/*****************************************************************************
 *                   SEGGER Microcontroller GmbH & Co. KG                    *
 *            Solutions for real time microcontroller applications           *
 *****************************************************************************
 *                                                                           *
 *               (c) 2017 SEGGER Microcontroller GmbH & Co. KG               *
 *                                                                           *
 *           Internet: www.segger.com   Support: support@segger.com          *
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 0

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak WWDG_IRQHandler
  .thumb_set WWDG_IRQHandler,Dummy_Handler

  .weak PVD_PVM_IRQHandler
  .thumb_set PVD_PVM_IRQHandler,Dummy_Handler

  .weak TAMP_STAMP_IRQHandler
  .thumb_set TAMP_STAMP_IRQHandler,Dummy_Handler

  .weak RTC_WKUP_IRQHandler
  .thumb_set RTC_WKUP_IRQHandler,Dummy_Handler

  .weak FLASH_IRQHandler
  .thumb_set FLASH_IRQHandler,Dummy_Handler

  .weak RCC_IRQHandler
  .thumb_set RCC_IRQHandler,Dummy_Handler

  .weak EXTI0_IRQHandler
  .thumb_set EXTI0_IRQHandler,Dummy_Handler

  .weak EXTI1_IRQHandler
  .thumb_set EXTI1_IRQHandler,Dummy_Handler

  .weak EXTI2_IRQHandler
  .thumb_set EXTI2_IRQHandler,Dummy_Handler

  .weak EXTI3_IRQHandler
  .thumb_set EXTI3_IRQHandler,Dummy_Handler

  .weak EXTI4_IRQHandler
  .thumb_set EXTI4_IRQHandler,Dummy_Handler

  .weak DMA1_CH1_IRQHandler
  .thumb_set DMA1_CH1_IRQHandler,Dummy_Handler

  .weak DMA1_CH2_IRQHandler
  .thumb_set DMA1_CH2_IRQHandler,Dummy_Handler

  .weak DMA1_CH3_IRQHandler
  .thumb_set DMA1_CH3_IRQHandler,Dummy_Handler

  .weak DMA1_CH4_IRQHandler
  .thumb_set DMA1_CH4_IRQHandler,Dummy_Handler

  .weak DMA1_CH5_IRQHandler
  .thumb_set DMA1_CH5_IRQHandler,Dummy_Handler

  .weak DMA1_CH6_IRQHandler
  .thumb_set DMA1_CH6_IRQHandler,Dummy_Handler

  .weak DMA1_CH7_IRQHandler
  .thumb_set DMA1_CH7_IRQHandler,Dummy_Handler

  .weak ADC1_IRQHandler
  .thumb_set ADC1_IRQHandler,Dummy_Handler

  .weak CAN1_TX_IRQHandler
  .thumb_set CAN1_TX_IRQHandler,Dummy_Handler

  .weak CAN1_RX0_IRQHandler
  .thumb_set CAN1_RX0_IRQHandler,Dummy_Handler

  .weak CAN1_RX1_IRQHandler
  .thumb_set CAN1_RX1_IRQHandler,Dummy_Handler

  .weak CAN1_SCE_IRQHandler
  .thumb_set CAN1_SCE_IRQHandler,Dummy_Handler

  .weak EXTI9_5_IRQHandler
  .thumb_set EXTI9_5_IRQHandler,Dummy_Handler

  .weak TIM1_BRK_TIM15_IRQHandler
  .thumb_set TIM1_BRK_TIM15_IRQHandler,Dummy_Handler

  .weak TIM1_UP_TIM16_IRQHandler
  .thumb_set TIM1_UP_TIM16_IRQHandler,Dummy_Handler

  .weak TIM1_TRG_COM_TIM17_IRQHandler
  .thumb_set TIM1_TRG_COM_TIM17_IRQHandler,Dummy_Handler

  .weak TIM1_CC_IRQHandler
  .thumb_set TIM1_CC_IRQHandler,Dummy_Handler

  .weak TIM2_IRQHandler
  .thumb_set TIM2_IRQHandler,Dummy_Handler

  .weak TIM3_IRQHandler
  .thumb_set TIM3_IRQHandler,Dummy_Handler

  .weak TIM4_IRQHandler
  .thumb_set TIM4_IRQHandler,Dummy_Handler

  .weak I2C1_EV_IRQHandler
  .thumb_set I2C1_EV_IRQHandler,Dummy_Handler

  .weak I2C1_ER_IRQHandler
  .thumb_set I2C1_ER_IRQHandler,Dummy_Handler

  .weak I2C2_EV_IRQHandler
  .thumb_set I2C2_EV_IRQHandler,Dummy_Handler

  .weak I2C2_ER_IRQHandler
  .thumb_set I2C2_ER_IRQHandler,Dummy_Handler

  .weak SPI1_IRQHandler
  .thumb_set SPI1_IRQHandler,Dummy_Handler

  .weak SPI2_IRQHandler
  .thumb_set SPI2_IRQHandler,Dummy_Handler

  .weak USART1_IRQHandler
  .thumb_set USART1_IRQHandler,Dummy_Handler

  .weak USART2_IRQHandler
  .thumb_set USART2_IRQHandler,Dummy_Handler

  .weak USART3_IRQHandler
  .thumb_set USART3_IRQHandler,Dummy_Handler

  .weak EXTI15_10_IRQHandler
  .thumb_set EXTI15_10_IRQHandler,Dummy_Handler

  .weak RTC_ALARM_IRQHandler
  .thumb_set RTC_ALARM_IRQHandler,Dummy_Handler

  .weak DFSDM1_FLT3_IRQHandler
  .thumb_set DFSDM1_FLT3_IRQHandler,Dummy_Handler

  .weak TIM8_BRK_IRQHandler
  .thumb_set TIM8_BRK_IRQHandler,Dummy_Handler

  .weak TIM8_UP_IRQHandler
  .thumb_set TIM8_UP_IRQHandler,Dummy_Handler

  .weak TIM8_TRG_COM_IRQHandler
  .thumb_set TIM8_TRG_COM_IRQHandler,Dummy_Handler

  .weak TIM8_CC_IRQHandler
  .thumb_set TIM8_CC_IRQHandler,Dummy_Handler

  .weak ADC3_IRQHandler
  .thumb_set ADC3_IRQHandler,Dummy_Handler

  .weak FMC_IRQHandler
  .thumb_set FMC_IRQHandler,Dummy_Handler

  .weak SDMMC1_IRQHandler
  .thumb_set SDMMC1_IRQHandler,Dummy_Handler

  .weak TIM5_IRQHandler
  .thumb_set TIM5_IRQHandler,Dummy_Handler

  .weak SPI3_IRQHandler
  .thumb_set SPI3_IRQHandler,Dummy_Handler

  .weak UART4_IRQHandler
  .thumb_set UART4_IRQHandler,Dummy_Handler

  .weak UART5_IRQHandler
  .thumb_set UART5_IRQHandler,Dummy_Handler

  .weak TIM6_DACUNDER_IRQHandler
  .thumb_set TIM6_DACUNDER_IRQHandler,Dummy_Handler

  .weak TIM7_IRQHandler
  .thumb_set TIM7_IRQHandler,Dummy_Handler

  .weak DMA2_CH1_IRQHandler
  .thumb_set DMA2_CH1_IRQHandler,Dummy_Handler

  .weak DMA2_CH2_IRQHandler
  .thumb_set DMA2_CH2_IRQHandler,Dummy_Handler

  .weak DMA2_CH3_IRQHandler
  .thumb_set DMA2_CH3_IRQHandler,Dummy_Handler

  .weak DMA2_CH4_IRQHandler
  .thumb_set DMA2_CH4_IRQHandler,Dummy_Handler

  .weak DMA2_CH5_IRQHandler
  .thumb_set DMA2_CH5_IRQHandler,Dummy_Handler

  .weak DFSDM1_FLT0_IRQHandler
  .thumb_set DFSDM1_FLT0_IRQHandler,Dummy_Handler

  .weak DFSDM1_FLT1_IRQHandler
  .thumb_set DFSDM1_FLT1_IRQHandler,Dummy_Handler

  .weak DFSDM1_FLT2_IRQHandler
  .thumb_set DFSDM1_FLT2_IRQHandler,Dummy_Handler

  .weak COMP_IRQHandler
  .thumb_set COMP_IRQHandler,Dummy_Handler

  .weak LPTIM1_IRQHandler
  .thumb_set LPTIM1_IRQHandler,Dummy_Handler

  .weak LPTIM2_IRQHandler
  .thumb_set LPTIM2_IRQHandler,Dummy_Handler

  .weak OTG_FS_IRQHandler
  .thumb_set OTG_FS_IRQHandler,Dummy_Handler

  .weak DMA2_CH6_IRQHandler
  .thumb_set DMA2_CH6_IRQHandler,Dummy_Handler

  .weak DMA2_CH7_IRQHandler
  .thumb_set DMA2_CH7_IRQHandler,Dummy_Handler

  .weak LPUART1_IRQHandler
  .thumb_set LPUART1_IRQHandler,Dummy_Handler

  .weak OCTOSPI1_IRQHandler
  .thumb_set OCTOSPI1_IRQHandler,Dummy_Handler

  .weak I2C3_EV_IRQHandler
  .thumb_set I2C3_EV_IRQHandler,Dummy_Handler

  .weak I2C3_ER_IRQHandler
  .thumb_set I2C3_ER_IRQHandler,Dummy_Handler

  .weak SAI1_IRQHandler
  .thumb_set SAI1_IRQHandler,Dummy_Handler

  .weak SAI2_IRQHandler
  .thumb_set SAI2_IRQHandler,Dummy_Handler

  .weak OCTOSPI2_IRQHandler
  .thumb_set OCTOSPI2_IRQHandler,Dummy_Handler

  .weak TSC_IRQHandler
  .thumb_set TSC_IRQHandler,Dummy_Handler

  .weak DSIHSOT_IRQHandler
  .thumb_set DSIHSOT_IRQHandler,Dummy_Handler

  .weak AES_IRQHandler
  .thumb_set AES_IRQHandler,Dummy_Handler

  .weak RNG_HASH_IRQHandler
  .thumb_set RNG_HASH_IRQHandler,Dummy_Handler

  .weak FPU_IRQHandler
  .thumb_set FPU_IRQHandler,Dummy_Handler

  .weak CRS_IRQHandler
  .thumb_set CRS_IRQHandler,Dummy_Handler

  .weak I2C4_ER_IRQHandler
  .thumb_set I2C4_ER_IRQHandler,Dummy_Handler

  .weak I2C4_EV_IRQHandler
  .thumb_set I2C4_EV_IRQHandler,Dummy_Handler

  .weak DCMI_IRQHandler
  .thumb_set DCMI_IRQHandler,Dummy_Handler

  .weak DMA2D_IRQHandler
  .thumb_set DMA2D_IRQHandler,Dummy_Handler

  .weak LCD_TFT_IRQHandler
  .thumb_set LCD_TFT_IRQHandler,Dummy_Handler

  .weak LCD_TFT_ER_IRQHandler
  .thumb_set LCD_TFT_ER_IRQHandler,Dummy_Handler

  .weak GFXMMU_IRQHandler
  .thumb_set GFXMMU_IRQHandler,Dummy_Handler

  .weak DMAMUX_OVR_IRQHandler
  .thumb_set DMAMUX_OVR_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak WWDG_IRQHandler
WWDG_IRQHandler:
  b .

  .thumb_func
  .weak PVD_PVM_IRQHandler
PVD_PVM_IRQHandler:
  b .

  .thumb_func
  .weak TAMP_STAMP_IRQHandler
TAMP_STAMP_IRQHandler:
  b .

  .thumb_func
  .weak RTC_WKUP_IRQHandler
RTC_WKUP_IRQHandler:
  b .

  .thumb_func
  .weak FLASH_IRQHandler
FLASH_IRQHandler:
  b .

  .thumb_func
  .weak RCC_IRQHandler
RCC_IRQHandler:
  b .

  .thumb_func
  .weak EXTI0_IRQHandler
EXTI0_IRQHandler:
  b .

  .thumb_func
  .weak EXTI1_IRQHandler
EXTI1_IRQHandler:
  b .

  .thumb_func
  .weak EXTI2_IRQHandler
EXTI2_IRQHandler:
  b .

  .thumb_func
  .weak EXTI3_IRQHandler
EXTI3_IRQHandler:
  b .

  .thumb_func
  .weak EXTI4_IRQHandler
EXTI4_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH1_IRQHandler
DMA1_CH1_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH2_IRQHandler
DMA1_CH2_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH3_IRQHandler
DMA1_CH3_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH4_IRQHandler
DMA1_CH4_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH5_IRQHandler
DMA1_CH5_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH6_IRQHandler
DMA1_CH6_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH7_IRQHandler
DMA1_CH7_IRQHandler:
  b .

  .thumb_func
  .weak ADC1_IRQHandler
ADC1_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_TX_IRQHandler
CAN1_TX_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_RX0_IRQHandler
CAN1_RX0_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_RX1_IRQHandler
CAN1_RX1_IRQHandler:
  b .

  .thumb_func
  .weak CAN1_SCE_IRQHandler
CAN1_SCE_IRQHandler:
  b .

  .thumb_func
  .weak EXTI9_5_IRQHandler
EXTI9_5_IRQHandler:
  b .

  .thumb_func
  .weak TIM1_BRK_TIM15_IRQHandler
TIM1_BRK_TIM15_IRQHandler:
  b .

  .thumb_func
  .weak TIM1_UP_TIM16_IRQHandler
TIM1_UP_TIM16_IRQHandler:
  b .

  .thumb_func
  .weak TIM1_TRG_COM_TIM17_IRQHandler
TIM1_TRG_COM_TIM17_IRQHandler:
  b .

  .thumb_func
  .weak TIM1_CC_IRQHandler
TIM1_CC_IRQHandler:
  b .

  .thumb_func
  .weak TIM2_IRQHandler
TIM2_IRQHandler:
  b .

  .thumb_func
  .weak TIM3_IRQHandler
TIM3_IRQHandler:
  b .

  .thumb_func
  .weak TIM4_IRQHandler
TIM4_IRQHandler:
  b .

  .thumb_func
  .weak I2C1_EV_IRQHandler
I2C1_EV_IRQHandler:
  b .

  .thumb_func
  .weak I2C1_ER_IRQHandler
I2C1_ER_IRQHandler:
  b .

  .thumb_func
  .weak I2C2_EV_IRQHandler
I2C2_EV_IRQHandler:
  b .

  .thumb_func
  .weak I2C2_ER_IRQHandler
I2C2_ER_IRQHandler:
  b .

  .thumb_func
  .weak SPI1_IRQHandler
SPI1_IRQHandler:
  b .

  .thumb_func
  .weak SPI2_IRQHandler
SPI2_IRQHandler:
  b .

  .thumb_func
  .weak USART1_IRQHandler
USART1_IRQHandler:
  b .

  .thumb_func
  .weak USART2_IRQHandler
USART2_IRQHandler:
  b .

  .thumb_func
  .weak USART3_IRQHandler
USART3_IRQHandler:
  b .

  .thumb_func
  .weak EXTI15_10_IRQHandler
EXTI15_10_IRQHandler:
  b .

  .thumb_func
  .weak RTC_ALARM_IRQHandler
RTC_ALARM_IRQHandler:
  b .

  .thumb_func
  .weak DFSDM1_FLT3_IRQHandler
DFSDM1_FLT3_IRQHandler:
  b .

  .thumb_func
  .weak TIM8_BRK_IRQHandler
TIM8_BRK_IRQHandler:
  b .

  .thumb_func
  .weak TIM8_UP_IRQHandler
TIM8_UP_IRQHandler:
  b .

  .thumb_func
  .weak TIM8_TRG_COM_IRQHandler
TIM8_TRG_COM_IRQHandler:
  b .

  .thumb_func
  .weak TIM8_CC_IRQHandler
TIM8_CC_IRQHandler:
  b .

  .thumb_func
  .weak ADC3_IRQHandler
ADC3_IRQHandler:
  b .

  .thumb_func
  .weak FMC_IRQHandler
FMC_IRQHandler:
  b .

  .thumb_func
  .weak SDMMC1_IRQHandler
SDMMC1_IRQHandler:
  b .

  .thumb_func
  .weak TIM5_IRQHandler
TIM5_IRQHandler:
  b .

  .thumb_func
  .weak SPI3_IRQHandler
SPI3_IRQHandler:
  b .

  .thumb_func
  .weak UART4_IRQHandler
UART4_IRQHandler:
  b .

  .thumb_func
  .weak UART5_IRQHandler
UART5_IRQHandler:
  b .

  .thumb_func
  .weak TIM6_DACUNDER_IRQHandler
TIM6_DACUNDER_IRQHandler:
  b .

  .thumb_func
  .weak TIM7_IRQHandler
TIM7_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH1_IRQHandler
DMA2_CH1_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH2_IRQHandler
DMA2_CH2_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH3_IRQHandler
DMA2_CH3_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH4_IRQHandler
DMA2_CH4_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH5_IRQHandler
DMA2_CH5_IRQHandler:
  b .

  .thumb_func
  .weak DFSDM1_FLT0_IRQHandler
DFSDM1_FLT0_IRQHandler:
  b .

  .thumb_func
  .weak DFSDM1_FLT1_IRQHandler
DFSDM1_FLT1_IRQHandler:
  b .

  .thumb_func
  .weak DFSDM1_FLT2_IRQHandler
DFSDM1_FLT2_IRQHandler:
  b .

  .thumb_func
  .weak COMP_IRQHandler
COMP_IRQHandler:
  b .

  .thumb_func
  .weak LPTIM1_IRQHandler
LPTIM1_IRQHandler:
  b .

  .thumb_func
  .weak LPTIM2_IRQHandler
LPTIM2_IRQHandler:
  b .

  .thumb_func
  .weak OTG_FS_IRQHandler
OTG_FS_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH6_IRQHandler
DMA2_CH6_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH7_IRQHandler
DMA2_CH7_IRQHandler:
  b .

  .thumb_func
  .weak LPUART1_IRQHandler
LPUART1_IRQHandler:
  b .

  .thumb_func
  .weak OCTOSPI1_IRQHandler
OCTOSPI1_IRQHandler:
  b .

  .thumb_func
  .weak I2C3_EV_IRQHandler
I2C3_EV_IRQHandler:
  b .

  .thumb_func
  .weak I2C3_ER_IRQHandler
I2C3_ER_IRQHandler:
  b .

  .thumb_func
  .weak SAI1_IRQHandler
SAI1_IRQHandler:
  b .

  .thumb_func
  .weak SAI2_IRQHandler
SAI2_IRQHandler:
  b .

  .thumb_func
  .weak OCTOSPI2_IRQHandler
OCTOSPI2_IRQHandler:
  b .

  .thumb_func
  .weak TSC_IRQHandler
TSC_IRQHandler:
  b .

  .thumb_func
  .weak DSIHSOT_IRQHandler
DSIHSOT_IRQHandler:
  b .

  .thumb_func
  .weak AES_IRQHandler
AES_IRQHandler:
  b .

  .thumb_func
  .weak RNG_HASH_IRQHandler
RNG_HASH_IRQHandler:
  b .

  .thumb_func
  .weak FPU_IRQHandler
FPU_IRQHandler:
  b .

  .thumb_func
  .weak CRS_IRQHandler
CRS_IRQHandler:
  b .

  .thumb_func
  .weak I2C4_ER_IRQHandler
I2C4_ER_IRQHandler:
  b .

  .thumb_func
  .weak I2C4_EV_IRQHandler
I2C4_EV_IRQHandler:
  b .

  .thumb_func
  .weak DCMI_IRQHandler
DCMI_IRQHandler:
  b .

  .thumb_func
  .weak DMA2D_IRQHandler
DMA2D_IRQHandler:
  b .

  .thumb_func
  .weak LCD_TFT_IRQHandler
LCD_TFT_IRQHandler:
  b .

  .thumb_func
  .weak LCD_TFT_ER_IRQHandler
LCD_TFT_ER_IRQHandler:
  b .

  .thumb_func
  .weak GFXMMU_IRQHandler
GFXMMU_IRQHandler:
  b .

  .thumb_func
  .weak DMAMUX_OVR_IRQHandler
DMAMUX_OVR_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .align 0
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word WWDG_IRQHandler
  .word PVD_PVM_IRQHandler
  .word TAMP_STAMP_IRQHandler
  .word RTC_WKUP_IRQHandler
  .word FLASH_IRQHandler
  .word RCC_IRQHandler
  .word EXTI0_IRQHandler
  .word EXTI1_IRQHandler
  .word EXTI2_IRQHandler
  .word EXTI3_IRQHandler
  .word EXTI4_IRQHandler
  .word DMA1_CH1_IRQHandler
  .word DMA1_CH2_IRQHandler
  .word DMA1_CH3_IRQHandler
  .word DMA1_CH4_IRQHandler
  .word DMA1_CH5_IRQHandler
  .word DMA1_CH6_IRQHandler
  .word DMA1_CH7_IRQHandler
  .word ADC1_IRQHandler
  .word CAN1_TX_IRQHandler
  .word CAN1_RX0_IRQHandler
  .word CAN1_RX1_IRQHandler
  .word CAN1_SCE_IRQHandler
  .word EXTI9_5_IRQHandler
  .word TIM1_BRK_TIM15_IRQHandler
  .word TIM1_UP_TIM16_IRQHandler
  .word TIM1_TRG_COM_TIM17_IRQHandler
  .word TIM1_CC_IRQHandler
  .word TIM2_IRQHandler
  .word TIM3_IRQHandler
  .word TIM4_IRQHandler
  .word I2C1_EV_IRQHandler
  .word I2C1_ER_IRQHandler
  .word I2C2_EV_IRQHandler
  .word I2C2_ER_IRQHandler
  .word SPI1_IRQHandler
  .word SPI2_IRQHandler
  .word USART1_IRQHandler
  .word USART2_IRQHandler
  .word USART3_IRQHandler
  .word EXTI15_10_IRQHandler
  .word RTC_ALARM_IRQHandler
  .word DFSDM1_FLT3_IRQHandler
  .word TIM8_BRK_IRQHandler
  .word TIM8_UP_IRQHandler
  .word TIM8_TRG_COM_IRQHandler
  .word TIM8_CC_IRQHandler
  .word ADC3_IRQHandler
  .word FMC_IRQHandler
  .word SDMMC1_IRQHandler
  .word TIM5_IRQHandler
  .word SPI3_IRQHandler
  .word UART4_IRQHandler
  .word UART5_IRQHandler
  .word TIM6_DACUNDER_IRQHandler
  .word TIM7_IRQHandler
  .word DMA2_CH1_IRQHandler
  .word DMA2_CH2_IRQHandler
  .word DMA2_CH3_IRQHandler
  .word DMA2_CH4_IRQHandler
  .word DMA2_CH5_IRQHandler
  .word DFSDM1_FLT0_IRQHandler
  .word DFSDM1_FLT1_IRQHandler
  .word DFSDM1_FLT2_IRQHandler
  .word COMP_IRQHandler
  .word LPTIM1_IRQHandler
  .word LPTIM2_IRQHandler
  .word OTG_FS_IRQHandler
  .word DMA2_CH6_IRQHandler
  .word DMA2_CH7_IRQHandler
  .word LPUART1_IRQHandler
  .word OCTOSPI1_IRQHandler
  .word I2C3_EV_IRQHandler
  .word I2C3_ER_IRQHandler
  .word SAI1_IRQHandler
  .word SAI2_IRQHandler
  .word OCTOSPI2_IRQHandler
  .word TSC_IRQHandler
  .word DSIHSOT_IRQHandler
  .word AES_IRQHandler
  .word RNG_HASH_IRQHandler
  .word FPU_IRQHandler
  .word CRS_IRQHandler
  .word I2C4_ER_IRQHandler
  .word I2C4_EV_IRQHandler
  .word DCMI_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word DMA2D_IRQHandler
  .word LCD_TFT_IRQHandler
  .word LCD_TFT_ER_IRQHandler
  .word GFXMMU_IRQHandler
  .word DMAMUX_OVR_IRQHandler
_vectors_end:

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .align 0
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
