/*********************************************************************
*               SEGGER MICROCONTROLLER GmbH & Co. KG                 *
*       Solutions for real time microcontroller applications         *
**********************************************************************
*                                                                    *
*       (c) 2014 - 2018  SEGGER Microcontroller GmbH                 *
*                                                                    *
*       www.segger.com     Support: support@segger.com               *
*                                                                    *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------

File    : main.c
Purpose : Generic application start
*/

#include <stdio.h>
#include <stdlib.h>
#include "stm32h7xx.h"

/*********************************************************************
*
*       __putchar()
*
*  Function description
*   Overwrites default ES putchar handler to support SWO
*/
int __putchar(int x, __printf_tag_ptr ptr)
{
    return ITM_SendChar(x);
}

/*********************************************************************
*
*       main()
*
*  Function description
*   Application entry point.
*/
void main(void) {
  int i;

  
  do {
    for (i = 0; i < 100; i++) {
      printf("Hello World %d!\n", i);
    }
  } while (1);
}

/*************************** End of file ****************************/
