/*********************************************************************
*                    SEGGER Microcontroller GmbH                     *
*                        The Embedded Experts                        *
**********************************************************************
*                                                                    *
*            (c) 2014 - 2019 SEGGER Microcontroller GmbH             *
*                                                                    *
*           www.segger.com     Support: support@segger.com           *
*                                                                    *
**********************************************************************
*                                                                    *
* All rights reserved.                                               *
*                                                                    *
* Redistribution and use in source and binary forms, with or         *
* without modification, are permitted provided that the following    *
* conditions are met:                                                *
*                                                                    *
* - Redistributions of source code must retain the above copyright   *
*   notice, this list of conditions and the following disclaimer.    *
*                                                                    *
* - Neither the name of SEGGER Microcontroller GmbH                  *
*   nor the names of its contributors may be used to endorse or      *
*   promote products derived from this software without specific     *
*   prior written permission.                                        *
*                                                                    *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND             *
* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,        *
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF           *
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE           *
* DISCLAIMED.                                                        *
* IN NO EVENT SHALL SEGGER Microcontroller GmbH BE LIABLE FOR        *
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR           *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT  *
* OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;    *
* OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      *
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT          *
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE  *
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH   *
* DAMAGE.                                                            *
*                                                                    *
*********************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 2

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak EMU_IRQHandler
  .thumb_set EMU_IRQHandler,Dummy_Handler

  .weak WDOG0_IRQHandler
  .thumb_set WDOG0_IRQHandler,Dummy_Handler

  .weak LDMA_IRQHandler
  .thumb_set LDMA_IRQHandler,Dummy_Handler

  .weak GPIO_EVEN_IRQHandler
  .thumb_set GPIO_EVEN_IRQHandler,Dummy_Handler

  .weak SMU_IRQHandler
  .thumb_set SMU_IRQHandler,Dummy_Handler

  .weak TIMER0_IRQHandler
  .thumb_set TIMER0_IRQHandler,Dummy_Handler

  .weak USART0_IRQHandler
  .thumb_set USART0_IRQHandler,Dummy_Handler

  .weak ACMP0_IRQHandler
  .thumb_set ACMP0_IRQHandler,Dummy_Handler

  .weak ADC0_IRQHandler
  .thumb_set ADC0_IRQHandler,Dummy_Handler

  .weak I2C0_IRQHandler
  .thumb_set I2C0_IRQHandler,Dummy_Handler

  .weak I2C1_IRQHandler
  .thumb_set I2C1_IRQHandler,Dummy_Handler

  .weak GPIO_ODD_IRQHandler
  .thumb_set GPIO_ODD_IRQHandler,Dummy_Handler

  .weak TIMER1_IRQHandler
  .thumb_set TIMER1_IRQHandler,Dummy_Handler

  .weak USART1_IRQHandler
  .thumb_set USART1_IRQHandler,Dummy_Handler

  .weak USART2_IRQHandler
  .thumb_set USART2_IRQHandler,Dummy_Handler

  .weak UART0_IRQHandler
  .thumb_set UART0_IRQHandler,Dummy_Handler

  .weak LEUART0_IRQHandler
  .thumb_set LEUART0_IRQHandler,Dummy_Handler

  .weak LETIMER0_IRQHandler
  .thumb_set LETIMER0_IRQHandler,Dummy_Handler

  .weak PCNT0_IRQHandler
  .thumb_set PCNT0_IRQHandler,Dummy_Handler

  .weak RTCC_IRQHandler
  .thumb_set RTCC_IRQHandler,Dummy_Handler

  .weak CMU_IRQHandler
  .thumb_set CMU_IRQHandler,Dummy_Handler

  .weak MSC_IRQHandler
  .thumb_set MSC_IRQHandler,Dummy_Handler

  .weak CRYPTO0_IRQHandler
  .thumb_set CRYPTO0_IRQHandler,Dummy_Handler

  .weak CRYOTIMER_IRQHandler
  .thumb_set CRYOTIMER_IRQHandler,Dummy_Handler

  .weak USART3_IRQHandler
  .thumb_set USART3_IRQHandler,Dummy_Handler

  .weak WTIMER0_IRQHandler
  .thumb_set WTIMER0_IRQHandler,Dummy_Handler

  .weak WTIMER1_IRQHandler
  .thumb_set WTIMER1_IRQHandler,Dummy_Handler

  .weak VDAC0_IRQHandler
  .thumb_set VDAC0_IRQHandler,Dummy_Handler

  .weak CSEN_IRQHandler
  .thumb_set CSEN_IRQHandler,Dummy_Handler

  .weak LESENSE_IRQHandler
  .thumb_set LESENSE_IRQHandler,Dummy_Handler

  .weak LCD_IRQHandler
  .thumb_set LCD_IRQHandler,Dummy_Handler

  .weak CAN0_IRQHandler
  .thumb_set CAN0_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak EMU_IRQHandler
EMU_IRQHandler:
  b .

  .thumb_func
  .weak WDOG0_IRQHandler
WDOG0_IRQHandler:
  b .

  .thumb_func
  .weak LDMA_IRQHandler
LDMA_IRQHandler:
  b .

  .thumb_func
  .weak GPIO_EVEN_IRQHandler
GPIO_EVEN_IRQHandler:
  b .

  .thumb_func
  .weak SMU_IRQHandler
SMU_IRQHandler:
  b .

  .thumb_func
  .weak TIMER0_IRQHandler
TIMER0_IRQHandler:
  b .

  .thumb_func
  .weak USART0_IRQHandler
USART0_IRQHandler:
  b .

  .thumb_func
  .weak ACMP0_IRQHandler
ACMP0_IRQHandler:
  b .

  .thumb_func
  .weak ADC0_IRQHandler
ADC0_IRQHandler:
  b .

  .thumb_func
  .weak I2C0_IRQHandler
I2C0_IRQHandler:
  b .

  .thumb_func
  .weak I2C1_IRQHandler
I2C1_IRQHandler:
  b .

  .thumb_func
  .weak GPIO_ODD_IRQHandler
GPIO_ODD_IRQHandler:
  b .

  .thumb_func
  .weak TIMER1_IRQHandler
TIMER1_IRQHandler:
  b .

  .thumb_func
  .weak USART1_IRQHandler
USART1_IRQHandler:
  b .

  .thumb_func
  .weak USART2_IRQHandler
USART2_IRQHandler:
  b .

  .thumb_func
  .weak UART0_IRQHandler
UART0_IRQHandler:
  b .

  .thumb_func
  .weak LEUART0_IRQHandler
LEUART0_IRQHandler:
  b .

  .thumb_func
  .weak LETIMER0_IRQHandler
LETIMER0_IRQHandler:
  b .

  .thumb_func
  .weak PCNT0_IRQHandler
PCNT0_IRQHandler:
  b .

  .thumb_func
  .weak RTCC_IRQHandler
RTCC_IRQHandler:
  b .

  .thumb_func
  .weak CMU_IRQHandler
CMU_IRQHandler:
  b .

  .thumb_func
  .weak MSC_IRQHandler
MSC_IRQHandler:
  b .

  .thumb_func
  .weak CRYPTO0_IRQHandler
CRYPTO0_IRQHandler:
  b .

  .thumb_func
  .weak CRYOTIMER_IRQHandler
CRYOTIMER_IRQHandler:
  b .

  .thumb_func
  .weak USART3_IRQHandler
USART3_IRQHandler:
  b .

  .thumb_func
  .weak WTIMER0_IRQHandler
WTIMER0_IRQHandler:
  b .

  .thumb_func
  .weak WTIMER1_IRQHandler
WTIMER1_IRQHandler:
  b .

  .thumb_func
  .weak VDAC0_IRQHandler
VDAC0_IRQHandler:
  b .

  .thumb_func
  .weak CSEN_IRQHandler
CSEN_IRQHandler:
  b .

  .thumb_func
  .weak LESENSE_IRQHandler
LESENSE_IRQHandler:
  b .

  .thumb_func
  .weak LCD_IRQHandler
LCD_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_IRQHandler
CAN0_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .balign 256
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word EMU_IRQHandler
  .word WDOG0_IRQHandler
  .word LDMA_IRQHandler
  .word GPIO_EVEN_IRQHandler
  .word SMU_IRQHandler
  .word TIMER0_IRQHandler
  .word USART0_IRQHandler
  .word ACMP0_IRQHandler
  .word ADC0_IRQHandler
  .word I2C0_IRQHandler
  .word I2C1_IRQHandler
  .word GPIO_ODD_IRQHandler
  .word TIMER1_IRQHandler
  .word USART1_IRQHandler
  .word USART2_IRQHandler
  .word UART0_IRQHandler
  .word LEUART0_IRQHandler
  .word LETIMER0_IRQHandler
  .word PCNT0_IRQHandler
  .word RTCC_IRQHandler
  .word CMU_IRQHandler
  .word MSC_IRQHandler
  .word CRYPTO0_IRQHandler
  .word CRYOTIMER_IRQHandler
  .word USART3_IRQHandler
  .word WTIMER0_IRQHandler
  .word WTIMER1_IRQHandler
  .word VDAC0_IRQHandler
  .word CSEN_IRQHandler
  .word LESENSE_IRQHandler
  .word LCD_IRQHandler
  .word CAN0_IRQHandler
_vectors_end:

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .balign 256
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
