/*
* File    : OS_StartLEDBlink.c
* Purpose : FreeRTOS sample program running two simple tasks, each toggling
*           an LED of the target hardware (as configured in BSP.c).
*/

#include "FreeRTOS.h"
#include "task.h"
#include "BSP.h"


static void HPTask(void *pvParameters) {
  (void)pvParameters;

  while (1) {
    BSP_ToggleLED(0);
    vTaskDelay(50);
  }
}

static void LPTask(void *pvParameters) {
  (void)pvParameters;

  while (1) {
    BSP_ToggleLED(1);
    vTaskDelay(200);
  }
}

/*********************************************************************
*
*       main()
*/
int main(void) {
  BSP_Init();   // Initialize LED ports
  xTaskCreate( HPTask, "HP Task", configMINIMAL_STACK_SIZE, NULL, 1,	NULL );
  xTaskCreate( LPTask, "LP Task", configMINIMAL_STACK_SIZE, NULL, 1,	NULL );
  vTaskStartScheduler();
  return 0;
}

/*************************** End of file ****************************/
