/**********************************************************
*          SEGGER MICROCONTROLLER SYSTEME GmbH
*   Solutions for real time microcontroller applications
***********************************************************
File    : main.h
Purpose : Global header
--------- END-OF-HEADER ---------------------------------*/

#ifndef MAIN_H
#define MAIN_H


#ifdef __cplusplus
  extern "C" {
#endif /* __cplusplus */

#include <stdlib.h>
#include <stdarg.h>
#include "RTOS.h"
#include "Global.h"

typedef void UART_ON_RX_FUNC(U8 Data);
typedef int  UART_ON_TX_FUNC(U8* pChar);

typedef UART_ON_TX_FUNC* UART_ON_TX_FUNC_P;
typedef UART_ON_RX_FUNC* UART_ON_RX_FUNC_P;

void HIF_UART_Init                (U32 Baudrate, UART_ON_TX_FUNC_P cbOnTx, UART_ON_RX_FUNC_P cbOnRx);           // Initialize UART, enable UART interrupts
void HIF_UART_EnableTXEInterrupt  (void);
void HIF_UART_WaitForTxEnd        (void);


#ifdef __cplusplus
  }
#endif /* __cplusplus */
#endif  /* defined MAIN_H */

/****** EOF *********************************************************/
