/*
** ###################################################################
**     Processor:           MIMXRT595SFFOA_dsp
**     Compiler:            XCC Compiler
**     Reference manual:    RT500 Reference Manual. Rev.0,09/2019
**     Version:             rev. 2.0, 2019-07-22
**     Build:               b190918
**
**     Abstract:
**         CMSIS Peripheral Access Layer for MIMXRT595S_dsp
**
**     Copyright 1997-2016 Freescale Semiconductor, Inc.
**     Copyright 2016-2019 NXP
**     All rights reserved.
**
**     SPDX-License-Identifier: BSD-3-Clause
**
**     http:                 www.nxp.com
**     mail:                 support@nxp.com
**
**     Revisions:
**     - rev. 1.0 (2019-04-19)
**         Initial version.
**     - rev. 2.0 (2019-07-22)
**         Base on rev 0.7 RM.
**
** ###################################################################
*/

/*!
 * @file MIMXRT595S_dsp.h
 * @version 2.0
 * @date 2019-07-22
 * @brief CMSIS Peripheral Access Layer for MIMXRT595S_dsp
 *
 * CMSIS Peripheral Access Layer for MIMXRT595S_dsp
 */

#ifndef _MIMXRT595S_DSP_H_
#define _MIMXRT595S_DSP_H_                       /**< Symbol preventing repeated inclusion */

/** Memory map major version (memory maps with equal major version number are
 * compatible) */
#define MCU_MEM_MAP_VERSION 0x0200U
/** Memory map minor version */
#define MCU_MEM_MAP_VERSION_MINOR 0x0000U


/* ----------------------------------------------------------------------------
   -- Interrupt vector numbers
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Interrupt_vector_numbers Interrupt vector numbers
 * @{
 */

/** Interrupt Number Definitions */
#define NUMBER_OF_INT_VECTORS 46                 /**< Number of interrupts in the Vector table */

typedef enum IRQn {
  /* Auxiliary constants */
  NotAvail_IRQn                = -128,             /**< Not available device specific interrupt */

  /* Core interrupts */
  NonMaskableInt_IRQn          = -5,               /**< SysIRQ, Non Maskable Interrupt */
  Software_IRQn                = -4,               /**< Software triggered Interrupt */
  RtosTimer0_IRQn              = -3,               /**< Internal RTOS Timer0 Interrupt */
  RtosTimer1_IRQn              = -2,               /**< Internal RTOS Timer1 Interrupt */
  Profiling_IRQn               = -1,               /**< Profiling Interrupt */

  /* Device specific interrupts */
  FLEXCOMM0_IRQn               = 0,                /**< Flexcomm Interface 0 (USART, SPI, I2C, I2S) */
  FLEXCOMM1_IRQn               = 1,                /**< Flexcomm Interface 1 (USART, SPI, I2C, I2S) */
  FLEXCOMM2_IRQn               = 2,                /**< Flexcomm Interface 2 (USART, SPI, I2C, I2S) */
  FLEXCOMM3_IRQn               = 3,                /**< Flexcomm Interface 3 (USART, SPI, I2C, I2S) */
  FLEXCOMM4_IRQn               = 4,                /**< Flexcomm Interface 4 (USART, SPI, I2C, I2S) */
  FLEXCOMM5_IRQn               = 5,                /**< Flexcomm Interface 5 (USART, SPI, I2C, I2S) */
  FLEXCOMM6_IRQn               = 6,                /**< Flexcomm Interface 6 (USART, SPI, I2C, I3S) */
  FLEXCOMM7_IRQn               = 7,                /**< Flexcomm Interface 7 (USART, SPI, I2C, I4S) */
  FLEXCOMM14_IRQn              = 8,                /**< Flexcomm Interface 14 (USART, SPI, I2C, I5S) */
  FLEXCOMM16_IRQn              = 9,                /**< Flexcomm Interface 16 (USART, SPI, I2C, I6S) */
  PIN_INT0_IRQn                = 10,               /**< Pin interrupt 0 or pattern match engine slice 0 int */
  PIN_INT1_IRQn                = 11,               /**< Pin interrupt 1 or pattern match engine slice 1 int */
  PIN_INT2_IRQn                = 12,               /**< Pin interrupt 2 or pattern match engine slice 2 int */
  PIN_INT3_IRQn                = 13,               /**< Pin interrupt 3 or pattern match engine slice 3 int */
  PIN_INT4_IRQn                = 14,               /**< Pin interrupt 4 or pattern match engine slice 4 int */
  PIN_INT5_IRQn                = 15,               /**< Pin interrupt 5 or pattern match engine slice 5 int */
  PIN_INT6_IRQn                = 16,               /**< Pin interrupt 6 or pattern match engine slice 6 int */
  PIN_INT7_IRQn                = 17,               /**< Pin interrupt 7 or pattern match engine slice 7 int */
  GPIO_INTA_IRQn               = 18,               /**< GPIO interrupt A */
  GPIO_INTB_IRQn               = 19,               /**< GPIO interrupt B */
  WDT1_IRQn                    = 20,               /**< Windowed watchdog timer 1 */
  DMA0_IRQn                    = 21,               /**< DMA controller 0 (secure or CM33 DMA) */
  DMA1_IRQn                    = 22,               /**< DMA controller 1 (non-secure or DSP DMA) */
  MU_B_IRQn                    = 23,               /**< Messaging Unit interrupt */
  UTICK0_IRQn                  = 24,               /**< Micro-tick Timer */
  MRT0_IRQn                    = 25,               /**< Multi-Rate Timer */
  OS_EVENT_IRQn                = 26,               /**< OS event timer */
  CTIMER0_IRQn                 = 27,               /**< Standard counter/timer CTIMER0 */
  CTIMER1_IRQn                 = 28,               /**< Standard counter/timer CTIMER1 */
  CTIMER2_IRQn                 = 29,               /**< Standard counter/timer CTIMER2 */
  CTIMER3_IRQn                 = 30,               /**< Standard counter/timer CTIMER3 */
  CTIMER4_IRQn                 = 31,               /**< Standard counter/timer CTIMER4 */
  RTC_IRQn                     = 32,               /**< RTC alarm and wake-up */
  I3C0_IRQn                    = 33,               /**< I3C interface 0 */
  I3C1_IRQn                    = 34,               /**< I3C interface 1 */
  DMIC0_IRQn                   = 35,               /**< Digital microphone and DMIC subsystem */
  HWVAD_IRQn                   = 36,               /**< Hardware Voice Activity Detector */
  LCDIF_IRQn                   = 37,               /**< Liquid Crystal Display Interface interrupt */
  GPU_IRQn                     = 38,               /**< Graphics Processor Unit interrupt */
  SMARTDMA_IRQn                = 39,               /**< Smart DMA Controller interrupt */
  FLEXIO_IRQn                  = 40                /**< Flexible IO interrupt */
} IRQn_Type;

/*!
 * @}
 */ /* end of group Interrupt_vector_numbers */

#include "core_dsp.h"                  /* Core Peripheral Access Layer */
#include "system_MIMXRT595S_dsp.h"     /* Device specific configuration file */

/* ----------------------------------------------------------------------------
   -- Device Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup Peripheral_access_layer Device Peripheral Access Layer
 * @{
 */


/*
** Start of section using anonymous unions
*/

#if defined(__XCC__)
  /* anonymous unions are enabled by default */
#else
  #error Not supported compiler type
#endif

/* ----------------------------------------------------------------------------
   -- ADC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Peripheral_Access_Layer ADC Peripheral Access Layer
 * @{
 */

/** ADC - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
       uint8_t RESERVED_0[8];
  __IO uint32_t CTRL;                              /**< ADC Control Register, offset: 0x10 */
  __IO uint32_t STAT;                              /**< ADC Status Register, offset: 0x14 */
  __IO uint32_t IE;                                /**< Interrupt Enable Register, offset: 0x18 */
  __IO uint32_t DE;                                /**< DMA Enable Register, offset: 0x1C */
  __IO uint32_t CFG;                               /**< ADC Configuration Register, offset: 0x20 */
  __IO uint32_t PAUSE;                             /**< ADC Pause Register, offset: 0x24 */
       uint8_t RESERVED_1[12];
  __O  uint32_t SWTRIG;                            /**< Software Trigger Register, offset: 0x34 */
  __IO uint32_t TSTAT;                             /**< Trigger Status Register, offset: 0x38 */
       uint8_t RESERVED_2[100];
  __IO uint32_t TCTRL[16];                         /**< Trigger Control Register, array offset: 0xA0, array step: 0x4 */
  __IO uint32_t FCTRL[2];                          /**< FIFO Control Register, array offset: 0xE0, array step: 0x4 */
       uint8_t RESERVED_3[24];
  struct {                                         /* offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDL;                              /**< ADC Command Low Buffer Register, array offset: 0x100, array step: 0x8 */
    __IO uint32_t CMDH;                              /**< ADC Command High Buffer Register, array offset: 0x104, array step: 0x8 */
  } CMD[15];
       uint8_t RESERVED_4[136];
  __IO uint32_t CV[4];                             /**< Compare Value Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_5[240];
  __I  uint32_t RESFIFO[2];                        /**< ADC Data Result FIFO Register, array offset: 0x300, array step: 0x4 */
} ADC_Type;

/* ----------------------------------------------------------------------------
   -- ADC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup ADC_Register_Masks ADC Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */
#define ADC_VERID_RES_MASK                       (0x1U)
#define ADC_VERID_RES_SHIFT                      (0U)
/*! RES - Resolution
 *  0b0..Up to 13-bit differential/12-bit single ended resolution supported.
 *  0b1..Up to 16-bit differential/15-bit single ended resolution supported.
 */
#define ADC_VERID_RES(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_RES_SHIFT)) & ADC_VERID_RES_MASK)
#define ADC_VERID_DIFFEN_MASK                    (0x2U)
#define ADC_VERID_DIFFEN_SHIFT                   (1U)
/*! DIFFEN - Differential Supported
 *  0b0..Differential operation not supported.
 *  0b1..Differential operation supported. CMDLa[DIFF] and CMDLa[ABSEL] control fields implemented.
 */
#define ADC_VERID_DIFFEN(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_DIFFEN_SHIFT)) & ADC_VERID_DIFFEN_MASK)
#define ADC_VERID_MVI_MASK                       (0x8U)
#define ADC_VERID_MVI_SHIFT                      (3U)
/*! MVI - Multi Vref Implemented
 *  0b0..Single voltage reference high (VREFH) input supported.
 *  0b1..Multiple voltage reference high (VREFH) inputs supported.
 */
#define ADC_VERID_MVI(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MVI_SHIFT)) & ADC_VERID_MVI_MASK)
#define ADC_VERID_CSW_MASK                       (0x70U)
#define ADC_VERID_CSW_SHIFT                      (4U)
/*! CSW - Channel Scale Width
 *  0b000..Channel scaling not supported.
 *  0b001..Channel scaling supported. 1-bit CSCALE control field.
 *  0b110..Channel scaling supported. 6-bit CSCALE control field.
 */
#define ADC_VERID_CSW(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CSW_SHIFT)) & ADC_VERID_CSW_MASK)
#define ADC_VERID_VR1RNGI_MASK                   (0x100U)
#define ADC_VERID_VR1RNGI_SHIFT                  (8U)
/*! VR1RNGI - Voltage Reference 1 Range Control Bit Implemented
 *  0b0..Range control not required. CFG[VREF1RNG] is not implemented.
 *  0b1..Range control required. CFG[VREF1RNG] is implemented.
 */
#define ADC_VERID_VR1RNGI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_VR1RNGI_SHIFT)) & ADC_VERID_VR1RNGI_MASK)
#define ADC_VERID_IADCKI_MASK                    (0x200U)
#define ADC_VERID_IADCKI_SHIFT                   (9U)
/*! IADCKI - Internal ADC Clock implemented
 *  0b0..Internal clock source not implemented.
 *  0b1..Internal clock source (and CFG[ADCKEN]) implemented.
 */
#define ADC_VERID_IADCKI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_VERID_IADCKI_SHIFT)) & ADC_VERID_IADCKI_MASK)
#define ADC_VERID_CALOFSI_MASK                   (0x400U)
#define ADC_VERID_CALOFSI_SHIFT                  (10U)
/*! CALOFSI - Calibration Function Implemented
 *  0b0..Calibration Not Implemented.
 *  0b1..Calibration Implemented.
 */
#define ADC_VERID_CALOFSI(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_CALOFSI_SHIFT)) & ADC_VERID_CALOFSI_MASK)
#define ADC_VERID_NUM_SEC_MASK                   (0x800U)
#define ADC_VERID_NUM_SEC_SHIFT                  (11U)
/*! NUM_SEC - Number of Single Ended Outputs Supported
 *  0b0..This design supports one single ended conversion at a time.
 *  0b1..This design supports two simultanious single ended conversions.
 */
#define ADC_VERID_NUM_SEC(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_SEC_SHIFT)) & ADC_VERID_NUM_SEC_MASK)
#define ADC_VERID_NUM_FIFO_MASK                  (0x7000U)
#define ADC_VERID_NUM_FIFO_SHIFT                 (12U)
/*! NUM_FIFO - Number of FIFOs
 *  0b000..N/A
 *  0b001..This design supports one result FIFO.
 *  0b010..This design supports two result FIFOs.
 *  0b011..This design supports three result FIFOs.
 *  0b100..This design supports four result FIFOs.
 */
#define ADC_VERID_NUM_FIFO(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_VERID_NUM_FIFO_SHIFT)) & ADC_VERID_NUM_FIFO_MASK)
#define ADC_VERID_MINOR_MASK                     (0xFF0000U)
#define ADC_VERID_MINOR_SHIFT                    (16U)
/*! MINOR - Minor Version Number
 */
#define ADC_VERID_MINOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MINOR_SHIFT)) & ADC_VERID_MINOR_MASK)
#define ADC_VERID_MAJOR_MASK                     (0xFF000000U)
#define ADC_VERID_MAJOR_SHIFT                    (24U)
/*! MAJOR - Major Version Number
 */
#define ADC_VERID_MAJOR(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_VERID_MAJOR_SHIFT)) & ADC_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */
#define ADC_PARAM_TRIG_NUM_MASK                  (0xFFU)
#define ADC_PARAM_TRIG_NUM_SHIFT                 (0U)
/*! TRIG_NUM - Trigger Number
 */
#define ADC_PARAM_TRIG_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_TRIG_NUM_SHIFT)) & ADC_PARAM_TRIG_NUM_MASK)
#define ADC_PARAM_FIFOSIZE_MASK                  (0xFF00U)
#define ADC_PARAM_FIFOSIZE_SHIFT                 (8U)
/*! FIFOSIZE - Result FIFO Depth
 *  0b00000001..Result FIFO depth = 1 dataword.
 *  0b00000100..Result FIFO depth = 4 datawords.
 *  0b00001000..Result FIFO depth = 8 datawords.
 *  0b00010000..Result FIFO depth = 16 datawords.
 *  0b00100000..Result FIFO depth = 32 datawords.
 *  0b01000000..Result FIFO depth = 64 datawords.
 */
#define ADC_PARAM_FIFOSIZE(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_FIFOSIZE_SHIFT)) & ADC_PARAM_FIFOSIZE_MASK)
#define ADC_PARAM_CV_NUM_MASK                    (0xFF0000U)
#define ADC_PARAM_CV_NUM_SHIFT                   (16U)
/*! CV_NUM - Compare Value Number
 */
#define ADC_PARAM_CV_NUM(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CV_NUM_SHIFT)) & ADC_PARAM_CV_NUM_MASK)
#define ADC_PARAM_CMD_NUM_MASK                   (0xFF000000U)
#define ADC_PARAM_CMD_NUM_SHIFT                  (24U)
/*! CMD_NUM - Command Buffer Number
 */
#define ADC_PARAM_CMD_NUM(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PARAM_CMD_NUM_SHIFT)) & ADC_PARAM_CMD_NUM_MASK)
/*! @} */

/*! @name CTRL - ADC Control Register */
/*! @{ */
#define ADC_CTRL_ADCEN_MASK                      (0x1U)
#define ADC_CTRL_ADCEN_SHIFT                     (0U)
/*! ADCEN - ADC Enable
 *  0b0..ADC is disabled.
 *  0b1..ADC is enabled.
 */
#define ADC_CTRL_ADCEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_ADCEN_SHIFT)) & ADC_CTRL_ADCEN_MASK)
#define ADC_CTRL_RST_MASK                        (0x2U)
#define ADC_CTRL_RST_SHIFT                       (1U)
/*! RST - Software Reset
 *  0b0..ADC logic is not reset.
 *  0b1..ADC logic is reset.
 */
#define ADC_CTRL_RST(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RST_SHIFT)) & ADC_CTRL_RST_MASK)
#define ADC_CTRL_DOZEN_MASK                      (0x4U)
#define ADC_CTRL_DOZEN_SHIFT                     (2U)
/*! DOZEN - Doze Enable
 *  0b0..ADC is enabled in Doze mode.
 *  0b1..ADC is disabled in Doze mode.
 */
#define ADC_CTRL_DOZEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_DOZEN_SHIFT)) & ADC_CTRL_DOZEN_MASK)
#define ADC_CTRL_RSTFIFO0_MASK                   (0x100U)
#define ADC_CTRL_RSTFIFO0_SHIFT                  (8U)
/*! RSTFIFO0 - Reset FIFO 0
 *  0b0..No effect.
 *  0b1..FIFO 0 is reset.
 */
#define ADC_CTRL_RSTFIFO0(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO0_SHIFT)) & ADC_CTRL_RSTFIFO0_MASK)
#define ADC_CTRL_RSTFIFO1_MASK                   (0x200U)
#define ADC_CTRL_RSTFIFO1_SHIFT                  (9U)
/*! RSTFIFO1 - Reset FIFO 1
 *  0b0..No effect.
 *  0b1..FIFO 1 is reset.
 */
#define ADC_CTRL_RSTFIFO1(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_CTRL_RSTFIFO1_SHIFT)) & ADC_CTRL_RSTFIFO1_MASK)
/*! @} */

/*! @name STAT - ADC Status Register */
/*! @{ */
#define ADC_STAT_RDY0_MASK                       (0x1U)
#define ADC_STAT_RDY0_SHIFT                      (0U)
/*! RDY0 - Result FIFO 0 Ready Flag
 *  0b0..Result FIFO 0 data level not above watermark level.
 *  0b1..Result FIFO 0 holding data above watermark level.
 */
#define ADC_STAT_RDY0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY0_SHIFT)) & ADC_STAT_RDY0_MASK)
#define ADC_STAT_FOF0_MASK                       (0x2U)
#define ADC_STAT_FOF0_SHIFT                      (1U)
/*! FOF0 - Result FIFO 0 Overflow Flag
 *  0b0..No result FIFO 0 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO 0 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_STAT_FOF0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF0_SHIFT)) & ADC_STAT_FOF0_MASK)
#define ADC_STAT_RDY1_MASK                       (0x4U)
#define ADC_STAT_RDY1_SHIFT                      (2U)
/*! RDY1 - Result FIFO1 Ready Flag
 *  0b0..Result FIFO1 data level not above watermark level.
 *  0b1..Result FIFO1 holding data above watermark level.
 */
#define ADC_STAT_RDY1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_RDY1_SHIFT)) & ADC_STAT_RDY1_MASK)
#define ADC_STAT_FOF1_MASK                       (0x8U)
#define ADC_STAT_FOF1_SHIFT                      (3U)
/*! FOF1 - Result FIFO1 Overflow Flag
 *  0b0..No result FIFO1 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO1 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_STAT_FOF1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_STAT_FOF1_SHIFT)) & ADC_STAT_FOF1_MASK)
#define ADC_STAT_TEXC_INT_MASK                   (0x100U)
#define ADC_STAT_TEXC_INT_SHIFT                  (8U)
/*! TEXC_INT - Interrupt Flag For High Priority Trigger Exception
 *  0b0..No trigger exceptions have occurred.
 *  0b1..A trigger exception has occurred and is pending acknowledgement.
 */
#define ADC_STAT_TEXC_INT(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TEXC_INT_SHIFT)) & ADC_STAT_TEXC_INT_MASK)
#define ADC_STAT_TCOMP_INT_MASK                  (0x200U)
#define ADC_STAT_TCOMP_INT_SHIFT                 (9U)
/*! TCOMP_INT - Interrupt Flag For Trigger Completion
 *  0b0..Either IE[TCOMP_IE] is set to 0, or no trigger sequences have run to completion.
 *  0b1..Trigger sequence has been completed and all data is stored in the associated FIFO.
 */
#define ADC_STAT_TCOMP_INT(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TCOMP_INT_SHIFT)) & ADC_STAT_TCOMP_INT_MASK)
#define ADC_STAT_ADC_ACTIVE_MASK                 (0x800U)
#define ADC_STAT_ADC_ACTIVE_SHIFT                (11U)
/*! ADC_ACTIVE - ADC Active
 *  0b0..The ADC is IDLE. There are no pending triggers to service and no active commands are being processed.
 *  0b1..The ADC is processing a conversion, running through the power up delay, or servicing a trigger.
 */
#define ADC_STAT_ADC_ACTIVE(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_STAT_ADC_ACTIVE_SHIFT)) & ADC_STAT_ADC_ACTIVE_MASK)
#define ADC_STAT_TRGACT_MASK                     (0xF0000U)
#define ADC_STAT_TRGACT_SHIFT                    (16U)
/*! TRGACT - Trigger Active
 *  0b0000..Command (sequence) associated with Trigger 0 currently being executed.
 *  0b0001..Command (sequence) associated with Trigger 1 currently being executed.
 *  0b0010..Command (sequence) associated with Trigger 2 currently being executed.
 *  0b0011-0b1111..Command (sequence) from the associated Trigger number is currently being executed.
 */
#define ADC_STAT_TRGACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_TRGACT_SHIFT)) & ADC_STAT_TRGACT_MASK)
#define ADC_STAT_CMDACT_MASK                     (0xF000000U)
#define ADC_STAT_CMDACT_SHIFT                    (24U)
/*! CMDACT - Command Active
 *  0b0000..No command is currently in progress.
 *  0b0001..Command 1 currently being executed.
 *  0b0010..Command 2 currently being executed.
 *  0b0011-0b1111..Associated command number is currently being executed.
 */
#define ADC_STAT_CMDACT(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_STAT_CMDACT_SHIFT)) & ADC_STAT_CMDACT_MASK)
/*! @} */

/*! @name IE - Interrupt Enable Register */
/*! @{ */
#define ADC_IE_FWMIE0_MASK                       (0x1U)
#define ADC_IE_FWMIE0_SHIFT                      (0U)
/*! FWMIE0 - FIFO 0 Watermark Interrupt Enable
 *  0b0..FIFO 0 watermark interrupts are not enabled.
 *  0b1..FIFO 0 watermark interrupts are enabled.
 */
#define ADC_IE_FWMIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE0_SHIFT)) & ADC_IE_FWMIE0_MASK)
#define ADC_IE_FOFIE0_MASK                       (0x2U)
#define ADC_IE_FOFIE0_SHIFT                      (1U)
/*! FOFIE0 - Result FIFO 0 Overflow Interrupt Enable
 *  0b0..FIFO 0 overflow interrupts are not enabled.
 *  0b1..FIFO 0 overflow interrupts are enabled.
 */
#define ADC_IE_FOFIE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE0_SHIFT)) & ADC_IE_FOFIE0_MASK)
#define ADC_IE_FWMIE1_MASK                       (0x4U)
#define ADC_IE_FWMIE1_SHIFT                      (2U)
/*! FWMIE1 - FIFO1 Watermark Interrupt Enable
 *  0b0..FIFO1 watermark interrupts are not enabled.
 *  0b1..FIFO1 watermark interrupts are enabled.
 */
#define ADC_IE_FWMIE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FWMIE1_SHIFT)) & ADC_IE_FWMIE1_MASK)
#define ADC_IE_FOFIE1_MASK                       (0x8U)
#define ADC_IE_FOFIE1_SHIFT                      (3U)
/*! FOFIE1 - Result FIFO1 Overflow Interrupt Enable
 *  0b0..No result FIFO1 overflow has occurred since the last time the flag was cleared.
 *  0b1..At least one result FIFO1 overflow has occurred since the last time the flag was cleared.
 */
#define ADC_IE_FOFIE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_IE_FOFIE1_SHIFT)) & ADC_IE_FOFIE1_MASK)
#define ADC_IE_TEXC_IE_MASK                      (0x100U)
#define ADC_IE_TEXC_IE_SHIFT                     (8U)
/*! TEXC_IE - Trigger Exception Interrupt Enable
 *  0b0..Trigger exception interrupts are disabled.
 *  0b1..Trigger exception interrupts are enabled.
 */
#define ADC_IE_TEXC_IE(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_IE_TEXC_IE_SHIFT)) & ADC_IE_TEXC_IE_MASK)
#define ADC_IE_TCOMP_IE_MASK                     (0xFFFF0000U)
#define ADC_IE_TCOMP_IE_SHIFT                    (16U)
/*! TCOMP_IE - Trigger Completion Interrupt Enable
 *  0b0000000000000000..Trigger completion interrupts are disabled.
 *  0b0000000000000001..Trigger completion interrupts are enabled for trigger source 0 only.
 *  0b0000000000000010..Trigger completion interrupts are enabled for trigger source 1 only.
 *  0b0000000000000011-0b1111111111111110..Associated trigger completion interrupts are enabled.
 *  0b1111111111111111..Trigger completion interrupts are enabled for every trigger source.
 */
#define ADC_IE_TCOMP_IE(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_IE_TCOMP_IE_SHIFT)) & ADC_IE_TCOMP_IE_MASK)
/*! @} */

/*! @name DE - DMA Enable Register */
/*! @{ */
#define ADC_DE_FWMDE0_MASK                       (0x1U)
#define ADC_DE_FWMDE0_SHIFT                      (0U)
/*! FWMDE0 - FIFO 0 Watermark DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define ADC_DE_FWMDE0(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE0_SHIFT)) & ADC_DE_FWMDE0_MASK)
#define ADC_DE_FWMDE1_MASK                       (0x2U)
#define ADC_DE_FWMDE1_SHIFT                      (1U)
/*! FWMDE1 - FIFO1 Watermark DMA Enable
 *  0b0..DMA request disabled.
 *  0b1..DMA request enabled.
 */
#define ADC_DE_FWMDE1(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_DE_FWMDE1_SHIFT)) & ADC_DE_FWMDE1_MASK)
/*! @} */

/*! @name CFG - ADC Configuration Register */
/*! @{ */
#define ADC_CFG_TPRICTRL_MASK                    (0x3U)
#define ADC_CFG_TPRICTRL_SHIFT                   (0U)
/*! TPRICTRL - ADC trigger priority control
 *  0b00..If a higher priority trigger is detected during command processing, the current conversion is aborted
 *        and the new command specified by the trigger is started.
 *  0b01..If a higher priority trigger is received during command processing, the current command is stopped after
 *        after completing the current conversion. If averaging is enabled, the averaging loop will be completed.
 *        However, CMDHa[LOOP] will be ignored and the higher priority trigger will be serviced.
 *  0b10..If a higher priority trigger is received during command processing, the current command will be
 *        completed (averaging, looping, compare) before servicing the higher priority trigger.
 *  0b11..RESERVED
 */
#define ADC_CFG_TPRICTRL(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TPRICTRL_SHIFT)) & ADC_CFG_TPRICTRL_MASK)
#define ADC_CFG_PWRSEL_MASK                      (0x30U)
#define ADC_CFG_PWRSEL_SHIFT                     (4U)
/*! PWRSEL - Power Configuration Select
 *  0b00..Lowest power setting.
 *  0b01..Higher power setting than 0b0.
 *  0b10..Higher power setting than 0b1.
 *  0b11..Highest power setting.
 */
#define ADC_CFG_PWRSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWRSEL_SHIFT)) & ADC_CFG_PWRSEL_MASK)
#define ADC_CFG_REFSEL_MASK                      (0xC0U)
#define ADC_CFG_REFSEL_SHIFT                     (6U)
/*! REFSEL - Voltage Reference Selection
 *  0b00..(Default) Option 1 setting.
 *  0b01..Option 2 setting.
 *  0b10..Option 3 setting.
 *  0b11..Reserved
 */
#define ADC_CFG_REFSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CFG_REFSEL_SHIFT)) & ADC_CFG_REFSEL_MASK)
#define ADC_CFG_TRES_MASK                        (0x100U)
#define ADC_CFG_TRES_SHIFT                       (8U)
/*! TRES - Trigger Resume Enable
 *  0b0..Trigger sequences interrupted by a high priority trigger exception are not automatically resumed or restarted.
 *  0b1..Trigger sequences interrupted by a high priority trigger exception are automatically resumed or restarted.
 */
#define ADC_CFG_TRES(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TRES_SHIFT)) & ADC_CFG_TRES_MASK)
#define ADC_CFG_TCMDRES_MASK                     (0x200U)
#define ADC_CFG_TCMDRES_SHIFT                    (9U)
/*! TCMDRES - Trigger Command Resume
 *  0b0..Trigger sequences interrupted by a high priority trigger exception is automatically restarted.
 *  0b1..Trigger sequences interrupted by a high priority trigger exception is resumed from the command executing before the exception.
 */
#define ADC_CFG_TCMDRES(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CFG_TCMDRES_SHIFT)) & ADC_CFG_TCMDRES_MASK)
#define ADC_CFG_HPT_EXDI_MASK                    (0x400U)
#define ADC_CFG_HPT_EXDI_SHIFT                   (10U)
/*! HPT_EXDI - High Priority Trigger Exception Disable
 *  0b0..High priority trigger exceptions are enabled.
 *  0b1..High priority trigger exceptions are disabled.
 */
#define ADC_CFG_HPT_EXDI(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_CFG_HPT_EXDI_SHIFT)) & ADC_CFG_HPT_EXDI_MASK)
#define ADC_CFG_PUDLY_MASK                       (0xFF0000U)
#define ADC_CFG_PUDLY_SHIFT                      (16U)
/*! PUDLY - Power Up Delay
 */
#define ADC_CFG_PUDLY(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PUDLY_SHIFT)) & ADC_CFG_PUDLY_MASK)
#define ADC_CFG_PWREN_MASK                       (0x10000000U)
#define ADC_CFG_PWREN_SHIFT                      (28U)
/*! PWREN - ADC Analog Pre-Enable
 *  0b0..ADC analog circuits are only enabled while conversions are active. Performance is affected due to analog startup delays.
 *  0b1..ADC analog circuits are pre-enabled and ready to execute conversions without startup delays (at the cost
 *       of higher DC current consumption). A single power up delay (CFG[PUDLY]) is executed immediately once PWREN
 *       is set, and any detected trigger does not begin ADC operation until the power up delay time has passed.
 *       After this initial delay expires the analog will remain pre-enabled, and no additional delays will be
 *       executed.
 */
#define ADC_CFG_PWREN(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CFG_PWREN_SHIFT)) & ADC_CFG_PWREN_MASK)
/*! @} */

/*! @name PAUSE - ADC Pause Register */
/*! @{ */
#define ADC_PAUSE_PAUSEDLY_MASK                  (0x1FFU)
#define ADC_PAUSE_PAUSEDLY_SHIFT                 (0U)
/*! PAUSEDLY - Pause Delay
 */
#define ADC_PAUSE_PAUSEDLY(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEDLY_SHIFT)) & ADC_PAUSE_PAUSEDLY_MASK)
#define ADC_PAUSE_PAUSEEN_MASK                   (0x80000000U)
#define ADC_PAUSE_PAUSEEN_SHIFT                  (31U)
/*! PAUSEEN - PAUSE Option Enable
 *  0b0..Pause operation disabled
 *  0b1..Pause operation enabled
 */
#define ADC_PAUSE_PAUSEEN(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_PAUSE_PAUSEEN_SHIFT)) & ADC_PAUSE_PAUSEEN_MASK)
/*! @} */

/*! @name SWTRIG - Software Trigger Register */
/*! @{ */
#define ADC_SWTRIG_SWT0_MASK                     (0x1U)
#define ADC_SWTRIG_SWT0_SHIFT                    (0U)
/*! SWT0 - Software trigger 0 event
 *  0b0..No trigger 0 event generated.
 *  0b1..Trigger 0 event generated.
 */
#define ADC_SWTRIG_SWT0(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT0_SHIFT)) & ADC_SWTRIG_SWT0_MASK)
#define ADC_SWTRIG_SWT1_MASK                     (0x2U)
#define ADC_SWTRIG_SWT1_SHIFT                    (1U)
/*! SWT1 - Software trigger 1 event
 *  0b0..No trigger 1 event generated.
 *  0b1..Trigger 1 event generated.
 */
#define ADC_SWTRIG_SWT1(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT1_SHIFT)) & ADC_SWTRIG_SWT1_MASK)
#define ADC_SWTRIG_SWT2_MASK                     (0x4U)
#define ADC_SWTRIG_SWT2_SHIFT                    (2U)
/*! SWT2 - Software trigger 2 event
 *  0b0..No trigger 2 event generated.
 *  0b1..Trigger 2 event generated.
 */
#define ADC_SWTRIG_SWT2(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT2_SHIFT)) & ADC_SWTRIG_SWT2_MASK)
#define ADC_SWTRIG_SWT3_MASK                     (0x8U)
#define ADC_SWTRIG_SWT3_SHIFT                    (3U)
/*! SWT3 - Software trigger 3 event
 *  0b0..No trigger 3 event generated.
 *  0b1..Trigger 3 event generated.
 */
#define ADC_SWTRIG_SWT3(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT3_SHIFT)) & ADC_SWTRIG_SWT3_MASK)
#define ADC_SWTRIG_SWT4_MASK                     (0x10U)
#define ADC_SWTRIG_SWT4_SHIFT                    (4U)
/*! SWT4 - Software trigger 4 event
 *  0b0..No trigger 4 event generated.
 *  0b1..Trigger 4 event generated.
 */
#define ADC_SWTRIG_SWT4(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT4_SHIFT)) & ADC_SWTRIG_SWT4_MASK)
#define ADC_SWTRIG_SWT5_MASK                     (0x20U)
#define ADC_SWTRIG_SWT5_SHIFT                    (5U)
/*! SWT5 - Software trigger 5 event
 *  0b0..No trigger 5 event generated.
 *  0b1..Trigger 5 event generated.
 */
#define ADC_SWTRIG_SWT5(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT5_SHIFT)) & ADC_SWTRIG_SWT5_MASK)
#define ADC_SWTRIG_SWT6_MASK                     (0x40U)
#define ADC_SWTRIG_SWT6_SHIFT                    (6U)
/*! SWT6 - Software trigger 6 event
 *  0b0..No trigger 6 event generated.
 *  0b1..Trigger 6 event generated.
 */
#define ADC_SWTRIG_SWT6(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT6_SHIFT)) & ADC_SWTRIG_SWT6_MASK)
#define ADC_SWTRIG_SWT7_MASK                     (0x80U)
#define ADC_SWTRIG_SWT7_SHIFT                    (7U)
/*! SWT7 - Software trigger 7 event
 *  0b0..No trigger 7 event generated.
 *  0b1..Trigger 7 event generated.
 */
#define ADC_SWTRIG_SWT7(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT7_SHIFT)) & ADC_SWTRIG_SWT7_MASK)
#define ADC_SWTRIG_SWT8_MASK                     (0x100U)
#define ADC_SWTRIG_SWT8_SHIFT                    (8U)
/*! SWT8 - Software trigger 8 event
 *  0b0..No trigger 8 event generated.
 *  0b1..Trigger 8 event generated.
 */
#define ADC_SWTRIG_SWT8(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT8_SHIFT)) & ADC_SWTRIG_SWT8_MASK)
#define ADC_SWTRIG_SWT9_MASK                     (0x200U)
#define ADC_SWTRIG_SWT9_SHIFT                    (9U)
/*! SWT9 - Software trigger 9 event
 *  0b0..No trigger 9 event generated.
 *  0b1..Trigger 9 event generated.
 */
#define ADC_SWTRIG_SWT9(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT9_SHIFT)) & ADC_SWTRIG_SWT9_MASK)
#define ADC_SWTRIG_SWT10_MASK                    (0x400U)
#define ADC_SWTRIG_SWT10_SHIFT                   (10U)
/*! SWT10 - Software trigger 10 event
 *  0b0..No trigger 10 event generated.
 *  0b1..Trigger 10 event generated.
 */
#define ADC_SWTRIG_SWT10(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT10_SHIFT)) & ADC_SWTRIG_SWT10_MASK)
#define ADC_SWTRIG_SWT11_MASK                    (0x800U)
#define ADC_SWTRIG_SWT11_SHIFT                   (11U)
/*! SWT11 - Software trigger 11 event
 *  0b0..No trigger 11 event generated.
 *  0b1..Trigger 11 event generated.
 */
#define ADC_SWTRIG_SWT11(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT11_SHIFT)) & ADC_SWTRIG_SWT11_MASK)
#define ADC_SWTRIG_SWT12_MASK                    (0x1000U)
#define ADC_SWTRIG_SWT12_SHIFT                   (12U)
/*! SWT12 - Software trigger 12 event
 *  0b0..No trigger 12 event generated.
 *  0b1..Trigger 12 event generated.
 */
#define ADC_SWTRIG_SWT12(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT12_SHIFT)) & ADC_SWTRIG_SWT12_MASK)
#define ADC_SWTRIG_SWT13_MASK                    (0x2000U)
#define ADC_SWTRIG_SWT13_SHIFT                   (13U)
/*! SWT13 - Software trigger 13 event
 *  0b0..No trigger 13 event generated.
 *  0b1..Trigger 13 event generated.
 */
#define ADC_SWTRIG_SWT13(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT13_SHIFT)) & ADC_SWTRIG_SWT13_MASK)
#define ADC_SWTRIG_SWT14_MASK                    (0x4000U)
#define ADC_SWTRIG_SWT14_SHIFT                   (14U)
/*! SWT14 - Software trigger 14 event
 *  0b0..No trigger 14 event generated.
 *  0b1..Trigger 14 event generated.
 */
#define ADC_SWTRIG_SWT14(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT14_SHIFT)) & ADC_SWTRIG_SWT14_MASK)
#define ADC_SWTRIG_SWT15_MASK                    (0x8000U)
#define ADC_SWTRIG_SWT15_SHIFT                   (15U)
/*! SWT15 - Software trigger 15 event
 *  0b0..No trigger 15 event generated.
 *  0b1..Trigger 15 event generated.
 */
#define ADC_SWTRIG_SWT15(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_SWTRIG_SWT15_SHIFT)) & ADC_SWTRIG_SWT15_MASK)
/*! @} */

/*! @name TSTAT - Trigger Status Register */
/*! @{ */
#define ADC_TSTAT_TEXC_NUM_MASK                  (0xFFFFU)
#define ADC_TSTAT_TEXC_NUM_SHIFT                 (0U)
/*! TEXC_NUM - Trigger Exception Number
 *  0b0000000000000000..No triggers have been interrupted by a high priority exception. Or CFG[TRES] = 1.
 *  0b0000000000000001..Trigger 0 has been interrupted by a high priority exception.
 *  0b0000000000000010..Trigger 1 has been interrupted by a high priority exception.
 *  0b0000000000000011-0b1111111111111110..Associated trigger sequence has interrupted by a high priority exception.
 *  0b1111111111111111..Every trigger sequence has been interrupted by a high priority exception.
 */
#define ADC_TSTAT_TEXC_NUM(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TEXC_NUM_SHIFT)) & ADC_TSTAT_TEXC_NUM_MASK)
#define ADC_TSTAT_TCOMP_FLAG_MASK                (0xFFFF0000U)
#define ADC_TSTAT_TCOMP_FLAG_SHIFT               (16U)
/*! TCOMP_FLAG - Trigger Completion Flag
 *  0b0000000000000000..No triggers have been completed. Trigger completion interrupts are disabled.
 *  0b0000000000000001..Trigger 0 has been completed and triger 0 has enabled completion interrupts.
 *  0b0000000000000010..Trigger 1 has been completed and triger 1 has enabled completion interrupts.
 *  0b0000000000000011-0b1111111111111110..Associated trigger sequence has completed and has enabled completion interrupts.
 *  0b1111111111111111..Every trigger sequence has been completed and every trigger has enabled completion interrupts.
 */
#define ADC_TSTAT_TCOMP_FLAG(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TSTAT_TCOMP_FLAG_SHIFT)) & ADC_TSTAT_TCOMP_FLAG_MASK)
/*! @} */

/*! @name TCTRL - Trigger Control Register */
/*! @{ */
#define ADC_TCTRL_HTEN_MASK                      (0x1U)
#define ADC_TCTRL_HTEN_SHIFT                     (0U)
/*! HTEN - Trigger enable
 *  0b0..Hardware trigger source disabled
 *  0b1..Hardware trigger source enabled
 */
#define ADC_TCTRL_HTEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_HTEN_SHIFT)) & ADC_TCTRL_HTEN_MASK)
#define ADC_TCTRL_FIFO_SEL_A_MASK                (0x2U)
#define ADC_TCTRL_FIFO_SEL_A_SHIFT               (1U)
/*! FIFO_SEL_A - SAR Result Destination For Channel A
 *  0b0..Result written to FIFO 0
 *  0b1..Result written to FIFO 1
 */
#define ADC_TCTRL_FIFO_SEL_A(x)                  (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_FIFO_SEL_A_SHIFT)) & ADC_TCTRL_FIFO_SEL_A_MASK)
#define ADC_TCTRL_TPRI_MASK                      (0xF00U)
#define ADC_TCTRL_TPRI_SHIFT                     (8U)
/*! TPRI - Trigger priority setting
 *  0b0000..Set to highest priority, Level 1
 *  0b0001-0b1110..Set to corresponding priority level
 *  0b1111..Set to lowest priority, Level 16
 */
#define ADC_TCTRL_TPRI(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TPRI_SHIFT)) & ADC_TCTRL_TPRI_MASK)
#define ADC_TCTRL_RSYNC_MASK                     (0x8000U)
#define ADC_TCTRL_RSYNC_SHIFT                    (15U)
/*! RSYNC - Trigger Resync
 */
#define ADC_TCTRL_RSYNC(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_RSYNC_SHIFT)) & ADC_TCTRL_RSYNC_MASK)
#define ADC_TCTRL_TDLY_MASK                      (0xF0000U)
#define ADC_TCTRL_TDLY_SHIFT                     (16U)
/*! TDLY - Trigger delay select
 */
#define ADC_TCTRL_TDLY(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TDLY_SHIFT)) & ADC_TCTRL_TDLY_MASK)
#define ADC_TCTRL_TCMD_MASK                      (0xF000000U)
#define ADC_TCTRL_TCMD_SHIFT                     (24U)
/*! TCMD - Trigger command select
 *  0b0000..Not a valid selection from the command buffer. Trigger event is ignored.
 *  0b0001..CMD1 is executed
 *  0b0010-0b1110..Corresponding CMD is executed
 *  0b1111..CMD15 is executed
 */
#define ADC_TCTRL_TCMD(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_TCTRL_TCMD_SHIFT)) & ADC_TCTRL_TCMD_MASK)
/*! @} */

/* The count of ADC_TCTRL */
#define ADC_TCTRL_COUNT                          (16U)

/*! @name FCTRL - FIFO Control Register */
/*! @{ */
#define ADC_FCTRL_FCOUNT_MASK                    (0x1FU)
#define ADC_FCTRL_FCOUNT_SHIFT                   (0U)
/*! FCOUNT - Result FIFO counter
 */
#define ADC_FCTRL_FCOUNT(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FCOUNT_SHIFT)) & ADC_FCTRL_FCOUNT_MASK)
#define ADC_FCTRL_FWMARK_MASK                    (0xF0000U)
#define ADC_FCTRL_FWMARK_SHIFT                   (16U)
/*! FWMARK - Watermark level selection
 */
#define ADC_FCTRL_FWMARK(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_FCTRL_FWMARK_SHIFT)) & ADC_FCTRL_FWMARK_MASK)
/*! @} */

/* The count of ADC_FCTRL */
#define ADC_FCTRL_COUNT                          (2U)

/*! @name CMDL - ADC Command Low Buffer Register */
/*! @{ */
#define ADC_CMDL_ADCH_MASK                       (0x1FU)
#define ADC_CMDL_ADCH_SHIFT                      (0U)
/*! ADCH - Input channel select
 *  0b00000..Select CH0A or CH0B or CH0A/CH0B pair.
 *  0b00001..Select CH1A or CH1B or CH1A/CH1B pair.
 *  0b00010..Select CH2A or CH2B or CH2A/CH2B pair.
 *  0b00011..Select CH3A or CH3B or CH3A/CH3B pair.
 *  0b00100-0b11101..Select corresponding channel CHnA or CHnB or CHnA/CHnB pair.
 *  0b11110..Select CH30A or CH30B or CH30A/CH30B pair.
 *  0b11111..Select CH31A or CH31B or CH31A/CH31B pair.
 */
#define ADC_CMDL_ADCH(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ADCH_SHIFT)) & ADC_CMDL_ADCH_MASK)
#define ADC_CMDL_ABSEL_MASK                      (0x20U)
#define ADC_CMDL_ABSEL_SHIFT                     (5U)
/*! ABSEL - A-side vs. B-side Select
 *  0b0..When DIFF=0b0, the associated A-side channel is converted as single-ended. When DIFF=0b1, the ADC result is (CHnA-CHnB).
 *  0b1..When DIFF=0b0, the associated B-side channel is converted as single-ended. When DIFF=0b1, the ADC result is (CHnB-CHnA).
 */
#define ADC_CMDL_ABSEL(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_ABSEL_SHIFT)) & ADC_CMDL_ABSEL_MASK)
#define ADC_CMDL_DIFF_MASK                       (0x40U)
#define ADC_CMDL_DIFF_SHIFT                      (6U)
/*! DIFF - Differential Mode Enable
 *  0b0..Single-ended mode.
 *  0b1..Differential mode.
 */
#define ADC_CMDL_DIFF(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_DIFF_SHIFT)) & ADC_CMDL_DIFF_MASK)
#define ADC_CMDL_CSCALE_MASK                     (0x2000U)
#define ADC_CMDL_CSCALE_SHIFT                    (13U)
/*! CSCALE - Channel Scale
 *  0b0..Scale selected analog channel (Factor of 30/64)
 *  0b1..(Default) Full scale (Factor of 1)
 */
#define ADC_CMDL_CSCALE(x)                       (((uint32_t)(((uint32_t)(x)) << ADC_CMDL_CSCALE_SHIFT)) & ADC_CMDL_CSCALE_MASK)
/*! @} */

/* The count of ADC_CMDL */
#define ADC_CMDL_COUNT                           (15U)

/*! @name CMDH - ADC Command High Buffer Register */
/*! @{ */
#define ADC_CMDH_CMPEN_MASK                      (0x3U)
#define ADC_CMDH_CMPEN_SHIFT                     (0U)
/*! CMPEN - Compare Function Enable
 *  0b00..Compare disabled.
 *  0b01..Reserved
 *  0b10..Compare enabled. Store on true.
 *  0b11..Compare enabled. Repeat channel acquisition (sample/convert/compare) until true.
 */
#define ADC_CMDH_CMPEN(x)                        (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_CMPEN_SHIFT)) & ADC_CMDH_CMPEN_MASK)
#define ADC_CMDH_WAIT_TRIG_MASK                  (0x4U)
#define ADC_CMDH_WAIT_TRIG_SHIFT                 (2U)
/*! WAIT_TRIG - Wait for trigger assertion before execution.
 *  0b0..This command will be automatically executed.
 *  0b1..The active trigger must be asserted again before executing this command.
 */
#define ADC_CMDH_WAIT_TRIG(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_WAIT_TRIG_SHIFT)) & ADC_CMDH_WAIT_TRIG_MASK)
#define ADC_CMDH_LWI_MASK                        (0x80U)
#define ADC_CMDH_LWI_SHIFT                       (7U)
/*! LWI - Loop with Increment
 *  0b0..Auto channel increment disabled
 *  0b1..Auto channel increment enabled
 */
#define ADC_CMDH_LWI(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LWI_SHIFT)) & ADC_CMDH_LWI_MASK)
#define ADC_CMDH_STS_MASK                        (0x700U)
#define ADC_CMDH_STS_SHIFT                       (8U)
/*! STS - Sample Time Select
 *  0b000..Minimum sample time of 3 ADCK cycles.
 *  0b001..3 + 21 ADCK cycles; 5 ADCK cycles total sample time.
 *  0b010..3 + 22 ADCK cycles; 7 ADCK cycles total sample time.
 *  0b011..3 + 23 ADCK cycles; 11 ADCK cycles total sample time.
 *  0b100..3 + 24 ADCK cycles; 19 ADCK cycles total sample time.
 *  0b101..3 + 25 ADCK cycles; 35 ADCK cycles total sample time.
 *  0b110..3 + 26 ADCK cycles; 67 ADCK cycles total sample time.
 *  0b111..3 + 27 ADCK cycles; 131 ADCK cycles total sample time.
 */
#define ADC_CMDH_STS(x)                          (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_STS_SHIFT)) & ADC_CMDH_STS_MASK)
#define ADC_CMDH_AVGS_MASK                       (0x7000U)
#define ADC_CMDH_AVGS_SHIFT                      (12U)
/*! AVGS - Hardware Average Select
 *  0b000..Single conversion.
 *  0b001..2 conversions averaged.
 *  0b010..4 conversions averaged.
 *  0b011..8 conversions averaged.
 *  0b100..16 conversions averaged.
 *  0b101..32 conversions averaged.
 *  0b110..64 conversions averaged.
 *  0b111..128 conversions averaged.
 */
#define ADC_CMDH_AVGS(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_AVGS_SHIFT)) & ADC_CMDH_AVGS_MASK)
#define ADC_CMDH_LOOP_MASK                       (0xF0000U)
#define ADC_CMDH_LOOP_SHIFT                      (16U)
/*! LOOP - Loop Count Select
 *  0b0000..Looping not enabled. Command executes 1 time.
 *  0b0001..Loop 1 time. Command executes 2 times.
 *  0b0010..Loop 2 times. Command executes 3 times.
 *  0b0011-0b1110..Loop corresponding number of times. Command executes LOOP+1 times.
 *  0b1111..Loop 15 times. Command executes 16 times.
 */
#define ADC_CMDH_LOOP(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_LOOP_SHIFT)) & ADC_CMDH_LOOP_MASK)
#define ADC_CMDH_NEXT_MASK                       (0xF000000U)
#define ADC_CMDH_NEXT_SHIFT                      (24U)
/*! NEXT - Next Command Select
 *  0b0000..No next command defined. Terminate conversions at completion of current command. If lower priority
 *          trigger pending, begin command associated with lower priority trigger.
 *  0b0001..Select CMD1 command buffer register as next command.
 *  0b0010-0b1110..Select corresponding CMD command buffer register as next command
 *  0b1111..Select CMD15 command buffer register as next command.
 */
#define ADC_CMDH_NEXT(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_CMDH_NEXT_SHIFT)) & ADC_CMDH_NEXT_MASK)
/*! @} */

/* The count of ADC_CMDH */
#define ADC_CMDH_COUNT                           (15U)

/*! @name CV - Compare Value Register */
/*! @{ */
#define ADC_CV_CVL_MASK                          (0xFFFFU)
#define ADC_CV_CVL_SHIFT                         (0U)
/*! CVL - Compare Value Low.
 */
#define ADC_CV_CVL(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVL_SHIFT)) & ADC_CV_CVL_MASK)
#define ADC_CV_CVH_MASK                          (0xFFFF0000U)
#define ADC_CV_CVH_SHIFT                         (16U)
/*! CVH - Compare Value High.
 */
#define ADC_CV_CVH(x)                            (((uint32_t)(((uint32_t)(x)) << ADC_CV_CVH_SHIFT)) & ADC_CV_CVH_MASK)
/*! @} */

/* The count of ADC_CV */
#define ADC_CV_COUNT                             (4U)

/*! @name RESFIFO - ADC Data Result FIFO Register */
/*! @{ */
#define ADC_RESFIFO_D_MASK                       (0xFFFFU)
#define ADC_RESFIFO_D_SHIFT                      (0U)
/*! D - Data result
 */
#define ADC_RESFIFO_D(x)                         (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_D_SHIFT)) & ADC_RESFIFO_D_MASK)
#define ADC_RESFIFO_TSRC_MASK                    (0xF0000U)
#define ADC_RESFIFO_TSRC_SHIFT                   (16U)
/*! TSRC - Trigger Source
 *  0b0000..Trigger source 0 initiated this conversion.
 *  0b0001..Trigger source 1 initiated this conversion.
 *  0b0010-0b1110..Corresponding trigger source initiated this conversion.
 *  0b1111..Trigger source 15 initiated this conversion.
 */
#define ADC_RESFIFO_TSRC(x)                      (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_TSRC_SHIFT)) & ADC_RESFIFO_TSRC_MASK)
#define ADC_RESFIFO_LOOPCNT_MASK                 (0xF00000U)
#define ADC_RESFIFO_LOOPCNT_SHIFT                (20U)
/*! LOOPCNT - Loop count value
 *  0b0000..Result is from initial conversion in command.
 *  0b0001..Result is from second conversion in command.
 *  0b0010-0b1110..Result is from LOOPCNT+1 conversion in command.
 *  0b1111..Result is from 16th conversion in command.
 */
#define ADC_RESFIFO_LOOPCNT(x)                   (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_LOOPCNT_SHIFT)) & ADC_RESFIFO_LOOPCNT_MASK)
#define ADC_RESFIFO_CMDSRC_MASK                  (0xF000000U)
#define ADC_RESFIFO_CMDSRC_SHIFT                 (24U)
/*! CMDSRC - Command Buffer Source
 *  0b0000..Not a valid value CMDSRC value for a dataword in RESFIFO. 0x0 is only found in initial FIFO state
 *          prior to an ADC conversion result dataword being stored to a RESFIFO buffer.
 *  0b0001..CMD1 buffer used as control settings for this conversion.
 *  0b0010-0b1110..Corresponding command buffer used as control settings for this conversion.
 *  0b1111..CMD15 buffer used as control settings for this conversion.
 */
#define ADC_RESFIFO_CMDSRC(x)                    (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_CMDSRC_SHIFT)) & ADC_RESFIFO_CMDSRC_MASK)
#define ADC_RESFIFO_VALID_MASK                   (0x80000000U)
#define ADC_RESFIFO_VALID_SHIFT                  (31U)
/*! VALID - FIFO entry is valid
 *  0b0..FIFO is empty. Discard any read from RESFIFO.
 *  0b1..FIFO record read from RESFIFO is valid.
 */
#define ADC_RESFIFO_VALID(x)                     (((uint32_t)(((uint32_t)(x)) << ADC_RESFIFO_VALID_SHIFT)) & ADC_RESFIFO_VALID_MASK)
/*! @} */

/* The count of ADC_RESFIFO */
#define ADC_RESFIFO_COUNT                        (2U)


/*!
 * @}
 */ /* end of group ADC_Register_Masks */


/* ADC - Peripheral instance base addresses */
/** Peripheral ADC0 base address */
#define ADC0_BASE                                (0x4013A000u)
/** Peripheral ADC0 base pointer */
#define ADC0                                     ((ADC_Type *)ADC0_BASE)
/** Array initializer of ADC peripheral base addresses */
#define ADC_BASE_ADDRS                           { ADC0_BASE }
/** Array initializer of ADC peripheral base pointers */
#define ADC_BASE_PTRS                            { ADC0 }

/*!
 * @}
 */ /* end of group ADC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AIPS Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPS_Peripheral_Access_Layer AIPS Peripheral Access Layer
 * @{
 */

/** AIPS - Register Layout Typedef */
typedef struct {
  __IO uint32_t MPRA;                              /**< Master Privilege Register A, offset: 0x0 */
       uint8_t RESERVED_0[60];
  __IO uint32_t OPACRA;                            /**< Off-Platform Peripheral Access Control Register, offset: 0x40 */
  __IO uint32_t OPACRB;                            /**< Off-Platform Peripheral Access Control Register, offset: 0x44 */
} AIPS_Type;

/* ----------------------------------------------------------------------------
   -- AIPS Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AIPS_Register_Masks AIPS Register Masks
 * @{
 */

/*! @name MPRA - Master Privilege Register A */
/*! @{ */
#define AIPS_MPRA_MPL7_MASK                      (0x1U)
#define AIPS_MPRA_MPL7_SHIFT                     (0U)
/*! MPL7 - Master 7 Privilege Level
 *  0b0..Accesses from this master are forced to user-mode.
 *  0b1..Accesses from this master are not forced to user-mode.
 */
#define AIPS_MPRA_MPL7(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MPL7_SHIFT)) & AIPS_MPRA_MPL7_MASK)
#define AIPS_MPRA_MTW7_MASK                      (0x2U)
#define AIPS_MPRA_MTW7_SHIFT                     (1U)
/*! MTW7 - Master 7 Trusted for Writes
 *  0b0..This master is not trusted for write accesses.
 *  0b1..This master is trusted for write accesses.
 */
#define AIPS_MPRA_MTW7(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MTW7_SHIFT)) & AIPS_MPRA_MTW7_MASK)
#define AIPS_MPRA_MTR7_MASK                      (0x4U)
#define AIPS_MPRA_MTR7_SHIFT                     (2U)
/*! MTR7 - Master 7 Trusted for Read
 *  0b0..This master is not trusted for read accesses.
 *  0b1..This master is trusted for read accesses.
 */
#define AIPS_MPRA_MTR7(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MTR7_SHIFT)) & AIPS_MPRA_MTR7_MASK)
#define AIPS_MPRA_MPL5_MASK                      (0x100U)
#define AIPS_MPRA_MPL5_SHIFT                     (8U)
/*! MPL5 - Master 5 Privilege Level
 *  0b0..Accesses from this master are forced to user-mode.
 *  0b1..Accesses from this master are not forced to user-mode.
 */
#define AIPS_MPRA_MPL5(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MPL5_SHIFT)) & AIPS_MPRA_MPL5_MASK)
#define AIPS_MPRA_MTW5_MASK                      (0x200U)
#define AIPS_MPRA_MTW5_SHIFT                     (9U)
/*! MTW5 - Master 5 Trusted For Writes
 *  0b0..This master is not trusted for write accesses.
 *  0b1..This master is trusted for write accesses.
 */
#define AIPS_MPRA_MTW5(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MTW5_SHIFT)) & AIPS_MPRA_MTW5_MASK)
#define AIPS_MPRA_MTR5_MASK                      (0x400U)
#define AIPS_MPRA_MTR5_SHIFT                     (10U)
/*! MTR5 - Master 5 Trusted For Read
 *  0b0..This master is not trusted for read accesses.
 *  0b1..This master is trusted for read accesses.
 */
#define AIPS_MPRA_MTR5(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MTR5_SHIFT)) & AIPS_MPRA_MTR5_MASK)
#define AIPS_MPRA_MPL4_MASK                      (0x1000U)
#define AIPS_MPRA_MPL4_SHIFT                     (12U)
/*! MPL4 - Master 4 Privilege Level
 *  0b0..Accesses from this master are forced to user-mode.
 *  0b1..Accesses from this master are not forced to user-mode.
 */
#define AIPS_MPRA_MPL4(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MPL4_SHIFT)) & AIPS_MPRA_MPL4_MASK)
#define AIPS_MPRA_MTW4_MASK                      (0x2000U)
#define AIPS_MPRA_MTW4_SHIFT                     (13U)
/*! MTW4 - Master 4 Trusted For Writes
 *  0b0..This master is not trusted for write accesses.
 *  0b1..This master is trusted for write accesses.
 */
#define AIPS_MPRA_MTW4(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MTW4_SHIFT)) & AIPS_MPRA_MTW4_MASK)
#define AIPS_MPRA_MTR4_MASK                      (0x4000U)
#define AIPS_MPRA_MTR4_SHIFT                     (14U)
/*! MTR4 - Master 4 Trusted For Read
 *  0b0..This master is not trusted for read accesses.
 *  0b1..This master is trusted for read accesses.
 */
#define AIPS_MPRA_MTR4(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MTR4_SHIFT)) & AIPS_MPRA_MTR4_MASK)
#define AIPS_MPRA_MPL3_MASK                      (0x10000U)
#define AIPS_MPRA_MPL3_SHIFT                     (16U)
/*! MPL3 - Master 3 Privilege Level
 *  0b0..Accesses from this master are forced to user-mode.
 *  0b1..Accesses from this master are not forced to user-mode.
 */
#define AIPS_MPRA_MPL3(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MPL3_SHIFT)) & AIPS_MPRA_MPL3_MASK)
#define AIPS_MPRA_MTW3_MASK                      (0x20000U)
#define AIPS_MPRA_MTW3_SHIFT                     (17U)
/*! MTW3 - Master 3 Trusted For Writes
 *  0b0..This master is not trusted for write accesses.
 *  0b1..This master is trusted for write accesses.
 */
#define AIPS_MPRA_MTW3(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MTW3_SHIFT)) & AIPS_MPRA_MTW3_MASK)
#define AIPS_MPRA_MTR3_MASK                      (0x40000U)
#define AIPS_MPRA_MTR3_SHIFT                     (18U)
/*! MTR3 - Master 3 Trusted For Read
 *  0b0..This master is not trusted for read accesses.
 *  0b1..This master is trusted for read accesses.
 */
#define AIPS_MPRA_MTR3(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MTR3_SHIFT)) & AIPS_MPRA_MTR3_MASK)
#define AIPS_MPRA_MPL1_MASK                      (0x1000000U)
#define AIPS_MPRA_MPL1_SHIFT                     (24U)
/*! MPL1 - Master 1 Privilege Level
 *  0b0..Accesses from this master are forced to user-mode.
 *  0b1..Accesses from this master are not forced to user-mode.
 */
#define AIPS_MPRA_MPL1(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MPL1_SHIFT)) & AIPS_MPRA_MPL1_MASK)
#define AIPS_MPRA_MTW1_MASK                      (0x2000000U)
#define AIPS_MPRA_MTW1_SHIFT                     (25U)
/*! MTW1 - Master 1 Trusted for Writes
 *  0b0..This master is not trusted for write accesses.
 *  0b1..This master is trusted for write accesses.
 */
#define AIPS_MPRA_MTW1(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MTW1_SHIFT)) & AIPS_MPRA_MTW1_MASK)
#define AIPS_MPRA_MTR1_MASK                      (0x4000000U)
#define AIPS_MPRA_MTR1_SHIFT                     (26U)
/*! MTR1 - Master 1 Trusted for Read
 *  0b0..This master is not trusted for read accesses.
 *  0b1..This master is trusted for read accesses.
 */
#define AIPS_MPRA_MTR1(x)                        (((uint32_t)(((uint32_t)(x)) << AIPS_MPRA_MTR1_SHIFT)) & AIPS_MPRA_MTR1_MASK)
/*! @} */

/*! @name OPACRA - Off-Platform Peripheral Access Control Register */
/*! @{ */
#define AIPS_OPACRA_TP7_MASK                     (0x1U)
#define AIPS_OPACRA_TP7_SHIFT                    (0U)
/*! TP7 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRA_TP7(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_TP7_SHIFT)) & AIPS_OPACRA_TP7_MASK)
#define AIPS_OPACRA_WP7_MASK                     (0x2U)
#define AIPS_OPACRA_WP7_SHIFT                    (1U)
/*! WP7 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRA_WP7(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_WP7_SHIFT)) & AIPS_OPACRA_WP7_MASK)
#define AIPS_OPACRA_SP7_MASK                     (0x4U)
#define AIPS_OPACRA_SP7_SHIFT                    (2U)
/*! SP7 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRA_SP7(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_SP7_SHIFT)) & AIPS_OPACRA_SP7_MASK)
#define AIPS_OPACRA_TP6_MASK                     (0x10U)
#define AIPS_OPACRA_TP6_SHIFT                    (4U)
/*! TP6 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRA_TP6(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_TP6_SHIFT)) & AIPS_OPACRA_TP6_MASK)
#define AIPS_OPACRA_WP6_MASK                     (0x20U)
#define AIPS_OPACRA_WP6_SHIFT                    (5U)
/*! WP6 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRA_WP6(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_WP6_SHIFT)) & AIPS_OPACRA_WP6_MASK)
#define AIPS_OPACRA_SP6_MASK                     (0x40U)
#define AIPS_OPACRA_SP6_SHIFT                    (6U)
/*! SP6 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRA_SP6(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_SP6_SHIFT)) & AIPS_OPACRA_SP6_MASK)
#define AIPS_OPACRA_TP5_MASK                     (0x100U)
#define AIPS_OPACRA_TP5_SHIFT                    (8U)
/*! TP5 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRA_TP5(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_TP5_SHIFT)) & AIPS_OPACRA_TP5_MASK)
#define AIPS_OPACRA_WP5_MASK                     (0x200U)
#define AIPS_OPACRA_WP5_SHIFT                    (9U)
/*! WP5 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRA_WP5(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_WP5_SHIFT)) & AIPS_OPACRA_WP5_MASK)
#define AIPS_OPACRA_SP5_MASK                     (0x400U)
#define AIPS_OPACRA_SP5_SHIFT                    (10U)
/*! SP5 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRA_SP5(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_SP5_SHIFT)) & AIPS_OPACRA_SP5_MASK)
#define AIPS_OPACRA_TP4_MASK                     (0x1000U)
#define AIPS_OPACRA_TP4_SHIFT                    (12U)
/*! TP4 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRA_TP4(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_TP4_SHIFT)) & AIPS_OPACRA_TP4_MASK)
#define AIPS_OPACRA_WP4_MASK                     (0x2000U)
#define AIPS_OPACRA_WP4_SHIFT                    (13U)
/*! WP4 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRA_WP4(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_WP4_SHIFT)) & AIPS_OPACRA_WP4_MASK)
#define AIPS_OPACRA_SP4_MASK                     (0x4000U)
#define AIPS_OPACRA_SP4_SHIFT                    (14U)
/*! SP4 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRA_SP4(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_SP4_SHIFT)) & AIPS_OPACRA_SP4_MASK)
#define AIPS_OPACRA_TP3_MASK                     (0x10000U)
#define AIPS_OPACRA_TP3_SHIFT                    (16U)
/*! TP3 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRA_TP3(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_TP3_SHIFT)) & AIPS_OPACRA_TP3_MASK)
#define AIPS_OPACRA_WP3_MASK                     (0x20000U)
#define AIPS_OPACRA_WP3_SHIFT                    (17U)
/*! WP3 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRA_WP3(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_WP3_SHIFT)) & AIPS_OPACRA_WP3_MASK)
#define AIPS_OPACRA_SP3_MASK                     (0x40000U)
#define AIPS_OPACRA_SP3_SHIFT                    (18U)
/*! SP3 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRA_SP3(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_SP3_SHIFT)) & AIPS_OPACRA_SP3_MASK)
#define AIPS_OPACRA_TP2_MASK                     (0x100000U)
#define AIPS_OPACRA_TP2_SHIFT                    (20U)
/*! TP2 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRA_TP2(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_TP2_SHIFT)) & AIPS_OPACRA_TP2_MASK)
#define AIPS_OPACRA_WP2_MASK                     (0x200000U)
#define AIPS_OPACRA_WP2_SHIFT                    (21U)
/*! WP2 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRA_WP2(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_WP2_SHIFT)) & AIPS_OPACRA_WP2_MASK)
#define AIPS_OPACRA_SP2_MASK                     (0x400000U)
#define AIPS_OPACRA_SP2_SHIFT                    (22U)
/*! SP2 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRA_SP2(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_SP2_SHIFT)) & AIPS_OPACRA_SP2_MASK)
#define AIPS_OPACRA_TP1_MASK                     (0x1000000U)
#define AIPS_OPACRA_TP1_SHIFT                    (24U)
/*! TP1 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRA_TP1(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_TP1_SHIFT)) & AIPS_OPACRA_TP1_MASK)
#define AIPS_OPACRA_WP1_MASK                     (0x2000000U)
#define AIPS_OPACRA_WP1_SHIFT                    (25U)
/*! WP1 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRA_WP1(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_WP1_SHIFT)) & AIPS_OPACRA_WP1_MASK)
#define AIPS_OPACRA_SP1_MASK                     (0x4000000U)
#define AIPS_OPACRA_SP1_SHIFT                    (26U)
/*! SP1 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRA_SP1(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_SP1_SHIFT)) & AIPS_OPACRA_SP1_MASK)
#define AIPS_OPACRA_TP0_MASK                     (0x10000000U)
#define AIPS_OPACRA_TP0_SHIFT                    (28U)
/*! TP0 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRA_TP0(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_TP0_SHIFT)) & AIPS_OPACRA_TP0_MASK)
#define AIPS_OPACRA_WP0_MASK                     (0x20000000U)
#define AIPS_OPACRA_WP0_SHIFT                    (29U)
/*! WP0 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRA_WP0(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_WP0_SHIFT)) & AIPS_OPACRA_WP0_MASK)
#define AIPS_OPACRA_SP0_MASK                     (0x40000000U)
#define AIPS_OPACRA_SP0_SHIFT                    (30U)
/*! SP0 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRA_SP0(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRA_SP0_SHIFT)) & AIPS_OPACRA_SP0_MASK)
/*! @} */

/*! @name OPACRB - Off-Platform Peripheral Access Control Register */
/*! @{ */
#define AIPS_OPACRB_TP7_MASK                     (0x1U)
#define AIPS_OPACRB_TP7_SHIFT                    (0U)
/*! TP7 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRB_TP7(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_TP7_SHIFT)) & AIPS_OPACRB_TP7_MASK)
#define AIPS_OPACRB_WP7_MASK                     (0x2U)
#define AIPS_OPACRB_WP7_SHIFT                    (1U)
/*! WP7 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRB_WP7(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_WP7_SHIFT)) & AIPS_OPACRB_WP7_MASK)
#define AIPS_OPACRB_SP7_MASK                     (0x4U)
#define AIPS_OPACRB_SP7_SHIFT                    (2U)
/*! SP7 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRB_SP7(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_SP7_SHIFT)) & AIPS_OPACRB_SP7_MASK)
#define AIPS_OPACRB_TP4_MASK                     (0x1000U)
#define AIPS_OPACRB_TP4_SHIFT                    (12U)
/*! TP4 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRB_TP4(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_TP4_SHIFT)) & AIPS_OPACRB_TP4_MASK)
#define AIPS_OPACRB_WP4_MASK                     (0x2000U)
#define AIPS_OPACRB_WP4_SHIFT                    (13U)
/*! WP4 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRB_WP4(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_WP4_SHIFT)) & AIPS_OPACRB_WP4_MASK)
#define AIPS_OPACRB_SP4_MASK                     (0x4000U)
#define AIPS_OPACRB_SP4_SHIFT                    (14U)
/*! SP4 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRB_SP4(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_SP4_SHIFT)) & AIPS_OPACRB_SP4_MASK)
#define AIPS_OPACRB_TP3_MASK                     (0x10000U)
#define AIPS_OPACRB_TP3_SHIFT                    (16U)
/*! TP3 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRB_TP3(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_TP3_SHIFT)) & AIPS_OPACRB_TP3_MASK)
#define AIPS_OPACRB_WP3_MASK                     (0x20000U)
#define AIPS_OPACRB_WP3_SHIFT                    (17U)
/*! WP3 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRB_WP3(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_WP3_SHIFT)) & AIPS_OPACRB_WP3_MASK)
#define AIPS_OPACRB_SP3_MASK                     (0x40000U)
#define AIPS_OPACRB_SP3_SHIFT                    (18U)
/*! SP3 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRB_SP3(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_SP3_SHIFT)) & AIPS_OPACRB_SP3_MASK)
#define AIPS_OPACRB_TP2_MASK                     (0x100000U)
#define AIPS_OPACRB_TP2_SHIFT                    (20U)
/*! TP2 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRB_TP2(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_TP2_SHIFT)) & AIPS_OPACRB_TP2_MASK)
#define AIPS_OPACRB_WP2_MASK                     (0x200000U)
#define AIPS_OPACRB_WP2_SHIFT                    (21U)
/*! WP2 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRB_WP2(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_WP2_SHIFT)) & AIPS_OPACRB_WP2_MASK)
#define AIPS_OPACRB_SP2_MASK                     (0x400000U)
#define AIPS_OPACRB_SP2_SHIFT                    (22U)
/*! SP2 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRB_SP2(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_SP2_SHIFT)) & AIPS_OPACRB_SP2_MASK)
#define AIPS_OPACRB_TP1_MASK                     (0x1000000U)
#define AIPS_OPACRB_TP1_SHIFT                    (24U)
/*! TP1 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRB_TP1(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_TP1_SHIFT)) & AIPS_OPACRB_TP1_MASK)
#define AIPS_OPACRB_WP1_MASK                     (0x2000000U)
#define AIPS_OPACRB_WP1_SHIFT                    (25U)
/*! WP1 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRB_WP1(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_WP1_SHIFT)) & AIPS_OPACRB_WP1_MASK)
#define AIPS_OPACRB_SP1_MASK                     (0x4000000U)
#define AIPS_OPACRB_SP1_SHIFT                    (26U)
/*! SP1 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRB_SP1(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_SP1_SHIFT)) & AIPS_OPACRB_SP1_MASK)
#define AIPS_OPACRB_TP0_MASK                     (0x10000000U)
#define AIPS_OPACRB_TP0_SHIFT                    (28U)
/*! TP0 - Trusted Protect
 *  0b0..Accesses from an untrusted master are allowed.
 *  0b1..Accesses from an untrusted master are not allowed.
 */
#define AIPS_OPACRB_TP0(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_TP0_SHIFT)) & AIPS_OPACRB_TP0_MASK)
#define AIPS_OPACRB_WP0_MASK                     (0x20000000U)
#define AIPS_OPACRB_WP0_SHIFT                    (29U)
/*! WP0 - Write Protect
 *  0b0..This peripheral allows write accesses.
 *  0b1..This peripheral is write protected.
 */
#define AIPS_OPACRB_WP0(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_WP0_SHIFT)) & AIPS_OPACRB_WP0_MASK)
#define AIPS_OPACRB_SP0_MASK                     (0x40000000U)
#define AIPS_OPACRB_SP0_SHIFT                    (30U)
/*! SP0 - Supervisor Protect
 *  0b0..This peripheral does not require supervisor privilege level for accesses.
 *  0b1..This peripheral requires supervisor privilege level for accesses.
 */
#define AIPS_OPACRB_SP0(x)                       (((uint32_t)(((uint32_t)(x)) << AIPS_OPACRB_SP0_SHIFT)) & AIPS_OPACRB_SP0_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group AIPS_Register_Masks */


/* AIPS - Peripheral instance base addresses */
/** Peripheral AIPS0 base address */
#define AIPS0_BASE                               (0x40110000u)
/** Peripheral AIPS0 base pointer */
#define AIPS0                                    ((AIPS_Type *)AIPS0_BASE)
/** Peripheral AIPS1 base address */
#define AIPS1_BASE                               (0x40130000u)
/** Peripheral AIPS1 base pointer */
#define AIPS1                                    ((AIPS_Type *)AIPS1_BASE)
/** Array initializer of AIPS peripheral base addresses */
#define AIPS_BASE_ADDRS                          { AIPS0_BASE, AIPS1_BASE }
/** Array initializer of AIPS peripheral base pointers */
#define AIPS_BASE_PTRS                           { AIPS0, AIPS1 }

/*!
 * @}
 */ /* end of group AIPS_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- AXI_SWITCH Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AXI_SWITCH_Peripheral_Access_Layer AXI_SWITCH Peripheral Access Layer
 * @{
 */

/** AXI_SWITCH - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[8];
  __IO uint32_t FN_MOD_BM_ISS;                     /**< Bus Matrix Issuing Functionality Modification., offset: 0x8 */
       uint8_t RESERVED_1[24];
  __IO uint32_t FN_MOD2;                           /**< Bypass Merge, offset: 0x24 */
       uint8_t RESERVED_2[216];
  __IO uint32_t READ_QOS;                          /**< Read channel QoS value, offset: 0x100 */
  __IO uint32_t WRITE_QOS;                         /**< WRITE channel QoS value, offset: 0x104 */
  __IO uint32_t FN_MOD;                            /**< Issuing Functionality Modification, offset: 0x108 */
} AXI_SWITCH_Type;

/* ----------------------------------------------------------------------------
   -- AXI_SWITCH Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup AXI_SWITCH_Register_Masks AXI_SWITCH Register Masks
 * @{
 */

/*! @name FN_MOD_BM_ISS - Bus Matrix Issuing Functionality Modification. */
/*! @{ */
#define AXI_SWITCH_FN_MOD_BM_ISS_FN_MOD_BM_ISS_MASK (0x3U)
#define AXI_SWITCH_FN_MOD_BM_ISS_FN_MOD_BM_ISS_SHIFT (0U)
/*! FN_MOD_BM_ISS - Read channel QoS value
 */
#define AXI_SWITCH_FN_MOD_BM_ISS_FN_MOD_BM_ISS(x) (((uint32_t)(((uint32_t)(x)) << AXI_SWITCH_FN_MOD_BM_ISS_FN_MOD_BM_ISS_SHIFT)) & AXI_SWITCH_FN_MOD_BM_ISS_FN_MOD_BM_ISS_MASK)
/*! @} */

/*! @name FN_MOD2 - Bypass Merge */
/*! @{ */
#define AXI_SWITCH_FN_MOD2_FN_MOD2_MASK          (0x1U)
#define AXI_SWITCH_FN_MOD2_FN_MOD2_SHIFT         (0U)
/*! FN_MOD2 - Bypass Merge
 */
#define AXI_SWITCH_FN_MOD2_FN_MOD2(x)            (((uint32_t)(((uint32_t)(x)) << AXI_SWITCH_FN_MOD2_FN_MOD2_SHIFT)) & AXI_SWITCH_FN_MOD2_FN_MOD2_MASK)
/*! @} */

/*! @name READ_QOS - Read channel QoS value */
/*! @{ */
#define AXI_SWITCH_READ_QOS_READ_QOS_MASK        (0xFU)
#define AXI_SWITCH_READ_QOS_READ_QOS_SHIFT       (0U)
/*! READ_QOS - Read channel QoS value
 */
#define AXI_SWITCH_READ_QOS_READ_QOS(x)          (((uint32_t)(((uint32_t)(x)) << AXI_SWITCH_READ_QOS_READ_QOS_SHIFT)) & AXI_SWITCH_READ_QOS_READ_QOS_MASK)
/*! @} */

/*! @name WRITE_QOS - WRITE channel QoS value */
/*! @{ */
#define AXI_SWITCH_WRITE_QOS_WRITE_QOS_MASK      (0xFU)
#define AXI_SWITCH_WRITE_QOS_WRITE_QOS_SHIFT     (0U)
/*! WRITE_QOS - Write channel QoS value
 */
#define AXI_SWITCH_WRITE_QOS_WRITE_QOS(x)        (((uint32_t)(((uint32_t)(x)) << AXI_SWITCH_WRITE_QOS_WRITE_QOS_SHIFT)) & AXI_SWITCH_WRITE_QOS_WRITE_QOS_MASK)
/*! @} */

/*! @name FN_MOD - Issuing Functionality Modification */
/*! @{ */
#define AXI_SWITCH_FN_MOD_FN_MOD_MASK            (0x3U)
#define AXI_SWITCH_FN_MOD_FN_MOD_SHIFT           (0U)
/*! FN_MOD - Bypass Merge
 */
#define AXI_SWITCH_FN_MOD_FN_MOD(x)              (((uint32_t)(((uint32_t)(x)) << AXI_SWITCH_FN_MOD_FN_MOD_SHIFT)) & AXI_SWITCH_FN_MOD_FN_MOD_MASK)
#define AXI_SWITCH_FN_MOD_WRITE_QOS_MASK         (0x3U)
#define AXI_SWITCH_FN_MOD_WRITE_QOS_SHIFT        (0U)
/*! WRITE_QOS - Write channel QoS value
 */
#define AXI_SWITCH_FN_MOD_WRITE_QOS(x)           (((uint32_t)(((uint32_t)(x)) << AXI_SWITCH_FN_MOD_WRITE_QOS_SHIFT)) & AXI_SWITCH_FN_MOD_WRITE_QOS_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group AXI_SWITCH_Register_Masks */


/* AXI_SWITCH - Peripheral instance base addresses */
/** Peripheral AXI_SWITCH_AMIB base address */
#define AXI_SWITCH_AMIB_BASE                     (0x428EBFC0u)
/** Peripheral AXI_SWITCH_AMIB base pointer */
#define AXI_SWITCH_AMIB                          ((AXI_SWITCH_Type *)AXI_SWITCH_AMIB_BASE)
/** Peripheral AXI_SWITCH_ASIB base address */
#define AXI_SWITCH_ASIB_BASE                     (0x428E9FC0u)
/** Peripheral AXI_SWITCH_ASIB base pointer */
#define AXI_SWITCH_ASIB                          ((AXI_SWITCH_Type *)AXI_SWITCH_ASIB_BASE)
/** Array initializer of AXI_SWITCH peripheral base addresses */
#define AXI_SWITCH_BASE_ADDRS                    { AXI_SWITCH_AMIB_BASE, AXI_SWITCH_ASIB_BASE }
/** Array initializer of AXI_SWITCH peripheral base pointers */
#define AXI_SWITCH_BASE_PTRS                     { AXI_SWITCH_AMIB, AXI_SWITCH_ASIB }

/*!
 * @}
 */ /* end of group AXI_SWITCH_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CACHE64_CTRL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_CTRL_Peripheral_Access_Layer CACHE64_CTRL Peripheral Access Layer
 * @{
 */

/** CACHE64_CTRL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[2048];
  __IO uint32_t CCR;                               /**< Cache control register, offset: 0x800 */
  __IO uint32_t CLCR;                              /**< Cache line control register, offset: 0x804 */
  __IO uint32_t CSAR;                              /**< Cache search address register, offset: 0x808 */
  __IO uint32_t CCVR;                              /**< Cache read/write value register, offset: 0x80C */
  __IO uint32_t CSRR;                              /**< Cache soft reset register, offset: 0x810 */
} CACHE64_CTRL_Type;

/* ----------------------------------------------------------------------------
   -- CACHE64_CTRL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_CTRL_Register_Masks CACHE64_CTRL Register Masks
 * @{
 */

/*! @name CCR - Cache control register */
/*! @{ */
#define CACHE64_CTRL_CCR_ENCACHE_MASK            (0x1U)
#define CACHE64_CTRL_CCR_ENCACHE_SHIFT           (0U)
/*! ENCACHE - Cache enable
 *  0b0..Cache disabled
 *  0b1..Cache enabled
 */
#define CACHE64_CTRL_CCR_ENCACHE(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_ENCACHE_SHIFT)) & CACHE64_CTRL_CCR_ENCACHE_MASK)
#define CACHE64_CTRL_CCR_ENWRBUF_MASK            (0x2U)
#define CACHE64_CTRL_CCR_ENWRBUF_SHIFT           (1U)
/*! ENWRBUF - Enable Write Buffer
 *  0b0..Write buffer disabled
 *  0b1..Write buffer enabled
 */
#define CACHE64_CTRL_CCR_ENWRBUF(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_ENWRBUF_SHIFT)) & CACHE64_CTRL_CCR_ENWRBUF_MASK)
#define CACHE64_CTRL_CCR_INVW0_MASK              (0x1000000U)
#define CACHE64_CTRL_CCR_INVW0_SHIFT             (24U)
/*! INVW0 - Invalidate Way 0
 *  0b0..No operation
 *  0b1..When setting the GO bit, invalidate all lines in way 0.
 */
#define CACHE64_CTRL_CCR_INVW0(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_INVW0_SHIFT)) & CACHE64_CTRL_CCR_INVW0_MASK)
#define CACHE64_CTRL_CCR_PUSHW0_MASK             (0x2000000U)
#define CACHE64_CTRL_CCR_PUSHW0_SHIFT            (25U)
/*! PUSHW0 - Push Way 0
 *  0b0..No operation
 *  0b1..When setting the GO bit, push all modified lines in way 0
 */
#define CACHE64_CTRL_CCR_PUSHW0(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_PUSHW0_SHIFT)) & CACHE64_CTRL_CCR_PUSHW0_MASK)
#define CACHE64_CTRL_CCR_INVW1_MASK              (0x4000000U)
#define CACHE64_CTRL_CCR_INVW1_SHIFT             (26U)
/*! INVW1 - Invalidate Way 1
 *  0b0..No operation
 *  0b1..When setting the GO bit, invalidate all lines in way 1
 */
#define CACHE64_CTRL_CCR_INVW1(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_INVW1_SHIFT)) & CACHE64_CTRL_CCR_INVW1_MASK)
#define CACHE64_CTRL_CCR_PUSHW1_MASK             (0x8000000U)
#define CACHE64_CTRL_CCR_PUSHW1_SHIFT            (27U)
/*! PUSHW1 - Push Way 1
 *  0b0..No operation
 *  0b1..When setting the GO bit, push all modified lines in way 1
 */
#define CACHE64_CTRL_CCR_PUSHW1(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_PUSHW1_SHIFT)) & CACHE64_CTRL_CCR_PUSHW1_MASK)
#define CACHE64_CTRL_CCR_GO_MASK                 (0x80000000U)
#define CACHE64_CTRL_CCR_GO_SHIFT                (31U)
/*! GO - Initiate Cache Command
 *  0b0..Write: no effect. Read: no cache command active.
 *  0b1..Write: initiate command indicated by bits 27-24. Read: cache command active.
 */
#define CACHE64_CTRL_CCR_GO(x)                   (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCR_GO_SHIFT)) & CACHE64_CTRL_CCR_GO_MASK)
/*! @} */

/*! @name CLCR - Cache line control register */
/*! @{ */
#define CACHE64_CTRL_CLCR_LGO_MASK               (0x1U)
#define CACHE64_CTRL_CLCR_LGO_SHIFT              (0U)
/*! LGO - Initiate Cache Line Command
 *  0b0..Write: no effect. Read: no line command active.
 *  0b1..Write: initiate line command indicated by bits 27-24. Read: line command active.
 */
#define CACHE64_CTRL_CLCR_LGO(x)                 (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LGO_SHIFT)) & CACHE64_CTRL_CLCR_LGO_MASK)
#define CACHE64_CTRL_CLCR_CACHEADDR_MASK         (0x3FFCU)
#define CACHE64_CTRL_CLCR_CACHEADDR_SHIFT        (2U)
/*! CACHEADDR - Cache address
 */
#define CACHE64_CTRL_CLCR_CACHEADDR(x)           (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_CACHEADDR_SHIFT)) & CACHE64_CTRL_CLCR_CACHEADDR_MASK)
#define CACHE64_CTRL_CLCR_WSEL_MASK              (0x4000U)
#define CACHE64_CTRL_CLCR_WSEL_SHIFT             (14U)
/*! WSEL - Way select
 *  0b0..Way 0
 *  0b1..Way 1
 */
#define CACHE64_CTRL_CLCR_WSEL(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_WSEL_SHIFT)) & CACHE64_CTRL_CLCR_WSEL_MASK)
#define CACHE64_CTRL_CLCR_TDSEL_MASK             (0x10000U)
#define CACHE64_CTRL_CLCR_TDSEL_SHIFT            (16U)
/*! TDSEL - Tag/Data Select
 *  0b0..Data
 *  0b1..Tag
 */
#define CACHE64_CTRL_CLCR_TDSEL(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_TDSEL_SHIFT)) & CACHE64_CTRL_CLCR_TDSEL_MASK)
#define CACHE64_CTRL_CLCR_LCIVB_MASK             (0x100000U)
#define CACHE64_CTRL_CLCR_LCIVB_SHIFT            (20U)
/*! LCIVB - Line Command Initial Valid Bit
 */
#define CACHE64_CTRL_CLCR_LCIVB(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCIVB_SHIFT)) & CACHE64_CTRL_CLCR_LCIVB_MASK)
#define CACHE64_CTRL_CLCR_LCIMB_MASK             (0x200000U)
#define CACHE64_CTRL_CLCR_LCIMB_SHIFT            (21U)
/*! LCIMB - Line Command Initial Modified Bit
 */
#define CACHE64_CTRL_CLCR_LCIMB(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCIMB_SHIFT)) & CACHE64_CTRL_CLCR_LCIMB_MASK)
#define CACHE64_CTRL_CLCR_LCWAY_MASK             (0x400000U)
#define CACHE64_CTRL_CLCR_LCWAY_SHIFT            (22U)
/*! LCWAY - Line Command Way
 */
#define CACHE64_CTRL_CLCR_LCWAY(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCWAY_SHIFT)) & CACHE64_CTRL_CLCR_LCWAY_MASK)
#define CACHE64_CTRL_CLCR_LCMD_MASK              (0x3000000U)
#define CACHE64_CTRL_CLCR_LCMD_SHIFT             (24U)
/*! LCMD - Line Command
 *  0b00..Search and read or write
 *  0b01..Invalidate
 *  0b10..Push
 *  0b11..Clear
 */
#define CACHE64_CTRL_CLCR_LCMD(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LCMD_SHIFT)) & CACHE64_CTRL_CLCR_LCMD_MASK)
#define CACHE64_CTRL_CLCR_LADSEL_MASK            (0x4000000U)
#define CACHE64_CTRL_CLCR_LADSEL_SHIFT           (26U)
/*! LADSEL - Line Address Select
 *  0b0..Cache address
 *  0b1..Physical address
 */
#define CACHE64_CTRL_CLCR_LADSEL(x)              (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LADSEL_SHIFT)) & CACHE64_CTRL_CLCR_LADSEL_MASK)
#define CACHE64_CTRL_CLCR_LACC_MASK              (0x8000000U)
#define CACHE64_CTRL_CLCR_LACC_SHIFT             (27U)
/*! LACC - Line access type
 *  0b0..Read
 *  0b1..Write
 */
#define CACHE64_CTRL_CLCR_LACC(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CLCR_LACC_SHIFT)) & CACHE64_CTRL_CLCR_LACC_MASK)
/*! @} */

/*! @name CSAR - Cache search address register */
/*! @{ */
#define CACHE64_CTRL_CSAR_LGO_MASK               (0x1U)
#define CACHE64_CTRL_CSAR_LGO_SHIFT              (0U)
/*! LGO - Initiate Cache Line Command
 *  0b0..Write: no effect. Read: no line command active.
 *  0b1..Write: initiate line command indicated by bits CLCR[27:24]. Read: line command active.
 */
#define CACHE64_CTRL_CSAR_LGO(x)                 (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_LGO_SHIFT)) & CACHE64_CTRL_CSAR_LGO_MASK)
#define CACHE64_CTRL_CSAR_PHYADDR27_1_MASK       (0xFFFFFFEU)
#define CACHE64_CTRL_CSAR_PHYADDR27_1_SHIFT      (1U)
/*! PHYADDR27_1 - Physical Address
 */
#define CACHE64_CTRL_CSAR_PHYADDR27_1(x)         (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_PHYADDR27_1_SHIFT)) & CACHE64_CTRL_CSAR_PHYADDR27_1_MASK)
#define CACHE64_CTRL_CSAR_PHYADDR31_29_MASK      (0xE0000000U)
#define CACHE64_CTRL_CSAR_PHYADDR31_29_SHIFT     (29U)
/*! PHYADDR31_29 - Physical Address
 */
#define CACHE64_CTRL_CSAR_PHYADDR31_29(x)        (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSAR_PHYADDR31_29_SHIFT)) & CACHE64_CTRL_CSAR_PHYADDR31_29_MASK)
/*! @} */

/*! @name CCVR - Cache read/write value register */
/*! @{ */
#define CACHE64_CTRL_CCVR_DATA_MASK              (0xFFFFFFFFU)
#define CACHE64_CTRL_CCVR_DATA_SHIFT             (0U)
/*! DATA - Cache read/write Data
 */
#define CACHE64_CTRL_CCVR_DATA(x)                (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CCVR_DATA_SHIFT)) & CACHE64_CTRL_CCVR_DATA_MASK)
/*! @} */

/*! @name CSRR - Cache soft reset register */
/*! @{ */
#define CACHE64_CTRL_CSRR_RESET_MASK             (0x3U)
#define CACHE64_CTRL_CSRR_RESET_SHIFT            (0U)
/*! RESET - Issue soft reset
 */
#define CACHE64_CTRL_CSRR_RESET(x)               (((uint32_t)(((uint32_t)(x)) << CACHE64_CTRL_CSRR_RESET_SHIFT)) & CACHE64_CTRL_CSRR_RESET_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CACHE64_CTRL_Register_Masks */


/* CACHE64_CTRL - Peripheral instance base addresses */
/** Peripheral CACHE64_CTRL0 base address */
#define CACHE64_CTRL0_BASE                       (0x40033000u)
/** Peripheral CACHE64_CTRL0 base pointer */
#define CACHE64_CTRL0                            ((CACHE64_CTRL_Type *)CACHE64_CTRL0_BASE)
/** Peripheral CACHE64_CTRL1 base address */
#define CACHE64_CTRL1_BASE                       (0x40034000u)
/** Peripheral CACHE64_CTRL1 base pointer */
#define CACHE64_CTRL1                            ((CACHE64_CTRL_Type *)CACHE64_CTRL1_BASE)
/** Array initializer of CACHE64_CTRL peripheral base addresses */
#define CACHE64_CTRL_BASE_ADDRS                  { CACHE64_CTRL0_BASE, CACHE64_CTRL1_BASE }
/** Array initializer of CACHE64_CTRL peripheral base pointers */
#define CACHE64_CTRL_BASE_PTRS                   { CACHE64_CTRL0, CACHE64_CTRL1 }
/* Backward compatibility */
#define CACHE64_CTRL_CSAR_PHYADDR_MASK (CACHE64_CTRL_CSAR_PHYADDR27_1_MASK | CACHE64_CTRL_CSAR_PHYADDR31_29_MASK)


/*!
 * @}
 */ /* end of group CACHE64_CTRL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CACHE64_POLSEL Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_POLSEL_Peripheral_Access_Layer CACHE64_POLSEL Peripheral Access Layer
 * @{
 */

/** CACHE64_POLSEL - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[20];
  __IO uint32_t REG0_TOP;                          /**< Region 0 Top Boundary, offset: 0x14 */
  __IO uint32_t REG1_TOP;                          /**< Region 1 Top Boundary, offset: 0x18 */
  __IO uint32_t POLSEL;                            /**< Policy Select, offset: 0x1C */
} CACHE64_POLSEL_Type;

/* ----------------------------------------------------------------------------
   -- CACHE64_POLSEL Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CACHE64_POLSEL_Register_Masks CACHE64_POLSEL Register Masks
 * @{
 */

/*! @name REG0_TOP - Region 0 Top Boundary */
/*! @{ */
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP_MASK    (0x7FFFC00U)
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP_SHIFT   (10U)
/*! REG0_TOP - Upper limit of Region 0
 */
#define CACHE64_POLSEL_REG0_TOP_REG0_TOP(x)      (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_REG0_TOP_REG0_TOP_SHIFT)) & CACHE64_POLSEL_REG0_TOP_REG0_TOP_MASK)
/*! @} */

/*! @name REG1_TOP - Region 1 Top Boundary */
/*! @{ */
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP_MASK    (0x7FFFC00U)
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP_SHIFT   (10U)
/*! REG1_TOP - Upper limit of Region 1
 */
#define CACHE64_POLSEL_REG1_TOP_REG1_TOP(x)      (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_REG1_TOP_REG1_TOP_SHIFT)) & CACHE64_POLSEL_REG1_TOP_REG1_TOP_MASK)
/*! @} */

/*! @name POLSEL - Policy Select */
/*! @{ */
#define CACHE64_POLSEL_POLSEL_REG0_POLICY_MASK   (0x3U)
#define CACHE64_POLSEL_POLSEL_REG0_POLICY_SHIFT  (0U)
/*! REG0_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG0_POLICY(x)     (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG0_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG0_POLICY_MASK)
#define CACHE64_POLSEL_POLSEL_REG1_POLICY_MASK   (0xCU)
#define CACHE64_POLSEL_POLSEL_REG1_POLICY_SHIFT  (2U)
/*! REG1_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG1_POLICY(x)     (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG1_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG1_POLICY_MASK)
#define CACHE64_POLSEL_POLSEL_REG02_POLICY_MASK  (0x30U)
#define CACHE64_POLSEL_POLSEL_REG02_POLICY_SHIFT (4U)
/*! REG02_POLICY - Policy Select for Region 0
 *  0b00..Non-cache
 *  0b01..Write-thru
 *  0b10..Write-back
 *  0b11..Invalid
 */
#define CACHE64_POLSEL_POLSEL_REG02_POLICY(x)    (((uint32_t)(((uint32_t)(x)) << CACHE64_POLSEL_POLSEL_REG02_POLICY_SHIFT)) & CACHE64_POLSEL_POLSEL_REG02_POLICY_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CACHE64_POLSEL_Register_Masks */


/* CACHE64_POLSEL - Peripheral instance base addresses */
/** Peripheral CACHE64_POLSEL0 base address */
#define CACHE64_POLSEL0_BASE                     (0x40033000u)
/** Peripheral CACHE64_POLSEL0 base pointer */
#define CACHE64_POLSEL0                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL0_BASE)
/** Peripheral CACHE64_POLSEL1 base address */
#define CACHE64_POLSEL1_BASE                     (0x40034000u)
/** Peripheral CACHE64_POLSEL1 base pointer */
#define CACHE64_POLSEL1                          ((CACHE64_POLSEL_Type *)CACHE64_POLSEL1_BASE)
/** Array initializer of CACHE64_POLSEL peripheral base addresses */
#define CACHE64_POLSEL_BASE_ADDRS                { CACHE64_POLSEL0_BASE, CACHE64_POLSEL1_BASE }
/** Array initializer of CACHE64_POLSEL peripheral base pointers */
#define CACHE64_POLSEL_BASE_PTRS                 { CACHE64_POLSEL0, CACHE64_POLSEL1 }

/*!
 * @}
 */ /* end of group CACHE64_POLSEL_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CASPER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CASPER_Peripheral_Access_Layer CASPER Peripheral Access Layer
 * @{
 */

/** CASPER - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL0;                             /**< Control 0, offset: 0x0 */
  __IO uint32_t CTRL1;                             /**< Control 1, offset: 0x4 */
  __IO uint32_t LOADER;                            /**< Loader, offset: 0x8 */
  __IO uint32_t STATUS;                            /**< Status, offset: 0xC */
  __IO uint32_t INTENSET;                          /**< Interrupt Enable Set, offset: 0x10 */
  __IO uint32_t INTENCLR;                          /**< Interrupt Enable Clear, offset: 0x14 */
  __I  uint32_t INTSTAT;                           /**< Interrupt status, offset: 0x18 */
       uint8_t RESERVED_0[4];
  __IO uint32_t AREG;                              /**< A Register, offset: 0x20 */
  __IO uint32_t BREG;                              /**< B Register, offset: 0x24 */
  __IO uint32_t CREG;                              /**< C Register, offset: 0x28 */
  __IO uint32_t DREG;                              /**< D Register, offset: 0x2C */
  __IO uint32_t RES0;                              /**< Result Register 0, offset: 0x30 */
  __IO uint32_t RES1;                              /**< Result Register 1, offset: 0x34 */
  __IO uint32_t RES2;                              /**< Result Register 2, offset: 0x38 */
  __IO uint32_t RES3;                              /**< Result Register 3, offset: 0x3C */
       uint8_t RESERVED_1[32];
  __IO uint32_t MASK;                              /**< Mask, offset: 0x60 */
  __IO uint32_t REMASK;                            /**< Remask, offset: 0x64 */
       uint8_t RESERVED_2[24];
  __IO uint32_t LOCK;                              /**< Lock, offset: 0x80 */
} CASPER_Type;

/* ----------------------------------------------------------------------------
   -- CASPER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CASPER_Register_Masks CASPER Register Masks
 * @{
 */

/*! @name CTRL0 - Control 0 */
/*! @{ */
#define CASPER_CTRL0_ABBPAIR_MASK                (0x1U)
#define CASPER_CTRL0_ABBPAIR_SHIFT               (0U)
/*! ABBPAIR - ABOFF Bank Pair
 *  0b0..Bank-pair 0 (1st)
 *  0b1..Bank-pair 1 (2nd)
 */
#define CASPER_CTRL0_ABBPAIR(x)                  (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL0_ABBPAIR_SHIFT)) & CASPER_CTRL0_ABBPAIR_MASK)
#define CASPER_CTRL0_ABOFF_MASK                  (0x4U)
#define CASPER_CTRL0_ABOFF_SHIFT                 (2U)
/*! ABOFF - AB Offset
 */
#define CASPER_CTRL0_ABOFF(x)                    (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL0_ABOFF_SHIFT)) & CASPER_CTRL0_ABOFF_MASK)
#define CASPER_CTRL0_CDBPAIR_MASK                (0x10000U)
#define CASPER_CTRL0_CDBPAIR_SHIFT               (16U)
/*! CDBPAIR - CDOFF Bank Pair
 *  0b0..Bank-pair 0 (1st)
 *  0b1..Bank-pair 1 (2nd)
 */
#define CASPER_CTRL0_CDBPAIR(x)                  (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL0_CDBPAIR_SHIFT)) & CASPER_CTRL0_CDBPAIR_MASK)
#define CASPER_CTRL0_CDOFF_MASK                  (0x1FFC0000U)
#define CASPER_CTRL0_CDOFF_SHIFT                 (18U)
/*! CDOFF - CD Offset
 */
#define CASPER_CTRL0_CDOFF(x)                    (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL0_CDOFF_SHIFT)) & CASPER_CTRL0_CDOFF_MASK)
/*! @} */

/*! @name CTRL1 - Control 1 */
/*! @{ */
#define CASPER_CTRL1_ITER_MASK                   (0xFFU)
#define CASPER_CTRL1_ITER_SHIFT                  (0U)
/*! ITER - Interation Counter
 */
#define CASPER_CTRL1_ITER(x)                     (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_ITER_SHIFT)) & CASPER_CTRL1_ITER_MASK)
#define CASPER_CTRL1_MODE_MASK                   (0xFF00U)
#define CASPER_CTRL1_MODE_SHIFT                  (8U)
/*! MODE - Mode
 */
#define CASPER_CTRL1_MODE(x)                     (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_MODE_SHIFT)) & CASPER_CTRL1_MODE_MASK)
#define CASPER_CTRL1_RESBPAIR_MASK               (0x10000U)
#define CASPER_CTRL1_RESBPAIR_SHIFT              (16U)
/*! RESBPAIR - RESOFF Bank Pair
 *  0b0..Bank-pair 0 (1st)
 *  0b1..Bank-pair 1 (2nd)
 */
#define CASPER_CTRL1_RESBPAIR(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_RESBPAIR_SHIFT)) & CASPER_CTRL1_RESBPAIR_MASK)
#define CASPER_CTRL1_RESOFF_MASK                 (0x1FFC0000U)
#define CASPER_CTRL1_RESOFF_SHIFT                (18U)
/*! RESOFF - Result Offset
 */
#define CASPER_CTRL1_RESOFF(x)                   (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_RESOFF_SHIFT)) & CASPER_CTRL1_RESOFF_MASK)
#define CASPER_CTRL1_CSKIP_MASK                  (0xC0000000U)
#define CASPER_CTRL1_CSKIP_SHIFT                 (30U)
/*! CSKIP - Skip Rules on Carry
 *  0b00..No Skip
 *  0b01..Skip if Carry is 1
 *  0b10..Skip if Carry is 0
 *  0b11..Set CTRLOFF to CDOFF and Skip
 */
#define CASPER_CTRL1_CSKIP(x)                    (((uint32_t)(((uint32_t)(x)) << CASPER_CTRL1_CSKIP_SHIFT)) & CASPER_CTRL1_CSKIP_MASK)
/*! @} */

/*! @name LOADER - Loader */
/*! @{ */
#define CASPER_LOADER_COUNT_MASK                 (0xFFU)
#define CASPER_LOADER_COUNT_SHIFT                (0U)
/*! COUNT - Count
 */
#define CASPER_LOADER_COUNT(x)                   (((uint32_t)(((uint32_t)(x)) << CASPER_LOADER_COUNT_SHIFT)) & CASPER_LOADER_COUNT_MASK)
#define CASPER_LOADER_CTRLBPAIR_MASK             (0x10000U)
#define CASPER_LOADER_CTRLBPAIR_SHIFT            (16U)
/*! CTRLBPAIR - Control Bank Pair
 *  0b0..Bank-pair 0 (1st)
 *  0b1..Bank-pair 1 (2nd)
 */
#define CASPER_LOADER_CTRLBPAIR(x)               (((uint32_t)(((uint32_t)(x)) << CASPER_LOADER_CTRLBPAIR_SHIFT)) & CASPER_LOADER_CTRLBPAIR_MASK)
#define CASPER_LOADER_CTRLOFF_MASK               (0x1FFC0000U)
#define CASPER_LOADER_CTRLOFF_SHIFT              (18U)
/*! CTRLOFF - Control Offset
 */
#define CASPER_LOADER_CTRLOFF(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_LOADER_CTRLOFF_SHIFT)) & CASPER_LOADER_CTRLOFF_MASK)
/*! @} */

/*! @name STATUS - Status */
/*! @{ */
#define CASPER_STATUS_DONE_MASK                  (0x1U)
#define CASPER_STATUS_DONE_SHIFT                 (0U)
/*! DONE - Done
 *  0b0..Busy or just cleared
 *  0b1..Completed last operation
 */
#define CASPER_STATUS_DONE(x)                    (((uint32_t)(((uint32_t)(x)) << CASPER_STATUS_DONE_SHIFT)) & CASPER_STATUS_DONE_MASK)
#define CASPER_STATUS_CARRY_MASK                 (0x10U)
#define CASPER_STATUS_CARRY_SHIFT                (4U)
/*! CARRY - Carry
 *  0b0..Carry was 0 or no carry
 *  0b1..Carry was 1
 */
#define CASPER_STATUS_CARRY(x)                   (((uint32_t)(((uint32_t)(x)) << CASPER_STATUS_CARRY_SHIFT)) & CASPER_STATUS_CARRY_MASK)
#define CASPER_STATUS_BUSY_MASK                  (0x20U)
#define CASPER_STATUS_BUSY_SHIFT                 (5U)
/*! BUSY - Busy
 *  0b0..Not busy - is idle
 *  0b1..Is busy
 */
#define CASPER_STATUS_BUSY(x)                    (((uint32_t)(((uint32_t)(x)) << CASPER_STATUS_BUSY_SHIFT)) & CASPER_STATUS_BUSY_MASK)
/*! @} */

/*! @name INTENSET - Interrupt Enable Set */
/*! @{ */
#define CASPER_INTENSET_DONE_MASK                (0x1U)
#define CASPER_INTENSET_DONE_SHIFT               (0U)
/*! DONE - Done
 *  0b0..Do not interrupt when done
 *  0b1..Interrupt when done
 */
#define CASPER_INTENSET_DONE(x)                  (((uint32_t)(((uint32_t)(x)) << CASPER_INTENSET_DONE_SHIFT)) & CASPER_INTENSET_DONE_MASK)
/*! @} */

/*! @name INTENCLR - Interrupt Enable Clear */
/*! @{ */
#define CASPER_INTENCLR_DONE_MASK                (0x1U)
#define CASPER_INTENCLR_DONE_SHIFT               (0U)
/*! DONE - Done
 *  0b0..If written 0, ignored
 *  0b1..If written 1, do not interrupt when done.
 */
#define CASPER_INTENCLR_DONE(x)                  (((uint32_t)(((uint32_t)(x)) << CASPER_INTENCLR_DONE_SHIFT)) & CASPER_INTENCLR_DONE_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt status */
/*! @{ */
#define CASPER_INTSTAT_DONE_MASK                 (0x1U)
#define CASPER_INTSTAT_DONE_SHIFT                (0U)
/*! DONE
 *  0b0..Not caused by accelerator being done
 *  0b1..Caused by accelerator being done
 */
#define CASPER_INTSTAT_DONE(x)                   (((uint32_t)(((uint32_t)(x)) << CASPER_INTSTAT_DONE_SHIFT)) & CASPER_INTSTAT_DONE_MASK)
/*! @} */

/*! @name AREG - A Register */
/*! @{ */
#define CASPER_AREG_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_AREG_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register Value
 */
#define CASPER_AREG_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_AREG_REG_VALUE_SHIFT)) & CASPER_AREG_REG_VALUE_MASK)
/*! @} */

/*! @name BREG - B Register */
/*! @{ */
#define CASPER_BREG_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_BREG_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register Value
 */
#define CASPER_BREG_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_BREG_REG_VALUE_SHIFT)) & CASPER_BREG_REG_VALUE_MASK)
/*! @} */

/*! @name CREG - C Register */
/*! @{ */
#define CASPER_CREG_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_CREG_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register Value
 */
#define CASPER_CREG_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_CREG_REG_VALUE_SHIFT)) & CASPER_CREG_REG_VALUE_MASK)
/*! @} */

/*! @name DREG - D Register */
/*! @{ */
#define CASPER_DREG_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_DREG_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register Value
 */
#define CASPER_DREG_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_DREG_REG_VALUE_SHIFT)) & CASPER_DREG_REG_VALUE_MASK)
/*! @} */

/*! @name RES0 - Result Register 0 */
/*! @{ */
#define CASPER_RES0_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_RES0_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register Value
 */
#define CASPER_RES0_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_RES0_REG_VALUE_SHIFT)) & CASPER_RES0_REG_VALUE_MASK)
/*! @} */

/*! @name RES1 - Result Register 1 */
/*! @{ */
#define CASPER_RES1_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_RES1_REG_VALUE_SHIFT              (0U)
#define CASPER_RES1_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_RES1_REG_VALUE_SHIFT)) & CASPER_RES1_REG_VALUE_MASK)
/*! @} */

/*! @name RES2 - Result Register 2 */
/*! @{ */
#define CASPER_RES2_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_RES2_REG_VALUE_SHIFT              (0U)
/*! REG_VALUE - Register Value
 */
#define CASPER_RES2_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_RES2_REG_VALUE_SHIFT)) & CASPER_RES2_REG_VALUE_MASK)
/*! @} */

/*! @name RES3 - Result Register 3 */
/*! @{ */
#define CASPER_RES3_REG_VALUE_MASK               (0xFFFFFFFFU)
#define CASPER_RES3_REG_VALUE_SHIFT              (0U)
#define CASPER_RES3_REG_VALUE(x)                 (((uint32_t)(((uint32_t)(x)) << CASPER_RES3_REG_VALUE_SHIFT)) & CASPER_RES3_REG_VALUE_MASK)
/*! @} */

/*! @name MASK - Mask */
/*! @{ */
#define CASPER_MASK_MASK_MASK                    (0xFFFFFFFFU)
#define CASPER_MASK_MASK_SHIFT                   (0U)
/*! MASK - Mask
 */
#define CASPER_MASK_MASK(x)                      (((uint32_t)(((uint32_t)(x)) << CASPER_MASK_MASK_SHIFT)) & CASPER_MASK_MASK_MASK)
/*! @} */

/*! @name REMASK - Remask */
/*! @{ */
#define CASPER_REMASK_MASK_MASK                  (0xFFFFFFFFU)
#define CASPER_REMASK_MASK_SHIFT                 (0U)
/*! MASK - Mask
 */
#define CASPER_REMASK_MASK(x)                    (((uint32_t)(((uint32_t)(x)) << CASPER_REMASK_MASK_SHIFT)) & CASPER_REMASK_MASK_MASK)
/*! @} */

/*! @name LOCK - Lock */
/*! @{ */
#define CASPER_LOCK_LOCK_MASK                    (0x1U)
#define CASPER_LOCK_LOCK_SHIFT                   (0U)
/*! LOCK - Lock
 *  0b0..Unlock
 *  0b1..Lock to current security level
 */
#define CASPER_LOCK_LOCK(x)                      (((uint32_t)(((uint32_t)(x)) << CASPER_LOCK_LOCK_SHIFT)) & CASPER_LOCK_LOCK_MASK)
#define CASPER_LOCK_KEY_MASK                     (0x1FFF0U)
#define CASPER_LOCK_KEY_SHIFT                    (4U)
/*! KEY - Key
 *  0b0011100111101..Key Value
 */
#define CASPER_LOCK_KEY(x)                       (((uint32_t)(((uint32_t)(x)) << CASPER_LOCK_KEY_SHIFT)) & CASPER_LOCK_KEY_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CASPER_Register_Masks */


/* CASPER - Peripheral instance base addresses */
/** Peripheral CASPER base address */
#define CASPER_BASE                              (0x40201000u)
/** Peripheral CASPER base pointer */
#define CASPER                                   ((CASPER_Type *)CASPER_BASE)
/** Array initializer of CASPER peripheral base addresses */
#define CASPER_BASE_ADDRS                        { CASPER_BASE }
/** Array initializer of CASPER peripheral base pointers */
#define CASPER_BASE_PTRS                         { CASPER }

/*!
 * @}
 */ /* end of group CASPER_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CLKCTL0 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CLKCTL0_Peripheral_Access_Layer CLKCTL0 Peripheral Access Layer
 * @{
 */

/** CLKCTL0 - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t PSCCTL0;                           /**< Clock Control 0, offset: 0x10 */
  __IO uint32_t PSCCTL1;                           /**< Clock Control 1, offset: 0x14 */
  __IO uint32_t PSCCTL2;                           /**< Clock Control 2, offset: 0x18 */
       uint8_t RESERVED_1[36];
  __O  uint32_t PSCCTL0_SET;                       /**< Clock Control 0 Set, offset: 0x40 */
  __O  uint32_t PSCCTL1_SET;                       /**< Clock Control 1 Set, offset: 0x44 */
  __O  uint32_t PSCCTL2_SET;                       /**< Clock Control 2 Set, offset: 0x48 */
       uint8_t RESERVED_2[36];
  __O  uint32_t PSCCTL0_CLR;                       /**< Clock Control 0 Clear, offset: 0x70 */
  __O  uint32_t PSCCTL1_CLR;                       /**< Clock Control 1 Clear, offset: 0x74 */
  __O  uint32_t PSCCTL2_CLR;                       /**< Clock Control 2 Clear, offset: 0x78 */
       uint8_t RESERVED_3[4];
  __IO uint32_t FRO_CONTROL;                       /**< Free Running Oscillator Control, offset: 0x80 */
  __I  uint32_t FRO_CAPVAL;                        /**< Free Running Oscillator Captured Value, offset: 0x84 */
       uint8_t RESERVED_4[4];
  __IO uint32_t FRO_RDTRIM;                        /**< Free Running Oscillator Trim, offset: 0x8C */
       uint8_t RESERVED_5[120];
  __IO uint32_t FRODIVSEL;                         /**< FRO Clock Divider, offset: 0x108 */
  __I  uint32_t FROCLKSTATUS;                      /**< FRO Clock Status, offset: 0x10C */
  __IO uint32_t FRODIVOEN;                         /**< FRO Enable Register, offset: 0x110 */
       uint8_t RESERVED_6[28];
  __IO uint32_t LOWFREQCLKDIV;                     /**< Low Frequency Clock Divider, offset: 0x130 */
       uint8_t RESERVED_7[44];
  __IO uint32_t SYSOSCCTL0;                        /**< System Oscillator Control 0, offset: 0x160 */
       uint8_t RESERVED_8[4];
  __IO uint32_t SYSOSCBYPASS;                      /**< OSC Clock Source Select, offset: 0x168 */
       uint8_t RESERVED_9[36];
  __IO uint32_t LPOSCCTL0;                         /**< Low Power Oscillator Control 0, offset: 0x190 */
       uint8_t RESERVED_10[44];
  __IO uint32_t OSC32KHZCTL0;                      /**< 32 KHz Oscillator Control 0, offset: 0x1C0 */
       uint8_t RESERVED_11[60];
  __IO uint32_t SYSPLL0CLKSEL;                     /**< System PLL 0 Clock Select, offset: 0x200 */
  __IO uint32_t SYSPLL0CTL0;                       /**< System PLL0 Control 0, offset: 0x204 */
       uint8_t RESERVED_12[4];
  __IO uint32_t SYSPLL0LOCKTIMEDIV2;               /**< System PLL0 Lock Time Div2, offset: 0x20C */
  __IO uint32_t SYSPLL0NUM;                        /**< System PLL0 Numerator, offset: 0x210 */
  __IO uint32_t SYSPLL0DENOM;                      /**< System PLL0 Denominator, offset: 0x214 */
  __IO uint32_t SYSPLL0PFD;                        /**< System PLL0 PFD, offset: 0x218 */
       uint8_t RESERVED_13[484];
  __IO uint32_t SYSCPUAHBCLKDIV;                   /**< System CPU AHB Clock Divider, offset: 0x400 */
       uint8_t RESERVED_14[44];
  __IO uint32_t MAINCLKSELA;                       /**< Main Clock Select A, offset: 0x430 */
  __IO uint32_t MAINCLKSELB;                       /**< Main Clock Select B, offset: 0x434 */
       uint8_t RESERVED_15[200];
  __IO uint32_t PFCDIV[2];                         /**< PFC0DIV..PFC1DIV, array offset: 0x500, array step: 0x4 */
       uint8_t RESERVED_16[280];
  __IO uint32_t FLEXSPI0FCLKSEL;                   /**< FlexSPI0 Functional Clock Select, offset: 0x620 */
  __IO uint32_t FLEXSPI0FCLKDIV;                   /**< FlexSPI0 Functional Clock Divider, offset: 0x624 */
       uint8_t RESERVED_17[8];
  __IO uint32_t FLEXSPI1FCLKSEL;                   /**< FlexSPI1 Functional Clock Select, offset: 0x630 */
  __IO uint32_t FLEXSPI1FCLKDIV;                   /**< FlexSPI1 Functional Clock Divider, offset: 0x634 */
       uint8_t RESERVED_18[8];
  __IO uint32_t SCTFCLKSEL;                        /**< SCT Functional Clock Select, offset: 0x640 */
  __IO uint32_t SCTIN7CLKDIV;                      /**< SCT Functional Clock Divider, offset: 0x644 */
       uint8_t RESERVED_19[24];
  __IO uint32_t USBHSFCLKSEL;                      /**< High Speed USB Functional Clock Select, offset: 0x660 */
  __IO uint32_t USBHSFCLKDIV;                      /**< High Speed USB Functional Clock Divider, offset: 0x664 */
       uint8_t RESERVED_20[24];
  __IO uint32_t SDIO0FCLKSEL;                      /**< SDIO0 Functional Clock Select, offset: 0x680 */
  __IO uint32_t SDIO0FCLKDIV;                      /**< SDIO0 Functional Clock Divider, offset: 0x684 */
       uint8_t RESERVED_21[8];
  __IO uint32_t SDIO1FCLKSEL;                      /**< SDIO1 Functional Clock Select, offset: 0x690 */
  __IO uint32_t SDIO1FCLKDIV;                      /**< SDIO1 Functional Clock Divider, offset: 0x694 */
       uint8_t RESERVED_22[56];
  __IO uint32_t ADC0FCLKSEL0;                      /**< ADC0 Functional Clock Select 0, offset: 0x6D0 */
  __IO uint32_t ADC0FCLKSEL1;                      /**< ADC0 Functional Clock Select 1, offset: 0x6D4 */
  __IO uint32_t ADC0FCLKDIV;                       /**< ADC0 Functional Clock Divider, offset: 0x6D8 */
       uint8_t RESERVED_23[36];
  __IO uint32_t UTICKFCLKSEL;                      /**< UTICK Functional Clock Select, offset: 0x700 */
       uint8_t RESERVED_24[28];
  __IO uint32_t WDT0FCLKSEL;                       /**< WDT0 Functional Clock Select, offset: 0x720 */
       uint8_t RESERVED_25[12];
  __IO uint32_t A32KHZWAKECLKSEL;                  /**< 32 KHz Wake Clock Source Select, offset: 0x730 */
  __IO uint32_t A32KHZWAKECLKDIV;                  /**< 32 KHz Wake Clock Divider, offset: 0x734 */
       uint8_t RESERVED_26[40];
  __IO uint32_t SYSTICKFCLKSEL;                    /**< SYSTICK Functional Clock Select, offset: 0x760 */
  __IO uint32_t SYSTICKFCLKDIV;                    /**< SYSTICK Functional Clock Divider, offset: 0x764 */
       uint8_t RESERVED_27[8];
  __IO uint32_t DPHYCLKSEL;                        /**< MIPI-DSI PHY Clock Select, offset: 0x770 */
  __IO uint32_t DPHYCLKDIV;                        /**< MIPI-DSI PHY Clock Divider, offset: 0x774 */
  __IO uint32_t DPHYESCCLKSEL;                     /**< MIPI-DSI DPHY Escape Mode Clock Select, offset: 0x778 */
  __IO uint32_t DPHYESCRXCLKDIV;                   /**< MIPI-DSI DPHY Escape Mode Receive Clock Divider, offset: 0x77C */
  __IO uint32_t DPHYESCTXCLKDIV;                   /**< MIPI-DSI DPHY Escape Mode Tramsmit Clock Divider, offset: 0x780 */
       uint8_t RESERVED_28[12];
  __IO uint32_t GPUCLKSEL;                         /**< GPU Clock Select, offset: 0x790 */
  __IO uint32_t GPUCLKDIV;                         /**< GPU Clock Divider, offset: 0x794 */
       uint8_t RESERVED_29[8];
  __IO uint32_t DCPIXELCLKSEL;                     /**< LCDIF Pixel Clock Select, offset: 0x7A0 */
  __IO uint32_t DCPIXELCLKDIV;                     /**< LCDIF Pixel Clock Divider, offset: 0x7A4 */
} CLKCTL0_Type;

/* ----------------------------------------------------------------------------
   -- CLKCTL0 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CLKCTL0_Register_Masks CLKCTL0 Register Masks
 * @{
 */

/*! @name PSCCTL0 - Clock Control 0 */
/*! @{ */
#define CLKCTL0_PSCCTL0_DSP_CLK_MASK             (0x2U)
#define CLKCTL0_PSCCTL0_DSP_CLK_SHIFT            (1U)
/*! DSP_CLK - DSP clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_DSP_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_DSP_CLK_SHIFT)) & CLKCTL0_PSCCTL0_DSP_CLK_MASK)
#define CLKCTL0_PSCCTL0_ROM_CTRLR_CLK_MASK       (0x4U)
#define CLKCTL0_PSCCTL0_ROM_CTRLR_CLK_SHIFT      (2U)
/*! ROM_CTRLR_CLK - 128KB ROM Controller clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_ROM_CTRLR_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_ROM_CTRLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_ROM_CTRLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_AXI_SWITCH_CLK_MASK      (0x8U)
#define CLKCTL0_PSCCTL0_AXI_SWITCH_CLK_SHIFT     (3U)
/*! AXI_SWITCH_CLK - AXI Switch clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_AXI_SWITCH_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_AXI_SWITCH_CLK_SHIFT)) & CLKCTL0_PSCCTL0_AXI_SWITCH_CLK_MASK)
#define CLKCTL0_PSCCTL0_AXI_CTLR_CLK_MASK        (0x10U)
#define CLKCTL0_PSCCTL0_AXI_CTLR_CLK_SHIFT       (4U)
/*! AXI_CTLR_CLK - AXI Controller clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_AXI_CTLR_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_AXI_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_AXI_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_POWERQUAD_CLK_MASK       (0x100U)
#define CLKCTL0_PSCCTL0_POWERQUAD_CLK_SHIFT      (8U)
/*! POWERQUAD_CLK - POWERQUAD clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_POWERQUAD_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_POWERQUAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_POWERQUAD_CLK_MASK)
#define CLKCTL0_PSCCTL0_CASPER_CLK_MASK          (0x200U)
#define CLKCTL0_PSCCTL0_CASPER_CLK_SHIFT         (9U)
/*! CASPER_CLK - CASPER clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_CASPER_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CASPER_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CASPER_CLK_MASK)
#define CLKCTL0_PSCCTL0_HASHCRYPT_CLK_MASK       (0x400U)
#define CLKCTL0_PSCCTL0_HASHCRYPT_CLK_SHIFT      (10U)
/*! HASHCRYPT_CLK - HASHCRYPT clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_HASHCRYPT_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_HASHCRYPT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_HASHCRYPT_CLK_MASK)
#define CLKCTL0_PSCCTL0_PUF_CLK_MASK             (0x800U)
#define CLKCTL0_PSCCTL0_PUF_CLK_SHIFT            (11U)
/*! PUF_CLK - PUF clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_PUF_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_PUF_CLK_SHIFT)) & CLKCTL0_PSCCTL0_PUF_CLK_MASK)
#define CLKCTL0_PSCCTL0_RNG_CLK_MASK             (0x1000U)
#define CLKCTL0_PSCCTL0_RNG_CLK_SHIFT            (12U)
/*! RNG_CLK - Random Number Generator (RNG) clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_RNG_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_RNG_CLK_SHIFT)) & CLKCTL0_PSCCTL0_RNG_CLK_MASK)
#define CLKCTL0_PSCCTL0_FLEXSPI0_OTFAD_CLK_MASK  (0x10000U)
#define CLKCTL0_PSCCTL0_FLEXSPI0_OTFAD_CLK_SHIFT (16U)
/*! FLEXSPI0_OTFAD_CLK - FLEXSPI0 / OTFAD clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_FLEXSPI0_OTFAD_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_FLEXSPI0_OTFAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_FLEXSPI0_OTFAD_CLK_MASK)
#define CLKCTL0_PSCCTL0_OTP_CTLR_CLK_MASK        (0x20000U)
#define CLKCTL0_PSCCTL0_OTP_CTLR_CLK_SHIFT       (17U)
/*! OTP_CTLR_CLK - OTP Controller clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_OTP_CTLR_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_OTP_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_OTP_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_FLEXSPI1_CLK_MASK        (0x40000U)
#define CLKCTL0_PSCCTL0_FLEXSPI1_CLK_SHIFT       (18U)
/*! FLEXSPI1_CLK - FLEXSPI1 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_FLEXSPI1_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_FLEXSPI1_CLK_SHIFT)) & CLKCTL0_PSCCTL0_FLEXSPI1_CLK_MASK)
#define CLKCTL0_PSCCTL0_USBHS_PHY_CLK_MASK       (0x100000U)
#define CLKCTL0_PSCCTL0_USBHS_PHY_CLK_SHIFT      (20U)
/*! USBHS_PHY_CLK - USB HS PHY clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_USBHS_PHY_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_USBHS_PHY_CLK_SHIFT)) & CLKCTL0_PSCCTL0_USBHS_PHY_CLK_MASK)
#define CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK_MASK    (0x200000U)
#define CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK_SHIFT   (21U)
/*! USBHS_DEVICE_CLK - USB HS Device clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK_SHIFT)) & CLKCTL0_PSCCTL0_USBHS_DEVICE_CLK_MASK)
#define CLKCTL0_PSCCTL0_USBHS_HOST_CLK_MASK      (0x400000U)
#define CLKCTL0_PSCCTL0_USBHS_HOST_CLK_SHIFT     (22U)
/*! USBHS_HOST_CLK - USB HS Host clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_USBHS_HOST_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_USBHS_HOST_CLK_SHIFT)) & CLKCTL0_PSCCTL0_USBHS_HOST_CLK_MASK)
#define CLKCTL0_PSCCTL0_USBHS_SRAM_CLK_MASK      (0x800000U)
#define CLKCTL0_PSCCTL0_USBHS_SRAM_CLK_SHIFT     (23U)
/*! USBHS_SRAM_CLK - USB HS SRAM clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_USBHS_SRAM_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_USBHS_SRAM_CLK_SHIFT)) & CLKCTL0_PSCCTL0_USBHS_SRAM_CLK_MASK)
#define CLKCTL0_PSCCTL0_SCT_CLK_MASK             (0x1000000U)
#define CLKCTL0_PSCCTL0_SCT_CLK_SHIFT            (24U)
/*! SCT_CLK - SCT clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_SCT_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SCT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SCT_CLK_MASK)
#define CLKCTL0_PSCCTL0_GPU_CLK_MASK             (0x4000000U)
#define CLKCTL0_PSCCTL0_GPU_CLK_SHIFT            (26U)
/*! GPU_CLK - GPU clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_GPU_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_GPU_CLK_SHIFT)) & CLKCTL0_PSCCTL0_GPU_CLK_MASK)
#define CLKCTL0_PSCCTL0_DISPLAY_CTLR_CLK_MASK    (0x8000000U)
#define CLKCTL0_PSCCTL0_DISPLAY_CTLR_CLK_SHIFT   (27U)
/*! DISPLAY_CTLR_CLK - Display Controller clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_DISPLAY_CTLR_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_DISPLAY_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_DISPLAY_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_MIPI_DSI_CTLR_CLK_MASK   (0x10000000U)
#define CLKCTL0_PSCCTL0_MIPI_DSI_CTLR_CLK_SHIFT  (28U)
/*! MIPI_DSI_CTLR_CLK - MIPI-DSI Controller clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_MIPI_DSI_CTLR_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_MIPI_DSI_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_MIPI_DSI_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_SMARTDMA_CLK_MASK        (0x40000000U)
#define CLKCTL0_PSCCTL0_SMARTDMA_CLK_SHIFT       (30U)
/*! SMARTDMA_CLK - Smart DMA clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL0_SMARTDMA_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SMARTDMA_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SMARTDMA_CLK_MASK)
/*! @} */

/*! @name PSCCTL1 - Clock Control 1 */
/*! @{ */
#define CLKCTL0_PSCCTL1_SDIO0_CLK_MASK           (0x4U)
#define CLKCTL0_PSCCTL1_SDIO0_CLK_SHIFT          (2U)
/*! SDIO0_CLK - SDIO0 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL1_SDIO0_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SDIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SDIO0_CLK_MASK)
#define CLKCTL0_PSCCTL1_SDIO1_CLK_MASK           (0x8U)
#define CLKCTL0_PSCCTL1_SDIO1_CLK_SHIFT          (3U)
/*! SDIO1_CLK - SDIO1 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL1_SDIO1_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SDIO1_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SDIO1_CLK_MASK)
#define CLKCTL0_PSCCTL1_ACMP0_CLK_MASK           (0x8000U)
#define CLKCTL0_PSCCTL1_ACMP0_CLK_SHIFT          (15U)
/*! ACMP0_CLK - ACMP0 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL1_ACMP0_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_ACMP0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_ACMP0_CLK_MASK)
#define CLKCTL0_PSCCTL1_ADC0_CLK_MASK            (0x10000U)
#define CLKCTL0_PSCCTL1_ADC0_CLK_SHIFT           (16U)
/*! ADC0_CLK - ADC0 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL1_ADC0_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_ADC0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_ADC0_CLK_MASK)
#define CLKCTL0_PSCCTL1_SHSGPIO0_CLK_MASK        (0x1000000U)
#define CLKCTL0_PSCCTL1_SHSGPIO0_CLK_SHIFT       (24U)
/*! SHSGPIO0_CLK - SHSGPIO0 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL1_SHSGPIO0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SHSGPIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SHSGPIO0_CLK_MASK)
/*! @} */

/*! @name PSCCTL2 - Clock Control 2 */
/*! @{ */
#define CLKCTL0_PSCCTL2_UTICK0_CLK_MASK          (0x1U)
#define CLKCTL0_PSCCTL2_UTICK0_CLK_SHIFT         (0U)
/*! UTICK0_CLK - Micro-Tick Timer 0 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL2_UTICK0_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_UTICK0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_UTICK0_CLK_MASK)
#define CLKCTL0_PSCCTL2_WWDT0_CLK_MASK           (0x2U)
#define CLKCTL0_PSCCTL2_WWDT0_CLK_SHIFT          (1U)
/*! WWDT0_CLK - Watchdog Timer 0 clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL2_WWDT0_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_WWDT0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_WWDT0_CLK_MASK)
#define CLKCTL0_PSCCTL2_PMC_CLK_MASK             (0x20000000U)
#define CLKCTL0_PSCCTL2_PMC_CLK_SHIFT            (29U)
/*! PMC_CLK - Power Management Controller clock control
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_PSCCTL2_PMC_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_PMC_CLK_SHIFT)) & CLKCTL0_PSCCTL2_PMC_CLK_MASK)
/*! @} */

/*! @name PSCCTL0_SET - Clock Control 0 Set */
/*! @{ */
#define CLKCTL0_PSCCTL0_SET_DSP_CLK_MASK         (0x2U)
#define CLKCTL0_PSCCTL0_SET_DSP_CLK_SHIFT        (1U)
/*! DSP_CLK - DSP clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_DSP_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_DSP_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_DSP_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_ROM_CTRLR_CLK_MASK   (0x4U)
#define CLKCTL0_PSCCTL0_SET_ROM_CTRLR_CLK_SHIFT  (2U)
/*! ROM_CTRLR_CLK - 128KB ROM Controller clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_ROM_CTRLR_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_ROM_CTRLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_ROM_CTRLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_AXI_SWITCH_CLK_MASK  (0x8U)
#define CLKCTL0_PSCCTL0_SET_AXI_SWITCH_CLK_SHIFT (3U)
/*! AXI_SWITCH_CLK - AXI Switch clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_AXI_SWITCH_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_AXI_SWITCH_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_AXI_SWITCH_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_AXI_CTLR_CLK_MASK    (0x10U)
#define CLKCTL0_PSCCTL0_SET_AXI_CTLR_CLK_SHIFT   (4U)
/*! AXI_CTLR_CLK - AXI Controller clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_AXI_CTLR_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_AXI_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_AXI_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK_MASK   (0x100U)
#define CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK_SHIFT  (8U)
/*! POWERQUAD_CLK - POWERQUAD clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_POWERQUAD_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_CASPER_CLK_MASK      (0x200U)
#define CLKCTL0_PSCCTL0_SET_CASPER_CLK_SHIFT     (9U)
/*! CASPER_CLK - CASPER clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_CASPER_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_CASPER_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_CASPER_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK_MASK   (0x400U)
#define CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK_SHIFT  (10U)
/*! HASHCRYPT_CLK - HASHCRYPT clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_HASHCRYPT_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_PUF_CLK_MASK         (0x800U)
#define CLKCTL0_PSCCTL0_SET_PUF_CLK_SHIFT        (11U)
/*! PUF_CLK - PUF clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_PUF_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_PUF_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_PUF_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_RNG_CLK_MASK         (0x1000U)
#define CLKCTL0_PSCCTL0_SET_RNG_CLK_SHIFT        (12U)
/*! RNG_CLK - Random Number Generator (RNG) clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_RNG_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_RNG_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_RNG_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_FLEXSPI0_OTFAD_CLK_MASK (0x10000U)
#define CLKCTL0_PSCCTL0_SET_FLEXSPI0_OTFAD_CLK_SHIFT (16U)
/*! FLEXSPI0_OTFAD_CLK - FLEXSPI0 / OTFAD clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_FLEXSPI0_OTFAD_CLK(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_FLEXSPI0_OTFAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_FLEXSPI0_OTFAD_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_OTP_CTLR_CLK_MASK    (0x20000U)
#define CLKCTL0_PSCCTL0_SET_OTP_CTLR_CLK_SHIFT   (17U)
/*! OTP_CTLR_CLK - OTP Controller clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_OTP_CTLR_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_OTP_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_OTP_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_FLEXSPI1_CLK_MASK    (0x40000U)
#define CLKCTL0_PSCCTL0_SET_FLEXSPI1_CLK_SHIFT   (18U)
/*! FLEXSPI1_CLK - FLEXSPI1 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_FLEXSPI1_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_FLEXSPI1_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_FLEXSPI1_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK_MASK   (0x100000U)
#define CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK_SHIFT  (20U)
/*! USBHS_PHY_CLK - USB HS PHY clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_USBHS_PHY_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK_MASK (0x200000U)
#define CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK_SHIFT (21U)
/*! USBHS_DEVICE_CLK - USB HS Device clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_USBHS_DEVICE_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK_MASK  (0x400000U)
#define CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK_SHIFT (22U)
/*! USBHS_HOST_CLK - USB HS Host clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_USBHS_HOST_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK_MASK  (0x800000U)
#define CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK_SHIFT (23U)
/*! USBHS_SRAM_CLK - USB HS SRAM clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_USBHS_SRAM_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_SCT_CLK_MASK         (0x1000000U)
#define CLKCTL0_PSCCTL0_SET_SCT_CLK_SHIFT        (24U)
/*! SCT_CLK - SCT clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_SCT_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_SCT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_SCT_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_GPU_CLK_MASK         (0x4000000U)
#define CLKCTL0_PSCCTL0_SET_GPU_CLK_SHIFT        (26U)
/*! GPU_CLK - GPU clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_GPU_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_GPU_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_GPU_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_DISPLAY_CTLR_CLK_MASK (0x8000000U)
#define CLKCTL0_PSCCTL0_SET_DISPLAY_CTLR_CLK_SHIFT (27U)
/*! DISPLAY_CTLR_CLK - Display Controller clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_DISPLAY_CTLR_CLK(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_DISPLAY_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_DISPLAY_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_MIPI_DSI_CTLR_CLK_MASK (0x10000000U)
#define CLKCTL0_PSCCTL0_SET_MIPI_DSI_CTLR_CLK_SHIFT (28U)
/*! MIPI_DSI_CTLR_CLK - MIPI-DSI Controller clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_MIPI_DSI_CTLR_CLK(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_MIPI_DSI_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_MIPI_DSI_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_SET_SMARTDMA_CLK_MASK    (0x40000000U)
#define CLKCTL0_PSCCTL0_SET_SMARTDMA_CLK_SHIFT   (30U)
/*! SMARTDMA_CLK - Smart DMA clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_SET_SMARTDMA_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_SET_SMARTDMA_CLK_SHIFT)) & CLKCTL0_PSCCTL0_SET_SMARTDMA_CLK_MASK)
/*! @} */

/*! @name PSCCTL1_SET - Clock Control 1 Set */
/*! @{ */
#define CLKCTL0_PSCCTL1_SET_SDIO0_CLK_MASK       (0x4U)
#define CLKCTL0_PSCCTL1_SET_SDIO0_CLK_SHIFT      (2U)
/*! SDIO0_CLK - SDIO0 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_SET_SDIO0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_SDIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_SDIO0_CLK_MASK)
#define CLKCTL0_PSCCTL1_SET_SDIO1_CLK_MASK       (0x8U)
#define CLKCTL0_PSCCTL1_SET_SDIO1_CLK_SHIFT      (3U)
/*! SDIO1_CLK - SDIO1 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_SET_SDIO1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_SDIO1_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_SDIO1_CLK_MASK)
#define CLKCTL0_PSCCTL1_SET_ACMP0_CLK_MASK       (0x8000U)
#define CLKCTL0_PSCCTL1_SET_ACMP0_CLK_SHIFT      (15U)
/*! ACMP0_CLK - ACMP0 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_SET_ACMP0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_ACMP0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_ACMP0_CLK_MASK)
#define CLKCTL0_PSCCTL1_SET_ADC0_CLK_MASK        (0x10000U)
#define CLKCTL0_PSCCTL1_SET_ADC0_CLK_SHIFT       (16U)
/*! ADC0_CLK - ADC0 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_SET_ADC0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_ADC0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_ADC0_CLK_MASK)
#define CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK_MASK    (0x1000000U)
#define CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK_SHIFT   (24U)
/*! SHSGPIO0_CLK - SHSGPIO0 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_SET_SHSGPIO0_CLK_MASK)
/*! @} */

/*! @name PSCCTL2_SET - Clock Control 2 Set */
/*! @{ */
#define CLKCTL0_PSCCTL2_SET_UTICK0_CLK_MASK      (0x1U)
#define CLKCTL0_PSCCTL2_SET_UTICK0_CLK_SHIFT     (0U)
/*! UTICK0_CLK - Micro-Tick Timer 0 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL2 register
 */
#define CLKCTL0_PSCCTL2_SET_UTICK0_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_SET_UTICK0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_SET_UTICK0_CLK_MASK)
#define CLKCTL0_PSCCTL2_SET_WWDT0_CLK_MASK       (0x2U)
#define CLKCTL0_PSCCTL2_SET_WWDT0_CLK_SHIFT      (1U)
/*! WWDT0_CLK - Watchdog Timer 0 clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL2 register
 */
#define CLKCTL0_PSCCTL2_SET_WWDT0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_SET_WWDT0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_SET_WWDT0_CLK_MASK)
#define CLKCTL0_PSCCTL2_SET_PMC_MASK             (0x20000000U)
#define CLKCTL0_PSCCTL2_SET_PMC_SHIFT            (29U)
/*! PMC - Power Management Controller clock set
 *  0b0..No effect
 *  0b1..Sets the corresponding bit in PSCCTL2 register
 */
#define CLKCTL0_PSCCTL2_SET_PMC(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_SET_PMC_SHIFT)) & CLKCTL0_PSCCTL2_SET_PMC_MASK)
/*! @} */

/*! @name PSCCTL0_CLR - Clock Control 0 Clear */
/*! @{ */
#define CLKCTL0_PSCCTL0_CLR_DSP_CLK_MASK         (0x2U)
#define CLKCTL0_PSCCTL0_CLR_DSP_CLK_SHIFT        (1U)
/*! DSP_CLK - DSP clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_DSP_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_DSP_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_DSP_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_ROM_CTRLR_CLK_MASK   (0x4U)
#define CLKCTL0_PSCCTL0_CLR_ROM_CTRLR_CLK_SHIFT  (2U)
/*! ROM_CTRLR_CLK - 128KB ROM Controller clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_ROM_CTRLR_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_ROM_CTRLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_ROM_CTRLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_AXI_SWITCH_CLK_MASK  (0x8U)
#define CLKCTL0_PSCCTL0_CLR_AXI_SWITCH_CLK_SHIFT (3U)
/*! AXI_SWITCH_CLK - AXI Switch clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_AXI_SWITCH_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_AXI_SWITCH_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_AXI_SWITCH_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_AXI_CTLR_CLK_MASK    (0x10U)
#define CLKCTL0_PSCCTL0_CLR_AXI_CTLR_CLK_SHIFT   (4U)
/*! AXI_CTLR_CLK - AXI Controller clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_AXI_CTLR_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_AXI_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_AXI_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK_MASK   (0x100U)
#define CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK_SHIFT  (8U)
/*! POWERQUAD_CLK - POWERQUAD clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_POWERQUAD_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_CASPER_CLK_MASK      (0x200U)
#define CLKCTL0_PSCCTL0_CLR_CASPER_CLK_SHIFT     (9U)
/*! CASPER_CLK - CASPER clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_CASPER_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_CASPER_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_CASPER_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK_MASK   (0x400U)
#define CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK_SHIFT  (10U)
/*! HASHCRYPT_CLK - HASHCRYPT clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_HASHCRYPT_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_PUF_CLK_MASK         (0x800U)
#define CLKCTL0_PSCCTL0_CLR_PUF_CLK_SHIFT        (11U)
/*! PUF_CLK - PUF clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_PUF_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_PUF_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_PUF_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_RNG_CLK_MASK         (0x1000U)
#define CLKCTL0_PSCCTL0_CLR_RNG_CLK_SHIFT        (12U)
/*! RNG_CLK - RNG clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_RNG_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_RNG_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_RNG_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI0_OTFAD_CLK_MASK (0x10000U)
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI0_OTFAD_CLK_SHIFT (16U)
/*! FLEXSPI0_OTFAD_CLK - FLEXSPI0 / OTFAD clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI0_OTFAD_CLK(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_FLEXSPI0_OTFAD_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_FLEXSPI0_OTFAD_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_OTP_CTLR_CLK_MASK    (0x20000U)
#define CLKCTL0_PSCCTL0_CLR_OTP_CTLR_CLK_SHIFT   (17U)
/*! OTP_CTLR_CLK - OTP Controller clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_OTP_CTLR_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_OTP_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_OTP_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI1_CLK_MASK    (0x40000U)
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI1_CLK_SHIFT   (18U)
/*! FLEXSPI1_CLK - FLEXSPI1 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_FLEXSPI1_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_FLEXSPI1_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_FLEXSPI1_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK_MASK   (0x100000U)
#define CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK_SHIFT  (20U)
/*! USBHS_PHY_CLK - USB HS PHY clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_USBHS_PHY_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK_MASK (0x200000U)
#define CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK_SHIFT (21U)
/*! USBHS_DEVICE_CLK - USB HS Device clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_USBHS_DEVICE_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK_MASK  (0x400000U)
#define CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK_SHIFT (22U)
/*! USBHS_HOST_CLK - USB HS Host clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_USBHS_HOST_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK_MASK  (0x800000U)
#define CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK_SHIFT (23U)
/*! USBHS_SRAM_CLK - USB HS SRAM clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK(x)    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_USBHS_SRAM_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_SCT_CLK_MASK         (0x1000000U)
#define CLKCTL0_PSCCTL0_CLR_SCT_CLK_SHIFT        (24U)
/*! SCT_CLK - SCT clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_SCT_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_SCT_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_SCT_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_GPU_CLK_MASK         (0x4000000U)
#define CLKCTL0_PSCCTL0_CLR_GPU_CLK_SHIFT        (26U)
/*! GPU_CLK - GPU clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_GPU_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_GPU_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_GPU_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_DISPLAY_CTLR_CLK_MASK (0x8000000U)
#define CLKCTL0_PSCCTL0_CLR_DISPLAY_CTLR_CLK_SHIFT (27U)
/*! DISPLAY_CTLR_CLK - Display Controller clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_DISPLAY_CTLR_CLK(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_DISPLAY_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_DISPLAY_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_MIPI_DSI_CTLR_CLK_MASK (0x10000000U)
#define CLKCTL0_PSCCTL0_CLR_MIPI_DSI_CTLR_CLK_SHIFT (28U)
/*! MIPI_DSI_CTLR_CLK - MIPI-DSI Controller clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_MIPI_DSI_CTLR_CLK(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_MIPI_DSI_CTLR_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_MIPI_DSI_CTLR_CLK_MASK)
#define CLKCTL0_PSCCTL0_CLR_SMARTDMA_CLK_MASK    (0x40000000U)
#define CLKCTL0_PSCCTL0_CLR_SMARTDMA_CLK_SHIFT   (30U)
/*! SMARTDMA_CLK - Smart DMA clock set
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL0 register
 */
#define CLKCTL0_PSCCTL0_CLR_SMARTDMA_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL0_CLR_SMARTDMA_CLK_SHIFT)) & CLKCTL0_PSCCTL0_CLR_SMARTDMA_CLK_MASK)
/*! @} */

/*! @name PSCCTL1_CLR - Clock Control 1 Clear */
/*! @{ */
#define CLKCTL0_PSCCTL1_CLR_SDIO0_CLK_MASK       (0x4U)
#define CLKCTL0_PSCCTL1_CLR_SDIO0_CLK_SHIFT      (2U)
/*! SDIO0_CLK - SDIO0 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_CLR_SDIO0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_SDIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_SDIO0_CLK_MASK)
#define CLKCTL0_PSCCTL1_CLR_SDIO1_CLK_MASK       (0x8U)
#define CLKCTL0_PSCCTL1_CLR_SDIO1_CLK_SHIFT      (3U)
/*! SDIO1_CLK - SDIO1 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_CLR_SDIO1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_SDIO1_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_SDIO1_CLK_MASK)
#define CLKCTL0_PSCCTL1_CLR_ACMP0_CLK_MASK       (0x8000U)
#define CLKCTL0_PSCCTL1_CLR_ACMP0_CLK_SHIFT      (15U)
/*! ACMP0_CLK - ACMP0 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_CLR_ACMP0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_ACMP0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_ACMP0_CLK_MASK)
#define CLKCTL0_PSCCTL1_CLR_ADC0_CLK_MASK        (0x10000U)
#define CLKCTL0_PSCCTL1_CLR_ADC0_CLK_SHIFT       (16U)
/*! ADC0_CLK - ADC0 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_CLR_ADC0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_ADC0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_ADC0_CLK_MASK)
#define CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK_MASK    (0x1000000U)
#define CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK_SHIFT   (24U)
/*! SHSGPIO0_CLK - SHSGPIO0 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL1 register
 */
#define CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK_SHIFT)) & CLKCTL0_PSCCTL1_CLR_SHSGPIO0_CLK_MASK)
/*! @} */

/*! @name PSCCTL2_CLR - Clock Control 2 Clear */
/*! @{ */
#define CLKCTL0_PSCCTL2_CLR_UTICK0_CLK_MASK      (0x1U)
#define CLKCTL0_PSCCTL2_CLR_UTICK0_CLK_SHIFT     (0U)
/*! UTICK0_CLK - Micro-Tick Timer 0 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL2 register
 */
#define CLKCTL0_PSCCTL2_CLR_UTICK0_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_CLR_UTICK0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_CLR_UTICK0_CLK_MASK)
#define CLKCTL0_PSCCTL2_CLR_WWDT0_CLK_MASK       (0x2U)
#define CLKCTL0_PSCCTL2_CLR_WWDT0_CLK_SHIFT      (1U)
/*! WWDT0_CLK - Watchdog Timer 0 clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL2 register
 */
#define CLKCTL0_PSCCTL2_CLR_WWDT0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_CLR_WWDT0_CLK_SHIFT)) & CLKCTL0_PSCCTL2_CLR_WWDT0_CLK_MASK)
#define CLKCTL0_PSCCTL2_CLR_PMC_CLK_MASK         (0x20000000U)
#define CLKCTL0_PSCCTL2_CLR_PMC_CLK_SHIFT        (29U)
/*! PMC_CLK - Power Management Controller clock clear
 *  0b0..No effect
 *  0b1..Clears the corresponding bit in PSCCTL2 register
 */
#define CLKCTL0_PSCCTL2_CLR_PMC_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PSCCTL2_CLR_PMC_CLK_SHIFT)) & CLKCTL0_PSCCTL2_CLR_PMC_CLK_MASK)
/*! @} */

/*! @name FRO_CONTROL - Free Running Oscillator Control */
/*! @{ */
#define CLKCTL0_FRO_CONTROL_EXP_COUNT_MASK       (0xFFFFU)
#define CLKCTL0_FRO_CONTROL_EXP_COUNT_SHIFT      (0U)
/*! EXP_COUNT - Expected Count
 */
#define CLKCTL0_FRO_CONTROL_EXP_COUNT(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_CONTROL_EXP_COUNT_SHIFT)) & CLKCTL0_FRO_CONTROL_EXP_COUNT_MASK)
#define CLKCTL0_FRO_CONTROL_THRESH_RANGE_UP_MASK (0x1F0000U)
#define CLKCTL0_FRO_CONTROL_THRESH_RANGE_UP_SHIFT (16U)
/*! THRESH_RANGE_UP - Threshold Range Upper Limit
 */
#define CLKCTL0_FRO_CONTROL_THRESH_RANGE_UP(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_CONTROL_THRESH_RANGE_UP_SHIFT)) & CLKCTL0_FRO_CONTROL_THRESH_RANGE_UP_MASK)
#define CLKCTL0_FRO_CONTROL_THRESH_RANGE_LOW_MASK (0x3E00000U)
#define CLKCTL0_FRO_CONTROL_THRESH_RANGE_LOW_SHIFT (21U)
/*! THRESH_RANGE_LOW - Threshold Range Lower Limit
 */
#define CLKCTL0_FRO_CONTROL_THRESH_RANGE_LOW(x)  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_CONTROL_THRESH_RANGE_LOW_SHIFT)) & CLKCTL0_FRO_CONTROL_THRESH_RANGE_LOW_MASK)
#define CLKCTL0_FRO_CONTROL_ENA_TUNE_MASK        (0x80000000U)
#define CLKCTL0_FRO_CONTROL_ENA_TUNE_SHIFT       (31U)
/*! ENA_TUNE - Enable Tuning
 *  0b0..Stop tuning
 *  0b1..Start tuning
 */
#define CLKCTL0_FRO_CONTROL_ENA_TUNE(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_CONTROL_ENA_TUNE_SHIFT)) & CLKCTL0_FRO_CONTROL_ENA_TUNE_MASK)
/*! @} */

/*! @name FRO_CAPVAL - Free Running Oscillator Captured Value */
/*! @{ */
#define CLKCTL0_FRO_CAPVAL_CAPVAL_MASK           (0xFFFFU)
#define CLKCTL0_FRO_CAPVAL_CAPVAL_SHIFT          (0U)
/*! CAPVAL - Captured Value
 */
#define CLKCTL0_FRO_CAPVAL_CAPVAL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_CAPVAL_CAPVAL_SHIFT)) & CLKCTL0_FRO_CAPVAL_CAPVAL_MASK)
#define CLKCTL0_FRO_CAPVAL_DATA_VALID_MASK       (0x80000000U)
#define CLKCTL0_FRO_CAPVAL_DATA_VALID_SHIFT      (31U)
/*! DATA_VALID - Data Valid
 *  0b0..CAPVAL data is not valid
 *  0b1..CAPVAL data is valid
 */
#define CLKCTL0_FRO_CAPVAL_DATA_VALID(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_CAPVAL_DATA_VALID_SHIFT)) & CLKCTL0_FRO_CAPVAL_DATA_VALID_MASK)
/*! @} */

/*! @name FRO_RDTRIM - Free Running Oscillator Trim */
/*! @{ */
#define CLKCTL0_FRO_RDTRIM_TRIM_MASK             (0x7FFU)
#define CLKCTL0_FRO_RDTRIM_TRIM_SHIFT            (0U)
/*! TRIM - It is the trim value supplied to the oscillator
 */
#define CLKCTL0_FRO_RDTRIM_TRIM(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRO_RDTRIM_TRIM_SHIFT)) & CLKCTL0_FRO_RDTRIM_TRIM_MASK)
/*! @} */

/*! @name FRODIVSEL - FRO Clock Divider */
/*! @{ */
#define CLKCTL0_FRODIVSEL_SEL_MASK               (0x3U)
#define CLKCTL0_FRODIVSEL_SEL_SHIFT              (0U)
/*! SEL - Select clock
 *  0b00..FRO Clock Divided by 2
 *  0b01..FRO Clock Divided by 4
 *  0b10..FRO Clock Divided by 8
 *  0b11..FRO Clock Divided by 16
 */
#define CLKCTL0_FRODIVSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRODIVSEL_SEL_SHIFT)) & CLKCTL0_FRODIVSEL_SEL_MASK)
/*! @} */

/*! @name FROCLKSTATUS - FRO Clock Status */
/*! @{ */
#define CLKCTL0_FROCLKSTATUS_CLK_OK_MASK         (0x1U)
#define CLKCTL0_FROCLKSTATUS_CLK_OK_SHIFT        (0U)
/*! CLK_OK - FRO Clock OK
 *  0b0..FRO clock has not yet reached its final frequency
 *  0b1..FRO clock has reached its final frequency
 */
#define CLKCTL0_FROCLKSTATUS_CLK_OK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FROCLKSTATUS_CLK_OK_SHIFT)) & CLKCTL0_FROCLKSTATUS_CLK_OK_MASK)
/*! @} */

/*! @name FRODIVOEN - FRO Enable Register */
/*! @{ */
#define CLKCTL0_FRODIVOEN_FRO_DIV1_O_EN_MASK     (0x1U)
#define CLKCTL0_FRODIVOEN_FRO_DIV1_O_EN_SHIFT    (0U)
/*! FRO_DIV1_O_EN - FRO Divided-by-1 Clock Enable
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_FRODIVOEN_FRO_DIV1_O_EN(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRODIVOEN_FRO_DIV1_O_EN_SHIFT)) & CLKCTL0_FRODIVOEN_FRO_DIV1_O_EN_MASK)
#define CLKCTL0_FRODIVOEN_FRO_DIV2_O_EN_MASK     (0x2U)
#define CLKCTL0_FRODIVOEN_FRO_DIV2_O_EN_SHIFT    (1U)
/*! FRO_DIV2_O_EN - FRO Divided-by-2 Clock Enable
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_FRODIVOEN_FRO_DIV2_O_EN(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRODIVOEN_FRO_DIV2_O_EN_SHIFT)) & CLKCTL0_FRODIVOEN_FRO_DIV2_O_EN_MASK)
#define CLKCTL0_FRODIVOEN_FRO_DIV4_O_EN_MASK     (0x4U)
#define CLKCTL0_FRODIVOEN_FRO_DIV4_O_EN_SHIFT    (2U)
/*! FRO_DIV4_O_EN - FRO Divided-by-4 Clock Enable
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_FRODIVOEN_FRO_DIV4_O_EN(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRODIVOEN_FRO_DIV4_O_EN_SHIFT)) & CLKCTL0_FRODIVOEN_FRO_DIV4_O_EN_MASK)
#define CLKCTL0_FRODIVOEN_FRO_DIV8_O_EN_MASK     (0x8U)
#define CLKCTL0_FRODIVOEN_FRO_DIV8_O_EN_SHIFT    (3U)
/*! FRO_DIV8_O_EN - FRO Divided-by-8 Clock Enable
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_FRODIVOEN_FRO_DIV8_O_EN(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRODIVOEN_FRO_DIV8_O_EN_SHIFT)) & CLKCTL0_FRODIVOEN_FRO_DIV8_O_EN_MASK)
#define CLKCTL0_FRODIVOEN_FRO_DIV16_O_EN_MASK    (0x10U)
#define CLKCTL0_FRODIVOEN_FRO_DIV16_O_EN_SHIFT   (4U)
/*! FRO_DIV16_O_EN - FRO Divided-by-16 Clock Enable
 *  0b0..Disable clock
 *  0b1..Enable clock
 */
#define CLKCTL0_FRODIVOEN_FRO_DIV16_O_EN(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FRODIVOEN_FRO_DIV16_O_EN_SHIFT)) & CLKCTL0_FRODIVOEN_FRO_DIV16_O_EN_MASK)
/*! @} */

/*! @name LOWFREQCLKDIV - Low Frequency Clock Divider */
/*! @{ */
#define CLKCTL0_LOWFREQCLKDIV_DIV_MASK           (0xFFU)
#define CLKCTL0_LOWFREQCLKDIV_DIV_SHIFT          (0U)
/*! DIV - Low Frequency Clock Divider Value
 */
#define CLKCTL0_LOWFREQCLKDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_LOWFREQCLKDIV_DIV_SHIFT)) & CLKCTL0_LOWFREQCLKDIV_DIV_MASK)
#define CLKCTL0_LOWFREQCLKDIV_RESET_MASK         (0x20000000U)
#define CLKCTL0_LOWFREQCLKDIV_RESET_SHIFT        (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_LOWFREQCLKDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_LOWFREQCLKDIV_RESET_SHIFT)) & CLKCTL0_LOWFREQCLKDIV_RESET_MASK)
#define CLKCTL0_LOWFREQCLKDIV_HALT_MASK          (0x40000000U)
#define CLKCTL0_LOWFREQCLKDIV_HALT_SHIFT         (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_LOWFREQCLKDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_LOWFREQCLKDIV_HALT_SHIFT)) & CLKCTL0_LOWFREQCLKDIV_HALT_MASK)
#define CLKCTL0_LOWFREQCLKDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL0_LOWFREQCLKDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished
 *  0b1..The Divider value has changed
 */
#define CLKCTL0_LOWFREQCLKDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_LOWFREQCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_LOWFREQCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SYSOSCCTL0 - System Oscillator Control 0 */
/*! @{ */
#define CLKCTL0_SYSOSCCTL0_LP_ENABLE_MASK        (0x1U)
#define CLKCTL0_SYSOSCCTL0_LP_ENABLE_SHIFT       (0U)
/*! LP_ENABLE - Low Power Mode Enable
 *  0b0..Enable High Gain Mode (HP)
 *  0b1..Enable Low Power mode (LP)
 */
#define CLKCTL0_SYSOSCCTL0_LP_ENABLE(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSOSCCTL0_LP_ENABLE_SHIFT)) & CLKCTL0_SYSOSCCTL0_LP_ENABLE_MASK)
#define CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE_MASK    (0x2U)
#define CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE_SHIFT   (1U)
/*! BYPASS_ENABLE - Bypass Enable
 *  0b0..Enable Normal mode. Oscillation with crystal connected.
 *  0b1..Enable Bypass mode. In this mode a clock can be directly input into the XTALIN pin.
 */
#define CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE_SHIFT)) & CLKCTL0_SYSOSCCTL0_BYPASS_ENABLE_MASK)
/*! @} */

/*! @name SYSOSCBYPASS - OSC Clock Source Select */
/*! @{ */
#define CLKCTL0_SYSOSCBYPASS_SEL_MASK            (0x7U)
#define CLKCTL0_SYSOSCBYPASS_SEL_SHIFT           (0U)
/*! SEL - Select SYSOSC Bypass
 *  0b000..Select OSC Clock
 *  0b001..Select Clock IN clock
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed
 */
#define CLKCTL0_SYSOSCBYPASS_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSOSCBYPASS_SEL_SHIFT)) & CLKCTL0_SYSOSCBYPASS_SEL_MASK)
/*! @} */

/*! @name LPOSCCTL0 - Low Power Oscillator Control 0 */
/*! @{ */
#define CLKCTL0_LPOSCCTL0_CLKRDY_MASK            (0x80000000U)
#define CLKCTL0_LPOSCCTL0_CLKRDY_SHIFT           (31U)
/*! CLKRDY - LPOSC Clock Ready
 *  0b0..LPOSC clock is not ready
 *  0b1..LPOSC clock is ready
 */
#define CLKCTL0_LPOSCCTL0_CLKRDY(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_LPOSCCTL0_CLKRDY_SHIFT)) & CLKCTL0_LPOSCCTL0_CLKRDY_MASK)
/*! @} */

/*! @name OSC32KHZCTL0 - 32 KHz Oscillator Control 0 */
/*! @{ */
#define CLKCTL0_OSC32KHZCTL0_ENA32KHZ_MASK       (0x1U)
#define CLKCTL0_OSC32KHZCTL0_ENA32KHZ_SHIFT      (0U)
/*! ENA32KHZ - 32 KHz Oscillator Enable
 *  0b0..Disable oscillator
 *  0b1..Enable oscillator
 */
#define CLKCTL0_OSC32KHZCTL0_ENA32KHZ(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_OSC32KHZCTL0_ENA32KHZ_SHIFT)) & CLKCTL0_OSC32KHZCTL0_ENA32KHZ_MASK)
/*! @} */

/*! @name SYSPLL0CLKSEL - System PLL 0 Clock Select */
/*! @{ */
#define CLKCTL0_SYSPLL0CLKSEL_SEL_MASK           (0x7U)
#define CLKCTL0_SYSPLL0CLKSEL_SEL_SHIFT          (0U)
/*! SEL - System PLL0 Reference Input Clock Source
 *  0b000..FRO Clock (Divided-by-8 selection)
 *  0b001..OSC_CLK clock
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL0_SYSPLL0CLKSEL_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CLKSEL_SEL_SHIFT)) & CLKCTL0_SYSPLL0CLKSEL_SEL_MASK)
/*! @} */

/*! @name SYSPLL0CTL0 - System PLL0 Control 0 */
/*! @{ */
#define CLKCTL0_SYSPLL0CTL0_BYPASS_MASK          (0x1U)
#define CLKCTL0_SYSPLL0CTL0_BYPASS_SHIFT         (0U)
/*! BYPASS - SYSPLL0 BYPASS Mode
 *  0b0..PFD outputs are PFD-programmed clocks
 *  0b1..Bypass Mode: PFD outputs are sourced directly from rhe reference input clock
 */
#define CLKCTL0_SYSPLL0CTL0_BYPASS(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CTL0_BYPASS_SHIFT)) & CLKCTL0_SYSPLL0CTL0_BYPASS_MASK)
#define CLKCTL0_SYSPLL0CTL0_RESET_MASK           (0x2U)
#define CLKCTL0_SYSPLL0CTL0_RESET_SHIFT          (1U)
/*! RESET - SYSPLL0 Reset
 *  0b0..SYSPLL0 reset is removed
 *  0b1..SYSPLL0 is placed into reset
 */
#define CLKCTL0_SYSPLL0CTL0_RESET(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CTL0_RESET_SHIFT)) & CLKCTL0_SYSPLL0CTL0_RESET_MASK)
#define CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA_MASK (0x2000U)
#define CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA_SHIFT (13U)
/*! HOLDRINGOFF_ENA - Hold Ring Off Control
 *  0b0..Disable
 *  0b1..Enable
 */
#define CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA(x)   (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA_SHIFT)) & CLKCTL0_SYSPLL0CTL0_HOLDRINGOFF_ENA_MASK)
#define CLKCTL0_SYSPLL0CTL0_MULT_MASK            (0xFF0000U)
#define CLKCTL0_SYSPLL0CTL0_MULT_SHIFT           (16U)
/*! MULT - Multiplication Factor for FSYSPLL0_OUTPUT
 *  0b00010000..Divide by 16
 *  0b00010001..Divide by 17
 *  0b00010100..Divide by 20
 *  0b00010110..Divide by 22
 *  0b00011011..Divide by 27
 *  0b00100001..Divide by 33
 */
#define CLKCTL0_SYSPLL0CTL0_MULT(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0CTL0_MULT_SHIFT)) & CLKCTL0_SYSPLL0CTL0_MULT_MASK)
/*! @} */

/*! @name SYSPLL0LOCKTIMEDIV2 - System PLL0 Lock Time Div2 */
/*! @{ */
#define CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_MASK (0xFFFFU)
#define CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_SHIFT (0U)
/*! LOCKTIMEDIV2 - SYSPLL0 Lock Time Divide-by-2
 */
#define CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_SHIFT)) & CLKCTL0_SYSPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_MASK)
/*! @} */

/*! @name SYSPLL0NUM - System PLL0 Numerator */
/*! @{ */
#define CLKCTL0_SYSPLL0NUM_NUM_MASK              (0x3FFFFFFFU)
#define CLKCTL0_SYSPLL0NUM_NUM_SHIFT             (0U)
/*! NUM - Numerator of the SYSPLL0 fractional loop divider
 */
#define CLKCTL0_SYSPLL0NUM_NUM(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0NUM_NUM_SHIFT)) & CLKCTL0_SYSPLL0NUM_NUM_MASK)
/*! @} */

/*! @name SYSPLL0DENOM - System PLL0 Denominator */
/*! @{ */
#define CLKCTL0_SYSPLL0DENOM_DENOM_MASK          (0x3FFFFFFFU)
#define CLKCTL0_SYSPLL0DENOM_DENOM_SHIFT         (0U)
/*! DENOM - Denominator of the SYSPLL0 fractional loop divider
 */
#define CLKCTL0_SYSPLL0DENOM_DENOM(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0DENOM_DENOM_SHIFT)) & CLKCTL0_SYSPLL0DENOM_DENOM_MASK)
/*! @} */

/*! @name SYSPLL0PFD - System PLL0 PFD */
/*! @{ */
#define CLKCTL0_SYSPLL0PFD_PFD0_MASK             (0x3FU)
#define CLKCTL0_SYSPLL0PFD_PFD0_SHIFT            (0U)
/*! PFD0 - PLL Fractional Divider 0
 */
#define CLKCTL0_SYSPLL0PFD_PFD0(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD0_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD0_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY_MASK      (0x40U)
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY_SHIFT     (6U)
/*! PFD0_CLKRDY - PFD0 Clock Ready Status Flag
 *  0b0..PFD0 clock is not ready
 *  0b1..PFD0 clock is ready
 */
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD0_CLKRDY_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE_MASK     (0x80U)
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE_SHIFT    (7U)
/*! PFD0_CLKGATE - PFD0 Clock Gate
 *  0b0..PFD0 clock is not gated
 *  0b1..PFD0 clock is gated
 */
#define CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD0_CLKGATE_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD1_MASK             (0x3F00U)
#define CLKCTL0_SYSPLL0PFD_PFD1_SHIFT            (8U)
/*! PFD1 - PLL Fractional Divider 1
 */
#define CLKCTL0_SYSPLL0PFD_PFD1(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD1_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD1_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY_MASK      (0x4000U)
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY_SHIFT     (14U)
/*! PFD1_CLKRDY - PFD1 Clock Ready Status Flag
 *  0b0..PFD1 clock is not ready
 *  0b1..PFD1 clock is ready
 */
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD1_CLKRDY_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE_MASK     (0x8000U)
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE_SHIFT    (15U)
/*! PFD1_CLKGATE - PFD1 Clock Gate
 *  0b0..PFD1 clock is not gated
 *  0b1..PFD1 clock is gated
 */
#define CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD1_CLKGATE_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD2_MASK             (0x3F0000U)
#define CLKCTL0_SYSPLL0PFD_PFD2_SHIFT            (16U)
/*! PFD2 - PLL Fractional Divider 2
 */
#define CLKCTL0_SYSPLL0PFD_PFD2(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD2_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD2_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY_MASK      (0x400000U)
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY_SHIFT     (22U)
/*! PFD2_CLKRDY - PFD2 Clock Ready Status Flag
 *  0b0..PFD2 clock is not ready
 *  0b1..PFD2 clock is ready
 */
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD2_CLKRDY_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE_MASK     (0x800000U)
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE_SHIFT    (23U)
/*! PFD2_CLKGATE - PFD2 Clock Gate
 *  0b0..PFD2 clock is not gated
 *  0b1..PFD2 clock is gated
 */
#define CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD2_CLKGATE_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD3_MASK             (0x3F000000U)
#define CLKCTL0_SYSPLL0PFD_PFD3_SHIFT            (24U)
/*! PFD3 - PLL Fractional Divider 3
 */
#define CLKCTL0_SYSPLL0PFD_PFD3(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD3_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD3_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY_MASK      (0x40000000U)
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY_SHIFT     (30U)
/*! PFD3_CLKRDY - PFD3 Clock Ready Status Flag
 *  0b0..PFD3 clock is not ready
 *  0b1..PFD3 clock is ready
 */
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD3_CLKRDY_MASK)
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE_MASK     (0x80000000U)
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE_SHIFT    (31U)
/*! PFD3_CLKGATE - PFD3 Clock Gate
 *  0b0..PFD3 clock is not gated
 *  0b1..PFD3 clock is gated
 */
#define CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE_SHIFT)) & CLKCTL0_SYSPLL0PFD_PFD3_CLKGATE_MASK)
/*! @} */

/*! @name SYSCPUAHBCLKDIV - System CPU AHB Clock Divider */
/*! @{ */
#define CLKCTL0_SYSCPUAHBCLKDIV_DIV_MASK         (0xFFU)
#define CLKCTL0_SYSCPUAHBCLKDIV_DIV_SHIFT        (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_SYSCPUAHBCLKDIV_DIV(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSCPUAHBCLKDIV_DIV_SHIFT)) & CLKCTL0_SYSCPUAHBCLKDIV_DIV_MASK)
#define CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG_MASK     (0x80000000U)
#define CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG_SHIFT    (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SYSCPUAHBCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name MAINCLKSELA - Main Clock Select A */
/*! @{ */
#define CLKCTL0_MAINCLKSELA_SEL_MASK             (0x3U)
#define CLKCTL0_MAINCLKSELA_SEL_SHIFT            (0U)
/*! SEL - Control Main 1st Stage Control Clock Source
 *  0b00..Low Power Oscillator Clock (LPOSC)
 *  0b01..FRODIV which is the output of the FRODIVSEL mux
 *  0b10..OSC_CLK clock
 *  0b11..FRO clock
 */
#define CLKCTL0_MAINCLKSELA_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINCLKSELA_SEL_SHIFT)) & CLKCTL0_MAINCLKSELA_SEL_MASK)
/*! @} */

/*! @name MAINCLKSELB - Main Clock Select B */
/*! @{ */
#define CLKCTL0_MAINCLKSELB_SEL_MASK             (0x3U)
#define CLKCTL0_MAINCLKSELB_SEL_SHIFT            (0U)
/*! SEL - Main Clock Source Selection
 *  0b00..MAINCLKSELA 1st Stage Clock
 *  0b01..Main System PLL Clock
 *  0b10..RTC 32 KHz Clock
 *  0b11..Reserved
 */
#define CLKCTL0_MAINCLKSELB_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_MAINCLKSELB_SEL_SHIFT)) & CLKCTL0_MAINCLKSELB_SEL_MASK)
/*! @} */

/*! @name PFCDIV - PFC0DIV..PFC1DIV */
/*! @{ */
#define CLKCTL0_PFCDIV_DIV_MASK                  (0xFFU)
#define CLKCTL0_PFCDIV_DIV_SHIFT                 (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_PFCDIV_DIV(x)                    (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PFCDIV_DIV_SHIFT)) & CLKCTL0_PFCDIV_DIV_MASK)
#define CLKCTL0_PFCDIV_RESET_MASK                (0x20000000U)
#define CLKCTL0_PFCDIV_RESET_SHIFT               (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_PFCDIV_RESET(x)                  (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PFCDIV_RESET_SHIFT)) & CLKCTL0_PFCDIV_RESET_MASK)
#define CLKCTL0_PFCDIV_HALT_MASK                 (0x40000000U)
#define CLKCTL0_PFCDIV_HALT_SHIFT                (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_PFCDIV_HALT(x)                   (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PFCDIV_HALT_SHIFT)) & CLKCTL0_PFCDIV_HALT_MASK)
#define CLKCTL0_PFCDIV_REQFLAG_MASK              (0x80000000U)
#define CLKCTL0_PFCDIV_REQFLAG_SHIFT             (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_PFCDIV_REQFLAG(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_PFCDIV_REQFLAG_SHIFT)) & CLKCTL0_PFCDIV_REQFLAG_MASK)
/*! @} */

/* The count of CLKCTL0_PFCDIV */
#define CLKCTL0_PFCDIV_COUNT                     (2U)

/*! @name FLEXSPI0FCLKSEL - FlexSPI0 Functional Clock Select */
/*! @{ */
#define CLKCTL0_FLEXSPI0FCLKSEL_SEL_MASK         (0x7U)
#define CLKCTL0_FLEXSPI0FCLKSEL_SEL_SHIFT        (0U)
/*! SEL - Select Clock Source
 *  0b000..Main Clock
 *  0b001..Main System PLL Clock
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..FRO_192M Clock
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_FLEXSPI0FCLKSEL_SEL(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI0FCLKSEL_SEL_SHIFT)) & CLKCTL0_FLEXSPI0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name FLEXSPI0FCLKDIV - FlexSPI0 Functional Clock Divider */
/*! @{ */
#define CLKCTL0_FLEXSPI0FCLKDIV_DIV_MASK         (0xFFU)
#define CLKCTL0_FLEXSPI0FCLKDIV_DIV_SHIFT        (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_FLEXSPI0FCLKDIV_DIV(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI0FCLKDIV_DIV_SHIFT)) & CLKCTL0_FLEXSPI0FCLKDIV_DIV_MASK)
#define CLKCTL0_FLEXSPI0FCLKDIV_RESET_MASK       (0x20000000U)
#define CLKCTL0_FLEXSPI0FCLKDIV_RESET_SHIFT      (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_FLEXSPI0FCLKDIV_RESET(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI0FCLKDIV_RESET_SHIFT)) & CLKCTL0_FLEXSPI0FCLKDIV_RESET_MASK)
#define CLKCTL0_FLEXSPI0FCLKDIV_HALT_MASK        (0x40000000U)
#define CLKCTL0_FLEXSPI0FCLKDIV_HALT_SHIFT       (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_FLEXSPI0FCLKDIV_HALT(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI0FCLKDIV_HALT_SHIFT)) & CLKCTL0_FLEXSPI0FCLKDIV_HALT_MASK)
#define CLKCTL0_FLEXSPI0FCLKDIV_REQFLAG_MASK     (0x80000000U)
#define CLKCTL0_FLEXSPI0FCLKDIV_REQFLAG_SHIFT    (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_FLEXSPI0FCLKDIV_REQFLAG(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_FLEXSPI0FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name FLEXSPI1FCLKSEL - FlexSPI1 Functional Clock Select */
/*! @{ */
#define CLKCTL0_FLEXSPI1FCLKSEL_SEL_MASK         (0x7U)
#define CLKCTL0_FLEXSPI1FCLKSEL_SEL_SHIFT        (0U)
/*! SEL - Select Clock Source
 *  0b000..Main Clock
 *  0b001..Main System PLL Clock
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..FRO_192M Clock
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_FLEXSPI1FCLKSEL_SEL(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI1FCLKSEL_SEL_SHIFT)) & CLKCTL0_FLEXSPI1FCLKSEL_SEL_MASK)
/*! @} */

/*! @name FLEXSPI1FCLKDIV - FlexSPI1 Functional Clock Divider */
/*! @{ */
#define CLKCTL0_FLEXSPI1FCLKDIV_DIV_MASK         (0xFFU)
#define CLKCTL0_FLEXSPI1FCLKDIV_DIV_SHIFT        (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_FLEXSPI1FCLKDIV_DIV(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI1FCLKDIV_DIV_SHIFT)) & CLKCTL0_FLEXSPI1FCLKDIV_DIV_MASK)
#define CLKCTL0_FLEXSPI1FCLKDIV_RESET_MASK       (0x20000000U)
#define CLKCTL0_FLEXSPI1FCLKDIV_RESET_SHIFT      (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_FLEXSPI1FCLKDIV_RESET(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI1FCLKDIV_RESET_SHIFT)) & CLKCTL0_FLEXSPI1FCLKDIV_RESET_MASK)
#define CLKCTL0_FLEXSPI1FCLKDIV_HALT_MASK        (0x40000000U)
#define CLKCTL0_FLEXSPI1FCLKDIV_HALT_SHIFT       (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_FLEXSPI1FCLKDIV_HALT(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI1FCLKDIV_HALT_SHIFT)) & CLKCTL0_FLEXSPI1FCLKDIV_HALT_MASK)
#define CLKCTL0_FLEXSPI1FCLKDIV_REQFLAG_MASK     (0x80000000U)
#define CLKCTL0_FLEXSPI1FCLKDIV_REQFLAG_SHIFT    (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_FLEXSPI1FCLKDIV_REQFLAG(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_FLEXSPI1FCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_FLEXSPI1FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SCTFCLKSEL - SCT Functional Clock Select */
/*! @{ */
#define CLKCTL0_SCTFCLKSEL_SEL_MASK              (0x7U)
#define CLKCTL0_SCTFCLKSEL_SEL_SHIFT             (0U)
/*! SEL - Select Clock Source
 *  0b000..Main Clock
 *  0b001..Main System PLL Clock
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..FRO Clock
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..AUDIO PLL Clock
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_SCTFCLKSEL_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTFCLKSEL_SEL_SHIFT)) & CLKCTL0_SCTFCLKSEL_SEL_MASK)
/*! @} */

/*! @name SCTIN7CLKDIV - SCT Functional Clock Divider */
/*! @{ */
#define CLKCTL0_SCTIN7CLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL0_SCTIN7CLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_SCTIN7CLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTIN7CLKDIV_DIV_SHIFT)) & CLKCTL0_SCTIN7CLKDIV_DIV_MASK)
#define CLKCTL0_SCTIN7CLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL0_SCTIN7CLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_SCTIN7CLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTIN7CLKDIV_RESET_SHIFT)) & CLKCTL0_SCTIN7CLKDIV_RESET_MASK)
#define CLKCTL0_SCTIN7CLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL0_SCTIN7CLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_SCTIN7CLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTIN7CLKDIV_HALT_SHIFT)) & CLKCTL0_SCTIN7CLKDIV_HALT_MASK)
#define CLKCTL0_SCTIN7CLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL0_SCTIN7CLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_SCTIN7CLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SCTIN7CLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SCTIN7CLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name USBHSFCLKSEL - High Speed USB Functional Clock Select */
/*! @{ */
#define CLKCTL0_USBHSFCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL0_USBHSFCLKSEL_SEL_SHIFT           (0U)
/*! SEL - Select Clock Source
 *  0b000..OSC_CLK Clock
 *  0b001..Main Clock
 *  0b010..Reserved
 *  0b011..AUX0_PLL_CLOCK
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_USBHSFCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKSEL_SEL_SHIFT)) & CLKCTL0_USBHSFCLKSEL_SEL_MASK)
/*! @} */

/*! @name USBHSFCLKDIV - High Speed USB Functional Clock Divider */
/*! @{ */
#define CLKCTL0_USBHSFCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL0_USBHSFCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_USBHSFCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKDIV_DIV_SHIFT)) & CLKCTL0_USBHSFCLKDIV_DIV_MASK)
#define CLKCTL0_USBHSFCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL0_USBHSFCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_USBHSFCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKDIV_RESET_SHIFT)) & CLKCTL0_USBHSFCLKDIV_RESET_MASK)
#define CLKCTL0_USBHSFCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL0_USBHSFCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_USBHSFCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKDIV_HALT_SHIFT)) & CLKCTL0_USBHSFCLKDIV_HALT_MASK)
#define CLKCTL0_USBHSFCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL0_USBHSFCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_USBHSFCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_USBHSFCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_USBHSFCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SDIO0FCLKSEL - SDIO0 Functional Clock Select */
/*! @{ */
#define CLKCTL0_SDIO0FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL0_SDIO0FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - Select Clock Source
 *  0b000..Main Clock
 *  0b001..System PLL Clock
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..FRO Clock Divided by 2
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_SDIO0FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKSEL_SEL_SHIFT)) & CLKCTL0_SDIO0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name SDIO0FCLKDIV - SDIO0 Functional Clock Divider */
/*! @{ */
#define CLKCTL0_SDIO0FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL0_SDIO0FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_SDIO0FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKDIV_DIV_SHIFT)) & CLKCTL0_SDIO0FCLKDIV_DIV_MASK)
#define CLKCTL0_SDIO0FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL0_SDIO0FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_SDIO0FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKDIV_RESET_SHIFT)) & CLKCTL0_SDIO0FCLKDIV_RESET_MASK)
#define CLKCTL0_SDIO0FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL0_SDIO0FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_SDIO0FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKDIV_HALT_SHIFT)) & CLKCTL0_SDIO0FCLKDIV_HALT_MASK)
#define CLKCTL0_SDIO0FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL0_SDIO0FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_SDIO0FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SDIO0FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SDIO1FCLKSEL - SDIO1 Functional Clock Select */
/*! @{ */
#define CLKCTL0_SDIO1FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL0_SDIO1FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - Select Clock Source
 *  0b000..Main Clock
 *  0b001..Main System PLL Clock
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..FRO Clock Divided by 2
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_SDIO1FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKSEL_SEL_SHIFT)) & CLKCTL0_SDIO1FCLKSEL_SEL_MASK)
/*! @} */

/*! @name SDIO1FCLKDIV - SDIO1 Functional Clock Divider */
/*! @{ */
#define CLKCTL0_SDIO1FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL0_SDIO1FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_SDIO1FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKDIV_DIV_SHIFT)) & CLKCTL0_SDIO1FCLKDIV_DIV_MASK)
#define CLKCTL0_SDIO1FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL0_SDIO1FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_SDIO1FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKDIV_RESET_SHIFT)) & CLKCTL0_SDIO1FCLKDIV_RESET_MASK)
#define CLKCTL0_SDIO1FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL0_SDIO1FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_SDIO1FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKDIV_HALT_SHIFT)) & CLKCTL0_SDIO1FCLKDIV_HALT_MASK)
#define CLKCTL0_SDIO1FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL0_SDIO1FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_SDIO1FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SDIO1FCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SDIO1FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name ADC0FCLKSEL0 - ADC0 Functional Clock Select 0 */
/*! @{ */
#define CLKCTL0_ADC0FCLKSEL0_SEL_MASK            (0x7U)
#define CLKCTL0_ADC0FCLKSEL0_SEL_SHIFT           (0U)
/*! SEL - Select Clock Source
 *  0b000..OSC_CLK Clock
 *  0b001..Low Power Oscillator Clock (LPOSC)
 *  0b010..FRO Clock Divided by 4
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_ADC0FCLKSEL0_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKSEL0_SEL_SHIFT)) & CLKCTL0_ADC0FCLKSEL0_SEL_MASK)
/*! @} */

/*! @name ADC0FCLKSEL1 - ADC0 Functional Clock Select 1 */
/*! @{ */
#define CLKCTL0_ADC0FCLKSEL1_SEL_MASK            (0x7U)
#define CLKCTL0_ADC0FCLKSEL1_SEL_SHIFT           (0U)
/*! SEL - Select Clock Source
 *  0b000..ADC0FCLKSEL0 Multiplexed Output
 *  0b001..SYSPLL0 MAIN_CLK (PFD0 Output)
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..SYSPLL0 AUX1_PLL_Clock
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_ADC0FCLKSEL1_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKSEL1_SEL_SHIFT)) & CLKCTL0_ADC0FCLKSEL1_SEL_MASK)
/*! @} */

/*! @name ADC0FCLKDIV - ADC0 Functional Clock Divider */
/*! @{ */
#define CLKCTL0_ADC0FCLKDIV_DIV_MASK             (0xFFU)
#define CLKCTL0_ADC0FCLKDIV_DIV_SHIFT            (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_ADC0FCLKDIV_DIV(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKDIV_DIV_SHIFT)) & CLKCTL0_ADC0FCLKDIV_DIV_MASK)
#define CLKCTL0_ADC0FCLKDIV_RESET_MASK           (0x20000000U)
#define CLKCTL0_ADC0FCLKDIV_RESET_SHIFT          (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_ADC0FCLKDIV_RESET(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKDIV_RESET_SHIFT)) & CLKCTL0_ADC0FCLKDIV_RESET_MASK)
#define CLKCTL0_ADC0FCLKDIV_HALT_MASK            (0x40000000U)
#define CLKCTL0_ADC0FCLKDIV_HALT_SHIFT           (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_ADC0FCLKDIV_HALT(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKDIV_HALT_SHIFT)) & CLKCTL0_ADC0FCLKDIV_HALT_MASK)
#define CLKCTL0_ADC0FCLKDIV_REQFLAG_MASK         (0x80000000U)
#define CLKCTL0_ADC0FCLKDIV_REQFLAG_SHIFT        (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_ADC0FCLKDIV_REQFLAG(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_ADC0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_ADC0FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name UTICKFCLKSEL - UTICK Functional Clock Select */
/*! @{ */
#define CLKCTL0_UTICKFCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL0_UTICKFCLKSEL_SEL_SHIFT           (0U)
/*! SEL - Select Clock Source
 *  0b000..Low Power Oscillator Clock (LPOSC)
 *  0b001..Reserved
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_UTICKFCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_UTICKFCLKSEL_SEL_SHIFT)) & CLKCTL0_UTICKFCLKSEL_SEL_MASK)
/*! @} */

/*! @name WDT0FCLKSEL - WDT0 Functional Clock Select */
/*! @{ */
#define CLKCTL0_WDT0FCLKSEL_SEL_MASK             (0x7U)
#define CLKCTL0_WDT0FCLKSEL_SEL_SHIFT            (0U)
/*! SEL - Select Clock Source
 *  0b000..Low Power Oscillator Clock (LPOSC)
 *  0b001..Reserved
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_WDT0FCLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_WDT0FCLKSEL_SEL_SHIFT)) & CLKCTL0_WDT0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name A32KHZWAKECLKSEL - 32 KHz Wake Clock Source Select */
/*! @{ */
#define CLKCTL0_A32KHZWAKECLKSEL_SEL_MASK        (0x7U)
#define CLKCTL0_A32KHZWAKECLKSEL_SEL_SHIFT       (0U)
/*! SEL - Select Clock Source
 *  0b000..32 KHz
 *  0b001..Low Power Oscillator Clock (LPOSC); divided by 32 by default
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_A32KHZWAKECLKSEL_SEL(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_A32KHZWAKECLKSEL_SEL_SHIFT)) & CLKCTL0_A32KHZWAKECLKSEL_SEL_MASK)
/*! @} */

/*! @name A32KHZWAKECLKDIV - 32 KHz Wake Clock Divider */
/*! @{ */
#define CLKCTL0_A32KHZWAKECLKDIV_DIV_MASK        (0xFFU)
#define CLKCTL0_A32KHZWAKECLKDIV_DIV_SHIFT       (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_A32KHZWAKECLKDIV_DIV(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_A32KHZWAKECLKDIV_DIV_SHIFT)) & CLKCTL0_A32KHZWAKECLKDIV_DIV_MASK)
#define CLKCTL0_A32KHZWAKECLKDIV_RESET_MASK      (0x20000000U)
#define CLKCTL0_A32KHZWAKECLKDIV_RESET_SHIFT     (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_A32KHZWAKECLKDIV_RESET(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_A32KHZWAKECLKDIV_RESET_SHIFT)) & CLKCTL0_A32KHZWAKECLKDIV_RESET_MASK)
#define CLKCTL0_A32KHZWAKECLKDIV_HALT_MASK       (0x40000000U)
#define CLKCTL0_A32KHZWAKECLKDIV_HALT_SHIFT      (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_A32KHZWAKECLKDIV_HALT(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_A32KHZWAKECLKDIV_HALT_SHIFT)) & CLKCTL0_A32KHZWAKECLKDIV_HALT_MASK)
#define CLKCTL0_A32KHZWAKECLKDIV_REQFLAG_MASK    (0x80000000U)
#define CLKCTL0_A32KHZWAKECLKDIV_REQFLAG_SHIFT   (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_A32KHZWAKECLKDIV_REQFLAG(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL0_A32KHZWAKECLKDIV_REQFLAG_SHIFT)) & CLKCTL0_A32KHZWAKECLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name SYSTICKFCLKSEL - SYSTICK Functional Clock Select */
/*! @{ */
#define CLKCTL0_SYSTICKFCLKSEL_SEL_MASK          (0x7U)
#define CLKCTL0_SYSTICKFCLKSEL_SEL_SHIFT         (0U)
/*! SEL - Select Clock Source
 *  0b000..Systick Divider Output Clock
 *  0b001..Low Power Oscillator Clock (LPOSC)
 *  0b010..32 KHz RTC Clock
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_SYSTICKFCLKSEL_SEL(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKSEL_SEL_SHIFT)) & CLKCTL0_SYSTICKFCLKSEL_SEL_MASK)
/*! @} */

/*! @name SYSTICKFCLKDIV - SYSTICK Functional Clock Divider */
/*! @{ */
#define CLKCTL0_SYSTICKFCLKDIV_DIV_MASK          (0xFFU)
#define CLKCTL0_SYSTICKFCLKDIV_DIV_SHIFT         (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_SYSTICKFCLKDIV_DIV(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKDIV_DIV_SHIFT)) & CLKCTL0_SYSTICKFCLKDIV_DIV_MASK)
#define CLKCTL0_SYSTICKFCLKDIV_RESET_MASK        (0x20000000U)
#define CLKCTL0_SYSTICKFCLKDIV_RESET_SHIFT       (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_SYSTICKFCLKDIV_RESET(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKDIV_RESET_SHIFT)) & CLKCTL0_SYSTICKFCLKDIV_RESET_MASK)
#define CLKCTL0_SYSTICKFCLKDIV_HALT_MASK         (0x40000000U)
#define CLKCTL0_SYSTICKFCLKDIV_HALT_SHIFT        (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_SYSTICKFCLKDIV_HALT(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKDIV_HALT_SHIFT)) & CLKCTL0_SYSTICKFCLKDIV_HALT_MASK)
#define CLKCTL0_SYSTICKFCLKDIV_REQFLAG_MASK      (0x80000000U)
#define CLKCTL0_SYSTICKFCLKDIV_REQFLAG_SHIFT     (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_SYSTICKFCLKDIV_REQFLAG(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL0_SYSTICKFCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_SYSTICKFCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DPHYCLKSEL - MIPI-DSI PHY Clock Select */
/*! @{ */
#define CLKCTL0_DPHYCLKSEL_SEL_MASK              (0x7U)
#define CLKCTL0_DPHYCLKSEL_SEL_SHIFT             (0U)
/*! SEL - Select Clock Source
 *  0b000..FRO Clock (Div1 192 MHz)
 *  0b001..SYSPLL0 MAIN_CLK (PFD0 Output)
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..SYSPLL0 AUX1_PLL_Clock
 *  0b100..MIPI PHY Test Clock (from LVDS pads)
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_DPHYCLKSEL_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYCLKSEL_SEL_SHIFT)) & CLKCTL0_DPHYCLKSEL_SEL_MASK)
/*! @} */

/*! @name DPHYCLKDIV - MIPI-DSI PHY Clock Divider */
/*! @{ */
#define CLKCTL0_DPHYCLKDIV_DIV_MASK              (0xFFU)
#define CLKCTL0_DPHYCLKDIV_DIV_SHIFT             (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_DPHYCLKDIV_DIV(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYCLKDIV_DIV_SHIFT)) & CLKCTL0_DPHYCLKDIV_DIV_MASK)
#define CLKCTL0_DPHYCLKDIV_RESET_MASK            (0x20000000U)
#define CLKCTL0_DPHYCLKDIV_RESET_SHIFT           (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_DPHYCLKDIV_RESET(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYCLKDIV_RESET_SHIFT)) & CLKCTL0_DPHYCLKDIV_RESET_MASK)
#define CLKCTL0_DPHYCLKDIV_HALT_MASK             (0x40000000U)
#define CLKCTL0_DPHYCLKDIV_HALT_SHIFT            (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_DPHYCLKDIV_HALT(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYCLKDIV_HALT_SHIFT)) & CLKCTL0_DPHYCLKDIV_HALT_MASK)
#define CLKCTL0_DPHYCLKDIV_REQFLAG_MASK          (0x80000000U)
#define CLKCTL0_DPHYCLKDIV_REQFLAG_SHIFT         (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_DPHYCLKDIV_REQFLAG(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_DPHYCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DPHYESCCLKSEL - MIPI-DSI DPHY Escape Mode Clock Select */
/*! @{ */
#define CLKCTL0_DPHYESCCLKSEL_SEL_MASK           (0x7U)
#define CLKCTL0_DPHYESCCLKSEL_SEL_SHIFT          (0U)
/*! SEL - Select Clock Source
 *  0b000..FRO Clock (Div1 or 192 MHz)
 *  0b001..FRO Clock (Div16 or 12 MHz)
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_DPHYESCCLKSEL_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCCLKSEL_SEL_SHIFT)) & CLKCTL0_DPHYESCCLKSEL_SEL_MASK)
/*! @} */

/*! @name DPHYESCRXCLKDIV - MIPI-DSI DPHY Escape Mode Receive Clock Divider */
/*! @{ */
#define CLKCTL0_DPHYESCRXCLKDIV_DIV_MASK         (0xFFU)
#define CLKCTL0_DPHYESCRXCLKDIV_DIV_SHIFT        (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_DPHYESCRXCLKDIV_DIV(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCRXCLKDIV_DIV_SHIFT)) & CLKCTL0_DPHYESCRXCLKDIV_DIV_MASK)
#define CLKCTL0_DPHYESCRXCLKDIV_RESET_MASK       (0x20000000U)
#define CLKCTL0_DPHYESCRXCLKDIV_RESET_SHIFT      (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_DPHYESCRXCLKDIV_RESET(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCRXCLKDIV_RESET_SHIFT)) & CLKCTL0_DPHYESCRXCLKDIV_RESET_MASK)
#define CLKCTL0_DPHYESCRXCLKDIV_HALT_MASK        (0x40000000U)
#define CLKCTL0_DPHYESCRXCLKDIV_HALT_SHIFT       (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_DPHYESCRXCLKDIV_HALT(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCRXCLKDIV_HALT_SHIFT)) & CLKCTL0_DPHYESCRXCLKDIV_HALT_MASK)
#define CLKCTL0_DPHYESCRXCLKDIV_REQFLAG_MASK     (0x80000000U)
#define CLKCTL0_DPHYESCRXCLKDIV_REQFLAG_SHIFT    (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_DPHYESCRXCLKDIV_REQFLAG(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCRXCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_DPHYESCRXCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DPHYESCTXCLKDIV - MIPI-DSI DPHY Escape Mode Tramsmit Clock Divider */
/*! @{ */
#define CLKCTL0_DPHYESCTXCLKDIV_DIV_MASK         (0xFFU)
#define CLKCTL0_DPHYESCTXCLKDIV_DIV_SHIFT        (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_DPHYESCTXCLKDIV_DIV(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCTXCLKDIV_DIV_SHIFT)) & CLKCTL0_DPHYESCTXCLKDIV_DIV_MASK)
#define CLKCTL0_DPHYESCTXCLKDIV_RESET_MASK       (0x20000000U)
#define CLKCTL0_DPHYESCTXCLKDIV_RESET_SHIFT      (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_DPHYESCTXCLKDIV_RESET(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCTXCLKDIV_RESET_SHIFT)) & CLKCTL0_DPHYESCTXCLKDIV_RESET_MASK)
#define CLKCTL0_DPHYESCTXCLKDIV_HALT_MASK        (0x40000000U)
#define CLKCTL0_DPHYESCTXCLKDIV_HALT_SHIFT       (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_DPHYESCTXCLKDIV_HALT(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCTXCLKDIV_HALT_SHIFT)) & CLKCTL0_DPHYESCTXCLKDIV_HALT_MASK)
#define CLKCTL0_DPHYESCTXCLKDIV_REQFLAG_MASK     (0x80000000U)
#define CLKCTL0_DPHYESCTXCLKDIV_REQFLAG_SHIFT    (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_DPHYESCTXCLKDIV_REQFLAG(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DPHYESCTXCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_DPHYESCTXCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name GPUCLKSEL - GPU Clock Select */
/*! @{ */
#define CLKCTL0_GPUCLKSEL_SEL_MASK               (0x7U)
#define CLKCTL0_GPUCLKSEL_SEL_SHIFT              (0U)
/*! SEL - Select Clock Source
 *  0b000..Main Clock
 *  0b001..FRO Clock (Div1 or 192 MHz)
 *  0b010..SYSPLL0 MAIN_CLK (PFD0 Output)
 *  0b011..SYSPLL0 AUX0_PLL_Clock
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_GPUCLKSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL0_GPUCLKSEL_SEL_SHIFT)) & CLKCTL0_GPUCLKSEL_SEL_MASK)
/*! @} */

/*! @name GPUCLKDIV - GPU Clock Divider */
/*! @{ */
#define CLKCTL0_GPUCLKDIV_DIV_MASK               (0xFFU)
#define CLKCTL0_GPUCLKDIV_DIV_SHIFT              (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_GPUCLKDIV_DIV(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL0_GPUCLKDIV_DIV_SHIFT)) & CLKCTL0_GPUCLKDIV_DIV_MASK)
#define CLKCTL0_GPUCLKDIV_RESET_MASK             (0x20000000U)
#define CLKCTL0_GPUCLKDIV_RESET_SHIFT            (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_GPUCLKDIV_RESET(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL0_GPUCLKDIV_RESET_SHIFT)) & CLKCTL0_GPUCLKDIV_RESET_MASK)
#define CLKCTL0_GPUCLKDIV_HALT_MASK              (0x40000000U)
#define CLKCTL0_GPUCLKDIV_HALT_SHIFT             (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_GPUCLKDIV_HALT(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL0_GPUCLKDIV_HALT_SHIFT)) & CLKCTL0_GPUCLKDIV_HALT_MASK)
#define CLKCTL0_GPUCLKDIV_REQFLAG_MASK           (0x80000000U)
#define CLKCTL0_GPUCLKDIV_REQFLAG_SHIFT          (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_GPUCLKDIV_REQFLAG(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_GPUCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_GPUCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DCPIXELCLKSEL - LCDIF Pixel Clock Select */
/*! @{ */
#define CLKCTL0_DCPIXELCLKSEL_SEL_MASK           (0x7U)
#define CLKCTL0_DCPIXELCLKSEL_SEL_SHIFT          (0U)
/*! SEL - Select Clock Source
 *  0b000..MIPI-DSI PHY Clock
 *  0b001..Main Clock
 *  0b010..FRO Clock (Div1 or 192 MHz)
 *  0b011..SYSPLL0 MAIN_CLK (PFD0 Output)
 *  0b100..SYSPLL0 AUX0_PLL_Clock
 *  0b101..SYSPLL0 AUX1_PLL_Clock
 *  0b110..Reserved
 *  0b111..None; this may be selected to reduce power when no output is needed.
 */
#define CLKCTL0_DCPIXELCLKSEL_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DCPIXELCLKSEL_SEL_SHIFT)) & CLKCTL0_DCPIXELCLKSEL_SEL_MASK)
/*! @} */

/*! @name DCPIXELCLKDIV - LCDIF Pixel Clock Divider */
/*! @{ */
#define CLKCTL0_DCPIXELCLKDIV_DIV_MASK           (0xFFU)
#define CLKCTL0_DCPIXELCLKDIV_DIV_SHIFT          (0U)
/*! DIV - Clock Divider Value Selection
 */
#define CLKCTL0_DCPIXELCLKDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DCPIXELCLKDIV_DIV_SHIFT)) & CLKCTL0_DCPIXELCLKDIV_DIV_MASK)
#define CLKCTL0_DCPIXELCLKDIV_RESET_MASK         (0x20000000U)
#define CLKCTL0_DCPIXELCLKDIV_RESET_SHIFT        (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL0_DCPIXELCLKDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DCPIXELCLKDIV_RESET_SHIFT)) & CLKCTL0_DCPIXELCLKDIV_RESET_MASK)
#define CLKCTL0_DCPIXELCLKDIV_HALT_MASK          (0x40000000U)
#define CLKCTL0_DCPIXELCLKDIV_HALT_SHIFT         (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL0_DCPIXELCLKDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DCPIXELCLKDIV_HALT_SHIFT)) & CLKCTL0_DCPIXELCLKDIV_HALT_MASK)
#define CLKCTL0_DCPIXELCLKDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL0_DCPIXELCLKDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider status flag
 *  0b0..The change to the divider value has finished
 *  0b1..A change is being made to the divider value
 */
#define CLKCTL0_DCPIXELCLKDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL0_DCPIXELCLKDIV_REQFLAG_SHIFT)) & CLKCTL0_DCPIXELCLKDIV_REQFLAG_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CLKCTL0_Register_Masks */


/* CLKCTL0 - Peripheral instance base addresses */
/** Peripheral CLKCTL0 base address */
#define CLKCTL0_BASE                             (0x40001000u)
/** Peripheral CLKCTL0 base pointer */
#define CLKCTL0                                  ((CLKCTL0_Type *)CLKCTL0_BASE)
/** Array initializer of CLKCTL0 peripheral base addresses */
#define CLKCTL0_BASE_ADDRS                       { CLKCTL0_BASE }
/** Array initializer of CLKCTL0 peripheral base pointers */
#define CLKCTL0_BASE_PTRS                        { CLKCTL0 }

/*!
 * @}
 */ /* end of group CLKCTL0_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CLKCTL1 Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CLKCTL1_Peripheral_Access_Layer CLKCTL1 Peripheral Access Layer
 * @{
 */

/** CLKCTL1 - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[16];
  __IO uint32_t PSCCTL0;                           /**< Clock Control 0, offset: 0x10 */
  __IO uint32_t PSCCTL1;                           /**< Clock Control 1, offset: 0x14 */
  __IO uint32_t PSCCTL2;                           /**< Clock Control 2, offset: 0x18 */
       uint8_t RESERVED_1[36];
  __IO uint32_t PSCCTL0_SET;                       /**< Clock Set 0, offset: 0x40 */
  __IO uint32_t PSCCTL1_SET;                       /**< Clock Set 1, offset: 0x44 */
  __IO uint32_t PSCCTL2_SET;                       /**< Clock Set 2, offset: 0x48 */
       uint8_t RESERVED_2[36];
  __IO uint32_t PSCCTL0_CLR;                       /**< Clock Clear 0, offset: 0x70 */
  __IO uint32_t PSCCTL1_CLR;                       /**< Clock Clear 1, offset: 0x74 */
  __IO uint32_t PSCCTL2_CLR;                       /**< Clock Clear 2, offset: 0x78 */
       uint8_t RESERVED_3[388];
  __IO uint32_t AUDIOPLL0CLKSEL;                   /**< Audio PLL0 Clock Select, offset: 0x200 */
  __IO uint32_t AUDIOPLL0CTL0;                     /**< Audio PLL0 Control 0, offset: 0x204 */
       uint8_t RESERVED_4[4];
  __IO uint32_t AUDIOPLL0LOCKTIMEDIV2;             /**< Audio PLL0 Lock Time Divide-by-2, offset: 0x20C */
  __IO uint32_t AUDIOPLL0NUM;                      /**< Audio PLL0 Numerator, offset: 0x210 */
  __IO uint32_t AUDIOPLL0DENOM;                    /**< Audio PLL0 Denominator, offset: 0x214 */
  __IO uint32_t AUDIOPLL0PFD;                      /**< Audio PLL0 PFD, offset: 0x218 */
       uint8_t RESERVED_5[36];
  __IO uint32_t AUDIOPLLCLKDIV;                    /**< Audio PLL Clock Divider, offset: 0x240 */
       uint8_t RESERVED_6[444];
  __IO uint32_t DSPCPUCLKDIV;                      /**< DSP CPU Clock Divider, offset: 0x400 */
       uint8_t RESERVED_7[44];
  __IO uint32_t DSPCPUCLKSELA;                     /**< DSP CPU Clock Select A, offset: 0x430 */
  __IO uint32_t DSPCPUCLKSELB;                     /**< DSP CPU Clock Select B, offset: 0x434 */
       uint8_t RESERVED_8[72];
  __IO uint32_t OSEVENTTFCLKSEL;                   /**< OS Event Timer Functional Clock Select, offset: 0x480 */
       uint8_t RESERVED_9[124];
  struct {                                         /* offset: 0x500, array step: 0x20 */
    __IO uint32_t FRGCLKSEL;                         /**< Fractional Rate Generator 0 Clock Select..Fractional Rate Generator 16 Clock Select, array offset: 0x500, array step: 0x20 */
    __IO uint32_t FRGCTL;                            /**< Fractional Rate Generator 0 Control..Fractional Rate Generator 16 Control, array offset: 0x504, array step: 0x20 */
    __IO uint32_t FCFCLKSEL;                         /**< Flexcomm0 Clock Select..Flexcomm16 Clock Select, array offset: 0x508, array step: 0x20 */
         uint8_t RESERVED_0[20];
  } FLEXCOMM[17];
  __IO uint32_t FRG17CLKSEL;                       /**< Fractional Rate Generator 17 Clock Select, offset: 0x720 */
  __IO uint32_t FRG17CTL;                          /**< Fractional Rate Generator 17 Control, offset: 0x724 */
  __IO uint32_t FLEXIOCLKSEL;                      /**< FlexIO Clock Select, offset: 0x728 */
       uint8_t RESERVED_10[20];
  __IO uint32_t FLEXIOCLKDIV;                      /**< FlexIO Clock Divider, offset: 0x740 */
       uint8_t RESERVED_11[28];
  __IO uint32_t FRGPLLCLKDIV;                      /**< Fractional Rate Generator PLL Clock Divider, offset: 0x760 */
       uint8_t RESERVED_12[28];
  __IO uint32_t DMIC0FCLKSEL;                      /**< DMIC0 Functional Clock Select, offset: 0x780 */
  __IO uint32_t DMIC0FCLKDIV;                      /**< DMIC0 Functional Clock Divider, offset: 0x784 */
       uint8_t RESERVED_13[24];
  __IO uint32_t CT32BITFCLKSEL[5];                 /**< CT32BIT 0 Functional Clock Select..CT32BIT 4 Functional Clock Select, array offset: 0x7A0, array step: 0x4 */
       uint8_t RESERVED_14[12];
  __IO uint32_t AUDIOMCLKSEL;                      /**< Audio MCLK Clock Select, offset: 0x7C0 */
  __IO uint32_t AUDIOMCLKDIV;                      /**< Audio MCLK Clock Divider, offset: 0x7C4 */
       uint8_t RESERVED_15[24];
  __IO uint32_t CLKOUTSEL0;                        /**< CLKOUT Clock Select 0, offset: 0x7E0 */
  __IO uint32_t CLKOUTSEL1;                        /**< CLKOUT Clock Select 1, offset: 0x7E4 */
  __IO uint32_t CLKOUTFCLKDIV;                     /**< CLKOUT Functional Clock Divider, offset: 0x7E8 */
       uint8_t RESERVED_16[20];
  __IO uint32_t I3C01FCLKSEL;                      /**< I3C0, I3C1 Functional Clock Select, offset: 0x800 */
  __IO uint32_t I3C01FCLKSTCSEL;                   /**< I3C0, I3C1 Functional Slow Time Control Clock Select, offset: 0x804 */
  __IO uint32_t I3C01FCLKSTCDIV;                   /**< I3C0, I3C1 Functional Slow Time Control Clock Divider, offset: 0x808 */
  __IO uint32_t I3C01FCLKSDIV;                     /**< I3C0, I3C1 Functional Slow Clock Divider, offset: 0x80C */
  __IO uint32_t I3C01FCLKDIV;                      /**< I3C0, I3C1 Functional Clock Divider, offset: 0x810 */
  __IO uint32_t I3C01FCLKSTSTCLKSEL;               /**< I3C01 Functional Clock Select, offset: 0x814 */
       uint8_t RESERVED_17[8];
  __IO uint32_t WDT1FCLKSEL;                       /**< Watchdog Timer 1 Functional Clock Select, offset: 0x820 */
       uint8_t RESERVED_18[12];
  __IO uint32_t ACMP0FCLKSEL;                      /**< Analog Comparator 0 Clock Select, offset: 0x830 */
  __IO uint32_t ACMP0FCLKDIV;                      /**< Analog comparator 0 FCLK divider, offset: 0x834 */
} CLKCTL1_Type;

/* ----------------------------------------------------------------------------
   -- CLKCTL1 Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CLKCTL1_Register_Masks CLKCTL1 Register Masks
 * @{
 */

/*! @name PSCCTL0 - Clock Control 0 */
/*! @{ */
#define CLKCTL1_PSCCTL0_FC0_CLK_MASK             (0x100U)
#define CLKCTL1_PSCCTL0_FC0_CLK_SHIFT            (8U)
/*! FC0_CLK - Flexcomm Interface 0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC0_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC0_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC0_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC1_CLK_MASK             (0x200U)
#define CLKCTL1_PSCCTL0_FC1_CLK_SHIFT            (9U)
/*! FC1_CLK - Flexcomm Interface 1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC1_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC1_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC1_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC2_CLK_MASK             (0x400U)
#define CLKCTL1_PSCCTL0_FC2_CLK_SHIFT            (10U)
/*! FC2_CLK - Flexcomm Interface 2 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC2_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC2_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC2_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC3_CLK_MASK             (0x800U)
#define CLKCTL1_PSCCTL0_FC3_CLK_SHIFT            (11U)
/*! FC3_CLK - Flexcomm Interface 3 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC3_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC3_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC3_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC4_CLK_MASK             (0x1000U)
#define CLKCTL1_PSCCTL0_FC4_CLK_SHIFT            (12U)
/*! FC4_CLK - Flexcomm Interface 4 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC4_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC4_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC4_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC5_CLK_MASK             (0x2000U)
#define CLKCTL1_PSCCTL0_FC5_CLK_SHIFT            (13U)
/*! FC5_CLK - Flexcomm Interface 5 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC5_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC5_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC5_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC6_CLK_MASK             (0x4000U)
#define CLKCTL1_PSCCTL0_FC6_CLK_SHIFT            (14U)
/*! FC6_CLK - Flexcomm Interface 6 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC6_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC6_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC6_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC7_CLK_MASK             (0x8000U)
#define CLKCTL1_PSCCTL0_FC7_CLK_SHIFT            (15U)
/*! FC7_CLK - Flexcomm Interface 7 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC7_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC7_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC7_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC8_CLK_MASK             (0x10000U)
#define CLKCTL1_PSCCTL0_FC8_CLK_SHIFT            (16U)
/*! FC8_CLK - Flexcomm Interface 8 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC8_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC8_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC8_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC9_CLK_MASK             (0x20000U)
#define CLKCTL1_PSCCTL0_FC9_CLK_SHIFT            (17U)
/*! FC9_CLK - Flexcomm Interface 9 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC9_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC9_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC9_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC10_CLK_MASK            (0x40000U)
#define CLKCTL1_PSCCTL0_FC10_CLK_SHIFT           (18U)
/*! FC10_CLK - Flexcomm Interface 10 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC10_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC10_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC10_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC11_CLK_MASK            (0x80000U)
#define CLKCTL1_PSCCTL0_FC11_CLK_SHIFT           (19U)
/*! FC11_CLK - Flexcomm Interface 11 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC11_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC11_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC11_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC12_CLK_MASK            (0x100000U)
#define CLKCTL1_PSCCTL0_FC12_CLK_SHIFT           (20U)
/*! FC12_CLK - Flexcomm Interface 12 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC12_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC12_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC12_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC13_CLK_MASK            (0x200000U)
#define CLKCTL1_PSCCTL0_FC13_CLK_SHIFT           (21U)
/*! FC13_CLK - Flexcomm Interface 13 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC13_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC13_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC13_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC14_SPI_CLK_MASK        (0x400000U)
#define CLKCTL1_PSCCTL0_FC14_SPI_CLK_SHIFT       (22U)
/*! FC14_SPI_CLK - Flexcomm Interface 14 SPI clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC14_SPI_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC14_SPI_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC14_SPI_CLK_MASK)
#define CLKCTL1_PSCCTL0_FC15_I2C_CLK_MASK        (0x800000U)
#define CLKCTL1_PSCCTL0_FC15_I2C_CLK_SHIFT       (23U)
/*! FC15_I2C_CLK - Flexcomm Interface 15 I2C clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC15_I2C_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC15_I2C_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC15_I2C_CLK_MASK)
#define CLKCTL1_PSCCTL0_DMIC0_MASK               (0x1000000U)
#define CLKCTL1_PSCCTL0_DMIC0_SHIFT              (24U)
/*! DMIC0 - DMIC0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_DMIC0(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_DMIC0_SHIFT)) & CLKCTL1_PSCCTL0_DMIC0_MASK)
#define CLKCTL1_PSCCTL0_FC16_SPI_CLK_MASK        (0x2000000U)
#define CLKCTL1_PSCCTL0_FC16_SPI_CLK_SHIFT       (25U)
/*! FC16_SPI_CLK - Flexcomm Interface 16 SPI clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FC16_SPI_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FC16_SPI_CLK_SHIFT)) & CLKCTL1_PSCCTL0_FC16_SPI_CLK_MASK)
#define CLKCTL1_PSCCTL0_OSEVENT_TIMER_MASK       (0x8000000U)
#define CLKCTL1_PSCCTL0_OSEVENT_TIMER_SHIFT      (27U)
/*! OSEVENT_TIMER - OS event timer bus clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_OSEVENT_TIMER(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_OSEVENT_TIMER_SHIFT)) & CLKCTL1_PSCCTL0_OSEVENT_TIMER_MASK)
#define CLKCTL1_PSCCTL0_FlexIO_MASK              (0x20000000U)
#define CLKCTL1_PSCCTL0_FlexIO_SHIFT             (29U)
/*! FlexIO - FlexIO clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL0_FlexIO(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_FlexIO_SHIFT)) & CLKCTL1_PSCCTL0_FlexIO_MASK)
/*! @} */

/*! @name PSCCTL1 - Clock Control 1 */
/*! @{ */
#define CLKCTL1_PSCCTL1_HSGPIO0_CLK_MASK         (0x1U)
#define CLKCTL1_PSCCTL1_HSGPIO0_CLK_SHIFT        (0U)
/*! HSGPIO0_CLK - Non-secure GPIO0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO0_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO0_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO1_CLK_MASK         (0x2U)
#define CLKCTL1_PSCCTL1_HSGPIO1_CLK_SHIFT        (1U)
/*! HSGPIO1_CLK - Non-secure GPIO1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO1_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO1_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO2_CLK_MASK         (0x4U)
#define CLKCTL1_PSCCTL1_HSGPIO2_CLK_SHIFT        (2U)
/*! HSGPIO2_CLK - Non-secure GPIO2 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO2_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO2_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO2_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO3_CLK_MASK         (0x8U)
#define CLKCTL1_PSCCTL1_HSGPIO3_CLK_SHIFT        (3U)
/*! HSGPIO3_CLK - Non-secure GPIO3 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO3_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO3_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO3_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO4_CLK_MASK         (0x10U)
#define CLKCTL1_PSCCTL1_HSGPIO4_CLK_SHIFT        (4U)
/*! HSGPIO4_CLK - Non-secure GPIO4 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO4_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO4_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO4_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO5_CLK_MASK         (0x20U)
#define CLKCTL1_PSCCTL1_HSGPIO5_CLK_SHIFT        (5U)
/*! HSGPIO5_CLK - Non-secure GPIO5 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO5_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO5_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO5_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO6_CLK_MASK         (0x40U)
#define CLKCTL1_PSCCTL1_HSGPIO6_CLK_SHIFT        (6U)
/*! HSGPIO6_CLK - Non-secure GPIO6 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO6_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO6_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO6_CLK_MASK)
#define CLKCTL1_PSCCTL1_HSGPIO7_CLK_MASK         (0x80U)
#define CLKCTL1_PSCCTL1_HSGPIO7_CLK_SHIFT        (7U)
/*! HSGPIO7_CLK - Non-secure GPIO7 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_HSGPIO7_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_HSGPIO7_CLK_SHIFT)) & CLKCTL1_PSCCTL1_HSGPIO7_CLK_MASK)
#define CLKCTL1_PSCCTL1_CRC_CLK_MASK             (0x10000U)
#define CLKCTL1_PSCCTL1_CRC_CLK_SHIFT            (16U)
/*! CRC_CLK - CRC clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_CRC_CLK(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CRC_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CRC_CLK_MASK)
#define CLKCTL1_PSCCTL1_DMAC0_CLK_MASK           (0x800000U)
#define CLKCTL1_PSCCTL1_DMAC0_CLK_SHIFT          (23U)
/*! DMAC0_CLK - DMAC0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_DMAC0_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_DMAC0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_DMAC0_CLK_MASK)
#define CLKCTL1_PSCCTL1_DMAC1_CLK_MASK           (0x1000000U)
#define CLKCTL1_PSCCTL1_DMAC1_CLK_SHIFT          (24U)
/*! DMAC1_CLK - DMAC1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_DMAC1_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_DMAC1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_DMAC1_CLK_MASK)
#define CLKCTL1_PSCCTL1_MU_CLK_MASK              (0x10000000U)
#define CLKCTL1_PSCCTL1_MU_CLK_SHIFT             (28U)
/*! MU_CLK - Messaging Unit clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_MU_CLK(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_MU_CLK_SHIFT)) & CLKCTL1_PSCCTL1_MU_CLK_MASK)
#define CLKCTL1_PSCCTL1_SEMA_CLK_MASK            (0x20000000U)
#define CLKCTL1_PSCCTL1_SEMA_CLK_SHIFT           (29U)
/*! SEMA_CLK - Semaphore clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_SEMA_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SEMA_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SEMA_CLK_MASK)
#define CLKCTL1_PSCCTL1_FREQME_CLK_MASK          (0x80000000U)
#define CLKCTL1_PSCCTL1_FREQME_CLK_SHIFT         (31U)
/*! FREQME_CLK - Frequency Measurement clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL1_FREQME_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_FREQME_CLK_SHIFT)) & CLKCTL1_PSCCTL1_FREQME_CLK_MASK)
/*! @} */

/*! @name PSCCTL2 - Clock Control 2 */
/*! @{ */
#define CLKCTL1_PSCCTL2_CT32BIT0_CLK_MASK        (0x1U)
#define CLKCTL1_PSCCTL2_CT32BIT0_CLK_SHIFT       (0U)
/*! CT32BIT0_CLK - CT32BIT 0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT0_CLK_MASK)
#define CLKCTL1_PSCCTL2_CT32BIT1_CLK_MASK        (0x2U)
#define CLKCTL1_PSCCTL2_CT32BIT1_CLK_SHIFT       (1U)
/*! CT32BIT1_CLK - CT32BIT 1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT1_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT1_CLK_MASK)
#define CLKCTL1_PSCCTL2_CT32BIT2_CLK_MASK        (0x4U)
#define CLKCTL1_PSCCTL2_CT32BIT2_CLK_SHIFT       (2U)
/*! CT32BIT2_CLK - CT32BIT 2 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT2_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT2_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT2_CLK_MASK)
#define CLKCTL1_PSCCTL2_CT32BIT3_CLK_MASK        (0x8U)
#define CLKCTL1_PSCCTL2_CT32BIT3_CLK_SHIFT       (3U)
/*! CT32BIT3_CLK - CT32BIT 3 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT3_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT3_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT3_CLK_MASK)
#define CLKCTL1_PSCCTL2_CT32BIT4_CLK_MASK        (0x10U)
#define CLKCTL1_PSCCTL2_CT32BIT4_CLK_SHIFT       (4U)
/*! CT32BIT4_CLK - CT32BIT 4 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CT32BIT4_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CT32BIT4_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CT32BIT4_CLK_MASK)
#define CLKCTL1_PSCCTL2_RTCLITE_CLK_MASK         (0x80U)
#define CLKCTL1_PSCCTL2_RTCLITE_CLK_SHIFT        (7U)
/*! RTCLITE_CLK - RTC clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_RTCLITE_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_RTCLITE_CLK_SHIFT)) & CLKCTL1_PSCCTL2_RTCLITE_CLK_MASK)
#define CLKCTL1_PSCCTL2_MRT0_CLK_MASK            (0x100U)
#define CLKCTL1_PSCCTL2_MRT0_CLK_SHIFT           (8U)
/*! MRT0_CLK - Multi-Rate Timer 0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_MRT0_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_MRT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_MRT0_CLK_MASK)
#define CLKCTL1_PSCCTL2_WWDT1_CLK_MASK           (0x400U)
#define CLKCTL1_PSCCTL2_WWDT1_CLK_SHIFT          (10U)
/*! WWDT1_CLK - Watchdog Timer 1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_WWDT1_CLK(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_WWDT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_WWDT1_CLK_MASK)
#define CLKCTL1_PSCCTL2_I3C0_CLK_MASK            (0x10000U)
#define CLKCTL1_PSCCTL2_I3C0_CLK_SHIFT           (16U)
/*! I3C0_CLK - I3C0 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_I3C0_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_I3C0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_I3C0_CLK_MASK)
#define CLKCTL1_PSCCTL2_I3C1_CLK_MASK            (0x20000U)
#define CLKCTL1_PSCCTL2_I3C1_CLK_SHIFT           (17U)
/*! I3C1_CLK - I3C1 clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_I3C1_CLK(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_I3C1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_I3C1_CLK_MASK)
#define CLKCTL1_PSCCTL2_GPIOINTCTL_MASK          (0x40000000U)
#define CLKCTL1_PSCCTL2_GPIOINTCTL_SHIFT         (30U)
/*! GPIOINTCTL - PINT clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_GPIOINTCTL(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_GPIOINTCTL_SHIFT)) & CLKCTL1_PSCCTL2_GPIOINTCTL_MASK)
#define CLKCTL1_PSCCTL2_PIMCTL_MASK              (0x80000000U)
#define CLKCTL1_PSCCTL2_PIMCTL_SHIFT             (31U)
/*! PIMCTL - INPUTMUX clock control
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_PIMCTL(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_PIMCTL_SHIFT)) & CLKCTL1_PSCCTL2_PIMCTL_MASK)
/*! @} */

/*! @name PSCCTL0_SET - Clock Set 0 */
/*! @{ */
#define CLKCTL1_PSCCTL0_SET_FC0_CLK_MASK         (0x100U)
#define CLKCTL1_PSCCTL0_SET_FC0_CLK_SHIFT        (8U)
/*! FC0_CLK - Flexcomm Interface 0 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC0_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC0_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC0_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC1_CLK_MASK         (0x200U)
#define CLKCTL1_PSCCTL0_SET_FC1_CLK_SHIFT        (9U)
/*! FC1_CLK - Flexcomm Interface 1 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC1_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC1_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC1_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC2_CLK_MASK         (0x400U)
#define CLKCTL1_PSCCTL0_SET_FC2_CLK_SHIFT        (10U)
/*! FC2_CLK - Flexcomm Interface 2 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC2_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC2_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC2_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC3_CLK_MASK         (0x800U)
#define CLKCTL1_PSCCTL0_SET_FC3_CLK_SHIFT        (11U)
/*! FC3_CLK - Flexcomm Interface 3 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC3_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC3_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC3_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC4_CLK_MASK         (0x1000U)
#define CLKCTL1_PSCCTL0_SET_FC4_CLK_SHIFT        (12U)
/*! FC4_CLK - Flexcomm Interface 4 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC4_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC4_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC4_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC5_CLK_MASK         (0x2000U)
#define CLKCTL1_PSCCTL0_SET_FC5_CLK_SHIFT        (13U)
/*! FC5_CLK - Flexcomm Interface 5 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC5_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC5_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC5_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC6_CLK_MASK         (0x4000U)
#define CLKCTL1_PSCCTL0_SET_FC6_CLK_SHIFT        (14U)
/*! FC6_CLK - Flexcomm Interface 6 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC6_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC6_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC6_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC7_CLK_MASK         (0x8000U)
#define CLKCTL1_PSCCTL0_SET_FC7_CLK_SHIFT        (15U)
/*! FC7_CLK - Flexcomm Interface 7 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC7_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC7_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC7_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC8_CLK_MASK         (0x10000U)
#define CLKCTL1_PSCCTL0_SET_FC8_CLK_SHIFT        (16U)
/*! FC8_CLK - Flexcomm Interface 8 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC8_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC8_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC8_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC9_CLK_MASK         (0x20000U)
#define CLKCTL1_PSCCTL0_SET_FC9_CLK_SHIFT        (17U)
/*! FC9_CLK - Flexcomm Interface 9 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC9_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC9_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC9_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC10_CLK_MASK        (0x40000U)
#define CLKCTL1_PSCCTL0_SET_FC10_CLK_SHIFT       (18U)
/*! FC10_CLK - Flexcomm Interface 10 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC10_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC10_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC10_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC11_CLK_MASK        (0x80000U)
#define CLKCTL1_PSCCTL0_SET_FC11_CLK_SHIFT       (19U)
/*! FC11_CLK - Flexcomm Interface 11 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC11_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC11_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC11_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC12_CLK_MASK        (0x100000U)
#define CLKCTL1_PSCCTL0_SET_FC12_CLK_SHIFT       (20U)
/*! FC12_CLK - Flexcomm Interface 12 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC12_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC12_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC12_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC13_CLK_MASK        (0x200000U)
#define CLKCTL1_PSCCTL0_SET_FC13_CLK_SHIFT       (21U)
/*! FC13_CLK - Flexcomm Interface 13 clock set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC13_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC13_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC13_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK_MASK    (0x400000U)
#define CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK_SHIFT   (22U)
/*! FC14_SPI_CLK - Flexcomm Interface 14 SPI clock control
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC14_SPI_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK_MASK    (0x800000U)
#define CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK_SHIFT   (23U)
/*! FC15_I2C_CLK - Flexcomm Interface 15 I2C clock control
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC15_I2C_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_DMIC0_MASK           (0x1000000U)
#define CLKCTL1_PSCCTL0_SET_DMIC0_SHIFT          (24U)
/*! DMIC0 - DMIC0 clock control
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_DMIC0(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_DMIC0_SHIFT)) & CLKCTL1_PSCCTL0_SET_DMIC0_MASK)
#define CLKCTL1_PSCCTL0_SET_FC16_SPI_CLK_MASK    (0x2000000U)
#define CLKCTL1_PSCCTL0_SET_FC16_SPI_CLK_SHIFT   (25U)
/*! FC16_SPI_CLK - Flexcomm Interface 16 SPI clock control
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FC16_SPI_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FC16_SPI_CLK_SHIFT)) & CLKCTL1_PSCCTL0_SET_FC16_SPI_CLK_MASK)
#define CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER_MASK   (0x8000000U)
#define CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER_SHIFT  (27U)
/*! OSEVENT_TIMER - OS event timer bus clock control
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER_SHIFT)) & CLKCTL1_PSCCTL0_SET_OSEVENT_TIMER_MASK)
#define CLKCTL1_PSCCTL0_SET_FlexIO_MASK          (0x20000000U)
#define CLKCTL1_PSCCTL0_SET_FlexIO_SHIFT         (29U)
/*! FlexIO - FlexIO clock control
 *  0b0..No effect
 *  0b1..Sets the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_SET_FlexIO(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_SET_FlexIO_SHIFT)) & CLKCTL1_PSCCTL0_SET_FlexIO_MASK)
/*! @} */

/*! @name PSCCTL1_SET - Clock Set 1 */
/*! @{ */
#define CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK_MASK     (0x1U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK_SHIFT    (0U)
/*! HSGPIO0_CLK - Non-secure GPIO0 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO0_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK_MASK     (0x2U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK_SHIFT    (1U)
/*! HSGPIO1_CLK - Non-secure GPIO1 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO1_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK_MASK     (0x4U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK_SHIFT    (2U)
/*! HSGPIO2_CLK - Non-secure GPIO2 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO2_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK_MASK     (0x8U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK_SHIFT    (3U)
/*! HSGPIO3_CLK - Non-secure GPIO3 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO3_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK_MASK     (0x10U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK_SHIFT    (4U)
/*! HSGPIO4_CLK - Non-secure GPIO4 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO4_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK_MASK     (0x20U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK_SHIFT    (5U)
/*! HSGPIO5_CLK - Non-secure GPIO5 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO5_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK_MASK     (0x40U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK_SHIFT    (6U)
/*! HSGPIO6_CLK - Non-secure GPIO6 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO6_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK_MASK     (0x80U)
#define CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK_SHIFT    (7U)
/*! HSGPIO7_CLK - Non-secure GPIO7 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_HSGPIO7_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_CRC_CLK_MASK         (0x10000U)
#define CLKCTL1_PSCCTL1_SET_CRC_CLK_SHIFT        (16U)
/*! CRC_CLK - CRC clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_CRC_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_CRC_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_CRC_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_DMAC0_CLK_MASK       (0x800000U)
#define CLKCTL1_PSCCTL1_SET_DMAC0_CLK_SHIFT      (23U)
/*! DMAC0_CLK - DMAC0 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_DMAC0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_DMAC0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_DMAC0_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_DMAC1_CLK_MASK       (0x1000000U)
#define CLKCTL1_PSCCTL1_SET_DMAC1_CLK_SHIFT      (24U)
/*! DMAC1_CLK - DMAC1 clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_DMAC1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_DMAC1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_DMAC1_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_MU_CLK_MASK          (0x10000000U)
#define CLKCTL1_PSCCTL1_SET_MU_CLK_SHIFT         (28U)
/*! MU_CLK - Messaging Unit clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_MU_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_MU_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_MU_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_SEMA_CLK_MASK        (0x20000000U)
#define CLKCTL1_PSCCTL1_SET_SEMA_CLK_SHIFT       (29U)
/*! SEMA_CLK - Semaphore clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_SEMA_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_SEMA_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_SEMA_CLK_MASK)
#define CLKCTL1_PSCCTL1_SET_FREQME_CLK_MASK      (0x80000000U)
#define CLKCTL1_PSCCTL1_SET_FREQME_CLK_SHIFT     (31U)
/*! FREQME_CLK - Frequency Measurement clock control set
 *  0b0..No effect
 *  0b1..Sets the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_SET_FREQME_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_SET_FREQME_CLK_SHIFT)) & CLKCTL1_PSCCTL1_SET_FREQME_CLK_MASK)
/*! @} */

/*! @name PSCCTL2_SET - Clock Set 2 */
/*! @{ */
#define CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK_MASK    (0x1U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK_SHIFT   (0U)
/*! CT32BIT0_CLK - CT32BIT 0 clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT0_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK_MASK    (0x2U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK_SHIFT   (1U)
/*! CT32BIT1_CLK - CT32BIT 1 clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT1_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK_MASK    (0x4U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK_SHIFT   (2U)
/*! CT32BIT2_CLK - CT32BIT 2 clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT2_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK_MASK    (0x8U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK_SHIFT   (3U)
/*! CT32BIT3_CLK - CT32BIT 3 clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT3_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK_MASK    (0x10U)
#define CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK_SHIFT   (4U)
/*! CT32BIT4_CLK - CT32BIT 4 clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_CT32BIT4_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_RTCLITE_CLK_MASK     (0x80U)
#define CLKCTL1_PSCCTL2_SET_RTCLITE_CLK_SHIFT    (7U)
/*! RTCLITE_CLK - RTC clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_RTCLITE_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_RTCLITE_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_RTCLITE_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_MRT0_CLK_MASK        (0x100U)
#define CLKCTL1_PSCCTL2_SET_MRT0_CLK_SHIFT       (8U)
/*! MRT0_CLK - Multi-Rate Timer 0 clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_MRT0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_MRT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_MRT0_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_WWDT1_CLK_MASK       (0x400U)
#define CLKCTL1_PSCCTL2_SET_WWDT1_CLK_SHIFT      (10U)
/*! WWDT1_CLK - Watchdog Timer 1 clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_WWDT1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_WWDT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_WWDT1_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_I3C0_CLK_MASK        (0x10000U)
#define CLKCTL1_PSCCTL2_SET_I3C0_CLK_SHIFT       (16U)
/*! I3C0_CLK - I3C0 clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_I3C0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_I3C0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_I3C0_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_I3C1_CLK_MASK        (0x20000U)
#define CLKCTL1_PSCCTL2_SET_I3C1_CLK_SHIFT       (17U)
/*! I3C1_CLK - I3C1 clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_I3C1_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_I3C1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_SET_I3C1_CLK_MASK)
#define CLKCTL1_PSCCTL2_SET_GPIOINTCTL_MASK      (0x40000000U)
#define CLKCTL1_PSCCTL2_SET_GPIOINTCTL_SHIFT     (30U)
/*! GPIOINTCTL - PINT clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_GPIOINTCTL(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_GPIOINTCTL_SHIFT)) & CLKCTL1_PSCCTL2_SET_GPIOINTCTL_MASK)
#define CLKCTL1_PSCCTL2_SET_PIMCTL_MASK          (0x80000000U)
#define CLKCTL1_PSCCTL2_SET_PIMCTL_SHIFT         (31U)
/*! PIMCTL - INPUTMUX clock control set
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_SET_PIMCTL(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_SET_PIMCTL_SHIFT)) & CLKCTL1_PSCCTL2_SET_PIMCTL_MASK)
/*! @} */

/*! @name PSCCTL0_CLR - Clock Clear 0 */
/*! @{ */
#define CLKCTL1_PSCCTL0_CLR_FC0_CLK_MASK         (0x100U)
#define CLKCTL1_PSCCTL0_CLR_FC0_CLK_SHIFT        (8U)
/*! FC0_CLK - Flexcomm Interface 0 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC0_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC0_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC0_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC1_CLK_MASK         (0x200U)
#define CLKCTL1_PSCCTL0_CLR_FC1_CLK_SHIFT        (9U)
/*! FC1_CLK - Flexcomm Interface 1 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC1_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC1_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC1_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC2_CLK_MASK         (0x400U)
#define CLKCTL1_PSCCTL0_CLR_FC2_CLK_SHIFT        (10U)
/*! FC2_CLK - Flexcomm Interface 2 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC2_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC2_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC2_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC3_CLK_MASK         (0x800U)
#define CLKCTL1_PSCCTL0_CLR_FC3_CLK_SHIFT        (11U)
/*! FC3_CLK - Flexcomm Interface 3 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC3_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC3_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC3_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC4_CLK_MASK         (0x1000U)
#define CLKCTL1_PSCCTL0_CLR_FC4_CLK_SHIFT        (12U)
/*! FC4_CLK - Flexcomm Interface 4 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC4_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC4_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC4_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC5_CLK_MASK         (0x2000U)
#define CLKCTL1_PSCCTL0_CLR_FC5_CLK_SHIFT        (13U)
/*! FC5_CLK - Flexcomm Interface 5 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC5_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC5_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC5_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC6_CLK_MASK         (0x4000U)
#define CLKCTL1_PSCCTL0_CLR_FC6_CLK_SHIFT        (14U)
/*! FC6_CLK - Flexcomm Interface 6 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC6_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC6_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC6_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC7_CLK_MASK         (0x8000U)
#define CLKCTL1_PSCCTL0_CLR_FC7_CLK_SHIFT        (15U)
/*! FC7_CLK - Flexcomm Interface 7 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC7_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC7_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC7_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC8_CLK_MASK         (0x10000U)
#define CLKCTL1_PSCCTL0_CLR_FC8_CLK_SHIFT        (16U)
/*! FC8_CLK - Flexcomm Interface 8 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC8_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC8_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC8_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC9_CLK_MASK         (0x20000U)
#define CLKCTL1_PSCCTL0_CLR_FC9_CLK_SHIFT        (17U)
/*! FC9_CLK - Flexcomm Interface 9 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC9_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC9_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC9_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC10_CLK_MASK        (0x40000U)
#define CLKCTL1_PSCCTL0_CLR_FC10_CLK_SHIFT       (18U)
/*! FC10_CLK - Flexcomm Interface 10 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC10_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC10_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC10_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC11_CLK_MASK        (0x80000U)
#define CLKCTL1_PSCCTL0_CLR_FC11_CLK_SHIFT       (19U)
/*! FC11_CLK - Flexcomm Interface 11 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC11_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC11_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC11_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC12_CLK_MASK        (0x100000U)
#define CLKCTL1_PSCCTL0_CLR_FC12_CLK_SHIFT       (20U)
/*! FC12_CLK - Flexcomm Interface 12 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC12_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC12_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC12_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC13_CLK_MASK        (0x200000U)
#define CLKCTL1_PSCCTL0_CLR_FC13_CLK_SHIFT       (21U)
/*! FC13_CLK - Flexcomm Interface 13 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC13_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC13_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC13_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK_MASK    (0x400000U)
#define CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK_SHIFT   (22U)
/*! FC14_SPI_CLK - Flexcomm Interface 14 SPI clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC14_SPI_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK_MASK    (0x800000U)
#define CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK_SHIFT   (23U)
/*! FC15_I2C_CLK - Flexcomm Interface 15 I2C clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC15_I2C_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_DMIC0_MASK           (0x1000000U)
#define CLKCTL1_PSCCTL0_CLR_DMIC0_SHIFT          (24U)
/*! DMIC0 - DMIC0 clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_DMIC0(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_DMIC0_SHIFT)) & CLKCTL1_PSCCTL0_CLR_DMIC0_MASK)
#define CLKCTL1_PSCCTL0_CLR_FC16_SPI_CLK_MASK    (0x2000000U)
#define CLKCTL1_PSCCTL0_CLR_FC16_SPI_CLK_SHIFT   (25U)
/*! FC16_SPI_CLK - Flexcomm Interface 16 SPI clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FC16_SPI_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FC16_SPI_CLK_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FC16_SPI_CLK_MASK)
#define CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER_MASK   (0x8000000U)
#define CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER_SHIFT  (27U)
/*! OSEVENT_TIMER - OS event timer bus clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER_SHIFT)) & CLKCTL1_PSCCTL0_CLR_OSEVENT_TIMER_MASK)
#define CLKCTL1_PSCCTL0_CLR_FlexIO_MASK          (0x20000000U)
#define CLKCTL1_PSCCTL0_CLR_FlexIO_SHIFT         (29U)
/*! FlexIO - FlexIO clock control clear
 *  0b0..No effect
 *  0b1..Clears the PSCCTL0 bit
 */
#define CLKCTL1_PSCCTL0_CLR_FlexIO(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL0_CLR_FlexIO_SHIFT)) & CLKCTL1_PSCCTL0_CLR_FlexIO_MASK)
/*! @} */

/*! @name PSCCTL1_CLR - Clock Clear 1 */
/*! @{ */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK_MASK     (0x1U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK_SHIFT    (0U)
/*! HSGPIO0_CLK - Non-secure GPIO0 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO0_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK_MASK     (0x2U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK_SHIFT    (1U)
/*! HSGPIO1_CLK - Non-secure GPIO1 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO1_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK_MASK     (0x4U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK_SHIFT    (2U)
/*! HSGPIO2_CLK - Non-secure GPIO2 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO2_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK_MASK     (0x8U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK_SHIFT    (3U)
/*! HSGPIO3_CLK - Non-secure GPIO3 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO3_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK_MASK     (0x10U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK_SHIFT    (4U)
/*! HSGPIO4_CLK - Non-secure GPIO4 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO4_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK_MASK     (0x20U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK_SHIFT    (5U)
/*! HSGPIO5_CLK - Non-secure GPIO5 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO5_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK_MASK     (0x40U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK_SHIFT    (6U)
/*! HSGPIO6_CLK - Non-secure GPIO6 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO6_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK_MASK     (0x80U)
#define CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK_SHIFT    (7U)
/*! HSGPIO7_CLK - Non-secure GPIO7 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_HSGPIO7_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_CRC_CLK_MASK         (0x10000U)
#define CLKCTL1_PSCCTL1_CLR_CRC_CLK_SHIFT        (16U)
/*! CRC_CLK - CRC clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_CRC_CLK(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_CRC_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_CRC_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_DMAC0_CLK_MASK       (0x800000U)
#define CLKCTL1_PSCCTL1_CLR_DMAC0_CLK_SHIFT      (23U)
/*! DMAC0_CLK - DMAC0 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_DMAC0_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_DMAC0_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_DMAC0_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_DMAC1_CLK_MASK       (0x1000000U)
#define CLKCTL1_PSCCTL1_CLR_DMAC1_CLK_SHIFT      (24U)
/*! DMAC1_CLK - DMAC1 clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_DMAC1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_DMAC1_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_DMAC1_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_MU_CLK_MASK          (0x10000000U)
#define CLKCTL1_PSCCTL1_CLR_MU_CLK_SHIFT         (28U)
/*! MU_CLK - Messaging Unit clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_MU_CLK(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_MU_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_MU_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_SEMA_CLK_MASK        (0x20000000U)
#define CLKCTL1_PSCCTL1_CLR_SEMA_CLK_SHIFT       (29U)
/*! SEMA_CLK - Semaphore clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_SEMA_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_SEMA_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_SEMA_CLK_MASK)
#define CLKCTL1_PSCCTL1_CLR_FREQME_CLK_MASK      (0x80000000U)
#define CLKCTL1_PSCCTL1_CLR_FREQME_CLK_SHIFT     (31U)
/*! FREQME_CLK - Frequency Measurement clock control
 *  0b0..No effect
 *  0b1..Clears the PSCCTL1 bit
 */
#define CLKCTL1_PSCCTL1_CLR_FREQME_CLK(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL1_CLR_FREQME_CLK_SHIFT)) & CLKCTL1_PSCCTL1_CLR_FREQME_CLK_MASK)
/*! @} */

/*! @name PSCCTL2_CLR - Clock Clear 2 */
/*! @{ */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK_MASK    (0x1U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK_SHIFT   (0U)
/*! CT32BIT0_CLK - CT32BIT 0 clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT0_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK_MASK    (0x2U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK_SHIFT   (1U)
/*! CT32BIT1_CLK - CT32BIT 1 clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT1_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK_MASK    (0x4U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK_SHIFT   (2U)
/*! CT32BIT2_CLK - CT32BIT 2 clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT2_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK_MASK    (0x8U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK_SHIFT   (3U)
/*! CT32BIT3_CLK - CT32BIT 3 clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT3_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK_MASK    (0x10U)
#define CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK_SHIFT   (4U)
/*! CT32BIT4_CLK - CT32BIT 4 clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_CT32BIT4_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_RTCLITE_CLK_MASK     (0x80U)
#define CLKCTL1_PSCCTL2_CLR_RTCLITE_CLK_SHIFT    (7U)
/*! RTCLITE_CLK - RTC clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_RTCLITE_CLK(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_RTCLITE_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_RTCLITE_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_MRT0_CLK_MASK        (0x100U)
#define CLKCTL1_PSCCTL2_CLR_MRT0_CLK_SHIFT       (8U)
/*! MRT0_CLK - Multi-Rate Timer 0 clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_MRT0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_MRT0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_MRT0_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_WWDT1_CLK_MASK       (0x400U)
#define CLKCTL1_PSCCTL2_CLR_WWDT1_CLK_SHIFT      (10U)
/*! WWDT1_CLK - Watchdog Timer 1 clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_WWDT1_CLK(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_WWDT1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_WWDT1_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_I3C0_CLK_MASK        (0x10000U)
#define CLKCTL1_PSCCTL2_CLR_I3C0_CLK_SHIFT       (16U)
/*! I3C0_CLK - I3C0 clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_I3C0_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_I3C0_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_I3C0_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_I3C1_CLK_MASK        (0x20000U)
#define CLKCTL1_PSCCTL2_CLR_I3C1_CLK_SHIFT       (17U)
/*! I3C1_CLK - I3C1 clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_I3C1_CLK(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_I3C1_CLK_SHIFT)) & CLKCTL1_PSCCTL2_CLR_I3C1_CLK_MASK)
#define CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_MASK      (0x40000000U)
#define CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_SHIFT     (30U)
/*! GPIOINTCTL - PINT clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_GPIOINTCTL(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_SHIFT)) & CLKCTL1_PSCCTL2_CLR_GPIOINTCTL_MASK)
#define CLKCTL1_PSCCTL2_CLR_PIMCTL_MASK          (0x80000000U)
#define CLKCTL1_PSCCTL2_CLR_PIMCTL_SHIFT         (31U)
/*! PIMCTL - INPUTMUX clock control clear
 *  0b0..Disable Clock
 *  0b1..Enable Clock
 */
#define CLKCTL1_PSCCTL2_CLR_PIMCTL(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_PSCCTL2_CLR_PIMCTL_SHIFT)) & CLKCTL1_PSCCTL2_CLR_PIMCTL_MASK)
/*! @} */

/*! @name AUDIOPLL0CLKSEL - Audio PLL0 Clock Select */
/*! @{ */
#define CLKCTL1_AUDIOPLL0CLKSEL_SEL_MASK         (0x7U)
#define CLKCTL1_AUDIOPLL0CLKSEL_SEL_SHIFT        (0U)
/*! SEL - Audio PLL0 Clock Select
 *  0b000..FRO Clock (Divided-by-8 selection)
 *  0b001..OSC_CLK clock (User-Selectable)
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_AUDIOPLL0CLKSEL_SEL(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CLKSEL_SEL_SHIFT)) & CLKCTL1_AUDIOPLL0CLKSEL_SEL_MASK)
/*! @} */

/*! @name AUDIOPLL0CTL0 - Audio PLL0 Control 0 */
/*! @{ */
#define CLKCTL1_AUDIOPLL0CTL0_BYPASS_MASK        (0x1U)
#define CLKCTL1_AUDIOPLL0CTL0_BYPASS_SHIFT       (0U)
/*! BYPASS - AUDIOPLL0 BYPASS Mode
 *  0b0..PFD outputs are PFD-programmed clocks
 *  0b1..Bypass Mode. PFD outputs are sourced directly from the reference input clock
 */
#define CLKCTL1_AUDIOPLL0CTL0_BYPASS(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CTL0_BYPASS_SHIFT)) & CLKCTL1_AUDIOPLL0CTL0_BYPASS_MASK)
#define CLKCTL1_AUDIOPLL0CTL0_RESET_MASK         (0x2U)
#define CLKCTL1_AUDIOPLL0CTL0_RESET_SHIFT        (1U)
/*! RESET - AUDIOPLL0 Reset
 *  0b0..AUDIOPLL0 reset is removed
 *  0b1..AUDIOPLL0 is placed into reset
 */
#define CLKCTL1_AUDIOPLL0CTL0_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CTL0_RESET_SHIFT)) & CLKCTL1_AUDIOPLL0CTL0_RESET_MASK)
#define CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA_MASK (0x2000U)
#define CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA_SHIFT (13U)
/*! HOLDRINGOFF_ENA - Hold Ring Off Control
 *  0b0..Disable
 *  0b1..Enable
 */
#define CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA_SHIFT)) & CLKCTL1_AUDIOPLL0CTL0_HOLDRINGOFF_ENA_MASK)
#define CLKCTL1_AUDIOPLL0CTL0_MULT_MASK          (0xFF0000U)
#define CLKCTL1_AUDIOPLL0CTL0_MULT_SHIFT         (16U)
/*! MULT - Multiplication Factor for F SYSPLL0_OUTPUT
 *  0b00010000..Divide by 16
 *  0b00010001..Divide by 17
 *  0b00010100..Divide by 20
 *  0b00010110..Divide by 22
 *  0b00011011..Divide by 27
 *  0b00100001..Divide by 33
 */
#define CLKCTL1_AUDIOPLL0CTL0_MULT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0CTL0_MULT_SHIFT)) & CLKCTL1_AUDIOPLL0CTL0_MULT_MASK)
/*! @} */

/*! @name AUDIOPLL0LOCKTIMEDIV2 - Audio PLL0 Lock Time Divide-by-2 */
/*! @{ */
#define CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_MASK (0xFFFFU)
#define CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_SHIFT (0U)
/*! LOCKTIMEDIV2 - AUDIOPLL0 Lock Time Divide-by-2
 */
#define CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2(x) (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_SHIFT)) & CLKCTL1_AUDIOPLL0LOCKTIMEDIV2_LOCKTIMEDIV2_MASK)
/*! @} */

/*! @name AUDIOPLL0NUM - Audio PLL0 Numerator */
/*! @{ */
#define CLKCTL1_AUDIOPLL0NUM_NUM_MASK            (0x3FFFFFFFU)
#define CLKCTL1_AUDIOPLL0NUM_NUM_SHIFT           (0U)
/*! NUM - Numerator
 */
#define CLKCTL1_AUDIOPLL0NUM_NUM(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0NUM_NUM_SHIFT)) & CLKCTL1_AUDIOPLL0NUM_NUM_MASK)
/*! @} */

/*! @name AUDIOPLL0DENOM - Audio PLL0 Denominator */
/*! @{ */
#define CLKCTL1_AUDIOPLL0DENOM_DENOM_MASK        (0x3FFFFFFFU)
#define CLKCTL1_AUDIOPLL0DENOM_DENOM_SHIFT       (0U)
/*! DENOM - Denominator
 */
#define CLKCTL1_AUDIOPLL0DENOM_DENOM(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0DENOM_DENOM_SHIFT)) & CLKCTL1_AUDIOPLL0DENOM_DENOM_MASK)
/*! @} */

/*! @name AUDIOPLL0PFD - Audio PLL0 PFD */
/*! @{ */
#define CLKCTL1_AUDIOPLL0PFD_PFD0_MASK           (0x3FU)
#define CLKCTL1_AUDIOPLL0PFD_PFD0_SHIFT          (0U)
/*! PFD0 - PLL Fractional Divider 0
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD0(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD0_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD0_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY_MASK    (0x40U)
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY_SHIFT   (6U)
/*! PFD0_CLKRDY - PFD0 Clock Ready Status Flag
 *  0b0..Not ready
 *  0b1..Ready
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD0_CLKRDY_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE_MASK   (0x80U)
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE_SHIFT  (7U)
/*! PFD0_CLKGATE - PFD0 Clock Gate
 *  0b0..PFD0 clock is not gated
 *  0b1..PFD0 clock is gated
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD0_CLKGATE_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_MASK           (0x3F00U)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_SHIFT          (8U)
/*! PFD1 - PLL Fractional Divider 1
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD1(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD1_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD1_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY_MASK    (0x4000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY_SHIFT   (14U)
/*! PFD1_CLKRDY - PFD1 Clock Ready Status Flag
 *  0b0..Not ready
 *  0b1..Ready
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD1_CLKRDY_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE_MASK   (0x8000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE_SHIFT  (15U)
/*! PFD1_CLKGATE - PFD1 Clock Gate
 *  0b0..PFD1 clock is not gated
 *  0b1..PFD1 clock is gated
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD1_CLKGATE_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_MASK           (0x3F0000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_SHIFT          (16U)
/*! PFD2 - PLL Fractional Divider 2
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD2(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD2_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD2_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY_MASK    (0x400000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY_SHIFT   (22U)
/*! PFD2_CLKRDY - PFD2 Clock Ready Status Flag
 *  0b0..Not ready
 *  0b1..Ready
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD2_CLKRDY_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE_MASK   (0x800000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE_SHIFT  (23U)
/*! PFD2_CLKGATE - PFD2 Clock Gate
 *  0b0..PFD2 clock is not gated
 *  0b1..PFD2 clock is gated
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD2_CLKGATE_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_MASK           (0x3F000000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_SHIFT          (24U)
/*! PFD3 - PLL Fractional Divider 3
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD3(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD3_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD3_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY_MASK    (0x40000000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY_SHIFT   (30U)
/*! PFD3_CLKRDY - PFD3 Clock Ready Status Flag
 *  0b0..Not ready
 *  0b1..Ready
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY(x)      (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD3_CLKRDY_MASK)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE_MASK   (0x80000000U)
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE_SHIFT  (31U)
/*! PFD3_CLKGATE - PFD3 Clock Gate
 *  0b0..PFD3 clock is not gated
 *  0b1..PFD3 clock is gated
 */
#define CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE(x)     (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE_SHIFT)) & CLKCTL1_AUDIOPLL0PFD_PFD3_CLKGATE_MASK)
/*! @} */

/*! @name AUDIOPLLCLKDIV - Audio PLL Clock Divider */
/*! @{ */
#define CLKCTL1_AUDIOPLLCLKDIV_DIV_MASK          (0xFFU)
#define CLKCTL1_AUDIOPLLCLKDIV_DIV_SHIFT         (0U)
/*! DIV - 32 KHz Wake Clock Divider Value
 */
#define CLKCTL1_AUDIOPLLCLKDIV_DIV(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLLCLKDIV_DIV_SHIFT)) & CLKCTL1_AUDIOPLLCLKDIV_DIV_MASK)
#define CLKCTL1_AUDIOPLLCLKDIV_RESET_MASK        (0x20000000U)
#define CLKCTL1_AUDIOPLLCLKDIV_RESET_SHIFT       (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_AUDIOPLLCLKDIV_RESET(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLLCLKDIV_RESET_SHIFT)) & CLKCTL1_AUDIOPLLCLKDIV_RESET_MASK)
#define CLKCTL1_AUDIOPLLCLKDIV_HALT_MASK         (0x40000000U)
#define CLKCTL1_AUDIOPLLCLKDIV_HALT_SHIFT        (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_AUDIOPLLCLKDIV_HALT(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLLCLKDIV_HALT_SHIFT)) & CLKCTL1_AUDIOPLLCLKDIV_HALT_MASK)
#define CLKCTL1_AUDIOPLLCLKDIV_REQFLAG_MASK      (0x80000000U)
#define CLKCTL1_AUDIOPLLCLKDIV_REQFLAG_SHIFT     (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished
 *  0b1..The Divider value has changed
 */
#define CLKCTL1_AUDIOPLLCLKDIV_REQFLAG(x)        (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOPLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_AUDIOPLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DSPCPUCLKDIV - DSP CPU Clock Divider */
/*! @{ */
#define CLKCTL1_DSPCPUCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_DSPCPUCLKDIV_DIV_SHIFT           (0U)
/*! DIV - DSP Clock Divider Value
 */
#define CLKCTL1_DSPCPUCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKDIV_DIV_SHIFT)) & CLKCTL1_DSPCPUCLKDIV_DIV_MASK)
#define CLKCTL1_DSPCPUCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_DSPCPUCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_DSPCPUCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKDIV_RESET_SHIFT)) & CLKCTL1_DSPCPUCLKDIV_RESET_MASK)
#define CLKCTL1_DSPCPUCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_DSPCPUCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_DSPCPUCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKDIV_HALT_SHIFT)) & CLKCTL1_DSPCPUCLKDIV_HALT_MASK)
#define CLKCTL1_DSPCPUCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_DSPCPUCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_DSPCPUCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_DSPCPUCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DSPCPUCLKSELA - DSP CPU Clock Select A */
/*! @{ */
#define CLKCTL1_DSPCPUCLKSELA_SEL_MASK           (0x3U)
#define CLKCTL1_DSPCPUCLKSELA_SEL_SHIFT          (0U)
/*! SEL - DSP Main 1st Stage Control Clock Source
 *  0b00..FRO Clock
 *  0b01..OSC_CLK Clock
 *  0b10..Low Power Oscillator Clock (LPOSC)
 *  0b11..Reserved
 */
#define CLKCTL1_DSPCPUCLKSELA_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKSELA_SEL_SHIFT)) & CLKCTL1_DSPCPUCLKSELA_SEL_MASK)
/*! @} */

/*! @name DSPCPUCLKSELB - DSP CPU Clock Select B */
/*! @{ */
#define CLKCTL1_DSPCPUCLKSELB_SEL_MASK           (0x3U)
#define CLKCTL1_DSPCPUCLKSELB_SEL_SHIFT          (0U)
/*! SEL - Main Clock Source
 *  0b00..MAINCLKSELA 1st Stage Clock
 *  0b01..Main System PLL Clock
 *  0b10..DSP System PLL Clock
 *  0b11..RTC 32 KHz Clock
 */
#define CLKCTL1_DSPCPUCLKSELB_SEL(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DSPCPUCLKSELB_SEL_SHIFT)) & CLKCTL1_DSPCPUCLKSELB_SEL_MASK)
/*! @} */

/*! @name OSEVENTTFCLKSEL - OS Event Timer Functional Clock Select */
/*! @{ */
#define CLKCTL1_OSEVENTTFCLKSEL_SEL_MASK         (0x7U)
#define CLKCTL1_OSEVENTTFCLKSEL_SEL_SHIFT        (0U)
/*! SEL - OS Event Timer Functional Clock Source
 *  0b000..Low Power Oscillator Clock (LPOSC)
 *  0b001..RTC 32 KHz Clock
 *  0b010..HCLK Free-Running Clock (Global Time Stamping)
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_OSEVENTTFCLKSEL_SEL(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_OSEVENTTFCLKSEL_SEL_SHIFT)) & CLKCTL1_OSEVENTTFCLKSEL_SEL_MASK)
/*! @} */

/*! @name FRGCLKSEL - Fractional Rate Generator 0 Clock Select..Fractional Rate Generator 16 Clock Select */
/*! @{ */
#define CLKCTL1_FRGCLKSEL_SEL_MASK               (0x7U)
#define CLKCTL1_FRGCLKSEL_SEL_SHIFT              (0U)
/*! SEL - Fractional Generator 16 Clock Source
 *  0b000..Main Clock
 *  0b001..FRG PLL Clock
 *  0b010..FRO Clock Divided by 4
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_FRGCLKSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGCLKSEL_SEL_SHIFT)) & CLKCTL1_FRGCLKSEL_SEL_MASK)
/*! @} */

/* The count of CLKCTL1_FRGCLKSEL */
#define CLKCTL1_FRGCLKSEL_COUNT                  (17U)

/*! @name FRGCTL - Fractional Rate Generator 0 Control..Fractional Rate Generator 16 Control */
/*! @{ */
#define CLKCTL1_FRGCTL_DIV_MASK                  (0xFFU)
#define CLKCTL1_FRGCTL_DIV_SHIFT                 (0U)
#define CLKCTL1_FRGCTL_DIV(x)                    (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGCTL_DIV_SHIFT)) & CLKCTL1_FRGCTL_DIV_MASK)
#define CLKCTL1_FRGCTL_MULT_MASK                 (0xFF00U)
#define CLKCTL1_FRGCTL_MULT_SHIFT                (8U)
#define CLKCTL1_FRGCTL_MULT(x)                   (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGCTL_MULT_SHIFT)) & CLKCTL1_FRGCTL_MULT_MASK)
/*! @} */

/* The count of CLKCTL1_FRGCTL */
#define CLKCTL1_FRGCTL_COUNT                     (17U)

/*! @name FCFCLKSEL - Flexcomm0 Clock Select..Flexcomm16 Clock Select */
/*! @{ */
#define CLKCTL1_FCFCLKSEL_SEL_MASK               (0x7U)
#define CLKCTL1_FCFCLKSEL_SEL_SHIFT              (0U)
/*! SEL - Flexcomm Functional Clock Source
 *  0b000..FRO Clock Divided-by-4
 *  0b001..Audio PLL Clock
 *  0b010..Master Clock In
 *  0b011..FCn FRG Clock
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_FCFCLKSEL_SEL(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FCFCLKSEL_SEL_SHIFT)) & CLKCTL1_FCFCLKSEL_SEL_MASK)
/*! @} */

/* The count of CLKCTL1_FCFCLKSEL */
#define CLKCTL1_FCFCLKSEL_COUNT                  (17U)

/*! @name FRG17CLKSEL - Fractional Rate Generator 17 Clock Select */
/*! @{ */
#define CLKCTL1_FRG17CLKSEL_SEL_MASK             (0x7U)
#define CLKCTL1_FRG17CLKSEL_SEL_SHIFT            (0U)
/*! SEL - Fractional Generator 17 Clock Source
 *  0b000..Main Clock
 *  0b001..FRG PLL Clock
 *  0b010..FRO Clock Divided by 4
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_FRG17CLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRG17CLKSEL_SEL_SHIFT)) & CLKCTL1_FRG17CLKSEL_SEL_MASK)
/*! @} */

/*! @name FRG17CTL - Fractional Rate Generator 17 Control */
/*! @{ */
#define CLKCTL1_FRG17CTL_DIV_MASK                (0xFFU)
#define CLKCTL1_FRG17CTL_DIV_SHIFT               (0U)
#define CLKCTL1_FRG17CTL_DIV(x)                  (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRG17CTL_DIV_SHIFT)) & CLKCTL1_FRG17CTL_DIV_MASK)
#define CLKCTL1_FRG17CTL_MULT_MASK               (0xFF00U)
#define CLKCTL1_FRG17CTL_MULT_SHIFT              (8U)
#define CLKCTL1_FRG17CTL_MULT(x)                 (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRG17CTL_MULT_SHIFT)) & CLKCTL1_FRG17CTL_MULT_MASK)
/*! @} */

/*! @name FLEXIOCLKSEL - FlexIO Clock Select */
/*! @{ */
#define CLKCTL1_FLEXIOCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL1_FLEXIOCLKSEL_SEL_SHIFT           (0U)
/*! SEL - FlexIO Functional Clock Source
 *  0b000..FRO Clock (Divided-by-4 selection)
 *  0b001..Audio PLL Clock
 *  0b010..Master Clock In
 *  0b011..FC17 FRG Clock
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_FLEXIOCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FLEXIOCLKSEL_SEL_SHIFT)) & CLKCTL1_FLEXIOCLKSEL_SEL_MASK)
/*! @} */

/*! @name FLEXIOCLKDIV - FlexIO Clock Divider */
/*! @{ */
#define CLKCTL1_FLEXIOCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_FLEXIOCLKDIV_DIV_SHIFT           (0U)
/*! DIV - FLEXIO Clock Divider Value
 */
#define CLKCTL1_FLEXIOCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FLEXIOCLKDIV_DIV_SHIFT)) & CLKCTL1_FLEXIOCLKDIV_DIV_MASK)
#define CLKCTL1_FLEXIOCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_FLEXIOCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_FLEXIOCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FLEXIOCLKDIV_RESET_SHIFT)) & CLKCTL1_FLEXIOCLKDIV_RESET_MASK)
#define CLKCTL1_FLEXIOCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_FLEXIOCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_FLEXIOCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FLEXIOCLKDIV_HALT_SHIFT)) & CLKCTL1_FLEXIOCLKDIV_HALT_MASK)
#define CLKCTL1_FLEXIOCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_FLEXIOCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed
 */
#define CLKCTL1_FLEXIOCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FLEXIOCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_FLEXIOCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name FRGPLLCLKDIV - Fractional Rate Generator PLL Clock Divider */
/*! @{ */
#define CLKCTL1_FRGPLLCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_FRGPLLCLKDIV_DIV_SHIFT           (0U)
/*! DIV - FRG PLL Clock Divider Value
 */
#define CLKCTL1_FRGPLLCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGPLLCLKDIV_DIV_SHIFT)) & CLKCTL1_FRGPLLCLKDIV_DIV_MASK)
#define CLKCTL1_FRGPLLCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_FRGPLLCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_FRGPLLCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGPLLCLKDIV_RESET_SHIFT)) & CLKCTL1_FRGPLLCLKDIV_RESET_MASK)
#define CLKCTL1_FRGPLLCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_FRGPLLCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_FRGPLLCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGPLLCLKDIV_HALT_SHIFT)) & CLKCTL1_FRGPLLCLKDIV_HALT_MASK)
#define CLKCTL1_FRGPLLCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_FRGPLLCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_FRGPLLCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_FRGPLLCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_FRGPLLCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name DMIC0FCLKSEL - DMIC0 Functional Clock Select */
/*! @{ */
#define CLKCTL1_DMIC0FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL1_DMIC0FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - DMIC Functional Clock Source
 *  0b000..FRO Clock (Divided-by-4 selection)
 *  0b001..Audio PLL Clock
 *  0b010..Master Clock In
 *  0b011..Low Power Oscillator Clock (LPOSC)
 *  0b100..32 KHz Wake Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_DMIC0FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKSEL_SEL_SHIFT)) & CLKCTL1_DMIC0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name DMIC0FCLKDIV - DMIC0 Functional Clock Divider */
/*! @{ */
#define CLKCTL1_DMIC0FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_DMIC0FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - 32 KHz Wake Clock Divider Value
 */
#define CLKCTL1_DMIC0FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKDIV_DIV_SHIFT)) & CLKCTL1_DMIC0FCLKDIV_DIV_MASK)
#define CLKCTL1_DMIC0FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_DMIC0FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_DMIC0FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKDIV_RESET_SHIFT)) & CLKCTL1_DMIC0FCLKDIV_RESET_MASK)
#define CLKCTL1_DMIC0FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_DMIC0FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_DMIC0FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKDIV_HALT_SHIFT)) & CLKCTL1_DMIC0FCLKDIV_HALT_MASK)
#define CLKCTL1_DMIC0FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_DMIC0FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_DMIC0FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_DMIC0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_DMIC0FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name CT32BITFCLKSEL - CT32BIT 0 Functional Clock Select..CT32BIT 4 Functional Clock Select */
/*! @{ */
#define CLKCTL1_CT32BITFCLKSEL_SEL_MASK          (0x7U)
#define CLKCTL1_CT32BITFCLKSEL_SEL_SHIFT         (0U)
/*! SEL - CT32BIT 4 Functional Clock Source
 *  0b000..Main Clock
 *  0b001..FRO Clock
 *  0b010..Audio PLL Clock
 *  0b011..Master Clock In
 *  0b100..32 KHZ Wake Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_CT32BITFCLKSEL_SEL(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CT32BITFCLKSEL_SEL_SHIFT)) & CLKCTL1_CT32BITFCLKSEL_SEL_MASK)
/*! @} */

/* The count of CLKCTL1_CT32BITFCLKSEL */
#define CLKCTL1_CT32BITFCLKSEL_COUNT             (5U)

/*! @name AUDIOMCLKSEL - Audio MCLK Clock Select */
/*! @{ */
#define CLKCTL1_AUDIOMCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL1_AUDIOMCLKSEL_SEL_SHIFT           (0U)
/*! SEL - Audio MCLK Clock Source Select
 *  0b000..FRO Clock (Divided-by-8 selection)
 *  0b001..AUDIO PLL Clock (Shared Domain)
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_AUDIOMCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKSEL_SEL_SHIFT)) & CLKCTL1_AUDIOMCLKSEL_SEL_MASK)
/*! @} */

/*! @name AUDIOMCLKDIV - Audio MCLK Clock Divider */
/*! @{ */
#define CLKCTL1_AUDIOMCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_AUDIOMCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Audio MCLK Clock Divider Value
 */
#define CLKCTL1_AUDIOMCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKDIV_DIV_SHIFT)) & CLKCTL1_AUDIOMCLKDIV_DIV_MASK)
#define CLKCTL1_AUDIOMCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_AUDIOMCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_AUDIOMCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKDIV_RESET_SHIFT)) & CLKCTL1_AUDIOMCLKDIV_RESET_MASK)
#define CLKCTL1_AUDIOMCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_AUDIOMCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_AUDIOMCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKDIV_HALT_SHIFT)) & CLKCTL1_AUDIOMCLKDIV_HALT_MASK)
#define CLKCTL1_AUDIOMCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_AUDIOMCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_AUDIOMCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_AUDIOMCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_AUDIOMCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name CLKOUTSEL0 - CLKOUT Clock Select 0 */
/*! @{ */
#define CLKCTL1_CLKOUTSEL0_SEL_MASK              (0x7U)
#define CLKCTL1_CLKOUTSEL0_SEL_SHIFT             (0U)
/*! SEL - Clock Output Select 1st Stage
 *  0b000..OSC_CLK Clock
 *  0b001..Low Power Oscillator Clock (LPOSC)
 *  0b010..FRO Clock
 *  0b011..Main Clock
 *  0b100..DSP Main Clock
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_CLKOUTSEL0_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTSEL0_SEL_SHIFT)) & CLKCTL1_CLKOUTSEL0_SEL_MASK)
/*! @} */

/*! @name CLKOUTSEL1 - CLKOUT Clock Select 1 */
/*! @{ */
#define CLKCTL1_CLKOUTSEL1_SEL_MASK              (0x7U)
#define CLKCTL1_CLKOUTSEL1_SEL_SHIFT             (0U)
/*! SEL - Clock Out Source
 *  0b000..CLKOUTSEL0 Multiplexed Output
 *  0b001..Main System PLL Clock
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..DSP PLL Clock
 *  0b100..SYSPLL0 AUX1_PLL_Clock
 *  0b101..AUDIO PLL Clock
 *  0b110..32 KHz RTC Clock
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_CLKOUTSEL1_SEL(x)                (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTSEL1_SEL_SHIFT)) & CLKCTL1_CLKOUTSEL1_SEL_MASK)
/*! @} */

/*! @name CLKOUTFCLKDIV - CLKOUT Functional Clock Divider */
/*! @{ */
#define CLKCTL1_CLKOUTFCLKDIV_DIV_MASK           (0xFFU)
#define CLKCTL1_CLKOUTFCLKDIV_DIV_SHIFT          (0U)
/*! DIV - Clock-Out Clock Divider Value
 */
#define CLKCTL1_CLKOUTFCLKDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTFCLKDIV_DIV_SHIFT)) & CLKCTL1_CLKOUTFCLKDIV_DIV_MASK)
#define CLKCTL1_CLKOUTFCLKDIV_RESET_MASK         (0x20000000U)
#define CLKCTL1_CLKOUTFCLKDIV_RESET_SHIFT        (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_CLKOUTFCLKDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTFCLKDIV_RESET_SHIFT)) & CLKCTL1_CLKOUTFCLKDIV_RESET_MASK)
#define CLKCTL1_CLKOUTFCLKDIV_HALT_MASK          (0x40000000U)
#define CLKCTL1_CLKOUTFCLKDIV_HALT_SHIFT         (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_CLKOUTFCLKDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTFCLKDIV_HALT_SHIFT)) & CLKCTL1_CLKOUTFCLKDIV_HALT_MASK)
#define CLKCTL1_CLKOUTFCLKDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL1_CLKOUTFCLKDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed
 */
#define CLKCTL1_CLKOUTFCLKDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_CLKOUTFCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_CLKOUTFCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name I3C01FCLKSEL - I3C0, I3C1 Functional Clock Select */
/*! @{ */
#define CLKCTL1_I3C01FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL1_I3C01FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - I3C0, I3C1 Clock Source
 *  0b000..Main Clock
 *  0b001..FRO Clock (Divided-by-8 selection)
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_I3C01FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSEL_SEL_SHIFT)) & CLKCTL1_I3C01FCLKSEL_SEL_MASK)
/*! @} */

/*! @name I3C01FCLKSTCSEL - I3C0, I3C1 Functional Slow Time Control Clock Select */
/*! @{ */
#define CLKCTL1_I3C01FCLKSTCSEL_SEL_MASK         (0x7U)
#define CLKCTL1_I3C01FCLKSTCSEL_SEL_SHIFT        (0U)
/*! SEL - I3C0, I3C1 Clock Source
 *  0b000..I3C0 FCLK
 *  0b001..Low Power Oscillator Clock (LPOSC)
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_I3C01FCLKSTCSEL_SEL(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSTCSEL_SEL_SHIFT)) & CLKCTL1_I3C01FCLKSTCSEL_SEL_MASK)
/*! @} */

/*! @name I3C01FCLKSTCDIV - I3C0, I3C1 Functional Slow Time Control Clock Divider */
/*! @{ */
#define CLKCTL1_I3C01FCLKSTCDIV_DIV_MASK         (0xFFU)
#define CLKCTL1_I3C01FCLKSTCDIV_DIV_SHIFT        (0U)
/*! DIV - I3C0, I3C1 Clock Divider Value
 */
#define CLKCTL1_I3C01FCLKSTCDIV_DIV(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSTCDIV_DIV_SHIFT)) & CLKCTL1_I3C01FCLKSTCDIV_DIV_MASK)
#define CLKCTL1_I3C01FCLKSTCDIV_RESET_MASK       (0x20000000U)
#define CLKCTL1_I3C01FCLKSTCDIV_RESET_SHIFT      (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_I3C01FCLKSTCDIV_RESET(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSTCDIV_RESET_SHIFT)) & CLKCTL1_I3C01FCLKSTCDIV_RESET_MASK)
#define CLKCTL1_I3C01FCLKSTCDIV_HALT_MASK        (0x40000000U)
#define CLKCTL1_I3C01FCLKSTCDIV_HALT_SHIFT       (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_I3C01FCLKSTCDIV_HALT(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSTCDIV_HALT_SHIFT)) & CLKCTL1_I3C01FCLKSTCDIV_HALT_MASK)
#define CLKCTL1_I3C01FCLKSTCDIV_REQFLAG_MASK     (0x80000000U)
#define CLKCTL1_I3C01FCLKSTCDIV_REQFLAG_SHIFT    (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_I3C01FCLKSTCDIV_REQFLAG(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSTCDIV_REQFLAG_SHIFT)) & CLKCTL1_I3C01FCLKSTCDIV_REQFLAG_MASK)
/*! @} */

/*! @name I3C01FCLKSDIV - I3C0, I3C1 Functional Slow Clock Divider */
/*! @{ */
#define CLKCTL1_I3C01FCLKSDIV_DIV_MASK           (0xFFU)
#define CLKCTL1_I3C01FCLKSDIV_DIV_SHIFT          (0U)
/*! DIV - I3C0, I3C1 Clock Divider Value
 */
#define CLKCTL1_I3C01FCLKSDIV_DIV(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSDIV_DIV_SHIFT)) & CLKCTL1_I3C01FCLKSDIV_DIV_MASK)
#define CLKCTL1_I3C01FCLKSDIV_RESET_MASK         (0x20000000U)
#define CLKCTL1_I3C01FCLKSDIV_RESET_SHIFT        (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_I3C01FCLKSDIV_RESET(x)           (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSDIV_RESET_SHIFT)) & CLKCTL1_I3C01FCLKSDIV_RESET_MASK)
#define CLKCTL1_I3C01FCLKSDIV_HALT_MASK          (0x40000000U)
#define CLKCTL1_I3C01FCLKSDIV_HALT_SHIFT         (30U)
/*! HALT - Halt the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_I3C01FCLKSDIV_HALT(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSDIV_HALT_SHIFT)) & CLKCTL1_I3C01FCLKSDIV_HALT_MASK)
#define CLKCTL1_I3C01FCLKSDIV_REQFLAG_MASK       (0x80000000U)
#define CLKCTL1_I3C01FCLKSDIV_REQFLAG_SHIFT      (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_I3C01FCLKSDIV_REQFLAG(x)         (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSDIV_REQFLAG_SHIFT)) & CLKCTL1_I3C01FCLKSDIV_REQFLAG_MASK)
/*! @} */

/*! @name I3C01FCLKDIV - I3C0, I3C1 Functional Clock Divider */
/*! @{ */
#define CLKCTL1_I3C01FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_I3C01FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - I3C0, I3C1 Clock Divider Value
 */
#define CLKCTL1_I3C01FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKDIV_DIV_SHIFT)) & CLKCTL1_I3C01FCLKDIV_DIV_MASK)
#define CLKCTL1_I3C01FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_I3C01FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_I3C01FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKDIV_RESET_SHIFT)) & CLKCTL1_I3C01FCLKDIV_RESET_MASK)
#define CLKCTL1_I3C01FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_I3C01FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_I3C01FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKDIV_HALT_SHIFT)) & CLKCTL1_I3C01FCLKDIV_HALT_MASK)
#define CLKCTL1_I3C01FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_I3C01FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_I3C01FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_I3C01FCLKDIV_REQFLAG_MASK)
/*! @} */

/*! @name I3C01FCLKSTSTCLKSEL - I3C01 Functional Clock Select */
/*! @{ */
#define CLKCTL1_I3C01FCLKSTSTCLKSEL_SEL_MASK     (0x7U)
#define CLKCTL1_I3C01FCLKSTSTCLKSEL_SEL_SHIFT    (0U)
/*! SEL - I3C0, I3C1 FCLK Test Clock Source
 *  0b000..Low Power Oscillator Clock (LPOSC)
 *  0b001..Reserved
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_I3C01FCLKSTSTCLKSEL_SEL(x)       (((uint32_t)(((uint32_t)(x)) << CLKCTL1_I3C01FCLKSTSTCLKSEL_SEL_SHIFT)) & CLKCTL1_I3C01FCLKSTSTCLKSEL_SEL_MASK)
/*! @} */

/*! @name WDT1FCLKSEL - Watchdog Timer 1 Functional Clock Select */
/*! @{ */
#define CLKCTL1_WDT1FCLKSEL_SEL_MASK             (0x7U)
#define CLKCTL1_WDT1FCLKSEL_SEL_SHIFT            (0U)
/*! SEL - WDT1 Functional Clock Source
 *  0b000..Low Power Oscillator Clock (LPOSC)
 *  0b001..Main Clock
 *  0b010..Reserved
 *  0b011..Reserved
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_WDT1FCLKSEL_SEL(x)               (((uint32_t)(((uint32_t)(x)) << CLKCTL1_WDT1FCLKSEL_SEL_SHIFT)) & CLKCTL1_WDT1FCLKSEL_SEL_MASK)
/*! @} */

/*! @name ACMP0FCLKSEL - Analog Comparator 0 Clock Select */
/*! @{ */
#define CLKCTL1_ACMP0FCLKSEL_SEL_MASK            (0x7U)
#define CLKCTL1_ACMP0FCLKSEL_SEL_SHIFT           (0U)
/*! SEL - ACMP0 Fast Functional Clock Source
 *  0b000..Main Clock
 *  0b001..FRO Clock (Divided-by-4 selection)
 *  0b010..SYSPLL0 AUX0_PLL_Clock
 *  0b011..SYSPLL0 AUX1_PLL_Clock
 *  0b100..Reserved
 *  0b101..Reserved
 *  0b110..Reserved
 *  0b111..None, output gated to reduce power
 */
#define CLKCTL1_ACMP0FCLKSEL_SEL(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKSEL_SEL_SHIFT)) & CLKCTL1_ACMP0FCLKSEL_SEL_MASK)
/*! @} */

/*! @name ACMP0FCLKDIV - Analog comparator 0 FCLK divider */
/*! @{ */
#define CLKCTL1_ACMP0FCLKDIV_DIV_MASK            (0xFFU)
#define CLKCTL1_ACMP0FCLKDIV_DIV_SHIFT           (0U)
/*! DIV - Clock Out Clock Divider Value
 */
#define CLKCTL1_ACMP0FCLKDIV_DIV(x)              (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKDIV_DIV_SHIFT)) & CLKCTL1_ACMP0FCLKDIV_DIV_MASK)
#define CLKCTL1_ACMP0FCLKDIV_RESET_MASK          (0x20000000U)
#define CLKCTL1_ACMP0FCLKDIV_RESET_SHIFT         (29U)
/*! RESET - Reset the Divider Counter
 *  0b0..No effect
 *  0b1..Reset the Divider Counter
 */
#define CLKCTL1_ACMP0FCLKDIV_RESET(x)            (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKDIV_RESET_SHIFT)) & CLKCTL1_ACMP0FCLKDIV_RESET_MASK)
#define CLKCTL1_ACMP0FCLKDIV_HALT_MASK           (0x40000000U)
#define CLKCTL1_ACMP0FCLKDIV_HALT_SHIFT          (30U)
/*! HALT - Halts the Divider Counter
 *  0b0..No effect
 *  0b1..Halt (stop) the Divider Counter
 */
#define CLKCTL1_ACMP0FCLKDIV_HALT(x)             (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKDIV_HALT_SHIFT)) & CLKCTL1_ACMP0FCLKDIV_HALT_MASK)
#define CLKCTL1_ACMP0FCLKDIV_REQFLAG_MASK        (0x80000000U)
#define CLKCTL1_ACMP0FCLKDIV_REQFLAG_SHIFT       (31U)
/*! REQFLAG - Divider Status Flag
 *  0b0..The Divider change has finished (clock being divided must be running for this status to change).
 *  0b1..The Divider value has changed.
 */
#define CLKCTL1_ACMP0FCLKDIV_REQFLAG(x)          (((uint32_t)(((uint32_t)(x)) << CLKCTL1_ACMP0FCLKDIV_REQFLAG_SHIFT)) & CLKCTL1_ACMP0FCLKDIV_REQFLAG_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CLKCTL1_Register_Masks */


/* CLKCTL1 - Peripheral instance base addresses */
/** Peripheral CLKCTL1 base address */
#define CLKCTL1_BASE                             (0x40021000u)
/** Peripheral CLKCTL1 base pointer */
#define CLKCTL1                                  ((CLKCTL1_Type *)CLKCTL1_BASE)
/** Array initializer of CLKCTL1 peripheral base addresses */
#define CLKCTL1_BASE_ADDRS                       { CLKCTL1_BASE }
/** Array initializer of CLKCTL1 peripheral base pointers */
#define CLKCTL1_BASE_PTRS                        { CLKCTL1 }

/*!
 * @}
 */ /* end of group CLKCTL1_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CRC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Peripheral_Access_Layer CRC Peripheral Access Layer
 * @{
 */

/** CRC - Register Layout Typedef */
typedef struct {
  __IO uint32_t MODE;                              /**< MODE Register, offset: 0x0 */
  __IO uint32_t SEED;                              /**< CRC Seed Register, offset: 0x4 */
  union {                                          /* offset: 0x8 */
    __I  uint32_t SUM;                               /**< CRC Sum, offset: 0x8 */
    __IO uint32_t WR_DATA;                           /**< CRC Write Data, offset: 0x8 */
  };
} CRC_Type;

/* ----------------------------------------------------------------------------
   -- CRC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CRC_Register_Masks CRC Register Masks
 * @{
 */

/*! @name MODE - MODE Register */
/*! @{ */
#define CRC_MODE_CRC_POLY_MASK                   (0x3U)
#define CRC_MODE_CRC_POLY_SHIFT                  (0U)
/*! CRC_POLY - CRC Polynomial
 *  0b00..Use CRC-CCITT polynomial
 *  0b01..Use CRC-16 polynomial
 *  0b10..Use CRC-32 polynomial
 *  0b11..Reserved
 */
#define CRC_MODE_CRC_POLY(x)                     (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CRC_POLY_SHIFT)) & CRC_MODE_CRC_POLY_MASK)
#define CRC_MODE_BIT_RVS_WR_MASK                 (0x4U)
#define CRC_MODE_BIT_RVS_WR_SHIFT                (2U)
/*! BIT_RVS_WR - Bit-order Reverse for Write Data
 *  0b0..Do not use bit-order reverse for WR_DATA (per byte)
 *  0b1..Use bit-order reverse for WR_DATA (per byte)
 */
#define CRC_MODE_BIT_RVS_WR(x)                   (((uint32_t)(((uint32_t)(x)) << CRC_MODE_BIT_RVS_WR_SHIFT)) & CRC_MODE_BIT_RVS_WR_MASK)
#define CRC_MODE_CMPL_WR_MASK                    (0x8U)
#define CRC_MODE_CMPL_WR_SHIFT                   (3U)
/*! CMPL_WR - 1's Complement for Write Data
 *  0b0..Do not use 1's complement for WR_DATA
 *  0b1..Use 1's complement for WR_DATA
 */
#define CRC_MODE_CMPL_WR(x)                      (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CMPL_WR_SHIFT)) & CRC_MODE_CMPL_WR_MASK)
#define CRC_MODE_BIT_RVS_SUM_MASK                (0x10U)
#define CRC_MODE_BIT_RVS_SUM_SHIFT               (4U)
/*! BIT_RVS_SUM - Bit-order Reverse for CRC Sum
 *  0b0..Do not use bit-order reverse for CRC Sum
 *  0b1..Use bit-order reverse for CRC Sum
 */
#define CRC_MODE_BIT_RVS_SUM(x)                  (((uint32_t)(((uint32_t)(x)) << CRC_MODE_BIT_RVS_SUM_SHIFT)) & CRC_MODE_BIT_RVS_SUM_MASK)
#define CRC_MODE_CMPL_SUM_MASK                   (0x20U)
#define CRC_MODE_CMPL_SUM_SHIFT                  (5U)
/*! CMPL_SUM - 1's Complement for CRC Sum
 *  0b0..Do not use 1's complement for CRC Sum
 *  0b1..Use 1's complement for CRC Sum
 */
#define CRC_MODE_CMPL_SUM(x)                     (((uint32_t)(((uint32_t)(x)) << CRC_MODE_CMPL_SUM_SHIFT)) & CRC_MODE_CMPL_SUM_MASK)
/*! @} */

/*! @name SEED - CRC Seed Register */
/*! @{ */
#define CRC_SEED_CRC_SEED_MASK                   (0xFFFFFFFFU)
#define CRC_SEED_CRC_SEED_SHIFT                  (0U)
/*! CRC_SEED - CRC Seed
 */
#define CRC_SEED_CRC_SEED(x)                     (((uint32_t)(((uint32_t)(x)) << CRC_SEED_CRC_SEED_SHIFT)) & CRC_SEED_CRC_SEED_MASK)
/*! @} */

/*! @name SUM - CRC Sum */
/*! @{ */
#define CRC_SUM_CRC_SUM_MASK                     (0xFFFFFFFFU)
#define CRC_SUM_CRC_SUM_SHIFT                    (0U)
/*! CRC_SUM - CRC Sum
 */
#define CRC_SUM_CRC_SUM(x)                       (((uint32_t)(((uint32_t)(x)) << CRC_SUM_CRC_SUM_SHIFT)) & CRC_SUM_CRC_SUM_MASK)
/*! @} */

/*! @name WR_DATA - CRC Write Data */
/*! @{ */
#define CRC_WR_DATA_WR_DATA_MASK                 (0xFFFFFFFFU)
#define CRC_WR_DATA_WR_DATA_SHIFT                (0U)
/*! WR_DATA - CRC Write Data
 */
#define CRC_WR_DATA_WR_DATA(x)                   (((uint32_t)(((uint32_t)(x)) << CRC_WR_DATA_WR_DATA_SHIFT)) & CRC_WR_DATA_WR_DATA_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group CRC_Register_Masks */


/* CRC - Peripheral instance base addresses */
/** Peripheral CRC_ENGINE base address */
#define CRC_ENGINE_BASE                          (0x40120000u)
/** Peripheral CRC_ENGINE base pointer */
#define CRC_ENGINE                               ((CRC_Type *)CRC_ENGINE_BASE)
/** Array initializer of CRC peripheral base addresses */
#define CRC_BASE_ADDRS                           { CRC_ENGINE_BASE }
/** Array initializer of CRC peripheral base pointers */
#define CRC_BASE_PTRS                            { CRC_ENGINE }

/*!
 * @}
 */ /* end of group CRC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- CTIMER Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Peripheral_Access_Layer CTIMER Peripheral Access Layer
 * @{
 */

/** CTIMER - Register Layout Typedef */
typedef struct {
  __IO uint32_t IR;                                /**< Interrupt Register., offset: 0x0 */
  __IO uint32_t TCR;                               /**< Timer Control Register, offset: 0x4 */
  __IO uint32_t TC;                                /**< Timer Counter, offset: 0x8 */
  __IO uint32_t PR;                                /**< Prescale Register, offset: 0xC */
  __IO uint32_t PC;                                /**< Prescale Counter., offset: 0x10 */
  __IO uint32_t MCR;                               /**< Match Control Register., offset: 0x14 */
  __IO uint32_t MR[4];                             /**< Match Register, array offset: 0x18, array step: 0x4 */
  __IO uint32_t CCR;                               /**< Capture Control Register, offset: 0x28 */
  __I  uint32_t CR[4];                             /**< Capture Register, array offset: 0x2C, array step: 0x4 */
  __IO uint32_t EMR;                               /**< External Match Register, offset: 0x3C */
       uint8_t RESERVED_0[48];
  __IO uint32_t CTCR;                              /**< Count Control Register, offset: 0x70 */
  __IO uint32_t PWMC;                              /**< PWM Control Register, offset: 0x74 */
  __IO uint32_t MSR[4];                            /**< Match Shadow Register, array offset: 0x78, array step: 0x4 */
} CTIMER_Type;

/* ----------------------------------------------------------------------------
   -- CTIMER Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup CTIMER_Register_Masks CTIMER Register Masks
 * @{
 */

/*! @name IR - Interrupt Register. */
/*! @{ */
#define CTIMER_IR_MR0INT_MASK                    (0x1U)
#define CTIMER_IR_MR0INT_SHIFT                   (0U)
/*! MR0INT - Interrupt flag for match channel 0
 */
#define CTIMER_IR_MR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR0INT_SHIFT)) & CTIMER_IR_MR0INT_MASK)
#define CTIMER_IR_MR1INT_MASK                    (0x2U)
#define CTIMER_IR_MR1INT_SHIFT                   (1U)
/*! MR1INT - Interrupt flag for match channel 1
 */
#define CTIMER_IR_MR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR1INT_SHIFT)) & CTIMER_IR_MR1INT_MASK)
#define CTIMER_IR_MR2INT_MASK                    (0x4U)
#define CTIMER_IR_MR2INT_SHIFT                   (2U)
/*! MR2INT - Interrupt flag for match channel 2
 */
#define CTIMER_IR_MR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR2INT_SHIFT)) & CTIMER_IR_MR2INT_MASK)
#define CTIMER_IR_MR3INT_MASK                    (0x8U)
#define CTIMER_IR_MR3INT_SHIFT                   (3U)
/*! MR3INT - Interrupt flag for match channel 3
 */
#define CTIMER_IR_MR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_MR3INT_SHIFT)) & CTIMER_IR_MR3INT_MASK)
#define CTIMER_IR_CR0INT_MASK                    (0x10U)
#define CTIMER_IR_CR0INT_SHIFT                   (4U)
/*! CR0INT - Interrupt flag for capture channel 0 event
 */
#define CTIMER_IR_CR0INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR0INT_SHIFT)) & CTIMER_IR_CR0INT_MASK)
#define CTIMER_IR_CR1INT_MASK                    (0x20U)
#define CTIMER_IR_CR1INT_SHIFT                   (5U)
/*! CR1INT - Interrupt flag for capture channel 1 event
 */
#define CTIMER_IR_CR1INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR1INT_SHIFT)) & CTIMER_IR_CR1INT_MASK)
#define CTIMER_IR_CR2INT_MASK                    (0x40U)
#define CTIMER_IR_CR2INT_SHIFT                   (6U)
/*! CR2INT - Interrupt flag for capture channel 2 event
 */
#define CTIMER_IR_CR2INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR2INT_SHIFT)) & CTIMER_IR_CR2INT_MASK)
#define CTIMER_IR_CR3INT_MASK                    (0x80U)
#define CTIMER_IR_CR3INT_SHIFT                   (7U)
/*! CR3INT - Interrupt flag for capture channel 3 event
 */
#define CTIMER_IR_CR3INT(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_IR_CR3INT_SHIFT)) & CTIMER_IR_CR3INT_MASK)
/*! @} */

/*! @name TCR - Timer Control Register */
/*! @{ */
#define CTIMER_TCR_CEN_MASK                      (0x1U)
#define CTIMER_TCR_CEN_SHIFT                     (0U)
/*! CEN - Counter enable.
 *  0b0..Disabled. The counters are disabled.
 *  0b1..Enabled. The Timer Counter and Prescale Counter are enabled.
 */
#define CTIMER_TCR_CEN(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CEN_SHIFT)) & CTIMER_TCR_CEN_MASK)
#define CTIMER_TCR_CRST_MASK                     (0x2U)
#define CTIMER_TCR_CRST_SHIFT                    (1U)
/*! CRST - Counter reset.
 *  0b0..Disabled. Do nothing.
 *  0b1..Enabled
 */
#define CTIMER_TCR_CRST(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TCR_CRST_SHIFT)) & CTIMER_TCR_CRST_MASK)
/*! @} */

/*! @name TC - Timer Counter */
/*! @{ */
#define CTIMER_TC_TCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_TC_TCVAL_SHIFT                    (0U)
/*! TCVAL - Timer counter value.
 */
#define CTIMER_TC_TCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_TC_TCVAL_SHIFT)) & CTIMER_TC_TCVAL_MASK)
/*! @} */

/*! @name PR - Prescale Register */
/*! @{ */
#define CTIMER_PR_PRVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PR_PRVAL_SHIFT                    (0U)
/*! PRVAL - Prescale reload value.
 */
#define CTIMER_PR_PRVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PR_PRVAL_SHIFT)) & CTIMER_PR_PRVAL_MASK)
/*! @} */

/*! @name PC - Prescale Counter. */
/*! @{ */
#define CTIMER_PC_PCVAL_MASK                     (0xFFFFFFFFU)
#define CTIMER_PC_PCVAL_SHIFT                    (0U)
/*! PCVAL - Prescale counter value.
 */
#define CTIMER_PC_PCVAL(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_PC_PCVAL_SHIFT)) & CTIMER_PC_PCVAL_MASK)
/*! @} */

/*! @name MCR - Match Control Register. */
/*! @{ */
#define CTIMER_MCR_MR0I_MASK                     (0x1U)
#define CTIMER_MCR_MR0I_SHIFT                    (0U)
/*! MR0I - Interrupt on MR0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR0I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0I_SHIFT)) & CTIMER_MCR_MR0I_MASK)
#define CTIMER_MCR_MR0R_MASK                     (0x2U)
#define CTIMER_MCR_MR0R_SHIFT                    (1U)
/*! MR0R - Reset on MR0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR0R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0R_SHIFT)) & CTIMER_MCR_MR0R_MASK)
#define CTIMER_MCR_MR0S_MASK                     (0x4U)
#define CTIMER_MCR_MR0S_SHIFT                    (2U)
/*! MR0S - Stop on MR0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR0S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0S_SHIFT)) & CTIMER_MCR_MR0S_MASK)
#define CTIMER_MCR_MR1I_MASK                     (0x8U)
#define CTIMER_MCR_MR1I_SHIFT                    (3U)
/*! MR1I - Interrupt on MR1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR1I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1I_SHIFT)) & CTIMER_MCR_MR1I_MASK)
#define CTIMER_MCR_MR1R_MASK                     (0x10U)
#define CTIMER_MCR_MR1R_SHIFT                    (4U)
/*! MR1R - Reset on MR1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR1R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1R_SHIFT)) & CTIMER_MCR_MR1R_MASK)
#define CTIMER_MCR_MR1S_MASK                     (0x20U)
#define CTIMER_MCR_MR1S_SHIFT                    (5U)
/*! MR1S - Stop on MR1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR1S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1S_SHIFT)) & CTIMER_MCR_MR1S_MASK)
#define CTIMER_MCR_MR2I_MASK                     (0x40U)
#define CTIMER_MCR_MR2I_SHIFT                    (6U)
/*! MR2I - Interrupt on MR2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR2I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2I_SHIFT)) & CTIMER_MCR_MR2I_MASK)
#define CTIMER_MCR_MR2R_MASK                     (0x80U)
#define CTIMER_MCR_MR2R_SHIFT                    (7U)
/*! MR2R - Reset on MR2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR2R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2R_SHIFT)) & CTIMER_MCR_MR2R_MASK)
#define CTIMER_MCR_MR2S_MASK                     (0x100U)
#define CTIMER_MCR_MR2S_SHIFT                    (8U)
/*! MR2S - Stop on MR2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR2S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2S_SHIFT)) & CTIMER_MCR_MR2S_MASK)
#define CTIMER_MCR_MR3I_MASK                     (0x200U)
#define CTIMER_MCR_MR3I_SHIFT                    (9U)
/*! MR3I - Interrupt on MR3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR3I(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3I_SHIFT)) & CTIMER_MCR_MR3I_MASK)
#define CTIMER_MCR_MR3R_MASK                     (0x400U)
#define CTIMER_MCR_MR3R_SHIFT                    (10U)
/*! MR3R - Reset on MR3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR3R(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3R_SHIFT)) & CTIMER_MCR_MR3R_MASK)
#define CTIMER_MCR_MR3S_MASK                     (0x800U)
#define CTIMER_MCR_MR3S_SHIFT                    (11U)
/*! MR3S - Stop on MR3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR3S(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3S_SHIFT)) & CTIMER_MCR_MR3S_MASK)
#define CTIMER_MCR_MR0RL_MASK                    (0x1000000U)
#define CTIMER_MCR_MR0RL_SHIFT                   (24U)
/*! MR0RL - Reload MR0
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR0RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR0RL_SHIFT)) & CTIMER_MCR_MR0RL_MASK)
#define CTIMER_MCR_MR1RL_MASK                    (0x2000000U)
#define CTIMER_MCR_MR1RL_SHIFT                   (25U)
/*! MR1RL - Reload MR1
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR1RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR1RL_SHIFT)) & CTIMER_MCR_MR1RL_MASK)
#define CTIMER_MCR_MR2RL_MASK                    (0x4000000U)
#define CTIMER_MCR_MR2RL_SHIFT                   (26U)
/*! MR2RL - Reload MR2
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR2RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR2RL_SHIFT)) & CTIMER_MCR_MR2RL_MASK)
#define CTIMER_MCR_MR3RL_MASK                    (0x8000000U)
#define CTIMER_MCR_MR3RL_SHIFT                   (27U)
/*! MR3RL - Reload MR3
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_MCR_MR3RL(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_MCR_MR3RL_SHIFT)) & CTIMER_MCR_MR3RL_MASK)
/*! @} */

/*! @name MR - Match Register */
/*! @{ */
#define CTIMER_MR_MATCH_MASK                     (0xFFFFFFFFU)
#define CTIMER_MR_MATCH_SHIFT                    (0U)
/*! MATCH - Timer counter match value.
 */
#define CTIMER_MR_MATCH(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_MR_MATCH_SHIFT)) & CTIMER_MR_MATCH_MASK)
/*! @} */

/* The count of CTIMER_MR */
#define CTIMER_MR_COUNT                          (4U)

/*! @name CCR - Capture Control Register */
/*! @{ */
#define CTIMER_CCR_CAP0RE_MASK                   (0x1U)
#define CTIMER_CCR_CAP0RE_SHIFT                  (0U)
/*! CAP0RE - Rising edge of capture channel 0: a sequence of 0 then 1 causes CR0 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP0RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0RE_SHIFT)) & CTIMER_CCR_CAP0RE_MASK)
#define CTIMER_CCR_CAP0FE_MASK                   (0x2U)
#define CTIMER_CCR_CAP0FE_SHIFT                  (1U)
/*! CAP0FE - Falling edge of capture channel 0: a sequence of 1 then 0 causes CR0 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP0FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0FE_SHIFT)) & CTIMER_CCR_CAP0FE_MASK)
#define CTIMER_CCR_CAP0I_MASK                    (0x4U)
#define CTIMER_CCR_CAP0I_SHIFT                   (2U)
/*! CAP0I - Generate interrupt on channel 0 capture event: a CR0 load generates an interrupt.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP0I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP0I_SHIFT)) & CTIMER_CCR_CAP0I_MASK)
#define CTIMER_CCR_CAP1RE_MASK                   (0x8U)
#define CTIMER_CCR_CAP1RE_SHIFT                  (3U)
/*! CAP1RE - Rising edge of capture channel 1: a sequence of 0 then 1 causes CR1 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP1RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1RE_SHIFT)) & CTIMER_CCR_CAP1RE_MASK)
#define CTIMER_CCR_CAP1FE_MASK                   (0x10U)
#define CTIMER_CCR_CAP1FE_SHIFT                  (4U)
/*! CAP1FE - Falling edge of capture channel 1: a sequence of 1 then 0 causes CR1 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP1FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1FE_SHIFT)) & CTIMER_CCR_CAP1FE_MASK)
#define CTIMER_CCR_CAP1I_MASK                    (0x20U)
#define CTIMER_CCR_CAP1I_SHIFT                   (5U)
/*! CAP1I - Generate interrupt on channel 1 capture event: a CR1 load generates an interrupt.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP1I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP1I_SHIFT)) & CTIMER_CCR_CAP1I_MASK)
#define CTIMER_CCR_CAP2RE_MASK                   (0x40U)
#define CTIMER_CCR_CAP2RE_SHIFT                  (6U)
/*! CAP2RE - Rising edge of capture channel 2: a sequence of 0 then 1 causes CR2 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP2RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2RE_SHIFT)) & CTIMER_CCR_CAP2RE_MASK)
#define CTIMER_CCR_CAP2FE_MASK                   (0x80U)
#define CTIMER_CCR_CAP2FE_SHIFT                  (7U)
/*! CAP2FE - Falling edge of capture channel 2: a sequence of 1 then 0 causes CR2 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP2FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2FE_SHIFT)) & CTIMER_CCR_CAP2FE_MASK)
#define CTIMER_CCR_CAP2I_MASK                    (0x100U)
#define CTIMER_CCR_CAP2I_SHIFT                   (8U)
/*! CAP2I - Generate interrupt on channel 2 capture event: a CR2 load generates an interrupt.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP2I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP2I_SHIFT)) & CTIMER_CCR_CAP2I_MASK)
#define CTIMER_CCR_CAP3RE_MASK                   (0x200U)
#define CTIMER_CCR_CAP3RE_SHIFT                  (9U)
/*! CAP3RE - Rising edge of capture channel 3: a sequence of 0 then 1 causes CR3 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP3RE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3RE_SHIFT)) & CTIMER_CCR_CAP3RE_MASK)
#define CTIMER_CCR_CAP3FE_MASK                   (0x400U)
#define CTIMER_CCR_CAP3FE_SHIFT                  (10U)
/*! CAP3FE - Falling edge of capture channel 3: a sequence of 1 then 0 causes CR3 to be loaded with the contents of TC.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP3FE(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3FE_SHIFT)) & CTIMER_CCR_CAP3FE_MASK)
#define CTIMER_CCR_CAP3I_MASK                    (0x800U)
#define CTIMER_CCR_CAP3I_SHIFT                   (11U)
/*! CAP3I - Generate interrupt on channel 3 capture event: a CR3 load generates an interrupt.
 *  0b0..Disabled
 *  0b1..Enabled
 */
#define CTIMER_CCR_CAP3I(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CCR_CAP3I_SHIFT)) & CTIMER_CCR_CAP3I_MASK)
/*! @} */

/*! @name CR - Capture Register */
/*! @{ */
#define CTIMER_CR_CAP_MASK                       (0xFFFFFFFFU)
#define CTIMER_CR_CAP_SHIFT                      (0U)
/*! CAP - Timer counter capture value.
 */
#define CTIMER_CR_CAP(x)                         (((uint32_t)(((uint32_t)(x)) << CTIMER_CR_CAP_SHIFT)) & CTIMER_CR_CAP_MASK)
/*! @} */

/* The count of CTIMER_CR */
#define CTIMER_CR_COUNT                          (4U)

/*! @name EMR - External Match Register */
/*! @{ */
#define CTIMER_EMR_EM0_MASK                      (0x1U)
#define CTIMER_EMR_EM0_SHIFT                     (0U)
/*! EM0 - External Match 0
 */
#define CTIMER_EMR_EM0(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM0_SHIFT)) & CTIMER_EMR_EM0_MASK)
#define CTIMER_EMR_EM1_MASK                      (0x2U)
#define CTIMER_EMR_EM1_SHIFT                     (1U)
/*! EM1 - External Match 1
 */
#define CTIMER_EMR_EM1(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM1_SHIFT)) & CTIMER_EMR_EM1_MASK)
#define CTIMER_EMR_EM2_MASK                      (0x4U)
#define CTIMER_EMR_EM2_SHIFT                     (2U)
/*! EM2 - External Match 2
 */
#define CTIMER_EMR_EM2(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM2_SHIFT)) & CTIMER_EMR_EM2_MASK)
#define CTIMER_EMR_EM3_MASK                      (0x8U)
#define CTIMER_EMR_EM3_SHIFT                     (3U)
/*! EM3 - External Match 3
 */
#define CTIMER_EMR_EM3(x)                        (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EM3_SHIFT)) & CTIMER_EMR_EM3_MASK)
#define CTIMER_EMR_EMC0_MASK                     (0x30U)
#define CTIMER_EMR_EMC0_SHIFT                    (4U)
/*! EMC0 - External Match Control 0
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT0 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT0 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC0(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC0_SHIFT)) & CTIMER_EMR_EMC0_MASK)
#define CTIMER_EMR_EMC1_MASK                     (0xC0U)
#define CTIMER_EMR_EMC1_SHIFT                    (6U)
/*! EMC1 - External Match Control 1
 *  0b00..Do Nothing
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT1 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT1 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC1(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC1_SHIFT)) & CTIMER_EMR_EMC1_MASK)
#define CTIMER_EMR_EMC2_MASK                     (0x300U)
#define CTIMER_EMR_EMC2_SHIFT                    (8U)
/*! EMC2 - External Match Control 2
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT2 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT2 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC2(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC2_SHIFT)) & CTIMER_EMR_EMC2_MASK)
#define CTIMER_EMR_EMC3_MASK                     (0xC00U)
#define CTIMER_EMR_EMC3_SHIFT                    (10U)
/*! EMC3 - External Match Control 3
 *  0b00..Do Nothing.
 *  0b01..Clear. Clear the corresponding External Match bit/output to 0 (MAT3 pin is LOW if pinned out).
 *  0b10..Set. Set the corresponding External Match bit/output to 1 (MAT3 pin is HIGH if pinned out).
 *  0b11..Toggle. Toggle the corresponding External Match bit/output.
 */
#define CTIMER_EMR_EMC3(x)                       (((uint32_t)(((uint32_t)(x)) << CTIMER_EMR_EMC3_SHIFT)) & CTIMER_EMR_EMC3_MASK)
/*! @} */

/*! @name CTCR - Count Control Register */
/*! @{ */
#define CTIMER_CTCR_CTMODE_MASK                  (0x3U)
#define CTIMER_CTCR_CTMODE_SHIFT                 (0U)
/*! CTMODE - The Count Control Register (CTCR) is used to select between Timer and Counter mode, and
 *    in Counter mode to select the pin and edge(s) for counting. When Counter Mode is chosen as a
 *    mode of operation, the CAP input (selected by the CTCR bits 3:2) is sampled on every rising
 *    edge of the CTIMER function clock. After comparing two consecutive samples of this CAP input,
 *    one of the following four events is recognized: rising edge, falling edge, either of edges or no
 *    changes in the level of the selected CAP input. Only if the identified event occurs and the
 *    event corresponds to the one selected by bits 1:0 in the CTCR register, will the Timer Counter
 *    register be incremented. Effective processing of the externally supplied clock to the counter
 *    has some limitations. Since two successive rising edges of the CTIMER function clock are used
 *    to identify only one edge on the CAP selected input, the frequency of the CAP input cannot
 *    exceed one half of the CTIMER function clock. Consequently, duration of the HIGH/LOWLOW levels on
 *    the same CAP input in this case cannot be shorter than a CTIMER function clock. Bits 7:4 of
 *    this register are also used to enable and configure the capture-clears-timer feature. This
 *    feature allows for a designated edge on a particular CAP input to reset the timer to all zeros.
 *    Using this mechanism to clear the timer on the leading edge of an input pulse and performing a
 *    capture on the trailing edge, permits direct pulse-width measurement using a single capture
 *    input without the need to perform a subtraction operation in software.
 *  0b00..Timer Mode
 *  0b01..Counter Mode rising edge
 *  0b10..Counter Mode falling edge
 *  0b11..Counter Mode dual edge
 */
#define CTIMER_CTCR_CTMODE(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CTMODE_SHIFT)) & CTIMER_CTCR_CTMODE_MASK)
#define CTIMER_CTCR_CINSEL_MASK                  (0xCU)
#define CTIMER_CTCR_CINSEL_SHIFT                 (2U)
/*! CINSEL - Count Input Select
 *  0b00..Channel 0. CAPn.0 for CTIMERn
 *  0b01..Channel 1. CAPn.1 for CTIMERn
 *  0b10..Channel 2. CAPn.2 for CTIMERn
 *  0b11..Channel 3. CAPn.3 for CTIMERn
 */
#define CTIMER_CTCR_CINSEL(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_CINSEL_SHIFT)) & CTIMER_CTCR_CINSEL_MASK)
#define CTIMER_CTCR_ENCC_MASK                    (0x10U)
#define CTIMER_CTCR_ENCC_SHIFT                   (4U)
#define CTIMER_CTCR_ENCC(x)                      (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_ENCC_SHIFT)) & CTIMER_CTCR_ENCC_MASK)
#define CTIMER_CTCR_SELCC_MASK                   (0xE0U)
#define CTIMER_CTCR_SELCC_SHIFT                  (5U)
/*! SELCC - Edge select
 *  0b000..Channel 0 Rising Edge. Rising edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
 *  0b001..Channel 0 Falling Edge. Falling edge of the signal on capture channel 0 clears the timer (if bit 4 is set).
 *  0b010..Channel 1 Rising Edge. Rising edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
 *  0b011..Channel 1 Falling Edge. Falling edge of the signal on capture channel 1 clears the timer (if bit 4 is set).
 *  0b100..Channel 2 Rising Edge. Rising edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
 *  0b101..Channel 2 Falling Edge. Falling edge of the signal on capture channel 2 clears the timer (if bit 4 is set).
 */
#define CTIMER_CTCR_SELCC(x)                     (((uint32_t)(((uint32_t)(x)) << CTIMER_CTCR_SELCC_SHIFT)) & CTIMER_CTCR_SELCC_MASK)
/*! @} */

/*! @name PWMC - PWM Control Register */
/*! @{ */
#define CTIMER_PWMC_PWMEN0_MASK                  (0x1U)
#define CTIMER_PWMC_PWMEN0_SHIFT                 (0U)
/*! PWMEN0 - PWM mode enable for channel0.
 *  0b0..Match. CTIMERn_MAT0 is controlled by EM0.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT0.
 */
#define CTIMER_PWMC_PWMEN0(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN0_SHIFT)) & CTIMER_PWMC_PWMEN0_MASK)
#define CTIMER_PWMC_PWMEN1_MASK                  (0x2U)
#define CTIMER_PWMC_PWMEN1_SHIFT                 (1U)
/*! PWMEN1 - PWM mode enable for channel1.
 *  0b0..Match. CTIMERn_MAT01 is controlled by EM1.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT1.
 */
#define CTIMER_PWMC_PWMEN1(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN1_SHIFT)) & CTIMER_PWMC_PWMEN1_MASK)
#define CTIMER_PWMC_PWMEN2_MASK                  (0x4U)
#define CTIMER_PWMC_PWMEN2_SHIFT                 (2U)
/*! PWMEN2 - PWM mode enable for channel2.
 *  0b0..Match. CTIMERn_MAT2 is controlled by EM2.
 *  0b1..PWM. PWM mode is enabled for CTIMERn_MAT2.
 */
#define CTIMER_PWMC_PWMEN2(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN2_SHIFT)) & CTIMER_PWMC_PWMEN2_MASK)
#define CTIMER_PWMC_PWMEN3_MASK                  (0x8U)
#define CTIMER_PWMC_PWMEN3_SHIFT                 (3U)
/*! PWMEN3 - PWM mode enable for channel3. Note: It is recommended to use match channel 3 to set the PWM cycle.
 *  0b0..Match. CTIMERn_MAT3 is controlled by EM3.
 *  0b1..PWM. PWM mode is enabled for CT132Bn_MAT3.
 */
#define CTIMER_PWMC_PWMEN3(x)                    (((uint32_t)(((uint32_t)(x)) << CTIMER_PWMC_PWMEN3_SHIFT)) & CTIMER_PWMC_PWMEN3_MASK)
/*! @} */

/*! @name MSR - Match Shadow Register */
/*! @{ */
#define CTIMER_MSR_MATCH_SHADOW_MASK             (0xFFFFFFFFU)
#define CTIMER_MSR_MATCH_SHADOW_SHIFT            (0U)
/*! MATCH_SHADOW - Timer counter match shadow value.
 */
#define CTIMER_MSR_MATCH_SHADOW(x)               (((uint32_t)(((uint32_t)(x)) << CTIMER_MSR_MATCH_SHADOW_SHIFT)) & CTIMER_MSR_MATCH_SHADOW_MASK)
/*! @} */

/* The count of CTIMER_MSR */
#define CTIMER_MSR_COUNT                         (4U)


/*!
 * @}
 */ /* end of group CTIMER_Register_Masks */


/* CTIMER - Peripheral instance base addresses */
/** Peripheral CTIMER0 base address */
#define CTIMER0_BASE                             (0x40028000u)
/** Peripheral CTIMER0 base pointer */
#define CTIMER0                                  ((CTIMER_Type *)CTIMER0_BASE)
/** Peripheral CTIMER1 base address */
#define CTIMER1_BASE                             (0x40029000u)
/** Peripheral CTIMER1 base pointer */
#define CTIMER1                                  ((CTIMER_Type *)CTIMER1_BASE)
/** Peripheral CTIMER2 base address */
#define CTIMER2_BASE                             (0x4002A000u)
/** Peripheral CTIMER2 base pointer */
#define CTIMER2                                  ((CTIMER_Type *)CTIMER2_BASE)
/** Peripheral CTIMER3 base address */
#define CTIMER3_BASE                             (0x4002B000u)
/** Peripheral CTIMER3 base pointer */
#define CTIMER3                                  ((CTIMER_Type *)CTIMER3_BASE)
/** Peripheral CTIMER4 base address */
#define CTIMER4_BASE                             (0x4002C000u)
/** Peripheral CTIMER4 base pointer */
#define CTIMER4                                  ((CTIMER_Type *)CTIMER4_BASE)
/** Array initializer of CTIMER peripheral base addresses */
#define CTIMER_BASE_ADDRS                        { CTIMER0_BASE, CTIMER1_BASE, CTIMER2_BASE, CTIMER3_BASE, CTIMER4_BASE }
/** Array initializer of CTIMER peripheral base pointers */
#define CTIMER_BASE_PTRS                         { CTIMER0, CTIMER1, CTIMER2, CTIMER3, CTIMER4 }
/** Interrupt vectors for the CTIMER peripheral type */
#define CTIMER_IRQS                              { CTIMER0_IRQn, CTIMER1_IRQn, CTIMER2_IRQn, CTIMER3_IRQn, CTIMER4_IRQn }

/*!
 * @}
 */ /* end of group CTIMER_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DEBUGGER_MAILBOX Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DEBUGGER_MAILBOX_Peripheral_Access_Layer DEBUGGER_MAILBOX Peripheral Access Layer
 * @{
 */

/** DEBUGGER_MAILBOX - Register Layout Typedef */
typedef struct {
  __IO uint32_t CSW;                               /**< Command and status word, offset: 0x0 */
  __IO uint32_t REQUEST;                           /**< Request Value, offset: 0x4 */
  __IO uint32_t RETURN;                            /**< Return Value, offset: 0x8 */
       uint8_t RESERVED_0[240];
  __I  uint32_t ID;                                /**< Identification, offset: 0xFC */
} DEBUGGER_MAILBOX_Type;

/* ----------------------------------------------------------------------------
   -- DEBUGGER_MAILBOX Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DEBUGGER_MAILBOX_Register_Masks DEBUGGER_MAILBOX Register Masks
 * @{
 */

/*! @name CSW - Command and status word */
/*! @{ */
#define DEBUGGER_MAILBOX_CSW_RESYNCH_REQ_MASK    (0x1U)
#define DEBUGGER_MAILBOX_CSW_RESYNCH_REQ_SHIFT   (0U)
/*! RESYNCH_REQ - Re-synchronization Request
 *  0b0..No Request
 *  0b1..Request for re-synchronization
 */
#define DEBUGGER_MAILBOX_CSW_RESYNCH_REQ(x)      (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_RESYNCH_REQ_SHIFT)) & DEBUGGER_MAILBOX_CSW_RESYNCH_REQ_MASK)
#define DEBUGGER_MAILBOX_CSW_REQ_PENDING_MASK    (0x2U)
#define DEBUGGER_MAILBOX_CSW_REQ_PENDING_SHIFT   (1U)
/*! REQ_PENDING - Request Pending
 *  0b0..No Request Pending
 *  0b1..Request for Re-synchronization Pending
 */
#define DEBUGGER_MAILBOX_CSW_REQ_PENDING(x)      (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_REQ_PENDING_SHIFT)) & DEBUGGER_MAILBOX_CSW_REQ_PENDING_MASK)
#define DEBUGGER_MAILBOX_CSW_DBG_OR_ERR_MASK     (0x4U)
#define DEBUGGER_MAILBOX_CSW_DBG_OR_ERR_SHIFT    (2U)
/*! DBG_OR_ERR - Debug Overrun Error
 *  0b0..No Debug Overrun error
 *  0b1..Debug Overrun Error. A debug overrun occurred.
 */
#define DEBUGGER_MAILBOX_CSW_DBG_OR_ERR(x)       (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_DBG_OR_ERR_SHIFT)) & DEBUGGER_MAILBOX_CSW_DBG_OR_ERR_MASK)
#define DEBUGGER_MAILBOX_CSW_AHB_OR_ERR_MASK     (0x8U)
#define DEBUGGER_MAILBOX_CSW_AHB_OR_ERR_SHIFT    (3U)
/*! AHB_OR_ERR - When 1, an AHB overrun has occurred: a RETURN value has been overwritten by the
 *    device before the RETURN value was read by the debugger.
 *  0b0..No AHB Overrun Error
 *  0b1..AHB Overrun Error. An AHB overrun occurred.
 */
#define DEBUGGER_MAILBOX_CSW_AHB_OR_ERR(x)       (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_AHB_OR_ERR_SHIFT)) & DEBUGGER_MAILBOX_CSW_AHB_OR_ERR_MASK)
#define DEBUGGER_MAILBOX_CSW_SOFT_RESET_MASK     (0x10U)
#define DEBUGGER_MAILBOX_CSW_SOFT_RESET_SHIFT    (4U)
/*! SOFT_RESET - Soft Reset
 */
#define DEBUGGER_MAILBOX_CSW_SOFT_RESET(x)       (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_SOFT_RESET_SHIFT)) & DEBUGGER_MAILBOX_CSW_SOFT_RESET_MASK)
#define DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ_MASK (0x20U)
#define DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ_SHIFT (5U)
/*! CHIP_RESET_REQ - Chip Reset Request
 */
#define DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ(x)   (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ_SHIFT)) & DEBUGGER_MAILBOX_CSW_CHIP_RESET_REQ_MASK)
/*! @} */

/*! @name REQUEST - Request Value */
/*! @{ */
#define DEBUGGER_MAILBOX_REQUEST_REQUEST_MASK    (0xFFFFFFFFU)
#define DEBUGGER_MAILBOX_REQUEST_REQUEST_SHIFT   (0U)
/*! REQUEST - Request Value
 */
#define DEBUGGER_MAILBOX_REQUEST_REQUEST(x)      (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_REQUEST_REQUEST_SHIFT)) & DEBUGGER_MAILBOX_REQUEST_REQUEST_MASK)
/*! @} */

/*! @name RETURN - Return Value */
/*! @{ */
#define DEBUGGER_MAILBOX_RETURN_RETURN_MASK      (0xFFFFFFFFU)
#define DEBUGGER_MAILBOX_RETURN_RETURN_SHIFT     (0U)
/*! RETURN - Return Value
 */
#define DEBUGGER_MAILBOX_RETURN_RETURN(x)        (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_RETURN_RETURN_SHIFT)) & DEBUGGER_MAILBOX_RETURN_RETURN_MASK)
/*! @} */

/*! @name ID - Identification */
/*! @{ */
#define DEBUGGER_MAILBOX_ID_ID_MASK              (0xFFFFFFFFU)
#define DEBUGGER_MAILBOX_ID_ID_SHIFT             (0U)
/*! ID - Identification Value
 */
#define DEBUGGER_MAILBOX_ID_ID(x)                (((uint32_t)(((uint32_t)(x)) << DEBUGGER_MAILBOX_ID_ID_SHIFT)) & DEBUGGER_MAILBOX_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DEBUGGER_MAILBOX_Register_Masks */


/* DEBUGGER_MAILBOX - Peripheral instance base addresses */
/** Peripheral DEBUGGER_MAILBOX base address */
#define DEBUGGER_MAILBOX_BASE                    (0x4010F000u)
/** Peripheral DEBUGGER_MAILBOX base pointer */
#define DEBUGGER_MAILBOX                         ((DEBUGGER_MAILBOX_Type *)DEBUGGER_MAILBOX_BASE)
/** Array initializer of DEBUGGER_MAILBOX peripheral base addresses */
#define DEBUGGER_MAILBOX_BASE_ADDRS              { DEBUGGER_MAILBOX_BASE }
/** Array initializer of DEBUGGER_MAILBOX peripheral base pointers */
#define DEBUGGER_MAILBOX_BASE_PTRS               { DEBUGGER_MAILBOX }

/*!
 * @}
 */ /* end of group DEBUGGER_MAILBOX_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMA Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Peripheral_Access_Layer DMA Peripheral Access Layer
 * @{
 */

/** DMA - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< DMA control, offset: 0x0 */
  __I  uint32_t INTSTAT;                           /**< Interrupt status, offset: 0x4 */
  __IO uint32_t SRAMBASE;                          /**< SRAM address of the channel configuration table, offset: 0x8 */
       uint8_t RESERVED_0[20];
  struct {                                         /* offset: 0x20, array step: 0x60 */
    __IO uint32_t ENABLESET;                         /**< Channel Enable read and set for all DMA channels, array offset: 0x20, array step: 0x60 */
    __IO uint32_t ENABLESET1;                        /**< Channel Enable read and set for all DMA channels, array offset: 0x24, array step: 0x60 */
    __IO uint32_t ENABLECLR;                         /**< Channel Enable Clear for all DMA channels, array offset: 0x28, array step: 0x60 */
    __IO uint32_t ENABLECLR1;                        /**< Channel Enable Clear for all DMA channels, array offset: 0x2C, array step: 0x60 */
    __I  uint32_t ACTIVE;                            /**< Channel Active status for all DMA channels, array offset: 0x30, array step: 0x60 */
    __I  uint32_t ACTIVE1;                           /**< Channel Active status for all DMA channels, array offset: 0x34, array step: 0x60 */
    __I  uint32_t BUSY;                              /**< Channel Busy status for all DMA channels, array offset: 0x38, array step: 0x60 */
    __I  uint32_t BUSY1;                             /**< Channel Busy status for all DMA channels, array offset: 0x3C, array step: 0x60 */
    __IO uint32_t ERRINT;                            /**< Error Interrupt status for all DMA channels, array offset: 0x40, array step: 0x60 */
    __IO uint32_t ERRINT1;                           /**< Error Interrupt status for all DMA channels, array offset: 0x44, array step: 0x60 */
    __IO uint32_t INTENSET;                          /**< Interrupt Enable read and Set for all DMA channels, array offset: 0x48, array step: 0x60 */
    __IO uint32_t INTENSET1;                         /**< Interrupt Enable read and Set for all DMA channels, array offset: 0x4C, array step: 0x60 */
    __O  uint32_t INTENCLR;                          /**< Interrupt Enable Clear for all DMA channels, array offset: 0x50, array step: 0x60 */
    __O  uint32_t INTENCLR1;                         /**< Interrupt Enable Clear for all DMA channels, array offset: 0x54, array step: 0x60 */
    __IO uint32_t INTA;                              /**< Interrupt A status for all DMA channels, array offset: 0x58, array step: 0x60 */
    __IO uint32_t INTA1;                             /**< Interrupt A status for all DMA channels, array offset: 0x5C, array step: 0x60 */
    __IO uint32_t INTB;                              /**< Interrupt B status for all DMA channels, array offset: 0x60, array step: 0x60 */
    __IO uint32_t INTB1;                             /**< Interrupt B status for all DMA channels, array offset: 0x64, array step: 0x60 */
    __O  uint32_t SETVALID;                          /**< Set ValidPending control bits for all DMA channels, array offset: 0x68, array step: 0x60 */
    __O  uint32_t SETVALID1;                         /**< Set ValidPending control bits for all DMA channels, array offset: 0x6C, array step: 0x60 */
    __O  uint32_t SETTRIG;                           /**< Set Trigger control bits for all DMA channels, array offset: 0x70, array step: 0x60 */
    __O  uint32_t SETTRIG1;                          /**< Set Trigger control bits for all DMA channels, array offset: 0x74, array step: 0x60 */
    __O  uint32_t ABORT;                             /**< Channel Abort control for all DMA channels, array offset: 0x78, array step: 0x60 */
    __O  uint32_t ABORT1;                            /**< Channel Abort control for all DMA channels, array offset: 0x7C, array step: 0x60 */
  } COMMON[1];
       uint8_t RESERVED_1[896];
  struct {                                         /* offset: 0x400, array step: 0x10 */
    __IO uint32_t CFG;                               /**< Configuration register for DMA channel, array offset: 0x400, array step: 0x10 */
    __I  uint32_t CTLSTAT;                           /**< Control and status register for DMA channel, array offset: 0x404, array step: 0x10 */
    __IO uint32_t XFERCFG;                           /**< Transfer configuration register for DMA channel, array offset: 0x408, array step: 0x10 */
         uint8_t RESERVED_0[4];
  } CHANNEL[37];
} DMA_Type;

/* ----------------------------------------------------------------------------
   -- DMA Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMA_Register_Masks DMA Register Masks
 * @{
 */

/*! @name CTRL - DMA control */
/*! @{ */
#define DMA_CTRL_ENABLE_MASK                     (0x1U)
#define DMA_CTRL_ENABLE_SHIFT                    (0U)
/*! ENABLE - DMA controller master enable.
 *  0b0..DMA controller is disabled.
 *  0b1..Enabled.
 */
#define DMA_CTRL_ENABLE(x)                       (((uint32_t)(((uint32_t)(x)) << DMA_CTRL_ENABLE_SHIFT)) & DMA_CTRL_ENABLE_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt status */
/*! @{ */
#define DMA_INTSTAT_ACTIVEINT_MASK               (0x2U)
#define DMA_INTSTAT_ACTIVEINT_SHIFT              (1U)
/*! ACTIVEINT - Summarizes whether any enabled interrupts (other than error interrupts) are pending.
 *  0b0..No enabled interrupts are pending.
 *  0b1..At least one enabled interrupt is pending.
 */
#define DMA_INTSTAT_ACTIVEINT(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_INTSTAT_ACTIVEINT_SHIFT)) & DMA_INTSTAT_ACTIVEINT_MASK)
#define DMA_INTSTAT_ACTIVEERRINT_MASK            (0x4U)
#define DMA_INTSTAT_ACTIVEERRINT_SHIFT           (2U)
/*! ACTIVEERRINT - Summarizes whether any error interrupts are pending.
 *  0b0..No error interrupts are pending.
 *  0b1..At least one error interrupt is pending.
 */
#define DMA_INTSTAT_ACTIVEERRINT(x)              (((uint32_t)(((uint32_t)(x)) << DMA_INTSTAT_ACTIVEERRINT_SHIFT)) & DMA_INTSTAT_ACTIVEERRINT_MASK)
/*! @} */

/*! @name SRAMBASE - SRAM address of the channel configuration table */
/*! @{ */
#define DMA_SRAMBASE_OFFSET_MASK                 (0xFFFFFE00U)
#define DMA_SRAMBASE_OFFSET_SHIFT                (9U)
/*! OFFSET - Offset
 */
#define DMA_SRAMBASE_OFFSET(x)                   (((uint32_t)(((uint32_t)(x)) << DMA_SRAMBASE_OFFSET_SHIFT)) & DMA_SRAMBASE_OFFSET_MASK)
/*! @} */

/*! @name COMMON_ENABLESET - Channel Enable read and set for all DMA channels */
/*! @{ */
#define DMA_COMMON_ENABLESET_ENABLE0_MASK        (0x1U)
#define DMA_COMMON_ENABLESET_ENABLE0_SHIFT       (0U)
/*! ENABLE0 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE0(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE0_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE0_MASK)
#define DMA_COMMON_ENABLESET_ENABLE1_MASK        (0x2U)
#define DMA_COMMON_ENABLESET_ENABLE1_SHIFT       (1U)
/*! ENABLE1 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE1(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE1_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE1_MASK)
#define DMA_COMMON_ENABLESET_ENABLE2_MASK        (0x4U)
#define DMA_COMMON_ENABLESET_ENABLE2_SHIFT       (2U)
/*! ENABLE2 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE2(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE2_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE2_MASK)
#define DMA_COMMON_ENABLESET_ENABLE3_MASK        (0x8U)
#define DMA_COMMON_ENABLESET_ENABLE3_SHIFT       (3U)
/*! ENABLE3 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE3(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE3_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE3_MASK)
#define DMA_COMMON_ENABLESET_ENABLE4_MASK        (0x10U)
#define DMA_COMMON_ENABLESET_ENABLE4_SHIFT       (4U)
/*! ENABLE4 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE4(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE4_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE4_MASK)
#define DMA_COMMON_ENABLESET_ENABLE5_MASK        (0x20U)
#define DMA_COMMON_ENABLESET_ENABLE5_SHIFT       (5U)
/*! ENABLE5 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE5(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE5_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE5_MASK)
#define DMA_COMMON_ENABLESET_ENABLE6_MASK        (0x40U)
#define DMA_COMMON_ENABLESET_ENABLE6_SHIFT       (6U)
/*! ENABLE6 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE6(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE6_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE6_MASK)
#define DMA_COMMON_ENABLESET_ENABLE7_MASK        (0x80U)
#define DMA_COMMON_ENABLESET_ENABLE7_SHIFT       (7U)
/*! ENABLE7 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE7(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE7_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE7_MASK)
#define DMA_COMMON_ENABLESET_ENABLE8_MASK        (0x100U)
#define DMA_COMMON_ENABLESET_ENABLE8_SHIFT       (8U)
/*! ENABLE8 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE8(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE8_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE8_MASK)
#define DMA_COMMON_ENABLESET_ENABLE9_MASK        (0x200U)
#define DMA_COMMON_ENABLESET_ENABLE9_SHIFT       (9U)
/*! ENABLE9 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE9(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE9_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE9_MASK)
#define DMA_COMMON_ENABLESET_ENABLE10_MASK       (0x400U)
#define DMA_COMMON_ENABLESET_ENABLE10_SHIFT      (10U)
/*! ENABLE10 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE10(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE10_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE10_MASK)
#define DMA_COMMON_ENABLESET_ENABLE11_MASK       (0x800U)
#define DMA_COMMON_ENABLESET_ENABLE11_SHIFT      (11U)
/*! ENABLE11 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE11(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE11_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE11_MASK)
#define DMA_COMMON_ENABLESET_ENABLE12_MASK       (0x1000U)
#define DMA_COMMON_ENABLESET_ENABLE12_SHIFT      (12U)
/*! ENABLE12 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE12(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE12_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE12_MASK)
#define DMA_COMMON_ENABLESET_ENABLE13_MASK       (0x2000U)
#define DMA_COMMON_ENABLESET_ENABLE13_SHIFT      (13U)
/*! ENABLE13 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE13(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE13_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE13_MASK)
#define DMA_COMMON_ENABLESET_ENABLE14_MASK       (0x4000U)
#define DMA_COMMON_ENABLESET_ENABLE14_SHIFT      (14U)
/*! ENABLE14 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE14(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE14_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE14_MASK)
#define DMA_COMMON_ENABLESET_ENABLE15_MASK       (0x8000U)
#define DMA_COMMON_ENABLESET_ENABLE15_SHIFT      (15U)
/*! ENABLE15 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE15(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE15_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE15_MASK)
#define DMA_COMMON_ENABLESET_ENABLE16_MASK       (0x10000U)
#define DMA_COMMON_ENABLESET_ENABLE16_SHIFT      (16U)
/*! ENABLE16 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE16(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE16_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE16_MASK)
#define DMA_COMMON_ENABLESET_ENABLE17_MASK       (0x20000U)
#define DMA_COMMON_ENABLESET_ENABLE17_SHIFT      (17U)
/*! ENABLE17 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE17(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE17_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE17_MASK)
#define DMA_COMMON_ENABLESET_ENABLE18_MASK       (0x40000U)
#define DMA_COMMON_ENABLESET_ENABLE18_SHIFT      (18U)
/*! ENABLE18 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE18(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE18_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE18_MASK)
#define DMA_COMMON_ENABLESET_ENABLE19_MASK       (0x80000U)
#define DMA_COMMON_ENABLESET_ENABLE19_SHIFT      (19U)
/*! ENABLE19 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE19(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE19_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE19_MASK)
#define DMA_COMMON_ENABLESET_ENABLE20_MASK       (0x100000U)
#define DMA_COMMON_ENABLESET_ENABLE20_SHIFT      (20U)
/*! ENABLE20 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE20(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE20_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE20_MASK)
#define DMA_COMMON_ENABLESET_ENABLE21_MASK       (0x200000U)
#define DMA_COMMON_ENABLESET_ENABLE21_SHIFT      (21U)
/*! ENABLE21 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE21(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE21_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE21_MASK)
#define DMA_COMMON_ENABLESET_ENABLE22_MASK       (0x400000U)
#define DMA_COMMON_ENABLESET_ENABLE22_SHIFT      (22U)
/*! ENABLE22 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE22(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE22_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE22_MASK)
#define DMA_COMMON_ENABLESET_ENABLE23_MASK       (0x800000U)
#define DMA_COMMON_ENABLESET_ENABLE23_SHIFT      (23U)
/*! ENABLE23 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE23(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE23_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE23_MASK)
#define DMA_COMMON_ENABLESET_ENABLE24_MASK       (0x1000000U)
#define DMA_COMMON_ENABLESET_ENABLE24_SHIFT      (24U)
/*! ENABLE24 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE24(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE24_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE24_MASK)
#define DMA_COMMON_ENABLESET_ENABLE25_MASK       (0x2000000U)
#define DMA_COMMON_ENABLESET_ENABLE25_SHIFT      (25U)
/*! ENABLE25 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE25(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE25_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE25_MASK)
#define DMA_COMMON_ENABLESET_ENABLE26_MASK       (0x4000000U)
#define DMA_COMMON_ENABLESET_ENABLE26_SHIFT      (26U)
/*! ENABLE26 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE26(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE26_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE26_MASK)
#define DMA_COMMON_ENABLESET_ENABLE27_MASK       (0x8000000U)
#define DMA_COMMON_ENABLESET_ENABLE27_SHIFT      (27U)
/*! ENABLE27 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE27(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE27_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE27_MASK)
#define DMA_COMMON_ENABLESET_ENABLE28_MASK       (0x10000000U)
#define DMA_COMMON_ENABLESET_ENABLE28_SHIFT      (28U)
/*! ENABLE28 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE28(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE28_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE28_MASK)
#define DMA_COMMON_ENABLESET_ENABLE29_MASK       (0x20000000U)
#define DMA_COMMON_ENABLESET_ENABLE29_SHIFT      (29U)
/*! ENABLE29 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE29(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE29_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE29_MASK)
#define DMA_COMMON_ENABLESET_ENABLE30_MASK       (0x40000000U)
#define DMA_COMMON_ENABLESET_ENABLE30_SHIFT      (30U)
/*! ENABLE30 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE30(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE30_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE30_MASK)
#define DMA_COMMON_ENABLESET_ENABLE31_MASK       (0x80000000U)
#define DMA_COMMON_ENABLESET_ENABLE31_SHIFT      (31U)
/*! ENABLE31 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET_ENABLE31(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET_ENABLE31_SHIFT)) & DMA_COMMON_ENABLESET_ENABLE31_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLESET */
#define DMA_COMMON_ENABLESET_COUNT               (1U)

/*! @name COMMON_ENABLESET1 - Channel Enable read and set for all DMA channels */
/*! @{ */
#define DMA_COMMON_ENABLESET1_ENABLE32_MASK      (0x1U)
#define DMA_COMMON_ENABLESET1_ENABLE32_SHIFT     (0U)
/*! ENABLE32 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE32(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE32_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE32_MASK)
#define DMA_COMMON_ENABLESET1_ENABLE33_MASK      (0x2U)
#define DMA_COMMON_ENABLESET1_ENABLE33_SHIFT     (1U)
/*! ENABLE33 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE33(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE33_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE33_MASK)
#define DMA_COMMON_ENABLESET1_ENABLE34_MASK      (0x4U)
#define DMA_COMMON_ENABLESET1_ENABLE34_SHIFT     (2U)
/*! ENABLE34 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE34(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE34_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE34_MASK)
#define DMA_COMMON_ENABLESET1_ENABLE35_MASK      (0x8U)
#define DMA_COMMON_ENABLESET1_ENABLE35_SHIFT     (3U)
/*! ENABLE35 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE35(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE35_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE35_MASK)
#define DMA_COMMON_ENABLESET1_ENABLE36_MASK      (0x10U)
#define DMA_COMMON_ENABLESET1_ENABLE36_SHIFT     (4U)
/*! ENABLE36 - Enable for DMA channel
 *  0b0..DMA channel is disabled.
 *  0b1..DMA channel is enabled.
 */
#define DMA_COMMON_ENABLESET1_ENABLE36(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLESET1_ENABLE36_SHIFT)) & DMA_COMMON_ENABLESET1_ENABLE36_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLESET1 */
#define DMA_COMMON_ENABLESET1_COUNT              (1U)

/*! @name COMMON_ENABLECLR - Channel Enable Clear for all DMA channels */
/*! @{ */
#define DMA_COMMON_ENABLECLR_CLR0_MASK           (0x1U)
#define DMA_COMMON_ENABLECLR_CLR0_SHIFT          (0U)
/*! CLR0 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR0(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR0_SHIFT)) & DMA_COMMON_ENABLECLR_CLR0_MASK)
#define DMA_COMMON_ENABLECLR_CLR1_MASK           (0x2U)
#define DMA_COMMON_ENABLECLR_CLR1_SHIFT          (1U)
/*! CLR1 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR1(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR1_SHIFT)) & DMA_COMMON_ENABLECLR_CLR1_MASK)
#define DMA_COMMON_ENABLECLR_CLR2_MASK           (0x4U)
#define DMA_COMMON_ENABLECLR_CLR2_SHIFT          (2U)
/*! CLR2 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR2(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR2_SHIFT)) & DMA_COMMON_ENABLECLR_CLR2_MASK)
#define DMA_COMMON_ENABLECLR_CLR3_MASK           (0x8U)
#define DMA_COMMON_ENABLECLR_CLR3_SHIFT          (3U)
/*! CLR3 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR3(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR3_SHIFT)) & DMA_COMMON_ENABLECLR_CLR3_MASK)
#define DMA_COMMON_ENABLECLR_CLR4_MASK           (0x10U)
#define DMA_COMMON_ENABLECLR_CLR4_SHIFT          (4U)
/*! CLR4 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR4(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR4_SHIFT)) & DMA_COMMON_ENABLECLR_CLR4_MASK)
#define DMA_COMMON_ENABLECLR_CLR5_MASK           (0x20U)
#define DMA_COMMON_ENABLECLR_CLR5_SHIFT          (5U)
/*! CLR5 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR5(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR5_SHIFT)) & DMA_COMMON_ENABLECLR_CLR5_MASK)
#define DMA_COMMON_ENABLECLR_CLR6_MASK           (0x40U)
#define DMA_COMMON_ENABLECLR_CLR6_SHIFT          (6U)
/*! CLR6 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR6(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR6_SHIFT)) & DMA_COMMON_ENABLECLR_CLR6_MASK)
#define DMA_COMMON_ENABLECLR_CLR7_MASK           (0x80U)
#define DMA_COMMON_ENABLECLR_CLR7_SHIFT          (7U)
/*! CLR7 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR7(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR7_SHIFT)) & DMA_COMMON_ENABLECLR_CLR7_MASK)
#define DMA_COMMON_ENABLECLR_CLR8_MASK           (0x100U)
#define DMA_COMMON_ENABLECLR_CLR8_SHIFT          (8U)
/*! CLR8 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR8(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR8_SHIFT)) & DMA_COMMON_ENABLECLR_CLR8_MASK)
#define DMA_COMMON_ENABLECLR_CLR9_MASK           (0x200U)
#define DMA_COMMON_ENABLECLR_CLR9_SHIFT          (9U)
/*! CLR9 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR9(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR9_SHIFT)) & DMA_COMMON_ENABLECLR_CLR9_MASK)
#define DMA_COMMON_ENABLECLR_CLR10_MASK          (0x400U)
#define DMA_COMMON_ENABLECLR_CLR10_SHIFT         (10U)
/*! CLR10 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR10(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR10_SHIFT)) & DMA_COMMON_ENABLECLR_CLR10_MASK)
#define DMA_COMMON_ENABLECLR_CLR11_MASK          (0x800U)
#define DMA_COMMON_ENABLECLR_CLR11_SHIFT         (11U)
/*! CLR11 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR11(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR11_SHIFT)) & DMA_COMMON_ENABLECLR_CLR11_MASK)
#define DMA_COMMON_ENABLECLR_CLR12_MASK          (0x1000U)
#define DMA_COMMON_ENABLECLR_CLR12_SHIFT         (12U)
/*! CLR12 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR12(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR12_SHIFT)) & DMA_COMMON_ENABLECLR_CLR12_MASK)
#define DMA_COMMON_ENABLECLR_CLR13_MASK          (0x2000U)
#define DMA_COMMON_ENABLECLR_CLR13_SHIFT         (13U)
/*! CLR13 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR13(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR13_SHIFT)) & DMA_COMMON_ENABLECLR_CLR13_MASK)
#define DMA_COMMON_ENABLECLR_CLR14_MASK          (0x4000U)
#define DMA_COMMON_ENABLECLR_CLR14_SHIFT         (14U)
/*! CLR14 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR14(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR14_SHIFT)) & DMA_COMMON_ENABLECLR_CLR14_MASK)
#define DMA_COMMON_ENABLECLR_CLR15_MASK          (0x8000U)
#define DMA_COMMON_ENABLECLR_CLR15_SHIFT         (15U)
/*! CLR15 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR15(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR15_SHIFT)) & DMA_COMMON_ENABLECLR_CLR15_MASK)
#define DMA_COMMON_ENABLECLR_CLR16_MASK          (0x10000U)
#define DMA_COMMON_ENABLECLR_CLR16_SHIFT         (16U)
/*! CLR16 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR16(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR16_SHIFT)) & DMA_COMMON_ENABLECLR_CLR16_MASK)
#define DMA_COMMON_ENABLECLR_CLR17_MASK          (0x20000U)
#define DMA_COMMON_ENABLECLR_CLR17_SHIFT         (17U)
/*! CLR17 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR17(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR17_SHIFT)) & DMA_COMMON_ENABLECLR_CLR17_MASK)
#define DMA_COMMON_ENABLECLR_CLR18_MASK          (0x40000U)
#define DMA_COMMON_ENABLECLR_CLR18_SHIFT         (18U)
/*! CLR18 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR18(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR18_SHIFT)) & DMA_COMMON_ENABLECLR_CLR18_MASK)
#define DMA_COMMON_ENABLECLR_CLR19_MASK          (0x80000U)
#define DMA_COMMON_ENABLECLR_CLR19_SHIFT         (19U)
/*! CLR19 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR19(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR19_SHIFT)) & DMA_COMMON_ENABLECLR_CLR19_MASK)
#define DMA_COMMON_ENABLECLR_CLR20_MASK          (0x100000U)
#define DMA_COMMON_ENABLECLR_CLR20_SHIFT         (20U)
/*! CLR20 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR20(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR20_SHIFT)) & DMA_COMMON_ENABLECLR_CLR20_MASK)
#define DMA_COMMON_ENABLECLR_CLR21_MASK          (0x200000U)
#define DMA_COMMON_ENABLECLR_CLR21_SHIFT         (21U)
/*! CLR21 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR21(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR21_SHIFT)) & DMA_COMMON_ENABLECLR_CLR21_MASK)
#define DMA_COMMON_ENABLECLR_CLR22_MASK          (0x400000U)
#define DMA_COMMON_ENABLECLR_CLR22_SHIFT         (22U)
/*! CLR22 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR22(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR22_SHIFT)) & DMA_COMMON_ENABLECLR_CLR22_MASK)
#define DMA_COMMON_ENABLECLR_CLR23_MASK          (0x800000U)
#define DMA_COMMON_ENABLECLR_CLR23_SHIFT         (23U)
/*! CLR23 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR23(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR23_SHIFT)) & DMA_COMMON_ENABLECLR_CLR23_MASK)
#define DMA_COMMON_ENABLECLR_CLR24_MASK          (0x1000000U)
#define DMA_COMMON_ENABLECLR_CLR24_SHIFT         (24U)
/*! CLR24 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR24(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR24_SHIFT)) & DMA_COMMON_ENABLECLR_CLR24_MASK)
#define DMA_COMMON_ENABLECLR_CLR25_MASK          (0x2000000U)
#define DMA_COMMON_ENABLECLR_CLR25_SHIFT         (25U)
/*! CLR25 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR25(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR25_SHIFT)) & DMA_COMMON_ENABLECLR_CLR25_MASK)
#define DMA_COMMON_ENABLECLR_CLR26_MASK          (0x4000000U)
#define DMA_COMMON_ENABLECLR_CLR26_SHIFT         (26U)
/*! CLR26 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR26(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR26_SHIFT)) & DMA_COMMON_ENABLECLR_CLR26_MASK)
#define DMA_COMMON_ENABLECLR_CLR27_MASK          (0x8000000U)
#define DMA_COMMON_ENABLECLR_CLR27_SHIFT         (27U)
/*! CLR27 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR27(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR27_SHIFT)) & DMA_COMMON_ENABLECLR_CLR27_MASK)
#define DMA_COMMON_ENABLECLR_CLR28_MASK          (0x10000000U)
#define DMA_COMMON_ENABLECLR_CLR28_SHIFT         (28U)
/*! CLR28 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR28(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR28_SHIFT)) & DMA_COMMON_ENABLECLR_CLR28_MASK)
#define DMA_COMMON_ENABLECLR_CLR29_MASK          (0x20000000U)
#define DMA_COMMON_ENABLECLR_CLR29_SHIFT         (29U)
/*! CLR29 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR29(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR29_SHIFT)) & DMA_COMMON_ENABLECLR_CLR29_MASK)
#define DMA_COMMON_ENABLECLR_CLR30_MASK          (0x40000000U)
#define DMA_COMMON_ENABLECLR_CLR30_SHIFT         (30U)
/*! CLR30 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR30(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR30_SHIFT)) & DMA_COMMON_ENABLECLR_CLR30_MASK)
#define DMA_COMMON_ENABLECLR_CLR31_MASK          (0x80000000U)
#define DMA_COMMON_ENABLECLR_CLR31_SHIFT         (31U)
/*! CLR31 - Writing ones to this register clears the corresponding bits in ENABLESET0.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR_CLR31(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR_CLR31_SHIFT)) & DMA_COMMON_ENABLECLR_CLR31_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLECLR */
#define DMA_COMMON_ENABLECLR_COUNT               (1U)

/*! @name COMMON_ENABLECLR1 - Channel Enable Clear for all DMA channels */
/*! @{ */
#define DMA_COMMON_ENABLECLR1_CLR32_MASK         (0x1U)
#define DMA_COMMON_ENABLECLR1_CLR32_SHIFT        (0U)
/*! CLR32 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR32(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR32_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR32_MASK)
#define DMA_COMMON_ENABLECLR1_CLR33_MASK         (0x2U)
#define DMA_COMMON_ENABLECLR1_CLR33_SHIFT        (1U)
/*! CLR33 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR33(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR33_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR33_MASK)
#define DMA_COMMON_ENABLECLR1_CLR34_MASK         (0x4U)
#define DMA_COMMON_ENABLECLR1_CLR34_SHIFT        (2U)
/*! CLR34 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR34(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR34_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR34_MASK)
#define DMA_COMMON_ENABLECLR1_CLR35_MASK         (0x8U)
#define DMA_COMMON_ENABLECLR1_CLR35_SHIFT        (3U)
/*! CLR35 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR35(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR35_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR35_MASK)
#define DMA_COMMON_ENABLECLR1_CLR36_MASK         (0x10U)
#define DMA_COMMON_ENABLECLR1_CLR36_SHIFT        (4U)
/*! CLR36 - Writing ones to this register clears the corresponding bits in ENABLESET1.
 *  0b0..No effect.
 *  0b1..DMA channel is cleared.
 */
#define DMA_COMMON_ENABLECLR1_CLR36(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ENABLECLR1_CLR36_SHIFT)) & DMA_COMMON_ENABLECLR1_CLR36_MASK)
/*! @} */

/* The count of DMA_COMMON_ENABLECLR1 */
#define DMA_COMMON_ENABLECLR1_COUNT              (1U)

/*! @name COMMON_ACTIVE - Channel Active status for all DMA channels */
/*! @{ */
#define DMA_COMMON_ACTIVE_ACTIVE0_MASK           (0x1U)
#define DMA_COMMON_ACTIVE_ACTIVE0_SHIFT          (0U)
/*! ACTIVE0 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE0(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE0_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE0_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE1_MASK           (0x2U)
#define DMA_COMMON_ACTIVE_ACTIVE1_SHIFT          (1U)
/*! ACTIVE1 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE1(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE1_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE1_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE2_MASK           (0x4U)
#define DMA_COMMON_ACTIVE_ACTIVE2_SHIFT          (2U)
/*! ACTIVE2 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE2(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE2_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE2_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE3_MASK           (0x8U)
#define DMA_COMMON_ACTIVE_ACTIVE3_SHIFT          (3U)
/*! ACTIVE3 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE3(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE3_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE3_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE4_MASK           (0x10U)
#define DMA_COMMON_ACTIVE_ACTIVE4_SHIFT          (4U)
/*! ACTIVE4 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE4(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE4_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE4_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE5_MASK           (0x20U)
#define DMA_COMMON_ACTIVE_ACTIVE5_SHIFT          (5U)
/*! ACTIVE5 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE5(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE5_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE5_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE6_MASK           (0x40U)
#define DMA_COMMON_ACTIVE_ACTIVE6_SHIFT          (6U)
/*! ACTIVE6 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE6(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE6_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE6_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE7_MASK           (0x80U)
#define DMA_COMMON_ACTIVE_ACTIVE7_SHIFT          (7U)
/*! ACTIVE7 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE7(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE7_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE7_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE8_MASK           (0x100U)
#define DMA_COMMON_ACTIVE_ACTIVE8_SHIFT          (8U)
/*! ACTIVE8 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE8(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE8_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE8_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE9_MASK           (0x200U)
#define DMA_COMMON_ACTIVE_ACTIVE9_SHIFT          (9U)
/*! ACTIVE9 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE9(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE9_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE9_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE10_MASK          (0x400U)
#define DMA_COMMON_ACTIVE_ACTIVE10_SHIFT         (10U)
/*! ACTIVE10 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE10(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE10_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE10_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE11_MASK          (0x800U)
#define DMA_COMMON_ACTIVE_ACTIVE11_SHIFT         (11U)
/*! ACTIVE11 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE11(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE11_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE11_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE12_MASK          (0x1000U)
#define DMA_COMMON_ACTIVE_ACTIVE12_SHIFT         (12U)
/*! ACTIVE12 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE12(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE12_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE12_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE13_MASK          (0x2000U)
#define DMA_COMMON_ACTIVE_ACTIVE13_SHIFT         (13U)
/*! ACTIVE13 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE13(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE13_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE13_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE14_MASK          (0x4000U)
#define DMA_COMMON_ACTIVE_ACTIVE14_SHIFT         (14U)
/*! ACTIVE14 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE14(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE14_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE14_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE15_MASK          (0x8000U)
#define DMA_COMMON_ACTIVE_ACTIVE15_SHIFT         (15U)
/*! ACTIVE15 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE15(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE15_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE15_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE16_MASK          (0x10000U)
#define DMA_COMMON_ACTIVE_ACTIVE16_SHIFT         (16U)
/*! ACTIVE16 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE16(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE16_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE16_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE17_MASK          (0x20000U)
#define DMA_COMMON_ACTIVE_ACTIVE17_SHIFT         (17U)
/*! ACTIVE17 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE17(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE17_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE17_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE18_MASK          (0x40000U)
#define DMA_COMMON_ACTIVE_ACTIVE18_SHIFT         (18U)
/*! ACTIVE18 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE18(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE18_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE18_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE19_MASK          (0x80000U)
#define DMA_COMMON_ACTIVE_ACTIVE19_SHIFT         (19U)
/*! ACTIVE19 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE19(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE19_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE19_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE20_MASK          (0x100000U)
#define DMA_COMMON_ACTIVE_ACTIVE20_SHIFT         (20U)
/*! ACTIVE20 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE20(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE20_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE20_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE21_MASK          (0x200000U)
#define DMA_COMMON_ACTIVE_ACTIVE21_SHIFT         (21U)
/*! ACTIVE21 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE21(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE21_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE21_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE22_MASK          (0x400000U)
#define DMA_COMMON_ACTIVE_ACTIVE22_SHIFT         (22U)
/*! ACTIVE22 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE22(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE22_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE22_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE23_MASK          (0x800000U)
#define DMA_COMMON_ACTIVE_ACTIVE23_SHIFT         (23U)
/*! ACTIVE23 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE23(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE23_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE23_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE24_MASK          (0x1000000U)
#define DMA_COMMON_ACTIVE_ACTIVE24_SHIFT         (24U)
/*! ACTIVE24 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE24(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE24_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE24_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE25_MASK          (0x2000000U)
#define DMA_COMMON_ACTIVE_ACTIVE25_SHIFT         (25U)
/*! ACTIVE25 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE25(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE25_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE25_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE26_MASK          (0x4000000U)
#define DMA_COMMON_ACTIVE_ACTIVE26_SHIFT         (26U)
/*! ACTIVE26 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE26(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE26_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE26_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE27_MASK          (0x8000000U)
#define DMA_COMMON_ACTIVE_ACTIVE27_SHIFT         (27U)
/*! ACTIVE27 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE27(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE27_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE27_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE28_MASK          (0x10000000U)
#define DMA_COMMON_ACTIVE_ACTIVE28_SHIFT         (28U)
/*! ACTIVE28 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE28(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE28_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE28_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE29_MASK          (0x20000000U)
#define DMA_COMMON_ACTIVE_ACTIVE29_SHIFT         (29U)
/*! ACTIVE29 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE29(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE29_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE29_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE30_MASK          (0x40000000U)
#define DMA_COMMON_ACTIVE_ACTIVE30_SHIFT         (30U)
/*! ACTIVE30 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE30(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE30_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE30_MASK)
#define DMA_COMMON_ACTIVE_ACTIVE31_MASK          (0x80000000U)
#define DMA_COMMON_ACTIVE_ACTIVE31_SHIFT         (31U)
/*! ACTIVE31 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE_ACTIVE31(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE_ACTIVE31_SHIFT)) & DMA_COMMON_ACTIVE_ACTIVE31_MASK)
/*! @} */

/* The count of DMA_COMMON_ACTIVE */
#define DMA_COMMON_ACTIVE_COUNT                  (1U)

/*! @name COMMON_ACTIVE1 - Channel Active status for all DMA channels */
/*! @{ */
#define DMA_COMMON_ACTIVE1_ACTIVE32_MASK         (0x1U)
#define DMA_COMMON_ACTIVE1_ACTIVE32_SHIFT        (0U)
/*! ACTIVE32 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE32(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE32_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE32_MASK)
#define DMA_COMMON_ACTIVE1_ACTIVE33_MASK         (0x2U)
#define DMA_COMMON_ACTIVE1_ACTIVE33_SHIFT        (1U)
/*! ACTIVE33 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE33(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE33_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE33_MASK)
#define DMA_COMMON_ACTIVE1_ACTIVE34_MASK         (0x4U)
#define DMA_COMMON_ACTIVE1_ACTIVE34_SHIFT        (2U)
/*! ACTIVE34 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE34(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE34_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE34_MASK)
#define DMA_COMMON_ACTIVE1_ACTIVE35_MASK         (0x8U)
#define DMA_COMMON_ACTIVE1_ACTIVE35_SHIFT        (3U)
/*! ACTIVE35 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE35(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE35_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE35_MASK)
#define DMA_COMMON_ACTIVE1_ACTIVE36_MASK         (0x10U)
#define DMA_COMMON_ACTIVE1_ACTIVE36_SHIFT        (4U)
/*! ACTIVE36 - Active flag for DMA channel.
 *  0b0..DMA channel is not active.
 *  0b1..DMA channel is active.
 */
#define DMA_COMMON_ACTIVE1_ACTIVE36(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ACTIVE1_ACTIVE36_SHIFT)) & DMA_COMMON_ACTIVE1_ACTIVE36_MASK)
/*! @} */

/* The count of DMA_COMMON_ACTIVE1 */
#define DMA_COMMON_ACTIVE1_COUNT                 (1U)

/*! @name COMMON_BUSY - Channel Busy status for all DMA channels */
/*! @{ */
#define DMA_COMMON_BUSY_BUSY0_MASK               (0x1U)
#define DMA_COMMON_BUSY_BUSY0_SHIFT              (0U)
/*! BUSY0 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY0(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY0_SHIFT)) & DMA_COMMON_BUSY_BUSY0_MASK)
#define DMA_COMMON_BUSY_BUSY1_MASK               (0x2U)
#define DMA_COMMON_BUSY_BUSY1_SHIFT              (1U)
/*! BUSY1 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY1(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY1_SHIFT)) & DMA_COMMON_BUSY_BUSY1_MASK)
#define DMA_COMMON_BUSY_BUSY2_MASK               (0x4U)
#define DMA_COMMON_BUSY_BUSY2_SHIFT              (2U)
/*! BUSY2 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY2(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY2_SHIFT)) & DMA_COMMON_BUSY_BUSY2_MASK)
#define DMA_COMMON_BUSY_BUSY3_MASK               (0x8U)
#define DMA_COMMON_BUSY_BUSY3_SHIFT              (3U)
/*! BUSY3 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY3(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY3_SHIFT)) & DMA_COMMON_BUSY_BUSY3_MASK)
#define DMA_COMMON_BUSY_BUSY4_MASK               (0x10U)
#define DMA_COMMON_BUSY_BUSY4_SHIFT              (4U)
/*! BUSY4 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY4(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY4_SHIFT)) & DMA_COMMON_BUSY_BUSY4_MASK)
#define DMA_COMMON_BUSY_BUSY5_MASK               (0x20U)
#define DMA_COMMON_BUSY_BUSY5_SHIFT              (5U)
/*! BUSY5 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY5(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY5_SHIFT)) & DMA_COMMON_BUSY_BUSY5_MASK)
#define DMA_COMMON_BUSY_BUSY6_MASK               (0x40U)
#define DMA_COMMON_BUSY_BUSY6_SHIFT              (6U)
/*! BUSY6 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY6(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY6_SHIFT)) & DMA_COMMON_BUSY_BUSY6_MASK)
#define DMA_COMMON_BUSY_BUSY7_MASK               (0x80U)
#define DMA_COMMON_BUSY_BUSY7_SHIFT              (7U)
/*! BUSY7 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY7(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY7_SHIFT)) & DMA_COMMON_BUSY_BUSY7_MASK)
#define DMA_COMMON_BUSY_BUSY8_MASK               (0x100U)
#define DMA_COMMON_BUSY_BUSY8_SHIFT              (8U)
/*! BUSY8 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY8(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY8_SHIFT)) & DMA_COMMON_BUSY_BUSY8_MASK)
#define DMA_COMMON_BUSY_BUSY9_MASK               (0x200U)
#define DMA_COMMON_BUSY_BUSY9_SHIFT              (9U)
/*! BUSY9 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY9(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY9_SHIFT)) & DMA_COMMON_BUSY_BUSY9_MASK)
#define DMA_COMMON_BUSY_BUSY10_MASK              (0x400U)
#define DMA_COMMON_BUSY_BUSY10_SHIFT             (10U)
/*! BUSY10 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY10(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY10_SHIFT)) & DMA_COMMON_BUSY_BUSY10_MASK)
#define DMA_COMMON_BUSY_BUSY11_MASK              (0x800U)
#define DMA_COMMON_BUSY_BUSY11_SHIFT             (11U)
/*! BUSY11 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY11(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY11_SHIFT)) & DMA_COMMON_BUSY_BUSY11_MASK)
#define DMA_COMMON_BUSY_BUSY12_MASK              (0x1000U)
#define DMA_COMMON_BUSY_BUSY12_SHIFT             (12U)
/*! BUSY12 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY12(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY12_SHIFT)) & DMA_COMMON_BUSY_BUSY12_MASK)
#define DMA_COMMON_BUSY_BUSY13_MASK              (0x2000U)
#define DMA_COMMON_BUSY_BUSY13_SHIFT             (13U)
/*! BUSY13 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY13(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY13_SHIFT)) & DMA_COMMON_BUSY_BUSY13_MASK)
#define DMA_COMMON_BUSY_BUSY14_MASK              (0x4000U)
#define DMA_COMMON_BUSY_BUSY14_SHIFT             (14U)
/*! BUSY14 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY14(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY14_SHIFT)) & DMA_COMMON_BUSY_BUSY14_MASK)
#define DMA_COMMON_BUSY_BUSY15_MASK              (0x8000U)
#define DMA_COMMON_BUSY_BUSY15_SHIFT             (15U)
/*! BUSY15 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY15(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY15_SHIFT)) & DMA_COMMON_BUSY_BUSY15_MASK)
#define DMA_COMMON_BUSY_BUSY16_MASK              (0x10000U)
#define DMA_COMMON_BUSY_BUSY16_SHIFT             (16U)
/*! BUSY16 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY16(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY16_SHIFT)) & DMA_COMMON_BUSY_BUSY16_MASK)
#define DMA_COMMON_BUSY_BUSY17_MASK              (0x20000U)
#define DMA_COMMON_BUSY_BUSY17_SHIFT             (17U)
/*! BUSY17 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY17(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY17_SHIFT)) & DMA_COMMON_BUSY_BUSY17_MASK)
#define DMA_COMMON_BUSY_BUSY18_MASK              (0x40000U)
#define DMA_COMMON_BUSY_BUSY18_SHIFT             (18U)
/*! BUSY18 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY18(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY18_SHIFT)) & DMA_COMMON_BUSY_BUSY18_MASK)
#define DMA_COMMON_BUSY_BUSY19_MASK              (0x80000U)
#define DMA_COMMON_BUSY_BUSY19_SHIFT             (19U)
/*! BUSY19 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY19(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY19_SHIFT)) & DMA_COMMON_BUSY_BUSY19_MASK)
#define DMA_COMMON_BUSY_BUSY20_MASK              (0x100000U)
#define DMA_COMMON_BUSY_BUSY20_SHIFT             (20U)
/*! BUSY20 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY20(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY20_SHIFT)) & DMA_COMMON_BUSY_BUSY20_MASK)
#define DMA_COMMON_BUSY_BUSY21_MASK              (0x200000U)
#define DMA_COMMON_BUSY_BUSY21_SHIFT             (21U)
/*! BUSY21 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY21(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY21_SHIFT)) & DMA_COMMON_BUSY_BUSY21_MASK)
#define DMA_COMMON_BUSY_BUSY22_MASK              (0x400000U)
#define DMA_COMMON_BUSY_BUSY22_SHIFT             (22U)
/*! BUSY22 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY22(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY22_SHIFT)) & DMA_COMMON_BUSY_BUSY22_MASK)
#define DMA_COMMON_BUSY_BUSY23_MASK              (0x800000U)
#define DMA_COMMON_BUSY_BUSY23_SHIFT             (23U)
/*! BUSY23 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY23(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY23_SHIFT)) & DMA_COMMON_BUSY_BUSY23_MASK)
#define DMA_COMMON_BUSY_BUSY24_MASK              (0x1000000U)
#define DMA_COMMON_BUSY_BUSY24_SHIFT             (24U)
/*! BUSY24 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY24(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY24_SHIFT)) & DMA_COMMON_BUSY_BUSY24_MASK)
#define DMA_COMMON_BUSY_BUSY25_MASK              (0x2000000U)
#define DMA_COMMON_BUSY_BUSY25_SHIFT             (25U)
/*! BUSY25 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY25(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY25_SHIFT)) & DMA_COMMON_BUSY_BUSY25_MASK)
#define DMA_COMMON_BUSY_BUSY26_MASK              (0x4000000U)
#define DMA_COMMON_BUSY_BUSY26_SHIFT             (26U)
/*! BUSY26 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY26(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY26_SHIFT)) & DMA_COMMON_BUSY_BUSY26_MASK)
#define DMA_COMMON_BUSY_BUSY27_MASK              (0x8000000U)
#define DMA_COMMON_BUSY_BUSY27_SHIFT             (27U)
/*! BUSY27 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY27(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY27_SHIFT)) & DMA_COMMON_BUSY_BUSY27_MASK)
#define DMA_COMMON_BUSY_BUSY28_MASK              (0x10000000U)
#define DMA_COMMON_BUSY_BUSY28_SHIFT             (28U)
/*! BUSY28 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY28(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY28_SHIFT)) & DMA_COMMON_BUSY_BUSY28_MASK)
#define DMA_COMMON_BUSY_BUSY29_MASK              (0x20000000U)
#define DMA_COMMON_BUSY_BUSY29_SHIFT             (29U)
/*! BUSY29 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY29(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY29_SHIFT)) & DMA_COMMON_BUSY_BUSY29_MASK)
#define DMA_COMMON_BUSY_BUSY30_MASK              (0x40000000U)
#define DMA_COMMON_BUSY_BUSY30_SHIFT             (30U)
/*! BUSY30 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY30(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY30_SHIFT)) & DMA_COMMON_BUSY_BUSY30_MASK)
#define DMA_COMMON_BUSY_BUSY31_MASK              (0x80000000U)
#define DMA_COMMON_BUSY_BUSY31_SHIFT             (31U)
/*! BUSY31 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY_BUSY31(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY_BUSY31_SHIFT)) & DMA_COMMON_BUSY_BUSY31_MASK)
/*! @} */

/* The count of DMA_COMMON_BUSY */
#define DMA_COMMON_BUSY_COUNT                    (1U)

/*! @name COMMON_BUSY1 - Channel Busy status for all DMA channels */
/*! @{ */
#define DMA_COMMON_BUSY1_BUSY32_MASK             (0x1U)
#define DMA_COMMON_BUSY1_BUSY32_SHIFT            (0U)
/*! BUSY32 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY32(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY32_SHIFT)) & DMA_COMMON_BUSY1_BUSY32_MASK)
#define DMA_COMMON_BUSY1_BUSY33_MASK             (0x2U)
#define DMA_COMMON_BUSY1_BUSY33_SHIFT            (1U)
/*! BUSY33 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY33(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY33_SHIFT)) & DMA_COMMON_BUSY1_BUSY33_MASK)
#define DMA_COMMON_BUSY1_BUSY34_MASK             (0x4U)
#define DMA_COMMON_BUSY1_BUSY34_SHIFT            (2U)
/*! BUSY34 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY34(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY34_SHIFT)) & DMA_COMMON_BUSY1_BUSY34_MASK)
#define DMA_COMMON_BUSY1_BUSY35_MASK             (0x8U)
#define DMA_COMMON_BUSY1_BUSY35_SHIFT            (3U)
/*! BUSY35 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY35(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY35_SHIFT)) & DMA_COMMON_BUSY1_BUSY35_MASK)
#define DMA_COMMON_BUSY1_BUSY36_MASK             (0x10U)
#define DMA_COMMON_BUSY1_BUSY36_SHIFT            (4U)
/*! BUSY36 - Busy flag for DMA channel.
 *  0b0..DMA channel is not busy.
 *  0b1..DMA channel is busy.
 */
#define DMA_COMMON_BUSY1_BUSY36(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_BUSY1_BUSY36_SHIFT)) & DMA_COMMON_BUSY1_BUSY36_MASK)
/*! @} */

/* The count of DMA_COMMON_BUSY1 */
#define DMA_COMMON_BUSY1_COUNT                   (1U)

/*! @name COMMON_ERRINT - Error Interrupt status for all DMA channels */
/*! @{ */
#define DMA_COMMON_ERRINT_ERR0_MASK              (0x1U)
#define DMA_COMMON_ERRINT_ERR0_SHIFT             (0U)
/*! ERR0 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR0(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR0_SHIFT)) & DMA_COMMON_ERRINT_ERR0_MASK)
#define DMA_COMMON_ERRINT_ERR1_MASK              (0x2U)
#define DMA_COMMON_ERRINT_ERR1_SHIFT             (1U)
/*! ERR1 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR1(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR1_SHIFT)) & DMA_COMMON_ERRINT_ERR1_MASK)
#define DMA_COMMON_ERRINT_ERR2_MASK              (0x4U)
#define DMA_COMMON_ERRINT_ERR2_SHIFT             (2U)
/*! ERR2 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR2(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR2_SHIFT)) & DMA_COMMON_ERRINT_ERR2_MASK)
#define DMA_COMMON_ERRINT_ERR3_MASK              (0x8U)
#define DMA_COMMON_ERRINT_ERR3_SHIFT             (3U)
/*! ERR3 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR3(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR3_SHIFT)) & DMA_COMMON_ERRINT_ERR3_MASK)
#define DMA_COMMON_ERRINT_ERR4_MASK              (0x10U)
#define DMA_COMMON_ERRINT_ERR4_SHIFT             (4U)
/*! ERR4 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR4(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR4_SHIFT)) & DMA_COMMON_ERRINT_ERR4_MASK)
#define DMA_COMMON_ERRINT_ERR5_MASK              (0x20U)
#define DMA_COMMON_ERRINT_ERR5_SHIFT             (5U)
/*! ERR5 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR5(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR5_SHIFT)) & DMA_COMMON_ERRINT_ERR5_MASK)
#define DMA_COMMON_ERRINT_ERR6_MASK              (0x40U)
#define DMA_COMMON_ERRINT_ERR6_SHIFT             (6U)
/*! ERR6 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR6(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR6_SHIFT)) & DMA_COMMON_ERRINT_ERR6_MASK)
#define DMA_COMMON_ERRINT_ERR7_MASK              (0x80U)
#define DMA_COMMON_ERRINT_ERR7_SHIFT             (7U)
/*! ERR7 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR7(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR7_SHIFT)) & DMA_COMMON_ERRINT_ERR7_MASK)
#define DMA_COMMON_ERRINT_ERR8_MASK              (0x100U)
#define DMA_COMMON_ERRINT_ERR8_SHIFT             (8U)
/*! ERR8 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR8(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR8_SHIFT)) & DMA_COMMON_ERRINT_ERR8_MASK)
#define DMA_COMMON_ERRINT_ERR9_MASK              (0x200U)
#define DMA_COMMON_ERRINT_ERR9_SHIFT             (9U)
/*! ERR9 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR9(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR9_SHIFT)) & DMA_COMMON_ERRINT_ERR9_MASK)
#define DMA_COMMON_ERRINT_ERR10_MASK             (0x400U)
#define DMA_COMMON_ERRINT_ERR10_SHIFT            (10U)
/*! ERR10 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR10(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR10_SHIFT)) & DMA_COMMON_ERRINT_ERR10_MASK)
#define DMA_COMMON_ERRINT_ERR11_MASK             (0x800U)
#define DMA_COMMON_ERRINT_ERR11_SHIFT            (11U)
/*! ERR11 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR11(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR11_SHIFT)) & DMA_COMMON_ERRINT_ERR11_MASK)
#define DMA_COMMON_ERRINT_ERR12_MASK             (0x1000U)
#define DMA_COMMON_ERRINT_ERR12_SHIFT            (12U)
/*! ERR12 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR12(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR12_SHIFT)) & DMA_COMMON_ERRINT_ERR12_MASK)
#define DMA_COMMON_ERRINT_ERR13_MASK             (0x2000U)
#define DMA_COMMON_ERRINT_ERR13_SHIFT            (13U)
/*! ERR13 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR13(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR13_SHIFT)) & DMA_COMMON_ERRINT_ERR13_MASK)
#define DMA_COMMON_ERRINT_ERR14_MASK             (0x4000U)
#define DMA_COMMON_ERRINT_ERR14_SHIFT            (14U)
/*! ERR14 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR14(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR14_SHIFT)) & DMA_COMMON_ERRINT_ERR14_MASK)
#define DMA_COMMON_ERRINT_ERR15_MASK             (0x8000U)
#define DMA_COMMON_ERRINT_ERR15_SHIFT            (15U)
/*! ERR15 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR15(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR15_SHIFT)) & DMA_COMMON_ERRINT_ERR15_MASK)
#define DMA_COMMON_ERRINT_ERR16_MASK             (0x10000U)
#define DMA_COMMON_ERRINT_ERR16_SHIFT            (16U)
/*! ERR16 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR16(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR16_SHIFT)) & DMA_COMMON_ERRINT_ERR16_MASK)
#define DMA_COMMON_ERRINT_ERR17_MASK             (0x20000U)
#define DMA_COMMON_ERRINT_ERR17_SHIFT            (17U)
/*! ERR17 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR17(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR17_SHIFT)) & DMA_COMMON_ERRINT_ERR17_MASK)
#define DMA_COMMON_ERRINT_ERR18_MASK             (0x40000U)
#define DMA_COMMON_ERRINT_ERR18_SHIFT            (18U)
/*! ERR18 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR18(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR18_SHIFT)) & DMA_COMMON_ERRINT_ERR18_MASK)
#define DMA_COMMON_ERRINT_ERR19_MASK             (0x80000U)
#define DMA_COMMON_ERRINT_ERR19_SHIFT            (19U)
/*! ERR19 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR19(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR19_SHIFT)) & DMA_COMMON_ERRINT_ERR19_MASK)
#define DMA_COMMON_ERRINT_ERR20_MASK             (0x100000U)
#define DMA_COMMON_ERRINT_ERR20_SHIFT            (20U)
/*! ERR20 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR20(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR20_SHIFT)) & DMA_COMMON_ERRINT_ERR20_MASK)
#define DMA_COMMON_ERRINT_ERR21_MASK             (0x200000U)
#define DMA_COMMON_ERRINT_ERR21_SHIFT            (21U)
/*! ERR21 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR21(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR21_SHIFT)) & DMA_COMMON_ERRINT_ERR21_MASK)
#define DMA_COMMON_ERRINT_ERR22_MASK             (0x400000U)
#define DMA_COMMON_ERRINT_ERR22_SHIFT            (22U)
/*! ERR22 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR22(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR22_SHIFT)) & DMA_COMMON_ERRINT_ERR22_MASK)
#define DMA_COMMON_ERRINT_ERR23_MASK             (0x800000U)
#define DMA_COMMON_ERRINT_ERR23_SHIFT            (23U)
/*! ERR23 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR23(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR23_SHIFT)) & DMA_COMMON_ERRINT_ERR23_MASK)
#define DMA_COMMON_ERRINT_ERR24_MASK             (0x1000000U)
#define DMA_COMMON_ERRINT_ERR24_SHIFT            (24U)
/*! ERR24 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR24(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR24_SHIFT)) & DMA_COMMON_ERRINT_ERR24_MASK)
#define DMA_COMMON_ERRINT_ERR25_MASK             (0x2000000U)
#define DMA_COMMON_ERRINT_ERR25_SHIFT            (25U)
/*! ERR25 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR25(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR25_SHIFT)) & DMA_COMMON_ERRINT_ERR25_MASK)
#define DMA_COMMON_ERRINT_ERR26_MASK             (0x4000000U)
#define DMA_COMMON_ERRINT_ERR26_SHIFT            (26U)
/*! ERR26 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR26(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR26_SHIFT)) & DMA_COMMON_ERRINT_ERR26_MASK)
#define DMA_COMMON_ERRINT_ERR27_MASK             (0x8000000U)
#define DMA_COMMON_ERRINT_ERR27_SHIFT            (27U)
/*! ERR27 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR27(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR27_SHIFT)) & DMA_COMMON_ERRINT_ERR27_MASK)
#define DMA_COMMON_ERRINT_ERR28_MASK             (0x10000000U)
#define DMA_COMMON_ERRINT_ERR28_SHIFT            (28U)
/*! ERR28 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR28(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR28_SHIFT)) & DMA_COMMON_ERRINT_ERR28_MASK)
#define DMA_COMMON_ERRINT_ERR29_MASK             (0x20000000U)
#define DMA_COMMON_ERRINT_ERR29_SHIFT            (29U)
/*! ERR29 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR29(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR29_SHIFT)) & DMA_COMMON_ERRINT_ERR29_MASK)
#define DMA_COMMON_ERRINT_ERR30_MASK             (0x40000000U)
#define DMA_COMMON_ERRINT_ERR30_SHIFT            (30U)
/*! ERR30 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR30(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR30_SHIFT)) & DMA_COMMON_ERRINT_ERR30_MASK)
#define DMA_COMMON_ERRINT_ERR31_MASK             (0x80000000U)
#define DMA_COMMON_ERRINT_ERR31_SHIFT            (31U)
/*! ERR31 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT_ERR31(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT_ERR31_SHIFT)) & DMA_COMMON_ERRINT_ERR31_MASK)
/*! @} */

/* The count of DMA_COMMON_ERRINT */
#define DMA_COMMON_ERRINT_COUNT                  (1U)

/*! @name COMMON_ERRINT1 - Error Interrupt status for all DMA channels */
/*! @{ */
#define DMA_COMMON_ERRINT1_ERR32_MASK            (0x1U)
#define DMA_COMMON_ERRINT1_ERR32_SHIFT           (0U)
/*! ERR32 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR32(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR32_SHIFT)) & DMA_COMMON_ERRINT1_ERR32_MASK)
#define DMA_COMMON_ERRINT1_ERR33_MASK            (0x2U)
#define DMA_COMMON_ERRINT1_ERR33_SHIFT           (1U)
/*! ERR33 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR33(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR33_SHIFT)) & DMA_COMMON_ERRINT1_ERR33_MASK)
#define DMA_COMMON_ERRINT1_ERR34_MASK            (0x4U)
#define DMA_COMMON_ERRINT1_ERR34_SHIFT           (2U)
/*! ERR34 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR34(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR34_SHIFT)) & DMA_COMMON_ERRINT1_ERR34_MASK)
#define DMA_COMMON_ERRINT1_ERR35_MASK            (0x8U)
#define DMA_COMMON_ERRINT1_ERR35_SHIFT           (3U)
/*! ERR35 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR35(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR35_SHIFT)) & DMA_COMMON_ERRINT1_ERR35_MASK)
#define DMA_COMMON_ERRINT1_ERR36_MASK            (0x10U)
#define DMA_COMMON_ERRINT1_ERR36_SHIFT           (4U)
/*! ERR36 - Error Interrupt flag for DMA channel.
 *  0b0..The Error Interrupt is not active for DMA channel.
 *  0b1..The Error Interrupt is pending for DMA channel.
 */
#define DMA_COMMON_ERRINT1_ERR36(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ERRINT1_ERR36_SHIFT)) & DMA_COMMON_ERRINT1_ERR36_MASK)
/*! @} */

/* The count of DMA_COMMON_ERRINT1 */
#define DMA_COMMON_ERRINT1_COUNT                 (1U)

/*! @name COMMON_INTENSET - Interrupt Enable read and Set for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTENSET_INTEN0_MASK          (0x1U)
#define DMA_COMMON_INTENSET_INTEN0_SHIFT         (0U)
/*! INTEN0 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN0(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN0_SHIFT)) & DMA_COMMON_INTENSET_INTEN0_MASK)
#define DMA_COMMON_INTENSET_INTEN1_MASK          (0x2U)
#define DMA_COMMON_INTENSET_INTEN1_SHIFT         (1U)
/*! INTEN1 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN1(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN1_SHIFT)) & DMA_COMMON_INTENSET_INTEN1_MASK)
#define DMA_COMMON_INTENSET_INTEN2_MASK          (0x4U)
#define DMA_COMMON_INTENSET_INTEN2_SHIFT         (2U)
/*! INTEN2 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN2(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN2_SHIFT)) & DMA_COMMON_INTENSET_INTEN2_MASK)
#define DMA_COMMON_INTENSET_INTEN3_MASK          (0x8U)
#define DMA_COMMON_INTENSET_INTEN3_SHIFT         (3U)
/*! INTEN3 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN3(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN3_SHIFT)) & DMA_COMMON_INTENSET_INTEN3_MASK)
#define DMA_COMMON_INTENSET_INTEN4_MASK          (0x10U)
#define DMA_COMMON_INTENSET_INTEN4_SHIFT         (4U)
/*! INTEN4 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN4(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN4_SHIFT)) & DMA_COMMON_INTENSET_INTEN4_MASK)
#define DMA_COMMON_INTENSET_INTEN5_MASK          (0x20U)
#define DMA_COMMON_INTENSET_INTEN5_SHIFT         (5U)
/*! INTEN5 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN5(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN5_SHIFT)) & DMA_COMMON_INTENSET_INTEN5_MASK)
#define DMA_COMMON_INTENSET_INTEN6_MASK          (0x40U)
#define DMA_COMMON_INTENSET_INTEN6_SHIFT         (6U)
/*! INTEN6 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN6(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN6_SHIFT)) & DMA_COMMON_INTENSET_INTEN6_MASK)
#define DMA_COMMON_INTENSET_INTEN7_MASK          (0x80U)
#define DMA_COMMON_INTENSET_INTEN7_SHIFT         (7U)
/*! INTEN7 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN7(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN7_SHIFT)) & DMA_COMMON_INTENSET_INTEN7_MASK)
#define DMA_COMMON_INTENSET_INTEN8_MASK          (0x100U)
#define DMA_COMMON_INTENSET_INTEN8_SHIFT         (8U)
/*! INTEN8 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN8(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN8_SHIFT)) & DMA_COMMON_INTENSET_INTEN8_MASK)
#define DMA_COMMON_INTENSET_INTEN9_MASK          (0x200U)
#define DMA_COMMON_INTENSET_INTEN9_SHIFT         (9U)
/*! INTEN9 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN9(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN9_SHIFT)) & DMA_COMMON_INTENSET_INTEN9_MASK)
#define DMA_COMMON_INTENSET_INTEN10_MASK         (0x400U)
#define DMA_COMMON_INTENSET_INTEN10_SHIFT        (10U)
/*! INTEN10 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN10(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN10_SHIFT)) & DMA_COMMON_INTENSET_INTEN10_MASK)
#define DMA_COMMON_INTENSET_INTEN11_MASK         (0x800U)
#define DMA_COMMON_INTENSET_INTEN11_SHIFT        (11U)
/*! INTEN11 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN11(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN11_SHIFT)) & DMA_COMMON_INTENSET_INTEN11_MASK)
#define DMA_COMMON_INTENSET_INTEN12_MASK         (0x1000U)
#define DMA_COMMON_INTENSET_INTEN12_SHIFT        (12U)
/*! INTEN12 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN12(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN12_SHIFT)) & DMA_COMMON_INTENSET_INTEN12_MASK)
#define DMA_COMMON_INTENSET_INTEN13_MASK         (0x2000U)
#define DMA_COMMON_INTENSET_INTEN13_SHIFT        (13U)
/*! INTEN13 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN13(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN13_SHIFT)) & DMA_COMMON_INTENSET_INTEN13_MASK)
#define DMA_COMMON_INTENSET_INTEN14_MASK         (0x4000U)
#define DMA_COMMON_INTENSET_INTEN14_SHIFT        (14U)
/*! INTEN14 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN14(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN14_SHIFT)) & DMA_COMMON_INTENSET_INTEN14_MASK)
#define DMA_COMMON_INTENSET_INTEN15_MASK         (0x8000U)
#define DMA_COMMON_INTENSET_INTEN15_SHIFT        (15U)
/*! INTEN15 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN15(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN15_SHIFT)) & DMA_COMMON_INTENSET_INTEN15_MASK)
#define DMA_COMMON_INTENSET_INTEN16_MASK         (0x10000U)
#define DMA_COMMON_INTENSET_INTEN16_SHIFT        (16U)
/*! INTEN16 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN16(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN16_SHIFT)) & DMA_COMMON_INTENSET_INTEN16_MASK)
#define DMA_COMMON_INTENSET_INTEN17_MASK         (0x20000U)
#define DMA_COMMON_INTENSET_INTEN17_SHIFT        (17U)
/*! INTEN17 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN17(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN17_SHIFT)) & DMA_COMMON_INTENSET_INTEN17_MASK)
#define DMA_COMMON_INTENSET_INTEN18_MASK         (0x40000U)
#define DMA_COMMON_INTENSET_INTEN18_SHIFT        (18U)
/*! INTEN18 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN18(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN18_SHIFT)) & DMA_COMMON_INTENSET_INTEN18_MASK)
#define DMA_COMMON_INTENSET_INTEN19_MASK         (0x80000U)
#define DMA_COMMON_INTENSET_INTEN19_SHIFT        (19U)
/*! INTEN19 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN19(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN19_SHIFT)) & DMA_COMMON_INTENSET_INTEN19_MASK)
#define DMA_COMMON_INTENSET_INTEN20_MASK         (0x100000U)
#define DMA_COMMON_INTENSET_INTEN20_SHIFT        (20U)
/*! INTEN20 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN20(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN20_SHIFT)) & DMA_COMMON_INTENSET_INTEN20_MASK)
#define DMA_COMMON_INTENSET_INTEN21_MASK         (0x200000U)
#define DMA_COMMON_INTENSET_INTEN21_SHIFT        (21U)
/*! INTEN21 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN21(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN21_SHIFT)) & DMA_COMMON_INTENSET_INTEN21_MASK)
#define DMA_COMMON_INTENSET_INTEN22_MASK         (0x400000U)
#define DMA_COMMON_INTENSET_INTEN22_SHIFT        (22U)
/*! INTEN22 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN22(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN22_SHIFT)) & DMA_COMMON_INTENSET_INTEN22_MASK)
#define DMA_COMMON_INTENSET_INTEN23_MASK         (0x800000U)
#define DMA_COMMON_INTENSET_INTEN23_SHIFT        (23U)
/*! INTEN23 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN23(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN23_SHIFT)) & DMA_COMMON_INTENSET_INTEN23_MASK)
#define DMA_COMMON_INTENSET_INTEN24_MASK         (0x1000000U)
#define DMA_COMMON_INTENSET_INTEN24_SHIFT        (24U)
/*! INTEN24 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN24(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN24_SHIFT)) & DMA_COMMON_INTENSET_INTEN24_MASK)
#define DMA_COMMON_INTENSET_INTEN25_MASK         (0x2000000U)
#define DMA_COMMON_INTENSET_INTEN25_SHIFT        (25U)
/*! INTEN25 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN25(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN25_SHIFT)) & DMA_COMMON_INTENSET_INTEN25_MASK)
#define DMA_COMMON_INTENSET_INTEN26_MASK         (0x4000000U)
#define DMA_COMMON_INTENSET_INTEN26_SHIFT        (26U)
/*! INTEN26 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN26(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN26_SHIFT)) & DMA_COMMON_INTENSET_INTEN26_MASK)
#define DMA_COMMON_INTENSET_INTEN27_MASK         (0x8000000U)
#define DMA_COMMON_INTENSET_INTEN27_SHIFT        (27U)
/*! INTEN27 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN27(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN27_SHIFT)) & DMA_COMMON_INTENSET_INTEN27_MASK)
#define DMA_COMMON_INTENSET_INTEN28_MASK         (0x10000000U)
#define DMA_COMMON_INTENSET_INTEN28_SHIFT        (28U)
/*! INTEN28 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN28(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN28_SHIFT)) & DMA_COMMON_INTENSET_INTEN28_MASK)
#define DMA_COMMON_INTENSET_INTEN29_MASK         (0x20000000U)
#define DMA_COMMON_INTENSET_INTEN29_SHIFT        (29U)
/*! INTEN29 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN29(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN29_SHIFT)) & DMA_COMMON_INTENSET_INTEN29_MASK)
#define DMA_COMMON_INTENSET_INTEN30_MASK         (0x40000000U)
#define DMA_COMMON_INTENSET_INTEN30_SHIFT        (30U)
/*! INTEN30 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN30(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN30_SHIFT)) & DMA_COMMON_INTENSET_INTEN30_MASK)
#define DMA_COMMON_INTENSET_INTEN31_MASK         (0x80000000U)
#define DMA_COMMON_INTENSET_INTEN31_SHIFT        (31U)
/*! INTEN31 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET_INTEN31(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET_INTEN31_SHIFT)) & DMA_COMMON_INTENSET_INTEN31_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENSET */
#define DMA_COMMON_INTENSET_COUNT                (1U)

/*! @name COMMON_INTENSET1 - Interrupt Enable read and Set for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTENSET1_INTEN32_MASK        (0x1U)
#define DMA_COMMON_INTENSET1_INTEN32_SHIFT       (0U)
/*! INTEN32 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN32(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN32_SHIFT)) & DMA_COMMON_INTENSET1_INTEN32_MASK)
#define DMA_COMMON_INTENSET1_INTEN33_MASK        (0x2U)
#define DMA_COMMON_INTENSET1_INTEN33_SHIFT       (1U)
/*! INTEN33 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN33(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN33_SHIFT)) & DMA_COMMON_INTENSET1_INTEN33_MASK)
#define DMA_COMMON_INTENSET1_INTEN34_MASK        (0x4U)
#define DMA_COMMON_INTENSET1_INTEN34_SHIFT       (2U)
/*! INTEN34 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN34(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN34_SHIFT)) & DMA_COMMON_INTENSET1_INTEN34_MASK)
#define DMA_COMMON_INTENSET1_INTEN35_MASK        (0x8U)
#define DMA_COMMON_INTENSET1_INTEN35_SHIFT       (3U)
/*! INTEN35 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN35(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN35_SHIFT)) & DMA_COMMON_INTENSET1_INTEN35_MASK)
#define DMA_COMMON_INTENSET1_INTEN36_MASK        (0x10U)
#define DMA_COMMON_INTENSET1_INTEN36_SHIFT       (4U)
/*! INTEN36 - Interrupt Enable read and set for DMA channel.
 *  0b0..The Interrupt for DMA channel is disabled.
 *  0b1..The Interrupt for DMA channel is enabled.
 */
#define DMA_COMMON_INTENSET1_INTEN36(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENSET1_INTEN36_SHIFT)) & DMA_COMMON_INTENSET1_INTEN36_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENSET1 */
#define DMA_COMMON_INTENSET1_COUNT               (1U)

/*! @name COMMON_INTENCLR - Interrupt Enable Clear for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTENCLR_CLR0_MASK            (0x1U)
#define DMA_COMMON_INTENCLR_CLR0_SHIFT           (0U)
/*! CLR0 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR0(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR0_SHIFT)) & DMA_COMMON_INTENCLR_CLR0_MASK)
#define DMA_COMMON_INTENCLR_CLR1_MASK            (0x2U)
#define DMA_COMMON_INTENCLR_CLR1_SHIFT           (1U)
/*! CLR1 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR1(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR1_SHIFT)) & DMA_COMMON_INTENCLR_CLR1_MASK)
#define DMA_COMMON_INTENCLR_CLR2_MASK            (0x4U)
#define DMA_COMMON_INTENCLR_CLR2_SHIFT           (2U)
/*! CLR2 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR2(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR2_SHIFT)) & DMA_COMMON_INTENCLR_CLR2_MASK)
#define DMA_COMMON_INTENCLR_CLR3_MASK            (0x8U)
#define DMA_COMMON_INTENCLR_CLR3_SHIFT           (3U)
/*! CLR3 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR3(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR3_SHIFT)) & DMA_COMMON_INTENCLR_CLR3_MASK)
#define DMA_COMMON_INTENCLR_CLR4_MASK            (0x10U)
#define DMA_COMMON_INTENCLR_CLR4_SHIFT           (4U)
/*! CLR4 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR4(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR4_SHIFT)) & DMA_COMMON_INTENCLR_CLR4_MASK)
#define DMA_COMMON_INTENCLR_CLR5_MASK            (0x20U)
#define DMA_COMMON_INTENCLR_CLR5_SHIFT           (5U)
/*! CLR5 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR5(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR5_SHIFT)) & DMA_COMMON_INTENCLR_CLR5_MASK)
#define DMA_COMMON_INTENCLR_CLR6_MASK            (0x40U)
#define DMA_COMMON_INTENCLR_CLR6_SHIFT           (6U)
/*! CLR6 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR6(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR6_SHIFT)) & DMA_COMMON_INTENCLR_CLR6_MASK)
#define DMA_COMMON_INTENCLR_CLR7_MASK            (0x80U)
#define DMA_COMMON_INTENCLR_CLR7_SHIFT           (7U)
/*! CLR7 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR7(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR7_SHIFT)) & DMA_COMMON_INTENCLR_CLR7_MASK)
#define DMA_COMMON_INTENCLR_CLR8_MASK            (0x100U)
#define DMA_COMMON_INTENCLR_CLR8_SHIFT           (8U)
/*! CLR8 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR8(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR8_SHIFT)) & DMA_COMMON_INTENCLR_CLR8_MASK)
#define DMA_COMMON_INTENCLR_CLR9_MASK            (0x200U)
#define DMA_COMMON_INTENCLR_CLR9_SHIFT           (9U)
/*! CLR9 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR9(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR9_SHIFT)) & DMA_COMMON_INTENCLR_CLR9_MASK)
#define DMA_COMMON_INTENCLR_CLR10_MASK           (0x400U)
#define DMA_COMMON_INTENCLR_CLR10_SHIFT          (10U)
/*! CLR10 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR10(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR10_SHIFT)) & DMA_COMMON_INTENCLR_CLR10_MASK)
#define DMA_COMMON_INTENCLR_CLR11_MASK           (0x800U)
#define DMA_COMMON_INTENCLR_CLR11_SHIFT          (11U)
/*! CLR11 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR11(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR11_SHIFT)) & DMA_COMMON_INTENCLR_CLR11_MASK)
#define DMA_COMMON_INTENCLR_CLR12_MASK           (0x1000U)
#define DMA_COMMON_INTENCLR_CLR12_SHIFT          (12U)
/*! CLR12 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR12(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR12_SHIFT)) & DMA_COMMON_INTENCLR_CLR12_MASK)
#define DMA_COMMON_INTENCLR_CLR13_MASK           (0x2000U)
#define DMA_COMMON_INTENCLR_CLR13_SHIFT          (13U)
/*! CLR13 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR13(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR13_SHIFT)) & DMA_COMMON_INTENCLR_CLR13_MASK)
#define DMA_COMMON_INTENCLR_CLR14_MASK           (0x4000U)
#define DMA_COMMON_INTENCLR_CLR14_SHIFT          (14U)
/*! CLR14 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR14(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR14_SHIFT)) & DMA_COMMON_INTENCLR_CLR14_MASK)
#define DMA_COMMON_INTENCLR_CLR15_MASK           (0x8000U)
#define DMA_COMMON_INTENCLR_CLR15_SHIFT          (15U)
/*! CLR15 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR15(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR15_SHIFT)) & DMA_COMMON_INTENCLR_CLR15_MASK)
#define DMA_COMMON_INTENCLR_CLR16_MASK           (0x10000U)
#define DMA_COMMON_INTENCLR_CLR16_SHIFT          (16U)
/*! CLR16 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR16(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR16_SHIFT)) & DMA_COMMON_INTENCLR_CLR16_MASK)
#define DMA_COMMON_INTENCLR_CLR17_MASK           (0x20000U)
#define DMA_COMMON_INTENCLR_CLR17_SHIFT          (17U)
/*! CLR17 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR17(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR17_SHIFT)) & DMA_COMMON_INTENCLR_CLR17_MASK)
#define DMA_COMMON_INTENCLR_CLR18_MASK           (0x40000U)
#define DMA_COMMON_INTENCLR_CLR18_SHIFT          (18U)
/*! CLR18 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR18(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR18_SHIFT)) & DMA_COMMON_INTENCLR_CLR18_MASK)
#define DMA_COMMON_INTENCLR_CLR19_MASK           (0x80000U)
#define DMA_COMMON_INTENCLR_CLR19_SHIFT          (19U)
/*! CLR19 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR19(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR19_SHIFT)) & DMA_COMMON_INTENCLR_CLR19_MASK)
#define DMA_COMMON_INTENCLR_CLR20_MASK           (0x100000U)
#define DMA_COMMON_INTENCLR_CLR20_SHIFT          (20U)
/*! CLR20 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR20(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR20_SHIFT)) & DMA_COMMON_INTENCLR_CLR20_MASK)
#define DMA_COMMON_INTENCLR_CLR21_MASK           (0x200000U)
#define DMA_COMMON_INTENCLR_CLR21_SHIFT          (21U)
/*! CLR21 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR21(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR21_SHIFT)) & DMA_COMMON_INTENCLR_CLR21_MASK)
#define DMA_COMMON_INTENCLR_CLR22_MASK           (0x400000U)
#define DMA_COMMON_INTENCLR_CLR22_SHIFT          (22U)
/*! CLR22 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR22(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR22_SHIFT)) & DMA_COMMON_INTENCLR_CLR22_MASK)
#define DMA_COMMON_INTENCLR_CLR23_MASK           (0x800000U)
#define DMA_COMMON_INTENCLR_CLR23_SHIFT          (23U)
/*! CLR23 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR23(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR23_SHIFT)) & DMA_COMMON_INTENCLR_CLR23_MASK)
#define DMA_COMMON_INTENCLR_CLR24_MASK           (0x1000000U)
#define DMA_COMMON_INTENCLR_CLR24_SHIFT          (24U)
/*! CLR24 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR24(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR24_SHIFT)) & DMA_COMMON_INTENCLR_CLR24_MASK)
#define DMA_COMMON_INTENCLR_CLR25_MASK           (0x2000000U)
#define DMA_COMMON_INTENCLR_CLR25_SHIFT          (25U)
/*! CLR25 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR25(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR25_SHIFT)) & DMA_COMMON_INTENCLR_CLR25_MASK)
#define DMA_COMMON_INTENCLR_CLR26_MASK           (0x4000000U)
#define DMA_COMMON_INTENCLR_CLR26_SHIFT          (26U)
/*! CLR26 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR26(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR26_SHIFT)) & DMA_COMMON_INTENCLR_CLR26_MASK)
#define DMA_COMMON_INTENCLR_CLR27_MASK           (0x8000000U)
#define DMA_COMMON_INTENCLR_CLR27_SHIFT          (27U)
/*! CLR27 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR27(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR27_SHIFT)) & DMA_COMMON_INTENCLR_CLR27_MASK)
#define DMA_COMMON_INTENCLR_CLR28_MASK           (0x10000000U)
#define DMA_COMMON_INTENCLR_CLR28_SHIFT          (28U)
/*! CLR28 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR28(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR28_SHIFT)) & DMA_COMMON_INTENCLR_CLR28_MASK)
#define DMA_COMMON_INTENCLR_CLR29_MASK           (0x20000000U)
#define DMA_COMMON_INTENCLR_CLR29_SHIFT          (29U)
/*! CLR29 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR29(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR29_SHIFT)) & DMA_COMMON_INTENCLR_CLR29_MASK)
#define DMA_COMMON_INTENCLR_CLR30_MASK           (0x40000000U)
#define DMA_COMMON_INTENCLR_CLR30_SHIFT          (30U)
/*! CLR30 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR30(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR30_SHIFT)) & DMA_COMMON_INTENCLR_CLR30_MASK)
#define DMA_COMMON_INTENCLR_CLR31_MASK           (0x80000000U)
#define DMA_COMMON_INTENCLR_CLR31_SHIFT          (31U)
/*! CLR31 - Writing ones to this register clears corresponding bits in the DMAIntEnSet0.
 */
#define DMA_COMMON_INTENCLR_CLR31(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR_CLR31_SHIFT)) & DMA_COMMON_INTENCLR_CLR31_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENCLR */
#define DMA_COMMON_INTENCLR_COUNT                (1U)

/*! @name COMMON_INTENCLR1 - Interrupt Enable Clear for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTENCLR1_CLR32_MASK          (0x1U)
#define DMA_COMMON_INTENCLR1_CLR32_SHIFT         (0U)
/*! CLR32 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR32(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR32_SHIFT)) & DMA_COMMON_INTENCLR1_CLR32_MASK)
#define DMA_COMMON_INTENCLR1_CLR33_MASK          (0x2U)
#define DMA_COMMON_INTENCLR1_CLR33_SHIFT         (1U)
/*! CLR33 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR33(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR33_SHIFT)) & DMA_COMMON_INTENCLR1_CLR33_MASK)
#define DMA_COMMON_INTENCLR1_CLR34_MASK          (0x4U)
#define DMA_COMMON_INTENCLR1_CLR34_SHIFT         (2U)
/*! CLR34 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR34(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR34_SHIFT)) & DMA_COMMON_INTENCLR1_CLR34_MASK)
#define DMA_COMMON_INTENCLR1_CLR35_MASK          (0x8U)
#define DMA_COMMON_INTENCLR1_CLR35_SHIFT         (3U)
/*! CLR35 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR35(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR35_SHIFT)) & DMA_COMMON_INTENCLR1_CLR35_MASK)
#define DMA_COMMON_INTENCLR1_CLR36_MASK          (0x10U)
#define DMA_COMMON_INTENCLR1_CLR36_SHIFT         (4U)
/*! CLR36 - Writing ones to this register clears corresponding bits in the DMAIntEnSet1.
 */
#define DMA_COMMON_INTENCLR1_CLR36(x)            (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTENCLR1_CLR36_SHIFT)) & DMA_COMMON_INTENCLR1_CLR36_MASK)
/*! @} */

/* The count of DMA_COMMON_INTENCLR1 */
#define DMA_COMMON_INTENCLR1_COUNT               (1U)

/*! @name COMMON_INTA - Interrupt A status for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTA_INTA0_MASK               (0x1U)
#define DMA_COMMON_INTA_INTA0_SHIFT              (0U)
/*! INTA0 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA0(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA0_SHIFT)) & DMA_COMMON_INTA_INTA0_MASK)
#define DMA_COMMON_INTA_INTA1_MASK               (0x2U)
#define DMA_COMMON_INTA_INTA1_SHIFT              (1U)
/*! INTA1 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA1(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA1_SHIFT)) & DMA_COMMON_INTA_INTA1_MASK)
#define DMA_COMMON_INTA_INTA2_MASK               (0x4U)
#define DMA_COMMON_INTA_INTA2_SHIFT              (2U)
/*! INTA2 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA2(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA2_SHIFT)) & DMA_COMMON_INTA_INTA2_MASK)
#define DMA_COMMON_INTA_INTA3_MASK               (0x8U)
#define DMA_COMMON_INTA_INTA3_SHIFT              (3U)
/*! INTA3 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA3(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA3_SHIFT)) & DMA_COMMON_INTA_INTA3_MASK)
#define DMA_COMMON_INTA_INTA4_MASK               (0x10U)
#define DMA_COMMON_INTA_INTA4_SHIFT              (4U)
/*! INTA4 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA4(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA4_SHIFT)) & DMA_COMMON_INTA_INTA4_MASK)
#define DMA_COMMON_INTA_INTA5_MASK               (0x20U)
#define DMA_COMMON_INTA_INTA5_SHIFT              (5U)
/*! INTA5 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA5(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA5_SHIFT)) & DMA_COMMON_INTA_INTA5_MASK)
#define DMA_COMMON_INTA_INTA6_MASK               (0x40U)
#define DMA_COMMON_INTA_INTA6_SHIFT              (6U)
/*! INTA6 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA6(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA6_SHIFT)) & DMA_COMMON_INTA_INTA6_MASK)
#define DMA_COMMON_INTA_INTA7_MASK               (0x80U)
#define DMA_COMMON_INTA_INTA7_SHIFT              (7U)
/*! INTA7 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA7(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA7_SHIFT)) & DMA_COMMON_INTA_INTA7_MASK)
#define DMA_COMMON_INTA_INTA8_MASK               (0x100U)
#define DMA_COMMON_INTA_INTA8_SHIFT              (8U)
/*! INTA8 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA8(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA8_SHIFT)) & DMA_COMMON_INTA_INTA8_MASK)
#define DMA_COMMON_INTA_INTA9_MASK               (0x200U)
#define DMA_COMMON_INTA_INTA9_SHIFT              (9U)
/*! INTA9 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA9(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA9_SHIFT)) & DMA_COMMON_INTA_INTA9_MASK)
#define DMA_COMMON_INTA_INTA10_MASK              (0x400U)
#define DMA_COMMON_INTA_INTA10_SHIFT             (10U)
/*! INTA10 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA10(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA10_SHIFT)) & DMA_COMMON_INTA_INTA10_MASK)
#define DMA_COMMON_INTA_INTA11_MASK              (0x800U)
#define DMA_COMMON_INTA_INTA11_SHIFT             (11U)
/*! INTA11 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA11(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA11_SHIFT)) & DMA_COMMON_INTA_INTA11_MASK)
#define DMA_COMMON_INTA_INTA12_MASK              (0x1000U)
#define DMA_COMMON_INTA_INTA12_SHIFT             (12U)
/*! INTA12 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA12(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA12_SHIFT)) & DMA_COMMON_INTA_INTA12_MASK)
#define DMA_COMMON_INTA_INTA13_MASK              (0x2000U)
#define DMA_COMMON_INTA_INTA13_SHIFT             (13U)
/*! INTA13 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA13(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA13_SHIFT)) & DMA_COMMON_INTA_INTA13_MASK)
#define DMA_COMMON_INTA_INTA14_MASK              (0x4000U)
#define DMA_COMMON_INTA_INTA14_SHIFT             (14U)
/*! INTA14 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA14(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA14_SHIFT)) & DMA_COMMON_INTA_INTA14_MASK)
#define DMA_COMMON_INTA_INTA15_MASK              (0x8000U)
#define DMA_COMMON_INTA_INTA15_SHIFT             (15U)
/*! INTA15 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA15(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA15_SHIFT)) & DMA_COMMON_INTA_INTA15_MASK)
#define DMA_COMMON_INTA_INTA16_MASK              (0x10000U)
#define DMA_COMMON_INTA_INTA16_SHIFT             (16U)
/*! INTA16 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA16(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA16_SHIFT)) & DMA_COMMON_INTA_INTA16_MASK)
#define DMA_COMMON_INTA_INTA17_MASK              (0x20000U)
#define DMA_COMMON_INTA_INTA17_SHIFT             (17U)
/*! INTA17 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA17(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA17_SHIFT)) & DMA_COMMON_INTA_INTA17_MASK)
#define DMA_COMMON_INTA_INTA18_MASK              (0x40000U)
#define DMA_COMMON_INTA_INTA18_SHIFT             (18U)
/*! INTA18 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA18(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA18_SHIFT)) & DMA_COMMON_INTA_INTA18_MASK)
#define DMA_COMMON_INTA_INTA19_MASK              (0x80000U)
#define DMA_COMMON_INTA_INTA19_SHIFT             (19U)
/*! INTA19 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA19(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA19_SHIFT)) & DMA_COMMON_INTA_INTA19_MASK)
#define DMA_COMMON_INTA_INTA20_MASK              (0x100000U)
#define DMA_COMMON_INTA_INTA20_SHIFT             (20U)
/*! INTA20 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA20(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA20_SHIFT)) & DMA_COMMON_INTA_INTA20_MASK)
#define DMA_COMMON_INTA_INTA21_MASK              (0x200000U)
#define DMA_COMMON_INTA_INTA21_SHIFT             (21U)
/*! INTA21 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA21(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA21_SHIFT)) & DMA_COMMON_INTA_INTA21_MASK)
#define DMA_COMMON_INTA_INTA22_MASK              (0x400000U)
#define DMA_COMMON_INTA_INTA22_SHIFT             (22U)
/*! INTA22 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA22(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA22_SHIFT)) & DMA_COMMON_INTA_INTA22_MASK)
#define DMA_COMMON_INTA_INTA23_MASK              (0x800000U)
#define DMA_COMMON_INTA_INTA23_SHIFT             (23U)
/*! INTA23 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA23(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA23_SHIFT)) & DMA_COMMON_INTA_INTA23_MASK)
#define DMA_COMMON_INTA_INTA24_MASK              (0x1000000U)
#define DMA_COMMON_INTA_INTA24_SHIFT             (24U)
/*! INTA24 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA24(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA24_SHIFT)) & DMA_COMMON_INTA_INTA24_MASK)
#define DMA_COMMON_INTA_INTA25_MASK              (0x2000000U)
#define DMA_COMMON_INTA_INTA25_SHIFT             (25U)
/*! INTA25 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA25(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA25_SHIFT)) & DMA_COMMON_INTA_INTA25_MASK)
#define DMA_COMMON_INTA_INTA26_MASK              (0x4000000U)
#define DMA_COMMON_INTA_INTA26_SHIFT             (26U)
/*! INTA26 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA26(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA26_SHIFT)) & DMA_COMMON_INTA_INTA26_MASK)
#define DMA_COMMON_INTA_INTA27_MASK              (0x8000000U)
#define DMA_COMMON_INTA_INTA27_SHIFT             (27U)
/*! INTA27 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA27(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA27_SHIFT)) & DMA_COMMON_INTA_INTA27_MASK)
#define DMA_COMMON_INTA_INTA28_MASK              (0x10000000U)
#define DMA_COMMON_INTA_INTA28_SHIFT             (28U)
/*! INTA28 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA28(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA28_SHIFT)) & DMA_COMMON_INTA_INTA28_MASK)
#define DMA_COMMON_INTA_INTA29_MASK              (0x20000000U)
#define DMA_COMMON_INTA_INTA29_SHIFT             (29U)
/*! INTA29 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA29(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA29_SHIFT)) & DMA_COMMON_INTA_INTA29_MASK)
#define DMA_COMMON_INTA_INTA30_MASK              (0x40000000U)
#define DMA_COMMON_INTA_INTA30_SHIFT             (30U)
/*! INTA30 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA30(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA30_SHIFT)) & DMA_COMMON_INTA_INTA30_MASK)
#define DMA_COMMON_INTA_INTA31_MASK              (0x80000000U)
#define DMA_COMMON_INTA_INTA31_SHIFT             (31U)
/*! INTA31 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA_INTA31(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA_INTA31_SHIFT)) & DMA_COMMON_INTA_INTA31_MASK)
/*! @} */

/* The count of DMA_COMMON_INTA */
#define DMA_COMMON_INTA_COUNT                    (1U)

/*! @name COMMON_INTA1 - Interrupt A status for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTA1_INTA32_MASK             (0x1U)
#define DMA_COMMON_INTA1_INTA32_SHIFT            (0U)
/*! INTA32 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA32(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA32_SHIFT)) & DMA_COMMON_INTA1_INTA32_MASK)
#define DMA_COMMON_INTA1_INTA33_MASK             (0x2U)
#define DMA_COMMON_INTA1_INTA33_SHIFT            (1U)
/*! INTA33 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA33(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA33_SHIFT)) & DMA_COMMON_INTA1_INTA33_MASK)
#define DMA_COMMON_INTA1_INTA34_MASK             (0x4U)
#define DMA_COMMON_INTA1_INTA34_SHIFT            (2U)
/*! INTA34 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA34(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA34_SHIFT)) & DMA_COMMON_INTA1_INTA34_MASK)
#define DMA_COMMON_INTA1_INTA35_MASK             (0x8U)
#define DMA_COMMON_INTA1_INTA35_SHIFT            (3U)
/*! INTA35 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA35(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA35_SHIFT)) & DMA_COMMON_INTA1_INTA35_MASK)
#define DMA_COMMON_INTA1_INTA36_MASK             (0x10U)
#define DMA_COMMON_INTA1_INTA36_SHIFT            (4U)
/*! INTA36 - Interrupt A status for DMA channel.
 *  0b0..The DMA channel interrupt A is not active.
 *  0b1..The DMA channel interrupt A is active.
 */
#define DMA_COMMON_INTA1_INTA36(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTA1_INTA36_SHIFT)) & DMA_COMMON_INTA1_INTA36_MASK)
/*! @} */

/* The count of DMA_COMMON_INTA1 */
#define DMA_COMMON_INTA1_COUNT                   (1U)

/*! @name COMMON_INTB - Interrupt B status for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTB_INTB0_MASK               (0x1U)
#define DMA_COMMON_INTB_INTB0_SHIFT              (0U)
/*! INTB0 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB0(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB0_SHIFT)) & DMA_COMMON_INTB_INTB0_MASK)
#define DMA_COMMON_INTB_INTB1_MASK               (0x2U)
#define DMA_COMMON_INTB_INTB1_SHIFT              (1U)
/*! INTB1 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB1(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB1_SHIFT)) & DMA_COMMON_INTB_INTB1_MASK)
#define DMA_COMMON_INTB_INTB2_MASK               (0x4U)
#define DMA_COMMON_INTB_INTB2_SHIFT              (2U)
/*! INTB2 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB2(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB2_SHIFT)) & DMA_COMMON_INTB_INTB2_MASK)
#define DMA_COMMON_INTB_INTB3_MASK               (0x8U)
#define DMA_COMMON_INTB_INTB3_SHIFT              (3U)
/*! INTB3 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB3(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB3_SHIFT)) & DMA_COMMON_INTB_INTB3_MASK)
#define DMA_COMMON_INTB_INTB4_MASK               (0x10U)
#define DMA_COMMON_INTB_INTB4_SHIFT              (4U)
/*! INTB4 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB4(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB4_SHIFT)) & DMA_COMMON_INTB_INTB4_MASK)
#define DMA_COMMON_INTB_INTB5_MASK               (0x20U)
#define DMA_COMMON_INTB_INTB5_SHIFT              (5U)
/*! INTB5 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB5(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB5_SHIFT)) & DMA_COMMON_INTB_INTB5_MASK)
#define DMA_COMMON_INTB_INTB6_MASK               (0x40U)
#define DMA_COMMON_INTB_INTB6_SHIFT              (6U)
/*! INTB6 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB6(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB6_SHIFT)) & DMA_COMMON_INTB_INTB6_MASK)
#define DMA_COMMON_INTB_INTB7_MASK               (0x80U)
#define DMA_COMMON_INTB_INTB7_SHIFT              (7U)
/*! INTB7 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB7(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB7_SHIFT)) & DMA_COMMON_INTB_INTB7_MASK)
#define DMA_COMMON_INTB_INTB8_MASK               (0x100U)
#define DMA_COMMON_INTB_INTB8_SHIFT              (8U)
/*! INTB8 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB8(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB8_SHIFT)) & DMA_COMMON_INTB_INTB8_MASK)
#define DMA_COMMON_INTB_INTB9_MASK               (0x200U)
#define DMA_COMMON_INTB_INTB9_SHIFT              (9U)
/*! INTB9 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB9(x)                 (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB9_SHIFT)) & DMA_COMMON_INTB_INTB9_MASK)
#define DMA_COMMON_INTB_INTB10_MASK              (0x400U)
#define DMA_COMMON_INTB_INTB10_SHIFT             (10U)
/*! INTB10 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB10(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB10_SHIFT)) & DMA_COMMON_INTB_INTB10_MASK)
#define DMA_COMMON_INTB_INTB11_MASK              (0x800U)
#define DMA_COMMON_INTB_INTB11_SHIFT             (11U)
/*! INTB11 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB11(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB11_SHIFT)) & DMA_COMMON_INTB_INTB11_MASK)
#define DMA_COMMON_INTB_INTB12_MASK              (0x1000U)
#define DMA_COMMON_INTB_INTB12_SHIFT             (12U)
/*! INTB12 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB12(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB12_SHIFT)) & DMA_COMMON_INTB_INTB12_MASK)
#define DMA_COMMON_INTB_INTB13_MASK              (0x2000U)
#define DMA_COMMON_INTB_INTB13_SHIFT             (13U)
/*! INTB13 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB13(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB13_SHIFT)) & DMA_COMMON_INTB_INTB13_MASK)
#define DMA_COMMON_INTB_INTB14_MASK              (0x4000U)
#define DMA_COMMON_INTB_INTB14_SHIFT             (14U)
/*! INTB14 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB14(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB14_SHIFT)) & DMA_COMMON_INTB_INTB14_MASK)
#define DMA_COMMON_INTB_INTB15_MASK              (0x8000U)
#define DMA_COMMON_INTB_INTB15_SHIFT             (15U)
/*! INTB15 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB15(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB15_SHIFT)) & DMA_COMMON_INTB_INTB15_MASK)
#define DMA_COMMON_INTB_INTB16_MASK              (0x10000U)
#define DMA_COMMON_INTB_INTB16_SHIFT             (16U)
/*! INTB16 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB16(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB16_SHIFT)) & DMA_COMMON_INTB_INTB16_MASK)
#define DMA_COMMON_INTB_INTB17_MASK              (0x20000U)
#define DMA_COMMON_INTB_INTB17_SHIFT             (17U)
/*! INTB17 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB17(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB17_SHIFT)) & DMA_COMMON_INTB_INTB17_MASK)
#define DMA_COMMON_INTB_INTB18_MASK              (0x40000U)
#define DMA_COMMON_INTB_INTB18_SHIFT             (18U)
/*! INTB18 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB18(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB18_SHIFT)) & DMA_COMMON_INTB_INTB18_MASK)
#define DMA_COMMON_INTB_INTB19_MASK              (0x80000U)
#define DMA_COMMON_INTB_INTB19_SHIFT             (19U)
/*! INTB19 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB19(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB19_SHIFT)) & DMA_COMMON_INTB_INTB19_MASK)
#define DMA_COMMON_INTB_INTB20_MASK              (0x100000U)
#define DMA_COMMON_INTB_INTB20_SHIFT             (20U)
/*! INTB20 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB20(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB20_SHIFT)) & DMA_COMMON_INTB_INTB20_MASK)
#define DMA_COMMON_INTB_INTB21_MASK              (0x200000U)
#define DMA_COMMON_INTB_INTB21_SHIFT             (21U)
/*! INTB21 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB21(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB21_SHIFT)) & DMA_COMMON_INTB_INTB21_MASK)
#define DMA_COMMON_INTB_INTB22_MASK              (0x400000U)
#define DMA_COMMON_INTB_INTB22_SHIFT             (22U)
/*! INTB22 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB22(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB22_SHIFT)) & DMA_COMMON_INTB_INTB22_MASK)
#define DMA_COMMON_INTB_INTB23_MASK              (0x800000U)
#define DMA_COMMON_INTB_INTB23_SHIFT             (23U)
/*! INTB23 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB23(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB23_SHIFT)) & DMA_COMMON_INTB_INTB23_MASK)
#define DMA_COMMON_INTB_INTB24_MASK              (0x1000000U)
#define DMA_COMMON_INTB_INTB24_SHIFT             (24U)
/*! INTB24 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB24(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB24_SHIFT)) & DMA_COMMON_INTB_INTB24_MASK)
#define DMA_COMMON_INTB_INTB25_MASK              (0x2000000U)
#define DMA_COMMON_INTB_INTB25_SHIFT             (25U)
/*! INTB25 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB25(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB25_SHIFT)) & DMA_COMMON_INTB_INTB25_MASK)
#define DMA_COMMON_INTB_INTB26_MASK              (0x4000000U)
#define DMA_COMMON_INTB_INTB26_SHIFT             (26U)
/*! INTB26 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB26(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB26_SHIFT)) & DMA_COMMON_INTB_INTB26_MASK)
#define DMA_COMMON_INTB_INTB27_MASK              (0x8000000U)
#define DMA_COMMON_INTB_INTB27_SHIFT             (27U)
/*! INTB27 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB27(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB27_SHIFT)) & DMA_COMMON_INTB_INTB27_MASK)
#define DMA_COMMON_INTB_INTB28_MASK              (0x10000000U)
#define DMA_COMMON_INTB_INTB28_SHIFT             (28U)
/*! INTB28 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB28(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB28_SHIFT)) & DMA_COMMON_INTB_INTB28_MASK)
#define DMA_COMMON_INTB_INTB29_MASK              (0x20000000U)
#define DMA_COMMON_INTB_INTB29_SHIFT             (29U)
/*! INTB29 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB29(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB29_SHIFT)) & DMA_COMMON_INTB_INTB29_MASK)
#define DMA_COMMON_INTB_INTB30_MASK              (0x40000000U)
#define DMA_COMMON_INTB_INTB30_SHIFT             (30U)
/*! INTB30 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB30(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB30_SHIFT)) & DMA_COMMON_INTB_INTB30_MASK)
#define DMA_COMMON_INTB_INTB31_MASK              (0x80000000U)
#define DMA_COMMON_INTB_INTB31_SHIFT             (31U)
/*! INTB31 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB_INTB31(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB_INTB31_SHIFT)) & DMA_COMMON_INTB_INTB31_MASK)
/*! @} */

/* The count of DMA_COMMON_INTB */
#define DMA_COMMON_INTB_COUNT                    (1U)

/*! @name COMMON_INTB1 - Interrupt B status for all DMA channels */
/*! @{ */
#define DMA_COMMON_INTB1_INTB0_MASK              (0x1U)
#define DMA_COMMON_INTB1_INTB0_SHIFT             (0U)
/*! INTB0 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB0(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB0_SHIFT)) & DMA_COMMON_INTB1_INTB0_MASK)
#define DMA_COMMON_INTB1_INTB1_MASK              (0x2U)
#define DMA_COMMON_INTB1_INTB1_SHIFT             (1U)
/*! INTB1 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB1(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB1_SHIFT)) & DMA_COMMON_INTB1_INTB1_MASK)
#define DMA_COMMON_INTB1_INTB2_MASK              (0x4U)
#define DMA_COMMON_INTB1_INTB2_SHIFT             (2U)
/*! INTB2 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB2(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB2_SHIFT)) & DMA_COMMON_INTB1_INTB2_MASK)
#define DMA_COMMON_INTB1_INTB3_MASK              (0x8U)
#define DMA_COMMON_INTB1_INTB3_SHIFT             (3U)
/*! INTB3 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB3(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB3_SHIFT)) & DMA_COMMON_INTB1_INTB3_MASK)
#define DMA_COMMON_INTB1_INTB4_MASK              (0x10U)
#define DMA_COMMON_INTB1_INTB4_SHIFT             (4U)
/*! INTB4 - Interrupt B status for DMA channel.
 *  0b0..The DMA channel interrupt B is not active.
 *  0b1..The DMA channel interrupt B is active.
 */
#define DMA_COMMON_INTB1_INTB4(x)                (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_INTB1_INTB4_SHIFT)) & DMA_COMMON_INTB1_INTB4_MASK)
/*! @} */

/* The count of DMA_COMMON_INTB1 */
#define DMA_COMMON_INTB1_COUNT                   (1U)

/*! @name COMMON_SETVALID - Set ValidPending control bits for all DMA channels */
/*! @{ */
#define DMA_COMMON_SETVALID_SETVALID0_MASK       (0x1U)
#define DMA_COMMON_SETVALID_SETVALID0_SHIFT      (0U)
/*! SETVALID0 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID0(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID0_SHIFT)) & DMA_COMMON_SETVALID_SETVALID0_MASK)
#define DMA_COMMON_SETVALID_SETVALID1_MASK       (0x2U)
#define DMA_COMMON_SETVALID_SETVALID1_SHIFT      (1U)
/*! SETVALID1 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID1(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID1_SHIFT)) & DMA_COMMON_SETVALID_SETVALID1_MASK)
#define DMA_COMMON_SETVALID_SETVALID2_MASK       (0x4U)
#define DMA_COMMON_SETVALID_SETVALID2_SHIFT      (2U)
/*! SETVALID2 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID2(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID2_SHIFT)) & DMA_COMMON_SETVALID_SETVALID2_MASK)
#define DMA_COMMON_SETVALID_SETVALID3_MASK       (0x8U)
#define DMA_COMMON_SETVALID_SETVALID3_SHIFT      (3U)
/*! SETVALID3 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID3(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID3_SHIFT)) & DMA_COMMON_SETVALID_SETVALID3_MASK)
#define DMA_COMMON_SETVALID_SETVALID4_MASK       (0x10U)
#define DMA_COMMON_SETVALID_SETVALID4_SHIFT      (4U)
/*! SETVALID4 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID4(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID4_SHIFT)) & DMA_COMMON_SETVALID_SETVALID4_MASK)
#define DMA_COMMON_SETVALID_SETVALID5_MASK       (0x20U)
#define DMA_COMMON_SETVALID_SETVALID5_SHIFT      (5U)
/*! SETVALID5 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID5(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID5_SHIFT)) & DMA_COMMON_SETVALID_SETVALID5_MASK)
#define DMA_COMMON_SETVALID_SETVALID6_MASK       (0x40U)
#define DMA_COMMON_SETVALID_SETVALID6_SHIFT      (6U)
/*! SETVALID6 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID6(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID6_SHIFT)) & DMA_COMMON_SETVALID_SETVALID6_MASK)
#define DMA_COMMON_SETVALID_SETVALID7_MASK       (0x80U)
#define DMA_COMMON_SETVALID_SETVALID7_SHIFT      (7U)
/*! SETVALID7 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID7(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID7_SHIFT)) & DMA_COMMON_SETVALID_SETVALID7_MASK)
#define DMA_COMMON_SETVALID_SETVALID8_MASK       (0x100U)
#define DMA_COMMON_SETVALID_SETVALID8_SHIFT      (8U)
/*! SETVALID8 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID8(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID8_SHIFT)) & DMA_COMMON_SETVALID_SETVALID8_MASK)
#define DMA_COMMON_SETVALID_SETVALID9_MASK       (0x200U)
#define DMA_COMMON_SETVALID_SETVALID9_SHIFT      (9U)
/*! SETVALID9 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID9(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID9_SHIFT)) & DMA_COMMON_SETVALID_SETVALID9_MASK)
#define DMA_COMMON_SETVALID_SETVALID10_MASK      (0x400U)
#define DMA_COMMON_SETVALID_SETVALID10_SHIFT     (10U)
/*! SETVALID10 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID10(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID10_SHIFT)) & DMA_COMMON_SETVALID_SETVALID10_MASK)
#define DMA_COMMON_SETVALID_SETVALID11_MASK      (0x800U)
#define DMA_COMMON_SETVALID_SETVALID11_SHIFT     (11U)
/*! SETVALID11 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID11(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID11_SHIFT)) & DMA_COMMON_SETVALID_SETVALID11_MASK)
#define DMA_COMMON_SETVALID_SETVALID12_MASK      (0x1000U)
#define DMA_COMMON_SETVALID_SETVALID12_SHIFT     (12U)
/*! SETVALID12 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID12(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID12_SHIFT)) & DMA_COMMON_SETVALID_SETVALID12_MASK)
#define DMA_COMMON_SETVALID_SETVALID13_MASK      (0x2000U)
#define DMA_COMMON_SETVALID_SETVALID13_SHIFT     (13U)
/*! SETVALID13 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID13(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID13_SHIFT)) & DMA_COMMON_SETVALID_SETVALID13_MASK)
#define DMA_COMMON_SETVALID_SETVALID14_MASK      (0x4000U)
#define DMA_COMMON_SETVALID_SETVALID14_SHIFT     (14U)
/*! SETVALID14 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID14(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID14_SHIFT)) & DMA_COMMON_SETVALID_SETVALID14_MASK)
#define DMA_COMMON_SETVALID_SETVALID15_MASK      (0x8000U)
#define DMA_COMMON_SETVALID_SETVALID15_SHIFT     (15U)
/*! SETVALID15 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID15(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID15_SHIFT)) & DMA_COMMON_SETVALID_SETVALID15_MASK)
#define DMA_COMMON_SETVALID_SETVALID16_MASK      (0x10000U)
#define DMA_COMMON_SETVALID_SETVALID16_SHIFT     (16U)
/*! SETVALID16 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID16(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID16_SHIFT)) & DMA_COMMON_SETVALID_SETVALID16_MASK)
#define DMA_COMMON_SETVALID_SETVALID17_MASK      (0x20000U)
#define DMA_COMMON_SETVALID_SETVALID17_SHIFT     (17U)
/*! SETVALID17 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID17(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID17_SHIFT)) & DMA_COMMON_SETVALID_SETVALID17_MASK)
#define DMA_COMMON_SETVALID_SETVALID18_MASK      (0x40000U)
#define DMA_COMMON_SETVALID_SETVALID18_SHIFT     (18U)
/*! SETVALID18 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID18(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID18_SHIFT)) & DMA_COMMON_SETVALID_SETVALID18_MASK)
#define DMA_COMMON_SETVALID_SETVALID19_MASK      (0x80000U)
#define DMA_COMMON_SETVALID_SETVALID19_SHIFT     (19U)
/*! SETVALID19 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID19(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID19_SHIFT)) & DMA_COMMON_SETVALID_SETVALID19_MASK)
#define DMA_COMMON_SETVALID_SETVALID20_MASK      (0x100000U)
#define DMA_COMMON_SETVALID_SETVALID20_SHIFT     (20U)
/*! SETVALID20 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID20(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID20_SHIFT)) & DMA_COMMON_SETVALID_SETVALID20_MASK)
#define DMA_COMMON_SETVALID_SETVALID21_MASK      (0x200000U)
#define DMA_COMMON_SETVALID_SETVALID21_SHIFT     (21U)
/*! SETVALID21 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID21(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID21_SHIFT)) & DMA_COMMON_SETVALID_SETVALID21_MASK)
#define DMA_COMMON_SETVALID_SETVALID22_MASK      (0x400000U)
#define DMA_COMMON_SETVALID_SETVALID22_SHIFT     (22U)
/*! SETVALID22 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID22(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID22_SHIFT)) & DMA_COMMON_SETVALID_SETVALID22_MASK)
#define DMA_COMMON_SETVALID_SETVALID23_MASK      (0x800000U)
#define DMA_COMMON_SETVALID_SETVALID23_SHIFT     (23U)
/*! SETVALID23 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID23(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID23_SHIFT)) & DMA_COMMON_SETVALID_SETVALID23_MASK)
#define DMA_COMMON_SETVALID_SETVALID24_MASK      (0x1000000U)
#define DMA_COMMON_SETVALID_SETVALID24_SHIFT     (24U)
/*! SETVALID24 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID24(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID24_SHIFT)) & DMA_COMMON_SETVALID_SETVALID24_MASK)
#define DMA_COMMON_SETVALID_SETVALID25_MASK      (0x2000000U)
#define DMA_COMMON_SETVALID_SETVALID25_SHIFT     (25U)
/*! SETVALID25 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID25(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID25_SHIFT)) & DMA_COMMON_SETVALID_SETVALID25_MASK)
#define DMA_COMMON_SETVALID_SETVALID26_MASK      (0x4000000U)
#define DMA_COMMON_SETVALID_SETVALID26_SHIFT     (26U)
/*! SETVALID26 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID26(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID26_SHIFT)) & DMA_COMMON_SETVALID_SETVALID26_MASK)
#define DMA_COMMON_SETVALID_SETVALID27_MASK      (0x8000000U)
#define DMA_COMMON_SETVALID_SETVALID27_SHIFT     (27U)
/*! SETVALID27 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID27(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID27_SHIFT)) & DMA_COMMON_SETVALID_SETVALID27_MASK)
#define DMA_COMMON_SETVALID_SETVALID28_MASK      (0x10000000U)
#define DMA_COMMON_SETVALID_SETVALID28_SHIFT     (28U)
/*! SETVALID28 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID28(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID28_SHIFT)) & DMA_COMMON_SETVALID_SETVALID28_MASK)
#define DMA_COMMON_SETVALID_SETVALID29_MASK      (0x20000000U)
#define DMA_COMMON_SETVALID_SETVALID29_SHIFT     (29U)
/*! SETVALID29 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID29(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID29_SHIFT)) & DMA_COMMON_SETVALID_SETVALID29_MASK)
#define DMA_COMMON_SETVALID_SETVALID30_MASK      (0x40000000U)
#define DMA_COMMON_SETVALID_SETVALID30_SHIFT     (30U)
/*! SETVALID30 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID30(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID30_SHIFT)) & DMA_COMMON_SETVALID_SETVALID30_MASK)
#define DMA_COMMON_SETVALID_SETVALID31_MASK      (0x80000000U)
#define DMA_COMMON_SETVALID_SETVALID31_SHIFT     (31U)
/*! SETVALID31 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID_SETVALID31(x)        (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID_SETVALID31_SHIFT)) & DMA_COMMON_SETVALID_SETVALID31_MASK)
/*! @} */

/* The count of DMA_COMMON_SETVALID */
#define DMA_COMMON_SETVALID_COUNT                (1U)

/*! @name COMMON_SETVALID1 - Set ValidPending control bits for all DMA channels */
/*! @{ */
#define DMA_COMMON_SETVALID1_SETVALID32_MASK     (0x1U)
#define DMA_COMMON_SETVALID1_SETVALID32_SHIFT    (0U)
/*! SETVALID32 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID32(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID32_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID32_MASK)
#define DMA_COMMON_SETVALID1_SETVALID33_MASK     (0x2U)
#define DMA_COMMON_SETVALID1_SETVALID33_SHIFT    (1U)
/*! SETVALID33 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID33(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID33_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID33_MASK)
#define DMA_COMMON_SETVALID1_SETVALID34_MASK     (0x4U)
#define DMA_COMMON_SETVALID1_SETVALID34_SHIFT    (2U)
/*! SETVALID34 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID34(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID34_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID34_MASK)
#define DMA_COMMON_SETVALID1_SETVALID35_MASK     (0x8U)
#define DMA_COMMON_SETVALID1_SETVALID35_SHIFT    (3U)
/*! SETVALID35 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID35(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID35_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID35_MASK)
#define DMA_COMMON_SETVALID1_SETVALID36_MASK     (0x10U)
#define DMA_COMMON_SETVALID1_SETVALID36_SHIFT    (4U)
/*! SETVALID36 - SetValid control for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the ValidPending control bit for DMA channel.
 */
#define DMA_COMMON_SETVALID1_SETVALID36(x)       (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETVALID1_SETVALID36_SHIFT)) & DMA_COMMON_SETVALID1_SETVALID36_MASK)
/*! @} */

/* The count of DMA_COMMON_SETVALID1 */
#define DMA_COMMON_SETVALID1_COUNT               (1U)

/*! @name COMMON_SETTRIG - Set Trigger control bits for all DMA channels */
/*! @{ */
#define DMA_COMMON_SETTRIG_SETTRIG0_MASK         (0x1U)
#define DMA_COMMON_SETTRIG_SETTRIG0_SHIFT        (0U)
/*! SETTRIG0 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG0(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG0_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG0_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG1_MASK         (0x2U)
#define DMA_COMMON_SETTRIG_SETTRIG1_SHIFT        (1U)
/*! SETTRIG1 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG1(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG1_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG1_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG2_MASK         (0x4U)
#define DMA_COMMON_SETTRIG_SETTRIG2_SHIFT        (2U)
/*! SETTRIG2 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG2(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG2_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG2_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG3_MASK         (0x8U)
#define DMA_COMMON_SETTRIG_SETTRIG3_SHIFT        (3U)
/*! SETTRIG3 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG3(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG3_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG3_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG4_MASK         (0x10U)
#define DMA_COMMON_SETTRIG_SETTRIG4_SHIFT        (4U)
/*! SETTRIG4 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG4(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG4_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG4_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG5_MASK         (0x20U)
#define DMA_COMMON_SETTRIG_SETTRIG5_SHIFT        (5U)
/*! SETTRIG5 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG5(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG5_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG5_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG6_MASK         (0x40U)
#define DMA_COMMON_SETTRIG_SETTRIG6_SHIFT        (6U)
/*! SETTRIG6 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG6(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG6_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG6_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG7_MASK         (0x80U)
#define DMA_COMMON_SETTRIG_SETTRIG7_SHIFT        (7U)
/*! SETTRIG7 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG7(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG7_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG7_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG8_MASK         (0x100U)
#define DMA_COMMON_SETTRIG_SETTRIG8_SHIFT        (8U)
/*! SETTRIG8 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG8(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG8_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG8_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG9_MASK         (0x200U)
#define DMA_COMMON_SETTRIG_SETTRIG9_SHIFT        (9U)
/*! SETTRIG9 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG9(x)           (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG9_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG9_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG10_MASK        (0x400U)
#define DMA_COMMON_SETTRIG_SETTRIG10_SHIFT       (10U)
/*! SETTRIG10 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG10(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG10_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG10_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG11_MASK        (0x800U)
#define DMA_COMMON_SETTRIG_SETTRIG11_SHIFT       (11U)
/*! SETTRIG11 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG11(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG11_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG11_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG12_MASK        (0x1000U)
#define DMA_COMMON_SETTRIG_SETTRIG12_SHIFT       (12U)
/*! SETTRIG12 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG12(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG12_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG12_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG13_MASK        (0x2000U)
#define DMA_COMMON_SETTRIG_SETTRIG13_SHIFT       (13U)
/*! SETTRIG13 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG13(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG13_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG13_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG14_MASK        (0x4000U)
#define DMA_COMMON_SETTRIG_SETTRIG14_SHIFT       (14U)
/*! SETTRIG14 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG14(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG14_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG14_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG15_MASK        (0x8000U)
#define DMA_COMMON_SETTRIG_SETTRIG15_SHIFT       (15U)
/*! SETTRIG15 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG15(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG15_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG15_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG16_MASK        (0x10000U)
#define DMA_COMMON_SETTRIG_SETTRIG16_SHIFT       (16U)
/*! SETTRIG16 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG16(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG16_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG16_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG17_MASK        (0x20000U)
#define DMA_COMMON_SETTRIG_SETTRIG17_SHIFT       (17U)
/*! SETTRIG17 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG17(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG17_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG17_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG18_MASK        (0x40000U)
#define DMA_COMMON_SETTRIG_SETTRIG18_SHIFT       (18U)
/*! SETTRIG18 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG18(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG18_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG18_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG19_MASK        (0x80000U)
#define DMA_COMMON_SETTRIG_SETTRIG19_SHIFT       (19U)
/*! SETTRIG19 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG19(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG19_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG19_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG20_MASK        (0x100000U)
#define DMA_COMMON_SETTRIG_SETTRIG20_SHIFT       (20U)
/*! SETTRIG20 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG20(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG20_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG20_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG21_MASK        (0x200000U)
#define DMA_COMMON_SETTRIG_SETTRIG21_SHIFT       (21U)
/*! SETTRIG21 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG21(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG21_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG21_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG22_MASK        (0x400000U)
#define DMA_COMMON_SETTRIG_SETTRIG22_SHIFT       (22U)
/*! SETTRIG22 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG22(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG22_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG22_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG23_MASK        (0x800000U)
#define DMA_COMMON_SETTRIG_SETTRIG23_SHIFT       (23U)
/*! SETTRIG23 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG23(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG23_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG23_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG24_MASK        (0x1000000U)
#define DMA_COMMON_SETTRIG_SETTRIG24_SHIFT       (24U)
/*! SETTRIG24 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG24(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG24_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG24_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG25_MASK        (0x2000000U)
#define DMA_COMMON_SETTRIG_SETTRIG25_SHIFT       (25U)
/*! SETTRIG25 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG25(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG25_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG25_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG26_MASK        (0x4000000U)
#define DMA_COMMON_SETTRIG_SETTRIG26_SHIFT       (26U)
/*! SETTRIG26 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG26(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG26_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG26_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG27_MASK        (0x8000000U)
#define DMA_COMMON_SETTRIG_SETTRIG27_SHIFT       (27U)
/*! SETTRIG27 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG27(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG27_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG27_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG28_MASK        (0x10000000U)
#define DMA_COMMON_SETTRIG_SETTRIG28_SHIFT       (28U)
/*! SETTRIG28 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG28(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG28_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG28_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG29_MASK        (0x20000000U)
#define DMA_COMMON_SETTRIG_SETTRIG29_SHIFT       (29U)
/*! SETTRIG29 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG29(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG29_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG29_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG30_MASK        (0x40000000U)
#define DMA_COMMON_SETTRIG_SETTRIG30_SHIFT       (30U)
/*! SETTRIG30 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG30(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG30_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG30_MASK)
#define DMA_COMMON_SETTRIG_SETTRIG31_MASK        (0x80000000U)
#define DMA_COMMON_SETTRIG_SETTRIG31_SHIFT       (31U)
/*! SETTRIG31 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG_SETTRIG31(x)          (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG_SETTRIG31_SHIFT)) & DMA_COMMON_SETTRIG_SETTRIG31_MASK)
/*! @} */

/* The count of DMA_COMMON_SETTRIG */
#define DMA_COMMON_SETTRIG_COUNT                 (1U)

/*! @name COMMON_SETTRIG1 - Set Trigger control bits for all DMA channels */
/*! @{ */
#define DMA_COMMON_SETTRIG1_SETTRIG32_MASK       (0x1U)
#define DMA_COMMON_SETTRIG1_SETTRIG32_SHIFT      (0U)
/*! SETTRIG32 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG32(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG32_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG32_MASK)
#define DMA_COMMON_SETTRIG1_SETTRIG33_MASK       (0x2U)
#define DMA_COMMON_SETTRIG1_SETTRIG33_SHIFT      (1U)
/*! SETTRIG33 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG33(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG33_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG33_MASK)
#define DMA_COMMON_SETTRIG1_SETTRIG34_MASK       (0x4U)
#define DMA_COMMON_SETTRIG1_SETTRIG34_SHIFT      (2U)
/*! SETTRIG34 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG34(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG34_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG34_MASK)
#define DMA_COMMON_SETTRIG1_SETTRIG35_MASK       (0x8U)
#define DMA_COMMON_SETTRIG1_SETTRIG35_SHIFT      (3U)
/*! SETTRIG35 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG35(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG35_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG35_MASK)
#define DMA_COMMON_SETTRIG1_SETTRIG36_MASK       (0x10U)
#define DMA_COMMON_SETTRIG1_SETTRIG36_SHIFT      (4U)
/*! SETTRIG36 - Set Trigger control bit for DMA channel.
 *  0b0..No effect.
 *  0b1..Sets the Trig bit for DMA channel.
 */
#define DMA_COMMON_SETTRIG1_SETTRIG36(x)         (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_SETTRIG1_SETTRIG36_SHIFT)) & DMA_COMMON_SETTRIG1_SETTRIG36_MASK)
/*! @} */

/* The count of DMA_COMMON_SETTRIG1 */
#define DMA_COMMON_SETTRIG1_COUNT                (1U)

/*! @name COMMON_ABORT - Channel Abort control for all DMA channels */
/*! @{ */
#define DMA_COMMON_ABORT_ABORT0_MASK             (0x1U)
#define DMA_COMMON_ABORT_ABORT0_SHIFT            (0U)
/*! ABORT0 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT0(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT0_SHIFT)) & DMA_COMMON_ABORT_ABORT0_MASK)
#define DMA_COMMON_ABORT_ABORT1_MASK             (0x2U)
#define DMA_COMMON_ABORT_ABORT1_SHIFT            (1U)
/*! ABORT1 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT1(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT1_SHIFT)) & DMA_COMMON_ABORT_ABORT1_MASK)
#define DMA_COMMON_ABORT_ABORT2_MASK             (0x4U)
#define DMA_COMMON_ABORT_ABORT2_SHIFT            (2U)
/*! ABORT2 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT2(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT2_SHIFT)) & DMA_COMMON_ABORT_ABORT2_MASK)
#define DMA_COMMON_ABORT_ABORT3_MASK             (0x8U)
#define DMA_COMMON_ABORT_ABORT3_SHIFT            (3U)
/*! ABORT3 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT3(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT3_SHIFT)) & DMA_COMMON_ABORT_ABORT3_MASK)
#define DMA_COMMON_ABORT_ABORT4_MASK             (0x10U)
#define DMA_COMMON_ABORT_ABORT4_SHIFT            (4U)
/*! ABORT4 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT4(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT4_SHIFT)) & DMA_COMMON_ABORT_ABORT4_MASK)
#define DMA_COMMON_ABORT_ABORT5_MASK             (0x20U)
#define DMA_COMMON_ABORT_ABORT5_SHIFT            (5U)
/*! ABORT5 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT5(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT5_SHIFT)) & DMA_COMMON_ABORT_ABORT5_MASK)
#define DMA_COMMON_ABORT_ABORT6_MASK             (0x40U)
#define DMA_COMMON_ABORT_ABORT6_SHIFT            (6U)
/*! ABORT6 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT6(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT6_SHIFT)) & DMA_COMMON_ABORT_ABORT6_MASK)
#define DMA_COMMON_ABORT_ABORT7_MASK             (0x80U)
#define DMA_COMMON_ABORT_ABORT7_SHIFT            (7U)
/*! ABORT7 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT7(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT7_SHIFT)) & DMA_COMMON_ABORT_ABORT7_MASK)
#define DMA_COMMON_ABORT_ABORT8_MASK             (0x100U)
#define DMA_COMMON_ABORT_ABORT8_SHIFT            (8U)
/*! ABORT8 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT8(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT8_SHIFT)) & DMA_COMMON_ABORT_ABORT8_MASK)
#define DMA_COMMON_ABORT_ABORT9_MASK             (0x200U)
#define DMA_COMMON_ABORT_ABORT9_SHIFT            (9U)
/*! ABORT9 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT9(x)               (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT9_SHIFT)) & DMA_COMMON_ABORT_ABORT9_MASK)
#define DMA_COMMON_ABORT_ABORT10_MASK            (0x400U)
#define DMA_COMMON_ABORT_ABORT10_SHIFT           (10U)
/*! ABORT10 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT10(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT10_SHIFT)) & DMA_COMMON_ABORT_ABORT10_MASK)
#define DMA_COMMON_ABORT_ABORT11_MASK            (0x800U)
#define DMA_COMMON_ABORT_ABORT11_SHIFT           (11U)
/*! ABORT11 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT11(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT11_SHIFT)) & DMA_COMMON_ABORT_ABORT11_MASK)
#define DMA_COMMON_ABORT_ABORT12_MASK            (0x1000U)
#define DMA_COMMON_ABORT_ABORT12_SHIFT           (12U)
/*! ABORT12 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT12(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT12_SHIFT)) & DMA_COMMON_ABORT_ABORT12_MASK)
#define DMA_COMMON_ABORT_ABORT13_MASK            (0x2000U)
#define DMA_COMMON_ABORT_ABORT13_SHIFT           (13U)
/*! ABORT13 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT13(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT13_SHIFT)) & DMA_COMMON_ABORT_ABORT13_MASK)
#define DMA_COMMON_ABORT_ABORT14_MASK            (0x4000U)
#define DMA_COMMON_ABORT_ABORT14_SHIFT           (14U)
/*! ABORT14 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT14(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT14_SHIFT)) & DMA_COMMON_ABORT_ABORT14_MASK)
#define DMA_COMMON_ABORT_ABORT15_MASK            (0x8000U)
#define DMA_COMMON_ABORT_ABORT15_SHIFT           (15U)
/*! ABORT15 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT15(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT15_SHIFT)) & DMA_COMMON_ABORT_ABORT15_MASK)
#define DMA_COMMON_ABORT_ABORT16_MASK            (0x10000U)
#define DMA_COMMON_ABORT_ABORT16_SHIFT           (16U)
/*! ABORT16 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT16(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT16_SHIFT)) & DMA_COMMON_ABORT_ABORT16_MASK)
#define DMA_COMMON_ABORT_ABORT17_MASK            (0x20000U)
#define DMA_COMMON_ABORT_ABORT17_SHIFT           (17U)
/*! ABORT17 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT17(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT17_SHIFT)) & DMA_COMMON_ABORT_ABORT17_MASK)
#define DMA_COMMON_ABORT_ABORT18_MASK            (0x40000U)
#define DMA_COMMON_ABORT_ABORT18_SHIFT           (18U)
/*! ABORT18 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT18(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT18_SHIFT)) & DMA_COMMON_ABORT_ABORT18_MASK)
#define DMA_COMMON_ABORT_ABORT19_MASK            (0x80000U)
#define DMA_COMMON_ABORT_ABORT19_SHIFT           (19U)
/*! ABORT19 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT19(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT19_SHIFT)) & DMA_COMMON_ABORT_ABORT19_MASK)
#define DMA_COMMON_ABORT_ABORT20_MASK            (0x100000U)
#define DMA_COMMON_ABORT_ABORT20_SHIFT           (20U)
/*! ABORT20 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT20(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT20_SHIFT)) & DMA_COMMON_ABORT_ABORT20_MASK)
#define DMA_COMMON_ABORT_ABORT21_MASK            (0x200000U)
#define DMA_COMMON_ABORT_ABORT21_SHIFT           (21U)
/*! ABORT21 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT21(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT21_SHIFT)) & DMA_COMMON_ABORT_ABORT21_MASK)
#define DMA_COMMON_ABORT_ABORT22_MASK            (0x400000U)
#define DMA_COMMON_ABORT_ABORT22_SHIFT           (22U)
/*! ABORT22 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT22(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT22_SHIFT)) & DMA_COMMON_ABORT_ABORT22_MASK)
#define DMA_COMMON_ABORT_ABORT23_MASK            (0x800000U)
#define DMA_COMMON_ABORT_ABORT23_SHIFT           (23U)
/*! ABORT23 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT23(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT23_SHIFT)) & DMA_COMMON_ABORT_ABORT23_MASK)
#define DMA_COMMON_ABORT_ABORT24_MASK            (0x1000000U)
#define DMA_COMMON_ABORT_ABORT24_SHIFT           (24U)
/*! ABORT24 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT24(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT24_SHIFT)) & DMA_COMMON_ABORT_ABORT24_MASK)
#define DMA_COMMON_ABORT_ABORT25_MASK            (0x2000000U)
#define DMA_COMMON_ABORT_ABORT25_SHIFT           (25U)
/*! ABORT25 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT25(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT25_SHIFT)) & DMA_COMMON_ABORT_ABORT25_MASK)
#define DMA_COMMON_ABORT_ABORT26_MASK            (0x4000000U)
#define DMA_COMMON_ABORT_ABORT26_SHIFT           (26U)
/*! ABORT26 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT26(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT26_SHIFT)) & DMA_COMMON_ABORT_ABORT26_MASK)
#define DMA_COMMON_ABORT_ABORT27_MASK            (0x8000000U)
#define DMA_COMMON_ABORT_ABORT27_SHIFT           (27U)
/*! ABORT27 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT27(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT27_SHIFT)) & DMA_COMMON_ABORT_ABORT27_MASK)
#define DMA_COMMON_ABORT_ABORT28_MASK            (0x10000000U)
#define DMA_COMMON_ABORT_ABORT28_SHIFT           (28U)
/*! ABORT28 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT28(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT28_SHIFT)) & DMA_COMMON_ABORT_ABORT28_MASK)
#define DMA_COMMON_ABORT_ABORT29_MASK            (0x20000000U)
#define DMA_COMMON_ABORT_ABORT29_SHIFT           (29U)
/*! ABORT29 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT29(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT29_SHIFT)) & DMA_COMMON_ABORT_ABORT29_MASK)
#define DMA_COMMON_ABORT_ABORT30_MASK            (0x40000000U)
#define DMA_COMMON_ABORT_ABORT30_SHIFT           (30U)
/*! ABORT30 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT30(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT30_SHIFT)) & DMA_COMMON_ABORT_ABORT30_MASK)
#define DMA_COMMON_ABORT_ABORT31_MASK            (0x80000000U)
#define DMA_COMMON_ABORT_ABORT31_SHIFT           (31U)
/*! ABORT31 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT_ABORT31(x)              (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT_ABORT31_SHIFT)) & DMA_COMMON_ABORT_ABORT31_MASK)
/*! @} */

/* The count of DMA_COMMON_ABORT */
#define DMA_COMMON_ABORT_COUNT                   (1U)

/*! @name COMMON_ABORT1 - Channel Abort control for all DMA channels */
/*! @{ */
#define DMA_COMMON_ABORT1_ABORT32_MASK           (0x1U)
#define DMA_COMMON_ABORT1_ABORT32_SHIFT          (0U)
/*! ABORT32 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT32(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT32_SHIFT)) & DMA_COMMON_ABORT1_ABORT32_MASK)
#define DMA_COMMON_ABORT1_ABORT33_MASK           (0x2U)
#define DMA_COMMON_ABORT1_ABORT33_SHIFT          (1U)
/*! ABORT33 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT33(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT33_SHIFT)) & DMA_COMMON_ABORT1_ABORT33_MASK)
#define DMA_COMMON_ABORT1_ABORT34_MASK           (0x4U)
#define DMA_COMMON_ABORT1_ABORT34_SHIFT          (2U)
/*! ABORT34 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT34(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT34_SHIFT)) & DMA_COMMON_ABORT1_ABORT34_MASK)
#define DMA_COMMON_ABORT1_ABORT35_MASK           (0x8U)
#define DMA_COMMON_ABORT1_ABORT35_SHIFT          (3U)
/*! ABORT35 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT35(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT35_SHIFT)) & DMA_COMMON_ABORT1_ABORT35_MASK)
#define DMA_COMMON_ABORT1_ABORT36_MASK           (0x10U)
#define DMA_COMMON_ABORT1_ABORT36_SHIFT          (4U)
/*! ABORT36 - Abort control for DMA channel.
 *  0b0..No effect.
 *  0b1..Aborts DMA operations on channel.
 */
#define DMA_COMMON_ABORT1_ABORT36(x)             (((uint32_t)(((uint32_t)(x)) << DMA_COMMON_ABORT1_ABORT36_SHIFT)) & DMA_COMMON_ABORT1_ABORT36_MASK)
/*! @} */

/* The count of DMA_COMMON_ABORT1 */
#define DMA_COMMON_ABORT1_COUNT                  (1U)

/*! @name CHANNEL_CFG - Configuration register for DMA channel */
/*! @{ */
#define DMA_CHANNEL_CFG_PERIPHREQEN_MASK         (0x1U)
#define DMA_CHANNEL_CFG_PERIPHREQEN_SHIFT        (0U)
/*! PERIPHREQEN - Peripheral request Enable.
 *  0b0..Peripheral DMA requests disabled.
 *  0b1..Peripheral DMA requests enabled.
 */
#define DMA_CHANNEL_CFG_PERIPHREQEN(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_PERIPHREQEN_SHIFT)) & DMA_CHANNEL_CFG_PERIPHREQEN_MASK)
#define DMA_CHANNEL_CFG_HWTRIGEN_MASK            (0x2U)
#define DMA_CHANNEL_CFG_HWTRIGEN_SHIFT           (1U)
/*! HWTRIGEN - Hardware Triggering Enable for channel.
 *  0b0..Hardware triggering not used for channel.
 *  0b1..Hardware triggering used for channel.
 */
#define DMA_CHANNEL_CFG_HWTRIGEN(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_HWTRIGEN_SHIFT)) & DMA_CHANNEL_CFG_HWTRIGEN_MASK)
#define DMA_CHANNEL_CFG_TRIGPOL_MASK             (0x10U)
#define DMA_CHANNEL_CFG_TRIGPOL_SHIFT            (4U)
/*! TRIGPOL - Trigger Polarity.
 *  0b0..Active low - falling edge. Hardware trigger is active low or falling edge triggered, based on TRIGTYPE.
 *  0b1..Active high - rising edge. Hardware trigger is active high or rising edge triggered, based on TRIGTYPE.
 */
#define DMA_CHANNEL_CFG_TRIGPOL(x)               (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGPOL_SHIFT)) & DMA_CHANNEL_CFG_TRIGPOL_MASK)
#define DMA_CHANNEL_CFG_TRIGTYPE_MASK            (0x20U)
#define DMA_CHANNEL_CFG_TRIGTYPE_SHIFT           (5U)
/*! TRIGTYPE - Trigger Type.
 *  0b0..Edge. Hardware trigger is edge triggered. Transfers will be initiated and completed, as specified for a single trigger.
 *  0b1..Level.
 */
#define DMA_CHANNEL_CFG_TRIGTYPE(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGTYPE_SHIFT)) & DMA_CHANNEL_CFG_TRIGTYPE_MASK)
#define DMA_CHANNEL_CFG_TRIGBURST_MASK           (0x40U)
#define DMA_CHANNEL_CFG_TRIGBURST_SHIFT          (6U)
/*! TRIGBURST - Trigger Burst.
 *  0b0..Single transfer.
 *  0b1..Burst transfer.
 */
#define DMA_CHANNEL_CFG_TRIGBURST(x)             (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_TRIGBURST_SHIFT)) & DMA_CHANNEL_CFG_TRIGBURST_MASK)
#define DMA_CHANNEL_CFG_BURSTPOWER_MASK          (0xF00U)
#define DMA_CHANNEL_CFG_BURSTPOWER_SHIFT         (8U)
/*! BURSTPOWER - Burst Power.
 */
#define DMA_CHANNEL_CFG_BURSTPOWER(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_BURSTPOWER_SHIFT)) & DMA_CHANNEL_CFG_BURSTPOWER_MASK)
#define DMA_CHANNEL_CFG_SRCBURSTWRAP_MASK        (0x4000U)
#define DMA_CHANNEL_CFG_SRCBURSTWRAP_SHIFT       (14U)
/*! SRCBURSTWRAP - Source Burst Wrap.
 *  0b0..Disabled.
 *  0b1..Enabled.
 */
#define DMA_CHANNEL_CFG_SRCBURSTWRAP(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_SRCBURSTWRAP_SHIFT)) & DMA_CHANNEL_CFG_SRCBURSTWRAP_MASK)
#define DMA_CHANNEL_CFG_DSTBURSTWRAP_MASK        (0x8000U)
#define DMA_CHANNEL_CFG_DSTBURSTWRAP_SHIFT       (15U)
/*! DSTBURSTWRAP - Destination Burst Wrap.
 *  0b0..Disabled. Destination burst wrapping is not enabled for this DMA channel.
 *  0b1..Enabled. Destination burst wrapping is enabled for this DMA channel.
 */
#define DMA_CHANNEL_CFG_DSTBURSTWRAP(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_DSTBURSTWRAP_SHIFT)) & DMA_CHANNEL_CFG_DSTBURSTWRAP_MASK)
#define DMA_CHANNEL_CFG_CHPRIORITY_MASK          (0x70000U)
#define DMA_CHANNEL_CFG_CHPRIORITY_SHIFT         (16U)
/*! CHPRIORITY - Priority of channel when multiple DMA requests are pending.
 */
#define DMA_CHANNEL_CFG_CHPRIORITY(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CFG_CHPRIORITY_SHIFT)) & DMA_CHANNEL_CFG_CHPRIORITY_MASK)
/*! @} */

/* The count of DMA_CHANNEL_CFG */
#define DMA_CHANNEL_CFG_COUNT                    (37U)

/*! @name CHANNEL_CTLSTAT - Control and status register for DMA channel */
/*! @{ */
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING_MASK    (0x1U)
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING_SHIFT   (0U)
/*! VALIDPENDING - Valid pending flag for this channel.
 *  0b0..No effect on DMA operation.
 *  0b1..Valid pending.
 */
#define DMA_CHANNEL_CTLSTAT_VALIDPENDING(x)      (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CTLSTAT_VALIDPENDING_SHIFT)) & DMA_CHANNEL_CTLSTAT_VALIDPENDING_MASK)
#define DMA_CHANNEL_CTLSTAT_TRIG_MASK            (0x4U)
#define DMA_CHANNEL_CTLSTAT_TRIG_SHIFT           (2U)
/*! TRIG - Trigger flag.
 *  0b0..Not triggered. The trigger for this DMA channel is not set. DMA operations will not be carried out.
 *  0b1..Triggered. The trigger for this DMA channel is set. DMA operations will be carried out.
 */
#define DMA_CHANNEL_CTLSTAT_TRIG(x)              (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_CTLSTAT_TRIG_SHIFT)) & DMA_CHANNEL_CTLSTAT_TRIG_MASK)
/*! @} */

/* The count of DMA_CHANNEL_CTLSTAT */
#define DMA_CHANNEL_CTLSTAT_COUNT                (37U)

/*! @name CHANNEL_XFERCFG - Transfer configuration register for DMA channel */
/*! @{ */
#define DMA_CHANNEL_XFERCFG_CFGVALID_MASK        (0x1U)
#define DMA_CHANNEL_XFERCFG_CFGVALID_SHIFT       (0U)
/*! CFGVALID - Configuration Valid flag.
 *  0b0..Not valid.
 *  0b1..Valid.
 */
#define DMA_CHANNEL_XFERCFG_CFGVALID(x)          (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_CFGVALID_SHIFT)) & DMA_CHANNEL_XFERCFG_CFGVALID_MASK)
#define DMA_CHANNEL_XFERCFG_RELOAD_MASK          (0x2U)
#define DMA_CHANNEL_XFERCFG_RELOAD_SHIFT         (1U)
/*! RELOAD - Reload.
 *  0b0..Disabled. The channels' control structure should not be reloaded when the current descriptor is exhausted.
 *  0b1..Enabled. The channels' control structure should be reloaded when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_RELOAD(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_RELOAD_SHIFT)) & DMA_CHANNEL_XFERCFG_RELOAD_MASK)
#define DMA_CHANNEL_XFERCFG_SWTRIG_MASK          (0x4U)
#define DMA_CHANNEL_XFERCFG_SWTRIG_SHIFT         (2U)
/*! SWTRIG - Software Trigger.
 *  0b0..Not set.
 *  0b1..Set.
 */
#define DMA_CHANNEL_XFERCFG_SWTRIG(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SWTRIG_SHIFT)) & DMA_CHANNEL_XFERCFG_SWTRIG_MASK)
#define DMA_CHANNEL_XFERCFG_CLRTRIG_MASK         (0x8U)
#define DMA_CHANNEL_XFERCFG_CLRTRIG_SHIFT        (3U)
/*! CLRTRIG - Clear Trigger.
 *  0b0..Not cleared.
 *  0b1..Cleared.
 */
#define DMA_CHANNEL_XFERCFG_CLRTRIG(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_CLRTRIG_SHIFT)) & DMA_CHANNEL_XFERCFG_CLRTRIG_MASK)
#define DMA_CHANNEL_XFERCFG_SETINTA_MASK         (0x10U)
#define DMA_CHANNEL_XFERCFG_SETINTA_SHIFT        (4U)
/*! SETINTA - Set Interrupt flag A for channel.
 *  0b0..No effect.
 *  0b1..Set. The INTA flag for this channel will be set when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_SETINTA(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SETINTA_SHIFT)) & DMA_CHANNEL_XFERCFG_SETINTA_MASK)
#define DMA_CHANNEL_XFERCFG_SETINTB_MASK         (0x20U)
#define DMA_CHANNEL_XFERCFG_SETINTB_SHIFT        (5U)
/*! SETINTB - Set Interrupt flag B for channel.
 *  0b0..No effect.
 *  0b1..Set. The INTB flag for this channel will be set when the current descriptor is exhausted.
 */
#define DMA_CHANNEL_XFERCFG_SETINTB(x)           (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SETINTB_SHIFT)) & DMA_CHANNEL_XFERCFG_SETINTB_MASK)
#define DMA_CHANNEL_XFERCFG_WIDTH_MASK           (0x300U)
#define DMA_CHANNEL_XFERCFG_WIDTH_SHIFT          (8U)
/*! WIDTH - Transfer width used for this DMA channel.
 *  0b00..8-bit.
 *  0b01..16-bit.
 *  0b10..32-bit.
 *  0b11..Reserved.
 */
#define DMA_CHANNEL_XFERCFG_WIDTH(x)             (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_WIDTH_SHIFT)) & DMA_CHANNEL_XFERCFG_WIDTH_MASK)
#define DMA_CHANNEL_XFERCFG_SRCINC_MASK          (0x3000U)
#define DMA_CHANNEL_XFERCFG_SRCINC_SHIFT         (12U)
/*! SRCINC - Source address increment
 *  0b00..No increment.
 *  0b01..1 x width.
 *  0b10..2 x width.
 *  0b11..4 x width.
 */
#define DMA_CHANNEL_XFERCFG_SRCINC(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_SRCINC_SHIFT)) & DMA_CHANNEL_XFERCFG_SRCINC_MASK)
#define DMA_CHANNEL_XFERCFG_DSTINC_MASK          (0xC000U)
#define DMA_CHANNEL_XFERCFG_DSTINC_SHIFT         (14U)
/*! DSTINC - Destination address increment
 *  0b00..No increment.
 *  0b01..1 x width.
 *  0b10..2 x width.
 *  0b11..4 x width.
 */
#define DMA_CHANNEL_XFERCFG_DSTINC(x)            (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_DSTINC_SHIFT)) & DMA_CHANNEL_XFERCFG_DSTINC_MASK)
#define DMA_CHANNEL_XFERCFG_XFERCOUNT_MASK       (0x3FF0000U)
#define DMA_CHANNEL_XFERCFG_XFERCOUNT_SHIFT      (16U)
/*! XFERCOUNT - Total number of transfers to be performed, minus 1 encoded.
 */
#define DMA_CHANNEL_XFERCFG_XFERCOUNT(x)         (((uint32_t)(((uint32_t)(x)) << DMA_CHANNEL_XFERCFG_XFERCOUNT_SHIFT)) & DMA_CHANNEL_XFERCFG_XFERCOUNT_MASK)
/*! @} */

/* The count of DMA_CHANNEL_XFERCFG */
#define DMA_CHANNEL_XFERCFG_COUNT                (37U)


/*!
 * @}
 */ /* end of group DMA_Register_Masks */


/* DMA - Peripheral instance base addresses */
/** Peripheral DMA0 base address */
#define DMA0_BASE                                (0x40104000u)
/** Peripheral DMA0 base pointer */
#define DMA0                                     ((DMA_Type *)DMA0_BASE)
/** Peripheral DMA1 base address */
#define DMA1_BASE                                (0x40105000u)
/** Peripheral DMA1 base pointer */
#define DMA1                                     ((DMA_Type *)DMA1_BASE)
/** Array initializer of DMA peripheral base addresses */
#define DMA_BASE_ADDRS                           { DMA0_BASE, DMA1_BASE }
/** Array initializer of DMA peripheral base pointers */
#define DMA_BASE_PTRS                            { DMA0, DMA1 }
/** Interrupt vectors for the DMA peripheral type */
#define DMA_IRQS                                 { DMA0_IRQn, DMA1_IRQn }

/*!
 * @}
 */ /* end of group DMA_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- DMIC Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMIC_Peripheral_Access_Layer DMIC Peripheral Access Layer
 * @{
 */

/** DMIC - Register Layout Typedef */
typedef struct {
  struct {                                         /* offset: 0x0, array step: 0x100 */
    __IO uint32_t OSR;                               /**< Oversample Rate, array offset: 0x0, array step: 0x100 */
    __IO uint32_t DIVHFCLK;                          /**< DMIC Clock, array offset: 0x4, array step: 0x100 */
    __IO uint32_t PREAC2FSCOEF;                      /**< Compensation Filter for 2 FS, array offset: 0x8, array step: 0x100 */
    __IO uint32_t PREAC4FSCOEF;                      /**< Compensation Filter for 4 FS, array offset: 0xC, array step: 0x100 */
    __IO uint32_t GAINSHIFT;                         /**< Decimator Gain Shift, array offset: 0x10, array step: 0x100 */
         uint8_t RESERVED_0[108];
    __IO uint32_t FIFO_CTRL;                         /**< FIFO Control, array offset: 0x80, array step: 0x100 */
    __IO uint32_t FIFO_STATUS;                       /**< FIFO Status, array offset: 0x84, array step: 0x100 */
    __I  uint32_t FIFO_DATA;                         /**< FIFO Data, array offset: 0x88, array step: 0x100 */
    __IO uint32_t PHY_CTRL;                          /**< Physical Control, array offset: 0x8C, array step: 0x100 */
    __IO uint32_t DC_CTRL;                           /**< DC Filter Control, array offset: 0x90, array step: 0x100 */
         uint8_t RESERVED_1[108];
  } CHANNEL[8];
       uint8_t RESERVED_0[1792];
  __IO uint32_t CHANEN;                            /**< Channel Enable, offset: 0xF00 */
       uint8_t RESERVED_1[12];
  __IO uint32_t USE2FS;                            /**< Use 2 FS register, offset: 0xF10 */
       uint8_t RESERVED_2[108];
  __IO uint32_t HWVADGAIN;                         /**< HWVAD Input Gain, offset: 0xF80 */
  __IO uint32_t HWVADHPFS;                         /**< HWVAD Filter Control, offset: 0xF84 */
  __IO uint32_t HWVADST10;                         /**< HWVAD Control, offset: 0xF88 */
  __IO uint32_t HWVADRSTT;                         /**< HWVAD Filter Reset, offset: 0xF8C */
  __IO uint32_t HWVADTHGN;                         /**< HWVAD Noise Estimator Gain, offset: 0xF90 */
  __IO uint32_t HWVADTHGS;                         /**< HWVAD Signal Estimator Gain, offset: 0xF94 */
  __I  uint32_t HWVADLOWZ;                         /**< HWVAD Noise Envelope Estimator, offset: 0xF98 */
} DMIC_Type;

/* ----------------------------------------------------------------------------
   -- DMIC Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup DMIC_Register_Masks DMIC Register Masks
 * @{
 */

/*! @name CHANNEL_OSR - Oversample Rate */
/*! @{ */
#define DMIC_CHANNEL_OSR_OSR_MASK                (0xFFU)
#define DMIC_CHANNEL_OSR_OSR_SHIFT               (0U)
/*! OSR - Oversample Rate
 */
#define DMIC_CHANNEL_OSR_OSR(x)                  (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_OSR_OSR_SHIFT)) & DMIC_CHANNEL_OSR_OSR_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_OSR */
#define DMIC_CHANNEL_OSR_COUNT                   (8U)

/*! @name CHANNEL_DIVHFCLK - DMIC Clock */
/*! @{ */
#define DMIC_CHANNEL_DIVHFCLK_PDMDIV_MASK        (0xFU)
#define DMIC_CHANNEL_DIVHFCLK_PDMDIV_SHIFT       (0U)
/*! PDMDIV - PDM Clock Divider Value
 *  0b0000..Divide by 1
 *  0b0001..Divide by 2
 *  0b0010..Divide by 3
 *  0b0011..Divide by 4
 *  0b0100..Divide by 6
 *  0b0101..Divide by 8
 *  0b0110..Divide by 12
 *  0b0111..Divide by 16
 *  0b1000..Divide by 24
 *  0b1001..Divide by 32
 *  0b1010..Divide by 48
 *  0b1011..Divide by 64
 *  0b1100..Divide by 96
 *  0b1101..Divide by 128
 *  0b1110-0b1111..Reserved
 */
#define DMIC_CHANNEL_DIVHFCLK_PDMDIV(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DIVHFCLK_PDMDIV_SHIFT)) & DMIC_CHANNEL_DIVHFCLK_PDMDIV_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_DIVHFCLK */
#define DMIC_CHANNEL_DIVHFCLK_COUNT              (8U)

/*! @name CHANNEL_PREAC2FSCOEF - Compensation Filter for 2 FS */
/*! @{ */
#define DMIC_CHANNEL_PREAC2FSCOEF_COMP_MASK      (0x3U)
#define DMIC_CHANNEL_PREAC2FSCOEF_COMP_SHIFT     (0U)
/*! COMP - Compensation value
 *  0b00..Compensation = 0. This is the recommended setting.
 *  0b01..Compensation = -0.16
 *  0b10..Compensation = -0.15
 *  0b11..Compensation = -0.13
 */
#define DMIC_CHANNEL_PREAC2FSCOEF_COMP(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PREAC2FSCOEF_COMP_SHIFT)) & DMIC_CHANNEL_PREAC2FSCOEF_COMP_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PREAC2FSCOEF */
#define DMIC_CHANNEL_PREAC2FSCOEF_COUNT          (8U)

/*! @name CHANNEL_PREAC4FSCOEF - Compensation Filter for 4 FS */
/*! @{ */
#define DMIC_CHANNEL_PREAC4FSCOEF_COMP_MASK      (0x3U)
#define DMIC_CHANNEL_PREAC4FSCOEF_COMP_SHIFT     (0U)
/*! COMP - Compensation value
 *  0b00..Compensation = 0. This is the recommended setting.
 *  0b01..Compensation = -0.16
 *  0b10..Compensation = -0.15
 *  0b11..Compensation = -0.13
 */
#define DMIC_CHANNEL_PREAC4FSCOEF_COMP(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PREAC4FSCOEF_COMP_SHIFT)) & DMIC_CHANNEL_PREAC4FSCOEF_COMP_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PREAC4FSCOEF */
#define DMIC_CHANNEL_PREAC4FSCOEF_COUNT          (8U)

/*! @name CHANNEL_GAINSHIFT - Decimator Gain Shift */
/*! @{ */
#define DMIC_CHANNEL_GAINSHIFT_GAIN_MASK         (0x3FU)
#define DMIC_CHANNEL_GAINSHIFT_GAIN_SHIFT        (0U)
/*! GAIN - Gain
 */
#define DMIC_CHANNEL_GAINSHIFT_GAIN(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_GAINSHIFT_GAIN_SHIFT)) & DMIC_CHANNEL_GAINSHIFT_GAIN_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_GAINSHIFT */
#define DMIC_CHANNEL_GAINSHIFT_COUNT             (8U)

/*! @name CHANNEL_FIFO_CTRL - FIFO Control */
/*! @{ */
#define DMIC_CHANNEL_FIFO_CTRL_ENABLE_MASK       (0x1U)
#define DMIC_CHANNEL_FIFO_CTRL_ENABLE_SHIFT      (0U)
/*! ENABLE - FIFO Enable.
 *  0b0..FIFO is not enabled. Enabling a DMIC channel with the FIFO disabled could be useful while data is being
 *       streamed to the I2S, or in order to avoid a filter settling delay when a channel is re-enabled after a
 *       period when the data was not needed.
 *  0b1..FIFO is enabled. The FIFO must be enabled in order for the CPU or DMA to read data from the DMIC via the FIFODATA register.
 */
#define DMIC_CHANNEL_FIFO_CTRL_ENABLE(x)         (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_ENABLE_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_ENABLE_MASK)
#define DMIC_CHANNEL_FIFO_CTRL_RESETN_MASK       (0x2U)
#define DMIC_CHANNEL_FIFO_CTRL_RESETN_SHIFT      (1U)
/*! RESETN - FIFO Reset
 *  0b0..Reset the FIFO. This must be cleared before resuming operation.
 *  0b1..Normal operation
 */
#define DMIC_CHANNEL_FIFO_CTRL_RESETN(x)         (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_RESETN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_RESETN_MASK)
#define DMIC_CHANNEL_FIFO_CTRL_INTEN_MASK        (0x4U)
#define DMIC_CHANNEL_FIFO_CTRL_INTEN_SHIFT       (2U)
/*! INTEN - Interrupt Enable.
 *  0b0..FIFO level interrupts are not enabled.
 *  0b1..FIFO level interrupts are enabled.
 */
#define DMIC_CHANNEL_FIFO_CTRL_INTEN(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_INTEN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_INTEN_MASK)
#define DMIC_CHANNEL_FIFO_CTRL_DMAEN_MASK        (0x8U)
#define DMIC_CHANNEL_FIFO_CTRL_DMAEN_SHIFT       (3U)
/*! DMAEN - DMA Enable
 *  0b0..DMA requests are not enabled.
 *  0b1..DMA requests based on FIFO level are enabled.
 */
#define DMIC_CHANNEL_FIFO_CTRL_DMAEN(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_DMAEN_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_DMAEN_MASK)
#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_MASK      (0x1F0000U)
#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_SHIFT     (16U)
/*! TRIGLVL - FIFO Trigger Level for Interrupt
 *  0b00000..Trigger when the FIFO has received one entry (is no longer empty).
 *  0b00001..Trigger when the FIFO has received two entries.
 *  0b01110..Trigger when the FIFO has received 15 entries.
 *  0b01111..Trigger when the FIFO has received 16 entries (has become full).
 */
#define DMIC_CHANNEL_FIFO_CTRL_TRIGLVL(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_SHIFT)) & DMIC_CHANNEL_FIFO_CTRL_TRIGLVL_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_CTRL */
#define DMIC_CHANNEL_FIFO_CTRL_COUNT             (8U)

/*! @name CHANNEL_FIFO_STATUS - FIFO Status */
/*! @{ */
#define DMIC_CHANNEL_FIFO_STATUS_INT_MASK        (0x1U)
#define DMIC_CHANNEL_FIFO_STATUS_INT_SHIFT       (0U)
/*! INT - Status of Interrupt (write 1 to clear)
 */
#define DMIC_CHANNEL_FIFO_STATUS_INT(x)          (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_INT_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_INT_MASK)
#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN_MASK    (0x2U)
#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN_SHIFT   (1U)
/*! OVERRUN - Overrun Detected (write 1 to clear)
 */
#define DMIC_CHANNEL_FIFO_STATUS_OVERRUN(x)      (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_OVERRUN_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_OVERRUN_MASK)
#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_MASK   (0x4U)
#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_SHIFT  (2U)
/*! UNDERRUN - Underrun Detected (write 1 to clear)
 */
#define DMIC_CHANNEL_FIFO_STATUS_UNDERRUN(x)     (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_SHIFT)) & DMIC_CHANNEL_FIFO_STATUS_UNDERRUN_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_STATUS */
#define DMIC_CHANNEL_FIFO_STATUS_COUNT           (8U)

/*! @name CHANNEL_FIFO_DATA - FIFO Data */
/*! @{ */
#define DMIC_CHANNEL_FIFO_DATA_DATA_MASK         (0xFFFFFFU)
#define DMIC_CHANNEL_FIFO_DATA_DATA_SHIFT        (0U)
/*! DATA - PCM Data
 */
#define DMIC_CHANNEL_FIFO_DATA_DATA(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_FIFO_DATA_DATA_SHIFT)) & DMIC_CHANNEL_FIFO_DATA_DATA_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_FIFO_DATA */
#define DMIC_CHANNEL_FIFO_DATA_COUNT             (8U)

/*! @name CHANNEL_PHY_CTRL - Physical Control */
/*! @{ */
#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL_MASK      (0x1U)
#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL_SHIFT     (0U)
/*! PHY_FALL - Capture DMIC on Falling edge (0 means on rising)
 *  0b0..Capture PDM_DATA on the rising edge of PDM_CLK.
 *  0b1..Capture PDM_DATA on the falling edge of PDM_CLK.
 */
#define DMIC_CHANNEL_PHY_CTRL_PHY_FALL(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PHY_CTRL_PHY_FALL_SHIFT)) & DMIC_CHANNEL_PHY_CTRL_PHY_FALL_MASK)
#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF_MASK      (0x2U)
#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF_SHIFT     (1U)
/*! PHY_HALF - Use Half rate sampling (ie Clock to dmic is sent at half the speed than the decimator is providing)
 *  0b0..Standard half rate sampling. The clock to the DMIC is sent at the same rate as the decimator is providing.
 *  0b1..Use half rate sampling. The clock to the DMIC is sent at half the rate that the decimator is providing.
 */
#define DMIC_CHANNEL_PHY_CTRL_PHY_HALF(x)        (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_PHY_CTRL_PHY_HALF_SHIFT)) & DMIC_CHANNEL_PHY_CTRL_PHY_HALF_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_PHY_CTRL */
#define DMIC_CHANNEL_PHY_CTRL_COUNT              (8U)

/*! @name CHANNEL_DC_CTRL - DC Filter Control */
/*! @{ */
#define DMIC_CHANNEL_DC_CTRL_DCPOLE_MASK         (0x3U)
#define DMIC_CHANNEL_DC_CTRL_DCPOLE_SHIFT        (0U)
/*! DCPOLE - DC Block Filter
 *  0b00..Flat Response, no filter
 *  0b01..155 Hz
 *  0b10..78 Hz
 *  0b11..39 Hz
 */
#define DMIC_CHANNEL_DC_CTRL_DCPOLE(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_DCPOLE_SHIFT)) & DMIC_CHANNEL_DC_CTRL_DCPOLE_MASK)
#define DMIC_CHANNEL_DC_CTRL_DCGAIN_MASK         (0xF0U)
#define DMIC_CHANNEL_DC_CTRL_DCGAIN_SHIFT        (4U)
/*! DCGAIN - DC Gain
 */
#define DMIC_CHANNEL_DC_CTRL_DCGAIN(x)           (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_DCGAIN_SHIFT)) & DMIC_CHANNEL_DC_CTRL_DCGAIN_MASK)
#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_MASK (0x100U)
#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_SHIFT (8U)
/*! SATURATEAT16BIT - Saturate at 16 Bit
 *  0b0..Do not Saturate. Results roll over if out range and do not saturate.
 *  0b1..Saturate. If the result overflows, it saturates at 0xFFFF for positive overflow and 0x8000 for negative overflow.
 */
#define DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT(x)  (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_SHIFT)) & DMIC_CHANNEL_DC_CTRL_SATURATEAT16BIT_MASK)
#define DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_MASK     (0x200U)
#define DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_SHIFT    (9U)
/*! SIGNEXTEND - Sign Extend
 *  0b0..The top byte of the FIFODATA register is always 0.
 *  0b1..The top byte of the FIFODATA register is sign extended.
 */
#define DMIC_CHANNEL_DC_CTRL_SIGNEXTEND(x)       (((uint32_t)(((uint32_t)(x)) << DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_SHIFT)) & DMIC_CHANNEL_DC_CTRL_SIGNEXTEND_MASK)
/*! @} */

/* The count of DMIC_CHANNEL_DC_CTRL */
#define DMIC_CHANNEL_DC_CTRL_COUNT               (8U)

/*! @name CHANEN - Channel Enable */
/*! @{ */
#define DMIC_CHANEN_EN_CH0_MASK                  (0x1U)
#define DMIC_CHANEN_EN_CH0_SHIFT                 (0U)
/*! EN_CH0 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH0(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH0_SHIFT)) & DMIC_CHANEN_EN_CH0_MASK)
#define DMIC_CHANEN_EN_CH1_MASK                  (0x2U)
#define DMIC_CHANEN_EN_CH1_SHIFT                 (1U)
/*! EN_CH1 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH1(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH1_SHIFT)) & DMIC_CHANEN_EN_CH1_MASK)
#define DMIC_CHANEN_EN_CH2_MASK                  (0x4U)
#define DMIC_CHANEN_EN_CH2_SHIFT                 (2U)
/*! EN_CH2 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH2(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH2_SHIFT)) & DMIC_CHANEN_EN_CH2_MASK)
#define DMIC_CHANEN_EN_CH3_MASK                  (0x8U)
#define DMIC_CHANEN_EN_CH3_SHIFT                 (3U)
/*! EN_CH3 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH3(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH3_SHIFT)) & DMIC_CHANEN_EN_CH3_MASK)
#define DMIC_CHANEN_EN_CH4_MASK                  (0x10U)
#define DMIC_CHANEN_EN_CH4_SHIFT                 (4U)
/*! EN_CH4 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH4(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH4_SHIFT)) & DMIC_CHANEN_EN_CH4_MASK)
#define DMIC_CHANEN_EN_CH5_MASK                  (0x20U)
#define DMIC_CHANEN_EN_CH5_SHIFT                 (5U)
/*! EN_CH5 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH5(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH5_SHIFT)) & DMIC_CHANEN_EN_CH5_MASK)
#define DMIC_CHANEN_EN_CH6_MASK                  (0x40U)
#define DMIC_CHANEN_EN_CH6_SHIFT                 (6U)
/*! EN_CH6 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH6(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH6_SHIFT)) & DMIC_CHANEN_EN_CH6_MASK)
#define DMIC_CHANEN_EN_CH7_MASK                  (0x80U)
#define DMIC_CHANEN_EN_CH7_SHIFT                 (7U)
/*! EN_CH7 - Enable Channel n
 *  0b0..PDM channel n is disabled.
 *  0b1..PDM channel n is enabled.
 */
#define DMIC_CHANEN_EN_CH7(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_CHANEN_EN_CH7_SHIFT)) & DMIC_CHANEN_EN_CH7_MASK)
/*! @} */

/*! @name USE2FS - Use 2 FS register */
/*! @{ */
#define DMIC_USE2FS_USE2FS_MASK                  (0x1U)
#define DMIC_USE2FS_USE2FS_SHIFT                 (0U)
/*! USE2FS - Use 2FS register
 *  0b0..Use 1 FS output for PCM data.
 *  0b1..Use 2 FS output for PCM data.
 */
#define DMIC_USE2FS_USE2FS(x)                    (((uint32_t)(((uint32_t)(x)) << DMIC_USE2FS_USE2FS_SHIFT)) & DMIC_USE2FS_USE2FS_MASK)
/*! @} */

/*! @name HWVADGAIN - HWVAD Input Gain */
/*! @{ */
#define DMIC_HWVADGAIN_INPUTGAIN_MASK            (0xFU)
#define DMIC_HWVADGAIN_INPUTGAIN_SHIFT           (0U)
/*! INPUTGAIN
 *  0b0000..-10 bits
 *  0b0001..-8 bits
 *  0b0010..-6 bits
 *  0b0011..-4 bits
 *  0b0100..-2 bits
 *  0b0101..0 bits (default)
 *  0b0110..+2 bits
 *  0b0111..+4 bits
 *  0b1000..+6 bits
 *  0b1001..+8 bits
 *  0b1010..+10 bits
 *  0b1011..+12 bits
 *  0b1100..+14 bits
 *  0b1101-0b1111..Reserved
 */
#define DMIC_HWVADGAIN_INPUTGAIN(x)              (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADGAIN_INPUTGAIN_SHIFT)) & DMIC_HWVADGAIN_INPUTGAIN_MASK)
/*! @} */

/*! @name HWVADHPFS - HWVAD Filter Control */
/*! @{ */
#define DMIC_HWVADHPFS_HPFS_MASK                 (0x3U)
#define DMIC_HWVADHPFS_HPFS_SHIFT                (0U)
/*! HPFS - The HPFS field chooses the High Pass filter in first part of HWVAD.
 *  0b00..BYPASS. First filter by-pass.
 *  0b01..HIGH_PASS_1750HZ. High pass filter with -3dB cut-off at 1750 Hz.
 *  0b10..HIGH_PASS_215HZ. High pass filter with -3dB cut-off at 215 Hz.
 *  0b11..Reserved
 */
#define DMIC_HWVADHPFS_HPFS(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADHPFS_HPFS_SHIFT)) & DMIC_HWVADHPFS_HPFS_MASK)
/*! @} */

/*! @name HWVADST10 - HWVAD Control */
/*! @{ */
#define DMIC_HWVADST10_ST10_MASK                 (0x1U)
#define DMIC_HWVADST10_ST10_SHIFT                (0U)
/*! ST10 - STAGE 1
 *  0b0..Normal operation, waiting for HWVAD trigger event (stage 0).
 *  0b1..Reset internal interrupt flag by writing a '1' (stage 1) pulse.
 */
#define DMIC_HWVADST10_ST10(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADST10_ST10_SHIFT)) & DMIC_HWVADST10_ST10_MASK)
/*! @} */

/*! @name HWVADRSTT - HWVAD Filter Reset */
/*! @{ */
#define DMIC_HWVADRSTT_RSST_MASK                 (0x1U)
#define DMIC_HWVADRSTT_RSST_SHIFT                (0U)
/*! RSST - Reset HWVAD
 */
#define DMIC_HWVADRSTT_RSST(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADRSTT_RSST_SHIFT)) & DMIC_HWVADRSTT_RSST_MASK)
/*! @} */

/*! @name HWVADTHGN - HWVAD Noise Estimator Gain */
/*! @{ */
#define DMIC_HWVADTHGN_THGN_MASK                 (0xFU)
#define DMIC_HWVADTHGN_THGN_SHIFT                (0U)
/*! THGN - Gain Factor for Noise Estimator
 */
#define DMIC_HWVADTHGN_THGN(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADTHGN_THGN_SHIFT)) & DMIC_HWVADTHGN_THGN_MASK)
/*! @} */

/*! @name HWVADTHGS - HWVAD Signal Estimator Gain */
/*! @{ */
#define DMIC_HWVADTHGS_THGS_MASK                 (0xFU)
#define DMIC_HWVADTHGS_THGS_SHIFT                (0U)
/*! THGS - Signal Gain Factor
 */
#define DMIC_HWVADTHGS_THGS(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADTHGS_THGS_SHIFT)) & DMIC_HWVADTHGS_THGS_MASK)
/*! @} */

/*! @name HWVADLOWZ - HWVAD Noise Envelope Estimator */
/*! @{ */
#define DMIC_HWVADLOWZ_LOWZ_MASK                 (0xFFFFU)
#define DMIC_HWVADLOWZ_LOWZ_SHIFT                (0U)
/*! LOWZ - Average Noise-floor Value
 */
#define DMIC_HWVADLOWZ_LOWZ(x)                   (((uint32_t)(((uint32_t)(x)) << DMIC_HWVADLOWZ_LOWZ_SHIFT)) & DMIC_HWVADLOWZ_LOWZ_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group DMIC_Register_Masks */


/* DMIC - Peripheral instance base addresses */
/** Peripheral DMIC0 base address */
#define DMIC0_BASE                               (0x40121000u)
/** Peripheral DMIC0 base pointer */
#define DMIC0                                    ((DMIC_Type *)DMIC0_BASE)
/** Array initializer of DMIC peripheral base addresses */
#define DMIC_BASE_ADDRS                          { DMIC0_BASE }
/** Array initializer of DMIC peripheral base pointers */
#define DMIC_BASE_PTRS                           { DMIC0 }
/** Interrupt vectors for the DMIC peripheral type */
#define DMIC_IRQS                                { DMIC0_IRQn }
#define DMIC_HWVAD_IRQS                          { HWVAD_IRQn }

/*!
 * @}
 */ /* end of group DMIC_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXCOMM Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXCOMM_Peripheral_Access_Layer FLEXCOMM Peripheral Access Layer
 * @{
 */

/** FLEXCOMM - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[4088];
  __IO uint32_t PSELID;                            /**< Peripheral Select and Flexcomm module ID, offset: 0xFF8 */
  __I  uint32_t PID;                               /**< Peripheral Identification, offset: 0xFFC */
} FLEXCOMM_Type;

/* ----------------------------------------------------------------------------
   -- FLEXCOMM Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXCOMM_Register_Masks FLEXCOMM Register Masks
 * @{
 */

/*! @name PSELID - Peripheral Select and Flexcomm module ID */
/*! @{ */
#define FLEXCOMM_PSELID_PERSEL_MASK              (0x7U)
#define FLEXCOMM_PSELID_PERSEL_SHIFT             (0U)
/*! PERSEL - Peripheral Select
 *  0b000..No peripheral selected.
 *  0b001..USART function selected
 *  0b010..SPI function selected
 *  0b011..I2C function selected
 *  0b100..I2S transmit function selected
 *  0b101..I2S receive function selected
 *  0b110..Reserved
 *  0b111..Reserved
 */
#define FLEXCOMM_PSELID_PERSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_PERSEL_SHIFT)) & FLEXCOMM_PSELID_PERSEL_MASK)
#define FLEXCOMM_PSELID_LOCK_MASK                (0x8U)
#define FLEXCOMM_PSELID_LOCK_SHIFT               (3U)
/*! LOCK - Lock the peripheral select.
 *  0b0..Peripheral select can be changed by software.
 *  0b1..Peripheral select is locked and cannot be changed until this Flexcomm module or the entire device is reset.
 */
#define FLEXCOMM_PSELID_LOCK(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_LOCK_SHIFT)) & FLEXCOMM_PSELID_LOCK_MASK)
#define FLEXCOMM_PSELID_USARTPRESENT_MASK        (0x10U)
#define FLEXCOMM_PSELID_USARTPRESENT_SHIFT       (4U)
/*! USARTPRESENT - USART present indicator
 *  0b0..This Flexcomm module does not include the USART function.
 *  0b1..This Flexcomm module includes the USART function.
 */
#define FLEXCOMM_PSELID_USARTPRESENT(x)          (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_USARTPRESENT_SHIFT)) & FLEXCOMM_PSELID_USARTPRESENT_MASK)
#define FLEXCOMM_PSELID_SPIPRESENT_MASK          (0x20U)
#define FLEXCOMM_PSELID_SPIPRESENT_SHIFT         (5U)
/*! SPIPRESENT - SPI present indicator
 *  0b0..This Flexcomm module does not include the SPI function.
 *  0b1..This Flexcomm module includes the SPI function.
 */
#define FLEXCOMM_PSELID_SPIPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_SPIPRESENT_SHIFT)) & FLEXCOMM_PSELID_SPIPRESENT_MASK)
#define FLEXCOMM_PSELID_I2CPRESENT_MASK          (0x40U)
#define FLEXCOMM_PSELID_I2CPRESENT_SHIFT         (6U)
/*! I2CPRESENT
 *  0b0..This Flexcomm module does not include the I2C function.
 *  0b1..This Flexcomm module includes the I2C function.
 */
#define FLEXCOMM_PSELID_I2CPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_I2CPRESENT_SHIFT)) & FLEXCOMM_PSELID_I2CPRESENT_MASK)
#define FLEXCOMM_PSELID_I2SPRESENT_MASK          (0x80U)
#define FLEXCOMM_PSELID_I2SPRESENT_SHIFT         (7U)
/*! I2SPRESENT
 *  0b0..This Flexcomm module does not include the I2S function.
 *  0b1..This Flexcomm module includes the I2S function.
 */
#define FLEXCOMM_PSELID_I2SPRESENT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_I2SPRESENT_SHIFT)) & FLEXCOMM_PSELID_I2SPRESENT_MASK)
#define FLEXCOMM_PSELID_ID_MASK                  (0xFFFFF000U)
#define FLEXCOMM_PSELID_ID_SHIFT                 (12U)
/*! ID - Flexcomm ID
 */
#define FLEXCOMM_PSELID_ID(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PSELID_ID_SHIFT)) & FLEXCOMM_PSELID_ID_MASK)
/*! @} */

/*! @name PID - Peripheral Identification */
/*! @{ */
#define FLEXCOMM_PID_Minor_Rev_MASK              (0xF00U)
#define FLEXCOMM_PID_Minor_Rev_SHIFT             (8U)
/*! Minor_Rev - Minor revision of module implementation
 */
#define FLEXCOMM_PID_Minor_Rev(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_Minor_Rev_SHIFT)) & FLEXCOMM_PID_Minor_Rev_MASK)
#define FLEXCOMM_PID_Major_Rev_MASK              (0xF000U)
#define FLEXCOMM_PID_Major_Rev_SHIFT             (12U)
/*! Major_Rev - Major revision of module implementation
 */
#define FLEXCOMM_PID_Major_Rev(x)                (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_Major_Rev_SHIFT)) & FLEXCOMM_PID_Major_Rev_MASK)
#define FLEXCOMM_PID_ID_MASK                     (0xFFFF0000U)
#define FLEXCOMM_PID_ID_SHIFT                    (16U)
/*! ID - Module identifier for the selected function
 */
#define FLEXCOMM_PID_ID(x)                       (((uint32_t)(((uint32_t)(x)) << FLEXCOMM_PID_ID_SHIFT)) & FLEXCOMM_PID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FLEXCOMM_Register_Masks */


/* FLEXCOMM - Peripheral instance base addresses */
/** Peripheral FLEXCOMM0 base address */
#define FLEXCOMM0_BASE                           (0x40106000u)
/** Peripheral FLEXCOMM0 base pointer */
#define FLEXCOMM0                                ((FLEXCOMM_Type *)FLEXCOMM0_BASE)
/** Peripheral FLEXCOMM1 base address */
#define FLEXCOMM1_BASE                           (0x40107000u)
/** Peripheral FLEXCOMM1 base pointer */
#define FLEXCOMM1                                ((FLEXCOMM_Type *)FLEXCOMM1_BASE)
/** Peripheral FLEXCOMM2 base address */
#define FLEXCOMM2_BASE                           (0x40108000u)
/** Peripheral FLEXCOMM2 base pointer */
#define FLEXCOMM2                                ((FLEXCOMM_Type *)FLEXCOMM2_BASE)
/** Peripheral FLEXCOMM3 base address */
#define FLEXCOMM3_BASE                           (0x40109000u)
/** Peripheral FLEXCOMM3 base pointer */
#define FLEXCOMM3                                ((FLEXCOMM_Type *)FLEXCOMM3_BASE)
/** Peripheral FLEXCOMM4 base address */
#define FLEXCOMM4_BASE                           (0x40122000u)
/** Peripheral FLEXCOMM4 base pointer */
#define FLEXCOMM4                                ((FLEXCOMM_Type *)FLEXCOMM4_BASE)
/** Peripheral FLEXCOMM5 base address */
#define FLEXCOMM5_BASE                           (0x40123000u)
/** Peripheral FLEXCOMM5 base pointer */
#define FLEXCOMM5                                ((FLEXCOMM_Type *)FLEXCOMM5_BASE)
/** Peripheral FLEXCOMM6 base address */
#define FLEXCOMM6_BASE                           (0x40124000u)
/** Peripheral FLEXCOMM6 base pointer */
#define FLEXCOMM6                                ((FLEXCOMM_Type *)FLEXCOMM6_BASE)
/** Peripheral FLEXCOMM7 base address */
#define FLEXCOMM7_BASE                           (0x40125000u)
/** Peripheral FLEXCOMM7 base pointer */
#define FLEXCOMM7                                ((FLEXCOMM_Type *)FLEXCOMM7_BASE)
/** Peripheral FLEXCOMM8 base address */
#define FLEXCOMM8_BASE                           (0x40209000u)
/** Peripheral FLEXCOMM8 base pointer */
#define FLEXCOMM8                                ((FLEXCOMM_Type *)FLEXCOMM8_BASE)
/** Peripheral FLEXCOMM9 base address */
#define FLEXCOMM9_BASE                           (0x4020A000u)
/** Peripheral FLEXCOMM9 base pointer */
#define FLEXCOMM9                                ((FLEXCOMM_Type *)FLEXCOMM9_BASE)
/** Peripheral FLEXCOMM10 base address */
#define FLEXCOMM10_BASE                          (0x4020B000u)
/** Peripheral FLEXCOMM10 base pointer */
#define FLEXCOMM10                               ((FLEXCOMM_Type *)FLEXCOMM10_BASE)
/** Peripheral FLEXCOMM11 base address */
#define FLEXCOMM11_BASE                          (0x4020C000u)
/** Peripheral FLEXCOMM11 base pointer */
#define FLEXCOMM11                               ((FLEXCOMM_Type *)FLEXCOMM11_BASE)
/** Peripheral FLEXCOMM12 base address */
#define FLEXCOMM12_BASE                          (0x4020D000u)
/** Peripheral FLEXCOMM12 base pointer */
#define FLEXCOMM12                               ((FLEXCOMM_Type *)FLEXCOMM12_BASE)
/** Peripheral FLEXCOMM13 base address */
#define FLEXCOMM13_BASE                          (0x4020E000u)
/** Peripheral FLEXCOMM13 base pointer */
#define FLEXCOMM13                               ((FLEXCOMM_Type *)FLEXCOMM13_BASE)
/** Peripheral FLEXCOMM14 base address */
#define FLEXCOMM14_BASE                          (0x40126000u)
/** Peripheral FLEXCOMM14 base pointer */
#define FLEXCOMM14                               ((FLEXCOMM_Type *)FLEXCOMM14_BASE)
/** Peripheral FLEXCOMM15 base address */
#define FLEXCOMM15_BASE                          (0x40127000u)
/** Peripheral FLEXCOMM15 base pointer */
#define FLEXCOMM15                               ((FLEXCOMM_Type *)FLEXCOMM15_BASE)
/** Peripheral FLEXCOMM16 base address */
#define FLEXCOMM16_BASE                          (0x40128000u)
/** Peripheral FLEXCOMM16 base pointer */
#define FLEXCOMM16                               ((FLEXCOMM_Type *)FLEXCOMM16_BASE)
/** Array initializer of FLEXCOMM peripheral base addresses */
#define FLEXCOMM_BASE_ADDRS                      { FLEXCOMM0_BASE, FLEXCOMM1_BASE, FLEXCOMM2_BASE, FLEXCOMM3_BASE, FLEXCOMM4_BASE, FLEXCOMM5_BASE, FLEXCOMM6_BASE, FLEXCOMM7_BASE, FLEXCOMM8_BASE, FLEXCOMM9_BASE, FLEXCOMM10_BASE, FLEXCOMM11_BASE, FLEXCOMM12_BASE, FLEXCOMM13_BASE, FLEXCOMM14_BASE, FLEXCOMM15_BASE, FLEXCOMM16_BASE }
/** Array initializer of FLEXCOMM peripheral base pointers */
#define FLEXCOMM_BASE_PTRS                       { FLEXCOMM0, FLEXCOMM1, FLEXCOMM2, FLEXCOMM3, FLEXCOMM4, FLEXCOMM5, FLEXCOMM6, FLEXCOMM7, FLEXCOMM8, FLEXCOMM9, FLEXCOMM10, FLEXCOMM11, FLEXCOMM12, FLEXCOMM13, FLEXCOMM14, FLEXCOMM15, FLEXCOMM16 }
/** Interrupt vectors for the FLEXCOMM peripheral type */
#define FLEXCOMM_IRQS                            { FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, FLEXCOMM6_IRQn, FLEXCOMM7_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, FLEXCOMM14_IRQn, NotAvail_IRQn, FLEXCOMM16_IRQn }

/*!
 * @}
 */ /* end of group FLEXCOMM_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Peripheral_Access_Layer FLEXIO Peripheral Access Layer
 * @{
 */

/** FLEXIO - Register Layout Typedef */
typedef struct {
  __I  uint32_t VERID;                             /**< Version ID Register, offset: 0x0 */
  __I  uint32_t PARAM;                             /**< Parameter Register, offset: 0x4 */
  __IO uint32_t CTRL;                              /**< FlexIO Control Register, offset: 0x8 */
  __I  uint32_t PIN;                               /**< Pin State Register, offset: 0xC */
  __IO uint32_t SHIFTSTAT;                         /**< Shifter Status Register, offset: 0x10 */
  __IO uint32_t SHIFTERR;                          /**< Shifter Error Register, offset: 0x14 */
  __IO uint32_t TIMSTAT;                           /**< Timer Status Register, offset: 0x18 */
       uint8_t RESERVED_0[4];
  __IO uint32_t SHIFTSIEN;                         /**< Shifter Status Interrupt Enable, offset: 0x20 */
  __IO uint32_t SHIFTEIEN;                         /**< Shifter Error Interrupt Enable, offset: 0x24 */
  __IO uint32_t TIMIEN;                            /**< Timer Interrupt Enable Register, offset: 0x28 */
       uint8_t RESERVED_1[4];
  __IO uint32_t SHIFTSDEN;                         /**< Shifter Status DMA Enable, offset: 0x30 */
       uint8_t RESERVED_2[4];
  __IO uint32_t TIMERSDEN;                         /**< Timer Status DMA Enable, offset: 0x38 */
       uint8_t RESERVED_3[4];
  __IO uint32_t SHIFTSTATE;                        /**< Shifter State Register, offset: 0x40 */
       uint8_t RESERVED_4[4];
  __IO uint32_t TRGSTAT;                           /**< Trigger Status Register, offset: 0x48 */
  __IO uint32_t TRIGIEN;                           /**< External Trigger Interrupt Enable Register, offset: 0x4C */
  __IO uint32_t PINSTAT;                           /**< Pin Status Register, offset: 0x50 */
  __IO uint32_t PINIEN;                            /**< Pin Interrupt Enable Register, offset: 0x54 */
  __IO uint32_t PINREN;                            /**< Pin Rising Edge Enable Register, offset: 0x58 */
  __IO uint32_t PINFEN;                            /**< Pin Falling Edge Enable Register, offset: 0x5C */
  __IO uint32_t PINOUTD;                           /**< Pin Output Data Register, offset: 0x60 */
  __IO uint32_t PINOUTE;                           /**< Pin Output Enable Register, offset: 0x64 */
  __O  uint32_t PINOUTDIS;                         /**< Pin Output Disable Register, offset: 0x68 */
  __O  uint32_t PINOUTCLR;                         /**< Pin Output Clear Register, offset: 0x6C */
  __O  uint32_t PINOUTSET;                         /**< Pin Output Set Register, offset: 0x70 */
  __O  uint32_t PINOUTTOG;                         /**< Pin Output Toggle Register, offset: 0x74 */
       uint8_t RESERVED_5[8];
  __IO uint32_t SHIFTCTL[8];                       /**< Shifter Control N Register, array offset: 0x80, array step: 0x4 */
       uint8_t RESERVED_6[96];
  __IO uint32_t SHIFTCFG[8];                       /**< Shifter Configuration N Register, array offset: 0x100, array step: 0x4 */
       uint8_t RESERVED_7[224];
  __IO uint32_t SHIFTBUF[8];                       /**< Shifter Buffer N Register, array offset: 0x200, array step: 0x4 */
       uint8_t RESERVED_8[96];
  __IO uint32_t SHIFTBUFBIS[8];                    /**< Shifter Buffer N Bit Swapped Register, array offset: 0x280, array step: 0x4 */
       uint8_t RESERVED_9[96];
  __IO uint32_t SHIFTBUFBYS[8];                    /**< Shifter Buffer N Byte Swapped Register, array offset: 0x300, array step: 0x4 */
       uint8_t RESERVED_10[96];
  __IO uint32_t SHIFTBUFBBS[8];                    /**< Shifter Buffer N Bit Byte Swapped Register, array offset: 0x380, array step: 0x4 */
       uint8_t RESERVED_11[96];
  __IO uint32_t TIMCTL[8];                         /**< Timer Control N Register, array offset: 0x400, array step: 0x4 */
       uint8_t RESERVED_12[96];
  __IO uint32_t TIMCFG[8];                         /**< Timer Configuration N Register, array offset: 0x480, array step: 0x4 */
       uint8_t RESERVED_13[96];
  __IO uint32_t TIMCMP[8];                         /**< Timer Compare N Register, array offset: 0x500, array step: 0x4 */
       uint8_t RESERVED_14[352];
  __IO uint32_t SHIFTBUFNBS[8];                    /**< Shifter Buffer N Nibble Byte Swapped Register, array offset: 0x680, array step: 0x4 */
       uint8_t RESERVED_15[96];
  __IO uint32_t SHIFTBUFHWS[8];                    /**< Shifter Buffer N Half Word Swapped Register, array offset: 0x700, array step: 0x4 */
       uint8_t RESERVED_16[96];
  __IO uint32_t SHIFTBUFNIS[8];                    /**< Shifter Buffer N Nibble Swapped Register, array offset: 0x780, array step: 0x4 */
       uint8_t RESERVED_17[96];
  __IO uint32_t SHIFTBUFOES[8];                    /**< Shifter Buffer N Odd Even Swapped Register, array offset: 0x800, array step: 0x4 */
       uint8_t RESERVED_18[96];
  __IO uint32_t SHIFTBUFEOS[8];                    /**< Shifter Buffer N Even Odd Swapped Register, array offset: 0x880, array step: 0x4 */
} FLEXIO_Type;

/* ----------------------------------------------------------------------------
   -- FLEXIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXIO_Register_Masks FLEXIO Register Masks
 * @{
 */

/*! @name VERID - Version ID Register */
/*! @{ */
#define FLEXIO_VERID_FEATURE_MASK                (0xFFFFU)
#define FLEXIO_VERID_FEATURE_SHIFT               (0U)
/*! FEATURE - Feature Specification Number
 *  0b0000000000000000..Standard features implemented.
 *  0b0000000000000001..Supports state, logic and parallel modes.
 *  0b0000000000000010..Supports pin control registers.
 *  0b0000000000000011..Supports state, logic and parallel modes; plus pin control registers.
 */
#define FLEXIO_VERID_FEATURE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_FEATURE_SHIFT)) & FLEXIO_VERID_FEATURE_MASK)
#define FLEXIO_VERID_MINOR_MASK                  (0xFF0000U)
#define FLEXIO_VERID_MINOR_SHIFT                 (16U)
/*! MINOR - Minor Version Number
 */
#define FLEXIO_VERID_MINOR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_MINOR_SHIFT)) & FLEXIO_VERID_MINOR_MASK)
#define FLEXIO_VERID_MAJOR_MASK                  (0xFF000000U)
#define FLEXIO_VERID_MAJOR_SHIFT                 (24U)
/*! MAJOR - Major Version Number
 */
#define FLEXIO_VERID_MAJOR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_VERID_MAJOR_SHIFT)) & FLEXIO_VERID_MAJOR_MASK)
/*! @} */

/*! @name PARAM - Parameter Register */
/*! @{ */
#define FLEXIO_PARAM_SHIFTER_MASK                (0xFFU)
#define FLEXIO_PARAM_SHIFTER_SHIFT               (0U)
/*! SHIFTER - Shifter Number
 */
#define FLEXIO_PARAM_SHIFTER(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_SHIFTER_SHIFT)) & FLEXIO_PARAM_SHIFTER_MASK)
#define FLEXIO_PARAM_TIMER_MASK                  (0xFF00U)
#define FLEXIO_PARAM_TIMER_SHIFT                 (8U)
/*! TIMER - Timer Number
 */
#define FLEXIO_PARAM_TIMER(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_TIMER_SHIFT)) & FLEXIO_PARAM_TIMER_MASK)
#define FLEXIO_PARAM_PIN_MASK                    (0xFF0000U)
#define FLEXIO_PARAM_PIN_SHIFT                   (16U)
/*! PIN - Pin Number
 */
#define FLEXIO_PARAM_PIN(x)                      (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_PIN_SHIFT)) & FLEXIO_PARAM_PIN_MASK)
#define FLEXIO_PARAM_TRIGGER_MASK                (0xFF000000U)
#define FLEXIO_PARAM_TRIGGER_SHIFT               (24U)
/*! TRIGGER - Trigger Number
 */
#define FLEXIO_PARAM_TRIGGER(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_PARAM_TRIGGER_SHIFT)) & FLEXIO_PARAM_TRIGGER_MASK)
/*! @} */

/*! @name CTRL - FlexIO Control Register */
/*! @{ */
#define FLEXIO_CTRL_FLEXEN_MASK                  (0x1U)
#define FLEXIO_CTRL_FLEXEN_SHIFT                 (0U)
/*! FLEXEN - FlexIO Enable
 *  0b0..FlexIO module is disabled.
 *  0b1..FlexIO module is enabled.
 */
#define FLEXIO_CTRL_FLEXEN(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_FLEXEN_SHIFT)) & FLEXIO_CTRL_FLEXEN_MASK)
#define FLEXIO_CTRL_SWRST_MASK                   (0x2U)
#define FLEXIO_CTRL_SWRST_SHIFT                  (1U)
/*! SWRST - Software Reset
 *  0b0..Software reset is disabled
 *  0b1..Software reset is enabled, all FlexIO registers except the Control Register are reset.
 */
#define FLEXIO_CTRL_SWRST(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_SWRST_SHIFT)) & FLEXIO_CTRL_SWRST_MASK)
#define FLEXIO_CTRL_FASTACC_MASK                 (0x4U)
#define FLEXIO_CTRL_FASTACC_SHIFT                (2U)
/*! FASTACC - Fast Access
 *  0b0..Configures for normal register accesses to FlexIO
 *  0b1..Configures for fast register accesses to FlexIO
 */
#define FLEXIO_CTRL_FASTACC(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_FASTACC_SHIFT)) & FLEXIO_CTRL_FASTACC_MASK)
#define FLEXIO_CTRL_DBGE_MASK                    (0x40000000U)
#define FLEXIO_CTRL_DBGE_SHIFT                   (30U)
/*! DBGE - Debug Enable
 *  0b0..FlexIO is disabled in debug modes.
 *  0b1..FlexIO is enabled in debug modes
 */
#define FLEXIO_CTRL_DBGE(x)                      (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_DBGE_SHIFT)) & FLEXIO_CTRL_DBGE_MASK)
#define FLEXIO_CTRL_DOZEN_MASK                   (0x80000000U)
#define FLEXIO_CTRL_DOZEN_SHIFT                  (31U)
/*! DOZEN - Doze Enable
 *  0b0..FlexIO enabled in Doze modes.
 *  0b1..FlexIO disabled in Doze modes.
 */
#define FLEXIO_CTRL_DOZEN(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_CTRL_DOZEN_SHIFT)) & FLEXIO_CTRL_DOZEN_MASK)
/*! @} */

/*! @name PIN - Pin State Register */
/*! @{ */
#define FLEXIO_PIN_PDI_MASK                      (0xFFFFU)
#define FLEXIO_PIN_PDI_SHIFT                     (0U)
/*! PDI - Pin Data Input
 */
#define FLEXIO_PIN_PDI(x)                        (((uint32_t)(((uint32_t)(x)) << FLEXIO_PIN_PDI_SHIFT)) & FLEXIO_PIN_PDI_MASK)
/*! @} */

/*! @name SHIFTSTAT - Shifter Status Register */
/*! @{ */
#define FLEXIO_SHIFTSTAT_SSF_MASK                (0xFFU)
#define FLEXIO_SHIFTSTAT_SSF_SHIFT               (0U)
/*! SSF - Shifter Status Flag
 */
#define FLEXIO_SHIFTSTAT_SSF(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSTAT_SSF_SHIFT)) & FLEXIO_SHIFTSTAT_SSF_MASK)
/*! @} */

/*! @name SHIFTERR - Shifter Error Register */
/*! @{ */
#define FLEXIO_SHIFTERR_SEF_MASK                 (0xFFU)
#define FLEXIO_SHIFTERR_SEF_SHIFT                (0U)
/*! SEF - Shifter Error Flags
 */
#define FLEXIO_SHIFTERR_SEF(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTERR_SEF_SHIFT)) & FLEXIO_SHIFTERR_SEF_MASK)
/*! @} */

/*! @name TIMSTAT - Timer Status Register */
/*! @{ */
#define FLEXIO_TIMSTAT_TSF_MASK                  (0xFFU)
#define FLEXIO_TIMSTAT_TSF_SHIFT                 (0U)
/*! TSF - Timer Status Flags
 */
#define FLEXIO_TIMSTAT_TSF(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMSTAT_TSF_SHIFT)) & FLEXIO_TIMSTAT_TSF_MASK)
/*! @} */

/*! @name SHIFTSIEN - Shifter Status Interrupt Enable */
/*! @{ */
#define FLEXIO_SHIFTSIEN_SSIE_MASK               (0xFFU)
#define FLEXIO_SHIFTSIEN_SSIE_SHIFT              (0U)
/*! SSIE - Shifter Status Interrupt Enable
 */
#define FLEXIO_SHIFTSIEN_SSIE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSIEN_SSIE_SHIFT)) & FLEXIO_SHIFTSIEN_SSIE_MASK)
/*! @} */

/*! @name SHIFTEIEN - Shifter Error Interrupt Enable */
/*! @{ */
#define FLEXIO_SHIFTEIEN_SEIE_MASK               (0xFFU)
#define FLEXIO_SHIFTEIEN_SEIE_SHIFT              (0U)
/*! SEIE - Shifter Error Interrupt Enable
 */
#define FLEXIO_SHIFTEIEN_SEIE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTEIEN_SEIE_SHIFT)) & FLEXIO_SHIFTEIEN_SEIE_MASK)
/*! @} */

/*! @name TIMIEN - Timer Interrupt Enable Register */
/*! @{ */
#define FLEXIO_TIMIEN_TEIE_MASK                  (0xFFU)
#define FLEXIO_TIMIEN_TEIE_SHIFT                 (0U)
/*! TEIE - Timer Status Interrupt Enable
 */
#define FLEXIO_TIMIEN_TEIE(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMIEN_TEIE_SHIFT)) & FLEXIO_TIMIEN_TEIE_MASK)
/*! @} */

/*! @name SHIFTSDEN - Shifter Status DMA Enable */
/*! @{ */
#define FLEXIO_SHIFTSDEN_SSDE_MASK               (0xFFU)
#define FLEXIO_SHIFTSDEN_SSDE_SHIFT              (0U)
/*! SSDE - Shifter Status DMA Enable
 */
#define FLEXIO_SHIFTSDEN_SSDE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSDEN_SSDE_SHIFT)) & FLEXIO_SHIFTSDEN_SSDE_MASK)
/*! @} */

/*! @name TIMERSDEN - Timer Status DMA Enable */
/*! @{ */
#define FLEXIO_TIMERSDEN_TSDE_MASK               (0xFFU)
#define FLEXIO_TIMERSDEN_TSDE_SHIFT              (0U)
/*! TSDE - Timer Status DMA Enable
 */
#define FLEXIO_TIMERSDEN_TSDE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMERSDEN_TSDE_SHIFT)) & FLEXIO_TIMERSDEN_TSDE_MASK)
/*! @} */

/*! @name SHIFTSTATE - Shifter State Register */
/*! @{ */
#define FLEXIO_SHIFTSTATE_STATE_MASK             (0x7U)
#define FLEXIO_SHIFTSTATE_STATE_SHIFT            (0U)
/*! STATE - Current State Pointer
 */
#define FLEXIO_SHIFTSTATE_STATE(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTSTATE_STATE_SHIFT)) & FLEXIO_SHIFTSTATE_STATE_MASK)
/*! @} */

/*! @name TRGSTAT - Trigger Status Register */
/*! @{ */
#define FLEXIO_TRGSTAT_ETSF_MASK                 (0xFFFFU)
#define FLEXIO_TRGSTAT_ETSF_SHIFT                (0U)
/*! ETSF - External Trigger Status Flags
 */
#define FLEXIO_TRGSTAT_ETSF(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TRGSTAT_ETSF_SHIFT)) & FLEXIO_TRGSTAT_ETSF_MASK)
/*! @} */

/*! @name TRIGIEN - External Trigger Interrupt Enable Register */
/*! @{ */
#define FLEXIO_TRIGIEN_TRIE_MASK                 (0xFFFFU)
#define FLEXIO_TRIGIEN_TRIE_SHIFT                (0U)
/*! TRIE - External Trigger Interrupt Enable
 */
#define FLEXIO_TRIGIEN_TRIE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TRIGIEN_TRIE_SHIFT)) & FLEXIO_TRIGIEN_TRIE_MASK)
/*! @} */

/*! @name PINSTAT - Pin Status Register */
/*! @{ */
#define FLEXIO_PINSTAT_PSF_MASK                  (0xFFFFU)
#define FLEXIO_PINSTAT_PSF_SHIFT                 (0U)
/*! PSF - Pin Status Flags
 */
#define FLEXIO_PINSTAT_PSF(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINSTAT_PSF_SHIFT)) & FLEXIO_PINSTAT_PSF_MASK)
/*! @} */

/*! @name PINIEN - Pin Interrupt Enable Register */
/*! @{ */
#define FLEXIO_PINIEN_PSIE_MASK                  (0xFFFFU)
#define FLEXIO_PINIEN_PSIE_SHIFT                 (0U)
/*! PSIE - Pin Status Interrupt Enable
 */
#define FLEXIO_PINIEN_PSIE(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINIEN_PSIE_SHIFT)) & FLEXIO_PINIEN_PSIE_MASK)
/*! @} */

/*! @name PINREN - Pin Rising Edge Enable Register */
/*! @{ */
#define FLEXIO_PINREN_PRE_MASK                   (0xFFFFU)
#define FLEXIO_PINREN_PRE_SHIFT                  (0U)
/*! PRE - Pin Rising Edge
 */
#define FLEXIO_PINREN_PRE(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINREN_PRE_SHIFT)) & FLEXIO_PINREN_PRE_MASK)
/*! @} */

/*! @name PINFEN - Pin Falling Edge Enable Register */
/*! @{ */
#define FLEXIO_PINFEN_PFE_MASK                   (0xFFFFU)
#define FLEXIO_PINFEN_PFE_SHIFT                  (0U)
/*! PFE - Pin Falling Edge
 */
#define FLEXIO_PINFEN_PFE(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINFEN_PFE_SHIFT)) & FLEXIO_PINFEN_PFE_MASK)
/*! @} */

/*! @name PINOUTD - Pin Output Data Register */
/*! @{ */
#define FLEXIO_PINOUTD_OUTD_MASK                 (0xFFFFU)
#define FLEXIO_PINOUTD_OUTD_SHIFT                (0U)
/*! OUTD - Output Data
 */
#define FLEXIO_PINOUTD_OUTD(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTD_OUTD_SHIFT)) & FLEXIO_PINOUTD_OUTD_MASK)
/*! @} */

/*! @name PINOUTE - Pin Output Enable Register */
/*! @{ */
#define FLEXIO_PINOUTE_OUTE_MASK                 (0xFFFFU)
#define FLEXIO_PINOUTE_OUTE_SHIFT                (0U)
/*! OUTE - Output Enable
 */
#define FLEXIO_PINOUTE_OUTE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTE_OUTE_SHIFT)) & FLEXIO_PINOUTE_OUTE_MASK)
/*! @} */

/*! @name PINOUTDIS - Pin Output Disable Register */
/*! @{ */
#define FLEXIO_PINOUTDIS_OUTDIS_MASK             (0xFFFFU)
#define FLEXIO_PINOUTDIS_OUTDIS_SHIFT            (0U)
/*! OUTDIS - Output Disable
 */
#define FLEXIO_PINOUTDIS_OUTDIS(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTDIS_OUTDIS_SHIFT)) & FLEXIO_PINOUTDIS_OUTDIS_MASK)
/*! @} */

/*! @name PINOUTCLR - Pin Output Clear Register */
/*! @{ */
#define FLEXIO_PINOUTCLR_OUTCLR_MASK             (0xFFFFU)
#define FLEXIO_PINOUTCLR_OUTCLR_SHIFT            (0U)
/*! OUTCLR - Output Clear
 */
#define FLEXIO_PINOUTCLR_OUTCLR(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTCLR_OUTCLR_SHIFT)) & FLEXIO_PINOUTCLR_OUTCLR_MASK)
/*! @} */

/*! @name PINOUTSET - Pin Output Set Register */
/*! @{ */
#define FLEXIO_PINOUTSET_OUTSET_MASK             (0xFFFFU)
#define FLEXIO_PINOUTSET_OUTSET_SHIFT            (0U)
/*! OUTSET - Output Set
 */
#define FLEXIO_PINOUTSET_OUTSET(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTSET_OUTSET_SHIFT)) & FLEXIO_PINOUTSET_OUTSET_MASK)
/*! @} */

/*! @name PINOUTTOG - Pin Output Toggle Register */
/*! @{ */
#define FLEXIO_PINOUTTOG_OUTTOG_MASK             (0xFFFFU)
#define FLEXIO_PINOUTTOG_OUTTOG_SHIFT            (0U)
/*! OUTTOG - Output Toggle
 */
#define FLEXIO_PINOUTTOG_OUTTOG(x)               (((uint32_t)(((uint32_t)(x)) << FLEXIO_PINOUTTOG_OUTTOG_SHIFT)) & FLEXIO_PINOUTTOG_OUTTOG_MASK)
/*! @} */

/*! @name SHIFTCTL - Shifter Control N Register */
/*! @{ */
#define FLEXIO_SHIFTCTL_SMOD_MASK                (0x7U)
#define FLEXIO_SHIFTCTL_SMOD_SHIFT               (0U)
/*! SMOD - Shifter Mode
 *  0b000..Disabled.
 *  0b001..Receive mode. Captures the current Shifter content into the SHIFTBUF on expiration of the Timer.
 *  0b010..Transmit mode. Load SHIFTBUF contents into the Shifter on expiration of the Timer.
 *  0b011..Reserved.
 *  0b100..Match Store mode. Shifter data is compared to SHIFTBUF content on expiration of the Timer.
 *  0b101..Match Continuous mode. Shifter data is continuously compared to SHIFTBUF contents.
 *  0b110..State mode. SHIFTBUF contents are used for storing programmable state attributes.
 *  0b111..Logic mode. SHIFTBUF contents are used for implementing programmable logic look up table.
 */
#define FLEXIO_SHIFTCTL_SMOD(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_SMOD_SHIFT)) & FLEXIO_SHIFTCTL_SMOD_MASK)
#define FLEXIO_SHIFTCTL_PINPOL_MASK              (0x80U)
#define FLEXIO_SHIFTCTL_PINPOL_SHIFT             (7U)
/*! PINPOL - Shifter Pin Polarity
 *  0b0..Pin is active high
 *  0b1..Pin is active low
 */
#define FLEXIO_SHIFTCTL_PINPOL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINPOL_SHIFT)) & FLEXIO_SHIFTCTL_PINPOL_MASK)
#define FLEXIO_SHIFTCTL_PINSEL_MASK              (0xF00U)
#define FLEXIO_SHIFTCTL_PINSEL_SHIFT             (8U)
/*! PINSEL - Shifter Pin Select
 */
#define FLEXIO_SHIFTCTL_PINSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINSEL_SHIFT)) & FLEXIO_SHIFTCTL_PINSEL_MASK)
#define FLEXIO_SHIFTCTL_PINCFG_MASK              (0x30000U)
#define FLEXIO_SHIFTCTL_PINCFG_SHIFT             (16U)
/*! PINCFG - Shifter Pin Configuration
 *  0b00..Shifter pin output disabled
 *  0b01..Shifter pin open drain or bidirectional output enable
 *  0b10..Shifter pin bidirectional output data
 *  0b11..Shifter pin output
 */
#define FLEXIO_SHIFTCTL_PINCFG(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_PINCFG_SHIFT)) & FLEXIO_SHIFTCTL_PINCFG_MASK)
#define FLEXIO_SHIFTCTL_TIMPOL_MASK              (0x800000U)
#define FLEXIO_SHIFTCTL_TIMPOL_SHIFT             (23U)
/*! TIMPOL - Timer Polarity
 *  0b0..Shift on posedge of Shift clock
 *  0b1..Shift on negedge of Shift clock
 */
#define FLEXIO_SHIFTCTL_TIMPOL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_TIMPOL_SHIFT)) & FLEXIO_SHIFTCTL_TIMPOL_MASK)
#define FLEXIO_SHIFTCTL_TIMSEL_MASK              (0x7000000U)
#define FLEXIO_SHIFTCTL_TIMSEL_SHIFT             (24U)
/*! TIMSEL - Timer Select
 */
#define FLEXIO_SHIFTCTL_TIMSEL(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCTL_TIMSEL_SHIFT)) & FLEXIO_SHIFTCTL_TIMSEL_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTCTL */
#define FLEXIO_SHIFTCTL_COUNT                    (8U)

/*! @name SHIFTCFG - Shifter Configuration N Register */
/*! @{ */
#define FLEXIO_SHIFTCFG_SSTART_MASK              (0x3U)
#define FLEXIO_SHIFTCFG_SSTART_SHIFT             (0U)
/*! SSTART - Shifter Start bit
 *  0b00..Start bit disabled for transmitter/receiver/match store, transmitter loads data on enable
 *  0b01..Start bit disabled for transmitter/receiver/match store, transmitter loads data on first shift
 *  0b10..Transmitter outputs start bit value 0 before loading data on first shift, receiver/match store sets error flag if start bit is not 0
 *  0b11..Transmitter outputs start bit value 1 before loading data on first shift, receiver/match store sets error flag if start bit is not 1
 */
#define FLEXIO_SHIFTCFG_SSTART(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSTART_SHIFT)) & FLEXIO_SHIFTCFG_SSTART_MASK)
#define FLEXIO_SHIFTCFG_SSTOP_MASK               (0x30U)
#define FLEXIO_SHIFTCFG_SSTOP_SHIFT              (4U)
/*! SSTOP - Shifter Stop bit
 *  0b00..Stop bit disabled for transmitter/receiver/match store
 *  0b01..Reserved for transmitter/receiver/match store
 *  0b10..Transmitter outputs stop bit value 0 on store, receiver/match store sets error flag if stop bit is not 0
 *  0b11..Transmitter outputs stop bit value 1 on store, receiver/match store sets error flag if stop bit is not 1
 */
#define FLEXIO_SHIFTCFG_SSTOP(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_SSTOP_SHIFT)) & FLEXIO_SHIFTCFG_SSTOP_MASK)
#define FLEXIO_SHIFTCFG_INSRC_MASK               (0x100U)
#define FLEXIO_SHIFTCFG_INSRC_SHIFT              (8U)
/*! INSRC - Input Source
 *  0b0..Pin
 *  0b1..Shifter N+1 Output
 */
#define FLEXIO_SHIFTCFG_INSRC(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_INSRC_SHIFT)) & FLEXIO_SHIFTCFG_INSRC_MASK)
#define FLEXIO_SHIFTCFG_LATST_MASK               (0x200U)
#define FLEXIO_SHIFTCFG_LATST_SHIFT              (9U)
/*! LATST - Late Store
 *  0b0..Shift register will store the pre-shift register state.
 *  0b1..Shift register will store the post-shift register state.
 */
#define FLEXIO_SHIFTCFG_LATST(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_LATST_SHIFT)) & FLEXIO_SHIFTCFG_LATST_MASK)
#define FLEXIO_SHIFTCFG_PWIDTH_MASK              (0xF0000U)
#define FLEXIO_SHIFTCFG_PWIDTH_SHIFT             (16U)
/*! PWIDTH - Parallel Width
 */
#define FLEXIO_SHIFTCFG_PWIDTH(x)                (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTCFG_PWIDTH_SHIFT)) & FLEXIO_SHIFTCFG_PWIDTH_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTCFG */
#define FLEXIO_SHIFTCFG_COUNT                    (8U)

/*! @name SHIFTBUF - Shifter Buffer N Register */
/*! @{ */
#define FLEXIO_SHIFTBUF_SHIFTBUF_MASK            (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUF_SHIFTBUF_SHIFT           (0U)
/*! SHIFTBUF - Shift Buffer
 */
#define FLEXIO_SHIFTBUF_SHIFTBUF(x)              (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUF_SHIFTBUF_SHIFT)) & FLEXIO_SHIFTBUF_SHIFTBUF_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUF */
#define FLEXIO_SHIFTBUF_COUNT                    (8U)

/*! @name SHIFTBUFBIS - Shifter Buffer N Bit Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_SHIFT     (0U)
/*! SHIFTBUFBIS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_SHIFT)) & FLEXIO_SHIFTBUFBIS_SHIFTBUFBIS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBIS */
#define FLEXIO_SHIFTBUFBIS_COUNT                 (8U)

/*! @name SHIFTBUFBYS - Shifter Buffer N Byte Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_SHIFT     (0U)
/*! SHIFTBUFBYS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_SHIFT)) & FLEXIO_SHIFTBUFBYS_SHIFTBUFBYS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBYS */
#define FLEXIO_SHIFTBUFBYS_COUNT                 (8U)

/*! @name SHIFTBUFBBS - Shifter Buffer N Bit Byte Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_SHIFT     (0U)
/*! SHIFTBUFBBS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_SHIFT)) & FLEXIO_SHIFTBUFBBS_SHIFTBUFBBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFBBS */
#define FLEXIO_SHIFTBUFBBS_COUNT                 (8U)

/*! @name TIMCTL - Timer Control N Register */
/*! @{ */
#define FLEXIO_TIMCTL_TIMOD_MASK                 (0x7U)
#define FLEXIO_TIMCTL_TIMOD_SHIFT                (0U)
/*! TIMOD - Timer Mode
 *  0b000..Timer Disabled.
 *  0b001..Dual 8-bit counters baud mode.
 *  0b010..Dual 8-bit counters PWM high mode.
 *  0b011..Single 16-bit counter mode.
 *  0b100..Single 16-bit counter disable mode.
 *  0b101..Dual 8-bit counters word mode.
 *  0b110..Dual 8-bit counters PWM low mode.
 *  0b111..Single 16-bit input capture mode.
 */
#define FLEXIO_TIMCTL_TIMOD(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TIMOD_SHIFT)) & FLEXIO_TIMCTL_TIMOD_MASK)
#define FLEXIO_TIMCTL_ONETIM_MASK                (0x20U)
#define FLEXIO_TIMCTL_ONETIM_SHIFT               (5U)
/*! ONETIM - Timer One Time Operation
 *  0b0..The timer enable event is generated as normal.
 *  0b1..The timer enable event is blocked unless timer status flag is clear.
 */
#define FLEXIO_TIMCTL_ONETIM(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_ONETIM_SHIFT)) & FLEXIO_TIMCTL_ONETIM_MASK)
#define FLEXIO_TIMCTL_PININS_MASK                (0x40U)
#define FLEXIO_TIMCTL_PININS_SHIFT               (6U)
/*! PININS - Timer Pin Input Select
 *  0b0..Timer pin input and output are selected by PINSEL.
 *  0b1..Timer pin input is selected by PINSEL+1, timer pin output remains selected by PINSEL.
 */
#define FLEXIO_TIMCTL_PININS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PININS_SHIFT)) & FLEXIO_TIMCTL_PININS_MASK)
#define FLEXIO_TIMCTL_PINPOL_MASK                (0x80U)
#define FLEXIO_TIMCTL_PINPOL_SHIFT               (7U)
/*! PINPOL - Timer Pin Polarity
 *  0b0..Pin is active high
 *  0b1..Pin is active low
 */
#define FLEXIO_TIMCTL_PINPOL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINPOL_SHIFT)) & FLEXIO_TIMCTL_PINPOL_MASK)
#define FLEXIO_TIMCTL_PINSEL_MASK                (0xF00U)
#define FLEXIO_TIMCTL_PINSEL_SHIFT               (8U)
/*! PINSEL - Timer Pin Select
 */
#define FLEXIO_TIMCTL_PINSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINSEL_SHIFT)) & FLEXIO_TIMCTL_PINSEL_MASK)
#define FLEXIO_TIMCTL_PINCFG_MASK                (0x30000U)
#define FLEXIO_TIMCTL_PINCFG_SHIFT               (16U)
/*! PINCFG - Timer Pin Configuration
 *  0b00..Timer pin output disabled
 *  0b01..Timer pin open drain or bidirectional output enable
 *  0b10..Timer pin bidirectional output data
 *  0b11..Timer pin output
 */
#define FLEXIO_TIMCTL_PINCFG(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_PINCFG_SHIFT)) & FLEXIO_TIMCTL_PINCFG_MASK)
#define FLEXIO_TIMCTL_TRGSRC_MASK                (0x400000U)
#define FLEXIO_TIMCTL_TRGSRC_SHIFT               (22U)
/*! TRGSRC - Trigger Source
 *  0b0..External trigger selected
 *  0b1..Internal trigger selected
 */
#define FLEXIO_TIMCTL_TRGSRC(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGSRC_SHIFT)) & FLEXIO_TIMCTL_TRGSRC_MASK)
#define FLEXIO_TIMCTL_TRGPOL_MASK                (0x800000U)
#define FLEXIO_TIMCTL_TRGPOL_SHIFT               (23U)
/*! TRGPOL - Trigger Polarity
 *  0b0..Trigger active high
 *  0b1..Trigger active low
 */
#define FLEXIO_TIMCTL_TRGPOL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGPOL_SHIFT)) & FLEXIO_TIMCTL_TRGPOL_MASK)
#define FLEXIO_TIMCTL_TRGSEL_MASK                (0x1F000000U)
#define FLEXIO_TIMCTL_TRGSEL_SHIFT               (24U)
/*! TRGSEL - Trigger Select
 */
#define FLEXIO_TIMCTL_TRGSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCTL_TRGSEL_SHIFT)) & FLEXIO_TIMCTL_TRGSEL_MASK)
/*! @} */

/* The count of FLEXIO_TIMCTL */
#define FLEXIO_TIMCTL_COUNT                      (8U)

/*! @name TIMCFG - Timer Configuration N Register */
/*! @{ */
#define FLEXIO_TIMCFG_TSTART_MASK                (0x2U)
#define FLEXIO_TIMCFG_TSTART_SHIFT               (1U)
/*! TSTART - Timer Start Bit
 *  0b0..Start bit disabled
 *  0b1..Start bit enabled
 */
#define FLEXIO_TIMCFG_TSTART(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TSTART_SHIFT)) & FLEXIO_TIMCFG_TSTART_MASK)
#define FLEXIO_TIMCFG_TSTOP_MASK                 (0x30U)
#define FLEXIO_TIMCFG_TSTOP_SHIFT                (4U)
/*! TSTOP - Timer Stop Bit
 *  0b00..Stop bit disabled
 *  0b01..Stop bit is enabled on timer compare
 *  0b10..Stop bit is enabled on timer disable
 *  0b11..Stop bit is enabled on timer compare and timer disable
 */
#define FLEXIO_TIMCFG_TSTOP(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TSTOP_SHIFT)) & FLEXIO_TIMCFG_TSTOP_MASK)
#define FLEXIO_TIMCFG_TIMENA_MASK                (0x700U)
#define FLEXIO_TIMCFG_TIMENA_SHIFT               (8U)
/*! TIMENA - Timer Enable
 *  0b000..Timer always enabled
 *  0b001..Timer enabled on Timer N-1 enable
 *  0b010..Timer enabled on Trigger high
 *  0b011..Timer enabled on Trigger high and Pin high
 *  0b100..Timer enabled on Pin rising edge
 *  0b101..Timer enabled on Pin rising edge and Trigger high
 *  0b110..Timer enabled on Trigger rising edge
 *  0b111..Timer enabled on Trigger rising or falling edge
 */
#define FLEXIO_TIMCFG_TIMENA(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMENA_SHIFT)) & FLEXIO_TIMCFG_TIMENA_MASK)
#define FLEXIO_TIMCFG_TIMDIS_MASK                (0x7000U)
#define FLEXIO_TIMCFG_TIMDIS_SHIFT               (12U)
/*! TIMDIS - Timer Disable
 *  0b000..Timer never disabled
 *  0b001..Timer disabled on Timer N-1 disable
 *  0b010..Timer disabled on Timer compare (upper 8-bits match and decrement)
 *  0b011..Timer disabled on Timer compare (upper 8-bits match and decrement) and Trigger Low
 *  0b100..Timer disabled on Pin rising or falling edge
 *  0b101..Timer disabled on Pin rising or falling edge provided Trigger is high
 *  0b110..Timer disabled on Trigger falling edge
 *  0b111..Reserved
 */
#define FLEXIO_TIMCFG_TIMDIS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMDIS_SHIFT)) & FLEXIO_TIMCFG_TIMDIS_MASK)
#define FLEXIO_TIMCFG_TIMRST_MASK                (0x70000U)
#define FLEXIO_TIMCFG_TIMRST_SHIFT               (16U)
/*! TIMRST - Timer Reset
 *  0b000..Timer never reset
 *  0b001..Timer reset on Timer Output high.
 *  0b010..Timer reset on Timer Pin equal to Timer Output
 *  0b011..Timer reset on Timer Trigger equal to Timer Output
 *  0b100..Timer reset on Timer Pin rising edge
 *  0b101..Reserved
 *  0b110..Timer reset on Trigger rising edge
 *  0b111..Timer reset on Trigger rising or falling edge
 */
#define FLEXIO_TIMCFG_TIMRST(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMRST_SHIFT)) & FLEXIO_TIMCFG_TIMRST_MASK)
#define FLEXIO_TIMCFG_TIMDEC_MASK                (0x700000U)
#define FLEXIO_TIMCFG_TIMDEC_SHIFT               (20U)
/*! TIMDEC - Timer Decrement
 *  0b000..Decrement counter on FlexIO clock, Shift clock equals Timer output.
 *  0b001..Decrement counter on Trigger input (both edges), Shift clock equals Timer output.
 *  0b010..Decrement counter on Pin input (both edges), Shift clock equals Pin input.
 *  0b011..Decrement counter on Trigger input (both edges), Shift clock equals Trigger input.
 *  0b100..Decrement counter on FlexIO clock divided by 16, Shift clock equals Timer output.
 *  0b101..Decrement counter on FlexIO clock divided by 256, Shift clock equals Timer output.
 *  0b110..Decrement counter on Pin input (rising edge), Shift clock equals Pin input.
 *  0b111..Decrement counter on Trigger input (rising edge), Shift clock equals Trigger input.
 */
#define FLEXIO_TIMCFG_TIMDEC(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMDEC_SHIFT)) & FLEXIO_TIMCFG_TIMDEC_MASK)
#define FLEXIO_TIMCFG_TIMOUT_MASK                (0x3000000U)
#define FLEXIO_TIMCFG_TIMOUT_SHIFT               (24U)
/*! TIMOUT - Timer Output
 *  0b00..Timer output is logic one when enabled and is not affected by timer reset
 *  0b01..Timer output is logic zero when enabled and is not affected by timer reset
 *  0b10..Timer output is logic one when enabled and on timer reset
 *  0b11..Timer output is logic zero when enabled and on timer reset
 */
#define FLEXIO_TIMCFG_TIMOUT(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCFG_TIMOUT_SHIFT)) & FLEXIO_TIMCFG_TIMOUT_MASK)
/*! @} */

/* The count of FLEXIO_TIMCFG */
#define FLEXIO_TIMCFG_COUNT                      (8U)

/*! @name TIMCMP - Timer Compare N Register */
/*! @{ */
#define FLEXIO_TIMCMP_CMP_MASK                   (0xFFFFU)
#define FLEXIO_TIMCMP_CMP_SHIFT                  (0U)
/*! CMP - Timer Compare Value
 */
#define FLEXIO_TIMCMP_CMP(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXIO_TIMCMP_CMP_SHIFT)) & FLEXIO_TIMCMP_CMP_MASK)
/*! @} */

/* The count of FLEXIO_TIMCMP */
#define FLEXIO_TIMCMP_COUNT                      (8U)

/*! @name SHIFTBUFNBS - Shifter Buffer N Nibble Byte Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_SHIFT     (0U)
/*! SHIFTBUFNBS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_SHIFT)) & FLEXIO_SHIFTBUFNBS_SHIFTBUFNBS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFNBS */
#define FLEXIO_SHIFTBUFNBS_COUNT                 (8U)

/*! @name SHIFTBUFHWS - Shifter Buffer N Half Word Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_SHIFT     (0U)
/*! SHIFTBUFHWS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_SHIFT)) & FLEXIO_SHIFTBUFHWS_SHIFTBUFHWS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFHWS */
#define FLEXIO_SHIFTBUFHWS_COUNT                 (8U)

/*! @name SHIFTBUFNIS - Shifter Buffer N Nibble Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_SHIFT     (0U)
/*! SHIFTBUFNIS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_SHIFT)) & FLEXIO_SHIFTBUFNIS_SHIFTBUFNIS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFNIS */
#define FLEXIO_SHIFTBUFNIS_COUNT                 (8U)

/*! @name SHIFTBUFOES - Shifter Buffer N Odd Even Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES_SHIFT     (0U)
/*! SHIFTBUFOES - Shift Buffer
 */
#define FLEXIO_SHIFTBUFOES_SHIFTBUFOES(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFOES_SHIFTBUFOES_SHIFT)) & FLEXIO_SHIFTBUFOES_SHIFTBUFOES_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFOES */
#define FLEXIO_SHIFTBUFOES_COUNT                 (8U)

/*! @name SHIFTBUFEOS - Shifter Buffer N Even Odd Swapped Register */
/*! @{ */
#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_MASK      (0xFFFFFFFFU)
#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_SHIFT     (0U)
/*! SHIFTBUFEOS - Shift Buffer
 */
#define FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS(x)        (((uint32_t)(((uint32_t)(x)) << FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_SHIFT)) & FLEXIO_SHIFTBUFEOS_SHIFTBUFEOS_MASK)
/*! @} */

/* The count of FLEXIO_SHIFTBUFEOS */
#define FLEXIO_SHIFTBUFEOS_COUNT                 (8U)


/*!
 * @}
 */ /* end of group FLEXIO_Register_Masks */


/* FLEXIO - Peripheral instance base addresses */
/** Peripheral FLEXIO0 base address */
#define FLEXIO0_BASE                             (0x40032000u)
/** Peripheral FLEXIO0 base pointer */
#define FLEXIO0                                  ((FLEXIO_Type *)FLEXIO0_BASE)
/** Array initializer of FLEXIO peripheral base addresses */
#define FLEXIO_BASE_ADDRS                        { FLEXIO0_BASE }
/** Array initializer of FLEXIO peripheral base pointers */
#define FLEXIO_BASE_PTRS                         { FLEXIO0 }

/*!
 * @}
 */ /* end of group FLEXIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FLEXSPI Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXSPI_Peripheral_Access_Layer FLEXSPI Peripheral Access Layer
 * @{
 */

/** FLEXSPI - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCR0;                              /**< Module Control Register 0, offset: 0x0 */
  __IO uint32_t MCR1;                              /**< Module Control Register 1, offset: 0x4 */
  __IO uint32_t MCR2;                              /**< Module Control Register 2, offset: 0x8 */
  __IO uint32_t AHBCR;                             /**< AHB Bus Control Register, offset: 0xC */
  __IO uint32_t INTEN;                             /**< Interrupt Enable Register, offset: 0x10 */
  __IO uint32_t INTR;                              /**< Interrupt Register, offset: 0x14 */
  __IO uint32_t LUTKEY;                            /**< LUT Key Register, offset: 0x18 */
  __IO uint32_t LUTCR;                             /**< LUT Control Register, offset: 0x1C */
  __IO uint32_t AHBRXBUFCR0[8];                    /**< AHB RX Buffer 0 Control Register 0..AHB RX Buffer 7 Control Register 0, array offset: 0x20, array step: 0x4 */
       uint8_t RESERVED_0[32];
  __IO uint32_t FLSHCR0[4];                        /**< Flash Control Register 0, array offset: 0x60, array step: 0x4 */
  __IO uint32_t FLSHCR1[4];                        /**< Flash Control Register 1, array offset: 0x70, array step: 0x4 */
  __IO uint32_t FLSHCR2[4];                        /**< Flash Control Register 2, array offset: 0x80, array step: 0x4 */
       uint8_t RESERVED_1[4];
  __IO uint32_t FLSHCR4;                           /**< Flash Control Register 4, offset: 0x94 */
       uint8_t RESERVED_2[8];
  __IO uint32_t IPCR0;                             /**< IP Control Register 0, offset: 0xA0 */
  __IO uint32_t IPCR1;                             /**< IP Control Register 1, offset: 0xA4 */
       uint8_t RESERVED_3[8];
  __IO uint32_t IPCMD;                             /**< IP Command Register, offset: 0xB0 */
  __IO uint32_t DLPR;                              /**< Data Learn Pattern Register, offset: 0xB4 */
  __IO uint32_t IPRXFCR;                           /**< IP RX FIFO Control Register, offset: 0xB8 */
  __IO uint32_t IPTXFCR;                           /**< IP TX FIFO Control Register, offset: 0xBC */
  __IO uint32_t DLLCR[2];                          /**< DLL Control Register 0, array offset: 0xC0, array step: 0x4 */
       uint8_t RESERVED_4[24];
  __I  uint32_t STS0;                              /**< Status Register 0, offset: 0xE0 */
  __I  uint32_t STS1;                              /**< Status Register 1, offset: 0xE4 */
  __I  uint32_t STS2;                              /**< Status Register 2, offset: 0xE8 */
  __I  uint32_t AHBSPNDSTS;                        /**< AHB Suspend Status Register, offset: 0xEC */
  __I  uint32_t IPRXFSTS;                          /**< IP RX FIFO Status Register, offset: 0xF0 */
  __I  uint32_t IPTXFSTS;                          /**< IP TX FIFO Status Register, offset: 0xF4 */
       uint8_t RESERVED_5[8];
  __I  uint32_t RFDR[32];                          /**< IP RX FIFO Data Register 0..IP RX FIFO Data Register 31, array offset: 0x100, array step: 0x4 */
  __O  uint32_t TFDR[32];                          /**< IP TX FIFO Data Register 0..IP TX FIFO Data Register 31, array offset: 0x180, array step: 0x4 */
  __IO uint32_t LUT[64];                           /**< LUT 0..LUT 63, array offset: 0x200, array step: 0x4 */
} FLEXSPI_Type;

/* ----------------------------------------------------------------------------
   -- FLEXSPI Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FLEXSPI_Register_Masks FLEXSPI Register Masks
 * @{
 */

/*! @name MCR0 - Module Control Register 0 */
/*! @{ */
#define FLEXSPI_MCR0_SWRESET_MASK                (0x1U)
#define FLEXSPI_MCR0_SWRESET_SHIFT               (0U)
/*! SWRESET - Software Reset
 */
#define FLEXSPI_MCR0_SWRESET(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_SWRESET_SHIFT)) & FLEXSPI_MCR0_SWRESET_MASK)
#define FLEXSPI_MCR0_MDIS_MASK                   (0x2U)
#define FLEXSPI_MCR0_MDIS_SHIFT                  (1U)
/*! MDIS - Module Disable
 */
#define FLEXSPI_MCR0_MDIS(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_MDIS_SHIFT)) & FLEXSPI_MCR0_MDIS_MASK)
#define FLEXSPI_MCR0_RXCLKSRC_MASK               (0x30U)
#define FLEXSPI_MCR0_RXCLKSRC_SHIFT              (4U)
/*! RXCLKSRC - Sample Clock source selection for Flash Reading
 *  0b00..Dummy Read strobe generated by FlexSPI Controller and loopback internally.
 *  0b01..Dummy Read strobe generated by FlexSPI Controller and loopback from DQS pad.
 *  0b10..Reserved
 *  0b11..Flash provided Read strobe and input from DQS pad
 */
#define FLEXSPI_MCR0_RXCLKSRC(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_RXCLKSRC_SHIFT)) & FLEXSPI_MCR0_RXCLKSRC_MASK)
#define FLEXSPI_MCR0_SERCLKDIV_MASK              (0x700U)
#define FLEXSPI_MCR0_SERCLKDIV_SHIFT             (8U)
/*! SERCLKDIV - The serial root clock could be divided inside FlexSPI wrapper. Refer Clocks chapter for more details on clocking.
 *  0b000..Divided by 1
 *  0b001..Divided by 2
 *  0b010..Divided by 3
 *  0b011..Divided by 4
 *  0b100..Divided by 5
 *  0b101..Divided by 6
 *  0b110..Divided by 7
 *  0b111..Divided by 8
 */
#define FLEXSPI_MCR0_SERCLKDIV(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_SERCLKDIV_SHIFT)) & FLEXSPI_MCR0_SERCLKDIV_MASK)
#define FLEXSPI_MCR0_HSEN_MASK                   (0x800U)
#define FLEXSPI_MCR0_HSEN_SHIFT                  (11U)
/*! HSEN - Half Speed Serial Flash access Enable.
 *  0b0..Disable divide by 2 of serial flash clock for half speed commands.
 *  0b1..Enable divide by 2 of serial flash clock for half speed commands.
 */
#define FLEXSPI_MCR0_HSEN(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_HSEN_SHIFT)) & FLEXSPI_MCR0_HSEN_MASK)
#define FLEXSPI_MCR0_DOZEEN_MASK                 (0x1000U)
#define FLEXSPI_MCR0_DOZEEN_SHIFT                (12U)
/*! DOZEEN - Doze mode enable bit
 *  0b0..Doze mode support disabled. AHB clock and serial clock will not be gated off when there is doze mode request from system.
 *  0b1..Doze mode support enabled. AHB clock and serial clock will be gated off when there is doze mode request from system.
 */
#define FLEXSPI_MCR0_DOZEEN(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_DOZEEN_SHIFT)) & FLEXSPI_MCR0_DOZEEN_MASK)
#define FLEXSPI_MCR0_COMBINATIONEN_MASK          (0x2000U)
#define FLEXSPI_MCR0_COMBINATIONEN_SHIFT         (13U)
/*! COMBINATIONEN - This bit is to support Flash Octal mode access by combining Port A and B Data pins (A_DATA[3:0] and B_DATA[3:0]).
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define FLEXSPI_MCR0_COMBINATIONEN(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_COMBINATIONEN_SHIFT)) & FLEXSPI_MCR0_COMBINATIONEN_MASK)
#define FLEXSPI_MCR0_SCKFREERUNEN_MASK           (0x4000U)
#define FLEXSPI_MCR0_SCKFREERUNEN_SHIFT          (14U)
/*! SCKFREERUNEN - This bit is used to force SCLK output free-running. For FPGA applications,
 *    external device may use SCLK as reference clock to its internal PLL. If SCLK free-running is
 *    enabled, data sampling with loopback clock from SCLK pad is not supported (MCR0[RXCLKSRC]=2).
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define FLEXSPI_MCR0_SCKFREERUNEN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_SCKFREERUNEN_SHIFT)) & FLEXSPI_MCR0_SCKFREERUNEN_MASK)
#define FLEXSPI_MCR0_LEARNEN_MASK                (0x8000U)
#define FLEXSPI_MCR0_LEARNEN_SHIFT               (15U)
/*! LEARNEN - This bit is used to enable/disable data learning feature. When data learning is
 *    disabled, the sampling clock phase 0 is always used for RX data sampling even if LEARN instruction
 *    is correctly executed.
 *  0b0..Disable.
 *  0b1..Enable.
 */
#define FLEXSPI_MCR0_LEARNEN(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_LEARNEN_SHIFT)) & FLEXSPI_MCR0_LEARNEN_MASK)
#define FLEXSPI_MCR0_IPGRANTWAIT_MASK            (0xFF0000U)
#define FLEXSPI_MCR0_IPGRANTWAIT_SHIFT           (16U)
/*! IPGRANTWAIT - Time out wait cycle for IP command grant.
 */
#define FLEXSPI_MCR0_IPGRANTWAIT(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_IPGRANTWAIT_SHIFT)) & FLEXSPI_MCR0_IPGRANTWAIT_MASK)
#define FLEXSPI_MCR0_AHBGRANTWAIT_MASK           (0xFF000000U)
#define FLEXSPI_MCR0_AHBGRANTWAIT_SHIFT          (24U)
/*! AHBGRANTWAIT - Timeout wait cycle for AHB command grant.
 */
#define FLEXSPI_MCR0_AHBGRANTWAIT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR0_AHBGRANTWAIT_SHIFT)) & FLEXSPI_MCR0_AHBGRANTWAIT_MASK)
/*! @} */

/*! @name MCR1 - Module Control Register 1 */
/*! @{ */
#define FLEXSPI_MCR1_AHBBUSWAIT_MASK             (0xFFFFU)
#define FLEXSPI_MCR1_AHBBUSWAIT_SHIFT            (0U)
#define FLEXSPI_MCR1_AHBBUSWAIT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR1_AHBBUSWAIT_SHIFT)) & FLEXSPI_MCR1_AHBBUSWAIT_MASK)
#define FLEXSPI_MCR1_SEQWAIT_MASK                (0xFFFF0000U)
#define FLEXSPI_MCR1_SEQWAIT_SHIFT               (16U)
#define FLEXSPI_MCR1_SEQWAIT(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR1_SEQWAIT_SHIFT)) & FLEXSPI_MCR1_SEQWAIT_MASK)
/*! @} */

/*! @name MCR2 - Module Control Register 2 */
/*! @{ */
#define FLEXSPI_MCR2_CLRAHBBUFOPT_MASK           (0x800U)
#define FLEXSPI_MCR2_CLRAHBBUFOPT_SHIFT          (11U)
/*! CLRAHBBUFOPT - This bit determines whether AHB RX Buffer and AHB TX Buffer will be cleaned
 *    automatically when FlexSPI returns STOP mode ACK. Software should set this bit if AHB RX Buffer or
 *    AHB TX Buffer will be powered off in STOP mode. Otherwise AHB read access after exiting STOP
 *    mode may hit AHB RX Buffer or AHB TX Buffer but their data entries are invalid.
 *  0b0..AHB RX/TX Buffer will not be cleaned automatically when FlexSPI return Stop mode ACK.
 *  0b1..AHB RX/TX Buffer will be cleaned automatically when FlexSPI return Stop mode ACK.
 */
#define FLEXSPI_MCR2_CLRAHBBUFOPT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_CLRAHBBUFOPT_SHIFT)) & FLEXSPI_MCR2_CLRAHBBUFOPT_MASK)
#define FLEXSPI_MCR2_CLRLEARNPHASE_MASK          (0x4000U)
#define FLEXSPI_MCR2_CLRLEARNPHASE_SHIFT         (14U)
/*! CLRLEARNPHASE - The sampling clock phase selection will be reset to phase 0 when this bit is
 *    written with 0x1. This bit will be auto-cleared immediately.
 */
#define FLEXSPI_MCR2_CLRLEARNPHASE(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_CLRLEARNPHASE_SHIFT)) & FLEXSPI_MCR2_CLRLEARNPHASE_MASK)
#define FLEXSPI_MCR2_SAMEDEVICEEN_MASK           (0x8000U)
#define FLEXSPI_MCR2_SAMEDEVICEEN_SHIFT          (15U)
/*! SAMEDEVICEEN - All external devices are same devices (both in types and size) for A1/A2/B1/B2.
 *  0b0..In Individual mode, FLSHA1CRx/FLSHA2CRx/FLSHB1CRx/FLSHB2CRx register setting will be applied to Flash
 *       A1/A2/B1/B2 separately. In Parallel mode, FLSHA1CRx register setting will be applied to Flash A1 and B1,
 *       FLSHA2CRx register setting will be applied to Flash A2 and B2. FLSHB1CRx/FLSHB2CRx register settings will be
 *       ignored.
 *  0b1..FLSHA1CR0/FLSHA1CR1/FLSHA1CR2 register settings will be applied to Flash A1/A2/B1/B2. FLSHA2CRx/FLSHB1CRx/FLSHB2CRx will be ignored.
 */
#define FLEXSPI_MCR2_SAMEDEVICEEN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_SAMEDEVICEEN_SHIFT)) & FLEXSPI_MCR2_SAMEDEVICEEN_MASK)
#define FLEXSPI_MCR2_SCKBDIFFOPT_MASK            (0x80000U)
#define FLEXSPI_MCR2_SCKBDIFFOPT_SHIFT           (19U)
/*! SCKBDIFFOPT - B_SCLK pad can be used as A_SCLK differential clock output (inverted clock to
 *    A_SCLK). In this case, port B flash access is not available. After changing the value of this
 *    field, MCR0[SWRESET] should be set.
 *  0b1..B_SCLK pad is used as port A SCLK inverted clock output (Differential clock to A_SCLK). Port B flash access is not available.
 *  0b0..B_SCLK pad is used as port B SCLK clock output. Port B flash access is available.
 */
#define FLEXSPI_MCR2_SCKBDIFFOPT(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_SCKBDIFFOPT_SHIFT)) & FLEXSPI_MCR2_SCKBDIFFOPT_MASK)
#define FLEXSPI_MCR2_RESUMEWAIT_MASK             (0xFF000000U)
#define FLEXSPI_MCR2_RESUMEWAIT_SHIFT            (24U)
/*! RESUMEWAIT - Wait cycle (in AHB clock cycle) for idle state before suspended command sequence resumed.
 */
#define FLEXSPI_MCR2_RESUMEWAIT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_MCR2_RESUMEWAIT_SHIFT)) & FLEXSPI_MCR2_RESUMEWAIT_MASK)
/*! @} */

/*! @name AHBCR - AHB Bus Control Register */
/*! @{ */
#define FLEXSPI_AHBCR_APAREN_MASK                (0x1U)
#define FLEXSPI_AHBCR_APAREN_SHIFT               (0U)
/*! APAREN - Parallel mode enabled for AHB triggered Command (both read and write) .
 *  0b0..Flash will be accessed in Individual mode.
 *  0b1..Flash will be accessed in Parallel mode.
 */
#define FLEXSPI_AHBCR_APAREN(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_APAREN_SHIFT)) & FLEXSPI_AHBCR_APAREN_MASK)
#define FLEXSPI_AHBCR_CACHABLEEN_MASK            (0x8U)
#define FLEXSPI_AHBCR_CACHABLEEN_SHIFT           (3U)
/*! CACHABLEEN - Enable AHB bus cachable read access support.
 *  0b0..Disabled. When there is AHB bus cachable read access, FlexSPI will not check whether it hit AHB TX Buffer.
 *  0b1..Enabled. When there is AHB bus cachable read access, FlexSPI will check whether it hit AHB TX Buffer first.
 */
#define FLEXSPI_AHBCR_CACHABLEEN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_CACHABLEEN_SHIFT)) & FLEXSPI_AHBCR_CACHABLEEN_MASK)
#define FLEXSPI_AHBCR_BUFFERABLEEN_MASK          (0x10U)
#define FLEXSPI_AHBCR_BUFFERABLEEN_SHIFT         (4U)
/*! BUFFERABLEEN - Enable AHB bus bufferable write access support. This field affects the last beat
 *    of AHB write access, refer for more details about AHB bufferable write.
 *  0b0..Disabled. For all AHB write access (no matter bufferable or non-bufferable ), FlexSPI will return AHB Bus
 *       ready after all data is transmitted to External device and AHB command finished.
 *  0b1..Enabled. For AHB bufferable write access, FlexSPI will return AHB Bus ready when the AHB command is
 *       granted by arbitrator and will not wait for AHB command finished.
 */
#define FLEXSPI_AHBCR_BUFFERABLEEN(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_BUFFERABLEEN_SHIFT)) & FLEXSPI_AHBCR_BUFFERABLEEN_MASK)
#define FLEXSPI_AHBCR_PREFETCHEN_MASK            (0x20U)
#define FLEXSPI_AHBCR_PREFETCHEN_SHIFT           (5U)
/*! PREFETCHEN - AHB Read Prefetch Enable.
 */
#define FLEXSPI_AHBCR_PREFETCHEN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_PREFETCHEN_SHIFT)) & FLEXSPI_AHBCR_PREFETCHEN_MASK)
#define FLEXSPI_AHBCR_READADDROPT_MASK           (0x40U)
#define FLEXSPI_AHBCR_READADDROPT_SHIFT          (6U)
/*! READADDROPT - AHB Read Address option bit. This option bit is intend to remove AHB burst start address alignment limitation.
 *  0b0..There is AHB read burst start address alignment limitation when flash is accessed in parallel mode or flash is wordaddressable.
 *  0b1..There is no AHB read burst start address alignment limitation. FlexSPI will fetch more data than AHB
 *       burst required to meet the alignment requirement.
 */
#define FLEXSPI_AHBCR_READADDROPT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_READADDROPT_SHIFT)) & FLEXSPI_AHBCR_READADDROPT_MASK)
#define FLEXSPI_AHBCR_READSZALIGN_MASK           (0x400U)
#define FLEXSPI_AHBCR_READSZALIGN_SHIFT          (10U)
/*! READSZALIGN - AHB Read Size Alignment
 *  0b0..AHB read size will be decided by other register setting like PREFETCH_EN,OTFAD_EN...
 *  0b1..AHB read size to up size to 8 bytes aligned, no prefetching
 */
#define FLEXSPI_AHBCR_READSZALIGN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBCR_READSZALIGN_SHIFT)) & FLEXSPI_AHBCR_READSZALIGN_MASK)
/*! @} */

/*! @name INTEN - Interrupt Enable Register */
/*! @{ */
#define FLEXSPI_INTEN_IPCMDDONEEN_MASK           (0x1U)
#define FLEXSPI_INTEN_IPCMDDONEEN_SHIFT          (0U)
/*! IPCMDDONEEN - IP triggered Command Sequences Execution finished interrupt enable.
 */
#define FLEXSPI_INTEN_IPCMDDONEEN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPCMDDONEEN_SHIFT)) & FLEXSPI_INTEN_IPCMDDONEEN_MASK)
#define FLEXSPI_INTEN_IPCMDGEEN_MASK             (0x2U)
#define FLEXSPI_INTEN_IPCMDGEEN_SHIFT            (1U)
/*! IPCMDGEEN - IP triggered Command Sequences Grant Timeout interrupt enable.
 */
#define FLEXSPI_INTEN_IPCMDGEEN(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPCMDGEEN_SHIFT)) & FLEXSPI_INTEN_IPCMDGEEN_MASK)
#define FLEXSPI_INTEN_AHBCMDGEEN_MASK            (0x4U)
#define FLEXSPI_INTEN_AHBCMDGEEN_SHIFT           (2U)
/*! AHBCMDGEEN - AHB triggered Command Sequences Grant Timeout interrupt enable.
 */
#define FLEXSPI_INTEN_AHBCMDGEEN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBCMDGEEN_SHIFT)) & FLEXSPI_INTEN_AHBCMDGEEN_MASK)
#define FLEXSPI_INTEN_IPCMDERREN_MASK            (0x8U)
#define FLEXSPI_INTEN_IPCMDERREN_SHIFT           (3U)
/*! IPCMDERREN - IP triggered Command Sequences Error Detected interrupt enable.
 */
#define FLEXSPI_INTEN_IPCMDERREN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPCMDERREN_SHIFT)) & FLEXSPI_INTEN_IPCMDERREN_MASK)
#define FLEXSPI_INTEN_AHBCMDERREN_MASK           (0x10U)
#define FLEXSPI_INTEN_AHBCMDERREN_SHIFT          (4U)
/*! AHBCMDERREN - AHB triggered Command Sequences Error Detected interrupt enable.
 */
#define FLEXSPI_INTEN_AHBCMDERREN(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBCMDERREN_SHIFT)) & FLEXSPI_INTEN_AHBCMDERREN_MASK)
#define FLEXSPI_INTEN_IPRXWAEN_MASK              (0x20U)
#define FLEXSPI_INTEN_IPRXWAEN_SHIFT             (5U)
/*! IPRXWAEN - IP RX FIFO WaterMark available interrupt enable.
 */
#define FLEXSPI_INTEN_IPRXWAEN(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPRXWAEN_SHIFT)) & FLEXSPI_INTEN_IPRXWAEN_MASK)
#define FLEXSPI_INTEN_IPTXWEEN_MASK              (0x40U)
#define FLEXSPI_INTEN_IPTXWEEN_SHIFT             (6U)
/*! IPTXWEEN - IP TX FIFO WaterMark empty interrupt enable.
 */
#define FLEXSPI_INTEN_IPTXWEEN(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_IPTXWEEN_SHIFT)) & FLEXSPI_INTEN_IPTXWEEN_MASK)
#define FLEXSPI_INTEN_DATALEARNFAILEN_MASK       (0x80U)
#define FLEXSPI_INTEN_DATALEARNFAILEN_SHIFT      (7U)
/*! DATALEARNFAILEN - Data Learning failed interrupt enable.
 */
#define FLEXSPI_INTEN_DATALEARNFAILEN(x)         (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_DATALEARNFAILEN_SHIFT)) & FLEXSPI_INTEN_DATALEARNFAILEN_MASK)
#define FLEXSPI_INTEN_SCKSTOPBYRDEN_MASK         (0x100U)
#define FLEXSPI_INTEN_SCKSTOPBYRDEN_SHIFT        (8U)
/*! SCKSTOPBYRDEN - SCLK is stopped during command sequence because Async RX FIFO full interrupt enable.
 */
#define FLEXSPI_INTEN_SCKSTOPBYRDEN(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_SCKSTOPBYRDEN_SHIFT)) & FLEXSPI_INTEN_SCKSTOPBYRDEN_MASK)
#define FLEXSPI_INTEN_SCKSTOPBYWREN_MASK         (0x200U)
#define FLEXSPI_INTEN_SCKSTOPBYWREN_SHIFT        (9U)
/*! SCKSTOPBYWREN - SCLK is stopped during command sequence because Async TX FIFO empty interrupt enable.
 */
#define FLEXSPI_INTEN_SCKSTOPBYWREN(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_SCKSTOPBYWREN_SHIFT)) & FLEXSPI_INTEN_SCKSTOPBYWREN_MASK)
#define FLEXSPI_INTEN_AHBBUSERROREN_MASK         (0x400U)
#define FLEXSPI_INTEN_AHBBUSERROREN_SHIFT        (10U)
/*! AHBBUSERROREN - AHB Bus error interrupt enable.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTEN_AHBBUSERROREN(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBBUSERROREN_SHIFT)) & FLEXSPI_INTEN_AHBBUSERROREN_MASK)
#define FLEXSPI_INTEN_AHBBUSTIMEOUTEN_MASK       (0x400U)
#define FLEXSPI_INTEN_AHBBUSTIMEOUTEN_SHIFT      (10U)
/*! AHBBUSTIMEOUTEN - AHB Bus timeout interrupt.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTEN_AHBBUSTIMEOUTEN(x)         (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_AHBBUSTIMEOUTEN_SHIFT)) & FLEXSPI_INTEN_AHBBUSTIMEOUTEN_MASK)
#define FLEXSPI_INTEN_SEQTIMEOUTEN_MASK          (0x800U)
#define FLEXSPI_INTEN_SEQTIMEOUTEN_SHIFT         (11U)
/*! SEQTIMEOUTEN - Sequence execution timeout interrupt enable.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTEN_SEQTIMEOUTEN(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_SEQTIMEOUTEN_SHIFT)) & FLEXSPI_INTEN_SEQTIMEOUTEN_MASK)
#define FLEXSPI_INTEN_KEYDONEEN_MASK             (0x1000U)
#define FLEXSPI_INTEN_KEYDONEEN_SHIFT            (12U)
/*! KEYDONEEN - OTFAD key blob processing done interrupt enable.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTEN_KEYDONEEN(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_KEYDONEEN_SHIFT)) & FLEXSPI_INTEN_KEYDONEEN_MASK)
#define FLEXSPI_INTEN_KEYERROREN_MASK            (0x2000U)
#define FLEXSPI_INTEN_KEYERROREN_SHIFT           (13U)
/*! KEYERROREN - OTFAD key blob processing error interrupt enable.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTEN_KEYERROREN(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTEN_KEYERROREN_SHIFT)) & FLEXSPI_INTEN_KEYERROREN_MASK)
/*! @} */

/*! @name INTR - Interrupt Register */
/*! @{ */
#define FLEXSPI_INTR_IPCMDDONE_MASK              (0x1U)
#define FLEXSPI_INTR_IPCMDDONE_SHIFT             (0U)
/*! IPCMDDONE - IP triggered Command Sequences Execution finished interrupt. This interrupt is also
 *    generated when there is IPCMDGE or IPCMDERR interrupt generated.
 */
#define FLEXSPI_INTR_IPCMDDONE(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPCMDDONE_SHIFT)) & FLEXSPI_INTR_IPCMDDONE_MASK)
#define FLEXSPI_INTR_IPCMDGE_MASK                (0x2U)
#define FLEXSPI_INTR_IPCMDGE_SHIFT               (1U)
/*! IPCMDGE - IP triggered Command Sequences Grant Timeout interrupt.
 */
#define FLEXSPI_INTR_IPCMDGE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPCMDGE_SHIFT)) & FLEXSPI_INTR_IPCMDGE_MASK)
#define FLEXSPI_INTR_AHBCMDGE_MASK               (0x4U)
#define FLEXSPI_INTR_AHBCMDGE_SHIFT              (2U)
/*! AHBCMDGE - AHB triggered Command Sequences Grant Timeout interrupt.
 */
#define FLEXSPI_INTR_AHBCMDGE(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBCMDGE_SHIFT)) & FLEXSPI_INTR_AHBCMDGE_MASK)
#define FLEXSPI_INTR_IPCMDERR_MASK               (0x8U)
#define FLEXSPI_INTR_IPCMDERR_SHIFT              (3U)
/*! IPCMDERR - IP triggered Command Sequences Error Detected interrupt. When an error detected for
 *    IP command, this command will be ignored and not executed at all.
 */
#define FLEXSPI_INTR_IPCMDERR(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPCMDERR_SHIFT)) & FLEXSPI_INTR_IPCMDERR_MASK)
#define FLEXSPI_INTR_AHBCMDERR_MASK              (0x10U)
#define FLEXSPI_INTR_AHBCMDERR_SHIFT             (4U)
/*! AHBCMDERR - AHB triggered Command Sequences Error Detected interrupt. When an error detected for
 *    AHB command, this command will be ignored and not executed at all.
 */
#define FLEXSPI_INTR_AHBCMDERR(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBCMDERR_SHIFT)) & FLEXSPI_INTR_AHBCMDERR_MASK)
#define FLEXSPI_INTR_IPRXWA_MASK                 (0x20U)
#define FLEXSPI_INTR_IPRXWA_SHIFT                (5U)
/*! IPRXWA - IP RX FIFO watermark available interrupt.
 */
#define FLEXSPI_INTR_IPRXWA(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPRXWA_SHIFT)) & FLEXSPI_INTR_IPRXWA_MASK)
#define FLEXSPI_INTR_IPTXWE_MASK                 (0x40U)
#define FLEXSPI_INTR_IPTXWE_SHIFT                (6U)
/*! IPTXWE - IP TX FIFO watermark empty interrupt.
 */
#define FLEXSPI_INTR_IPTXWE(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_IPTXWE_SHIFT)) & FLEXSPI_INTR_IPTXWE_MASK)
#define FLEXSPI_INTR_DATALEARNFAIL_MASK          (0x80U)
#define FLEXSPI_INTR_DATALEARNFAIL_SHIFT         (7U)
/*! DATALEARNFAIL - Data Learning failed interrupt.
 */
#define FLEXSPI_INTR_DATALEARNFAIL(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_DATALEARNFAIL_SHIFT)) & FLEXSPI_INTR_DATALEARNFAIL_MASK)
#define FLEXSPI_INTR_SCKSTOPBYRD_MASK            (0x100U)
#define FLEXSPI_INTR_SCKSTOPBYRD_SHIFT           (8U)
/*! SCKSTOPBYRD - SCLK is stopped during command sequence because Async RX FIFO full interrupt.
 */
#define FLEXSPI_INTR_SCKSTOPBYRD(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_SCKSTOPBYRD_SHIFT)) & FLEXSPI_INTR_SCKSTOPBYRD_MASK)
#define FLEXSPI_INTR_SCKSTOPBYWR_MASK            (0x200U)
#define FLEXSPI_INTR_SCKSTOPBYWR_SHIFT           (9U)
/*! SCKSTOPBYWR - SCLK is stopped during command sequence because Async TX FIFO empty interrupt.
 */
#define FLEXSPI_INTR_SCKSTOPBYWR(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_SCKSTOPBYWR_SHIFT)) & FLEXSPI_INTR_SCKSTOPBYWR_MASK)
#define FLEXSPI_INTR_AHBBUSERROR_MASK            (0x400U)
#define FLEXSPI_INTR_AHBBUSERROR_SHIFT           (10U)
/*! AHBBUSERROR - AHB Bus timeout or AHB bus illegal access Flash during OTFAD key blob processing interrupt.
 */
#define FLEXSPI_INTR_AHBBUSERROR(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBBUSERROR_SHIFT)) & FLEXSPI_INTR_AHBBUSERROR_MASK)
#define FLEXSPI_INTR_AHBBUSTIMEOUT_MASK          (0x400U)
#define FLEXSPI_INTR_AHBBUSTIMEOUT_SHIFT         (10U)
/*! AHBBUSTIMEOUT - AHB Bus timeout interrupt.Refer Interrupts chapter for more details.
 */
#define FLEXSPI_INTR_AHBBUSTIMEOUT(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_AHBBUSTIMEOUT_SHIFT)) & FLEXSPI_INTR_AHBBUSTIMEOUT_MASK)
#define FLEXSPI_INTR_SEQTIMEOUT_MASK             (0x800U)
#define FLEXSPI_INTR_SEQTIMEOUT_SHIFT            (11U)
/*! SEQTIMEOUT - Sequence execution timeout interrupt.
 */
#define FLEXSPI_INTR_SEQTIMEOUT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_SEQTIMEOUT_SHIFT)) & FLEXSPI_INTR_SEQTIMEOUT_MASK)
#define FLEXSPI_INTR_KEYDONE_MASK                (0x1000U)
#define FLEXSPI_INTR_KEYDONE_SHIFT               (12U)
/*! KEYDONE - OTFAD key blob processing done interrupt.
 */
#define FLEXSPI_INTR_KEYDONE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_KEYDONE_SHIFT)) & FLEXSPI_INTR_KEYDONE_MASK)
#define FLEXSPI_INTR_KEYERROR_MASK               (0x2000U)
#define FLEXSPI_INTR_KEYERROR_SHIFT              (13U)
/*! KEYERROR - OTFAD key blob processing error interrupt.
 */
#define FLEXSPI_INTR_KEYERROR(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_INTR_KEYERROR_SHIFT)) & FLEXSPI_INTR_KEYERROR_MASK)
/*! @} */

/*! @name LUTKEY - LUT Key Register */
/*! @{ */
#define FLEXSPI_LUTKEY_KEY_MASK                  (0xFFFFFFFFU)
#define FLEXSPI_LUTKEY_KEY_SHIFT                 (0U)
/*! KEY - The Key to lock or unlock LUT.
 */
#define FLEXSPI_LUTKEY_KEY(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUTKEY_KEY_SHIFT)) & FLEXSPI_LUTKEY_KEY_MASK)
/*! @} */

/*! @name LUTCR - LUT Control Register */
/*! @{ */
#define FLEXSPI_LUTCR_LOCK_MASK                  (0x1U)
#define FLEXSPI_LUTCR_LOCK_SHIFT                 (0U)
/*! LOCK - Lock LUT
 */
#define FLEXSPI_LUTCR_LOCK(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUTCR_LOCK_SHIFT)) & FLEXSPI_LUTCR_LOCK_MASK)
#define FLEXSPI_LUTCR_UNLOCK_MASK                (0x2U)
#define FLEXSPI_LUTCR_UNLOCK_SHIFT               (1U)
/*! UNLOCK - Unlock LUT
 */
#define FLEXSPI_LUTCR_UNLOCK(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUTCR_UNLOCK_SHIFT)) & FLEXSPI_LUTCR_UNLOCK_MASK)
/*! @} */

/*! @name AHBRXBUFCR0 - AHB RX Buffer 0 Control Register 0..AHB RX Buffer 7 Control Register 0 */
/*! @{ */
#define FLEXSPI_AHBRXBUFCR0_BUFSZ_MASK           (0x1FFU)  /* Merged from fields with different position or width, of widths (8, 9), largest definition used */
#define FLEXSPI_AHBRXBUFCR0_BUFSZ_SHIFT          (0U)
/*! BUFSZ - AHB RX Buffer Size in 64 bits.
 */
#define FLEXSPI_AHBRXBUFCR0_BUFSZ(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_BUFSZ_SHIFT)) & FLEXSPI_AHBRXBUFCR0_BUFSZ_MASK)  /* Merged from fields with different position or width, of widths (8, 9), largest definition used */
#define FLEXSPI_AHBRXBUFCR0_MSTRID_MASK          (0xF0000U)
#define FLEXSPI_AHBRXBUFCR0_MSTRID_SHIFT         (16U)
/*! MSTRID - This AHB RX Buffer is assigned according to AHB Master with ID (MSTR_ID).
 */
#define FLEXSPI_AHBRXBUFCR0_MSTRID(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_MSTRID_SHIFT)) & FLEXSPI_AHBRXBUFCR0_MSTRID_MASK)
#define FLEXSPI_AHBRXBUFCR0_PRIORITY_MASK        (0x7000000U)
#define FLEXSPI_AHBRXBUFCR0_PRIORITY_SHIFT       (24U)
/*! PRIORITY - This priority for AHB Master Read which this AHB RX Buffer is assigned. 7 is the highest priority, 0 the lowest.
 */
#define FLEXSPI_AHBRXBUFCR0_PRIORITY(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_PRIORITY_SHIFT)) & FLEXSPI_AHBRXBUFCR0_PRIORITY_MASK)
#define FLEXSPI_AHBRXBUFCR0_PREFETCHEN_MASK      (0x80000000U)
#define FLEXSPI_AHBRXBUFCR0_PREFETCHEN_SHIFT     (31U)
/*! PREFETCHEN - AHB Read Prefetch Enable for current AHB RX Buffer corresponding Master.
 */
#define FLEXSPI_AHBRXBUFCR0_PREFETCHEN(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBRXBUFCR0_PREFETCHEN_SHIFT)) & FLEXSPI_AHBRXBUFCR0_PREFETCHEN_MASK)
/*! @} */

/* The count of FLEXSPI_AHBRXBUFCR0 */
#define FLEXSPI_AHBRXBUFCR0_COUNT                (8U)

/*! @name FLSHCR0 - Flash Control Register 0 */
/*! @{ */
#define FLEXSPI_FLSHCR0_FLSHSZ_MASK              (0x7FFFFFU)
#define FLEXSPI_FLSHCR0_FLSHSZ_SHIFT             (0U)
/*! FLSHSZ - Flash Size in KByte.
 */
#define FLEXSPI_FLSHCR0_FLSHSZ(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR0_FLSHSZ_SHIFT)) & FLEXSPI_FLSHCR0_FLSHSZ_MASK)
/*! @} */

/* The count of FLEXSPI_FLSHCR0 */
#define FLEXSPI_FLSHCR0_COUNT                    (4U)

/*! @name FLSHCR1 - Flash Control Register 1 */
/*! @{ */
#define FLEXSPI_FLSHCR1_TCSS_MASK                (0x1FU)
#define FLEXSPI_FLSHCR1_TCSS_SHIFT               (0U)
/*! TCSS - Serial Flash CS setup time.
 */
#define FLEXSPI_FLSHCR1_TCSS(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_TCSS_SHIFT)) & FLEXSPI_FLSHCR1_TCSS_MASK)
#define FLEXSPI_FLSHCR1_TCSH_MASK                (0x3E0U)
#define FLEXSPI_FLSHCR1_TCSH_SHIFT               (5U)
/*! TCSH - Serial Flash CS Hold time.
 */
#define FLEXSPI_FLSHCR1_TCSH(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_TCSH_SHIFT)) & FLEXSPI_FLSHCR1_TCSH_MASK)
#define FLEXSPI_FLSHCR1_WA_MASK                  (0x400U)
#define FLEXSPI_FLSHCR1_WA_SHIFT                 (10U)
/*! WA - Word Addressable.
 */
#define FLEXSPI_FLSHCR1_WA(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_WA_SHIFT)) & FLEXSPI_FLSHCR1_WA_MASK)
#define FLEXSPI_FLSHCR1_CAS_MASK                 (0x7800U)
#define FLEXSPI_FLSHCR1_CAS_SHIFT                (11U)
/*! CAS - Column Address Size.
 */
#define FLEXSPI_FLSHCR1_CAS(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_CAS_SHIFT)) & FLEXSPI_FLSHCR1_CAS_MASK)
#define FLEXSPI_FLSHCR1_CSINTERVALUNIT_MASK      (0x8000U)
#define FLEXSPI_FLSHCR1_CSINTERVALUNIT_SHIFT     (15U)
/*! CSINTERVALUNIT - CS interval unit
 *  0b0..The CS interval unit is 1 serial clock cycle
 *  0b1..The CS interval unit is 256 serial clock cycle
 */
#define FLEXSPI_FLSHCR1_CSINTERVALUNIT(x)        (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_CSINTERVALUNIT_SHIFT)) & FLEXSPI_FLSHCR1_CSINTERVALUNIT_MASK)
#define FLEXSPI_FLSHCR1_CSINTERVAL_MASK          (0xFFFF0000U)
#define FLEXSPI_FLSHCR1_CSINTERVAL_SHIFT         (16U)
/*! CSINTERVAL - This field is used to set the minimum interval between flash device Chip selection
 *    deassertion and flash device Chip selection assertion. If external flash has a limitation on
 *    the interval between command sequences, this field should be set accordingly. If there is no
 *    limitation, set this field with value 0x0.
 */
#define FLEXSPI_FLSHCR1_CSINTERVAL(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR1_CSINTERVAL_SHIFT)) & FLEXSPI_FLSHCR1_CSINTERVAL_MASK)
/*! @} */

/* The count of FLEXSPI_FLSHCR1 */
#define FLEXSPI_FLSHCR1_COUNT                    (4U)

/*! @name FLSHCR2 - Flash Control Register 2 */
/*! @{ */
#define FLEXSPI_FLSHCR2_ARDSEQID_MASK            (0xFU)
#define FLEXSPI_FLSHCR2_ARDSEQID_SHIFT           (0U)
/*! ARDSEQID - Sequence Index for AHB Read triggered Command in LUT.
 */
#define FLEXSPI_FLSHCR2_ARDSEQID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_ARDSEQID_SHIFT)) & FLEXSPI_FLSHCR2_ARDSEQID_MASK)
#define FLEXSPI_FLSHCR2_ARDSEQNUM_MASK           (0xE0U)
#define FLEXSPI_FLSHCR2_ARDSEQNUM_SHIFT          (5U)
/*! ARDSEQNUM - Sequence Number for AHB Read triggered Command in LUT.
 */
#define FLEXSPI_FLSHCR2_ARDSEQNUM(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_ARDSEQNUM_SHIFT)) & FLEXSPI_FLSHCR2_ARDSEQNUM_MASK)
#define FLEXSPI_FLSHCR2_AWRSEQID_MASK            (0xF00U)
#define FLEXSPI_FLSHCR2_AWRSEQID_SHIFT           (8U)
/*! AWRSEQID - Sequence Index for AHB Write triggered Command.
 */
#define FLEXSPI_FLSHCR2_AWRSEQID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRSEQID_SHIFT)) & FLEXSPI_FLSHCR2_AWRSEQID_MASK)
#define FLEXSPI_FLSHCR2_AWRSEQNUM_MASK           (0xE000U)
#define FLEXSPI_FLSHCR2_AWRSEQNUM_SHIFT          (13U)
/*! AWRSEQNUM - Sequence Number for AHB Write triggered Command.
 */
#define FLEXSPI_FLSHCR2_AWRSEQNUM(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRSEQNUM_SHIFT)) & FLEXSPI_FLSHCR2_AWRSEQNUM_MASK)
#define FLEXSPI_FLSHCR2_AWRWAIT_MASK             (0xFFF0000U)
#define FLEXSPI_FLSHCR2_AWRWAIT_SHIFT            (16U)
#define FLEXSPI_FLSHCR2_AWRWAIT(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRWAIT_SHIFT)) & FLEXSPI_FLSHCR2_AWRWAIT_MASK)
#define FLEXSPI_FLSHCR2_AWRWAITUNIT_MASK         (0x70000000U)
#define FLEXSPI_FLSHCR2_AWRWAITUNIT_SHIFT        (28U)
/*! AWRWAITUNIT - AWRWAIT unit
 *  0b000..The AWRWAIT unit is 2 ahb clock cycle
 *  0b001..The AWRWAIT unit is 8 ahb clock cycle
 *  0b010..The AWRWAIT unit is 32 ahb clock cycle
 *  0b011..The AWRWAIT unit is 128 ahb clock cycle
 *  0b100..The AWRWAIT unit is 512 ahb clock cycle
 *  0b101..The AWRWAIT unit is 2048 ahb clock cycle
 *  0b110..The AWRWAIT unit is 8192 ahb clock cycle
 *  0b111..The AWRWAIT unit is 32768 ahb clock cycle
 */
#define FLEXSPI_FLSHCR2_AWRWAITUNIT(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_AWRWAITUNIT_SHIFT)) & FLEXSPI_FLSHCR2_AWRWAITUNIT_MASK)
#define FLEXSPI_FLSHCR2_CLRINSTRPTR_MASK         (0x80000000U)
#define FLEXSPI_FLSHCR2_CLRINSTRPTR_SHIFT        (31U)
/*! CLRINSTRPTR - Clear the instruction pointer which is internally saved pointer by JMP_ON_CS.
 *    Refer Programmable Sequence Engine for details.
 */
#define FLEXSPI_FLSHCR2_CLRINSTRPTR(x)           (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR2_CLRINSTRPTR_SHIFT)) & FLEXSPI_FLSHCR2_CLRINSTRPTR_MASK)
/*! @} */

/* The count of FLEXSPI_FLSHCR2 */
#define FLEXSPI_FLSHCR2_COUNT                    (4U)

/*! @name FLSHCR4 - Flash Control Register 4 */
/*! @{ */
#define FLEXSPI_FLSHCR4_WMOPT1_MASK              (0x1U)
#define FLEXSPI_FLSHCR4_WMOPT1_SHIFT             (0U)
/*! WMOPT1 - Write mask option bit 1. This option bit could be used to remove AHB write burst start address alignment limitation.
 *  0b0..DQS pin will be used as Write Mask when writing to external device. There is no limitation on AHB write
 *       burst start address alignment when flash is accessed in individual mode.
 *  0b1..DQS pin will not be used as Write Mask when writing to external device. There is limitation on AHB write
 *       burst start address alignment when flash is accessed in individual mode.
 */
#define FLEXSPI_FLSHCR4_WMOPT1(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR4_WMOPT1_SHIFT)) & FLEXSPI_FLSHCR4_WMOPT1_MASK)
#define FLEXSPI_FLSHCR4_WMENA_MASK               (0x4U)
#define FLEXSPI_FLSHCR4_WMENA_SHIFT              (2U)
/*! WMENA - Write mask enable bit for flash device on port A. When write mask function is needed for
 *    memory device on port A, this bit must be set.
 *  0b0..Write mask is disabled, DQS(RWDS) pin will be un-driven when writing to external device.
 *  0b1..Write mask is enabled, DQS(RWDS) pin will be driven by FlexSPI as write mask output when writing to external device.
 */
#define FLEXSPI_FLSHCR4_WMENA(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR4_WMENA_SHIFT)) & FLEXSPI_FLSHCR4_WMENA_MASK)
#define FLEXSPI_FLSHCR4_WMENB_MASK               (0x8U)
#define FLEXSPI_FLSHCR4_WMENB_SHIFT              (3U)
/*! WMENB - Write mask enable bit for flash device on port B. When write mask function is needed for
 *    memory device on port B, this bit must be set.
 *  0b0..Write mask is disabled, DQS(RWDS) pin will be un-driven when writing to external device.
 *  0b1..Write mask is enabled, DQS(RWDS) pin will be driven by FlexSPI as write mask output when writing to external device.
 */
#define FLEXSPI_FLSHCR4_WMENB(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_FLSHCR4_WMENB_SHIFT)) & FLEXSPI_FLSHCR4_WMENB_MASK)
/*! @} */

/*! @name IPCR0 - IP Control Register 0 */
/*! @{ */
#define FLEXSPI_IPCR0_SFAR_MASK                  (0xFFFFFFFFU)
#define FLEXSPI_IPCR0_SFAR_SHIFT                 (0U)
/*! SFAR - Serial Flash Address for IP command.
 */
#define FLEXSPI_IPCR0_SFAR(x)                    (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR0_SFAR_SHIFT)) & FLEXSPI_IPCR0_SFAR_MASK)
/*! @} */

/*! @name IPCR1 - IP Control Register 1 */
/*! @{ */
#define FLEXSPI_IPCR1_IDATSZ_MASK                (0xFFFFU)
#define FLEXSPI_IPCR1_IDATSZ_SHIFT               (0U)
/*! IDATSZ - Flash Read/Program Data Size (in Bytes) for IP command.
 */
#define FLEXSPI_IPCR1_IDATSZ(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR1_IDATSZ_SHIFT)) & FLEXSPI_IPCR1_IDATSZ_MASK)
#define FLEXSPI_IPCR1_ISEQID_MASK                (0xF0000U)
#define FLEXSPI_IPCR1_ISEQID_SHIFT               (16U)
/*! ISEQID - Sequence Index in LUT for IP command.
 */
#define FLEXSPI_IPCR1_ISEQID(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR1_ISEQID_SHIFT)) & FLEXSPI_IPCR1_ISEQID_MASK)
#define FLEXSPI_IPCR1_ISEQNUM_MASK               (0x7000000U)
#define FLEXSPI_IPCR1_ISEQNUM_SHIFT              (24U)
/*! ISEQNUM - Sequence Number for IP command: ISEQNUM+1.
 */
#define FLEXSPI_IPCR1_ISEQNUM(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR1_ISEQNUM_SHIFT)) & FLEXSPI_IPCR1_ISEQNUM_MASK)
#define FLEXSPI_IPCR1_IPAREN_MASK                (0x80000000U)
#define FLEXSPI_IPCR1_IPAREN_SHIFT               (31U)
/*! IPAREN - Parallel mode Enabled for IP command.
 *  0b0..Flash will be accessed in Individual mode.
 *  0b1..Flash will be accessed in Parallel mode.
 */
#define FLEXSPI_IPCR1_IPAREN(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCR1_IPAREN_SHIFT)) & FLEXSPI_IPCR1_IPAREN_MASK)
/*! @} */

/*! @name IPCMD - IP Command Register */
/*! @{ */
#define FLEXSPI_IPCMD_TRG_MASK                   (0x1U)
#define FLEXSPI_IPCMD_TRG_SHIFT                  (0U)
/*! TRG - Setting this bit will trigger an IP Command.
 */
#define FLEXSPI_IPCMD_TRG(x)                     (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPCMD_TRG_SHIFT)) & FLEXSPI_IPCMD_TRG_MASK)
/*! @} */

/*! @name DLPR - Data Learn Pattern Register */
/*! @{ */
#define FLEXSPI_DLPR_DLP_MASK                    (0xFFFFFFFFU)
#define FLEXSPI_DLPR_DLP_SHIFT                   (0U)
/*! DLP - Data Learning Pattern.
 */
#define FLEXSPI_DLPR_DLP(x)                      (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLPR_DLP_SHIFT)) & FLEXSPI_DLPR_DLP_MASK)
/*! @} */

/*! @name IPRXFCR - IP RX FIFO Control Register */
/*! @{ */
#define FLEXSPI_IPRXFCR_CLRIPRXF_MASK            (0x1U)
#define FLEXSPI_IPRXFCR_CLRIPRXF_SHIFT           (0U)
/*! CLRIPRXF - Clear all valid data entries in IP RX FIFO.
 */
#define FLEXSPI_IPRXFCR_CLRIPRXF(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFCR_CLRIPRXF_SHIFT)) & FLEXSPI_IPRXFCR_CLRIPRXF_MASK)
#define FLEXSPI_IPRXFCR_RXDMAEN_MASK             (0x2U)
#define FLEXSPI_IPRXFCR_RXDMAEN_SHIFT            (1U)
/*! RXDMAEN - IP RX FIFO reading by DMA enabled.
 *  0b0..IP RX FIFO would be read by processor.
 *  0b1..IP RX FIFO would be read by DMA.
 */
#define FLEXSPI_IPRXFCR_RXDMAEN(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFCR_RXDMAEN_SHIFT)) & FLEXSPI_IPRXFCR_RXDMAEN_MASK)
#define FLEXSPI_IPRXFCR_RXWMRK_MASK              (0x1FCU)
#define FLEXSPI_IPRXFCR_RXWMRK_SHIFT             (2U)
/*! RXWMRK - Watermark level is (RXWMRK+1)*64 Bits.
 */
#define FLEXSPI_IPRXFCR_RXWMRK(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFCR_RXWMRK_SHIFT)) & FLEXSPI_IPRXFCR_RXWMRK_MASK)
/*! @} */

/*! @name IPTXFCR - IP TX FIFO Control Register */
/*! @{ */
#define FLEXSPI_IPTXFCR_CLRIPTXF_MASK            (0x1U)
#define FLEXSPI_IPTXFCR_CLRIPTXF_SHIFT           (0U)
/*! CLRIPTXF - Clear all valid data entries in IP TX FIFO.
 */
#define FLEXSPI_IPTXFCR_CLRIPTXF(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFCR_CLRIPTXF_SHIFT)) & FLEXSPI_IPTXFCR_CLRIPTXF_MASK)
#define FLEXSPI_IPTXFCR_TXDMAEN_MASK             (0x2U)
#define FLEXSPI_IPTXFCR_TXDMAEN_SHIFT            (1U)
/*! TXDMAEN - IP TX FIFO filling by DMA enabled.
 *  0b0..IP TX FIFO would be filled by processor.
 *  0b1..IP TX FIFO would be filled by DMA.
 */
#define FLEXSPI_IPTXFCR_TXDMAEN(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFCR_TXDMAEN_SHIFT)) & FLEXSPI_IPTXFCR_TXDMAEN_MASK)
#define FLEXSPI_IPTXFCR_TXWMRK_MASK              (0x1FCU)
#define FLEXSPI_IPTXFCR_TXWMRK_SHIFT             (2U)
/*! TXWMRK - Watermark level is (TXWMRK+1)*64 Bits.
 */
#define FLEXSPI_IPTXFCR_TXWMRK(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFCR_TXWMRK_SHIFT)) & FLEXSPI_IPTXFCR_TXWMRK_MASK)
/*! @} */

/*! @name DLLCR - DLL Control Register 0 */
/*! @{ */
#define FLEXSPI_DLLCR_DLLEN_MASK                 (0x1U)
#define FLEXSPI_DLLCR_DLLEN_SHIFT                (0U)
/*! DLLEN - DLL calibration enable.
 */
#define FLEXSPI_DLLCR_DLLEN(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_DLLEN_SHIFT)) & FLEXSPI_DLLCR_DLLEN_MASK)
#define FLEXSPI_DLLCR_DLLRESET_MASK              (0x2U)
#define FLEXSPI_DLLCR_DLLRESET_SHIFT             (1U)
/*! DLLRESET - Software could force a reset on DLL by setting this field to 0x1. This will cause the
 *    DLL to lose lock and re-calibrate to detect an ref_clock half period phase shift. The reset
 *    action is edge triggered, so software need to clear this bit after set this bit (no delay
 *    limitation).
 */
#define FLEXSPI_DLLCR_DLLRESET(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_DLLRESET_SHIFT)) & FLEXSPI_DLLCR_DLLRESET_MASK)
#define FLEXSPI_DLLCR_SLVDLYTARGET_MASK          (0x78U)
#define FLEXSPI_DLLCR_SLVDLYTARGET_SHIFT         (3U)
/*! SLVDLYTARGET - The delay target for slave delay line is: ((SLVDLYTARGET+1) * 1/32 * clock cycle
 *    of reference clock (serial root clock). If serial root clock is >= 100 MHz, DLLEN set to 0x1,
 *    OVRDEN set to =0x0, then SLVDLYTARGET setting of 0xF is recommended.
 */
#define FLEXSPI_DLLCR_SLVDLYTARGET(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_SLVDLYTARGET_SHIFT)) & FLEXSPI_DLLCR_SLVDLYTARGET_MASK)
#define FLEXSPI_DLLCR_OVRDEN_MASK                (0x100U)
#define FLEXSPI_DLLCR_OVRDEN_SHIFT               (8U)
/*! OVRDEN - Slave clock delay line delay cell number selection override enable.
 */
#define FLEXSPI_DLLCR_OVRDEN(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_OVRDEN_SHIFT)) & FLEXSPI_DLLCR_OVRDEN_MASK)
#define FLEXSPI_DLLCR_OVRDVAL_MASK               (0x7E00U)
#define FLEXSPI_DLLCR_OVRDVAL_SHIFT              (9U)
/*! OVRDVAL - Slave clock delay line delay cell number selection override value.
 */
#define FLEXSPI_DLLCR_OVRDVAL(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_DLLCR_OVRDVAL_SHIFT)) & FLEXSPI_DLLCR_OVRDVAL_MASK)
/*! @} */

/* The count of FLEXSPI_DLLCR */
#define FLEXSPI_DLLCR_COUNT                      (2U)

/*! @name STS0 - Status Register 0 */
/*! @{ */
#define FLEXSPI_STS0_SEQIDLE_MASK                (0x1U)
#define FLEXSPI_STS0_SEQIDLE_SHIFT               (0U)
/*! SEQIDLE - This status bit indicates the state machine in SEQ_CTL is idle and there is command
 *    sequence executing on FlexSPI interface.
 */
#define FLEXSPI_STS0_SEQIDLE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_SEQIDLE_SHIFT)) & FLEXSPI_STS0_SEQIDLE_MASK)
#define FLEXSPI_STS0_ARBIDLE_MASK                (0x2U)
#define FLEXSPI_STS0_ARBIDLE_SHIFT               (1U)
/*! ARBIDLE - This status bit indicates the state machine in ARB_CTL is busy and there is command
 *    sequence granted by arbitrator and not finished yet on FlexSPI interface. When ARB_CTL state
 *    (ARBIDLE=0x1) is idle, there will be no transaction on FlexSPI interface also (SEQIDLE=0x1). So
 *    this bit should be polled to wait for FlexSPI controller become idle instead of SEQIDLE.
 */
#define FLEXSPI_STS0_ARBIDLE(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_ARBIDLE_SHIFT)) & FLEXSPI_STS0_ARBIDLE_MASK)
#define FLEXSPI_STS0_ARBCMDSRC_MASK              (0xCU)
#define FLEXSPI_STS0_ARBCMDSRC_SHIFT             (2U)
/*! ARBCMDSRC - This status field indicates the trigger source of current command sequence granted
 *    by arbitrator. This field value is meaningless when ARB_CTL is not busy (STS0[ARBIDLE]=0x1).
 *  0b00..Triggered by AHB read command (triggered by AHB read).
 *  0b01..Triggered by AHB write command (triggered by AHB Write).
 *  0b10..Triggered by IP command (triggered by setting register bit IPCMD.TRG).
 *  0b11..Triggered by suspended command (resumed).
 */
#define FLEXSPI_STS0_ARBCMDSRC(x)                (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_ARBCMDSRC_SHIFT)) & FLEXSPI_STS0_ARBCMDSRC_MASK)
#define FLEXSPI_STS0_DATALEARNPHASEA_MASK        (0xF0U)
#define FLEXSPI_STS0_DATALEARNPHASEA_SHIFT       (4U)
/*! DATALEARNPHASEA - Indicate the sampling clock phase selection on Port A after Data Learning.
 */
#define FLEXSPI_STS0_DATALEARNPHASEA(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_DATALEARNPHASEA_SHIFT)) & FLEXSPI_STS0_DATALEARNPHASEA_MASK)
#define FLEXSPI_STS0_DATALEARNPHASEB_MASK        (0xF00U)
#define FLEXSPI_STS0_DATALEARNPHASEB_SHIFT       (8U)
/*! DATALEARNPHASEB - Indicate the sampling clock phase selection on Port B after Data Learning.
 */
#define FLEXSPI_STS0_DATALEARNPHASEB(x)          (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS0_DATALEARNPHASEB_SHIFT)) & FLEXSPI_STS0_DATALEARNPHASEB_MASK)
/*! @} */

/*! @name STS1 - Status Register 1 */
/*! @{ */
#define FLEXSPI_STS1_AHBCMDERRID_MASK            (0xFU)
#define FLEXSPI_STS1_AHBCMDERRID_SHIFT           (0U)
/*! AHBCMDERRID - Indicates the sequence index when an AHB command error is detected. This field
 *    will be cleared when INTR[AHBCMDERR] is write-1-clear(w1c).
 */
#define FLEXSPI_STS1_AHBCMDERRID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS1_AHBCMDERRID_SHIFT)) & FLEXSPI_STS1_AHBCMDERRID_MASK)
#define FLEXSPI_STS1_AHBCMDERRCODE_MASK          (0xF00U)
#define FLEXSPI_STS1_AHBCMDERRCODE_SHIFT         (8U)
/*! AHBCMDERRCODE - Indicates the Error Code when AHB command Error detected. This field will be
 *    cleared when INTR[AHBCMDERR] is write-1-clear(w1c).
 *  0b0000..No error.
 *  0b0010..AHB Write command with JMP_ON_CS instruction used in the sequence.
 *  0b0011..There is unknown instruction opcode in the sequence.
 *  0b0100..Instruction DUMMY_SDR/DUMMY_RWDS_SDR used in DDR sequence.
 *  0b0101..Instruction DUMMY_DDR/DUMMY_RWDS_DDR used in SDR sequence.
 *  0b1110..Sequence execution timeout.
 */
#define FLEXSPI_STS1_AHBCMDERRCODE(x)            (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS1_AHBCMDERRCODE_SHIFT)) & FLEXSPI_STS1_AHBCMDERRCODE_MASK)
#define FLEXSPI_STS1_IPCMDERRID_MASK             (0xF0000U)
#define FLEXSPI_STS1_IPCMDERRID_SHIFT            (16U)
/*! IPCMDERRID - Indicates the sequence Index when IP command error detected. This field will be
 *    cleared when INTR[IPCMDERR] is write-1-clear(w1c).
 */
#define FLEXSPI_STS1_IPCMDERRID(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS1_IPCMDERRID_SHIFT)) & FLEXSPI_STS1_IPCMDERRID_MASK)
#define FLEXSPI_STS1_IPCMDERRCODE_MASK           (0xF000000U)
#define FLEXSPI_STS1_IPCMDERRCODE_SHIFT          (24U)
/*! IPCMDERRCODE - Indicates the Error Code when IP command Error detected. This field will be
 *    cleared when INTR[IPCMDERR] is write-1-clear(w1c).
 *  0b0000..No error.
 *  0b0010..IP command with JMP_ON_CS instruction used in the sequence.
 *  0b0011..There is unknown instruction opcode in the sequence.
 *  0b0100..Instruction DUMMY_SDR/DUMMY_RWDS_SDR used in DDR sequence.
 *  0b0101..Instruction DUMMY_DDR/DUMMY_RWDS_DDR used in SDR sequence.
 *  0b0110..Flash access start address exceed the whole flash address range (A1/A2/B1/B2).
 *  0b1110..Sequence execution timeout.
 *  0b1111..Flash boundary crossed.
 */
#define FLEXSPI_STS1_IPCMDERRCODE(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS1_IPCMDERRCODE_SHIFT)) & FLEXSPI_STS1_IPCMDERRCODE_MASK)
/*! @} */

/*! @name STS2 - Status Register 2 */
/*! @{ */
#define FLEXSPI_STS2_ASLVLOCK_MASK               (0x1U)
#define FLEXSPI_STS2_ASLVLOCK_SHIFT              (0U)
/*! ASLVLOCK - Flash A sample clock slave delay line locked.
 */
#define FLEXSPI_STS2_ASLVLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_ASLVLOCK_SHIFT)) & FLEXSPI_STS2_ASLVLOCK_MASK)
#define FLEXSPI_STS2_AREFLOCK_MASK               (0x2U)
#define FLEXSPI_STS2_AREFLOCK_SHIFT              (1U)
/*! AREFLOCK - Flash A sample clock reference delay line locked.
 */
#define FLEXSPI_STS2_AREFLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_AREFLOCK_SHIFT)) & FLEXSPI_STS2_AREFLOCK_MASK)
#define FLEXSPI_STS2_ASLVSEL_MASK                (0xFCU)
#define FLEXSPI_STS2_ASLVSEL_SHIFT               (2U)
/*! ASLVSEL - Flash A sample clock slave delay line delay cell number selection .
 */
#define FLEXSPI_STS2_ASLVSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_ASLVSEL_SHIFT)) & FLEXSPI_STS2_ASLVSEL_MASK)
#define FLEXSPI_STS2_AREFSEL_MASK                (0x3F00U)
#define FLEXSPI_STS2_AREFSEL_SHIFT               (8U)
/*! AREFSEL - Flash A sample clock reference delay line delay cell number selection.
 */
#define FLEXSPI_STS2_AREFSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_AREFSEL_SHIFT)) & FLEXSPI_STS2_AREFSEL_MASK)
#define FLEXSPI_STS2_BSLVLOCK_MASK               (0x10000U)
#define FLEXSPI_STS2_BSLVLOCK_SHIFT              (16U)
/*! BSLVLOCK - Flash B sample clock slave delay line locked.
 */
#define FLEXSPI_STS2_BSLVLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_BSLVLOCK_SHIFT)) & FLEXSPI_STS2_BSLVLOCK_MASK)
#define FLEXSPI_STS2_BREFLOCK_MASK               (0x20000U)
#define FLEXSPI_STS2_BREFLOCK_SHIFT              (17U)
/*! BREFLOCK - Flash B sample clock reference delay line locked.
 */
#define FLEXSPI_STS2_BREFLOCK(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_BREFLOCK_SHIFT)) & FLEXSPI_STS2_BREFLOCK_MASK)
#define FLEXSPI_STS2_BSLVSEL_MASK                (0xFC0000U)
#define FLEXSPI_STS2_BSLVSEL_SHIFT               (18U)
/*! BSLVSEL - Flash B sample clock slave delay line delay cell number selection.
 */
#define FLEXSPI_STS2_BSLVSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_BSLVSEL_SHIFT)) & FLEXSPI_STS2_BSLVSEL_MASK)
#define FLEXSPI_STS2_BREFSEL_MASK                (0x3F000000U)
#define FLEXSPI_STS2_BREFSEL_SHIFT               (24U)
/*! BREFSEL - Flash B sample clock reference delay line delay cell number selection.
 */
#define FLEXSPI_STS2_BREFSEL(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_STS2_BREFSEL_SHIFT)) & FLEXSPI_STS2_BREFSEL_MASK)
/*! @} */

/*! @name AHBSPNDSTS - AHB Suspend Status Register */
/*! @{ */
#define FLEXSPI_AHBSPNDSTS_ACTIVE_MASK           (0x1U)
#define FLEXSPI_AHBSPNDSTS_ACTIVE_SHIFT          (0U)
/*! ACTIVE - Indicates if an AHB read prefetch command sequence has been suspended.
 */
#define FLEXSPI_AHBSPNDSTS_ACTIVE(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBSPNDSTS_ACTIVE_SHIFT)) & FLEXSPI_AHBSPNDSTS_ACTIVE_MASK)
#define FLEXSPI_AHBSPNDSTS_BUFID_MASK            (0xEU)
#define FLEXSPI_AHBSPNDSTS_BUFID_SHIFT           (1U)
/*! BUFID - AHB RX BUF ID for suspended command sequence.
 */
#define FLEXSPI_AHBSPNDSTS_BUFID(x)              (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBSPNDSTS_BUFID_SHIFT)) & FLEXSPI_AHBSPNDSTS_BUFID_MASK)
#define FLEXSPI_AHBSPNDSTS_DATLFT_MASK           (0xFFFF0000U)
#define FLEXSPI_AHBSPNDSTS_DATLFT_SHIFT          (16U)
/*! DATLFT - Left Data size for suspended command sequence (in byte).
 */
#define FLEXSPI_AHBSPNDSTS_DATLFT(x)             (((uint32_t)(((uint32_t)(x)) << FLEXSPI_AHBSPNDSTS_DATLFT_SHIFT)) & FLEXSPI_AHBSPNDSTS_DATLFT_MASK)
/*! @} */

/*! @name IPRXFSTS - IP RX FIFO Status Register */
/*! @{ */
#define FLEXSPI_IPRXFSTS_FILL_MASK               (0xFFU)
#define FLEXSPI_IPRXFSTS_FILL_SHIFT              (0U)
/*! FILL - Fill level of IP RX FIFO.
 */
#define FLEXSPI_IPRXFSTS_FILL(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFSTS_FILL_SHIFT)) & FLEXSPI_IPRXFSTS_FILL_MASK)
#define FLEXSPI_IPRXFSTS_RDCNTR_MASK             (0xFFFF0000U)
#define FLEXSPI_IPRXFSTS_RDCNTR_SHIFT            (16U)
/*! RDCNTR - Total Read Data Counter: RDCNTR * 64 Bits.
 */
#define FLEXSPI_IPRXFSTS_RDCNTR(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPRXFSTS_RDCNTR_SHIFT)) & FLEXSPI_IPRXFSTS_RDCNTR_MASK)
/*! @} */

/*! @name IPTXFSTS - IP TX FIFO Status Register */
/*! @{ */
#define FLEXSPI_IPTXFSTS_FILL_MASK               (0xFFU)
#define FLEXSPI_IPTXFSTS_FILL_SHIFT              (0U)
/*! FILL - Fill level of IP TX FIFO.
 */
#define FLEXSPI_IPTXFSTS_FILL(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFSTS_FILL_SHIFT)) & FLEXSPI_IPTXFSTS_FILL_MASK)
#define FLEXSPI_IPTXFSTS_WRCNTR_MASK             (0xFFFF0000U)
#define FLEXSPI_IPTXFSTS_WRCNTR_SHIFT            (16U)
/*! WRCNTR - Total Write Data Counter: WRCNTR * 64 Bits.
 */
#define FLEXSPI_IPTXFSTS_WRCNTR(x)               (((uint32_t)(((uint32_t)(x)) << FLEXSPI_IPTXFSTS_WRCNTR_SHIFT)) & FLEXSPI_IPTXFSTS_WRCNTR_MASK)
/*! @} */

/*! @name RFDR - IP RX FIFO Data Register 0..IP RX FIFO Data Register 31 */
/*! @{ */
#define FLEXSPI_RFDR_RXDATA_MASK                 (0xFFFFFFFFU)
#define FLEXSPI_RFDR_RXDATA_SHIFT                (0U)
/*! RXDATA - RX Data
 */
#define FLEXSPI_RFDR_RXDATA(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_RFDR_RXDATA_SHIFT)) & FLEXSPI_RFDR_RXDATA_MASK)
/*! @} */

/* The count of FLEXSPI_RFDR */
#define FLEXSPI_RFDR_COUNT                       (32U)

/*! @name TFDR - IP TX FIFO Data Register 0..IP TX FIFO Data Register 31 */
/*! @{ */
#define FLEXSPI_TFDR_TXDATA_MASK                 (0xFFFFFFFFU)
#define FLEXSPI_TFDR_TXDATA_SHIFT                (0U)
/*! TXDATA - TX Data
 */
#define FLEXSPI_TFDR_TXDATA(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_TFDR_TXDATA_SHIFT)) & FLEXSPI_TFDR_TXDATA_MASK)
/*! @} */

/* The count of FLEXSPI_TFDR */
#define FLEXSPI_TFDR_COUNT                       (32U)

/*! @name LUT - LUT 0..LUT 63 */
/*! @{ */
#define FLEXSPI_LUT_OPERAND0_MASK                (0xFFU)
#define FLEXSPI_LUT_OPERAND0_SHIFT               (0U)
/*! OPERAND0 - OPERAND0
 */
#define FLEXSPI_LUT_OPERAND0(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_OPERAND0_SHIFT)) & FLEXSPI_LUT_OPERAND0_MASK)
#define FLEXSPI_LUT_NUM_PADS0_MASK               (0x300U)
#define FLEXSPI_LUT_NUM_PADS0_SHIFT              (8U)
/*! NUM_PADS0 - NUM_PADS0
 */
#define FLEXSPI_LUT_NUM_PADS0(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_NUM_PADS0_SHIFT)) & FLEXSPI_LUT_NUM_PADS0_MASK)
#define FLEXSPI_LUT_OPCODE0_MASK                 (0xFC00U)
#define FLEXSPI_LUT_OPCODE0_SHIFT                (10U)
/*! OPCODE0 - OPCODE
 */
#define FLEXSPI_LUT_OPCODE0(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_OPCODE0_SHIFT)) & FLEXSPI_LUT_OPCODE0_MASK)
#define FLEXSPI_LUT_OPERAND1_MASK                (0xFF0000U)
#define FLEXSPI_LUT_OPERAND1_SHIFT               (16U)
/*! OPERAND1 - OPERAND1
 */
#define FLEXSPI_LUT_OPERAND1(x)                  (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_OPERAND1_SHIFT)) & FLEXSPI_LUT_OPERAND1_MASK)
#define FLEXSPI_LUT_NUM_PADS1_MASK               (0x3000000U)
#define FLEXSPI_LUT_NUM_PADS1_SHIFT              (24U)
/*! NUM_PADS1 - NUM_PADS1
 */
#define FLEXSPI_LUT_NUM_PADS1(x)                 (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_NUM_PADS1_SHIFT)) & FLEXSPI_LUT_NUM_PADS1_MASK)
#define FLEXSPI_LUT_OPCODE1_MASK                 (0xFC000000U)
#define FLEXSPI_LUT_OPCODE1_SHIFT                (26U)
/*! OPCODE1 - OPCODE1
 */
#define FLEXSPI_LUT_OPCODE1(x)                   (((uint32_t)(((uint32_t)(x)) << FLEXSPI_LUT_OPCODE1_SHIFT)) & FLEXSPI_LUT_OPCODE1_MASK)
/*! @} */

/* The count of FLEXSPI_LUT */
#define FLEXSPI_LUT_COUNT                        (64U)


/*!
 * @}
 */ /* end of group FLEXSPI_Register_Masks */


/* FLEXSPI - Peripheral instance base addresses */
/** Peripheral FLEXSPI0 base address */
#define FLEXSPI0_BASE                            (0x40134000u)
/** Peripheral FLEXSPI0 base pointer */
#define FLEXSPI0                                 ((FLEXSPI_Type *)FLEXSPI0_BASE)
/** Peripheral FLEXSPI1 base address */
#define FLEXSPI1_BASE                            (0x4013C000u)
/** Peripheral FLEXSPI1 base pointer */
#define FLEXSPI1                                 ((FLEXSPI_Type *)FLEXSPI1_BASE)
/** Array initializer of FLEXSPI peripheral base addresses */
#define FLEXSPI_BASE_ADDRS                       { FLEXSPI0_BASE, FLEXSPI1_BASE }
/** Array initializer of FLEXSPI peripheral base pointers */
#define FLEXSPI_BASE_PTRS                        { FLEXSPI0, FLEXSPI1 }
/* FlexSPI0 AMBA address. */
#define FlexSPI0_AMBA_BASE                       (0x08000000U)
/* FlexSPI1 AMBA address. */
#define FlexSPI1_AMBA_BASE                       (0x28000000U)


/*!
 * @}
 */ /* end of group FLEXSPI_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- FREQME Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FREQME_Peripheral_Access_Layer FREQME Peripheral Access Layer
 * @{
 */

/** FREQME - Register Layout Typedef */
typedef struct {
  union {                                          /* offset: 0x0 */
    __I  uint32_t FREQMECTRL_R;                      /**< Frequency Measurement (in Read mode), offset: 0x0 */
    __O  uint32_t FREQMECTRL_W;                      /**< Frequency Measurement (in Write mode), offset: 0x0 */
  };
} FREQME_Type;

/* ----------------------------------------------------------------------------
   -- FREQME Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup FREQME_Register_Masks FREQME Register Masks
 * @{
 */

/*! @name FREQMECTRL_R - Frequency Measurement (in Read mode) */
/*! @{ */
#define FREQME_FREQMECTRL_R_RESULT_MASK          (0x7FFFFFFFU)
#define FREQME_FREQMECTRL_R_RESULT_SHIFT         (0U)
/*! RESULT - Result
 */
#define FREQME_FREQMECTRL_R_RESULT(x)            (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_R_RESULT_SHIFT)) & FREQME_FREQMECTRL_R_RESULT_MASK)
#define FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS_MASK (0x80000000U)
#define FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS_SHIFT (31U)
/*! MEASURE_IN_PROGRESS - Measure in Progress
 *  0b0..Process complete. Measurement cycle is complete. The results are ready in the RESULT field.
 *  0b1..In Progress. Measurement cycle is in progress.
 */
#define FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS(x) (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS_SHIFT)) & FREQME_FREQMECTRL_R_MEASURE_IN_PROGRESS_MASK)
/*! @} */

/*! @name FREQMECTRL_W - Frequency Measurement (in Write mode) */
/*! @{ */
#define FREQME_FREQMECTRL_W_REF_SCALE_MASK       (0x1FU)
#define FREQME_FREQMECTRL_W_REF_SCALE_SHIFT      (0U)
/*! REF_SCALE - Reference Clock Scaling Factor
 *  0b00000..Count cycle = 2^0 = 1
 *  0b00001..Count cycle = 2^1 = 2
 *  0b00010..Count cycle = 2^4 = 4
 *  0b11111..Count cycle = 2^31 = 2,147,483,648
 */
#define FREQME_FREQMECTRL_W_REF_SCALE(x)         (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_REF_SCALE_SHIFT)) & FREQME_FREQMECTRL_W_REF_SCALE_MASK)
#define FREQME_FREQMECTRL_W_PULSE_MODE_MASK      (0x100U)
#define FREQME_FREQMECTRL_W_PULSE_MODE_SHIFT     (8U)
/*! PULSE_MODE - Pulse Width Measurement mode select
 *  0b0..Frequency Measurement Mode. FREQMECTRL works in a Frequency Measurement mode. Once the measurement starts
 *       (real count start is aligned at rising edge arrival on reference clock), the target counter increments by
 *       the target clock until the reference counter running by the reference clock reaches the count end point
 *       selected by REF_SCALE.
 *  0b1..Pulse Width Measurement mode. FREQMECTRL works in a Pulse Width Measurement mode, measuring the high or
 *       low period of reference clock input selected by PULSE_POL. The target counter starts incrementing by the
 *       target clock once a corresponding trigger edge (rising edge for high period measurement and falling edge for
 *       low period) occurs.
 */
#define FREQME_FREQMECTRL_W_PULSE_MODE(x)        (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_PULSE_MODE_SHIFT)) & FREQME_FREQMECTRL_W_PULSE_MODE_MASK)
#define FREQME_FREQMECTRL_W_PULSE_POL_MASK       (0x200U)
#define FREQME_FREQMECTRL_W_PULSE_POL_SHIFT      (9U)
/*! PULSE_POL - Pulse Polarity
 *  0b0..High Period. High period of reference clock is measured in Pulse Width Measurement mode triggered by the
 *       rising edge on the reference clock input.
 *  0b1..Low Period. Low period of reference clock is measured in Pulse Width Measurement mode triggered by the
 *       falling edge on the reference clock input.
 */
#define FREQME_FREQMECTRL_W_PULSE_POL(x)         (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_PULSE_POL_SHIFT)) & FREQME_FREQMECTRL_W_PULSE_POL_MASK)
#define FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS_MASK (0x80000000U)
#define FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS_SHIFT (31U)
/*! MEASURE_IN_PROGRESS - Measure in Progress
 *  0b0..Force Terminate. Forces the termination of any measurement cycle currently in progress and resets RESULT or just resets RESULT if in idle.
 *  0b1..Initiates Measurement Cycle. Initiates frequency or pulse width measurement process. Hardware clears the
 *       MEASURE_IN_PROGRESS bit when the measurement cycle completes. A new measurement starts if there is an
 *       active measurement in progress.
 */
#define FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS(x) (((uint32_t)(((uint32_t)(x)) << FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS_SHIFT)) & FREQME_FREQMECTRL_W_MEASURE_IN_PROGRESS_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group FREQME_Register_Masks */


/* FREQME - Peripheral instance base addresses */
/** Peripheral FREQME base address */
#define FREQME_BASE                              (0x4002F000u)
/** Peripheral FREQME base pointer */
#define FREQME                                   ((FREQME_Type *)FREQME_BASE)
/** Array initializer of FREQME peripheral base addresses */
#define FREQME_BASE_ADDRS                        { FREQME_BASE }
/** Array initializer of FREQME peripheral base pointers */
#define FREQME_BASE_PTRS                         { FREQME }

/*!
 * @}
 */ /* end of group FREQME_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- GPIO Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Peripheral_Access_Layer GPIO Peripheral Access Layer
 * @{
 */

/** GPIO - Register Layout Typedef */
typedef struct {
  __IO uint8_t B[8][32];                           /**< Byte pin registers for all port GPIO pins, array offset: 0x0, array step: index*0x20, index2*0x1 */
       uint8_t RESERVED_0[3840];
  __IO uint32_t W[8][32];                          /**< Word pin registers for all port GPIO pins, array offset: 0x1000, array step: index*0x80, index2*0x4 */
       uint8_t RESERVED_1[3072];
  __O  uint32_t DIR[8];                            /**< Port direction, array offset: 0x2000, array step: 0x4 */
       uint8_t RESERVED_2[96];
  __IO uint32_t MASK[8];                           /**< Port mask, array offset: 0x2080, array step: 0x4 */
       uint8_t RESERVED_3[96];
  __IO uint32_t PIN[8];                            /**< Port pin, array offset: 0x2100, array step: 0x4 */
       uint8_t RESERVED_4[96];
  __IO uint32_t MPIN[8];                           /**< Masked Port Pin, array offset: 0x2180, array step: 0x4 */
       uint8_t RESERVED_5[96];
  __IO uint32_t SET[8];                            /**< Port set, array offset: 0x2200, array step: 0x4 */
       uint8_t RESERVED_6[96];
  __IO uint32_t CLR[8];                            /**< Port clear, array offset: 0x2280, array step: 0x4 */
       uint8_t RESERVED_7[96];
  __O  uint32_t NOT[8];                            /**< Port toggle, array offset: 0x2300, array step: 0x4 */
       uint8_t RESERVED_8[96];
  __O  uint32_t DIRSET[8];                         /**< Port direction set, array offset: 0x2380, array step: 0x4 */
       uint8_t RESERVED_9[96];
  __IO uint32_t DIRCLR[8];                         /**< Port direction clear, array offset: 0x2400, array step: 0x4 */
       uint8_t RESERVED_10[96];
  __O  uint32_t DIRNOT[8];                         /**< Port direction toggle, array offset: 0x2480, array step: 0x4 */
       uint8_t RESERVED_11[96];
  __IO uint32_t INTENA[8];                         /**< Interrupt A enable control, array offset: 0x2500, array step: 0x4 */
       uint8_t RESERVED_12[96];
  __IO uint32_t INTENB[8];                         /**< Interrupt B enable control, array offset: 0x2580, array step: 0x4 */
       uint8_t RESERVED_13[96];
  __IO uint32_t INTPOL[8];                         /**< Interupt polarity control, array offset: 0x2600, array step: 0x4 */
       uint8_t RESERVED_14[96];
  __IO uint32_t INTEDG[8];                         /**< Interrupt edge select, array offset: 0x2680, array step: 0x4 */
       uint8_t RESERVED_15[96];
  __IO uint32_t INTSTATA[8];                       /**< Interrupt status for interrupt A, array offset: 0x2700, array step: 0x4 */
       uint8_t RESERVED_16[96];
  __IO uint32_t INTSTATB[8];                       /**< Interrupt status for interrupt B, array offset: 0x2780, array step: 0x4 */
} GPIO_Type;

/* ----------------------------------------------------------------------------
   -- GPIO Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup GPIO_Register_Masks GPIO Register Masks
 * @{
 */

/*! @name B - Byte pin registers for all port GPIO pins */
/*! @{ */
#define GPIO_B_PBYTE_MASK                        (0x1U)
#define GPIO_B_PBYTE_SHIFT                       (0U)
/*! PBYTE - Port Byte
 */
#define GPIO_B_PBYTE(x)                          (((uint8_t)(((uint8_t)(x)) << GPIO_B_PBYTE_SHIFT)) & GPIO_B_PBYTE_MASK)
/*! @} */

/* The count of GPIO_B */
#define GPIO_B_COUNT                             (8U)

/* The count of GPIO_B */
#define GPIO_B_COUNT2                            (32U)

/*! @name W - Word pin registers for all port GPIO pins */
/*! @{ */
#define GPIO_W_PWORD_MASK                        (0xFFFFFFFFU)
#define GPIO_W_PWORD_SHIFT                       (0U)
/*! PWORD - Read 0- pin PIOa_b is LOW. Write 0- clear output bit. Read 0xFFFF FFFF- pin PIOa_b is
 *    HIGH. Write any value 0x0000 0001 to 0xFFFF FFFF- sets output bit. Only 0 or 0xFFFF FFFF can be
 *    read. Writing any value other than 0 will set the output bit.
 */
#define GPIO_W_PWORD(x)                          (((uint32_t)(((uint32_t)(x)) << GPIO_W_PWORD_SHIFT)) & GPIO_W_PWORD_MASK)
/*! @} */

/* The count of GPIO_W */
#define GPIO_W_COUNT                             (8U)

/* The count of GPIO_W */
#define GPIO_W_COUNT2                            (32U)

/*! @name DIR - Port direction */
/*! @{ */
#define GPIO_DIR_DIRP0_MASK                      (0x1U)
#define GPIO_DIR_DIRP0_SHIFT                     (0U)
/*! DIRP0 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP0_SHIFT)) & GPIO_DIR_DIRP0_MASK)
#define GPIO_DIR_DIRP1_MASK                      (0x2U)
#define GPIO_DIR_DIRP1_SHIFT                     (1U)
/*! DIRP1 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP1_SHIFT)) & GPIO_DIR_DIRP1_MASK)
#define GPIO_DIR_DIRP2_MASK                      (0x4U)
#define GPIO_DIR_DIRP2_SHIFT                     (2U)
/*! DIRP2 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP2_SHIFT)) & GPIO_DIR_DIRP2_MASK)
#define GPIO_DIR_DIRP3_MASK                      (0x8U)
#define GPIO_DIR_DIRP3_SHIFT                     (3U)
/*! DIRP3 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP3_SHIFT)) & GPIO_DIR_DIRP3_MASK)
#define GPIO_DIR_DIRP4_MASK                      (0x10U)
#define GPIO_DIR_DIRP4_SHIFT                     (4U)
/*! DIRP4 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP4_SHIFT)) & GPIO_DIR_DIRP4_MASK)
#define GPIO_DIR_DIRP5_MASK                      (0x20U)
#define GPIO_DIR_DIRP5_SHIFT                     (5U)
/*! DIRP5 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP5_SHIFT)) & GPIO_DIR_DIRP5_MASK)
#define GPIO_DIR_DIRP6_MASK                      (0x40U)
#define GPIO_DIR_DIRP6_SHIFT                     (6U)
/*! DIRP6 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP6_SHIFT)) & GPIO_DIR_DIRP6_MASK)
#define GPIO_DIR_DIRP7_MASK                      (0x80U)
#define GPIO_DIR_DIRP7_SHIFT                     (7U)
/*! DIRP7 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP7_SHIFT)) & GPIO_DIR_DIRP7_MASK)
#define GPIO_DIR_DIRP8_MASK                      (0x100U)
#define GPIO_DIR_DIRP8_SHIFT                     (8U)
/*! DIRP8 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP8_SHIFT)) & GPIO_DIR_DIRP8_MASK)
#define GPIO_DIR_DIRP9_MASK                      (0x200U)
#define GPIO_DIR_DIRP9_SHIFT                     (9U)
/*! DIRP9 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP9_SHIFT)) & GPIO_DIR_DIRP9_MASK)
#define GPIO_DIR_DIRP10_MASK                     (0x400U)
#define GPIO_DIR_DIRP10_SHIFT                    (10U)
/*! DIRP10 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP10_SHIFT)) & GPIO_DIR_DIRP10_MASK)
#define GPIO_DIR_DIRP11_MASK                     (0x800U)
#define GPIO_DIR_DIRP11_SHIFT                    (11U)
/*! DIRP11 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP11_SHIFT)) & GPIO_DIR_DIRP11_MASK)
#define GPIO_DIR_DIRP12_MASK                     (0x1000U)
#define GPIO_DIR_DIRP12_SHIFT                    (12U)
/*! DIRP12 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP12_SHIFT)) & GPIO_DIR_DIRP12_MASK)
#define GPIO_DIR_DIRP13_MASK                     (0x2000U)
#define GPIO_DIR_DIRP13_SHIFT                    (13U)
/*! DIRP13 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP13_SHIFT)) & GPIO_DIR_DIRP13_MASK)
#define GPIO_DIR_DIRP14_MASK                     (0x4000U)
#define GPIO_DIR_DIRP14_SHIFT                    (14U)
/*! DIRP14 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP14_SHIFT)) & GPIO_DIR_DIRP14_MASK)
#define GPIO_DIR_DIRP15_MASK                     (0x8000U)
#define GPIO_DIR_DIRP15_SHIFT                    (15U)
/*! DIRP15 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP15_SHIFT)) & GPIO_DIR_DIRP15_MASK)
#define GPIO_DIR_DIRP16_MASK                     (0x10000U)
#define GPIO_DIR_DIRP16_SHIFT                    (16U)
/*! DIRP16 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP16_SHIFT)) & GPIO_DIR_DIRP16_MASK)
#define GPIO_DIR_DIRP17_MASK                     (0x20000U)
#define GPIO_DIR_DIRP17_SHIFT                    (17U)
/*! DIRP17 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP17_SHIFT)) & GPIO_DIR_DIRP17_MASK)
#define GPIO_DIR_DIRP18_MASK                     (0x40000U)
#define GPIO_DIR_DIRP18_SHIFT                    (18U)
/*! DIRP18 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP18_SHIFT)) & GPIO_DIR_DIRP18_MASK)
#define GPIO_DIR_DIRP19_MASK                     (0x80000U)
#define GPIO_DIR_DIRP19_SHIFT                    (19U)
/*! DIRP19 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP19_SHIFT)) & GPIO_DIR_DIRP19_MASK)
#define GPIO_DIR_DIRP20_MASK                     (0x100000U)
#define GPIO_DIR_DIRP20_SHIFT                    (20U)
/*! DIRP20 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP20_SHIFT)) & GPIO_DIR_DIRP20_MASK)
#define GPIO_DIR_DIRP21_MASK                     (0x200000U)
#define GPIO_DIR_DIRP21_SHIFT                    (21U)
/*! DIRP21 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP21_SHIFT)) & GPIO_DIR_DIRP21_MASK)
#define GPIO_DIR_DIRP22_MASK                     (0x400000U)
#define GPIO_DIR_DIRP22_SHIFT                    (22U)
/*! DIRP22 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP22_SHIFT)) & GPIO_DIR_DIRP22_MASK)
#define GPIO_DIR_DIRP23_MASK                     (0x800000U)
#define GPIO_DIR_DIRP23_SHIFT                    (23U)
/*! DIRP23 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP23_SHIFT)) & GPIO_DIR_DIRP23_MASK)
#define GPIO_DIR_DIRP24_MASK                     (0x1000000U)
#define GPIO_DIR_DIRP24_SHIFT                    (24U)
/*! DIRP24 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP24_SHIFT)) & GPIO_DIR_DIRP24_MASK)
#define GPIO_DIR_DIRP25_MASK                     (0x2000000U)
#define GPIO_DIR_DIRP25_SHIFT                    (25U)
/*! DIRP25 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP25_SHIFT)) & GPIO_DIR_DIRP25_MASK)
#define GPIO_DIR_DIRP26_MASK                     (0x4000000U)
#define GPIO_DIR_DIRP26_SHIFT                    (26U)
/*! DIRP26 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP26_SHIFT)) & GPIO_DIR_DIRP26_MASK)
#define GPIO_DIR_DIRP27_MASK                     (0x8000000U)
#define GPIO_DIR_DIRP27_SHIFT                    (27U)
/*! DIRP27 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP27_SHIFT)) & GPIO_DIR_DIRP27_MASK)
#define GPIO_DIR_DIRP28_MASK                     (0x10000000U)
#define GPIO_DIR_DIRP28_SHIFT                    (28U)
/*! DIRP28 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP28_SHIFT)) & GPIO_DIR_DIRP28_MASK)
#define GPIO_DIR_DIRP29_MASK                     (0x20000000U)
#define GPIO_DIR_DIRP29_SHIFT                    (29U)
/*! DIRP29 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP29_SHIFT)) & GPIO_DIR_DIRP29_MASK)
#define GPIO_DIR_DIRP30_MASK                     (0x40000000U)
#define GPIO_DIR_DIRP30_SHIFT                    (30U)
/*! DIRP30 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP30_SHIFT)) & GPIO_DIR_DIRP30_MASK)
#define GPIO_DIR_DIRP31_MASK                     (0x80000000U)
#define GPIO_DIR_DIRP31_SHIFT                    (31U)
/*! DIRP31 - Selects pin direction for pin PIOa_b.
 *  0b0..Input
 *  0b1..Output
 */
#define GPIO_DIR_DIRP31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_DIR_DIRP31_SHIFT)) & GPIO_DIR_DIRP31_MASK)
/*! @} */

/* The count of GPIO_DIR */
#define GPIO_DIR_COUNT                           (8U)

/*! @name MASK - Port mask */
/*! @{ */
#define GPIO_MASK_MASKP0_MASK                    (0x1U)
#define GPIO_MASK_MASKP0_SHIFT                   (0U)
/*! MASKP0 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP0(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP0_SHIFT)) & GPIO_MASK_MASKP0_MASK)
#define GPIO_MASK_MASKP1_MASK                    (0x2U)
#define GPIO_MASK_MASKP1_SHIFT                   (1U)
/*! MASKP1 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP1(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP1_SHIFT)) & GPIO_MASK_MASKP1_MASK)
#define GPIO_MASK_MASKP2_MASK                    (0x4U)
#define GPIO_MASK_MASKP2_SHIFT                   (2U)
/*! MASKP2 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP2(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP2_SHIFT)) & GPIO_MASK_MASKP2_MASK)
#define GPIO_MASK_MASKP3_MASK                    (0x8U)
#define GPIO_MASK_MASKP3_SHIFT                   (3U)
/*! MASKP3 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP3(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP3_SHIFT)) & GPIO_MASK_MASKP3_MASK)
#define GPIO_MASK_MASKP4_MASK                    (0x10U)
#define GPIO_MASK_MASKP4_SHIFT                   (4U)
/*! MASKP4 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP4(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP4_SHIFT)) & GPIO_MASK_MASKP4_MASK)
#define GPIO_MASK_MASKP5_MASK                    (0x20U)
#define GPIO_MASK_MASKP5_SHIFT                   (5U)
/*! MASKP5 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP5(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP5_SHIFT)) & GPIO_MASK_MASKP5_MASK)
#define GPIO_MASK_MASKP6_MASK                    (0x40U)
#define GPIO_MASK_MASKP6_SHIFT                   (6U)
/*! MASKP6 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP6(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP6_SHIFT)) & GPIO_MASK_MASKP6_MASK)
#define GPIO_MASK_MASKP7_MASK                    (0x80U)
#define GPIO_MASK_MASKP7_SHIFT                   (7U)
/*! MASKP7 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP7(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP7_SHIFT)) & GPIO_MASK_MASKP7_MASK)
#define GPIO_MASK_MASKP8_MASK                    (0x100U)
#define GPIO_MASK_MASKP8_SHIFT                   (8U)
/*! MASKP8 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP8(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP8_SHIFT)) & GPIO_MASK_MASKP8_MASK)
#define GPIO_MASK_MASKP9_MASK                    (0x200U)
#define GPIO_MASK_MASKP9_SHIFT                   (9U)
/*! MASKP9 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP9(x)                      (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP9_SHIFT)) & GPIO_MASK_MASKP9_MASK)
#define GPIO_MASK_MASKP10_MASK                   (0x400U)
#define GPIO_MASK_MASKP10_SHIFT                  (10U)
/*! MASKP10 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP10(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP10_SHIFT)) & GPIO_MASK_MASKP10_MASK)
#define GPIO_MASK_MASKP11_MASK                   (0x800U)
#define GPIO_MASK_MASKP11_SHIFT                  (11U)
/*! MASKP11 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP11(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP11_SHIFT)) & GPIO_MASK_MASKP11_MASK)
#define GPIO_MASK_MASKP12_MASK                   (0x1000U)
#define GPIO_MASK_MASKP12_SHIFT                  (12U)
/*! MASKP12 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP12(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP12_SHIFT)) & GPIO_MASK_MASKP12_MASK)
#define GPIO_MASK_MASKP13_MASK                   (0x2000U)
#define GPIO_MASK_MASKP13_SHIFT                  (13U)
/*! MASKP13 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP13(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP13_SHIFT)) & GPIO_MASK_MASKP13_MASK)
#define GPIO_MASK_MASKP14_MASK                   (0x4000U)
#define GPIO_MASK_MASKP14_SHIFT                  (14U)
/*! MASKP14 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP14(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP14_SHIFT)) & GPIO_MASK_MASKP14_MASK)
#define GPIO_MASK_MASKP15_MASK                   (0x8000U)
#define GPIO_MASK_MASKP15_SHIFT                  (15U)
/*! MASKP15 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP15(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP15_SHIFT)) & GPIO_MASK_MASKP15_MASK)
#define GPIO_MASK_MASKP16_MASK                   (0x10000U)
#define GPIO_MASK_MASKP16_SHIFT                  (16U)
/*! MASKP16 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP16(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP16_SHIFT)) & GPIO_MASK_MASKP16_MASK)
#define GPIO_MASK_MASKP17_MASK                   (0x20000U)
#define GPIO_MASK_MASKP17_SHIFT                  (17U)
/*! MASKP17 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP17(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP17_SHIFT)) & GPIO_MASK_MASKP17_MASK)
#define GPIO_MASK_MASKP18_MASK                   (0x40000U)
#define GPIO_MASK_MASKP18_SHIFT                  (18U)
/*! MASKP18 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP18(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP18_SHIFT)) & GPIO_MASK_MASKP18_MASK)
#define GPIO_MASK_MASKP19_MASK                   (0x80000U)
#define GPIO_MASK_MASKP19_SHIFT                  (19U)
/*! MASKP19 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP19(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP19_SHIFT)) & GPIO_MASK_MASKP19_MASK)
#define GPIO_MASK_MASKP20_MASK                   (0x100000U)
#define GPIO_MASK_MASKP20_SHIFT                  (20U)
/*! MASKP20 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP20(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP20_SHIFT)) & GPIO_MASK_MASKP20_MASK)
#define GPIO_MASK_MASKP21_MASK                   (0x200000U)
#define GPIO_MASK_MASKP21_SHIFT                  (21U)
/*! MASKP21 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP21(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP21_SHIFT)) & GPIO_MASK_MASKP21_MASK)
#define GPIO_MASK_MASKP22_MASK                   (0x400000U)
#define GPIO_MASK_MASKP22_SHIFT                  (22U)
/*! MASKP22 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP22(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP22_SHIFT)) & GPIO_MASK_MASKP22_MASK)
#define GPIO_MASK_MASKP23_MASK                   (0x800000U)
#define GPIO_MASK_MASKP23_SHIFT                  (23U)
/*! MASKP23 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP23(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP23_SHIFT)) & GPIO_MASK_MASKP23_MASK)
#define GPIO_MASK_MASKP24_MASK                   (0x1000000U)
#define GPIO_MASK_MASKP24_SHIFT                  (24U)
/*! MASKP24 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP24(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP24_SHIFT)) & GPIO_MASK_MASKP24_MASK)
#define GPIO_MASK_MASKP25_MASK                   (0x2000000U)
#define GPIO_MASK_MASKP25_SHIFT                  (25U)
/*! MASKP25 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP25(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP25_SHIFT)) & GPIO_MASK_MASKP25_MASK)
#define GPIO_MASK_MASKP26_MASK                   (0x4000000U)
#define GPIO_MASK_MASKP26_SHIFT                  (26U)
/*! MASKP26 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP26(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP26_SHIFT)) & GPIO_MASK_MASKP26_MASK)
#define GPIO_MASK_MASKP27_MASK                   (0x8000000U)
#define GPIO_MASK_MASKP27_SHIFT                  (27U)
/*! MASKP27 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP27(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP27_SHIFT)) & GPIO_MASK_MASKP27_MASK)
#define GPIO_MASK_MASKP28_MASK                   (0x10000000U)
#define GPIO_MASK_MASKP28_SHIFT                  (28U)
/*! MASKP28 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP28(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP28_SHIFT)) & GPIO_MASK_MASKP28_MASK)
#define GPIO_MASK_MASKP29_MASK                   (0x20000000U)
#define GPIO_MASK_MASKP29_SHIFT                  (29U)
/*! MASKP29 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP29(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP29_SHIFT)) & GPIO_MASK_MASKP29_MASK)
#define GPIO_MASK_MASKP30_MASK                   (0x40000000U)
#define GPIO_MASK_MASKP30_SHIFT                  (30U)
/*! MASKP30 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP30(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP30_SHIFT)) & GPIO_MASK_MASKP30_MASK)
#define GPIO_MASK_MASKP31_MASK                   (0x80000000U)
#define GPIO_MASK_MASKP31_SHIFT                  (31U)
/*! MASKP31 - Port Mask
 *  0b0..Read MPIN: pin state; write MPIN: load output bit
 *  0b1..Read MPIN: 0; write MPIN: output bit not affected
 */
#define GPIO_MASK_MASKP31(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MASK_MASKP31_SHIFT)) & GPIO_MASK_MASKP31_MASK)
/*! @} */

/* The count of GPIO_MASK */
#define GPIO_MASK_COUNT                          (8U)

/*! @name PIN - Port pin */
/*! @{ */
#define GPIO_PIN_PORT0_MASK                      (0x1U)
#define GPIO_PIN_PORT0_SHIFT                     (0U)
/*! PORT0 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT0_SHIFT)) & GPIO_PIN_PORT0_MASK)
#define GPIO_PIN_PORT1_MASK                      (0x2U)
#define GPIO_PIN_PORT1_SHIFT                     (1U)
/*! PORT1 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT1_SHIFT)) & GPIO_PIN_PORT1_MASK)
#define GPIO_PIN_PORT2_MASK                      (0x4U)
#define GPIO_PIN_PORT2_SHIFT                     (2U)
/*! PORT2 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT2_SHIFT)) & GPIO_PIN_PORT2_MASK)
#define GPIO_PIN_PORT3_MASK                      (0x8U)
#define GPIO_PIN_PORT3_SHIFT                     (3U)
/*! PORT3 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT3_SHIFT)) & GPIO_PIN_PORT3_MASK)
#define GPIO_PIN_PORT4_MASK                      (0x10U)
#define GPIO_PIN_PORT4_SHIFT                     (4U)
/*! PORT4 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT4_SHIFT)) & GPIO_PIN_PORT4_MASK)
#define GPIO_PIN_PORT5_MASK                      (0x20U)
#define GPIO_PIN_PORT5_SHIFT                     (5U)
/*! PORT5 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT5_SHIFT)) & GPIO_PIN_PORT5_MASK)
#define GPIO_PIN_PORT6_MASK                      (0x40U)
#define GPIO_PIN_PORT6_SHIFT                     (6U)
/*! PORT6 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT6_SHIFT)) & GPIO_PIN_PORT6_MASK)
#define GPIO_PIN_PORT7_MASK                      (0x80U)
#define GPIO_PIN_PORT7_SHIFT                     (7U)
/*! PORT7 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT7_SHIFT)) & GPIO_PIN_PORT7_MASK)
#define GPIO_PIN_PORT8_MASK                      (0x100U)
#define GPIO_PIN_PORT8_SHIFT                     (8U)
/*! PORT8 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT8_SHIFT)) & GPIO_PIN_PORT8_MASK)
#define GPIO_PIN_PORT9_MASK                      (0x200U)
#define GPIO_PIN_PORT9_SHIFT                     (9U)
/*! PORT9 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT9_SHIFT)) & GPIO_PIN_PORT9_MASK)
#define GPIO_PIN_PORT10_MASK                     (0x400U)
#define GPIO_PIN_PORT10_SHIFT                    (10U)
/*! PORT10 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT10_SHIFT)) & GPIO_PIN_PORT10_MASK)
#define GPIO_PIN_PORT11_MASK                     (0x800U)
#define GPIO_PIN_PORT11_SHIFT                    (11U)
/*! PORT11 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT11_SHIFT)) & GPIO_PIN_PORT11_MASK)
#define GPIO_PIN_PORT12_MASK                     (0x1000U)
#define GPIO_PIN_PORT12_SHIFT                    (12U)
/*! PORT12 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT12_SHIFT)) & GPIO_PIN_PORT12_MASK)
#define GPIO_PIN_PORT13_MASK                     (0x2000U)
#define GPIO_PIN_PORT13_SHIFT                    (13U)
/*! PORT13 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT13_SHIFT)) & GPIO_PIN_PORT13_MASK)
#define GPIO_PIN_PORT14_MASK                     (0x4000U)
#define GPIO_PIN_PORT14_SHIFT                    (14U)
/*! PORT14 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT14_SHIFT)) & GPIO_PIN_PORT14_MASK)
#define GPIO_PIN_PORT15_MASK                     (0x8000U)
#define GPIO_PIN_PORT15_SHIFT                    (15U)
/*! PORT15 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT15_SHIFT)) & GPIO_PIN_PORT15_MASK)
#define GPIO_PIN_PORT16_MASK                     (0x10000U)
#define GPIO_PIN_PORT16_SHIFT                    (16U)
/*! PORT16 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT16_SHIFT)) & GPIO_PIN_PORT16_MASK)
#define GPIO_PIN_PORT17_MASK                     (0x20000U)
#define GPIO_PIN_PORT17_SHIFT                    (17U)
/*! PORT17 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT17_SHIFT)) & GPIO_PIN_PORT17_MASK)
#define GPIO_PIN_PORT18_MASK                     (0x40000U)
#define GPIO_PIN_PORT18_SHIFT                    (18U)
/*! PORT18 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT18_SHIFT)) & GPIO_PIN_PORT18_MASK)
#define GPIO_PIN_PORT19_MASK                     (0x80000U)
#define GPIO_PIN_PORT19_SHIFT                    (19U)
/*! PORT19 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT19_SHIFT)) & GPIO_PIN_PORT19_MASK)
#define GPIO_PIN_PORT20_MASK                     (0x100000U)
#define GPIO_PIN_PORT20_SHIFT                    (20U)
/*! PORT20 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT20_SHIFT)) & GPIO_PIN_PORT20_MASK)
#define GPIO_PIN_PORT21_MASK                     (0x200000U)
#define GPIO_PIN_PORT21_SHIFT                    (21U)
/*! PORT21 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT21_SHIFT)) & GPIO_PIN_PORT21_MASK)
#define GPIO_PIN_PORT22_MASK                     (0x400000U)
#define GPIO_PIN_PORT22_SHIFT                    (22U)
/*! PORT22 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT22_SHIFT)) & GPIO_PIN_PORT22_MASK)
#define GPIO_PIN_PORT23_MASK                     (0x800000U)
#define GPIO_PIN_PORT23_SHIFT                    (23U)
/*! PORT23 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT23_SHIFT)) & GPIO_PIN_PORT23_MASK)
#define GPIO_PIN_PORT24_MASK                     (0x1000000U)
#define GPIO_PIN_PORT24_SHIFT                    (24U)
/*! PORT24 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT24_SHIFT)) & GPIO_PIN_PORT24_MASK)
#define GPIO_PIN_PORT25_MASK                     (0x2000000U)
#define GPIO_PIN_PORT25_SHIFT                    (25U)
/*! PORT25 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT25_SHIFT)) & GPIO_PIN_PORT25_MASK)
#define GPIO_PIN_PORT26_MASK                     (0x4000000U)
#define GPIO_PIN_PORT26_SHIFT                    (26U)
/*! PORT26 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT26_SHIFT)) & GPIO_PIN_PORT26_MASK)
#define GPIO_PIN_PORT27_MASK                     (0x8000000U)
#define GPIO_PIN_PORT27_SHIFT                    (27U)
/*! PORT27 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT27_SHIFT)) & GPIO_PIN_PORT27_MASK)
#define GPIO_PIN_PORT28_MASK                     (0x10000000U)
#define GPIO_PIN_PORT28_SHIFT                    (28U)
/*! PORT28 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT28_SHIFT)) & GPIO_PIN_PORT28_MASK)
#define GPIO_PIN_PORT29_MASK                     (0x20000000U)
#define GPIO_PIN_PORT29_SHIFT                    (29U)
/*! PORT29 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT29_SHIFT)) & GPIO_PIN_PORT29_MASK)
#define GPIO_PIN_PORT30_MASK                     (0x40000000U)
#define GPIO_PIN_PORT30_SHIFT                    (30U)
/*! PORT30 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT30_SHIFT)) & GPIO_PIN_PORT30_MASK)
#define GPIO_PIN_PORT31_MASK                     (0x80000000U)
#define GPIO_PIN_PORT31_SHIFT                    (31U)
/*! PORT31 - Port pins
 *  0b0..Read- pin is low; Write- clear output bit
 *  0b1..Read- pin is high; Write- set output bit
 */
#define GPIO_PIN_PORT31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_PIN_PORT31_SHIFT)) & GPIO_PIN_PORT31_MASK)
/*! @} */

/* The count of GPIO_PIN */
#define GPIO_PIN_COUNT                           (8U)

/*! @name MPIN - Masked Port Pin */
/*! @{ */
#define GPIO_MPIN_MPORTP0_MASK                   (0x1U)
#define GPIO_MPIN_MPORTP0_SHIFT                  (0U)
/*! MPORTP0 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP0(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP0_SHIFT)) & GPIO_MPIN_MPORTP0_MASK)
#define GPIO_MPIN_MPORTP1_MASK                   (0x2U)
#define GPIO_MPIN_MPORTP1_SHIFT                  (1U)
/*! MPORTP1 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP1(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP1_SHIFT)) & GPIO_MPIN_MPORTP1_MASK)
#define GPIO_MPIN_MPORTP2_MASK                   (0x4U)
#define GPIO_MPIN_MPORTP2_SHIFT                  (2U)
/*! MPORTP2 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP2(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP2_SHIFT)) & GPIO_MPIN_MPORTP2_MASK)
#define GPIO_MPIN_MPORTP3_MASK                   (0x8U)
#define GPIO_MPIN_MPORTP3_SHIFT                  (3U)
/*! MPORTP3 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP3(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP3_SHIFT)) & GPIO_MPIN_MPORTP3_MASK)
#define GPIO_MPIN_MPORTP4_MASK                   (0x10U)
#define GPIO_MPIN_MPORTP4_SHIFT                  (4U)
/*! MPORTP4 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP4(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP4_SHIFT)) & GPIO_MPIN_MPORTP4_MASK)
#define GPIO_MPIN_MPORTP5_MASK                   (0x20U)
#define GPIO_MPIN_MPORTP5_SHIFT                  (5U)
/*! MPORTP5 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP5(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP5_SHIFT)) & GPIO_MPIN_MPORTP5_MASK)
#define GPIO_MPIN_MPORTP6_MASK                   (0x40U)
#define GPIO_MPIN_MPORTP6_SHIFT                  (6U)
/*! MPORTP6 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP6(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP6_SHIFT)) & GPIO_MPIN_MPORTP6_MASK)
#define GPIO_MPIN_MPORTP7_MASK                   (0x80U)
#define GPIO_MPIN_MPORTP7_SHIFT                  (7U)
/*! MPORTP7 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP7(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP7_SHIFT)) & GPIO_MPIN_MPORTP7_MASK)
#define GPIO_MPIN_MPORTP8_MASK                   (0x100U)
#define GPIO_MPIN_MPORTP8_SHIFT                  (8U)
/*! MPORTP8 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP8(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP8_SHIFT)) & GPIO_MPIN_MPORTP8_MASK)
#define GPIO_MPIN_MPORTP9_MASK                   (0x200U)
#define GPIO_MPIN_MPORTP9_SHIFT                  (9U)
/*! MPORTP9 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP9(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP9_SHIFT)) & GPIO_MPIN_MPORTP9_MASK)
#define GPIO_MPIN_MPORTP10_MASK                  (0x400U)
#define GPIO_MPIN_MPORTP10_SHIFT                 (10U)
/*! MPORTP10 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP10(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP10_SHIFT)) & GPIO_MPIN_MPORTP10_MASK)
#define GPIO_MPIN_MPORTP11_MASK                  (0x800U)
#define GPIO_MPIN_MPORTP11_SHIFT                 (11U)
/*! MPORTP11 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP11(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP11_SHIFT)) & GPIO_MPIN_MPORTP11_MASK)
#define GPIO_MPIN_MPORTP12_MASK                  (0x1000U)
#define GPIO_MPIN_MPORTP12_SHIFT                 (12U)
/*! MPORTP12 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP12(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP12_SHIFT)) & GPIO_MPIN_MPORTP12_MASK)
#define GPIO_MPIN_MPORTP13_MASK                  (0x2000U)
#define GPIO_MPIN_MPORTP13_SHIFT                 (13U)
/*! MPORTP13 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP13(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP13_SHIFT)) & GPIO_MPIN_MPORTP13_MASK)
#define GPIO_MPIN_MPORTP14_MASK                  (0x4000U)
#define GPIO_MPIN_MPORTP14_SHIFT                 (14U)
/*! MPORTP14 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP14(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP14_SHIFT)) & GPIO_MPIN_MPORTP14_MASK)
#define GPIO_MPIN_MPORTP15_MASK                  (0x8000U)
#define GPIO_MPIN_MPORTP15_SHIFT                 (15U)
/*! MPORTP15 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP15(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP15_SHIFT)) & GPIO_MPIN_MPORTP15_MASK)
#define GPIO_MPIN_MPORTP16_MASK                  (0x10000U)
#define GPIO_MPIN_MPORTP16_SHIFT                 (16U)
/*! MPORTP16 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP16(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP16_SHIFT)) & GPIO_MPIN_MPORTP16_MASK)
#define GPIO_MPIN_MPORTP17_MASK                  (0x20000U)
#define GPIO_MPIN_MPORTP17_SHIFT                 (17U)
/*! MPORTP17 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP17(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP17_SHIFT)) & GPIO_MPIN_MPORTP17_MASK)
#define GPIO_MPIN_MPORTP18_MASK                  (0x40000U)
#define GPIO_MPIN_MPORTP18_SHIFT                 (18U)
/*! MPORTP18 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP18(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP18_SHIFT)) & GPIO_MPIN_MPORTP18_MASK)
#define GPIO_MPIN_MPORTP19_MASK                  (0x80000U)
#define GPIO_MPIN_MPORTP19_SHIFT                 (19U)
/*! MPORTP19 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP19(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP19_SHIFT)) & GPIO_MPIN_MPORTP19_MASK)
#define GPIO_MPIN_MPORTP20_MASK                  (0x100000U)
#define GPIO_MPIN_MPORTP20_SHIFT                 (20U)
/*! MPORTP20 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP20(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP20_SHIFT)) & GPIO_MPIN_MPORTP20_MASK)
#define GPIO_MPIN_MPORTP21_MASK                  (0x200000U)
#define GPIO_MPIN_MPORTP21_SHIFT                 (21U)
/*! MPORTP21 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP21(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP21_SHIFT)) & GPIO_MPIN_MPORTP21_MASK)
#define GPIO_MPIN_MPORTP22_MASK                  (0x400000U)
#define GPIO_MPIN_MPORTP22_SHIFT                 (22U)
/*! MPORTP22 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP22(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP22_SHIFT)) & GPIO_MPIN_MPORTP22_MASK)
#define GPIO_MPIN_MPORTP23_MASK                  (0x800000U)
#define GPIO_MPIN_MPORTP23_SHIFT                 (23U)
/*! MPORTP23 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP23(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP23_SHIFT)) & GPIO_MPIN_MPORTP23_MASK)
#define GPIO_MPIN_MPORTP24_MASK                  (0x1000000U)
#define GPIO_MPIN_MPORTP24_SHIFT                 (24U)
/*! MPORTP24 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP24(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP24_SHIFT)) & GPIO_MPIN_MPORTP24_MASK)
#define GPIO_MPIN_MPORTP25_MASK                  (0x2000000U)
#define GPIO_MPIN_MPORTP25_SHIFT                 (25U)
/*! MPORTP25 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP25(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP25_SHIFT)) & GPIO_MPIN_MPORTP25_MASK)
#define GPIO_MPIN_MPORTP26_MASK                  (0x4000000U)
#define GPIO_MPIN_MPORTP26_SHIFT                 (26U)
/*! MPORTP26 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP26(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP26_SHIFT)) & GPIO_MPIN_MPORTP26_MASK)
#define GPIO_MPIN_MPORTP27_MASK                  (0x8000000U)
#define GPIO_MPIN_MPORTP27_SHIFT                 (27U)
/*! MPORTP27 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP27(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP27_SHIFT)) & GPIO_MPIN_MPORTP27_MASK)
#define GPIO_MPIN_MPORTP28_MASK                  (0x10000000U)
#define GPIO_MPIN_MPORTP28_SHIFT                 (28U)
/*! MPORTP28 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP28(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP28_SHIFT)) & GPIO_MPIN_MPORTP28_MASK)
#define GPIO_MPIN_MPORTP29_MASK                  (0x20000000U)
#define GPIO_MPIN_MPORTP29_SHIFT                 (29U)
/*! MPORTP29 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP29(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP29_SHIFT)) & GPIO_MPIN_MPORTP29_MASK)
#define GPIO_MPIN_MPORTP30_MASK                  (0x40000000U)
#define GPIO_MPIN_MPORTP30_SHIFT                 (30U)
/*! MPORTP30 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP30(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP30_SHIFT)) & GPIO_MPIN_MPORTP30_MASK)
#define GPIO_MPIN_MPORTP31_MASK                  (0x80000000U)
#define GPIO_MPIN_MPORTP31_SHIFT                 (31U)
/*! MPORTP31 - Mask bits for port pins
 *  0b0..Read- pin is LOW and/or the corresponding bit in the MASK register is 1; write- clear output bit if the
 *       corresponding bit in the MASK register is 0
 *  0b1..Read- pin is HIGH and the corresponding bit in the MASK register is 0; write- set output bit if the
 *       corresponding bit in the MASK register is 0
 */
#define GPIO_MPIN_MPORTP31(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_MPIN_MPORTP31_SHIFT)) & GPIO_MPIN_MPORTP31_MASK)
/*! @} */

/* The count of GPIO_MPIN */
#define GPIO_MPIN_COUNT                          (8U)

/*! @name SET - Port set */
/*! @{ */
#define GPIO_SET_SETP_MASK                       (0xFFFFFFFFU)
#define GPIO_SET_SETP_SHIFT                      (0U)
/*! SETP - Read or set output bits
 *  0b00000000000000000000000000000000..Read- output bit; write- no operation
 *  0b00000000000000000000000000000001..Read- output bit; write- set output bit
 */
#define GPIO_SET_SETP(x)                         (((uint32_t)(((uint32_t)(x)) << GPIO_SET_SETP_SHIFT)) & GPIO_SET_SETP_MASK)
/*! @} */

/* The count of GPIO_SET */
#define GPIO_SET_COUNT                           (8U)

/*! @name CLR - Port clear */
/*! @{ */
#define GPIO_CLR_CLRP0_MASK                      (0x1U)
#define GPIO_CLR_CLRP0_SHIFT                     (0U)
/*! CLRP0 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP0_SHIFT)) & GPIO_CLR_CLRP0_MASK)
#define GPIO_CLR_CLRP1_MASK                      (0x2U)
#define GPIO_CLR_CLRP1_SHIFT                     (1U)
/*! CLRP1 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP1_SHIFT)) & GPIO_CLR_CLRP1_MASK)
#define GPIO_CLR_CLRP2_MASK                      (0x4U)
#define GPIO_CLR_CLRP2_SHIFT                     (2U)
/*! CLRP2 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP2_SHIFT)) & GPIO_CLR_CLRP2_MASK)
#define GPIO_CLR_CLRP3_MASK                      (0x8U)
#define GPIO_CLR_CLRP3_SHIFT                     (3U)
/*! CLRP3 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP3_SHIFT)) & GPIO_CLR_CLRP3_MASK)
#define GPIO_CLR_CLRP4_MASK                      (0x10U)
#define GPIO_CLR_CLRP4_SHIFT                     (4U)
/*! CLRP4 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP4_SHIFT)) & GPIO_CLR_CLRP4_MASK)
#define GPIO_CLR_CLRP5_MASK                      (0x20U)
#define GPIO_CLR_CLRP5_SHIFT                     (5U)
/*! CLRP5 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP5_SHIFT)) & GPIO_CLR_CLRP5_MASK)
#define GPIO_CLR_CLRP6_MASK                      (0x40U)
#define GPIO_CLR_CLRP6_SHIFT                     (6U)
/*! CLRP6 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP6_SHIFT)) & GPIO_CLR_CLRP6_MASK)
#define GPIO_CLR_CLRP7_MASK                      (0x80U)
#define GPIO_CLR_CLRP7_SHIFT                     (7U)
/*! CLRP7 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP7_SHIFT)) & GPIO_CLR_CLRP7_MASK)
#define GPIO_CLR_CLRP8_MASK                      (0x100U)
#define GPIO_CLR_CLRP8_SHIFT                     (8U)
/*! CLRP8 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP8_SHIFT)) & GPIO_CLR_CLRP8_MASK)
#define GPIO_CLR_CLRP9_MASK                      (0x200U)
#define GPIO_CLR_CLRP9_SHIFT                     (9U)
/*! CLRP9 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP9_SHIFT)) & GPIO_CLR_CLRP9_MASK)
#define GPIO_CLR_CLRP10_MASK                     (0x400U)
#define GPIO_CLR_CLRP10_SHIFT                    (10U)
/*! CLRP10 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP10_SHIFT)) & GPIO_CLR_CLRP10_MASK)
#define GPIO_CLR_CLRP11_MASK                     (0x800U)
#define GPIO_CLR_CLRP11_SHIFT                    (11U)
/*! CLRP11 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP11_SHIFT)) & GPIO_CLR_CLRP11_MASK)
#define GPIO_CLR_CLRP12_MASK                     (0x1000U)
#define GPIO_CLR_CLRP12_SHIFT                    (12U)
/*! CLRP12 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP12_SHIFT)) & GPIO_CLR_CLRP12_MASK)
#define GPIO_CLR_CLRP13_MASK                     (0x2000U)
#define GPIO_CLR_CLRP13_SHIFT                    (13U)
/*! CLRP13 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP13_SHIFT)) & GPIO_CLR_CLRP13_MASK)
#define GPIO_CLR_CLRP14_MASK                     (0x4000U)
#define GPIO_CLR_CLRP14_SHIFT                    (14U)
/*! CLRP14 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP14_SHIFT)) & GPIO_CLR_CLRP14_MASK)
#define GPIO_CLR_CLRP15_MASK                     (0x8000U)
#define GPIO_CLR_CLRP15_SHIFT                    (15U)
/*! CLRP15 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP15_SHIFT)) & GPIO_CLR_CLRP15_MASK)
#define GPIO_CLR_CLRP16_MASK                     (0x10000U)
#define GPIO_CLR_CLRP16_SHIFT                    (16U)
/*! CLRP16 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP16_SHIFT)) & GPIO_CLR_CLRP16_MASK)
#define GPIO_CLR_CLRP17_MASK                     (0x20000U)
#define GPIO_CLR_CLRP17_SHIFT                    (17U)
/*! CLRP17 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP17_SHIFT)) & GPIO_CLR_CLRP17_MASK)
#define GPIO_CLR_CLRP18_MASK                     (0x40000U)
#define GPIO_CLR_CLRP18_SHIFT                    (18U)
/*! CLRP18 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP18_SHIFT)) & GPIO_CLR_CLRP18_MASK)
#define GPIO_CLR_CLRP19_MASK                     (0x80000U)
#define GPIO_CLR_CLRP19_SHIFT                    (19U)
/*! CLRP19 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP19_SHIFT)) & GPIO_CLR_CLRP19_MASK)
#define GPIO_CLR_CLRP20_MASK                     (0x100000U)
#define GPIO_CLR_CLRP20_SHIFT                    (20U)
/*! CLRP20 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP20_SHIFT)) & GPIO_CLR_CLRP20_MASK)
#define GPIO_CLR_CLRP21_MASK                     (0x200000U)
#define GPIO_CLR_CLRP21_SHIFT                    (21U)
/*! CLRP21 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP21_SHIFT)) & GPIO_CLR_CLRP21_MASK)
#define GPIO_CLR_CLRP22_MASK                     (0x400000U)
#define GPIO_CLR_CLRP22_SHIFT                    (22U)
/*! CLRP22 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP22_SHIFT)) & GPIO_CLR_CLRP22_MASK)
#define GPIO_CLR_CLRP23_MASK                     (0x800000U)
#define GPIO_CLR_CLRP23_SHIFT                    (23U)
/*! CLRP23 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP23_SHIFT)) & GPIO_CLR_CLRP23_MASK)
#define GPIO_CLR_CLRP24_MASK                     (0x1000000U)
#define GPIO_CLR_CLRP24_SHIFT                    (24U)
/*! CLRP24 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP24_SHIFT)) & GPIO_CLR_CLRP24_MASK)
#define GPIO_CLR_CLRP25_MASK                     (0x2000000U)
#define GPIO_CLR_CLRP25_SHIFT                    (25U)
/*! CLRP25 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP25_SHIFT)) & GPIO_CLR_CLRP25_MASK)
#define GPIO_CLR_CLRP26_MASK                     (0x4000000U)
#define GPIO_CLR_CLRP26_SHIFT                    (26U)
/*! CLRP26 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP26_SHIFT)) & GPIO_CLR_CLRP26_MASK)
#define GPIO_CLR_CLRP27_MASK                     (0x8000000U)
#define GPIO_CLR_CLRP27_SHIFT                    (27U)
/*! CLRP27 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP27_SHIFT)) & GPIO_CLR_CLRP27_MASK)
#define GPIO_CLR_CLRP28_MASK                     (0x10000000U)
#define GPIO_CLR_CLRP28_SHIFT                    (28U)
/*! CLRP28 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP28_SHIFT)) & GPIO_CLR_CLRP28_MASK)
#define GPIO_CLR_CLRP29_MASK                     (0x20000000U)
#define GPIO_CLR_CLRP29_SHIFT                    (29U)
/*! CLRP29 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP29_SHIFT)) & GPIO_CLR_CLRP29_MASK)
#define GPIO_CLR_CLRP30_MASK                     (0x40000000U)
#define GPIO_CLR_CLRP30_SHIFT                    (30U)
/*! CLRP30 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP30_SHIFT)) & GPIO_CLR_CLRP30_MASK)
#define GPIO_CLR_CLRP31_MASK                     (0x80000000U)
#define GPIO_CLR_CLRP31_SHIFT                    (31U)
/*! CLRP31 - Clear output bits
 *  0b0..No operation
 *  0b1..Clears output bit
 */
#define GPIO_CLR_CLRP31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_CLR_CLRP31_SHIFT)) & GPIO_CLR_CLRP31_MASK)
/*! @} */

/* The count of GPIO_CLR */
#define GPIO_CLR_COUNT                           (8U)

/*! @name NOT - Port toggle */
/*! @{ */
#define GPIO_NOT_NOTP0_MASK                      (0x1U)
#define GPIO_NOT_NOTP0_SHIFT                     (0U)
/*! NOTP0 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP0(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP0_SHIFT)) & GPIO_NOT_NOTP0_MASK)
#define GPIO_NOT_NOTP1_MASK                      (0x2U)
#define GPIO_NOT_NOTP1_SHIFT                     (1U)
/*! NOTP1 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP1(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP1_SHIFT)) & GPIO_NOT_NOTP1_MASK)
#define GPIO_NOT_NOTP2_MASK                      (0x4U)
#define GPIO_NOT_NOTP2_SHIFT                     (2U)
/*! NOTP2 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP2(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP2_SHIFT)) & GPIO_NOT_NOTP2_MASK)
#define GPIO_NOT_NOTP3_MASK                      (0x8U)
#define GPIO_NOT_NOTP3_SHIFT                     (3U)
/*! NOTP3 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP3(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP3_SHIFT)) & GPIO_NOT_NOTP3_MASK)
#define GPIO_NOT_NOTP4_MASK                      (0x10U)
#define GPIO_NOT_NOTP4_SHIFT                     (4U)
/*! NOTP4 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP4(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP4_SHIFT)) & GPIO_NOT_NOTP4_MASK)
#define GPIO_NOT_NOTP5_MASK                      (0x20U)
#define GPIO_NOT_NOTP5_SHIFT                     (5U)
/*! NOTP5 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP5(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP5_SHIFT)) & GPIO_NOT_NOTP5_MASK)
#define GPIO_NOT_NOTP6_MASK                      (0x40U)
#define GPIO_NOT_NOTP6_SHIFT                     (6U)
/*! NOTP6 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP6(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP6_SHIFT)) & GPIO_NOT_NOTP6_MASK)
#define GPIO_NOT_NOTP7_MASK                      (0x80U)
#define GPIO_NOT_NOTP7_SHIFT                     (7U)
/*! NOTP7 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP7(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP7_SHIFT)) & GPIO_NOT_NOTP7_MASK)
#define GPIO_NOT_NOTP8_MASK                      (0x100U)
#define GPIO_NOT_NOTP8_SHIFT                     (8U)
/*! NOTP8 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP8(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP8_SHIFT)) & GPIO_NOT_NOTP8_MASK)
#define GPIO_NOT_NOTP9_MASK                      (0x200U)
#define GPIO_NOT_NOTP9_SHIFT                     (9U)
/*! NOTP9 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP9(x)                        (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP9_SHIFT)) & GPIO_NOT_NOTP9_MASK)
#define GPIO_NOT_NOTP10_MASK                     (0x400U)
#define GPIO_NOT_NOTP10_SHIFT                    (10U)
/*! NOTP10 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP10(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP10_SHIFT)) & GPIO_NOT_NOTP10_MASK)
#define GPIO_NOT_NOTP11_MASK                     (0x800U)
#define GPIO_NOT_NOTP11_SHIFT                    (11U)
/*! NOTP11 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP11(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP11_SHIFT)) & GPIO_NOT_NOTP11_MASK)
#define GPIO_NOT_NOTP12_MASK                     (0x1000U)
#define GPIO_NOT_NOTP12_SHIFT                    (12U)
/*! NOTP12 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP12(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP12_SHIFT)) & GPIO_NOT_NOTP12_MASK)
#define GPIO_NOT_NOTP13_MASK                     (0x2000U)
#define GPIO_NOT_NOTP13_SHIFT                    (13U)
/*! NOTP13 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP13(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP13_SHIFT)) & GPIO_NOT_NOTP13_MASK)
#define GPIO_NOT_NOTP14_MASK                     (0x4000U)
#define GPIO_NOT_NOTP14_SHIFT                    (14U)
/*! NOTP14 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP14(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP14_SHIFT)) & GPIO_NOT_NOTP14_MASK)
#define GPIO_NOT_NOTP15_MASK                     (0x8000U)
#define GPIO_NOT_NOTP15_SHIFT                    (15U)
/*! NOTP15 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP15(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP15_SHIFT)) & GPIO_NOT_NOTP15_MASK)
#define GPIO_NOT_NOTP16_MASK                     (0x10000U)
#define GPIO_NOT_NOTP16_SHIFT                    (16U)
/*! NOTP16 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP16(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP16_SHIFT)) & GPIO_NOT_NOTP16_MASK)
#define GPIO_NOT_NOTP17_MASK                     (0x20000U)
#define GPIO_NOT_NOTP17_SHIFT                    (17U)
/*! NOTP17 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP17(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP17_SHIFT)) & GPIO_NOT_NOTP17_MASK)
#define GPIO_NOT_NOTP18_MASK                     (0x40000U)
#define GPIO_NOT_NOTP18_SHIFT                    (18U)
/*! NOTP18 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP18(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP18_SHIFT)) & GPIO_NOT_NOTP18_MASK)
#define GPIO_NOT_NOTP19_MASK                     (0x80000U)
#define GPIO_NOT_NOTP19_SHIFT                    (19U)
/*! NOTP19 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP19(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP19_SHIFT)) & GPIO_NOT_NOTP19_MASK)
#define GPIO_NOT_NOTP20_MASK                     (0x100000U)
#define GPIO_NOT_NOTP20_SHIFT                    (20U)
/*! NOTP20 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP20(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP20_SHIFT)) & GPIO_NOT_NOTP20_MASK)
#define GPIO_NOT_NOTP21_MASK                     (0x200000U)
#define GPIO_NOT_NOTP21_SHIFT                    (21U)
/*! NOTP21 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP21(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP21_SHIFT)) & GPIO_NOT_NOTP21_MASK)
#define GPIO_NOT_NOTP22_MASK                     (0x400000U)
#define GPIO_NOT_NOTP22_SHIFT                    (22U)
/*! NOTP22 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP22(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP22_SHIFT)) & GPIO_NOT_NOTP22_MASK)
#define GPIO_NOT_NOTP23_MASK                     (0x800000U)
#define GPIO_NOT_NOTP23_SHIFT                    (23U)
/*! NOTP23 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP23(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP23_SHIFT)) & GPIO_NOT_NOTP23_MASK)
#define GPIO_NOT_NOTP24_MASK                     (0x1000000U)
#define GPIO_NOT_NOTP24_SHIFT                    (24U)
/*! NOTP24 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP24(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP24_SHIFT)) & GPIO_NOT_NOTP24_MASK)
#define GPIO_NOT_NOTP25_MASK                     (0x2000000U)
#define GPIO_NOT_NOTP25_SHIFT                    (25U)
/*! NOTP25 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP25(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP25_SHIFT)) & GPIO_NOT_NOTP25_MASK)
#define GPIO_NOT_NOTP26_MASK                     (0x4000000U)
#define GPIO_NOT_NOTP26_SHIFT                    (26U)
/*! NOTP26 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP26(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP26_SHIFT)) & GPIO_NOT_NOTP26_MASK)
#define GPIO_NOT_NOTP27_MASK                     (0x8000000U)
#define GPIO_NOT_NOTP27_SHIFT                    (27U)
/*! NOTP27 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP27(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP27_SHIFT)) & GPIO_NOT_NOTP27_MASK)
#define GPIO_NOT_NOTP28_MASK                     (0x10000000U)
#define GPIO_NOT_NOTP28_SHIFT                    (28U)
/*! NOTP28 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP28(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP28_SHIFT)) & GPIO_NOT_NOTP28_MASK)
#define GPIO_NOT_NOTP29_MASK                     (0x20000000U)
#define GPIO_NOT_NOTP29_SHIFT                    (29U)
/*! NOTP29 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP29(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP29_SHIFT)) & GPIO_NOT_NOTP29_MASK)
#define GPIO_NOT_NOTP30_MASK                     (0x40000000U)
#define GPIO_NOT_NOTP30_SHIFT                    (30U)
/*! NOTP30 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP30(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP30_SHIFT)) & GPIO_NOT_NOTP30_MASK)
#define GPIO_NOT_NOTP31_MASK                     (0x80000000U)
#define GPIO_NOT_NOTP31_SHIFT                    (31U)
/*! NOTP31 - Toggle output bits
 *  0b0..No operation
 *  0b1..Toggle output bit
 */
#define GPIO_NOT_NOTP31(x)                       (((uint32_t)(((uint32_t)(x)) << GPIO_NOT_NOTP31_SHIFT)) & GPIO_NOT_NOTP31_MASK)
/*! @} */

/* The count of GPIO_NOT */
#define GPIO_NOT_COUNT                           (8U)

/*! @name DIRSET - Port direction set */
/*! @{ */
#define GPIO_DIRSET_DIRSETP0_MASK                (0x1U)
#define GPIO_DIRSET_DIRSETP0_SHIFT               (0U)
/*! DIRSETP0 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP0(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP0_SHIFT)) & GPIO_DIRSET_DIRSETP0_MASK)
#define GPIO_DIRSET_DIRSETP1_MASK                (0x2U)
#define GPIO_DIRSET_DIRSETP1_SHIFT               (1U)
/*! DIRSETP1 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP1(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP1_SHIFT)) & GPIO_DIRSET_DIRSETP1_MASK)
#define GPIO_DIRSET_DIRSETP2_MASK                (0x4U)
#define GPIO_DIRSET_DIRSETP2_SHIFT               (2U)
/*! DIRSETP2 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP2(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP2_SHIFT)) & GPIO_DIRSET_DIRSETP2_MASK)
#define GPIO_DIRSET_DIRSETP3_MASK                (0x8U)
#define GPIO_DIRSET_DIRSETP3_SHIFT               (3U)
/*! DIRSETP3 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP3(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP3_SHIFT)) & GPIO_DIRSET_DIRSETP3_MASK)
#define GPIO_DIRSET_DIRSETP4_MASK                (0x10U)
#define GPIO_DIRSET_DIRSETP4_SHIFT               (4U)
/*! DIRSETP4 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP4(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP4_SHIFT)) & GPIO_DIRSET_DIRSETP4_MASK)
#define GPIO_DIRSET_DIRSETP5_MASK                (0x20U)
#define GPIO_DIRSET_DIRSETP5_SHIFT               (5U)
/*! DIRSETP5 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP5(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP5_SHIFT)) & GPIO_DIRSET_DIRSETP5_MASK)
#define GPIO_DIRSET_DIRSETP6_MASK                (0x40U)
#define GPIO_DIRSET_DIRSETP6_SHIFT               (6U)
/*! DIRSETP6 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP6(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP6_SHIFT)) & GPIO_DIRSET_DIRSETP6_MASK)
#define GPIO_DIRSET_DIRSETP7_MASK                (0x80U)
#define GPIO_DIRSET_DIRSETP7_SHIFT               (7U)
/*! DIRSETP7 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP7(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP7_SHIFT)) & GPIO_DIRSET_DIRSETP7_MASK)
#define GPIO_DIRSET_DIRSETP8_MASK                (0x100U)
#define GPIO_DIRSET_DIRSETP8_SHIFT               (8U)
/*! DIRSETP8 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP8(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP8_SHIFT)) & GPIO_DIRSET_DIRSETP8_MASK)
#define GPIO_DIRSET_DIRSETP9_MASK                (0x200U)
#define GPIO_DIRSET_DIRSETP9_SHIFT               (9U)
/*! DIRSETP9 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP9(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP9_SHIFT)) & GPIO_DIRSET_DIRSETP9_MASK)
#define GPIO_DIRSET_DIRSETP10_MASK               (0x400U)
#define GPIO_DIRSET_DIRSETP10_SHIFT              (10U)
/*! DIRSETP10 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP10(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP10_SHIFT)) & GPIO_DIRSET_DIRSETP10_MASK)
#define GPIO_DIRSET_DIRSETP11_MASK               (0x800U)
#define GPIO_DIRSET_DIRSETP11_SHIFT              (11U)
/*! DIRSETP11 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP11(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP11_SHIFT)) & GPIO_DIRSET_DIRSETP11_MASK)
#define GPIO_DIRSET_DIRSETP12_MASK               (0x1000U)
#define GPIO_DIRSET_DIRSETP12_SHIFT              (12U)
/*! DIRSETP12 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP12(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP12_SHIFT)) & GPIO_DIRSET_DIRSETP12_MASK)
#define GPIO_DIRSET_DIRSETP13_MASK               (0x2000U)
#define GPIO_DIRSET_DIRSETP13_SHIFT              (13U)
/*! DIRSETP13 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP13(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP13_SHIFT)) & GPIO_DIRSET_DIRSETP13_MASK)
#define GPIO_DIRSET_DIRSETP14_MASK               (0x4000U)
#define GPIO_DIRSET_DIRSETP14_SHIFT              (14U)
/*! DIRSETP14 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP14(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP14_SHIFT)) & GPIO_DIRSET_DIRSETP14_MASK)
#define GPIO_DIRSET_DIRSETP15_MASK               (0x8000U)
#define GPIO_DIRSET_DIRSETP15_SHIFT              (15U)
/*! DIRSETP15 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP15(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP15_SHIFT)) & GPIO_DIRSET_DIRSETP15_MASK)
#define GPIO_DIRSET_DIRSETP16_MASK               (0x10000U)
#define GPIO_DIRSET_DIRSETP16_SHIFT              (16U)
/*! DIRSETP16 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP16(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP16_SHIFT)) & GPIO_DIRSET_DIRSETP16_MASK)
#define GPIO_DIRSET_DIRSETP17_MASK               (0x20000U)
#define GPIO_DIRSET_DIRSETP17_SHIFT              (17U)
/*! DIRSETP17 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP17(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP17_SHIFT)) & GPIO_DIRSET_DIRSETP17_MASK)
#define GPIO_DIRSET_DIRSETP18_MASK               (0x40000U)
#define GPIO_DIRSET_DIRSETP18_SHIFT              (18U)
/*! DIRSETP18 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP18(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP18_SHIFT)) & GPIO_DIRSET_DIRSETP18_MASK)
#define GPIO_DIRSET_DIRSETP19_MASK               (0x80000U)
#define GPIO_DIRSET_DIRSETP19_SHIFT              (19U)
/*! DIRSETP19 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP19(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP19_SHIFT)) & GPIO_DIRSET_DIRSETP19_MASK)
#define GPIO_DIRSET_DIRSETP20_MASK               (0x100000U)
#define GPIO_DIRSET_DIRSETP20_SHIFT              (20U)
/*! DIRSETP20 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP20(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP20_SHIFT)) & GPIO_DIRSET_DIRSETP20_MASK)
#define GPIO_DIRSET_DIRSETP21_MASK               (0x200000U)
#define GPIO_DIRSET_DIRSETP21_SHIFT              (21U)
/*! DIRSETP21 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP21(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP21_SHIFT)) & GPIO_DIRSET_DIRSETP21_MASK)
#define GPIO_DIRSET_DIRSETP22_MASK               (0x400000U)
#define GPIO_DIRSET_DIRSETP22_SHIFT              (22U)
/*! DIRSETP22 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP22(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP22_SHIFT)) & GPIO_DIRSET_DIRSETP22_MASK)
#define GPIO_DIRSET_DIRSETP23_MASK               (0x800000U)
#define GPIO_DIRSET_DIRSETP23_SHIFT              (23U)
/*! DIRSETP23 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP23(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP23_SHIFT)) & GPIO_DIRSET_DIRSETP23_MASK)
#define GPIO_DIRSET_DIRSETP24_MASK               (0x1000000U)
#define GPIO_DIRSET_DIRSETP24_SHIFT              (24U)
/*! DIRSETP24 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP24(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP24_SHIFT)) & GPIO_DIRSET_DIRSETP24_MASK)
#define GPIO_DIRSET_DIRSETP25_MASK               (0x2000000U)
#define GPIO_DIRSET_DIRSETP25_SHIFT              (25U)
/*! DIRSETP25 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP25(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP25_SHIFT)) & GPIO_DIRSET_DIRSETP25_MASK)
#define GPIO_DIRSET_DIRSETP26_MASK               (0x4000000U)
#define GPIO_DIRSET_DIRSETP26_SHIFT              (26U)
/*! DIRSETP26 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP26(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP26_SHIFT)) & GPIO_DIRSET_DIRSETP26_MASK)
#define GPIO_DIRSET_DIRSETP27_MASK               (0x8000000U)
#define GPIO_DIRSET_DIRSETP27_SHIFT              (27U)
/*! DIRSETP27 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP27(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP27_SHIFT)) & GPIO_DIRSET_DIRSETP27_MASK)
#define GPIO_DIRSET_DIRSETP28_MASK               (0x10000000U)
#define GPIO_DIRSET_DIRSETP28_SHIFT              (28U)
/*! DIRSETP28 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP28(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP28_SHIFT)) & GPIO_DIRSET_DIRSETP28_MASK)
#define GPIO_DIRSET_DIRSETP29_MASK               (0x20000000U)
#define GPIO_DIRSET_DIRSETP29_SHIFT              (29U)
/*! DIRSETP29 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP29(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP29_SHIFT)) & GPIO_DIRSET_DIRSETP29_MASK)
#define GPIO_DIRSET_DIRSETP30_MASK               (0x40000000U)
#define GPIO_DIRSET_DIRSETP30_SHIFT              (30U)
/*! DIRSETP30 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP30(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP30_SHIFT)) & GPIO_DIRSET_DIRSETP30_MASK)
#define GPIO_DIRSET_DIRSETP31_MASK               (0x80000000U)
#define GPIO_DIRSET_DIRSETP31_SHIFT              (31U)
/*! DIRSETP31 - Direction set bits for Port pins
 *  0b0..No operation
 *  0b1..Sets direction bit
 */
#define GPIO_DIRSET_DIRSETP31(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRSET_DIRSETP31_SHIFT)) & GPIO_DIRSET_DIRSETP31_MASK)
/*! @} */

/* The count of GPIO_DIRSET */
#define GPIO_DIRSET_COUNT                        (8U)

/*! @name DIRCLR - Port direction clear */
/*! @{ */
#define GPIO_DIRCLR_DIRCLRP0_MASK                (0x1U)
#define GPIO_DIRCLR_DIRCLRP0_SHIFT               (0U)
/*! DIRCLRP0 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP0(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP0_SHIFT)) & GPIO_DIRCLR_DIRCLRP0_MASK)
#define GPIO_DIRCLR_DIRCLRP1_MASK                (0x2U)
#define GPIO_DIRCLR_DIRCLRP1_SHIFT               (1U)
/*! DIRCLRP1 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP1(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP1_SHIFT)) & GPIO_DIRCLR_DIRCLRP1_MASK)
#define GPIO_DIRCLR_DIRCLRP2_MASK                (0x4U)
#define GPIO_DIRCLR_DIRCLRP2_SHIFT               (2U)
/*! DIRCLRP2 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP2(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP2_SHIFT)) & GPIO_DIRCLR_DIRCLRP2_MASK)
#define GPIO_DIRCLR_DIRCLRP3_MASK                (0x8U)
#define GPIO_DIRCLR_DIRCLRP3_SHIFT               (3U)
/*! DIRCLRP3 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP3(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP3_SHIFT)) & GPIO_DIRCLR_DIRCLRP3_MASK)
#define GPIO_DIRCLR_DIRCLRP4_MASK                (0x10U)
#define GPIO_DIRCLR_DIRCLRP4_SHIFT               (4U)
/*! DIRCLRP4 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP4(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP4_SHIFT)) & GPIO_DIRCLR_DIRCLRP4_MASK)
#define GPIO_DIRCLR_DIRCLRP5_MASK                (0x20U)
#define GPIO_DIRCLR_DIRCLRP5_SHIFT               (5U)
/*! DIRCLRP5 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP5(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP5_SHIFT)) & GPIO_DIRCLR_DIRCLRP5_MASK)
#define GPIO_DIRCLR_DIRCLRP6_MASK                (0x40U)
#define GPIO_DIRCLR_DIRCLRP6_SHIFT               (6U)
/*! DIRCLRP6 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP6(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP6_SHIFT)) & GPIO_DIRCLR_DIRCLRP6_MASK)
#define GPIO_DIRCLR_DIRCLRP7_MASK                (0x80U)
#define GPIO_DIRCLR_DIRCLRP7_SHIFT               (7U)
/*! DIRCLRP7 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP7(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP7_SHIFT)) & GPIO_DIRCLR_DIRCLRP7_MASK)
#define GPIO_DIRCLR_DIRCLRP8_MASK                (0x100U)
#define GPIO_DIRCLR_DIRCLRP8_SHIFT               (8U)
/*! DIRCLRP8 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP8(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP8_SHIFT)) & GPIO_DIRCLR_DIRCLRP8_MASK)
#define GPIO_DIRCLR_DIRCLRP9_MASK                (0x200U)
#define GPIO_DIRCLR_DIRCLRP9_SHIFT               (9U)
/*! DIRCLRP9 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP9(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP9_SHIFT)) & GPIO_DIRCLR_DIRCLRP9_MASK)
#define GPIO_DIRCLR_DIRCLRP10_MASK               (0x400U)
#define GPIO_DIRCLR_DIRCLRP10_SHIFT              (10U)
/*! DIRCLRP10 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP10(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP10_SHIFT)) & GPIO_DIRCLR_DIRCLRP10_MASK)
#define GPIO_DIRCLR_DIRCLRP11_MASK               (0x800U)
#define GPIO_DIRCLR_DIRCLRP11_SHIFT              (11U)
/*! DIRCLRP11 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP11(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP11_SHIFT)) & GPIO_DIRCLR_DIRCLRP11_MASK)
#define GPIO_DIRCLR_DIRCLRP12_MASK               (0x1000U)
#define GPIO_DIRCLR_DIRCLRP12_SHIFT              (12U)
/*! DIRCLRP12 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP12(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP12_SHIFT)) & GPIO_DIRCLR_DIRCLRP12_MASK)
#define GPIO_DIRCLR_DIRCLRP13_MASK               (0x2000U)
#define GPIO_DIRCLR_DIRCLRP13_SHIFT              (13U)
/*! DIRCLRP13 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP13(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP13_SHIFT)) & GPIO_DIRCLR_DIRCLRP13_MASK)
#define GPIO_DIRCLR_DIRCLRP14_MASK               (0x4000U)
#define GPIO_DIRCLR_DIRCLRP14_SHIFT              (14U)
/*! DIRCLRP14 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP14(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP14_SHIFT)) & GPIO_DIRCLR_DIRCLRP14_MASK)
#define GPIO_DIRCLR_DIRCLRP15_MASK               (0x8000U)
#define GPIO_DIRCLR_DIRCLRP15_SHIFT              (15U)
/*! DIRCLRP15 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP15(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP15_SHIFT)) & GPIO_DIRCLR_DIRCLRP15_MASK)
#define GPIO_DIRCLR_DIRCLRP16_MASK               (0x10000U)
#define GPIO_DIRCLR_DIRCLRP16_SHIFT              (16U)
/*! DIRCLRP16 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP16(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP16_SHIFT)) & GPIO_DIRCLR_DIRCLRP16_MASK)
#define GPIO_DIRCLR_DIRCLRP17_MASK               (0x20000U)
#define GPIO_DIRCLR_DIRCLRP17_SHIFT              (17U)
/*! DIRCLRP17 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP17(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP17_SHIFT)) & GPIO_DIRCLR_DIRCLRP17_MASK)
#define GPIO_DIRCLR_DIRCLRP18_MASK               (0x40000U)
#define GPIO_DIRCLR_DIRCLRP18_SHIFT              (18U)
/*! DIRCLRP18 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP18(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP18_SHIFT)) & GPIO_DIRCLR_DIRCLRP18_MASK)
#define GPIO_DIRCLR_DIRCLRP19_MASK               (0x80000U)
#define GPIO_DIRCLR_DIRCLRP19_SHIFT              (19U)
/*! DIRCLRP19 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP19(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP19_SHIFT)) & GPIO_DIRCLR_DIRCLRP19_MASK)
#define GPIO_DIRCLR_DIRCLRP20_MASK               (0x100000U)
#define GPIO_DIRCLR_DIRCLRP20_SHIFT              (20U)
/*! DIRCLRP20 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP20(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP20_SHIFT)) & GPIO_DIRCLR_DIRCLRP20_MASK)
#define GPIO_DIRCLR_DIRCLRP21_MASK               (0x200000U)
#define GPIO_DIRCLR_DIRCLRP21_SHIFT              (21U)
/*! DIRCLRP21 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP21(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP21_SHIFT)) & GPIO_DIRCLR_DIRCLRP21_MASK)
#define GPIO_DIRCLR_DIRCLRP22_MASK               (0x400000U)
#define GPIO_DIRCLR_DIRCLRP22_SHIFT              (22U)
/*! DIRCLRP22 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP22(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP22_SHIFT)) & GPIO_DIRCLR_DIRCLRP22_MASK)
#define GPIO_DIRCLR_DIRCLRP23_MASK               (0x800000U)
#define GPIO_DIRCLR_DIRCLRP23_SHIFT              (23U)
/*! DIRCLRP23 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP23(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP23_SHIFT)) & GPIO_DIRCLR_DIRCLRP23_MASK)
#define GPIO_DIRCLR_DIRCLRP24_MASK               (0x1000000U)
#define GPIO_DIRCLR_DIRCLRP24_SHIFT              (24U)
/*! DIRCLRP24 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP24(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP24_SHIFT)) & GPIO_DIRCLR_DIRCLRP24_MASK)
#define GPIO_DIRCLR_DIRCLRP25_MASK               (0x2000000U)
#define GPIO_DIRCLR_DIRCLRP25_SHIFT              (25U)
/*! DIRCLRP25 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP25(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP25_SHIFT)) & GPIO_DIRCLR_DIRCLRP25_MASK)
#define GPIO_DIRCLR_DIRCLRP26_MASK               (0x4000000U)
#define GPIO_DIRCLR_DIRCLRP26_SHIFT              (26U)
/*! DIRCLRP26 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP26(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP26_SHIFT)) & GPIO_DIRCLR_DIRCLRP26_MASK)
#define GPIO_DIRCLR_DIRCLRP27_MASK               (0x8000000U)
#define GPIO_DIRCLR_DIRCLRP27_SHIFT              (27U)
/*! DIRCLRP27 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP27(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP27_SHIFT)) & GPIO_DIRCLR_DIRCLRP27_MASK)
#define GPIO_DIRCLR_DIRCLRP28_MASK               (0x10000000U)
#define GPIO_DIRCLR_DIRCLRP28_SHIFT              (28U)
/*! DIRCLRP28 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP28(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP28_SHIFT)) & GPIO_DIRCLR_DIRCLRP28_MASK)
#define GPIO_DIRCLR_DIRCLRP29_MASK               (0x20000000U)
#define GPIO_DIRCLR_DIRCLRP29_SHIFT              (29U)
/*! DIRCLRP29 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP29(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP29_SHIFT)) & GPIO_DIRCLR_DIRCLRP29_MASK)
#define GPIO_DIRCLR_DIRCLRP30_MASK               (0x40000000U)
#define GPIO_DIRCLR_DIRCLRP30_SHIFT              (30U)
/*! DIRCLRP30 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP30(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP30_SHIFT)) & GPIO_DIRCLR_DIRCLRP30_MASK)
#define GPIO_DIRCLR_DIRCLRP31_MASK               (0x80000000U)
#define GPIO_DIRCLR_DIRCLRP31_SHIFT              (31U)
/*! DIRCLRP31 - Clear direction bits.
 *  0b0..No operation
 *  0b1..Clears direction bits
 */
#define GPIO_DIRCLR_DIRCLRP31(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_DIRCLR_DIRCLRP31_SHIFT)) & GPIO_DIRCLR_DIRCLRP31_MASK)
/*! @} */

/* The count of GPIO_DIRCLR */
#define GPIO_DIRCLR_COUNT                        (8U)

/*! @name DIRNOT - Port direction toggle */
/*! @{ */
#define GPIO_DIRNOT_DIRNOTP_MASK                 (0x1FFFFFFFU)
#define GPIO_DIRNOT_DIRNOTP_SHIFT                (0U)
/*! DIRNOTP - Toggle direction bits.
 *  0b00000000000000000000000000000..No operation
 *  0b00000000000000000000000000001..Toggles direction bit
 */
#define GPIO_DIRNOT_DIRNOTP(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_DIRNOT_DIRNOTP_SHIFT)) & GPIO_DIRNOT_DIRNOTP_MASK)
/*! @} */

/* The count of GPIO_DIRNOT */
#define GPIO_DIRNOT_COUNT                        (8U)

/*! @name INTENA - Interrupt A enable control */
/*! @{ */
#define GPIO_INTENA_INT_EN0_MASK                 (0x1U)
#define GPIO_INTENA_INT_EN0_SHIFT                (0U)
/*! INT_EN0 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN0(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN0_SHIFT)) & GPIO_INTENA_INT_EN0_MASK)
#define GPIO_INTENA_INT_EN1_MASK                 (0x2U)
#define GPIO_INTENA_INT_EN1_SHIFT                (1U)
/*! INT_EN1 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN1(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN1_SHIFT)) & GPIO_INTENA_INT_EN1_MASK)
#define GPIO_INTENA_INT_EN2_MASK                 (0x4U)
#define GPIO_INTENA_INT_EN2_SHIFT                (2U)
/*! INT_EN2 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN2(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN2_SHIFT)) & GPIO_INTENA_INT_EN2_MASK)
#define GPIO_INTENA_INT_EN3_MASK                 (0x8U)
#define GPIO_INTENA_INT_EN3_SHIFT                (3U)
/*! INT_EN3 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN3(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN3_SHIFT)) & GPIO_INTENA_INT_EN3_MASK)
#define GPIO_INTENA_INT_EN4_MASK                 (0x10U)
#define GPIO_INTENA_INT_EN4_SHIFT                (4U)
/*! INT_EN4 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN4(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN4_SHIFT)) & GPIO_INTENA_INT_EN4_MASK)
#define GPIO_INTENA_INT_EN5_MASK                 (0x20U)
#define GPIO_INTENA_INT_EN5_SHIFT                (5U)
/*! INT_EN5 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN5(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN5_SHIFT)) & GPIO_INTENA_INT_EN5_MASK)
#define GPIO_INTENA_INT_EN6_MASK                 (0x40U)
#define GPIO_INTENA_INT_EN6_SHIFT                (6U)
/*! INT_EN6 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN6(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN6_SHIFT)) & GPIO_INTENA_INT_EN6_MASK)
#define GPIO_INTENA_INT_EN7_MASK                 (0x80U)
#define GPIO_INTENA_INT_EN7_SHIFT                (7U)
/*! INT_EN7 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN7(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN7_SHIFT)) & GPIO_INTENA_INT_EN7_MASK)
#define GPIO_INTENA_INT_EN8_MASK                 (0x100U)
#define GPIO_INTENA_INT_EN8_SHIFT                (8U)
/*! INT_EN8 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN8(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN8_SHIFT)) & GPIO_INTENA_INT_EN8_MASK)
#define GPIO_INTENA_INT_EN9_MASK                 (0x200U)
#define GPIO_INTENA_INT_EN9_SHIFT                (9U)
/*! INT_EN9 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN9(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN9_SHIFT)) & GPIO_INTENA_INT_EN9_MASK)
#define GPIO_INTENA_INT_EN10_MASK                (0x400U)
#define GPIO_INTENA_INT_EN10_SHIFT               (10U)
/*! INT_EN10 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN10(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN10_SHIFT)) & GPIO_INTENA_INT_EN10_MASK)
#define GPIO_INTENA_INT_EN11_MASK                (0x800U)
#define GPIO_INTENA_INT_EN11_SHIFT               (11U)
/*! INT_EN11 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN11(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN11_SHIFT)) & GPIO_INTENA_INT_EN11_MASK)
#define GPIO_INTENA_INT_EN12_MASK                (0x1000U)
#define GPIO_INTENA_INT_EN12_SHIFT               (12U)
/*! INT_EN12 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN12(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN12_SHIFT)) & GPIO_INTENA_INT_EN12_MASK)
#define GPIO_INTENA_INT_EN13_MASK                (0x2000U)
#define GPIO_INTENA_INT_EN13_SHIFT               (13U)
/*! INT_EN13 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN13(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN13_SHIFT)) & GPIO_INTENA_INT_EN13_MASK)
#define GPIO_INTENA_INT_EN14_MASK                (0x4000U)
#define GPIO_INTENA_INT_EN14_SHIFT               (14U)
/*! INT_EN14 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN14(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN14_SHIFT)) & GPIO_INTENA_INT_EN14_MASK)
#define GPIO_INTENA_INT_EN15_MASK                (0x8000U)
#define GPIO_INTENA_INT_EN15_SHIFT               (15U)
/*! INT_EN15 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN15(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN15_SHIFT)) & GPIO_INTENA_INT_EN15_MASK)
#define GPIO_INTENA_INT_EN16_MASK                (0x10000U)
#define GPIO_INTENA_INT_EN16_SHIFT               (16U)
/*! INT_EN16 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN16(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN16_SHIFT)) & GPIO_INTENA_INT_EN16_MASK)
#define GPIO_INTENA_INT_EN17_MASK                (0x20000U)
#define GPIO_INTENA_INT_EN17_SHIFT               (17U)
/*! INT_EN17 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN17(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN17_SHIFT)) & GPIO_INTENA_INT_EN17_MASK)
#define GPIO_INTENA_INT_EN18_MASK                (0x40000U)
#define GPIO_INTENA_INT_EN18_SHIFT               (18U)
/*! INT_EN18 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN18(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN18_SHIFT)) & GPIO_INTENA_INT_EN18_MASK)
#define GPIO_INTENA_INT_EN19_MASK                (0x80000U)
#define GPIO_INTENA_INT_EN19_SHIFT               (19U)
/*! INT_EN19 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN19(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN19_SHIFT)) & GPIO_INTENA_INT_EN19_MASK)
#define GPIO_INTENA_INT_EN20_MASK                (0x100000U)
#define GPIO_INTENA_INT_EN20_SHIFT               (20U)
/*! INT_EN20 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN20(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN20_SHIFT)) & GPIO_INTENA_INT_EN20_MASK)
#define GPIO_INTENA_INT_EN21_MASK                (0x200000U)
#define GPIO_INTENA_INT_EN21_SHIFT               (21U)
/*! INT_EN21 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN21(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN21_SHIFT)) & GPIO_INTENA_INT_EN21_MASK)
#define GPIO_INTENA_INT_EN22_MASK                (0x400000U)
#define GPIO_INTENA_INT_EN22_SHIFT               (22U)
/*! INT_EN22 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN22(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN22_SHIFT)) & GPIO_INTENA_INT_EN22_MASK)
#define GPIO_INTENA_INT_EN23_MASK                (0x800000U)
#define GPIO_INTENA_INT_EN23_SHIFT               (23U)
/*! INT_EN23 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN23(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN23_SHIFT)) & GPIO_INTENA_INT_EN23_MASK)
#define GPIO_INTENA_INT_EN24_MASK                (0x1000000U)
#define GPIO_INTENA_INT_EN24_SHIFT               (24U)
/*! INT_EN24 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN24(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN24_SHIFT)) & GPIO_INTENA_INT_EN24_MASK)
#define GPIO_INTENA_INT_EN25_MASK                (0x2000000U)
#define GPIO_INTENA_INT_EN25_SHIFT               (25U)
/*! INT_EN25 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN25(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN25_SHIFT)) & GPIO_INTENA_INT_EN25_MASK)
#define GPIO_INTENA_INT_EN26_MASK                (0x4000000U)
#define GPIO_INTENA_INT_EN26_SHIFT               (26U)
/*! INT_EN26 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN26(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN26_SHIFT)) & GPIO_INTENA_INT_EN26_MASK)
#define GPIO_INTENA_INT_EN27_MASK                (0x8000000U)
#define GPIO_INTENA_INT_EN27_SHIFT               (27U)
/*! INT_EN27 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN27(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN27_SHIFT)) & GPIO_INTENA_INT_EN27_MASK)
#define GPIO_INTENA_INT_EN28_MASK                (0x10000000U)
#define GPIO_INTENA_INT_EN28_SHIFT               (28U)
/*! INT_EN28 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN28(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN28_SHIFT)) & GPIO_INTENA_INT_EN28_MASK)
#define GPIO_INTENA_INT_EN29_MASK                (0x20000000U)
#define GPIO_INTENA_INT_EN29_SHIFT               (29U)
/*! INT_EN29 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN29(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN29_SHIFT)) & GPIO_INTENA_INT_EN29_MASK)
#define GPIO_INTENA_INT_EN30_MASK                (0x40000000U)
#define GPIO_INTENA_INT_EN30_SHIFT               (30U)
/*! INT_EN30 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN30(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN30_SHIFT)) & GPIO_INTENA_INT_EN30_MASK)
#define GPIO_INTENA_INT_EN31_MASK                (0x80000000U)
#define GPIO_INTENA_INT_EN31_SHIFT               (31U)
/*! INT_EN31 - Interrupt A enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt A
 *  0b1..Pin contributes to GPIO interrupt A
 */
#define GPIO_INTENA_INT_EN31(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENA_INT_EN31_SHIFT)) & GPIO_INTENA_INT_EN31_MASK)
/*! @} */

/* The count of GPIO_INTENA */
#define GPIO_INTENA_COUNT                        (8U)

/*! @name INTENB - Interrupt B enable control */
/*! @{ */
#define GPIO_INTENB_INT_EN0_MASK                 (0x1U)
#define GPIO_INTENB_INT_EN0_SHIFT                (0U)
/*! INT_EN0 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN0(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN0_SHIFT)) & GPIO_INTENB_INT_EN0_MASK)
#define GPIO_INTENB_INT_EN1_MASK                 (0x2U)
#define GPIO_INTENB_INT_EN1_SHIFT                (1U)
/*! INT_EN1 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN1(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN1_SHIFT)) & GPIO_INTENB_INT_EN1_MASK)
#define GPIO_INTENB_INT_EN2_MASK                 (0x4U)
#define GPIO_INTENB_INT_EN2_SHIFT                (2U)
/*! INT_EN2 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN2(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN2_SHIFT)) & GPIO_INTENB_INT_EN2_MASK)
#define GPIO_INTENB_INT_EN3_MASK                 (0x8U)
#define GPIO_INTENB_INT_EN3_SHIFT                (3U)
/*! INT_EN3 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN3(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN3_SHIFT)) & GPIO_INTENB_INT_EN3_MASK)
#define GPIO_INTENB_INT_EN4_MASK                 (0x10U)
#define GPIO_INTENB_INT_EN4_SHIFT                (4U)
/*! INT_EN4 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN4(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN4_SHIFT)) & GPIO_INTENB_INT_EN4_MASK)
#define GPIO_INTENB_INT_EN5_MASK                 (0x20U)
#define GPIO_INTENB_INT_EN5_SHIFT                (5U)
/*! INT_EN5 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN5(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN5_SHIFT)) & GPIO_INTENB_INT_EN5_MASK)
#define GPIO_INTENB_INT_EN6_MASK                 (0x40U)
#define GPIO_INTENB_INT_EN6_SHIFT                (6U)
/*! INT_EN6 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN6(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN6_SHIFT)) & GPIO_INTENB_INT_EN6_MASK)
#define GPIO_INTENB_INT_EN7_MASK                 (0x80U)
#define GPIO_INTENB_INT_EN7_SHIFT                (7U)
/*! INT_EN7 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN7(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN7_SHIFT)) & GPIO_INTENB_INT_EN7_MASK)
#define GPIO_INTENB_INT_EN8_MASK                 (0x100U)
#define GPIO_INTENB_INT_EN8_SHIFT                (8U)
/*! INT_EN8 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN8(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN8_SHIFT)) & GPIO_INTENB_INT_EN8_MASK)
#define GPIO_INTENB_INT_EN9_MASK                 (0x200U)
#define GPIO_INTENB_INT_EN9_SHIFT                (9U)
/*! INT_EN9 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN9(x)                   (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN9_SHIFT)) & GPIO_INTENB_INT_EN9_MASK)
#define GPIO_INTENB_INT_EN10_MASK                (0x400U)
#define GPIO_INTENB_INT_EN10_SHIFT               (10U)
/*! INT_EN10 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN10(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN10_SHIFT)) & GPIO_INTENB_INT_EN10_MASK)
#define GPIO_INTENB_INT_EN11_MASK                (0x800U)
#define GPIO_INTENB_INT_EN11_SHIFT               (11U)
/*! INT_EN11 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN11(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN11_SHIFT)) & GPIO_INTENB_INT_EN11_MASK)
#define GPIO_INTENB_INT_EN12_MASK                (0x1000U)
#define GPIO_INTENB_INT_EN12_SHIFT               (12U)
/*! INT_EN12 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN12(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN12_SHIFT)) & GPIO_INTENB_INT_EN12_MASK)
#define GPIO_INTENB_INT_EN13_MASK                (0x2000U)
#define GPIO_INTENB_INT_EN13_SHIFT               (13U)
/*! INT_EN13 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN13(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN13_SHIFT)) & GPIO_INTENB_INT_EN13_MASK)
#define GPIO_INTENB_INT_EN14_MASK                (0x4000U)
#define GPIO_INTENB_INT_EN14_SHIFT               (14U)
/*! INT_EN14 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN14(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN14_SHIFT)) & GPIO_INTENB_INT_EN14_MASK)
#define GPIO_INTENB_INT_EN15_MASK                (0x8000U)
#define GPIO_INTENB_INT_EN15_SHIFT               (15U)
/*! INT_EN15 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN15(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN15_SHIFT)) & GPIO_INTENB_INT_EN15_MASK)
#define GPIO_INTENB_INT_EN16_MASK                (0x10000U)
#define GPIO_INTENB_INT_EN16_SHIFT               (16U)
/*! INT_EN16 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN16(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN16_SHIFT)) & GPIO_INTENB_INT_EN16_MASK)
#define GPIO_INTENB_INT_EN17_MASK                (0x20000U)
#define GPIO_INTENB_INT_EN17_SHIFT               (17U)
/*! INT_EN17 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN17(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN17_SHIFT)) & GPIO_INTENB_INT_EN17_MASK)
#define GPIO_INTENB_INT_EN18_MASK                (0x40000U)
#define GPIO_INTENB_INT_EN18_SHIFT               (18U)
/*! INT_EN18 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN18(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN18_SHIFT)) & GPIO_INTENB_INT_EN18_MASK)
#define GPIO_INTENB_INT_EN19_MASK                (0x80000U)
#define GPIO_INTENB_INT_EN19_SHIFT               (19U)
/*! INT_EN19 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN19(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN19_SHIFT)) & GPIO_INTENB_INT_EN19_MASK)
#define GPIO_INTENB_INT_EN20_MASK                (0x100000U)
#define GPIO_INTENB_INT_EN20_SHIFT               (20U)
/*! INT_EN20 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN20(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN20_SHIFT)) & GPIO_INTENB_INT_EN20_MASK)
#define GPIO_INTENB_INT_EN21_MASK                (0x200000U)
#define GPIO_INTENB_INT_EN21_SHIFT               (21U)
/*! INT_EN21 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN21(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN21_SHIFT)) & GPIO_INTENB_INT_EN21_MASK)
#define GPIO_INTENB_INT_EN22_MASK                (0x400000U)
#define GPIO_INTENB_INT_EN22_SHIFT               (22U)
/*! INT_EN22 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN22(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN22_SHIFT)) & GPIO_INTENB_INT_EN22_MASK)
#define GPIO_INTENB_INT_EN23_MASK                (0x800000U)
#define GPIO_INTENB_INT_EN23_SHIFT               (23U)
/*! INT_EN23 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN23(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN23_SHIFT)) & GPIO_INTENB_INT_EN23_MASK)
#define GPIO_INTENB_INT_EN24_MASK                (0x1000000U)
#define GPIO_INTENB_INT_EN24_SHIFT               (24U)
/*! INT_EN24 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN24(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN24_SHIFT)) & GPIO_INTENB_INT_EN24_MASK)
#define GPIO_INTENB_INT_EN25_MASK                (0x2000000U)
#define GPIO_INTENB_INT_EN25_SHIFT               (25U)
/*! INT_EN25 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN25(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN25_SHIFT)) & GPIO_INTENB_INT_EN25_MASK)
#define GPIO_INTENB_INT_EN26_MASK                (0x4000000U)
#define GPIO_INTENB_INT_EN26_SHIFT               (26U)
/*! INT_EN26 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN26(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN26_SHIFT)) & GPIO_INTENB_INT_EN26_MASK)
#define GPIO_INTENB_INT_EN27_MASK                (0x8000000U)
#define GPIO_INTENB_INT_EN27_SHIFT               (27U)
/*! INT_EN27 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN27(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN27_SHIFT)) & GPIO_INTENB_INT_EN27_MASK)
#define GPIO_INTENB_INT_EN28_MASK                (0x10000000U)
#define GPIO_INTENB_INT_EN28_SHIFT               (28U)
/*! INT_EN28 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN28(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN28_SHIFT)) & GPIO_INTENB_INT_EN28_MASK)
#define GPIO_INTENB_INT_EN29_MASK                (0x20000000U)
#define GPIO_INTENB_INT_EN29_SHIFT               (29U)
/*! INT_EN29 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN29(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN29_SHIFT)) & GPIO_INTENB_INT_EN29_MASK)
#define GPIO_INTENB_INT_EN30_MASK                (0x40000000U)
#define GPIO_INTENB_INT_EN30_SHIFT               (30U)
/*! INT_EN30 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN30(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN30_SHIFT)) & GPIO_INTENB_INT_EN30_MASK)
#define GPIO_INTENB_INT_EN31_MASK                (0x80000000U)
#define GPIO_INTENB_INT_EN31_SHIFT               (31U)
/*! INT_EN31 - Interrupt B enable bits.
 *  0b0..Pin does not contribute to GPIO interrupt B
 *  0b1..Pin contributes to GPIO interrupt B
 */
#define GPIO_INTENB_INT_EN31(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTENB_INT_EN31_SHIFT)) & GPIO_INTENB_INT_EN31_MASK)
/*! @} */

/* The count of GPIO_INTENB */
#define GPIO_INTENB_COUNT                        (8U)

/*! @name INTPOL - Interupt polarity control */
/*! @{ */
#define GPIO_INTPOL_POL_CTL0_MASK                (0x1U)
#define GPIO_INTPOL_POL_CTL0_SHIFT               (0U)
/*! POL_CTL0 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL0(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL0_SHIFT)) & GPIO_INTPOL_POL_CTL0_MASK)
#define GPIO_INTPOL_POL_CTL1_MASK                (0x2U)
#define GPIO_INTPOL_POL_CTL1_SHIFT               (1U)
/*! POL_CTL1 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL1(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL1_SHIFT)) & GPIO_INTPOL_POL_CTL1_MASK)
#define GPIO_INTPOL_POL_CTL2_MASK                (0x4U)
#define GPIO_INTPOL_POL_CTL2_SHIFT               (2U)
/*! POL_CTL2 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL2(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL2_SHIFT)) & GPIO_INTPOL_POL_CTL2_MASK)
#define GPIO_INTPOL_POL_CTL3_MASK                (0x8U)
#define GPIO_INTPOL_POL_CTL3_SHIFT               (3U)
/*! POL_CTL3 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL3(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL3_SHIFT)) & GPIO_INTPOL_POL_CTL3_MASK)
#define GPIO_INTPOL_POL_CTL4_MASK                (0x10U)
#define GPIO_INTPOL_POL_CTL4_SHIFT               (4U)
/*! POL_CTL4 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL4(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL4_SHIFT)) & GPIO_INTPOL_POL_CTL4_MASK)
#define GPIO_INTPOL_POL_CTL5_MASK                (0x20U)
#define GPIO_INTPOL_POL_CTL5_SHIFT               (5U)
/*! POL_CTL5 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL5(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL5_SHIFT)) & GPIO_INTPOL_POL_CTL5_MASK)
#define GPIO_INTPOL_POL_CTL6_MASK                (0x40U)
#define GPIO_INTPOL_POL_CTL6_SHIFT               (6U)
/*! POL_CTL6 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL6(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL6_SHIFT)) & GPIO_INTPOL_POL_CTL6_MASK)
#define GPIO_INTPOL_POL_CTL7_MASK                (0x80U)
#define GPIO_INTPOL_POL_CTL7_SHIFT               (7U)
/*! POL_CTL7 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL7(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL7_SHIFT)) & GPIO_INTPOL_POL_CTL7_MASK)
#define GPIO_INTPOL_POL_CTL8_MASK                (0x100U)
#define GPIO_INTPOL_POL_CTL8_SHIFT               (8U)
/*! POL_CTL8 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL8(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL8_SHIFT)) & GPIO_INTPOL_POL_CTL8_MASK)
#define GPIO_INTPOL_POL_CTL9_MASK                (0x200U)
#define GPIO_INTPOL_POL_CTL9_SHIFT               (9U)
/*! POL_CTL9 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL9(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL9_SHIFT)) & GPIO_INTPOL_POL_CTL9_MASK)
#define GPIO_INTPOL_POL_CTL10_MASK               (0x400U)
#define GPIO_INTPOL_POL_CTL10_SHIFT              (10U)
/*! POL_CTL10 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL10(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL10_SHIFT)) & GPIO_INTPOL_POL_CTL10_MASK)
#define GPIO_INTPOL_POL_CTL11_MASK               (0x800U)
#define GPIO_INTPOL_POL_CTL11_SHIFT              (11U)
/*! POL_CTL11 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL11(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL11_SHIFT)) & GPIO_INTPOL_POL_CTL11_MASK)
#define GPIO_INTPOL_POL_CTL12_MASK               (0x1000U)
#define GPIO_INTPOL_POL_CTL12_SHIFT              (12U)
/*! POL_CTL12 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL12(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL12_SHIFT)) & GPIO_INTPOL_POL_CTL12_MASK)
#define GPIO_INTPOL_POL_CTL13_MASK               (0x2000U)
#define GPIO_INTPOL_POL_CTL13_SHIFT              (13U)
/*! POL_CTL13 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL13(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL13_SHIFT)) & GPIO_INTPOL_POL_CTL13_MASK)
#define GPIO_INTPOL_POL_CTL14_MASK               (0x4000U)
#define GPIO_INTPOL_POL_CTL14_SHIFT              (14U)
/*! POL_CTL14 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL14(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL14_SHIFT)) & GPIO_INTPOL_POL_CTL14_MASK)
#define GPIO_INTPOL_POL_CTL15_MASK               (0x8000U)
#define GPIO_INTPOL_POL_CTL15_SHIFT              (15U)
/*! POL_CTL15 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL15(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL15_SHIFT)) & GPIO_INTPOL_POL_CTL15_MASK)
#define GPIO_INTPOL_POL_CTL16_MASK               (0x10000U)
#define GPIO_INTPOL_POL_CTL16_SHIFT              (16U)
/*! POL_CTL16 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL16(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL16_SHIFT)) & GPIO_INTPOL_POL_CTL16_MASK)
#define GPIO_INTPOL_POL_CTL17_MASK               (0x20000U)
#define GPIO_INTPOL_POL_CTL17_SHIFT              (17U)
/*! POL_CTL17 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL17(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL17_SHIFT)) & GPIO_INTPOL_POL_CTL17_MASK)
#define GPIO_INTPOL_POL_CTL18_MASK               (0x40000U)
#define GPIO_INTPOL_POL_CTL18_SHIFT              (18U)
/*! POL_CTL18 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL18(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL18_SHIFT)) & GPIO_INTPOL_POL_CTL18_MASK)
#define GPIO_INTPOL_POL_CTL19_MASK               (0x80000U)
#define GPIO_INTPOL_POL_CTL19_SHIFT              (19U)
/*! POL_CTL19 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL19(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL19_SHIFT)) & GPIO_INTPOL_POL_CTL19_MASK)
#define GPIO_INTPOL_POL_CTL20_MASK               (0x100000U)
#define GPIO_INTPOL_POL_CTL20_SHIFT              (20U)
/*! POL_CTL20 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL20(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL20_SHIFT)) & GPIO_INTPOL_POL_CTL20_MASK)
#define GPIO_INTPOL_POL_CTL21_MASK               (0x200000U)
#define GPIO_INTPOL_POL_CTL21_SHIFT              (21U)
/*! POL_CTL21 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL21(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL21_SHIFT)) & GPIO_INTPOL_POL_CTL21_MASK)
#define GPIO_INTPOL_POL_CTL22_MASK               (0x400000U)
#define GPIO_INTPOL_POL_CTL22_SHIFT              (22U)
/*! POL_CTL22 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL22(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL22_SHIFT)) & GPIO_INTPOL_POL_CTL22_MASK)
#define GPIO_INTPOL_POL_CTL23_MASK               (0x800000U)
#define GPIO_INTPOL_POL_CTL23_SHIFT              (23U)
/*! POL_CTL23 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL23(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL23_SHIFT)) & GPIO_INTPOL_POL_CTL23_MASK)
#define GPIO_INTPOL_POL_CTL24_MASK               (0x1000000U)
#define GPIO_INTPOL_POL_CTL24_SHIFT              (24U)
/*! POL_CTL24 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL24(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL24_SHIFT)) & GPIO_INTPOL_POL_CTL24_MASK)
#define GPIO_INTPOL_POL_CTL25_MASK               (0x2000000U)
#define GPIO_INTPOL_POL_CTL25_SHIFT              (25U)
/*! POL_CTL25 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL25(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL25_SHIFT)) & GPIO_INTPOL_POL_CTL25_MASK)
#define GPIO_INTPOL_POL_CTL26_MASK               (0x4000000U)
#define GPIO_INTPOL_POL_CTL26_SHIFT              (26U)
/*! POL_CTL26 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL26(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL26_SHIFT)) & GPIO_INTPOL_POL_CTL26_MASK)
#define GPIO_INTPOL_POL_CTL27_MASK               (0x8000000U)
#define GPIO_INTPOL_POL_CTL27_SHIFT              (27U)
/*! POL_CTL27 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL27(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL27_SHIFT)) & GPIO_INTPOL_POL_CTL27_MASK)
#define GPIO_INTPOL_POL_CTL28_MASK               (0x10000000U)
#define GPIO_INTPOL_POL_CTL28_SHIFT              (28U)
/*! POL_CTL28 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL28(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL28_SHIFT)) & GPIO_INTPOL_POL_CTL28_MASK)
#define GPIO_INTPOL_POL_CTL29_MASK               (0x20000000U)
#define GPIO_INTPOL_POL_CTL29_SHIFT              (29U)
/*! POL_CTL29 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL29(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL29_SHIFT)) & GPIO_INTPOL_POL_CTL29_MASK)
#define GPIO_INTPOL_POL_CTL30_MASK               (0x40000000U)
#define GPIO_INTPOL_POL_CTL30_SHIFT              (30U)
/*! POL_CTL30 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL30(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL30_SHIFT)) & GPIO_INTPOL_POL_CTL30_MASK)
#define GPIO_INTPOL_POL_CTL31_MASK               (0x80000000U)
#define GPIO_INTPOL_POL_CTL31_SHIFT              (31U)
/*! POL_CTL31 - Polarity control for each pin
 *  0b0..High level or rising edge triggered
 *  0b1..Low level or falling edge triggered
 */
#define GPIO_INTPOL_POL_CTL31(x)                 (((uint32_t)(((uint32_t)(x)) << GPIO_INTPOL_POL_CTL31_SHIFT)) & GPIO_INTPOL_POL_CTL31_MASK)
/*! @} */

/* The count of GPIO_INTPOL */
#define GPIO_INTPOL_COUNT                        (8U)

/*! @name INTEDG - Interrupt edge select */
/*! @{ */
#define GPIO_INTEDG_EDGE0_MASK                   (0x1U)
#define GPIO_INTEDG_EDGE0_SHIFT                  (0U)
/*! EDGE0 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE0(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE0_SHIFT)) & GPIO_INTEDG_EDGE0_MASK)
#define GPIO_INTEDG_EDGE1_MASK                   (0x2U)
#define GPIO_INTEDG_EDGE1_SHIFT                  (1U)
/*! EDGE1 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE1(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE1_SHIFT)) & GPIO_INTEDG_EDGE1_MASK)
#define GPIO_INTEDG_EDGE2_MASK                   (0x4U)
#define GPIO_INTEDG_EDGE2_SHIFT                  (2U)
/*! EDGE2 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE2(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE2_SHIFT)) & GPIO_INTEDG_EDGE2_MASK)
#define GPIO_INTEDG_EDGE3_MASK                   (0x8U)
#define GPIO_INTEDG_EDGE3_SHIFT                  (3U)
/*! EDGE3 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE3(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE3_SHIFT)) & GPIO_INTEDG_EDGE3_MASK)
#define GPIO_INTEDG_EDGE4_MASK                   (0x10U)
#define GPIO_INTEDG_EDGE4_SHIFT                  (4U)
/*! EDGE4 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE4(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE4_SHIFT)) & GPIO_INTEDG_EDGE4_MASK)
#define GPIO_INTEDG_EDGE5_MASK                   (0x20U)
#define GPIO_INTEDG_EDGE5_SHIFT                  (5U)
/*! EDGE5 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE5(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE5_SHIFT)) & GPIO_INTEDG_EDGE5_MASK)
#define GPIO_INTEDG_EDGE6_MASK                   (0x40U)
#define GPIO_INTEDG_EDGE6_SHIFT                  (6U)
/*! EDGE6 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE6(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE6_SHIFT)) & GPIO_INTEDG_EDGE6_MASK)
#define GPIO_INTEDG_EDGE7_MASK                   (0x80U)
#define GPIO_INTEDG_EDGE7_SHIFT                  (7U)
/*! EDGE7 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE7(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE7_SHIFT)) & GPIO_INTEDG_EDGE7_MASK)
#define GPIO_INTEDG_EDGE8_MASK                   (0x100U)
#define GPIO_INTEDG_EDGE8_SHIFT                  (8U)
/*! EDGE8 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE8(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE8_SHIFT)) & GPIO_INTEDG_EDGE8_MASK)
#define GPIO_INTEDG_EDGE9_MASK                   (0x200U)
#define GPIO_INTEDG_EDGE9_SHIFT                  (9U)
/*! EDGE9 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE9(x)                     (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE9_SHIFT)) & GPIO_INTEDG_EDGE9_MASK)
#define GPIO_INTEDG_EDGE10_MASK                  (0x400U)
#define GPIO_INTEDG_EDGE10_SHIFT                 (10U)
/*! EDGE10 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE10(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE10_SHIFT)) & GPIO_INTEDG_EDGE10_MASK)
#define GPIO_INTEDG_EDGE11_MASK                  (0x800U)
#define GPIO_INTEDG_EDGE11_SHIFT                 (11U)
/*! EDGE11 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE11(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE11_SHIFT)) & GPIO_INTEDG_EDGE11_MASK)
#define GPIO_INTEDG_EDGE12_MASK                  (0x1000U)
#define GPIO_INTEDG_EDGE12_SHIFT                 (12U)
/*! EDGE12 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE12(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE12_SHIFT)) & GPIO_INTEDG_EDGE12_MASK)
#define GPIO_INTEDG_EDGE13_MASK                  (0x2000U)
#define GPIO_INTEDG_EDGE13_SHIFT                 (13U)
/*! EDGE13 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE13(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE13_SHIFT)) & GPIO_INTEDG_EDGE13_MASK)
#define GPIO_INTEDG_EDGE14_MASK                  (0x4000U)
#define GPIO_INTEDG_EDGE14_SHIFT                 (14U)
/*! EDGE14 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE14(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE14_SHIFT)) & GPIO_INTEDG_EDGE14_MASK)
#define GPIO_INTEDG_EDGE15_MASK                  (0x8000U)
#define GPIO_INTEDG_EDGE15_SHIFT                 (15U)
/*! EDGE15 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE15(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE15_SHIFT)) & GPIO_INTEDG_EDGE15_MASK)
#define GPIO_INTEDG_EDGE16_MASK                  (0x10000U)
#define GPIO_INTEDG_EDGE16_SHIFT                 (16U)
/*! EDGE16 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE16(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE16_SHIFT)) & GPIO_INTEDG_EDGE16_MASK)
#define GPIO_INTEDG_EDGE17_MASK                  (0x20000U)
#define GPIO_INTEDG_EDGE17_SHIFT                 (17U)
/*! EDGE17 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE17(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE17_SHIFT)) & GPIO_INTEDG_EDGE17_MASK)
#define GPIO_INTEDG_EDGE18_MASK                  (0x40000U)
#define GPIO_INTEDG_EDGE18_SHIFT                 (18U)
/*! EDGE18 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE18(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE18_SHIFT)) & GPIO_INTEDG_EDGE18_MASK)
#define GPIO_INTEDG_EDGE19_MASK                  (0x80000U)
#define GPIO_INTEDG_EDGE19_SHIFT                 (19U)
/*! EDGE19 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE19(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE19_SHIFT)) & GPIO_INTEDG_EDGE19_MASK)
#define GPIO_INTEDG_EDGE20_MASK                  (0x100000U)
#define GPIO_INTEDG_EDGE20_SHIFT                 (20U)
/*! EDGE20 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE20(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE20_SHIFT)) & GPIO_INTEDG_EDGE20_MASK)
#define GPIO_INTEDG_EDGE21_MASK                  (0x200000U)
#define GPIO_INTEDG_EDGE21_SHIFT                 (21U)
/*! EDGE21 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE21(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE21_SHIFT)) & GPIO_INTEDG_EDGE21_MASK)
#define GPIO_INTEDG_EDGE22_MASK                  (0x400000U)
#define GPIO_INTEDG_EDGE22_SHIFT                 (22U)
/*! EDGE22 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE22(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE22_SHIFT)) & GPIO_INTEDG_EDGE22_MASK)
#define GPIO_INTEDG_EDGE23_MASK                  (0x800000U)
#define GPIO_INTEDG_EDGE23_SHIFT                 (23U)
/*! EDGE23 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE23(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE23_SHIFT)) & GPIO_INTEDG_EDGE23_MASK)
#define GPIO_INTEDG_EDGE24_MASK                  (0x1000000U)
#define GPIO_INTEDG_EDGE24_SHIFT                 (24U)
/*! EDGE24 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE24(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE24_SHIFT)) & GPIO_INTEDG_EDGE24_MASK)
#define GPIO_INTEDG_EDGE25_MASK                  (0x2000000U)
#define GPIO_INTEDG_EDGE25_SHIFT                 (25U)
/*! EDGE25 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE25(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE25_SHIFT)) & GPIO_INTEDG_EDGE25_MASK)
#define GPIO_INTEDG_EDGE26_MASK                  (0x4000000U)
#define GPIO_INTEDG_EDGE26_SHIFT                 (26U)
/*! EDGE26 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE26(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE26_SHIFT)) & GPIO_INTEDG_EDGE26_MASK)
#define GPIO_INTEDG_EDGE27_MASK                  (0x8000000U)
#define GPIO_INTEDG_EDGE27_SHIFT                 (27U)
/*! EDGE27 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE27(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE27_SHIFT)) & GPIO_INTEDG_EDGE27_MASK)
#define GPIO_INTEDG_EDGE28_MASK                  (0x10000000U)
#define GPIO_INTEDG_EDGE28_SHIFT                 (28U)
/*! EDGE28 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE28(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE28_SHIFT)) & GPIO_INTEDG_EDGE28_MASK)
#define GPIO_INTEDG_EDGE29_MASK                  (0x20000000U)
#define GPIO_INTEDG_EDGE29_SHIFT                 (29U)
/*! EDGE29 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE29(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE29_SHIFT)) & GPIO_INTEDG_EDGE29_MASK)
#define GPIO_INTEDG_EDGE30_MASK                  (0x40000000U)
#define GPIO_INTEDG_EDGE30_SHIFT                 (30U)
/*! EDGE30 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE30(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE30_SHIFT)) & GPIO_INTEDG_EDGE30_MASK)
#define GPIO_INTEDG_EDGE31_MASK                  (0x80000000U)
#define GPIO_INTEDG_EDGE31_SHIFT                 (31U)
/*! EDGE31 - Edge or level mode select bits.
 *  0b0..Level mode
 *  0b1..Edge mode
 */
#define GPIO_INTEDG_EDGE31(x)                    (((uint32_t)(((uint32_t)(x)) << GPIO_INTEDG_EDGE31_SHIFT)) & GPIO_INTEDG_EDGE31_MASK)
/*! @} */

/* The count of GPIO_INTEDG */
#define GPIO_INTEDG_COUNT                        (8U)

/*! @name INTSTATA - Interrupt status for interrupt A */
/*! @{ */
#define GPIO_INTSTATA_STATUS_MASK                (0xFFFFFFFFU)
#define GPIO_INTSTATA_STATUS_SHIFT               (0U)
/*! STATUS - Interrupt status.
 */
#define GPIO_INTSTATA_STATUS(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTSTATA_STATUS_SHIFT)) & GPIO_INTSTATA_STATUS_MASK)
/*! @} */

/* The count of GPIO_INTSTATA */
#define GPIO_INTSTATA_COUNT                      (8U)

/*! @name INTSTATB - Interrupt status for interrupt B */
/*! @{ */
#define GPIO_INTSTATB_STATUS_MASK                (0xFFFFFFFFU)
#define GPIO_INTSTATB_STATUS_SHIFT               (0U)
/*! STATUS - Interrupt status
 */
#define GPIO_INTSTATB_STATUS(x)                  (((uint32_t)(((uint32_t)(x)) << GPIO_INTSTATB_STATUS_SHIFT)) & GPIO_INTSTATB_STATUS_MASK)
/*! @} */

/* The count of GPIO_INTSTATB */
#define GPIO_INTSTATB_COUNT                      (8U)


/*!
 * @}
 */ /* end of group GPIO_Register_Masks */


/* GPIO - Peripheral instance base addresses */
/** Peripheral GPIO base address */
#define GPIO_BASE                                (0x40100000u)
/** Peripheral GPIO base pointer */
#define GPIO                                     ((GPIO_Type *)GPIO_BASE)
/** Array initializer of GPIO peripheral base addresses */
#define GPIO_BASE_ADDRS                          { GPIO_BASE }
/** Array initializer of GPIO peripheral base pointers */
#define GPIO_BASE_PTRS                           { GPIO }

/*!
 * @}
 */ /* end of group GPIO_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- HASHCRYPT Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup HASHCRYPT_Peripheral_Access_Layer HASHCRYPT Peripheral Access Layer
 * @{
 */

/** HASHCRYPT - Register Layout Typedef */
typedef struct {
  __IO uint32_t CTRL;                              /**< Control, offset: 0x0 */
  __IO uint32_t STATUS;                            /**< Status, offset: 0x4 */
  __IO uint32_t INTENSET;                          /**< Interrupt Enable, offset: 0x8 */
  __IO uint32_t INTENCLR;                          /**< Interrupt Clear, offset: 0xC */
  __IO uint32_t MEMCTRL;                           /**< Memory Control, offset: 0x10 */
  __IO uint32_t MEMADDR;                           /**< Memory Address, offset: 0x14 */
       uint8_t RESERVED_0[8];
  __O  uint32_t INDATA;                            /**< Input Data, offset: 0x20 */
  __O  uint32_t ALIAS[7];                          /**< Alias, array offset: 0x24, array step: 0x4 */
  __I  uint32_t DIGEST0[8];                        /**< Digest0 n/Output Data0 n, array offset: 0x40, array step: 0x4 */
       uint8_t RESERVED_1[32];
  __IO uint32_t CRYPTCFG;                          /**< Cryptographic Configuration, offset: 0x80 */
  __I  uint32_t CONFIG;                            /**< Configuration, offset: 0x84 */
       uint8_t RESERVED_2[4];
  __IO uint32_t LOCK;                              /**< Lock, offset: 0x8C */
  __O  uint32_t MASK[4];                           /**< Mask, array offset: 0x90, array step: 0x4 */
} HASHCRYPT_Type;

/* ----------------------------------------------------------------------------
   -- HASHCRYPT Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup HASHCRYPT_Register_Masks HASHCRYPT Register Masks
 * @{
 */

/*! @name CTRL - Control */
/*! @{ */
#define HASHCRYPT_CTRL_MODE_MASK                 (0x7U)
#define HASHCRYPT_CTRL_MODE_SHIFT                (0U)
/*! MODE - Operational Mode
 *  0b000..Disabled
 *  0b001..SHA1 is enabled
 *  0b010..SHA2-256 is enabled
 *  0b011..
 *  0b100..AES is enabled (see also CRYPTCFG register for more controls)
 *  0b101..ICB-AES is enabled (see also CRYPTCFG register for more controls)
 *  0b110..
 *  0b111..
 */
#define HASHCRYPT_CTRL_MODE(x)                   (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CTRL_MODE_SHIFT)) & HASHCRYPT_CTRL_MODE_MASK)
#define HASHCRYPT_CTRL_NEW_HASH_MASK             (0x10U)
#define HASHCRYPT_CTRL_NEW_HASH_SHIFT            (4U)
/*! NEW_HASH - New Hash Operation
 *  0b1..Starts a new Hash/Crypto and initializes the Digest/Result.
 */
#define HASHCRYPT_CTRL_NEW_HASH(x)               (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CTRL_NEW_HASH_SHIFT)) & HASHCRYPT_CTRL_NEW_HASH_MASK)
#define HASHCRYPT_CTRL_DMA_I_MASK                (0x100U)
#define HASHCRYPT_CTRL_DMA_I_SHIFT               (8U)
/*! DMA_I - DMA to Fill INDATA.
 *  0b0..DMA is not used. Processor writes the necessary words when WAITING is set (interrupts), unless AHB Master is used.
 *  0b1..DMA will push in the data.
 */
#define HASHCRYPT_CTRL_DMA_I(x)                  (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CTRL_DMA_I_SHIFT)) & HASHCRYPT_CTRL_DMA_I_MASK)
#define HASHCRYPT_CTRL_DMA_O_MASK                (0x200U)
#define HASHCRYPT_CTRL_DMA_O_SHIFT               (9U)
/*! DMA_O - DMA to Drain the Digest/Output
 *  0b0..DMA is not used. Processor reads the digest/output in response to DIGEST interrupt.
 *  0b1..DMA will drain the data.
 */
#define HASHCRYPT_CTRL_DMA_O(x)                  (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CTRL_DMA_O_SHIFT)) & HASHCRYPT_CTRL_DMA_O_MASK)
#define HASHCRYPT_CTRL_HASHSWPB_MASK             (0x1000U)
#define HASHCRYPT_CTRL_HASHSWPB_SHIFT            (12U)
/*! HASHSWPB - Hash Swap Bytes
 */
#define HASHCRYPT_CTRL_HASHSWPB(x)               (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CTRL_HASHSWPB_SHIFT)) & HASHCRYPT_CTRL_HASHSWPB_MASK)
/*! @} */

/*! @name STATUS - Status */
/*! @{ */
#define HASHCRYPT_STATUS_WAITING_MASK            (0x1U)
#define HASHCRYPT_STATUS_WAITING_SHIFT           (0U)
/*! WAITING - Waiting for Data
 *  0b0..Not waiting for data - may be disabled or may be busy. For cryptographic uses, this is not set if IsLast
 *       is set nor will it set until at least 1 word is read of the output.
 *  0b1..Waiting for data to be written (16 words)
 */
#define HASHCRYPT_STATUS_WAITING(x)              (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_STATUS_WAITING_SHIFT)) & HASHCRYPT_STATUS_WAITING_MASK)
#define HASHCRYPT_STATUS_DIGEST_MASK             (0x2U)
#define HASHCRYPT_STATUS_DIGEST_SHIFT            (1U)
/*! DIGEST - Digest/Outdata
 *  0b0..Digest is not ready
 *  0b1..Digest is ready. Application may read it or may write more data.
 */
#define HASHCRYPT_STATUS_DIGEST(x)               (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_STATUS_DIGEST_SHIFT)) & HASHCRYPT_STATUS_DIGEST_MASK)
#define HASHCRYPT_STATUS_ERROR_MASK              (0x4U)
#define HASHCRYPT_STATUS_ERROR_SHIFT             (2U)
/*! ERROR - Error
 *  0b0..No error.
 *  0b1..An error occurred since last cleared (written 1 to clear).
 */
#define HASHCRYPT_STATUS_ERROR(x)                (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_STATUS_ERROR_SHIFT)) & HASHCRYPT_STATUS_ERROR_MASK)
#define HASHCRYPT_STATUS_NEEDKEY_MASK            (0x10U)
#define HASHCRYPT_STATUS_NEEDKEY_SHIFT           (4U)
/*! NEEDKEY - Need Key to be Written
 *  0b0..No Key is needed and writes will not be treated as Key
 *  0b1..Key is needed and INDATA/ALIAS will be accepted as Key. Will also set WAITING.
 */
#define HASHCRYPT_STATUS_NEEDKEY(x)              (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_STATUS_NEEDKEY_SHIFT)) & HASHCRYPT_STATUS_NEEDKEY_MASK)
#define HASHCRYPT_STATUS_NEEDIV_MASK             (0x20U)
#define HASHCRYPT_STATUS_NEEDIV_SHIFT            (5U)
/*! NEEDIV - Need IV/Nonce
 *  0b0..No IV/Nonce is needed, either because written already or because not needed.
 *  0b1..IV/Nonce is needed and INDATA/ALIAS will be accepted as IV/Nonce. Will also set WAITING.
 */
#define HASHCRYPT_STATUS_NEEDIV(x)               (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_STATUS_NEEDIV_SHIFT)) & HASHCRYPT_STATUS_NEEDIV_MASK)
#define HASHCRYPT_STATUS_ICBIDX_MASK             (0x3F0000U)
#define HASHCRYPT_STATUS_ICBIDX_SHIFT            (16U)
/*! ICBIDX - ICB Index Count
 */
#define HASHCRYPT_STATUS_ICBIDX(x)               (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_STATUS_ICBIDX_SHIFT)) & HASHCRYPT_STATUS_ICBIDX_MASK)
/*! @} */

/*! @name INTENSET - Interrupt Enable */
/*! @{ */
#define HASHCRYPT_INTENSET_WAITING_MASK          (0x1U)
#define HASHCRYPT_INTENSET_WAITING_SHIFT         (0U)
/*! WAITING - Interrupt When Waiting for Data Input
 *  0b0..Interrupt not enabled when waiting
 *  0b1..Interrupt is enabled when waiting
 */
#define HASHCRYPT_INTENSET_WAITING(x)            (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INTENSET_WAITING_SHIFT)) & HASHCRYPT_INTENSET_WAITING_MASK)
#define HASHCRYPT_INTENSET_DIGEST_MASK           (0x2U)
#define HASHCRYPT_INTENSET_DIGEST_SHIFT          (1U)
/*! DIGEST - Digest/Outdata
 *  0b0..Interrupt not enabled when Digest is ready
 *  0b1..Interrupt is enabled when Digest is ready. Interrupt cleared by writing more data, starting a new Hash, or disabling (done).
 */
#define HASHCRYPT_INTENSET_DIGEST(x)             (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INTENSET_DIGEST_SHIFT)) & HASHCRYPT_INTENSET_DIGEST_MASK)
#define HASHCRYPT_INTENSET_ERROR_MASK            (0x4U)
#define HASHCRYPT_INTENSET_ERROR_SHIFT           (2U)
/*! ERROR - Interrupt on Error
 *  0b0..Interrupt not enabled on Error.
 *  0b1..Interrupt is enabled on Error (until cleared).
 */
#define HASHCRYPT_INTENSET_ERROR(x)              (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INTENSET_ERROR_SHIFT)) & HASHCRYPT_INTENSET_ERROR_MASK)
/*! @} */

/*! @name INTENCLR - Interrupt Clear */
/*! @{ */
#define HASHCRYPT_INTENCLR_WAITING_MASK          (0x1U)
#define HASHCRYPT_INTENCLR_WAITING_SHIFT         (0U)
/*! WAITING - Waiting
 */
#define HASHCRYPT_INTENCLR_WAITING(x)            (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INTENCLR_WAITING_SHIFT)) & HASHCRYPT_INTENCLR_WAITING_MASK)
#define HASHCRYPT_INTENCLR_DIGEST_MASK           (0x2U)
#define HASHCRYPT_INTENCLR_DIGEST_SHIFT          (1U)
/*! DIGEST - Digest
 */
#define HASHCRYPT_INTENCLR_DIGEST(x)             (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INTENCLR_DIGEST_SHIFT)) & HASHCRYPT_INTENCLR_DIGEST_MASK)
#define HASHCRYPT_INTENCLR_ERROR_MASK            (0x4U)
#define HASHCRYPT_INTENCLR_ERROR_SHIFT           (2U)
/*! ERROR - Error
 */
#define HASHCRYPT_INTENCLR_ERROR(x)              (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INTENCLR_ERROR_SHIFT)) & HASHCRYPT_INTENCLR_ERROR_MASK)
/*! @} */

/*! @name MEMCTRL - Memory Control */
/*! @{ */
#define HASHCRYPT_MEMCTRL_MASTER_MASK            (0x1U)
#define HASHCRYPT_MEMCTRL_MASTER_SHIFT           (0U)
/*! MASTER - Master
 *  0b0..Mastering is not used and the normal DMA or Interrupt based model is used with INDATA.
 *  0b1..Mastering is enabled and DMA and INDATA should not be used.
 */
#define HASHCRYPT_MEMCTRL_MASTER(x)              (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_MEMCTRL_MASTER_SHIFT)) & HASHCRYPT_MEMCTRL_MASTER_MASK)
#define HASHCRYPT_MEMCTRL_COUNT_MASK             (0x7FF0000U)
#define HASHCRYPT_MEMCTRL_COUNT_SHIFT            (16U)
/*! COUNT - Count
 *  0b00000000000..Done. Nothing to process
 *  0b00000000001..One 512-bit block to hash
 *  0b00000000010..Two 512-bit block to hash
 *  0b00000000011..Three 512-bit block to hash
 */
#define HASHCRYPT_MEMCTRL_COUNT(x)               (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_MEMCTRL_COUNT_SHIFT)) & HASHCRYPT_MEMCTRL_COUNT_MASK)
/*! @} */

/*! @name MEMADDR - Memory Address */
/*! @{ */
#define HASHCRYPT_MEMADDR_BASE_MASK              (0xFFFFFFFFU)
#define HASHCRYPT_MEMADDR_BASE_SHIFT             (0U)
/*! BASE - Base
 */
#define HASHCRYPT_MEMADDR_BASE(x)                (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_MEMADDR_BASE_SHIFT)) & HASHCRYPT_MEMADDR_BASE_MASK)
/*! @} */

/*! @name INDATA - Input Data */
/*! @{ */
#define HASHCRYPT_INDATA_DATA_MASK               (0xFFFFFFFFU)
#define HASHCRYPT_INDATA_DATA_SHIFT              (0U)
/*! DATA - Data
 */
#define HASHCRYPT_INDATA_DATA(x)                 (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_INDATA_DATA_SHIFT)) & HASHCRYPT_INDATA_DATA_MASK)
/*! @} */

/*! @name ALIAS - Alias */
/*! @{ */
#define HASHCRYPT_ALIAS_DATA_MASK                (0xFFFFFFFFU)
#define HASHCRYPT_ALIAS_DATA_SHIFT               (0U)
/*! DATA - Data
 */
#define HASHCRYPT_ALIAS_DATA(x)                  (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_ALIAS_DATA_SHIFT)) & HASHCRYPT_ALIAS_DATA_MASK)
/*! @} */

/* The count of HASHCRYPT_ALIAS */
#define HASHCRYPT_ALIAS_COUNT                    (7U)

/*! @name DIGEST0 - Digest0 n/Output Data0 n */
/*! @{ */
#define HASHCRYPT_DIGEST0_DIGEST_MASK            (0xFFFFFFFFU)
#define HASHCRYPT_DIGEST0_DIGEST_SHIFT           (0U)
/*! DIGEST - Digest
 */
#define HASHCRYPT_DIGEST0_DIGEST(x)              (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_DIGEST0_DIGEST_SHIFT)) & HASHCRYPT_DIGEST0_DIGEST_MASK)
/*! @} */

/* The count of HASHCRYPT_DIGEST0 */
#define HASHCRYPT_DIGEST0_COUNT                  (8U)

/*! @name CRYPTCFG - Cryptographic Configuration */
/*! @{ */
#define HASHCRYPT_CRYPTCFG_MSW1ST_OUT_MASK       (0x1U)
#define HASHCRYPT_CRYPTCFG_MSW1ST_OUT_SHIFT      (0U)
/*! MSW1ST_OUT - Most Significant Word 1st Out
 */
#define HASHCRYPT_CRYPTCFG_MSW1ST_OUT(x)         (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_MSW1ST_OUT_SHIFT)) & HASHCRYPT_CRYPTCFG_MSW1ST_OUT_MASK)
#define HASHCRYPT_CRYPTCFG_SWAPKEY_MASK          (0x2U)
#define HASHCRYPT_CRYPTCFG_SWAPKEY_SHIFT         (1U)
/*! SWAPKEY - Swap Key
 */
#define HASHCRYPT_CRYPTCFG_SWAPKEY(x)            (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_SWAPKEY_SHIFT)) & HASHCRYPT_CRYPTCFG_SWAPKEY_MASK)
#define HASHCRYPT_CRYPTCFG_SWAPDAT_MASK          (0x4U)
#define HASHCRYPT_CRYPTCFG_SWAPDAT_SHIFT         (2U)
/*! SWAPDAT - Swap Data/IV Inputs
 */
#define HASHCRYPT_CRYPTCFG_SWAPDAT(x)            (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_SWAPDAT_SHIFT)) & HASHCRYPT_CRYPTCFG_SWAPDAT_MASK)
#define HASHCRYPT_CRYPTCFG_MSW1ST_MASK           (0x8U)
#define HASHCRYPT_CRYPTCFG_MSW1ST_SHIFT          (3U)
/*! MSW1ST - Most Significant Word 1st Load
 */
#define HASHCRYPT_CRYPTCFG_MSW1ST(x)             (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_MSW1ST_SHIFT)) & HASHCRYPT_CRYPTCFG_MSW1ST_MASK)
#define HASHCRYPT_CRYPTCFG_AESMODE_MASK          (0x30U)
#define HASHCRYPT_CRYPTCFG_AESMODE_SHIFT         (4U)
/*! AESMODE - AES Cipher Mode
 *  0b00..ECB - used as is
 *  0b01..CBC mode (see details on IV/nonce)
 *  0b10..CTR mode (see details on IV/nonce). See also AESCTRPOS.
 *  0b11..Reserved
 */
#define HASHCRYPT_CRYPTCFG_AESMODE(x)            (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_AESMODE_SHIFT)) & HASHCRYPT_CRYPTCFG_AESMODE_MASK)
#define HASHCRYPT_CRYPTCFG_AESDECRYPT_MASK       (0x40U)
#define HASHCRYPT_CRYPTCFG_AESDECRYPT_SHIFT      (6U)
/*! AESDECRYPT - AES Decrypt
 *  0b0..Encrypt
 *  0b1..Decrypt
 */
#define HASHCRYPT_CRYPTCFG_AESDECRYPT(x)         (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_AESDECRYPT_SHIFT)) & HASHCRYPT_CRYPTCFG_AESDECRYPT_MASK)
#define HASHCRYPT_CRYPTCFG_AESSECRET_MASK        (0x80U)
#define HASHCRYPT_CRYPTCFG_AESSECRET_SHIFT       (7U)
/*! AESSECRET - AES Secret
 *  0b0..User key provided in normal way
 *  0b1..Secret key provided in hidden way by HW
 */
#define HASHCRYPT_CRYPTCFG_AESSECRET(x)          (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_AESSECRET_SHIFT)) & HASHCRYPT_CRYPTCFG_AESSECRET_MASK)
#define HASHCRYPT_CRYPTCFG_AESKEYSZ_MASK         (0x300U)
#define HASHCRYPT_CRYPTCFG_AESKEYSZ_SHIFT        (8U)
/*! AESKEYSZ - AES Key Size
 *  0b00..128 bit key
 *  0b01..192 bit key
 *  0b10..256 bit key
 *  0b11..Reserved
 */
#define HASHCRYPT_CRYPTCFG_AESKEYSZ(x)           (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_AESKEYSZ_SHIFT)) & HASHCRYPT_CRYPTCFG_AESKEYSZ_MASK)
#define HASHCRYPT_CRYPTCFG_AESCTRPOS_MASK        (0x1C00U)
#define HASHCRYPT_CRYPTCFG_AESCTRPOS_SHIFT       (10U)
/*! AESCTRPOS - AES CTR Position
 */
#define HASHCRYPT_CRYPTCFG_AESCTRPOS(x)          (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_AESCTRPOS_SHIFT)) & HASHCRYPT_CRYPTCFG_AESCTRPOS_MASK)
#define HASHCRYPT_CRYPTCFG_STREAMLAST_MASK       (0x10000U)
#define HASHCRYPT_CRYPTCFG_STREAMLAST_SHIFT      (16U)
/*! STREAMLAST - Stream Last
 */
#define HASHCRYPT_CRYPTCFG_STREAMLAST(x)         (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_STREAMLAST_SHIFT)) & HASHCRYPT_CRYPTCFG_STREAMLAST_MASK)
#define HASHCRYPT_CRYPTCFG_ICBSZ_MASK            (0x300000U)
#define HASHCRYPT_CRYPTCFG_ICBSZ_SHIFT           (20U)
/*! ICBSZ - ICB Size
 *  0b00..32 bits of the IV/ctr are used (from 127:96)
 *  0b01..64 bits of the IV/ctr are used (from 127:64)
 *  0b10..96 bits of the IV/ctr are used (from 127:32)
 *  0b11..All 128 bits of the IV/ctr are used
 */
#define HASHCRYPT_CRYPTCFG_ICBSZ(x)              (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_ICBSZ_SHIFT)) & HASHCRYPT_CRYPTCFG_ICBSZ_MASK)
#define HASHCRYPT_CRYPTCFG_ICBSTRM_MASK          (0xC00000U)
#define HASHCRYPT_CRYPTCFG_ICBSTRM_SHIFT         (22U)
/*! ICBSTRM - ICB Stream Size
 *  0b00..8 blocks
 *  0b01..16 blocks
 *  0b10..32 blocks
 *  0b11..64 blocks
 */
#define HASHCRYPT_CRYPTCFG_ICBSTRM(x)            (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CRYPTCFG_ICBSTRM_SHIFT)) & HASHCRYPT_CRYPTCFG_ICBSTRM_MASK)
/*! @} */

/*! @name CONFIG - Configuration */
/*! @{ */
#define HASHCRYPT_CONFIG_DUAL_MASK               (0x1U)
#define HASHCRYPT_CONFIG_DUAL_SHIFT              (0U)
/*! DUAL - Reads 1 if 2 x 512 bit buffers, 0 if only 1 x 512 bit
 */
#define HASHCRYPT_CONFIG_DUAL(x)                 (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_DUAL_SHIFT)) & HASHCRYPT_CONFIG_DUAL_MASK)
#define HASHCRYPT_CONFIG_DMA_MASK                (0x2U)
#define HASHCRYPT_CONFIG_DMA_SHIFT               (1U)
/*! DMA - Reads 1 if DMA is connected
 */
#define HASHCRYPT_CONFIG_DMA(x)                  (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_DMA_SHIFT)) & HASHCRYPT_CONFIG_DMA_MASK)
#define HASHCRYPT_CONFIG_AHB_MASK                (0x8U)
#define HASHCRYPT_CONFIG_AHB_SHIFT               (3U)
/*! AHB - Reads 1 if AHB Master is enabled
 */
#define HASHCRYPT_CONFIG_AHB(x)                  (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_AHB_SHIFT)) & HASHCRYPT_CONFIG_AHB_MASK)
#define HASHCRYPT_CONFIG_AES_MASK                (0x40U)
#define HASHCRYPT_CONFIG_AES_SHIFT               (6U)
/*! AES - Reads 1 if AES 128 is included
 */
#define HASHCRYPT_CONFIG_AES(x)                  (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_AES_SHIFT)) & HASHCRYPT_CONFIG_AES_MASK)
#define HASHCRYPT_CONFIG_AESKEY_MASK             (0x80U)
#define HASHCRYPT_CONFIG_AESKEY_SHIFT            (7U)
/*! AESKEY - Reads 1 if AES 192 and 256 also included
 */
#define HASHCRYPT_CONFIG_AESKEY(x)               (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_AESKEY_SHIFT)) & HASHCRYPT_CONFIG_AESKEY_MASK)
#define HASHCRYPT_CONFIG_SECRET_MASK             (0x100U)
#define HASHCRYPT_CONFIG_SECRET_SHIFT            (8U)
/*! SECRET - Reads 1 if AES Secret key is available
 */
#define HASHCRYPT_CONFIG_SECRET(x)               (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_SECRET_SHIFT)) & HASHCRYPT_CONFIG_SECRET_MASK)
#define HASHCRYPT_CONFIG_ICB_MASK                (0x800U)
#define HASHCRYPT_CONFIG_ICB_SHIFT               (11U)
/*! ICB - ICB
 */
#define HASHCRYPT_CONFIG_ICB(x)                  (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_CONFIG_ICB_SHIFT)) & HASHCRYPT_CONFIG_ICB_MASK)
/*! @} */

/*! @name LOCK - Lock */
/*! @{ */
#define HASHCRYPT_LOCK_SECLOCK_MASK              (0x3U)
#define HASHCRYPT_LOCK_SECLOCK_SHIFT             (0U)
/*! SECLOCK - Secure Lock
 *  0b00..Unlocks, so block is open to all. But, AHB Master will only issue non-secure requests.
 *  0b01..Locks to the current security level. AHB Master will issue requests at this level.
 */
#define HASHCRYPT_LOCK_SECLOCK(x)                (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_LOCK_SECLOCK_SHIFT)) & HASHCRYPT_LOCK_SECLOCK_MASK)
#define HASHCRYPT_LOCK_PATTERN_MASK              (0xFFF0U)
#define HASHCRYPT_LOCK_PATTERN_SHIFT             (4U)
/*! PATTERN - Must write 0xA75 to change lock state. A75:Pattern needed to change bits 1:0
 */
#define HASHCRYPT_LOCK_PATTERN(x)                (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_LOCK_PATTERN_SHIFT)) & HASHCRYPT_LOCK_PATTERN_MASK)
/*! @} */

/*! @name MASK - Mask */
/*! @{ */
#define HASHCRYPT_MASK_MASK_MASK                 (0xFFFFFFFFU)
#define HASHCRYPT_MASK_MASK_SHIFT                (0U)
/*! MASK - A random word.
 */
#define HASHCRYPT_MASK_MASK(x)                   (((uint32_t)(((uint32_t)(x)) << HASHCRYPT_MASK_MASK_SHIFT)) & HASHCRYPT_MASK_MASK_MASK)
/*! @} */

/* The count of HASHCRYPT_MASK */
#define HASHCRYPT_MASK_COUNT                     (4U)


/*!
 * @}
 */ /* end of group HASHCRYPT_Register_Masks */


/* HASHCRYPT - Peripheral instance base addresses */
/** Peripheral HASHCRYPT base address */
#define HASHCRYPT_BASE                           (0x40208000u)
/** Peripheral HASHCRYPT base pointer */
#define HASHCRYPT                                ((HASHCRYPT_Type *)HASHCRYPT_BASE)
/** Array initializer of HASHCRYPT peripheral base addresses */
#define HASHCRYPT_BASE_ADDRS                     { HASHCRYPT_BASE }
/** Array initializer of HASHCRYPT peripheral base pointers */
#define HASHCRYPT_BASE_PTRS                      { HASHCRYPT }

/*!
 * @}
 */ /* end of group HASHCRYPT_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- I2C Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Peripheral_Access_Layer I2C Peripheral Access Layer
 * @{
 */

/** I2C - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[2048];
  __IO uint32_t CFG;                               /**< Configuration Register, offset: 0x800 */
  __IO uint32_t STAT;                              /**< Status Register, offset: 0x804 */
  __IO uint32_t INTENSET;                          /**< Interrupt Enable Set Register, offset: 0x808 */
  __O  uint32_t INTENCLR;                          /**< Interrupt Enable Clear Register, offset: 0x80C */
  __IO uint32_t TIMEOUT;                           /**< Time-out Register, offset: 0x810 */
  __IO uint32_t CLKDIV;                            /**< Clock Divider Register, offset: 0x814 */
  __I  uint32_t INTSTAT;                           /**< Interrupt Status Register, offset: 0x818 */
       uint8_t RESERVED_1[4];
  __IO uint32_t MSTCTL;                            /**< Master Control Register, offset: 0x820 */
  __IO uint32_t MSTTIME;                           /**< Master Timing Register, offset: 0x824 */
  __IO uint32_t MSTDAT;                            /**< Master Data Register, offset: 0x828 */
       uint8_t RESERVED_2[20];
  __IO uint32_t SLVCTL;                            /**< Slave Control Register, offset: 0x840 */
  __IO uint32_t SLVDAT;                            /**< Slave Data Register, offset: 0x844 */
  __IO uint32_t SLVADR[4];                         /**< Slave Address Register, array offset: 0x848, array step: 0x4 */
  __IO uint32_t SLVQUAL0;                          /**< Slave Qualification for Address 0 Register, offset: 0x858 */
       uint8_t RESERVED_3[36];
  __I  uint32_t MONRXDAT;                          /**< Monitor Receiver Data Register, offset: 0x880 */
       uint8_t RESERVED_4[1912];
  __I  uint32_t ID;                                /**< Peripheral Identification Register, offset: 0xFFC */
} I2C_Type;

/* ----------------------------------------------------------------------------
   -- I2C Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2C_Register_Masks I2C Register Masks
 * @{
 */

/*! @name CFG - Configuration Register */
/*! @{ */
#define I2C_CFG_MSTEN_MASK                       (0x1U)
#define I2C_CFG_MSTEN_SHIFT                      (0U)
/*! MSTEN - Master Enable
 *  0b0..Disabled. The I2C Master function is disabled. When disabled, the Master configuration settings are not
 *       changed, but the Master function is internally reset.
 *  0b1..Enabled. The I2C Master function is enabled.
 */
#define I2C_CFG_MSTEN(x)                         (((uint32_t)(((uint32_t)(x)) << I2C_CFG_MSTEN_SHIFT)) & I2C_CFG_MSTEN_MASK)
#define I2C_CFG_SLVEN_MASK                       (0x2U)
#define I2C_CFG_SLVEN_SHIFT                      (1U)
/*! SLVEN - Slave Enable
 *  0b0..Disabled. The I2C slave function is disabled. When disabled, the Slave configuration settings are not
 *       changed, but the Slave function is internally reset.
 *  0b1..Enabled. The I2C slave function is enabled.
 */
#define I2C_CFG_SLVEN(x)                         (((uint32_t)(((uint32_t)(x)) << I2C_CFG_SLVEN_SHIFT)) & I2C_CFG_SLVEN_MASK)
#define I2C_CFG_MONEN_MASK                       (0x4U)
#define I2C_CFG_MONEN_SHIFT                      (2U)
/*! MONEN - Monitor Enable
 *  0b0..Disabled. The I2C Monitor function is disabled. When disabled, the Monitor function configuration
 *       settings are not changed, but the Monitor function is internally reset.
 *  0b1..Enabled. The I2C Monitor function is enabled.
 */
#define I2C_CFG_MONEN(x)                         (((uint32_t)(((uint32_t)(x)) << I2C_CFG_MONEN_SHIFT)) & I2C_CFG_MONEN_MASK)
#define I2C_CFG_TIMEOUTEN_MASK                   (0x8U)
#define I2C_CFG_TIMEOUTEN_SHIFT                  (3U)
/*! TIMEOUTEN - I2C bus Time-out Enable
 *  0b0..Disabled. The time-out function is disabled. When disabled, the time-out function is internally reset.
 *  0b1..Enabled. The time-out function is enabled. Both types of time-out flags will be generated and will cause
 *       interrupts if those flags are enabled. Typically, only one time-out flag will be used in a system.
 */
#define I2C_CFG_TIMEOUTEN(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_CFG_TIMEOUTEN_SHIFT)) & I2C_CFG_TIMEOUTEN_MASK)
#define I2C_CFG_MONCLKSTR_MASK                   (0x10U)
#define I2C_CFG_MONCLKSTR_SHIFT                  (4U)
/*! MONCLKSTR - Monitor function Clock Stretching
 *  0b0..Disabled. The Monitor function will not perform clock stretching. Software or DMA may not always be able
 *       to read data provided by the Monitor function before it (the data) is overwritten. This mode can be used
 *       when non-invasive monitoring is critical.
 *  0b1..Enabled. The Monitor function will perform clock stretching, to ensure that the software or DMA can read
 *       all incoming data supplied by the Monitor function.
 */
#define I2C_CFG_MONCLKSTR(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_CFG_MONCLKSTR_SHIFT)) & I2C_CFG_MONCLKSTR_MASK)
#define I2C_CFG_HSCAPABLE_MASK                   (0x20U)
#define I2C_CFG_HSCAPABLE_SHIFT                  (5U)
/*! HSCAPABLE - High Speed mode Capable enable
 *  0b0..Fast mode Plus enable
 *  0b1..High Speed mode enable
 */
#define I2C_CFG_HSCAPABLE(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_CFG_HSCAPABLE_SHIFT)) & I2C_CFG_HSCAPABLE_MASK)
/*! @} */

/*! @name STAT - Status Register */
/*! @{ */
#define I2C_STAT_MSTPENDING_MASK                 (0x1U)
#define I2C_STAT_MSTPENDING_SHIFT                (0U)
/*! MSTPENDING - Master Pending
 *  0b0..In progress. Communication is in progress and the Master function is busy and cannot currently accept a command.
 *  0b1..Pending. The Master function needs software service or is in the idle state. If the master is not in the
 *       idle state, then the master is waiting to receive or transmit data, or is waiting for the NACK bit.
 */
#define I2C_STAT_MSTPENDING(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTPENDING_SHIFT)) & I2C_STAT_MSTPENDING_MASK)
#define I2C_STAT_MSTSTATE_MASK                   (0xEU)
#define I2C_STAT_MSTSTATE_SHIFT                  (1U)
/*! MSTSTATE - Master State code
 *  0b000..Idle. The Master function is available to be used for a new transaction.
 *  0b001..Receive ready. Received data is available (in Master Receiver mode). Address plus Read was previously sent and Acknowledged by a slave.
 *  0b010..Transmit ready. Data can be transmitted (in Master Transmitter mode). Address plus Write was previously sent and Acknowledged by a slave.
 *  0b011..NACK Address. Slave NACKed address.
 *  0b100..NACK Data. Slave NACKed transmitted data.
 */
#define I2C_STAT_MSTSTATE(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTSTATE_SHIFT)) & I2C_STAT_MSTSTATE_MASK)
#define I2C_STAT_MSTARBLOSS_MASK                 (0x10U)
#define I2C_STAT_MSTARBLOSS_SHIFT                (4U)
/*! MSTARBLOSS - Master Arbitration Loss flag
 *  0b0..No Arbitration Loss has occurred
 *  0b1..Arbitration loss. The Master function has experienced an Arbitration Loss. At this point, the Master
 *       function has already stopped driving the bus and has gone into an idle state. Software can respond by doing
 *       nothing, or by sending a Start (to attempt to gain control of the bus when the bus next becomes idle).
 */
#define I2C_STAT_MSTARBLOSS(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTARBLOSS_SHIFT)) & I2C_STAT_MSTARBLOSS_MASK)
#define I2C_STAT_MSTSTSTPERR_MASK                (0x40U)
#define I2C_STAT_MSTSTSTPERR_SHIFT               (6U)
/*! MSTSTSTPERR - Master Start/Stop Error flag
 *  0b0..No Start/Stop Error has occurred.
 *  0b1..The Master function has experienced a Start/Stop Error. A Start or Stop was detected at a time when Start
 *       or Stop is not allowed by the I2C specification. The Master interface has stopped driving the bus and
 *       gone into an idle state; no action is required. A request for a Start could be made, or software could
 *       attempt to make sure that the bus has not stalled.
 */
#define I2C_STAT_MSTSTSTPERR(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MSTSTSTPERR_SHIFT)) & I2C_STAT_MSTSTSTPERR_MASK)
#define I2C_STAT_SLVPENDING_MASK                 (0x100U)
#define I2C_STAT_SLVPENDING_SHIFT                (8U)
/*! SLVPENDING - Slave Pending
 *  0b0..In progress. The Slave function does not currently need software service.
 *  0b1..Pending. The Slave function needs software service. Information about what is needed is in the Slave state field (SLVSTATE).
 */
#define I2C_STAT_SLVPENDING(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVPENDING_SHIFT)) & I2C_STAT_SLVPENDING_MASK)
#define I2C_STAT_SLVSTATE_MASK                   (0x600U)
#define I2C_STAT_SLVSTATE_SHIFT                  (9U)
/*! SLVSTATE - Slave State
 *  0b00..Slave address. Address plus R/W received. At least one of the 4 slave addresses has been matched by hardware.
 *  0b01..Slave receive. Received data is available (in Slave Receiver mode).
 *  0b10..Slave transmit. Data can be transmitted (in Slave Transmitter mode).
 *  0b11..Reserved
 */
#define I2C_STAT_SLVSTATE(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVSTATE_SHIFT)) & I2C_STAT_SLVSTATE_MASK)
#define I2C_STAT_SLVNOTSTR_MASK                  (0x800U)
#define I2C_STAT_SLVNOTSTR_SHIFT                 (11U)
/*! SLVNOTSTR - Slave Not Stretching
 *  0b0..Stretching. The slave function is currently stretching the I2C bus clock. Deep-Sleepmode cannot be entered at this time.
 *  0b1..Not stretching. The slave function is not currently stretching the I2C bus clock. Deep-sleep mode can be entered at this time.
 */
#define I2C_STAT_SLVNOTSTR(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVNOTSTR_SHIFT)) & I2C_STAT_SLVNOTSTR_MASK)
#define I2C_STAT_SLVIDX_MASK                     (0x3000U)
#define I2C_STAT_SLVIDX_SHIFT                    (12U)
/*! SLVIDX - Slave address match Index T
 *  0b00..Address 0. Slave address 0 was matched.
 *  0b01..Address 1. Slave address 1 was matched.
 *  0b10..Address 2. Slave address 2 was matched.
 *  0b11..Address 3. Slave address 3 was matched.
 */
#define I2C_STAT_SLVIDX(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVIDX_SHIFT)) & I2C_STAT_SLVIDX_MASK)
#define I2C_STAT_SLVSEL_MASK                     (0x4000U)
#define I2C_STAT_SLVSEL_SHIFT                    (14U)
/*! SLVSEL - Slave selected flag
 *  0b0..Not selected. The Slave function is not currently selected.
 *  0b1..Selected. The Slave function is currently selected.
 */
#define I2C_STAT_SLVSEL(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVSEL_SHIFT)) & I2C_STAT_SLVSEL_MASK)
#define I2C_STAT_SLVDESEL_MASK                   (0x8000U)
#define I2C_STAT_SLVDESEL_SHIFT                  (15U)
/*! SLVDESEL - Slave Deselected flag
 *  0b0..Not deselected. The Slave function has not become deselected. This does not mean that the Slave is
 *       currently selected. That information is in the SLVSEL flag.
 *  0b1..Deselected. The Slave function has become deselected. This is specifically caused by the SLVSEL flag
 *       changing from 1 to 0. See SLVSEL for details about when that event occurs.
 */
#define I2C_STAT_SLVDESEL(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SLVDESEL_SHIFT)) & I2C_STAT_SLVDESEL_MASK)
#define I2C_STAT_MONRDY_MASK                     (0x10000U)
#define I2C_STAT_MONRDY_SHIFT                    (16U)
/*! MONRDY - Monitor Ready
 *  0b0..No data. The Monitor function does not currently have data available.
 *  0b1..Data waiting. The Monitor function has data waiting to be read.
 */
#define I2C_STAT_MONRDY(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONRDY_SHIFT)) & I2C_STAT_MONRDY_MASK)
#define I2C_STAT_MONOV_MASK                      (0x20000U)
#define I2C_STAT_MONOV_SHIFT                     (17U)
/*! MONOV - Monitor Overflow flag
 *  0b0..No overrun. Monitor data has not overrun.
 *  0b1..Overrun. A Monitor data overrun has occurred. An overrun can only happen when Monitor clock stretching
 *       not enabled via the CFG[MONCLKSTR] bit. Writing 1 to MONOV bit clears the MONOV flag.
 */
#define I2C_STAT_MONOV(x)                        (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONOV_SHIFT)) & I2C_STAT_MONOV_MASK)
#define I2C_STAT_MONACTIVE_MASK                  (0x40000U)
#define I2C_STAT_MONACTIVE_SHIFT                 (18U)
/*! MONACTIVE - Monitor Active flag
 *  0b0..Inactive. The Monitor function considers the I2C bus to be inactive.
 *  0b1..Active. The Monitor function considers the I2C bus to be active.
 */
#define I2C_STAT_MONACTIVE(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONACTIVE_SHIFT)) & I2C_STAT_MONACTIVE_MASK)
#define I2C_STAT_MONIDLE_MASK                    (0x80000U)
#define I2C_STAT_MONIDLE_SHIFT                   (19U)
/*! MONIDLE - Monitor Idle flag
 *  0b0..Not idle. The I2C bus is not idle, or MONIDLE flag has been cleared by software.
 *  0b1..Idle. The I2C bus has gone idle at least once, since the last time MONIDLE flag was cleared by software.
 */
#define I2C_STAT_MONIDLE(x)                      (((uint32_t)(((uint32_t)(x)) << I2C_STAT_MONIDLE_SHIFT)) & I2C_STAT_MONIDLE_MASK)
#define I2C_STAT_EVENTTIMEOUT_MASK               (0x1000000U)
#define I2C_STAT_EVENTTIMEOUT_SHIFT              (24U)
/*! EVENTTIMEOUT - Event Time-out Interrupt flag
 *  0b0..No time-out. I2C bus events have not caused a time-out.
 *  0b1..Event time-out. The time between I2C bus events has been longer than the time specified by the TIMEOUT register.
 */
#define I2C_STAT_EVENTTIMEOUT(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_STAT_EVENTTIMEOUT_SHIFT)) & I2C_STAT_EVENTTIMEOUT_MASK)
#define I2C_STAT_SCLTIMEOUT_MASK                 (0x2000000U)
#define I2C_STAT_SCLTIMEOUT_SHIFT                (25U)
/*! SCLTIMEOUT - SCL Time-out Interrupt flag
 *  0b0..No time-out. SCL low time has not caused a time-out.
 *  0b1..Time-out. SCL low time has caused a time-out.
 */
#define I2C_STAT_SCLTIMEOUT(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_STAT_SCLTIMEOUT_SHIFT)) & I2C_STAT_SCLTIMEOUT_MASK)
/*! @} */

/*! @name INTENSET - Interrupt Enable Set Register */
/*! @{ */
#define I2C_INTENSET_MSTPENDINGEN_MASK           (0x1U)
#define I2C_INTENSET_MSTPENDINGEN_SHIFT          (0U)
/*! MSTPENDINGEN - Master Pending interrupt Enable
 *  0b0..Disabled. The MstPending interrupt is disabled.
 *  0b1..Enabled. The MstPending interrupt is enabled.
 */
#define I2C_INTENSET_MSTPENDINGEN(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MSTPENDINGEN_SHIFT)) & I2C_INTENSET_MSTPENDINGEN_MASK)
#define I2C_INTENSET_MSTARBLOSSEN_MASK           (0x10U)
#define I2C_INTENSET_MSTARBLOSSEN_SHIFT          (4U)
/*! MSTARBLOSSEN - Master Arbitration Loss interrupt Enable
 *  0b0..Disabled. The MstArbLoss interrupt is disabled.
 *  0b1..Enabled. The MstArbLoss interrupt is enabled.
 */
#define I2C_INTENSET_MSTARBLOSSEN(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MSTARBLOSSEN_SHIFT)) & I2C_INTENSET_MSTARBLOSSEN_MASK)
#define I2C_INTENSET_MSTSTSTPERREN_MASK          (0x40U)
#define I2C_INTENSET_MSTSTSTPERREN_SHIFT         (6U)
/*! MSTSTSTPERREN - Master Start/Stop Error interrupt Enable
 *  0b0..Disabled. The MstStStpErr interrupt is disabled.
 *  0b1..Enabled. The MstStStpErr interrupt is enabled.
 */
#define I2C_INTENSET_MSTSTSTPERREN(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MSTSTSTPERREN_SHIFT)) & I2C_INTENSET_MSTSTSTPERREN_MASK)
#define I2C_INTENSET_SLVPENDINGEN_MASK           (0x100U)
#define I2C_INTENSET_SLVPENDINGEN_SHIFT          (8U)
/*! SLVPENDINGEN - Slave Pending interrupt Enable
 *  0b0..Disabled. The SlvPending interrupt is disabled.
 *  0b1..Enabled. The SlvPending interrupt is enabled.
 */
#define I2C_INTENSET_SLVPENDINGEN(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SLVPENDINGEN_SHIFT)) & I2C_INTENSET_SLVPENDINGEN_MASK)
#define I2C_INTENSET_SLVNOTSTREN_MASK            (0x800U)
#define I2C_INTENSET_SLVNOTSTREN_SHIFT           (11U)
/*! SLVNOTSTREN - Slave Not Stretching interrupt Enable
 *  0b0..Disabled. The SlvNotStr interrupt is disabled.
 *  0b1..Enabled. The SlvNotStr interrupt is enabled.
 */
#define I2C_INTENSET_SLVNOTSTREN(x)              (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SLVNOTSTREN_SHIFT)) & I2C_INTENSET_SLVNOTSTREN_MASK)
#define I2C_INTENSET_SLVDESELEN_MASK             (0x8000U)
#define I2C_INTENSET_SLVDESELEN_SHIFT            (15U)
/*! SLVDESELEN - Slave Deselect interrupt Enable
 *  0b0..Disabled. The SlvDeSel interrupt is disabled.
 *  0b1..Enabled. The SlvDeSel interrupt is enabled.
 */
#define I2C_INTENSET_SLVDESELEN(x)               (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SLVDESELEN_SHIFT)) & I2C_INTENSET_SLVDESELEN_MASK)
#define I2C_INTENSET_MONRDYEN_MASK               (0x10000U)
#define I2C_INTENSET_MONRDYEN_SHIFT              (16U)
/*! MONRDYEN - Monitor data Ready interrupt Enable
 *  0b0..Disabled. The MonRdy interrupt is disabled.
 *  0b1..Enabled. The MonRdy interrupt is enabled.
 */
#define I2C_INTENSET_MONRDYEN(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MONRDYEN_SHIFT)) & I2C_INTENSET_MONRDYEN_MASK)
#define I2C_INTENSET_MONOVEN_MASK                (0x20000U)
#define I2C_INTENSET_MONOVEN_SHIFT               (17U)
/*! MONOVEN - Monitor Overrun interrupt Enable
 *  0b0..Disabled. The MonOv interrupt is disabled.
 *  0b1..Enabled. The MonOv interrupt is enabled.
 */
#define I2C_INTENSET_MONOVEN(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MONOVEN_SHIFT)) & I2C_INTENSET_MONOVEN_MASK)
#define I2C_INTENSET_MONIDLEEN_MASK              (0x80000U)
#define I2C_INTENSET_MONIDLEEN_SHIFT             (19U)
/*! MONIDLEEN - Monitor Idle interrupt Enable
 *  0b0..Disabled. The MonIdle interrupt is disabled.
 *  0b1..Enabled. The MonIdle interrupt is enabled.
 */
#define I2C_INTENSET_MONIDLEEN(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_MONIDLEEN_SHIFT)) & I2C_INTENSET_MONIDLEEN_MASK)
#define I2C_INTENSET_EVENTTIMEOUTEN_MASK         (0x1000000U)
#define I2C_INTENSET_EVENTTIMEOUTEN_SHIFT        (24U)
/*! EVENTTIMEOUTEN - Event Time-out interrupt Enable
 *  0b0..Disabled. The Event time-out interrupt is disabled.
 *  0b1..Enabled. The Event time-out interrupt is enabled.
 */
#define I2C_INTENSET_EVENTTIMEOUTEN(x)           (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_EVENTTIMEOUTEN_SHIFT)) & I2C_INTENSET_EVENTTIMEOUTEN_MASK)
#define I2C_INTENSET_SCLTIMEOUTEN_MASK           (0x2000000U)
#define I2C_INTENSET_SCLTIMEOUTEN_SHIFT          (25U)
/*! SCLTIMEOUTEN - SCL Time-out interrupt Enable
 *  0b0..Disabled. The SCL time-out interrupt is disabled.
 *  0b1..Enabled. The SCL time-out interrupt is enabled.
 */
#define I2C_INTENSET_SCLTIMEOUTEN(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENSET_SCLTIMEOUTEN_SHIFT)) & I2C_INTENSET_SCLTIMEOUTEN_MASK)
/*! @} */

/*! @name INTENCLR - Interrupt Enable Clear Register */
/*! @{ */
#define I2C_INTENCLR_MSTPENDINGCLR_MASK          (0x1U)
#define I2C_INTENCLR_MSTPENDINGCLR_SHIFT         (0U)
/*! MSTPENDINGCLR - Master Pending interrupt clear
 *  0b0..No effect on interrupt
 *  0b1..Clears the interrupt bit in INTENSET register
 */
#define I2C_INTENCLR_MSTPENDINGCLR(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MSTPENDINGCLR_SHIFT)) & I2C_INTENCLR_MSTPENDINGCLR_MASK)
#define I2C_INTENCLR_MSTARBLOSSCLR_MASK          (0x10U)
#define I2C_INTENCLR_MSTARBLOSSCLR_SHIFT         (4U)
/*! MSTARBLOSSCLR - Master Arbitration Loss interrupt clear
 *  0b0..No effect on interrupt
 *  0b1..Clears the interrupt bit in INTENSET register
 */
#define I2C_INTENCLR_MSTARBLOSSCLR(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MSTARBLOSSCLR_SHIFT)) & I2C_INTENCLR_MSTARBLOSSCLR_MASK)
#define I2C_INTENCLR_MSTSTSTPERRCLR_MASK         (0x40U)
#define I2C_INTENCLR_MSTSTSTPERRCLR_SHIFT        (6U)
/*! MSTSTSTPERRCLR - Master Start/Stop Error interrupt clear
 *  0b0..No effect on interrupt
 *  0b1..Clears the interrupt bit in INTENSET register
 */
#define I2C_INTENCLR_MSTSTSTPERRCLR(x)           (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MSTSTSTPERRCLR_SHIFT)) & I2C_INTENCLR_MSTSTSTPERRCLR_MASK)
#define I2C_INTENCLR_SLVPENDINGCLR_MASK          (0x100U)
#define I2C_INTENCLR_SLVPENDINGCLR_SHIFT         (8U)
/*! SLVPENDINGCLR - Slave Pending interrupt clear
 *  0b0..No effect on interrupt
 *  0b1..Clears the interrupt bit in INTENSET register
 */
#define I2C_INTENCLR_SLVPENDINGCLR(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SLVPENDINGCLR_SHIFT)) & I2C_INTENCLR_SLVPENDINGCLR_MASK)
#define I2C_INTENCLR_SLVNOTSTRCLR_MASK           (0x800U)
#define I2C_INTENCLR_SLVNOTSTRCLR_SHIFT          (11U)
/*! SLVNOTSTRCLR - Slave Not Stretching interrupt clear
 *  0b0..No effect on interrupt
 *  0b1..Clears the interrupt bit in INTENSET register
 */
#define I2C_INTENCLR_SLVNOTSTRCLR(x)             (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SLVNOTSTRCLR_SHIFT)) & I2C_INTENCLR_SLVNOTSTRCLR_MASK)
#define I2C_INTENCLR_SLVDESELCLR_MASK            (0x8000U)
#define I2C_INTENCLR_SLVDESELCLR_SHIFT           (15U)
/*! SLVDESELCLR - Slave Deselect interrupt clear
 *  0b0..No effect on interrupt
 *  0b1..Clears the interrupt bit in INTENSET register
 */
#define I2C_INTENCLR_SLVDESELCLR(x)              (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SLVDESELCLR_SHIFT)) & I2C_INTENCLR_SLVDESELCLR_MASK)
#define I2C_INTENCLR_MONRDYCLR_MASK              (0x10000U)
#define I2C_INTENCLR_MONRDYCLR_SHIFT             (16U)
/*! MONRDYCLR - Monitor data Ready interrupt clear
 *  0b0..No effect on interrupt
 *  0b1..Clears the interrupt bit in INTENSET register
 */
#define I2C_INTENCLR_MONRDYCLR(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MONRDYCLR_SHIFT)) & I2C_INTENCLR_MONRDYCLR_MASK)
#define I2C_INTENCLR_MONOVCLR_MASK               (0x20000U)
#define I2C_INTENCLR_MONOVCLR_SHIFT              (17U)
/*! MONOVCLR - Monitor Overrun interrupt clear
 *  0b0..No effect on interrupt
 *  0b1..Clears the interrupt bit in INTENSET register
 */
#define I2C_INTENCLR_MONOVCLR(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MONOVCLR_SHIFT)) & I2C_INTENCLR_MONOVCLR_MASK)
#define I2C_INTENCLR_MONIDLECLR_MASK             (0x80000U)
#define I2C_INTENCLR_MONIDLECLR_SHIFT            (19U)
/*! MONIDLECLR - Monitor Idle interrupt clear
 *  0b0..No effect on interrupt
 *  0b1..Clears the interrupt bit in INTENSET register
 */
#define I2C_INTENCLR_MONIDLECLR(x)               (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_MONIDLECLR_SHIFT)) & I2C_INTENCLR_MONIDLECLR_MASK)
#define I2C_INTENCLR_EVENTTIMEOUTCLR_MASK        (0x1000000U)
#define I2C_INTENCLR_EVENTTIMEOUTCLR_SHIFT       (24U)
/*! EVENTTIMEOUTCLR - Event time-out interrupt clear
 *  0b0..No effect on interrupt
 *  0b1..Clears the interrupt bit in INTENSET register
 */
#define I2C_INTENCLR_EVENTTIMEOUTCLR(x)          (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_EVENTTIMEOUTCLR_SHIFT)) & I2C_INTENCLR_EVENTTIMEOUTCLR_MASK)
#define I2C_INTENCLR_SCLTIMEOUTCLR_MASK          (0x2000000U)
#define I2C_INTENCLR_SCLTIMEOUTCLR_SHIFT         (25U)
/*! SCLTIMEOUTCLR - SCL time-out interrupt clear
 *  0b0..No effect on interrupt
 *  0b1..Clears the interrupt bit in INTENSET register
 */
#define I2C_INTENCLR_SCLTIMEOUTCLR(x)            (((uint32_t)(((uint32_t)(x)) << I2C_INTENCLR_SCLTIMEOUTCLR_SHIFT)) & I2C_INTENCLR_SCLTIMEOUTCLR_MASK)
/*! @} */

/*! @name TIMEOUT - Time-out Register */
/*! @{ */
#define I2C_TIMEOUT_TOMIN_MASK                   (0xFU)
#define I2C_TIMEOUT_TOMIN_SHIFT                  (0U)
/*! TOMIN - Time-out time value, the bottom 4 bits
 */
#define I2C_TIMEOUT_TOMIN(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_TIMEOUT_TOMIN_SHIFT)) & I2C_TIMEOUT_TOMIN_MASK)
#define I2C_TIMEOUT_TO_MASK                      (0xFFF0U)
#define I2C_TIMEOUT_TO_SHIFT                     (4U)
/*! TO - Time-out time value
 *  0b000000000000..A time-out will occur after 16 counts of the I2C function clock.
 *  0b000000000001..A time-out will occur after 32 counts of the I2C function clock.
 *  0b111111111111..A time-out will occur after 65,536 counts of the I2C function clock.
 */
#define I2C_TIMEOUT_TO(x)                        (((uint32_t)(((uint32_t)(x)) << I2C_TIMEOUT_TO_SHIFT)) & I2C_TIMEOUT_TO_MASK)
/*! @} */

/*! @name CLKDIV - Clock Divider Register */
/*! @{ */
#define I2C_CLKDIV_DIVVAL_MASK                   (0xFFFFU)
#define I2C_CLKDIV_DIVVAL_SHIFT                  (0U)
/*! DIVVAL - Divider Value
 *  0b0000000000000000..FCLK is used directly by the I2C.
 *  0b0000000000000001..FCLK is divided by 2 before being used by the I2C.
 *  0b0000000000000010..FCLK is divided by 3 before being used by the I2C.
 *  0b1111111111111111..FCLK is divided by 65,536 before being used by the I2C.
 */
#define I2C_CLKDIV_DIVVAL(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_CLKDIV_DIVVAL_SHIFT)) & I2C_CLKDIV_DIVVAL_MASK)
/*! @} */

/*! @name INTSTAT - Interrupt Status Register */
/*! @{ */
#define I2C_INTSTAT_MSTPENDING_MASK              (0x1U)
#define I2C_INTSTAT_MSTPENDING_SHIFT             (0U)
/*! MSTPENDING - Master Pending
 *  0b0..Not active
 *  0b1..Active
 */
#define I2C_INTSTAT_MSTPENDING(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MSTPENDING_SHIFT)) & I2C_INTSTAT_MSTPENDING_MASK)
#define I2C_INTSTAT_MSTARBLOSS_MASK              (0x10U)
#define I2C_INTSTAT_MSTARBLOSS_SHIFT             (4U)
/*! MSTARBLOSS - Master Arbitration Loss flag
 *  0b0..Not active
 *  0b1..Active
 */
#define I2C_INTSTAT_MSTARBLOSS(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MSTARBLOSS_SHIFT)) & I2C_INTSTAT_MSTARBLOSS_MASK)
#define I2C_INTSTAT_MSTSTSTPERR_MASK             (0x40U)
#define I2C_INTSTAT_MSTSTSTPERR_SHIFT            (6U)
/*! MSTSTSTPERR - Master Start/Stop Error flag
 *  0b0..Not active
 *  0b1..Active
 */
#define I2C_INTSTAT_MSTSTSTPERR(x)               (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MSTSTSTPERR_SHIFT)) & I2C_INTSTAT_MSTSTSTPERR_MASK)
#define I2C_INTSTAT_SLVPENDING_MASK              (0x100U)
#define I2C_INTSTAT_SLVPENDING_SHIFT             (8U)
/*! SLVPENDING - Slave Pending
 *  0b0..Not active
 *  0b1..Active
 */
#define I2C_INTSTAT_SLVPENDING(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SLVPENDING_SHIFT)) & I2C_INTSTAT_SLVPENDING_MASK)
#define I2C_INTSTAT_SLVNOTSTR_MASK               (0x800U)
#define I2C_INTSTAT_SLVNOTSTR_SHIFT              (11U)
/*! SLVNOTSTR - Slave Not Stretching status
 *  0b0..Not active
 *  0b1..Active
 */
#define I2C_INTSTAT_SLVNOTSTR(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SLVNOTSTR_SHIFT)) & I2C_INTSTAT_SLVNOTSTR_MASK)
#define I2C_INTSTAT_SLVDESEL_MASK                (0x8000U)
#define I2C_INTSTAT_SLVDESEL_SHIFT               (15U)
/*! SLVDESEL - Slave Deselected flag
 *  0b0..Not active
 *  0b1..Active
 */
#define I2C_INTSTAT_SLVDESEL(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SLVDESEL_SHIFT)) & I2C_INTSTAT_SLVDESEL_MASK)
#define I2C_INTSTAT_MONRDY_MASK                  (0x10000U)
#define I2C_INTSTAT_MONRDY_SHIFT                 (16U)
/*! MONRDY - Monitor Ready
 *  0b0..Not active
 *  0b1..Active
 */
#define I2C_INTSTAT_MONRDY(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MONRDY_SHIFT)) & I2C_INTSTAT_MONRDY_MASK)
#define I2C_INTSTAT_MONOV_MASK                   (0x20000U)
#define I2C_INTSTAT_MONOV_SHIFT                  (17U)
/*! MONOV - Monitor Overflow flag
 *  0b0..Not active
 *  0b1..Active
 */
#define I2C_INTSTAT_MONOV(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MONOV_SHIFT)) & I2C_INTSTAT_MONOV_MASK)
#define I2C_INTSTAT_MONIDLE_MASK                 (0x80000U)
#define I2C_INTSTAT_MONIDLE_SHIFT                (19U)
/*! MONIDLE - Monitor Idle flag
 *  0b0..Not active
 *  0b1..Active
 */
#define I2C_INTSTAT_MONIDLE(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_MONIDLE_SHIFT)) & I2C_INTSTAT_MONIDLE_MASK)
#define I2C_INTSTAT_EVENTTIMEOUT_MASK            (0x1000000U)
#define I2C_INTSTAT_EVENTTIMEOUT_SHIFT           (24U)
/*! EVENTTIMEOUT - Event Time-out Interrupt flag
 *  0b0..Not active
 *  0b1..Active
 */
#define I2C_INTSTAT_EVENTTIMEOUT(x)              (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_EVENTTIMEOUT_SHIFT)) & I2C_INTSTAT_EVENTTIMEOUT_MASK)
#define I2C_INTSTAT_SCLTIMEOUT_MASK              (0x2000000U)
#define I2C_INTSTAT_SCLTIMEOUT_SHIFT             (25U)
/*! SCLTIMEOUT - SCL Time-out Interrupt flag
 *  0b0..Not active
 *  0b1..Active
 */
#define I2C_INTSTAT_SCLTIMEOUT(x)                (((uint32_t)(((uint32_t)(x)) << I2C_INTSTAT_SCLTIMEOUT_SHIFT)) & I2C_INTSTAT_SCLTIMEOUT_MASK)
/*! @} */

/*! @name MSTCTL - Master Control Register */
/*! @{ */
#define I2C_MSTCTL_MSTCONTINUE_MASK              (0x1U)
#define I2C_MSTCTL_MSTCONTINUE_SHIFT             (0U)
/*! MSTCONTINUE - Master Continue(write-only)
 *  0b0..No effect
 *  0b1..Continue. Informs the Master function to continue to the next operation. This action must done after
 *       writing transmit data, reading received data, or any other housekeeping related to the next bus operation.
 */
#define I2C_MSTCTL_MSTCONTINUE(x)                (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTCONTINUE_SHIFT)) & I2C_MSTCTL_MSTCONTINUE_MASK)
#define I2C_MSTCTL_MSTSTART_MASK                 (0x2U)
#define I2C_MSTCTL_MSTSTART_SHIFT                (1U)
/*! MSTSTART - Master Start control(write-only)
 *  0b0..No effect
 *  0b1..Start. A Start will be generated on the I2C bus at the next allowed time.
 */
#define I2C_MSTCTL_MSTSTART(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTSTART_SHIFT)) & I2C_MSTCTL_MSTSTART_MASK)
#define I2C_MSTCTL_MSTSTOP_MASK                  (0x4U)
#define I2C_MSTCTL_MSTSTOP_SHIFT                 (2U)
/*! MSTSTOP - Master Stop control(write-only)
 *  0b0..No effect
 *  0b1..Stop. A Stop will be generated on the I2C bus at the next allowed time, preceded by a NACK to the slave
 *       if the master is receiving data from the slave (in Master Receiver mode).
 */
#define I2C_MSTCTL_MSTSTOP(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTSTOP_SHIFT)) & I2C_MSTCTL_MSTSTOP_MASK)
#define I2C_MSTCTL_MSTDMA_MASK                   (0x8U)
#define I2C_MSTCTL_MSTDMA_SHIFT                  (3U)
/*! MSTDMA - Master DMA enable
 *  0b0..Disable. No DMA requests are generated for master operation.
 *  0b1..Enable. A DMA request is generated for I2C master data operations. When this I2C master is generating
 *       Acknowledge bits in Master Receiver mode, the acknowledge is generated automatically.
 */
#define I2C_MSTCTL_MSTDMA(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_MSTCTL_MSTDMA_SHIFT)) & I2C_MSTCTL_MSTDMA_MASK)
/*! @} */

/*! @name MSTTIME - Master Timing Register */
/*! @{ */
#define I2C_MSTTIME_MSTSCLLOW_MASK               (0x7U)
#define I2C_MSTTIME_MSTSCLLOW_SHIFT              (0U)
/*! MSTSCLLOW - Master SCL Low time
 *  0b000..2 clocks. Minimum SCL low time is 2 clocks of the I2C clock pre-divider.
 *  0b001..3 clocks. Minimum SCL low time is 3 clocks of the I2C clock pre-divider.
 *  0b010..4 clocks. Minimum SCL low time is 4 clocks of the I2C clock pre-divider.
 *  0b011..5 clocks. Minimum SCL low time is 5 clocks of the I2C clock pre-divider.
 *  0b100..6 clocks. Minimum SCL low time is 6 clocks of the I2C clock pre-divider.
 *  0b101..7 clocks. Minimum SCL low time is 7 clocks of the I2C clock pre-divider.
 *  0b110..8 clocks. Minimum SCL low time is 8 clocks of the I2C clock pre-divider.
 *  0b111..9 clocks. Minimum SCL low time is 9 clocks of the I2C clock pre-divider.
 */
#define I2C_MSTTIME_MSTSCLLOW(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_MSTTIME_MSTSCLLOW_SHIFT)) & I2C_MSTTIME_MSTSCLLOW_MASK)
#define I2C_MSTTIME_MSTSCLHIGH_MASK              (0x70U)
#define I2C_MSTTIME_MSTSCLHIGH_SHIFT             (4U)
/*! MSTSCLHIGH - Master SCL High time
 *  0b000..2 clocks. Minimum SCL high time is 2 clocks of the I2C clock pre-divider.
 *  0b001..3 clocks. Minimum SCL high time is 3 clocks of the I2C clock pre-divider .
 *  0b010..4 clocks. Minimum SCL high time is 4 clocks of the I2C clock pre-divider.
 *  0b011..5 clocks. Minimum SCL high time is 5 clocks of the I2C clock pre-divider.
 *  0b100..6 clocks. Minimum SCL high time is 6 clocks of the I2C clock pre-divider.
 *  0b101..7 clocks. Minimum SCL high time is 7 clocks of the I2C clock pre-divider.
 *  0b110..8 clocks. Minimum SCL high time is 8 clocks of the I2C clock pre-divider.
 *  0b111..9 clocks. Minimum SCL high time is 9 clocks of the I2C clock pre-divider.
 */
#define I2C_MSTTIME_MSTSCLHIGH(x)                (((uint32_t)(((uint32_t)(x)) << I2C_MSTTIME_MSTSCLHIGH_SHIFT)) & I2C_MSTTIME_MSTSCLHIGH_MASK)
/*! @} */

/*! @name MSTDAT - Master Data Register */
/*! @{ */
#define I2C_MSTDAT_DATA_MASK                     (0xFFU)
#define I2C_MSTDAT_DATA_SHIFT                    (0U)
/*! DATA - Master function data register
 */
#define I2C_MSTDAT_DATA(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_MSTDAT_DATA_SHIFT)) & I2C_MSTDAT_DATA_MASK)
/*! @} */

/*! @name SLVCTL - Slave Control Register */
/*! @{ */
#define I2C_SLVCTL_SLVCONTINUE_MASK              (0x1U)
#define I2C_SLVCTL_SLVCONTINUE_SHIFT             (0U)
/*! SLVCONTINUE - Slave Continue
 *  0b0..No effect
 *  0b1..Continue. Informs the Slave function to continue to the next operation, by clearing the STAT[SLVPENDING]
 *       flag. This must be done after writing transmit data, reading received data, or any other housekeeping
 *       related to the next bus operation. Automatic Operation has different requirements. SLVCONTINUE should not be
 *       set unless SLVPENDING = 1.
 */
#define I2C_SLVCTL_SLVCONTINUE(x)                (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_SLVCONTINUE_SHIFT)) & I2C_SLVCTL_SLVCONTINUE_MASK)
#define I2C_SLVCTL_SLVNACK_MASK                  (0x2U)
#define I2C_SLVCTL_SLVNACK_SHIFT                 (1U)
/*! SLVNACK - Slave NACK
 *  0b0..No effect
 *  0b1..NACK. Causes the Slave function to NACK the master when the slave is receiving data from the master (in Slave Receiver mode).
 */
#define I2C_SLVCTL_SLVNACK(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_SLVNACK_SHIFT)) & I2C_SLVCTL_SLVNACK_MASK)
#define I2C_SLVCTL_SLVDMA_MASK                   (0x8U)
#define I2C_SLVCTL_SLVDMA_SHIFT                  (3U)
/*! SLVDMA - Slave DMA enable
 *  0b0..Disabled. No DMA requests are issued for Slave mode operation.
 *  0b1..Enabled. DMA requests are issued for I2C slave data transmission and reception.
 */
#define I2C_SLVCTL_SLVDMA(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_SLVDMA_SHIFT)) & I2C_SLVCTL_SLVDMA_MASK)
#define I2C_SLVCTL_AUTOACK_MASK                  (0x100U)
#define I2C_SLVCTL_AUTOACK_SHIFT                 (8U)
/*! AUTOACK - Automatic Acknowledge
 *  0b0..Normal, non-automatic operation. If AUTONACK = 0, then a SlvPending interrupt is generated when a
 *       matching address is received. If AUTONACK = 1, then received addresses are NACKed (ignored).
 *  0b1..A header with matching SLVADR0 and matching direction as set by AUTOMATCHREAD will be ACKed immediately,
 *       allowing the master to move on to the data bytes. If the address matches SLVADR0, but the direction does
 *       not match AUTOMATCHREAD, then the behavior will depend on the SLVADR0[AUTONACK] bit: if AUTONACK is set,
 *       then it will be Nacked; if AUTONACK is clear, then a SlvPending interrupt is generated.
 */
#define I2C_SLVCTL_AUTOACK(x)                    (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_AUTOACK_SHIFT)) & I2C_SLVCTL_AUTOACK_MASK)
#define I2C_SLVCTL_AUTOMATCHREAD_MASK            (0x200U)
#define I2C_SLVCTL_AUTOMATCHREAD_SHIFT           (9U)
/*! AUTOMATCHREAD - Automatic Match Read
 *  0b0..In Automatic Mode, the expected next operation is an I2C write.
 *  0b1..In Automatic Mode, the expected next operation is an I2C read.
 */
#define I2C_SLVCTL_AUTOMATCHREAD(x)              (((uint32_t)(((uint32_t)(x)) << I2C_SLVCTL_AUTOMATCHREAD_SHIFT)) & I2C_SLVCTL_AUTOMATCHREAD_MASK)
/*! @} */

/*! @name SLVDAT - Slave Data Register */
/*! @{ */
#define I2C_SLVDAT_DATA_MASK                     (0xFFU)
#define I2C_SLVDAT_DATA_SHIFT                    (0U)
/*! DATA - Slave function data register
 */
#define I2C_SLVDAT_DATA(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_SLVDAT_DATA_SHIFT)) & I2C_SLVDAT_DATA_MASK)
/*! @} */

/*! @name SLVADR - Slave Address Register */
/*! @{ */
#define I2C_SLVADR_SADISABLE_MASK                (0x1U)
#define I2C_SLVADR_SADISABLE_SHIFT               (0U)
/*! SADISABLE - Slave Address n Disable
 *  0b0..Enabled. Slave Address n is enabled.
 *  0b1..Ignored. Slave Address n is ignored.
 */
#define I2C_SLVADR_SADISABLE(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_SLVADR_SADISABLE_SHIFT)) & I2C_SLVADR_SADISABLE_MASK)
#define I2C_SLVADR_SLVADR_MASK                   (0xFEU)
#define I2C_SLVADR_SLVADR_SHIFT                  (1U)
/*! SLVADR - Slave Address.
 */
#define I2C_SLVADR_SLVADR(x)                     (((uint32_t)(((uint32_t)(x)) << I2C_SLVADR_SLVADR_SHIFT)) & I2C_SLVADR_SLVADR_MASK)
#define I2C_SLVADR_AUTONACK_MASK                 (0x8000U)
#define I2C_SLVADR_AUTONACK_SHIFT                (15U)
/*! AUTONACK - Automatic NACK operation
 *  0b0..Normal operation, matching I2C addresses are not ignored.
 *  0b1..Automatic-only mode. All incoming addresses are ignored (NACKed), unless AUTOACK is set, and the address
 *       matches SLVADRn, and AUTOMATCHREAD matches the direction.
 */
#define I2C_SLVADR_AUTONACK(x)                   (((uint32_t)(((uint32_t)(x)) << I2C_SLVADR_AUTONACK_SHIFT)) & I2C_SLVADR_AUTONACK_MASK)
/*! @} */

/* The count of I2C_SLVADR */
#define I2C_SLVADR_COUNT                         (4U)

/*! @name SLVQUAL0 - Slave Qualification for Address 0 Register */
/*! @{ */
#define I2C_SLVQUAL0_QUALMODE0_MASK              (0x1U)
#define I2C_SLVQUAL0_QUALMODE0_SHIFT             (0U)
/*! QUALMODE0 - Qualify mode for slave address 0
 *  0b0..Mask. The SLVQUAL0 field is used as a logical mask for matching address 0.
 *  0b1..Extend. The SLVQUAL0 field is used to extend address 0 matching in a range of addresses.
 */
#define I2C_SLVQUAL0_QUALMODE0(x)                (((uint32_t)(((uint32_t)(x)) << I2C_SLVQUAL0_QUALMODE0_SHIFT)) & I2C_SLVQUAL0_QUALMODE0_MASK)
#define I2C_SLVQUAL0_SLVQUAL0_MASK               (0xFEU)
#define I2C_SLVQUAL0_SLVQUAL0_SHIFT              (1U)
/*! SLVQUAL0 - Slave address Qualifier for address 0
 */
#define I2C_SLVQUAL0_SLVQUAL0(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_SLVQUAL0_SLVQUAL0_SHIFT)) & I2C_SLVQUAL0_SLVQUAL0_MASK)
/*! @} */

/*! @name MONRXDAT - Monitor Receiver Data Register */
/*! @{ */
#define I2C_MONRXDAT_MONRXDAT_MASK               (0xFFU)
#define I2C_MONRXDAT_MONRXDAT_SHIFT              (0U)
/*! MONRXDAT - Monitor function Receiver Data
 */
#define I2C_MONRXDAT_MONRXDAT(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONRXDAT_SHIFT)) & I2C_MONRXDAT_MONRXDAT_MASK)
#define I2C_MONRXDAT_MONSTART_MASK               (0x100U)
#define I2C_MONRXDAT_MONSTART_SHIFT              (8U)
/*! MONSTART - Monitor Received Start
 *  0b0..No start detected. The Monitor function has not detected a Start event on the I2C bus.
 *  0b1..Start detected. The Monitor function has detected a Start event on the I2C bus.
 */
#define I2C_MONRXDAT_MONSTART(x)                 (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONSTART_SHIFT)) & I2C_MONRXDAT_MONSTART_MASK)
#define I2C_MONRXDAT_MONRESTART_MASK             (0x200U)
#define I2C_MONRXDAT_MONRESTART_SHIFT            (9U)
/*! MONRESTART - Monitor Received Repeated Start
 *  0b0..No repeated start detected. The Monitor function has not detected a Repeated Start event on the I2C bus.
 *  0b1..Repeated start detected. The Monitor function has detected a Repeated Start event on the I2C bus.
 */
#define I2C_MONRXDAT_MONRESTART(x)               (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONRESTART_SHIFT)) & I2C_MONRXDAT_MONRESTART_MASK)
#define I2C_MONRXDAT_MONNACK_MASK                (0x400U)
#define I2C_MONRXDAT_MONNACK_SHIFT               (10U)
/*! MONNACK - Monitor Received NACK
 *  0b0..Acknowledged. The data currently being provided by the Monitor function was acknowledged by at least one master or slave receiver.
 *  0b1..Not acknowledged. The data currently being provided by the Monitor function was not acknowledged by any receiver.
 */
#define I2C_MONRXDAT_MONNACK(x)                  (((uint32_t)(((uint32_t)(x)) << I2C_MONRXDAT_MONNACK_SHIFT)) & I2C_MONRXDAT_MONNACK_MASK)
/*! @} */

/*! @name ID - Peripheral Identification Register */
/*! @{ */
#define I2C_ID_APERTURE_MASK                     (0xFFU)
#define I2C_ID_APERTURE_SHIFT                    (0U)
/*! APERTURE - Aperture
 */
#define I2C_ID_APERTURE(x)                       (((uint32_t)(((uint32_t)(x)) << I2C_ID_APERTURE_SHIFT)) & I2C_ID_APERTURE_MASK)
#define I2C_ID_MINOR_REV_MASK                    (0xF00U)
#define I2C_ID_MINOR_REV_SHIFT                   (8U)
/*! MINOR_REV - Minor revision of module implementation
 */
#define I2C_ID_MINOR_REV(x)                      (((uint32_t)(((uint32_t)(x)) << I2C_ID_MINOR_REV_SHIFT)) & I2C_ID_MINOR_REV_MASK)
#define I2C_ID_MAJOR_REV_MASK                    (0xF000U)
#define I2C_ID_MAJOR_REV_SHIFT                   (12U)
/*! MAJOR_REV - Major revision of module implementation
 */
#define I2C_ID_MAJOR_REV(x)                      (((uint32_t)(((uint32_t)(x)) << I2C_ID_MAJOR_REV_SHIFT)) & I2C_ID_MAJOR_REV_MASK)
#define I2C_ID_ID_MASK                           (0xFFFF0000U)
#define I2C_ID_ID_SHIFT                          (16U)
/*! ID - Module identifier for the selected function
 */
#define I2C_ID_ID(x)                             (((uint32_t)(((uint32_t)(x)) << I2C_ID_ID_SHIFT)) & I2C_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group I2C_Register_Masks */


/* I2C - Peripheral instance base addresses */
/** Peripheral I2C0 base address */
#define I2C0_BASE                                (0x40106000u)
/** Peripheral I2C0 base pointer */
#define I2C0                                     ((I2C_Type *)I2C0_BASE)
/** Peripheral I2C1 base address */
#define I2C1_BASE                                (0x40107000u)
/** Peripheral I2C1 base pointer */
#define I2C1                                     ((I2C_Type *)I2C1_BASE)
/** Peripheral I2C2 base address */
#define I2C2_BASE                                (0x40108000u)
/** Peripheral I2C2 base pointer */
#define I2C2                                     ((I2C_Type *)I2C2_BASE)
/** Peripheral I2C3 base address */
#define I2C3_BASE                                (0x40109000u)
/** Peripheral I2C3 base pointer */
#define I2C3                                     ((I2C_Type *)I2C3_BASE)
/** Peripheral I2C4 base address */
#define I2C4_BASE                                (0x40122000u)
/** Peripheral I2C4 base pointer */
#define I2C4                                     ((I2C_Type *)I2C4_BASE)
/** Peripheral I2C5 base address */
#define I2C5_BASE                                (0x40123000u)
/** Peripheral I2C5 base pointer */
#define I2C5                                     ((I2C_Type *)I2C5_BASE)
/** Peripheral I2C6 base address */
#define I2C6_BASE                                (0x40124000u)
/** Peripheral I2C6 base pointer */
#define I2C6                                     ((I2C_Type *)I2C6_BASE)
/** Peripheral I2C7 base address */
#define I2C7_BASE                                (0x40125000u)
/** Peripheral I2C7 base pointer */
#define I2C7                                     ((I2C_Type *)I2C7_BASE)
/** Peripheral I2C8 base address */
#define I2C8_BASE                                (0x40209000u)
/** Peripheral I2C8 base pointer */
#define I2C8                                     ((I2C_Type *)I2C8_BASE)
/** Peripheral I2C9 base address */
#define I2C9_BASE                                (0x4020A000u)
/** Peripheral I2C9 base pointer */
#define I2C9                                     ((I2C_Type *)I2C9_BASE)
/** Peripheral I2C10 base address */
#define I2C10_BASE                               (0x4020B000u)
/** Peripheral I2C10 base pointer */
#define I2C10                                    ((I2C_Type *)I2C10_BASE)
/** Peripheral I2C11 base address */
#define I2C11_BASE                               (0x4020C000u)
/** Peripheral I2C11 base pointer */
#define I2C11                                    ((I2C_Type *)I2C11_BASE)
/** Peripheral I2C12 base address */
#define I2C12_BASE                               (0x4020D000u)
/** Peripheral I2C12 base pointer */
#define I2C12                                    ((I2C_Type *)I2C12_BASE)
/** Peripheral I2C13 base address */
#define I2C13_BASE                               (0x4020E000u)
/** Peripheral I2C13 base pointer */
#define I2C13                                    ((I2C_Type *)I2C13_BASE)
/** Peripheral I2C15 base address */
#define I2C15_BASE                               (0x40127000u)
/** Peripheral I2C15 base pointer */
#define I2C15                                    ((I2C_Type *)I2C15_BASE)
/** Array initializer of I2C peripheral base addresses */
#define I2C_BASE_ADDRS                           { I2C0_BASE, I2C1_BASE, I2C2_BASE, I2C3_BASE, I2C4_BASE, I2C5_BASE, I2C6_BASE, I2C7_BASE, I2C8_BASE, I2C9_BASE, I2C10_BASE, I2C11_BASE, I2C12_BASE, I2C13_BASE, I2C15_BASE }
/** Array initializer of I2C peripheral base pointers */
#define I2C_BASE_PTRS                            { I2C0, I2C1, I2C2, I2C3, I2C4, I2C5, I2C6, I2C7, I2C8, I2C9, I2C10, I2C11, I2C12, I2C13, I2C15 }
/** Interrupt vectors for the I2C peripheral type */
#define I2C_IRQS                                 { FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, FLEXCOMM6_IRQn, FLEXCOMM7_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn }

/*!
 * @}
 */ /* end of group I2C_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- I2S Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2S_Peripheral_Access_Layer I2S Peripheral Access Layer
 * @{
 */

/** I2S - Register Layout Typedef */
typedef struct {
       uint8_t RESERVED_0[3072];
  __IO uint32_t CFG1;                              /**< Configuration Register 1 for the Primary Channel Pair, offset: 0xC00 */
  __IO uint32_t CFG2;                              /**< Configuration Register 2 for the Primary Channel Pair, offset: 0xC04 */
  __IO uint32_t STAT;                              /**< Status Register for the Primary Channel Pair, offset: 0xC08 */
       uint8_t RESERVED_1[16];
  __IO uint32_t DIV;                               /**< Clock Divider, offset: 0xC1C */
  struct {                                         /* offset: 0xC20, array step: 0x20 */
    __IO uint32_t PCFG1;                             /**< Configuration Register 1 for Channel Pair 1..Configuration Register 1 for Channel Pair 3, array offset: 0xC20, array step: 0x20 */
    __IO uint32_t PCFG2;                             /**< Configuration Register 2 for Channel Pair 1..Configuration Register 2 for Channel Pair 3, array offset: 0xC24, array step: 0x20 */
    __I  uint32_t PSTAT;                             /**< Status Register for Channel Pair 1..Status Register for Channel Pair 3, array offset: 0xC28, array step: 0x20 */
         uint8_t RESERVED_0[20];
  } SECCHANNEL[3];
       uint8_t RESERVED_2[384];
  __IO uint32_t FIFOCFG;                           /**< FIFO Configuration and Enable, offset: 0xE00 */
  __IO uint32_t FIFOSTAT;                          /**< FIFO Status, offset: 0xE04 */
  __IO uint32_t FIFOTRIG;                          /**< FIFO Trigger Settings, offset: 0xE08 */
       uint8_t RESERVED_3[4];
  __IO uint32_t FIFOINTENSET;                      /**< FIFO Interrupt Enable Set and Read, offset: 0xE10 */
  __IO uint32_t FIFOINTENCLR;                      /**< FIFO Interrupt Enable Clear and Read, offset: 0xE14 */
  __I  uint32_t FIFOINTSTAT;                       /**< FIFO Interrupt Status, offset: 0xE18 */
       uint8_t RESERVED_4[4];
  __O  uint32_t FIFOWR;                            /**< FIFO Write Data, offset: 0xE20 */
  __O  uint32_t FIFOWR48H;                         /**< FIFO Write Data for Upper Data Bits, offset: 0xE24 */
       uint8_t RESERVED_5[8];
  __I  uint32_t FIFORD;                            /**< FIFO Read Data, offset: 0xE30 */
  __I  uint32_t FIFORD48H;                         /**< FIFO Read Data for Upper Data Bits, offset: 0xE34 */
       uint8_t RESERVED_6[8];
  __I  uint32_t FIFORDNOPOP;                       /**< FIFO Data Read with No FIFO Pop, offset: 0xE40 */
  __I  uint32_t FIFORD48HNOPOP;                    /**< FIFO Data Read for Upper Data Bits with No FIFO Pop, offset: 0xE44 */
  __I  uint32_t FIFOSIZE;                          /**< FIFO Size Register, offset: 0xE48 */
       uint8_t RESERVED_7[432];
  __I  uint32_t ID;                                /**< I2S Module Identification, offset: 0xFFC */
} I2S_Type;

/* ----------------------------------------------------------------------------
   -- I2S Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I2S_Register_Masks I2S Register Masks
 * @{
 */

/*! @name CFG1 - Configuration Register 1 for the Primary Channel Pair */
/*! @{ */
#define I2S_CFG1_MAINENABLE_MASK                 (0x1U)
#define I2S_CFG1_MAINENABLE_SHIFT                (0U)
/*! MAINENABLE - Main Enable
 *  0b0..Disabled. All I2S channel pairs in this Flexcomm are disabled and the internal state machines, counters,
 *       and flags are reset. No other channel pairs can be enabled.
 *  0b1..Enabled. This I2S channel pair is enabled. Other channel pairs in this Flexcomm may be enabled in their individual PAIRENABLE bits.
 */
#define I2S_CFG1_MAINENABLE(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_MAINENABLE_SHIFT)) & I2S_CFG1_MAINENABLE_MASK)
#define I2S_CFG1_DATAPAUSE_MASK                  (0x2U)
#define I2S_CFG1_DATAPAUSE_SHIFT                 (1U)
/*! DATAPAUSE - Data Flow Pause
 *  0b0..Normal operation
 *  0b1..Pause
 */
#define I2S_CFG1_DATAPAUSE(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_DATAPAUSE_SHIFT)) & I2S_CFG1_DATAPAUSE_MASK)
#define I2S_CFG1_PAIRCOUNT_MASK                  (0xCU)
#define I2S_CFG1_PAIRCOUNT_SHIFT                 (2U)
/*! PAIRCOUNT - Pair Count
 *  0b00..1 I2S channel pairs in this Flexcomm module
 *  0b01..2 I2S channel pairs in this Flexcomm module
 *  0b10..3 I2S channel pairs in this Flexcomm module
 *  0b11..4 I2S channel pairs in this Flexcomm module
 */
#define I2S_CFG1_PAIRCOUNT(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_PAIRCOUNT_SHIFT)) & I2S_CFG1_PAIRCOUNT_MASK)
#define I2S_CFG1_MSTSLVCFG_MASK                  (0x30U)
#define I2S_CFG1_MSTSLVCFG_SHIFT                 (4U)
/*! MSTSLVCFG - Master/Slave Configuration Selection
 *  0b00..Normal Slave Mode
 *  0b01..WS Synchronized Master Mode
 *  0b10..Master Using an Existing SCK Mode
 *  0b11..Normal Master Mode
 */
#define I2S_CFG1_MSTSLVCFG(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_MSTSLVCFG_SHIFT)) & I2S_CFG1_MSTSLVCFG_MASK)
#define I2S_CFG1_MODE_MASK                       (0xC0U)
#define I2S_CFG1_MODE_SHIFT                      (6U)
/*! MODE - Mode
 *  0b00..Classic Mode
 *  0b01..DSP mode WS 50% duty cycle
 *  0b10..DSP mode WS 1 clock
 *  0b11..DSP mode WS 1 data
 */
#define I2S_CFG1_MODE(x)                         (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_MODE_SHIFT)) & I2S_CFG1_MODE_MASK)
#define I2S_CFG1_RIGHTLOW_MASK                   (0x100U)
#define I2S_CFG1_RIGHTLOW_SHIFT                  (8U)
/*! RIGHTLOW - Right Channel Low
 *  0b0..Right high. The right channel is taken from the high part of the FIFO data. For example, when data is 16
 *       bits, FIFO bits 31:16 are used for the right channel.
 *  0b1..Right low. The right channel is taken from the low part of the FIFO data. For example, when data is 16
 *       bits, FIFO bits 15:0 are used for the right channel.
 */
#define I2S_CFG1_RIGHTLOW(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_RIGHTLOW_SHIFT)) & I2S_CFG1_RIGHTLOW_MASK)
#define I2S_CFG1_LEFTJUST_MASK                   (0x200U)
#define I2S_CFG1_LEFTJUST_SHIFT                  (9U)
/*! LEFTJUST - Left-Justify Data
 *  0b0..Right-justified. Data is transferred between the FIFO and the I2S serializer/deserializer right
 *       justified, i.e. starting from bit 0 and continuing to the position defined by DATALEN. This corresponds to
 *       right-justified data in the stream on the data bus.
 *  0b1..Left-justified. Data is transferred between the FIFO and the I2S serializer/deserializer left justified,
 *       i.e., starting from the MSB of the FIFO entry and continuing for the number of bits defined by DATALEN.
 *       This corresponds to left-justified data in the stream on the data bus.
 */
#define I2S_CFG1_LEFTJUST(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_LEFTJUST_SHIFT)) & I2S_CFG1_LEFTJUST_MASK)
#define I2S_CFG1_ONECHANNEL_MASK                 (0x400U)
#define I2S_CFG1_ONECHANNEL_SHIFT                (10U)
/*! ONECHANNEL - Single Channel Mode
 *  0b0..Dual channel
 *  0b1..Single channel
 */
#define I2S_CFG1_ONECHANNEL(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_ONECHANNEL_SHIFT)) & I2S_CFG1_ONECHANNEL_MASK)
#define I2S_CFG1_PDMDATA_MASK                    (0x800U)
#define I2S_CFG1_PDMDATA_SHIFT                   (11U)
/*! PDMDATA - PDM Data Selection
 *  0b0..Normal operation. Data is transferred to or from the Flexcomm FIFO.
 *  0b1..DMIC subsystem. The data source is the D-Mic subsystem. When PDMDATA = 1, only the primary channel pair
 *       can be used in this Flexcomm. If ONECHANNEL = 1, only the PDM left data is used. the WS signal rate must
 *       match the Fs (sample rate) of the D-Mic decimator. A rate mismatch will at some point cause the I2S to
 *       overrun or underrun.
 */
#define I2S_CFG1_PDMDATA(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_PDMDATA_SHIFT)) & I2S_CFG1_PDMDATA_MASK)
#define I2S_CFG1_SCK_POL_MASK                    (0x1000U)
#define I2S_CFG1_SCK_POL_SHIFT                   (12U)
/*! SCK_POL - SCK Polarity
 *  0b0..Falling edge. Data is launched on the SCK signal falling edges and sampled on the SCK signal rising edges (standard for I2S).
 *  0b1..Rising edge. Data is launched on the SCK signal rising edges and sampled on the SCK signal falling edges.
 */
#define I2S_CFG1_SCK_POL(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_SCK_POL_SHIFT)) & I2S_CFG1_SCK_POL_MASK)
#define I2S_CFG1_WS_POL_MASK                     (0x2000U)
#define I2S_CFG1_WS_POL_SHIFT                    (13U)
/*! WS_POL - WS Polarity
 *  0b0..Not inverted. Data frames begin at a falling edge of the WS signal (standard for classic I2S).
 *  0b1..Inverted. The WS signal is inverted, resulting in a data frame beginning at a rising edge of the WS
 *       signal (standard for most 'non-classic' variations of I2S).
 */
#define I2S_CFG1_WS_POL(x)                       (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_WS_POL_SHIFT)) & I2S_CFG1_WS_POL_MASK)
#define I2S_CFG1_DATALEN_MASK                    (0x1F0000U)
#define I2S_CFG1_DATALEN_SHIFT                   (16U)
/*! DATALEN - Data Length
 *  0b00011..Data is 4 bits in length.
 *  0b00100..Data is 5 bits in length.
 *  0b00111..Data is 8 bits in length.
 *  0b11110..Data is 31 bits in length.
 *  0b11111..Data is 32 bits in length.
 */
#define I2S_CFG1_DATALEN(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_CFG1_DATALEN_SHIFT)) & I2S_CFG1_DATALEN_MASK)
/*! @} */

/*! @name CFG2 - Configuration Register 2 for the Primary Channel Pair */
/*! @{ */
#define I2S_CFG2_FRAMELEN_MASK                   (0x1FFU)
#define I2S_CFG2_FRAMELEN_SHIFT                  (0U)
/*! FRAMELEN - Frame Length
 *  0b000000011..Frame is 4 bits in total length
 *  0b000000100..Frame is 5 bits in total length
 *  0b111111111..Frame is 512 bits in total length
 */
#define I2S_CFG2_FRAMELEN(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_CFG2_FRAMELEN_SHIFT)) & I2S_CFG2_FRAMELEN_MASK)
#define I2S_CFG2_POSITION_MASK                   (0x1FF0000U)
#define I2S_CFG2_POSITION_SHIFT                  (16U)
/*! POSITION - Data Position
 *  0b000000000..Data begins at bit position 0 (the first bit position) within the frame or WS phase
 *  0b000000001..Data begins at bit position 1 within the frame or WS phase
 *  0b000000010..Data begins at bit position 2 within the frame or WS phase
 */
#define I2S_CFG2_POSITION(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_CFG2_POSITION_SHIFT)) & I2S_CFG2_POSITION_MASK)
/*! @} */

/*! @name STAT - Status Register for the Primary Channel Pair */
/*! @{ */
#define I2S_STAT_BUSY_MASK                       (0x1U)
#define I2S_STAT_BUSY_SHIFT                      (0U)
/*! BUSY - Busy Status
 *  0b0..Idle. The transmitter/receiver for channel pair is currently idle.
 *  0b1..Busy. The transmitter/receiver for channel pair is currently processing data.
 */
#define I2S_STAT_BUSY(x)                         (((uint32_t)(((uint32_t)(x)) << I2S_STAT_BUSY_SHIFT)) & I2S_STAT_BUSY_MASK)
#define I2S_STAT_SLVFRMERR_MASK                  (0x2U)
#define I2S_STAT_SLVFRMERR_SHIFT                 (1U)
/*! SLVFRMERR - Slave Frame Error
 *  0b0..No error. No error has been recorded.
 *  0b1..Error. An error has been recorded for some channel pair that is operating in slave mode. ERROR is cleared
 *       by writing a 1 to this bit position.
 */
#define I2S_STAT_SLVFRMERR(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_STAT_SLVFRMERR_SHIFT)) & I2S_STAT_SLVFRMERR_MASK)
#define I2S_STAT_LR_MASK                         (0x4U)
#define I2S_STAT_LR_SHIFT                        (2U)
/*! LR - Left/Right Indication
 *  0b0..Left channel
 *  0b1..Right channel
 */
#define I2S_STAT_LR(x)                           (((uint32_t)(((uint32_t)(x)) << I2S_STAT_LR_SHIFT)) & I2S_STAT_LR_MASK)
#define I2S_STAT_DATAPAUSED_MASK                 (0x8U)
#define I2S_STAT_DATAPAUSED_SHIFT                (3U)
/*! DATAPAUSED - Data Paused
 *  0b0..Not Paused. Data is not currently paused. A data pause may have been requested but is not yet in force,
 *       waiting for an allowed pause point. Refer to the description of the CFG1[DATAPAUSE] control bit.
 *  0b1..Paused. A data pause has been requested and is now in force.
 */
#define I2S_STAT_DATAPAUSED(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_STAT_DATAPAUSED_SHIFT)) & I2S_STAT_DATAPAUSED_MASK)
/*! @} */

/*! @name DIV - Clock Divider */
/*! @{ */
#define I2S_DIV_DIV_MASK                         (0xFFFU)
#define I2S_DIV_DIV_SHIFT                        (0U)
/*! DIV - Divider
 *  0b000000000000..FCLK is used directly.
 *  0b000000000001..FCLK is divided by 2.
 *  0b000000000010..FCLK is divided by 3.
 *  0b111111111111..FCLK is divided by 4,096.
 */
#define I2S_DIV_DIV(x)                           (((uint32_t)(((uint32_t)(x)) << I2S_DIV_DIV_SHIFT)) & I2S_DIV_DIV_MASK)
/*! @} */

/*! @name SECCHANNEL_PCFG1 - Configuration Register 1 for Channel Pair 1..Configuration Register 1 for Channel Pair 3 */
/*! @{ */
#define I2S_SECCHANNEL_PCFG1_PAIRENABLE_MASK     (0x1U)
#define I2S_SECCHANNEL_PCFG1_PAIRENABLE_SHIFT    (0U)
/*! PAIRENABLE - Pair Enable
 *  0b0..Disabled. This I2S channel pair is disabled.
 *  0b1..Enabled. This I2S channel pair is enabled. Other channel pairs in this Flexcomm module may be enabled in their individual PAIRENABLE bits.
 */
#define I2S_SECCHANNEL_PCFG1_PAIRENABLE(x)       (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PCFG1_PAIRENABLE_SHIFT)) & I2S_SECCHANNEL_PCFG1_PAIRENABLE_MASK)
#define I2S_SECCHANNEL_PCFG1_ONECHANNEL_MASK     (0x400U)
#define I2S_SECCHANNEL_PCFG1_ONECHANNEL_SHIFT    (10U)
/*! ONECHANNEL - Single Channel Mode
 *  0b0..Dual Channel. I2S data for this channel pair is treated as left and right channels.
 *  0b1..Single Channel. I2S data for this channel pair is treated as a single channel, functionally the left channel for this pair.
 */
#define I2S_SECCHANNEL_PCFG1_ONECHANNEL(x)       (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PCFG1_ONECHANNEL_SHIFT)) & I2S_SECCHANNEL_PCFG1_ONECHANNEL_MASK)
/*! @} */

/* The count of I2S_SECCHANNEL_PCFG1 */
#define I2S_SECCHANNEL_PCFG1_COUNT               (3U)

/*! @name SECCHANNEL_PCFG2 - Configuration Register 2 for Channel Pair 1..Configuration Register 2 for Channel Pair 3 */
/*! @{ */
#define I2S_SECCHANNEL_PCFG2_POSITION_MASK       (0x1FF0000U)
#define I2S_SECCHANNEL_PCFG2_POSITION_SHIFT      (16U)
/*! POSITION - Data Position
 */
#define I2S_SECCHANNEL_PCFG2_POSITION(x)         (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PCFG2_POSITION_SHIFT)) & I2S_SECCHANNEL_PCFG2_POSITION_MASK)
/*! @} */

/* The count of I2S_SECCHANNEL_PCFG2 */
#define I2S_SECCHANNEL_PCFG2_COUNT               (3U)

/*! @name SECCHANNEL_PSTAT - Status Register for Channel Pair 1..Status Register for Channel Pair 3 */
/*! @{ */
#define I2S_SECCHANNEL_PSTAT_BUSY_MASK           (0x1U)
#define I2S_SECCHANNEL_PSTAT_BUSY_SHIFT          (0U)
/*! BUSY - Busy Status for Channel Pair
 *  0b0..Idle. The transmitter/receiver for this channel pair is currently idle.
 *  0b1..Busy. The transmitter/receiver for this channel pair is currently processing data.
 */
#define I2S_SECCHANNEL_PSTAT_BUSY(x)             (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PSTAT_BUSY_SHIFT)) & I2S_SECCHANNEL_PSTAT_BUSY_MASK)
#define I2S_SECCHANNEL_PSTAT_SLVFRMERR_MASK      (0x2U)
#define I2S_SECCHANNEL_PSTAT_SLVFRMERR_SHIFT     (1U)
/*! SLVFRMERR - Save Frame Error Flag
 *  0b0..No Error. No error has been recorded.
 *  0b1..Error. An error has been recorded for some channel pair that is operating in slave mode. ERROR is cleared
 *       by writing a 1 to this bit position.
 */
#define I2S_SECCHANNEL_PSTAT_SLVFRMERR(x)        (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PSTAT_SLVFRMERR_SHIFT)) & I2S_SECCHANNEL_PSTAT_SLVFRMERR_MASK)
#define I2S_SECCHANNEL_PSTAT_LR_MASK             (0x4U)
#define I2S_SECCHANNEL_PSTAT_LR_SHIFT            (2U)
/*! LR - Left/Right Indication
 *  0b0..Left channel
 *  0b1..Right channel
 */
#define I2S_SECCHANNEL_PSTAT_LR(x)               (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PSTAT_LR_SHIFT)) & I2S_SECCHANNEL_PSTAT_LR_MASK)
#define I2S_SECCHANNEL_PSTAT_DATAPAUSED_MASK     (0x8U)
#define I2S_SECCHANNEL_PSTAT_DATAPAUSED_SHIFT    (3U)
/*! DATAPAUSED - Data Paused Status Flag
 *  0b0..Data Not Paused. Data is not currently paused. A data pause may have been requested but is not yet in
 *       force, waiting for an allowed pause point. Refer to the description in CFG1[DATAPAUSE].
 *  0b1..Data Paused. A data pause has been requested and is now in force.
 */
#define I2S_SECCHANNEL_PSTAT_DATAPAUSED(x)       (((uint32_t)(((uint32_t)(x)) << I2S_SECCHANNEL_PSTAT_DATAPAUSED_SHIFT)) & I2S_SECCHANNEL_PSTAT_DATAPAUSED_MASK)
/*! @} */

/* The count of I2S_SECCHANNEL_PSTAT */
#define I2S_SECCHANNEL_PSTAT_COUNT               (3U)

/*! @name FIFOCFG - FIFO Configuration and Enable */
/*! @{ */
#define I2S_FIFOCFG_ENABLETX_MASK                (0x1U)
#define I2S_FIFOCFG_ENABLETX_SHIFT               (0U)
/*! ENABLETX
 *  0b0..Disabled Transmit. The transmit FIFO is not enabled.
 *  0b1..Enabled transmit. The transmit FIFO is enabled.
 */
#define I2S_FIFOCFG_ENABLETX(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_ENABLETX_SHIFT)) & I2S_FIFOCFG_ENABLETX_MASK)
#define I2S_FIFOCFG_ENABLERX_MASK                (0x2U)
#define I2S_FIFOCFG_ENABLERX_SHIFT               (1U)
/*! ENABLERX
 *  0b0..Disabled. The receive FIFO is not enabled.
 *  0b1..Enabled. The receive FIFO is enabled.
 */
#define I2S_FIFOCFG_ENABLERX(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_ENABLERX_SHIFT)) & I2S_FIFOCFG_ENABLERX_MASK)
#define I2S_FIFOCFG_TXI2SE0_MASK                 (0x4U)
#define I2S_FIFOCFG_TXI2SE0_SHIFT                (2U)
/*! TXI2SE0
 *  0b0..Last value. If the TX FIFO becomes empty, the last value is sent. This setting may be used when the data
 *       length is 24 bits or less, or when MONO = 1 for this channel pair.
 *  0b1..Zero. If the TX FIFO becomes empty, 0 is sent. Use if the data length is greater than 24 bits or if zero fill is preferred.
 */
#define I2S_FIFOCFG_TXI2SE0(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_TXI2SE0_SHIFT)) & I2S_FIFOCFG_TXI2SE0_MASK)
#define I2S_FIFOCFG_PACK48_MASK                  (0x8U)
#define I2S_FIFOCFG_PACK48_SHIFT                 (3U)
/*! PACK48 - Packing Format 48-bit data
 *  0b0..Bits_24. 48-bit I2S FIFO entries are handled as all 24-bit values.
 *  0b1..Bits_32_16. 48-bit I2S FIFO entries are handled as alternating 32-bit and 16-bit values.
 */
#define I2S_FIFOCFG_PACK48(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_PACK48_SHIFT)) & I2S_FIFOCFG_PACK48_MASK)
#define I2S_FIFOCFG_SIZE_MASK                    (0x30U)
#define I2S_FIFOCFG_SIZE_SHIFT                   (4U)
/*! SIZE - FIFO Size Configuration
 *  0b10..Size 32 Bits. FIFO is configured as 8 entries of 32 bits, each corresponding to 2 16-bit data values for
 *        left and right channels. This setting occurs when the I2S CFG1[DATALEN] value is less than 16 bits, or
 *        from 25 to 32 bits.
 *  0b11..Size 48 Bits. FIFO is configured as 8 entries of 48 bits, each corresponding to 2 24-bit (?) data values
 *        for left and right channels. This setting occurs when the I2S CFG1[DATALEN] value is from 17 to 24 bits.
 */
#define I2S_FIFOCFG_SIZE(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_SIZE_SHIFT)) & I2S_FIFOCFG_SIZE_MASK)
#define I2S_FIFOCFG_DMATX_MASK                   (0x1000U)
#define I2S_FIFOCFG_DMATX_SHIFT                  (12U)
/*! DMATX - DMA Transmit
 *  0b0..Disabled. DMA is not used for the transmit function.
 *  0b1..Enabled. Trigger DMA for the transmit function if the FIFO is not full. Generally, data interrupts would be disabled if DMA is enabled.
 */
#define I2S_FIFOCFG_DMATX(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_DMATX_SHIFT)) & I2S_FIFOCFG_DMATX_MASK)
#define I2S_FIFOCFG_DMARX_MASK                   (0x2000U)
#define I2S_FIFOCFG_DMARX_SHIFT                  (13U)
/*! DMARX - DMA Receive
 *  0b0..Disabled. DMA is not used for the receive function.
 *  0b1..Enabled. Trigger DMA for the receive function if the FIFO is not empty. Generally, data interrupts would be disabled if DMA is enabled.
 */
#define I2S_FIFOCFG_DMARX(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_DMARX_SHIFT)) & I2S_FIFOCFG_DMARX_MASK)
#define I2S_FIFOCFG_WAKETX_MASK                  (0x4000U)
#define I2S_FIFOCFG_WAKETX_SHIFT                 (14U)
/*! WAKETX - Wake-up for Transmit FIFO Level
 *  0b0..Disabled. Only enabled interrupts wake up the device from reduced power modes.
 *  0b1..Enabled. A device wake up for DMA occurs if the transmit FIFO level reaches the value specified by
 *       FIFOTRIG[TXLVL], even when the TXLVL interrupt is not enabled.
 */
#define I2S_FIFOCFG_WAKETX(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_WAKETX_SHIFT)) & I2S_FIFOCFG_WAKETX_MASK)
#define I2S_FIFOCFG_WAKERX_MASK                  (0x8000U)
#define I2S_FIFOCFG_WAKERX_SHIFT                 (15U)
/*! WAKERX - Wake-up for Receive FIFO Level
 *  0b0..Only enabled interrupts wake up the device from reduced power modes.
 *  0b1..A device wake-up for DMA occurs if the receive FIFO level reaches the value specified by FIFOTRIG[RXLVL],
 *       even when the RXLVL interrupt is not enabled.
 */
#define I2S_FIFOCFG_WAKERX(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_WAKERX_SHIFT)) & I2S_FIFOCFG_WAKERX_MASK)
#define I2S_FIFOCFG_EMPTYTX_MASK                 (0x10000U)
#define I2S_FIFOCFG_EMPTYTX_SHIFT                (16U)
#define I2S_FIFOCFG_EMPTYTX(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_EMPTYTX_SHIFT)) & I2S_FIFOCFG_EMPTYTX_MASK)
#define I2S_FIFOCFG_EMPTYRX_MASK                 (0x20000U)
#define I2S_FIFOCFG_EMPTYRX_SHIFT                (17U)
#define I2S_FIFOCFG_EMPTYRX(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_EMPTYRX_SHIFT)) & I2S_FIFOCFG_EMPTYRX_MASK)
#define I2S_FIFOCFG_POPDBG_MASK                  (0x40000U)
#define I2S_FIFOCFG_POPDBG_SHIFT                 (18U)
/*! POPDBG - Pop FIFO for Debug Reads
 *  0b0..Debug reads of the FIFO do not pop the FIFO.
 *  0b1..A debug read causes the FIFO to pop.
 */
#define I2S_FIFOCFG_POPDBG(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOCFG_POPDBG_SHIFT)) & I2S_FIFOCFG_POPDBG_MASK)
/*! @} */

/*! @name FIFOSTAT - FIFO Status */
/*! @{ */
#define I2S_FIFOSTAT_TXERR_MASK                  (0x1U)
#define I2S_FIFOSTAT_TXERR_SHIFT                 (0U)
/*! TXERR - TX FIFO Error
 *  0b0..No transmit FIFO error occured
 *  0b1..Transmit FIFO error occured
 */
#define I2S_FIFOSTAT_TXERR(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXERR_SHIFT)) & I2S_FIFOSTAT_TXERR_MASK)
#define I2S_FIFOSTAT_RXERR_MASK                  (0x2U)
#define I2S_FIFOSTAT_RXERR_SHIFT                 (1U)
/*! RXERR - RX FIFO Error
 *  0b0..No receive FIFO error occured
 *  0b1..Receive FIFO error occured
 */
#define I2S_FIFOSTAT_RXERR(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXERR_SHIFT)) & I2S_FIFOSTAT_RXERR_MASK)
#define I2S_FIFOSTAT_PERINT_MASK                 (0x8U)
#define I2S_FIFOSTAT_PERINT_SHIFT                (3U)
/*! PERINT - Peripheral Interrupt
 *  0b0..No interrupt
 *  0b1..Interrupt
 */
#define I2S_FIFOSTAT_PERINT(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_PERINT_SHIFT)) & I2S_FIFOSTAT_PERINT_MASK)
#define I2S_FIFOSTAT_TXEMPTY_MASK                (0x10U)
#define I2S_FIFOSTAT_TXEMPTY_SHIFT               (4U)
/*! TXEMPTY - Transmit FIFO Empty
 *  0b0..Transmit FIFO is not empty
 *  0b1..Transmit FIFO is empty; however, the peripheral may still be processing the last piece of data.
 */
#define I2S_FIFOSTAT_TXEMPTY(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXEMPTY_SHIFT)) & I2S_FIFOSTAT_TXEMPTY_MASK)
#define I2S_FIFOSTAT_TXNOTFULL_MASK              (0x20U)
#define I2S_FIFOSTAT_TXNOTFULL_SHIFT             (5U)
/*! TXNOTFULL - Transmit FIFO Not Full
 *  0b0..Transmit FIFO is full, and another write would cause an overflow
 *  0b1..Transmit FIFO is not full, so more data can be written
 */
#define I2S_FIFOSTAT_TXNOTFULL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXNOTFULL_SHIFT)) & I2S_FIFOSTAT_TXNOTFULL_MASK)
#define I2S_FIFOSTAT_RXNOTEMPTY_MASK             (0x40U)
#define I2S_FIFOSTAT_RXNOTEMPTY_SHIFT            (6U)
/*! RXNOTEMPTY - Receive FIFO Not Empty
 *  0b0..Receive FIFO is empty
 *  0b1..Receive FIFO is not empty, so data can be read.
 */
#define I2S_FIFOSTAT_RXNOTEMPTY(x)               (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXNOTEMPTY_SHIFT)) & I2S_FIFOSTAT_RXNOTEMPTY_MASK)
#define I2S_FIFOSTAT_RXFULL_MASK                 (0x80U)
#define I2S_FIFOSTAT_RXFULL_SHIFT                (7U)
/*! RXFULL - Receive FIFO Full
 *  0b0..Receive FIFO is not full
 *  0b1..Receive FIFO is full
 */
#define I2S_FIFOSTAT_RXFULL(x)                   (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXFULL_SHIFT)) & I2S_FIFOSTAT_RXFULL_MASK)
#define I2S_FIFOSTAT_TXLVL_MASK                  (0x1F00U)
#define I2S_FIFOSTAT_TXLVL_SHIFT                 (8U)
/*! TXLVL - Transmit FIFO Current Level
 *  0b00000..TX FIFO is empty
 */
#define I2S_FIFOSTAT_TXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_TXLVL_SHIFT)) & I2S_FIFOSTAT_TXLVL_MASK)
#define I2S_FIFOSTAT_RXLVL_MASK                  (0x1F0000U)
#define I2S_FIFOSTAT_RXLVL_SHIFT                 (16U)
/*! RXLVL - Receive FIFO Current Level
 *  0b00000..RX FIFO is empty
 */
#define I2S_FIFOSTAT_RXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSTAT_RXLVL_SHIFT)) & I2S_FIFOSTAT_RXLVL_MASK)
/*! @} */

/*! @name FIFOTRIG - FIFO Trigger Settings */
/*! @{ */
#define I2S_FIFOTRIG_TXLVLENA_MASK               (0x1U)
#define I2S_FIFOTRIG_TXLVLENA_SHIFT              (0U)
/*! TXLVLENA - Transmit FIFO Level Trigger Enable
 *  0b0..Transmit FIFO level does not generate a FIFO level trigger.
 *  0b1..An trigger generates if the transmit FIFO level reaches the value specified by the TXLVL field in this register.
 */
#define I2S_FIFOTRIG_TXLVLENA(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_TXLVLENA_SHIFT)) & I2S_FIFOTRIG_TXLVLENA_MASK)
#define I2S_FIFOTRIG_RXLVLENA_MASK               (0x2U)
#define I2S_FIFOTRIG_RXLVLENA_SHIFT              (1U)
/*! RXLVLENA - Receive FIFO Level Trigger Enable
 *  0b0..Receive FIFO level does not generate a FIFO level trigger.
 *  0b1..An trigger generates if the receive FIFO level reaches the value specified by the RXLVL.
 */
#define I2S_FIFOTRIG_RXLVLENA(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_RXLVLENA_SHIFT)) & I2S_FIFOTRIG_RXLVLENA_MASK)
#define I2S_FIFOTRIG_TXLVL_MASK                  (0xF00U)
#define I2S_FIFOTRIG_TXLVL_SHIFT                 (8U)
/*! TXLVL - Transmit FIFO Level Trigger Point
 *  0b0000..Trigger when the TX FIFO becomes empty.
 *  0b0001..Trigger when the TX FIFO level decreases to one entry.
 *  0b1111..Trigger when the TX FIFO level decreases to 15 entries (is no longer full).
 */
#define I2S_FIFOTRIG_TXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_TXLVL_SHIFT)) & I2S_FIFOTRIG_TXLVL_MASK)
#define I2S_FIFOTRIG_RXLVL_MASK                  (0xF0000U)
#define I2S_FIFOTRIG_RXLVL_SHIFT                 (16U)
/*! RXLVL - Receive FIFO Level Trigger Point
 *  0b0000..Trigger when the RX FIFO has received 1 entry (the FIFO is no longer empty).
 *  0b0001..Trigger when the RX FIFO has received 2 entries.
 *  0b1111..Trigger when the RX FIFO has received 16 entries (the FIFO has become full).
 */
#define I2S_FIFOTRIG_RXLVL(x)                    (((uint32_t)(((uint32_t)(x)) << I2S_FIFOTRIG_RXLVL_SHIFT)) & I2S_FIFOTRIG_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTENSET - FIFO Interrupt Enable Set and Read */
/*! @{ */
#define I2S_FIFOINTENSET_TXERR_MASK              (0x1U)
#define I2S_FIFOINTENSET_TXERR_SHIFT             (0U)
/*! TXERR - Transmit Error Interrupt
 *  0b0..Disabled. No interrupt generates for a transmit error.
 *  0b1..Enabled. An interrupt generates when a transmit error occurs.
 */
#define I2S_FIFOINTENSET_TXERR(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_TXERR_SHIFT)) & I2S_FIFOINTENSET_TXERR_MASK)
#define I2S_FIFOINTENSET_RXERR_MASK              (0x2U)
#define I2S_FIFOINTENSET_RXERR_SHIFT             (1U)
/*! RXERR - Receive Error Interrupt
 *  0b0..Disabled. No interrupt generates for a receive error.
 *  0b1..Enabled. An interrupt generates when a receive error occurs.
 */
#define I2S_FIFOINTENSET_RXERR(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_RXERR_SHIFT)) & I2S_FIFOINTENSET_RXERR_MASK)
#define I2S_FIFOINTENSET_TXLVL_MASK              (0x4U)
#define I2S_FIFOINTENSET_TXLVL_SHIFT             (2U)
/*! TXLVL - Transmit Level Interrupt
 *  0b0..Disabled. No interrupt generates based on the TX FIFO level.
 *  0b1..Enabled. If FIFOTRIG[TXLVLENA] = 1, an interrupt generates when the TX FIFO level decreases to the level
 *       specified by the FIFOTRIG[TXLVL] flag.
 */
#define I2S_FIFOINTENSET_TXLVL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_TXLVL_SHIFT)) & I2S_FIFOINTENSET_TXLVL_MASK)
#define I2S_FIFOINTENSET_RXLVL_MASK              (0x8U)
#define I2S_FIFOINTENSET_RXLVL_SHIFT             (3U)
/*! RXLVL - Receive Level Interrupt
 *  0b0..Disabled. No interrupt generates based on the RX FIFO level.
 *  0b1..Enabled. If FIFOTRIG[RXLVLENA] = 1, an interrupt generates when the RX FIFO level increases to the level specified by FIFOTRIG[RXLVL].
 */
#define I2S_FIFOINTENSET_RXLVL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENSET_RXLVL_SHIFT)) & I2S_FIFOINTENSET_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTENCLR - FIFO Interrupt Enable Clear and Read */
/*! @{ */
#define I2S_FIFOINTENCLR_TXERR_MASK              (0x1U)
#define I2S_FIFOINTENCLR_TXERR_SHIFT             (0U)
/*! TXERR - Transmit Error Interrupt Clear
 *  0b0..Interrupt is not cleared.
 *  0b1..Interrupt is cleared.
 */
#define I2S_FIFOINTENCLR_TXERR(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_TXERR_SHIFT)) & I2S_FIFOINTENCLR_TXERR_MASK)
#define I2S_FIFOINTENCLR_RXERR_MASK              (0x2U)
#define I2S_FIFOINTENCLR_RXERR_SHIFT             (1U)
/*! RXERR - Receive Error Interrupt Clear
 *  0b0..Interrupt is not cleared.
 *  0b1..Interrupt is cleared.
 */
#define I2S_FIFOINTENCLR_RXERR(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_RXERR_SHIFT)) & I2S_FIFOINTENCLR_RXERR_MASK)
#define I2S_FIFOINTENCLR_TXLVL_MASK              (0x4U)
#define I2S_FIFOINTENCLR_TXLVL_SHIFT             (2U)
/*! TXLVL - Transmit Level Interrupt Clear
 *  0b0..Interrupt is not cleared.
 *  0b1..Interrupt is cleared.
 */
#define I2S_FIFOINTENCLR_TXLVL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_TXLVL_SHIFT)) & I2S_FIFOINTENCLR_TXLVL_MASK)
#define I2S_FIFOINTENCLR_RXLVL_MASK              (0x8U)
#define I2S_FIFOINTENCLR_RXLVL_SHIFT             (3U)
/*! RXLVL - Receive Level Interrupt Clear
 *  0b0..Interrupt is not cleared.
 *  0b1..Interrupt is cleared.
 */
#define I2S_FIFOINTENCLR_RXLVL(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTENCLR_RXLVL_SHIFT)) & I2S_FIFOINTENCLR_RXLVL_MASK)
/*! @} */

/*! @name FIFOINTSTAT - FIFO Interrupt Status */
/*! @{ */
#define I2S_FIFOINTSTAT_TXERR_MASK               (0x1U)
#define I2S_FIFOINTSTAT_TXERR_SHIFT              (0U)
/*! TXERR - TX FIFO Error Interrupt Status
 *  0b0..Not pending
 *  0b1..Pending
 */
#define I2S_FIFOINTSTAT_TXERR(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_TXERR_SHIFT)) & I2S_FIFOINTSTAT_TXERR_MASK)
#define I2S_FIFOINTSTAT_RXERR_MASK               (0x2U)
#define I2S_FIFOINTSTAT_RXERR_SHIFT              (1U)
/*! RXERR - RX FIFO Error Interrupt Status
 *  0b0..Not pending
 *  0b1..Pending
 */
#define I2S_FIFOINTSTAT_RXERR(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_RXERR_SHIFT)) & I2S_FIFOINTSTAT_RXERR_MASK)
#define I2S_FIFOINTSTAT_TXLVL_MASK               (0x4U)
#define I2S_FIFOINTSTAT_TXLVL_SHIFT              (2U)
/*! TXLVL - Transmit FIFO Level Interrupt Status
 *  0b0..Not pending
 *  0b1..Pending
 */
#define I2S_FIFOINTSTAT_TXLVL(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_TXLVL_SHIFT)) & I2S_FIFOINTSTAT_TXLVL_MASK)
#define I2S_FIFOINTSTAT_RXLVL_MASK               (0x8U)
#define I2S_FIFOINTSTAT_RXLVL_SHIFT              (3U)
/*! RXLVL - Receive FIFO Level Interrupt Status
 *  0b0..Not pending
 *  0b1..Pending
 */
#define I2S_FIFOINTSTAT_RXLVL(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_RXLVL_SHIFT)) & I2S_FIFOINTSTAT_RXLVL_MASK)
#define I2S_FIFOINTSTAT_PERINT_MASK              (0x10U)
#define I2S_FIFOINTSTAT_PERINT_SHIFT             (4U)
/*! PERINT - Peripheral Interrupt Status
 *  0b0..Not pending
 *  0b1..Pending
 */
#define I2S_FIFOINTSTAT_PERINT(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFOINTSTAT_PERINT_SHIFT)) & I2S_FIFOINTSTAT_PERINT_MASK)
/*! @} */

/*! @name FIFOWR - FIFO Write Data */
/*! @{ */
#define I2S_FIFOWR_TXDATA_MASK                   (0xFFFFFFFFU)
#define I2S_FIFOWR_TXDATA_SHIFT                  (0U)
/*! TXDATA - Transmit Data to the FIFO
 */
#define I2S_FIFOWR_TXDATA(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_FIFOWR_TXDATA_SHIFT)) & I2S_FIFOWR_TXDATA_MASK)
/*! @} */

/*! @name FIFOWR48H - FIFO Write Data for Upper Data Bits */
/*! @{ */
#define I2S_FIFOWR48H_TXDATA_MASK                (0xFFFFFFU)
#define I2S_FIFOWR48H_TXDATA_SHIFT               (0U)
/*! TXDATA - Transmit Data to the FIFO
 */
#define I2S_FIFOWR48H_TXDATA(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFOWR48H_TXDATA_SHIFT)) & I2S_FIFOWR48H_TXDATA_MASK)
/*! @} */

/*! @name FIFORD - FIFO Read Data */
/*! @{ */
#define I2S_FIFORD_RXDATA_MASK                   (0xFFFFFFFFU)
#define I2S_FIFORD_RXDATA_SHIFT                  (0U)
/*! RXDATA - Received Data from the FIFO
 */
#define I2S_FIFORD_RXDATA(x)                     (((uint32_t)(((uint32_t)(x)) << I2S_FIFORD_RXDATA_SHIFT)) & I2S_FIFORD_RXDATA_MASK)
/*! @} */

/*! @name FIFORD48H - FIFO Read Data for Upper Data Bits */
/*! @{ */
#define I2S_FIFORD48H_RXDATA_MASK                (0xFFFFFFU)
#define I2S_FIFORD48H_RXDATA_SHIFT               (0U)
/*! RXDATA - Received Data from the FIFO
 */
#define I2S_FIFORD48H_RXDATA(x)                  (((uint32_t)(((uint32_t)(x)) << I2S_FIFORD48H_RXDATA_SHIFT)) & I2S_FIFORD48H_RXDATA_MASK)
/*! @} */

/*! @name FIFORDNOPOP - FIFO Data Read with No FIFO Pop */
/*! @{ */
#define I2S_FIFORDNOPOP_RXDATA_MASK              (0xFFFFFFFFU)
#define I2S_FIFORDNOPOP_RXDATA_SHIFT             (0U)
/*! RXDATA - Received Data from the FIFO
 */
#define I2S_FIFORDNOPOP_RXDATA(x)                (((uint32_t)(((uint32_t)(x)) << I2S_FIFORDNOPOP_RXDATA_SHIFT)) & I2S_FIFORDNOPOP_RXDATA_MASK)
/*! @} */

/*! @name FIFORD48HNOPOP - FIFO Data Read for Upper Data Bits with No FIFO Pop */
/*! @{ */
#define I2S_FIFORD48HNOPOP_RXDATA_MASK           (0xFFFFFFU)
#define I2S_FIFORD48HNOPOP_RXDATA_SHIFT          (0U)
/*! RXDATA - Received Data from the FIFO
 */
#define I2S_FIFORD48HNOPOP_RXDATA(x)             (((uint32_t)(((uint32_t)(x)) << I2S_FIFORD48HNOPOP_RXDATA_SHIFT)) & I2S_FIFORD48HNOPOP_RXDATA_MASK)
/*! @} */

/*! @name FIFOSIZE - FIFO Size Register */
/*! @{ */
#define I2S_FIFOSIZE_FIFOSIZE_MASK               (0x1FU)
#define I2S_FIFOSIZE_FIFOSIZE_SHIFT              (0U)
#define I2S_FIFOSIZE_FIFOSIZE(x)                 (((uint32_t)(((uint32_t)(x)) << I2S_FIFOSIZE_FIFOSIZE_SHIFT)) & I2S_FIFOSIZE_FIFOSIZE_MASK)
/*! @} */

/*! @name ID - I2S Module Identification */
/*! @{ */
#define I2S_ID_APERTURE_MASK                     (0xFFU)
#define I2S_ID_APERTURE_SHIFT                    (0U)
/*! APERTURE - Aperture
 */
#define I2S_ID_APERTURE(x)                       (((uint32_t)(((uint32_t)(x)) << I2S_ID_APERTURE_SHIFT)) & I2S_ID_APERTURE_MASK)
#define I2S_ID_MINOR_REV_MASK                    (0xF00U)
#define I2S_ID_MINOR_REV_SHIFT                   (8U)
/*! MINOR_REV - Minor Revision
 */
#define I2S_ID_MINOR_REV(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_ID_MINOR_REV_SHIFT)) & I2S_ID_MINOR_REV_MASK)
#define I2S_ID_MAJOR_REV_MASK                    (0xF000U)
#define I2S_ID_MAJOR_REV_SHIFT                   (12U)
/*! MAJOR_REV - Major Revision
 */
#define I2S_ID_MAJOR_REV(x)                      (((uint32_t)(((uint32_t)(x)) << I2S_ID_MAJOR_REV_SHIFT)) & I2S_ID_MAJOR_REV_MASK)
#define I2S_ID_ID_MASK                           (0xFFFF0000U)
#define I2S_ID_ID_SHIFT                          (16U)
/*! ID - Module Identifier
 */
#define I2S_ID_ID(x)                             (((uint32_t)(((uint32_t)(x)) << I2S_ID_ID_SHIFT)) & I2S_ID_ID_MASK)
/*! @} */


/*!
 * @}
 */ /* end of group I2S_Register_Masks */


/* I2S - Peripheral instance base addresses */
/** Peripheral I2S0 base address */
#define I2S0_BASE                                (0x40106000u)
/** Peripheral I2S0 base pointer */
#define I2S0                                     ((I2S_Type *)I2S0_BASE)
/** Peripheral I2S1 base address */
#define I2S1_BASE                                (0x40107000u)
/** Peripheral I2S1 base pointer */
#define I2S1                                     ((I2S_Type *)I2S1_BASE)
/** Peripheral I2S2 base address */
#define I2S2_BASE                                (0x40108000u)
/** Peripheral I2S2 base pointer */
#define I2S2                                     ((I2S_Type *)I2S2_BASE)
/** Peripheral I2S3 base address */
#define I2S3_BASE                                (0x40109000u)
/** Peripheral I2S3 base pointer */
#define I2S3                                     ((I2S_Type *)I2S3_BASE)
/** Peripheral I2S4 base address */
#define I2S4_BASE                                (0x40122000u)
/** Peripheral I2S4 base pointer */
#define I2S4                                     ((I2S_Type *)I2S4_BASE)
/** Peripheral I2S5 base address */
#define I2S5_BASE                                (0x40123000u)
/** Peripheral I2S5 base pointer */
#define I2S5                                     ((I2S_Type *)I2S5_BASE)
/** Peripheral I2S6 base address */
#define I2S6_BASE                                (0x40124000u)
/** Peripheral I2S6 base pointer */
#define I2S6                                     ((I2S_Type *)I2S6_BASE)
/** Peripheral I2S7 base address */
#define I2S7_BASE                                (0x40125000u)
/** Peripheral I2S7 base pointer */
#define I2S7                                     ((I2S_Type *)I2S7_BASE)
/** Peripheral I2S8 base address */
#define I2S8_BASE                                (0x40209000u)
/** Peripheral I2S8 base pointer */
#define I2S8                                     ((I2S_Type *)I2S8_BASE)
/** Peripheral I2S9 base address */
#define I2S9_BASE                                (0x4020A000u)
/** Peripheral I2S9 base pointer */
#define I2S9                                     ((I2S_Type *)I2S9_BASE)
/** Peripheral I2S10 base address */
#define I2S10_BASE                               (0x4020B000u)
/** Peripheral I2S10 base pointer */
#define I2S10                                    ((I2S_Type *)I2S10_BASE)
/** Peripheral I2S11 base address */
#define I2S11_BASE                               (0x4020C000u)
/** Peripheral I2S11 base pointer */
#define I2S11                                    ((I2S_Type *)I2S11_BASE)
/** Peripheral I2S12 base address */
#define I2S12_BASE                               (0x4020D000u)
/** Peripheral I2S12 base pointer */
#define I2S12                                    ((I2S_Type *)I2S12_BASE)
/** Peripheral I2S13 base address */
#define I2S13_BASE                               (0x4020E000u)
/** Peripheral I2S13 base pointer */
#define I2S13                                    ((I2S_Type *)I2S13_BASE)
/** Array initializer of I2S peripheral base addresses */
#define I2S_BASE_ADDRS                           { I2S0_BASE, I2S1_BASE, I2S2_BASE, I2S3_BASE, I2S4_BASE, I2S5_BASE, I2S6_BASE, I2S7_BASE, I2S8_BASE, I2S9_BASE, I2S10_BASE, I2S11_BASE, I2S12_BASE, I2S13_BASE }
/** Array initializer of I2S peripheral base pointers */
#define I2S_BASE_PTRS                            { I2S0, I2S1, I2S2, I2S3, I2S4, I2S5, I2S6, I2S7, I2S8, I2S9, I2S10, I2S11, I2S12, I2S13 }
/** Interrupt vectors for the I2S peripheral type */
#define I2S_IRQS                                 { FLEXCOMM0_IRQn, FLEXCOMM1_IRQn, FLEXCOMM2_IRQn, FLEXCOMM3_IRQn, FLEXCOMM4_IRQn, FLEXCOMM5_IRQn, FLEXCOMM6_IRQn, FLEXCOMM7_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn, NotAvail_IRQn }

/*!
 * @}
 */ /* end of group I2S_Peripheral_Access_Layer */


/* ----------------------------------------------------------------------------
   -- I3C Peripheral Access Layer
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I3C_Peripheral_Access_Layer I3C Peripheral Access Layer
 * @{
 */

/** I3C - Register Layout Typedef */
typedef struct {
  __IO uint32_t MCONFIG;                           /**< Master Configuration Register, offset: 0x0 */
  __IO uint32_t SCONFIG;                           /**< Slave Configuration Register, offset: 0x4 */
  __IO uint32_t SSTATUS;                           /**< Slave Status Register, offset: 0x8 */
  __IO uint32_t SCTRL;                             /**< Slave Control Register, offset: 0xC */
  __IO uint32_t SINTSET;                           /**< Slave Interrupt Set Register, offset: 0x10 */
  __IO uint32_t SINTCLR;                           /**< Slave Interrupt Clear Register, offset: 0x14 */
  __I  uint32_t SINTMASKED;                        /**< Slave Interrupt Mask Register, offset: 0x18 */
  __IO uint32_t SERRWARN;                          /**< Slave Errors and Warnings Register, offset: 0x1C */
  __IO uint32_t SDMACTRL;                          /**< Slave DMA Control Register, offset: 0x20 */
       uint8_t RESERVED_0[8];
  __IO uint32_t SDATACTRL;                         /**< Slave Data Control Register, offset: 0x2C */
  __O  uint32_t SWDATAB;                           /**< Slave Write Data Byte Register, offset: 0x30 */
  __O  uint32_t SWDATABE;                          /**< Slave Write Data Byte End, offset: 0x34 */
  __O  uint32_t SWDATAH;                           /**< Slave Write Data Half-word Register, offset: 0x38 */
  __O  uint32_t SWDATAHE;                          /**< Slave Write Data Half-word End Register, offset: 0x3C */
  __I  uint32_t SRDATAB;                           /**< Slave Read Data Byte Register, offset: 0x40 */
       uint8_t RESERVED_1[4];
  __I  uint32_t SRDATAH;                           /**< Slave Read Data Half-word Register, offset: 0x48 */
       uint8_t RESERVED_2[20];
  __I  uint32_t SCAPABILITIES;                     /**< Slave Capabilities Register, offset: 0x60 */
  __IO uint32_t SDYNADDR;                          /**< Slave Dynamic Address Register, offset: 0x64 */
  __IO uint32_t SMAXLIMITS;                        /**< Slave Maximum Limits Register, offset: 0x68 */
  __IO uint32_t SIDPARTNO;                         /**< Slave ID Part Number Register, offset: 0x6C */
  __IO uint32_t SIDEXT;                            /**< Slave ID Extension Register, offset: 0x70 */
  __IO uint32_t SVENDORID;                         /**< Slave Vendor ID Register, offset: 0x74 */
  __IO uint32_t STCCLOCK;                          /**< Slave Time Control Clock Register, offset: 0x78 */
  __I  uint32_t SMSGMAPADDR;                       /**< Slave Message-Mapped Address Register, offset: 0x7C */
       uint8_t RESERVED_3[4];
  __IO uint32_t MCTRL;                             /**< Master Main Control Register, offset: 0x84 */
  __IO uint32_t MSTATUS;                           /**< Master Status Register, offset: 0x88 */
  __IO uint32_t MIBIRULES;                         /**< Master In-band Interrupt Registry and Rules Register, offset: 0x8C */
  __IO uint32_t MINTSET;                           /**< Master Interrupt Set Register, offset: 0x90 */
  __O  uint32_t MINTCLR;                           /**< Master Interrupt Clear Register, offset: 0x94 */
  __I  uint32_t MINTMASKED;                        /**< Master Interrupt Mask Register, offset: 0x98 */
  __IO uint32_t MERRWARN;                          /**< Master Errors and Warnings Register, offset: 0x9C */
  __IO uint32_t MDMACTRL;                          /**< Master DMA Control Register, offset: 0xA0 */
       uint8_t RESERVED_4[8];
  __IO uint32_t MDATACTRL;                         /**< Master Data Control Register, offset: 0xAC */
  __O  uint32_t MWDATAB;                           /**< Master Write Data Byte Register, offset: 0xB0 */
  __O  uint32_t MWDATABE;                          /**< Master Write Data Byte End Register, offset: 0xB4 */
  __O  uint32_t MWDATAH;                           /**< Master Write Data Half-word Register, offset: 0xB8 */
  __O  uint32_t MWDATAHE;                          /**< Master Write Data Byte End Register, offset: 0xBC */
  __I  uint32_t MRDATAB;                           /**< Master Read Data Byte Register, offset: 0xC0 */
       uint8_t RESERVED_5[4];
  __I  uint32_t MRDATAH;                           /**< Master Read Data Half-word Register, offset: 0xC8 */
       uint8_t RESERVED_6[4];
  union {                                          /* offset: 0xD0 */
    __O  uint32_t MWMSG_SDR_CONTROL;                 /**< Master Write Message in SDR mode, offset: 0xD0 */
    __O  uint32_t MWMSG_SDR_DATA;                    /**< Master Write Message Data in SDR mode, offset: 0xD0 */
  };
  __I  uint32_t MRMSG_SDR;                         /**< Master Read Message in SDR mode, offset: 0xD4 */
  union {                                          /* offset: 0xD8 */
    __O  uint32_t MWMSG_DDR_CONTROL;                 /**< Master Write Message in DDR mode, offset: 0xD8 */
    __O  uint32_t MWMSG_DDR_DATA;                    /**< Master Write Message Data in DDR mode, offset: 0xD8 */
  };
  __IO uint32_t MRMSG_DDR;                         /**< Master Read Message in DDR mode, offset: 0xDC */
       uint8_t RESERVED_7[4];
  __IO uint32_t MDYNADDR;                          /**< Master Dynamic Address Register, offset: 0xE4 */
       uint8_t RESERVED_8[3860];
  __I  uint32_t SID;                               /**< Slave Module ID Register, offset: 0xFFC */
} I3C_Type;

/* ----------------------------------------------------------------------------
   -- I3C Register Masks
   ---------------------------------------------------------------------------- */

/*!
 * @addtogroup I3C_Register_Masks I3C Register Masks
 * @{
 */

/*! @name MCONFIG - Master Configuration Register */
/*! @{ */
#define I3C_MCONFIG_MSTENA_MASK                  (0x3U)
#define I3C_MCONFIG_MSTENA_SHIFT                 (0U)
/*! MSTENA - Master enable
 *  0b00..MASTER_OFF: Master is off (is not enabled). If MASTER_OFF is enabled, then the I3C module can only use slave mode.
 *  0b01..MASTER_ON: Master is on (is enabled). When used from start-up, this I3C module is master by default (the
 *        main master). The module will control the bus unless the master is handed off. If the master is handed
 *        off, then MSTENA must move to 2 after that happens. The handoff means emitting GETACCMST and if accepted,
 *        the module will emit a STOP and set the MSTENA bit to 2 (or 0).
 *  0b10..MASTER_CAPABLE: The I3C module is master-capable; however the module is operating as a slave now. When
 *        used from the start, the I3C module will start as a slave, but will be prepared to switch to master mode.
 *        To switch to master mode, the slave emits an Master Request (MR), or gets a GETACCMST CCC command and
 *        accepts it (to switch on the STOP).
 *  0b11..RESERVED
 */
#define I3C_MCONFIG_MSTENA(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_MSTENA_SHIFT)) & I3C_MCONFIG_MSTENA_MASK)
#define I3C_MCONFIG_DISTO_MASK                   (0x8U)
#define I3C_MCONFIG_DISTO_SHIFT                  (3U)
/*! DISTO - Disable Timeout
 */
#define I3C_MCONFIG_DISTO(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_DISTO_SHIFT)) & I3C_MCONFIG_DISTO_MASK)
#define I3C_MCONFIG_HKEEP_MASK                   (0x30U)
#define I3C_MCONFIG_HKEEP_SHIFT                  (4U)
/*! HKEEP - High-Keeper
 *  0b00..NONE: Use PUR (Pull-Up Resistor). Hold SCL High.
 *  0b01..WIRED_IN: Wired-in High Keeper controls; use pin_HK (High Keeper) controls.
 *  0b10..PASSIVE_SDA: Passive on SDA; can Hi-Z (high impedance) for Bus Free (IDLE) and hold.
 *  0b11..PASSIVE_ON_SDA_SCL: Passive on SDA and SCL; can Hi-Z (high impedance) both for Bus Free (IDLE), and can Hi-Z SDA for hold.
 */
#define I3C_MCONFIG_HKEEP(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_HKEEP_SHIFT)) & I3C_MCONFIG_HKEEP_MASK)
#define I3C_MCONFIG_ODSTOP_MASK                  (0x40U)
#define I3C_MCONFIG_ODSTOP_SHIFT                 (6U)
/*! ODSTOP - Open drain stop
 */
#define I3C_MCONFIG_ODSTOP(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_ODSTOP_SHIFT)) & I3C_MCONFIG_ODSTOP_MASK)
#define I3C_MCONFIG_PPBAUD_MASK                  (0xF00U)
#define I3C_MCONFIG_PPBAUD_SHIFT                 (8U)
/*! PPBAUD - Push-pull baud rate
 */
#define I3C_MCONFIG_PPBAUD(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_PPBAUD_SHIFT)) & I3C_MCONFIG_PPBAUD_MASK)
#define I3C_MCONFIG_PPLOW_MASK                   (0xF000U)
#define I3C_MCONFIG_PPLOW_SHIFT                  (12U)
/*! PPLOW - Push-Pull low
 */
#define I3C_MCONFIG_PPLOW(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_PPLOW_SHIFT)) & I3C_MCONFIG_PPLOW_MASK)
#define I3C_MCONFIG_ODBAUD_MASK                  (0xFF0000U)
#define I3C_MCONFIG_ODBAUD_SHIFT                 (16U)
/*! ODBAUD - Open drain baud rate
 */
#define I3C_MCONFIG_ODBAUD(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_ODBAUD_SHIFT)) & I3C_MCONFIG_ODBAUD_MASK)
#define I3C_MCONFIG_ODHPP_MASK                   (0x1000000U)
#define I3C_MCONFIG_ODHPP_SHIFT                  (24U)
/*! ODHPP - Open drain high push-pull
 */
#define I3C_MCONFIG_ODHPP(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_ODHPP_SHIFT)) & I3C_MCONFIG_ODHPP_MASK)
#define I3C_MCONFIG_SKEW_MASK                    (0xE000000U)
#define I3C_MCONFIG_SKEW_SHIFT                   (25U)
/*! SKEW - Skew
 */
#define I3C_MCONFIG_SKEW(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_SKEW_SHIFT)) & I3C_MCONFIG_SKEW_MASK)
#define I3C_MCONFIG_I2CBAUD_MASK                 (0xF0000000U)
#define I3C_MCONFIG_I2CBAUD_SHIFT                (28U)
/*! I2CBAUD - I2C baud rate
 */
#define I3C_MCONFIG_I2CBAUD(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MCONFIG_I2CBAUD_SHIFT)) & I3C_MCONFIG_I2CBAUD_MASK)
/*! @} */

/*! @name SCONFIG - Slave Configuration Register */
/*! @{ */
#define I3C_SCONFIG_SLVENA_MASK                  (0x1U)
#define I3C_SCONFIG_SLVENA_SHIFT                 (0U)
/*! SLVENA - Slave enable
 */
#define I3C_SCONFIG_SLVENA(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_SLVENA_SHIFT)) & I3C_SCONFIG_SLVENA_MASK)
#define I3C_SCONFIG_NACK_MASK                    (0x2U)
#define I3C_SCONFIG_NACK_SHIFT                   (1U)
/*! NACK - Not acknowledge
 */
#define I3C_SCONFIG_NACK(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_NACK_SHIFT)) & I3C_SCONFIG_NACK_MASK)
#define I3C_SCONFIG_MATCHSS_MASK                 (0x4U)
#define I3C_SCONFIG_MATCHSS_SHIFT                (2U)
/*! MATCHSS - Match START or STOP
 */
#define I3C_SCONFIG_MATCHSS(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_MATCHSS_SHIFT)) & I3C_SCONFIG_MATCHSS_MASK)
#define I3C_SCONFIG_S0IGNORE_MASK                (0x8U)
#define I3C_SCONFIG_S0IGNORE_SHIFT               (3U)
/*! S0IGNORE - S0/S1 errors ignore
 */
#define I3C_SCONFIG_S0IGNORE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_S0IGNORE_SHIFT)) & I3C_SCONFIG_S0IGNORE_MASK)
#define I3C_SCONFIG_DDROK_MASK                   (0x10U)
#define I3C_SCONFIG_DDROK_SHIFT                  (4U)
/*! DDROK - Double Data Rate OK
 */
#define I3C_SCONFIG_DDROK(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_DDROK_SHIFT)) & I3C_SCONFIG_DDROK_MASK)
#define I3C_SCONFIG_IDRAND_MASK                  (0x100U)
#define I3C_SCONFIG_IDRAND_SHIFT                 (8U)
/*! IDRAND - ID random
 */
#define I3C_SCONFIG_IDRAND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_IDRAND_SHIFT)) & I3C_SCONFIG_IDRAND_MASK)
#define I3C_SCONFIG_OFFLINE_MASK                 (0x200U)
#define I3C_SCONFIG_OFFLINE_SHIFT                (9U)
/*! OFFLINE - Offline
 */
#define I3C_SCONFIG_OFFLINE(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_OFFLINE_SHIFT)) & I3C_SCONFIG_OFFLINE_MASK)
#define I3C_SCONFIG_BAMATCH_MASK                 (0xFF0000U)
#define I3C_SCONFIG_BAMATCH_SHIFT                (16U)
/*! BAMATCH - Bus available match
 */
#define I3C_SCONFIG_BAMATCH(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_BAMATCH_SHIFT)) & I3C_SCONFIG_BAMATCH_MASK)
#define I3C_SCONFIG_SADDR_MASK                   (0xFE000000U)
#define I3C_SCONFIG_SADDR_SHIFT                  (25U)
/*! SADDR - Static address
 */
#define I3C_SCONFIG_SADDR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SCONFIG_SADDR_SHIFT)) & I3C_SCONFIG_SADDR_MASK)
/*! @} */

/*! @name SSTATUS - Slave Status Register */
/*! @{ */
#define I3C_SSTATUS_STNOTSTOP_MASK               (0x1U)
#define I3C_SSTATUS_STNOTSTOP_SHIFT              (0U)
/*! STNOTSTOP - Status not stop
 */
#define I3C_SSTATUS_STNOTSTOP(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STNOTSTOP_SHIFT)) & I3C_SSTATUS_STNOTSTOP_MASK)
#define I3C_SSTATUS_STMSG_MASK                   (0x2U)
#define I3C_SSTATUS_STMSG_SHIFT                  (1U)
/*! STMSG - Status message
 */
#define I3C_SSTATUS_STMSG(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STMSG_SHIFT)) & I3C_SSTATUS_STMSG_MASK)
#define I3C_SSTATUS_STCCCH_MASK                  (0x4U)
#define I3C_SSTATUS_STCCCH_SHIFT                 (2U)
/*! STCCCH - Status Common Command Code Handler
 */
#define I3C_SSTATUS_STCCCH(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STCCCH_SHIFT)) & I3C_SSTATUS_STCCCH_MASK)
#define I3C_SSTATUS_STREQRD_MASK                 (0x8U)
#define I3C_SSTATUS_STREQRD_SHIFT                (3U)
/*! STREQRD - Status required
 */
#define I3C_SSTATUS_STREQRD(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STREQRD_SHIFT)) & I3C_SSTATUS_STREQRD_MASK)
#define I3C_SSTATUS_STREQWR_MASK                 (0x10U)
#define I3C_SSTATUS_STREQWR_SHIFT                (4U)
/*! STREQWR - Status request write
 */
#define I3C_SSTATUS_STREQWR(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STREQWR_SHIFT)) & I3C_SSTATUS_STREQWR_MASK)
#define I3C_SSTATUS_STDAA_MASK                   (0x20U)
#define I3C_SSTATUS_STDAA_SHIFT                  (5U)
/*! STDAA - Status Dynamic Address Assignment
 */
#define I3C_SSTATUS_STDAA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STDAA_SHIFT)) & I3C_SSTATUS_STDAA_MASK)
#define I3C_SSTATUS_STHDR_MASK                   (0x40U)
#define I3C_SSTATUS_STHDR_SHIFT                  (6U)
/*! STHDR - Status High Data Rate
 */
#define I3C_SSTATUS_STHDR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STHDR_SHIFT)) & I3C_SSTATUS_STHDR_MASK)
#define I3C_SSTATUS_START_MASK                   (0x100U)
#define I3C_SSTATUS_START_SHIFT                  (8U)
/*! START - Start
 */
#define I3C_SSTATUS_START(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_START_SHIFT)) & I3C_SSTATUS_START_MASK)
#define I3C_SSTATUS_MATCHED_MASK                 (0x200U)
#define I3C_SSTATUS_MATCHED_SHIFT                (9U)
/*! MATCHED - Matched
 */
#define I3C_SSTATUS_MATCHED(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_MATCHED_SHIFT)) & I3C_SSTATUS_MATCHED_MASK)
#define I3C_SSTATUS_STOP_MASK                    (0x400U)
#define I3C_SSTATUS_STOP_SHIFT                   (10U)
/*! STOP - Stop
 */
#define I3C_SSTATUS_STOP(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_STOP_SHIFT)) & I3C_SSTATUS_STOP_MASK)
#define I3C_SSTATUS_RX_PEND_MASK                 (0x800U)
#define I3C_SSTATUS_RX_PEND_SHIFT                (11U)
/*! RX_PEND - Received message pending
 */
#define I3C_SSTATUS_RX_PEND(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_RX_PEND_SHIFT)) & I3C_SSTATUS_RX_PEND_MASK)
#define I3C_SSTATUS_TXNOTFULL_MASK               (0x1000U)
#define I3C_SSTATUS_TXNOTFULL_SHIFT              (12U)
/*! TXNOTFULL - Transmit buffer is not full
 */
#define I3C_SSTATUS_TXNOTFULL(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_TXNOTFULL_SHIFT)) & I3C_SSTATUS_TXNOTFULL_MASK)
#define I3C_SSTATUS_DACHG_MASK                   (0x2000U)
#define I3C_SSTATUS_DACHG_SHIFT                  (13U)
/*! DACHG - DACHG
 */
#define I3C_SSTATUS_DACHG(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_DACHG_SHIFT)) & I3C_SSTATUS_DACHG_MASK)
#define I3C_SSTATUS_CCC_MASK                     (0x4000U)
#define I3C_SSTATUS_CCC_SHIFT                    (14U)
/*! CCC - Common Command Code
 */
#define I3C_SSTATUS_CCC(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_CCC_SHIFT)) & I3C_SSTATUS_CCC_MASK)
#define I3C_SSTATUS_ERRWARN_MASK                 (0x8000U)
#define I3C_SSTATUS_ERRWARN_SHIFT                (15U)
/*! ERRWARN - Error warning
 */
#define I3C_SSTATUS_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_ERRWARN_SHIFT)) & I3C_SSTATUS_ERRWARN_MASK)
#define I3C_SSTATUS_HDRMATCH_MASK                (0x10000U)
#define I3C_SSTATUS_HDRMATCH_SHIFT               (16U)
/*! HDRMATCH - High Data Rate command match
 */
#define I3C_SSTATUS_HDRMATCH(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_HDRMATCH_SHIFT)) & I3C_SSTATUS_HDRMATCH_MASK)
#define I3C_SSTATUS_CHANDLED_MASK                (0x20000U)
#define I3C_SSTATUS_CHANDLED_SHIFT               (17U)
/*! CHANDLED - Common-Command-Code handled
 */
#define I3C_SSTATUS_CHANDLED(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_CHANDLED_SHIFT)) & I3C_SSTATUS_CHANDLED_MASK)
#define I3C_SSTATUS_EVENT_MASK                   (0x40000U)
#define I3C_SSTATUS_EVENT_SHIFT                  (18U)
/*! EVENT - Event
 */
#define I3C_SSTATUS_EVENT(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_EVENT_SHIFT)) & I3C_SSTATUS_EVENT_MASK)
#define I3C_SSTATUS_EVDET_MASK                   (0x300000U)
#define I3C_SSTATUS_EVDET_SHIFT                  (20U)
/*! EVDET - Event details
 *  0b00..NONE: no event or no pending event
 *  0b01..NO_REQUEST: Request not sent yet. Either there was no START yet, or is waiting for Bus-Available or Bus-Idle (HJ).
 *  0b10..NACKED: Not acknowledged(Request sent and NACKed); the module will try again.
 *  0b11..ACKED: Acknowledged (Request sent and ACKed), so Done (unless the time control data is still being sent).
 */
#define I3C_SSTATUS_EVDET(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_EVDET_SHIFT)) & I3C_SSTATUS_EVDET_MASK)
#define I3C_SSTATUS_IBIDIS_MASK                  (0x1000000U)
#define I3C_SSTATUS_IBIDIS_SHIFT                 (24U)
/*! IBIDIS - In-Band Interrupts are disabled
 */
#define I3C_SSTATUS_IBIDIS(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_IBIDIS_SHIFT)) & I3C_SSTATUS_IBIDIS_MASK)
#define I3C_SSTATUS_MRDIS_MASK                   (0x2000000U)
#define I3C_SSTATUS_MRDIS_SHIFT                  (25U)
/*! MRDIS - Master requests are disabled
 */
#define I3C_SSTATUS_MRDIS(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_MRDIS_SHIFT)) & I3C_SSTATUS_MRDIS_MASK)
#define I3C_SSTATUS_HJDIS_MASK                   (0x8000000U)
#define I3C_SSTATUS_HJDIS_SHIFT                  (27U)
/*! HJDIS - Hot-Join is disabled
 */
#define I3C_SSTATUS_HJDIS(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_HJDIS_SHIFT)) & I3C_SSTATUS_HJDIS_MASK)
#define I3C_SSTATUS_ACTSTATE_MASK                (0x30000000U)
#define I3C_SSTATUS_ACTSTATE_SHIFT               (28U)
/*! ACTSTATE - Activity state from Common Command Codes (CCC)
 *  0b00..NO_LATENCY: normal bus operations
 *  0b01..LATENCY_1MS: 1 ms of latency
 *  0b10..LATENCY_100MS: 100 ms of latency
 *  0b11..LATENCY_10S: 10 seconds of latency
 */
#define I3C_SSTATUS_ACTSTATE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_ACTSTATE_SHIFT)) & I3C_SSTATUS_ACTSTATE_MASK)
#define I3C_SSTATUS_TIMECTRL_MASK                (0xC0000000U)
#define I3C_SSTATUS_TIMECTRL_SHIFT               (30U)
/*! TIMECTRL - Time control
 *  0b00..NO_TIME_CONTROL: No time control is enabled
 *  0b01..Reserved
 *  0b10..ASYNC_MODE: Asynchronous standard mode (0) is enabled
 *  0b11..RESERVED
 */
#define I3C_SSTATUS_TIMECTRL(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SSTATUS_TIMECTRL_SHIFT)) & I3C_SSTATUS_TIMECTRL_MASK)
/*! @} */

/*! @name SCTRL - Slave Control Register */
/*! @{ */
#define I3C_SCTRL_EVENT_MASK                     (0x3U)
#define I3C_SCTRL_EVENT_SHIFT                    (0U)
/*! EVENT - EVENT
 *  0b00..NORMAL_MODE: If EVENT is set to 0 after was a non-0 value, event processing will cancel if the event
 *        processing has not yet started; if event processing has already been started, then event processing will not
 *        be be cancelled.
 *  0b01..IBI: Start an In-Band Interrupt. This will try to push an IBI interrupt onto the I3C bus. If data is
 *        associated with the IBI, then the data will be read from the SCTRL.IBIDATA field. If time control is
 *        enabled, then this data will also include any time control-related bytes; additionally, the IBIDATA byte will
 *        have bit 7 set to 1 automatically (as is required for time control). The IBI interrupt will occur after the
 *        1st (mandatory) IBIDATA, if any.
 *  0b10..MASTER_REQUEST: Start a Master-Request.
 *  0b11..HOT_JOIN_REQUEST: Start a Hot-Join request. A Hot-Join Request should only be used when the device is
 *        powered on after the I3C bus is already powered up, or when the device is connected using hot insertion
 *        methods (the device is powered up when it is physically inserted onto the powered-up I3C bus). The hot join
 *        will wait for Bus Idle, and SCTRL.EVENT=HOT_JOIN_REQUEST must be set before the slave enable
 *        (SCONFIG.SLVENA).
 */
#define I3C_SCTRL_EVENT(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_EVENT_SHIFT)) & I3C_SCTRL_EVENT_MASK)
#define I3C_SCTRL_IBIDATA_MASK                   (0xFF00U)
#define I3C_SCTRL_IBIDATA_SHIFT                  (8U)
/*! IBIDATA - In-Band Interrupt data
 */
#define I3C_SCTRL_IBIDATA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_IBIDATA_SHIFT)) & I3C_SCTRL_IBIDATA_MASK)
#define I3C_SCTRL_PENDINT_MASK                   (0xF0000U)
#define I3C_SCTRL_PENDINT_SHIFT                  (16U)
/*! PENDINT - Pending interrupt
 */
#define I3C_SCTRL_PENDINT(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_PENDINT_SHIFT)) & I3C_SCTRL_PENDINT_MASK)
#define I3C_SCTRL_ACTSTATE_MASK                  (0x300000U)
#define I3C_SCTRL_ACTSTATE_SHIFT                 (20U)
/*! ACTSTATE - Activity state (of slave)
 */
#define I3C_SCTRL_ACTSTATE(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_ACTSTATE_SHIFT)) & I3C_SCTRL_ACTSTATE_MASK)
#define I3C_SCTRL_VENDINFO_MASK                  (0xFF000000U)
#define I3C_SCTRL_VENDINFO_SHIFT                 (24U)
/*! VENDINFO - Vendor information
 */
#define I3C_SCTRL_VENDINFO(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SCTRL_VENDINFO_SHIFT)) & I3C_SCTRL_VENDINFO_MASK)
/*! @} */

/*! @name SINTSET - Slave Interrupt Set Register */
/*! @{ */
#define I3C_SINTSET_START_MASK                   (0x100U)
#define I3C_SINTSET_START_SHIFT                  (8U)
/*! START - Start interrupt enable
 */
#define I3C_SINTSET_START(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_START_SHIFT)) & I3C_SINTSET_START_MASK)
#define I3C_SINTSET_MATCHED_MASK                 (0x200U)
#define I3C_SINTSET_MATCHED_SHIFT                (9U)
/*! MATCHED - Match interrupt enable
 */
#define I3C_SINTSET_MATCHED(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_MATCHED_SHIFT)) & I3C_SINTSET_MATCHED_MASK)
#define I3C_SINTSET_STOP_MASK                    (0x400U)
#define I3C_SINTSET_STOP_SHIFT                   (10U)
/*! STOP - Stop interrupt enable
 */
#define I3C_SINTSET_STOP(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_STOP_SHIFT)) & I3C_SINTSET_STOP_MASK)
#define I3C_SINTSET_RXPEND_MASK                  (0x800U)
#define I3C_SINTSET_RXPEND_SHIFT                 (11U)
/*! RXPEND - Receive interrupt enable
 */
#define I3C_SINTSET_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_RXPEND_SHIFT)) & I3C_SINTSET_RXPEND_MASK)
#define I3C_SINTSET_TXSEND_MASK                  (0x1000U)
#define I3C_SINTSET_TXSEND_SHIFT                 (12U)
/*! TXSEND - Transmit interrupt enable
 */
#define I3C_SINTSET_TXSEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_TXSEND_SHIFT)) & I3C_SINTSET_TXSEND_MASK)
#define I3C_SINTSET_DACHG_MASK                   (0x2000U)
#define I3C_SINTSET_DACHG_SHIFT                  (13U)
/*! DACHG - Dynamic address change interrupt enable
 */
#define I3C_SINTSET_DACHG(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_DACHG_SHIFT)) & I3C_SINTSET_DACHG_MASK)
#define I3C_SINTSET_CCC_MASK                     (0x4000U)
#define I3C_SINTSET_CCC_SHIFT                    (14U)
/*! CCC - Common Command Code (CCC) (that was not handled by I3C module) interrupt enable
 */
#define I3C_SINTSET_CCC(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_CCC_SHIFT)) & I3C_SINTSET_CCC_MASK)
#define I3C_SINTSET_ERRWARN_MASK                 (0x8000U)
#define I3C_SINTSET_ERRWARN_SHIFT                (15U)
/*! ERRWARN - Error/warning interrupt enable
 */
#define I3C_SINTSET_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_ERRWARN_SHIFT)) & I3C_SINTSET_ERRWARN_MASK)
#define I3C_SINTSET_DDRMATCHED_MASK              (0x10000U)
#define I3C_SINTSET_DDRMATCHED_SHIFT             (16U)
/*! DDRMATCHED - Double Data Rate (DDR) interrupt enable
 */
#define I3C_SINTSET_DDRMATCHED(x)                (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_DDRMATCHED_SHIFT)) & I3C_SINTSET_DDRMATCHED_MASK)
#define I3C_SINTSET_CHANDLED_MASK                (0x20000U)
#define I3C_SINTSET_CHANDLED_SHIFT               (17U)
/*! CHANDLED - Common Command Code (CCC) (that was handled by I3C module) interrupt enable
 */
#define I3C_SINTSET_CHANDLED(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_CHANDLED_SHIFT)) & I3C_SINTSET_CHANDLED_MASK)
#define I3C_SINTSET_EVENT_MASK                   (0x40000U)
#define I3C_SINTSET_EVENT_SHIFT                  (18U)
/*! EVENT - Event interrupt enable
 */
#define I3C_SINTSET_EVENT(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTSET_EVENT_SHIFT)) & I3C_SINTSET_EVENT_MASK)
/*! @} */

/*! @name SINTCLR - Slave Interrupt Clear Register */
/*! @{ */
#define I3C_SINTCLR_START_MASK                   (0x100U)
#define I3C_SINTCLR_START_SHIFT                  (8U)
/*! START - START interrupt enable clear
 */
#define I3C_SINTCLR_START(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_START_SHIFT)) & I3C_SINTCLR_START_MASK)
#define I3C_SINTCLR_MATCHED_MASK                 (0x200U)
#define I3C_SINTCLR_MATCHED_SHIFT                (9U)
/*! MATCHED - MATCHED interrupt enable clear
 */
#define I3C_SINTCLR_MATCHED(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_MATCHED_SHIFT)) & I3C_SINTCLR_MATCHED_MASK)
#define I3C_SINTCLR_STOP_MASK                    (0x400U)
#define I3C_SINTCLR_STOP_SHIFT                   (10U)
/*! STOP - STOP interrupt enable clear
 */
#define I3C_SINTCLR_STOP(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_STOP_SHIFT)) & I3C_SINTCLR_STOP_MASK)
#define I3C_SINTCLR_RXPEND_MASK                  (0x800U)
#define I3C_SINTCLR_RXPEND_SHIFT                 (11U)
/*! RXPEND - RXPEND interrupt enable clear
 */
#define I3C_SINTCLR_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_RXPEND_SHIFT)) & I3C_SINTCLR_RXPEND_MASK)
#define I3C_SINTCLR_TXSEND_MASK                  (0x1000U)
#define I3C_SINTCLR_TXSEND_SHIFT                 (12U)
/*! TXSEND - TXSEND interrupt enable clear
 */
#define I3C_SINTCLR_TXSEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_TXSEND_SHIFT)) & I3C_SINTCLR_TXSEND_MASK)
#define I3C_SINTCLR_DACHG_MASK                   (0x2000U)
#define I3C_SINTCLR_DACHG_SHIFT                  (13U)
/*! DACHG - DACHG interrupt enable clear
 */
#define I3C_SINTCLR_DACHG(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_DACHG_SHIFT)) & I3C_SINTCLR_DACHG_MASK)
#define I3C_SINTCLR_CCC_MASK                     (0x4000U)
#define I3C_SINTCLR_CCC_SHIFT                    (14U)
/*! CCC - CCC interrupt enable clear
 */
#define I3C_SINTCLR_CCC(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_CCC_SHIFT)) & I3C_SINTCLR_CCC_MASK)
#define I3C_SINTCLR_ERRWARN_MASK                 (0x8000U)
#define I3C_SINTCLR_ERRWARN_SHIFT                (15U)
/*! ERRWARN - ERRWARN interrupt enable clear
 */
#define I3C_SINTCLR_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_ERRWARN_SHIFT)) & I3C_SINTCLR_ERRWARN_MASK)
#define I3C_SINTCLR_DDRMATCHED_MASK              (0x10000U)
#define I3C_SINTCLR_DDRMATCHED_SHIFT             (16U)
/*! DDRMATCHED - DDRMATCHED interrupt enable clear
 */
#define I3C_SINTCLR_DDRMATCHED(x)                (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_DDRMATCHED_SHIFT)) & I3C_SINTCLR_DDRMATCHED_MASK)
#define I3C_SINTCLR_CHANDLED_MASK                (0x20000U)
#define I3C_SINTCLR_CHANDLED_SHIFT               (17U)
/*! CHANDLED - CHANDLED interrupt enable clear
 */
#define I3C_SINTCLR_CHANDLED(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_CHANDLED_SHIFT)) & I3C_SINTCLR_CHANDLED_MASK)
#define I3C_SINTCLR_EVENT_MASK                   (0x40000U)
#define I3C_SINTCLR_EVENT_SHIFT                  (18U)
/*! EVENT - EVENT interrupt enable clear
 */
#define I3C_SINTCLR_EVENT(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SINTCLR_EVENT_SHIFT)) & I3C_SINTCLR_EVENT_MASK)
/*! @} */

/*! @name SINTMASKED - Slave Interrupt Mask Register */
/*! @{ */
#define I3C_SINTMASKED_START_MASK                (0x100U)
#define I3C_SINTMASKED_START_SHIFT               (8U)
/*! START - START interrupt mask
 */
#define I3C_SINTMASKED_START(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_START_SHIFT)) & I3C_SINTMASKED_START_MASK)
#define I3C_SINTMASKED_MATCHED_MASK              (0x200U)
#define I3C_SINTMASKED_MATCHED_SHIFT             (9U)
/*! MATCHED - MATCHED interrupt mask
 */
#define I3C_SINTMASKED_MATCHED(x)                (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_MATCHED_SHIFT)) & I3C_SINTMASKED_MATCHED_MASK)
#define I3C_SINTMASKED_STOP_MASK                 (0x400U)
#define I3C_SINTMASKED_STOP_SHIFT                (10U)
/*! STOP - STOP interrupt mask
 */
#define I3C_SINTMASKED_STOP(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_STOP_SHIFT)) & I3C_SINTMASKED_STOP_MASK)
#define I3C_SINTMASKED_RXPEND_MASK               (0x800U)
#define I3C_SINTMASKED_RXPEND_SHIFT              (11U)
/*! RXPEND - RXPEND interrupt mask
 */
#define I3C_SINTMASKED_RXPEND(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_RXPEND_SHIFT)) & I3C_SINTMASKED_RXPEND_MASK)
#define I3C_SINTMASKED_TXSEND_MASK               (0x1000U)
#define I3C_SINTMASKED_TXSEND_SHIFT              (12U)
/*! TXSEND - TXSEND interrupt mask
 */
#define I3C_SINTMASKED_TXSEND(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_TXSEND_SHIFT)) & I3C_SINTMASKED_TXSEND_MASK)
#define I3C_SINTMASKED_DACHG_MASK                (0x2000U)
#define I3C_SINTMASKED_DACHG_SHIFT               (13U)
/*! DACHG - DACHG interrupt mask
 */
#define I3C_SINTMASKED_DACHG(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_DACHG_SHIFT)) & I3C_SINTMASKED_DACHG_MASK)
#define I3C_SINTMASKED_CCC_MASK                  (0x4000U)
#define I3C_SINTMASKED_CCC_SHIFT                 (14U)
/*! CCC - CCC interrupt mask
 */
#define I3C_SINTMASKED_CCC(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_CCC_SHIFT)) & I3C_SINTMASKED_CCC_MASK)
#define I3C_SINTMASKED_ERRWARN_MASK              (0x8000U)
#define I3C_SINTMASKED_ERRWARN_SHIFT             (15U)
/*! ERRWARN - ERRWARN interrupt mask
 */
#define I3C_SINTMASKED_ERRWARN(x)                (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_ERRWARN_SHIFT)) & I3C_SINTMASKED_ERRWARN_MASK)
#define I3C_SINTMASKED_DDRMATCHED_MASK           (0x10000U)
#define I3C_SINTMASKED_DDRMATCHED_SHIFT          (16U)
/*! DDRMATCHED - DDRMATCHED interrupt mask
 */
#define I3C_SINTMASKED_DDRMATCHED(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_DDRMATCHED_SHIFT)) & I3C_SINTMASKED_DDRMATCHED_MASK)
#define I3C_SINTMASKED_CHANDLED_MASK             (0x20000U)
#define I3C_SINTMASKED_CHANDLED_SHIFT            (17U)
/*! CHANDLED - CHANDLED interrupt mask
 */
#define I3C_SINTMASKED_CHANDLED(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_CHANDLED_SHIFT)) & I3C_SINTMASKED_CHANDLED_MASK)
#define I3C_SINTMASKED_EVENT_MASK                (0x40000U)
#define I3C_SINTMASKED_EVENT_SHIFT               (18U)
/*! EVENT - EVENT interrupt mask
 */
#define I3C_SINTMASKED_EVENT(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SINTMASKED_EVENT_SHIFT)) & I3C_SINTMASKED_EVENT_MASK)
/*! @} */

/*! @name SERRWARN - Slave Errors and Warnings Register */
/*! @{ */
#define I3C_SERRWARN_ORUN_MASK                   (0x1U)
#define I3C_SERRWARN_ORUN_SHIFT                  (0U)
/*! ORUN - Overrun error
 */
#define I3C_SERRWARN_ORUN(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_ORUN_SHIFT)) & I3C_SERRWARN_ORUN_MASK)
#define I3C_SERRWARN_URUN_MASK                   (0x2U)
#define I3C_SERRWARN_URUN_SHIFT                  (1U)
/*! URUN - Underrun error
 */
#define I3C_SERRWARN_URUN(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_URUN_SHIFT)) & I3C_SERRWARN_URUN_MASK)
#define I3C_SERRWARN_URUNNACK_MASK               (0x4U)
#define I3C_SERRWARN_URUNNACK_SHIFT              (2U)
/*! URUNNACK - Underrun and Not Acknowledged (NACKed) error
 */
#define I3C_SERRWARN_URUNNACK(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_URUNNACK_SHIFT)) & I3C_SERRWARN_URUNNACK_MASK)
#define I3C_SERRWARN_TERM_MASK                   (0x8U)
#define I3C_SERRWARN_TERM_SHIFT                  (3U)
/*! TERM - Terminated error
 */
#define I3C_SERRWARN_TERM(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_TERM_SHIFT)) & I3C_SERRWARN_TERM_MASK)
#define I3C_SERRWARN_INVSTART_MASK               (0x10U)
#define I3C_SERRWARN_INVSTART_SHIFT              (4U)
/*! INVSTART - Invalid start error
 */
#define I3C_SERRWARN_INVSTART(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_INVSTART_SHIFT)) & I3C_SERRWARN_INVSTART_MASK)
#define I3C_SERRWARN_SPAR_MASK                   (0x100U)
#define I3C_SERRWARN_SPAR_SHIFT                  (8U)
/*! SPAR - SDR parity error
 */
#define I3C_SERRWARN_SPAR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_SPAR_SHIFT)) & I3C_SERRWARN_SPAR_MASK)
#define I3C_SERRWARN_HPAR_MASK                   (0x200U)
#define I3C_SERRWARN_HPAR_SHIFT                  (9U)
/*! HPAR - HDR parity error
 */
#define I3C_SERRWARN_HPAR(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_HPAR_SHIFT)) & I3C_SERRWARN_HPAR_MASK)
#define I3C_SERRWARN_HCRC_MASK                   (0x400U)
#define I3C_SERRWARN_HCRC_SHIFT                  (10U)
/*! HCRC - HDR-DDR CRC error
 */
#define I3C_SERRWARN_HCRC(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_HCRC_SHIFT)) & I3C_SERRWARN_HCRC_MASK)
#define I3C_SERRWARN_S0S1_MASK                   (0x800U)
#define I3C_SERRWARN_S0S1_SHIFT                  (11U)
/*! S0S1 - S0 or S1 error
 */
#define I3C_SERRWARN_S0S1(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_S0S1_SHIFT)) & I3C_SERRWARN_S0S1_MASK)
#define I3C_SERRWARN_OREAD_MASK                  (0x10000U)
#define I3C_SERRWARN_OREAD_SHIFT                 (16U)
/*! OREAD - Over-read error
 */
#define I3C_SERRWARN_OREAD(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_OREAD_SHIFT)) & I3C_SERRWARN_OREAD_MASK)
#define I3C_SERRWARN_OWRITE_MASK                 (0x20000U)
#define I3C_SERRWARN_OWRITE_SHIFT                (17U)
/*! OWRITE - Over-write error
 */
#define I3C_SERRWARN_OWRITE(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SERRWARN_OWRITE_SHIFT)) & I3C_SERRWARN_OWRITE_MASK)
/*! @} */

/*! @name SDMACTRL - Slave DMA Control Register */
/*! @{ */
#define I3C_SDMACTRL_DMAFB_MASK                  (0x3U)
#define I3C_SDMACTRL_DMAFB_SHIFT                 (0U)
/*! DMAFB - DMA Read (From-bus) trigger
 *  0b00..DMA not used
 *  0b01..DMA is enabled for 1 frame
 *  0b10..DMA enable
 */
#define I3C_SDMACTRL_DMAFB(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SDMACTRL_DMAFB_SHIFT)) & I3C_SDMACTRL_DMAFB_MASK)
#define I3C_SDMACTRL_DMATB_MASK                  (0xCU)
#define I3C_SDMACTRL_DMATB_SHIFT                 (2U)
/*! DMATB - DMA Write (To-bus) trigger
 *  0b00..NOT_USED: DMA is not used
 *  0b01..ENABLE_ONE_FRAME: DMA is enabled for 1 Frame (ended by DMA or terminated). DMATB auto-clears on a STOP
 *        or START (see the Match START or STOP bit (SCONFIG.MATCHSS).
 *  0b10..ENABLE: DMA is enabled until turned off. Normally, ENABLE should only be used with Master Message mode.
 */
#define I3C_SDMACTRL_DMATB(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SDMACTRL_DMATB_SHIFT)) & I3C_SDMACTRL_DMATB_MASK)
#define I3C_SDMACTRL_DMAWIDTH_MASK               (0x30U)
#define I3C_SDMACTRL_DMAWIDTH_SHIFT              (4U)
/*! DMAWIDTH - Width of DMA operations
 *  0b00..BYTE
 *  0b01..BYTE_AGAIN
 *  0b10..HALF_WORD: Half word (16 bits). This will make sure that 2 bytes are free/available in the FIFO.
 *  0b11..RESERVED
 */
#define I3C_SDMACTRL_DMAWIDTH(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDMACTRL_DMAWIDTH_SHIFT)) & I3C_SDMACTRL_DMAWIDTH_MASK)
/*! @} */

/*! @name SDATACTRL - Slave Data Control Register */
/*! @{ */
#define I3C_SDATACTRL_FLUSHTB_MASK               (0x1U)
#define I3C_SDATACTRL_FLUSHTB_SHIFT              (0U)
/*! FLUSHTB - Flush the to-bus buffer/FIFO
 */
#define I3C_SDATACTRL_FLUSHTB(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_FLUSHTB_SHIFT)) & I3C_SDATACTRL_FLUSHTB_MASK)
#define I3C_SDATACTRL_FLUSHFB_MASK               (0x2U)
#define I3C_SDATACTRL_FLUSHFB_SHIFT              (1U)
/*! FLUSHFB - Flushes the from-bus buffer/FIFO
 */
#define I3C_SDATACTRL_FLUSHFB(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_FLUSHFB_SHIFT)) & I3C_SDATACTRL_FLUSHFB_MASK)
#define I3C_SDATACTRL_UNLOCK_MASK                (0x8U)
#define I3C_SDATACTRL_UNLOCK_SHIFT               (3U)
/*! UNLOCK - Unlock
 */
#define I3C_SDATACTRL_UNLOCK(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_UNLOCK_SHIFT)) & I3C_SDATACTRL_UNLOCK_MASK)
#define I3C_SDATACTRL_TXTRIG_MASK                (0x30U)
#define I3C_SDATACTRL_TXTRIG_SHIFT               (4U)
/*! TXTRIG - Trigger level for TX FIFO emptiness
 *  0b00..Trigger on empty
 *  0b01..Trigger on ¼ full or less
 *  0b10..Trigger on .5 full or less
 *  0b11..Trigger on 1 less than full or less (Default)
 */
#define I3C_SDATACTRL_TXTRIG(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_TXTRIG_SHIFT)) & I3C_SDATACTRL_TXTRIG_MASK)
#define I3C_SDATACTRL_RXTRIG_MASK                (0xC0U)
#define I3C_SDATACTRL_RXTRIG_SHIFT               (6U)
/*! RXTRIG - Trigger level for RX FIFO fullness
 *  0b00..Trigger on not empty
 *  0b01..Trigger on ¼ or more full
 *  0b10..Trigger on .5 or more full
 *  0b11..Trigger on 3/4 or more full
 */
#define I3C_SDATACTRL_RXTRIG(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_RXTRIG_SHIFT)) & I3C_SDATACTRL_RXTRIG_MASK)
#define I3C_SDATACTRL_TXCOUNT_MASK               (0x1F0000U)
#define I3C_SDATACTRL_TXCOUNT_SHIFT              (16U)
/*! TXCOUNT - Count of bytes in TX
 */
#define I3C_SDATACTRL_TXCOUNT(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_TXCOUNT_SHIFT)) & I3C_SDATACTRL_TXCOUNT_MASK)
#define I3C_SDATACTRL_RXCOUNT_MASK               (0x1F000000U)
#define I3C_SDATACTRL_RXCOUNT_SHIFT              (24U)
/*! RXCOUNT - Count of bytes in RX
 */
#define I3C_SDATACTRL_RXCOUNT(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_RXCOUNT_SHIFT)) & I3C_SDATACTRL_RXCOUNT_MASK)
#define I3C_SDATACTRL_TXFULL_MASK                (0x40000000U)
#define I3C_SDATACTRL_TXFULL_SHIFT               (30U)
/*! TXFULL - TX is full
 *  0b1..TX is full
 *  0b0..TX is not full
 */
#define I3C_SDATACTRL_TXFULL(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_TXFULL_SHIFT)) & I3C_SDATACTRL_TXFULL_MASK)
#define I3C_SDATACTRL_RXEMPTY_MASK               (0x80000000U)
#define I3C_SDATACTRL_RXEMPTY_SHIFT              (31U)
/*! RXEMPTY - RX is empty
 *  0b1..RX is empty
 *  0b0..RX is not empty
 */
#define I3C_SDATACTRL_RXEMPTY(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SDATACTRL_RXEMPTY_SHIFT)) & I3C_SDATACTRL_RXEMPTY_MASK)
/*! @} */

/*! @name SWDATAB - Slave Write Data Byte Register */
/*! @{ */
#define I3C_SWDATAB_DATA_MASK                    (0xFFU)
#define I3C_SWDATAB_DATA_SHIFT                   (0U)
/*! DATA - The data byte to send to the master
 */
#define I3C_SWDATAB_DATA(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAB_DATA_SHIFT)) & I3C_SWDATAB_DATA_MASK)
#define I3C_SWDATAB_END_MASK                     (0x100U)
#define I3C_SWDATAB_END_SHIFT                    (8U)
/*! END - End
 */
#define I3C_SWDATAB_END(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAB_END_SHIFT)) & I3C_SWDATAB_END_MASK)
#define I3C_SWDATAB_END_ALSO_MASK                (0x10000U)
#define I3C_SWDATAB_END_ALSO_SHIFT               (16U)
/*! END_ALSO - End also
 */
#define I3C_SWDATAB_END_ALSO(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAB_END_ALSO_SHIFT)) & I3C_SWDATAB_END_ALSO_MASK)
/*! @} */

/*! @name SWDATABE - Slave Write Data Byte End */
/*! @{ */
#define I3C_SWDATABE_DATA_MASK                   (0xFFU)
#define I3C_SWDATABE_DATA_SHIFT                  (0U)
/*! DATA - The data byte to send to the master
 */
#define I3C_SWDATABE_DATA(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SWDATABE_DATA_SHIFT)) & I3C_SWDATABE_DATA_MASK)
/*! @} */

/*! @name SWDATAH - Slave Write Data Half-word Register */
/*! @{ */
#define I3C_SWDATAH_DATA0_MASK                   (0xFFU)
#define I3C_SWDATAH_DATA0_SHIFT                  (0U)
/*! DATA0 - The 1st byte to send to the master
 */
#define I3C_SWDATAH_DATA0(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAH_DATA0_SHIFT)) & I3C_SWDATAH_DATA0_MASK)
#define I3C_SWDATAH_DATA1_MASK                   (0xFF00U)
#define I3C_SWDATAH_DATA1_SHIFT                  (8U)
/*! DATA1 - The 2nd byte to send to the master
 */
#define I3C_SWDATAH_DATA1(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAH_DATA1_SHIFT)) & I3C_SWDATAH_DATA1_MASK)
#define I3C_SWDATAH_END_MASK                     (0x10000U)
#define I3C_SWDATAH_END_SHIFT                    (16U)
/*! END - End of message
 */
#define I3C_SWDATAH_END(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAH_END_SHIFT)) & I3C_SWDATAH_END_MASK)
/*! @} */

/*! @name SWDATAHE - Slave Write Data Half-word End Register */
/*! @{ */
#define I3C_SWDATAHE_DATA0_MASK                  (0xFFU)
#define I3C_SWDATAHE_DATA0_SHIFT                 (0U)
/*! DATA0 - The 1st byte to send to the master
 */
#define I3C_SWDATAHE_DATA0(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAHE_DATA0_SHIFT)) & I3C_SWDATAHE_DATA0_MASK)
#define I3C_SWDATAHE_DATA1_MASK                  (0xFF00U)
#define I3C_SWDATAHE_DATA1_SHIFT                 (8U)
/*! DATA1 - The 2nd byte to send to the master
 */
#define I3C_SWDATAHE_DATA1(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SWDATAHE_DATA1_SHIFT)) & I3C_SWDATAHE_DATA1_MASK)
/*! @} */

/*! @name SRDATAB - Slave Read Data Byte Register */
/*! @{ */
#define I3C_SRDATAB_DATA0_MASK                   (0xFFU)
#define I3C_SRDATAB_DATA0_SHIFT                  (0U)
/*! DATA0 - Byte read from the master
 */
#define I3C_SRDATAB_DATA0(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SRDATAB_DATA0_SHIFT)) & I3C_SRDATAB_DATA0_MASK)
/*! @} */

/*! @name SRDATAH - Slave Read Data Half-word Register */
/*! @{ */
#define I3C_SRDATAH_LSB_MASK                     (0xFFU)
#define I3C_SRDATAH_LSB_SHIFT                    (0U)
/*! LSB - The 1st byte read from the slave
 */
#define I3C_SRDATAH_LSB(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SRDATAH_LSB_SHIFT)) & I3C_SRDATAH_LSB_MASK)
#define I3C_SRDATAH_MSB_MASK                     (0xFF00U)
#define I3C_SRDATAH_MSB_SHIFT                    (8U)
/*! MSB - The 2nd byte read from the slave
 */
#define I3C_SRDATAH_MSB(x)                       (((uint32_t)(((uint32_t)(x)) << I3C_SRDATAH_MSB_SHIFT)) & I3C_SRDATAH_MSB_MASK)
/*! @} */

/*! @name SCAPABILITIES - Slave Capabilities Register */
/*! @{ */
#define I3C_SCAPABILITIES_IDENA_MASK             (0x3U)
#define I3C_SCAPABILITIES_IDENA_SHIFT            (0U)
/*! IDENA - ID 48b handler
 *  0b00..APPLICATION: Application handles ID 48b
 *  0b01..HW: Hardware handles ID 48b
 *  0b10..HW_BUT: in hardware but the I3C module instance handles ID 48b.
 *  0b11..PARTNO: a part number register (PARTNO) handles ID 48b
 */
#define I3C_SCAPABILITIES_IDENA(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_IDENA_SHIFT)) & I3C_SCAPABILITIES_IDENA_MASK)
#define I3C_SCAPABILITIES_IDREG_MASK             (0x3CU)
#define I3C_SCAPABILITIES_IDREG_SHIFT            (2U)
/*! IDREG - ID register
 */
#define I3C_SCAPABILITIES_IDREG(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_IDREG_SHIFT)) & I3C_SCAPABILITIES_IDREG_MASK)
#define I3C_SCAPABILITIES_HDRSUPP_MASK           (0x1C0U)
#define I3C_SCAPABILITIES_HDRSUPP_SHIFT          (6U)
/*! HDRSUPP - HDR support
 */
#define I3C_SCAPABILITIES_HDRSUPP(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_HDRSUPP_SHIFT)) & I3C_SCAPABILITIES_HDRSUPP_MASK)
#define I3C_SCAPABILITIES_MASTER_MASK            (0x200U)
#define I3C_SCAPABILITIES_MASTER_SHIFT           (9U)
/*! MASTER - Master
 *  0b0..MASTERNOTSUPPORTED: master capability is not supported.
 *  0b1..MASTERSUPPORTED: master capability is supported.
 */
#define I3C_SCAPABILITIES_MASTER(x)              (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_MASTER_SHIFT)) & I3C_SCAPABILITIES_MASTER_MASK)
#define I3C_SCAPABILITIES_SADDR_MASK             (0xC00U)
#define I3C_SCAPABILITIES_SADDR_SHIFT            (10U)
/*! SADDR - Static address
 *  0b00..NO_STATIC: No static address
 *  0b01..STATIC: Static address is fixed in hardware
 *  0b10..HW_CONTROL: Hardware controls the static address dynamically (for example, from the pin strap)
 *  0b11..CONFIG: SCONFIG register supplies the static address
 */
#define I3C_SCAPABILITIES_SADDR(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_SADDR_SHIFT)) & I3C_SCAPABILITIES_SADDR_MASK)
#define I3C_SCAPABILITIES_CCCHANDLE_MASK         (0xF000U)
#define I3C_SCAPABILITIES_CCCHANDLE_SHIFT        (12U)
/*! CCCHANDLE - Common Command Codes (CCC) handling
 */
#define I3C_SCAPABILITIES_CCCHANDLE(x)           (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_CCCHANDLE_SHIFT)) & I3C_SCAPABILITIES_CCCHANDLE_MASK)
#define I3C_SCAPABILITIES_IBI_MR_HJ_MASK         (0x1F0000U)
#define I3C_SCAPABILITIES_IBI_MR_HJ_SHIFT        (16U)
/*! IBI_MR_HJ - In-Band Interrupts, Master Requests, Hot Join events
 */
#define I3C_SCAPABILITIES_IBI_MR_HJ(x)           (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_IBI_MR_HJ_SHIFT)) & I3C_SCAPABILITIES_IBI_MR_HJ_MASK)
#define I3C_SCAPABILITIES_TIMECTRL_MASK          (0x200000U)
#define I3C_SCAPABILITIES_TIMECTRL_SHIFT         (21U)
/*! TIMECTRL - Time control
 *  0b0..NO_TIME_CONTROL_TYPE: No time control is enabled
 *  0b1..ATLEAST1_TIME_CONTROL: at least one time-control type is supported
 */
#define I3C_SCAPABILITIES_TIMECTRL(x)            (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_TIMECTRL_SHIFT)) & I3C_SCAPABILITIES_TIMECTRL_MASK)
#define I3C_SCAPABILITIES_EXTFIFO_MASK           (0x3800000U)
#define I3C_SCAPABILITIES_EXTFIFO_SHIFT          (23U)
/*! EXTFIFO - External FIFO
 *  0b001..STD_EXT_FIFO: standard available/free external FIFO
 *  0b011..RESERVED
 */
#define I3C_SCAPABILITIES_EXTFIFO(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_EXTFIFO_SHIFT)) & I3C_SCAPABILITIES_EXTFIFO_MASK)
#define I3C_SCAPABILITIES_FIFOTX_MASK            (0xC000000U)
#define I3C_SCAPABILITIES_FIFOTX_SHIFT           (26U)
/*! FIFOTX - FIFO transmit
 *  0b00..FIFO_2BYTE: 2-byte TX FIFO, the default FIFO transmit value (FIFOTX)
 *  0b01..FIFO_4BYTE: 4-byte TX FIFO
 *  0b10..FIFO_8BYTE: 8-byte TX FIFO
 *  0b11..FIFO_16BYTE: 16-byte TX FIFO
 */
#define I3C_SCAPABILITIES_FIFOTX(x)              (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_FIFOTX_SHIFT)) & I3C_SCAPABILITIES_FIFOTX_MASK)
#define I3C_SCAPABILITIES_FIFORX_MASK            (0x30000000U)
#define I3C_SCAPABILITIES_FIFORX_SHIFT           (28U)
/*! FIFORX - FIFO receive
 *  0b00..FIFO_2BYTE: 2 (or 3)-byte RX FIFO, the default FIFO receive value (FIFORX)
 *  0b01..FIFO_4BYTE: 4-byte RX FIFO
 *  0b10..FIFO_8BYTE: 8-byte RX FIFO
 *  0b11..FIFO_16BYTE: 16-byte RX FIFO
 */
#define I3C_SCAPABILITIES_FIFORX(x)              (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_FIFORX_SHIFT)) & I3C_SCAPABILITIES_FIFORX_MASK)
#define I3C_SCAPABILITIES_INT_MASK               (0x40000000U)
#define I3C_SCAPABILITIES_INT_SHIFT              (30U)
/*! INT - INT
 *  0b1..Interrupts are supported
 *  0b0..Interrupts are not supported
 */
#define I3C_SCAPABILITIES_INT(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_INT_SHIFT)) & I3C_SCAPABILITIES_INT_MASK)
#define I3C_SCAPABILITIES_DMA_MASK               (0x80000000U)
#define I3C_SCAPABILITIES_DMA_SHIFT              (31U)
/*! DMA - DMA
 *  0b1..DMA is supported
 *  0b0..DMA is not supported
 */
#define I3C_SCAPABILITIES_DMA(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_SCAPABILITIES_DMA_SHIFT)) & I3C_SCAPABILITIES_DMA_MASK)
/*! @} */

/*! @name SDYNADDR - Slave Dynamic Address Register */
/*! @{ */
#define I3C_SDYNADDR_DAVALID_MASK                (0x1U)
#define I3C_SDYNADDR_DAVALID_SHIFT               (0U)
/*! DAVALID - DAVALID
 *  0b0..DANOTASSIGNED: a Dynamic Address is not assigned
 *  0b1..DAASSIGNED: a Dynamic Address is assigned
 */
#define I3C_SDYNADDR_DAVALID(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_DAVALID_SHIFT)) & I3C_SDYNADDR_DAVALID_MASK)
#define I3C_SDYNADDR_DADDR_MASK                  (0xFEU)
#define I3C_SDYNADDR_DADDR_SHIFT                 (1U)
/*! DADDR - Dynamic address
 */
#define I3C_SDYNADDR_DADDR(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_DADDR_SHIFT)) & I3C_SDYNADDR_DADDR_MASK)
#define I3C_SDYNADDR_MAPIDX_MASK                 (0xF00U)
#define I3C_SDYNADDR_MAPIDX_SHIFT                (8U)
/*! MAPIDX - Mapped Dynamic Address
 */
#define I3C_SDYNADDR_MAPIDX(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_MAPIDX_SHIFT)) & I3C_SDYNADDR_MAPIDX_MASK)
#define I3C_SDYNADDR_MAPSA_MASK                  (0x1000U)
#define I3C_SDYNADDR_MAPSA_SHIFT                 (12U)
/*! MAPSA - Map a Static Address
 */
#define I3C_SDYNADDR_MAPSA(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_MAPSA_SHIFT)) & I3C_SDYNADDR_MAPSA_MASK)
#define I3C_SDYNADDR_KEY_MASK                    (0xFFFF0000U)
#define I3C_SDYNADDR_KEY_SHIFT                   (16U)
/*! KEY - Key
 */
#define I3C_SDYNADDR_KEY(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_SDYNADDR_KEY_SHIFT)) & I3C_SDYNADDR_KEY_MASK)
/*! @} */

/*! @name SMAXLIMITS - Slave Maximum Limits Register */
/*! @{ */
#define I3C_SMAXLIMITS_MAXRD_MASK                (0xFFFU)
#define I3C_SMAXLIMITS_MAXRD_SHIFT               (0U)
/*! MAXRD - Maximum read length
 */
#define I3C_SMAXLIMITS_MAXRD(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SMAXLIMITS_MAXRD_SHIFT)) & I3C_SMAXLIMITS_MAXRD_MASK)
#define I3C_SMAXLIMITS_MAXWR_MASK                (0xFFF0000U)
#define I3C_SMAXLIMITS_MAXWR_SHIFT               (16U)
/*! MAXWR - Maximum write length
 */
#define I3C_SMAXLIMITS_MAXWR(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SMAXLIMITS_MAXWR_SHIFT)) & I3C_SMAXLIMITS_MAXWR_MASK)
/*! @} */

/*! @name SIDPARTNO - Slave ID Part Number Register */
/*! @{ */
#define I3C_SIDPARTNO_PARTNO_MASK                (0xFFFFFFFFU)
#define I3C_SIDPARTNO_PARTNO_SHIFT               (0U)
/*! PARTNO - Part number
 */
#define I3C_SIDPARTNO_PARTNO(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_SIDPARTNO_PARTNO_SHIFT)) & I3C_SIDPARTNO_PARTNO_MASK)
/*! @} */

/*! @name SIDEXT - Slave ID Extension Register */
/*! @{ */
#define I3C_SIDEXT_DCR_MASK                      (0xFF00U)
#define I3C_SIDEXT_DCR_SHIFT                     (8U)
/*! DCR - Device Characteristic Register
 */
#define I3C_SIDEXT_DCR(x)                        (((uint32_t)(((uint32_t)(x)) << I3C_SIDEXT_DCR_SHIFT)) & I3C_SIDEXT_DCR_MASK)
#define I3C_SIDEXT_BCR_MASK                      (0xFF0000U)
#define I3C_SIDEXT_BCR_SHIFT                     (16U)
/*! BCR - Bus Characteristics Register
 */
#define I3C_SIDEXT_BCR(x)                        (((uint32_t)(((uint32_t)(x)) << I3C_SIDEXT_BCR_SHIFT)) & I3C_SIDEXT_BCR_MASK)
/*! @} */

/*! @name SVENDORID - Slave Vendor ID Register */
/*! @{ */
#define I3C_SVENDORID_VID_MASK                   (0x7FFFU)
#define I3C_SVENDORID_VID_SHIFT                  (0U)
/*! VID - Vendor ID
 */
#define I3C_SVENDORID_VID(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_SVENDORID_VID_SHIFT)) & I3C_SVENDORID_VID_MASK)
/*! @} */

/*! @name STCCLOCK - Slave Time Control Clock Register */
/*! @{ */
#define I3C_STCCLOCK_ACCURACY_MASK               (0xFFU)
#define I3C_STCCLOCK_ACCURACY_SHIFT              (0U)
/*! ACCURACY - Clock accuracy
 */
#define I3C_STCCLOCK_ACCURACY(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_STCCLOCK_ACCURACY_SHIFT)) & I3C_STCCLOCK_ACCURACY_MASK)
#define I3C_STCCLOCK_FREQ_MASK                   (0xFF00U)
#define I3C_STCCLOCK_FREQ_SHIFT                  (8U)
/*! FREQ - Clock frequency
 */
#define I3C_STCCLOCK_FREQ(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_STCCLOCK_FREQ_SHIFT)) & I3C_STCCLOCK_FREQ_MASK)
/*! @} */

/*! @name SMSGMAPADDR - Slave Message-Mapped Address Register */
/*! @{ */
#define I3C_SMSGMAPADDR_MAPLAST_MASK             (0xFU)
#define I3C_SMSGMAPADDR_MAPLAST_SHIFT            (0U)
/*! MAPLAST - Matched address index
 */
#define I3C_SMSGMAPADDR_MAPLAST(x)               (((uint32_t)(((uint32_t)(x)) << I3C_SMSGMAPADDR_MAPLAST_SHIFT)) & I3C_SMSGMAPADDR_MAPLAST_MASK)
#define I3C_SMSGMAPADDR_MAPLASTM1_MASK           (0xF00U)
#define I3C_SMSGMAPADDR_MAPLASTM1_SHIFT          (8U)
/*! MAPLASTM1 - Previous match index 1
 */
#define I3C_SMSGMAPADDR_MAPLASTM1(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SMSGMAPADDR_MAPLASTM1_SHIFT)) & I3C_SMSGMAPADDR_MAPLASTM1_MASK)
#define I3C_SMSGMAPADDR_MAPLASTM2_MASK           (0xF0000U)
#define I3C_SMSGMAPADDR_MAPLASTM2_SHIFT          (16U)
/*! MAPLASTM2 - Previous match index 2
 */
#define I3C_SMSGMAPADDR_MAPLASTM2(x)             (((uint32_t)(((uint32_t)(x)) << I3C_SMSGMAPADDR_MAPLASTM2_SHIFT)) & I3C_SMSGMAPADDR_MAPLASTM2_MASK)
/*! @} */

/*! @name MCTRL - Master Main Control Register */
/*! @{ */
#define I3C_MCTRL_REQUEST_MASK                   (0x7U)
#define I3C_MCTRL_REQUEST_SHIFT                  (0U)
/*! REQUEST - Request
 *  0b000..NONE: Returns to this when finished with any request. The MSTATUS register indicates the master's
 *         state. See also AutoIBI mode. NONE is only written as 0: when setting RDTERM to 1 (to stop a read in
 *         progress) or when setting IBI reponse field (IBIRESP) for MSG use
 *  0b001..EMITSTARTADDR: Emit START with address and direction from a stopped state or in the middle of a Single
 *         Data Rate (SDR) message. If from a stopped state (IDLE), then emit start may be prevented by an event
 *         (like IBI, MR, HJ), in which case the appropriate interrupt is signaled; note that Emit START can be
 *         resubmitted.
 *  0b010..EMITSTOP: Emit a STOP on bus. Must be in Single Data Rate (SDR) mode. If in Dynamic Address Assignment
 *         (DAA) mode, Emit stop will exit DAA mode.
 *  0b011..IBIACKNACK: Manual In-Band Interrupt (IBI) Acknowledge (ACK) or Not Acknowledge (NACK). When IBIRESP
 *         has indicated a hold on an In-Band Interrupt to allow a manual decision, this request completes it. Uses
 *         IBIRESP to provide the information.
 *  0b100..PROCESSDAA: If not in Dynamic Address Assignment (DAA) mode now, will issue START, 7E, ENTDAA, and then
 *         will emit 7E/R to process each slave. Will stop just before the new Dynamic Address (DA) is to be
 *         emitted. The next Process DAA request will use the Addr field as the new DA to assign. If NACKed on the 7E/R,
 *         then the interrupt will indicate this situation, and a STOP will be emitted.
 *  0b101..RESERVED
 *  0b110..FORCEEXIT and IBHR: Emit an Exit Pattern from any state, but end Double Data Rate (DDR) (including
 *         MSGDDR), if in DDR mode now. Includes a STOP afterward. If TYPE != 0, then it will perform an IBHR (In-Band
 *         Hardware Reset). If TYPE=2, then it does a normal reset (DEFRST can prevent the reset). If TYPE=3, it
 *         does a forced reset (will always reset).
 *  0b111..AUTOIBI: Hold in a stopped state, but auto-emit START,7E when the slave is holding down SDA to get an
 *         In-Band Interrupt (IBI). Actual In-Band Interrupt handling is defined by IBIRESP.
 */
#define I3C_MCTRL_REQUEST(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_REQUEST_SHIFT)) & I3C_MCTRL_REQUEST_MASK)
#define I3C_MCTRL_TYPE_MASK                      (0x30U)
#define I3C_MCTRL_TYPE_SHIFT                     (4U)
/*! TYPE - Bus type with START
 *  0b00..I3C: Normally the SDR mode of I3C. For ForceExit, the Exit pattern.
 *  0b01..I2C: Normally the Standard I2C protocol.
 *  0b10..DDR: (Double Data Rate): Normally the HDR-DDR mode of I3C. Enter DDR mode (7E and then ENTHDR0), if the
 *        module is not already in DDR mode. The 1st byte written to the TX FIFO should be a command, and should
 *        already be in the FIFO. To end DDR mode, use ForceExit. For ForceExit, the normal IBHR (In-Band Hardware
 *        Reset).
 *  0b11..For ForcedExit, this is forced IBHR.
 */
#define I3C_MCTRL_TYPE(x)                        (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_TYPE_SHIFT)) & I3C_MCTRL_TYPE_MASK)
#define I3C_MCTRL_IBIRESP_MASK                   (0xC0U)
#define I3C_MCTRL_IBIRESP_SHIFT                  (6U)
/*! IBIRESP - In-Band Interrupt (IBI) response
 *  0b00..ACK: Acknowledge. A mandatory byte (or not) is decided by the Master In-band Interrupt Registry and
 *        Rules Register (MIBIRULES). To limit the maximum number of IBI bytes, configure the Read Termination field
 *        (MCTRL.RDTERM).
 *  0b01..NACK: Not acknowledge
 *  0b10..ACK_WITH_MANDATORY: Acknowledge with mandatory byte (ignores the MIBIRULES register). Acknowledge with
 *        mandatory byte should not be used, unless only slaves with a mandatory byte can cause an In-Band Interrupt.
 *  0b11..MANUAL: stop and wait for a decision using the IBIAckNack request
 */
#define I3C_MCTRL_IBIRESP(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_IBIRESP_SHIFT)) & I3C_MCTRL_IBIRESP_MASK)
#define I3C_MCTRL_DIR_MASK                       (0x100U)
#define I3C_MCTRL_DIR_SHIFT                      (8U)
/*! DIR - DIR
 *  0b0..DIRWRITE: Write
 *  0b1..DIRREAD: Read
 */
#define I3C_MCTRL_DIR(x)                         (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_DIR_SHIFT)) & I3C_MCTRL_DIR_MASK)
#define I3C_MCTRL_ADDR_MASK                      (0xFE00U)
#define I3C_MCTRL_ADDR_SHIFT                     (9U)
/*! ADDR - ADDR
 */
#define I3C_MCTRL_ADDR(x)                        (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_ADDR_SHIFT)) & I3C_MCTRL_ADDR_MASK)
#define I3C_MCTRL_RDTERM_MASK                    (0xFF0000U)
#define I3C_MCTRL_RDTERM_SHIFT                   (16U)
/*! RDTERM - Read terminate
 */
#define I3C_MCTRL_RDTERM(x)                      (((uint32_t)(((uint32_t)(x)) << I3C_MCTRL_RDTERM_SHIFT)) & I3C_MCTRL_RDTERM_MASK)
/*! @} */

/*! @name MSTATUS - Master Status Register */
/*! @{ */
#define I3C_MSTATUS_STATE_MASK                   (0x7U)
#define I3C_MSTATUS_STATE_SHIFT                  (0U)
/*! STATE - State of the master
 *  0b000..IDLE: the bus has STOPped.
 *  0b001..SLVREQ: (Slave Request state) the bus has STOPped but a slave is holding SDA low. If using auto-emit
 *         IBI (MCTRL.AutoIBI), then the master will not stay in the Slave Request state.
 *  0b010..MSGSDR: in Single Data Rate (SDR) Message state (from using MWMSG_SDR)
 *  0b011..NORMACT: normal active Single Data Rate (SDR) state (from using MCTRL and MWDATAn and MRDATAn
 *         registers). The master will stay in the NORMACT state until a STOP is issued.
 *  0b100..MSGDDR: in Double Data Rate (DDR) Message mode (from using MWMSG_DDR or using the normal method with
 *         DDR). The master will stay in the DDR state, until the master exits using EXIT (emits the Exit pattern).
 *  0b101..DAA: in Enter Dynamic Address Assignment (ENTDAA) mode
 *  0b110..IBIACK: waiting for an In-Band Interrupt (IBI) ACK/NACK decision
 *  0b111..IBIRCV: Receiving an In-Band Interrupt (IBI); this IBIRCV state is used after IBI/MR/HJ has won the
 *         arbitration, and IBIRCV state is also used for IBI mandatory byte (if any) and any bytes that follow.
 */
#define I3C_MSTATUS_STATE(x)                     (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_STATE_SHIFT)) & I3C_MSTATUS_STATE_MASK)
#define I3C_MSTATUS_BETWEEN_MASK                 (0x10U)
#define I3C_MSTATUS_BETWEEN_SHIFT                (4U)
/*! BETWEEN - Between messages or Dynamic Address Assignments (DAA)
 */
#define I3C_MSTATUS_BETWEEN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_BETWEEN_SHIFT)) & I3C_MSTATUS_BETWEEN_MASK)
#define I3C_MSTATUS_NACKED_MASK                  (0x20U)
#define I3C_MSTATUS_NACKED_SHIFT                 (5U)
/*! NACKED - Not acknowledged
 */
#define I3C_MSTATUS_NACKED(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_NACKED_SHIFT)) & I3C_MSTATUS_NACKED_MASK)
#define I3C_MSTATUS_IBITYPE_MASK                 (0xC0U)
#define I3C_MSTATUS_IBITYPE_SHIFT                (6U)
/*! IBITYPE - In-Band Interrupt (IBI) type
 *  0b00..NONE: cleared when IBI Won bit (MSTATUS.IBIWON) is cleared
 *  0b01..IBI: In-Band Interrupt
 *  0b10..MR: Master Request
 *  0b11..HJ: Hot-Join
 */
#define I3C_MSTATUS_IBITYPE(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_IBITYPE_SHIFT)) & I3C_MSTATUS_IBITYPE_MASK)
#define I3C_MSTATUS_SLVSTART_MASK                (0x100U)
#define I3C_MSTATUS_SLVSTART_SHIFT               (8U)
/*! SLVSTART - Slave start
 */
#define I3C_MSTATUS_SLVSTART(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_SLVSTART_SHIFT)) & I3C_MSTATUS_SLVSTART_MASK)
#define I3C_MSTATUS_MCTRLDONE_MASK               (0x200U)
#define I3C_MSTATUS_MCTRLDONE_SHIFT              (9U)
/*! MCTRLDONE - Master control done
 */
#define I3C_MSTATUS_MCTRLDONE(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_MCTRLDONE_SHIFT)) & I3C_MSTATUS_MCTRLDONE_MASK)
#define I3C_MSTATUS_COMPLETE_MASK                (0x400U)
#define I3C_MSTATUS_COMPLETE_SHIFT               (10U)
/*! COMPLETE - COMPLETE
 */
#define I3C_MSTATUS_COMPLETE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_COMPLETE_SHIFT)) & I3C_MSTATUS_COMPLETE_MASK)
#define I3C_MSTATUS_RXPEND_MASK                  (0x800U)
#define I3C_MSTATUS_RXPEND_SHIFT                 (11U)
/*! RXPEND - RXPEND
 */
#define I3C_MSTATUS_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_RXPEND_SHIFT)) & I3C_MSTATUS_RXPEND_MASK)
#define I3C_MSTATUS_TXNOTFULL_MASK               (0x1000U)
#define I3C_MSTATUS_TXNOTFULL_SHIFT              (12U)
/*! TXNOTFULL - TX buffer/FIFO not yet full
 */
#define I3C_MSTATUS_TXNOTFULL(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_TXNOTFULL_SHIFT)) & I3C_MSTATUS_TXNOTFULL_MASK)
#define I3C_MSTATUS_IBIWON_MASK                  (0x2000U)
#define I3C_MSTATUS_IBIWON_SHIFT                 (13U)
/*! IBIWON - In-Band Interrupt (IBI) won
 */
#define I3C_MSTATUS_IBIWON(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_IBIWON_SHIFT)) & I3C_MSTATUS_IBIWON_MASK)
#define I3C_MSTATUS_ERRWARN_MASK                 (0x8000U)
#define I3C_MSTATUS_ERRWARN_SHIFT                (15U)
/*! ERRWARN - Error or warning
 */
#define I3C_MSTATUS_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_ERRWARN_SHIFT)) & I3C_MSTATUS_ERRWARN_MASK)
#define I3C_MSTATUS_NOWMASTER_MASK               (0x80000U)
#define I3C_MSTATUS_NOWMASTER_SHIFT              (19U)
/*! NOWMASTER - Now master (now this module is a master)
 */
#define I3C_MSTATUS_NOWMASTER(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_NOWMASTER_SHIFT)) & I3C_MSTATUS_NOWMASTER_MASK)
#define I3C_MSTATUS_IBIADDR_MASK                 (0x7F000000U)
#define I3C_MSTATUS_IBIADDR_SHIFT                (24U)
/*! IBIADDR - IBI address
 */
#define I3C_MSTATUS_IBIADDR(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MSTATUS_IBIADDR_SHIFT)) & I3C_MSTATUS_IBIADDR_MASK)
/*! @} */

/*! @name MIBIRULES - Master In-band Interrupt Registry and Rules Register */
/*! @{ */
#define I3C_MIBIRULES_ADDR0_MASK                 (0x3FU)
#define I3C_MIBIRULES_ADDR0_SHIFT                (0U)
/*! ADDR0 - ADDR0
 */
#define I3C_MIBIRULES_ADDR0(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR0_SHIFT)) & I3C_MIBIRULES_ADDR0_MASK)
#define I3C_MIBIRULES_ADDR1_MASK                 (0xFC0U)
#define I3C_MIBIRULES_ADDR1_SHIFT                (6U)
/*! ADDR1 - ADDR1
 */
#define I3C_MIBIRULES_ADDR1(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR1_SHIFT)) & I3C_MIBIRULES_ADDR1_MASK)
#define I3C_MIBIRULES_ADDR2_MASK                 (0x3F000U)
#define I3C_MIBIRULES_ADDR2_SHIFT                (12U)
/*! ADDR2 - ADDR2
 */
#define I3C_MIBIRULES_ADDR2(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR2_SHIFT)) & I3C_MIBIRULES_ADDR2_MASK)
#define I3C_MIBIRULES_ADDR3_MASK                 (0xFC0000U)
#define I3C_MIBIRULES_ADDR3_SHIFT                (18U)
/*! ADDR3 - ADDR3
 */
#define I3C_MIBIRULES_ADDR3(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR3_SHIFT)) & I3C_MIBIRULES_ADDR3_MASK)
#define I3C_MIBIRULES_ADDR4_MASK                 (0x3F000000U)
#define I3C_MIBIRULES_ADDR4_SHIFT                (24U)
/*! ADDR4 - ADDR4
 */
#define I3C_MIBIRULES_ADDR4(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_ADDR4_SHIFT)) & I3C_MIBIRULES_ADDR4_MASK)
#define I3C_MIBIRULES_MSB0_MASK                  (0x40000000U)
#define I3C_MIBIRULES_MSB0_SHIFT                 (30U)
/*! MSB0 - Set Most Significant address Bit to 0
 */
#define I3C_MIBIRULES_MSB0(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_MSB0_SHIFT)) & I3C_MIBIRULES_MSB0_MASK)
#define I3C_MIBIRULES_NOBYTE_MASK                (0x80000000U)
#define I3C_MIBIRULES_NOBYTE_SHIFT               (31U)
/*! NOBYTE - No IBI byte
 */
#define I3C_MIBIRULES_NOBYTE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MIBIRULES_NOBYTE_SHIFT)) & I3C_MIBIRULES_NOBYTE_MASK)
/*! @} */

/*! @name MINTSET - Master Interrupt Set Register */
/*! @{ */
#define I3C_MINTSET_SLVSTART_MASK                (0x100U)
#define I3C_MINTSET_SLVSTART_SHIFT               (8U)
/*! SLVSTART - Slave start interrupt enable
 */
#define I3C_MINTSET_SLVSTART(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_SLVSTART_SHIFT)) & I3C_MINTSET_SLVSTART_MASK)
#define I3C_MINTSET_MCTRLDONE_MASK               (0x200U)
#define I3C_MINTSET_MCTRLDONE_SHIFT              (9U)
/*! MCTRLDONE - Master control done interrupt enable
 */
#define I3C_MINTSET_MCTRLDONE(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_MCTRLDONE_SHIFT)) & I3C_MINTSET_MCTRLDONE_MASK)
#define I3C_MINTSET_COMPLETE_MASK                (0x400U)
#define I3C_MINTSET_COMPLETE_SHIFT               (10U)
/*! COMPLETE - Completed message interrupt enable
 */
#define I3C_MINTSET_COMPLETE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_COMPLETE_SHIFT)) & I3C_MINTSET_COMPLETE_MASK)
#define I3C_MINTSET_RXPEND_MASK                  (0x800U)
#define I3C_MINTSET_RXPEND_SHIFT                 (11U)
/*! RXPEND - RX pending interrupt enable
 */
#define I3C_MINTSET_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_RXPEND_SHIFT)) & I3C_MINTSET_RXPEND_MASK)
#define I3C_MINTSET_TXNOTFULL_MASK               (0x1000U)
#define I3C_MINTSET_TXNOTFULL_SHIFT              (12U)
/*! TXNOTFULL - TX buffer/FIFO is not full interrupt enable
 */
#define I3C_MINTSET_TXNOTFULL(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_TXNOTFULL_SHIFT)) & I3C_MINTSET_TXNOTFULL_MASK)
#define I3C_MINTSET_IBIWON_MASK                  (0x2000U)
#define I3C_MINTSET_IBIWON_SHIFT                 (13U)
/*! IBIWON - In-Band Interrupt (IBI) won interrupt enable
 */
#define I3C_MINTSET_IBIWON(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_IBIWON_SHIFT)) & I3C_MINTSET_IBIWON_MASK)
#define I3C_MINTSET_ERRWARN_MASK                 (0x8000U)
#define I3C_MINTSET_ERRWARN_SHIFT                (15U)
/*! ERRWARN - Error or warning (ERRWARN) interrupt enable
 */
#define I3C_MINTSET_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_ERRWARN_SHIFT)) & I3C_MINTSET_ERRWARN_MASK)
#define I3C_MINTSET_NOWMASTER_MASK               (0x80000U)
#define I3C_MINTSET_NOWMASTER_SHIFT              (19U)
/*! NOWMASTER - Now master (now this I3C module is a master) interrupt enable
 */
#define I3C_MINTSET_NOWMASTER(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTSET_NOWMASTER_SHIFT)) & I3C_MINTSET_NOWMASTER_MASK)
/*! @} */

/*! @name MINTCLR - Master Interrupt Clear Register */
/*! @{ */
#define I3C_MINTCLR_SLVSTART_MASK                (0x100U)
#define I3C_MINTCLR_SLVSTART_SHIFT               (8U)
/*! SLVSTART - SLVSTART interrupt enable clear
 */
#define I3C_MINTCLR_SLVSTART(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_SLVSTART_SHIFT)) & I3C_MINTCLR_SLVSTART_MASK)
#define I3C_MINTCLR_MCTRLDONE_MASK               (0x200U)
#define I3C_MINTCLR_MCTRLDONE_SHIFT              (9U)
/*! MCTRLDONE - MCTRLDONE interrupt enable clear
 */
#define I3C_MINTCLR_MCTRLDONE(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_MCTRLDONE_SHIFT)) & I3C_MINTCLR_MCTRLDONE_MASK)
#define I3C_MINTCLR_COMPLETE_MASK                (0x400U)
#define I3C_MINTCLR_COMPLETE_SHIFT               (10U)
/*! COMPLETE - COMPLETE interrupt enable clear
 */
#define I3C_MINTCLR_COMPLETE(x)                  (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_COMPLETE_SHIFT)) & I3C_MINTCLR_COMPLETE_MASK)
#define I3C_MINTCLR_RXPEND_MASK                  (0x800U)
#define I3C_MINTCLR_RXPEND_SHIFT                 (11U)
/*! RXPEND - RXPEND interrupt enable clear
 */
#define I3C_MINTCLR_RXPEND(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_RXPEND_SHIFT)) & I3C_MINTCLR_RXPEND_MASK)
#define I3C_MINTCLR_TXNOTFULL_MASK               (0x1000U)
#define I3C_MINTCLR_TXNOTFULL_SHIFT              (12U)
/*! TXNOTFULL - TXNOTFULL interrupt enable clear
 */
#define I3C_MINTCLR_TXNOTFULL(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_TXNOTFULL_SHIFT)) & I3C_MINTCLR_TXNOTFULL_MASK)
#define I3C_MINTCLR_IBIWON_MASK                  (0x2000U)
#define I3C_MINTCLR_IBIWON_SHIFT                 (13U)
/*! IBIWON - IBIWON interrupt enable clear
 */
#define I3C_MINTCLR_IBIWON(x)                    (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_IBIWON_SHIFT)) & I3C_MINTCLR_IBIWON_MASK)
#define I3C_MINTCLR_ERRWARN_MASK                 (0x8000U)
#define I3C_MINTCLR_ERRWARN_SHIFT                (15U)
/*! ERRWARN - ERRWARN interrupt enable clear
 */
#define I3C_MINTCLR_ERRWARN(x)                   (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_ERRWARN_SHIFT)) & I3C_MINTCLR_ERRWARN_MASK)
#define I3C_MINTCLR_NOWMASTER_MASK               (0x80000U)
#define I3C_MINTCLR_NOWMASTER_SHIFT              (19U)
/*! NOWMASTER - NOWMASTER interrupt enable clear
 */
#define I3C_MINTCLR_NOWMASTER(x)                 (((uint32_t)(((uint32_t)(x)) << I3C_MINTCLR_NOWMASTER_SHIFT)) & I3C_MINTCLR_NOWMASTER_MASK)
/*! @} */

/*! @name MINTMASKED - Master Interrupt Mask Register */
/*! @{ */
#define I3C_MINTMASKED_SLVSTART_MASK             (0x100U)
#define I3C_MINTMASKED_SLVSTART_SHIFT            (8U)
/*! SLVSTART - SLVSTART interrupt mask
 */
#define I3C_MINTMASKED_SLVSTART(x)               (((uint32_t)(((uint32_t)(x)) << I3C_MINTMASKED_SLVSTART_SHIFT)) & I3C_MINTMASKED_SLVSTART_MASK)
#define I3C_MINTMASKED_MCTRLDONE_MASK            (0x200U)
#define I3C_MINTMASKED_MCTRLDONE_SHIFT           (9U)
/