/*********************************************************************
*                     SEGGER Microcontroller GmbH                    *
*                        The Embedded Experts                        *
**********************************************************************
*                                                                    *
*       (c) 1995 - 2020 SEGGER Microcontroller GmbH                  *
*                                                                    *
*       Internet: segger.com  Support: support_embos@segger.com      *
*                                                                    *
**********************************************************************
*                                                                    *
*       embOS * Real time operating system for microcontrollers      *
*                                                                    *
*       Please note:                                                 *
*                                                                    *
*       Knowledge of this file may under no circumstances            *
*       be used to write a similar product or a real-time            *
*       operating system for in-house use.                           *
*                                                                    *
*       Thank you for your fairness !                                *
*                                                                    *
**********************************************************************
*                                                                    *
*       OS version: V5.10.2.0                                        *
*                                                                    *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------
File    : BSP.c
Purpose : BSP for MIMXRT595-EVK
*/

#include "BSP.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/

#define LED0_BIT          (14)  // Red,   P0_14
#define LED1_BIT           (0)  // Green, P1_0
#define LED2_BIT          (17)  // Blue,  P3_17

#define CLKCTL1_PSCCTL1_SET   (*(volatile unsigned int*)(0x40021044u))
#define RSTCTL1_PRSTCTL1_CLR  (*(volatile unsigned int*)(0x40020074u))

#define GPIO_BASE_ADDR    (0x40100000u)
#define GPIO_DIRSET0      (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x2380u))  // Port 0 set direction register
#define GPIO_DIRSET1      (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x2384u))  // Port 1 set direction register
#define GPIO_DIRSET3      (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x238Cu))  // Port 1 set direction register
#define GPIO_SET0         (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x2200u))  // Port 0 set register
#define GPIO_SET1         (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x2204u))  // Port 1 set register
#define GPIO_SET3         (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x220Cu))  // Port 1 set register
#define GPIO_CLR0         (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x2280u))  // Port 0 clear register
#define GPIO_CLR1         (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x2284u))  // Port 1 clear register
#define GPIO_CLR3         (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x228Cu))  // Port 1 clear register
#define GPIO_NOT0         (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x2300u))  // Port 0 toggle register
#define GPIO_NOT1         (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x2304u))  // Port 1 toggle register
#define GPIO_NOT3         (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x230Cu))  // Port 1 toggle register

/*********************************************************************
*
*       Global functions
*
**********************************************************************
*/

/*********************************************************************
*
*       BSP_Init()
*/
void BSP_Init(void) {
  RSTCTL1_PRSTCTL1_CLR  |= (1u << 0)   // Clear GPIO port 0 reset
                        |  (1u << 1)   // Clear GPIO port 1 reset
                        |  (1u << 3);  // Clear GPIO port 3 reset
  CLKCTL1_PSCCTL1_SET   |= (1u << 0)   // Enable GPIO port 0 clock
                        |  (1u << 1)   // Enable GPIO port 1 clock
                        |  (1u << 3);  // Enable GPIO port 3 clock
  GPIO_DIRSET0          |=  (1u << LED0_BIT);
  GPIO_DIRSET1          |=  (1u << LED1_BIT);
  GPIO_DIRSET3          |=  (1u << LED2_BIT);
}

/*********************************************************************
*
*       BSP_SetLED()
*/
void BSP_SetLED(int Index) {
  switch(Index) {
  case 0:
    GPIO_SET0 |= (1u << LED0_BIT);
    break;
  case 1:
    GPIO_SET1 |= (1u << LED1_BIT);
    break;
  case 2:
    GPIO_SET3 |= (1u << LED2_BIT);
    break;
  default:
    break;
  }
}

/*********************************************************************
*
*       BSP_ClrLED()
*/
void BSP_ClrLED(int Index) {
  switch(Index) {
  case 0:
    GPIO_CLR0 |= (1u << LED0_BIT);
    break;
  case 1:
    GPIO_CLR1 |= (1u << LED1_BIT);
    break;
  case 2:
    GPIO_CLR3 |= (1u << LED2_BIT);
    break;
  default:
    break;
  }
}

/*********************************************************************
*
*       BSP_ToggleLED()
*/
void BSP_ToggleLED(int Index) {
  switch(Index) {
  case 0:
    GPIO_NOT0 |= (1u << LED0_BIT);
    break;
  case 1:
    GPIO_NOT1 |= (1u << LED1_BIT);
    break;
  case 2:
    GPIO_NOT3 |= (1u << LED2_BIT);
    break;
  default:
    break;
  }
}

/*************************** End of file ****************************/
