/*********************************************************************
*               SEGGER MICROCONTROLLER GmbH & Co. KG                 *
*       Solutions for real time microcontroller applications         *
**********************************************************************
*                                                                    *
*       (c) 2014 - 2018  SEGGER Microcontroller GmbH & Co. KG        *
*                                                                    *
*       www.segger.com     Support: support@segger.com               *
*                                                                    *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------

File    : main.c
Purpose : Generic application start
*/

#include <stdio.h>
#include <stdlib.h>

/*********************************************************************
*
*       Defines, fixed
*
**********************************************************************
*/
#define PADREGK  (*(volatile unsigned int*)0x40010028)
#define PADKEY   (*(volatile unsigned int*)0x40010060)
#define TPIUCTRL (*(volatile unsigned int*)0x40020250)

/*********************************************************************
*
*       Local functions
*
**********************************************************************
*/
/*********************************************************************
*
*       _Delay()
*/
static void _Delay(void) {
  volatile unsigned int DelayCnt;
  DelayCnt = 1000000;
  while(--DelayCnt);
}

/*********************************************************************
*
*       main()
*
*  Function description
*   Application entry point.
*/
void main(void) {
  int i;
  unsigned int v;
  //
  // Init pin for SWO output
  // On the Apollo2 AMAPH1KK-KBR EVB PAD41 has been wired for SWO
  //
  TPIUCTRL = (2 << 8) | (1 << 0);
  PADKEY   = 0x00000073;          // Unlock PAD registers
  PADREGK &= ~(1 << 15);          // PAD41PWRUP: 0 == Power switch disabled
  v  = PADREGK;
  v &= ~(7uL << 11);
  v |= (2 << 11);                 // PAD41FNCSEL: 2 == Configure pin as SWO
  PADREGK = v;
  PADREGK |= (1 << 10);           // PAD41STRNG: 1 == High drive strength
  PADREGK |= (1 << 9);            // PAD41INPEN: 1 == Pad input enabled
  PADREGK |= (1 << 8);            // PAD41PULL: 1 == Pullup enabled
  PADKEY = 0x00000000;

  do {
    printf("Hello World %d!\n", i);
    i++;
    if (i > 1000) {
      i = 0;
    }
    _Delay();
  } while (1);
}

/*************************** End of file ****************************/
