/*********************************************************************
*                    SEGGER Microcontroller GmbH                     *
*                        The Embedded Experts                        *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------

File    : main.c
Purpose : Generic application start

*/

#include <stdio.h>
#include <stm32f4xx.h>
#include <stdlib.h>

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
static volatile int ticks = 0;

/*********************************************************************
*
*       SysTick_Handler()
*
*  Function description
*    Takes care of Systick interrupt.
*
*/
void SysTick_Handler(void) {
  ticks++;
}

/*********************************************************************
*
*       Local functions
*
**********************************************************************
*/
/*********************************************************************
*
*       delay()
*
*  Function description
*    Delay function in ms
*
*  Parameter
*     n: Delay in ms
*/
static void delay(int n) {
  unsigned endTicks = ticks + n;
  while (ticks < endTicks);
}

/*********************************************************************
*
*       main()
*
*  Function description
*   Application entry point.
*/
int main(void) {
  // 
  // Start of Systick Sample
  //
  // Make sure SystemCoreClock is up-to-date
  //
  SystemCoreClockUpdate();
  //
  // Enable SysTick timer interrupt
  //
  SysTick->LOAD = (SystemCoreClock / 1000) - 1;
  SysTick->VAL = 0;
  SysTick->CTRL = SysTick_CTRL_CLKSOURCE_Msk | SysTick_CTRL_TICKINT_Msk | SysTick_CTRL_ENABLE_Msk;
  printf("Systick sample start.\n");
  //
  // Display tick count
  //
  while (1) {
    printf("ticks = %d\n", ticks);
    delay(1000);
  }
}
/*************************** End of file ****************************/
