/*********************************************************************
*                    SEGGER Microcontroller GmbH                     *
*                        The Embedded Experts                        *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------

File    : main.c
Purpose : Generic application start

*/

#include <stdio.h>
#include <stdlib.h>

struct TEST_STRUCT {
  unsigned char  vChar;
  unsigned short vShort;
  unsigned int   vInt;
} TEST_STRUCT;
/*********************************************************************
*
*       main()
*
*  Function description
*   Application entry point.
*/
int main(void) {
  int                       i;
  int                       sincnt;
  static signed int         sin;
  static struct TEST_STRUCT test_struct;
  static int                array2d[2][2];
  const int sine_table[40] = { 0, 5125, 10125, 14876, 19260, 23170, 26509, 29196,
31163, 32364, 32767, 32364, 31163, 29196, 26509, 23170, 19260, 14876, 10125,
5125, 0, -5126, -10126, -14877, -19261, -23171, -26510, -29197, -31164, -32365,
-32768, -32365, -31164, -29197, -26510, -23171, -19261, -14877, -10126, -5126 };

  i      = 0;
  sincnt = 0;
  sin    = 0;
  test_struct.vChar  = 0;
  test_struct.vShort = 0;
  test_struct.vInt   = 0;
  array2d[0][0] = 0;
  array2d[0][1] = 0;
  array2d[1][0] = 0;
  array2d[1][1] = 0;
  do {
    test_struct.vChar  += 3;
    test_struct.vShort += 55;
    test_struct.vInt   += 111;
    if (test_struct.vChar > 250) {
      test_struct.vChar  = 0;
      test_struct.vShort = 0;
      test_struct.vInt   = 0;
    }
    sin = sine_table[sincnt];
    sincnt++;
    if (sincnt == 40) {
      sincnt = 0;
    }
    array2d[0][0] += 1;
    array2d[0][1] += 2;
    array2d[1][0] += 3;
    array2d[1][1] += 4;
    i = 0;
    while (i < 0x00000FFF) {
      i++;
    }
  } while (1);
}

/*************************** End of file ****************************/
