/*********************************************************************
*                    SEGGER Microcontroller GmbH                     *
*                        The Embedded Experts                        *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------

File    : main.c
Purpose : Generic application start

*/

#include <stdio.h>
#include <stdlib.h>
#include "LPC55S28.h"

void _SendString(const char* c) {
  char* p;
  uint32_t uC;
  
  p = (char*)c;
  do {
  uC = (0 + (*p++));
    ITM_SendChar(uC);
  }
  while (*p);
}

static void _Delay(unsigned long Delay_us) {
  Delay_us *= 8000;
  while(Delay_us--);
}


/*********************************************************************
*
*       main()
*
*  Function description
*   Application entry point.
*/
int main(void) {
  int i;

  do {
      for (i = 0; i < 100; i++) {
      _SendString("Hello World!\n");
      _Delay(1000);
    }
  
  } while (1);
}

/*************************** End of file ****************************/
