
/****************************************************************************************************//**
 * @file     LPC43xx.h
 *
 * @brief    CMSIS Cortex-M4 Peripheral Access Layer Header File for
 *           LPC43xx from .
 *
 * @version  V9
 * @date     4. September 2013
 *
 * @note     Generated with SVDConv V2.80 
 *           from CMSIS SVD File 'LPC43xx.svd' Version 9,
 *
 *           Modified by KEIL
 *******************************************************************************************************/



/** @addtogroup (null)
  * @{
  */

/** @addtogroup LPC43xx
  * @{
  */

#ifndef LPC43XX_H
#define LPC43XX_H

#ifdef __cplusplus
extern "C" {
#endif

/*
   Following defines are used:
     CORE_M4    LPC43xx M4 Application core
     CORE_M0    LPC43xx M0 Application core
     CORE_M0SUB LPC43xx M0 Subsystem core
 */
#if !defined (CORE_M4) && !defined (CORE_M0) && !defined (CORE_M0SUB)
  #define CORE_M4
#endif  

/* -------------------------  Interrupt Number Definition  ------------------------ */

typedef enum {
#ifdef CORE_M4
/* -------------------  Cortex-M4 Processor Exceptions Numbers  ------------------- */
  NonMaskableInt_IRQn               = -14, /*!<   2  Non maskable Interrupt, cannot be stopped or preempted    */
  HardFault_IRQn                    = -13, /*!<   3  Hard Fault, all classes of Fault                          */
  MemoryManagement_IRQn             = -12, /*!<   4  Memory Management                                         */
  BusFault_IRQn                     = -11, /*!<   5  Bus Fault                                                 */
  UsageFault_IRQn                   = -10, /*!<   6  Usage Fault                                               */
  SVCall_IRQn                       =  -5, /*!<  11  System Service Call via SVC instruction                   */
  DebugMonitor_IRQn                 =  -4, /*!<  12  Debug Monitor                                             */
  PendSV_IRQn                       =  -2, /*!<  14  Pendable request for system service                       */
  SysTick_IRQn                      =  -1, /*!<  15  System Tick Timer                                         */
// ---------------------------  LPC43xx/M4 Specific Interrupt Numbers  ----------------------------
  DAC_IRQn                          =  0,  /*!<   0  DAC interrupt                                             */
  M0APP_IRQn                        =  1,  /*!<   1  Cortex-M0APP; Latched TXEV; for M4-M0APP communication    */
  DMA_IRQn                          =  2,  /*!<   2  DMA interrupt                                             */

  FLASHEEPROM_IRQn                  =  4,  /*!<   4  flash bank A, flash bank B, EEPROM ORed interrupt         */
  ETHERNET_IRQn                     =  5,  /*!<   5  Ethernet interrupt                                         */
  SDIO_IRQn                         =  6,  /*!<   6  SD/MMC interrupt                                          */
  LCD_IRQn                          =  7,  /*!<   7  LCD interrupt                                             */
  USB0_IRQn                         =  8,  /*!<   8  OTG interrupt                                             */
  USB1_IRQn                         =  9,  /*!<   9  USB1 interrupt                                            */
  SCT_IRQn                          = 10,  /*!<  10  SCT combined interrupt                                    */
  RITIMER_IRQn                      = 11,  /*!<  11  RI Timer interrupt                                        */
  TIMER0_IRQn                       = 12,  /*!<  12  Timer 0 interrupt                                         */
  TIMER1_IRQn                       = 13,  /*!<  13  Timer 1 interrupt                                         */
  TIMER2_IRQn                       = 14,  /*!<  14  Timer 2 interrupt                                         */
  TIMER3_IRQn                       = 15,  /*!<  15  Timer 3 interrupt                                         */
  MCPWM_IRQn                        = 16,  /*!<  16  Motor control PWM interrupt                               */
  ADC0_IRQn                         = 17,  /*!<  17  ADC0 interrupt                                            */
  I2C0_IRQn                         = 18,  /*!<  18  I2C0 interrupt                                            */
  I2C1_IRQn                         = 19,  /*!<  19  I2C1 interrupt                                            */
  SPI_IRQn                          = 20,  /*!<  20  SPI interrupt                                             */
  ADC1_IRQn                         = 21,  /*!<  21  ADC1 interrupt                                            */
  SSP0_IRQn                         = 22,  /*!<  22  SSP0 interrupt                                            */
  SSP1_IRQn                         = 23,  /*!<  23  SSP1 interrupt                                            */
  USART0_IRQn                       = 24,  /*!<  24  USART0 interrupt                                          */
  UART1_IRQn                        = 25,  /*!<  25  Combined UART1, Modem interrupt                           */
  USART2_IRQn                       = 26,  /*!<  26  USART2 interrupt                                          */
  USART3_IRQn                       = 27,  /*!<  27  Combined USART3, IrDA interrupt                           */
  I2S0_IRQn                         = 28,  /*!<  28  I2S0 interrupt                                            */
  I2S1_IRQn                         = 29,  /*!<  29  I2S1 interrupt                                            */
  SPIFI_IRQn                        = 30,  /*!<  30  SPISI interrupt                                           */
  SGPIO_IRQn                        = 31,  /*!<  31  SGPIO interrupt                                           */
  PIN_INT0_IRQn                     = 32,  /*!<  32  GPIO pin interrupt 0                                      */
  PIN_INT1_IRQn                     = 33,  /*!<  33  GPIO pin interrupt 1                                      */
  PIN_INT2_IRQn                     = 34,  /*!<  34  GPIO pin interrupt 2                                      */
  PIN_INT3_IRQn                     = 35,  /*!<  35  GPIO pin interrupt 3                                      */
  PIN_INT4_IRQn                     = 36,  /*!<  36  GPIO pin interrupt 4                                      */
  PIN_INT5_IRQn                     = 37,  /*!<  37  GPIO pin interrupt 5                                      */
  PIN_INT6_IRQn                     = 38,  /*!<  38  GPIO pin interrupt 6                                      */
  PIN_INT7_IRQn                     = 39,  /*!<  39  GPIO pin interrupt 7                                      */
  GINT0_IRQn                        = 40,  /*!<  40  GPIO global interrupt 0                                   */
  GINT1_IRQn                        = 41,  /*!<  41  GPIO global interrupt 1                                   */
  EVENTROUTER_IRQn                  = 42,  /*!<  42  Event router interrupt                                    */
  C_CAN1_IRQn                       = 43,  /*!<  43  C_CAN1 interrupt                                          */

  ADCHS_IRQn                        = 45,  /*!<  45  ADCHS combined interrupt                                  */
  ATIMER_IRQn                       = 46,  /*!<  46  Alarm timer interrupt                                     */
  RTC_IRQn                          = 47,  /*!<  47  RTC interrupt                                             */

  WWDT_IRQn                         = 49,  /*!<  49  WWDT interrupt                                            */
  M0SUB_IRQn                        = 50,  /*!<  50  TXEV instruction from the M0 subsystem core interrupt     */
  C_CAN0_IRQn                       = 51,  /*!<  51  C_CAN0 interrupt                                          */
  QEI_IRQn                          = 52,  /*!<  52  QEI interrupt                                             */
#endif
#ifdef CORE_M0
/* -------------------  Cortex-M0 Processor Exceptions Numbers  ------------------- */
  NonMaskableInt_IRQn               = -14, /*!<   2  Non maskable Interrupt, cannot be stopped or preempted    */
  HardFault_IRQn                    = -13, /*!<   3  Hard Fault, all classes of Fault                          */
                                
                                
                                
  SVCall_IRQn                       =  -5, /*!<  11  System Service Call via SVC instruction                   */
                                
  PendSV_IRQn                       =  -2, /*!<  14  Pendable request for system service                       */
  SysTick_IRQn                      =  -1, /*!<  15  System Tick Timer                                         */
// ---------------------------  LPC43xx/M0App Specific Interrupt Numbers  -------------------------
  M0_RTC_IRQn                       =  0,  /*!<   0  RTC interrupt                                             */
  M0_M4CORE_IRQn                    =  1,  /*!<   1  M4 core interrupt                                         */
  M0_DMA_IRQn                       =  2,  /*!<   2  DMA interrupt                                             */

  M0_FLASHEEPROMAT_IRQn             =  4,  /*!<   4  flash bank A, flash bank B, EEPROM, Atimer ORed interrupt */
  M0_ETHERNET_IRQn                  =  5,  /*!<   5  Ethernet interrupt                                        */
  M0_SDIO_IRQn                      =  6,  /*!<   6  SD/MMC interrupt                                          */
  M0_LCD_IRQn                       =  7,  /*!<   7  LCD interrupt                                             */
  M0_USB0_IRQn                      =  8,  /*!<   8  OTG interrupt                                             */
  M0_USB1_IRQn                      =  9,  /*!<   9  USB1 interrupt                                            */
  M0_SCT_IRQn                       = 10,  /*!<  10  SCT combined interrupt                                    */
  M0_RITIMER_OR_WWDT_IRQn           = 11,  /*!<  11  RI timer, WWDT ORed interrupt                             */
  M0_TIMER0_IRQn                    = 12,  /*!<  12  Timer 0 interrupt                                         */
  M0_GINT1_IRQn                     = 13,  /*!<  13  GPIO global interrupt 1                                   */
  M0_PIN_INT4_IRQn                  = 14,  /*!<  14  GPIO pin interrupt 4                                      */
  M0_TIMER3_IRQn                    = 15,  /*!<  15  Timer 3                                                   */
  M0_MCPWM_IRQn                     = 16,  /*!<  16  Motor control PWM interrupt                               */
  M0_ADC0_IRQn                      = 17,  /*!<  17  ADC0 interrupt                                            */
  M0_I2C0_OR_I2C1_IRQn              = 18,  /*!<  18  I2C0, I2C1 ORed interrupt                                 */
  M0_SGPIO_IRQn                     = 19,  /*!<  19  SGPIO interrupt                                           */
  M0_SPI_OR_DAC_IRQn                = 20,  /*!<  20  SPI, DAC ORed interrupt                                   */
  M0_ADC1_IRQn                      = 21,  /*!<  21  ADC1 interrupt                                            */
  M0_SSP0_OR_SSP1_IRQn              = 22,  /*!<  22  SSP0, SSP 1 ORed interrupt                                */
  M0_EVENTROUTER_IRQn               = 23,  /*!<  23  Event router interrupt                                    */
  M0_USART0_IRQn                    = 24,  /*!<  24  USART0 interrupt                                          */
  M0_UART1_IRQn                     = 25,  /*!<  25  Modem/UART1 interrupt                                     */
  M0_USART2_OR_C_CAN1_IRQn          = 26,  /*!<  26  USART2, C_CAN1 ORed interrupt                             */
  M0_USART3_IRQn                    = 27,  /*!<  27  USART3 interrupt                                          */
  M0_I2S0_OR_I2S1_QEI_IRQn          = 28,  /*!<  28  I2S0, I2S1, QEI ORed interrupt                            */
  M0_C_CAN0_IRQn                    = 29,  /*!<  29  C_CAN0 interrupt                                          */
  M0_SPIFI_OR_ADCHS_IRQn            = 30,  /*!<  30  SPIFI, ADCHS ORed interrupt                               */
  M0_M0SUB_IRQn                     = 31,  /*!<  31  M0SUB core interrupt                                      */
#endif
#ifdef CORE_M0SUB
/* -------------------  Cortex-M0 Processor Exceptions Numbers  ------------------- */
  NonMaskableInt_IRQn               = -14, /*!<   2  Non maskable Interrupt, cannot be stopped or preempted    */
  HardFault_IRQn                    = -13, /*!<   3  Hard Fault, all classes of Fault                          */
                                
                                
                                
  SVCall_IRQn                       =  -5, /*!<  11  System Service Call via SVC instruction                   */
                                
  PendSV_IRQn                       =  -2, /*!<  14  Pendable request for system service                       */
  SysTick_IRQn                      =  -1, /*!<  15  System Tick Timer                                         */
// ---------------------------  LPC43xx/M0Sub Specific Interrupt Numbers  -------------------------
  M0S_RTC_IRQn                      =  0,  /*!<   0  RTC interrupt                                             */
  M0S_M4CORE_IRQn                   =  1,  /*!<   1  M4 core interrupt                                         */
  M0S_DMA_IRQn                      =  2,  /*!<   2  DMA interrupt                                             */
                                                   
  M0S_SGPIO_INPUT_IRQn              =  4,  /*!<   4  SGPIO input bit match interrupt                           */
  M0S_SGPIO_MATCH_IRQn              =  5,  /*!<   5  SGPIO pattern match interrupt                             */
  M0S_SGPIO_SHIFT_IRQn              =  6,  /*!<   6  SGPIO shift clock interrupt                               */
  M0S_SGPIO_POS_IRQn                =  7,  /*!<   7  SGPIO capture clock interrupt                             */
  M0S_USB0_IRQn                     =  8,  /*!<   8  OTG interrupt                                             */
  M0S_USB1_IRQn                     =  9,  /*!<   9  USB1 interrupt                                            */
  M0S_SCT_IRQn                      = 10,  /*!<  10  SCT combined interrupt                                     */
  M0S_RITIMER_IRQn                  = 11,  /*!<  11  RI timer interrupt                                        */
  M0S_GINT1_IRQn                    = 12,  /*!<  12  GPIO global interrupt 1                                   */
  M0S_TIMER1_IRQn                   = 13,  /*!<  13  Timer 1 interrupt                                         */
  M0S_TIMER2_IRQn                   = 14,  /*!<  14  Timer 2 interrupt                                         */
  M0S_PIN_INT5_IRQn                 = 15,  /*!<  15  GPIO pin interrupt 5                                      */
  M0S_MCPWM_IRQn                    = 16,  /*!<  16  Motor control PWM interrupt                               */
  M0S_ADC0_IRQn                     = 17,  /*!<  17  ADC0 interrupt                                            */
  M0S_I2C0_IRQn                     = 18,  /*!<  18  I2C0 interrupt                                            */
  M0S_I2C1_IRQn                     = 19,  /*!<  19  I2C1 interrupt                                            */
  M0S_SPI_IRQn                      = 20,  /*!<  20  SPI interrupt                                             */
  M0S_ADC1_IRQn                     = 21,  /*!<  21  ADC1 interrupt                                            */
  M0S_SSP0_OR_SSP1_IRQn             = 22,  /*!<  22  SSP0, SSP1 ORed interrupt                                 */
  M0S_EVENTROUTER_IRQn              = 23,  /*!<  23  Event router interrupt                                    */
  M0S_USART0_IRQn                   = 24,  /*!<  24  USART0 interrupt                                          */
  M0S_UART1_IRQn                    = 25,  /*!<  25  Modem/UART1 interrupt                                     */
  M0S_USART2_OR_C_CAN1_IRQn         = 26,  /*!<  26  USART2, C_CAN1 ORed interrupt                             */
  M0S_USART3_IRQn                   = 27,  /*!<  27  USART3 interrupt                                          */
  M0S_I2S0_OR_I2S1_OR_QEI_IRQn      = 28,  /*!<  28  I2S0, I2S1, QEI ORed interrupt                            */
  M0S_C_CAN0_IRQn                   = 29,  /*!<  29  C_CAN0 interrupt                                          */
  M0S_SPIFI_OR_ADCHS_IRQn           = 30,  /*!<  30  SPIFI, ADCHS ORed interrupt                               */
  M0S_M0APP_IRQn                    = 31,  /*!<  31  M0APP core interrupt                                      */
#endif
} IRQn_Type;

 /* Event Router Input (ERI) Number Definitions */
typedef enum {
  WAKEUP0_ERIn                      = 0,
  WAKEUP1_ERIn                      = 1,
  WAKEUP2_ERIn                      = 2,
  WAKEUP3_ERIn                      = 3,
  ATIMER_ERIn                       = 4,
  RTC_ERIn                          = 5,
  BOD1_ERIn                         = 6,  /* Bod trip 1 */
  WWDT_ERIn                         = 7,
  ETH_ERIn                          = 8,
  USB0_ERIn                         = 9,
  USB1_ERIn                         = 10,
  SDIO_ERIn                         = 11,
  CAN_ERIn                          = 12, /* CAN0/1 or'ed */
  TIM2_ERIn                         = 13,
  TIM6_ERIn                         = 14,
  QEI_ERIn                          = 15,
  TIM14_ERIn                        = 16,
  RESERVED0_ERIn                    = 17, /* M0s */
  RESERVED1_ERIn                    = 18, /* M3/M4 */
  RESET_ERIn                        = 19
}ERIn_Type;

/** @addtogroup Configuration_of_CMSIS
  * @{
  */


/* ================================================================================ */
/* ================      Processor and Core Peripheral Section     ================ */
/* ================================================================================ */

#if defined CORE_M4
/* ----------------Configuration of the Cortex-M4 Processor and Core Peripherals---------------- */
#define __CM4_REV                 0x0000            /*!< Cortex-M4 Core Revision                                               */
#define __MPU_PRESENT                  1            /*!< MPU present or not                                                    */
#define __NVIC_PRIO_BITS               3            /*!< Number of Bits used for Priority Levels                               */
#define __Vendor_SysTickConfig         0            /*!< Set to 1 if different SysTick Config is used                          */
#define __FPU_PRESENT                  1            /*!< FPU present or not                                                    */

#include "core_cm4.h"                               /*!< Cortex-M4 processor and core peripherals                              */
#endif

#if defined CORE_M0 || defined CORE_M0SUB
/* ----------------Configuration of the Cortex-M0 Processor and Core Peripherals---------------- */
#define __MPU_PRESENT             0                 /*!< MPU present or not                                                    */
#define __NVIC_PRIO_BITS          2                 /*!< Number of Bits used for Priority Levels                               */
#define __Vendor_SysTickConfig    0                 /*!< Set to 1 if different SysTick Config is used                          */
#define __FPU_PRESENT             0                 /*!< FPU present or not                                                    */

#include "core_cm0.h"                               /*!< Cortex-M4 processor and core peripherals                              */
#endif

/** @} */ /* End of group Configuration_of_CMSIS */
#include "system_LPC43xx.h"                         /*!< LPC43xx System                                                        */


/* ================================================================================ */
/* ================       Device Specific Peripheral Section       ================ */
/* ================================================================================ */


/** @addtogroup Device_Peripheral_Registers
  * @{
  */


/* -------------------  Start of section using anonymous unions  ------------------ */
#if defined(__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined(__ICCARM__)
  #pragma language=extended
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__TMS470__)
/* anonymous unions are enabled by default */
#elif defined(__TASKING__)
  #pragma warning 586
#else
  #warning Not supported compiler type
#endif



/* ================================================================================ */
/* ================                       SCT                      ================ */
/* ================================================================================ */


/**
  * @brief State Configurable Timer (SCT) with dither engine  (SCT)
  */

typedef struct {                                    /*!< (@ 0x40000000) SCT Structure                                          */
  __IO uint32_t  CONFIG;                            /*!< (@ 0x40000000) SCT configuration register                             */
  __IO uint32_t  CTRL;                              /*!< (@ 0x40000004) SCT control register                                   */
  __IO uint32_t  LIMIT;                             /*!< (@ 0x40000008) SCT limit register                                     */
  __IO uint32_t  HALT;                              /*!< (@ 0x4000000C) SCT halt condition register                            */
  __IO uint32_t  STOP;                              /*!< (@ 0x40000010) SCT stop condition register                            */
  __IO uint32_t  START;                             /*!< (@ 0x40000014) SCT start condition register                           */
  __IO uint32_t  DITHER;                            /*!< (@ 0x40000018) SCT dither condition register                          */
  __I  uint32_t  RESERVED0[9];
  __IO uint32_t  COUNT;                             /*!< (@ 0x40000040) SCT counter register                                   */
  __IO uint32_t  STATE;                             /*!< (@ 0x40000044) SCT state register                                     */
  __I  uint32_t  INPUT;                             /*!< (@ 0x40000048) SCT input register                                     */
  __IO uint32_t  REGMODE;                           /*!< (@ 0x4000004C) SCT match/capture registers mode register              */
  __IO uint32_t  OUTPUT;                            /*!< (@ 0x40000050) SCT output register                                    */
  __IO uint32_t  OUTPUTDIRCTRL;                     /*!< (@ 0x40000054) SCT output counter direction control register          */
  __IO uint32_t  RES;                               /*!< (@ 0x40000058) SCT conflict resolution register                       */
  __IO uint32_t  DMAREQ0;                           /*!< (@ 0x4000005C) SCT DMA request 0 register                             */
  __IO uint32_t  DMAREQ1;                           /*!< (@ 0x40000060) SCT DMA request 1 register                             */
  __I  uint32_t  RESERVED1[35];
  __IO uint32_t  EVEN;                              /*!< (@ 0x400000F0) SCT event enable register                              */
  __IO uint32_t  EVFLAG;                            /*!< (@ 0x400000F4) SCT event flag register                                */
  __IO uint32_t  CONEN;                             /*!< (@ 0x400000F8) SCT conflict enable register                           */
  __IO uint32_t  CONFLAG;                           /*!< (@ 0x400000FC) SCT conflict flag register                             */
  
  union {
    __IO uint32_t  CAP0;                            /*!< (@ 0x40000100) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
    __IO uint32_t  MATCH0;                          /*!< (@ 0x40000100) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
  };
  
  union {
    __IO uint32_t  CAP1;                            /*!< (@ 0x40000104) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
    __IO uint32_t  MATCH1;                          /*!< (@ 0x40000104) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
  };
  
  union {
    __IO uint32_t  CAP2;                            /*!< (@ 0x40000108) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
    __IO uint32_t  MATCH2;                          /*!< (@ 0x40000108) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
  };
  
  union {
    __IO uint32_t  CAP3;                            /*!< (@ 0x4000010C) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
    __IO uint32_t  MATCH3;                          /*!< (@ 0x4000010C) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
  };
  
  union {
    __IO uint32_t  MATCH4;                          /*!< (@ 0x40000110) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
    __IO uint32_t  CAP4;                            /*!< (@ 0x40000110) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
  };
  
  union {
    __IO uint32_t  CAP5;                            /*!< (@ 0x40000114) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
    __IO uint32_t  MATCH5;                          /*!< (@ 0x40000114) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
  };
  
  union {
    __IO uint32_t  MATCH6;                          /*!< (@ 0x40000118) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
    __IO uint32_t  CAP6;                            /*!< (@ 0x40000118) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
  };
  
  union {
    __IO uint32_t  MATCH7;                          /*!< (@ 0x4000011C) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
    __IO uint32_t  CAP7;                            /*!< (@ 0x4000011C) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
  };
  
  union {
    __IO uint32_t  MATCH8;                          /*!< (@ 0x40000120) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
    __IO uint32_t  CAP8;                            /*!< (@ 0x40000120) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
  };
  
  union {
    __IO uint32_t  MATCH9;                          /*!< (@ 0x40000124) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
    __IO uint32_t  CAP9;                            /*!< (@ 0x40000124) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
  };
  
  union {
    __IO uint32_t  MATCH10;                         /*!< (@ 0x40000128) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
    __IO uint32_t  CAP10;                           /*!< (@ 0x40000128) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
  };
  
  union {
    __IO uint32_t  MATCH11;                         /*!< (@ 0x4000012C) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
    __IO uint32_t  CAP11;                           /*!< (@ 0x4000012C) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
  };
  
  union {
    __IO uint32_t  MATCH12;                         /*!< (@ 0x40000130) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
    __IO uint32_t  CAP12;                           /*!< (@ 0x40000130) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
  };
  
  union {
    __IO uint32_t  CAP13;                           /*!< (@ 0x40000134) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
    __IO uint32_t  MATCH13;                         /*!< (@ 0x40000134) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
  };
  
  union {
    __IO uint32_t  MATCH14;                         /*!< (@ 0x40000138) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
    __IO uint32_t  CAP14;                           /*!< (@ 0x40000138) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
  };
  
  union {
    __IO uint32_t  CAP15;                           /*!< (@ 0x4000013C) SCT capture register of capture channel 0 to
                                                         15; REGMOD0 to REGMODE15 = 1                                          */
    __IO uint32_t  MATCH15;                         /*!< (@ 0x4000013C) SCT match value register of match channels 0
                                                         to 15; REGMOD0 to REGMODE15 = 0                                       */
  };
  __IO uint32_t  FRACMAT0;                          /*!< (@ 0x40000140) Fractional match registers 0 to 5 for SCT match
                                                         value registers 0 to 5.                                               */
  __IO uint32_t  FRACMAT1;                          /*!< (@ 0x40000144) Fractional match registers 0 to 5 for SCT match
                                                         value registers 0 to 5.                                               */
  __IO uint32_t  FRACMAT2;                          /*!< (@ 0x40000148) Fractional match registers 0 to 5 for SCT match
                                                         value registers 0 to 5.                                               */
  __IO uint32_t  FRACMAT3;                          /*!< (@ 0x4000014C) Fractional match registers 0 to 5 for SCT match
                                                         value registers 0 to 5.                                               */
  __IO uint32_t  FRACMAT4;                          /*!< (@ 0x40000150) Fractional match registers 0 to 5 for SCT match
                                                         value registers 0 to 5.                                               */
  __IO uint32_t  FRACMAT5;                          /*!< (@ 0x40000154) Fractional match registers 0 to 5 for SCT match
                                                         value registers 0 to 5.                                               */
  __I  uint32_t  RESERVED2[42];
  
  union {
    __IO uint32_t  CAPCTRL0;                        /*!< (@ 0x40000200) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
    __IO uint32_t  MATCHREL0;                       /*!< (@ 0x40000200) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
  };
  
  union {
    __IO uint32_t  MATCHREL1;                       /*!< (@ 0x40000204) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
    __IO uint32_t  CAPCTRL1;                        /*!< (@ 0x40000204) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
  };
  
  union {
    __IO uint32_t  CAPCTRL2;                        /*!< (@ 0x40000208) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
    __IO uint32_t  MATCHREL2;                       /*!< (@ 0x40000208) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
  };
  
  union {
    __IO uint32_t  MATCHREL3;                       /*!< (@ 0x4000020C) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
    __IO uint32_t  CAPCTRL3;                        /*!< (@ 0x4000020C) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
  };
  
  union {
    __IO uint32_t  CAPCTRL4;                        /*!< (@ 0x40000210) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
    __IO uint32_t  MATCHREL4;                       /*!< (@ 0x40000210) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
  };
  
  union {
    __IO uint32_t  CAPCTRL5;                        /*!< (@ 0x40000214) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
    __IO uint32_t  MATCHREL5;                       /*!< (@ 0x40000214) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
  };
  
  union {
    __IO uint32_t  MATCHREL6;                       /*!< (@ 0x40000218) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
    __IO uint32_t  CAPCTRL6;                        /*!< (@ 0x40000218) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
  };
  
  union {
    __IO uint32_t  CAPCTRL7;                        /*!< (@ 0x4000021C) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
    __IO uint32_t  MATCHREL7;                       /*!< (@ 0x4000021C) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
  };
  
  union {
    __IO uint32_t  MATCHREL8;                       /*!< (@ 0x40000220) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
    __IO uint32_t  CAPCTRL8;                        /*!< (@ 0x40000220) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
  };
  
  union {
    __IO uint32_t  CAPCTRL9;                        /*!< (@ 0x40000224) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
    __IO uint32_t  MATCHREL9;                       /*!< (@ 0x40000224) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
  };
  
  union {
    __IO uint32_t  MATCHREL10;                      /*!< (@ 0x40000228) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
    __IO uint32_t  CAPCTRL10;                       /*!< (@ 0x40000228) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
  };
  
  union {
    __IO uint32_t  MATCHREL11;                      /*!< (@ 0x4000022C) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
    __IO uint32_t  CAPCTRL11;                       /*!< (@ 0x4000022C) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
  };
  
  union {
    __IO uint32_t  MATCHREL12;                      /*!< (@ 0x40000230) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
    __IO uint32_t  CAPCTRL12;                       /*!< (@ 0x40000230) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
  };
  
  union {
    __IO uint32_t  CAPCTRL13;                       /*!< (@ 0x40000234) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
    __IO uint32_t  MATCHREL13;                      /*!< (@ 0x40000234) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
  };
  
  union {
    __IO uint32_t  CAPCTRL14;                       /*!< (@ 0x40000238) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
    __IO uint32_t  MATCHREL14;                      /*!< (@ 0x40000238) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
  };
  
  union {
    __IO uint32_t  CAPCTRL15;                       /*!< (@ 0x4000023C) SCT capture control register 0 to 15; REGMOD0
                                                         = 1 to REGMODE15 = 1                                                  */
    __IO uint32_t  MATCHREL15;                      /*!< (@ 0x4000023C) SCT match reload value register 0 to 15; REGMOD0
                                                         = 0 to REGMODE15 = 0                                                  */
  };
  __IO uint32_t  FRACMATREL0;                       /*!< (@ 0x40000240) Fractional match reload registers 0 to 5 for
                                                         SCT match value registers 0 to 5.                                     */
  __IO uint32_t  FRACMATREL1;                       /*!< (@ 0x40000244) Fractional match reload registers 0 to 5 for
                                                         SCT match value registers 0 to 5.                                     */
  __IO uint32_t  FRACMATREL2;                       /*!< (@ 0x40000248) Fractional match reload registers 0 to 5 for
                                                         SCT match value registers 0 to 5.                                     */
  __IO uint32_t  FRACMATREL3;                       /*!< (@ 0x4000024C) Fractional match reload registers 0 to 5 for
                                                         SCT match value registers 0 to 5.                                     */
  __IO uint32_t  FRACMATREL4;                       /*!< (@ 0x40000250) Fractional match reload registers 0 to 5 for
                                                         SCT match value registers 0 to 5.                                     */
  __IO uint32_t  FRACMATREL5;                       /*!< (@ 0x40000254) Fractional match reload registers 0 to 5 for
                                                         SCT match value registers 0 to 5.                                     */
  __I  uint32_t  RESERVED3[42];
  __IO uint32_t  EV0_STATE;                         /*!< (@ 0x40000300) SCT event state register 0                             */
  __IO uint32_t  EV0_CTRL;                          /*!< (@ 0x40000304) SCT event control register 0                           */
  __IO uint32_t  EV1_STATE;                         /*!< (@ 0x40000308) SCT event state register 0                             */
  __IO uint32_t  EV1_CTRL;                          /*!< (@ 0x4000030C) SCT event control register 0                           */
  __IO uint32_t  EV2_STATE;                         /*!< (@ 0x40000310) SCT event state register 0                             */
  __IO uint32_t  EV2_CTRL;                          /*!< (@ 0x40000314) SCT event control register 0                           */
  __IO uint32_t  EV3_STATE;                         /*!< (@ 0x40000318) SCT event state register 0                             */
  __IO uint32_t  EV3_CTRL;                          /*!< (@ 0x4000031C) SCT event control register 0                           */
  __IO uint32_t  EV4_STATE;                         /*!< (@ 0x40000320) SCT event state register 0                             */
  __IO uint32_t  EV4_CTRL;                          /*!< (@ 0x40000324) SCT event control register 0                           */
  __IO uint32_t  EV5_STATE;                         /*!< (@ 0x40000328) SCT event state register 0                             */
  __IO uint32_t  EV5_CTRL;                          /*!< (@ 0x4000032C) SCT event control register 0                           */
  __IO uint32_t  EV6_STATE;                         /*!< (@ 0x40000330) SCT event state register 0                             */
  __IO uint32_t  EV6_CTRL;                          /*!< (@ 0x40000334) SCT event control register 0                           */
  __IO uint32_t  EV7_STATE;                         /*!< (@ 0x40000338) SCT event state register 0                             */
  __IO uint32_t  EV7_CTRL;                          /*!< (@ 0x4000033C) SCT event control register 0                           */
  __IO uint32_t  EV8_STATE;                         /*!< (@ 0x40000340) SCT event state register 0                             */
  __IO uint32_t  EV8_CTRL;                          /*!< (@ 0x40000344) SCT event control register 0                           */
  __IO uint32_t  EV9_STATE;                         /*!< (@ 0x40000348) SCT event state register 0                             */
  __IO uint32_t  EV9_CTRL;                          /*!< (@ 0x4000034C) SCT event control register 0                           */
  __IO uint32_t  EV10_STATE;                        /*!< (@ 0x40000350) SCT event state register 0                             */
  __IO uint32_t  EV10_CTRL;                         /*!< (@ 0x40000354) SCT event control register 0                           */
  __IO uint32_t  EV11_STATE;                        /*!< (@ 0x40000358) SCT event state register 0                             */
  __IO uint32_t  EV11_CTRL;                         /*!< (@ 0x4000035C) SCT event control register 0                           */
  __IO uint32_t  EV12_STATE;                        /*!< (@ 0x40000360) SCT event state register 0                             */
  __IO uint32_t  EV12_CTRL;                         /*!< (@ 0x40000364) SCT event control register 0                           */
  __IO uint32_t  EV13_STATE;                        /*!< (@ 0x40000368) SCT event state register 0                             */
  __IO uint32_t  EV13_CTRL;                         /*!< (@ 0x4000036C) SCT event control register 0                           */
  __IO uint32_t  EV14_STATE;                        /*!< (@ 0x40000370) SCT event state register 0                             */
  __IO uint32_t  EV14_CTRL;                         /*!< (@ 0x40000374) SCT event control register 0                           */
  __IO uint32_t  EV15_STATE;                        /*!< (@ 0x40000378) SCT event state register 0                             */
  __IO uint32_t  EV15_CTRL;                         /*!< (@ 0x4000037C) SCT event control register 0                           */
  __I  uint32_t  RESERVED4[96];
  __IO uint32_t  OUT0_SET;                          /*!< (@ 0x40000500) SCT output 0 set register                              */
  __IO uint32_t  OUT0_CLR;                          /*!< (@ 0x40000504) SCT output 0 clear register                            */
  __IO uint32_t  OUT1_SET;                          /*!< (@ 0x40000508) SCT output 0 set register                              */
  __IO uint32_t  OUT1_CLR;                          /*!< (@ 0x4000050C) SCT output 0 clear register                            */
  __IO uint32_t  OUT2_SET;                          /*!< (@ 0x40000510) SCT output 0 set register                              */
  __IO uint32_t  OUT2_CLR;                          /*!< (@ 0x40000514) SCT output 0 clear register                            */
  __IO uint32_t  OUT3_SET;                          /*!< (@ 0x40000518) SCT output 0 set register                              */
  __IO uint32_t  OUT3_CLR;                          /*!< (@ 0x4000051C) SCT output 0 clear register                            */
  __IO uint32_t  OUT4_SET;                          /*!< (@ 0x40000520) SCT output 0 set register                              */
  __IO uint32_t  OUT4_CLR;                          /*!< (@ 0x40000524) SCT output 0 clear register                            */
  __IO uint32_t  OUT5_SET;                          /*!< (@ 0x40000528) SCT output 0 set register                              */
  __IO uint32_t  OUT5_CLR;                          /*!< (@ 0x4000052C) SCT output 0 clear register                            */
  __IO uint32_t  OUT6_SET;                          /*!< (@ 0x40000530) SCT output 0 set register                              */
  __IO uint32_t  OUT6_CLR;                          /*!< (@ 0x40000534) SCT output 0 clear register                            */
  __IO uint32_t  OUT7_SET;                          /*!< (@ 0x40000538) SCT output 0 set register                              */
  __IO uint32_t  OUT7_CLR;                          /*!< (@ 0x4000053C) SCT output 0 clear register                            */
  __IO uint32_t  OUT8_SET;                          /*!< (@ 0x40000540) SCT output 0 set register                              */
  __IO uint32_t  OUT8_CLR;                          /*!< (@ 0x40000544) SCT output 0 clear register                            */
  __IO uint32_t  OUT9_SET;                          /*!< (@ 0x40000548) SCT output 0 set register                              */
  __IO uint32_t  OUT9_CLR;                          /*!< (@ 0x4000054C) SCT output 0 clear register                            */
  __IO uint32_t  OUT10_SET;                         /*!< (@ 0x40000550) SCT output 0 set register                              */
  __IO uint32_t  OUT10_CLR;                         /*!< (@ 0x40000554) SCT output 0 clear register                            */
  __IO uint32_t  OUT11_SET;                         /*!< (@ 0x40000558) SCT output 0 set register                              */
  __IO uint32_t  OUT11_CLR;                         /*!< (@ 0x4000055C) SCT output 0 clear register                            */
  __IO uint32_t  OUT12_SET;                         /*!< (@ 0x40000560) SCT output 0 set register                              */
  __IO uint32_t  OUT12_CLR;                         /*!< (@ 0x40000564) SCT output 0 clear register                            */
  __IO uint32_t  OUT13_SET;                         /*!< (@ 0x40000568) SCT output 0 set register                              */
  __IO uint32_t  OUT13_CLR;                         /*!< (@ 0x4000056C) SCT output 0 clear register                            */
  __IO uint32_t  OUT14_SET;                         /*!< (@ 0x40000570) SCT output 0 set register                              */
  __IO uint32_t  OUT14_CLR;                         /*!< (@ 0x40000574) SCT output 0 clear register                            */
  __IO uint32_t  OUT15_SET;                         /*!< (@ 0x40000578) SCT output 0 set register                              */
  __IO uint32_t  OUT15_CLR;                         /*!< (@ 0x4000057C) SCT output 0 clear register                            */
} LPC_SCT_Type;


/* ================================================================================ */
/* ================                      GPDMA                     ================ */
/* ================================================================================ */


/**
  * @brief General Purpose DMA (GPDMA)  (GPDMA)
  */

typedef struct {                                    /*!< (@ 0x40002000) GPDMA Structure                                        */
  __I  uint32_t  INTSTAT;                           /*!< (@ 0x40002000) DMA Interrupt Status Register                          */
  __I  uint32_t  INTTCSTAT;                         /*!< (@ 0x40002004) DMA Interrupt Terminal Count Request Status Register   */
  __O  uint32_t  INTTCCLEAR;                        /*!< (@ 0x40002008) DMA Interrupt Terminal Count Request Clear Register    */
  __I  uint32_t  INTERRSTAT;                        /*!< (@ 0x4000200C) DMA Interrupt Error Status Register                    */
  __O  uint32_t  INTERRCLR;                         /*!< (@ 0x40002010) DMA Interrupt Error Clear Register                     */
  __I  uint32_t  RAWINTTCSTAT;                      /*!< (@ 0x40002014) DMA Raw Interrupt Terminal Count Status Register       */
  __I  uint32_t  RAWINTERRSTAT;                     /*!< (@ 0x40002018) DMA Raw Error Interrupt Status Register                */
  __I  uint32_t  ENBLDCHNS;                         /*!< (@ 0x4000201C) DMA Enabled Channel Register                           */
  __IO uint32_t  SOFTBREQ;                          /*!< (@ 0x40002020) DMA Software Burst Request Register                    */
  __IO uint32_t  SOFTSREQ;                          /*!< (@ 0x40002024) DMA Software Single Request Register                   */
  __IO uint32_t  SOFTLBREQ;                         /*!< (@ 0x40002028) DMA Software Last Burst Request Register               */
  __IO uint32_t  SOFTLSREQ;                         /*!< (@ 0x4000202C) DMA Software Last Single Request Register              */
  __IO uint32_t  CONFIG;                            /*!< (@ 0x40002030) DMA Configuration Register                             */
  __IO uint32_t  SYNC;                              /*!< (@ 0x40002034) DMA Synchronization Register                           */
  __I  uint32_t  RESERVED0[50];
  __IO uint32_t  C0SRCADDR;                         /*!< (@ 0x40002100) DMA Channel Source Address Register                    */
  __IO uint32_t  C0DESTADDR;                        /*!< (@ 0x40002104) DMA Channel Destination Address Register               */
  __IO uint32_t  C0LLI;                             /*!< (@ 0x40002108) DMA Channel Linked List Item Register                  */
  __IO uint32_t  C0CONTROL;                         /*!< (@ 0x4000210C) DMA Channel Control Register                           */
  __IO uint32_t  C0CONFIG;                          /*!< (@ 0x40002110) DMA Channel Configuration Register                     */
  __I  uint32_t  RESERVED1[3];
  __IO uint32_t  C1SRCADDR;                         /*!< (@ 0x40002120) DMA Channel Source Address Register                    */
  __IO uint32_t  C1DESTADDR;                        /*!< (@ 0x40002124) DMA Channel Destination Address Register               */
  __IO uint32_t  C1LLI;                             /*!< (@ 0x40002128) DMA Channel Linked List Item Register                  */
  __IO uint32_t  C1CONTROL;                         /*!< (@ 0x4000212C) DMA Channel Control Register                           */
  __IO uint32_t  C1CONFIG;                          /*!< (@ 0x40002130) DMA Channel Configuration Register                     */
  __I  uint32_t  RESERVED2[3];
  __IO uint32_t  C2SRCADDR;                         /*!< (@ 0x40002140) DMA Channel Source Address Register                    */
  __IO uint32_t  C2DESTADDR;                        /*!< (@ 0x40002144) DMA Channel Destination Address Register               */
  __IO uint32_t  C2LLI;                             /*!< (@ 0x40002148) DMA Channel Linked List Item Register                  */
  __IO uint32_t  C2CONTROL;                         /*!< (@ 0x4000214C) DMA Channel Control Register                           */
  __IO uint32_t  C2CONFIG;                          /*!< (@ 0x40002150) DMA Channel Configuration Register                     */
  __I  uint32_t  RESERVED3[3];
  __IO uint32_t  C3SRCADDR;                         /*!< (@ 0x40002160) DMA Channel Source Address Register                    */
  __IO uint32_t  C3DESTADDR;                        /*!< (@ 0x40002164) DMA Channel Destination Address Register               */
  __IO uint32_t  C3LLI;                             /*!< (@ 0x40002168) DMA Channel Linked List Item Register                  */
  __IO uint32_t  C3CONTROL;                         /*!< (@ 0x4000216C) DMA Channel Control Register                           */
  __IO uint32_t  C3CONFIG;                          /*!< (@ 0x40002170) DMA Channel Configuration Register                     */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  C4SRCADDR;                         /*!< (@ 0x40002180) DMA Channel Source Address Register                    */
  __IO uint32_t  C4DESTADDR;                        /*!< (@ 0x40002184) DMA Channel Destination Address Register               */
  __IO uint32_t  C4LLI;                             /*!< (@ 0x40002188) DMA Channel Linked List Item Register                  */
  __IO uint32_t  C4CONTROL;                         /*!< (@ 0x4000218C) DMA Channel Control Register                           */
  __IO uint32_t  C4CONFIG;                          /*!< (@ 0x40002190) DMA Channel Configuration Register                     */
  __I  uint32_t  RESERVED5[3];
  __IO uint32_t  C5SRCADDR;                         /*!< (@ 0x400021A0) DMA Channel Source Address Register                    */
  __IO uint32_t  C5DESTADDR;                        /*!< (@ 0x400021A4) DMA Channel Destination Address Register               */
  __IO uint32_t  C5LLI;                             /*!< (@ 0x400021A8) DMA Channel Linked List Item Register                  */
  __IO uint32_t  C5CONTROL;                         /*!< (@ 0x400021AC) DMA Channel Control Register                           */
  __IO uint32_t  C5CONFIG;                          /*!< (@ 0x400021B0) DMA Channel Configuration Register                     */
  __I  uint32_t  RESERVED6[3];
  __IO uint32_t  C6SRCADDR;                         /*!< (@ 0x400021C0) DMA Channel Source Address Register                    */
  __IO uint32_t  C6DESTADDR;                        /*!< (@ 0x400021C4) DMA Channel Destination Address Register               */
  __IO uint32_t  C6LLI;                             /*!< (@ 0x400021C8) DMA Channel Linked List Item Register                  */
  __IO uint32_t  C6CONTROL;                         /*!< (@ 0x400021CC) DMA Channel Control Register                           */
  __IO uint32_t  C6CONFIG;                          /*!< (@ 0x400021D0) DMA Channel Configuration Register                     */
  __I  uint32_t  RESERVED7[3];
  __IO uint32_t  C7SRCADDR;                         /*!< (@ 0x400021E0) DMA Channel Source Address Register                    */
  __IO uint32_t  C7DESTADDR;                        /*!< (@ 0x400021E4) DMA Channel Destination Address Register               */
  __IO uint32_t  C7LLI;                             /*!< (@ 0x400021E8) DMA Channel Linked List Item Register                  */
  __IO uint32_t  C7CONTROL;                         /*!< (@ 0x400021EC) DMA Channel Control Register                           */
  __IO uint32_t  C7CONFIG;                          /*!< (@ 0x400021F0) DMA Channel Configuration Register                     */
} LPC_GPDMA_Type;


/* ================================================================================ */
/* ================                      SPIFI                     ================ */
/* ================================================================================ */


/**
  * @brief SPI Flash Interface (SPIFI) (SPIFI)
  */

typedef struct {                                    /*!< (@ 0x40003000) SPIFI Structure                                        */
  __IO uint32_t  CTRL;                              /*!< (@ 0x40003000) SPIFI control register                                 */
  __IO uint32_t  CMD;                               /*!< (@ 0x40003004) SPIFI command register                                 */
  __IO uint32_t  ADDR;                              /*!< (@ 0x40003008) SPIFI address register                                 */
  __IO uint32_t  IDATA;                             /*!< (@ 0x4000300C) SPIFI intermediate data register                       */
  __IO uint32_t  CLIMIT;                            /*!< (@ 0x40003010) SPIFI cache limit register                             */
  __IO uint32_t  DATA;                              /*!< (@ 0x40003014) SPIFI data register                                    */
  __IO uint32_t  MCMD;                              /*!< (@ 0x40003018) SPIFI memory command register                          */
  __IO uint32_t  STAT;                              /*!< (@ 0x4000301C) SPIFI status register                                  */
} LPC_SPIFI_Type;


/* ================================================================================ */
/* ================                      SDMMC                     ================ */
/* ================================================================================ */


/**
  * @brief SD/MMC (SDMMC)
  */

typedef struct {                                    /*!< (@ 0x40004000) SDMMC Structure                                        */
  __IO uint32_t  CTRL;                              /*!< (@ 0x40004000) Control Register                                       */
  __IO uint32_t  PWREN;                             /*!< (@ 0x40004004) Power Enable Register                                  */
  __IO uint32_t  CLKDIV;                            /*!< (@ 0x40004008) Clock Divider Register                                 */
  __IO uint32_t  CLKSRC;                            /*!< (@ 0x4000400C) SD Clock Source Register                               */
  __IO uint32_t  CLKENA;                            /*!< (@ 0x40004010) Clock Enable Register                                  */
  __IO uint32_t  TMOUT;                             /*!< (@ 0x40004014) Time-out Register                                      */
  __IO uint32_t  CTYPE;                             /*!< (@ 0x40004018) Card Type Register                                     */
  __IO uint32_t  BLKSIZ;                            /*!< (@ 0x4000401C) Block Size Register                                    */
  __IO uint32_t  BYTCNT;                            /*!< (@ 0x40004020) Byte Count Register                                    */
  __IO uint32_t  INTMASK;                           /*!< (@ 0x40004024) Interrupt Mask Register                                */
  __IO uint32_t  CMDARG;                            /*!< (@ 0x40004028) Command Argument Register                              */
  __IO uint32_t  CMD;                               /*!< (@ 0x4000402C) Command Register                                       */
  __I  uint32_t  RESP0;                             /*!< (@ 0x40004030) Response Register 0                                    */
  __I  uint32_t  RESP1;                             /*!< (@ 0x40004034) Response Register 1                                    */
  __I  uint32_t  RESP2;                             /*!< (@ 0x40004038) Response Register 2                                    */
  __I  uint32_t  RESP3;                             /*!< (@ 0x4000403C) Response Register 3                                    */
  __I  uint32_t  MINTSTS;                           /*!< (@ 0x40004040) Masked Interrupt Status Register                       */
  __IO uint32_t  RINTSTS;                           /*!< (@ 0x40004044) Raw Interrupt Status Register                          */
  __I  uint32_t  STATUS;                            /*!< (@ 0x40004048) Status Register                                        */
  __IO uint32_t  FIFOTH;                            /*!< (@ 0x4000404C) FIFO Threshold Watermark Register                      */
  __I  uint32_t  CDETECT;                           /*!< (@ 0x40004050) Card Detect Register                                   */
  __I  uint32_t  WRTPRT;                            /*!< (@ 0x40004054) Write Protect Register                                 */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  TCBCNT;                            /*!< (@ 0x4000405C) Transferred CIU Card Byte Count Register               */
  __I  uint32_t  TBBCNT;                            /*!< (@ 0x40004060) Transferred Host to BIU-FIFO Byte Count Register       */
  __IO uint32_t  DEBNCE;                            /*!< (@ 0x40004064) Debounce Count Register                                */
  __I  uint32_t  RESERVED1[4];
  __IO uint32_t  RST_N;                             /*!< (@ 0x40004078) Hardware Reset                                         */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  BMOD;                              /*!< (@ 0x40004080) Bus Mode Register                                      */
  __O  uint32_t  PLDMND;                            /*!< (@ 0x40004084) Poll Demand Register                                   */
  __IO uint32_t  DBADDR;                            /*!< (@ 0x40004088) Descriptor List Base Address Register                  */
  __IO uint32_t  IDSTS;                             /*!< (@ 0x4000408C) Internal DMAC Status Register                          */
  __IO uint32_t  IDINTEN;                           /*!< (@ 0x40004090) Internal DMAC Interrupt Enable Register                */
  __I  uint32_t  DSCADDR;                           /*!< (@ 0x40004094) Current Host Descriptor Address Register               */
  __I  uint32_t  BUFADDR;                           /*!< (@ 0x40004098) Current Buffer Descriptor Address Register             */
} LPC_SDMMC_Type;


/* ================================================================================ */
/* ================                       EMC                      ================ */
/* ================================================================================ */


/**
  * @brief External Memory Controller (EMC)  (EMC)
  */

typedef struct {                                    /*!< (@ 0x40005000) EMC Structure                                          */
  __IO uint32_t  CONTROL;                           /*!< (@ 0x40005000) Controls operation of the memory controller.           */
  __I  uint32_t  STATUS;                            /*!< (@ 0x40005004) Provides EMC status information.                       */
  __IO uint32_t  CONFIG;                            /*!< (@ 0x40005008) Configures operation of the memory controller.         */
  __I  uint32_t  RESERVED0[5];
  __IO uint32_t  DYNAMICCONTROL;                    /*!< (@ 0x40005020) Controls dynamic memory operation.                     */
  __IO uint32_t  DYNAMICREFRESH;                    /*!< (@ 0x40005024) Configures dynamic memory refresh operation.           */
  __IO uint32_t  DYNAMICREADCONFIG;                 /*!< (@ 0x40005028) Configures the dynamic memory read strategy.           */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  DYNAMICRP;                         /*!< (@ 0x40005030) Selects the precharge command period.                  */
  __IO uint32_t  DYNAMICRAS;                        /*!< (@ 0x40005034) Selects the active to precharge command period.        */
  __IO uint32_t  DYNAMICSREX;                       /*!< (@ 0x40005038) Selects the self-refresh exit time.                    */
  __IO uint32_t  DYNAMICAPR;                        /*!< (@ 0x4000503C) Selects the last-data-out to active command time.      */
  __IO uint32_t  DYNAMICDAL;                        /*!< (@ 0x40005040) Selects the data-in to active command time.            */
  __IO uint32_t  DYNAMICWR;                         /*!< (@ 0x40005044) Selects the write recovery time.                       */
  __IO uint32_t  DYNAMICRC;                         /*!< (@ 0x40005048) Selects the active to active command period.           */
  __IO uint32_t  DYNAMICRFC;                        /*!< (@ 0x4000504C) Selects the auto-refresh period.                       */
  __IO uint32_t  DYNAMICXSR;                        /*!< (@ 0x40005050) Selects the exit self-refresh to active command
                                                         time.                                                                 */
  __IO uint32_t  DYNAMICRRD;                        /*!< (@ 0x40005054) Selects the active bank A to active bank B latency.    */
  __IO uint32_t  DYNAMICMRD;                        /*!< (@ 0x40005058) Selects the load mode register to active command
                                                         time.                                                                 */
  __I  uint32_t  RESERVED2[9];
  __IO uint32_t  STATICEXTENDEDWAIT;                /*!< (@ 0x40005080) Selects time for long static memory read and
                                                         write transfers.                                                      */
  __I  uint32_t  RESERVED3[31];
  __IO uint32_t  DYNAMICCONFIG0;                    /*!< (@ 0x40005100) Selects the configuration information for dynamic
                                                         memory chip select 0.                                                 */
  __IO uint32_t  DYNAMICRASCAS0;                    /*!< (@ 0x40005104) Selects the RAS and CAS latencies for dynamic
                                                         memory chip select 0.                                                 */
  __I  uint32_t  RESERVED4[6];
  __IO uint32_t  DYNAMICCONFIG1;                    /*!< (@ 0x40005120) Selects the configuration information for dynamic
                                                         memory chip select 0.                                                 */
  __IO uint32_t  DYNAMICRASCAS1;                    /*!< (@ 0x40005124) Selects the RAS and CAS latencies for dynamic
                                                         memory chip select 0.                                                 */
  __I  uint32_t  RESERVED5[6];
  __IO uint32_t  DYNAMICCONFIG2;                    /*!< (@ 0x40005140) Selects the configuration information for dynamic
                                                         memory chip select 0.                                                 */
  __IO uint32_t  DYNAMICRASCAS2;                    /*!< (@ 0x40005144) Selects the RAS and CAS latencies for dynamic
                                                         memory chip select 0.                                                 */
  __I  uint32_t  RESERVED6[6];
  __IO uint32_t  DYNAMICCONFIG3;                    /*!< (@ 0x40005160) Selects the configuration information for dynamic
                                                         memory chip select 0.                                                 */
  __IO uint32_t  DYNAMICRASCAS3;                    /*!< (@ 0x40005164) Selects the RAS and CAS latencies for dynamic
                                                         memory chip select 0.                                                 */
  __I  uint32_t  RESERVED7[38];
  __IO uint32_t  STATICCONFIG0;                     /*!< (@ 0x40005200) Selects the memory configuration for static chip
                                                         select 0.                                                             */
  __IO uint32_t  STATICWAITWEN0;                    /*!< (@ 0x40005204) Selects the delay from chip select 0 to write
                                                         enable.                                                               */
  __IO uint32_t  STATICWAITOEN0;                    /*!< (@ 0x40005208) Selects the delay from chip select 0 or address
                                                         change, whichever is later, to output enable.                         */
  __IO uint32_t  STATICWAITRD0;                     /*!< (@ 0x4000520C) Selects the delay from chip select 0 to a read
                                                         access.                                                               */
  __IO uint32_t  STATICWAITPAGE0;                   /*!< (@ 0x40005210) Selects the delay for asynchronous page mode
                                                         sequential accesses for chip select 0.                                */
  __IO uint32_t  STATICWAITWR0;                     /*!< (@ 0x40005214) Selects the delay from chip select 0 to a write
                                                         access.                                                               */
  __IO uint32_t  STATICWAITTURN0;                   /*!< (@ 0x40005218) Selects the number of bus turnaround cycles for
                                                         chip select 0.                                                        */
  __I  uint32_t  RESERVED8;
  __IO uint32_t  STATICCONFIG1;                     /*!< (@ 0x40005220) Selects the memory configuration for static chip
                                                         select 0.                                                             */
  __IO uint32_t  STATICWAITWEN1;                    /*!< (@ 0x40005224) Selects the delay from chip select 0 to write
                                                         enable.                                                               */
  __IO uint32_t  STATICWAITOEN1;                    /*!< (@ 0x40005228) Selects the delay from chip select 0 or address
                                                         change, whichever is later, to output enable.                         */
  __IO uint32_t  STATICWAITRD1;                     /*!< (@ 0x4000522C) Selects the delay from chip select 0 to a read
                                                         access.                                                               */
  __IO uint32_t  STATICWAITPAGE1;                   /*!< (@ 0x40005230) Selects the delay for asynchronous page mode
                                                         sequential accesses for chip select 0.                                */
  __IO uint32_t  STATICWAITWR1;                     /*!< (@ 0x40005234) Selects the delay from chip select 0 to a write
                                                         access.                                                               */
  __IO uint32_t  STATICWAITTURN1;                   /*!< (@ 0x40005238) Selects the number of bus turnaround cycles for
                                                         chip select 0.                                                        */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  STATICCONFIG2;                     /*!< (@ 0x40005240) Selects the memory configuration for static chip
                                                         select 0.                                                             */
  __IO uint32_t  STATICWAITWEN2;                    /*!< (@ 0x40005244) Selects the delay from chip select 0 to write
                                                         enable.                                                               */
  __IO uint32_t  STATICWAITOEN2;                    /*!< (@ 0x40005248) Selects the delay from chip select 0 or address
                                                         change, whichever is later, to output enable.                         */
  __IO uint32_t  STATICWAITRD2;                     /*!< (@ 0x4000524C) Selects the delay from chip select 0 to a read
                                                         access.                                                               */
  __IO uint32_t  STATICWAITPAGE2;                   /*!< (@ 0x40005250) Selects the delay for asynchronous page mode
                                                         sequential accesses for chip select 0.                                */
  __IO uint32_t  STATICWAITWR2;                     /*!< (@ 0x40005254) Selects the delay from chip select 0 to a write
                                                         access.                                                               */
  __IO uint32_t  STATICWAITTURN2;                   /*!< (@ 0x40005258) Selects the number of bus turnaround cycles for
                                                         chip select 0.                                                        */
  __I  uint32_t  RESERVED10;
  __IO uint32_t  STATICCONFIG3;                     /*!< (@ 0x40005260) Selects the memory configuration for static chip
                                                         select 0.                                                             */
  __IO uint32_t  STATICWAITWEN3;                    /*!< (@ 0x40005264) Selects the delay from chip select 0 to write
                                                         enable.                                                               */
  __IO uint32_t  STATICWAITOEN3;                    /*!< (@ 0x40005268) Selects the delay from chip select 0 or address
                                                         change, whichever is later, to output enable.                         */
  __IO uint32_t  STATICWAITRD3;                     /*!< (@ 0x4000526C) Selects the delay from chip select 0 to a read
                                                         access.                                                               */
  __IO uint32_t  STATICWAITPAGE3;                   /*!< (@ 0x40005270) Selects the delay for asynchronous page mode
                                                         sequential accesses for chip select 0.                                */
  __IO uint32_t  STATICWAITWR3;                     /*!< (@ 0x40005274) Selects the delay from chip select 0 to a write
                                                         access.                                                               */
  __IO uint32_t  STATICWAITTURN3;                   /*!< (@ 0x40005278) Selects the number of bus turnaround cycles for
                                                         chip select 0.                                                        */
} LPC_EMC_Type;


/* ================================================================================ */
/* ================                      USB0                      ================ */
/* ================================================================================ */


/**
  * @brief USB0 Host/Device/OTG controller (USB0)
  */

typedef struct {                                    /*!< (@ 0x40006000) USB0 Structure                                         */
  __I  uint32_t  RESERVED0[64];
  __I  uint32_t  CAPLENGTH;                         /*!< (@ 0x40006100) Capability register length                             */
  __I  uint32_t  HCSPARAMS;                         /*!< (@ 0x40006104) Host controller structural parameters                  */
  __I  uint32_t  HCCPARAMS;                         /*!< (@ 0x40006108) Host controller capability parameters                  */
  __I  uint32_t  RESERVED1[5];
  __I  uint32_t  DCIVERSION;                        /*!< (@ 0x40006120) Device interface version number                        */
  __I  uint32_t  RESERVED2[7];
  
  union {
    __IO uint32_t  USBCMD_H;                        /*!< (@ 0x40006140) USB command (host mode)                                */
    __IO uint32_t  USBCMD_D;                        /*!< (@ 0x40006140) USB command (device mode)                              */
  };
  
  union {
    __IO uint32_t  USBSTS_H;                        /*!< (@ 0x40006144) USB status (host mode)                                 */
    __IO uint32_t  USBSTS_D;                        /*!< (@ 0x40006144) USB status (device mode)                               */
  };
  
  union {
    __IO uint32_t  USBINTR_H;                       /*!< (@ 0x40006148) USB interrupt enable (host mode)                       */
    __IO uint32_t  USBINTR_D;                       /*!< (@ 0x40006148) USB interrupt enable (device mode)                     */
  };
  
  union {
    __IO uint32_t  FRINDEX_H;                       /*!< (@ 0x4000614C) USB frame index (host mode)                            */
    __IO uint32_t  FRINDEX_D;                       /*!< (@ 0x4000614C) USB frame index (device mode)                          */
  };
  __I  uint32_t  RESERVED3;
  
  union {
    __IO uint32_t  PERIODICLISTBASE;                /*!< (@ 0x40006154) Frame list base address (host mode)                    */
    __IO uint32_t  DEVICEADDR;                      /*!< (@ 0x40006154) USB device address (device mode)                       */
  };
  
  union {
    __IO uint32_t  ASYNCLISTADDR;                   /*!< (@ 0x40006158) Address of endpoint list in memory                     */
    __IO uint32_t  ENDPOINTLISTADDR;                /*!< (@ 0x40006158) Address of endpoint list in memory                     */
  };
  __IO uint32_t  TTCTRL;                            /*!< (@ 0x4000615C) Asynchronous buffer status for embedded TT (host
                                                         mode)                                                                 */
  __IO uint32_t  BURSTSIZE;                         /*!< (@ 0x40006160) Programmable burst size                                */
  __IO uint32_t  TXFILLTUNING;                      /*!< (@ 0x40006164) Host transmit pre-buffer packet tuning (host
                                                         mode)                                                                 */
  __I  uint32_t  RESERVED4[3];
  __IO uint32_t  BINTERVAL;                         /*!< (@ 0x40006174) Length of virtual frame                                */
  __IO uint32_t  ENDPTNAK;                          /*!< (@ 0x40006178) Endpoint NAK (device mode)                             */
  __IO uint32_t  ENDPTNAKEN;                        /*!< (@ 0x4000617C) Endpoint NAK Enable (device mode)                      */
  __I  uint32_t  RESERVED5;
  
  union {
    __IO uint32_t  PORTSC1_H;                       /*!< (@ 0x40006184) Port 1 status/control (host mode)                      */
    __IO uint32_t  PORTSC1_D;                       /*!< (@ 0x40006184) Port 1 status/control (device mode)                    */
  };
  __I  uint32_t  RESERVED6[7];
  __IO uint32_t  OTGSC;                             /*!< (@ 0x400061A4) OTG status and control                                 */
  
  union {
    __IO uint32_t  USBMODE_H;                       /*!< (@ 0x400061A8) USB mode (host mode)                                   */
    __IO uint32_t  USBMODE_D;                       /*!< (@ 0x400061A8) USB device mode (device mode)                          */
  };
  __IO uint32_t  ENDPTSETUPSTAT;                    /*!< (@ 0x400061AC) Endpoint setup status                                  */
  __IO uint32_t  ENDPTPRIME;                        /*!< (@ 0x400061B0) Endpoint initialization                                */
  __IO uint32_t  ENDPTFLUSH;                        /*!< (@ 0x400061B4) Endpoint de-initialization                             */
  __I  uint32_t  ENDPTSTAT;                         /*!< (@ 0x400061B8) Endpoint status                                        */
  __IO uint32_t  ENDPTCOMPLETE;                     /*!< (@ 0x400061BC) Endpoint complete                                      */
  __IO uint32_t  ENDPTCTRL0;                        /*!< (@ 0x400061C0) Endpoint control 0                                     */
  __IO uint32_t  ENDPTCTRL1;                        /*!< (@ 0x400061C4) Endpoint control                                       */
  __IO uint32_t  ENDPTCTRL2;                        /*!< (@ 0x400061C8) Endpoint control                                       */
  __IO uint32_t  ENDPTCTRL3;                        /*!< (@ 0x400061CC) Endpoint control                                       */
  __IO uint32_t  ENDPTCTRL4;                        /*!< (@ 0x400061D0) Endpoint control                                       */
  __IO uint32_t  ENDPTCTRL5;                        /*!< (@ 0x400061D4) Endpoint control                                       */
} LPC_USB0_Type;


/* ================================================================================ */
/* ================                      USB1                      ================ */
/* ================================================================================ */


/**
  * @brief USB1 Host/Device controller  (USB1)
  */

typedef struct {                                    /*!< (@ 0x40007000) USB1 Structure                                         */
  __I  uint32_t  RESERVED0[64];
  __I  uint32_t  CAPLENGTH;                         /*!< (@ 0x40007100) Capability register length                             */
  __I  uint32_t  HCSPARAMS;                         /*!< (@ 0x40007104) Host controller structural parameters                  */
  __I  uint32_t  HCCPARAMS;                         /*!< (@ 0x40007108) Host controller capability parameters                  */
  __I  uint32_t  RESERVED1[5];
  __I  uint32_t  DCIVERSION;                        /*!< (@ 0x40007120) Device interface version number                        */
  __I  uint32_t  RESERVED2[7];
  
  union {
    __IO uint32_t  USBCMD_H;                        /*!< (@ 0x40007140) USB command (host mode)                                */
    __IO uint32_t  USBCMD_D;                        /*!< (@ 0x40007140) USB command (device mode)                              */
  };
  
  union {
    __IO uint32_t  USBSTS_H;                        /*!< (@ 0x40007144) USB status (host mode)                                 */
    __IO uint32_t  USBSTS_D;                        /*!< (@ 0x40007144) USB status (device mode)                               */
  };
  
  union {
    __IO uint32_t  USBINTR_H;                       /*!< (@ 0x40007148) USB interrupt enable (host mode)                       */
    __IO uint32_t  USBINTR_D;                       /*!< (@ 0x40007148) USB interrupt enable (device mode)                     */
  };
  
  union {
    __IO uint32_t  FRINDEX_H;                       /*!< (@ 0x4000714C) USB frame index (host mode)                            */
    __I  uint32_t  FRINDEX_D;                       /*!< (@ 0x4000714C) USB frame index (device mode)                          */
  };
  __I  uint32_t  RESERVED3;
  
  union {
    __IO uint32_t  PERIODICLISTBASE;                /*!< (@ 0x40007154) Frame list base address                                */
    __IO uint32_t  DEVICEADDR;                      /*!< (@ 0x40007154) USB device address                                     */
  };
  
  union {
    __IO uint32_t  ASYNCLISTADDR;                   /*!< (@ 0x40007158) Address of endpoint list in memory (host mode)         */
    __IO uint32_t  ENDPOINTLISTADDR;                /*!< (@ 0x40007158) Address of endpoint list in memory (device mode)       */
  };
  __IO uint32_t  TTCTRL;                            /*!< (@ 0x4000715C) Asynchronous buffer status for embedded TT (host
                                                         mode)                                                                 */
  __IO uint32_t  BURSTSIZE;                         /*!< (@ 0x40007160) Programmable burst size                                */
  __IO uint32_t  TXFILLTUNING;                      /*!< (@ 0x40007164) Host transmit pre-buffer packet tuning (host
                                                         mode)                                                                 */
  __I  uint32_t  RESERVED4[2];
  __IO uint32_t  ULPIVIEWPORT;                      /*!< (@ 0x40007170) ULPI viewport                                          */
  __IO uint32_t  BINTERVAL;                         /*!< (@ 0x40007174) Length of virtual frame                                */
  __IO uint32_t  ENDPTNAK;                          /*!< (@ 0x40007178) Endpoint NAK (device mode)                             */
  __IO uint32_t  ENDPTNAKEN;                        /*!< (@ 0x4000717C) Endpoint NAK Enable (device mode)                      */
  __I  uint32_t  RESERVED5;
  
  union {
    __IO uint32_t  PORTSC1_H;                       /*!< (@ 0x40007184) Port 1 status/control (host mode)                      */
    __IO uint32_t  PORTSC1_D;                       /*!< (@ 0x40007184) Port 1 status/control (device mode)                    */
  };
  __I  uint32_t  RESERVED6[8];
  
  union {
    __IO uint32_t  USBMODE_H;                       /*!< (@ 0x400071A8) USB mode (host mode)                                   */
    __IO uint32_t  USBMODE_D;                       /*!< (@ 0x400071A8) USB mode (device mode)                                 */
  };
  __IO uint32_t  ENDPTSETUPSTAT;                    /*!< (@ 0x400071AC) Endpoint setup status                                  */
  __IO uint32_t  ENDPTPRIME;                        /*!< (@ 0x400071B0) Endpoint initialization                                */
  __IO uint32_t  ENDPTFLUSH;                        /*!< (@ 0x400071B4) Endpoint de-initialization                             */
  __I  uint32_t  ENDPTSTAT;                         /*!< (@ 0x400071B8) Endpoint status                                        */
  __IO uint32_t  ENDPTCOMPLETE;                     /*!< (@ 0x400071BC) Endpoint complete                                      */
  __IO uint32_t  ENDPTCTRL0;                        /*!< (@ 0x400071C0) Endpoint control 0                                     */
  __IO uint32_t  ENDPTCTRL1;                        /*!< (@ 0x400071C4) Endpoint control                                       */
  __IO uint32_t  ENDPTCTRL2;                        /*!< (@ 0x400071C8) Endpoint control                                       */
  __IO uint32_t  ENDPTCTRL3;                        /*!< (@ 0x400071CC) Endpoint control                                       */
} LPC_USB1_Type;


/* ================================================================================ */
/* ================                       LCD                      ================ */
/* ================================================================================ */


/**
  * @brief LCD controller  (LCD)
  */

typedef struct {                                    /*!< (@ 0x40008000) LCD Structure                                          */
  __IO uint32_t  TIMH;                              /*!< (@ 0x40008000) Horizontal Timing Control register                     */
  __IO uint32_t  TIMV;                              /*!< (@ 0x40008004) Vertical Timing Control register                       */
  __IO uint32_t  POL;                               /*!< (@ 0x40008008) Clock and Signal Polarity Control register             */
  __IO uint32_t  LE;                                /*!< (@ 0x4000800C) Line End Control register                              */
  __IO uint32_t  UPBASE;                            /*!< (@ 0x40008010) Upper Panel Frame Base Address register                */
  __IO uint32_t  LPBASE;                            /*!< (@ 0x40008014) Lower Panel Frame Base Address register                */
  __IO uint32_t  CTRL;                              /*!< (@ 0x40008018) LCD Control register                                   */
  __IO uint32_t  INTMSK;                            /*!< (@ 0x4000801C) Interrupt Mask register                                */
  __I  uint32_t  INTRAW;                            /*!< (@ 0x40008020) Raw Interrupt Status register                          */
  __I  uint32_t  INTSTAT;                           /*!< (@ 0x40008024) Masked Interrupt Status register                       */
  __O  uint32_t  INTCLR;                            /*!< (@ 0x40008028) Interrupt Clear register                               */
  __I  uint32_t  UPCURR;                            /*!< (@ 0x4000802C) Upper Panel Current Address Value register             */
  __I  uint32_t  LPCURR;                            /*!< (@ 0x40008030) Lower Panel Current Address Value register             */
  __I  uint32_t  RESERVED0[115];
  __IO uint32_t  PAL[256];                          /*!< (@ 0x40008200) 256x16-bit Color Palette registers                     */
  __I  uint32_t  RESERVED1[128];
  __IO uint32_t  CRSR_IMG[256];                     /*!< (@ 0x40008800) Cursor Image registers                                 */
  __IO uint32_t  CRSR_CTRL;                         /*!< (@ 0x40008C00) Cursor Control register                                */
  __IO uint32_t  CRSR_CFG;                          /*!< (@ 0x40008C04) Cursor Configuration register                          */
  __IO uint32_t  CRSR_PAL0;                         /*!< (@ 0x40008C08) Cursor Palette register 0                              */
  __IO uint32_t  CRSR_PAL1;                         /*!< (@ 0x40008C0C) Cursor Palette register 1                              */
  __IO uint32_t  CRSR_XY;                           /*!< (@ 0x40008C10) Cursor XY Position register                            */
  __IO uint32_t  CRSR_CLIP;                         /*!< (@ 0x40008C14) Cursor Clip Position register                          */
  __I  uint32_t  RESERVED2[2];
  __IO uint32_t  CRSR_INTMSK;                       /*!< (@ 0x40008C20) Cursor Interrupt Mask register                         */
  __O  uint32_t  CRSR_INTCLR;                       /*!< (@ 0x40008C24) Cursor Interrupt Clear register                        */
  __I  uint32_t  CRSR_INTRAW;                       /*!< (@ 0x40008C28) Cursor Raw Interrupt Status register                   */
  __I  uint32_t  CRSR_INTSTAT;                      /*!< (@ 0x40008C2C) Cursor Masked Interrupt Status register                */
} LPC_LCD_Type;


/* ================================================================================ */
/* ================                     EEPROM                     ================ */
/* ================================================================================ */


/**
  * @brief EEPROM (EEPROM)
  */

typedef struct {                                    /*!< (@ 0x4000E000) EEPROM Structure                                       */
  __IO uint32_t  CMD;                               /*!< (@ 0x4000E000) EEPROM command register                                */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  RWSTATE;                           /*!< (@ 0x4000E008) EEPROM read wait state register                        */
  __IO uint32_t  AUTOPROG;                          /*!< (@ 0x4000E00C) EEPROM auto programming register                       */
  __IO uint32_t  WSTATE;                            /*!< (@ 0x4000E010) EEPROM wait state register                             */
  __IO uint32_t  CLKDIV;                            /*!< (@ 0x4000E014) EEPROM clock divider register                          */
  __IO uint32_t  PWRDWN;                            /*!< (@ 0x4000E018) EEPROM power-down register                             */
  __I  uint32_t  RESERVED1[1007];
  __O  uint32_t  INTENCLR;                          /*!< (@ 0x4000EFD8) EEPROM interrupt enable clear                          */
  __O  uint32_t  INTENSET;                          /*!< (@ 0x4000EFDC) EEPROM interrupt enable set                            */
  __I  uint32_t  INTSTAT;                           /*!< (@ 0x4000EFE0) EEPROM interrupt status                                */
  __I  uint32_t  INTEN;                             /*!< (@ 0x4000EFE4) EEPROM interrupt enable                                */
  __O  uint32_t  INTSTATCLR;                        /*!< (@ 0x4000EFE8) EEPROM interrupt status clear                          */
} LPC_EEPROM_Type;


/* ================================================================================ */
/* ================                    ETHERNET                    ================ */
/* ================================================================================ */


/**
  * @brief Ethernet (ETHERNET)
  */

typedef struct {                                    /*!< (@ 0x40010000) ETHERNET Structure                                     */
  __IO uint32_t  MAC_CONFIG;                        /*!< (@ 0x40010000) MAC configuration register                             */
  __IO uint32_t  MAC_FRAME_FILTER;                  /*!< (@ 0x40010004) MAC frame filter                                       */
  __IO uint32_t  MAC_HASHTABLE_HIGH;                /*!< (@ 0x40010008) Hash table high register                               */
  __IO uint32_t  MAC_HASHTABLE_LOW;                 /*!< (@ 0x4001000C) Hash table low register                                */
  __IO uint32_t  MAC_MII_ADDR;                      /*!< (@ 0x40010010) MII address register                                   */
  __IO uint32_t  MAC_MII_DATA;                      /*!< (@ 0x40010014) MII data register                                      */
  __IO uint32_t  MAC_FLOW_CTRL;                     /*!< (@ 0x40010018) Flow control register                                  */
  __IO uint32_t  MAC_VLAN_TAG;                      /*!< (@ 0x4001001C) VLAN tag register                                      */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  MAC_DEBUG;                         /*!< (@ 0x40010024) Debug register                                         */
  __IO uint32_t  MAC_RWAKE_FRFLT;                   /*!< (@ 0x40010028) Remote wake-up frame filter                            */
  __IO uint32_t  MAC_PMT_CTRL_STAT;                 /*!< (@ 0x4001002C) PMT control and status                                 */
  __I  uint32_t  RESERVED1[2];
  __I  uint32_t  MAC_INTR;                          /*!< (@ 0x40010038) Interrupt status register                              */
  __IO uint32_t  MAC_INTR_MASK;                     /*!< (@ 0x4001003C) Interrupt mask register                                */
  __IO uint32_t  MAC_ADDR0_HIGH;                    /*!< (@ 0x40010040) MAC address 0 high register                            */
  __IO uint32_t  MAC_ADDR0_LOW;                     /*!< (@ 0x40010044) MAC address 0 low register                             */
  __I  uint32_t  RESERVED2[430];
  __IO uint32_t  MAC_TIMESTP_CTRL;                  /*!< (@ 0x40010700) Time stamp control register                            */
  __IO uint32_t  SUBSECOND_INCR;                    /*!< (@ 0x40010704) Sub-second increment register                          */
  __I  uint32_t  SECONDS;                           /*!< (@ 0x40010708) System time seconds register                           */
  __I  uint32_t  NANOSECONDS;                       /*!< (@ 0x4001070C) System time nanoseconds register                       */
  __IO uint32_t  SECONDSUPDATE;                     /*!< (@ 0x40010710) System time seconds update register                    */
  __IO uint32_t  NANOSECONDSUPDATE;                 /*!< (@ 0x40010714) System time nanoseconds update register                */
  __IO uint32_t  ADDEND;                            /*!< (@ 0x40010718) Time stamp addend register                             */
  __IO uint32_t  TARGETSECONDS;                     /*!< (@ 0x4001071C) Target time seconds register                           */
  __IO uint32_t  TARGETNANOSECONDS;                 /*!< (@ 0x40010720) Target time nanoseconds register                       */
  __IO uint32_t  HIGHWORD;                          /*!< (@ 0x40010724) System time higher word seconds register               */
  __I  uint32_t  TIMESTAMPSTAT;                     /*!< (@ 0x40010728) Time stamp status register                             */
  __I  uint32_t  RESERVED3[565];
  __IO uint32_t  DMA_BUS_MODE;                      /*!< (@ 0x40011000) Bus Mode Register                                      */
  __IO uint32_t  DMA_TRANS_POLL_DEMAND;             /*!< (@ 0x40011004) Transmit poll demand register                          */
  __IO uint32_t  DMA_REC_POLL_DEMAND;               /*!< (@ 0x40011008) Receive poll demand register                           */
  __IO uint32_t  DMA_REC_DES_ADDR;                  /*!< (@ 0x4001100C) Receive descriptor list address register               */
  __IO uint32_t  DMA_TRANS_DES_ADDR;                /*!< (@ 0x40011010) Transmit descriptor list address register              */
  __IO uint32_t  DMA_STAT;                          /*!< (@ 0x40011014) Status register                                        */
  __IO uint32_t  DMA_OP_MODE;                       /*!< (@ 0x40011018) Operation mode register                                */
  __IO uint32_t  DMA_INT_EN;                        /*!< (@ 0x4001101C) Interrupt enable register                              */
  __I  uint32_t  DMA_MFRM_BUFOF;                    /*!< (@ 0x40011020) Missed frame and buffer overflow register              */
  __IO uint32_t  DMA_REC_INT_WDT;                   /*!< (@ 0x40011024) Receive interrupt watchdog timer register              */
  __I  uint32_t  RESERVED4[8];
  __I  uint32_t  DMA_CURHOST_TRANS_DES;             /*!< (@ 0x40011048) Current host transmit descriptor register              */
  __I  uint32_t  DMA_CURHOST_REC_DES;               /*!< (@ 0x4001104C) Current host receive descriptor register               */
  __I  uint32_t  DMA_CURHOST_TRANS_BUF;             /*!< (@ 0x40011050) Current host transmit buffer address register          */
  __I  uint32_t  DMA_CURHOST_REC_BUF;               /*!< (@ 0x40011054) Current host receive buffer address register           */
} LPC_ETHERNET_Type;


/* ================================================================================ */
/* ================                     ATIMER                     ================ */
/* ================================================================================ */


/**
  * @brief Alarm timer  (ATIMER)
  */

typedef struct {                                    /*!< (@ 0x40040000) ATIMER Structure                                       */
  __IO uint32_t  DOWNCOUNTER;                       /*!< (@ 0x40040000) Downcounter register                                   */
  __IO uint32_t  PRESET;                            /*!< (@ 0x40040004) Preset value register                                  */
  __I  uint32_t  RESERVED0[1012];
  __O  uint32_t  CLR_EN;                            /*!< (@ 0x40040FD8) Interrupt clear enable register                        */
  __O  uint32_t  SET_EN;                            /*!< (@ 0x40040FDC) Interrupt set enable register                          */
  __I  uint32_t  STATUS;                            /*!< (@ 0x40040FE0) Status register                                        */
  __I  uint32_t  ENABLE;                            /*!< (@ 0x40040FE4) Enable register                                        */
  __O  uint32_t  CLR_STAT;                          /*!< (@ 0x40040FE8) Clear register                                         */
  __O  uint32_t  SET_STAT;                          /*!< (@ 0x40040FEC) Set register                                           */
} LPC_ATIMER_Type;


/* ================================================================================ */
/* ================                     REGFILE                    ================ */
/* ================================================================================ */


/**
  * @brief RTC REGFILE  (REGFILE)
  */

typedef struct {                                    /*!< (@ 0x40041000) REGFILE Structure                                      */
  __IO uint32_t  REGFILE[64];                       /*!< (@ 0x40041000) General purpose storage register                       */
} LPC_REGFILE_Type;


/* ================================================================================ */
/* ================                       PMC                      ================ */
/* ================================================================================ */


/**
  * @brief Power Management Controller (PMC) (PMC)
  */

typedef struct {                                    /*!< (@ 0x40042000) PMC Structure                                          */
  __IO uint32_t  PD0_SLEEP0_HW_ENA;                 /*!< (@ 0x40042000) Hardware sleep event enable register                   */
  __I  uint32_t  RESERVED0[6];
  __IO uint32_t  PD0_SLEEP0_MODE;                   /*!< (@ 0x4004201C) Sleep power mode register                              */
} LPC_PMC_Type;


/* ================================================================================ */
/* ================                      CREG                      ================ */
/* ================================================================================ */


/**
  * @brief Configuration Registers (CREG) (CREG)
  */

typedef struct {                                    /*!< (@ 0x40043000) CREG Structure                                         */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  CREG0;                             /*!< (@ 0x40043004) Chip configuration register 32 kHz oscillator
                                                         output and BOD control register.                                      */
  __I  uint32_t  RESERVED1[62];
  __IO uint32_t  M4MEMMAP;                          /*!< (@ 0x40043100) ARM Cortex-M4 memory mapping                           */
  __I  uint32_t  RESERVED2[5];
  __IO uint32_t  CREG5;                             /*!< (@ 0x40043118) Chip configuration register 5. Controls JTAG
                                                         access.                                                               */
  __IO uint32_t  DMAMUX;                            /*!< (@ 0x4004311C) DMA mux control                                        */
  __IO uint32_t  FLASHCFGA;                         /*!< (@ 0x40043120) Flash accelerator configuration register for
                                                         flash bank A                                                          */
  __IO uint32_t  FLASHCFGB;                         /*!< (@ 0x40043124) Flash accelerator configuration register for
                                                         flash bank B                                                          */
  __IO uint32_t  ETBCFG;                            /*!< (@ 0x40043128) ETB RAM configuration                                  */
  __IO uint32_t  CREG6;                             /*!< (@ 0x4004312C) Chip configuration register 6. Controls multiple
                                                         functions : Ethernet interface, SCT output, I2S0/1 inputs, EMC
                                                          clock.                                                               */
  __IO uint32_t  M4TXEVENT;                         /*!< (@ 0x40043130) Cortex-M4 TXEV event clear                             */
  __I  uint32_t  RESERVED3[51];
  __I  uint32_t  CHIPID;                            /*!< (@ 0x40043200) Part ID                                                */
  __I  uint32_t  RESERVED4[65];
  __IO uint32_t  M0SUBMEMMAP;                       /*!< (@ 0x40043308) ARM Cortex-M0SUB memory mapping                        */
  __I  uint32_t  RESERVED5[2];
  __IO uint32_t  M0SUBTXEVENT;                      /*!< (@ 0x40043314) Cortex-M0SUB TXEV event clear                          */
  __I  uint32_t  RESERVED6[58];
  __IO uint32_t  M0APPTXEVENT;                      /*!< (@ 0x40043400) Cortex-M0APP TXEV event clear                          */
  __IO uint32_t  M0APPMEMMAP;                       /*!< (@ 0x40043404) ARM Cortex-M0APP memory mapping                        */
  __I  uint32_t  RESERVED7[62];
  __IO uint32_t  USB0FLADJ;                         /*!< (@ 0x40043500) USB0 frame length adjust register                      */
  __I  uint32_t  RESERVED8[63];
  __IO uint32_t  USB1FLADJ;                         /*!< (@ 0x40043600) USB1 frame length adjust register                      */
} LPC_CREG_Type;


/* ================================================================================ */
/* ================                   EVENTROUTER                  ================ */
/* ================================================================================ */


/**
  * @brief Event router (EVENTROUTER)
  */

typedef struct {                                    /*!< (@ 0x40044000) EVENTROUTER Structure                                  */
  __IO uint32_t  HILO;                              /*!< (@ 0x40044000) Level configuration register                           */
  __IO uint32_t  EDGE;                              /*!< (@ 0x40044004) Edge configuration                                     */
  __I  uint32_t  RESERVED0[1012];
  __O  uint32_t  CLR_EN;                            /*!< (@ 0x40044FD8) Clear event enable register                            */
  __O  uint32_t  SET_EN;                            /*!< (@ 0x40044FDC) Set event enable register                              */
  __I  uint32_t  STATUS;                            /*!< (@ 0x40044FE0) Event Status register                                  */
  __I  uint32_t  ENABLE;                            /*!< (@ 0x40044FE4) Event Enable register                                  */
  __O  uint32_t  CLR_STAT;                          /*!< (@ 0x40044FE8) Clear event status register                            */
  __O  uint32_t  SET_STAT;                          /*!< (@ 0x40044FEC) Set event status register                              */
} LPC_EVENTROUTER_Type;


/* ================================================================================ */
/* ================                       RTC                      ================ */
/* ================================================================================ */


/**
  * @brief Real-Time Clock (RTC) and event recorder  (RTC)
  */

typedef struct {                                    /*!< (@ 0x40046000) RTC Structure                                          */
  __O  uint32_t  ILR;                               /*!< (@ 0x40046000) Interrupt Location Register                            */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  CCR;                               /*!< (@ 0x40046008) Clock Control Register                                 */
  __IO uint32_t  CIIR;                              /*!< (@ 0x4004600C) Counter Increment Interrupt Register                   */
  __IO uint32_t  AMR;                               /*!< (@ 0x40046010) Alarm Mask Register                                    */
  __I  uint32_t  CTIME0;                            /*!< (@ 0x40046014) Consolidated Time Register 0                           */
  __I  uint32_t  CTIME1;                            /*!< (@ 0x40046018) Consolidated Time Register 1                           */
  __I  uint32_t  CTIME2;                            /*!< (@ 0x4004601C) Consolidated Time Register 2                           */
  __IO uint32_t  SEC;                               /*!< (@ 0x40046020) Seconds Register                                       */
  __IO uint32_t  MIN;                               /*!< (@ 0x40046024) Minutes Register                                       */
  __IO uint32_t  HRS;                               /*!< (@ 0x40046028) Hours Register                                         */
  __IO uint32_t  DOM;                               /*!< (@ 0x4004602C) Day of Month Register                                  */
  __IO uint32_t  DOW;                               /*!< (@ 0x40046030) Day of Week Register                                   */
  __IO uint32_t  DOY;                               /*!< (@ 0x40046034) Day of Year Register                                   */
  __IO uint32_t  MONTH;                             /*!< (@ 0x40046038) Months Register                                        */
  __IO uint32_t  YEAR;                              /*!< (@ 0x4004603C) Years Register                                         */
  __IO uint32_t  CALIBRATION;                       /*!< (@ 0x40046040) Calibration Value Register                             */
  __I  uint32_t  RESERVED1[7];
  __IO uint32_t  ASEC;                              /*!< (@ 0x40046060) Alarm value for Seconds                                */
  __IO uint32_t  AMIN;                              /*!< (@ 0x40046064) Alarm value for Minutes                                */
  __IO uint32_t  AHRS;                              /*!< (@ 0x40046068) Alarm value for Hours                                  */
  __IO uint32_t  ADOM;                              /*!< (@ 0x4004606C) Alarm value for Day of Month                           */
  __IO uint32_t  ADOW;                              /*!< (@ 0x40046070) Alarm value for Day of Week                            */
  __IO uint32_t  ADOY;                              /*!< (@ 0x40046074) Alarm value for Day of Year                            */
  __IO uint32_t  AMON;                              /*!< (@ 0x40046078) Alarm value for Months                                 */
  __IO uint32_t  AYRS;                              /*!< (@ 0x4004607C) Alarm value for Year                                   */
  __IO uint32_t  ERSTATUS;                          /*!< (@ 0x40046080) Event Monitor/Recorder Status register. Contains
                                                         status flags for event channels and other Event Monitor/Recorder
                                                          conditions.                                                          */
  __IO uint32_t  ERCONTRO;                          /*!< (@ 0x40046084) Event Monitor/Recorder Control register. Contains
                                                         bits that control actions for the event channels as well as
                                                          for Event Monitor/Recorder setup.                                    */
  __I  uint32_t  ERCOUNTERS;                        /*!< (@ 0x40046088) Event Monitor/Recorder Counters register. Allows
                                                         reading the counters associated with the event channels.              */
  __I  uint32_t  RESERVED2;
  __I  uint32_t  ERFIRSTSTAMP0;                     /*!< (@ 0x40046090) Event Monitor/Recorder First Stamp register for
                                                         channel 0. Retains the time stamp for the first event on channel
                                                          0.                                                                   */
  __I  uint32_t  ERFIRSTSTAMP1;                     /*!< (@ 0x40046094) Event Monitor/Recorder First Stamp register for
                                                         channel 0. Retains the time stamp for the first event on channel
                                                          0.                                                                   */
  __I  uint32_t  ERFIRSTSTAMP2;                     /*!< (@ 0x40046098) Event Monitor/Recorder First Stamp register for
                                                         channel 0. Retains the time stamp for the first event on channel
                                                          0.                                                                   */
  __I  uint32_t  RESERVED3;
  __I  uint32_t  ERLASTSTAMP0;                      /*!< (@ 0x400460A0) Event Monitor/Recorder Last Stamp register for
                                                         channel 0. Retains the time stamp for the last (i.e. most recent)
                                                          event on channel 0.                                                  */
  __I  uint32_t  ERLASTSTAMP1;                      /*!< (@ 0x400460A4) Event Monitor/Recorder Last Stamp register for
                                                         channel 0. Retains the time stamp for the last (i.e. most recent)
                                                          event on channel 0.                                                  */
  __I  uint32_t  ERLASTSTAMP2;                      /*!< (@ 0x400460A8) Event Monitor/Recorder Last Stamp register for
                                                         channel 0. Retains the time stamp for the last (i.e. most recent)
                                                          event on channel 0.                                                  */
} LPC_RTC_Type;


/* ================================================================================ */
/* ================                       CGU                      ================ */
/* ================================================================================ */


/**
  * @brief Clock Generation Unit (CGU) (CGU)
  */

typedef struct {                                    /*!< (@ 0x40050000) CGU Structure                                          */
  __I  uint32_t  RESERVED0[5];
  __IO uint32_t  FREQ_MON;                          /*!< (@ 0x40050014) Frequency monitor register                             */
  __IO uint32_t  XTAL_OSC_CTRL;                     /*!< (@ 0x40050018) Crystal oscillator control register                    */
  __I  uint32_t  PLL0USB_STAT;                      /*!< (@ 0x4005001C) PLL0USB status register                                */
  __IO uint32_t  PLL0USB_CTRL;                      /*!< (@ 0x40050020) PLL0USB control register                               */
  __IO uint32_t  PLL0USB_MDIV;                      /*!< (@ 0x40050024) PLL0USB M-divider register                             */
  __IO uint32_t  PLL0USB_NP_DIV;                    /*!< (@ 0x40050028) PLL0USB N/P-divider register                           */
  __I  uint32_t  PLL0AUDIO_STAT;                    /*!< (@ 0x4005002C) PLL0AUDIO status register                              */
  __IO uint32_t  PLL0AUDIO_CTRL;                    /*!< (@ 0x40050030) PLL0AUDIO control register                             */
  __IO uint32_t  PLL0AUDIO_MDIV;                    /*!< (@ 0x40050034) PLL0AUDIO M-divider register                           */
  __IO uint32_t  PLL0AUDIO_NP_DIV;                  /*!< (@ 0x40050038) PLL0AUDIO N/P-divider register                         */
  __IO uint32_t  PLL0AUDIO_FRAC;                    /*!< (@ 0x4005003C) PLL0AUDIO fractional divider register                  */
  __I  uint32_t  PLL1_STAT;                         /*!< (@ 0x40050040) PLL1 status register                                   */
  __IO uint32_t  PLL1_CTRL;                         /*!< (@ 0x40050044) PLL1 control register                                  */
  __IO uint32_t  IDIVA_CTRL;                        /*!< (@ 0x40050048) Integer divider A control register                     */
  __IO uint32_t  IDIVB_CTRL;                        /*!< (@ 0x4005004C) Integer divider B control register                     */
  __IO uint32_t  IDIVC_CTRL;                        /*!< (@ 0x40050050) Integer divider C control register                     */
  __IO uint32_t  IDIVD_CTRL;                        /*!< (@ 0x40050054) Integer divider D control register                     */
  __IO uint32_t  IDIVE_CTRL;                        /*!< (@ 0x40050058) Integer divider E control register                     */
  __I  uint32_t  BASE_SAFE_CLK;                     /*!< (@ 0x4005005C) Output stage 0 control register for base clock
                                                         BASE_SAFE_CLK                                                         */
  __IO uint32_t  BASE_USB0_CLK;                     /*!< (@ 0x40050060) Output stage 1 control register for base clock
                                                         BASE_USB0_CLK                                                         */
  __IO uint32_t  BASE_PERIPH_CLK;                   /*!< (@ 0x40050064) Output stage 2 control register for base clock
                                                         BASE_PERIPH_CLK                                                       */
  __IO uint32_t  BASE_USB1_CLK;                     /*!< (@ 0x40050068) Output stage 3 control register for base clock
                                                         BASE_USB1_CLK                                                         */
  __IO uint32_t  BASE_M4_CLK;                       /*!< (@ 0x4005006C) Output stage BASE_M4_CLK control register              */
  __IO uint32_t  BASE_SPIFI_CLK;                    /*!< (@ 0x40050070) Output stage BASE_SPIFI_CLK control register           */
  __IO uint32_t  BASE_SPI_CLK;                      /*!< (@ 0x40050074) Output stage BASE_SPI_CLK control register             */
  __IO uint32_t  BASE_PHY_RX_CLK;                   /*!< (@ 0x40050078) Output stage BASE_PHY_RX_CLK control register          */
  __IO uint32_t  BASE_PHY_TX_CLK;                   /*!< (@ 0x4005007C) Output stage BASE_PHY_TX_CLK control register          */
  __IO uint32_t  BASE_APB1_CLK;                     /*!< (@ 0x40050080) Output stage BASE_APB1_CLK control register            */
  __IO uint32_t  BASE_APB3_CLK;                     /*!< (@ 0x40050084) Output stage BASE_APB3_CLK control register            */
  __IO uint32_t  BASE_LCD_CLK;                      /*!< (@ 0x40050088) Output stage BASE_LCD_CLK control register             */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  BASE_SDIO_CLK;                     /*!< (@ 0x40050090) Output stage BASE_SDIO_CLK control register            */
  __IO uint32_t  BASE_SSP0_CLK;                     /*!< (@ 0x40050094) Output stage BASE_SSP0_CLK control register            */
  __IO uint32_t  BASE_SSP1_CLK;                     /*!< (@ 0x40050098) Output stage BASE_SSP1_CLK control register            */
  __IO uint32_t  BASE_UART0_CLK;                    /*!< (@ 0x4005009C) Output stage BASE_UART0_CLK control register           */
  __IO uint32_t  BASE_UART1_CLK;                    /*!< (@ 0x400500A0) Output stage BASE_UART1_CLK control register           */
  __IO uint32_t  BASE_UART2_CLK;                    /*!< (@ 0x400500A4) Output stage BASE_UART2_CLK control register           */
  __IO uint32_t  BASE_UART3_CLK;                    /*!< (@ 0x400500A8) Output stage BASE_UART3_CLK control register           */
  __IO uint32_t  BASE_OUT_CLK;                      /*!< (@ 0x400500AC) Output stage 20 control register for base clock
                                                         BASE_OUT_CLK                                                          */
  __I  uint32_t  RESERVED2[4];
  __IO uint32_t  BASE_APLL_CLK;                     /*!< (@ 0x400500C0) Output stage 25 control register for base clock
                                                         BASE_APLL_CLK                                                         */
  __IO uint32_t  BASE_CGU_OUT0_CLK;                 /*!< (@ 0x400500C4) Output stage 25 control register for base clock
                                                         BASE_CGU_OUT0_CLK                                                     */
  __IO uint32_t  BASE_CGU_OUT1_CLK;                 /*!< (@ 0x400500C8) Output stage 25 control register for base clock
                                                         BASE_CGU_OUT1_CLK                                                     */
} LPC_CGU_Type;


/* ================================================================================ */
/* ================                      CCU1                      ================ */
/* ================================================================================ */


/**
  * @brief Clock Control Unit (CCU) (CCU1)
  */

typedef struct {                                    /*!< (@ 0x40051000) CCU1 Structure                                         */
  __IO uint32_t  PM;                                /*!< (@ 0x40051000) CCU1 power mode register                               */
  __I  uint32_t  BASE_STAT;                         /*!< (@ 0x40051004) CCU1 base clocks status register                       */
  __I  uint32_t  RESERVED0[62];
  __IO uint32_t  CLK_APB3_BUS_CFG;                  /*!< (@ 0x40051100) CLK_APB3_BUS clock configuration register              */
  __I  uint32_t  CLK_APB3_BUS_STAT;                 /*!< (@ 0x40051104) CLK_APB3_BUS clock status register                     */
  __IO uint32_t  CLK_APB3_I2C1_CFG;                 /*!< (@ 0x40051108) CLK_APB3_I2C1 clock configuration register             */
  __I  uint32_t  CLK_APB3_I2C1_STAT;                /*!< (@ 0x4005110C) CLK_APB3_I2C1 clock status register                    */
  __IO uint32_t  CLK_APB3_DAC_CFG;                  /*!< (@ 0x40051110) CLK_APB3_DAC clock configuration register              */
  __I  uint32_t  CLK_APB3_DAC_STAT;                 /*!< (@ 0x40051114) CLK_APB3_DAC clock status register                     */
  __IO uint32_t  CLK_APB3_ADC0_CFG;                 /*!< (@ 0x40051118) CLK_APB3_ADC0 clock configuration register             */
  __I  uint32_t  CLK_APB3_ADC0_STAT;                /*!< (@ 0x4005111C) CLK_APB3_ADC0 clock status register                    */
  __IO uint32_t  CLK_APB3_ADC1_CFG;                 /*!< (@ 0x40051120) CLK_APB3_ADC1 clock configuration register             */
  __I  uint32_t  CLK_APB3_ADC1_STAT;                /*!< (@ 0x40051124) CLK_APB3_ADC1 clock status register                    */
  __IO uint32_t  CLK_APB3_CAN0_CFG;                 /*!< (@ 0x40051128) CLK_APB3_CAN0 clock configuration register             */
  __I  uint32_t  CLK_APB3_CAN0_STAT;                /*!< (@ 0x4005112C) CLK_APB3_CAN0 clock status register                    */
  __I  uint32_t  RESERVED1[52];
  __IO uint32_t  CLK_APB1_BUS_CFG;                  /*!< (@ 0x40051200) CLK_APB1_BUS clock configuration register              */
  __I  uint32_t  CLK_APB1_BUS_STAT;                 /*!< (@ 0x40051204) CLK_APB1_BUS clock status register                     */
  __IO uint32_t  CLK_APB1_MOTOCONPWM_CFG;           /*!< (@ 0x40051208) CLK_APB1_MOTOCONPWM clock configuration register       */
  __I  uint32_t  CLK_APB1_MOTOCONPWM_STAT;          /*!< (@ 0x4005120C) CLK_APB1_MOTOCONPWM clock status register              */
  __IO uint32_t  CLK_APB1_I2C0_CFG;                 /*!< (@ 0x40051210) CLK_ABP1_I2C0 clock configuration register             */
  __I  uint32_t  CLK_APB1_I2C0_STAT;                /*!< (@ 0x40051214) CLK_APB1_I2C0 clock status register                    */
  __IO uint32_t  CLK_APB1_I2S_CFG;                  /*!< (@ 0x40051218) CLK_APB1_I2S clock configuration register              */
  __I  uint32_t  CLK_APB1_I2S_STAT;                 /*!< (@ 0x4005121C) CLK_APB1_I2S clock status register                     */
  __IO uint32_t  CLK_APB1_CAN1_CFG;                 /*!< (@ 0x40051220) CLK_APB1_CAN1 clock configuration register             */
  __I  uint32_t  CLK_APB1_CAN1_STAT;                /*!< (@ 0x40051224) CLK_APB1_CAN1 clock status register                    */
  __I  uint32_t  RESERVED2[54];
  __IO uint32_t  CLK_SPIFI_CFG;                     /*!< (@ 0x40051300) CLK_SPIFI clock configuration register                 */
  __I  uint32_t  CLK_SPIFI_STAT;                    /*!< (@ 0x40051304) CLK_APB1_SPIFI clock status register                   */
  __I  uint32_t  RESERVED3[62];
  __IO uint32_t  CLK_M4_BUS_CFG;                    /*!< (@ 0x40051400) CLK_M4_BUS clock configuration register                */
  __I  uint32_t  CLK_M4_BUS_STAT;                   /*!< (@ 0x40051404) CLK_M4_BUSclock status register                        */
  __IO uint32_t  CLK_M4_SPIFI_CFG;                  /*!< (@ 0x40051408) CLK_M4_SPIFI clock configuration register              */
  __I  uint32_t  CLK_M4_SPIFI_STAT;                 /*!< (@ 0x4005140C) CLK_M4_SPIFI clock status register                     */
  __IO uint32_t  CLK_M4_GPIO_CFG;                   /*!< (@ 0x40051410) CLK_M4_GPIO clock configuration register               */
  __I  uint32_t  CLK_M4_GPIO_STAT;                  /*!< (@ 0x40051414) CLK_M4_GPIO clock status register                      */
  __IO uint32_t  CLK_M4_LCD_CFG;                    /*!< (@ 0x40051418) CLK_M4_LCD clock configuration register                */
  __I  uint32_t  CLK_M4_LCD_STAT;                   /*!< (@ 0x4005141C) CLK_M4_LCD clock status register                       */
  __IO uint32_t  CLK_M4_ETHERNET_CFG;               /*!< (@ 0x40051420) CLK_M4_ETHERNET clock configuration register           */
  __I  uint32_t  CLK_M4_ETHERNET_STAT;              /*!< (@ 0x40051424) CLK_M4_ETHERNET clock status register                  */
  __IO uint32_t  CLK_M4_USB0_CFG;                   /*!< (@ 0x40051428) CLK_M4_USB0 clock configuration register               */
  __I  uint32_t  CLK_M4_USB0_STAT;                  /*!< (@ 0x4005142C) CLK_M4_USB0 clock status register                      */
  __IO uint32_t  CLK_M4_EMC_CFG;                    /*!< (@ 0x40051430) CLK_M4_EMC clock configuration register                */
  __I  uint32_t  CLK_M4_EMC_STAT;                   /*!< (@ 0x40051434) CLK_M4_EMC clock status register                       */
  __IO uint32_t  CLK_M4_SDIO_CFG;                   /*!< (@ 0x40051438) CLK_M4_SDIO clock configuration register               */
  __I  uint32_t  CLK_M4_SDIO_STAT;                  /*!< (@ 0x4005143C) CLK_M4_SDIO clock status register                      */
  __IO uint32_t  CLK_M4_DMA_CFG;                    /*!< (@ 0x40051440) CLK_M4_DMA clock configuration register                */
  __I  uint32_t  CLK_M4_DMA_STAT;                   /*!< (@ 0x40051444) CLK_M4_DMA clock status register                       */
  __IO uint32_t  CLK_M4_M4CORE_CFG;                 /*!< (@ 0x40051448) CLK_M4_M4CORE clock configuration register             */
  __I  uint32_t  CLK_M4_M4CORE_STAT;                /*!< (@ 0x4005144C) CLK_M4_M3CORE clock status register                    */
  __I  uint32_t  RESERVED4[6];
  __IO uint32_t  CLK_M4_SCT_CFG;                    /*!< (@ 0x40051468) CLK_M4_SCT clock configuration register                */
  __I  uint32_t  CLK_M4_SCT_STAT;                   /*!< (@ 0x4005146C) CLK_M4_SCT clock status register                       */
  __IO uint32_t  CLK_M4_USB1_CFG;                   /*!< (@ 0x40051470) CLK_M4_USB1 clock configuration register               */
  __I  uint32_t  CLK_M4_USB1_STAT;                  /*!< (@ 0x40051474) CLK_M4_USB1 clock status register                      */
  __IO uint32_t  CLK_M4_EMCDIV_CFG;                 /*!< (@ 0x40051478) CLK_M4_EMCDIV clock configuration register             */
  __I  uint32_t  CLK_M4_EMCDIV_STAT;                /*!< (@ 0x4005147C) CLK_M4_EMCDIV clock status register                    */
  __IO uint32_t  CLK_M4_FLASHA_CFG;                 /*!< (@ 0x40051480) CLK_M4_FLASHA clock configuration register             */
  __I  uint32_t  CLK_M4_FLASHA_STAT;                /*!< (@ 0x40051484) CLK_M4_FLASHA clock status register                    */
  __IO uint32_t  CLK_M4_FLASHB_CFG;                 /*!< (@ 0x40051488) CLK_M4_FLASHB clock configuration register             */
  __I  uint32_t  CLK_M4_FLASHB_STAT;                /*!< (@ 0x4005148C) CLK_M4_FLASHB clock status register                    */
  __IO uint32_t  CLK_M4_M0APP_CFG;                  /*!< (@ 0x40051490) CLK_M0APP_CFG clock configuration register             */
  __I  uint32_t  CLK_M4_M0APP_STAT;                 /*!< (@ 0x40051494) CLK_M4_MOAPP clock status register                     */
  __IO uint32_t  CLK_M4_ADCHS_CFG;                  /*!< (@ 0x40051498) CLK_ADCHS_CFG clock configuration register             */
  __I  uint32_t  CLK_M4_ADCHS_STAT;                 /*!< (@ 0x4005149C) CLK_M4_ADCHS clock status register                     */
  __IO uint32_t  CLK_M4_EEPROM_CFG;                 /*!< (@ 0x400514A0) CLK_EEPROM_CFG clock configuration register            */
  __I  uint32_t  CLK_M4_EEPROM_STAT;                /*!< (@ 0x400514A4) CLK_M4_EEPROM clock status register                    */
  __I  uint32_t  RESERVED5[22];
  __IO uint32_t  CLK_M4_WWDT_CFG;                   /*!< (@ 0x40051500) CLK_M4_WWDT clock configuration register               */
  __I  uint32_t  CLK_M4_WWDT_STAT;                  /*!< (@ 0x40051504) CLK_M4_WWDT clock status register                      */
  __IO uint32_t  CLK_M4_USART0_CFG;                 /*!< (@ 0x40051508) CLK_M4_USART0 clock configuration register             */
  __I  uint32_t  CLK_M4_USART0_STAT;                /*!< (@ 0x4005150C) CLK_M4_USART0 clock status register                    */
  __IO uint32_t  CLK_M4_UART1_CFG;                  /*!< (@ 0x40051510) CLK_M4_UART1 clock configuration register              */
  __I  uint32_t  CLK_M4_UART1_STAT;                 /*!< (@ 0x40051514) CLK_M4_UART1 clock status register                     */
  __IO uint32_t  CLK_M4_SSP0_CFG;                   /*!< (@ 0x40051518) CLK_M4_SSP0 clock configuration register               */
  __I  uint32_t  CLK_M4_SSP0_STAT;                  /*!< (@ 0x4005151C) CLK_M4_SSP0 clock status register                      */
  __IO uint32_t  CLK_M4_TIMER0_CFG;                 /*!< (@ 0x40051520) CLK_M4_TIMER0 clock configuration register             */
  __I  uint32_t  CLK_M4_TIMER0_STAT;                /*!< (@ 0x40051524) CLK_M4_TIMER0 clock status register                    */
  __IO uint32_t  CLK_M4_TIMER1_CFG;                 /*!< (@ 0x40051528) CLK_M4_TIMER1clock configuration register              */
  __I  uint32_t  CLK_M4_TIMER1_STAT;                /*!< (@ 0x4005152C) CLK_M4_TIMER1 clock status register                    */
  __IO uint32_t  CLK_M4_SCU_CFG;                    /*!< (@ 0x40051530) CLK_M4_SCU clock configuration register                */
  __I  uint32_t  CLK_M4_SCU_STAT;                   /*!< (@ 0x40051534) CLK_SCU_XXX clock status register                      */
  __IO uint32_t  CLK_M4_CREG_CFG;                   /*!< (@ 0x40051538) CLK_M4_CREGclock configuration register                */
  __I  uint32_t  CLK_M4_CREG_STAT;                  /*!< (@ 0x4005153C) CLK_M4_CREG clock status register                      */
  __I  uint32_t  RESERVED6[48];
  __IO uint32_t  CLK_M4_RITIMER_CFG;                /*!< (@ 0x40051600) CLK_M4_RITIMER clock configuration register            */
  __I  uint32_t  CLK_M4_RITIMER_STAT;               /*!< (@ 0x40051604) CLK_M4_RITIMER clock status register                   */
  __IO uint32_t  CLK_M4_USART2_CFG;                 /*!< (@ 0x40051608) CLK_M4_USART2 clock configuration register             */
  __I  uint32_t  CLK_M4_USART2_STAT;                /*!< (@ 0x4005160C) CLK_M4_USART2 clock status register                    */
  __IO uint32_t  CLK_M4_USART3_CFG;                 /*!< (@ 0x40051610) CLK_M4_USART3 clock configuration register             */
  __I  uint32_t  CLK_M4_USART3_STAT;                /*!< (@ 0x40051614) CLK_M4_USART3 clock status register                    */
  __IO uint32_t  CLK_M4_TIMER2_CFG;                 /*!< (@ 0x40051618) CLK_M4_TIMER2 clock configuration register             */
  __I  uint32_t  CLK_M4_TIMER2_STAT;                /*!< (@ 0x4005161C) CLK_M4_TIMER2 clock status register                    */
  __IO uint32_t  CLK_M4_TIMER3_CFG;                 /*!< (@ 0x40051620) CLK_M4_TIMER3 clock configuration register             */
  __I  uint32_t  CLK_M4_TIMER3_STAT;                /*!< (@ 0x40051624) CLK_M4_TIMER3 clock status register                    */
  __IO uint32_t  CLK_M4_SSP1_CFG;                   /*!< (@ 0x40051628) CLK_M4_SSP1 clock configuration register               */
  __I  uint32_t  CLK_M4_SSP1_STAT;                  /*!< (@ 0x4005162C) CLK_M4_SSP1 clock status register                      */
  __IO uint32_t  CLK_M4_QEI_CFG;                    /*!< (@ 0x40051630) CLK_M4_QEIclock configuration register                 */
  __I  uint32_t  CLK_M4_QEI_STAT;                   /*!< (@ 0x40051634) CLK_M4_QEI clock status register                       */
  __I  uint32_t  RESERVED7[50];
  __IO uint32_t  CLK_PERIPH_BUS_CFG;                /*!< (@ 0x40051700) CLK_PERIPH_BUS_CFG clock configuration register        */
  __I  uint32_t  CLK_PERIPH_BUS_STAT;               /*!< (@ 0x40051704) CLK_PERIPH_BUS_STAT clock status register              */
  __I  uint32_t  RESERVED8[2];
  __IO uint32_t  CLK_PERIPH_CORE_CFG;               /*!< (@ 0x40051710) CLK_PERIPH_CORE_CFG clock configuration register       */
  __I  uint32_t  CLK_PERIPH_CORE_STAT;              /*!< (@ 0x40051714) CLK_CORE_BUS_STAT clock status register                */
  __IO uint32_t  CLK_PERIPH_SGPIO_CFG;              /*!< (@ 0x40051718) CLK_PERIPH_SGPIO_CFG clock configuration register      */
  __I  uint32_t  CLK_PERIPH_SGPIO_STAT;             /*!< (@ 0x4005171C) CLK_CORE_SGPIO_STAT clock status register              */
  __I  uint32_t  RESERVED9[56];
  __IO uint32_t  CLK_USB0_CFG;                      /*!< (@ 0x40051800) CLK_M4_USB0 clock configuration register               */
  __I  uint32_t  CLK_USB0_STAT;                     /*!< (@ 0x40051804) CLK_USB0 clock status register                         */
  __I  uint32_t  RESERVED10[62];
  __IO uint32_t  CLK_USB1_CFG;                      /*!< (@ 0x40051900) CLK_USB1 clock configuration register                  */
  __I  uint32_t  CLK_USB1_STAT;                     /*!< (@ 0x40051904) CLK_USB1 clock status register                         */
  __I  uint32_t  RESERVED11[62];
  __IO uint32_t  CLK_SPI_CFG;                       /*!< (@ 0x40051A00) CLK_SPI clock configuration register                   */
  __I  uint32_t  CLK_SPI_STAT;                      /*!< (@ 0x40051A04) CLK_SPI clock status register                          */
  __I  uint32_t  RESERVED12[62];
  __IO uint32_t  CLK_ADCHS_CFG;                     /*!< (@ 0x40051B00) CLK_ADCHS clock configuration register                 */
  __I  uint32_t  CLK_ADCHS_STAT;                    /*!< (@ 0x40051B04) CLK_ADCHS clock status register                        */
} LPC_CCU1_Type;


/* ================================================================================ */
/* ================                      CCU2                      ================ */
/* ================================================================================ */


/**
  * @brief Clock Control Unit (CCU2) (CCU2)
  */

typedef struct {                                    /*!< (@ 0x40052000) CCU2 Structure                                         */
  __IO uint32_t  PM;                                /*!< (@ 0x40052000) Power mode register                                    */
  __I  uint32_t  BASE_STAT;                         /*!< (@ 0x40052004) CCU base clocks status register                        */
  __I  uint32_t  RESERVED0[62];
  __IO uint32_t  CLK_AUDIO_CFG;                     /*!< (@ 0x40052100) CLK_AUDIO clock configuration register                 */
  __I  uint32_t  CLK_AUDIO_STAT;                    /*!< (@ 0x40052104) CLK_AUDIO clock status register                        */
  __I  uint32_t  RESERVED1[62];
  __IO uint32_t  CLK_APB2_USART3_CFG;               /*!< (@ 0x40052200) CLK_APB2_USART3 clock configuration register           */
  __I  uint32_t  CLK_APB2_USART3_STAT;              /*!< (@ 0x40052204) CLK_APB2_USART3 clock status register                  */
  __I  uint32_t  RESERVED2[62];
  __IO uint32_t  CLK_APB2_USART2_CFG;               /*!< (@ 0x40052300) CLK_APB2_USART2 clock configuration register           */
  __I  uint32_t  CLK_APB2_USART2_STAT;              /*!< (@ 0x40052304) CLK_APB2_USART clock status register                   */
  __I  uint32_t  RESERVED3[62];
  __IO uint32_t  CLK_APB0_UART1_CFG;            /*!< (@ 0x40052400) CLK_APB2_UART1 clock configuration register            */
  __I  uint32_t  CLK_APB0_UART1_STAT;               /*!< (@ 0x40052404) CLK_APB0_UART1 clock status register                   */
  __I  uint32_t  RESERVED4[62];
  __IO uint32_t  CLK_APB0_USART0_CFG;               /*!< (@ 0x40052500) CLK_APB2_USART0 clock configuration register           */
  __I  uint32_t  CLK_APB0_USART0_STAT;              /*!< (@ 0x40052504) CLK_APB0_USART0 clock status register                  */
  __I  uint32_t  RESERVED5[62];
  __IO uint32_t  CLK_APB2_SSP1_CFG;                 /*!< (@ 0x40052600) CLK_APB2_SSP1 clock configuration register             */
  __I  uint32_t  CLK_APB2_SSP1_STAT;                /*!< (@ 0x40052604) CLK_APB2_SSP1 clock status register                    */
  __I  uint32_t  RESERVED6[62];
  __IO uint32_t  CLK_APB0_SSP0_CFG;                 /*!< (@ 0x40052700) CLK_APB0_SSP0 clock configuration register             */
  __I  uint32_t  CLK_APB0_SSP0_STAT;                /*!< (@ 0x40052704) CLK_APB0_SSP0 clock status register                    */
  __I  uint32_t  RESERVED7[62];
  __IO uint32_t  CLK_SDIO_CFG;                      /*!< (@ 0x40052800) CLK_SDIO clock configuration register                  */
  __I  uint32_t  CLK_SDIO_STAT;                     /*!< (@ 0x40052804) CLK_SDIO clock status register                         */
} LPC_CCU2_Type;


/* ================================================================================ */
/* ================                       RGU                      ================ */
/* ================================================================================ */


/**
  * @brief Reset Generation Unit (RGU) (RGU)
  */

typedef struct {                                    /*!< (@ 0x40053000) RGU Structure                                          */
  __I  uint32_t  RESERVED0[64];
  __O  uint32_t  RESET_CTRL0;                       /*!< (@ 0x40053100) Reset control register 0                               */
  __O  uint32_t  RESET_CTRL1;                       /*!< (@ 0x40053104) Reset control register 1                               */
  __I  uint32_t  RESERVED1[2];
  __IO uint32_t  RESET_STATUS0;                     /*!< (@ 0x40053110) Reset status register 0                                */
  __IO uint32_t  RESET_STATUS1;                     /*!< (@ 0x40053114) Reset status register 1                                */
  __IO uint32_t  RESET_STATUS2;                     /*!< (@ 0x40053118) Reset status register 2                                */
  __IO uint32_t  RESET_STATUS3;                     /*!< (@ 0x4005311C) Reset status register 3                                */
  __I  uint32_t  RESERVED2[12];
  __I  uint32_t  RESET_ACTIVE_STATUS0;              /*!< (@ 0x40053150) Reset active status register 0                         */
  __I  uint32_t  RESET_ACTIVE_STATUS1;              /*!< (@ 0x40053154) Reset active status register 1                         */
  __I  uint32_t  RESERVED3[171];
  __IO uint32_t  RESET_EXT_STAT1;                   /*!< (@ 0x40053404) Reset external status register 1 for PERIPH_RST        */
  __IO uint32_t  RESET_EXT_STAT2;                   /*!< (@ 0x40053408) Reset external status register 2 for MASTER_RST        */
  __I  uint32_t  RESERVED4[2];
  __IO uint32_t  RESET_EXT_STAT5;                   /*!< (@ 0x40053414) Reset external status register 5 for CREG_RST          */
  __I  uint32_t  RESERVED5[2];
  __IO uint32_t  RESET_EXT_STAT8;                   /*!< (@ 0x40053420) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT9;                   /*!< (@ 0x40053424) Reset external status register                         */
  __I  uint32_t  RESERVED6[2];
  __IO uint32_t  RESET_EXT_STAT12;                  /*!< (@ 0x40053430) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT13;                  /*!< (@ 0x40053434) Reset external status register                         */
  __I  uint32_t  RESERVED7[2];
  __IO uint32_t  RESET_EXT_STAT16;                  /*!< (@ 0x40053440) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT17;                  /*!< (@ 0x40053444) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT18;                  /*!< (@ 0x40053448) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT19;                  /*!< (@ 0x4005344C) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT20;                  /*!< (@ 0x40053450) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT21;                  /*!< (@ 0x40053454) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT22;                  /*!< (@ 0x40053458) Reset external status register                         */
  __I  uint32_t  RESERVED8[2];
  __IO uint32_t  RESET_EXT_STAT25;                  /*!< (@ 0x40053464) Reset external status register                         */
  __I  uint32_t  RESERVED9;
  __IO uint32_t  RESET_EXT_STAT27;                  /*!< (@ 0x4005346C) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT28;                  /*!< (@ 0x40053470) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT29;                  /*!< (@ 0x40053474) Reset external status register                         */
  __I  uint32_t  RESERVED10[2];
  __IO uint32_t  RESET_EXT_STAT32;                  /*!< (@ 0x40053480) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT33;                  /*!< (@ 0x40053484) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT34;                  /*!< (@ 0x40053488) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT35;                  /*!< (@ 0x4005348C) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT36;                  /*!< (@ 0x40053490) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT37;                  /*!< (@ 0x40053494) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT38;                  /*!< (@ 0x40053498) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT39;                  /*!< (@ 0x4005349C) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT40;                  /*!< (@ 0x400534A0) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT41;                  /*!< (@ 0x400534A4) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT42;                  /*!< (@ 0x400534A8) Reset external status register                         */
  __I  uint32_t  RESERVED11;
  __IO uint32_t  RESET_EXT_STAT44;                  /*!< (@ 0x400534B0) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT45;                  /*!< (@ 0x400534B4) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT46;                  /*!< (@ 0x400534B8) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT47;                  /*!< (@ 0x400534BC) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT48;                  /*!< (@ 0x400534C0) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT49;                  /*!< (@ 0x400534C4) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT50;                  /*!< (@ 0x400534C8) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT51;                  /*!< (@ 0x400534CC) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT52;                  /*!< (@ 0x400534D0) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT53;                  /*!< (@ 0x400534D4) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT54;                  /*!< (@ 0x400534D8) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT55;                  /*!< (@ 0x400534DC) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT56;                  /*!< (@ 0x400534E0) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT57;                  /*!< (@ 0x400534E4) Reset external status register                         */
  __IO uint32_t  RESET_EXT_STAT58;                  /*!< (@ 0x400534E8) Reset external status register                         */
  __I  uint32_t  RESERVED12;
  __IO uint32_t  RESET_EXT_STAT60;                  /*!< (@ 0x400534F0) Reset external status register                         */
} LPC_RGU_Type;


/* ================================================================================ */
/* ================                      WWDT                      ================ */
/* ================================================================================ */


/**
  * @brief Windowed Watchdog timer (WWDT)  (WWDT)
  */

typedef struct {                                    /*!< (@ 0x40080000) WWDT Structure                                         */
  __IO uint32_t  MOD;                               /*!< (@ 0x40080000) Watchdog mode register. This register contains
                                                         the basic mode and status of the Watchdog Timer.                      */
  __IO uint32_t  TC;                                /*!< (@ 0x40080004) Watchdog timer constant register. This register
                                                         determines the time-out value.                                        */
  __O  uint32_t  FEED;                              /*!< (@ 0x40080008) Watchdog feed sequence register. Writing 0xAA
                                                         followed by 0x55 to this register reloads the Watchdog timer
                                                          with the value contained in WDTC.                                    */
  __I  uint32_t  TV;                                /*!< (@ 0x4008000C) Watchdog timer value register. This register
                                                         reads out the current value of the Watchdog timer.                    */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  WARNINT;                           /*!< (@ 0x40080014) Watchdog warning interrupt register. This register
                                                         contains the Watchdog warning interrupt compare value.                */
  __IO uint32_t  WINDOW;                            /*!< (@ 0x40080018) Watchdog timer window register. This register
                                                         contains the Watchdog window value.                                   */
} LPC_WWDT_Type;


/* ================================================================================ */
/* ================                 USARTn [USART0]                ================ */
/* ================================================================================ */


/**
  * @brief USART0_2_3 (USARTn)
  */

typedef struct {                                    /*!< (@ 0x40081000) USARTn Structure                                       */
  
  union {
    __IO uint32_t  DLL;                             /*!< (@ 0x40081000) Divisor Latch LSB. Least significant byte of
                                                         the baud rate divisor value. The full divisor is used to generate
                                                          a baud rate from the fractional rate divider (DLAB = 1).             */
    __O  uint32_t  THR;                             /*!< (@ 0x40081000) Transmit Holding Register. The next character
                                                         to be transmitted is written here (DLAB = 0).                         */
    __I  uint32_t  RBR;                             /*!< (@ 0x40081000) Receiver Buffer Register. Contains the next received
                                                         character to be read (DLAB = 0).                                      */
  };
  
  union {
    __IO uint32_t  IER;                             /*!< (@ 0x40081004) Interrupt Enable Register. Contains individual
                                                         interrupt enable bits for the 7 potential USART interrupts (DLAB
                                                          = 0).                                                                */
    __IO uint32_t  DLM;                             /*!< (@ 0x40081004) Divisor Latch MSB. Most significant byte of the
                                                         baud rate divisor value. The full divisor is used to generate
                                                          a baud rate from the fractional rate divider (DLAB = 1).             */
  };
  
  union {
    __O  uint32_t  FCR;                             /*!< (@ 0x40081008) FIFO Control Register. Controls USART FIFO usage
                                                         and modes.                                                            */
    __I  uint32_t  IIR;                             /*!< (@ 0x40081008) Interrupt ID Register. Identifies which interrupt(s)
                                                         are pending.                                                          */
  };
  __IO uint32_t  LCR;                               /*!< (@ 0x4008100C) Line Control Register. Contains controls for
                                                         frame formatting and break generation.                                */
  __I  uint32_t  RESERVED0;
  __I  uint32_t  LSR;                               /*!< (@ 0x40081014) Line Status Register. Contains flags for transmit
                                                         and receive status, including line errors.                            */
  __I  uint32_t  RESERVED1;
  __IO uint32_t  SCR;                               /*!< (@ 0x4008101C) Scratch Pad Register. Eight-bit temporary storage
                                                         for software.                                                         */
  __IO uint32_t  ACR;                               /*!< (@ 0x40081020) Auto-baud Control Register. Contains controls
                                                         for the auto-baud feature.                                            */
  __IO uint32_t  ICR;                               /*!< (@ 0x40081024) IrDA control register (USART3 only)                    */
  __IO uint32_t  FDR;                               /*!< (@ 0x40081028) Fractional Divider Register. Generates a clock
                                                         input for the baud rate divider.                                      */
  __IO uint32_t  OSR;                               /*!< (@ 0x4008102C) Oversampling Register. Controls the degree of
                                                         oversampling during each bit time.                                    */
  __I  uint32_t  RESERVED2[4];
  __IO uint32_t  HDEN;                              /*!< (@ 0x40081040) Half-duplex enable Register                            */
  __I  uint32_t  RESERVED3;
  __IO uint32_t  SCICTRL;                           /*!< (@ 0x40081048) Smart card interface control register                  */
  __IO uint32_t  RS485CTRL;                         /*!< (@ 0x4008104C) RS-485/EIA-485 Control. Contains controls to
                                                         configure various aspects of RS-485/EIA-485 modes.                    */
  __IO uint32_t  RS485ADRMATCH;                     /*!< (@ 0x40081050) RS-485/EIA-485 address match. Contains the address
                                                         match value for RS-485/EIA-485 mode.                                  */
  __IO uint32_t  RS485DLY;                          /*!< (@ 0x40081054) RS-485/EIA-485 direction control delay.                */
  __IO uint32_t  SYNCCTRL;                          /*!< (@ 0x40081058) Synchronous mode control register.                     */
  __IO uint32_t  TER;                               /*!< (@ 0x4008105C) Transmit Enable Register. Turns off USART transmitter
                                                         for use with software flow control.                                   */
} LPC_USARTn_Type;


/* ================================================================================ */
/* ================                      UART1                     ================ */
/* ================================================================================ */


/**
  * @brief UART1 (UART1)
  */

typedef struct {                                    /*!< (@ 0x40082000) UART1 Structure                                        */
  
  union {
    __IO uint32_t  DLL;                             /*!< (@ 0x40082000) Divisor Latch LSB. Least significant byte of
                                                         the baud rate divisor value. The full divisor is used to generate
                                                          a baud rate from the fractional rate divider. (DLAB=1)               */
    __O  uint32_t  THR;                             /*!< (@ 0x40082000) Transmit Holding Register. The next character
                                                         to be transmitted is written here. (DLAB=0)                           */
    __I  uint32_t  RBR;                             /*!< (@ 0x40082000) Receiver Buffer Register. Contains the next received
                                                         character to be read. (DLAB=0)                                        */
  };
  
  union {
    __IO uint32_t  IER;                             /*!< (@ 0x40082004) Interrupt Enable Register. Contains individual
                                                         interrupt enable bits for the 7 potential UART1 interrupts.
                                                          (DLAB=0)                                                             */
    __IO uint32_t  DLM;                             /*!< (@ 0x40082004) Divisor Latch MSB. Most significant byte of the
                                                         baud rate divisor value. The full divisor is used to generate
                                                          a baud rate from the fractional rate divider.(DLAB=1)                */
  };
  
  union {
    __O  uint32_t  FCR;                             /*!< (@ 0x40082008) FIFO Control Register. Controls UART1 FIFO usage
                                                         and modes.                                                            */
    __I  uint32_t  IIR;                             /*!< (@ 0x40082008) Interrupt ID Register. Identifies which interrupt(s)
                                                         are pending.                                                          */
  };
  __IO uint32_t  LCR;                               /*!< (@ 0x4008200C) Line Control Register. Contains controls for
                                                         frame formatting and break generation.                                */
  __IO uint32_t  MCR;                               /*!< (@ 0x40082010) Modem Control Register. Contains controls for
                                                         flow control handshaking and loopback mode.                           */
  __I  uint32_t  LSR;                               /*!< (@ 0x40082014) Line Status Register. Contains flags for transmit
                                                         and receive status, including line errors.                            */
  __I  uint32_t  MSR;                               /*!< (@ 0x40082018) Modem Status Register. Contains handshake signal
                                                         status flags.                                                         */
  __IO uint32_t  SCR;                               /*!< (@ 0x4008201C) Scratch Pad Register. 8-bit temporary storage
                                                         for software.                                                         */
  __IO uint32_t  ACR;                               /*!< (@ 0x40082020) Auto-baud Control Register. Contains controls
                                                         for the auto-baud feature.                                            */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  FDR;                               /*!< (@ 0x40082028) Fractional Divider Register. Generates a clock
                                                         input for the baud rate divider.                                      */
  __I  uint32_t  RESERVED1[8];
  __IO uint32_t  RS485CTRL;                         /*!< (@ 0x4008204C) RS-485/EIA-485 Control. Contains controls to
                                                         configure various aspects of RS-485/EIA-485 modes.                    */
  __IO uint32_t  RS485ADRMATCH;                     /*!< (@ 0x40082050) RS-485/EIA-485 address match. Contains the address
                                                         match value for RS-485/EIA-485 mode.                                  */
  __IO uint32_t  RS485DLY;                          /*!< (@ 0x40082054) RS-485/EIA-485 direction control delay.                */
  __I  uint32_t  RESERVED2;
  __IO uint32_t  TER;                               /*!< (@ 0x4008205C) Transmit Enable Register. Turns off UART transmitter
                                                         for use with software flow control.                                   */
} LPC_UART1_Type;


/* ================================================================================ */
/* ================                   SSPn [SSP0]                  ================ */
/* ================================================================================ */


/**
  * @brief SSP0/1 (SSPn)
  */

typedef struct {                                    /*!< (@ 0x40083000) SSPn Structure                                         */
  __IO uint32_t  CR0;                               /*!< (@ 0x40083000) Control Register 0. Selects the serial clock
                                                         rate, bus type, and data size.                                        */
  __IO uint32_t  CR1;                               /*!< (@ 0x40083004) Control Register 1. Selects master/slave and
                                                         other modes.                                                          */
  __IO uint32_t  DR;                                /*!< (@ 0x40083008) Data Register. Writes fill the transmit FIFO,
                                                         and reads empty the receive FIFO.                                     */
  __I  uint32_t  SR;                                /*!< (@ 0x4008300C) Status Register                                        */
  __IO uint32_t  CPSR;                              /*!< (@ 0x40083010) Clock Prescale Register                                */
  __IO uint32_t  IMSC;                              /*!< (@ 0x40083014) Interrupt Mask Set and Clear Register                  */
  __I  uint32_t  RIS;                               /*!< (@ 0x40083018) Raw Interrupt Status Register                          */
  __I  uint32_t  MIS;                               /*!< (@ 0x4008301C) Masked Interrupt Status Register                       */
  __O  uint32_t  ICR;                               /*!< (@ 0x40083020) SSPICR Interrupt Clear Register                        */
  __IO uint32_t  DMACR;                             /*!< (@ 0x40083024) SSP0 DMA control register                              */
} LPC_SSPn_Type;


/* ================================================================================ */
/* ================                 TIMERn [TIMER0]                ================ */
/* ================================================================================ */


/**
  * @brief Timer0/1/2/3 (TIMERn)
  */

typedef struct {                                    /*!< (@ 0x40084000) TIMERn Structure                                       */
  __IO uint32_t  IR;                                /*!< (@ 0x40084000) Interrupt Register. The IR can be written to
                                                         clear interrupts. The IR can be read to identify which of eight
                                                          possible interrupt sources are pending.                              */
  __IO uint32_t  TCR;                               /*!< (@ 0x40084004) Timer Control Register. The TCR is used to control
                                                         the Timer Counter functions. The Timer Counter can be disabled
                                                          or reset through the TCR.                                            */
  __IO uint32_t  TC;                                /*!< (@ 0x40084008) Timer Counter. The 32 bit TC is incremented every
                                                         PR+1 cycles of PCLK. The TC is controlled through the TCR.            */
  __IO uint32_t  PR;                                /*!< (@ 0x4008400C) Prescale Register. When the Prescale Counter
                                                         (PC) is equal to this value, the next clock increments the TC
                                                          and clears the PC.                                                   */
  __IO uint32_t  PC;                                /*!< (@ 0x40084010) Prescale Counter. The 32 bit PC is a counter
                                                         which is incremented to the value stored in PR. When the value
                                                          in PR is reached, the TC is incremented and the PC is cleared.
                                                          The PC is observable and controllable through the bus interface.     */
  __IO uint32_t  MCR;                               /*!< (@ 0x40084014) Match Control Register. The MCR is used to control
                                                         if an interrupt is generated and if the TC is reset when a Match
                                                          occurs.                                                              */
  __IO uint32_t  MR0;                               /*!< (@ 0x40084018) Match Register 0. MR0 can be enabled through
                                                         the MCR to reset the TC, stop both the TC and PC, and/or generate
                                                          an interrupt every time MR0 matches the TC.                          */
  __IO uint32_t  MR1;                               /*!< (@ 0x4008401C) Match Register 0. MR0 can be enabled through
                                                         the MCR to reset the TC, stop both the TC and PC, and/or generate
                                                          an interrupt every time MR0 matches the TC.                          */
  __IO uint32_t  MR2;                               /*!< (@ 0x40084020) Match Register 0. MR0 can be enabled through
                                                         the MCR to reset the TC, stop both the TC and PC, and/or generate
                                                          an interrupt every time MR0 matches the TC.                          */
  __IO uint32_t  MR3;                               /*!< (@ 0x40084024) Match Register 0. MR0 can be enabled through
                                                         the MCR to reset the TC, stop both the TC and PC, and/or generate
                                                          an interrupt every time MR0 matches the TC.                          */
  __IO uint32_t  CCR;                               /*!< (@ 0x40084028) Capture Control Register. The CCR controls which
                                                         edges of the capture inputs are used to load the Capture Registers
                                                          and whether or not an interrupt is generated when a capture
                                                          takes place.                                                         */
  __I  uint32_t  CR0;                               /*!< (@ 0x4008402C) Capture Register 0. CR0 is loaded with the value
                                                         of TC when there is an event on the CAPn.0 input.                     */
  __I  uint32_t  CR1;                               /*!< (@ 0x40084030) Capture Register 0. CR0 is loaded with the value
                                                         of TC when there is an event on the CAPn.0 input.                     */
  __I  uint32_t  CR2;                               /*!< (@ 0x40084034) Capture Register 0. CR0 is loaded with the value
                                                         of TC when there is an event on the CAPn.0 input.                     */
  __I  uint32_t  CR3;                               /*!< (@ 0x40084038) Capture Register 0. CR0 is loaded with the value
                                                         of TC when there is an event on the CAPn.0 input.                     */
  __IO uint32_t  EMR;                               /*!< (@ 0x4008403C) External Match Register. The EMR controls the
                                                         external match pins MATn.0-3 (MAT0.0-3 and MAT1.0-3 respectively).    */
  __I  uint32_t  RESERVED0[12];
  __IO uint32_t  CTCR;                              /*!< (@ 0x40084070) Count Control Register. The CTCR selects between
                                                         Timer and Counter mode, and in Counter mode selects the signal
                                                          and edge(s) for counting.                                            */
} LPC_TIMERn_Type;


/* ================================================================================ */
/* ================                       SCU                      ================ */
/* ================================================================================ */


/**
  * @brief System Control Unit (SCU) I/O configuration  (SCU)
  */

typedef struct {                                    /*!< (@ 0x40086000) SCU Structure                                          */
  __IO uint32_t  SFSP0_0;                           /*!< (@ 0x40086000) Pin configuration register for pins P0                 */
  __IO uint32_t  SFSP0_1;                           /*!< (@ 0x40086004) Pin configuration register for pins P0                 */
  __I  uint32_t  RESERVED0[30];
  __IO uint32_t  SFSP1_0;                           /*!< (@ 0x40086080) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_1;                           /*!< (@ 0x40086084) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_2;                           /*!< (@ 0x40086088) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_3;                           /*!< (@ 0x4008608C) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_4;                           /*!< (@ 0x40086090) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_5;                           /*!< (@ 0x40086094) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_6;                           /*!< (@ 0x40086098) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_7;                           /*!< (@ 0x4008609C) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_8;                           /*!< (@ 0x400860A0) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_9;                           /*!< (@ 0x400860A4) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_10;                          /*!< (@ 0x400860A8) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_11;                          /*!< (@ 0x400860AC) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_12;                          /*!< (@ 0x400860B0) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_13;                          /*!< (@ 0x400860B4) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_14;                          /*!< (@ 0x400860B8) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_15;                          /*!< (@ 0x400860BC) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_16;                          /*!< (@ 0x400860C0) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_17;                          /*!< (@ 0x400860C4) Pin configuration register for pins P1_17              */
  __IO uint32_t  SFSP1_18;                          /*!< (@ 0x400860C8) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_19;                          /*!< (@ 0x400860CC) Pin configuration register for pins P1                 */
  __IO uint32_t  SFSP1_20;                          /*!< (@ 0x400860D0) Pin configuration register for pins P1                 */
  __I  uint32_t  RESERVED1[11];
  __IO uint32_t  SFSP2_0;                           /*!< (@ 0x40086100) Pin configuration register for pins P2                 */
  __IO uint32_t  SFSP2_1;                           /*!< (@ 0x40086104) Pin configuration register for pins P2                 */
  __IO uint32_t  SFSP2_2;                           /*!< (@ 0x40086108) Pin configuration register for pins P2                 */
  __IO uint32_t  SFSP2_3;                           /*!< (@ 0x4008610C) Pin configuration register for pins P2                 */
  __IO uint32_t  SFSP2_4;                           /*!< (@ 0x40086110) Pin configuration register for pins P2                 */
  __IO uint32_t  SFSP2_5;                           /*!< (@ 0x40086114) Pin configuration register for pins P2                 */
  __IO uint32_t  SFSP2_6;                           /*!< (@ 0x40086118) Pin configuration register for pins P2                 */
  __IO uint32_t  SFSP2_7;                           /*!< (@ 0x4008611C) Pin configuration register for pins P2                 */
  __IO uint32_t  SFSP2_8;                           /*!< (@ 0x40086120) Pin configuration register for pins P2                 */
  __IO uint32_t  SFSP2_9;                           /*!< (@ 0x40086124) Pin configuration register for pins P2                 */
  __IO uint32_t  SFSP2_10;                          /*!< (@ 0x40086128) Pin configuration register for pins P2                 */
  __IO uint32_t  SFSP2_11;                          /*!< (@ 0x4008612C) Pin configuration register for pins P2                 */
  __IO uint32_t  SFSP2_12;                          /*!< (@ 0x40086130) Pin configuration register for pins P2                 */
  __IO uint32_t  SFSP2_13;                          /*!< (@ 0x40086134) Pin configuration register for pins P2                 */
  __I  uint32_t  RESERVED2[18];
  __IO uint32_t  SFSP3_0;                           /*!< (@ 0x40086180) Pin configuration register for pins P3                 */
  __IO uint32_t  SFSP3_1;                           /*!< (@ 0x40086184) Pin configuration register for pins P3                 */
  __IO uint32_t  SFSP3_2;                           /*!< (@ 0x40086188) Pin configuration register for pins P3                 */
  __IO uint32_t  SFSP3_3;                           /*!< (@ 0x4008618C) Pin configuration register for pins P3                 */
  __IO uint32_t  SFSP3_4;                           /*!< (@ 0x40086190) Pin configuration register for pins P3                 */
  __IO uint32_t  SFSP3_5;                           /*!< (@ 0x40086194) Pin configuration register for pins P3                 */
  __IO uint32_t  SFSP3_6;                           /*!< (@ 0x40086198) Pin configuration register for pins P3                 */
  __IO uint32_t  SFSP3_7;                           /*!< (@ 0x4008619C) Pin configuration register for pins P3                 */
  __IO uint32_t  SFSP3_8;                           /*!< (@ 0x400861A0) Pin configuration register for pins P3                 */
  __I  uint32_t  RESERVED3[23];
  __IO uint32_t  SFSP4_0;                           /*!< (@ 0x40086200) Pin configuration register for pins P4                 */
  __IO uint32_t  SFSP4_1;                           /*!< (@ 0x40086204) Pin configuration register for pins P4                 */
  __IO uint32_t  SFSP4_2;                           /*!< (@ 0x40086208) Pin configuration register for pins P4                 */
  __IO uint32_t  SFSP4_3;                           /*!< (@ 0x4008620C) Pin configuration register for pins P4                 */
  __IO uint32_t  SFSP4_4;                           /*!< (@ 0x40086210) Pin configuration register for pins P4                 */
  __IO uint32_t  SFSP4_5;                           /*!< (@ 0x40086214) Pin configuration register for pins P4                 */
  __IO uint32_t  SFSP4_6;                           /*!< (@ 0x40086218) Pin configuration register for pins P4                 */
  __IO uint32_t  SFSP4_7;                           /*!< (@ 0x4008621C) Pin configuration register for pins P4                 */
  __IO uint32_t  SFSP4_8;                           /*!< (@ 0x40086220) Pin configuration register for pins P4                 */
  __IO uint32_t  SFSP4_9;                           /*!< (@ 0x40086224) Pin configuration register for pins P4                 */
  __IO uint32_t  SFSP4_10;                          /*!< (@ 0x40086228) Pin configuration register for pins P4                 */
  __I  uint32_t  RESERVED4[21];
  __IO uint32_t  SFSP5_0;                           /*!< (@ 0x40086280) Pin configuration register for pins P5                 */
  __IO uint32_t  SFSP5_1;                           /*!< (@ 0x40086284) Pin configuration register for pins P5                 */
  __IO uint32_t  SFSP5_2;                           /*!< (@ 0x40086288) Pin configuration register for pins P5                 */
  __IO uint32_t  SFSP5_3;                           /*!< (@ 0x4008628C) Pin configuration register for pins P5                 */
  __IO uint32_t  SFSP5_4;                           /*!< (@ 0x40086290) Pin configuration register for pins P5                 */
  __IO uint32_t  SFSP5_5;                           /*!< (@ 0x40086294) Pin configuration register for pins P5                 */
  __IO uint32_t  SFSP5_6;                           /*!< (@ 0x40086298) Pin configuration register for pins P5                 */
  __IO uint32_t  SFSP5_7;                           /*!< (@ 0x4008629C) Pin configuration register for pins P5                 */
  __I  uint32_t  RESERVED5[24];
  __IO uint32_t  SFSP6_0;                           /*!< (@ 0x40086300) Pin configuration register for pins P6                 */
  __IO uint32_t  SFSP6_1;                           /*!< (@ 0x40086304) Pin configuration register for pins P6                 */
  __IO uint32_t  SFSP6_2;                           /*!< (@ 0x40086308) Pin configuration register for pins P6                 */
  __IO uint32_t  SFSP6_3;                           /*!< (@ 0x4008630C) Pin configuration register for pins P6                 */
  __IO uint32_t  SFSP6_4;                           /*!< (@ 0x40086310) Pin configuration register for pins P6                 */
  __IO uint32_t  SFSP6_5;                           /*!< (@ 0x40086314) Pin configuration register for pins P6                 */
  __IO uint32_t  SFSP6_6;                           /*!< (@ 0x40086318) Pin configuration register for pins P6                 */
  __IO uint32_t  SFSP6_7;                           /*!< (@ 0x4008631C) Pin configuration register for pins P6                 */
  __IO uint32_t  SFSP6_8;                           /*!< (@ 0x40086320) Pin configuration register for pins P6                 */
  __IO uint32_t  SFSP6_9;                           /*!< (@ 0x40086324) Pin configuration register for pins P6                 */
  __IO uint32_t  SFSP6_10;                          /*!< (@ 0x40086328) Pin configuration register for pins P6                 */
  __IO uint32_t  SFSP6_11;                          /*!< (@ 0x4008632C) Pin configuration register for pins P6                 */
  __IO uint32_t  SFSP6_12;                          /*!< (@ 0x40086330) Pin configuration register for pins P6                 */
  __I  uint32_t  RESERVED6[19];
  __IO uint32_t  SFSP7_0;                           /*!< (@ 0x40086380) Pin configuration register for pins P7                 */
  __IO uint32_t  SFSP7_1;                           /*!< (@ 0x40086384) Pin configuration register for pins P7                 */
  __IO uint32_t  SFSP7_2;                           /*!< (@ 0x40086388) Pin configuration register for pins P7                 */
  __IO uint32_t  SFSP7_3;                           /*!< (@ 0x4008638C) Pin configuration register for pins P7                 */
  __IO uint32_t  SFSP7_4;                           /*!< (@ 0x40086390) Pin configuration register for pins P7                 */
  __IO uint32_t  SFSP7_5;                           /*!< (@ 0x40086394) Pin configuration register for pins P7                 */
  __IO uint32_t  SFSP7_6;                           /*!< (@ 0x40086398) Pin configuration register for pins P7                 */
  __IO uint32_t  SFSP7_7;                           /*!< (@ 0x4008639C) Pin configuration register for pins P7                 */
  __I  uint32_t  RESERVED7[24];
  __IO uint32_t  SFSP8_0;                           /*!< (@ 0x40086400) Pin configuration register for pins P8                 */
  __IO uint32_t  SFSP8_1;                           /*!< (@ 0x40086404) Pin configuration register for pins P8                 */
  __IO uint32_t  SFSP8_2;                           /*!< (@ 0x40086408) Pin configuration register for pins P8                 */
  __IO uint32_t  SFSP8_3;                           /*!< (@ 0x4008640C) Pin configuration register for pins P8                 */
  __IO uint32_t  SFSP8_4;                           /*!< (@ 0x40086410) Pin configuration register for pins P8                 */
  __IO uint32_t  SFSP8_5;                           /*!< (@ 0x40086414) Pin configuration register for pins P8                 */
  __IO uint32_t  SFSP8_6;                           /*!< (@ 0x40086418) Pin configuration register for pins P8                 */
  __IO uint32_t  SFSP8_7;                           /*!< (@ 0x4008641C) Pin configuration register for pins P8                 */
  __IO uint32_t  SFSP8_8;                           /*!< (@ 0x40086420) Pin configuration register for pins P8                 */
  __I  uint32_t  RESERVED8[23];
  __IO uint32_t  SFSP9_0;                           /*!< (@ 0x40086480) Pin configuration register for pins P9                 */
  __IO uint32_t  SFSP9_1;                           /*!< (@ 0x40086484) Pin configuration register for pins P9                 */
  __IO uint32_t  SFSP9_2;                           /*!< (@ 0x40086488) Pin configuration register for pins P9                 */
  __IO uint32_t  SFSP9_3;                           /*!< (@ 0x4008648C) Pin configuration register for pins P9                 */
  __IO uint32_t  SFSP9_4;                           /*!< (@ 0x40086490) Pin configuration register for pins P9                 */
  __IO uint32_t  SFSP9_5;                           /*!< (@ 0x40086494) Pin configuration register for pins P9                 */
  __IO uint32_t  SFSP9_6;                           /*!< (@ 0x40086498) Pin configuration register for pins P9                 */
  __I  uint32_t  RESERVED9[25];
  __IO uint32_t  SFSPA_0;                           /*!< (@ 0x40086500) Pin configuration register for pins PA                 */
  __IO uint32_t  SFSPA_1;                           /*!< (@ 0x40086504) Pin configuration register for pins PA                 */
  __IO uint32_t  SFSPA_2;                           /*!< (@ 0x40086508) Pin configuration register for pins PA                 */
  __IO uint32_t  SFSPA_3;                           /*!< (@ 0x4008650C) Pin configuration register for pins PA                 */
  __IO uint32_t  SFSPA_4;                           /*!< (@ 0x40086510) Pin configuration register for pins PA                 */
  __I  uint32_t  RESERVED10[27];
  __IO uint32_t  SFSPB_0;                           /*!< (@ 0x40086580) Pin configuration register for pins PB                 */
  __IO uint32_t  SFSPB_1;                           /*!< (@ 0x40086584) Pin configuration register for pins PB                 */
  __IO uint32_t  SFSPB_2;                           /*!< (@ 0x40086588) Pin configuration register for pins PB                 */
  __IO uint32_t  SFSPB_3;                           /*!< (@ 0x4008658C) Pin configuration register for pins PB                 */
  __IO uint32_t  SFSPB_4;                           /*!< (@ 0x40086590) Pin configuration register for pins PB                 */
  __IO uint32_t  SFSPB_5;                           /*!< (@ 0x40086594) Pin configuration register for pins PB                 */
  __IO uint32_t  SFSPB_6;                           /*!< (@ 0x40086598) Pin configuration register for pins PB                 */
  __I  uint32_t  RESERVED11[25];
  __IO uint32_t  SFSPC_0;                           /*!< (@ 0x40086600) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_1;                           /*!< (@ 0x40086604) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_2;                           /*!< (@ 0x40086608) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_3;                           /*!< (@ 0x4008660C) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_4;                           /*!< (@ 0x40086610) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_5;                           /*!< (@ 0x40086614) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_6;                           /*!< (@ 0x40086618) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_7;                           /*!< (@ 0x4008661C) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_8;                           /*!< (@ 0x40086620) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_9;                           /*!< (@ 0x40086624) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_10;                          /*!< (@ 0x40086628) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_11;                          /*!< (@ 0x4008662C) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_12;                          /*!< (@ 0x40086630) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_13;                          /*!< (@ 0x40086634) Pin configuration register for pins PC                 */
  __IO uint32_t  SFSPC_14;                          /*!< (@ 0x40086638) Pin configuration register for pins PC                 */
  __I  uint32_t  RESERVED12[17];
  __IO uint32_t  SFSPD_0;                           /*!< (@ 0x40086680) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_1;                           /*!< (@ 0x40086684) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_2;                           /*!< (@ 0x40086688) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_3;                           /*!< (@ 0x4008668C) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_4;                           /*!< (@ 0x40086690) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_5;                           /*!< (@ 0x40086694) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_6;                           /*!< (@ 0x40086698) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_7;                           /*!< (@ 0x4008669C) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_8;                           /*!< (@ 0x400866A0) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_9;                           /*!< (@ 0x400866A4) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_10;                          /*!< (@ 0x400866A8) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_11;                          /*!< (@ 0x400866AC) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_12;                          /*!< (@ 0x400866B0) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_13;                          /*!< (@ 0x400866B4) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_14;                          /*!< (@ 0x400866B8) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_15;                          /*!< (@ 0x400866BC) Pin configuration register for pins PD                 */
  __IO uint32_t  SFSPD_16;                          /*!< (@ 0x400866C0) Pin configuration register for pins PD                 */
  __I  uint32_t  RESERVED13[15];
  __IO uint32_t  SFSPE_0;                           /*!< (@ 0x40086700) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_1;                           /*!< (@ 0x40086704) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_2;                           /*!< (@ 0x40086708) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_3;                           /*!< (@ 0x4008670C) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_4;                           /*!< (@ 0x40086710) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_5;                           /*!< (@ 0x40086714) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_6;                           /*!< (@ 0x40086718) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_7;                           /*!< (@ 0x4008671C) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_8;                           /*!< (@ 0x40086720) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_9;                           /*!< (@ 0x40086724) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_10;                          /*!< (@ 0x40086728) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_11;                          /*!< (@ 0x4008672C) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_12;                          /*!< (@ 0x40086730) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_13;                          /*!< (@ 0x40086734) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_14;                          /*!< (@ 0x40086738) Pin configuration register for pins PE                 */
  __IO uint32_t  SFSPE_15;                          /*!< (@ 0x4008673C) Pin configuration register for pins PE                 */
  __I  uint32_t  RESERVED14[16];
  __IO uint32_t  SFSPF_0;                           /*!< (@ 0x40086780) Pin configuration register for pins PF                 */
  __IO uint32_t  SFSPF_1;                           /*!< (@ 0x40086784) Pin configuration register for pins PF                 */
  __IO uint32_t  SFSPF_2;                           /*!< (@ 0x40086788) Pin configuration register for pins PF                 */
  __IO uint32_t  SFSPF_3;                           /*!< (@ 0x4008678C) Pin configuration register for pins PF                 */
  __IO uint32_t  SFSPF_4;                           /*!< (@ 0x40086790) Pin configuration register for pins PF                 */
  __IO uint32_t  SFSPF_5;                           /*!< (@ 0x40086794) Pin configuration register for pins PF                 */
  __IO uint32_t  SFSPF_6;                           /*!< (@ 0x40086798) Pin configuration register for pins PF                 */
  __IO uint32_t  SFSPF_7;                           /*!< (@ 0x4008679C) Pin configuration register for pins PF                 */
  __IO uint32_t  SFSPF_8;                           /*!< (@ 0x400867A0) Pin configuration register for pins PF                 */
  __IO uint32_t  SFSPF_9;                           /*!< (@ 0x400867A4) Pin configuration register for pins PF                 */
  __IO uint32_t  SFSPF_10;                          /*!< (@ 0x400867A8) Pin configuration register for pins PF                 */
  __IO uint32_t  SFSPF_11;                          /*!< (@ 0x400867AC) Pin configuration register for pins PF                 */
  __I  uint32_t  RESERVED15[276];
  __IO uint32_t  SFSCLK_0;                          /*!< (@ 0x40086C00) Pin configuration register for pins CLK                */
  __IO uint32_t  SFSCLK_1;                          /*!< (@ 0x40086C04) Pin configuration register for pins CLK                */
  __IO uint32_t  SFSCLK_2;                          /*!< (@ 0x40086C08) Pin configuration register for pins CLK                */
  __IO uint32_t  SFSCLK_3;                          /*!< (@ 0x40086C0C) Pin configuration register for pins CLK                */
  __I  uint32_t  RESERVED16[28];
  __IO uint32_t  SFSUSB;                            /*!< (@ 0x40086C80) Pin configuration register for pins USB1_DM and
                                                         USB1_DP                                                               */
  __IO uint32_t  SFSI2C0;                           /*!< (@ 0x40086C84) Pin configuration register for I2C0-bus pins           */
  __IO uint32_t  ENAIO0;                            /*!< (@ 0x40086C88) ADC0 function select register                          */
  __IO uint32_t  ENAIO1;                            /*!< (@ 0x40086C8C) ADC1 function select register                          */
  __IO uint32_t  ENAIO2;                            /*!< (@ 0x40086C90) Analog function select register                        */
  __I  uint32_t  RESERVED17[27];
  __IO uint32_t  EMCDELAYCLK;                       /*!< (@ 0x40086D00) EMC clock delay register                               */
  __I  uint32_t  RESERVED18[31];
  __IO uint32_t  SDDELAY;                           /*!< (@ 0x40086D80) SD/MMC sample and drive delay register                 */
  __I  uint32_t  RESERVED19[31];
  __IO uint32_t  PINTSEL0;                          /*!< (@ 0x40086E00) Pin interrupt select register for pin interrupts
                                                         0 to 3.                                                               */
  __IO uint32_t  PINTSEL1;                          /*!< (@ 0x40086E04) Pin interrupt select register for pin interrupts
                                                         4 to 7.                                                               */
} LPC_SCU_Type;


/* ================================================================================ */
/* ================                  GPIO_PIN_INT                  ================ */
/* ================================================================================ */


/**
  * @brief GPIO pin interrupt (GPIO_PIN_INT)
  */

typedef struct {                                    /*!< (@ 0x40087000) GPIO_PIN_INT Structure                                 */
  __IO uint32_t  ISEL;                              /*!< (@ 0x40087000) Pin Interrupt Mode register                            */
  __IO uint32_t  IENR;                              /*!< (@ 0x40087004) Pin Interrupt Enable (Rising) register                 */
  __O  uint32_t  SIENR;                             /*!< (@ 0x40087008) Set Pin Interrupt Enable (Rising) register             */
  __O  uint32_t  CIENR;                             /*!< (@ 0x4008700C) Clear Pin Interrupt Enable (Rising) register           */
  __IO uint32_t  IENF;                              /*!< (@ 0x40087010) Pin Interrupt Enable Falling Edge / Active Level
                                                         register                                                              */
  __O  uint32_t  SIENF;                             /*!< (@ 0x40087014) Set Pin Interrupt Enable Falling Edge / Active
                                                         Level register                                                        */
  __O  uint32_t  CIENF;                             /*!< (@ 0x40087018) Clear Pin Interrupt Enable Falling Edge / Active
                                                         Level address                                                         */
  __IO uint32_t  RISE;                              /*!< (@ 0x4008701C) Pin Interrupt Rising Edge register                     */
  __IO uint32_t  FALL;                              /*!< (@ 0x40087020) Pin Interrupt Falling Edge register                    */
  __IO uint32_t  IST;                               /*!< (@ 0x40087024) Pin Interrupt Status register                          */
} LPC_GPIO_PIN_INT_Type;


/* ================================================================================ */
/* ================        GPIO_GROUP_INTn [GPIO_GROUP_INT0]       ================ */
/* ================================================================================ */


/**
  * @brief GPIO group interrupt 0 (GPIO_GROUP_INTn)
  */

typedef struct {                                    /*!< (@ 0x40088000) GPIO_GROUP_INTn Structure                              */
  __IO uint32_t  CTRL;                              /*!< (@ 0x40088000) GPIO grouped interrupt control register                */
  __I  uint32_t  RESERVED0[7];
  __IO uint32_t  PORT_POL0;                         /*!< (@ 0x40088020) GPIO grouped interrupt port polarity register          */
  __IO uint32_t  PORT_POL1;                         /*!< (@ 0x40088024) GPIO grouped interrupt port polarity register          */
  __IO uint32_t  PORT_POL2;                         /*!< (@ 0x40088028) GPIO grouped interrupt port polarity register          */
  __IO uint32_t  PORT_POL3;                         /*!< (@ 0x4008802C) GPIO grouped interrupt port polarity register          */
  __IO uint32_t  PORT_POL4;                         /*!< (@ 0x40088030) GPIO grouped interrupt port polarity register          */
  __IO uint32_t  PORT_POL5;                         /*!< (@ 0x40088034) GPIO grouped interrupt port polarity register          */
  __IO uint32_t  PORT_POL6;                         /*!< (@ 0x40088038) GPIO grouped interrupt port polarity register          */
  __IO uint32_t  PORT_POL7;                         /*!< (@ 0x4008803C) GPIO grouped interrupt port polarity register          */
  __IO uint32_t  PORT_ENA0;                         /*!< (@ 0x40088040) GPIO grouped interrupt port m enable register          */
  __IO uint32_t  PORT_ENA1;                         /*!< (@ 0x40088044) GPIO grouped interrupt port m enable register          */
  __IO uint32_t  PORT_ENA2;                         /*!< (@ 0x40088048) GPIO grouped interrupt port m enable register          */
  __IO uint32_t  PORT_ENA3;                         /*!< (@ 0x4008804C) GPIO grouped interrupt port m enable register          */
  __IO uint32_t  PORT_ENA4;                         /*!< (@ 0x40088050) GPIO grouped interrupt port m enable register          */
  __IO uint32_t  PORT_ENA5;                         /*!< (@ 0x40088054) GPIO grouped interrupt port m enable register          */
  __IO uint32_t  PORT_ENA6;                         /*!< (@ 0x40088058) GPIO grouped interrupt port m enable register          */
  __IO uint32_t  PORT_ENA7;                         /*!< (@ 0x4008805C) GPIO grouped interrupt port m enable register          */
} LPC_GPIO_GROUP_INTn_Type;


/* ================================================================================ */
/* ================                      MCPWM                     ================ */
/* ================================================================================ */


/**
  * @brief Motor Control PWM (MOTOCONPWM)  (MCPWM)
  */

typedef struct {                                    /*!< (@ 0x400A0000) MCPWM Structure                                        */
  __I  uint32_t  CON;                               /*!< (@ 0x400A0000) PWM Control read address                               */
  __O  uint32_t  CON_SET;                           /*!< (@ 0x400A0004) PWM Control set address                                */
  __O  uint32_t  CON_CLR;                           /*!< (@ 0x400A0008) PWM Control clear address                              */
  __I  uint32_t  CAPCON;                            /*!< (@ 0x400A000C) Capture Control read address                           */
  __O  uint32_t  CAPCON_SET;                        /*!< (@ 0x400A0010) Capture Control set address                            */
  __O  uint32_t  CAPCON_CLR;                        /*!< (@ 0x400A0014) Event Control clear address                            */
  __IO uint32_t  TC0;                               /*!< (@ 0x400A0018) Timer Counter register                                 */
  __IO uint32_t  TC1;                               /*!< (@ 0x400A001C) Timer Counter register                                 */
  __IO uint32_t  TC2;                               /*!< (@ 0x400A0020) Timer Counter register                                 */
  __IO uint32_t  LIM0;                              /*!< (@ 0x400A0024) Limit register                                         */
  __IO uint32_t  LIM1;                              /*!< (@ 0x400A0028) Limit register                                         */
  __IO uint32_t  LIM2;                              /*!< (@ 0x400A002C) Limit register                                         */
  __IO uint32_t  MAT0;                              /*!< (@ 0x400A0030) Match register                                         */
  __IO uint32_t  MAT1;                              /*!< (@ 0x400A0034) Match register                                         */
  __IO uint32_t  MAT2;                              /*!< (@ 0x400A0038) Match register                                         */
  __IO uint32_t  DT;                                /*!< (@ 0x400A003C) Dead time register                                     */
  __IO uint32_t  CCP;                               /*!< (@ 0x400A0040) Communication Pattern register                         */
  __I  uint32_t  CAP0;                              /*!< (@ 0x400A0044) Capture register                                       */
  __I  uint32_t  CAP1;                              /*!< (@ 0x400A0048) Capture register                                       */
  __I  uint32_t  CAP2;                              /*!< (@ 0x400A004C) Capture register                                       */
  __I  uint32_t  INTEN;                             /*!< (@ 0x400A0050) Interrupt Enable read address                          */
  __O  uint32_t  INTEN_SET;                         /*!< (@ 0x400A0054) Interrupt Enable set address                           */
  __O  uint32_t  INTEN_CLR;                         /*!< (@ 0x400A0058) Interrupt Enable clear address                         */
  __I  uint32_t  CNTCON;                            /*!< (@ 0x400A005C) Count Control read address                             */
  __O  uint32_t  CNTCON_SET;                        /*!< (@ 0x400A0060) Count Control set address                              */
  __O  uint32_t  CNTCON_CLR;                        /*!< (@ 0x400A0064) Count Control clear address                            */
  __I  uint32_t  INTF;                              /*!< (@ 0x400A0068) Interrupt flags read address                           */
  __O  uint32_t  INTF_SET;                          /*!< (@ 0x400A006C) Interrupt flags set address                            */
  __O  uint32_t  INTF_CLR;                          /*!< (@ 0x400A0070) Interrupt flags clear address                          */
  __O  uint32_t  CAP_CLR;                           /*!< (@ 0x400A0074) Capture clear address                                  */
} LPC_MCPWM_Type;


/* ================================================================================ */
/* ================                   I2Cn [I2C0]                  ================ */
/* ================================================================================ */


/**
  * @brief I2C-bus interface (I2Cn)
  */

typedef struct {                                    /*!< (@ 0x400A1000) I2Cn Structure                                         */
  __IO uint32_t  CONSET;                            /*!< (@ 0x400A1000) I2C Control Set Register. When a one is written
                                                         to a bit of this register, the corresponding bit in the I2C
                                                          control register is set. Writing a zero has no effect on the
                                                          corresponding bit in the I2C control register.                       */
  __I  uint32_t  STAT;                              /*!< (@ 0x400A1004) I2C Status Register. During I2C operation, this
                                                         register provides detailed status codes that allow software
                                                          to determine the next action needed.                                 */
  __IO uint32_t  DAT;                               /*!< (@ 0x400A1008) I2C Data Register. During master or slave transmit
                                                         mode, data to be transmitted is written to this register. During
                                                          master or slave receive mode, data that has been received may
                                                          be read from this register.                                          */
  __IO uint32_t  ADR0;                              /*!< (@ 0x400A100C) I2C Slave Address Register 0. Contains the 7-bit
                                                         slave address for operation of the I2C interface in slave mode,
                                                          and is not used in master mode. The least significant bit determines
                                                          whether a slave responds to the General Call address.                */
  __IO uint32_t  SCLH;                              /*!< (@ 0x400A1010) SCH Duty Cycle Register High Half Word. Determines
                                                         the high time of the I2C clock.                                       */
  __IO uint32_t  SCLL;                              /*!< (@ 0x400A1014) SCL Duty Cycle Register Low Half Word. Determines
                                                         the low time of the I2C clock. SCLL and SCLH together determine
                                                          the clock frequency generated by an I2C master and certain times
                                                          used in slave mode.                                                  */
  __O  uint32_t  CONCLR;                            /*!< (@ 0x400A1018) I2C Control Clear Register. When a one is written
                                                         to a bit of this register, the corresponding bit in the I2C
                                                          control register is cleared. Writing a zero has no effect on
                                                          the corresponding bit in the I2C control register.                   */
  __IO uint32_t  MMCTRL;                            /*!< (@ 0x400A101C) Monitor mode control register.                         */
  __IO uint32_t  ADR1;                              /*!< (@ 0x400A1020) I2C Slave Address Register. Contains the 7-bit
                                                         slave address for operation of the I2C interface in slave mode,
                                                          and is not used in master mode. The least significant bit determines
                                                          whether a slave responds to the General Call address.                */
  __IO uint32_t  ADR2;                              /*!< (@ 0x400A1024) I2C Slave Address Register. Contains the 7-bit
                                                         slave address for operation of the I2C interface in slave mode,
                                                          and is not used in master mode. The least significant bit determines
                                                          whether a slave responds to the General Call address.                */
  __IO uint32_t  ADR3;                              /*!< (@ 0x400A1028) I2C Slave Address Register. Contains the 7-bit
                                                         slave address for operation of the I2C interface in slave mode,
                                                          and is not used in master mode. The least significant bit determines
                                                          whether a slave responds to the General Call address.                */
  __I  uint32_t  DATA_BUFFER;                       /*!< (@ 0x400A102C) Data buffer register. The contents of the 8 MSBs
                                                         of the DAT shift register will be transferred to the DATA_BUFFER
                                                          automatically after every nine bits (8 bits of data plus ACK
                                                          or NACK) has been received on the bus.                               */
  __IO uint32_t  MASK0;                             /*!< (@ 0x400A1030) I2C Slave address mask register                        */
  __IO uint32_t  MASK1;                             /*!< (@ 0x400A1034) I2C Slave address mask register                        */
  __IO uint32_t  MASK2;                             /*!< (@ 0x400A1038) I2C Slave address mask register                        */
  __IO uint32_t  MASK3;                             /*!< (@ 0x400A103C) I2C Slave address mask register                        */
} LPC_I2Cn_Type;


/* ================================================================================ */
/* ================                   I2Sn [I2S0]                  ================ */
/* ================================================================================ */


/**
  * @brief I2S interface  (I2Sn)
  */

typedef struct {                                    /*!< (@ 0x400A2000) I2Sn Structure                                         */
  __IO uint32_t  DAO;                               /*!< (@ 0x400A2000) I2S Digital Audio Output Register. Contains control
                                                         bits for the I2S transmit channel.                                    */
  __IO uint32_t  DAI;                               /*!< (@ 0x400A2004) I2S Digital Audio Input Register. Contains control
                                                         bits for the I2S receive channel.                                     */
  __O  uint32_t  TXFIFO;                            /*!< (@ 0x400A2008) I2S Transmit FIFO. Access register for the 8
                                                         x 32-bit transmitter FIFO.                                            */
  __I  uint32_t  RXFIFO;                            /*!< (@ 0x400A200C) I2S Receive FIFO. Access register for the 8 x
                                                         32-bit receiver FIFO.                                                 */
  __I  uint32_t  STATE;                             /*!< (@ 0x400A2010) I2S Status Feedback Register. Contains status
                                                         information about the I2S interface.                                  */
  __IO uint32_t  DMA1;                              /*!< (@ 0x400A2014) I2S DMA Configuration Register 1. Contains control
                                                         information for DMA request 1.                                        */
  __IO uint32_t  DMA2;                              /*!< (@ 0x400A2018) I2S DMA Configuration Register 2. Contains control
                                                         information for DMA request 2.                                        */
  __IO uint32_t  IRQ;                               /*!< (@ 0x400A201C) I2S Interrupt Request Control Register. Contains
                                                         bits that control how the I2S interrupt request is generated.         */
  __IO uint32_t  TXRATE;                            /*!< (@ 0x400A2020) I2S Transmit MCLK divider. This register determines
                                                         the I2S TX MCLK rate by specifying the value to divide PCLK
                                                          by in order to produce MCLK.                                         */
  __IO uint32_t  RXRATE;                            /*!< (@ 0x400A2024) I2S Receive MCLK divider. This register determines
                                                         the I2S RX MCLK rate by specifying the value to divide PCLK
                                                          by in order to produce MCLK.                                         */
  __IO uint32_t  TXBITRATE;                         /*!< (@ 0x400A2028) I2S Transmit bit rate divider. This register
                                                         determines the I2S transmit bit rate by specifying the value
                                                          to divide TX_MCLK by in order to produce the transmit bit clock.     */
  __IO uint32_t  RXBITRATE;                         /*!< (@ 0x400A202C) I2S Receive bit rate divider. This register determines
                                                         the I2S receive bit rate by specifying the value to divide RX_MCLK
                                                          by in order to produce the receive bit clock.                        */
  __IO uint32_t  TXMODE;                            /*!< (@ 0x400A2030) I2S Transmit mode control.                             */
  __IO uint32_t  RXMODE;                            /*!< (@ 0x400A2034) I2S Receive mode control.                              */
} LPC_I2Sn_Type;


/* ================================================================================ */
/* ================                 C_CANn [C_CAN1]                ================ */
/* ================================================================================ */


/**
  * @brief C_CAN  (C_CANn)
  */

typedef struct {                                    /*!< (@ 0x400A4000) C_CANn Structure                                       */
  __IO uint32_t  CNTL;                              /*!< (@ 0x400A4000) CAN control                                            */
  __IO uint32_t  STAT;                              /*!< (@ 0x400A4004) Status register                                        */
  __I  uint32_t  EC;                                /*!< (@ 0x400A4008) Error counter                                          */
  __IO uint32_t  BT;                                /*!< (@ 0x400A400C) Bit timing register                                    */
  __I  uint32_t  INT;                               /*!< (@ 0x400A4010) Interrupt register                                     */
  __IO uint32_t  TEST;                              /*!< (@ 0x400A4014) Test register                                          */
  __IO uint32_t  BRPE;                              /*!< (@ 0x400A4018) Baud rate prescaler extension register                 */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  IF1_CMDREQ;                        /*!< (@ 0x400A4020) Message interface command request                      */
  
  union {
    __IO uint32_t  IF1_CMDMSK_R;                    /*!< (@ 0x400A4024) Message interface command mask (read direction)        */
    __IO uint32_t  IF1_CMDMSK_W;                    /*!< (@ 0x400A4024) Message interface command mask (write direction)       */
  };
  __IO uint32_t  IF1_MSK1;                          /*!< (@ 0x400A4028) Message interface mask 1                               */
  __IO uint32_t  IF1_MSK2;                          /*!< (@ 0x400A402C) Message interface 1 mask 2                             */
  __IO uint32_t  IF1_ARB1;                          /*!< (@ 0x400A4030) Message interface 1 arbitration 1                      */
  __IO uint32_t  IF1_ARB2;                          /*!< (@ 0x400A4034) Message interface 1 arbitration 2                      */
  __IO uint32_t  IF1_MCTRL;                         /*!< (@ 0x400A4038) Message interface 1 message control                    */
  __IO uint32_t  IF1_DA1;                           /*!< (@ 0x400A403C) Message interface data A1                              */
  __IO uint32_t  IF1_DA2;                           /*!< (@ 0x400A4040) Message interface 1 data A2                            */
  __IO uint32_t  IF1_DB1;                           /*!< (@ 0x400A4044) Message interface 1 data B1                            */
  __IO uint32_t  IF1_DB2;                           /*!< (@ 0x400A4048) Message interface 1 data B2                            */
  __I  uint32_t  RESERVED1[13];
  __IO uint32_t  IF2_CMDREQ;                        /*!< (@ 0x400A4080) Message interface command request                      */
  
  union {
    __IO uint32_t  IF2_CMDMSK_R;                    /*!< (@ 0x400A4084) Message interface command mask (read direction)        */
    __IO uint32_t  IF2_CMDMSK_W;                    /*!< (@ 0x400A4084) Message interface command mask (write direction)       */
  };
  __IO uint32_t  IF2_MSK1;                          /*!< (@ 0x400A4088) Message interface mask 1                               */
  __IO uint32_t  IF2_MSK2;                          /*!< (@ 0x400A408C) Message interface 1 mask 2                             */
  __IO uint32_t  IF2_ARB1;                          /*!< (@ 0x400A4090) Message interface 1 arbitration 1                      */
  __IO uint32_t  IF2_ARB2;                          /*!< (@ 0x400A4094) Message interface 1 arbitration 2                      */
  __IO uint32_t  IF2_MCTRL;                         /*!< (@ 0x400A4098) Message interface 1 message control                    */
  __IO uint32_t  IF2_DA1;                           /*!< (@ 0x400A409C) Message interface data A1                              */
  __IO uint32_t  IF2_DA2;                           /*!< (@ 0x400A40A0) Message interface 1 data A2                            */
  __IO uint32_t  IF2_DB1;                           /*!< (@ 0x400A40A4) Message interface 1 data B1                            */
  __IO uint32_t  IF2_DB2;                           /*!< (@ 0x400A40A8) Message interface 1 data B2                            */
  __I  uint32_t  RESERVED2[21];
  __I  uint32_t  TXREQ1;                            /*!< (@ 0x400A4100) Transmission request 1                                 */
  __I  uint32_t  TXREQ2;                            /*!< (@ 0x400A4104) Transmission request 2                                 */
  __I  uint32_t  RESERVED3[6];
  __I  uint32_t  ND1;                               /*!< (@ 0x400A4120) New data 1                                             */
  __I  uint32_t  ND2;                               /*!< (@ 0x400A4124) New data 2                                             */
  __I  uint32_t  RESERVED4[6];
  __I  uint32_t  IR1;                               /*!< (@ 0x400A4140) Interrupt pending 1                                    */
  __I  uint32_t  IR2;                               /*!< (@ 0x400A4144) Interrupt pending 2                                    */
  __I  uint32_t  RESERVED5[6];
  __I  uint32_t  MSGV1;                             /*!< (@ 0x400A4160) Message valid 1                                        */
  __I  uint32_t  MSGV2;                             /*!< (@ 0x400A4164) Message valid 2                                        */
  __I  uint32_t  RESERVED6[6];
  __IO uint32_t  CLKDIV;                            /*!< (@ 0x400A4180) CAN clock divider register                             */
} LPC_C_CANn_Type;


/* ================================================================================ */
/* ================                     RITIMER                    ================ */
/* ================================================================================ */


/**
  * @brief Repetitive Interrupt Timer (RIT)  (RITIMER)
  */

typedef struct {                                    /*!< (@ 0x400C0000) RITIMER Structure                                      */
  __IO uint32_t  COMPVAL;                           /*!< (@ 0x400C0000) Compare register                                       */
  __IO uint32_t  MASK;                              /*!< (@ 0x400C0004) Mask register. This register holds the 32-bit
                                                         mask value. A 1 written to any bit will force a compare on the
                                                          corresponding bit of the counter and compare register.               */
  __IO uint32_t  CTRL;                              /*!< (@ 0x400C0008) Control register.                                      */
  __IO uint32_t  COUNTER;                           /*!< (@ 0x400C000C) 32-bit counter                                         */
} LPC_RITIMER_Type;


/* ================================================================================ */
/* ================                       QEI                      ================ */
/* ================================================================================ */


/**
  * @brief Quadrature Encoder Interface (QEI)  (QEI)
  */

typedef struct {                                    /*!< (@ 0x400C6000) QEI Structure                                          */
  __O  uint32_t  CON;                               /*!< (@ 0x400C6000) Control register                                       */
  __I  uint32_t  STAT;                              /*!< (@ 0x400C6004) Encoder status register                                */
  __IO uint32_t  CONF;                              /*!< (@ 0x400C6008) Configuration register                                 */
  __I  uint32_t  POS;                               /*!< (@ 0x400C600C) Position register                                      */
  __IO uint32_t  MAXPOS;                            /*!< (@ 0x400C6010) Maximum position register                              */
  __IO uint32_t  CMPOS0;                            /*!< (@ 0x400C6014) position compare register 0                            */
  __IO uint32_t  CMPOS1;                            /*!< (@ 0x400C6018) position compare register 1                            */
  __IO uint32_t  CMPOS2;                            /*!< (@ 0x400C601C) position compare register 2                            */
  __I  uint32_t  INXCNT;                            /*!< (@ 0x400C6020) Index count register                                   */
  __IO uint32_t  INXCMP0;                           /*!< (@ 0x400C6024) Index compare register 0                               */
  __IO uint32_t  LOAD;                              /*!< (@ 0x400C6028) Velocity timer reload register                         */
  __I  uint32_t  TIME;                              /*!< (@ 0x400C602C) Velocity timer register                                */
  __I  uint32_t  VEL;                               /*!< (@ 0x400C6030) Velocity counter register                              */
  __I  uint32_t  CAP;                               /*!< (@ 0x400C6034) Velocity capture register                              */
  __IO uint32_t  VELCOMP;                           /*!< (@ 0x400C6038) Velocity compare register                              */
  __IO uint32_t  FILTERPHA;                         /*!< (@ 0x400C603C) Digital filter register on input phase A (QEI_A)       */
  __IO uint32_t  FILTERPHB;                         /*!< (@ 0x400C6040) Digital filter register on input phase B (QEI_B)       */
  __IO uint32_t  FILTERINX;                         /*!< (@ 0x400C6044) Digital filter register on input index (QEI_IDX)       */
  __IO uint32_t  WINDOW;                            /*!< (@ 0x400C6048) Index acceptance window register                       */
  __IO uint32_t  INXCMP1;                           /*!< (@ 0x400C604C) Index compare register 1                               */
  __IO uint32_t  INXCMP2;                           /*!< (@ 0x400C6050) Index compare register 2                               */
  __I  uint32_t  RESERVED0[993];
  __O  uint32_t  IEC;                               /*!< (@ 0x400C6FD8) Interrupt enable clear register                        */
  __O  uint32_t  IES;                               /*!< (@ 0x400C6FDC) Interrupt enable set register                          */
  __I  uint32_t  INTSTAT;                           /*!< (@ 0x400C6FE0) Interrupt status register                              */
  __I  uint32_t  IE;                                /*!< (@ 0x400C6FE4) Interrupt enable register                              */
  __O  uint32_t  CLR;                               /*!< (@ 0x400C6FE8) Interrupt status clear register                        */
  __O  uint32_t  SET;                               /*!< (@ 0x400C6FEC) Interrupt status set register                          */
} LPC_QEI_Type;


/* ================================================================================ */
/* ================                      GIMA                      ================ */
/* ================================================================================ */


/**
  * @brief Global Input Multiplexer Array (GIMA) (GIMA)
  */

typedef struct {                                    /*!< (@ 0x400C7000) GIMA Structure                                         */
  __IO uint32_t  CAP0_0_IN;                         /*!< (@ 0x400C7000) Timer 0 CAP0_0 capture input multiplexer (GIMA
                                                         output 0)                                                             */
  __IO uint32_t  CAP0_1_IN;                         /*!< (@ 0x400C7004) Timer 0 CAP0_1 capture input multiplexer (GIMA
                                                         output 1)                                                             */
  __IO uint32_t  CAP0_2_IN;                         /*!< (@ 0x400C7008) Timer 0 CAP0_2 capture input multiplexer (GIMA
                                                         output 2)                                                             */
  __IO uint32_t  CAP0_3_IN;                         /*!< (@ 0x400C700C) Timer 0 CAP0_3 capture input multiplexer (GIMA
                                                         output 3)                                                             */
  __IO uint32_t  CAP1_0_IN;                         /*!< (@ 0x400C7010) Timer 1 CAP1_0 capture input multiplexer (GIMA
                                                         output 4)                                                             */
  __IO uint32_t  CAP1_1_IN;                         /*!< (@ 0x400C7014) Timer 1 CAP1_1 capture input multiplexer (GIMA
                                                         output 5)                                                             */
  __IO uint32_t  CAP1_2_IN;                         /*!< (@ 0x400C7018) Timer 1 CAP1_2 capture input multiplexer (GIMA
                                                         output 6)                                                             */
  __IO uint32_t  CAP1_3_IN;                         /*!< (@ 0x400C701C) Timer 1 CAP1_3 capture input multiplexer (GIMA
                                                         output 7)                                                             */
  __IO uint32_t  CAP2_0_IN;                         /*!< (@ 0x400C7020) Timer 2 CAP2_0 capture input multiplexer (GIMA
                                                         output 8)                                                             */
  __IO uint32_t  CAP2_1_IN;                         /*!< (@ 0x400C7024) Timer 2 CAP2_1 capture input multiplexer (GIMA
                                                         output 9)                                                             */
  __IO uint32_t  CAP2_2_IN;                         /*!< (@ 0x400C7028) Timer 2 CAP2_2 capture input multiplexer (GIMA
                                                         output 10)                                                            */
  __IO uint32_t  CAP2_3_IN;                         /*!< (@ 0x400C702C) Timer 2 CAP2_3 capture input multiplexer (GIMA
                                                         output 11)                                                            */
  __IO uint32_t  CAP3_0_IN;                         /*!< (@ 0x400C7030) Timer 3 CAP3_0 capture input multiplexer (GIMA
                                                         output 12)                                                            */
  __IO uint32_t  CAP3_1_IN;                         /*!< (@ 0x400C7034) Timer 3 CAP3_1 capture input multiplexer (GIMA
                                                         output 13)                                                            */
  __IO uint32_t  CAP3_2_IN;                         /*!< (@ 0x400C7038) Timer 3 CAP3_2 capture input multiplexer (GIMA
                                                         output 14)                                                            */
  __IO uint32_t  CAP3_3_IN;                         /*!< (@ 0x400C703C) Timer 3 CAP3_3 capture input multiplexer (GIMA
                                                         output 15)                                                            */
  __IO uint32_t  CTIN_0_IN;                         /*!< (@ 0x400C7040) SCT CTIN_0 capture input multiplexer (GIMA output
                                                         16)                                                                   */
  __IO uint32_t  CTIN_1_IN;                         /*!< (@ 0x400C7044) SCT CTIN_1 capture input multiplexer (GIMA output
                                                         17)                                                                   */
  __IO uint32_t  CTIN_2_IN;                         /*!< (@ 0x400C7048) SCT CTIN_2 capture input multiplexer (GIMA output
                                                         18)                                                                   */
  __IO uint32_t  CTIN_3_IN;                         /*!< (@ 0x400C704C) SCT CTIN_3 capture input multiplexer (GIMA output
                                                         19)                                                                   */
  __IO uint32_t  CTIN_4_IN;                         /*!< (@ 0x400C7050) SCT CTIN_4 capture input multiplexer (GIMA output
                                                         20)                                                                   */
  __IO uint32_t  CTIN_5_IN;                         /*!< (@ 0x400C7054) SCT CTIN_5 capture input multiplexer (GIMA output
                                                         21)                                                                   */
  __IO uint32_t  CTIN_6_IN;                         /*!< (@ 0x400C7058) SCT CTIN_6 capture input multiplexer (GIMA output
                                                         22)                                                                   */
  __IO uint32_t  CTIN_7_IN;                         /*!< (@ 0x400C705C) SCT CTIN_7 capture input multiplexer (GIMA output
                                                         23)                                                                   */
  __IO uint32_t  ADCHS_TRIGGER_IN;                  /*!< (@ 0x400C7060) ADCHS trigger input multiplexer (GIMA output
                                                         24)                                                                   */
  __IO uint32_t  EVENTROUTER_13_IN;                 /*!< (@ 0x400C7064) Event router input 13 multiplexer (GIMA output
                                                         25)                                                                   */
  __IO uint32_t  EVENTROUTER_14_IN;                 /*!< (@ 0x400C7068) Event router input 14 multiplexer (GIMA output
                                                         26)                                                                   */
  __IO uint32_t  EVENTROUTER_16_IN;                 /*!< (@ 0x400C706C) Event router input 16 multiplexer (GIMA output
                                                         27)                                                                   */
  __IO uint32_t  ADCSTART0_IN;                      /*!< (@ 0x400C7070) ADC start0 input multiplexer (GIMA output 28)          */
  __IO uint32_t  ADCSTART1_IN;                      /*!< (@ 0x400C7074) ADC start1 input multiplexer (GIMA output 29)          */
} LPC_GIMA_Type;


/* ================================================================================ */
/* ================                       DAC                      ================ */
/* ================================================================================ */


/**
  * @brief Digital-to-Analog Converter (DAC)  (DAC)
  */

typedef struct {                                    /*!< (@ 0x400E1000) DAC Structure                                          */
  __IO uint32_t  CR;                                /*!< (@ 0x400E1000) DAC register. Holds the conversion data.               */
  __IO uint32_t  CTRL;                              /*!< (@ 0x400E1004) DAC control register.                                  */
  __IO uint32_t  CNTVAL;                            /*!< (@ 0x400E1008) DAC counter value register.                            */
} LPC_DAC_Type;


/* ================================================================================ */
/* ================                   ADCn [ADC0]                  ================ */
/* ================================================================================ */


/**
  * @brief 10-bit Analog-to-Digital Converter (ADC)  (ADCn)
  */

typedef struct {                                    /*!< (@ 0x400E3000) ADCn Structure                                         */
  __IO uint32_t  CR;                                /*!< (@ 0x400E3000) A/D Control Register. The AD0CR register must
                                                         be written to select the operating mode before A/D conversion
                                                          can occur.                                                           */
  __I  uint32_t  GDR;                               /*!< (@ 0x400E3004) A/D Global Data Register. Contains the result
                                                         of the most recent A/D conversion.                                    */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  INTEN;                             /*!< (@ 0x400E300C) A/D Interrupt Enable Register. This register
                                                         contains enable bits that allow the DONE flag of each A/D channel
                                                          to be included or excluded from contributing to the generation
                                                          of an A/D interrupt.                                                 */
  __I  uint32_t  DR[8];                             /*!< (@ 0x400E3010) A/D Channel Data Register. This register contains
                                                         the result of the most recent conversion completed on channel
                                                          n.                                                                   */
  __I  uint32_t  STAT;                              /*!< (@ 0x400E3030) A/D Status Register. This register contains DONE
                                                         and OVERRUN flags for all of the A/D channels, as well as the
                                                          A/D interrupt flag.                                                  */
} LPC_ADCn_Type;


/* ================================================================================ */
/* ================                      ADCHS                     ================ */
/* ================================================================================ */


/**
  * @brief 12-bit Analog-to-Digital Converter High-Speed (ADCHS) (ADCHS)
  */

typedef struct {                                    /*!< (@ 0x400F0000) ADCHS Structure                                        */
  __O  uint32_t  FLUSH;                             /*!< (@ 0x400F0000) Flushes FIFO                                           */
  __IO uint32_t  DMA_REQ;                           /*!< (@ 0x400F0004) Set or clear DMA write request                         */
  __I  uint32_t  FIFO_STS;                          /*!< (@ 0x400F0008) Indicates FIFO fill level status                       */
  __IO uint32_t  FIFO_CFG;                          /*!< (@ 0x400F000C) Configures FIFO fill level that triggers interrupt
                                                         and packing 1 or 2 samples per word.                                  */
  __O  uint32_t  TRIGGER;                           /*!< (@ 0x400F0010) Enable software trigger to start descriptor processing */
  __IO uint32_t  DSCR_STS;                          /*!< (@ 0x400F0014) Indicates active descriptor table and descriptor
                                                         entry                                                                 */
  __IO uint32_t  POWER_DOWN;                        /*!< (@ 0x400F0018) Set or clear power down mode                           */
  __IO uint32_t  CONFIG;                            /*!< (@ 0x400F001C) Configures external trigger mode, store channel
                                                         ID in FIFO and walk-up recovery time from power down.                 */
  __IO uint32_t  THR_A;                             /*!< (@ 0x400F0020) Configures window comparator A levels.                 */
  __IO uint32_t  THR_B;                             /*!< (@ 0x400F0024) Configures window comparator B levels.                 */
  __I  uint32_t  LAST_SAMPLE[6];                    /*!< (@ 0x400F0028) Contains last converted sample of input M [M=0..5)
                                                         and result of window comparator.                                      */
  __I  uint32_t  RESERVED0[49];
  __IO uint32_t  ADC_SPEED;                         /*!< (@ 0x400F0104) ADC speed control                                      */
  __IO uint32_t  POWER_CONTROL;                     /*!< (@ 0x400F0108) Configures ADC power vs. speed, DC-in biasing,
                                                         output format and power gating.                                       */
  __I  uint32_t  RESERVED1[61];
  __I  uint32_t  FIFO_OUTPUT[16];                   /*!< (@ 0x400F0200) FIFO output mapped to 16 consecutive address
                                                         locations. An output contains the value and input channel ID
                                                          of one or two converted samples                                      */
  __I  uint32_t  RESERVED2[48];
  __IO uint32_t  DESCRIPTOR0_[8];                   /*!< (@ 0x400F0300) Table 0 descriptor n, n= 0 to 7                        */
  __IO uint32_t  DESCRIPTOR1_[8];                   /*!< (@ 0x400F0320) Table 1 descriptors n, n=0 to 7                        */
  __I  uint32_t  RESERVED3[752];
  __O  uint32_t  CLR_EN0;                           /*!< (@ 0x400F0F00) Interrupt 0 clear mask                                 */
  __O  uint32_t  SET_EN0;                           /*!< (@ 0x400F0F04) Interrupt 0 set mask                                   */
  __I  uint32_t  MASK0;                             /*!< (@ 0x400F0F08) Interrupt 0 mask                                       */
  __I  uint32_t  STATUS0;                           /*!< (@ 0x400F0F0C) Interrupt 0 status. Interrupt 0 contains FIFO
                                                         fill level, descriptor status and ADC range under/overflow            */
  __O  uint32_t  CLR_STAT0;                         /*!< (@ 0x400F0F10) Interrupt 0 clear status                               */
  __O  uint32_t  SET_STAT0;                         /*!< (@ 0x400F0F14) Interrupt 0 set status                                 */
  __I  uint32_t  RESERVED4[2];
  __O  uint32_t  CLR_EN1;                           /*!< (@ 0x400F0F20) Interrupt 1 mask clear enable.                         */
  __O  uint32_t  SET_EN1;                           /*!< (@ 0x400F0F24) Interrupt 1 mask set enable                            */
  __I  uint32_t  MASK1;                             /*!< (@ 0x400F0F28) Interrupt 1 mask                                       */
  __I  uint32_t  STATUS1;                           /*!< (@ 0x400F0F2C) Interrupt 1 status. Interrupt 1 contains window
                                                         comparator results and register last LAST_SAMPLE[M] overrun.          */
  __O  uint32_t  CLR_STAT1;                         /*!< (@ 0x400F0F30) Interrupt 1 clear status                               */
  __O  uint32_t  SET_STAT1;                         /*!< (@ 0x400F0F34) Interrupt 1 set status                                 */
} LPC_ADCHS_Type;


/* ================================================================================ */
/* ================                    GPIO_PORT                   ================ */
/* ================================================================================ */


/**
  * @brief GPIO port  (GPIO_PORT)
  */

typedef struct {                                    /*!< (@ 0x400F4000) GPIO_PORT Structure                                    */
  __IO uint8_t   B[256];                            /*!< (@ 0x400F4000) Byte pin registers port 0 to 5; pins PIOn_0 to
                                                         PIOn_31                                                               */
  __I  uint32_t  RESERVED0[960];
  __IO uint32_t  W[256];                            /*!< (@ 0x400F5000) Word pin registers port 0 to 5                         */
  __I  uint32_t  RESERVED1[768];
  __IO uint32_t  DIR[8];                            /*!< (@ 0x400F6000) Direction registers port m                             */
  __I  uint32_t  RESERVED2[24];
  __IO uint32_t  MASK[8];                           /*!< (@ 0x400F6080) Mask register port m                                   */
  __I  uint32_t  RESERVED3[24];
  __IO uint32_t  PIN[8];                            /*!< (@ 0x400F6100) Port pin register port m                               */
  __I  uint32_t  RESERVED4[24];
  __IO uint32_t  MPIN[8];                           /*!< (@ 0x400F6180) Masked port register port m                            */
  __I  uint32_t  RESERVED5[24];
  __IO uint32_t  SET[8];                            /*!< (@ 0x400F6200) Write: Set register for port m Read: output bits
                                                         for port m                                                            */
  __I  uint32_t  RESERVED6[24];
  __O  uint32_t  CLR[8];                            /*!< (@ 0x400F6280) Clear port m                                           */
  __I  uint32_t  RESERVED7[24];
  __O  uint32_t  NOT[8];                            /*!< (@ 0x400F6300) Toggle port m                                          */
} LPC_GPIO_PORT_Type;


/* ================================================================================ */
/* ================                       SPI                      ================ */
/* ================================================================================ */


/**
  * @brief SPI  (SPI)
  */

typedef struct {                                    /*!< (@ 0x40100000) SPI Structure                                          */
  __IO uint32_t  CR;                                /*!< (@ 0x40100000) SPI Control Register. This register controls
                                                         the operation of the SPI.                                             */
  __I  uint32_t  SR;                                /*!< (@ 0x40100004) SPI Status Register. This register shows the
                                                         status of the SPI.                                                    */
  __IO uint32_t  DR;                                /*!< (@ 0x40100008) SPI Data Register. This bi-directional register
                                                         provides the transmit and receive data for the SPI. Transmit
                                                          data is provided to the SPI0 by writing to this register. Data
                                                          received by the SPI0 can be read from this register.                 */
  __IO uint32_t  CCR;                               /*!< (@ 0x4010000C) SPI Clock Counter Register. This register controls
                                                         the frequency of a master's SCK0.                                     */
  __IO uint32_t  TCR;                               /*!< (@ 0x40100010) SPI Test Control register. For functional testing
                                                         only.                                                                 */
  __IO uint32_t  TSR;                               /*!< (@ 0x40100014) SPI Test Status register. For functional testing
                                                         only.                                                                 */
  __I  uint32_t  RESERVED0;
  __IO uint32_t  INT;                               /*!< (@ 0x4010001C) SPI Interrupt Flag. This register contains the
                                                         interrupt flag for the SPI interface.                                 */
} LPC_SPI_Type;


/* ================================================================================ */
/* ================                      SGPIO                     ================ */
/* ================================================================================ */


/**
  * @brief Serial GPIO (SGPIO) (SGPIO)
  */

typedef struct {                                    /*!< (@ 0x40101000) SGPIO Structure                                        */
  __IO uint32_t  OUT_MUX_CFG[16];                   /*!< (@ 0x40101000) Pin multiplexer configuration registers.               */
  __IO uint32_t  SGPIO_MUX_CFG[16];                 /*!< (@ 0x40101040) SGPIO multiplexer configuration registers.             */
  __IO uint32_t  SLICE_MUX_CFG[16];                 /*!< (@ 0x40101080) Slice multiplexer configuration registers.             */
  __IO uint32_t  REG[16];                           /*!< (@ 0x401010C0) Slice data registers. Each time COUNT0 reaches
                                                         0x0 the register shifts loading bit 31 with data captured from
                                                          DIN(n). DOUT(n) is set to REG(0)                                     */
  __IO uint32_t  REG_SS[16];                        /*!< (@ 0x40101100) Slice data shadow registers. Each time POS reaches
                                                         0x0 the contents of REG_SS is exchanged with the content of
                                                          REG                                                                  */
  __IO uint32_t  PRESET[16];                        /*!< (@ 0x40101140) Reload value of COUNT0, loaded when COUNT0 reaches
                                                         0x0                                                                   */
  __IO uint32_t  COUNT[16];                         /*!< (@ 0x40101180) Down counter, counts down each clock cycle.            */
  __IO uint32_t  POS[16];                           /*!< (@ 0x401011C0) Each time COUNT0 reaches 0x0 POS counts down.          */
  __IO uint32_t  MASK_A;                            /*!< (@ 0x40101200) Mask for pattern match function of slice A             */
  __IO uint32_t  MASK_H;                            /*!< (@ 0x40101204) Mask for pattern match function of slice H             */
  __IO uint32_t  MASK_I;                            /*!< (@ 0x40101208) Mask for pattern match function of slice I             */
  __IO uint32_t  MASK_P;                            /*!< (@ 0x4010120C) Mask for pattern match function of slice P             */
  __I  uint32_t  GPIO_INREG;                        /*!< (@ 0x40101210) GPIO input status register                             */
  __IO uint32_t  GPIO_OUTREG;                       /*!< (@ 0x40101214) GPIO output control register                           */
  __IO uint32_t  GPIO_OENREG;                       /*!< (@ 0x40101218) GPIO OE control register                               */
  __IO uint32_t  CTRL_ENABLE;                       /*!< (@ 0x4010121C) Enables the slice COUNT counter                        */
  __IO uint32_t  CTRL_DISABLE;                      /*!< (@ 0x40101220) Disables the slice POS counter                         */
  __I  uint32_t  RESERVED0[823];
  __O  uint32_t  CLR_EN_0;                          /*!< (@ 0x40101F00) Shift clock interrupt clear mask                       */
  __O  uint32_t  SET_EN_0;                          /*!< (@ 0x40101F04) Shift clock interrupt set mask                         */
  __I  uint32_t  ENABLE_0;                          /*!< (@ 0x40101F08) Shift clock interrupt enable                           */
  __I  uint32_t  STATUS_0;                          /*!< (@ 0x40101F0C) Shift clock interrupt status                           */
  __O  uint32_t  CLR_STATUS_0;                      /*!< (@ 0x40101F10) Shift clock interrupt clear status                     */
  __O  uint32_t  SET_STATUS_0;                      /*!< (@ 0x40101F14) Shift clock interrupt set status                       */
  __I  uint32_t  RESERVED1[2];
  __O  uint32_t  CLR_EN_1;                          /*!< (@ 0x40101F20) Exchange clock interrupt clear mask                    */
  __O  uint32_t  SET_EN_1;                          /*!< (@ 0x40101F24) Exchange clock interrupt set mask                      */
  __I  uint32_t  ENABLE_1;                          /*!< (@ 0x40101F28) Exchange clock interrupt enable                        */
  __I  uint32_t  STATUS_1;                          /*!< (@ 0x40101F2C) Exchange clock interrupt status                        */
  __O  uint32_t  CLR_STATUS_1;                      /*!< (@ 0x40101F30) Exchange clock interrupt clear status                  */
  __O  uint32_t  SET_STATUS_1;                      /*!< (@ 0x40101F34) Exchange clock interrupt set status                    */
  __I  uint32_t  RESERVED2[2];
  __O  uint32_t  CLR_EN_2;                          /*!< (@ 0x40101F40) Pattern match interrupt clear mask                     */
  __O  uint32_t  SET_EN_2;                          /*!< (@ 0x40101F44) Pattern match interrupt set mask                       */
  __I  uint32_t  ENABLE_2;                          /*!< (@ 0x40101F48) Pattern match interrupt enable                         */
  __I  uint32_t  STATUS_2;                          /*!< (@ 0x40101F4C) Pattern match interrupt status                         */
  __O  uint32_t  CLR_STATUS_2;                      /*!< (@ 0x40101F50) Pattern match interrupt clear status                   */
  __O  uint32_t  SET_STATUS_2;                      /*!< (@ 0x40101F54) Pattern match interrupt set status                     */
  __I  uint32_t  RESERVED3[2];
  __O  uint32_t  CLR_EN_3;                          /*!< (@ 0x40101F60) Input interrupt clear mask                             */
  __O  uint32_t  SET_EN_3;                          /*!< (@ 0x40101F64) Input bit match interrupt set mask                     */
  __I  uint32_t  ENABLE_3;                          /*!< (@ 0x40101F68) Input bit match interrupt enable                       */
  __I  uint32_t  STATUS_3;                          /*!< (@ 0x40101F6C) Input bit match interrupt status                       */
  __O  uint32_t  CLR_STATUS_3;                      /*!< (@ 0x40101F70) Input bit match interrupt clear status                 */
  __O  uint32_t  SET_STATUS_3;                      /*!< (@ 0x40101F74) Input bit match interrupt set status                   */
} LPC_SGPIO_Type;


/* --------------------  End of section using anonymous unions  ------------------- */
#if defined(__CC_ARM)
  #pragma pop
#elif defined(__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined(__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined(__TASKING__)
  #pragma warning restore
#else
  #warning Not supported compiler type
#endif


#ifdef CMSIS_BITPOSITIONS
/* ================================================================================ */
/* ================          struct 'SCT' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  SCT_CONFIG  --------------------------------- */
#define SCT_CONFIG_UNIFY_Pos                  0                                                       /*!< SCT CONFIG: UNIFY Position              */
#define SCT_CONFIG_UNIFY_Msk                  (0x01UL << SCT_CONFIG_UNIFY_Pos)                        /*!< SCT CONFIG: UNIFY Mask                  */
#define SCT_CONFIG_CLKMODE_Pos                1                                                       /*!< SCT CONFIG: CLKMODE Position            */
#define SCT_CONFIG_CLKMODE_Msk                (0x03UL << SCT_CONFIG_CLKMODE_Pos)                      /*!< SCT CONFIG: CLKMODE Mask                */
#define SCT_CONFIG_CKSEL_Pos                  3                                                       /*!< SCT CONFIG: CKSEL Position              */
#define SCT_CONFIG_CKSEL_Msk                  (0x0fUL << SCT_CONFIG_CKSEL_Pos)                        /*!< SCT CONFIG: CKSEL Mask                  */
#define SCT_CONFIG_NORELAOD_L_Pos             7                                                       /*!< SCT CONFIG: NORELAOD_L Position         */
#define SCT_CONFIG_NORELAOD_L_Msk             (0x01UL << SCT_CONFIG_NORELAOD_L_Pos)                   /*!< SCT CONFIG: NORELAOD_L Mask             */
#define SCT_CONFIG_NORELOAD_H_Pos             8                                                       /*!< SCT CONFIG: NORELOAD_H Position         */
#define SCT_CONFIG_NORELOAD_H_Msk             (0x01UL << SCT_CONFIG_NORELOAD_H_Pos)                   /*!< SCT CONFIG: NORELOAD_H Mask             */
#define SCT_CONFIG_INSYNC_Pos                 9                                                       /*!< SCT CONFIG: INSYNC Position             */
#define SCT_CONFIG_INSYNC_Msk                 (0x000000ffUL << SCT_CONFIG_INSYNC_Pos)                 /*!< SCT CONFIG: INSYNC Mask                 */
#define SCT_CONFIG_AUTOLIMIT_L_Pos            17                                                      /*!< SCT CONFIG: AUTOLIMIT_L Position        */
#define SCT_CONFIG_AUTOLIMIT_L_Msk            (0x01UL << SCT_CONFIG_AUTOLIMIT_L_Pos)                  /*!< SCT CONFIG: AUTOLIMIT_L Mask            */
#define SCT_CONFIG_AUTOLIMIT_H_Pos            18                                                      /*!< SCT CONFIG: AUTOLIMIT_H Position        */
#define SCT_CONFIG_AUTOLIMIT_H_Msk            (0x01UL << SCT_CONFIG_AUTOLIMIT_H_Pos)                  /*!< SCT CONFIG: AUTOLIMIT_H Mask            */

/* ----------------------------------  SCT_CTRL  ---------------------------------- */
#define SCT_CTRL_DOWN_L_Pos                   0                                                       /*!< SCT CTRL: DOWN_L Position               */
#define SCT_CTRL_DOWN_L_Msk                   (0x01UL << SCT_CTRL_DOWN_L_Pos)                         /*!< SCT CTRL: DOWN_L Mask                   */
#define SCT_CTRL_STOP_L_Pos                   1                                                       /*!< SCT CTRL: STOP_L Position               */
#define SCT_CTRL_STOP_L_Msk                   (0x01UL << SCT_CTRL_STOP_L_Pos)                         /*!< SCT CTRL: STOP_L Mask                   */
#define SCT_CTRL_HALT_L_Pos                   2                                                       /*!< SCT CTRL: HALT_L Position               */
#define SCT_CTRL_HALT_L_Msk                   (0x01UL << SCT_CTRL_HALT_L_Pos)                         /*!< SCT CTRL: HALT_L Mask                   */
#define SCT_CTRL_CLRCTR_L_Pos                 3                                                       /*!< SCT CTRL: CLRCTR_L Position             */
#define SCT_CTRL_CLRCTR_L_Msk                 (0x01UL << SCT_CTRL_CLRCTR_L_Pos)                       /*!< SCT CTRL: CLRCTR_L Mask                 */
#define SCT_CTRL_BIDIR_L_Pos                  4                                                       /*!< SCT CTRL: BIDIR_L Position              */
#define SCT_CTRL_BIDIR_L_Msk                  (0x01UL << SCT_CTRL_BIDIR_L_Pos)                        /*!< SCT CTRL: BIDIR_L Mask                  */
#define SCT_CTRL_PRE_L_Pos                    5                                                       /*!< SCT CTRL: PRE_L Position                */
#define SCT_CTRL_PRE_L_Msk                    (0x000000ffUL << SCT_CTRL_PRE_L_Pos)                    /*!< SCT CTRL: PRE_L Mask                    */
#define SCT_CTRL_DOWN_H_Pos                   16                                                      /*!< SCT CTRL: DOWN_H Position               */
#define SCT_CTRL_DOWN_H_Msk                   (0x01UL << SCT_CTRL_DOWN_H_Pos)                         /*!< SCT CTRL: DOWN_H Mask                   */
#define SCT_CTRL_STOP_H_Pos                   17                                                      /*!< SCT CTRL: STOP_H Position               */
#define SCT_CTRL_STOP_H_Msk                   (0x01UL << SCT_CTRL_STOP_H_Pos)                         /*!< SCT CTRL: STOP_H Mask                   */
#define SCT_CTRL_HALT_H_Pos                   18                                                      /*!< SCT CTRL: HALT_H Position               */
#define SCT_CTRL_HALT_H_Msk                   (0x01UL << SCT_CTRL_HALT_H_Pos)                         /*!< SCT CTRL: HALT_H Mask                   */
#define SCT_CTRL_CLRCTR_H_Pos                 19                                                      /*!< SCT CTRL: CLRCTR_H Position             */
#define SCT_CTRL_CLRCTR_H_Msk                 (0x01UL << SCT_CTRL_CLRCTR_H_Pos)                       /*!< SCT CTRL: CLRCTR_H Mask                 */
#define SCT_CTRL_BIDIR_H_Pos                  20                                                      /*!< SCT CTRL: BIDIR_H Position              */
#define SCT_CTRL_BIDIR_H_Msk                  (0x01UL << SCT_CTRL_BIDIR_H_Pos)                        /*!< SCT CTRL: BIDIR_H Mask                  */
#define SCT_CTRL_PRE_H_Pos                    21                                                      /*!< SCT CTRL: PRE_H Position                */
#define SCT_CTRL_PRE_H_Msk                    (0x000000ffUL << SCT_CTRL_PRE_H_Pos)                    /*!< SCT CTRL: PRE_H Mask                    */

/* ----------------------------------  SCT_LIMIT  --------------------------------- */
#define SCT_LIMIT_LIMMSK_L_Pos                0                                                       /*!< SCT LIMIT: LIMMSK_L Position            */
#define SCT_LIMIT_LIMMSK_L_Msk                (0x0000ffffUL << SCT_LIMIT_LIMMSK_L_Pos)                /*!< SCT LIMIT: LIMMSK_L Mask                */
#define SCT_LIMIT_LIMMSK_H_Pos                16                                                      /*!< SCT LIMIT: LIMMSK_H Position            */
#define SCT_LIMIT_LIMMSK_H_Msk                (0x0000ffffUL << SCT_LIMIT_LIMMSK_H_Pos)                /*!< SCT LIMIT: LIMMSK_H Mask                */

/* ----------------------------------  SCT_HALT  ---------------------------------- */
#define SCT_HALT_HALTMSK_L_Pos                0                                                       /*!< SCT HALT: HALTMSK_L Position            */
#define SCT_HALT_HALTMSK_L_Msk                (0x0000ffffUL << SCT_HALT_HALTMSK_L_Pos)                /*!< SCT HALT: HALTMSK_L Mask                */
#define SCT_HALT_HALTMSK_H_Pos                16                                                      /*!< SCT HALT: HALTMSK_H Position            */
#define SCT_HALT_HALTMSK_H_Msk                (0x0000ffffUL << SCT_HALT_HALTMSK_H_Pos)                /*!< SCT HALT: HALTMSK_H Mask                */

/* ----------------------------------  SCT_STOP  ---------------------------------- */
#define SCT_STOP_STOPMSK_L_Pos                0                                                       /*!< SCT STOP: STOPMSK_L Position            */
#define SCT_STOP_STOPMSK_L_Msk                (0x0000ffffUL << SCT_STOP_STOPMSK_L_Pos)                /*!< SCT STOP: STOPMSK_L Mask                */
#define SCT_STOP_STOPMSK_H_Pos                16                                                      /*!< SCT STOP: STOPMSK_H Position            */
#define SCT_STOP_STOPMSK_H_Msk                (0x0000ffffUL << SCT_STOP_STOPMSK_H_Pos)                /*!< SCT STOP: STOPMSK_H Mask                */

/* ----------------------------------  SCT_START  --------------------------------- */
#define SCT_START_STARTMSK_L_Pos              0                                                       /*!< SCT START: STARTMSK_L Position          */
#define SCT_START_STARTMSK_L_Msk              (0x0000ffffUL << SCT_START_STARTMSK_L_Pos)              /*!< SCT START: STARTMSK_L Mask              */
#define SCT_START_STARTMSK_H_Pos              16                                                      /*!< SCT START: STARTMSK_H Position          */
#define SCT_START_STARTMSK_H_Msk              (0x0000ffffUL << SCT_START_STARTMSK_H_Pos)              /*!< SCT START: STARTMSK_H Mask              */

/* ---------------------------------  SCT_DITHER  --------------------------------- */
#define SCT_DITHER_DITHMSK_L_Pos              0                                                       /*!< SCT DITHER: DITHMSK_L Position          */
#define SCT_DITHER_DITHMSK_L_Msk              (0x0000ffffUL << SCT_DITHER_DITHMSK_L_Pos)              /*!< SCT DITHER: DITHMSK_L Mask              */
#define SCT_DITHER_DITHMSK_H_Pos              16                                                      /*!< SCT DITHER: DITHMSK_H Position          */
#define SCT_DITHER_DITHMSK_H_Msk              (0x0000ffffUL << SCT_DITHER_DITHMSK_H_Pos)              /*!< SCT DITHER: DITHMSK_H Mask              */

/* ----------------------------------  SCT_COUNT  --------------------------------- */
#define SCT_COUNT_CTR_L_Pos                   0                                                       /*!< SCT COUNT: CTR_L Position               */
#define SCT_COUNT_CTR_L_Msk                   (0x0000ffffUL << SCT_COUNT_CTR_L_Pos)                   /*!< SCT COUNT: CTR_L Mask                   */
#define SCT_COUNT_CTR_H_Pos                   16                                                      /*!< SCT COUNT: CTR_H Position               */
#define SCT_COUNT_CTR_H_Msk                   (0x0000ffffUL << SCT_COUNT_CTR_H_Pos)                   /*!< SCT COUNT: CTR_H Mask                   */

/* ----------------------------------  SCT_STATE  --------------------------------- */
#define SCT_STATE_STATE_L_Pos                 0                                                       /*!< SCT STATE: STATE_L Position             */
#define SCT_STATE_STATE_L_Msk                 (0x1fUL << SCT_STATE_STATE_L_Pos)                       /*!< SCT STATE: STATE_L Mask                 */
#define SCT_STATE_STATE_H_Pos                 16                                                      /*!< SCT STATE: STATE_H Position             */
#define SCT_STATE_STATE_H_Msk                 (0x1fUL << SCT_STATE_STATE_H_Pos)                       /*!< SCT STATE: STATE_H Mask                 */

/* ----------------------------------  SCT_INPUT  --------------------------------- */
#define SCT_INPUT_AIN0_Pos                    0                                                       /*!< SCT INPUT: AIN0 Position                */
#define SCT_INPUT_AIN0_Msk                    (0x01UL << SCT_INPUT_AIN0_Pos)                          /*!< SCT INPUT: AIN0 Mask                    */
#define SCT_INPUT_AIN1_Pos                    1                                                       /*!< SCT INPUT: AIN1 Position                */
#define SCT_INPUT_AIN1_Msk                    (0x01UL << SCT_INPUT_AIN1_Pos)                          /*!< SCT INPUT: AIN1 Mask                    */
#define SCT_INPUT_AIN2_Pos                    2                                                       /*!< SCT INPUT: AIN2 Position                */
#define SCT_INPUT_AIN2_Msk                    (0x01UL << SCT_INPUT_AIN2_Pos)                          /*!< SCT INPUT: AIN2 Mask                    */
#define SCT_INPUT_AIN3_Pos                    3                                                       /*!< SCT INPUT: AIN3 Position                */
#define SCT_INPUT_AIN3_Msk                    (0x01UL << SCT_INPUT_AIN3_Pos)                          /*!< SCT INPUT: AIN3 Mask                    */
#define SCT_INPUT_AIN4_Pos                    4                                                       /*!< SCT INPUT: AIN4 Position                */
#define SCT_INPUT_AIN4_Msk                    (0x01UL << SCT_INPUT_AIN4_Pos)                          /*!< SCT INPUT: AIN4 Mask                    */
#define SCT_INPUT_AIN5_Pos                    5                                                       /*!< SCT INPUT: AIN5 Position                */
#define SCT_INPUT_AIN5_Msk                    (0x01UL << SCT_INPUT_AIN5_Pos)                          /*!< SCT INPUT: AIN5 Mask                    */
#define SCT_INPUT_AIN6_Pos                    6                                                       /*!< SCT INPUT: AIN6 Position                */
#define SCT_INPUT_AIN6_Msk                    (0x01UL << SCT_INPUT_AIN6_Pos)                          /*!< SCT INPUT: AIN6 Mask                    */
#define SCT_INPUT_AIN7_Pos                    7                                                       /*!< SCT INPUT: AIN7 Position                */
#define SCT_INPUT_AIN7_Msk                    (0x01UL << SCT_INPUT_AIN7_Pos)                          /*!< SCT INPUT: AIN7 Mask                    */
#define SCT_INPUT_SIN0_Pos                    16                                                      /*!< SCT INPUT: SIN0 Position                */
#define SCT_INPUT_SIN0_Msk                    (0x01UL << SCT_INPUT_SIN0_Pos)                          /*!< SCT INPUT: SIN0 Mask                    */
#define SCT_INPUT_SIN1_Pos                    17                                                      /*!< SCT INPUT: SIN1 Position                */
#define SCT_INPUT_SIN1_Msk                    (0x01UL << SCT_INPUT_SIN1_Pos)                          /*!< SCT INPUT: SIN1 Mask                    */
#define SCT_INPUT_SIN2_Pos                    18                                                      /*!< SCT INPUT: SIN2 Position                */
#define SCT_INPUT_SIN2_Msk                    (0x01UL << SCT_INPUT_SIN2_Pos)                          /*!< SCT INPUT: SIN2 Mask                    */
#define SCT_INPUT_SIN3_Pos                    19                                                      /*!< SCT INPUT: SIN3 Position                */
#define SCT_INPUT_SIN3_Msk                    (0x01UL << SCT_INPUT_SIN3_Pos)                          /*!< SCT INPUT: SIN3 Mask                    */
#define SCT_INPUT_SIN4_Pos                    20                                                      /*!< SCT INPUT: SIN4 Position                */
#define SCT_INPUT_SIN4_Msk                    (0x01UL << SCT_INPUT_SIN4_Pos)                          /*!< SCT INPUT: SIN4 Mask                    */
#define SCT_INPUT_SIN5_Pos                    21                                                      /*!< SCT INPUT: SIN5 Position                */
#define SCT_INPUT_SIN5_Msk                    (0x01UL << SCT_INPUT_SIN5_Pos)                          /*!< SCT INPUT: SIN5 Mask                    */
#define SCT_INPUT_SIN6_Pos                    22                                                      /*!< SCT INPUT: SIN6 Position                */
#define SCT_INPUT_SIN6_Msk                    (0x01UL << SCT_INPUT_SIN6_Pos)                          /*!< SCT INPUT: SIN6 Mask                    */
#define SCT_INPUT_SIN7_Pos                    23                                                      /*!< SCT INPUT: SIN7 Position                */
#define SCT_INPUT_SIN7_Msk                    (0x01UL << SCT_INPUT_SIN7_Pos)                          /*!< SCT INPUT: SIN7 Mask                    */

/* ---------------------------------  SCT_REGMODE  -------------------------------- */
#define SCT_REGMODE_REGMOD_L_Pos              0                                                       /*!< SCT REGMODE: REGMOD_L Position          */
#define SCT_REGMODE_REGMOD_L_Msk              (0x0000ffffUL << SCT_REGMODE_REGMOD_L_Pos)              /*!< SCT REGMODE: REGMOD_L Mask              */
#define SCT_REGMODE_REGMOD_H_Pos              16                                                      /*!< SCT REGMODE: REGMOD_H Position          */
#define SCT_REGMODE_REGMOD_H_Msk              (0x0000ffffUL << SCT_REGMODE_REGMOD_H_Pos)              /*!< SCT REGMODE: REGMOD_H Mask              */

/* ---------------------------------  SCT_OUTPUT  --------------------------------- */
#define SCT_OUTPUT_OUT_Pos                    0                                                       /*!< SCT OUTPUT: OUT Position                */
#define SCT_OUTPUT_OUT_Msk                    (0x0000ffffUL << SCT_OUTPUT_OUT_Pos)                    /*!< SCT OUTPUT: OUT Mask                    */

/* ------------------------------  SCT_OUTPUTDIRCTRL  ----------------------------- */
#define SCT_OUTPUTDIRCTRL_SETCLR0_Pos         0                                                       /*!< SCT OUTPUTDIRCTRL: SETCLR0 Position     */
#define SCT_OUTPUTDIRCTRL_SETCLR0_Msk         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR0_Pos)               /*!< SCT OUTPUTDIRCTRL: SETCLR0 Mask         */
#define SCT_OUTPUTDIRCTRL_SETCLR1_Pos         2                                                       /*!< SCT OUTPUTDIRCTRL: SETCLR1 Position     */
#define SCT_OUTPUTDIRCTRL_SETCLR1_Msk         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR1_Pos)               /*!< SCT OUTPUTDIRCTRL: SETCLR1 Mask         */
#define SCT_OUTPUTDIRCTRL_SETCLR2_Pos         4                                                       /*!< SCT OUTPUTDIRCTRL: SETCLR2 Position     */
#define SCT_OUTPUTDIRCTRL_SETCLR2_Msk         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR2_Pos)               /*!< SCT OUTPUTDIRCTRL: SETCLR2 Mask         */
#define SCT_OUTPUTDIRCTRL_SETCLR3_Pos         6                                                       /*!< SCT OUTPUTDIRCTRL: SETCLR3 Position     */
#define SCT_OUTPUTDIRCTRL_SETCLR3_Msk         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR3_Pos)               /*!< SCT OUTPUTDIRCTRL: SETCLR3 Mask         */
#define SCT_OUTPUTDIRCTRL_SETCLR4_Pos         8                                                       /*!< SCT OUTPUTDIRCTRL: SETCLR4 Position     */
#define SCT_OUTPUTDIRCTRL_SETCLR4_Msk         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR4_Pos)               /*!< SCT OUTPUTDIRCTRL: SETCLR4 Mask         */
#define SCT_OUTPUTDIRCTRL_SETCLR5_Pos         10                                                      /*!< SCT OUTPUTDIRCTRL: SETCLR5 Position     */
#define SCT_OUTPUTDIRCTRL_SETCLR5_Msk         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR5_Pos)               /*!< SCT OUTPUTDIRCTRL: SETCLR5 Mask         */
#define SCT_OUTPUTDIRCTRL_SETCLR6_Pos         12                                                      /*!< SCT OUTPUTDIRCTRL: SETCLR6 Position     */
#define SCT_OUTPUTDIRCTRL_SETCLR6_Msk         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR6_Pos)               /*!< SCT OUTPUTDIRCTRL: SETCLR6 Mask         */
#define SCT_OUTPUTDIRCTRL_SETCLR7_Pos         14                                                      /*!< SCT OUTPUTDIRCTRL: SETCLR7 Position     */
#define SCT_OUTPUTDIRCTRL_SETCLR7_Msk         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR7_Pos)               /*!< SCT OUTPUTDIRCTRL: SETCLR7 Mask         */
#define SCT_OUTPUTDIRCTRL_SETCLR8_Pos         16                                                      /*!< SCT OUTPUTDIRCTRL: SETCLR8 Position     */
#define SCT_OUTPUTDIRCTRL_SETCLR8_Msk         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR8_Pos)               /*!< SCT OUTPUTDIRCTRL: SETCLR8 Mask         */
#define SCT_OUTPUTDIRCTRL_SETCLR9_Pos         18                                                      /*!< SCT OUTPUTDIRCTRL: SETCLR9 Position     */
#define SCT_OUTPUTDIRCTRL_SETCLR9_Msk         (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR9_Pos)               /*!< SCT OUTPUTDIRCTRL: SETCLR9 Mask         */
#define SCT_OUTPUTDIRCTRL_SETCLR10_Pos        20                                                      /*!< SCT OUTPUTDIRCTRL: SETCLR10 Position    */
#define SCT_OUTPUTDIRCTRL_SETCLR10_Msk        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR10_Pos)              /*!< SCT OUTPUTDIRCTRL: SETCLR10 Mask        */
#define SCT_OUTPUTDIRCTRL_SETCLR11_Pos        22                                                      /*!< SCT OUTPUTDIRCTRL: SETCLR11 Position    */
#define SCT_OUTPUTDIRCTRL_SETCLR11_Msk        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR11_Pos)              /*!< SCT OUTPUTDIRCTRL: SETCLR11 Mask        */
#define SCT_OUTPUTDIRCTRL_SETCLR12_Pos        24                                                      /*!< SCT OUTPUTDIRCTRL: SETCLR12 Position    */
#define SCT_OUTPUTDIRCTRL_SETCLR12_Msk        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR12_Pos)              /*!< SCT OUTPUTDIRCTRL: SETCLR12 Mask        */
#define SCT_OUTPUTDIRCTRL_SETCLR13_Pos        26                                                      /*!< SCT OUTPUTDIRCTRL: SETCLR13 Position    */
#define SCT_OUTPUTDIRCTRL_SETCLR13_Msk        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR13_Pos)              /*!< SCT OUTPUTDIRCTRL: SETCLR13 Mask        */
#define SCT_OUTPUTDIRCTRL_SETCLR14_Pos        28                                                      /*!< SCT OUTPUTDIRCTRL: SETCLR14 Position    */
#define SCT_OUTPUTDIRCTRL_SETCLR14_Msk        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR14_Pos)              /*!< SCT OUTPUTDIRCTRL: SETCLR14 Mask        */
#define SCT_OUTPUTDIRCTRL_SETCLR15_Pos        30                                                      /*!< SCT OUTPUTDIRCTRL: SETCLR15 Position    */
#define SCT_OUTPUTDIRCTRL_SETCLR15_Msk        (0x03UL << SCT_OUTPUTDIRCTRL_SETCLR15_Pos)              /*!< SCT OUTPUTDIRCTRL: SETCLR15 Mask        */

/* -----------------------------------  SCT_RES  ---------------------------------- */
#define SCT_RES_O0RES_Pos                     0                                                       /*!< SCT RES: O0RES Position                 */
#define SCT_RES_O0RES_Msk                     (0x03UL << SCT_RES_O0RES_Pos)                           /*!< SCT RES: O0RES Mask                     */
#define SCT_RES_O1RES_Pos                     2                                                       /*!< SCT RES: O1RES Position                 */
#define SCT_RES_O1RES_Msk                     (0x03UL << SCT_RES_O1RES_Pos)                           /*!< SCT RES: O1RES Mask                     */
#define SCT_RES_O2RES_Pos                     4                                                       /*!< SCT RES: O2RES Position                 */
#define SCT_RES_O2RES_Msk                     (0x03UL << SCT_RES_O2RES_Pos)                           /*!< SCT RES: O2RES Mask                     */
#define SCT_RES_O3RES_Pos                     6                                                       /*!< SCT RES: O3RES Position                 */
#define SCT_RES_O3RES_Msk                     (0x03UL << SCT_RES_O3RES_Pos)                           /*!< SCT RES: O3RES Mask                     */
#define SCT_RES_O4RES_Pos                     8                                                       /*!< SCT RES: O4RES Position                 */
#define SCT_RES_O4RES_Msk                     (0x03UL << SCT_RES_O4RES_Pos)                           /*!< SCT RES: O4RES Mask                     */
#define SCT_RES_O5RES_Pos                     10                                                      /*!< SCT RES: O5RES Position                 */
#define SCT_RES_O5RES_Msk                     (0x03UL << SCT_RES_O5RES_Pos)                           /*!< SCT RES: O5RES Mask                     */
#define SCT_RES_O6RES_Pos                     12                                                      /*!< SCT RES: O6RES Position                 */
#define SCT_RES_O6RES_Msk                     (0x03UL << SCT_RES_O6RES_Pos)                           /*!< SCT RES: O6RES Mask                     */
#define SCT_RES_O7RES_Pos                     14                                                      /*!< SCT RES: O7RES Position                 */
#define SCT_RES_O7RES_Msk                     (0x03UL << SCT_RES_O7RES_Pos)                           /*!< SCT RES: O7RES Mask                     */
#define SCT_RES_O8RES_Pos                     16                                                      /*!< SCT RES: O8RES Position                 */
#define SCT_RES_O8RES_Msk                     (0x03UL << SCT_RES_O8RES_Pos)                           /*!< SCT RES: O8RES Mask                     */
#define SCT_RES_O9RES_Pos                     18                                                      /*!< SCT RES: O9RES Position                 */
#define SCT_RES_O9RES_Msk                     (0x03UL << SCT_RES_O9RES_Pos)                           /*!< SCT RES: O9RES Mask                     */
#define SCT_RES_O10RES_Pos                    20                                                      /*!< SCT RES: O10RES Position                */
#define SCT_RES_O10RES_Msk                    (0x03UL << SCT_RES_O10RES_Pos)                          /*!< SCT RES: O10RES Mask                    */
#define SCT_RES_O11RES_Pos                    22                                                      /*!< SCT RES: O11RES Position                */
#define SCT_RES_O11RES_Msk                    (0x03UL << SCT_RES_O11RES_Pos)                          /*!< SCT RES: O11RES Mask                    */
#define SCT_RES_O12RES_Pos                    24                                                      /*!< SCT RES: O12RES Position                */
#define SCT_RES_O12RES_Msk                    (0x03UL << SCT_RES_O12RES_Pos)                          /*!< SCT RES: O12RES Mask                    */
#define SCT_RES_O13RES_Pos                    26                                                      /*!< SCT RES: O13RES Position                */
#define SCT_RES_O13RES_Msk                    (0x03UL << SCT_RES_O13RES_Pos)                          /*!< SCT RES: O13RES Mask                    */
#define SCT_RES_O14RES_Pos                    28                                                      /*!< SCT RES: O14RES Position                */
#define SCT_RES_O14RES_Msk                    (0x03UL << SCT_RES_O14RES_Pos)                          /*!< SCT RES: O14RES Mask                    */
#define SCT_RES_O15RES_Pos                    30                                                      /*!< SCT RES: O15RES Position                */
#define SCT_RES_O15RES_Msk                    (0x03UL << SCT_RES_O15RES_Pos)                          /*!< SCT RES: O15RES Mask                    */

/* ---------------------------------  SCT_DMAREQ0  -------------------------------- */
#define SCT_DMAREQ0_DEV_00_Pos                0                                                       /*!< SCT DMAREQ0: DEV_00 Position            */
#define SCT_DMAREQ0_DEV_00_Msk                (0x01UL << SCT_DMAREQ0_DEV_00_Pos)                      /*!< SCT DMAREQ0: DEV_00 Mask                */
#define SCT_DMAREQ0_DEV_01_Pos                1                                                       /*!< SCT DMAREQ0: DEV_01 Position            */
#define SCT_DMAREQ0_DEV_01_Msk                (0x01UL << SCT_DMAREQ0_DEV_01_Pos)                      /*!< SCT DMAREQ0: DEV_01 Mask                */
#define SCT_DMAREQ0_DEV_02_Pos                2                                                       /*!< SCT DMAREQ0: DEV_02 Position            */
#define SCT_DMAREQ0_DEV_02_Msk                (0x01UL << SCT_DMAREQ0_DEV_02_Pos)                      /*!< SCT DMAREQ0: DEV_02 Mask                */
#define SCT_DMAREQ0_DEV_03_Pos                3                                                       /*!< SCT DMAREQ0: DEV_03 Position            */
#define SCT_DMAREQ0_DEV_03_Msk                (0x01UL << SCT_DMAREQ0_DEV_03_Pos)                      /*!< SCT DMAREQ0: DEV_03 Mask                */
#define SCT_DMAREQ0_DEV_04_Pos                4                                                       /*!< SCT DMAREQ0: DEV_04 Position            */
#define SCT_DMAREQ0_DEV_04_Msk                (0x01UL << SCT_DMAREQ0_DEV_04_Pos)                      /*!< SCT DMAREQ0: DEV_04 Mask                */
#define SCT_DMAREQ0_DEV_05_Pos                5                                                       /*!< SCT DMAREQ0: DEV_05 Position            */
#define SCT_DMAREQ0_DEV_05_Msk                (0x01UL << SCT_DMAREQ0_DEV_05_Pos)                      /*!< SCT DMAREQ0: DEV_05 Mask                */
#define SCT_DMAREQ0_DEV_06_Pos                6                                                       /*!< SCT DMAREQ0: DEV_06 Position            */
#define SCT_DMAREQ0_DEV_06_Msk                (0x01UL << SCT_DMAREQ0_DEV_06_Pos)                      /*!< SCT DMAREQ0: DEV_06 Mask                */
#define SCT_DMAREQ0_DEV_07_Pos                7                                                       /*!< SCT DMAREQ0: DEV_07 Position            */
#define SCT_DMAREQ0_DEV_07_Msk                (0x01UL << SCT_DMAREQ0_DEV_07_Pos)                      /*!< SCT DMAREQ0: DEV_07 Mask                */
#define SCT_DMAREQ0_DEV_08_Pos                8                                                       /*!< SCT DMAREQ0: DEV_08 Position            */
#define SCT_DMAREQ0_DEV_08_Msk                (0x01UL << SCT_DMAREQ0_DEV_08_Pos)                      /*!< SCT DMAREQ0: DEV_08 Mask                */
#define SCT_DMAREQ0_DEV_09_Pos                9                                                       /*!< SCT DMAREQ0: DEV_09 Position            */
#define SCT_DMAREQ0_DEV_09_Msk                (0x01UL << SCT_DMAREQ0_DEV_09_Pos)                      /*!< SCT DMAREQ0: DEV_09 Mask                */
#define SCT_DMAREQ0_DEV_010_Pos               10                                                      /*!< SCT DMAREQ0: DEV_010 Position           */
#define SCT_DMAREQ0_DEV_010_Msk               (0x01UL << SCT_DMAREQ0_DEV_010_Pos)                     /*!< SCT DMAREQ0: DEV_010 Mask               */
#define SCT_DMAREQ0_DEV_011_Pos               11                                                      /*!< SCT DMAREQ0: DEV_011 Position           */
#define SCT_DMAREQ0_DEV_011_Msk               (0x01UL << SCT_DMAREQ0_DEV_011_Pos)                     /*!< SCT DMAREQ0: DEV_011 Mask               */
#define SCT_DMAREQ0_DEV_012_Pos               12                                                      /*!< SCT DMAREQ0: DEV_012 Position           */
#define SCT_DMAREQ0_DEV_012_Msk               (0x01UL << SCT_DMAREQ0_DEV_012_Pos)                     /*!< SCT DMAREQ0: DEV_012 Mask               */
#define SCT_DMAREQ0_DEV_013_Pos               13                                                      /*!< SCT DMAREQ0: DEV_013 Position           */
#define SCT_DMAREQ0_DEV_013_Msk               (0x01UL << SCT_DMAREQ0_DEV_013_Pos)                     /*!< SCT DMAREQ0: DEV_013 Mask               */
#define SCT_DMAREQ0_DEV_014_Pos               14                                                      /*!< SCT DMAREQ0: DEV_014 Position           */
#define SCT_DMAREQ0_DEV_014_Msk               (0x01UL << SCT_DMAREQ0_DEV_014_Pos)                     /*!< SCT DMAREQ0: DEV_014 Mask               */
#define SCT_DMAREQ0_DEV_015_Pos               15                                                      /*!< SCT DMAREQ0: DEV_015 Position           */
#define SCT_DMAREQ0_DEV_015_Msk               (0x01UL << SCT_DMAREQ0_DEV_015_Pos)                     /*!< SCT DMAREQ0: DEV_015 Mask               */
#define SCT_DMAREQ0_DRL0_Pos                  30                                                      /*!< SCT DMAREQ0: DRL0 Position              */
#define SCT_DMAREQ0_DRL0_Msk                  (0x01UL << SCT_DMAREQ0_DRL0_Pos)                        /*!< SCT DMAREQ0: DRL0 Mask                  */
#define SCT_DMAREQ0_DRQ0_Pos                  31                                                      /*!< SCT DMAREQ0: DRQ0 Position              */
#define SCT_DMAREQ0_DRQ0_Msk                  (0x01UL << SCT_DMAREQ0_DRQ0_Pos)                        /*!< SCT DMAREQ0: DRQ0 Mask                  */

/* ---------------------------------  SCT_DMAREQ1  -------------------------------- */
#define SCT_DMAREQ1_DEV_10_Pos                0                                                       /*!< SCT DMAREQ1: DEV_10 Position            */
#define SCT_DMAREQ1_DEV_10_Msk                (0x01UL << SCT_DMAREQ1_DEV_10_Pos)                      /*!< SCT DMAREQ1: DEV_10 Mask                */
#define SCT_DMAREQ1_DEV_11_Pos                1                                                       /*!< SCT DMAREQ1: DEV_11 Position            */
#define SCT_DMAREQ1_DEV_11_Msk                (0x01UL << SCT_DMAREQ1_DEV_11_Pos)                      /*!< SCT DMAREQ1: DEV_11 Mask                */
#define SCT_DMAREQ1_DEV_12_Pos                2                                                       /*!< SCT DMAREQ1: DEV_12 Position            */
#define SCT_DMAREQ1_DEV_12_Msk                (0x01UL << SCT_DMAREQ1_DEV_12_Pos)                      /*!< SCT DMAREQ1: DEV_12 Mask                */
#define SCT_DMAREQ1_DEV_13_Pos                3                                                       /*!< SCT DMAREQ1: DEV_13 Position            */
#define SCT_DMAREQ1_DEV_13_Msk                (0x01UL << SCT_DMAREQ1_DEV_13_Pos)                      /*!< SCT DMAREQ1: DEV_13 Mask                */
#define SCT_DMAREQ1_DEV_14_Pos                4                                                       /*!< SCT DMAREQ1: DEV_14 Position            */
#define SCT_DMAREQ1_DEV_14_Msk                (0x01UL << SCT_DMAREQ1_DEV_14_Pos)                      /*!< SCT DMAREQ1: DEV_14 Mask                */
#define SCT_DMAREQ1_DEV_15_Pos                5                                                       /*!< SCT DMAREQ1: DEV_15 Position            */
#define SCT_DMAREQ1_DEV_15_Msk                (0x01UL << SCT_DMAREQ1_DEV_15_Pos)                      /*!< SCT DMAREQ1: DEV_15 Mask                */
#define SCT_DMAREQ1_DEV_16_Pos                6                                                       /*!< SCT DMAREQ1: DEV_16 Position            */
#define SCT_DMAREQ1_DEV_16_Msk                (0x01UL << SCT_DMAREQ1_DEV_16_Pos)                      /*!< SCT DMAREQ1: DEV_16 Mask                */
#define SCT_DMAREQ1_DEV_17_Pos                7                                                       /*!< SCT DMAREQ1: DEV_17 Position            */
#define SCT_DMAREQ1_DEV_17_Msk                (0x01UL << SCT_DMAREQ1_DEV_17_Pos)                      /*!< SCT DMAREQ1: DEV_17 Mask                */
#define SCT_DMAREQ1_DEV_18_Pos                8                                                       /*!< SCT DMAREQ1: DEV_18 Position            */
#define SCT_DMAREQ1_DEV_18_Msk                (0x01UL << SCT_DMAREQ1_DEV_18_Pos)                      /*!< SCT DMAREQ1: DEV_18 Mask                */
#define SCT_DMAREQ1_DEV_19_Pos                9                                                       /*!< SCT DMAREQ1: DEV_19 Position            */
#define SCT_DMAREQ1_DEV_19_Msk                (0x01UL << SCT_DMAREQ1_DEV_19_Pos)                      /*!< SCT DMAREQ1: DEV_19 Mask                */
#define SCT_DMAREQ1_DEV_110_Pos               10                                                      /*!< SCT DMAREQ1: DEV_110 Position           */
#define SCT_DMAREQ1_DEV_110_Msk               (0x01UL << SCT_DMAREQ1_DEV_110_Pos)                     /*!< SCT DMAREQ1: DEV_110 Mask               */
#define SCT_DMAREQ1_DEV_111_Pos               11                                                      /*!< SCT DMAREQ1: DEV_111 Position           */
#define SCT_DMAREQ1_DEV_111_Msk               (0x01UL << SCT_DMAREQ1_DEV_111_Pos)                     /*!< SCT DMAREQ1: DEV_111 Mask               */
#define SCT_DMAREQ1_DEV_112_Pos               12                                                      /*!< SCT DMAREQ1: DEV_112 Position           */
#define SCT_DMAREQ1_DEV_112_Msk               (0x01UL << SCT_DMAREQ1_DEV_112_Pos)                     /*!< SCT DMAREQ1: DEV_112 Mask               */
#define SCT_DMAREQ1_DEV_113_Pos               13                                                      /*!< SCT DMAREQ1: DEV_113 Position           */
#define SCT_DMAREQ1_DEV_113_Msk               (0x01UL << SCT_DMAREQ1_DEV_113_Pos)                     /*!< SCT DMAREQ1: DEV_113 Mask               */
#define SCT_DMAREQ1_DEV_114_Pos               14                                                      /*!< SCT DMAREQ1: DEV_114 Position           */
#define SCT_DMAREQ1_DEV_114_Msk               (0x01UL << SCT_DMAREQ1_DEV_114_Pos)                     /*!< SCT DMAREQ1: DEV_114 Mask               */
#define SCT_DMAREQ1_DEV_115_Pos               15                                                      /*!< SCT DMAREQ1: DEV_115 Position           */
#define SCT_DMAREQ1_DEV_115_Msk               (0x01UL << SCT_DMAREQ1_DEV_115_Pos)                     /*!< SCT DMAREQ1: DEV_115 Mask               */
#define SCT_DMAREQ1_DRL1_Pos                  30                                                      /*!< SCT DMAREQ1: DRL1 Position              */
#define SCT_DMAREQ1_DRL1_Msk                  (0x01UL << SCT_DMAREQ1_DRL1_Pos)                        /*!< SCT DMAREQ1: DRL1 Mask                  */
#define SCT_DMAREQ1_DRQ1_Pos                  31                                                      /*!< SCT DMAREQ1: DRQ1 Position              */
#define SCT_DMAREQ1_DRQ1_Msk                  (0x01UL << SCT_DMAREQ1_DRQ1_Pos)                        /*!< SCT DMAREQ1: DRQ1 Mask                  */

/* ----------------------------------  SCT_EVEN  ---------------------------------- */
#define SCT_EVEN_IEN0_Pos                     0                                                       /*!< SCT EVEN: IEN0 Position                 */
#define SCT_EVEN_IEN0_Msk                     (0x01UL << SCT_EVEN_IEN0_Pos)                           /*!< SCT EVEN: IEN0 Mask                     */
#define SCT_EVEN_IEN1_Pos                     1                                                       /*!< SCT EVEN: IEN1 Position                 */
#define SCT_EVEN_IEN1_Msk                     (0x01UL << SCT_EVEN_IEN1_Pos)                           /*!< SCT EVEN: IEN1 Mask                     */
#define SCT_EVEN_IEN2_Pos                     2                                                       /*!< SCT EVEN: IEN2 Position                 */
#define SCT_EVEN_IEN2_Msk                     (0x01UL << SCT_EVEN_IEN2_Pos)                           /*!< SCT EVEN: IEN2 Mask                     */
#define SCT_EVEN_IEN3_Pos                     3                                                       /*!< SCT EVEN: IEN3 Position                 */
#define SCT_EVEN_IEN3_Msk                     (0x01UL << SCT_EVEN_IEN3_Pos)                           /*!< SCT EVEN: IEN3 Mask                     */
#define SCT_EVEN_IEN4_Pos                     4                                                       /*!< SCT EVEN: IEN4 Position                 */
#define SCT_EVEN_IEN4_Msk                     (0x01UL << SCT_EVEN_IEN4_Pos)                           /*!< SCT EVEN: IEN4 Mask                     */
#define SCT_EVEN_IEN5_Pos                     5                                                       /*!< SCT EVEN: IEN5 Position                 */
#define SCT_EVEN_IEN5_Msk                     (0x01UL << SCT_EVEN_IEN5_Pos)                           /*!< SCT EVEN: IEN5 Mask                     */
#define SCT_EVEN_IEN6_Pos                     6                                                       /*!< SCT EVEN: IEN6 Position                 */
#define SCT_EVEN_IEN6_Msk                     (0x01UL << SCT_EVEN_IEN6_Pos)                           /*!< SCT EVEN: IEN6 Mask                     */
#define SCT_EVEN_IEN7_Pos                     7                                                       /*!< SCT EVEN: IEN7 Position                 */
#define SCT_EVEN_IEN7_Msk                     (0x01UL << SCT_EVEN_IEN7_Pos)                           /*!< SCT EVEN: IEN7 Mask                     */
#define SCT_EVEN_IEN8_Pos                     8                                                       /*!< SCT EVEN: IEN8 Position                 */
#define SCT_EVEN_IEN8_Msk                     (0x01UL << SCT_EVEN_IEN8_Pos)                           /*!< SCT EVEN: IEN8 Mask                     */
#define SCT_EVEN_IEN9_Pos                     9                                                       /*!< SCT EVEN: IEN9 Position                 */
#define SCT_EVEN_IEN9_Msk                     (0x01UL << SCT_EVEN_IEN9_Pos)                           /*!< SCT EVEN: IEN9 Mask                     */
#define SCT_EVEN_IEN10_Pos                    10                                                      /*!< SCT EVEN: IEN10 Position                */
#define SCT_EVEN_IEN10_Msk                    (0x01UL << SCT_EVEN_IEN10_Pos)                          /*!< SCT EVEN: IEN10 Mask                    */
#define SCT_EVEN_IEN11_Pos                    11                                                      /*!< SCT EVEN: IEN11 Position                */
#define SCT_EVEN_IEN11_Msk                    (0x01UL << SCT_EVEN_IEN11_Pos)                          /*!< SCT EVEN: IEN11 Mask                    */
#define SCT_EVEN_IEN12_Pos                    12                                                      /*!< SCT EVEN: IEN12 Position                */
#define SCT_EVEN_IEN12_Msk                    (0x01UL << SCT_EVEN_IEN12_Pos)                          /*!< SCT EVEN: IEN12 Mask                    */
#define SCT_EVEN_IEN13_Pos                    13                                                      /*!< SCT EVEN: IEN13 Position                */
#define SCT_EVEN_IEN13_Msk                    (0x01UL << SCT_EVEN_IEN13_Pos)                          /*!< SCT EVEN: IEN13 Mask                    */
#define SCT_EVEN_IEN14_Pos                    14                                                      /*!< SCT EVEN: IEN14 Position                */
#define SCT_EVEN_IEN14_Msk                    (0x01UL << SCT_EVEN_IEN14_Pos)                          /*!< SCT EVEN: IEN14 Mask                    */
#define SCT_EVEN_IEN15_Pos                    15                                                      /*!< SCT EVEN: IEN15 Position                */
#define SCT_EVEN_IEN15_Msk                    (0x01UL << SCT_EVEN_IEN15_Pos)                          /*!< SCT EVEN: IEN15 Mask                    */

/* ---------------------------------  SCT_EVFLAG  --------------------------------- */
#define SCT_EVFLAG_FLAG0_Pos                  0                                                       /*!< SCT EVFLAG: FLAG0 Position              */
#define SCT_EVFLAG_FLAG0_Msk                  (0x01UL << SCT_EVFLAG_FLAG0_Pos)                        /*!< SCT EVFLAG: FLAG0 Mask                  */
#define SCT_EVFLAG_FLAG1_Pos                  1                                                       /*!< SCT EVFLAG: FLAG1 Position              */
#define SCT_EVFLAG_FLAG1_Msk                  (0x01UL << SCT_EVFLAG_FLAG1_Pos)                        /*!< SCT EVFLAG: FLAG1 Mask                  */
#define SCT_EVFLAG_FLAG2_Pos                  2                                                       /*!< SCT EVFLAG: FLAG2 Position              */
#define SCT_EVFLAG_FLAG2_Msk                  (0x01UL << SCT_EVFLAG_FLAG2_Pos)                        /*!< SCT EVFLAG: FLAG2 Mask                  */
#define SCT_EVFLAG_FLAG3_Pos                  3                                                       /*!< SCT EVFLAG: FLAG3 Position              */
#define SCT_EVFLAG_FLAG3_Msk                  (0x01UL << SCT_EVFLAG_FLAG3_Pos)                        /*!< SCT EVFLAG: FLAG3 Mask                  */
#define SCT_EVFLAG_FLAG4_Pos                  4                                                       /*!< SCT EVFLAG: FLAG4 Position              */
#define SCT_EVFLAG_FLAG4_Msk                  (0x01UL << SCT_EVFLAG_FLAG4_Pos)                        /*!< SCT EVFLAG: FLAG4 Mask                  */
#define SCT_EVFLAG_FLAG5_Pos                  5                                                       /*!< SCT EVFLAG: FLAG5 Position              */
#define SCT_EVFLAG_FLAG5_Msk                  (0x01UL << SCT_EVFLAG_FLAG5_Pos)                        /*!< SCT EVFLAG: FLAG5 Mask                  */
#define SCT_EVFLAG_FLAG6_Pos                  6                                                       /*!< SCT EVFLAG: FLAG6 Position              */
#define SCT_EVFLAG_FLAG6_Msk                  (0x01UL << SCT_EVFLAG_FLAG6_Pos)                        /*!< SCT EVFLAG: FLAG6 Mask                  */
#define SCT_EVFLAG_FLAG7_Pos                  7                                                       /*!< SCT EVFLAG: FLAG7 Position              */
#define SCT_EVFLAG_FLAG7_Msk                  (0x01UL << SCT_EVFLAG_FLAG7_Pos)                        /*!< SCT EVFLAG: FLAG7 Mask                  */
#define SCT_EVFLAG_FLAG8_Pos                  8                                                       /*!< SCT EVFLAG: FLAG8 Position              */
#define SCT_EVFLAG_FLAG8_Msk                  (0x01UL << SCT_EVFLAG_FLAG8_Pos)                        /*!< SCT EVFLAG: FLAG8 Mask                  */
#define SCT_EVFLAG_FLAG9_Pos                  9                                                       /*!< SCT EVFLAG: FLAG9 Position              */
#define SCT_EVFLAG_FLAG9_Msk                  (0x01UL << SCT_EVFLAG_FLAG9_Pos)                        /*!< SCT EVFLAG: FLAG9 Mask                  */
#define SCT_EVFLAG_FLAG10_Pos                 10                                                      /*!< SCT EVFLAG: FLAG10 Position             */
#define SCT_EVFLAG_FLAG10_Msk                 (0x01UL << SCT_EVFLAG_FLAG10_Pos)                       /*!< SCT EVFLAG: FLAG10 Mask                 */
#define SCT_EVFLAG_FLAG11_Pos                 11                                                      /*!< SCT EVFLAG: FLAG11 Position             */
#define SCT_EVFLAG_FLAG11_Msk                 (0x01UL << SCT_EVFLAG_FLAG11_Pos)                       /*!< SCT EVFLAG: FLAG11 Mask                 */
#define SCT_EVFLAG_FLAG12_Pos                 12                                                      /*!< SCT EVFLAG: FLAG12 Position             */
#define SCT_EVFLAG_FLAG12_Msk                 (0x01UL << SCT_EVFLAG_FLAG12_Pos)                       /*!< SCT EVFLAG: FLAG12 Mask                 */
#define SCT_EVFLAG_FLAG13_Pos                 13                                                      /*!< SCT EVFLAG: FLAG13 Position             */
#define SCT_EVFLAG_FLAG13_Msk                 (0x01UL << SCT_EVFLAG_FLAG13_Pos)                       /*!< SCT EVFLAG: FLAG13 Mask                 */
#define SCT_EVFLAG_FLAG14_Pos                 14                                                      /*!< SCT EVFLAG: FLAG14 Position             */
#define SCT_EVFLAG_FLAG14_Msk                 (0x01UL << SCT_EVFLAG_FLAG14_Pos)                       /*!< SCT EVFLAG: FLAG14 Mask                 */
#define SCT_EVFLAG_FLAG15_Pos                 15                                                      /*!< SCT EVFLAG: FLAG15 Position             */
#define SCT_EVFLAG_FLAG15_Msk                 (0x01UL << SCT_EVFLAG_FLAG15_Pos)                       /*!< SCT EVFLAG: FLAG15 Mask                 */

/* ----------------------------------  SCT_CONEN  --------------------------------- */
#define SCT_CONEN_NCEN0_Pos                   0                                                       /*!< SCT CONEN: NCEN0 Position               */
#define SCT_CONEN_NCEN0_Msk                   (0x01UL << SCT_CONEN_NCEN0_Pos)                         /*!< SCT CONEN: NCEN0 Mask                   */
#define SCT_CONEN_NCEN1_Pos                   1                                                       /*!< SCT CONEN: NCEN1 Position               */
#define SCT_CONEN_NCEN1_Msk                   (0x01UL << SCT_CONEN_NCEN1_Pos)                         /*!< SCT CONEN: NCEN1 Mask                   */
#define SCT_CONEN_NCEN2_Pos                   2                                                       /*!< SCT CONEN: NCEN2 Position               */
#define SCT_CONEN_NCEN2_Msk                   (0x01UL << SCT_CONEN_NCEN2_Pos)                         /*!< SCT CONEN: NCEN2 Mask                   */
#define SCT_CONEN_NCEN3_Pos                   3                                                       /*!< SCT CONEN: NCEN3 Position               */
#define SCT_CONEN_NCEN3_Msk                   (0x01UL << SCT_CONEN_NCEN3_Pos)                         /*!< SCT CONEN: NCEN3 Mask                   */
#define SCT_CONEN_NCEN4_Pos                   4                                                       /*!< SCT CONEN: NCEN4 Position               */
#define SCT_CONEN_NCEN4_Msk                   (0x01UL << SCT_CONEN_NCEN4_Pos)                         /*!< SCT CONEN: NCEN4 Mask                   */
#define SCT_CONEN_NCEN5_Pos                   5                                                       /*!< SCT CONEN: NCEN5 Position               */
#define SCT_CONEN_NCEN5_Msk                   (0x01UL << SCT_CONEN_NCEN5_Pos)                         /*!< SCT CONEN: NCEN5 Mask                   */
#define SCT_CONEN_NCEN6_Pos                   6                                                       /*!< SCT CONEN: NCEN6 Position               */
#define SCT_CONEN_NCEN6_Msk                   (0x01UL << SCT_CONEN_NCEN6_Pos)                         /*!< SCT CONEN: NCEN6 Mask                   */
#define SCT_CONEN_NCEN7_Pos                   7                                                       /*!< SCT CONEN: NCEN7 Position               */
#define SCT_CONEN_NCEN7_Msk                   (0x01UL << SCT_CONEN_NCEN7_Pos)                         /*!< SCT CONEN: NCEN7 Mask                   */
#define SCT_CONEN_NCEN8_Pos                   8                                                       /*!< SCT CONEN: NCEN8 Position               */
#define SCT_CONEN_NCEN8_Msk                   (0x01UL << SCT_CONEN_NCEN8_Pos)                         /*!< SCT CONEN: NCEN8 Mask                   */
#define SCT_CONEN_NCEN9_Pos                   9                                                       /*!< SCT CONEN: NCEN9 Position               */
#define SCT_CONEN_NCEN9_Msk                   (0x01UL << SCT_CONEN_NCEN9_Pos)                         /*!< SCT CONEN: NCEN9 Mask                   */
#define SCT_CONEN_NCEN10_Pos                  10                                                      /*!< SCT CONEN: NCEN10 Position              */
#define SCT_CONEN_NCEN10_Msk                  (0x01UL << SCT_CONEN_NCEN10_Pos)                        /*!< SCT CONEN: NCEN10 Mask                  */
#define SCT_CONEN_NCEN11_Pos                  11                                                      /*!< SCT CONEN: NCEN11 Position              */
#define SCT_CONEN_NCEN11_Msk                  (0x01UL << SCT_CONEN_NCEN11_Pos)                        /*!< SCT CONEN: NCEN11 Mask                  */
#define SCT_CONEN_NCEN12_Pos                  12                                                      /*!< SCT CONEN: NCEN12 Position              */
#define SCT_CONEN_NCEN12_Msk                  (0x01UL << SCT_CONEN_NCEN12_Pos)                        /*!< SCT CONEN: NCEN12 Mask                  */
#define SCT_CONEN_NCEN13_Pos                  13                                                      /*!< SCT CONEN: NCEN13 Position              */
#define SCT_CONEN_NCEN13_Msk                  (0x01UL << SCT_CONEN_NCEN13_Pos)                        /*!< SCT CONEN: NCEN13 Mask                  */
#define SCT_CONEN_NCEN14_Pos                  14                                                      /*!< SCT CONEN: NCEN14 Position              */
#define SCT_CONEN_NCEN14_Msk                  (0x01UL << SCT_CONEN_NCEN14_Pos)                        /*!< SCT CONEN: NCEN14 Mask                  */
#define SCT_CONEN_NCEN15_Pos                  15                                                      /*!< SCT CONEN: NCEN15 Position              */
#define SCT_CONEN_NCEN15_Msk                  (0x01UL << SCT_CONEN_NCEN15_Pos)                        /*!< SCT CONEN: NCEN15 Mask                  */

/* ---------------------------------  SCT_CONFLAG  -------------------------------- */
#define SCT_CONFLAG_NCFLAG0_Pos               0                                                       /*!< SCT CONFLAG: NCFLAG0 Position           */
#define SCT_CONFLAG_NCFLAG0_Msk               (0x01UL << SCT_CONFLAG_NCFLAG0_Pos)                     /*!< SCT CONFLAG: NCFLAG0 Mask               */
#define SCT_CONFLAG_NCFLAG1_Pos               1                                                       /*!< SCT CONFLAG: NCFLAG1 Position           */
#define SCT_CONFLAG_NCFLAG1_Msk               (0x01UL << SCT_CONFLAG_NCFLAG1_Pos)                     /*!< SCT CONFLAG: NCFLAG1 Mask               */
#define SCT_CONFLAG_NCFLAG2_Pos               2                                                       /*!< SCT CONFLAG: NCFLAG2 Position           */
#define SCT_CONFLAG_NCFLAG2_Msk               (0x01UL << SCT_CONFLAG_NCFLAG2_Pos)                     /*!< SCT CONFLAG: NCFLAG2 Mask               */
#define SCT_CONFLAG_NCFLAG3_Pos               3                                                       /*!< SCT CONFLAG: NCFLAG3 Position           */
#define SCT_CONFLAG_NCFLAG3_Msk               (0x01UL << SCT_CONFLAG_NCFLAG3_Pos)                     /*!< SCT CONFLAG: NCFLAG3 Mask               */
#define SCT_CONFLAG_NCFLAG4_Pos               4                                                       /*!< SCT CONFLAG: NCFLAG4 Position           */
#define SCT_CONFLAG_NCFLAG4_Msk               (0x01UL << SCT_CONFLAG_NCFLAG4_Pos)                     /*!< SCT CONFLAG: NCFLAG4 Mask               */
#define SCT_CONFLAG_NCFLAG5_Pos               5                                                       /*!< SCT CONFLAG: NCFLAG5 Position           */
#define SCT_CONFLAG_NCFLAG5_Msk               (0x01UL << SCT_CONFLAG_NCFLAG5_Pos)                     /*!< SCT CONFLAG: NCFLAG5 Mask               */
#define SCT_CONFLAG_NCFLAG6_Pos               6                                                       /*!< SCT CONFLAG: NCFLAG6 Position           */
#define SCT_CONFLAG_NCFLAG6_Msk               (0x01UL << SCT_CONFLAG_NCFLAG6_Pos)                     /*!< SCT CONFLAG: NCFLAG6 Mask               */
#define SCT_CONFLAG_NCFLAG7_Pos               7                                                       /*!< SCT CONFLAG: NCFLAG7 Position           */
#define SCT_CONFLAG_NCFLAG7_Msk               (0x01UL << SCT_CONFLAG_NCFLAG7_Pos)                     /*!< SCT CONFLAG: NCFLAG7 Mask               */
#define SCT_CONFLAG_NCFLAG8_Pos               8                                                       /*!< SCT CONFLAG: NCFLAG8 Position           */
#define SCT_CONFLAG_NCFLAG8_Msk               (0x01UL << SCT_CONFLAG_NCFLAG8_Pos)                     /*!< SCT CONFLAG: NCFLAG8 Mask               */
#define SCT_CONFLAG_NCFLAG9_Pos               9                                                       /*!< SCT CONFLAG: NCFLAG9 Position           */
#define SCT_CONFLAG_NCFLAG9_Msk               (0x01UL << SCT_CONFLAG_NCFLAG9_Pos)                     /*!< SCT CONFLAG: NCFLAG9 Mask               */
#define SCT_CONFLAG_NCFLAG10_Pos              10                                                      /*!< SCT CONFLAG: NCFLAG10 Position          */
#define SCT_CONFLAG_NCFLAG10_Msk              (0x01UL << SCT_CONFLAG_NCFLAG10_Pos)                    /*!< SCT CONFLAG: NCFLAG10 Mask              */
#define SCT_CONFLAG_NCFLAG11_Pos              11                                                      /*!< SCT CONFLAG: NCFLAG11 Position          */
#define SCT_CONFLAG_NCFLAG11_Msk              (0x01UL << SCT_CONFLAG_NCFLAG11_Pos)                    /*!< SCT CONFLAG: NCFLAG11 Mask              */
#define SCT_CONFLAG_NCFLAG12_Pos              12                                                      /*!< SCT CONFLAG: NCFLAG12 Position          */
#define SCT_CONFLAG_NCFLAG12_Msk              (0x01UL << SCT_CONFLAG_NCFLAG12_Pos)                    /*!< SCT CONFLAG: NCFLAG12 Mask              */
#define SCT_CONFLAG_NCFLAG13_Pos              13                                                      /*!< SCT CONFLAG: NCFLAG13 Position          */
#define SCT_CONFLAG_NCFLAG13_Msk              (0x01UL << SCT_CONFLAG_NCFLAG13_Pos)                    /*!< SCT CONFLAG: NCFLAG13 Mask              */
#define SCT_CONFLAG_NCFLAG14_Pos              14                                                      /*!< SCT CONFLAG: NCFLAG14 Position          */
#define SCT_CONFLAG_NCFLAG14_Msk              (0x01UL << SCT_CONFLAG_NCFLAG14_Pos)                    /*!< SCT CONFLAG: NCFLAG14 Mask              */
#define SCT_CONFLAG_NCFLAG15_Pos              15                                                      /*!< SCT CONFLAG: NCFLAG15 Position          */
#define SCT_CONFLAG_NCFLAG15_Msk              (0x01UL << SCT_CONFLAG_NCFLAG15_Pos)                    /*!< SCT CONFLAG: NCFLAG15 Mask              */
#define SCT_CONFLAG_BUSERRL_Pos               30                                                      /*!< SCT CONFLAG: BUSERRL Position           */
#define SCT_CONFLAG_BUSERRL_Msk               (0x01UL << SCT_CONFLAG_BUSERRL_Pos)                     /*!< SCT CONFLAG: BUSERRL Mask               */
#define SCT_CONFLAG_BUSERRH_Pos               31                                                      /*!< SCT CONFLAG: BUSERRH Position           */
#define SCT_CONFLAG_BUSERRH_Msk               (0x01UL << SCT_CONFLAG_BUSERRH_Pos)                     /*!< SCT CONFLAG: BUSERRH Mask               */

/* ---------------------------------  SCT_MATCH0  --------------------------------- */
#define SCT_MATCH0_MATCH_L_Pos                0                                                       /*!< SCT MATCH0: MATCH_L Position            */
#define SCT_MATCH0_MATCH_L_Msk                (0x0000ffffUL << SCT_MATCH0_MATCH_L_Pos)                /*!< SCT MATCH0: MATCH_L Mask                */
#define SCT_MATCH0_MATCH_H_Pos                16                                                      /*!< SCT MATCH0: MATCH_H Position            */
#define SCT_MATCH0_MATCH_H_Msk                (0x0000ffffUL << SCT_MATCH0_MATCH_H_Pos)                /*!< SCT MATCH0: MATCH_H Mask                */

/* ----------------------------------  SCT_CAP0  ---------------------------------- */
#define SCT_CAP0_CAP_L_Pos                    0                                                       /*!< SCT CAP0: CAP_L Position                */
#define SCT_CAP0_CAP_L_Msk                    (0x0000ffffUL << SCT_CAP0_CAP_L_Pos)                    /*!< SCT CAP0: CAP_L Mask                    */
#define SCT_CAP0_CAP_H_Pos                    16                                                      /*!< SCT CAP0: CAP_H Position                */
#define SCT_CAP0_CAP_H_Msk                    (0x0000ffffUL << SCT_CAP0_CAP_H_Pos)                    /*!< SCT CAP0: CAP_H Mask                    */

/* ---------------------------------  SCT_MATCH1  --------------------------------- */
#define SCT_MATCH1_MATCH_L_Pos                0                                                       /*!< SCT MATCH1: MATCH_L Position            */
#define SCT_MATCH1_MATCH_L_Msk                (0x0000ffffUL << SCT_MATCH1_MATCH_L_Pos)                /*!< SCT MATCH1: MATCH_L Mask                */
#define SCT_MATCH1_MATCH_H_Pos                16                                                      /*!< SCT MATCH1: MATCH_H Position            */
#define SCT_MATCH1_MATCH_H_Msk                (0x0000ffffUL << SCT_MATCH1_MATCH_H_Pos)                /*!< SCT MATCH1: MATCH_H Mask                */

/* ----------------------------------  SCT_CAP1  ---------------------------------- */
#define SCT_CAP1_CAP_L_Pos                    0                                                       /*!< SCT CAP1: CAP_L Position                */
#define SCT_CAP1_CAP_L_Msk                    (0x0000ffffUL << SCT_CAP1_CAP_L_Pos)                    /*!< SCT CAP1: CAP_L Mask                    */
#define SCT_CAP1_CAP_H_Pos                    16                                                      /*!< SCT CAP1: CAP_H Position                */
#define SCT_CAP1_CAP_H_Msk                    (0x0000ffffUL << SCT_CAP1_CAP_H_Pos)                    /*!< SCT CAP1: CAP_H Mask                    */

/* ---------------------------------  SCT_MATCH2  --------------------------------- */
#define SCT_MATCH2_MATCH_L_Pos                0                                                       /*!< SCT MATCH2: MATCH_L Position            */
#define SCT_MATCH2_MATCH_L_Msk                (0x0000ffffUL << SCT_MATCH2_MATCH_L_Pos)                /*!< SCT MATCH2: MATCH_L Mask                */
#define SCT_MATCH2_MATCH_H_Pos                16                                                      /*!< SCT MATCH2: MATCH_H Position            */
#define SCT_MATCH2_MATCH_H_Msk                (0x0000ffffUL << SCT_MATCH2_MATCH_H_Pos)                /*!< SCT MATCH2: MATCH_H Mask                */

/* ----------------------------------  SCT_CAP2  ---------------------------------- */
#define SCT_CAP2_CAP_L_Pos                    0                                                       /*!< SCT CAP2: CAP_L Position                */
#define SCT_CAP2_CAP_L_Msk                    (0x0000ffffUL << SCT_CAP2_CAP_L_Pos)                    /*!< SCT CAP2: CAP_L Mask                    */
#define SCT_CAP2_CAP_H_Pos                    16                                                      /*!< SCT CAP2: CAP_H Position                */
#define SCT_CAP2_CAP_H_Msk                    (0x0000ffffUL << SCT_CAP2_CAP_H_Pos)                    /*!< SCT CAP2: CAP_H Mask                    */

/* ---------------------------------  SCT_MATCH3  --------------------------------- */
#define SCT_MATCH3_MATCH_L_Pos                0                                                       /*!< SCT MATCH3: MATCH_L Position            */
#define SCT_MATCH3_MATCH_L_Msk                (0x0000ffffUL << SCT_MATCH3_MATCH_L_Pos)                /*!< SCT MATCH3: MATCH_L Mask                */
#define SCT_MATCH3_MATCH_H_Pos                16                                                      /*!< SCT MATCH3: MATCH_H Position            */
#define SCT_MATCH3_MATCH_H_Msk                (0x0000ffffUL << SCT_MATCH3_MATCH_H_Pos)                /*!< SCT MATCH3: MATCH_H Mask                */

/* ----------------------------------  SCT_CAP3  ---------------------------------- */
#define SCT_CAP3_CAP_L_Pos                    0                                                       /*!< SCT CAP3: CAP_L Position                */
#define SCT_CAP3_CAP_L_Msk                    (0x0000ffffUL << SCT_CAP3_CAP_L_Pos)                    /*!< SCT CAP3: CAP_L Mask                    */
#define SCT_CAP3_CAP_H_Pos                    16                                                      /*!< SCT CAP3: CAP_H Position                */
#define SCT_CAP3_CAP_H_Msk                    (0x0000ffffUL << SCT_CAP3_CAP_H_Pos)                    /*!< SCT CAP3: CAP_H Mask                    */

/* ----------------------------------  SCT_CAP4  ---------------------------------- */
#define SCT_CAP4_CAP_L_Pos                    0                                                       /*!< SCT CAP4: CAP_L Position                */
#define SCT_CAP4_CAP_L_Msk                    (0x0000ffffUL << SCT_CAP4_CAP_L_Pos)                    /*!< SCT CAP4: CAP_L Mask                    */
#define SCT_CAP4_CAP_H_Pos                    16                                                      /*!< SCT CAP4: CAP_H Position                */
#define SCT_CAP4_CAP_H_Msk                    (0x0000ffffUL << SCT_CAP4_CAP_H_Pos)                    /*!< SCT CAP4: CAP_H Mask                    */

/* ---------------------------------  SCT_MATCH4  --------------------------------- */
#define SCT_MATCH4_MATCH_L_Pos                0                                                       /*!< SCT MATCH4: MATCH_L Position            */
#define SCT_MATCH4_MATCH_L_Msk                (0x0000ffffUL << SCT_MATCH4_MATCH_L_Pos)                /*!< SCT MATCH4: MATCH_L Mask                */
#define SCT_MATCH4_MATCH_H_Pos                16                                                      /*!< SCT MATCH4: MATCH_H Position            */
#define SCT_MATCH4_MATCH_H_Msk                (0x0000ffffUL << SCT_MATCH4_MATCH_H_Pos)                /*!< SCT MATCH4: MATCH_H Mask                */

/* ---------------------------------  SCT_MATCH5  --------------------------------- */
#define SCT_MATCH5_MATCH_L_Pos                0                                                       /*!< SCT MATCH5: MATCH_L Position            */
#define SCT_MATCH5_MATCH_L_Msk                (0x0000ffffUL << SCT_MATCH5_MATCH_L_Pos)                /*!< SCT MATCH5: MATCH_L Mask                */
#define SCT_MATCH5_MATCH_H_Pos                16                                                      /*!< SCT MATCH5: MATCH_H Position            */
#define SCT_MATCH5_MATCH_H_Msk                (0x0000ffffUL << SCT_MATCH5_MATCH_H_Pos)                /*!< SCT MATCH5: MATCH_H Mask                */

/* ----------------------------------  SCT_CAP5  ---------------------------------- */
#define SCT_CAP5_CAP_L_Pos                    0                                                       /*!< SCT CAP5: CAP_L Position                */
#define SCT_CAP5_CAP_L_Msk                    (0x0000ffffUL << SCT_CAP5_CAP_L_Pos)                    /*!< SCT CAP5: CAP_L Mask                    */
#define SCT_CAP5_CAP_H_Pos                    16                                                      /*!< SCT CAP5: CAP_H Position                */
#define SCT_CAP5_CAP_H_Msk                    (0x0000ffffUL << SCT_CAP5_CAP_H_Pos)                    /*!< SCT CAP5: CAP_H Mask                    */

/* ----------------------------------  SCT_CAP6  ---------------------------------- */
#define SCT_CAP6_CAP_L_Pos                    0                                                       /*!< SCT CAP6: CAP_L Position                */
#define SCT_CAP6_CAP_L_Msk                    (0x0000ffffUL << SCT_CAP6_CAP_L_Pos)                    /*!< SCT CAP6: CAP_L Mask                    */
#define SCT_CAP6_CAP_H_Pos                    16                                                      /*!< SCT CAP6: CAP_H Position                */
#define SCT_CAP6_CAP_H_Msk                    (0x0000ffffUL << SCT_CAP6_CAP_H_Pos)                    /*!< SCT CAP6: CAP_H Mask                    */

/* ---------------------------------  SCT_MATCH6  --------------------------------- */
#define SCT_MATCH6_MATCH_L_Pos                0                                                       /*!< SCT MATCH6: MATCH_L Position            */
#define SCT_MATCH6_MATCH_L_Msk                (0x0000ffffUL << SCT_MATCH6_MATCH_L_Pos)                /*!< SCT MATCH6: MATCH_L Mask                */
#define SCT_MATCH6_MATCH_H_Pos                16                                                      /*!< SCT MATCH6: MATCH_H Position            */
#define SCT_MATCH6_MATCH_H_Msk                (0x0000ffffUL << SCT_MATCH6_MATCH_H_Pos)                /*!< SCT MATCH6: MATCH_H Mask                */

/* ----------------------------------  SCT_CAP7  ---------------------------------- */
#define SCT_CAP7_CAP_L_Pos                    0                                                       /*!< SCT CAP7: CAP_L Position                */
#define SCT_CAP7_CAP_L_Msk                    (0x0000ffffUL << SCT_CAP7_CAP_L_Pos)                    /*!< SCT CAP7: CAP_L Mask                    */
#define SCT_CAP7_CAP_H_Pos                    16                                                      /*!< SCT CAP7: CAP_H Position                */
#define SCT_CAP7_CAP_H_Msk                    (0x0000ffffUL << SCT_CAP7_CAP_H_Pos)                    /*!< SCT CAP7: CAP_H Mask                    */

/* ---------------------------------  SCT_MATCH7  --------------------------------- */
#define SCT_MATCH7_MATCH_L_Pos                0                                                       /*!< SCT MATCH7: MATCH_L Position            */
#define SCT_MATCH7_MATCH_L_Msk                (0x0000ffffUL << SCT_MATCH7_MATCH_L_Pos)                /*!< SCT MATCH7: MATCH_L Mask                */
#define SCT_MATCH7_MATCH_H_Pos                16                                                      /*!< SCT MATCH7: MATCH_H Position            */
#define SCT_MATCH7_MATCH_H_Msk                (0x0000ffffUL << SCT_MATCH7_MATCH_H_Pos)                /*!< SCT MATCH7: MATCH_H Mask                */

/* ----------------------------------  SCT_CAP8  ---------------------------------- */
#define SCT_CAP8_CAP_L_Pos                    0                                                       /*!< SCT CAP8: CAP_L Position                */
#define SCT_CAP8_CAP_L_Msk                    (0x0000ffffUL << SCT_CAP8_CAP_L_Pos)                    /*!< SCT CAP8: CAP_L Mask                    */
#define SCT_CAP8_CAP_H_Pos                    16                                                      /*!< SCT CAP8: CAP_H Position                */
#define SCT_CAP8_CAP_H_Msk                    (0x0000ffffUL << SCT_CAP8_CAP_H_Pos)                    /*!< SCT CAP8: CAP_H Mask                    */

/* ---------------------------------  SCT_MATCH8  --------------------------------- */
#define SCT_MATCH8_MATCH_L_Pos                0                                                       /*!< SCT MATCH8: MATCH_L Position            */
#define SCT_MATCH8_MATCH_L_Msk                (0x0000ffffUL << SCT_MATCH8_MATCH_L_Pos)                /*!< SCT MATCH8: MATCH_L Mask                */
#define SCT_MATCH8_MATCH_H_Pos                16                                                      /*!< SCT MATCH8: MATCH_H Position            */
#define SCT_MATCH8_MATCH_H_Msk                (0x0000ffffUL << SCT_MATCH8_MATCH_H_Pos)                /*!< SCT MATCH8: MATCH_H Mask                */

/* ----------------------------------  SCT_CAP9  ---------------------------------- */
#define SCT_CAP9_CAP_L_Pos                    0                                                       /*!< SCT CAP9: CAP_L Position                */
#define SCT_CAP9_CAP_L_Msk                    (0x0000ffffUL << SCT_CAP9_CAP_L_Pos)                    /*!< SCT CAP9: CAP_L Mask                    */
#define SCT_CAP9_CAP_H_Pos                    16                                                      /*!< SCT CAP9: CAP_H Position                */
#define SCT_CAP9_CAP_H_Msk                    (0x0000ffffUL << SCT_CAP9_CAP_H_Pos)                    /*!< SCT CAP9: CAP_H Mask                    */

/* ---------------------------------  SCT_MATCH9  --------------------------------- */
#define SCT_MATCH9_MATCH_L_Pos                0                                                       /*!< SCT MATCH9: MATCH_L Position            */
#define SCT_MATCH9_MATCH_L_Msk                (0x0000ffffUL << SCT_MATCH9_MATCH_L_Pos)                /*!< SCT MATCH9: MATCH_L Mask                */
#define SCT_MATCH9_MATCH_H_Pos                16                                                      /*!< SCT MATCH9: MATCH_H Position            */
#define SCT_MATCH9_MATCH_H_Msk                (0x0000ffffUL << SCT_MATCH9_MATCH_H_Pos)                /*!< SCT MATCH9: MATCH_H Mask                */

/* ----------------------------------  SCT_CAP10  --------------------------------- */
#define SCT_CAP10_CAP_L_Pos                   0                                                       /*!< SCT CAP10: CAP_L Position               */
#define SCT_CAP10_CAP_L_Msk                   (0x0000ffffUL << SCT_CAP10_CAP_L_Pos)                   /*!< SCT CAP10: CAP_L Mask                   */
#define SCT_CAP10_CAP_H_Pos                   16                                                      /*!< SCT CAP10: CAP_H Position               */
#define SCT_CAP10_CAP_H_Msk                   (0x0000ffffUL << SCT_CAP10_CAP_H_Pos)                   /*!< SCT CAP10: CAP_H Mask                   */

/* ---------------------------------  SCT_MATCH10  -------------------------------- */
#define SCT_MATCH10_MATCH_L_Pos               0                                                       /*!< SCT MATCH10: MATCH_L Position           */
#define SCT_MATCH10_MATCH_L_Msk               (0x0000ffffUL << SCT_MATCH10_MATCH_L_Pos)               /*!< SCT MATCH10: MATCH_L Mask               */
#define SCT_MATCH10_MATCH_H_Pos               16                                                      /*!< SCT MATCH10: MATCH_H Position           */
#define SCT_MATCH10_MATCH_H_Msk               (0x0000ffffUL << SCT_MATCH10_MATCH_H_Pos)               /*!< SCT MATCH10: MATCH_H Mask               */

/* ----------------------------------  SCT_CAP11  --------------------------------- */
#define SCT_CAP11_CAP_L_Pos                   0                                                       /*!< SCT CAP11: CAP_L Position               */
#define SCT_CAP11_CAP_L_Msk                   (0x0000ffffUL << SCT_CAP11_CAP_L_Pos)                   /*!< SCT CAP11: CAP_L Mask                   */
#define SCT_CAP11_CAP_H_Pos                   16                                                      /*!< SCT CAP11: CAP_H Position               */
#define SCT_CAP11_CAP_H_Msk                   (0x0000ffffUL << SCT_CAP11_CAP_H_Pos)                   /*!< SCT CAP11: CAP_H Mask                   */

/* ---------------------------------  SCT_MATCH11  -------------------------------- */
#define SCT_MATCH11_MATCH_L_Pos               0                                                       /*!< SCT MATCH11: MATCH_L Position           */
#define SCT_MATCH11_MATCH_L_Msk               (0x0000ffffUL << SCT_MATCH11_MATCH_L_Pos)               /*!< SCT MATCH11: MATCH_L Mask               */
#define SCT_MATCH11_MATCH_H_Pos               16                                                      /*!< SCT MATCH11: MATCH_H Position           */
#define SCT_MATCH11_MATCH_H_Msk               (0x0000ffffUL << SCT_MATCH11_MATCH_H_Pos)               /*!< SCT MATCH11: MATCH_H Mask               */

/* ----------------------------------  SCT_CAP12  --------------------------------- */
#define SCT_CAP12_CAP_L_Pos                   0                                                       /*!< SCT CAP12: CAP_L Position               */
#define SCT_CAP12_CAP_L_Msk                   (0x0000ffffUL << SCT_CAP12_CAP_L_Pos)                   /*!< SCT CAP12: CAP_L Mask                   */
#define SCT_CAP12_CAP_H_Pos                   16                                                      /*!< SCT CAP12: CAP_H Position               */
#define SCT_CAP12_CAP_H_Msk                   (0x0000ffffUL << SCT_CAP12_CAP_H_Pos)                   /*!< SCT CAP12: CAP_H Mask                   */

/* ---------------------------------  SCT_MATCH12  -------------------------------- */
#define SCT_MATCH12_MATCH_L_Pos               0                                                       /*!< SCT MATCH12: MATCH_L Position           */
#define SCT_MATCH12_MATCH_L_Msk               (0x0000ffffUL << SCT_MATCH12_MATCH_L_Pos)               /*!< SCT MATCH12: MATCH_L Mask               */
#define SCT_MATCH12_MATCH_H_Pos               16                                                      /*!< SCT MATCH12: MATCH_H Position           */
#define SCT_MATCH12_MATCH_H_Msk               (0x0000ffffUL << SCT_MATCH12_MATCH_H_Pos)               /*!< SCT MATCH12: MATCH_H Mask               */

/* ---------------------------------  SCT_MATCH13  -------------------------------- */
#define SCT_MATCH13_MATCH_L_Pos               0                                                       /*!< SCT MATCH13: MATCH_L Position           */
#define SCT_MATCH13_MATCH_L_Msk               (0x0000ffffUL << SCT_MATCH13_MATCH_L_Pos)               /*!< SCT MATCH13: MATCH_L Mask               */
#define SCT_MATCH13_MATCH_H_Pos               16                                                      /*!< SCT MATCH13: MATCH_H Position           */
#define SCT_MATCH13_MATCH_H_Msk               (0x0000ffffUL << SCT_MATCH13_MATCH_H_Pos)               /*!< SCT MATCH13: MATCH_H Mask               */

/* ----------------------------------  SCT_CAP13  --------------------------------- */
#define SCT_CAP13_CAP_L_Pos                   0                                                       /*!< SCT CAP13: CAP_L Position               */
#define SCT_CAP13_CAP_L_Msk                   (0x0000ffffUL << SCT_CAP13_CAP_L_Pos)                   /*!< SCT CAP13: CAP_L Mask                   */
#define SCT_CAP13_CAP_H_Pos                   16                                                      /*!< SCT CAP13: CAP_H Position               */
#define SCT_CAP13_CAP_H_Msk                   (0x0000ffffUL << SCT_CAP13_CAP_H_Pos)                   /*!< SCT CAP13: CAP_H Mask                   */

/* ----------------------------------  SCT_CAP14  --------------------------------- */
#define SCT_CAP14_CAP_L_Pos                   0                                                       /*!< SCT CAP14: CAP_L Position               */
#define SCT_CAP14_CAP_L_Msk                   (0x0000ffffUL << SCT_CAP14_CAP_L_Pos)                   /*!< SCT CAP14: CAP_L Mask                   */
#define SCT_CAP14_CAP_H_Pos                   16                                                      /*!< SCT CAP14: CAP_H Position               */
#define SCT_CAP14_CAP_H_Msk                   (0x0000ffffUL << SCT_CAP14_CAP_H_Pos)                   /*!< SCT CAP14: CAP_H Mask                   */

/* ---------------------------------  SCT_MATCH14  -------------------------------- */
#define SCT_MATCH14_MATCH_L_Pos               0                                                       /*!< SCT MATCH14: MATCH_L Position           */
#define SCT_MATCH14_MATCH_L_Msk               (0x0000ffffUL << SCT_MATCH14_MATCH_L_Pos)               /*!< SCT MATCH14: MATCH_L Mask               */
#define SCT_MATCH14_MATCH_H_Pos               16                                                      /*!< SCT MATCH14: MATCH_H Position           */
#define SCT_MATCH14_MATCH_H_Msk               (0x0000ffffUL << SCT_MATCH14_MATCH_H_Pos)               /*!< SCT MATCH14: MATCH_H Mask               */

/* ---------------------------------  SCT_MATCH15  -------------------------------- */
#define SCT_MATCH15_MATCH_L_Pos               0                                                       /*!< SCT MATCH15: MATCH_L Position           */
#define SCT_MATCH15_MATCH_L_Msk               (0x0000ffffUL << SCT_MATCH15_MATCH_L_Pos)               /*!< SCT MATCH15: MATCH_L Mask               */
#define SCT_MATCH15_MATCH_H_Pos               16                                                      /*!< SCT MATCH15: MATCH_H Position           */
#define SCT_MATCH15_MATCH_H_Msk               (0x0000ffffUL << SCT_MATCH15_MATCH_H_Pos)               /*!< SCT MATCH15: MATCH_H Mask               */

/* ----------------------------------  SCT_CAP15  --------------------------------- */
#define SCT_CAP15_CAP_L_Pos                   0                                                       /*!< SCT CAP15: CAP_L Position               */
#define SCT_CAP15_CAP_L_Msk                   (0x0000ffffUL << SCT_CAP15_CAP_L_Pos)                   /*!< SCT CAP15: CAP_L Mask                   */
#define SCT_CAP15_CAP_H_Pos                   16                                                      /*!< SCT CAP15: CAP_H Position               */
#define SCT_CAP15_CAP_H_Msk                   (0x0000ffffUL << SCT_CAP15_CAP_H_Pos)                   /*!< SCT CAP15: CAP_H Mask                   */

/* --------------------------------  SCT_FRACMAT0  -------------------------------- */
#define SCT_FRACMAT0_FRACMAT_L_Pos            0                                                       /*!< SCT FRACMAT0: FRACMAT_L Position        */
#define SCT_FRACMAT0_FRACMAT_L_Msk            (0x0fUL << SCT_FRACMAT0_FRACMAT_L_Pos)                  /*!< SCT FRACMAT0: FRACMAT_L Mask            */
#define SCT_FRACMAT0_FRACMAT_H_Pos            16                                                      /*!< SCT FRACMAT0: FRACMAT_H Position        */
#define SCT_FRACMAT0_FRACMAT_H_Msk            (0x0fUL << SCT_FRACMAT0_FRACMAT_H_Pos)                  /*!< SCT FRACMAT0: FRACMAT_H Mask            */

/* --------------------------------  SCT_FRACMAT1  -------------------------------- */
#define SCT_FRACMAT1_FRACMAT_L_Pos            0                                                       /*!< SCT FRACMAT1: FRACMAT_L Position        */
#define SCT_FRACMAT1_FRACMAT_L_Msk            (0x0fUL << SCT_FRACMAT1_FRACMAT_L_Pos)                  /*!< SCT FRACMAT1: FRACMAT_L Mask            */
#define SCT_FRACMAT1_FRACMAT_H_Pos            16                                                      /*!< SCT FRACMAT1: FRACMAT_H Position        */
#define SCT_FRACMAT1_FRACMAT_H_Msk            (0x0fUL << SCT_FRACMAT1_FRACMAT_H_Pos)                  /*!< SCT FRACMAT1: FRACMAT_H Mask            */

/* --------------------------------  SCT_FRACMAT2  -------------------------------- */
#define SCT_FRACMAT2_FRACMAT_L_Pos            0                                                       /*!< SCT FRACMAT2: FRACMAT_L Position        */
#define SCT_FRACMAT2_FRACMAT_L_Msk            (0x0fUL << SCT_FRACMAT2_FRACMAT_L_Pos)                  /*!< SCT FRACMAT2: FRACMAT_L Mask            */
#define SCT_FRACMAT2_FRACMAT_H_Pos            16                                                      /*!< SCT FRACMAT2: FRACMAT_H Position        */
#define SCT_FRACMAT2_FRACMAT_H_Msk            (0x0fUL << SCT_FRACMAT2_FRACMAT_H_Pos)                  /*!< SCT FRACMAT2: FRACMAT_H Mask            */

/* --------------------------------  SCT_FRACMAT3  -------------------------------- */
#define SCT_FRACMAT3_FRACMAT_L_Pos            0                                                       /*!< SCT FRACMAT3: FRACMAT_L Position        */
#define SCT_FRACMAT3_FRACMAT_L_Msk            (0x0fUL << SCT_FRACMAT3_FRACMAT_L_Pos)                  /*!< SCT FRACMAT3: FRACMAT_L Mask            */
#define SCT_FRACMAT3_FRACMAT_H_Pos            16                                                      /*!< SCT FRACMAT3: FRACMAT_H Position        */
#define SCT_FRACMAT3_FRACMAT_H_Msk            (0x0fUL << SCT_FRACMAT3_FRACMAT_H_Pos)                  /*!< SCT FRACMAT3: FRACMAT_H Mask            */

/* --------------------------------  SCT_FRACMAT4  -------------------------------- */
#define SCT_FRACMAT4_FRACMAT_L_Pos            0                                                       /*!< SCT FRACMAT4: FRACMAT_L Position        */
#define SCT_FRACMAT4_FRACMAT_L_Msk            (0x0fUL << SCT_FRACMAT4_FRACMAT_L_Pos)                  /*!< SCT FRACMAT4: FRACMAT_L Mask            */
#define SCT_FRACMAT4_FRACMAT_H_Pos            16                                                      /*!< SCT FRACMAT4: FRACMAT_H Position        */
#define SCT_FRACMAT4_FRACMAT_H_Msk            (0x0fUL << SCT_FRACMAT4_FRACMAT_H_Pos)                  /*!< SCT FRACMAT4: FRACMAT_H Mask            */

/* --------------------------------  SCT_FRACMAT5  -------------------------------- */
#define SCT_FRACMAT5_FRACMAT_L_Pos            0                                                       /*!< SCT FRACMAT5: FRACMAT_L Position        */
#define SCT_FRACMAT5_FRACMAT_L_Msk            (0x0fUL << SCT_FRACMAT5_FRACMAT_L_Pos)                  /*!< SCT FRACMAT5: FRACMAT_L Mask            */
#define SCT_FRACMAT5_FRACMAT_H_Pos            16                                                      /*!< SCT FRACMAT5: FRACMAT_H Position        */
#define SCT_FRACMAT5_FRACMAT_H_Msk            (0x0fUL << SCT_FRACMAT5_FRACMAT_H_Pos)                  /*!< SCT FRACMAT5: FRACMAT_H Mask            */

/* --------------------------------  SCT_MATCHREL0  ------------------------------- */
#define SCT_MATCHREL0_RELOAD_L_Pos            0                                                       /*!< SCT MATCHREL0: RELOAD_L Position        */
#define SCT_MATCHREL0_RELOAD_L_Msk            (0x0000ffffUL << SCT_MATCHREL0_RELOAD_L_Pos)            /*!< SCT MATCHREL0: RELOAD_L Mask            */
#define SCT_MATCHREL0_RELOAD_H_Pos            16                                                      /*!< SCT MATCHREL0: RELOAD_H Position        */
#define SCT_MATCHREL0_RELOAD_H_Msk            (0x0000ffffUL << SCT_MATCHREL0_RELOAD_H_Pos)            /*!< SCT MATCHREL0: RELOAD_H Mask            */

/* --------------------------------  SCT_CAPCTRL0  -------------------------------- */
#define SCT_CAPCTRL0_CAPCON_L_Pos             0                                                       /*!< SCT CAPCTRL0: CAPCON_L Position         */
#define SCT_CAPCTRL0_CAPCON_L_Msk             (0x0000ffffUL << SCT_CAPCTRL0_CAPCON_L_Pos)             /*!< SCT CAPCTRL0: CAPCON_L Mask             */
#define SCT_CAPCTRL0_CAPCON_H_Pos             16                                                      /*!< SCT CAPCTRL0: CAPCON_H Position         */
#define SCT_CAPCTRL0_CAPCON_H_Msk             (0x0000ffffUL << SCT_CAPCTRL0_CAPCON_H_Pos)             /*!< SCT CAPCTRL0: CAPCON_H Mask             */

/* --------------------------------  SCT_CAPCTRL1  -------------------------------- */
#define SCT_CAPCTRL1_CAPCON_L_Pos             0                                                       /*!< SCT CAPCTRL1: CAPCON_L Position         */
#define SCT_CAPCTRL1_CAPCON_L_Msk             (0x0000ffffUL << SCT_CAPCTRL1_CAPCON_L_Pos)             /*!< SCT CAPCTRL1: CAPCON_L Mask             */
#define SCT_CAPCTRL1_CAPCON_H_Pos             16                                                      /*!< SCT CAPCTRL1: CAPCON_H Position         */
#define SCT_CAPCTRL1_CAPCON_H_Msk             (0x0000ffffUL << SCT_CAPCTRL1_CAPCON_H_Pos)             /*!< SCT CAPCTRL1: CAPCON_H Mask             */

/* --------------------------------  SCT_MATCHREL1  ------------------------------- */
#define SCT_MATCHREL1_RELOAD_L_Pos            0                                                       /*!< SCT MATCHREL1: RELOAD_L Position        */
#define SCT_MATCHREL1_RELOAD_L_Msk            (0x0000ffffUL << SCT_MATCHREL1_RELOAD_L_Pos)            /*!< SCT MATCHREL1: RELOAD_L Mask            */
#define SCT_MATCHREL1_RELOAD_H_Pos            16                                                      /*!< SCT MATCHREL1: RELOAD_H Position        */
#define SCT_MATCHREL1_RELOAD_H_Msk            (0x0000ffffUL << SCT_MATCHREL1_RELOAD_H_Pos)            /*!< SCT MATCHREL1: RELOAD_H Mask            */

/* --------------------------------  SCT_MATCHREL2  ------------------------------- */
#define SCT_MATCHREL2_RELOAD_L_Pos            0                                                       /*!< SCT MATCHREL2: RELOAD_L Position        */
#define SCT_MATCHREL2_RELOAD_L_Msk            (0x0000ffffUL << SCT_MATCHREL2_RELOAD_L_Pos)            /*!< SCT MATCHREL2: RELOAD_L Mask            */
#define SCT_MATCHREL2_RELOAD_H_Pos            16                                                      /*!< SCT MATCHREL2: RELOAD_H Position        */
#define SCT_MATCHREL2_RELOAD_H_Msk            (0x0000ffffUL << SCT_MATCHREL2_RELOAD_H_Pos)            /*!< SCT MATCHREL2: RELOAD_H Mask            */

/* --------------------------------  SCT_CAPCTRL2  -------------------------------- */
#define SCT_CAPCTRL2_CAPCON_L_Pos             0                                                       /*!< SCT CAPCTRL2: CAPCON_L Position         */
#define SCT_CAPCTRL2_CAPCON_L_Msk             (0x0000ffffUL << SCT_CAPCTRL2_CAPCON_L_Pos)             /*!< SCT CAPCTRL2: CAPCON_L Mask             */
#define SCT_CAPCTRL2_CAPCON_H_Pos             16                                                      /*!< SCT CAPCTRL2: CAPCON_H Position         */
#define SCT_CAPCTRL2_CAPCON_H_Msk             (0x0000ffffUL << SCT_CAPCTRL2_CAPCON_H_Pos)             /*!< SCT CAPCTRL2: CAPCON_H Mask             */

/* --------------------------------  SCT_CAPCTRL3  -------------------------------- */
#define SCT_CAPCTRL3_CAPCON_L_Pos             0                                                       /*!< SCT CAPCTRL3: CAPCON_L Position         */
#define SCT_CAPCTRL3_CAPCON_L_Msk             (0x0000ffffUL << SCT_CAPCTRL3_CAPCON_L_Pos)             /*!< SCT CAPCTRL3: CAPCON_L Mask             */
#define SCT_CAPCTRL3_CAPCON_H_Pos             16                                                      /*!< SCT CAPCTRL3: CAPCON_H Position         */
#define SCT_CAPCTRL3_CAPCON_H_Msk             (0x0000ffffUL << SCT_CAPCTRL3_CAPCON_H_Pos)             /*!< SCT CAPCTRL3: CAPCON_H Mask             */

/* --------------------------------  SCT_MATCHREL3  ------------------------------- */
#define SCT_MATCHREL3_RELOAD_L_Pos            0                                                       /*!< SCT MATCHREL3: RELOAD_L Position        */
#define SCT_MATCHREL3_RELOAD_L_Msk            (0x0000ffffUL << SCT_MATCHREL3_RELOAD_L_Pos)            /*!< SCT MATCHREL3: RELOAD_L Mask            */
#define SCT_MATCHREL3_RELOAD_H_Pos            16                                                      /*!< SCT MATCHREL3: RELOAD_H Position        */
#define SCT_MATCHREL3_RELOAD_H_Msk            (0x0000ffffUL << SCT_MATCHREL3_RELOAD_H_Pos)            /*!< SCT MATCHREL3: RELOAD_H Mask            */

/* --------------------------------  SCT_MATCHREL4  ------------------------------- */
#define SCT_MATCHREL4_RELOAD_L_Pos            0                                                       /*!< SCT MATCHREL4: RELOAD_L Position        */
#define SCT_MATCHREL4_RELOAD_L_Msk            (0x0000ffffUL << SCT_MATCHREL4_RELOAD_L_Pos)            /*!< SCT MATCHREL4: RELOAD_L Mask            */
#define SCT_MATCHREL4_RELOAD_H_Pos            16                                                      /*!< SCT MATCHREL4: RELOAD_H Position        */
#define SCT_MATCHREL4_RELOAD_H_Msk            (0x0000ffffUL << SCT_MATCHREL4_RELOAD_H_Pos)            /*!< SCT MATCHREL4: RELOAD_H Mask            */

/* --------------------------------  SCT_CAPCTRL4  -------------------------------- */
#define SCT_CAPCTRL4_CAPCON_L_Pos             0                                                       /*!< SCT CAPCTRL4: CAPCON_L Position         */
#define SCT_CAPCTRL4_CAPCON_L_Msk             (0x0000ffffUL << SCT_CAPCTRL4_CAPCON_L_Pos)             /*!< SCT CAPCTRL4: CAPCON_L Mask             */
#define SCT_CAPCTRL4_CAPCON_H_Pos             16                                                      /*!< SCT CAPCTRL4: CAPCON_H Position         */
#define SCT_CAPCTRL4_CAPCON_H_Msk             (0x0000ffffUL << SCT_CAPCTRL4_CAPCON_H_Pos)             /*!< SCT CAPCTRL4: CAPCON_H Mask             */

/* --------------------------------  SCT_MATCHREL5  ------------------------------- */
#define SCT_MATCHREL5_RELOAD_L_Pos            0                                                       /*!< SCT MATCHREL5: RELOAD_L Position        */
#define SCT_MATCHREL5_RELOAD_L_Msk            (0x0000ffffUL << SCT_MATCHREL5_RELOAD_L_Pos)            /*!< SCT MATCHREL5: RELOAD_L Mask            */
#define SCT_MATCHREL5_RELOAD_H_Pos            16                                                      /*!< SCT MATCHREL5: RELOAD_H Position        */
#define SCT_MATCHREL5_RELOAD_H_Msk            (0x0000ffffUL << SCT_MATCHREL5_RELOAD_H_Pos)            /*!< SCT MATCHREL5: RELOAD_H Mask            */

/* --------------------------------  SCT_CAPCTRL5  -------------------------------- */
#define SCT_CAPCTRL5_CAPCON_L_Pos             0                                                       /*!< SCT CAPCTRL5: CAPCON_L Position         */
#define SCT_CAPCTRL5_CAPCON_L_Msk             (0x0000ffffUL << SCT_CAPCTRL5_CAPCON_L_Pos)             /*!< SCT CAPCTRL5: CAPCON_L Mask             */
#define SCT_CAPCTRL5_CAPCON_H_Pos             16                                                      /*!< SCT CAPCTRL5: CAPCON_H Position         */
#define SCT_CAPCTRL5_CAPCON_H_Msk             (0x0000ffffUL << SCT_CAPCTRL5_CAPCON_H_Pos)             /*!< SCT CAPCTRL5: CAPCON_H Mask             */

/* --------------------------------  SCT_CAPCTRL6  -------------------------------- */
#define SCT_CAPCTRL6_CAPCON_L_Pos             0                                                       /*!< SCT CAPCTRL6: CAPCON_L Position         */
#define SCT_CAPCTRL6_CAPCON_L_Msk             (0x0000ffffUL << SCT_CAPCTRL6_CAPCON_L_Pos)             /*!< SCT CAPCTRL6: CAPCON_L Mask             */
#define SCT_CAPCTRL6_CAPCON_H_Pos             16                                                      /*!< SCT CAPCTRL6: CAPCON_H Position         */
#define SCT_CAPCTRL6_CAPCON_H_Msk             (0x0000ffffUL << SCT_CAPCTRL6_CAPCON_H_Pos)             /*!< SCT CAPCTRL6: CAPCON_H Mask             */

/* --------------------------------  SCT_MATCHREL6  ------------------------------- */
#define SCT_MATCHREL6_RELOAD_L_Pos            0                                                       /*!< SCT MATCHREL6: RELOAD_L Position        */
#define SCT_MATCHREL6_RELOAD_L_Msk            (0x0000ffffUL << SCT_MATCHREL6_RELOAD_L_Pos)            /*!< SCT MATCHREL6: RELOAD_L Mask            */
#define SCT_MATCHREL6_RELOAD_H_Pos            16                                                      /*!< SCT MATCHREL6: RELOAD_H Position        */
#define SCT_MATCHREL6_RELOAD_H_Msk            (0x0000ffffUL << SCT_MATCHREL6_RELOAD_H_Pos)            /*!< SCT MATCHREL6: RELOAD_H Mask            */

/* --------------------------------  SCT_MATCHREL7  ------------------------------- */
#define SCT_MATCHREL7_RELOAD_L_Pos            0                                                       /*!< SCT MATCHREL7: RELOAD_L Position        */
#define SCT_MATCHREL7_RELOAD_L_Msk            (0x0000ffffUL << SCT_MATCHREL7_RELOAD_L_Pos)            /*!< SCT MATCHREL7: RELOAD_L Mask            */
#define SCT_MATCHREL7_RELOAD_H_Pos            16                                                      /*!< SCT MATCHREL7: RELOAD_H Position        */
#define SCT_MATCHREL7_RELOAD_H_Msk            (0x0000ffffUL << SCT_MATCHREL7_RELOAD_H_Pos)            /*!< SCT MATCHREL7: RELOAD_H Mask            */

/* --------------------------------  SCT_CAPCTRL7  -------------------------------- */
#define SCT_CAPCTRL7_CAPCON_L_Pos             0                                                       /*!< SCT CAPCTRL7: CAPCON_L Position         */
#define SCT_CAPCTRL7_CAPCON_L_Msk             (0x0000ffffUL << SCT_CAPCTRL7_CAPCON_L_Pos)             /*!< SCT CAPCTRL7: CAPCON_L Mask             */
#define SCT_CAPCTRL7_CAPCON_H_Pos             16                                                      /*!< SCT CAPCTRL7: CAPCON_H Position         */
#define SCT_CAPCTRL7_CAPCON_H_Msk             (0x0000ffffUL << SCT_CAPCTRL7_CAPCON_H_Pos)             /*!< SCT CAPCTRL7: CAPCON_H Mask             */

/* --------------------------------  SCT_CAPCTRL8  -------------------------------- */
#define SCT_CAPCTRL8_CAPCON_L_Pos             0                                                       /*!< SCT CAPCTRL8: CAPCON_L Position         */
#define SCT_CAPCTRL8_CAPCON_L_Msk             (0x0000ffffUL << SCT_CAPCTRL8_CAPCON_L_Pos)             /*!< SCT CAPCTRL8: CAPCON_L Mask             */
#define SCT_CAPCTRL8_CAPCON_H_Pos             16                                                      /*!< SCT CAPCTRL8: CAPCON_H Position         */
#define SCT_CAPCTRL8_CAPCON_H_Msk             (0x0000ffffUL << SCT_CAPCTRL8_CAPCON_H_Pos)             /*!< SCT CAPCTRL8: CAPCON_H Mask             */

/* --------------------------------  SCT_MATCHREL8  ------------------------------- */
#define SCT_MATCHREL8_RELOAD_L_Pos            0                                                       /*!< SCT MATCHREL8: RELOAD_L Position        */
#define SCT_MATCHREL8_RELOAD_L_Msk            (0x0000ffffUL << SCT_MATCHREL8_RELOAD_L_Pos)            /*!< SCT MATCHREL8: RELOAD_L Mask            */
#define SCT_MATCHREL8_RELOAD_H_Pos            16                                                      /*!< SCT MATCHREL8: RELOAD_H Position        */
#define SCT_MATCHREL8_RELOAD_H_Msk            (0x0000ffffUL << SCT_MATCHREL8_RELOAD_H_Pos)            /*!< SCT MATCHREL8: RELOAD_H Mask            */

/* --------------------------------  SCT_MATCHREL9  ------------------------------- */
#define SCT_MATCHREL9_RELOAD_L_Pos            0                                                       /*!< SCT MATCHREL9: RELOAD_L Position        */
#define SCT_MATCHREL9_RELOAD_L_Msk            (0x0000ffffUL << SCT_MATCHREL9_RELOAD_L_Pos)            /*!< SCT MATCHREL9: RELOAD_L Mask            */
#define SCT_MATCHREL9_RELOAD_H_Pos            16                                                      /*!< SCT MATCHREL9: RELOAD_H Position        */
#define SCT_MATCHREL9_RELOAD_H_Msk            (0x0000ffffUL << SCT_MATCHREL9_RELOAD_H_Pos)            /*!< SCT MATCHREL9: RELOAD_H Mask            */

/* --------------------------------  SCT_CAPCTRL9  -------------------------------- */
#define SCT_CAPCTRL9_CAPCON_L_Pos             0                                                       /*!< SCT CAPCTRL9: CAPCON_L Position         */
#define SCT_CAPCTRL9_CAPCON_L_Msk             (0x0000ffffUL << SCT_CAPCTRL9_CAPCON_L_Pos)             /*!< SCT CAPCTRL9: CAPCON_L Mask             */
#define SCT_CAPCTRL9_CAPCON_H_Pos             16                                                      /*!< SCT CAPCTRL9: CAPCON_H Position         */
#define SCT_CAPCTRL9_CAPCON_H_Msk             (0x0000ffffUL << SCT_CAPCTRL9_CAPCON_H_Pos)             /*!< SCT CAPCTRL9: CAPCON_H Mask             */

/* --------------------------------  SCT_CAPCTRL10  ------------------------------- */
#define SCT_CAPCTRL10_CAPCON_L_Pos            0                                                       /*!< SCT CAPCTRL10: CAPCON_L Position        */
#define SCT_CAPCTRL10_CAPCON_L_Msk            (0x0000ffffUL << SCT_CAPCTRL10_CAPCON_L_Pos)            /*!< SCT CAPCTRL10: CAPCON_L Mask            */
#define SCT_CAPCTRL10_CAPCON_H_Pos            16                                                      /*!< SCT CAPCTRL10: CAPCON_H Position        */
#define SCT_CAPCTRL10_CAPCON_H_Msk            (0x0000ffffUL << SCT_CAPCTRL10_CAPCON_H_Pos)            /*!< SCT CAPCTRL10: CAPCON_H Mask            */

/* -------------------------------  SCT_MATCHREL10  ------------------------------- */
#define SCT_MATCHREL10_RELOAD_L_Pos           0                                                       /*!< SCT MATCHREL10: RELOAD_L Position       */
#define SCT_MATCHREL10_RELOAD_L_Msk           (0x0000ffffUL << SCT_MATCHREL10_RELOAD_L_Pos)           /*!< SCT MATCHREL10: RELOAD_L Mask           */
#define SCT_MATCHREL10_RELOAD_H_Pos           16                                                      /*!< SCT MATCHREL10: RELOAD_H Position       */
#define SCT_MATCHREL10_RELOAD_H_Msk           (0x0000ffffUL << SCT_MATCHREL10_RELOAD_H_Pos)           /*!< SCT MATCHREL10: RELOAD_H Mask           */

/* --------------------------------  SCT_CAPCTRL11  ------------------------------- */
#define SCT_CAPCTRL11_CAPCON_L_Pos            0                                                       /*!< SCT CAPCTRL11: CAPCON_L Position        */
#define SCT_CAPCTRL11_CAPCON_L_Msk            (0x0000ffffUL << SCT_CAPCTRL11_CAPCON_L_Pos)            /*!< SCT CAPCTRL11: CAPCON_L Mask            */
#define SCT_CAPCTRL11_CAPCON_H_Pos            16                                                      /*!< SCT CAPCTRL11: CAPCON_H Position        */
#define SCT_CAPCTRL11_CAPCON_H_Msk            (0x0000ffffUL << SCT_CAPCTRL11_CAPCON_H_Pos)            /*!< SCT CAPCTRL11: CAPCON_H Mask            */

/* -------------------------------  SCT_MATCHREL11  ------------------------------- */
#define SCT_MATCHREL11_RELOAD_L_Pos           0                                                       /*!< SCT MATCHREL11: RELOAD_L Position       */
#define SCT_MATCHREL11_RELOAD_L_Msk           (0x0000ffffUL << SCT_MATCHREL11_RELOAD_L_Pos)           /*!< SCT MATCHREL11: RELOAD_L Mask           */
#define SCT_MATCHREL11_RELOAD_H_Pos           16                                                      /*!< SCT MATCHREL11: RELOAD_H Position       */
#define SCT_MATCHREL11_RELOAD_H_Msk           (0x0000ffffUL << SCT_MATCHREL11_RELOAD_H_Pos)           /*!< SCT MATCHREL11: RELOAD_H Mask           */

/* --------------------------------  SCT_CAPCTRL12  ------------------------------- */
#define SCT_CAPCTRL12_CAPCON_L_Pos            0                                                       /*!< SCT CAPCTRL12: CAPCON_L Position        */
#define SCT_CAPCTRL12_CAPCON_L_Msk            (0x0000ffffUL << SCT_CAPCTRL12_CAPCON_L_Pos)            /*!< SCT CAPCTRL12: CAPCON_L Mask            */
#define SCT_CAPCTRL12_CAPCON_H_Pos            16                                                      /*!< SCT CAPCTRL12: CAPCON_H Position        */
#define SCT_CAPCTRL12_CAPCON_H_Msk            (0x0000ffffUL << SCT_CAPCTRL12_CAPCON_H_Pos)            /*!< SCT CAPCTRL12: CAPCON_H Mask            */

/* -------------------------------  SCT_MATCHREL12  ------------------------------- */
#define SCT_MATCHREL12_RELOAD_L_Pos           0                                                       /*!< SCT MATCHREL12: RELOAD_L Position       */
#define SCT_MATCHREL12_RELOAD_L_Msk           (0x0000ffffUL << SCT_MATCHREL12_RELOAD_L_Pos)           /*!< SCT MATCHREL12: RELOAD_L Mask           */
#define SCT_MATCHREL12_RELOAD_H_Pos           16                                                      /*!< SCT MATCHREL12: RELOAD_H Position       */
#define SCT_MATCHREL12_RELOAD_H_Msk           (0x0000ffffUL << SCT_MATCHREL12_RELOAD_H_Pos)           /*!< SCT MATCHREL12: RELOAD_H Mask           */

/* -------------------------------  SCT_MATCHREL13  ------------------------------- */
#define SCT_MATCHREL13_RELOAD_L_Pos           0                                                       /*!< SCT MATCHREL13: RELOAD_L Position       */
#define SCT_MATCHREL13_RELOAD_L_Msk           (0x0000ffffUL << SCT_MATCHREL13_RELOAD_L_Pos)           /*!< SCT MATCHREL13: RELOAD_L Mask           */
#define SCT_MATCHREL13_RELOAD_H_Pos           16                                                      /*!< SCT MATCHREL13: RELOAD_H Position       */
#define SCT_MATCHREL13_RELOAD_H_Msk           (0x0000ffffUL << SCT_MATCHREL13_RELOAD_H_Pos)           /*!< SCT MATCHREL13: RELOAD_H Mask           */

/* --------------------------------  SCT_CAPCTRL13  ------------------------------- */
#define SCT_CAPCTRL13_CAPCON_L_Pos            0                                                       /*!< SCT CAPCTRL13: CAPCON_L Position        */
#define SCT_CAPCTRL13_CAPCON_L_Msk            (0x0000ffffUL << SCT_CAPCTRL13_CAPCON_L_Pos)            /*!< SCT CAPCTRL13: CAPCON_L Mask            */
#define SCT_CAPCTRL13_CAPCON_H_Pos            16                                                      /*!< SCT CAPCTRL13: CAPCON_H Position        */
#define SCT_CAPCTRL13_CAPCON_H_Msk            (0x0000ffffUL << SCT_CAPCTRL13_CAPCON_H_Pos)            /*!< SCT CAPCTRL13: CAPCON_H Mask            */

/* -------------------------------  SCT_MATCHREL14  ------------------------------- */
#define SCT_MATCHREL14_RELOAD_L_Pos           0                                                       /*!< SCT MATCHREL14: RELOAD_L Position       */
#define SCT_MATCHREL14_RELOAD_L_Msk           (0x0000ffffUL << SCT_MATCHREL14_RELOAD_L_Pos)           /*!< SCT MATCHREL14: RELOAD_L Mask           */
#define SCT_MATCHREL14_RELOAD_H_Pos           16                                                      /*!< SCT MATCHREL14: RELOAD_H Position       */
#define SCT_MATCHREL14_RELOAD_H_Msk           (0x0000ffffUL << SCT_MATCHREL14_RELOAD_H_Pos)           /*!< SCT MATCHREL14: RELOAD_H Mask           */

/* --------------------------------  SCT_CAPCTRL14  ------------------------------- */
#define SCT_CAPCTRL14_CAPCON_L_Pos            0                                                       /*!< SCT CAPCTRL14: CAPCON_L Position        */
#define SCT_CAPCTRL14_CAPCON_L_Msk            (0x0000ffffUL << SCT_CAPCTRL14_CAPCON_L_Pos)            /*!< SCT CAPCTRL14: CAPCON_L Mask            */
#define SCT_CAPCTRL14_CAPCON_H_Pos            16                                                      /*!< SCT CAPCTRL14: CAPCON_H Position        */
#define SCT_CAPCTRL14_CAPCON_H_Msk            (0x0000ffffUL << SCT_CAPCTRL14_CAPCON_H_Pos)            /*!< SCT CAPCTRL14: CAPCON_H Mask            */

/* -------------------------------  SCT_MATCHREL15  ------------------------------- */
#define SCT_MATCHREL15_RELOAD_L_Pos           0                                                       /*!< SCT MATCHREL15: RELOAD_L Position       */
#define SCT_MATCHREL15_RELOAD_L_Msk           (0x0000ffffUL << SCT_MATCHREL15_RELOAD_L_Pos)           /*!< SCT MATCHREL15: RELOAD_L Mask           */
#define SCT_MATCHREL15_RELOAD_H_Pos           16                                                      /*!< SCT MATCHREL15: RELOAD_H Position       */
#define SCT_MATCHREL15_RELOAD_H_Msk           (0x0000ffffUL << SCT_MATCHREL15_RELOAD_H_Pos)           /*!< SCT MATCHREL15: RELOAD_H Mask           */

/* --------------------------------  SCT_CAPCTRL15  ------------------------------- */
#define SCT_CAPCTRL15_CAPCON_L_Pos            0                                                       /*!< SCT CAPCTRL15: CAPCON_L Position        */
#define SCT_CAPCTRL15_CAPCON_L_Msk            (0x0000ffffUL << SCT_CAPCTRL15_CAPCON_L_Pos)            /*!< SCT CAPCTRL15: CAPCON_L Mask            */
#define SCT_CAPCTRL15_CAPCON_H_Pos            16                                                      /*!< SCT CAPCTRL15: CAPCON_H Position        */
#define SCT_CAPCTRL15_CAPCON_H_Msk            (0x0000ffffUL << SCT_CAPCTRL15_CAPCON_H_Pos)            /*!< SCT CAPCTRL15: CAPCON_H Mask            */

/* -------------------------------  SCT_FRACMATREL0  ------------------------------ */
#define SCT_FRACMATREL0_RELFRAC_L_Pos         0                                                       /*!< SCT FRACMATREL0: RELFRAC_L Position     */
#define SCT_FRACMATREL0_RELFRAC_L_Msk         (0x0fUL << SCT_FRACMATREL0_RELFRAC_L_Pos)               /*!< SCT FRACMATREL0: RELFRAC_L Mask         */
#define SCT_FRACMATREL0_RELFRAC_H_Pos         16                                                      /*!< SCT FRACMATREL0: RELFRAC_H Position     */
#define SCT_FRACMATREL0_RELFRAC_H_Msk         (0x0fUL << SCT_FRACMATREL0_RELFRAC_H_Pos)               /*!< SCT FRACMATREL0: RELFRAC_H Mask         */

/* -------------------------------  SCT_FRACMATREL1  ------------------------------ */
#define SCT_FRACMATREL1_RELFRAC_L_Pos         0                                                       /*!< SCT FRACMATREL1: RELFRAC_L Position     */
#define SCT_FRACMATREL1_RELFRAC_L_Msk         (0x0fUL << SCT_FRACMATREL1_RELFRAC_L_Pos)               /*!< SCT FRACMATREL1: RELFRAC_L Mask         */
#define SCT_FRACMATREL1_RELFRAC_H_Pos         16                                                      /*!< SCT FRACMATREL1: RELFRAC_H Position     */
#define SCT_FRACMATREL1_RELFRAC_H_Msk         (0x0fUL << SCT_FRACMATREL1_RELFRAC_H_Pos)               /*!< SCT FRACMATREL1: RELFRAC_H Mask         */

/* -------------------------------  SCT_FRACMATREL2  ------------------------------ */
#define SCT_FRACMATREL2_RELFRAC_L_Pos         0                                                       /*!< SCT FRACMATREL2: RELFRAC_L Position     */
#define SCT_FRACMATREL2_RELFRAC_L_Msk         (0x0fUL << SCT_FRACMATREL2_RELFRAC_L_Pos)               /*!< SCT FRACMATREL2: RELFRAC_L Mask         */
#define SCT_FRACMATREL2_RELFRAC_H_Pos         16                                                      /*!< SCT FRACMATREL2: RELFRAC_H Position     */
#define SCT_FRACMATREL2_RELFRAC_H_Msk         (0x0fUL << SCT_FRACMATREL2_RELFRAC_H_Pos)               /*!< SCT FRACMATREL2: RELFRAC_H Mask         */

/* -------------------------------  SCT_FRACMATREL3  ------------------------------ */
#define SCT_FRACMATREL3_RELFRAC_L_Pos         0                                                       /*!< SCT FRACMATREL3: RELFRAC_L Position     */
#define SCT_FRACMATREL3_RELFRAC_L_Msk         (0x0fUL << SCT_FRACMATREL3_RELFRAC_L_Pos)               /*!< SCT FRACMATREL3: RELFRAC_L Mask         */
#define SCT_FRACMATREL3_RELFRAC_H_Pos         16                                                      /*!< SCT FRACMATREL3: RELFRAC_H Position     */
#define SCT_FRACMATREL3_RELFRAC_H_Msk         (0x0fUL << SCT_FRACMATREL3_RELFRAC_H_Pos)               /*!< SCT FRACMATREL3: RELFRAC_H Mask         */

/* -------------------------------  SCT_FRACMATREL4  ------------------------------ */
#define SCT_FRACMATREL4_RELFRAC_L_Pos         0                                                       /*!< SCT FRACMATREL4: RELFRAC_L Position     */
#define SCT_FRACMATREL4_RELFRAC_L_Msk         (0x0fUL << SCT_FRACMATREL4_RELFRAC_L_Pos)               /*!< SCT FRACMATREL4: RELFRAC_L Mask         */
#define SCT_FRACMATREL4_RELFRAC_H_Pos         16                                                      /*!< SCT FRACMATREL4: RELFRAC_H Position     */
#define SCT_FRACMATREL4_RELFRAC_H_Msk         (0x0fUL << SCT_FRACMATREL4_RELFRAC_H_Pos)               /*!< SCT FRACMATREL4: RELFRAC_H Mask         */

/* -------------------------------  SCT_FRACMATREL5  ------------------------------ */
#define SCT_FRACMATREL5_RELFRAC_L_Pos         0                                                       /*!< SCT FRACMATREL5: RELFRAC_L Position     */
#define SCT_FRACMATREL5_RELFRAC_L_Msk         (0x0fUL << SCT_FRACMATREL5_RELFRAC_L_Pos)               /*!< SCT FRACMATREL5: RELFRAC_L Mask         */
#define SCT_FRACMATREL5_RELFRAC_H_Pos         16                                                      /*!< SCT FRACMATREL5: RELFRAC_H Position     */
#define SCT_FRACMATREL5_RELFRAC_H_Msk         (0x0fUL << SCT_FRACMATREL5_RELFRAC_H_Pos)               /*!< SCT FRACMATREL5: RELFRAC_H Mask         */

/* --------------------------------  SCT_EV0_STATE  ------------------------------- */
#define SCT_EV0_STATE_STATEMSK0_Pos           0                                                       /*!< SCT EV0_STATE: STATEMSK0 Position       */
#define SCT_EV0_STATE_STATEMSK0_Msk           (0x01UL << SCT_EV0_STATE_STATEMSK0_Pos)                 /*!< SCT EV0_STATE: STATEMSK0 Mask           */
#define SCT_EV0_STATE_STATEMSK1_Pos           1                                                       /*!< SCT EV0_STATE: STATEMSK1 Position       */
#define SCT_EV0_STATE_STATEMSK1_Msk           (0x01UL << SCT_EV0_STATE_STATEMSK1_Pos)                 /*!< SCT EV0_STATE: STATEMSK1 Mask           */
#define SCT_EV0_STATE_STATEMSK2_Pos           2                                                       /*!< SCT EV0_STATE: STATEMSK2 Position       */
#define SCT_EV0_STATE_STATEMSK2_Msk           (0x01UL << SCT_EV0_STATE_STATEMSK2_Pos)                 /*!< SCT EV0_STATE: STATEMSK2 Mask           */
#define SCT_EV0_STATE_STATEMSK3_Pos           3                                                       /*!< SCT EV0_STATE: STATEMSK3 Position       */
#define SCT_EV0_STATE_STATEMSK3_Msk           (0x01UL << SCT_EV0_STATE_STATEMSK3_Pos)                 /*!< SCT EV0_STATE: STATEMSK3 Mask           */
#define SCT_EV0_STATE_STATEMSK4_Pos           4                                                       /*!< SCT EV0_STATE: STATEMSK4 Position       */
#define SCT_EV0_STATE_STATEMSK4_Msk           (0x01UL << SCT_EV0_STATE_STATEMSK4_Pos)                 /*!< SCT EV0_STATE: STATEMSK4 Mask           */
#define SCT_EV0_STATE_STATEMSK5_Pos           5                                                       /*!< SCT EV0_STATE: STATEMSK5 Position       */
#define SCT_EV0_STATE_STATEMSK5_Msk           (0x01UL << SCT_EV0_STATE_STATEMSK5_Pos)                 /*!< SCT EV0_STATE: STATEMSK5 Mask           */
#define SCT_EV0_STATE_STATEMSK6_Pos           6                                                       /*!< SCT EV0_STATE: STATEMSK6 Position       */
#define SCT_EV0_STATE_STATEMSK6_Msk           (0x01UL << SCT_EV0_STATE_STATEMSK6_Pos)                 /*!< SCT EV0_STATE: STATEMSK6 Mask           */
#define SCT_EV0_STATE_STATEMSK7_Pos           7                                                       /*!< SCT EV0_STATE: STATEMSK7 Position       */
#define SCT_EV0_STATE_STATEMSK7_Msk           (0x01UL << SCT_EV0_STATE_STATEMSK7_Pos)                 /*!< SCT EV0_STATE: STATEMSK7 Mask           */
#define SCT_EV0_STATE_STATEMSK8_Pos           8                                                       /*!< SCT EV0_STATE: STATEMSK8 Position       */
#define SCT_EV0_STATE_STATEMSK8_Msk           (0x01UL << SCT_EV0_STATE_STATEMSK8_Pos)                 /*!< SCT EV0_STATE: STATEMSK8 Mask           */
#define SCT_EV0_STATE_STATEMSK9_Pos           9                                                       /*!< SCT EV0_STATE: STATEMSK9 Position       */
#define SCT_EV0_STATE_STATEMSK9_Msk           (0x01UL << SCT_EV0_STATE_STATEMSK9_Pos)                 /*!< SCT EV0_STATE: STATEMSK9 Mask           */
#define SCT_EV0_STATE_STATEMSK10_Pos          10                                                      /*!< SCT EV0_STATE: STATEMSK10 Position      */
#define SCT_EV0_STATE_STATEMSK10_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK10_Pos)                /*!< SCT EV0_STATE: STATEMSK10 Mask          */
#define SCT_EV0_STATE_STATEMSK11_Pos          11                                                      /*!< SCT EV0_STATE: STATEMSK11 Position      */
#define SCT_EV0_STATE_STATEMSK11_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK11_Pos)                /*!< SCT EV0_STATE: STATEMSK11 Mask          */
#define SCT_EV0_STATE_STATEMSK12_Pos          12                                                      /*!< SCT EV0_STATE: STATEMSK12 Position      */
#define SCT_EV0_STATE_STATEMSK12_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK12_Pos)                /*!< SCT EV0_STATE: STATEMSK12 Mask          */
#define SCT_EV0_STATE_STATEMSK13_Pos          13                                                      /*!< SCT EV0_STATE: STATEMSK13 Position      */
#define SCT_EV0_STATE_STATEMSK13_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK13_Pos)                /*!< SCT EV0_STATE: STATEMSK13 Mask          */
#define SCT_EV0_STATE_STATEMSK14_Pos          14                                                      /*!< SCT EV0_STATE: STATEMSK14 Position      */
#define SCT_EV0_STATE_STATEMSK14_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK14_Pos)                /*!< SCT EV0_STATE: STATEMSK14 Mask          */
#define SCT_EV0_STATE_STATEMSK15_Pos          15                                                      /*!< SCT EV0_STATE: STATEMSK15 Position      */
#define SCT_EV0_STATE_STATEMSK15_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK15_Pos)                /*!< SCT EV0_STATE: STATEMSK15 Mask          */
#define SCT_EV0_STATE_STATEMSK16_Pos          16                                                      /*!< SCT EV0_STATE: STATEMSK16 Position      */
#define SCT_EV0_STATE_STATEMSK16_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK16_Pos)                /*!< SCT EV0_STATE: STATEMSK16 Mask          */
#define SCT_EV0_STATE_STATEMSK17_Pos          17                                                      /*!< SCT EV0_STATE: STATEMSK17 Position      */
#define SCT_EV0_STATE_STATEMSK17_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK17_Pos)                /*!< SCT EV0_STATE: STATEMSK17 Mask          */
#define SCT_EV0_STATE_STATEMSK18_Pos          18                                                      /*!< SCT EV0_STATE: STATEMSK18 Position      */
#define SCT_EV0_STATE_STATEMSK18_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK18_Pos)                /*!< SCT EV0_STATE: STATEMSK18 Mask          */
#define SCT_EV0_STATE_STATEMSK19_Pos          19                                                      /*!< SCT EV0_STATE: STATEMSK19 Position      */
#define SCT_EV0_STATE_STATEMSK19_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK19_Pos)                /*!< SCT EV0_STATE: STATEMSK19 Mask          */
#define SCT_EV0_STATE_STATEMSK20_Pos          20                                                      /*!< SCT EV0_STATE: STATEMSK20 Position      */
#define SCT_EV0_STATE_STATEMSK20_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK20_Pos)                /*!< SCT EV0_STATE: STATEMSK20 Mask          */
#define SCT_EV0_STATE_STATEMSK21_Pos          21                                                      /*!< SCT EV0_STATE: STATEMSK21 Position      */
#define SCT_EV0_STATE_STATEMSK21_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK21_Pos)                /*!< SCT EV0_STATE: STATEMSK21 Mask          */
#define SCT_EV0_STATE_STATEMSK22_Pos          22                                                      /*!< SCT EV0_STATE: STATEMSK22 Position      */
#define SCT_EV0_STATE_STATEMSK22_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK22_Pos)                /*!< SCT EV0_STATE: STATEMSK22 Mask          */
#define SCT_EV0_STATE_STATEMSK23_Pos          23                                                      /*!< SCT EV0_STATE: STATEMSK23 Position      */
#define SCT_EV0_STATE_STATEMSK23_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK23_Pos)                /*!< SCT EV0_STATE: STATEMSK23 Mask          */
#define SCT_EV0_STATE_STATEMSK24_Pos          24                                                      /*!< SCT EV0_STATE: STATEMSK24 Position      */
#define SCT_EV0_STATE_STATEMSK24_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK24_Pos)                /*!< SCT EV0_STATE: STATEMSK24 Mask          */
#define SCT_EV0_STATE_STATEMSK25_Pos          25                                                      /*!< SCT EV0_STATE: STATEMSK25 Position      */
#define SCT_EV0_STATE_STATEMSK25_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK25_Pos)                /*!< SCT EV0_STATE: STATEMSK25 Mask          */
#define SCT_EV0_STATE_STATEMSK26_Pos          26                                                      /*!< SCT EV0_STATE: STATEMSK26 Position      */
#define SCT_EV0_STATE_STATEMSK26_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK26_Pos)                /*!< SCT EV0_STATE: STATEMSK26 Mask          */
#define SCT_EV0_STATE_STATEMSK27_Pos          27                                                      /*!< SCT EV0_STATE: STATEMSK27 Position      */
#define SCT_EV0_STATE_STATEMSK27_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK27_Pos)                /*!< SCT EV0_STATE: STATEMSK27 Mask          */
#define SCT_EV0_STATE_STATEMSK28_Pos          28                                                      /*!< SCT EV0_STATE: STATEMSK28 Position      */
#define SCT_EV0_STATE_STATEMSK28_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK28_Pos)                /*!< SCT EV0_STATE: STATEMSK28 Mask          */
#define SCT_EV0_STATE_STATEMSK29_Pos          29                                                      /*!< SCT EV0_STATE: STATEMSK29 Position      */
#define SCT_EV0_STATE_STATEMSK29_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK29_Pos)                /*!< SCT EV0_STATE: STATEMSK29 Mask          */
#define SCT_EV0_STATE_STATEMSK30_Pos          30                                                      /*!< SCT EV0_STATE: STATEMSK30 Position      */
#define SCT_EV0_STATE_STATEMSK30_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK30_Pos)                /*!< SCT EV0_STATE: STATEMSK30 Mask          */
#define SCT_EV0_STATE_STATEMSK31_Pos          31                                                      /*!< SCT EV0_STATE: STATEMSK31 Position      */
#define SCT_EV0_STATE_STATEMSK31_Msk          (0x01UL << SCT_EV0_STATE_STATEMSK31_Pos)                /*!< SCT EV0_STATE: STATEMSK31 Mask          */

/* --------------------------------  SCT_EV0_CTRL  -------------------------------- */
#define SCT_EV0_CTRL_MATCHSEL_Pos             0                                                       /*!< SCT EV0_CTRL: MATCHSEL Position         */
#define SCT_EV0_CTRL_MATCHSEL_Msk             (0x0fUL << SCT_EV0_CTRL_MATCHSEL_Pos)                   /*!< SCT EV0_CTRL: MATCHSEL Mask             */
#define SCT_EV0_CTRL_HEVENT_Pos               4                                                       /*!< SCT EV0_CTRL: HEVENT Position           */
#define SCT_EV0_CTRL_HEVENT_Msk               (0x01UL << SCT_EV0_CTRL_HEVENT_Pos)                     /*!< SCT EV0_CTRL: HEVENT Mask               */
#define SCT_EV0_CTRL_OUTSEL_Pos               5                                                       /*!< SCT EV0_CTRL: OUTSEL Position           */
#define SCT_EV0_CTRL_OUTSEL_Msk               (0x01UL << SCT_EV0_CTRL_OUTSEL_Pos)                     /*!< SCT EV0_CTRL: OUTSEL Mask               */
#define SCT_EV0_CTRL_IOSEL_Pos                6                                                       /*!< SCT EV0_CTRL: IOSEL Position            */
#define SCT_EV0_CTRL_IOSEL_Msk                (0x0fUL << SCT_EV0_CTRL_IOSEL_Pos)                      /*!< SCT EV0_CTRL: IOSEL Mask                */
#define SCT_EV0_CTRL_IOCOND_Pos               10                                                      /*!< SCT EV0_CTRL: IOCOND Position           */
#define SCT_EV0_CTRL_IOCOND_Msk               (0x03UL << SCT_EV0_CTRL_IOCOND_Pos)                     /*!< SCT EV0_CTRL: IOCOND Mask               */
#define SCT_EV0_CTRL_COMBMODE_Pos             12                                                      /*!< SCT EV0_CTRL: COMBMODE Position         */
#define SCT_EV0_CTRL_COMBMODE_Msk             (0x03UL << SCT_EV0_CTRL_COMBMODE_Pos)                   /*!< SCT EV0_CTRL: COMBMODE Mask             */
#define SCT_EV0_CTRL_STATELD_Pos              14                                                      /*!< SCT EV0_CTRL: STATELD Position          */
#define SCT_EV0_CTRL_STATELD_Msk              (0x01UL << SCT_EV0_CTRL_STATELD_Pos)                    /*!< SCT EV0_CTRL: STATELD Mask              */
#define SCT_EV0_CTRL_STATEV_Pos               15                                                      /*!< SCT EV0_CTRL: STATEV Position           */
#define SCT_EV0_CTRL_STATEV_Msk               (0x1fUL << SCT_EV0_CTRL_STATEV_Pos)                     /*!< SCT EV0_CTRL: STATEV Mask               */
#define SCT_EV0_CTRL_MATCHMEM_Pos             20                                                      /*!< SCT EV0_CTRL: MATCHMEM Position         */
#define SCT_EV0_CTRL_MATCHMEM_Msk             (0x01UL << SCT_EV0_CTRL_MATCHMEM_Pos)                   /*!< SCT EV0_CTRL: MATCHMEM Mask             */
#define SCT_EV0_CTRL_DIRECTION_Pos            21                                                      /*!< SCT EV0_CTRL: DIRECTION Position        */
#define SCT_EV0_CTRL_DIRECTION_Msk            (0x03UL << SCT_EV0_CTRL_DIRECTION_Pos)                  /*!< SCT EV0_CTRL: DIRECTION Mask            */

/* --------------------------------  SCT_EV1_STATE  ------------------------------- */
#define SCT_EV1_STATE_STATEMSK0_Pos           0                                                       /*!< SCT EV1_STATE: STATEMSK0 Position       */
#define SCT_EV1_STATE_STATEMSK0_Msk           (0x01UL << SCT_EV1_STATE_STATEMSK0_Pos)                 /*!< SCT EV1_STATE: STATEMSK0 Mask           */
#define SCT_EV1_STATE_STATEMSK1_Pos           1                                                       /*!< SCT EV1_STATE: STATEMSK1 Position       */
#define SCT_EV1_STATE_STATEMSK1_Msk           (0x01UL << SCT_EV1_STATE_STATEMSK1_Pos)                 /*!< SCT EV1_STATE: STATEMSK1 Mask           */
#define SCT_EV1_STATE_STATEMSK2_Pos           2                                                       /*!< SCT EV1_STATE: STATEMSK2 Position       */
#define SCT_EV1_STATE_STATEMSK2_Msk           (0x01UL << SCT_EV1_STATE_STATEMSK2_Pos)                 /*!< SCT EV1_STATE: STATEMSK2 Mask           */
#define SCT_EV1_STATE_STATEMSK3_Pos           3                                                       /*!< SCT EV1_STATE: STATEMSK3 Position       */
#define SCT_EV1_STATE_STATEMSK3_Msk           (0x01UL << SCT_EV1_STATE_STATEMSK3_Pos)                 /*!< SCT EV1_STATE: STATEMSK3 Mask           */
#define SCT_EV1_STATE_STATEMSK4_Pos           4                                                       /*!< SCT EV1_STATE: STATEMSK4 Position       */
#define SCT_EV1_STATE_STATEMSK4_Msk           (0x01UL << SCT_EV1_STATE_STATEMSK4_Pos)                 /*!< SCT EV1_STATE: STATEMSK4 Mask           */
#define SCT_EV1_STATE_STATEMSK5_Pos           5                                                       /*!< SCT EV1_STATE: STATEMSK5 Position       */
#define SCT_EV1_STATE_STATEMSK5_Msk           (0x01UL << SCT_EV1_STATE_STATEMSK5_Pos)                 /*!< SCT EV1_STATE: STATEMSK5 Mask           */
#define SCT_EV1_STATE_STATEMSK6_Pos           6                                                       /*!< SCT EV1_STATE: STATEMSK6 Position       */
#define SCT_EV1_STATE_STATEMSK6_Msk           (0x01UL << SCT_EV1_STATE_STATEMSK6_Pos)                 /*!< SCT EV1_STATE: STATEMSK6 Mask           */
#define SCT_EV1_STATE_STATEMSK7_Pos           7                                                       /*!< SCT EV1_STATE: STATEMSK7 Position       */
#define SCT_EV1_STATE_STATEMSK7_Msk           (0x01UL << SCT_EV1_STATE_STATEMSK7_Pos)                 /*!< SCT EV1_STATE: STATEMSK7 Mask           */
#define SCT_EV1_STATE_STATEMSK8_Pos           8                                                       /*!< SCT EV1_STATE: STATEMSK8 Position       */
#define SCT_EV1_STATE_STATEMSK8_Msk           (0x01UL << SCT_EV1_STATE_STATEMSK8_Pos)                 /*!< SCT EV1_STATE: STATEMSK8 Mask           */
#define SCT_EV1_STATE_STATEMSK9_Pos           9                                                       /*!< SCT EV1_STATE: STATEMSK9 Position       */
#define SCT_EV1_STATE_STATEMSK9_Msk           (0x01UL << SCT_EV1_STATE_STATEMSK9_Pos)                 /*!< SCT EV1_STATE: STATEMSK9 Mask           */
#define SCT_EV1_STATE_STATEMSK10_Pos          10                                                      /*!< SCT EV1_STATE: STATEMSK10 Position      */
#define SCT_EV1_STATE_STATEMSK10_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK10_Pos)                /*!< SCT EV1_STATE: STATEMSK10 Mask          */
#define SCT_EV1_STATE_STATEMSK11_Pos          11                                                      /*!< SCT EV1_STATE: STATEMSK11 Position      */
#define SCT_EV1_STATE_STATEMSK11_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK11_Pos)                /*!< SCT EV1_STATE: STATEMSK11 Mask          */
#define SCT_EV1_STATE_STATEMSK12_Pos          12                                                      /*!< SCT EV1_STATE: STATEMSK12 Position      */
#define SCT_EV1_STATE_STATEMSK12_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK12_Pos)                /*!< SCT EV1_STATE: STATEMSK12 Mask          */
#define SCT_EV1_STATE_STATEMSK13_Pos          13                                                      /*!< SCT EV1_STATE: STATEMSK13 Position      */
#define SCT_EV1_STATE_STATEMSK13_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK13_Pos)                /*!< SCT EV1_STATE: STATEMSK13 Mask          */
#define SCT_EV1_STATE_STATEMSK14_Pos          14                                                      /*!< SCT EV1_STATE: STATEMSK14 Position      */
#define SCT_EV1_STATE_STATEMSK14_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK14_Pos)                /*!< SCT EV1_STATE: STATEMSK14 Mask          */
#define SCT_EV1_STATE_STATEMSK15_Pos          15                                                      /*!< SCT EV1_STATE: STATEMSK15 Position      */
#define SCT_EV1_STATE_STATEMSK15_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK15_Pos)                /*!< SCT EV1_STATE: STATEMSK15 Mask          */
#define SCT_EV1_STATE_STATEMSK16_Pos          16                                                      /*!< SCT EV1_STATE: STATEMSK16 Position      */
#define SCT_EV1_STATE_STATEMSK16_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK16_Pos)                /*!< SCT EV1_STATE: STATEMSK16 Mask          */
#define SCT_EV1_STATE_STATEMSK17_Pos          17                                                      /*!< SCT EV1_STATE: STATEMSK17 Position      */
#define SCT_EV1_STATE_STATEMSK17_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK17_Pos)                /*!< SCT EV1_STATE: STATEMSK17 Mask          */
#define SCT_EV1_STATE_STATEMSK18_Pos          18                                                      /*!< SCT EV1_STATE: STATEMSK18 Position      */
#define SCT_EV1_STATE_STATEMSK18_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK18_Pos)                /*!< SCT EV1_STATE: STATEMSK18 Mask          */
#define SCT_EV1_STATE_STATEMSK19_Pos          19                                                      /*!< SCT EV1_STATE: STATEMSK19 Position      */
#define SCT_EV1_STATE_STATEMSK19_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK19_Pos)                /*!< SCT EV1_STATE: STATEMSK19 Mask          */
#define SCT_EV1_STATE_STATEMSK20_Pos          20                                                      /*!< SCT EV1_STATE: STATEMSK20 Position      */
#define SCT_EV1_STATE_STATEMSK20_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK20_Pos)                /*!< SCT EV1_STATE: STATEMSK20 Mask          */
#define SCT_EV1_STATE_STATEMSK21_Pos          21                                                      /*!< SCT EV1_STATE: STATEMSK21 Position      */
#define SCT_EV1_STATE_STATEMSK21_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK21_Pos)                /*!< SCT EV1_STATE: STATEMSK21 Mask          */
#define SCT_EV1_STATE_STATEMSK22_Pos          22                                                      /*!< SCT EV1_STATE: STATEMSK22 Position      */
#define SCT_EV1_STATE_STATEMSK22_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK22_Pos)                /*!< SCT EV1_STATE: STATEMSK22 Mask          */
#define SCT_EV1_STATE_STATEMSK23_Pos          23                                                      /*!< SCT EV1_STATE: STATEMSK23 Position      */
#define SCT_EV1_STATE_STATEMSK23_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK23_Pos)                /*!< SCT EV1_STATE: STATEMSK23 Mask          */
#define SCT_EV1_STATE_STATEMSK24_Pos          24                                                      /*!< SCT EV1_STATE: STATEMSK24 Position      */
#define SCT_EV1_STATE_STATEMSK24_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK24_Pos)                /*!< SCT EV1_STATE: STATEMSK24 Mask          */
#define SCT_EV1_STATE_STATEMSK25_Pos          25                                                      /*!< SCT EV1_STATE: STATEMSK25 Position      */
#define SCT_EV1_STATE_STATEMSK25_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK25_Pos)                /*!< SCT EV1_STATE: STATEMSK25 Mask          */
#define SCT_EV1_STATE_STATEMSK26_Pos          26                                                      /*!< SCT EV1_STATE: STATEMSK26 Position      */
#define SCT_EV1_STATE_STATEMSK26_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK26_Pos)                /*!< SCT EV1_STATE: STATEMSK26 Mask          */
#define SCT_EV1_STATE_STATEMSK27_Pos          27                                                      /*!< SCT EV1_STATE: STATEMSK27 Position      */
#define SCT_EV1_STATE_STATEMSK27_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK27_Pos)                /*!< SCT EV1_STATE: STATEMSK27 Mask          */
#define SCT_EV1_STATE_STATEMSK28_Pos          28                                                      /*!< SCT EV1_STATE: STATEMSK28 Position      */
#define SCT_EV1_STATE_STATEMSK28_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK28_Pos)                /*!< SCT EV1_STATE: STATEMSK28 Mask          */
#define SCT_EV1_STATE_STATEMSK29_Pos          29                                                      /*!< SCT EV1_STATE: STATEMSK29 Position      */
#define SCT_EV1_STATE_STATEMSK29_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK29_Pos)                /*!< SCT EV1_STATE: STATEMSK29 Mask          */
#define SCT_EV1_STATE_STATEMSK30_Pos          30                                                      /*!< SCT EV1_STATE: STATEMSK30 Position      */
#define SCT_EV1_STATE_STATEMSK30_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK30_Pos)                /*!< SCT EV1_STATE: STATEMSK30 Mask          */
#define SCT_EV1_STATE_STATEMSK31_Pos          31                                                      /*!< SCT EV1_STATE: STATEMSK31 Position      */
#define SCT_EV1_STATE_STATEMSK31_Msk          (0x01UL << SCT_EV1_STATE_STATEMSK31_Pos)                /*!< SCT EV1_STATE: STATEMSK31 Mask          */

/* --------------------------------  SCT_EV1_CTRL  -------------------------------- */
#define SCT_EV1_CTRL_MATCHSEL_Pos             0                                                       /*!< SCT EV1_CTRL: MATCHSEL Position         */
#define SCT_EV1_CTRL_MATCHSEL_Msk             (0x0fUL << SCT_EV1_CTRL_MATCHSEL_Pos)                   /*!< SCT EV1_CTRL: MATCHSEL Mask             */
#define SCT_EV1_CTRL_HEVENT_Pos               4                                                       /*!< SCT EV1_CTRL: HEVENT Position           */
#define SCT_EV1_CTRL_HEVENT_Msk               (0x01UL << SCT_EV1_CTRL_HEVENT_Pos)                     /*!< SCT EV1_CTRL: HEVENT Mask               */
#define SCT_EV1_CTRL_OUTSEL_Pos               5                                                       /*!< SCT EV1_CTRL: OUTSEL Position           */
#define SCT_EV1_CTRL_OUTSEL_Msk               (0x01UL << SCT_EV1_CTRL_OUTSEL_Pos)                     /*!< SCT EV1_CTRL: OUTSEL Mask               */
#define SCT_EV1_CTRL_IOSEL_Pos                6                                                       /*!< SCT EV1_CTRL: IOSEL Position            */
#define SCT_EV1_CTRL_IOSEL_Msk                (0x0fUL << SCT_EV1_CTRL_IOSEL_Pos)                      /*!< SCT EV1_CTRL: IOSEL Mask                */
#define SCT_EV1_CTRL_IOCOND_Pos               10                                                      /*!< SCT EV1_CTRL: IOCOND Position           */
#define SCT_EV1_CTRL_IOCOND_Msk               (0x03UL << SCT_EV1_CTRL_IOCOND_Pos)                     /*!< SCT EV1_CTRL: IOCOND Mask               */
#define SCT_EV1_CTRL_COMBMODE_Pos             12                                                      /*!< SCT EV1_CTRL: COMBMODE Position         */
#define SCT_EV1_CTRL_COMBMODE_Msk             (0x03UL << SCT_EV1_CTRL_COMBMODE_Pos)                   /*!< SCT EV1_CTRL: COMBMODE Mask             */
#define SCT_EV1_CTRL_STATELD_Pos              14                                                      /*!< SCT EV1_CTRL: STATELD Position          */
#define SCT_EV1_CTRL_STATELD_Msk              (0x01UL << SCT_EV1_CTRL_STATELD_Pos)                    /*!< SCT EV1_CTRL: STATELD Mask              */
#define SCT_EV1_CTRL_STATEV_Pos               15                                                      /*!< SCT EV1_CTRL: STATEV Position           */
#define SCT_EV1_CTRL_STATEV_Msk               (0x1fUL << SCT_EV1_CTRL_STATEV_Pos)                     /*!< SCT EV1_CTRL: STATEV Mask               */
#define SCT_EV1_CTRL_MATCHMEM_Pos             20                                                      /*!< SCT EV1_CTRL: MATCHMEM Position         */
#define SCT_EV1_CTRL_MATCHMEM_Msk             (0x01UL << SCT_EV1_CTRL_MATCHMEM_Pos)                   /*!< SCT EV1_CTRL: MATCHMEM Mask             */
#define SCT_EV1_CTRL_DIRECTION_Pos            21                                                      /*!< SCT EV1_CTRL: DIRECTION Position        */
#define SCT_EV1_CTRL_DIRECTION_Msk            (0x03UL << SCT_EV1_CTRL_DIRECTION_Pos)                  /*!< SCT EV1_CTRL: DIRECTION Mask            */

/* --------------------------------  SCT_EV2_STATE  ------------------------------- */
#define SCT_EV2_STATE_STATEMSK0_Pos           0                                                       /*!< SCT EV2_STATE: STATEMSK0 Position       */
#define SCT_EV2_STATE_STATEMSK0_Msk           (0x01UL << SCT_EV2_STATE_STATEMSK0_Pos)                 /*!< SCT EV2_STATE: STATEMSK0 Mask           */
#define SCT_EV2_STATE_STATEMSK1_Pos           1                                                       /*!< SCT EV2_STATE: STATEMSK1 Position       */
#define SCT_EV2_STATE_STATEMSK1_Msk           (0x01UL << SCT_EV2_STATE_STATEMSK1_Pos)                 /*!< SCT EV2_STATE: STATEMSK1 Mask           */
#define SCT_EV2_STATE_STATEMSK2_Pos           2                                                       /*!< SCT EV2_STATE: STATEMSK2 Position       */
#define SCT_EV2_STATE_STATEMSK2_Msk           (0x01UL << SCT_EV2_STATE_STATEMSK2_Pos)                 /*!< SCT EV2_STATE: STATEMSK2 Mask           */
#define SCT_EV2_STATE_STATEMSK3_Pos           3                                                       /*!< SCT EV2_STATE: STATEMSK3 Position       */
#define SCT_EV2_STATE_STATEMSK3_Msk           (0x01UL << SCT_EV2_STATE_STATEMSK3_Pos)                 /*!< SCT EV2_STATE: STATEMSK3 Mask           */
#define SCT_EV2_STATE_STATEMSK4_Pos           4                                                       /*!< SCT EV2_STATE: STATEMSK4 Position       */
#define SCT_EV2_STATE_STATEMSK4_Msk           (0x01UL << SCT_EV2_STATE_STATEMSK4_Pos)                 /*!< SCT EV2_STATE: STATEMSK4 Mask           */
#define SCT_EV2_STATE_STATEMSK5_Pos           5                                                       /*!< SCT EV2_STATE: STATEMSK5 Position       */
#define SCT_EV2_STATE_STATEMSK5_Msk           (0x01UL << SCT_EV2_STATE_STATEMSK5_Pos)                 /*!< SCT EV2_STATE: STATEMSK5 Mask           */
#define SCT_EV2_STATE_STATEMSK6_Pos           6                                                       /*!< SCT EV2_STATE: STATEMSK6 Position       */
#define SCT_EV2_STATE_STATEMSK6_Msk           (0x01UL << SCT_EV2_STATE_STATEMSK6_Pos)                 /*!< SCT EV2_STATE: STATEMSK6 Mask           */
#define SCT_EV2_STATE_STATEMSK7_Pos           7                                                       /*!< SCT EV2_STATE: STATEMSK7 Position       */
#define SCT_EV2_STATE_STATEMSK7_Msk           (0x01UL << SCT_EV2_STATE_STATEMSK7_Pos)                 /*!< SCT EV2_STATE: STATEMSK7 Mask           */
#define SCT_EV2_STATE_STATEMSK8_Pos           8                                                       /*!< SCT EV2_STATE: STATEMSK8 Position       */
#define SCT_EV2_STATE_STATEMSK8_Msk           (0x01UL << SCT_EV2_STATE_STATEMSK8_Pos)                 /*!< SCT EV2_STATE: STATEMSK8 Mask           */
#define SCT_EV2_STATE_STATEMSK9_Pos           9                                                       /*!< SCT EV2_STATE: STATEMSK9 Position       */
#define SCT_EV2_STATE_STATEMSK9_Msk           (0x01UL << SCT_EV2_STATE_STATEMSK9_Pos)                 /*!< SCT EV2_STATE: STATEMSK9 Mask           */
#define SCT_EV2_STATE_STATEMSK10_Pos          10                                                      /*!< SCT EV2_STATE: STATEMSK10 Position      */
#define SCT_EV2_STATE_STATEMSK10_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK10_Pos)                /*!< SCT EV2_STATE: STATEMSK10 Mask          */
#define SCT_EV2_STATE_STATEMSK11_Pos          11                                                      /*!< SCT EV2_STATE: STATEMSK11 Position      */
#define SCT_EV2_STATE_STATEMSK11_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK11_Pos)                /*!< SCT EV2_STATE: STATEMSK11 Mask          */
#define SCT_EV2_STATE_STATEMSK12_Pos          12                                                      /*!< SCT EV2_STATE: STATEMSK12 Position      */
#define SCT_EV2_STATE_STATEMSK12_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK12_Pos)                /*!< SCT EV2_STATE: STATEMSK12 Mask          */
#define SCT_EV2_STATE_STATEMSK13_Pos          13                                                      /*!< SCT EV2_STATE: STATEMSK13 Position      */
#define SCT_EV2_STATE_STATEMSK13_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK13_Pos)                /*!< SCT EV2_STATE: STATEMSK13 Mask          */
#define SCT_EV2_STATE_STATEMSK14_Pos          14                                                      /*!< SCT EV2_STATE: STATEMSK14 Position      */
#define SCT_EV2_STATE_STATEMSK14_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK14_Pos)                /*!< SCT EV2_STATE: STATEMSK14 Mask          */
#define SCT_EV2_STATE_STATEMSK15_Pos          15                                                      /*!< SCT EV2_STATE: STATEMSK15 Position      */
#define SCT_EV2_STATE_STATEMSK15_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK15_Pos)                /*!< SCT EV2_STATE: STATEMSK15 Mask          */
#define SCT_EV2_STATE_STATEMSK16_Pos          16                                                      /*!< SCT EV2_STATE: STATEMSK16 Position      */
#define SCT_EV2_STATE_STATEMSK16_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK16_Pos)                /*!< SCT EV2_STATE: STATEMSK16 Mask          */
#define SCT_EV2_STATE_STATEMSK17_Pos          17                                                      /*!< SCT EV2_STATE: STATEMSK17 Position      */
#define SCT_EV2_STATE_STATEMSK17_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK17_Pos)                /*!< SCT EV2_STATE: STATEMSK17 Mask          */
#define SCT_EV2_STATE_STATEMSK18_Pos          18                                                      /*!< SCT EV2_STATE: STATEMSK18 Position      */
#define SCT_EV2_STATE_STATEMSK18_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK18_Pos)                /*!< SCT EV2_STATE: STATEMSK18 Mask          */
#define SCT_EV2_STATE_STATEMSK19_Pos          19                                                      /*!< SCT EV2_STATE: STATEMSK19 Position      */
#define SCT_EV2_STATE_STATEMSK19_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK19_Pos)                /*!< SCT EV2_STATE: STATEMSK19 Mask          */
#define SCT_EV2_STATE_STATEMSK20_Pos          20                                                      /*!< SCT EV2_STATE: STATEMSK20 Position      */
#define SCT_EV2_STATE_STATEMSK20_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK20_Pos)                /*!< SCT EV2_STATE: STATEMSK20 Mask          */
#define SCT_EV2_STATE_STATEMSK21_Pos          21                                                      /*!< SCT EV2_STATE: STATEMSK21 Position      */
#define SCT_EV2_STATE_STATEMSK21_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK21_Pos)                /*!< SCT EV2_STATE: STATEMSK21 Mask          */
#define SCT_EV2_STATE_STATEMSK22_Pos          22                                                      /*!< SCT EV2_STATE: STATEMSK22 Position      */
#define SCT_EV2_STATE_STATEMSK22_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK22_Pos)                /*!< SCT EV2_STATE: STATEMSK22 Mask          */
#define SCT_EV2_STATE_STATEMSK23_Pos          23                                                      /*!< SCT EV2_STATE: STATEMSK23 Position      */
#define SCT_EV2_STATE_STATEMSK23_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK23_Pos)                /*!< SCT EV2_STATE: STATEMSK23 Mask          */
#define SCT_EV2_STATE_STATEMSK24_Pos          24                                                      /*!< SCT EV2_STATE: STATEMSK24 Position      */
#define SCT_EV2_STATE_STATEMSK24_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK24_Pos)                /*!< SCT EV2_STATE: STATEMSK24 Mask          */
#define SCT_EV2_STATE_STATEMSK25_Pos          25                                                      /*!< SCT EV2_STATE: STATEMSK25 Position      */
#define SCT_EV2_STATE_STATEMSK25_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK25_Pos)                /*!< SCT EV2_STATE: STATEMSK25 Mask          */
#define SCT_EV2_STATE_STATEMSK26_Pos          26                                                      /*!< SCT EV2_STATE: STATEMSK26 Position      */
#define SCT_EV2_STATE_STATEMSK26_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK26_Pos)                /*!< SCT EV2_STATE: STATEMSK26 Mask          */
#define SCT_EV2_STATE_STATEMSK27_Pos          27                                                      /*!< SCT EV2_STATE: STATEMSK27 Position      */
#define SCT_EV2_STATE_STATEMSK27_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK27_Pos)                /*!< SCT EV2_STATE: STATEMSK27 Mask          */
#define SCT_EV2_STATE_STATEMSK28_Pos          28                                                      /*!< SCT EV2_STATE: STATEMSK28 Position      */
#define SCT_EV2_STATE_STATEMSK28_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK28_Pos)                /*!< SCT EV2_STATE: STATEMSK28 Mask          */
#define SCT_EV2_STATE_STATEMSK29_Pos          29                                                      /*!< SCT EV2_STATE: STATEMSK29 Position      */
#define SCT_EV2_STATE_STATEMSK29_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK29_Pos)                /*!< SCT EV2_STATE: STATEMSK29 Mask          */
#define SCT_EV2_STATE_STATEMSK30_Pos          30                                                      /*!< SCT EV2_STATE: STATEMSK30 Position      */
#define SCT_EV2_STATE_STATEMSK30_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK30_Pos)                /*!< SCT EV2_STATE: STATEMSK30 Mask          */
#define SCT_EV2_STATE_STATEMSK31_Pos          31                                                      /*!< SCT EV2_STATE: STATEMSK31 Position      */
#define SCT_EV2_STATE_STATEMSK31_Msk          (0x01UL << SCT_EV2_STATE_STATEMSK31_Pos)                /*!< SCT EV2_STATE: STATEMSK31 Mask          */

/* --------------------------------  SCT_EV2_CTRL  -------------------------------- */
#define SCT_EV2_CTRL_MATCHSEL_Pos             0                                                       /*!< SCT EV2_CTRL: MATCHSEL Position         */
#define SCT_EV2_CTRL_MATCHSEL_Msk             (0x0fUL << SCT_EV2_CTRL_MATCHSEL_Pos)                   /*!< SCT EV2_CTRL: MATCHSEL Mask             */
#define SCT_EV2_CTRL_HEVENT_Pos               4                                                       /*!< SCT EV2_CTRL: HEVENT Position           */
#define SCT_EV2_CTRL_HEVENT_Msk               (0x01UL << SCT_EV2_CTRL_HEVENT_Pos)                     /*!< SCT EV2_CTRL: HEVENT Mask               */
#define SCT_EV2_CTRL_OUTSEL_Pos               5                                                       /*!< SCT EV2_CTRL: OUTSEL Position           */
#define SCT_EV2_CTRL_OUTSEL_Msk               (0x01UL << SCT_EV2_CTRL_OUTSEL_Pos)                     /*!< SCT EV2_CTRL: OUTSEL Mask               */
#define SCT_EV2_CTRL_IOSEL_Pos                6                                                       /*!< SCT EV2_CTRL: IOSEL Position            */
#define SCT_EV2_CTRL_IOSEL_Msk                (0x0fUL << SCT_EV2_CTRL_IOSEL_Pos)                      /*!< SCT EV2_CTRL: IOSEL Mask                */
#define SCT_EV2_CTRL_IOCOND_Pos               10                                                      /*!< SCT EV2_CTRL: IOCOND Position           */
#define SCT_EV2_CTRL_IOCOND_Msk               (0x03UL << SCT_EV2_CTRL_IOCOND_Pos)                     /*!< SCT EV2_CTRL: IOCOND Mask               */
#define SCT_EV2_CTRL_COMBMODE_Pos             12                                                      /*!< SCT EV2_CTRL: COMBMODE Position         */
#define SCT_EV2_CTRL_COMBMODE_Msk             (0x03UL << SCT_EV2_CTRL_COMBMODE_Pos)                   /*!< SCT EV2_CTRL: COMBMODE Mask             */
#define SCT_EV2_CTRL_STATELD_Pos              14                                                      /*!< SCT EV2_CTRL: STATELD Position          */
#define SCT_EV2_CTRL_STATELD_Msk              (0x01UL << SCT_EV2_CTRL_STATELD_Pos)                    /*!< SCT EV2_CTRL: STATELD Mask              */
#define SCT_EV2_CTRL_STATEV_Pos               15                                                      /*!< SCT EV2_CTRL: STATEV Position           */
#define SCT_EV2_CTRL_STATEV_Msk               (0x1fUL << SCT_EV2_CTRL_STATEV_Pos)                     /*!< SCT EV2_CTRL: STATEV Mask               */
#define SCT_EV2_CTRL_MATCHMEM_Pos             20                                                      /*!< SCT EV2_CTRL: MATCHMEM Position         */
#define SCT_EV2_CTRL_MATCHMEM_Msk             (0x01UL << SCT_EV2_CTRL_MATCHMEM_Pos)                   /*!< SCT EV2_CTRL: MATCHMEM Mask             */
#define SCT_EV2_CTRL_DIRECTION_Pos            21                                                      /*!< SCT EV2_CTRL: DIRECTION Position        */
#define SCT_EV2_CTRL_DIRECTION_Msk            (0x03UL << SCT_EV2_CTRL_DIRECTION_Pos)                  /*!< SCT EV2_CTRL: DIRECTION Mask            */

/* --------------------------------  SCT_EV3_STATE  ------------------------------- */
#define SCT_EV3_STATE_STATEMSK0_Pos           0                                                       /*!< SCT EV3_STATE: STATEMSK0 Position       */
#define SCT_EV3_STATE_STATEMSK0_Msk           (0x01UL << SCT_EV3_STATE_STATEMSK0_Pos)                 /*!< SCT EV3_STATE: STATEMSK0 Mask           */
#define SCT_EV3_STATE_STATEMSK1_Pos           1                                                       /*!< SCT EV3_STATE: STATEMSK1 Position       */
#define SCT_EV3_STATE_STATEMSK1_Msk           (0x01UL << SCT_EV3_STATE_STATEMSK1_Pos)                 /*!< SCT EV3_STATE: STATEMSK1 Mask           */
#define SCT_EV3_STATE_STATEMSK2_Pos           2                                                       /*!< SCT EV3_STATE: STATEMSK2 Position       */
#define SCT_EV3_STATE_STATEMSK2_Msk           (0x01UL << SCT_EV3_STATE_STATEMSK2_Pos)                 /*!< SCT EV3_STATE: STATEMSK2 Mask           */
#define SCT_EV3_STATE_STATEMSK3_Pos           3                                                       /*!< SCT EV3_STATE: STATEMSK3 Position       */
#define SCT_EV3_STATE_STATEMSK3_Msk           (0x01UL << SCT_EV3_STATE_STATEMSK3_Pos)                 /*!< SCT EV3_STATE: STATEMSK3 Mask           */
#define SCT_EV3_STATE_STATEMSK4_Pos           4                                                       /*!< SCT EV3_STATE: STATEMSK4 Position       */
#define SCT_EV3_STATE_STATEMSK4_Msk           (0x01UL << SCT_EV3_STATE_STATEMSK4_Pos)                 /*!< SCT EV3_STATE: STATEMSK4 Mask           */
#define SCT_EV3_STATE_STATEMSK5_Pos           5                                                       /*!< SCT EV3_STATE: STATEMSK5 Position       */
#define SCT_EV3_STATE_STATEMSK5_Msk           (0x01UL << SCT_EV3_STATE_STATEMSK5_Pos)                 /*!< SCT EV3_STATE: STATEMSK5 Mask           */
#define SCT_EV3_STATE_STATEMSK6_Pos           6                                                       /*!< SCT EV3_STATE: STATEMSK6 Position       */
#define SCT_EV3_STATE_STATEMSK6_Msk           (0x01UL << SCT_EV3_STATE_STATEMSK6_Pos)                 /*!< SCT EV3_STATE: STATEMSK6 Mask           */
#define SCT_EV3_STATE_STATEMSK7_Pos           7                                                       /*!< SCT EV3_STATE: STATEMSK7 Position       */
#define SCT_EV3_STATE_STATEMSK7_Msk           (0x01UL << SCT_EV3_STATE_STATEMSK7_Pos)                 /*!< SCT EV3_STATE: STATEMSK7 Mask           */
#define SCT_EV3_STATE_STATEMSK8_Pos           8                                                       /*!< SCT EV3_STATE: STATEMSK8 Position       */
#define SCT_EV3_STATE_STATEMSK8_Msk           (0x01UL << SCT_EV3_STATE_STATEMSK8_Pos)                 /*!< SCT EV3_STATE: STATEMSK8 Mask           */
#define SCT_EV3_STATE_STATEMSK9_Pos           9                                                       /*!< SCT EV3_STATE: STATEMSK9 Position       */
#define SCT_EV3_STATE_STATEMSK9_Msk           (0x01UL << SCT_EV3_STATE_STATEMSK9_Pos)                 /*!< SCT EV3_STATE: STATEMSK9 Mask           */
#define SCT_EV3_STATE_STATEMSK10_Pos          10                                                      /*!< SCT EV3_STATE: STATEMSK10 Position      */
#define SCT_EV3_STATE_STATEMSK10_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK10_Pos)                /*!< SCT EV3_STATE: STATEMSK10 Mask          */
#define SCT_EV3_STATE_STATEMSK11_Pos          11                                                      /*!< SCT EV3_STATE: STATEMSK11 Position      */
#define SCT_EV3_STATE_STATEMSK11_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK11_Pos)                /*!< SCT EV3_STATE: STATEMSK11 Mask          */
#define SCT_EV3_STATE_STATEMSK12_Pos          12                                                      /*!< SCT EV3_STATE: STATEMSK12 Position      */
#define SCT_EV3_STATE_STATEMSK12_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK12_Pos)                /*!< SCT EV3_STATE: STATEMSK12 Mask          */
#define SCT_EV3_STATE_STATEMSK13_Pos          13                                                      /*!< SCT EV3_STATE: STATEMSK13 Position      */
#define SCT_EV3_STATE_STATEMSK13_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK13_Pos)                /*!< SCT EV3_STATE: STATEMSK13 Mask          */
#define SCT_EV3_STATE_STATEMSK14_Pos          14                                                      /*!< SCT EV3_STATE: STATEMSK14 Position      */
#define SCT_EV3_STATE_STATEMSK14_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK14_Pos)                /*!< SCT EV3_STATE: STATEMSK14 Mask          */
#define SCT_EV3_STATE_STATEMSK15_Pos          15                                                      /*!< SCT EV3_STATE: STATEMSK15 Position      */
#define SCT_EV3_STATE_STATEMSK15_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK15_Pos)                /*!< SCT EV3_STATE: STATEMSK15 Mask          */
#define SCT_EV3_STATE_STATEMSK16_Pos          16                                                      /*!< SCT EV3_STATE: STATEMSK16 Position      */
#define SCT_EV3_STATE_STATEMSK16_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK16_Pos)                /*!< SCT EV3_STATE: STATEMSK16 Mask          */
#define SCT_EV3_STATE_STATEMSK17_Pos          17                                                      /*!< SCT EV3_STATE: STATEMSK17 Position      */
#define SCT_EV3_STATE_STATEMSK17_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK17_Pos)                /*!< SCT EV3_STATE: STATEMSK17 Mask          */
#define SCT_EV3_STATE_STATEMSK18_Pos          18                                                      /*!< SCT EV3_STATE: STATEMSK18 Position      */
#define SCT_EV3_STATE_STATEMSK18_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK18_Pos)                /*!< SCT EV3_STATE: STATEMSK18 Mask          */
#define SCT_EV3_STATE_STATEMSK19_Pos          19                                                      /*!< SCT EV3_STATE: STATEMSK19 Position      */
#define SCT_EV3_STATE_STATEMSK19_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK19_Pos)                /*!< SCT EV3_STATE: STATEMSK19 Mask          */
#define SCT_EV3_STATE_STATEMSK20_Pos          20                                                      /*!< SCT EV3_STATE: STATEMSK20 Position      */
#define SCT_EV3_STATE_STATEMSK20_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK20_Pos)                /*!< SCT EV3_STATE: STATEMSK20 Mask          */
#define SCT_EV3_STATE_STATEMSK21_Pos          21                                                      /*!< SCT EV3_STATE: STATEMSK21 Position      */
#define SCT_EV3_STATE_STATEMSK21_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK21_Pos)                /*!< SCT EV3_STATE: STATEMSK21 Mask          */
#define SCT_EV3_STATE_STATEMSK22_Pos          22                                                      /*!< SCT EV3_STATE: STATEMSK22 Position      */
#define SCT_EV3_STATE_STATEMSK22_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK22_Pos)                /*!< SCT EV3_STATE: STATEMSK22 Mask          */
#define SCT_EV3_STATE_STATEMSK23_Pos          23                                                      /*!< SCT EV3_STATE: STATEMSK23 Position      */
#define SCT_EV3_STATE_STATEMSK23_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK23_Pos)                /*!< SCT EV3_STATE: STATEMSK23 Mask          */
#define SCT_EV3_STATE_STATEMSK24_Pos          24                                                      /*!< SCT EV3_STATE: STATEMSK24 Position      */
#define SCT_EV3_STATE_STATEMSK24_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK24_Pos)                /*!< SCT EV3_STATE: STATEMSK24 Mask          */
#define SCT_EV3_STATE_STATEMSK25_Pos          25                                                      /*!< SCT EV3_STATE: STATEMSK25 Position      */
#define SCT_EV3_STATE_STATEMSK25_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK25_Pos)                /*!< SCT EV3_STATE: STATEMSK25 Mask          */
#define SCT_EV3_STATE_STATEMSK26_Pos          26                                                      /*!< SCT EV3_STATE: STATEMSK26 Position      */
#define SCT_EV3_STATE_STATEMSK26_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK26_Pos)                /*!< SCT EV3_STATE: STATEMSK26 Mask          */
#define SCT_EV3_STATE_STATEMSK27_Pos          27                                                      /*!< SCT EV3_STATE: STATEMSK27 Position      */
#define SCT_EV3_STATE_STATEMSK27_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK27_Pos)                /*!< SCT EV3_STATE: STATEMSK27 Mask          */
#define SCT_EV3_STATE_STATEMSK28_Pos          28                                                      /*!< SCT EV3_STATE: STATEMSK28 Position      */
#define SCT_EV3_STATE_STATEMSK28_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK28_Pos)                /*!< SCT EV3_STATE: STATEMSK28 Mask          */
#define SCT_EV3_STATE_STATEMSK29_Pos          29                                                      /*!< SCT EV3_STATE: STATEMSK29 Position      */
#define SCT_EV3_STATE_STATEMSK29_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK29_Pos)                /*!< SCT EV3_STATE: STATEMSK29 Mask          */
#define SCT_EV3_STATE_STATEMSK30_Pos          30                                                      /*!< SCT EV3_STATE: STATEMSK30 Position      */
#define SCT_EV3_STATE_STATEMSK30_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK30_Pos)                /*!< SCT EV3_STATE: STATEMSK30 Mask          */
#define SCT_EV3_STATE_STATEMSK31_Pos          31                                                      /*!< SCT EV3_STATE: STATEMSK31 Position      */
#define SCT_EV3_STATE_STATEMSK31_Msk          (0x01UL << SCT_EV3_STATE_STATEMSK31_Pos)                /*!< SCT EV3_STATE: STATEMSK31 Mask          */

/* --------------------------------  SCT_EV3_CTRL  -------------------------------- */
#define SCT_EV3_CTRL_MATCHSEL_Pos             0                                                       /*!< SCT EV3_CTRL: MATCHSEL Position         */
#define SCT_EV3_CTRL_MATCHSEL_Msk             (0x0fUL << SCT_EV3_CTRL_MATCHSEL_Pos)                   /*!< SCT EV3_CTRL: MATCHSEL Mask             */
#define SCT_EV3_CTRL_HEVENT_Pos               4                                                       /*!< SCT EV3_CTRL: HEVENT Position           */
#define SCT_EV3_CTRL_HEVENT_Msk               (0x01UL << SCT_EV3_CTRL_HEVENT_Pos)                     /*!< SCT EV3_CTRL: HEVENT Mask               */
#define SCT_EV3_CTRL_OUTSEL_Pos               5                                                       /*!< SCT EV3_CTRL: OUTSEL Position           */
#define SCT_EV3_CTRL_OUTSEL_Msk               (0x01UL << SCT_EV3_CTRL_OUTSEL_Pos)                     /*!< SCT EV3_CTRL: OUTSEL Mask               */
#define SCT_EV3_CTRL_IOSEL_Pos                6                                                       /*!< SCT EV3_CTRL: IOSEL Position            */
#define SCT_EV3_CTRL_IOSEL_Msk                (0x0fUL << SCT_EV3_CTRL_IOSEL_Pos)                      /*!< SCT EV3_CTRL: IOSEL Mask                */
#define SCT_EV3_CTRL_IOCOND_Pos               10                                                      /*!< SCT EV3_CTRL: IOCOND Position           */
#define SCT_EV3_CTRL_IOCOND_Msk               (0x03UL << SCT_EV3_CTRL_IOCOND_Pos)                     /*!< SCT EV3_CTRL: IOCOND Mask               */
#define SCT_EV3_CTRL_COMBMODE_Pos             12                                                      /*!< SCT EV3_CTRL: COMBMODE Position         */
#define SCT_EV3_CTRL_COMBMODE_Msk             (0x03UL << SCT_EV3_CTRL_COMBMODE_Pos)                   /*!< SCT EV3_CTRL: COMBMODE Mask             */
#define SCT_EV3_CTRL_STATELD_Pos              14                                                      /*!< SCT EV3_CTRL: STATELD Position          */
#define SCT_EV3_CTRL_STATELD_Msk              (0x01UL << SCT_EV3_CTRL_STATELD_Pos)                    /*!< SCT EV3_CTRL: STATELD Mask              */
#define SCT_EV3_CTRL_STATEV_Pos               15                                                      /*!< SCT EV3_CTRL: STATEV Position           */
#define SCT_EV3_CTRL_STATEV_Msk               (0x1fUL << SCT_EV3_CTRL_STATEV_Pos)                     /*!< SCT EV3_CTRL: STATEV Mask               */
#define SCT_EV3_CTRL_MATCHMEM_Pos             20                                                      /*!< SCT EV3_CTRL: MATCHMEM Position         */
#define SCT_EV3_CTRL_MATCHMEM_Msk             (0x01UL << SCT_EV3_CTRL_MATCHMEM_Pos)                   /*!< SCT EV3_CTRL: MATCHMEM Mask             */
#define SCT_EV3_CTRL_DIRECTION_Pos            21                                                      /*!< SCT EV3_CTRL: DIRECTION Position        */
#define SCT_EV3_CTRL_DIRECTION_Msk            (0x03UL << SCT_EV3_CTRL_DIRECTION_Pos)                  /*!< SCT EV3_CTRL: DIRECTION Mask            */

/* --------------------------------  SCT_EV4_STATE  ------------------------------- */
#define SCT_EV4_STATE_STATEMSK0_Pos           0                                                       /*!< SCT EV4_STATE: STATEMSK0 Position       */
#define SCT_EV4_STATE_STATEMSK0_Msk           (0x01UL << SCT_EV4_STATE_STATEMSK0_Pos)                 /*!< SCT EV4_STATE: STATEMSK0 Mask           */
#define SCT_EV4_STATE_STATEMSK1_Pos           1                                                       /*!< SCT EV4_STATE: STATEMSK1 Position       */
#define SCT_EV4_STATE_STATEMSK1_Msk           (0x01UL << SCT_EV4_STATE_STATEMSK1_Pos)                 /*!< SCT EV4_STATE: STATEMSK1 Mask           */
#define SCT_EV4_STATE_STATEMSK2_Pos           2                                                       /*!< SCT EV4_STATE: STATEMSK2 Position       */
#define SCT_EV4_STATE_STATEMSK2_Msk           (0x01UL << SCT_EV4_STATE_STATEMSK2_Pos)                 /*!< SCT EV4_STATE: STATEMSK2 Mask           */
#define SCT_EV4_STATE_STATEMSK3_Pos           3                                                       /*!< SCT EV4_STATE: STATEMSK3 Position       */
#define SCT_EV4_STATE_STATEMSK3_Msk           (0x01UL << SCT_EV4_STATE_STATEMSK3_Pos)                 /*!< SCT EV4_STATE: STATEMSK3 Mask           */
#define SCT_EV4_STATE_STATEMSK4_Pos           4                                                       /*!< SCT EV4_STATE: STATEMSK4 Position       */
#define SCT_EV4_STATE_STATEMSK4_Msk           (0x01UL << SCT_EV4_STATE_STATEMSK4_Pos)                 /*!< SCT EV4_STATE: STATEMSK4 Mask           */
#define SCT_EV4_STATE_STATEMSK5_Pos           5                                                       /*!< SCT EV4_STATE: STATEMSK5 Position       */
#define SCT_EV4_STATE_STATEMSK5_Msk           (0x01UL << SCT_EV4_STATE_STATEMSK5_Pos)                 /*!< SCT EV4_STATE: STATEMSK5 Mask           */
#define SCT_EV4_STATE_STATEMSK6_Pos           6                                                       /*!< SCT EV4_STATE: STATEMSK6 Position       */
#define SCT_EV4_STATE_STATEMSK6_Msk           (0x01UL << SCT_EV4_STATE_STATEMSK6_Pos)                 /*!< SCT EV4_STATE: STATEMSK6 Mask           */
#define SCT_EV4_STATE_STATEMSK7_Pos           7                                                       /*!< SCT EV4_STATE: STATEMSK7 Position       */
#define SCT_EV4_STATE_STATEMSK7_Msk           (0x01UL << SCT_EV4_STATE_STATEMSK7_Pos)                 /*!< SCT EV4_STATE: STATEMSK7 Mask           */
#define SCT_EV4_STATE_STATEMSK8_Pos           8                                                       /*!< SCT EV4_STATE: STATEMSK8 Position       */
#define SCT_EV4_STATE_STATEMSK8_Msk           (0x01UL << SCT_EV4_STATE_STATEMSK8_Pos)                 /*!< SCT EV4_STATE: STATEMSK8 Mask           */
#define SCT_EV4_STATE_STATEMSK9_Pos           9                                                       /*!< SCT EV4_STATE: STATEMSK9 Position       */
#define SCT_EV4_STATE_STATEMSK9_Msk           (0x01UL << SCT_EV4_STATE_STATEMSK9_Pos)                 /*!< SCT EV4_STATE: STATEMSK9 Mask           */
#define SCT_EV4_STATE_STATEMSK10_Pos          10                                                      /*!< SCT EV4_STATE: STATEMSK10 Position      */
#define SCT_EV4_STATE_STATEMSK10_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK10_Pos)                /*!< SCT EV4_STATE: STATEMSK10 Mask          */
#define SCT_EV4_STATE_STATEMSK11_Pos          11                                                      /*!< SCT EV4_STATE: STATEMSK11 Position      */
#define SCT_EV4_STATE_STATEMSK11_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK11_Pos)                /*!< SCT EV4_STATE: STATEMSK11 Mask          */
#define SCT_EV4_STATE_STATEMSK12_Pos          12                                                      /*!< SCT EV4_STATE: STATEMSK12 Position      */
#define SCT_EV4_STATE_STATEMSK12_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK12_Pos)                /*!< SCT EV4_STATE: STATEMSK12 Mask          */
#define SCT_EV4_STATE_STATEMSK13_Pos          13                                                      /*!< SCT EV4_STATE: STATEMSK13 Position      */
#define SCT_EV4_STATE_STATEMSK13_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK13_Pos)                /*!< SCT EV4_STATE: STATEMSK13 Mask          */
#define SCT_EV4_STATE_STATEMSK14_Pos          14                                                      /*!< SCT EV4_STATE: STATEMSK14 Position      */
#define SCT_EV4_STATE_STATEMSK14_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK14_Pos)                /*!< SCT EV4_STATE: STATEMSK14 Mask          */
#define SCT_EV4_STATE_STATEMSK15_Pos          15                                                      /*!< SCT EV4_STATE: STATEMSK15 Position      */
#define SCT_EV4_STATE_STATEMSK15_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK15_Pos)                /*!< SCT EV4_STATE: STATEMSK15 Mask          */
#define SCT_EV4_STATE_STATEMSK16_Pos          16                                                      /*!< SCT EV4_STATE: STATEMSK16 Position      */
#define SCT_EV4_STATE_STATEMSK16_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK16_Pos)                /*!< SCT EV4_STATE: STATEMSK16 Mask          */
#define SCT_EV4_STATE_STATEMSK17_Pos          17                                                      /*!< SCT EV4_STATE: STATEMSK17 Position      */
#define SCT_EV4_STATE_STATEMSK17_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK17_Pos)                /*!< SCT EV4_STATE: STATEMSK17 Mask          */
#define SCT_EV4_STATE_STATEMSK18_Pos          18                                                      /*!< SCT EV4_STATE: STATEMSK18 Position      */
#define SCT_EV4_STATE_STATEMSK18_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK18_Pos)                /*!< SCT EV4_STATE: STATEMSK18 Mask          */
#define SCT_EV4_STATE_STATEMSK19_Pos          19                                                      /*!< SCT EV4_STATE: STATEMSK19 Position      */
#define SCT_EV4_STATE_STATEMSK19_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK19_Pos)                /*!< SCT EV4_STATE: STATEMSK19 Mask          */
#define SCT_EV4_STATE_STATEMSK20_Pos          20                                                      /*!< SCT EV4_STATE: STATEMSK20 Position      */
#define SCT_EV4_STATE_STATEMSK20_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK20_Pos)                /*!< SCT EV4_STATE: STATEMSK20 Mask          */
#define SCT_EV4_STATE_STATEMSK21_Pos          21                                                      /*!< SCT EV4_STATE: STATEMSK21 Position      */
#define SCT_EV4_STATE_STATEMSK21_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK21_Pos)                /*!< SCT EV4_STATE: STATEMSK21 Mask          */
#define SCT_EV4_STATE_STATEMSK22_Pos          22                                                      /*!< SCT EV4_STATE: STATEMSK22 Position      */
#define SCT_EV4_STATE_STATEMSK22_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK22_Pos)                /*!< SCT EV4_STATE: STATEMSK22 Mask          */
#define SCT_EV4_STATE_STATEMSK23_Pos          23                                                      /*!< SCT EV4_STATE: STATEMSK23 Position      */
#define SCT_EV4_STATE_STATEMSK23_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK23_Pos)                /*!< SCT EV4_STATE: STATEMSK23 Mask          */
#define SCT_EV4_STATE_STATEMSK24_Pos          24                                                      /*!< SCT EV4_STATE: STATEMSK24 Position      */
#define SCT_EV4_STATE_STATEMSK24_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK24_Pos)                /*!< SCT EV4_STATE: STATEMSK24 Mask          */
#define SCT_EV4_STATE_STATEMSK25_Pos          25                                                      /*!< SCT EV4_STATE: STATEMSK25 Position      */
#define SCT_EV4_STATE_STATEMSK25_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK25_Pos)                /*!< SCT EV4_STATE: STATEMSK25 Mask          */
#define SCT_EV4_STATE_STATEMSK26_Pos          26                                                      /*!< SCT EV4_STATE: STATEMSK26 Position      */
#define SCT_EV4_STATE_STATEMSK26_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK26_Pos)                /*!< SCT EV4_STATE: STATEMSK26 Mask          */
#define SCT_EV4_STATE_STATEMSK27_Pos          27                                                      /*!< SCT EV4_STATE: STATEMSK27 Position      */
#define SCT_EV4_STATE_STATEMSK27_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK27_Pos)                /*!< SCT EV4_STATE: STATEMSK27 Mask          */
#define SCT_EV4_STATE_STATEMSK28_Pos          28                                                      /*!< SCT EV4_STATE: STATEMSK28 Position      */
#define SCT_EV4_STATE_STATEMSK28_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK28_Pos)                /*!< SCT EV4_STATE: STATEMSK28 Mask          */
#define SCT_EV4_STATE_STATEMSK29_Pos          29                                                      /*!< SCT EV4_STATE: STATEMSK29 Position      */
#define SCT_EV4_STATE_STATEMSK29_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK29_Pos)                /*!< SCT EV4_STATE: STATEMSK29 Mask          */
#define SCT_EV4_STATE_STATEMSK30_Pos          30                                                      /*!< SCT EV4_STATE: STATEMSK30 Position      */
#define SCT_EV4_STATE_STATEMSK30_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK30_Pos)                /*!< SCT EV4_STATE: STATEMSK30 Mask          */
#define SCT_EV4_STATE_STATEMSK31_Pos          31                                                      /*!< SCT EV4_STATE: STATEMSK31 Position      */
#define SCT_EV4_STATE_STATEMSK31_Msk          (0x01UL << SCT_EV4_STATE_STATEMSK31_Pos)                /*!< SCT EV4_STATE: STATEMSK31 Mask          */

/* --------------------------------  SCT_EV4_CTRL  -------------------------------- */
#define SCT_EV4_CTRL_MATCHSEL_Pos             0                                                       /*!< SCT EV4_CTRL: MATCHSEL Position         */
#define SCT_EV4_CTRL_MATCHSEL_Msk             (0x0fUL << SCT_EV4_CTRL_MATCHSEL_Pos)                   /*!< SCT EV4_CTRL: MATCHSEL Mask             */
#define SCT_EV4_CTRL_HEVENT_Pos               4                                                       /*!< SCT EV4_CTRL: HEVENT Position           */
#define SCT_EV4_CTRL_HEVENT_Msk               (0x01UL << SCT_EV4_CTRL_HEVENT_Pos)                     /*!< SCT EV4_CTRL: HEVENT Mask               */
#define SCT_EV4_CTRL_OUTSEL_Pos               5                                                       /*!< SCT EV4_CTRL: OUTSEL Position           */
#define SCT_EV4_CTRL_OUTSEL_Msk               (0x01UL << SCT_EV4_CTRL_OUTSEL_Pos)                     /*!< SCT EV4_CTRL: OUTSEL Mask               */
#define SCT_EV4_CTRL_IOSEL_Pos                6                                                       /*!< SCT EV4_CTRL: IOSEL Position            */
#define SCT_EV4_CTRL_IOSEL_Msk                (0x0fUL << SCT_EV4_CTRL_IOSEL_Pos)                      /*!< SCT EV4_CTRL: IOSEL Mask                */
#define SCT_EV4_CTRL_IOCOND_Pos               10                                                      /*!< SCT EV4_CTRL: IOCOND Position           */
#define SCT_EV4_CTRL_IOCOND_Msk               (0x03UL << SCT_EV4_CTRL_IOCOND_Pos)                     /*!< SCT EV4_CTRL: IOCOND Mask               */
#define SCT_EV4_CTRL_COMBMODE_Pos             12                                                      /*!< SCT EV4_CTRL: COMBMODE Position         */
#define SCT_EV4_CTRL_COMBMODE_Msk             (0x03UL << SCT_EV4_CTRL_COMBMODE_Pos)                   /*!< SCT EV4_CTRL: COMBMODE Mask             */
#define SCT_EV4_CTRL_STATELD_Pos              14                                                      /*!< SCT EV4_CTRL: STATELD Position          */
#define SCT_EV4_CTRL_STATELD_Msk              (0x01UL << SCT_EV4_CTRL_STATELD_Pos)                    /*!< SCT EV4_CTRL: STATELD Mask              */
#define SCT_EV4_CTRL_STATEV_Pos               15                                                      /*!< SCT EV4_CTRL: STATEV Position           */
#define SCT_EV4_CTRL_STATEV_Msk               (0x1fUL << SCT_EV4_CTRL_STATEV_Pos)                     /*!< SCT EV4_CTRL: STATEV Mask               */
#define SCT_EV4_CTRL_MATCHMEM_Pos             20                                                      /*!< SCT EV4_CTRL: MATCHMEM Position         */
#define SCT_EV4_CTRL_MATCHMEM_Msk             (0x01UL << SCT_EV4_CTRL_MATCHMEM_Pos)                   /*!< SCT EV4_CTRL: MATCHMEM Mask             */
#define SCT_EV4_CTRL_DIRECTION_Pos            21                                                      /*!< SCT EV4_CTRL: DIRECTION Position        */
#define SCT_EV4_CTRL_DIRECTION_Msk            (0x03UL << SCT_EV4_CTRL_DIRECTION_Pos)                  /*!< SCT EV4_CTRL: DIRECTION Mask            */

/* --------------------------------  SCT_EV5_STATE  ------------------------------- */
#define SCT_EV5_STATE_STATEMSK0_Pos           0                                                       /*!< SCT EV5_STATE: STATEMSK0 Position       */
#define SCT_EV5_STATE_STATEMSK0_Msk           (0x01UL << SCT_EV5_STATE_STATEMSK0_Pos)                 /*!< SCT EV5_STATE: STATEMSK0 Mask           */
#define SCT_EV5_STATE_STATEMSK1_Pos           1                                                       /*!< SCT EV5_STATE: STATEMSK1 Position       */
#define SCT_EV5_STATE_STATEMSK1_Msk           (0x01UL << SCT_EV5_STATE_STATEMSK1_Pos)                 /*!< SCT EV5_STATE: STATEMSK1 Mask           */
#define SCT_EV5_STATE_STATEMSK2_Pos           2                                                       /*!< SCT EV5_STATE: STATEMSK2 Position       */
#define SCT_EV5_STATE_STATEMSK2_Msk           (0x01UL << SCT_EV5_STATE_STATEMSK2_Pos)                 /*!< SCT EV5_STATE: STATEMSK2 Mask           */
#define SCT_EV5_STATE_STATEMSK3_Pos           3                                                       /*!< SCT EV5_STATE: STATEMSK3 Position       */
#define SCT_EV5_STATE_STATEMSK3_Msk           (0x01UL << SCT_EV5_STATE_STATEMSK3_Pos)                 /*!< SCT EV5_STATE: STATEMSK3 Mask           */
#define SCT_EV5_STATE_STATEMSK4_Pos           4                                                       /*!< SCT EV5_STATE: STATEMSK4 Position       */
#define SCT_EV5_STATE_STATEMSK4_Msk           (0x01UL << SCT_EV5_STATE_STATEMSK4_Pos)                 /*!< SCT EV5_STATE: STATEMSK4 Mask           */
#define SCT_EV5_STATE_STATEMSK5_Pos           5                                                       /*!< SCT EV5_STATE: STATEMSK5 Position       */
#define SCT_EV5_STATE_STATEMSK5_Msk           (0x01UL << SCT_EV5_STATE_STATEMSK5_Pos)                 /*!< SCT EV5_STATE: STATEMSK5 Mask           */
#define SCT_EV5_STATE_STATEMSK6_Pos           6                                                       /*!< SCT EV5_STATE: STATEMSK6 Position       */
#define SCT_EV5_STATE_STATEMSK6_Msk           (0x01UL << SCT_EV5_STATE_STATEMSK6_Pos)                 /*!< SCT EV5_STATE: STATEMSK6 Mask           */
#define SCT_EV5_STATE_STATEMSK7_Pos           7                                                       /*!< SCT EV5_STATE: STATEMSK7 Position       */
#define SCT_EV5_STATE_STATEMSK7_Msk           (0x01UL << SCT_EV5_STATE_STATEMSK7_Pos)                 /*!< SCT EV5_STATE: STATEMSK7 Mask           */
#define SCT_EV5_STATE_STATEMSK8_Pos           8                                                       /*!< SCT EV5_STATE: STATEMSK8 Position       */
#define SCT_EV5_STATE_STATEMSK8_Msk           (0x01UL << SCT_EV5_STATE_STATEMSK8_Pos)                 /*!< SCT EV5_STATE: STATEMSK8 Mask           */
#define SCT_EV5_STATE_STATEMSK9_Pos           9                                                       /*!< SCT EV5_STATE: STATEMSK9 Position       */
#define SCT_EV5_STATE_STATEMSK9_Msk           (0x01UL << SCT_EV5_STATE_STATEMSK9_Pos)                 /*!< SCT EV5_STATE: STATEMSK9 Mask           */
#define SCT_EV5_STATE_STATEMSK10_Pos          10                                                      /*!< SCT EV5_STATE: STATEMSK10 Position      */
#define SCT_EV5_STATE_STATEMSK10_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK10_Pos)                /*!< SCT EV5_STATE: STATEMSK10 Mask          */
#define SCT_EV5_STATE_STATEMSK11_Pos          11                                                      /*!< SCT EV5_STATE: STATEMSK11 Position      */
#define SCT_EV5_STATE_STATEMSK11_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK11_Pos)                /*!< SCT EV5_STATE: STATEMSK11 Mask          */
#define SCT_EV5_STATE_STATEMSK12_Pos          12                                                      /*!< SCT EV5_STATE: STATEMSK12 Position      */
#define SCT_EV5_STATE_STATEMSK12_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK12_Pos)                /*!< SCT EV5_STATE: STATEMSK12 Mask          */
#define SCT_EV5_STATE_STATEMSK13_Pos          13                                                      /*!< SCT EV5_STATE: STATEMSK13 Position      */
#define SCT_EV5_STATE_STATEMSK13_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK13_Pos)                /*!< SCT EV5_STATE: STATEMSK13 Mask          */
#define SCT_EV5_STATE_STATEMSK14_Pos          14                                                      /*!< SCT EV5_STATE: STATEMSK14 Position      */
#define SCT_EV5_STATE_STATEMSK14_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK14_Pos)                /*!< SCT EV5_STATE: STATEMSK14 Mask          */
#define SCT_EV5_STATE_STATEMSK15_Pos          15                                                      /*!< SCT EV5_STATE: STATEMSK15 Position      */
#define SCT_EV5_STATE_STATEMSK15_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK15_Pos)                /*!< SCT EV5_STATE: STATEMSK15 Mask          */
#define SCT_EV5_STATE_STATEMSK16_Pos          16                                                      /*!< SCT EV5_STATE: STATEMSK16 Position      */
#define SCT_EV5_STATE_STATEMSK16_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK16_Pos)                /*!< SCT EV5_STATE: STATEMSK16 Mask          */
#define SCT_EV5_STATE_STATEMSK17_Pos          17                                                      /*!< SCT EV5_STATE: STATEMSK17 Position      */
#define SCT_EV5_STATE_STATEMSK17_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK17_Pos)                /*!< SCT EV5_STATE: STATEMSK17 Mask          */
#define SCT_EV5_STATE_STATEMSK18_Pos          18                                                      /*!< SCT EV5_STATE: STATEMSK18 Position      */
#define SCT_EV5_STATE_STATEMSK18_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK18_Pos)                /*!< SCT EV5_STATE: STATEMSK18 Mask          */
#define SCT_EV5_STATE_STATEMSK19_Pos          19                                                      /*!< SCT EV5_STATE: STATEMSK19 Position      */
#define SCT_EV5_STATE_STATEMSK19_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK19_Pos)                /*!< SCT EV5_STATE: STATEMSK19 Mask          */
#define SCT_EV5_STATE_STATEMSK20_Pos          20                                                      /*!< SCT EV5_STATE: STATEMSK20 Position      */
#define SCT_EV5_STATE_STATEMSK20_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK20_Pos)                /*!< SCT EV5_STATE: STATEMSK20 Mask          */
#define SCT_EV5_STATE_STATEMSK21_Pos          21                                                      /*!< SCT EV5_STATE: STATEMSK21 Position      */
#define SCT_EV5_STATE_STATEMSK21_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK21_Pos)                /*!< SCT EV5_STATE: STATEMSK21 Mask          */
#define SCT_EV5_STATE_STATEMSK22_Pos          22                                                      /*!< SCT EV5_STATE: STATEMSK22 Position      */
#define SCT_EV5_STATE_STATEMSK22_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK22_Pos)                /*!< SCT EV5_STATE: STATEMSK22 Mask          */
#define SCT_EV5_STATE_STATEMSK23_Pos          23                                                      /*!< SCT EV5_STATE: STATEMSK23 Position      */
#define SCT_EV5_STATE_STATEMSK23_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK23_Pos)                /*!< SCT EV5_STATE: STATEMSK23 Mask          */
#define SCT_EV5_STATE_STATEMSK24_Pos          24                                                      /*!< SCT EV5_STATE: STATEMSK24 Position      */
#define SCT_EV5_STATE_STATEMSK24_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK24_Pos)                /*!< SCT EV5_STATE: STATEMSK24 Mask          */
#define SCT_EV5_STATE_STATEMSK25_Pos          25                                                      /*!< SCT EV5_STATE: STATEMSK25 Position      */
#define SCT_EV5_STATE_STATEMSK25_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK25_Pos)                /*!< SCT EV5_STATE: STATEMSK25 Mask          */
#define SCT_EV5_STATE_STATEMSK26_Pos          26                                                      /*!< SCT EV5_STATE: STATEMSK26 Position      */
#define SCT_EV5_STATE_STATEMSK26_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK26_Pos)                /*!< SCT EV5_STATE: STATEMSK26 Mask          */
#define SCT_EV5_STATE_STATEMSK27_Pos          27                                                      /*!< SCT EV5_STATE: STATEMSK27 Position      */
#define SCT_EV5_STATE_STATEMSK27_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK27_Pos)                /*!< SCT EV5_STATE: STATEMSK27 Mask          */
#define SCT_EV5_STATE_STATEMSK28_Pos          28                                                      /*!< SCT EV5_STATE: STATEMSK28 Position      */
#define SCT_EV5_STATE_STATEMSK28_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK28_Pos)                /*!< SCT EV5_STATE: STATEMSK28 Mask          */
#define SCT_EV5_STATE_STATEMSK29_Pos          29                                                      /*!< SCT EV5_STATE: STATEMSK29 Position      */
#define SCT_EV5_STATE_STATEMSK29_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK29_Pos)                /*!< SCT EV5_STATE: STATEMSK29 Mask          */
#define SCT_EV5_STATE_STATEMSK30_Pos          30                                                      /*!< SCT EV5_STATE: STATEMSK30 Position      */
#define SCT_EV5_STATE_STATEMSK30_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK30_Pos)                /*!< SCT EV5_STATE: STATEMSK30 Mask          */
#define SCT_EV5_STATE_STATEMSK31_Pos          31                                                      /*!< SCT EV5_STATE: STATEMSK31 Position      */
#define SCT_EV5_STATE_STATEMSK31_Msk          (0x01UL << SCT_EV5_STATE_STATEMSK31_Pos)                /*!< SCT EV5_STATE: STATEMSK31 Mask          */

/* --------------------------------  SCT_EV5_CTRL  -------------------------------- */
#define SCT_EV5_CTRL_MATCHSEL_Pos             0                                                       /*!< SCT EV5_CTRL: MATCHSEL Position         */
#define SCT_EV5_CTRL_MATCHSEL_Msk             (0x0fUL << SCT_EV5_CTRL_MATCHSEL_Pos)                   /*!< SCT EV5_CTRL: MATCHSEL Mask             */
#define SCT_EV5_CTRL_HEVENT_Pos               4                                                       /*!< SCT EV5_CTRL: HEVENT Position           */
#define SCT_EV5_CTRL_HEVENT_Msk               (0x01UL << SCT_EV5_CTRL_HEVENT_Pos)                     /*!< SCT EV5_CTRL: HEVENT Mask               */
#define SCT_EV5_CTRL_OUTSEL_Pos               5                                                       /*!< SCT EV5_CTRL: OUTSEL Position           */
#define SCT_EV5_CTRL_OUTSEL_Msk               (0x01UL << SCT_EV5_CTRL_OUTSEL_Pos)                     /*!< SCT EV5_CTRL: OUTSEL Mask               */
#define SCT_EV5_CTRL_IOSEL_Pos                6                                                       /*!< SCT EV5_CTRL: IOSEL Position            */
#define SCT_EV5_CTRL_IOSEL_Msk                (0x0fUL << SCT_EV5_CTRL_IOSEL_Pos)                      /*!< SCT EV5_CTRL: IOSEL Mask                */
#define SCT_EV5_CTRL_IOCOND_Pos               10                                                      /*!< SCT EV5_CTRL: IOCOND Position           */
#define SCT_EV5_CTRL_IOCOND_Msk               (0x03UL << SCT_EV5_CTRL_IOCOND_Pos)                     /*!< SCT EV5_CTRL: IOCOND Mask               */
#define SCT_EV5_CTRL_COMBMODE_Pos             12                                                      /*!< SCT EV5_CTRL: COMBMODE Position         */
#define SCT_EV5_CTRL_COMBMODE_Msk             (0x03UL << SCT_EV5_CTRL_COMBMODE_Pos)                   /*!< SCT EV5_CTRL: COMBMODE Mask             */
#define SCT_EV5_CTRL_STATELD_Pos              14                                                      /*!< SCT EV5_CTRL: STATELD Position          */
#define SCT_EV5_CTRL_STATELD_Msk              (0x01UL << SCT_EV5_CTRL_STATELD_Pos)                    /*!< SCT EV5_CTRL: STATELD Mask              */
#define SCT_EV5_CTRL_STATEV_Pos               15                                                      /*!< SCT EV5_CTRL: STATEV Position           */
#define SCT_EV5_CTRL_STATEV_Msk               (0x1fUL << SCT_EV5_CTRL_STATEV_Pos)                     /*!< SCT EV5_CTRL: STATEV Mask               */
#define SCT_EV5_CTRL_MATCHMEM_Pos             20                                                      /*!< SCT EV5_CTRL: MATCHMEM Position         */
#define SCT_EV5_CTRL_MATCHMEM_Msk             (0x01UL << SCT_EV5_CTRL_MATCHMEM_Pos)                   /*!< SCT EV5_CTRL: MATCHMEM Mask             */
#define SCT_EV5_CTRL_DIRECTION_Pos            21                                                      /*!< SCT EV5_CTRL: DIRECTION Position        */
#define SCT_EV5_CTRL_DIRECTION_Msk            (0x03UL << SCT_EV5_CTRL_DIRECTION_Pos)                  /*!< SCT EV5_CTRL: DIRECTION Mask            */

/* --------------------------------  SCT_EV6_STATE  ------------------------------- */
#define SCT_EV6_STATE_STATEMSK0_Pos           0                                                       /*!< SCT EV6_STATE: STATEMSK0 Position       */
#define SCT_EV6_STATE_STATEMSK0_Msk           (0x01UL << SCT_EV6_STATE_STATEMSK0_Pos)                 /*!< SCT EV6_STATE: STATEMSK0 Mask           */
#define SCT_EV6_STATE_STATEMSK1_Pos           1                                                       /*!< SCT EV6_STATE: STATEMSK1 Position       */
#define SCT_EV6_STATE_STATEMSK1_Msk           (0x01UL << SCT_EV6_STATE_STATEMSK1_Pos)                 /*!< SCT EV6_STATE: STATEMSK1 Mask           */
#define SCT_EV6_STATE_STATEMSK2_Pos           2                                                       /*!< SCT EV6_STATE: STATEMSK2 Position       */
#define SCT_EV6_STATE_STATEMSK2_Msk           (0x01UL << SCT_EV6_STATE_STATEMSK2_Pos)                 /*!< SCT EV6_STATE: STATEMSK2 Mask           */
#define SCT_EV6_STATE_STATEMSK3_Pos           3                                                       /*!< SCT EV6_STATE: STATEMSK3 Position       */
#define SCT_EV6_STATE_STATEMSK3_Msk           (0x01UL << SCT_EV6_STATE_STATEMSK3_Pos)                 /*!< SCT EV6_STATE: STATEMSK3 Mask           */
#define SCT_EV6_STATE_STATEMSK4_Pos           4                                                       /*!< SCT EV6_STATE: STATEMSK4 Position       */
#define SCT_EV6_STATE_STATEMSK4_Msk           (0x01UL << SCT_EV6_STATE_STATEMSK4_Pos)                 /*!< SCT EV6_STATE: STATEMSK4 Mask           */
#define SCT_EV6_STATE_STATEMSK5_Pos           5                                                       /*!< SCT EV6_STATE: STATEMSK5 Position       */
#define SCT_EV6_STATE_STATEMSK5_Msk           (0x01UL << SCT_EV6_STATE_STATEMSK5_Pos)                 /*!< SCT EV6_STATE: STATEMSK5 Mask           */
#define SCT_EV6_STATE_STATEMSK6_Pos           6                                                       /*!< SCT EV6_STATE: STATEMSK6 Position       */
#define SCT_EV6_STATE_STATEMSK6_Msk           (0x01UL << SCT_EV6_STATE_STATEMSK6_Pos)                 /*!< SCT EV6_STATE: STATEMSK6 Mask           */
#define SCT_EV6_STATE_STATEMSK7_Pos           7                                                       /*!< SCT EV6_STATE: STATEMSK7 Position       */
#define SCT_EV6_STATE_STATEMSK7_Msk           (0x01UL << SCT_EV6_STATE_STATEMSK7_Pos)                 /*!< SCT EV6_STATE: STATEMSK7 Mask           */
#define SCT_EV6_STATE_STATEMSK8_Pos           8                                                       /*!< SCT EV6_STATE: STATEMSK8 Position       */
#define SCT_EV6_STATE_STATEMSK8_Msk           (0x01UL << SCT_EV6_STATE_STATEMSK8_Pos)                 /*!< SCT EV6_STATE: STATEMSK8 Mask           */
#define SCT_EV6_STATE_STATEMSK9_Pos           9                                                       /*!< SCT EV6_STATE: STATEMSK9 Position       */
#define SCT_EV6_STATE_STATEMSK9_Msk           (0x01UL << SCT_EV6_STATE_STATEMSK9_Pos)                 /*!< SCT EV6_STATE: STATEMSK9 Mask           */
#define SCT_EV6_STATE_STATEMSK10_Pos          10                                                      /*!< SCT EV6_STATE: STATEMSK10 Position      */
#define SCT_EV6_STATE_STATEMSK10_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK10_Pos)                /*!< SCT EV6_STATE: STATEMSK10 Mask          */
#define SCT_EV6_STATE_STATEMSK11_Pos          11                                                      /*!< SCT EV6_STATE: STATEMSK11 Position      */
#define SCT_EV6_STATE_STATEMSK11_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK11_Pos)                /*!< SCT EV6_STATE: STATEMSK11 Mask          */
#define SCT_EV6_STATE_STATEMSK12_Pos          12                                                      /*!< SCT EV6_STATE: STATEMSK12 Position      */
#define SCT_EV6_STATE_STATEMSK12_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK12_Pos)                /*!< SCT EV6_STATE: STATEMSK12 Mask          */
#define SCT_EV6_STATE_STATEMSK13_Pos          13                                                      /*!< SCT EV6_STATE: STATEMSK13 Position      */
#define SCT_EV6_STATE_STATEMSK13_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK13_Pos)                /*!< SCT EV6_STATE: STATEMSK13 Mask          */
#define SCT_EV6_STATE_STATEMSK14_Pos          14                                                      /*!< SCT EV6_STATE: STATEMSK14 Position      */
#define SCT_EV6_STATE_STATEMSK14_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK14_Pos)                /*!< SCT EV6_STATE: STATEMSK14 Mask          */
#define SCT_EV6_STATE_STATEMSK15_Pos          15                                                      /*!< SCT EV6_STATE: STATEMSK15 Position      */
#define SCT_EV6_STATE_STATEMSK15_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK15_Pos)                /*!< SCT EV6_STATE: STATEMSK15 Mask          */
#define SCT_EV6_STATE_STATEMSK16_Pos          16                                                      /*!< SCT EV6_STATE: STATEMSK16 Position      */
#define SCT_EV6_STATE_STATEMSK16_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK16_Pos)                /*!< SCT EV6_STATE: STATEMSK16 Mask          */
#define SCT_EV6_STATE_STATEMSK17_Pos          17                                                      /*!< SCT EV6_STATE: STATEMSK17 Position      */
#define SCT_EV6_STATE_STATEMSK17_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK17_Pos)                /*!< SCT EV6_STATE: STATEMSK17 Mask          */
#define SCT_EV6_STATE_STATEMSK18_Pos          18                                                      /*!< SCT EV6_STATE: STATEMSK18 Position      */
#define SCT_EV6_STATE_STATEMSK18_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK18_Pos)                /*!< SCT EV6_STATE: STATEMSK18 Mask          */
#define SCT_EV6_STATE_STATEMSK19_Pos          19                                                      /*!< SCT EV6_STATE: STATEMSK19 Position      */
#define SCT_EV6_STATE_STATEMSK19_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK19_Pos)                /*!< SCT EV6_STATE: STATEMSK19 Mask          */
#define SCT_EV6_STATE_STATEMSK20_Pos          20                                                      /*!< SCT EV6_STATE: STATEMSK20 Position      */
#define SCT_EV6_STATE_STATEMSK20_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK20_Pos)                /*!< SCT EV6_STATE: STATEMSK20 Mask          */
#define SCT_EV6_STATE_STATEMSK21_Pos          21                                                      /*!< SCT EV6_STATE: STATEMSK21 Position      */
#define SCT_EV6_STATE_STATEMSK21_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK21_Pos)                /*!< SCT EV6_STATE: STATEMSK21 Mask          */
#define SCT_EV6_STATE_STATEMSK22_Pos          22                                                      /*!< SCT EV6_STATE: STATEMSK22 Position      */
#define SCT_EV6_STATE_STATEMSK22_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK22_Pos)                /*!< SCT EV6_STATE: STATEMSK22 Mask          */
#define SCT_EV6_STATE_STATEMSK23_Pos          23                                                      /*!< SCT EV6_STATE: STATEMSK23 Position      */
#define SCT_EV6_STATE_STATEMSK23_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK23_Pos)                /*!< SCT EV6_STATE: STATEMSK23 Mask          */
#define SCT_EV6_STATE_STATEMSK24_Pos          24                                                      /*!< SCT EV6_STATE: STATEMSK24 Position      */
#define SCT_EV6_STATE_STATEMSK24_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK24_Pos)                /*!< SCT EV6_STATE: STATEMSK24 Mask          */
#define SCT_EV6_STATE_STATEMSK25_Pos          25                                                      /*!< SCT EV6_STATE: STATEMSK25 Position      */
#define SCT_EV6_STATE_STATEMSK25_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK25_Pos)                /*!< SCT EV6_STATE: STATEMSK25 Mask          */
#define SCT_EV6_STATE_STATEMSK26_Pos          26                                                      /*!< SCT EV6_STATE: STATEMSK26 Position      */
#define SCT_EV6_STATE_STATEMSK26_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK26_Pos)                /*!< SCT EV6_STATE: STATEMSK26 Mask          */
#define SCT_EV6_STATE_STATEMSK27_Pos          27                                                      /*!< SCT EV6_STATE: STATEMSK27 Position      */
#define SCT_EV6_STATE_STATEMSK27_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK27_Pos)                /*!< SCT EV6_STATE: STATEMSK27 Mask          */
#define SCT_EV6_STATE_STATEMSK28_Pos          28                                                      /*!< SCT EV6_STATE: STATEMSK28 Position      */
#define SCT_EV6_STATE_STATEMSK28_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK28_Pos)                /*!< SCT EV6_STATE: STATEMSK28 Mask          */
#define SCT_EV6_STATE_STATEMSK29_Pos          29                                                      /*!< SCT EV6_STATE: STATEMSK29 Position      */
#define SCT_EV6_STATE_STATEMSK29_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK29_Pos)                /*!< SCT EV6_STATE: STATEMSK29 Mask          */
#define SCT_EV6_STATE_STATEMSK30_Pos          30                                                      /*!< SCT EV6_STATE: STATEMSK30 Position      */
#define SCT_EV6_STATE_STATEMSK30_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK30_Pos)                /*!< SCT EV6_STATE: STATEMSK30 Mask          */
#define SCT_EV6_STATE_STATEMSK31_Pos          31                                                      /*!< SCT EV6_STATE: STATEMSK31 Position      */
#define SCT_EV6_STATE_STATEMSK31_Msk          (0x01UL << SCT_EV6_STATE_STATEMSK31_Pos)                /*!< SCT EV6_STATE: STATEMSK31 Mask          */

/* --------------------------------  SCT_EV6_CTRL  -------------------------------- */
#define SCT_EV6_CTRL_MATCHSEL_Pos             0                                                       /*!< SCT EV6_CTRL: MATCHSEL Position         */
#define SCT_EV6_CTRL_MATCHSEL_Msk             (0x0fUL << SCT_EV6_CTRL_MATCHSEL_Pos)                   /*!< SCT EV6_CTRL: MATCHSEL Mask             */
#define SCT_EV6_CTRL_HEVENT_Pos               4                                                       /*!< SCT EV6_CTRL: HEVENT Position           */
#define SCT_EV6_CTRL_HEVENT_Msk               (0x01UL << SCT_EV6_CTRL_HEVENT_Pos)                     /*!< SCT EV6_CTRL: HEVENT Mask               */
#define SCT_EV6_CTRL_OUTSEL_Pos               5                                                       /*!< SCT EV6_CTRL: OUTSEL Position           */
#define SCT_EV6_CTRL_OUTSEL_Msk               (0x01UL << SCT_EV6_CTRL_OUTSEL_Pos)                     /*!< SCT EV6_CTRL: OUTSEL Mask               */
#define SCT_EV6_CTRL_IOSEL_Pos                6                                                       /*!< SCT EV6_CTRL: IOSEL Position            */
#define SCT_EV6_CTRL_IOSEL_Msk                (0x0fUL << SCT_EV6_CTRL_IOSEL_Pos)                      /*!< SCT EV6_CTRL: IOSEL Mask                */
#define SCT_EV6_CTRL_IOCOND_Pos               10                                                      /*!< SCT EV6_CTRL: IOCOND Position           */
#define SCT_EV6_CTRL_IOCOND_Msk               (0x03UL << SCT_EV6_CTRL_IOCOND_Pos)                     /*!< SCT EV6_CTRL: IOCOND Mask               */
#define SCT_EV6_CTRL_COMBMODE_Pos             12                                                      /*!< SCT EV6_CTRL: COMBMODE Position         */
#define SCT_EV6_CTRL_COMBMODE_Msk             (0x03UL << SCT_EV6_CTRL_COMBMODE_Pos)                   /*!< SCT EV6_CTRL: COMBMODE Mask             */
#define SCT_EV6_CTRL_STATELD_Pos              14                                                      /*!< SCT EV6_CTRL: STATELD Position          */
#define SCT_EV6_CTRL_STATELD_Msk              (0x01UL << SCT_EV6_CTRL_STATELD_Pos)                    /*!< SCT EV6_CTRL: STATELD Mask              */
#define SCT_EV6_CTRL_STATEV_Pos               15                                                      /*!< SCT EV6_CTRL: STATEV Position           */
#define SCT_EV6_CTRL_STATEV_Msk               (0x1fUL << SCT_EV6_CTRL_STATEV_Pos)                     /*!< SCT EV6_CTRL: STATEV Mask               */
#define SCT_EV6_CTRL_MATCHMEM_Pos             20                                                      /*!< SCT EV6_CTRL: MATCHMEM Position         */
#define SCT_EV6_CTRL_MATCHMEM_Msk             (0x01UL << SCT_EV6_CTRL_MATCHMEM_Pos)                   /*!< SCT EV6_CTRL: MATCHMEM Mask             */
#define SCT_EV6_CTRL_DIRECTION_Pos            21                                                      /*!< SCT EV6_CTRL: DIRECTION Position        */
#define SCT_EV6_CTRL_DIRECTION_Msk            (0x03UL << SCT_EV6_CTRL_DIRECTION_Pos)                  /*!< SCT EV6_CTRL: DIRECTION Mask            */

/* --------------------------------  SCT_EV7_STATE  ------------------------------- */
#define SCT_EV7_STATE_STATEMSK0_Pos           0                                                       /*!< SCT EV7_STATE: STATEMSK0 Position       */
#define SCT_EV7_STATE_STATEMSK0_Msk           (0x01UL << SCT_EV7_STATE_STATEMSK0_Pos)                 /*!< SCT EV7_STATE: STATEMSK0 Mask           */
#define SCT_EV7_STATE_STATEMSK1_Pos           1                                                       /*!< SCT EV7_STATE: STATEMSK1 Position       */
#define SCT_EV7_STATE_STATEMSK1_Msk           (0x01UL << SCT_EV7_STATE_STATEMSK1_Pos)                 /*!< SCT EV7_STATE: STATEMSK1 Mask           */
#define SCT_EV7_STATE_STATEMSK2_Pos           2                                                       /*!< SCT EV7_STATE: STATEMSK2 Position       */
#define SCT_EV7_STATE_STATEMSK2_Msk           (0x01UL << SCT_EV7_STATE_STATEMSK2_Pos)                 /*!< SCT EV7_STATE: STATEMSK2 Mask           */
#define SCT_EV7_STATE_STATEMSK3_Pos           3                                                       /*!< SCT EV7_STATE: STATEMSK3 Position       */
#define SCT_EV7_STATE_STATEMSK3_Msk           (0x01UL << SCT_EV7_STATE_STATEMSK3_Pos)                 /*!< SCT EV7_STATE: STATEMSK3 Mask           */
#define SCT_EV7_STATE_STATEMSK4_Pos           4                                                       /*!< SCT EV7_STATE: STATEMSK4 Position       */
#define SCT_EV7_STATE_STATEMSK4_Msk           (0x01UL << SCT_EV7_STATE_STATEMSK4_Pos)                 /*!< SCT EV7_STATE: STATEMSK4 Mask           */
#define SCT_EV7_STATE_STATEMSK5_Pos           5                                                       /*!< SCT EV7_STATE: STATEMSK5 Position       */
#define SCT_EV7_STATE_STATEMSK5_Msk           (0x01UL << SCT_EV7_STATE_STATEMSK5_Pos)                 /*!< SCT EV7_STATE: STATEMSK5 Mask           */
#define SCT_EV7_STATE_STATEMSK6_Pos           6                                                       /*!< SCT EV7_STATE: STATEMSK6 Position       */
#define SCT_EV7_STATE_STATEMSK6_Msk           (0x01UL << SCT_EV7_STATE_STATEMSK6_Pos)                 /*!< SCT EV7_STATE: STATEMSK6 Mask           */
#define SCT_EV7_STATE_STATEMSK7_Pos           7                                                       /*!< SCT EV7_STATE: STATEMSK7 Position       */
#define SCT_EV7_STATE_STATEMSK7_Msk           (0x01UL << SCT_EV7_STATE_STATEMSK7_Pos)                 /*!< SCT EV7_STATE: STATEMSK7 Mask           */
#define SCT_EV7_STATE_STATEMSK8_Pos           8                                                       /*!< SCT EV7_STATE: STATEMSK8 Position       */
#define SCT_EV7_STATE_STATEMSK8_Msk           (0x01UL << SCT_EV7_STATE_STATEMSK8_Pos)                 /*!< SCT EV7_STATE: STATEMSK8 Mask           */
#define SCT_EV7_STATE_STATEMSK9_Pos           9                                                       /*!< SCT EV7_STATE: STATEMSK9 Position       */
#define SCT_EV7_STATE_STATEMSK9_Msk           (0x01UL << SCT_EV7_STATE_STATEMSK9_Pos)                 /*!< SCT EV7_STATE: STATEMSK9 Mask           */
#define SCT_EV7_STATE_STATEMSK10_Pos          10                                                      /*!< SCT EV7_STATE: STATEMSK10 Position      */
#define SCT_EV7_STATE_STATEMSK10_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK10_Pos)                /*!< SCT EV7_STATE: STATEMSK10 Mask          */
#define SCT_EV7_STATE_STATEMSK11_Pos          11                                                      /*!< SCT EV7_STATE: STATEMSK11 Position      */
#define SCT_EV7_STATE_STATEMSK11_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK11_Pos)                /*!< SCT EV7_STATE: STATEMSK11 Mask          */
#define SCT_EV7_STATE_STATEMSK12_Pos          12                                                      /*!< SCT EV7_STATE: STATEMSK12 Position      */
#define SCT_EV7_STATE_STATEMSK12_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK12_Pos)                /*!< SCT EV7_STATE: STATEMSK12 Mask          */
#define SCT_EV7_STATE_STATEMSK13_Pos          13                                                      /*!< SCT EV7_STATE: STATEMSK13 Position      */
#define SCT_EV7_STATE_STATEMSK13_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK13_Pos)                /*!< SCT EV7_STATE: STATEMSK13 Mask          */
#define SCT_EV7_STATE_STATEMSK14_Pos          14                                                      /*!< SCT EV7_STATE: STATEMSK14 Position      */
#define SCT_EV7_STATE_STATEMSK14_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK14_Pos)                /*!< SCT EV7_STATE: STATEMSK14 Mask          */
#define SCT_EV7_STATE_STATEMSK15_Pos          15                                                      /*!< SCT EV7_STATE: STATEMSK15 Position      */
#define SCT_EV7_STATE_STATEMSK15_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK15_Pos)                /*!< SCT EV7_STATE: STATEMSK15 Mask          */
#define SCT_EV7_STATE_STATEMSK16_Pos          16                                                      /*!< SCT EV7_STATE: STATEMSK16 Position      */
#define SCT_EV7_STATE_STATEMSK16_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK16_Pos)                /*!< SCT EV7_STATE: STATEMSK16 Mask          */
#define SCT_EV7_STATE_STATEMSK17_Pos          17                                                      /*!< SCT EV7_STATE: STATEMSK17 Position      */
#define SCT_EV7_STATE_STATEMSK17_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK17_Pos)                /*!< SCT EV7_STATE: STATEMSK17 Mask          */
#define SCT_EV7_STATE_STATEMSK18_Pos          18                                                      /*!< SCT EV7_STATE: STATEMSK18 Position      */
#define SCT_EV7_STATE_STATEMSK18_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK18_Pos)                /*!< SCT EV7_STATE: STATEMSK18 Mask          */
#define SCT_EV7_STATE_STATEMSK19_Pos          19                                                      /*!< SCT EV7_STATE: STATEMSK19 Position      */
#define SCT_EV7_STATE_STATEMSK19_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK19_Pos)                /*!< SCT EV7_STATE: STATEMSK19 Mask          */
#define SCT_EV7_STATE_STATEMSK20_Pos          20                                                      /*!< SCT EV7_STATE: STATEMSK20 Position      */
#define SCT_EV7_STATE_STATEMSK20_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK20_Pos)                /*!< SCT EV7_STATE: STATEMSK20 Mask          */
#define SCT_EV7_STATE_STATEMSK21_Pos          21                                                      /*!< SCT EV7_STATE: STATEMSK21 Position      */
#define SCT_EV7_STATE_STATEMSK21_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK21_Pos)                /*!< SCT EV7_STATE: STATEMSK21 Mask          */
#define SCT_EV7_STATE_STATEMSK22_Pos          22                                                      /*!< SCT EV7_STATE: STATEMSK22 Position      */
#define SCT_EV7_STATE_STATEMSK22_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK22_Pos)                /*!< SCT EV7_STATE: STATEMSK22 Mask          */
#define SCT_EV7_STATE_STATEMSK23_Pos          23                                                      /*!< SCT EV7_STATE: STATEMSK23 Position      */
#define SCT_EV7_STATE_STATEMSK23_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK23_Pos)                /*!< SCT EV7_STATE: STATEMSK23 Mask          */
#define SCT_EV7_STATE_STATEMSK24_Pos          24                                                      /*!< SCT EV7_STATE: STATEMSK24 Position      */
#define SCT_EV7_STATE_STATEMSK24_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK24_Pos)                /*!< SCT EV7_STATE: STATEMSK24 Mask          */
#define SCT_EV7_STATE_STATEMSK25_Pos          25                                                      /*!< SCT EV7_STATE: STATEMSK25 Position      */
#define SCT_EV7_STATE_STATEMSK25_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK25_Pos)                /*!< SCT EV7_STATE: STATEMSK25 Mask          */
#define SCT_EV7_STATE_STATEMSK26_Pos          26                                                      /*!< SCT EV7_STATE: STATEMSK26 Position      */
#define SCT_EV7_STATE_STATEMSK26_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK26_Pos)                /*!< SCT EV7_STATE: STATEMSK26 Mask          */
#define SCT_EV7_STATE_STATEMSK27_Pos          27                                                      /*!< SCT EV7_STATE: STATEMSK27 Position      */
#define SCT_EV7_STATE_STATEMSK27_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK27_Pos)                /*!< SCT EV7_STATE: STATEMSK27 Mask          */
#define SCT_EV7_STATE_STATEMSK28_Pos          28                                                      /*!< SCT EV7_STATE: STATEMSK28 Position      */
#define SCT_EV7_STATE_STATEMSK28_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK28_Pos)                /*!< SCT EV7_STATE: STATEMSK28 Mask          */
#define SCT_EV7_STATE_STATEMSK29_Pos          29                                                      /*!< SCT EV7_STATE: STATEMSK29 Position      */
#define SCT_EV7_STATE_STATEMSK29_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK29_Pos)                /*!< SCT EV7_STATE: STATEMSK29 Mask          */
#define SCT_EV7_STATE_STATEMSK30_Pos          30                                                      /*!< SCT EV7_STATE: STATEMSK30 Position      */
#define SCT_EV7_STATE_STATEMSK30_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK30_Pos)                /*!< SCT EV7_STATE: STATEMSK30 Mask          */
#define SCT_EV7_STATE_STATEMSK31_Pos          31                                                      /*!< SCT EV7_STATE: STATEMSK31 Position      */
#define SCT_EV7_STATE_STATEMSK31_Msk          (0x01UL << SCT_EV7_STATE_STATEMSK31_Pos)                /*!< SCT EV7_STATE: STATEMSK31 Mask          */

/* --------------------------------  SCT_EV7_CTRL  -------------------------------- */
#define SCT_EV7_CTRL_MATCHSEL_Pos             0                                                       /*!< SCT EV7_CTRL: MATCHSEL Position         */
#define SCT_EV7_CTRL_MATCHSEL_Msk             (0x0fUL << SCT_EV7_CTRL_MATCHSEL_Pos)                   /*!< SCT EV7_CTRL: MATCHSEL Mask             */
#define SCT_EV7_CTRL_HEVENT_Pos               4                                                       /*!< SCT EV7_CTRL: HEVENT Position           */
#define SCT_EV7_CTRL_HEVENT_Msk               (0x01UL << SCT_EV7_CTRL_HEVENT_Pos)                     /*!< SCT EV7_CTRL: HEVENT Mask               */
#define SCT_EV7_CTRL_OUTSEL_Pos               5                                                       /*!< SCT EV7_CTRL: OUTSEL Position           */
#define SCT_EV7_CTRL_OUTSEL_Msk               (0x01UL << SCT_EV7_CTRL_OUTSEL_Pos)                     /*!< SCT EV7_CTRL: OUTSEL Mask               */
#define SCT_EV7_CTRL_IOSEL_Pos                6                                                       /*!< SCT EV7_CTRL: IOSEL Position            */
#define SCT_EV7_CTRL_IOSEL_Msk                (0x0fUL << SCT_EV7_CTRL_IOSEL_Pos)                      /*!< SCT EV7_CTRL: IOSEL Mask                */
#define SCT_EV7_CTRL_IOCOND_Pos               10                                                      /*!< SCT EV7_CTRL: IOCOND Position           */
#define SCT_EV7_CTRL_IOCOND_Msk               (0x03UL << SCT_EV7_CTRL_IOCOND_Pos)                     /*!< SCT EV7_CTRL: IOCOND Mask               */
#define SCT_EV7_CTRL_COMBMODE_Pos             12                                                      /*!< SCT EV7_CTRL: COMBMODE Position         */
#define SCT_EV7_CTRL_COMBMODE_Msk             (0x03UL << SCT_EV7_CTRL_COMBMODE_Pos)                   /*!< SCT EV7_CTRL: COMBMODE Mask             */
#define SCT_EV7_CTRL_STATELD_Pos              14                                                      /*!< SCT EV7_CTRL: STATELD Position          */
#define SCT_EV7_CTRL_STATELD_Msk              (0x01UL << SCT_EV7_CTRL_STATELD_Pos)                    /*!< SCT EV7_CTRL: STATELD Mask              */
#define SCT_EV7_CTRL_STATEV_Pos               15                                                      /*!< SCT EV7_CTRL: STATEV Position           */
#define SCT_EV7_CTRL_STATEV_Msk               (0x1fUL << SCT_EV7_CTRL_STATEV_Pos)                     /*!< SCT EV7_CTRL: STATEV Mask               */
#define SCT_EV7_CTRL_MATCHMEM_Pos             20                                                      /*!< SCT EV7_CTRL: MATCHMEM Position         */
#define SCT_EV7_CTRL_MATCHMEM_Msk             (0x01UL << SCT_EV7_CTRL_MATCHMEM_Pos)                   /*!< SCT EV7_CTRL: MATCHMEM Mask             */
#define SCT_EV7_CTRL_DIRECTION_Pos            21                                                      /*!< SCT EV7_CTRL: DIRECTION Position        */
#define SCT_EV7_CTRL_DIRECTION_Msk            (0x03UL << SCT_EV7_CTRL_DIRECTION_Pos)                  /*!< SCT EV7_CTRL: DIRECTION Mask            */

/* --------------------------------  SCT_EV8_STATE  ------------------------------- */
#define SCT_EV8_STATE_STATEMSK0_Pos           0                                                       /*!< SCT EV8_STATE: STATEMSK0 Position       */
#define SCT_EV8_STATE_STATEMSK0_Msk           (0x01UL << SCT_EV8_STATE_STATEMSK0_Pos)                 /*!< SCT EV8_STATE: STATEMSK0 Mask           */
#define SCT_EV8_STATE_STATEMSK1_Pos           1                                                       /*!< SCT EV8_STATE: STATEMSK1 Position       */
#define SCT_EV8_STATE_STATEMSK1_Msk           (0x01UL << SCT_EV8_STATE_STATEMSK1_Pos)                 /*!< SCT EV8_STATE: STATEMSK1 Mask           */
#define SCT_EV8_STATE_STATEMSK2_Pos           2                                                       /*!< SCT EV8_STATE: STATEMSK2 Position       */
#define SCT_EV8_STATE_STATEMSK2_Msk           (0x01UL << SCT_EV8_STATE_STATEMSK2_Pos)                 /*!< SCT EV8_STATE: STATEMSK2 Mask           */
#define SCT_EV8_STATE_STATEMSK3_Pos           3                                                       /*!< SCT EV8_STATE: STATEMSK3 Position       */
#define SCT_EV8_STATE_STATEMSK3_Msk           (0x01UL << SCT_EV8_STATE_STATEMSK3_Pos)                 /*!< SCT EV8_STATE: STATEMSK3 Mask           */
#define SCT_EV8_STATE_STATEMSK4_Pos           4                                                       /*!< SCT EV8_STATE: STATEMSK4 Position       */
#define SCT_EV8_STATE_STATEMSK4_Msk           (0x01UL << SCT_EV8_STATE_STATEMSK4_Pos)                 /*!< SCT EV8_STATE: STATEMSK4 Mask           */
#define SCT_EV8_STATE_STATEMSK5_Pos           5                                                       /*!< SCT EV8_STATE: STATEMSK5 Position       */
#define SCT_EV8_STATE_STATEMSK5_Msk           (0x01UL << SCT_EV8_STATE_STATEMSK5_Pos)                 /*!< SCT EV8_STATE: STATEMSK5 Mask           */
#define SCT_EV8_STATE_STATEMSK6_Pos           6                                                       /*!< SCT EV8_STATE: STATEMSK6 Position       */
#define SCT_EV8_STATE_STATEMSK6_Msk           (0x01UL << SCT_EV8_STATE_STATEMSK6_Pos)                 /*!< SCT EV8_STATE: STATEMSK6 Mask           */
#define SCT_EV8_STATE_STATEMSK7_Pos           7                                                       /*!< SCT EV8_STATE: STATEMSK7 Position       */
#define SCT_EV8_STATE_STATEMSK7_Msk           (0x01UL << SCT_EV8_STATE_STATEMSK7_Pos)                 /*!< SCT EV8_STATE: STATEMSK7 Mask           */
#define SCT_EV8_STATE_STATEMSK8_Pos           8                                                       /*!< SCT EV8_STATE: STATEMSK8 Position       */
#define SCT_EV8_STATE_STATEMSK8_Msk           (0x01UL << SCT_EV8_STATE_STATEMSK8_Pos)                 /*!< SCT EV8_STATE: STATEMSK8 Mask           */
#define SCT_EV8_STATE_STATEMSK9_Pos           9                                                       /*!< SCT EV8_STATE: STATEMSK9 Position       */
#define SCT_EV8_STATE_STATEMSK9_Msk           (0x01UL << SCT_EV8_STATE_STATEMSK9_Pos)                 /*!< SCT EV8_STATE: STATEMSK9 Mask           */
#define SCT_EV8_STATE_STATEMSK10_Pos          10                                                      /*!< SCT EV8_STATE: STATEMSK10 Position      */
#define SCT_EV8_STATE_STATEMSK10_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK10_Pos)                /*!< SCT EV8_STATE: STATEMSK10 Mask          */
#define SCT_EV8_STATE_STATEMSK11_Pos          11                                                      /*!< SCT EV8_STATE: STATEMSK11 Position      */
#define SCT_EV8_STATE_STATEMSK11_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK11_Pos)                /*!< SCT EV8_STATE: STATEMSK11 Mask          */
#define SCT_EV8_STATE_STATEMSK12_Pos          12                                                      /*!< SCT EV8_STATE: STATEMSK12 Position      */
#define SCT_EV8_STATE_STATEMSK12_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK12_Pos)                /*!< SCT EV8_STATE: STATEMSK12 Mask          */
#define SCT_EV8_STATE_STATEMSK13_Pos          13                                                      /*!< SCT EV8_STATE: STATEMSK13 Position      */
#define SCT_EV8_STATE_STATEMSK13_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK13_Pos)                /*!< SCT EV8_STATE: STATEMSK13 Mask          */
#define SCT_EV8_STATE_STATEMSK14_Pos          14                                                      /*!< SCT EV8_STATE: STATEMSK14 Position      */
#define SCT_EV8_STATE_STATEMSK14_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK14_Pos)                /*!< SCT EV8_STATE: STATEMSK14 Mask          */
#define SCT_EV8_STATE_STATEMSK15_Pos          15                                                      /*!< SCT EV8_STATE: STATEMSK15 Position      */
#define SCT_EV8_STATE_STATEMSK15_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK15_Pos)                /*!< SCT EV8_STATE: STATEMSK15 Mask          */
#define SCT_EV8_STATE_STATEMSK16_Pos          16                                                      /*!< SCT EV8_STATE: STATEMSK16 Position      */
#define SCT_EV8_STATE_STATEMSK16_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK16_Pos)                /*!< SCT EV8_STATE: STATEMSK16 Mask          */
#define SCT_EV8_STATE_STATEMSK17_Pos          17                                                      /*!< SCT EV8_STATE: STATEMSK17 Position      */
#define SCT_EV8_STATE_STATEMSK17_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK17_Pos)                /*!< SCT EV8_STATE: STATEMSK17 Mask          */
#define SCT_EV8_STATE_STATEMSK18_Pos          18                                                      /*!< SCT EV8_STATE: STATEMSK18 Position      */
#define SCT_EV8_STATE_STATEMSK18_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK18_Pos)                /*!< SCT EV8_STATE: STATEMSK18 Mask          */
#define SCT_EV8_STATE_STATEMSK19_Pos          19                                                      /*!< SCT EV8_STATE: STATEMSK19 Position      */
#define SCT_EV8_STATE_STATEMSK19_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK19_Pos)                /*!< SCT EV8_STATE: STATEMSK19 Mask          */
#define SCT_EV8_STATE_STATEMSK20_Pos          20                                                      /*!< SCT EV8_STATE: STATEMSK20 Position      */
#define SCT_EV8_STATE_STATEMSK20_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK20_Pos)                /*!< SCT EV8_STATE: STATEMSK20 Mask          */
#define SCT_EV8_STATE_STATEMSK21_Pos          21                                                      /*!< SCT EV8_STATE: STATEMSK21 Position      */
#define SCT_EV8_STATE_STATEMSK21_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK21_Pos)                /*!< SCT EV8_STATE: STATEMSK21 Mask          */
#define SCT_EV8_STATE_STATEMSK22_Pos          22                                                      /*!< SCT EV8_STATE: STATEMSK22 Position      */
#define SCT_EV8_STATE_STATEMSK22_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK22_Pos)                /*!< SCT EV8_STATE: STATEMSK22 Mask          */
#define SCT_EV8_STATE_STATEMSK23_Pos          23                                                      /*!< SCT EV8_STATE: STATEMSK23 Position      */
#define SCT_EV8_STATE_STATEMSK23_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK23_Pos)                /*!< SCT EV8_STATE: STATEMSK23 Mask          */
#define SCT_EV8_STATE_STATEMSK24_Pos          24                                                      /*!< SCT EV8_STATE: STATEMSK24 Position      */
#define SCT_EV8_STATE_STATEMSK24_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK24_Pos)                /*!< SCT EV8_STATE: STATEMSK24 Mask          */
#define SCT_EV8_STATE_STATEMSK25_Pos          25                                                      /*!< SCT EV8_STATE: STATEMSK25 Position      */
#define SCT_EV8_STATE_STATEMSK25_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK25_Pos)                /*!< SCT EV8_STATE: STATEMSK25 Mask          */
#define SCT_EV8_STATE_STATEMSK26_Pos          26                                                      /*!< SCT EV8_STATE: STATEMSK26 Position      */
#define SCT_EV8_STATE_STATEMSK26_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK26_Pos)                /*!< SCT EV8_STATE: STATEMSK26 Mask          */
#define SCT_EV8_STATE_STATEMSK27_Pos          27                                                      /*!< SCT EV8_STATE: STATEMSK27 Position      */
#define SCT_EV8_STATE_STATEMSK27_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK27_Pos)                /*!< SCT EV8_STATE: STATEMSK27 Mask          */
#define SCT_EV8_STATE_STATEMSK28_Pos          28                                                      /*!< SCT EV8_STATE: STATEMSK28 Position      */
#define SCT_EV8_STATE_STATEMSK28_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK28_Pos)                /*!< SCT EV8_STATE: STATEMSK28 Mask          */
#define SCT_EV8_STATE_STATEMSK29_Pos          29                                                      /*!< SCT EV8_STATE: STATEMSK29 Position      */
#define SCT_EV8_STATE_STATEMSK29_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK29_Pos)                /*!< SCT EV8_STATE: STATEMSK29 Mask          */
#define SCT_EV8_STATE_STATEMSK30_Pos          30                                                      /*!< SCT EV8_STATE: STATEMSK30 Position      */
#define SCT_EV8_STATE_STATEMSK30_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK30_Pos)                /*!< SCT EV8_STATE: STATEMSK30 Mask          */
#define SCT_EV8_STATE_STATEMSK31_Pos          31                                                      /*!< SCT EV8_STATE: STATEMSK31 Position      */
#define SCT_EV8_STATE_STATEMSK31_Msk          (0x01UL << SCT_EV8_STATE_STATEMSK31_Pos)                /*!< SCT EV8_STATE: STATEMSK31 Mask          */

/* --------------------------------  SCT_EV8_CTRL  -------------------------------- */
#define SCT_EV8_CTRL_MATCHSEL_Pos             0                                                       /*!< SCT EV8_CTRL: MATCHSEL Position         */
#define SCT_EV8_CTRL_MATCHSEL_Msk             (0x0fUL << SCT_EV8_CTRL_MATCHSEL_Pos)                   /*!< SCT EV8_CTRL: MATCHSEL Mask             */
#define SCT_EV8_CTRL_HEVENT_Pos               4                                                       /*!< SCT EV8_CTRL: HEVENT Position           */
#define SCT_EV8_CTRL_HEVENT_Msk               (0x01UL << SCT_EV8_CTRL_HEVENT_Pos)                     /*!< SCT EV8_CTRL: HEVENT Mask               */
#define SCT_EV8_CTRL_OUTSEL_Pos               5                                                       /*!< SCT EV8_CTRL: OUTSEL Position           */
#define SCT_EV8_CTRL_OUTSEL_Msk               (0x01UL << SCT_EV8_CTRL_OUTSEL_Pos)                     /*!< SCT EV8_CTRL: OUTSEL Mask               */
#define SCT_EV8_CTRL_IOSEL_Pos                6                                                       /*!< SCT EV8_CTRL: IOSEL Position            */
#define SCT_EV8_CTRL_IOSEL_Msk                (0x0fUL << SCT_EV8_CTRL_IOSEL_Pos)                      /*!< SCT EV8_CTRL: IOSEL Mask                */
#define SCT_EV8_CTRL_IOCOND_Pos               10                                                      /*!< SCT EV8_CTRL: IOCOND Position           */
#define SCT_EV8_CTRL_IOCOND_Msk               (0x03UL << SCT_EV8_CTRL_IOCOND_Pos)                     /*!< SCT EV8_CTRL: IOCOND Mask               */
#define SCT_EV8_CTRL_COMBMODE_Pos             12                                                      /*!< SCT EV8_CTRL: COMBMODE Position         */
#define SCT_EV8_CTRL_COMBMODE_Msk             (0x03UL << SCT_EV8_CTRL_COMBMODE_Pos)                   /*!< SCT EV8_CTRL: COMBMODE Mask             */
#define SCT_EV8_CTRL_STATELD_Pos              14                                                      /*!< SCT EV8_CTRL: STATELD Position          */
#define SCT_EV8_CTRL_STATELD_Msk              (0x01UL << SCT_EV8_CTRL_STATELD_Pos)                    /*!< SCT EV8_CTRL: STATELD Mask              */
#define SCT_EV8_CTRL_STATEV_Pos               15                                                      /*!< SCT EV8_CTRL: STATEV Position           */
#define SCT_EV8_CTRL_STATEV_Msk               (0x1fUL << SCT_EV8_CTRL_STATEV_Pos)                     /*!< SCT EV8_CTRL: STATEV Mask               */
#define SCT_EV8_CTRL_MATCHMEM_Pos             20                                                      /*!< SCT EV8_CTRL: MATCHMEM Position         */
#define SCT_EV8_CTRL_MATCHMEM_Msk             (0x01UL << SCT_EV8_CTRL_MATCHMEM_Pos)                   /*!< SCT EV8_CTRL: MATCHMEM Mask             */
#define SCT_EV8_CTRL_DIRECTION_Pos            21                                                      /*!< SCT EV8_CTRL: DIRECTION Position        */
#define SCT_EV8_CTRL_DIRECTION_Msk            (0x03UL << SCT_EV8_CTRL_DIRECTION_Pos)                  /*!< SCT EV8_CTRL: DIRECTION Mask            */

/* --------------------------------  SCT_EV9_STATE  ------------------------------- */
#define SCT_EV9_STATE_STATEMSK0_Pos           0                                                       /*!< SCT EV9_STATE: STATEMSK0 Position       */
#define SCT_EV9_STATE_STATEMSK0_Msk           (0x01UL << SCT_EV9_STATE_STATEMSK0_Pos)                 /*!< SCT EV9_STATE: STATEMSK0 Mask           */
#define SCT_EV9_STATE_STATEMSK1_Pos           1                                                       /*!< SCT EV9_STATE: STATEMSK1 Position       */
#define SCT_EV9_STATE_STATEMSK1_Msk           (0x01UL << SCT_EV9_STATE_STATEMSK1_Pos)                 /*!< SCT EV9_STATE: STATEMSK1 Mask           */
#define SCT_EV9_STATE_STATEMSK2_Pos           2                                                       /*!< SCT EV9_STATE: STATEMSK2 Position       */
#define SCT_EV9_STATE_STATEMSK2_Msk           (0x01UL << SCT_EV9_STATE_STATEMSK2_Pos)                 /*!< SCT EV9_STATE: STATEMSK2 Mask           */
#define SCT_EV9_STATE_STATEMSK3_Pos           3                                                       /*!< SCT EV9_STATE: STATEMSK3 Position       */
#define SCT_EV9_STATE_STATEMSK3_Msk           (0x01UL << SCT_EV9_STATE_STATEMSK3_Pos)                 /*!< SCT EV9_STATE: STATEMSK3 Mask           */
#define SCT_EV9_STATE_STATEMSK4_Pos           4                                                       /*!< SCT EV9_STATE: STATEMSK4 Position       */
#define SCT_EV9_STATE_STATEMSK4_Msk           (0x01UL << SCT_EV9_STATE_STATEMSK4_Pos)                 /*!< SCT EV9_STATE: STATEMSK4 Mask           */
#define SCT_EV9_STATE_STATEMSK5_Pos           5                                                       /*!< SCT EV9_STATE: STATEMSK5 Position       */
#define SCT_EV9_STATE_STATEMSK5_Msk           (0x01UL << SCT_EV9_STATE_STATEMSK5_Pos)                 /*!< SCT EV9_STATE: STATEMSK5 Mask           */
#define SCT_EV9_STATE_STATEMSK6_Pos           6                                                       /*!< SCT EV9_STATE: STATEMSK6 Position       */
#define SCT_EV9_STATE_STATEMSK6_Msk           (0x01UL << SCT_EV9_STATE_STATEMSK6_Pos)                 /*!< SCT EV9_STATE: STATEMSK6 Mask           */
#define SCT_EV9_STATE_STATEMSK7_Pos           7                                                       /*!< SCT EV9_STATE: STATEMSK7 Position       */
#define SCT_EV9_STATE_STATEMSK7_Msk           (0x01UL << SCT_EV9_STATE_STATEMSK7_Pos)                 /*!< SCT EV9_STATE: STATEMSK7 Mask           */
#define SCT_EV9_STATE_STATEMSK8_Pos           8                                                       /*!< SCT EV9_STATE: STATEMSK8 Position       */
#define SCT_EV9_STATE_STATEMSK8_Msk           (0x01UL << SCT_EV9_STATE_STATEMSK8_Pos)                 /*!< SCT EV9_STATE: STATEMSK8 Mask           */
#define SCT_EV9_STATE_STATEMSK9_Pos           9                                                       /*!< SCT EV9_STATE: STATEMSK9 Position       */
#define SCT_EV9_STATE_STATEMSK9_Msk           (0x01UL << SCT_EV9_STATE_STATEMSK9_Pos)                 /*!< SCT EV9_STATE: STATEMSK9 Mask           */
#define SCT_EV9_STATE_STATEMSK10_Pos          10                                                      /*!< SCT EV9_STATE: STATEMSK10 Position      */
#define SCT_EV9_STATE_STATEMSK10_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK10_Pos)                /*!< SCT EV9_STATE: STATEMSK10 Mask          */
#define SCT_EV9_STATE_STATEMSK11_Pos          11                                                      /*!< SCT EV9_STATE: STATEMSK11 Position      */
#define SCT_EV9_STATE_STATEMSK11_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK11_Pos)                /*!< SCT EV9_STATE: STATEMSK11 Mask          */
#define SCT_EV9_STATE_STATEMSK12_Pos          12                                                      /*!< SCT EV9_STATE: STATEMSK12 Position      */
#define SCT_EV9_STATE_STATEMSK12_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK12_Pos)                /*!< SCT EV9_STATE: STATEMSK12 Mask          */
#define SCT_EV9_STATE_STATEMSK13_Pos          13                                                      /*!< SCT EV9_STATE: STATEMSK13 Position      */
#define SCT_EV9_STATE_STATEMSK13_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK13_Pos)                /*!< SCT EV9_STATE: STATEMSK13 Mask          */
#define SCT_EV9_STATE_STATEMSK14_Pos          14                                                      /*!< SCT EV9_STATE: STATEMSK14 Position      */
#define SCT_EV9_STATE_STATEMSK14_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK14_Pos)                /*!< SCT EV9_STATE: STATEMSK14 Mask          */
#define SCT_EV9_STATE_STATEMSK15_Pos          15                                                      /*!< SCT EV9_STATE: STATEMSK15 Position      */
#define SCT_EV9_STATE_STATEMSK15_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK15_Pos)                /*!< SCT EV9_STATE: STATEMSK15 Mask          */
#define SCT_EV9_STATE_STATEMSK16_Pos          16                                                      /*!< SCT EV9_STATE: STATEMSK16 Position      */
#define SCT_EV9_STATE_STATEMSK16_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK16_Pos)                /*!< SCT EV9_STATE: STATEMSK16 Mask          */
#define SCT_EV9_STATE_STATEMSK17_Pos          17                                                      /*!< SCT EV9_STATE: STATEMSK17 Position      */
#define SCT_EV9_STATE_STATEMSK17_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK17_Pos)                /*!< SCT EV9_STATE: STATEMSK17 Mask          */
#define SCT_EV9_STATE_STATEMSK18_Pos          18                                                      /*!< SCT EV9_STATE: STATEMSK18 Position      */
#define SCT_EV9_STATE_STATEMSK18_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK18_Pos)                /*!< SCT EV9_STATE: STATEMSK18 Mask          */
#define SCT_EV9_STATE_STATEMSK19_Pos          19                                                      /*!< SCT EV9_STATE: STATEMSK19 Position      */
#define SCT_EV9_STATE_STATEMSK19_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK19_Pos)                /*!< SCT EV9_STATE: STATEMSK19 Mask          */
#define SCT_EV9_STATE_STATEMSK20_Pos          20                                                      /*!< SCT EV9_STATE: STATEMSK20 Position      */
#define SCT_EV9_STATE_STATEMSK20_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK20_Pos)                /*!< SCT EV9_STATE: STATEMSK20 Mask          */
#define SCT_EV9_STATE_STATEMSK21_Pos          21                                                      /*!< SCT EV9_STATE: STATEMSK21 Position      */
#define SCT_EV9_STATE_STATEMSK21_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK21_Pos)                /*!< SCT EV9_STATE: STATEMSK21 Mask          */
#define SCT_EV9_STATE_STATEMSK22_Pos          22                                                      /*!< SCT EV9_STATE: STATEMSK22 Position      */
#define SCT_EV9_STATE_STATEMSK22_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK22_Pos)                /*!< SCT EV9_STATE: STATEMSK22 Mask          */
#define SCT_EV9_STATE_STATEMSK23_Pos          23                                                      /*!< SCT EV9_STATE: STATEMSK23 Position      */
#define SCT_EV9_STATE_STATEMSK23_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK23_Pos)                /*!< SCT EV9_STATE: STATEMSK23 Mask          */
#define SCT_EV9_STATE_STATEMSK24_Pos          24                                                      /*!< SCT EV9_STATE: STATEMSK24 Position      */
#define SCT_EV9_STATE_STATEMSK24_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK24_Pos)                /*!< SCT EV9_STATE: STATEMSK24 Mask          */
#define SCT_EV9_STATE_STATEMSK25_Pos          25                                                      /*!< SCT EV9_STATE: STATEMSK25 Position      */
#define SCT_EV9_STATE_STATEMSK25_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK25_Pos)                /*!< SCT EV9_STATE: STATEMSK25 Mask          */
#define SCT_EV9_STATE_STATEMSK26_Pos          26                                                      /*!< SCT EV9_STATE: STATEMSK26 Position      */
#define SCT_EV9_STATE_STATEMSK26_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK26_Pos)                /*!< SCT EV9_STATE: STATEMSK26 Mask          */
#define SCT_EV9_STATE_STATEMSK27_Pos          27                                                      /*!< SCT EV9_STATE: STATEMSK27 Position      */
#define SCT_EV9_STATE_STATEMSK27_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK27_Pos)                /*!< SCT EV9_STATE: STATEMSK27 Mask          */
#define SCT_EV9_STATE_STATEMSK28_Pos          28                                                      /*!< SCT EV9_STATE: STATEMSK28 Position      */
#define SCT_EV9_STATE_STATEMSK28_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK28_Pos)                /*!< SCT EV9_STATE: STATEMSK28 Mask          */
#define SCT_EV9_STATE_STATEMSK29_Pos          29                                                      /*!< SCT EV9_STATE: STATEMSK29 Position      */
#define SCT_EV9_STATE_STATEMSK29_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK29_Pos)                /*!< SCT EV9_STATE: STATEMSK29 Mask          */
#define SCT_EV9_STATE_STATEMSK30_Pos          30                                                      /*!< SCT EV9_STATE: STATEMSK30 Position      */
#define SCT_EV9_STATE_STATEMSK30_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK30_Pos)                /*!< SCT EV9_STATE: STATEMSK30 Mask          */
#define SCT_EV9_STATE_STATEMSK31_Pos          31                                                      /*!< SCT EV9_STATE: STATEMSK31 Position      */
#define SCT_EV9_STATE_STATEMSK31_Msk          (0x01UL << SCT_EV9_STATE_STATEMSK31_Pos)                /*!< SCT EV9_STATE: STATEMSK31 Mask          */

/* --------------------------------  SCT_EV9_CTRL  -------------------------------- */
#define SCT_EV9_CTRL_MATCHSEL_Pos             0                                                       /*!< SCT EV9_CTRL: MATCHSEL Position         */
#define SCT_EV9_CTRL_MATCHSEL_Msk             (0x0fUL << SCT_EV9_CTRL_MATCHSEL_Pos)                   /*!< SCT EV9_CTRL: MATCHSEL Mask             */
#define SCT_EV9_CTRL_HEVENT_Pos               4                                                       /*!< SCT EV9_CTRL: HEVENT Position           */
#define SCT_EV9_CTRL_HEVENT_Msk               (0x01UL << SCT_EV9_CTRL_HEVENT_Pos)                     /*!< SCT EV9_CTRL: HEVENT Mask               */
#define SCT_EV9_CTRL_OUTSEL_Pos               5                                                       /*!< SCT EV9_CTRL: OUTSEL Position           */
#define SCT_EV9_CTRL_OUTSEL_Msk               (0x01UL << SCT_EV9_CTRL_OUTSEL_Pos)                     /*!< SCT EV9_CTRL: OUTSEL Mask               */
#define SCT_EV9_CTRL_IOSEL_Pos                6                                                       /*!< SCT EV9_CTRL: IOSEL Position            */
#define SCT_EV9_CTRL_IOSEL_Msk                (0x0fUL << SCT_EV9_CTRL_IOSEL_Pos)                      /*!< SCT EV9_CTRL: IOSEL Mask                */
#define SCT_EV9_CTRL_IOCOND_Pos               10                                                      /*!< SCT EV9_CTRL: IOCOND Position           */
#define SCT_EV9_CTRL_IOCOND_Msk               (0x03UL << SCT_EV9_CTRL_IOCOND_Pos)                     /*!< SCT EV9_CTRL: IOCOND Mask               */
#define SCT_EV9_CTRL_COMBMODE_Pos             12                                                      /*!< SCT EV9_CTRL: COMBMODE Position         */
#define SCT_EV9_CTRL_COMBMODE_Msk             (0x03UL << SCT_EV9_CTRL_COMBMODE_Pos)                   /*!< SCT EV9_CTRL: COMBMODE Mask             */
#define SCT_EV9_CTRL_STATELD_Pos              14                                                      /*!< SCT EV9_CTRL: STATELD Position          */
#define SCT_EV9_CTRL_STATELD_Msk              (0x01UL << SCT_EV9_CTRL_STATELD_Pos)                    /*!< SCT EV9_CTRL: STATELD Mask              */
#define SCT_EV9_CTRL_STATEV_Pos               15                                                      /*!< SCT EV9_CTRL: STATEV Position           */
#define SCT_EV9_CTRL_STATEV_Msk               (0x1fUL << SCT_EV9_CTRL_STATEV_Pos)                     /*!< SCT EV9_CTRL: STATEV Mask               */
#define SCT_EV9_CTRL_MATCHMEM_Pos             20                                                      /*!< SCT EV9_CTRL: MATCHMEM Position         */
#define SCT_EV9_CTRL_MATCHMEM_Msk             (0x01UL << SCT_EV9_CTRL_MATCHMEM_Pos)                   /*!< SCT EV9_CTRL: MATCHMEM Mask             */
#define SCT_EV9_CTRL_DIRECTION_Pos            21                                                      /*!< SCT EV9_CTRL: DIRECTION Position        */
#define SCT_EV9_CTRL_DIRECTION_Msk            (0x03UL << SCT_EV9_CTRL_DIRECTION_Pos)                  /*!< SCT EV9_CTRL: DIRECTION Mask            */

/* -------------------------------  SCT_EV10_STATE  ------------------------------- */
#define SCT_EV10_STATE_STATEMSK0_Pos          0                                                       /*!< SCT EV10_STATE: STATEMSK0 Position      */
#define SCT_EV10_STATE_STATEMSK0_Msk          (0x01UL << SCT_EV10_STATE_STATEMSK0_Pos)                /*!< SCT EV10_STATE: STATEMSK0 Mask          */
#define SCT_EV10_STATE_STATEMSK1_Pos          1                                                       /*!< SCT EV10_STATE: STATEMSK1 Position      */
#define SCT_EV10_STATE_STATEMSK1_Msk          (0x01UL << SCT_EV10_STATE_STATEMSK1_Pos)                /*!< SCT EV10_STATE: STATEMSK1 Mask          */
#define SCT_EV10_STATE_STATEMSK2_Pos          2                                                       /*!< SCT EV10_STATE: STATEMSK2 Position      */
#define SCT_EV10_STATE_STATEMSK2_Msk          (0x01UL << SCT_EV10_STATE_STATEMSK2_Pos)                /*!< SCT EV10_STATE: STATEMSK2 Mask          */
#define SCT_EV10_STATE_STATEMSK3_Pos          3                                                       /*!< SCT EV10_STATE: STATEMSK3 Position      */
#define SCT_EV10_STATE_STATEMSK3_Msk          (0x01UL << SCT_EV10_STATE_STATEMSK3_Pos)                /*!< SCT EV10_STATE: STATEMSK3 Mask          */
#define SCT_EV10_STATE_STATEMSK4_Pos          4                                                       /*!< SCT EV10_STATE: STATEMSK4 Position      */
#define SCT_EV10_STATE_STATEMSK4_Msk          (0x01UL << SCT_EV10_STATE_STATEMSK4_Pos)                /*!< SCT EV10_STATE: STATEMSK4 Mask          */
#define SCT_EV10_STATE_STATEMSK5_Pos          5                                                       /*!< SCT EV10_STATE: STATEMSK5 Position      */
#define SCT_EV10_STATE_STATEMSK5_Msk          (0x01UL << SCT_EV10_STATE_STATEMSK5_Pos)                /*!< SCT EV10_STATE: STATEMSK5 Mask          */
#define SCT_EV10_STATE_STATEMSK6_Pos          6                                                       /*!< SCT EV10_STATE: STATEMSK6 Position      */
#define SCT_EV10_STATE_STATEMSK6_Msk          (0x01UL << SCT_EV10_STATE_STATEMSK6_Pos)                /*!< SCT EV10_STATE: STATEMSK6 Mask          */
#define SCT_EV10_STATE_STATEMSK7_Pos          7                                                       /*!< SCT EV10_STATE: STATEMSK7 Position      */
#define SCT_EV10_STATE_STATEMSK7_Msk          (0x01UL << SCT_EV10_STATE_STATEMSK7_Pos)                /*!< SCT EV10_STATE: STATEMSK7 Mask          */
#define SCT_EV10_STATE_STATEMSK8_Pos          8                                                       /*!< SCT EV10_STATE: STATEMSK8 Position      */
#define SCT_EV10_STATE_STATEMSK8_Msk          (0x01UL << SCT_EV10_STATE_STATEMSK8_Pos)                /*!< SCT EV10_STATE: STATEMSK8 Mask          */
#define SCT_EV10_STATE_STATEMSK9_Pos          9                                                       /*!< SCT EV10_STATE: STATEMSK9 Position      */
#define SCT_EV10_STATE_STATEMSK9_Msk          (0x01UL << SCT_EV10_STATE_STATEMSK9_Pos)                /*!< SCT EV10_STATE: STATEMSK9 Mask          */
#define SCT_EV10_STATE_STATEMSK10_Pos         10                                                      /*!< SCT EV10_STATE: STATEMSK10 Position     */
#define SCT_EV10_STATE_STATEMSK10_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK10_Pos)               /*!< SCT EV10_STATE: STATEMSK10 Mask         */
#define SCT_EV10_STATE_STATEMSK11_Pos         11                                                      /*!< SCT EV10_STATE: STATEMSK11 Position     */
#define SCT_EV10_STATE_STATEMSK11_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK11_Pos)               /*!< SCT EV10_STATE: STATEMSK11 Mask         */
#define SCT_EV10_STATE_STATEMSK12_Pos         12                                                      /*!< SCT EV10_STATE: STATEMSK12 Position     */
#define SCT_EV10_STATE_STATEMSK12_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK12_Pos)               /*!< SCT EV10_STATE: STATEMSK12 Mask         */
#define SCT_EV10_STATE_STATEMSK13_Pos         13                                                      /*!< SCT EV10_STATE: STATEMSK13 Position     */
#define SCT_EV10_STATE_STATEMSK13_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK13_Pos)               /*!< SCT EV10_STATE: STATEMSK13 Mask         */
#define SCT_EV10_STATE_STATEMSK14_Pos         14                                                      /*!< SCT EV10_STATE: STATEMSK14 Position     */
#define SCT_EV10_STATE_STATEMSK14_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK14_Pos)               /*!< SCT EV10_STATE: STATEMSK14 Mask         */
#define SCT_EV10_STATE_STATEMSK15_Pos         15                                                      /*!< SCT EV10_STATE: STATEMSK15 Position     */
#define SCT_EV10_STATE_STATEMSK15_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK15_Pos)               /*!< SCT EV10_STATE: STATEMSK15 Mask         */
#define SCT_EV10_STATE_STATEMSK16_Pos         16                                                      /*!< SCT EV10_STATE: STATEMSK16 Position     */
#define SCT_EV10_STATE_STATEMSK16_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK16_Pos)               /*!< SCT EV10_STATE: STATEMSK16 Mask         */
#define SCT_EV10_STATE_STATEMSK17_Pos         17                                                      /*!< SCT EV10_STATE: STATEMSK17 Position     */
#define SCT_EV10_STATE_STATEMSK17_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK17_Pos)               /*!< SCT EV10_STATE: STATEMSK17 Mask         */
#define SCT_EV10_STATE_STATEMSK18_Pos         18                                                      /*!< SCT EV10_STATE: STATEMSK18 Position     */
#define SCT_EV10_STATE_STATEMSK18_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK18_Pos)               /*!< SCT EV10_STATE: STATEMSK18 Mask         */
#define SCT_EV10_STATE_STATEMSK19_Pos         19                                                      /*!< SCT EV10_STATE: STATEMSK19 Position     */
#define SCT_EV10_STATE_STATEMSK19_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK19_Pos)               /*!< SCT EV10_STATE: STATEMSK19 Mask         */
#define SCT_EV10_STATE_STATEMSK20_Pos         20                                                      /*!< SCT EV10_STATE: STATEMSK20 Position     */
#define SCT_EV10_STATE_STATEMSK20_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK20_Pos)               /*!< SCT EV10_STATE: STATEMSK20 Mask         */
#define SCT_EV10_STATE_STATEMSK21_Pos         21                                                      /*!< SCT EV10_STATE: STATEMSK21 Position     */
#define SCT_EV10_STATE_STATEMSK21_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK21_Pos)               /*!< SCT EV10_STATE: STATEMSK21 Mask         */
#define SCT_EV10_STATE_STATEMSK22_Pos         22                                                      /*!< SCT EV10_STATE: STATEMSK22 Position     */
#define SCT_EV10_STATE_STATEMSK22_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK22_Pos)               /*!< SCT EV10_STATE: STATEMSK22 Mask         */
#define SCT_EV10_STATE_STATEMSK23_Pos         23                                                      /*!< SCT EV10_STATE: STATEMSK23 Position     */
#define SCT_EV10_STATE_STATEMSK23_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK23_Pos)               /*!< SCT EV10_STATE: STATEMSK23 Mask         */
#define SCT_EV10_STATE_STATEMSK24_Pos         24                                                      /*!< SCT EV10_STATE: STATEMSK24 Position     */
#define SCT_EV10_STATE_STATEMSK24_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK24_Pos)               /*!< SCT EV10_STATE: STATEMSK24 Mask         */
#define SCT_EV10_STATE_STATEMSK25_Pos         25                                                      /*!< SCT EV10_STATE: STATEMSK25 Position     */
#define SCT_EV10_STATE_STATEMSK25_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK25_Pos)               /*!< SCT EV10_STATE: STATEMSK25 Mask         */
#define SCT_EV10_STATE_STATEMSK26_Pos         26                                                      /*!< SCT EV10_STATE: STATEMSK26 Position     */
#define SCT_EV10_STATE_STATEMSK26_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK26_Pos)               /*!< SCT EV10_STATE: STATEMSK26 Mask         */
#define SCT_EV10_STATE_STATEMSK27_Pos         27                                                      /*!< SCT EV10_STATE: STATEMSK27 Position     */
#define SCT_EV10_STATE_STATEMSK27_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK27_Pos)               /*!< SCT EV10_STATE: STATEMSK27 Mask         */
#define SCT_EV10_STATE_STATEMSK28_Pos         28                                                      /*!< SCT EV10_STATE: STATEMSK28 Position     */
#define SCT_EV10_STATE_STATEMSK28_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK28_Pos)               /*!< SCT EV10_STATE: STATEMSK28 Mask         */
#define SCT_EV10_STATE_STATEMSK29_Pos         29                                                      /*!< SCT EV10_STATE: STATEMSK29 Position     */
#define SCT_EV10_STATE_STATEMSK29_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK29_Pos)               /*!< SCT EV10_STATE: STATEMSK29 Mask         */
#define SCT_EV10_STATE_STATEMSK30_Pos         30                                                      /*!< SCT EV10_STATE: STATEMSK30 Position     */
#define SCT_EV10_STATE_STATEMSK30_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK30_Pos)               /*!< SCT EV10_STATE: STATEMSK30 Mask         */
#define SCT_EV10_STATE_STATEMSK31_Pos         31                                                      /*!< SCT EV10_STATE: STATEMSK31 Position     */
#define SCT_EV10_STATE_STATEMSK31_Msk         (0x01UL << SCT_EV10_STATE_STATEMSK31_Pos)               /*!< SCT EV10_STATE: STATEMSK31 Mask         */

/* --------------------------------  SCT_EV10_CTRL  ------------------------------- */
#define SCT_EV10_CTRL_MATCHSEL_Pos            0                                                       /*!< SCT EV10_CTRL: MATCHSEL Position        */
#define SCT_EV10_CTRL_MATCHSEL_Msk            (0x0fUL << SCT_EV10_CTRL_MATCHSEL_Pos)                  /*!< SCT EV10_CTRL: MATCHSEL Mask            */
#define SCT_EV10_CTRL_HEVENT_Pos              4                                                       /*!< SCT EV10_CTRL: HEVENT Position          */
#define SCT_EV10_CTRL_HEVENT_Msk              (0x01UL << SCT_EV10_CTRL_HEVENT_Pos)                    /*!< SCT EV10_CTRL: HEVENT Mask              */
#define SCT_EV10_CTRL_OUTSEL_Pos              5                                                       /*!< SCT EV10_CTRL: OUTSEL Position          */
#define SCT_EV10_CTRL_OUTSEL_Msk              (0x01UL << SCT_EV10_CTRL_OUTSEL_Pos)                    /*!< SCT EV10_CTRL: OUTSEL Mask              */
#define SCT_EV10_CTRL_IOSEL_Pos               6                                                       /*!< SCT EV10_CTRL: IOSEL Position           */
#define SCT_EV10_CTRL_IOSEL_Msk               (0x0fUL << SCT_EV10_CTRL_IOSEL_Pos)                     /*!< SCT EV10_CTRL: IOSEL Mask               */
#define SCT_EV10_CTRL_IOCOND_Pos              10                                                      /*!< SCT EV10_CTRL: IOCOND Position          */
#define SCT_EV10_CTRL_IOCOND_Msk              (0x03UL << SCT_EV10_CTRL_IOCOND_Pos)                    /*!< SCT EV10_CTRL: IOCOND Mask              */
#define SCT_EV10_CTRL_COMBMODE_Pos            12                                                      /*!< SCT EV10_CTRL: COMBMODE Position        */
#define SCT_EV10_CTRL_COMBMODE_Msk            (0x03UL << SCT_EV10_CTRL_COMBMODE_Pos)                  /*!< SCT EV10_CTRL: COMBMODE Mask            */
#define SCT_EV10_CTRL_STATELD_Pos             14                                                      /*!< SCT EV10_CTRL: STATELD Position         */
#define SCT_EV10_CTRL_STATELD_Msk             (0x01UL << SCT_EV10_CTRL_STATELD_Pos)                   /*!< SCT EV10_CTRL: STATELD Mask             */
#define SCT_EV10_CTRL_STATEV_Pos              15                                                      /*!< SCT EV10_CTRL: STATEV Position          */
#define SCT_EV10_CTRL_STATEV_Msk              (0x1fUL << SCT_EV10_CTRL_STATEV_Pos)                    /*!< SCT EV10_CTRL: STATEV Mask              */
#define SCT_EV10_CTRL_MATCHMEM_Pos            20                                                      /*!< SCT EV10_CTRL: MATCHMEM Position        */
#define SCT_EV10_CTRL_MATCHMEM_Msk            (0x01UL << SCT_EV10_CTRL_MATCHMEM_Pos)                  /*!< SCT EV10_CTRL: MATCHMEM Mask            */
#define SCT_EV10_CTRL_DIRECTION_Pos           21                                                      /*!< SCT EV10_CTRL: DIRECTION Position       */
#define SCT_EV10_CTRL_DIRECTION_Msk           (0x03UL << SCT_EV10_CTRL_DIRECTION_Pos)                 /*!< SCT EV10_CTRL: DIRECTION Mask           */

/* -------------------------------  SCT_EV11_STATE  ------------------------------- */
#define SCT_EV11_STATE_STATEMSK0_Pos          0                                                       /*!< SCT EV11_STATE: STATEMSK0 Position      */
#define SCT_EV11_STATE_STATEMSK0_Msk          (0x01UL << SCT_EV11_STATE_STATEMSK0_Pos)                /*!< SCT EV11_STATE: STATEMSK0 Mask          */
#define SCT_EV11_STATE_STATEMSK1_Pos          1                                                       /*!< SCT EV11_STATE: STATEMSK1 Position      */
#define SCT_EV11_STATE_STATEMSK1_Msk          (0x01UL << SCT_EV11_STATE_STATEMSK1_Pos)                /*!< SCT EV11_STATE: STATEMSK1 Mask          */
#define SCT_EV11_STATE_STATEMSK2_Pos          2                                                       /*!< SCT EV11_STATE: STATEMSK2 Position      */
#define SCT_EV11_STATE_STATEMSK2_Msk          (0x01UL << SCT_EV11_STATE_STATEMSK2_Pos)                /*!< SCT EV11_STATE: STATEMSK2 Mask          */
#define SCT_EV11_STATE_STATEMSK3_Pos          3                                                       /*!< SCT EV11_STATE: STATEMSK3 Position      */
#define SCT_EV11_STATE_STATEMSK3_Msk          (0x01UL << SCT_EV11_STATE_STATEMSK3_Pos)                /*!< SCT EV11_STATE: STATEMSK3 Mask          */
#define SCT_EV11_STATE_STATEMSK4_Pos          4                                                       /*!< SCT EV11_STATE: STATEMSK4 Position      */
#define SCT_EV11_STATE_STATEMSK4_Msk          (0x01UL << SCT_EV11_STATE_STATEMSK4_Pos)                /*!< SCT EV11_STATE: STATEMSK4 Mask          */
#define SCT_EV11_STATE_STATEMSK5_Pos          5                                                       /*!< SCT EV11_STATE: STATEMSK5 Position      */
#define SCT_EV11_STATE_STATEMSK5_Msk          (0x01UL << SCT_EV11_STATE_STATEMSK5_Pos)                /*!< SCT EV11_STATE: STATEMSK5 Mask          */
#define SCT_EV11_STATE_STATEMSK6_Pos          6                                                       /*!< SCT EV11_STATE: STATEMSK6 Position      */
#define SCT_EV11_STATE_STATEMSK6_Msk          (0x01UL << SCT_EV11_STATE_STATEMSK6_Pos)                /*!< SCT EV11_STATE: STATEMSK6 Mask          */
#define SCT_EV11_STATE_STATEMSK7_Pos          7                                                       /*!< SCT EV11_STATE: STATEMSK7 Position      */
#define SCT_EV11_STATE_STATEMSK7_Msk          (0x01UL << SCT_EV11_STATE_STATEMSK7_Pos)                /*!< SCT EV11_STATE: STATEMSK7 Mask          */
#define SCT_EV11_STATE_STATEMSK8_Pos          8                                                       /*!< SCT EV11_STATE: STATEMSK8 Position      */
#define SCT_EV11_STATE_STATEMSK8_Msk          (0x01UL << SCT_EV11_STATE_STATEMSK8_Pos)                /*!< SCT EV11_STATE: STATEMSK8 Mask          */
#define SCT_EV11_STATE_STATEMSK9_Pos          9                                                       /*!< SCT EV11_STATE: STATEMSK9 Position      */
#define SCT_EV11_STATE_STATEMSK9_Msk          (0x01UL << SCT_EV11_STATE_STATEMSK9_Pos)                /*!< SCT EV11_STATE: STATEMSK9 Mask          */
#define SCT_EV11_STATE_STATEMSK10_Pos         10                                                      /*!< SCT EV11_STATE: STATEMSK10 Position     */
#define SCT_EV11_STATE_STATEMSK10_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK10_Pos)               /*!< SCT EV11_STATE: STATEMSK10 Mask         */
#define SCT_EV11_STATE_STATEMSK11_Pos         11                                                      /*!< SCT EV11_STATE: STATEMSK11 Position     */
#define SCT_EV11_STATE_STATEMSK11_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK11_Pos)               /*!< SCT EV11_STATE: STATEMSK11 Mask         */
#define SCT_EV11_STATE_STATEMSK12_Pos         12                                                      /*!< SCT EV11_STATE: STATEMSK12 Position     */
#define SCT_EV11_STATE_STATEMSK12_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK12_Pos)               /*!< SCT EV11_STATE: STATEMSK12 Mask         */
#define SCT_EV11_STATE_STATEMSK13_Pos         13                                                      /*!< SCT EV11_STATE: STATEMSK13 Position     */
#define SCT_EV11_STATE_STATEMSK13_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK13_Pos)               /*!< SCT EV11_STATE: STATEMSK13 Mask         */
#define SCT_EV11_STATE_STATEMSK14_Pos         14                                                      /*!< SCT EV11_STATE: STATEMSK14 Position     */
#define SCT_EV11_STATE_STATEMSK14_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK14_Pos)               /*!< SCT EV11_STATE: STATEMSK14 Mask         */
#define SCT_EV11_STATE_STATEMSK15_Pos         15                                                      /*!< SCT EV11_STATE: STATEMSK15 Position     */
#define SCT_EV11_STATE_STATEMSK15_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK15_Pos)               /*!< SCT EV11_STATE: STATEMSK15 Mask         */
#define SCT_EV11_STATE_STATEMSK16_Pos         16                                                      /*!< SCT EV11_STATE: STATEMSK16 Position     */
#define SCT_EV11_STATE_STATEMSK16_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK16_Pos)               /*!< SCT EV11_STATE: STATEMSK16 Mask         */
#define SCT_EV11_STATE_STATEMSK17_Pos         17                                                      /*!< SCT EV11_STATE: STATEMSK17 Position     */
#define SCT_EV11_STATE_STATEMSK17_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK17_Pos)               /*!< SCT EV11_STATE: STATEMSK17 Mask         */
#define SCT_EV11_STATE_STATEMSK18_Pos         18                                                      /*!< SCT EV11_STATE: STATEMSK18 Position     */
#define SCT_EV11_STATE_STATEMSK18_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK18_Pos)               /*!< SCT EV11_STATE: STATEMSK18 Mask         */
#define SCT_EV11_STATE_STATEMSK19_Pos         19                                                      /*!< SCT EV11_STATE: STATEMSK19 Position     */
#define SCT_EV11_STATE_STATEMSK19_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK19_Pos)               /*!< SCT EV11_STATE: STATEMSK19 Mask         */
#define SCT_EV11_STATE_STATEMSK20_Pos         20                                                      /*!< SCT EV11_STATE: STATEMSK20 Position     */
#define SCT_EV11_STATE_STATEMSK20_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK20_Pos)               /*!< SCT EV11_STATE: STATEMSK20 Mask         */
#define SCT_EV11_STATE_STATEMSK21_Pos         21                                                      /*!< SCT EV11_STATE: STATEMSK21 Position     */
#define SCT_EV11_STATE_STATEMSK21_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK21_Pos)               /*!< SCT EV11_STATE: STATEMSK21 Mask         */
#define SCT_EV11_STATE_STATEMSK22_Pos         22                                                      /*!< SCT EV11_STATE: STATEMSK22 Position     */
#define SCT_EV11_STATE_STATEMSK22_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK22_Pos)               /*!< SCT EV11_STATE: STATEMSK22 Mask         */
#define SCT_EV11_STATE_STATEMSK23_Pos         23                                                      /*!< SCT EV11_STATE: STATEMSK23 Position     */
#define SCT_EV11_STATE_STATEMSK23_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK23_Pos)               /*!< SCT EV11_STATE: STATEMSK23 Mask         */
#define SCT_EV11_STATE_STATEMSK24_Pos         24                                                      /*!< SCT EV11_STATE: STATEMSK24 Position     */
#define SCT_EV11_STATE_STATEMSK24_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK24_Pos)               /*!< SCT EV11_STATE: STATEMSK24 Mask         */
#define SCT_EV11_STATE_STATEMSK25_Pos         25                                                      /*!< SCT EV11_STATE: STATEMSK25 Position     */
#define SCT_EV11_STATE_STATEMSK25_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK25_Pos)               /*!< SCT EV11_STATE: STATEMSK25 Mask         */
#define SCT_EV11_STATE_STATEMSK26_Pos         26                                                      /*!< SCT EV11_STATE: STATEMSK26 Position     */
#define SCT_EV11_STATE_STATEMSK26_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK26_Pos)               /*!< SCT EV11_STATE: STATEMSK26 Mask         */
#define SCT_EV11_STATE_STATEMSK27_Pos         27                                                      /*!< SCT EV11_STATE: STATEMSK27 Position     */
#define SCT_EV11_STATE_STATEMSK27_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK27_Pos)               /*!< SCT EV11_STATE: STATEMSK27 Mask         */
#define SCT_EV11_STATE_STATEMSK28_Pos         28                                                      /*!< SCT EV11_STATE: STATEMSK28 Position     */
#define SCT_EV11_STATE_STATEMSK28_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK28_Pos)               /*!< SCT EV11_STATE: STATEMSK28 Mask         */
#define SCT_EV11_STATE_STATEMSK29_Pos         29                                                      /*!< SCT EV11_STATE: STATEMSK29 Position     */
#define SCT_EV11_STATE_STATEMSK29_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK29_Pos)               /*!< SCT EV11_STATE: STATEMSK29 Mask         */
#define SCT_EV11_STATE_STATEMSK30_Pos         30                                                      /*!< SCT EV11_STATE: STATEMSK30 Position     */
#define SCT_EV11_STATE_STATEMSK30_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK30_Pos)               /*!< SCT EV11_STATE: STATEMSK30 Mask         */
#define SCT_EV11_STATE_STATEMSK31_Pos         31                                                      /*!< SCT EV11_STATE: STATEMSK31 Position     */
#define SCT_EV11_STATE_STATEMSK31_Msk         (0x01UL << SCT_EV11_STATE_STATEMSK31_Pos)               /*!< SCT EV11_STATE: STATEMSK31 Mask         */

/* --------------------------------  SCT_EV11_CTRL  ------------------------------- */
#define SCT_EV11_CTRL_MATCHSEL_Pos            0                                                       /*!< SCT EV11_CTRL: MATCHSEL Position        */
#define SCT_EV11_CTRL_MATCHSEL_Msk            (0x0fUL << SCT_EV11_CTRL_MATCHSEL_Pos)                  /*!< SCT EV11_CTRL: MATCHSEL Mask            */
#define SCT_EV11_CTRL_HEVENT_Pos              4                                                       /*!< SCT EV11_CTRL: HEVENT Position          */
#define SCT_EV11_CTRL_HEVENT_Msk              (0x01UL << SCT_EV11_CTRL_HEVENT_Pos)                    /*!< SCT EV11_CTRL: HEVENT Mask              */
#define SCT_EV11_CTRL_OUTSEL_Pos              5                                                       /*!< SCT EV11_CTRL: OUTSEL Position          */
#define SCT_EV11_CTRL_OUTSEL_Msk              (0x01UL << SCT_EV11_CTRL_OUTSEL_Pos)                    /*!< SCT EV11_CTRL: OUTSEL Mask              */
#define SCT_EV11_CTRL_IOSEL_Pos               6                                                       /*!< SCT EV11_CTRL: IOSEL Position           */
#define SCT_EV11_CTRL_IOSEL_Msk               (0x0fUL << SCT_EV11_CTRL_IOSEL_Pos)                     /*!< SCT EV11_CTRL: IOSEL Mask               */
#define SCT_EV11_CTRL_IOCOND_Pos              10                                                      /*!< SCT EV11_CTRL: IOCOND Position          */
#define SCT_EV11_CTRL_IOCOND_Msk              (0x03UL << SCT_EV11_CTRL_IOCOND_Pos)                    /*!< SCT EV11_CTRL: IOCOND Mask              */
#define SCT_EV11_CTRL_COMBMODE_Pos            12                                                      /*!< SCT EV11_CTRL: COMBMODE Position        */
#define SCT_EV11_CTRL_COMBMODE_Msk            (0x03UL << SCT_EV11_CTRL_COMBMODE_Pos)                  /*!< SCT EV11_CTRL: COMBMODE Mask            */
#define SCT_EV11_CTRL_STATELD_Pos             14                                                      /*!< SCT EV11_CTRL: STATELD Position         */
#define SCT_EV11_CTRL_STATELD_Msk             (0x01UL << SCT_EV11_CTRL_STATELD_Pos)                   /*!< SCT EV11_CTRL: STATELD Mask             */
#define SCT_EV11_CTRL_STATEV_Pos              15                                                      /*!< SCT EV11_CTRL: STATEV Position          */
#define SCT_EV11_CTRL_STATEV_Msk              (0x1fUL << SCT_EV11_CTRL_STATEV_Pos)                    /*!< SCT EV11_CTRL: STATEV Mask              */
#define SCT_EV11_CTRL_MATCHMEM_Pos            20                                                      /*!< SCT EV11_CTRL: MATCHMEM Position        */
#define SCT_EV11_CTRL_MATCHMEM_Msk            (0x01UL << SCT_EV11_CTRL_MATCHMEM_Pos)                  /*!< SCT EV11_CTRL: MATCHMEM Mask            */
#define SCT_EV11_CTRL_DIRECTION_Pos           21                                                      /*!< SCT EV11_CTRL: DIRECTION Position       */
#define SCT_EV11_CTRL_DIRECTION_Msk           (0x03UL << SCT_EV11_CTRL_DIRECTION_Pos)                 /*!< SCT EV11_CTRL: DIRECTION Mask           */

/* -------------------------------  SCT_EV12_STATE  ------------------------------- */
#define SCT_EV12_STATE_STATEMSK0_Pos          0                                                       /*!< SCT EV12_STATE: STATEMSK0 Position      */
#define SCT_EV12_STATE_STATEMSK0_Msk          (0x01UL << SCT_EV12_STATE_STATEMSK0_Pos)                /*!< SCT EV12_STATE: STATEMSK0 Mask          */
#define SCT_EV12_STATE_STATEMSK1_Pos          1                                                       /*!< SCT EV12_STATE: STATEMSK1 Position      */
#define SCT_EV12_STATE_STATEMSK1_Msk          (0x01UL << SCT_EV12_STATE_STATEMSK1_Pos)                /*!< SCT EV12_STATE: STATEMSK1 Mask          */
#define SCT_EV12_STATE_STATEMSK2_Pos          2                                                       /*!< SCT EV12_STATE: STATEMSK2 Position      */
#define SCT_EV12_STATE_STATEMSK2_Msk          (0x01UL << SCT_EV12_STATE_STATEMSK2_Pos)                /*!< SCT EV12_STATE: STATEMSK2 Mask          */
#define SCT_EV12_STATE_STATEMSK3_Pos          3                                                       /*!< SCT EV12_STATE: STATEMSK3 Position      */
#define SCT_EV12_STATE_STATEMSK3_Msk          (0x01UL << SCT_EV12_STATE_STATEMSK3_Pos)                /*!< SCT EV12_STATE: STATEMSK3 Mask          */
#define SCT_EV12_STATE_STATEMSK4_Pos          4                                                       /*!< SCT EV12_STATE: STATEMSK4 Position      */
#define SCT_EV12_STATE_STATEMSK4_Msk          (0x01UL << SCT_EV12_STATE_STATEMSK4_Pos)                /*!< SCT EV12_STATE: STATEMSK4 Mask          */
#define SCT_EV12_STATE_STATEMSK5_Pos          5                                                       /*!< SCT EV12_STATE: STATEMSK5 Position      */
#define SCT_EV12_STATE_STATEMSK5_Msk          (0x01UL << SCT_EV12_STATE_STATEMSK5_Pos)                /*!< SCT EV12_STATE: STATEMSK5 Mask          */
#define SCT_EV12_STATE_STATEMSK6_Pos          6                                                       /*!< SCT EV12_STATE: STATEMSK6 Position      */
#define SCT_EV12_STATE_STATEMSK6_Msk          (0x01UL << SCT_EV12_STATE_STATEMSK6_Pos)                /*!< SCT EV12_STATE: STATEMSK6 Mask          */
#define SCT_EV12_STATE_STATEMSK7_Pos          7                                                       /*!< SCT EV12_STATE: STATEMSK7 Position      */
#define SCT_EV12_STATE_STATEMSK7_Msk          (0x01UL << SCT_EV12_STATE_STATEMSK7_Pos)                /*!< SCT EV12_STATE: STATEMSK7 Mask          */
#define SCT_EV12_STATE_STATEMSK8_Pos          8                                                       /*!< SCT EV12_STATE: STATEMSK8 Position      */
#define SCT_EV12_STATE_STATEMSK8_Msk          (0x01UL << SCT_EV12_STATE_STATEMSK8_Pos)                /*!< SCT EV12_STATE: STATEMSK8 Mask          */
#define SCT_EV12_STATE_STATEMSK9_Pos          9                                                       /*!< SCT EV12_STATE: STATEMSK9 Position      */
#define SCT_EV12_STATE_STATEMSK9_Msk          (0x01UL << SCT_EV12_STATE_STATEMSK9_Pos)                /*!< SCT EV12_STATE: STATEMSK9 Mask          */
#define SCT_EV12_STATE_STATEMSK10_Pos         10                                                      /*!< SCT EV12_STATE: STATEMSK10 Position     */
#define SCT_EV12_STATE_STATEMSK10_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK10_Pos)               /*!< SCT EV12_STATE: STATEMSK10 Mask         */
#define SCT_EV12_STATE_STATEMSK11_Pos         11                                                      /*!< SCT EV12_STATE: STATEMSK11 Position     */
#define SCT_EV12_STATE_STATEMSK11_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK11_Pos)               /*!< SCT EV12_STATE: STATEMSK11 Mask         */
#define SCT_EV12_STATE_STATEMSK12_Pos         12                                                      /*!< SCT EV12_STATE: STATEMSK12 Position     */
#define SCT_EV12_STATE_STATEMSK12_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK12_Pos)               /*!< SCT EV12_STATE: STATEMSK12 Mask         */
#define SCT_EV12_STATE_STATEMSK13_Pos         13                                                      /*!< SCT EV12_STATE: STATEMSK13 Position     */
#define SCT_EV12_STATE_STATEMSK13_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK13_Pos)               /*!< SCT EV12_STATE: STATEMSK13 Mask         */
#define SCT_EV12_STATE_STATEMSK14_Pos         14                                                      /*!< SCT EV12_STATE: STATEMSK14 Position     */
#define SCT_EV12_STATE_STATEMSK14_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK14_Pos)               /*!< SCT EV12_STATE: STATEMSK14 Mask         */
#define SCT_EV12_STATE_STATEMSK15_Pos         15                                                      /*!< SCT EV12_STATE: STATEMSK15 Position     */
#define SCT_EV12_STATE_STATEMSK15_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK15_Pos)               /*!< SCT EV12_STATE: STATEMSK15 Mask         */
#define SCT_EV12_STATE_STATEMSK16_Pos         16                                                      /*!< SCT EV12_STATE: STATEMSK16 Position     */
#define SCT_EV12_STATE_STATEMSK16_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK16_Pos)               /*!< SCT EV12_STATE: STATEMSK16 Mask         */
#define SCT_EV12_STATE_STATEMSK17_Pos         17                                                      /*!< SCT EV12_STATE: STATEMSK17 Position     */
#define SCT_EV12_STATE_STATEMSK17_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK17_Pos)               /*!< SCT EV12_STATE: STATEMSK17 Mask         */
#define SCT_EV12_STATE_STATEMSK18_Pos         18                                                      /*!< SCT EV12_STATE: STATEMSK18 Position     */
#define SCT_EV12_STATE_STATEMSK18_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK18_Pos)               /*!< SCT EV12_STATE: STATEMSK18 Mask         */
#define SCT_EV12_STATE_STATEMSK19_Pos         19                                                      /*!< SCT EV12_STATE: STATEMSK19 Position     */
#define SCT_EV12_STATE_STATEMSK19_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK19_Pos)               /*!< SCT EV12_STATE: STATEMSK19 Mask         */
#define SCT_EV12_STATE_STATEMSK20_Pos         20                                                      /*!< SCT EV12_STATE: STATEMSK20 Position     */
#define SCT_EV12_STATE_STATEMSK20_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK20_Pos)               /*!< SCT EV12_STATE: STATEMSK20 Mask         */
#define SCT_EV12_STATE_STATEMSK21_Pos         21                                                      /*!< SCT EV12_STATE: STATEMSK21 Position     */
#define SCT_EV12_STATE_STATEMSK21_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK21_Pos)               /*!< SCT EV12_STATE: STATEMSK21 Mask         */
#define SCT_EV12_STATE_STATEMSK22_Pos         22                                                      /*!< SCT EV12_STATE: STATEMSK22 Position     */
#define SCT_EV12_STATE_STATEMSK22_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK22_Pos)               /*!< SCT EV12_STATE: STATEMSK22 Mask         */
#define SCT_EV12_STATE_STATEMSK23_Pos         23                                                      /*!< SCT EV12_STATE: STATEMSK23 Position     */
#define SCT_EV12_STATE_STATEMSK23_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK23_Pos)               /*!< SCT EV12_STATE: STATEMSK23 Mask         */
#define SCT_EV12_STATE_STATEMSK24_Pos         24                                                      /*!< SCT EV12_STATE: STATEMSK24 Position     */
#define SCT_EV12_STATE_STATEMSK24_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK24_Pos)               /*!< SCT EV12_STATE: STATEMSK24 Mask         */
#define SCT_EV12_STATE_STATEMSK25_Pos         25                                                      /*!< SCT EV12_STATE: STATEMSK25 Position     */
#define SCT_EV12_STATE_STATEMSK25_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK25_Pos)               /*!< SCT EV12_STATE: STATEMSK25 Mask         */
#define SCT_EV12_STATE_STATEMSK26_Pos         26                                                      /*!< SCT EV12_STATE: STATEMSK26 Position     */
#define SCT_EV12_STATE_STATEMSK26_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK26_Pos)               /*!< SCT EV12_STATE: STATEMSK26 Mask         */
#define SCT_EV12_STATE_STATEMSK27_Pos         27                                                      /*!< SCT EV12_STATE: STATEMSK27 Position     */
#define SCT_EV12_STATE_STATEMSK27_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK27_Pos)               /*!< SCT EV12_STATE: STATEMSK27 Mask         */
#define SCT_EV12_STATE_STATEMSK28_Pos         28                                                      /*!< SCT EV12_STATE: STATEMSK28 Position     */
#define SCT_EV12_STATE_STATEMSK28_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK28_Pos)               /*!< SCT EV12_STATE: STATEMSK28 Mask         */
#define SCT_EV12_STATE_STATEMSK29_Pos         29                                                      /*!< SCT EV12_STATE: STATEMSK29 Position     */
#define SCT_EV12_STATE_STATEMSK29_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK29_Pos)               /*!< SCT EV12_STATE: STATEMSK29 Mask         */
#define SCT_EV12_STATE_STATEMSK30_Pos         30                                                      /*!< SCT EV12_STATE: STATEMSK30 Position     */
#define SCT_EV12_STATE_STATEMSK30_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK30_Pos)               /*!< SCT EV12_STATE: STATEMSK30 Mask         */
#define SCT_EV12_STATE_STATEMSK31_Pos         31                                                      /*!< SCT EV12_STATE: STATEMSK31 Position     */
#define SCT_EV12_STATE_STATEMSK31_Msk         (0x01UL << SCT_EV12_STATE_STATEMSK31_Pos)               /*!< SCT EV12_STATE: STATEMSK31 Mask         */

/* --------------------------------  SCT_EV12_CTRL  ------------------------------- */
#define SCT_EV12_CTRL_MATCHSEL_Pos            0                                                       /*!< SCT EV12_CTRL: MATCHSEL Position        */
#define SCT_EV12_CTRL_MATCHSEL_Msk            (0x0fUL << SCT_EV12_CTRL_MATCHSEL_Pos)                  /*!< SCT EV12_CTRL: MATCHSEL Mask            */
#define SCT_EV12_CTRL_HEVENT_Pos              4                                                       /*!< SCT EV12_CTRL: HEVENT Position          */
#define SCT_EV12_CTRL_HEVENT_Msk              (0x01UL << SCT_EV12_CTRL_HEVENT_Pos)                    /*!< SCT EV12_CTRL: HEVENT Mask              */
#define SCT_EV12_CTRL_OUTSEL_Pos              5                                                       /*!< SCT EV12_CTRL: OUTSEL Position          */
#define SCT_EV12_CTRL_OUTSEL_Msk              (0x01UL << SCT_EV12_CTRL_OUTSEL_Pos)                    /*!< SCT EV12_CTRL: OUTSEL Mask              */
#define SCT_EV12_CTRL_IOSEL_Pos               6                                                       /*!< SCT EV12_CTRL: IOSEL Position           */
#define SCT_EV12_CTRL_IOSEL_Msk               (0x0fUL << SCT_EV12_CTRL_IOSEL_Pos)                     /*!< SCT EV12_CTRL: IOSEL Mask               */
#define SCT_EV12_CTRL_IOCOND_Pos              10                                                      /*!< SCT EV12_CTRL: IOCOND Position          */
#define SCT_EV12_CTRL_IOCOND_Msk              (0x03UL << SCT_EV12_CTRL_IOCOND_Pos)                    /*!< SCT EV12_CTRL: IOCOND Mask              */
#define SCT_EV12_CTRL_COMBMODE_Pos            12                                                      /*!< SCT EV12_CTRL: COMBMODE Position        */
#define SCT_EV12_CTRL_COMBMODE_Msk            (0x03UL << SCT_EV12_CTRL_COMBMODE_Pos)                  /*!< SCT EV12_CTRL: COMBMODE Mask            */
#define SCT_EV12_CTRL_STATELD_Pos             14                                                      /*!< SCT EV12_CTRL: STATELD Position         */
#define SCT_EV12_CTRL_STATELD_Msk             (0x01UL << SCT_EV12_CTRL_STATELD_Pos)                   /*!< SCT EV12_CTRL: STATELD Mask             */
#define SCT_EV12_CTRL_STATEV_Pos              15                                                      /*!< SCT EV12_CTRL: STATEV Position          */
#define SCT_EV12_CTRL_STATEV_Msk              (0x1fUL << SCT_EV12_CTRL_STATEV_Pos)                    /*!< SCT EV12_CTRL: STATEV Mask              */
#define SCT_EV12_CTRL_MATCHMEM_Pos            20                                                      /*!< SCT EV12_CTRL: MATCHMEM Position        */
#define SCT_EV12_CTRL_MATCHMEM_Msk            (0x01UL << SCT_EV12_CTRL_MATCHMEM_Pos)                  /*!< SCT EV12_CTRL: MATCHMEM Mask            */
#define SCT_EV12_CTRL_DIRECTION_Pos           21                                                      /*!< SCT EV12_CTRL: DIRECTION Position       */
#define SCT_EV12_CTRL_DIRECTION_Msk           (0x03UL << SCT_EV12_CTRL_DIRECTION_Pos)                 /*!< SCT EV12_CTRL: DIRECTION Mask           */

/* -------------------------------  SCT_EV13_STATE  ------------------------------- */
#define SCT_EV13_STATE_STATEMSK0_Pos          0                                                       /*!< SCT EV13_STATE: STATEMSK0 Position      */
#define SCT_EV13_STATE_STATEMSK0_Msk          (0x01UL << SCT_EV13_STATE_STATEMSK0_Pos)                /*!< SCT EV13_STATE: STATEMSK0 Mask          */
#define SCT_EV13_STATE_STATEMSK1_Pos          1                                                       /*!< SCT EV13_STATE: STATEMSK1 Position      */
#define SCT_EV13_STATE_STATEMSK1_Msk          (0x01UL << SCT_EV13_STATE_STATEMSK1_Pos)                /*!< SCT EV13_STATE: STATEMSK1 Mask          */
#define SCT_EV13_STATE_STATEMSK2_Pos          2                                                       /*!< SCT EV13_STATE: STATEMSK2 Position      */
#define SCT_EV13_STATE_STATEMSK2_Msk          (0x01UL << SCT_EV13_STATE_STATEMSK2_Pos)                /*!< SCT EV13_STATE: STATEMSK2 Mask          */
#define SCT_EV13_STATE_STATEMSK3_Pos          3                                                       /*!< SCT EV13_STATE: STATEMSK3 Position      */
#define SCT_EV13_STATE_STATEMSK3_Msk          (0x01UL << SCT_EV13_STATE_STATEMSK3_Pos)                /*!< SCT EV13_STATE: STATEMSK3 Mask          */
#define SCT_EV13_STATE_STATEMSK4_Pos          4                                                       /*!< SCT EV13_STATE: STATEMSK4 Position      */
#define SCT_EV13_STATE_STATEMSK4_Msk          (0x01UL << SCT_EV13_STATE_STATEMSK4_Pos)                /*!< SCT EV13_STATE: STATEMSK4 Mask          */
#define SCT_EV13_STATE_STATEMSK5_Pos          5                                                       /*!< SCT EV13_STATE: STATEMSK5 Position      */
#define SCT_EV13_STATE_STATEMSK5_Msk          (0x01UL << SCT_EV13_STATE_STATEMSK5_Pos)                /*!< SCT EV13_STATE: STATEMSK5 Mask          */
#define SCT_EV13_STATE_STATEMSK6_Pos          6                                                       /*!< SCT EV13_STATE: STATEMSK6 Position      */
#define SCT_EV13_STATE_STATEMSK6_Msk          (0x01UL << SCT_EV13_STATE_STATEMSK6_Pos)                /*!< SCT EV13_STATE: STATEMSK6 Mask          */
#define SCT_EV13_STATE_STATEMSK7_Pos          7                                                       /*!< SCT EV13_STATE: STATEMSK7 Position      */
#define SCT_EV13_STATE_STATEMSK7_Msk          (0x01UL << SCT_EV13_STATE_STATEMSK7_Pos)                /*!< SCT EV13_STATE: STATEMSK7 Mask          */
#define SCT_EV13_STATE_STATEMSK8_Pos          8                                                       /*!< SCT EV13_STATE: STATEMSK8 Position      */
#define SCT_EV13_STATE_STATEMSK8_Msk          (0x01UL << SCT_EV13_STATE_STATEMSK8_Pos)                /*!< SCT EV13_STATE: STATEMSK8 Mask          */
#define SCT_EV13_STATE_STATEMSK9_Pos          9                                                       /*!< SCT EV13_STATE: STATEMSK9 Position      */
#define SCT_EV13_STATE_STATEMSK9_Msk          (0x01UL << SCT_EV13_STATE_STATEMSK9_Pos)                /*!< SCT EV13_STATE: STATEMSK9 Mask          */
#define SCT_EV13_STATE_STATEMSK10_Pos         10                                                      /*!< SCT EV13_STATE: STATEMSK10 Position     */
#define SCT_EV13_STATE_STATEMSK10_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK10_Pos)               /*!< SCT EV13_STATE: STATEMSK10 Mask         */
#define SCT_EV13_STATE_STATEMSK11_Pos         11                                                      /*!< SCT EV13_STATE: STATEMSK11 Position     */
#define SCT_EV13_STATE_STATEMSK11_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK11_Pos)               /*!< SCT EV13_STATE: STATEMSK11 Mask         */
#define SCT_EV13_STATE_STATEMSK12_Pos         12                                                      /*!< SCT EV13_STATE: STATEMSK12 Position     */
#define SCT_EV13_STATE_STATEMSK12_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK12_Pos)               /*!< SCT EV13_STATE: STATEMSK12 Mask         */
#define SCT_EV13_STATE_STATEMSK13_Pos         13                                                      /*!< SCT EV13_STATE: STATEMSK13 Position     */
#define SCT_EV13_STATE_STATEMSK13_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK13_Pos)               /*!< SCT EV13_STATE: STATEMSK13 Mask         */
#define SCT_EV13_STATE_STATEMSK14_Pos         14                                                      /*!< SCT EV13_STATE: STATEMSK14 Position     */
#define SCT_EV13_STATE_STATEMSK14_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK14_Pos)               /*!< SCT EV13_STATE: STATEMSK14 Mask         */
#define SCT_EV13_STATE_STATEMSK15_Pos         15                                                      /*!< SCT EV13_STATE: STATEMSK15 Position     */
#define SCT_EV13_STATE_STATEMSK15_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK15_Pos)               /*!< SCT EV13_STATE: STATEMSK15 Mask         */
#define SCT_EV13_STATE_STATEMSK16_Pos         16                                                      /*!< SCT EV13_STATE: STATEMSK16 Position     */
#define SCT_EV13_STATE_STATEMSK16_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK16_Pos)               /*!< SCT EV13_STATE: STATEMSK16 Mask         */
#define SCT_EV13_STATE_STATEMSK17_Pos         17                                                      /*!< SCT EV13_STATE: STATEMSK17 Position     */
#define SCT_EV13_STATE_STATEMSK17_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK17_Pos)               /*!< SCT EV13_STATE: STATEMSK17 Mask         */
#define SCT_EV13_STATE_STATEMSK18_Pos         18                                                      /*!< SCT EV13_STATE: STATEMSK18 Position     */
#define SCT_EV13_STATE_STATEMSK18_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK18_Pos)               /*!< SCT EV13_STATE: STATEMSK18 Mask         */
#define SCT_EV13_STATE_STATEMSK19_Pos         19                                                      /*!< SCT EV13_STATE: STATEMSK19 Position     */
#define SCT_EV13_STATE_STATEMSK19_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK19_Pos)               /*!< SCT EV13_STATE: STATEMSK19 Mask         */
#define SCT_EV13_STATE_STATEMSK20_Pos         20                                                      /*!< SCT EV13_STATE: STATEMSK20 Position     */
#define SCT_EV13_STATE_STATEMSK20_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK20_Pos)               /*!< SCT EV13_STATE: STATEMSK20 Mask         */
#define SCT_EV13_STATE_STATEMSK21_Pos         21                                                      /*!< SCT EV13_STATE: STATEMSK21 Position     */
#define SCT_EV13_STATE_STATEMSK21_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK21_Pos)               /*!< SCT EV13_STATE: STATEMSK21 Mask         */
#define SCT_EV13_STATE_STATEMSK22_Pos         22                                                      /*!< SCT EV13_STATE: STATEMSK22 Position     */
#define SCT_EV13_STATE_STATEMSK22_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK22_Pos)               /*!< SCT EV13_STATE: STATEMSK22 Mask         */
#define SCT_EV13_STATE_STATEMSK23_Pos         23                                                      /*!< SCT EV13_STATE: STATEMSK23 Position     */
#define SCT_EV13_STATE_STATEMSK23_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK23_Pos)               /*!< SCT EV13_STATE: STATEMSK23 Mask         */
#define SCT_EV13_STATE_STATEMSK24_Pos         24                                                      /*!< SCT EV13_STATE: STATEMSK24 Position     */
#define SCT_EV13_STATE_STATEMSK24_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK24_Pos)               /*!< SCT EV13_STATE: STATEMSK24 Mask         */
#define SCT_EV13_STATE_STATEMSK25_Pos         25                                                      /*!< SCT EV13_STATE: STATEMSK25 Position     */
#define SCT_EV13_STATE_STATEMSK25_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK25_Pos)               /*!< SCT EV13_STATE: STATEMSK25 Mask         */
#define SCT_EV13_STATE_STATEMSK26_Pos         26                                                      /*!< SCT EV13_STATE: STATEMSK26 Position     */
#define SCT_EV13_STATE_STATEMSK26_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK26_Pos)               /*!< SCT EV13_STATE: STATEMSK26 Mask         */
#define SCT_EV13_STATE_STATEMSK27_Pos         27                                                      /*!< SCT EV13_STATE: STATEMSK27 Position     */
#define SCT_EV13_STATE_STATEMSK27_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK27_Pos)               /*!< SCT EV13_STATE: STATEMSK27 Mask         */
#define SCT_EV13_STATE_STATEMSK28_Pos         28                                                      /*!< SCT EV13_STATE: STATEMSK28 Position     */
#define SCT_EV13_STATE_STATEMSK28_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK28_Pos)               /*!< SCT EV13_STATE: STATEMSK28 Mask         */
#define SCT_EV13_STATE_STATEMSK29_Pos         29                                                      /*!< SCT EV13_STATE: STATEMSK29 Position     */
#define SCT_EV13_STATE_STATEMSK29_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK29_Pos)               /*!< SCT EV13_STATE: STATEMSK29 Mask         */
#define SCT_EV13_STATE_STATEMSK30_Pos         30                                                      /*!< SCT EV13_STATE: STATEMSK30 Position     */
#define SCT_EV13_STATE_STATEMSK30_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK30_Pos)               /*!< SCT EV13_STATE: STATEMSK30 Mask         */
#define SCT_EV13_STATE_STATEMSK31_Pos         31                                                      /*!< SCT EV13_STATE: STATEMSK31 Position     */
#define SCT_EV13_STATE_STATEMSK31_Msk         (0x01UL << SCT_EV13_STATE_STATEMSK31_Pos)               /*!< SCT EV13_STATE: STATEMSK31 Mask         */

/* --------------------------------  SCT_EV13_CTRL  ------------------------------- */
#define SCT_EV13_CTRL_MATCHSEL_Pos            0                                                       /*!< SCT EV13_CTRL: MATCHSEL Position        */
#define SCT_EV13_CTRL_MATCHSEL_Msk            (0x0fUL << SCT_EV13_CTRL_MATCHSEL_Pos)                  /*!< SCT EV13_CTRL: MATCHSEL Mask            */
#define SCT_EV13_CTRL_HEVENT_Pos              4                                                       /*!< SCT EV13_CTRL: HEVENT Position          */
#define SCT_EV13_CTRL_HEVENT_Msk              (0x01UL << SCT_EV13_CTRL_HEVENT_Pos)                    /*!< SCT EV13_CTRL: HEVENT Mask              */
#define SCT_EV13_CTRL_OUTSEL_Pos              5                                                       /*!< SCT EV13_CTRL: OUTSEL Position          */
#define SCT_EV13_CTRL_OUTSEL_Msk              (0x01UL << SCT_EV13_CTRL_OUTSEL_Pos)                    /*!< SCT EV13_CTRL: OUTSEL Mask              */
#define SCT_EV13_CTRL_IOSEL_Pos               6                                                       /*!< SCT EV13_CTRL: IOSEL Position           */
#define SCT_EV13_CTRL_IOSEL_Msk               (0x0fUL << SCT_EV13_CTRL_IOSEL_Pos)                     /*!< SCT EV13_CTRL: IOSEL Mask               */
#define SCT_EV13_CTRL_IOCOND_Pos              10                                                      /*!< SCT EV13_CTRL: IOCOND Position          */
#define SCT_EV13_CTRL_IOCOND_Msk              (0x03UL << SCT_EV13_CTRL_IOCOND_Pos)                    /*!< SCT EV13_CTRL: IOCOND Mask              */
#define SCT_EV13_CTRL_COMBMODE_Pos            12                                                      /*!< SCT EV13_CTRL: COMBMODE Position        */
#define SCT_EV13_CTRL_COMBMODE_Msk            (0x03UL << SCT_EV13_CTRL_COMBMODE_Pos)                  /*!< SCT EV13_CTRL: COMBMODE Mask            */
#define SCT_EV13_CTRL_STATELD_Pos             14                                                      /*!< SCT EV13_CTRL: STATELD Position         */
#define SCT_EV13_CTRL_STATELD_Msk             (0x01UL << SCT_EV13_CTRL_STATELD_Pos)                   /*!< SCT EV13_CTRL: STATELD Mask             */
#define SCT_EV13_CTRL_STATEV_Pos              15                                                      /*!< SCT EV13_CTRL: STATEV Position          */
#define SCT_EV13_CTRL_STATEV_Msk              (0x1fUL << SCT_EV13_CTRL_STATEV_Pos)                    /*!< SCT EV13_CTRL: STATEV Mask              */
#define SCT_EV13_CTRL_MATCHMEM_Pos            20                                                      /*!< SCT EV13_CTRL: MATCHMEM Position        */
#define SCT_EV13_CTRL_MATCHMEM_Msk            (0x01UL << SCT_EV13_CTRL_MATCHMEM_Pos)                  /*!< SCT EV13_CTRL: MATCHMEM Mask            */
#define SCT_EV13_CTRL_DIRECTION_Pos           21                                                      /*!< SCT EV13_CTRL: DIRECTION Position       */
#define SCT_EV13_CTRL_DIRECTION_Msk           (0x03UL << SCT_EV13_CTRL_DIRECTION_Pos)                 /*!< SCT EV13_CTRL: DIRECTION Mask           */

/* -------------------------------  SCT_EV14_STATE  ------------------------------- */
#define SCT_EV14_STATE_STATEMSK0_Pos          0                                                       /*!< SCT EV14_STATE: STATEMSK0 Position      */
#define SCT_EV14_STATE_STATEMSK0_Msk          (0x01UL << SCT_EV14_STATE_STATEMSK0_Pos)                /*!< SCT EV14_STATE: STATEMSK0 Mask          */
#define SCT_EV14_STATE_STATEMSK1_Pos          1                                                       /*!< SCT EV14_STATE: STATEMSK1 Position      */
#define SCT_EV14_STATE_STATEMSK1_Msk          (0x01UL << SCT_EV14_STATE_STATEMSK1_Pos)                /*!< SCT EV14_STATE: STATEMSK1 Mask          */
#define SCT_EV14_STATE_STATEMSK2_Pos          2                                                       /*!< SCT EV14_STATE: STATEMSK2 Position      */
#define SCT_EV14_STATE_STATEMSK2_Msk          (0x01UL << SCT_EV14_STATE_STATEMSK2_Pos)                /*!< SCT EV14_STATE: STATEMSK2 Mask          */
#define SCT_EV14_STATE_STATEMSK3_Pos          3                                                       /*!< SCT EV14_STATE: STATEMSK3 Position      */
#define SCT_EV14_STATE_STATEMSK3_Msk          (0x01UL << SCT_EV14_STATE_STATEMSK3_Pos)                /*!< SCT EV14_STATE: STATEMSK3 Mask          */
#define SCT_EV14_STATE_STATEMSK4_Pos          4                                                       /*!< SCT EV14_STATE: STATEMSK4 Position      */
#define SCT_EV14_STATE_STATEMSK4_Msk          (0x01UL << SCT_EV14_STATE_STATEMSK4_Pos)                /*!< SCT EV14_STATE: STATEMSK4 Mask          */
#define SCT_EV14_STATE_STATEMSK5_Pos          5                                                       /*!< SCT EV14_STATE: STATEMSK5 Position      */
#define SCT_EV14_STATE_STATEMSK5_Msk          (0x01UL << SCT_EV14_STATE_STATEMSK5_Pos)                /*!< SCT EV14_STATE: STATEMSK5 Mask          */
#define SCT_EV14_STATE_STATEMSK6_Pos          6                                                       /*!< SCT EV14_STATE: STATEMSK6 Position      */
#define SCT_EV14_STATE_STATEMSK6_Msk          (0x01UL << SCT_EV14_STATE_STATEMSK6_Pos)                /*!< SCT EV14_STATE: STATEMSK6 Mask          */
#define SCT_EV14_STATE_STATEMSK7_Pos          7                                                       /*!< SCT EV14_STATE: STATEMSK7 Position      */
#define SCT_EV14_STATE_STATEMSK7_Msk          (0x01UL << SCT_EV14_STATE_STATEMSK7_Pos)                /*!< SCT EV14_STATE: STATEMSK7 Mask          */
#define SCT_EV14_STATE_STATEMSK8_Pos          8                                                       /*!< SCT EV14_STATE: STATEMSK8 Position      */
#define SCT_EV14_STATE_STATEMSK8_Msk          (0x01UL << SCT_EV14_STATE_STATEMSK8_Pos)                /*!< SCT EV14_STATE: STATEMSK8 Mask          */
#define SCT_EV14_STATE_STATEMSK9_Pos          9                                                       /*!< SCT EV14_STATE: STATEMSK9 Position      */
#define SCT_EV14_STATE_STATEMSK9_Msk          (0x01UL << SCT_EV14_STATE_STATEMSK9_Pos)                /*!< SCT EV14_STATE: STATEMSK9 Mask          */
#define SCT_EV14_STATE_STATEMSK10_Pos         10                                                      /*!< SCT EV14_STATE: STATEMSK10 Position     */
#define SCT_EV14_STATE_STATEMSK10_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK10_Pos)               /*!< SCT EV14_STATE: STATEMSK10 Mask         */
#define SCT_EV14_STATE_STATEMSK11_Pos         11                                                      /*!< SCT EV14_STATE: STATEMSK11 Position     */
#define SCT_EV14_STATE_STATEMSK11_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK11_Pos)               /*!< SCT EV14_STATE: STATEMSK11 Mask         */
#define SCT_EV14_STATE_STATEMSK12_Pos         12                                                      /*!< SCT EV14_STATE: STATEMSK12 Position     */
#define SCT_EV14_STATE_STATEMSK12_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK12_Pos)               /*!< SCT EV14_STATE: STATEMSK12 Mask         */
#define SCT_EV14_STATE_STATEMSK13_Pos         13                                                      /*!< SCT EV14_STATE: STATEMSK13 Position     */
#define SCT_EV14_STATE_STATEMSK13_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK13_Pos)               /*!< SCT EV14_STATE: STATEMSK13 Mask         */
#define SCT_EV14_STATE_STATEMSK14_Pos         14                                                      /*!< SCT EV14_STATE: STATEMSK14 Position     */
#define SCT_EV14_STATE_STATEMSK14_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK14_Pos)               /*!< SCT EV14_STATE: STATEMSK14 Mask         */
#define SCT_EV14_STATE_STATEMSK15_Pos         15                                                      /*!< SCT EV14_STATE: STATEMSK15 Position     */
#define SCT_EV14_STATE_STATEMSK15_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK15_Pos)               /*!< SCT EV14_STATE: STATEMSK15 Mask         */
#define SCT_EV14_STATE_STATEMSK16_Pos         16                                                      /*!< SCT EV14_STATE: STATEMSK16 Position     */
#define SCT_EV14_STATE_STATEMSK16_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK16_Pos)               /*!< SCT EV14_STATE: STATEMSK16 Mask         */
#define SCT_EV14_STATE_STATEMSK17_Pos         17                                                      /*!< SCT EV14_STATE: STATEMSK17 Position     */
#define SCT_EV14_STATE_STATEMSK17_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK17_Pos)               /*!< SCT EV14_STATE: STATEMSK17 Mask         */
#define SCT_EV14_STATE_STATEMSK18_Pos         18                                                      /*!< SCT EV14_STATE: STATEMSK18 Position     */
#define SCT_EV14_STATE_STATEMSK18_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK18_Pos)               /*!< SCT EV14_STATE: STATEMSK18 Mask         */
#define SCT_EV14_STATE_STATEMSK19_Pos         19                                                      /*!< SCT EV14_STATE: STATEMSK19 Position     */
#define SCT_EV14_STATE_STATEMSK19_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK19_Pos)               /*!< SCT EV14_STATE: STATEMSK19 Mask         */
#define SCT_EV14_STATE_STATEMSK20_Pos         20                                                      /*!< SCT EV14_STATE: STATEMSK20 Position     */
#define SCT_EV14_STATE_STATEMSK20_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK20_Pos)               /*!< SCT EV14_STATE: STATEMSK20 Mask         */
#define SCT_EV14_STATE_STATEMSK21_Pos         21                                                      /*!< SCT EV14_STATE: STATEMSK21 Position     */
#define SCT_EV14_STATE_STATEMSK21_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK21_Pos)               /*!< SCT EV14_STATE: STATEMSK21 Mask         */
#define SCT_EV14_STATE_STATEMSK22_Pos         22                                                      /*!< SCT EV14_STATE: STATEMSK22 Position     */
#define SCT_EV14_STATE_STATEMSK22_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK22_Pos)               /*!< SCT EV14_STATE: STATEMSK22 Mask         */
#define SCT_EV14_STATE_STATEMSK23_Pos         23                                                      /*!< SCT EV14_STATE: STATEMSK23 Position     */
#define SCT_EV14_STATE_STATEMSK23_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK23_Pos)               /*!< SCT EV14_STATE: STATEMSK23 Mask         */
#define SCT_EV14_STATE_STATEMSK24_Pos         24                                                      /*!< SCT EV14_STATE: STATEMSK24 Position     */
#define SCT_EV14_STATE_STATEMSK24_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK24_Pos)               /*!< SCT EV14_STATE: STATEMSK24 Mask         */
#define SCT_EV14_STATE_STATEMSK25_Pos         25                                                      /*!< SCT EV14_STATE: STATEMSK25 Position     */
#define SCT_EV14_STATE_STATEMSK25_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK25_Pos)               /*!< SCT EV14_STATE: STATEMSK25 Mask         */
#define SCT_EV14_STATE_STATEMSK26_Pos         26                                                      /*!< SCT EV14_STATE: STATEMSK26 Position     */
#define SCT_EV14_STATE_STATEMSK26_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK26_Pos)               /*!< SCT EV14_STATE: STATEMSK26 Mask         */
#define SCT_EV14_STATE_STATEMSK27_Pos         27                                                      /*!< SCT EV14_STATE: STATEMSK27 Position     */
#define SCT_EV14_STATE_STATEMSK27_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK27_Pos)               /*!< SCT EV14_STATE: STATEMSK27 Mask         */
#define SCT_EV14_STATE_STATEMSK28_Pos         28                                                      /*!< SCT EV14_STATE: STATEMSK28 Position     */
#define SCT_EV14_STATE_STATEMSK28_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK28_Pos)               /*!< SCT EV14_STATE: STATEMSK28 Mask         */
#define SCT_EV14_STATE_STATEMSK29_Pos         29                                                      /*!< SCT EV14_STATE: STATEMSK29 Position     */
#define SCT_EV14_STATE_STATEMSK29_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK29_Pos)               /*!< SCT EV14_STATE: STATEMSK29 Mask         */
#define SCT_EV14_STATE_STATEMSK30_Pos         30                                                      /*!< SCT EV14_STATE: STATEMSK30 Position     */
#define SCT_EV14_STATE_STATEMSK30_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK30_Pos)               /*!< SCT EV14_STATE: STATEMSK30 Mask         */
#define SCT_EV14_STATE_STATEMSK31_Pos         31                                                      /*!< SCT EV14_STATE: STATEMSK31 Position     */
#define SCT_EV14_STATE_STATEMSK31_Msk         (0x01UL << SCT_EV14_STATE_STATEMSK31_Pos)               /*!< SCT EV14_STATE: STATEMSK31 Mask         */

/* --------------------------------  SCT_EV14_CTRL  ------------------------------- */
#define SCT_EV14_CTRL_MATCHSEL_Pos            0                                                       /*!< SCT EV14_CTRL: MATCHSEL Position        */
#define SCT_EV14_CTRL_MATCHSEL_Msk            (0x0fUL << SCT_EV14_CTRL_MATCHSEL_Pos)                  /*!< SCT EV14_CTRL: MATCHSEL Mask            */
#define SCT_EV14_CTRL_HEVENT_Pos              4                                                       /*!< SCT EV14_CTRL: HEVENT Position          */
#define SCT_EV14_CTRL_HEVENT_Msk              (0x01UL << SCT_EV14_CTRL_HEVENT_Pos)                    /*!< SCT EV14_CTRL: HEVENT Mask              */
#define SCT_EV14_CTRL_OUTSEL_Pos              5                                                       /*!< SCT EV14_CTRL: OUTSEL Position          */
#define SCT_EV14_CTRL_OUTSEL_Msk              (0x01UL << SCT_EV14_CTRL_OUTSEL_Pos)                    /*!< SCT EV14_CTRL: OUTSEL Mask              */
#define SCT_EV14_CTRL_IOSEL_Pos               6                                                       /*!< SCT EV14_CTRL: IOSEL Position           */
#define SCT_EV14_CTRL_IOSEL_Msk               (0x0fUL << SCT_EV14_CTRL_IOSEL_Pos)                     /*!< SCT EV14_CTRL: IOSEL Mask               */
#define SCT_EV14_CTRL_IOCOND_Pos              10                                                      /*!< SCT EV14_CTRL: IOCOND Position          */
#define SCT_EV14_CTRL_IOCOND_Msk              (0x03UL << SCT_EV14_CTRL_IOCOND_Pos)                    /*!< SCT EV14_CTRL: IOCOND Mask              */
#define SCT_EV14_CTRL_COMBMODE_Pos            12                                                      /*!< SCT EV14_CTRL: COMBMODE Position        */
#define SCT_EV14_CTRL_COMBMODE_Msk            (0x03UL << SCT_EV14_CTRL_COMBMODE_Pos)                  /*!< SCT EV14_CTRL: COMBMODE Mask            */
#define SCT_EV14_CTRL_STATELD_Pos             14                                                      /*!< SCT EV14_CTRL: STATELD Position         */
#define SCT_EV14_CTRL_STATELD_Msk             (0x01UL << SCT_EV14_CTRL_STATELD_Pos)                   /*!< SCT EV14_CTRL: STATELD Mask             */
#define SCT_EV14_CTRL_STATEV_Pos              15                                                      /*!< SCT EV14_CTRL: STATEV Position          */
#define SCT_EV14_CTRL_STATEV_Msk              (0x1fUL << SCT_EV14_CTRL_STATEV_Pos)                    /*!< SCT EV14_CTRL: STATEV Mask              */
#define SCT_EV14_CTRL_MATCHMEM_Pos            20                                                      /*!< SCT EV14_CTRL: MATCHMEM Position        */
#define SCT_EV14_CTRL_MATCHMEM_Msk            (0x01UL << SCT_EV14_CTRL_MATCHMEM_Pos)                  /*!< SCT EV14_CTRL: MATCHMEM Mask            */
#define SCT_EV14_CTRL_DIRECTION_Pos           21                                                      /*!< SCT EV14_CTRL: DIRECTION Position       */
#define SCT_EV14_CTRL_DIRECTION_Msk           (0x03UL << SCT_EV14_CTRL_DIRECTION_Pos)                 /*!< SCT EV14_CTRL: DIRECTION Mask           */

/* -------------------------------  SCT_EV15_STATE  ------------------------------- */
#define SCT_EV15_STATE_STATEMSK0_Pos          0                                                       /*!< SCT EV15_STATE: STATEMSK0 Position      */
#define SCT_EV15_STATE_STATEMSK0_Msk          (0x01UL << SCT_EV15_STATE_STATEMSK0_Pos)                /*!< SCT EV15_STATE: STATEMSK0 Mask          */
#define SCT_EV15_STATE_STATEMSK1_Pos          1                                                       /*!< SCT EV15_STATE: STATEMSK1 Position      */
#define SCT_EV15_STATE_STATEMSK1_Msk          (0x01UL << SCT_EV15_STATE_STATEMSK1_Pos)                /*!< SCT EV15_STATE: STATEMSK1 Mask          */
#define SCT_EV15_STATE_STATEMSK2_Pos          2                                                       /*!< SCT EV15_STATE: STATEMSK2 Position      */
#define SCT_EV15_STATE_STATEMSK2_Msk          (0x01UL << SCT_EV15_STATE_STATEMSK2_Pos)                /*!< SCT EV15_STATE: STATEMSK2 Mask          */
#define SCT_EV15_STATE_STATEMSK3_Pos          3                                                       /*!< SCT EV15_STATE: STATEMSK3 Position      */
#define SCT_EV15_STATE_STATEMSK3_Msk          (0x01UL << SCT_EV15_STATE_STATEMSK3_Pos)                /*!< SCT EV15_STATE: STATEMSK3 Mask          */
#define SCT_EV15_STATE_STATEMSK4_Pos          4                                                       /*!< SCT EV15_STATE: STATEMSK4 Position      */
#define SCT_EV15_STATE_STATEMSK4_Msk          (0x01UL << SCT_EV15_STATE_STATEMSK4_Pos)                /*!< SCT EV15_STATE: STATEMSK4 Mask          */
#define SCT_EV15_STATE_STATEMSK5_Pos          5                                                       /*!< SCT EV15_STATE: STATEMSK5 Position      */
#define SCT_EV15_STATE_STATEMSK5_Msk          (0x01UL << SCT_EV15_STATE_STATEMSK5_Pos)                /*!< SCT EV15_STATE: STATEMSK5 Mask          */
#define SCT_EV15_STATE_STATEMSK6_Pos          6                                                       /*!< SCT EV15_STATE: STATEMSK6 Position      */
#define SCT_EV15_STATE_STATEMSK6_Msk          (0x01UL << SCT_EV15_STATE_STATEMSK6_Pos)                /*!< SCT EV15_STATE: STATEMSK6 Mask          */
#define SCT_EV15_STATE_STATEMSK7_Pos          7                                                       /*!< SCT EV15_STATE: STATEMSK7 Position      */
#define SCT_EV15_STATE_STATEMSK7_Msk          (0x01UL << SCT_EV15_STATE_STATEMSK7_Pos)                /*!< SCT EV15_STATE: STATEMSK7 Mask          */
#define SCT_EV15_STATE_STATEMSK8_Pos          8                                                       /*!< SCT EV15_STATE: STATEMSK8 Position      */
#define SCT_EV15_STATE_STATEMSK8_Msk          (0x01UL << SCT_EV15_STATE_STATEMSK8_Pos)                /*!< SCT EV15_STATE: STATEMSK8 Mask          */
#define SCT_EV15_STATE_STATEMSK9_Pos          9                                                       /*!< SCT EV15_STATE: STATEMSK9 Position      */
#define SCT_EV15_STATE_STATEMSK9_Msk          (0x01UL << SCT_EV15_STATE_STATEMSK9_Pos)                /*!< SCT EV15_STATE: STATEMSK9 Mask          */
#define SCT_EV15_STATE_STATEMSK10_Pos         10                                                      /*!< SCT EV15_STATE: STATEMSK10 Position     */
#define SCT_EV15_STATE_STATEMSK10_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK10_Pos)               /*!< SCT EV15_STATE: STATEMSK10 Mask         */
#define SCT_EV15_STATE_STATEMSK11_Pos         11                                                      /*!< SCT EV15_STATE: STATEMSK11 Position     */
#define SCT_EV15_STATE_STATEMSK11_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK11_Pos)               /*!< SCT EV15_STATE: STATEMSK11 Mask         */
#define SCT_EV15_STATE_STATEMSK12_Pos         12                                                      /*!< SCT EV15_STATE: STATEMSK12 Position     */
#define SCT_EV15_STATE_STATEMSK12_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK12_Pos)               /*!< SCT EV15_STATE: STATEMSK12 Mask         */
#define SCT_EV15_STATE_STATEMSK13_Pos         13                                                      /*!< SCT EV15_STATE: STATEMSK13 Position     */
#define SCT_EV15_STATE_STATEMSK13_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK13_Pos)               /*!< SCT EV15_STATE: STATEMSK13 Mask         */
#define SCT_EV15_STATE_STATEMSK14_Pos         14                                                      /*!< SCT EV15_STATE: STATEMSK14 Position     */
#define SCT_EV15_STATE_STATEMSK14_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK14_Pos)               /*!< SCT EV15_STATE: STATEMSK14 Mask         */
#define SCT_EV15_STATE_STATEMSK15_Pos         15                                                      /*!< SCT EV15_STATE: STATEMSK15 Position     */
#define SCT_EV15_STATE_STATEMSK15_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK15_Pos)               /*!< SCT EV15_STATE: STATEMSK15 Mask         */
#define SCT_EV15_STATE_STATEMSK16_Pos         16                                                      /*!< SCT EV15_STATE: STATEMSK16 Position     */
#define SCT_EV15_STATE_STATEMSK16_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK16_Pos)               /*!< SCT EV15_STATE: STATEMSK16 Mask         */
#define SCT_EV15_STATE_STATEMSK17_Pos         17                                                      /*!< SCT EV15_STATE: STATEMSK17 Position     */
#define SCT_EV15_STATE_STATEMSK17_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK17_Pos)               /*!< SCT EV15_STATE: STATEMSK17 Mask         */
#define SCT_EV15_STATE_STATEMSK18_Pos         18                                                      /*!< SCT EV15_STATE: STATEMSK18 Position     */
#define SCT_EV15_STATE_STATEMSK18_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK18_Pos)               /*!< SCT EV15_STATE: STATEMSK18 Mask         */
#define SCT_EV15_STATE_STATEMSK19_Pos         19                                                      /*!< SCT EV15_STATE: STATEMSK19 Position     */
#define SCT_EV15_STATE_STATEMSK19_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK19_Pos)               /*!< SCT EV15_STATE: STATEMSK19 Mask         */
#define SCT_EV15_STATE_STATEMSK20_Pos         20                                                      /*!< SCT EV15_STATE: STATEMSK20 Position     */
#define SCT_EV15_STATE_STATEMSK20_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK20_Pos)               /*!< SCT EV15_STATE: STATEMSK20 Mask         */
#define SCT_EV15_STATE_STATEMSK21_Pos         21                                                      /*!< SCT EV15_STATE: STATEMSK21 Position     */
#define SCT_EV15_STATE_STATEMSK21_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK21_Pos)               /*!< SCT EV15_STATE: STATEMSK21 Mask         */
#define SCT_EV15_STATE_STATEMSK22_Pos         22                                                      /*!< SCT EV15_STATE: STATEMSK22 Position     */
#define SCT_EV15_STATE_STATEMSK22_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK22_Pos)               /*!< SCT EV15_STATE: STATEMSK22 Mask         */
#define SCT_EV15_STATE_STATEMSK23_Pos         23                                                      /*!< SCT EV15_STATE: STATEMSK23 Position     */
#define SCT_EV15_STATE_STATEMSK23_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK23_Pos)               /*!< SCT EV15_STATE: STATEMSK23 Mask         */
#define SCT_EV15_STATE_STATEMSK24_Pos         24                                                      /*!< SCT EV15_STATE: STATEMSK24 Position     */
#define SCT_EV15_STATE_STATEMSK24_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK24_Pos)               /*!< SCT EV15_STATE: STATEMSK24 Mask         */
#define SCT_EV15_STATE_STATEMSK25_Pos         25                                                      /*!< SCT EV15_STATE: STATEMSK25 Position     */
#define SCT_EV15_STATE_STATEMSK25_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK25_Pos)               /*!< SCT EV15_STATE: STATEMSK25 Mask         */
#define SCT_EV15_STATE_STATEMSK26_Pos         26                                                      /*!< SCT EV15_STATE: STATEMSK26 Position     */
#define SCT_EV15_STATE_STATEMSK26_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK26_Pos)               /*!< SCT EV15_STATE: STATEMSK26 Mask         */
#define SCT_EV15_STATE_STATEMSK27_Pos         27                                                      /*!< SCT EV15_STATE: STATEMSK27 Position     */
#define SCT_EV15_STATE_STATEMSK27_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK27_Pos)               /*!< SCT EV15_STATE: STATEMSK27 Mask         */
#define SCT_EV15_STATE_STATEMSK28_Pos         28                                                      /*!< SCT EV15_STATE: STATEMSK28 Position     */
#define SCT_EV15_STATE_STATEMSK28_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK28_Pos)               /*!< SCT EV15_STATE: STATEMSK28 Mask         */
#define SCT_EV15_STATE_STATEMSK29_Pos         29                                                      /*!< SCT EV15_STATE: STATEMSK29 Position     */
#define SCT_EV15_STATE_STATEMSK29_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK29_Pos)               /*!< SCT EV15_STATE: STATEMSK29 Mask         */
#define SCT_EV15_STATE_STATEMSK30_Pos         30                                                      /*!< SCT EV15_STATE: STATEMSK30 Position     */
#define SCT_EV15_STATE_STATEMSK30_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK30_Pos)               /*!< SCT EV15_STATE: STATEMSK30 Mask         */
#define SCT_EV15_STATE_STATEMSK31_Pos         31                                                      /*!< SCT EV15_STATE: STATEMSK31 Position     */
#define SCT_EV15_STATE_STATEMSK31_Msk         (0x01UL << SCT_EV15_STATE_STATEMSK31_Pos)               /*!< SCT EV15_STATE: STATEMSK31 Mask         */

/* --------------------------------  SCT_EV15_CTRL  ------------------------------- */
#define SCT_EV15_CTRL_MATCHSEL_Pos            0                                                       /*!< SCT EV15_CTRL: MATCHSEL Position        */
#define SCT_EV15_CTRL_MATCHSEL_Msk            (0x0fUL << SCT_EV15_CTRL_MATCHSEL_Pos)                  /*!< SCT EV15_CTRL: MATCHSEL Mask            */
#define SCT_EV15_CTRL_HEVENT_Pos              4                                                       /*!< SCT EV15_CTRL: HEVENT Position          */
#define SCT_EV15_CTRL_HEVENT_Msk              (0x01UL << SCT_EV15_CTRL_HEVENT_Pos)                    /*!< SCT EV15_CTRL: HEVENT Mask              */
#define SCT_EV15_CTRL_OUTSEL_Pos              5                                                       /*!< SCT EV15_CTRL: OUTSEL Position          */
#define SCT_EV15_CTRL_OUTSEL_Msk              (0x01UL << SCT_EV15_CTRL_OUTSEL_Pos)                    /*!< SCT EV15_CTRL: OUTSEL Mask              */
#define SCT_EV15_CTRL_IOSEL_Pos               6                                                       /*!< SCT EV15_CTRL: IOSEL Position           */
#define SCT_EV15_CTRL_IOSEL_Msk               (0x0fUL << SCT_EV15_CTRL_IOSEL_Pos)                     /*!< SCT EV15_CTRL: IOSEL Mask               */
#define SCT_EV15_CTRL_IOCOND_Pos              10                                                      /*!< SCT EV15_CTRL: IOCOND Position          */
#define SCT_EV15_CTRL_IOCOND_Msk              (0x03UL << SCT_EV15_CTRL_IOCOND_Pos)                    /*!< SCT EV15_CTRL: IOCOND Mask              */
#define SCT_EV15_CTRL_COMBMODE_Pos            12                                                      /*!< SCT EV15_CTRL: COMBMODE Position        */
#define SCT_EV15_CTRL_COMBMODE_Msk            (0x03UL << SCT_EV15_CTRL_COMBMODE_Pos)                  /*!< SCT EV15_CTRL: COMBMODE Mask            */
#define SCT_EV15_CTRL_STATELD_Pos             14                                                      /*!< SCT EV15_CTRL: STATELD Position         */
#define SCT_EV15_CTRL_STATELD_Msk             (0x01UL << SCT_EV15_CTRL_STATELD_Pos)                   /*!< SCT EV15_CTRL: STATELD Mask             */
#define SCT_EV15_CTRL_STATEV_Pos              15                                                      /*!< SCT EV15_CTRL: STATEV Position          */
#define SCT_EV15_CTRL_STATEV_Msk              (0x1fUL << SCT_EV15_CTRL_STATEV_Pos)                    /*!< SCT EV15_CTRL: STATEV Mask              */
#define SCT_EV15_CTRL_MATCHMEM_Pos            20                                                      /*!< SCT EV15_CTRL: MATCHMEM Position        */
#define SCT_EV15_CTRL_MATCHMEM_Msk            (0x01UL << SCT_EV15_CTRL_MATCHMEM_Pos)                  /*!< SCT EV15_CTRL: MATCHMEM Mask            */
#define SCT_EV15_CTRL_DIRECTION_Pos           21                                                      /*!< SCT EV15_CTRL: DIRECTION Position       */
#define SCT_EV15_CTRL_DIRECTION_Msk           (0x03UL << SCT_EV15_CTRL_DIRECTION_Pos)                 /*!< SCT EV15_CTRL: DIRECTION Mask           */

/* --------------------------------  SCT_OUT0_SET  -------------------------------- */
#define SCT_OUT0_SET_SET0_Pos                 0                                                       /*!< SCT OUT0_SET: SET0 Position             */
#define SCT_OUT0_SET_SET0_Msk                 (0x01UL << SCT_OUT0_SET_SET0_Pos)                       /*!< SCT OUT0_SET: SET0 Mask                 */
#define SCT_OUT0_SET_SET1_Pos                 1                                                       /*!< SCT OUT0_SET: SET1 Position             */
#define SCT_OUT0_SET_SET1_Msk                 (0x01UL << SCT_OUT0_SET_SET1_Pos)                       /*!< SCT OUT0_SET: SET1 Mask                 */
#define SCT_OUT0_SET_SET2_Pos                 2                                                       /*!< SCT OUT0_SET: SET2 Position             */
#define SCT_OUT0_SET_SET2_Msk                 (0x01UL << SCT_OUT0_SET_SET2_Pos)                       /*!< SCT OUT0_SET: SET2 Mask                 */
#define SCT_OUT0_SET_SET3_Pos                 3                                                       /*!< SCT OUT0_SET: SET3 Position             */
#define SCT_OUT0_SET_SET3_Msk                 (0x01UL << SCT_OUT0_SET_SET3_Pos)                       /*!< SCT OUT0_SET: SET3 Mask                 */
#define SCT_OUT0_SET_SET4_Pos                 4                                                       /*!< SCT OUT0_SET: SET4 Position             */
#define SCT_OUT0_SET_SET4_Msk                 (0x01UL << SCT_OUT0_SET_SET4_Pos)                       /*!< SCT OUT0_SET: SET4 Mask                 */
#define SCT_OUT0_SET_SET5_Pos                 5                                                       /*!< SCT OUT0_SET: SET5 Position             */
#define SCT_OUT0_SET_SET5_Msk                 (0x01UL << SCT_OUT0_SET_SET5_Pos)                       /*!< SCT OUT0_SET: SET5 Mask                 */
#define SCT_OUT0_SET_SET6_Pos                 6                                                       /*!< SCT OUT0_SET: SET6 Position             */
#define SCT_OUT0_SET_SET6_Msk                 (0x01UL << SCT_OUT0_SET_SET6_Pos)                       /*!< SCT OUT0_SET: SET6 Mask                 */
#define SCT_OUT0_SET_SET7_Pos                 7                                                       /*!< SCT OUT0_SET: SET7 Position             */
#define SCT_OUT0_SET_SET7_Msk                 (0x01UL << SCT_OUT0_SET_SET7_Pos)                       /*!< SCT OUT0_SET: SET7 Mask                 */
#define SCT_OUT0_SET_SET8_Pos                 8                                                       /*!< SCT OUT0_SET: SET8 Position             */
#define SCT_OUT0_SET_SET8_Msk                 (0x01UL << SCT_OUT0_SET_SET8_Pos)                       /*!< SCT OUT0_SET: SET8 Mask                 */
#define SCT_OUT0_SET_SET9_Pos                 9                                                       /*!< SCT OUT0_SET: SET9 Position             */
#define SCT_OUT0_SET_SET9_Msk                 (0x01UL << SCT_OUT0_SET_SET9_Pos)                       /*!< SCT OUT0_SET: SET9 Mask                 */
#define SCT_OUT0_SET_SET10_Pos                10                                                      /*!< SCT OUT0_SET: SET10 Position            */
#define SCT_OUT0_SET_SET10_Msk                (0x01UL << SCT_OUT0_SET_SET10_Pos)                      /*!< SCT OUT0_SET: SET10 Mask                */
#define SCT_OUT0_SET_SET11_Pos                11                                                      /*!< SCT OUT0_SET: SET11 Position            */
#define SCT_OUT0_SET_SET11_Msk                (0x01UL << SCT_OUT0_SET_SET11_Pos)                      /*!< SCT OUT0_SET: SET11 Mask                */
#define SCT_OUT0_SET_SET12_Pos                12                                                      /*!< SCT OUT0_SET: SET12 Position            */
#define SCT_OUT0_SET_SET12_Msk                (0x01UL << SCT_OUT0_SET_SET12_Pos)                      /*!< SCT OUT0_SET: SET12 Mask                */
#define SCT_OUT0_SET_SET13_Pos                13                                                      /*!< SCT OUT0_SET: SET13 Position            */
#define SCT_OUT0_SET_SET13_Msk                (0x01UL << SCT_OUT0_SET_SET13_Pos)                      /*!< SCT OUT0_SET: SET13 Mask                */
#define SCT_OUT0_SET_SET14_Pos                14                                                      /*!< SCT OUT0_SET: SET14 Position            */
#define SCT_OUT0_SET_SET14_Msk                (0x01UL << SCT_OUT0_SET_SET14_Pos)                      /*!< SCT OUT0_SET: SET14 Mask                */
#define SCT_OUT0_SET_SET15_Pos                15                                                      /*!< SCT OUT0_SET: SET15 Position            */
#define SCT_OUT0_SET_SET15_Msk                (0x01UL << SCT_OUT0_SET_SET15_Pos)                      /*!< SCT OUT0_SET: SET15 Mask                */

/* --------------------------------  SCT_OUT0_CLR  -------------------------------- */
#define SCT_OUT0_CLR_CLR0_Pos                 0                                                       /*!< SCT OUT0_CLR: CLR0 Position             */
#define SCT_OUT0_CLR_CLR0_Msk                 (0x01UL << SCT_OUT0_CLR_CLR0_Pos)                       /*!< SCT OUT0_CLR: CLR0 Mask                 */
#define SCT_OUT0_CLR_CLR1_Pos                 1                                                       /*!< SCT OUT0_CLR: CLR1 Position             */
#define SCT_OUT0_CLR_CLR1_Msk                 (0x01UL << SCT_OUT0_CLR_CLR1_Pos)                       /*!< SCT OUT0_CLR: CLR1 Mask                 */
#define SCT_OUT0_CLR_CLR2_Pos                 2                                                       /*!< SCT OUT0_CLR: CLR2 Position             */
#define SCT_OUT0_CLR_CLR2_Msk                 (0x01UL << SCT_OUT0_CLR_CLR2_Pos)                       /*!< SCT OUT0_CLR: CLR2 Mask                 */
#define SCT_OUT0_CLR_CLR3_Pos                 3                                                       /*!< SCT OUT0_CLR: CLR3 Position             */
#define SCT_OUT0_CLR_CLR3_Msk                 (0x01UL << SCT_OUT0_CLR_CLR3_Pos)                       /*!< SCT OUT0_CLR: CLR3 Mask                 */
#define SCT_OUT0_CLR_CLR4_Pos                 4                                                       /*!< SCT OUT0_CLR: CLR4 Position             */
#define SCT_OUT0_CLR_CLR4_Msk                 (0x01UL << SCT_OUT0_CLR_CLR4_Pos)                       /*!< SCT OUT0_CLR: CLR4 Mask                 */
#define SCT_OUT0_CLR_CLR5_Pos                 5                                                       /*!< SCT OUT0_CLR: CLR5 Position             */
#define SCT_OUT0_CLR_CLR5_Msk                 (0x01UL << SCT_OUT0_CLR_CLR5_Pos)                       /*!< SCT OUT0_CLR: CLR5 Mask                 */
#define SCT_OUT0_CLR_CLR6_Pos                 6                                                       /*!< SCT OUT0_CLR: CLR6 Position             */
#define SCT_OUT0_CLR_CLR6_Msk                 (0x01UL << SCT_OUT0_CLR_CLR6_Pos)                       /*!< SCT OUT0_CLR: CLR6 Mask                 */
#define SCT_OUT0_CLR_CLR7_Pos                 7                                                       /*!< SCT OUT0_CLR: CLR7 Position             */
#define SCT_OUT0_CLR_CLR7_Msk                 (0x01UL << SCT_OUT0_CLR_CLR7_Pos)                       /*!< SCT OUT0_CLR: CLR7 Mask                 */
#define SCT_OUT0_CLR_CLR8_Pos                 8                                                       /*!< SCT OUT0_CLR: CLR8 Position             */
#define SCT_OUT0_CLR_CLR8_Msk                 (0x01UL << SCT_OUT0_CLR_CLR8_Pos)                       /*!< SCT OUT0_CLR: CLR8 Mask                 */
#define SCT_OUT0_CLR_CLR9_Pos                 9                                                       /*!< SCT OUT0_CLR: CLR9 Position             */
#define SCT_OUT0_CLR_CLR9_Msk                 (0x01UL << SCT_OUT0_CLR_CLR9_Pos)                       /*!< SCT OUT0_CLR: CLR9 Mask                 */
#define SCT_OUT0_CLR_CLR10_Pos                10                                                      /*!< SCT OUT0_CLR: CLR10 Position            */
#define SCT_OUT0_CLR_CLR10_Msk                (0x01UL << SCT_OUT0_CLR_CLR10_Pos)                      /*!< SCT OUT0_CLR: CLR10 Mask                */
#define SCT_OUT0_CLR_CLR11_Pos                11                                                      /*!< SCT OUT0_CLR: CLR11 Position            */
#define SCT_OUT0_CLR_CLR11_Msk                (0x01UL << SCT_OUT0_CLR_CLR11_Pos)                      /*!< SCT OUT0_CLR: CLR11 Mask                */
#define SCT_OUT0_CLR_CLR12_Pos                12                                                      /*!< SCT OUT0_CLR: CLR12 Position            */
#define SCT_OUT0_CLR_CLR12_Msk                (0x01UL << SCT_OUT0_CLR_CLR12_Pos)                      /*!< SCT OUT0_CLR: CLR12 Mask                */
#define SCT_OUT0_CLR_CLR13_Pos                13                                                      /*!< SCT OUT0_CLR: CLR13 Position            */
#define SCT_OUT0_CLR_CLR13_Msk                (0x01UL << SCT_OUT0_CLR_CLR13_Pos)                      /*!< SCT OUT0_CLR: CLR13 Mask                */
#define SCT_OUT0_CLR_CLR14_Pos                14                                                      /*!< SCT OUT0_CLR: CLR14 Position            */
#define SCT_OUT0_CLR_CLR14_Msk                (0x01UL << SCT_OUT0_CLR_CLR14_Pos)                      /*!< SCT OUT0_CLR: CLR14 Mask                */
#define SCT_OUT0_CLR_CLR15_Pos                15                                                      /*!< SCT OUT0_CLR: CLR15 Position            */
#define SCT_OUT0_CLR_CLR15_Msk                (0x01UL << SCT_OUT0_CLR_CLR15_Pos)                      /*!< SCT OUT0_CLR: CLR15 Mask                */

/* --------------------------------  SCT_OUT1_SET  -------------------------------- */
#define SCT_OUT1_SET_SET0_Pos                 0                                                       /*!< SCT OUT1_SET: SET0 Position             */
#define SCT_OUT1_SET_SET0_Msk                 (0x01UL << SCT_OUT1_SET_SET0_Pos)                       /*!< SCT OUT1_SET: SET0 Mask                 */
#define SCT_OUT1_SET_SET1_Pos                 1                                                       /*!< SCT OUT1_SET: SET1 Position             */
#define SCT_OUT1_SET_SET1_Msk                 (0x01UL << SCT_OUT1_SET_SET1_Pos)                       /*!< SCT OUT1_SET: SET1 Mask                 */
#define SCT_OUT1_SET_SET2_Pos                 2                                                       /*!< SCT OUT1_SET: SET2 Position             */
#define SCT_OUT1_SET_SET2_Msk                 (0x01UL << SCT_OUT1_SET_SET2_Pos)                       /*!< SCT OUT1_SET: SET2 Mask                 */
#define SCT_OUT1_SET_SET3_Pos                 3                                                       /*!< SCT OUT1_SET: SET3 Position             */
#define SCT_OUT1_SET_SET3_Msk                 (0x01UL << SCT_OUT1_SET_SET3_Pos)                       /*!< SCT OUT1_SET: SET3 Mask                 */
#define SCT_OUT1_SET_SET4_Pos                 4                                                       /*!< SCT OUT1_SET: SET4 Position             */
#define SCT_OUT1_SET_SET4_Msk                 (0x01UL << SCT_OUT1_SET_SET4_Pos)                       /*!< SCT OUT1_SET: SET4 Mask                 */
#define SCT_OUT1_SET_SET5_Pos                 5                                                       /*!< SCT OUT1_SET: SET5 Position             */
#define SCT_OUT1_SET_SET5_Msk                 (0x01UL << SCT_OUT1_SET_SET5_Pos)                       /*!< SCT OUT1_SET: SET5 Mask                 */
#define SCT_OUT1_SET_SET6_Pos                 6                                                       /*!< SCT OUT1_SET: SET6 Position             */
#define SCT_OUT1_SET_SET6_Msk                 (0x01UL << SCT_OUT1_SET_SET6_Pos)                       /*!< SCT OUT1_SET: SET6 Mask                 */
#define SCT_OUT1_SET_SET7_Pos                 7                                                       /*!< SCT OUT1_SET: SET7 Position             */
#define SCT_OUT1_SET_SET7_Msk                 (0x01UL << SCT_OUT1_SET_SET7_Pos)                       /*!< SCT OUT1_SET: SET7 Mask                 */
#define SCT_OUT1_SET_SET8_Pos                 8                                                       /*!< SCT OUT1_SET: SET8 Position             */
#define SCT_OUT1_SET_SET8_Msk                 (0x01UL << SCT_OUT1_SET_SET8_Pos)                       /*!< SCT OUT1_SET: SET8 Mask                 */
#define SCT_OUT1_SET_SET9_Pos                 9                                                       /*!< SCT OUT1_SET: SET9 Position             */
#define SCT_OUT1_SET_SET9_Msk                 (0x01UL << SCT_OUT1_SET_SET9_Pos)                       /*!< SCT OUT1_SET: SET9 Mask                 */
#define SCT_OUT1_SET_SET10_Pos                10                                                      /*!< SCT OUT1_SET: SET10 Position            */
#define SCT_OUT1_SET_SET10_Msk                (0x01UL << SCT_OUT1_SET_SET10_Pos)                      /*!< SCT OUT1_SET: SET10 Mask                */
#define SCT_OUT1_SET_SET11_Pos                11                                                      /*!< SCT OUT1_SET: SET11 Position            */
#define SCT_OUT1_SET_SET11_Msk                (0x01UL << SCT_OUT1_SET_SET11_Pos)                      /*!< SCT OUT1_SET: SET11 Mask                */
#define SCT_OUT1_SET_SET12_Pos                12                                                      /*!< SCT OUT1_SET: SET12 Position            */
#define SCT_OUT1_SET_SET12_Msk                (0x01UL << SCT_OUT1_SET_SET12_Pos)                      /*!< SCT OUT1_SET: SET12 Mask                */
#define SCT_OUT1_SET_SET13_Pos                13                                                      /*!< SCT OUT1_SET: SET13 Position            */
#define SCT_OUT1_SET_SET13_Msk                (0x01UL << SCT_OUT1_SET_SET13_Pos)                      /*!< SCT OUT1_SET: SET13 Mask                */
#define SCT_OUT1_SET_SET14_Pos                14                                                      /*!< SCT OUT1_SET: SET14 Position            */
#define SCT_OUT1_SET_SET14_Msk                (0x01UL << SCT_OUT1_SET_SET14_Pos)                      /*!< SCT OUT1_SET: SET14 Mask                */
#define SCT_OUT1_SET_SET15_Pos                15                                                      /*!< SCT OUT1_SET: SET15 Position            */
#define SCT_OUT1_SET_SET15_Msk                (0x01UL << SCT_OUT1_SET_SET15_Pos)                      /*!< SCT OUT1_SET: SET15 Mask                */

/* --------------------------------  SCT_OUT1_CLR  -------------------------------- */
#define SCT_OUT1_CLR_CLR0_Pos                 0                                                       /*!< SCT OUT1_CLR: CLR0 Position             */
#define SCT_OUT1_CLR_CLR0_Msk                 (0x01UL << SCT_OUT1_CLR_CLR0_Pos)                       /*!< SCT OUT1_CLR: CLR0 Mask                 */
#define SCT_OUT1_CLR_CLR1_Pos                 1                                                       /*!< SCT OUT1_CLR: CLR1 Position             */
#define SCT_OUT1_CLR_CLR1_Msk                 (0x01UL << SCT_OUT1_CLR_CLR1_Pos)                       /*!< SCT OUT1_CLR: CLR1 Mask                 */
#define SCT_OUT1_CLR_CLR2_Pos                 2                                                       /*!< SCT OUT1_CLR: CLR2 Position             */
#define SCT_OUT1_CLR_CLR2_Msk                 (0x01UL << SCT_OUT1_CLR_CLR2_Pos)                       /*!< SCT OUT1_CLR: CLR2 Mask                 */
#define SCT_OUT1_CLR_CLR3_Pos                 3                                                       /*!< SCT OUT1_CLR: CLR3 Position             */
#define SCT_OUT1_CLR_CLR3_Msk                 (0x01UL << SCT_OUT1_CLR_CLR3_Pos)                       /*!< SCT OUT1_CLR: CLR3 Mask                 */
#define SCT_OUT1_CLR_CLR4_Pos                 4                                                       /*!< SCT OUT1_CLR: CLR4 Position             */
#define SCT_OUT1_CLR_CLR4_Msk                 (0x01UL << SCT_OUT1_CLR_CLR4_Pos)                       /*!< SCT OUT1_CLR: CLR4 Mask                 */
#define SCT_OUT1_CLR_CLR5_Pos                 5                                                       /*!< SCT OUT1_CLR: CLR5 Position             */
#define SCT_OUT1_CLR_CLR5_Msk                 (0x01UL << SCT_OUT1_CLR_CLR5_Pos)                       /*!< SCT OUT1_CLR: CLR5 Mask                 */
#define SCT_OUT1_CLR_CLR6_Pos                 6                                                       /*!< SCT OUT1_CLR: CLR6 Position             */
#define SCT_OUT1_CLR_CLR6_Msk                 (0x01UL << SCT_OUT1_CLR_CLR6_Pos)                       /*!< SCT OUT1_CLR: CLR6 Mask                 */
#define SCT_OUT1_CLR_CLR7_Pos                 7                                                       /*!< SCT OUT1_CLR: CLR7 Position             */
#define SCT_OUT1_CLR_CLR7_Msk                 (0x01UL << SCT_OUT1_CLR_CLR7_Pos)                       /*!< SCT OUT1_CLR: CLR7 Mask                 */
#define SCT_OUT1_CLR_CLR8_Pos                 8                                                       /*!< SCT OUT1_CLR: CLR8 Position             */
#define SCT_OUT1_CLR_CLR8_Msk                 (0x01UL << SCT_OUT1_CLR_CLR8_Pos)                       /*!< SCT OUT1_CLR: CLR8 Mask                 */
#define SCT_OUT1_CLR_CLR9_Pos                 9                                                       /*!< SCT OUT1_CLR: CLR9 Position             */
#define SCT_OUT1_CLR_CLR9_Msk                 (0x01UL << SCT_OUT1_CLR_CLR9_Pos)                       /*!< SCT OUT1_CLR: CLR9 Mask                 */
#define SCT_OUT1_CLR_CLR10_Pos                10                                                      /*!< SCT OUT1_CLR: CLR10 Position            */
#define SCT_OUT1_CLR_CLR10_Msk                (0x01UL << SCT_OUT1_CLR_CLR10_Pos)                      /*!< SCT OUT1_CLR: CLR10 Mask                */
#define SCT_OUT1_CLR_CLR11_Pos                11                                                      /*!< SCT OUT1_CLR: CLR11 Position            */
#define SCT_OUT1_CLR_CLR11_Msk                (0x01UL << SCT_OUT1_CLR_CLR11_Pos)                      /*!< SCT OUT1_CLR: CLR11 Mask                */
#define SCT_OUT1_CLR_CLR12_Pos                12                                                      /*!< SCT OUT1_CLR: CLR12 Position            */
#define SCT_OUT1_CLR_CLR12_Msk                (0x01UL << SCT_OUT1_CLR_CLR12_Pos)                      /*!< SCT OUT1_CLR: CLR12 Mask                */
#define SCT_OUT1_CLR_CLR13_Pos                13                                                      /*!< SCT OUT1_CLR: CLR13 Position            */
#define SCT_OUT1_CLR_CLR13_Msk                (0x01UL << SCT_OUT1_CLR_CLR13_Pos)                      /*!< SCT OUT1_CLR: CLR13 Mask                */
#define SCT_OUT1_CLR_CLR14_Pos                14                                                      /*!< SCT OUT1_CLR: CLR14 Position            */
#define SCT_OUT1_CLR_CLR14_Msk                (0x01UL << SCT_OUT1_CLR_CLR14_Pos)                      /*!< SCT OUT1_CLR: CLR14 Mask                */
#define SCT_OUT1_CLR_CLR15_Pos                15                                                      /*!< SCT OUT1_CLR: CLR15 Position            */
#define SCT_OUT1_CLR_CLR15_Msk                (0x01UL << SCT_OUT1_CLR_CLR15_Pos)                      /*!< SCT OUT1_CLR: CLR15 Mask                */

/* --------------------------------  SCT_OUT2_SET  -------------------------------- */
#define SCT_OUT2_SET_SET0_Pos                 0                                                       /*!< SCT OUT2_SET: SET0 Position             */
#define SCT_OUT2_SET_SET0_Msk                 (0x01UL << SCT_OUT2_SET_SET0_Pos)                       /*!< SCT OUT2_SET: SET0 Mask                 */
#define SCT_OUT2_SET_SET1_Pos                 1                                                       /*!< SCT OUT2_SET: SET1 Position             */
#define SCT_OUT2_SET_SET1_Msk                 (0x01UL << SCT_OUT2_SET_SET1_Pos)                       /*!< SCT OUT2_SET: SET1 Mask                 */
#define SCT_OUT2_SET_SET2_Pos                 2                                                       /*!< SCT OUT2_SET: SET2 Position             */
#define SCT_OUT2_SET_SET2_Msk                 (0x01UL << SCT_OUT2_SET_SET2_Pos)                       /*!< SCT OUT2_SET: SET2 Mask                 */
#define SCT_OUT2_SET_SET3_Pos                 3                                                       /*!< SCT OUT2_SET: SET3 Position             */
#define SCT_OUT2_SET_SET3_Msk                 (0x01UL << SCT_OUT2_SET_SET3_Pos)                       /*!< SCT OUT2_SET: SET3 Mask                 */
#define SCT_OUT2_SET_SET4_Pos                 4                                                       /*!< SCT OUT2_SET: SET4 Position             */
#define SCT_OUT2_SET_SET4_Msk                 (0x01UL << SCT_OUT2_SET_SET4_Pos)                       /*!< SCT OUT2_SET: SET4 Mask                 */
#define SCT_OUT2_SET_SET5_Pos                 5                                                       /*!< SCT OUT2_SET: SET5 Position             */
#define SCT_OUT2_SET_SET5_Msk                 (0x01UL << SCT_OUT2_SET_SET5_Pos)                       /*!< SCT OUT2_SET: SET5 Mask                 */
#define SCT_OUT2_SET_SET6_Pos                 6                                                       /*!< SCT OUT2_SET: SET6 Position             */
#define SCT_OUT2_SET_SET6_Msk                 (0x01UL << SCT_OUT2_SET_SET6_Pos)                       /*!< SCT OUT2_SET: SET6 Mask                 */
#define SCT_OUT2_SET_SET7_Pos                 7                                                       /*!< SCT OUT2_SET: SET7 Position             */
#define SCT_OUT2_SET_SET7_Msk                 (0x01UL << SCT_OUT2_SET_SET7_Pos)                       /*!< SCT OUT2_SET: SET7 Mask                 */
#define SCT_OUT2_SET_SET8_Pos                 8                                                       /*!< SCT OUT2_SET: SET8 Position             */
#define SCT_OUT2_SET_SET8_Msk                 (0x01UL << SCT_OUT2_SET_SET8_Pos)                       /*!< SCT OUT2_SET: SET8 Mask                 */
#define SCT_OUT2_SET_SET9_Pos                 9                                                       /*!< SCT OUT2_SET: SET9 Position             */
#define SCT_OUT2_SET_SET9_Msk                 (0x01UL << SCT_OUT2_SET_SET9_Pos)                       /*!< SCT OUT2_SET: SET9 Mask                 */
#define SCT_OUT2_SET_SET10_Pos                10                                                      /*!< SCT OUT2_SET: SET10 Position            */
#define SCT_OUT2_SET_SET10_Msk                (0x01UL << SCT_OUT2_SET_SET10_Pos)                      /*!< SCT OUT2_SET: SET10 Mask                */
#define SCT_OUT2_SET_SET11_Pos                11                                                      /*!< SCT OUT2_SET: SET11 Position            */
#define SCT_OUT2_SET_SET11_Msk                (0x01UL << SCT_OUT2_SET_SET11_Pos)                      /*!< SCT OUT2_SET: SET11 Mask                */
#define SCT_OUT2_SET_SET12_Pos                12                                                      /*!< SCT OUT2_SET: SET12 Position            */
#define SCT_OUT2_SET_SET12_Msk                (0x01UL << SCT_OUT2_SET_SET12_Pos)                      /*!< SCT OUT2_SET: SET12 Mask                */
#define SCT_OUT2_SET_SET13_Pos                13                                                      /*!< SCT OUT2_SET: SET13 Position            */
#define SCT_OUT2_SET_SET13_Msk                (0x01UL << SCT_OUT2_SET_SET13_Pos)                      /*!< SCT OUT2_SET: SET13 Mask                */
#define SCT_OUT2_SET_SET14_Pos                14                                                      /*!< SCT OUT2_SET: SET14 Position            */
#define SCT_OUT2_SET_SET14_Msk                (0x01UL << SCT_OUT2_SET_SET14_Pos)                      /*!< SCT OUT2_SET: SET14 Mask                */
#define SCT_OUT2_SET_SET15_Pos                15                                                      /*!< SCT OUT2_SET: SET15 Position            */
#define SCT_OUT2_SET_SET15_Msk                (0x01UL << SCT_OUT2_SET_SET15_Pos)                      /*!< SCT OUT2_SET: SET15 Mask                */

/* --------------------------------  SCT_OUT2_CLR  -------------------------------- */
#define SCT_OUT2_CLR_CLR0_Pos                 0                                                       /*!< SCT OUT2_CLR: CLR0 Position             */
#define SCT_OUT2_CLR_CLR0_Msk                 (0x01UL << SCT_OUT2_CLR_CLR0_Pos)                       /*!< SCT OUT2_CLR: CLR0 Mask                 */
#define SCT_OUT2_CLR_CLR1_Pos                 1                                                       /*!< SCT OUT2_CLR: CLR1 Position             */
#define SCT_OUT2_CLR_CLR1_Msk                 (0x01UL << SCT_OUT2_CLR_CLR1_Pos)                       /*!< SCT OUT2_CLR: CLR1 Mask                 */
#define SCT_OUT2_CLR_CLR2_Pos                 2                                                       /*!< SCT OUT2_CLR: CLR2 Position             */
#define SCT_OUT2_CLR_CLR2_Msk                 (0x01UL << SCT_OUT2_CLR_CLR2_Pos)                       /*!< SCT OUT2_CLR: CLR2 Mask                 */
#define SCT_OUT2_CLR_CLR3_Pos                 3                                                       /*!< SCT OUT2_CLR: CLR3 Position             */
#define SCT_OUT2_CLR_CLR3_Msk                 (0x01UL << SCT_OUT2_CLR_CLR3_Pos)                       /*!< SCT OUT2_CLR: CLR3 Mask                 */
#define SCT_OUT2_CLR_CLR4_Pos                 4                                                       /*!< SCT OUT2_CLR: CLR4 Position             */
#define SCT_OUT2_CLR_CLR4_Msk                 (0x01UL << SCT_OUT2_CLR_CLR4_Pos)                       /*!< SCT OUT2_CLR: CLR4 Mask                 */
#define SCT_OUT2_CLR_CLR5_Pos                 5                                                       /*!< SCT OUT2_CLR: CLR5 Position             */
#define SCT_OUT2_CLR_CLR5_Msk                 (0x01UL << SCT_OUT2_CLR_CLR5_Pos)                       /*!< SCT OUT2_CLR: CLR5 Mask                 */
#define SCT_OUT2_CLR_CLR6_Pos                 6                                                       /*!< SCT OUT2_CLR: CLR6 Position             */
#define SCT_OUT2_CLR_CLR6_Msk                 (0x01UL << SCT_OUT2_CLR_CLR6_Pos)                       /*!< SCT OUT2_CLR: CLR6 Mask                 */
#define SCT_OUT2_CLR_CLR7_Pos                 7                                                       /*!< SCT OUT2_CLR: CLR7 Position             */
#define SCT_OUT2_CLR_CLR7_Msk                 (0x01UL << SCT_OUT2_CLR_CLR7_Pos)                       /*!< SCT OUT2_CLR: CLR7 Mask                 */
#define SCT_OUT2_CLR_CLR8_Pos                 8                                                       /*!< SCT OUT2_CLR: CLR8 Position             */
#define SCT_OUT2_CLR_CLR8_Msk                 (0x01UL << SCT_OUT2_CLR_CLR8_Pos)                       /*!< SCT OUT2_CLR: CLR8 Mask                 */
#define SCT_OUT2_CLR_CLR9_Pos                 9                                                       /*!< SCT OUT2_CLR: CLR9 Position             */
#define SCT_OUT2_CLR_CLR9_Msk                 (0x01UL << SCT_OUT2_CLR_CLR9_Pos)                       /*!< SCT OUT2_CLR: CLR9 Mask                 */
#define SCT_OUT2_CLR_CLR10_Pos                10                                                      /*!< SCT OUT2_CLR: CLR10 Position            */
#define SCT_OUT2_CLR_CLR10_Msk                (0x01UL << SCT_OUT2_CLR_CLR10_Pos)                      /*!< SCT OUT2_CLR: CLR10 Mask                */
#define SCT_OUT2_CLR_CLR11_Pos                11                                                      /*!< SCT OUT2_CLR: CLR11 Position            */
#define SCT_OUT2_CLR_CLR11_Msk                (0x01UL << SCT_OUT2_CLR_CLR11_Pos)                      /*!< SCT OUT2_CLR: CLR11 Mask                */
#define SCT_OUT2_CLR_CLR12_Pos                12                                                      /*!< SCT OUT2_CLR: CLR12 Position            */
#define SCT_OUT2_CLR_CLR12_Msk                (0x01UL << SCT_OUT2_CLR_CLR12_Pos)                      /*!< SCT OUT2_CLR: CLR12 Mask                */
#define SCT_OUT2_CLR_CLR13_Pos                13                                                      /*!< SCT OUT2_CLR: CLR13 Position            */
#define SCT_OUT2_CLR_CLR13_Msk                (0x01UL << SCT_OUT2_CLR_CLR13_Pos)                      /*!< SCT OUT2_CLR: CLR13 Mask                */
#define SCT_OUT2_CLR_CLR14_Pos                14                                                      /*!< SCT OUT2_CLR: CLR14 Position            */
#define SCT_OUT2_CLR_CLR14_Msk                (0x01UL << SCT_OUT2_CLR_CLR14_Pos)                      /*!< SCT OUT2_CLR: CLR14 Mask                */
#define SCT_OUT2_CLR_CLR15_Pos                15                                                      /*!< SCT OUT2_CLR: CLR15 Position            */
#define SCT_OUT2_CLR_CLR15_Msk                (0x01UL << SCT_OUT2_CLR_CLR15_Pos)                      /*!< SCT OUT2_CLR: CLR15 Mask                */

/* --------------------------------  SCT_OUT3_SET  -------------------------------- */
#define SCT_OUT3_SET_SET0_Pos                 0                                                       /*!< SCT OUT3_SET: SET0 Position             */
#define SCT_OUT3_SET_SET0_Msk                 (0x01UL << SCT_OUT3_SET_SET0_Pos)                       /*!< SCT OUT3_SET: SET0 Mask                 */
#define SCT_OUT3_SET_SET1_Pos                 1                                                       /*!< SCT OUT3_SET: SET1 Position             */
#define SCT_OUT3_SET_SET1_Msk                 (0x01UL << SCT_OUT3_SET_SET1_Pos)                       /*!< SCT OUT3_SET: SET1 Mask                 */
#define SCT_OUT3_SET_SET2_Pos                 2                                                       /*!< SCT OUT3_SET: SET2 Position             */
#define SCT_OUT3_SET_SET2_Msk                 (0x01UL << SCT_OUT3_SET_SET2_Pos)                       /*!< SCT OUT3_SET: SET2 Mask                 */
#define SCT_OUT3_SET_SET3_Pos                 3                                                       /*!< SCT OUT3_SET: SET3 Position             */
#define SCT_OUT3_SET_SET3_Msk                 (0x01UL << SCT_OUT3_SET_SET3_Pos)                       /*!< SCT OUT3_SET: SET3 Mask                 */
#define SCT_OUT3_SET_SET4_Pos                 4                                                       /*!< SCT OUT3_SET: SET4 Position             */
#define SCT_OUT3_SET_SET4_Msk                 (0x01UL << SCT_OUT3_SET_SET4_Pos)                       /*!< SCT OUT3_SET: SET4 Mask                 */
#define SCT_OUT3_SET_SET5_Pos                 5                                                       /*!< SCT OUT3_SET: SET5 Position             */
#define SCT_OUT3_SET_SET5_Msk                 (0x01UL << SCT_OUT3_SET_SET5_Pos)                       /*!< SCT OUT3_SET: SET5 Mask                 */
#define SCT_OUT3_SET_SET6_Pos                 6                                                       /*!< SCT OUT3_SET: SET6 Position             */
#define SCT_OUT3_SET_SET6_Msk                 (0x01UL << SCT_OUT3_SET_SET6_Pos)                       /*!< SCT OUT3_SET: SET6 Mask                 */
#define SCT_OUT3_SET_SET7_Pos                 7                                                       /*!< SCT OUT3_SET: SET7 Position             */
#define SCT_OUT3_SET_SET7_Msk                 (0x01UL << SCT_OUT3_SET_SET7_Pos)                       /*!< SCT OUT3_SET: SET7 Mask                 */
#define SCT_OUT3_SET_SET8_Pos                 8                                                       /*!< SCT OUT3_SET: SET8 Position             */
#define SCT_OUT3_SET_SET8_Msk                 (0x01UL << SCT_OUT3_SET_SET8_Pos)                       /*!< SCT OUT3_SET: SET8 Mask                 */
#define SCT_OUT3_SET_SET9_Pos                 9                                                       /*!< SCT OUT3_SET: SET9 Position             */
#define SCT_OUT3_SET_SET9_Msk                 (0x01UL << SCT_OUT3_SET_SET9_Pos)                       /*!< SCT OUT3_SET: SET9 Mask                 */
#define SCT_OUT3_SET_SET10_Pos                10                                                      /*!< SCT OUT3_SET: SET10 Position            */
#define SCT_OUT3_SET_SET10_Msk                (0x01UL << SCT_OUT3_SET_SET10_Pos)                      /*!< SCT OUT3_SET: SET10 Mask                */
#define SCT_OUT3_SET_SET11_Pos                11                                                      /*!< SCT OUT3_SET: SET11 Position            */
#define SCT_OUT3_SET_SET11_Msk                (0x01UL << SCT_OUT3_SET_SET11_Pos)                      /*!< SCT OUT3_SET: SET11 Mask                */
#define SCT_OUT3_SET_SET12_Pos                12                                                      /*!< SCT OUT3_SET: SET12 Position            */
#define SCT_OUT3_SET_SET12_Msk                (0x01UL << SCT_OUT3_SET_SET12_Pos)                      /*!< SCT OUT3_SET: SET12 Mask                */
#define SCT_OUT3_SET_SET13_Pos                13                                                      /*!< SCT OUT3_SET: SET13 Position            */
#define SCT_OUT3_SET_SET13_Msk                (0x01UL << SCT_OUT3_SET_SET13_Pos)                      /*!< SCT OUT3_SET: SET13 Mask                */
#define SCT_OUT3_SET_SET14_Pos                14                                                      /*!< SCT OUT3_SET: SET14 Position            */
#define SCT_OUT3_SET_SET14_Msk                (0x01UL << SCT_OUT3_SET_SET14_Pos)                      /*!< SCT OUT3_SET: SET14 Mask                */
#define SCT_OUT3_SET_SET15_Pos                15                                                      /*!< SCT OUT3_SET: SET15 Position            */
#define SCT_OUT3_SET_SET15_Msk                (0x01UL << SCT_OUT3_SET_SET15_Pos)                      /*!< SCT OUT3_SET: SET15 Mask                */

/* --------------------------------  SCT_OUT3_CLR  -------------------------------- */
#define SCT_OUT3_CLR_CLR0_Pos                 0                                                       /*!< SCT OUT3_CLR: CLR0 Position             */
#define SCT_OUT3_CLR_CLR0_Msk                 (0x01UL << SCT_OUT3_CLR_CLR0_Pos)                       /*!< SCT OUT3_CLR: CLR0 Mask                 */
#define SCT_OUT3_CLR_CLR1_Pos                 1                                                       /*!< SCT OUT3_CLR: CLR1 Position             */
#define SCT_OUT3_CLR_CLR1_Msk                 (0x01UL << SCT_OUT3_CLR_CLR1_Pos)                       /*!< SCT OUT3_CLR: CLR1 Mask                 */
#define SCT_OUT3_CLR_CLR2_Pos                 2                                                       /*!< SCT OUT3_CLR: CLR2 Position             */
#define SCT_OUT3_CLR_CLR2_Msk                 (0x01UL << SCT_OUT3_CLR_CLR2_Pos)                       /*!< SCT OUT3_CLR: CLR2 Mask                 */
#define SCT_OUT3_CLR_CLR3_Pos                 3                                                       /*!< SCT OUT3_CLR: CLR3 Position             */
#define SCT_OUT3_CLR_CLR3_Msk                 (0x01UL << SCT_OUT3_CLR_CLR3_Pos)                       /*!< SCT OUT3_CLR: CLR3 Mask                 */
#define SCT_OUT3_CLR_CLR4_Pos                 4                                                       /*!< SCT OUT3_CLR: CLR4 Position             */
#define SCT_OUT3_CLR_CLR4_Msk                 (0x01UL << SCT_OUT3_CLR_CLR4_Pos)                       /*!< SCT OUT3_CLR: CLR4 Mask                 */
#define SCT_OUT3_CLR_CLR5_Pos                 5                                                       /*!< SCT OUT3_CLR: CLR5 Position             */
#define SCT_OUT3_CLR_CLR5_Msk                 (0x01UL << SCT_OUT3_CLR_CLR5_Pos)                       /*!< SCT OUT3_CLR: CLR5 Mask                 */
#define SCT_OUT3_CLR_CLR6_Pos                 6                                                       /*!< SCT OUT3_CLR: CLR6 Position             */
#define SCT_OUT3_CLR_CLR6_Msk                 (0x01UL << SCT_OUT3_CLR_CLR6_Pos)                       /*!< SCT OUT3_CLR: CLR6 Mask                 */
#define SCT_OUT3_CLR_CLR7_Pos                 7                                                       /*!< SCT OUT3_CLR: CLR7 Position             */
#define SCT_OUT3_CLR_CLR7_Msk                 (0x01UL << SCT_OUT3_CLR_CLR7_Pos)                       /*!< SCT OUT3_CLR: CLR7 Mask                 */
#define SCT_OUT3_CLR_CLR8_Pos                 8                                                       /*!< SCT OUT3_CLR: CLR8 Position             */
#define SCT_OUT3_CLR_CLR8_Msk                 (0x01UL << SCT_OUT3_CLR_CLR8_Pos)                       /*!< SCT OUT3_CLR: CLR8 Mask                 */
#define SCT_OUT3_CLR_CLR9_Pos                 9                                                       /*!< SCT OUT3_CLR: CLR9 Position             */
#define SCT_OUT3_CLR_CLR9_Msk                 (0x01UL << SCT_OUT3_CLR_CLR9_Pos)                       /*!< SCT OUT3_CLR: CLR9 Mask                 */
#define SCT_OUT3_CLR_CLR10_Pos                10                                                      /*!< SCT OUT3_CLR: CLR10 Position            */
#define SCT_OUT3_CLR_CLR10_Msk                (0x01UL << SCT_OUT3_CLR_CLR10_Pos)                      /*!< SCT OUT3_CLR: CLR10 Mask                */
#define SCT_OUT3_CLR_CLR11_Pos                11                                                      /*!< SCT OUT3_CLR: CLR11 Position            */
#define SCT_OUT3_CLR_CLR11_Msk                (0x01UL << SCT_OUT3_CLR_CLR11_Pos)                      /*!< SCT OUT3_CLR: CLR11 Mask                */
#define SCT_OUT3_CLR_CLR12_Pos                12                                                      /*!< SCT OUT3_CLR: CLR12 Position            */
#define SCT_OUT3_CLR_CLR12_Msk                (0x01UL << SCT_OUT3_CLR_CLR12_Pos)                      /*!< SCT OUT3_CLR: CLR12 Mask                */
#define SCT_OUT3_CLR_CLR13_Pos                13                                                      /*!< SCT OUT3_CLR: CLR13 Position            */
#define SCT_OUT3_CLR_CLR13_Msk                (0x01UL << SCT_OUT3_CLR_CLR13_Pos)                      /*!< SCT OUT3_CLR: CLR13 Mask                */
#define SCT_OUT3_CLR_CLR14_Pos                14                                                      /*!< SCT OUT3_CLR: CLR14 Position            */
#define SCT_OUT3_CLR_CLR14_Msk                (0x01UL << SCT_OUT3_CLR_CLR14_Pos)                      /*!< SCT OUT3_CLR: CLR14 Mask                */
#define SCT_OUT3_CLR_CLR15_Pos                15                                                      /*!< SCT OUT3_CLR: CLR15 Position            */
#define SCT_OUT3_CLR_CLR15_Msk                (0x01UL << SCT_OUT3_CLR_CLR15_Pos)                      /*!< SCT OUT3_CLR: CLR15 Mask                */

/* --------------------------------  SCT_OUT4_SET  -------------------------------- */
#define SCT_OUT4_SET_SET0_Pos                 0                                                       /*!< SCT OUT4_SET: SET0 Position             */
#define SCT_OUT4_SET_SET0_Msk                 (0x01UL << SCT_OUT4_SET_SET0_Pos)                       /*!< SCT OUT4_SET: SET0 Mask                 */
#define SCT_OUT4_SET_SET1_Pos                 1                                                       /*!< SCT OUT4_SET: SET1 Position             */
#define SCT_OUT4_SET_SET1_Msk                 (0x01UL << SCT_OUT4_SET_SET1_Pos)                       /*!< SCT OUT4_SET: SET1 Mask                 */
#define SCT_OUT4_SET_SET2_Pos                 2                                                       /*!< SCT OUT4_SET: SET2 Position             */
#define SCT_OUT4_SET_SET2_Msk                 (0x01UL << SCT_OUT4_SET_SET2_Pos)                       /*!< SCT OUT4_SET: SET2 Mask                 */
#define SCT_OUT4_SET_SET3_Pos                 3                                                       /*!< SCT OUT4_SET: SET3 Position             */
#define SCT_OUT4_SET_SET3_Msk                 (0x01UL << SCT_OUT4_SET_SET3_Pos)                       /*!< SCT OUT4_SET: SET3 Mask                 */
#define SCT_OUT4_SET_SET4_Pos                 4                                                       /*!< SCT OUT4_SET: SET4 Position             */
#define SCT_OUT4_SET_SET4_Msk                 (0x01UL << SCT_OUT4_SET_SET4_Pos)                       /*!< SCT OUT4_SET: SET4 Mask                 */
#define SCT_OUT4_SET_SET5_Pos                 5                                                       /*!< SCT OUT4_SET: SET5 Position             */
#define SCT_OUT4_SET_SET5_Msk                 (0x01UL << SCT_OUT4_SET_SET5_Pos)                       /*!< SCT OUT4_SET: SET5 Mask                 */
#define SCT_OUT4_SET_SET6_Pos                 6                                                       /*!< SCT OUT4_SET: SET6 Position             */
#define SCT_OUT4_SET_SET6_Msk                 (0x01UL << SCT_OUT4_SET_SET6_Pos)                       /*!< SCT OUT4_SET: SET6 Mask                 */
#define SCT_OUT4_SET_SET7_Pos                 7                                                       /*!< SCT OUT4_SET: SET7 Position             */
#define SCT_OUT4_SET_SET7_Msk                 (0x01UL << SCT_OUT4_SET_SET7_Pos)                       /*!< SCT OUT4_SET: SET7 Mask                 */
#define SCT_OUT4_SET_SET8_Pos                 8                                                       /*!< SCT OUT4_SET: SET8 Position             */
#define SCT_OUT4_SET_SET8_Msk                 (0x01UL << SCT_OUT4_SET_SET8_Pos)                       /*!< SCT OUT4_SET: SET8 Mask                 */
#define SCT_OUT4_SET_SET9_Pos                 9                                                       /*!< SCT OUT4_SET: SET9 Position             */
#define SCT_OUT4_SET_SET9_Msk                 (0x01UL << SCT_OUT4_SET_SET9_Pos)                       /*!< SCT OUT4_SET: SET9 Mask                 */
#define SCT_OUT4_SET_SET10_Pos                10                                                      /*!< SCT OUT4_SET: SET10 Position            */
#define SCT_OUT4_SET_SET10_Msk                (0x01UL << SCT_OUT4_SET_SET10_Pos)                      /*!< SCT OUT4_SET: SET10 Mask                */
#define SCT_OUT4_SET_SET11_Pos                11                                                      /*!< SCT OUT4_SET: SET11 Position            */
#define SCT_OUT4_SET_SET11_Msk                (0x01UL << SCT_OUT4_SET_SET11_Pos)                      /*!< SCT OUT4_SET: SET11 Mask                */
#define SCT_OUT4_SET_SET12_Pos                12                                                      /*!< SCT OUT4_SET: SET12 Position            */
#define SCT_OUT4_SET_SET12_Msk                (0x01UL << SCT_OUT4_SET_SET12_Pos)                      /*!< SCT OUT4_SET: SET12 Mask                */
#define SCT_OUT4_SET_SET13_Pos                13                                                      /*!< SCT OUT4_SET: SET13 Position            */
#define SCT_OUT4_SET_SET13_Msk                (0x01UL << SCT_OUT4_SET_SET13_Pos)                      /*!< SCT OUT4_SET: SET13 Mask                */
#define SCT_OUT4_SET_SET14_Pos                14                                                      /*!< SCT OUT4_SET: SET14 Position            */
#define SCT_OUT4_SET_SET14_Msk                (0x01UL << SCT_OUT4_SET_SET14_Pos)                      /*!< SCT OUT4_SET: SET14 Mask                */
#define SCT_OUT4_SET_SET15_Pos                15                                                      /*!< SCT OUT4_SET: SET15 Position            */
#define SCT_OUT4_SET_SET15_Msk                (0x01UL << SCT_OUT4_SET_SET15_Pos)                      /*!< SCT OUT4_SET: SET15 Mask                */

/* --------------------------------  SCT_OUT4_CLR  -------------------------------- */
#define SCT_OUT4_CLR_CLR0_Pos                 0                                                       /*!< SCT OUT4_CLR: CLR0 Position             */
#define SCT_OUT4_CLR_CLR0_Msk                 (0x01UL << SCT_OUT4_CLR_CLR0_Pos)                       /*!< SCT OUT4_CLR: CLR0 Mask                 */
#define SCT_OUT4_CLR_CLR1_Pos                 1                                                       /*!< SCT OUT4_CLR: CLR1 Position             */
#define SCT_OUT4_CLR_CLR1_Msk                 (0x01UL << SCT_OUT4_CLR_CLR1_Pos)                       /*!< SCT OUT4_CLR: CLR1 Mask                 */
#define SCT_OUT4_CLR_CLR2_Pos                 2                                                       /*!< SCT OUT4_CLR: CLR2 Position             */
#define SCT_OUT4_CLR_CLR2_Msk                 (0x01UL << SCT_OUT4_CLR_CLR2_Pos)                       /*!< SCT OUT4_CLR: CLR2 Mask                 */
#define SCT_OUT4_CLR_CLR3_Pos                 3                                                       /*!< SCT OUT4_CLR: CLR3 Position             */
#define SCT_OUT4_CLR_CLR3_Msk                 (0x01UL << SCT_OUT4_CLR_CLR3_Pos)                       /*!< SCT OUT4_CLR: CLR3 Mask                 */
#define SCT_OUT4_CLR_CLR4_Pos                 4                                                       /*!< SCT OUT4_CLR: CLR4 Position             */
#define SCT_OUT4_CLR_CLR4_Msk                 (0x01UL << SCT_OUT4_CLR_CLR4_Pos)                       /*!< SCT OUT4_CLR: CLR4 Mask                 */
#define SCT_OUT4_CLR_CLR5_Pos                 5                                                       /*!< SCT OUT4_CLR: CLR5 Position             */
#define SCT_OUT4_CLR_CLR5_Msk                 (0x01UL << SCT_OUT4_CLR_CLR5_Pos)                       /*!< SCT OUT4_CLR: CLR5 Mask                 */
#define SCT_OUT4_CLR_CLR6_Pos                 6                                                       /*!< SCT OUT4_CLR: CLR6 Position             */
#define SCT_OUT4_CLR_CLR6_Msk                 (0x01UL << SCT_OUT4_CLR_CLR6_Pos)                       /*!< SCT OUT4_CLR: CLR6 Mask                 */
#define SCT_OUT4_CLR_CLR7_Pos                 7                                                       /*!< SCT OUT4_CLR: CLR7 Position             */
#define SCT_OUT4_CLR_CLR7_Msk                 (0x01UL << SCT_OUT4_CLR_CLR7_Pos)                       /*!< SCT OUT4_CLR: CLR7 Mask                 */
#define SCT_OUT4_CLR_CLR8_Pos                 8                                                       /*!< SCT OUT4_CLR: CLR8 Position             */
#define SCT_OUT4_CLR_CLR8_Msk                 (0x01UL << SCT_OUT4_CLR_CLR8_Pos)                       /*!< SCT OUT4_CLR: CLR8 Mask                 */
#define SCT_OUT4_CLR_CLR9_Pos                 9                                                       /*!< SCT OUT4_CLR: CLR9 Position             */
#define SCT_OUT4_CLR_CLR9_Msk                 (0x01UL << SCT_OUT4_CLR_CLR9_Pos)                       /*!< SCT OUT4_CLR: CLR9 Mask                 */
#define SCT_OUT4_CLR_CLR10_Pos                10                                                      /*!< SCT OUT4_CLR: CLR10 Position            */
#define SCT_OUT4_CLR_CLR10_Msk                (0x01UL << SCT_OUT4_CLR_CLR10_Pos)                      /*!< SCT OUT4_CLR: CLR10 Mask                */
#define SCT_OUT4_CLR_CLR11_Pos                11                                                      /*!< SCT OUT4_CLR: CLR11 Position            */
#define SCT_OUT4_CLR_CLR11_Msk                (0x01UL << SCT_OUT4_CLR_CLR11_Pos)                      /*!< SCT OUT4_CLR: CLR11 Mask                */
#define SCT_OUT4_CLR_CLR12_Pos                12                                                      /*!< SCT OUT4_CLR: CLR12 Position            */
#define SCT_OUT4_CLR_CLR12_Msk                (0x01UL << SCT_OUT4_CLR_CLR12_Pos)                      /*!< SCT OUT4_CLR: CLR12 Mask                */
#define SCT_OUT4_CLR_CLR13_Pos                13                                                      /*!< SCT OUT4_CLR: CLR13 Position            */
#define SCT_OUT4_CLR_CLR13_Msk                (0x01UL << SCT_OUT4_CLR_CLR13_Pos)                      /*!< SCT OUT4_CLR: CLR13 Mask                */
#define SCT_OUT4_CLR_CLR14_Pos                14                                                      /*!< SCT OUT4_CLR: CLR14 Position            */
#define SCT_OUT4_CLR_CLR14_Msk                (0x01UL << SCT_OUT4_CLR_CLR14_Pos)                      /*!< SCT OUT4_CLR: CLR14 Mask                */
#define SCT_OUT4_CLR_CLR15_Pos                15                                                      /*!< SCT OUT4_CLR: CLR15 Position            */
#define SCT_OUT4_CLR_CLR15_Msk                (0x01UL << SCT_OUT4_CLR_CLR15_Pos)                      /*!< SCT OUT4_CLR: CLR15 Mask                */

/* --------------------------------  SCT_OUT5_SET  -------------------------------- */
#define SCT_OUT5_SET_SET0_Pos                 0                                                       /*!< SCT OUT5_SET: SET0 Position             */
#define SCT_OUT5_SET_SET0_Msk                 (0x01UL << SCT_OUT5_SET_SET0_Pos)                       /*!< SCT OUT5_SET: SET0 Mask                 */
#define SCT_OUT5_SET_SET1_Pos                 1                                                       /*!< SCT OUT5_SET: SET1 Position             */
#define SCT_OUT5_SET_SET1_Msk                 (0x01UL << SCT_OUT5_SET_SET1_Pos)                       /*!< SCT OUT5_SET: SET1 Mask                 */
#define SCT_OUT5_SET_SET2_Pos                 2                                                       /*!< SCT OUT5_SET: SET2 Position             */
#define SCT_OUT5_SET_SET2_Msk                 (0x01UL << SCT_OUT5_SET_SET2_Pos)                       /*!< SCT OUT5_SET: SET2 Mask                 */
#define SCT_OUT5_SET_SET3_Pos                 3                                                       /*!< SCT OUT5_SET: SET3 Position             */
#define SCT_OUT5_SET_SET3_Msk                 (0x01UL << SCT_OUT5_SET_SET3_Pos)                       /*!< SCT OUT5_SET: SET3 Mask                 */
#define SCT_OUT5_SET_SET4_Pos                 4                                                       /*!< SCT OUT5_SET: SET4 Position             */
#define SCT_OUT5_SET_SET4_Msk                 (0x01UL << SCT_OUT5_SET_SET4_Pos)                       /*!< SCT OUT5_SET: SET4 Mask                 */
#define SCT_OUT5_SET_SET5_Pos                 5                                                       /*!< SCT OUT5_SET: SET5 Position             */
#define SCT_OUT5_SET_SET5_Msk                 (0x01UL << SCT_OUT5_SET_SET5_Pos)                       /*!< SCT OUT5_SET: SET5 Mask                 */
#define SCT_OUT5_SET_SET6_Pos                 6                                                       /*!< SCT OUT5_SET: SET6 Position             */
#define SCT_OUT5_SET_SET6_Msk                 (0x01UL << SCT_OUT5_SET_SET6_Pos)                       /*!< SCT OUT5_SET: SET6 Mask                 */
#define SCT_OUT5_SET_SET7_Pos                 7                                                       /*!< SCT OUT5_SET: SET7 Position             */
#define SCT_OUT5_SET_SET7_Msk                 (0x01UL << SCT_OUT5_SET_SET7_Pos)                       /*!< SCT OUT5_SET: SET7 Mask                 */
#define SCT_OUT5_SET_SET8_Pos                 8                                                       /*!< SCT OUT5_SET: SET8 Position             */
#define SCT_OUT5_SET_SET8_Msk                 (0x01UL << SCT_OUT5_SET_SET8_Pos)                       /*!< SCT OUT5_SET: SET8 Mask                 */
#define SCT_OUT5_SET_SET9_Pos                 9                                                       /*!< SCT OUT5_SET: SET9 Position             */
#define SCT_OUT5_SET_SET9_Msk                 (0x01UL << SCT_OUT5_SET_SET9_Pos)                       /*!< SCT OUT5_SET: SET9 Mask                 */
#define SCT_OUT5_SET_SET10_Pos                10                                                      /*!< SCT OUT5_SET: SET10 Position            */
#define SCT_OUT5_SET_SET10_Msk                (0x01UL << SCT_OUT5_SET_SET10_Pos)                      /*!< SCT OUT5_SET: SET10 Mask                */
#define SCT_OUT5_SET_SET11_Pos                11                                                      /*!< SCT OUT5_SET: SET11 Position            */
#define SCT_OUT5_SET_SET11_Msk                (0x01UL << SCT_OUT5_SET_SET11_Pos)                      /*!< SCT OUT5_SET: SET11 Mask                */
#define SCT_OUT5_SET_SET12_Pos                12                                                      /*!< SCT OUT5_SET: SET12 Position            */
#define SCT_OUT5_SET_SET12_Msk                (0x01UL << SCT_OUT5_SET_SET12_Pos)                      /*!< SCT OUT5_SET: SET12 Mask                */
#define SCT_OUT5_SET_SET13_Pos                13                                                      /*!< SCT OUT5_SET: SET13 Position            */
#define SCT_OUT5_SET_SET13_Msk                (0x01UL << SCT_OUT5_SET_SET13_Pos)                      /*!< SCT OUT5_SET: SET13 Mask                */
#define SCT_OUT5_SET_SET14_Pos                14                                                      /*!< SCT OUT5_SET: SET14 Position            */
#define SCT_OUT5_SET_SET14_Msk                (0x01UL << SCT_OUT5_SET_SET14_Pos)                      /*!< SCT OUT5_SET: SET14 Mask                */
#define SCT_OUT5_SET_SET15_Pos                15                                                      /*!< SCT OUT5_SET: SET15 Position            */
#define SCT_OUT5_SET_SET15_Msk                (0x01UL << SCT_OUT5_SET_SET15_Pos)                      /*!< SCT OUT5_SET: SET15 Mask                */

/* --------------------------------  SCT_OUT5_CLR  -------------------------------- */
#define SCT_OUT5_CLR_CLR0_Pos                 0                                                       /*!< SCT OUT5_CLR: CLR0 Position             */
#define SCT_OUT5_CLR_CLR0_Msk                 (0x01UL << SCT_OUT5_CLR_CLR0_Pos)                       /*!< SCT OUT5_CLR: CLR0 Mask                 */
#define SCT_OUT5_CLR_CLR1_Pos                 1                                                       /*!< SCT OUT5_CLR: CLR1 Position             */
#define SCT_OUT5_CLR_CLR1_Msk                 (0x01UL << SCT_OUT5_CLR_CLR1_Pos)                       /*!< SCT OUT5_CLR: CLR1 Mask                 */
#define SCT_OUT5_CLR_CLR2_Pos                 2                                                       /*!< SCT OUT5_CLR: CLR2 Position             */
#define SCT_OUT5_CLR_CLR2_Msk                 (0x01UL << SCT_OUT5_CLR_CLR2_Pos)                       /*!< SCT OUT5_CLR: CLR2 Mask                 */
#define SCT_OUT5_CLR_CLR3_Pos                 3                                                       /*!< SCT OUT5_CLR: CLR3 Position             */
#define SCT_OUT5_CLR_CLR3_Msk                 (0x01UL << SCT_OUT5_CLR_CLR3_Pos)                       /*!< SCT OUT5_CLR: CLR3 Mask                 */
#define SCT_OUT5_CLR_CLR4_Pos                 4                                                       /*!< SCT OUT5_CLR: CLR4 Position             */
#define SCT_OUT5_CLR_CLR4_Msk                 (0x01UL << SCT_OUT5_CLR_CLR4_Pos)                       /*!< SCT OUT5_CLR: CLR4 Mask                 */
#define SCT_OUT5_CLR_CLR5_Pos                 5                                                       /*!< SCT OUT5_CLR: CLR5 Position             */
#define SCT_OUT5_CLR_CLR5_Msk                 (0x01UL << SCT_OUT5_CLR_CLR5_Pos)                       /*!< SCT OUT5_CLR: CLR5 Mask                 */
#define SCT_OUT5_CLR_CLR6_Pos                 6                                                       /*!< SCT OUT5_CLR: CLR6 Position             */
#define SCT_OUT5_CLR_CLR6_Msk                 (0x01UL << SCT_OUT5_CLR_CLR6_Pos)                       /*!< SCT OUT5_CLR: CLR6 Mask                 */
#define SCT_OUT5_CLR_CLR7_Pos                 7                                                       /*!< SCT OUT5_CLR: CLR7 Position             */
#define SCT_OUT5_CLR_CLR7_Msk                 (0x01UL << SCT_OUT5_CLR_CLR7_Pos)                       /*!< SCT OUT5_CLR: CLR7 Mask                 */
#define SCT_OUT5_CLR_CLR8_Pos                 8                                                       /*!< SCT OUT5_CLR: CLR8 Position             */
#define SCT_OUT5_CLR_CLR8_Msk                 (0x01UL << SCT_OUT5_CLR_CLR8_Pos)                       /*!< SCT OUT5_CLR: CLR8 Mask                 */
#define SCT_OUT5_CLR_CLR9_Pos                 9                                                       /*!< SCT OUT5_CLR: CLR9 Position             */
#define SCT_OUT5_CLR_CLR9_Msk                 (0x01UL << SCT_OUT5_CLR_CLR9_Pos)                       /*!< SCT OUT5_CLR: CLR9 Mask                 */
#define SCT_OUT5_CLR_CLR10_Pos                10                                                      /*!< SCT OUT5_CLR: CLR10 Position            */
#define SCT_OUT5_CLR_CLR10_Msk                (0x01UL << SCT_OUT5_CLR_CLR10_Pos)                      /*!< SCT OUT5_CLR: CLR10 Mask                */
#define SCT_OUT5_CLR_CLR11_Pos                11                                                      /*!< SCT OUT5_CLR: CLR11 Position            */
#define SCT_OUT5_CLR_CLR11_Msk                (0x01UL << SCT_OUT5_CLR_CLR11_Pos)                      /*!< SCT OUT5_CLR: CLR11 Mask                */
#define SCT_OUT5_CLR_CLR12_Pos                12                                                      /*!< SCT OUT5_CLR: CLR12 Position            */
#define SCT_OUT5_CLR_CLR12_Msk                (0x01UL << SCT_OUT5_CLR_CLR12_Pos)                      /*!< SCT OUT5_CLR: CLR12 Mask                */
#define SCT_OUT5_CLR_CLR13_Pos                13                                                      /*!< SCT OUT5_CLR: CLR13 Position            */
#define SCT_OUT5_CLR_CLR13_Msk                (0x01UL << SCT_OUT5_CLR_CLR13_Pos)                      /*!< SCT OUT5_CLR: CLR13 Mask                */
#define SCT_OUT5_CLR_CLR14_Pos                14                                                      /*!< SCT OUT5_CLR: CLR14 Position            */
#define SCT_OUT5_CLR_CLR14_Msk                (0x01UL << SCT_OUT5_CLR_CLR14_Pos)                      /*!< SCT OUT5_CLR: CLR14 Mask                */
#define SCT_OUT5_CLR_CLR15_Pos                15                                                      /*!< SCT OUT5_CLR: CLR15 Position            */
#define SCT_OUT5_CLR_CLR15_Msk                (0x01UL << SCT_OUT5_CLR_CLR15_Pos)                      /*!< SCT OUT5_CLR: CLR15 Mask                */

/* --------------------------------  SCT_OUT6_SET  -------------------------------- */
#define SCT_OUT6_SET_SET0_Pos                 0                                                       /*!< SCT OUT6_SET: SET0 Position             */
#define SCT_OUT6_SET_SET0_Msk                 (0x01UL << SCT_OUT6_SET_SET0_Pos)                       /*!< SCT OUT6_SET: SET0 Mask                 */
#define SCT_OUT6_SET_SET1_Pos                 1                                                       /*!< SCT OUT6_SET: SET1 Position             */
#define SCT_OUT6_SET_SET1_Msk                 (0x01UL << SCT_OUT6_SET_SET1_Pos)                       /*!< SCT OUT6_SET: SET1 Mask                 */
#define SCT_OUT6_SET_SET2_Pos                 2                                                       /*!< SCT OUT6_SET: SET2 Position             */
#define SCT_OUT6_SET_SET2_Msk                 (0x01UL << SCT_OUT6_SET_SET2_Pos)                       /*!< SCT OUT6_SET: SET2 Mask                 */
#define SCT_OUT6_SET_SET3_Pos                 3                                                       /*!< SCT OUT6_SET: SET3 Position             */
#define SCT_OUT6_SET_SET3_Msk                 (0x01UL << SCT_OUT6_SET_SET3_Pos)                       /*!< SCT OUT6_SET: SET3 Mask                 */
#define SCT_OUT6_SET_SET4_Pos                 4                                                       /*!< SCT OUT6_SET: SET4 Position             */
#define SCT_OUT6_SET_SET4_Msk                 (0x01UL << SCT_OUT6_SET_SET4_Pos)                       /*!< SCT OUT6_SET: SET4 Mask                 */
#define SCT_OUT6_SET_SET5_Pos                 5                                                       /*!< SCT OUT6_SET: SET5 Position             */
#define SCT_OUT6_SET_SET5_Msk                 (0x01UL << SCT_OUT6_SET_SET5_Pos)                       /*!< SCT OUT6_SET: SET5 Mask                 */
#define SCT_OUT6_SET_SET6_Pos                 6                                                       /*!< SCT OUT6_SET: SET6 Position             */
#define SCT_OUT6_SET_SET6_Msk                 (0x01UL << SCT_OUT6_SET_SET6_Pos)                       /*!< SCT OUT6_SET: SET6 Mask                 */
#define SCT_OUT6_SET_SET7_Pos                 7                                                       /*!< SCT OUT6_SET: SET7 Position             */
#define SCT_OUT6_SET_SET7_Msk                 (0x01UL << SCT_OUT6_SET_SET7_Pos)                       /*!< SCT OUT6_SET: SET7 Mask                 */
#define SCT_OUT6_SET_SET8_Pos                 8                                                       /*!< SCT OUT6_SET: SET8 Position             */
#define SCT_OUT6_SET_SET8_Msk                 (0x01UL << SCT_OUT6_SET_SET8_Pos)                       /*!< SCT OUT6_SET: SET8 Mask                 */
#define SCT_OUT6_SET_SET9_Pos                 9                                                       /*!< SCT OUT6_SET: SET9 Position             */
#define SCT_OUT6_SET_SET9_Msk                 (0x01UL << SCT_OUT6_SET_SET9_Pos)                       /*!< SCT OUT6_SET: SET9 Mask                 */
#define SCT_OUT6_SET_SET10_Pos                10                                                      /*!< SCT OUT6_SET: SET10 Position            */
#define SCT_OUT6_SET_SET10_Msk                (0x01UL << SCT_OUT6_SET_SET10_Pos)                      /*!< SCT OUT6_SET: SET10 Mask                */
#define SCT_OUT6_SET_SET11_Pos                11                                                      /*!< SCT OUT6_SET: SET11 Position            */
#define SCT_OUT6_SET_SET11_Msk                (0x01UL << SCT_OUT6_SET_SET11_Pos)                      /*!< SCT OUT6_SET: SET11 Mask                */
#define SCT_OUT6_SET_SET12_Pos                12                                                      /*!< SCT OUT6_SET: SET12 Position            */
#define SCT_OUT6_SET_SET12_Msk                (0x01UL << SCT_OUT6_SET_SET12_Pos)                      /*!< SCT OUT6_SET: SET12 Mask                */
#define SCT_OUT6_SET_SET13_Pos                13                                                      /*!< SCT OUT6_SET: SET13 Position            */
#define SCT_OUT6_SET_SET13_Msk                (0x01UL << SCT_OUT6_SET_SET13_Pos)                      /*!< SCT OUT6_SET: SET13 Mask                */
#define SCT_OUT6_SET_SET14_Pos                14                                                      /*!< SCT OUT6_SET: SET14 Position            */
#define SCT_OUT6_SET_SET14_Msk                (0x01UL << SCT_OUT6_SET_SET14_Pos)                      /*!< SCT OUT6_SET: SET14 Mask                */
#define SCT_OUT6_SET_SET15_Pos                15                                                      /*!< SCT OUT6_SET: SET15 Position            */
#define SCT_OUT6_SET_SET15_Msk                (0x01UL << SCT_OUT6_SET_SET15_Pos)                      /*!< SCT OUT6_SET: SET15 Mask                */

/* --------------------------------  SCT_OUT6_CLR  -------------------------------- */
#define SCT_OUT6_CLR_CLR0_Pos                 0                                                       /*!< SCT OUT6_CLR: CLR0 Position             */
#define SCT_OUT6_CLR_CLR0_Msk                 (0x01UL << SCT_OUT6_CLR_CLR0_Pos)                       /*!< SCT OUT6_CLR: CLR0 Mask                 */
#define SCT_OUT6_CLR_CLR1_Pos                 1                                                       /*!< SCT OUT6_CLR: CLR1 Position             */
#define SCT_OUT6_CLR_CLR1_Msk                 (0x01UL << SCT_OUT6_CLR_CLR1_Pos)                       /*!< SCT OUT6_CLR: CLR1 Mask                 */
#define SCT_OUT6_CLR_CLR2_Pos                 2                                                       /*!< SCT OUT6_CLR: CLR2 Position             */
#define SCT_OUT6_CLR_CLR2_Msk                 (0x01UL << SCT_OUT6_CLR_CLR2_Pos)                       /*!< SCT OUT6_CLR: CLR2 Mask                 */
#define SCT_OUT6_CLR_CLR3_Pos                 3                                                       /*!< SCT OUT6_CLR: CLR3 Position             */
#define SCT_OUT6_CLR_CLR3_Msk                 (0x01UL << SCT_OUT6_CLR_CLR3_Pos)                       /*!< SCT OUT6_CLR: CLR3 Mask                 */
#define SCT_OUT6_CLR_CLR4_Pos                 4                                                       /*!< SCT OUT6_CLR: CLR4 Position             */
#define SCT_OUT6_CLR_CLR4_Msk                 (0x01UL << SCT_OUT6_CLR_CLR4_Pos)                       /*!< SCT OUT6_CLR: CLR4 Mask                 */
#define SCT_OUT6_CLR_CLR5_Pos                 5                                                       /*!< SCT OUT6_CLR: CLR5 Position             */
#define SCT_OUT6_CLR_CLR5_Msk                 (0x01UL << SCT_OUT6_CLR_CLR5_Pos)                       /*!< SCT OUT6_CLR: CLR5 Mask                 */
#define SCT_OUT6_CLR_CLR6_Pos                 6                                                       /*!< SCT OUT6_CLR: CLR6 Position             */
#define SCT_OUT6_CLR_CLR6_Msk                 (0x01UL << SCT_OUT6_CLR_CLR6_Pos)                       /*!< SCT OUT6_CLR: CLR6 Mask                 */
#define SCT_OUT6_CLR_CLR7_Pos                 7                                                       /*!< SCT OUT6_CLR: CLR7 Position             */
#define SCT_OUT6_CLR_CLR7_Msk                 (0x01UL << SCT_OUT6_CLR_CLR7_Pos)                       /*!< SCT OUT6_CLR: CLR7 Mask                 */
#define SCT_OUT6_CLR_CLR8_Pos                 8                                                       /*!< SCT OUT6_CLR: CLR8 Position             */
#define SCT_OUT6_CLR_CLR8_Msk                 (0x01UL << SCT_OUT6_CLR_CLR8_Pos)                       /*!< SCT OUT6_CLR: CLR8 Mask                 */
#define SCT_OUT6_CLR_CLR9_Pos                 9                                                       /*!< SCT OUT6_CLR: CLR9 Position             */
#define SCT_OUT6_CLR_CLR9_Msk                 (0x01UL << SCT_OUT6_CLR_CLR9_Pos)                       /*!< SCT OUT6_CLR: CLR9 Mask                 */
#define SCT_OUT6_CLR_CLR10_Pos                10                                                      /*!< SCT OUT6_CLR: CLR10 Position            */
#define SCT_OUT6_CLR_CLR10_Msk                (0x01UL << SCT_OUT6_CLR_CLR10_Pos)                      /*!< SCT OUT6_CLR: CLR10 Mask                */
#define SCT_OUT6_CLR_CLR11_Pos                11                                                      /*!< SCT OUT6_CLR: CLR11 Position            */
#define SCT_OUT6_CLR_CLR11_Msk                (0x01UL << SCT_OUT6_CLR_CLR11_Pos)                      /*!< SCT OUT6_CLR: CLR11 Mask                */
#define SCT_OUT6_CLR_CLR12_Pos                12                                                      /*!< SCT OUT6_CLR: CLR12 Position            */
#define SCT_OUT6_CLR_CLR12_Msk                (0x01UL << SCT_OUT6_CLR_CLR12_Pos)                      /*!< SCT OUT6_CLR: CLR12 Mask                */
#define SCT_OUT6_CLR_CLR13_Pos                13                                                      /*!< SCT OUT6_CLR: CLR13 Position            */
#define SCT_OUT6_CLR_CLR13_Msk                (0x01UL << SCT_OUT6_CLR_CLR13_Pos)                      /*!< SCT OUT6_CLR: CLR13 Mask                */
#define SCT_OUT6_CLR_CLR14_Pos                14                                                      /*!< SCT OUT6_CLR: CLR14 Position            */
#define SCT_OUT6_CLR_CLR14_Msk                (0x01UL << SCT_OUT6_CLR_CLR14_Pos)                      /*!< SCT OUT6_CLR: CLR14 Mask                */
#define SCT_OUT6_CLR_CLR15_Pos                15                                                      /*!< SCT OUT6_CLR: CLR15 Position            */
#define SCT_OUT6_CLR_CLR15_Msk                (0x01UL << SCT_OUT6_CLR_CLR15_Pos)                      /*!< SCT OUT6_CLR: CLR15 Mask                */

/* --------------------------------  SCT_OUT7_SET  -------------------------------- */
#define SCT_OUT7_SET_SET0_Pos                 0                                                       /*!< SCT OUT7_SET: SET0 Position             */
#define SCT_OUT7_SET_SET0_Msk                 (0x01UL << SCT_OUT7_SET_SET0_Pos)                       /*!< SCT OUT7_SET: SET0 Mask                 */
#define SCT_OUT7_SET_SET1_Pos                 1                                                       /*!< SCT OUT7_SET: SET1 Position             */
#define SCT_OUT7_SET_SET1_Msk                 (0x01UL << SCT_OUT7_SET_SET1_Pos)                       /*!< SCT OUT7_SET: SET1 Mask                 */
#define SCT_OUT7_SET_SET2_Pos                 2                                                       /*!< SCT OUT7_SET: SET2 Position             */
#define SCT_OUT7_SET_SET2_Msk                 (0x01UL << SCT_OUT7_SET_SET2_Pos)                       /*!< SCT OUT7_SET: SET2 Mask                 */
#define SCT_OUT7_SET_SET3_Pos                 3                                                       /*!< SCT OUT7_SET: SET3 Position             */
#define SCT_OUT7_SET_SET3_Msk                 (0x01UL << SCT_OUT7_SET_SET3_Pos)                       /*!< SCT OUT7_SET: SET3 Mask                 */
#define SCT_OUT7_SET_SET4_Pos                 4                                                       /*!< SCT OUT7_SET: SET4 Position             */
#define SCT_OUT7_SET_SET4_Msk                 (0x01UL << SCT_OUT7_SET_SET4_Pos)                       /*!< SCT OUT7_SET: SET4 Mask                 */
#define SCT_OUT7_SET_SET5_Pos                 5                                                       /*!< SCT OUT7_SET: SET5 Position             */
#define SCT_OUT7_SET_SET5_Msk                 (0x01UL << SCT_OUT7_SET_SET5_Pos)                       /*!< SCT OUT7_SET: SET5 Mask                 */
#define SCT_OUT7_SET_SET6_Pos                 6                                                       /*!< SCT OUT7_SET: SET6 Position             */
#define SCT_OUT7_SET_SET6_Msk                 (0x01UL << SCT_OUT7_SET_SET6_Pos)                       /*!< SCT OUT7_SET: SET6 Mask                 */
#define SCT_OUT7_SET_SET7_Pos                 7                                                       /*!< SCT OUT7_SET: SET7 Position             */
#define SCT_OUT7_SET_SET7_Msk                 (0x01UL << SCT_OUT7_SET_SET7_Pos)                       /*!< SCT OUT7_SET: SET7 Mask                 */
#define SCT_OUT7_SET_SET8_Pos                 8                                                       /*!< SCT OUT7_SET: SET8 Position             */
#define SCT_OUT7_SET_SET8_Msk                 (0x01UL << SCT_OUT7_SET_SET8_Pos)                       /*!< SCT OUT7_SET: SET8 Mask                 */
#define SCT_OUT7_SET_SET9_Pos                 9                                                       /*!< SCT OUT7_SET: SET9 Position             */
#define SCT_OUT7_SET_SET9_Msk                 (0x01UL << SCT_OUT7_SET_SET9_Pos)                       /*!< SCT OUT7_SET: SET9 Mask                 */
#define SCT_OUT7_SET_SET10_Pos                10                                                      /*!< SCT OUT7_SET: SET10 Position            */
#define SCT_OUT7_SET_SET10_Msk                (0x01UL << SCT_OUT7_SET_SET10_Pos)                      /*!< SCT OUT7_SET: SET10 Mask                */
#define SCT_OUT7_SET_SET11_Pos                11                                                      /*!< SCT OUT7_SET: SET11 Position            */
#define SCT_OUT7_SET_SET11_Msk                (0x01UL << SCT_OUT7_SET_SET11_Pos)                      /*!< SCT OUT7_SET: SET11 Mask                */
#define SCT_OUT7_SET_SET12_Pos                12                                                      /*!< SCT OUT7_SET: SET12 Position            */
#define SCT_OUT7_SET_SET12_Msk                (0x01UL << SCT_OUT7_SET_SET12_Pos)                      /*!< SCT OUT7_SET: SET12 Mask                */
#define SCT_OUT7_SET_SET13_Pos                13                                                      /*!< SCT OUT7_SET: SET13 Position            */
#define SCT_OUT7_SET_SET13_Msk                (0x01UL << SCT_OUT7_SET_SET13_Pos)                      /*!< SCT OUT7_SET: SET13 Mask                */
#define SCT_OUT7_SET_SET14_Pos                14                                                      /*!< SCT OUT7_SET: SET14 Position            */
#define SCT_OUT7_SET_SET14_Msk                (0x01UL << SCT_OUT7_SET_SET14_Pos)                      /*!< SCT OUT7_SET: SET14 Mask                */
#define SCT_OUT7_SET_SET15_Pos                15                                                      /*!< SCT OUT7_SET: SET15 Position            */
#define SCT_OUT7_SET_SET15_Msk                (0x01UL << SCT_OUT7_SET_SET15_Pos)                      /*!< SCT OUT7_SET: SET15 Mask                */

/* --------------------------------  SCT_OUT7_CLR  -------------------------------- */
#define SCT_OUT7_CLR_CLR0_Pos                 0                                                       /*!< SCT OUT7_CLR: CLR0 Position             */
#define SCT_OUT7_CLR_CLR0_Msk                 (0x01UL << SCT_OUT7_CLR_CLR0_Pos)                       /*!< SCT OUT7_CLR: CLR0 Mask                 */
#define SCT_OUT7_CLR_CLR1_Pos                 1                                                       /*!< SCT OUT7_CLR: CLR1 Position             */
#define SCT_OUT7_CLR_CLR1_Msk                 (0x01UL << SCT_OUT7_CLR_CLR1_Pos)                       /*!< SCT OUT7_CLR: CLR1 Mask                 */
#define SCT_OUT7_CLR_CLR2_Pos                 2                                                       /*!< SCT OUT7_CLR: CLR2 Position             */
#define SCT_OUT7_CLR_CLR2_Msk                 (0x01UL << SCT_OUT7_CLR_CLR2_Pos)                       /*!< SCT OUT7_CLR: CLR2 Mask                 */
#define SCT_OUT7_CLR_CLR3_Pos                 3                                                       /*!< SCT OUT7_CLR: CLR3 Position             */
#define SCT_OUT7_CLR_CLR3_Msk                 (0x01UL << SCT_OUT7_CLR_CLR3_Pos)                       /*!< SCT OUT7_CLR: CLR3 Mask                 */
#define SCT_OUT7_CLR_CLR4_Pos                 4                                                       /*!< SCT OUT7_CLR: CLR4 Position             */
#define SCT_OUT7_CLR_CLR4_Msk                 (0x01UL << SCT_OUT7_CLR_CLR4_Pos)                       /*!< SCT OUT7_CLR: CLR4 Mask                 */
#define SCT_OUT7_CLR_CLR5_Pos                 5                                                       /*!< SCT OUT7_CLR: CLR5 Position             */
#define SCT_OUT7_CLR_CLR5_Msk                 (0x01UL << SCT_OUT7_CLR_CLR5_Pos)                       /*!< SCT OUT7_CLR: CLR5 Mask                 */
#define SCT_OUT7_CLR_CLR6_Pos                 6                                                       /*!< SCT OUT7_CLR: CLR6 Position             */
#define SCT_OUT7_CLR_CLR6_Msk                 (0x01UL << SCT_OUT7_CLR_CLR6_Pos)                       /*!< SCT OUT7_CLR: CLR6 Mask                 */
#define SCT_OUT7_CLR_CLR7_Pos                 7                                                       /*!< SCT OUT7_CLR: CLR7 Position             */
#define SCT_OUT7_CLR_CLR7_Msk                 (0x01UL << SCT_OUT7_CLR_CLR7_Pos)                       /*!< SCT OUT7_CLR: CLR7 Mask                 */
#define SCT_OUT7_CLR_CLR8_Pos                 8                                                       /*!< SCT OUT7_CLR: CLR8 Position             */
#define SCT_OUT7_CLR_CLR8_Msk                 (0x01UL << SCT_OUT7_CLR_CLR8_Pos)                       /*!< SCT OUT7_CLR: CLR8 Mask                 */
#define SCT_OUT7_CLR_CLR9_Pos                 9                                                       /*!< SCT OUT7_CLR: CLR9 Position             */
#define SCT_OUT7_CLR_CLR9_Msk                 (0x01UL << SCT_OUT7_CLR_CLR9_Pos)                       /*!< SCT OUT7_CLR: CLR9 Mask                 */
#define SCT_OUT7_CLR_CLR10_Pos                10                                                      /*!< SCT OUT7_CLR: CLR10 Position            */
#define SCT_OUT7_CLR_CLR10_Msk                (0x01UL << SCT_OUT7_CLR_CLR10_Pos)                      /*!< SCT OUT7_CLR: CLR10 Mask                */
#define SCT_OUT7_CLR_CLR11_Pos                11                                                      /*!< SCT OUT7_CLR: CLR11 Position            */
#define SCT_OUT7_CLR_CLR11_Msk                (0x01UL << SCT_OUT7_CLR_CLR11_Pos)                      /*!< SCT OUT7_CLR: CLR11 Mask                */
#define SCT_OUT7_CLR_CLR12_Pos                12                                                      /*!< SCT OUT7_CLR: CLR12 Position            */
#define SCT_OUT7_CLR_CLR12_Msk                (0x01UL << SCT_OUT7_CLR_CLR12_Pos)                      /*!< SCT OUT7_CLR: CLR12 Mask                */
#define SCT_OUT7_CLR_CLR13_Pos                13                                                      /*!< SCT OUT7_CLR: CLR13 Position            */
#define SCT_OUT7_CLR_CLR13_Msk                (0x01UL << SCT_OUT7_CLR_CLR13_Pos)                      /*!< SCT OUT7_CLR: CLR13 Mask                */
#define SCT_OUT7_CLR_CLR14_Pos                14                                                      /*!< SCT OUT7_CLR: CLR14 Position            */
#define SCT_OUT7_CLR_CLR14_Msk                (0x01UL << SCT_OUT7_CLR_CLR14_Pos)                      /*!< SCT OUT7_CLR: CLR14 Mask                */
#define SCT_OUT7_CLR_CLR15_Pos                15                                                      /*!< SCT OUT7_CLR: CLR15 Position            */
#define SCT_OUT7_CLR_CLR15_Msk                (0x01UL << SCT_OUT7_CLR_CLR15_Pos)                      /*!< SCT OUT7_CLR: CLR15 Mask                */

/* --------------------------------  SCT_OUT8_SET  -------------------------------- */
#define SCT_OUT8_SET_SET0_Pos                 0                                                       /*!< SCT OUT8_SET: SET0 Position             */
#define SCT_OUT8_SET_SET0_Msk                 (0x01UL << SCT_OUT8_SET_SET0_Pos)                       /*!< SCT OUT8_SET: SET0 Mask                 */
#define SCT_OUT8_SET_SET1_Pos                 1                                                       /*!< SCT OUT8_SET: SET1 Position             */
#define SCT_OUT8_SET_SET1_Msk                 (0x01UL << SCT_OUT8_SET_SET1_Pos)                       /*!< SCT OUT8_SET: SET1 Mask                 */
#define SCT_OUT8_SET_SET2_Pos                 2                                                       /*!< SCT OUT8_SET: SET2 Position             */
#define SCT_OUT8_SET_SET2_Msk                 (0x01UL << SCT_OUT8_SET_SET2_Pos)                       /*!< SCT OUT8_SET: SET2 Mask                 */
#define SCT_OUT8_SET_SET3_Pos                 3                                                       /*!< SCT OUT8_SET: SET3 Position             */
#define SCT_OUT8_SET_SET3_Msk                 (0x01UL << SCT_OUT8_SET_SET3_Pos)                       /*!< SCT OUT8_SET: SET3 Mask                 */
#define SCT_OUT8_SET_SET4_Pos                 4                                                       /*!< SCT OUT8_SET: SET4 Position             */
#define SCT_OUT8_SET_SET4_Msk                 (0x01UL << SCT_OUT8_SET_SET4_Pos)                       /*!< SCT OUT8_SET: SET4 Mask                 */
#define SCT_OUT8_SET_SET5_Pos                 5                                                       /*!< SCT OUT8_SET: SET5 Position             */
#define SCT_OUT8_SET_SET5_Msk                 (0x01UL << SCT_OUT8_SET_SET5_Pos)                       /*!< SCT OUT8_SET: SET5 Mask                 */
#define SCT_OUT8_SET_SET6_Pos                 6                                                       /*!< SCT OUT8_SET: SET6 Position             */
#define SCT_OUT8_SET_SET6_Msk                 (0x01UL << SCT_OUT8_SET_SET6_Pos)                       /*!< SCT OUT8_SET: SET6 Mask                 */
#define SCT_OUT8_SET_SET7_Pos                 7                                                       /*!< SCT OUT8_SET: SET7 Position             */
#define SCT_OUT8_SET_SET7_Msk                 (0x01UL << SCT_OUT8_SET_SET7_Pos)                       /*!< SCT OUT8_SET: SET7 Mask                 */
#define SCT_OUT8_SET_SET8_Pos                 8                                                       /*!< SCT OUT8_SET: SET8 Position             */
#define SCT_OUT8_SET_SET8_Msk                 (0x01UL << SCT_OUT8_SET_SET8_Pos)                       /*!< SCT OUT8_SET: SET8 Mask                 */
#define SCT_OUT8_SET_SET9_Pos                 9                                                       /*!< SCT OUT8_SET: SET9 Position             */
#define SCT_OUT8_SET_SET9_Msk                 (0x01UL << SCT_OUT8_SET_SET9_Pos)                       /*!< SCT OUT8_SET: SET9 Mask                 */
#define SCT_OUT8_SET_SET10_Pos                10                                                      /*!< SCT OUT8_SET: SET10 Position            */
#define SCT_OUT8_SET_SET10_Msk                (0x01UL << SCT_OUT8_SET_SET10_Pos)                      /*!< SCT OUT8_SET: SET10 Mask                */
#define SCT_OUT8_SET_SET11_Pos                11                                                      /*!< SCT OUT8_SET: SET11 Position            */
#define SCT_OUT8_SET_SET11_Msk                (0x01UL << SCT_OUT8_SET_SET11_Pos)                      /*!< SCT OUT8_SET: SET11 Mask                */
#define SCT_OUT8_SET_SET12_Pos                12                                                      /*!< SCT OUT8_SET: SET12 Position            */
#define SCT_OUT8_SET_SET12_Msk                (0x01UL << SCT_OUT8_SET_SET12_Pos)                      /*!< SCT OUT8_SET: SET12 Mask                */
#define SCT_OUT8_SET_SET13_Pos                13                                                      /*!< SCT OUT8_SET: SET13 Position            */
#define SCT_OUT8_SET_SET13_Msk                (0x01UL << SCT_OUT8_SET_SET13_Pos)                      /*!< SCT OUT8_SET: SET13 Mask                */
#define SCT_OUT8_SET_SET14_Pos                14                                                      /*!< SCT OUT8_SET: SET14 Position            */
#define SCT_OUT8_SET_SET14_Msk                (0x01UL << SCT_OUT8_SET_SET14_Pos)                      /*!< SCT OUT8_SET: SET14 Mask                */
#define SCT_OUT8_SET_SET15_Pos                15                                                      /*!< SCT OUT8_SET: SET15 Position            */
#define SCT_OUT8_SET_SET15_Msk                (0x01UL << SCT_OUT8_SET_SET15_Pos)                      /*!< SCT OUT8_SET: SET15 Mask                */

/* --------------------------------  SCT_OUT8_CLR  -------------------------------- */
#define SCT_OUT8_CLR_CLR0_Pos                 0                                                       /*!< SCT OUT8_CLR: CLR0 Position             */
#define SCT_OUT8_CLR_CLR0_Msk                 (0x01UL << SCT_OUT8_CLR_CLR0_Pos)                       /*!< SCT OUT8_CLR: CLR0 Mask                 */
#define SCT_OUT8_CLR_CLR1_Pos                 1                                                       /*!< SCT OUT8_CLR: CLR1 Position             */
#define SCT_OUT8_CLR_CLR1_Msk                 (0x01UL << SCT_OUT8_CLR_CLR1_Pos)                       /*!< SCT OUT8_CLR: CLR1 Mask                 */
#define SCT_OUT8_CLR_CLR2_Pos                 2                                                       /*!< SCT OUT8_CLR: CLR2 Position             */
#define SCT_OUT8_CLR_CLR2_Msk                 (0x01UL << SCT_OUT8_CLR_CLR2_Pos)                       /*!< SCT OUT8_CLR: CLR2 Mask                 */
#define SCT_OUT8_CLR_CLR3_Pos                 3                                                       /*!< SCT OUT8_CLR: CLR3 Position             */
#define SCT_OUT8_CLR_CLR3_Msk                 (0x01UL << SCT_OUT8_CLR_CLR3_Pos)                       /*!< SCT OUT8_CLR: CLR3 Mask                 */
#define SCT_OUT8_CLR_CLR4_Pos                 4                                                       /*!< SCT OUT8_CLR: CLR4 Position             */
#define SCT_OUT8_CLR_CLR4_Msk                 (0x01UL << SCT_OUT8_CLR_CLR4_Pos)                       /*!< SCT OUT8_CLR: CLR4 Mask                 */
#define SCT_OUT8_CLR_CLR5_Pos                 5                                                       /*!< SCT OUT8_CLR: CLR5 Position             */
#define SCT_OUT8_CLR_CLR5_Msk                 (0x01UL << SCT_OUT8_CLR_CLR5_Pos)                       /*!< SCT OUT8_CLR: CLR5 Mask                 */
#define SCT_OUT8_CLR_CLR6_Pos                 6                                                       /*!< SCT OUT8_CLR: CLR6 Position             */
#define SCT_OUT8_CLR_CLR6_Msk                 (0x01UL << SCT_OUT8_CLR_CLR6_Pos)                       /*!< SCT OUT8_CLR: CLR6 Mask                 */
#define SCT_OUT8_CLR_CLR7_Pos                 7                                                       /*!< SCT OUT8_CLR: CLR7 Position             */
#define SCT_OUT8_CLR_CLR7_Msk                 (0x01UL << SCT_OUT8_CLR_CLR7_Pos)                       /*!< SCT OUT8_CLR: CLR7 Mask                 */
#define SCT_OUT8_CLR_CLR8_Pos                 8                                                       /*!< SCT OUT8_CLR: CLR8 Position             */
#define SCT_OUT8_CLR_CLR8_Msk                 (0x01UL << SCT_OUT8_CLR_CLR8_Pos)                       /*!< SCT OUT8_CLR: CLR8 Mask                 */
#define SCT_OUT8_CLR_CLR9_Pos                 9                                                       /*!< SCT OUT8_CLR: CLR9 Position             */
#define SCT_OUT8_CLR_CLR9_Msk                 (0x01UL << SCT_OUT8_CLR_CLR9_Pos)                       /*!< SCT OUT8_CLR: CLR9 Mask                 */
#define SCT_OUT8_CLR_CLR10_Pos                10                                                      /*!< SCT OUT8_CLR: CLR10 Position            */
#define SCT_OUT8_CLR_CLR10_Msk                (0x01UL << SCT_OUT8_CLR_CLR10_Pos)                      /*!< SCT OUT8_CLR: CLR10 Mask                */
#define SCT_OUT8_CLR_CLR11_Pos                11                                                      /*!< SCT OUT8_CLR: CLR11 Position            */
#define SCT_OUT8_CLR_CLR11_Msk                (0x01UL << SCT_OUT8_CLR_CLR11_Pos)                      /*!< SCT OUT8_CLR: CLR11 Mask                */
#define SCT_OUT8_CLR_CLR12_Pos                12                                                      /*!< SCT OUT8_CLR: CLR12 Position            */
#define SCT_OUT8_CLR_CLR12_Msk                (0x01UL << SCT_OUT8_CLR_CLR12_Pos)                      /*!< SCT OUT8_CLR: CLR12 Mask                */
#define SCT_OUT8_CLR_CLR13_Pos                13                                                      /*!< SCT OUT8_CLR: CLR13 Position            */
#define SCT_OUT8_CLR_CLR13_Msk                (0x01UL << SCT_OUT8_CLR_CLR13_Pos)                      /*!< SCT OUT8_CLR: CLR13 Mask                */
#define SCT_OUT8_CLR_CLR14_Pos                14                                                      /*!< SCT OUT8_CLR: CLR14 Position            */
#define SCT_OUT8_CLR_CLR14_Msk                (0x01UL << SCT_OUT8_CLR_CLR14_Pos)                      /*!< SCT OUT8_CLR: CLR14 Mask                */
#define SCT_OUT8_CLR_CLR15_Pos                15                                                      /*!< SCT OUT8_CLR: CLR15 Position            */
#define SCT_OUT8_CLR_CLR15_Msk                (0x01UL << SCT_OUT8_CLR_CLR15_Pos)                      /*!< SCT OUT8_CLR: CLR15 Mask                */

/* --------------------------------  SCT_OUT9_SET  -------------------------------- */
#define SCT_OUT9_SET_SET0_Pos                 0                                                       /*!< SCT OUT9_SET: SET0 Position             */
#define SCT_OUT9_SET_SET0_Msk                 (0x01UL << SCT_OUT9_SET_SET0_Pos)                       /*!< SCT OUT9_SET: SET0 Mask                 */
#define SCT_OUT9_SET_SET1_Pos                 1                                                       /*!< SCT OUT9_SET: SET1 Position             */
#define SCT_OUT9_SET_SET1_Msk                 (0x01UL << SCT_OUT9_SET_SET1_Pos)                       /*!< SCT OUT9_SET: SET1 Mask                 */
#define SCT_OUT9_SET_SET2_Pos                 2                                                       /*!< SCT OUT9_SET: SET2 Position             */
#define SCT_OUT9_SET_SET2_Msk                 (0x01UL << SCT_OUT9_SET_SET2_Pos)                       /*!< SCT OUT9_SET: SET2 Mask                 */
#define SCT_OUT9_SET_SET3_Pos                 3                                                       /*!< SCT OUT9_SET: SET3 Position             */
#define SCT_OUT9_SET_SET3_Msk                 (0x01UL << SCT_OUT9_SET_SET3_Pos)                       /*!< SCT OUT9_SET: SET3 Mask                 */
#define SCT_OUT9_SET_SET4_Pos                 4                                                       /*!< SCT OUT9_SET: SET4 Position             */
#define SCT_OUT9_SET_SET4_Msk                 (0x01UL << SCT_OUT9_SET_SET4_Pos)                       /*!< SCT OUT9_SET: SET4 Mask                 */
#define SCT_OUT9_SET_SET5_Pos                 5                                                       /*!< SCT OUT9_SET: SET5 Position             */
#define SCT_OUT9_SET_SET5_Msk                 (0x01UL << SCT_OUT9_SET_SET5_Pos)                       /*!< SCT OUT9_SET: SET5 Mask                 */
#define SCT_OUT9_SET_SET6_Pos                 6                                                       /*!< SCT OUT9_SET: SET6 Position             */
#define SCT_OUT9_SET_SET6_Msk                 (0x01UL << SCT_OUT9_SET_SET6_Pos)                       /*!< SCT OUT9_SET: SET6 Mask                 */
#define SCT_OUT9_SET_SET7_Pos                 7                                                       /*!< SCT OUT9_SET: SET7 Position             */
#define SCT_OUT9_SET_SET7_Msk                 (0x01UL << SCT_OUT9_SET_SET7_Pos)                       /*!< SCT OUT9_SET: SET7 Mask                 */
#define SCT_OUT9_SET_SET8_Pos                 8                                                       /*!< SCT OUT9_SET: SET8 Position             */
#define SCT_OUT9_SET_SET8_Msk                 (0x01UL << SCT_OUT9_SET_SET8_Pos)                       /*!< SCT OUT9_SET: SET8 Mask                 */
#define SCT_OUT9_SET_SET9_Pos                 9                                                       /*!< SCT OUT9_SET: SET9 Position             */
#define SCT_OUT9_SET_SET9_Msk                 (0x01UL << SCT_OUT9_SET_SET9_Pos)                       /*!< SCT OUT9_SET: SET9 Mask                 */
#define SCT_OUT9_SET_SET10_Pos                10                                                      /*!< SCT OUT9_SET: SET10 Position            */
#define SCT_OUT9_SET_SET10_Msk                (0x01UL << SCT_OUT9_SET_SET10_Pos)                      /*!< SCT OUT9_SET: SET10 Mask                */
#define SCT_OUT9_SET_SET11_Pos                11                                                      /*!< SCT OUT9_SET: SET11 Position            */
#define SCT_OUT9_SET_SET11_Msk                (0x01UL << SCT_OUT9_SET_SET11_Pos)                      /*!< SCT OUT9_SET: SET11 Mask                */
#define SCT_OUT9_SET_SET12_Pos                12                                                      /*!< SCT OUT9_SET: SET12 Position            */
#define SCT_OUT9_SET_SET12_Msk                (0x01UL << SCT_OUT9_SET_SET12_Pos)                      /*!< SCT OUT9_SET: SET12 Mask                */
#define SCT_OUT9_SET_SET13_Pos                13                                                      /*!< SCT OUT9_SET: SET13 Position            */
#define SCT_OUT9_SET_SET13_Msk                (0x01UL << SCT_OUT9_SET_SET13_Pos)                      /*!< SCT OUT9_SET: SET13 Mask                */
#define SCT_OUT9_SET_SET14_Pos                14                                                      /*!< SCT OUT9_SET: SET14 Position            */
#define SCT_OUT9_SET_SET14_Msk                (0x01UL << SCT_OUT9_SET_SET14_Pos)                      /*!< SCT OUT9_SET: SET14 Mask                */
#define SCT_OUT9_SET_SET15_Pos                15                                                      /*!< SCT OUT9_SET: SET15 Position            */
#define SCT_OUT9_SET_SET15_Msk                (0x01UL << SCT_OUT9_SET_SET15_Pos)                      /*!< SCT OUT9_SET: SET15 Mask                */

/* --------------------------------  SCT_OUT9_CLR  -------------------------------- */
#define SCT_OUT9_CLR_CLR0_Pos                 0                                                       /*!< SCT OUT9_CLR: CLR0 Position             */
#define SCT_OUT9_CLR_CLR0_Msk                 (0x01UL << SCT_OUT9_CLR_CLR0_Pos)                       /*!< SCT OUT9_CLR: CLR0 Mask                 */
#define SCT_OUT9_CLR_CLR1_Pos                 1                                                       /*!< SCT OUT9_CLR: CLR1 Position             */
#define SCT_OUT9_CLR_CLR1_Msk                 (0x01UL << SCT_OUT9_CLR_CLR1_Pos)                       /*!< SCT OUT9_CLR: CLR1 Mask                 */
#define SCT_OUT9_CLR_CLR2_Pos                 2                                                       /*!< SCT OUT9_CLR: CLR2 Position             */
#define SCT_OUT9_CLR_CLR2_Msk                 (0x01UL << SCT_OUT9_CLR_CLR2_Pos)                       /*!< SCT OUT9_CLR: CLR2 Mask                 */
#define SCT_OUT9_CLR_CLR3_Pos                 3                                                       /*!< SCT OUT9_CLR: CLR3 Position             */
#define SCT_OUT9_CLR_CLR3_Msk                 (0x01UL << SCT_OUT9_CLR_CLR3_Pos)                       /*!< SCT OUT9_CLR: CLR3 Mask                 */
#define SCT_OUT9_CLR_CLR4_Pos                 4                                                       /*!< SCT OUT9_CLR: CLR4 Position             */
#define SCT_OUT9_CLR_CLR4_Msk                 (0x01UL << SCT_OUT9_CLR_CLR4_Pos)                       /*!< SCT OUT9_CLR: CLR4 Mask                 */
#define SCT_OUT9_CLR_CLR5_Pos                 5                                                       /*!< SCT OUT9_CLR: CLR5 Position             */
#define SCT_OUT9_CLR_CLR5_Msk                 (0x01UL << SCT_OUT9_CLR_CLR5_Pos)                       /*!< SCT OUT9_CLR: CLR5 Mask                 */
#define SCT_OUT9_CLR_CLR6_Pos                 6                                                       /*!< SCT OUT9_CLR: CLR6 Position             */
#define SCT_OUT9_CLR_CLR6_Msk                 (0x01UL << SCT_OUT9_CLR_CLR6_Pos)                       /*!< SCT OUT9_CLR: CLR6 Mask                 */
#define SCT_OUT9_CLR_CLR7_Pos                 7                                                       /*!< SCT OUT9_CLR: CLR7 Position             */
#define SCT_OUT9_CLR_CLR7_Msk                 (0x01UL << SCT_OUT9_CLR_CLR7_Pos)                       /*!< SCT OUT9_CLR: CLR7 Mask                 */
#define SCT_OUT9_CLR_CLR8_Pos                 8                                                       /*!< SCT OUT9_CLR: CLR8 Position             */
#define SCT_OUT9_CLR_CLR8_Msk                 (0x01UL << SCT_OUT9_CLR_CLR8_Pos)                       /*!< SCT OUT9_CLR: CLR8 Mask                 */
#define SCT_OUT9_CLR_CLR9_Pos                 9                                                       /*!< SCT OUT9_CLR: CLR9 Position             */
#define SCT_OUT9_CLR_CLR9_Msk                 (0x01UL << SCT_OUT9_CLR_CLR9_Pos)                       /*!< SCT OUT9_CLR: CLR9 Mask                 */
#define SCT_OUT9_CLR_CLR10_Pos                10                                                      /*!< SCT OUT9_CLR: CLR10 Position            */
#define SCT_OUT9_CLR_CLR10_Msk                (0x01UL << SCT_OUT9_CLR_CLR10_Pos)                      /*!< SCT OUT9_CLR: CLR10 Mask                */
#define SCT_OUT9_CLR_CLR11_Pos                11                                                      /*!< SCT OUT9_CLR: CLR11 Position            */
#define SCT_OUT9_CLR_CLR11_Msk                (0x01UL << SCT_OUT9_CLR_CLR11_Pos)                      /*!< SCT OUT9_CLR: CLR11 Mask                */
#define SCT_OUT9_CLR_CLR12_Pos                12                                                      /*!< SCT OUT9_CLR: CLR12 Position            */
#define SCT_OUT9_CLR_CLR12_Msk                (0x01UL << SCT_OUT9_CLR_CLR12_Pos)                      /*!< SCT OUT9_CLR: CLR12 Mask                */
#define SCT_OUT9_CLR_CLR13_Pos                13                                                      /*!< SCT OUT9_CLR: CLR13 Position            */
#define SCT_OUT9_CLR_CLR13_Msk                (0x01UL << SCT_OUT9_CLR_CLR13_Pos)                      /*!< SCT OUT9_CLR: CLR13 Mask                */
#define SCT_OUT9_CLR_CLR14_Pos                14                                                      /*!< SCT OUT9_CLR: CLR14 Position            */
#define SCT_OUT9_CLR_CLR14_Msk                (0x01UL << SCT_OUT9_CLR_CLR14_Pos)                      /*!< SCT OUT9_CLR: CLR14 Mask                */
#define SCT_OUT9_CLR_CLR15_Pos                15                                                      /*!< SCT OUT9_CLR: CLR15 Position            */
#define SCT_OUT9_CLR_CLR15_Msk                (0x01UL << SCT_OUT9_CLR_CLR15_Pos)                      /*!< SCT OUT9_CLR: CLR15 Mask                */

/* --------------------------------  SCT_OUT10_SET  ------------------------------- */
#define SCT_OUT10_SET_SET0_Pos                0                                                       /*!< SCT OUT10_SET: SET0 Position            */
#define SCT_OUT10_SET_SET0_Msk                (0x01UL << SCT_OUT10_SET_SET0_Pos)                      /*!< SCT OUT10_SET: SET0 Mask                */
#define SCT_OUT10_SET_SET1_Pos                1                                                       /*!< SCT OUT10_SET: SET1 Position            */
#define SCT_OUT10_SET_SET1_Msk                (0x01UL << SCT_OUT10_SET_SET1_Pos)                      /*!< SCT OUT10_SET: SET1 Mask                */
#define SCT_OUT10_SET_SET2_Pos                2                                                       /*!< SCT OUT10_SET: SET2 Position            */
#define SCT_OUT10_SET_SET2_Msk                (0x01UL << SCT_OUT10_SET_SET2_Pos)                      /*!< SCT OUT10_SET: SET2 Mask                */
#define SCT_OUT10_SET_SET3_Pos                3                                                       /*!< SCT OUT10_SET: SET3 Position            */
#define SCT_OUT10_SET_SET3_Msk                (0x01UL << SCT_OUT10_SET_SET3_Pos)                      /*!< SCT OUT10_SET: SET3 Mask                */
#define SCT_OUT10_SET_SET4_Pos                4                                                       /*!< SCT OUT10_SET: SET4 Position            */
#define SCT_OUT10_SET_SET4_Msk                (0x01UL << SCT_OUT10_SET_SET4_Pos)                      /*!< SCT OUT10_SET: SET4 Mask                */
#define SCT_OUT10_SET_SET5_Pos                5                                                       /*!< SCT OUT10_SET: SET5 Position            */
#define SCT_OUT10_SET_SET5_Msk                (0x01UL << SCT_OUT10_SET_SET5_Pos)                      /*!< SCT OUT10_SET: SET5 Mask                */
#define SCT_OUT10_SET_SET6_Pos                6                                                       /*!< SCT OUT10_SET: SET6 Position            */
#define SCT_OUT10_SET_SET6_Msk                (0x01UL << SCT_OUT10_SET_SET6_Pos)                      /*!< SCT OUT10_SET: SET6 Mask                */
#define SCT_OUT10_SET_SET7_Pos                7                                                       /*!< SCT OUT10_SET: SET7 Position            */
#define SCT_OUT10_SET_SET7_Msk                (0x01UL << SCT_OUT10_SET_SET7_Pos)                      /*!< SCT OUT10_SET: SET7 Mask                */
#define SCT_OUT10_SET_SET8_Pos                8                                                       /*!< SCT OUT10_SET: SET8 Position            */
#define SCT_OUT10_SET_SET8_Msk                (0x01UL << SCT_OUT10_SET_SET8_Pos)                      /*!< SCT OUT10_SET: SET8 Mask                */
#define SCT_OUT10_SET_SET9_Pos                9                                                       /*!< SCT OUT10_SET: SET9 Position            */
#define SCT_OUT10_SET_SET9_Msk                (0x01UL << SCT_OUT10_SET_SET9_Pos)                      /*!< SCT OUT10_SET: SET9 Mask                */
#define SCT_OUT10_SET_SET10_Pos               10                                                      /*!< SCT OUT10_SET: SET10 Position           */
#define SCT_OUT10_SET_SET10_Msk               (0x01UL << SCT_OUT10_SET_SET10_Pos)                     /*!< SCT OUT10_SET: SET10 Mask               */
#define SCT_OUT10_SET_SET11_Pos               11                                                      /*!< SCT OUT10_SET: SET11 Position           */
#define SCT_OUT10_SET_SET11_Msk               (0x01UL << SCT_OUT10_SET_SET11_Pos)                     /*!< SCT OUT10_SET: SET11 Mask               */
#define SCT_OUT10_SET_SET12_Pos               12                                                      /*!< SCT OUT10_SET: SET12 Position           */
#define SCT_OUT10_SET_SET12_Msk               (0x01UL << SCT_OUT10_SET_SET12_Pos)                     /*!< SCT OUT10_SET: SET12 Mask               */
#define SCT_OUT10_SET_SET13_Pos               13                                                      /*!< SCT OUT10_SET: SET13 Position           */
#define SCT_OUT10_SET_SET13_Msk               (0x01UL << SCT_OUT10_SET_SET13_Pos)                     /*!< SCT OUT10_SET: SET13 Mask               */
#define SCT_OUT10_SET_SET14_Pos               14                                                      /*!< SCT OUT10_SET: SET14 Position           */
#define SCT_OUT10_SET_SET14_Msk               (0x01UL << SCT_OUT10_SET_SET14_Pos)                     /*!< SCT OUT10_SET: SET14 Mask               */
#define SCT_OUT10_SET_SET15_Pos               15                                                      /*!< SCT OUT10_SET: SET15 Position           */
#define SCT_OUT10_SET_SET15_Msk               (0x01UL << SCT_OUT10_SET_SET15_Pos)                     /*!< SCT OUT10_SET: SET15 Mask               */

/* --------------------------------  SCT_OUT10_CLR  ------------------------------- */
#define SCT_OUT10_CLR_CLR0_Pos                0                                                       /*!< SCT OUT10_CLR: CLR0 Position            */
#define SCT_OUT10_CLR_CLR0_Msk                (0x01UL << SCT_OUT10_CLR_CLR0_Pos)                      /*!< SCT OUT10_CLR: CLR0 Mask                */
#define SCT_OUT10_CLR_CLR1_Pos                1                                                       /*!< SCT OUT10_CLR: CLR1 Position            */
#define SCT_OUT10_CLR_CLR1_Msk                (0x01UL << SCT_OUT10_CLR_CLR1_Pos)                      /*!< SCT OUT10_CLR: CLR1 Mask                */
#define SCT_OUT10_CLR_CLR2_Pos                2                                                       /*!< SCT OUT10_CLR: CLR2 Position            */
#define SCT_OUT10_CLR_CLR2_Msk                (0x01UL << SCT_OUT10_CLR_CLR2_Pos)                      /*!< SCT OUT10_CLR: CLR2 Mask                */
#define SCT_OUT10_CLR_CLR3_Pos                3                                                       /*!< SCT OUT10_CLR: CLR3 Position            */
#define SCT_OUT10_CLR_CLR3_Msk                (0x01UL << SCT_OUT10_CLR_CLR3_Pos)                      /*!< SCT OUT10_CLR: CLR3 Mask                */
#define SCT_OUT10_CLR_CLR4_Pos                4                                                       /*!< SCT OUT10_CLR: CLR4 Position            */
#define SCT_OUT10_CLR_CLR4_Msk                (0x01UL << SCT_OUT10_CLR_CLR4_Pos)                      /*!< SCT OUT10_CLR: CLR4 Mask                */
#define SCT_OUT10_CLR_CLR5_Pos                5                                                       /*!< SCT OUT10_CLR: CLR5 Position            */
#define SCT_OUT10_CLR_CLR5_Msk                (0x01UL << SCT_OUT10_CLR_CLR5_Pos)                      /*!< SCT OUT10_CLR: CLR5 Mask                */
#define SCT_OUT10_CLR_CLR6_Pos                6                                                       /*!< SCT OUT10_CLR: CLR6 Position            */
#define SCT_OUT10_CLR_CLR6_Msk                (0x01UL << SCT_OUT10_CLR_CLR6_Pos)                      /*!< SCT OUT10_CLR: CLR6 Mask                */
#define SCT_OUT10_CLR_CLR7_Pos                7                                                       /*!< SCT OUT10_CLR: CLR7 Position            */
#define SCT_OUT10_CLR_CLR7_Msk                (0x01UL << SCT_OUT10_CLR_CLR7_Pos)                      /*!< SCT OUT10_CLR: CLR7 Mask                */
#define SCT_OUT10_CLR_CLR8_Pos                8                                                       /*!< SCT OUT10_CLR: CLR8 Position            */
#define SCT_OUT10_CLR_CLR8_Msk                (0x01UL << SCT_OUT10_CLR_CLR8_Pos)                      /*!< SCT OUT10_CLR: CLR8 Mask                */
#define SCT_OUT10_CLR_CLR9_Pos                9                                                       /*!< SCT OUT10_CLR: CLR9 Position            */
#define SCT_OUT10_CLR_CLR9_Msk                (0x01UL << SCT_OUT10_CLR_CLR9_Pos)                      /*!< SCT OUT10_CLR: CLR9 Mask                */
#define SCT_OUT10_CLR_CLR10_Pos               10                                                      /*!< SCT OUT10_CLR: CLR10 Position           */
#define SCT_OUT10_CLR_CLR10_Msk               (0x01UL << SCT_OUT10_CLR_CLR10_Pos)                     /*!< SCT OUT10_CLR: CLR10 Mask               */
#define SCT_OUT10_CLR_CLR11_Pos               11                                                      /*!< SCT OUT10_CLR: CLR11 Position           */
#define SCT_OUT10_CLR_CLR11_Msk               (0x01UL << SCT_OUT10_CLR_CLR11_Pos)                     /*!< SCT OUT10_CLR: CLR11 Mask               */
#define SCT_OUT10_CLR_CLR12_Pos               12                                                      /*!< SCT OUT10_CLR: CLR12 Position           */
#define SCT_OUT10_CLR_CLR12_Msk               (0x01UL << SCT_OUT10_CLR_CLR12_Pos)                     /*!< SCT OUT10_CLR: CLR12 Mask               */
#define SCT_OUT10_CLR_CLR13_Pos               13                                                      /*!< SCT OUT10_CLR: CLR13 Position           */
#define SCT_OUT10_CLR_CLR13_Msk               (0x01UL << SCT_OUT10_CLR_CLR13_Pos)                     /*!< SCT OUT10_CLR: CLR13 Mask               */
#define SCT_OUT10_CLR_CLR14_Pos               14                                                      /*!< SCT OUT10_CLR: CLR14 Position           */
#define SCT_OUT10_CLR_CLR14_Msk               (0x01UL << SCT_OUT10_CLR_CLR14_Pos)                     /*!< SCT OUT10_CLR: CLR14 Mask               */
#define SCT_OUT10_CLR_CLR15_Pos               15                                                      /*!< SCT OUT10_CLR: CLR15 Position           */
#define SCT_OUT10_CLR_CLR15_Msk               (0x01UL << SCT_OUT10_CLR_CLR15_Pos)                     /*!< SCT OUT10_CLR: CLR15 Mask               */

/* --------------------------------  SCT_OUT11_SET  ------------------------------- */
#define SCT_OUT11_SET_SET0_Pos                0                                                       /*!< SCT OUT11_SET: SET0 Position            */
#define SCT_OUT11_SET_SET0_Msk                (0x01UL << SCT_OUT11_SET_SET0_Pos)                      /*!< SCT OUT11_SET: SET0 Mask                */
#define SCT_OUT11_SET_SET1_Pos                1                                                       /*!< SCT OUT11_SET: SET1 Position            */
#define SCT_OUT11_SET_SET1_Msk                (0x01UL << SCT_OUT11_SET_SET1_Pos)                      /*!< SCT OUT11_SET: SET1 Mask                */
#define SCT_OUT11_SET_SET2_Pos                2                                                       /*!< SCT OUT11_SET: SET2 Position            */
#define SCT_OUT11_SET_SET2_Msk                (0x01UL << SCT_OUT11_SET_SET2_Pos)                      /*!< SCT OUT11_SET: SET2 Mask                */
#define SCT_OUT11_SET_SET3_Pos                3                                                       /*!< SCT OUT11_SET: SET3 Position            */
#define SCT_OUT11_SET_SET3_Msk                (0x01UL << SCT_OUT11_SET_SET3_Pos)                      /*!< SCT OUT11_SET: SET3 Mask                */
#define SCT_OUT11_SET_SET4_Pos                4                                                       /*!< SCT OUT11_SET: SET4 Position            */
#define SCT_OUT11_SET_SET4_Msk                (0x01UL << SCT_OUT11_SET_SET4_Pos)                      /*!< SCT OUT11_SET: SET4 Mask                */
#define SCT_OUT11_SET_SET5_Pos                5                                                       /*!< SCT OUT11_SET: SET5 Position            */
#define SCT_OUT11_SET_SET5_Msk                (0x01UL << SCT_OUT11_SET_SET5_Pos)                      /*!< SCT OUT11_SET: SET5 Mask                */
#define SCT_OUT11_SET_SET6_Pos                6                                                       /*!< SCT OUT11_SET: SET6 Position            */
#define SCT_OUT11_SET_SET6_Msk                (0x01UL << SCT_OUT11_SET_SET6_Pos)                      /*!< SCT OUT11_SET: SET6 Mask                */
#define SCT_OUT11_SET_SET7_Pos                7                                                       /*!< SCT OUT11_SET: SET7 Position            */
#define SCT_OUT11_SET_SET7_Msk                (0x01UL << SCT_OUT11_SET_SET7_Pos)                      /*!< SCT OUT11_SET: SET7 Mask                */
#define SCT_OUT11_SET_SET8_Pos                8                                                       /*!< SCT OUT11_SET: SET8 Position            */
#define SCT_OUT11_SET_SET8_Msk                (0x01UL << SCT_OUT11_SET_SET8_Pos)                      /*!< SCT OUT11_SET: SET8 Mask                */
#define SCT_OUT11_SET_SET9_Pos                9                                                       /*!< SCT OUT11_SET: SET9 Position            */
#define SCT_OUT11_SET_SET9_Msk                (0x01UL << SCT_OUT11_SET_SET9_Pos)                      /*!< SCT OUT11_SET: SET9 Mask                */
#define SCT_OUT11_SET_SET10_Pos               10                                                      /*!< SCT OUT11_SET: SET10 Position           */
#define SCT_OUT11_SET_SET10_Msk               (0x01UL << SCT_OUT11_SET_SET10_Pos)                     /*!< SCT OUT11_SET: SET10 Mask               */
#define SCT_OUT11_SET_SET11_Pos               11                                                      /*!< SCT OUT11_SET: SET11 Position           */
#define SCT_OUT11_SET_SET11_Msk               (0x01UL << SCT_OUT11_SET_SET11_Pos)                     /*!< SCT OUT11_SET: SET11 Mask               */
#define SCT_OUT11_SET_SET12_Pos               12                                                      /*!< SCT OUT11_SET: SET12 Position           */
#define SCT_OUT11_SET_SET12_Msk               (0x01UL << SCT_OUT11_SET_SET12_Pos)                     /*!< SCT OUT11_SET: SET12 Mask               */
#define SCT_OUT11_SET_SET13_Pos               13                                                      /*!< SCT OUT11_SET: SET13 Position           */
#define SCT_OUT11_SET_SET13_Msk               (0x01UL << SCT_OUT11_SET_SET13_Pos)                     /*!< SCT OUT11_SET: SET13 Mask               */
#define SCT_OUT11_SET_SET14_Pos               14                                                      /*!< SCT OUT11_SET: SET14 Position           */
#define SCT_OUT11_SET_SET14_Msk               (0x01UL << SCT_OUT11_SET_SET14_Pos)                     /*!< SCT OUT11_SET: SET14 Mask               */
#define SCT_OUT11_SET_SET15_Pos               15                                                      /*!< SCT OUT11_SET: SET15 Position           */
#define SCT_OUT11_SET_SET15_Msk               (0x01UL << SCT_OUT11_SET_SET15_Pos)                     /*!< SCT OUT11_SET: SET15 Mask               */

/* --------------------------------  SCT_OUT11_CLR  ------------------------------- */
#define SCT_OUT11_CLR_CLR0_Pos                0                                                       /*!< SCT OUT11_CLR: CLR0 Position            */
#define SCT_OUT11_CLR_CLR0_Msk                (0x01UL << SCT_OUT11_CLR_CLR0_Pos)                      /*!< SCT OUT11_CLR: CLR0 Mask                */
#define SCT_OUT11_CLR_CLR1_Pos                1                                                       /*!< SCT OUT11_CLR: CLR1 Position            */
#define SCT_OUT11_CLR_CLR1_Msk                (0x01UL << SCT_OUT11_CLR_CLR1_Pos)                      /*!< SCT OUT11_CLR: CLR1 Mask                */
#define SCT_OUT11_CLR_CLR2_Pos                2                                                       /*!< SCT OUT11_CLR: CLR2 Position            */
#define SCT_OUT11_CLR_CLR2_Msk                (0x01UL << SCT_OUT11_CLR_CLR2_Pos)                      /*!< SCT OUT11_CLR: CLR2 Mask                */
#define SCT_OUT11_CLR_CLR3_Pos                3                                                       /*!< SCT OUT11_CLR: CLR3 Position            */
#define SCT_OUT11_CLR_CLR3_Msk                (0x01UL << SCT_OUT11_CLR_CLR3_Pos)                      /*!< SCT OUT11_CLR: CLR3 Mask                */
#define SCT_OUT11_CLR_CLR4_Pos                4                                                       /*!< SCT OUT11_CLR: CLR4 Position            */
#define SCT_OUT11_CLR_CLR4_Msk                (0x01UL << SCT_OUT11_CLR_CLR4_Pos)                      /*!< SCT OUT11_CLR: CLR4 Mask                */
#define SCT_OUT11_CLR_CLR5_Pos                5                                                       /*!< SCT OUT11_CLR: CLR5 Position            */
#define SCT_OUT11_CLR_CLR5_Msk                (0x01UL << SCT_OUT11_CLR_CLR5_Pos)                      /*!< SCT OUT11_CLR: CLR5 Mask                */
#define SCT_OUT11_CLR_CLR6_Pos                6                                                       /*!< SCT OUT11_CLR: CLR6 Position            */
#define SCT_OUT11_CLR_CLR6_Msk                (0x01UL << SCT_OUT11_CLR_CLR6_Pos)                      /*!< SCT OUT11_CLR: CLR6 Mask                */
#define SCT_OUT11_CLR_CLR7_Pos                7                                                       /*!< SCT OUT11_CLR: CLR7 Position            */
#define SCT_OUT11_CLR_CLR7_Msk                (0x01UL << SCT_OUT11_CLR_CLR7_Pos)                      /*!< SCT OUT11_CLR: CLR7 Mask                */
#define SCT_OUT11_CLR_CLR8_Pos                8                                                       /*!< SCT OUT11_CLR: CLR8 Position            */
#define SCT_OUT11_CLR_CLR8_Msk                (0x01UL << SCT_OUT11_CLR_CLR8_Pos)                      /*!< SCT OUT11_CLR: CLR8 Mask                */
#define SCT_OUT11_CLR_CLR9_Pos                9                                                       /*!< SCT OUT11_CLR: CLR9 Position            */
#define SCT_OUT11_CLR_CLR9_Msk                (0x01UL << SCT_OUT11_CLR_CLR9_Pos)                      /*!< SCT OUT11_CLR: CLR9 Mask                */
#define SCT_OUT11_CLR_CLR10_Pos               10                                                      /*!< SCT OUT11_CLR: CLR10 Position           */
#define SCT_OUT11_CLR_CLR10_Msk               (0x01UL << SCT_OUT11_CLR_CLR10_Pos)                     /*!< SCT OUT11_CLR: CLR10 Mask               */
#define SCT_OUT11_CLR_CLR11_Pos               11                                                      /*!< SCT OUT11_CLR: CLR11 Position           */
#define SCT_OUT11_CLR_CLR11_Msk               (0x01UL << SCT_OUT11_CLR_CLR11_Pos)                     /*!< SCT OUT11_CLR: CLR11 Mask               */
#define SCT_OUT11_CLR_CLR12_Pos               12                                                      /*!< SCT OUT11_CLR: CLR12 Position           */
#define SCT_OUT11_CLR_CLR12_Msk               (0x01UL << SCT_OUT11_CLR_CLR12_Pos)                     /*!< SCT OUT11_CLR: CLR12 Mask               */
#define SCT_OUT11_CLR_CLR13_Pos               13                                                      /*!< SCT OUT11_CLR: CLR13 Position           */
#define SCT_OUT11_CLR_CLR13_Msk               (0x01UL << SCT_OUT11_CLR_CLR13_Pos)                     /*!< SCT OUT11_CLR: CLR13 Mask               */
#define SCT_OUT11_CLR_CLR14_Pos               14                                                      /*!< SCT OUT11_CLR: CLR14 Position           */
#define SCT_OUT11_CLR_CLR14_Msk               (0x01UL << SCT_OUT11_CLR_CLR14_Pos)                     /*!< SCT OUT11_CLR: CLR14 Mask               */
#define SCT_OUT11_CLR_CLR15_Pos               15                                                      /*!< SCT OUT11_CLR: CLR15 Position           */
#define SCT_OUT11_CLR_CLR15_Msk               (0x01UL << SCT_OUT11_CLR_CLR15_Pos)                     /*!< SCT OUT11_CLR: CLR15 Mask               */

/* --------------------------------  SCT_OUT12_SET  ------------------------------- */
#define SCT_OUT12_SET_SET0_Pos                0                                                       /*!< SCT OUT12_SET: SET0 Position            */
#define SCT_OUT12_SET_SET0_Msk                (0x01UL << SCT_OUT12_SET_SET0_Pos)                      /*!< SCT OUT12_SET: SET0 Mask                */
#define SCT_OUT12_SET_SET1_Pos                1                                                       /*!< SCT OUT12_SET: SET1 Position            */
#define SCT_OUT12_SET_SET1_Msk                (0x01UL << SCT_OUT12_SET_SET1_Pos)                      /*!< SCT OUT12_SET: SET1 Mask                */
#define SCT_OUT12_SET_SET2_Pos                2                                                       /*!< SCT OUT12_SET: SET2 Position            */
#define SCT_OUT12_SET_SET2_Msk                (0x01UL << SCT_OUT12_SET_SET2_Pos)                      /*!< SCT OUT12_SET: SET2 Mask                */
#define SCT_OUT12_SET_SET3_Pos                3                                                       /*!< SCT OUT12_SET: SET3 Position            */
#define SCT_OUT12_SET_SET3_Msk                (0x01UL << SCT_OUT12_SET_SET3_Pos)                      /*!< SCT OUT12_SET: SET3 Mask                */
#define SCT_OUT12_SET_SET4_Pos                4                                                       /*!< SCT OUT12_SET: SET4 Position            */
#define SCT_OUT12_SET_SET4_Msk                (0x01UL << SCT_OUT12_SET_SET4_Pos)                      /*!< SCT OUT12_SET: SET4 Mask                */
#define SCT_OUT12_SET_SET5_Pos                5                                                       /*!< SCT OUT12_SET: SET5 Position            */
#define SCT_OUT12_SET_SET5_Msk                (0x01UL << SCT_OUT12_SET_SET5_Pos)                      /*!< SCT OUT12_SET: SET5 Mask                */
#define SCT_OUT12_SET_SET6_Pos                6                                                       /*!< SCT OUT12_SET: SET6 Position            */
#define SCT_OUT12_SET_SET6_Msk                (0x01UL << SCT_OUT12_SET_SET6_Pos)                      /*!< SCT OUT12_SET: SET6 Mask                */
#define SCT_OUT12_SET_SET7_Pos                7                                                       /*!< SCT OUT12_SET: SET7 Position            */
#define SCT_OUT12_SET_SET7_Msk                (0x01UL << SCT_OUT12_SET_SET7_Pos)                      /*!< SCT OUT12_SET: SET7 Mask                */
#define SCT_OUT12_SET_SET8_Pos                8                                                       /*!< SCT OUT12_SET: SET8 Position            */
#define SCT_OUT12_SET_SET8_Msk                (0x01UL << SCT_OUT12_SET_SET8_Pos)                      /*!< SCT OUT12_SET: SET8 Mask                */
#define SCT_OUT12_SET_SET9_Pos                9                                                       /*!< SCT OUT12_SET: SET9 Position            */
#define SCT_OUT12_SET_SET9_Msk                (0x01UL << SCT_OUT12_SET_SET9_Pos)                      /*!< SCT OUT12_SET: SET9 Mask                */
#define SCT_OUT12_SET_SET10_Pos               10                                                      /*!< SCT OUT12_SET: SET10 Position           */
#define SCT_OUT12_SET_SET10_Msk               (0x01UL << SCT_OUT12_SET_SET10_Pos)                     /*!< SCT OUT12_SET: SET10 Mask               */
#define SCT_OUT12_SET_SET11_Pos               11                                                      /*!< SCT OUT12_SET: SET11 Position           */
#define SCT_OUT12_SET_SET11_Msk               (0x01UL << SCT_OUT12_SET_SET11_Pos)                     /*!< SCT OUT12_SET: SET11 Mask               */
#define SCT_OUT12_SET_SET12_Pos               12                                                      /*!< SCT OUT12_SET: SET12 Position           */
#define SCT_OUT12_SET_SET12_Msk               (0x01UL << SCT_OUT12_SET_SET12_Pos)                     /*!< SCT OUT12_SET: SET12 Mask               */
#define SCT_OUT12_SET_SET13_Pos               13                                                      /*!< SCT OUT12_SET: SET13 Position           */
#define SCT_OUT12_SET_SET13_Msk               (0x01UL << SCT_OUT12_SET_SET13_Pos)                     /*!< SCT OUT12_SET: SET13 Mask               */
#define SCT_OUT12_SET_SET14_Pos               14                                                      /*!< SCT OUT12_SET: SET14 Position           */
#define SCT_OUT12_SET_SET14_Msk               (0x01UL << SCT_OUT12_SET_SET14_Pos)                     /*!< SCT OUT12_SET: SET14 Mask               */
#define SCT_OUT12_SET_SET15_Pos               15                                                      /*!< SCT OUT12_SET: SET15 Position           */
#define SCT_OUT12_SET_SET15_Msk               (0x01UL << SCT_OUT12_SET_SET15_Pos)                     /*!< SCT OUT12_SET: SET15 Mask               */

/* --------------------------------  SCT_OUT12_CLR  ------------------------------- */
#define SCT_OUT12_CLR_CLR0_Pos                0                                                       /*!< SCT OUT12_CLR: CLR0 Position            */
#define SCT_OUT12_CLR_CLR0_Msk                (0x01UL << SCT_OUT12_CLR_CLR0_Pos)                      /*!< SCT OUT12_CLR: CLR0 Mask                */
#define SCT_OUT12_CLR_CLR1_Pos                1                                                       /*!< SCT OUT12_CLR: CLR1 Position            */
#define SCT_OUT12_CLR_CLR1_Msk                (0x01UL << SCT_OUT12_CLR_CLR1_Pos)                      /*!< SCT OUT12_CLR: CLR1 Mask                */
#define SCT_OUT12_CLR_CLR2_Pos                2                                                       /*!< SCT OUT12_CLR: CLR2 Position            */
#define SCT_OUT12_CLR_CLR2_Msk                (0x01UL << SCT_OUT12_CLR_CLR2_Pos)                      /*!< SCT OUT12_CLR: CLR2 Mask                */
#define SCT_OUT12_CLR_CLR3_Pos                3                                                       /*!< SCT OUT12_CLR: CLR3 Position            */
#define SCT_OUT12_CLR_CLR3_Msk                (0x01UL << SCT_OUT12_CLR_CLR3_Pos)                      /*!< SCT OUT12_CLR: CLR3 Mask                */
#define SCT_OUT12_CLR_CLR4_Pos                4                                                       /*!< SCT OUT12_CLR: CLR4 Position            */
#define SCT_OUT12_CLR_CLR4_Msk                (0x01UL << SCT_OUT12_CLR_CLR4_Pos)                      /*!< SCT OUT12_CLR: CLR4 Mask                */
#define SCT_OUT12_CLR_CLR5_Pos                5                                                       /*!< SCT OUT12_CLR: CLR5 Position            */
#define SCT_OUT12_CLR_CLR5_Msk                (0x01UL << SCT_OUT12_CLR_CLR5_Pos)                      /*!< SCT OUT12_CLR: CLR5 Mask                */
#define SCT_OUT12_CLR_CLR6_Pos                6                                                       /*!< SCT OUT12_CLR: CLR6 Position            */
#define SCT_OUT12_CLR_CLR6_Msk                (0x01UL << SCT_OUT12_CLR_CLR6_Pos)                      /*!< SCT OUT12_CLR: CLR6 Mask                */
#define SCT_OUT12_CLR_CLR7_Pos                7                                                       /*!< SCT OUT12_CLR: CLR7 Position            */
#define SCT_OUT12_CLR_CLR7_Msk                (0x01UL << SCT_OUT12_CLR_CLR7_Pos)                      /*!< SCT OUT12_CLR: CLR7 Mask                */
#define SCT_OUT12_CLR_CLR8_Pos                8                                                       /*!< SCT OUT12_CLR: CLR8 Position            */
#define SCT_OUT12_CLR_CLR8_Msk                (0x01UL << SCT_OUT12_CLR_CLR8_Pos)                      /*!< SCT OUT12_CLR: CLR8 Mask                */
#define SCT_OUT12_CLR_CLR9_Pos                9                                                       /*!< SCT OUT12_CLR: CLR9 Position            */
#define SCT_OUT12_CLR_CLR9_Msk                (0x01UL << SCT_OUT12_CLR_CLR9_Pos)                      /*!< SCT OUT12_CLR: CLR9 Mask                */
#define SCT_OUT12_CLR_CLR10_Pos               10                                                      /*!< SCT OUT12_CLR: CLR10 Position           */
#define SCT_OUT12_CLR_CLR10_Msk               (0x01UL << SCT_OUT12_CLR_CLR10_Pos)                     /*!< SCT OUT12_CLR: CLR10 Mask               */
#define SCT_OUT12_CLR_CLR11_Pos               11                                                      /*!< SCT OUT12_CLR: CLR11 Position           */
#define SCT_OUT12_CLR_CLR11_Msk               (0x01UL << SCT_OUT12_CLR_CLR11_Pos)                     /*!< SCT OUT12_CLR: CLR11 Mask               */
#define SCT_OUT12_CLR_CLR12_Pos               12                                                      /*!< SCT OUT12_CLR: CLR12 Position           */
#define SCT_OUT12_CLR_CLR12_Msk               (0x01UL << SCT_OUT12_CLR_CLR12_Pos)                     /*!< SCT OUT12_CLR: CLR12 Mask               */
#define SCT_OUT12_CLR_CLR13_Pos               13                                                      /*!< SCT OUT12_CLR: CLR13 Position           */
#define SCT_OUT12_CLR_CLR13_Msk               (0x01UL << SCT_OUT12_CLR_CLR13_Pos)                     /*!< SCT OUT12_CLR: CLR13 Mask               */
#define SCT_OUT12_CLR_CLR14_Pos               14                                                      /*!< SCT OUT12_CLR: CLR14 Position           */
#define SCT_OUT12_CLR_CLR14_Msk               (0x01UL << SCT_OUT12_CLR_CLR14_Pos)                     /*!< SCT OUT12_CLR: CLR14 Mask               */
#define SCT_OUT12_CLR_CLR15_Pos               15                                                      /*!< SCT OUT12_CLR: CLR15 Position           */
#define SCT_OUT12_CLR_CLR15_Msk               (0x01UL << SCT_OUT12_CLR_CLR15_Pos)                     /*!< SCT OUT12_CLR: CLR15 Mask               */

/* --------------------------------  SCT_OUT13_SET  ------------------------------- */
#define SCT_OUT13_SET_SET0_Pos                0                                                       /*!< SCT OUT13_SET: SET0 Position            */
#define SCT_OUT13_SET_SET0_Msk                (0x01UL << SCT_OUT13_SET_SET0_Pos)                      /*!< SCT OUT13_SET: SET0 Mask                */
#define SCT_OUT13_SET_SET1_Pos                1                                                       /*!< SCT OUT13_SET: SET1 Position            */
#define SCT_OUT13_SET_SET1_Msk                (0x01UL << SCT_OUT13_SET_SET1_Pos)                      /*!< SCT OUT13_SET: SET1 Mask                */
#define SCT_OUT13_SET_SET2_Pos                2                                                       /*!< SCT OUT13_SET: SET2 Position            */
#define SCT_OUT13_SET_SET2_Msk                (0x01UL << SCT_OUT13_SET_SET2_Pos)                      /*!< SCT OUT13_SET: SET2 Mask                */
#define SCT_OUT13_SET_SET3_Pos                3                                                       /*!< SCT OUT13_SET: SET3 Position            */
#define SCT_OUT13_SET_SET3_Msk                (0x01UL << SCT_OUT13_SET_SET3_Pos)                      /*!< SCT OUT13_SET: SET3 Mask                */
#define SCT_OUT13_SET_SET4_Pos                4                                                       /*!< SCT OUT13_SET: SET4 Position            */
#define SCT_OUT13_SET_SET4_Msk                (0x01UL << SCT_OUT13_SET_SET4_Pos)                      /*!< SCT OUT13_SET: SET4 Mask                */
#define SCT_OUT13_SET_SET5_Pos                5                                                       /*!< SCT OUT13_SET: SET5 Position            */
#define SCT_OUT13_SET_SET5_Msk                (0x01UL << SCT_OUT13_SET_SET5_Pos)                      /*!< SCT OUT13_SET: SET5 Mask                */
#define SCT_OUT13_SET_SET6_Pos                6                                                       /*!< SCT OUT13_SET: SET6 Position            */
#define SCT_OUT13_SET_SET6_Msk                (0x01UL << SCT_OUT13_SET_SET6_Pos)                      /*!< SCT OUT13_SET: SET6 Mask                */
#define SCT_OUT13_SET_SET7_Pos                7                                                       /*!< SCT OUT13_SET: SET7 Position            */
#define SCT_OUT13_SET_SET7_Msk                (0x01UL << SCT_OUT13_SET_SET7_Pos)                      /*!< SCT OUT13_SET: SET7 Mask                */
#define SCT_OUT13_SET_SET8_Pos                8                                                       /*!< SCT OUT13_SET: SET8 Position            */
#define SCT_OUT13_SET_SET8_Msk                (0x01UL << SCT_OUT13_SET_SET8_Pos)                      /*!< SCT OUT13_SET: SET8 Mask                */
#define SCT_OUT13_SET_SET9_Pos                9                                                       /*!< SCT OUT13_SET: SET9 Position            */
#define SCT_OUT13_SET_SET9_Msk                (0x01UL << SCT_OUT13_SET_SET9_Pos)                      /*!< SCT OUT13_SET: SET9 Mask                */
#define SCT_OUT13_SET_SET10_Pos               10                                                      /*!< SCT OUT13_SET: SET10 Position           */
#define SCT_OUT13_SET_SET10_Msk               (0x01UL << SCT_OUT13_SET_SET10_Pos)                     /*!< SCT OUT13_SET: SET10 Mask               */
#define SCT_OUT13_SET_SET11_Pos               11                                                      /*!< SCT OUT13_SET: SET11 Position           */
#define SCT_OUT13_SET_SET11_Msk               (0x01UL << SCT_OUT13_SET_SET11_Pos)                     /*!< SCT OUT13_SET: SET11 Mask               */
#define SCT_OUT13_SET_SET12_Pos               12                                                      /*!< SCT OUT13_SET: SET12 Position           */
#define SCT_OUT13_SET_SET12_Msk               (0x01UL << SCT_OUT13_SET_SET12_Pos)                     /*!< SCT OUT13_SET: SET12 Mask               */
#define SCT_OUT13_SET_SET13_Pos               13                                                      /*!< SCT OUT13_SET: SET13 Position           */
#define SCT_OUT13_SET_SET13_Msk               (0x01UL << SCT_OUT13_SET_SET13_Pos)                     /*!< SCT OUT13_SET: SET13 Mask               */
#define SCT_OUT13_SET_SET14_Pos               14                                                      /*!< SCT OUT13_SET: SET14 Position           */
#define SCT_OUT13_SET_SET14_Msk               (0x01UL << SCT_OUT13_SET_SET14_Pos)                     /*!< SCT OUT13_SET: SET14 Mask               */
#define SCT_OUT13_SET_SET15_Pos               15                                                      /*!< SCT OUT13_SET: SET15 Position           */
#define SCT_OUT13_SET_SET15_Msk               (0x01UL << SCT_OUT13_SET_SET15_Pos)                     /*!< SCT OUT13_SET: SET15 Mask               */

/* --------------------------------  SCT_OUT13_CLR  ------------------------------- */
#define SCT_OUT13_CLR_CLR0_Pos                0                                                       /*!< SCT OUT13_CLR: CLR0 Position            */
#define SCT_OUT13_CLR_CLR0_Msk                (0x01UL << SCT_OUT13_CLR_CLR0_Pos)                      /*!< SCT OUT13_CLR: CLR0 Mask                */
#define SCT_OUT13_CLR_CLR1_Pos                1                                                       /*!< SCT OUT13_CLR: CLR1 Position            */
#define SCT_OUT13_CLR_CLR1_Msk                (0x01UL << SCT_OUT13_CLR_CLR1_Pos)                      /*!< SCT OUT13_CLR: CLR1 Mask                */
#define SCT_OUT13_CLR_CLR2_Pos                2                                                       /*!< SCT OUT13_CLR: CLR2 Position            */
#define SCT_OUT13_CLR_CLR2_Msk                (0x01UL << SCT_OUT13_CLR_CLR2_Pos)                      /*!< SCT OUT13_CLR: CLR2 Mask                */
#define SCT_OUT13_CLR_CLR3_Pos                3                                                       /*!< SCT OUT13_CLR: CLR3 Position            */
#define SCT_OUT13_CLR_CLR3_Msk                (0x01UL << SCT_OUT13_CLR_CLR3_Pos)                      /*!< SCT OUT13_CLR: CLR3 Mask                */
#define SCT_OUT13_CLR_CLR4_Pos                4                                                       /*!< SCT OUT13_CLR: CLR4 Position            */
#define SCT_OUT13_CLR_CLR4_Msk                (0x01UL << SCT_OUT13_CLR_CLR4_Pos)                      /*!< SCT OUT13_CLR: CLR4 Mask                */
#define SCT_OUT13_CLR_CLR5_Pos                5                                                       /*!< SCT OUT13_CLR: CLR5 Position            */
#define SCT_OUT13_CLR_CLR5_Msk                (0x01UL << SCT_OUT13_CLR_CLR5_Pos)                      /*!< SCT OUT13_CLR: CLR5 Mask                */
#define SCT_OUT13_CLR_CLR6_Pos                6                                                       /*!< SCT OUT13_CLR: CLR6 Position            */
#define SCT_OUT13_CLR_CLR6_Msk                (0x01UL << SCT_OUT13_CLR_CLR6_Pos)                      /*!< SCT OUT13_CLR: CLR6 Mask                */
#define SCT_OUT13_CLR_CLR7_Pos                7                                                       /*!< SCT OUT13_CLR: CLR7 Position            */
#define SCT_OUT13_CLR_CLR7_Msk                (0x01UL << SCT_OUT13_CLR_CLR7_Pos)                      /*!< SCT OUT13_CLR: CLR7 Mask                */
#define SCT_OUT13_CLR_CLR8_Pos                8                                                       /*!< SCT OUT13_CLR: CLR8 Position            */
#define SCT_OUT13_CLR_CLR8_Msk                (0x01UL << SCT_OUT13_CLR_CLR8_Pos)                      /*!< SCT OUT13_CLR: CLR8 Mask                */
#define SCT_OUT13_CLR_CLR9_Pos                9                                                       /*!< SCT OUT13_CLR: CLR9 Position            */
#define SCT_OUT13_CLR_CLR9_Msk                (0x01UL << SCT_OUT13_CLR_CLR9_Pos)                      /*!< SCT OUT13_CLR: CLR9 Mask                */
#define SCT_OUT13_CLR_CLR10_Pos               10                                                      /*!< SCT OUT13_CLR: CLR10 Position           */
#define SCT_OUT13_CLR_CLR10_Msk               (0x01UL << SCT_OUT13_CLR_CLR10_Pos)                     /*!< SCT OUT13_CLR: CLR10 Mask               */
#define SCT_OUT13_CLR_CLR11_Pos               11                                                      /*!< SCT OUT13_CLR: CLR11 Position           */
#define SCT_OUT13_CLR_CLR11_Msk               (0x01UL << SCT_OUT13_CLR_CLR11_Pos)                     /*!< SCT OUT13_CLR: CLR11 Mask               */
#define SCT_OUT13_CLR_CLR12_Pos               12                                                      /*!< SCT OUT13_CLR: CLR12 Position           */
#define SCT_OUT13_CLR_CLR12_Msk               (0x01UL << SCT_OUT13_CLR_CLR12_Pos)                     /*!< SCT OUT13_CLR: CLR12 Mask               */
#define SCT_OUT13_CLR_CLR13_Pos               13                                                      /*!< SCT OUT13_CLR: CLR13 Position           */
#define SCT_OUT13_CLR_CLR13_Msk               (0x01UL << SCT_OUT13_CLR_CLR13_Pos)                     /*!< SCT OUT13_CLR: CLR13 Mask               */
#define SCT_OUT13_CLR_CLR14_Pos               14                                                      /*!< SCT OUT13_CLR: CLR14 Position           */
#define SCT_OUT13_CLR_CLR14_Msk               (0x01UL << SCT_OUT13_CLR_CLR14_Pos)                     /*!< SCT OUT13_CLR: CLR14 Mask               */
#define SCT_OUT13_CLR_CLR15_Pos               15                                                      /*!< SCT OUT13_CLR: CLR15 Position           */
#define SCT_OUT13_CLR_CLR15_Msk               (0x01UL << SCT_OUT13_CLR_CLR15_Pos)                     /*!< SCT OUT13_CLR: CLR15 Mask               */

/* --------------------------------  SCT_OUT14_SET  ------------------------------- */
#define SCT_OUT14_SET_SET0_Pos                0                                                       /*!< SCT OUT14_SET: SET0 Position            */
#define SCT_OUT14_SET_SET0_Msk                (0x01UL << SCT_OUT14_SET_SET0_Pos)                      /*!< SCT OUT14_SET: SET0 Mask                */
#define SCT_OUT14_SET_SET1_Pos                1                                                       /*!< SCT OUT14_SET: SET1 Position            */
#define SCT_OUT14_SET_SET1_Msk                (0x01UL << SCT_OUT14_SET_SET1_Pos)                      /*!< SCT OUT14_SET: SET1 Mask                */
#define SCT_OUT14_SET_SET2_Pos                2                                                       /*!< SCT OUT14_SET: SET2 Position            */
#define SCT_OUT14_SET_SET2_Msk                (0x01UL << SCT_OUT14_SET_SET2_Pos)                      /*!< SCT OUT14_SET: SET2 Mask                */
#define SCT_OUT14_SET_SET3_Pos                3                                                       /*!< SCT OUT14_SET: SET3 Position            */
#define SCT_OUT14_SET_SET3_Msk                (0x01UL << SCT_OUT14_SET_SET3_Pos)                      /*!< SCT OUT14_SET: SET3 Mask                */
#define SCT_OUT14_SET_SET4_Pos                4                                                       /*!< SCT OUT14_SET: SET4 Position            */
#define SCT_OUT14_SET_SET4_Msk                (0x01UL << SCT_OUT14_SET_SET4_Pos)                      /*!< SCT OUT14_SET: SET4 Mask                */
#define SCT_OUT14_SET_SET5_Pos                5                                                       /*!< SCT OUT14_SET: SET5 Position            */
#define SCT_OUT14_SET_SET5_Msk                (0x01UL << SCT_OUT14_SET_SET5_Pos)                      /*!< SCT OUT14_SET: SET5 Mask                */
#define SCT_OUT14_SET_SET6_Pos                6                                                       /*!< SCT OUT14_SET: SET6 Position            */
#define SCT_OUT14_SET_SET6_Msk                (0x01UL << SCT_OUT14_SET_SET6_Pos)                      /*!< SCT OUT14_SET: SET6 Mask                */
#define SCT_OUT14_SET_SET7_Pos                7                                                       /*!< SCT OUT14_SET: SET7 Position            */
#define SCT_OUT14_SET_SET7_Msk                (0x01UL << SCT_OUT14_SET_SET7_Pos)                      /*!< SCT OUT14_SET: SET7 Mask                */
#define SCT_OUT14_SET_SET8_Pos                8                                                       /*!< SCT OUT14_SET: SET8 Position            */
#define SCT_OUT14_SET_SET8_Msk                (0x01UL << SCT_OUT14_SET_SET8_Pos)                      /*!< SCT OUT14_SET: SET8 Mask                */
#define SCT_OUT14_SET_SET9_Pos                9                                                       /*!< SCT OUT14_SET: SET9 Position            */
#define SCT_OUT14_SET_SET9_Msk                (0x01UL << SCT_OUT14_SET_SET9_Pos)                      /*!< SCT OUT14_SET: SET9 Mask                */
#define SCT_OUT14_SET_SET10_Pos               10                                                      /*!< SCT OUT14_SET: SET10 Position           */
#define SCT_OUT14_SET_SET10_Msk               (0x01UL << SCT_OUT14_SET_SET10_Pos)                     /*!< SCT OUT14_SET: SET10 Mask               */
#define SCT_OUT14_SET_SET11_Pos               11                                                      /*!< SCT OUT14_SET: SET11 Position           */
#define SCT_OUT14_SET_SET11_Msk               (0x01UL << SCT_OUT14_SET_SET11_Pos)                     /*!< SCT OUT14_SET: SET11 Mask               */
#define SCT_OUT14_SET_SET12_Pos               12                                                      /*!< SCT OUT14_SET: SET12 Position           */
#define SCT_OUT14_SET_SET12_Msk               (0x01UL << SCT_OUT14_SET_SET12_Pos)                     /*!< SCT OUT14_SET: SET12 Mask               */
#define SCT_OUT14_SET_SET13_Pos               13                                                      /*!< SCT OUT14_SET: SET13 Position           */
#define SCT_OUT14_SET_SET13_Msk               (0x01UL << SCT_OUT14_SET_SET13_Pos)                     /*!< SCT OUT14_SET: SET13 Mask               */
#define SCT_OUT14_SET_SET14_Pos               14                                                      /*!< SCT OUT14_SET: SET14 Position           */
#define SCT_OUT14_SET_SET14_Msk               (0x01UL << SCT_OUT14_SET_SET14_Pos)                     /*!< SCT OUT14_SET: SET14 Mask               */
#define SCT_OUT14_SET_SET15_Pos               15                                                      /*!< SCT OUT14_SET: SET15 Position           */
#define SCT_OUT14_SET_SET15_Msk               (0x01UL << SCT_OUT14_SET_SET15_Pos)                     /*!< SCT OUT14_SET: SET15 Mask               */

/* --------------------------------  SCT_OUT14_CLR  ------------------------------- */
#define SCT_OUT14_CLR_CLR0_Pos                0                                                       /*!< SCT OUT14_CLR: CLR0 Position            */
#define SCT_OUT14_CLR_CLR0_Msk                (0x01UL << SCT_OUT14_CLR_CLR0_Pos)                      /*!< SCT OUT14_CLR: CLR0 Mask                */
#define SCT_OUT14_CLR_CLR1_Pos                1                                                       /*!< SCT OUT14_CLR: CLR1 Position            */
#define SCT_OUT14_CLR_CLR1_Msk                (0x01UL << SCT_OUT14_CLR_CLR1_Pos)                      /*!< SCT OUT14_CLR: CLR1 Mask                */
#define SCT_OUT14_CLR_CLR2_Pos                2                                                       /*!< SCT OUT14_CLR: CLR2 Position            */
#define SCT_OUT14_CLR_CLR2_Msk                (0x01UL << SCT_OUT14_CLR_CLR2_Pos)                      /*!< SCT OUT14_CLR: CLR2 Mask                */
#define SCT_OUT14_CLR_CLR3_Pos                3                                                       /*!< SCT OUT14_CLR: CLR3 Position            */
#define SCT_OUT14_CLR_CLR3_Msk                (0x01UL << SCT_OUT14_CLR_CLR3_Pos)                      /*!< SCT OUT14_CLR: CLR3 Mask                */
#define SCT_OUT14_CLR_CLR4_Pos                4                                                       /*!< SCT OUT14_CLR: CLR4 Position            */
#define SCT_OUT14_CLR_CLR4_Msk                (0x01UL << SCT_OUT14_CLR_CLR4_Pos)                      /*!< SCT OUT14_CLR: CLR4 Mask                */
#define SCT_OUT14_CLR_CLR5_Pos                5                                                       /*!< SCT OUT14_CLR: CLR5 Position            */
#define SCT_OUT14_CLR_CLR5_Msk                (0x01UL << SCT_OUT14_CLR_CLR5_Pos)                      /*!< SCT OUT14_CLR: CLR5 Mask                */
#define SCT_OUT14_CLR_CLR6_Pos                6                                                       /*!< SCT OUT14_CLR: CLR6 Position            */
#define SCT_OUT14_CLR_CLR6_Msk                (0x01UL << SCT_OUT14_CLR_CLR6_Pos)                      /*!< SCT OUT14_CLR: CLR6 Mask                */
#define SCT_OUT14_CLR_CLR7_Pos                7                                                       /*!< SCT OUT14_CLR: CLR7 Position            */
#define SCT_OUT14_CLR_CLR7_Msk                (0x01UL << SCT_OUT14_CLR_CLR7_Pos)                      /*!< SCT OUT14_CLR: CLR7 Mask                */
#define SCT_OUT14_CLR_CLR8_Pos                8                                                       /*!< SCT OUT14_CLR: CLR8 Position            */
#define SCT_OUT14_CLR_CLR8_Msk                (0x01UL << SCT_OUT14_CLR_CLR8_Pos)                      /*!< SCT OUT14_CLR: CLR8 Mask                */
#define SCT_OUT14_CLR_CLR9_Pos                9                                                       /*!< SCT OUT14_CLR: CLR9 Position            */
#define SCT_OUT14_CLR_CLR9_Msk                (0x01UL << SCT_OUT14_CLR_CLR9_Pos)                      /*!< SCT OUT14_CLR: CLR9 Mask                */
#define SCT_OUT14_CLR_CLR10_Pos               10                                                      /*!< SCT OUT14_CLR: CLR10 Position           */
#define SCT_OUT14_CLR_CLR10_Msk               (0x01UL << SCT_OUT14_CLR_CLR10_Pos)                     /*!< SCT OUT14_CLR: CLR10 Mask               */
#define SCT_OUT14_CLR_CLR11_Pos               11                                                      /*!< SCT OUT14_CLR: CLR11 Position           */
#define SCT_OUT14_CLR_CLR11_Msk               (0x01UL << SCT_OUT14_CLR_CLR11_Pos)                     /*!< SCT OUT14_CLR: CLR11 Mask               */
#define SCT_OUT14_CLR_CLR12_Pos               12                                                      /*!< SCT OUT14_CLR: CLR12 Position           */
#define SCT_OUT14_CLR_CLR12_Msk               (0x01UL << SCT_OUT14_CLR_CLR12_Pos)                     /*!< SCT OUT14_CLR: CLR12 Mask               */
#define SCT_OUT14_CLR_CLR13_Pos               13                                                      /*!< SCT OUT14_CLR: CLR13 Position           */
#define SCT_OUT14_CLR_CLR13_Msk               (0x01UL << SCT_OUT14_CLR_CLR13_Pos)                     /*!< SCT OUT14_CLR: CLR13 Mask               */
#define SCT_OUT14_CLR_CLR14_Pos               14                                                      /*!< SCT OUT14_CLR: CLR14 Position           */
#define SCT_OUT14_CLR_CLR14_Msk               (0x01UL << SCT_OUT14_CLR_CLR14_Pos)                     /*!< SCT OUT14_CLR: CLR14 Mask               */
#define SCT_OUT14_CLR_CLR15_Pos               15                                                      /*!< SCT OUT14_CLR: CLR15 Position           */
#define SCT_OUT14_CLR_CLR15_Msk               (0x01UL << SCT_OUT14_CLR_CLR15_Pos)                     /*!< SCT OUT14_CLR: CLR15 Mask               */

/* --------------------------------  SCT_OUT15_SET  ------------------------------- */
#define SCT_OUT15_SET_SET0_Pos                0                                                       /*!< SCT OUT15_SET: SET0 Position            */
#define SCT_OUT15_SET_SET0_Msk                (0x01UL << SCT_OUT15_SET_SET0_Pos)                      /*!< SCT OUT15_SET: SET0 Mask                */
#define SCT_OUT15_SET_SET1_Pos                1                                                       /*!< SCT OUT15_SET: SET1 Position            */
#define SCT_OUT15_SET_SET1_Msk                (0x01UL << SCT_OUT15_SET_SET1_Pos)                      /*!< SCT OUT15_SET: SET1 Mask                */
#define SCT_OUT15_SET_SET2_Pos                2                                                       /*!< SCT OUT15_SET: SET2 Position            */
#define SCT_OUT15_SET_SET2_Msk                (0x01UL << SCT_OUT15_SET_SET2_Pos)                      /*!< SCT OUT15_SET: SET2 Mask                */
#define SCT_OUT15_SET_SET3_Pos                3                                                       /*!< SCT OUT15_SET: SET3 Position            */
#define SCT_OUT15_SET_SET3_Msk                (0x01UL << SCT_OUT15_SET_SET3_Pos)                      /*!< SCT OUT15_SET: SET3 Mask                */
#define SCT_OUT15_SET_SET4_Pos                4                                                       /*!< SCT OUT15_SET: SET4 Position            */
#define SCT_OUT15_SET_SET4_Msk                (0x01UL << SCT_OUT15_SET_SET4_Pos)                      /*!< SCT OUT15_SET: SET4 Mask                */
#define SCT_OUT15_SET_SET5_Pos                5                                                       /*!< SCT OUT15_SET: SET5 Position            */
#define SCT_OUT15_SET_SET5_Msk                (0x01UL << SCT_OUT15_SET_SET5_Pos)                      /*!< SCT OUT15_SET: SET5 Mask                */
#define SCT_OUT15_SET_SET6_Pos                6                                                       /*!< SCT OUT15_SET: SET6 Position            */
#define SCT_OUT15_SET_SET6_Msk                (0x01UL << SCT_OUT15_SET_SET6_Pos)                      /*!< SCT OUT15_SET: SET6 Mask                */
#define SCT_OUT15_SET_SET7_Pos                7                                                       /*!< SCT OUT15_SET: SET7 Position            */
#define SCT_OUT15_SET_SET7_Msk                (0x01UL << SCT_OUT15_SET_SET7_Pos)                      /*!< SCT OUT15_SET: SET7 Mask                */
#define SCT_OUT15_SET_SET8_Pos                8                                                       /*!< SCT OUT15_SET: SET8 Position            */
#define SCT_OUT15_SET_SET8_Msk                (0x01UL << SCT_OUT15_SET_SET8_Pos)                      /*!< SCT OUT15_SET: SET8 Mask                */
#define SCT_OUT15_SET_SET9_Pos                9                                                       /*!< SCT OUT15_SET: SET9 Position            */
#define SCT_OUT15_SET_SET9_Msk                (0x01UL << SCT_OUT15_SET_SET9_Pos)                      /*!< SCT OUT15_SET: SET9 Mask                */
#define SCT_OUT15_SET_SET10_Pos               10                                                      /*!< SCT OUT15_SET: SET10 Position           */
#define SCT_OUT15_SET_SET10_Msk               (0x01UL << SCT_OUT15_SET_SET10_Pos)                     /*!< SCT OUT15_SET: SET10 Mask               */
#define SCT_OUT15_SET_SET11_Pos               11                                                      /*!< SCT OUT15_SET: SET11 Position           */
#define SCT_OUT15_SET_SET11_Msk               (0x01UL << SCT_OUT15_SET_SET11_Pos)                     /*!< SCT OUT15_SET: SET11 Mask               */
#define SCT_OUT15_SET_SET12_Pos               12                                                      /*!< SCT OUT15_SET: SET12 Position           */
#define SCT_OUT15_SET_SET12_Msk               (0x01UL << SCT_OUT15_SET_SET12_Pos)                     /*!< SCT OUT15_SET: SET12 Mask               */
#define SCT_OUT15_SET_SET13_Pos               13                                                      /*!< SCT OUT15_SET: SET13 Position           */
#define SCT_OUT15_SET_SET13_Msk               (0x01UL << SCT_OUT15_SET_SET13_Pos)                     /*!< SCT OUT15_SET: SET13 Mask               */
#define SCT_OUT15_SET_SET14_Pos               14                                                      /*!< SCT OUT15_SET: SET14 Position           */
#define SCT_OUT15_SET_SET14_Msk               (0x01UL << SCT_OUT15_SET_SET14_Pos)                     /*!< SCT OUT15_SET: SET14 Mask               */
#define SCT_OUT15_SET_SET15_Pos               15                                                      /*!< SCT OUT15_SET: SET15 Position           */
#define SCT_OUT15_SET_SET15_Msk               (0x01UL << SCT_OUT15_SET_SET15_Pos)                     /*!< SCT OUT15_SET: SET15 Mask               */

/* --------------------------------  SCT_OUT15_CLR  ------------------------------- */
#define SCT_OUT15_CLR_CLR0_Pos                0                                                       /*!< SCT OUT15_CLR: CLR0 Position            */
#define SCT_OUT15_CLR_CLR0_Msk                (0x01UL << SCT_OUT15_CLR_CLR0_Pos)                      /*!< SCT OUT15_CLR: CLR0 Mask                */
#define SCT_OUT15_CLR_CLR1_Pos                1                                                       /*!< SCT OUT15_CLR: CLR1 Position            */
#define SCT_OUT15_CLR_CLR1_Msk                (0x01UL << SCT_OUT15_CLR_CLR1_Pos)                      /*!< SCT OUT15_CLR: CLR1 Mask                */
#define SCT_OUT15_CLR_CLR2_Pos                2                                                       /*!< SCT OUT15_CLR: CLR2 Position            */
#define SCT_OUT15_CLR_CLR2_Msk                (0x01UL << SCT_OUT15_CLR_CLR2_Pos)                      /*!< SCT OUT15_CLR: CLR2 Mask                */
#define SCT_OUT15_CLR_CLR3_Pos                3                                                       /*!< SCT OUT15_CLR: CLR3 Position            */
#define SCT_OUT15_CLR_CLR3_Msk                (0x01UL << SCT_OUT15_CLR_CLR3_Pos)                      /*!< SCT OUT15_CLR: CLR3 Mask                */
#define SCT_OUT15_CLR_CLR4_Pos                4                                                       /*!< SCT OUT15_CLR: CLR4 Position            */
#define SCT_OUT15_CLR_CLR4_Msk                (0x01UL << SCT_OUT15_CLR_CLR4_Pos)                      /*!< SCT OUT15_CLR: CLR4 Mask                */
#define SCT_OUT15_CLR_CLR5_Pos                5                                                       /*!< SCT OUT15_CLR: CLR5 Position            */
#define SCT_OUT15_CLR_CLR5_Msk                (0x01UL << SCT_OUT15_CLR_CLR5_Pos)                      /*!< SCT OUT15_CLR: CLR5 Mask                */
#define SCT_OUT15_CLR_CLR6_Pos                6                                                       /*!< SCT OUT15_CLR: CLR6 Position            */
#define SCT_OUT15_CLR_CLR6_Msk                (0x01UL << SCT_OUT15_CLR_CLR6_Pos)                      /*!< SCT OUT15_CLR: CLR6 Mask                */
#define SCT_OUT15_CLR_CLR7_Pos                7                                                       /*!< SCT OUT15_CLR: CLR7 Position            */
#define SCT_OUT15_CLR_CLR7_Msk                (0x01UL << SCT_OUT15_CLR_CLR7_Pos)                      /*!< SCT OUT15_CLR: CLR7 Mask                */
#define SCT_OUT15_CLR_CLR8_Pos                8                                                       /*!< SCT OUT15_CLR: CLR8 Position            */
#define SCT_OUT15_CLR_CLR8_Msk                (0x01UL << SCT_OUT15_CLR_CLR8_Pos)                      /*!< SCT OUT15_CLR: CLR8 Mask                */
#define SCT_OUT15_CLR_CLR9_Pos                9                                                       /*!< SCT OUT15_CLR: CLR9 Position            */
#define SCT_OUT15_CLR_CLR9_Msk                (0x01UL << SCT_OUT15_CLR_CLR9_Pos)                      /*!< SCT OUT15_CLR: CLR9 Mask                */
#define SCT_OUT15_CLR_CLR10_Pos               10                                                      /*!< SCT OUT15_CLR: CLR10 Position           */
#define SCT_OUT15_CLR_CLR10_Msk               (0x01UL << SCT_OUT15_CLR_CLR10_Pos)                     /*!< SCT OUT15_CLR: CLR10 Mask               */
#define SCT_OUT15_CLR_CLR11_Pos               11                                                      /*!< SCT OUT15_CLR: CLR11 Position           */
#define SCT_OUT15_CLR_CLR11_Msk               (0x01UL << SCT_OUT15_CLR_CLR11_Pos)                     /*!< SCT OUT15_CLR: CLR11 Mask               */
#define SCT_OUT15_CLR_CLR12_Pos               12                                                      /*!< SCT OUT15_CLR: CLR12 Position           */
#define SCT_OUT15_CLR_CLR12_Msk               (0x01UL << SCT_OUT15_CLR_CLR12_Pos)                     /*!< SCT OUT15_CLR: CLR12 Mask               */
#define SCT_OUT15_CLR_CLR13_Pos               13                                                      /*!< SCT OUT15_CLR: CLR13 Position           */
#define SCT_OUT15_CLR_CLR13_Msk               (0x01UL << SCT_OUT15_CLR_CLR13_Pos)                     /*!< SCT OUT15_CLR: CLR13 Mask               */
#define SCT_OUT15_CLR_CLR14_Pos               14                                                      /*!< SCT OUT15_CLR: CLR14 Position           */
#define SCT_OUT15_CLR_CLR14_Msk               (0x01UL << SCT_OUT15_CLR_CLR14_Pos)                     /*!< SCT OUT15_CLR: CLR14 Mask               */
#define SCT_OUT15_CLR_CLR15_Pos               15                                                      /*!< SCT OUT15_CLR: CLR15 Position           */
#define SCT_OUT15_CLR_CLR15_Msk               (0x01UL << SCT_OUT15_CLR_CLR15_Pos)                     /*!< SCT OUT15_CLR: CLR15 Mask               */


/* ================================================================================ */
/* ================         struct 'GPDMA' Position & Mask         ================ */
/* ================================================================================ */


/* --------------------------------  GPDMA_INTSTAT  ------------------------------- */
#define GPDMA_INTSTAT_INTSTAT0_Pos            0                                                       /*!< GPDMA INTSTAT: INTSTAT0 Position        */
#define GPDMA_INTSTAT_INTSTAT0_Msk            (0x01UL << GPDMA_INTSTAT_INTSTAT0_Pos)                  /*!< GPDMA INTSTAT: INTSTAT0 Mask            */
#define GPDMA_INTSTAT_INTSTAT1_Pos            1                                                       /*!< GPDMA INTSTAT: INTSTAT1 Position        */
#define GPDMA_INTSTAT_INTSTAT1_Msk            (0x01UL << GPDMA_INTSTAT_INTSTAT1_Pos)                  /*!< GPDMA INTSTAT: INTSTAT1 Mask            */
#define GPDMA_INTSTAT_INTSTAT2_Pos            2                                                       /*!< GPDMA INTSTAT: INTSTAT2 Position        */
#define GPDMA_INTSTAT_INTSTAT2_Msk            (0x01UL << GPDMA_INTSTAT_INTSTAT2_Pos)                  /*!< GPDMA INTSTAT: INTSTAT2 Mask            */
#define GPDMA_INTSTAT_INTSTAT3_Pos            3                                                       /*!< GPDMA INTSTAT: INTSTAT3 Position        */
#define GPDMA_INTSTAT_INTSTAT3_Msk            (0x01UL << GPDMA_INTSTAT_INTSTAT3_Pos)                  /*!< GPDMA INTSTAT: INTSTAT3 Mask            */
#define GPDMA_INTSTAT_INTSTAT4_Pos            4                                                       /*!< GPDMA INTSTAT: INTSTAT4 Position        */
#define GPDMA_INTSTAT_INTSTAT4_Msk            (0x01UL << GPDMA_INTSTAT_INTSTAT4_Pos)                  /*!< GPDMA INTSTAT: INTSTAT4 Mask            */
#define GPDMA_INTSTAT_INTSTAT5_Pos            5                                                       /*!< GPDMA INTSTAT: INTSTAT5 Position        */
#define GPDMA_INTSTAT_INTSTAT5_Msk            (0x01UL << GPDMA_INTSTAT_INTSTAT5_Pos)                  /*!< GPDMA INTSTAT: INTSTAT5 Mask            */
#define GPDMA_INTSTAT_INTSTAT6_Pos            6                                                       /*!< GPDMA INTSTAT: INTSTAT6 Position        */
#define GPDMA_INTSTAT_INTSTAT6_Msk            (0x01UL << GPDMA_INTSTAT_INTSTAT6_Pos)                  /*!< GPDMA INTSTAT: INTSTAT6 Mask            */
#define GPDMA_INTSTAT_INTSTAT7_Pos            7                                                       /*!< GPDMA INTSTAT: INTSTAT7 Position        */
#define GPDMA_INTSTAT_INTSTAT7_Msk            (0x01UL << GPDMA_INTSTAT_INTSTAT7_Pos)                  /*!< GPDMA INTSTAT: INTSTAT7 Mask            */

/* -------------------------------  GPDMA_INTTCSTAT  ------------------------------ */
#define GPDMA_INTTCSTAT_INTTCSTAT0_Pos        0                                                       /*!< GPDMA INTTCSTAT: INTTCSTAT0 Position    */
#define GPDMA_INTTCSTAT_INTTCSTAT0_Msk        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT0_Pos)              /*!< GPDMA INTTCSTAT: INTTCSTAT0 Mask        */
#define GPDMA_INTTCSTAT_INTTCSTAT1_Pos        1                                                       /*!< GPDMA INTTCSTAT: INTTCSTAT1 Position    */
#define GPDMA_INTTCSTAT_INTTCSTAT1_Msk        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT1_Pos)              /*!< GPDMA INTTCSTAT: INTTCSTAT1 Mask        */
#define GPDMA_INTTCSTAT_INTTCSTAT2_Pos        2                                                       /*!< GPDMA INTTCSTAT: INTTCSTAT2 Position    */
#define GPDMA_INTTCSTAT_INTTCSTAT2_Msk        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT2_Pos)              /*!< GPDMA INTTCSTAT: INTTCSTAT2 Mask        */
#define GPDMA_INTTCSTAT_INTTCSTAT3_Pos        3                                                       /*!< GPDMA INTTCSTAT: INTTCSTAT3 Position    */
#define GPDMA_INTTCSTAT_INTTCSTAT3_Msk        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT3_Pos)              /*!< GPDMA INTTCSTAT: INTTCSTAT3 Mask        */
#define GPDMA_INTTCSTAT_INTTCSTAT4_Pos        4                                                       /*!< GPDMA INTTCSTAT: INTTCSTAT4 Position    */
#define GPDMA_INTTCSTAT_INTTCSTAT4_Msk        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT4_Pos)              /*!< GPDMA INTTCSTAT: INTTCSTAT4 Mask        */
#define GPDMA_INTTCSTAT_INTTCSTAT5_Pos        5                                                       /*!< GPDMA INTTCSTAT: INTTCSTAT5 Position    */
#define GPDMA_INTTCSTAT_INTTCSTAT5_Msk        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT5_Pos)              /*!< GPDMA INTTCSTAT: INTTCSTAT5 Mask        */
#define GPDMA_INTTCSTAT_INTTCSTAT6_Pos        6                                                       /*!< GPDMA INTTCSTAT: INTTCSTAT6 Position    */
#define GPDMA_INTTCSTAT_INTTCSTAT6_Msk        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT6_Pos)              /*!< GPDMA INTTCSTAT: INTTCSTAT6 Mask        */
#define GPDMA_INTTCSTAT_INTTCSTAT7_Pos        7                                                       /*!< GPDMA INTTCSTAT: INTTCSTAT7 Position    */
#define GPDMA_INTTCSTAT_INTTCSTAT7_Msk        (0x01UL << GPDMA_INTTCSTAT_INTTCSTAT7_Pos)              /*!< GPDMA INTTCSTAT: INTTCSTAT7 Mask        */

/* ------------------------------  GPDMA_INTTCCLEAR  ------------------------------ */
#define GPDMA_INTTCCLEAR_INTTCCLEAR0_Pos      0                                                       /*!< GPDMA INTTCCLEAR: INTTCCLEAR0 Position  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR0_Msk      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR0_Pos)            /*!< GPDMA INTTCCLEAR: INTTCCLEAR0 Mask      */
#define GPDMA_INTTCCLEAR_INTTCCLEAR1_Pos      1                                                       /*!< GPDMA INTTCCLEAR: INTTCCLEAR1 Position  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR1_Msk      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR1_Pos)            /*!< GPDMA INTTCCLEAR: INTTCCLEAR1 Mask      */
#define GPDMA_INTTCCLEAR_INTTCCLEAR2_Pos      2                                                       /*!< GPDMA INTTCCLEAR: INTTCCLEAR2 Position  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR2_Msk      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR2_Pos)            /*!< GPDMA INTTCCLEAR: INTTCCLEAR2 Mask      */
#define GPDMA_INTTCCLEAR_INTTCCLEAR3_Pos      3                                                       /*!< GPDMA INTTCCLEAR: INTTCCLEAR3 Position  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR3_Msk      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR3_Pos)            /*!< GPDMA INTTCCLEAR: INTTCCLEAR3 Mask      */
#define GPDMA_INTTCCLEAR_INTTCCLEAR4_Pos      4                                                       /*!< GPDMA INTTCCLEAR: INTTCCLEAR4 Position  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR4_Msk      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR4_Pos)            /*!< GPDMA INTTCCLEAR: INTTCCLEAR4 Mask      */
#define GPDMA_INTTCCLEAR_INTTCCLEAR5_Pos      5                                                       /*!< GPDMA INTTCCLEAR: INTTCCLEAR5 Position  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR5_Msk      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR5_Pos)            /*!< GPDMA INTTCCLEAR: INTTCCLEAR5 Mask      */
#define GPDMA_INTTCCLEAR_INTTCCLEAR6_Pos      6                                                       /*!< GPDMA INTTCCLEAR: INTTCCLEAR6 Position  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR6_Msk      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR6_Pos)            /*!< GPDMA INTTCCLEAR: INTTCCLEAR6 Mask      */
#define GPDMA_INTTCCLEAR_INTTCCLEAR7_Pos      7                                                       /*!< GPDMA INTTCCLEAR: INTTCCLEAR7 Position  */
#define GPDMA_INTTCCLEAR_INTTCCLEAR7_Msk      (0x01UL << GPDMA_INTTCCLEAR_INTTCCLEAR7_Pos)            /*!< GPDMA INTTCCLEAR: INTTCCLEAR7 Mask      */

/* ------------------------------  GPDMA_INTERRSTAT  ------------------------------ */
#define GPDMA_INTERRSTAT_INTERRSTAT0_Pos      0                                                       /*!< GPDMA INTERRSTAT: INTERRSTAT0 Position  */
#define GPDMA_INTERRSTAT_INTERRSTAT0_Msk      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT0_Pos)            /*!< GPDMA INTERRSTAT: INTERRSTAT0 Mask      */
#define GPDMA_INTERRSTAT_INTERRSTAT1_Pos      1                                                       /*!< GPDMA INTERRSTAT: INTERRSTAT1 Position  */
#define GPDMA_INTERRSTAT_INTERRSTAT1_Msk      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT1_Pos)            /*!< GPDMA INTERRSTAT: INTERRSTAT1 Mask      */
#define GPDMA_INTERRSTAT_INTERRSTAT2_Pos      2                                                       /*!< GPDMA INTERRSTAT: INTERRSTAT2 Position  */
#define GPDMA_INTERRSTAT_INTERRSTAT2_Msk      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT2_Pos)            /*!< GPDMA INTERRSTAT: INTERRSTAT2 Mask      */
#define GPDMA_INTERRSTAT_INTERRSTAT3_Pos      3                                                       /*!< GPDMA INTERRSTAT: INTERRSTAT3 Position  */
#define GPDMA_INTERRSTAT_INTERRSTAT3_Msk      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT3_Pos)            /*!< GPDMA INTERRSTAT: INTERRSTAT3 Mask      */
#define GPDMA_INTERRSTAT_INTERRSTAT4_Pos      4                                                       /*!< GPDMA INTERRSTAT: INTERRSTAT4 Position  */
#define GPDMA_INTERRSTAT_INTERRSTAT4_Msk      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT4_Pos)            /*!< GPDMA INTERRSTAT: INTERRSTAT4 Mask      */
#define GPDMA_INTERRSTAT_INTERRSTAT5_Pos      5                                                       /*!< GPDMA INTERRSTAT: INTERRSTAT5 Position  */
#define GPDMA_INTERRSTAT_INTERRSTAT5_Msk      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT5_Pos)            /*!< GPDMA INTERRSTAT: INTERRSTAT5 Mask      */
#define GPDMA_INTERRSTAT_INTERRSTAT6_Pos      6                                                       /*!< GPDMA INTERRSTAT: INTERRSTAT6 Position  */
#define GPDMA_INTERRSTAT_INTERRSTAT6_Msk      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT6_Pos)            /*!< GPDMA INTERRSTAT: INTERRSTAT6 Mask      */
#define GPDMA_INTERRSTAT_INTERRSTAT7_Pos      7                                                       /*!< GPDMA INTERRSTAT: INTERRSTAT7 Position  */
#define GPDMA_INTERRSTAT_INTERRSTAT7_Msk      (0x01UL << GPDMA_INTERRSTAT_INTERRSTAT7_Pos)            /*!< GPDMA INTERRSTAT: INTERRSTAT7 Mask      */

/* -------------------------------  GPDMA_INTERRCLR  ------------------------------ */
#define GPDMA_INTERRCLR_INTERRCLR0_Pos        0                                                       /*!< GPDMA INTERRCLR: INTERRCLR0 Position    */
#define GPDMA_INTERRCLR_INTERRCLR0_Msk        (0x01UL << GPDMA_INTERRCLR_INTERRCLR0_Pos)              /*!< GPDMA INTERRCLR: INTERRCLR0 Mask        */
#define GPDMA_INTERRCLR_INTERRCLR1_Pos        1                                                       /*!< GPDMA INTERRCLR: INTERRCLR1 Position    */
#define GPDMA_INTERRCLR_INTERRCLR1_Msk        (0x01UL << GPDMA_INTERRCLR_INTERRCLR1_Pos)              /*!< GPDMA INTERRCLR: INTERRCLR1 Mask        */
#define GPDMA_INTERRCLR_INTERRCLR2_Pos        2                                                       /*!< GPDMA INTERRCLR: INTERRCLR2 Position    */
#define GPDMA_INTERRCLR_INTERRCLR2_Msk        (0x01UL << GPDMA_INTERRCLR_INTERRCLR2_Pos)              /*!< GPDMA INTERRCLR: INTERRCLR2 Mask        */
#define GPDMA_INTERRCLR_INTERRCLR3_Pos        3                                                       /*!< GPDMA INTERRCLR: INTERRCLR3 Position    */
#define GPDMA_INTERRCLR_INTERRCLR3_Msk        (0x01UL << GPDMA_INTERRCLR_INTERRCLR3_Pos)              /*!< GPDMA INTERRCLR: INTERRCLR3 Mask        */
#define GPDMA_INTERRCLR_INTERRCLR4_Pos        4                                                       /*!< GPDMA INTERRCLR: INTERRCLR4 Position    */
#define GPDMA_INTERRCLR_INTERRCLR4_Msk        (0x01UL << GPDMA_INTERRCLR_INTERRCLR4_Pos)              /*!< GPDMA INTERRCLR: INTERRCLR4 Mask        */
#define GPDMA_INTERRCLR_INTERRCLR5_Pos        5                                                       /*!< GPDMA INTERRCLR: INTERRCLR5 Position    */
#define GPDMA_INTERRCLR_INTERRCLR5_Msk        (0x01UL << GPDMA_INTERRCLR_INTERRCLR5_Pos)              /*!< GPDMA INTERRCLR: INTERRCLR5 Mask        */
#define GPDMA_INTERRCLR_INTERRCLR6_Pos        6                                                       /*!< GPDMA INTERRCLR: INTERRCLR6 Position    */
#define GPDMA_INTERRCLR_INTERRCLR6_Msk        (0x01UL << GPDMA_INTERRCLR_INTERRCLR6_Pos)              /*!< GPDMA INTERRCLR: INTERRCLR6 Mask        */
#define GPDMA_INTERRCLR_INTERRCLR7_Pos        7                                                       /*!< GPDMA INTERRCLR: INTERRCLR7 Position    */
#define GPDMA_INTERRCLR_INTERRCLR7_Msk        (0x01UL << GPDMA_INTERRCLR_INTERRCLR7_Pos)              /*!< GPDMA INTERRCLR: INTERRCLR7 Mask        */

/* -----------------------------  GPDMA_RAWINTTCSTAT  ----------------------------- */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Pos  0                                                       /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT0 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Msk  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT0_Pos)        /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT0 Mask  */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Pos  1                                                       /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT1 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Msk  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT1_Pos)        /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT1 Mask  */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Pos  2                                                       /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT2 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Msk  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT2_Pos)        /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT2 Mask  */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Pos  3                                                       /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT3 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Msk  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT3_Pos)        /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT3 Mask  */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Pos  4                                                       /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT4 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Msk  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT4_Pos)        /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT4 Mask  */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Pos  5                                                       /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT5 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Msk  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT5_Pos)        /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT5 Mask  */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Pos  6                                                       /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT6 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Msk  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT6_Pos)        /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT6 Mask  */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Pos  7                                                       /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT7 Position */
#define GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Msk  (0x01UL << GPDMA_RAWINTTCSTAT_RAWINTTCSTAT7_Pos)        /*!< GPDMA RAWINTTCSTAT: RAWINTTCSTAT7 Mask  */

/* -----------------------------  GPDMA_RAWINTERRSTAT  ---------------------------- */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Pos 0                                                      /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT0 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Msk (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT0_Pos)     /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT0 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Pos 1                                                      /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT1 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Msk (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT1_Pos)     /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT1 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Pos 2                                                      /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT2 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Msk (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT2_Pos)     /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT2 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Pos 3                                                      /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT3 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Msk (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT3_Pos)     /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT3 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Pos 4                                                      /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT4 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Msk (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT4_Pos)     /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT4 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Pos 5                                                      /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT5 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Msk (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT5_Pos)     /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT5 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Pos 6                                                      /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT6 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Msk (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT6_Pos)     /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT6 Mask */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Pos 7                                                      /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT7 Position */
#define GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Msk (0x01UL << GPDMA_RAWINTERRSTAT_RAWINTERRSTAT7_Pos)     /*!< GPDMA RAWINTERRSTAT: RAWINTERRSTAT7 Mask */

/* -------------------------------  GPDMA_ENBLDCHNS  ------------------------------ */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Pos  0                                                       /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS0 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Msk  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS0_Pos)        /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS0 Mask  */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Pos  1                                                       /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS1 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Msk  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS1_Pos)        /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS1 Mask  */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Pos  2                                                       /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS2 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Msk  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS2_Pos)        /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS2 Mask  */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Pos  3                                                       /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS3 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Msk  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS3_Pos)        /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS3 Mask  */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Pos  4                                                       /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS4 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Msk  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS4_Pos)        /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS4 Mask  */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Pos  5                                                       /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS5 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Msk  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS5_Pos)        /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS5 Mask  */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Pos  6                                                       /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS6 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Msk  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS6_Pos)        /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS6 Mask  */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Pos  7                                                       /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS7 Position */
#define GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Msk  (0x01UL << GPDMA_ENBLDCHNS_ENABLEDCHANNELS7_Pos)        /*!< GPDMA ENBLDCHNS: ENABLEDCHANNELS7 Mask  */

/* -------------------------------  GPDMA_SOFTBREQ  ------------------------------- */
#define GPDMA_SOFTBREQ_SOFTBREQ0_Pos          0                                                       /*!< GPDMA SOFTBREQ: SOFTBREQ0 Position      */
#define GPDMA_SOFTBREQ_SOFTBREQ0_Msk          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ0_Pos)                /*!< GPDMA SOFTBREQ: SOFTBREQ0 Mask          */
#define GPDMA_SOFTBREQ_SOFTBREQ1_Pos          1                                                       /*!< GPDMA SOFTBREQ: SOFTBREQ1 Position      */
#define GPDMA_SOFTBREQ_SOFTBREQ1_Msk          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ1_Pos)                /*!< GPDMA SOFTBREQ: SOFTBREQ1 Mask          */
#define GPDMA_SOFTBREQ_SOFTBREQ2_Pos          2                                                       /*!< GPDMA SOFTBREQ: SOFTBREQ2 Position      */
#define GPDMA_SOFTBREQ_SOFTBREQ2_Msk          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ2_Pos)                /*!< GPDMA SOFTBREQ: SOFTBREQ2 Mask          */
#define GPDMA_SOFTBREQ_SOFTBREQ3_Pos          3                                                       /*!< GPDMA SOFTBREQ: SOFTBREQ3 Position      */
#define GPDMA_SOFTBREQ_SOFTBREQ3_Msk          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ3_Pos)                /*!< GPDMA SOFTBREQ: SOFTBREQ3 Mask          */
#define GPDMA_SOFTBREQ_SOFTBREQ4_Pos          4                                                       /*!< GPDMA SOFTBREQ: SOFTBREQ4 Position      */
#define GPDMA_SOFTBREQ_SOFTBREQ4_Msk          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ4_Pos)                /*!< GPDMA SOFTBREQ: SOFTBREQ4 Mask          */
#define GPDMA_SOFTBREQ_SOFTBREQ5_Pos          5                                                       /*!< GPDMA SOFTBREQ: SOFTBREQ5 Position      */
#define GPDMA_SOFTBREQ_SOFTBREQ5_Msk          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ5_Pos)                /*!< GPDMA SOFTBREQ: SOFTBREQ5 Mask          */
#define GPDMA_SOFTBREQ_SOFTBREQ6_Pos          6                                                       /*!< GPDMA SOFTBREQ: SOFTBREQ6 Position      */
#define GPDMA_SOFTBREQ_SOFTBREQ6_Msk          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ6_Pos)                /*!< GPDMA SOFTBREQ: SOFTBREQ6 Mask          */
#define GPDMA_SOFTBREQ_SOFTBREQ7_Pos          7                                                       /*!< GPDMA SOFTBREQ: SOFTBREQ7 Position      */
#define GPDMA_SOFTBREQ_SOFTBREQ7_Msk          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ7_Pos)                /*!< GPDMA SOFTBREQ: SOFTBREQ7 Mask          */
#define GPDMA_SOFTBREQ_SOFTBREQ8_Pos          8                                                       /*!< GPDMA SOFTBREQ: SOFTBREQ8 Position      */
#define GPDMA_SOFTBREQ_SOFTBREQ8_Msk          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ8_Pos)                /*!< GPDMA SOFTBREQ: SOFTBREQ8 Mask          */
#define GPDMA_SOFTBREQ_SOFTBREQ9_Pos          9                                                       /*!< GPDMA SOFTBREQ: SOFTBREQ9 Position      */
#define GPDMA_SOFTBREQ_SOFTBREQ9_Msk          (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ9_Pos)                /*!< GPDMA SOFTBREQ: SOFTBREQ9 Mask          */
#define GPDMA_SOFTBREQ_SOFTBREQ10_Pos         10                                                      /*!< GPDMA SOFTBREQ: SOFTBREQ10 Position     */
#define GPDMA_SOFTBREQ_SOFTBREQ10_Msk         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ10_Pos)               /*!< GPDMA SOFTBREQ: SOFTBREQ10 Mask         */
#define GPDMA_SOFTBREQ_SOFTBREQ11_Pos         11                                                      /*!< GPDMA SOFTBREQ: SOFTBREQ11 Position     */
#define GPDMA_SOFTBREQ_SOFTBREQ11_Msk         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ11_Pos)               /*!< GPDMA SOFTBREQ: SOFTBREQ11 Mask         */
#define GPDMA_SOFTBREQ_SOFTBREQ12_Pos         12                                                      /*!< GPDMA SOFTBREQ: SOFTBREQ12 Position     */
#define GPDMA_SOFTBREQ_SOFTBREQ12_Msk         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ12_Pos)               /*!< GPDMA SOFTBREQ: SOFTBREQ12 Mask         */
#define GPDMA_SOFTBREQ_SOFTBREQ13_Pos         13                                                      /*!< GPDMA SOFTBREQ: SOFTBREQ13 Position     */
#define GPDMA_SOFTBREQ_SOFTBREQ13_Msk         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ13_Pos)               /*!< GPDMA SOFTBREQ: SOFTBREQ13 Mask         */
#define GPDMA_SOFTBREQ_SOFTBREQ14_Pos         14                                                      /*!< GPDMA SOFTBREQ: SOFTBREQ14 Position     */
#define GPDMA_SOFTBREQ_SOFTBREQ14_Msk         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ14_Pos)               /*!< GPDMA SOFTBREQ: SOFTBREQ14 Mask         */
#define GPDMA_SOFTBREQ_SOFTBREQ15_Pos         15                                                      /*!< GPDMA SOFTBREQ: SOFTBREQ15 Position     */
#define GPDMA_SOFTBREQ_SOFTBREQ15_Msk         (0x01UL << GPDMA_SOFTBREQ_SOFTBREQ15_Pos)               /*!< GPDMA SOFTBREQ: SOFTBREQ15 Mask         */

/* -------------------------------  GPDMA_SOFTSREQ  ------------------------------- */
#define GPDMA_SOFTSREQ_SOFTSREQ0_Pos          0                                                       /*!< GPDMA SOFTSREQ: SOFTSREQ0 Position      */
#define GPDMA_SOFTSREQ_SOFTSREQ0_Msk          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ0_Pos)                /*!< GPDMA SOFTSREQ: SOFTSREQ0 Mask          */
#define GPDMA_SOFTSREQ_SOFTSREQ1_Pos          1                                                       /*!< GPDMA SOFTSREQ: SOFTSREQ1 Position      */
#define GPDMA_SOFTSREQ_SOFTSREQ1_Msk          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ1_Pos)                /*!< GPDMA SOFTSREQ: SOFTSREQ1 Mask          */
#define GPDMA_SOFTSREQ_SOFTSREQ2_Pos          2                                                       /*!< GPDMA SOFTSREQ: SOFTSREQ2 Position      */
#define GPDMA_SOFTSREQ_SOFTSREQ2_Msk          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ2_Pos)                /*!< GPDMA SOFTSREQ: SOFTSREQ2 Mask          */
#define GPDMA_SOFTSREQ_SOFTSREQ3_Pos          3                                                       /*!< GPDMA SOFTSREQ: SOFTSREQ3 Position      */
#define GPDMA_SOFTSREQ_SOFTSREQ3_Msk          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ3_Pos)                /*!< GPDMA SOFTSREQ: SOFTSREQ3 Mask          */
#define GPDMA_SOFTSREQ_SOFTSREQ4_Pos          4                                                       /*!< GPDMA SOFTSREQ: SOFTSREQ4 Position      */
#define GPDMA_SOFTSREQ_SOFTSREQ4_Msk          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ4_Pos)                /*!< GPDMA SOFTSREQ: SOFTSREQ4 Mask          */
#define GPDMA_SOFTSREQ_SOFTSREQ5_Pos          5                                                       /*!< GPDMA SOFTSREQ: SOFTSREQ5 Position      */
#define GPDMA_SOFTSREQ_SOFTSREQ5_Msk          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ5_Pos)                /*!< GPDMA SOFTSREQ: SOFTSREQ5 Mask          */
#define GPDMA_SOFTSREQ_SOFTSREQ6_Pos          6                                                       /*!< GPDMA SOFTSREQ: SOFTSREQ6 Position      */
#define GPDMA_SOFTSREQ_SOFTSREQ6_Msk          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ6_Pos)                /*!< GPDMA SOFTSREQ: SOFTSREQ6 Mask          */
#define GPDMA_SOFTSREQ_SOFTSREQ7_Pos          7                                                       /*!< GPDMA SOFTSREQ: SOFTSREQ7 Position      */
#define GPDMA_SOFTSREQ_SOFTSREQ7_Msk          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ7_Pos)                /*!< GPDMA SOFTSREQ: SOFTSREQ7 Mask          */
#define GPDMA_SOFTSREQ_SOFTSREQ8_Pos          8                                                       /*!< GPDMA SOFTSREQ: SOFTSREQ8 Position      */
#define GPDMA_SOFTSREQ_SOFTSREQ8_Msk          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ8_Pos)                /*!< GPDMA SOFTSREQ: SOFTSREQ8 Mask          */
#define GPDMA_SOFTSREQ_SOFTSREQ9_Pos          9                                                       /*!< GPDMA SOFTSREQ: SOFTSREQ9 Position      */
#define GPDMA_SOFTSREQ_SOFTSREQ9_Msk          (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ9_Pos)                /*!< GPDMA SOFTSREQ: SOFTSREQ9 Mask          */
#define GPDMA_SOFTSREQ_SOFTSREQ10_Pos         10                                                      /*!< GPDMA SOFTSREQ: SOFTSREQ10 Position     */
#define GPDMA_SOFTSREQ_SOFTSREQ10_Msk         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ10_Pos)               /*!< GPDMA SOFTSREQ: SOFTSREQ10 Mask         */
#define GPDMA_SOFTSREQ_SOFTSREQ11_Pos         11                                                      /*!< GPDMA SOFTSREQ: SOFTSREQ11 Position     */
#define GPDMA_SOFTSREQ_SOFTSREQ11_Msk         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ11_Pos)               /*!< GPDMA SOFTSREQ: SOFTSREQ11 Mask         */
#define GPDMA_SOFTSREQ_SOFTSREQ12_Pos         12                                                      /*!< GPDMA SOFTSREQ: SOFTSREQ12 Position     */
#define GPDMA_SOFTSREQ_SOFTSREQ12_Msk         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ12_Pos)               /*!< GPDMA SOFTSREQ: SOFTSREQ12 Mask         */
#define GPDMA_SOFTSREQ_SOFTSREQ13_Pos         13                                                      /*!< GPDMA SOFTSREQ: SOFTSREQ13 Position     */
#define GPDMA_SOFTSREQ_SOFTSREQ13_Msk         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ13_Pos)               /*!< GPDMA SOFTSREQ: SOFTSREQ13 Mask         */
#define GPDMA_SOFTSREQ_SOFTSREQ14_Pos         14                                                      /*!< GPDMA SOFTSREQ: SOFTSREQ14 Position     */
#define GPDMA_SOFTSREQ_SOFTSREQ14_Msk         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ14_Pos)               /*!< GPDMA SOFTSREQ: SOFTSREQ14 Mask         */
#define GPDMA_SOFTSREQ_SOFTSREQ15_Pos         15                                                      /*!< GPDMA SOFTSREQ: SOFTSREQ15 Position     */
#define GPDMA_SOFTSREQ_SOFTSREQ15_Msk         (0x01UL << GPDMA_SOFTSREQ_SOFTSREQ15_Pos)               /*!< GPDMA SOFTSREQ: SOFTSREQ15 Mask         */

/* -------------------------------  GPDMA_SOFTLBREQ  ------------------------------ */
#define GPDMA_SOFTLBREQ_SOFTLBREQ0_Pos        0                                                       /*!< GPDMA SOFTLBREQ: SOFTLBREQ0 Position    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ0_Msk        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ0_Pos)              /*!< GPDMA SOFTLBREQ: SOFTLBREQ0 Mask        */
#define GPDMA_SOFTLBREQ_SOFTLBREQ1_Pos        1                                                       /*!< GPDMA SOFTLBREQ: SOFTLBREQ1 Position    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ1_Msk        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ1_Pos)              /*!< GPDMA SOFTLBREQ: SOFTLBREQ1 Mask        */
#define GPDMA_SOFTLBREQ_SOFTLBREQ2_Pos        2                                                       /*!< GPDMA SOFTLBREQ: SOFTLBREQ2 Position    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ2_Msk        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ2_Pos)              /*!< GPDMA SOFTLBREQ: SOFTLBREQ2 Mask        */
#define GPDMA_SOFTLBREQ_SOFTLBREQ3_Pos        3                                                       /*!< GPDMA SOFTLBREQ: SOFTLBREQ3 Position    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ3_Msk        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ3_Pos)              /*!< GPDMA SOFTLBREQ: SOFTLBREQ3 Mask        */
#define GPDMA_SOFTLBREQ_SOFTLBREQ4_Pos        4                                                       /*!< GPDMA SOFTLBREQ: SOFTLBREQ4 Position    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ4_Msk        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ4_Pos)              /*!< GPDMA SOFTLBREQ: SOFTLBREQ4 Mask        */
#define GPDMA_SOFTLBREQ_SOFTLBREQ5_Pos        5                                                       /*!< GPDMA SOFTLBREQ: SOFTLBREQ5 Position    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ5_Msk        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ5_Pos)              /*!< GPDMA SOFTLBREQ: SOFTLBREQ5 Mask        */
#define GPDMA_SOFTLBREQ_SOFTLBREQ6_Pos        6                                                       /*!< GPDMA SOFTLBREQ: SOFTLBREQ6 Position    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ6_Msk        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ6_Pos)              /*!< GPDMA SOFTLBREQ: SOFTLBREQ6 Mask        */
#define GPDMA_SOFTLBREQ_SOFTLBREQ7_Pos        7                                                       /*!< GPDMA SOFTLBREQ: SOFTLBREQ7 Position    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ7_Msk        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ7_Pos)              /*!< GPDMA SOFTLBREQ: SOFTLBREQ7 Mask        */
#define GPDMA_SOFTLBREQ_SOFTLBREQ8_Pos        8                                                       /*!< GPDMA SOFTLBREQ: SOFTLBREQ8 Position    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ8_Msk        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ8_Pos)              /*!< GPDMA SOFTLBREQ: SOFTLBREQ8 Mask        */
#define GPDMA_SOFTLBREQ_SOFTLBREQ9_Pos        9                                                       /*!< GPDMA SOFTLBREQ: SOFTLBREQ9 Position    */
#define GPDMA_SOFTLBREQ_SOFTLBREQ9_Msk        (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ9_Pos)              /*!< GPDMA SOFTLBREQ: SOFTLBREQ9 Mask        */
#define GPDMA_SOFTLBREQ_SOFTLBREQ10_Pos       10                                                      /*!< GPDMA SOFTLBREQ: SOFTLBREQ10 Position   */
#define GPDMA_SOFTLBREQ_SOFTLBREQ10_Msk       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ10_Pos)             /*!< GPDMA SOFTLBREQ: SOFTLBREQ10 Mask       */
#define GPDMA_SOFTLBREQ_SOFTLBREQ11_Pos       11                                                      /*!< GPDMA SOFTLBREQ: SOFTLBREQ11 Position   */
#define GPDMA_SOFTLBREQ_SOFTLBREQ11_Msk       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ11_Pos)             /*!< GPDMA SOFTLBREQ: SOFTLBREQ11 Mask       */
#define GPDMA_SOFTLBREQ_SOFTLBREQ12_Pos       12                                                      /*!< GPDMA SOFTLBREQ: SOFTLBREQ12 Position   */
#define GPDMA_SOFTLBREQ_SOFTLBREQ12_Msk       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ12_Pos)             /*!< GPDMA SOFTLBREQ: SOFTLBREQ12 Mask       */
#define GPDMA_SOFTLBREQ_SOFTLBREQ13_Pos       13                                                      /*!< GPDMA SOFTLBREQ: SOFTLBREQ13 Position   */
#define GPDMA_SOFTLBREQ_SOFTLBREQ13_Msk       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ13_Pos)             /*!< GPDMA SOFTLBREQ: SOFTLBREQ13 Mask       */
#define GPDMA_SOFTLBREQ_SOFTLBREQ14_Pos       14                                                      /*!< GPDMA SOFTLBREQ: SOFTLBREQ14 Position   */
#define GPDMA_SOFTLBREQ_SOFTLBREQ14_Msk       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ14_Pos)             /*!< GPDMA SOFTLBREQ: SOFTLBREQ14 Mask       */
#define GPDMA_SOFTLBREQ_SOFTLBREQ15_Pos       15                                                      /*!< GPDMA SOFTLBREQ: SOFTLBREQ15 Position   */
#define GPDMA_SOFTLBREQ_SOFTLBREQ15_Msk       (0x01UL << GPDMA_SOFTLBREQ_SOFTLBREQ15_Pos)             /*!< GPDMA SOFTLBREQ: SOFTLBREQ15 Mask       */

/* -------------------------------  GPDMA_SOFTLSREQ  ------------------------------ */
#define GPDMA_SOFTLSREQ_SOFTLSREQ0_Pos        0                                                       /*!< GPDMA SOFTLSREQ: SOFTLSREQ0 Position    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ0_Msk        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ0_Pos)              /*!< GPDMA SOFTLSREQ: SOFTLSREQ0 Mask        */
#define GPDMA_SOFTLSREQ_SOFTLSREQ1_Pos        1                                                       /*!< GPDMA SOFTLSREQ: SOFTLSREQ1 Position    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ1_Msk        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ1_Pos)              /*!< GPDMA SOFTLSREQ: SOFTLSREQ1 Mask        */
#define GPDMA_SOFTLSREQ_SOFTLSREQ2_Pos        2                                                       /*!< GPDMA SOFTLSREQ: SOFTLSREQ2 Position    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ2_Msk        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ2_Pos)              /*!< GPDMA SOFTLSREQ: SOFTLSREQ2 Mask        */
#define GPDMA_SOFTLSREQ_SOFTLSREQ3_Pos        3                                                       /*!< GPDMA SOFTLSREQ: SOFTLSREQ3 Position    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ3_Msk        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ3_Pos)              /*!< GPDMA SOFTLSREQ: SOFTLSREQ3 Mask        */
#define GPDMA_SOFTLSREQ_SOFTLSREQ4_Pos        4                                                       /*!< GPDMA SOFTLSREQ: SOFTLSREQ4 Position    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ4_Msk        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ4_Pos)              /*!< GPDMA SOFTLSREQ: SOFTLSREQ4 Mask        */
#define GPDMA_SOFTLSREQ_SOFTLSREQ5_Pos        5                                                       /*!< GPDMA SOFTLSREQ: SOFTLSREQ5 Position    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ5_Msk        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ5_Pos)              /*!< GPDMA SOFTLSREQ: SOFTLSREQ5 Mask        */
#define GPDMA_SOFTLSREQ_SOFTLSREQ6_Pos        6                                                       /*!< GPDMA SOFTLSREQ: SOFTLSREQ6 Position    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ6_Msk        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ6_Pos)              /*!< GPDMA SOFTLSREQ: SOFTLSREQ6 Mask        */
#define GPDMA_SOFTLSREQ_SOFTLSREQ7_Pos        7                                                       /*!< GPDMA SOFTLSREQ: SOFTLSREQ7 Position    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ7_Msk        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ7_Pos)              /*!< GPDMA SOFTLSREQ: SOFTLSREQ7 Mask        */
#define GPDMA_SOFTLSREQ_SOFTLSREQ8_Pos        8                                                       /*!< GPDMA SOFTLSREQ: SOFTLSREQ8 Position    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ8_Msk        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ8_Pos)              /*!< GPDMA SOFTLSREQ: SOFTLSREQ8 Mask        */
#define GPDMA_SOFTLSREQ_SOFTLSREQ9_Pos        9                                                       /*!< GPDMA SOFTLSREQ: SOFTLSREQ9 Position    */
#define GPDMA_SOFTLSREQ_SOFTLSREQ9_Msk        (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ9_Pos)              /*!< GPDMA SOFTLSREQ: SOFTLSREQ9 Mask        */
#define GPDMA_SOFTLSREQ_SOFTLSREQ10_Pos       10                                                      /*!< GPDMA SOFTLSREQ: SOFTLSREQ10 Position   */
#define GPDMA_SOFTLSREQ_SOFTLSREQ10_Msk       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ10_Pos)             /*!< GPDMA SOFTLSREQ: SOFTLSREQ10 Mask       */
#define GPDMA_SOFTLSREQ_SOFTLSREQ11_Pos       11                                                      /*!< GPDMA SOFTLSREQ: SOFTLSREQ11 Position   */
#define GPDMA_SOFTLSREQ_SOFTLSREQ11_Msk       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ11_Pos)             /*!< GPDMA SOFTLSREQ: SOFTLSREQ11 Mask       */
#define GPDMA_SOFTLSREQ_SOFTLSREQ12_Pos       12                                                      /*!< GPDMA SOFTLSREQ: SOFTLSREQ12 Position   */
#define GPDMA_SOFTLSREQ_SOFTLSREQ12_Msk       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ12_Pos)             /*!< GPDMA SOFTLSREQ: SOFTLSREQ12 Mask       */
#define GPDMA_SOFTLSREQ_SOFTLSREQ13_Pos       13                                                      /*!< GPDMA SOFTLSREQ: SOFTLSREQ13 Position   */
#define GPDMA_SOFTLSREQ_SOFTLSREQ13_Msk       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ13_Pos)             /*!< GPDMA SOFTLSREQ: SOFTLSREQ13 Mask       */
#define GPDMA_SOFTLSREQ_SOFTLSREQ14_Pos       14                                                      /*!< GPDMA SOFTLSREQ: SOFTLSREQ14 Position   */
#define GPDMA_SOFTLSREQ_SOFTLSREQ14_Msk       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ14_Pos)             /*!< GPDMA SOFTLSREQ: SOFTLSREQ14 Mask       */
#define GPDMA_SOFTLSREQ_SOFTLSREQ15_Pos       15                                                      /*!< GPDMA SOFTLSREQ: SOFTLSREQ15 Position   */
#define GPDMA_SOFTLSREQ_SOFTLSREQ15_Msk       (0x01UL << GPDMA_SOFTLSREQ_SOFTLSREQ15_Pos)             /*!< GPDMA SOFTLSREQ: SOFTLSREQ15 Mask       */

/* --------------------------------  GPDMA_CONFIG  -------------------------------- */
#define GPDMA_CONFIG_E_Pos                    0                                                       /*!< GPDMA CONFIG: E Position                */
#define GPDMA_CONFIG_E_Msk                    (0x01UL << GPDMA_CONFIG_E_Pos)                          /*!< GPDMA CONFIG: E Mask                    */
#define GPDMA_CONFIG_M0_Pos                   1                                                       /*!< GPDMA CONFIG: M0 Position               */
#define GPDMA_CONFIG_M0_Msk                   (0x01UL << GPDMA_CONFIG_M0_Pos)                         /*!< GPDMA CONFIG: M0 Mask                   */
#define GPDMA_CONFIG_M1_Pos                   2                                                       /*!< GPDMA CONFIG: M1 Position               */
#define GPDMA_CONFIG_M1_Msk                   (0x01UL << GPDMA_CONFIG_M1_Pos)                         /*!< GPDMA CONFIG: M1 Mask                   */

/* ---------------------------------  GPDMA_SYNC  --------------------------------- */
#define GPDMA_SYNC_DMACSYNC0_Pos              0                                                       /*!< GPDMA SYNC: DMACSYNC0 Position          */
#define GPDMA_SYNC_DMACSYNC0_Msk              (0x01UL << GPDMA_SYNC_DMACSYNC0_Pos)                    /*!< GPDMA SYNC: DMACSYNC0 Mask              */
#define GPDMA_SYNC_DMACSYNC1_Pos              1                                                       /*!< GPDMA SYNC: DMACSYNC1 Position          */
#define GPDMA_SYNC_DMACSYNC1_Msk              (0x01UL << GPDMA_SYNC_DMACSYNC1_Pos)                    /*!< GPDMA SYNC: DMACSYNC1 Mask              */
#define GPDMA_SYNC_DMACSYNC2_Pos              2                                                       /*!< GPDMA SYNC: DMACSYNC2 Position          */
#define GPDMA_SYNC_DMACSYNC2_Msk              (0x01UL << GPDMA_SYNC_DMACSYNC2_Pos)                    /*!< GPDMA SYNC: DMACSYNC2 Mask              */
#define GPDMA_SYNC_DMACSYNC3_Pos              3                                                       /*!< GPDMA SYNC: DMACSYNC3 Position          */
#define GPDMA_SYNC_DMACSYNC3_Msk              (0x01UL << GPDMA_SYNC_DMACSYNC3_Pos)                    /*!< GPDMA SYNC: DMACSYNC3 Mask              */
#define GPDMA_SYNC_DMACSYNC4_Pos              4                                                       /*!< GPDMA SYNC: DMACSYNC4 Position          */
#define GPDMA_SYNC_DMACSYNC4_Msk              (0x01UL << GPDMA_SYNC_DMACSYNC4_Pos)                    /*!< GPDMA SYNC: DMACSYNC4 Mask              */
#define GPDMA_SYNC_DMACSYNC5_Pos              5                                                       /*!< GPDMA SYNC: DMACSYNC5 Position          */
#define GPDMA_SYNC_DMACSYNC5_Msk              (0x01UL << GPDMA_SYNC_DMACSYNC5_Pos)                    /*!< GPDMA SYNC: DMACSYNC5 Mask              */
#define GPDMA_SYNC_DMACSYNC6_Pos              6                                                       /*!< GPDMA SYNC: DMACSYNC6 Position          */
#define GPDMA_SYNC_DMACSYNC6_Msk              (0x01UL << GPDMA_SYNC_DMACSYNC6_Pos)                    /*!< GPDMA SYNC: DMACSYNC6 Mask              */
#define GPDMA_SYNC_DMACSYNC7_Pos              7                                                       /*!< GPDMA SYNC: DMACSYNC7 Position          */
#define GPDMA_SYNC_DMACSYNC7_Msk              (0x01UL << GPDMA_SYNC_DMACSYNC7_Pos)                    /*!< GPDMA SYNC: DMACSYNC7 Mask              */
#define GPDMA_SYNC_DMACSYNC8_Pos              8                                                       /*!< GPDMA SYNC: DMACSYNC8 Position          */
#define GPDMA_SYNC_DMACSYNC8_Msk              (0x01UL << GPDMA_SYNC_DMACSYNC8_Pos)                    /*!< GPDMA SYNC: DMACSYNC8 Mask              */
#define GPDMA_SYNC_DMACSYNC9_Pos              9                                                       /*!< GPDMA SYNC: DMACSYNC9 Position          */
#define GPDMA_SYNC_DMACSYNC9_Msk              (0x01UL << GPDMA_SYNC_DMACSYNC9_Pos)                    /*!< GPDMA SYNC: DMACSYNC9 Mask              */
#define GPDMA_SYNC_DMACSYNC10_Pos             10                                                      /*!< GPDMA SYNC: DMACSYNC10 Position         */
#define GPDMA_SYNC_DMACSYNC10_Msk             (0x01UL << GPDMA_SYNC_DMACSYNC10_Pos)                   /*!< GPDMA SYNC: DMACSYNC10 Mask             */
#define GPDMA_SYNC_DMACSYNC11_Pos             11                                                      /*!< GPDMA SYNC: DMACSYNC11 Position         */
#define GPDMA_SYNC_DMACSYNC11_Msk             (0x01UL << GPDMA_SYNC_DMACSYNC11_Pos)                   /*!< GPDMA SYNC: DMACSYNC11 Mask             */
#define GPDMA_SYNC_DMACSYNC12_Pos             12                                                      /*!< GPDMA SYNC: DMACSYNC12 Position         */
#define GPDMA_SYNC_DMACSYNC12_Msk             (0x01UL << GPDMA_SYNC_DMACSYNC12_Pos)                   /*!< GPDMA SYNC: DMACSYNC12 Mask             */
#define GPDMA_SYNC_DMACSYNC13_Pos             13                                                      /*!< GPDMA SYNC: DMACSYNC13 Position         */
#define GPDMA_SYNC_DMACSYNC13_Msk             (0x01UL << GPDMA_SYNC_DMACSYNC13_Pos)                   /*!< GPDMA SYNC: DMACSYNC13 Mask             */
#define GPDMA_SYNC_DMACSYNC14_Pos             14                                                      /*!< GPDMA SYNC: DMACSYNC14 Position         */
#define GPDMA_SYNC_DMACSYNC14_Msk             (0x01UL << GPDMA_SYNC_DMACSYNC14_Pos)                   /*!< GPDMA SYNC: DMACSYNC14 Mask             */
#define GPDMA_SYNC_DMACSYNC15_Pos             15                                                      /*!< GPDMA SYNC: DMACSYNC15 Position         */
#define GPDMA_SYNC_DMACSYNC15_Msk             (0x01UL << GPDMA_SYNC_DMACSYNC15_Pos)                   /*!< GPDMA SYNC: DMACSYNC15 Mask             */

/* -------------------------------  GPDMA_C0SRCADDR  ------------------------------ */
#define GPDMA_C0SRCADDR_SRCADDR_Pos           0                                                       /*!< GPDMA C0SRCADDR: SRCADDR Position       */
#define GPDMA_C0SRCADDR_SRCADDR_Msk           (0xffffffffUL << GPDMA_C0SRCADDR_SRCADDR_Pos)           /*!< GPDMA C0SRCADDR: SRCADDR Mask           */

/* ------------------------------  GPDMA_C0DESTADDR  ------------------------------ */
#define GPDMA_C0DESTADDR_DESTADDR_Pos         0                                                       /*!< GPDMA C0DESTADDR: DESTADDR Position     */
#define GPDMA_C0DESTADDR_DESTADDR_Msk         (0xffffffffUL << GPDMA_C0DESTADDR_DESTADDR_Pos)         /*!< GPDMA C0DESTADDR: DESTADDR Mask         */

/* ---------------------------------  GPDMA_C0LLI  -------------------------------- */
#define GPDMA_C0LLI_LM_Pos                    0                                                       /*!< GPDMA C0LLI: LM Position                */
#define GPDMA_C0LLI_LM_Msk                    (0x01UL << GPDMA_C0LLI_LM_Pos)                          /*!< GPDMA C0LLI: LM Mask                    */
#define GPDMA_C0LLI_R_Pos                     1                                                       /*!< GPDMA C0LLI: R Position                 */
#define GPDMA_C0LLI_R_Msk                     (0x01UL << GPDMA_C0LLI_R_Pos)                           /*!< GPDMA C0LLI: R Mask                     */
#define GPDMA_C0LLI_LLI_Pos                   2                                                       /*!< GPDMA C0LLI: LLI Position               */
#define GPDMA_C0LLI_LLI_Msk                   (0x3fffffffUL << GPDMA_C0LLI_LLI_Pos)                   /*!< GPDMA C0LLI: LLI Mask                   */

/* -------------------------------  GPDMA_C0CONTROL  ------------------------------ */
#define GPDMA_C0CONTROL_TRANSFERSIZE_Pos      0                                                       /*!< GPDMA C0CONTROL: TRANSFERSIZE Position  */
#define GPDMA_C0CONTROL_TRANSFERSIZE_Msk      (0x00000fffUL << GPDMA_C0CONTROL_TRANSFERSIZE_Pos)      /*!< GPDMA C0CONTROL: TRANSFERSIZE Mask      */
#define GPDMA_C0CONTROL_SBSIZE_Pos            12                                                      /*!< GPDMA C0CONTROL: SBSIZE Position        */
#define GPDMA_C0CONTROL_SBSIZE_Msk            (0x07UL << GPDMA_C0CONTROL_SBSIZE_Pos)                  /*!< GPDMA C0CONTROL: SBSIZE Mask            */
#define GPDMA_C0CONTROL_DBSIZE_Pos            15                                                      /*!< GPDMA C0CONTROL: DBSIZE Position        */
#define GPDMA_C0CONTROL_DBSIZE_Msk            (0x07UL << GPDMA_C0CONTROL_DBSIZE_Pos)                  /*!< GPDMA C0CONTROL: DBSIZE Mask            */
#define GPDMA_C0CONTROL_SWIDTH_Pos            18                                                      /*!< GPDMA C0CONTROL: SWIDTH Position        */
#define GPDMA_C0CONTROL_SWIDTH_Msk            (0x07UL << GPDMA_C0CONTROL_SWIDTH_Pos)                  /*!< GPDMA C0CONTROL: SWIDTH Mask            */
#define GPDMA_C0CONTROL_DWIDTH_Pos            21                                                      /*!< GPDMA C0CONTROL: DWIDTH Position        */
#define GPDMA_C0CONTROL_DWIDTH_Msk            (0x07UL << GPDMA_C0CONTROL_DWIDTH_Pos)                  /*!< GPDMA C0CONTROL: DWIDTH Mask            */
#define GPDMA_C0CONTROL_S_Pos                 24                                                      /*!< GPDMA C0CONTROL: S Position             */
#define GPDMA_C0CONTROL_S_Msk                 (0x01UL << GPDMA_C0CONTROL_S_Pos)                       /*!< GPDMA C0CONTROL: S Mask                 */
#define GPDMA_C0CONTROL_D_Pos                 25                                                      /*!< GPDMA C0CONTROL: D Position             */
#define GPDMA_C0CONTROL_D_Msk                 (0x01UL << GPDMA_C0CONTROL_D_Pos)                       /*!< GPDMA C0CONTROL: D Mask                 */
#define GPDMA_C0CONTROL_SI_Pos                26                                                      /*!< GPDMA C0CONTROL: SI Position            */
#define GPDMA_C0CONTROL_SI_Msk                (0x01UL << GPDMA_C0CONTROL_SI_Pos)                      /*!< GPDMA C0CONTROL: SI Mask                */
#define GPDMA_C0CONTROL_DI_Pos                27                                                      /*!< GPDMA C0CONTROL: DI Position            */
#define GPDMA_C0CONTROL_DI_Msk                (0x01UL << GPDMA_C0CONTROL_DI_Pos)                      /*!< GPDMA C0CONTROL: DI Mask                */
#define GPDMA_C0CONTROL_PROT1_Pos             28                                                      /*!< GPDMA C0CONTROL: PROT1 Position         */
#define GPDMA_C0CONTROL_PROT1_Msk             (0x01UL << GPDMA_C0CONTROL_PROT1_Pos)                   /*!< GPDMA C0CONTROL: PROT1 Mask             */
#define GPDMA_C0CONTROL_PROT2_Pos             29                                                      /*!< GPDMA C0CONTROL: PROT2 Position         */
#define GPDMA_C0CONTROL_PROT2_Msk             (0x01UL << GPDMA_C0CONTROL_PROT2_Pos)                   /*!< GPDMA C0CONTROL: PROT2 Mask             */
#define GPDMA_C0CONTROL_PROT3_Pos             30                                                      /*!< GPDMA C0CONTROL: PROT3 Position         */
#define GPDMA_C0CONTROL_PROT3_Msk             (0x01UL << GPDMA_C0CONTROL_PROT3_Pos)                   /*!< GPDMA C0CONTROL: PROT3 Mask             */
#define GPDMA_C0CONTROL_I_Pos                 31                                                      /*!< GPDMA C0CONTROL: I Position             */
#define GPDMA_C0CONTROL_I_Msk                 (0x01UL << GPDMA_C0CONTROL_I_Pos)                       /*!< GPDMA C0CONTROL: I Mask                 */

/* -------------------------------  GPDMA_C0CONFIG  ------------------------------- */
#define GPDMA_C0CONFIG_E_Pos                  0                                                       /*!< GPDMA C0CONFIG: E Position              */
#define GPDMA_C0CONFIG_E_Msk                  (0x01UL << GPDMA_C0CONFIG_E_Pos)                        /*!< GPDMA C0CONFIG: E Mask                  */
#define GPDMA_C0CONFIG_SRCPERIPHERAL_Pos      1                                                       /*!< GPDMA C0CONFIG: SRCPERIPHERAL Position  */
#define GPDMA_C0CONFIG_SRCPERIPHERAL_Msk      (0x1fUL << GPDMA_C0CONFIG_SRCPERIPHERAL_Pos)            /*!< GPDMA C0CONFIG: SRCPERIPHERAL Mask      */
#define GPDMA_C0CONFIG_DESTPERIPHERAL_Pos     6                                                       /*!< GPDMA C0CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C0CONFIG_DESTPERIPHERAL_Msk     (0x1fUL << GPDMA_C0CONFIG_DESTPERIPHERAL_Pos)           /*!< GPDMA C0CONFIG: DESTPERIPHERAL Mask     */
#define GPDMA_C0CONFIG_FLOWCNTRL_Pos          11                                                      /*!< GPDMA C0CONFIG: FLOWCNTRL Position      */
#define GPDMA_C0CONFIG_FLOWCNTRL_Msk          (0x07UL << GPDMA_C0CONFIG_FLOWCNTRL_Pos)                /*!< GPDMA C0CONFIG: FLOWCNTRL Mask          */
#define GPDMA_C0CONFIG_IE_Pos                 14                                                      /*!< GPDMA C0CONFIG: IE Position             */
#define GPDMA_C0CONFIG_IE_Msk                 (0x01UL << GPDMA_C0CONFIG_IE_Pos)                       /*!< GPDMA C0CONFIG: IE Mask                 */
#define GPDMA_C0CONFIG_ITC_Pos                15                                                      /*!< GPDMA C0CONFIG: ITC Position            */
#define GPDMA_C0CONFIG_ITC_Msk                (0x01UL << GPDMA_C0CONFIG_ITC_Pos)                      /*!< GPDMA C0CONFIG: ITC Mask                */
#define GPDMA_C0CONFIG_L_Pos                  16                                                      /*!< GPDMA C0CONFIG: L Position              */
#define GPDMA_C0CONFIG_L_Msk                  (0x01UL << GPDMA_C0CONFIG_L_Pos)                        /*!< GPDMA C0CONFIG: L Mask                  */
#define GPDMA_C0CONFIG_A_Pos                  17                                                      /*!< GPDMA C0CONFIG: A Position              */
#define GPDMA_C0CONFIG_A_Msk                  (0x01UL << GPDMA_C0CONFIG_A_Pos)                        /*!< GPDMA C0CONFIG: A Mask                  */
#define GPDMA_C0CONFIG_H_Pos                  18                                                      /*!< GPDMA C0CONFIG: H Position              */
#define GPDMA_C0CONFIG_H_Msk                  (0x01UL << GPDMA_C0CONFIG_H_Pos)                        /*!< GPDMA C0CONFIG: H Mask                  */

/* -------------------------------  GPDMA_C1SRCADDR  ------------------------------ */
#define GPDMA_C1SRCADDR_SRCADDR_Pos           0                                                       /*!< GPDMA C1SRCADDR: SRCADDR Position       */
#define GPDMA_C1SRCADDR_SRCADDR_Msk           (0xffffffffUL << GPDMA_C1SRCADDR_SRCADDR_Pos)           /*!< GPDMA C1SRCADDR: SRCADDR Mask           */

/* ------------------------------  GPDMA_C1DESTADDR  ------------------------------ */
#define GPDMA_C1DESTADDR_DESTADDR_Pos         0                                                       /*!< GPDMA C1DESTADDR: DESTADDR Position     */
#define GPDMA_C1DESTADDR_DESTADDR_Msk         (0xffffffffUL << GPDMA_C1DESTADDR_DESTADDR_Pos)         /*!< GPDMA C1DESTADDR: DESTADDR Mask         */

/* ---------------------------------  GPDMA_C1LLI  -------------------------------- */
#define GPDMA_C1LLI_LM_Pos                    0                                                       /*!< GPDMA C1LLI: LM Position                */
#define GPDMA_C1LLI_LM_Msk                    (0x01UL << GPDMA_C1LLI_LM_Pos)                          /*!< GPDMA C1LLI: LM Mask                    */
#define GPDMA_C1LLI_R_Pos                     1                                                       /*!< GPDMA C1LLI: R Position                 */
#define GPDMA_C1LLI_R_Msk                     (0x01UL << GPDMA_C1LLI_R_Pos)                           /*!< GPDMA C1LLI: R Mask                     */
#define GPDMA_C1LLI_LLI_Pos                   2                                                       /*!< GPDMA C1LLI: LLI Position               */
#define GPDMA_C1LLI_LLI_Msk                   (0x3fffffffUL << GPDMA_C1LLI_LLI_Pos)                   /*!< GPDMA C1LLI: LLI Mask                   */

/* -------------------------------  GPDMA_C1CONTROL  ------------------------------ */
#define GPDMA_C1CONTROL_TRANSFERSIZE_Pos      0                                                       /*!< GPDMA C1CONTROL: TRANSFERSIZE Position  */
#define GPDMA_C1CONTROL_TRANSFERSIZE_Msk      (0x00000fffUL << GPDMA_C1CONTROL_TRANSFERSIZE_Pos)      /*!< GPDMA C1CONTROL: TRANSFERSIZE Mask      */
#define GPDMA_C1CONTROL_SBSIZE_Pos            12                                                      /*!< GPDMA C1CONTROL: SBSIZE Position        */
#define GPDMA_C1CONTROL_SBSIZE_Msk            (0x07UL << GPDMA_C1CONTROL_SBSIZE_Pos)                  /*!< GPDMA C1CONTROL: SBSIZE Mask            */
#define GPDMA_C1CONTROL_DBSIZE_Pos            15                                                      /*!< GPDMA C1CONTROL: DBSIZE Position        */
#define GPDMA_C1CONTROL_DBSIZE_Msk            (0x07UL << GPDMA_C1CONTROL_DBSIZE_Pos)                  /*!< GPDMA C1CONTROL: DBSIZE Mask            */
#define GPDMA_C1CONTROL_SWIDTH_Pos            18                                                      /*!< GPDMA C1CONTROL: SWIDTH Position        */
#define GPDMA_C1CONTROL_SWIDTH_Msk            (0x07UL << GPDMA_C1CONTROL_SWIDTH_Pos)                  /*!< GPDMA C1CONTROL: SWIDTH Mask            */
#define GPDMA_C1CONTROL_DWIDTH_Pos            21                                                      /*!< GPDMA C1CONTROL: DWIDTH Position        */
#define GPDMA_C1CONTROL_DWIDTH_Msk            (0x07UL << GPDMA_C1CONTROL_DWIDTH_Pos)                  /*!< GPDMA C1CONTROL: DWIDTH Mask            */
#define GPDMA_C1CONTROL_S_Pos                 24                                                      /*!< GPDMA C1CONTROL: S Position             */
#define GPDMA_C1CONTROL_S_Msk                 (0x01UL << GPDMA_C1CONTROL_S_Pos)                       /*!< GPDMA C1CONTROL: S Mask                 */
#define GPDMA_C1CONTROL_D_Pos                 25                                                      /*!< GPDMA C1CONTROL: D Position             */
#define GPDMA_C1CONTROL_D_Msk                 (0x01UL << GPDMA_C1CONTROL_D_Pos)                       /*!< GPDMA C1CONTROL: D Mask                 */
#define GPDMA_C1CONTROL_SI_Pos                26                                                      /*!< GPDMA C1CONTROL: SI Position            */
#define GPDMA_C1CONTROL_SI_Msk                (0x01UL << GPDMA_C1CONTROL_SI_Pos)                      /*!< GPDMA C1CONTROL: SI Mask                */
#define GPDMA_C1CONTROL_DI_Pos                27                                                      /*!< GPDMA C1CONTROL: DI Position            */
#define GPDMA_C1CONTROL_DI_Msk                (0x01UL << GPDMA_C1CONTROL_DI_Pos)                      /*!< GPDMA C1CONTROL: DI Mask                */
#define GPDMA_C1CONTROL_PROT1_Pos             28                                                      /*!< GPDMA C1CONTROL: PROT1 Position         */
#define GPDMA_C1CONTROL_PROT1_Msk             (0x01UL << GPDMA_C1CONTROL_PROT1_Pos)                   /*!< GPDMA C1CONTROL: PROT1 Mask             */
#define GPDMA_C1CONTROL_PROT2_Pos             29                                                      /*!< GPDMA C1CONTROL: PROT2 Position         */
#define GPDMA_C1CONTROL_PROT2_Msk             (0x01UL << GPDMA_C1CONTROL_PROT2_Pos)                   /*!< GPDMA C1CONTROL: PROT2 Mask             */
#define GPDMA_C1CONTROL_PROT3_Pos             30                                                      /*!< GPDMA C1CONTROL: PROT3 Position         */
#define GPDMA_C1CONTROL_PROT3_Msk             (0x01UL << GPDMA_C1CONTROL_PROT3_Pos)                   /*!< GPDMA C1CONTROL: PROT3 Mask             */
#define GPDMA_C1CONTROL_I_Pos                 31                                                      /*!< GPDMA C1CONTROL: I Position             */
#define GPDMA_C1CONTROL_I_Msk                 (0x01UL << GPDMA_C1CONTROL_I_Pos)                       /*!< GPDMA C1CONTROL: I Mask                 */

/* -------------------------------  GPDMA_C1CONFIG  ------------------------------- */
#define GPDMA_C1CONFIG_E_Pos                  0                                                       /*!< GPDMA C1CONFIG: E Position              */
#define GPDMA_C1CONFIG_E_Msk                  (0x01UL << GPDMA_C1CONFIG_E_Pos)                        /*!< GPDMA C1CONFIG: E Mask                  */
#define GPDMA_C1CONFIG_SRCPERIPHERAL_Pos      1                                                       /*!< GPDMA C1CONFIG: SRCPERIPHERAL Position  */
#define GPDMA_C1CONFIG_SRCPERIPHERAL_Msk      (0x1fUL << GPDMA_C1CONFIG_SRCPERIPHERAL_Pos)            /*!< GPDMA C1CONFIG: SRCPERIPHERAL Mask      */
#define GPDMA_C1CONFIG_DESTPERIPHERAL_Pos     6                                                       /*!< GPDMA C1CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C1CONFIG_DESTPERIPHERAL_Msk     (0x1fUL << GPDMA_C1CONFIG_DESTPERIPHERAL_Pos)           /*!< GPDMA C1CONFIG: DESTPERIPHERAL Mask     */
#define GPDMA_C1CONFIG_FLOWCNTRL_Pos          11                                                      /*!< GPDMA C1CONFIG: FLOWCNTRL Position      */
#define GPDMA_C1CONFIG_FLOWCNTRL_Msk          (0x07UL << GPDMA_C1CONFIG_FLOWCNTRL_Pos)                /*!< GPDMA C1CONFIG: FLOWCNTRL Mask          */
#define GPDMA_C1CONFIG_IE_Pos                 14                                                      /*!< GPDMA C1CONFIG: IE Position             */
#define GPDMA_C1CONFIG_IE_Msk                 (0x01UL << GPDMA_C1CONFIG_IE_Pos)                       /*!< GPDMA C1CONFIG: IE Mask                 */
#define GPDMA_C1CONFIG_ITC_Pos                15                                                      /*!< GPDMA C1CONFIG: ITC Position            */
#define GPDMA_C1CONFIG_ITC_Msk                (0x01UL << GPDMA_C1CONFIG_ITC_Pos)                      /*!< GPDMA C1CONFIG: ITC Mask                */
#define GPDMA_C1CONFIG_L_Pos                  16                                                      /*!< GPDMA C1CONFIG: L Position              */
#define GPDMA_C1CONFIG_L_Msk                  (0x01UL << GPDMA_C1CONFIG_L_Pos)                        /*!< GPDMA C1CONFIG: L Mask                  */
#define GPDMA_C1CONFIG_A_Pos                  17                                                      /*!< GPDMA C1CONFIG: A Position              */
#define GPDMA_C1CONFIG_A_Msk                  (0x01UL << GPDMA_C1CONFIG_A_Pos)                        /*!< GPDMA C1CONFIG: A Mask                  */
#define GPDMA_C1CONFIG_H_Pos                  18                                                      /*!< GPDMA C1CONFIG: H Position              */
#define GPDMA_C1CONFIG_H_Msk                  (0x01UL << GPDMA_C1CONFIG_H_Pos)                        /*!< GPDMA C1CONFIG: H Mask                  */

/* -------------------------------  GPDMA_C2SRCADDR  ------------------------------ */
#define GPDMA_C2SRCADDR_SRCADDR_Pos           0                                                       /*!< GPDMA C2SRCADDR: SRCADDR Position       */
#define GPDMA_C2SRCADDR_SRCADDR_Msk           (0xffffffffUL << GPDMA_C2SRCADDR_SRCADDR_Pos)           /*!< GPDMA C2SRCADDR: SRCADDR Mask           */

/* ------------------------------  GPDMA_C2DESTADDR  ------------------------------ */
#define GPDMA_C2DESTADDR_DESTADDR_Pos         0                                                       /*!< GPDMA C2DESTADDR: DESTADDR Position     */
#define GPDMA_C2DESTADDR_DESTADDR_Msk         (0xffffffffUL << GPDMA_C2DESTADDR_DESTADDR_Pos)         /*!< GPDMA C2DESTADDR: DESTADDR Mask         */

/* ---------------------------------  GPDMA_C2LLI  -------------------------------- */
#define GPDMA_C2LLI_LM_Pos                    0                                                       /*!< GPDMA C2LLI: LM Position                */
#define GPDMA_C2LLI_LM_Msk                    (0x01UL << GPDMA_C2LLI_LM_Pos)                          /*!< GPDMA C2LLI: LM Mask                    */
#define GPDMA_C2LLI_R_Pos                     1                                                       /*!< GPDMA C2LLI: R Position                 */
#define GPDMA_C2LLI_R_Msk                     (0x01UL << GPDMA_C2LLI_R_Pos)                           /*!< GPDMA C2LLI: R Mask                     */
#define GPDMA_C2LLI_LLI_Pos                   2                                                       /*!< GPDMA C2LLI: LLI Position               */
#define GPDMA_C2LLI_LLI_Msk                   (0x3fffffffUL << GPDMA_C2LLI_LLI_Pos)                   /*!< GPDMA C2LLI: LLI Mask                   */

/* -------------------------------  GPDMA_C2CONTROL  ------------------------------ */
#define GPDMA_C2CONTROL_TRANSFERSIZE_Pos      0                                                       /*!< GPDMA C2CONTROL: TRANSFERSIZE Position  */
#define GPDMA_C2CONTROL_TRANSFERSIZE_Msk      (0x00000fffUL << GPDMA_C2CONTROL_TRANSFERSIZE_Pos)      /*!< GPDMA C2CONTROL: TRANSFERSIZE Mask      */
#define GPDMA_C2CONTROL_SBSIZE_Pos            12                                                      /*!< GPDMA C2CONTROL: SBSIZE Position        */
#define GPDMA_C2CONTROL_SBSIZE_Msk            (0x07UL << GPDMA_C2CONTROL_SBSIZE_Pos)                  /*!< GPDMA C2CONTROL: SBSIZE Mask            */
#define GPDMA_C2CONTROL_DBSIZE_Pos            15                                                      /*!< GPDMA C2CONTROL: DBSIZE Position        */
#define GPDMA_C2CONTROL_DBSIZE_Msk            (0x07UL << GPDMA_C2CONTROL_DBSIZE_Pos)                  /*!< GPDMA C2CONTROL: DBSIZE Mask            */
#define GPDMA_C2CONTROL_SWIDTH_Pos            18                                                      /*!< GPDMA C2CONTROL: SWIDTH Position        */
#define GPDMA_C2CONTROL_SWIDTH_Msk            (0x07UL << GPDMA_C2CONTROL_SWIDTH_Pos)                  /*!< GPDMA C2CONTROL: SWIDTH Mask            */
#define GPDMA_C2CONTROL_DWIDTH_Pos            21                                                      /*!< GPDMA C2CONTROL: DWIDTH Position        */
#define GPDMA_C2CONTROL_DWIDTH_Msk            (0x07UL << GPDMA_C2CONTROL_DWIDTH_Pos)                  /*!< GPDMA C2CONTROL: DWIDTH Mask            */
#define GPDMA_C2CONTROL_S_Pos                 24                                                      /*!< GPDMA C2CONTROL: S Position             */
#define GPDMA_C2CONTROL_S_Msk                 (0x01UL << GPDMA_C2CONTROL_S_Pos)                       /*!< GPDMA C2CONTROL: S Mask                 */
#define GPDMA_C2CONTROL_D_Pos                 25                                                      /*!< GPDMA C2CONTROL: D Position             */
#define GPDMA_C2CONTROL_D_Msk                 (0x01UL << GPDMA_C2CONTROL_D_Pos)                       /*!< GPDMA C2CONTROL: D Mask                 */
#define GPDMA_C2CONTROL_SI_Pos                26                                                      /*!< GPDMA C2CONTROL: SI Position            */
#define GPDMA_C2CONTROL_SI_Msk                (0x01UL << GPDMA_C2CONTROL_SI_Pos)                      /*!< GPDMA C2CONTROL: SI Mask                */
#define GPDMA_C2CONTROL_DI_Pos                27                                                      /*!< GPDMA C2CONTROL: DI Position            */
#define GPDMA_C2CONTROL_DI_Msk                (0x01UL << GPDMA_C2CONTROL_DI_Pos)                      /*!< GPDMA C2CONTROL: DI Mask                */
#define GPDMA_C2CONTROL_PROT1_Pos             28                                                      /*!< GPDMA C2CONTROL: PROT1 Position         */
#define GPDMA_C2CONTROL_PROT1_Msk             (0x01UL << GPDMA_C2CONTROL_PROT1_Pos)                   /*!< GPDMA C2CONTROL: PROT1 Mask             */
#define GPDMA_C2CONTROL_PROT2_Pos             29                                                      /*!< GPDMA C2CONTROL: PROT2 Position         */
#define GPDMA_C2CONTROL_PROT2_Msk             (0x01UL << GPDMA_C2CONTROL_PROT2_Pos)                   /*!< GPDMA C2CONTROL: PROT2 Mask             */
#define GPDMA_C2CONTROL_PROT3_Pos             30                                                      /*!< GPDMA C2CONTROL: PROT3 Position         */
#define GPDMA_C2CONTROL_PROT3_Msk             (0x01UL << GPDMA_C2CONTROL_PROT3_Pos)                   /*!< GPDMA C2CONTROL: PROT3 Mask             */
#define GPDMA_C2CONTROL_I_Pos                 31                                                      /*!< GPDMA C2CONTROL: I Position             */
#define GPDMA_C2CONTROL_I_Msk                 (0x01UL << GPDMA_C2CONTROL_I_Pos)                       /*!< GPDMA C2CONTROL: I Mask                 */

/* -------------------------------  GPDMA_C2CONFIG  ------------------------------- */
#define GPDMA_C2CONFIG_E_Pos                  0                                                       /*!< GPDMA C2CONFIG: E Position              */
#define GPDMA_C2CONFIG_E_Msk                  (0x01UL << GPDMA_C2CONFIG_E_Pos)                        /*!< GPDMA C2CONFIG: E Mask                  */
#define GPDMA_C2CONFIG_SRCPERIPHERAL_Pos      1                                                       /*!< GPDMA C2CONFIG: SRCPERIPHERAL Position  */
#define GPDMA_C2CONFIG_SRCPERIPHERAL_Msk      (0x1fUL << GPDMA_C2CONFIG_SRCPERIPHERAL_Pos)            /*!< GPDMA C2CONFIG: SRCPERIPHERAL Mask      */
#define GPDMA_C2CONFIG_DESTPERIPHERAL_Pos     6                                                       /*!< GPDMA C2CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C2CONFIG_DESTPERIPHERAL_Msk     (0x1fUL << GPDMA_C2CONFIG_DESTPERIPHERAL_Pos)           /*!< GPDMA C2CONFIG: DESTPERIPHERAL Mask     */
#define GPDMA_C2CONFIG_FLOWCNTRL_Pos          11                                                      /*!< GPDMA C2CONFIG: FLOWCNTRL Position      */
#define GPDMA_C2CONFIG_FLOWCNTRL_Msk          (0x07UL << GPDMA_C2CONFIG_FLOWCNTRL_Pos)                /*!< GPDMA C2CONFIG: FLOWCNTRL Mask          */
#define GPDMA_C2CONFIG_IE_Pos                 14                                                      /*!< GPDMA C2CONFIG: IE Position             */
#define GPDMA_C2CONFIG_IE_Msk                 (0x01UL << GPDMA_C2CONFIG_IE_Pos)                       /*!< GPDMA C2CONFIG: IE Mask                 */
#define GPDMA_C2CONFIG_ITC_Pos                15                                                      /*!< GPDMA C2CONFIG: ITC Position            */
#define GPDMA_C2CONFIG_ITC_Msk                (0x01UL << GPDMA_C2CONFIG_ITC_Pos)                      /*!< GPDMA C2CONFIG: ITC Mask                */
#define GPDMA_C2CONFIG_L_Pos                  16                                                      /*!< GPDMA C2CONFIG: L Position              */
#define GPDMA_C2CONFIG_L_Msk                  (0x01UL << GPDMA_C2CONFIG_L_Pos)                        /*!< GPDMA C2CONFIG: L Mask                  */
#define GPDMA_C2CONFIG_A_Pos                  17                                                      /*!< GPDMA C2CONFIG: A Position              */
#define GPDMA_C2CONFIG_A_Msk                  (0x01UL << GPDMA_C2CONFIG_A_Pos)                        /*!< GPDMA C2CONFIG: A Mask                  */
#define GPDMA_C2CONFIG_H_Pos                  18                                                      /*!< GPDMA C2CONFIG: H Position              */
#define GPDMA_C2CONFIG_H_Msk                  (0x01UL << GPDMA_C2CONFIG_H_Pos)                        /*!< GPDMA C2CONFIG: H Mask                  */

/* -------------------------------  GPDMA_C3SRCADDR  ------------------------------ */
#define GPDMA_C3SRCADDR_SRCADDR_Pos           0                                                       /*!< GPDMA C3SRCADDR: SRCADDR Position       */
#define GPDMA_C3SRCADDR_SRCADDR_Msk           (0xffffffffUL << GPDMA_C3SRCADDR_SRCADDR_Pos)           /*!< GPDMA C3SRCADDR: SRCADDR Mask           */

/* ------------------------------  GPDMA_C3DESTADDR  ------------------------------ */
#define GPDMA_C3DESTADDR_DESTADDR_Pos         0                                                       /*!< GPDMA C3DESTADDR: DESTADDR Position     */
#define GPDMA_C3DESTADDR_DESTADDR_Msk         (0xffffffffUL << GPDMA_C3DESTADDR_DESTADDR_Pos)         /*!< GPDMA C3DESTADDR: DESTADDR Mask         */

/* ---------------------------------  GPDMA_C3LLI  -------------------------------- */
#define GPDMA_C3LLI_LM_Pos                    0                                                       /*!< GPDMA C3LLI: LM Position                */
#define GPDMA_C3LLI_LM_Msk                    (0x01UL << GPDMA_C3LLI_LM_Pos)                          /*!< GPDMA C3LLI: LM Mask                    */
#define GPDMA_C3LLI_R_Pos                     1                                                       /*!< GPDMA C3LLI: R Position                 */
#define GPDMA_C3LLI_R_Msk                     (0x01UL << GPDMA_C3LLI_R_Pos)                           /*!< GPDMA C3LLI: R Mask                     */
#define GPDMA_C3LLI_LLI_Pos                   2                                                       /*!< GPDMA C3LLI: LLI Position               */
#define GPDMA_C3LLI_LLI_Msk                   (0x3fffffffUL << GPDMA_C3LLI_LLI_Pos)                   /*!< GPDMA C3LLI: LLI Mask                   */

/* -------------------------------  GPDMA_C3CONTROL  ------------------------------ */
#define GPDMA_C3CONTROL_TRANSFERSIZE_Pos      0                                                       /*!< GPDMA C3CONTROL: TRANSFERSIZE Position  */
#define GPDMA_C3CONTROL_TRANSFERSIZE_Msk      (0x00000fffUL << GPDMA_C3CONTROL_TRANSFERSIZE_Pos)      /*!< GPDMA C3CONTROL: TRANSFERSIZE Mask      */
#define GPDMA_C3CONTROL_SBSIZE_Pos            12                                                      /*!< GPDMA C3CONTROL: SBSIZE Position        */
#define GPDMA_C3CONTROL_SBSIZE_Msk            (0x07UL << GPDMA_C3CONTROL_SBSIZE_Pos)                  /*!< GPDMA C3CONTROL: SBSIZE Mask            */
#define GPDMA_C3CONTROL_DBSIZE_Pos            15                                                      /*!< GPDMA C3CONTROL: DBSIZE Position        */
#define GPDMA_C3CONTROL_DBSIZE_Msk            (0x07UL << GPDMA_C3CONTROL_DBSIZE_Pos)                  /*!< GPDMA C3CONTROL: DBSIZE Mask            */
#define GPDMA_C3CONTROL_SWIDTH_Pos            18                                                      /*!< GPDMA C3CONTROL: SWIDTH Position        */
#define GPDMA_C3CONTROL_SWIDTH_Msk            (0x07UL << GPDMA_C3CONTROL_SWIDTH_Pos)                  /*!< GPDMA C3CONTROL: SWIDTH Mask            */
#define GPDMA_C3CONTROL_DWIDTH_Pos            21                                                      /*!< GPDMA C3CONTROL: DWIDTH Position        */
#define GPDMA_C3CONTROL_DWIDTH_Msk            (0x07UL << GPDMA_C3CONTROL_DWIDTH_Pos)                  /*!< GPDMA C3CONTROL: DWIDTH Mask            */
#define GPDMA_C3CONTROL_S_Pos                 24                                                      /*!< GPDMA C3CONTROL: S Position             */
#define GPDMA_C3CONTROL_S_Msk                 (0x01UL << GPDMA_C3CONTROL_S_Pos)                       /*!< GPDMA C3CONTROL: S Mask                 */
#define GPDMA_C3CONTROL_D_Pos                 25                                                      /*!< GPDMA C3CONTROL: D Position             */
#define GPDMA_C3CONTROL_D_Msk                 (0x01UL << GPDMA_C3CONTROL_D_Pos)                       /*!< GPDMA C3CONTROL: D Mask                 */
#define GPDMA_C3CONTROL_SI_Pos                26                                                      /*!< GPDMA C3CONTROL: SI Position            */
#define GPDMA_C3CONTROL_SI_Msk                (0x01UL << GPDMA_C3CONTROL_SI_Pos)                      /*!< GPDMA C3CONTROL: SI Mask                */
#define GPDMA_C3CONTROL_DI_Pos                27                                                      /*!< GPDMA C3CONTROL: DI Position            */
#define GPDMA_C3CONTROL_DI_Msk                (0x01UL << GPDMA_C3CONTROL_DI_Pos)                      /*!< GPDMA C3CONTROL: DI Mask                */
#define GPDMA_C3CONTROL_PROT1_Pos             28                                                      /*!< GPDMA C3CONTROL: PROT1 Position         */
#define GPDMA_C3CONTROL_PROT1_Msk             (0x01UL << GPDMA_C3CONTROL_PROT1_Pos)                   /*!< GPDMA C3CONTROL: PROT1 Mask             */
#define GPDMA_C3CONTROL_PROT2_Pos             29                                                      /*!< GPDMA C3CONTROL: PROT2 Position         */
#define GPDMA_C3CONTROL_PROT2_Msk             (0x01UL << GPDMA_C3CONTROL_PROT2_Pos)                   /*!< GPDMA C3CONTROL: PROT2 Mask             */
#define GPDMA_C3CONTROL_PROT3_Pos             30                                                      /*!< GPDMA C3CONTROL: PROT3 Position         */
#define GPDMA_C3CONTROL_PROT3_Msk             (0x01UL << GPDMA_C3CONTROL_PROT3_Pos)                   /*!< GPDMA C3CONTROL: PROT3 Mask             */
#define GPDMA_C3CONTROL_I_Pos                 31                                                      /*!< GPDMA C3CONTROL: I Position             */
#define GPDMA_C3CONTROL_I_Msk                 (0x01UL << GPDMA_C3CONTROL_I_Pos)                       /*!< GPDMA C3CONTROL: I Mask                 */

/* -------------------------------  GPDMA_C3CONFIG  ------------------------------- */
#define GPDMA_C3CONFIG_E_Pos                  0                                                       /*!< GPDMA C3CONFIG: E Position              */
#define GPDMA_C3CONFIG_E_Msk                  (0x01UL << GPDMA_C3CONFIG_E_Pos)                        /*!< GPDMA C3CONFIG: E Mask                  */
#define GPDMA_C3CONFIG_SRCPERIPHERAL_Pos      1                                                       /*!< GPDMA C3CONFIG: SRCPERIPHERAL Position  */
#define GPDMA_C3CONFIG_SRCPERIPHERAL_Msk      (0x1fUL << GPDMA_C3CONFIG_SRCPERIPHERAL_Pos)            /*!< GPDMA C3CONFIG: SRCPERIPHERAL Mask      */
#define GPDMA_C3CONFIG_DESTPERIPHERAL_Pos     6                                                       /*!< GPDMA C3CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C3CONFIG_DESTPERIPHERAL_Msk     (0x1fUL << GPDMA_C3CONFIG_DESTPERIPHERAL_Pos)           /*!< GPDMA C3CONFIG: DESTPERIPHERAL Mask     */
#define GPDMA_C3CONFIG_FLOWCNTRL_Pos          11                                                      /*!< GPDMA C3CONFIG: FLOWCNTRL Position      */
#define GPDMA_C3CONFIG_FLOWCNTRL_Msk          (0x07UL << GPDMA_C3CONFIG_FLOWCNTRL_Pos)                /*!< GPDMA C3CONFIG: FLOWCNTRL Mask          */
#define GPDMA_C3CONFIG_IE_Pos                 14                                                      /*!< GPDMA C3CONFIG: IE Position             */
#define GPDMA_C3CONFIG_IE_Msk                 (0x01UL << GPDMA_C3CONFIG_IE_Pos)                       /*!< GPDMA C3CONFIG: IE Mask                 */
#define GPDMA_C3CONFIG_ITC_Pos                15                                                      /*!< GPDMA C3CONFIG: ITC Position            */
#define GPDMA_C3CONFIG_ITC_Msk                (0x01UL << GPDMA_C3CONFIG_ITC_Pos)                      /*!< GPDMA C3CONFIG: ITC Mask                */
#define GPDMA_C3CONFIG_L_Pos                  16                                                      /*!< GPDMA C3CONFIG: L Position              */
#define GPDMA_C3CONFIG_L_Msk                  (0x01UL << GPDMA_C3CONFIG_L_Pos)                        /*!< GPDMA C3CONFIG: L Mask                  */
#define GPDMA_C3CONFIG_A_Pos                  17                                                      /*!< GPDMA C3CONFIG: A Position              */
#define GPDMA_C3CONFIG_A_Msk                  (0x01UL << GPDMA_C3CONFIG_A_Pos)                        /*!< GPDMA C3CONFIG: A Mask                  */
#define GPDMA_C3CONFIG_H_Pos                  18                                                      /*!< GPDMA C3CONFIG: H Position              */
#define GPDMA_C3CONFIG_H_Msk                  (0x01UL << GPDMA_C3CONFIG_H_Pos)                        /*!< GPDMA C3CONFIG: H Mask                  */

/* -------------------------------  GPDMA_C4SRCADDR  ------------------------------ */
#define GPDMA_C4SRCADDR_SRCADDR_Pos           0                                                       /*!< GPDMA C4SRCADDR: SRCADDR Position       */
#define GPDMA_C4SRCADDR_SRCADDR_Msk           (0xffffffffUL << GPDMA_C4SRCADDR_SRCADDR_Pos)           /*!< GPDMA C4SRCADDR: SRCADDR Mask           */

/* ------------------------------  GPDMA_C4DESTADDR  ------------------------------ */
#define GPDMA_C4DESTADDR_DESTADDR_Pos         0                                                       /*!< GPDMA C4DESTADDR: DESTADDR Position     */
#define GPDMA_C4DESTADDR_DESTADDR_Msk         (0xffffffffUL << GPDMA_C4DESTADDR_DESTADDR_Pos)         /*!< GPDMA C4DESTADDR: DESTADDR Mask         */

/* ---------------------------------  GPDMA_C4LLI  -------------------------------- */
#define GPDMA_C4LLI_LM_Pos                    0                                                       /*!< GPDMA C4LLI: LM Position                */
#define GPDMA_C4LLI_LM_Msk                    (0x01UL << GPDMA_C4LLI_LM_Pos)                          /*!< GPDMA C4LLI: LM Mask                    */
#define GPDMA_C4LLI_R_Pos                     1                                                       /*!< GPDMA C4LLI: R Position                 */
#define GPDMA_C4LLI_R_Msk                     (0x01UL << GPDMA_C4LLI_R_Pos)                           /*!< GPDMA C4LLI: R Mask                     */
#define GPDMA_C4LLI_LLI_Pos                   2                                                       /*!< GPDMA C4LLI: LLI Position               */
#define GPDMA_C4LLI_LLI_Msk                   (0x3fffffffUL << GPDMA_C4LLI_LLI_Pos)                   /*!< GPDMA C4LLI: LLI Mask                   */

/* -------------------------------  GPDMA_C4CONTROL  ------------------------------ */
#define GPDMA_C4CONTROL_TRANSFERSIZE_Pos      0                                                       /*!< GPDMA C4CONTROL: TRANSFERSIZE Position  */
#define GPDMA_C4CONTROL_TRANSFERSIZE_Msk      (0x00000fffUL << GPDMA_C4CONTROL_TRANSFERSIZE_Pos)      /*!< GPDMA C4CONTROL: TRANSFERSIZE Mask      */
#define GPDMA_C4CONTROL_SBSIZE_Pos            12                                                      /*!< GPDMA C4CONTROL: SBSIZE Position        */
#define GPDMA_C4CONTROL_SBSIZE_Msk            (0x07UL << GPDMA_C4CONTROL_SBSIZE_Pos)                  /*!< GPDMA C4CONTROL: SBSIZE Mask            */
#define GPDMA_C4CONTROL_DBSIZE_Pos            15                                                      /*!< GPDMA C4CONTROL: DBSIZE Position        */
#define GPDMA_C4CONTROL_DBSIZE_Msk            (0x07UL << GPDMA_C4CONTROL_DBSIZE_Pos)                  /*!< GPDMA C4CONTROL: DBSIZE Mask            */
#define GPDMA_C4CONTROL_SWIDTH_Pos            18                                                      /*!< GPDMA C4CONTROL: SWIDTH Position        */
#define GPDMA_C4CONTROL_SWIDTH_Msk            (0x07UL << GPDMA_C4CONTROL_SWIDTH_Pos)                  /*!< GPDMA C4CONTROL: SWIDTH Mask            */
#define GPDMA_C4CONTROL_DWIDTH_Pos            21                                                      /*!< GPDMA C4CONTROL: DWIDTH Position        */
#define GPDMA_C4CONTROL_DWIDTH_Msk            (0x07UL << GPDMA_C4CONTROL_DWIDTH_Pos)                  /*!< GPDMA C4CONTROL: DWIDTH Mask            */
#define GPDMA_C4CONTROL_S_Pos                 24                                                      /*!< GPDMA C4CONTROL: S Position             */
#define GPDMA_C4CONTROL_S_Msk                 (0x01UL << GPDMA_C4CONTROL_S_Pos)                       /*!< GPDMA C4CONTROL: S Mask                 */
#define GPDMA_C4CONTROL_D_Pos                 25                                                      /*!< GPDMA C4CONTROL: D Position             */
#define GPDMA_C4CONTROL_D_Msk                 (0x01UL << GPDMA_C4CONTROL_D_Pos)                       /*!< GPDMA C4CONTROL: D Mask                 */
#define GPDMA_C4CONTROL_SI_Pos                26                                                      /*!< GPDMA C4CONTROL: SI Position            */
#define GPDMA_C4CONTROL_SI_Msk                (0x01UL << GPDMA_C4CONTROL_SI_Pos)                      /*!< GPDMA C4CONTROL: SI Mask                */
#define GPDMA_C4CONTROL_DI_Pos                27                                                      /*!< GPDMA C4CONTROL: DI Position            */
#define GPDMA_C4CONTROL_DI_Msk                (0x01UL << GPDMA_C4CONTROL_DI_Pos)                      /*!< GPDMA C4CONTROL: DI Mask                */
#define GPDMA_C4CONTROL_PROT1_Pos             28                                                      /*!< GPDMA C4CONTROL: PROT1 Position         */
#define GPDMA_C4CONTROL_PROT1_Msk             (0x01UL << GPDMA_C4CONTROL_PROT1_Pos)                   /*!< GPDMA C4CONTROL: PROT1 Mask             */
#define GPDMA_C4CONTROL_PROT2_Pos             29                                                      /*!< GPDMA C4CONTROL: PROT2 Position         */
#define GPDMA_C4CONTROL_PROT2_Msk             (0x01UL << GPDMA_C4CONTROL_PROT2_Pos)                   /*!< GPDMA C4CONTROL: PROT2 Mask             */
#define GPDMA_C4CONTROL_PROT3_Pos             30                                                      /*!< GPDMA C4CONTROL: PROT3 Position         */
#define GPDMA_C4CONTROL_PROT3_Msk             (0x01UL << GPDMA_C4CONTROL_PROT3_Pos)                   /*!< GPDMA C4CONTROL: PROT3 Mask             */
#define GPDMA_C4CONTROL_I_Pos                 31                                                      /*!< GPDMA C4CONTROL: I Position             */
#define GPDMA_C4CONTROL_I_Msk                 (0x01UL << GPDMA_C4CONTROL_I_Pos)                       /*!< GPDMA C4CONTROL: I Mask                 */

/* -------------------------------  GPDMA_C4CONFIG  ------------------------------- */
#define GPDMA_C4CONFIG_E_Pos                  0                                                       /*!< GPDMA C4CONFIG: E Position              */
#define GPDMA_C4CONFIG_E_Msk                  (0x01UL << GPDMA_C4CONFIG_E_Pos)                        /*!< GPDMA C4CONFIG: E Mask                  */
#define GPDMA_C4CONFIG_SRCPERIPHERAL_Pos      1                                                       /*!< GPDMA C4CONFIG: SRCPERIPHERAL Position  */
#define GPDMA_C4CONFIG_SRCPERIPHERAL_Msk      (0x1fUL << GPDMA_C4CONFIG_SRCPERIPHERAL_Pos)            /*!< GPDMA C4CONFIG: SRCPERIPHERAL Mask      */
#define GPDMA_C4CONFIG_DESTPERIPHERAL_Pos     6                                                       /*!< GPDMA C4CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C4CONFIG_DESTPERIPHERAL_Msk     (0x1fUL << GPDMA_C4CONFIG_DESTPERIPHERAL_Pos)           /*!< GPDMA C4CONFIG: DESTPERIPHERAL Mask     */
#define GPDMA_C4CONFIG_FLOWCNTRL_Pos          11                                                      /*!< GPDMA C4CONFIG: FLOWCNTRL Position      */
#define GPDMA_C4CONFIG_FLOWCNTRL_Msk          (0x07UL << GPDMA_C4CONFIG_FLOWCNTRL_Pos)                /*!< GPDMA C4CONFIG: FLOWCNTRL Mask          */
#define GPDMA_C4CONFIG_IE_Pos                 14                                                      /*!< GPDMA C4CONFIG: IE Position             */
#define GPDMA_C4CONFIG_IE_Msk                 (0x01UL << GPDMA_C4CONFIG_IE_Pos)                       /*!< GPDMA C4CONFIG: IE Mask                 */
#define GPDMA_C4CONFIG_ITC_Pos                15                                                      /*!< GPDMA C4CONFIG: ITC Position            */
#define GPDMA_C4CONFIG_ITC_Msk                (0x01UL << GPDMA_C4CONFIG_ITC_Pos)                      /*!< GPDMA C4CONFIG: ITC Mask                */
#define GPDMA_C4CONFIG_L_Pos                  16                                                      /*!< GPDMA C4CONFIG: L Position              */
#define GPDMA_C4CONFIG_L_Msk                  (0x01UL << GPDMA_C4CONFIG_L_Pos)                        /*!< GPDMA C4CONFIG: L Mask                  */
#define GPDMA_C4CONFIG_A_Pos                  17                                                      /*!< GPDMA C4CONFIG: A Position              */
#define GPDMA_C4CONFIG_A_Msk                  (0x01UL << GPDMA_C4CONFIG_A_Pos)                        /*!< GPDMA C4CONFIG: A Mask                  */
#define GPDMA_C4CONFIG_H_Pos                  18                                                      /*!< GPDMA C4CONFIG: H Position              */
#define GPDMA_C4CONFIG_H_Msk                  (0x01UL << GPDMA_C4CONFIG_H_Pos)                        /*!< GPDMA C4CONFIG: H Mask                  */

/* -------------------------------  GPDMA_C5SRCADDR  ------------------------------ */
#define GPDMA_C5SRCADDR_SRCADDR_Pos           0                                                       /*!< GPDMA C5SRCADDR: SRCADDR Position       */
#define GPDMA_C5SRCADDR_SRCADDR_Msk           (0xffffffffUL << GPDMA_C5SRCADDR_SRCADDR_Pos)           /*!< GPDMA C5SRCADDR: SRCADDR Mask           */

/* ------------------------------  GPDMA_C5DESTADDR  ------------------------------ */
#define GPDMA_C5DESTADDR_DESTADDR_Pos         0                                                       /*!< GPDMA C5DESTADDR: DESTADDR Position     */
#define GPDMA_C5DESTADDR_DESTADDR_Msk         (0xffffffffUL << GPDMA_C5DESTADDR_DESTADDR_Pos)         /*!< GPDMA C5DESTADDR: DESTADDR Mask         */

/* ---------------------------------  GPDMA_C5LLI  -------------------------------- */
#define GPDMA_C5LLI_LM_Pos                    0                                                       /*!< GPDMA C5LLI: LM Position                */
#define GPDMA_C5LLI_LM_Msk                    (0x01UL << GPDMA_C5LLI_LM_Pos)                          /*!< GPDMA C5LLI: LM Mask                    */
#define GPDMA_C5LLI_R_Pos                     1                                                       /*!< GPDMA C5LLI: R Position                 */
#define GPDMA_C5LLI_R_Msk                     (0x01UL << GPDMA_C5LLI_R_Pos)                           /*!< GPDMA C5LLI: R Mask                     */
#define GPDMA_C5LLI_LLI_Pos                   2                                                       /*!< GPDMA C5LLI: LLI Position               */
#define GPDMA_C5LLI_LLI_Msk                   (0x3fffffffUL << GPDMA_C5LLI_LLI_Pos)                   /*!< GPDMA C5LLI: LLI Mask                   */

/* -------------------------------  GPDMA_C5CONTROL  ------------------------------ */
#define GPDMA_C5CONTROL_TRANSFERSIZE_Pos      0                                                       /*!< GPDMA C5CONTROL: TRANSFERSIZE Position  */
#define GPDMA_C5CONTROL_TRANSFERSIZE_Msk      (0x00000fffUL << GPDMA_C5CONTROL_TRANSFERSIZE_Pos)      /*!< GPDMA C5CONTROL: TRANSFERSIZE Mask      */
#define GPDMA_C5CONTROL_SBSIZE_Pos            12                                                      /*!< GPDMA C5CONTROL: SBSIZE Position        */
#define GPDMA_C5CONTROL_SBSIZE_Msk            (0x07UL << GPDMA_C5CONTROL_SBSIZE_Pos)                  /*!< GPDMA C5CONTROL: SBSIZE Mask            */
#define GPDMA_C5CONTROL_DBSIZE_Pos            15                                                      /*!< GPDMA C5CONTROL: DBSIZE Position        */
#define GPDMA_C5CONTROL_DBSIZE_Msk            (0x07UL << GPDMA_C5CONTROL_DBSIZE_Pos)                  /*!< GPDMA C5CONTROL: DBSIZE Mask            */
#define GPDMA_C5CONTROL_SWIDTH_Pos            18                                                      /*!< GPDMA C5CONTROL: SWIDTH Position        */
#define GPDMA_C5CONTROL_SWIDTH_Msk            (0x07UL << GPDMA_C5CONTROL_SWIDTH_Pos)                  /*!< GPDMA C5CONTROL: SWIDTH Mask            */
#define GPDMA_C5CONTROL_DWIDTH_Pos            21                                                      /*!< GPDMA C5CONTROL: DWIDTH Position        */
#define GPDMA_C5CONTROL_DWIDTH_Msk            (0x07UL << GPDMA_C5CONTROL_DWIDTH_Pos)                  /*!< GPDMA C5CONTROL: DWIDTH Mask            */
#define GPDMA_C5CONTROL_S_Pos                 24                                                      /*!< GPDMA C5CONTROL: S Position             */
#define GPDMA_C5CONTROL_S_Msk                 (0x01UL << GPDMA_C5CONTROL_S_Pos)                       /*!< GPDMA C5CONTROL: S Mask                 */
#define GPDMA_C5CONTROL_D_Pos                 25                                                      /*!< GPDMA C5CONTROL: D Position             */
#define GPDMA_C5CONTROL_D_Msk                 (0x01UL << GPDMA_C5CONTROL_D_Pos)                       /*!< GPDMA C5CONTROL: D Mask                 */
#define GPDMA_C5CONTROL_SI_Pos                26                                                      /*!< GPDMA C5CONTROL: SI Position            */
#define GPDMA_C5CONTROL_SI_Msk                (0x01UL << GPDMA_C5CONTROL_SI_Pos)                      /*!< GPDMA C5CONTROL: SI Mask                */
#define GPDMA_C5CONTROL_DI_Pos                27                                                      /*!< GPDMA C5CONTROL: DI Position            */
#define GPDMA_C5CONTROL_DI_Msk                (0x01UL << GPDMA_C5CONTROL_DI_Pos)                      /*!< GPDMA C5CONTROL: DI Mask                */
#define GPDMA_C5CONTROL_PROT1_Pos             28                                                      /*!< GPDMA C5CONTROL: PROT1 Position         */
#define GPDMA_C5CONTROL_PROT1_Msk             (0x01UL << GPDMA_C5CONTROL_PROT1_Pos)                   /*!< GPDMA C5CONTROL: PROT1 Mask             */
#define GPDMA_C5CONTROL_PROT2_Pos             29                                                      /*!< GPDMA C5CONTROL: PROT2 Position         */
#define GPDMA_C5CONTROL_PROT2_Msk             (0x01UL << GPDMA_C5CONTROL_PROT2_Pos)                   /*!< GPDMA C5CONTROL: PROT2 Mask             */
#define GPDMA_C5CONTROL_PROT3_Pos             30                                                      /*!< GPDMA C5CONTROL: PROT3 Position         */
#define GPDMA_C5CONTROL_PROT3_Msk             (0x01UL << GPDMA_C5CONTROL_PROT3_Pos)                   /*!< GPDMA C5CONTROL: PROT3 Mask             */
#define GPDMA_C5CONTROL_I_Pos                 31                                                      /*!< GPDMA C5CONTROL: I Position             */
#define GPDMA_C5CONTROL_I_Msk                 (0x01UL << GPDMA_C5CONTROL_I_Pos)                       /*!< GPDMA C5CONTROL: I Mask                 */

/* -------------------------------  GPDMA_C5CONFIG  ------------------------------- */
#define GPDMA_C5CONFIG_E_Pos                  0                                                       /*!< GPDMA C5CONFIG: E Position              */
#define GPDMA_C5CONFIG_E_Msk                  (0x01UL << GPDMA_C5CONFIG_E_Pos)                        /*!< GPDMA C5CONFIG: E Mask                  */
#define GPDMA_C5CONFIG_SRCPERIPHERAL_Pos      1                                                       /*!< GPDMA C5CONFIG: SRCPERIPHERAL Position  */
#define GPDMA_C5CONFIG_SRCPERIPHERAL_Msk      (0x1fUL << GPDMA_C5CONFIG_SRCPERIPHERAL_Pos)            /*!< GPDMA C5CONFIG: SRCPERIPHERAL Mask      */
#define GPDMA_C5CONFIG_DESTPERIPHERAL_Pos     6                                                       /*!< GPDMA C5CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C5CONFIG_DESTPERIPHERAL_Msk     (0x1fUL << GPDMA_C5CONFIG_DESTPERIPHERAL_Pos)           /*!< GPDMA C5CONFIG: DESTPERIPHERAL Mask     */
#define GPDMA_C5CONFIG_FLOWCNTRL_Pos          11                                                      /*!< GPDMA C5CONFIG: FLOWCNTRL Position      */
#define GPDMA_C5CONFIG_FLOWCNTRL_Msk          (0x07UL << GPDMA_C5CONFIG_FLOWCNTRL_Pos)                /*!< GPDMA C5CONFIG: FLOWCNTRL Mask          */
#define GPDMA_C5CONFIG_IE_Pos                 14                                                      /*!< GPDMA C5CONFIG: IE Position             */
#define GPDMA_C5CONFIG_IE_Msk                 (0x01UL << GPDMA_C5CONFIG_IE_Pos)                       /*!< GPDMA C5CONFIG: IE Mask                 */
#define GPDMA_C5CONFIG_ITC_Pos                15                                                      /*!< GPDMA C5CONFIG: ITC Position            */
#define GPDMA_C5CONFIG_ITC_Msk                (0x01UL << GPDMA_C5CONFIG_ITC_Pos)                      /*!< GPDMA C5CONFIG: ITC Mask                */
#define GPDMA_C5CONFIG_L_Pos                  16                                                      /*!< GPDMA C5CONFIG: L Position              */
#define GPDMA_C5CONFIG_L_Msk                  (0x01UL << GPDMA_C5CONFIG_L_Pos)                        /*!< GPDMA C5CONFIG: L Mask                  */
#define GPDMA_C5CONFIG_A_Pos                  17                                                      /*!< GPDMA C5CONFIG: A Position              */
#define GPDMA_C5CONFIG_A_Msk                  (0x01UL << GPDMA_C5CONFIG_A_Pos)                        /*!< GPDMA C5CONFIG: A Mask                  */
#define GPDMA_C5CONFIG_H_Pos                  18                                                      /*!< GPDMA C5CONFIG: H Position              */
#define GPDMA_C5CONFIG_H_Msk                  (0x01UL << GPDMA_C5CONFIG_H_Pos)                        /*!< GPDMA C5CONFIG: H Mask                  */

/* -------------------------------  GPDMA_C6SRCADDR  ------------------------------ */
#define GPDMA_C6SRCADDR_SRCADDR_Pos           0                                                       /*!< GPDMA C6SRCADDR: SRCADDR Position       */
#define GPDMA_C6SRCADDR_SRCADDR_Msk           (0xffffffffUL << GPDMA_C6SRCADDR_SRCADDR_Pos)           /*!< GPDMA C6SRCADDR: SRCADDR Mask           */

/* ------------------------------  GPDMA_C6DESTADDR  ------------------------------ */
#define GPDMA_C6DESTADDR_DESTADDR_Pos         0                                                       /*!< GPDMA C6DESTADDR: DESTADDR Position     */
#define GPDMA_C6DESTADDR_DESTADDR_Msk         (0xffffffffUL << GPDMA_C6DESTADDR_DESTADDR_Pos)         /*!< GPDMA C6DESTADDR: DESTADDR Mask         */

/* ---------------------------------  GPDMA_C6LLI  -------------------------------- */
#define GPDMA_C6LLI_LM_Pos                    0                                                       /*!< GPDMA C6LLI: LM Position                */
#define GPDMA_C6LLI_LM_Msk                    (0x01UL << GPDMA_C6LLI_LM_Pos)                          /*!< GPDMA C6LLI: LM Mask                    */
#define GPDMA_C6LLI_R_Pos                     1                                                       /*!< GPDMA C6LLI: R Position                 */
#define GPDMA_C6LLI_R_Msk                     (0x01UL << GPDMA_C6LLI_R_Pos)                           /*!< GPDMA C6LLI: R Mask                     */
#define GPDMA_C6LLI_LLI_Pos                   2                                                       /*!< GPDMA C6LLI: LLI Position               */
#define GPDMA_C6LLI_LLI_Msk                   (0x3fffffffUL << GPDMA_C6LLI_LLI_Pos)                   /*!< GPDMA C6LLI: LLI Mask                   */

/* -------------------------------  GPDMA_C6CONTROL  ------------------------------ */
#define GPDMA_C6CONTROL_TRANSFERSIZE_Pos      0                                                       /*!< GPDMA C6CONTROL: TRANSFERSIZE Position  */
#define GPDMA_C6CONTROL_TRANSFERSIZE_Msk      (0x00000fffUL << GPDMA_C6CONTROL_TRANSFERSIZE_Pos)      /*!< GPDMA C6CONTROL: TRANSFERSIZE Mask      */
#define GPDMA_C6CONTROL_SBSIZE_Pos            12                                                      /*!< GPDMA C6CONTROL: SBSIZE Position        */
#define GPDMA_C6CONTROL_SBSIZE_Msk            (0x07UL << GPDMA_C6CONTROL_SBSIZE_Pos)                  /*!< GPDMA C6CONTROL: SBSIZE Mask            */
#define GPDMA_C6CONTROL_DBSIZE_Pos            15                                                      /*!< GPDMA C6CONTROL: DBSIZE Position        */
#define GPDMA_C6CONTROL_DBSIZE_Msk            (0x07UL << GPDMA_C6CONTROL_DBSIZE_Pos)                  /*!< GPDMA C6CONTROL: DBSIZE Mask            */
#define GPDMA_C6CONTROL_SWIDTH_Pos            18                                                      /*!< GPDMA C6CONTROL: SWIDTH Position        */
#define GPDMA_C6CONTROL_SWIDTH_Msk            (0x07UL << GPDMA_C6CONTROL_SWIDTH_Pos)                  /*!< GPDMA C6CONTROL: SWIDTH Mask            */
#define GPDMA_C6CONTROL_DWIDTH_Pos            21                                                      /*!< GPDMA C6CONTROL: DWIDTH Position        */
#define GPDMA_C6CONTROL_DWIDTH_Msk            (0x07UL << GPDMA_C6CONTROL_DWIDTH_Pos)                  /*!< GPDMA C6CONTROL: DWIDTH Mask            */
#define GPDMA_C6CONTROL_S_Pos                 24                                                      /*!< GPDMA C6CONTROL: S Position             */
#define GPDMA_C6CONTROL_S_Msk                 (0x01UL << GPDMA_C6CONTROL_S_Pos)                       /*!< GPDMA C6CONTROL: S Mask                 */
#define GPDMA_C6CONTROL_D_Pos                 25                                                      /*!< GPDMA C6CONTROL: D Position             */
#define GPDMA_C6CONTROL_D_Msk                 (0x01UL << GPDMA_C6CONTROL_D_Pos)                       /*!< GPDMA C6CONTROL: D Mask                 */
#define GPDMA_C6CONTROL_SI_Pos                26                                                      /*!< GPDMA C6CONTROL: SI Position            */
#define GPDMA_C6CONTROL_SI_Msk                (0x01UL << GPDMA_C6CONTROL_SI_Pos)                      /*!< GPDMA C6CONTROL: SI Mask                */
#define GPDMA_C6CONTROL_DI_Pos                27                                                      /*!< GPDMA C6CONTROL: DI Position            */
#define GPDMA_C6CONTROL_DI_Msk                (0x01UL << GPDMA_C6CONTROL_DI_Pos)                      /*!< GPDMA C6CONTROL: DI Mask                */
#define GPDMA_C6CONTROL_PROT1_Pos             28                                                      /*!< GPDMA C6CONTROL: PROT1 Position         */
#define GPDMA_C6CONTROL_PROT1_Msk             (0x01UL << GPDMA_C6CONTROL_PROT1_Pos)                   /*!< GPDMA C6CONTROL: PROT1 Mask             */
#define GPDMA_C6CONTROL_PROT2_Pos             29                                                      /*!< GPDMA C6CONTROL: PROT2 Position         */
#define GPDMA_C6CONTROL_PROT2_Msk             (0x01UL << GPDMA_C6CONTROL_PROT2_Pos)                   /*!< GPDMA C6CONTROL: PROT2 Mask             */
#define GPDMA_C6CONTROL_PROT3_Pos             30                                                      /*!< GPDMA C6CONTROL: PROT3 Position         */
#define GPDMA_C6CONTROL_PROT3_Msk             (0x01UL << GPDMA_C6CONTROL_PROT3_Pos)                   /*!< GPDMA C6CONTROL: PROT3 Mask             */
#define GPDMA_C6CONTROL_I_Pos                 31                                                      /*!< GPDMA C6CONTROL: I Position             */
#define GPDMA_C6CONTROL_I_Msk                 (0x01UL << GPDMA_C6CONTROL_I_Pos)                       /*!< GPDMA C6CONTROL: I Mask                 */

/* -------------------------------  GPDMA_C6CONFIG  ------------------------------- */
#define GPDMA_C6CONFIG_E_Pos                  0                                                       /*!< GPDMA C6CONFIG: E Position              */
#define GPDMA_C6CONFIG_E_Msk                  (0x01UL << GPDMA_C6CONFIG_E_Pos)                        /*!< GPDMA C6CONFIG: E Mask                  */
#define GPDMA_C6CONFIG_SRCPERIPHERAL_Pos      1                                                       /*!< GPDMA C6CONFIG: SRCPERIPHERAL Position  */
#define GPDMA_C6CONFIG_SRCPERIPHERAL_Msk      (0x1fUL << GPDMA_C6CONFIG_SRCPERIPHERAL_Pos)            /*!< GPDMA C6CONFIG: SRCPERIPHERAL Mask      */
#define GPDMA_C6CONFIG_DESTPERIPHERAL_Pos     6                                                       /*!< GPDMA C6CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C6CONFIG_DESTPERIPHERAL_Msk     (0x1fUL << GPDMA_C6CONFIG_DESTPERIPHERAL_Pos)           /*!< GPDMA C6CONFIG: DESTPERIPHERAL Mask     */
#define GPDMA_C6CONFIG_FLOWCNTRL_Pos          11                                                      /*!< GPDMA C6CONFIG: FLOWCNTRL Position      */
#define GPDMA_C6CONFIG_FLOWCNTRL_Msk          (0x07UL << GPDMA_C6CONFIG_FLOWCNTRL_Pos)                /*!< GPDMA C6CONFIG: FLOWCNTRL Mask          */
#define GPDMA_C6CONFIG_IE_Pos                 14                                                      /*!< GPDMA C6CONFIG: IE Position             */
#define GPDMA_C6CONFIG_IE_Msk                 (0x01UL << GPDMA_C6CONFIG_IE_Pos)                       /*!< GPDMA C6CONFIG: IE Mask                 */
#define GPDMA_C6CONFIG_ITC_Pos                15                                                      /*!< GPDMA C6CONFIG: ITC Position            */
#define GPDMA_C6CONFIG_ITC_Msk                (0x01UL << GPDMA_C6CONFIG_ITC_Pos)                      /*!< GPDMA C6CONFIG: ITC Mask                */
#define GPDMA_C6CONFIG_L_Pos                  16                                                      /*!< GPDMA C6CONFIG: L Position              */
#define GPDMA_C6CONFIG_L_Msk                  (0x01UL << GPDMA_C6CONFIG_L_Pos)                        /*!< GPDMA C6CONFIG: L Mask                  */
#define GPDMA_C6CONFIG_A_Pos                  17                                                      /*!< GPDMA C6CONFIG: A Position              */
#define GPDMA_C6CONFIG_A_Msk                  (0x01UL << GPDMA_C6CONFIG_A_Pos)                        /*!< GPDMA C6CONFIG: A Mask                  */
#define GPDMA_C6CONFIG_H_Pos                  18                                                      /*!< GPDMA C6CONFIG: H Position              */
#define GPDMA_C6CONFIG_H_Msk                  (0x01UL << GPDMA_C6CONFIG_H_Pos)                        /*!< GPDMA C6CONFIG: H Mask                  */

/* -------------------------------  GPDMA_C7SRCADDR  ------------------------------ */
#define GPDMA_C7SRCADDR_SRCADDR_Pos           0                                                       /*!< GPDMA C7SRCADDR: SRCADDR Position       */
#define GPDMA_C7SRCADDR_SRCADDR_Msk           (0xffffffffUL << GPDMA_C7SRCADDR_SRCADDR_Pos)           /*!< GPDMA C7SRCADDR: SRCADDR Mask           */

/* ------------------------------  GPDMA_C7DESTADDR  ------------------------------ */
#define GPDMA_C7DESTADDR_DESTADDR_Pos         0                                                       /*!< GPDMA C7DESTADDR: DESTADDR Position     */
#define GPDMA_C7DESTADDR_DESTADDR_Msk         (0xffffffffUL << GPDMA_C7DESTADDR_DESTADDR_Pos)         /*!< GPDMA C7DESTADDR: DESTADDR Mask         */

/* ---------------------------------  GPDMA_C7LLI  -------------------------------- */
#define GPDMA_C7LLI_LM_Pos                    0                                                       /*!< GPDMA C7LLI: LM Position                */
#define GPDMA_C7LLI_LM_Msk                    (0x01UL << GPDMA_C7LLI_LM_Pos)                          /*!< GPDMA C7LLI: LM Mask                    */
#define GPDMA_C7LLI_R_Pos                     1                                                       /*!< GPDMA C7LLI: R Position                 */
#define GPDMA_C7LLI_R_Msk                     (0x01UL << GPDMA_C7LLI_R_Pos)                           /*!< GPDMA C7LLI: R Mask                     */
#define GPDMA_C7LLI_LLI_Pos                   2                                                       /*!< GPDMA C7LLI: LLI Position               */
#define GPDMA_C7LLI_LLI_Msk                   (0x3fffffffUL << GPDMA_C7LLI_LLI_Pos)                   /*!< GPDMA C7LLI: LLI Mask                   */

/* -------------------------------  GPDMA_C7CONTROL  ------------------------------ */
#define GPDMA_C7CONTROL_TRANSFERSIZE_Pos      0                                                       /*!< GPDMA C7CONTROL: TRANSFERSIZE Position  */
#define GPDMA_C7CONTROL_TRANSFERSIZE_Msk      (0x00000fffUL << GPDMA_C7CONTROL_TRANSFERSIZE_Pos)      /*!< GPDMA C7CONTROL: TRANSFERSIZE Mask      */
#define GPDMA_C7CONTROL_SBSIZE_Pos            12                                                      /*!< GPDMA C7CONTROL: SBSIZE Position        */
#define GPDMA_C7CONTROL_SBSIZE_Msk            (0x07UL << GPDMA_C7CONTROL_SBSIZE_Pos)                  /*!< GPDMA C7CONTROL: SBSIZE Mask            */
#define GPDMA_C7CONTROL_DBSIZE_Pos            15                                                      /*!< GPDMA C7CONTROL: DBSIZE Position        */
#define GPDMA_C7CONTROL_DBSIZE_Msk            (0x07UL << GPDMA_C7CONTROL_DBSIZE_Pos)                  /*!< GPDMA C7CONTROL: DBSIZE Mask            */
#define GPDMA_C7CONTROL_SWIDTH_Pos            18                                                      /*!< GPDMA C7CONTROL: SWIDTH Position        */
#define GPDMA_C7CONTROL_SWIDTH_Msk            (0x07UL << GPDMA_C7CONTROL_SWIDTH_Pos)                  /*!< GPDMA C7CONTROL: SWIDTH Mask            */
#define GPDMA_C7CONTROL_DWIDTH_Pos            21                                                      /*!< GPDMA C7CONTROL: DWIDTH Position        */
#define GPDMA_C7CONTROL_DWIDTH_Msk            (0x07UL << GPDMA_C7CONTROL_DWIDTH_Pos)                  /*!< GPDMA C7CONTROL: DWIDTH Mask            */
#define GPDMA_C7CONTROL_S_Pos                 24                                                      /*!< GPDMA C7CONTROL: S Position             */
#define GPDMA_C7CONTROL_S_Msk                 (0x01UL << GPDMA_C7CONTROL_S_Pos)                       /*!< GPDMA C7CONTROL: S Mask                 */
#define GPDMA_C7CONTROL_D_Pos                 25                                                      /*!< GPDMA C7CONTROL: D Position             */
#define GPDMA_C7CONTROL_D_Msk                 (0x01UL << GPDMA_C7CONTROL_D_Pos)                       /*!< GPDMA C7CONTROL: D Mask                 */
#define GPDMA_C7CONTROL_SI_Pos                26                                                      /*!< GPDMA C7CONTROL: SI Position            */
#define GPDMA_C7CONTROL_SI_Msk                (0x01UL << GPDMA_C7CONTROL_SI_Pos)                      /*!< GPDMA C7CONTROL: SI Mask                */
#define GPDMA_C7CONTROL_DI_Pos                27                                                      /*!< GPDMA C7CONTROL: DI Position            */
#define GPDMA_C7CONTROL_DI_Msk                (0x01UL << GPDMA_C7CONTROL_DI_Pos)                      /*!< GPDMA C7CONTROL: DI Mask                */
#define GPDMA_C7CONTROL_PROT1_Pos             28                                                      /*!< GPDMA C7CONTROL: PROT1 Position         */
#define GPDMA_C7CONTROL_PROT1_Msk             (0x01UL << GPDMA_C7CONTROL_PROT1_Pos)                   /*!< GPDMA C7CONTROL: PROT1 Mask             */
#define GPDMA_C7CONTROL_PROT2_Pos             29                                                      /*!< GPDMA C7CONTROL: PROT2 Position         */
#define GPDMA_C7CONTROL_PROT2_Msk             (0x01UL << GPDMA_C7CONTROL_PROT2_Pos)                   /*!< GPDMA C7CONTROL: PROT2 Mask             */
#define GPDMA_C7CONTROL_PROT3_Pos             30                                                      /*!< GPDMA C7CONTROL: PROT3 Position         */
#define GPDMA_C7CONTROL_PROT3_Msk             (0x01UL << GPDMA_C7CONTROL_PROT3_Pos)                   /*!< GPDMA C7CONTROL: PROT3 Mask             */
#define GPDMA_C7CONTROL_I_Pos                 31                                                      /*!< GPDMA C7CONTROL: I Position             */
#define GPDMA_C7CONTROL_I_Msk                 (0x01UL << GPDMA_C7CONTROL_I_Pos)                       /*!< GPDMA C7CONTROL: I Mask                 */

/* -------------------------------  GPDMA_C7CONFIG  ------------------------------- */
#define GPDMA_C7CONFIG_E_Pos                  0                                                       /*!< GPDMA C7CONFIG: E Position              */
#define GPDMA_C7CONFIG_E_Msk                  (0x01UL << GPDMA_C7CONFIG_E_Pos)                        /*!< GPDMA C7CONFIG: E Mask                  */
#define GPDMA_C7CONFIG_SRCPERIPHERAL_Pos      1                                                       /*!< GPDMA C7CONFIG: SRCPERIPHERAL Position  */
#define GPDMA_C7CONFIG_SRCPERIPHERAL_Msk      (0x1fUL << GPDMA_C7CONFIG_SRCPERIPHERAL_Pos)            /*!< GPDMA C7CONFIG: SRCPERIPHERAL Mask      */
#define GPDMA_C7CONFIG_DESTPERIPHERAL_Pos     6                                                       /*!< GPDMA C7CONFIG: DESTPERIPHERAL Position */
#define GPDMA_C7CONFIG_DESTPERIPHERAL_Msk     (0x1fUL << GPDMA_C7CONFIG_DESTPERIPHERAL_Pos)           /*!< GPDMA C7CONFIG: DESTPERIPHERAL Mask     */
#define GPDMA_C7CONFIG_FLOWCNTRL_Pos          11                                                      /*!< GPDMA C7CONFIG: FLOWCNTRL Position      */
#define GPDMA_C7CONFIG_FLOWCNTRL_Msk          (0x07UL << GPDMA_C7CONFIG_FLOWCNTRL_Pos)                /*!< GPDMA C7CONFIG: FLOWCNTRL Mask          */
#define GPDMA_C7CONFIG_IE_Pos                 14                                                      /*!< GPDMA C7CONFIG: IE Position             */
#define GPDMA_C7CONFIG_IE_Msk                 (0x01UL << GPDMA_C7CONFIG_IE_Pos)                       /*!< GPDMA C7CONFIG: IE Mask                 */
#define GPDMA_C7CONFIG_ITC_Pos                15                                                      /*!< GPDMA C7CONFIG: ITC Position            */
#define GPDMA_C7CONFIG_ITC_Msk                (0x01UL << GPDMA_C7CONFIG_ITC_Pos)                      /*!< GPDMA C7CONFIG: ITC Mask                */
#define GPDMA_C7CONFIG_L_Pos                  16                                                      /*!< GPDMA C7CONFIG: L Position              */
#define GPDMA_C7CONFIG_L_Msk                  (0x01UL << GPDMA_C7CONFIG_L_Pos)                        /*!< GPDMA C7CONFIG: L Mask                  */
#define GPDMA_C7CONFIG_A_Pos                  17                                                      /*!< GPDMA C7CONFIG: A Position              */
#define GPDMA_C7CONFIG_A_Msk                  (0x01UL << GPDMA_C7CONFIG_A_Pos)                        /*!< GPDMA C7CONFIG: A Mask                  */
#define GPDMA_C7CONFIG_H_Pos                  18                                                      /*!< GPDMA C7CONFIG: H Position              */
#define GPDMA_C7CONFIG_H_Msk                  (0x01UL << GPDMA_C7CONFIG_H_Pos)                        /*!< GPDMA C7CONFIG: H Mask                  */


/* ================================================================================ */
/* ================         struct 'SPIFI' Position & Mask         ================ */
/* ================================================================================ */


/* ---------------------------------  SPIFI_CTRL  --------------------------------- */
#define SPIFI_CTRL_TIMEOUT_Pos                0                                                       /*!< SPIFI CTRL: TIMEOUT Position            */
#define SPIFI_CTRL_TIMEOUT_Msk                (0x0000ffffUL << SPIFI_CTRL_TIMEOUT_Pos)                /*!< SPIFI CTRL: TIMEOUT Mask                */
#define SPIFI_CTRL_CSHIGH_Pos                 16                                                      /*!< SPIFI CTRL: CSHIGH Position             */
#define SPIFI_CTRL_CSHIGH_Msk                 (0x0fUL << SPIFI_CTRL_CSHIGH_Pos)                       /*!< SPIFI CTRL: CSHIGH Mask                 */
#define SPIFI_CTRL_D_PRFTCH_DIS_Pos           21                                                      /*!< SPIFI CTRL: D_PRFTCH_DIS Position       */
#define SPIFI_CTRL_D_PRFTCH_DIS_Msk           (0x01UL << SPIFI_CTRL_D_PRFTCH_DIS_Pos)                 /*!< SPIFI CTRL: D_PRFTCH_DIS Mask           */
#define SPIFI_CTRL_INTEN_Pos                  22                                                      /*!< SPIFI CTRL: INTEN Position              */
#define SPIFI_CTRL_INTEN_Msk                  (0x01UL << SPIFI_CTRL_INTEN_Pos)                        /*!< SPIFI CTRL: INTEN Mask                  */
#define SPIFI_CTRL_MODE3_Pos                  23                                                      /*!< SPIFI CTRL: MODE3 Position              */
#define SPIFI_CTRL_MODE3_Msk                  (0x01UL << SPIFI_CTRL_MODE3_Pos)                        /*!< SPIFI CTRL: MODE3 Mask                  */
#define SPIFI_CTRL_PRFTCH_DIS_Pos             27                                                      /*!< SPIFI CTRL: PRFTCH_DIS Position         */
#define SPIFI_CTRL_PRFTCH_DIS_Msk             (0x01UL << SPIFI_CTRL_PRFTCH_DIS_Pos)                   /*!< SPIFI CTRL: PRFTCH_DIS Mask             */
#define SPIFI_CTRL_DUAL_Pos                   28                                                      /*!< SPIFI CTRL: DUAL Position               */
#define SPIFI_CTRL_DUAL_Msk                   (0x01UL << SPIFI_CTRL_DUAL_Pos)                         /*!< SPIFI CTRL: DUAL Mask                   */
#define SPIFI_CTRL_RFCLK_Pos                  29                                                      /*!< SPIFI CTRL: RFCLK Position              */
#define SPIFI_CTRL_RFCLK_Msk                  (0x01UL << SPIFI_CTRL_RFCLK_Pos)                        /*!< SPIFI CTRL: RFCLK Mask                  */
#define SPIFI_CTRL_FBCLK_Pos                  30                                                      /*!< SPIFI CTRL: FBCLK Position              */
#define SPIFI_CTRL_FBCLK_Msk                  (0x01UL << SPIFI_CTRL_FBCLK_Pos)                        /*!< SPIFI CTRL: FBCLK Mask                  */
#define SPIFI_CTRL_DMAEN_Pos                  31                                                      /*!< SPIFI CTRL: DMAEN Position              */
#define SPIFI_CTRL_DMAEN_Msk                  (0x01UL << SPIFI_CTRL_DMAEN_Pos)                        /*!< SPIFI CTRL: DMAEN Mask                  */

/* ----------------------------------  SPIFI_CMD  --------------------------------- */
#define SPIFI_CMD_DATALEN_Pos                 0                                                       /*!< SPIFI CMD: DATALEN Position             */
#define SPIFI_CMD_DATALEN_Msk                 (0x00003fffUL << SPIFI_CMD_DATALEN_Pos)                 /*!< SPIFI CMD: DATALEN Mask                 */
#define SPIFI_CMD_POLL_Pos                    14                                                      /*!< SPIFI CMD: POLL Position                */
#define SPIFI_CMD_POLL_Msk                    (0x01UL << SPIFI_CMD_POLL_Pos)                          /*!< SPIFI CMD: POLL Mask                    */
#define SPIFI_CMD_DOUT_Pos                    15                                                      /*!< SPIFI CMD: DOUT Position                */
#define SPIFI_CMD_DOUT_Msk                    (0x01UL << SPIFI_CMD_DOUT_Pos)                          /*!< SPIFI CMD: DOUT Mask                    */
#define SPIFI_CMD_INTLEN_Pos                  16                                                      /*!< SPIFI CMD: INTLEN Position              */
#define SPIFI_CMD_INTLEN_Msk                  (0x07UL << SPIFI_CMD_INTLEN_Pos)                        /*!< SPIFI CMD: INTLEN Mask                  */
#define SPIFI_CMD_FIELDFORM_Pos               19                                                      /*!< SPIFI CMD: FIELDFORM Position           */
#define SPIFI_CMD_FIELDFORM_Msk               (0x03UL << SPIFI_CMD_FIELDFORM_Pos)                     /*!< SPIFI CMD: FIELDFORM Mask               */
#define SPIFI_CMD_FRAMEFORM_Pos               21                                                      /*!< SPIFI CMD: FRAMEFORM Position           */
#define SPIFI_CMD_FRAMEFORM_Msk               (0x07UL << SPIFI_CMD_FRAMEFORM_Pos)                     /*!< SPIFI CMD: FRAMEFORM Mask               */
#define SPIFI_CMD_OPCODE_Pos                  24                                                      /*!< SPIFI CMD: OPCODE Position              */
#define SPIFI_CMD_OPCODE_Msk                  (0x000000ffUL << SPIFI_CMD_OPCODE_Pos)                  /*!< SPIFI CMD: OPCODE Mask                  */

/* ---------------------------------  SPIFI_ADDR  --------------------------------- */
#define SPIFI_ADDR_ADDRESS_Pos                0                                                       /*!< SPIFI ADDR: ADDRESS Position            */
#define SPIFI_ADDR_ADDRESS_Msk                (0xffffffffUL << SPIFI_ADDR_ADDRESS_Pos)                /*!< SPIFI ADDR: ADDRESS Mask                */

/* ---------------------------------  SPIFI_IDATA  -------------------------------- */
#define SPIFI_IDATA_IDATA_Pos                 0                                                       /*!< SPIFI IDATA: IDATA Position             */
#define SPIFI_IDATA_IDATA_Msk                 (0xffffffffUL << SPIFI_IDATA_IDATA_Pos)                 /*!< SPIFI IDATA: IDATA Mask                 */

/* --------------------------------  SPIFI_CLIMIT  -------------------------------- */
#define SPIFI_CLIMIT_CLIMIT_Pos               0                                                       /*!< SPIFI CLIMIT: CLIMIT Position           */
#define SPIFI_CLIMIT_CLIMIT_Msk               (0xffffffffUL << SPIFI_CLIMIT_CLIMIT_Pos)               /*!< SPIFI CLIMIT: CLIMIT Mask               */

/* ---------------------------------  SPIFI_DATA  --------------------------------- */
#define SPIFI_DATA_DATA_Pos                   0                                                       /*!< SPIFI DATA: DATA Position               */
#define SPIFI_DATA_DATA_Msk                   (0xffffffffUL << SPIFI_DATA_DATA_Pos)                   /*!< SPIFI DATA: DATA Mask                   */

/* ---------------------------------  SPIFI_MCMD  --------------------------------- */
#define SPIFI_MCMD_POLL_Pos                   14                                                      /*!< SPIFI MCMD: POLL Position               */
#define SPIFI_MCMD_POLL_Msk                   (0x01UL << SPIFI_MCMD_POLL_Pos)                         /*!< SPIFI MCMD: POLL Mask                   */
#define SPIFI_MCMD_DOUT_Pos                   15                                                      /*!< SPIFI MCMD: DOUT Position               */
#define SPIFI_MCMD_DOUT_Msk                   (0x01UL << SPIFI_MCMD_DOUT_Pos)                         /*!< SPIFI MCMD: DOUT Mask                   */
#define SPIFI_MCMD_INTLEN_Pos                 16                                                      /*!< SPIFI MCMD: INTLEN Position             */
#define SPIFI_MCMD_INTLEN_Msk                 (0x07UL << SPIFI_MCMD_INTLEN_Pos)                       /*!< SPIFI MCMD: INTLEN Mask                 */
#define SPIFI_MCMD_FIELDFORM_Pos              19                                                      /*!< SPIFI MCMD: FIELDFORM Position          */
#define SPIFI_MCMD_FIELDFORM_Msk              (0x03UL << SPIFI_MCMD_FIELDFORM_Pos)                    /*!< SPIFI MCMD: FIELDFORM Mask              */
#define SPIFI_MCMD_FRAMEFORM_Pos              21                                                      /*!< SPIFI MCMD: FRAMEFORM Position          */
#define SPIFI_MCMD_FRAMEFORM_Msk              (0x07UL << SPIFI_MCMD_FRAMEFORM_Pos)                    /*!< SPIFI MCMD: FRAMEFORM Mask              */
#define SPIFI_MCMD_OPCODE_Pos                 24                                                      /*!< SPIFI MCMD: OPCODE Position             */
#define SPIFI_MCMD_OPCODE_Msk                 (0x000000ffUL << SPIFI_MCMD_OPCODE_Pos)                 /*!< SPIFI MCMD: OPCODE Mask                 */

/* ---------------------------------  SPIFI_STAT  --------------------------------- */
#define SPIFI_STAT_MCINIT_Pos                 0                                                       /*!< SPIFI STAT: MCINIT Position             */
#define SPIFI_STAT_MCINIT_Msk                 (0x01UL << SPIFI_STAT_MCINIT_Pos)                       /*!< SPIFI STAT: MCINIT Mask                 */
#define SPIFI_STAT_CMD_Pos                    1                                                       /*!< SPIFI STAT: CMD Position                */
#define SPIFI_STAT_CMD_Msk                    (0x01UL << SPIFI_STAT_CMD_Pos)                          /*!< SPIFI STAT: CMD Mask                    */
#define SPIFI_STAT_RESET_Pos                  4                                                       /*!< SPIFI STAT: RESET Position              */
#define SPIFI_STAT_RESET_Msk                  (0x01UL << SPIFI_STAT_RESET_Pos)                        /*!< SPIFI STAT: RESET Mask                  */
#define SPIFI_STAT_INTRQ_Pos                  5                                                       /*!< SPIFI STAT: INTRQ Position              */
#define SPIFI_STAT_INTRQ_Msk                  (0x01UL << SPIFI_STAT_INTRQ_Pos)                        /*!< SPIFI STAT: INTRQ Mask                  */
#define SPIFI_STAT_VERSION_Pos                24                                                      /*!< SPIFI STAT: VERSION Position            */
#define SPIFI_STAT_VERSION_Msk                (0x000000ffUL << SPIFI_STAT_VERSION_Pos)                /*!< SPIFI STAT: VERSION Mask                */


/* ================================================================================ */
/* ================         struct 'SDMMC' Position & Mask         ================ */
/* ================================================================================ */


/* ---------------------------------  SDMMC_CTRL  --------------------------------- */
#define SDMMC_CTRL_CONTROLLER_RESET_Pos       0                                                       /*!< SDMMC CTRL: CONTROLLER_RESET Position   */
#define SDMMC_CTRL_CONTROLLER_RESET_Msk       (0x01UL << SDMMC_CTRL_CONTROLLER_RESET_Pos)             /*!< SDMMC CTRL: CONTROLLER_RESET Mask       */
#define SDMMC_CTRL_FIFO_RESET_Pos             1                                                       /*!< SDMMC CTRL: FIFO_RESET Position         */
#define SDMMC_CTRL_FIFO_RESET_Msk             (0x01UL << SDMMC_CTRL_FIFO_RESET_Pos)                   /*!< SDMMC CTRL: FIFO_RESET Mask             */
#define SDMMC_CTRL_DMA_RESET_Pos              2                                                       /*!< SDMMC CTRL: DMA_RESET Position          */
#define SDMMC_CTRL_DMA_RESET_Msk              (0x01UL << SDMMC_CTRL_DMA_RESET_Pos)                    /*!< SDMMC CTRL: DMA_RESET Mask              */
#define SDMMC_CTRL_INT_ENABLE_Pos             4                                                       /*!< SDMMC CTRL: INT_ENABLE Position         */
#define SDMMC_CTRL_INT_ENABLE_Msk             (0x01UL << SDMMC_CTRL_INT_ENABLE_Pos)                   /*!< SDMMC CTRL: INT_ENABLE Mask             */
#define SDMMC_CTRL_READ_WAIT_Pos              6                                                       /*!< SDMMC CTRL: READ_WAIT Position          */
#define SDMMC_CTRL_READ_WAIT_Msk              (0x01UL << SDMMC_CTRL_READ_WAIT_Pos)                    /*!< SDMMC CTRL: READ_WAIT Mask              */
#define SDMMC_CTRL_SEND_IRQ_RESPONSE_Pos      7                                                       /*!< SDMMC CTRL: SEND_IRQ_RESPONSE Position  */
#define SDMMC_CTRL_SEND_IRQ_RESPONSE_Msk      (0x01UL << SDMMC_CTRL_SEND_IRQ_RESPONSE_Pos)            /*!< SDMMC CTRL: SEND_IRQ_RESPONSE Mask      */
#define SDMMC_CTRL_ABORT_READ_DATA_Pos        8                                                       /*!< SDMMC CTRL: ABORT_READ_DATA Position    */
#define SDMMC_CTRL_ABORT_READ_DATA_Msk        (0x01UL << SDMMC_CTRL_ABORT_READ_DATA_Pos)              /*!< SDMMC CTRL: ABORT_READ_DATA Mask        */
#define SDMMC_CTRL_SEND_CCSD_Pos              9                                                       /*!< SDMMC CTRL: SEND_CCSD Position          */
#define SDMMC_CTRL_SEND_CCSD_Msk              (0x01UL << SDMMC_CTRL_SEND_CCSD_Pos)                    /*!< SDMMC CTRL: SEND_CCSD Mask              */
#define SDMMC_CTRL_SEND_AUTO_STOP_Pos         10                                                      /*!< SDMMC CTRL: SEND_AUTO_STOP Position     */
#define SDMMC_CTRL_SEND_AUTO_STOP_Msk         (0x01UL << SDMMC_CTRL_SEND_AUTO_STOP_Pos)               /*!< SDMMC CTRL: SEND_AUTO_STOP Mask         */
#define SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_Pos 11                                               /*!< SDMMC CTRL: CEATA_DEVICE_INTERRUPT_STATUS Position */
#define SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_Msk (0x01UL << SDMMC_CTRL_CEATA_DEVICE_INTERRUPT_STATUS_Pos)/*!< SDMMC CTRL: CEATA_DEVICE_INTERRUPT_STATUS Mask */
#define SDMMC_CTRL_CARD_VOLTAGE_A0_Pos        16                                                      /*!< SDMMC CTRL: CARD_VOLTAGE_A0 Position    */
#define SDMMC_CTRL_CARD_VOLTAGE_A0_Msk        (0x01UL << SDMMC_CTRL_CARD_VOLTAGE_A0_Pos)              /*!< SDMMC CTRL: CARD_VOLTAGE_A0 Mask        */
#define SDMMC_CTRL_CARD_VOLTAGE_A1_Pos        17                                                      /*!< SDMMC CTRL: CARD_VOLTAGE_A1 Position    */
#define SDMMC_CTRL_CARD_VOLTAGE_A1_Msk        (0x01UL << SDMMC_CTRL_CARD_VOLTAGE_A1_Pos)              /*!< SDMMC CTRL: CARD_VOLTAGE_A1 Mask        */
#define SDMMC_CTRL_CARD_VOLTAGE_A2_Pos        18                                                      /*!< SDMMC CTRL: CARD_VOLTAGE_A2 Position    */
#define SDMMC_CTRL_CARD_VOLTAGE_A2_Msk        (0x01UL << SDMMC_CTRL_CARD_VOLTAGE_A2_Pos)              /*!< SDMMC CTRL: CARD_VOLTAGE_A2 Mask        */
#define SDMMC_CTRL_USE_INTERNAL_DMAC_Pos      25                                                      /*!< SDMMC CTRL: USE_INTERNAL_DMAC Position  */
#define SDMMC_CTRL_USE_INTERNAL_DMAC_Msk      (0x01UL << SDMMC_CTRL_USE_INTERNAL_DMAC_Pos)            /*!< SDMMC CTRL: USE_INTERNAL_DMAC Mask      */

/* ---------------------------------  SDMMC_PWREN  -------------------------------- */
#define SDMMC_PWREN_POWER_ENABLE_Pos          0                                                       /*!< SDMMC PWREN: POWER_ENABLE Position      */
#define SDMMC_PWREN_POWER_ENABLE_Msk          (0x01UL << SDMMC_PWREN_POWER_ENABLE_Pos)                /*!< SDMMC PWREN: POWER_ENABLE Mask          */

/* --------------------------------  SDMMC_CLKDIV  -------------------------------- */
#define SDMMC_CLKDIV_CLK_DIVIDER0_Pos         0                                                       /*!< SDMMC CLKDIV: CLK_DIVIDER0 Position     */
#define SDMMC_CLKDIV_CLK_DIVIDER0_Msk         (0x000000ffUL << SDMMC_CLKDIV_CLK_DIVIDER0_Pos)         /*!< SDMMC CLKDIV: CLK_DIVIDER0 Mask         */
#define SDMMC_CLKDIV_CLK_DIVIDER1_Pos         8                                                       /*!< SDMMC CLKDIV: CLK_DIVIDER1 Position     */
#define SDMMC_CLKDIV_CLK_DIVIDER1_Msk         (0x000000ffUL << SDMMC_CLKDIV_CLK_DIVIDER1_Pos)         /*!< SDMMC CLKDIV: CLK_DIVIDER1 Mask         */
#define SDMMC_CLKDIV_CLK_DIVIDER2_Pos         16                                                      /*!< SDMMC CLKDIV: CLK_DIVIDER2 Position     */
#define SDMMC_CLKDIV_CLK_DIVIDER2_Msk         (0x000000ffUL << SDMMC_CLKDIV_CLK_DIVIDER2_Pos)         /*!< SDMMC CLKDIV: CLK_DIVIDER2 Mask         */
#define SDMMC_CLKDIV_CLK_DIVIDER3_Pos         24                                                      /*!< SDMMC CLKDIV: CLK_DIVIDER3 Position     */
#define SDMMC_CLKDIV_CLK_DIVIDER3_Msk         (0x000000ffUL << SDMMC_CLKDIV_CLK_DIVIDER3_Pos)         /*!< SDMMC CLKDIV: CLK_DIVIDER3 Mask         */

/* --------------------------------  SDMMC_CLKSRC  -------------------------------- */
#define SDMMC_CLKSRC_CLK_SOURCE_Pos           0                                                       /*!< SDMMC CLKSRC: CLK_SOURCE Position       */
#define SDMMC_CLKSRC_CLK_SOURCE_Msk           (0x03UL << SDMMC_CLKSRC_CLK_SOURCE_Pos)                 /*!< SDMMC CLKSRC: CLK_SOURCE Mask           */

/* --------------------------------  SDMMC_CLKENA  -------------------------------- */
#define SDMMC_CLKENA_CCLK_ENABLE_Pos          0                                                       /*!< SDMMC CLKENA: CCLK_ENABLE Position      */
#define SDMMC_CLKENA_CCLK_ENABLE_Msk          (0x01UL << SDMMC_CLKENA_CCLK_ENABLE_Pos)                /*!< SDMMC CLKENA: CCLK_ENABLE Mask          */
#define SDMMC_CLKENA_CCLK_LOW_POWER_Pos       16                                                      /*!< SDMMC CLKENA: CCLK_LOW_POWER Position   */
#define SDMMC_CLKENA_CCLK_LOW_POWER_Msk       (0x01UL << SDMMC_CLKENA_CCLK_LOW_POWER_Pos)             /*!< SDMMC CLKENA: CCLK_LOW_POWER Mask       */

/* ---------------------------------  SDMMC_TMOUT  -------------------------------- */
#define SDMMC_TMOUT_RESPONSE_TIMEOUT_Pos      0                                                       /*!< SDMMC TMOUT: RESPONSE_TIMEOUT Position  */
#define SDMMC_TMOUT_RESPONSE_TIMEOUT_Msk      (0x000000ffUL << SDMMC_TMOUT_RESPONSE_TIMEOUT_Pos)      /*!< SDMMC TMOUT: RESPONSE_TIMEOUT Mask      */
#define SDMMC_TMOUT_DATA_TIMEOUT_Pos          8                                                       /*!< SDMMC TMOUT: DATA_TIMEOUT Position      */
#define SDMMC_TMOUT_DATA_TIMEOUT_Msk          (0x00ffffffUL << SDMMC_TMOUT_DATA_TIMEOUT_Pos)          /*!< SDMMC TMOUT: DATA_TIMEOUT Mask          */

/* ---------------------------------  SDMMC_CTYPE  -------------------------------- */
#define SDMMC_CTYPE_CARD_WIDTH0_Pos           0                                                       /*!< SDMMC CTYPE: CARD_WIDTH0 Position       */
#define SDMMC_CTYPE_CARD_WIDTH0_Msk           (0x01UL << SDMMC_CTYPE_CARD_WIDTH0_Pos)                 /*!< SDMMC CTYPE: CARD_WIDTH0 Mask           */
#define SDMMC_CTYPE_CARD_WIDTH1_Pos           16                                                      /*!< SDMMC CTYPE: CARD_WIDTH1 Position       */
#define SDMMC_CTYPE_CARD_WIDTH1_Msk           (0x01UL << SDMMC_CTYPE_CARD_WIDTH1_Pos)                 /*!< SDMMC CTYPE: CARD_WIDTH1 Mask           */

/* --------------------------------  SDMMC_BLKSIZ  -------------------------------- */
#define SDMMC_BLKSIZ_BLOCK_SIZE_Pos           0                                                       /*!< SDMMC BLKSIZ: BLOCK_SIZE Position       */
#define SDMMC_BLKSIZ_BLOCK_SIZE_Msk           (0x0000ffffUL << SDMMC_BLKSIZ_BLOCK_SIZE_Pos)           /*!< SDMMC BLKSIZ: BLOCK_SIZE Mask           */

/* --------------------------------  SDMMC_BYTCNT  -------------------------------- */
#define SDMMC_BYTCNT_BYTE_COUNT_Pos           0                                                       /*!< SDMMC BYTCNT: BYTE_COUNT Position       */
#define SDMMC_BYTCNT_BYTE_COUNT_Msk           (0xffffffffUL << SDMMC_BYTCNT_BYTE_COUNT_Pos)           /*!< SDMMC BYTCNT: BYTE_COUNT Mask           */

/* --------------------------------  SDMMC_INTMASK  ------------------------------- */
#define SDMMC_INTMASK_CDET_Pos                0                                                       /*!< SDMMC INTMASK: CDET Position            */
#define SDMMC_INTMASK_CDET_Msk                (0x01UL << SDMMC_INTMASK_CDET_Pos)                      /*!< SDMMC INTMASK: CDET Mask                */
#define SDMMC_INTMASK_RE_Pos                  1                                                       /*!< SDMMC INTMASK: RE Position              */
#define SDMMC_INTMASK_RE_Msk                  (0x01UL << SDMMC_INTMASK_RE_Pos)                        /*!< SDMMC INTMASK: RE Mask                  */
#define SDMMC_INTMASK_CDONE_Pos               2                                                       /*!< SDMMC INTMASK: CDONE Position           */
#define SDMMC_INTMASK_CDONE_Msk               (0x01UL << SDMMC_INTMASK_CDONE_Pos)                     /*!< SDMMC INTMASK: CDONE Mask               */
#define SDMMC_INTMASK_DTO_Pos                 3                                                       /*!< SDMMC INTMASK: DTO Position             */
#define SDMMC_INTMASK_DTO_Msk                 (0x01UL << SDMMC_INTMASK_DTO_Pos)                       /*!< SDMMC INTMASK: DTO Mask                 */
#define SDMMC_INTMASK_TXDR_Pos                4                                                       /*!< SDMMC INTMASK: TXDR Position            */
#define SDMMC_INTMASK_TXDR_Msk                (0x01UL << SDMMC_INTMASK_TXDR_Pos)                      /*!< SDMMC INTMASK: TXDR Mask                */
#define SDMMC_INTMASK_RXDR_Pos                5                                                       /*!< SDMMC INTMASK: RXDR Position            */
#define SDMMC_INTMASK_RXDR_Msk                (0x01UL << SDMMC_INTMASK_RXDR_Pos)                      /*!< SDMMC INTMASK: RXDR Mask                */
#define SDMMC_INTMASK_RCRC_Pos                6                                                       /*!< SDMMC INTMASK: RCRC Position            */
#define SDMMC_INTMASK_RCRC_Msk                (0x01UL << SDMMC_INTMASK_RCRC_Pos)                      /*!< SDMMC INTMASK: RCRC Mask                */
#define SDMMC_INTMASK_DCRC_Pos                7                                                       /*!< SDMMC INTMASK: DCRC Position            */
#define SDMMC_INTMASK_DCRC_Msk                (0x01UL << SDMMC_INTMASK_DCRC_Pos)                      /*!< SDMMC INTMASK: DCRC Mask                */
#define SDMMC_INTMASK_RTO_Pos                 8                                                       /*!< SDMMC INTMASK: RTO Position             */
#define SDMMC_INTMASK_RTO_Msk                 (0x01UL << SDMMC_INTMASK_RTO_Pos)                       /*!< SDMMC INTMASK: RTO Mask                 */
#define SDMMC_INTMASK_DRTO_Pos                9                                                       /*!< SDMMC INTMASK: DRTO Position            */
#define SDMMC_INTMASK_DRTO_Msk                (0x01UL << SDMMC_INTMASK_DRTO_Pos)                      /*!< SDMMC INTMASK: DRTO Mask                */
#define SDMMC_INTMASK_HTO_Pos                 10                                                      /*!< SDMMC INTMASK: HTO Position             */
#define SDMMC_INTMASK_HTO_Msk                 (0x01UL << SDMMC_INTMASK_HTO_Pos)                       /*!< SDMMC INTMASK: HTO Mask                 */
#define SDMMC_INTMASK_FRUN_Pos                11                                                      /*!< SDMMC INTMASK: FRUN Position            */
#define SDMMC_INTMASK_FRUN_Msk                (0x01UL << SDMMC_INTMASK_FRUN_Pos)                      /*!< SDMMC INTMASK: FRUN Mask                */
#define SDMMC_INTMASK_HLE_Pos                 12                                                      /*!< SDMMC INTMASK: HLE Position             */
#define SDMMC_INTMASK_HLE_Msk                 (0x01UL << SDMMC_INTMASK_HLE_Pos)                       /*!< SDMMC INTMASK: HLE Mask                 */
#define SDMMC_INTMASK_SBE_Pos                 13                                                      /*!< SDMMC INTMASK: SBE Position             */
#define SDMMC_INTMASK_SBE_Msk                 (0x01UL << SDMMC_INTMASK_SBE_Pos)                       /*!< SDMMC INTMASK: SBE Mask                 */
#define SDMMC_INTMASK_ACD_Pos                 14                                                      /*!< SDMMC INTMASK: ACD Position             */
#define SDMMC_INTMASK_ACD_Msk                 (0x01UL << SDMMC_INTMASK_ACD_Pos)                       /*!< SDMMC INTMASK: ACD Mask                 */
#define SDMMC_INTMASK_EBE_Pos                 15                                                      /*!< SDMMC INTMASK: EBE Position             */
#define SDMMC_INTMASK_EBE_Msk                 (0x01UL << SDMMC_INTMASK_EBE_Pos)                       /*!< SDMMC INTMASK: EBE Mask                 */
#define SDMMC_INTMASK_SDIO_INT_MASK_Pos       16                                                      /*!< SDMMC INTMASK: SDIO_INT_MASK Position   */
#define SDMMC_INTMASK_SDIO_INT_MASK_Msk       (0x01UL << SDMMC_INTMASK_SDIO_INT_MASK_Pos)             /*!< SDMMC INTMASK: SDIO_INT_MASK Mask       */

/* --------------------------------  SDMMC_CMDARG  -------------------------------- */
#define SDMMC_CMDARG_CMD_ARG_Pos              0                                                       /*!< SDMMC CMDARG: CMD_ARG Position          */
#define SDMMC_CMDARG_CMD_ARG_Msk              (0xffffffffUL << SDMMC_CMDARG_CMD_ARG_Pos)              /*!< SDMMC CMDARG: CMD_ARG Mask              */

/* ----------------------------------  SDMMC_CMD  --------------------------------- */
#define SDMMC_CMD_CMD_INDEX_Pos               0                                                       /*!< SDMMC CMD: CMD_INDEX Position           */
#define SDMMC_CMD_CMD_INDEX_Msk               (0x3fUL << SDMMC_CMD_CMD_INDEX_Pos)                     /*!< SDMMC CMD: CMD_INDEX Mask               */
#define SDMMC_CMD_RESPONSE_EXPECT_Pos         6                                                       /*!< SDMMC CMD: RESPONSE_EXPECT Position     */
#define SDMMC_CMD_RESPONSE_EXPECT_Msk         (0x01UL << SDMMC_CMD_RESPONSE_EXPECT_Pos)               /*!< SDMMC CMD: RESPONSE_EXPECT Mask         */
#define SDMMC_CMD_RESPONSE_LENGTH_Pos         7                                                       /*!< SDMMC CMD: RESPONSE_LENGTH Position     */
#define SDMMC_CMD_RESPONSE_LENGTH_Msk         (0x01UL << SDMMC_CMD_RESPONSE_LENGTH_Pos)               /*!< SDMMC CMD: RESPONSE_LENGTH Mask         */
#define SDMMC_CMD_CHECK_RESPONSE_CRC_Pos      8                                                       /*!< SDMMC CMD: CHECK_RESPONSE_CRC Position  */
#define SDMMC_CMD_CHECK_RESPONSE_CRC_Msk      (0x01UL << SDMMC_CMD_CHECK_RESPONSE_CRC_Pos)            /*!< SDMMC CMD: CHECK_RESPONSE_CRC Mask      */
#define SDMMC_CMD_DATA_EXPECTED_Pos           9                                                       /*!< SDMMC CMD: DATA_EXPECTED Position       */
#define SDMMC_CMD_DATA_EXPECTED_Msk           (0x01UL << SDMMC_CMD_DATA_EXPECTED_Pos)                 /*!< SDMMC CMD: DATA_EXPECTED Mask           */
#define SDMMC_CMD_READ_WRITE_Pos              10                                                      /*!< SDMMC CMD: READ_WRITE Position          */
#define SDMMC_CMD_READ_WRITE_Msk              (0x01UL << SDMMC_CMD_READ_WRITE_Pos)                    /*!< SDMMC CMD: READ_WRITE Mask              */
#define SDMMC_CMD_TRANSFER_MODE_Pos           11                                                      /*!< SDMMC CMD: TRANSFER_MODE Position       */
#define SDMMC_CMD_TRANSFER_MODE_Msk           (0x01UL << SDMMC_CMD_TRANSFER_MODE_Pos)                 /*!< SDMMC CMD: TRANSFER_MODE Mask           */
#define SDMMC_CMD_SEND_AUTO_STOP_Pos          12                                                      /*!< SDMMC CMD: SEND_AUTO_STOP Position      */
#define SDMMC_CMD_SEND_AUTO_STOP_Msk          (0x01UL << SDMMC_CMD_SEND_AUTO_STOP_Pos)                /*!< SDMMC CMD: SEND_AUTO_STOP Mask          */
#define SDMMC_CMD_WAIT_PRVDATA_COMPLETE_Pos   13                                                      /*!< SDMMC CMD: WAIT_PRVDATA_COMPLETE Position */
#define SDMMC_CMD_WAIT_PRVDATA_COMPLETE_Msk   (0x01UL << SDMMC_CMD_WAIT_PRVDATA_COMPLETE_Pos)         /*!< SDMMC CMD: WAIT_PRVDATA_COMPLETE Mask   */
#define SDMMC_CMD_STOP_ABORT_CMD_Pos          14                                                      /*!< SDMMC CMD: STOP_ABORT_CMD Position      */
#define SDMMC_CMD_STOP_ABORT_CMD_Msk          (0x01UL << SDMMC_CMD_STOP_ABORT_CMD_Pos)                /*!< SDMMC CMD: STOP_ABORT_CMD Mask          */
#define SDMMC_CMD_SEND_INITIALIZATION_Pos     15                                                      /*!< SDMMC CMD: SEND_INITIALIZATION Position */
#define SDMMC_CMD_SEND_INITIALIZATION_Msk     (0x01UL << SDMMC_CMD_SEND_INITIALIZATION_Pos)           /*!< SDMMC CMD: SEND_INITIALIZATION Mask     */
#define SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY_Pos 21                                                  /*!< SDMMC CMD: UPDATE_CLOCK_REGISTERS_ONLY Position */
#define SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY_Msk (0x01UL << SDMMC_CMD_UPDATE_CLOCK_REGISTERS_ONLY_Pos)/*!< SDMMC CMD: UPDATE_CLOCK_REGISTERS_ONLY Mask */
#define SDMMC_CMD_READ_CEATA_DEVICE_Pos       22                                                      /*!< SDMMC CMD: READ_CEATA_DEVICE Position   */
#define SDMMC_CMD_READ_CEATA_DEVICE_Msk       (0x01UL << SDMMC_CMD_READ_CEATA_DEVICE_Pos)             /*!< SDMMC CMD: READ_CEATA_DEVICE Mask       */
#define SDMMC_CMD_CCS_EXPECTED_Pos            23                                                      /*!< SDMMC CMD: CCS_EXPECTED Position        */
#define SDMMC_CMD_CCS_EXPECTED_Msk            (0x01UL << SDMMC_CMD_CCS_EXPECTED_Pos)                  /*!< SDMMC CMD: CCS_EXPECTED Mask            */
#define SDMMC_CMD_ENABLE_BOOT_Pos             24                                                      /*!< SDMMC CMD: ENABLE_BOOT Position         */
#define SDMMC_CMD_ENABLE_BOOT_Msk             (0x01UL << SDMMC_CMD_ENABLE_BOOT_Pos)                   /*!< SDMMC CMD: ENABLE_BOOT Mask             */
#define SDMMC_CMD_EXPECT_BOOT_ACK_Pos         25                                                      /*!< SDMMC CMD: EXPECT_BOOT_ACK Position     */
#define SDMMC_CMD_EXPECT_BOOT_ACK_Msk         (0x01UL << SDMMC_CMD_EXPECT_BOOT_ACK_Pos)               /*!< SDMMC CMD: EXPECT_BOOT_ACK Mask         */
#define SDMMC_CMD_DISABLE_BOOT_Pos            26                                                      /*!< SDMMC CMD: DISABLE_BOOT Position        */
#define SDMMC_CMD_DISABLE_BOOT_Msk            (0x01UL << SDMMC_CMD_DISABLE_BOOT_Pos)                  /*!< SDMMC CMD: DISABLE_BOOT Mask            */
#define SDMMC_CMD_BOOT_MODE_Pos               27                                                      /*!< SDMMC CMD: BOOT_MODE Position           */
#define SDMMC_CMD_BOOT_MODE_Msk               (0x01UL << SDMMC_CMD_BOOT_MODE_Pos)                     /*!< SDMMC CMD: BOOT_MODE Mask               */
#define SDMMC_CMD_VOLT_SWITCH_Pos             28                                                      /*!< SDMMC CMD: VOLT_SWITCH Position         */
#define SDMMC_CMD_VOLT_SWITCH_Msk             (0x01UL << SDMMC_CMD_VOLT_SWITCH_Pos)                   /*!< SDMMC CMD: VOLT_SWITCH Mask             */
#define SDMMC_CMD_START_CMD_Pos               31                                                      /*!< SDMMC CMD: START_CMD Position           */
#define SDMMC_CMD_START_CMD_Msk               (0x01UL << SDMMC_CMD_START_CMD_Pos)                     /*!< SDMMC CMD: START_CMD Mask               */

/* ---------------------------------  SDMMC_RESP0  -------------------------------- */
#define SDMMC_RESP0_RESPONSE0_Pos             0                                                       /*!< SDMMC RESP0: RESPONSE0 Position         */
#define SDMMC_RESP0_RESPONSE0_Msk             (0xffffffffUL << SDMMC_RESP0_RESPONSE0_Pos)             /*!< SDMMC RESP0: RESPONSE0 Mask             */

/* ---------------------------------  SDMMC_RESP1  -------------------------------- */
#define SDMMC_RESP1_RESPONSE1_Pos             0                                                       /*!< SDMMC RESP1: RESPONSE1 Position         */
#define SDMMC_RESP1_RESPONSE1_Msk             (0xffffffffUL << SDMMC_RESP1_RESPONSE1_Pos)             /*!< SDMMC RESP1: RESPONSE1 Mask             */

/* ---------------------------------  SDMMC_RESP2  -------------------------------- */
#define SDMMC_RESP2_RESPONSE2_Pos             0                                                       /*!< SDMMC RESP2: RESPONSE2 Position         */
#define SDMMC_RESP2_RESPONSE2_Msk             (0xffffffffUL << SDMMC_RESP2_RESPONSE2_Pos)             /*!< SDMMC RESP2: RESPONSE2 Mask             */

/* ---------------------------------  SDMMC_RESP3  -------------------------------- */
#define SDMMC_RESP3_RESPONSE3_Pos             0                                                       /*!< SDMMC RESP3: RESPONSE3 Position         */
#define SDMMC_RESP3_RESPONSE3_Msk             (0xffffffffUL << SDMMC_RESP3_RESPONSE3_Pos)             /*!< SDMMC RESP3: RESPONSE3 Mask             */

/* --------------------------------  SDMMC_MINTSTS  ------------------------------- */
#define SDMMC_MINTSTS_CDET_Pos                0                                                       /*!< SDMMC MINTSTS: CDET Position            */
#define SDMMC_MINTSTS_CDET_Msk                (0x01UL << SDMMC_MINTSTS_CDET_Pos)                      /*!< SDMMC MINTSTS: CDET Mask                */
#define SDMMC_MINTSTS_RE_Pos                  1                                                       /*!< SDMMC MINTSTS: RE Position              */
#define SDMMC_MINTSTS_RE_Msk                  (0x01UL << SDMMC_MINTSTS_RE_Pos)                        /*!< SDMMC MINTSTS: RE Mask                  */
#define SDMMC_MINTSTS_CDONE_Pos               2                                                       /*!< SDMMC MINTSTS: CDONE Position           */
#define SDMMC_MINTSTS_CDONE_Msk               (0x01UL << SDMMC_MINTSTS_CDONE_Pos)                     /*!< SDMMC MINTSTS: CDONE Mask               */
#define SDMMC_MINTSTS_DTO_Pos                 3                                                       /*!< SDMMC MINTSTS: DTO Position             */
#define SDMMC_MINTSTS_DTO_Msk                 (0x01UL << SDMMC_MINTSTS_DTO_Pos)                       /*!< SDMMC MINTSTS: DTO Mask                 */
#define SDMMC_MINTSTS_TXDR_Pos                4                                                       /*!< SDMMC MINTSTS: TXDR Position            */
#define SDMMC_MINTSTS_TXDR_Msk                (0x01UL << SDMMC_MINTSTS_TXDR_Pos)                      /*!< SDMMC MINTSTS: TXDR Mask                */
#define SDMMC_MINTSTS_RXDR_Pos                5                                                       /*!< SDMMC MINTSTS: RXDR Position            */
#define SDMMC_MINTSTS_RXDR_Msk                (0x01UL << SDMMC_MINTSTS_RXDR_Pos)                      /*!< SDMMC MINTSTS: RXDR Mask                */
#define SDMMC_MINTSTS_RCRC_Pos                6                                                       /*!< SDMMC MINTSTS: RCRC Position            */
#define SDMMC_MINTSTS_RCRC_Msk                (0x01UL << SDMMC_MINTSTS_RCRC_Pos)                      /*!< SDMMC MINTSTS: RCRC Mask                */
#define SDMMC_MINTSTS_DCRC_Pos                7                                                       /*!< SDMMC MINTSTS: DCRC Position            */
#define SDMMC_MINTSTS_DCRC_Msk                (0x01UL << SDMMC_MINTSTS_DCRC_Pos)                      /*!< SDMMC MINTSTS: DCRC Mask                */
#define SDMMC_MINTSTS_RTO_Pos                 8                                                       /*!< SDMMC MINTSTS: RTO Position             */
#define SDMMC_MINTSTS_RTO_Msk                 (0x01UL << SDMMC_MINTSTS_RTO_Pos)                       /*!< SDMMC MINTSTS: RTO Mask                 */
#define SDMMC_MINTSTS_DRTO_Pos                9                                                       /*!< SDMMC MINTSTS: DRTO Position            */
#define SDMMC_MINTSTS_DRTO_Msk                (0x01UL << SDMMC_MINTSTS_DRTO_Pos)                      /*!< SDMMC MINTSTS: DRTO Mask                */
#define SDMMC_MINTSTS_HTO_Pos                 10                                                      /*!< SDMMC MINTSTS: HTO Position             */
#define SDMMC_MINTSTS_HTO_Msk                 (0x01UL << SDMMC_MINTSTS_HTO_Pos)                       /*!< SDMMC MINTSTS: HTO Mask                 */
#define SDMMC_MINTSTS_FRUN_Pos                11                                                      /*!< SDMMC MINTSTS: FRUN Position            */
#define SDMMC_MINTSTS_FRUN_Msk                (0x01UL << SDMMC_MINTSTS_FRUN_Pos)                      /*!< SDMMC MINTSTS: FRUN Mask                */
#define SDMMC_MINTSTS_HLE_Pos                 12                                                      /*!< SDMMC MINTSTS: HLE Position             */
#define SDMMC_MINTSTS_HLE_Msk                 (0x01UL << SDMMC_MINTSTS_HLE_Pos)                       /*!< SDMMC MINTSTS: HLE Mask                 */
#define SDMMC_MINTSTS_SBE_Pos                 13                                                      /*!< SDMMC MINTSTS: SBE Position             */
#define SDMMC_MINTSTS_SBE_Msk                 (0x01UL << SDMMC_MINTSTS_SBE_Pos)                       /*!< SDMMC MINTSTS: SBE Mask                 */
#define SDMMC_MINTSTS_ACD_Pos                 14                                                      /*!< SDMMC MINTSTS: ACD Position             */
#define SDMMC_MINTSTS_ACD_Msk                 (0x01UL << SDMMC_MINTSTS_ACD_Pos)                       /*!< SDMMC MINTSTS: ACD Mask                 */
#define SDMMC_MINTSTS_EBE_Pos                 15                                                      /*!< SDMMC MINTSTS: EBE Position             */
#define SDMMC_MINTSTS_EBE_Msk                 (0x01UL << SDMMC_MINTSTS_EBE_Pos)                       /*!< SDMMC MINTSTS: EBE Mask                 */
#define SDMMC_MINTSTS_SDIO_INTERRUPT_Pos      16                                                      /*!< SDMMC MINTSTS: SDIO_INTERRUPT Position  */
#define SDMMC_MINTSTS_SDIO_INTERRUPT_Msk      (0x01UL << SDMMC_MINTSTS_SDIO_INTERRUPT_Pos)            /*!< SDMMC MINTSTS: SDIO_INTERRUPT Mask      */

/* --------------------------------  SDMMC_RINTSTS  ------------------------------- */
#define SDMMC_RINTSTS_CDET_Pos                0                                                       /*!< SDMMC RINTSTS: CDET Position            */
#define SDMMC_RINTSTS_CDET_Msk                (0x01UL << SDMMC_RINTSTS_CDET_Pos)                      /*!< SDMMC RINTSTS: CDET Mask                */
#define SDMMC_RINTSTS_RE_Pos                  1                                                       /*!< SDMMC RINTSTS: RE Position              */
#define SDMMC_RINTSTS_RE_Msk                  (0x01UL << SDMMC_RINTSTS_RE_Pos)                        /*!< SDMMC RINTSTS: RE Mask                  */
#define SDMMC_RINTSTS_CDONE_Pos               2                                                       /*!< SDMMC RINTSTS: CDONE Position           */
#define SDMMC_RINTSTS_CDONE_Msk               (0x01UL << SDMMC_RINTSTS_CDONE_Pos)                     /*!< SDMMC RINTSTS: CDONE Mask               */
#define SDMMC_RINTSTS_DTO_Pos                 3                                                       /*!< SDMMC RINTSTS: DTO Position             */
#define SDMMC_RINTSTS_DTO_Msk                 (0x01UL << SDMMC_RINTSTS_DTO_Pos)                       /*!< SDMMC RINTSTS: DTO Mask                 */
#define SDMMC_RINTSTS_TXDR_Pos                4                                                       /*!< SDMMC RINTSTS: TXDR Position            */
#define SDMMC_RINTSTS_TXDR_Msk                (0x01UL << SDMMC_RINTSTS_TXDR_Pos)                      /*!< SDMMC RINTSTS: TXDR Mask                */
#define SDMMC_RINTSTS_RXDR_Pos                5                                                       /*!< SDMMC RINTSTS: RXDR Position            */
#define SDMMC_RINTSTS_RXDR_Msk                (0x01UL << SDMMC_RINTSTS_RXDR_Pos)                      /*!< SDMMC RINTSTS: RXDR Mask                */
#define SDMMC_RINTSTS_RCRC_Pos                6                                                       /*!< SDMMC RINTSTS: RCRC Position            */
#define SDMMC_RINTSTS_RCRC_Msk                (0x01UL << SDMMC_RINTSTS_RCRC_Pos)                      /*!< SDMMC RINTSTS: RCRC Mask                */
#define SDMMC_RINTSTS_DCRC_Pos                7                                                       /*!< SDMMC RINTSTS: DCRC Position            */
#define SDMMC_RINTSTS_DCRC_Msk                (0x01UL << SDMMC_RINTSTS_DCRC_Pos)                      /*!< SDMMC RINTSTS: DCRC Mask                */
#define SDMMC_RINTSTS_RTO_BAR_Pos             8                                                       /*!< SDMMC RINTSTS: RTO_BAR Position         */
#define SDMMC_RINTSTS_RTO_BAR_Msk             (0x01UL << SDMMC_RINTSTS_RTO_BAR_Pos)                   /*!< SDMMC RINTSTS: RTO_BAR Mask             */
#define SDMMC_RINTSTS_DRTO_BDS_Pos            9                                                       /*!< SDMMC RINTSTS: DRTO_BDS Position        */
#define SDMMC_RINTSTS_DRTO_BDS_Msk            (0x01UL << SDMMC_RINTSTS_DRTO_BDS_Pos)                  /*!< SDMMC RINTSTS: DRTO_BDS Mask            */
#define SDMMC_RINTSTS_HTO_Pos                 10                                                      /*!< SDMMC RINTSTS: HTO Position             */
#define SDMMC_RINTSTS_HTO_Msk                 (0x01UL << SDMMC_RINTSTS_HTO_Pos)                       /*!< SDMMC RINTSTS: HTO Mask                 */
#define SDMMC_RINTSTS_FRUN_Pos                11                                                      /*!< SDMMC RINTSTS: FRUN Position            */
#define SDMMC_RINTSTS_FRUN_Msk                (0x01UL << SDMMC_RINTSTS_FRUN_Pos)                      /*!< SDMMC RINTSTS: FRUN Mask                */
#define SDMMC_RINTSTS_HLE_Pos                 12                                                      /*!< SDMMC RINTSTS: HLE Position             */
#define SDMMC_RINTSTS_HLE_Msk                 (0x01UL << SDMMC_RINTSTS_HLE_Pos)                       /*!< SDMMC RINTSTS: HLE Mask                 */
#define SDMMC_RINTSTS_SBE_Pos                 13                                                      /*!< SDMMC RINTSTS: SBE Position             */
#define SDMMC_RINTSTS_SBE_Msk                 (0x01UL << SDMMC_RINTSTS_SBE_Pos)                       /*!< SDMMC RINTSTS: SBE Mask                 */
#define SDMMC_RINTSTS_ACD_Pos                 14                                                      /*!< SDMMC RINTSTS: ACD Position             */
#define SDMMC_RINTSTS_ACD_Msk                 (0x01UL << SDMMC_RINTSTS_ACD_Pos)                       /*!< SDMMC RINTSTS: ACD Mask                 */
#define SDMMC_RINTSTS_EBE_Pos                 15                                                      /*!< SDMMC RINTSTS: EBE Position             */
#define SDMMC_RINTSTS_EBE_Msk                 (0x01UL << SDMMC_RINTSTS_EBE_Pos)                       /*!< SDMMC RINTSTS: EBE Mask                 */
#define SDMMC_RINTSTS_SDIO_INTERRUPT_Pos      16                                                      /*!< SDMMC RINTSTS: SDIO_INTERRUPT Position  */
#define SDMMC_RINTSTS_SDIO_INTERRUPT_Msk      (0x01UL << SDMMC_RINTSTS_SDIO_INTERRUPT_Pos)            /*!< SDMMC RINTSTS: SDIO_INTERRUPT Mask      */

/* --------------------------------  SDMMC_STATUS  -------------------------------- */
#define SDMMC_STATUS_FIFO_RX_WATERMARK_Pos    0                                                       /*!< SDMMC STATUS: FIFO_RX_WATERMARK Position */
#define SDMMC_STATUS_FIFO_RX_WATERMARK_Msk    (0x01UL << SDMMC_STATUS_FIFO_RX_WATERMARK_Pos)          /*!< SDMMC STATUS: FIFO_RX_WATERMARK Mask    */
#define SDMMC_STATUS_FIFO_TX_WATERMARK_Pos    1                                                       /*!< SDMMC STATUS: FIFO_TX_WATERMARK Position */
#define SDMMC_STATUS_FIFO_TX_WATERMARK_Msk    (0x01UL << SDMMC_STATUS_FIFO_TX_WATERMARK_Pos)          /*!< SDMMC STATUS: FIFO_TX_WATERMARK Mask    */
#define SDMMC_STATUS_FIFO_EMPTY_Pos           2                                                       /*!< SDMMC STATUS: FIFO_EMPTY Position       */
#define SDMMC_STATUS_FIFO_EMPTY_Msk           (0x01UL << SDMMC_STATUS_FIFO_EMPTY_Pos)                 /*!< SDMMC STATUS: FIFO_EMPTY Mask           */
#define SDMMC_STATUS_FIFO_FULL_Pos            3                                                       /*!< SDMMC STATUS: FIFO_FULL Position        */
#define SDMMC_STATUS_FIFO_FULL_Msk            (0x01UL << SDMMC_STATUS_FIFO_FULL_Pos)                  /*!< SDMMC STATUS: FIFO_FULL Mask            */
#define SDMMC_STATUS_CMDFSMSTATES_Pos         4                                                       /*!< SDMMC STATUS: CMDFSMSTATES Position     */
#define SDMMC_STATUS_CMDFSMSTATES_Msk         (0x0fUL << SDMMC_STATUS_CMDFSMSTATES_Pos)               /*!< SDMMC STATUS: CMDFSMSTATES Mask         */
#define SDMMC_STATUS_DATA_3_STATUS_Pos        8                                                       /*!< SDMMC STATUS: DATA_3_STATUS Position    */
#define SDMMC_STATUS_DATA_3_STATUS_Msk        (0x01UL << SDMMC_STATUS_DATA_3_STATUS_Pos)              /*!< SDMMC STATUS: DATA_3_STATUS Mask        */
#define SDMMC_STATUS_DATA_BUSY_Pos            9                                                       /*!< SDMMC STATUS: DATA_BUSY Position        */
#define SDMMC_STATUS_DATA_BUSY_Msk            (0x01UL << SDMMC_STATUS_DATA_BUSY_Pos)                  /*!< SDMMC STATUS: DATA_BUSY Mask            */
#define SDMMC_STATUS_DATA_STATE_MC_BUSY_Pos   10                                                      /*!< SDMMC STATUS: DATA_STATE_MC_BUSY Position */
#define SDMMC_STATUS_DATA_STATE_MC_BUSY_Msk   (0x01UL << SDMMC_STATUS_DATA_STATE_MC_BUSY_Pos)         /*!< SDMMC STATUS: DATA_STATE_MC_BUSY Mask   */
#define SDMMC_STATUS_RESPONSE_INDEX_Pos       11                                                      /*!< SDMMC STATUS: RESPONSE_INDEX Position   */
#define SDMMC_STATUS_RESPONSE_INDEX_Msk       (0x3fUL << SDMMC_STATUS_RESPONSE_INDEX_Pos)             /*!< SDMMC STATUS: RESPONSE_INDEX Mask       */
#define SDMMC_STATUS_FIFO_COUNT_Pos           17                                                      /*!< SDMMC STATUS: FIFO_COUNT Position       */
#define SDMMC_STATUS_FIFO_COUNT_Msk           (0x00001fffUL << SDMMC_STATUS_FIFO_COUNT_Pos)           /*!< SDMMC STATUS: FIFO_COUNT Mask           */
#define SDMMC_STATUS_DMA_ACK_Pos              30                                                      /*!< SDMMC STATUS: DMA_ACK Position          */
#define SDMMC_STATUS_DMA_ACK_Msk              (0x01UL << SDMMC_STATUS_DMA_ACK_Pos)                    /*!< SDMMC STATUS: DMA_ACK Mask              */
#define SDMMC_STATUS_DMA_REQ_Pos              31                                                      /*!< SDMMC STATUS: DMA_REQ Position          */
#define SDMMC_STATUS_DMA_REQ_Msk              (0x01UL << SDMMC_STATUS_DMA_REQ_Pos)                    /*!< SDMMC STATUS: DMA_REQ Mask              */

/* --------------------------------  SDMMC_FIFOTH  -------------------------------- */
#define SDMMC_FIFOTH_TX_WMARK_Pos             0                                                       /*!< SDMMC FIFOTH: TX_WMARK Position         */
#define SDMMC_FIFOTH_TX_WMARK_Msk             (0x00000fffUL << SDMMC_FIFOTH_TX_WMARK_Pos)             /*!< SDMMC FIFOTH: TX_WMARK Mask             */
#define SDMMC_FIFOTH_RX_WMARK_Pos             16                                                      /*!< SDMMC FIFOTH: RX_WMARK Position         */
#define SDMMC_FIFOTH_RX_WMARK_Msk             (0x00000fffUL << SDMMC_FIFOTH_RX_WMARK_Pos)             /*!< SDMMC FIFOTH: RX_WMARK Mask             */
#define SDMMC_FIFOTH_DMA_MTS_Pos              28                                                      /*!< SDMMC FIFOTH: DMA_MTS Position          */
#define SDMMC_FIFOTH_DMA_MTS_Msk              (0x07UL << SDMMC_FIFOTH_DMA_MTS_Pos)                    /*!< SDMMC FIFOTH: DMA_MTS Mask              */

/* --------------------------------  SDMMC_CDETECT  ------------------------------- */
#define SDMMC_CDETECT_CARD_DETECT_Pos         0                                                       /*!< SDMMC CDETECT: CARD_DETECT Position     */
#define SDMMC_CDETECT_CARD_DETECT_Msk         (0x01UL << SDMMC_CDETECT_CARD_DETECT_Pos)               /*!< SDMMC CDETECT: CARD_DETECT Mask         */

/* --------------------------------  SDMMC_WRTPRT  -------------------------------- */
#define SDMMC_WRTPRT_WRITE_PROTECT_Pos        0                                                       /*!< SDMMC WRTPRT: WRITE_PROTECT Position    */
#define SDMMC_WRTPRT_WRITE_PROTECT_Msk        (0x01UL << SDMMC_WRTPRT_WRITE_PROTECT_Pos)              /*!< SDMMC WRTPRT: WRITE_PROTECT Mask        */

/* --------------------------------  SDMMC_TCBCNT  -------------------------------- */
#define SDMMC_TCBCNT_TRANS_CARD_BYTE_COUNT_Pos 0                                                      /*!< SDMMC TCBCNT: TRANS_CARD_BYTE_COUNT Position */
#define SDMMC_TCBCNT_TRANS_CARD_BYTE_COUNT_Msk (0xffffffffUL << SDMMC_TCBCNT_TRANS_CARD_BYTE_COUNT_Pos)/*!< SDMMC TCBCNT: TRANS_CARD_BYTE_COUNT Mask */

/* --------------------------------  SDMMC_TBBCNT  -------------------------------- */
#define SDMMC_TBBCNT_TRANS_FIFO_BYTE_COUNT_Pos 0                                                      /*!< SDMMC TBBCNT: TRANS_FIFO_BYTE_COUNT Position */
#define SDMMC_TBBCNT_TRANS_FIFO_BYTE_COUNT_Msk (0xffffffffUL << SDMMC_TBBCNT_TRANS_FIFO_BYTE_COUNT_Pos)/*!< SDMMC TBBCNT: TRANS_FIFO_BYTE_COUNT Mask */

/* --------------------------------  SDMMC_DEBNCE  -------------------------------- */
#define SDMMC_DEBNCE_DEBOUNCE_COUNT_Pos       0                                                       /*!< SDMMC DEBNCE: DEBOUNCE_COUNT Position   */
#define SDMMC_DEBNCE_DEBOUNCE_COUNT_Msk       (0x00ffffffUL << SDMMC_DEBNCE_DEBOUNCE_COUNT_Pos)       /*!< SDMMC DEBNCE: DEBOUNCE_COUNT Mask       */

/* ---------------------------------  SDMMC_RST_N  -------------------------------- */
#define SDMMC_RST_N_CARD_RESET_Pos            0                                                       /*!< SDMMC RST_N: CARD_RESET Position        */
#define SDMMC_RST_N_CARD_RESET_Msk            (0x01UL << SDMMC_RST_N_CARD_RESET_Pos)                  /*!< SDMMC RST_N: CARD_RESET Mask            */

/* ---------------------------------  SDMMC_BMOD  --------------------------------- */
#define SDMMC_BMOD_SWR_Pos                    0                                                       /*!< SDMMC BMOD: SWR Position                */
#define SDMMC_BMOD_SWR_Msk                    (0x01UL << SDMMC_BMOD_SWR_Pos)                          /*!< SDMMC BMOD: SWR Mask                    */
#define SDMMC_BMOD_FB_Pos                     1                                                       /*!< SDMMC BMOD: FB Position                 */
#define SDMMC_BMOD_FB_Msk                     (0x01UL << SDMMC_BMOD_FB_Pos)                           /*!< SDMMC BMOD: FB Mask                     */
#define SDMMC_BMOD_DSL_Pos                    2                                                       /*!< SDMMC BMOD: DSL Position                */
#define SDMMC_BMOD_DSL_Msk                    (0x1fUL << SDMMC_BMOD_DSL_Pos)                          /*!< SDMMC BMOD: DSL Mask                    */
#define SDMMC_BMOD_DE_Pos                     7                                                       /*!< SDMMC BMOD: DE Position                 */
#define SDMMC_BMOD_DE_Msk                     (0x01UL << SDMMC_BMOD_DE_Pos)                           /*!< SDMMC BMOD: DE Mask                     */
#define SDMMC_BMOD_PBL_Pos                    8                                                       /*!< SDMMC BMOD: PBL Position                */
#define SDMMC_BMOD_PBL_Msk                    (0x07UL << SDMMC_BMOD_PBL_Pos)                          /*!< SDMMC BMOD: PBL Mask                    */

/* --------------------------------  SDMMC_PLDMND  -------------------------------- */
#define SDMMC_PLDMND_PD_Pos                   0                                                       /*!< SDMMC PLDMND: PD Position               */
#define SDMMC_PLDMND_PD_Msk                   (0xffffffffUL << SDMMC_PLDMND_PD_Pos)                   /*!< SDMMC PLDMND: PD Mask                   */

/* --------------------------------  SDMMC_DBADDR  -------------------------------- */
#define SDMMC_DBADDR_SDL_Pos                  0                                                       /*!< SDMMC DBADDR: SDL Position              */
#define SDMMC_DBADDR_SDL_Msk                  (0xffffffffUL << SDMMC_DBADDR_SDL_Pos)                  /*!< SDMMC DBADDR: SDL Mask                  */

/* ---------------------------------  SDMMC_IDSTS  -------------------------------- */
#define SDMMC_IDSTS_TI_Pos                    0                                                       /*!< SDMMC IDSTS: TI Position                */
#define SDMMC_IDSTS_TI_Msk                    (0x01UL << SDMMC_IDSTS_TI_Pos)                          /*!< SDMMC IDSTS: TI Mask                    */
#define SDMMC_IDSTS_RI_Pos                    1                                                       /*!< SDMMC IDSTS: RI Position                */
#define SDMMC_IDSTS_RI_Msk                    (0x01UL << SDMMC_IDSTS_RI_Pos)                          /*!< SDMMC IDSTS: RI Mask                    */
#define SDMMC_IDSTS_FBE_Pos                   2                                                       /*!< SDMMC IDSTS: FBE Position               */
#define SDMMC_IDSTS_FBE_Msk                   (0x01UL << SDMMC_IDSTS_FBE_Pos)                         /*!< SDMMC IDSTS: FBE Mask                   */
#define SDMMC_IDSTS_DU_Pos                    4                                                       /*!< SDMMC IDSTS: DU Position                */
#define SDMMC_IDSTS_DU_Msk                    (0x01UL << SDMMC_IDSTS_DU_Pos)                          /*!< SDMMC IDSTS: DU Mask                    */
#define SDMMC_IDSTS_CES_Pos                   5                                                       /*!< SDMMC IDSTS: CES Position               */
#define SDMMC_IDSTS_CES_Msk                   (0x01UL << SDMMC_IDSTS_CES_Pos)                         /*!< SDMMC IDSTS: CES Mask                   */
#define SDMMC_IDSTS_NIS_Pos                   8                                                       /*!< SDMMC IDSTS: NIS Position               */
#define SDMMC_IDSTS_NIS_Msk                   (0x01UL << SDMMC_IDSTS_NIS_Pos)                         /*!< SDMMC IDSTS: NIS Mask                   */
#define SDMMC_IDSTS_AIS_Pos                   9                                                       /*!< SDMMC IDSTS: AIS Position               */
#define SDMMC_IDSTS_AIS_Msk                   (0x01UL << SDMMC_IDSTS_AIS_Pos)                         /*!< SDMMC IDSTS: AIS Mask                   */
#define SDMMC_IDSTS_EB_Pos                    10                                                      /*!< SDMMC IDSTS: EB Position                */
#define SDMMC_IDSTS_EB_Msk                    (0x07UL << SDMMC_IDSTS_EB_Pos)                          /*!< SDMMC IDSTS: EB Mask                    */
#define SDMMC_IDSTS_FSM_Pos                   13                                                      /*!< SDMMC IDSTS: FSM Position               */
#define SDMMC_IDSTS_FSM_Msk                   (0x0fUL << SDMMC_IDSTS_FSM_Pos)                         /*!< SDMMC IDSTS: FSM Mask                   */

/* --------------------------------  SDMMC_IDINTEN  ------------------------------- */
#define SDMMC_IDINTEN_TI_Pos                  0                                                       /*!< SDMMC IDINTEN: TI Position              */
#define SDMMC_IDINTEN_TI_Msk                  (0x01UL << SDMMC_IDINTEN_TI_Pos)                        /*!< SDMMC IDINTEN: TI Mask                  */
#define SDMMC_IDINTEN_RI_Pos                  1                                                       /*!< SDMMC IDINTEN: RI Position              */
#define SDMMC_IDINTEN_RI_Msk                  (0x01UL << SDMMC_IDINTEN_RI_Pos)                        /*!< SDMMC IDINTEN: RI Mask                  */
#define SDMMC_IDINTEN_FBE_Pos                 2                                                       /*!< SDMMC IDINTEN: FBE Position             */
#define SDMMC_IDINTEN_FBE_Msk                 (0x01UL << SDMMC_IDINTEN_FBE_Pos)                       /*!< SDMMC IDINTEN: FBE Mask                 */
#define SDMMC_IDINTEN_DU_Pos                  4                                                       /*!< SDMMC IDINTEN: DU Position              */
#define SDMMC_IDINTEN_DU_Msk                  (0x01UL << SDMMC_IDINTEN_DU_Pos)                        /*!< SDMMC IDINTEN: DU Mask                  */
#define SDMMC_IDINTEN_CES_Pos                 5                                                       /*!< SDMMC IDINTEN: CES Position             */
#define SDMMC_IDINTEN_CES_Msk                 (0x01UL << SDMMC_IDINTEN_CES_Pos)                       /*!< SDMMC IDINTEN: CES Mask                 */
#define SDMMC_IDINTEN_NIS_Pos                 8                                                       /*!< SDMMC IDINTEN: NIS Position             */
#define SDMMC_IDINTEN_NIS_Msk                 (0x01UL << SDMMC_IDINTEN_NIS_Pos)                       /*!< SDMMC IDINTEN: NIS Mask                 */
#define SDMMC_IDINTEN_AIS_Pos                 9                                                       /*!< SDMMC IDINTEN: AIS Position             */
#define SDMMC_IDINTEN_AIS_Msk                 (0x01UL << SDMMC_IDINTEN_AIS_Pos)                       /*!< SDMMC IDINTEN: AIS Mask                 */

/* --------------------------------  SDMMC_DSCADDR  ------------------------------- */
#define SDMMC_DSCADDR_HDA_Pos                 0                                                       /*!< SDMMC DSCADDR: HDA Position             */
#define SDMMC_DSCADDR_HDA_Msk                 (0xffffffffUL << SDMMC_DSCADDR_HDA_Pos)                 /*!< SDMMC DSCADDR: HDA Mask                 */

/* --------------------------------  SDMMC_BUFADDR  ------------------------------- */
#define SDMMC_BUFADDR_HBA_Pos                 0                                                       /*!< SDMMC BUFADDR: HBA Position             */
#define SDMMC_BUFADDR_HBA_Msk                 (0xffffffffUL << SDMMC_BUFADDR_HBA_Pos)                 /*!< SDMMC BUFADDR: HBA Mask                 */


/* ================================================================================ */
/* ================          struct 'EMC' Position & Mask          ================ */
/* ================================================================================ */


/* ---------------------------------  EMC_CONTROL  -------------------------------- */
#define EMC_CONTROL_E_Pos                     0                                                       /*!< EMC CONTROL: E Position                 */
#define EMC_CONTROL_E_Msk                     (0x01UL << EMC_CONTROL_E_Pos)                           /*!< EMC CONTROL: E Mask                     */
#define EMC_CONTROL_M_Pos                     1                                                       /*!< EMC CONTROL: M Position                 */
#define EMC_CONTROL_M_Msk                     (0x01UL << EMC_CONTROL_M_Pos)                           /*!< EMC CONTROL: M Mask                     */
#define EMC_CONTROL_L_Pos                     2                                                       /*!< EMC CONTROL: L Position                 */
#define EMC_CONTROL_L_Msk                     (0x01UL << EMC_CONTROL_L_Pos)                           /*!< EMC CONTROL: L Mask                     */

/* ---------------------------------  EMC_STATUS  --------------------------------- */
#define EMC_STATUS_B_Pos                      0                                                       /*!< EMC STATUS: B Position                  */
#define EMC_STATUS_B_Msk                      (0x01UL << EMC_STATUS_B_Pos)                            /*!< EMC STATUS: B Mask                      */
#define EMC_STATUS_S_Pos                      1                                                       /*!< EMC STATUS: S Position                  */
#define EMC_STATUS_S_Msk                      (0x01UL << EMC_STATUS_S_Pos)                            /*!< EMC STATUS: S Mask                      */
#define EMC_STATUS_SA_Pos                     2                                                       /*!< EMC STATUS: SA Position                 */
#define EMC_STATUS_SA_Msk                     (0x01UL << EMC_STATUS_SA_Pos)                           /*!< EMC STATUS: SA Mask                     */

/* ---------------------------------  EMC_CONFIG  --------------------------------- */
#define EMC_CONFIG_EM_Pos                     0                                                       /*!< EMC CONFIG: EM Position                 */
#define EMC_CONFIG_EM_Msk                     (0x01UL << EMC_CONFIG_EM_Pos)                           /*!< EMC CONFIG: EM Mask                     */

/* -----------------------------  EMC_DYNAMICCONTROL  ----------------------------- */
#define EMC_DYNAMICCONTROL_CE_Pos             0                                                       /*!< EMC DYNAMICCONTROL: CE Position         */
#define EMC_DYNAMICCONTROL_CE_Msk             (0x01UL << EMC_DYNAMICCONTROL_CE_Pos)                   /*!< EMC DYNAMICCONTROL: CE Mask             */
#define EMC_DYNAMICCONTROL_CS_Pos             1                                                       /*!< EMC DYNAMICCONTROL: CS Position         */
#define EMC_DYNAMICCONTROL_CS_Msk             (0x01UL << EMC_DYNAMICCONTROL_CS_Pos)                   /*!< EMC DYNAMICCONTROL: CS Mask             */
#define EMC_DYNAMICCONTROL_SR_Pos             2                                                       /*!< EMC DYNAMICCONTROL: SR Position         */
#define EMC_DYNAMICCONTROL_SR_Msk             (0x01UL << EMC_DYNAMICCONTROL_SR_Pos)                   /*!< EMC DYNAMICCONTROL: SR Mask             */
#define EMC_DYNAMICCONTROL_MMC_Pos            5                                                       /*!< EMC DYNAMICCONTROL: MMC Position        */
#define EMC_DYNAMICCONTROL_MMC_Msk            (0x01UL << EMC_DYNAMICCONTROL_MMC_Pos)                  /*!< EMC DYNAMICCONTROL: MMC Mask            */
#define EMC_DYNAMICCONTROL_I_Pos              7                                                       /*!< EMC DYNAMICCONTROL: I Position          */
#define EMC_DYNAMICCONTROL_I_Msk              (0x03UL << EMC_DYNAMICCONTROL_I_Pos)                    /*!< EMC DYNAMICCONTROL: I Mask              */

/* -----------------------------  EMC_DYNAMICREFRESH  ----------------------------- */
#define EMC_DYNAMICREFRESH_REFRESH_Pos        0                                                       /*!< EMC DYNAMICREFRESH: REFRESH Position    */
#define EMC_DYNAMICREFRESH_REFRESH_Msk        (0x000007ffUL << EMC_DYNAMICREFRESH_REFRESH_Pos)        /*!< EMC DYNAMICREFRESH: REFRESH Mask        */

/* ----------------------------  EMC_DYNAMICREADCONFIG  --------------------------- */
#define EMC_DYNAMICREADCONFIG_RD_Pos          0                                                       /*!< EMC DYNAMICREADCONFIG: RD Position      */
#define EMC_DYNAMICREADCONFIG_RD_Msk          (0x03UL << EMC_DYNAMICREADCONFIG_RD_Pos)                /*!< EMC DYNAMICREADCONFIG: RD Mask          */

/* --------------------------------  EMC_DYNAMICRP  ------------------------------- */
#define EMC_DYNAMICRP_TRP_Pos                 0                                                       /*!< EMC DYNAMICRP: TRP Position             */
#define EMC_DYNAMICRP_TRP_Msk                 (0x0fUL << EMC_DYNAMICRP_TRP_Pos)                       /*!< EMC DYNAMICRP: TRP Mask                 */

/* -------------------------------  EMC_DYNAMICRAS  ------------------------------- */
#define EMC_DYNAMICRAS_TRAS_Pos               0                                                       /*!< EMC DYNAMICRAS: TRAS Position           */
#define EMC_DYNAMICRAS_TRAS_Msk               (0x0fUL << EMC_DYNAMICRAS_TRAS_Pos)                     /*!< EMC DYNAMICRAS: TRAS Mask               */

/* -------------------------------  EMC_DYNAMICSREX  ------------------------------ */
#define EMC_DYNAMICSREX_TSREX_Pos             0                                                       /*!< EMC DYNAMICSREX: TSREX Position         */
#define EMC_DYNAMICSREX_TSREX_Msk             (0x0fUL << EMC_DYNAMICSREX_TSREX_Pos)                   /*!< EMC DYNAMICSREX: TSREX Mask             */

/* -------------------------------  EMC_DYNAMICAPR  ------------------------------- */
#define EMC_DYNAMICAPR_TAPR_Pos               0                                                       /*!< EMC DYNAMICAPR: TAPR Position           */
#define EMC_DYNAMICAPR_TAPR_Msk               (0x0fUL << EMC_DYNAMICAPR_TAPR_Pos)                     /*!< EMC DYNAMICAPR: TAPR Mask               */

/* -------------------------------  EMC_DYNAMICDAL  ------------------------------- */
#define EMC_DYNAMICDAL_TDAL_Pos               0                                                       /*!< EMC DYNAMICDAL: TDAL Position           */
#define EMC_DYNAMICDAL_TDAL_Msk               (0x0fUL << EMC_DYNAMICDAL_TDAL_Pos)                     /*!< EMC DYNAMICDAL: TDAL Mask               */

/* --------------------------------  EMC_DYNAMICWR  ------------------------------- */
#define EMC_DYNAMICWR_TWR_Pos                 0                                                       /*!< EMC DYNAMICWR: TWR Position             */
#define EMC_DYNAMICWR_TWR_Msk                 (0x0fUL << EMC_DYNAMICWR_TWR_Pos)                       /*!< EMC DYNAMICWR: TWR Mask                 */

/* --------------------------------  EMC_DYNAMICRC  ------------------------------- */
#define EMC_DYNAMICRC_TRC_Pos                 0                                                       /*!< EMC DYNAMICRC: TRC Position             */
#define EMC_DYNAMICRC_TRC_Msk                 (0x1fUL << EMC_DYNAMICRC_TRC_Pos)                       /*!< EMC DYNAMICRC: TRC Mask                 */

/* -------------------------------  EMC_DYNAMICRFC  ------------------------------- */
#define EMC_DYNAMICRFC_TRFC_Pos               0                                                       /*!< EMC DYNAMICRFC: TRFC Position           */
#define EMC_DYNAMICRFC_TRFC_Msk               (0x1fUL << EMC_DYNAMICRFC_TRFC_Pos)                     /*!< EMC DYNAMICRFC: TRFC Mask               */

/* -------------------------------  EMC_DYNAMICXSR  ------------------------------- */
#define EMC_DYNAMICXSR_TXSR_Pos               0                                                       /*!< EMC DYNAMICXSR: TXSR Position           */
#define EMC_DYNAMICXSR_TXSR_Msk               (0x1fUL << EMC_DYNAMICXSR_TXSR_Pos)                     /*!< EMC DYNAMICXSR: TXSR Mask               */

/* -------------------------------  EMC_DYNAMICRRD  ------------------------------- */
#define EMC_DYNAMICRRD_TRRD_Pos               0                                                       /*!< EMC DYNAMICRRD: TRRD Position           */
#define EMC_DYNAMICRRD_TRRD_Msk               (0x0fUL << EMC_DYNAMICRRD_TRRD_Pos)                     /*!< EMC DYNAMICRRD: TRRD Mask               */

/* -------------------------------  EMC_DYNAMICMRD  ------------------------------- */
#define EMC_DYNAMICMRD_TMRD_Pos               0                                                       /*!< EMC DYNAMICMRD: TMRD Position           */
#define EMC_DYNAMICMRD_TMRD_Msk               (0x0fUL << EMC_DYNAMICMRD_TMRD_Pos)                     /*!< EMC DYNAMICMRD: TMRD Mask               */

/* ---------------------------  EMC_STATICEXTENDEDWAIT  --------------------------- */
#define EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_Pos 0                                                     /*!< EMC STATICEXTENDEDWAIT: EXTENDEDWAIT Position */
#define EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_Msk (0x000003ffUL << EMC_STATICEXTENDEDWAIT_EXTENDEDWAIT_Pos)/*!< EMC STATICEXTENDEDWAIT: EXTENDEDWAIT Mask */

/* -----------------------------  EMC_DYNAMICCONFIG0  ----------------------------- */
#define EMC_DYNAMICCONFIG0_MD_Pos             3                                                       /*!< EMC DYNAMICCONFIG0: MD Position         */
#define EMC_DYNAMICCONFIG0_MD_Msk             (0x03UL << EMC_DYNAMICCONFIG0_MD_Pos)                   /*!< EMC DYNAMICCONFIG0: MD Mask             */
#define EMC_DYNAMICCONFIG0_AM0_Pos            7                                                       /*!< EMC DYNAMICCONFIG0: AM0 Position        */
#define EMC_DYNAMICCONFIG0_AM0_Msk            (0x3fUL << EMC_DYNAMICCONFIG0_AM0_Pos)                  /*!< EMC DYNAMICCONFIG0: AM0 Mask            */
#define EMC_DYNAMICCONFIG0_AM1_Pos            14                                                      /*!< EMC DYNAMICCONFIG0: AM1 Position        */
#define EMC_DYNAMICCONFIG0_AM1_Msk            (0x01UL << EMC_DYNAMICCONFIG0_AM1_Pos)                  /*!< EMC DYNAMICCONFIG0: AM1 Mask            */
#define EMC_DYNAMICCONFIG0_B_Pos              19                                                      /*!< EMC DYNAMICCONFIG0: B Position          */
#define EMC_DYNAMICCONFIG0_B_Msk              (0x01UL << EMC_DYNAMICCONFIG0_B_Pos)                    /*!< EMC DYNAMICCONFIG0: B Mask              */
#define EMC_DYNAMICCONFIG0_P_Pos              20                                                      /*!< EMC DYNAMICCONFIG0: P Position          */
#define EMC_DYNAMICCONFIG0_P_Msk              (0x01UL << EMC_DYNAMICCONFIG0_P_Pos)                    /*!< EMC DYNAMICCONFIG0: P Mask              */

/* -----------------------------  EMC_DYNAMICRASCAS0  ----------------------------- */
#define EMC_DYNAMICRASCAS0_RAS_Pos            0                                                       /*!< EMC DYNAMICRASCAS0: RAS Position        */
#define EMC_DYNAMICRASCAS0_RAS_Msk            (0x03UL << EMC_DYNAMICRASCAS0_RAS_Pos)                  /*!< EMC DYNAMICRASCAS0: RAS Mask            */
#define EMC_DYNAMICRASCAS0_CAS_Pos            8                                                       /*!< EMC DYNAMICRASCAS0: CAS Position        */
#define EMC_DYNAMICRASCAS0_CAS_Msk            (0x03UL << EMC_DYNAMICRASCAS0_CAS_Pos)                  /*!< EMC DYNAMICRASCAS0: CAS Mask            */

/* -----------------------------  EMC_DYNAMICCONFIG1  ----------------------------- */
#define EMC_DYNAMICCONFIG1_MD_Pos             3                                                       /*!< EMC DYNAMICCONFIG1: MD Position         */
#define EMC_DYNAMICCONFIG1_MD_Msk             (0x03UL << EMC_DYNAMICCONFIG1_MD_Pos)                   /*!< EMC DYNAMICCONFIG1: MD Mask             */
#define EMC_DYNAMICCONFIG1_AM0_Pos            7                                                       /*!< EMC DYNAMICCONFIG1: AM0 Position        */
#define EMC_DYNAMICCONFIG1_AM0_Msk            (0x3fUL << EMC_DYNAMICCONFIG1_AM0_Pos)                  /*!< EMC DYNAMICCONFIG1: AM0 Mask            */
#define EMC_DYNAMICCONFIG1_AM1_Pos            14                                                      /*!< EMC DYNAMICCONFIG1: AM1 Position        */
#define EMC_DYNAMICCONFIG1_AM1_Msk            (0x01UL << EMC_DYNAMICCONFIG1_AM1_Pos)                  /*!< EMC DYNAMICCONFIG1: AM1 Mask            */
#define EMC_DYNAMICCONFIG1_B_Pos              19                                                      /*!< EMC DYNAMICCONFIG1: B Position          */
#define EMC_DYNAMICCONFIG1_B_Msk              (0x01UL << EMC_DYNAMICCONFIG1_B_Pos)                    /*!< EMC DYNAMICCONFIG1: B Mask              */
#define EMC_DYNAMICCONFIG1_P_Pos              20                                                      /*!< EMC DYNAMICCONFIG1: P Position          */
#define EMC_DYNAMICCONFIG1_P_Msk              (0x01UL << EMC_DYNAMICCONFIG1_P_Pos)                    /*!< EMC DYNAMICCONFIG1: P Mask              */

/* -----------------------------  EMC_DYNAMICRASCAS1  ----------------------------- */
#define EMC_DYNAMICRASCAS1_RAS_Pos            0                                                       /*!< EMC DYNAMICRASCAS1: RAS Position        */
#define EMC_DYNAMICRASCAS1_RAS_Msk            (0x03UL << EMC_DYNAMICRASCAS1_RAS_Pos)                  /*!< EMC DYNAMICRASCAS1: RAS Mask            */
#define EMC_DYNAMICRASCAS1_CAS_Pos            8                                                       /*!< EMC DYNAMICRASCAS1: CAS Position        */
#define EMC_DYNAMICRASCAS1_CAS_Msk            (0x03UL << EMC_DYNAMICRASCAS1_CAS_Pos)                  /*!< EMC DYNAMICRASCAS1: CAS Mask            */

/* -----------------------------  EMC_DYNAMICCONFIG2  ----------------------------- */
#define EMC_DYNAMICCONFIG2_MD_Pos             3                                                       /*!< EMC DYNAMICCONFIG2: MD Position         */
#define EMC_DYNAMICCONFIG2_MD_Msk             (0x03UL << EMC_DYNAMICCONFIG2_MD_Pos)                   /*!< EMC DYNAMICCONFIG2: MD Mask             */
#define EMC_DYNAMICCONFIG2_AM0_Pos            7                                                       /*!< EMC DYNAMICCONFIG2: AM0 Position        */
#define EMC_DYNAMICCONFIG2_AM0_Msk            (0x3fUL << EMC_DYNAMICCONFIG2_AM0_Pos)                  /*!< EMC DYNAMICCONFIG2: AM0 Mask            */
#define EMC_DYNAMICCONFIG2_AM1_Pos            14                                                      /*!< EMC DYNAMICCONFIG2: AM1 Position        */
#define EMC_DYNAMICCONFIG2_AM1_Msk            (0x01UL << EMC_DYNAMICCONFIG2_AM1_Pos)                  /*!< EMC DYNAMICCONFIG2: AM1 Mask            */
#define EMC_DYNAMICCONFIG2_B_Pos              19                                                      /*!< EMC DYNAMICCONFIG2: B Position          */
#define EMC_DYNAMICCONFIG2_B_Msk              (0x01UL << EMC_DYNAMICCONFIG2_B_Pos)                    /*!< EMC DYNAMICCONFIG2: B Mask              */
#define EMC_DYNAMICCONFIG2_P_Pos              20                                                      /*!< EMC DYNAMICCONFIG2: P Position          */
#define EMC_DYNAMICCONFIG2_P_Msk              (0x01UL << EMC_DYNAMICCONFIG2_P_Pos)                    /*!< EMC DYNAMICCONFIG2: P Mask              */

/* -----------------------------  EMC_DYNAMICRASCAS2  ----------------------------- */
#define EMC_DYNAMICRASCAS2_RAS_Pos            0                                                       /*!< EMC DYNAMICRASCAS2: RAS Position        */
#define EMC_DYNAMICRASCAS2_RAS_Msk            (0x03UL << EMC_DYNAMICRASCAS2_RAS_Pos)                  /*!< EMC DYNAMICRASCAS2: RAS Mask            */
#define EMC_DYNAMICRASCAS2_CAS_Pos            8                                                       /*!< EMC DYNAMICRASCAS2: CAS Position        */
#define EMC_DYNAMICRASCAS2_CAS_Msk            (0x03UL << EMC_DYNAMICRASCAS2_CAS_Pos)                  /*!< EMC DYNAMICRASCAS2: CAS Mask            */

/* -----------------------------  EMC_DYNAMICCONFIG3  ----------------------------- */
#define EMC_DYNAMICCONFIG3_MD_Pos             3                                                       /*!< EMC DYNAMICCONFIG3: MD Position         */
#define EMC_DYNAMICCONFIG3_MD_Msk             (0x03UL << EMC_DYNAMICCONFIG3_MD_Pos)                   /*!< EMC DYNAMICCONFIG3: MD Mask             */
#define EMC_DYNAMICCONFIG3_AM0_Pos            7                                                       /*!< EMC DYNAMICCONFIG3: AM0 Position        */
#define EMC_DYNAMICCONFIG3_AM0_Msk            (0x3fUL << EMC_DYNAMICCONFIG3_AM0_Pos)                  /*!< EMC DYNAMICCONFIG3: AM0 Mask            */
#define EMC_DYNAMICCONFIG3_AM1_Pos            14                                                      /*!< EMC DYNAMICCONFIG3: AM1 Position        */
#define EMC_DYNAMICCONFIG3_AM1_Msk            (0x01UL << EMC_DYNAMICCONFIG3_AM1_Pos)                  /*!< EMC DYNAMICCONFIG3: AM1 Mask            */
#define EMC_DYNAMICCONFIG3_B_Pos              19                                                      /*!< EMC DYNAMICCONFIG3: B Position          */
#define EMC_DYNAMICCONFIG3_B_Msk              (0x01UL << EMC_DYNAMICCONFIG3_B_Pos)                    /*!< EMC DYNAMICCONFIG3: B Mask              */
#define EMC_DYNAMICCONFIG3_P_Pos              20                                                      /*!< EMC DYNAMICCONFIG3: P Position          */
#define EMC_DYNAMICCONFIG3_P_Msk              (0x01UL << EMC_DYNAMICCONFIG3_P_Pos)                    /*!< EMC DYNAMICCONFIG3: P Mask              */

/* -----------------------------  EMC_DYNAMICRASCAS3  ----------------------------- */
#define EMC_DYNAMICRASCAS3_RAS_Pos            0                                                       /*!< EMC DYNAMICRASCAS3: RAS Position        */
#define EMC_DYNAMICRASCAS3_RAS_Msk            (0x03UL << EMC_DYNAMICRASCAS3_RAS_Pos)                  /*!< EMC DYNAMICRASCAS3: RAS Mask            */
#define EMC_DYNAMICRASCAS3_CAS_Pos            8                                                       /*!< EMC DYNAMICRASCAS3: CAS Position        */
#define EMC_DYNAMICRASCAS3_CAS_Msk            (0x03UL << EMC_DYNAMICRASCAS3_CAS_Pos)                  /*!< EMC DYNAMICRASCAS3: CAS Mask            */

/* ------------------------------  EMC_STATICCONFIG0  ----------------------------- */
#define EMC_STATICCONFIG0_MW_Pos              0                                                       /*!< EMC STATICCONFIG0: MW Position          */
#define EMC_STATICCONFIG0_MW_Msk              (0x03UL << EMC_STATICCONFIG0_MW_Pos)                    /*!< EMC STATICCONFIG0: MW Mask              */
#define EMC_STATICCONFIG0_PM_Pos              3                                                       /*!< EMC STATICCONFIG0: PM Position          */
#define EMC_STATICCONFIG0_PM_Msk              (0x01UL << EMC_STATICCONFIG0_PM_Pos)                    /*!< EMC STATICCONFIG0: PM Mask              */
#define EMC_STATICCONFIG0_PC_Pos              6                                                       /*!< EMC STATICCONFIG0: PC Position          */
#define EMC_STATICCONFIG0_PC_Msk              (0x01UL << EMC_STATICCONFIG0_PC_Pos)                    /*!< EMC STATICCONFIG0: PC Mask              */
#define EMC_STATICCONFIG0_PB_Pos              7                                                       /*!< EMC STATICCONFIG0: PB Position          */
#define EMC_STATICCONFIG0_PB_Msk              (0x01UL << EMC_STATICCONFIG0_PB_Pos)                    /*!< EMC STATICCONFIG0: PB Mask              */
#define EMC_STATICCONFIG0_EW_Pos              8                                                       /*!< EMC STATICCONFIG0: EW Position          */
#define EMC_STATICCONFIG0_EW_Msk              (0x01UL << EMC_STATICCONFIG0_EW_Pos)                    /*!< EMC STATICCONFIG0: EW Mask              */
#define EMC_STATICCONFIG0_B_Pos               19                                                      /*!< EMC STATICCONFIG0: B Position           */
#define EMC_STATICCONFIG0_B_Msk               (0x01UL << EMC_STATICCONFIG0_B_Pos)                     /*!< EMC STATICCONFIG0: B Mask               */
#define EMC_STATICCONFIG0_P_Pos               20                                                      /*!< EMC STATICCONFIG0: P Position           */
#define EMC_STATICCONFIG0_P_Msk               (0x01UL << EMC_STATICCONFIG0_P_Pos)                     /*!< EMC STATICCONFIG0: P Mask               */

/* -----------------------------  EMC_STATICWAITWEN0  ----------------------------- */
#define EMC_STATICWAITWEN0_WAITWEN_Pos        0                                                       /*!< EMC STATICWAITWEN0: WAITWEN Position    */
#define EMC_STATICWAITWEN0_WAITWEN_Msk        (0x0fUL << EMC_STATICWAITWEN0_WAITWEN_Pos)              /*!< EMC STATICWAITWEN0: WAITWEN Mask        */

/* -----------------------------  EMC_STATICWAITOEN0  ----------------------------- */
#define EMC_STATICWAITOEN0_WAITOEN_Pos        0                                                       /*!< EMC STATICWAITOEN0: WAITOEN Position    */
#define EMC_STATICWAITOEN0_WAITOEN_Msk        (0x0fUL << EMC_STATICWAITOEN0_WAITOEN_Pos)              /*!< EMC STATICWAITOEN0: WAITOEN Mask        */

/* ------------------------------  EMC_STATICWAITRD0  ----------------------------- */
#define EMC_STATICWAITRD0_WAITRD_Pos          0                                                       /*!< EMC STATICWAITRD0: WAITRD Position      */
#define EMC_STATICWAITRD0_WAITRD_Msk          (0x1fUL << EMC_STATICWAITRD0_WAITRD_Pos)                /*!< EMC STATICWAITRD0: WAITRD Mask          */

/* -----------------------------  EMC_STATICWAITPAGE0  ---------------------------- */
#define EMC_STATICWAITPAGE0_WAITPAGE_Pos      0                                                       /*!< EMC STATICWAITPAGE0: WAITPAGE Position  */
#define EMC_STATICWAITPAGE0_WAITPAGE_Msk      (0x1fUL << EMC_STATICWAITPAGE0_WAITPAGE_Pos)            /*!< EMC STATICWAITPAGE0: WAITPAGE Mask      */

/* ------------------------------  EMC_STATICWAITWR0  ----------------------------- */
#define EMC_STATICWAITWR0_WAITWR_Pos          0                                                       /*!< EMC STATICWAITWR0: WAITWR Position      */
#define EMC_STATICWAITWR0_WAITWR_Msk          (0x1fUL << EMC_STATICWAITWR0_WAITWR_Pos)                /*!< EMC STATICWAITWR0: WAITWR Mask          */

/* -----------------------------  EMC_STATICWAITTURN0  ---------------------------- */
#define EMC_STATICWAITTURN0_WAITTURN_Pos      0                                                       /*!< EMC STATICWAITTURN0: WAITTURN Position  */
#define EMC_STATICWAITTURN0_WAITTURN_Msk      (0x0fUL << EMC_STATICWAITTURN0_WAITTURN_Pos)            /*!< EMC STATICWAITTURN0: WAITTURN Mask      */

/* ------------------------------  EMC_STATICCONFIG1  ----------------------------- */
#define EMC_STATICCONFIG1_MW_Pos              0                                                       /*!< EMC STATICCONFIG1: MW Position          */
#define EMC_STATICCONFIG1_MW_Msk              (0x03UL << EMC_STATICCONFIG1_MW_Pos)                    /*!< EMC STATICCONFIG1: MW Mask              */
#define EMC_STATICCONFIG1_PM_Pos              3                                                       /*!< EMC STATICCONFIG1: PM Position          */
#define EMC_STATICCONFIG1_PM_Msk              (0x01UL << EMC_STATICCONFIG1_PM_Pos)                    /*!< EMC STATICCONFIG1: PM Mask              */
#define EMC_STATICCONFIG1_PC_Pos              6                                                       /*!< EMC STATICCONFIG1: PC Position          */
#define EMC_STATICCONFIG1_PC_Msk              (0x01UL << EMC_STATICCONFIG1_PC_Pos)                    /*!< EMC STATICCONFIG1: PC Mask              */
#define EMC_STATICCONFIG1_PB_Pos              7                                                       /*!< EMC STATICCONFIG1: PB Position          */
#define EMC_STATICCONFIG1_PB_Msk              (0x01UL << EMC_STATICCONFIG1_PB_Pos)                    /*!< EMC STATICCONFIG1: PB Mask              */
#define EMC_STATICCONFIG1_EW_Pos              8                                                       /*!< EMC STATICCONFIG1: EW Position          */
#define EMC_STATICCONFIG1_EW_Msk              (0x01UL << EMC_STATICCONFIG1_EW_Pos)                    /*!< EMC STATICCONFIG1: EW Mask              */
#define EMC_STATICCONFIG1_B_Pos               19                                                      /*!< EMC STATICCONFIG1: B Position           */
#define EMC_STATICCONFIG1_B_Msk               (0x01UL << EMC_STATICCONFIG1_B_Pos)                     /*!< EMC STATICCONFIG1: B Mask               */
#define EMC_STATICCONFIG1_P_Pos               20                                                      /*!< EMC STATICCONFIG1: P Position           */
#define EMC_STATICCONFIG1_P_Msk               (0x01UL << EMC_STATICCONFIG1_P_Pos)                     /*!< EMC STATICCONFIG1: P Mask               */

/* -----------------------------  EMC_STATICWAITWEN1  ----------------------------- */
#define EMC_STATICWAITWEN1_WAITWEN_Pos        0                                                       /*!< EMC STATICWAITWEN1: WAITWEN Position    */
#define EMC_STATICWAITWEN1_WAITWEN_Msk        (0x0fUL << EMC_STATICWAITWEN1_WAITWEN_Pos)              /*!< EMC STATICWAITWEN1: WAITWEN Mask        */

/* -----------------------------  EMC_STATICWAITOEN1  ----------------------------- */
#define EMC_STATICWAITOEN1_WAITOEN_Pos        0                                                       /*!< EMC STATICWAITOEN1: WAITOEN Position    */
#define EMC_STATICWAITOEN1_WAITOEN_Msk        (0x0fUL << EMC_STATICWAITOEN1_WAITOEN_Pos)              /*!< EMC STATICWAITOEN1: WAITOEN Mask        */

/* ------------------------------  EMC_STATICWAITRD1  ----------------------------- */
#define EMC_STATICWAITRD1_WAITRD_Pos          0                                                       /*!< EMC STATICWAITRD1: WAITRD Position      */
#define EMC_STATICWAITRD1_WAITRD_Msk          (0x1fUL << EMC_STATICWAITRD1_WAITRD_Pos)                /*!< EMC STATICWAITRD1: WAITRD Mask          */

/* -----------------------------  EMC_STATICWAITPAGE1  ---------------------------- */
#define EMC_STATICWAITPAGE1_WAITPAGE_Pos      0                                                       /*!< EMC STATICWAITPAGE1: WAITPAGE Position  */
#define EMC_STATICWAITPAGE1_WAITPAGE_Msk      (0x1fUL << EMC_STATICWAITPAGE1_WAITPAGE_Pos)            /*!< EMC STATICWAITPAGE1: WAITPAGE Mask      */

/* ------------------------------  EMC_STATICWAITWR1  ----------------------------- */
#define EMC_STATICWAITWR1_WAITWR_Pos          0                                                       /*!< EMC STATICWAITWR1: WAITWR Position      */
#define EMC_STATICWAITWR1_WAITWR_Msk          (0x1fUL << EMC_STATICWAITWR1_WAITWR_Pos)                /*!< EMC STATICWAITWR1: WAITWR Mask          */

/* -----------------------------  EMC_STATICWAITTURN1  ---------------------------- */
#define EMC_STATICWAITTURN1_WAITTURN_Pos      0                                                       /*!< EMC STATICWAITTURN1: WAITTURN Position  */
#define EMC_STATICWAITTURN1_WAITTURN_Msk      (0x0fUL << EMC_STATICWAITTURN1_WAITTURN_Pos)            /*!< EMC STATICWAITTURN1: WAITTURN Mask      */

/* ------------------------------  EMC_STATICCONFIG2  ----------------------------- */
#define EMC_STATICCONFIG2_MW_Pos              0                                                       /*!< EMC STATICCONFIG2: MW Position          */
#define EMC_STATICCONFIG2_MW_Msk              (0x03UL << EMC_STATICCONFIG2_MW_Pos)                    /*!< EMC STATICCONFIG2: MW Mask              */
#define EMC_STATICCONFIG2_PM_Pos              3                                                       /*!< EMC STATICCONFIG2: PM Position          */
#define EMC_STATICCONFIG2_PM_Msk              (0x01UL << EMC_STATICCONFIG2_PM_Pos)                    /*!< EMC STATICCONFIG2: PM Mask              */
#define EMC_STATICCONFIG2_PC_Pos              6                                                       /*!< EMC STATICCONFIG2: PC Position          */
#define EMC_STATICCONFIG2_PC_Msk              (0x01UL << EMC_STATICCONFIG2_PC_Pos)                    /*!< EMC STATICCONFIG2: PC Mask              */
#define EMC_STATICCONFIG2_PB_Pos              7                                                       /*!< EMC STATICCONFIG2: PB Position          */
#define EMC_STATICCONFIG2_PB_Msk              (0x01UL << EMC_STATICCONFIG2_PB_Pos)                    /*!< EMC STATICCONFIG2: PB Mask              */
#define EMC_STATICCONFIG2_EW_Pos              8                                                       /*!< EMC STATICCONFIG2: EW Position          */
#define EMC_STATICCONFIG2_EW_Msk              (0x01UL << EMC_STATICCONFIG2_EW_Pos)                    /*!< EMC STATICCONFIG2: EW Mask              */
#define EMC_STATICCONFIG2_B_Pos               19                                                      /*!< EMC STATICCONFIG2: B Position           */
#define EMC_STATICCONFIG2_B_Msk               (0x01UL << EMC_STATICCONFIG2_B_Pos)                     /*!< EMC STATICCONFIG2: B Mask               */
#define EMC_STATICCONFIG2_P_Pos               20                                                      /*!< EMC STATICCONFIG2: P Position           */
#define EMC_STATICCONFIG2_P_Msk               (0x01UL << EMC_STATICCONFIG2_P_Pos)                     /*!< EMC STATICCONFIG2: P Mask               */

/* -----------------------------  EMC_STATICWAITWEN2  ----------------------------- */
#define EMC_STATICWAITWEN2_WAITWEN_Pos        0                                                       /*!< EMC STATICWAITWEN2: WAITWEN Position    */
#define EMC_STATICWAITWEN2_WAITWEN_Msk        (0x0fUL << EMC_STATICWAITWEN2_WAITWEN_Pos)              /*!< EMC STATICWAITWEN2: WAITWEN Mask        */

/* -----------------------------  EMC_STATICWAITOEN2  ----------------------------- */
#define EMC_STATICWAITOEN2_WAITOEN_Pos        0                                                       /*!< EMC STATICWAITOEN2: WAITOEN Position    */
#define EMC_STATICWAITOEN2_WAITOEN_Msk        (0x0fUL << EMC_STATICWAITOEN2_WAITOEN_Pos)              /*!< EMC STATICWAITOEN2: WAITOEN Mask        */

/* ------------------------------  EMC_STATICWAITRD2  ----------------------------- */
#define EMC_STATICWAITRD2_WAITRD_Pos          0                                                       /*!< EMC STATICWAITRD2: WAITRD Position      */
#define EMC_STATICWAITRD2_WAITRD_Msk          (0x1fUL << EMC_STATICWAITRD2_WAITRD_Pos)                /*!< EMC STATICWAITRD2: WAITRD Mask          */

/* -----------------------------  EMC_STATICWAITPAGE2  ---------------------------- */
#define EMC_STATICWAITPAGE2_WAITPAGE_Pos      0                                                       /*!< EMC STATICWAITPAGE2: WAITPAGE Position  */
#define EMC_STATICWAITPAGE2_WAITPAGE_Msk      (0x1fUL << EMC_STATICWAITPAGE2_WAITPAGE_Pos)            /*!< EMC STATICWAITPAGE2: WAITPAGE Mask      */

/* ------------------------------  EMC_STATICWAITWR2  ----------------------------- */
#define EMC_STATICWAITWR2_WAITWR_Pos          0                                                       /*!< EMC STATICWAITWR2: WAITWR Position      */
#define EMC_STATICWAITWR2_WAITWR_Msk          (0x1fUL << EMC_STATICWAITWR2_WAITWR_Pos)                /*!< EMC STATICWAITWR2: WAITWR Mask          */

/* -----------------------------  EMC_STATICWAITTURN2  ---------------------------- */
#define EMC_STATICWAITTURN2_WAITTURN_Pos      0                                                       /*!< EMC STATICWAITTURN2: WAITTURN Position  */
#define EMC_STATICWAITTURN2_WAITTURN_Msk      (0x0fUL << EMC_STATICWAITTURN2_WAITTURN_Pos)            /*!< EMC STATICWAITTURN2: WAITTURN Mask      */

/* ------------------------------  EMC_STATICCONFIG3  ----------------------------- */
#define EMC_STATICCONFIG3_MW_Pos              0                                                       /*!< EMC STATICCONFIG3: MW Position          */
#define EMC_STATICCONFIG3_MW_Msk              (0x03UL << EMC_STATICCONFIG3_MW_Pos)                    /*!< EMC STATICCONFIG3: MW Mask              */
#define EMC_STATICCONFIG3_PM_Pos              3                                                       /*!< EMC STATICCONFIG3: PM Position          */
#define EMC_STATICCONFIG3_PM_Msk              (0x01UL << EMC_STATICCONFIG3_PM_Pos)                    /*!< EMC STATICCONFIG3: PM Mask              */
#define EMC_STATICCONFIG3_PC_Pos              6                                                       /*!< EMC STATICCONFIG3: PC Position          */
#define EMC_STATICCONFIG3_PC_Msk              (0x01UL << EMC_STATICCONFIG3_PC_Pos)                    /*!< EMC STATICCONFIG3: PC Mask              */
#define EMC_STATICCONFIG3_PB_Pos              7                                                       /*!< EMC STATICCONFIG3: PB Position          */
#define EMC_STATICCONFIG3_PB_Msk              (0x01UL << EMC_STATICCONFIG3_PB_Pos)                    /*!< EMC STATICCONFIG3: PB Mask              */
#define EMC_STATICCONFIG3_EW_Pos              8                                                       /*!< EMC STATICCONFIG3: EW Position          */
#define EMC_STATICCONFIG3_EW_Msk              (0x01UL << EMC_STATICCONFIG3_EW_Pos)                    /*!< EMC STATICCONFIG3: EW Mask              */
#define EMC_STATICCONFIG3_B_Pos               19                                                      /*!< EMC STATICCONFIG3: B Position           */
#define EMC_STATICCONFIG3_B_Msk               (0x01UL << EMC_STATICCONFIG3_B_Pos)                     /*!< EMC STATICCONFIG3: B Mask               */
#define EMC_STATICCONFIG3_P_Pos               20                                                      /*!< EMC STATICCONFIG3: P Position           */
#define EMC_STATICCONFIG3_P_Msk               (0x01UL << EMC_STATICCONFIG3_P_Pos)                     /*!< EMC STATICCONFIG3: P Mask               */

/* -----------------------------  EMC_STATICWAITWEN3  ----------------------------- */
#define EMC_STATICWAITWEN3_WAITWEN_Pos        0                                                       /*!< EMC STATICWAITWEN3: WAITWEN Position    */
#define EMC_STATICWAITWEN3_WAITWEN_Msk        (0x0fUL << EMC_STATICWAITWEN3_WAITWEN_Pos)              /*!< EMC STATICWAITWEN3: WAITWEN Mask        */

/* -----------------------------  EMC_STATICWAITOEN3  ----------------------------- */
#define EMC_STATICWAITOEN3_WAITOEN_Pos        0                                                       /*!< EMC STATICWAITOEN3: WAITOEN Position    */
#define EMC_STATICWAITOEN3_WAITOEN_Msk        (0x0fUL << EMC_STATICWAITOEN3_WAITOEN_Pos)              /*!< EMC STATICWAITOEN3: WAITOEN Mask        */

/* ------------------------------  EMC_STATICWAITRD3  ----------------------------- */
#define EMC_STATICWAITRD3_WAITRD_Pos          0                                                       /*!< EMC STATICWAITRD3: WAITRD Position      */
#define EMC_STATICWAITRD3_WAITRD_Msk          (0x1fUL << EMC_STATICWAITRD3_WAITRD_Pos)                /*!< EMC STATICWAITRD3: WAITRD Mask          */

/* -----------------------------  EMC_STATICWAITPAGE3  ---------------------------- */
#define EMC_STATICWAITPAGE3_WAITPAGE_Pos      0                                                       /*!< EMC STATICWAITPAGE3: WAITPAGE Position  */
#define EMC_STATICWAITPAGE3_WAITPAGE_Msk      (0x1fUL << EMC_STATICWAITPAGE3_WAITPAGE_Pos)            /*!< EMC STATICWAITPAGE3: WAITPAGE Mask      */

/* ------------------------------  EMC_STATICWAITWR3  ----------------------------- */
#define EMC_STATICWAITWR3_WAITWR_Pos          0                                                       /*!< EMC STATICWAITWR3: WAITWR Position      */
#define EMC_STATICWAITWR3_WAITWR_Msk          (0x1fUL << EMC_STATICWAITWR3_WAITWR_Pos)                /*!< EMC STATICWAITWR3: WAITWR Mask          */

/* -----------------------------  EMC_STATICWAITTURN3  ---------------------------- */
#define EMC_STATICWAITTURN3_WAITTURN_Pos      0                                                       /*!< EMC STATICWAITTURN3: WAITTURN Position  */
#define EMC_STATICWAITTURN3_WAITTURN_Msk      (0x0fUL << EMC_STATICWAITTURN3_WAITTURN_Pos)            /*!< EMC STATICWAITTURN3: WAITTURN Mask      */


/* ================================================================================ */
/* ================          struct 'USB0' Position & Mask         ================ */
/* ================================================================================ */


/* -------------------------------  USB0_CAPLENGTH  ------------------------------- */
#define USB0_CAPLENGTH_CAPLENGTH_Pos          0                                                       /*!< USB0 CAPLENGTH: CAPLENGTH Position      */
#define USB0_CAPLENGTH_CAPLENGTH_Msk          (0x000000ffUL << USB0_CAPLENGTH_CAPLENGTH_Pos)          /*!< USB0 CAPLENGTH: CAPLENGTH Mask          */
#define USB0_CAPLENGTH_HCIVERSION_Pos         8                                                       /*!< USB0 CAPLENGTH: HCIVERSION Position     */
#define USB0_CAPLENGTH_HCIVERSION_Msk         (0x0000ffffUL << USB0_CAPLENGTH_HCIVERSION_Pos)         /*!< USB0 CAPLENGTH: HCIVERSION Mask         */

/* -------------------------------  USB0_HCSPARAMS  ------------------------------- */
#define USB0_HCSPARAMS_N_PORTS_Pos            0                                                       /*!< USB0 HCSPARAMS: N_PORTS Position        */
#define USB0_HCSPARAMS_N_PORTS_Msk            (0x0fUL << USB0_HCSPARAMS_N_PORTS_Pos)                  /*!< USB0 HCSPARAMS: N_PORTS Mask            */
#define USB0_HCSPARAMS_PPC_Pos                4                                                       /*!< USB0 HCSPARAMS: PPC Position            */
#define USB0_HCSPARAMS_PPC_Msk                (0x01UL << USB0_HCSPARAMS_PPC_Pos)                      /*!< USB0 HCSPARAMS: PPC Mask                */
#define USB0_HCSPARAMS_N_PCC_Pos              8                                                       /*!< USB0 HCSPARAMS: N_PCC Position          */
#define USB0_HCSPARAMS_N_PCC_Msk              (0x0fUL << USB0_HCSPARAMS_N_PCC_Pos)                    /*!< USB0 HCSPARAMS: N_PCC Mask              */
#define USB0_HCSPARAMS_N_CC_Pos               12                                                      /*!< USB0 HCSPARAMS: N_CC Position           */
#define USB0_HCSPARAMS_N_CC_Msk               (0x0fUL << USB0_HCSPARAMS_N_CC_Pos)                     /*!< USB0 HCSPARAMS: N_CC Mask               */
#define USB0_HCSPARAMS_PI_Pos                 16                                                      /*!< USB0 HCSPARAMS: PI Position             */
#define USB0_HCSPARAMS_PI_Msk                 (0x01UL << USB0_HCSPARAMS_PI_Pos)                       /*!< USB0 HCSPARAMS: PI Mask                 */
#define USB0_HCSPARAMS_N_PTT_Pos              20                                                      /*!< USB0 HCSPARAMS: N_PTT Position          */
#define USB0_HCSPARAMS_N_PTT_Msk              (0x0fUL << USB0_HCSPARAMS_N_PTT_Pos)                    /*!< USB0 HCSPARAMS: N_PTT Mask              */
#define USB0_HCSPARAMS_N_TT_Pos               24                                                      /*!< USB0 HCSPARAMS: N_TT Position           */
#define USB0_HCSPARAMS_N_TT_Msk               (0x0fUL << USB0_HCSPARAMS_N_TT_Pos)                     /*!< USB0 HCSPARAMS: N_TT Mask               */

/* -------------------------------  USB0_HCCPARAMS  ------------------------------- */
#define USB0_HCCPARAMS_ADC_Pos                0                                                       /*!< USB0 HCCPARAMS: ADC Position            */
#define USB0_HCCPARAMS_ADC_Msk                (0x01UL << USB0_HCCPARAMS_ADC_Pos)                      /*!< USB0 HCCPARAMS: ADC Mask                */
#define USB0_HCCPARAMS_PFL_Pos                1                                                       /*!< USB0 HCCPARAMS: PFL Position            */
#define USB0_HCCPARAMS_PFL_Msk                (0x01UL << USB0_HCCPARAMS_PFL_Pos)                      /*!< USB0 HCCPARAMS: PFL Mask                */
#define USB0_HCCPARAMS_ASP_Pos                2                                                       /*!< USB0 HCCPARAMS: ASP Position            */
#define USB0_HCCPARAMS_ASP_Msk                (0x01UL << USB0_HCCPARAMS_ASP_Pos)                      /*!< USB0 HCCPARAMS: ASP Mask                */
#define USB0_HCCPARAMS_IST_Pos                4                                                       /*!< USB0 HCCPARAMS: IST Position            */
#define USB0_HCCPARAMS_IST_Msk                (0x0fUL << USB0_HCCPARAMS_IST_Pos)                      /*!< USB0 HCCPARAMS: IST Mask                */
#define USB0_HCCPARAMS_EECP_Pos               8                                                       /*!< USB0 HCCPARAMS: EECP Position           */
#define USB0_HCCPARAMS_EECP_Msk               (0x000000ffUL << USB0_HCCPARAMS_EECP_Pos)               /*!< USB0 HCCPARAMS: EECP Mask               */

/* -------------------------------  USB0_DCIVERSION  ------------------------------ */
#define USB0_DCIVERSION_DCIVERSION_Pos        0                                                       /*!< USB0 DCIVERSION: DCIVERSION Position    */
#define USB0_DCIVERSION_DCIVERSION_Msk        (0x0000ffffUL << USB0_DCIVERSION_DCIVERSION_Pos)        /*!< USB0 DCIVERSION: DCIVERSION Mask        */

/* --------------------------------  USB0_USBCMD_D  ------------------------------- */
#define USB0_USBCMD_D_RS_Pos                  0                                                       /*!< USB0 USBCMD_D: RS Position              */
#define USB0_USBCMD_D_RS_Msk                  (0x01UL << USB0_USBCMD_D_RS_Pos)                        /*!< USB0 USBCMD_D: RS Mask                  */
#define USB0_USBCMD_D_RST_Pos                 1                                                       /*!< USB0 USBCMD_D: RST Position             */
#define USB0_USBCMD_D_RST_Msk                 (0x01UL << USB0_USBCMD_D_RST_Pos)                       /*!< USB0 USBCMD_D: RST Mask                 */
#define USB0_USBCMD_D_SUTW_Pos                13                                                      /*!< USB0 USBCMD_D: SUTW Position            */
#define USB0_USBCMD_D_SUTW_Msk                (0x01UL << USB0_USBCMD_D_SUTW_Pos)                      /*!< USB0 USBCMD_D: SUTW Mask                */
#define USB0_USBCMD_D_ATDTW_Pos               14                                                      /*!< USB0 USBCMD_D: ATDTW Position           */
#define USB0_USBCMD_D_ATDTW_Msk               (0x01UL << USB0_USBCMD_D_ATDTW_Pos)                     /*!< USB0 USBCMD_D: ATDTW Mask               */
#define USB0_USBCMD_D_ITC_Pos                 16                                                      /*!< USB0 USBCMD_D: ITC Position             */
#define USB0_USBCMD_D_ITC_Msk                 (0x000000ffUL << USB0_USBCMD_D_ITC_Pos)                 /*!< USB0 USBCMD_D: ITC Mask                 */

/* --------------------------------  USB0_USBCMD_H  ------------------------------- */
#define USB0_USBCMD_H_RS_Pos                  0                                                       /*!< USB0 USBCMD_H: RS Position              */
#define USB0_USBCMD_H_RS_Msk                  (0x01UL << USB0_USBCMD_H_RS_Pos)                        /*!< USB0 USBCMD_H: RS Mask                  */
#define USB0_USBCMD_H_RST_Pos                 1                                                       /*!< USB0 USBCMD_H: RST Position             */
#define USB0_USBCMD_H_RST_Msk                 (0x01UL << USB0_USBCMD_H_RST_Pos)                       /*!< USB0 USBCMD_H: RST Mask                 */
#define USB0_USBCMD_H_FS0_Pos                 2                                                       /*!< USB0 USBCMD_H: FS0 Position             */
#define USB0_USBCMD_H_FS0_Msk                 (0x01UL << USB0_USBCMD_H_FS0_Pos)                       /*!< USB0 USBCMD_H: FS0 Mask                 */
#define USB0_USBCMD_H_FS1_Pos                 3                                                       /*!< USB0 USBCMD_H: FS1 Position             */
#define USB0_USBCMD_H_FS1_Msk                 (0x01UL << USB0_USBCMD_H_FS1_Pos)                       /*!< USB0 USBCMD_H: FS1 Mask                 */
#define USB0_USBCMD_H_PSE_Pos                 4                                                       /*!< USB0 USBCMD_H: PSE Position             */
#define USB0_USBCMD_H_PSE_Msk                 (0x01UL << USB0_USBCMD_H_PSE_Pos)                       /*!< USB0 USBCMD_H: PSE Mask                 */
#define USB0_USBCMD_H_ASE_Pos                 5                                                       /*!< USB0 USBCMD_H: ASE Position             */
#define USB0_USBCMD_H_ASE_Msk                 (0x01UL << USB0_USBCMD_H_ASE_Pos)                       /*!< USB0 USBCMD_H: ASE Mask                 */
#define USB0_USBCMD_H_IAA_Pos                 6                                                       /*!< USB0 USBCMD_H: IAA Position             */
#define USB0_USBCMD_H_IAA_Msk                 (0x01UL << USB0_USBCMD_H_IAA_Pos)                       /*!< USB0 USBCMD_H: IAA Mask                 */
#define USB0_USBCMD_H_ASP1_0_Pos              8                                                       /*!< USB0 USBCMD_H: ASP1_0 Position          */
#define USB0_USBCMD_H_ASP1_0_Msk              (0x03UL << USB0_USBCMD_H_ASP1_0_Pos)                    /*!< USB0 USBCMD_H: ASP1_0 Mask              */
#define USB0_USBCMD_H_ASPE_Pos                11                                                      /*!< USB0 USBCMD_H: ASPE Position            */
#define USB0_USBCMD_H_ASPE_Msk                (0x01UL << USB0_USBCMD_H_ASPE_Pos)                      /*!< USB0 USBCMD_H: ASPE Mask                */
#define USB0_USBCMD_H_FS2_Pos                 15                                                      /*!< USB0 USBCMD_H: FS2 Position             */
#define USB0_USBCMD_H_FS2_Msk                 (0x01UL << USB0_USBCMD_H_FS2_Pos)                       /*!< USB0 USBCMD_H: FS2 Mask                 */
#define USB0_USBCMD_H_ITC_Pos                 16                                                      /*!< USB0 USBCMD_H: ITC Position             */
#define USB0_USBCMD_H_ITC_Msk                 (0x000000ffUL << USB0_USBCMD_H_ITC_Pos)                 /*!< USB0 USBCMD_H: ITC Mask                 */

/* --------------------------------  USB0_USBSTS_D  ------------------------------- */
#define USB0_USBSTS_D_UI_Pos                  0                                                       /*!< USB0 USBSTS_D: UI Position              */
#define USB0_USBSTS_D_UI_Msk                  (0x01UL << USB0_USBSTS_D_UI_Pos)                        /*!< USB0 USBSTS_D: UI Mask                  */
#define USB0_USBSTS_D_UEI_Pos                 1                                                       /*!< USB0 USBSTS_D: UEI Position             */
#define USB0_USBSTS_D_UEI_Msk                 (0x01UL << USB0_USBSTS_D_UEI_Pos)                       /*!< USB0 USBSTS_D: UEI Mask                 */
#define USB0_USBSTS_D_PCI_Pos                 2                                                       /*!< USB0 USBSTS_D: PCI Position             */
#define USB0_USBSTS_D_PCI_Msk                 (0x01UL << USB0_USBSTS_D_PCI_Pos)                       /*!< USB0 USBSTS_D: PCI Mask                 */
#define USB0_USBSTS_D_AAI_Pos                 5                                                       /*!< USB0 USBSTS_D: AAI Position             */
#define USB0_USBSTS_D_AAI_Msk                 (0x01UL << USB0_USBSTS_D_AAI_Pos)                       /*!< USB0 USBSTS_D: AAI Mask                 */
#define USB0_USBSTS_D_URI_Pos                 6                                                       /*!< USB0 USBSTS_D: URI Position             */
#define USB0_USBSTS_D_URI_Msk                 (0x01UL << USB0_USBSTS_D_URI_Pos)                       /*!< USB0 USBSTS_D: URI Mask                 */
#define USB0_USBSTS_D_SRI_Pos                 7                                                       /*!< USB0 USBSTS_D: SRI Position             */
#define USB0_USBSTS_D_SRI_Msk                 (0x01UL << USB0_USBSTS_D_SRI_Pos)                       /*!< USB0 USBSTS_D: SRI Mask                 */
#define USB0_USBSTS_D_SLI_Pos                 8                                                       /*!< USB0 USBSTS_D: SLI Position             */
#define USB0_USBSTS_D_SLI_Msk                 (0x01UL << USB0_USBSTS_D_SLI_Pos)                       /*!< USB0 USBSTS_D: SLI Mask                 */
#define USB0_USBSTS_D_NAKI_Pos                16                                                      /*!< USB0 USBSTS_D: NAKI Position            */
#define USB0_USBSTS_D_NAKI_Msk                (0x01UL << USB0_USBSTS_D_NAKI_Pos)                      /*!< USB0 USBSTS_D: NAKI Mask                */

/* --------------------------------  USB0_USBSTS_H  ------------------------------- */
#define USB0_USBSTS_H_UI_Pos                  0                                                       /*!< USB0 USBSTS_H: UI Position              */
#define USB0_USBSTS_H_UI_Msk                  (0x01UL << USB0_USBSTS_H_UI_Pos)                        /*!< USB0 USBSTS_H: UI Mask                  */
#define USB0_USBSTS_H_UEI_Pos                 1                                                       /*!< USB0 USBSTS_H: UEI Position             */
#define USB0_USBSTS_H_UEI_Msk                 (0x01UL << USB0_USBSTS_H_UEI_Pos)                       /*!< USB0 USBSTS_H: UEI Mask                 */
#define USB0_USBSTS_H_PCI_Pos                 2                                                       /*!< USB0 USBSTS_H: PCI Position             */
#define USB0_USBSTS_H_PCI_Msk                 (0x01UL << USB0_USBSTS_H_PCI_Pos)                       /*!< USB0 USBSTS_H: PCI Mask                 */
#define USB0_USBSTS_H_FRI_Pos                 3                                                       /*!< USB0 USBSTS_H: FRI Position             */
#define USB0_USBSTS_H_FRI_Msk                 (0x01UL << USB0_USBSTS_H_FRI_Pos)                       /*!< USB0 USBSTS_H: FRI Mask                 */
#define USB0_USBSTS_H_AAI_Pos                 5                                                       /*!< USB0 USBSTS_H: AAI Position             */
#define USB0_USBSTS_H_AAI_Msk                 (0x01UL << USB0_USBSTS_H_AAI_Pos)                       /*!< USB0 USBSTS_H: AAI Mask                 */
#define USB0_USBSTS_H_SRI_Pos                 7                                                       /*!< USB0 USBSTS_H: SRI Position             */
#define USB0_USBSTS_H_SRI_Msk                 (0x01UL << USB0_USBSTS_H_SRI_Pos)                       /*!< USB0 USBSTS_H: SRI Mask                 */
#define USB0_USBSTS_H_HCH_Pos                 12                                                      /*!< USB0 USBSTS_H: HCH Position             */
#define USB0_USBSTS_H_HCH_Msk                 (0x01UL << USB0_USBSTS_H_HCH_Pos)                       /*!< USB0 USBSTS_H: HCH Mask                 */
#define USB0_USBSTS_H_RCL_Pos                 13                                                      /*!< USB0 USBSTS_H: RCL Position             */
#define USB0_USBSTS_H_RCL_Msk                 (0x01UL << USB0_USBSTS_H_RCL_Pos)                       /*!< USB0 USBSTS_H: RCL Mask                 */
#define USB0_USBSTS_H_PS_Pos                  14                                                      /*!< USB0 USBSTS_H: PS Position              */
#define USB0_USBSTS_H_PS_Msk                  (0x01UL << USB0_USBSTS_H_PS_Pos)                        /*!< USB0 USBSTS_H: PS Mask                  */
#define USB0_USBSTS_H_AS_Pos                  15                                                      /*!< USB0 USBSTS_H: AS Position              */
#define USB0_USBSTS_H_AS_Msk                  (0x01UL << USB0_USBSTS_H_AS_Pos)                        /*!< USB0 USBSTS_H: AS Mask                  */
#define USB0_USBSTS_H_UAI_Pos                 18                                                      /*!< USB0 USBSTS_H: UAI Position             */
#define USB0_USBSTS_H_UAI_Msk                 (0x01UL << USB0_USBSTS_H_UAI_Pos)                       /*!< USB0 USBSTS_H: UAI Mask                 */
#define USB0_USBSTS_H_UPI_Pos                 19                                                      /*!< USB0 USBSTS_H: UPI Position             */
#define USB0_USBSTS_H_UPI_Msk                 (0x01UL << USB0_USBSTS_H_UPI_Pos)                       /*!< USB0 USBSTS_H: UPI Mask                 */

/* -------------------------------  USB0_USBINTR_D  ------------------------------- */
#define USB0_USBINTR_D_UE_Pos                 0                                                       /*!< USB0 USBINTR_D: UE Position             */
#define USB0_USBINTR_D_UE_Msk                 (0x01UL << USB0_USBINTR_D_UE_Pos)                       /*!< USB0 USBINTR_D: UE Mask                 */
#define USB0_USBINTR_D_UEE_Pos                1                                                       /*!< USB0 USBINTR_D: UEE Position            */
#define USB0_USBINTR_D_UEE_Msk                (0x01UL << USB0_USBINTR_D_UEE_Pos)                      /*!< USB0 USBINTR_D: UEE Mask                */
#define USB0_USBINTR_D_PCE_Pos                2                                                       /*!< USB0 USBINTR_D: PCE Position            */
#define USB0_USBINTR_D_PCE_Msk                (0x01UL << USB0_USBINTR_D_PCE_Pos)                      /*!< USB0 USBINTR_D: PCE Mask                */
#define USB0_USBINTR_D_URE_Pos                6                                                       /*!< USB0 USBINTR_D: URE Position            */
#define USB0_USBINTR_D_URE_Msk                (0x01UL << USB0_USBINTR_D_URE_Pos)                      /*!< USB0 USBINTR_D: URE Mask                */
#define USB0_USBINTR_D_SRE_Pos                7                                                       /*!< USB0 USBINTR_D: SRE Position            */
#define USB0_USBINTR_D_SRE_Msk                (0x01UL << USB0_USBINTR_D_SRE_Pos)                      /*!< USB0 USBINTR_D: SRE Mask                */
#define USB0_USBINTR_D_SLE_Pos                8                                                       /*!< USB0 USBINTR_D: SLE Position            */
#define USB0_USBINTR_D_SLE_Msk                (0x01UL << USB0_USBINTR_D_SLE_Pos)                      /*!< USB0 USBINTR_D: SLE Mask                */
#define USB0_USBINTR_D_NAKE_Pos               16                                                      /*!< USB0 USBINTR_D: NAKE Position           */
#define USB0_USBINTR_D_NAKE_Msk               (0x01UL << USB0_USBINTR_D_NAKE_Pos)                     /*!< USB0 USBINTR_D: NAKE Mask               */

/* -------------------------------  USB0_USBINTR_H  ------------------------------- */
#define USB0_USBINTR_H_UE_Pos                 0                                                       /*!< USB0 USBINTR_H: UE Position             */
#define USB0_USBINTR_H_UE_Msk                 (0x01UL << USB0_USBINTR_H_UE_Pos)                       /*!< USB0 USBINTR_H: UE Mask                 */
#define USB0_USBINTR_H_UEE_Pos                1                                                       /*!< USB0 USBINTR_H: UEE Position            */
#define USB0_USBINTR_H_UEE_Msk                (0x01UL << USB0_USBINTR_H_UEE_Pos)                      /*!< USB0 USBINTR_H: UEE Mask                */
#define USB0_USBINTR_H_PCE_Pos                2                                                       /*!< USB0 USBINTR_H: PCE Position            */
#define USB0_USBINTR_H_PCE_Msk                (0x01UL << USB0_USBINTR_H_PCE_Pos)                      /*!< USB0 USBINTR_H: PCE Mask                */
#define USB0_USBINTR_H_FRE_Pos                3                                                       /*!< USB0 USBINTR_H: FRE Position            */
#define USB0_USBINTR_H_FRE_Msk                (0x01UL << USB0_USBINTR_H_FRE_Pos)                      /*!< USB0 USBINTR_H: FRE Mask                */
#define USB0_USBINTR_H_AAE_Pos                5                                                       /*!< USB0 USBINTR_H: AAE Position            */
#define USB0_USBINTR_H_AAE_Msk                (0x01UL << USB0_USBINTR_H_AAE_Pos)                      /*!< USB0 USBINTR_H: AAE Mask                */
#define USB0_USBINTR_H_SRE_Pos                7                                                       /*!< USB0 USBINTR_H: SRE Position            */
#define USB0_USBINTR_H_SRE_Msk                (0x01UL << USB0_USBINTR_H_SRE_Pos)                      /*!< USB0 USBINTR_H: SRE Mask                */
#define USB0_USBINTR_H_UAIE_Pos               18                                                      /*!< USB0 USBINTR_H: UAIE Position           */
#define USB0_USBINTR_H_UAIE_Msk               (0x01UL << USB0_USBINTR_H_UAIE_Pos)                     /*!< USB0 USBINTR_H: UAIE Mask               */
#define USB0_USBINTR_H_UPIA_Pos               19                                                      /*!< USB0 USBINTR_H: UPIA Position           */
#define USB0_USBINTR_H_UPIA_Msk               (0x01UL << USB0_USBINTR_H_UPIA_Pos)                     /*!< USB0 USBINTR_H: UPIA Mask               */

/* -------------------------------  USB0_FRINDEX_D  ------------------------------- */
#define USB0_FRINDEX_D_FRINDEX2_0_Pos         0                                                       /*!< USB0 FRINDEX_D: FRINDEX2_0 Position     */
#define USB0_FRINDEX_D_FRINDEX2_0_Msk         (0x07UL << USB0_FRINDEX_D_FRINDEX2_0_Pos)               /*!< USB0 FRINDEX_D: FRINDEX2_0 Mask         */
#define USB0_FRINDEX_D_FRINDEX13_3_Pos        3                                                       /*!< USB0 FRINDEX_D: FRINDEX13_3 Position    */
#define USB0_FRINDEX_D_FRINDEX13_3_Msk        (0x000007ffUL << USB0_FRINDEX_D_FRINDEX13_3_Pos)        /*!< USB0 FRINDEX_D: FRINDEX13_3 Mask        */

/* -------------------------------  USB0_FRINDEX_H  ------------------------------- */
#define USB0_FRINDEX_H_FRINDEX2_0_Pos         0                                                       /*!< USB0 FRINDEX_H: FRINDEX2_0 Position     */
#define USB0_FRINDEX_H_FRINDEX2_0_Msk         (0x07UL << USB0_FRINDEX_H_FRINDEX2_0_Pos)               /*!< USB0 FRINDEX_H: FRINDEX2_0 Mask         */
#define USB0_FRINDEX_H_FRINDEX12_3_Pos        3                                                       /*!< USB0 FRINDEX_H: FRINDEX12_3 Position    */
#define USB0_FRINDEX_H_FRINDEX12_3_Msk        (0x000003ffUL << USB0_FRINDEX_H_FRINDEX12_3_Pos)        /*!< USB0 FRINDEX_H: FRINDEX12_3 Mask        */

/* -------------------------------  USB0_DEVICEADDR  ------------------------------ */
#define USB0_DEVICEADDR_USBADRA_Pos           24                                                      /*!< USB0 DEVICEADDR: USBADRA Position       */
#define USB0_DEVICEADDR_USBADRA_Msk           (0x01UL << USB0_DEVICEADDR_USBADRA_Pos)                 /*!< USB0 DEVICEADDR: USBADRA Mask           */
#define USB0_DEVICEADDR_USBADR_Pos            25                                                      /*!< USB0 DEVICEADDR: USBADR Position        */
#define USB0_DEVICEADDR_USBADR_Msk            (0x7fUL << USB0_DEVICEADDR_USBADR_Pos)                  /*!< USB0 DEVICEADDR: USBADR Mask            */

/* ----------------------------  USB0_PERIODICLISTBASE  --------------------------- */
#define USB0_PERIODICLISTBASE_PERBASE31_12_Pos 12                                                     /*!< USB0 PERIODICLISTBASE: PERBASE31_12 Position */
#define USB0_PERIODICLISTBASE_PERBASE31_12_Msk (0x000fffffUL << USB0_PERIODICLISTBASE_PERBASE31_12_Pos)/*!< USB0 PERIODICLISTBASE: PERBASE31_12 Mask */

/* ----------------------------  USB0_ENDPOINTLISTADDR  --------------------------- */
#define USB0_ENDPOINTLISTADDR_EPBASE31_11_Pos 11                                                      /*!< USB0 ENDPOINTLISTADDR: EPBASE31_11 Position */
#define USB0_ENDPOINTLISTADDR_EPBASE31_11_Msk (0x001fffffUL << USB0_ENDPOINTLISTADDR_EPBASE31_11_Pos) /*!< USB0 ENDPOINTLISTADDR: EPBASE31_11 Mask */

/* -----------------------------  USB0_ASYNCLISTADDR  ----------------------------- */
#define USB0_ASYNCLISTADDR_ASYBASE31_5_Pos    5                                                       /*!< USB0 ASYNCLISTADDR: ASYBASE31_5 Position */
#define USB0_ASYNCLISTADDR_ASYBASE31_5_Msk    (0x07ffffffUL << USB0_ASYNCLISTADDR_ASYBASE31_5_Pos)    /*!< USB0 ASYNCLISTADDR: ASYBASE31_5 Mask    */

/* ---------------------------------  USB0_TTCTRL  -------------------------------- */
#define USB0_TTCTRL_TTHA_Pos                  24                                                      /*!< USB0 TTCTRL: TTHA Position              */
#define USB0_TTCTRL_TTHA_Msk                  (0x7fUL << USB0_TTCTRL_TTHA_Pos)                        /*!< USB0 TTCTRL: TTHA Mask                  */

/* -------------------------------  USB0_BURSTSIZE  ------------------------------- */
#define USB0_BURSTSIZE_RXPBURST_Pos           0                                                       /*!< USB0 BURSTSIZE: RXPBURST Position       */
#define USB0_BURSTSIZE_RXPBURST_Msk           (0x000000ffUL << USB0_BURSTSIZE_RXPBURST_Pos)           /*!< USB0 BURSTSIZE: RXPBURST Mask           */
#define USB0_BURSTSIZE_TXPBURST_Pos           8                                                       /*!< USB0 BURSTSIZE: TXPBURST Position       */
#define USB0_BURSTSIZE_TXPBURST_Msk           (0x000000ffUL << USB0_BURSTSIZE_TXPBURST_Pos)           /*!< USB0 BURSTSIZE: TXPBURST Mask           */

/* ------------------------------  USB0_TXFILLTUNING  ----------------------------- */
#define USB0_TXFILLTUNING_TXSCHOH_Pos         0                                                       /*!< USB0 TXFILLTUNING: TXSCHOH Position     */
#define USB0_TXFILLTUNING_TXSCHOH_Msk         (0x000000ffUL << USB0_TXFILLTUNING_TXSCHOH_Pos)         /*!< USB0 TXFILLTUNING: TXSCHOH Mask         */
#define USB0_TXFILLTUNING_TXSCHEATLTH_Pos     8                                                       /*!< USB0 TXFILLTUNING: TXSCHEATLTH Position */
#define USB0_TXFILLTUNING_TXSCHEATLTH_Msk     (0x1fUL << USB0_TXFILLTUNING_TXSCHEATLTH_Pos)           /*!< USB0 TXFILLTUNING: TXSCHEATLTH Mask     */
#define USB0_TXFILLTUNING_TXFIFOTHRES_Pos     16                                                      /*!< USB0 TXFILLTUNING: TXFIFOTHRES Position */
#define USB0_TXFILLTUNING_TXFIFOTHRES_Msk     (0x3fUL << USB0_TXFILLTUNING_TXFIFOTHRES_Pos)           /*!< USB0 TXFILLTUNING: TXFIFOTHRES Mask     */

/* -------------------------------  USB0_BINTERVAL  ------------------------------- */
#define USB0_BINTERVAL_BINT_Pos               0                                                       /*!< USB0 BINTERVAL: BINT Position           */
#define USB0_BINTERVAL_BINT_Msk               (0x0fUL << USB0_BINTERVAL_BINT_Pos)                     /*!< USB0 BINTERVAL: BINT Mask               */

/* --------------------------------  USB0_ENDPTNAK  ------------------------------- */
#define USB0_ENDPTNAK_EPRN0_Pos               0                                                       /*!< USB0 ENDPTNAK: EPRN0 Position           */
#define USB0_ENDPTNAK_EPRN0_Msk               (0x01UL << USB0_ENDPTNAK_EPRN0_Pos)                     /*!< USB0 ENDPTNAK: EPRN0 Mask               */
#define USB0_ENDPTNAK_EPRN1_Pos               1                                                       /*!< USB0 ENDPTNAK: EPRN1 Position           */
#define USB0_ENDPTNAK_EPRN1_Msk               (0x01UL << USB0_ENDPTNAK_EPRN1_Pos)                     /*!< USB0 ENDPTNAK: EPRN1 Mask               */
#define USB0_ENDPTNAK_EPRN2_Pos               2                                                       /*!< USB0 ENDPTNAK: EPRN2 Position           */
#define USB0_ENDPTNAK_EPRN2_Msk               (0x01UL << USB0_ENDPTNAK_EPRN2_Pos)                     /*!< USB0 ENDPTNAK: EPRN2 Mask               */
#define USB0_ENDPTNAK_EPRN3_Pos               3                                                       /*!< USB0 ENDPTNAK: EPRN3 Position           */
#define USB0_ENDPTNAK_EPRN3_Msk               (0x01UL << USB0_ENDPTNAK_EPRN3_Pos)                     /*!< USB0 ENDPTNAK: EPRN3 Mask               */
#define USB0_ENDPTNAK_EPRN4_Pos               4                                                       /*!< USB0 ENDPTNAK: EPRN4 Position           */
#define USB0_ENDPTNAK_EPRN4_Msk               (0x01UL << USB0_ENDPTNAK_EPRN4_Pos)                     /*!< USB0 ENDPTNAK: EPRN4 Mask               */
#define USB0_ENDPTNAK_EPRN5_Pos               5                                                       /*!< USB0 ENDPTNAK: EPRN5 Position           */
#define USB0_ENDPTNAK_EPRN5_Msk               (0x01UL << USB0_ENDPTNAK_EPRN5_Pos)                     /*!< USB0 ENDPTNAK: EPRN5 Mask               */
#define USB0_ENDPTNAK_EPTN0_Pos               16                                                      /*!< USB0 ENDPTNAK: EPTN0 Position           */
#define USB0_ENDPTNAK_EPTN0_Msk               (0x01UL << USB0_ENDPTNAK_EPTN0_Pos)                     /*!< USB0 ENDPTNAK: EPTN0 Mask               */
#define USB0_ENDPTNAK_EPTN1_Pos               17                                                      /*!< USB0 ENDPTNAK: EPTN1 Position           */
#define USB0_ENDPTNAK_EPTN1_Msk               (0x01UL << USB0_ENDPTNAK_EPTN1_Pos)                     /*!< USB0 ENDPTNAK: EPTN1 Mask               */
#define USB0_ENDPTNAK_EPTN2_Pos               18                                                      /*!< USB0 ENDPTNAK: EPTN2 Position           */
#define USB0_ENDPTNAK_EPTN2_Msk               (0x01UL << USB0_ENDPTNAK_EPTN2_Pos)                     /*!< USB0 ENDPTNAK: EPTN2 Mask               */
#define USB0_ENDPTNAK_EPTN3_Pos               19                                                      /*!< USB0 ENDPTNAK: EPTN3 Position           */
#define USB0_ENDPTNAK_EPTN3_Msk               (0x01UL << USB0_ENDPTNAK_EPTN3_Pos)                     /*!< USB0 ENDPTNAK: EPTN3 Mask               */
#define USB0_ENDPTNAK_EPTN4_Pos               20                                                      /*!< USB0 ENDPTNAK: EPTN4 Position           */
#define USB0_ENDPTNAK_EPTN4_Msk               (0x01UL << USB0_ENDPTNAK_EPTN4_Pos)                     /*!< USB0 ENDPTNAK: EPTN4 Mask               */
#define USB0_ENDPTNAK_EPTN5_Pos               21                                                      /*!< USB0 ENDPTNAK: EPTN5 Position           */
#define USB0_ENDPTNAK_EPTN5_Msk               (0x01UL << USB0_ENDPTNAK_EPTN5_Pos)                     /*!< USB0 ENDPTNAK: EPTN5 Mask               */

/* -------------------------------  USB0_ENDPTNAKEN  ------------------------------ */
#define USB0_ENDPTNAKEN_EPRNE0_Pos            0                                                       /*!< USB0 ENDPTNAKEN: EPRNE0 Position        */
#define USB0_ENDPTNAKEN_EPRNE0_Msk            (0x01UL << USB0_ENDPTNAKEN_EPRNE0_Pos)                  /*!< USB0 ENDPTNAKEN: EPRNE0 Mask            */
#define USB0_ENDPTNAKEN_EPRNE1_Pos            1                                                       /*!< USB0 ENDPTNAKEN: EPRNE1 Position        */
#define USB0_ENDPTNAKEN_EPRNE1_Msk            (0x01UL << USB0_ENDPTNAKEN_EPRNE1_Pos)                  /*!< USB0 ENDPTNAKEN: EPRNE1 Mask            */
#define USB0_ENDPTNAKEN_EPRNE2_Pos            2                                                       /*!< USB0 ENDPTNAKEN: EPRNE2 Position        */
#define USB0_ENDPTNAKEN_EPRNE2_Msk            (0x01UL << USB0_ENDPTNAKEN_EPRNE2_Pos)                  /*!< USB0 ENDPTNAKEN: EPRNE2 Mask            */
#define USB0_ENDPTNAKEN_EPRNE3_Pos            3                                                       /*!< USB0 ENDPTNAKEN: EPRNE3 Position        */
#define USB0_ENDPTNAKEN_EPRNE3_Msk            (0x01UL << USB0_ENDPTNAKEN_EPRNE3_Pos)                  /*!< USB0 ENDPTNAKEN: EPRNE3 Mask            */
#define USB0_ENDPTNAKEN_EPRNE4_Pos            4                                                       /*!< USB0 ENDPTNAKEN: EPRNE4 Position        */
#define USB0_ENDPTNAKEN_EPRNE4_Msk            (0x01UL << USB0_ENDPTNAKEN_EPRNE4_Pos)                  /*!< USB0 ENDPTNAKEN: EPRNE4 Mask            */
#define USB0_ENDPTNAKEN_EPRNE5_Pos            5                                                       /*!< USB0 ENDPTNAKEN: EPRNE5 Position        */
#define USB0_ENDPTNAKEN_EPRNE5_Msk            (0x01UL << USB0_ENDPTNAKEN_EPRNE5_Pos)                  /*!< USB0 ENDPTNAKEN: EPRNE5 Mask            */
#define USB0_ENDPTNAKEN_EPTNE0_Pos            16                                                      /*!< USB0 ENDPTNAKEN: EPTNE0 Position        */
#define USB0_ENDPTNAKEN_EPTNE0_Msk            (0x01UL << USB0_ENDPTNAKEN_EPTNE0_Pos)                  /*!< USB0 ENDPTNAKEN: EPTNE0 Mask            */
#define USB0_ENDPTNAKEN_EPTNE1_Pos            17                                                      /*!< USB0 ENDPTNAKEN: EPTNE1 Position        */
#define USB0_ENDPTNAKEN_EPTNE1_Msk            (0x01UL << USB0_ENDPTNAKEN_EPTNE1_Pos)                  /*!< USB0 ENDPTNAKEN: EPTNE1 Mask            */
#define USB0_ENDPTNAKEN_EPTNE2_Pos            18                                                      /*!< USB0 ENDPTNAKEN: EPTNE2 Position        */
#define USB0_ENDPTNAKEN_EPTNE2_Msk            (0x01UL << USB0_ENDPTNAKEN_EPTNE2_Pos)                  /*!< USB0 ENDPTNAKEN: EPTNE2 Mask            */
#define USB0_ENDPTNAKEN_EPTNE3_Pos            19                                                      /*!< USB0 ENDPTNAKEN: EPTNE3 Position        */
#define USB0_ENDPTNAKEN_EPTNE3_Msk            (0x01UL << USB0_ENDPTNAKEN_EPTNE3_Pos)                  /*!< USB0 ENDPTNAKEN: EPTNE3 Mask            */
#define USB0_ENDPTNAKEN_EPTNE4_Pos            20                                                      /*!< USB0 ENDPTNAKEN: EPTNE4 Position        */
#define USB0_ENDPTNAKEN_EPTNE4_Msk            (0x01UL << USB0_ENDPTNAKEN_EPTNE4_Pos)                  /*!< USB0 ENDPTNAKEN: EPTNE4 Mask            */
#define USB0_ENDPTNAKEN_EPTNE5_Pos            21                                                      /*!< USB0 ENDPTNAKEN: EPTNE5 Position        */
#define USB0_ENDPTNAKEN_EPTNE5_Msk            (0x01UL << USB0_ENDPTNAKEN_EPTNE5_Pos)                  /*!< USB0 ENDPTNAKEN: EPTNE5 Mask            */

/* -------------------------------  USB0_PORTSC1_D  ------------------------------- */
#define USB0_PORTSC1_D_CCS_Pos                0                                                       /*!< USB0 PORTSC1_D: CCS Position            */
#define USB0_PORTSC1_D_CCS_Msk                (0x01UL << USB0_PORTSC1_D_CCS_Pos)                      /*!< USB0 PORTSC1_D: CCS Mask                */
#define USB0_PORTSC1_D_PE_Pos                 2                                                       /*!< USB0 PORTSC1_D: PE Position             */
#define USB0_PORTSC1_D_PE_Msk                 (0x01UL << USB0_PORTSC1_D_PE_Pos)                       /*!< USB0 PORTSC1_D: PE Mask                 */
#define USB0_PORTSC1_D_PEC_Pos                3                                                       /*!< USB0 PORTSC1_D: PEC Position            */
#define USB0_PORTSC1_D_PEC_Msk                (0x01UL << USB0_PORTSC1_D_PEC_Pos)                      /*!< USB0 PORTSC1_D: PEC Mask                */
#define USB0_PORTSC1_D_FPR_Pos                6                                                       /*!< USB0 PORTSC1_D: FPR Position            */
#define USB0_PORTSC1_D_FPR_Msk                (0x01UL << USB0_PORTSC1_D_FPR_Pos)                      /*!< USB0 PORTSC1_D: FPR Mask                */
#define USB0_PORTSC1_D_SUSP_Pos               7                                                       /*!< USB0 PORTSC1_D: SUSP Position           */
#define USB0_PORTSC1_D_SUSP_Msk               (0x01UL << USB0_PORTSC1_D_SUSP_Pos)                     /*!< USB0 PORTSC1_D: SUSP Mask               */
#define USB0_PORTSC1_D_PR_Pos                 8                                                       /*!< USB0 PORTSC1_D: PR Position             */
#define USB0_PORTSC1_D_PR_Msk                 (0x01UL << USB0_PORTSC1_D_PR_Pos)                       /*!< USB0 PORTSC1_D: PR Mask                 */
#define USB0_PORTSC1_D_HSP_Pos                9                                                       /*!< USB0 PORTSC1_D: HSP Position            */
#define USB0_PORTSC1_D_HSP_Msk                (0x01UL << USB0_PORTSC1_D_HSP_Pos)                      /*!< USB0 PORTSC1_D: HSP Mask                */
#define USB0_PORTSC1_D_PIC1_0_Pos             14                                                      /*!< USB0 PORTSC1_D: PIC1_0 Position         */
#define USB0_PORTSC1_D_PIC1_0_Msk             (0x03UL << USB0_PORTSC1_D_PIC1_0_Pos)                   /*!< USB0 PORTSC1_D: PIC1_0 Mask             */
#define USB0_PORTSC1_D_PTC3_0_Pos             16                                                      /*!< USB0 PORTSC1_D: PTC3_0 Position         */
#define USB0_PORTSC1_D_PTC3_0_Msk             (0x0fUL << USB0_PORTSC1_D_PTC3_0_Pos)                   /*!< USB0 PORTSC1_D: PTC3_0 Mask             */
#define USB0_PORTSC1_D_PHCD_Pos               23                                                      /*!< USB0 PORTSC1_D: PHCD Position           */
#define USB0_PORTSC1_D_PHCD_Msk               (0x01UL << USB0_PORTSC1_D_PHCD_Pos)                     /*!< USB0 PORTSC1_D: PHCD Mask               */
#define USB0_PORTSC1_D_PFSC_Pos               24                                                      /*!< USB0 PORTSC1_D: PFSC Position           */
#define USB0_PORTSC1_D_PFSC_Msk               (0x01UL << USB0_PORTSC1_D_PFSC_Pos)                     /*!< USB0 PORTSC1_D: PFSC Mask               */
#define USB0_PORTSC1_D_PSPD_Pos               26                                                      /*!< USB0 PORTSC1_D: PSPD Position           */
#define USB0_PORTSC1_D_PSPD_Msk               (0x03UL << USB0_PORTSC1_D_PSPD_Pos)                     /*!< USB0 PORTSC1_D: PSPD Mask               */

/* -------------------------------  USB0_PORTSC1_H  ------------------------------- */
#define USB0_PORTSC1_H_CCS_Pos                0                                                       /*!< USB0 PORTSC1_H: CCS Position            */
#define USB0_PORTSC1_H_CCS_Msk                (0x01UL << USB0_PORTSC1_H_CCS_Pos)                      /*!< USB0 PORTSC1_H: CCS Mask                */
#define USB0_PORTSC1_H_CSC_Pos                1                                                       /*!< USB0 PORTSC1_H: CSC Position            */
#define USB0_PORTSC1_H_CSC_Msk                (0x01UL << USB0_PORTSC1_H_CSC_Pos)                      /*!< USB0 PORTSC1_H: CSC Mask                */
#define USB0_PORTSC1_H_PE_Pos                 2                                                       /*!< USB0 PORTSC1_H: PE Position             */
#define USB0_PORTSC1_H_PE_Msk                 (0x01UL << USB0_PORTSC1_H_PE_Pos)                       /*!< USB0 PORTSC1_H: PE Mask                 */
#define USB0_PORTSC1_H_PEC_Pos                3                                                       /*!< USB0 PORTSC1_H: PEC Position            */
#define USB0_PORTSC1_H_PEC_Msk                (0x01UL << USB0_PORTSC1_H_PEC_Pos)                      /*!< USB0 PORTSC1_H: PEC Mask                */
#define USB0_PORTSC1_H_OCA_Pos                4                                                       /*!< USB0 PORTSC1_H: OCA Position            */
#define USB0_PORTSC1_H_OCA_Msk                (0x01UL << USB0_PORTSC1_H_OCA_Pos)                      /*!< USB0 PORTSC1_H: OCA Mask                */
#define USB0_PORTSC1_H_OCC_Pos                5                                                       /*!< USB0 PORTSC1_H: OCC Position            */
#define USB0_PORTSC1_H_OCC_Msk                (0x01UL << USB0_PORTSC1_H_OCC_Pos)                      /*!< USB0 PORTSC1_H: OCC Mask                */
#define USB0_PORTSC1_H_FPR_Pos                6                                                       /*!< USB0 PORTSC1_H: FPR Position            */
#define USB0_PORTSC1_H_FPR_Msk                (0x01UL << USB0_PORTSC1_H_FPR_Pos)                      /*!< USB0 PORTSC1_H: FPR Mask                */
#define USB0_PORTSC1_H_SUSP_Pos               7                                                       /*!< USB0 PORTSC1_H: SUSP Position           */
#define USB0_PORTSC1_H_SUSP_Msk               (0x01UL << USB0_PORTSC1_H_SUSP_Pos)                     /*!< USB0 PORTSC1_H: SUSP Mask               */
#define USB0_PORTSC1_H_PR_Pos                 8                                                       /*!< USB0 PORTSC1_H: PR Position             */
#define USB0_PORTSC1_H_PR_Msk                 (0x01UL << USB0_PORTSC1_H_PR_Pos)                       /*!< USB0 PORTSC1_H: PR Mask                 */
#define USB0_PORTSC1_H_HSP_Pos                9                                                       /*!< USB0 PORTSC1_H: HSP Position            */
#define USB0_PORTSC1_H_HSP_Msk                (0x01UL << USB0_PORTSC1_H_HSP_Pos)                      /*!< USB0 PORTSC1_H: HSP Mask                */
#define USB0_PORTSC1_H_LS_Pos                 10                                                      /*!< USB0 PORTSC1_H: LS Position             */
#define USB0_PORTSC1_H_LS_Msk                 (0x03UL << USB0_PORTSC1_H_LS_Pos)                       /*!< USB0 PORTSC1_H: LS Mask                 */
#define USB0_PORTSC1_H_PP_Pos                 12                                                      /*!< USB0 PORTSC1_H: PP Position             */
#define USB0_PORTSC1_H_PP_Msk                 (0x01UL << USB0_PORTSC1_H_PP_Pos)                       /*!< USB0 PORTSC1_H: PP Mask                 */
#define USB0_PORTSC1_H_PIC1_0_Pos             14                                                      /*!< USB0 PORTSC1_H: PIC1_0 Position         */
#define USB0_PORTSC1_H_PIC1_0_Msk             (0x03UL << USB0_PORTSC1_H_PIC1_0_Pos)                   /*!< USB0 PORTSC1_H: PIC1_0 Mask             */
#define USB0_PORTSC1_H_PTC3_0_Pos             16                                                      /*!< USB0 PORTSC1_H: PTC3_0 Position         */
#define USB0_PORTSC1_H_PTC3_0_Msk             (0x0fUL << USB0_PORTSC1_H_PTC3_0_Pos)                   /*!< USB0 PORTSC1_H: PTC3_0 Mask             */
#define USB0_PORTSC1_H_WKCN_Pos               20                                                      /*!< USB0 PORTSC1_H: WKCN Position           */
#define USB0_PORTSC1_H_WKCN_Msk               (0x01UL << USB0_PORTSC1_H_WKCN_Pos)                     /*!< USB0 PORTSC1_H: WKCN Mask               */
#define USB0_PORTSC1_H_WKDC_Pos               21                                                      /*!< USB0 PORTSC1_H: WKDC Position           */
#define USB0_PORTSC1_H_WKDC_Msk               (0x01UL << USB0_PORTSC1_H_WKDC_Pos)                     /*!< USB0 PORTSC1_H: WKDC Mask               */
#define USB0_PORTSC1_H_WKOC_Pos               22                                                      /*!< USB0 PORTSC1_H: WKOC Position           */
#define USB0_PORTSC1_H_WKOC_Msk               (0x01UL << USB0_PORTSC1_H_WKOC_Pos)                     /*!< USB0 PORTSC1_H: WKOC Mask               */
#define USB0_PORTSC1_H_PHCD_Pos               23                                                      /*!< USB0 PORTSC1_H: PHCD Position           */
#define USB0_PORTSC1_H_PHCD_Msk               (0x01UL << USB0_PORTSC1_H_PHCD_Pos)                     /*!< USB0 PORTSC1_H: PHCD Mask               */
#define USB0_PORTSC1_H_PFSC_Pos               24                                                      /*!< USB0 PORTSC1_H: PFSC Position           */
#define USB0_PORTSC1_H_PFSC_Msk               (0x01UL << USB0_PORTSC1_H_PFSC_Pos)                     /*!< USB0 PORTSC1_H: PFSC Mask               */
#define USB0_PORTSC1_H_PSPD_Pos               26                                                      /*!< USB0 PORTSC1_H: PSPD Position           */
#define USB0_PORTSC1_H_PSPD_Msk               (0x03UL << USB0_PORTSC1_H_PSPD_Pos)                     /*!< USB0 PORTSC1_H: PSPD Mask               */

/* ---------------------------------  USB0_OTGSC  --------------------------------- */
#define USB0_OTGSC_VD_Pos                     0                                                       /*!< USB0 OTGSC: VD Position                 */
#define USB0_OTGSC_VD_Msk                     (0x01UL << USB0_OTGSC_VD_Pos)                           /*!< USB0 OTGSC: VD Mask                     */
#define USB0_OTGSC_VC_Pos                     1                                                       /*!< USB0 OTGSC: VC Position                 */
#define USB0_OTGSC_VC_Msk                     (0x01UL << USB0_OTGSC_VC_Pos)                           /*!< USB0 OTGSC: VC Mask                     */
#define USB0_OTGSC_HAAR_Pos                   2                                                       /*!< USB0 OTGSC: HAAR Position               */
#define USB0_OTGSC_HAAR_Msk                   (0x01UL << USB0_OTGSC_HAAR_Pos)                         /*!< USB0 OTGSC: HAAR Mask                   */
#define USB0_OTGSC_OT_Pos                     3                                                       /*!< USB0 OTGSC: OT Position                 */
#define USB0_OTGSC_OT_Msk                     (0x01UL << USB0_OTGSC_OT_Pos)                           /*!< USB0 OTGSC: OT Mask                     */
#define USB0_OTGSC_DP_Pos                     4                                                       /*!< USB0 OTGSC: DP Position                 */
#define USB0_OTGSC_DP_Msk                     (0x01UL << USB0_OTGSC_DP_Pos)                           /*!< USB0 OTGSC: DP Mask                     */
#define USB0_OTGSC_IDPU_Pos                   5                                                       /*!< USB0 OTGSC: IDPU Position               */
#define USB0_OTGSC_IDPU_Msk                   (0x01UL << USB0_OTGSC_IDPU_Pos)                         /*!< USB0 OTGSC: IDPU Mask                   */
#define USB0_OTGSC_HADP_Pos                   6                                                       /*!< USB0 OTGSC: HADP Position               */
#define USB0_OTGSC_HADP_Msk                   (0x01UL << USB0_OTGSC_HADP_Pos)                         /*!< USB0 OTGSC: HADP Mask                   */
#define USB0_OTGSC_HABA_Pos                   7                                                       /*!< USB0 OTGSC: HABA Position               */
#define USB0_OTGSC_HABA_Msk                   (0x01UL << USB0_OTGSC_HABA_Pos)                         /*!< USB0 OTGSC: HABA Mask                   */
#define USB0_OTGSC_ID_Pos                     8                                                       /*!< USB0 OTGSC: ID Position                 */
#define USB0_OTGSC_ID_Msk                     (0x01UL << USB0_OTGSC_ID_Pos)                           /*!< USB0 OTGSC: ID Mask                     */
#define USB0_OTGSC_AVV_Pos                    9                                                       /*!< USB0 OTGSC: AVV Position                */
#define USB0_OTGSC_AVV_Msk                    (0x01UL << USB0_OTGSC_AVV_Pos)                          /*!< USB0 OTGSC: AVV Mask                    */
#define USB0_OTGSC_ASV_Pos                    10                                                      /*!< USB0 OTGSC: ASV Position                */
#define USB0_OTGSC_ASV_Msk                    (0x01UL << USB0_OTGSC_ASV_Pos)                          /*!< USB0 OTGSC: ASV Mask                    */
#define USB0_OTGSC_BSV_Pos                    11                                                      /*!< USB0 OTGSC: BSV Position                */
#define USB0_OTGSC_BSV_Msk                    (0x01UL << USB0_OTGSC_BSV_Pos)                          /*!< USB0 OTGSC: BSV Mask                    */
#define USB0_OTGSC_BSE_Pos                    12                                                      /*!< USB0 OTGSC: BSE Position                */
#define USB0_OTGSC_BSE_Msk                    (0x01UL << USB0_OTGSC_BSE_Pos)                          /*!< USB0 OTGSC: BSE Mask                    */
#define USB0_OTGSC_MS1T_Pos                   13                                                      /*!< USB0 OTGSC: MS1T Position               */
#define USB0_OTGSC_MS1T_Msk                   (0x01UL << USB0_OTGSC_MS1T_Pos)                         /*!< USB0 OTGSC: MS1T Mask                   */
#define USB0_OTGSC_DPS_Pos                    14                                                      /*!< USB0 OTGSC: DPS Position                */
#define USB0_OTGSC_DPS_Msk                    (0x01UL << USB0_OTGSC_DPS_Pos)                          /*!< USB0 OTGSC: DPS Mask                    */
#define USB0_OTGSC_IDIS_Pos                   16                                                      /*!< USB0 OTGSC: IDIS Position               */
#define USB0_OTGSC_IDIS_Msk                   (0x01UL << USB0_OTGSC_IDIS_Pos)                         /*!< USB0 OTGSC: IDIS Mask                   */
#define USB0_OTGSC_AVVIS_Pos                  17                                                      /*!< USB0 OTGSC: AVVIS Position              */
#define USB0_OTGSC_AVVIS_Msk                  (0x01UL << USB0_OTGSC_AVVIS_Pos)                        /*!< USB0 OTGSC: AVVIS Mask                  */
#define USB0_OTGSC_ASVIS_Pos                  18                                                      /*!< USB0 OTGSC: ASVIS Position              */
#define USB0_OTGSC_ASVIS_Msk                  (0x01UL << USB0_OTGSC_ASVIS_Pos)                        /*!< USB0 OTGSC: ASVIS Mask                  */
#define USB0_OTGSC_BSVIS_Pos                  19                                                      /*!< USB0 OTGSC: BSVIS Position              */
#define USB0_OTGSC_BSVIS_Msk                  (0x01UL << USB0_OTGSC_BSVIS_Pos)                        /*!< USB0 OTGSC: BSVIS Mask                  */
#define USB0_OTGSC_BSEIS_Pos                  20                                                      /*!< USB0 OTGSC: BSEIS Position              */
#define USB0_OTGSC_BSEIS_Msk                  (0x01UL << USB0_OTGSC_BSEIS_Pos)                        /*!< USB0 OTGSC: BSEIS Mask                  */
#define USB0_OTGSC_ms1S_Pos                   21                                                      /*!< USB0 OTGSC: ms1S Position               */
#define USB0_OTGSC_ms1S_Msk                   (0x01UL << USB0_OTGSC_ms1S_Pos)                         /*!< USB0 OTGSC: ms1S Mask                   */
#define USB0_OTGSC_DPIS_Pos                   22                                                      /*!< USB0 OTGSC: DPIS Position               */
#define USB0_OTGSC_DPIS_Msk                   (0x01UL << USB0_OTGSC_DPIS_Pos)                         /*!< USB0 OTGSC: DPIS Mask                   */
#define USB0_OTGSC_IDIE_Pos                   24                                                      /*!< USB0 OTGSC: IDIE Position               */
#define USB0_OTGSC_IDIE_Msk                   (0x01UL << USB0_OTGSC_IDIE_Pos)                         /*!< USB0 OTGSC: IDIE Mask                   */
#define USB0_OTGSC_AVVIE_Pos                  25                                                      /*!< USB0 OTGSC: AVVIE Position              */
#define USB0_OTGSC_AVVIE_Msk                  (0x01UL << USB0_OTGSC_AVVIE_Pos)                        /*!< USB0 OTGSC: AVVIE Mask                  */
#define USB0_OTGSC_ASVIE_Pos                  26                                                      /*!< USB0 OTGSC: ASVIE Position              */
#define USB0_OTGSC_ASVIE_Msk                  (0x01UL << USB0_OTGSC_ASVIE_Pos)                        /*!< USB0 OTGSC: ASVIE Mask                  */
#define USB0_OTGSC_BSVIE_Pos                  27                                                      /*!< USB0 OTGSC: BSVIE Position              */
#define USB0_OTGSC_BSVIE_Msk                  (0x01UL << USB0_OTGSC_BSVIE_Pos)                        /*!< USB0 OTGSC: BSVIE Mask                  */
#define USB0_OTGSC_BSEIE_Pos                  28                                                      /*!< USB0 OTGSC: BSEIE Position              */
#define USB0_OTGSC_BSEIE_Msk                  (0x01UL << USB0_OTGSC_BSEIE_Pos)                        /*!< USB0 OTGSC: BSEIE Mask                  */
#define USB0_OTGSC_MS1E_Pos                   29                                                      /*!< USB0 OTGSC: MS1E Position               */
#define USB0_OTGSC_MS1E_Msk                   (0x01UL << USB0_OTGSC_MS1E_Pos)                         /*!< USB0 OTGSC: MS1E Mask                   */
#define USB0_OTGSC_DPIE_Pos                   30                                                      /*!< USB0 OTGSC: DPIE Position               */
#define USB0_OTGSC_DPIE_Msk                   (0x01UL << USB0_OTGSC_DPIE_Pos)                         /*!< USB0 OTGSC: DPIE Mask                   */

/* -------------------------------  USB0_USBMODE_D  ------------------------------- */
#define USB0_USBMODE_D_CM1_0_Pos              0                                                       /*!< USB0 USBMODE_D: CM1_0 Position          */
#define USB0_USBMODE_D_CM1_0_Msk              (0x03UL << USB0_USBMODE_D_CM1_0_Pos)                    /*!< USB0 USBMODE_D: CM1_0 Mask              */
#define USB0_USBMODE_D_ES_Pos                 2                                                       /*!< USB0 USBMODE_D: ES Position             */
#define USB0_USBMODE_D_ES_Msk                 (0x01UL << USB0_USBMODE_D_ES_Pos)                       /*!< USB0 USBMODE_D: ES Mask                 */
#define USB0_USBMODE_D_SLOM_Pos               3                                                       /*!< USB0 USBMODE_D: SLOM Position           */
#define USB0_USBMODE_D_SLOM_Msk               (0x01UL << USB0_USBMODE_D_SLOM_Pos)                     /*!< USB0 USBMODE_D: SLOM Mask               */
#define USB0_USBMODE_D_SDIS_Pos               4                                                       /*!< USB0 USBMODE_D: SDIS Position           */
#define USB0_USBMODE_D_SDIS_Msk               (0x01UL << USB0_USBMODE_D_SDIS_Pos)                     /*!< USB0 USBMODE_D: SDIS Mask               */

/* -------------------------------  USB0_USBMODE_H  ------------------------------- */
#define USB0_USBMODE_H_CM_Pos                 0                                                       /*!< USB0 USBMODE_H: CM Position             */
#define USB0_USBMODE_H_CM_Msk                 (0x03UL << USB0_USBMODE_H_CM_Pos)                       /*!< USB0 USBMODE_H: CM Mask                 */
#define USB0_USBMODE_H_ES_Pos                 2                                                       /*!< USB0 USBMODE_H: ES Position             */
#define USB0_USBMODE_H_ES_Msk                 (0x01UL << USB0_USBMODE_H_ES_Pos)                       /*!< USB0 USBMODE_H: ES Mask                 */
#define USB0_USBMODE_H_SDIS_Pos               4                                                       /*!< USB0 USBMODE_H: SDIS Position           */
#define USB0_USBMODE_H_SDIS_Msk               (0x01UL << USB0_USBMODE_H_SDIS_Pos)                     /*!< USB0 USBMODE_H: SDIS Mask               */
#define USB0_USBMODE_H_VBPS_Pos               5                                                       /*!< USB0 USBMODE_H: VBPS Position           */
#define USB0_USBMODE_H_VBPS_Msk               (0x01UL << USB0_USBMODE_H_VBPS_Pos)                     /*!< USB0 USBMODE_H: VBPS Mask               */

/* -----------------------------  USB0_ENDPTSETUPSTAT  ---------------------------- */
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT0_Pos 0                                                     /*!< USB0 ENDPTSETUPSTAT: ENDPTSETUPSTAT0 Position */
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT0_Msk (0x01UL << USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT0_Pos)   /*!< USB0 ENDPTSETUPSTAT: ENDPTSETUPSTAT0 Mask */
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT1_Pos 1                                                     /*!< USB0 ENDPTSETUPSTAT: ENDPTSETUPSTAT1 Position */
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT1_Msk (0x01UL << USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT1_Pos)   /*!< USB0 ENDPTSETUPSTAT: ENDPTSETUPSTAT1 Mask */
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT2_Pos 2                                                     /*!< USB0 ENDPTSETUPSTAT: ENDPTSETUPSTAT2 Position */
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT2_Msk (0x01UL << USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT2_Pos)   /*!< USB0 ENDPTSETUPSTAT: ENDPTSETUPSTAT2 Mask */
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT3_Pos 3                                                     /*!< USB0 ENDPTSETUPSTAT: ENDPTSETUPSTAT3 Position */
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT3_Msk (0x01UL << USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT3_Pos)   /*!< USB0 ENDPTSETUPSTAT: ENDPTSETUPSTAT3 Mask */
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT4_Pos 4                                                     /*!< USB0 ENDPTSETUPSTAT: ENDPTSETUPSTAT4 Position */
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT4_Msk (0x01UL << USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT4_Pos)   /*!< USB0 ENDPTSETUPSTAT: ENDPTSETUPSTAT4 Mask */
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT5_Pos 5                                                     /*!< USB0 ENDPTSETUPSTAT: ENDPTSETUPSTAT5 Position */
#define USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT5_Msk (0x01UL << USB0_ENDPTSETUPSTAT_ENDPTSETUPSTAT5_Pos)   /*!< USB0 ENDPTSETUPSTAT: ENDPTSETUPSTAT5 Mask */

/* -------------------------------  USB0_ENDPTPRIME  ------------------------------ */
#define USB0_ENDPTPRIME_PERB0_Pos             0                                                       /*!< USB0 ENDPTPRIME: PERB0 Position         */
#define USB0_ENDPTPRIME_PERB0_Msk             (0x01UL << USB0_ENDPTPRIME_PERB0_Pos)                   /*!< USB0 ENDPTPRIME: PERB0 Mask             */
#define USB0_ENDPTPRIME_PERB1_Pos             1                                                       /*!< USB0 ENDPTPRIME: PERB1 Position         */
#define USB0_ENDPTPRIME_PERB1_Msk             (0x01UL << USB0_ENDPTPRIME_PERB1_Pos)                   /*!< USB0 ENDPTPRIME: PERB1 Mask             */
#define USB0_ENDPTPRIME_PERB2_Pos             2                                                       /*!< USB0 ENDPTPRIME: PERB2 Position         */
#define USB0_ENDPTPRIME_PERB2_Msk             (0x01UL << USB0_ENDPTPRIME_PERB2_Pos)                   /*!< USB0 ENDPTPRIME: PERB2 Mask             */
#define USB0_ENDPTPRIME_PERB3_Pos             3                                                       /*!< USB0 ENDPTPRIME: PERB3 Position         */
#define USB0_ENDPTPRIME_PERB3_Msk             (0x01UL << USB0_ENDPTPRIME_PERB3_Pos)                   /*!< USB0 ENDPTPRIME: PERB3 Mask             */
#define USB0_ENDPTPRIME_PERB4_Pos             4                                                       /*!< USB0 ENDPTPRIME: PERB4 Position         */
#define USB0_ENDPTPRIME_PERB4_Msk             (0x01UL << USB0_ENDPTPRIME_PERB4_Pos)                   /*!< USB0 ENDPTPRIME: PERB4 Mask             */
#define USB0_ENDPTPRIME_PERB5_Pos             5                                                       /*!< USB0 ENDPTPRIME: PERB5 Position         */
#define USB0_ENDPTPRIME_PERB5_Msk             (0x01UL << USB0_ENDPTPRIME_PERB5_Pos)                   /*!< USB0 ENDPTPRIME: PERB5 Mask             */
#define USB0_ENDPTPRIME_PETB0_Pos             16                                                      /*!< USB0 ENDPTPRIME: PETB0 Position         */
#define USB0_ENDPTPRIME_PETB0_Msk             (0x01UL << USB0_ENDPTPRIME_PETB0_Pos)                   /*!< USB0 ENDPTPRIME: PETB0 Mask             */
#define USB0_ENDPTPRIME_PETB1_Pos             17                                                      /*!< USB0 ENDPTPRIME: PETB1 Position         */
#define USB0_ENDPTPRIME_PETB1_Msk             (0x01UL << USB0_ENDPTPRIME_PETB1_Pos)                   /*!< USB0 ENDPTPRIME: PETB1 Mask             */
#define USB0_ENDPTPRIME_PETB2_Pos             18                                                      /*!< USB0 ENDPTPRIME: PETB2 Position         */
#define USB0_ENDPTPRIME_PETB2_Msk             (0x01UL << USB0_ENDPTPRIME_PETB2_Pos)                   /*!< USB0 ENDPTPRIME: PETB2 Mask             */
#define USB0_ENDPTPRIME_PETB3_Pos             19                                                      /*!< USB0 ENDPTPRIME: PETB3 Position         */
#define USB0_ENDPTPRIME_PETB3_Msk             (0x01UL << USB0_ENDPTPRIME_PETB3_Pos)                   /*!< USB0 ENDPTPRIME: PETB3 Mask             */
#define USB0_ENDPTPRIME_PETB4_Pos             20                                                      /*!< USB0 ENDPTPRIME: PETB4 Position         */
#define USB0_ENDPTPRIME_PETB4_Msk             (0x01UL << USB0_ENDPTPRIME_PETB4_Pos)                   /*!< USB0 ENDPTPRIME: PETB4 Mask             */
#define USB0_ENDPTPRIME_PETB5_Pos             21                                                      /*!< USB0 ENDPTPRIME: PETB5 Position         */
#define USB0_ENDPTPRIME_PETB5_Msk             (0x01UL << USB0_ENDPTPRIME_PETB5_Pos)                   /*!< USB0 ENDPTPRIME: PETB5 Mask             */

/* -------------------------------  USB0_ENDPTFLUSH  ------------------------------ */
#define USB0_ENDPTFLUSH_FERB0_Pos             0                                                       /*!< USB0 ENDPTFLUSH: FERB0 Position         */
#define USB0_ENDPTFLUSH_FERB0_Msk             (0x01UL << USB0_ENDPTFLUSH_FERB0_Pos)                   /*!< USB0 ENDPTFLUSH: FERB0 Mask             */
#define USB0_ENDPTFLUSH_FERB1_Pos             1                                                       /*!< USB0 ENDPTFLUSH: FERB1 Position         */
#define USB0_ENDPTFLUSH_FERB1_Msk             (0x01UL << USB0_ENDPTFLUSH_FERB1_Pos)                   /*!< USB0 ENDPTFLUSH: FERB1 Mask             */
#define USB0_ENDPTFLUSH_FERB2_Pos             2                                                       /*!< USB0 ENDPTFLUSH: FERB2 Position         */
#define USB0_ENDPTFLUSH_FERB2_Msk             (0x01UL << USB0_ENDPTFLUSH_FERB2_Pos)                   /*!< USB0 ENDPTFLUSH: FERB2 Mask             */
#define USB0_ENDPTFLUSH_FERB3_Pos             3                                                       /*!< USB0 ENDPTFLUSH: FERB3 Position         */
#define USB0_ENDPTFLUSH_FERB3_Msk             (0x01UL << USB0_ENDPTFLUSH_FERB3_Pos)                   /*!< USB0 ENDPTFLUSH: FERB3 Mask             */
#define USB0_ENDPTFLUSH_FERB4_Pos             4                                                       /*!< USB0 ENDPTFLUSH: FERB4 Position         */
#define USB0_ENDPTFLUSH_FERB4_Msk             (0x01UL << USB0_ENDPTFLUSH_FERB4_Pos)                   /*!< USB0 ENDPTFLUSH: FERB4 Mask             */
#define USB0_ENDPTFLUSH_FERB5_Pos             5                                                       /*!< USB0 ENDPTFLUSH: FERB5 Position         */
#define USB0_ENDPTFLUSH_FERB5_Msk             (0x01UL << USB0_ENDPTFLUSH_FERB5_Pos)                   /*!< USB0 ENDPTFLUSH: FERB5 Mask             */
#define USB0_ENDPTFLUSH_FETB0_Pos             16                                                      /*!< USB0 ENDPTFLUSH: FETB0 Position         */
#define USB0_ENDPTFLUSH_FETB0_Msk             (0x01UL << USB0_ENDPTFLUSH_FETB0_Pos)                   /*!< USB0 ENDPTFLUSH: FETB0 Mask             */
#define USB0_ENDPTFLUSH_FETB1_Pos             17                                                      /*!< USB0 ENDPTFLUSH: FETB1 Position         */
#define USB0_ENDPTFLUSH_FETB1_Msk             (0x01UL << USB0_ENDPTFLUSH_FETB1_Pos)                   /*!< USB0 ENDPTFLUSH: FETB1 Mask             */
#define USB0_ENDPTFLUSH_FETB2_Pos             18                                                      /*!< USB0 ENDPTFLUSH: FETB2 Position         */
#define USB0_ENDPTFLUSH_FETB2_Msk             (0x01UL << USB0_ENDPTFLUSH_FETB2_Pos)                   /*!< USB0 ENDPTFLUSH: FETB2 Mask             */
#define USB0_ENDPTFLUSH_FETB3_Pos             19                                                      /*!< USB0 ENDPTFLUSH: FETB3 Position         */
#define USB0_ENDPTFLUSH_FETB3_Msk             (0x01UL << USB0_ENDPTFLUSH_FETB3_Pos)                   /*!< USB0 ENDPTFLUSH: FETB3 Mask             */
#define USB0_ENDPTFLUSH_FETB4_Pos             20                                                      /*!< USB0 ENDPTFLUSH: FETB4 Position         */
#define USB0_ENDPTFLUSH_FETB4_Msk             (0x01UL << USB0_ENDPTFLUSH_FETB4_Pos)                   /*!< USB0 ENDPTFLUSH: FETB4 Mask  