/*****************************************************************************
 *                   SEGGER Microcontroller GmbH & Co. KG                    *
 *            Solutions for real time microcontroller applications           *
 *****************************************************************************
 *                                                                           *
 *               (c) 2015 SEGGER Microcontroller GmbH & Co. KG               *
 *                                                                           *
 *           Internet: www.segger.com   Support: support@segger.com          *
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 0

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak DMA0_IRQHandler
  .thumb_set DMA0_IRQHandler,Dummy_Handler

  .weak DMA1_IRQHandler
  .thumb_set DMA1_IRQHandler,Dummy_Handler

  .weak DMA2_IRQHandler
  .thumb_set DMA2_IRQHandler,Dummy_Handler

  .weak DMA3_IRQHandler
  .thumb_set DMA3_IRQHandler,Dummy_Handler

  .weak DMA4_IRQHandler
  .thumb_set DMA4_IRQHandler,Dummy_Handler

  .weak DMA5_IRQHandler
  .thumb_set DMA5_IRQHandler,Dummy_Handler

  .weak DMA6_IRQHandler
  .thumb_set DMA6_IRQHandler,Dummy_Handler

  .weak DMA7_IRQHandler
  .thumb_set DMA7_IRQHandler,Dummy_Handler

  .weak DMA8_IRQHandler
  .thumb_set DMA8_IRQHandler,Dummy_Handler

  .weak DMA9_IRQHandler
  .thumb_set DMA9_IRQHandler,Dummy_Handler

  .weak DMA10_IRQHandler
  .thumb_set DMA10_IRQHandler,Dummy_Handler

  .weak DMA11_IRQHandler
  .thumb_set DMA11_IRQHandler,Dummy_Handler

  .weak DMA12_IRQHandler
  .thumb_set DMA12_IRQHandler,Dummy_Handler

  .weak DMA13_IRQHandler
  .thumb_set DMA13_IRQHandler,Dummy_Handler

  .weak DMA14_IRQHandler
  .thumb_set DMA14_IRQHandler,Dummy_Handler

  .weak DMA15_IRQHandler
  .thumb_set DMA15_IRQHandler,Dummy_Handler

  .weak DMA_Error_IRQHandler
  .thumb_set DMA_Error_IRQHandler,Dummy_Handler

  .weak FTFE_IRQHandler
  .thumb_set FTFE_IRQHandler,Dummy_Handler

  .weak Read_Collision_IRQHandler
  .thumb_set Read_Collision_IRQHandler,Dummy_Handler

  .weak LVD_LVW_IRQHandler
  .thumb_set LVD_LVW_IRQHandler,Dummy_Handler

  .weak LLWU_IRQHandler
  .thumb_set LLWU_IRQHandler,Dummy_Handler

  .weak WDOG_EWM_IRQHandler
  .thumb_set WDOG_EWM_IRQHandler,Dummy_Handler

  .weak RNG_IRQHandler
  .thumb_set RNG_IRQHandler,Dummy_Handler

  .weak I2C0_IRQHandler
  .thumb_set I2C0_IRQHandler,Dummy_Handler

  .weak I2C1_IRQHandler
  .thumb_set I2C1_IRQHandler,Dummy_Handler

  .weak SPI0_IRQHandler
  .thumb_set SPI0_IRQHandler,Dummy_Handler

  .weak SPI1_IRQHandler
  .thumb_set SPI1_IRQHandler,Dummy_Handler

  .weak I2S0_Tx_IRQHandler
  .thumb_set I2S0_Tx_IRQHandler,Dummy_Handler

  .weak I2S0_Rx_IRQHandler
  .thumb_set I2S0_Rx_IRQHandler,Dummy_Handler

  .weak UART0_RX_TX_IRQHandler
  .thumb_set UART0_RX_TX_IRQHandler,Dummy_Handler

  .weak UART0_ERR_IRQHandler
  .thumb_set UART0_ERR_IRQHandler,Dummy_Handler

  .weak UART1_RX_TX_IRQHandler
  .thumb_set UART1_RX_TX_IRQHandler,Dummy_Handler

  .weak UART1_ERR_IRQHandler
  .thumb_set UART1_ERR_IRQHandler,Dummy_Handler

  .weak UART2_RX_TX_IRQHandler
  .thumb_set UART2_RX_TX_IRQHandler,Dummy_Handler

  .weak UART2_ERR_IRQHandler
  .thumb_set UART2_ERR_IRQHandler,Dummy_Handler

  .weak UART3_RX_TX_IRQHandler
  .thumb_set UART3_RX_TX_IRQHandler,Dummy_Handler

  .weak UART3_ERR_IRQHandler
  .thumb_set UART3_ERR_IRQHandler,Dummy_Handler

  .weak ADC0_IRQHandler
  .thumb_set ADC0_IRQHandler,Dummy_Handler

  .weak CMP0_IRQHandler
  .thumb_set CMP0_IRQHandler,Dummy_Handler

  .weak CMP1_IRQHandler
  .thumb_set CMP1_IRQHandler,Dummy_Handler

  .weak FTM0_IRQHandler
  .thumb_set FTM0_IRQHandler,Dummy_Handler

  .weak FTM1_IRQHandler
  .thumb_set FTM1_IRQHandler,Dummy_Handler

  .weak FTM2_IRQHandler
  .thumb_set FTM2_IRQHandler,Dummy_Handler

  .weak CMT_IRQHandler
  .thumb_set CMT_IRQHandler,Dummy_Handler

  .weak RTC_IRQHandler
  .thumb_set RTC_IRQHandler,Dummy_Handler

  .weak RTC_Seconds_IRQHandler
  .thumb_set RTC_Seconds_IRQHandler,Dummy_Handler

  .weak PIT0_IRQHandler
  .thumb_set PIT0_IRQHandler,Dummy_Handler

  .weak PIT1_IRQHandler
  .thumb_set PIT1_IRQHandler,Dummy_Handler

  .weak PIT2_IRQHandler
  .thumb_set PIT2_IRQHandler,Dummy_Handler

  .weak PIT3_IRQHandler
  .thumb_set PIT3_IRQHandler,Dummy_Handler

  .weak PDB0_IRQHandler
  .thumb_set PDB0_IRQHandler,Dummy_Handler

  .weak USB0_IRQHandler
  .thumb_set USB0_IRQHandler,Dummy_Handler

  .weak USBDCD_IRQHandler
  .thumb_set USBDCD_IRQHandler,Dummy_Handler

  .weak DAC0_IRQHandler
  .thumb_set DAC0_IRQHandler,Dummy_Handler

  .weak LPTMR0_IRQHandler
  .thumb_set LPTMR0_IRQHandler,Dummy_Handler

  .weak PORTA_IRQHandler
  .thumb_set PORTA_IRQHandler,Dummy_Handler

  .weak PORTB_IRQHandler
  .thumb_set PORTB_IRQHandler,Dummy_Handler

  .weak PORTC_IRQHandler
  .thumb_set PORTC_IRQHandler,Dummy_Handler

  .weak PORTD_IRQHandler
  .thumb_set PORTD_IRQHandler,Dummy_Handler

  .weak PORTE_IRQHandler
  .thumb_set PORTE_IRQHandler,Dummy_Handler

  .weak SPI2_IRQHandler
  .thumb_set SPI2_IRQHandler,Dummy_Handler

  .weak UART4_RX_TX_IRQHandler
  .thumb_set UART4_RX_TX_IRQHandler,Dummy_Handler

  .weak UART4_ERR_IRQHandler
  .thumb_set UART4_ERR_IRQHandler,Dummy_Handler

  .weak UART5_RX_TX_IRQHandler
  .thumb_set UART5_RX_TX_IRQHandler,Dummy_Handler

  .weak UART5_ERR_IRQHandler
  .thumb_set UART5_ERR_IRQHandler,Dummy_Handler

  .weak CMP2_IRQHandler
  .thumb_set CMP2_IRQHandler,Dummy_Handler

  .weak FTM3_IRQHandler
  .thumb_set FTM3_IRQHandler,Dummy_Handler

  .weak DAC1_IRQHandler
  .thumb_set DAC1_IRQHandler,Dummy_Handler

  .weak ADC1_IRQHandler
  .thumb_set ADC1_IRQHandler,Dummy_Handler

  .weak I2C2_IRQHandler
  .thumb_set I2C2_IRQHandler,Dummy_Handler

  .weak CAN0_ORed_Message_buffer_IRQHandler
  .thumb_set CAN0_ORed_Message_buffer_IRQHandler,Dummy_Handler

  .weak CAN0_Bus_Off_IRQHandler
  .thumb_set CAN0_Bus_Off_IRQHandler,Dummy_Handler

  .weak CAN0_Error_IRQHandler
  .thumb_set CAN0_Error_IRQHandler,Dummy_Handler

  .weak CAN0_Tx_Warning_IRQHandler
  .thumb_set CAN0_Tx_Warning_IRQHandler,Dummy_Handler

  .weak CAN0_Rx_Warning_IRQHandler
  .thumb_set CAN0_Rx_Warning_IRQHandler,Dummy_Handler

  .weak CAN0_Wake_Up_IRQHandler
  .thumb_set CAN0_Wake_Up_IRQHandler,Dummy_Handler

  .weak SDHC_IRQHandler
  .thumb_set SDHC_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak DMA0_IRQHandler
DMA0_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_IRQHandler
DMA1_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_IRQHandler
DMA2_IRQHandler:
  b .

  .thumb_func
  .weak DMA3_IRQHandler
DMA3_IRQHandler:
  b .

  .thumb_func
  .weak DMA4_IRQHandler
DMA4_IRQHandler:
  b .

  .thumb_func
  .weak DMA5_IRQHandler
DMA5_IRQHandler:
  b .

  .thumb_func
  .weak DMA6_IRQHandler
DMA6_IRQHandler:
  b .

  .thumb_func
  .weak DMA7_IRQHandler
DMA7_IRQHandler:
  b .

  .thumb_func
  .weak DMA8_IRQHandler
DMA8_IRQHandler:
  b .

  .thumb_func
  .weak DMA9_IRQHandler
DMA9_IRQHandler:
  b .

  .thumb_func
  .weak DMA10_IRQHandler
DMA10_IRQHandler:
  b .

  .thumb_func
  .weak DMA11_IRQHandler
DMA11_IRQHandler:
  b .

  .thumb_func
  .weak DMA12_IRQHandler
DMA12_IRQHandler:
  b .

  .thumb_func
  .weak DMA13_IRQHandler
DMA13_IRQHandler:
  b .

  .thumb_func
  .weak DMA14_IRQHandler
DMA14_IRQHandler:
  b .

  .thumb_func
  .weak DMA15_IRQHandler
DMA15_IRQHandler:
  b .

  .thumb_func
  .weak DMA_Error_IRQHandler
DMA_Error_IRQHandler:
  b .

  .thumb_func
  .weak FTFE_IRQHandler
FTFE_IRQHandler:
  b .

  .thumb_func
  .weak Read_Collision_IRQHandler
Read_Collision_IRQHandler:
  b .

  .thumb_func
  .weak LVD_LVW_IRQHandler
LVD_LVW_IRQHandler:
  b .

  .thumb_func
  .weak LLWU_IRQHandler
LLWU_IRQHandler:
  b .

  .thumb_func
  .weak WDOG_EWM_IRQHandler
WDOG_EWM_IRQHandler:
  b .

  .thumb_func
  .weak RNG_IRQHandler
RNG_IRQHandler:
  b .

  .thumb_func
  .weak I2C0_IRQHandler
I2C0_IRQHandler:
  b .

  .thumb_func
  .weak I2C1_IRQHandler
I2C1_IRQHandler:
  b .

  .thumb_func
  .weak SPI0_IRQHandler
SPI0_IRQHandler:
  b .

  .thumb_func
  .weak SPI1_IRQHandler
SPI1_IRQHandler:
  b .

  .thumb_func
  .weak I2S0_Tx_IRQHandler
I2S0_Tx_IRQHandler:
  b .

  .thumb_func
  .weak I2S0_Rx_IRQHandler
I2S0_Rx_IRQHandler:
  b .

  .thumb_func
  .weak UART0_RX_TX_IRQHandler
UART0_RX_TX_IRQHandler:
  b .

  .thumb_func
  .weak UART0_ERR_IRQHandler
UART0_ERR_IRQHandler:
  b .

  .thumb_func
  .weak UART1_RX_TX_IRQHandler
UART1_RX_TX_IRQHandler:
  b .

  .thumb_func
  .weak UART1_ERR_IRQHandler
UART1_ERR_IRQHandler:
  b .

  .thumb_func
  .weak UART2_RX_TX_IRQHandler
UART2_RX_TX_IRQHandler:
  b .

  .thumb_func
  .weak UART2_ERR_IRQHandler
UART2_ERR_IRQHandler:
  b .

  .thumb_func
  .weak UART3_RX_TX_IRQHandler
UART3_RX_TX_IRQHandler:
  b .

  .thumb_func
  .weak UART3_ERR_IRQHandler
UART3_ERR_IRQHandler:
  b .

  .thumb_func
  .weak ADC0_IRQHandler
ADC0_IRQHandler:
  b .

  .thumb_func
  .weak CMP0_IRQHandler
CMP0_IRQHandler:
  b .

  .thumb_func
  .weak CMP1_IRQHandler
CMP1_IRQHandler:
  b .

  .thumb_func
  .weak FTM0_IRQHandler
FTM0_IRQHandler:
  b .

  .thumb_func
  .weak FTM1_IRQHandler
FTM1_IRQHandler:
  b .

  .thumb_func
  .weak FTM2_IRQHandler
FTM2_IRQHandler:
  b .

  .thumb_func
  .weak CMT_IRQHandler
CMT_IRQHandler:
  b .

  .thumb_func
  .weak RTC_IRQHandler
RTC_IRQHandler:
  b .

  .thumb_func
  .weak RTC_Seconds_IRQHandler
RTC_Seconds_IRQHandler:
  b .

  .thumb_func
  .weak PIT0_IRQHandler
PIT0_IRQHandler:
  b .

  .thumb_func
  .weak PIT1_IRQHandler
PIT1_IRQHandler:
  b .

  .thumb_func
  .weak PIT2_IRQHandler
PIT2_IRQHandler:
  b .

  .thumb_func
  .weak PIT3_IRQHandler
PIT3_IRQHandler:
  b .

  .thumb_func
  .weak PDB0_IRQHandler
PDB0_IRQHandler:
  b .

  .thumb_func
  .weak USB0_IRQHandler
USB0_IRQHandler:
  b .

  .thumb_func
  .weak USBDCD_IRQHandler
USBDCD_IRQHandler:
  b .

  .thumb_func
  .weak DAC0_IRQHandler
DAC0_IRQHandler:
  b .

  .thumb_func
  .weak LPTMR0_IRQHandler
LPTMR0_IRQHandler:
  b .

  .thumb_func
  .weak PORTA_IRQHandler
PORTA_IRQHandler:
  b .

  .thumb_func
  .weak PORTB_IRQHandler
PORTB_IRQHandler:
  b .

  .thumb_func
  .weak PORTC_IRQHandler
PORTC_IRQHandler:
  b .

  .thumb_func
  .weak PORTD_IRQHandler
PORTD_IRQHandler:
  b .

  .thumb_func
  .weak PORTE_IRQHandler
PORTE_IRQHandler:
  b .

  .thumb_func
  .weak SPI2_IRQHandler
SPI2_IRQHandler:
  b .

  .thumb_func
  .weak UART4_RX_TX_IRQHandler
UART4_RX_TX_IRQHandler:
  b .

  .thumb_func
  .weak UART4_ERR_IRQHandler
UART4_ERR_IRQHandler:
  b .

  .thumb_func
  .weak UART5_RX_TX_IRQHandler
UART5_RX_TX_IRQHandler:
  b .

  .thumb_func
  .weak UART5_ERR_IRQHandler
UART5_ERR_IRQHandler:
  b .

  .thumb_func
  .weak CMP2_IRQHandler
CMP2_IRQHandler:
  b .

  .thumb_func
  .weak FTM3_IRQHandler
FTM3_IRQHandler:
  b .

  .thumb_func
  .weak DAC1_IRQHandler
DAC1_IRQHandler:
  b .

  .thumb_func
  .weak ADC1_IRQHandler
ADC1_IRQHandler:
  b .

  .thumb_func
  .weak I2C2_IRQHandler
I2C2_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_ORed_Message_buffer_IRQHandler
CAN0_ORed_Message_buffer_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_Bus_Off_IRQHandler
CAN0_Bus_Off_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_Error_IRQHandler
CAN0_Error_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_Tx_Warning_IRQHandler
CAN0_Tx_Warning_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_Rx_Warning_IRQHandler
CAN0_Rx_Warning_IRQHandler:
  b .

  .thumb_func
  .weak CAN0_Wake_Up_IRQHandler
CAN0_Wake_Up_IRQHandler:
  b .

  .thumb_func
  .weak SDHC_IRQHandler
SDHC_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .align 0
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word DMA0_IRQHandler
  .word DMA1_IRQHandler
  .word DMA2_IRQHandler
  .word DMA3_IRQHandler
  .word DMA4_IRQHandler
  .word DMA5_IRQHandler
  .word DMA6_IRQHandler
  .word DMA7_IRQHandler
  .word DMA8_IRQHandler
  .word DMA9_IRQHandler
  .word DMA10_IRQHandler
  .word DMA11_IRQHandler
  .word DMA12_IRQHandler
  .word DMA13_IRQHandler
  .word DMA14_IRQHandler
  .word DMA15_IRQHandler
  .word DMA_Error_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word FTFE_IRQHandler
  .word Read_Collision_IRQHandler
  .word LVD_LVW_IRQHandler
  .word LLWU_IRQHandler
  .word WDOG_EWM_IRQHandler
  .word RNG_IRQHandler
  .word I2C0_IRQHandler
  .word I2C1_IRQHandler
  .word SPI0_IRQHandler
  .word SPI1_IRQHandler
  .word I2S0_Tx_IRQHandler
  .word I2S0_Rx_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word UART0_RX_TX_IRQHandler
  .word UART0_ERR_IRQHandler
  .word UART1_RX_TX_IRQHandler
  .word UART1_ERR_IRQHandler
  .word UART2_RX_TX_IRQHandler
  .word UART2_ERR_IRQHandler
  .word UART3_RX_TX_IRQHandler
  .word UART3_ERR_IRQHandler
  .word ADC0_IRQHandler
  .word CMP0_IRQHandler
  .word CMP1_IRQHandler
  .word FTM0_IRQHandler
  .word FTM1_IRQHandler
  .word FTM2_IRQHandler
  .word CMT_IRQHandler
  .word RTC_IRQHandler
  .word RTC_Seconds_IRQHandler
  .word PIT0_IRQHandler
  .word PIT1_IRQHandler
  .word PIT2_IRQHandler
  .word PIT3_IRQHandler
  .word PDB0_IRQHandler
  .word USB0_IRQHandler
  .word USBDCD_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word DAC0_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word LPTMR0_IRQHandler
  .word PORTA_IRQHandler
  .word PORTB_IRQHandler
  .word PORTC_IRQHandler
  .word PORTD_IRQHandler
  .word PORTE_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word SPI2_IRQHandler
  .word UART4_RX_TX_IRQHandler
  .word UART4_ERR_IRQHandler
  .word UART5_RX_TX_IRQHandler
  .word UART5_ERR_IRQHandler
  .word CMP2_IRQHandler
  .word FTM3_IRQHandler
  .word DAC1_IRQHandler
  .word ADC1_IRQHandler
  .word I2C2_IRQHandler
  .word CAN0_ORed_Message_buffer_IRQHandler
  .word CAN0_Bus_Off_IRQHandler
  .word CAN0_Error_IRQHandler
  .word CAN0_Tx_Warning_IRQHandler
  .word CAN0_Rx_Warning_IRQHandler
  .word CAN0_Wake_Up_IRQHandler
  .word SDHC_IRQHandler
_vectors_end:

#if 1
  .section .vectors, "ax"
  // fill to 0x400 for the flash configuration field
  //.fill 0x400-(_vectors_end-_vectors), 1, 0xff
  .org 0x400, 0xFF
BackDoorKey:
  .byte 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff
#if defined(E_SERIES)
RESERVED:
  .byte 0xff, 0xff, 0xff, 0xff
EEPROT:
  .byte 0xff
FPROT:
  .byte 0xff
FSEC:
  .byte 0xfe
FOPT:
  .byte 0xff
#else
FPROT:
  .byte 0xff, 0xff, 0xff, 0xff
FSEC:
  .byte 0xfe
FOPT:
#if defined(MKL03Z4) || defined(MKL17Z4) || defined(MKL17Z644) || defined(MKL27Z4)  || defined(MKL27Z644) || defined(MKL33Z4) || defined(MKL33Z644) || defined(MKL43Z4)
  .byte 0x3b
#else 
  .byte 0xff
#endif
FEPROT:
  .byte 0xff
FDPROT:
  .byte 0xff
#endif
#endif

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .align 0
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
