/*********************************************************************
*                    SEGGER Microcontroller GmbH                     *
*                        The Embedded Experts                        *
**********************************************************************
*                                                                    *
*            (c) 2014 - 2020 SEGGER Microcontroller GmbH             *
*                                                                    *
*           www.segger.com     Support: support@segger.com           *
*                                                                    *
**********************************************************************
*                                                                    *
* All rights reserved.                                               *
*                                                                    *
* Redistribution and use in source and binary forms, with or         *
* without modification, are permitted provided that the following    *
* conditions are met:                                                *
*                                                                    *
* - Redistributions of source code must retain the above copyright   *
*   notice, this list of conditions and the following disclaimer.    *
*                                                                    *
* - Neither the name of SEGGER Microcontroller GmbH                  *
*   nor the names of its contributors may be used to endorse or      *
*   promote products derived from this software without specific     *
*   prior written permission.                                        *
*                                                                    *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND             *
* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,        *
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF           *
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE           *
* DISCLAIMED.                                                        *
* IN NO EVENT SHALL SEGGER Microcontroller GmbH BE LIABLE FOR        *
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR           *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT  *
* OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;    *
* OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      *
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT          *
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE  *
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH   *
* DAMAGE.                                                            *
*                                                                    *
*********************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 2

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak WDT0_IRQHandler
  .thumb_set WDT0_IRQHandler,Dummy_Handler

  .weak DMA0_IRQHandler
  .thumb_set DMA0_IRQHandler,Dummy_Handler

  .weak GPIO_INTA_IRQHandler
  .thumb_set GPIO_INTA_IRQHandler,Dummy_Handler

  .weak GPIO_INTB_IRQHandler
  .thumb_set GPIO_INTB_IRQHandler,Dummy_Handler

  .weak PIN_INT0_IRQHandler
  .thumb_set PIN_INT0_IRQHandler,Dummy_Handler

  .weak PIN_INT1_IRQHandler
  .thumb_set PIN_INT1_IRQHandler,Dummy_Handler

  .weak PIN_INT2_IRQHandler
  .thumb_set PIN_INT2_IRQHandler,Dummy_Handler

  .weak PIN_INT3_IRQHandler
  .thumb_set PIN_INT3_IRQHandler,Dummy_Handler

  .weak UTICK0_IRQHandler
  .thumb_set UTICK0_IRQHandler,Dummy_Handler

  .weak MRT0_IRQHandler
  .thumb_set MRT0_IRQHandler,Dummy_Handler

  .weak CTIMER0_IRQHandler
  .thumb_set CTIMER0_IRQHandler,Dummy_Handler

  .weak CTIMER1_IRQHandler
  .thumb_set CTIMER1_IRQHandler,Dummy_Handler

  .weak SCT0_IRQHandler
  .thumb_set SCT0_IRQHandler,Dummy_Handler

  .weak CTIMER3_IRQHandler
  .thumb_set CTIMER3_IRQHandler,Dummy_Handler

  .weak FLEXCOMM0_IRQHandler
  .thumb_set FLEXCOMM0_IRQHandler,Dummy_Handler

  .weak FLEXCOMM1_IRQHandler
  .thumb_set FLEXCOMM1_IRQHandler,Dummy_Handler

  .weak FLEXCOMM2_IRQHandler
  .thumb_set FLEXCOMM2_IRQHandler,Dummy_Handler

  .weak FLEXCOMM3_IRQHandler
  .thumb_set FLEXCOMM3_IRQHandler,Dummy_Handler

  .weak FLEXCOMM4_IRQHandler
  .thumb_set FLEXCOMM4_IRQHandler,Dummy_Handler

  .weak FLEXCOMM5_IRQHandler
  .thumb_set FLEXCOMM5_IRQHandler,Dummy_Handler

  .weak FLEXCOMM14_IRQHandler
  .thumb_set FLEXCOMM14_IRQHandler,Dummy_Handler

  .weak FLEXCOMM15_IRQHandler
  .thumb_set FLEXCOMM15_IRQHandler,Dummy_Handler

  .weak ADC0_IRQHandler
  .thumb_set ADC0_IRQHandler,Dummy_Handler

  .weak ACMP_IRQHandler
  .thumb_set ACMP_IRQHandler,Dummy_Handler

  .weak DMIC0_IRQHandler
  .thumb_set DMIC0_IRQHandler,Dummy_Handler

  .weak HYPERVISOR_IRQHandler
  .thumb_set HYPERVISOR_IRQHandler,Dummy_Handler

  .weak SECUREVIOLATION_IRQHandler
  .thumb_set SECUREVIOLATION_IRQHandler,Dummy_Handler

  .weak HWVAD0_IRQHandler
  .thumb_set HWVAD0_IRQHandler,Dummy_Handler

  .weak RNG_IRQHandler
  .thumb_set RNG_IRQHandler,Dummy_Handler

  .weak RTC_IRQHandler
  .thumb_set RTC_IRQHandler,Dummy_Handler

  .weak DSPWAKE_IRQHandler
  .thumb_set DSPWAKE_IRQHandler,Dummy_Handler

  .weak MU_A_IRQHandler
  .thumb_set MU_A_IRQHandler,Dummy_Handler

  .weak PIN_INT4_IRQHandler
  .thumb_set PIN_INT4_IRQHandler,Dummy_Handler

  .weak PIN_INT5_IRQHandler
  .thumb_set PIN_INT5_IRQHandler,Dummy_Handler

  .weak PIN_INT6_IRQHandler
  .thumb_set PIN_INT6_IRQHandler,Dummy_Handler

  .weak PIN_INT7_IRQHandler
  .thumb_set PIN_INT7_IRQHandler,Dummy_Handler

  .weak CTIMER2_IRQHandler
  .thumb_set CTIMER2_IRQHandler,Dummy_Handler

  .weak CTIMER4_IRQHandler
  .thumb_set CTIMER4_IRQHandler,Dummy_Handler

  .weak OS_EVENT_IRQHandler
  .thumb_set OS_EVENT_IRQHandler,Dummy_Handler

  .weak FLEXSPI_IRQHandler
  .thumb_set FLEXSPI_IRQHandler,Dummy_Handler

  .weak FLEXCOMM6_IRQHandler
  .thumb_set FLEXCOMM6_IRQHandler,Dummy_Handler

  .weak FLEXCOMM7_IRQHandler
  .thumb_set FLEXCOMM7_IRQHandler,Dummy_Handler

  .weak USDHC0_IRQHandler
  .thumb_set USDHC0_IRQHandler,Dummy_Handler

  .weak USDHC1_IRQHandler
  .thumb_set USDHC1_IRQHandler,Dummy_Handler

  .weak SGPIO_INTA_IRQHandler
  .thumb_set SGPIO_INTA_IRQHandler,Dummy_Handler

  .weak SGPIO_INTB_IRQHandler
  .thumb_set SGPIO_INTB_IRQHandler,Dummy_Handler

  .weak I3C0_IRQHandler
  .thumb_set I3C0_IRQHandler,Dummy_Handler

  .weak USB_IRQHandler
  .thumb_set USB_IRQHandler,Dummy_Handler

  .weak USB_WAKEUP_IRQHandler
  .thumb_set USB_WAKEUP_IRQHandler,Dummy_Handler

  .weak WDT1_IRQHandler
  .thumb_set WDT1_IRQHandler,Dummy_Handler

  .weak USBPHY_DCD_IRQHandler
  .thumb_set USBPHY_DCD_IRQHandler,Dummy_Handler

  .weak DMA1_IRQHandler
  .thumb_set DMA1_IRQHandler,Dummy_Handler

  .weak PUF_IRQHandler
  .thumb_set PUF_IRQHandler,Dummy_Handler

  .weak POWERQUAD_IRQHandler
  .thumb_set POWERQUAD_IRQHandler,Dummy_Handler

  .weak CASPER_IRQHandler
  .thumb_set CASPER_IRQHandler,Dummy_Handler

  .weak PMC_PMIC_IRQHandler
  .thumb_set PMC_PMIC_IRQHandler,Dummy_Handler

  .weak HASHCRYPT_IRQHandler
  .thumb_set HASHCRYPT_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak WDT0_IRQHandler
WDT0_IRQHandler:
  b .

  .thumb_func
  .weak DMA0_IRQHandler
DMA0_IRQHandler:
  b .

  .thumb_func
  .weak GPIO_INTA_IRQHandler
GPIO_INTA_IRQHandler:
  b .

  .thumb_func
  .weak GPIO_INTB_IRQHandler
GPIO_INTB_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT0_IRQHandler
PIN_INT0_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT1_IRQHandler
PIN_INT1_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT2_IRQHandler
PIN_INT2_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT3_IRQHandler
PIN_INT3_IRQHandler:
  b .

  .thumb_func
  .weak UTICK0_IRQHandler
UTICK0_IRQHandler:
  b .

  .thumb_func
  .weak MRT0_IRQHandler
MRT0_IRQHandler:
  b .

  .thumb_func
  .weak CTIMER0_IRQHandler
CTIMER0_IRQHandler:
  b .

  .thumb_func
  .weak CTIMER1_IRQHandler
CTIMER1_IRQHandler:
  b .

  .thumb_func
  .weak SCT0_IRQHandler
SCT0_IRQHandler:
  b .

  .thumb_func
  .weak CTIMER3_IRQHandler
CTIMER3_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM0_IRQHandler
FLEXCOMM0_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM1_IRQHandler
FLEXCOMM1_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM2_IRQHandler
FLEXCOMM2_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM3_IRQHandler
FLEXCOMM3_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM4_IRQHandler
FLEXCOMM4_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM5_IRQHandler
FLEXCOMM5_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM14_IRQHandler
FLEXCOMM14_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM15_IRQHandler
FLEXCOMM15_IRQHandler:
  b .

  .thumb_func
  .weak ADC0_IRQHandler
ADC0_IRQHandler:
  b .

  .thumb_func
  .weak ACMP_IRQHandler
ACMP_IRQHandler:
  b .

  .thumb_func
  .weak DMIC0_IRQHandler
DMIC0_IRQHandler:
  b .

  .thumb_func
  .weak HYPERVISOR_IRQHandler
HYPERVISOR_IRQHandler:
  b .

  .thumb_func
  .weak SECUREVIOLATION_IRQHandler
SECUREVIOLATION_IRQHandler:
  b .

  .thumb_func
  .weak HWVAD0_IRQHandler
HWVAD0_IRQHandler:
  b .

  .thumb_func
  .weak RNG_IRQHandler
RNG_IRQHandler:
  b .

  .thumb_func
  .weak RTC_IRQHandler
RTC_IRQHandler:
  b .

  .thumb_func
  .weak DSPWAKE_IRQHandler
DSPWAKE_IRQHandler:
  b .

  .thumb_func
  .weak MU_A_IRQHandler
MU_A_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT4_IRQHandler
PIN_INT4_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT5_IRQHandler
PIN_INT5_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT6_IRQHandler
PIN_INT6_IRQHandler:
  b .

  .thumb_func
  .weak PIN_INT7_IRQHandler
PIN_INT7_IRQHandler:
  b .

  .thumb_func
  .weak CTIMER2_IRQHandler
CTIMER2_IRQHandler:
  b .

  .thumb_func
  .weak CTIMER4_IRQHandler
CTIMER4_IRQHandler:
  b .

  .thumb_func
  .weak OS_EVENT_IRQHandler
OS_EVENT_IRQHandler:
  b .

  .thumb_func
  .weak FLEXSPI_IRQHandler
FLEXSPI_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM6_IRQHandler
FLEXCOMM6_IRQHandler:
  b .

  .thumb_func
  .weak FLEXCOMM7_IRQHandler
FLEXCOMM7_IRQHandler:
  b .

  .thumb_func
  .weak USDHC0_IRQHandler
USDHC0_IRQHandler:
  b .

  .thumb_func
  .weak USDHC1_IRQHandler
USDHC1_IRQHandler:
  b .

  .thumb_func
  .weak SGPIO_INTA_IRQHandler
SGPIO_INTA_IRQHandler:
  b .

  .thumb_func
  .weak SGPIO_INTB_IRQHandler
SGPIO_INTB_IRQHandler:
  b .

  .thumb_func
  .weak I3C0_IRQHandler
I3C0_IRQHandler:
  b .

  .thumb_func
  .weak USB_IRQHandler
USB_IRQHandler:
  b .

  .thumb_func
  .weak USB_WAKEUP_IRQHandler
USB_WAKEUP_IRQHandler:
  b .

  .thumb_func
  .weak WDT1_IRQHandler
WDT1_IRQHandler:
  b .

  .thumb_func
  .weak USBPHY_DCD_IRQHandler
USBPHY_DCD_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_IRQHandler
DMA1_IRQHandler:
  b .

  .thumb_func
  .weak PUF_IRQHandler
PUF_IRQHandler:
  b .

  .thumb_func
  .weak POWERQUAD_IRQHandler
POWERQUAD_IRQHandler:
  b .

  .thumb_func
  .weak CASPER_IRQHandler
CASPER_IRQHandler:
  b .

  .thumb_func
  .weak PMC_PMIC_IRQHandler
PMC_PMIC_IRQHandler:
  b .

  .thumb_func
  .weak HASHCRYPT_IRQHandler
HASHCRYPT_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .balign 512
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word WDT0_IRQHandler
  .word DMA0_IRQHandler
  .word GPIO_INTA_IRQHandler
  .word GPIO_INTB_IRQHandler
  .word PIN_INT0_IRQHandler
  .word PIN_INT1_IRQHandler
  .word PIN_INT2_IRQHandler
  .word PIN_INT3_IRQHandler
  .word UTICK0_IRQHandler
  .word MRT0_IRQHandler
  .word CTIMER0_IRQHandler
  .word CTIMER1_IRQHandler
  .word SCT0_IRQHandler
  .word CTIMER3_IRQHandler
  .word FLEXCOMM0_IRQHandler
  .word FLEXCOMM1_IRQHandler
  .word FLEXCOMM2_IRQHandler
  .word FLEXCOMM3_IRQHandler
  .word FLEXCOMM4_IRQHandler
  .word FLEXCOMM5_IRQHandler
  .word FLEXCOMM14_IRQHandler
  .word FLEXCOMM15_IRQHandler
  .word ADC0_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word ACMP_IRQHandler
  .word DMIC0_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word HYPERVISOR_IRQHandler
  .word SECUREVIOLATION_IRQHandler
  .word HWVAD0_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word RNG_IRQHandler
  .word RTC_IRQHandler
  .word DSPWAKE_IRQHandler
  .word MU_A_IRQHandler
  .word PIN_INT4_IRQHandler
  .word PIN_INT5_IRQHandler
  .word PIN_INT6_IRQHandler
  .word PIN_INT7_IRQHandler
  .word CTIMER2_IRQHandler
  .word CTIMER4_IRQHandler
  .word OS_EVENT_IRQHandler
  .word FLEXSPI_IRQHandler
  .word FLEXCOMM6_IRQHandler
  .word FLEXCOMM7_IRQHandler
  .word USDHC0_IRQHandler
  .word USDHC1_IRQHandler
  .word SGPIO_INTA_IRQHandler
  .word SGPIO_INTB_IRQHandler
  .word I3C0_IRQHandler
  .word USB_IRQHandler
  .word USB_WAKEUP_IRQHandler
  .word WDT1_IRQHandler
  .word USBPHY_DCD_IRQHandler
  .word DMA1_IRQHandler
  .word PUF_IRQHandler
  .word POWERQUAD_IRQHandler
  .word CASPER_IRQHandler
  .word PMC_PMIC_IRQHandler
  .word HASHCRYPT_IRQHandler
_vectors_end:

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .balign 512
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
