/*****************************************************************************
 *                   SEGGER Microcontroller GmbH & Co. KG                    *
 *            Solutions for real time microcontroller applications           *
 *****************************************************************************
 *                                                                           *
 *               (c) 2017 SEGGER Microcontroller GmbH & Co. KG               *
 *                                                                           *
 *           Internet: www.segger.com   Support: support@segger.com          *
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 0

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak INT0_IRQHandler
  .thumb_set INT0_IRQHandler,Dummy_Handler

  .weak INT1_IRQHandler
  .thumb_set INT1_IRQHandler,Dummy_Handler

  .weak INT2_IRQHandler
  .thumb_set INT2_IRQHandler,Dummy_Handler

  .weak INT3_IRQHandler
  .thumb_set INT3_IRQHandler,Dummy_Handler

  .weak INT4_IRQHandler
  .thumb_set INT4_IRQHandler,Dummy_Handler

  .weak INT5_IRQHandler
  .thumb_set INT5_IRQHandler,Dummy_Handler

  .weak INT6_IRQHandler
  .thumb_set INT6_IRQHandler,Dummy_Handler

  .weak INT7_IRQHandler
  .thumb_set INT7_IRQHandler,Dummy_Handler

  .weak INT8_IRQHandler
  .thumb_set INT8_IRQHandler,Dummy_Handler

  .weak INT9_IRQHandler
  .thumb_set INT9_IRQHandler,Dummy_Handler

  .weak INTA_IRQHandler
  .thumb_set INTA_IRQHandler,Dummy_Handler

  .weak INTB_IRQHandler
  .thumb_set INTB_IRQHandler,Dummy_Handler

  .weak INTC_IRQHandler
  .thumb_set INTC_IRQHandler,Dummy_Handler

  .weak INTD_IRQHandler
  .thumb_set INTD_IRQHandler,Dummy_Handler

  .weak INTE_IRQHandler
  .thumb_set INTE_IRQHandler,Dummy_Handler

  .weak INTF_IRQHandler
  .thumb_set INTF_IRQHandler,Dummy_Handler

  .weak INT10_IRQHandler
  .thumb_set INT10_IRQHandler,Dummy_Handler

  .weak INT11_IRQHandler
  .thumb_set INT11_IRQHandler,Dummy_Handler

  .weak INT12_IRQHandler
  .thumb_set INT12_IRQHandler,Dummy_Handler

  .weak INT13_IRQHandler
  .thumb_set INT13_IRQHandler,Dummy_Handler

  .weak INT14_IRQHandler
  .thumb_set INT14_IRQHandler,Dummy_Handler

  .weak INT15_IRQHandler
  .thumb_set INT15_IRQHandler,Dummy_Handler

  .weak INTKWUPA_IRQHandler
  .thumb_set INTKWUPA_IRQHandler,Dummy_Handler

  .weak INTKWUPB_IRQHandler
  .thumb_set INTKWUPB_IRQHandler,Dummy_Handler

  .weak INTKSCAN_IRQHandler
  .thumb_set INTKSCAN_IRQHandler,Dummy_Handler

  .weak INTRTC_IRQHandler
  .thumb_set INTRTC_IRQHandler,Dummy_Handler

  .weak INT16_IRQHandler
  .thumb_set INT16_IRQHandler,Dummy_Handler

  .weak INT17_IRQHandler
  .thumb_set INT17_IRQHandler,Dummy_Handler

  .weak INTPSCSTOP_IRQHandler
  .thumb_set INTPSCSTOP_IRQHandler,Dummy_Handler

  .weak INTPSCBRK_IRQHandler
  .thumb_set INTPSCBRK_IRQHandler,Dummy_Handler

  .weak INTPSCSTEP_IRQHandler
  .thumb_set INTPSCSTEP_IRQHandler,Dummy_Handler

  .weak INTPSCII_IRQHandler
  .thumb_set INTPSCII_IRQHandler,Dummy_Handler

  .weak INTPSCIA_IRQHandler
  .thumb_set INTPSCIA_IRQHandler,Dummy_Handler

  .weak INTE0RX_IRQHandler
  .thumb_set INTE0RX_IRQHandler,Dummy_Handler

  .weak INTE0TX_IRQHandler
  .thumb_set INTE0TX_IRQHandler,Dummy_Handler

  .weak INTE0ERR_IRQHandler
  .thumb_set INTE0ERR_IRQHandler,Dummy_Handler

  .weak INTE1RX_IRQHandler
  .thumb_set INTE1RX_IRQHandler,Dummy_Handler

  .weak INTE1TX_IRQHandler
  .thumb_set INTE1TX_IRQHandler,Dummy_Handler

  .weak INTE1ERR_IRQHandler
  .thumb_set INTE1ERR_IRQHandler,Dummy_Handler

  .weak INTE2RX_IRQHandler
  .thumb_set INTE2RX_IRQHandler,Dummy_Handler

  .weak INTE2TX_IRQHandler
  .thumb_set INTE2TX_IRQHandler,Dummy_Handler

  .weak INTE2ERR_IRQHandler
  .thumb_set INTE2ERR_IRQHandler,Dummy_Handler

  .weak INTRX0_IRQHandler
  .thumb_set INTRX0_IRQHandler,Dummy_Handler

  .weak INTTX0_IRQHandler
  .thumb_set INTTX0_IRQHandler,Dummy_Handler

  .weak INTRX1_IRQHandler
  .thumb_set INTRX1_IRQHandler,Dummy_Handler

  .weak INTTX1_IRQHandler
  .thumb_set INTTX1_IRQHandler,Dummy_Handler

  .weak INTRX2_IRQHandler
  .thumb_set INTRX2_IRQHandler,Dummy_Handler

  .weak INTTX2_IRQHandler
  .thumb_set INTTX2_IRQHandler,Dummy_Handler

  .weak INTRX3_IRQHandler
  .thumb_set INTRX3_IRQHandler,Dummy_Handler

  .weak INTTX3_IRQHandler
  .thumb_set INTTX3_IRQHandler,Dummy_Handler

  .weak INTRX4_IRQHandler
  .thumb_set INTRX4_IRQHandler,Dummy_Handler

  .weak INTTX4_IRQHandler
  .thumb_set INTTX4_IRQHandler,Dummy_Handler

  .weak INTRX5_IRQHandler
  .thumb_set INTRX5_IRQHandler,Dummy_Handler

  .weak INTTX5_IRQHandler
  .thumb_set INTTX5_IRQHandler,Dummy_Handler

  .weak INTUART0_IRQHandler
  .thumb_set INTUART0_IRQHandler,Dummy_Handler

  .weak INTUART1_IRQHandler
  .thumb_set INTUART1_IRQHandler,Dummy_Handler

  .weak INTI2C_IRQHandler
  .thumb_set INTI2C_IRQHandler,Dummy_Handler

  .weak INTADA_IRQHandler
  .thumb_set INTADA_IRQHandler,Dummy_Handler

  .weak INTADB_IRQHandler
  .thumb_set INTADB_IRQHandler,Dummy_Handler

  .weak INTADC_IRQHandler
  .thumb_set INTADC_IRQHandler,Dummy_Handler

  .weak INTTB00_IRQHandler
  .thumb_set INTTB00_IRQHandler,Dummy_Handler

  .weak INTTB01_IRQHandler
  .thumb_set INTTB01_IRQHandler,Dummy_Handler

  .weak INTTB02_IRQHandler
  .thumb_set INTTB02_IRQHandler,Dummy_Handler

  .weak INTTB03_IRQHandler
  .thumb_set INTTB03_IRQHandler,Dummy_Handler

  .weak INTTB04_IRQHandler
  .thumb_set INTTB04_IRQHandler,Dummy_Handler

  .weak INTTB05_IRQHandler
  .thumb_set INTTB05_IRQHandler,Dummy_Handler

  .weak INTTB06_IRQHandler
  .thumb_set INTTB06_IRQHandler,Dummy_Handler

  .weak INTTB07_IRQHandler
  .thumb_set INTTB07_IRQHandler,Dummy_Handler

  .weak INTTB08_IRQHandler
  .thumb_set INTTB08_IRQHandler,Dummy_Handler

  .weak INTTB09_IRQHandler
  .thumb_set INTTB09_IRQHandler,Dummy_Handler

  .weak INTTB10_IRQHandler
  .thumb_set INTTB10_IRQHandler,Dummy_Handler

  .weak INTTB11_IRQHandler
  .thumb_set INTTB11_IRQHandler,Dummy_Handler

  .weak INTTB12_IRQHandler
  .thumb_set INTTB12_IRQHandler,Dummy_Handler

  .weak INTTB13_IRQHandler
  .thumb_set INTTB13_IRQHandler,Dummy_Handler

  .weak INTTB14_IRQHandler
  .thumb_set INTTB14_IRQHandler,Dummy_Handler

  .weak INTTB15_IRQHandler
  .thumb_set INTTB15_IRQHandler,Dummy_Handler

  .weak INTTB16_IRQHandler
  .thumb_set INTTB16_IRQHandler,Dummy_Handler

  .weak INTTB17_IRQHandler
  .thumb_set INTTB17_IRQHandler,Dummy_Handler

  .weak INTTB18_IRQHandler
  .thumb_set INTTB18_IRQHandler,Dummy_Handler

  .weak INTTB19_IRQHandler
  .thumb_set INTTB19_IRQHandler,Dummy_Handler

  .weak INTTCCMP0_IRQHandler
  .thumb_set INTTCCMP0_IRQHandler,Dummy_Handler

  .weak INTTCCMP1_IRQHandler
  .thumb_set INTTCCMP1_IRQHandler,Dummy_Handler

  .weak INTTCCMP2_IRQHandler
  .thumb_set INTTCCMP2_IRQHandler,Dummy_Handler

  .weak INTTCCMP3_IRQHandler
  .thumb_set INTTCCMP3_IRQHandler,Dummy_Handler

  .weak INTTCCMP4_IRQHandler
  .thumb_set INTTCCMP4_IRQHandler,Dummy_Handler

  .weak INTTCCMP5_IRQHandler
  .thumb_set INTTCCMP5_IRQHandler,Dummy_Handler

  .weak INTTCCMP6_IRQHandler
  .thumb_set INTTCCMP6_IRQHandler,Dummy_Handler

  .weak INTTCCMP7_IRQHandler
  .thumb_set INTTCCMP7_IRQHandler,Dummy_Handler

  .weak INTTCCAP0_IRQHandler
  .thumb_set INTTCCAP0_IRQHandler,Dummy_Handler

  .weak INTTCCAP1_IRQHandler
  .thumb_set INTTCCAP1_IRQHandler,Dummy_Handler

  .weak INTTCCAP2_IRQHandler
  .thumb_set INTTCCAP2_IRQHandler,Dummy_Handler

  .weak INTTCCAP3_IRQHandler
  .thumb_set INTTCCAP3_IRQHandler,Dummy_Handler

  .weak INTPHC00_IRQHandler
  .thumb_set INTPHC00_IRQHandler,Dummy_Handler

  .weak INTPHC01_IRQHandler
  .thumb_set INTPHC01_IRQHandler,Dummy_Handler

  .weak INTPHC0EVRY_IRQHandler
  .thumb_set INTPHC0EVRY_IRQHandler,Dummy_Handler

  .weak INTPHC10_IRQHandler
  .thumb_set INTPHC10_IRQHandler,Dummy_Handler

  .weak INTPHC11_IRQHandler
  .thumb_set INTPHC11_IRQHandler,Dummy_Handler

  .weak INTPHC1EVRY_IRQHandler
  .thumb_set INTPHC1EVRY_IRQHandler,Dummy_Handler

  .weak INTEPHC_IRQHandler
  .thumb_set INTEPHC_IRQHandler,Dummy_Handler

  .weak INTPHCPOVF_IRQHandler
  .thumb_set INTPHCPOVF_IRQHandler,Dummy_Handler

  .weak INTPHCPPHE_IRQHandler
  .thumb_set INTPHCPPHE_IRQHandler,Dummy_Handler

  .weak INTPHCPCY0_IRQHandler
  .thumb_set INTPHCPCY0_IRQHandler,Dummy_Handler

  .weak INTPHCPCY1_IRQHandler
  .thumb_set INTPHCPCY1_IRQHandler,Dummy_Handler

  .weak INTPHCPCY2_IRQHandler
  .thumb_set INTPHCPCY2_IRQHandler,Dummy_Handler

  .weak INTPHCPCY3_IRQHandler
  .thumb_set INTPHCPCY3_IRQHandler,Dummy_Handler

  .weak INTTD0CMP0_IRQHandler
  .thumb_set INTTD0CMP0_IRQHandler,Dummy_Handler

  .weak INTTD0CMP1_IRQHandler
  .thumb_set INTTD0CMP1_IRQHandler,Dummy_Handler

  .weak INTTD0CMP2_IRQHandler
  .thumb_set INTTD0CMP2_IRQHandler,Dummy_Handler

  .weak INTTD0CMP3_IRQHandler
  .thumb_set INTTD0CMP3_IRQHandler,Dummy_Handler

  .weak INTTD0CMP4_IRQHandler
  .thumb_set INTTD0CMP4_IRQHandler,Dummy_Handler

  .weak INTTD1CMP0_IRQHandler
  .thumb_set INTTD1CMP0_IRQHandler,Dummy_Handler

  .weak INTTD1CMP1_IRQHandler
  .thumb_set INTTD1CMP1_IRQHandler,Dummy_Handler

  .weak INTTD1CMP2_IRQHandler
  .thumb_set INTTD1CMP2_IRQHandler,Dummy_Handler

  .weak INTTD1CMP3_IRQHandler
  .thumb_set INTTD1CMP3_IRQHandler,Dummy_Handler

  .weak INTTD1CMP4_IRQHandler
  .thumb_set INTTD1CMP4_IRQHandler,Dummy_Handler

  .weak INTADAHP_IRQHandler
  .thumb_set INTADAHP_IRQHandler,Dummy_Handler

  .weak INTADBHP_IRQHandler
  .thumb_set INTADBHP_IRQHandler,Dummy_Handler

  .weak INTADCHP_IRQHandler
  .thumb_set INTADCHP_IRQHandler,Dummy_Handler

  .weak INTTB07CAP0_IRQHandler
  .thumb_set INTTB07CAP0_IRQHandler,Dummy_Handler

  .weak INTTB07CAP1_IRQHandler
  .thumb_set INTTB07CAP1_IRQHandler,Dummy_Handler

  .weak INTTB08CAP0_IRQHandler
  .thumb_set INTTB08CAP0_IRQHandler,Dummy_Handler

  .weak INTTB08CAP1_IRQHandler
  .thumb_set INTTB08CAP1_IRQHandler,Dummy_Handler

  .weak INTTB09CAP0_IRQHandler
  .thumb_set INTTB09CAP0_IRQHandler,Dummy_Handler

  .weak INTTB09CAP1_IRQHandler
  .thumb_set INTTB09CAP1_IRQHandler,Dummy_Handler

  .weak INTTB10CAP0_IRQHandler
  .thumb_set INTTB10CAP0_IRQHandler,Dummy_Handler

  .weak INTTB10CAP1_IRQHandler
  .thumb_set INTTB10CAP1_IRQHandler,Dummy_Handler

  .weak INTTB11CAP0_IRQHandler
  .thumb_set INTTB11CAP0_IRQHandler,Dummy_Handler

  .weak INTTB11CAP1_IRQHandler
  .thumb_set INTTB11CAP1_IRQHandler,Dummy_Handler

  .weak INTTB12CAP0_IRQHandler
  .thumb_set INTTB12CAP0_IRQHandler,Dummy_Handler

  .weak INTTB12CAP1_IRQHandler
  .thumb_set INTTB12CAP1_IRQHandler,Dummy_Handler

  .weak INTTB13CAP0_IRQHandler
  .thumb_set INTTB13CAP0_IRQHandler,Dummy_Handler

  .weak INTTB13CAP1_IRQHandler
  .thumb_set INTTB13CAP1_IRQHandler,Dummy_Handler

  .weak INTTB14CAP0_IRQHandler
  .thumb_set INTTB14CAP0_IRQHandler,Dummy_Handler

  .weak INTTB14CAP1_IRQHandler
  .thumb_set INTTB14CAP1_IRQHandler,Dummy_Handler

  .weak INTTB15CAP0_IRQHandler
  .thumb_set INTTB15CAP0_IRQHandler,Dummy_Handler

  .weak INTTB15CAP1_IRQHandler
  .thumb_set INTTB15CAP1_IRQHandler,Dummy_Handler

  .weak INTTB16CAP0_IRQHandler
  .thumb_set INTTB16CAP0_IRQHandler,Dummy_Handler

  .weak INTTB16CAP1_IRQHandler
  .thumb_set INTTB16CAP1_IRQHandler,Dummy_Handler

  .weak INTTB17CAP0_IRQHandler
  .thumb_set INTTB17CAP0_IRQHandler,Dummy_Handler

  .weak INTTB17CAP1_IRQHandler
  .thumb_set INTTB17CAP1_IRQHandler,Dummy_Handler

  .weak INTTB18CAP0_IRQHandler
  .thumb_set INTTB18CAP0_IRQHandler,Dummy_Handler

  .weak INTTB18CAP1_IRQHandler
  .thumb_set INTTB18CAP1_IRQHandler,Dummy_Handler

  .weak INTTB19CAP0_IRQHandler
  .thumb_set INTTB19CAP0_IRQHandler,Dummy_Handler

  .weak INTTB19CAP1_IRQHandler
  .thumb_set INTTB19CAP1_IRQHandler,Dummy_Handler

  .weak INTADAM0_IRQHandler
  .thumb_set INTADAM0_IRQHandler,Dummy_Handler

  .weak INTADAM1_IRQHandler
  .thumb_set INTADAM1_IRQHandler,Dummy_Handler

  .weak INTADBM0_IRQHandler
  .thumb_set INTADBM0_IRQHandler,Dummy_Handler

  .weak INTADBM1_IRQHandler
  .thumb_set INTADBM1_IRQHandler,Dummy_Handler

  .weak INTADCM0_IRQHandler
  .thumb_set INTADCM0_IRQHandler,Dummy_Handler

  .weak INTADCM1_IRQHandler
  .thumb_set INTADCM1_IRQHandler,Dummy_Handler

  .weak INTDMACATC_IRQHandler
  .thumb_set INTDMACATC_IRQHandler,Dummy_Handler

  .weak INTDMACAERR_IRQHandler
  .thumb_set INTDMACAERR_IRQHandler,Dummy_Handler

  .weak INTDMACBTC_IRQHandler
  .thumb_set INTDMACBTC_IRQHandler,Dummy_Handler

  .weak INTDMACBERR_IRQHandler
  .thumb_set INTDMACBERR_IRQHandler,Dummy_Handler

  .weak INTDMACCTC_IRQHandler
  .thumb_set INTDMACCTC_IRQHandler,Dummy_Handler

  .weak INTDMACCERR_IRQHandler
  .thumb_set INTDMACCERR_IRQHandler,Dummy_Handler

  .weak INTTCTBT_IRQHandler
  .thumb_set INTTCTBT_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak INT0_IRQHandler
INT0_IRQHandler:
  b .

  .thumb_func
  .weak INT1_IRQHandler
INT1_IRQHandler:
  b .

  .thumb_func
  .weak INT2_IRQHandler
INT2_IRQHandler:
  b .

  .thumb_func
  .weak INT3_IRQHandler
INT3_IRQHandler:
  b .

  .thumb_func
  .weak INT4_IRQHandler
INT4_IRQHandler:
  b .

  .thumb_func
  .weak INT5_IRQHandler
INT5_IRQHandler:
  b .

  .thumb_func
  .weak INT6_IRQHandler
INT6_IRQHandler:
  b .

  .thumb_func
  .weak INT7_IRQHandler
INT7_IRQHandler:
  b .

  .thumb_func
  .weak INT8_IRQHandler
INT8_IRQHandler:
  b .

  .thumb_func
  .weak INT9_IRQHandler
INT9_IRQHandler:
  b .

  .thumb_func
  .weak INTA_IRQHandler
INTA_IRQHandler:
  b .

  .thumb_func
  .weak INTB_IRQHandler
INTB_IRQHandler:
  b .

  .thumb_func
  .weak INTC_IRQHandler
INTC_IRQHandler:
  b .

  .thumb_func
  .weak INTD_IRQHandler
INTD_IRQHandler:
  b .

  .thumb_func
  .weak INTE_IRQHandler
INTE_IRQHandler:
  b .

  .thumb_func
  .weak INTF_IRQHandler
INTF_IRQHandler:
  b .

  .thumb_func
  .weak INT10_IRQHandler
INT10_IRQHandler:
  b .

  .thumb_func
  .weak INT11_IRQHandler
INT11_IRQHandler:
  b .

  .thumb_func
  .weak INT12_IRQHandler
INT12_IRQHandler:
  b .

  .thumb_func
  .weak INT13_IRQHandler
INT13_IRQHandler:
  b .

  .thumb_func
  .weak INT14_IRQHandler
INT14_IRQHandler:
  b .

  .thumb_func
  .weak INT15_IRQHandler
INT15_IRQHandler:
  b .

  .thumb_func
  .weak INTKWUPA_IRQHandler
INTKWUPA_IRQHandler:
  b .

  .thumb_func
  .weak INTKWUPB_IRQHandler
INTKWUPB_IRQHandler:
  b .

  .thumb_func
  .weak INTKSCAN_IRQHandler
INTKSCAN_IRQHandler:
  b .

  .thumb_func
  .weak INTRTC_IRQHandler
INTRTC_IRQHandler:
  b .

  .thumb_func
  .weak INT16_IRQHandler
INT16_IRQHandler:
  b .

  .thumb_func
  .weak INT17_IRQHandler
INT17_IRQHandler:
  b .

  .thumb_func
  .weak INTPSCSTOP_IRQHandler
INTPSCSTOP_IRQHandler:
  b .

  .thumb_func
  .weak INTPSCBRK_IRQHandler
INTPSCBRK_IRQHandler:
  b .

  .thumb_func
  .weak INTPSCSTEP_IRQHandler
INTPSCSTEP_IRQHandler:
  b .

  .thumb_func
  .weak INTPSCII_IRQHandler
INTPSCII_IRQHandler:
  b .

  .thumb_func
  .weak INTPSCIA_IRQHandler
INTPSCIA_IRQHandler:
  b .

  .thumb_func
  .weak INTE0RX_IRQHandler
INTE0RX_IRQHandler:
  b .

  .thumb_func
  .weak INTE0TX_IRQHandler
INTE0TX_IRQHandler:
  b .

  .thumb_func
  .weak INTE0ERR_IRQHandler
INTE0ERR_IRQHandler:
  b .

  .thumb_func
  .weak INTE1RX_IRQHandler
INTE1RX_IRQHandler:
  b .

  .thumb_func
  .weak INTE1TX_IRQHandler
INTE1TX_IRQHandler:
  b .

  .thumb_func
  .weak INTE1ERR_IRQHandler
INTE1ERR_IRQHandler:
  b .

  .thumb_func
  .weak INTE2RX_IRQHandler
INTE2RX_IRQHandler:
  b .

  .thumb_func
  .weak INTE2TX_IRQHandler
INTE2TX_IRQHandler:
  b .

  .thumb_func
  .weak INTE2ERR_IRQHandler
INTE2ERR_IRQHandler:
  b .

  .thumb_func
  .weak INTRX0_IRQHandler
INTRX0_IRQHandler:
  b .

  .thumb_func
  .weak INTTX0_IRQHandler
INTTX0_IRQHandler:
  b .

  .thumb_func
  .weak INTRX1_IRQHandler
INTRX1_IRQHandler:
  b .

  .thumb_func
  .weak INTTX1_IRQHandler
INTTX1_IRQHandler:
  b .

  .thumb_func
  .weak INTRX2_IRQHandler
INTRX2_IRQHandler:
  b .

  .thumb_func
  .weak INTTX2_IRQHandler
INTTX2_IRQHandler:
  b .

  .thumb_func
  .weak INTRX3_IRQHandler
INTRX3_IRQHandler:
  b .

  .thumb_func
  .weak INTTX3_IRQHandler
INTTX3_IRQHandler:
  b .

  .thumb_func
  .weak INTRX4_IRQHandler
INTRX4_IRQHandler:
  b .

  .thumb_func
  .weak INTTX4_IRQHandler
INTTX4_IRQHandler:
  b .

  .thumb_func
  .weak INTRX5_IRQHandler
INTRX5_IRQHandler:
  b .

  .thumb_func
  .weak INTTX5_IRQHandler
INTTX5_IRQHandler:
  b .

  .thumb_func
  .weak INTUART0_IRQHandler
INTUART0_IRQHandler:
  b .

  .thumb_func
  .weak INTUART1_IRQHandler
INTUART1_IRQHandler:
  b .

  .thumb_func
  .weak INTI2C_IRQHandler
INTI2C_IRQHandler:
  b .

  .thumb_func
  .weak INTADA_IRQHandler
INTADA_IRQHandler:
  b .

  .thumb_func
  .weak INTADB_IRQHandler
INTADB_IRQHandler:
  b .

  .thumb_func
  .weak INTADC_IRQHandler
INTADC_IRQHandler:
  b .

  .thumb_func
  .weak INTTB00_IRQHandler
INTTB00_IRQHandler:
  b .

  .thumb_func
  .weak INTTB01_IRQHandler
INTTB01_IRQHandler:
  b .

  .thumb_func
  .weak INTTB02_IRQHandler
INTTB02_IRQHandler:
  b .

  .thumb_func
  .weak INTTB03_IRQHandler
INTTB03_IRQHandler:
  b .

  .thumb_func
  .weak INTTB04_IRQHandler
INTTB04_IRQHandler:
  b .

  .thumb_func
  .weak INTTB05_IRQHandler
INTTB05_IRQHandler:
  b .

  .thumb_func
  .weak INTTB06_IRQHandler
INTTB06_IRQHandler:
  b .

  .thumb_func
  .weak INTTB07_IRQHandler
INTTB07_IRQHandler:
  b .

  .thumb_func
  .weak INTTB08_IRQHandler
INTTB08_IRQHandler:
  b .

  .thumb_func
  .weak INTTB09_IRQHandler
INTTB09_IRQHandler:
  b .

  .thumb_func
  .weak INTTB10_IRQHandler
INTTB10_IRQHandler:
  b .

  .thumb_func
  .weak INTTB11_IRQHandler
INTTB11_IRQHandler:
  b .

  .thumb_func
  .weak INTTB12_IRQHandler
INTTB12_IRQHandler:
  b .

  .thumb_func
  .weak INTTB13_IRQHandler
INTTB13_IRQHandler:
  b .

  .thumb_func
  .weak INTTB14_IRQHandler
INTTB14_IRQHandler:
  b .

  .thumb_func
  .weak INTTB15_IRQHandler
INTTB15_IRQHandler:
  b .

  .thumb_func
  .weak INTTB16_IRQHandler
INTTB16_IRQHandler:
  b .

  .thumb_func
  .weak INTTB17_IRQHandler
INTTB17_IRQHandler:
  b .

  .thumb_func
  .weak INTTB18_IRQHandler
INTTB18_IRQHandler:
  b .

  .thumb_func
  .weak INTTB19_IRQHandler
INTTB19_IRQHandler:
  b .

  .thumb_func
  .weak INTTCCMP0_IRQHandler
INTTCCMP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTCCMP1_IRQHandler
INTTCCMP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTCCMP2_IRQHandler
INTTCCMP2_IRQHandler:
  b .

  .thumb_func
  .weak INTTCCMP3_IRQHandler
INTTCCMP3_IRQHandler:
  b .

  .thumb_func
  .weak INTTCCMP4_IRQHandler
INTTCCMP4_IRQHandler:
  b .

  .thumb_func
  .weak INTTCCMP5_IRQHandler
INTTCCMP5_IRQHandler:
  b .

  .thumb_func
  .weak INTTCCMP6_IRQHandler
INTTCCMP6_IRQHandler:
  b .

  .thumb_func
  .weak INTTCCMP7_IRQHandler
INTTCCMP7_IRQHandler:
  b .

  .thumb_func
  .weak INTTCCAP0_IRQHandler
INTTCCAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTCCAP1_IRQHandler
INTTCCAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTCCAP2_IRQHandler
INTTCCAP2_IRQHandler:
  b .

  .thumb_func
  .weak INTTCCAP3_IRQHandler
INTTCCAP3_IRQHandler:
  b .

  .thumb_func
  .weak INTPHC00_IRQHandler
INTPHC00_IRQHandler:
  b .

  .thumb_func
  .weak INTPHC01_IRQHandler
INTPHC01_IRQHandler:
  b .

  .thumb_func
  .weak INTPHC0EVRY_IRQHandler
INTPHC0EVRY_IRQHandler:
  b .

  .thumb_func
  .weak INTPHC10_IRQHandler
INTPHC10_IRQHandler:
  b .

  .thumb_func
  .weak INTPHC11_IRQHandler
INTPHC11_IRQHandler:
  b .

  .thumb_func
  .weak INTPHC1EVRY_IRQHandler
INTPHC1EVRY_IRQHandler:
  b .

  .thumb_func
  .weak INTEPHC_IRQHandler
INTEPHC_IRQHandler:
  b .

  .thumb_func
  .weak INTPHCPOVF_IRQHandler
INTPHCPOVF_IRQHandler:
  b .

  .thumb_func
  .weak INTPHCPPHE_IRQHandler
INTPHCPPHE_IRQHandler:
  b .

  .thumb_func
  .weak INTPHCPCY0_IRQHandler
INTPHCPCY0_IRQHandler:
  b .

  .thumb_func
  .weak INTPHCPCY1_IRQHandler
INTPHCPCY1_IRQHandler:
  b .

  .thumb_func
  .weak INTPHCPCY2_IRQHandler
INTPHCPCY2_IRQHandler:
  b .

  .thumb_func
  .weak INTPHCPCY3_IRQHandler
INTPHCPCY3_IRQHandler:
  b .

  .thumb_func
  .weak INTTD0CMP0_IRQHandler
INTTD0CMP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTD0CMP1_IRQHandler
INTTD0CMP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTD0CMP2_IRQHandler
INTTD0CMP2_IRQHandler:
  b .

  .thumb_func
  .weak INTTD0CMP3_IRQHandler
INTTD0CMP3_IRQHandler:
  b .

  .thumb_func
  .weak INTTD0CMP4_IRQHandler
INTTD0CMP4_IRQHandler:
  b .

  .thumb_func
  .weak INTTD1CMP0_IRQHandler
INTTD1CMP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTD1CMP1_IRQHandler
INTTD1CMP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTD1CMP2_IRQHandler
INTTD1CMP2_IRQHandler:
  b .

  .thumb_func
  .weak INTTD1CMP3_IRQHandler
INTTD1CMP3_IRQHandler:
  b .

  .thumb_func
  .weak INTTD1CMP4_IRQHandler
INTTD1CMP4_IRQHandler:
  b .

  .thumb_func
  .weak INTADAHP_IRQHandler
INTADAHP_IRQHandler:
  b .

  .thumb_func
  .weak INTADBHP_IRQHandler
INTADBHP_IRQHandler:
  b .

  .thumb_func
  .weak INTADCHP_IRQHandler
INTADCHP_IRQHandler:
  b .

  .thumb_func
  .weak INTTB07CAP0_IRQHandler
INTTB07CAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTB07CAP1_IRQHandler
INTTB07CAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTB08CAP0_IRQHandler
INTTB08CAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTB08CAP1_IRQHandler
INTTB08CAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTB09CAP0_IRQHandler
INTTB09CAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTB09CAP1_IRQHandler
INTTB09CAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTB10CAP0_IRQHandler
INTTB10CAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTB10CAP1_IRQHandler
INTTB10CAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTB11CAP0_IRQHandler
INTTB11CAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTB11CAP1_IRQHandler
INTTB11CAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTB12CAP0_IRQHandler
INTTB12CAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTB12CAP1_IRQHandler
INTTB12CAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTB13CAP0_IRQHandler
INTTB13CAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTB13CAP1_IRQHandler
INTTB13CAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTB14CAP0_IRQHandler
INTTB14CAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTB14CAP1_IRQHandler
INTTB14CAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTB15CAP0_IRQHandler
INTTB15CAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTB15CAP1_IRQHandler
INTTB15CAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTB16CAP0_IRQHandler
INTTB16CAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTB16CAP1_IRQHandler
INTTB16CAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTB17CAP0_IRQHandler
INTTB17CAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTB17CAP1_IRQHandler
INTTB17CAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTB18CAP0_IRQHandler
INTTB18CAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTB18CAP1_IRQHandler
INTTB18CAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTTB19CAP0_IRQHandler
INTTB19CAP0_IRQHandler:
  b .

  .thumb_func
  .weak INTTB19CAP1_IRQHandler
INTTB19CAP1_IRQHandler:
  b .

  .thumb_func
  .weak INTADAM0_IRQHandler
INTADAM0_IRQHandler:
  b .

  .thumb_func
  .weak INTADAM1_IRQHandler
INTADAM1_IRQHandler:
  b .

  .thumb_func
  .weak INTADBM0_IRQHandler
INTADBM0_IRQHandler:
  b .

  .thumb_func
  .weak INTADBM1_IRQHandler
INTADBM1_IRQHandler:
  b .

  .thumb_func
  .weak INTADCM0_IRQHandler
INTADCM0_IRQHandler:
  b .

  .thumb_func
  .weak INTADCM1_IRQHandler
INTADCM1_IRQHandler:
  b .

  .thumb_func
  .weak INTDMACATC_IRQHandler
INTDMACATC_IRQHandler:
  b .

  .thumb_func
  .weak INTDMACAERR_IRQHandler
INTDMACAERR_IRQHandler:
  b .

  .thumb_func
  .weak INTDMACBTC_IRQHandler
INTDMACBTC_IRQHandler:
  b .

  .thumb_func
  .weak INTDMACBERR_IRQHandler
INTDMACBERR_IRQHandler:
  b .

  .thumb_func
  .weak INTDMACCTC_IRQHandler
INTDMACCTC_IRQHandler:
  b .

  .thumb_func
  .weak INTDMACCERR_IRQHandler
INTDMACCERR_IRQHandler:
  b .

  .thumb_func
  .weak INTTCTBT_IRQHandler
INTTCTBT_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .align 0
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word INT0_IRQHandler
  .word INT1_IRQHandler
  .word INT2_IRQHandler
  .word INT3_IRQHandler
  .word INT4_IRQHandler
  .word INT5_IRQHandler
  .word INT6_IRQHandler
  .word INT7_IRQHandler
  .word INT8_IRQHandler
  .word INT9_IRQHandler
  .word INTA_IRQHandler
  .word INTB_IRQHandler
  .word INTC_IRQHandler
  .word INTD_IRQHandler
  .word INTE_IRQHandler
  .word INTF_IRQHandler
  .word INT10_IRQHandler
  .word INT11_IRQHandler
  .word INT12_IRQHandler
  .word INT13_IRQHandler
  .word INT14_IRQHandler
  .word INT15_IRQHandler
  .word INTKWUPA_IRQHandler
  .word INTKWUPB_IRQHandler
  .word INTKSCAN_IRQHandler
  .word INTRTC_IRQHandler
  .word INT16_IRQHandler
  .word INT17_IRQHandler
  .word INTPSCSTOP_IRQHandler
  .word INTPSCBRK_IRQHandler
  .word INTPSCSTEP_IRQHandler
  .word INTPSCII_IRQHandler
  .word INTPSCIA_IRQHandler
  .word INTE0RX_IRQHandler
  .word INTE0TX_IRQHandler
  .word INTE0ERR_IRQHandler
  .word INTE1RX_IRQHandler
  .word INTE1TX_IRQHandler
  .word INTE1ERR_IRQHandler
  .word INTE2RX_IRQHandler
  .word INTE2TX_IRQHandler
  .word INTE2ERR_IRQHandler
  .word INTRX0_IRQHandler
  .word INTTX0_IRQHandler
  .word INTRX1_IRQHandler
  .word INTTX1_IRQHandler
  .word INTRX2_IRQHandler
  .word INTTX2_IRQHandler
  .word INTRX3_IRQHandler
  .word INTTX3_IRQHandler
  .word INTRX4_IRQHandler
  .word INTTX4_IRQHandler
  .word INTRX5_IRQHandler
  .word INTTX5_IRQHandler
  .word INTUART0_IRQHandler
  .word INTUART1_IRQHandler
  .word INTI2C_IRQHandler
  .word INTADA_IRQHandler
  .word INTADB_IRQHandler
  .word INTADC_IRQHandler
  .word INTTB00_IRQHandler
  .word INTTB01_IRQHandler
  .word INTTB02_IRQHandler
  .word INTTB03_IRQHandler
  .word INTTB04_IRQHandler
  .word INTTB05_IRQHandler
  .word INTTB06_IRQHandler
  .word INTTB07_IRQHandler
  .word INTTB08_IRQHandler
  .word INTTB09_IRQHandler
  .word INTTB10_IRQHandler
  .word INTTB11_IRQHandler
  .word INTTB12_IRQHandler
  .word INTTB13_IRQHandler
  .word INTTB14_IRQHandler
  .word INTTB15_IRQHandler
  .word INTTB16_IRQHandler
  .word INTTB17_IRQHandler
  .word INTTB18_IRQHandler
  .word INTTB19_IRQHandler
  .word INTTCCMP0_IRQHandler
  .word INTTCCMP1_IRQHandler
  .word INTTCCMP2_IRQHandler
  .word INTTCCMP3_IRQHandler
  .word INTTCCMP4_IRQHandler
  .word INTTCCMP5_IRQHandler
  .word INTTCCMP6_IRQHandler
  .word INTTCCMP7_IRQHandler
  .word INTTCCAP0_IRQHandler
  .word INTTCCAP1_IRQHandler
  .word INTTCCAP2_IRQHandler
  .word INTTCCAP3_IRQHandler
  .word INTPHC00_IRQHandler
  .word INTPHC01_IRQHandler
  .word INTPHC0EVRY_IRQHandler
  .word INTPHC10_IRQHandler
  .word INTPHC11_IRQHandler
  .word INTPHC1EVRY_IRQHandler
  .word INTEPHC_IRQHandler
  .word INTPHCPOVF_IRQHandler
  .word INTPHCPPHE_IRQHandler
  .word INTPHCPCY0_IRQHandler
  .word INTPHCPCY1_IRQHandler
  .word INTPHCPCY2_IRQHandler
  .word INTPHCPCY3_IRQHandler
  .word INTTD0CMP0_IRQHandler
  .word INTTD0CMP1_IRQHandler
  .word INTTD0CMP2_IRQHandler
  .word INTTD0CMP3_IRQHandler
  .word INTTD0CMP4_IRQHandler
  .word INTTD1CMP0_IRQHandler
  .word INTTD1CMP1_IRQHandler
  .word INTTD1CMP2_IRQHandler
  .word INTTD1CMP3_IRQHandler
  .word INTTD1CMP4_IRQHandler
  .word INTADAHP_IRQHandler
  .word INTADBHP_IRQHandler
  .word INTADCHP_IRQHandler
  .word INTTB07CAP0_IRQHandler
  .word INTTB07CAP1_IRQHandler
  .word INTTB08CAP0_IRQHandler
  .word INTTB08CAP1_IRQHandler
  .word INTTB09CAP0_IRQHandler
  .word INTTB09CAP1_IRQHandler
  .word INTTB10CAP0_IRQHandler
  .word INTTB10CAP1_IRQHandler
  .word INTTB11CAP0_IRQHandler
  .word INTTB11CAP1_IRQHandler
  .word INTTB12CAP0_IRQHandler
  .word INTTB12CAP1_IRQHandler
  .word INTTB13CAP0_IRQHandler
  .word INTTB13CAP1_IRQHandler
  .word INTTB14CAP0_IRQHandler
  .word INTTB14CAP1_IRQHandler
  .word INTTB15CAP0_IRQHandler
  .word INTTB15CAP1_IRQHandler
  .word INTTB16CAP0_IRQHandler
  .word INTTB16CAP1_IRQHandler
  .word INTTB17CAP0_IRQHandler
  .word INTTB17CAP1_IRQHandler
  .word INTTB18CAP0_IRQHandler
  .word INTTB18CAP1_IRQHandler
  .word INTTB19CAP0_IRQHandler
  .word INTTB19CAP1_IRQHandler
  .word INTADAM0_IRQHandler
  .word INTADAM1_IRQHandler
  .word INTADBM0_IRQHandler
  .word INTADBM1_IRQHandler
  .word INTADCM0_IRQHandler
  .word INTADCM1_IRQHandler
  .word INTDMACATC_IRQHandler
  .word INTDMACAERR_IRQHandler
  .word INTDMACBTC_IRQHandler
  .word INTDMACBERR_IRQHandler
  .word INTDMACCTC_IRQHandler
  .word INTDMACCERR_IRQHandler
  .word INTTCTBT_IRQHandler
_vectors_end:

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .align 0
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
