/**
 *******************************************************************************
 * @file    TMPM440.h
 * @brief   CMSIS Cortex-M4 Core Peripheral Access Layer Header File for the
 *          TOSHIBA 'TMPM440' Device Series
 * @version V2.0.2.1 (Tentative)
 * @date    2012/07/12
 * 
 * THE SOURCE CODE AND ITS RELATED DOCUMENTATION IS PROVIDED "AS IS". TOSHIBA
 * CORPORATION MAKES NO OTHER WARRANTY OF ANY KIND, WHETHER EXPRESS, IMPLIED OR,
 * STATUTORY AND DISCLAIMS ANY AND ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * SATISFACTORY QUALITY, NON INFRINGEMENT AND FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * THE SOURCE CODE AND DOCUMENTATION MAY INCLUDE ERRORS. TOSHIBA CORPORATION
 * RESERVES THE RIGHT TO INCORPORATE MODIFICATIONS TO THE SOURCE CODE IN LATER
 * REVISIONS OF IT, AND TO MAKE IMPROVEMENTS OR CHANGES IN THE DOCUMENTATION OR
 * THE PRODUCTS OR TECHNOLOGIES DESCRIBED THEREIN AT ANY TIME.
 * 
 * TOSHIBA CORPORATION SHALL NOT BE LIABLE FOR ANY DIRECT, INDIRECT OR
 * CONSEQUENTIAL DAMAGE OR LIABILITY ARISING FROM YOUR USE OF THE SOURCE CODE OR
 * ANY DOCUMENTATION, INCLUDING BUT NOT LIMITED TO, LOST REVENUES, DATA OR
 * PROFITS, DAMAGES OF ANY SPECIAL, INCIDENTAL OR CONSEQUENTIAL NATURE, PUNITIVE
 * DAMAGES, LOSS OF PROPERTY OR LOSS OF PROFITS ARISING OUT OF OR IN CONNECTION
 * WITH THIS AGREEMENT, OR BEING UNUSABLE, EVEN IF ADVISED OF THE POSSIBILITY OR
 * PROBABILITY OF SUCH DAMAGES AND WHETHER A CLAIM FOR SUCH DAMAGE IS BASED UPON
 * WARRANTY, CONTRACT, TORT, NEGLIGENCE OR OTHERWISE.
 * 
 * (C)Copyright TOSHIBA CORPORATION 2012 All rights reserved
 *
 *                                                              modified by Keil
 *******************************************************************************
 */

/** @addtogroup TOSHIBA_TX04_MICROCONTROLLER
  * @{
  */

/** @addtogroup TMPM440
  * @{
  */

#ifndef __TMPM440_H__
#define __TMPM440_H__

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup Configuration_of_CMSIS
  * @{
  */

/** Interrupt Number Definition */
typedef enum IRQn
{
/******  Cortex-M4 Processor Exceptions Numbers ***************************************************************/
  NonMaskableInt_IRQn           = -14,       /*!< 2 Non Maskable Interrupt                                    */
  HardFault_IRQn                = -13,       /*!< 3 Cortex-M4 Hard Fault Interrupt                            */
  MemoryManagement_IRQn         = -12,       /*!< 4 Cortex-M4 Memory Management Interrupt                     */
  BusFault_IRQn                 = -11,       /*!< 5 Cortex-M4 Bus Fault Interrupt                             */
  UsageFault_IRQn               = -10,       /*!< 6 Cortex-M4 Usage Fault Interrupt                           */
  SVCall_IRQn                   = -5,        /*!< 11 Cortex-M4 SV Call Interrupt                              */
  DebugMonitor_IRQn             = -4,        /*!< 12 Cortex-M4 Debug Monitor Interrupt                        */
  PendSV_IRQn                   = -2,        /*!< 14 Cortex-M4 Pend SV Interrupt                              */
  SysTick_IRQn                  = -1,        /*!< 15 Cortex-M4 System Tick Interrupt                          */

/******  TMPM440 Specific Interrupt Numbers *******************************************************************/
  INT0_IRQn                     = 0,         /*!< Interrupt pin 0                                             */
  INT1_IRQn                     = 1,         /*!< Interrupt pin 1                                             */
  INT2_IRQn                     = 2,         /*!< Interrupt pin 2                                             */
  INT3_IRQn                     = 3,         /*!< Interrupt pin 3                                             */
  INT4_IRQn                     = 4,         /*!< Interrupt pin 4                                             */
  INT5_IRQn                     = 5,         /*!< Interrupt pin 5                                             */
  INT6_IRQn                     = 6,         /*!< Interrupt pin 6                                             */
  INT7_IRQn                     = 7,         /*!< Interrupt pin 7                                             */
  INT8_IRQn                     = 8,         /*!< Interrupt pin 8                                             */
  INT9_IRQn                     = 9,         /*!< Interrupt pin 9                                             */
  INTA_IRQn                     = 10,        /*!< Interrupt pin A                                             */
  INTB_IRQn                     = 11,        /*!< Interrupt pin B                                             */
  INTC_IRQn                     = 12,        /*!< Interrupt pin C                                             */
  INTD_IRQn                     = 13,        /*!< Interrupt pin D                                             */
  INTE_IRQn                     = 14,        /*!< Interrupt pin E                                             */
  INTF_IRQn                     = 15,        /*!< Interrupt pin F                                             */
  INT10_IRQn                    = 16,        /*!< Interrupt pin 10                                            */
  INT11_IRQn                    = 17,        /*!< Interrupt pin 11                                            */
  INT12_IRQn                    = 18,        /*!< Interrupt pin 12                                            */
  INT13_IRQn                    = 19,        /*!< Interrupt pin 13                                            */
  INT14_IRQn                    = 20,        /*!< Interrupt pin 14                                            */
  INT15_IRQn                    = 21,        /*!< Interrupt pin 15                                            */
  INTKWUPA_IRQn                 = 22,        /*!< Key on wake up interrupt (unitA)                            */
  INTKWUPB_IRQn                 = 23,        /*!< Key on wake up interrupt (unitB)                            */
  INTKSCAN_IRQn                 = 24,        /*!< Key matrix scan interupt                                    */
  INTRTC_IRQn                   = 25,        /*!< Real time counter interupt                                  */
  INT16_IRQn                    = 26,        /*!< Interrupt pin 16                                            */
  INT17_IRQn                    = 27,        /*!< Interrupt pin 17                                            */
  INTPSCSTOP_IRQn               = 28,        /*!< PSC end interrupt                                           */
  INTPSCBRK_IRQn                = 29,        /*!< PSC break interrupt                                         */
  INTPSCSTEP_IRQn               = 30,        /*!< PSC step interrupt                                          */
  INTPSCII_IRQn                 = 31,        /*!< PSC unjustified instruction interrupt                       */
  INTPSCIA_IRQn                 = 32,        /*!< PSC unjustified address interrupt                           */
  INTE0RX_IRQn                  = 33,        /*!< ESIO 0 reception interrupt                                  */
  INTE0TX_IRQn                  = 34,        /*!< ESIO 0 transmission interrupt                               */
  INTE0ERR_IRQn                 = 35,        /*!< ESIO 0 error interrupt                                      */
  INTE1RX_IRQn                  = 36,        /*!< ESIO 1 reception interrupt                                  */
  INTE1TX_IRQn                  = 37,        /*!< ESIO 1 transmission interrupt                               */
  INTE1ERR_IRQn                 = 38,        /*!< ESIO 1 error interrupt                                      */
  INTE2RX_IRQn                  = 39,        /*!< ESIO 2 reception interrupt                                  */
  INTE2TX_IRQn                  = 40,        /*!< ESIO 2 transmission interrupt                               */
  INTE2ERR_IRQn                 = 41,        /*!< ESIO 2 error interrupt                                      */
  INTRX0_IRQn                   = 42,        /*!< Serial0 reception interrupt                                 */
  INTTX0_IRQn                   = 43,        /*!< Serial0 transmission interrupt                              */
  INTRX1_IRQn                   = 44,        /*!< Serial1 reception interrupt                                 */
  INTTX1_IRQn                   = 45,        /*!< Serial1 transmission interrupt                              */
  INTRX2_IRQn                   = 46,        /*!< Serial2 reception interrupt                                 */
  INTTX2_IRQn                   = 47,        /*!< Serial2 transmission interrupt                              */
  INTRX3_IRQn                   = 48,        /*!< Serial3 reception interrupt                                 */
  INTTX3_IRQn                   = 49,        /*!< Serial3 transmission interrupt                              */
  INTRX4_IRQn                   = 50,        /*!< Serial4 reception interrupt                                 */
  INTTX4_IRQn                   = 51,        /*!< Serial4 transmission interrupt                              */
  INTRX5_IRQn                   = 52,        /*!< Serial5 reception interrupt                                 */
  INTTX5_IRQn                   = 53,        /*!< Serial5 transmission interrupt                              */
  INTUART0_IRQn                 = 54,        /*!< Full UART0 transmission and reception interrupt             */
  INTUART1_IRQn                 = 55,        /*!< Full UART1 transmission and reception interrupt             */
  INTI2C_IRQn                   = 56,        /*!< I2C interrupt                                               */
  INTADA_IRQn                   = 57,        /*!< AD conversion interrupt (unitA)                             */
  INTADB_IRQn                   = 58,        /*!< AD conversion interrupt (unitB)                             */
  INTADC_IRQn                   = 59,        /*!< AD conversion interrupt (unitC)                             */
  INTTB00_IRQn                  = 60,        /*!< 16-bit TMRB00 compare match detection interrupt             */
  INTTB01_IRQn                  = 61,        /*!< 16-bit TMRB01 compare match detection interrupt             */
  INTTB02_IRQn                  = 62,        /*!< 16-bit TMRB02 compare match detection interrupt             */
  INTTB03_IRQn                  = 63,        /*!< 16-bit TMRB03 compare match detection interrupt             */
  INTTB04_IRQn                  = 64,        /*!< 16-bit TMRB04 compare match detection interrupt             */
  INTTB05_IRQn                  = 65,        /*!< 16-bit TMRB05 compare match detection interrupt             */
  INTTB06_IRQn                  = 66,        /*!< 16-bit TMRB06 compare match detection interrupt             */
  INTTB07_IRQn                  = 67,        /*!< 16-bit TMRB07 compare match detection interrupt             */
  INTTB08_IRQn                  = 68,        /*!< 16-bit TMRB08 compare match detection interrupt             */
  INTTB09_IRQn                  = 69,        /*!< 16-bit TMRB09 compare match detection interrupt             */
  INTTB10_IRQn                  = 70,        /*!< 16-bit TMRB10 compare match detection interrupt             */
  INTTB11_IRQn                  = 71,        /*!< 16-bit TMRB11 compare match detection interrupt             */
  INTTB12_IRQn                  = 72,        /*!< 16-bit TMRB12 compare match detection interrupt             */
  INTTB13_IRQn                  = 73,        /*!< 16-bit TMRB13 compare match detection interrupt             */
  INTTB14_IRQn                  = 74,        /*!< 16-bit TMRB14 compare match detection interrupt             */
  INTTB15_IRQn                  = 75,        /*!< 16-bit TMRB15 compare match detection interrupt             */
  INTTB16_IRQn                  = 76,        /*!< 16-bit TMRB16 compare match detection interrupt             */
  INTTB17_IRQn                  = 77,        /*!< 16-bit TMRB17 compare match detection interrupt             */
  INTTB18_IRQn                  = 78,        /*!< 16-bit TMRB18 compare match detection interrupt             */
  INTTB19_IRQn                  = 79,        /*!< 16-bit TMRB19 compare match detection interrupt             */
  INTTCCMP0_IRQn                = 80,        /*!< 32-bit TMRC0 compare match detection interrupt              */
  INTTCCMP1_IRQn                = 81,        /*!< 32-bit TMRC1 compare match detection interrupt              */
  INTTCCMP2_IRQn                = 82,        /*!< 32-bit TMRC2 compare match detection interrupt              */
  INTTCCMP3_IRQn                = 83,        /*!< 32-bit TMRC3 compare match detection interrupt              */
  INTTCCMP4_IRQn                = 84,        /*!< 32-bit TMRC4 compare match detection interrupt              */
  INTTCCMP5_IRQn                = 85,        /*!< 32-bit TMRC5 compare match detection interrupt              */
  INTTCCMP6_IRQn                = 86,        /*!< 32-bit TMRC6 compare match detection interrupt              */
  INTTCCMP7_IRQn                = 87,        /*!< 32-bit TMRC7 compare match detection interrupt              */
  INTTCCAP0_IRQn                = 88,        /*!< 32-bit TMRC0 input capture detection interrupt              */
  INTTCCAP1_IRQn                = 89,        /*!< 32-bit TMRC1 input capture detection interrupt              */
  INTTCCAP2_IRQn                = 90,        /*!< 32-bit TMRC2 input capture detection interrupt              */
  INTTCCAP3_IRQn                = 91,        /*!< 32-bit TMRC3 input capture detection interrupt              */
  INTPHC00_IRQn                 = 92,        /*!< 16-bit PHC0 compare match detection interrupt 0             */
  INTPHC01_IRQn                 = 93,        /*!< 16-bit PHC0 compare match detection interrupt 1             */
  INTPHC0EVRY_IRQn              = 94,        /*!< 16-bit PHC0 every count interrupt                           */
  INTPHC10_IRQn                 = 95,        /*!< 16-bit PHC1 compare match detection interrupt 0             */
  INTPHC11_IRQn                 = 96,        /*!< 16-bit PHC1 compare match detection interrupt 1             */
  INTPHC1EVRY_IRQn              = 97,        /*!< 16-bit PHC1 every count interrupt                           */
  INTEPHC_IRQn                  = 98,        /*!< Two-phase pulse input counter interrupt                     */
  INTPHCPOVF_IRQn               = 99,        /*!< PHCP overflow interrupt                                     */
  INTPHCPPHE_IRQn               = 100,       /*!< PHCP phase error interrupt                                  */
  INTPHCPCY0_IRQn               = 101,       /*!< PHCP cycle interrupt 0                                      */
  INTPHCPCY1_IRQn               = 102,       /*!< PHCP cycle interrupt 1                                      */
  INTPHCPCY2_IRQn               = 103,       /*!< PHCP cycle interrupt 2                                      */
  INTPHCPCY3_IRQn               = 104,       /*!< PHCP cycle interrupt 3                                      */
  INTTD0CMP0_IRQn               = 105,       /*!< TMRD0 compare match detection interrupt 0                   */
  INTTD0CMP1_IRQn               = 106,       /*!< TMRD0 compare match detection interrupt 1                   */
  INTTD0CMP2_IRQn               = 107,       /*!< TMRD0 compare match detection interrupt 2                   */
  INTTD0CMP3_IRQn               = 108,       /*!< TMRD0 compare match detection interrupt 3                   */
  INTTD0CMP4_IRQn               = 109,       /*!< TMRD0 compare match detection interrupt 4                   */
  INTTD1CMP0_IRQn               = 110,       /*!< TMRD1 compare match detection interrupt 0                   */
  INTTD1CMP1_IRQn               = 111,       /*!< TMRD1 compare match detection interrupt 1                   */
  INTTD1CMP2_IRQn               = 112,       /*!< TMRD1 compare match detection interrupt 2                   */
  INTTD1CMP3_IRQn               = 113,       /*!< TMRD1 compare match detection interrupt 3                   */
  INTTD1CMP4_IRQn               = 114,       /*!< TMRD1 compare match detection interrupt 4                   */
  INTADAHP_IRQn                 = 115,       /*!< High Priority AD conversion interrupt (channel.A)           */
  INTADBHP_IRQn                 = 116,       /*!< High Priority AD conversion interrupt (channel.B)           */
  INTADCHP_IRQn                 = 117,       /*!< High Priority AD conversion interrupt (channel.C)           */
  INTTB07CAP0_IRQn              = 118,       /*!< 16-bit TMRB07 input capture 0 detection interrupt           */
  INTTB07CAP1_IRQn              = 119,       /*!< 16-bit TMRB07 input capture 1 detection interrupt           */
  INTTB08CAP0_IRQn              = 120,       /*!< 16-bit TMRB08 input capture 0 detection interrupt           */
  INTTB08CAP1_IRQn              = 121,       /*!< 16-bit TMRB08 input capture 1 detection interrupt           */
  INTTB09CAP0_IRQn              = 122,       /*!< 16-bit TMRB09 input capture 0 detection interrupt           */
  INTTB09CAP1_IRQn              = 123,       /*!< 16-bit TMRB09 input capture 1 detection interrupt           */
  INTTB10CAP0_IRQn              = 124,       /*!< 16-bit TMRB10 input capture 0 detection interrupt           */
  INTTB10CAP1_IRQn              = 125,       /*!< 16-bit TMRB10 input capture 1 detection interrupt           */
  INTTB11CAP0_IRQn              = 126,       /*!< 16-bit TMRB11 input capture 0 detection interrupt           */
  INTTB11CAP1_IRQn              = 127,       /*!< 16-bit TMRB11 input capture 1 detection interrupt           */
  INTTB12CAP0_IRQn              = 128,       /*!< 16-bit TMRB12 input capture 0 detection interrupt           */
  INTTB12CAP1_IRQn              = 129,       /*!< 16-bit TMRB12 input capture 1 detection interrupt           */
  INTTB13CAP0_IRQn              = 130,       /*!< 16-bit TMRB13 input capture 0 detection interrupt           */
  INTTB13CAP1_IRQn              = 131,       /*!< 16-bit TMRB13 input capture 1 detection interrupt           */
  INTTB14CAP0_IRQn              = 132,       /*!< 16-bit TMRB14 input capture 0 detection interrupt           */
  INTTB14CAP1_IRQn              = 133,       /*!< 16-bit TMRB14 input capture 1 detection interrupt           */
  INTTB15CAP0_IRQn              = 134,       /*!< 16-bit TMRB15 input capture 0 detection interrupt           */
  INTTB15CAP1_IRQn              = 135,       /*!< 16-bit TMRB15 input capture 1 detection interrupt           */
  INTTB16CAP0_IRQn              = 136,       /*!< 16-bit TMRB16 input capture 0 detection interrupt           */
  INTTB16CAP1_IRQn              = 137,       /*!< 16-bit TMRB16 input capture 1 detection interrupt           */
  INTTB17CAP0_IRQn              = 138,       /*!< 16-bit TMRB17 input capture 0 detection interrupt           */
  INTTB17CAP1_IRQn              = 139,       /*!< 16-bit TMRB17 input capture 1 detection interrupt           */
  INTTB18CAP0_IRQn              = 140,       /*!< 16-bit TMRB18 input capture 0 detection interrupt           */
  INTTB18CAP1_IRQn              = 141,       /*!< 16-bit TMRB18 input capture 1 detection interrupt           */
  INTTB19CAP0_IRQn              = 142,       /*!< 16-bit TMRB19 input capture 0 detection interrupt           */
  INTTB19CAP1_IRQn              = 143,       /*!< 16-bit TMRB19 input capture 1 detection interrupt           */
  INTADAM0_IRQn                 = 144,       /*!< SAR ADC monitor 0 interrupt (unitA)                         */
  INTADAM1_IRQn                 = 145,       /*!< SAR ADC monitor 1 interrupt (unitA)                         */
  INTADBM0_IRQn                 = 146,       /*!< SAR ADC monitor 0 interrupt (unitB)                         */
  INTADBM1_IRQn                 = 147,       /*!< SAR ADC monitor 1 interrupt (unitB)                         */
  INTADCM0_IRQn                 = 148,       /*!< SAR ADC monitor 0 interrupt (unitC)                         */
  INTADCM1_IRQn                 = 149,       /*!< SAR ADC monitor 1 interrupt (unitC)                         */
  INTDMACATC_IRQn               = 150,       /*!< DMA terminal count status interrupt (unitA)                 */
  INTDMACAERR_IRQn              = 151,       /*!< DMA error status interrupt (unitA)                          */
  INTDMACBTC_IRQn               = 152,       /*!< DMA terminal count status interrupt (unitB)                 */
  INTDMACBERR_IRQn              = 153,       /*!< DMA error status interrupt (unitB)                          */
  INTDMACCTC_IRQn               = 154,       /*!< DMA terminal count status interrupt (unitC)                 */
  INTDMACCERR_IRQn              = 155,       /*!< DMA error status interrupt (unitC)                          */
  INTTCTBT_IRQn                 = 156        /*!< 32-bit TMRC overflow interrupt                              */
} IRQn_Type;

/** Processor and Core Peripheral Section */

/* Configuration of the Cortex-M4 Processor and Core Peripherals */
#define __CM4_REV              0x0400       /*!< Cortex-M4 Core Revision                           */
#define __MPU_PRESENT             0         /*!< MPU present or not                                */
#define __NVIC_PRIO_BITS          3         /*!< Number of Bits used for Priority Levels           */
#define __Vendor_SysTickConfig    0         /*!< Set to 1 if different SysTick Config is used      */
#define __FPU_PRESENT             1         /*!< FPU present or not                                */

/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                       /* Cortex-M4 processor and core peripherals            */
#include "system_TMPM440.h"                 /* TMPM440 System                                      */

/** @addtogroup Device_Peripheral_registers
  * @{
  */

/** Device Specific Peripheral registers structures */

/**
  * @brief DMA Controller
  */
typedef struct
{
  __I  uint32_t INTSTATUS;         /*!< DMAC Interrupt Status Register               */
  __I  uint32_t INTTCSTATUS;       /*!< DMAC Interrupt Terminal Count Status Register*/
  __O  uint32_t INTTCCLEAR;        /*!< DMAC Interrupt Terminal Count Clear Register */
  __I  uint32_t INTERRORSTATUS;    /*!< DMAC Interrupt Error Status Register         */
  __O  uint32_t INTERRCLR;         /*!< DMAC Interrupt Error Clear Register          */
  __I  uint32_t RAWINTTCSTATUS;    /*!< DMAC Raw Interrupt Terminal Count Status Register*/
  __I  uint32_t RAWINTERRORSTATUS; /*!< DMAC Raw Error Interrupt Status Register     */
  __I  uint32_t ENBLDCHNS;         /*!< DMAC Enabled Channel Register                */
  __IO uint32_t SOFTBREQ;          /*!< DMAC Software Burst Request Register         */
  __IO uint32_t SOFTSREQ;          /*!< DMAC Software Single Request Register        */
       uint32_t RESERVED0[2];
  __IO uint32_t CONFIGURATION;     /*!< DMAC Configuration Register                  */
       uint32_t RESERVED1[51];
  __IO uint32_t C0SRCADDR;         /*!< DMAC Channel 0 Source Address Register       */
  __IO uint32_t C0DESTADDR;        /*!< DMAC Channel 0 Destination Address Register  */
  __IO uint32_t C0LLI;             /*!< DMAC Channel 0 Linked List Item Register     */
  __IO uint32_t C0CONTROL;         /*!< DMAC Channel 0 Control Register              */
  __IO uint32_t C0CONFIGURATION;   /*!< DMAC Channel 0 Configuration Register        */
       uint32_t RESERVED2[3];
  __IO uint32_t C1SRCADDR;         /*!< DMAC Channel 1 Source Address Register       */
  __IO uint32_t C1DESTADDR;        /*!< DMAC Channel 1 Destination Address Register  */
  __IO uint32_t C1LLI;             /*!< DMAC Channel 1 Linked List Item Register     */
  __IO uint32_t C1CONTROL;         /*!< DMAC Channel 1 Control Register              */
  __IO uint32_t C1CONFIGURATION;   /*!< DMAC Channel 1 Configuration Register        */
} TSB_DMAC_TypeDef;

/**
  * @brief Programmable Servo Controller 
  */
typedef struct
{
  __IO uint32_t UA0;               /*!< Accumulator                                  */
  __IO uint32_t UM0;               /*!< Multiplier Register                          */
  __IO uint32_t UM1;               /*!< Shift Count Register                         */
  __IO uint32_t UL0;               /*!< Upper Limit Value Register                   */
  __IO uint32_t UL1;               /*!< Lower Limit Value Register                   */
  __IO uint32_t UR0;               /*!< Add Sub Value Register 0                     */
  __IO uint32_t UR1;               /*!< Add Sub Value Register 1                     */
  __IO uint32_t SGN;               /*!< Arithmetic Parameter with Signed Register    */
  __IO uint32_t AP0;               /*!< Address Pointer 0                            */
  __IO uint32_t AP1;               /*!< Address Pointer 1                            */
  __IO uint32_t AP2;               /*!< Address Pointer 2                            */
  __IO uint32_t AP3;               /*!< Address Pointer 3                            */
  __IO uint32_t BR0;               /*!< Break Pointer                                */
  __IO uint32_t PG0;               /*!< Program Counter                              */
  __IO uint32_t VG0;               /*!< Repeat Processing Vector Pointer             */
       uint32_t RESERVED0[49];
  __IO uint32_t CNT;               /*!< Control Register                             */
  __IO uint32_t FLG;               /*!< Flag Register                                */
       uint32_t RESERVED1[7102];
  __IO uint32_t REN;               /*!< Run Trigger Enable Register                  */
  __I  uint32_t RFLG;              /*!< Run Trigger Flag Register                    */
  __O  uint32_t RCLR;              /*!< Run Trigger Clear Register                   */
  __O  uint32_t RSET;              /*!< Run Trigger Clear Register                   */
       uint32_t RESERVED2[60];
  __IO uint32_t PTOUT;             /*!< Port Output Enable Register for PSC          */
  __IO uint32_t PTCR;              /*!< Port Control Register for PSC                */
  __I  uint32_t PTIN;              /*!< Port Input Enable Register for PSC           */
} TSB_PSC_TypeDef;

/**
  * @brief Synchronous Serial Port
  */
typedef struct
{
  __IO uint32_t CR0;               /*!< Control Register 0                           */
  __IO uint32_t CR1;               /*!< Control Register 1                           */
  __IO uint32_t DR;                /*!< Data Register                                */
  __I  uint32_t SR;                /*!< Status Register                              */
  __IO uint32_t CPSR;              /*!< Clock Prescale Register                      */
  __IO uint32_t IMSC;              /*!< Interrupt Mask Set And Clear Register        */
  __I  uint32_t RIS;               /*!< Raw Interrupt Status Register                */
  __I  uint32_t MIS;               /*!< Masked Interrupt Status Register             */
  __O  uint32_t ICR;               /*!< Interrupt Clear Register                     */
  __IO uint32_t DMACR;             /*!< DMA Control Register                         */
} TSB_SSP_TypeDef;

#if defined ( __CC_ARM   )           /* RealView Compiler */
#pragma anon_unions
#elif (defined (__ICCARM__))         /*  ICC Compiler     */
#pragma language=extended
#endif

/**
  * @brief UART
  */
typedef struct
{
  __IO uint32_t DR;                /*!< Data Register                                */
union {
  __I  uint32_t RSR;               /*!< Receive Status Register                      */
  __O  uint32_t ECR;               /*!< Error Clear Register                         */
  };
       uint32_t RESERVED0[4];
  __I  uint32_t FR;                /*!< Flag Register                                */
       uint32_t RESERVED1[2];
  __IO uint32_t IBRD;              /*!< Integer Baud Rate Register                   */
  __IO uint32_t FBRD;              /*!< Fractional Baud Rate Register                */
  __IO uint32_t LCR_H;             /*!< Line Control Register                        */
  __IO uint32_t CR;                /*!< Control Register                             */
  __IO uint32_t IFLS;              /*!< Interrupt FIFO Level Select Register         */
  __IO uint32_t IMSC;              /*!< Interrupt Mask Set/Clear Register            */
  __I  uint32_t RIS;               /*!< Raw Interrupt Status Register                */
  __I  uint32_t MIS;               /*!< Masked Interrupt Status Register             */
  __O  uint32_t ICR;               /*!< Interrupt Clear Register                     */
  __IO uint32_t DMACR;             /*!< DMA Control Register                         */
} TSB_UART_TypeDef;

/**
  * @brief 12bit A/D Converter
  */
typedef struct
{
  __IO uint32_t CLK;               /*!< Conversion Clock Setting Register            */
  __O  uint32_t MOD0;              /*!< Mode Control Register0                       */
  __IO uint32_t MOD1;              /*!< Mode Control Register1                       */
  __IO uint32_t MOD2;              /*!< Mode Control Register2                       */
  __IO uint32_t MOD3;              /*!< Mode Control Register3                       */
  __IO uint32_t MOD4;              /*!< Mode Control Register4                       */
  __I  uint32_t MOD5;              /*!< Mode Control Register5                       */
  __IO uint32_t MOD6;              /*!< Mode Control Register6                       */
  __IO uint32_t MOD7;              /*!< Mode Control Register7                       */
  __IO uint32_t CMPCR0;            /*!< Monitoring Interrupt Control Register0       */
  __IO uint32_t CMPCR1;            /*!< Monitoring Interrupt Control Register1       */
  __IO uint32_t CMP0;              /*!< Conversion Result Compare Register0          */
  __IO uint32_t CMP1;              /*!< Conversion Result Compare Register1          */
  __I  uint32_t REG00;             /*!< Conversion Result Store Register0            */
  __I  uint32_t REG01;             /*!< Conversion Result Store Register1            */
  __I  uint32_t REG02;             /*!< Conversion Result Store Register2            */
  __I  uint32_t REG03;             /*!< Conversion Result Store Register3            */
  __I  uint32_t REG04;             /*!< Conversion Result Store Register4            */
  __I  uint32_t REG05;             /*!< Conversion Result Store Register5            */
  __I  uint32_t REG06;             /*!< Conversion Result Store Register6            */
  __I  uint32_t REG07;             /*!< Conversion Result Store Register7            */
  __I  uint32_t REG08;             /*!< Conversion Result Store Register8            */
  __I  uint32_t REG09;             /*!< Conversion Result Store Register9            */
  __I  uint32_t REG10;             /*!< Conversion Result Store Register10           */
  __I  uint32_t REG11;             /*!< Conversion Result Store Register11           */
       uint32_t RESERVED0[4];
  __I  uint32_t REGSP;             /*!< Highest Priority Conversion Result Store Register*/
} TSB_AD_TypeDef;

/**
  * @brief 12bit A/D Converter for PSC
  */
typedef struct
{
       uint32_t RESERVED0[13];
  __I  uint32_t REG00;             /*!< Conversion Result Store Register0            */
  __I  uint32_t REG01;             /*!< Conversion Result Store Register1            */
  __I  uint32_t REG02;             /*!< Conversion Result Store Register2            */
  __I  uint32_t REG03;             /*!< Conversion Result Store Register3            */
  __I  uint32_t REG04;             /*!< Conversion Result Store Register4            */
  __I  uint32_t REG05;             /*!< Conversion Result Store Register5            */
  __I  uint32_t REG06;             /*!< Conversion Result Store Register6            */
  __I  uint32_t REG07;             /*!< Conversion Result Store Register7            */
       uint32_t RESERVED1[8];
  __I  uint32_t REGSP;             /*!< Highest Priority Conversion Result Store Register*/
} TSB_AD_MIR_TypeDef;

/**
  * @brief 10bit D/A Converter
  */
typedef struct
{
  __IO uint32_t CTL;               /*!< Control Register                             */
  __IO uint32_t REG;               /*!< Output Register                              */
} TSB_DA_TypeDef;

/**
  * @brief Timer D-common
  */
typedef struct
{
       uint32_t RESERVED0[16];
  __IO uint32_t BCR;               /*!< Update Flag Setting Register                 */
       uint32_t RESERVED1[3];
  __IO uint32_t EN;                /*!< Timer Enable Register                        */
  __IO uint32_t CONF;              /*!< Timer Configuration Register                 */
} TSB_TD_TypeDef;

/**
  * @brief Timer D-unit0
  */
typedef struct
{
  __IO uint32_t RUN;               /*!< Timer Run Register (unit0)                   */
  __IO uint32_t CR;                /*!< Timer Control Register (unit0)               */
  __IO uint32_t MOD;               /*!< Timer Mode Register (unit0)                  */
  __IO uint32_t DMA;               /*!< DMA Request Enable Register (unit0)          */
       uint32_t RESERVED0;
  __IO uint32_t RG0;               /*!< Timer Register0 (unit0)                      */
  __IO uint32_t RG1;               /*!< Timer Register1 (unit0)                      */
  __IO uint32_t RG2;               /*!< Timer Register2 (unit0)                      */
  __IO uint32_t RG3;               /*!< Timer Register3 (unit0)                      */
  __IO uint32_t RG4;               /*!< Timer Register4 (unit0)                      */
  __IO uint32_t RG5;               /*!< Timer Register5 (unit0)                      */
       uint32_t RESERVED1[58];
  __I  uint32_t CP0;               /*!< Compare Register0 (unit0)                    */
  __I  uint32_t CP1;               /*!< Compare Register1 (unit0)                    */
  __I  uint32_t CP2;               /*!< Compare Register2 (unit0)                    */
  __I  uint32_t CP3;               /*!< Compare Register3 (unit0)                    */
  __IO uint32_t CP4;               /*!< Compare Register4 (unit0)                    */
  __I  uint32_t CP5;               /*!< Compare Register5 (unit0)                    */
} TSB_TD0_TypeDef;

/**
  * @brief Timer D-unit1
  */
typedef struct
{
       uint32_t RESERVED0[11];
  __IO uint32_t RG0;               /*!< Timer Register0 (unit1)                      */
  __IO uint32_t RG1;               /*!< Timer Register1 (unit1)                      */
  __IO uint32_t RG2;               /*!< Timer Register2 (unit1)                      */
  __IO uint32_t RG3;               /*!< Timer Register3 (unit1)                      */
  __IO uint32_t RG4;               /*!< Timer Register4 (unit1)                      */
       uint32_t RESERVED1[48];
  __IO uint32_t RUN;               /*!< Timer Run Register (unit1)                   */
  __IO uint32_t CR;                /*!< Timer Control Register (unit1)               */
  __IO uint32_t MOD;               /*!< Timer Mode Register (unit1)                  */
  __IO uint32_t DMA;               /*!< DMA Request Enable Register (unit1)          */
       uint32_t RESERVED2[7];
  __I  uint32_t CP0;               /*!< Compare Register0 (unit1)                    */
  __I  uint32_t CP1;               /*!< Compare Register1 (unit1)                    */
  __I  uint32_t CP2;               /*!< Compare Register2 (unit1)                    */
  __I  uint32_t CP3;               /*!< Compare Register3 (unit1)                    */
  __IO uint32_t CP4;               /*!< Compare Register4 (unit1)                    */
} TSB_TD1_TypeDef;

/**
  * @brief External Bus Interface(EXB)
  */
typedef struct
{
  __IO uint32_t MOD;               /*!< External Bus Mode Register                   */
       uint32_t RESERVED0[3];
  __IO uint32_t AS0;               /*!< External Bus Base Address and CS Space setting Register 0*/
  __IO uint32_t AS1;               /*!< External Bus Base Address and CS Space setting Register 1*/
  __IO uint32_t AS2;               /*!< External Bus Base Address and CS Space setting Register 2*/
  __IO uint32_t AS3;               /*!< External Bus Base Address and CS Space setting Register 3*/
       uint32_t RESERVED1[8];
  __IO uint32_t CS0;               /*!< Chip Select and Wait Controller Register 0   */
  __IO uint32_t CS1;               /*!< Chip Select and Wait Controller Register 1   */
  __IO uint32_t CS2;               /*!< Chip Select and Wait Controller Register 2   */
  __IO uint32_t CS3;               /*!< Chip Select and Wait Controller Register 3   */
} TSB_EXB_TypeDef;

/**
  * @brief Enhannced Two Aspect Pulse Input Counter (Enhannced 2-Phase Pulse Input Timer) (EPHC) for CPU
  */
typedef struct
{
  __IO uint32_t EN;                /*!< EPHC Enable Register                         */
  __IO uint32_t CNT;               /*!< EPHC Control Register                        */
  __IO uint32_t IE;                /*!< EPHC Interrupt Enable Register               */
  __IO uint32_t FLG;               /*!< EPHC Status Register                         */
  __IO uint32_t ARUN;              /*!< EPHC 16-bit Counter Run Register             */
  __IO uint32_t ACP0;              /*!< EPHC Pulse Counter Compare 0 Register        */
  __IO uint32_t ACP1;              /*!< EPHC Pulse Counter Compare 1 Register        */
  __IO uint32_t ADAT;              /*!< EPHC 16-bit Counter Read Register            */
  __IO uint32_t BRUN;              /*!< EPHC 24-bit Counter Run Register             */
  __IO uint32_t BDMA;              /*!< EPHC DMAE Request Enable Register            */
  __I  uint32_t BUC;               /*!< EPHC 24-bit Counter Read Register            */
       uint32_t RESERVED0;
  __I  uint32_t BCAP00;            /*!< EPHC Capture 00 Register                     */
  __I  uint32_t BCAP10;            /*!< EPHC Capture 10 Register                     */
  __I  uint32_t BCAP20;            /*!< EPHC Capture 20 Register                     */
  __I  uint32_t BCAP30;            /*!< EPHC Capture 30 Register                     */
  __I  uint32_t B0DAT;             /*!< EPHC Cycle 0 Register                        */
  __I  uint32_t B1DAT;             /*!< EPHC Cycle 1 Register                        */
  __I  uint32_t B2DAT;             /*!< EPHC Cycle 2 Register                        */
  __I  uint32_t B3DAT;             /*!< EPHC Cycle 3 Register                        */
  __I  uint32_t BCDAT;             /*!< EPHC Cycle Common Register                   */
       uint32_t RESERVED1[3];
  __I  uint32_t B0PDT;             /*!< EPHC Phase DifferEPHCe 0 Register            */
  __I  uint32_t B1PDT;             /*!< EPHC Phase DifferEPHCe 1 Register            */
  __I  uint32_t B2PDT;             /*!< EPHC Phase DifferEPHCe 2 Register            */
  __I  uint32_t B3PDT;             /*!< EPHC Phase DifferEPHCe 3 Register            */
} TSB_EPHC_TypeDef;

/**
  * @brief Enhannced Two Aspect Pulse Input Counter (Enhannced 2-Phase Pulse Input Timer) (EPHC) for PSC
  */
typedef struct
{
       uint32_t RESERVED0[7];
  __IO uint32_t ADAT;              /*!< EPHC 16-bit Counter Read Register            */
       uint32_t RESERVED1[2];
  __I  uint32_t BUC;               /*!< EPHC 24-bit Counter Read Register            */
       uint32_t RESERVED2;
  __I  uint32_t BCAP00;            /*!< EPHC Capture 00 Register                     */
  __I  uint32_t BCAP10;            /*!< EPHC Capture 10 Register                     */
  __I  uint32_t BCAP20;            /*!< EPHC Capture 20 Register                     */
  __I  uint32_t BCAP30;            /*!< EPHC Capture 30 Register                     */
  __I  uint32_t B0DAT;             /*!< EPHC Cycle 0 Register                        */
  __I  uint32_t B1DAT;             /*!< EPHC Cycle 1 Register                        */
  __I  uint32_t B2DAT;             /*!< EPHC Cycle 2 Register                        */
  __I  uint32_t B3DAT;             /*!< EPHC Cycle 3 Register                        */
  __I  uint32_t BCDAT;             /*!< EPHC Cycle Common Register                   */
       uint32_t RESERVED3[3];
  __I  uint32_t B0PDT;             /*!< EPHC Phase DifferEPHCe 0 Register            */
  __I  uint32_t B1PDT;             /*!< EPHC Phase DifferEPHCe 1 Register            */
  __I  uint32_t B2PDT;             /*!< EPHC Phase DifferEPHCe 2 Register            */
  __I  uint32_t B3PDT;             /*!< EPHC Phase DifferEPHCe 3 Register            */
} TSB_EPHC_MIR_TypeDef;

/**
  * @brief Enhannced Serial I/O (ESIO)
  */
typedef struct
{
  __IO uint32_t CR0;               /*!< ESIO Control Register 0                      */
  __IO uint32_t CR1;               /*!< ESIO Control Register 1                      */
  __IO uint32_t CR2;               /*!< ESIO Control Register 2                      */
  __IO uint32_t CR3;               /*!< ESIO Control Register 3                      */
  __IO uint32_t BR;                /*!< ESIO Baud Rate Generator Control Register    */
  __IO uint32_t FMTR0;             /*!< ESIO Format Control Register 0               */
  __IO uint32_t FMTR1;             /*!< ESIO Format Control Register 1               */
       uint32_t RESERVED0[57];
  __IO uint32_t DR;                /*!< ESIO Data Register                           */
       uint32_t RESERVED1[63];
  __IO uint32_t SR;                /*!< ESIO Status Register                         */
  __IO uint32_t PERR;              /*!< ESIO Parity Error Flag Register              */
  __IO uint32_t HPERR0;            /*!< ESIO Horizontal Parity Error Register 0      */
  __IO uint32_t HPERR1;            /*!< ESIO Horizontal Parity Error Register 1      */
  __IO uint32_t HPERR2;            /*!< ESIO Horizontal Parity Error Register 2      */
  __IO uint32_t HPERR3;            /*!< ESIO Horizontal Parity Error Register 3      */
  __IO uint32_t VPERR;             /*!< ESIO Vertical Parity Error Frame Number Register*/
} TSB_ESIO_TypeDef;

/**
  * @brief Port A
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port A Data Register                         */
  __IO uint32_t CR;                /*!< Port A Output Control Register               */
  __IO uint32_t FR1;               /*!< Port A Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port A Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port A Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port A Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port A Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port A Input Control Register                */
} TSB_PA_TypeDef;

/**
  * @brief Port B
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port B Data Register                         */
  __IO uint32_t CR;                /*!< Port B Output Control Register               */
  __IO uint32_t FR1;               /*!< Port B Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port B Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port B Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port B Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port B Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port B Input Control Register                */
} TSB_PB_TypeDef;

/**
  * @brief Port C
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port C Data Register                         */
  __IO uint32_t CR;                /*!< Port C Output Control Register               */
  __IO uint32_t FR1;               /*!< Port C Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port C Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port C Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port C Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port C Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port C Input Control Register                */
} TSB_PC_TypeDef;

/**
  * @brief Port D
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port D Data Register                         */
  __IO uint32_t CR;                /*!< Port D Output Control Register               */
  __IO uint32_t FR1;               /*!< Port D Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port D Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port D Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port D Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port D Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port D Input Control Register                */
} TSB_PD_TypeDef;

/**
  * @brief Port E
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port E Data Register                         */
  __IO uint32_t CR;                /*!< Port E Output Control Register               */
  __IO uint32_t FR1;               /*!< Port E Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port E Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port E Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port E Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port E Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port E Input Control Register                */
} TSB_PE_TypeDef;

/**
  * @brief Port F
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port F Data Register                         */
  __IO uint32_t CR;                /*!< Port F Output Control Register               */
  __IO uint32_t FR1;               /*!< Port F Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port F Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port F Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port F Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port F Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port F Input Control Register                */
} TSB_PF_TypeDef;

/**
  * @brief Port G
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port G Data Register                         */
  __IO uint32_t CR;                /*!< Port G Output Control Register               */
  __IO uint32_t FR1;               /*!< Port G Function Register 1                   */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port G Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port G Pull-up Control Register              */
  __IO uint32_t PDN;               /*!< Port G Pull-down Control Register            */
       uint32_t RESERVED1;
  __IO uint32_t IE;                /*!< Port G Input Control Register                */
} TSB_PG_TypeDef;

/**
  * @brief Port H
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port H Data Register                         */
  __IO uint32_t CR;                /*!< Port H Output Control Register               */
  __IO uint32_t FR1;               /*!< Port H Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port H Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port H Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port H Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port H Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port H Input Control Register                */
} TSB_PH_TypeDef;

/**
  * @brief Port J
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port J Data Register                         */
  __IO uint32_t CR;                /*!< Port J Output Control Register               */
  __IO uint32_t FR1;               /*!< Port J Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port J Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port J Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port J Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port J Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port J Input Control Register                */
} TSB_PJ_TypeDef;

/**
  * @brief Port K
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port K Data Register                         */
  __IO uint32_t CR;                /*!< Port K Output Control Register               */
  __IO uint32_t FR1;               /*!< Port K Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port K Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port K Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port K Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port K Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port K Input Control Register                */
} TSB_PK_TypeDef;

/**
  * @brief Port L
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port L Data Register                         */
  __IO uint32_t CR;                /*!< Port L Output Control Register               */
  __IO uint32_t FR1;               /*!< Port L Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port L Function Register 2                   */
       uint32_t RESERVED0[6];
  __IO uint32_t OD;                /*!< Port L Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port L Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port L Input Control Register                */
} TSB_PL_TypeDef;

/**
  * @brief Port M
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port M Data Register                         */
  __IO uint32_t CR;                /*!< Port M Output Control Register               */
  __IO uint32_t FR1;               /*!< Port M Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port M Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port M Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port M Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port M Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port M Input Control Register                */
} TSB_PM_TypeDef;

/**
  * @brief Port N
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port N Data Register                         */
  __IO uint32_t CR;                /*!< Port N Output Control Register               */
  __IO uint32_t FR1;               /*!< Port N Function Register 1                   */
       uint32_t RESERVED0;
  __IO uint32_t FR3;               /*!< Port N Function Register 3                   */
       uint32_t RESERVED1[5];
  __IO uint32_t OD;                /*!< Port N Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port N Pull-up Control Register              */
       uint32_t RESERVED2[2];
  __IO uint32_t IE;                /*!< Port N Input Control Register                */
} TSB_PN_TypeDef;

/**
  * @brief Port P
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port P Data Register                         */
  __IO uint32_t CR;                /*!< Port P Output Control Register               */
  __IO uint32_t FR1;               /*!< Port P Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port P Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port P Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port P Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port P Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port P Input Control Register                */
} TSB_PP_TypeDef;

/**
  * @brief Port R
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port R Data Register                         */
  __IO uint32_t CR;                /*!< Port R Output Control Register               */
  __IO uint32_t FR1;               /*!< Port R Function Register 1                   */
  __IO uint32_t FR2;               /*!< Port R Function Register 2                   */
  __IO uint32_t FR3;               /*!< Port R Function Register 3                   */
       uint32_t RESERVED0[5];
  __IO uint32_t OD;                /*!< Port R Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port R Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port R Input Control Register                */
} TSB_PR_TypeDef;

/**
  * @brief Port T
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port T Data Register                         */
  __IO uint32_t CR;                /*!< Port T Output Control Register               */
  __IO uint32_t FR1;               /*!< Port T Function Register 1                   */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port T Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port T Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port T Input Control Register                */
} TSB_PT_TypeDef;

/**
  * @brief Port U
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port U Data Register                         */
  __IO uint32_t CR;                /*!< Port U Output Control Register               */
  __IO uint32_t FR1;               /*!< Port U Function Register 1                   */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port U Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port U Pull-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port U Input Control Register                */
} TSB_PU_TypeDef;

/**
  * @brief Port V
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port V Data Register                         */
  __IO uint32_t CR;                /*!< Port V OutPVt Control Register               */
  __IO uint32_t FR1;               /*!< Port V Function Register 1                   */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port V Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port V PVll-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port V InPVt Control Register                */
} TSB_PV_TypeDef;

/**
  * @brief Port W
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port W Data Register                         */
  __IO uint32_t CR;                /*!< Port W OutPWt Control Register               */
  __IO uint32_t FR1;               /*!< Port W Function Register 1                   */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port W Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port W PWll-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port W InPWt Control Register                */
} TSB_PW_TypeDef;

/**
  * @brief Port Y
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port Y Data Register                         */
  __IO uint32_t CR;                /*!< Port Y OutPYt Control Register               */
  __IO uint32_t FR1;               /*!< Port Y Function Register 1                   */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port Y Open Drain Control Register           */
  __IO uint32_t PUP;               /*!< Port Y PYll-up Control Register              */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port Y InPYt Control Register                */
} TSB_PY_TypeDef;

/**
  * @brief Port AA
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port AA Data Register                        */
  __IO uint32_t CR;                /*!< Port AA OutPAAt Control Register             */
  __IO uint32_t FR1;               /*!< Port AA Function Register 1                  */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port AA Open Drain Control Register          */
  __IO uint32_t PUP;               /*!< Port AA PAAll-up Control Register            */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port AA InPAAt Control Register              */
} TSB_PAA_TypeDef;

/**
  * @brief Port AB
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port AB Data Register                        */
  __IO uint32_t CR;                /*!< Port AB OutPABt Control Register             */
  __IO uint32_t FR1;               /*!< Port AB Function Register 1                  */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port AB Open Drain Control Register          */
  __IO uint32_t PUP;               /*!< Port AB PABll-up Control Register            */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port AB InPABt Control Register              */
} TSB_PAB_TypeDef;

/**
  * @brief Port AC
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port AC Data Register                        */
  __IO uint32_t CR;                /*!< Port AC OutPACt Control Register             */
  __IO uint32_t FR1;               /*!< Port AC Function Register 1                  */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port AC Open Drain Control Register          */
  __IO uint32_t PUP;               /*!< Port AC PACll-up Control Register            */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port AC InPACt Control Register              */
} TSB_PAC_TypeDef;

/**
  * @brief Port AD
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port AD Data Register                        */
  __IO uint32_t CR;                /*!< Port AD OutPADt Control Register             */
  __IO uint32_t FR1;               /*!< Port AD Function Register 1                  */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port AD Open Drain Control Register          */
  __IO uint32_t PUP;               /*!< Port AD PADll-up Control Register            */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port AD InPADt Control Register              */
} TSB_PAD_TypeDef;

/**
  * @brief Port AE
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port AE Data Register                        */
  __IO uint32_t CR;                /*!< Port AE OutPAEt Control Register             */
  __IO uint32_t FR1;               /*!< Port AE Function Register 1                  */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port AE Open Drain Control Register          */
  __IO uint32_t PAEP;              /*!< Port AE PAEll-up Control Register            */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port AE InPAEt Control Register              */
} TSB_PAE_TypeDef;

/**
  * @brief Port AF
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port AF Data Register                        */
  __IO uint32_t CR;                /*!< Port AF OutPAFt Control Register             */
  __IO uint32_t FR1;               /*!< Port AF Function Register 1                  */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port AF Open Drain Control Register          */
  __IO uint32_t PUP;               /*!< Port AF PAFll-up Control Register            */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port AF InPAFt Control Register              */
} TSB_PAF_TypeDef;

/**
  * @brief Port AG
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port AG Data Register                        */
  __IO uint32_t CR;                /*!< Port AG OutPAGt Control Register             */
  __IO uint32_t FR1;               /*!< Port AG Function Register 1                  */
  __IO uint32_t FR2;               /*!< Port AG Function Register 2                  */
       uint32_t RESERVED0[6];
  __IO uint32_t OD;                /*!< Port AG Open Drain Control Register          */
  __IO uint32_t PUP;               /*!< Port AG PAGll-up Control Register            */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port AG InPAGt Control Register              */
} TSB_PAG_TypeDef;

/**
  * @brief Port AH
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port AH Data Register                        */
  __IO uint32_t CR;                /*!< Port AH OutPAHt Control Register             */
  __IO uint32_t FR1;               /*!< Port AH Function Register 1                  */
  __IO uint32_t FR2;               /*!< Port AH Function Register 2                  */
       uint32_t RESERVED0[6];
  __IO uint32_t OD;                /*!< Port AH Open Drain Control Register          */
  __IO uint32_t PUP;               /*!< Port AH PAHll-up Control Register            */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port AH InPAHt Control Register              */
} TSB_PAH_TypeDef;

/**
  * @brief Port AJ
  */
typedef struct
{
  __IO uint32_t DATA;              /*!< Port AJ Data Register                        */
  __IO uint32_t CR;                /*!< Port AJ OutPAJt Control Register             */
  __IO uint32_t FR1;               /*!< Port AJ Function Register 1                  */
       uint32_t RESERVED0[7];
  __IO uint32_t OD;                /*!< Port AJ Open Drain Control Register          */
  __IO uint32_t PUP;               /*!< Port AJ PAJll-up Control Register            */
       uint32_t RESERVED1[2];
  __IO uint32_t IE;                /*!< Port AJ InPAJt Control Register              */
} TSB_PAJ_TypeDef;

/**
  * @brief 16-bit Timer/Event Counter (TB)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< TB Enable Register                           */
  __IO uint32_t RUN;               /*!< TB RUN Register                              */
  __IO uint32_t CR;                /*!< TB Control Register                          */
  __IO uint32_t MOD;               /*!< TB Mode Register                             */
  __IO uint32_t FFCR;              /*!< TB Flip-Flop Control Register                */
  __I  uint32_t ST;                /*!< TB Status Register                           */
  __IO uint32_t IM;                /*!< TB Interrupt Mask Register                   */
  __I  uint32_t UC;                /*!< TB Read Capture Register                     */
  __IO uint32_t RG0;               /*!< TB RG0 Timer Register                        */
  __IO uint32_t RG1;               /*!< TB RG1 Timer Register                        */
  __I  uint32_t CP0;               /*!< TB CP0 Capture Register                      */
  __I  uint32_t CP1;               /*!< TB CP1 Capture Register                      */
  __IO uint32_t DMA;               /*!< TB DMA Enable Register                       */
} TSB_TB_TypeDef;

/**
  * @brief 32-bit Timer (TC)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< TC Enable Register                           */
  __IO uint32_t TBTRUN;            /*!< TC RUN Register                              */
  __IO uint32_t TBTCR;             /*!< TC Control Register                          */
  __I  uint32_t TBTCP;             /*!< TC TBT Capture Register                      */
  __I  uint32_t TBTRDCP;           /*!< TC TBT Read Capture Register                 */
       uint32_t RESERVED0[3];
  __IO uint32_t CMPCTL0;           /*!< TC Compare Control Register0                 */
  __IO uint32_t CMP0;              /*!< TC Compare Register0                         */
       uint32_t RESERVED1[2];
  __IO uint32_t CMPCTL1;           /*!< TC Compare Control Register1                 */
  __IO uint32_t CMP1;              /*!< TC Compare Register1                         */
       uint32_t RESERVED2[2];
  __IO uint32_t CMPCTL2;           /*!< TC Compare Control Register2                 */
  __IO uint32_t CMP2;              /*!< TC Compare Register2                         */
       uint32_t RESERVED3[2];
  __IO uint32_t CMPCTL3;           /*!< TC Compare Control Register3                 */
  __IO uint32_t CMP3;              /*!< TC Compare Register3                         */
       uint32_t RESERVED4[2];
  __IO uint32_t CMPCTL4;           /*!< TC Compare Control Register4                 */
  __IO uint32_t CMP4;              /*!< TC Compare Register4                         */
       uint32_t RESERVED5[2];
  __IO uint32_t CMPCTL5;           /*!< TC Compare Control Register5                 */
  __IO uint32_t CMP5;              /*!< TC Compare Register5                         */
       uint32_t RESERVED6[2];
  __IO uint32_t CMPCTL6;           /*!< TC Compare Control Register6                 */
  __IO uint32_t CMP6;              /*!< TC Compare Register6                         */
       uint32_t RESERVED7[2];
  __IO uint32_t CMPCTL7;           /*!< TC Compare Control Register7                 */
  __IO uint32_t CMP7;              /*!< TC Compare Register7                         */
       uint32_t RESERVED8[2];
  __IO uint32_t CAPCR0;            /*!< TC Capture Control Register0                 */
  __I  uint32_t CAP0;              /*!< TC Capture Register0                         */
       uint32_t RESERVED9[2];
  __IO uint32_t CAPCR1;            /*!< TC Capture Control Register1                 */
  __I  uint32_t CAP1;              /*!< TC Capture Register1                         */
       uint32_t RESERVED10[2];
  __IO uint32_t CAPCR2;            /*!< TC Capture Control Register2                 */
  __I  uint32_t CAP2;              /*!< TC Capture Register2                         */
       uint32_t RESERVED11[2];
  __IO uint32_t CAPCR3;            /*!< TC Capture Control Register3                 */
  __I  uint32_t CAP3;              /*!< TC Capture Register3                         */
} TSB_TC_TypeDef;

/**
  * @brief Two-phase Pulse Input Count
  */
typedef struct
{
  __IO uint32_t RUN;               /*!< Two-phase Pulse Input Count Run Register     */
  __IO uint32_t CR;                /*!< Two-phase Pulse Input Count Control Register */
  __IO uint32_t EN;                /*!< Two-phase Pulse Input Count Timer Enable Register */
  __IO uint32_t FLG;               /*!< Two-phase Pulse Input Count Status Register  */
  __IO uint32_t CMP0;              /*!< Two-phase Pulse Input Count Compare Register 0 */
  __IO uint32_t CMP1;              /*!< Two-phase Pulse Input Count Compare Register 1*/
  __I  uint32_t CNT;               /*!< Two-phase Pulse Input Count Counter Read Register*/
  __IO uint32_t DMA;               /*!< Two-phase Pulse Input Count DMA Enable Register*/
} TSB_PHC_TypeDef;

/**
  * @brief Real Time Clock (RTC)
  */
typedef struct
{
  __IO uint8_t  SECR;              /*!< RTC Second Column Register                   */
  __IO uint8_t  MINR;              /*!< RTC Minute Column Register                   */
  __IO uint8_t  HOURR;             /*!< RTC Hour Column Register                     */
       uint8_t  RESERVED0;
  __IO uint8_t  DAYR;              /*!< RTC Day of the Week Column Register          */
  __IO uint8_t  DATER;             /*!< RTC Day Column Register                      */
  __IO uint8_t  MONTHR;            /*!< RTC Month Column Register                    */
  __IO uint8_t  YEARR;             /*!< RTC Year Column Register                     */
  __IO uint8_t  PAGER;             /*!< RTC PAGE Register                            */
       uint8_t  RESERVED1[3];
  __IO uint8_t  RESTR;             /*!< RTC Reset Register                           */
} TSB_RTC_TypeDef;

/**
  * @brief Serial Bus Interface (SBI)
  */
typedef struct
{
  __IO uint32_t CR0;               /*!< SBI Control Register 0                       */
  __IO uint32_t CR1;               /*!< SBI Control Register 1 (I2C Mode)            */
  __IO uint32_t DBR;               /*!< SBI Data Buffer Register                     */
  __IO uint32_t I2CAR;             /*!< SBI I2C Bus Address Register                 */
union {
  __O  uint32_t CR2;               /*!< SBI Control Register 2 (I2C Mode)            */
  __I  uint32_t SR;                /*!< SBI Status Register (I2C Mode)               */
  };
  __IO uint32_t BR0;               /*!< SBI Baud Rate Register 0                     */
} TSB_SBI_TypeDef;

/**
  * @brief Serial Channel (SC)
  */
typedef struct
{
  __IO uint32_t EN;                /*!< SC Enable Register                           */
  __IO uint32_t BUF;               /*!< SC Buffer Register                           */
  __IO uint32_t CR;                /*!< SC Control Register                          */
  __IO uint32_t MOD0;              /*!< SC Mode Control Register 0                   */
  __IO uint32_t BRCR;              /*!< SC Baud Rate Generator Control Register      */
  __IO uint32_t BRADD;             /*!< SC Baud Rate Generator Control Register 2    */
  __IO uint32_t MOD1;              /*!< SC Mode Control Register 1                   */
  __IO uint32_t MOD2;              /*!< SC Mode Control Register 2                   */
  __IO uint32_t RFC;               /*!< SC RX FIFO Configuration Register            */
  __IO uint32_t TFC;               /*!< SC TX FIFO Configuration Register            */
  __I  uint32_t RST;               /*!< SC RX FIFO Status Register                   */
  __I  uint32_t TST;               /*!< SC TX FIFO Status Register                   */
  __IO uint32_t FCNF;              /*!< SC FIFO Configuration Register               */
  __IO uint32_t DMA;               /*!< SC DMA Enable Register                       */
} TSB_SC_TypeDef;

/**
  * @brief Watchdog Timer (WD)
  */
typedef struct
{
  __IO uint32_t MOD;               /*!< WD Mode Register                             */
  __O  uint32_t CR;                /*!< WD Control Register                          */
} TSB_WD_TypeDef;

/**
  * @brief Clock Generator (CG)
  */
typedef struct
{
  __IO uint32_t SYSCR;             /*!< System Control Register                      */
  __IO uint32_t OSCCR;             /*!< Oscillation Control Register                 */
  __IO uint32_t STBYCR;            /*!< Standby Control Register                     */
  __IO uint32_t PLLSEL;            /*!< PLL Selection Register                       */
  __IO uint32_t CKSEL;             /*!< System Clock Selection Register              */
  __IO uint32_t PWMGEAR;           /*!< Timer D Clock Setting Register               */
       uint32_t RESERVED0[2];
  __IO uint32_t LKMSKA;            /*!< fclk Supply Stop Register A                  */
  __IO uint32_t LKMSKB;            /*!< fclk Supply Stop Register B                  */
  __IO uint32_t CMSKA;             /*!< fc Supply Stop Register A                    */
  __IO uint32_t CMSKB;             /*!< fc Supply Stop Register B                    */
       uint32_t RESERVED1[3];
  __IO uint32_t PROTECT;           /*!< Protect Register                             */
  __IO uint32_t IMCGA;             /*!< CG Interrupt Mode Control Register A         */
  __IO uint32_t IMCGB;             /*!< CG Interrupt Mode Control Register B         */
  __IO uint32_t IMCGC;             /*!< CG Interrupt Mode Control Register C         */
  __IO uint32_t IMCGD;             /*!< CG Interrupt Mode Control Register D         */
  __IO uint32_t IMCGE;             /*!< CG Interrupt Mode Control Register E         */
  __IO uint32_t IMCGF;             /*!< CG Interrupt Mode Control Register F         */
  __IO uint32_t IMCGG;             /*!< CG Interrupt Mode Control Register G         */
  __IO uint32_t IMCGH;             /*!< CG Interrupt Mode Control Register H         */
  __O  uint32_t ICRCG;             /*!< CG Interrupt Request Clear Register          */
  __IO uint32_t RSTFLG;            /*!< Reset Flag Register                          */
} TSB_CG_TypeDef;

/**
  * @brief Key Matrix Scan
  */
typedef struct
{
  __IO uint32_t EN;                /*!< Enable Register                              */
  __IO uint32_t ICR;               /*!< Key Input Control Register                   */
  __IO uint32_t OCR;               /*!< Key Output Control Register                  */
  __IO uint32_t CR;                /*!< Control Register                             */
  __IO uint32_t CTR;               /*!< Count Register                               */
  __I  uint32_t BR0;               /*!< Buffer0 Register                             */
  __I  uint32_t BR1;               /*!< Buffer1 Register                             */
  __IO uint32_t BMR0;              /*!< Buffer0 Mask Register                        */
  __IO uint32_t BMR1;              /*!< Buffer1 Mask Register                        */
  __IO uint32_t INTCR;             /*!< Interrupt Control Register                   */
} TSB_KS_TypeDef;

/**
  * @brief Key On Wake Up
  */
typedef struct
{
  __IO uint32_t CR0;               /*!< Control Register 0                           */
  __IO uint32_t CR1;               /*!< Control Register 1                           */
  __IO uint32_t CR2;               /*!< Control Register 2                           */
  __IO uint32_t CR3;               /*!< Control Register 3                           */
  __IO uint32_t CR4;               /*!< Control Register 4                           */
  __IO uint32_t CR5;               /*!< Control Register 5                           */
  __IO uint32_t CR6;               /*!< Control Register 6                           */
  __IO uint32_t CR7;               /*!< Control Register 7                           */
  __IO uint32_t CR8;               /*!< Control Register 8                           */
  __IO uint32_t CR9;               /*!< Control Register 9                           */
  __IO uint32_t CR10;              /*!< Control Register 10                          */
  __IO uint32_t CR11;              /*!< Control Register 11                          */
  __IO uint32_t CR12;              /*!< Control Register 12                          */
  __IO uint32_t CR13;              /*!< Control Register 13                          */
  __IO uint32_t CR14;              /*!< Control Register 14                          */
  __IO uint32_t CR15;              /*!< Control Register 15                          */
  __IO uint32_t CR16;              /*!< Control Register 16                          */
  __IO uint32_t CR17;              /*!< Control Register 17                          */
  __IO uint32_t CR18;              /*!< Control Register 18                          */
  __IO uint32_t CR19;              /*!< Control Register 19                          */
  __IO uint32_t CR20;              /*!< Control Register 20                          */
  __IO uint32_t CR21;              /*!< Control Register 21                          */
  __IO uint32_t CR22;              /*!< Control Register 22                          */
  __IO uint32_t CR23;              /*!< Control Register 23                          */
  __IO uint32_t CR24;              /*!< Control Register 24                          */
  __IO uint32_t CR25;              /*!< Control Register 25                          */
  __IO uint32_t CR26;              /*!< Control Register 26                          */
  __IO uint32_t CR27;              /*!< Control Register 27                          */
  __IO uint32_t CR28;              /*!< Control Register 28                          */
  __IO uint32_t CR29;              /*!< Control Register 29                          */
  __IO uint32_t CR30;              /*!< Control Register 30                          */
  __IO uint32_t CR31;              /*!< Control Register 31                          */
  __I  uint32_t PKEY;              /*!< Port Monitor Register                        */
  __IO uint32_t CNT;               /*!< Control Register                             */
  __O  uint32_t CLR;               /*!< Interrupt All Clear Register                 */
  __I  uint32_t INT;               /*!< Interrupt Monitor Register                   */
} TSB_KWUP_TypeDef;

/**
  * @brief Flash Control (FC)
  */
typedef struct
{
       uint32_t RESERVED0[4];
  __IO uint32_t SECBIT;            /*!< Security Bit Register                        */
       uint32_t RESERVED1[2];
  __IO uint32_t CR;                /*!< Control Register                             */
  __I  uint32_t SR;                /*!< Flash Status Register                        */
       uint32_t RESERVED2[3];
  __I  uint32_t PSRA;              /*!< Flash Protect Status Register A              */
  __I  uint32_t PSRB;              /*!< Flash Protect Status Register B              */
} TSB_FC_TypeDef;


/* Memory map */
#define FLASH_BASE            (0x00000000UL)
#define RAM_BASE              (0x20000000UL)
#define PERI_BASE             (0x40000000UL)


#define TSB_DMACA_BASE             (PERI_BASE  + 0x0000000UL)
#define TSB_DMACB_BASE             (PERI_BASE  + 0x0001000UL)
#define TSB_DMACC_BASE             (PERI_BASE  + 0x0002000UL)
#define TSB_DMAC_BASE              (PERI_BASE  + 0x405F000UL)
#define TSB_PSC_BASE               (PERI_BASE  + 0x0018000UL)
#define TSB_SSP_BASE               (PERI_BASE  + 0x0040000UL)
#define TSB_UART0_BASE             (PERI_BASE  + 0x4048000UL)
#define TSB_UART1_BASE             (PERI_BASE  + 0x4049000UL)
#define TSB_ADA_BASE               (PERI_BASE  + 0x4050000UL)
#define TSB_ADB_BASE               (PERI_BASE  + 0x4051000UL)
#define TSB_ADC_BASE               (PERI_BASE  + 0x4052000UL)
#define TSB_AD_MIRA_BASE           (PERI_BASE  + 0x0074000UL)
#define TSB_AD_MIRB_BASE           (PERI_BASE  + 0x0079000UL)
#define TSB_AD_MIRC_BASE           (PERI_BASE  + 0x007A000UL)
#define TSB_DAA_BASE               (PERI_BASE  + 0x4054000UL)
#define TSB_DAB_BASE               (PERI_BASE  + 0x4055000UL)
#define TSB_TD_BASE                (PERI_BASE  + 0x0058000UL)
#define TSB_TD0_BASE               (PERI_BASE  + 0x0058000UL)
#define TSB_TD1_BASE               (PERI_BASE  + 0x0058000UL)
#define TSB_EXB_BASE               (PERI_BASE  + 0x405C000UL)
#define TSB_EPHC_BASE              (PERI_BASE  + 0x4060000UL)
#define TSB_EPHC_MIR_BASE          (PERI_BASE  + 0x0075000UL)
#define TSB_ESIO0_BASE             (PERI_BASE  + 0x406A000UL)
#define TSB_ESIO1_BASE             (PERI_BASE  + 0x406B000UL)
#define TSB_ESIO2_BASE             (PERI_BASE  + 0x406C000UL)
#define TSB_PA_BASE                (PERI_BASE  + 0x00C0000UL)
#define TSB_PB_BASE                (PERI_BASE  + 0x00C0100UL)
#define TSB_PC_BASE                (PERI_BASE  + 0x00C0200UL)
#define TSB_PD_BASE                (PERI_BASE  + 0x00C0300UL)
#define TSB_PE_BASE                (PERI_BASE  + 0x00C0400UL)
#define TSB_PF_BASE                (PERI_BASE  + 0x00C0500UL)
#define TSB_PG_BASE                (PERI_BASE  + 0x00C0600UL)
#define TSB_PH_BASE                (PERI_BASE  + 0x00C0700UL)
#define TSB_PJ_BASE                (PERI_BASE  + 0x00C0800UL)
#define TSB_PK_BASE                (PERI_BASE  + 0x00C0900UL)
#define TSB_PL_BASE                (PERI_BASE  + 0x00C0A00UL)
#define TSB_PM_BASE                (PERI_BASE  + 0x00C0B00UL)
#define TSB_PN_BASE                (PERI_BASE  + 0x00C0C00UL)
#define TSB_PP_BASE                (PERI_BASE  + 0x00C0D00UL)
#define TSB_PR_BASE                (PERI_BASE  + 0x00C0E00UL)
#define TSB_PT_BASE                (PERI_BASE  + 0x00C0F00UL)
#define TSB_PU_BASE                (PERI_BASE  + 0x00C1000UL)
#define TSB_PV_BASE                (PERI_BASE  + 0x00C1100UL)
#define TSB_PW_BASE                (PERI_BASE  + 0x00C1200UL)
#define TSB_PY_BASE                (PERI_BASE  + 0x00C1300UL)
#define TSB_PAA_BASE               (PERI_BASE  + 0x00C1400UL)
#define TSB_PAB_BASE               (PERI_BASE  + 0x00C1500UL)
#define TSB_PAC_BASE               (PERI_BASE  + 0x00C1600UL)
#define TSB_PAD_BASE               (PERI_BASE  + 0x00C1700UL)
#define TSB_PAE_BASE               (PERI_BASE  + 0x00C1800UL)
#define TSB_PAF_BASE               (PERI_BASE  + 0x00C1900UL)
#define TSB_PAG_BASE               (PERI_BASE  + 0x00C1A00UL)
#define TSB_PAH_BASE               (PERI_BASE  + 0x00C1B00UL)
#define TSB_PAJ_BASE               (PERI_BASE  + 0x00C1C00UL)
#define TSB_TB0_BASE               (PERI_BASE  + 0x40C4000UL)
#define TSB_TB1_BASE               (PERI_BASE  + 0x40C4100UL)
#define TSB_TB2_BASE               (PERI_BASE  + 0x40C4200UL)
#define TSB_TB3_BASE               (PERI_BASE  + 0x40C4300UL)
#define TSB_TB4_BASE               (PERI_BASE  + 0x40C4400UL)
#define TSB_TB5_BASE               (PERI_BASE  + 0x40C4500UL)
#define TSB_TB6_BASE               (PERI_BASE  + 0x40C4600UL)
#define TSB_TB7_BASE               (PERI_BASE  + 0x40C4700UL)
#define TSB_TB8_BASE               (PERI_BASE  + 0x40C4800UL)
#define TSB_TB9_BASE               (PERI_BASE  + 0x40C4900UL)
#define TSB_TB10_BASE              (PERI_BASE  + 0x00C5000UL)
#define TSB_TB11_BASE              (PERI_BASE  + 0x00C5100UL)
#define TSB_TB12_BASE              (PERI_BASE  + 0x00C5200UL)
#define TSB_TB13_BASE              (PERI_BASE  + 0x00C5300UL)
#define TSB_TB14_BASE              (PERI_BASE  + 0x00C5400UL)
#define TSB_TB15_BASE              (PERI_BASE  + 0x00C5500UL)
#define TSB_TB16_BASE              (PERI_BASE  + 0x00C5600UL)
#define TSB_TB17_BASE              (PERI_BASE  + 0x00C5700UL)
#define TSB_TB18_BASE              (PERI_BASE  + 0x00C5800UL)
#define TSB_TB19_BASE              (PERI_BASE  + 0x00C5900UL)
#define TSB_TC_BASE                (PERI_BASE  + 0x40CE000UL)
#define TSB_PHC0_BASE              (PERI_BASE  + 0x00CA000UL)
#define TSB_PHC1_BASE              (PERI_BASE  + 0x00CA100UL)
#define TSB_RTC_BASE               (PERI_BASE  + 0x00CC000UL)
#define TSB_SBI_BASE               (PERI_BASE  + 0x00E0000UL)
#define TSB_SC0_BASE               (PERI_BASE  + 0x40E1000UL)
#define TSB_SC1_BASE               (PERI_BASE  + 0x40E1100UL)
#define TSB_SC2_BASE               (PERI_BASE  + 0x40E1200UL)
#define TSB_SC3_BASE               (PERI_BASE  + 0x40E1300UL)
#define TSB_SC4_BASE               (PERI_BASE  + 0x40E1400UL)
#define TSB_SC5_BASE               (PERI_BASE  + 0x40E1500UL)
#define TSB_WD_BASE                (PERI_BASE  + 0x00F2000UL)
#define TSB_CG_BASE                (PERI_BASE  + 0x00F3000UL)
#define TSB_KS_BASE                (PERI_BASE  + 0x00FA000UL)
#define TSB_KWUPA_BASE             (PERI_BASE  + 0x00FB000UL)
#define TSB_KWUPB_BASE             (PERI_BASE  + 0x00FB100UL)
#define TSB_FC_BASE                (PERI_BASE  + 0x1FFF000UL)


/* Peripheral declaration */
#define TSB_DMACA                  ((   TSB_DMAC_TypeDef *) TSB_DMACA_BASE)
#define TSB_DMACB                  ((   TSB_DMAC_TypeDef *) TSB_DMACB_BASE)
#define TSB_DMACC                  ((   TSB_DMAC_TypeDef *) TSB_DMACC_BASE)
#define TSB_DMAC                   ((   TSB_DMAC_TypeDef *)  TSB_DMAC_BASE)
#define TSB_PSC                    ((    TSB_PSC_TypeDef *)   TSB_PSC_BASE)
#define TSB_SSP                    ((    TSB_SSP_TypeDef *)   TSB_SSP_BASE)
#define TSB_UART0                  ((   TSB_UART_TypeDef *) TSB_UART0_BASE)
#define TSB_UART1                  ((   TSB_UART_TypeDef *) TSB_UART1_BASE)
#define TSB_ADA                    ((     TSB_AD_TypeDef *)   TSB_ADA_BASE)
#define TSB_ADB                    ((     TSB_AD_TypeDef *)   TSB_ADB_BASE)
#define TSB_ADC                    ((     TSB_AD_TypeDef *)   TSB_ADC_BASE)
#define TSB_AD_MIRA                (( TSB_AD_MIR_TypeDef *)TSB_AD_MIRA_BASE)
#define TSB_AD_MIRB                (( TSB_AD_MIR_TypeDef *)TSB_AD_MIRB_BASE)
#define TSB_AD_MIRC                (( TSB_AD_MIR_TypeDef *)TSB_AD_MIRC_BASE)
#define TSB_DAA                    ((     TSB_DA_TypeDef *)   TSB_DAA_BASE)
#define TSB_DAB                    ((     TSB_DA_TypeDef *)   TSB_DAB_BASE)
#define TSB_TD                     ((     TSB_TD_TypeDef *)    TSB_TD_BASE)
#define TSB_TD0                    ((    TSB_TD0_TypeDef *)   TSB_TD0_BASE)
#define TSB_TD1                    ((    TSB_TD1_TypeDef *)   TSB_TD1_BASE)
#define TSB_EXB                    ((    TSB_EXB_TypeDef *)   TSB_EXB_BASE)
#define TSB_EPHC                   ((   TSB_EPHC_TypeDef *)  TSB_EPHC_BASE)
#define TSB_EPHC_MIR               ((TSB_EPHC_MIR_TypeDef *)TSB_EPHC_MIR_BASE)
#define TSB_ESIO0                  ((   TSB_ESIO_TypeDef *) TSB_ESIO0_BASE)
#define TSB_ESIO1                  ((   TSB_ESIO_TypeDef *) TSB_ESIO1_BASE)
#define TSB_ESIO2                  ((   TSB_ESIO_TypeDef *) TSB_ESIO2_BASE)
#define TSB_PA                     ((     TSB_PA_TypeDef *)    TSB_PA_BASE)
#define TSB_PB                     ((     TSB_PB_TypeDef *)    TSB_PB_BASE)
#define TSB_PC                     ((     TSB_PC_TypeDef *)    TSB_PC_BASE)
#define TSB_PD                     ((     TSB_PD_TypeDef *)    TSB_PD_BASE)
#define TSB_PE                     ((     TSB_PE_TypeDef *)    TSB_PE_BASE)
#define TSB_PF                     ((     TSB_PF_TypeDef *)    TSB_PF_BASE)
#define TSB_PG                     ((     TSB_PG_TypeDef *)    TSB_PG_BASE)
#define TSB_PH                     ((     TSB_PH_TypeDef *)    TSB_PH_BASE)
#define TSB_PJ                     ((     TSB_PJ_TypeDef *)    TSB_PJ_BASE)
#define TSB_PK                     ((     TSB_PK_TypeDef *)    TSB_PK_BASE)
#define TSB_PL                     ((     TSB_PL_TypeDef *)    TSB_PL_BASE)
#define TSB_PM                     ((     TSB_PM_TypeDef *)    TSB_PM_BASE)
#define TSB_PN                     ((     TSB_PN_TypeDef *)    TSB_PN_BASE)
#define TSB_PP                     ((     TSB_PP_TypeDef *)    TSB_PP_BASE)
#define TSB_PR                     ((     TSB_PR_TypeDef *)    TSB_PR_BASE)
#define TSB_PT                     ((     TSB_PT_TypeDef *)    TSB_PT_BASE)
#define TSB_PU                     ((     TSB_PU_TypeDef *)    TSB_PU_BASE)
#define TSB_PV                     ((     TSB_PV_TypeDef *)    TSB_PV_BASE)
#define TSB_PW                     ((     TSB_PW_TypeDef *)    TSB_PW_BASE)
#define TSB_PY                     ((     TSB_PY_TypeDef *)    TSB_PY_BASE)
#define TSB_PAA                    ((    TSB_PAA_TypeDef *)   TSB_PAA_BASE)
#define TSB_PAB                    ((    TSB_PAB_TypeDef *)   TSB_PAB_BASE)
#define TSB_PAC                    ((    TSB_PAC_TypeDef *)   TSB_PAC_BASE)
#define TSB_PAD                    ((    TSB_PAD_TypeDef *)   TSB_PAD_BASE)
#define TSB_PAE                    ((    TSB_PAE_TypeDef *)   TSB_PAE_BASE)
#define TSB_PAF                    ((    TSB_PAF_TypeDef *)   TSB_PAF_BASE)
#define TSB_PAG                    ((    TSB_PAG_TypeDef *)   TSB_PAG_BASE)
#define TSB_PAH                    ((    TSB_PAH_TypeDef *)   TSB_PAH_BASE)
#define TSB_PAJ                    ((    TSB_PAJ_TypeDef *)   TSB_PAJ_BASE)
#define TSB_TB0                    ((     TSB_TB_TypeDef *)   TSB_TB0_BASE)
#define TSB_TB1                    ((     TSB_TB_TypeDef *)   TSB_TB1_BASE)
#define TSB_TB2                    ((     TSB_TB_TypeDef *)   TSB_TB2_BASE)
#define TSB_TB3                    ((     TSB_TB_TypeDef *)   TSB_TB3_BASE)
#define TSB_TB4                    ((     TSB_TB_TypeDef *)   TSB_TB4_BASE)
#define TSB_TB5                    ((     TSB_TB_TypeDef *)   TSB_TB5_BASE)
#define TSB_TB6                    ((     TSB_TB_TypeDef *)   TSB_TB6_BASE)
#define TSB_TB7                    ((     TSB_TB_TypeDef *)   TSB_TB7_BASE)
#define TSB_TB8                    ((     TSB_TB_TypeDef *)   TSB_TB8_BASE)
#define TSB_TB9                    ((     TSB_TB_TypeDef *)   TSB_TB9_BASE)
#define TSB_TB10                   ((     TSB_TB_TypeDef *)  TSB_TB10_BASE)
#define TSB_TB11                   ((     TSB_TB_TypeDef *)  TSB_TB11_BASE)
#define TSB_TB12                   ((     TSB_TB_TypeDef *)  TSB_TB12_BASE)
#define TSB_TB13                   ((     TSB_TB_TypeDef *)  TSB_TB13_BASE)
#define TSB_TB14                   ((     TSB_TB_TypeDef *)  TSB_TB14_BASE)
#define TSB_TB15                   ((     TSB_TB_TypeDef *)  TSB_TB15_BASE)
#define TSB_TB16                   ((     TSB_TB_TypeDef *)  TSB_TB16_BASE)
#define TSB_TB17                   ((     TSB_TB_TypeDef *)  TSB_TB17_BASE)
#define TSB_TB18                   ((     TSB_TB_TypeDef *)  TSB_TB18_BASE)
#define TSB_TB19                   ((     TSB_TB_TypeDef *)  TSB_TB19_BASE)
#define TSB_TC                     ((     TSB_TC_TypeDef *)    TSB_TC_BASE)
#define TSB_PHC0                   ((    TSB_PHC_TypeDef *)  TSB_PHC0_BASE)
#define TSB_PHC1                   ((    TSB_PHC_TypeDef *)  TSB_PHC1_BASE)
#define TSB_RTC                    ((    TSB_RTC_TypeDef *)   TSB_RTC_BASE)
#define TSB_SBI                    ((    TSB_SBI_TypeDef *)   TSB_SBI_BASE)
#define TSB_SC0                    ((     TSB_SC_TypeDef *)   TSB_SC0_BASE)
#define TSB_SC1                    ((     TSB_SC_TypeDef *)   TSB_SC1_BASE)
#define TSB_SC2                    ((     TSB_SC_TypeDef *)   TSB_SC2_BASE)
#define TSB_SC3                    ((     TSB_SC_TypeDef *)   TSB_SC3_BASE)
#define TSB_SC4                    ((     TSB_SC_TypeDef *)   TSB_SC4_BASE)
#define TSB_SC5                    ((     TSB_SC_TypeDef *)   TSB_SC5_BASE)
#define TSB_WD                     ((     TSB_WD_TypeDef *)    TSB_WD_BASE)
#define TSB_CG                     ((     TSB_CG_TypeDef *)    TSB_CG_BASE)
#define TSB_KS                     ((     TSB_KS_TypeDef *)    TSB_KS_BASE)
#define TSB_KWUPA                  ((   TSB_KWUP_TypeDef *) TSB_KWUPA_BASE)
#define TSB_KWUPB                  ((   TSB_KWUP_TypeDef *) TSB_KWUPB_BASE)
#define TSB_FC                     ((     TSB_FC_TypeDef *)    TSB_FC_BASE)


/* Bit-Band for Device Specific Peripheral Registers */
#define BITBAND_OFFSET (0x02000000UL)
#define BITBAND_PERI_BASE (PERI_BASE + BITBAND_OFFSET)
#define BITBAND_PERI(addr, bitnum) (BITBAND_PERI_BASE + (((uint32_t)(addr) - PERI_BASE) << 5) + ((uint32_t)(bitnum) << 2))



/* DMA Controller */
#define TSB_DMACA_INTSTATUS_INTSTATUS0            (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->INTSTATUS,0)))
#define TSB_DMACA_INTSTATUS_INTSTATUS1            (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->INTSTATUS,1)))
#define TSB_DMACA_INTTCSTATUS_INTTCSTATUS0        (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->INTTCSTATUS,0)))
#define TSB_DMACA_INTTCSTATUS_INTTCSTATUS1        (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->INTTCSTATUS,1)))
#define TSB_DMACA_INTERRORSTATUS_INTERRSTATUS0    (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->INTERRORSTATUS,0)))
#define TSB_DMACA_INTERRORSTATUS_INTERRSTATUS1    (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->INTERRORSTATUS,1)))
#define TSB_DMACA_RAWINTTCSTATUS_RAMINTTCS0       (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->RAWINTTCSTATUS,0)))
#define TSB_DMACA_RAWINTTCSTATUS_RAMINTTCS1       (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->RAWINTTCSTATUS,1)))
#define TSB_DMACA_RAWINTERRORSTATUS_RAWINTERRS0   (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->RAWINTERRORSTATUS,0)))
#define TSB_DMACA_RAWINTERRORSTATUS_RAWINTERRS1   (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->RAWINTERRORSTATUS,1)))
#define TSB_DMACA_ENBLDCHNS_ENABLEDCH0            (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->ENBLDCHNS,0)))
#define TSB_DMACA_ENBLDCHNS_ENABLEDCH1            (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->ENBLDCHNS,1)))
#define TSB_DMACA_CONFIGURATION_E                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->CONFIGURATION,0)))
#define TSB_DMACA_CONFIGURATION_M                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->CONFIGURATION,1)))
#define TSB_DMACA_C0CONTROL_SI                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C0CONTROL,26)))
#define TSB_DMACA_C0CONTROL_DI                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C0CONTROL,27)))
#define TSB_DMACA_C0CONTROL_I                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C0CONTROL,31)))
#define TSB_DMACA_C0CONFIGURATION_E               (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C0CONFIGURATION,0)))
#define TSB_DMACA_C0CONFIGURATION_IE              (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C0CONFIGURATION,14)))
#define TSB_DMACA_C0CONFIGURATION_ITC             (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C0CONFIGURATION,15)))
#define TSB_DMACA_C0CONFIGURATION_LOCK            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C0CONFIGURATION,16)))
#define TSB_DMACA_C0CONFIGURATION_ACTIVE          (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->C0CONFIGURATION,17)))
#define TSB_DMACA_C0CONFIGURATION_HALT            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C0CONFIGURATION,18)))
#define TSB_DMACA_C1CONTROL_SI                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C1CONTROL,26)))
#define TSB_DMACA_C1CONTROL_DI                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C1CONTROL,27)))
#define TSB_DMACA_C1CONTROL_I                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C1CONTROL,31)))
#define TSB_DMACA_C1CONFIGURATION_E               (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C1CONFIGURATION,0)))
#define TSB_DMACA_C1CONFIGURATION_IE              (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C1CONFIGURATION,14)))
#define TSB_DMACA_C1CONFIGURATION_ITC             (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C1CONFIGURATION,15)))
#define TSB_DMACA_C1CONFIGURATION_LOCK            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C1CONFIGURATION,16)))
#define TSB_DMACA_C1CONFIGURATION_ACTIVE          (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACA->C1CONFIGURATION,17)))
#define TSB_DMACA_C1CONFIGURATION_HALT            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACA->C1CONFIGURATION,18)))

#define TSB_DMACB_INTSTATUS_INTSTATUS0            (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->INTSTATUS,0)))
#define TSB_DMACB_INTSTATUS_INTSTATUS1            (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->INTSTATUS,1)))
#define TSB_DMACB_INTTCSTATUS_INTTCSTATUS0        (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->INTTCSTATUS,0)))
#define TSB_DMACB_INTTCSTATUS_INTTCSTATUS1        (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->INTTCSTATUS,1)))
#define TSB_DMACB_INTERRORSTATUS_INTERRSTATUS0    (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->INTERRORSTATUS,0)))
#define TSB_DMACB_INTERRORSTATUS_INTERRSTATUS1    (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->INTERRORSTATUS,1)))
#define TSB_DMACB_RAWINTTCSTATUS_RAMINTTCS0       (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->RAWINTTCSTATUS,0)))
#define TSB_DMACB_RAWINTTCSTATUS_RAMINTTCS1       (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->RAWINTTCSTATUS,1)))
#define TSB_DMACB_RAWINTERRORSTATUS_RAWINTERRS0   (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->RAWINTERRORSTATUS,0)))
#define TSB_DMACB_RAWINTERRORSTATUS_RAWINTERRS1   (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->RAWINTERRORSTATUS,1)))
#define TSB_DMACB_ENBLDCHNS_ENABLEDCH0            (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->ENBLDCHNS,0)))
#define TSB_DMACB_ENBLDCHNS_ENABLEDCH1            (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->ENBLDCHNS,1)))
#define TSB_DMACB_CONFIGURATION_E                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->CONFIGURATION,0)))
#define TSB_DMACB_CONFIGURATION_M                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->CONFIGURATION,1)))
#define TSB_DMACB_C0CONTROL_SI                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C0CONTROL,26)))
#define TSB_DMACB_C0CONTROL_DI                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C0CONTROL,27)))
#define TSB_DMACB_C0CONTROL_I                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C0CONTROL,31)))
#define TSB_DMACB_C0CONFIGURATION_E               (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C0CONFIGURATION,0)))
#define TSB_DMACB_C0CONFIGURATION_IE              (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C0CONFIGURATION,14)))
#define TSB_DMACB_C0CONFIGURATION_ITC             (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C0CONFIGURATION,15)))
#define TSB_DMACB_C0CONFIGURATION_LOCK            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C0CONFIGURATION,16)))
#define TSB_DMACB_C0CONFIGURATION_ACTIVE          (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->C0CONFIGURATION,17)))
#define TSB_DMACB_C0CONFIGURATION_HALT            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C0CONFIGURATION,18)))
#define TSB_DMACB_C1CONTROL_SI                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C1CONTROL,26)))
#define TSB_DMACB_C1CONTROL_DI                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C1CONTROL,27)))
#define TSB_DMACB_C1CONTROL_I                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C1CONTROL,31)))
#define TSB_DMACB_C1CONFIGURATION_E               (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C1CONFIGURATION,0)))
#define TSB_DMACB_C1CONFIGURATION_IE              (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C1CONFIGURATION,14)))
#define TSB_DMACB_C1CONFIGURATION_ITC             (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C1CONFIGURATION,15)))
#define TSB_DMACB_C1CONFIGURATION_LOCK            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C1CONFIGURATION,16)))
#define TSB_DMACB_C1CONFIGURATION_ACTIVE          (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACB->C1CONFIGURATION,17)))
#define TSB_DMACB_C1CONFIGURATION_HALT            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACB->C1CONFIGURATION,18)))

#define TSB_DMACC_INTSTATUS_INTSTATUS0            (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->INTSTATUS,0)))
#define TSB_DMACC_INTSTATUS_INTSTATUS1            (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->INTSTATUS,1)))
#define TSB_DMACC_INTTCSTATUS_INTTCSTATUS0        (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->INTTCSTATUS,0)))
#define TSB_DMACC_INTTCSTATUS_INTTCSTATUS1        (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->INTTCSTATUS,1)))
#define TSB_DMACC_INTERRORSTATUS_INTERRSTATUS0    (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->INTERRORSTATUS,0)))
#define TSB_DMACC_INTERRORSTATUS_INTERRSTATUS1    (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->INTERRORSTATUS,1)))
#define TSB_DMACC_RAWINTTCSTATUS_RAMINTTCS0       (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->RAWINTTCSTATUS,0)))
#define TSB_DMACC_RAWINTTCSTATUS_RAMINTTCS1       (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->RAWINTTCSTATUS,1)))
#define TSB_DMACC_RAWINTERRORSTATUS_RAWINTERRS0   (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->RAWINTERRORSTATUS,0)))
#define TSB_DMACC_RAWINTERRORSTATUS_RAWINTERRS1   (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->RAWINTERRORSTATUS,1)))
#define TSB_DMACC_ENBLDCHNS_ENABLEDCH0            (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->ENBLDCHNS,0)))
#define TSB_DMACC_ENBLDCHNS_ENABLEDCH1            (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->ENBLDCHNS,1)))
#define TSB_DMACC_CONFIGURATION_E                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->CONFIGURATION,0)))
#define TSB_DMACC_CONFIGURATION_M                 (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->CONFIGURATION,1)))
#define TSB_DMACC_C0CONTROL_SI                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C0CONTROL,26)))
#define TSB_DMACC_C0CONTROL_DI                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C0CONTROL,27)))
#define TSB_DMACC_C0CONTROL_I                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C0CONTROL,31)))
#define TSB_DMACC_C0CONFIGURATION_E               (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C0CONFIGURATION,0)))
#define TSB_DMACC_C0CONFIGURATION_IE              (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C0CONFIGURATION,14)))
#define TSB_DMACC_C0CONFIGURATION_ITC             (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C0CONFIGURATION,15)))
#define TSB_DMACC_C0CONFIGURATION_LOCK            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C0CONFIGURATION,16)))
#define TSB_DMACC_C0CONFIGURATION_ACTIVE          (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->C0CONFIGURATION,17)))
#define TSB_DMACC_C0CONFIGURATION_HALT            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C0CONFIGURATION,18)))
#define TSB_DMACC_C1CONTROL_SI                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C1CONTROL,26)))
#define TSB_DMACC_C1CONTROL_DI                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C1CONTROL,27)))
#define TSB_DMACC_C1CONTROL_I                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C1CONTROL,31)))
#define TSB_DMACC_C1CONFIGURATION_E               (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C1CONFIGURATION,0)))
#define TSB_DMACC_C1CONFIGURATION_IE              (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C1CONFIGURATION,14)))
#define TSB_DMACC_C1CONFIGURATION_ITC             (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C1CONFIGURATION,15)))
#define TSB_DMACC_C1CONFIGURATION_LOCK            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C1CONFIGURATION,16)))
#define TSB_DMACC_C1CONFIGURATION_ACTIVE          (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMACC->C1CONFIGURATION,17)))
#define TSB_DMACC_C1CONFIGURATION_HALT            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMACC->C1CONFIGURATION,18)))

#define TSB_DMAC_REDGE_DEDGEA                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->REDGE,0)))
#define TSB_DMAC_REDGE_DEDGEB                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->REDGE,1)))
#define TSB_DMAC_REDGE_DEDGEC                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_DMAC->REDGE,2)))
#define TSB_DMAC_RCLR_DCLR0                       (*((__O  uint32_t *)BITBAND_PERI(&TSB_DMAC->RCLR,0)))
#define TSB_DMAC_RCLR_DCLR1                       (*((__O  uint32_t *)BITBAND_PERI(&TSB_DMAC->RCLR,1)))
#define TSB_DMAC_RCLR_DCLR2                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_DMAC->RCLR,2)))
#define TSB_DMAC_RCLR_DCLR8                       (*((__O  uint32_t *)BITBAND_PERI(&TSB_DMAC->RCLR,8)))
#define TSB_DMAC_RCLR_DCLR9                       (*((__O  uint32_t *)BITBAND_PERI(&TSB_DMAC->RCLR,9)))
#define TSB_DMAC_RCLR_DCLR16                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_DMAC->RCLR,16)))
#define TSB_DMAC_RCLR_DCLR17                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_DMAC->RCLR,17)))
#define TSB_DMAC_RCLR_DCLR18                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_DMAC->RCLR,18)))
#define TSB_DMAC_RCLR_DCLR19                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_DMAC->RCLR,19)))


/* Programmable Servo Controller  */
#define TSB_PSC_SGN_SA0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->SGN,16)))
#define TSB_PSC_SGN_SM0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->SGN,17)))
#define TSB_PSC_SGN_SM1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->SGN,18)))
#define TSB_PSC_SGN_SL0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->SGN,19)))
#define TSB_PSC_SGN_SL1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->SGN,20)))
#define TSB_PSC_SGN_SR0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->SGN,21)))
#define TSB_PSC_SGN_SR1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->SGN,22)))
#define TSB_PSC_CNT_START                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->CNT,16)))
#define TSB_PSC_CNT_TENB                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->CNT,17)))
#define TSB_PSC_CNT_STEP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->CNT,24)))
#define TSB_PSC_CNT_BRK                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->CNT,25)))
#define TSB_PSC_FLG_OVER                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->FLG,16)))
#define TSB_PSC_FLG_UNDER                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->FLG,17)))
#define TSB_PSC_FLG_ZERO                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->FLG,24)))
#define TSB_PSC_REN_INTEN0                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,0)))
#define TSB_PSC_REN_INTEN1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,1)))
#define TSB_PSC_REN_INTEN2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,2)))
#define TSB_PSC_REN_INTEN3                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,3)))
#define TSB_PSC_REN_INTEN4                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,4)))
#define TSB_PSC_REN_INTEN5                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,5)))
#define TSB_PSC_REN_INTEN6                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,6)))
#define TSB_PSC_REN_INTEN7                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,7)))
#define TSB_PSC_REN_INTEN8                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,8)))
#define TSB_PSC_REN_INTEN9                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,9)))
#define TSB_PSC_REN_INTEN10                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,10)))
#define TSB_PSC_REN_INTEN11                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,11)))
#define TSB_PSC_REN_INTEN12                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,12)))
#define TSB_PSC_REN_INTEN13                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,13)))
#define TSB_PSC_REN_INTEN14                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,14)))
#define TSB_PSC_REN_INTEN15                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,15)))
#define TSB_PSC_REN_INTEG0                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,16)))
#define TSB_PSC_REN_INTEG1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,17)))
#define TSB_PSC_REN_INTEG2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,18)))
#define TSB_PSC_REN_INTEG3                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PSC->REN,19)))
#define TSB_PSC_RFLG_INTFLG0                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,0)))
#define TSB_PSC_RFLG_INTFLG1                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,1)))
#define TSB_PSC_RFLG_INTFLG2                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,2)))
#define TSB_PSC_RFLG_INTFLG3                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,3)))
#define TSB_PSC_RFLG_INTFLG4                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,4)))
#define TSB_PSC_RFLG_INTFLG5                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,5)))
#define TSB_PSC_RFLG_INTFLG6                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,6)))
#define TSB_PSC_RFLG_INTFLG7                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,7)))
#define TSB_PSC_RFLG_INTFLG8                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,8)))
#define TSB_PSC_RFLG_INTFLG9                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,9)))
#define TSB_PSC_RFLG_INTFLG10                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,10)))
#define TSB_PSC_RFLG_INTFLG11                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,11)))
#define TSB_PSC_RFLG_INTFLG12                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,12)))
#define TSB_PSC_RFLG_INTFLG13                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,13)))
#define TSB_PSC_RFLG_INTFLG14                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,14)))
#define TSB_PSC_RFLG_INTFLG15                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,15)))
#define TSB_PSC_RFLG_INTOVRF0                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,16)))
#define TSB_PSC_RFLG_INTOVRF1                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,17)))
#define TSB_PSC_RFLG_INTOVRF2                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,18)))
#define TSB_PSC_RFLG_INTOVRF3                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,19)))
#define TSB_PSC_RFLG_INTOVRF4                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,20)))
#define TSB_PSC_RFLG_INTOVRF5                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,21)))
#define TSB_PSC_RFLG_INTOVRF6                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,22)))
#define TSB_PSC_RFLG_INTOVRF7                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,23)))
#define TSB_PSC_RFLG_INTOVRF8                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,24)))
#define TSB_PSC_RFLG_INTOVRF9                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,25)))
#define TSB_PSC_RFLG_INTOVRF10                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,26)))
#define TSB_PSC_RFLG_INTOVRF11                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,27)))
#define TSB_PSC_RFLG_INTOVRF12                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,28)))
#define TSB_PSC_RFLG_INTOVRF13                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,29)))
#define TSB_PSC_RFLG_INTOVRF14                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,30)))
#define TSB_PSC_RFLG_INTOVRF15                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_PSC->RFLG,31)))
#define TSB_PSC_RCLR_INTCLR0                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,0)))
#define TSB_PSC_RCLR_INTCLR1                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,1)))
#define TSB_PSC_RCLR_INTCLR2                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,2)))
#define TSB_PSC_RCLR_INTCLR3                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,3)))
#define TSB_PSC_RCLR_INTCLR4                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,4)))
#define TSB_PSC_RCLR_INTCLR5                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,5)))
#define TSB_PSC_RCLR_INTCLR6                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,6)))
#define TSB_PSC_RCLR_INTCLR7                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,7)))
#define TSB_PSC_RCLR_INTCLR8                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,8)))
#define TSB_PSC_RCLR_INTCLR9                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,9)))
#define TSB_PSC_RCLR_INTCLR10                     (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,10)))
#define TSB_PSC_RCLR_INTCLR11                     (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,11)))
#define TSB_PSC_RCLR_INTCLR12                     (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,12)))
#define TSB_PSC_RCLR_INTCLR13                     (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,13)))
#define TSB_PSC_RCLR_INTCLR14                     (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,14)))
#define TSB_PSC_RCLR_INTCLR15                     (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RCLR,15)))
#define TSB_PSC_RSET_INTSET0                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,0)))
#define TSB_PSC_RSET_INTSET1                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,1)))
#define TSB_PSC_RSET_INTSET2                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,2)))
#define TSB_PSC_RSET_INTSET3                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,3)))
#define TSB_PSC_RSET_INTSET4                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,4)))
#define TSB_PSC_RSET_INTSET5                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,5)))
#define TSB_PSC_RSET_INTSET6                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,6)))
#define TSB_PSC_RSET_INTSET7                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,7)))
#define TSB_PSC_RSET_INTSET8                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,8)))
#define TSB_PSC_RSET_INTSET9                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,9)))
#define TSB_PSC_RSET_INTSET10                     (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,10)))
#define TSB_PSC_RSET_INTSET11                     (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,11)))
#define TSB_PSC_RSET_INTSET12                     (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,12)))
#define TSB_PSC_RSET_INTSET13                     (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,13)))
#define TSB_PSC_RSET_INTSET14                     (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,14)))
#define TSB_PSC_RSET_INTSET15                     (*((__O  uint32_t *)BITBAND_PERI(&TSB_PSC->RSET,15)))


/* Synchronous Serial Port */
#define TSB_SSP_CR0_SPO                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP->CR0,6)))
#define TSB_SSP_CR0_SPH                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP->CR0,7)))
#define TSB_SSP_CR1_SSE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP->CR1,1)))
#define TSB_SSP_CR1_MS                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP->CR1,2)))
#define TSB_SSP_CR1_SOD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP->CR1,3)))
#define TSB_SSP_SR_TFE                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP->SR,0)))
#define TSB_SSP_SR_TNF                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP->SR,1)))
#define TSB_SSP_SR_RNE                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP->SR,2)))
#define TSB_SSP_SR_RFF                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP->SR,3)))
#define TSB_SSP_SR_BSY                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP->SR,4)))
#define TSB_SSP_IMSC_RORIM                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP->IMSC,0)))
#define TSB_SSP_IMSC_RTIM                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP->IMSC,1)))
#define TSB_SSP_IMSC_RXIM                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP->IMSC,2)))
#define TSB_SSP_IMSC_TXIM                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP->IMSC,3)))
#define TSB_SSP_RIS_RORRIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP->RIS,0)))
#define TSB_SSP_RIS_RTRIS                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP->RIS,1)))
#define TSB_SSP_RIS_RXRIS                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP->RIS,2)))
#define TSB_SSP_RIS_TXRIS                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP->RIS,3)))
#define TSB_SSP_MIS_RORMIS                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP->MIS,0)))
#define TSB_SSP_MIS_RTMIS                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP->MIS,1)))
#define TSB_SSP_MIS_RXMIS                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP->MIS,2)))
#define TSB_SSP_MIS_TXMIS                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_SSP->MIS,3)))
#define TSB_SSP_ICR_RORIC                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP->ICR,0)))
#define TSB_SSP_ICR_RTIC                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_SSP->ICR,1)))
#define TSB_SSP_DMACR_RXDMAE                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP->DMACR,0)))
#define TSB_SSP_DMACR_TXDMAE                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SSP->DMACR,1)))


/* UART */
#define TSB_UART0_DR_FE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->DR,8)))
#define TSB_UART0_DR_PE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->DR,9)))
#define TSB_UART0_DR_BE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->DR,10)))
#define TSB_UART0_DR_OE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->DR,11)))
#define TSB_UART0_RSR_FE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RSR,0)))
#define TSB_UART0_RSR_PE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RSR,1)))
#define TSB_UART0_RSR_BE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RSR,2)))
#define TSB_UART0_RSR_OE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RSR,3)))
#define TSB_UART0_ECR_FE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ECR,0)))
#define TSB_UART0_ECR_PE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ECR,1)))
#define TSB_UART0_ECR_BE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ECR,2)))
#define TSB_UART0_ECR_OE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ECR,3)))
#define TSB_UART0_FR_CTS                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,0)))
#define TSB_UART0_FR_DSR                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,1)))
#define TSB_UART0_FR_DCD                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,2)))
#define TSB_UART0_FR_BUSY                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,3)))
#define TSB_UART0_FR_RXFE                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,4)))
#define TSB_UART0_FR_TXFF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,5)))
#define TSB_UART0_FR_RXFF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,6)))
#define TSB_UART0_FR_TXFE                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,7)))
#define TSB_UART0_FR_RI                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->FR,8)))
#define TSB_UART0_LCR_H_BRK                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,0)))
#define TSB_UART0_LCR_H_PEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,1)))
#define TSB_UART0_LCR_H_EPS                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,2)))
#define TSB_UART0_LCR_H_STP2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,3)))
#define TSB_UART0_LCR_H_FEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,4)))
#define TSB_UART0_LCR_H_SPS                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->LCR_H,7)))
#define TSB_UART0_CR_UARTEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,0)))
#define TSB_UART0_CR_SIREN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,1)))
#define TSB_UART0_CR_SIRLP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,2)))
#define TSB_UART0_CR_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,8)))
#define TSB_UART0_CR_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,9)))
#define TSB_UART0_CR_DTR                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,10)))
#define TSB_UART0_CR_RTS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,11)))
#define TSB_UART0_CR_RTSEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,14)))
#define TSB_UART0_CR_CTSEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->CR,15)))
#define TSB_UART0_IMSC_RIMIM                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,0)))
#define TSB_UART0_IMSC_CTSMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,1)))
#define TSB_UART0_IMSC_DCDMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,2)))
#define TSB_UART0_IMSC_DSRMIN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,3)))
#define TSB_UART0_IMSC_RXIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,4)))
#define TSB_UART0_IMSC_TXIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,5)))
#define TSB_UART0_IMSC_RTIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,6)))
#define TSB_UART0_IMSC_FEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,7)))
#define TSB_UART0_IMSC_PEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,8)))
#define TSB_UART0_IMSC_BEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,9)))
#define TSB_UART0_IMSC_OEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->IMSC,10)))
#define TSB_UART0_RIS_CTSRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,1)))
#define TSB_UART0_RIS_RXRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,4)))
#define TSB_UART0_RIS_TXRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,5)))
#define TSB_UART0_RIS_RTRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,6)))
#define TSB_UART0_RIS_FERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,7)))
#define TSB_UART0_RIS_PERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,8)))
#define TSB_UART0_RIS_BERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,9)))
#define TSB_UART0_RIS_OERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->RIS,10)))
#define TSB_UART0_MIS_CTSMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,1)))
#define TSB_UART0_MIS_RXMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,4)))
#define TSB_UART0_MIS_TXMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,5)))
#define TSB_UART0_MIS_RTMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,6)))
#define TSB_UART0_MIS_FEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,7)))
#define TSB_UART0_MIS_PEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,8)))
#define TSB_UART0_MIS_BEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,9)))
#define TSB_UART0_MIS_OEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART0->MIS,10)))
#define TSB_UART0_ICR_CTSMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,1)))
#define TSB_UART0_ICR_RXIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,4)))
#define TSB_UART0_ICR_TXIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,5)))
#define TSB_UART0_ICR_RTIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,6)))
#define TSB_UART0_ICR_FEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,7)))
#define TSB_UART0_ICR_PEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,8)))
#define TSB_UART0_ICR_BEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,9)))
#define TSB_UART0_ICR_OEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART0->ICR,10)))
#define TSB_UART0_DMACR_RXDMAE                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->DMACR,0)))
#define TSB_UART0_DMACR_TXDMAE                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->DMACR,1)))
#define TSB_UART0_DMACR_DMAONERR                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART0->DMACR,2)))

#define TSB_UART1_DR_FE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->DR,8)))
#define TSB_UART1_DR_PE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->DR,9)))
#define TSB_UART1_DR_BE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->DR,10)))
#define TSB_UART1_DR_OE                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->DR,11)))
#define TSB_UART1_RSR_FE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RSR,0)))
#define TSB_UART1_RSR_PE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RSR,1)))
#define TSB_UART1_RSR_BE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RSR,2)))
#define TSB_UART1_RSR_OE                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RSR,3)))
#define TSB_UART1_ECR_FE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ECR,0)))
#define TSB_UART1_ECR_PE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ECR,1)))
#define TSB_UART1_ECR_BE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ECR,2)))
#define TSB_UART1_ECR_OE                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ECR,3)))
#define TSB_UART1_FR_CTS                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,0)))
#define TSB_UART1_FR_DSR                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,1)))
#define TSB_UART1_FR_DCD                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,2)))
#define TSB_UART1_FR_BUSY                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,3)))
#define TSB_UART1_FR_RXFE                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,4)))
#define TSB_UART1_FR_TXFF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,5)))
#define TSB_UART1_FR_RXFF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,6)))
#define TSB_UART1_FR_TXFE                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,7)))
#define TSB_UART1_FR_RI                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->FR,8)))
#define TSB_UART1_LCR_H_BRK                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,0)))
#define TSB_UART1_LCR_H_PEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,1)))
#define TSB_UART1_LCR_H_EPS                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,2)))
#define TSB_UART1_LCR_H_STP2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,3)))
#define TSB_UART1_LCR_H_FEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,4)))
#define TSB_UART1_LCR_H_SPS                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->LCR_H,7)))
#define TSB_UART1_CR_UARTEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,0)))
#define TSB_UART1_CR_SIREN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,1)))
#define TSB_UART1_CR_SIRLP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,2)))
#define TSB_UART1_CR_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,8)))
#define TSB_UART1_CR_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,9)))
#define TSB_UART1_CR_DTR                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,10)))
#define TSB_UART1_CR_RTS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,11)))
#define TSB_UART1_CR_RTSEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,14)))
#define TSB_UART1_CR_CTSEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->CR,15)))
#define TSB_UART1_IMSC_RIMIM                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,0)))
#define TSB_UART1_IMSC_CTSMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,1)))
#define TSB_UART1_IMSC_DCDMIM                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,2)))
#define TSB_UART1_IMSC_DSRMIN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,3)))
#define TSB_UART1_IMSC_RXIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,4)))
#define TSB_UART1_IMSC_TXIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,5)))
#define TSB_UART1_IMSC_RTIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,6)))
#define TSB_UART1_IMSC_FEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,7)))
#define TSB_UART1_IMSC_PEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,8)))
#define TSB_UART1_IMSC_BEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,9)))
#define TSB_UART1_IMSC_OEIM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->IMSC,10)))
#define TSB_UART1_RIS_CTSRMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,1)))
#define TSB_UART1_RIS_RXRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,4)))
#define TSB_UART1_RIS_TXRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,5)))
#define TSB_UART1_RIS_RTRIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,6)))
#define TSB_UART1_RIS_FERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,7)))
#define TSB_UART1_RIS_PERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,8)))
#define TSB_UART1_RIS_BERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,9)))
#define TSB_UART1_RIS_OERIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->RIS,10)))
#define TSB_UART1_MIS_CTSMMIS                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,1)))
#define TSB_UART1_MIS_RXMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,4)))
#define TSB_UART1_MIS_TXMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,5)))
#define TSB_UART1_MIS_RTMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,6)))
#define TSB_UART1_MIS_FEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,7)))
#define TSB_UART1_MIS_PEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,8)))
#define TSB_UART1_MIS_BEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,9)))
#define TSB_UART1_MIS_OEMIS                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_UART1->MIS,10)))
#define TSB_UART1_ICR_CTSMIC                      (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,1)))
#define TSB_UART1_ICR_RXIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,4)))
#define TSB_UART1_ICR_TXIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,5)))
#define TSB_UART1_ICR_RTIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,6)))
#define TSB_UART1_ICR_FEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,7)))
#define TSB_UART1_ICR_PEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,8)))
#define TSB_UART1_ICR_BEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,9)))
#define TSB_UART1_ICR_OEIC                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_UART1->ICR,10)))
#define TSB_UART1_DMACR_RXDMAE                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->DMACR,0)))
#define TSB_UART1_DMACR_TXDMAE                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->DMACR,1)))
#define TSB_UART1_DMACR_DMAONERR                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_UART1->DMACR,2)))


/* 12bit A/D Converter */
#define TSB_ADA_MOD0_ADS                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_ADA->MOD0,0)))
#define TSB_ADA_MOD0_HPADS                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_ADA->MOD0,1)))
#define TSB_ADA_MOD1_ADHWE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD1,0)))
#define TSB_ADA_MOD1_ADHWS                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD1,1)))
#define TSB_ADA_MOD1_HPADHWE                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD1,2)))
#define TSB_ADA_MOD1_HPADHWS                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD1,3)))
#define TSB_ADA_MOD1_RCUT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD1,5)))
#define TSB_ADA_MOD1_I2AD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD1,6)))
#define TSB_ADA_MOD1_DACON                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD1,7)))
#define TSB_ADA_MOD3_SCAN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD3,0)))
#define TSB_ADA_MOD3_REPEAT                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD3,1)))
#define TSB_ADA_MOD5_ADBF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->MOD5,0)))
#define TSB_ADA_MOD5_EOCF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->MOD5,1)))
#define TSB_ADA_MOD5_HPADBF                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->MOD5,2)))
#define TSB_ADA_MOD5_HPEOCF                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->MOD5,3)))
#define TSB_ADA_MOD7_INTADDMA                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD7,0)))
#define TSB_ADA_MOD7_INTADHPDMA                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->MOD7,1)))
#define TSB_ADA_CMPCR0_ADBIG0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->CMPCR0,4)))
#define TSB_ADA_CMPCR0_CMPCOND0                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->CMPCR0,5)))
#define TSB_ADA_CMPCR0_CMP0EN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->CMPCR0,7)))
#define TSB_ADA_CMPCR1_ADBIG1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->CMPCR1,4)))
#define TSB_ADA_CMPCR1_CMPCOND1                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->CMPCR1,5)))
#define TSB_ADA_CMPCR1_CMP1EN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADA->CMPCR1,7)))
#define TSB_ADA_REG00_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG00,12)))
#define TSB_ADA_REG00_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG00,13)))
#define TSB_ADA_REG00_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG00,16)))
#define TSB_ADA_REG00_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG00,17)))
#define TSB_ADA_REG01_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG01,12)))
#define TSB_ADA_REG01_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG01,13)))
#define TSB_ADA_REG01_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG01,16)))
#define TSB_ADA_REG01_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG01,17)))
#define TSB_ADA_REG02_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG02,12)))
#define TSB_ADA_REG02_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG02,13)))
#define TSB_ADA_REG02_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG02,16)))
#define TSB_ADA_REG02_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG02,17)))
#define TSB_ADA_REG03_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG03,12)))
#define TSB_ADA_REG03_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG03,13)))
#define TSB_ADA_REG03_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG03,16)))
#define TSB_ADA_REG03_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG03,17)))
#define TSB_ADA_REG04_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG04,12)))
#define TSB_ADA_REG04_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG04,13)))
#define TSB_ADA_REG04_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG04,16)))
#define TSB_ADA_REG04_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG04,17)))
#define TSB_ADA_REG05_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG05,12)))
#define TSB_ADA_REG05_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG05,13)))
#define TSB_ADA_REG05_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG05,16)))
#define TSB_ADA_REG05_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG05,17)))
#define TSB_ADA_REG06_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG06,12)))
#define TSB_ADA_REG06_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG06,13)))
#define TSB_ADA_REG06_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG06,16)))
#define TSB_ADA_REG06_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG06,17)))
#define TSB_ADA_REG07_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG07,12)))
#define TSB_ADA_REG07_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG07,13)))
#define TSB_ADA_REG07_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG07,16)))
#define TSB_ADA_REG07_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG07,17)))
#define TSB_ADA_REG08_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG08,12)))
#define TSB_ADA_REG08_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG08,13)))
#define TSB_ADA_REG08_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG08,16)))
#define TSB_ADA_REG08_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG08,17)))
#define TSB_ADA_REG09_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG09,12)))
#define TSB_ADA_REG09_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG09,13)))
#define TSB_ADA_REG09_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG09,16)))
#define TSB_ADA_REG09_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG09,17)))
#define TSB_ADA_REG10_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG10,12)))
#define TSB_ADA_REG10_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG10,13)))
#define TSB_ADA_REG10_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG10,16)))
#define TSB_ADA_REG10_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG10,17)))
#define TSB_ADA_REG11_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG11,12)))
#define TSB_ADA_REG11_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG11,13)))
#define TSB_ADA_REG11_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG11,16)))
#define TSB_ADA_REG11_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REG11,17)))
#define TSB_ADA_REGSP_ADRFSP                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REGSP,12)))
#define TSB_ADA_REGSP_ADOVFSP                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REGSP,13)))
#define TSB_ADA_REGSP_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REGSP,16)))
#define TSB_ADA_REGSP_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADA->REGSP,17)))

#define TSB_ADB_MOD0_ADS                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_ADB->MOD0,0)))
#define TSB_ADB_MOD0_HPADS                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_ADB->MOD0,1)))
#define TSB_ADB_MOD1_ADHWE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD1,0)))
#define TSB_ADB_MOD1_ADHWS                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD1,1)))
#define TSB_ADB_MOD1_HPADHWE                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD1,2)))
#define TSB_ADB_MOD1_HPADHWS                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD1,3)))
#define TSB_ADB_MOD1_RCUT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD1,5)))
#define TSB_ADB_MOD1_I2AD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD1,6)))
#define TSB_ADB_MOD1_DACON                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD1,7)))
#define TSB_ADB_MOD3_SCAN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD3,0)))
#define TSB_ADB_MOD3_REPEAT                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD3,1)))
#define TSB_ADB_MOD5_ADBF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->MOD5,0)))
#define TSB_ADB_MOD5_EOCF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->MOD5,1)))
#define TSB_ADB_MOD5_HPADBF                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->MOD5,2)))
#define TSB_ADB_MOD5_HPEOCF                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->MOD5,3)))
#define TSB_ADB_MOD7_INTADDMA                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD7,0)))
#define TSB_ADB_MOD7_INTADHPDMA                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->MOD7,1)))
#define TSB_ADB_CMPCR0_ADBIG0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->CMPCR0,4)))
#define TSB_ADB_CMPCR0_CMPCOND0                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->CMPCR0,5)))
#define TSB_ADB_CMPCR0_CMP0EN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->CMPCR0,7)))
#define TSB_ADB_CMPCR1_ADBIG1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->CMPCR1,4)))
#define TSB_ADB_CMPCR1_CMPCOND1                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->CMPCR1,5)))
#define TSB_ADB_CMPCR1_CMP1EN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADB->CMPCR1,7)))
#define TSB_ADB_REG00_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG00,12)))
#define TSB_ADB_REG00_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG00,13)))
#define TSB_ADB_REG00_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG00,16)))
#define TSB_ADB_REG00_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG00,17)))
#define TSB_ADB_REG01_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG01,12)))
#define TSB_ADB_REG01_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG01,13)))
#define TSB_ADB_REG01_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG01,16)))
#define TSB_ADB_REG01_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG01,17)))
#define TSB_ADB_REG02_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG02,12)))
#define TSB_ADB_REG02_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG02,13)))
#define TSB_ADB_REG02_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG02,16)))
#define TSB_ADB_REG02_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG02,17)))
#define TSB_ADB_REG03_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG03,12)))
#define TSB_ADB_REG03_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG03,13)))
#define TSB_ADB_REG03_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG03,16)))
#define TSB_ADB_REG03_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG03,17)))
#define TSB_ADB_REG04_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG04,12)))
#define TSB_ADB_REG04_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG04,13)))
#define TSB_ADB_REG04_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG04,16)))
#define TSB_ADB_REG04_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG04,17)))
#define TSB_ADB_REG05_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG05,12)))
#define TSB_ADB_REG05_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG05,13)))
#define TSB_ADB_REG05_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG05,16)))
#define TSB_ADB_REG05_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG05,17)))
#define TSB_ADB_REG06_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG06,12)))
#define TSB_ADB_REG06_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG06,13)))
#define TSB_ADB_REG06_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG06,16)))
#define TSB_ADB_REG06_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG06,17)))
#define TSB_ADB_REG07_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG07,12)))
#define TSB_ADB_REG07_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG07,13)))
#define TSB_ADB_REG07_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG07,16)))
#define TSB_ADB_REG07_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG07,17)))
#define TSB_ADB_REG08_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG08,12)))
#define TSB_ADB_REG08_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG08,13)))
#define TSB_ADB_REG08_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG08,16)))
#define TSB_ADB_REG08_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG08,17)))
#define TSB_ADB_REG09_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG09,12)))
#define TSB_ADB_REG09_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG09,13)))
#define TSB_ADB_REG09_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG09,16)))
#define TSB_ADB_REG09_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG09,17)))
#define TSB_ADB_REG10_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG10,12)))
#define TSB_ADB_REG10_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG10,13)))
#define TSB_ADB_REG10_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG10,16)))
#define TSB_ADB_REG10_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG10,17)))
#define TSB_ADB_REG11_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG11,12)))
#define TSB_ADB_REG11_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG11,13)))
#define TSB_ADB_REG11_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG11,16)))
#define TSB_ADB_REG11_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REG11,17)))
#define TSB_ADB_REGSP_ADRFSP                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REGSP,12)))
#define TSB_ADB_REGSP_ADOVFSP                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REGSP,13)))
#define TSB_ADB_REGSP_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REGSP,16)))
#define TSB_ADB_REGSP_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADB->REGSP,17)))

#define TSB_ADC_MOD0_ADS                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_ADC->MOD0,0)))
#define TSB_ADC_MOD0_HPADS                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_ADC->MOD0,1)))
#define TSB_ADC_MOD1_ADHWE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->MOD1,0)))
#define TSB_ADC_MOD1_ADHWS                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->MOD1,1)))
#define TSB_ADC_MOD1_HPADHWE                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->MOD1,2)))
#define TSB_ADC_MOD1_HPADHWS                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->MOD1,3)))
#define TSB_ADC_MOD1_RCUT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->MOD1,5)))
#define TSB_ADC_MOD1_I2AD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->MOD1,6)))
#define TSB_ADC_MOD1_DACON                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->MOD1,7)))
#define TSB_ADC_MOD3_SCAN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->MOD3,0)))
#define TSB_ADC_MOD3_REPEAT                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->MOD3,1)))
#define TSB_ADC_MOD5_ADBF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->MOD5,0)))
#define TSB_ADC_MOD5_EOCF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->MOD5,1)))
#define TSB_ADC_MOD5_HPADBF                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->MOD5,2)))
#define TSB_ADC_MOD5_HPEOCF                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->MOD5,3)))
#define TSB_ADC_MOD7_INTADDMA                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->MOD7,0)))
#define TSB_ADC_MOD7_INTADHPDMA                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->MOD7,1)))
#define TSB_ADC_CMPCR0_ADBIG0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->CMPCR0,4)))
#define TSB_ADC_CMPCR0_CMPCOND0                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->CMPCR0,5)))
#define TSB_ADC_CMPCR0_CMP0EN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->CMPCR0,7)))
#define TSB_ADC_CMPCR1_ADBIG1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->CMPCR1,4)))
#define TSB_ADC_CMPCR1_CMPCOND1                   (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->CMPCR1,5)))
#define TSB_ADC_CMPCR1_CMP1EN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ADC->CMPCR1,7)))
#define TSB_ADC_REG00_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG00,12)))
#define TSB_ADC_REG00_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG00,13)))
#define TSB_ADC_REG00_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG00,16)))
#define TSB_ADC_REG00_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG00,17)))
#define TSB_ADC_REG01_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG01,12)))
#define TSB_ADC_REG01_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG01,13)))
#define TSB_ADC_REG01_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG01,16)))
#define TSB_ADC_REG01_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG01,17)))
#define TSB_ADC_REG02_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG02,12)))
#define TSB_ADC_REG02_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG02,13)))
#define TSB_ADC_REG02_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG02,16)))
#define TSB_ADC_REG02_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG02,17)))
#define TSB_ADC_REG03_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG03,12)))
#define TSB_ADC_REG03_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG03,13)))
#define TSB_ADC_REG03_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG03,16)))
#define TSB_ADC_REG03_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG03,17)))
#define TSB_ADC_REG04_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG04,12)))
#define TSB_ADC_REG04_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG04,13)))
#define TSB_ADC_REG04_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG04,16)))
#define TSB_ADC_REG04_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG04,17)))
#define TSB_ADC_REG05_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG05,12)))
#define TSB_ADC_REG05_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG05,13)))
#define TSB_ADC_REG05_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG05,16)))
#define TSB_ADC_REG05_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG05,17)))
#define TSB_ADC_REG06_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG06,12)))
#define TSB_ADC_REG06_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG06,13)))
#define TSB_ADC_REG06_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG06,16)))
#define TSB_ADC_REG06_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG06,17)))
#define TSB_ADC_REG07_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG07,12)))
#define TSB_ADC_REG07_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG07,13)))
#define TSB_ADC_REG07_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG07,16)))
#define TSB_ADC_REG07_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG07,17)))
#define TSB_ADC_REG08_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG08,12)))
#define TSB_ADC_REG08_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG08,13)))
#define TSB_ADC_REG08_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG08,16)))
#define TSB_ADC_REG08_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG08,17)))
#define TSB_ADC_REG09_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG09,12)))
#define TSB_ADC_REG09_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG09,13)))
#define TSB_ADC_REG09_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG09,16)))
#define TSB_ADC_REG09_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG09,17)))
#define TSB_ADC_REG10_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG10,12)))
#define TSB_ADC_REG10_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG10,13)))
#define TSB_ADC_REG10_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG10,16)))
#define TSB_ADC_REG10_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG10,17)))
#define TSB_ADC_REG11_ADRF                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG11,12)))
#define TSB_ADC_REG11_ADOVRF                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG11,13)))
#define TSB_ADC_REG11_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG11,16)))
#define TSB_ADC_REG11_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REG11,17)))
#define TSB_ADC_REGSP_ADRFSP                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REGSP,12)))
#define TSB_ADC_REGSP_ADOVFSP                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REGSP,13)))
#define TSB_ADC_REGSP_ADRF_MR                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REGSP,16)))
#define TSB_ADC_REGSP_ADOVRF_MR                   (*((__I  uint32_t *)BITBAND_PERI(&TSB_ADC->REGSP,17)))


/* 12bit A/D Converter for PSC */
#define TSB_AD_MIRA_REG00_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG00,12)))
#define TSB_AD_MIRA_REG00_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG00,13)))
#define TSB_AD_MIRA_REG00_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG00,16)))
#define TSB_AD_MIRA_REG00_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG00,17)))
#define TSB_AD_MIRA_REG01_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG01,12)))
#define TSB_AD_MIRA_REG01_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG01,13)))
#define TSB_AD_MIRA_REG01_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG01,16)))
#define TSB_AD_MIRA_REG01_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG01,17)))
#define TSB_AD_MIRA_REG02_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG02,12)))
#define TSB_AD_MIRA_REG02_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG02,13)))
#define TSB_AD_MIRA_REG02_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG02,16)))
#define TSB_AD_MIRA_REG02_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG02,17)))
#define TSB_AD_MIRA_REG03_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG03,12)))
#define TSB_AD_MIRA_REG03_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG03,13)))
#define TSB_AD_MIRA_REG03_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG03,16)))
#define TSB_AD_MIRA_REG03_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG03,17)))
#define TSB_AD_MIRA_REG04_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG04,12)))
#define TSB_AD_MIRA_REG04_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG04,13)))
#define TSB_AD_MIRA_REG04_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG04,16)))
#define TSB_AD_MIRA_REG04_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG04,17)))
#define TSB_AD_MIRA_REG05_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG05,12)))
#define TSB_AD_MIRA_REG05_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG05,13)))
#define TSB_AD_MIRA_REG05_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG05,16)))
#define TSB_AD_MIRA_REG05_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG05,17)))
#define TSB_AD_MIRA_REG06_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG06,12)))
#define TSB_AD_MIRA_REG06_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG06,13)))
#define TSB_AD_MIRA_REG06_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG06,16)))
#define TSB_AD_MIRA_REG06_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG06,17)))
#define TSB_AD_MIRA_REG07_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG07,12)))
#define TSB_AD_MIRA_REG07_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG07,13)))
#define TSB_AD_MIRA_REG07_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG07,16)))
#define TSB_AD_MIRA_REG07_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REG07,17)))
#define TSB_AD_MIRA_REGSP_ADRFSP                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REGSP,12)))
#define TSB_AD_MIRA_REGSP_ADOVFSP                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REGSP,13)))
#define TSB_AD_MIRA_REGSP_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REGSP,16)))
#define TSB_AD_MIRA_REGSP_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRA->REGSP,17)))

#define TSB_AD_MIRB_REG00_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG00,12)))
#define TSB_AD_MIRB_REG00_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG00,13)))
#define TSB_AD_MIRB_REG00_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG00,16)))
#define TSB_AD_MIRB_REG00_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG00,17)))
#define TSB_AD_MIRB_REG01_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG01,12)))
#define TSB_AD_MIRB_REG01_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG01,13)))
#define TSB_AD_MIRB_REG01_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG01,16)))
#define TSB_AD_MIRB_REG01_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG01,17)))
#define TSB_AD_MIRB_REG02_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG02,12)))
#define TSB_AD_MIRB_REG02_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG02,13)))
#define TSB_AD_MIRB_REG02_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG02,16)))
#define TSB_AD_MIRB_REG02_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG02,17)))
#define TSB_AD_MIRB_REG03_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG03,12)))
#define TSB_AD_MIRB_REG03_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG03,13)))
#define TSB_AD_MIRB_REG03_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG03,16)))
#define TSB_AD_MIRB_REG03_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG03,17)))
#define TSB_AD_MIRB_REG04_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG04,12)))
#define TSB_AD_MIRB_REG04_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG04,13)))
#define TSB_AD_MIRB_REG04_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG04,16)))
#define TSB_AD_MIRB_REG04_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG04,17)))
#define TSB_AD_MIRB_REG05_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG05,12)))
#define TSB_AD_MIRB_REG05_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG05,13)))
#define TSB_AD_MIRB_REG05_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG05,16)))
#define TSB_AD_MIRB_REG05_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG05,17)))
#define TSB_AD_MIRB_REG06_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG06,12)))
#define TSB_AD_MIRB_REG06_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG06,13)))
#define TSB_AD_MIRB_REG06_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG06,16)))
#define TSB_AD_MIRB_REG06_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG06,17)))
#define TSB_AD_MIRB_REG07_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG07,12)))
#define TSB_AD_MIRB_REG07_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG07,13)))
#define TSB_AD_MIRB_REG07_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG07,16)))
#define TSB_AD_MIRB_REG07_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REG07,17)))
#define TSB_AD_MIRB_REGSP_ADRFSP                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REGSP,12)))
#define TSB_AD_MIRB_REGSP_ADOVFSP                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REGSP,13)))
#define TSB_AD_MIRB_REGSP_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REGSP,16)))
#define TSB_AD_MIRB_REGSP_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRB->REGSP,17)))

#define TSB_AD_MIRC_REG00_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG00,12)))
#define TSB_AD_MIRC_REG00_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG00,13)))
#define TSB_AD_MIRC_REG00_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG00,16)))
#define TSB_AD_MIRC_REG00_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG00,17)))
#define TSB_AD_MIRC_REG01_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG01,12)))
#define TSB_AD_MIRC_REG01_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG01,13)))
#define TSB_AD_MIRC_REG01_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG01,16)))
#define TSB_AD_MIRC_REG01_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG01,17)))
#define TSB_AD_MIRC_REG02_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG02,12)))
#define TSB_AD_MIRC_REG02_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG02,13)))
#define TSB_AD_MIRC_REG02_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG02,16)))
#define TSB_AD_MIRC_REG02_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG02,17)))
#define TSB_AD_MIRC_REG03_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG03,12)))
#define TSB_AD_MIRC_REG03_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG03,13)))
#define TSB_AD_MIRC_REG03_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG03,16)))
#define TSB_AD_MIRC_REG03_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG03,17)))
#define TSB_AD_MIRC_REG04_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG04,12)))
#define TSB_AD_MIRC_REG04_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG04,13)))
#define TSB_AD_MIRC_REG04_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG04,16)))
#define TSB_AD_MIRC_REG04_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG04,17)))
#define TSB_AD_MIRC_REG05_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG05,12)))
#define TSB_AD_MIRC_REG05_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG05,13)))
#define TSB_AD_MIRC_REG05_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG05,16)))
#define TSB_AD_MIRC_REG05_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG05,17)))
#define TSB_AD_MIRC_REG06_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG06,12)))
#define TSB_AD_MIRC_REG06_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG06,13)))
#define TSB_AD_MIRC_REG06_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG06,16)))
#define TSB_AD_MIRC_REG06_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG06,17)))
#define TSB_AD_MIRC_REG07_ADRF                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG07,12)))
#define TSB_AD_MIRC_REG07_ADOVRF                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG07,13)))
#define TSB_AD_MIRC_REG07_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG07,16)))
#define TSB_AD_MIRC_REG07_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REG07,17)))
#define TSB_AD_MIRC_REGSP_ADRFSP                  (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REGSP,12)))
#define TSB_AD_MIRC_REGSP_ADOVFSP                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REGSP,13)))
#define TSB_AD_MIRC_REGSP_ADRF_MR                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REGSP,16)))
#define TSB_AD_MIRC_REGSP_ADOVRF_MR               (*((__I  uint32_t *)BITBAND_PERI(&TSB_AD_MIRC->REGSP,17)))


/* 10bit D/A Converter */
#define TSB_DAA_CTL_OP                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DAA->CTL,0)))
#define TSB_DAA_CTL_VREFON                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DAA->CTL,1)))

#define TSB_DAB_CTL_OP                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_DAB->CTL,0)))
#define TSB_DAB_CTL_VREFON                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_DAB->CTL,1)))


/* Timer D-common */
#define TSB_TD_BCR_TDSFT00                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD->BCR,0)))
#define TSB_TD_BCR_TDSFT01                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD->BCR,1)))
#define TSB_TD_BCR_TDSFT10                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD->BCR,2)))
#define TSB_TD_BCR_TDSFT11                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD->BCR,3)))
#define TSB_TD_BCR_PHSCHG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD->BCR,4)))
#define TSB_TD_EN_TDHALT                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD->EN,5)))
#define TSB_TD_EN_TDEN0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD->EN,6)))
#define TSB_TD_EN_TDEN1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD->EN,7)))
#define TSB_TD_CONF_TDI2TD0                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD->CONF,6)))
#define TSB_TD_CONF_TDI2TD1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD->CONF,7)))


/* Timer D-unit0 */
#define TSB_TD0_RUN_TDRUN                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_TD0->RUN,0)))
#define TSB_TD0_CR_TDRDE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD0->CR,2)))
#define TSB_TD0_CR_TDMDPT00                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD0->CR,4)))
#define TSB_TD0_CR_TDMDPT01                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD0->CR,8)))
#define TSB_TD0_MOD_TDCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD0->MOD,4)))
#define TSB_TD0_MOD_TDIV0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD0->MOD,6)))
#define TSB_TD0_MOD_TDIV1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD0->MOD,7)))
#define TSB_TD0_DMA_DMAEN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD0->DMA,0)))


/* Timer D-unit1 */
#define TSB_TD1_RUN_TDRUN                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_TD1->RUN,0)))
#define TSB_TD1_CR_TDRDE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD1->CR,2)))
#define TSB_TD1_CR_TDMDPT10                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD1->CR,4)))
#define TSB_TD1_CR_TDMDPT11                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD1->CR,8)))
#define TSB_TD1_MOD_TDCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD1->MOD,4)))
#define TSB_TD1_MOD_TDIV0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD1->MOD,6)))
#define TSB_TD1_MOD_TDIV1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD1->MOD,7)))
#define TSB_TD1_DMA_DMAEN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TD1->DMA,0)))


/* External Bus Interface(EXB) */
#define TSB_EXB_MOD_EXBSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->MOD,0)))
#define TSB_EXB_CS0_CSW0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS0,0)))
#define TSB_EXB_CS0_ENDTYPE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS0,7)))
#define TSB_EXB_CS1_CSW0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS1,0)))
#define TSB_EXB_CS1_ENDTYPE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS1,7)))
#define TSB_EXB_CS2_CSW0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS2,0)))
#define TSB_EXB_CS2_ENDTYPE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS2,7)))
#define TSB_EXB_CS3_CSW0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS3,0)))
#define TSB_EXB_CS3_ENDTYPE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_EXB->CS3,7)))


/* Enhannced Two Aspect Pulse Input Counter (Enhannced 2-Phase Pulse Input Timer) (EPHC) for CPU */
#define TSB_EPHC_EN_EN                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->EN,0)))
#define TSB_EPHC_CNT_PBDIR                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->CNT,11)))
#define TSB_EPHC_CNT_MA12                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->CNT,12)))
#define TSB_EPHC_CNT_MA2DIR                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->CNT,13)))
#define TSB_EPHC_IE_INTPCCP0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->IE,0)))
#define TSB_EPHC_IE_INTPCCP1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->IE,1)))
#define TSB_EPHC_IE_INTPCOVF                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->IE,2)))
#define TSB_EPHC_IE_INTPCUDF                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->IE,3)))
#define TSB_EPHC_IE_INTPCDT0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->IE,4)))
#define TSB_EPHC_IE_INTPCDT1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->IE,5)))
#define TSB_EPHC_IE_INTPCDT2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->IE,6)))
#define TSB_EPHC_IE_INTPCDT3                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->IE,7)))
#define TSB_EPHC_IE_INTPCDIR                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->IE,8)))
#define TSB_EPHC_IE_INTPCUOVF                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->IE,9)))
#define TSB_EPHC_FLG_CMP0F                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->FLG,0)))
#define TSB_EPHC_FLG_CMP1F                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->FLG,1)))
#define TSB_EPHC_FLG_OVFF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->FLG,2)))
#define TSB_EPHC_FLG_UDFF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->FLG,3)))
#define TSB_EPHC_FLG_SB0F                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->FLG,4)))
#define TSB_EPHC_FLG_SB1F                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->FLG,5)))
#define TSB_EPHC_FLG_SB2F                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->FLG,6)))
#define TSB_EPHC_FLG_SB3F                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->FLG,7)))
#define TSB_EPHC_FLG_DIRF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->FLG,8)))
#define TSB_EPHC_ARUN_RUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->ARUN,0)))
#define TSB_EPHC_ARUN_CLR                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->ARUN,1)))
#define TSB_EPHC_BRUN_T24RUN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_EPHC->BRUN,0)))
#define TSB_EPHC_BCAP00_OVF00                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_EPHC->BCAP00,24)))
#define TSB_EPHC_BCAP10_OVF10                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_EPHC->BCAP10,24)))
#define TSB_EPHC_BCAP20_OVF20                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_EPHC->BCAP20,24)))
#define TSB_EPHC_BCAP30_OVF30                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_EPHC->BCAP30,24)))


/* Enhannced Two Aspect Pulse Input Counter (Enhannced 2-Phase Pulse Input Timer) (EPHC) for PSC */
#define TSB_EPHC_MIR_BCAP00_OVF00                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_EPHC_MIR->BCAP00,24)))
#define TSB_EPHC_MIR_BCAP10_OVF10                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_EPHC_MIR->BCAP10,24)))
#define TSB_EPHC_MIR_BCAP20_OVF20                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_EPHC_MIR->BCAP20,24)))
#define TSB_EPHC_MIR_BCAP30_OVF30                 (*((__I  uint32_t *)BITBAND_PERI(&TSB_EPHC_MIR->BCAP30,24)))


/* Enhannced Serial I/O (ESIO) */
#define TSB_ESIO0_CR0_ESIOE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->CR0,0)))
#define TSB_ESIO0_CR1_CSSEL                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->CR1,8)))
#define TSB_ESIO0_CR1_ESIOMS                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->CR1,13)))
#define TSB_ESIO0_CR1_TRXE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->CR1,14)))
#define TSB_ESIO0_CR2_DMARE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->CR2,0)))
#define TSB_ESIO0_CR2_DMATE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->CR2,1)))
#define TSB_ESIO0_CR2_INTPERR                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->CR2,2)))
#define TSB_ESIO0_CR2_INTRXWE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->CR2,4)))
#define TSB_ESIO0_CR2_INTRXFE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->CR2,5)))
#define TSB_ESIO0_CR2_INTTXWE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->CR2,6)))
#define TSB_ESIO0_CR2_INTTXFE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->CR2,7)))
#define TSB_ESIO0_CR3_RFFLLCLR                    (*((__O  uint32_t *)BITBAND_PERI(&TSB_ESIO0->CR3,0)))
#define TSB_ESIO0_CR3_TFEMPCLR                    (*((__O  uint32_t *)BITBAND_PERI(&TSB_ESIO0->CR3,1)))
#define TSB_ESIO0_FMTR0_CS0POL                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->FMTR0,8)))
#define TSB_ESIO0_FMTR0_CS1POL                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->FMTR0,9)))
#define TSB_ESIO0_FMTR0_CKPOL                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->FMTR0,14)))
#define TSB_ESIO0_FMTR0_DIR                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->FMTR0,31)))
#define TSB_ESIO0_FMTR1_VPM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->FMTR1,0)))
#define TSB_ESIO0_FMTR1_VPE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->FMTR1,1)))
#define TSB_ESIO0_FMTR1_HPM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->FMTR1,2)))
#define TSB_ESIO0_FMTR1_HPE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->FMTR1,3)))
#define TSB_ESIO0_SR_RFFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO0->SR,4)))
#define TSB_ESIO0_SR_INTRXFF                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->SR,5)))
#define TSB_ESIO0_SR_RWEND                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->SR,6)))
#define TSB_ESIO0_SR_RXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO0->SR,7)))
#define TSB_ESIO0_SR_TFEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO0->SR,20)))
#define TSB_ESIO0_SR_INTTXFF                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->SR,21)))
#define TSB_ESIO0_SR_TWEND                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->SR,22)))
#define TSB_ESIO0_SR_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO0->SR,23)))
#define TSB_ESIO0_SR_ESIOSUE                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO0->SR,31)))
#define TSB_ESIO0_PERR_HPERR                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->PERR,8)))
#define TSB_ESIO0_PERR_VPERR                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO0->PERR,9)))

#define TSB_ESIO1_CR0_ESIOE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->CR0,0)))
#define TSB_ESIO1_CR1_CSSEL                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->CR1,8)))
#define TSB_ESIO1_CR1_ESIOMS                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->CR1,13)))
#define TSB_ESIO1_CR1_TRXE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->CR1,14)))
#define TSB_ESIO1_CR2_DMARE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->CR2,0)))
#define TSB_ESIO1_CR2_DMATE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->CR2,1)))
#define TSB_ESIO1_CR2_INTPERR                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->CR2,2)))
#define TSB_ESIO1_CR2_INTRXWE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->CR2,4)))
#define TSB_ESIO1_CR2_INTRXFE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->CR2,5)))
#define TSB_ESIO1_CR2_INTTXWE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->CR2,6)))
#define TSB_ESIO1_CR2_INTTXFE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->CR2,7)))
#define TSB_ESIO1_CR3_RFFLLCLR                    (*((__O  uint32_t *)BITBAND_PERI(&TSB_ESIO1->CR3,0)))
#define TSB_ESIO1_CR3_TFEMPCLR                    (*((__O  uint32_t *)BITBAND_PERI(&TSB_ESIO1->CR3,1)))
#define TSB_ESIO1_FMTR0_CS0POL                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->FMTR0,8)))
#define TSB_ESIO1_FMTR0_CS1POL                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->FMTR0,9)))
#define TSB_ESIO1_FMTR0_CKPOL                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->FMTR0,14)))
#define TSB_ESIO1_FMTR0_DIR                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->FMTR0,31)))
#define TSB_ESIO1_FMTR1_VPM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->FMTR1,0)))
#define TSB_ESIO1_FMTR1_VPE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->FMTR1,1)))
#define TSB_ESIO1_FMTR1_HPM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->FMTR1,2)))
#define TSB_ESIO1_FMTR1_HPE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->FMTR1,3)))
#define TSB_ESIO1_SR_RFFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO1->SR,4)))
#define TSB_ESIO1_SR_INTRXFF                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->SR,5)))
#define TSB_ESIO1_SR_RWEND                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->SR,6)))
#define TSB_ESIO1_SR_RXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO1->SR,7)))
#define TSB_ESIO1_SR_TFEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO1->SR,20)))
#define TSB_ESIO1_SR_INTTXFF                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->SR,21)))
#define TSB_ESIO1_SR_TWEND                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->SR,22)))
#define TSB_ESIO1_SR_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO1->SR,23)))
#define TSB_ESIO1_SR_ESIOSUE                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO1->SR,31)))
#define TSB_ESIO1_PERR_HPERR                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->PERR,8)))
#define TSB_ESIO1_PERR_VPERR                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO1->PERR,9)))

#define TSB_ESIO2_CR0_ESIOE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->CR0,0)))
#define TSB_ESIO2_CR1_CSSEL                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->CR1,8)))
#define TSB_ESIO2_CR1_ESIOMS                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->CR1,13)))
#define TSB_ESIO2_CR1_TRXE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->CR1,14)))
#define TSB_ESIO2_CR2_DMARE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->CR2,0)))
#define TSB_ESIO2_CR2_DMATE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->CR2,1)))
#define TSB_ESIO2_CR2_INTPERR                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->CR2,2)))
#define TSB_ESIO2_CR2_INTRXWE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->CR2,4)))
#define TSB_ESIO2_CR2_INTRXFE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->CR2,5)))
#define TSB_ESIO2_CR2_INTTXWE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->CR2,6)))
#define TSB_ESIO2_CR2_INTTXFE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->CR2,7)))
#define TSB_ESIO2_CR3_RFFLLCLR                    (*((__O  uint32_t *)BITBAND_PERI(&TSB_ESIO2->CR3,0)))
#define TSB_ESIO2_CR3_TFEMPCLR                    (*((__O  uint32_t *)BITBAND_PERI(&TSB_ESIO2->CR3,1)))
#define TSB_ESIO2_FMTR0_CS0POL                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->FMTR0,8)))
#define TSB_ESIO2_FMTR0_CS1POL                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->FMTR0,9)))
#define TSB_ESIO2_FMTR0_CKPOL                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->FMTR0,14)))
#define TSB_ESIO2_FMTR0_DIR                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->FMTR0,31)))
#define TSB_ESIO2_FMTR1_VPM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->FMTR1,0)))
#define TSB_ESIO2_FMTR1_VPE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->FMTR1,1)))
#define TSB_ESIO2_FMTR1_HPM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->FMTR1,2)))
#define TSB_ESIO2_FMTR1_HPE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->FMTR1,3)))
#define TSB_ESIO2_SR_RFFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO2->SR,4)))
#define TSB_ESIO2_SR_INTRXFF                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->SR,5)))
#define TSB_ESIO2_SR_RWEND                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->SR,6)))
#define TSB_ESIO2_SR_RXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO2->SR,7)))
#define TSB_ESIO2_SR_TFEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO2->SR,20)))
#define TSB_ESIO2_SR_INTTXFF                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->SR,21)))
#define TSB_ESIO2_SR_TWEND                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->SR,22)))
#define TSB_ESIO2_SR_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO2->SR,23)))
#define TSB_ESIO2_SR_ESIOSUE                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_ESIO2->SR,31)))
#define TSB_ESIO2_PERR_HPERR                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->PERR,8)))
#define TSB_ESIO2_PERR_VPERR                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_ESIO2->PERR,9)))


/* Port A */
#define TSB_PA_DATA_PA0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,0)))
#define TSB_PA_DATA_PA1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,1)))
#define TSB_PA_DATA_PA2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,2)))
#define TSB_PA_DATA_PA3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,3)))
#define TSB_PA_DATA_PA4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,4)))
#define TSB_PA_DATA_PA5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,5)))
#define TSB_PA_DATA_PA6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,6)))
#define TSB_PA_DATA_PA7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->DATA,7)))
#define TSB_PA_CR_PA0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,0)))
#define TSB_PA_CR_PA1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,1)))
#define TSB_PA_CR_PA2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,2)))
#define TSB_PA_CR_PA3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,3)))
#define TSB_PA_CR_PA4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,4)))
#define TSB_PA_CR_PA5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,5)))
#define TSB_PA_CR_PA6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,6)))
#define TSB_PA_CR_PA7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->CR,7)))
#define TSB_PA_FR1_PA0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,0)))
#define TSB_PA_FR1_PA1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,1)))
#define TSB_PA_FR1_PA2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,2)))
#define TSB_PA_FR1_PA3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,3)))
#define TSB_PA_FR1_PA4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,4)))
#define TSB_PA_FR1_PA5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,5)))
#define TSB_PA_FR1_PA6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,6)))
#define TSB_PA_FR1_PA7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR1,7)))
#define TSB_PA_FR2_PA0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,0)))
#define TSB_PA_FR2_PA1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,1)))
#define TSB_PA_FR2_PA2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,2)))
#define TSB_PA_FR2_PA3F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,3)))
#define TSB_PA_FR2_PA4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,4)))
#define TSB_PA_FR2_PA5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,5)))
#define TSB_PA_FR2_PA6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,6)))
#define TSB_PA_FR2_PA7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR2,7)))
#define TSB_PA_FR3_PA0F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR3,0)))
#define TSB_PA_FR3_PA1F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR3,1)))
#define TSB_PA_FR3_PA2F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR3,2)))
#define TSB_PA_FR3_PA3F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR3,3)))
#define TSB_PA_FR3_PA4F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR3,4)))
#define TSB_PA_FR3_PA5F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR3,5)))
#define TSB_PA_FR3_PA6F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR3,6)))
#define TSB_PA_FR3_PA7F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->FR3,7)))
#define TSB_PA_OD_PA0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,0)))
#define TSB_PA_OD_PA1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,1)))
#define TSB_PA_OD_PA2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,2)))
#define TSB_PA_OD_PA3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,3)))
#define TSB_PA_OD_PA4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,4)))
#define TSB_PA_OD_PA5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,5)))
#define TSB_PA_OD_PA6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,6)))
#define TSB_PA_OD_PA7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->OD,7)))
#define TSB_PA_PUP_PA0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,0)))
#define TSB_PA_PUP_PA1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,1)))
#define TSB_PA_PUP_PA2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,2)))
#define TSB_PA_PUP_PA3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,3)))
#define TSB_PA_PUP_PA4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,4)))
#define TSB_PA_PUP_PA5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,5)))
#define TSB_PA_PUP_PA6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,6)))
#define TSB_PA_PUP_PA7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->PUP,7)))
#define TSB_PA_IE_PA0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,0)))
#define TSB_PA_IE_PA1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,1)))
#define TSB_PA_IE_PA2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,2)))
#define TSB_PA_IE_PA3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,3)))
#define TSB_PA_IE_PA4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,4)))
#define TSB_PA_IE_PA5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,5)))
#define TSB_PA_IE_PA6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,6)))
#define TSB_PA_IE_PA7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PA->IE,7)))


/* Port B */
#define TSB_PB_DATA_PB0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,0)))
#define TSB_PB_DATA_PB1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,1)))
#define TSB_PB_DATA_PB2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,2)))
#define TSB_PB_DATA_PB3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,3)))
#define TSB_PB_DATA_PB4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,4)))
#define TSB_PB_DATA_PB5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,5)))
#define TSB_PB_DATA_PB6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,6)))
#define TSB_PB_DATA_PB7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->DATA,7)))
#define TSB_PB_CR_PB0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,0)))
#define TSB_PB_CR_PB1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,1)))
#define TSB_PB_CR_PB2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,2)))
#define TSB_PB_CR_PB3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,3)))
#define TSB_PB_CR_PB4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,4)))
#define TSB_PB_CR_PB5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,5)))
#define TSB_PB_CR_PB6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,6)))
#define TSB_PB_CR_PB7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->CR,7)))
#define TSB_PB_FR1_PB0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,0)))
#define TSB_PB_FR1_PB1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,1)))
#define TSB_PB_FR1_PB2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,2)))
#define TSB_PB_FR1_PB3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,3)))
#define TSB_PB_FR1_PB4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,4)))
#define TSB_PB_FR1_PB5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,5)))
#define TSB_PB_FR1_PB6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,6)))
#define TSB_PB_FR1_PB7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR1,7)))
#define TSB_PB_FR2_PB0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR2,0)))
#define TSB_PB_FR2_PB1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR2,1)))
#define TSB_PB_FR2_PB2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR2,2)))
#define TSB_PB_FR2_PB3F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR2,3)))
#define TSB_PB_FR2_PB4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR2,4)))
#define TSB_PB_FR2_PB5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR2,5)))
#define TSB_PB_FR2_PB6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR2,6)))
#define TSB_PB_FR2_PB7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR2,7)))
#define TSB_PB_FR3_PB0F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR3,0)))
#define TSB_PB_FR3_PB1F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR3,1)))
#define TSB_PB_FR3_PB2F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR3,2)))
#define TSB_PB_FR3_PB3F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR3,3)))
#define TSB_PB_FR3_PB4F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR3,4)))
#define TSB_PB_FR3_PB5F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR3,5)))
#define TSB_PB_FR3_PB6F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR3,6)))
#define TSB_PB_FR3_PB7F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->FR3,7)))
#define TSB_PB_OD_PB0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,0)))
#define TSB_PB_OD_PB1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,1)))
#define TSB_PB_OD_PB2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,2)))
#define TSB_PB_OD_PB3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,3)))
#define TSB_PB_OD_PB4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,4)))
#define TSB_PB_OD_PB5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,5)))
#define TSB_PB_OD_PB6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,6)))
#define TSB_PB_OD_PB7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->OD,7)))
#define TSB_PB_PUP_PB0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,0)))
#define TSB_PB_PUP_PB1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,1)))
#define TSB_PB_PUP_PB2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,2)))
#define TSB_PB_PUP_PB3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,3)))
#define TSB_PB_PUP_PB4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,4)))
#define TSB_PB_PUP_PB5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,5)))
#define TSB_PB_PUP_PB6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,6)))
#define TSB_PB_PUP_PB7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->PUP,7)))
#define TSB_PB_IE_PB0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,0)))
#define TSB_PB_IE_PB1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,1)))
#define TSB_PB_IE_PB2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,2)))
#define TSB_PB_IE_PB3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,3)))
#define TSB_PB_IE_PB4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,4)))
#define TSB_PB_IE_PB5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,5)))
#define TSB_PB_IE_PB6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,6)))
#define TSB_PB_IE_PB7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PB->IE,7)))


/* Port C */
#define TSB_PC_DATA_PC0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,0)))
#define TSB_PC_DATA_PC1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,1)))
#define TSB_PC_DATA_PC2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,2)))
#define TSB_PC_DATA_PC3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,3)))
#define TSB_PC_DATA_PC4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,4)))
#define TSB_PC_DATA_PC5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,5)))
#define TSB_PC_DATA_PC6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,6)))
#define TSB_PC_DATA_PC7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->DATA,7)))
#define TSB_PC_CR_PC0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,0)))
#define TSB_PC_CR_PC1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,1)))
#define TSB_PC_CR_PC2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,2)))
#define TSB_PC_CR_PC3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,3)))
#define TSB_PC_CR_PC4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,4)))
#define TSB_PC_CR_PC5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,5)))
#define TSB_PC_CR_PC6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,6)))
#define TSB_PC_CR_PC7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->CR,7)))
#define TSB_PC_FR1_PC0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,0)))
#define TSB_PC_FR1_PC1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,1)))
#define TSB_PC_FR1_PC2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,2)))
#define TSB_PC_FR1_PC3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,3)))
#define TSB_PC_FR1_PC4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,4)))
#define TSB_PC_FR1_PC5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,5)))
#define TSB_PC_FR1_PC6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,6)))
#define TSB_PC_FR1_PC7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR1,7)))
#define TSB_PC_FR2_PC0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,0)))
#define TSB_PC_FR2_PC1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,1)))
#define TSB_PC_FR2_PC2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,2)))
#define TSB_PC_FR2_PC3F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,3)))
#define TSB_PC_FR2_PC4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,4)))
#define TSB_PC_FR2_PC5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,5)))
#define TSB_PC_FR2_PC6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,6)))
#define TSB_PC_FR2_PC7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR2,7)))
#define TSB_PC_FR3_PC0F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR3,0)))
#define TSB_PC_FR3_PC1F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR3,1)))
#define TSB_PC_FR3_PC2F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR3,2)))
#define TSB_PC_FR3_PC3F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR3,3)))
#define TSB_PC_FR3_PC4F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR3,4)))
#define TSB_PC_FR3_PC5F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR3,5)))
#define TSB_PC_FR3_PC6F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR3,6)))
#define TSB_PC_FR3_PC7F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->FR3,7)))
#define TSB_PC_OD_PC0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,0)))
#define TSB_PC_OD_PC1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,1)))
#define TSB_PC_OD_PC2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,2)))
#define TSB_PC_OD_PC3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,3)))
#define TSB_PC_OD_PC4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,4)))
#define TSB_PC_OD_PC5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,5)))
#define TSB_PC_OD_PC6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,6)))
#define TSB_PC_OD_PC7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->OD,7)))
#define TSB_PC_PUP_PC0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,0)))
#define TSB_PC_PUP_PC1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,1)))
#define TSB_PC_PUP_PC2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,2)))
#define TSB_PC_PUP_PC3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,3)))
#define TSB_PC_PUP_PC4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,4)))
#define TSB_PC_PUP_PC5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,5)))
#define TSB_PC_PUP_PC6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,6)))
#define TSB_PC_PUP_PC7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->PUP,7)))
#define TSB_PC_IE_PC0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,0)))
#define TSB_PC_IE_PC1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,1)))
#define TSB_PC_IE_PC2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,2)))
#define TSB_PC_IE_PC3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,3)))
#define TSB_PC_IE_PC4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,4)))
#define TSB_PC_IE_PC5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,5)))
#define TSB_PC_IE_PC6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,6)))
#define TSB_PC_IE_PC7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PC->IE,7)))


/* Port D */
#define TSB_PD_DATA_PD0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,0)))
#define TSB_PD_DATA_PD1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,1)))
#define TSB_PD_DATA_PD2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,2)))
#define TSB_PD_DATA_PD3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,3)))
#define TSB_PD_DATA_PD4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,4)))
#define TSB_PD_DATA_PD5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,5)))
#define TSB_PD_DATA_PD6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,6)))
#define TSB_PD_DATA_PD7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->DATA,7)))
#define TSB_PD_CR_PD0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,0)))
#define TSB_PD_CR_PD1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,1)))
#define TSB_PD_CR_PD2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,2)))
#define TSB_PD_CR_PD3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,3)))
#define TSB_PD_CR_PD4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,4)))
#define TSB_PD_CR_PD5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,5)))
#define TSB_PD_CR_PD6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,6)))
#define TSB_PD_CR_PD7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->CR,7)))
#define TSB_PD_FR1_PD0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,0)))
#define TSB_PD_FR1_PD1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,1)))
#define TSB_PD_FR1_PD2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,2)))
#define TSB_PD_FR1_PD3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,3)))
#define TSB_PD_FR1_PD4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,4)))
#define TSB_PD_FR1_PD5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,5)))
#define TSB_PD_FR1_PD6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,6)))
#define TSB_PD_FR1_PD7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR1,7)))
#define TSB_PD_FR2_PD0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR2,0)))
#define TSB_PD_FR2_PD1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR2,1)))
#define TSB_PD_FR2_PD2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR2,2)))
#define TSB_PD_FR2_PD3F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR2,3)))
#define TSB_PD_FR2_PD4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR2,4)))
#define TSB_PD_FR2_PD5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR2,5)))
#define TSB_PD_FR2_PD6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR2,6)))
#define TSB_PD_FR2_PD7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR2,7)))
#define TSB_PD_FR3_PD0F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR3,0)))
#define TSB_PD_FR3_PD1F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR3,1)))
#define TSB_PD_FR3_PD2F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR3,2)))
#define TSB_PD_FR3_PD3F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR3,3)))
#define TSB_PD_FR3_PD4F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR3,4)))
#define TSB_PD_FR3_PD5F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR3,5)))
#define TSB_PD_FR3_PD6F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR3,6)))
#define TSB_PD_FR3_PD7F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->FR3,7)))
#define TSB_PD_OD_PD0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,0)))
#define TSB_PD_OD_PD1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,1)))
#define TSB_PD_OD_PD2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,2)))
#define TSB_PD_OD_PD3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,3)))
#define TSB_PD_OD_PD4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,4)))
#define TSB_PD_OD_PD5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,5)))
#define TSB_PD_OD_PD6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,6)))
#define TSB_PD_OD_PD7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->OD,7)))
#define TSB_PD_PUP_PD0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,0)))
#define TSB_PD_PUP_PD1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,1)))
#define TSB_PD_PUP_PD2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,2)))
#define TSB_PD_PUP_PD3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,3)))
#define TSB_PD_PUP_PD4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,4)))
#define TSB_PD_PUP_PD5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,5)))
#define TSB_PD_PUP_PD6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,6)))
#define TSB_PD_PUP_PD7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->PUP,7)))
#define TSB_PD_IE_PD0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,0)))
#define TSB_PD_IE_PD1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,1)))
#define TSB_PD_IE_PD2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,2)))
#define TSB_PD_IE_PD3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,3)))
#define TSB_PD_IE_PD4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,4)))
#define TSB_PD_IE_PD5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,5)))
#define TSB_PD_IE_PD6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,6)))
#define TSB_PD_IE_PD7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PD->IE,7)))


/* Port E */
#define TSB_PE_DATA_PE0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,0)))
#define TSB_PE_DATA_PE1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,1)))
#define TSB_PE_DATA_PE2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,2)))
#define TSB_PE_DATA_PE3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,3)))
#define TSB_PE_DATA_PE4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,4)))
#define TSB_PE_DATA_PE5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,5)))
#define TSB_PE_DATA_PE6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,6)))
#define TSB_PE_DATA_PE7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->DATA,7)))
#define TSB_PE_CR_PE0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,0)))
#define TSB_PE_CR_PE1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,1)))
#define TSB_PE_CR_PE2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,2)))
#define TSB_PE_CR_PE3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,3)))
#define TSB_PE_CR_PE4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,4)))
#define TSB_PE_CR_PE5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,5)))
#define TSB_PE_CR_PE6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,6)))
#define TSB_PE_CR_PE7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->CR,7)))
#define TSB_PE_FR1_PE0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,0)))
#define TSB_PE_FR1_PE1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,1)))
#define TSB_PE_FR1_PE2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,2)))
#define TSB_PE_FR1_PE3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,3)))
#define TSB_PE_FR1_PE4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,4)))
#define TSB_PE_FR1_PE5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,5)))
#define TSB_PE_FR1_PE6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,6)))
#define TSB_PE_FR1_PE7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR1,7)))
#define TSB_PE_FR2_PE0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR2,0)))
#define TSB_PE_FR2_PE1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR2,1)))
#define TSB_PE_FR2_PE2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR2,2)))
#define TSB_PE_FR2_PE3F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR2,3)))
#define TSB_PE_FR2_PE4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR2,4)))
#define TSB_PE_FR2_PE5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR2,5)))
#define TSB_PE_FR2_PE6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR2,6)))
#define TSB_PE_FR2_PE7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR2,7)))
#define TSB_PE_FR3_PE0F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR3,0)))
#define TSB_PE_FR3_PE1F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR3,1)))
#define TSB_PE_FR3_PE2F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR3,2)))
#define TSB_PE_FR3_PE3F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR3,3)))
#define TSB_PE_FR3_PE4F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR3,4)))
#define TSB_PE_FR3_PE5F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR3,5)))
#define TSB_PE_FR3_PE6F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR3,6)))
#define TSB_PE_FR3_PE7F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->FR3,7)))
#define TSB_PE_OD_PE0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,0)))
#define TSB_PE_OD_PE1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,1)))
#define TSB_PE_OD_PE2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,2)))
#define TSB_PE_OD_PE3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,3)))
#define TSB_PE_OD_PE4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,4)))
#define TSB_PE_OD_PE5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,5)))
#define TSB_PE_OD_PE6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,6)))
#define TSB_PE_OD_PE7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->OD,7)))
#define TSB_PE_PUP_PE0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,0)))
#define TSB_PE_PUP_PE1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,1)))
#define TSB_PE_PUP_PE2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,2)))
#define TSB_PE_PUP_PE3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,3)))
#define TSB_PE_PUP_PE4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,4)))
#define TSB_PE_PUP_PE5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,5)))
#define TSB_PE_PUP_PE6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,6)))
#define TSB_PE_PUP_PE7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->PUP,7)))
#define TSB_PE_IE_PE0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,0)))
#define TSB_PE_IE_PE1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,1)))
#define TSB_PE_IE_PE2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,2)))
#define TSB_PE_IE_PE3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,3)))
#define TSB_PE_IE_PE4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,4)))
#define TSB_PE_IE_PE5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,5)))
#define TSB_PE_IE_PE6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,6)))
#define TSB_PE_IE_PE7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PE->IE,7)))


/* Port F */
#define TSB_PF_DATA_PF0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,0)))
#define TSB_PF_DATA_PF1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,1)))
#define TSB_PF_DATA_PF2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,2)))
#define TSB_PF_DATA_PF3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,3)))
#define TSB_PF_DATA_PF4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,4)))
#define TSB_PF_DATA_PF5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,5)))
#define TSB_PF_DATA_PF6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,6)))
#define TSB_PF_DATA_PF7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->DATA,7)))
#define TSB_PF_CR_PF0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,0)))
#define TSB_PF_CR_PF1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,1)))
#define TSB_PF_CR_PF2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,2)))
#define TSB_PF_CR_PF3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,3)))
#define TSB_PF_CR_PF4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,4)))
#define TSB_PF_CR_PF5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,5)))
#define TSB_PF_CR_PF6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,6)))
#define TSB_PF_CR_PF7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->CR,7)))
#define TSB_PF_FR1_PF0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,0)))
#define TSB_PF_FR1_PF1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,1)))
#define TSB_PF_FR1_PF2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,2)))
#define TSB_PF_FR1_PF3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,3)))
#define TSB_PF_FR1_PF4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,4)))
#define TSB_PF_FR1_PF5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,5)))
#define TSB_PF_FR1_PF6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,6)))
#define TSB_PF_FR1_PF7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR1,7)))
#define TSB_PF_FR2_PF0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR2,0)))
#define TSB_PF_FR2_PF1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR2,1)))
#define TSB_PF_FR2_PF2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR2,2)))
#define TSB_PF_FR2_PF3F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR2,3)))
#define TSB_PF_FR2_PF4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR2,4)))
#define TSB_PF_FR2_PF5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR2,5)))
#define TSB_PF_FR2_PF6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR2,6)))
#define TSB_PF_FR2_PF7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR2,7)))
#define TSB_PF_FR3_PF0F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR3,0)))
#define TSB_PF_FR3_PF1F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR3,1)))
#define TSB_PF_FR3_PF2F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR3,2)))
#define TSB_PF_FR3_PF3F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR3,3)))
#define TSB_PF_FR3_PF4F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR3,4)))
#define TSB_PF_FR3_PF5F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR3,5)))
#define TSB_PF_FR3_PF6F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR3,6)))
#define TSB_PF_FR3_PF7F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->FR3,7)))
#define TSB_PF_OD_PF0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,0)))
#define TSB_PF_OD_PF1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,1)))
#define TSB_PF_OD_PF2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,2)))
#define TSB_PF_OD_PF3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,3)))
#define TSB_PF_OD_PF4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,4)))
#define TSB_PF_OD_PF5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,5)))
#define TSB_PF_OD_PF6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,6)))
#define TSB_PF_OD_PF7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->OD,7)))
#define TSB_PF_PUP_PF0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,0)))
#define TSB_PF_PUP_PF1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,1)))
#define TSB_PF_PUP_PF2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,2)))
#define TSB_PF_PUP_PF3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,3)))
#define TSB_PF_PUP_PF4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,4)))
#define TSB_PF_PUP_PF5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,5)))
#define TSB_PF_PUP_PF6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,6)))
#define TSB_PF_PUP_PF7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->PUP,7)))
#define TSB_PF_IE_PF0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,0)))
#define TSB_PF_IE_PF1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,1)))
#define TSB_PF_IE_PF2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,2)))
#define TSB_PF_IE_PF3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,3)))
#define TSB_PF_IE_PF4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,4)))
#define TSB_PF_IE_PF5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,5)))
#define TSB_PF_IE_PF6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,6)))
#define TSB_PF_IE_PF7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PF->IE,7)))


/* Port G */
#define TSB_PG_DATA_PG0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,0)))
#define TSB_PG_DATA_PG1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,1)))
#define TSB_PG_DATA_PG2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,2)))
#define TSB_PG_DATA_PG3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,3)))
#define TSB_PG_DATA_PG4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,4)))
#define TSB_PG_DATA_PG5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,5)))
#define TSB_PG_DATA_PG6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,6)))
#define TSB_PG_DATA_PG7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->DATA,7)))
#define TSB_PG_CR_PG0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,0)))
#define TSB_PG_CR_PG1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,1)))
#define TSB_PG_CR_PG2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,2)))
#define TSB_PG_CR_PG3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,3)))
#define TSB_PG_CR_PG4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,4)))
#define TSB_PG_CR_PG5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,5)))
#define TSB_PG_CR_PG6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,6)))
#define TSB_PG_CR_PG7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->CR,7)))
#define TSB_PG_FR1_PG0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,0)))
#define TSB_PG_FR1_PG1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,1)))
#define TSB_PG_FR1_PG2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,2)))
#define TSB_PG_FR1_PG3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,3)))
#define TSB_PG_FR1_PG4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,4)))
#define TSB_PG_FR1_PG5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,5)))
#define TSB_PG_FR1_PG6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,6)))
#define TSB_PG_FR1_PG7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->FR1,7)))
#define TSB_PG_OD_PG0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,0)))
#define TSB_PG_OD_PG1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,1)))
#define TSB_PG_OD_PG2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,2)))
#define TSB_PG_OD_PG3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,3)))
#define TSB_PG_OD_PG4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,4)))
#define TSB_PG_OD_PG5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,5)))
#define TSB_PG_OD_PG6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,6)))
#define TSB_PG_OD_PG7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->OD,7)))
#define TSB_PG_PUP_PG0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,0)))
#define TSB_PG_PUP_PG1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,1)))
#define TSB_PG_PUP_PG2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,2)))
#define TSB_PG_PUP_PG3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,3)))
#define TSB_PG_PUP_PG4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,4)))
#define TSB_PG_PUP_PG5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,5)))
#define TSB_PG_PUP_PG6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,6)))
#define TSB_PG_PUP_PG7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PUP,7)))
#define TSB_PG_PDN_PG0DN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,0)))
#define TSB_PG_PDN_PG1DN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,1)))
#define TSB_PG_PDN_PG2DN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,2)))
#define TSB_PG_PDN_PG3DN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,3)))
#define TSB_PG_PDN_PG4DN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,4)))
#define TSB_PG_PDN_PG5DN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,5)))
#define TSB_PG_PDN_PG6DN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,6)))
#define TSB_PG_PDN_PG7DN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->PDN,7)))
#define TSB_PG_IE_PG0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,0)))
#define TSB_PG_IE_PG1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,1)))
#define TSB_PG_IE_PG2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,2)))
#define TSB_PG_IE_PG3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,3)))
#define TSB_PG_IE_PG4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,4)))
#define TSB_PG_IE_PG5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,5)))
#define TSB_PG_IE_PG6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,6)))
#define TSB_PG_IE_PG7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PG->IE,7)))


/* Port H */
#define TSB_PH_DATA_PH0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,0)))
#define TSB_PH_DATA_PH1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,1)))
#define TSB_PH_DATA_PH2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,2)))
#define TSB_PH_DATA_PH3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,3)))
#define TSB_PH_DATA_PH4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,4)))
#define TSB_PH_DATA_PH5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,5)))
#define TSB_PH_DATA_PH6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,6)))
#define TSB_PH_DATA_PH7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->DATA,7)))
#define TSB_PH_CR_PH0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,0)))
#define TSB_PH_CR_PH1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,1)))
#define TSB_PH_CR_PH2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,2)))
#define TSB_PH_CR_PH3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,3)))
#define TSB_PH_CR_PH4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,4)))
#define TSB_PH_CR_PH5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,5)))
#define TSB_PH_CR_PH6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,6)))
#define TSB_PH_CR_PH7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->CR,7)))
#define TSB_PH_FR1_PH0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,0)))
#define TSB_PH_FR1_PH1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,1)))
#define TSB_PH_FR1_PH2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,2)))
#define TSB_PH_FR1_PH3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,3)))
#define TSB_PH_FR1_PH4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,4)))
#define TSB_PH_FR1_PH5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,5)))
#define TSB_PH_FR1_PH6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,6)))
#define TSB_PH_FR1_PH7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR1,7)))
#define TSB_PH_FR2_PH0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR2,0)))
#define TSB_PH_FR2_PH1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR2,1)))
#define TSB_PH_FR2_PH2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR2,2)))
#define TSB_PH_FR2_PH3F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR2,3)))
#define TSB_PH_FR2_PH4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR2,4)))
#define TSB_PH_FR2_PH5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR2,5)))
#define TSB_PH_FR2_PH6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR2,6)))
#define TSB_PH_FR2_PH7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR2,7)))
#define TSB_PH_FR3_PH0F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR3,0)))
#define TSB_PH_FR3_PH1F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR3,1)))
#define TSB_PH_FR3_PH2F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR3,2)))
#define TSB_PH_FR3_PH3F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR3,3)))
#define TSB_PH_FR3_PH4F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR3,4)))
#define TSB_PH_FR3_PH5F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR3,5)))
#define TSB_PH_FR3_PH6F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR3,6)))
#define TSB_PH_FR3_PH7F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->FR3,7)))
#define TSB_PH_OD_PH0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,0)))
#define TSB_PH_OD_PH1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,1)))
#define TSB_PH_OD_PH2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,2)))
#define TSB_PH_OD_PH3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,3)))
#define TSB_PH_OD_PH4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,4)))
#define TSB_PH_OD_PH5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,5)))
#define TSB_PH_OD_PH6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,6)))
#define TSB_PH_OD_PH7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->OD,7)))
#define TSB_PH_PUP_PH0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,0)))
#define TSB_PH_PUP_PH1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,1)))
#define TSB_PH_PUP_PH2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,2)))
#define TSB_PH_PUP_PH3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,3)))
#define TSB_PH_PUP_PH4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,4)))
#define TSB_PH_PUP_PH5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,5)))
#define TSB_PH_PUP_PH6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,6)))
#define TSB_PH_PUP_PH7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->PUP,7)))
#define TSB_PH_IE_PH0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,0)))
#define TSB_PH_IE_PH1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,1)))
#define TSB_PH_IE_PH2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,2)))
#define TSB_PH_IE_PH3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,3)))
#define TSB_PH_IE_PH4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,4)))
#define TSB_PH_IE_PH5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,5)))
#define TSB_PH_IE_PH6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,6)))
#define TSB_PH_IE_PH7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PH->IE,7)))


/* Port J */
#define TSB_PJ_DATA_PJ0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,0)))
#define TSB_PJ_DATA_PJ1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,1)))
#define TSB_PJ_DATA_PJ2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,2)))
#define TSB_PJ_DATA_PJ3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,3)))
#define TSB_PJ_DATA_PJ4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,4)))
#define TSB_PJ_DATA_PJ5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,5)))
#define TSB_PJ_DATA_PJ6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,6)))
#define TSB_PJ_DATA_PJ7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->DATA,7)))
#define TSB_PJ_CR_PJ0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,0)))
#define TSB_PJ_CR_PJ1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,1)))
#define TSB_PJ_CR_PJ2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,2)))
#define TSB_PJ_CR_PJ3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,3)))
#define TSB_PJ_CR_PJ4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,4)))
#define TSB_PJ_CR_PJ5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,5)))
#define TSB_PJ_CR_PJ6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,6)))
#define TSB_PJ_CR_PJ7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->CR,7)))
#define TSB_PJ_FR1_PJ0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,0)))
#define TSB_PJ_FR1_PJ1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,1)))
#define TSB_PJ_FR1_PJ2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,2)))
#define TSB_PJ_FR1_PJ3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,3)))
#define TSB_PJ_FR1_PJ4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,4)))
#define TSB_PJ_FR1_PJ5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,5)))
#define TSB_PJ_FR1_PJ6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,6)))
#define TSB_PJ_FR1_PJ7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR1,7)))
#define TSB_PJ_FR2_PJ0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR2,0)))
#define TSB_PJ_FR2_PJ1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR2,1)))
#define TSB_PJ_FR2_PJ2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR2,2)))
#define TSB_PJ_FR2_PJ3F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR2,3)))
#define TSB_PJ_FR2_PJ4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR2,4)))
#define TSB_PJ_FR2_PJ5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR2,5)))
#define TSB_PJ_FR2_PJ6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR2,6)))
#define TSB_PJ_FR2_PJ7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR2,7)))
#define TSB_PJ_FR3_PJ0F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR3,0)))
#define TSB_PJ_FR3_PJ1F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR3,1)))
#define TSB_PJ_FR3_PJ2F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR3,2)))
#define TSB_PJ_FR3_PJ3F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR3,3)))
#define TSB_PJ_FR3_PJ4F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR3,4)))
#define TSB_PJ_FR3_PJ5F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR3,5)))
#define TSB_PJ_FR3_PJ6F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR3,6)))
#define TSB_PJ_FR3_PJ7F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->FR3,7)))
#define TSB_PJ_OD_PJ0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,0)))
#define TSB_PJ_OD_PJ1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,1)))
#define TSB_PJ_OD_PJ2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,2)))
#define TSB_PJ_OD_PJ3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,3)))
#define TSB_PJ_OD_PJ4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,4)))
#define TSB_PJ_OD_PJ5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,5)))
#define TSB_PJ_OD_PJ6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,6)))
#define TSB_PJ_OD_PJ7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->OD,7)))
#define TSB_PJ_PUP_PJ0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,0)))
#define TSB_PJ_PUP_PJ1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,1)))
#define TSB_PJ_PUP_PJ2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,2)))
#define TSB_PJ_PUP_PJ3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,3)))
#define TSB_PJ_PUP_PJ4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,4)))
#define TSB_PJ_PUP_PJ5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,5)))
#define TSB_PJ_PUP_PJ6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,6)))
#define TSB_PJ_PUP_PJ7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->PUP,7)))
#define TSB_PJ_IE_PJ0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,0)))
#define TSB_PJ_IE_PJ1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,1)))
#define TSB_PJ_IE_PJ2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,2)))
#define TSB_PJ_IE_PJ3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,3)))
#define TSB_PJ_IE_PJ4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,4)))
#define TSB_PJ_IE_PJ5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,5)))
#define TSB_PJ_IE_PJ6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,6)))
#define TSB_PJ_IE_PJ7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PJ->IE,7)))


/* Port K */
#define TSB_PK_DATA_PK0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,0)))
#define TSB_PK_DATA_PK1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,1)))
#define TSB_PK_DATA_PK2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,2)))
#define TSB_PK_DATA_PK3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,3)))
#define TSB_PK_DATA_PK4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,4)))
#define TSB_PK_DATA_PK5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,5)))
#define TSB_PK_DATA_PK6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,6)))
#define TSB_PK_DATA_PK7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->DATA,7)))
#define TSB_PK_CR_PK0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,0)))
#define TSB_PK_CR_PK1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,1)))
#define TSB_PK_CR_PK2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,2)))
#define TSB_PK_CR_PK3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,3)))
#define TSB_PK_CR_PK4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,4)))
#define TSB_PK_CR_PK5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,5)))
#define TSB_PK_CR_PK6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,6)))
#define TSB_PK_CR_PK7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->CR,7)))
#define TSB_PK_FR1_PK0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,0)))
#define TSB_PK_FR1_PK1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,1)))
#define TSB_PK_FR1_PK2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,2)))
#define TSB_PK_FR1_PK3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,3)))
#define TSB_PK_FR1_PK4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,4)))
#define TSB_PK_FR1_PK5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,5)))
#define TSB_PK_FR1_PK6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,6)))
#define TSB_PK_FR1_PK7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR1,7)))
#define TSB_PK_FR2_PK0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR2,0)))
#define TSB_PK_FR2_PK1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR2,1)))
#define TSB_PK_FR2_PK2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR2,2)))
#define TSB_PK_FR2_PK3F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR2,3)))
#define TSB_PK_FR2_PK4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR2,4)))
#define TSB_PK_FR2_PK5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR2,5)))
#define TSB_PK_FR2_PK6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR2,6)))
#define TSB_PK_FR2_PK7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR2,7)))
#define TSB_PK_FR3_PK0F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR3,0)))
#define TSB_PK_FR3_PK1F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR3,1)))
#define TSB_PK_FR3_PK2F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR3,2)))
#define TSB_PK_FR3_PK3F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR3,3)))
#define TSB_PK_FR3_PK4F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR3,4)))
#define TSB_PK_FR3_PK5F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR3,5)))
#define TSB_PK_FR3_PK6F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR3,6)))
#define TSB_PK_FR3_PK7F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->FR3,7)))
#define TSB_PK_OD_PK0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,0)))
#define TSB_PK_OD_PK1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,1)))
#define TSB_PK_OD_PK2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,2)))
#define TSB_PK_OD_PK3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,3)))
#define TSB_PK_OD_PK4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,4)))
#define TSB_PK_OD_PK5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,5)))
#define TSB_PK_OD_PK6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,6)))
#define TSB_PK_OD_PK7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->OD,7)))
#define TSB_PK_PUP_PK0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,0)))
#define TSB_PK_PUP_PK1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,1)))
#define TSB_PK_PUP_PK2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,2)))
#define TSB_PK_PUP_PK3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,3)))
#define TSB_PK_PUP_PK4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,4)))
#define TSB_PK_PUP_PK5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,5)))
#define TSB_PK_PUP_PK6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,6)))
#define TSB_PK_PUP_PK7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->PUP,7)))
#define TSB_PK_IE_PK0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,0)))
#define TSB_PK_IE_PK1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,1)))
#define TSB_PK_IE_PK2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,2)))
#define TSB_PK_IE_PK3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,3)))
#define TSB_PK_IE_PK4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,4)))
#define TSB_PK_IE_PK5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,5)))
#define TSB_PK_IE_PK6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,6)))
#define TSB_PK_IE_PK7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PK->IE,7)))


/* Port L */
#define TSB_PL_DATA_PL0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,0)))
#define TSB_PL_DATA_PL1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,1)))
#define TSB_PL_DATA_PL2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,2)))
#define TSB_PL_DATA_PL3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,3)))
#define TSB_PL_DATA_PL4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,4)))
#define TSB_PL_DATA_PL5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,5)))
#define TSB_PL_DATA_PL6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,6)))
#define TSB_PL_DATA_PL7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->DATA,7)))
#define TSB_PL_CR_PL0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,0)))
#define TSB_PL_CR_PL1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,1)))
#define TSB_PL_CR_PL2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,2)))
#define TSB_PL_CR_PL3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,3)))
#define TSB_PL_CR_PL4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,4)))
#define TSB_PL_CR_PL5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,5)))
#define TSB_PL_CR_PL6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,6)))
#define TSB_PL_CR_PL7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->CR,7)))
#define TSB_PL_FR1_PL0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,0)))
#define TSB_PL_FR1_PL1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,1)))
#define TSB_PL_FR1_PL2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,2)))
#define TSB_PL_FR1_PL3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,3)))
#define TSB_PL_FR1_PL4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,4)))
#define TSB_PL_FR1_PL5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,5)))
#define TSB_PL_FR1_PL6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,6)))
#define TSB_PL_FR1_PL7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR1,7)))
#define TSB_PL_FR2_PL0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR2,0)))
#define TSB_PL_FR2_PL1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR2,1)))
#define TSB_PL_FR2_PL2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR2,2)))
#define TSB_PL_FR2_PL3F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR2,3)))
#define TSB_PL_FR2_PL4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR2,4)))
#define TSB_PL_FR2_PL5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR2,5)))
#define TSB_PL_FR2_PL6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR2,6)))
#define TSB_PL_FR2_PL7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->FR2,7)))
#define TSB_PL_OD_PL0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,0)))
#define TSB_PL_OD_PL1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,1)))
#define TSB_PL_OD_PL2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,2)))
#define TSB_PL_OD_PL3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,3)))
#define TSB_PL_OD_PL4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,4)))
#define TSB_PL_OD_PL5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,5)))
#define TSB_PL_OD_PL6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,6)))
#define TSB_PL_OD_PL7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->OD,7)))
#define TSB_PL_PUP_PL0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,0)))
#define TSB_PL_PUP_PL1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,1)))
#define TSB_PL_PUP_PL2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,2)))
#define TSB_PL_PUP_PL3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,3)))
#define TSB_PL_PUP_PL4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,4)))
#define TSB_PL_PUP_PL5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,5)))
#define TSB_PL_PUP_PL6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,6)))
#define TSB_PL_PUP_PL7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->PUP,7)))
#define TSB_PL_IE_PL0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,0)))
#define TSB_PL_IE_PL1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,1)))
#define TSB_PL_IE_PL2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,2)))
#define TSB_PL_IE_PL3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,3)))
#define TSB_PL_IE_PL4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,4)))
#define TSB_PL_IE_PL5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,5)))
#define TSB_PL_IE_PL6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,6)))
#define TSB_PL_IE_PL7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PL->IE,7)))


/* Port M */
#define TSB_PM_DATA_PM0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,0)))
#define TSB_PM_DATA_PM1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,1)))
#define TSB_PM_DATA_PM2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,2)))
#define TSB_PM_DATA_PM3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,3)))
#define TSB_PM_DATA_PM4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,4)))
#define TSB_PM_DATA_PM5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,5)))
#define TSB_PM_DATA_PM6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,6)))
#define TSB_PM_DATA_PM7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->DATA,7)))
#define TSB_PM_CR_PM0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,0)))
#define TSB_PM_CR_PM1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,1)))
#define TSB_PM_CR_PM2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,2)))
#define TSB_PM_CR_PM3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,3)))
#define TSB_PM_CR_PM4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,4)))
#define TSB_PM_CR_PM5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,5)))
#define TSB_PM_CR_PM6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,6)))
#define TSB_PM_CR_PM7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->CR,7)))
#define TSB_PM_FR1_PM0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,0)))
#define TSB_PM_FR1_PM1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,1)))
#define TSB_PM_FR1_PM2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,2)))
#define TSB_PM_FR1_PM3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,3)))
#define TSB_PM_FR1_PM4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,4)))
#define TSB_PM_FR1_PM5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,5)))
#define TSB_PM_FR1_PM6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,6)))
#define TSB_PM_FR1_PM7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR1,7)))
#define TSB_PM_FR2_PM0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR2,0)))
#define TSB_PM_FR2_PM1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR2,1)))
#define TSB_PM_FR2_PM2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR2,2)))
#define TSB_PM_FR2_PM3F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR2,3)))
#define TSB_PM_FR2_PM4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR2,4)))
#define TSB_PM_FR2_PM5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR2,5)))
#define TSB_PM_FR2_PM6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR2,6)))
#define TSB_PM_FR2_PM7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR2,7)))
#define TSB_PM_FR3_PM0F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR3,0)))
#define TSB_PM_FR3_PM1F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR3,1)))
#define TSB_PM_FR3_PM2F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR3,2)))
#define TSB_PM_FR3_PM3F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR3,3)))
#define TSB_PM_FR3_PM4F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR3,4)))
#define TSB_PM_FR3_PM5F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR3,5)))
#define TSB_PM_FR3_PM6F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR3,6)))
#define TSB_PM_FR3_PM7F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->FR3,7)))
#define TSB_PM_OD_PM0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,0)))
#define TSB_PM_OD_PM1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,1)))
#define TSB_PM_OD_PM2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,2)))
#define TSB_PM_OD_PM3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,3)))
#define TSB_PM_OD_PM4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,4)))
#define TSB_PM_OD_PM5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,5)))
#define TSB_PM_OD_PM6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,6)))
#define TSB_PM_OD_PM7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->OD,7)))
#define TSB_PM_PUP_PM0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,0)))
#define TSB_PM_PUP_PM1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,1)))
#define TSB_PM_PUP_PM2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,2)))
#define TSB_PM_PUP_PM3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,3)))
#define TSB_PM_PUP_PM4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,4)))
#define TSB_PM_PUP_PM5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,5)))
#define TSB_PM_PUP_PM6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,6)))
#define TSB_PM_PUP_PM7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->PUP,7)))
#define TSB_PM_IE_PM0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,0)))
#define TSB_PM_IE_PM1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,1)))
#define TSB_PM_IE_PM2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,2)))
#define TSB_PM_IE_PM3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,3)))
#define TSB_PM_IE_PM4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,4)))
#define TSB_PM_IE_PM5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,5)))
#define TSB_PM_IE_PM6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,6)))
#define TSB_PM_IE_PM7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PM->IE,7)))


/* Port N */
#define TSB_PN_DATA_PN0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,0)))
#define TSB_PN_DATA_PN1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,1)))
#define TSB_PN_DATA_PN2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,2)))
#define TSB_PN_DATA_PN3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,3)))
#define TSB_PN_DATA_PN4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,4)))
#define TSB_PN_DATA_PN5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,5)))
#define TSB_PN_DATA_PN6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,6)))
#define TSB_PN_DATA_PN7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->DATA,7)))
#define TSB_PN_CR_PN0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,0)))
#define TSB_PN_CR_PN1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,1)))
#define TSB_PN_CR_PN2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,2)))
#define TSB_PN_CR_PN3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,3)))
#define TSB_PN_CR_PN4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,4)))
#define TSB_PN_CR_PN5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,5)))
#define TSB_PN_CR_PN6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,6)))
#define TSB_PN_CR_PN7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->CR,7)))
#define TSB_PN_FR1_PN0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,0)))
#define TSB_PN_FR1_PN1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,1)))
#define TSB_PN_FR1_PN2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,2)))
#define TSB_PN_FR1_PN3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,3)))
#define TSB_PN_FR1_PN4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,4)))
#define TSB_PN_FR1_PN5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,5)))
#define TSB_PN_FR1_PN6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,6)))
#define TSB_PN_FR1_PN7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR1,7)))
#define TSB_PN_FR3_PN0F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR3,0)))
#define TSB_PN_FR3_PN1F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR3,1)))
#define TSB_PN_FR3_PN2F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR3,2)))
#define TSB_PN_FR3_PN3F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR3,3)))
#define TSB_PN_FR3_PN4F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR3,4)))
#define TSB_PN_FR3_PN5F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR3,5)))
#define TSB_PN_FR3_PN6F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR3,6)))
#define TSB_PN_FR3_PN7F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->FR3,7)))
#define TSB_PN_OD_PN0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,0)))
#define TSB_PN_OD_PN1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,1)))
#define TSB_PN_OD_PN2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,2)))
#define TSB_PN_OD_PN3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,3)))
#define TSB_PN_OD_PN4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,4)))
#define TSB_PN_OD_PN5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,5)))
#define TSB_PN_OD_PN6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,6)))
#define TSB_PN_OD_PN7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->OD,7)))
#define TSB_PN_PUP_PN0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,0)))
#define TSB_PN_PUP_PN1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,1)))
#define TSB_PN_PUP_PN2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,2)))
#define TSB_PN_PUP_PN3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,3)))
#define TSB_PN_PUP_PN4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,4)))
#define TSB_PN_PUP_PN5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,5)))
#define TSB_PN_PUP_PN6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,6)))
#define TSB_PN_PUP_PN7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->PUP,7)))
#define TSB_PN_IE_PN0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,0)))
#define TSB_PN_IE_PN1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,1)))
#define TSB_PN_IE_PN2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,2)))
#define TSB_PN_IE_PN3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,3)))
#define TSB_PN_IE_PN4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,4)))
#define TSB_PN_IE_PN5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,5)))
#define TSB_PN_IE_PN6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,6)))
#define TSB_PN_IE_PN7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PN->IE,7)))


/* Port P */
#define TSB_PP_DATA_PP0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->DATA,0)))
#define TSB_PP_DATA_PP1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->DATA,1)))
#define TSB_PP_DATA_PP2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->DATA,2)))
#define TSB_PP_DATA_PP3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->DATA,3)))
#define TSB_PP_DATA_PP4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->DATA,4)))
#define TSB_PP_DATA_PP5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->DATA,5)))
#define TSB_PP_DATA_PP6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->DATA,6)))
#define TSB_PP_DATA_PP7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->DATA,7)))
#define TSB_PP_CR_PP0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->CR,0)))
#define TSB_PP_CR_PP1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->CR,1)))
#define TSB_PP_CR_PP2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->CR,2)))
#define TSB_PP_CR_PP3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->CR,3)))
#define TSB_PP_CR_PP4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->CR,4)))
#define TSB_PP_CR_PP5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->CR,5)))
#define TSB_PP_CR_PP6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->CR,6)))
#define TSB_PP_CR_PP7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->CR,7)))
#define TSB_PP_FR1_PP0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR1,0)))
#define TSB_PP_FR1_PP1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR1,1)))
#define TSB_PP_FR1_PP2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR1,2)))
#define TSB_PP_FR1_PP3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR1,3)))
#define TSB_PP_FR1_PP4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR1,4)))
#define TSB_PP_FR1_PP5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR1,5)))
#define TSB_PP_FR1_PP6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR1,6)))
#define TSB_PP_FR1_PP7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR1,7)))
#define TSB_PP_FR2_PP0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR2,0)))
#define TSB_PP_FR2_PP1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR2,1)))
#define TSB_PP_FR2_PP2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR2,2)))
#define TSB_PP_FR2_PP3F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR2,3)))
#define TSB_PP_FR2_PP4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR2,4)))
#define TSB_PP_FR2_PP5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR2,5)))
#define TSB_PP_FR2_PP6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR2,6)))
#define TSB_PP_FR2_PP7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR2,7)))
#define TSB_PP_FR3_PP0F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR3,0)))
#define TSB_PP_FR3_PP1F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR3,1)))
#define TSB_PP_FR3_PP2F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR3,2)))
#define TSB_PP_FR3_PP3F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR3,3)))
#define TSB_PP_FR3_PP4F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR3,4)))
#define TSB_PP_FR3_PP5F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR3,5)))
#define TSB_PP_FR3_PP6F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR3,6)))
#define TSB_PP_FR3_PP7F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->FR3,7)))
#define TSB_PP_OD_PP0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->OD,0)))
#define TSB_PP_OD_PP1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->OD,1)))
#define TSB_PP_OD_PP2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->OD,2)))
#define TSB_PP_OD_PP3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->OD,3)))
#define TSB_PP_OD_PP4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->OD,4)))
#define TSB_PP_OD_PP5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->OD,5)))
#define TSB_PP_OD_PP6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->OD,6)))
#define TSB_PP_OD_PP7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->OD,7)))
#define TSB_PP_PUP_PP0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->PUP,0)))
#define TSB_PP_PUP_PP1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->PUP,1)))
#define TSB_PP_PUP_PP2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->PUP,2)))
#define TSB_PP_PUP_PP3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->PUP,3)))
#define TSB_PP_PUP_PP4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->PUP,4)))
#define TSB_PP_PUP_PP5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->PUP,5)))
#define TSB_PP_PUP_PP6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->PUP,6)))
#define TSB_PP_PUP_PP7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->PUP,7)))
#define TSB_PP_IE_PP0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->IE,0)))
#define TSB_PP_IE_PP1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->IE,1)))
#define TSB_PP_IE_PP2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->IE,2)))
#define TSB_PP_IE_PP3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->IE,3)))
#define TSB_PP_IE_PP4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->IE,4)))
#define TSB_PP_IE_PP5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->IE,5)))
#define TSB_PP_IE_PP6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->IE,6)))
#define TSB_PP_IE_PP7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PP->IE,7)))


/* Port R */
#define TSB_PR_DATA_PR0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->DATA,0)))
#define TSB_PR_DATA_PR1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->DATA,1)))
#define TSB_PR_DATA_PR2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->DATA,2)))
#define TSB_PR_DATA_PR3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->DATA,3)))
#define TSB_PR_DATA_PR4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->DATA,4)))
#define TSB_PR_DATA_PR5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->DATA,5)))
#define TSB_PR_DATA_PR6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->DATA,6)))
#define TSB_PR_DATA_PR7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->DATA,7)))
#define TSB_PR_CR_PR0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->CR,0)))
#define TSB_PR_CR_PR1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->CR,1)))
#define TSB_PR_CR_PR2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->CR,2)))
#define TSB_PR_CR_PR3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->CR,3)))
#define TSB_PR_CR_PR4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->CR,4)))
#define TSB_PR_CR_PR5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->CR,5)))
#define TSB_PR_CR_PR6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->CR,6)))
#define TSB_PR_CR_PR7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->CR,7)))
#define TSB_PR_FR1_PR0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR1,0)))
#define TSB_PR_FR1_PR1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR1,1)))
#define TSB_PR_FR1_PR2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR1,2)))
#define TSB_PR_FR1_PR3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR1,3)))
#define TSB_PR_FR1_PR4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR1,4)))
#define TSB_PR_FR1_PR5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR1,5)))
#define TSB_PR_FR1_PR6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR1,6)))
#define TSB_PR_FR1_PR7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR1,7)))
#define TSB_PR_FR2_PR0F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR2,0)))
#define TSB_PR_FR2_PR1F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR2,1)))
#define TSB_PR_FR2_PR2F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR2,2)))
#define TSB_PR_FR2_PR3F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR2,3)))
#define TSB_PR_FR2_PR4F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR2,4)))
#define TSB_PR_FR2_PR5F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR2,5)))
#define TSB_PR_FR2_PR6F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR2,6)))
#define TSB_PR_FR2_PR7F2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR2,7)))
#define TSB_PR_FR3_PR0F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR3,0)))
#define TSB_PR_FR3_PR1F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR3,1)))
#define TSB_PR_FR3_PR2F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR3,2)))
#define TSB_PR_FR3_PR3F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR3,3)))
#define TSB_PR_FR3_PR4F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR3,4)))
#define TSB_PR_FR3_PR5F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR3,5)))
#define TSB_PR_FR3_PR6F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR3,6)))
#define TSB_PR_FR3_PR7F3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->FR3,7)))
#define TSB_PR_OD_PR0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->OD,0)))
#define TSB_PR_OD_PR1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->OD,1)))
#define TSB_PR_OD_PR2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->OD,2)))
#define TSB_PR_OD_PR3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->OD,3)))
#define TSB_PR_OD_PR4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->OD,4)))
#define TSB_PR_OD_PR5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->OD,5)))
#define TSB_PR_OD_PR6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->OD,6)))
#define TSB_PR_OD_PR7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->OD,7)))
#define TSB_PR_PUP_PR0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->PUP,0)))
#define TSB_PR_PUP_PR1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->PUP,1)))
#define TSB_PR_PUP_PR2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->PUP,2)))
#define TSB_PR_PUP_PR3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->PUP,3)))
#define TSB_PR_PUP_PR4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->PUP,4)))
#define TSB_PR_PUP_PR5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->PUP,5)))
#define TSB_PR_PUP_PR6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->PUP,6)))
#define TSB_PR_PUP_PR7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->PUP,7)))
#define TSB_PR_IE_PR0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->IE,0)))
#define TSB_PR_IE_PR1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->IE,1)))
#define TSB_PR_IE_PR2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->IE,2)))
#define TSB_PR_IE_PR3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->IE,3)))
#define TSB_PR_IE_PR4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->IE,4)))
#define TSB_PR_IE_PR5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->IE,5)))
#define TSB_PR_IE_PR6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->IE,6)))
#define TSB_PR_IE_PR7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PR->IE,7)))


/* Port T */
#define TSB_PT_DATA_PT0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->DATA,0)))
#define TSB_PT_DATA_PT1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->DATA,1)))
#define TSB_PT_DATA_PT2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->DATA,2)))
#define TSB_PT_DATA_PT3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->DATA,3)))
#define TSB_PT_DATA_PT4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->DATA,4)))
#define TSB_PT_DATA_PT5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->DATA,5)))
#define TSB_PT_DATA_PT6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->DATA,6)))
#define TSB_PT_DATA_PT7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->DATA,7)))
#define TSB_PT_CR_PT0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->CR,0)))
#define TSB_PT_CR_PT1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->CR,1)))
#define TSB_PT_CR_PT2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->CR,2)))
#define TSB_PT_CR_PT3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->CR,3)))
#define TSB_PT_CR_PT4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->CR,4)))
#define TSB_PT_CR_PT5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->CR,5)))
#define TSB_PT_CR_PT6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->CR,6)))
#define TSB_PT_CR_PT7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->CR,7)))
#define TSB_PT_FR1_PT0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->FR1,0)))
#define TSB_PT_FR1_PT1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->FR1,1)))
#define TSB_PT_FR1_PT2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->FR1,2)))
#define TSB_PT_FR1_PT3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->FR1,3)))
#define TSB_PT_FR1_PT4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->FR1,4)))
#define TSB_PT_FR1_PT5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->FR1,5)))
#define TSB_PT_FR1_PT6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->FR1,6)))
#define TSB_PT_FR1_PT7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->FR1,7)))
#define TSB_PT_OD_PT0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->OD,0)))
#define TSB_PT_OD_PT1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->OD,1)))
#define TSB_PT_OD_PT2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->OD,2)))
#define TSB_PT_OD_PT3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->OD,3)))
#define TSB_PT_OD_PT4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->OD,4)))
#define TSB_PT_OD_PT5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->OD,5)))
#define TSB_PT_OD_PT6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->OD,6)))
#define TSB_PT_OD_PT7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->OD,7)))
#define TSB_PT_PUP_PT0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->PUP,0)))
#define TSB_PT_PUP_PT1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->PUP,1)))
#define TSB_PT_PUP_PT2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->PUP,2)))
#define TSB_PT_PUP_PT3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->PUP,3)))
#define TSB_PT_PUP_PT4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->PUP,4)))
#define TSB_PT_PUP_PT5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->PUP,5)))
#define TSB_PT_PUP_PT6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->PUP,6)))
#define TSB_PT_PUP_PT7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->PUP,7)))
#define TSB_PT_IE_PT0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->IE,0)))
#define TSB_PT_IE_PT1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->IE,1)))
#define TSB_PT_IE_PT2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->IE,2)))
#define TSB_PT_IE_PT3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->IE,3)))
#define TSB_PT_IE_PT4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->IE,4)))
#define TSB_PT_IE_PT5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->IE,5)))
#define TSB_PT_IE_PT6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->IE,6)))
#define TSB_PT_IE_PT7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PT->IE,7)))


/* Port U */
#define TSB_PU_DATA_PU0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->DATA,0)))
#define TSB_PU_DATA_PU1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->DATA,1)))
#define TSB_PU_DATA_PU2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->DATA,2)))
#define TSB_PU_DATA_PU3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->DATA,3)))
#define TSB_PU_DATA_PU4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->DATA,4)))
#define TSB_PU_DATA_PU5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->DATA,5)))
#define TSB_PU_DATA_PU6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->DATA,6)))
#define TSB_PU_DATA_PU7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->DATA,7)))
#define TSB_PU_CR_PU0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->CR,0)))
#define TSB_PU_CR_PU1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->CR,1)))
#define TSB_PU_CR_PU2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->CR,2)))
#define TSB_PU_CR_PU3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->CR,3)))
#define TSB_PU_CR_PU4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->CR,4)))
#define TSB_PU_CR_PU5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->CR,5)))
#define TSB_PU_CR_PU6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->CR,6)))
#define TSB_PU_CR_PU7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->CR,7)))
#define TSB_PU_FR1_PU0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->FR1,0)))
#define TSB_PU_FR1_PU1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->FR1,1)))
#define TSB_PU_FR1_PU2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->FR1,2)))
#define TSB_PU_FR1_PU3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->FR1,3)))
#define TSB_PU_FR1_PU4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->FR1,4)))
#define TSB_PU_FR1_PU5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->FR1,5)))
#define TSB_PU_FR1_PU6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->FR1,6)))
#define TSB_PU_FR1_PU7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->FR1,7)))
#define TSB_PU_OD_PU0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->OD,0)))
#define TSB_PU_OD_PU1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->OD,1)))
#define TSB_PU_OD_PU2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->OD,2)))
#define TSB_PU_OD_PU3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->OD,3)))
#define TSB_PU_OD_PU4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->OD,4)))
#define TSB_PU_OD_PU5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->OD,5)))
#define TSB_PU_OD_PU6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->OD,6)))
#define TSB_PU_OD_PU7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->OD,7)))
#define TSB_PU_PUP_PU0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->PUP,0)))
#define TSB_PU_PUP_PU1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->PUP,1)))
#define TSB_PU_PUP_PU2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->PUP,2)))
#define TSB_PU_PUP_PU3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->PUP,3)))
#define TSB_PU_PUP_PU4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->PUP,4)))
#define TSB_PU_PUP_PU5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->PUP,5)))
#define TSB_PU_PUP_PU6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->PUP,6)))
#define TSB_PU_PUP_PU7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->PUP,7)))
#define TSB_PU_IE_PU0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->IE,0)))
#define TSB_PU_IE_PU1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->IE,1)))
#define TSB_PU_IE_PU2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->IE,2)))
#define TSB_PU_IE_PU3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->IE,3)))
#define TSB_PU_IE_PU4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->IE,4)))
#define TSB_PU_IE_PU5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->IE,5)))
#define TSB_PU_IE_PU6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->IE,6)))
#define TSB_PU_IE_PU7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PU->IE,7)))


/* Port V */
#define TSB_PV_DATA_PV0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->DATA,0)))
#define TSB_PV_DATA_PV1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->DATA,1)))
#define TSB_PV_DATA_PV2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->DATA,2)))
#define TSB_PV_DATA_PV3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->DATA,3)))
#define TSB_PV_DATA_PV4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->DATA,4)))
#define TSB_PV_DATA_PV5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->DATA,5)))
#define TSB_PV_DATA_PV6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->DATA,6)))
#define TSB_PV_DATA_PV7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->DATA,7)))
#define TSB_PV_CR_PV0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->CR,0)))
#define TSB_PV_CR_PV1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->CR,1)))
#define TSB_PV_CR_PV2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->CR,2)))
#define TSB_PV_CR_PV3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->CR,3)))
#define TSB_PV_CR_PV4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->CR,4)))
#define TSB_PV_CR_PV5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->CR,5)))
#define TSB_PV_CR_PV6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->CR,6)))
#define TSB_PV_CR_PV7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->CR,7)))
#define TSB_PV_FR1_PV0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->FR1,0)))
#define TSB_PV_FR1_PV1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->FR1,1)))
#define TSB_PV_FR1_PV2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->FR1,2)))
#define TSB_PV_FR1_PV3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->FR1,3)))
#define TSB_PV_FR1_PV4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->FR1,4)))
#define TSB_PV_FR1_PV5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->FR1,5)))
#define TSB_PV_FR1_PV6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->FR1,6)))
#define TSB_PV_FR1_PV7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->FR1,7)))
#define TSB_PV_OD_PV0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->OD,0)))
#define TSB_PV_OD_PV1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->OD,1)))
#define TSB_PV_OD_PV2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->OD,2)))
#define TSB_PV_OD_PV3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->OD,3)))
#define TSB_PV_OD_PV4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->OD,4)))
#define TSB_PV_OD_PV5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->OD,5)))
#define TSB_PV_OD_PV6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->OD,6)))
#define TSB_PV_OD_PV7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->OD,7)))
#define TSB_PV_PUP_PV0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->PUP,0)))
#define TSB_PV_PUP_PV1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->PUP,1)))
#define TSB_PV_PUP_PV2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->PUP,2)))
#define TSB_PV_PUP_PV3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->PUP,3)))
#define TSB_PV_PUP_PV4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->PUP,4)))
#define TSB_PV_PUP_PV5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->PUP,5)))
#define TSB_PV_PUP_PV6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->PUP,6)))
#define TSB_PV_PUP_PV7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->PUP,7)))
#define TSB_PV_IE_PV0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->IE,0)))
#define TSB_PV_IE_PV1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->IE,1)))
#define TSB_PV_IE_PV2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->IE,2)))
#define TSB_PV_IE_PV3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->IE,3)))
#define TSB_PV_IE_PV4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->IE,4)))
#define TSB_PV_IE_PV5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->IE,5)))
#define TSB_PV_IE_PV6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->IE,6)))
#define TSB_PV_IE_PV7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PV->IE,7)))


/* Port W */
#define TSB_PW_DATA_PW0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->DATA,0)))
#define TSB_PW_DATA_PW1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->DATA,1)))
#define TSB_PW_DATA_PW2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->DATA,2)))
#define TSB_PW_DATA_PW3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->DATA,3)))
#define TSB_PW_DATA_PW4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->DATA,4)))
#define TSB_PW_DATA_PW5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->DATA,5)))
#define TSB_PW_DATA_PW6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->DATA,6)))
#define TSB_PW_DATA_PW7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->DATA,7)))
#define TSB_PW_CR_PW0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->CR,0)))
#define TSB_PW_CR_PW1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->CR,1)))
#define TSB_PW_CR_PW2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->CR,2)))
#define TSB_PW_CR_PW3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->CR,3)))
#define TSB_PW_CR_PW4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->CR,4)))
#define TSB_PW_CR_PW5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->CR,5)))
#define TSB_PW_CR_PW6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->CR,6)))
#define TSB_PW_CR_PW7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->CR,7)))
#define TSB_PW_FR1_PW0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->FR1,0)))
#define TSB_PW_FR1_PW1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->FR1,1)))
#define TSB_PW_FR1_PW2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->FR1,2)))
#define TSB_PW_FR1_PW3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->FR1,3)))
#define TSB_PW_FR1_PW4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->FR1,4)))
#define TSB_PW_FR1_PW5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->FR1,5)))
#define TSB_PW_FR1_PW6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->FR1,6)))
#define TSB_PW_FR1_PW7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->FR1,7)))
#define TSB_PW_OD_PW0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->OD,0)))
#define TSB_PW_OD_PW1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->OD,1)))
#define TSB_PW_OD_PW2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->OD,2)))
#define TSB_PW_OD_PW3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->OD,3)))
#define TSB_PW_OD_PW4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->OD,4)))
#define TSB_PW_OD_PW5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->OD,5)))
#define TSB_PW_OD_PW6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->OD,6)))
#define TSB_PW_OD_PW7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->OD,7)))
#define TSB_PW_PUP_PW0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->PUP,0)))
#define TSB_PW_PUP_PW1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->PUP,1)))
#define TSB_PW_PUP_PW2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->PUP,2)))
#define TSB_PW_PUP_PW3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->PUP,3)))
#define TSB_PW_PUP_PW4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->PUP,4)))
#define TSB_PW_PUP_PW5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->PUP,5)))
#define TSB_PW_PUP_PW6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->PUP,6)))
#define TSB_PW_PUP_PW7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->PUP,7)))
#define TSB_PW_IE_PW0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->IE,0)))
#define TSB_PW_IE_PW1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->IE,1)))
#define TSB_PW_IE_PW2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->IE,2)))
#define TSB_PW_IE_PW3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->IE,3)))
#define TSB_PW_IE_PW4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->IE,4)))
#define TSB_PW_IE_PW5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->IE,5)))
#define TSB_PW_IE_PW6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->IE,6)))
#define TSB_PW_IE_PW7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PW->IE,7)))


/* Port Y */
#define TSB_PY_DATA_PY0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->DATA,0)))
#define TSB_PY_DATA_PY1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->DATA,1)))
#define TSB_PY_DATA_PY2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->DATA,2)))
#define TSB_PY_DATA_PY3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->DATA,3)))
#define TSB_PY_DATA_PY4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->DATA,4)))
#define TSB_PY_DATA_PY5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->DATA,5)))
#define TSB_PY_DATA_PY6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->DATA,6)))
#define TSB_PY_DATA_PY7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->DATA,7)))
#define TSB_PY_CR_PY0C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->CR,0)))
#define TSB_PY_CR_PY1C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->CR,1)))
#define TSB_PY_CR_PY2C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->CR,2)))
#define TSB_PY_CR_PY3C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->CR,3)))
#define TSB_PY_CR_PY4C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->CR,4)))
#define TSB_PY_CR_PY5C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->CR,5)))
#define TSB_PY_CR_PY6C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->CR,6)))
#define TSB_PY_CR_PY7C                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->CR,7)))
#define TSB_PY_FR1_PY0F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->FR1,0)))
#define TSB_PY_FR1_PY1F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->FR1,1)))
#define TSB_PY_FR1_PY2F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->FR1,2)))
#define TSB_PY_FR1_PY3F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->FR1,3)))
#define TSB_PY_FR1_PY4F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->FR1,4)))
#define TSB_PY_FR1_PY5F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->FR1,5)))
#define TSB_PY_FR1_PY6F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->FR1,6)))
#define TSB_PY_FR1_PY7F1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->FR1,7)))
#define TSB_PY_OD_PY0OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->OD,0)))
#define TSB_PY_OD_PY1OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->OD,1)))
#define TSB_PY_OD_PY2OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->OD,2)))
#define TSB_PY_OD_PY3OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->OD,3)))
#define TSB_PY_OD_PY4OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->OD,4)))
#define TSB_PY_OD_PY5OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->OD,5)))
#define TSB_PY_OD_PY6OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->OD,6)))
#define TSB_PY_OD_PY7OD                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->OD,7)))
#define TSB_PY_PUP_PY0UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->PUP,0)))
#define TSB_PY_PUP_PY1UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->PUP,1)))
#define TSB_PY_PUP_PY2UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->PUP,2)))
#define TSB_PY_PUP_PY3UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->PUP,3)))
#define TSB_PY_PUP_PY4UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->PUP,4)))
#define TSB_PY_PUP_PY5UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->PUP,5)))
#define TSB_PY_PUP_PY6UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->PUP,6)))
#define TSB_PY_PUP_PY7UP                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->PUP,7)))
#define TSB_PY_IE_PY0IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->IE,0)))
#define TSB_PY_IE_PY1IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->IE,1)))
#define TSB_PY_IE_PY2IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->IE,2)))
#define TSB_PY_IE_PY3IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->IE,3)))
#define TSB_PY_IE_PY4IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->IE,4)))
#define TSB_PY_IE_PY5IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->IE,5)))
#define TSB_PY_IE_PY6IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->IE,6)))
#define TSB_PY_IE_PY7IE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_PY->IE,7)))


/* Port AA */
#define TSB_PAA_DATA_PAA0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->DATA,0)))
#define TSB_PAA_DATA_PAA1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->DATA,1)))
#define TSB_PAA_DATA_PAA2                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->DATA,2)))
#define TSB_PAA_DATA_PAA3                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->DATA,3)))
#define TSB_PAA_DATA_PAA4                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->DATA,4)))
#define TSB_PAA_DATA_PAA5                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->DATA,5)))
#define TSB_PAA_DATA_PAA6                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->DATA,6)))
#define TSB_PAA_DATA_PAA7                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->DATA,7)))
#define TSB_PAA_CR_PAA0C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->CR,0)))
#define TSB_PAA_CR_PAA1C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->CR,1)))
#define TSB_PAA_CR_PAA2C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->CR,2)))
#define TSB_PAA_CR_PAA3C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->CR,3)))
#define TSB_PAA_CR_PAA4C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->CR,4)))
#define TSB_PAA_CR_PAA5C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->CR,5)))
#define TSB_PAA_CR_PAA6C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->CR,6)))
#define TSB_PAA_CR_PAA7C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->CR,7)))
#define TSB_PAA_FR1_PAA0F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->FR1,0)))
#define TSB_PAA_FR1_PAA1F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->FR1,1)))
#define TSB_PAA_FR1_PAA2F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->FR1,2)))
#define TSB_PAA_FR1_PAA3F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->FR1,3)))
#define TSB_PAA_FR1_PAA4F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->FR1,4)))
#define TSB_PAA_FR1_PAA5F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->FR1,5)))
#define TSB_PAA_FR1_PAA6F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->FR1,6)))
#define TSB_PAA_FR1_PAA7F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->FR1,7)))
#define TSB_PAA_OD_PAA0OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->OD,0)))
#define TSB_PAA_OD_PAA1OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->OD,1)))
#define TSB_PAA_OD_PAA2OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->OD,2)))
#define TSB_PAA_OD_PAA3OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->OD,3)))
#define TSB_PAA_OD_PAA4OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->OD,4)))
#define TSB_PAA_OD_PAA5OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->OD,5)))
#define TSB_PAA_OD_PAA6OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->OD,6)))
#define TSB_PAA_OD_PAA7OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->OD,7)))
#define TSB_PAA_PUP_PAA0UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->PUP,0)))
#define TSB_PAA_PUP_PAA1UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->PUP,1)))
#define TSB_PAA_PUP_PAA2UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->PUP,2)))
#define TSB_PAA_PUP_PAA3UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->PUP,3)))
#define TSB_PAA_PUP_PAA4UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->PUP,4)))
#define TSB_PAA_PUP_PAA5UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->PUP,5)))
#define TSB_PAA_PUP_PAA6UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->PUP,6)))
#define TSB_PAA_PUP_PAA7UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->PUP,7)))
#define TSB_PAA_IE_PAA0IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->IE,0)))
#define TSB_PAA_IE_PAA1IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->IE,1)))
#define TSB_PAA_IE_PAA2IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->IE,2)))
#define TSB_PAA_IE_PAA3IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->IE,3)))
#define TSB_PAA_IE_PAA4IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->IE,4)))
#define TSB_PAA_IE_PAA5IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->IE,5)))
#define TSB_PAA_IE_PAA6IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->IE,6)))
#define TSB_PAA_IE_PAA7IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAA->IE,7)))


/* Port AB */
#define TSB_PAB_DATA_PAB0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->DATA,0)))
#define TSB_PAB_DATA_PAB1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->DATA,1)))
#define TSB_PAB_DATA_PAB2                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->DATA,2)))
#define TSB_PAB_DATA_PAB3                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->DATA,3)))
#define TSB_PAB_DATA_PAB4                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->DATA,4)))
#define TSB_PAB_DATA_PAB5                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->DATA,5)))
#define TSB_PAB_DATA_PAB6                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->DATA,6)))
#define TSB_PAB_DATA_PAB7                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->DATA,7)))
#define TSB_PAB_CR_PAB0C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->CR,0)))
#define TSB_PAB_CR_PAB1C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->CR,1)))
#define TSB_PAB_CR_PAB2C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->CR,2)))
#define TSB_PAB_CR_PAB3C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->CR,3)))
#define TSB_PAB_CR_PAB4C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->CR,4)))
#define TSB_PAB_CR_PAB5C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->CR,5)))
#define TSB_PAB_CR_PAB6C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->CR,6)))
#define TSB_PAB_CR_PAB7C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->CR,7)))
#define TSB_PAB_FR1_PAB0F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->FR1,0)))
#define TSB_PAB_FR1_PAB1F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->FR1,1)))
#define TSB_PAB_FR1_PAB2F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->FR1,2)))
#define TSB_PAB_FR1_PAB3F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->FR1,3)))
#define TSB_PAB_FR1_PAB4F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->FR1,4)))
#define TSB_PAB_FR1_PAB5F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->FR1,5)))
#define TSB_PAB_FR1_PAB6F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->FR1,6)))
#define TSB_PAB_FR1_PAB7F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->FR1,7)))
#define TSB_PAB_OD_PAB0OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->OD,0)))
#define TSB_PAB_OD_PAB1OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->OD,1)))
#define TSB_PAB_OD_PAB2OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->OD,2)))
#define TSB_PAB_OD_PAB3OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->OD,3)))
#define TSB_PAB_OD_PAB4OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->OD,4)))
#define TSB_PAB_OD_PAB5OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->OD,5)))
#define TSB_PAB_OD_PAB6OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->OD,6)))
#define TSB_PAB_OD_PAB7OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->OD,7)))
#define TSB_PAB_PUP_PAB0UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->PUP,0)))
#define TSB_PAB_PUP_PAB1UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->PUP,1)))
#define TSB_PAB_PUP_PAB2UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->PUP,2)))
#define TSB_PAB_PUP_PAB3UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->PUP,3)))
#define TSB_PAB_PUP_PAB4UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->PUP,4)))
#define TSB_PAB_PUP_PAB5UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->PUP,5)))
#define TSB_PAB_PUP_PAB6UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->PUP,6)))
#define TSB_PAB_PUP_PAB7UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->PUP,7)))
#define TSB_PAB_IE_PAB0IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->IE,0)))
#define TSB_PAB_IE_PAB1IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->IE,1)))
#define TSB_PAB_IE_PAB2IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->IE,2)))
#define TSB_PAB_IE_PAB3IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->IE,3)))
#define TSB_PAB_IE_PAB4IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->IE,4)))
#define TSB_PAB_IE_PAB5IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->IE,5)))
#define TSB_PAB_IE_PAB6IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->IE,6)))
#define TSB_PAB_IE_PAB7IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAB->IE,7)))


/* Port AC */
#define TSB_PAC_DATA_PAC0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->DATA,0)))
#define TSB_PAC_DATA_PAC1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->DATA,1)))
#define TSB_PAC_DATA_PAC2                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->DATA,2)))
#define TSB_PAC_DATA_PAC3                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->DATA,3)))
#define TSB_PAC_DATA_PAC4                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->DATA,4)))
#define TSB_PAC_DATA_PAC5                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->DATA,5)))
#define TSB_PAC_DATA_PAC6                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->DATA,6)))
#define TSB_PAC_DATA_PAC7                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->DATA,7)))
#define TSB_PAC_CR_PAC0C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->CR,0)))
#define TSB_PAC_CR_PAC1C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->CR,1)))
#define TSB_PAC_CR_PAC2C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->CR,2)))
#define TSB_PAC_CR_PAC3C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->CR,3)))
#define TSB_PAC_CR_PAC4C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->CR,4)))
#define TSB_PAC_CR_PAC5C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->CR,5)))
#define TSB_PAC_CR_PAC6C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->CR,6)))
#define TSB_PAC_CR_PAC7C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->CR,7)))
#define TSB_PAC_FR1_PAC0F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->FR1,0)))
#define TSB_PAC_FR1_PAC1F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->FR1,1)))
#define TSB_PAC_FR1_PAC2F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->FR1,2)))
#define TSB_PAC_FR1_PAC3F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->FR1,3)))
#define TSB_PAC_FR1_PAC4F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->FR1,4)))
#define TSB_PAC_FR1_PAC5F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->FR1,5)))
#define TSB_PAC_FR1_PAC6F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->FR1,6)))
#define TSB_PAC_FR1_PAC7F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->FR1,7)))
#define TSB_PAC_OD_PAC0OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->OD,0)))
#define TSB_PAC_OD_PAC1OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->OD,1)))
#define TSB_PAC_OD_PAC2OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->OD,2)))
#define TSB_PAC_OD_PAC3OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->OD,3)))
#define TSB_PAC_OD_PAC4OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->OD,4)))
#define TSB_PAC_OD_PAC5OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->OD,5)))
#define TSB_PAC_OD_PAC6OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->OD,6)))
#define TSB_PAC_OD_PAC7OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->OD,7)))
#define TSB_PAC_PUP_PAC0UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->PUP,0)))
#define TSB_PAC_PUP_PAC1UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->PUP,1)))
#define TSB_PAC_PUP_PAC2UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->PUP,2)))
#define TSB_PAC_PUP_PAC3UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->PUP,3)))
#define TSB_PAC_PUP_PAC4UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->PUP,4)))
#define TSB_PAC_PUP_PAC5UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->PUP,5)))
#define TSB_PAC_PUP_PAC6UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->PUP,6)))
#define TSB_PAC_PUP_PAC7UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->PUP,7)))
#define TSB_PAC_IE_PAC0IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->IE,0)))
#define TSB_PAC_IE_PAC1IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->IE,1)))
#define TSB_PAC_IE_PAC2IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->IE,2)))
#define TSB_PAC_IE_PAC3IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->IE,3)))
#define TSB_PAC_IE_PAC4IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->IE,4)))
#define TSB_PAC_IE_PAC5IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->IE,5)))
#define TSB_PAC_IE_PAC6IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->IE,6)))
#define TSB_PAC_IE_PAC7IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAC->IE,7)))


/* Port AD */
#define TSB_PAD_DATA_PAD0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->DATA,0)))
#define TSB_PAD_DATA_PAD1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->DATA,1)))
#define TSB_PAD_DATA_PAD2                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->DATA,2)))
#define TSB_PAD_DATA_PAD3                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->DATA,3)))
#define TSB_PAD_DATA_PAD4                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->DATA,4)))
#define TSB_PAD_DATA_PAD5                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->DATA,5)))
#define TSB_PAD_DATA_PAD6                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->DATA,6)))
#define TSB_PAD_DATA_PAD7                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->DATA,7)))
#define TSB_PAD_CR_PAD0C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->CR,0)))
#define TSB_PAD_CR_PAD1C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->CR,1)))
#define TSB_PAD_CR_PAD2C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->CR,2)))
#define TSB_PAD_CR_PAD3C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->CR,3)))
#define TSB_PAD_CR_PAD4C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->CR,4)))
#define TSB_PAD_CR_PAD5C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->CR,5)))
#define TSB_PAD_CR_PAD6C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->CR,6)))
#define TSB_PAD_CR_PAD7C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->CR,7)))
#define TSB_PAD_FR1_PAD0F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->FR1,0)))
#define TSB_PAD_FR1_PAD1F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->FR1,1)))
#define TSB_PAD_FR1_PAD2F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->FR1,2)))
#define TSB_PAD_FR1_PAD3F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->FR1,3)))
#define TSB_PAD_FR1_PAD4F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->FR1,4)))
#define TSB_PAD_FR1_PAD5F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->FR1,5)))
#define TSB_PAD_FR1_PAD6F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->FR1,6)))
#define TSB_PAD_FR1_PAD7F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->FR1,7)))
#define TSB_PAD_OD_PAD0OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->OD,0)))
#define TSB_PAD_OD_PAD1OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->OD,1)))
#define TSB_PAD_OD_PAD2OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->OD,2)))
#define TSB_PAD_OD_PAD3OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->OD,3)))
#define TSB_PAD_OD_PAD4OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->OD,4)))
#define TSB_PAD_OD_PAD5OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->OD,5)))
#define TSB_PAD_OD_PAD6OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->OD,6)))
#define TSB_PAD_OD_PAD7OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->OD,7)))
#define TSB_PAD_PUP_PAD0UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->PUP,0)))
#define TSB_PAD_PUP_PAD1UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->PUP,1)))
#define TSB_PAD_PUP_PAD2UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->PUP,2)))
#define TSB_PAD_PUP_PAD3UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->PUP,3)))
#define TSB_PAD_PUP_PAD4UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->PUP,4)))
#define TSB_PAD_PUP_PAD5UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->PUP,5)))
#define TSB_PAD_PUP_PAD6UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->PUP,6)))
#define TSB_PAD_PUP_PAD7UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->PUP,7)))
#define TSB_PAD_IE_PAD0IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->IE,0)))
#define TSB_PAD_IE_PAD1IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->IE,1)))
#define TSB_PAD_IE_PAD2IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->IE,2)))
#define TSB_PAD_IE_PAD3IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->IE,3)))
#define TSB_PAD_IE_PAD4IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->IE,4)))
#define TSB_PAD_IE_PAD5IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->IE,5)))
#define TSB_PAD_IE_PAD6IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->IE,6)))
#define TSB_PAD_IE_PAD7IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAD->IE,7)))


/* Port AE */
#define TSB_PAE_DATA_PAE0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->DATA,0)))
#define TSB_PAE_DATA_PAE1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->DATA,1)))
#define TSB_PAE_DATA_PAE2                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->DATA,2)))
#define TSB_PAE_DATA_PAE3                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->DATA,3)))
#define TSB_PAE_DATA_PAE4                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->DATA,4)))
#define TSB_PAE_DATA_PAE5                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->DATA,5)))
#define TSB_PAE_DATA_PAE6                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->DATA,6)))
#define TSB_PAE_DATA_PAE7                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->DATA,7)))
#define TSB_PAE_CR_PAE0C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->CR,0)))
#define TSB_PAE_CR_PAE1C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->CR,1)))
#define TSB_PAE_CR_PAE2C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->CR,2)))
#define TSB_PAE_CR_PAE3C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->CR,3)))
#define TSB_PAE_CR_PAE4C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->CR,4)))
#define TSB_PAE_CR_PAE5C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->CR,5)))
#define TSB_PAE_CR_PAE6C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->CR,6)))
#define TSB_PAE_CR_PAE7C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->CR,7)))
#define TSB_PAE_FR1_PAE0F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->FR1,0)))
#define TSB_PAE_FR1_PAE1F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->FR1,1)))
#define TSB_PAE_FR1_PAE2F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->FR1,2)))
#define TSB_PAE_FR1_PAE3F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->FR1,3)))
#define TSB_PAE_FR1_PAE4F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->FR1,4)))
#define TSB_PAE_FR1_PAE5F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->FR1,5)))
#define TSB_PAE_FR1_PAE6F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->FR1,6)))
#define TSB_PAE_FR1_PAE7F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->FR1,7)))
#define TSB_PAE_OD_PAE0OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->OD,0)))
#define TSB_PAE_OD_PAE1OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->OD,1)))
#define TSB_PAE_OD_PAE2OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->OD,2)))
#define TSB_PAE_OD_PAE3OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->OD,3)))
#define TSB_PAE_OD_PAE4OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->OD,4)))
#define TSB_PAE_OD_PAE5OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->OD,5)))
#define TSB_PAE_OD_PAE6OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->OD,6)))
#define TSB_PAE_OD_PAE7OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->OD,7)))
#define TSB_PAE_PAEP_PAE0UP                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->PAEP,0)))
#define TSB_PAE_PAEP_PAE1UP                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->PAEP,1)))
#define TSB_PAE_PAEP_PAE2UP                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->PAEP,2)))
#define TSB_PAE_PAEP_PAE3UP                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->PAEP,3)))
#define TSB_PAE_PAEP_PAE4UP                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->PAEP,4)))
#define TSB_PAE_PAEP_PAE5UP                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->PAEP,5)))
#define TSB_PAE_PAEP_PAE6UP                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->PAEP,6)))
#define TSB_PAE_PAEP_PAE7UP                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->PAEP,7)))
#define TSB_PAE_IE_PAE0IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->IE,0)))
#define TSB_PAE_IE_PAE1IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->IE,1)))
#define TSB_PAE_IE_PAE2IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->IE,2)))
#define TSB_PAE_IE_PAE3IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->IE,3)))
#define TSB_PAE_IE_PAE4IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->IE,4)))
#define TSB_PAE_IE_PAE5IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->IE,5)))
#define TSB_PAE_IE_PAE6IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->IE,6)))
#define TSB_PAE_IE_PAE7IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAE->IE,7)))


/* Port AF */
#define TSB_PAF_DATA_PAF0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->DATA,0)))
#define TSB_PAF_DATA_PAF1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->DATA,1)))
#define TSB_PAF_DATA_PAF2                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->DATA,2)))
#define TSB_PAF_DATA_PAF3                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->DATA,3)))
#define TSB_PAF_DATA_PAF4                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->DATA,4)))
#define TSB_PAF_DATA_PAF5                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->DATA,5)))
#define TSB_PAF_DATA_PAF6                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->DATA,6)))
#define TSB_PAF_DATA_PAF7                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->DATA,7)))
#define TSB_PAF_CR_PAF0C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->CR,0)))
#define TSB_PAF_CR_PAF1C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->CR,1)))
#define TSB_PAF_CR_PAF2C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->CR,2)))
#define TSB_PAF_CR_PAF3C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->CR,3)))
#define TSB_PAF_CR_PAF4C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->CR,4)))
#define TSB_PAF_CR_PAF5C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->CR,5)))
#define TSB_PAF_CR_PAF6C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->CR,6)))
#define TSB_PAF_CR_PAF7C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->CR,7)))
#define TSB_PAF_FR1_PAF0F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->FR1,0)))
#define TSB_PAF_FR1_PAF1F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->FR1,1)))
#define TSB_PAF_FR1_PAF2F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->FR1,2)))
#define TSB_PAF_FR1_PAF3F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->FR1,3)))
#define TSB_PAF_FR1_PAF4F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->FR1,4)))
#define TSB_PAF_FR1_PAF5F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->FR1,5)))
#define TSB_PAF_FR1_PAF6F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->FR1,6)))
#define TSB_PAF_FR1_PAF7F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->FR1,7)))
#define TSB_PAF_OD_PAF0OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->OD,0)))
#define TSB_PAF_OD_PAF1OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->OD,1)))
#define TSB_PAF_OD_PAF2OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->OD,2)))
#define TSB_PAF_OD_PAF3OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->OD,3)))
#define TSB_PAF_OD_PAF4OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->OD,4)))
#define TSB_PAF_OD_PAF5OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->OD,5)))
#define TSB_PAF_OD_PAF6OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->OD,6)))
#define TSB_PAF_OD_PAF7OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->OD,7)))
#define TSB_PAF_PUP_PAF0UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->PUP,0)))
#define TSB_PAF_PUP_PAF1UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->PUP,1)))
#define TSB_PAF_PUP_PAF2UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->PUP,2)))
#define TSB_PAF_PUP_PAF3UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->PUP,3)))
#define TSB_PAF_PUP_PAF4UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->PUP,4)))
#define TSB_PAF_PUP_PAF5UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->PUP,5)))
#define TSB_PAF_PUP_PAF6UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->PUP,6)))
#define TSB_PAF_PUP_PAF7UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->PUP,7)))
#define TSB_PAF_IE_PAF0IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->IE,0)))
#define TSB_PAF_IE_PAF1IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->IE,1)))
#define TSB_PAF_IE_PAF2IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->IE,2)))
#define TSB_PAF_IE_PAF3IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->IE,3)))
#define TSB_PAF_IE_PAF4IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->IE,4)))
#define TSB_PAF_IE_PAF5IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->IE,5)))
#define TSB_PAF_IE_PAF6IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->IE,6)))
#define TSB_PAF_IE_PAF7IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAF->IE,7)))


/* Port AG */
#define TSB_PAG_DATA_PAG0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->DATA,0)))
#define TSB_PAG_DATA_PAG1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->DATA,1)))
#define TSB_PAG_DATA_PAG2                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->DATA,2)))
#define TSB_PAG_DATA_PAG3                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->DATA,3)))
#define TSB_PAG_DATA_PAG4                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->DATA,4)))
#define TSB_PAG_DATA_PAG5                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->DATA,5)))
#define TSB_PAG_DATA_PAG6                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->DATA,6)))
#define TSB_PAG_DATA_PAG7                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->DATA,7)))
#define TSB_PAG_CR_PAG0C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->CR,0)))
#define TSB_PAG_CR_PAG1C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->CR,1)))
#define TSB_PAG_CR_PAG2C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->CR,2)))
#define TSB_PAG_CR_PAG3C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->CR,3)))
#define TSB_PAG_CR_PAG4C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->CR,4)))
#define TSB_PAG_CR_PAG5C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->CR,5)))
#define TSB_PAG_CR_PAG6C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->CR,6)))
#define TSB_PAG_CR_PAG7C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->CR,7)))
#define TSB_PAG_FR1_PAG0F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR1,0)))
#define TSB_PAG_FR1_PAG1F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR1,1)))
#define TSB_PAG_FR1_PAG2F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR1,2)))
#define TSB_PAG_FR1_PAG3F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR1,3)))
#define TSB_PAG_FR1_PAG4F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR1,4)))
#define TSB_PAG_FR1_PAG5F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR1,5)))
#define TSB_PAG_FR1_PAG6F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR1,6)))
#define TSB_PAG_FR1_PAG7F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR1,7)))
#define TSB_PAG_FR2_PAG0F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR2,0)))
#define TSB_PAG_FR2_PAG1F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR2,1)))
#define TSB_PAG_FR2_PAG2F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR2,2)))
#define TSB_PAG_FR2_PAG3F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR2,3)))
#define TSB_PAG_FR2_PAG4F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR2,4)))
#define TSB_PAG_FR2_PAG5F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR2,5)))
#define TSB_PAG_FR2_PAG6F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR2,6)))
#define TSB_PAG_FR2_PAG7F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->FR2,7)))
#define TSB_PAG_OD_PAG0OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->OD,0)))
#define TSB_PAG_OD_PAG1OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->OD,1)))
#define TSB_PAG_OD_PAG2OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->OD,2)))
#define TSB_PAG_OD_PAG3OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->OD,3)))
#define TSB_PAG_OD_PAG4OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->OD,4)))
#define TSB_PAG_OD_PAG5OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->OD,5)))
#define TSB_PAG_OD_PAG6OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->OD,6)))
#define TSB_PAG_OD_PAG7OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->OD,7)))
#define TSB_PAG_PUP_PAG0UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->PUP,0)))
#define TSB_PAG_PUP_PAG1UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->PUP,1)))
#define TSB_PAG_PUP_PAG2UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->PUP,2)))
#define TSB_PAG_PUP_PAG3UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->PUP,3)))
#define TSB_PAG_PUP_PAG4UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->PUP,4)))
#define TSB_PAG_PUP_PAG5UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->PUP,5)))
#define TSB_PAG_PUP_PAG6UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->PUP,6)))
#define TSB_PAG_PUP_PAG7UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->PUP,7)))
#define TSB_PAG_IE_PAG0IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->IE,0)))
#define TSB_PAG_IE_PAG1IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->IE,1)))
#define TSB_PAG_IE_PAG2IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->IE,2)))
#define TSB_PAG_IE_PAG3IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->IE,3)))
#define TSB_PAG_IE_PAG4IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->IE,4)))
#define TSB_PAG_IE_PAG5IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->IE,5)))
#define TSB_PAG_IE_PAG6IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->IE,6)))
#define TSB_PAG_IE_PAG7IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAG->IE,7)))


/* Port AH */
#define TSB_PAH_DATA_PAH0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->DATA,0)))
#define TSB_PAH_DATA_PAH1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->DATA,1)))
#define TSB_PAH_DATA_PAH2                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->DATA,2)))
#define TSB_PAH_DATA_PAH3                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->DATA,3)))
#define TSB_PAH_DATA_PAH4                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->DATA,4)))
#define TSB_PAH_DATA_PAH5                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->DATA,5)))
#define TSB_PAH_DATA_PAH6                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->DATA,6)))
#define TSB_PAH_DATA_PAH7                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->DATA,7)))
#define TSB_PAH_CR_PAH0C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->CR,0)))
#define TSB_PAH_CR_PAH1C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->CR,1)))
#define TSB_PAH_CR_PAH2C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->CR,2)))
#define TSB_PAH_CR_PAH3C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->CR,3)))
#define TSB_PAH_CR_PAH4C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->CR,4)))
#define TSB_PAH_CR_PAH5C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->CR,5)))
#define TSB_PAH_CR_PAH6C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->CR,6)))
#define TSB_PAH_CR_PAH7C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->CR,7)))
#define TSB_PAH_FR1_PAH0F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR1,0)))
#define TSB_PAH_FR1_PAH1F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR1,1)))
#define TSB_PAH_FR1_PAH2F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR1,2)))
#define TSB_PAH_FR1_PAH3F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR1,3)))
#define TSB_PAH_FR1_PAH4F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR1,4)))
#define TSB_PAH_FR1_PAH5F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR1,5)))
#define TSB_PAH_FR1_PAH6F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR1,6)))
#define TSB_PAH_FR1_PAH7F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR1,7)))
#define TSB_PAH_FR2_PAH0F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR2,0)))
#define TSB_PAH_FR2_PAH1F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR2,1)))
#define TSB_PAH_FR2_PAH2F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR2,2)))
#define TSB_PAH_FR2_PAH3F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR2,3)))
#define TSB_PAH_FR2_PAH4F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR2,4)))
#define TSB_PAH_FR2_PAH5F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR2,5)))
#define TSB_PAH_FR2_PAH6F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR2,6)))
#define TSB_PAH_FR2_PAH7F2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->FR2,7)))
#define TSB_PAH_OD_PAH0OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->OD,0)))
#define TSB_PAH_OD_PAH1OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->OD,1)))
#define TSB_PAH_OD_PAH2OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->OD,2)))
#define TSB_PAH_OD_PAH3OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->OD,3)))
#define TSB_PAH_OD_PAH4OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->OD,4)))
#define TSB_PAH_OD_PAH5OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->OD,5)))
#define TSB_PAH_OD_PAH6OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->OD,6)))
#define TSB_PAH_OD_PAH7OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->OD,7)))
#define TSB_PAH_PUP_PAH0UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->PUP,0)))
#define TSB_PAH_PUP_PAH1UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->PUP,1)))
#define TSB_PAH_PUP_PAH2UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->PUP,2)))
#define TSB_PAH_PUP_PAH3UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->PUP,3)))
#define TSB_PAH_PUP_PAH4UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->PUP,4)))
#define TSB_PAH_PUP_PAH5UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->PUP,5)))
#define TSB_PAH_PUP_PAH6UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->PUP,6)))
#define TSB_PAH_PUP_PAH7UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->PUP,7)))
#define TSB_PAH_IE_PAH0IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->IE,0)))
#define TSB_PAH_IE_PAH1IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->IE,1)))
#define TSB_PAH_IE_PAH2IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->IE,2)))
#define TSB_PAH_IE_PAH3IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->IE,3)))
#define TSB_PAH_IE_PAH4IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->IE,4)))
#define TSB_PAH_IE_PAH5IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->IE,5)))
#define TSB_PAH_IE_PAH6IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->IE,6)))
#define TSB_PAH_IE_PAH7IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAH->IE,7)))


/* Port AJ */
#define TSB_PAJ_DATA_PAJ0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->DATA,0)))
#define TSB_PAJ_DATA_PAJ1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->DATA,1)))
#define TSB_PAJ_DATA_PAJ2                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->DATA,2)))
#define TSB_PAJ_DATA_PAJ3                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->DATA,3)))
#define TSB_PAJ_DATA_PAJ4                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->DATA,4)))
#define TSB_PAJ_DATA_PAJ5                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->DATA,5)))
#define TSB_PAJ_DATA_PAJ6                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->DATA,6)))
#define TSB_PAJ_DATA_PAJ7                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->DATA,7)))
#define TSB_PAJ_CR_PAJ0C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->CR,0)))
#define TSB_PAJ_CR_PAJ1C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->CR,1)))
#define TSB_PAJ_CR_PAJ2C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->CR,2)))
#define TSB_PAJ_CR_PAJ3C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->CR,3)))
#define TSB_PAJ_CR_PAJ4C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->CR,4)))
#define TSB_PAJ_CR_PAJ5C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->CR,5)))
#define TSB_PAJ_CR_PAJ6C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->CR,6)))
#define TSB_PAJ_CR_PAJ7C                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->CR,7)))
#define TSB_PAJ_FR1_PAJ0F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->FR1,0)))
#define TSB_PAJ_FR1_PAJ1F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->FR1,1)))
#define TSB_PAJ_FR1_PAJ2F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->FR1,2)))
#define TSB_PAJ_FR1_PAJ3F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->FR1,3)))
#define TSB_PAJ_FR1_PAJ4F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->FR1,4)))
#define TSB_PAJ_FR1_PAJ5F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->FR1,5)))
#define TSB_PAJ_FR1_PAJ6F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->FR1,6)))
#define TSB_PAJ_FR1_PAJ7F1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->FR1,7)))
#define TSB_PAJ_OD_PAJ0OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->OD,0)))
#define TSB_PAJ_OD_PAJ1OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->OD,1)))
#define TSB_PAJ_OD_PAJ2OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->OD,2)))
#define TSB_PAJ_OD_PAJ3OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->OD,3)))
#define TSB_PAJ_OD_PAJ4OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->OD,4)))
#define TSB_PAJ_OD_PAJ5OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->OD,5)))
#define TSB_PAJ_OD_PAJ6OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->OD,6)))
#define TSB_PAJ_OD_PAJ7OD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->OD,7)))
#define TSB_PAJ_PUP_PAJ0UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->PUP,0)))
#define TSB_PAJ_PUP_PAJ1UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->PUP,1)))
#define TSB_PAJ_PUP_PAJ2UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->PUP,2)))
#define TSB_PAJ_PUP_PAJ3UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->PUP,3)))
#define TSB_PAJ_PUP_PAJ4UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->PUP,4)))
#define TSB_PAJ_PUP_PAJ5UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->PUP,5)))
#define TSB_PAJ_PUP_PAJ6UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->PUP,6)))
#define TSB_PAJ_PUP_PAJ7UP                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->PUP,7)))
#define TSB_PAJ_IE_PAJ0IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->IE,0)))
#define TSB_PAJ_IE_PAJ1IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->IE,1)))
#define TSB_PAJ_IE_PAJ2IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->IE,2)))
#define TSB_PAJ_IE_PAJ3IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->IE,3)))
#define TSB_PAJ_IE_PAJ4IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->IE,4)))
#define TSB_PAJ_IE_PAJ5IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->IE,5)))
#define TSB_PAJ_IE_PAJ6IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->IE,6)))
#define TSB_PAJ_IE_PAJ7IE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PAJ->IE,7)))


/* 16-bit Timer/Event Counter (TB) */
#define TSB_TB0_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->EN,6)))
#define TSB_TB0_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->EN,7)))
#define TSB_TB0_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->RUN,0)))
#define TSB_TB0_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->RUN,2)))
#define TSB_TB0_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,0)))
#define TSB_TB0_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,1)))
#define TSB_TB0_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,3)))
#define TSB_TB0_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,5)))
#define TSB_TB0_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->CR,7)))
#define TSB_TB0_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->MOD,3)))
#define TSB_TB0_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB0->MOD,6)))
#define TSB_TB0_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,2)))
#define TSB_TB0_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,3)))
#define TSB_TB0_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,4)))
#define TSB_TB0_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->FFCR,5)))
#define TSB_TB0_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->IM,0)))
#define TSB_TB0_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->IM,1)))
#define TSB_TB0_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->IM,2)))
#define TSB_TB0_DMA_TBDMAEN0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->DMA,0)))
#define TSB_TB0_DMA_TBDMAEN1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->DMA,1)))
#define TSB_TB0_DMA_TBDMAEN2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB0->DMA,2)))

#define TSB_TB1_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->EN,6)))
#define TSB_TB1_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->EN,7)))
#define TSB_TB1_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->RUN,0)))
#define TSB_TB1_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->RUN,2)))
#define TSB_TB1_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,0)))
#define TSB_TB1_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,1)))
#define TSB_TB1_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,3)))
#define TSB_TB1_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,5)))
#define TSB_TB1_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->CR,7)))
#define TSB_TB1_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->MOD,3)))
#define TSB_TB1_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB1->MOD,6)))
#define TSB_TB1_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,2)))
#define TSB_TB1_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,3)))
#define TSB_TB1_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,4)))
#define TSB_TB1_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->FFCR,5)))
#define TSB_TB1_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->IM,0)))
#define TSB_TB1_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->IM,1)))
#define TSB_TB1_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->IM,2)))
#define TSB_TB1_DMA_TBDMAEN0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->DMA,0)))
#define TSB_TB1_DMA_TBDMAEN1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->DMA,1)))
#define TSB_TB1_DMA_TBDMAEN2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB1->DMA,2)))

#define TSB_TB2_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->EN,6)))
#define TSB_TB2_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->EN,7)))
#define TSB_TB2_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->RUN,0)))
#define TSB_TB2_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->RUN,2)))
#define TSB_TB2_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,0)))
#define TSB_TB2_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,1)))
#define TSB_TB2_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,3)))
#define TSB_TB2_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,5)))
#define TSB_TB2_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->CR,7)))
#define TSB_TB2_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->MOD,3)))
#define TSB_TB2_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB2->MOD,6)))
#define TSB_TB2_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,2)))
#define TSB_TB2_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,3)))
#define TSB_TB2_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,4)))
#define TSB_TB2_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->FFCR,5)))
#define TSB_TB2_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->IM,0)))
#define TSB_TB2_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->IM,1)))
#define TSB_TB2_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->IM,2)))
#define TSB_TB2_DMA_TBDMAEN0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->DMA,0)))
#define TSB_TB2_DMA_TBDMAEN1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->DMA,1)))
#define TSB_TB2_DMA_TBDMAEN2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB2->DMA,2)))

#define TSB_TB3_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->EN,6)))
#define TSB_TB3_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->EN,7)))
#define TSB_TB3_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->RUN,0)))
#define TSB_TB3_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->RUN,2)))
#define TSB_TB3_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,0)))
#define TSB_TB3_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,1)))
#define TSB_TB3_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,3)))
#define TSB_TB3_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,5)))
#define TSB_TB3_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->CR,7)))
#define TSB_TB3_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->MOD,3)))
#define TSB_TB3_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB3->MOD,6)))
#define TSB_TB3_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,2)))
#define TSB_TB3_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,3)))
#define TSB_TB3_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,4)))
#define TSB_TB3_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->FFCR,5)))
#define TSB_TB3_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->IM,0)))
#define TSB_TB3_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->IM,1)))
#define TSB_TB3_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->IM,2)))
#define TSB_TB3_DMA_TBDMAEN0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->DMA,0)))
#define TSB_TB3_DMA_TBDMAEN1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->DMA,1)))
#define TSB_TB3_DMA_TBDMAEN2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB3->DMA,2)))

#define TSB_TB4_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->EN,6)))
#define TSB_TB4_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->EN,7)))
#define TSB_TB4_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->RUN,0)))
#define TSB_TB4_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->RUN,2)))
#define TSB_TB4_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,0)))
#define TSB_TB4_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,1)))
#define TSB_TB4_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,3)))
#define TSB_TB4_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,5)))
#define TSB_TB4_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->CR,7)))
#define TSB_TB4_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->MOD,3)))
#define TSB_TB4_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB4->MOD,6)))
#define TSB_TB4_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,2)))
#define TSB_TB4_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,3)))
#define TSB_TB4_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,4)))
#define TSB_TB4_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->FFCR,5)))
#define TSB_TB4_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->IM,0)))
#define TSB_TB4_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->IM,1)))
#define TSB_TB4_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->IM,2)))
#define TSB_TB4_DMA_TBDMAEN0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->DMA,0)))
#define TSB_TB4_DMA_TBDMAEN1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->DMA,1)))
#define TSB_TB4_DMA_TBDMAEN2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB4->DMA,2)))

#define TSB_TB5_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->EN,6)))
#define TSB_TB5_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->EN,7)))
#define TSB_TB5_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->RUN,0)))
#define TSB_TB5_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->RUN,2)))
#define TSB_TB5_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,0)))
#define TSB_TB5_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,1)))
#define TSB_TB5_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,3)))
#define TSB_TB5_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,5)))
#define TSB_TB5_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->CR,7)))
#define TSB_TB5_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->MOD,3)))
#define TSB_TB5_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB5->MOD,6)))
#define TSB_TB5_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->FFCR,2)))
#define TSB_TB5_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->FFCR,3)))
#define TSB_TB5_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->FFCR,4)))
#define TSB_TB5_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->FFCR,5)))
#define TSB_TB5_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->IM,0)))
#define TSB_TB5_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->IM,1)))
#define TSB_TB5_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->IM,2)))
#define TSB_TB5_DMA_TBDMAEN0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->DMA,0)))
#define TSB_TB5_DMA_TBDMAEN1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->DMA,1)))
#define TSB_TB5_DMA_TBDMAEN2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB5->DMA,2)))

#define TSB_TB6_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->EN,6)))
#define TSB_TB6_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->EN,7)))
#define TSB_TB6_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->RUN,0)))
#define TSB_TB6_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->RUN,2)))
#define TSB_TB6_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,0)))
#define TSB_TB6_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,1)))
#define TSB_TB6_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,3)))
#define TSB_TB6_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,5)))
#define TSB_TB6_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->CR,7)))
#define TSB_TB6_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->MOD,3)))
#define TSB_TB6_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB6->MOD,6)))
#define TSB_TB6_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->FFCR,2)))
#define TSB_TB6_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->FFCR,3)))
#define TSB_TB6_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->FFCR,4)))
#define TSB_TB6_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->FFCR,5)))
#define TSB_TB6_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->IM,0)))
#define TSB_TB6_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->IM,1)))
#define TSB_TB6_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->IM,2)))
#define TSB_TB6_DMA_TBDMAEN0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->DMA,0)))
#define TSB_TB6_DMA_TBDMAEN1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->DMA,1)))
#define TSB_TB6_DMA_TBDMAEN2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB6->DMA,2)))

#define TSB_TB7_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->EN,6)))
#define TSB_TB7_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->EN,7)))
#define TSB_TB7_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->RUN,0)))
#define TSB_TB7_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->RUN,2)))
#define TSB_TB7_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,0)))
#define TSB_TB7_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,1)))
#define TSB_TB7_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,3)))
#define TSB_TB7_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,5)))
#define TSB_TB7_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->CR,7)))
#define TSB_TB7_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->MOD,3)))
#define TSB_TB7_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB7->MOD,6)))
#define TSB_TB7_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->FFCR,2)))
#define TSB_TB7_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->FFCR,3)))
#define TSB_TB7_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->FFCR,4)))
#define TSB_TB7_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->FFCR,5)))
#define TSB_TB7_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->IM,0)))
#define TSB_TB7_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->IM,1)))
#define TSB_TB7_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->IM,2)))
#define TSB_TB7_DMA_TBDMAEN0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->DMA,0)))
#define TSB_TB7_DMA_TBDMAEN1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->DMA,1)))
#define TSB_TB7_DMA_TBDMAEN2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB7->DMA,2)))

#define TSB_TB8_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->EN,6)))
#define TSB_TB8_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->EN,7)))
#define TSB_TB8_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->RUN,0)))
#define TSB_TB8_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->RUN,2)))
#define TSB_TB8_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->CR,0)))
#define TSB_TB8_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->CR,1)))
#define TSB_TB8_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->CR,3)))
#define TSB_TB8_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->CR,5)))
#define TSB_TB8_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->CR,7)))
#define TSB_TB8_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->MOD,3)))
#define TSB_TB8_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB8->MOD,6)))
#define TSB_TB8_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->FFCR,2)))
#define TSB_TB8_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->FFCR,3)))
#define TSB_TB8_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->FFCR,4)))
#define TSB_TB8_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->FFCR,5)))
#define TSB_TB8_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->IM,0)))
#define TSB_TB8_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->IM,1)))
#define TSB_TB8_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->IM,2)))
#define TSB_TB8_DMA_TBDMAEN0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->DMA,0)))
#define TSB_TB8_DMA_TBDMAEN1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->DMA,1)))
#define TSB_TB8_DMA_TBDMAEN2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB8->DMA,2)))

#define TSB_TB9_EN_TBHALT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->EN,6)))
#define TSB_TB9_EN_TBEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->EN,7)))
#define TSB_TB9_RUN_TBRUN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->RUN,0)))
#define TSB_TB9_RUN_TBPRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->RUN,2)))
#define TSB_TB9_CR_CSSEL                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->CR,0)))
#define TSB_TB9_CR_TRGSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->CR,1)))
#define TSB_TB9_CR_I2TB                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->CR,3)))
#define TSB_TB9_CR_TBSYNC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->CR,5)))
#define TSB_TB9_CR_TBWBF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->CR,7)))
#define TSB_TB9_MOD_TBCLE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->MOD,3)))
#define TSB_TB9_MOD_TBCP                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB9->MOD,6)))
#define TSB_TB9_FFCR_TBE0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->FFCR,2)))
#define TSB_TB9_FFCR_TBE1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->FFCR,3)))
#define TSB_TB9_FFCR_TBC0T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->FFCR,4)))
#define TSB_TB9_FFCR_TBC1T1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->FFCR,5)))
#define TSB_TB9_IM_TBIM0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->IM,0)))
#define TSB_TB9_IM_TBIM1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->IM,1)))
#define TSB_TB9_IM_TBIMOF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->IM,2)))
#define TSB_TB9_DMA_TBDMAEN0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->DMA,0)))
#define TSB_TB9_DMA_TBDMAEN1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->DMA,1)))
#define TSB_TB9_DMA_TBDMAEN2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB9->DMA,2)))

#define TSB_TB10_EN_TBHALT                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->EN,6)))
#define TSB_TB10_EN_TBEN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->EN,7)))
#define TSB_TB10_RUN_TBRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->RUN,0)))
#define TSB_TB10_RUN_TBPRUN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->RUN,2)))
#define TSB_TB10_CR_CSSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->CR,0)))
#define TSB_TB10_CR_TRGSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->CR,1)))
#define TSB_TB10_CR_I2TB                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->CR,3)))
#define TSB_TB10_CR_TBSYNC                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->CR,5)))
#define TSB_TB10_CR_TBWBF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->CR,7)))
#define TSB_TB10_MOD_TBCLE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->MOD,3)))
#define TSB_TB10_MOD_TBCP                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB10->MOD,6)))
#define TSB_TB10_FFCR_TBE0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->FFCR,2)))
#define TSB_TB10_FFCR_TBE1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->FFCR,3)))
#define TSB_TB10_FFCR_TBC0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->FFCR,4)))
#define TSB_TB10_FFCR_TBC1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->FFCR,5)))
#define TSB_TB10_IM_TBIM0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->IM,0)))
#define TSB_TB10_IM_TBIM1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->IM,1)))
#define TSB_TB10_IM_TBIMOF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->IM,2)))
#define TSB_TB10_DMA_TBDMAEN0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->DMA,0)))
#define TSB_TB10_DMA_TBDMAEN1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->DMA,1)))
#define TSB_TB10_DMA_TBDMAEN2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB10->DMA,2)))

#define TSB_TB11_EN_TBHALT                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->EN,6)))
#define TSB_TB11_EN_TBEN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->EN,7)))
#define TSB_TB11_RUN_TBRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->RUN,0)))
#define TSB_TB11_RUN_TBPRUN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->RUN,2)))
#define TSB_TB11_CR_CSSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->CR,0)))
#define TSB_TB11_CR_TRGSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->CR,1)))
#define TSB_TB11_CR_I2TB                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->CR,3)))
#define TSB_TB11_CR_TBSYNC                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->CR,5)))
#define TSB_TB11_CR_TBWBF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->CR,7)))
#define TSB_TB11_MOD_TBCLE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->MOD,3)))
#define TSB_TB11_MOD_TBCP                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB11->MOD,6)))
#define TSB_TB11_FFCR_TBE0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->FFCR,2)))
#define TSB_TB11_FFCR_TBE1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->FFCR,3)))
#define TSB_TB11_FFCR_TBC0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->FFCR,4)))
#define TSB_TB11_FFCR_TBC1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->FFCR,5)))
#define TSB_TB11_IM_TBIM0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->IM,0)))
#define TSB_TB11_IM_TBIM1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->IM,1)))
#define TSB_TB11_IM_TBIMOF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->IM,2)))
#define TSB_TB11_DMA_TBDMAEN0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->DMA,0)))
#define TSB_TB11_DMA_TBDMAEN1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->DMA,1)))
#define TSB_TB11_DMA_TBDMAEN2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB11->DMA,2)))

#define TSB_TB12_EN_TBHALT                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->EN,6)))
#define TSB_TB12_EN_TBEN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->EN,7)))
#define TSB_TB12_RUN_TBRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->RUN,0)))
#define TSB_TB12_RUN_TBPRUN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->RUN,2)))
#define TSB_TB12_CR_CSSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->CR,0)))
#define TSB_TB12_CR_TRGSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->CR,1)))
#define TSB_TB12_CR_I2TB                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->CR,3)))
#define TSB_TB12_CR_TBSYNC                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->CR,5)))
#define TSB_TB12_CR_TBWBF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->CR,7)))
#define TSB_TB12_MOD_TBCLE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->MOD,3)))
#define TSB_TB12_MOD_TBCP                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB12->MOD,6)))
#define TSB_TB12_FFCR_TBE0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->FFCR,2)))
#define TSB_TB12_FFCR_TBE1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->FFCR,3)))
#define TSB_TB12_FFCR_TBC0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->FFCR,4)))
#define TSB_TB12_FFCR_TBC1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->FFCR,5)))
#define TSB_TB12_IM_TBIM0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->IM,0)))
#define TSB_TB12_IM_TBIM1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->IM,1)))
#define TSB_TB12_IM_TBIMOF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->IM,2)))
#define TSB_TB12_DMA_TBDMAEN0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->DMA,0)))
#define TSB_TB12_DMA_TBDMAEN1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->DMA,1)))
#define TSB_TB12_DMA_TBDMAEN2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB12->DMA,2)))

#define TSB_TB13_EN_TBHALT                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->EN,6)))
#define TSB_TB13_EN_TBEN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->EN,7)))
#define TSB_TB13_RUN_TBRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->RUN,0)))
#define TSB_TB13_RUN_TBPRUN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->RUN,2)))
#define TSB_TB13_CR_CSSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->CR,0)))
#define TSB_TB13_CR_TRGSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->CR,1)))
#define TSB_TB13_CR_I2TB                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->CR,3)))
#define TSB_TB13_CR_TBSYNC                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->CR,5)))
#define TSB_TB13_CR_TBWBF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->CR,7)))
#define TSB_TB13_MOD_TBCLE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->MOD,3)))
#define TSB_TB13_MOD_TBCP                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB13->MOD,6)))
#define TSB_TB13_FFCR_TBE0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->FFCR,2)))
#define TSB_TB13_FFCR_TBE1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->FFCR,3)))
#define TSB_TB13_FFCR_TBC0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->FFCR,4)))
#define TSB_TB13_FFCR_TBC1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->FFCR,5)))
#define TSB_TB13_IM_TBIM0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->IM,0)))
#define TSB_TB13_IM_TBIM1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->IM,1)))
#define TSB_TB13_IM_TBIMOF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->IM,2)))
#define TSB_TB13_DMA_TBDMAEN0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->DMA,0)))
#define TSB_TB13_DMA_TBDMAEN1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->DMA,1)))
#define TSB_TB13_DMA_TBDMAEN2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB13->DMA,2)))

#define TSB_TB14_EN_TBHALT                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->EN,6)))
#define TSB_TB14_EN_TBEN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->EN,7)))
#define TSB_TB14_RUN_TBRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->RUN,0)))
#define TSB_TB14_RUN_TBPRUN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->RUN,2)))
#define TSB_TB14_CR_CSSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->CR,0)))
#define TSB_TB14_CR_TRGSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->CR,1)))
#define TSB_TB14_CR_I2TB                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->CR,3)))
#define TSB_TB14_CR_TBSYNC                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->CR,5)))
#define TSB_TB14_CR_TBWBF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->CR,7)))
#define TSB_TB14_MOD_TBCLE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->MOD,3)))
#define TSB_TB14_MOD_TBCP                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB14->MOD,6)))
#define TSB_TB14_FFCR_TBE0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->FFCR,2)))
#define TSB_TB14_FFCR_TBE1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->FFCR,3)))
#define TSB_TB14_FFCR_TBC0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->FFCR,4)))
#define TSB_TB14_FFCR_TBC1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->FFCR,5)))
#define TSB_TB14_IM_TBIM0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->IM,0)))
#define TSB_TB14_IM_TBIM1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->IM,1)))
#define TSB_TB14_IM_TBIMOF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->IM,2)))
#define TSB_TB14_DMA_TBDMAEN0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->DMA,0)))
#define TSB_TB14_DMA_TBDMAEN1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->DMA,1)))
#define TSB_TB14_DMA_TBDMAEN2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB14->DMA,2)))

#define TSB_TB15_EN_TBHALT                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->EN,6)))
#define TSB_TB15_EN_TBEN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->EN,7)))
#define TSB_TB15_RUN_TBRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->RUN,0)))
#define TSB_TB15_RUN_TBPRUN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->RUN,2)))
#define TSB_TB15_CR_CSSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->CR,0)))
#define TSB_TB15_CR_TRGSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->CR,1)))
#define TSB_TB15_CR_I2TB                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->CR,3)))
#define TSB_TB15_CR_TBSYNC                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->CR,5)))
#define TSB_TB15_CR_TBWBF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->CR,7)))
#define TSB_TB15_MOD_TBCLE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->MOD,3)))
#define TSB_TB15_MOD_TBCP                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB15->MOD,6)))
#define TSB_TB15_FFCR_TBE0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->FFCR,2)))
#define TSB_TB15_FFCR_TBE1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->FFCR,3)))
#define TSB_TB15_FFCR_TBC0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->FFCR,4)))
#define TSB_TB15_FFCR_TBC1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->FFCR,5)))
#define TSB_TB15_IM_TBIM0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->IM,0)))
#define TSB_TB15_IM_TBIM1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->IM,1)))
#define TSB_TB15_IM_TBIMOF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->IM,2)))
#define TSB_TB15_DMA_TBDMAEN0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->DMA,0)))
#define TSB_TB15_DMA_TBDMAEN1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->DMA,1)))
#define TSB_TB15_DMA_TBDMAEN2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB15->DMA,2)))

#define TSB_TB16_EN_TBHALT                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->EN,6)))
#define TSB_TB16_EN_TBEN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->EN,7)))
#define TSB_TB16_RUN_TBRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->RUN,0)))
#define TSB_TB16_RUN_TBPRUN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->RUN,2)))
#define TSB_TB16_CR_CSSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->CR,0)))
#define TSB_TB16_CR_TRGSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->CR,1)))
#define TSB_TB16_CR_I2TB                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->CR,3)))
#define TSB_TB16_CR_TBSYNC                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->CR,5)))
#define TSB_TB16_CR_TBWBF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->CR,7)))
#define TSB_TB16_MOD_TBCLE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->MOD,3)))
#define TSB_TB16_MOD_TBCP                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB16->MOD,6)))
#define TSB_TB16_FFCR_TBE0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->FFCR,2)))
#define TSB_TB16_FFCR_TBE1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->FFCR,3)))
#define TSB_TB16_FFCR_TBC0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->FFCR,4)))
#define TSB_TB16_FFCR_TBC1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->FFCR,5)))
#define TSB_TB16_IM_TBIM0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->IM,0)))
#define TSB_TB16_IM_TBIM1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->IM,1)))
#define TSB_TB16_IM_TBIMOF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->IM,2)))
#define TSB_TB16_DMA_TBDMAEN0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->DMA,0)))
#define TSB_TB16_DMA_TBDMAEN1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->DMA,1)))
#define TSB_TB16_DMA_TBDMAEN2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB16->DMA,2)))

#define TSB_TB17_EN_TBHALT                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->EN,6)))
#define TSB_TB17_EN_TBEN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->EN,7)))
#define TSB_TB17_RUN_TBRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->RUN,0)))
#define TSB_TB17_RUN_TBPRUN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->RUN,2)))
#define TSB_TB17_CR_CSSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->CR,0)))
#define TSB_TB17_CR_TRGSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->CR,1)))
#define TSB_TB17_CR_I2TB                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->CR,3)))
#define TSB_TB17_CR_TBSYNC                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->CR,5)))
#define TSB_TB17_CR_TBWBF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->CR,7)))
#define TSB_TB17_MOD_TBCLE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->MOD,3)))
#define TSB_TB17_MOD_TBCP                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB17->MOD,6)))
#define TSB_TB17_FFCR_TBE0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->FFCR,2)))
#define TSB_TB17_FFCR_TBE1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->FFCR,3)))
#define TSB_TB17_FFCR_TBC0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->FFCR,4)))
#define TSB_TB17_FFCR_TBC1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->FFCR,5)))
#define TSB_TB17_IM_TBIM0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->IM,0)))
#define TSB_TB17_IM_TBIM1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->IM,1)))
#define TSB_TB17_IM_TBIMOF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->IM,2)))
#define TSB_TB17_DMA_TBDMAEN0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->DMA,0)))
#define TSB_TB17_DMA_TBDMAEN1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->DMA,1)))
#define TSB_TB17_DMA_TBDMAEN2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB17->DMA,2)))

#define TSB_TB18_EN_TBHALT                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->EN,6)))
#define TSB_TB18_EN_TBEN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->EN,7)))
#define TSB_TB18_RUN_TBRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->RUN,0)))
#define TSB_TB18_RUN_TBPRUN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->RUN,2)))
#define TSB_TB18_CR_CSSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->CR,0)))
#define TSB_TB18_CR_TRGSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->CR,1)))
#define TSB_TB18_CR_I2TB                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->CR,3)))
#define TSB_TB18_CR_TBSYNC                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->CR,5)))
#define TSB_TB18_CR_TBWBF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->CR,7)))
#define TSB_TB18_MOD_TBCLE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->MOD,3)))
#define TSB_TB18_MOD_TBCP                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB18->MOD,6)))
#define TSB_TB18_FFCR_TBE0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->FFCR,2)))
#define TSB_TB18_FFCR_TBE1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->FFCR,3)))
#define TSB_TB18_FFCR_TBC0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->FFCR,4)))
#define TSB_TB18_FFCR_TBC1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->FFCR,5)))
#define TSB_TB18_IM_TBIM0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->IM,0)))
#define TSB_TB18_IM_TBIM1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->IM,1)))
#define TSB_TB18_IM_TBIMOF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->IM,2)))
#define TSB_TB18_DMA_TBDMAEN0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->DMA,0)))
#define TSB_TB18_DMA_TBDMAEN1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->DMA,1)))
#define TSB_TB18_DMA_TBDMAEN2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB18->DMA,2)))

#define TSB_TB19_EN_TBHALT                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->EN,6)))
#define TSB_TB19_EN_TBEN                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->EN,7)))
#define TSB_TB19_RUN_TBRUN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->RUN,0)))
#define TSB_TB19_RUN_TBPRUN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->RUN,2)))
#define TSB_TB19_CR_CSSEL                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->CR,0)))
#define TSB_TB19_CR_TRGSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->CR,1)))
#define TSB_TB19_CR_I2TB                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->CR,3)))
#define TSB_TB19_CR_TBSYNC                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->CR,5)))
#define TSB_TB19_CR_TBWBF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->CR,7)))
#define TSB_TB19_MOD_TBCLE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->MOD,3)))
#define TSB_TB19_MOD_TBCP                         (*((__O  uint32_t *)BITBAND_PERI(&TSB_TB19->MOD,6)))
#define TSB_TB19_FFCR_TBE0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->FFCR,2)))
#define TSB_TB19_FFCR_TBE1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->FFCR,3)))
#define TSB_TB19_FFCR_TBC0T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->FFCR,4)))
#define TSB_TB19_FFCR_TBC1T1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->FFCR,5)))
#define TSB_TB19_IM_TBIM0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->IM,0)))
#define TSB_TB19_IM_TBIM1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->IM,1)))
#define TSB_TB19_IM_TBIMOF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->IM,2)))
#define TSB_TB19_DMA_TBDMAEN0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->DMA,0)))
#define TSB_TB19_DMA_TBDMAEN1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->DMA,1)))
#define TSB_TB19_DMA_TBDMAEN2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TB19->DMA,2)))


/* 32-bit Timer (TC) */
#define TSB_TC_EN_TCEN                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->EN,7)))
#define TSB_TC_TBTRUN_TBTRUN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->TBTRUN,0)))
#define TSB_TC_TBTRUN_TBTPRUN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->TBTRUN,1)))
#define TSB_TC_TBTRUN_TBTCAP                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->TBTRUN,2)))
#define TSB_TC_TBTRUN_I2TBT                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->TBTRUN,6)))
#define TSB_TC_TBTCR_TBTNF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->TBTCR,7)))
#define TSB_TC_CMPCTL0_CMPEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL0,0)))
#define TSB_TC_CMPCTL0_CMPRDE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL0,1)))
#define TSB_TC_CMPCTL0_TCFFEN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL0,6)))
#define TSB_TC_CMPCTL1_CMPEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL1,0)))
#define TSB_TC_CMPCTL1_CMPRDE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL1,1)))
#define TSB_TC_CMPCTL1_TCFFEN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL1,6)))
#define TSB_TC_CMPCTL2_CMPEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL2,0)))
#define TSB_TC_CMPCTL2_CMPRDE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL2,1)))
#define TSB_TC_CMPCTL2_TCFFEN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL2,6)))
#define TSB_TC_CMPCTL3_CMPEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL3,0)))
#define TSB_TC_CMPCTL3_CMPRDE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL3,1)))
#define TSB_TC_CMPCTL3_TCFFEN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL3,6)))
#define TSB_TC_CMPCTL4_CMPEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL4,0)))
#define TSB_TC_CMPCTL4_CMPRDE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL4,1)))
#define TSB_TC_CMPCTL4_TCFFEN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL4,6)))
#define TSB_TC_CMPCTL5_CMPEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL5,0)))
#define TSB_TC_CMPCTL5_CMPRDE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL5,1)))
#define TSB_TC_CMPCTL5_TCFFEN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL5,6)))
#define TSB_TC_CMPCTL6_CMPEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL6,0)))
#define TSB_TC_CMPCTL6_CMPRDE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL6,1)))
#define TSB_TC_CMPCTL6_TCFFEN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL6,6)))
#define TSB_TC_CMPCTL7_CMPEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL7,0)))
#define TSB_TC_CMPCTL7_CMPRDE                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL7,1)))
#define TSB_TC_CMPCTL7_TCFFEN                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CMPCTL7,6)))
#define TSB_TC_CAPCR0_TCNF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CAPCR0,7)))
#define TSB_TC_CAPCR1_TCNF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CAPCR1,7)))
#define TSB_TC_CAPCR2_TCNF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CAPCR2,7)))
#define TSB_TC_CAPCR3_TCNF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_TC->CAPCR3,7)))


/* Two-phase Pulse Input Count */
#define TSB_PHC0_RUN_PHCRUN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC0->RUN,0)))
#define TSB_PHC0_RUN_PHCCLR                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC0->RUN,1)))
#define TSB_PHC0_CR_NFOFF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC0->CR,2)))
#define TSB_PHC0_CR_CMP0EN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC0->CR,3)))
#define TSB_PHC0_CR_CMP1EN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC0->CR,4)))
#define TSB_PHC0_CR_EVRYINT                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC0->CR,5)))
#define TSB_PHC0_EN_PHCEN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC0->EN,0)))
#define TSB_PHC0_FLG_CMP0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC0->FLG,0)))
#define TSB_PHC0_FLG_CMP1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC0->FLG,1)))
#define TSB_PHC0_FLG_OVF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC0->FLG,2)))
#define TSB_PHC0_FLG_UDF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC0->FLG,3)))
#define TSB_PHC0_DMA_PHCDMA2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC0->DMA,2)))

#define TSB_PHC1_RUN_PHCRUN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC1->RUN,0)))
#define TSB_PHC1_RUN_PHCCLR                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC1->RUN,1)))
#define TSB_PHC1_CR_NFOFF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC1->CR,2)))
#define TSB_PHC1_CR_CMP0EN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC1->CR,3)))
#define TSB_PHC1_CR_CMP1EN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC1->CR,4)))
#define TSB_PHC1_CR_EVRYINT                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC1->CR,5)))
#define TSB_PHC1_EN_PHCEN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC1->EN,0)))
#define TSB_PHC1_FLG_CMP0                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC1->FLG,0)))
#define TSB_PHC1_FLG_CMP1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC1->FLG,1)))
#define TSB_PHC1_FLG_OVF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC1->FLG,2)))
#define TSB_PHC1_FLG_UDF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC1->FLG,3)))
#define TSB_PHC1_DMA_PHCDMA2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_PHC1->DMA,2)))


/* Real Time Clock (RTC) */
#define TSB_RTC_MONTHR_MO0                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_RTC->MONTHR,0)))


/* Serial Bus Interface (SBI) */
#define TSB_SBI_CR0_SBIEN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SBI->CR0,7)))
#define TSB_SBI_CR1_SWRMON                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI->CR1,0)))
#define TSB_SBI_CR1_ACK                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SBI->CR1,4)))
#define TSB_SBI_CR1_SIOINH                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SBI->CR1,6)))
#define TSB_SBI_CR1_SIOS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SBI->CR1,7)))
#define TSB_SBI_I2CAR_ALS                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SBI->I2CAR,0)))
#define TSB_SBI_CR2_PIN                           (*((__O  uint32_t *)BITBAND_PERI(&TSB_SBI->CR2,4)))
#define TSB_SBI_CR2_BB                            (*((__O  uint32_t *)BITBAND_PERI(&TSB_SBI->CR2,5)))
#define TSB_SBI_CR2_TRX                           (*((__O  uint32_t *)BITBAND_PERI(&TSB_SBI->CR2,6)))
#define TSB_SBI_CR2_MST                           (*((__O  uint32_t *)BITBAND_PERI(&TSB_SBI->CR2,7)))
#define TSB_SBI_SR_LRB                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI->SR,0)))
#define TSB_SBI_SR_ADO                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI->SR,1)))
#define TSB_SBI_SR_AAS                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI->SR,2)))
#define TSB_SBI_SR_AL                             (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI->SR,3)))
#define TSB_SBI_SR_PIN                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI->SR,4)))
#define TSB_SBI_SR_BB                             (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI->SR,5)))
#define TSB_SBI_SR_TRX                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI->SR,6)))
#define TSB_SBI_SR_MST                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI->SR,7)))
#define TSB_SBI_SR_SEF                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI->SR,2)))
#define TSB_SBI_SR_SIOF                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SBI->SR,3)))
#define TSB_SBI_BR0_I2SBI                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SBI->BR0,6)))


/* Serial Channel (SC) */
#define TSB_SC0_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->EN,0)))
#define TSB_SC0_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->EN,1)))
#define TSB_SC0_CR_IOC                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->CR,0)))
#define TSB_SC0_CR_SCLKS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->CR,1)))
#define TSB_SC0_CR_PE                             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->CR,5)))
#define TSB_SC0_CR_EVEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->CR,6)))
#define TSB_SC0_CR_RB8                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->CR,7)))
#define TSB_SC0_CR_TXDEMP                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->CR,10)))
#define TSB_SC0_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,4)))
#define TSB_SC0_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,5)))
#define TSB_SC0_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,6)))
#define TSB_SC0_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD0,7)))
#define TSB_SC0_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->BRCR,6)))
#define TSB_SC0_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD1,4)))
#define TSB_SC0_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD1,7)))
#define TSB_SC0_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,2)))
#define TSB_SC0_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,3)))
#define TSB_SC0_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,4)))
#define TSB_SC0_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,5)))
#define TSB_SC0_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,6)))
#define TSB_SC0_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->MOD2,7)))
#define TSB_SC0_RFC_RFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->RFC,6)))
#define TSB_SC0_RFC_RFCS                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC0->RFC,7)))
#define TSB_SC0_TFC_TFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->TFC,6)))
#define TSB_SC0_TFC_TFCS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->TFC,7)))
#define TSB_SC0_TFC_TBCLR                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->TFC,8)))
#define TSB_SC0_RST_ROR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->RST,7)))
#define TSB_SC0_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC0->TST,7)))
#define TSB_SC0_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,0)))
#define TSB_SC0_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,1)))
#define TSB_SC0_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,2)))
#define TSB_SC0_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,3)))
#define TSB_SC0_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->FCNF,4)))
#define TSB_SC0_DMA_DMAEN0                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->DMA,0)))
#define TSB_SC0_DMA_DMAEN1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC0->DMA,1)))

#define TSB_SC1_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->EN,0)))
#define TSB_SC1_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->EN,1)))
#define TSB_SC1_CR_IOC                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->CR,0)))
#define TSB_SC1_CR_SCLKS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->CR,1)))
#define TSB_SC1_CR_PE                             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->CR,5)))
#define TSB_SC1_CR_EVEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->CR,6)))
#define TSB_SC1_CR_RB8                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->CR,7)))
#define TSB_SC1_CR_TXDEMP                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->CR,10)))
#define TSB_SC1_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,4)))
#define TSB_SC1_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,5)))
#define TSB_SC1_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,6)))
#define TSB_SC1_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD0,7)))
#define TSB_SC1_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->BRCR,6)))
#define TSB_SC1_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD1,4)))
#define TSB_SC1_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD1,7)))
#define TSB_SC1_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,2)))
#define TSB_SC1_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,3)))
#define TSB_SC1_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,4)))
#define TSB_SC1_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,5)))
#define TSB_SC1_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,6)))
#define TSB_SC1_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->MOD2,7)))
#define TSB_SC1_RFC_RFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->RFC,6)))
#define TSB_SC1_RFC_RFCS                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC1->RFC,7)))
#define TSB_SC1_TFC_TFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->TFC,6)))
#define TSB_SC1_TFC_TFCS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->TFC,7)))
#define TSB_SC1_TFC_TBCLR                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->TFC,8)))
#define TSB_SC1_RST_ROR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->RST,7)))
#define TSB_SC1_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC1->TST,7)))
#define TSB_SC1_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,0)))
#define TSB_SC1_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,1)))
#define TSB_SC1_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,2)))
#define TSB_SC1_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,3)))
#define TSB_SC1_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->FCNF,4)))
#define TSB_SC1_DMA_DMAEN0                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->DMA,0)))
#define TSB_SC1_DMA_DMAEN1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC1->DMA,1)))

#define TSB_SC2_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->EN,0)))
#define TSB_SC2_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->EN,1)))
#define TSB_SC2_CR_IOC                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->CR,0)))
#define TSB_SC2_CR_SCLKS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->CR,1)))
#define TSB_SC2_CR_PE                             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->CR,5)))
#define TSB_SC2_CR_EVEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->CR,6)))
#define TSB_SC2_CR_RB8                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->CR,7)))
#define TSB_SC2_CR_TXDEMP                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->CR,10)))
#define TSB_SC2_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,4)))
#define TSB_SC2_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,5)))
#define TSB_SC2_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,6)))
#define TSB_SC2_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD0,7)))
#define TSB_SC2_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->BRCR,6)))
#define TSB_SC2_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD1,4)))
#define TSB_SC2_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD1,7)))
#define TSB_SC2_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,2)))
#define TSB_SC2_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,3)))
#define TSB_SC2_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,4)))
#define TSB_SC2_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,5)))
#define TSB_SC2_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,6)))
#define TSB_SC2_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->MOD2,7)))
#define TSB_SC2_RFC_RFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->RFC,6)))
#define TSB_SC2_RFC_RFCS                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC2->RFC,7)))
#define TSB_SC2_TFC_TFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->TFC,6)))
#define TSB_SC2_TFC_TFCS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->TFC,7)))
#define TSB_SC2_TFC_TBCLR                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->TFC,8)))
#define TSB_SC2_RST_ROR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->RST,7)))
#define TSB_SC2_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC2->TST,7)))
#define TSB_SC2_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,0)))
#define TSB_SC2_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,1)))
#define TSB_SC2_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,2)))
#define TSB_SC2_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,3)))
#define TSB_SC2_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->FCNF,4)))
#define TSB_SC2_DMA_DMAEN0                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->DMA,0)))
#define TSB_SC2_DMA_DMAEN1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC2->DMA,1)))

#define TSB_SC3_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->EN,0)))
#define TSB_SC3_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->EN,1)))
#define TSB_SC3_CR_IOC                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->CR,0)))
#define TSB_SC3_CR_SCLKS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->CR,1)))
#define TSB_SC3_CR_PE                             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->CR,5)))
#define TSB_SC3_CR_EVEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->CR,6)))
#define TSB_SC3_CR_RB8                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->CR,7)))
#define TSB_SC3_CR_TXDEMP                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->CR,10)))
#define TSB_SC3_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD0,4)))
#define TSB_SC3_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD0,5)))
#define TSB_SC3_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD0,6)))
#define TSB_SC3_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD0,7)))
#define TSB_SC3_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->BRCR,6)))
#define TSB_SC3_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD1,4)))
#define TSB_SC3_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD1,7)))
#define TSB_SC3_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,2)))
#define TSB_SC3_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,3)))
#define TSB_SC3_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,4)))
#define TSB_SC3_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,5)))
#define TSB_SC3_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,6)))
#define TSB_SC3_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->MOD2,7)))
#define TSB_SC3_RFC_RFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->RFC,6)))
#define TSB_SC3_RFC_RFCS                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC3->RFC,7)))
#define TSB_SC3_TFC_TFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->TFC,6)))
#define TSB_SC3_TFC_TFCS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->TFC,7)))
#define TSB_SC3_TFC_TBCLR                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->TFC,8)))
#define TSB_SC3_RST_ROR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->RST,7)))
#define TSB_SC3_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC3->TST,7)))
#define TSB_SC3_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,0)))
#define TSB_SC3_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,1)))
#define TSB_SC3_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,2)))
#define TSB_SC3_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,3)))
#define TSB_SC3_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->FCNF,4)))
#define TSB_SC3_DMA_DMAEN0                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->DMA,0)))
#define TSB_SC3_DMA_DMAEN1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC3->DMA,1)))

#define TSB_SC4_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->EN,0)))
#define TSB_SC4_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->EN,1)))
#define TSB_SC4_CR_IOC                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->CR,0)))
#define TSB_SC4_CR_SCLKS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->CR,1)))
#define TSB_SC4_CR_PE                             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->CR,5)))
#define TSB_SC4_CR_EVEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->CR,6)))
#define TSB_SC4_CR_RB8                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->CR,7)))
#define TSB_SC4_CR_TXDEMP                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->CR,10)))
#define TSB_SC4_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD0,4)))
#define TSB_SC4_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD0,5)))
#define TSB_SC4_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD0,6)))
#define TSB_SC4_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD0,7)))
#define TSB_SC4_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->BRCR,6)))
#define TSB_SC4_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD1,4)))
#define TSB_SC4_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD1,7)))
#define TSB_SC4_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,2)))
#define TSB_SC4_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,3)))
#define TSB_SC4_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,4)))
#define TSB_SC4_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,5)))
#define TSB_SC4_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,6)))
#define TSB_SC4_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->MOD2,7)))
#define TSB_SC4_RFC_RFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->RFC,6)))
#define TSB_SC4_RFC_RFCS                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC4->RFC,7)))
#define TSB_SC4_TFC_TFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->TFC,6)))
#define TSB_SC4_TFC_TFCS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->TFC,7)))
#define TSB_SC4_TFC_TBCLR                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->TFC,8)))
#define TSB_SC4_RST_ROR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->RST,7)))
#define TSB_SC4_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC4->TST,7)))
#define TSB_SC4_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,0)))
#define TSB_SC4_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,1)))
#define TSB_SC4_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,2)))
#define TSB_SC4_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,3)))
#define TSB_SC4_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->FCNF,4)))
#define TSB_SC4_DMA_DMAEN0                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->DMA,0)))
#define TSB_SC4_DMA_DMAEN1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC4->DMA,1)))

#define TSB_SC5_EN_SIOE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->EN,0)))
#define TSB_SC5_EN_BRCKSEL                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->EN,1)))
#define TSB_SC5_CR_IOC                            (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->CR,0)))
#define TSB_SC5_CR_SCLKS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->CR,1)))
#define TSB_SC5_CR_PE                             (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->CR,5)))
#define TSB_SC5_CR_EVEN                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->CR,6)))
#define TSB_SC5_CR_RB8                            (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC5->CR,7)))
#define TSB_SC5_CR_TXDEMP                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->CR,10)))
#define TSB_SC5_MOD0_WU                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD0,4)))
#define TSB_SC5_MOD0_RXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD0,5)))
#define TSB_SC5_MOD0_CTSE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD0,6)))
#define TSB_SC5_MOD0_TB8                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD0,7)))
#define TSB_SC5_BRCR_BRADDE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->BRCR,6)))
#define TSB_SC5_MOD1_TXE                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD1,4)))
#define TSB_SC5_MOD1_I2SC                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD1,7)))
#define TSB_SC5_MOD2_WBUF                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD2,2)))
#define TSB_SC5_MOD2_DRCHG                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD2,3)))
#define TSB_SC5_MOD2_SBLEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->MOD2,4)))
#define TSB_SC5_MOD2_TXRUN                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC5->MOD2,5)))
#define TSB_SC5_MOD2_RBFLL                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC5->MOD2,6)))
#define TSB_SC5_MOD2_TBEMP                        (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC5->MOD2,7)))
#define TSB_SC5_RFC_RFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->RFC,6)))
#define TSB_SC5_RFC_RFCS                          (*((__O  uint32_t *)BITBAND_PERI(&TSB_SC5->RFC,7)))
#define TSB_SC5_TFC_TFIS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->TFC,6)))
#define TSB_SC5_TFC_TFCS                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->TFC,7)))
#define TSB_SC5_TFC_TBCLR                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->TFC,8)))
#define TSB_SC5_RST_ROR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC5->RST,7)))
#define TSB_SC5_TST_TUR                           (*((__I  uint32_t *)BITBAND_PERI(&TSB_SC5->TST,7)))
#define TSB_SC5_FCNF_CNFG                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->FCNF,0)))
#define TSB_SC5_FCNF_RXTXCNT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->FCNF,1)))
#define TSB_SC5_FCNF_RFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->FCNF,2)))
#define TSB_SC5_FCNF_TFIE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->FCNF,3)))
#define TSB_SC5_FCNF_RFST                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->FCNF,4)))
#define TSB_SC5_DMA_DMAEN0                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->DMA,0)))
#define TSB_SC5_DMA_DMAEN1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_SC5->DMA,1)))


/* Watchdog Timer (WD) */
#define TSB_WD_MOD_RESCR                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_WD->MOD,1)))
#define TSB_WD_MOD_I2WDT                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_WD->MOD,2)))
#define TSB_WD_MOD_WDTE                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_WD->MOD,7)))


/* Clock Generator (CG) */
#define TSB_CG_SYSCR_FPSEL0                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->SYSCR,12)))
#define TSB_CG_SYSCR_FPSEL1                       (*((__I  uint32_t *)BITBAND_PERI(&TSB_CG->SYSCR,13)))
#define TSB_CG_SYSCR_SCOSEL                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->SYSCR,16)))
#define TSB_CG_SYSCR_FCSTOP0                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->SYSCR,17)))
#define TSB_CG_SYSCR_FCSTOP1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->SYSCR,18)))
#define TSB_CG_SYSCR_FCSTOP2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->SYSCR,20)))
#define TSB_CG_SYSCR_PSCSTOP                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->SYSCR,21)))
#define TSB_CG_OSCCR_WUEON                        (*((__O  uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,0)))
#define TSB_CG_OSCCR_WUEF                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,1)))
#define TSB_CG_OSCCR_PLL0ON                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,2)))
#define TSB_CG_OSCCR_WUPSEL1                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,3)))
#define TSB_CG_OSCCR_XEN1                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,8)))
#define TSB_CG_OSCCR_XTEN                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,9)))
#define TSB_CG_OSCCR_PLL1ON                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,10)))
#define TSB_CG_OSCCR_XEN2                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,16)))
#define TSB_CG_OSCCR_OSCSEL                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,17)))
#define TSB_CG_OSCCR_EHOSCSEL                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,18)))
#define TSB_CG_OSCCR_WUPSEL2                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->OSCCR,19)))
#define TSB_CG_STBYCR_DRVE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->STBYCR,16)))
#define TSB_CG_STBYCR_PTKEEP                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->STBYCR,17)))
#define TSB_CG_PLLSEL_PLL0SEL                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->PLLSEL,0)))
#define TSB_CG_PLLSEL_PLL1SEL                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->PLLSEL,16)))
#define TSB_CG_CKSEL_SYSCKFLG                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_CG->CKSEL,0)))
#define TSB_CG_CKSEL_SYSCK                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CKSEL,1)))
#define TSB_CG_PWMGEAR_TMRDCLKEN                  (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->PWMGEAR,0)))
#define TSB_CG_LKMSKA_TMRB10                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,0)))
#define TSB_CG_LKMSKA_TMRB11                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,1)))
#define TSB_CG_LKMSKA_TMRB12                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,2)))
#define TSB_CG_LKMSKA_TMRB13                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,3)))
#define TSB_CG_LKMSKA_TMRB14                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,4)))
#define TSB_CG_LKMSKA_TMRB15                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,5)))
#define TSB_CG_LKMSKA_TMRB16                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,6)))
#define TSB_CG_LKMSKA_TMRB17                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,7)))
#define TSB_CG_LKMSKA_TMRB18                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,8)))
#define TSB_CG_LKMSKA_TMRB19                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,9)))
#define TSB_CG_LKMSKA_DAC0                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,10)))
#define TSB_CG_LKMSKA_DAC1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,11)))
#define TSB_CG_LKMSKA_EBIF                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,12)))
#define TSB_CG_LKMSKA_UART0                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,13)))
#define TSB_CG_LKMSKA_UART1                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,14)))
#define TSB_CG_LKMSKA_DMACA                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,15)))
#define TSB_CG_LKMSKA_DMACB                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,16)))
#define TSB_CG_LKMSKA_DMACC                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,17)))
#define TSB_CG_LKMSKA_PORTA                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,19)))
#define TSB_CG_LKMSKA_PORTB                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,20)))
#define TSB_CG_LKMSKA_PORTC                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,21)))
#define TSB_CG_LKMSKA_PORTD                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,22)))
#define TSB_CG_LKMSKA_PORTE                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,23)))
#define TSB_CG_LKMSKA_PORTF                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,24)))
#define TSB_CG_LKMSKA_PORTG                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,25)))
#define TSB_CG_LKMSKA_PORTH                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,26)))
#define TSB_CG_LKMSKA_PORTJ                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,27)))
#define TSB_CG_LKMSKA_PORTK                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,28)))
#define TSB_CG_LKMSKA_PORTL                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,29)))
#define TSB_CG_LKMSKA_PORTM                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,30)))
#define TSB_CG_LKMSKA_PORTN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKA,31)))
#define TSB_CG_LKMSKB_PORTP                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,0)))
#define TSB_CG_LKMSKB_PORTR                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,1)))
#define TSB_CG_LKMSKB_PORTT                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,2)))
#define TSB_CG_LKMSKB_PORTU                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,3)))
#define TSB_CG_LKMSKB_PORTV                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,4)))
#define TSB_CG_LKMSKB_PORTW                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,5)))
#define TSB_CG_LKMSKB_PORTY                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,6)))
#define TSB_CG_LKMSKB_PORTAA                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,7)))
#define TSB_CG_LKMSKB_PORTAB                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,8)))
#define TSB_CG_LKMSKB_PORTAC                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,9)))
#define TSB_CG_LKMSKB_PORTAD                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,10)))
#define TSB_CG_LKMSKB_PORTAE                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,11)))
#define TSB_CG_LKMSKB_PORTAF                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,12)))
#define TSB_CG_LKMSKB_PORTAG                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,13)))
#define TSB_CG_LKMSKB_PORTAH                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,14)))
#define TSB_CG_LKMSKB_PORTAJ                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,15)))
#define TSB_CG_LKMSKB_ADCA                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,17)))
#define TSB_CG_LKMSKB_ADCB                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,18)))
#define TSB_CG_LKMSKB_ADCC                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,19)))
#define TSB_CG_LKMSKB_EPHC                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,20)))
#define TSB_CG_LKMSKB_SBI                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,21)))
#define TSB_CG_LKMSKB_WDT                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->LKMSKB,22)))
#define TSB_CG_CMSKA_ESIO0                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,0)))
#define TSB_CG_CMSKA_ESIO1                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,1)))
#define TSB_CG_CMSKA_ESIO2                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,2)))
#define TSB_CG_CMSKA_TMRD                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,3)))
#define TSB_CG_CMSKA_SIO_UART0                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,4)))
#define TSB_CG_CMSKA_SIO_UART1                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,5)))
#define TSB_CG_CMSKA_SIO_UART2                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,6)))
#define TSB_CG_CMSKA_SIO_UART3                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,7)))
#define TSB_CG_CMSKA_SIO_UART4                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,8)))
#define TSB_CG_CMSKA_SIO_UART5                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,9)))
#define TSB_CG_CMSKA_TMRB00                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,10)))
#define TSB_CG_CMSKA_TMRB01                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,11)))
#define TSB_CG_CMSKA_TMRB02                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,12)))
#define TSB_CG_CMSKA_TMRB03                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,13)))
#define TSB_CG_CMSKA_TMRB04                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,14)))
#define TSB_CG_CMSKA_TMRB05                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,15)))
#define TSB_CG_CMSKA_TMRB06                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,16)))
#define TSB_CG_CMSKA_TMRB07                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,17)))
#define TSB_CG_CMSKA_TMRB08                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,18)))
#define TSB_CG_CMSKA_TMRB09                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,19)))
#define TSB_CG_CMSKA_TMRCCAP0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,20)))
#define TSB_CG_CMSKA_TMRCCAP1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,21)))
#define TSB_CG_CMSKA_TMRCCAP2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,22)))
#define TSB_CG_CMSKA_TMRCCAP3                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,23)))
#define TSB_CG_CMSKA_TMRCCMP0                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,24)))
#define TSB_CG_CMSKA_TMRCCMP1                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,25)))
#define TSB_CG_CMSKA_TMRCCMP2                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,26)))
#define TSB_CG_CMSKA_TMRCCMP3                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,27)))
#define TSB_CG_CMSKA_TMRCCMP4                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,28)))
#define TSB_CG_CMSKA_TMRCCMP5                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,29)))
#define TSB_CG_CMSKA_TMRCCMP6                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,30)))
#define TSB_CG_CMSKA_TMRCCMP7                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKA,31)))
#define TSB_CG_CMSKB_TMRCTBT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->CMSKB,0)))
#define TSB_CG_IMCGA_INT00EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGA,0)))
#define TSB_CG_IMCGA_INT01EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGA,8)))
#define TSB_CG_IMCGA_INT02EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGA,16)))
#define TSB_CG_IMCGA_INT03EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGA,24)))
#define TSB_CG_IMCGB_INT04EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGB,0)))
#define TSB_CG_IMCGB_INT05EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGB,8)))
#define TSB_CG_IMCGB_INT6EN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGB,16)))
#define TSB_CG_IMCGB_INT07EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGB,24)))
#define TSB_CG_IMCGC_INT08EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGC,0)))
#define TSB_CG_IMCGC_INT09EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGC,8)))
#define TSB_CG_IMCGC_INT0AEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGC,16)))
#define TSB_CG_IMCGC_INT0BEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGC,24)))
#define TSB_CG_IMCGD_INT0CEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGD,0)))
#define TSB_CG_IMCGD_INT0DEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGD,8)))
#define TSB_CG_IMCGD_INT0EEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGD,16)))
#define TSB_CG_IMCGD_INT0FEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGD,24)))
#define TSB_CG_IMCGE_INT10EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGE,0)))
#define TSB_CG_IMCGE_INT11EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGE,8)))
#define TSB_CG_IMCGE_INT12EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGE,16)))
#define TSB_CG_IMCGE_INT13EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGE,24)))
#define TSB_CG_IMCGF_INT14EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGF,0)))
#define TSB_CG_IMCGF_INT15EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGF,8)))
#define TSB_CG_IMCGF_INT16EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGF,16)))
#define TSB_CG_IMCGF_INT17EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGF,24)))
#define TSB_CG_IMCGG_INT18EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGG,0)))
#define TSB_CG_IMCGG_INT19EN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGG,8)))
#define TSB_CG_IMCGG_INT1AEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGG,16)))
#define TSB_CG_IMCGG_INT1BEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGG,24)))
#define TSB_CG_IMCGH_INT1CEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGH,0)))
#define TSB_CG_IMCGH_INT1DEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGH,8)))
#define TSB_CG_IMCGH_INT1EEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGH,16)))
#define TSB_CG_IMCGH_INT1FEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->IMCGH,24)))
#define TSB_CG_RSTFLG_PONRSTF0                    (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->RSTFLG,0)))
#define TSB_CG_RSTFLG_PINRSTF                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->RSTFLG,1)))
#define TSB_CG_RSTFLG_WDTRSTF                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->RSTFLG,2)))
#define TSB_CG_RSTFLG_BUPRSTF                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->RSTFLG,3)))
#define TSB_CG_RSTFLG_SYSRSTF                     (*((__IO uint32_t *)BITBAND_PERI(&TSB_CG->RSTFLG,4)))
#define TSB_CG_RSTFLG_PONRSTF1                    (*((__I  uint32_t *)BITBAND_PERI(&TSB_CG->RSTFLG,6)))


/* Key Matrix Scan */
#define TSB_KS_EN_EN                              (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->EN,0)))
#define TSB_KS_EN_SC                              (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->EN,1)))
#define TSB_KS_ICR_KSI0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->ICR,0)))
#define TSB_KS_ICR_KSI1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->ICR,1)))
#define TSB_KS_ICR_KSI2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->ICR,2)))
#define TSB_KS_ICR_KSI3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->ICR,3)))
#define TSB_KS_ICR_KSI4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->ICR,4)))
#define TSB_KS_ICR_KSI5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->ICR,5)))
#define TSB_KS_ICR_KSI6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->ICR,6)))
#define TSB_KS_ICR_KSI7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->ICR,7)))
#define TSB_KS_OCR_KSO0                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,0)))
#define TSB_KS_OCR_KSO1                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,1)))
#define TSB_KS_OCR_KSO2                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,2)))
#define TSB_KS_OCR_KSO3                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,3)))
#define TSB_KS_OCR_KSO4                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,4)))
#define TSB_KS_OCR_KSO5                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,5)))
#define TSB_KS_OCR_KSO6                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,6)))
#define TSB_KS_OCR_KSO7                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,7)))
#define TSB_KS_OCR_KSLO0                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,8)))
#define TSB_KS_OCR_KSLO1                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,9)))
#define TSB_KS_OCR_KSLO2                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,10)))
#define TSB_KS_OCR_KSLO3                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,11)))
#define TSB_KS_OCR_KSLO4                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,12)))
#define TSB_KS_OCR_KSLO5                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,13)))
#define TSB_KS_OCR_KSLO6                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,14)))
#define TSB_KS_OCR_KSLO7                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->OCR,15)))
#define TSB_KS_CR_START                           (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->CR,0)))
#define TSB_KS_CR_BRRST                           (*((__O  uint32_t *)BITBAND_PERI(&TSB_KS->CR,1)))
#define TSB_KS_CR_CMPCNT                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->CR,4)))
#define TSB_KS_INTCR_INTEN                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KS->INTCR,0)))


/* Key On Wake Up */
#define TSB_KWUPA_CR0_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR0,0)))
#define TSB_KWUPA_CR0_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR0,7)))
#define TSB_KWUPA_CR1_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR1,0)))
#define TSB_KWUPA_CR1_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR1,7)))
#define TSB_KWUPA_CR2_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR2,0)))
#define TSB_KWUPA_CR2_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR2,7)))
#define TSB_KWUPA_CR3_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR3,0)))
#define TSB_KWUPA_CR3_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR3,7)))
#define TSB_KWUPA_CR4_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR4,0)))
#define TSB_KWUPA_CR4_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR4,7)))
#define TSB_KWUPA_CR5_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR5,0)))
#define TSB_KWUPA_CR5_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR5,7)))
#define TSB_KWUPA_CR6_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR6,0)))
#define TSB_KWUPA_CR6_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR6,7)))
#define TSB_KWUPA_CR7_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR7,0)))
#define TSB_KWUPA_CR7_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR7,7)))
#define TSB_KWUPA_CR8_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR8,0)))
#define TSB_KWUPA_CR8_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR8,7)))
#define TSB_KWUPA_CR9_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR9,0)))
#define TSB_KWUPA_CR9_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR9,7)))
#define TSB_KWUPA_CR10_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR10,0)))
#define TSB_KWUPA_CR10_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR10,7)))
#define TSB_KWUPA_CR11_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR11,0)))
#define TSB_KWUPA_CR11_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR11,7)))
#define TSB_KWUPA_CR12_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR12,0)))
#define TSB_KWUPA_CR12_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR12,7)))
#define TSB_KWUPA_CR13_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR13,0)))
#define TSB_KWUPA_CR13_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR13,7)))
#define TSB_KWUPA_CR14_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR14,0)))
#define TSB_KWUPA_CR14_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR14,7)))
#define TSB_KWUPA_CR15_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR15,0)))
#define TSB_KWUPA_CR15_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR15,7)))
#define TSB_KWUPA_CR16_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR16,0)))
#define TSB_KWUPA_CR16_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR16,7)))
#define TSB_KWUPA_CR17_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR17,0)))
#define TSB_KWUPA_CR17_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR17,7)))
#define TSB_KWUPA_CR18_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR18,0)))
#define TSB_KWUPA_CR18_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR18,7)))
#define TSB_KWUPA_CR19_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR19,0)))
#define TSB_KWUPA_CR19_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR19,7)))
#define TSB_KWUPA_CR20_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR20,0)))
#define TSB_KWUPA_CR20_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR20,7)))
#define TSB_KWUPA_CR21_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR21,0)))
#define TSB_KWUPA_CR21_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR21,7)))
#define TSB_KWUPA_CR22_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR22,0)))
#define TSB_KWUPA_CR22_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR22,7)))
#define TSB_KWUPA_CR23_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR23,0)))
#define TSB_KWUPA_CR23_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR23,7)))
#define TSB_KWUPA_CR24_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR24,0)))
#define TSB_KWUPA_CR24_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR24,7)))
#define TSB_KWUPA_CR25_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR25,0)))
#define TSB_KWUPA_CR25_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR25,7)))
#define TSB_KWUPA_CR26_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR26,0)))
#define TSB_KWUPA_CR26_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR26,7)))
#define TSB_KWUPA_CR27_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR27,0)))
#define TSB_KWUPA_CR27_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR27,7)))
#define TSB_KWUPA_CR28_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR28,0)))
#define TSB_KWUPA_CR28_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR28,7)))
#define TSB_KWUPA_CR29_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR29,0)))
#define TSB_KWUPA_CR29_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR29,7)))
#define TSB_KWUPA_CR30_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR30,0)))
#define TSB_KWUPA_CR30_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR30,7)))
#define TSB_KWUPA_CR31_KEYEN                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR31,0)))
#define TSB_KWUPA_CR31_DPE                        (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPA->CR31,7)))
#define TSB_KWUPA_PKEY_PKEY0                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,0)))
#define TSB_KWUPA_PKEY_PKEY1                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,1)))
#define TSB_KWUPA_PKEY_PKEY2                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,2)))
#define TSB_KWUPA_PKEY_PKEY3                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,3)))
#define TSB_KWUPA_PKEY_PKEY4                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,4)))
#define TSB_KWUPA_PKEY_PKEY5                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,5)))
#define TSB_KWUPA_PKEY_PKEY6                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,6)))
#define TSB_KWUPA_PKEY_PKEY7                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,7)))
#define TSB_KWUPA_PKEY_PKEY8                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,8)))
#define TSB_KWUPA_PKEY_PKEY9                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,9)))
#define TSB_KWUPA_PKEY_PKEY10                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,10)))
#define TSB_KWUPA_PKEY_PKEY11                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,11)))
#define TSB_KWUPA_PKEY_PKEY12                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,12)))
#define TSB_KWUPA_PKEY_PKEY13                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,13)))
#define TSB_KWUPA_PKEY_PKEY14                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,14)))
#define TSB_KWUPA_PKEY_PKEY15                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,15)))
#define TSB_KWUPA_PKEY_PKEY16                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,16)))
#define TSB_KWUPA_PKEY_PKEY17                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,17)))
#define TSB_KWUPA_PKEY_PKEY18                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,18)))
#define TSB_KWUPA_PKEY_PKEY19                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,19)))
#define TSB_KWUPA_PKEY_PKEY20                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,20)))
#define TSB_KWUPA_PKEY_PKEY21                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,21)))
#define TSB_KWUPA_PKEY_PKEY22                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,22)))
#define TSB_KWUPA_PKEY_PKEY23                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,23)))
#define TSB_KWUPA_PKEY_PKEY24                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,24)))
#define TSB_KWUPA_PKEY_PKEY25                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,25)))
#define TSB_KWUPA_PKEY_PKEY26                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,26)))
#define TSB_KWUPA_PKEY_PKEY27                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,27)))
#define TSB_KWUPA_PKEY_PKEY28                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,28)))
#define TSB_KWUPA_PKEY_PKEY29                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,29)))
#define TSB_KWUPA_PKEY_PKEY30                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,30)))
#define TSB_KWUPA_PKEY_PKEY31                     (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPA->PKEY,31)))

#define TSB_KWUPB_CR0_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR0,0)))
#define TSB_KWUPB_CR0_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR0,7)))
#define TSB_KWUPB_CR1_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR1,0)))
#define TSB_KWUPB_CR1_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR1,7)))
#define TSB_KWUPB_CR2_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR2,0)))
#define TSB_KWUPB_CR2_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR2,7)))
#define TSB_KWUPB_CR3_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR3,0)))
#define TSB_KWUPB_CR3_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR3,7)))
#define TSB_KWUPB_CR4_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR4,0)))
#define TSB_KWUPB_CR4_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR4,7)))
#define TSB_KWUPB_CR5_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR5,0)))
#define TSB_KWUPB_CR5_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR5,7)))
#define TSB_KWUPB_CR6_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR6,0)))
#define TSB_KWUPB_CR6_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR6,7)))
#define TSB_KWUPB_CR7_KEYEN                       (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR7,0)))
#define TSB_KWUPB_CR7_DPE                         (*((__IO uint32_t *)BITBAND_PERI(&TSB_KWUPB->CR7,7)))
#define TSB_KWUPB_PKEY_PKEY0                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPB->PKEY,0)))
#define TSB_KWUPB_PKEY_PKEY1                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPB->PKEY,1)))
#define TSB_KWUPB_PKEY_PKEY2                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPB->PKEY,2)))
#define TSB_KWUPB_PKEY_PKEY3                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPB->PKEY,3)))
#define TSB_KWUPB_PKEY_PKEY4                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPB->PKEY,4)))
#define TSB_KWUPB_PKEY_PKEY5                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPB->PKEY,5)))
#define TSB_KWUPB_PKEY_PKEY6                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPB->PKEY,6)))
#define TSB_KWUPB_PKEY_PKEY7                      (*((__I  uint32_t *)BITBAND_PERI(&TSB_KWUPB->PKEY,7)))


/* Flash Control (FC) */
#define TSB_FC_SECBIT_SECBIT                      (*((__IO uint32_t *)BITBAND_PERI(&TSB_FC->SECBIT,0)))
#define TSB_FC_CR_FLBOFF                          (*((__IO uint32_t *)BITBAND_PERI(&TSB_FC->CR,0)))
#define TSB_FC_SR_RDY_BSY                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->SR,0)))
#define TSB_FC_PSRA_BLK0                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,0)))
#define TSB_FC_PSRA_BLK1                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,1)))
#define TSB_FC_PSRA_BLK2                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,2)))
#define TSB_FC_PSRA_BLK3                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,3)))
#define TSB_FC_PSRA_BLK4                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,4)))
#define TSB_FC_PSRA_BLK5                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,5)))
#define TSB_FC_PSRA_BLK6                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,6)))
#define TSB_FC_PSRA_BLK7                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,7)))
#define TSB_FC_PSRA_BLK8                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,8)))
#define TSB_FC_PSRA_BLK9                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,9)))
#define TSB_FC_PSRA_BLK10                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,10)))
#define TSB_FC_PSRA_BLK11                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,11)))
#define TSB_FC_PSRA_BLK12                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,12)))
#define TSB_FC_PSRA_BLK13                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRA,13)))
#define TSB_FC_PSRB_BLK0                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,0)))
#define TSB_FC_PSRB_BLK1                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,1)))
#define TSB_FC_PSRB_BLK2                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,2)))
#define TSB_FC_PSRB_BLK3                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,3)))
#define TSB_FC_PSRB_BLK4                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,4)))
#define TSB_FC_PSRB_BLK5                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,5)))
#define TSB_FC_PSRB_BLK6                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,6)))
#define TSB_FC_PSRB_BLK7                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,7)))
#define TSB_FC_PSRB_BLK8                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,8)))
#define TSB_FC_PSRB_BLK9                          (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,9)))
#define TSB_FC_PSRB_BLK10                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,10)))
#define TSB_FC_PSRB_BLK11                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,11)))
#define TSB_FC_PSRB_BLK12                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,12)))
#define TSB_FC_PSRB_BLK13                         (*((__I  uint32_t *)BITBAND_PERI(&TSB_FC->PSRB,13)))

/** @} */ /* End of group Device_Peripheral_registers */

#ifdef __cplusplus
}
#endif

#endif  /* __TMPM440_H__ */

/** @} */ /* End of group TMPM440 */
/** @} */ /* End of group TOSHIBA_TX04_MICROCONTROLLER */
