/*********************************************************************
*                     SEGGER Microcontroller GmbH                    *
*                        The Embedded Experts                        *
**********************************************************************
*                                                                    *
*       (c) 1995 - 2022 SEGGER Microcontroller GmbH                  *
*                                                                    *
*       Internet: segger.com  Support: support_embos@segger.com      *
*                                                                    *
**********************************************************************
*                                                                    *
*       embOS * Real time operating system                           *
*                                                                    *
*       Please note:                                                 *
*                                                                    *
*       Knowledge of this file may under no circumstances            *
*       be used to write a similar product or a real-time            *
*       operating system for in-house use.                           *
*                                                                    *
*       Thank you for your fairness !                                *
*                                                                    *
**********************************************************************
*                                                                    *
*       OS version: V5.18.0.0                                        *
*                                                                    *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------

File    : SEGGER_SYSVIEW_Conf.h
Purpose : SEGGER SystemView configuration file.
          Set defines which deviate from the defaults (see SEGGER_SYSVIEW_ConfDefaults.h) here.
Revision: $Rev: 21292 $

Additional information:
  Required defines which must be set are:
    SEGGER_SYSVIEW_GET_TIMESTAMP
    SEGGER_SYSVIEW_GET_INTERRUPT_ID
  For known compilers and cores, these might be set to good defaults
  in SEGGER_SYSVIEW_ConfDefaults.h.

  SystemView needs a (nestable) locking mechanism.
  If not defined, the RTT locking mechanism is used,
  which then needs to be properly configured.
*/

#ifndef SEGGER_SYSVIEW_CONF_H
#define SEGGER_SYSVIEW_CONF_H

#include <stdint.h>

/*********************************************************************
*
*       Defines, configurable
*
**********************************************************************
*/
extern uint32_t SystemCoreClock;

#define SEGGER_SYSVIEW_APP_NAME        "embOS start project"
#define SEGGER_SYSVIEW_DEVICE_NAME     "MK66FN2M0xxx18"
#define SEGGER_SYSVIEW_ID_BASE         0x1FFF0000
#define SEGGER_SYSVIEW_TIMESTAMP_FREQ  SystemCoreClock
#define SEGGER_SYSVIEW_CPU_FREQ        SystemCoreClock
#define SEGGER_SYSVIEW_SYSDESC0        "I#15=SysTick"

#endif  // SEGGER_SYSVIEW_CONF_H

/*************************** End of file ****************************/
