/*****************************************************************************
 *                   SEGGER Microcontroller GmbH & Co. KG                    *
 *            Solutions for real time microcontroller applications           *
 *****************************************************************************
 *                                                                           *
 *               (c) 2018 SEGGER Microcontroller GmbH & Co. KG               *
 *                                                                           *
 *           Internet: www.segger.com   Support: support@segger.com          *
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 0

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak SPI0_IRQHandler
  .thumb_set SPI0_IRQHandler,Dummy_Handler

  .weak DAC0_IRQHandler
  .thumb_set DAC0_IRQHandler,Dummy_Handler

  .weak UART0_IRQHandler
  .thumb_set UART0_IRQHandler,Dummy_Handler

  .weak UART1_IRQHandler
  .thumb_set UART1_IRQHandler,Dummy_Handler

  .weak I2C1_IRQHandler
  .thumb_set I2C1_IRQHandler,Dummy_Handler

  .weak I2C0_IRQHandler
  .thumb_set I2C0_IRQHandler,Dummy_Handler

  .weak MRT_IRQHandler
  .thumb_set MRT_IRQHandler,Dummy_Handler

  .weak CMP_IRQHandler
  .thumb_set CMP_IRQHandler,Dummy_Handler

  .weak WDT_IRQHandler
  .thumb_set WDT_IRQHandler,Dummy_Handler

  .weak BOD_IRQHandler
  .thumb_set BOD_IRQHandler,Dummy_Handler

  .weak FLASH_IRQHandler
  .thumb_set FLASH_IRQHandler,Dummy_Handler

  .weak WKT_IRQHandler
  .thumb_set WKT_IRQHandler,Dummy_Handler

  .weak ADC_SEQA_IRQHandler
  .thumb_set ADC_SEQA_IRQHandler,Dummy_Handler

  .weak ADC_SEQB_IRQHandler
  .thumb_set ADC_SEQB_IRQHandler,Dummy_Handler

  .weak ADC_THCMP_IRQHandler
  .thumb_set ADC_THCMP_IRQHandler,Dummy_Handler

  .weak ADC_OVR_IRQHandler
  .thumb_set ADC_OVR_IRQHandler,Dummy_Handler

  .weak CT32B0_IRQHandler
  .thumb_set CT32B0_IRQHandler,Dummy_Handler

  .weak PININT0_IRQHandler
  .thumb_set PININT0_IRQHandler,Dummy_Handler

  .weak PININT1_IRQHandler
  .thumb_set PININT1_IRQHandler,Dummy_Handler

  .weak PININT2_IRQHandler
  .thumb_set PININT2_IRQHandler,Dummy_Handler

  .weak PININT3_IRQHandler
  .thumb_set PININT3_IRQHandler,Dummy_Handler

  .weak PININT4_IRQHandler
  .thumb_set PININT4_IRQHandler,Dummy_Handler

  .weak PININT5_IRQHandler
  .thumb_set PININT5_IRQHandler,Dummy_Handler

  .weak PININT6_IRQHandler
  .thumb_set PININT6_IRQHandler,Dummy_Handler

  .weak PININT7_IRQHandler
  .thumb_set PININT7_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak SPI0_IRQHandler
SPI0_IRQHandler:
  b .

  .thumb_func
  .weak DAC0_IRQHandler
DAC0_IRQHandler:
  b .

  .thumb_func
  .weak UART0_IRQHandler
UART0_IRQHandler:
  b .

  .thumb_func
  .weak UART1_IRQHandler
UART1_IRQHandler:
  b .

  .thumb_func
  .weak I2C1_IRQHandler
I2C1_IRQHandler:
  b .

  .thumb_func
  .weak I2C0_IRQHandler
I2C0_IRQHandler:
  b .

  .thumb_func
  .weak MRT_IRQHandler
MRT_IRQHandler:
  b .

  .thumb_func
  .weak CMP_IRQHandler
CMP_IRQHandler:
  b .

  .thumb_func
  .weak WDT_IRQHandler
WDT_IRQHandler:
  b .

  .thumb_func
  .weak BOD_IRQHandler
BOD_IRQHandler:
  b .

  .thumb_func
  .weak FLASH_IRQHandler
FLASH_IRQHandler:
  b .

  .thumb_func
  .weak WKT_IRQHandler
WKT_IRQHandler:
  b .

  .thumb_func
  .weak ADC_SEQA_IRQHandler
ADC_SEQA_IRQHandler:
  b .

  .thumb_func
  .weak ADC_SEQB_IRQHandler
ADC_SEQB_IRQHandler:
  b .

  .thumb_func
  .weak ADC_THCMP_IRQHandler
ADC_THCMP_IRQHandler:
  b .

  .thumb_func
  .weak ADC_OVR_IRQHandler
ADC_OVR_IRQHandler:
  b .

  .thumb_func
  .weak CT32B0_IRQHandler
CT32B0_IRQHandler:
  b .

  .thumb_func
  .weak PININT0_IRQHandler
PININT0_IRQHandler:
  b .

  .thumb_func
  .weak PININT1_IRQHandler
PININT1_IRQHandler:
  b .

  .thumb_func
  .weak PININT2_IRQHandler
PININT2_IRQHandler:
  b .

  .thumb_func
  .weak PININT3_IRQHandler
PININT3_IRQHandler:
  b .

  .thumb_func
  .weak PININT4_IRQHandler
PININT4_IRQHandler:
  b .

  .thumb_func
  .weak PININT5_IRQHandler
PININT5_IRQHandler:
  b .

  .thumb_func
  .weak PININT6_IRQHandler
PININT6_IRQHandler:
  b .

  .thumb_func
  .weak PININT7_IRQHandler
PININT7_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .align 0
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word SPI0_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word DAC0_IRQHandler
  .word UART0_IRQHandler
  .word UART1_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word I2C1_IRQHandler
  .word I2C0_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word MRT_IRQHandler
  .word CMP_IRQHandler
  .word WDT_IRQHandler
  .word BOD_IRQHandler
  .word FLASH_IRQHandler
  .word WKT_IRQHandler
  .word ADC_SEQA_IRQHandler
  .word ADC_SEQB_IRQHandler
  .word ADC_THCMP_IRQHandler
  .word ADC_OVR_IRQHandler
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word Dummy_Handler /* Reserved */
  .word CT32B0_IRQHandler
  .word PININT0_IRQHandler
  .word PININT1_IRQHandler
  .word PININT2_IRQHandler
  .word PININT3_IRQHandler
  .word PININT4_IRQHandler
  .word PININT5_IRQHandler
  .word PININT6_IRQHandler
  .word PININT7_IRQHandler
_vectors_end:

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .align 0
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
