/*********************************************************************
*                    SEGGER Microcontroller GmbH                     *
*                        The Embedded Experts                        *
**********************************************************************
*                                                                    *
*            (c) 2014 - 2019 SEGGER Microcontroller GmbH             *
*                                                                    *
*       www.segger.com     Support: support@segger.com               *
*                                                                    *
**********************************************************************
*                                                                    *
* All rights reserved.                                               *
*                                                                    *
* Redistribution and use in source and binary forms, with or         *
* without modification, are permitted provided that the following    *
* condition is met:                                                  *
*                                                                    *
* o Redistributions of source code must retain the above copyright   *
*   notice, this condition and the following disclaimer.             *
*                                                                    *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND             *
* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,        *
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF           *
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE           *
* DISCLAIMED. IN NO EVENT SHALL SEGGER Microcontroller BE LIABLE FOR *
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR           *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT  *
* OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;    *
* OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      *
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT          *
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE  *
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH   *
* DAMAGE.                                                            *
*                                                                    *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------

File    : ARM_Startup.s
Purpose : Generic startup for ARM, Cortex-A, and Cortex-R processors.

*/
        .syntax unified   // Use unified ARM Instruction Set Syntax
        .arm              // Select ARM instruction set

/*********************************************************************
*
*       Macros
*
**********************************************************************
*/
/*********************************************************************
*
*       ISR_HANDLER
*
*    Declare a weak interrupt handler as endless loop,
*    and put it at the current index in the vector table.
*/
.macro ISR_HANDLER Name
        .section .vectors, "ax"
        ldr PC, =\Name
        .section .init, "ax"
        .global \Name
        .type   \Name, function
        .weak   \Name
        .arm
\Name:
1:      b 1b /* endless loop */
.endm

/*********************************************************************
*
*       ISR_RESERVED
*
*    Put a NULL vector at the current index in the vector table.
*/
.macro ISR_RESERVED
        .section .vectors, "ax"
        nop
.endm

/*********************************************************************
*
*       FUNC
*
*    Declare a global function
*/
.macro FUNC Name
        .global \Name
        .type   \Name, function
        .arm
        .balign 4
\Name:
.endm

/*********************************************************************
*
*       (Assembler) Defines
*
**********************************************************************
*/
        .equ reset_handler, Reset_Handler

/*********************************************************************
*
*       Global symbols
*
**********************************************************************
*/
        .global _vectors
        .global reset_handler

/*********************************************************************
*
*       Vector table and default interupt handlers
*
**********************************************************************
*/
        .section .vectors, "ax"
        .align 0
        //
        // Start of vector table
        //
_vectors:
        //
        // ARM Exceptions
        //
        ldr PC, =Reset_Handler
        ISR_HANDLER Undef_Handler
        ISR_HANDLER SVC_Handler
        ISR_HANDLER PAbort_Handler
        ISR_HANDLER DAbort_Handler
        ISR_RESERVED
        ISR_HANDLER IRQ_Handler
        ISR_HANDLER FIQ_Handler
        //
        // External vectors
        //
#ifdef __VECTORS
  #include __VECTORS  // Include vectors from file
#else  
        //
        // Add target's interrupts here.
        // Example:
        // ldr PC, =ExternalISR0
        // ldr PC, =ExternalISR1
        // ldr PC, =ExternalISR2
        // ldr PC, =ExternalISR3
        //
#endif
        //
        // End of vector table
        //
        .section .vectors, "ax"
_vectors_end:

/*********************************************************************
*
*       Global functions
*
**********************************************************************
*/
        .section .init, "ax"

/*********************************************************************
*
*       Reset_Handler()
*
*  Function description
*    Interrupt handler, called on reset.
*    Call system initialization and memory initialization,
*    enable floating point unit if required,
*    and call runtime init.
*/
  FUNC Reset_Handler
        //
        // Configure target system here
        //
#ifdef __FLASH_BUILD
        //
        // Put any FLASH build configuration specific code here
        //
#endif

#if !defined(__SOFTFP__)
        //
        // Enable floating point unit (CP11 and CP10)
        //
        mrc P15, #0x00, R0, C1, C0, #0x02
        orr R0, R0, #0x00F00000
        mcr P15, #0x00, R0, C1, C0, #0x02
        // enable VFP
        mov R0, #0x40000000
        fmxr fpexc, R0
#endif
        //
        // Call C runtime startup
        //
        b _start


/*************************** End of file ****************************/
