/*********************************************************************
*                    SEGGER Microcontroller GmbH                     *
*                        The Embedded Experts                        *
**********************************************************************
*                                                                    *
*            (c) 2018 - 2018 SEGGER Microcontroller GmbH             *
*                                                                    *
*           www.segger.com     Support: support@segger.com           *
*                                                                    *
**********************************************************************
*                                                                    *
* All rights reserved.                                               *
*                                                                    *
* Redistribution and use in source and binary forms, with or         *
* without modification, are permitted provided that the following    *
* conditions are met:                                                *
*                                                                    *
* - Redistributions of source code must retain the above copyright   *
*   notice, this list of conditions and the following disclaimer.    *
*                                                                    *
* - Neither the name of SEGGER Microcontroller GmbH                  *
*   nor the names of its contributors may be used to endorse or      *
*   promote products derived from this software without specific     *
*   prior written permission.                                        *
*                                                                    *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND             *
* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,        *
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF           *
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE           *
* DISCLAIMED.                                                        *
* IN NO EVENT SHALL SEGGER Microcontroller GmbH BE LIABLE FOR        *
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR           *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT  *
* OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;    *
* OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      *
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT          *
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE  *
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH   *
* DAMAGE.                                                            *
*                                                                    *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------

File    : main.c
Purpose : Generic application start

*/

#define U32 unsigned int
#define FPGA_LED *((volatile U32*)(0x41302000 + 0x00))

/*********************************************************************
*
*       _Delay()
*/
static void _Delay(void) {
  volatile U32 Cnt;

  Cnt = 800000;
  while(--Cnt);
}

/*********************************************************************
*
*       main()
*
*  Function description
*   Application entry point.
*/
void main(void) {
  volatile U32* pCmd;
  //
  // Core 0 controls LED1 and LED2
  // LED1 is toggled as long as core 0 runs
  // LED2 is toggled as long as core 1 runs and gives toggle commands to core 0
  //
  pCmd = (volatile U32*)0x10000000;        // Unused RAM, used as command area
  *pCmd = 0x12345678;
  FPGA_LED = 0;    // All LEDs off
  do {
    //
    // Toggle LED 1
    //
    FPGA_LED |= (1ul << 0);
    if (*pCmd != 0x12345678) {      // Core 1 instructs LED toggle?
      FPGA_LED |= (1ul << 1);
      *pCmd = 0x12345678;
      __asm("DSB");
    }
    _Delay();
    FPGA_LED &= ~(1ul << 0);
    if (*pCmd != 0x12345678) {      // Core 1 instructs LED toggle?
      FPGA_LED &= ~(1ul << 1);
      *pCmd = 0x12345678;
      __asm("DSB");
    }
    _Delay();
  } while (1);
}

/*************************** End of file ****************************/
