/*
 * Copyright (c) 2023, Ambiq Micro, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its
 * contributors may be used to endorse or promote products derived from this
 * software without specific prior written permission.
 *
 * Third party software included in this distribution is subject to the
 * additional license terms as defined in the /docs/licenses directory.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @file     apollo3.h
 * @brief    CMSIS HeaderFile
 * @version  1.0
 * @date     18. August 2023
 * @note     Generated by SVDConv V3.3.42 on Friday, 18.08.2023 11:58:23
 *           from File 'apollo3.svd',
 *           last modified on Monday, 24.07.2023 10:07:30
 */



/** @addtogroup Ambiq Micro
  * @{
  */


/** @addtogroup apollo3
  * @{
  */


#ifndef APOLLO3_H
#define APOLLO3_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M4 Specific Interrupt Numbers  ======================================== */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  MemoryManagement_IRQn     = -12,              /*!< -12  Memory Management, MPU mismatch, including Access Violation
                                                     and No Match                                                              */
  BusFault_IRQn             = -11,              /*!< -11  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                     related Fault                                                             */
  UsageFault_IRQn           = -10,              /*!< -10  Usage Fault, i.e. Undef Instruction, Illegal State Transition        */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  DebugMonitor_IRQn         =  -4,              /*!< -4 Debug Monitor                                                          */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* ==========================================  apollo3 Specific Interrupt Numbers  =========================================== */
  BROWNOUT_IRQn             =   0,              /*!< 0  BROWNOUT_IRQ                                                           */
  WDT_IRQn                  =   1,              /*!< 1  WDT_IRQ                                                                */
  RTC_IRQn                  =   2,              /*!< 2  RTC_IRQ                                                                */
  VCOMP_IRQn                =   3,              /*!< 3  VCOMP_IRQ                                                              */
  IOSLAVE_IRQn              =   4,              /*!< 4  IOSLAVE_IRQ                                                            */
  IOSLAVEACC_IRQn           =   5,              /*!< 5  IOSLAVEACC_IRQ                                                         */
  IOMSTR0_IRQn              =   6,              /*!< 6  IOMSTR0_IRQ                                                            */
  IOMSTR1_IRQn              =   7,              /*!< 7  IOMSTR1_IRQ                                                            */
  IOMSTR2_IRQn              =   8,              /*!< 8  IOMSTR2_IRQ                                                            */
  IOMSTR3_IRQn              =   9,              /*!< 9  IOMSTR3_IRQ                                                            */
  IOMSTR4_IRQn              =  10,              /*!< 10 IOMSTR4_IRQ                                                            */
  IOMSTR5_IRQn              =  11,              /*!< 11 IOMSTR5_IRQ                                                            */
  BLE_IRQn                  =  12,              /*!< 12 BLE_IRQ                                                                */
  GPIO_IRQn                 =  13,              /*!< 13 GPIO_IRQ                                                               */
  CTIMER_IRQn               =  14,              /*!< 14 CTIMER_IRQ                                                             */
  UART0_IRQn                =  15,              /*!< 15 UART0_IRQ                                                              */
  UART1_IRQn                =  16,              /*!< 16 UART1_IRQ                                                              */
  SCARD_IRQn                =  17,              /*!< 17 SCARD_IRQ                                                              */
  ADC_IRQn                  =  18,              /*!< 18 ADC_IRQ                                                                */
  PDM_IRQn                  =  19,              /*!< 19 PDM_IRQ                                                                */
  MSPI0_IRQn                =  20,              /*!< 20 MSPI0_IRQ                                                              */
  STIMER_IRQn               =  22,              /*!< 22 STIMER_IRQ                                                             */
  STIMER_CMPR0_IRQn         =  23,              /*!< 23 STIMER_CMPR0_IRQ                                                       */
  STIMER_CMPR1_IRQn         =  24,              /*!< 24 STIMER_CMPR1_IRQ                                                       */
  STIMER_CMPR2_IRQn         =  25,              /*!< 25 STIMER_CMPR2_IRQ                                                       */
  STIMER_CMPR3_IRQn         =  26,              /*!< 26 STIMER_CMPR3_IRQ                                                       */
  STIMER_CMPR4_IRQn         =  27,              /*!< 27 STIMER_CMPR4_IRQ                                                       */
  STIMER_CMPR5_IRQn         =  28,              /*!< 28 STIMER_CMPR5_IRQ                                                       */
  STIMER_CMPR6_IRQn         =  29,              /*!< 29 STIMER_CMPR6_IRQ                                                       */
  STIMER_CMPR7_IRQn         =  30,              /*!< 30 STIMER_CMPR7_IRQ                                                       */
  CLKGEN_IRQn               =  31,              /*!< 31 CLKGEN_IRQ                                                             */
  MAX_IRQn                  =  32               /*!< 32 Not a valid IRQ. The maximum IRQ is this value - 1.                    */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ===========================  Configuration of the ARM Cortex-M4 Processor and Core Peripherals  =========================== */
#define __CM4_REV                 0x0100U       /*!< CM4 Core Revision                                                         */
#define __NVIC_PRIO_BITS               3        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __VTOR_PRESENT                 1        /*!< Set to 1 if CPU supports Vector Table Offset Register                     */
#define __MPU_PRESENT                  1        /*!< MPU present                                                               */
#define __FPU_PRESENT                  1        /*!< FPU present                                                               */
#define __FPU_DP                       0        /*!< Double Precision FPU                                                      */
#define __DSP_PRESENT                  0        /*!< DSP extension present                                                     */
#define __ICACHE_PRESENT               1        /*!< Instruction Cache present                                                 */
#define __DCACHE_PRESENT               1        /*!< Data Cache present                                                        */
#define __ITCM_PRESENT                 1        /*!< Instruction TCM present                                                   */
#define __DTCM_PRESENT                 1        /*!< Data TCM present                                                          */
#define __SAUREGION_PRESENT            0        /*!< SAU region present                                                        */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                           /*!< ARM Cortex-M4 processor and core peripherals                              */
#include "system_apollo3.h"                     /*!< apollo3 System                                                            */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
  #pragma clang diagnostic ignored "-Wgnu-anonymous-struct"
  #pragma clang diagnostic ignored "-Wnested-anon-types"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Analog Digital Converter Control (ADC)
  */

typedef struct {                                /*!< (@ 0x50010000) ADC Structure                                              */

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) The ADC Configuration Register contains the software
                                                                    control for selecting the clock frequency
                                                                    used for the SAR conversions, the trigger
                                                                    polarity, the trigger select, the reference
                                                                    voltage select, the low power mode, the
                                                                    operating mode (single scan per trigger
                                                                    vs. repeating mode) and ADC enable.                        */

    struct {
      __IOM uint32_t ADCEN      : 1;            /*!< [0..0] This bit enables the ADC module. While the ADC is enabled,
                                                     the ADCCFG and SLOT Configuration register settings must
                                                     remain stable and unchanged. All configuration register
                                                     settings, slot configuration settings and window comparison
                                                     settings should be written prior to setting the ADCEN bit
                                                     to '1'.                                                                   */
            uint32_t            : 1;
      __IOM uint32_t RPTEN      : 1;            /*!< [2..2] This bit enables Repeating Scan Mode.                              */
      __IOM uint32_t LPMODE     : 1;            /*!< [3..3] Select power mode to enter between active scans.                   */
      __IOM uint32_t CKMODE     : 1;            /*!< [4..4] Clock mode register                                                */
            uint32_t            : 3;
      __IOM uint32_t REFSEL     : 2;            /*!< [9..8] Select the ADC reference voltage.                                  */
            uint32_t            : 2;
      __IOM uint32_t DFIFORDEN  : 1;            /*!< [12..12] Destructive FIFO Read Enable. Setting this will enable
                                                     FIFO pop upon reading the FIFOPR register.                                */
            uint32_t            : 3;
      __IOM uint32_t TRIGSEL    : 3;            /*!< [18..16] Select the ADC trigger source.                                   */
      __IOM uint32_t TRIGPOL    : 1;            /*!< [19..19] This bit selects the ADC trigger polarity for external
                                                     off chip triggers.                                                        */
            uint32_t            : 4;
      __IOM uint32_t CLKSEL     : 2;            /*!< [25..24] Select the source and frequency for the ADC clock.
                                                     All values not enumerated below are undefined.                            */
            uint32_t            : 6;
    } CFG_b;
  } ;

  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) This register indicates the basic power status
                                                                    for the ADC. For detailed power status,
                                                                    see the power control power status register.
                                                                    ADC power mode 0 indicates the ADC is in
                                                                    it's full power state and is ready to process
                                                                    scans. ADC Power mode 1 indicates the ADC
                                                                    enabled and in a low power state.                          */

    struct {
      __IOM uint32_t PWDSTAT    : 1;            /*!< [0..0] Indicates the power-status of the ADC.                             */
            uint32_t            : 31;
    } STAT_b;
  } ;

  union {
    __IOM uint32_t SWT;                         /*!< (@ 0x00000008) This register enables initiating an ADC scan
                                                                    through software.                                          */

    struct {
      __IOM uint32_t SWT        : 8;            /*!< [7..0] Writing 0x37 to this register generates a software trigger.        */
            uint32_t            : 24;
    } SWT_b;
  } ;

  union {
    __IOM uint32_t SL0CFG;                      /*!< (@ 0x0000000C) Slot 0 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN0      : 1;            /*!< [0..0] This bit enables slot 0 for ADC conversions.                       */
      __IOM uint32_t WCEN0      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     0.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL0     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE0    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
            uint32_t            : 6;
      __IOM uint32_t ADSEL0     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL0CFG_b;
  } ;

  union {
    __IOM uint32_t SL1CFG;                      /*!< (@ 0x00000010) Slot 1 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN1      : 1;            /*!< [0..0] This bit enables slot 1 for ADC conversions.                       */
      __IOM uint32_t WCEN1      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     1.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL1     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE1    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
            uint32_t            : 6;
      __IOM uint32_t ADSEL1     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL1CFG_b;
  } ;

  union {
    __IOM uint32_t SL2CFG;                      /*!< (@ 0x00000014) Slot 2 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN2      : 1;            /*!< [0..0] This bit enables slot 2 for ADC conversions.                       */
      __IOM uint32_t WCEN2      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     2.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL2     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE2    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
            uint32_t            : 6;
      __IOM uint32_t ADSEL2     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL2CFG_b;
  } ;

  union {
    __IOM uint32_t SL3CFG;                      /*!< (@ 0x00000018) Slot 3 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN3      : 1;            /*!< [0..0] This bit enables slot 3 for ADC conversions.                       */
      __IOM uint32_t WCEN3      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     3.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL3     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE3    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
            uint32_t            : 6;
      __IOM uint32_t ADSEL3     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL3CFG_b;
  } ;

  union {
    __IOM uint32_t SL4CFG;                      /*!< (@ 0x0000001C) Slot 4 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN4      : 1;            /*!< [0..0] This bit enables slot 4 for ADC conversions.                       */
      __IOM uint32_t WCEN4      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     4.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL4     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE4    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
            uint32_t            : 6;
      __IOM uint32_t ADSEL4     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL4CFG_b;
  } ;

  union {
    __IOM uint32_t SL5CFG;                      /*!< (@ 0x00000020) Slot 5 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN5      : 1;            /*!< [0..0] This bit enables slot 5 for ADC conversions.                       */
      __IOM uint32_t WCEN5      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     5.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL5     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE5    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
            uint32_t            : 6;
      __IOM uint32_t ADSEL5     : 3;            /*!< [26..24] Select number of measurements to average in the accumulate
                                                     divide module for this slot.                                              */
            uint32_t            : 5;
    } SL5CFG_b;
  } ;

  union {
    __IOM uint32_t SL6CFG;                      /*!< (@ 0x00000024) Slot 6 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN6      : 1;            /*!< [0..0] This bit enables slot 6 for ADC conversions.                       */
      __IOM uint32_t WCEN6      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     6.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL6     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE6    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
            uint32_t            : 6;
      __IOM uint32_t ADSEL6     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL6CFG_b;
  } ;

  union {
    __IOM uint32_t SL7CFG;                      /*!< (@ 0x00000028) Slot 7 Configuration Register                              */

    struct {
      __IOM uint32_t SLEN7      : 1;            /*!< [0..0] This bit enables slot 7 for ADC conversions.                       */
      __IOM uint32_t WCEN7      : 1;            /*!< [1..1] This bit enables the window compare function for slot
                                                     7.                                                                        */
            uint32_t            : 6;
      __IOM uint32_t CHSEL7     : 4;            /*!< [11..8] Select one of the 14 channel inputs for this slot.                */
            uint32_t            : 4;
      __IOM uint32_t PRMODE7    : 2;            /*!< [17..16] Set the Precision Mode For Slot.                                 */
            uint32_t            : 6;
      __IOM uint32_t ADSEL7     : 3;            /*!< [26..24] Select the number of measurements to average in the
                                                     accumulate divide module for this slot.                                   */
            uint32_t            : 5;
    } SL7CFG_b;
  } ;

  union {
    __IOM uint32_t WULIM;                       /*!< (@ 0x0000002C) Window Comparator Upper Limits Register                    */

    struct {
      __IOM uint32_t ULIM       : 20;           /*!< [19..0] Sets the upper limit for the window comparator.                   */
            uint32_t            : 12;
    } WULIM_b;
  } ;

  union {
    __IOM uint32_t WLLIM;                       /*!< (@ 0x00000030) Window Comparator Lower Limits Register                    */

    struct {
      __IOM uint32_t LLIM       : 20;           /*!< [19..0] Sets the lower limit for the window comparator.                   */
            uint32_t            : 12;
    } WLLIM_b;
  } ;

  union {
    __IOM uint32_t SCWLIM;                      /*!< (@ 0x00000034) Scale Window Comparator Limits                             */

    struct {
      __IOM uint32_t SCWLIMEN   : 1;            /*!< [0..0] Scale the window limits compare values per precision
                                                     mode. When set to 0x0 (default), the values in the 20-bit
                                                     limits registers will compare directly with the FIFO values
                                                     regardless of the precision mode the slot is configured
                                                     to. When set to 0x1, the compare values will be divided
                                                     by the difference in precision bits while performing the
                                                     window limit comparisons.                                                 */
            uint32_t            : 31;
    } SCWLIM_b;
  } ;

  union {
    __IOM uint32_t FIFO;                        /*!< (@ 0x00000038) The ADC FIFO Register contains the slot number
                                                                    and FIFO data for the oldest conversion
                                                                    data in the FIFO. The COUNT field indicates
                                                                    the total number of valid entries in the
                                                                    FIFO. A write to this register will pop
                                                                    one of the FIFO entries off the FIFO and
                                                                    decrease the COUNT by 1 if the COUNT is
                                                                    greater than zero.                                         */

    struct {
      __IOM uint32_t DATA       : 20;           /*!< [19..0] Oldest data in the FIFO.                                          */
      __IOM uint32_t COUNT      : 8;            /*!< [27..20] Number of valid entries in the ADC FIFO.                         */
      __IOM uint32_t SLOTNUM    : 3;            /*!< [30..28] Slot number associated with this FIFO data.                      */
      __IOM uint32_t RSVD       : 1;            /*!< [31..31] RESERVED.                                                        */
    } FIFO_b;
  } ;

  union {
    __IOM uint32_t FIFOPR;                      /*!< (@ 0x0000003C) This is a Pop Read mirrored copy of the ADCFIFO
                                                                    register with the only difference being
                                                                    that reading this register will result in
                                                                    a simultaneous FIFO POP which is also achieved
                                                                    by writing to the ADCFIFO Register. Note:
                                                                    The DFIFORDEN bit must be set in the CFG
                                                                    register for the the destructive read to
                                                                    be enabled.                                                */

    struct {
      __IOM uint32_t DATA       : 20;           /*!< [19..0] Oldest data in the FIFO.                                          */
      __IOM uint32_t COUNT      : 8;            /*!< [27..20] Number of valid entries in the ADC FIFO.                         */
      __IOM uint32_t SLOTNUMPR  : 3;            /*!< [30..28] Slot number associated with this FIFO data.                      */
      __IOM uint32_t RSVDPR     : 1;            /*!< [31..31] RESERVED.                                                        */
    } FIFOPR_b;
  } ;
  __IM  uint32_t  RESERVED[112];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Transfer Complete                                              */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Condition                                                */
            uint32_t            : 24;
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Transfer Complete                                              */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Condition                                                */
            uint32_t            : 24;
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Transfer Complete                                              */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Condition                                                */
            uint32_t            : 24;
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< [0..0] ADC conversion complete interrupt.                                 */
      __IOM uint32_t SCNCMP     : 1;            /*!< [1..1] ADC scan complete interrupt.                                       */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< [2..2] FIFO 75 percent full interrupt.                                    */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< [3..3] FIFO 100 percent full interrupt.                                   */
      __IOM uint32_t WCEXC      : 1;            /*!< [4..4] Window comparator voltage excursion interrupt.                     */
      __IOM uint32_t WCINC      : 1;            /*!< [5..5] Window comparator voltage incursion interrupt.                     */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Transfer Complete                                              */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Condition                                                */
            uint32_t            : 24;
    } INTSET_b;
  } ;
  __IM  uint32_t  RESERVED1[12];

  union {
    __IOM uint32_t DMATRIGEN;                   /*!< (@ 0x00000240) DMA Trigger Enable Register                                */

    struct {
      __IOM uint32_t DFIFO75    : 1;            /*!< [0..0] Trigger DMA upon FIFO 75 percent Full                              */
      __IOM uint32_t DFIFOFULL  : 1;            /*!< [1..1] Trigger DMA upon FIFO 100 percent Full                             */
            uint32_t            : 30;
    } DMATRIGEN_b;
  } ;

  union {
    __IOM uint32_t DMATRIGSTAT;                 /*!< (@ 0x00000244) DMA Trigger Status Register                                */

    struct {
      __IOM uint32_t D75STAT    : 1;            /*!< [0..0] Triggered DMA from FIFO 75 percent Full                            */
      __IOM uint32_t DFULLSTAT  : 1;            /*!< [1..1] Triggered DMA from FIFO 100 percent Full                           */
            uint32_t            : 30;
    } DMATRIGSTAT_b;
  } ;
  __IM  uint32_t  RESERVED2[14];

  union {
    __IOM uint32_t DMACFG;                      /*!< (@ 0x00000280) DMA Configuration Register                                 */

    struct {
      __IOM uint32_t DMAEN      : 1;            /*!< [0..0] DMA Enable                                                         */
            uint32_t            : 1;
      __IOM uint32_t DMADIR     : 1;            /*!< [2..2] Direction                                                          */
            uint32_t            : 5;
      __IOM uint32_t DMAPRI     : 1;            /*!< [8..8] Sets the Priority of the DMA request                               */
      __IOM uint32_t DMADYNPRI  : 1;            /*!< [9..9] Enables dynamic priority based on FIFO fullness. When
                                                     FIFO is full, priority is automatically set to HIGH. Otherwise,
                                                     DMAPRI is used.                                                           */
            uint32_t            : 6;
      __IOM uint32_t DMAHONSTAT : 1;            /*!< [16..16] Halt New ADC conversions until DMA Status DMAERR and
                                                     DMACPL Cleared.                                                           */
      __IOM uint32_t DMAMSK     : 1;            /*!< [17..17] Mask the FIFOCNT and SLOTNUM when transferring FIFO
                                                     contents to memory                                                        */
      __IOM uint32_t DPWROFF    : 1;            /*!< [18..18] Power Off the ADC System upon DMACPL.                            */
            uint32_t            : 13;
    } DMACFG_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t DMATOTCOUNT;                 /*!< (@ 0x00000288) DMA Total Transfer Count                                   */

    struct {
            uint32_t            : 2;
      __IOM uint32_t TOTCOUNT   : 16;           /*!< [17..2] Total Transfer Count                                              */
            uint32_t            : 14;
    } DMATOTCOUNT_b;
  } ;

  union {
    __IOM uint32_t DMATARGADDR;                 /*!< (@ 0x0000028C) DMA Target Address Register                                */

    struct {
      __IOM uint32_t LTARGADDR  : 19;           /*!< [18..0] DMA Target Address                                                */
      __IOM uint32_t UTARGADDR  : 13;           /*!< [31..19] SRAM Target                                                      */
    } DMATARGADDR_b;
  } ;

  union {
    __IOM uint32_t DMASTAT;                     /*!< (@ 0x00000290) DMA Status Register                                        */

    struct {
      __IOM uint32_t DMATIP     : 1;            /*!< [0..0] DMA Transfer In Progress                                           */
      __IOM uint32_t DMACPL     : 1;            /*!< [1..1] DMA Transfer Complete                                              */
      __IOM uint32_t DMAERR     : 1;            /*!< [2..2] DMA Error                                                          */
            uint32_t            : 29;
    } DMASTAT_b;
  } ;
} ADC_Type;                                     /*!< Size = 660 (0x294)                                                        */



/* =========================================================================================================================== */
/* ================                                          APBDMA                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief APB DMA Register Interfaces (APBDMA)
  */

typedef struct {                                /*!< (@ 0x40011000) APBDMA Structure                                           */

  union {
    __IOM uint32_t BBVALUE;                     /*!< (@ 0x00000000) Control Register                                           */

    struct {
      __IOM uint32_t DATAOUT    : 8;            /*!< [7..0] Data Output Values                                                 */
            uint32_t            : 8;
      __IOM uint32_t PIN        : 8;            /*!< [23..16] PIO values                                                       */
            uint32_t            : 8;
    } BBVALUE_b;
  } ;

  union {
    __IOM uint32_t BBSETCLEAR;                  /*!< (@ 0x00000004) Set/Clear Register                                         */

    struct {
      __IOM uint32_t SET        : 8;            /*!< [7..0] Write 1 to set PIO value (set higher priority then clear
                                                     if both bits are set)                                                     */
            uint32_t            : 8;
      __IOM uint32_t CLEAR      : 8;            /*!< [23..16] Write 1 to clear PIO value                                       */
            uint32_t            : 8;
    } BBSETCLEAR_b;
  } ;

  union {
    __IOM uint32_t BBINPUT;                     /*!< (@ 0x00000008) PIO Input Values                                           */

    struct {
      __IOM uint32_t DATAIN     : 8;            /*!< [7..0] PIO values                                                         */
            uint32_t            : 24;
    } BBINPUT_b;
  } ;
  __IM  uint32_t  RESERVED[5];

  union {
    __IOM uint32_t DEBUGDATA;                   /*!< (@ 0x00000020) PIO Input Values                                           */

    struct {
      __IOM uint32_t DEBUGDATA  : 32;           /*!< [31..0] Debug Data                                                        */
    } DEBUGDATA_b;
  } ;
  __IM  uint32_t  RESERVED1[7];

  union {
    __IOM uint32_t DEBUG_a;                     /*!< (@ 0x00000040) PIO Input Values                                           */

    struct {
      __IOM uint32_t DEBUGEN    : 4;            /*!< [3..0] Debug Enable                                                       */
            uint32_t            : 28;
    } DEBUG_b;
  } ;
} APBDMA_Type;                                  /*!< Size = 68 (0x44)                                                          */



/* =========================================================================================================================== */
/* ================                                           BLEIF                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief BLE Interface (BLEIF)
  */

typedef struct {                                /*!< (@ 0x5000C000) BLEIF Structure                                            */

  union {
    __IOM uint32_t FIFO;                        /*!< (@ 0x00000000) Provides direct random access to both input and
                                                                    output FIFOs. The state of the FIFO is not
                                                                    disturbed by reading these locations (i.e.,
                                                                    no POP will occur). FIFO0 is accessible
                                                                    from addresses 0x0 - 0x1C, and is used for
                                                                    data output from the IOM to external devices.
                                                                    These FIFO locations can be read and written
                                                                    directly.FIFO locations 0x20 - 0x3C provide
                                                                    read only access to the input FIFO. These
                                                                    FIFO locations cannot be directly written
                                                                    by the MCU, and are updated only by the
                                                                    internal hardware                                          */

    struct {
      __IOM uint32_t FIFO       : 32;           /*!< [31..0] FIFO direct access. Only locations 0 - 3F will return
                                                     valid information.                                                        */
    } FIFO_b;
  } ;
  __IM  uint32_t  RESERVED[63];

  union {
    __IOM uint32_t FIFOPTR;                     /*!< (@ 0x00000100) Provides the current valid byte count of data
                                                                    within the FIFO as seen from the internal
                                                                    state machines. FIFO0 is dedicated to outgoing
                                                                    transactions and FIFO1 is dedicated to incoming
                                                                    transactions. All counts are specified in
                                                                    units of bytes.                                            */

    struct {
      __IOM uint32_t FIFO0SIZ   : 8;            /*!< [7..0] The number of valid data bytes currently in the FIFO
                                                     0 (written by MCU, read by interface)                                     */
      __IOM uint32_t FIFO0REM   : 8;            /*!< [15..8] The number of remaining data bytes slots currently in
                                                     FIFO 0 (written by MCU, read by interface)                                */
      __IOM uint32_t FIFO1SIZ   : 8;            /*!< [23..16] The number of valid data bytes currently in FIFO 1
                                                     (written by interface, read by MCU)                                       */
      __IOM uint32_t FIFO1REM   : 8;            /*!< [31..24] The number of remaining data bytes slots currently
                                                     in FIFO 1 (written by interface, read by MCU)                             */
    } FIFOPTR_b;
  } ;

  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000104) Sets the threshold values for incoming and outgoing
                                                                    transactions. The threshold values are used
                                                                    to assert the interrupt if enabled, and
                                                                    also used during DMA to set the transfer
                                                                    size as a result of DMATHR trigger.The WTHR
                                                                    is used to indicate when there are more
                                                                    than WTHR bytes of open FIFO locations available
                                                                    in the outgoing FIFO (FIFO0). The intended
                                                                    use to invoke an interrupt or DMA transfer
                                                                    that will refill the FIFO with a byte count
                                                                    up to this value.The RTHR is used to indicate
                                                                    when t                                                     */

    struct {
      __IOM uint32_t FIFORTHR   : 6;            /*!< [5..0] FIFO read threshold in bytes. A value of 0 will disable
                                                     the read FIFO level from activating the threshold interrupt.
                                                     If this field is non-zero, it will trigger a threshold
                                                     interrupt when the read FIFO contains FIFORTHR valid bytes
                                                     of data, as indicated by the FIFO1SIZ field. This is intended
                                                     to signal when a data transfer of FIFORTHR bytes can be
                                                     done from the IOM module to the host via the read FIFO
                                                     to support large IOM read operations.                                     */
            uint32_t            : 2;
      __IOM uint32_t FIFOWTHR   : 6;            /*!< [13..8] FIFO write threshold in bytes. A value of 0 will disable
                                                     the write FIFO level from activating the threshold interrupt.
                                                     If this field is non-zero, it will trigger a threshold
                                                     interrupt when the write FIFO contains FIFOWTHR free bytes,
                                                     as indicated by the FIFO0REM field. This is intended to
                                                     signal when a transfer of FIFOWTHR bytes can be done from
                                                     the host to the IOM write FIFO to support large IOM write
                                                     operations.                                                               */
            uint32_t            : 18;
    } FIFOTHR_b;
  } ;

  union {
    __IOM uint32_t FIFOPOP;                     /*!< (@ 0x00000108) Will advance the internal read pointer of the
                                                                    incoming FIFO (FIFO1) when read, if POPWR
                                                                    is not active. If POPWR is active, a write
                                                                    to this register is needed to advance the
                                                                    internal FIFO pointer.                                     */

    struct {
      __IOM uint32_t FIFODOUT   : 32;           /*!< [31..0] This register will return the read data indicated by
                                                     the current read pointer on reads. If the POPWR control
                                                     bit in the FIFOCTRL register is reset (0), the FIFO read
                                                     pointer will be advanced by one word as a result of the
                                                     read.If the POPWR bit is set (1), the FIFO read pointer
                                                     will only be advanced after a write operation to this register.
                                                     The write data is ignored for this register.If less than
                                                     a even word multiple is available, and the command is completed,
                                                     the module will return the word containing                                */
    } FIFOPOP_b;
  } ;

  union {
    __IOM uint32_t FIFOPUSH;                    /*!< (@ 0x0000010C) Will write new data into the outgoing FIFO and
                                                                    advance the internal write pointer.                        */

    struct {
      __IOM uint32_t FIFODIN    : 32;           /*!< [31..0] This register is used to write the FIFORAM in FIFO mode
                                                     and will cause a push event to occur to the next open slot
                                                     within the FIFORAM. Writing to this register will cause
                                                     the write point to increment by 1 word(4 bytes).                          */
    } FIFOPUSH_b;
  } ;

  union {
    __IOM uint32_t FIFOCTRL;                    /*!< (@ 0x00000110) Provides controls for the operation of the internal
                                                                    FIFOs. Contains fields used to control the
                                                                    operation of the POP register, and also
                                                                    controls to reset the internal pointers
                                                                    of the FIFOs.                                              */

    struct {
      __IOM uint32_t POPWR      : 1;            /*!< [0..0] Selects the mode in which 'pop' events are done for the
                                                     FIFO read operations. A value of '1' will prevent a pop
                                                     event on a read operation, and will require a write to
                                                     the FIFOPOP register to create a pop event.A value of '0'
                                                     in this register will allow a pop event to occur on the
                                                     read of the FIFOPOP register, and may cause inadvertent
                                                     FIFO pops when used in a debugging mode.                                  */
      __IOM uint32_t FIFORSTN   : 1;            /*!< [1..1] Active low manual reset of the FIFO. Write to 0 to reset
                                                     FIFO, and then write to 1 to remove the reset.                            */
            uint32_t            : 30;
    } FIFOCTRL_b;
  } ;

  union {
    __IOM uint32_t FIFOLOC;                     /*!< (@ 0x00000114) Provides a read only value of the current read
                                                                    and write pointers. This register is read
                                                                    only and can be used along with the FIFO
                                                                    direct access method to determine the next
                                                                    data to be used for input and output functions.            */

    struct {
      __IOM uint32_t FIFOWPTR   : 4;            /*!< [3..0] Current FIFO write pointer. Value is the index into the
                                                     outgoing FIFO (FIFO0), which is used during write operations
                                                     to external devices.                                                      */
            uint32_t            : 4;
      __IOM uint32_t FIFORPTR   : 4;            /*!< [11..8] Current FIFO read pointer. Used to index into the incoming
                                                     FIFO (FIFO1), which is used to store read data returned
                                                     from external devices during a read operation.                            */
            uint32_t            : 20;
    } FIFOLOC_b;
  } ;
  __IM  uint32_t  RESERVED1[58];

  union {
    __IOM uint32_t CLKCFG;                      /*!< (@ 0x00000200) Provides clock related controls used internal
                                                                    to the BLEIF module, and enablement of 32KHz
                                                                    clock to the BLE Core module. The internal
                                                                    clock sourced is selected via the FSEL and
                                                                    can be further divided by 3 using the DIV3
                                                                    control.This register is also used to enable
                                                                    the clock, which must be done prior to performing
                                                                    any IO transactions.                                       */

    struct {
      __IOM uint32_t IOCLKEN    : 1;            /*!< [0..0] Enable for the interface clock. Must be enabled prior
                                                     to executing any IO operations.                                           */
            uint32_t            : 7;
      __IOM uint32_t FSEL       : 3;            /*!< [10..8] Select the input clock frequency.                                 */
      __IOM uint32_t CLK32KEN   : 1;            /*!< [11..11] Enable for the 32Khz clock to the BLE module                     */
      __IOM uint32_t DIV3       : 1;            /*!< [12..12] Enable of the divide by 3 of the source IOCLK.                   */
            uint32_t            : 19;
    } CLKCFG_b;
  } ;
  __IM  uint32_t  RESERVED2[2];

  union {
    __IOM uint32_t CMD;                         /*!< (@ 0x0000020C) Writes to this register will start an IO transaction,
                                                                    as well as set various parameters for the
                                                                    command itself. Reads will return the command
                                                                    value written to the CMD register.To read
                                                                    the number of bytes that have yet to be
                                                                    transferred, refer to the CTSIZE field within
                                                                    the CMDSTAT register.                                      */

    struct {
      __IOM uint32_t CMD        : 5;            /*!< [4..0] Command for submodule.                                             */
      __IOM uint32_t OFFSETCNT  : 2;            /*!< [6..5] Number of offset bytes to use for the command - 0, 1,
                                                     2, 3 are valid selections. The second (byte 1) and third
                                                     byte (byte 2) are read from the OFFSETHI register, and
                                                     the low order byte is pulled from this register in the
                                                     OFFSETLO field.Offset bytes are transmitted highest byte
                                                     first. E.g., if OFFSETCNT == 3, OFFSETHI[15:8] will be
                                                     transmitted first, then OFFSETHI[7:0] then OFFSETLO.If
                                                     OFFSETCNT == 2, OFFSETHI[7:0] will be transmitted, then
                                                     OFFSETLO.If OFFSETCNT == 1, only OFFSETLO will be transmitted             */
      __IOM uint32_t CONT       : 1;            /*!< [7..7] Continue to hold the bus after the current transaction
                                                     if set to a 1 with a new command issued.                                  */
      __IOM uint32_t TSIZE      : 12;           /*!< [19..8] Defines the transaction size in bytes. The offset transfer
                                                     is not included in this size.                                             */
      __IOM uint32_t CMDSEL     : 2;            /*!< [21..20] Command Specific selection information                           */
            uint32_t            : 2;
      __IOM uint32_t OFFSETLO   : 8;            /*!< [31..24] This register holds the low order byte of offset to
                                                     be used in the transaction. The number of offset bytes
                                                     to use is set with bits 1:0 of the command. Offset bytes
                                                     are transferred starting from the highest byte first.                     */
    } CMD_b;
  } ;

  union {
    __IOM uint32_t CMDRPT;                      /*!< (@ 0x00000210) Will repeat the next command for CMDRPT number
                                                                    of times. If CMDRPT is set to 1, the next
                                                                    command will be done 2 times in series.
                                                                    A repeat count of up to 31 is possible.
                                                                    Each command will be done as a separate
                                                                    command, but the data willbe treated as
                                                                    packed, and aligned to byte boundaries.
                                                                    This differs when executing separate commands
                                                                    without the CMDRPT set, as the data for
                                                                    each transaction is word aligned and any
                                                                    unused byte locations will be filled with
                                                                    0 for read operations, ordiscarded                         */

    struct {
      __IOM uint32_t CMDRPT     : 5;            /*!< [4..0] Count of number of times to repeat the next command.               */
            uint32_t            : 27;
    } CMDRPT_b;
  } ;

  union {
    __IOM uint32_t OFFSETHI;                    /*!< (@ 0x00000214) Provides the high order bytes of 2 or 3 byte
                                                                    offset transactions of the current command.
                                                                    Usage of these bytes is dependent on the
                                                                    OFFSETCNT field in the CMD register. If
                                                                    the OFFSETCNT == 3, the data located at
                                                                    OFFSETHI[15:0] will first be transmitted,followed
                                                                    by OFFSETHI[7:0], followed by OFFSETLO (in
                                                                    the CMD register) prior to sending or receiving
                                                                    any transaction data (if programed via TSIZE
                                                                    field in the CMD register).The offset bytes
                                                                    are always transmitted MSB first for all
                                                                    modules.                                                   */

    struct {
      __IOM uint32_t OFFSETHI   : 16;           /*!< [15..0] Holds the high order bytes of the 2 or 3 byte offset
                                                     phase of a transaction.                                                   */
            uint32_t            : 16;
    } OFFSETHI_b;
  } ;

  union {
    __IOM uint32_t CMDSTAT;                     /*!< (@ 0x00000218) Provides status on the execution of the command
                                                                    currently in progress. The fields in this
                                                                    register will reflect the real time status
                                                                    of the internal state machines and data
                                                                    transfers within the IOM.These are read
                                                                    only fields and writes to the registers
                                                                    are ignored.                                               */

    struct {
      __IOM uint32_t CCMD       : 5;            /*!< [4..0] current command that is being executed                             */
      __IOM uint32_t CMDSTAT    : 3;            /*!< [7..5] The current status of the command execution.                       */
      __IOM uint32_t CTSIZE     : 12;           /*!< [19..8] The current number of bytes still to be transferred
                                                     with this command. This field will count down to zero.                    */
            uint32_t            : 12;
    } CMDSTAT_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000220) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command Complete interrupt. Asserted when the current
                                                     operation has completed. For repeated commands, this will
                                                     only be asserted when the final repeated command is completed.            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. Asserted when a pop operation
                                                     is done to a empty read FIFO.                                             */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full FIFO. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t B2MST      : 1;            /*!< [4..4] B2M State change interrupt. Asserted on any change in
                                                     the B2M_STATE signal from the BLE Core.                                   */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t BLECIRQ    : 1;            /*!< [7..7] BLE Core IRQ signal. Asserted when the BLE_IRQ signal
                                                     from the BLE Core is asserted, indicating the availability
                                                     of read data from the BLE Core.                                           */
      __IOM uint32_t BLECSSTAT  : 1;            /*!< [8..8] BLE Core SPI Status interrupt. Asserted when the SPI_STATUS
                                                     signal from the BLE Core is asserted, indicating that SPI
                                                     writes can be done to the BLE Core.Transfers to the BLE
                                                     Core should only be done when this signal is high.                        */
      __IOM uint32_t DCMP       : 1;            /*!< [9..9] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [10..10] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [11..11] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [12..12] Command queue write operation executed a register write
                                                     with the register address bit 0 set to 1. The low address
                                                     bits in the CQ address fields are unused and bit 0 can
                                                     be used to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [13..13] Command queue error during processing. When an error
                                                     occurs, the system will stop processing and halt operations
                                                     to allow software to take recovery actions                                */
      __IOM uint32_t B2MSLEEP   : 1;            /*!< [14..14] The B2M_STATE from the BLE Core transitioned into the
                                                     sleep state                                                               */
      __IOM uint32_t B2MACTIVE  : 1;            /*!< [15..15] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into the active state Revision B: Falling BLE Core IRQ
                                                     signal. Asserted when the BLE_IRQ signal from the BLE Core
                                                     is deasserted (1 -> 0)                                                    */
      __IOM uint32_t B2MSHUTDN  : 1;            /*!< [16..16] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into shutdown state Revision B: Falling BLE Core Status
                                                     signal. Asserted when the BLE_STATUS signal from the BLE
                                                     Core is deasserted (1 -> 0)                                               */
            uint32_t            : 15;
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000224) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command Complete interrupt. Asserted when the current
                                                     operation has completed. For repeated commands, this will
                                                     only be asserted when the final repeated command is completed.            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. Asserted when a pop operation
                                                     is done to a empty read FIFO.                                             */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full FIFO. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t B2MST      : 1;            /*!< [4..4] B2M State change interrupt. Asserted on any change in
                                                     the B2M_STATE signal from the BLE Core.                                   */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t BLECIRQ    : 1;            /*!< [7..7] BLE Core IRQ signal. Asserted when the BLE_IRQ signal
                                                     from the BLE Core is asserted, indicating the availability
                                                     of read data from the BLE Core.                                           */
      __IOM uint32_t BLECSSTAT  : 1;            /*!< [8..8] BLE Core SPI Status interrupt. Asserted when the SPI_STATUS
                                                     signal from the BLE Core is asserted, indicating that SPI
                                                     writes can be done to the BLE Core.Transfers to the BLE
                                                     Core should only be done when this signal is high.                        */
      __IOM uint32_t DCMP       : 1;            /*!< [9..9] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [10..10] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [11..11] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [12..12] Command queue write operation executed a register write
                                                     with the register address bit 0 set to 1. The low address
                                                     bits in the CQ address fields are unused and bit 0 can
                                                     be used to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [13..13] Command queue error during processing. When an error
                                                     occurs, the system will stop processing and halt operations
                                                     to allow software to take recovery actions                                */
      __IOM uint32_t B2MSLEEP   : 1;            /*!< [14..14] The B2M_STATE from the BLE Core transitioned into the
                                                     sleep state                                                               */
      __IOM uint32_t B2MACTIVE  : 1;            /*!< [15..15] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into the active state Revision B: Falling BLE Core IRQ
                                                     signal. Asserted when the BLE_IRQ signal from the BLE Core
                                                     is deasserted (1 -> 0)                                                    */
      __IOM uint32_t B2MSHUTDN  : 1;            /*!< [16..16] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into shutdown state Revision B: Falling BLE Core Status
                                                     signal. Asserted when the BLE_STATUS signal from the BLE
                                                     Core is deasserted (1 -> 0)                                               */
            uint32_t            : 15;
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000228) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command Complete interrupt. Asserted when the current
                                                     operation has completed. For repeated commands, this will
                                                     only be asserted when the final repeated command is completed.            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. Asserted when a pop operation
                                                     is done to a empty read FIFO.                                             */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full FIFO. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t B2MST      : 1;            /*!< [4..4] B2M State change interrupt. Asserted on any change in
                                                     the B2M_STATE signal from the BLE Core.                                   */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t BLECIRQ    : 1;            /*!< [7..7] BLE Core IRQ signal. Asserted when the BLE_IRQ signal
                                                     from the BLE Core is asserted, indicating the availability
                                                     of read data from the BLE Core.                                           */
      __IOM uint32_t BLECSSTAT  : 1;            /*!< [8..8] BLE Core SPI Status interrupt. Asserted when the SPI_STATUS
                                                     signal from the BLE Core is asserted, indicating that SPI
                                                     writes can be done to the BLE Core.Transfers to the BLE
                                                     Core should only be done when this signal is high.                        */
      __IOM uint32_t DCMP       : 1;            /*!< [9..9] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [10..10] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [11..11] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [12..12] Command queue write operation executed a register write
                                                     with the register address bit 0 set to 1. The low address
                                                     bits in the CQ address fields are unused and bit 0 can
                                                     be used to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [13..13] Command queue error during processing. When an error
                                                     occurs, the system will stop processing and halt operations
                                                     to allow software to take recovery actions                                */
      __IOM uint32_t B2MSLEEP   : 1;            /*!< [14..14] The B2M_STATE from the BLE Core transitioned into the
                                                     sleep state                                                               */
      __IOM uint32_t B2MACTIVE  : 1;            /*!< [15..15] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into the active state Revision B: Falling BLE Core IRQ
                                                     signal. Asserted when the BLE_IRQ signal from the BLE Core
                                                     is deasserted (1 -> 0)                                                    */
      __IOM uint32_t B2MSHUTDN  : 1;            /*!< [16..16] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into shutdown state Revision B: Falling BLE Core Status
                                                     signal. Asserted when the BLE_STATUS signal from the BLE
                                                     Core is deasserted (1 -> 0)                                               */
            uint32_t            : 15;
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000022C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command Complete interrupt. Asserted when the current
                                                     operation has completed. For repeated commands, this will
                                                     only be asserted when the final repeated command is completed.            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. Asserted when a pop operation
                                                     is done to a empty read FIFO.                                             */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full FIFO. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t B2MST      : 1;            /*!< [4..4] B2M State change interrupt. Asserted on any change in
                                                     the B2M_STATE signal from the BLE Core.                                   */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t BLECIRQ    : 1;            /*!< [7..7] BLE Core IRQ signal. Asserted when the BLE_IRQ signal
                                                     from the BLE Core is asserted, indicating the availability
                                                     of read data from the BLE Core.                                           */
      __IOM uint32_t BLECSSTAT  : 1;            /*!< [8..8] BLE Core SPI Status interrupt. Asserted when the SPI_STATUS
                                                     signal from the BLE Core is asserted, indicating that SPI
                                                     writes can be done to the BLE Core.Transfers to the BLE
                                                     Core should only be done when this signal is high.                        */
      __IOM uint32_t DCMP       : 1;            /*!< [9..9] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [10..10] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [11..11] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [12..12] Command queue write operation executed a register write
                                                     with the register address bit 0 set to 1. The low address
                                                     bits in the CQ address fields are unused and bit 0 can
                                                     be used to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [13..13] Command queue error during processing. When an error
                                                     occurs, the system will stop processing and halt operations
                                                     to allow software to take recovery actions                                */
      __IOM uint32_t B2MSLEEP   : 1;            /*!< [14..14] The B2M_STATE from the BLE Core transitioned into the
                                                     sleep state                                                               */
      __IOM uint32_t B2MACTIVE  : 1;            /*!< [15..15] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into the active state Revision B: Falling BLE Core IRQ
                                                     signal. Asserted when the BLE_IRQ signal from the BLE Core
                                                     is deasserted (1 -> 0)                                                    */
      __IOM uint32_t B2MSHUTDN  : 1;            /*!< [16..16] Revision A: The B2M_STATE from the BLE Core transitioned
                                                     into shutdown state Revision B: Falling BLE Core Status
                                                     signal. Asserted when the BLE_STATUS signal from the BLE
                                                     Core is deasserted (1 -> 0)                                               */
            uint32_t            : 15;
    } INTSET_b;
  } ;

  union {
    __IOM uint32_t DMATRIGEN;                   /*!< (@ 0x00000230) Provides control on which event will trigger
                                                                    the DMA transfer after the DMA operation
                                                                    is setup and enabled. The trigger event
                                                                    will cause a number of bytes (depending
                                                                    on trigger event) to betransferred via the
                                                                    DMA operation, and can be used to adjust
                                                                    the latency of data to/from the IOM module
                                                                    to/from the DMA target. DMA transfers are
                                                                    broken into smaller transfers internally
                                                                    of up to16 bytes each, and multiple trigger
                                                                    events can be used to complete the entire
                                                                    programmed DMA transfer.                                   */

    struct {
      __IOM uint32_t DCMDCMPEN  : 1;            /*!< [0..0] Trigger DMA upon command complete. Enables the trigger
                                                     of the DMA when a command is completed. When this event
                                                     is triggered, the number of words transferred will be the
                                                     lesser of the remaining TOTCOUNT bytes, or the number of
                                                     bytes in the FIFO when the command completed. If this is
                                                     disabled, and the number of bytes in the FIFO is equal
                                                     or greater than the TOTCOUNT bytes, a transfer of TOTCOUNT
                                                     bytes will be done to ensure read data is stored when the
                                                     DMA is completed.                                                         */
      __IOM uint32_t DTHREN     : 1;            /*!< [1..1] Trigger DMA upon THR level reached. For M2P DMA operations
                                                     (IOM writes), the trigger will assert when the write FIFO
                                                     has (WTHR/4) number of words free in the write FIFO, and
                                                     will transfer (WTHR/4) number of wordsor, if the number
                                                     of words left to transfer is less than the WTHR value,
                                                     will transfer the remaining byte count.For P2M DMA operations,
                                                     the trigger will assert when the read FIFO has (RTHR/4)
                                                     words available in the read FIFO, and will transfer (RTHR/4)
                                                     words to SRAM. This trigger will NOT asser                                */
            uint32_t            : 30;
    } DMATRIGEN_b;
  } ;

  union {
    __IOM uint32_t DMATRIGSTAT;                 /*!< (@ 0x00000234) Provides the status of trigger events that have
                                                                    occurred for the transaction. Some of the
                                                                    bits are read only and some can be reset
                                                                    via a write of 0.                                          */

    struct {
      __IOM uint32_t DCMDCMP    : 1;            /*!< [0..0] Triggered DMA from Command complete event. Bit is read
                                                     only and can be cleared by disabling the DCMDCMP trigger
                                                     enable or by disabling DMA.                                               */
      __IOM uint32_t DTHR       : 1;            /*!< [1..1] Triggered DMA from THR event. Bit is read only and can
                                                     be cleared by disabling the DTHR trigger enable or by disabling
                                                     DMA.                                                                      */
      __IOM uint32_t DTOTCMP    : 1;            /*!< [2..2] DMA triggered when DCMDCMP = 0, and the amount of data
                                                     in the FIFO was enough to complete the DMA operation (greater
                                                     than or equal to current TOTCOUNT) when the command completed.
                                                     This trigger is default active when the DCMDCMP trigger
                                                     isdisabled and there is enough data in the FIFO to complete
                                                     the DMA operation.                                                        */
            uint32_t            : 29;
    } DMATRIGSTAT_b;
  } ;

  union {
    __IOM uint32_t DMACFG;                      /*!< (@ 0x00000238) Configuration control of the DMA process, including
                                                                    the direction of DMA, and enablement of
                                                                    DMA                                                        */

    struct {
      __IOM uint32_t DMAEN      : 1;            /*!< [0..0] DMA Enable. Setting this bit to EN will start the DMA
                                                     operation. This should be the last DMA related register
                                                     set prior to issuing the command                                          */
      __IOM uint32_t DMADIR     : 1;            /*!< [1..1] Direction                                                          */
            uint32_t            : 6;
      __IOM uint32_t DMAPRI     : 1;            /*!< [8..8] Sets the Priority of the DMA request                               */
      __IOM uint32_t DPWROFF    : 1;            /*!< [9..9] Power off module after DMA is complete. If this bit is
                                                     active, the module will request to power off the supply
                                                     it is attached to. If there are other units still requiring
                                                     power from the same domain, power down will not be performed.             */
            uint32_t            : 22;
    } DMACFG_b;
  } ;

  union {
    __IOM uint32_t DMATOTCOUNT;                 /*!< (@ 0x0000023C) Contains the number of bytes to be transferred
                                                                    for this DMA transaction. This register
                                                                    is decremented as the data is transferred,
                                                                    and will be 0 at the completion of the DMA
                                                                    operation.                                                 */

    struct {
      __IOM uint32_t TOTCOUNT   : 12;           /*!< [11..0] Triggered DMA from Command complete event occurred.
                                                     Bit is read only and can be cleared by disabling the DTHR
                                                     trigger enable or by disabling DMA.                                       */
            uint32_t            : 20;
    } DMATOTCOUNT_b;
  } ;

  union {
    __IOM uint32_t DMATARGADDR;                 /*!< (@ 0x00000240) The source or destination address internal the
                                                                    SRAM for the DMA data. For write operations,
                                                                    this can only be SRAM data (ADDR bit 28
                                                                    = 1); For read operations, this can be either
                                                                    SRAM or FLASH (ADDR bit 28 = 0)                            */

    struct {
      __IOM uint32_t TARGADDR   : 20;           /*!< [19..0] Bits [19:0] of the target byte address for source of
                                                     DMA (either read or write). The address can be any byte
                                                     alignment, and does not have to be word aligned. In cases
                                                     of non-word aligned addresses, the DMA logic will take
                                                     care for ensuring only the target bytes are read/written.                 */
            uint32_t            : 8;
      __IOM uint32_t TARGADDR28 : 1;            /*!< [28..28] Bit 28 of the target byte address for source of DMA
                                                     (either read or write). In cases of non-word aligned addresses,
                                                     the DMA logic will take care for ensuring only the target
                                                     bytes are read/written.Setting to '1' will select the SRAM.
                                                     Setting to '0' will select the flash                                      */
            uint32_t            : 3;
    } DMATARGADDR_b;
  } ;

  union {
    __IOM uint32_t DMASTAT;                     /*!< (@ 0x00000244) Status of the DMA operation currently in progress.         */

    struct {
      __IOM uint32_t DMATIP     : 1;            /*!< [0..0] DMA Transfer In Progress indicator. 1 will indicate that
                                                     a DMA transfer is active. The DMA transfer may be waiting
                                                     on data, transferring data, or waiting for priority.All
                                                     of these will be indicated with a 1. A 0 will indicate
                                                     that the DMA is fully complete and no further transactions
                                                     will be done. This bit is read only.                                      */
      __IOM uint32_t DMACPL     : 1;            /*!< [1..1] DMA Transfer Complete. This signals the end of the DMA
                                                     operation. This bit can be cleared by writing to 0.                       */
      __IOM uint32_t DMAERR     : 1;            /*!< [2..2] DMA Error. This active high bit signals that an error
                                                     was encountered during the DMA operation.                                 */
            uint32_t            : 29;
    } DMASTAT_b;
  } ;

  union {
    __IOM uint32_t CQCFG;                       /*!< (@ 0x00000248) Controls parameters and options for execution
                                                                    of the command queue operation. To enable
                                                                    command queue, create this in memory, set
                                                                    the address, and enable it with a write
                                                                    to CQEN                                                    */

    struct {
      __IOM uint32_t CQEN       : 1;            /*!< [0..0] Command queue enable. When set, will enable the processing
                                                     of the command queue and fetches of address/data pairs
                                                     will proceed from the word address within the CQADDR register.
                                                     Can be disabledusing a CQ executed write to this bit as
                                                     well.                                                                     */
      __IOM uint32_t CQPRI      : 1;            /*!< [1..1] Sets the Priority of the command queue DMA request.                */
            uint32_t            : 30;
    } CQCFG_b;
  } ;

  union {
    __IOM uint32_t CQADDR;                      /*!< (@ 0x0000024C) The SRAM address which will be fetched next execution
                                                                    of the CQ operation. This register is updated
                                                                    as the CQ operation progresses, and is the
                                                                    live version of the register. The register
                                                                    can also bewritten by the Command Queue
                                                                    operation itself, allowing the relocation
                                                                    of successive CQ fetches. In this case,
                                                                    the new CQ address will be used for the
                                                                    next CQ address/data fetch                                 */

    struct {
            uint32_t            : 2;
      __IOM uint32_t CQADDR     : 18;           /*!< [19..2] Bits 19:2 of target byte address for source of CQ (read
                                                     only). The buffer must be aligned on a word boundary                      */
            uint32_t            : 8;
      __IOM uint32_t CQADDR28   : 1;            /*!< [28..28] Bit 28 of target byte address for source of CQ (read
                                                     only). Used to denote Flash (0) or SRAM (1) access                        */
            uint32_t            : 3;
    } CQADDR_b;
  } ;

  union {
    __IOM uint32_t CQSTAT;                      /*!< (@ 0x00000250) Provides the status of the command queue operation.
                                                                    If the command queue is disabled, these
                                                                    bits will be cleared. The bits are read
                                                                    only                                                       */

    struct {
      __IOM uint32_t CQTIP      : 1;            /*!< [0..0] Command queue Transfer In Progress indicator. 1 will
                                                     indicate that a CQ transfer is active and this will remain
                                                     active even when paused waiting for external event.                       */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [1..1] Command queue operation is currently paused.                       */
      __IOM uint32_t CQERR      : 1;            /*!< [2..2] Command queue processing error. This active high bit
                                                     signals that an error was encountered during the CQ operation.            */
            uint32_t            : 29;
    } CQSTAT_b;
  } ;

  union {
    __IOM uint32_t CQFLAGS;                     /*!< (@ 0x00000254) Provides the current status of the SWFLAGS (bits
                                                                    7:0) and the hardware generated flags (15:8).
                                                                    A '1' will pause the CQ operation if it
                                                                    the same bit is enabled in the CQPAUSEEN
                                                                    register                                                   */

    struct {
      __IOM uint32_t CQFLAGS    : 16;           /*!< [15..0] Current flag status (read-only). Bits [7:0] are software
                                                     controllable and bits [15:8] are hardware status.                         */
      __IOM uint32_t CQIRQMASK  : 16;           /*!< [31..16] Provides for a per-bit mask of the flags used to invoke
                                                     an interrupt. A '1' in the bit position will enable the
                                                     pause event to trigger the interrupt, if the CQWT_int interrupt
                                                     is enabled.Bits definitions are the same as CQPAUSE                       */
    } CQFLAGS_b;
  } ;

  union {
    __IOM uint32_t CQSETCLEAR;                  /*!< (@ 0x00000258) Set/Clear the command queue software pause flags
                                                                    on a per-bit basis. Contains 3 fields, allowing
                                                                    for setting, clearing or toggling the value
                                                                    in the software flags. Priority when the
                                                                    same bitis enabled in each field is toggle,
                                                                    then set, then clear.                                      */

    struct {
      __IOM uint32_t CQFSET     : 8;            /*!< [7..0] Set CQFlag status bits. Will set to 1 the value of any
                                                     SWFLAG with a '1' in the corresponding bit position of
                                                     this field                                                                */
      __IOM uint32_t CQFTGL     : 8;            /*!< [15..8] Toggle the indicated bit. Will toggle the value of any
                                                     SWFLAG with a '1' in the corresponding bit position of
                                                     this field                                                                */
      __IOM uint32_t CQFCLR     : 8;            /*!< [23..16] Clear CQFlag status bits. Will clear to 0 any SWFLAG
                                                     with a '1' in the corresponding bit position of this field                */
            uint32_t            : 8;
    } CQSETCLEAR_b;
  } ;

  union {
    __IOM uint32_t CQPAUSEEN;                   /*!< (@ 0x0000025C) Enables a flag to pause an active command queue
                                                                    operation. If a bit is '1' and the corresponding
                                                                    bit in the CQFLAG register is '1', CQ processing
                                                                    will halt until either value is changed
                                                                    to '0'.                                                    */

    struct {
      __IOM uint32_t CQPEN      : 16;           /*!< [15..0] Enables the specified event to pause command processing
                                                     when active                                                               */
            uint32_t            : 16;
    } CQPAUSEEN_b;
  } ;

  union {
    __IOM uint32_t CQCURIDX;                    /*!< (@ 0x00000260) Current index value, targeted to be written by
                                                                    register write operations within the command
                                                                    queue. This is compared to the CQENDIDX
                                                                    and will stop the CQ operation if bit 15
                                                                    of the CQPAUSEEN is '1' andthis current
                                                                    index equals the CQENDIDX register value.
                                                                    This will only pause when the values are
                                                                    equal.                                                     */

    struct {
      __IOM uint32_t CQCURIDX   : 8;            /*!< [7..0] Holds 8 bits of data that will be compared with the CQENDIX
                                                     register field. If the values match, the IDXEQ pause event
                                                     will be activated, which will cause the pausing of command
                                                     queue operation if the IDXEQ bit is enabled in CQPAUSEEN.                 */
            uint32_t            : 24;
    } CQCURIDX_b;
  } ;

  union {
    __IOM uint32_t CQENDIDX;                    /*!< (@ 0x00000264) End index value, targeted to be written by software
                                                                    to indicate the last valid register pair
                                                                    contained within the command queue for register
                                                                    write operations within the command queue.This
                                                                    is compared to the CQCURIDX and will stop
                                                                    the CQ operation if bit 15 of the CQPAUSEEN
                                                                    is '1' andthis current index equals the
                                                                    CQCURIDX register value. This will only
                                                                    pause when the values are equal.                           */

    struct {
      __IOM uint32_t CQENDIDX   : 8;            /*!< [7..0] Holds 8 bits of data that will be compared with the CQCURIX
                                                     register field. If the values match, the IDXEQ pause event
                                                     will be activated, which will cause the pausing of command
                                                     queue operation if the IDXEQ bit is enabled in CQPAUSEEN.                 */
            uint32_t            : 24;
    } CQENDIDX_b;
  } ;

  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x00000268) General status of the IOM module command execution.        */

    struct {
      __IOM uint32_t ERR        : 1;            /*!< [0..0] Bit has been deprecated. Please refer to the other error
                                                     indicators. This will always return 0.                                    */
      __IOM uint32_t CMDACT     : 1;            /*!< [1..1] Indicates if the active I/O Command is currently processing
                                                     a transaction, or command is complete, but the FIFO pointers
                                                     are still synchronizing internally. This bit will go high
                                                     atthe start of the transaction, and will go low when the
                                                     command is complete, and the data and pointers within the
                                                     FIFO have been synchronized.                                              */
      __IOM uint32_t IDLEST     : 1;            /*!< [2..2] indicates if the active I/O state machine is IDLE. Note
                                                     - The state machine could be in idle state due to hold-offs
                                                     from data availability, or as the command gets propagated
                                                     into the logic from the registers.                                        */
            uint32_t            : 29;
    } STATUS_b;
  } ;
  __IM  uint32_t  RESERVED4[37];

  union {
    __IOM uint32_t MSPICFG;                     /*!< (@ 0x00000300) Controls the configuration of the SPI master
                                                                    module, including POL/PHA, LSB, flow control,
                                                                    and delays for MISO and MOSI                               */

    struct {
      __IOM uint32_t SPOL       : 1;            /*!< [0..0] This bit selects SPI polarity.                                     */
      __IOM uint32_t SPHA       : 1;            /*!< [1..1] Selects the SPI phase; When 1, will shift the sampling
                                                     edge by 1/2 clock.                                                        */
      __IOM uint32_t FULLDUP    : 1;            /*!< [2..2] Full Duplex mode. Capture read data during writes operations       */
            uint32_t            : 13;
      __IOM uint32_t WTFC       : 1;            /*!< [16..16] Enables flow control of new write transactions based
                                                     on the SPI_STATUS signal from the BLE Core.                               */
      __IOM uint32_t RDFC       : 1;            /*!< [17..17] Enables flow control of new read transactions based
                                                     on the SPI_STATUS signal from the BLE Core.                               */
            uint32_t            : 3;
      __IOM uint32_t WTFCPOL    : 1;            /*!< [21..21] Selects the write flow control signal polarity. The
                                                     transfers are halted when the selected flow control signal
                                                     is OPPOSITE polarity of this bit. (For example: WTFCPOL
                                                     = 0 will allow a SPI_STATUS=1 to pause transfers).                        */
      __IOM uint32_t RDFCPOL    : 1;            /*!< [22..22] Selects the read flow control signal polarity. When
                                                     set, the clock will be held low until the flow control
                                                     is deasserted.                                                            */
      __IOM uint32_t SPILSB     : 1;            /*!< [23..23] Selects data transfer as MSB first (0) or LSB first
                                                     (1) for the data portion of the SPI transaction. The offset
                                                     bytes are always transmitted MSB first.                                   */
      __IOM uint32_t DINDLY     : 3;            /*!< [26..24] Delay tap to use for the input signal (MISO). This
                                                     gives more hold time on the input data.                                   */
      __IOM uint32_t DOUTDLY    : 3;            /*!< [29..27] Delay tap to use for the output signal (MOSI). This
                                                     give more hold time on the output data.                                   */
      __IOM uint32_t MSPIRST    : 1;            /*!< [30..30] Bit is deprecated. setting it will have no effect.               */
            uint32_t            : 1;
    } MSPICFG_b;
  } ;

  union {
    __IOM uint32_t BLECFG;                      /*!< (@ 0x00000304) Provides control of isolation and IO signals
                                                                    between the interface module and the BLE
                                                                    Core.                                                      */

    struct {
      __IOM uint32_t PWRSMEN    : 1;            /*!< [0..0] Enable the power state machine for automatic sequencing
                                                     and control of power states of the BLE Core module.                       */
      __IOM uint32_t BLERSTN    : 1;            /*!< [1..1] Reset line to the BLE Core. This will reset the BLE core
                                                     when asserted ('0') and must be written to '1' prior to
                                                     performing any BTLE related operations to the core.                       */
      __IOM uint32_t WAKEUPCTL  : 2;            /*!< [3..2] WAKE signal override. Controls the source of the WAKE
                                                     signal to the BLE Core.                                                   */
      __IOM uint32_t DCDCFLGCTL : 2;            /*!< [5..4] DCDCFLG signal override. The value of this field will
                                                     be sent to the BLE Core when the PWRSM is off. Otherwise,
                                                     the value is supplied from internal logic.                                */
      __IOM uint32_t BLEHREQCTL : 2;            /*!< [7..6] BLEH power on request override. The value of this field
                                                     will be sent to the BLE Core when the PWRSM is off. Otherwise,
                                                     the value is supplied from internal logic.                                */
      __IOM uint32_t WT4ACTOFF  : 1;            /*!< [8..8] Debug control of BLEIF power state machine. Allows transition
                                                     into the active state in the BLEIF state without waiting
                                                     for DCDC request from BLE Core.                                           */
      __IOM uint32_t MCUFRCSLP  : 1;            /*!< [9..9] Force power state machine to go to the sleep state. Intended
                                                     for debug only. Has no effect on the actual BLE Core state,
                                                     only the state of the BLEIF interface state machine.                      */
      __IOM uint32_t FRCCLK     : 1;            /*!< [10..10] Force the clock in the BLEIF to be always running                */
      __IOM uint32_t STAYASLEEP : 1;            /*!< [11..11] Set to prevent the BLE power control module from waking
                                                     up the BLE Core after going into power down. To be used
                                                     for graceful shutdown, set by software prior to powering
                                                     off and will allow assertion of reset from sleep state.                   */
      __IOM uint32_t PWRISOCTL  : 2;            /*!< [13..12] Configuration of BLEH isolation control for power related
                                                     signals.                                                                  */
      __IOM uint32_t SPIISOCTL  : 2;            /*!< [15..14] Configuration of BLEH isolation controls for SPI related
                                                     signals.                                                                  */
            uint32_t            : 16;
    } BLECFG_b;
  } ;

  union {
    __IOM uint32_t PWRCMD;                      /*!< (@ 0x00000308) Sends power related commands to the power state
                                                                    machine in the BLE IF module.                              */

    struct {
      __IOM uint32_t WAKEREQ    : 1;            /*!< [0..0] Wake request from the MCU. When asserted (1), the BLE
                                                     Interface logic will assert the wakeup request signal to
                                                     the BLE Core. Only recognized when in the sleep state                     */
      __IOM uint32_t RESTART    : 1;            /*!< [1..1] Restart the BLE Core after going into the shutdown state.
                                                     Only valid when in the shutdown state.                                    */
            uint32_t            : 30;
    } PWRCMD_b;
  } ;

  union {
    __IOM uint32_t BSTATUS;                     /*!< (@ 0x0000030C) Status of the BLE Core interface signals                   */

    struct {
      __IOM uint32_t B2MSTATE   : 3;            /*!< [2..0] State of the BLE Core logic.                                       */
      __IOM uint32_t SPISTATUS  : 1;            /*!< [3..3] Value of the SPISTATUS signal from the BLE Core. The
                                                     signal is asserted when the BLE Core is able to accept
                                                     write data via the SPI interface. Data should be transmitted
                                                     to theBLE core only when this signal is 1. The hardware
                                                     will automatically wait for this signal prior to performing
                                                     a write operation if flow control is active.                              */
      __IOM uint32_t DCDCREQ    : 1;            /*!< [4..4] Value of the DCDCREQ signal from the BLE Core. The DCDCREQ
                                                     signal is sent from the core to the BLEIF module when the
                                                     BLE core requires BLEH power to be active. When activated,
                                                     this isindicated by DCDCFLAG going to 1.                                  */
      __IOM uint32_t DCDCFLAG   : 1;            /*!< [5..5] Value of the DCDCFLAG signal to the BLE Core. The DCDCFLAG
                                                     is a signal to the BLE Core indicating that the BLEH power
                                                     is active.                                                                */
      __IOM uint32_t WAKEUP     : 1;            /*!< [6..6] Value of the WAKEUP signal to the BLE Core . The WAKEUP
                                                     signals is sent from the BLEIF to the BLECORE to request
                                                     the BLE Core transition from sleep state to active state.                 */
      __IOM uint32_t BLEIRQ     : 1;            /*!< [7..7] Status of the BLEIRQ signal from the BLE Core. A value
                                                     of 1 indicates that read data is available in the core
                                                     and a read operation needs to be performed.                               */
      __IOM uint32_t PWRST      : 3;            /*!< [10..8] Current status of the power state machine                         */
      __IOM uint32_t BLEHACK    : 1;            /*!< [11..11] Value of the BLEHACK signal from the power control
                                                     unit. If the signal is '1', the BLEH power is active and
                                                     ready for use.                                                            */
      __IOM uint32_t BLEHREQ    : 1;            /*!< [12..12] Value of the BLEHREQ signal to the power control unit.
                                                     The BLEHREQ signal is sent from the BLEIF module to the
                                                     power control module to request the BLEH power up. When
                                                     the BLEHACK signal is asserted,BLEH power is stable and
                                                     ready for use.                                                            */
            uint32_t            : 19;
    } BSTATUS_b;
  } ;
  __IM  uint32_t  RESERVED5[64];

  union {
    __IOM uint32_t BLEDBG;                      /*!< (@ 0x00000410) Debug control                                              */

    struct {
      __IOM uint32_t DBGEN      : 1;            /*!< [0..0] Debug Enable. Setting this bit will enable the update
                                                     of data within this register, otherwise it is clock gated
                                                     for power savings                                                         */
      __IOM uint32_t IOCLKON    : 1;            /*!< [1..1] IOCLK debug clock control. Enable IO_CLK to be active
                                                     when this bit is '1'. Otherwise, the clock is controlled
                                                     with gating from the logic as needed.                                     */
      __IOM uint32_t APBCLKON   : 1;            /*!< [2..2] APBCLK debug clock control. Enable APB_CLK to be active
                                                     when this bit is '1'. Otherwise, the clock is controlled
                                                     with gating from the logic as needed.                                     */
      __IOM uint32_t DBGDATA    : 29;           /*!< [31..3] Debug data                                                        */
    } BLEDBG_b;
  } ;
} BLEIF_Type;                                   /*!< Size = 1044 (0x414)                                                       */



/* =========================================================================================================================== */
/* ================                                         CACHECTRL                                         ================ */
/* =========================================================================================================================== */


/**
  * @brief FLASH Cache Controller (CACHECTRL)
  */

typedef struct {                                /*!< (@ 0x40018000) CACHECTRL Structure                                        */

  union {
    __IOM uint32_t CACHECFG;                    /*!< (@ 0x00000000) FLASH Cache Control                                        */

    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< [0..0] Enables the FLASH cache controller and enables power
                                                     to the cache SRAMs. The ICACHE_ENABLE and DCACHE_ENABLE
                                                     should be set to enable caching for each type of access.                  */
      __IOM uint32_t LRU        : 1;            /*!< [1..1] Sets the cache replacement policy. 0=LRR (least recently
                                                     replaced), 1=LRU (least recently used). LRR minimizes writes
                                                     to the TAG SRAM.                                                          */
      __IOM uint32_t ENABLE_NC0 : 1;            /*!< [2..2] Enable Non-cacheable region 0. See NCR0 registers to
                                                     define the region.                                                        */
      __IOM uint32_t ENABLE_NC1 : 1;            /*!< [3..3] Enable Non-cacheable region 1. See NCR1 registers to
                                                     define the region.                                                        */
      __IOM uint32_t CONFIG     : 4;            /*!< [7..4] Sets the cache configuration                                       */
      __IOM uint32_t ICACHE_ENABLE : 1;         /*!< [8..8] Enable FLASH Instruction Caching                                   */
      __IOM uint32_t DCACHE_ENABLE : 1;         /*!< [9..9] Enable FLASH Data Caching                                          */
      __IOM uint32_t CACHE_CLKGATE : 1;         /*!< [10..10] Enable clock gating of cache TAG RAM. Software should
                                                     enable this bit for optimal power efficiency.                             */
      __IOM uint32_t CACHE_LS   : 1;            /*!< [11..11] Enable LS (light sleep) of cache RAMs. Software should
                                                     DISABLE this bit since cache activity is too high to benefit
                                                     from LS usage.                                                            */
            uint32_t            : 8;
      __IOM uint32_t DATA_CLKGATE : 1;          /*!< [20..20] Enable aggressive clock gating of entire data array.
                                                     This bit should be set to 1 for optimal power efficiency.                 */
            uint32_t            : 3;
      __IOM uint32_t ENABLE_MONITOR : 1;        /*!< [24..24] Enable Cache Monitoring Stats. Cache monitoring consumes
                                                     additional power and should only be enabled when profiling
                                                     code and counters will increment when this bit is set.
                                                     Counter values will be retained when this is set to 0,
                                                     allowing software to enable/disable counting for multiple
                                                     code segments.                                                            */
            uint32_t            : 7;
    } CACHECFG_b;
  } ;

  union {
    __IOM uint32_t FLASHCFG;                    /*!< (@ 0x00000004) FLASH Control Register                                     */

    struct {
      __IOM uint32_t RD_WAIT    : 4;            /*!< [3..0] Sets read waitstates for normal (fast) operation. A value
                                                     of 1 is recommended.                                                      */
      __IOM uint32_t SEDELAY    : 3;            /*!< [6..4] Sets SE delay (FLASH address setup). A value of 5 is
                                                     recommended.                                                              */
            uint32_t            : 1;
      __IOM uint32_t LPM_RD_WAIT : 4;           /*!< [11..8] Sets FLASH waitstates when in LPM Mode 2 (RD_WAIT in
                                                     LPM mode 2 only)                                                          */
      __IOM uint32_t LPMMODE    : 2;            /*!< [13..12] Controls FLASH low power modes (control of LPM pin).             */
            uint32_t            : 18;
    } FLASHCFG_b;
  } ;

  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000008) Cache Control                                              */

    struct {
      __IOM uint32_t INVALIDATE : 1;            /*!< [0..0] Writing a 1 to this bit field invalidates the FLASH cache
                                                     contents.                                                                 */
      __IOM uint32_t RESET_STAT : 1;            /*!< [1..1] Reset Cache Statistics. When written to a 1, the cache
                                                     monitor counters will be cleared. The monitor counters
                                                     can be reset only when the CACHECFG.ENABLE_MONITOR bit
                                                     is set.                                                                   */
      __IOM uint32_t CACHE_READY : 1;           /*!< [2..2] Cache Ready Status (enabled and not processing an invalidate
                                                     operation)                                                                */
            uint32_t            : 1;
      __IOM uint32_t FLASH0_SLM_STATUS : 1;     /*!< [4..4] FLASH Sleep Mode Status. 1 indicates that FLASH0 is in
                                                     sleep mode, 0 indicates FLASH0 is in normal mode.                         */
      __IOM uint32_t FLASH0_SLM_DISABLE : 1;    /*!< [5..5] Disable FLASH Sleep Mode. Write 1 to wake FLASH0 from
                                                     sleep mode (reading the array will also automatically wake
                                                     it).                                                                      */
      __IOM uint32_t FLASH0_SLM_ENABLE : 1;     /*!< [6..6] Enable FLASH Sleep Mode. Write to 1 to put FLASH0 into
                                                     sleep mode. NOTE: there is a 5 us latency after waking
                                                     FLASH until the first access will be returned.                            */
            uint32_t            : 1;
      __IOM uint32_t FLASH1_SLM_STATUS : 1;     /*!< [8..8] FLASH Sleep Mode Status. 1 indicates that FLASH1 is in
                                                     sleep mode, 0 indicates FLASH1 is in normal mode.                         */
      __IOM uint32_t FLASH1_SLM_DISABLE : 1;    /*!< [9..9] Disable FLASH Sleep Mode. Write 1 to wake FLASH1 from
                                                     sleep mode (reading the array will also automatically wake
                                                     it).                                                                      */
      __IOM uint32_t FLASH1_SLM_ENABLE : 1;     /*!< [10..10] Enable FLASH Sleep Mode. Write to 1 to put FLASH1 into
                                                     sleep mode. NOTE: there is a 5 us latency after waking
                                                     FLASH until the first access will be returned.                            */
            uint32_t            : 21;
    } CTRL_b;
  } ;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t NCR0START;                   /*!< (@ 0x00000010) FLASH Cache Noncacheable Region 0 Start                    */

    struct {
            uint32_t            : 4;
      __IOM uint32_t ADDR       : 23;           /*!< [26..4] Start address for non-cacheable region 0                          */
            uint32_t            : 5;
    } NCR0START_b;
  } ;

  union {
    __IOM uint32_t NCR0END;                     /*!< (@ 0x00000014) FLASH Cache Noncacheable Region 0 End                      */

    struct {
            uint32_t            : 4;
      __IOM uint32_t ADDR       : 23;           /*!< [26..4] End address for non-cacheable region 0                            */
            uint32_t            : 5;
    } NCR0END_b;
  } ;

  union {
    __IOM uint32_t NCR1START;                   /*!< (@ 0x00000018) FLASH Cache Noncacheable Region 1 Start                    */

    struct {
            uint32_t            : 4;
      __IOM uint32_t ADDR       : 23;           /*!< [26..4] Start address for non-cacheable region 1                          */
            uint32_t            : 5;
    } NCR1START_b;
  } ;

  union {
    __IOM uint32_t NCR1END;                     /*!< (@ 0x0000001C) FLASH Cache Noncacheable Region 1 End                      */

    struct {
            uint32_t            : 4;
      __IOM uint32_t ADDR       : 23;           /*!< [26..4] End address for non-cacheable region 1                            */
            uint32_t            : 5;
    } NCR1END_b;
  } ;
  __IM  uint32_t  RESERVED1[8];

  union {
    __IOM uint32_t DMON0;                       /*!< (@ 0x00000040) Data Cache Total Accesses                                  */

    struct {
      __IOM uint32_t DACCESS_COUNT : 32;        /*!< [31..0] Total accesses to data cache. All performance metrics
                                                     should be relative to the number of accesses performed.                   */
    } DMON0_b;
  } ;

  union {
    __IOM uint32_t DMON1;                       /*!< (@ 0x00000044) Data Cache Tag Lookups                                     */

    struct {
      __IOM uint32_t DLOOKUP_COUNT : 32;        /*!< [31..0] Total tag lookups from data cache.                                */
    } DMON1_b;
  } ;

  union {
    __IOM uint32_t DMON2;                       /*!< (@ 0x00000048) Data Cache Hits                                            */

    struct {
      __IOM uint32_t DHIT_COUNT : 32;           /*!< [31..0] Cache hits from lookup operations.                                */
    } DMON2_b;
  } ;

  union {
    __IOM uint32_t DMON3;                       /*!< (@ 0x0000004C) Data Cache Line Hits                                       */

    struct {
      __IOM uint32_t DLINE_COUNT : 32;          /*!< [31..0] Cache hits from line cache                                        */
    } DMON3_b;
  } ;

  union {
    __IOM uint32_t IMON0;                       /*!< (@ 0x00000050) Instruction Cache Total Accesses                           */

    struct {
      __IOM uint32_t IACCESS_COUNT : 32;        /*!< [31..0] Total accesses to Instruction cache                               */
    } IMON0_b;
  } ;

  union {
    __IOM uint32_t IMON1;                       /*!< (@ 0x00000054) Instruction Cache Tag Lookups                              */

    struct {
      __IOM uint32_t ILOOKUP_COUNT : 32;        /*!< [31..0] Total tag lookups from Instruction cache                          */
    } IMON1_b;
  } ;

  union {
    __IOM uint32_t IMON2;                       /*!< (@ 0x00000058) Instruction Cache Hits                                     */

    struct {
      __IOM uint32_t IHIT_COUNT : 32;           /*!< [31..0] Cache hits from lookup operations                                 */
    } IMON2_b;
  } ;

  union {
    __IOM uint32_t IMON3;                       /*!< (@ 0x0000005C) Instruction Cache Line Hits                                */

    struct {
      __IOM uint32_t ILINE_COUNT : 32;          /*!< [31..0] Cache hits from line cache                                        */
    } IMON3_b;
  } ;
} CACHECTRL_Type;                               /*!< Size = 96 (0x60)                                                          */



/* =========================================================================================================================== */
/* ================                                          CLKGEN                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Clock Generator (CLKGEN)
  */

typedef struct {                                /*!< (@ 0x40004000) CLKGEN Structure                                           */

  union {
    __IOM uint32_t CALXT;                       /*!< (@ 0x00000000) This is the XT Oscillator Calibration value.
                                                                    This value allows any derived XT clocks
                                                                    to be calibrated. This means that the original
                                                                    32KHz version of XT will not be changed,
                                                                    but a 16KHz version (divided down version)
                                                                    can be modified. This register value will
                                                                    add or subtract the number of cycles programmed
                                                                    in this register across a 32 seconds interval.
                                                                    For example, if a value of 100 is programmed
                                                                    in this register, then 100 additional clock
                                                                    cycles will be added into a 16KHz clock
                                                                    period across                                              */

    struct {
      __IOM uint32_t CALXT      : 11;           /*!< [10..0] XT Oscillator calibration value. This register will
                                                     enable the hardware to increase or decrease the number
                                                     of cycles in a 16KHz clock derived from the original 32KHz
                                                     version. The most significant bit is the sign. A '1' is
                                                     a reduction, and a '0' is an addition. This calibration
                                                     value will add or reduce the number of cycles programmed
                                                     here across a 32 second interval. The maximum value that
                                                     is effective is from -1024 to 1023.                                       */
            uint32_t            : 21;
    } CALXT_b;
  } ;

  union {
    __IOM uint32_t CALRC;                       /*!< (@ 0x00000004) This is the LFRC Calibration value. Similar to
                                                                    the XT calibration, it allows the derived
                                                                    LFRC clock to be calibrated. The original
                                                                    1024Hz clock source will not change, but
                                                                    a 512Hz version (divided down version) can
                                                                    be modified. This register will add or subtract
                                                                    the number of cycles programmed in this
                                                                    register across a 1024 seconds interval.
                                                                    For example, if a value of 200 is programmed
                                                                    in this register, then 200 additional clocks
                                                                    will be added into the 512Hz derived clock
                                                                    across a 1024 secon                                        */

    struct {
      __IOM uint32_t CALRC      : 18;           /*!< [17..0] LFRC Oscillator calibration value. This register will
                                                     enable the hardware to increase or decrease the number
                                                     of cycles in a 512 Hz clock derived from the original 1024
                                                     version. The most significant bit is the sign. A '1' is
                                                     a reduction, and a '0' is an addition. This calibration
                                                     value will add or reduce the number of cycles programmed
                                                     here across a 32 second interval. The range is from -131072
                                                     (decimal) to 131071 (decimal). This register is normally
                                                     used in conjunction with ACALCTR register. The CALRC regi                 */
            uint32_t            : 14;
    } CALRC_b;
  } ;

  union {
    __IOM uint32_t ACALCTR;                     /*!< (@ 0x00000008) This register can be used for 2 purposes. The
                                                                    first is to calibrate the LFRC clock using
                                                                    the XT clock source. The second is to measure
                                                                    an internal clock signal relative to the
                                                                    external clock. In that case, the ACALCTR
                                                                    will show the multiple of the external clock
                                                                    with respect to the internal clock signal.
                                                                    E.g. Fref = Fmeas x ACALCTR. Note that this
                                                                    register should not be confused with the
                                                                    HFRC Adjustment register, which is separately
                                                                    defined in CLKGEN_HFADJ register.                          */

    struct {
      __IOM uint32_t ACALCTR    : 24;           /*!< [23..0] Autocalibration Counter result. Bits 17 down to 0 of
                                                     this is feed directly to the CALRC register if ACAL register
                                                     in OCTRL register is set to 1024SEC or 512SEC.                            */
            uint32_t            : 8;
    } ACALCTR_b;
  } ;

  union {
    __IOM uint32_t OCTRL;                       /*!< (@ 0x0000000C) This register includes controls for autocalibration
                                                                    in addition to the RTC oscillator controls.                */

    struct {
      __IOM uint32_t STOPXT     : 1;            /*!< [0..0] Stop the XT Oscillator to the RTC                                  */
      __IOM uint32_t STOPRC     : 1;            /*!< [1..1] Stop the LFRC Oscillator to the RTC                                */
            uint32_t            : 4;
      __IOM uint32_t FOS        : 1;            /*!< [6..6] Oscillator switch on failure function. If this is set,
                                                     then LFRC clock source will switch from XT to RC.                         */
      __IOM uint32_t OSEL       : 1;            /*!< [7..7] Selects the RTC oscillator (1 => LFRC, 0 => XT)                    */
      __IOM uint32_t ACAL       : 3;            /*!< [10..8] Autocalibration control. This selects the source to
                                                     be used in the autocalibration flow. This flow can also
                                                     be used to measure an internal clock against an external
                                                     clock source, with the external clock normally used as
                                                     the reference.                                                            */
            uint32_t            : 21;
    } OCTRL_b;
  } ;

  union {
    __IOM uint32_t CLKOUT;                      /*!< (@ 0x00000010) This register enables the CLKOUT to the GPIOs,
                                                                    and selects the clock source to that.                      */

    struct {
      __IOM uint32_t CKSEL      : 6;            /*!< [5..0] CLKOUT signal select                                               */
            uint32_t            : 1;
      __IOM uint32_t CKEN       : 1;            /*!< [7..7] Enable the CLKOUT signal                                           */
            uint32_t            : 24;
    } CLKOUT_b;
  } ;

  union {
    __IOM uint32_t CLKKEY;                      /*!< (@ 0x00000014) This controls the write access to the CCTRL register.
                                                                    This prevents customers from accidentally
                                                                    setting the HFRC clocks to be half of what
                                                                    they are set to.                                           */

    struct {
      __IOM uint32_t CLKKEY     : 32;           /*!< [31..0] Key register value.                                               */
    } CLKKEY_b;
  } ;

  union {
    __IOM uint32_t CCTRL;                       /*!< (@ 0x00000018) This register controls the main divider for HFRC
                                                                    clock. If this is set, all internal HFRC
                                                                    clock sources are divided by 2.                            */

    struct {
      __IOM uint32_t CORESEL    : 1;            /*!< [0..0] Core Clock divisor                                                 */
            uint32_t            : 31;
    } CCTRL_b;
  } ;

  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x0000001C) This register provides status to the XT oscillator
                                                                    and the source of the RTC.                                 */

    struct {
      __IOM uint32_t OMODE      : 1;            /*!< [0..0] Current RTC oscillator (1 => LFRC, 0 => XT). After an
                                                     RTC oscillator change, it may take up to 2 seconds for
                                                     this field to reflect the new oscillator.                                 */
      __IOM uint32_t OSCF       : 1;            /*!< [1..1] XT Oscillator is enabled but not oscillating                       */
            uint32_t            : 30;
    } STATUS_b;
  } ;

  union {
    __IOM uint32_t HFADJ;                       /*!< (@ 0x00000020) This register controls the HFRC adjustment. The
                                                                    HFRC clock can change with temperature and
                                                                    process corners, and this register controls
                                                                    the HFRC adjustment logic which reduces
                                                                    the fluctuations to the clock.                             */

    struct {
      __IOM uint32_t HFADJEN    : 1;            /*!< [0..0] HFRC adjustment control                                            */
      __IOM uint32_t HFADJCK    : 3;            /*!< [3..1] Repeat period for HFRC adjustment                                  */
            uint32_t            : 4;
      __IOM uint32_t HFXTADJ    : 12;           /*!< [19..8] Target HFRC adjustment value.                                     */
      __IOM uint32_t HFWARMUP   : 1;            /*!< [20..20] XT warm-up period for HFRC adjustment                            */
      __IOM uint32_t HFADJGAIN  : 3;            /*!< [23..21] Gain control for HFRC adjustment                                 */
            uint32_t            : 8;
    } HFADJ_b;
  } ;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t CLOCKENSTAT;                 /*!< (@ 0x00000028) This register provides the enable status to all
                                                                    the peripheral clocks.                                     */

    struct {
      __IOM uint32_t CLOCKENSTAT : 32;          /*!< [31..0] Clock enable status                                               */
    } CLOCKENSTAT_b;
  } ;

  union {
    __IOM uint32_t CLOCKEN2STAT;                /*!< (@ 0x0000002C) This is a continuation of the clock enable status.         */

    struct {
      __IOM uint32_t CLOCKEN2STAT : 32;         /*!< [31..0] Clock enable status 2                                             */
    } CLOCKEN2STAT_b;
  } ;

  union {
    __IOM uint32_t CLOCKEN3STAT;                /*!< (@ 0x00000030) This is a continuation of the clock enable status.         */

    struct {
      __IOM uint32_t CLOCKEN3STAT : 32;         /*!< [31..0] Clock enable status 3                                             */
    } CLOCKEN3STAT_b;
  } ;

  union {
    __IOM uint32_t FREQCTRL;                    /*!< (@ 0x00000034) This register provides the burst control and
                                                                    burst status.                                              */

    struct {
      __IOM uint32_t BURSTREQ   : 1;            /*!< [0..0] Frequency Burst Enable Request                                     */
      __IOM uint32_t BURSTACK   : 1;            /*!< [1..1] Frequency Burst Request Acknowledge. Frequency burst
                                                     requested is always acknowledged whether burst is granted
                                                     or not depending on feature enable.                                       */
      __IOM uint32_t BURSTSTATUS : 1;           /*!< [2..2] This represents frequency burst status.                            */
            uint32_t            : 29;
    } FREQCTRL_b;
  } ;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t BLEBUCKTONADJ;               /*!< (@ 0x0000003C) This is the register control for BLE ton adjustment
                                                                    logic.                                                     */

    struct {
      __IOM uint32_t TONLOWTHRESHOLD : 10;      /*!< [9..0] TON ADJUST LOW THRESHOLD. Suggested values are #A(94KHz)
                                                     #15(47KHz) #53(12Khz) #14D(3Khz)                                          */
      __IOM uint32_t TONHIGHTHRESHOLD : 10;     /*!< [19..10] TON ADJUST HIGH THRESHOLD. Suggested values are #15(94KHz)
                                                     #2A(47Khz) #A6(12Khz) #29A(3Khz)                                          */
      __IOM uint32_t TONADJUSTPERIOD : 2;       /*!< [21..20] TON ADJUST PERIOD                                                */
      __IOM uint32_t TONADJUSTEN : 1;           /*!< [22..22] TON ADJUST ENABLE                                                */
      __IOM uint32_t ZEROLENDETECTTRIM : 4;     /*!< [26..23] BLEBUCK ZERO LENGTH DETECT TRIM                                  */
      __IOM uint32_t ZEROLENDETECTEN : 1;       /*!< [27..27] BLEBUCK ZERO LENGTH DETECT ENABLE                                */
            uint32_t            : 4;
    } BLEBUCKTONADJ_b;
  } ;
  __IM  uint32_t  RESERVED2[48];

  union {
    __IOM uint32_t INTRPTEN;                    /*!< (@ 0x00000100) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
            uint32_t            : 29;
    } INTRPTEN_b;
  } ;

  union {
    __IOM uint32_t INTRPTSTAT;                  /*!< (@ 0x00000104) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
            uint32_t            : 29;
    } INTRPTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTRPTCLR;                   /*!< (@ 0x00000108) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
            uint32_t            : 29;
    } INTRPTCLR_b;
  } ;

  union {
    __IOM uint32_t INTRPTSET;                   /*!< (@ 0x0000010C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t ACF        : 1;            /*!< [0..0] Autocalibration Fail interrupt                                     */
      __IOM uint32_t ACC        : 1;            /*!< [1..1] Autocalibration Complete interrupt                                 */
      __IOM uint32_t OF         : 1;            /*!< [2..2] XT Oscillator Fail interrupt                                       */
            uint32_t            : 29;
    } INTRPTSET_b;
  } ;
} CLKGEN_Type;                                  /*!< Size = 272 (0x110)                                                        */



/* =========================================================================================================================== */
/* ================                                          CTIMER                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Counter/Timer (CTIMER)
  */

typedef struct {                                /*!< (@ 0x40008000) CTIMER Structure                                           */

  union {
    __IOM uint32_t TMR0;                        /*!< (@ 0x00000000) This register holds the running time or event
                                                                    count for CTIMER 0. This is either for each
                                                                    16 bit half or for the whole 32 bit count
                                                                    when the pair is linked. If the pair is
                                                                    not linked, they can be running on separate
                                                                    clocks and are completely independent.                     */

    struct {
      __IOM uint32_t CTTMRA0    : 16;           /*!< [15..0] Counter/Timer A0.                                                 */
      __IOM uint32_t CTTMRB0    : 16;           /*!< [31..16] Counter/Timer B0.                                                */
    } TMR0_b;
  } ;

  union {
    __IOM uint32_t CMPRA0;                      /*!< (@ 0x00000004) This contains the Compare limits for timer 0
                                                                    half A.                                                    */

    struct {
      __IOM uint32_t CMPR0A0    : 16;           /*!< [15..0] Counter/Timer A0 Compare Register 0. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR1A0    : 16;           /*!< [31..16] Counter/Timer A0 Compare Register 1. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRA0_b;
  } ;

  union {
    __IOM uint32_t CMPRB0;                      /*!< (@ 0x00000008) This contains the Compare limits for timer 0
                                                                    B half.                                                    */

    struct {
      __IOM uint32_t CMPR0B0    : 16;           /*!< [15..0] Counter/Timer B0 Compare Register 0. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR1B0    : 16;           /*!< [31..16] Counter/Timer B0 Compare Register 1. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRB0_b;
  } ;

  union {
    __IOM uint32_t CTRL0;                       /*!< (@ 0x0000000C) This includes the Control bit fields for both
                                                                    halves of timer 0.                                         */

    struct {
      __IOM uint32_t TMRA0EN    : 1;            /*!< [0..0] Counter/Timer A0 Enable bit.                                       */
      __IOM uint32_t TMRA0CLK   : 5;            /*!< [5..1] Counter/Timer A0 Clock Select.                                     */
      __IOM uint32_t TMRA0FN    : 3;            /*!< [8..6] Counter/Timer A0 Function Select.                                  */
      __IOM uint32_t TMRA0IE0   : 1;            /*!< [9..9] Counter/Timer A0 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA0IE1   : 1;            /*!< [10..10] Counter/Timer A0 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA0CLR   : 1;            /*!< [11..11] Counter/Timer A0 Clear bit.                                      */
      __IOM uint32_t TMRA0POL   : 1;            /*!< [12..12] Counter/Timer A0 output polarity.                                */
            uint32_t            : 3;
      __IOM uint32_t TMRB0EN    : 1;            /*!< [16..16] Counter/Timer B0 Enable bit.                                     */
      __IOM uint32_t TMRB0CLK   : 5;            /*!< [21..17] Counter/Timer B0 Clock Select.                                   */
      __IOM uint32_t TMRB0FN    : 3;            /*!< [24..22] Counter/Timer B0 Function Select.                                */
      __IOM uint32_t TMRB0IE0   : 1;            /*!< [25..25] Counter/Timer B0 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB0IE1   : 1;            /*!< [26..26] Counter/Timer B0 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB0CLR   : 1;            /*!< [27..27] Counter/Timer B0 Clear bit.                                      */
      __IOM uint32_t TMRB0POL   : 1;            /*!< [28..28] Counter/Timer B0 output polarity.                                */
            uint32_t            : 2;
      __IOM uint32_t CTLINK0    : 1;            /*!< [31..31] Counter/Timer A0/B0 Link bit.                                    */
    } CTRL0_b;
  } ;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t CMPRAUXA0;                   /*!< (@ 0x00000014) Enhanced compare limits for timer half A. This
                                                                    is valid if timer 0 is set to function 4
                                                                    and function 5.                                            */

    struct {
      __IOM uint32_t CMPR2A0    : 16;           /*!< [15..0] Counter/Timer A0 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A0    : 16;           /*!< [31..16] Counter/Timer A0 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA0_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB0;                   /*!< (@ 0x00000018) Enhanced compare limits for timer half B. This
                                                                    is valid if timer 0 is set to function 4
                                                                    and function 5.                                            */

    struct {
      __IOM uint32_t CMPR2B0    : 16;           /*!< [15..0] Counter/Timer B0 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B0    : 16;           /*!< [31..16] Counter/Timer B0 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB0_b;
  } ;

  union {
    __IOM uint32_t AUX0;                        /*!< (@ 0x0000001C) Control bit fields for both halves of timer 0.             */

    struct {
      __IOM uint32_t TMRA0LMT   : 7;            /*!< [6..0] Counter/Timer A0 Pattern Limit Count.                              */
      __IOM uint32_t TMRA0TRIG  : 4;            /*!< [10..7] Counter/Timer A0 Trigger Select.                                  */
      __IOM uint32_t TMRA0NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA0TINV  : 1;            /*!< [12..12] Counter/Timer A0 Invert on trigger.                              */
      __IOM uint32_t TMRA0POL23 : 1;            /*!< [13..13] Counter/Timer A0 Upper output polarity                           */
      __IOM uint32_t TMRA0EN23  : 1;            /*!< [14..14] Counter/Timer A0 Upper compare enable.                           */
            uint32_t            : 1;
      __IOM uint32_t TMRB0LMT   : 6;            /*!< [21..16] Counter/Timer B0 Pattern Limit Count.                            */
            uint32_t            : 1;
      __IOM uint32_t TMRB0TRIG  : 4;            /*!< [26..23] Counter/Timer B0 Trigger Select.                                 */
      __IOM uint32_t TMRB0NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB0TINV  : 1;            /*!< [28..28] Counter/Timer B0 Invert on trigger.                              */
      __IOM uint32_t TMRB0POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB0EN23  : 1;            /*!< [30..30] Counter/Timer B0 Upper compare enable.                           */
            uint32_t            : 1;
    } AUX0_b;
  } ;

  union {
    __IOM uint32_t TMR1;                        /*!< (@ 0x00000020) This register holds the running time or event
                                                                    count for CTIMER 1. This is either for each
                                                                    16 bit half or for the whole 32 bit count
                                                                    when the pair is linked. If the pair is
                                                                    not linked, they can be running on separate
                                                                    clocks and are completely independent.                     */

    struct {
      __IOM uint32_t CTTMRA1    : 16;           /*!< [15..0] Counter/Timer A1.                                                 */
      __IOM uint32_t CTTMRB1    : 16;           /*!< [31..16] Counter/Timer B1.                                                */
    } TMR1_b;
  } ;

  union {
    __IOM uint32_t CMPRA1;                      /*!< (@ 0x00000024) This contains the Compare limits for timer 1
                                                                    A half.                                                    */

    struct {
      __IOM uint32_t CMPR0A1    : 16;           /*!< [15..0] Counter/Timer A1 Compare Register 0.                              */
      __IOM uint32_t CMPR1A1    : 16;           /*!< [31..16] Counter/Timer A1 Compare Register 1.                             */
    } CMPRA1_b;
  } ;

  union {
    __IOM uint32_t CMPRB1;                      /*!< (@ 0x00000028) This contains the Compare limits for timer 1
                                                                    B half.                                                    */

    struct {
      __IOM uint32_t CMPR0B1    : 16;           /*!< [15..0] Counter/Timer B1 Compare Register 0.                              */
      __IOM uint32_t CMPR1B1    : 16;           /*!< [31..16] Counter/Timer B1 Compare Register 1.                             */
    } CMPRB1_b;
  } ;

  union {
    __IOM uint32_t CTRL1;                       /*!< (@ 0x0000002C) This includes the Control bit fields for both
                                                                    halves of timer 1.                                         */

    struct {
      __IOM uint32_t TMRA1EN    : 1;            /*!< [0..0] Counter/Timer A1 Enable bit.                                       */
      __IOM uint32_t TMRA1CLK   : 5;            /*!< [5..1] Counter/Timer A1 Clock Select.                                     */
      __IOM uint32_t TMRA1FN    : 3;            /*!< [8..6] Counter/Timer A1 Function Select.                                  */
      __IOM uint32_t TMRA1IE0   : 1;            /*!< [9..9] Counter/Timer A1 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA1IE1   : 1;            /*!< [10..10] Counter/Timer A1 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA1CLR   : 1;            /*!< [11..11] Counter/Timer A1 Clear bit.                                      */
      __IOM uint32_t TMRA1POL   : 1;            /*!< [12..12] Counter/Timer A1 output polarity.                                */
            uint32_t            : 3;
      __IOM uint32_t TMRB1EN    : 1;            /*!< [16..16] Counter/Timer B1 Enable bit.                                     */
      __IOM uint32_t TMRB1CLK   : 5;            /*!< [21..17] Counter/Timer B1 Clock Select.                                   */
      __IOM uint32_t TMRB1FN    : 3;            /*!< [24..22] Counter/Timer B1 Function Select.                                */
      __IOM uint32_t TMRB1IE0   : 1;            /*!< [25..25] Counter/Timer B1 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB1IE1   : 1;            /*!< [26..26] Counter/Timer B1 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB1CLR   : 1;            /*!< [27..27] Counter/Timer B1 Clear bit.                                      */
      __IOM uint32_t TMRB1POL   : 1;            /*!< [28..28] Counter/Timer B1 output polarity.                                */
            uint32_t            : 2;
      __IOM uint32_t CTLINK1    : 1;            /*!< [31..31] Counter/Timer A1/B1 Link bit.                                    */
    } CTRL1_b;
  } ;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t CMPRAUXA1;                   /*!< (@ 0x00000034) Enhanced compare limits for timer half A. This
                                                                    is valid if timer 1 is set to function 4
                                                                    and function 5.                                            */

    struct {
      __IOM uint32_t CMPR2A1    : 16;           /*!< [15..0] Counter/Timer A1 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A1    : 16;           /*!< [31..16] Counter/Timer A1 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA1_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB1;                   /*!< (@ 0x00000038) Enhanced compare limits for timer half B. This
                                                                    is valid if timer 1 is set to function 4
                                                                    and function 5.                                            */

    struct {
      __IOM uint32_t CMPR2B1    : 16;           /*!< [15..0] Counter/Timer B1 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B1    : 16;           /*!< [31..16] Counter/Timer B1 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB1_b;
  } ;

  union {
    __IOM uint32_t AUX1;                        /*!< (@ 0x0000003C) Control bit fields for both halves of timer 0.             */

    struct {
      __IOM uint32_t TMRA1LMT   : 7;            /*!< [6..0] Counter/Timer A1 Pattern Limit Count.                              */
      __IOM uint32_t TMRA1TRIG  : 4;            /*!< [10..7] Counter/Timer A1 Trigger Select.                                  */
      __IOM uint32_t TMRA1NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA1TINV  : 1;            /*!< [12..12] Counter/Timer A1 Invert on trigger.                              */
      __IOM uint32_t TMRA1POL23 : 1;            /*!< [13..13] Counter/Timer A1 Upper output polarity                           */
      __IOM uint32_t TMRA1EN23  : 1;            /*!< [14..14] Counter/Timer A1 Upper compare enable.                           */
            uint32_t            : 1;
      __IOM uint32_t TMRB1LMT   : 6;            /*!< [21..16] Counter/Timer B1 Pattern Limit Count.                            */
            uint32_t            : 1;
      __IOM uint32_t TMRB1TRIG  : 4;            /*!< [26..23] Counter/Timer B1 Trigger Select.                                 */
      __IOM uint32_t TMRB1NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB1TINV  : 1;            /*!< [28..28] Counter/Timer B1 Invert on trigger.                              */
      __IOM uint32_t TMRB1POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB1EN23  : 1;            /*!< [30..30] Counter/Timer B1 Upper compare enable.                           */
            uint32_t            : 1;
    } AUX1_b;
  } ;

  union {
    __IOM uint32_t TMR2;                        /*!< (@ 0x00000040) This register holds the running time or event
                                                                    count for CTIMER 2. This is either for each
                                                                    16 bit half or for the whole 32 bit count
                                                                    when the pair is linked. If the pair is
                                                                    not linked, they can be running on separate
                                                                    clocks and are completely independent.                     */

    struct {
      __IOM uint32_t CTTMRA2    : 16;           /*!< [15..0] Counter/Timer A2.                                                 */
      __IOM uint32_t CTTMRB2    : 16;           /*!< [31..16] Counter/Timer B2.                                                */
    } TMR2_b;
  } ;

  union {
    __IOM uint32_t CMPRA2;                      /*!< (@ 0x00000044) This register holds the compare limits for timer
                                                                    2 A half.                                                  */

    struct {
      __IOM uint32_t CMPR0A2    : 16;           /*!< [15..0] Counter/Timer A2 Compare Register 0.                              */
      __IOM uint32_t CMPR1A2    : 16;           /*!< [31..16] Counter/Timer A2 Compare Register 1.                             */
    } CMPRA2_b;
  } ;

  union {
    __IOM uint32_t CMPRB2;                      /*!< (@ 0x00000048) This register holds the compare limits for timer
                                                                    2 B half.                                                  */

    struct {
      __IOM uint32_t CMPR0B2    : 16;           /*!< [15..0] Counter/Timer B2 Compare Register 0.                              */
      __IOM uint32_t CMPR1B2    : 16;           /*!< [31..16] Counter/Timer B2 Compare Register 1.                             */
    } CMPRB2_b;
  } ;

  union {
    __IOM uint32_t CTRL2;                       /*!< (@ 0x0000004C) This register holds the control bit fields for
                                                                    both halves of timer 2.                                    */

    struct {
      __IOM uint32_t TMRA2EN    : 1;            /*!< [0..0] Counter/Timer A2 Enable bit.                                       */
      __IOM uint32_t TMRA2CLK   : 5;            /*!< [5..1] Counter/Timer A2 Clock Select.                                     */
      __IOM uint32_t TMRA2FN    : 3;            /*!< [8..6] Counter/Timer A2 Function Select.                                  */
      __IOM uint32_t TMRA2IE0   : 1;            /*!< [9..9] Counter/Timer A2 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA2IE1   : 1;            /*!< [10..10] Counter/Timer A2 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA2CLR   : 1;            /*!< [11..11] Counter/Timer A2 Clear bit.                                      */
      __IOM uint32_t TMRA2POL   : 1;            /*!< [12..12] Counter/Timer A2 output polarity.                                */
            uint32_t            : 3;
      __IOM uint32_t TMRB2EN    : 1;            /*!< [16..16] Counter/Timer B2 Enable bit.                                     */
      __IOM uint32_t TMRB2CLK   : 5;            /*!< [21..17] Counter/Timer B2 Clock Select.                                   */
      __IOM uint32_t TMRB2FN    : 3;            /*!< [24..22] Counter/Timer B2 Function Select.                                */
      __IOM uint32_t TMRB2IE0   : 1;            /*!< [25..25] Counter/Timer B2 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB2IE1   : 1;            /*!< [26..26] Counter/Timer B2 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB2CLR   : 1;            /*!< [27..27] Counter/Timer B2 Clear bit.                                      */
      __IOM uint32_t TMRB2POL   : 1;            /*!< [28..28] Counter/Timer B2 output polarity.                                */
            uint32_t            : 2;
      __IOM uint32_t CTLINK2    : 1;            /*!< [31..31] Counter/Timer A2/B2 Link bit.                                    */
    } CTRL2_b;
  } ;
  __IM  uint32_t  RESERVED2;

  union {
    __IOM uint32_t CMPRAUXA2;                   /*!< (@ 0x00000054) Enhanced compare limits for timer half A.                  */

    struct {
      __IOM uint32_t CMPR2A2    : 16;           /*!< [15..0] Counter/Timer A2 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A2    : 16;           /*!< [31..16] Counter/Timer A2 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA2_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB2;                   /*!< (@ 0x00000058) Enhanced compare limits for timer half B.                  */

    struct {
      __IOM uint32_t CMPR2B2    : 16;           /*!< [15..0] Counter/Timer B2 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B2    : 16;           /*!< [31..16] Counter/Timer B2 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB2_b;
  } ;

  union {
    __IOM uint32_t AUX2;                        /*!< (@ 0x0000005C) Control bit fields for both halves of timer 0.             */

    struct {
      __IOM uint32_t TMRA2LMT   : 7;            /*!< [6..0] Counter/Timer A2 Pattern Limit Count.                              */
      __IOM uint32_t TMRA2TRIG  : 4;            /*!< [10..7] Counter/Timer A2 Trigger Select.                                  */
      __IOM uint32_t TMRA2NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA2TINV  : 1;            /*!< [12..12] Counter/Timer A2 Invert on trigger.                              */
      __IOM uint32_t TMRA2POL23 : 1;            /*!< [13..13] Counter/Timer A2 Upper output polarity                           */
      __IOM uint32_t TMRA2EN23  : 1;            /*!< [14..14] Counter/Timer A2 Upper compare enable.                           */
            uint32_t            : 1;
      __IOM uint32_t TMRB2LMT   : 6;            /*!< [21..16] Counter/Timer B2 Pattern Limit Count.                            */
            uint32_t            : 1;
      __IOM uint32_t TMRB2TRIG  : 4;            /*!< [26..23] Counter/Timer B2 Trigger Select.                                 */
      __IOM uint32_t TMRB2NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB2TINV  : 1;            /*!< [28..28] Counter/Timer B2 Invert on trigger.                              */
      __IOM uint32_t TMRB2POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB2EN23  : 1;            /*!< [30..30] Counter/Timer B2 Upper compare enable.                           */
            uint32_t            : 1;
    } AUX2_b;
  } ;

  union {
    __IOM uint32_t TMR3;                        /*!< (@ 0x00000060) Counter/Timer 3                                            */

    struct {
      __IOM uint32_t CTTMRA3    : 16;           /*!< [15..0] Counter/Timer A3.                                                 */
      __IOM uint32_t CTTMRB3    : 16;           /*!< [31..16] Counter/Timer B3.                                                */
    } TMR3_b;
  } ;

  union {
    __IOM uint32_t CMPRA3;                      /*!< (@ 0x00000064) This register holds the compare limits for timer
                                                                    half A.                                                    */

    struct {
      __IOM uint32_t CMPR0A3    : 16;           /*!< [15..0] Counter/Timer A3 Compare Register 0.                              */
      __IOM uint32_t CMPR1A3    : 16;           /*!< [31..16] Counter/Timer A3 Compare Register 1.                             */
    } CMPRA3_b;
  } ;

  union {
    __IOM uint32_t CMPRB3;                      /*!< (@ 0x00000068) This register holds the compare limits for timer
                                                                    half B.                                                    */

    struct {
      __IOM uint32_t CMPR0B3    : 16;           /*!< [15..0] Counter/Timer B3 Compare Register 0.                              */
      __IOM uint32_t CMPR1B3    : 16;           /*!< [31..16] Counter/Timer B3 Compare Register 1.                             */
    } CMPRB3_b;
  } ;

  union {
    __IOM uint32_t CTRL3;                       /*!< (@ 0x0000006C) This register holds the control bit fields for
                                                                    both halves of timer 3.                                    */

    struct {
      __IOM uint32_t TMRA3EN    : 1;            /*!< [0..0] Counter/Timer A3 Enable bit.                                       */
      __IOM uint32_t TMRA3CLK   : 5;            /*!< [5..1] Counter/Timer A3 Clock Select.                                     */
      __IOM uint32_t TMRA3FN    : 3;            /*!< [8..6] Counter/Timer A3 Function Select.                                  */
      __IOM uint32_t TMRA3IE0   : 1;            /*!< [9..9] Counter/Timer A3 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA3IE1   : 1;            /*!< [10..10] Counter/Timer A3 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA3CLR   : 1;            /*!< [11..11] Counter/Timer A3 Clear bit.                                      */
      __IOM uint32_t TMRA3POL   : 1;            /*!< [12..12] Counter/Timer A3 output polarity.                                */
            uint32_t            : 2;
      __IOM uint32_t ADCEN      : 1;            /*!< [15..15] Special Timer A3 enable for ADC function.                        */
      __IOM uint32_t TMRB3EN    : 1;            /*!< [16..16] Counter/Timer B3 Enable bit.                                     */
      __IOM uint32_t TMRB3CLK   : 5;            /*!< [21..17] Counter/Timer B3 Clock Select.                                   */
      __IOM uint32_t TMRB3FN    : 3;            /*!< [24..22] Counter/Timer B3 Function Select.                                */
      __IOM uint32_t TMRB3IE0   : 1;            /*!< [25..25] Counter/Timer B3 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB3IE1   : 1;            /*!< [26..26] Counter/Timer B3 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB3CLR   : 1;            /*!< [27..27] Counter/Timer B3 Clear bit.                                      */
      __IOM uint32_t TMRB3POL   : 1;            /*!< [28..28] Counter/Timer B3 output polarity.                                */
            uint32_t            : 2;
      __IOM uint32_t CTLINK3    : 1;            /*!< [31..31] Counter/Timer A3/B3 Link bit.                                    */
    } CTRL3_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t CMPRAUXA3;                   /*!< (@ 0x00000074) Enhanced compare limits for timer half A.                  */

    struct {
      __IOM uint32_t CMPR2A3    : 16;           /*!< [15..0] Counter/Timer A3 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A3    : 16;           /*!< [31..16] Counter/Timer A3 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA3_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB3;                   /*!< (@ 0x00000078) Enhanced compare limits for timer half B.                  */

    struct {
      __IOM uint32_t CMPR2B3    : 16;           /*!< [15..0] Counter/Timer B3 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B3    : 16;           /*!< [31..16] Counter/Timer B3 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB3_b;
  } ;

  union {
    __IOM uint32_t AUX3;                        /*!< (@ 0x0000007C) Control bit fields for both halves of timer 0.             */

    struct {
      __IOM uint32_t TMRA3LMT   : 7;            /*!< [6..0] Counter/Timer A3 Pattern Limit Count.                              */
      __IOM uint32_t TMRA3TRIG  : 4;            /*!< [10..7] Counter/Timer A3 Trigger Select.                                  */
      __IOM uint32_t TMRA3NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA3TINV  : 1;            /*!< [12..12] Counter/Timer A3 Invert on trigger.                              */
      __IOM uint32_t TMRA3POL23 : 1;            /*!< [13..13] Counter/Timer A3 Upper output polarity                           */
      __IOM uint32_t TMRA3EN23  : 1;            /*!< [14..14] Counter/Timer A3 Upper compare enable.                           */
            uint32_t            : 1;
      __IOM uint32_t TMRB3LMT   : 6;            /*!< [21..16] Counter/Timer B3 Pattern Limit Count.                            */
            uint32_t            : 1;
      __IOM uint32_t TMRB3TRIG  : 4;            /*!< [26..23] Counter/Timer B3 Trigger Select.                                 */
      __IOM uint32_t TMRB3NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB3TINV  : 1;            /*!< [28..28] Counter/Timer B3 Invert on trigger.                              */
      __IOM uint32_t TMRB3POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB3EN23  : 1;            /*!< [30..30] Counter/Timer B3 Upper compare enable.                           */
            uint32_t            : 1;
    } AUX3_b;
  } ;

  union {
    __IOM uint32_t TMR4;                        /*!< (@ 0x00000080) This register holds the running time or event
                                                                    count, either for each 16 bit half or for
                                                                    the whole 32 bit count when the pair is
                                                                    linked.                                                    */

    struct {
      __IOM uint32_t CTTMRA4    : 16;           /*!< [15..0] Counter/Timer A4.                                                 */
      __IOM uint32_t CTTMRB4    : 16;           /*!< [31..16] Counter/Timer B4.                                                */
    } TMR4_b;
  } ;

  union {
    __IOM uint32_t CMPRA4;                      /*!< (@ 0x00000084) Compare limits for timer half A.                           */

    struct {
      __IOM uint32_t CMPR0A4    : 16;           /*!< [15..0] Counter/Timer A4 Compare Register 0. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR1A4    : 16;           /*!< [31..16] Counter/Timer A4 Compare Register 1. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRA4_b;
  } ;

  union {
    __IOM uint32_t CMPRB4;                      /*!< (@ 0x00000088) Compare limits for timer half B.                           */

    struct {
      __IOM uint32_t CMPR0B4    : 16;           /*!< [15..0] Counter/Timer B4 Compare Register 0. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR1B4    : 16;           /*!< [31..16] Counter/Timer B4 Compare Register 1. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRB4_b;
  } ;

  union {
    __IOM uint32_t CTRL4;                       /*!< (@ 0x0000008C) Control bit fields for both halves of timer 4.             */

    struct {
      __IOM uint32_t TMRA4EN    : 1;            /*!< [0..0] Counter/Timer A4 Enable bit.                                       */
      __IOM uint32_t TMRA4CLK   : 5;            /*!< [5..1] Counter/Timer A4 Clock Select.                                     */
      __IOM uint32_t TMRA4FN    : 3;            /*!< [8..6] Counter/Timer A4 Function Select.                                  */
      __IOM uint32_t TMRA4IE0   : 1;            /*!< [9..9] Counter/Timer A4 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA4IE1   : 1;            /*!< [10..10] Counter/Timer A4 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA4CLR   : 1;            /*!< [11..11] Counter/Timer A4 Clear bit.                                      */
      __IOM uint32_t TMRA4POL   : 1;            /*!< [12..12] Counter/Timer A4 output polarity.                                */
            uint32_t            : 3;
      __IOM uint32_t TMRB4EN    : 1;            /*!< [16..16] Counter/Timer B4 Enable bit.                                     */
      __IOM uint32_t TMRB4CLK   : 5;            /*!< [21..17] Counter/Timer B4 Clock Select.                                   */
      __IOM uint32_t TMRB4FN    : 3;            /*!< [24..22] Counter/Timer B4 Function Select.                                */
      __IOM uint32_t TMRB4IE0   : 1;            /*!< [25..25] Counter/Timer B4 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB4IE1   : 1;            /*!< [26..26] Counter/Timer B4 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB4CLR   : 1;            /*!< [27..27] Counter/Timer B4 Clear bit.                                      */
      __IOM uint32_t TMRB4POL   : 1;            /*!< [28..28] Counter/Timer B4 output polarity.                                */
            uint32_t            : 2;
      __IOM uint32_t CTLINK4    : 1;            /*!< [31..31] Counter/Timer A4/B4 Link bit.                                    */
    } CTRL4_b;
  } ;
  __IM  uint32_t  RESERVED4;

  union {
    __IOM uint32_t CMPRAUXA4;                   /*!< (@ 0x00000094) Enhanced compare limits for timer half A.                  */

    struct {
      __IOM uint32_t CMPR2A4    : 16;           /*!< [15..0] Counter/Timer A4 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A4    : 16;           /*!< [31..16] Counter/Timer A4 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA4_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB4;                   /*!< (@ 0x00000098) Enhanced compare limits for timer half B.                  */

    struct {
      __IOM uint32_t CMPR2B4    : 16;           /*!< [15..0] Counter/Timer B4 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B4    : 16;           /*!< [31..16] Counter/Timer B4 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB4_b;
  } ;

  union {
    __IOM uint32_t AUX4;                        /*!< (@ 0x0000009C) Control bit fields for both halves of timer 4.             */

    struct {
      __IOM uint32_t TMRA4LMT   : 7;            /*!< [6..0] Counter/Timer A4 Pattern Limit Count.                              */
      __IOM uint32_t TMRA4TRIG  : 4;            /*!< [10..7] Counter/Timer A4 Trigger Select.                                  */
      __IOM uint32_t TMRA4NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA4TINV  : 1;            /*!< [12..12] Counter/Timer A4 Invert on trigger.                              */
      __IOM uint32_t TMRA4POL23 : 1;            /*!< [13..13] Counter/Timer A4 Upper output polarity                           */
      __IOM uint32_t TMRA4EN23  : 1;            /*!< [14..14] Counter/Timer A4 Upper compare enable.                           */
            uint32_t            : 1;
      __IOM uint32_t TMRB4LMT   : 6;            /*!< [21..16] Counter/Timer B4 Pattern Limit Count.                            */
            uint32_t            : 1;
      __IOM uint32_t TMRB4TRIG  : 4;            /*!< [26..23] Counter/Timer B4 Trigger Select.                                 */
      __IOM uint32_t TMRB4NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB4TINV  : 1;            /*!< [28..28] Counter/Timer B4 Invert on trigger.                              */
      __IOM uint32_t TMRB4POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB4EN23  : 1;            /*!< [30..30] Counter/Timer B4 Upper compare enable.                           */
            uint32_t            : 1;
    } AUX4_b;
  } ;

  union {
    __IOM uint32_t TMR5;                        /*!< (@ 0x000000A0) This register holds the running time or event
                                                                    count, either for each 16 bit half or for
                                                                    the whole 32 bit count when the pair is
                                                                    linked.                                                    */

    struct {
      __IOM uint32_t CTTMRA5    : 16;           /*!< [15..0] Counter/Timer A5.                                                 */
      __IOM uint32_t CTTMRB5    : 16;           /*!< [31..16] Counter/Timer B5.                                                */
    } TMR5_b;
  } ;

  union {
    __IOM uint32_t CMPRA5;                      /*!< (@ 0x000000A4) This register holds the compare limits for timer
                                                                    half A.                                                    */

    struct {
      __IOM uint32_t CMPR0A5    : 16;           /*!< [15..0] Counter/Timer A5 Compare Register 0.                              */
      __IOM uint32_t CMPR1A5    : 16;           /*!< [31..16] Counter/Timer A5 Compare Register 1.                             */
    } CMPRA5_b;
  } ;

  union {
    __IOM uint32_t CMPRB5;                      /*!< (@ 0x000000A8) This register holds the compare limits for timer
                                                                    half B.                                                    */

    struct {
      __IOM uint32_t CMPR0B5    : 16;           /*!< [15..0] Counter/Timer B5 Compare Register 0.                              */
      __IOM uint32_t CMPR1B5    : 16;           /*!< [31..16] Counter/Timer B5 Compare Register 1.                             */
    } CMPRB5_b;
  } ;

  union {
    __IOM uint32_t CTRL5;                       /*!< (@ 0x000000AC) Control bit fields for both halves of timer 0.             */

    struct {
      __IOM uint32_t TMRA5EN    : 1;            /*!< [0..0] Counter/Timer A5 Enable bit.                                       */
      __IOM uint32_t TMRA5CLK   : 5;            /*!< [5..1] Counter/Timer A5 Clock Select.                                     */
      __IOM uint32_t TMRA5FN    : 3;            /*!< [8..6] Counter/Timer A5 Function Select.                                  */
      __IOM uint32_t TMRA5IE0   : 1;            /*!< [9..9] Counter/Timer A5 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA5IE1   : 1;            /*!< [10..10] Counter/Timer A5 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA5CLR   : 1;            /*!< [11..11] Counter/Timer A5 Clear bit.                                      */
      __IOM uint32_t TMRA5POL   : 1;            /*!< [12..12] Counter/Timer A5 output polarity.                                */
            uint32_t            : 3;
      __IOM uint32_t TMRB5EN    : 1;            /*!< [16..16] Counter/Timer B5 Enable bit.                                     */
      __IOM uint32_t TMRB5CLK   : 5;            /*!< [21..17] Counter/Timer B5 Clock Select.                                   */
      __IOM uint32_t TMRB5FN    : 3;            /*!< [24..22] Counter/Timer B5 Function Select.                                */
      __IOM uint32_t TMRB5IE0   : 1;            /*!< [25..25] Counter/Timer B5 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB5IE1   : 1;            /*!< [26..26] Counter/Timer B5 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB5CLR   : 1;            /*!< [27..27] Counter/Timer B5 Clear bit.                                      */
      __IOM uint32_t TMRB5POL   : 1;            /*!< [28..28] Counter/Timer B5 output polarity.                                */
            uint32_t            : 2;
      __IOM uint32_t CTLINK5    : 1;            /*!< [31..31] Counter/Timer A5/B5 Link bit.                                    */
    } CTRL5_b;
  } ;
  __IM  uint32_t  RESERVED5;

  union {
    __IOM uint32_t CMPRAUXA5;                   /*!< (@ 0x000000B4) Enhanced compare limits for timer half A.                  */

    struct {
      __IOM uint32_t CMPR2A5    : 16;           /*!< [15..0] Counter/Timer A5 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A5    : 16;           /*!< [31..16] Counter/Timer A5 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA5_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB5;                   /*!< (@ 0x000000B8) Enhanced compare limits for timer half B.                  */

    struct {
      __IOM uint32_t CMPR2B5    : 16;           /*!< [15..0] Counter/Timer B5 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B5    : 16;           /*!< [31..16] Counter/Timer B5 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB5_b;
  } ;

  union {
    __IOM uint32_t AUX5;                        /*!< (@ 0x000000BC) Control bit fields for both halves of timer 0.             */

    struct {
      __IOM uint32_t TMRA5LMT   : 7;            /*!< [6..0] Counter/Timer A5 Pattern Limit Count.                              */
      __IOM uint32_t TMRA5TRIG  : 4;            /*!< [10..7] Counter/Timer A5 Trigger Select.                                  */
      __IOM uint32_t TMRA5NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA5TINV  : 1;            /*!< [12..12] Counter/Timer A5 Invert on trigger.                              */
      __IOM uint32_t TMRA5POL23 : 1;            /*!< [13..13] Counter/Timer A5 Upper output polarity                           */
      __IOM uint32_t TMRA5EN23  : 1;            /*!< [14..14] Counter/Timer A5 Upper compare enable.                           */
            uint32_t            : 1;
      __IOM uint32_t TMRB5LMT   : 6;            /*!< [21..16] Counter/Timer B5 Pattern Limit Count.                            */
            uint32_t            : 1;
      __IOM uint32_t TMRB5TRIG  : 4;            /*!< [26..23] Counter/Timer B5 Trigger Select.                                 */
      __IOM uint32_t TMRB5NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB5TINV  : 1;            /*!< [28..28] Counter/Timer B5 Invert on trigger.                              */
      __IOM uint32_t TMRB5POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB5EN23  : 1;            /*!< [30..30] Counter/Timer B5 Upper compare enable.                           */
            uint32_t            : 1;
    } AUX5_b;
  } ;

  union {
    __IOM uint32_t TMR6;                        /*!< (@ 0x000000C0) Counter/Timer 6                                            */

    struct {
      __IOM uint32_t CTTMRA6    : 16;           /*!< [15..0] Counter/Timer A6.                                                 */
      __IOM uint32_t CTTMRB6    : 16;           /*!< [31..16] Counter/Timer B6.                                                */
    } TMR6_b;
  } ;

  union {
    __IOM uint32_t CMPRA6;                      /*!< (@ 0x000000C4) This register holds the compare limits for timer
                                                                    half A.                                                    */

    struct {
      __IOM uint32_t CMPR0A6    : 16;           /*!< [15..0] Counter/Timer A6 Compare Register 0.                              */
      __IOM uint32_t CMPR1A6    : 16;           /*!< [31..16] Counter/Timer A6 Compare Register 1.                             */
    } CMPRA6_b;
  } ;

  union {
    __IOM uint32_t CMPRB6;                      /*!< (@ 0x000000C8) This register holds the compare limits for timer
                                                                    half B.                                                    */

    struct {
      __IOM uint32_t CMPR0B6    : 16;           /*!< [15..0] Counter/Timer B6 Compare Register 0.                              */
      __IOM uint32_t CMPR1B6    : 16;           /*!< [31..16] Counter/Timer B6 Compare Register 1.                             */
    } CMPRB6_b;
  } ;

  union {
    __IOM uint32_t CTRL6;                       /*!< (@ 0x000000CC) This register holds the control bit fields for
                                                                    both halves of timer 6.                                    */

    struct {
      __IOM uint32_t TMRA6EN    : 1;            /*!< [0..0] Counter/Timer A6 Enable bit.                                       */
      __IOM uint32_t TMRA6CLK   : 5;            /*!< [5..1] Counter/Timer A6 Clock Select.                                     */
      __IOM uint32_t TMRA6FN    : 3;            /*!< [8..6] Counter/Timer A6 Function Select.                                  */
      __IOM uint32_t TMRA6IE0   : 1;            /*!< [9..9] Counter/Timer A6 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA6IE1   : 1;            /*!< [10..10] Counter/Timer A6 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA6CLR   : 1;            /*!< [11..11] Counter/Timer A6 Clear bit.                                      */
      __IOM uint32_t TMRA6POL   : 1;            /*!< [12..12] Counter/Timer A6 output polarity.                                */
            uint32_t            : 3;
      __IOM uint32_t TMRB6EN    : 1;            /*!< [16..16] Counter/Timer B6 Enable bit.                                     */
      __IOM uint32_t TMRB6CLK   : 5;            /*!< [21..17] Counter/Timer B6 Clock Select.                                   */
      __IOM uint32_t TMRB6FN    : 3;            /*!< [24..22] Counter/Timer B6 Function Select.                                */
      __IOM uint32_t TMRB6IE0   : 1;            /*!< [25..25] Counter/Timer B6 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB6IE1   : 1;            /*!< [26..26] Counter/Timer B6 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB6CLR   : 1;            /*!< [27..27] Counter/Timer B6 Clear bit.                                      */
      __IOM uint32_t TMRB6POL   : 1;            /*!< [28..28] Counter/Timer B6 output polarity.                                */
            uint32_t            : 2;
      __IOM uint32_t CTLINK6    : 1;            /*!< [31..31] Counter/Timer A6/B6 Link bit.                                    */
    } CTRL6_b;
  } ;
  __IM  uint32_t  RESERVED6;

  union {
    __IOM uint32_t CMPRAUXA6;                   /*!< (@ 0x000000D4) Enhanced compare limits for timer half A.                  */

    struct {
      __IOM uint32_t CMPR2A6    : 16;           /*!< [15..0] Counter/Timer A6 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A6    : 16;           /*!< [31..16] Counter/Timer A6 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA6_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB6;                   /*!< (@ 0x000000D8) Enhanced compare limits for timer half B.                  */

    struct {
      __IOM uint32_t CMPR2B6    : 16;           /*!< [15..0] Counter/Timer B6 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B6    : 16;           /*!< [31..16] Counter/Timer B6 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB6_b;
  } ;

  union {
    __IOM uint32_t AUX6;                        /*!< (@ 0x000000DC) Control bit fields for both halves of timer 0.             */

    struct {
      __IOM uint32_t TMRA6LMT   : 7;            /*!< [6..0] Counter/Timer A6 Pattern Limit Count.                              */
      __IOM uint32_t TMRA6TRIG  : 4;            /*!< [10..7] Counter/Timer A6 Trigger Select.                                  */
      __IOM uint32_t TMRA6NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA6TINV  : 1;            /*!< [12..12] Counter/Timer A6 Invert on trigger.                              */
      __IOM uint32_t TMRA6POL23 : 1;            /*!< [13..13] Counter/Timer A6 Upper output polarity                           */
      __IOM uint32_t TMRA6EN23  : 1;            /*!< [14..14] Counter/Timer A6 Upper compare enable.                           */
            uint32_t            : 1;
      __IOM uint32_t TMRB6LMT   : 6;            /*!< [21..16] Counter/Timer B6 Pattern Limit Count.                            */
            uint32_t            : 1;
      __IOM uint32_t TMRB6TRIG  : 4;            /*!< [26..23] Counter/Timer B6 Trigger Select.                                 */
      __IOM uint32_t TMRB6NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB6TINV  : 1;            /*!< [28..28] Counter/Timer B6 Invert on trigger.                              */
      __IOM uint32_t TMRB6POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB6EN23  : 1;            /*!< [30..30] Counter/Timer B6 Upper compare enable.                           */
            uint32_t            : 1;
    } AUX6_b;
  } ;

  union {
    __IOM uint32_t TMR7;                        /*!< (@ 0x000000E0) Counter/Timer 7                                            */

    struct {
      __IOM uint32_t CTTMRA7    : 16;           /*!< [15..0] Counter/Timer A7.                                                 */
      __IOM uint32_t CTTMRB7    : 16;           /*!< [31..16] Counter/Timer B7.                                                */
    } TMR7_b;
  } ;

  union {
    __IOM uint32_t CMPRA7;                      /*!< (@ 0x000000E4) This register holds the compare limits for timer
                                                                    half A.                                                    */

    struct {
      __IOM uint32_t CMPR0A7    : 16;           /*!< [15..0] Counter/Timer A7 Compare Register 0.                              */
      __IOM uint32_t CMPR1A7    : 16;           /*!< [31..16] Counter/Timer A7 Compare Register 1.                             */
    } CMPRA7_b;
  } ;

  union {
    __IOM uint32_t CMPRB7;                      /*!< (@ 0x000000E8) This register holds the compare limits for timer
                                                                    half B.                                                    */

    struct {
      __IOM uint32_t CMPR0B7    : 16;           /*!< [15..0] Counter/Timer B3 Compare Register 0.                              */
      __IOM uint32_t CMPR1B7    : 16;           /*!< [31..16] Counter/Timer B3 Compare Register 1.                             */
    } CMPRB7_b;
  } ;

  union {
    __IOM uint32_t CTRL7;                       /*!< (@ 0x000000EC) This register holds the control bit fields for
                                                                    both halves of timer 7.                                    */

    struct {
      __IOM uint32_t TMRA7EN    : 1;            /*!< [0..0] Counter/Timer A7 Enable bit.                                       */
      __IOM uint32_t TMRA7CLK   : 5;            /*!< [5..1] Counter/Timer A7 Clock Select.                                     */
      __IOM uint32_t TMRA7FN    : 3;            /*!< [8..6] Counter/Timer A7 Function Select.                                  */
      __IOM uint32_t TMRA7IE0   : 1;            /*!< [9..9] Counter/Timer A7 Interrupt Enable bit based on COMPR0.             */
      __IOM uint32_t TMRA7IE1   : 1;            /*!< [10..10] Counter/Timer A7 Interrupt Enable bit based on COMPR1.           */
      __IOM uint32_t TMRA7CLR   : 1;            /*!< [11..11] Counter/Timer A7 Clear bit.                                      */
      __IOM uint32_t TMRA7POL   : 1;            /*!< [12..12] Counter/Timer A7 output polarity.                                */
            uint32_t            : 3;
      __IOM uint32_t TMRB7EN    : 1;            /*!< [16..16] Counter/Timer B7 Enable bit.                                     */
      __IOM uint32_t TMRB7CLK   : 5;            /*!< [21..17] Counter/Timer B7 Clock Select.                                   */
      __IOM uint32_t TMRB7FN    : 3;            /*!< [24..22] Counter/Timer B7 Function Select.                                */
      __IOM uint32_t TMRB7IE0   : 1;            /*!< [25..25] Counter/Timer B7 Interrupt Enable bit for COMPR0.                */
      __IOM uint32_t TMRB7IE1   : 1;            /*!< [26..26] Counter/Timer B7 Interrupt Enable bit for COMPR1.                */
      __IOM uint32_t TMRB7CLR   : 1;            /*!< [27..27] Counter/Timer B7 Clear bit.                                      */
      __IOM uint32_t TMRB7POL   : 1;            /*!< [28..28] Counter/Timer B7 output polarity.                                */
            uint32_t            : 2;
      __IOM uint32_t CTLINK7    : 1;            /*!< [31..31] Counter/Timer A7/B7 Link bit.                                    */
    } CTRL7_b;
  } ;
  __IM  uint32_t  RESERVED7;

  union {
    __IOM uint32_t CMPRAUXA7;                   /*!< (@ 0x000000F4) Enhanced compare limits for timer half A.                  */

    struct {
      __IOM uint32_t CMPR2A7    : 16;           /*!< [15..0] Counter/Timer A7 Compare Register 2. Holds the lower
                                                     limit for timer half A.                                                   */
      __IOM uint32_t CMPR3A7    : 16;           /*!< [31..16] Counter/Timer A7 Compare Register 3. Holds the upper
                                                     limit for timer half A.                                                   */
    } CMPRAUXA7_b;
  } ;

  union {
    __IOM uint32_t CMPRAUXB7;                   /*!< (@ 0x000000F8) Enhanced compare limits for timer half B.                  */

    struct {
      __IOM uint32_t CMPR2B7    : 16;           /*!< [15..0] Counter/Timer B7 Compare Register 2. Holds the lower
                                                     limit for timer half B.                                                   */
      __IOM uint32_t CMPR3B7    : 16;           /*!< [31..16] Counter/Timer B7 Compare Register 3. Holds the upper
                                                     limit for timer half B.                                                   */
    } CMPRAUXB7_b;
  } ;

  union {
    __IOM uint32_t AUX7;                        /*!< (@ 0x000000FC) Control bit fields for both halves of timer 0.             */

    struct {
      __IOM uint32_t TMRA7LMT   : 7;            /*!< [6..0] Counter/Timer A7 Pattern Limit Count.                              */
      __IOM uint32_t TMRA7TRIG  : 4;            /*!< [10..7] Counter/Timer A7 Trigger Select.                                  */
      __IOM uint32_t TMRA7NOSYNC : 1;           /*!< [11..11] Source clock synchronization control.                            */
      __IOM uint32_t TMRA7TINV  : 1;            /*!< [12..12] Counter/Timer A7 Invert on trigger.                              */
      __IOM uint32_t TMRA7POL23 : 1;            /*!< [13..13] Counter/Timer A7 Upper output polarity                           */
      __IOM uint32_t TMRA7EN23  : 1;            /*!< [14..14] Counter/Timer A7 Upper compare enable.                           */
            uint32_t            : 1;
      __IOM uint32_t TMRB7LMT   : 6;            /*!< [21..16] Counter/Timer B7 Pattern Limit Count.                            */
            uint32_t            : 1;
      __IOM uint32_t TMRB7TRIG  : 4;            /*!< [26..23] Counter/Timer B7 Trigger Select.                                 */
      __IOM uint32_t TMRB7NOSYNC : 1;           /*!< [27..27] Source clock synchronization control.                            */
      __IOM uint32_t TMRB7TINV  : 1;            /*!< [28..28] Counter/Timer B7 Invert on trigger.                              */
      __IOM uint32_t TMRB7POL23 : 1;            /*!< [29..29] Upper output polarity                                            */
      __IOM uint32_t TMRB7EN23  : 1;            /*!< [30..30] Counter/Timer B7 Upper compare enable.                           */
            uint32_t            : 1;
    } AUX7_b;
  } ;

  union {
    __IOM uint32_t GLOBEN;                      /*!< (@ 0x00000100) Alternate enables for all CTIMERs.                         */

    struct {
      __IOM uint32_t ENA0       : 1;            /*!< [0..0] Alternate enable for A0                                            */
      __IOM uint32_t ENB0       : 1;            /*!< [1..1] Alternate enable for B0                                            */
      __IOM uint32_t ENA1       : 1;            /*!< [2..2] Alternate enable for A1                                            */
      __IOM uint32_t ENB1       : 1;            /*!< [3..3] Alternate enable for B1                                            */
      __IOM uint32_t ENA2       : 1;            /*!< [4..4] Alternate enable for A2                                            */
      __IOM uint32_t ENB2       : 1;            /*!< [5..5] Alternate enable for B2                                            */
      __IOM uint32_t ENA3       : 1;            /*!< [6..6] Alternate enable for A3                                            */
      __IOM uint32_t ENB3       : 1;            /*!< [7..7] Alternate enable for B3.                                           */
      __IOM uint32_t ENA4       : 1;            /*!< [8..8] Alternate enable for A4                                            */
      __IOM uint32_t ENB4       : 1;            /*!< [9..9] Alternate enable for B4                                            */
      __IOM uint32_t ENA5       : 1;            /*!< [10..10] Alternate enable for A5                                          */
      __IOM uint32_t ENB5       : 1;            /*!< [11..11] Alternate enable for B5                                          */
      __IOM uint32_t ENA6       : 1;            /*!< [12..12] Alternate enable for A6                                          */
      __IOM uint32_t ENB6       : 1;            /*!< [13..13] Alternate enable for B6                                          */
      __IOM uint32_t ENA7       : 1;            /*!< [14..14] Alternate enable for A7                                          */
      __IOM uint32_t ENB7       : 1;            /*!< [15..15] Alternate enable for B7.                                         */
            uint32_t            : 16;
    } GLOBEN_b;
  } ;

  union {
    __IOM uint32_t OUTCFG0;                     /*!< (@ 0x00000104) Pad output configuration 0.                                */

    struct {
      __IOM uint32_t CFG0       : 3;            /*!< [2..0] Pad output 0 configuration                                         */
      __IOM uint32_t CFG1       : 3;            /*!< [5..3] Pad output 1 configuration                                         */
      __IOM uint32_t CFG2       : 3;            /*!< [8..6] Pad output 2 configuration                                         */
      __IOM uint32_t CFG3       : 3;            /*!< [11..9] Pad output 3 configuration                                        */
      __IOM uint32_t CFG4       : 3;            /*!< [14..12] Pad output 4 configuration                                       */
            uint32_t            : 1;
      __IOM uint32_t CFG5       : 3;            /*!< [18..16] Pad output 5 configuration                                       */
      __IOM uint32_t CFG6       : 3;            /*!< [21..19] Pad output 6 configuration                                       */
      __IOM uint32_t CFG7       : 3;            /*!< [24..22] Pad output 7 configuration                                       */
      __IOM uint32_t CFG8       : 3;            /*!< [27..25] Pad output 8 configuration                                       */
      __IOM uint32_t CFG9       : 3;            /*!< [30..28] Pad output 9 configuration                                       */
            uint32_t            : 1;
    } OUTCFG0_b;
  } ;

  union {
    __IOM uint32_t OUTCFG1;                     /*!< (@ 0x00000108) Pad output configuration 1.                                */

    struct {
      __IOM uint32_t CFG10      : 3;            /*!< [2..0] Pad output 10 configuration                                        */
      __IOM uint32_t CFG11      : 3;            /*!< [5..3] Pad output 11 configuration                                        */
      __IOM uint32_t CFG12      : 3;            /*!< [8..6] Pad output 12 configuration                                        */
      __IOM uint32_t CFG13      : 3;            /*!< [11..9] Pad output 13 configuration                                       */
      __IOM uint32_t CFG14      : 3;            /*!< [14..12] Pad output 14 configuration                                      */
            uint32_t            : 1;
      __IOM uint32_t CFG15      : 3;            /*!< [18..16] Pad output 15 configuration                                      */
      __IOM uint32_t CFG16      : 3;            /*!< [21..19] Pad output 16 configuration                                      */
      __IOM uint32_t CFG17      : 3;            /*!< [24..22] Pad output 17 configuration                                      */
      __IOM uint32_t CFG18      : 3;            /*!< [27..25] Pad output 18 configuration                                      */
      __IOM uint32_t CFG19      : 3;            /*!< [30..28] Pad output 19 configuration                                      */
            uint32_t            : 1;
    } OUTCFG1_b;
  } ;

  union {
    __IOM uint32_t OUTCFG2;                     /*!< (@ 0x0000010C) Pad output configuration 2.                                */

    struct {
      __IOM uint32_t CFG20      : 3;            /*!< [2..0] Pad output 20 configuration                                        */
      __IOM uint32_t CFG21      : 3;            /*!< [5..3] Pad output 21 configuration                                        */
      __IOM uint32_t CFG22      : 3;            /*!< [8..6] Pad output 22 configuration                                        */
      __IOM uint32_t CFG23      : 3;            /*!< [11..9] Pad output 23 configuration                                       */
      __IOM uint32_t CFG24      : 3;            /*!< [14..12] Pad output 24 configuration                                      */
            uint32_t            : 1;
      __IOM uint32_t CFG25      : 3;            /*!< [18..16] Pad output 25 configuration                                      */
      __IOM uint32_t CFG26      : 3;            /*!< [21..19] Pad output 26 configuration                                      */
      __IOM uint32_t CFG27      : 3;            /*!< [24..22] Pad output 27 configuration                                      */
      __IOM uint32_t CFG28      : 3;            /*!< [27..25] Pad output 28 configuration                                      */
      __IOM uint32_t CFG29      : 3;            /*!< [30..28] Pad output 29 configuration                                      */
            uint32_t            : 1;
    } OUTCFG2_b;
  } ;
  __IM  uint32_t  RESERVED8;

  union {
    __IOM uint32_t OUTCFG3;                     /*!< (@ 0x00000114) Pad output configuration 3.                                */

    struct {
      __IOM uint32_t CFG30      : 3;            /*!< [2..0] Pad output 30 configuration                                        */
      __IOM uint32_t CFG31      : 3;            /*!< [5..3] Pad output 31 configuration                                        */
            uint32_t            : 26;
    } OUTCFG3_b;
  } ;

  union {
    __IOM uint32_t INCFG;                       /*!< (@ 0x00000118) Pad input configuration.                                   */

    struct {
      __IOM uint32_t CFGA0      : 1;            /*!< [0..0] CTIMER A0 input configuration                                      */
      __IOM uint32_t CFGB0      : 1;            /*!< [1..1] CTIMER B0 input configuration                                      */
      __IOM uint32_t CFGA1      : 1;            /*!< [2..2] CTIMER A1 input configuration                                      */
      __IOM uint32_t CFGB1      : 1;            /*!< [3..3] CTIMER B1 input configuration                                      */
      __IOM uint32_t CFGA2      : 1;            /*!< [4..4] CTIMER A2 input configuration                                      */
      __IOM uint32_t CFGB2      : 1;            /*!< [5..5] CTIMER B2 input configuration                                      */
      __IOM uint32_t CFGA3      : 1;            /*!< [6..6] CTIMER A3 input configuration                                      */
      __IOM uint32_t CFGB3      : 1;            /*!< [7..7] CTIMER B3 input configuration                                      */
      __IOM uint32_t CFGA4      : 1;            /*!< [8..8] CTIMER A4 input configuration                                      */
      __IOM uint32_t CFGB4      : 1;            /*!< [9..9] CTIMER B4 input configuration                                      */
      __IOM uint32_t CFGA5      : 1;            /*!< [10..10] CTIMER A5 input configuration                                    */
      __IOM uint32_t CFGB5      : 1;            /*!< [11..11] CTIMER B5 input configuration                                    */
      __IOM uint32_t CFGA6      : 1;            /*!< [12..12] CTIMER A6 input configuration                                    */
      __IOM uint32_t CFGB6      : 1;            /*!< [13..13] CTIMER B6 input configuration                                    */
      __IOM uint32_t CFGA7      : 1;            /*!< [14..14] CTIMER A7 input configuration                                    */
      __IOM uint32_t CFGB7      : 1;            /*!< [15..15] CTIMER B7 input configuration                                    */
            uint32_t            : 16;
    } INCFG_b;
  } ;
  __IM  uint32_t  RESERVED9[9];

  union {
    __IOM uint32_t STCFG;                       /*!< (@ 0x00000140) The STIMER Configuration Register contains the
                                                                    software control for selecting the clock
                                                                    divider and source feeding the system timer.               */

    struct {
      __IOM uint32_t CLKSEL     : 4;            /*!< [3..0] Selects an appropriate clock source and divider to use
                                                     for the System Timer clock.                                               */
            uint32_t            : 4;
      __IOM uint32_t COMPARE_A_EN : 1;          /*!< [8..8] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparison is met.                                        */
      __IOM uint32_t COMPARE_B_EN : 1;          /*!< [9..9] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparison is met.                                        */
      __IOM uint32_t COMPARE_C_EN : 1;          /*!< [10..10] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparison is met.                                        */
      __IOM uint32_t COMPARE_D_EN : 1;          /*!< [11..11] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparison is met.                                        */
      __IOM uint32_t COMPARE_E_EN : 1;          /*!< [12..12] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparison is met.                                        */
      __IOM uint32_t COMPARE_F_EN : 1;          /*!< [13..13] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparison is met.                                        */
      __IOM uint32_t COMPARE_G_EN : 1;          /*!< [14..14] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparison is met.                                        */
      __IOM uint32_t COMPARE_H_EN : 1;          /*!< [15..15] Selects whether compare is enabled for the corresponding
                                                     SCMPR register. If compare is enabled, the interrupt status
                                                     is set once the comparison is met.                                        */
            uint32_t            : 14;
      __IOM uint32_t CLEAR      : 1;            /*!< [30..30] Set this bit to one to clear the System Timer register.
                                                     If this bit is set to '1', the system timer register will
                                                     stay cleared. It needs to be set to '0' for the system
                                                     timer to start running.                                                   */
      __IOM uint32_t FREEZE     : 1;            /*!< [31..31] Set this bit to one to freeze the clock input to the
                                                     COUNTER register. Once frozen, the value can be safely
                                                     written from the MCU. Unfreeze to resume.                                 */
    } STCFG_b;
  } ;

  union {
    __IOM uint32_t STTMR;                       /*!< (@ 0x00000144) The COUNTER Register contains the running count
                                                                    of time as maintained by incrementing for
                                                                    every rising clock edge of the clock source
                                                                    selected in the configuration register.
                                                                    It is this counter value that captured in
                                                                    the capture registers and it is this counter
                                                                    value that is compared against the various
                                                                    compare registers. This register cannot
                                                                    be written, but can be cleared to 0 for
                                                                    a deterministic value. Use the FREEZE bit
                                                                    will stop this counter from incrementing.                  */

    struct {
      __IOM uint32_t STTMR      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } STTMR_b;
  } ;

  union {
    __IOM uint32_t CAPTURECONTROL;              /*!< (@ 0x00000148) The STIMER Capture Control Register controls
                                                                    each of the 4 capture registers. It selects
                                                                    their GPIO pin number for a trigger source,
                                                                    enables a capture operation and sets the
                                                                    input polarity for the capture. NOTE: 8-bit
                                                                    writes can control individual capture registers
                                                                    atomically.                                                */

    struct {
      __IOM uint32_t CAPTURE0   : 1;            /*!< [0..0] Selects whether capture is enabled for the specified
                                                     capture register.                                                         */
      __IOM uint32_t CAPTURE1   : 1;            /*!< [1..1] Selects whether capture is enabled for the specified
                                                     capture register.                                                         */
      __IOM uint32_t CAPTURE2   : 1;            /*!< [2..2] Selects whether capture is enabled for the specified
                                                     capture register.                                                         */
      __IOM uint32_t CAPTURE3   : 1;            /*!< [3..3] Selects whether capture is enabled for the specified
                                                     capture register.                                                         */
            uint32_t            : 28;
    } CAPTURECONTROL_b;
  } ;
  __IM  uint32_t  RESERVED10;

  union {
    __IOM uint32_t SCMPR0;                      /*!< (@ 0x00000150) The VALUE in this bit field is used to compare
                                                                    against the VALUE in the COUNTER register.
                                                                    If the match criterion in the configuration
                                                                    register is met then a corresponding interrupt
                                                                    status bit is set. The match criterion is
                                                                    defined as COUNTER equal to COMPARE. To
                                                                    establish a desired value in this COMPARE
                                                                    register, write the number of ticks in the
                                                                    future to this register to indicate when
                                                                    to interrupt. The hardware does the addition
                                                                    to the COUNTER value in the STIMER clock
                                                                    domain so that the ma                                      */

    struct {
      __IOM uint32_t SCMPR0     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_A_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR0_b;
  } ;

  union {
    __IOM uint32_t SCMPR1;                      /*!< (@ 0x00000154) The VALUE in this bit field is used to compare
                                                                    against the VALUE in the COUNTER register.
                                                                    If the match criterion in the configuration
                                                                    register is met then a corresponding interrupt
                                                                    status bit is set. The match criterion is
                                                                    defined as COUNTER equal to COMPARE. To
                                                                    establish a desired value in this COMPARE
                                                                    register, write the number of ticks in the
                                                                    future to this register to indicate when
                                                                    to interrupt. The hardware does the addition
                                                                    to the COUNTER value in the STIMER clock
                                                                    domain so that the ma                                      */

    struct {
      __IOM uint32_t SCMPR1     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_B_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR1_b;
  } ;

  union {
    __IOM uint32_t SCMPR2;                      /*!< (@ 0x00000158) The VALUE in this bit field is used to compare
                                                                    against the VALUE in the COUNTER register.
                                                                    If the match criterion in the configuration
                                                                    register is met then a corresponding interrupt
                                                                    status bit is set. The match criterion is
                                                                    defined as COUNTER equal to COMPARE. To
                                                                    establish a desired value in this COMPARE
                                                                    register, write the number of ticks in the
                                                                    future to this register to indicate when
                                                                    to interrupt. The hardware does the addition
                                                                    to the COUNTER value in the STIMER clock
                                                                    domain so that the ma                                      */

    struct {
      __IOM uint32_t SCMPR2     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_C_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR2_b;
  } ;

  union {
    __IOM uint32_t SCMPR3;                      /*!< (@ 0x0000015C) The VALUE in this bit field is used to compare
                                                                    against the VALUE in the COUNTER register.
                                                                    If the match criterion in the configuration
                                                                    register is met then a corresponding interrupt
                                                                    status bit is set. The match criterion is
                                                                    defined as COUNTER equal to COMPARE. To
                                                                    establish a desired value in this COMPARE
                                                                    register, write the number of ticks in the
                                                                    future to this register to indicate when
                                                                    to interrupt. The hardware does the addition
                                                                    to the COUNTER value in the STIMER clock
                                                                    domain so that the ma                                      */

    struct {
      __IOM uint32_t SCMPR3     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_D_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR3_b;
  } ;

  union {
    __IOM uint32_t SCMPR4;                      /*!< (@ 0x00000160) The VALUE in this bit field is used to compare
                                                                    against the VALUE in the COUNTER register.
                                                                    If the match criterion in the configuration
                                                                    register is met then a corresponding interrupt
                                                                    status bit is set. The match criterion is
                                                                    defined as COUNTER equal to COMPARE. To
                                                                    establish a desired value in this COMPARE
                                                                    register, write the number of ticks in the
                                                                    future to this register to indicate when
                                                                    to interrupt. The hardware does the addition
                                                                    to the COUNTER value in the STIMER clock
                                                                    domain so that the ma                                      */

    struct {
      __IOM uint32_t SCMPR4     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_E_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR4_b;
  } ;

  union {
    __IOM uint32_t SCMPR5;                      /*!< (@ 0x00000164) The VALUE in this bit field is used to compare
                                                                    against the VALUE in the COUNTER register.
                                                                    If the match criterion in the configuration
                                                                    register is met then a corresponding interrupt
                                                                    status bit is set. The match criterion is
                                                                    defined as COUNTER equal to COMPARE. To
                                                                    establish a desired value in this COMPARE
                                                                    register, write the number of ticks in the
                                                                    future to this register to indicate when
                                                                    to interrupt. The hardware does the addition
                                                                    to the COUNTER value in the STIMER clock
                                                                    domain so that the ma                                      */

    struct {
      __IOM uint32_t SCMPR5     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_F_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR5_b;
  } ;

  union {
    __IOM uint32_t SCMPR6;                      /*!< (@ 0x00000168) The VALUE in this bit field is used to compare
                                                                    against the VALUE in the COUNTER register.
                                                                    If the match criterion in the configuration
                                                                    register is met then a corresponding interrupt
                                                                    status bit is set. The match criterion is
                                                                    defined as COUNTER equal to COMPARE. To
                                                                    establish a desired value in this COMPARE
                                                                    register, write the number of ticks in the
                                                                    future to this register to indicate when
                                                                    to interrupt. The hardware does the addition
                                                                    to the COUNTER value in the STIMER clock
                                                                    domain so that the ma                                      */

    struct {
      __IOM uint32_t SCMPR6     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_G_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR6_b;
  } ;

  union {
    __IOM uint32_t SCMPR7;                      /*!< (@ 0x0000016C) The VALUE in this bit field is used to compare
                                                                    against the VALUE in the COUNTER register.
                                                                    If the match criterion in the configuration
                                                                    register is met then a corresponding interrupt
                                                                    status bit is set. The match criterion is
                                                                    defined as COUNTER equal to COMPARE. To
                                                                    establish a desired value in this COMPARE
                                                                    register, write the number of ticks in the
                                                                    future to this register to indicate when
                                                                    to interrupt. The hardware does the addition
                                                                    to the COUNTER value in the STIMER clock
                                                                    domain so that the ma                                      */

    struct {
      __IOM uint32_t SCMPR7     : 32;           /*!< [31..0] Compare this value to the value in the COUNTER register
                                                     according to the match criterion, as selected in the COMPARE_H_EN
                                                     bit in the REG_CTIMER_STCGF register.                                     */
    } SCMPR7_b;
  } ;
  __IM  uint32_t  RESERVED11[28];

  union {
    __IOM uint32_t SCAPT0;                      /*!< (@ 0x000001E0) The STIMER Capture Register A grabs the VALUE
                                                                    in the COUNTER register whenever capture
                                                                    condition (event) A is asserted. This register
                                                                    holds a time stamp for the event.                          */

    struct {
      __IOM uint32_t SCAPT0     : 32;           /*!< [31..0] Whenever the event is detected, the value in the COUNTER
                                                     is copied into this register and the corresponding interrupt
                                                     status bit is set.                                                        */
    } SCAPT0_b;
  } ;

  union {
    __IOM uint32_t SCAPT1;                      /*!< (@ 0x000001E4) The STIMER Capture Register B grabs the VALUE
                                                                    in the COUNTER register whenever capture
                                                                    condition (event) B is asserted. This register
                                                                    holds a time stamp for the event.                          */

    struct {
      __IOM uint32_t SCAPT1     : 32;           /*!< [31..0] Whenever the event is detected, the value in the COUNTER
                                                     is copied into this register and the corresponding interrupt
                                                     status bit is set.                                                        */
    } SCAPT1_b;
  } ;

  union {
    __IOM uint32_t SCAPT2;                      /*!< (@ 0x000001E8) The STIMER Capture Register C grabs the VALUE
                                                                    in the COUNTER register whenever capture
                                                                    condition (event) C is asserted. This register
                                                                    holds a time stamp for the event.                          */

    struct {
      __IOM uint32_t SCAPT2     : 32;           /*!< [31..0] Whenever the event is detected, the value in the COUNTER
                                                     is copied into this register and the corresponding interrupt
                                                     status bit is set.                                                        */
    } SCAPT2_b;
  } ;

  union {
    __IOM uint32_t SCAPT3;                      /*!< (@ 0x000001EC) The STIMER Capture Register D grabs the VALUE
                                                                    in the COUNTER register whenever capture
                                                                    condition (event) D is asserted. This register
                                                                    holds a time stamp for the event.                          */

    struct {
      __IOM uint32_t SCAPT3     : 32;           /*!< [31..0] Whenever the event is detected, the value in the COUNTER
                                                     is copied into this register and the corresponding interrupt
                                                     status bit is set.                                                        */
    } SCAPT3_b;
  } ;

  union {
    __IOM uint32_t SNVR0;                       /*!< (@ 0x000001F0) The NVRAM_A Register contains a portion of the
                                                                    stored epoch offset associated with the
                                                                    time in the COUNTER register. This register
                                                                    is only reset by POI not by HRESETn. Its
                                                                    contents are intended to survive all reset
                                                                    level except POI and full power cycles.                    */

    struct {
      __IOM uint32_t SNVR0      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } SNVR0_b;
  } ;

  union {
    __IOM uint32_t SNVR1;                       /*!< (@ 0x000001F4) The NVRAM_B Register contains a portion of the
                                                                    stored epoch offset associated with the
                                                                    time in the COUNTER register. This register
                                                                    is only reset by POI not by HRESETn. Its
                                                                    contents are intended to survive all reset
                                                                    level except POI and full power cycles.                    */

    struct {
      __IOM uint32_t SNVR1      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } SNVR1_b;
  } ;

  union {
    __IOM uint32_t SNVR2;                       /*!< (@ 0x000001F8) The NVRAM_C Register contains a portion of the
                                                                    stored epoch offset associated with the
                                                                    time in the COUNTER register. This register
                                                                    is only reset by POI not by HRESETn. Its
                                                                    contents are intended to survive all reset
                                                                    level except POI and full power cycles.                    */

    struct {
      __IOM uint32_t SNVR2      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } SNVR2_b;
  } ;

  union {
    __IOM uint32_t SNVR3;                       /*!< (@ 0x000001FC) The NVRAM_D Register contains a portion of the
                                                                    stored epoch offset associated with the
                                                                    time in the COUNTER register. This register
                                                                    is only reset by POI not by HRESETn. Its
                                                                    contents are intended to survive all reset
                                                                    level except POI and full power cycles.                    */

    struct {
      __IOM uint32_t SNVR3      : 32;           /*!< [31..0] Value of the 32-bit counter as it ticks over.                     */
    } SNVR3_b;
  } ;

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< [0..0] Counter/Timer A0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< [1..1] Counter/Timer B0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< [2..2] Counter/Timer A1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< [3..3] Counter/Timer B1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< [4..4] Counter/Timer A2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< [5..5] Counter/Timer B2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< [6..6] Counter/Timer A3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< [7..7] Counter/Timer B3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA4C0INT : 1;           /*!< [8..8] Counter/Timer A4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB4C0INT : 1;           /*!< [9..9] Counter/Timer B4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA5C0INT : 1;           /*!< [10..10] Counter/Timer A5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB5C0INT : 1;           /*!< [11..11] Counter/Timer B5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA6C0INT : 1;           /*!< [12..12] Counter/Timer A6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB6C0INT : 1;           /*!< [13..13] Counter/Timer B6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA7C0INT : 1;           /*!< [14..14] Counter/Timer A7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB7C0INT : 1;           /*!< [15..15] Counter/Timer B7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< [16..16] Counter/Timer A0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< [17..17] Counter/Timer B0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< [18..18] Counter/Timer A1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< [19..19] Counter/Timer B1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< [20..20] Counter/Timer A2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< [21..21] Counter/Timer B2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< [22..22] Counter/Timer A3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< [23..23] Counter/Timer B3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA4C1INT : 1;           /*!< [24..24] Counter/Timer A4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB4C1INT : 1;           /*!< [25..25] Counter/Timer B4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA5C1INT : 1;           /*!< [26..26] Counter/Timer A5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB5C1INT : 1;           /*!< [27..27] Counter/Timer B5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA6C1INT : 1;           /*!< [28..28] Counter/Timer A6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB6C1INT : 1;           /*!< [29..29] Counter/Timer B6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA7C1INT : 1;           /*!< [30..30] Counter/Timer A7 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB7C1INT : 1;           /*!< [31..31] Counter/Timer B7 interrupt based on COMPR1.                      */
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< [0..0] Counter/Timer A0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< [1..1] Counter/Timer B0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< [2..2] Counter/Timer A1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< [3..3] Counter/Timer B1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< [4..4] Counter/Timer A2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< [5..5] Counter/Timer B2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< [6..6] Counter/Timer A3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< [7..7] Counter/Timer B3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA4C0INT : 1;           /*!< [8..8] Counter/Timer A4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB4C0INT : 1;           /*!< [9..9] Counter/Timer B4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA5C0INT : 1;           /*!< [10..10] Counter/Timer A5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB5C0INT : 1;           /*!< [11..11] Counter/Timer B5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA6C0INT : 1;           /*!< [12..12] Counter/Timer A6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB6C0INT : 1;           /*!< [13..13] Counter/Timer B6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA7C0INT : 1;           /*!< [14..14] Counter/Timer A7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB7C0INT : 1;           /*!< [15..15] Counter/Timer B7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< [16..16] Counter/Timer A0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< [17..17] Counter/Timer B0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< [18..18] Counter/Timer A1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< [19..19] Counter/Timer B1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< [20..20] Counter/Timer A2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< [21..21] Counter/Timer B2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< [22..22] Counter/Timer A3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< [23..23] Counter/Timer B3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA4C1INT : 1;           /*!< [24..24] Counter/Timer A4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB4C1INT : 1;           /*!< [25..25] Counter/Timer B4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA5C1INT : 1;           /*!< [26..26] Counter/Timer A5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB5C1INT : 1;           /*!< [27..27] Counter/Timer B5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA6C1INT : 1;           /*!< [28..28] Counter/Timer A6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB6C1INT : 1;           /*!< [29..29] Counter/Timer B6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA7C1INT : 1;           /*!< [30..30] Counter/Timer A7 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB7C1INT : 1;           /*!< [31..31] Counter/Timer B7 interrupt based on COMPR1.                      */
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< [0..0] Counter/Timer A0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< [1..1] Counter/Timer B0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< [2..2] Counter/Timer A1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< [3..3] Counter/Timer B1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< [4..4] Counter/Timer A2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< [5..5] Counter/Timer B2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< [6..6] Counter/Timer A3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< [7..7] Counter/Timer B3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA4C0INT : 1;           /*!< [8..8] Counter/Timer A4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB4C0INT : 1;           /*!< [9..9] Counter/Timer B4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA5C0INT : 1;           /*!< [10..10] Counter/Timer A5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB5C0INT : 1;           /*!< [11..11] Counter/Timer B5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA6C0INT : 1;           /*!< [12..12] Counter/Timer A6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB6C0INT : 1;           /*!< [13..13] Counter/Timer B6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA7C0INT : 1;           /*!< [14..14] Counter/Timer A7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB7C0INT : 1;           /*!< [15..15] Counter/Timer B7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< [16..16] Counter/Timer A0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< [17..17] Counter/Timer B0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< [18..18] Counter/Timer A1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< [19..19] Counter/Timer B1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< [20..20] Counter/Timer A2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< [21..21] Counter/Timer B2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< [22..22] Counter/Timer A3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< [23..23] Counter/Timer B3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA4C1INT : 1;           /*!< [24..24] Counter/Timer A4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB4C1INT : 1;           /*!< [25..25] Counter/Timer B4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA5C1INT : 1;           /*!< [26..26] Counter/Timer A5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB5C1INT : 1;           /*!< [27..27] Counter/Timer B5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA6C1INT : 1;           /*!< [28..28] Counter/Timer A6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB6C1INT : 1;           /*!< [29..29] Counter/Timer B6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA7C1INT : 1;           /*!< [30..30] Counter/Timer A7 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB7C1INT : 1;           /*!< [31..31] Counter/Timer B7 interrupt based on COMPR1.                      */
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t CTMRA0C0INT : 1;           /*!< [0..0] Counter/Timer A0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB0C0INT : 1;           /*!< [1..1] Counter/Timer B0 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA1C0INT : 1;           /*!< [2..2] Counter/Timer A1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB1C0INT : 1;           /*!< [3..3] Counter/Timer B1 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA2C0INT : 1;           /*!< [4..4] Counter/Timer A2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB2C0INT : 1;           /*!< [5..5] Counter/Timer B2 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA3C0INT : 1;           /*!< [6..6] Counter/Timer A3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB3C0INT : 1;           /*!< [7..7] Counter/Timer B3 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA4C0INT : 1;           /*!< [8..8] Counter/Timer A4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRB4C0INT : 1;           /*!< [9..9] Counter/Timer B4 interrupt based on COMPR0.                        */
      __IOM uint32_t CTMRA5C0INT : 1;           /*!< [10..10] Counter/Timer A5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB5C0INT : 1;           /*!< [11..11] Counter/Timer B5 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA6C0INT : 1;           /*!< [12..12] Counter/Timer A6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB6C0INT : 1;           /*!< [13..13] Counter/Timer B6 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA7C0INT : 1;           /*!< [14..14] Counter/Timer A7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRB7C0INT : 1;           /*!< [15..15] Counter/Timer B7 interrupt based on COMPR0.                      */
      __IOM uint32_t CTMRA0C1INT : 1;           /*!< [16..16] Counter/Timer A0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB0C1INT : 1;           /*!< [17..17] Counter/Timer B0 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA1C1INT : 1;           /*!< [18..18] Counter/Timer A1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB1C1INT : 1;           /*!< [19..19] Counter/Timer B1 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA2C1INT : 1;           /*!< [20..20] Counter/Timer A2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB2C1INT : 1;           /*!< [21..21] Counter/Timer B2 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA3C1INT : 1;           /*!< [22..22] Counter/Timer A3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB3C1INT : 1;           /*!< [23..23] Counter/Timer B3 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA4C1INT : 1;           /*!< [24..24] Counter/Timer A4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB4C1INT : 1;           /*!< [25..25] Counter/Timer B4 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA5C1INT : 1;           /*!< [26..26] Counter/Timer A5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB5C1INT : 1;           /*!< [27..27] Counter/Timer B5 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA6C1INT : 1;           /*!< [28..28] Counter/Timer A6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB6C1INT : 1;           /*!< [29..29] Counter/Timer B6 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRA7C1INT : 1;           /*!< [30..30] Counter/Timer A7 interrupt based on COMPR1.                      */
      __IOM uint32_t CTMRB7C1INT : 1;           /*!< [31..31] Counter/Timer B7 interrupt based on COMPR1.                      */
    } INTSET_b;
  } ;
  __IM  uint32_t  RESERVED12[60];

  union {
    __IOM uint32_t STMINTEN;                    /*!< (@ 0x00000300) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< [0..0] COUNTER is greater than or equal to COMPARE register
                                                     A.                                                                        */
      __IOM uint32_t COMPAREB   : 1;            /*!< [1..1] COUNTER is greater than or equal to COMPARE register
                                                     B.                                                                        */
      __IOM uint32_t COMPAREC   : 1;            /*!< [2..2] COUNTER is greater than or equal to COMPARE register
                                                     C.                                                                        */
      __IOM uint32_t COMPARED   : 1;            /*!< [3..3] COUNTER is greater than or equal to COMPARE register
                                                     D.                                                                        */
      __IOM uint32_t COMPAREE   : 1;            /*!< [4..4] COUNTER is greater than or equal to COMPARE register
                                                     E.                                                                        */
      __IOM uint32_t COMPAREF   : 1;            /*!< [5..5] COUNTER is greater than or equal to COMPARE register
                                                     F.                                                                        */
      __IOM uint32_t COMPAREG   : 1;            /*!< [6..6] COUNTER is greater than or equal to COMPARE register
                                                     G.                                                                        */
      __IOM uint32_t COMPAREH   : 1;            /*!< [7..7] COUNTER is greater than or equal to COMPARE register
                                                     H.                                                                        */
      __IOM uint32_t OVERFLOW   : 1;            /*!< [8..8] COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.            */
      __IOM uint32_t CAPTUREA   : 1;            /*!< [9..9] CAPTURE register A has grabbed the value in the counter            */
      __IOM uint32_t CAPTUREB   : 1;            /*!< [10..10] CAPTURE register B has grabbed the value in the counter          */
      __IOM uint32_t CAPTUREC   : 1;            /*!< [11..11] CAPTURE register C has grabbed the value in the counter          */
      __IOM uint32_t CAPTURED   : 1;            /*!< [12..12] CAPTURE register D has grabbed the value in the counter          */
            uint32_t            : 19;
    } STMINTEN_b;
  } ;

  union {
    __IOM uint32_t STMINTSTAT;                  /*!< (@ 0x00000304) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< [0..0] COUNTER is greater than or equal to COMPARE register
                                                     A.                                                                        */
      __IOM uint32_t COMPAREB   : 1;            /*!< [1..1] COUNTER is greater than or equal to COMPARE register
                                                     B.                                                                        */
      __IOM uint32_t COMPAREC   : 1;            /*!< [2..2] COUNTER is greater than or equal to COMPARE register
                                                     C.                                                                        */
      __IOM uint32_t COMPARED   : 1;            /*!< [3..3] COUNTER is greater than or equal to COMPARE register
                                                     D.                                                                        */
      __IOM uint32_t COMPAREE   : 1;            /*!< [4..4] COUNTER is greater than or equal to COMPARE register
                                                     E.                                                                        */
      __IOM uint32_t COMPAREF   : 1;            /*!< [5..5] COUNTER is greater than or equal to COMPARE register
                                                     F.                                                                        */
      __IOM uint32_t COMPAREG   : 1;            /*!< [6..6] COUNTER is greater than or equal to COMPARE register
                                                     G.                                                                        */
      __IOM uint32_t COMPAREH   : 1;            /*!< [7..7] COUNTER is greater than or equal to COMPARE register
                                                     H.                                                                        */
      __IOM uint32_t OVERFLOW   : 1;            /*!< [8..8] COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.            */
      __IOM uint32_t CAPTUREA   : 1;            /*!< [9..9] CAPTURE register A has grabbed the value in the counter            */
      __IOM uint32_t CAPTUREB   : 1;            /*!< [10..10] CAPTURE register B has grabbed the value in the counter          */
      __IOM uint32_t CAPTUREC   : 1;            /*!< [11..11] CAPTURE register C has grabbed the value in the counter          */
      __IOM uint32_t CAPTURED   : 1;            /*!< [12..12] CAPTURE register D has grabbed the value in the counter          */
            uint32_t            : 19;
    } STMINTSTAT_b;
  } ;

  union {
    __IOM uint32_t STMINTCLR;                   /*!< (@ 0x00000308) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< [0..0] COUNTER is greater than or equal to COMPARE register
                                                     A.                                                                        */
      __IOM uint32_t COMPAREB   : 1;            /*!< [1..1] COUNTER is greater than or equal to COMPARE register
                                                     B.                                                                        */
      __IOM uint32_t COMPAREC   : 1;            /*!< [2..2] COUNTER is greater than or equal to COMPARE register
                                                     C.                                                                        */
      __IOM uint32_t COMPARED   : 1;            /*!< [3..3] COUNTER is greater than or equal to COMPARE register
                                                     D.                                                                        */
      __IOM uint32_t COMPAREE   : 1;            /*!< [4..4] COUNTER is greater than or equal to COMPARE register
                                                     E.                                                                        */
      __IOM uint32_t COMPAREF   : 1;            /*!< [5..5] COUNTER is greater than or equal to COMPARE register
                                                     F.                                                                        */
      __IOM uint32_t COMPAREG   : 1;            /*!< [6..6] COUNTER is greater than or equal to COMPARE register
                                                     G.                                                                        */
      __IOM uint32_t COMPAREH   : 1;            /*!< [7..7] COUNTER is greater than or equal to COMPARE register
                                                     H.                                                                        */
      __IOM uint32_t OVERFLOW   : 1;            /*!< [8..8] COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.            */
      __IOM uint32_t CAPTUREA   : 1;            /*!< [9..9] CAPTURE register A has grabbed the value in the counter            */
      __IOM uint32_t CAPTUREB   : 1;            /*!< [10..10] CAPTURE register B has grabbed the value in the counter          */
      __IOM uint32_t CAPTUREC   : 1;            /*!< [11..11] CAPTURE register C has grabbed the value in the counter          */
      __IOM uint32_t CAPTURED   : 1;            /*!< [12..12] CAPTURE register D has grabbed the value in the counter          */
            uint32_t            : 19;
    } STMINTCLR_b;
  } ;

  union {
    __IOM uint32_t STMINTSET;                   /*!< (@ 0x0000030C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t COMPAREA   : 1;            /*!< [0..0] COUNTER is greater than or equal to COMPARE register
                                                     A.                                                                        */
      __IOM uint32_t COMPAREB   : 1;            /*!< [1..1] COUNTER is greater than or equal to COMPARE register
                                                     B.                                                                        */
      __IOM uint32_t COMPAREC   : 1;            /*!< [2..2] COUNTER is greater than or equal to COMPARE register
                                                     C.                                                                        */
      __IOM uint32_t COMPARED   : 1;            /*!< [3..3] COUNTER is greater than or equal to COMPARE register
                                                     D.                                                                        */
      __IOM uint32_t COMPAREE   : 1;            /*!< [4..4] COUNTER is greater than or equal to COMPARE register
                                                     E.                                                                        */
      __IOM uint32_t COMPAREF   : 1;            /*!< [5..5] COUNTER is greater than or equal to COMPARE register
                                                     F.                                                                        */
      __IOM uint32_t COMPAREG   : 1;            /*!< [6..6] COUNTER is greater than or equal to COMPARE register
                                                     G.                                                                        */
      __IOM uint32_t COMPAREH   : 1;            /*!< [7..7] COUNTER is greater than or equal to COMPARE register
                                                     H.                                                                        */
      __IOM uint32_t OVERFLOW   : 1;            /*!< [8..8] COUNTER over flowed from 0xFFFFFFFF back to 0x00000000.            */
      __IOM uint32_t CAPTUREA   : 1;            /*!< [9..9] CAPTURE register A has grabbed the value in the counter            */
      __IOM uint32_t CAPTUREB   : 1;            /*!< [10..10] CAPTURE register B has grabbed the value in the counter          */
      __IOM uint32_t CAPTUREC   : 1;            /*!< [11..11] CAPTURE register C has grabbed the value in the counter          */
      __IOM uint32_t CAPTURED   : 1;            /*!< [12..12] CAPTURE register D has grabbed the value in the counter          */
            uint32_t            : 19;
    } STMINTSET_b;
  } ;
} CTIMER_Type;                                  /*!< Size = 784 (0x310)                                                        */



/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose IO (GPIO)
  */

typedef struct {                                /*!< (@ 0x40010000) GPIO Structure                                             */

  union {
    __IOM uint32_t PADREGA;                     /*!< (@ 0x00000000) This register controls the pad configuration
                                                                    controls for PAD3 through PAD0. Writes to
                                                                    this register must be unlocked by the PADKEY
                                                                    register.                                                  */

    struct {
      __IOM uint32_t PAD0PULL   : 1;            /*!< [0..0] Pad 0 pullup enable                                                */
      __IOM uint32_t PAD0INPEN  : 1;            /*!< [1..1] Pad 0 input enable                                                 */
      __IOM uint32_t PAD0STRNG  : 1;            /*!< [2..2] Pad 0 drive strength                                               */
      __IOM uint32_t PAD0FNCSEL : 3;            /*!< [5..3] Pad 0 function select                                              */
      __IOM uint32_t PAD0RSEL   : 2;            /*!< [7..6] Pad 0 pullup resistor selection.                                   */
      __IOM uint32_t PAD1PULL   : 1;            /*!< [8..8] Pad 1 pullup enable                                                */
      __IOM uint32_t PAD1INPEN  : 1;            /*!< [9..9] Pad 1 input enable                                                 */
      __IOM uint32_t PAD1STRNG  : 1;            /*!< [10..10] Pad 1 drive strength                                             */
      __IOM uint32_t PAD1FNCSEL : 3;            /*!< [13..11] Pad 1 function select                                            */
      __IOM uint32_t PAD1RSEL   : 2;            /*!< [15..14] Pad 1 pullup resistor selection.                                 */
      __IOM uint32_t PAD2PULL   : 1;            /*!< [16..16] Pad 2 pullup enable                                              */
      __IOM uint32_t PAD2INPEN  : 1;            /*!< [17..17] Pad 2 input enable                                               */
      __IOM uint32_t PAD2STRNG  : 1;            /*!< [18..18] Pad 2 drive strength                                             */
      __IOM uint32_t PAD2FNCSEL : 3;            /*!< [21..19] Pad 2 function select                                            */
            uint32_t            : 2;
      __IOM uint32_t PAD3PULL   : 1;            /*!< [24..24] Pad 3 pullup enable                                              */
      __IOM uint32_t PAD3INPEN  : 1;            /*!< [25..25] Pad 3 input enable.                                              */
      __IOM uint32_t PAD3STRNG  : 1;            /*!< [26..26] Pad 3 drive strength.                                            */
      __IOM uint32_t PAD3FNCSEL : 3;            /*!< [29..27] Pad 3 function select                                            */
      __IOM uint32_t PAD3PWRUP  : 1;            /*!< [30..30] Pad 3 VDD power switch enable                                    */
            uint32_t            : 1;
    } PADREGA_b;
  } ;

  union {
    __IOM uint32_t PADREGB;                     /*!< (@ 0x00000004) This register controls the pad configuration
                                                                    controls for PAD7 through PAD4. Writes to
                                                                    this register must be unlocked by the PADKEY
                                                                    register.                                                  */

    struct {
      __IOM uint32_t PAD4PULL   : 1;            /*!< [0..0] Pad 4 pullup enable                                                */
      __IOM uint32_t PAD4INPEN  : 1;            /*!< [1..1] Pad 4 input enable                                                 */
      __IOM uint32_t PAD4STRNG  : 1;            /*!< [2..2] Pad 4 drive strength                                               */
      __IOM uint32_t PAD4FNCSEL : 3;            /*!< [5..3] Pad 4 function select                                              */
            uint32_t            : 2;
      __IOM uint32_t PAD5PULL   : 1;            /*!< [8..8] Pad 5 pullup enable                                                */
      __IOM uint32_t PAD5INPEN  : 1;            /*!< [9..9] Pad 5 input enable                                                 */
      __IOM uint32_t PAD5STRNG  : 1;            /*!< [10..10] Pad 5 drive strength                                             */
      __IOM uint32_t PAD5FNCSEL : 3;            /*!< [13..11] Pad 5 function select                                            */
      __IOM uint32_t PAD5RSEL   : 2;            /*!< [15..14] Pad 5 pullup resistor selection.                                 */
      __IOM uint32_t PAD6PULL   : 1;            /*!< [16..16] Pad 6 pullup enable                                              */
      __IOM uint32_t PAD6INPEN  : 1;            /*!< [17..17] Pad 6 input enable                                               */
      __IOM uint32_t PAD6STRNG  : 1;            /*!< [18..18] Pad 6 drive strength                                             */
      __IOM uint32_t PAD6FNCSEL : 3;            /*!< [21..19] Pad 6 function select                                            */
      __IOM uint32_t PAD6RSEL   : 2;            /*!< [23..22] Pad 6 pullup resistor selection.                                 */
      __IOM uint32_t PAD7PULL   : 1;            /*!< [24..24] Pad 7 pullup enable                                              */
      __IOM uint32_t PAD7INPEN  : 1;            /*!< [25..25] Pad 7 input enable                                               */
      __IOM uint32_t PAD7STRNG  : 1;            /*!< [26..26] Pad 7 drive strength                                             */
      __IOM uint32_t PAD7FNCSEL : 3;            /*!< [29..27] Pad 7 function select                                            */
            uint32_t            : 2;
    } PADREGB_b;
  } ;

  union {
    __IOM uint32_t PADREGC;                     /*!< (@ 0x00000008) This register controls the pad configuration
                                                                    controls for PAD11 through PAD8. Writes
                                                                    to this register must be unlocked by the
                                                                    PADKEY register.                                           */

    struct {
      __IOM uint32_t PAD8PULL   : 1;            /*!< [0..0] Pad 8 pullup enable                                                */
      __IOM uint32_t PAD8INPEN  : 1;            /*!< [1..1] Pad 8 input enable                                                 */
      __IOM uint32_t PAD8STRNG  : 1;            /*!< [2..2] Pad 8 drive strength                                               */
      __IOM uint32_t PAD8FNCSEL : 3;            /*!< [5..3] Pad 8 function select                                              */
      __IOM uint32_t PAD8RSEL   : 2;            /*!< [7..6] Pad 8 pullup resistor selection.                                   */
      __IOM uint32_t PAD9PULL   : 1;            /*!< [8..8] Pad 9 pullup enable                                                */
      __IOM uint32_t PAD9INPEN  : 1;            /*!< [9..9] Pad 9 input enable                                                 */
      __IOM uint32_t PAD9STRNG  : 1;            /*!< [10..10] Pad 9 drive strength                                             */
      __IOM uint32_t PAD9FNCSEL : 3;            /*!< [13..11] Pad 9 function select                                            */
      __IOM uint32_t PAD9RSEL   : 2;            /*!< [15..14] Pad 9 pullup resistor selection                                  */
      __IOM uint32_t PAD10PULL  : 1;            /*!< [16..16] Pad 10 pullup enable                                             */
      __IOM uint32_t PAD10INPEN : 1;            /*!< [17..17] Pad 10 input enable                                              */
      __IOM uint32_t PAD10STRNG : 1;            /*!< [18..18] Pad 10 drive strength                                            */
      __IOM uint32_t PAD10FNCSEL : 3;           /*!< [21..19] Pad 10 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD11PULL  : 1;            /*!< [24..24] Pad 11 pullup enable                                             */
      __IOM uint32_t PAD11INPEN : 1;            /*!< [25..25] Pad 11 input enable                                              */
      __IOM uint32_t PAD11STRNG : 1;            /*!< [26..26] Pad 11 drive strength                                            */
      __IOM uint32_t PAD11FNCSEL : 3;           /*!< [29..27] Pad 11 function select                                           */
            uint32_t            : 2;
    } PADREGC_b;
  } ;

  union {
    __IOM uint32_t PADREGD;                     /*!< (@ 0x0000000C) This register controls the pad configuration
                                                                    controls for PAD15 through PAD12. Writes
                                                                    to this register must be unlocked by the
                                                                    PADKEY register.                                           */

    struct {
      __IOM uint32_t PAD12PULL  : 1;            /*!< [0..0] Pad 12 pullup enable                                               */
      __IOM uint32_t PAD12INPEN : 1;            /*!< [1..1] Pad 12 input enable                                                */
      __IOM uint32_t PAD12STRNG : 1;            /*!< [2..2] Pad 12 drive strength                                              */
      __IOM uint32_t PAD12FNCSEL : 3;           /*!< [5..3] Pad 12 function select                                             */
            uint32_t            : 2;
      __IOM uint32_t PAD13PULL  : 1;            /*!< [8..8] Pad 13 pullup enable                                               */
      __IOM uint32_t PAD13INPEN : 1;            /*!< [9..9] Pad 13 input enable                                                */
      __IOM uint32_t PAD13STRNG : 1;            /*!< [10..10] Pad 13 drive strength                                            */
      __IOM uint32_t PAD13FNCSEL : 3;           /*!< [13..11] Pad 13 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD14PULL  : 1;            /*!< [16..16] Pad 14 pullup enable                                             */
      __IOM uint32_t PAD14INPEN : 1;            /*!< [17..17] Pad 14 input enable                                              */
      __IOM uint32_t PAD14STRNG : 1;            /*!< [18..18] Pad 14 drive strength                                            */
      __IOM uint32_t PAD14FNCSEL : 3;           /*!< [21..19] Pad 14 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD15PULL  : 1;            /*!< [24..24] Pad 15 pullup enable                                             */
      __IOM uint32_t PAD15INPEN : 1;            /*!< [25..25] Pad 15 input enable                                              */
      __IOM uint32_t PAD15STRNG : 1;            /*!< [26..26] Pad 15 drive strength                                            */
      __IOM uint32_t PAD15FNCSEL : 3;           /*!< [29..27] Pad 15 function select                                           */
            uint32_t            : 2;
    } PADREGD_b;
  } ;

  union {
    __IOM uint32_t PADREGE;                     /*!< (@ 0x00000010) This register controls the pad configuration
                                                                    controls for PAD19 through PAD16. Writes
                                                                    to this register must be unlocked by the
                                                                    PADKEY register.                                           */

    struct {
      __IOM uint32_t PAD16PULL  : 1;            /*!< [0..0] Pad 16 pullup enable                                               */
      __IOM uint32_t PAD16INPEN : 1;            /*!< [1..1] Pad 16 input enable                                                */
      __IOM uint32_t PAD16STRNG : 1;            /*!< [2..2] Pad 16 drive strength                                              */
      __IOM uint32_t PAD16FNCSEL : 3;           /*!< [5..3] Pad 16 function select                                             */
            uint32_t            : 2;
      __IOM uint32_t PAD17PULL  : 1;            /*!< [8..8] Pad 17 pullup enable                                               */
      __IOM uint32_t PAD17INPEN : 1;            /*!< [9..9] Pad 17 input enable                                                */
      __IOM uint32_t PAD17STRNG : 1;            /*!< [10..10] Pad 17 drive strength                                            */
      __IOM uint32_t PAD17FNCSEL : 3;           /*!< [13..11] Pad 17 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD18PULL  : 1;            /*!< [16..16] Pad 18 pullup enable                                             */
      __IOM uint32_t PAD18INPEN : 1;            /*!< [17..17] Pad 18 input enable                                              */
      __IOM uint32_t PAD18STRNG : 1;            /*!< [18..18] Pad 18 drive strength                                            */
      __IOM uint32_t PAD18FNCSEL : 3;           /*!< [21..19] Pad 18 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD19PULL  : 1;            /*!< [24..24] Pad 19 pullup enable                                             */
      __IOM uint32_t PAD19INPEN : 1;            /*!< [25..25] Pad 19 input enable                                              */
      __IOM uint32_t PAD19STRNG : 1;            /*!< [26..26] Pad 19 drive strength                                            */
      __IOM uint32_t PAD19FNCSEL : 3;           /*!< [29..27] Pad 19 function select                                           */
            uint32_t            : 2;
    } PADREGE_b;
  } ;

  union {
    __IOM uint32_t PADREGF;                     /*!< (@ 0x00000014) This register controls the pad configuration
                                                                    controls for PAD23 through PAD20. Writes
                                                                    to this register must be unlocked by the
                                                                    PADKEY register.                                           */

    struct {
      __IOM uint32_t PAD20PULL  : 1;            /*!< [0..0] Pad 20 pulldown enable                                             */
      __IOM uint32_t PAD20INPEN : 1;            /*!< [1..1] Pad 20 input enable                                                */
      __IOM uint32_t PAD20STRNG : 1;            /*!< [2..2] Pad 20 drive strength                                              */
      __IOM uint32_t PAD20FNCSEL : 3;           /*!< [5..3] Pad 20 function select                                             */
            uint32_t            : 2;
      __IOM uint32_t PAD21PULL  : 1;            /*!< [8..8] Pad 21 pullup enable                                               */
      __IOM uint32_t PAD21INPEN : 1;            /*!< [9..9] Pad 21 input enable                                                */
      __IOM uint32_t PAD21STRNG : 1;            /*!< [10..10] Pad 21 drive strength                                            */
      __IOM uint32_t PAD21FNCSEL : 3;           /*!< [13..11] Pad 21 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD22PULL  : 1;            /*!< [16..16] Pad 22 pullup enable                                             */
      __IOM uint32_t PAD22INPEN : 1;            /*!< [17..17] Pad 22 input enable                                              */
      __IOM uint32_t PAD22STRNG : 1;            /*!< [18..18] Pad 22 drive strength                                            */
      __IOM uint32_t PAD22FNCSEL : 3;           /*!< [21..19] Pad 22 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD23PULL  : 1;            /*!< [24..24] Pad 23 pullup enable                                             */
      __IOM uint32_t PAD23INPEN : 1;            /*!< [25..25] Pad 23 input enable                                              */
      __IOM uint32_t PAD23STRNG : 1;            /*!< [26..26] Pad 23 drive strength                                            */
      __IOM uint32_t PAD23FNCSEL : 3;           /*!< [29..27] Pad 23 function select                                           */
            uint32_t            : 2;
    } PADREGF_b;
  } ;

  union {
    __IOM uint32_t PADREGG;                     /*!< (@ 0x00000018) This register controls the pad configuration
                                                                    controls for PAD27 through PAD24. Writes
                                                                    to this register must be unlocked by the
                                                                    PADKEY register.                                           */

    struct {
      __IOM uint32_t PAD24PULL  : 1;            /*!< [0..0] Pad 24 pullup enable                                               */
      __IOM uint32_t PAD24INPEN : 1;            /*!< [1..1] Pad 24 input enable                                                */
      __IOM uint32_t PAD24STRNG : 1;            /*!< [2..2] Pad 24 drive strength                                              */
      __IOM uint32_t PAD24FNCSEL : 3;           /*!< [5..3] Pad 24 function select                                             */
            uint32_t            : 2;
      __IOM uint32_t PAD25PULL  : 1;            /*!< [8..8] Pad 25 pullup enable                                               */
      __IOM uint32_t PAD25INPEN : 1;            /*!< [9..9] Pad 25 input enable                                                */
      __IOM uint32_t PAD25STRNG : 1;            /*!< [10..10] Pad 25 drive strength                                            */
      __IOM uint32_t PAD25FNCSEL : 3;           /*!< [13..11] Pad 25 function select                                           */
      __IOM uint32_t PAD25RSEL  : 2;            /*!< [15..14] Pad 25 pullup resistor selection.                                */
      __IOM uint32_t PAD26PULL  : 1;            /*!< [16..16] Pad 26 pullup enable                                             */
      __IOM uint32_t PAD26INPEN : 1;            /*!< [17..17] Pad 26 input enable                                              */
      __IOM uint32_t PAD26STRNG : 1;            /*!< [18..18] Pad 26 drive strength                                            */
      __IOM uint32_t PAD26FNCSEL : 3;           /*!< [21..19] Pad 26 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD27PULL  : 1;            /*!< [24..24] Pad 27 pullup enable                                             */
      __IOM uint32_t PAD27INPEN : 1;            /*!< [25..25] Pad 27 input enable                                              */
      __IOM uint32_t PAD27STRNG : 1;            /*!< [26..26] Pad 27 drive strength                                            */
      __IOM uint32_t PAD27FNCSEL : 3;           /*!< [29..27] Pad 27 function select                                           */
      __IOM uint32_t PAD27RSEL  : 2;            /*!< [31..30] Pad 27 pullup resistor selection.                                */
    } PADREGG_b;
  } ;

  union {
    __IOM uint32_t PADREGH;                     /*!< (@ 0x0000001C) This register controls the pad configuration
                                                                    controls for PAD31 through PAD28. Writes
                                                                    to this register must be unlocked by the
                                                                    PADKEY register.                                           */

    struct {
      __IOM uint32_t PAD28PULL  : 1;            /*!< [0..0] Pad 28 pullup enable                                               */
      __IOM uint32_t PAD28INPEN : 1;            /*!< [1..1] Pad 28 input enable                                                */
      __IOM uint32_t PAD28STRNG : 1;            /*!< [2..2] Pad 28 drive strength                                              */
      __IOM uint32_t PAD28FNCSEL : 3;           /*!< [5..3] Pad 28 function select                                             */
            uint32_t            : 2;
      __IOM uint32_t PAD29PULL  : 1;            /*!< [8..8] Pad 29 pullup enable                                               */
      __IOM uint32_t PAD29INPEN : 1;            /*!< [9..9] Pad 29 input enable                                                */
      __IOM uint32_t PAD29STRNG : 1;            /*!< [10..10] Pad 29 drive strength                                            */
      __IOM uint32_t PAD29FNCSEL : 3;           /*!< [13..11] Pad 29 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD30PULL  : 1;            /*!< [16..16] Pad 30 pullup enable                                             */
      __IOM uint32_t PAD30INPEN : 1;            /*!< [17..17] Pad 30 input enable                                              */
      __IOM uint32_t PAD30STRNG : 1;            /*!< [18..18] Pad 30 drive strength                                            */
      __IOM uint32_t PAD30FNCSEL : 3;           /*!< [21..19] Pad 30 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD31PULL  : 1;            /*!< [24..24] Pad 31 pullup enable                                             */
      __IOM uint32_t PAD31INPEN : 1;            /*!< [25..25] Pad 31 input enable                                              */
      __IOM uint32_t PAD31STRNG : 1;            /*!< [26..26] Pad 31 drive strength                                            */
      __IOM uint32_t PAD31FNCSEL : 3;           /*!< [29..27] Pad 31 function select                                           */
            uint32_t            : 2;
    } PADREGH_b;
  } ;

  union {
    __IOM uint32_t PADREGI;                     /*!< (@ 0x00000020) This register controls the pad configuration
                                                                    controls for PAD35 through PAD32. Writes
                                                                    to this register must be unlocked by the
                                                                    PADKEY register.                                           */

    struct {
      __IOM uint32_t PAD32PULL  : 1;            /*!< [0..0] Pad 32 pullup enable                                               */
      __IOM uint32_t PAD32INPEN : 1;            /*!< [1..1] Pad 32 input enable                                                */
      __IOM uint32_t PAD32STRNG : 1;            /*!< [2..2] Pad 32 drive strength                                              */
      __IOM uint32_t PAD32FNCSEL : 3;           /*!< [5..3] Pad 32 function select                                             */
            uint32_t            : 2;
      __IOM uint32_t PAD33PULL  : 1;            /*!< [8..8] Pad 33 pullup enable                                               */
      __IOM uint32_t PAD33INPEN : 1;            /*!< [9..9] Pad 33 input enable                                                */
      __IOM uint32_t PAD33STRNG : 1;            /*!< [10..10] Pad 33 drive strength                                            */
      __IOM uint32_t PAD33FNCSEL : 3;           /*!< [13..11] Pad 33 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD34PULL  : 1;            /*!< [16..16] Pad 34 pullup enable                                             */
      __IOM uint32_t PAD34INPEN : 1;            /*!< [17..17] Pad 34 input enable                                              */
      __IOM uint32_t PAD34STRNG : 1;            /*!< [18..18] Pad 34 drive strength                                            */
      __IOM uint32_t PAD34FNCSEL : 3;           /*!< [21..19] Pad 34 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD35PULL  : 1;            /*!< [24..24] Pad 35 pullup enable                                             */
      __IOM uint32_t PAD35INPEN : 1;            /*!< [25..25] Pad 35 input enable                                              */
      __IOM uint32_t PAD35STRNG : 1;            /*!< [26..26] Pad 35 drive strength                                            */
      __IOM uint32_t PAD35FNCSEL : 3;           /*!< [29..27] Pad 35 function select                                           */
            uint32_t            : 2;
    } PADREGI_b;
  } ;

  union {
    __IOM uint32_t PADREGJ;                     /*!< (@ 0x00000024) This register controls the pad configuration
                                                                    controls for PAD39 through PAD36. Writes
                                                                    to this register must be unlocked by the
                                                                    PADKEY register.                                           */

    struct {
      __IOM uint32_t PAD36PULL  : 1;            /*!< [0..0] Pad 36 pullup enable                                               */
      __IOM uint32_t PAD36INPEN : 1;            /*!< [1..1] Pad 36 input enable                                                */
      __IOM uint32_t PAD36STRNG : 1;            /*!< [2..2] Pad 36 drive strength                                              */
      __IOM uint32_t PAD36FNCSEL : 3;           /*!< [5..3] Pad 36 function select                                             */
      __IOM uint32_t PAD36PWRUP : 1;            /*!< [6..6] Pad 36 VDD power switch enable                                     */
            uint32_t            : 1;
      __IOM uint32_t PAD37PULL  : 1;            /*!< [8..8] Pad 37 pullup enable                                               */
      __IOM uint32_t PAD37INPEN : 1;            /*!< [9..9] Pad 37 input enable                                                */
      __IOM uint32_t PAD37STRNG : 1;            /*!< [10..10] Pad 37 drive strength                                            */
      __IOM uint32_t PAD37FNCSEL : 3;           /*!< [13..11] Pad 37 function select                                           */
            uint32_t            : 1;
      __IOM uint32_t PAD37PWRDN : 1;            /*!< [15..15] Pad 37 VSS power switch enable                                   */
      __IOM uint32_t PAD38PULL  : 1;            /*!< [16..16] Pad 38 pullup enable                                             */
      __IOM uint32_t PAD38INPEN : 1;            /*!< [17..17] Pad 38 input enable                                              */
      __IOM uint32_t PAD38STRNG : 1;            /*!< [18..18] Pad 38 drive strength                                            */
      __IOM uint32_t PAD38FNCSEL : 3;           /*!< [21..19] Pad 38 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD39PULL  : 1;            /*!< [24..24] Pad 39 pullup enable                                             */
      __IOM uint32_t PAD39INPEN : 1;            /*!< [25..25] Pad 39 input enable                                              */
      __IOM uint32_t PAD39STRNG : 1;            /*!< [26..26] Pad 39 drive strength                                            */
      __IOM uint32_t PAD39FNCSEL : 3;           /*!< [29..27] Pad 39 function select                                           */
      __IOM uint32_t PAD39RSEL  : 2;            /*!< [31..30] Pad 39 pullup resistor selection.                                */
    } PADREGJ_b;
  } ;

  union {
    __IOM uint32_t PADREGK;                     /*!< (@ 0x00000028) This register controls the pad configuration
                                                                    controls for PAD43 through PAD40. Writes
                                                                    to this register must be unlocked by the
                                                                    PADKEY register.                                           */

    struct {
      __IOM uint32_t PAD40PULL  : 1;            /*!< [0..0] Pad 40 pullup enable                                               */
      __IOM uint32_t PAD40INPEN : 1;            /*!< [1..1] Pad 40 input enable                                                */
      __IOM uint32_t PAD40STRNG : 1;            /*!< [2..2] Pad 40 drive strength                                              */
      __IOM uint32_t PAD40FNCSEL : 3;           /*!< [5..3] Pad 40 function select                                             */
      __IOM uint32_t PAD40RSEL  : 2;            /*!< [7..6] Pad 40 pullup resistor selection.                                  */
      __IOM uint32_t PAD41PULL  : 1;            /*!< [8..8] Pad 41 pullup enable                                               */
      __IOM uint32_t PAD41INPEN : 1;            /*!< [9..9] Pad 41 input enable                                                */
      __IOM uint32_t PAD41STRNG : 1;            /*!< [10..10] Pad 41 drive strength                                            */
      __IOM uint32_t PAD41FNCSEL : 3;           /*!< [13..11] Pad 41 function select                                           */
            uint32_t            : 1;
      __IOM uint32_t PAD41PWRDN : 1;            /*!< [15..15] Pad 41 power switch enable                                       */
      __IOM uint32_t PAD42PULL  : 1;            /*!< [16..16] Pad 42 pullup enable                                             */
      __IOM uint32_t PAD42INPEN : 1;            /*!< [17..17] Pad 42 input enable                                              */
      __IOM uint32_t PAD42STRNG : 1;            /*!< [18..18] Pad 42 drive strength                                            */
      __IOM uint32_t PAD42FNCSEL : 3;           /*!< [21..19] Pad 42 function select                                           */
      __IOM uint32_t PAD42RSEL  : 2;            /*!< [23..22] Pad 42 pullup resistor selection.                                */
      __IOM uint32_t PAD43PULL  : 1;            /*!< [24..24] Pad 43 pullup enable                                             */
      __IOM uint32_t PAD43INPEN : 1;            /*!< [25..25] Pad 43 input enable                                              */
      __IOM uint32_t PAD43STRNG : 1;            /*!< [26..26] Pad 43 drive strength                                            */
      __IOM uint32_t PAD43FNCSEL : 3;           /*!< [29..27] Pad 43 function select                                           */
      __IOM uint32_t PAD43RSEL  : 2;            /*!< [31..30] Pad 43 pullup resistor selection.                                */
    } PADREGK_b;
  } ;

  union {
    __IOM uint32_t PADREGL;                     /*!< (@ 0x0000002C) This register controls the pad configuration
                                                                    controls for PAD47 through PAD44. Writes
                                                                    to this register must be unlocked by the
                                                                    PADKEY register.                                           */

    struct {
      __IOM uint32_t PAD44PULL  : 1;            /*!< [0..0] Pad 44 pullup enable                                               */
      __IOM uint32_t PAD44INPEN : 1;            /*!< [1..1] Pad 44 input enable                                                */
      __IOM uint32_t PAD44STRNG : 1;            /*!< [2..2] Pad 44 drive strength                                              */
      __IOM uint32_t PAD44FNCSEL : 3;           /*!< [5..3] Pad 44 function select                                             */
            uint32_t            : 2;
      __IOM uint32_t PAD45PULL  : 1;            /*!< [8..8] Pad 45 pullup enable                                               */
      __IOM uint32_t PAD45INPEN : 1;            /*!< [9..9] Pad 45 input enable                                                */
      __IOM uint32_t PAD45STRNG : 1;            /*!< [10..10] Pad 45 drive strength                                            */
      __IOM uint32_t PAD45FNCSEL : 3;           /*!< [13..11] Pad 45 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD46PULL  : 1;            /*!< [16..16] Pad 46 pullup enable                                             */
      __IOM uint32_t PAD46INPEN : 1;            /*!< [17..17] Pad 46 input enable                                              */
      __IOM uint32_t PAD46STRNG : 1;            /*!< [18..18] Pad 46 drive strength                                            */
      __IOM uint32_t PAD46FNCSEL : 3;           /*!< [21..19] Pad 46 function select                                           */
            uint32_t            : 2;
      __IOM uint32_t PAD47PULL  : 1;            /*!< [24..24] Pad 47 pullup enable                                             */
      __IOM uint32_t PAD47INPEN : 1;            /*!< [25..25] Pad 47 input enable                                              */
      __IOM uint32_t PAD47STRNG : 1;            /*!< [26..26] Pad 47 drive strength                                            */
      __IOM uint32_t PAD47FNCSEL : 3;           /*!< [29..27] Pad 47 function select                                           */
            uint32_t            : 2;
    } PADREGL_b;
  } ;

  union {
    __IOM uint32_t PADREGM;                     /*!< (@ 0x00000030) This register controls the pad configuration
                                                                    controls for PAD49 through PAD48. Writes
                                                                    to this register must be unlocked by the
                                                                    PADKEY register.                                           */

    struct {
      __IOM uint32_t PAD48PULL  : 1;            /*!< [0..0] Pad 48 pullup enable                                               */
      __IOM uint32_t PAD48INPEN : 1;            /*!< [1..1] Pad 48 input enable                                                */
      __IOM uint32_t PAD48STRNG : 1;            /*!< [2..2] Pad 48 drive strength                                              */
      __IOM uint32_t PAD48FNCSEL : 3;           /*!< [5..3] Pad 48 function select                                             */
      __IOM uint32_t PAD48RSEL  : 2;            /*!< [7..6] Pad 48 pullup resistor selection.                                  */
      __IOM uint32_t PAD49PULL  : 1;            /*!< [8..8] Pad 49 pullup enable                                               */
      __IOM uint32_t PAD49INPEN : 1;            /*!< [9..9] Pad 49 input enable                                                */
      __IOM uint32_t PAD49STRNG : 1;            /*!< [10..10] Pad 49 drive strength                                            */
      __IOM uint32_t PAD49FNCSEL : 3;           /*!< [13..11] Pad 49 function select                                           */
      __IOM uint32_t PAD49RSEL  : 2;            /*!< [15..14] Pad 49 pullup resistor selection.                                */
            uint32_t            : 16;
    } PADREGM_b;
  } ;
  __IM  uint32_t  RESERVED[3];

  union {
    __IOM uint32_t CFGA;                        /*!< (@ 0x00000040) GPIO configuration controls for GPIO[7:0]. Writes
                                                                    to this register must be unlocked by the
                                                                    PADKEY register.                                           */

    struct {
      __IOM uint32_t GPIO0INCFG : 1;            /*!< [0..0] GPIO0 input enable.                                                */
      __IOM uint32_t GPIO0OUTCFG : 2;           /*!< [2..1] GPIO0 output configuration.                                        */
      __IOM uint32_t GPIO0INTD  : 1;            /*!< [3..3] GPIO0 interrupt direction.                                         */
      __IOM uint32_t GPIO1INCFG : 1;            /*!< [4..4] GPIO1 input enable.                                                */
      __IOM uint32_t GPIO1OUTCFG : 2;           /*!< [6..5] GPIO1 output configuration.                                        */
      __IOM uint32_t GPIO1INTD  : 1;            /*!< [7..7] GPIO1 interrupt direction.                                         */
      __IOM uint32_t GPIO2INCFG : 1;            /*!< [8..8] GPIO2 input enable.                                                */
      __IOM uint32_t GPIO2OUTCFG : 2;           /*!< [10..9] GPIO2 output configuration.                                       */
      __IOM uint32_t GPIO2INTD  : 1;            /*!< [11..11] GPIO2 interrupt direction.                                       */
      __IOM uint32_t GPIO3INCFG : 1;            /*!< [12..12] GPIO3 input enable.                                              */
      __IOM uint32_t GPIO3OUTCFG : 2;           /*!< [14..13] GPIO3 output configuration.                                      */
      __IOM uint32_t GPIO3INTD  : 1;            /*!< [15..15] GPIO3 interrupt direction.                                       */
      __IOM uint32_t GPIO4INCFG : 1;            /*!< [16..16] GPIO4 input enable.                                              */
      __IOM uint32_t GPIO4OUTCFG : 2;           /*!< [18..17] GPIO4 output configuration.                                      */
      __IOM uint32_t GPIO4INTD  : 1;            /*!< [19..19] GPIO4 interrupt direction.                                       */
      __IOM uint32_t GPIO5INCFG : 1;            /*!< [20..20] GPIO5 input enable.                                              */
      __IOM uint32_t GPIO5OUTCFG : 2;           /*!< [22..21] GPIO5 output configuration.                                      */
      __IOM uint32_t GPIO5INTD  : 1;            /*!< [23..23] GPIO5 interrupt direction.                                       */
      __IOM uint32_t GPIO6INCFG : 1;            /*!< [24..24] GPIO6 input enable.                                              */
      __IOM uint32_t GPIO6OUTCFG : 2;           /*!< [26..25] GPIO6 output configuration.                                      */
      __IOM uint32_t GPIO6INTD  : 1;            /*!< [27..27] GPIO6 interrupt direction.                                       */
      __IOM uint32_t GPIO7INCFG : 1;            /*!< [28..28] GPIO7 input enable.                                              */
      __IOM uint32_t GPIO7OUTCFG : 2;           /*!< [30..29] GPIO7 output configuration.                                      */
      __IOM uint32_t GPIO7INTD  : 1;            /*!< [31..31] GPIO7 interrupt direction, nCE polarity.                         */
    } CFGA_b;
  } ;

  union {
    __IOM uint32_t CFGB;                        /*!< (@ 0x00000044) GPIO configuration controls for GPIO[15:8]. Writes
                                                                    to this register must be unlocked by the
                                                                    PADKEY register.                                           */

    struct {
      __IOM uint32_t GPIO8INCFG : 1;            /*!< [0..0] GPIO8 input enable.                                                */
      __IOM uint32_t GPIO8OUTCFG : 2;           /*!< [2..1] GPIO8 output configuration.                                        */
      __IOM uint32_t GPIO8INTD  : 1;            /*!< [3..3] GPIO8 interrupt direction.                                         */
      __IOM uint32_t GPIO9INCFG : 1;            /*!< [4..4] GPIO9 input enable.                                                */
      __IOM uint32_t GPIO9OUTCFG : 2;           /*!< [6..5] GPIO9 output configuration.                                        */
      __IOM uint32_t GPIO9INTD  : 1;            /*!< [7..7] GPIO9 interrupt direction.                                         */
      __IOM uint32_t GPIO10INCFG : 1;           /*!< [8..8] GPIO10 input enable.                                               */
      __IOM uint32_t GPIO10OUTCFG : 2;          /*!< [10..9] GPIO10 output configuration.                                      */
      __IOM uint32_t GPIO10INTD : 1;            /*!< [11..11] GPIO10 interrupt direction.                                      */
      __IOM uint32_t GPIO11INCFG : 1;           /*!< [12..12] GPIO11 input enable.                                             */
      __IOM uint32_t GPIO11OUTCFG : 2;          /*!< [14..13] GPIO11 output configuration.                                     */
      __IOM uint32_t GPIO11INTD : 1;            /*!< [15..15] GPIO11 interrupt direction.                                      */
      __IOM uint32_t GPIO12INCFG : 1;           /*!< [16..16] GPIO12 input enable.                                             */
      __IOM uint32_t GPIO12OUTCFG : 2;          /*!< [18..17] GPIO12 output configuration.                                     */
      __IOM uint32_t GPIO12INTD : 1;            /*!< [19..19] GPIO12 interrupt direction.                                      */
      __IOM uint32_t GPIO13INCFG : 1;           /*!< [20..20] GPIO13 input enable.                                             */
      __IOM uint32_t GPIO13OUTCFG : 2;          /*!< [22..21] GPIO13 output configuration.                                     */
      __IOM uint32_t GPIO13INTD : 1;            /*!< [23..23] GPIO13 interrupt direction.                                      */
      __IOM uint32_t GPIO14INCFG : 1;           /*!< [24..24] GPIO14 input enable.                                             */
      __IOM uint32_t GPIO14OUTCFG : 2;          /*!< [26..25] GPIO14 output configuration.                                     */
      __IOM uint32_t GPIO14INTD : 1;            /*!< [27..27] GPIO14 interrupt direction.                                      */
      __IOM uint32_t GPIO15INCFG : 1;           /*!< [28..28] GPIO15 input enable.                                             */
      __IOM uint32_t GPIO15OUTCFG : 2;          /*!< [30..29] GPIO15 output configuration.                                     */
      __IOM uint32_t GPIO15INTD : 1;            /*!< [31..31] GPIO15 interrupt direction.                                      */
    } CFGB_b;
  } ;

  union {
    __IOM uint32_t CFGC;                        /*!< (@ 0x00000048) GPIO configuration controls for GPIO[23:16].
                                                                    Writes to this register must be unlocked
                                                                    by the PADKEY register.                                    */

    struct {
      __IOM uint32_t GPIO16INCFG : 1;           /*!< [0..0] GPIO16 input enable.                                               */
      __IOM uint32_t GPIO16OUTCFG : 2;          /*!< [2..1] GPIO16 output configuration.                                       */
      __IOM uint32_t GPIO16INTD : 1;            /*!< [3..3] GPIO16 interrupt direction.                                        */
      __IOM uint32_t GPIO17INCFG : 1;           /*!< [4..4] GPIO17 input enable.                                               */
      __IOM uint32_t GPIO17OUTCFG : 2;          /*!< [6..5] GPIO17 output configuration.                                       */
      __IOM uint32_t GPIO17INTD : 1;            /*!< [7..7] GPIO17 interrupt direction.                                        */
      __IOM uint32_t GPIO18INCFG : 1;           /*!< [8..8] GPIO18 input enable.                                               */
      __IOM uint32_t GPIO18OUTCFG : 2;          /*!< [10..9] GPIO18 output configuration.                                      */
      __IOM uint32_t GPIO18INTD : 1;            /*!< [11..11] GPIO18 interrupt direction.                                      */
      __IOM uint32_t GPIO19INCFG : 1;           /*!< [12..12] GPIO19 input enable.                                             */
      __IOM uint32_t GPIO19OUTCFG : 2;          /*!< [14..13] GPIO19 output configuration.                                     */
      __IOM uint32_t GPIO19INTD : 1;            /*!< [15..15] GPIO19 interrupt direction.                                      */
      __IOM uint32_t GPIO20INCFG : 1;           /*!< [16..16] GPIO20 input enable.                                             */
      __IOM uint32_t GPIO20OUTCFG : 2;          /*!< [18..17] GPIO20 output configuration.                                     */
      __IOM uint32_t GPIO20INTD : 1;            /*!< [19..19] GPIO20 interrupt direction.                                      */
      __IOM uint32_t GPIO21INCFG : 1;           /*!< [20..20] GPIO21 input enable.                                             */
      __IOM uint32_t GPIO21OUTCFG : 2;          /*!< [22..21] GPIO21 output configuration.                                     */
      __IOM uint32_t GPIO21INTD : 1;            /*!< [23..23] GPIO21 interrupt direction.                                      */
      __IOM uint32_t GPIO22INCFG : 1;           /*!< [24..24] GPIO22 input enable.                                             */
      __IOM uint32_t GPIO22OUTCFG : 2;          /*!< [26..25] GPIO22 output configuration.                                     */
      __IOM uint32_t GPIO22INTD : 1;            /*!< [27..27] GPIO22 interrupt direction.                                      */
      __IOM uint32_t GPIO23INCFG : 1;           /*!< [28..28] GPIO23 input enable.                                             */
      __IOM uint32_t GPIO23OUTCFG : 2;          /*!< [30..29] GPIO23 output configuration.                                     */
      __IOM uint32_t GPIO23INTD : 1;            /*!< [31..31] GPIO23 interrupt direction.                                      */
    } CFGC_b;
  } ;

  union {
    __IOM uint32_t CFGD;                        /*!< (@ 0x0000004C) GPIO configuration controls for GPIO[31:24].
                                                                    Writes to this register must be unlocked
                                                                    by the PADKEY register.                                    */

    struct {
      __IOM uint32_t GPIO24INCFG : 1;           /*!< [0..0] GPIO24 input enable.                                               */
      __IOM uint32_t GPIO24OUTCFG : 2;          /*!< [2..1] GPIO24 output configuration.                                       */
      __IOM uint32_t GPIO24INTD : 1;            /*!< [3..3] GPIO24 interrupt direction.                                        */
      __IOM uint32_t GPIO25INCFG : 1;           /*!< [4..4] GPIO25 input enable.                                               */
      __IOM uint32_t GPIO25OUTCFG : 2;          /*!< [6..5] GPIO25 output configuration.                                       */
      __IOM uint32_t GPIO25INTD : 1;            /*!< [7..7] GPIO25 interrupt direction.                                        */
      __IOM uint32_t GPIO26INCFG : 1;           /*!< [8..8] GPIO26 input enable.                                               */
      __IOM uint32_t GPIO26OUTCFG : 2;          /*!< [10..9] GPIO26 output configuration.                                      */
      __IOM uint32_t GPIO26INTD : 1;            /*!< [11..11] GPIO26 interrupt direction.                                      */
      __IOM uint32_t GPIO27INCFG : 1;           /*!< [12..12] GPIO27 input enable.                                             */
      __IOM uint32_t GPIO27OUTCFG : 2;          /*!< [14..13] GPIO27 output configuration.                                     */
      __IOM uint32_t GPIO27INTD : 1;            /*!< [15..15] GPIO27 interrupt direction.                                      */
      __IOM uint32_t GPIO28INCFG : 1;           /*!< [16..16] GPIO28 input enable.                                             */
      __IOM uint32_t GPIO28OUTCFG : 2;          /*!< [18..17] GPIO28 output configuration.                                     */
      __IOM uint32_t GPIO28INTD : 1;            /*!< [19..19] GPIO28 interrupt direction.                                      */
      __IOM uint32_t GPIO29INCFG : 1;           /*!< [20..20] GPIO29 input enable.                                             */
      __IOM uint32_t GPIO29OUTCFG : 2;          /*!< [22..21] GPIO29 output configuration.                                     */
      __IOM uint32_t GPIO29INTD : 1;            /*!< [23..23] GPIO29 interrupt direction.                                      */
      __IOM uint32_t GPIO30INCFG : 1;           /*!< [24..24] GPIO30 input enable.                                             */
      __IOM uint32_t GPIO30OUTCFG : 2;          /*!< [26..25] GPIO30 output configuration.                                     */
      __IOM uint32_t GPIO30INTD : 1;            /*!< [27..27] GPIO30 interrupt direction.                                      */
      __IOM uint32_t GPIO31INCFG : 1;           /*!< [28..28] GPIO31 input enable.                                             */
      __IOM uint32_t GPIO31OUTCFG : 2;          /*!< [30..29] GPIO31 output configuration.                                     */
      __IOM uint32_t GPIO31INTD : 1;            /*!< [31..31] GPIO31 interrupt direction.                                      */
    } CFGD_b;
  } ;

  union {
    __IOM uint32_t CFGE;                        /*!< (@ 0x00000050) GPIO configuration controls for GPIO[39:32].
                                                                    Writes to this register must be unlocked
                                                                    by the PADKEY register.                                    */

    struct {
      __IOM uint32_t GPIO32INCFG : 1;           /*!< [0..0] GPIO32 input enable.                                               */
      __IOM uint32_t GPIO32OUTCFG : 2;          /*!< [2..1] GPIO32 output configuration.                                       */
      __IOM uint32_t GPIO32INTD : 1;            /*!< [3..3] GPIO32 interrupt direction.                                        */
      __IOM uint32_t GPIO33INCFG : 1;           /*!< [4..4] GPIO33 input enable.                                               */
      __IOM uint32_t GPIO33OUTCFG : 2;          /*!< [6..5] GPIO33 output configuration.                                       */
      __IOM uint32_t GPIO33INTD : 1;            /*!< [7..7] GPIO33 interrupt direction.                                        */
      __IOM uint32_t GPIO34INCFG : 1;           /*!< [8..8] GPIO34 input enable.                                               */
      __IOM uint32_t GPIO34OUTCFG : 2;          /*!< [10..9] GPIO34 output configuration.                                      */
      __IOM uint32_t GPIO34INTD : 1;            /*!< [11..11] GPIO34 interrupt direction.                                      */
      __IOM uint32_t GPIO35INCFG : 1;           /*!< [12..12] GPIO35 input enable.                                             */
      __IOM uint32_t GPIO35OUTCFG : 2;          /*!< [14..13] GPIO35 output configuration.                                     */
      __IOM uint32_t GPIO35INTD : 1;            /*!< [15..15] GPIO35 interrupt direction.                                      */
      __IOM uint32_t GPIO36INCFG : 1;           /*!< [16..16] GPIO36 input enable.                                             */
      __IOM uint32_t GPIO36OUTCFG : 2;          /*!< [18..17] GPIO36 output configuration.                                     */
      __IOM uint32_t GPIO36INTD : 1;            /*!< [19..19] GPIO36 interrupt direction.                                      */
      __IOM uint32_t GPIO37INCFG : 1;           /*!< [20..20] GPIO37 input enable.                                             */
      __IOM uint32_t GPIO37OUTCFG : 2;          /*!< [22..21] GPIO37 output configuration.                                     */
      __IOM uint32_t GPIO37INTD : 1;            /*!< [23..23] GPIO37 interrupt direction.                                      */
      __IOM uint32_t GPIO38INCFG : 1;           /*!< [24..24] GPIO38 input enable.                                             */
      __IOM uint32_t GPIO38OUTCFG : 2;          /*!< [26..25] GPIO38 output configuration.                                     */
      __IOM uint32_t GPIO38INTD : 1;            /*!< [27..27] GPIO38 interrupt direction.                                      */
      __IOM uint32_t GPIO39INCFG : 1;           /*!< [28..28] GPIO39 input enable.                                             */
      __IOM uint32_t GPIO39OUTCFG : 2;          /*!< [30..29] GPIO39 output configuration.                                     */
      __IOM uint32_t GPIO39INTD : 1;            /*!< [31..31] GPIO39 interrupt direction.                                      */
    } CFGE_b;
  } ;

  union {
    __IOM uint32_t CFGF;                        /*!< (@ 0x00000054) GPIO configuration controls for GPIO[47:40].
                                                                    Writes to this register must be unlocked
                                                                    by the PADKEY register.                                    */

    struct {
      __IOM uint32_t GPIO40INCFG : 1;           /*!< [0..0] GPIO40 input enable.                                               */
      __IOM uint32_t GPIO40OUTCFG : 2;          /*!< [2..1] GPIO40 output configuration.                                       */
      __IOM uint32_t GPIO40INTD : 1;            /*!< [3..3] GPIO40 interrupt direction.                                        */
      __IOM uint32_t GPIO41INCFG : 1;           /*!< [4..4] GPIO41 input enable.                                               */
      __IOM uint32_t GPIO41OUTCFG : 2;          /*!< [6..5] GPIO41 output configuration.                                       */
      __IOM uint32_t GPIO41INTD : 1;            /*!< [7..7] GPIO41 interrupt direction.                                        */
      __IOM uint32_t GPIO42INCFG : 1;           /*!< [8..8] GPIO42 input enable.                                               */
      __IOM uint32_t GPIO42OUTCFG : 2;          /*!< [10..9] GPIO42 output configuration.                                      */
      __IOM uint32_t GPIO42INTD : 1;            /*!< [11..11] GPIO42 interrupt direction.                                      */
      __IOM uint32_t GPIO43INCFG : 1;           /*!< [12..12] GPIO43 input enable.                                             */
      __IOM uint32_t GPIO43OUTCFG : 2;          /*!< [14..13] GPIO43 output configuration.                                     */
      __IOM uint32_t GPIO43INTD : 1;            /*!< [15..15] GPIO43 interrupt direction.                                      */
      __IOM uint32_t GPIO44INCFG : 1;           /*!< [16..16] GPIO44 input enable.                                             */
      __IOM uint32_t GPIO44OUTCFG : 2;          /*!< [18..17] GPIO44 output configuration.                                     */
      __IOM uint32_t GPIO44INTD : 1;            /*!< [19..19] GPIO44 interrupt direction.                                      */
      __IOM uint32_t GPIO45INCFG : 1;           /*!< [20..20] GPIO45 input enable.                                             */
      __IOM uint32_t GPIO45OUTCFG : 2;          /*!< [22..21] GPIO45 output configuration.                                     */
      __IOM uint32_t GPIO45INTD : 1;            /*!< [23..23] GPIO45 interrupt direction.                                      */
      __IOM uint32_t GPIO46INCFG : 1;           /*!< [24..24] GPIO46 input enable.                                             */
      __IOM uint32_t GPIO46OUTCFG : 2;          /*!< [26..25] GPIO46 output configuration.                                     */
      __IOM uint32_t GPIO46INTD : 1;            /*!< [27..27] GPIO46 interrupt direction.                                      */
      __IOM uint32_t GPIO47INCFG : 1;           /*!< [28..28] GPIO47 input enable.                                             */
      __IOM uint32_t GPIO47OUTCFG : 2;          /*!< [30..29] GPIO47 output configuration.                                     */
      __IOM uint32_t GPIO47INTD : 1;            /*!< [31..31] GPIO47 interrupt direction.                                      */
    } CFGF_b;
  } ;

  union {
    __IOM uint32_t CFGG;                        /*!< (@ 0x00000058) GPIO configuration controls for GPIO[49:48].
                                                                    Writes to this register must be unlocked
                                                                    by the PADKEY register.                                    */

    struct {
      __IOM uint32_t GPIO48INCFG : 1;           /*!< [0..0] GPIO48 input enable.                                               */
      __IOM uint32_t GPIO48OUTCFG : 2;          /*!< [2..1] GPIO48 output configuration.                                       */
      __IOM uint32_t GPIO48INTD : 1;            /*!< [3..3] GPIO48 interrupt direction.                                        */
      __IOM uint32_t GPIO49INCFG : 1;           /*!< [4..4] GPIO49 input enable.                                               */
      __IOM uint32_t GPIO49OUTCFG : 2;          /*!< [6..5] GPIO49 output configuration.                                       */
      __IOM uint32_t GPIO49INTD : 1;            /*!< [7..7] GPIO49 interrupt direction.                                        */
            uint32_t            : 24;
    } CFGG_b;
  } ;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t PADKEY;                      /*!< (@ 0x00000060) Lock state of the PINCFG and GPIO configuration
                                                                    registers. Write a value of 0x73 to unlock
                                                                    write access to the PAD and GPIO configuration
                                                                    registers. Write any other value to lock
                                                                    access to PAD and GPIO registers. This register
                                                                    also indicates lock status when read. When
                                                                    in the unlccked state (i.e. 0x73 has been
                                                                    written), it reads as 1. When in the locked
                                                                    state, it reads as 0.                                      */

    struct {
      __IOM uint32_t PADKEY     : 32;           /*!< [31..0] Key register value.                                               */
    } PADKEY_b;
  } ;
  __IM  uint32_t  RESERVED2[7];

  union {
    __IOM uint32_t RDA;                         /*!< (@ 0x00000080) GPIO Input Register A (31-0)                               */

    struct {
      __IOM uint32_t RDA        : 32;           /*!< [31..0] GPIO31-0 read data.                                               */
    } RDA_b;
  } ;

  union {
    __IOM uint32_t RDB;                         /*!< (@ 0x00000084) GPIO Input Register B (49-32)                              */

    struct {
      __IOM uint32_t RDB        : 18;           /*!< [17..0] GPIO49-32 read data.                                              */
            uint32_t            : 14;
    } RDB_b;
  } ;

  union {
    __IOM uint32_t WTA;                         /*!< (@ 0x00000088) GPIO Output Register A (31-0)                              */

    struct {
      __IOM uint32_t WTA        : 32;           /*!< [31..0] GPIO31-0 write data.                                              */
    } WTA_b;
  } ;

  union {
    __IOM uint32_t WTB;                         /*!< (@ 0x0000008C) GPIO Output Register B (49-32)                             */

    struct {
      __IOM uint32_t WTB        : 18;           /*!< [17..0] GPIO49-32 write data.                                             */
            uint32_t            : 14;
    } WTB_b;
  } ;

  union {
    __IOM uint32_t WTSA;                        /*!< (@ 0x00000090) GPIO Output Register A Set (31-0)                          */

    struct {
      __IOM uint32_t WTSA       : 32;           /*!< [31..0] Set the GPIO31-0 write data.                                      */
    } WTSA_b;
  } ;

  union {
    __IOM uint32_t WTSB;                        /*!< (@ 0x00000094) GPIO Output Register B Set (49-32)                         */

    struct {
      __IOM uint32_t WTSB       : 18;           /*!< [17..0] Set the GPIO49-32 write data.                                     */
            uint32_t            : 14;
    } WTSB_b;
  } ;

  union {
    __IOM uint32_t WTCA;                        /*!< (@ 0x00000098) GPIO Output Register A Clear (31-0)                        */

    struct {
      __IOM uint32_t WTCA       : 32;           /*!< [31..0] Clear the GPIO31-0 write data.                                    */
    } WTCA_b;
  } ;

  union {
    __IOM uint32_t WTCB;                        /*!< (@ 0x0000009C) GPIO Output Register B Clear (49-32)                       */

    struct {
      __IOM uint32_t WTCB       : 18;           /*!< [17..0] Clear the GPIO49-32 write data.                                   */
            uint32_t            : 14;
    } WTCB_b;
  } ;

  union {
    __IOM uint32_t ENA;                         /*!< (@ 0x000000A0) GPIO Enable Register A (31-0)                              */

    struct {
      __IOM uint32_t ENA        : 32;           /*!< [31..0] GPIO31-0 output enables                                           */
    } ENA_b;
  } ;

  union {
    __IOM uint32_t ENB;                         /*!< (@ 0x000000A4) GPIO Enable Register B (49-32)                             */

    struct {
      __IOM uint32_t ENB        : 18;           /*!< [17..0] GPIO49-32 output enables                                          */
            uint32_t            : 14;
    } ENB_b;
  } ;

  union {
    __IOM uint32_t ENSA;                        /*!< (@ 0x000000A8) GPIO Enable Register A Set (31-0)                          */

    struct {
      __IOM uint32_t ENSA       : 32;           /*!< [31..0] Set the GPIO31-0 output enables                                   */
    } ENSA_b;
  } ;

  union {
    __IOM uint32_t ENSB;                        /*!< (@ 0x000000AC) GPIO Enable Register B Set (49-32)                         */

    struct {
      __IOM uint32_t ENSB       : 18;           /*!< [17..0] Set the GPIO49-32 output enables                                  */
            uint32_t            : 14;
    } ENSB_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t ENCA;                        /*!< (@ 0x000000B4) GPIO Enable Register A Clear (31-0)                        */

    struct {
      __IOM uint32_t ENCA       : 32;           /*!< [31..0] Clear the GPIO31-0 output enables                                 */
    } ENCA_b;
  } ;

  union {
    __IOM uint32_t ENCB;                        /*!< (@ 0x000000B8) GPIO Enable Register B Clear (49-32)                       */

    struct {
      __IOM uint32_t ENCB       : 18;           /*!< [17..0] Clear the GPIO49-32 output enables                                */
            uint32_t            : 14;
    } ENCB_b;
  } ;

  union {
    __IOM uint32_t STMRCAP;                     /*!< (@ 0x000000BC) STIMER Capture trigger select and enable.                  */

    struct {
      __IOM uint32_t STSEL0     : 6;            /*!< [5..0] STIMER Capture 0 Select.                                           */
      __IOM uint32_t STPOL0     : 1;            /*!< [6..6] STIMER Capture 0 Polarity.                                         */
            uint32_t            : 1;
      __IOM uint32_t STSEL1     : 6;            /*!< [13..8] STIMER Capture 1 Select.                                          */
      __IOM uint32_t STPOL1     : 1;            /*!< [14..14] STIMER Capture 1 Polarity.                                       */
            uint32_t            : 1;
      __IOM uint32_t STSEL2     : 6;            /*!< [21..16] STIMER Capture 2 Select.                                         */
      __IOM uint32_t STPOL2     : 1;            /*!< [22..22] STIMER Capture 2 Polarity.                                       */
            uint32_t            : 1;
      __IOM uint32_t STSEL3     : 6;            /*!< [29..24] STIMER Capture 3 Select.                                         */
      __IOM uint32_t STPOL3     : 1;            /*!< [30..30] STIMER Capture 3 Polarity.                                       */
            uint32_t            : 1;
    } STMRCAP_b;
  } ;

  union {
    __IOM uint32_t IOM0IRQ;                     /*!< (@ 0x000000C0) IOMSTR0 IRQ select for flow control.                       */

    struct {
      __IOM uint32_t IOM0IRQ    : 6;            /*!< [5..0] IOMSTR0 IRQ pad select.                                            */
            uint32_t            : 26;
    } IOM0IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM1IRQ;                     /*!< (@ 0x000000C4) IOMSTR1 IRQ select for flow control.                       */

    struct {
      __IOM uint32_t IOM1IRQ    : 6;            /*!< [5..0] IOMSTR1 IRQ pad select.                                            */
            uint32_t            : 26;
    } IOM1IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM2IRQ;                     /*!< (@ 0x000000C8) IOMSTR2 IRQ select for flow control.                       */

    struct {
      __IOM uint32_t IOM2IRQ    : 6;            /*!< [5..0] IOMSTR2 IRQ pad select.                                            */
            uint32_t            : 26;
    } IOM2IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM3IRQ;                     /*!< (@ 0x000000CC) IOMSTR3 IRQ select for flow control.                       */

    struct {
      __IOM uint32_t IOM3IRQ    : 6;            /*!< [5..0] IOMSTR3 IRQ pad select.                                            */
            uint32_t            : 26;
    } IOM3IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM4IRQ;                     /*!< (@ 0x000000D0) IOMSTR4 IRQ select for flow control.                       */

    struct {
      __IOM uint32_t IOM4IRQ    : 6;            /*!< [5..0] IOMSTR4 IRQ pad select.                                            */
            uint32_t            : 26;
    } IOM4IRQ_b;
  } ;

  union {
    __IOM uint32_t IOM5IRQ;                     /*!< (@ 0x000000D4) IOMSTR5 IRQ select for flow control.                       */

    struct {
      __IOM uint32_t IOM5IRQ    : 6;            /*!< [5..0] IOMSTR5 IRQ pad select.                                            */
            uint32_t            : 26;
    } IOM5IRQ_b;
  } ;

  union {
    __IOM uint32_t BLEIFIRQ;                    /*!< (@ 0x000000D8) BLE IF IRQ select for flow control.                        */

    struct {
      __IOM uint32_t BLEIFIRQ   : 6;            /*!< [5..0] BLEIF IRQ pad select.                                              */
            uint32_t            : 26;
    } BLEIFIRQ_b;
  } ;

  union {
    __IOM uint32_t GPIOOBS;                     /*!< (@ 0x000000DC) GPIO Observation mode sample register                      */

    struct {
      __IOM uint32_t OBS_DATA   : 16;           /*!< [15..0] Sample of the data output on the GPIO observation port.
                                                     May have async sampling issues, as the data is not synronized
                                                     to the read operation. Intended for debug purposes only                   */
            uint32_t            : 16;
    } GPIOOBS_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGA;                  /*!< (@ 0x000000E0) This register has additional configuration control
                                                                    for pads 3, 2, 1, 0                                        */

    struct {
      __IOM uint32_t PAD0_DS1   : 1;            /*!< [0..0] Pad 0 high order drive strength selection. Used in conjunction
                                                     with PAD0STRNG field to set the pad drive strength.                       */
            uint32_t            : 3;
      __IOM uint32_t PAD0_SR    : 1;            /*!< [4..4] Pad 0 slew rate selection.                                         */
            uint32_t            : 3;
      __IOM uint32_t PAD1_DS1   : 1;            /*!< [8..8] Pad 1 high order drive strength selection. Used in conjunction
                                                     with PAD1STRNG field to set the pad drive strength.                       */
            uint32_t            : 3;
      __IOM uint32_t PAD1_SR    : 1;            /*!< [12..12] Pad 1 slew rate selection.                                       */
            uint32_t            : 3;
      __IOM uint32_t PAD2_DS1   : 1;            /*!< [16..16] Pad 2 high order drive strength selection. Used in
                                                     conjunction with PAD2STRNG field to set the pad drive strength.           */
            uint32_t            : 3;
      __IOM uint32_t PAD2_SR    : 1;            /*!< [20..20] Pad 2 slew rate selection.                                       */
            uint32_t            : 3;
      __IOM uint32_t PAD3_DS1   : 1;            /*!< [24..24] Pad 3 high order drive strength selection. Used in
                                                     conjunction with PAD3STRNG field to set the pad drive strength.           */
            uint32_t            : 3;
      __IOM uint32_t PAD3_SR    : 1;            /*!< [28..28] Pad 3 slew rate selection.                                       */
            uint32_t            : 3;
    } ALTPADCFGA_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGB;                  /*!< (@ 0x000000E4) This register has additional configuration control
                                                                    for pads 7, 6, 5, 4                                        */

    struct {
      __IOM uint32_t PAD4_DS1   : 1;            /*!< [0..0] Pad 4 high order drive strength selection. Used in conjunction
                                                     with PAD4STRNG field to set the pad drive strength.                       */
            uint32_t            : 3;
      __IOM uint32_t PAD4_SR    : 1;            /*!< [4..4] Pad 4 slew rate selection.                                         */
            uint32_t            : 3;
      __IOM uint32_t PAD5_DS1   : 1;            /*!< [8..8] Pad 5 high order drive strength selection. Used in conjunction
                                                     with PAD5STRNG field to set the pad drive strength.                       */
            uint32_t            : 3;
      __IOM uint32_t PAD5_SR    : 1;            /*!< [12..12] Pad 5 slew rate selection.                                       */
            uint32_t            : 3;
      __IOM uint32_t PAD6_DS1   : 1;            /*!< [16..16] Pad 6 high order drive strength selection. Used in
                                                     conjunction with PAD6STRNG field to set the pad drive strength.           */
            uint32_t            : 3;
      __IOM uint32_t PAD6_SR    : 1;            /*!< [20..20] Pad 6 slew rate selection.                                       */
            uint32_t            : 3;
      __IOM uint32_t PAD7_DS1   : 1;            /*!< [24..24] Pad 7 high order drive strength selection. Used in
                                                     conjunction with PAD7STRNG field to set the pad drive strength.           */
            uint32_t            : 3;
      __IOM uint32_t PAD7_SR    : 1;            /*!< [28..28] Pad 7 slew rate selection.                                       */
            uint32_t            : 3;
    } ALTPADCFGB_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGC;                  /*!< (@ 0x000000E8) This register has additional configuration control
                                                                    for pads 11, 10, 9, 8                                      */

    struct {
      __IOM uint32_t PAD8_DS1   : 1;            /*!< [0..0] Pad 8 high order drive strength selection. Used in conjunction
                                                     with PAD8STRNG field to set the pad drive strength.                       */
            uint32_t            : 3;
      __IOM uint32_t PAD8_SR    : 1;            /*!< [4..4] Pad 8 slew rate selection.                                         */
            uint32_t            : 3;
      __IOM uint32_t PAD9_DS1   : 1;            /*!< [8..8] Pad 9 high order drive strength selection. Used in conjunction
                                                     with PAD9STRNG field to set the pad drive strength.                       */
            uint32_t            : 3;
      __IOM uint32_t PAD9_SR    : 1;            /*!< [12..12] Pad 9 slew rate selection.                                       */
            uint32_t            : 3;
      __IOM uint32_t PAD10_DS1  : 1;            /*!< [16..16] Pad 10 high order drive strength selection. Used in
                                                     conjunction with PAD10STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD10_SR   : 1;            /*!< [20..20] Pad 10 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD11_DS1  : 1;            /*!< [24..24] Pad 11 high order drive strength selection. Used in
                                                     conjunction with PAD11STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD11_SR   : 1;            /*!< [28..28] Pad 11 slew rate selection.                                      */
            uint32_t            : 3;
    } ALTPADCFGC_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGD;                  /*!< (@ 0x000000EC) This register has additional configuration control
                                                                    for pads 15, 14, 13, 12                                    */

    struct {
      __IOM uint32_t PAD12_DS1  : 1;            /*!< [0..0] Pad 12 high order drive strength selection. Used in conjunction
                                                     with PAD12STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD12_SR   : 1;            /*!< [4..4] Pad 12 slew rate selection.                                        */
            uint32_t            : 3;
      __IOM uint32_t PAD13_DS1  : 1;            /*!< [8..8] Pad 13 high order drive strength selection. Used in conjunction
                                                     with PAD13STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD13_SR   : 1;            /*!< [12..12] Pad 13 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD14_DS1  : 1;            /*!< [16..16] Pad 14 high order drive strength selection. Used in
                                                     conjunction with PAD14STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD14_SR   : 1;            /*!< [20..20] Pad 14 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD15_DS1  : 1;            /*!< [24..24] Pad 15 high order drive strength selection. Used in
                                                     conjunction with PAD15STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD15_SR   : 1;            /*!< [28..28] Pad 15 slew rate selection.                                      */
            uint32_t            : 3;
    } ALTPADCFGD_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGE;                  /*!< (@ 0x000000F0) This register has additional configuration control
                                                                    for pads 19, 18, 17, 16                                    */

    struct {
      __IOM uint32_t PAD16_DS1  : 1;            /*!< [0..0] Pad 16 high order drive strength selection. Used in conjunction
                                                     with PAD16STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD16_SR   : 1;            /*!< [4..4] Pad 16 slew rate selection.                                        */
            uint32_t            : 3;
      __IOM uint32_t PAD17_DS1  : 1;            /*!< [8..8] Pad 17 high order drive strength selection. Used in conjunction
                                                     with PAD17STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD17_SR   : 1;            /*!< [12..12] Pad 17 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD18_DS1  : 1;            /*!< [16..16] Pad 18 high order drive strength selection. Used in
                                                     conjunction with PAD18STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD18_SR   : 1;            /*!< [20..20] Pad 18 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD19_DS1  : 1;            /*!< [24..24] Pad 19 high order drive strength selection. Used in
                                                     conjunction with PAD19STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD19_SR   : 1;            /*!< [28..28] Pad 19 slew rate selection.                                      */
            uint32_t            : 3;
    } ALTPADCFGE_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGF;                  /*!< (@ 0x000000F4) This register has additional configuration control
                                                                    for pads 23, 22, 21, 20                                    */

    struct {
      __IOM uint32_t PAD20_DS1  : 1;            /*!< [0..0] Pad 20 high order drive strength selection. Used in conjunction
                                                     with PAD20STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD20_SR   : 1;            /*!< [4..4] Pad 20 slew rate selection.                                        */
            uint32_t            : 3;
      __IOM uint32_t PAD21_DS1  : 1;            /*!< [8..8] Pad 21 high order drive strength selection. Used in conjunction
                                                     with PAD21STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD21_SR   : 1;            /*!< [12..12] Pad 21 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD22_DS1  : 1;            /*!< [16..16] Pad 22 high order drive strength selection. Used in
                                                     conjunction with PAD22STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD22_SR   : 1;            /*!< [20..20] Pad 22 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD23_DS1  : 1;            /*!< [24..24] Pad 23 high order drive strength selection. Used in
                                                     conjunction with PAD23STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD23_SR   : 1;            /*!< [28..28] Pad 23 slew rate selection.                                      */
            uint32_t            : 3;
    } ALTPADCFGF_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGG;                  /*!< (@ 0x000000F8) This register has additional configuration control
                                                                    for pads 27, 26, 25, 24                                    */

    struct {
      __IOM uint32_t PAD24_DS1  : 1;            /*!< [0..0] Pad 24 high order drive strength selection. Used in conjunction
                                                     with PAD24STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD24_SR   : 1;            /*!< [4..4] Pad 24 slew rate selection.                                        */
            uint32_t            : 3;
      __IOM uint32_t PAD25_DS1  : 1;            /*!< [8..8] Pad 25 high order drive strength selection. Used in conjunction
                                                     with PAD25STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD25_SR   : 1;            /*!< [12..12] Pad 25 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD26_DS1  : 1;            /*!< [16..16] Pad 26 high order drive strength selection. Used in
                                                     conjunction with PAD26STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD26_SR   : 1;            /*!< [20..20] Pad 26 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD27_DS1  : 1;            /*!< [24..24] Pad 27 high order drive strength selection. Used in
                                                     conjunction with PAD27STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD27_SR   : 1;            /*!< [28..28] Pad 27 slew rate selection.                                      */
            uint32_t            : 3;
    } ALTPADCFGG_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGH;                  /*!< (@ 0x000000FC) This register has additional configuration control
                                                                    for pads 31, 30, 29, 28                                    */

    struct {
      __IOM uint32_t PAD28_DS1  : 1;            /*!< [0..0] Pad 28 high order drive strength selection. Used in conjunction
                                                     with PAD28STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD28_SR   : 1;            /*!< [4..4] Pad 28 slew rate selection.                                        */
            uint32_t            : 3;
      __IOM uint32_t PAD29_DS1  : 1;            /*!< [8..8] Pad 29 high order drive strength selection. Used in conjunction
                                                     with PAD29STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD29_SR   : 1;            /*!< [12..12] Pad 29 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD30_DS1  : 1;            /*!< [16..16] Pad 30 high order drive strength selection. Used in
                                                     conjunction with PAD30STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD30_SR   : 1;            /*!< [20..20] Pad 30 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD31_DS1  : 1;            /*!< [24..24] Pad 31 high order drive strength selection. Used in
                                                     conjunction with PAD31STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD31_SR   : 1;            /*!< [28..28] Pad 31 slew rate selection.                                      */
            uint32_t            : 3;
    } ALTPADCFGH_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGI;                  /*!< (@ 0x00000100) This register has additional configuration control
                                                                    for pads 35, 34, 33, 32                                    */

    struct {
      __IOM uint32_t PAD32_DS1  : 1;            /*!< [0..0] Pad 32 high order drive strength selection. Used in conjunction
                                                     with PAD32STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD32_SR   : 1;            /*!< [4..4] Pad 32 slew rate selection.                                        */
            uint32_t            : 3;
      __IOM uint32_t PAD33_DS1  : 1;            /*!< [8..8] Pad 33 high order drive strength selection. Used in conjunction
                                                     with PAD33STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD33_SR   : 1;            /*!< [12..12] Pad 33 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD34_DS1  : 1;            /*!< [16..16] Pad 34 high order drive strength selection. Used in
                                                     conjunction with PAD34STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD34_SR   : 1;            /*!< [20..20] Pad 34 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD35_DS1  : 1;            /*!< [24..24] Pad 35 high order drive strength selection. Used in
                                                     conjunction with PAD35STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD35_SR   : 1;            /*!< [28..28] Pad 35 slew rate selection.                                      */
            uint32_t            : 3;
    } ALTPADCFGI_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGJ;                  /*!< (@ 0x00000104) This register has additional configuration control
                                                                    for pads 39, 38, 37, 36                                    */

    struct {
      __IOM uint32_t PAD36_DS1  : 1;            /*!< [0..0] Pad 36 high order drive strength selection. Used in conjunction
                                                     with PAD36STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD36_SR   : 1;            /*!< [4..4] Pad 36 slew rate selection.                                        */
            uint32_t            : 3;
      __IOM uint32_t PAD37_DS1  : 1;            /*!< [8..8] Pad 37 high order drive strength selection. Used in conjunction
                                                     with PAD37STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD37_SR   : 1;            /*!< [12..12] Pad 37 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD38_DS1  : 1;            /*!< [16..16] Pad 38 high order drive strength selection. Used in
                                                     conjunction with PAD38STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD38_SR   : 1;            /*!< [20..20] Pad 38 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD39_DS1  : 1;            /*!< [24..24] Pad 39 high order drive strength selection. Used in
                                                     conjunction with PAD39STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD39_SR   : 1;            /*!< [28..28] Pad 39 slew rate selection.                                      */
            uint32_t            : 3;
    } ALTPADCFGJ_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGK;                  /*!< (@ 0x00000108) This register has additional configuration control
                                                                    for pads 43, 42, 41, 40                                    */

    struct {
      __IOM uint32_t PAD40_DS1  : 1;            /*!< [0..0] Pad 40 high order drive strength selection. Used in conjunction
                                                     with PAD40STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD40_SR   : 1;            /*!< [4..4] Pad 40 slew rate selection.                                        */
            uint32_t            : 3;
      __IOM uint32_t PAD41_DS1  : 1;            /*!< [8..8] Pad 41 high order drive strength selection. Used in conjunction
                                                     with PAD41STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD41_SR   : 1;            /*!< [12..12] Pad 41 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD42_DS1  : 1;            /*!< [16..16] Pad 42 high order drive strength selection. Used in
                                                     conjunction with PAD42STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD42_SR   : 1;            /*!< [20..20] Pad 42 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD43_DS1  : 1;            /*!< [24..24] Pad 43 high order drive strength selection. Used in
                                                     conjunction with PAD43STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD43_SR   : 1;            /*!< [28..28] Pad 43 slew rate selection.                                      */
            uint32_t            : 3;
    } ALTPADCFGK_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGL;                  /*!< (@ 0x0000010C) This register has additional configuration control
                                                                    for pads 47, 46, 45, 44                                    */

    struct {
      __IOM uint32_t PAD44_DS1  : 1;            /*!< [0..0] Pad 44 high order drive strength selection. Used in conjunction
                                                     with PAD44STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD44_SR   : 1;            /*!< [4..4] Pad 44 slew rate selection.                                        */
            uint32_t            : 3;
      __IOM uint32_t PAD45_DS1  : 1;            /*!< [8..8] Pad 45 high order drive strength selection. Used in conjunction
                                                     with PAD45STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD45_SR   : 1;            /*!< [12..12] Pad 45 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD46_DS1  : 1;            /*!< [16..16] Pad 46 high order drive strength selection. Used in
                                                     conjunction with PAD46STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD46_SR   : 1;            /*!< [20..20] Pad 46 slew rate selection.                                      */
            uint32_t            : 3;
      __IOM uint32_t PAD47_DS1  : 1;            /*!< [24..24] Pad 47 high order drive strength selection. Used in
                                                     conjunction with PAD47STRNG field to set the pad drive
                                                     strength.                                                                 */
            uint32_t            : 3;
      __IOM uint32_t PAD47_SR   : 1;            /*!< [28..28] Pad 47 slew rate selection.                                      */
            uint32_t            : 3;
    } ALTPADCFGL_b;
  } ;

  union {
    __IOM uint32_t ALTPADCFGM;                  /*!< (@ 0x00000110) This register has additional configuration control
                                                                    for pads 49, 48                                            */

    struct {
      __IOM uint32_t PAD48_DS1  : 1;            /*!< [0..0] Pad 48 high order drive strength selection. Used in conjunction
                                                     with PAD48STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD48_SR   : 1;            /*!< [4..4] Pad 48 slew rate selection.                                        */
            uint32_t            : 3;
      __IOM uint32_t PAD49_DS1  : 1;            /*!< [8..8] Pad 49 high order drive strength selection. Used in conjunction
                                                     with PAD49STRNG field to set the pad drive strength.                      */
            uint32_t            : 3;
      __IOM uint32_t PAD49_SR   : 1;            /*!< [12..12] Pad 49 slew rate selection.                                      */
            uint32_t            : 19;
    } ALTPADCFGM_b;
  } ;

  union {
    __IOM uint32_t SCDET;                       /*!< (@ 0x00000114) Scard card detect select.                                  */

    struct {
      __IOM uint32_t SCDET      : 6;            /*!< [5..0] SCARD card detect pad select.                                      */
            uint32_t            : 26;
    } SCDET_b;
  } ;

  union {
    __IOM uint32_t CTENCFG;                     /*!< (@ 0x00000118) Pad enable configuration.                                  */

    struct {
      __IOM uint32_t EN0        : 1;            /*!< [0..0] CT0 Enable                                                         */
      __IOM uint32_t EN1        : 1;            /*!< [1..1] CT1 Enable                                                         */
      __IOM uint32_t EN2        : 1;            /*!< [2..2] CT2 Enable                                                         */
      __IOM uint32_t EN3        : 1;            /*!< [3..3] CT3 Enable                                                         */
      __IOM uint32_t EN4        : 1;            /*!< [4..4] CT4 Enable                                                         */
      __IOM uint32_t EN5        : 1;            /*!< [5..5] CT5 Enable                                                         */
      __IOM uint32_t EN6        : 1;            /*!< [6..6] CT6 Enable                                                         */
      __IOM uint32_t EN7        : 1;            /*!< [7..7] CT7 Enable                                                         */
      __IOM uint32_t EN8        : 1;            /*!< [8..8] CT8 Enable                                                         */
      __IOM uint32_t EN9        : 1;            /*!< [9..9] CT9 Enable                                                         */
      __IOM uint32_t EN10       : 1;            /*!< [10..10] CT10 Enable                                                      */
      __IOM uint32_t EN11       : 1;            /*!< [11..11] CT11 Enable                                                      */
      __IOM uint32_t EN12       : 1;            /*!< [12..12] CT12 Enable                                                      */
      __IOM uint32_t EN13       : 1;            /*!< [13..13] CT13 Enable                                                      */
      __IOM uint32_t EN14       : 1;            /*!< [14..14] CT14 Enable                                                      */
      __IOM uint32_t EN15       : 1;            /*!< [15..15] CT15 Enable                                                      */
      __IOM uint32_t EN16       : 1;            /*!< [16..16] CT16 Enable                                                      */
      __IOM uint32_t EN17       : 1;            /*!< [17..17] CT17 Enable                                                      */
      __IOM uint32_t EN18       : 1;            /*!< [18..18] CT18 Enable                                                      */
      __IOM uint32_t EN19       : 1;            /*!< [19..19] CT19 Enable                                                      */
      __IOM uint32_t EN20       : 1;            /*!< [20..20] CT20 Enable                                                      */
      __IOM uint32_t EN21       : 1;            /*!< [21..21] CT21 Enable                                                      */
      __IOM uint32_t EN22       : 1;            /*!< [22..22] CT22 Enable                                                      */
      __IOM uint32_t EN23       : 1;            /*!< [23..23] CT23 Enable                                                      */
      __IOM uint32_t EN24       : 1;            /*!< [24..24] CT24 Enable                                                      */
      __IOM uint32_t EN25       : 1;            /*!< [25..25] CT25 Enable                                                      */
      __IOM uint32_t EN26       : 1;            /*!< [26..26] CT26 Enable                                                      */
      __IOM uint32_t EN27       : 1;            /*!< [27..27] CT27 Enable                                                      */
      __IOM uint32_t EN28       : 1;            /*!< [28..28] CT28 Enable                                                      */
      __IOM uint32_t EN29       : 1;            /*!< [29..29] CT29 Enable                                                      */
      __IOM uint32_t EN30       : 1;            /*!< [30..30] CT30 Enable                                                      */
      __IOM uint32_t EN31       : 1;            /*!< [31..31] CT31 Enable                                                      */
    } CTENCFG_b;
  } ;
  __IM  uint32_t  RESERVED4[57];

  union {
    __IOM uint32_t INT0EN;                      /*!< (@ 0x00000200) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< [0..0] GPIO0 interrupt.                                                   */
      __IOM uint32_t GPIO1      : 1;            /*!< [1..1] GPIO1 interrupt.                                                   */
      __IOM uint32_t GPIO2      : 1;            /*!< [2..2] GPIO2 interrupt.                                                   */
      __IOM uint32_t GPIO3      : 1;            /*!< [3..3] GPIO3 interrupt.                                                   */
      __IOM uint32_t GPIO4      : 1;            /*!< [4..4] GPIO4 interrupt.                                                   */
      __IOM uint32_t GPIO5      : 1;            /*!< [5..5] GPIO5 interrupt.                                                   */
      __IOM uint32_t GPIO6      : 1;            /*!< [6..6] GPIO6 interrupt.                                                   */
      __IOM uint32_t GPIO7      : 1;            /*!< [7..7] GPIO7 interrupt.                                                   */
      __IOM uint32_t GPIO8      : 1;            /*!< [8..8] GPIO8 interrupt.                                                   */
      __IOM uint32_t GPIO9      : 1;            /*!< [9..9] GPIO9 interrupt.                                                   */
      __IOM uint32_t GPIO10     : 1;            /*!< [10..10] GPIO10 interrupt.                                                */
      __IOM uint32_t GPIO11     : 1;            /*!< [11..11] GPIO11 interrupt.                                                */
      __IOM uint32_t GPIO12     : 1;            /*!< [12..12] GPIO12 interrupt.                                                */
      __IOM uint32_t GPIO13     : 1;            /*!< [13..13] GPIO13 interrupt.                                                */
      __IOM uint32_t GPIO14     : 1;            /*!< [14..14] GPIO14 interrupt.                                                */
      __IOM uint32_t GPIO15     : 1;            /*!< [15..15] GPIO15 interrupt.                                                */
      __IOM uint32_t GPIO16     : 1;            /*!< [16..16] GPIO16 interrupt.                                                */
      __IOM uint32_t GPIO17     : 1;            /*!< [17..17] GPIO17 interrupt.                                                */
      __IOM uint32_t GPIO18     : 1;            /*!< [18..18] GPIO18interrupt.                                                 */
      __IOM uint32_t GPIO19     : 1;            /*!< [19..19] GPIO19 interrupt.                                                */
      __IOM uint32_t GPIO20     : 1;            /*!< [20..20] GPIO20 interrupt.                                                */
      __IOM uint32_t GPIO21     : 1;            /*!< [21..21] GPIO21 interrupt.                                                */
      __IOM uint32_t GPIO22     : 1;            /*!< [22..22] GPIO22 interrupt.                                                */
      __IOM uint32_t GPIO23     : 1;            /*!< [23..23] GPIO23 interrupt.                                                */
      __IOM uint32_t GPIO24     : 1;            /*!< [24..24] GPIO24 interrupt.                                                */
      __IOM uint32_t GPIO25     : 1;            /*!< [25..25] GPIO25 interrupt.                                                */
      __IOM uint32_t GPIO26     : 1;            /*!< [26..26] GPIO26 interrupt.                                                */
      __IOM uint32_t GPIO27     : 1;            /*!< [27..27] GPIO27 interrupt.                                                */
      __IOM uint32_t GPIO28     : 1;            /*!< [28..28] GPIO28 interrupt.                                                */
      __IOM uint32_t GPIO29     : 1;            /*!< [29..29] GPIO29 interrupt.                                                */
      __IOM uint32_t GPIO30     : 1;            /*!< [30..30] GPIO30 interrupt.                                                */
      __IOM uint32_t GPIO31     : 1;            /*!< [31..31] GPIO31 interrupt.                                                */
    } INT0EN_b;
  } ;

  union {
    __IOM uint32_t INT0STAT;                    /*!< (@ 0x00000204) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< [0..0] GPIO0 interrupt.                                                   */
      __IOM uint32_t GPIO1      : 1;            /*!< [1..1] GPIO1 interrupt.                                                   */
      __IOM uint32_t GPIO2      : 1;            /*!< [2..2] GPIO2 interrupt.                                                   */
      __IOM uint32_t GPIO3      : 1;            /*!< [3..3] GPIO3 interrupt.                                                   */
      __IOM uint32_t GPIO4      : 1;            /*!< [4..4] GPIO4 interrupt.                                                   */
      __IOM uint32_t GPIO5      : 1;            /*!< [5..5] GPIO5 interrupt.                                                   */
      __IOM uint32_t GPIO6      : 1;            /*!< [6..6] GPIO6 interrupt.                                                   */
      __IOM uint32_t GPIO7      : 1;            /*!< [7..7] GPIO7 interrupt.                                                   */
      __IOM uint32_t GPIO8      : 1;            /*!< [8..8] GPIO8 interrupt.                                                   */
      __IOM uint32_t GPIO9      : 1;            /*!< [9..9] GPIO9 interrupt.                                                   */
      __IOM uint32_t GPIO10     : 1;            /*!< [10..10] GPIO10 interrupt.                                                */
      __IOM uint32_t GPIO11     : 1;            /*!< [11..11] GPIO11 interrupt.                                                */
      __IOM uint32_t GPIO12     : 1;            /*!< [12..12] GPIO12 interrupt.                                                */
      __IOM uint32_t GPIO13     : 1;            /*!< [13..13] GPIO13 interrupt.                                                */
      __IOM uint32_t GPIO14     : 1;            /*!< [14..14] GPIO14 interrupt.                                                */
      __IOM uint32_t GPIO15     : 1;            /*!< [15..15] GPIO15 interrupt.                                                */
      __IOM uint32_t GPIO16     : 1;            /*!< [16..16] GPIO16 interrupt.                                                */
      __IOM uint32_t GPIO17     : 1;            /*!< [17..17] GPIO17 interrupt.                                                */
      __IOM uint32_t GPIO18     : 1;            /*!< [18..18] GPIO18interrupt.                                                 */
      __IOM uint32_t GPIO19     : 1;            /*!< [19..19] GPIO19 interrupt.                                                */
      __IOM uint32_t GPIO20     : 1;            /*!< [20..20] GPIO20 interrupt.                                                */
      __IOM uint32_t GPIO21     : 1;            /*!< [21..21] GPIO21 interrupt.                                                */
      __IOM uint32_t GPIO22     : 1;            /*!< [22..22] GPIO22 interrupt.                                                */
      __IOM uint32_t GPIO23     : 1;            /*!< [23..23] GPIO23 interrupt.                                                */
      __IOM uint32_t GPIO24     : 1;            /*!< [24..24] GPIO24 interrupt.                                                */
      __IOM uint32_t GPIO25     : 1;            /*!< [25..25] GPIO25 interrupt.                                                */
      __IOM uint32_t GPIO26     : 1;            /*!< [26..26] GPIO26 interrupt.                                                */
      __IOM uint32_t GPIO27     : 1;            /*!< [27..27] GPIO27 interrupt.                                                */
      __IOM uint32_t GPIO28     : 1;            /*!< [28..28] GPIO28 interrupt.                                                */
      __IOM uint32_t GPIO29     : 1;            /*!< [29..29] GPIO29 interrupt.                                                */
      __IOM uint32_t GPIO30     : 1;            /*!< [30..30] GPIO30 interrupt.                                                */
      __IOM uint32_t GPIO31     : 1;            /*!< [31..31] GPIO31 interrupt.                                                */
    } INT0STAT_b;
  } ;

  union {
    __IOM uint32_t INT0CLR;                     /*!< (@ 0x00000208) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< [0..0] GPIO0 interrupt.                                                   */
      __IOM uint32_t GPIO1      : 1;            /*!< [1..1] GPIO1 interrupt.                                                   */
      __IOM uint32_t GPIO2      : 1;            /*!< [2..2] GPIO2 interrupt.                                                   */
      __IOM uint32_t GPIO3      : 1;            /*!< [3..3] GPIO3 interrupt.                                                   */
      __IOM uint32_t GPIO4      : 1;            /*!< [4..4] GPIO4 interrupt.                                                   */
      __IOM uint32_t GPIO5      : 1;            /*!< [5..5] GPIO5 interrupt.                                                   */
      __IOM uint32_t GPIO6      : 1;            /*!< [6..6] GPIO6 interrupt.                                                   */
      __IOM uint32_t GPIO7      : 1;            /*!< [7..7] GPIO7 interrupt.                                                   */
      __IOM uint32_t GPIO8      : 1;            /*!< [8..8] GPIO8 interrupt.                                                   */
      __IOM uint32_t GPIO9      : 1;            /*!< [9..9] GPIO9 interrupt.                                                   */
      __IOM uint32_t GPIO10     : 1;            /*!< [10..10] GPIO10 interrupt.                                                */
      __IOM uint32_t GPIO11     : 1;            /*!< [11..11] GPIO11 interrupt.                                                */
      __IOM uint32_t GPIO12     : 1;            /*!< [12..12] GPIO12 interrupt.                                                */
      __IOM uint32_t GPIO13     : 1;            /*!< [13..13] GPIO13 interrupt.                                                */
      __IOM uint32_t GPIO14     : 1;            /*!< [14..14] GPIO14 interrupt.                                                */
      __IOM uint32_t GPIO15     : 1;            /*!< [15..15] GPIO15 interrupt.                                                */
      __IOM uint32_t GPIO16     : 1;            /*!< [16..16] GPIO16 interrupt.                                                */
      __IOM uint32_t GPIO17     : 1;            /*!< [17..17] GPIO17 interrupt.                                                */
      __IOM uint32_t GPIO18     : 1;            /*!< [18..18] GPIO18interrupt.                                                 */
      __IOM uint32_t GPIO19     : 1;            /*!< [19..19] GPIO19 interrupt.                                                */
      __IOM uint32_t GPIO20     : 1;            /*!< [20..20] GPIO20 interrupt.                                                */
      __IOM uint32_t GPIO21     : 1;            /*!< [21..21] GPIO21 interrupt.                                                */
      __IOM uint32_t GPIO22     : 1;            /*!< [22..22] GPIO22 interrupt.                                                */
      __IOM uint32_t GPIO23     : 1;            /*!< [23..23] GPIO23 interrupt.                                                */
      __IOM uint32_t GPIO24     : 1;            /*!< [24..24] GPIO24 interrupt.                                                */
      __IOM uint32_t GPIO25     : 1;            /*!< [25..25] GPIO25 interrupt.                                                */
      __IOM uint32_t GPIO26     : 1;            /*!< [26..26] GPIO26 interrupt.                                                */
      __IOM uint32_t GPIO27     : 1;            /*!< [27..27] GPIO27 interrupt.                                                */
      __IOM uint32_t GPIO28     : 1;            /*!< [28..28] GPIO28 interrupt.                                                */
      __IOM uint32_t GPIO29     : 1;            /*!< [29..29] GPIO29 interrupt.                                                */
      __IOM uint32_t GPIO30     : 1;            /*!< [30..30] GPIO30 interrupt.                                                */
      __IOM uint32_t GPIO31     : 1;            /*!< [31..31] GPIO31 interrupt.                                                */
    } INT0CLR_b;
  } ;

  union {
    __IOM uint32_t INT0SET;                     /*!< (@ 0x0000020C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< [0..0] GPIO0 interrupt.                                                   */
      __IOM uint32_t GPIO1      : 1;            /*!< [1..1] GPIO1 interrupt.                                                   */
      __IOM uint32_t GPIO2      : 1;            /*!< [2..2] GPIO2 interrupt.                                                   */
      __IOM uint32_t GPIO3      : 1;            /*!< [3..3] GPIO3 interrupt.                                                   */
      __IOM uint32_t GPIO4      : 1;            /*!< [4..4] GPIO4 interrupt.                                                   */
      __IOM uint32_t GPIO5      : 1;            /*!< [5..5] GPIO5 interrupt.                                                   */
      __IOM uint32_t GPIO6      : 1;            /*!< [6..6] GPIO6 interrupt.                                                   */
      __IOM uint32_t GPIO7      : 1;            /*!< [7..7] GPIO7 interrupt.                                                   */
      __IOM uint32_t GPIO8      : 1;            /*!< [8..8] GPIO8 interrupt.                                                   */
      __IOM uint32_t GPIO9      : 1;            /*!< [9..9] GPIO9 interrupt.                                                   */
      __IOM uint32_t GPIO10     : 1;            /*!< [10..10] GPIO10 interrupt.                                                */
      __IOM uint32_t GPIO11     : 1;            /*!< [11..11] GPIO11 interrupt.                                                */
      __IOM uint32_t GPIO12     : 1;            /*!< [12..12] GPIO12 interrupt.                                                */
      __IOM uint32_t GPIO13     : 1;            /*!< [13..13] GPIO13 interrupt.                                                */
      __IOM uint32_t GPIO14     : 1;            /*!< [14..14] GPIO14 interrupt.                                                */
      __IOM uint32_t GPIO15     : 1;            /*!< [15..15] GPIO15 interrupt.                                                */
      __IOM uint32_t GPIO16     : 1;            /*!< [16..16] GPIO16 interrupt.                                                */
      __IOM uint32_t GPIO17     : 1;            /*!< [17..17] GPIO17 interrupt.                                                */
      __IOM uint32_t GPIO18     : 1;            /*!< [18..18] GPIO18interrupt.                                                 */
      __IOM uint32_t GPIO19     : 1;            /*!< [19..19] GPIO19 interrupt.                                                */
      __IOM uint32_t GPIO20     : 1;            /*!< [20..20] GPIO20 interrupt.                                                */
      __IOM uint32_t GPIO21     : 1;            /*!< [21..21] GPIO21 interrupt.                                                */
      __IOM uint32_t GPIO22     : 1;            /*!< [22..22] GPIO22 interrupt.                                                */
      __IOM uint32_t GPIO23     : 1;            /*!< [23..23] GPIO23 interrupt.                                                */
      __IOM uint32_t GPIO24     : 1;            /*!< [24..24] GPIO24 interrupt.                                                */
      __IOM uint32_t GPIO25     : 1;            /*!< [25..25] GPIO25 interrupt.                                                */
      __IOM uint32_t GPIO26     : 1;            /*!< [26..26] GPIO26 interrupt.                                                */
      __IOM uint32_t GPIO27     : 1;            /*!< [27..27] GPIO27 interrupt.                                                */
      __IOM uint32_t GPIO28     : 1;            /*!< [28..28] GPIO28 interrupt.                                                */
      __IOM uint32_t GPIO29     : 1;            /*!< [29..29] GPIO29 interrupt.                                                */
      __IOM uint32_t GPIO30     : 1;            /*!< [30..30] GPIO30 interrupt.                                                */
      __IOM uint32_t GPIO31     : 1;            /*!< [31..31] GPIO31 interrupt.                                                */
    } INT0SET_b;
  } ;

  union {
    __IOM uint32_t INT1EN;                      /*!< (@ 0x00000210) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< [0..0] GPIO32 interrupt.                                                  */
      __IOM uint32_t GPIO33     : 1;            /*!< [1..1] GPIO33 interrupt.                                                  */
      __IOM uint32_t GPIO34     : 1;            /*!< [2..2] GPIO34 interrupt.                                                  */
      __IOM uint32_t GPIO35     : 1;            /*!< [3..3] GPIO35 interrupt.                                                  */
      __IOM uint32_t GPIO36     : 1;            /*!< [4..4] GPIO36 interrupt.                                                  */
      __IOM uint32_t GPIO37     : 1;            /*!< [5..5] GPIO37 interrupt.                                                  */
      __IOM uint32_t GPIO38     : 1;            /*!< [6..6] GPIO38 interrupt.                                                  */
      __IOM uint32_t GPIO39     : 1;            /*!< [7..7] GPIO39 interrupt.                                                  */
      __IOM uint32_t GPIO40     : 1;            /*!< [8..8] GPIO40 interrupt.                                                  */
      __IOM uint32_t GPIO41     : 1;            /*!< [9..9] GPIO41 interrupt.                                                  */
      __IOM uint32_t GPIO42     : 1;            /*!< [10..10] GPIO42 interrupt.                                                */
      __IOM uint32_t GPIO43     : 1;            /*!< [11..11] GPIO43 interrupt.                                                */
      __IOM uint32_t GPIO44     : 1;            /*!< [12..12] GPIO44 interrupt.                                                */
      __IOM uint32_t GPIO45     : 1;            /*!< [13..13] GPIO45 interrupt.                                                */
      __IOM uint32_t GPIO46     : 1;            /*!< [14..14] GPIO46 interrupt.                                                */
      __IOM uint32_t GPIO47     : 1;            /*!< [15..15] GPIO47 interrupt.                                                */
      __IOM uint32_t GPIO48     : 1;            /*!< [16..16] GPIO48 interrupt.                                                */
      __IOM uint32_t GPIO49     : 1;            /*!< [17..17] GPIO49 interrupt.                                                */
            uint32_t            : 14;
    } INT1EN_b;
  } ;

  union {
    __IOM uint32_t INT1STAT;                    /*!< (@ 0x00000214) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< [0..0] GPIO32 interrupt.                                                  */
      __IOM uint32_t GPIO33     : 1;            /*!< [1..1] GPIO33 interrupt.                                                  */
      __IOM uint32_t GPIO34     : 1;            /*!< [2..2] GPIO34 interrupt.                                                  */
      __IOM uint32_t GPIO35     : 1;            /*!< [3..3] GPIO35 interrupt.                                                  */
      __IOM uint32_t GPIO36     : 1;            /*!< [4..4] GPIO36 interrupt.                                                  */
      __IOM uint32_t GPIO37     : 1;            /*!< [5..5] GPIO37 interrupt.                                                  */
      __IOM uint32_t GPIO38     : 1;            /*!< [6..6] GPIO38 interrupt.                                                  */
      __IOM uint32_t GPIO39     : 1;            /*!< [7..7] GPIO39 interrupt.                                                  */
      __IOM uint32_t GPIO40     : 1;            /*!< [8..8] GPIO40 interrupt.                                                  */
      __IOM uint32_t GPIO41     : 1;            /*!< [9..9] GPIO41 interrupt.                                                  */
      __IOM uint32_t GPIO42     : 1;            /*!< [10..10] GPIO42 interrupt.                                                */
      __IOM uint32_t GPIO43     : 1;            /*!< [11..11] GPIO43 interrupt.                                                */
      __IOM uint32_t GPIO44     : 1;            /*!< [12..12] GPIO44 interrupt.                                                */
      __IOM uint32_t GPIO45     : 1;            /*!< [13..13] GPIO45 interrupt.                                                */
      __IOM uint32_t GPIO46     : 1;            /*!< [14..14] GPIO46 interrupt.                                                */
      __IOM uint32_t GPIO47     : 1;            /*!< [15..15] GPIO47 interrupt.                                                */
      __IOM uint32_t GPIO48     : 1;            /*!< [16..16] GPIO48 interrupt.                                                */
      __IOM uint32_t GPIO49     : 1;            /*!< [17..17] GPIO49 interrupt.                                                */
            uint32_t            : 14;
    } INT1STAT_b;
  } ;

  union {
    __IOM uint32_t INT1CLR;                     /*!< (@ 0x00000218) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< [0..0] GPIO32 interrupt.                                                  */
      __IOM uint32_t GPIO33     : 1;            /*!< [1..1] GPIO33 interrupt.                                                  */
      __IOM uint32_t GPIO34     : 1;            /*!< [2..2] GPIO34 interrupt.                                                  */
      __IOM uint32_t GPIO35     : 1;            /*!< [3..3] GPIO35 interrupt.                                                  */
      __IOM uint32_t GPIO36     : 1;            /*!< [4..4] GPIO36 interrupt.                                                  */
      __IOM uint32_t GPIO37     : 1;            /*!< [5..5] GPIO37 interrupt.                                                  */
      __IOM uint32_t GPIO38     : 1;            /*!< [6..6] GPIO38 interrupt.                                                  */
      __IOM uint32_t GPIO39     : 1;            /*!< [7..7] GPIO39 interrupt.                                                  */
      __IOM uint32_t GPIO40     : 1;            /*!< [8..8] GPIO40 interrupt.                                                  */
      __IOM uint32_t GPIO41     : 1;            /*!< [9..9] GPIO41 interrupt.                                                  */
      __IOM uint32_t GPIO42     : 1;            /*!< [10..10] GPIO42 interrupt.                                                */
      __IOM uint32_t GPIO43     : 1;            /*!< [11..11] GPIO43 interrupt.                                                */
      __IOM uint32_t GPIO44     : 1;            /*!< [12..12] GPIO44 interrupt.                                                */
      __IOM uint32_t GPIO45     : 1;            /*!< [13..13] GPIO45 interrupt.                                                */
      __IOM uint32_t GPIO46     : 1;            /*!< [14..14] GPIO46 interrupt.                                                */
      __IOM uint32_t GPIO47     : 1;            /*!< [15..15] GPIO47 interrupt.                                                */
      __IOM uint32_t GPIO48     : 1;            /*!< [16..16] GPIO48 interrupt.                                                */
      __IOM uint32_t GPIO49     : 1;            /*!< [17..17] GPIO49 interrupt.                                                */
            uint32_t            : 14;
    } INT1CLR_b;
  } ;

  union {
    __IOM uint32_t INT1SET;                     /*!< (@ 0x0000021C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< [0..0] GPIO32 interrupt.                                                  */
      __IOM uint32_t GPIO33     : 1;            /*!< [1..1] GPIO33 interrupt.                                                  */
      __IOM uint32_t GPIO34     : 1;            /*!< [2..2] GPIO34 interrupt.                                                  */
      __IOM uint32_t GPIO35     : 1;            /*!< [3..3] GPIO35 interrupt.                                                  */
      __IOM uint32_t GPIO36     : 1;            /*!< [4..4] GPIO36 interrupt.                                                  */
      __IOM uint32_t GPIO37     : 1;            /*!< [5..5] GPIO37 interrupt.                                                  */
      __IOM uint32_t GPIO38     : 1;            /*!< [6..6] GPIO38 interrupt.                                                  */
      __IOM uint32_t GPIO39     : 1;            /*!< [7..7] GPIO39 interrupt.                                                  */
      __IOM uint32_t GPIO40     : 1;            /*!< [8..8] GPIO40 interrupt.                                                  */
      __IOM uint32_t GPIO41     : 1;            /*!< [9..9] GPIO41 interrupt.                                                  */
      __IOM uint32_t GPIO42     : 1;            /*!< [10..10] GPIO42 interrupt.                                                */
      __IOM uint32_t GPIO43     : 1;            /*!< [11..11] GPIO43 interrupt.                                                */
      __IOM uint32_t GPIO44     : 1;            /*!< [12..12] GPIO44 interrupt.                                                */
      __IOM uint32_t GPIO45     : 1;            /*!< [13..13] GPIO45 interrupt.                                                */
      __IOM uint32_t GPIO46     : 1;            /*!< [14..14] GPIO46 interrupt.                                                */
      __IOM uint32_t GPIO47     : 1;            /*!< [15..15] GPIO47 interrupt.                                                */
      __IOM uint32_t GPIO48     : 1;            /*!< [16..16] GPIO48 interrupt.                                                */
      __IOM uint32_t GPIO49     : 1;            /*!< [17..17] GPIO49 interrupt.                                                */
            uint32_t            : 14;
    } INT1SET_b;
  } ;
} GPIO_Type;                                    /*!< Size = 544 (0x220)                                                        */



/* =========================================================================================================================== */
/* ================                                           IOM0                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief IO Peripheral Master (IOM0)
  */

typedef struct {                                /*!< (@ 0x50004000) IOM0 Structure                                             */

  union {
    __IOM uint32_t FIFO;                        /*!< (@ 0x00000000) Provides direct random access to both output
                                                                    and input FIFOs. The state of the FIFO is
                                                                    not disturbed by reading these locations
                                                                    (i.e., no POP will be done). FIFO0 is accessible
                                                                    from addresses 0x0 - 0x1C, and is used for
                                                                    data output from the IOM to external devices.
                                                                    These FIFO locations can be read and written
                                                                    directly.FIFO1 locations 0x20 - 0x3C provide
                                                                    read only access to the input FIFO. These
                                                                    FIFO locations cannot be directly written
                                                                    by the MCU and are updated only by the internal
                                                                    hardwa                                                     */

    struct {
      __IOM uint32_t FIFO       : 32;           /*!< [31..0] FIFO direct access. Only locations 0 - 3F will return
                                                     valid information.                                                        */
    } FIFO_b;
  } ;
  __IM  uint32_t  RESERVED[63];

  union {
    __IOM uint32_t FIFOPTR;                     /*!< (@ 0x00000100) Provides the current valid byte count of data
                                                                    within the FIFO as seen from the internal
                                                                    state machines. FIFO0 is dedicated to outgoing
                                                                    transactions and FIFO1 is dedicated to incoming
                                                                    transactions. All counts are specified in
                                                                    units of bytes.                                            */

    struct {
      __IOM uint32_t FIFO0SIZ   : 8;            /*!< [7..0] The number of valid data bytes currently in the FIFO
                                                     0 (written by MCU, read by interface)                                     */
      __IOM uint32_t FIFO0REM   : 8;            /*!< [15..8] The number of remaining data bytes slots currently in
                                                     FIFO 0 (written by MCU, read by interface)                                */
      __IOM uint32_t FIFO1SIZ   : 8;            /*!< [23..16] The number of valid data bytes currently in FIFO 1
                                                     (written by interface, read by MCU)                                       */
      __IOM uint32_t FIFO1REM   : 8;            /*!< [31..24] The number of remaining data bytes slots currently
                                                     in FIFO 1 (written by interface, read by MCU)                             */
    } FIFOPTR_b;
  } ;

  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000104) Sets the threshold values for incoming and outgoing
                                                                    transactions. The threshold values are used
                                                                    to assert the interrupt if enabled, and
                                                                    also used during DMA to set the transfer
                                                                    size as a result of DMATHR trigger.The WTHR
                                                                    is used to indicate when there are more
                                                                    than WTHR bytes of open FIFO locations available
                                                                    in the outgoing FIFO (FIFO0). The intended
                                                                    use to invoke an interrupt or DMA transfer
                                                                    that will refill the FIFO with a byte count
                                                                    up to this value.The RTHR is used to indicate
                                                                    when t                                                     */

    struct {
      __IOM uint32_t FIFORTHR   : 6;            /*!< [5..0] FIFO read threshold in bytes. A value of 0 will disable
                                                     the read FIFO level from activating the threshold interrupt.
                                                     If this field is non-zero, it will trigger a threshold
                                                     interrupt when the read FIFO contains FIFORTHR valid bytes
                                                     of data, as indicated by the FIFO1SIZ field. This is intended
                                                     to signal when a data transfer of FIFORTHR bytes can be
                                                     done from the IOM module to the host via the read FIFO
                                                     to support large IOM read operations.                                     */
            uint32_t            : 2;
      __IOM uint32_t FIFOWTHR   : 6;            /*!< [13..8] FIFO write threshold in bytes. A value of 0 will disable
                                                     the write FIFO level from activating the threshold interrupt.
                                                     If this field is non-zero, it will trigger a threshold
                                                     interrupt when the write FIFO contains FIFOWTHR free bytes,
                                                     as indicated by the FIFO0REM field. This is intended to
                                                     signal when a transfer of FIFOWTHR bytes can be done from
                                                     the host to the IOM write FIFO to support large IOM write
                                                     operations.                                                               */
            uint32_t            : 18;
    } FIFOTHR_b;
  } ;

  union {
    __IOM uint32_t FIFOPOP;                     /*!< (@ 0x00000108) Will advance the internal read pointer of the
                                                                    incoming FIFO (FIFO1) when read, if POPWR
                                                                    is not active. If POPWR is active, a write
                                                                    to this register is needed to advance the
                                                                    internal FIFO pointer.                                     */

    struct {
      __IOM uint32_t FIFODOUT   : 32;           /*!< [31..0] This register will return the read data indicated by
                                                     the current read pointer on reads. If the POPWR control
                                                     bit in the FIFOCTRL register is reset (0), the FIFO read
                                                     pointer will be advanced by one word as a result of the
                                                     read.If the POPWR bit is set (1), the FIFO read pointer
                                                     will only be advanced after a write operation to this register.
                                                     The write data is ignored for this register.If less than
                                                     a even word multiple is available, and the command is completed,
                                                     the module will return the word containing                                */
    } FIFOPOP_b;
  } ;

  union {
    __IOM uint32_t FIFOPUSH;                    /*!< (@ 0x0000010C) Will write new data into the outgoing FIFO and
                                                                    advance the internal write pointer.                        */

    struct {
      __IOM uint32_t FIFODIN    : 32;           /*!< [31..0] This register is used to write the FIFORAM in FIFO mode
                                                     and will cause a push event to occur to the next open slot
                                                     within the FIFORAM. Writing to this register will cause
                                                     the write point to increment by 1 word(4 bytes).                          */
    } FIFOPUSH_b;
  } ;

  union {
    __IOM uint32_t FIFOCTRL;                    /*!< (@ 0x00000110) Provides controls for the operation of the internal
                                                                    FIFOs. Contains fields used to control the
                                                                    operation of the POP register, and also
                                                                    controls to reset the internal pointers
                                                                    of the FIFOs.                                              */

    struct {
      __IOM uint32_t POPWR      : 1;            /*!< [0..0] Selects the mode in which 'pop' events are done for the
                                                     FIFO read operations. A value of '1' will prevent a pop
                                                     event on a read operation, and will require a write to
                                                     the FIFOPOP register to create a pop event.A value of '0'
                                                     in this register will allow a pop event to occur on the
                                                     read of the FIFOPOP register, and may cause inadvertent
                                                     FIFO pops when used in a debugging mode.                                  */
      __IOM uint32_t FIFORSTN   : 1;            /*!< [1..1] Active low manual reset of the FIFO. Write to 0 to reset
                                                     FIFO, and then write to 1 to remove the reset.                            */
            uint32_t            : 30;
    } FIFOCTRL_b;
  } ;

  union {
    __IOM uint32_t FIFOLOC;                     /*!< (@ 0x00000114) Provides a read only value of the current read
                                                                    and write pointers. This register is read
                                                                    only and can be used along with the FIFO
                                                                    direct access method to determine the next
                                                                    data to be used for input and output functions.            */

    struct {
      __IOM uint32_t FIFOWPTR   : 4;            /*!< [3..0] Current FIFO write pointer. Value is the index into the
                                                     outgoing FIFO (FIFO0), which is used during write operations
                                                     to external devices.                                                      */
            uint32_t            : 4;
      __IOM uint32_t FIFORPTR   : 4;            /*!< [11..8] Current FIFO read pointer. Used to index into the incoming
                                                     FIFO (FIFO1), which is used to store read data returned
                                                     from external devices during a read operation.                            */
            uint32_t            : 20;
    } FIFOLOC_b;
  } ;
  __IM  uint32_t  RESERVED1[58];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command Complete interrupt. Asserted when the current
                                                     operation has completed. For repeated commands, this will
                                                     only be asserted when the final repeated command is completed.            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. This occurs when software
                                                     tries to pop from an empty FIFO.                                          */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full FIFO. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t NAK        : 1;            /*!< [4..4] I2C NAK interrupt. Asserted when an unexpected NAK has
                                                     been received on the I2C bus.                                             */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t START      : 1;            /*!< [7..7] START command interrupt. Asserted when another master
                                                     on the bus has signaled a START command.                                  */
      __IOM uint32_t STOP       : 1;            /*!< [8..8] STOP command interrupt. Asserted when another master
                                                     on the bus has signaled a STOP command.                                   */
      __IOM uint32_t ARB        : 1;            /*!< [9..9] Arbitration loss interrupt. Asserted when arbitration
                                                     is enabled and has been lost to another master on the bus.                */
      __IOM uint32_t DCMP       : 1;            /*!< [10..10] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [11..11] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [12..12] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [13..13] CQ write operation performed a register write with
                                                     the register address bit 0 set to 1. The low address bits
                                                     in the CQ address fields are unused and bit 0 can be used
                                                     to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [14..14] Error during command queue operations                            */
            uint32_t            : 17;
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command Complete interrupt. Asserted when the current
                                                     operation has completed. For repeated commands, this will
                                                     only be asserted when the final repeated command is completed.            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. This occurs when software
                                                     tries to pop from an empty FIFO.                                          */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full FIFO. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t NAK        : 1;            /*!< [4..4] I2C NAK interrupt. Asserted when an unexpected NAK has
                                                     been received on the I2C bus.                                             */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t START      : 1;            /*!< [7..7] START command interrupt. Asserted when another master
                                                     on the bus has signaled a START command.                                  */
      __IOM uint32_t STOP       : 1;            /*!< [8..8] STOP command interrupt. Asserted when another master
                                                     on the bus has signaled a STOP command.                                   */
      __IOM uint32_t ARB        : 1;            /*!< [9..9] Arbitration loss interrupt. Asserted when arbitration
                                                     is enabled and has been lost to another master on the bus.                */
      __IOM uint32_t DCMP       : 1;            /*!< [10..10] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [11..11] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [12..12] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [13..13] CQ write operation performed a register write with
                                                     the register address bit 0 set to 1. The low address bits
                                                     in the CQ address fields are unused and bit 0 can be used
                                                     to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [14..14] Error during command queue operations                            */
            uint32_t            : 17;
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command Complete interrupt. Asserted when the current
                                                     operation has completed. For repeated commands, this will
                                                     only be asserted when the final repeated command is completed.            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. This occurs when software
                                                     tries to pop from an empty FIFO.                                          */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full FIFO. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t NAK        : 1;            /*!< [4..4] I2C NAK interrupt. Asserted when an unexpected NAK has
                                                     been received on the I2C bus.                                             */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t START      : 1;            /*!< [7..7] START command interrupt. Asserted when another master
                                                     on the bus has signaled a START command.                                  */
      __IOM uint32_t STOP       : 1;            /*!< [8..8] STOP command interrupt. Asserted when another master
                                                     on the bus has signaled a STOP command.                                   */
      __IOM uint32_t ARB        : 1;            /*!< [9..9] Arbitration loss interrupt. Asserted when arbitration
                                                     is enabled and has been lost to another master on the bus.                */
      __IOM uint32_t DCMP       : 1;            /*!< [10..10] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [11..11] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [12..12] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [13..13] CQ write operation performed a register write with
                                                     the register address bit 0 set to 1. The low address bits
                                                     in the CQ address fields are unused and bit 0 can be used
                                                     to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [14..14] Error during command queue operations                            */
            uint32_t            : 17;
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Command Complete interrupt. Asserted when the current
                                                     operation has completed. For repeated commands, this will
                                                     only be asserted when the final repeated command is completed.            */
      __IOM uint32_t THR        : 1;            /*!< [1..1] FIFO Threshold interrupt. For write operations, asserted
                                                     when the number of free bytes in the write FIFO equals
                                                     or exceeds the WTHR field.For read operations, asserted
                                                     when the number of valid bytes in the read FIFO equals
                                                     of exceeds the value set in the RTHR field.                               */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] Read FIFO Underflow interrupt. This occurs when software
                                                     tries to pop from an empty FIFO.                                          */
      __IOM uint32_t FOVFL      : 1;            /*!< [3..3] Write FIFO Overflow interrupt. This occurs when software
                                                     tries to write to a full FIFO. The current operation does
                                                     not stop.                                                                 */
      __IOM uint32_t NAK        : 1;            /*!< [4..4] I2C NAK interrupt. Asserted when an unexpected NAK has
                                                     been received on the I2C bus.                                             */
      __IOM uint32_t IACC       : 1;            /*!< [5..5] illegal FIFO access interrupt. Asserted when there is
                                                     a overflow or underflow event                                             */
      __IOM uint32_t ICMD       : 1;            /*!< [6..6] illegal command interrupt. Asserted when a command is
                                                     written when an active command is in progress.                            */
      __IOM uint32_t START      : 1;            /*!< [7..7] START command interrupt. Asserted when another master
                                                     on the bus has signaled a START command.                                  */
      __IOM uint32_t STOP       : 1;            /*!< [8..8] STOP command interrupt. Asserted when another master
                                                     on the bus has signaled a STOP command.                                   */
      __IOM uint32_t ARB        : 1;            /*!< [9..9] Arbitration loss interrupt. Asserted when arbitration
                                                     is enabled and has been lost to another master on the bus.                */
      __IOM uint32_t DCMP       : 1;            /*!< [10..10] DMA Complete. Processing of the DMA operation has completed
                                                     and the DMA submodule is returned into the idle state                     */
      __IOM uint32_t DERR       : 1;            /*!< [11..11] DMA Error encountered during the processing of the
                                                     DMA command. The DMA error could occur when the memory
                                                     access specified in the DMA operation is not available
                                                     or incorrectly specified.                                                 */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [12..12] Command queue is paused due to an active event enabled
                                                     in the PAUSEEN register. The interrupt is posted when the
                                                     event is enabled within the PAUSEEN register, the mask
                                                     is active in the CQIRQMASK field and the event occurs.                    */
      __IOM uint32_t CQUPD      : 1;            /*!< [13..13] CQ write operation performed a register write with
                                                     the register address bit 0 set to 1. The low address bits
                                                     in the CQ address fields are unused and bit 0 can be used
                                                     to trigger an interrupt to indicate when this register
                                                     write is performed by the CQ operation.                                   */
      __IOM uint32_t CQERR      : 1;            /*!< [14..14] Error during command queue operations                            */
            uint32_t            : 17;
    } INTSET_b;
  } ;

  union {
    __IOM uint32_t CLKCFG;                      /*!< (@ 0x00000210) Provides clock related controls used internal
                                                                    to the BLEIF module, and enablement of 32KHz
                                                                    clock to the BLE Core module. The internal
                                                                    clock sourced is selected via the FSEL and
                                                                    can be further divided by 3 using the DIV3
                                                                    control.This register is also used to enable
                                                                    the clock, which must be done prior to performing
                                                                    any IO transactions.                                       */

    struct {
      __IOM uint32_t IOCLKEN    : 1;            /*!< [0..0] Enable for the interface clock. Must be enabled prior
                                                     to executing any IO operations.                                           */
            uint32_t            : 7;
      __IOM uint32_t FSEL       : 3;            /*!< [10..8] Select the input clock frequency.                                 */
      __IOM uint32_t DIV3       : 1;            /*!< [11..11] Enable divide by 3 of the source IOCLK. Division by
                                                     3 is done before the DIVEN programmable divider, and if
                                                     enabledwill provide the divided by 3 clock as the source
                                                     to the programmable divider.                                              */
      __IOM uint32_t DIVEN      : 1;            /*!< [12..12] Enable clock division by TOTPER and LOWPER                       */
            uint32_t            : 3;
      __IOM uint32_t LOWPER     : 8;            /*!< [23..16] Clock low clock count minus 1. This provides the number
                                                     of clocks the divided clock will be low when the DIVEN
                                                     = 1.Only applicable when DIVEN = 1.                                       */
      __IOM uint32_t TOTPER     : 8;            /*!< [31..24] Clock total clock count minus 1. This provides the
                                                     total period of the divided clock -1 when the DIVEN is
                                                     active. Thesource clock is selected by FSEL. Only applicable
                                                     when DIVEN = 1.                                                           */
    } CLKCFG_b;
  } ;

  union {
    __IOM uint32_t SUBMODCTRL;                  /*!< (@ 0x00000214) Provides enable for each submodule. Only a single
                                                                    submodule can be enabled at one time.                      */

    struct {
      __IOM uint32_t SMOD0EN    : 1;            /*!< [0..0] Submodule 0 enable (1) or disable (0)                              */
      __IOM uint32_t SMOD0TYPE  : 3;            /*!< [3..1] Submodule 0 module type. This is the SPI Master interface.         */
      __IOM uint32_t SMOD1EN    : 1;            /*!< [4..4] Submodule 1 enable (1) or disable (0)                              */
      __IOM uint32_t SMOD1TYPE  : 3;            /*!< [7..5] Submodule 0 module type. This is the I2C Master interface          */
            uint32_t            : 24;
    } SUBMODCTRL_b;
  } ;

  union {
    __IOM uint32_t CMD;                         /*!< (@ 0x00000218) Writes to this register will start an IO transaction,
                                                                    as well as set various parameters for the
                                                                    command itself. Reads will return the command
                                                                    value written to the CMD register.To read
                                                                    the number of bytes that have yet to be
                                                                    transferred, refer to the CTSIZE field within
                                                                    the CMDSTAT register.                                      */

    struct {
      __IOM uint32_t CMD        : 5;            /*!< [4..0] Command for submodule.                                             */
      __IOM uint32_t OFFSETCNT  : 2;            /*!< [6..5] Number of offset bytes to use for the command - 0, 1,
                                                     2, 3 are valid selections. The second (byte 1) and third
                                                     byte (byte 2) are read from the OFFSETHI register, and
                                                     the low order byte is pulled from this register in the
                                                     OFFSETLO field.Offset bytes are transmitted highest byte
                                                     first. EG if OFFSETCNT == 3, OFFSETHI[15:8] will be transmitted
                                                     first, then OFFSETHI[7:0] then OFFSETLO.If OFFSETCNT ==
                                                     2, OFFSETHI[7:0] will be transmitted, then OFFSETLO.If
                                                     OFFSETCNT == 1, only OFFSETLO will be transmitted.                        */
      __IOM uint32_t CONT       : 1;            /*!< [7..7] Continue to hold the bus after the current transaction
                                                     if set to a 1 with a new command issued.                                  */
      __IOM uint32_t TSIZE      : 12;           /*!< [19..8] Defines the transaction size in bytes. The offset transfer
                                                     is not included in this size.                                             */
      __IOM uint32_t CMDSEL     : 2;            /*!< [21..20] Command Specific selection information. Not used in
                                                     Master I2C. Used as CEn select for Master SPI transactions                */
            uint32_t            : 2;
      __IOM uint32_t OFFSETLO   : 8;            /*!< [31..24] This register holds the low order byte of offset to
                                                     be used in the transaction. The number of offset bytes
                                                     to use is set with bits 1:0 of the command.                               */
    } CMD_b;
  } ;

  union {
    __IOM uint32_t DCX;                         /*!< (@ 0x0000021C) Enables use of CE signals to transmit DCX level
                                                                    for SPI transactions. Only used in Apollo3
                                                                    Revision B. For Revision A, this register
                                                                    MUST NOT be programmed!                                    */

    struct {
      __IOM uint32_t CE0OUT     : 1;            /*!< [0..0] Revision A: MUST NOT be programmed! Revision B: Enable
                                                     DCX output for CE0 output.                                                */
      __IOM uint32_t CE1OUT     : 1;            /*!< [1..1] Revision A: MUST NOT be programmed! Revision B: Enable
                                                     DCX output for CE1 output.                                                */
      __IOM uint32_t CE2OUT     : 1;            /*!< [2..2] Revision A: MUST NOT be programmed! Revision B: Enable
                                                     DCX output for CE2 output.                                                */
      __IOM uint32_t CE3OUT     : 1;            /*!< [3..3] Revision A: MUST NOT be programmed! Revision B: Enable
                                                     DCX output for CE3 output.                                                */
      __IOM uint32_t DCXEN      : 1;            /*!< [4..4] Revision A: MUST NOT be programmed! Revision B: Bit 4:
                                                     DCX Signaling Enable via other CE signals. The selected
                                                     DCX signal (unused CE pin) will be driven low during write
                                                     of offset byte, and high during transmission of data bytes.               */
            uint32_t            : 27;
    } DCX_b;
  } ;

  union {
    __IOM uint32_t OFFSETHI;                    /*!< (@ 0x00000220) High order 2 bytes of 3 byte offset for IO transaction     */

    struct {
      __IOM uint32_t OFFSETHI   : 16;           /*!< [15..0] Holds the high order 2 bytes of the 3 byte addressing/offset
                                                     field to use with IO commands. The number of offset bytes
                                                     to use is specified in the command register                               */
            uint32_t            : 16;
    } OFFSETHI_b;
  } ;

  union {
    __IOM uint32_t CMDSTAT;                     /*!< (@ 0x00000224) Provides status on the execution of the command
                                                                    currently in progress. The fields in this
                                                                    register will reflect the real time status
                                                                    of the internal state machines and data
                                                                    transfers within the IOM.These are read
                                                                    only fields and writes to the registers
                                                                    are ignored.                                               */

    struct {
      __IOM uint32_t CCMD       : 5;            /*!< [4..0] current command that is being executed                             */
      __IOM uint32_t CMDSTAT    : 3;            /*!< [7..5] The current status of the command execution.                       */
      __IOM uint32_t CTSIZE     : 12;           /*!< [19..8] The current number of bytes still to be transferred
                                                     with this command. This field will count down to zero.                    */
            uint32_t            : 12;
    } CMDSTAT_b;
  } ;
  __IM  uint32_t  RESERVED2[6];

  union {
    __IOM uint32_t DMATRIGEN;                   /*!< (@ 0x00000240) Provides control on which event will trigger
                                                                    the DMA transfer after the DMA operation
                                                                    is setup and enabled. The trigger event
                                                                    will cause a number of bytes (depending
                                                                    on trigger event) to betransferred via the
                                                                    DMA operation, and can be used to adjust
                                                                    the latency of data to/from the IOM module
                                                                    to/from the DMA target. DMA transfers are
                                                                    broken into smaller transfers internally
                                                                    of up to16 bytes each, and multiple trigger
                                                                    events can be used to complete the entire
                                                                    programmed DMA transfer.                                   */

    struct {
      __IOM uint32_t DCMDCMPEN  : 1;            /*!< [0..0] Trigger DMA upon command complete. Enables the trigger
                                                     of the DMA when a command is completed. When this event
                                                     is triggered, the number of words transferred will be the
                                                     lesser of the remaining TOTCOUNT bytes, or                                */
      __IOM uint32_t DTHREN     : 1;            /*!< [1..1] Trigger DMA upon THR level reached. For M2P DMA operations
                                                     (IOM writes), the trigger will assert when the write FIFO
                                                     has (WTHR/4) number of words free in the write FIFO, and
                                                     will transfer (WTHR/4) number of wordsor, if the number
                                                     of words left to transfer is less than the WTHR value,
                                                     will transfer the remaining byte count.For P2M DMA operations,
                                                     the trigger will assert when the read FIFO has (RTHR/4)
                                                     words available in the read FIFO, and will transfer (RTHR/4)
                                                     words to SRAM. This trigger will NOT asser                                */
            uint32_t            : 30;
    } DMATRIGEN_b;
  } ;

  union {
    __IOM uint32_t DMATRIGSTAT;                 /*!< (@ 0x00000244) Provides the status of trigger events that have
                                                                    occurred for the transaction. Some of the
                                                                    bits are read only and some can be reset
                                                                    via a write of 0.                                          */

    struct {
      __IOM uint32_t DCMDCMP    : 1;            /*!< [0..0] Triggered DMA from Command complete event. Bit is read
                                                     only and can be cleared by disabling the DCMDCMP trigger
                                                     enable or by disabling DMA.                                               */
      __IOM uint32_t DTHR       : 1;            /*!< [1..1] Triggered DMA from THR event. Bit is read only and can
                                                     be cleared by disabling the DTHR trigger enable or by disabling
                                                     DMA.                                                                      */
      __IOM uint32_t DTOTCMP    : 1;            /*!< [2..2] DMA triggered when DCMDCMP = 0, and the amount of data
                                                     in the FIFO was enough to complete the DMA operation (greater
                                                     than or equal to current TOTCOUNT) when the command completed.
                                                     This trigger is default active when the DCMDCMP trigger
                                                     isdisabled and there is enough data in the FIFO to complete
                                                     the DMA operation.                                                        */
            uint32_t            : 29;
    } DMATRIGSTAT_b;
  } ;
  __IM  uint32_t  RESERVED3[14];

  union {
    __IOM uint32_t DMACFG;                      /*!< (@ 0x00000280) Configuration control of the DMA process, including
                                                                    the direction of DMA, and enablement of
                                                                    DMA                                                        */

    struct {
      __IOM uint32_t DMAEN      : 1;            /*!< [0..0] DMA Enable. Setting this bit to EN will start the DMA
                                                     operation. This should be the last DMA related register
                                                     set prior to issuing the command                                          */
      __IOM uint32_t DMADIR     : 1;            /*!< [1..1] Direction                                                          */
            uint32_t            : 6;
      __IOM uint32_t DMAPRI     : 1;            /*!< [8..8] Sets the Priority of the DMA request                               */
      __IOM uint32_t DPWROFF    : 1;            /*!< [9..9] Power off module after DMA is complete. If this bit is
                                                     active, the module will request to power off the supply
                                                     it is attached to. If there are other units still requiring
                                                     power from the same domain, power down will not be performed.             */
            uint32_t            : 22;
    } DMACFG_b;
  } ;
  __IM  uint32_t  RESERVED4;

  union {
    __IOM uint32_t DMATOTCOUNT;                 /*!< (@ 0x00000288) Contains the number of bytes to be transferred
                                                                    for this DMA transaction. This register
                                                                    is decremented as the data is transferred,
                                                                    and will be 0 at the completion of the DMA
                                                                    operation.                                                 */

    struct {
      __IOM uint32_t TOTCOUNT   : 12;           /*!< [11..0] Triggered DMA from Command complete event occurred.
                                                     Bit is read only and can be cleared by disabling the DTHR
                                                     trigger enable or by disabling DMA.                                       */
            uint32_t            : 20;
    } DMATOTCOUNT_b;
  } ;

  union {
    __IOM uint32_t DMATARGADDR;                 /*!< (@ 0x0000028C) The source or destination address internal the
                                                                    SRAM for the DMA data. For write operations,
                                                                    this can only be SRAM data (ADDR bit 28
                                                                    = 1); For read operations, this can be either
                                                                    SRAM or FLASH (ADDR bit 28 = 0)                            */

    struct {
      __IOM uint32_t TARGADDR   : 20;           /*!< [19..0] Bits [19:0] of the target byte address for source of
                                                     DMA (either read or write). The address can be any byte
                                                     alignment, and does not have to be word aligned. In cases
                                                     of non-word aligned addresses, the DMA logic will take
                                                     care for ensuring only the target bytes are read/written.                 */
            uint32_t            : 8;
      __IOM uint32_t TARGADDR28 : 1;            /*!< [28..28] Bit 28 of the target byte address for source of DMA
                                                     (either read or write). In cases of non-word aligned addresses,
                                                     the DMA logic will take care for ensuring only the target
                                                     bytes are read/written.Setting to '1' will select the SRAM.
                                                     Setting to '0' will select the flash                                      */
            uint32_t            : 3;
    } DMATARGADDR_b;
  } ;

  union {
    __IOM uint32_t DMASTAT;                     /*!< (@ 0x00000290) Status of the DMA operation currently in progress.         */

    struct {
      __IOM uint32_t DMATIP     : 1;            /*!< [0..0] DMA Transfer In Progress indicator. 1 will indicate that
                                                     a DMA transfer is active. The DMA transfer may be waiting
                                                     on data, transferring data, or waiting for priority.All
                                                     of these will be indicated with a 1. A 0 will indicate
                                                     that the DMA is fully complete and no further transactions
                                                     will be done. This bit is read only.                                      */
      __IOM uint32_t DMACPL     : 1;            /*!< [1..1] DMA Transfer Complete. This signals the end of the DMA
                                                     operation. This bit can be cleared by writing to 0, and
                                                     will also be cleared when a new DMA is started.                           */
      __IOM uint32_t DMAERR     : 1;            /*!< [2..2] DMA Error. This active high bit signals an error was
                                                     encountered during the DMA operation. The bit can be cleared
                                                     by writing to 0. Once set, this bit will remain set until
                                                     cleared by software.                                                      */
            uint32_t            : 29;
    } DMASTAT_b;
  } ;

  union {
    __IOM uint32_t CQCFG;                       /*!< (@ 0x00000294) Controls parameters and options for execution
                                                                    of the command queue operation. To enable
                                                                    command queue, create this in memory, set
                                                                    the address, and enable it with a write
                                                                    to CQEN                                                    */

    struct {
      __IOM uint32_t CQEN       : 1;            /*!< [0..0] Command queue enable. When set, will enable the processing
                                                     of the command queue and fetches of address/data pairs
                                                     will proceed from the word address within the CQADDR register.
                                                     Can be disabled using a CQ executed write to this bit as
                                                     well.                                                                     */
      __IOM uint32_t CQPRI      : 1;            /*!< [1..1] Sets the Priority of the command queue DMA request                 */
            uint32_t            : 30;
    } CQCFG_b;
  } ;

  union {
    __IOM uint32_t CQADDR;                      /*!< (@ 0x00000298) The SRAM address which will be fetched next execution
                                                                    of the CQ operation. This register is updated
                                                                    as the CQ operation progresses, and is the
                                                                    live version of the register. The register
                                                                    can also be written by the Command Queue
                                                                    operation itself, allowing the relocation
                                                                    of successive CQ fetches. In this case,
                                                                    the new CQ address will be used for the
                                                                    next CQ address/data fetch.                                */

    struct {
            uint32_t            : 2;
      __IOM uint32_t CQADDR     : 18;           /*!< [19..2] Bits 19:2 of target byte address for source of CQ. The
                                                     buffer must be aligned on a word boundary                                 */
            uint32_t            : 8;
      __IOM uint32_t CQADDR28   : 1;            /*!< [28..28] Bit 28 of target byte address for source of CQ. Used
                                                     to denote Flash (0) or SRAM (1) access                                    */
            uint32_t            : 3;
    } CQADDR_b;
  } ;

  union {
    __IOM uint32_t CQSTAT;                      /*!< (@ 0x0000029C) Provides the status of the command queue operation.
                                                                    If the command queue is disabled, these
                                                                    bits will be cleared. The bits are read
                                                                    only                                                       */

    struct {
      __IOM uint32_t CQTIP      : 1;            /*!< [0..0] Command queue Transfer In Progress indicator. 1 will
                                                     indicate that a CQ transfer is active and this will remain
                                                     active even when paused waiting for external event.                       */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [1..1] Command queue operation is currently paused.                       */
      __IOM uint32_t CQERR      : 1;            /*!< [2..2] Command queue processing Error. This active high bit
                                                     signals that an error was encountered during the CQ operation.            */
            uint32_t            : 29;
    } CQSTAT_b;
  } ;

  union {
    __IOM uint32_t CQFLAGS;                     /*!< (@ 0x000002A0) Command Queue Flag                                         */

    struct {
      __IOM uint32_t CQFLAGS    : 16;           /*!< [15..0] Current flag status (read-only). Bits [7:0] are software
                                                     controllable and bits [15:8] are hardware status.                         */
      __IOM uint32_t CQIRQMASK  : 16;           /*!< [31..16] Mask the bits used to generate the command queue interrupt.
                                                     A '1' in the bit position will enable the pause event to
                                                     trigger the interrupt, if the CQWT_int interrupt is enabled.
                                                     Bits definitions are the same as CQPAUSE                                  */
    } CQFLAGS_b;
  } ;

  union {
    __IOM uint32_t CQSETCLEAR;                  /*!< (@ 0x000002A4) Set/Clear the command queue software pause flags
                                                                    on a per-bit basis. Contains 3 fields, allowing
                                                                    for setting, clearing or toggling the value
                                                                    in the software flags. Priority when the
                                                                    same bitis enabled in each field is toggle,
                                                                    then set, then clear.                                      */

    struct {
      __IOM uint32_t CQFSET     : 8;            /*!< [7..0] Set CQFlag status bits. Will set to 1 the value of any
                                                     SWFLAG with a '1' in the corresponding bit position of
                                                     this field                                                                */
      __IOM uint32_t CQFTGL     : 8;            /*!< [15..8] Toggle the indicated bit. Will toggle the value of any
                                                     SWFLAG with a '1' in the corresponding bit position of
                                                     this field                                                                */
      __IOM uint32_t CQFCLR     : 8;            /*!< [23..16] Clear CQFlag status bits. Will clear to 0 any SWFLAG
                                                     with a '1' in the corresponding bit position of this field                */
            uint32_t            : 8;
    } CQSETCLEAR_b;
  } ;

  union {
    __IOM uint32_t CQPAUSEEN;                   /*!< (@ 0x000002A8) Enables a flag to pause an active command queue
                                                                    operation. If a bit is '1' and the corresponding
                                                                    bit in the CQFLAG register is '1', CQ processing
                                                                    will halt until either value is changed
                                                                    to '0'.                                                    */

    struct {
      __IOM uint32_t CQPEN      : 16;           /*!< [15..0] Enables the specified event to pause command processing
                                                     when active                                                               */
            uint32_t            : 16;
    } CQPAUSEEN_b;
  } ;

  union {
    __IOM uint32_t CQCURIDX;                    /*!< (@ 0x000002AC) Current index value, targeted to be written by
                                                                    register write operations within the command
                                                                    queue. This is compared to the CQENDIDX
                                                                    and will stop the CQ operation if bit 15
                                                                    of the CQPAUSEEN is '1' andthis current
                                                                    index equals the CQENDIDX register value.
                                                                    This will only pause when the values are
                                                                    equal.                                                     */

    struct {
      __IOM uint32_t CQCURIDX   : 8;            /*!< [7..0] Holds 8 bits of data that will be compared with the CQENDIX
                                                     register field. If the values match, the IDXEQ pause event
                                                     will be activated, which will cause the pausing of command
                                                     queue operation if the IDXEQ bit is enabled in CQPAUSEEN.                 */
            uint32_t            : 24;
    } CQCURIDX_b;
  } ;

  union {
    __IOM uint32_t CQENDIDX;                    /*!< (@ 0x000002B0) End index value, targeted to be written by software
                                                                    to indicate the last valid register pair
                                                                    contained within the command queue for a
                                                                    register write operations within the command
                                                                    queue.This is compared to the CQCURIDX and
                                                                    will stop the CQ operation if bit 15 of
                                                                    the CQPAUSEEN is '1' andthis current index
                                                                    equals the CQCURIDX register value. This
                                                                    will only pause when the values are equal.                 */

    struct {
      __IOM uint32_t CQENDIDX   : 8;            /*!< [7..0] Holds 8 bits of data that will be compared with the CQCURIX
                                                     register field. If the values match, the IDXEQ pause event
                                                     will be activated, which will cause the pausing of command
                                                     queue operation if the IDXEQ bit is enabled in CQPAUSEEN.                 */
            uint32_t            : 24;
    } CQENDIDX_b;
  } ;

  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x000002B4) IOM Module Status                                          */

    struct {
      __IOM uint32_t ERR        : 1;            /*!< [0..0] Bit has been deprecated. Please refer to the other error
                                                     indicators. This will always return 0.                                    */
      __IOM uint32_t CMDACT     : 1;            /*!< [1..1] Indicates if the active I/O Command is currently processing
                                                     a transaction, or command is complete, but the FIFO pointers
                                                     are still synchronizing internally. This bit will go high
                                                     atthe start of the transaction, and will go low when the
                                                     command is complete, and the data and pointers within the
                                                     FIFO have been synchronized.                                              */
      __IOM uint32_t IDLEST     : 1;            /*!< [2..2] indicates if the active I/O state machine is IDLE. Note
                                                     - The state machine could be in idle state due to hold-offs
                                                     from data availability, or as the command gets propagated
                                                     into the logic from the registers.                                        */
            uint32_t            : 29;
    } STATUS_b;
  } ;
  __IM  uint32_t  RESERVED5[18];

  union {
    __IOM uint32_t MSPICFG;                     /*!< (@ 0x00000300) Controls the configuration of the SPI master
                                                                    module, including POL/PHA, LSB, flow control,
                                                                    and delays for MISO and MOSI                               */

    struct {
      __IOM uint32_t SPOL       : 1;            /*!< [0..0] selects SPI polarity.                                              */
      __IOM uint32_t SPHA       : 1;            /*!< [1..1] selects SPI phase.                                                 */
      __IOM uint32_t FULLDUP    : 1;            /*!< [2..2] Enables full duplex mode for Master SPI write operations.
                                                     Data will be captured simultaneously into the read FIFO                   */
            uint32_t            : 13;
      __IOM uint32_t WTFC       : 1;            /*!< [16..16] enables write mode flow control.                                 */
      __IOM uint32_t RDFC       : 1;            /*!< [17..17] enables read mode flow control.                                  */
      __IOM uint32_t MOSIINV    : 1;            /*!< [18..18] inverts MOSI when flow control is enabled.                       */
            uint32_t            : 1;
      __IOM uint32_t WTFCIRQ    : 1;            /*!< [20..20] selects the write mode flow control signal.                      */
      __IOM uint32_t WTFCPOL    : 1;            /*!< [21..21] selects the write flow control signal polarity. The
                                                     transfers are halted when the selected flow control signal
                                                     is OPPOSITE polarity of bit. (For example: WTFCPOL = 0
                                                     will allow a IRQ=1 to pause transfers).                                   */
      __IOM uint32_t RDFCPOL    : 1;            /*!< [22..22] selects the read flow control signal polarity.                   */
      __IOM uint32_t SPILSB     : 1;            /*!< [23..23] Selects data transfer as MSB first (0) or LSB first
                                                     (1) for the data portion of the SPI transaction. The offset
                                                     bytes are always transmitted MSB first.                                   */
      __IOM uint32_t DINDLY     : 3;            /*!< [26..24] Delay tap to use for the input signal (MISO). This
                                                     gives more hold time on the input data.                                   */
      __IOM uint32_t DOUTDLY    : 3;            /*!< [29..27] Delay tap to use for the output signal (MOSI). This
                                                     give more hold time on the output data                                    */
      __IOM uint32_t MSPIRST    : 1;            /*!< [30..30] Not used. To reset the module, toggle the SMOD_EN for
                                                     the module                                                                */
            uint32_t            : 1;
    } MSPICFG_b;
  } ;
  __IM  uint32_t  RESERVED6[63];

  union {
    __IOM uint32_t MI2CCFG;                     /*!< (@ 0x00000400) Controls the configuration of the I2C bus master.          */

    struct {
      __IOM uint32_t ADDRSZ     : 1;            /*!< [0..0] Sets the I2C master device address size to either 7 bits
                                                     (0) or 10 bits (1).                                                       */
      __IOM uint32_t I2CLSB     : 1;            /*!< [1..1] Direction of data transmit and receive, MSB(0) or LSB(1)
                                                     first. Default per I2C specification is MSB first. This
                                                     applies to both read and write data, and read data will
                                                     be bit                                                                    */
      __IOM uint32_t ARBEN      : 1;            /*!< [2..2] Enables multi-master arbitration for the I2C master.
                                                     If the bus is known to have only a single master, this
                                                     function can be disabled to save clock cycles on I2C transactions         */
            uint32_t            : 1;
      __IOM uint32_t SDADLY     : 2;            /*!< [5..4] Delay to enable on the SDA output. Values are 0x0-0x3.             */
      __IOM uint32_t MI2CRST    : 1;            /*!< [6..6] Not used. To reset the module, toggle the SMOD_EN for
                                                     the module                                                                */
            uint32_t            : 1;
      __IOM uint32_t SCLENDLY   : 4;            /*!< [11..8] Number of IOCLK cycles to delay the rising edge of the
                                                     SCL output en (clock will go low on this edge). Used to
                                                     allow clock shaping.                                                      */
      __IOM uint32_t SDAENDLY   : 4;            /*!< [15..12] Number of IOCLK cycles to delay the SDA output en (all
                                                     transitions affected). Used to delay data relative to clock               */
      __IOM uint32_t SMPCNT     : 8;            /*!< [23..16] Number of Base clock cycles to wait before sampling
                                                     the SCL clock to determine if a clock stretch event has
                                                     occurred                                                                  */
      __IOM uint32_t STRDIS     : 1;            /*!< [24..24] Disable detection of clock stretch events smaller than
                                                     1 cycle                                                                   */
            uint32_t            : 7;
    } MI2CCFG_b;
  } ;

  union {
    __IOM uint32_t DEVCFG;                      /*!< (@ 0x00000404) Contains the I2C device address.                           */

    struct {
      __IOM uint32_t DEVADDR    : 10;           /*!< [9..0] I2C address of the device that the Master will use to
                                                     target for read/write operations. This can be either a
                                                     7-bit or 10-bit address.                                                  */
            uint32_t            : 22;
    } DEVCFG_b;
  } ;
  __IM  uint32_t  RESERVED7[2];

  union {
    __IOM uint32_t IOMDBG;                      /*!< (@ 0x00000410) Debug control                                              */

    struct {
      __IOM uint32_t DBGEN      : 1;            /*!< [0..0] Debug Enable. Setting bit will enable the update of data
                                                     within this register, otherwise it is clock gated for power
                                                     savings                                                                   */
      __IOM uint32_t IOCLKON    : 1;            /*!< [1..1] IOCLK debug clock control. Enable IO_CLK to be active
                                                     when this bit is '1'. Otherwise, the clock is controlled
                                                     with gating from the logic as needed.                                     */
      __IOM uint32_t APBCLKON   : 1;            /*!< [2..2] APBCLK debug clock control. Enable APB_CLK to be active
                                                     when this bit is '1'. Otherwise, the clock is controlled
                                                     with gating from the logic as needed.                                     */
      __IOM uint32_t DBGDATA    : 29;           /*!< [31..3] Debug control for various options. DBGDATA[1:0] is used
                                                     to select between different debug data available in the
                                                     DBG0 and DBG1 registers.                                                  */
    } IOMDBG_b;
  } ;
} IOM0_Type;                                    /*!< Size = 1044 (0x414)                                                       */



/* =========================================================================================================================== */
/* ================                                          IOSLAVE                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C/SPI Slave (IOSLAVE)
  */

typedef struct {                                /*!< (@ 0x50000000) IOSLAVE Structure                                          */
  __IM  uint32_t  RESERVED[64];

  union {
    __IOM uint32_t FIFOPTR;                     /*!< (@ 0x00000100) Current FIFO Pointer                                       */

    struct {
      __IOM uint32_t FIFOPTR    : 8;            /*!< [7..0] Current FIFO pointer.                                              */
      __IOM uint32_t FIFOSIZ    : 8;            /*!< [15..8] The number of bytes currently in the hardware FIFO.               */
            uint32_t            : 16;
    } FIFOPTR_b;
  } ;

  union {
    __IOM uint32_t FIFOCFG;                     /*!< (@ 0x00000104) FIFO Configuration                                         */

    struct {
      __IOM uint32_t FIFOBASE   : 5;            /*!< [4..0] These bits hold the base address of the I/O FIFO in 8
                                                     byte segments. The IO Slave FIFO is situated in LRAM at
                                                     (FIFOBASE*8) to (FIFOMAX*8-1).                                            */
            uint32_t            : 3;
      __IOM uint32_t FIFOMAX    : 6;            /*!< [13..8] These bits hold the maximum FIFO address in 8 byte segments.
                                                     It is also the beginning of the RAM area of the LRAM. Note
                                                     that no RAM area is configured if FIFOMAX is set to 0x1F.                 */
            uint32_t            : 10;
      __IOM uint32_t ROBASE     : 6;            /*!< [29..24] Defines the read-only area. The IO Slave read-only
                                                     area is situated in LRAM at (ROBASE*8) to (FIFOBASE*8-1)                  */
            uint32_t            : 2;
    } FIFOCFG_b;
  } ;

  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000108) FIFO Threshold Configuration                               */

    struct {
      __IOM uint32_t FIFOTHR    : 8;            /*!< [7..0] FIFO size interrupt threshold.                                     */
            uint32_t            : 24;
    } FIFOTHR_b;
  } ;

  union {
    __IOM uint32_t FUPD;                        /*!< (@ 0x0000010C) FIFO Update Status                                         */

    struct {
      __IOM uint32_t FIFOUPD    : 1;            /*!< [0..0] This bit indicates that a FIFO update is underway.                 */
      __IOM uint32_t IOREAD     : 1;            /*!< [1..1] This bit field indicates an IO read is active.                     */
            uint32_t            : 30;
    } FUPD_b;
  } ;

  union {
    __IOM uint32_t FIFOCTR;                     /*!< (@ 0x00000110) Overall FIFO Counter                                       */

    struct {
      __IOM uint32_t FIFOCTR    : 10;           /*!< [9..0] Virtual FIFO byte count                                            */
            uint32_t            : 22;
    } FIFOCTR_b;
  } ;

  union {
    __IOM uint32_t FIFOINC;                     /*!< (@ 0x00000114) Overall FIFO Counter Increment                             */

    struct {
      __IOM uint32_t FIFOINC    : 10;           /*!< [9..0] Increment the Overall FIFO Counter by this value on a
                                                     write                                                                     */
            uint32_t            : 22;
    } FIFOINC_b;
  } ;

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000118) I/O Slave Configuration                                    */

    struct {
      __IOM uint32_t IFCSEL     : 1;            /*!< [0..0] This bit selects the I/O interface.                                */
      __IOM uint32_t SPOL       : 1;            /*!< [1..1] This bit selects SPI polarity.                                     */
      __IOM uint32_t LSB        : 1;            /*!< [2..2] This bit selects the transfer bit ordering.                        */
            uint32_t            : 1;
      __IOM uint32_t STARTRD    : 1;            /*!< [4..4] This bit holds the cycle to initiate an I/O RAM read.              */
            uint32_t            : 3;
      __IOM uint32_t I2CADDR    : 12;           /*!< [19..8] 7-bit or 10-bit I2C device address.                               */
            uint32_t            : 11;
      __IOM uint32_t IFCEN      : 1;            /*!< [31..31] IOSLAVE interface enable.                                        */
    } CFG_b;
  } ;

  union {
    __IOM uint32_t PRENC;                       /*!< (@ 0x0000011C) I/O Slave Interrupt Priority Encode                        */

    struct {
      __IOM uint32_t PRENC      : 5;            /*!< [4..0] These bits hold the priority encode of the REGACC interrupts.      */
            uint32_t            : 27;
    } PRENC_b;
  } ;

  union {
    __IOM uint32_t IOINTCTL;                    /*!< (@ 0x00000120) I/O Interrupt Control                                      */

    struct {
      __IOM uint32_t IOINTEN    : 8;            /*!< [7..0] These read-only bits indicate whether the IOINT interrupts
                                                     are enabled.                                                              */
      __IOM uint32_t IOINT      : 8;            /*!< [15..8] These bits read the IOINT interrupts.                             */
      __IOM uint32_t IOINTCLR   : 1;            /*!< [16..16] This bit clears all of the IOINT interrupts when written
                                                     with a 1.                                                                 */
            uint32_t            : 7;
      __IOM uint32_t IOINTSET   : 8;            /*!< [31..24] These bits set the IOINT interrupts when written with
                                                     a 1.                                                                      */
    } IOINTCTL_b;
  } ;

  union {
    __IOM uint32_t GENADD;                      /*!< (@ 0x00000124) General Address Data                                       */

    struct {
      __IOM uint32_t GADATA     : 8;            /*!< [7..0] The data supplied on the last General Address reference.           */
            uint32_t            : 24;
    } GENADD_b;
  } ;
  __IM  uint32_t  RESERVED1[54];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< [0..0] FIFO Size interrupt.                                               */
      __IOM uint32_t FOVFL      : 1;            /*!< [1..1] FIFO Overflow interrupt.                                           */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] FIFO Underflow interrupt.                                          */
      __IOM uint32_t FRDERR     : 1;            /*!< [3..3] FIFO Read Error interrupt.                                         */
      __IOM uint32_t GENAD      : 1;            /*!< [4..4] I2C General Address interrupt.                                     */
      __IOM uint32_t IOINTW     : 1;            /*!< [5..5] IO Write interrupt.                                                */
      __IOM uint32_t XCMPRF     : 1;            /*!< [6..6] Transfer complete interrupt, read from FIFO space.                 */
      __IOM uint32_t XCMPRR     : 1;            /*!< [7..7] Transfer complete interrupt, read from register space.             */
      __IOM uint32_t XCMPWF     : 1;            /*!< [8..8] Transfer complete interrupt, write to FIFO space.                  */
      __IOM uint32_t XCMPWR     : 1;            /*!< [9..9] Transfer complete interrupt, write to register space.              */
            uint32_t            : 22;
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< [0..0] FIFO Size interrupt.                                               */
      __IOM uint32_t FOVFL      : 1;            /*!< [1..1] FIFO Overflow interrupt.                                           */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] FIFO Underflow interrupt.                                          */
      __IOM uint32_t FRDERR     : 1;            /*!< [3..3] FIFO Read Error interrupt.                                         */
      __IOM uint32_t GENAD      : 1;            /*!< [4..4] I2C General Address interrupt.                                     */
      __IOM uint32_t IOINTW     : 1;            /*!< [5..5] IO Write interrupt.                                                */
      __IOM uint32_t XCMPRF     : 1;            /*!< [6..6] Transfer complete interrupt, read from FIFO space.                 */
      __IOM uint32_t XCMPRR     : 1;            /*!< [7..7] Transfer complete interrupt, read from register space.             */
      __IOM uint32_t XCMPWF     : 1;            /*!< [8..8] Transfer complete interrupt, write to FIFO space.                  */
      __IOM uint32_t XCMPWR     : 1;            /*!< [9..9] Transfer complete interrupt, write to register space.              */
            uint32_t            : 22;
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< [0..0] FIFO Size interrupt.                                               */
      __IOM uint32_t FOVFL      : 1;            /*!< [1..1] FIFO Overflow interrupt.                                           */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] FIFO Underflow interrupt.                                          */
      __IOM uint32_t FRDERR     : 1;            /*!< [3..3] FIFO Read Error interrupt.                                         */
      __IOM uint32_t GENAD      : 1;            /*!< [4..4] I2C General Address interrupt.                                     */
      __IOM uint32_t IOINTW     : 1;            /*!< [5..5] IO Write interrupt.                                                */
      __IOM uint32_t XCMPRF     : 1;            /*!< [6..6] Transfer complete interrupt, read from FIFO space.                 */
      __IOM uint32_t XCMPRR     : 1;            /*!< [7..7] Transfer complete interrupt, read from register space.             */
      __IOM uint32_t XCMPWF     : 1;            /*!< [8..8] Transfer complete interrupt, write to FIFO space.                  */
      __IOM uint32_t XCMPWR     : 1;            /*!< [9..9] Transfer complete interrupt, write to register space.              */
            uint32_t            : 22;
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< [0..0] FIFO Size interrupt.                                               */
      __IOM uint32_t FOVFL      : 1;            /*!< [1..1] FIFO Overflow interrupt.                                           */
      __IOM uint32_t FUNDFL     : 1;            /*!< [2..2] FIFO Underflow interrupt.                                          */
      __IOM uint32_t FRDERR     : 1;            /*!< [3..3] FIFO Read Error interrupt.                                         */
      __IOM uint32_t GENAD      : 1;            /*!< [4..4] I2C General Address interrupt.                                     */
      __IOM uint32_t IOINTW     : 1;            /*!< [5..5] IO Write interrupt.                                                */
      __IOM uint32_t XCMPRF     : 1;            /*!< [6..6] Transfer complete interrupt, read from FIFO space.                 */
      __IOM uint32_t XCMPRR     : 1;            /*!< [7..7] Transfer complete interrupt, read from register space.             */
      __IOM uint32_t XCMPWF     : 1;            /*!< [8..8] Transfer complete interrupt, write to FIFO space.                  */
      __IOM uint32_t XCMPWR     : 1;            /*!< [9..9] Transfer complete interrupt, write to register space.              */
            uint32_t            : 22;
    } INTSET_b;
  } ;

  union {
    __IOM uint32_t REGACCINTEN;                 /*!< (@ 0x00000210) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t REGACC     : 32;           /*!< [31..0] Register access interrupts.                                       */
    } REGACCINTEN_b;
  } ;

  union {
    __IOM uint32_t REGACCINTSTAT;               /*!< (@ 0x00000214) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t REGACC     : 32;           /*!< [31..0] Register access interrupts.                                       */
    } REGACCINTSTAT_b;
  } ;

  union {
    __IOM uint32_t REGACCINTCLR;                /*!< (@ 0x00000218) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t REGACC     : 32;           /*!< [31..0] Register access interrupts.                                       */
    } REGACCINTCLR_b;
  } ;

  union {
    __IOM uint32_t REGACCINTSET;                /*!< (@ 0x0000021C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t REGACC     : 32;           /*!< [31..0] Register access interrupts.                                       */
    } REGACCINTSET_b;
  } ;
} IOSLAVE_Type;                                 /*!< Size = 544 (0x220)                                                        */



/* =========================================================================================================================== */
/* ================                                          MCUCTRL                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief MCU Miscellaneous Control Logic (MCUCTRL)
  */

typedef struct {                                /*!< (@ 0x40020000) MCUCTRL Structure                                          */

  union {
    __IOM uint32_t CHIPPN;                      /*!< (@ 0x00000000) Chip Information Register                                  */

    struct {
      __IOM uint32_t PARTNUM    : 32;           /*!< [31..0] BCD part number.                                                  */
    } CHIPPN_b;
  } ;

  union {
    __IOM uint32_t CHIPID0;                     /*!< (@ 0x00000004) Unique Chip ID 0                                           */

    struct {
      __IOM uint32_t CHIPID0    : 32;           /*!< [31..0] Unique chip ID 0.                                                 */
    } CHIPID0_b;
  } ;

  union {
    __IOM uint32_t CHIPID1;                     /*!< (@ 0x00000008) Unique Chip ID 1                                           */

    struct {
      __IOM uint32_t CHIPID1    : 32;           /*!< [31..0] Unique chip ID 1.                                                 */
    } CHIPID1_b;
  } ;

  union {
    __IOM uint32_t CHIPREV;                     /*!< (@ 0x0000000C) Chip Revision                                              */

    struct {
      __IOM uint32_t REVMIN     : 4;            /*!< [3..0] Minor Revision ID.                                                 */
      __IOM uint32_t REVMAJ     : 4;            /*!< [7..4] Major Revision ID.                                                 */
      __IOM uint32_t SIPART     : 12;           /*!< [19..8] Silicon Part ID                                                   */
            uint32_t            : 12;
    } CHIPREV_b;
  } ;

  union {
    __IOM uint32_t VENDORID;                    /*!< (@ 0x00000010) Unique Vendor ID                                           */

    struct {
      __IOM uint32_t VENDORID   : 32;           /*!< [31..0] Unique Vendor ID                                                  */
    } VENDORID_b;
  } ;

  union {
    __IOM uint32_t SKU;                         /*!< (@ 0x00000014) Unique Chip SKU                                            */

    struct {
      __IOM uint32_t ALLOWBURST : 1;            /*!< [0..0] Allow Burst feature                                                */
      __IOM uint32_t ALLOWBLE   : 1;            /*!< [1..1] Allow BLE feature                                                  */
      __IOM uint32_t SECBOOT    : 1;            /*!< [2..2] Secure boot feature allowed                                        */
            uint32_t            : 29;
    } SKU_b;
  } ;

  union {
    __IOM uint32_t FEATUREENABLE;               /*!< (@ 0x00000018) Feature Enable on Burst and BLE                            */

    struct {
      __IOM uint32_t BLEREQ     : 1;            /*!< [0..0] Controls the BLE functionality                                     */
      __IOM uint32_t BLEACK     : 1;            /*!< [1..1] ACK for BLEREQ                                                     */
      __IOM uint32_t BLEAVAIL   : 1;            /*!< [2..2] AVAILABILITY of the BLE functionality                              */
            uint32_t            : 1;
      __IOM uint32_t BURSTREQ   : 1;            /*!< [4..4] Controls the Burst functionality                                   */
      __IOM uint32_t BURSTACK   : 1;            /*!< [5..5] ACK for BURSTREQ                                                   */
      __IOM uint32_t BURSTAVAIL : 1;            /*!< [6..6] Availability of Burst functionality                                */
            uint32_t            : 25;
    } FEATUREENABLE_b;
  } ;
  __IM  uint32_t  RESERVED;

  union {
    __IOM uint32_t DEBUGGER;                    /*!< (@ 0x00000020) Debugger Control                                           */

    struct {
      __IOM uint32_t LOCKOUT    : 1;            /*!< [0..0] Lockout of debugger (SWD).                                         */
            uint32_t            : 31;
    } DEBUGGER_b;
  } ;
  __IM  uint32_t  RESERVED1[55];

  union {
    __IOM uint32_t BODCTRL;                     /*!< (@ 0x00000100) BOD control Register                                       */

    struct {
      __IOM uint32_t BODLPWD    : 1;            /*!< [0..0] BODL Power Down.                                                   */
      __IOM uint32_t BODHPWD    : 1;            /*!< [1..1] BODH Power Down.                                                   */
      __IOM uint32_t BODCPWD    : 1;            /*!< [2..2] BODC Power Down.                                                   */
      __IOM uint32_t BODFPWD    : 1;            /*!< [3..3] BODF Power Down.                                                   */
      __IOM uint32_t BODLVREFSEL : 1;           /*!< [4..4] BODL External Reference Select. Note: the SWE mux select
                                                     in PWRSEQ2SWE must be set for this to take effect.                        */
      __IOM uint32_t BODHVREFSEL : 1;           /*!< [5..5] BODH External Reference Select. Note: the SWE mux select
                                                     in PWRSEQ2SWE must be set for this to take effect.                        */
            uint32_t            : 26;
    } BODCTRL_b;
  } ;

  union {
    __IOM uint32_t ADCPWRDLY;                   /*!< (@ 0x00000104) ADC Power Up Delay Control                                 */

    struct {
      __IOM uint32_t ADCPWR0    : 8;            /*!< [7..0] ADC Reference Buffer Power Enable delay in 64 ADC CLK
                                                     increments for ADC_CLKSEL = 0x1, 32 ADC CLOCK increments
                                                     for ADC_CLKSEL = 0x2.                                                     */
      __IOM uint32_t ADCPWR1    : 8;            /*!< [15..8] ADC Reference Keeper enable delay in 16 ADC CLK increments
                                                     for ADC_CLKSEL = 0x1, 8 ADC CLOCK increments for ADC_CLKSEL
                                                     = 0x2.                                                                    */
            uint32_t            : 16;
    } ADCPWRDLY_b;
  } ;
  __IM  uint32_t  RESERVED2;

  union {
    __IOM uint32_t ADCCAL;                      /*!< (@ 0x0000010C) ADC Calibration Control                                    */

    struct {
      __IOM uint32_t CALONPWRUP : 1;            /*!< [0..0] Run ADC Calibration on initial power up sequence                   */
      __IOM uint32_t ADCCALIBRATED : 1;         /*!< [1..1] Status for ADC Calibration                                         */
            uint32_t            : 30;
    } ADCCAL_b;
  } ;

  union {
    __IOM uint32_t ADCBATTLOAD;                 /*!< (@ 0x00000110) ADC Battery Load Enable                                    */

    struct {
      __IOM uint32_t BATTLOAD   : 1;            /*!< [0..0] Enable the ADC battery load resistor                               */
            uint32_t            : 31;
    } ADCBATTLOAD_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t ADCTRIM;                     /*!< (@ 0x00000118) ADC Trims                                                  */

    struct {
      __IOM uint32_t ADCREFKEEPIBTRIM : 2;      /*!< [1..0] ADC Reference Ibias trim                                           */
            uint32_t            : 4;
      __IOM uint32_t ADCREFBUFTRIM : 5;         /*!< [10..6] ADC Reference buffer trim                                         */
      __IOM uint32_t ADCRFBUFIBTRIM : 2;        /*!< [12..11] ADC reference buffer input bias trim                             */
            uint32_t            : 19;
    } ADCTRIM_b;
  } ;

  union {
    __IOM uint32_t ADCREFCOMP;                  /*!< (@ 0x0000011C) ADC Reference Keeper and Comparator Control                */

    struct {
      __IOM uint32_t ADC_REFCOMP_OUT : 1;       /*!< [0..0] Output of the ADC reference comparator                             */
            uint32_t            : 7;
      __IOM uint32_t ADCREFKEEPTRIM : 5;        /*!< [12..8] ADC Reference Keeper Trim                                         */
            uint32_t            : 3;
      __IOM uint32_t ADCRFCMPEN : 1;            /*!< [16..16] ADC Reference comparator power down                              */
            uint32_t            : 15;
    } ADCREFCOMP_b;
  } ;

  union {
    __IOM uint32_t XTALCTRL;                    /*!< (@ 0x00000120) XTAL Oscillator Control                                    */

    struct {
      __IOM uint32_t XTALSWE    : 1;            /*!< [0..0] XTAL Software Override Enable.                                     */
      __IOM uint32_t FDBKDSBLXTAL : 1;          /*!< [1..1] XTAL Oscillator Disable Feedback.                                  */
      __IOM uint32_t BYPCMPRXTAL : 1;           /*!< [2..2] XTAL Oscillator Bypass Comparator.                                 */
      __IOM uint32_t PDNBCOREXTAL : 1;          /*!< [3..3] XTAL Oscillator Power Down Core.                                   */
      __IOM uint32_t PDNBCMPRXTAL : 1;          /*!< [4..4] XTAL Oscillator Power Down Comparator.                             */
      __IOM uint32_t PWDBODXTAL : 1;            /*!< [5..5] XTAL Power down on brown out.                                      */
      __IOM uint32_t XTALIBUFTRIM : 2;          /*!< [7..6] XTAL IBUFF trim                                                    */
      __IOM uint32_t XTALICOMPTRIM : 2;         /*!< [9..8] XTAL ICOMP trim                                                    */
            uint32_t            : 22;
    } XTALCTRL_b;
  } ;

  union {
    __IOM uint32_t XTALGENCTRL;                 /*!< (@ 0x00000124) XTAL Oscillator General Control                            */

    struct {
      __IOM uint32_t ACWARMUP   : 2;            /*!< [1..0] Auto-calibration delay control                                     */
      __IOM uint32_t XTALBIASTRIM : 6;          /*!< [7..2] XTAL BIAS trim                                                     */
      __IOM uint32_t XTALKSBIASTRIM : 6;        /*!< [13..8] XTAL IBIAS Kick start trim. This trim value is used
                                                     during the startup process to enable a faster lock.                       */
            uint32_t            : 18;
    } XTALGENCTRL_b;
  } ;
  __IM  uint32_t  RESERVED4[28];

  union {
    __IOM uint32_t MISCCTRL;                    /*!< (@ 0x00000198) Miscellaneous control register.                            */

    struct {
      __IOM uint32_t RESERVED_RW_0 : 5;         /*!< [4..0] Reserved bits, always leave unchanged. The MISCCTRL register
                                                     must be modified via atomic RMW, leaving this bit field
                                                     completely unmodified. Failure to do so will result in
                                                     unpredictable behavior.                                                   */
      __IOM uint32_t BLE_RESETN : 1;            /*!< [5..5] BLE reset signal.                                                  */
            uint32_t            : 26;
    } MISCCTRL_b;
  } ;
  __IM  uint32_t  RESERVED5;

  union {
    __IOM uint32_t BOOTLOADER;                  /*!< (@ 0x000001A0) Bootloader and secure boot functions                       */

    struct {
      __IOM uint32_t BOOTLOADERLOW : 1;         /*!< [0..0] Determines whether the bootloader code is visible at
                                                     address 0x00000000 or not. Resets to 1, write 1 to clear.                 */
      __IOM uint32_t SBLOCK     : 1;            /*!< [1..1] Secure boot lock. Always resets to 1, write 1 to clear.
                                                     Enables system visibility to bootloader until set.                        */
      __IOM uint32_t PROTLOCK   : 1;            /*!< [2..2] Flash protection lock. Always resets to 1, write 1 to
                                                     clear. Enables writes to flash protection register set.                   */
            uint32_t            : 23;
      __IOM uint32_t SECBOOTFEATURE : 2;        /*!< [27..26] Indicates whether the secure boot feature is enabled.            */
      __IOM uint32_t SECBOOT    : 2;            /*!< [29..28] Indicates whether the secure boot on cold reset is
                                                     enabled                                                                   */
      __IOM uint32_t SECBOOTONRST : 2;          /*!< [31..30] Indicates whether the secure boot on warm reset is
                                                     enabled                                                                   */
    } BOOTLOADER_b;
  } ;

  union {
    __IOM uint32_t SHADOWVALID;                 /*!< (@ 0x000001A4) Register to indicate whether the shadow registers
                                                                    have been successfully loaded from the Flash
                                                                    Information Space.                                         */

    struct {
      __IOM uint32_t VALID      : 1;            /*!< [0..0] Indicates whether the shadow registers contain valid
                                                     data from the Flash Information Space.                                    */
      __IOM uint32_t BLDSLEEP   : 1;            /*!< [1..1] Indicates whether the bootloader should sleep or deep
                                                     sleep if no image loaded.                                                 */
      __IOM uint32_t INFO0_VALID : 1;           /*!< [2..2] Indicates whether INFO0 contains valid data                        */
            uint32_t            : 29;
    } SHADOWVALID_b;
  } ;
  __IM  uint32_t  RESERVED6[2];

  union {
    __IOM uint32_t SCRATCH0;                    /*!< (@ 0x000001B0) Scratch register that is not reset by any reset            */

    struct {
      __IOM uint32_t SCRATCH0   : 32;           /*!< [31..0] Scratch register 0.                                               */
    } SCRATCH0_b;
  } ;

  union {
    __IOM uint32_t SCRATCH1;                    /*!< (@ 0x000001B4) Scratch register that is not reset by any reset            */

    struct {
      __IOM uint32_t SCRATCH1   : 32;           /*!< [31..0] Scratch register 1.                                               */
    } SCRATCH1_b;
  } ;
  __IM  uint32_t  RESERVED7[2];

  union {
    __IOM uint32_t ICODEFAULTADDR;              /*!< (@ 0x000001C0) ICODE bus address which was present when a bus
                                                                    fault occurred.                                            */

    struct {
      __IOM uint32_t ICODEFAULTADDR : 32;       /*!< [31..0] The ICODE bus address observed when a Bus Fault occurred.
                                                     Once an address is captured in this field, it is held until
                                                     the corresponding Fault Observed bit is cleared in the
                                                     FAULTSTATUS register.                                                     */
    } ICODEFAULTADDR_b;
  } ;

  union {
    __IOM uint32_t DCODEFAULTADDR;              /*!< (@ 0x000001C4) DCODE bus address which was present when a bus
                                                                    fault occurred.                                            */

    struct {
      __IOM uint32_t DCODEFAULTADDR : 32;       /*!< [31..0] The DCODE bus address observed when a Bus Fault occurred.
                                                     Once an address is captured in this field, it is held until
                                                     the corresponding Fault Observed bit is cleared in the
                                                     FAULTSTATUS register.                                                     */
    } DCODEFAULTADDR_b;
  } ;

  union {
    __IOM uint32_t SYSFAULTADDR;                /*!< (@ 0x000001C8) System bus address which was present when a bus
                                                                    fault occurred.                                            */

    struct {
      __IOM uint32_t SYSFAULTADDR : 32;         /*!< [31..0] SYS bus address observed when a Bus Fault occurred.
                                                     Once an address is captured in this field, it is held until
                                                     the corresponding Fault Observed bit is cleared in the
                                                     FAULTSTATUS register.                                                     */
    } SYSFAULTADDR_b;
  } ;

  union {
    __IOM uint32_t FAULTSTATUS;                 /*!< (@ 0x000001CC) Reflects the status of the bus decoders' fault
                                                                    detection. Any write to this register will
                                                                    clear all of the status bits within the
                                                                    register.                                                  */

    struct {
      __IOM uint32_t ICODEFAULT : 1;            /*!< [0..0] The ICODE Bus Decoder Fault Detected bit. When set, a
                                                     fault has been detected, and the ICODEFAULTADDR register
                                                     will contain the bus address which generated the fault.                   */
      __IOM uint32_t DCODEFAULT : 1;            /*!< [1..1] DCODE Bus Decoder Fault Detected bit. When set, a fault
                                                     has been detected, and the DCODEFAULTADDR register will
                                                     contain the bus address which generated the fault.                        */
      __IOM uint32_t SYSFAULT   : 1;            /*!< [2..2] SYS Bus Decoder Fault Detected bit. When set, a fault
                                                     has been detected, and the SYSFAULTADDR register will contain
                                                     the bus address which generated the fault.                                */
            uint32_t            : 29;
    } FAULTSTATUS_b;
  } ;

  union {
    __IOM uint32_t FAULTCAPTUREEN;              /*!< (@ 0x000001D0) Enable the fault capture registers                         */

    struct {
      __IOM uint32_t FAULTCAPTUREEN : 1;        /*!< [0..0] Fault Capture Enable field. When set, the Fault Capture
                                                     monitors are enabled and addresses which generate a hard
                                                     fault are captured into the FAULTADDR registers.                          */
            uint32_t            : 31;
    } FAULTCAPTUREEN_b;
  } ;
  __IM  uint32_t  RESERVED8[11];

  union {
    __IOM uint32_t DBGR1;                       /*!< (@ 0x00000200) Read-only debug register 1                                 */

    struct {
      __IOM uint32_t ONETO8     : 32;           /*!< [31..0] Read-only register for communication validation                   */
    } DBGR1_b;
  } ;

  union {
    __IOM uint32_t DBGR2;                       /*!< (@ 0x00000204) Read-only debug register 2                                 */

    struct {
      __IOM uint32_t COOLCODE   : 32;           /*!< [31..0] Read-only register for communication validation                   */
    } DBGR2_b;
  } ;
  __IM  uint32_t  RESERVED9[6];

  union {
    __IOM uint32_t PMUENABLE;                   /*!< (@ 0x00000220) Control bit to enable/disable the PMU                      */

    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< [0..0] PMU Enable Control bit. When set, the MCU's PMU will
                                                     place the MCU into the lowest power consuming Deep Sleep
                                                     mode upon execution of a WFI instruction (dependent on
                                                     the setting of the SLEEPDEEP bit in the ARM SCR register).
                                                     When cleared, regardless of the requested sleep mode, the
                                                     PMU will not enter the lowest power Deep Sleep mode, instead
                                                     entering the Sleep mode.                                                  */
            uint32_t            : 31;
    } PMUENABLE_b;
  } ;
  __IM  uint32_t  RESERVED10[11];

  union {
    __IOM uint32_t TPIUCTRL;                    /*!< (@ 0x00000250) TPIU Control Register. Determines the clock enable
                                                                    and frequency for the M4's TPIU interface.                 */

    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< [0..0] TPIU Enable field. When set, the ARM M4 TPIU is enabled
                                                     and data can be streamed out of the MCU's SWO port using
                                                     the ARM ITM and TPIU modules.                                             */
            uint32_t            : 7;
      __IOM uint32_t CLKSEL     : 3;            /*!< [10..8] This field selects the frequency of the ARM M4 TPIU
                                                     port.                                                                     */
            uint32_t            : 21;
    } TPIUCTRL_b;
  } ;
  __IM  uint32_t  RESERVED11[4];

  union {
    __IOM uint32_t OTAPOINTER;                  /*!< (@ 0x00000264) OTA (Over the Air) Update Pointer/Status. Reset
                                                                    only by POA                                                */

    struct {
      __IOM uint32_t OTAVALID   : 1;            /*!< [0..0] Indicates that an OTA update is valid                              */
      __IOM uint32_t OTASBLUPDATE : 1;          /*!< [1..1] Indicates that the sbl_init has been updated                       */
      __IOM uint32_t OTAPOINTER : 30;           /*!< [31..2] Flash page pointer with updated OTA image                         */
    } OTAPOINTER_b;
  } ;
  __IM  uint32_t  RESERVED12[6];

  union {
    __IOM uint32_t APBDMACTRL;                  /*!< (@ 0x00000280) DMA Control Register. Determines misc settings
                                                                    for DMA operation                                          */

    struct {
      __IOM uint32_t DMA_ENABLE : 1;            /*!< [0..0] Enable the DMA controller. When disabled, DMA requests
                                                     will be ignored by the controller                                         */
      __IOM uint32_t DECODEABORT : 1;           /*!< [1..1] APB Decode Abort. When set, the APB bridge will issue
                                                     a data abort (bus fault) on transactions to peripherals
                                                     that are powered down. When set to 0, writes are quietly
                                                     discarded and reads return 0.                                             */
            uint32_t            : 6;
      __IOM uint32_t HYSTERESIS : 8;            /*!< [15..8] This field determines how long the DMA will remain active
                                                     during deep sleep before shutting down and returning the
                                                     system to full deep sleep. Values are based on a 94KHz
                                                     clock and are roughly 10 us increments for a range of ~10
                                                     us to 2.55 ms                                                             */
            uint32_t            : 16;
    } APBDMACTRL_b;
  } ;

  union {
    __IOM uint32_t SRAMMODE;                    /*!< (@ 0x00000284) SRAM Controller mode bits                                  */

    struct {
      __IOM uint32_t IPREFETCH  : 1;            /*!< [0..0] When set, instruction accesses to the SRAM banks will
                                                     be pre-fetched (normally 2 cycle read access). Generally,
                                                     this mode bit should be set for improved performance when
                                                     executing instructions from SRAM.                                         */
      __IOM uint32_t IPREFETCH_CACHE : 1;       /*!< [1..1] Secondary pre-fetch feature that will cache pre-fetched
                                                     data across bus wait states (requires IPREFETCH to be set).               */
            uint32_t            : 2;
      __IOM uint32_t DPREFETCH  : 1;            /*!< [4..4] When set, data bus accesses to the SRAM banks will be
                                                     pre-fetched (normally 2 cycle read access). Use of this
                                                     mode bit is only recommended if the work flow has a large
                                                     number of sequential accesses.                                            */
      __IOM uint32_t DPREFETCH_CACHE : 1;       /*!< [5..5] Secondary pre-fetch feature that will cache pre-fetched
                                                     data across bus wait states (requires DPREFETCH to be set).               */
            uint32_t            : 26;
    } SRAMMODE_b;
  } ;
  __IM  uint32_t  RESERVED13[48];

  union {
    __IOM uint32_t KEXTCLKSEL;                  /*!< (@ 0x00000348) Locks the state of the EXTCLKSEL register from
                                                                    writes. This is done to prevent errant writes
                                                                    to the register, as this could cause the
                                                                    chip to halt. Write a value of 0x53 to unlock
                                                                    write access to the EXTCLKSEL register.
                                                                    Once unlocked, the register will read back
                                                                    a 1 to indicate this is unlocked. Writing
                                                                    the register with any other value other
                                                                    than 0x53 will enable the lock.                            */

    struct {
      __IOM uint32_t KEXTCLKSEL : 32;           /*!< [31..0] Key register value.                                               */
    } KEXTCLKSEL_b;
  } ;
  __IM  uint32_t  RESERVED14;

  union {
    __IOM uint32_t SIMOBUCK1;                   /*!< (@ 0x00000350) SIMO Buck Control Reg 1                                    */

    struct {
      __IOM uint32_t COREACTIVETRIM : 10;       /*!< [9..0] simobuck_core_active_trim (VDDF)                                   */
      __IOM uint32_t SIMOBUCKCORELPTRIM : 6;    /*!< [15..10] simobuck_core_lp_trim                                            */
      __IOM uint32_t MEMACTIVETRIM : 6;         /*!< [21..16] simobuck_mem_active_trim (VDDC)                                  */
      __IOM uint32_t SIMOBUCKMEMLPTRIM : 6;     /*!< [27..22] simobuck_mem_lp_trim                                             */
      __IOM uint32_t CORETEMPCOTRIM : 4;        /*!< [31..28] simobuck_core_tempco_trim                                        */
    } SIMOBUCK1_b;
  } ;

  union {
    __IOM uint32_t SIMOBUCK2;                   /*!< (@ 0x00000354) SIMO Buck Control Reg 2                                    */

    struct {
      __IOM uint32_t SIMOBUCKTONGENTRIM : 5;    /*!< [4..0] simobuck_tongen_trim                                               */
      __IOM uint32_t RESERVED_RW_5 : 11;        /*!< [15..5] Reserved bits, always leave unchanged. The SIMOBUCK2
                                                     register must be modified via atomic RMW, leaving this
                                                     bit field completely unmodified. Failure to do so will
                                                     result in unpredictable behavior.                                         */
      __IOM uint32_t SIMOBUCKCORELPHIGHTONTRIM : 4;/*!< [19..16] simobuck_core_lp_high_ton_trim                                */
      __IOM uint32_t SIMOBUCKCORELPLOWTONTRIM : 4;/*!< [23..20] simobuck_core_lp_low_ton_trim                                  */
      __IOM uint32_t RESERVED_RW_24 : 4;        /*!< [27..24] Reserved bits, always leave unchanged. The SIMOBUCK2
                                                     register must be modified via atomic RMW, leaving this
                                                     bit field completely unmodified. Failure to do so will
                                                     result in unpredictable behavior.                                         */
      __IOM uint32_t SIMOBUCKCORELEAKAGETRIM : 2;/*!< [29..28] simobuck_core_leakage_trim                                      */
      __IOM uint32_t RESERVED_RW_30 : 2;        /*!< [31..30] Reserved bits, always leave unchanged. The SIMOBUCK2
                                                     register must be modified via atomic RMW, leaving this
                                                     bit field completely unmodified. Failure to do so will
                                                     result in unpredictable behavior.                                         */
    } SIMOBUCK2_b;
  } ;

  union {
    __IOM uint32_t SIMOBUCK3;                   /*!< (@ 0x00000358) SIMO Buck Control Reg 3                                    */

    struct {
      __IOM uint32_t SIMOBUCKCORELPHIGHTOFFTRIM : 4;/*!< [3..0] simobuck_core_lp_high_toff_trim                                */
      __IOM uint32_t SIMOBUCKCORELPLOWTOFFTRIM : 4;/*!< [7..4] simobuck_core_lp_low_toff_trim                                  */
      __IOM uint32_t SIMOBUCKMEMLPHIGHTOFFTRIM : 4;/*!< [11..8] simobuck_mem_lp_high_toff_trim                                 */
      __IOM uint32_t SIMOBUCKMEMLPLOWTOFFTRIM : 4;/*!< [15..12] simobuck_mem_lp_low_toff_trim                                  */
      __IOM uint32_t RESERVED_RW_16 : 11;       /*!< [26..16] Reserved bits, always leave unchanged. The SIMOBUCK3
                                                     register must be modified via atomic RMW, leaving this
                                                     bit field completely unmodified. Failure to do so will
                                                     result in unpredictable behavior.                                         */
      __IOM uint32_t SIMOBUCKMEMLPHIGHTONTRIM : 4;/*!< [30..27] simobuck_mem_lp_high_ton_trim                                  */
      __IOM uint32_t RESERVED_RW_31 : 1;        /*!< [31..31] Reserved bits, always leave unchanged. The SIMOBUCK2
                                                     register must be modified via atomic RMW, leaving this
                                                     bit field completely unmodified. Failure to do so will
                                                     result in unpredictable behavior.                                         */
    } SIMOBUCK3_b;
  } ;

  union {
    __IOM uint32_t SIMOBUCK4;                   /*!< (@ 0x0000035C) SIMO Buck Control Reg 4                                    */

    struct {
      __IOM uint32_t SIMOBUCKMEMLPLOWTONTRIM : 4;/*!< [3..0] simobuck_mem_lp_low_ton_trim                                      */
            uint32_t            : 17;
      __IOM uint32_t SIMOBUCKCLKDIVSEL : 2;     /*!< [22..21] simobuck_clkdiv_sel                                              */
      __IOM uint32_t SIMOBUCKCOMP2LPEN : 1;     /*!< [23..23] simobuck_comp2_lp_en                                             */
      __IOM uint32_t SIMOBUCKCOMP2TIMEOUTEN : 1;/*!< [24..24] simobuck_comp2_timeout_en                                        */
            uint32_t            : 7;
    } SIMOBUCK4_b;
  } ;
  __IM  uint32_t  RESERVED15[2];

  union {
    __IOM uint32_t BLEBUCK2;                    /*!< (@ 0x00000368) BLEBUCK2 Control Reg                                       */

    struct {
      __IOM uint32_t BLEBUCKTONLOWTRIM : 6;     /*!< [5..0] blebuck_ton_low_trim                                               */
      __IOM uint32_t BLEBUCKTONHITRIM : 6;      /*!< [11..6] blebuck_ton_hi_trim                                               */
      __IOM uint32_t BLEBUCKTOND2ATRIM : 6;     /*!< [17..12] blebuck_ton_trim                                                 */
            uint32_t            : 14;
    } BLEBUCK2_b;
  } ;
  __IM  uint32_t  RESERVED16[13];

  union {
    __IOM uint32_t FLASHWPROT0;                 /*!< (@ 0x000003A0) These bits write-protect flash in 16KB chunks.             */

    struct {
      __IOM uint32_t FW0BITS    : 32;           /*!< [31..0] Write protect flash 0x00000000 - 0x0007FFFF. Each bit
                                                     provides write protection for 16KB chunks of flash data
                                                     space. Bits are cleared by writing a 1 to the bit. When
                                                     read, 0 indicates the region is protected. Bits are sticky
                                                     (can be set when PROTLOCK is 1, but only cleared by reset)                */
    } FLASHWPROT0_b;
  } ;

  union {
    __IOM uint32_t FLASHWPROT1;                 /*!< (@ 0x000003A4) These bits write-protect flash in 16KB chunks.             */

    struct {
      __IOM uint32_t FW1BITS    : 32;           /*!< [31..0] Write protect flash 0x00080000 - 0x000FFFFF. Each bit
                                                     provides write protection for 16KB chunks of flash data
                                                     space. Bits are cleared by writing a 1 to the bit. When
                                                     read, 0 indicates the region is protected. Bits are sticky
                                                     (can be set when PROTLOCK is 1, but only cleared by reset)                */
    } FLASHWPROT1_b;
  } ;
  __IM  uint32_t  RESERVED17[2];

  union {
    __IOM uint32_t FLASHRPROT0;                 /*!< (@ 0x000003B0) These bits read-protect flash in 16KB chunks.              */

    struct {
      __IOM uint32_t FR0BITS    : 32;           /*!< [31..0] Copy (read) protect flash 0x00000000 - 0x0007FFFF. Each
                                                     bit provides read protection for 16KB chunks of flash.
                                                     Bits are cleared by writing a 1 to the bit. When read,
                                                     0 indicates the region is protected. Bits are sticky (can
                                                     be set when PROTLOCK is 1, but only cleared by reset)                     */
    } FLASHRPROT0_b;
  } ;

  union {
    __IOM uint32_t FLASHRPROT1;                 /*!< (@ 0x000003B4) These bits read-protect flash in 16KB chunks.              */

    struct {
      __IOM uint32_t FR1BITS    : 32;           /*!< [31..0] Copy (read) protect flash 0x00080000 - 0x000FFFFF. Each
                                                     bit provides read protection for 16KB chunks of flash.
                                                     Bits are cleared by writing a 1 to the bit. When read,
                                                     0 indicates the region is protected. Bits are sticky (can
                                                     be set when PROTLOCK is 1, but only cleared by reset)                     */
    } FLASHRPROT1_b;
  } ;
  __IM  uint32_t  RESERVED18[2];

  union {
    __IOM uint32_t DMASRAMWRITEPROTECT0;        /*!< (@ 0x000003C0) These bits write-protect system SRAM from DMA
                                                                    operations in 8KB chunks.                                  */

    struct {
      __IOM uint32_t DMA_WPROT0 : 32;           /*!< [31..0] Write protect SRAM from DMA. Each bit provides write
                                                     protection for an 8KB region of memory. When set to 1,
                                                     the region will be protected from DMA writes, when set
                                                     to 0, DMA may write the region.                                           */
    } DMASRAMWRITEPROTECT0_b;
  } ;

  union {
    __IOM uint32_t DMASRAMWRITEPROTECT1;        /*!< (@ 0x000003C4) These bits write-protect system SRAM from DMA
                                                                    operations in 8KB chunks.                                  */

    struct {
      __IOM uint32_t DMA_WPROT1 : 16;           /*!< [15..0] Write protect SRAM from DMA. Each bit provides write
                                                     protection for an 8KB region of memory. When set to 1,
                                                     the region will be protected from DMA writes, when set
                                                     to 0, DMA may write the region.                                           */
            uint32_t            : 16;
    } DMASRAMWRITEPROTECT1_b;
  } ;
  __IM  uint32_t  RESERVED19[2];

  union {
    __IOM uint32_t DMASRAMREADPROTECT0;         /*!< (@ 0x000003D0) These bits read-protect system SRAM from DMA
                                                                    operations in 8KB chunks.                                  */

    struct {
      __IOM uint32_t DMA_RPROT0 : 32;           /*!< [31..0] Read protect SRAM from DMA. Each bit provides write
                                                     protection for an 8KB region of memory. When set to 1,
                                                     the region will be protected from DMA reads, when set to
                                                     0, DMA may read the region.                                               */
    } DMASRAMREADPROTECT0_b;
  } ;

  union {
    __IOM uint32_t DMASRAMREADPROTECT1;         /*!< (@ 0x000003D4) These bits read-protect system SRAM from DMA
                                                                    operations in 8KB chunks.                                  */

    struct {
      __IOM uint32_t DMA_RPROT1 : 16;           /*!< [15..0] Read protect SRAM from DMA. Each bit provides write
                                                     protection for an 8KB region of memory. When set to 1,
                                                     the region will be protected from DMA reads, when set to
                                                     0, DMA may read the region.                                               */
            uint32_t            : 16;
    } DMASRAMREADPROTECT1_b;
  } ;
} MCUCTRL_Type;                                 /*!< Size = 984 (0x3d8)                                                        */



/* =========================================================================================================================== */
/* ================                                           MSPI                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Multi-bit SPI Master (MSPI)
  */

typedef struct {                                /*!< (@ 0x50014000) MSPI Structure                                             */

  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) This register is used to enable individual PIO
                                                                    based transactions to a device on the bus.
                                                                    The CFG register must be programmed properly
                                                                    for the transfer, and the ADDR and INSTR
                                                                    registers should be programmed if the SENDI
                                                                    and SENDA fields are enabled.                              */

    struct {
      __IOM uint32_t START      : 1;            /*!< [0..0] Write to 1 to initiate a PIO transaction on the bus (typically
                                                     the entire register should be written at once with this
                                                     bit set).                                                                 */
      __IOM uint32_t STATUS     : 1;            /*!< [1..1] Command status: 1 indicates command has completed. Cleared
                                                     by writing 1 to this bit or starting a new transfer.                      */
      __IOM uint32_t BUSY       : 1;            /*!< [2..2] Command status: 1 indicates controller is busy (command
                                                     in progress)                                                              */
      __IOM uint32_t QUADCMD    : 1;            /*!< [3..3] Flag indicating that the operation is a command that
                                                     should be replicated to both devices in paired QUAD mode.
                                                     This is typically only used when reading/writing configuration
                                                     registers in paired flash devices (do not set for memory
                                                     transfers).                                                               */
            uint32_t            : 2;
      __IOM uint32_t BIGENDIAN  : 1;            /*!< [6..6] 1 indicates data in FIFO is in big endian format (MSB
                                                     first); 0 indicates little endian data (default, LSB first).              */
      __IOM uint32_t ENTURN     : 1;            /*!< [7..7] Indicates whether TX->RX turnaround cycles should be
                                                     enabled for this operation (see TURNAROUND field in CFG
                                                     register).                                                                */
      __IOM uint32_t SENDA      : 1;            /*!< [8..8] Indicates whether an address phase should be sent (see
                                                     ADDR register and ASIZE field in CFG register)                            */
      __IOM uint32_t SENDI      : 1;            /*!< [9..9] Indicates whether an instruction phase should be sent
                                                     (see INSTR field and ISIZE field in CFG register)                         */
      __IOM uint32_t TXRX       : 1;            /*!< [10..10] 1 Indicates a TX operation, 0 indicates an RX operation
                                                     of XFERBYTES                                                              */
      __IOM uint32_t PIOSCRAMBLE : 1;           /*!< [11..11] Enables data scrambling for PIO operations. This should
                                                     only be used for data operations and never for commands
                                                     to a device.                                                              */
            uint32_t            : 4;
      __IOM uint32_t XFERBYTES  : 16;           /*!< [31..16] Number of bytes to transmit or receive (based on TXRX
                                                     bit)                                                                      */
    } CTRL_b;
  } ;

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000004) Command formatting for PIO based transactions
                                                                    (initiated by writes to CTRL register)                     */

    struct {
      __IOM uint32_t DEVCFG     : 4;            /*!< [3..0] Flash configuration for XIP and AUTO DMA operations.
                                                     Controls value for SER (Slave Enable) for XIP operations
                                                     and address generation for DMA/XIP modes. Also used to
                                                     configure SPIFRF (frame format).                                          */
      __IOM uint32_t ASIZE      : 2;            /*!< [5..4] Address Size. Address bytes to send from ADDR register             */
      __IOM uint32_t ISIZE      : 1;            /*!< [6..6] Instruction Sizeenum name = I8 value = 0x0 desc = Instruction
                                                     is 1 byteenum name = I16 value = 0x1 desc = Instruction
                                                     is 2 bytes                                                                */
      __IOM uint32_t SEPIO      : 1;            /*!< [7..7] Separate IO configuration. This bit should be set when
                                                     the target device has separate MOSI and MISO pins. Respective
                                                     IN/OUT bits below should be set to map pins.                              */
      __IOM uint32_t TURNAROUND : 6;            /*!< [13..8] Number of turnaround cycles (for TX->RX transitions).
                                                     Qualified by ENTURN or XIPENTURN bit field.                               */
            uint32_t            : 2;
      __IOM uint32_t CPHA       : 1;            /*!< [16..16] Serial clock phase.                                              */
      __IOM uint32_t CPOL       : 1;            /*!< [17..17] Serial clock polarity.                                           */
            uint32_t            : 14;
    } CFG_b;
  } ;

  union {
    __IOM uint32_t ADDR;                        /*!< (@ 0x00000008) Optional Address field to send for PIO transfers           */

    struct {
      __IOM uint32_t ADDR       : 32;           /*!< [31..0] Optional Address field to send (after optional instruction
                                                     field) - qualified by ASIZE in CMD register. NOTE: This
                                                     register is aliased to DMADEVADDR.                                        */
    } ADDR_b;
  } ;

  union {
    __IOM uint32_t INSTR;                       /*!< (@ 0x0000000C) Optional Instruction field to send for PIO transfers       */

    struct {
      __IOM uint32_t INSTR      : 16;           /*!< [15..0] Optional Instruction field to send (1st byte) - qualified
                                                     by ISEND/ISIZE                                                            */
            uint32_t            : 16;
    } INSTR_b;
  } ;

  union {
    __IOM uint32_t TXFIFO;                      /*!< (@ 0x00000010) TX Data FIFO                                               */

    struct {
      __IOM uint32_t TXFIFO     : 32;           /*!< [31..0] Data to be transmitted. Data should normally be aligned
                                                     to the LSB (pad the upper bits with zeros) unless BIGENDIAN
                                                     is set.                                                                   */
    } TXFIFO_b;
  } ;

  union {
    __IOM uint32_t RXFIFO;                      /*!< (@ 0x00000014) RX Data FIFO                                               */

    struct {
      __IOM uint32_t RXFIFO     : 32;           /*!< [31..0] Receive data. Data is aligned to the LSB (padded zeros
                                                     on upper bits) unless BIGENDIAN is set.                                   */
    } RXFIFO_b;
  } ;

  union {
    __IOM uint32_t TXENTRIES;                   /*!< (@ 0x00000018) Number of words in TX FIFO                                 */

    struct {
      __IOM uint32_t TXENTRIES  : 5;            /*!< [4..0] Number of 32-bit words/entries in TX FIFO                          */
            uint32_t            : 27;
    } TXENTRIES_b;
  } ;

  union {
    __IOM uint32_t RXENTRIES;                   /*!< (@ 0x0000001C) Number of words in RX FIFO                                 */

    struct {
      __IOM uint32_t RXENTRIES  : 5;            /*!< [4..0] Number of 32-bit words/entries in RX FIFO                          */
            uint32_t            : 27;
    } RXENTRIES_b;
  } ;

  union {
    __IOM uint32_t THRESHOLD;                   /*!< (@ 0x00000020) Threshold levels that trigger RXFull and TXEmpty
                                                                    interrupts                                                 */

    struct {
      __IOM uint32_t TXTHRESH   : 5;            /*!< [4..0] Number of entries in TX FIFO that cause TXF interrupt              */
            uint32_t            : 3;
      __IOM uint32_t RXTHRESH   : 5;            /*!< [12..8] Number of entries in TX FIFO that cause RXE interrupt             */
            uint32_t            : 19;
    } THRESHOLD_b;
  } ;
  __IM  uint32_t  RESERVED[55];

  union {
    __IOM uint32_t MSPICFG;                     /*!< (@ 0x00000100) Timing configuration bits for the MSPI module.
                                                                    PRSTN, IPRSTN, and FIFORESET can be used
                                                                    to reset portions of the MSPI interface
                                                                    in order to clear error conditions. The
                                                                    remaining bits control clock frequency and
                                                                    TX/RX capture timings.                                     */

    struct {
      __IOM uint32_t APBCLK     : 1;            /*!< [0..0] Enable continuous APB clock. For power-efficient operation,
                                                     APBCLK should be set to 0.                                                */
      __IOM uint32_t RXCAP      : 1;            /*!< [1..1] Controls RX data capture phase. A setting of 0 (NORMAL)
                                                     captures read data at the normal capture point relative
                                                     to the internal clock launch point. However, to accommodate
                                                     chip/pad/board delays, a setting of RXCAP of 1 is expected
                                                     to be used to align the capture point with the return data
                                                     window. This bit is used in conjunction with RXNEG to provide
                                                     4 unique capture points, all about 10 ns apart.                           */
      __IOM uint32_t RXNEG      : 1;            /*!< [2..2] Adjusts the RX capture phase to the negedge of the 48MHz
                                                     internal clock (~10 ns early). For normal operation, it
                                                     is expected that RXNEG will be set to 0.                                  */
      __IOM uint32_t TXNEG      : 1;            /*!< [3..3] Launches TX data a half clock cycle (~10 ns) early. This
                                                     should normally be programmed to zero (NORMAL).                           */
      __IOM uint32_t IOMSEL     : 3;            /*!< [6..4] Selects which IOM is selected for CQ handshake status.             */
            uint32_t            : 1;
      __IOM uint32_t CLKDIV     : 6;            /*!< [13..8] Clock Divider. Allows dividing 48 MHz base clock by
                                                     integer multiples. Enumerations are provided for common
                                                     frequency, but any integer divide from 48 MHz is allowed.
                                                     Odd divide ratios will result in a 33/66 percent duty cycle
                                                     with a long low clock pulse (to allow longer round-trip
                                                     for read data).                                                           */
            uint32_t            : 15;
      __IOM uint32_t FIFORESET  : 1;            /*!< [29..29] Reset MSPI FIFO (active high). 1=reset FIFO, 0=normal
                                                     operation. May be used to manually flush the FIFO in error
                                                     handling.                                                                 */
      __IOM uint32_t IPRSTN     : 1;            /*!< [30..30] IP block reset. Write to 0 to put the transfer module
                                                     in reset or 1 for normal operation. This may be required
                                                     after error conditions to clear the transfer on the bus.                  */
      __IOM uint32_t PRSTN      : 1;            /*!< [31..31] Peripheral reset. Master reset to the entire MSPI module
                                                     (DMA, XIP, and transfer state machines). 1=normal operation,
                                                     0=in reset.                                                               */
    } MSPICFG_b;
  } ;

  union {
    __IOM uint32_t PADCFG;                      /*!< (@ 0x00000104) Configuration bits for the MSPI pads. Allows
                                                                    pads associated with the upper quad to be
                                                                    mapped to corresponding bits on the lower
                                                                    quad. Use of Quad0 pins is recommended for
                                                                    optimal timing.                                            */

    struct {
      __IOM uint32_t OUT3       : 1;            /*!< [0..0] Output pad 3 configuration. 0=data[3] 1=CLK                        */
      __IOM uint32_t OUT4       : 1;            /*!< [1..1] Output pad 4 configuration. 0=data[4] 1=data[0]                    */
      __IOM uint32_t OUT5       : 1;            /*!< [2..2] Output pad 5 configuration. 0=data[5] 1=data[1]                    */
      __IOM uint32_t OUT6       : 1;            /*!< [3..3] Output pad 6 configuration. 0=data[6] 1=data[2]                    */
      __IOM uint32_t OUT7       : 1;            /*!< [4..4] Output pad 7 configuration. 0=data[7] 1=data[3]                    */
            uint32_t            : 11;
      __IOM uint32_t IN0        : 2;            /*!< [17..16] Data Input pad 0 pin muxing: 0=pad[0] 1=pad[4] 2=pad[1]
                                                     3=pad[5]                                                                  */
      __IOM uint32_t IN1        : 1;            /*!< [18..18] Data Input pad 1 pin muxing: 0=pad[1] 1=pad[5]                   */
      __IOM uint32_t IN2        : 1;            /*!< [19..19] Data Input pad 2 pin muxing: 0=pad[2] 1=pad[6]                   */
      __IOM uint32_t IN3        : 1;            /*!< [20..20] Data Input pad 3 pin muxing: 0=pad[3] 1=pad[7]                   */
      __IOM uint32_t REVCS      : 1;            /*!< [21..21] Reverse CS connections. Allows CS1 to be associated
                                                     with lower data lanes and CS0 to be associated with upper
                                                     data lines                                                                */
            uint32_t            : 10;
    } PADCFG_b;
  } ;

  union {
    __IOM uint32_t PADOUTEN;                    /*!< (@ 0x00000108) Enable bits for the MSPI output pads. Each active
                                                                    MSPI line should be set to 1 in the OUTEN
                                                                    field below.                                               */

    struct {
      __IOM uint32_t OUTEN      : 9;            /*!< [8..0] Output pad enable configuration. Indicates which pads
                                                     should be driven. Bits [3:0] are Quad0 data, [7:4] are
                                                     Quad1 data, and [8] is clock.                                             */
            uint32_t            : 23;
    } PADOUTEN_b;
  } ;

  union {
    __IOM uint32_t FLASH;                       /*!< (@ 0x0000010C) When any SPI flash is configured, this register
                                                                    must be properly programmed before XIP or
                                                                    AUTO DMA operations commence.                              */

    struct {
      __IOM uint32_t XIPEN      : 1;            /*!< [0..0] Enable the XIP (eXecute In Place) function which effectively
                                                     enables the address decoding of the MSPI device in the
                                                     flash/cache address space at address 0x04000000-0x07FFFFFF.               */
            uint32_t            : 1;
      __IOM uint32_t XIPACK     : 2;            /*!< [3..2] Controls transmission of Micron XIP acknowledge cycles
                                                     (Micron Flash devices only)                                               */
      __IOM uint32_t XIPBIGENDIAN : 1;          /*!< [4..4] Indicates whether XIP/AUTO DMA data transfers are in
                                                     big or little endian format                                               */
      __IOM uint32_t XIPENTURN  : 1;            /*!< [5..5] Indicates whether XIP/AUTO DMA operations should enable
                                                     TX->RX turnaround cycles                                                  */
      __IOM uint32_t XIPSENDA   : 1;            /*!< [6..6] Indicates whether XIP/AUTO DMA operations should send
                                                     an an address phase (see DMADEVADDR register and ASIZE
                                                     field in CFG)                                                             */
      __IOM uint32_t XIPSENDI   : 1;            /*!< [7..7] Indicates whether XIP/AUTO DMA operations should send
                                                     an instruction (see READINSTR field and ISIZE field in
                                                     CFG)                                                                      */
      __IOM uint32_t XIPMIXED   : 3;            /*!< [10..8] Provides override controls for data operations where
                                                     instruction, address, and data may transfer in different
                                                     rates.                                                                    */
            uint32_t            : 5;
      __IOM uint32_t WRITEINSTR : 8;            /*!< [23..16] Write command sent for DMA operations                            */
      __IOM uint32_t READINSTR  : 8;            /*!< [31..24] Read command sent to flash for DMA/XIP operations                */
    } FLASH_b;
  } ;
  __IM  uint32_t  RESERVED1[4];

  union {
    __IOM uint32_t SCRAMBLING;                  /*!< (@ 0x00000120) Enables data scrambling for the specified range
                                                                    external flash addresses. Scrambling does
                                                                    not impact flash access performance.                       */

    struct {
      __IOM uint32_t SCRSTART   : 10;           /*!< [9..0] Scrambling region start address [25:16] (64K block granularity).
                                                     The START block is the FIRST block included in the scrambled
                                                     address range.                                                            */
            uint32_t            : 6;
      __IOM uint32_t SCREND     : 10;           /*!< [25..16] Scrambling region end address [25:16] (64K block granularity).
                                                     The END block is the LAST block included in the scrambled
                                                     address range.                                                            */
            uint32_t            : 5;
      __IOM uint32_t SCRENABLE  : 1;            /*!< [31..31] Enables Data Scrambling Region. When 1 reads and writes
                                                     to the range will be scrambled. When 0, data will be read/written
                                                     unmodified. Address range is specified in 64K granularity
                                                     and the START/END ranges are included within the range.                   */
    } SCRAMBLING_b;
  } ;
  __IM  uint32_t  RESERVED2[55];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Transfer complete. Note that DMA and CQ operations are
                                                     layered, so CMDCMP, DCMP, and CQ* can all be signaled simultaneously.     */
      __IOM uint32_t TXE        : 1;            /*!< [1..1] Transmit FIFO empty.                                               */
      __IOM uint32_t TXO        : 1;            /*!< [2..2] Transmit FIFO Overflow (only occurs when SW writes to
                                                     a full FIFO).                                                             */
      __IOM uint32_t RXU        : 1;            /*!< [3..3] Receive FIFO underflow (only occurs when SW reads from
                                                     an empty FIFO)                                                            */
      __IOM uint32_t RXO        : 1;            /*!< [4..4] Receive FIFO overflow (cannot happen in MSPI design --
                                                     MSPI bus pins will stall)                                                 */
      __IOM uint32_t RXF        : 1;            /*!< [5..5] Receive FIFO full                                                  */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Complete Interrupt                                             */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Interrupt                                                */
      __IOM uint32_t CQCMP      : 1;            /*!< [8..8] Command Queue Complete Interrupt                                   */
      __IOM uint32_t CQUPD      : 1;            /*!< [9..9] Command Queue Update Interrupt. Issued whenever the CQ
                                                     performs an operation where address bit[0] is set. Useful
                                                     for triggering CURIDX interrupts.                                         */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [10..10] Command Queue is Paused.                                         */
      __IOM uint32_t CQERR      : 1;            /*!< [11..11] Command Queue Error Interrupt                                    */
      __IOM uint32_t SCRERR     : 1;            /*!< [12..12] Scrambling Alignment Error. Scrambling operations must
                                                     be aligned to word (4-byte) start address.                                */
            uint32_t            : 19;
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Transfer complete. Note that DMA and CQ operations are
                                                     layered, so CMDCMP, DCMP, and CQ* can all be signaled simultaneously.     */
      __IOM uint32_t TXE        : 1;            /*!< [1..1] Transmit FIFO empty.                                               */
      __IOM uint32_t TXO        : 1;            /*!< [2..2] Transmit FIFO Overflow (only occurs when SW writes to
                                                     a full FIFO).                                                             */
      __IOM uint32_t RXU        : 1;            /*!< [3..3] Receive FIFO underflow (only occurs when SW reads from
                                                     an empty FIFO)                                                            */
      __IOM uint32_t RXO        : 1;            /*!< [4..4] Receive FIFO overflow (cannot happen in MSPI design --
                                                     MSPI bus pins will stall)                                                 */
      __IOM uint32_t RXF        : 1;            /*!< [5..5] Receive FIFO full                                                  */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Complete Interrupt                                             */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Interrupt                                                */
      __IOM uint32_t CQCMP      : 1;            /*!< [8..8] Command Queue Complete Interrupt                                   */
      __IOM uint32_t CQUPD      : 1;            /*!< [9..9] Command Queue Update Interrupt. Issued whenever the CQ
                                                     performs an operation where address bit[0] is set. Useful
                                                     for triggering CURIDX interrupts.                                         */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [10..10] Command Queue is Paused.                                         */
      __IOM uint32_t CQERR      : 1;            /*!< [11..11] Command Queue Error Interrupt                                    */
      __IOM uint32_t SCRERR     : 1;            /*!< [12..12] Scrambling Alignment Error. Scrambling operations must
                                                     be aligned to word (4-byte) start address.                                */
            uint32_t            : 19;
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Transfer complete. Note that DMA and CQ operations are
                                                     layered, so CMDCMP, DCMP, and CQ* can all be signaled simultaneously.     */
      __IOM uint32_t TXE        : 1;            /*!< [1..1] Transmit FIFO empty.                                               */
      __IOM uint32_t TXO        : 1;            /*!< [2..2] Transmit FIFO Overflow (only occurs when SW writes to
                                                     a full FIFO).                                                             */
      __IOM uint32_t RXU        : 1;            /*!< [3..3] Receive FIFO underflow (only occurs when SW reads from
                                                     an empty FIFO)                                                            */
      __IOM uint32_t RXO        : 1;            /*!< [4..4] Receive FIFO overflow (cannot happen in MSPI design --
                                                     MSPI bus pins will stall)                                                 */
      __IOM uint32_t RXF        : 1;            /*!< [5..5] Receive FIFO full                                                  */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Complete Interrupt                                             */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Interrupt                                                */
      __IOM uint32_t CQCMP      : 1;            /*!< [8..8] Command Queue Complete Interrupt                                   */
      __IOM uint32_t CQUPD      : 1;            /*!< [9..9] Command Queue Update Interrupt. Issued whenever the CQ
                                                     performs an operation where address bit[0] is set. Useful
                                                     for triggering CURIDX interrupts.                                         */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [10..10] Command Queue is Paused.                                         */
      __IOM uint32_t CQERR      : 1;            /*!< [11..11] Command Queue Error Interrupt                                    */
      __IOM uint32_t SCRERR     : 1;            /*!< [12..12] Scrambling Alignment Error. Scrambling operations must
                                                     be aligned to word (4-byte) start address.                                */
            uint32_t            : 19;
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< [0..0] Transfer complete. Note that DMA and CQ operations are
                                                     layered, so CMDCMP, DCMP, and CQ* can all be signaled simultaneously.     */
      __IOM uint32_t TXE        : 1;            /*!< [1..1] Transmit FIFO empty.                                               */
      __IOM uint32_t TXO        : 1;            /*!< [2..2] Transmit FIFO Overflow (only occurs when SW writes to
                                                     a full FIFO).                                                             */
      __IOM uint32_t RXU        : 1;            /*!< [3..3] Receive FIFO underflow (only occurs when SW reads from
                                                     an empty FIFO)                                                            */
      __IOM uint32_t RXO        : 1;            /*!< [4..4] Receive FIFO overflow (cannot happen in MSPI design --
                                                     MSPI bus pins will stall)                                                 */
      __IOM uint32_t RXF        : 1;            /*!< [5..5] Receive FIFO full                                                  */
      __IOM uint32_t DCMP       : 1;            /*!< [6..6] DMA Complete Interrupt                                             */
      __IOM uint32_t DERR       : 1;            /*!< [7..7] DMA Error Interrupt                                                */
      __IOM uint32_t CQCMP      : 1;            /*!< [8..8] Command Queue Complete Interrupt                                   */
      __IOM uint32_t CQUPD      : 1;            /*!< [9..9] Command Queue Update Interrupt. Issued whenever the CQ
                                                     performs an operation where address bit[0] is set. Useful
                                                     for triggering CURIDX interrupts.                                         */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [10..10] Command Queue is Paused.                                         */
      __IOM uint32_t CQERR      : 1;            /*!< [11..11] Command Queue Error Interrupt                                    */
      __IOM uint32_t SCRERR     : 1;            /*!< [12..12] Scrambling Alignment Error. Scrambling operations must
                                                     be aligned to word (4-byte) start address.                                */
            uint32_t            : 19;
    } INTSET_b;
  } ;
  __IM  uint32_t  RESERVED3[16];

  union {
    __IOM uint32_t DMACFG;                      /*!< (@ 0x00000250) DMA Configuration                                          */

    struct {
      __IOM uint32_t DMAEN      : 2;            /*!< [1..0] DMA Enable. Setting this bit to EN will start the DMA
                                                     operation                                                                 */
      __IOM uint32_t DMADIR     : 1;            /*!< [2..2] Direction                                                          */
      __IOM uint32_t DMAPRI     : 2;            /*!< [4..3] Sets the Priority of the DMA request                               */
            uint32_t            : 13;
      __IOM uint32_t DMAPWROFF  : 1;            /*!< [18..18] Power off MSPI domain upon completion of DMA operation.          */
            uint32_t            : 13;
    } DMACFG_b;
  } ;

  union {
    __IOM uint32_t DMASTAT;                     /*!< (@ 0x00000254) DMA Status                                                 */

    struct {
      __IOM uint32_t DMATIP     : 1;            /*!< [0..0] DMA Transfer In Progress indicator. 1 will indicate that
                                                     a DMA transfer is active. The DMA transfer may be waiting
                                                     on data, transferring data, or waiting for priority. All
                                                     of these will be indicated with a 1. A 0 will indicate
                                                     that the DMA is fully complete and no further transactions
                                                     will be done.                                                             */
      __IOM uint32_t DMACPL     : 1;            /*!< [1..1] DMA Transfer Complete. This signals the end of the DMA
                                                     operation.                                                                */
      __IOM uint32_t DMAERR     : 1;            /*!< [2..2] DMA Error. This active high bit signals that an error
                                                     was encountered during the DMA operation.                                 */
      __IOM uint32_t SCRERR     : 1;            /*!< [3..3] Scrambling Access Alignment Error. This active high bit
                                                     signals that a scrambling operation was specified for a
                                                     non-word aligned DEVADDR.                                                 */
            uint32_t            : 28;
    } DMASTAT_b;
  } ;

  union {
    __IOM uint32_t DMATARGADDR;                 /*!< (@ 0x00000258) DMA Target Address                                         */

    struct {
      __IOM uint32_t TARGADDR   : 32;           /*!< [31..0] Target byte address for source of DMA (either read or
                                                     write). In cases of non-word aligned addresses, the DMA
                                                     logic will take care for ensuring only the target bytes
                                                     are read/written.                                                         */
    } DMATARGADDR_b;
  } ;

  union {
    __IOM uint32_t DMADEVADDR;                  /*!< (@ 0x0000025C) DMA Device Address                                         */

    struct {
      __IOM uint32_t DEVADDR    : 32;           /*!< [31..0] SPI Device address for automated DMA transactions (both
                                                     read and write).                                                          */
    } DMADEVADDR_b;
  } ;

  union {
    __IOM uint32_t DMATOTCOUNT;                 /*!< (@ 0x00000260) DMA Total Transfer Count                                   */

    struct {
      __IOM uint32_t TOTCOUNT   : 16;           /*!< [15..0] Total Transfer Count in bytes.                                    */
            uint32_t            : 16;
    } DMATOTCOUNT_b;
  } ;

  union {
    __IOM uint32_t DMABCOUNT;                   /*!< (@ 0x00000264) DMA BYTE Transfer Count                                    */

    struct {
      __IOM uint32_t BCOUNT     : 8;            /*!< [7..0] Burst transfer size in bytes. This is the number of bytes
                                                     transferred when a FIFO trigger event occurs. Recommended
                                                     values are 16 or 32.                                                      */
            uint32_t            : 24;
    } DMABCOUNT_b;
  } ;
  __IM  uint32_t  RESERVED4[4];

  union {
    __IOM uint32_t DMATHRESH;                   /*!< (@ 0x00000278) Indicates FIFO level at which a DMA should be
                                                                    triggered. For most configurations, a setting
                                                                    of 8 is recommended for both read and write
                                                                    operations.                                                */

    struct {
      __IOM uint32_t DMATHRESH  : 4;            /*!< [3..0] DMA transfer FIFO level trigger. For read operations,
                                                     DMA is triggered when the FIFO level is greater than this
                                                     value. For write operations, DMA is triggered when the
                                                     FIFO level is less than this level. Each DMA operation
                                                     will consist of BCOUNT bytes.                                             */
            uint32_t            : 28;
    } DMATHRESH_b;
  } ;
  __IM  uint32_t  RESERVED5[9];

  union {
    __IOM uint32_t CQCFG;                       /*!< (@ 0x000002A0) This register controls Command Queuing (CQ) operations
                                                                    in a manner similar to the DMACFG register.                */

    struct {
      __IOM uint32_t CQEN       : 1;            /*!< [0..0] Command queue enable. When set, will enable the processing
                                                     of the command queue                                                      */
      __IOM uint32_t CQPRI      : 1;            /*!< [1..1] Sets the Priority of the command queue DMA request                 */
      __IOM uint32_t CQPWROFF   : 1;            /*!< [2..2] Power off MSPI domain upon completion of DMA operation.            */
      __IOM uint32_t CQAUTOCLEARMASK : 1;       /*!< [3..3] Enable clear of CQMASK after each pause operation. This
                                                     may be useful when using software flags to pause CQ.                      */
            uint32_t            : 28;
    } CQCFG_b;
  } ;
  __IM  uint32_t  RESERVED6;

  union {
    __IOM uint32_t CQADDR;                      /*!< (@ 0x000002A8) Location of the command queue in SRAM or flash
                                                                    memory. This register will increment as
                                                                    CQ operations commence. Software should
                                                                    only write CQADDR when CQEN is disabled,
                                                                    however the command queue script itself
                                                                    may update CQADDR in order to perform queue
                                                                    management functions (like resetting the
                                                                    pointers)                                                  */

    struct {
      __IOM uint32_t CQADDR     : 29;           /*!< [28..0] Address of command queue buffer in SRAM or flash. The
                                                     buffer address must be aligned to a word boundary.                        */
            uint32_t            : 3;
    } CQADDR_b;
  } ;

  union {
    __IOM uint32_t CQSTAT;                      /*!< (@ 0x000002AC) Command Queue Status                                       */

    struct {
      __IOM uint32_t CQTIP      : 1;            /*!< [0..0] Command queue Transfer In Progress indicator. 1 will
                                                     indicate that a CQ transfer is active and this will remain
                                                     active even when paused waiting for external event.                       */
      __IOM uint32_t CQCPL      : 1;            /*!< [1..1] Command queue operation Complete. This signals the end
                                                     of the command queue operation.                                           */
      __IOM uint32_t CQERR      : 1;            /*!< [2..2] Command queue processing Error. This active high bit
                                                     signals that an error was encountered during the CQ operation.            */
      __IOM uint32_t CQPAUSED   : 1;            /*!< [3..3] Command queue is currently paused status.                          */
            uint32_t            : 28;
    } CQSTAT_b;
  } ;

  union {
    __IOM uint32_t CQFLAGS;                     /*!< (@ 0x000002B0) Command Queue Flags                                        */

    struct {
      __IOM uint32_t CQFLAGS    : 16;           /*!< [15..0] Current flag status (read-only). Bits [7:0] are software
                                                     controllable and bits [15:8] are hardware status.                         */
            uint32_t            : 16;
    } CQFLAGS_b;
  } ;

  union {
    __IOM uint32_t CQSETCLEAR;                  /*!< (@ 0x000002B4) Command Queue Flag Set/Clear                               */

    struct {
      __IOM uint32_t CQFSET     : 8;            /*!< [7..0] Set CQFlag status bits. Set has priority over clear if
                                                     both are high.                                                            */
      __IOM uint32_t CQFTOGGLE  : 8;            /*!< [15..8] Toggle CQFlag status bits                                         */
      __IOM uint32_t CQFCLR     : 8;            /*!< [23..16] Clear CQFlag status bits.                                        */
            uint32_t            : 8;
    } CQSETCLEAR_b;
  } ;

  union {
    __IOM uint32_t CQPAUSE;                     /*!< (@ 0x000002B8) Command Queue Pause Mask                                   */

    struct {
      __IOM uint32_t CQMASK     : 16;           /*!< [15..0] CQ will pause processing when ALL specified events are
                                                     satisfied -- i.e. when (CQMASK and CQPAUSE)==CQMASK.                      */
            uint32_t            : 16;
    } CQPAUSE_b;
  } ;
  __IM  uint32_t  RESERVED7;

  union {
    __IOM uint32_t CQCURIDX;                    /*!< (@ 0x000002C0) This register can be used in conjunction with
                                                                    the CQENDIDX register to manage the command
                                                                    queue. Typically software will initialize
                                                                    the CQCURIDX and CQENDIDX to the same value,
                                                                    which will cause the CQ to be paused when
                                                                    enabled. Software may then add entries to
                                                                    the command queue (in SRAM) and update CQENDIDX.
                                                                    The command queue operations will then increment
                                                                    CQCURIDX as it processes operations. Once
                                                                    CQCURIDX==CQENDIDX, the command queue hardware
                                                                    will automatically pause since no additional
                                                                    ope                                                        */

    struct {
      __IOM uint32_t CQCURIDX   : 8;            /*!< [7..0] Can be used to indicate the current position of the command
                                                     queue by having CQ operations write this field. A CQ hardware
                                                     status flag indicates when CURIDX and ENDIDX are not equal,
                                                     allowing SW to pause the CQ processing until the end index
                                                     is updated.                                                               */
            uint32_t            : 24;
    } CQCURIDX_b;
  } ;

  union {
    __IOM uint32_t CQENDIDX;                    /*!< (@ 0x000002C4) Command Queue End Index                                    */

    struct {
      __IOM uint32_t CQENDIDX   : 8;            /*!< [7..0] Can be used to indicate the end position of the command
                                                     queue. A CQ hardware status bit indices when CURIDX !=
                                                     ENDIDX so that the CQ can be paused when it reaches the
                                                     end pointer.                                                              */
            uint32_t            : 24;
    } CQENDIDX_b;
  } ;
} MSPI_Type;                                    /*!< Size = 712 (0x2c8)                                                        */



/* =========================================================================================================================== */
/* ================                                            PDM                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief PDM Audio (PDM)
  */

typedef struct {                                /*!< (@ 0x50011000) PDM Structure                                              */

  union {
    __IOM uint32_t PCFG;                        /*!< (@ 0x00000000) PDM Configuration                                          */

    struct {
      __IOM uint32_t PDMCOREEN  : 1;            /*!< [0..0] Data Streaming Control.                                            */
      __IOM uint32_t SOFTMUTE   : 1;            /*!< [1..1] Soft mute control.                                                 */
      __IOM uint32_t CYCLES     : 3;            /*!< [4..2] Number of clocks during gain-setting changes.                      */
      __IOM uint32_t HPCUTOFF   : 4;            /*!< [8..5] High pass filter coefficients.                                     */
      __IOM uint32_t ADCHPD     : 1;            /*!< [9..9] High pass filter control.                                          */
      __IOM uint32_t SINCRATE   : 7;            /*!< [16..10] SINC decimation rate.                                            */
      __IOM uint32_t MCLKDIV    : 2;            /*!< [18..17] PDM_CLK frequency divisor.                                       */
            uint32_t            : 2;
      __IOM uint32_t PGALEFT    : 5;            /*!< [25..21] Left channel PGA gain.                                           */
      __IOM uint32_t PGARIGHT   : 5;            /*!< [30..26] Right channel PGA gain.                                          */
      __IOM uint32_t LRSWAP     : 1;            /*!< [31..31] Left/right channel swap.                                         */
    } PCFG_b;
  } ;

  union {
    __IOM uint32_t VCFG;                        /*!< (@ 0x00000004) Voice Configuration                                        */

    struct {
            uint32_t            : 3;
      __IOM uint32_t CHSET      : 2;            /*!< [4..3] Set PCM channels.                                                  */
            uint32_t            : 3;
      __IOM uint32_t PCMPACK    : 1;            /*!< [8..8] PCM data packing enable.                                           */
            uint32_t            : 7;
      __IOM uint32_t SELAP      : 1;            /*!< [16..16] Select PDM input clock source.                                   */
      __IOM uint32_t DMICKDEL   : 1;            /*!< [17..17] PDM clock sampling delay.                                        */
            uint32_t            : 1;
      __IOM uint32_t BCLKINV    : 1;            /*!< [19..19] I2S BCLK input inversion.                                        */
      __IOM uint32_t I2SEN      : 1;            /*!< [20..20] I2S interface enable.                                            */
            uint32_t            : 5;
      __IOM uint32_t PDMCLKEN   : 1;            /*!< [26..26] Enable the serial clock.                                         */
      __IOM uint32_t PDMCLKSEL  : 3;            /*!< [29..27] Select the PDM input clock.                                      */
      __IOM uint32_t RSTB       : 1;            /*!< [30..30] Reset the IP core.                                               */
      __IOM uint32_t IOCLKEN    : 1;            /*!< [31..31] Enable the IO clock.                                             */
    } VCFG_b;
  } ;

  union {
    __IOM uint32_t VOICESTAT;                   /*!< (@ 0x00000008) Voice Status                                               */

    struct {
      __IOM uint32_t FIFOCNT    : 6;            /*!< [5..0] Valid 32-bit entries currently in the FIFO.                        */
            uint32_t            : 26;
    } VOICESTAT_b;
  } ;

  union {
    __IOM uint32_t FIFOREAD;                    /*!< (@ 0x0000000C) FIFO Read                                                  */

    struct {
      __IOM uint32_t FIFOREAD   : 32;           /*!< [31..0] FIFO read data.                                                   */
    } FIFOREAD_b;
  } ;

  union {
    __IOM uint32_t FIFOFLUSH;                   /*!< (@ 0x00000010) FIFO Flush                                                 */

    struct {
      __IOM uint32_t FIFOFLUSH  : 1;            /*!< [0..0] FIFO FLUSH.                                                        */
            uint32_t            : 31;
    } FIFOFLUSH_b;
  } ;

  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000014) FIFO Threshold                                             */

    struct {
      __IOM uint32_t FIFOTHR    : 5;            /*!< [4..0] FIFO Threshold value. When the FIFO count is equal to,
                                                     or larger than this value (in words), a THR interrupt is
                                                     generated (if enabled)                                                    */
            uint32_t            : 27;
    } FIFOTHR_b;
  } ;
  __IM  uint32_t  RESERVED[122];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t THR        : 1;            /*!< [0..0] This is the FIFO threshold interrupt.                              */
      __IOM uint32_t OVF        : 1;            /*!< [1..1] This is the FIFO overflow interrupt.                               */
      __IOM uint32_t UNDFL      : 1;            /*!< [2..2] This is the FIFO underflow interrupt.                              */
      __IOM uint32_t DCMP       : 1;            /*!< [3..3] DMA completed a transfer                                           */
      __IOM uint32_t DERR       : 1;            /*!< [4..4] DMA Error received                                                 */
            uint32_t            : 27;
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t THR        : 1;            /*!< [0..0] This is the FIFO threshold interrupt.                              */
      __IOM uint32_t OVF        : 1;            /*!< [1..1] This is the FIFO overflow interrupt.                               */
      __IOM uint32_t UNDFL      : 1;            /*!< [2..2] This is the FIFO underflow interrupt.                              */
      __IOM uint32_t DCMP       : 1;            /*!< [3..3] DMA completed a transfer                                           */
      __IOM uint32_t DERR       : 1;            /*!< [4..4] DMA Error received                                                 */
            uint32_t            : 27;
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t THR        : 1;            /*!< [0..0] This is the FIFO threshold interrupt.                              */
      __IOM uint32_t OVF        : 1;            /*!< [1..1] This is the FIFO overflow interrupt.                               */
      __IOM uint32_t UNDFL      : 1;            /*!< [2..2] This is the FIFO underflow interrupt.                              */
      __IOM uint32_t DCMP       : 1;            /*!< [3..3] DMA completed a transfer                                           */
      __IOM uint32_t DERR       : 1;            /*!< [4..4] DMA Error received                                                 */
            uint32_t            : 27;
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t THR        : 1;            /*!< [0..0] This is the FIFO threshold interrupt.                              */
      __IOM uint32_t OVF        : 1;            /*!< [1..1] This is the FIFO overflow interrupt.                               */
      __IOM uint32_t UNDFL      : 1;            /*!< [2..2] This is the FIFO underflow interrupt.                              */
      __IOM uint32_t DCMP       : 1;            /*!< [3..3] DMA completed a transfer                                           */
      __IOM uint32_t DERR       : 1;            /*!< [4..4] DMA Error received                                                 */
            uint32_t            : 27;
    } INTSET_b;
  } ;
  __IM  uint32_t  RESERVED1[12];

  union {
    __IOM uint32_t DMATRIGEN;                   /*!< (@ 0x00000240) DMA Trigger Enable                                         */

    struct {
      __IOM uint32_t DTHR       : 1;            /*!< [0..0] Trigger DMA upon when FIFO is filled to level indicated
                                                     by the FIFO THRESHOLD,at granularity of 16 bytes only                     */
      __IOM uint32_t DTHR90     : 1;            /*!< [1..1] Trigger DMA at FIFO 90 percent full. This signal is also
                                                     used internally for AUTOHIP function                                      */
            uint32_t            : 30;
    } DMATRIGEN_b;
  } ;

  union {
    __IOM uint32_t DMATRIGSTAT;                 /*!< (@ 0x00000244) DMA Trigger Status                                         */

    struct {
      __IOM uint32_t DTHRSTAT   : 1;            /*!< [0..0] Triggered DMA from FIFO reaching threshold                         */
      __IOM uint32_t DTHR90STAT : 1;            /*!< [1..1] Triggered DMA from FIFO reaching 90 percent full                   */
            uint32_t            : 30;
    } DMATRIGSTAT_b;
  } ;
  __IM  uint32_t  RESERVED2[14];

  union {
    __IOM uint32_t DMACFG;                      /*!< (@ 0x00000280) DMA Configuration                                          */

    struct {
      __IOM uint32_t DMAEN      : 1;            /*!< [0..0] DMA Enable                                                         */
            uint32_t            : 1;
      __IOM uint32_t DMADIR     : 1;            /*!< [2..2] Direction                                                          */
            uint32_t            : 5;
      __IOM uint32_t DMAPRI     : 1;            /*!< [8..8] Sets the Priority of the DMA request                               */
      __IOM uint32_t DAUTOHIP   : 1;            /*!< [9..9] Raise priority to high on FIFO full, and DMAPRI set to
                                                     low                                                                       */
      __IOM uint32_t DPWROFF    : 1;            /*!< [10..10] Power Off the ADC System upon DMACPL.                            */
            uint32_t            : 21;
    } DMACFG_b;
  } ;
  __IM  uint32_t  RESERVED3;

  union {
    __IOM uint32_t DMATOTCOUNT;                 /*!< (@ 0x00000288) DMA Total Transfer Count                                   */

    struct {
      __IOM uint32_t TOTCOUNT   : 20;           /*!< [19..0] Total Transfer Count. The transfer count must be a multiple
                                                     of the THR setting to avoid DMA overruns.                                 */
            uint32_t            : 12;
    } DMATOTCOUNT_b;
  } ;

  union {
    __IOM uint32_t DMATARGADDR;                 /*!< (@ 0x0000028C) DMA Target Address                                         */

    struct {
      __IOM uint32_t LTARGADDR  : 20;           /*!< [19..0] DMA Target Address. This register is not updated with
                                                     the current address of the DMA, but will remain static
                                                     with the original address during the DMA transfer.                        */
      __IOM uint32_t UTARGADDR  : 12;           /*!< [31..20] SRAM Target                                                      */
    } DMATARGADDR_b;
  } ;

  union {
    __IOM uint32_t DMASTAT;                     /*!< (@ 0x00000290) DMA Status                                                 */

    struct {
      __IOM uint32_t DMATIP     : 1;            /*!< [0..0] DMA Transfer In Progress                                           */
      __IOM uint32_t DMACPL     : 1;            /*!< [1..1] DMA Transfer Complete                                              */
      __IOM uint32_t DMAERR     : 1;            /*!< [2..2] DMA Error                                                          */
            uint32_t            : 29;
    } DMASTAT_b;
  } ;
} PDM_Type;                                     /*!< Size = 660 (0x294)                                                        */



/* =========================================================================================================================== */
/* ================                                          PWRCTRL                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief PWR Controller Register Bank (PWRCTRL)
  */

typedef struct {                                /*!< (@ 0x40021000) PWRCTRL Structure                                          */

  union {
    __IOM uint32_t SUPPLYSRC;                   /*!< (@ 0x00000000) This register controls the enable for BLE BUCK.            */

    struct {
      __IOM uint32_t BLEBUCKEN  : 1;            /*!< [0..0] Enables and Selects the BLE Buck as the supply for the
                                                     BLE power domain or for Burst LDO. It takes the initial
                                                     value from Customer INFO space. Buck will be powered up
                                                     only if there is an active request for BLEH domain or Burst
                                                     mode and appropriate feature is allowed.                                  */
            uint32_t            : 31;
    } SUPPLYSRC_b;
  } ;

  union {
    __IOM uint32_t SUPPLYSTATUS;                /*!< (@ 0x00000004) Provides an indicator for the BLE BUCK and SIMO
                                                                    BUCK status. Once the SIMO BUCK is powered
                                                                    up MEM and CORE LDOs are disabled.                         */

    struct {
      __IOM uint32_t SIMOBUCKON : 1;            /*!< [0..0] Indicates whether the Core/Mem low-voltage domains are
                                                     supplied from the LDO or the Buck.                                        */
      __IOM uint32_t BLEBUCKON  : 1;            /*!< [1..1] Indicates whether the BLE (if supported) domain and burst
                                                     (if supported) domain is supplied from the LDO or the Buck.
                                                     Buck will be powered up only if there is an active request
                                                     for BLEH domain or Burst mode and appropriate feature is
                                                     allowed.                                                                  */
            uint32_t            : 30;
    } SUPPLYSTATUS_b;
  } ;

  union {
    __IOM uint32_t DEVPWREN;                    /*!< (@ 0x00000008) This enables various peripherals power domains.            */

    struct {
      __IOM uint32_t PWRIOS     : 1;            /*!< [0..0] Power up IO Slave                                                  */
      __IOM uint32_t PWRIOM0    : 1;            /*!< [1..1] Power up IO Master 0                                               */
      __IOM uint32_t PWRIOM1    : 1;            /*!< [2..2] Power up IO Master 1                                               */
      __IOM uint32_t PWRIOM2    : 1;            /*!< [3..3] Power up IO Master 2                                               */
      __IOM uint32_t PWRIOM3    : 1;            /*!< [4..4] Power up IO Master 3                                               */
      __IOM uint32_t PWRIOM4    : 1;            /*!< [5..5] Power up IO Master 4                                               */
      __IOM uint32_t PWRIOM5    : 1;            /*!< [6..6] Power up IO Master 5                                               */
      __IOM uint32_t PWRUART0   : 1;            /*!< [7..7] Power up UART Controller 0                                         */
      __IOM uint32_t PWRUART1   : 1;            /*!< [8..8] Power up UART Controller 1                                         */
      __IOM uint32_t PWRADC     : 1;            /*!< [9..9] Power up ADC Digital Controller                                    */
      __IOM uint32_t PWRSCARD   : 1;            /*!< [10..10] Power up SCARD Controller                                        */
      __IOM uint32_t PWRMSPI    : 1;            /*!< [11..11] Power up MSPI Controller                                         */
      __IOM uint32_t PWRPDM     : 1;            /*!< [12..12] Power up PDM block                                               */
      __IOM uint32_t PWRBLEL    : 1;            /*!< [13..13] Power up BLE controller                                          */
            uint32_t            : 18;
    } DEVPWREN_b;
  } ;

  union {
    __IOM uint32_t MEMPWDINSLEEP;               /*!< (@ 0x0000000C) This controls the power down of the SRAM banks
                                                                    in deep sleep mode. If this is set, then
                                                                    the power for that SRAM bank will be gated
                                                                    when the core goes into deep sleep. Upon
                                                                    wake, the data within the SRAMs will be
                                                                    erased. If this is not set, retention voltage
                                                                    will be applied to the SRAM bank when the
                                                                    core goes into deep sleep. Upon wake, the
                                                                    data within the SRAMs are retained. Do not
                                                                    set this if the SRAM bank is used as the
                                                                    target for DMA transfer while CPU in deep
                                                                    sleep.                                                     */

    struct {
      __IOM uint32_t DTCMPWDSLP : 3;            /*!< [2..0] power down DTCM in deep sleep                                      */
      __IOM uint32_t SRAMPWDSLP : 10;           /*!< [12..3] Selects which SRAM banks are powered down in deep sleep
                                                     mode, causing the contents of the bank to be lost.                        */
      __IOM uint32_t FLASH0PWDSLP : 1;          /*!< [13..13] Power-down FLASH0 in deep sleep                                  */
      __IOM uint32_t FLASH1PWDSLP : 1;          /*!< [14..14] Power-down FLASH1 in deep sleep                                  */
            uint32_t            : 16;
      __IOM uint32_t CACHEPWDSLP : 1;           /*!< [31..31] power down cache in deep sleep                                   */
    } MEMPWDINSLEEP_b;
  } ;

  union {
    __IOM uint32_t MEMPWREN;                    /*!< (@ 0x00000010) This register enables the individual banks for
                                                                    the memories. When set, power will be enabled
                                                                    to the banks. This register works in conjunction
                                                                    with the MEMPWDINSLEEP register. When this
                                                                    register is set, then the MEMPWRINSLEEP
                                                                    register will determine whether power is
                                                                    enabled to the SRAMs in deep sleep. If this
                                                                    register is not set, then power will always
                                                                    be disabled to the memory bank.                            */

    struct {
      __IOM uint32_t DTCM       : 3;            /*!< [2..0] Power up DTCM                                                      */
      __IOM uint32_t SRAM       : 10;           /*!< [12..3] Power up SRAM groups                                              */
      __IOM uint32_t FLASH0     : 1;            /*!< [13..13] Power up FLASH0                                                  */
      __IOM uint32_t FLASH1     : 1;            /*!< [14..14] Power up FLASH1                                                  */
            uint32_t            : 15;
      __IOM uint32_t CACHEB0    : 1;            /*!< [30..30] Power up Cache Bank 0. This works in conjunction with
                                                     Cache enable from flash_cache module. To power up cache
                                                     bank 0, cache has to be enabled and this bit has to be
                                                     set.                                                                      */
      __IOM uint32_t CACHEB2    : 1;            /*!< [31..31] Power up Cache Bank 2. This works in conjunction with
                                                     Cache enable from flash_cache module. To power up cache
                                                     bank 2, cache has to be enabled and this bit has to be
                                                     set.                                                                      */
    } MEMPWREN_b;
  } ;

  union {
    __IOM uint32_t MEMPWRSTATUS;                /*!< (@ 0x00000014) It provides the power status for all the memory
                                                                    banks including- caches, FLASH (0 and 1)
                                                                    and all the SRAM groups. The status here
                                                                    should reflect the enable provided by the
                                                                    MEMPWREN register. There may be a lag time
                                                                    between setting the bits in MEMPWREN register
                                                                    and MEMPWRSTATUS register, due to the need
                                                                    to cycle the power gate and isolation sequences
                                                                    to the memory banks.                                       */

    struct {
      __IOM uint32_t DTCM00     : 1;            /*!< [0..0] This bit is 1 if power is supplied to DTCM GROUP0_0                */
      __IOM uint32_t DTCM01     : 1;            /*!< [1..1] This bit is 1 if power is supplied to DTCM GROUP0_1                */
      __IOM uint32_t DTCM1      : 1;            /*!< [2..2] This bit is 1 if power is supplied to DTCM GROUP1                  */
      __IOM uint32_t SRAM0      : 1;            /*!< [3..3] This bit is 1 if power is supplied to SRAM GROUP0                  */
      __IOM uint32_t SRAM1      : 1;            /*!< [4..4] This bit is 1 if power is supplied to SRAM GROUP1                  */
      __IOM uint32_t SRAM2      : 1;            /*!< [5..5] This bit is 1 if power is supplied to SRAM GROUP2                  */
      __IOM uint32_t SRAM3      : 1;            /*!< [6..6] This bit is 1 if power is supplied to SRAM GROUP3                  */
      __IOM uint32_t SRAM4      : 1;            /*!< [7..7] This bit is 1 if power is supplied to SRAM GROUP4                  */
      __IOM uint32_t SRAM5      : 1;            /*!< [8..8] This bit is 1 if power is supplied to SRAM GROUP5                  */
      __IOM uint32_t SRAM6      : 1;            /*!< [9..9] This bit is 1 if power is supplied to SRAM GROUP6                  */
      __IOM uint32_t SRAM7      : 1;            /*!< [10..10] This bit is 1 if power is supplied to SRAM GROUP7                */
      __IOM uint32_t SRAM8      : 1;            /*!< [11..11] This bit is 1 if power is supplied to SRAM GROUP8                */
      __IOM uint32_t SRAM9      : 1;            /*!< [12..12] This bit is 1 if power is supplied to SRAM GROUP9                */
      __IOM uint32_t FLASH0     : 1;            /*!< [13..13] This bit is 1 if power is supplied to FLASH 0                    */
      __IOM uint32_t FLASH1     : 1;            /*!< [14..14] This bit is 1 if power is supplied to FLASH 1                    */
      __IOM uint32_t CACHEB0    : 1;            /*!< [15..15] This bit is 1 if power is supplied to Cache Bank 0               */
      __IOM uint32_t CACHEB2    : 1;            /*!< [16..16] This bit is 1 if power is supplied to Cache Bank 2               */
            uint32_t            : 15;
    } MEMPWRSTATUS_b;
  } ;

  union {
    __IOM uint32_t DEVPWRSTATUS;                /*!< (@ 0x00000018) This provides the power status for the peripheral
                                                                    devices- BLEL, PDM, PDM, MSPI, SCARD, ADC,
                                                                    UART0 and 1, IOM5 to 0, IOSLAVE and MCUL
                                                                    (DMA and Fabrics) and MCUH (ARM core). The
                                                                    status here should reflect the enable provided
                                                                    by the DEVPWREN register. There may be a
                                                                    lag time between setting the bits in DEVPWREN
                                                                    register and DEVPWRSTATUS register, due
                                                                    to the need to cycle the power gate, isolation
                                                                    and reset sequences to the device power
                                                                    domains.                                                   */

    struct {
      __IOM uint32_t MCUL       : 1;            /*!< [0..0] This bit is 1 if power is supplied to MCUL                         */
      __IOM uint32_t MCUH       : 1;            /*!< [1..1] This bit is 1 if power is supplied to MCUH                         */
      __IOM uint32_t HCPA       : 1;            /*!< [2..2] This bit is 1 if power is supplied to HCPA domain (IO
                                                     SLAVE, UART0, UART1, SCARD)                                               */
      __IOM uint32_t HCPB       : 1;            /*!< [3..3] This bit is 1 if power is supplied to HCPB domain (IO
                                                     MASTER 0, 1, 2)                                                           */
      __IOM uint32_t HCPC       : 1;            /*!< [4..4] This bit is 1 if power is supplied to HCPC domain (IO
                                                     MASTER4, 5, 6)                                                            */
      __IOM uint32_t PWRADC     : 1;            /*!< [5..5] This bit is 1 if power is supplied to ADC                          */
      __IOM uint32_t PWRMSPI    : 1;            /*!< [6..6] This bit is 1 if power is supplied to MSPI                         */
      __IOM uint32_t PWRPDM     : 1;            /*!< [7..7] This bit is 1 if power is supplied to PDM                          */
      __IOM uint32_t BLEL       : 1;            /*!< [8..8] This bit is 1 if power is supplied to BLEL                         */
      __IOM uint32_t BLEH       : 1;            /*!< [9..9] This bit is 1 if power is supplied to BLEH                         */
            uint32_t            : 22;
    } DEVPWRSTATUS_b;
  } ;

  union {
    __IOM uint32_t SRAMCTRL;                    /*!< (@ 0x0000001C) This register provides additional fine-tune power
                                                                    management controls for the SRAMs and the
                                                                    SRAM controller. This includes enabling
                                                                    light sleep for the SRAM and TCM banks,
                                                                    and clock gating for reduced dynamic power.                */

    struct {
            uint32_t            : 1;
      __IOM uint32_t SRAMCLKGATE : 1;           /*!< [1..1] This bit is 1 if clock gating is allowed for individual
                                                     system SRAMs                                                              */
      __IOM uint32_t SRAMMASTERCLKGATE : 1;     /*!< [2..2] This bit is 1 when the master clock gate is enabled (top-level
                                                     clock gate for entire SRAM block)                                         */
            uint32_t            : 5;
      __IOM uint32_t SRAMLIGHTSLEEP : 12;       /*!< [19..8] Light Sleep enable for each TCM/SRAM bank. When 1, corresponding
                                                     bank will be put into light sleep. For optimal power, banks
                                                     should be put into light sleep while the system is active
                                                     but the bank has minimal or no accesses.                                  */
            uint32_t            : 12;
    } SRAMCTRL_b;
  } ;

  union {
    __IOM uint32_t ADCSTATUS;                   /*!< (@ 0x00000020) This provides the power status for various blocks
                                                                    within the ADC. These status comes directly
                                                                    from the ADC module and is captured through
                                                                    this interface.                                            */

    struct {
      __IOM uint32_t ADCPWD     : 1;            /*!< [0..0] This bit indicates that the ADC is powered down                    */
      __IOM uint32_t BGTPWD     : 1;            /*!< [1..1] This bit indicates that the ADC Band Gap is powered down           */
      __IOM uint32_t VPTATPWD   : 1;            /*!< [2..2] This bit indicates that the ADC temperature sensor input
                                                     buffer is powered down                                                    */
      __IOM uint32_t VBATPWD    : 1;            /*!< [3..3] This bit indicates that the ADC VBAT resistor divider
                                                     is powered down                                                           */
      __IOM uint32_t REFKEEPPWD : 1;            /*!< [4..4] This bit indicates that the ADC REFKEEP is powered down            */
      __IOM uint32_t REFBUFPWD  : 1;            /*!< [5..5] This bit indicates that the ADC REFBUF is powered down             */
            uint32_t            : 26;
    } ADCSTATUS_b;
  } ;

  union {
    __IOM uint32_t MISC;                        /*!< (@ 0x00000024) This register includes additional debug control
                                                                    bits. This is an internal Ambiq-only register.
                                                                    Customers should not attempt to change this
                                                                    or else functionality cannot be guaranteed.                */

    struct {
            uint32_t            : 3;
      __IOM uint32_t FORCEMEMVRLPTIMERS : 1;    /*!< [3..3] Control Bit to force Mem VR to LP mode in deep sleep
                                                     even when hfrc based ctimer or stimer is running.                         */
            uint32_t            : 2;
      __IOM uint32_t MEMVRLPBLE : 1;            /*!< [6..6] Control Bit to let Mem VR go to lp mode in deep sleep
                                                     even when BLEL or BLEH is powered on given none of the
                                                     other domains require it.                                                 */
            uint32_t            : 25;
    } MISC_b;
  } ;

  union {
    __IOM uint32_t DEVPWREVENTEN;               /*!< (@ 0x00000028) This register controls which feature trigger
                                                                    will result in an event to the CPU. It includes
                                                                    all the power on status for the core domains,
                                                                    as well as the Burst event. If any bits
                                                                    are set, then if the domain is turned on,
                                                                    it will result in an event to the ARM core.                */

    struct {
      __IOM uint32_t MCULEVEN   : 1;            /*!< [0..0] Control MCUL power-on status event                                 */
      __IOM uint32_t MCUHEVEN   : 1;            /*!< [1..1] Control MCUH power-on status event                                 */
      __IOM uint32_t HCPAEVEN   : 1;            /*!< [2..2] Control HCPA power-on status event                                 */
      __IOM uint32_t HCPBEVEN   : 1;            /*!< [3..3] Control HCPB power-on status event                                 */
      __IOM uint32_t HCPCEVEN   : 1;            /*!< [4..4] Control HCPC power-on status event                                 */
      __IOM uint32_t ADCEVEN    : 1;            /*!< [5..5] Control ADC power-on status event                                  */
      __IOM uint32_t MSPIEVEN   : 1;            /*!< [6..6] Control MSPI power-on status event                                 */
      __IOM uint32_t PDMEVEN    : 1;            /*!< [7..7] Control PDM power-on status event                                  */
      __IOM uint32_t BLELEVEN   : 1;            /*!< [8..8] Control BLE power-on status event                                  */
            uint32_t            : 20;
      __IOM uint32_t BLEFEATUREEVEN : 1;        /*!< [29..29] Control BLEFEATURE status event                                  */
      __IOM uint32_t BURSTFEATUREEVEN : 1;      /*!< [30..30] Control BURSTFEATURE status event                                */
      __IOM uint32_t BURSTEVEN  : 1;            /*!< [31..31] Control BURST status event                                       */
    } DEVPWREVENTEN_b;
  } ;

  union {
    __IOM uint32_t MEMPWREVENTEN;               /*!< (@ 0x0000002C) This register controls which power enable for
                                                                    the memories will result in an event to
                                                                    the CPU. It includes all the power on status
                                                                    for the memory domains. If any bits are
                                                                    set, then if the domain is turned on, it
                                                                    will result in an event to the ARM core.                   */

    struct {
      __IOM uint32_t DTCMEN     : 3;            /*!< [2..0] Enable DTCM power-on status event                                  */
      __IOM uint32_t SRAMEN     : 10;           /*!< [12..3] Control SRAM power-on status event                                */
      __IOM uint32_t FLASH0EN   : 1;            /*!< [13..13] Control FLASH power-on status event                              */
      __IOM uint32_t FLASH1EN   : 1;            /*!< [14..14] Control FLASH power-on status event                              */
            uint32_t            : 15;
      __IOM uint32_t CACHEB0EN  : 1;            /*!< [30..30] Control CACHE BANK 0 power-on status event                       */
      __IOM uint32_t CACHEB2EN  : 1;            /*!< [31..31] Control CACHEB2 power-on status event                            */
    } MEMPWREVENTEN_b;
  } ;
} PWRCTRL_Type;                                 /*!< Size = 48 (0x30)                                                          */



/* =========================================================================================================================== */
/* ================                                          RSTGEN                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief MCU Reset Generator (RSTGEN)
  */

typedef struct {                                /*!< (@ 0x40000000) RSTGEN Structure                                           */

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Reset configuration register. This controls the
                                                                    reset enables for brownout condition, and
                                                                    for the expiration of the watch dog timer.                 */

    struct {
      __IOM uint32_t BODHREN    : 1;            /*!< [0..0] Brown out high (2.1 V) reset enable.                               */
      __IOM uint32_t WDREN      : 1;            /*!< [1..1] Watchdog Timer Reset Enable. NOTE: The WDT module must
                                                     also be configured for WDT reset. This includes enabling
                                                     the RESEN bit in WDTCFG register in Watch dog timer block.                */
            uint32_t            : 30;
    } CFG_b;
  } ;

  union {
    __IOM uint32_t SWPOI;                       /*!< (@ 0x00000004) This is the software POI reset. writing the key
                                                                    value to this register will trigger a POI
                                                                    to the system. This will cause a reset to
                                                                    all blocks except for registers in clock
                                                                    gen, RTC and the STIMER.                                   */

    struct {
      __IOM uint32_t SWPOIKEY   : 8;            /*!< [7..0] 0x1B generates a software POI reset. This is a write-only
                                                     register. Reading from this register will yield only all
                                                     0's.                                                                      */
            uint32_t            : 24;
    } SWPOI_b;
  } ;

  union {
    __IOM uint32_t SWPOR;                       /*!< (@ 0x00000008) This is the software POR reset. Writing the key
                                                                    value to this register will trigger a POR
                                                                    to the system. This will cause a reset to
                                                                    all blocks except for registers in clock
                                                                    gen, RTC, power management unit, the STIMER,
                                                                    and the power management unit.                             */

    struct {
      __IOM uint32_t SWPORKEY   : 8;            /*!< [7..0] 0xD4 generates a software POR reset.                               */
            uint32_t            : 24;
    } SWPOR_b;
  } ;
  __IM  uint32_t  RESERVED[2];

  union {
    __IOM uint32_t TPIURST;                     /*!< (@ 0x00000014) This will trigger a reset for the TPIU unit.               */

    struct {
      __IOM uint32_t TPIURST    : 1;            /*!< [0..0] Static reset for the TPIU. Write to '1' to assert reset
                                                     to TPIU. Write to '0' to clear the reset.                                 */
            uint32_t            : 31;
    } TPIURST_b;
  } ;
  __IM  uint32_t  RESERVED1[122];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t BODH       : 1;            /*!< [0..0] Enables an interrupt that triggers when VCC is below
                                                     BODH level.                                                               */
            uint32_t            : 31;
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t BODH       : 1;            /*!< [0..0] Enables an interrupt that triggers when VCC is below
                                                     BODH level.                                                               */
            uint32_t            : 31;
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t BODH       : 1;            /*!< [0..0] Enables an interrupt that triggers when VCC is below
                                                     BODH level.                                                               */
            uint32_t            : 31;
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t BODH       : 1;            /*!< [0..0] Enables an interrupt that triggers when VCC is below
                                                     BODH level.                                                               */
            uint32_t            : 31;
    } INTSET_b;
  } ;
  __IM  uint32_t  RESERVED2[67107708];

  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x0FFFF000) This register contains the status for brownout
                                                                    events and the causes for resets.
                                                                    NOTE 1: All bits in this register, including
                                                                    reserved bits, are writable. Therefore care
                                                                    should be taken not to write this register.
                                                                    NOTE 2: This register does not retain its
                                                                    value across a core deep sleep cycle. Therefore
                                                                    applications needing to use this value after
                                                                    deep sleep must copy and save this register
                                                                    to SRAM before initiating the first deep
                                                                    sleep cycle.                                               */

    struct {
      __IOM uint32_t EXRSTAT    : 1;            /*!< [0..0] Reset was initiated by an External Reset (SBL).                    */
      __IOM uint32_t PORSTAT    : 1;            /*!< [1..1] Reset was initiated by a Power-On Reset (SBL).                     */
      __IOM uint32_t BORSTAT    : 1;            /*!< [2..2] Reset was initiated by a Brown-Out Reset (SBL).                    */
      __IOM uint32_t SWRSTAT    : 1;            /*!< [3..3] Reset was a initiated by SW POR or AIRCR Reset (SBL).              */
      __IOM uint32_t POIRSTAT   : 1;            /*!< [4..4] Reset was a initiated by Software POI Reset (SBL).                 */
      __IOM uint32_t DBGRSTAT   : 1;            /*!< [5..5] Reset was a initiated by Debugger Reset (SBL).                     */
      __IOM uint32_t WDRSTAT    : 1;            /*!< [6..6] Reset was initiated by a Watchdog Timer Reset (SBL).               */
      __IOM uint32_t BOUSTAT    : 1;            /*!< [7..7] An Unregulated Supply Brownout Event occurred (SBL).               */
      __IOM uint32_t BOCSTAT    : 1;            /*!< [8..8] A Core Regulator Brownout Event occurred (SBL).                    */
      __IOM uint32_t BOFSTAT    : 1;            /*!< [9..9] A Memory Regulator Brownout Event occurred (SBL).                  */
      __IOM uint32_t BOBSTAT    : 1;            /*!< [10..10] A BLE/Burst Regulator Brownout Event occurred (SBL).             */
            uint32_t            : 19;
      __IOM uint32_t FBOOT      : 1;            /*!< [30..30] Set if current boot was initiated by soft reset and
                                                     resulted in Fast Boot (SBL).                                              */
      __IOM uint32_t SBOOT      : 1;            /*!< [31..31] Set when booting securely (SBL).                                 */
    } STAT_b;
  } ;
} RSTGEN_Type;                                  /*!< Size = 268431364 (0xffff004)                                              */



/* =========================================================================================================================== */
/* ================                                            RTC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Real Time Clock (RTC)
  */

typedef struct {                                /*!< (@ 0x40004200) RTC Structure                                              */
  __IM  uint32_t  RESERVED[16];

  union {
    __IOM uint32_t CTRLOW;                      /*!< (@ 0x00000040) This counter contains the values for hour, minutes,
                                                                    seconds and 100ths of a second Counter.                    */

    struct {
      __IOM uint32_t CTR100     : 8;            /*!< [7..0] 100ths of a second Counter                                         */
      __IOM uint32_t CTRSEC     : 7;            /*!< [14..8] Seconds Counter                                                   */
            uint32_t            : 1;
      __IOM uint32_t CTRMIN     : 7;            /*!< [22..16] Minutes Counter                                                  */
            uint32_t            : 1;
      __IOM uint32_t CTRHR      : 6;            /*!< [29..24] Hours Counter                                                    */
            uint32_t            : 2;
    } CTRLOW_b;
  } ;

  union {
    __IOM uint32_t CTRUP;                       /*!< (@ 0x00000044) This register contains the day, month and year
                                                                    information. It contains which day in the
                                                                    week, and the century as well. The information
                                                                    of the century can also be derived from
                                                                    the year information. The 31st bit contains
                                                                    the error bit. See description in the register
                                                                    bit for condition when error is triggered.                 */

    struct {
      __IOM uint32_t CTRDATE    : 6;            /*!< [5..0] Date Counter                                                       */
            uint32_t            : 2;
      __IOM uint32_t CTRMO      : 5;            /*!< [12..8] Months Counter                                                    */
            uint32_t            : 3;
      __IOM uint32_t CTRYR      : 8;            /*!< [23..16] Years Counter                                                    */
      __IOM uint32_t CTRWKDY    : 3;            /*!< [26..24] Weekdays Counter                                                 */
      __IOM uint32_t CB         : 1;            /*!< [27..27] Century                                                          */
      __IOM uint32_t CEB        : 1;            /*!< [28..28] Century enable                                                   */
            uint32_t            : 2;
      __IOM uint32_t CTERR      : 1;            /*!< [31..31] Counter read error status. Error is triggered when
                                                     software reads the lower word of the counters, and fails
                                                     to read the upper counter within 1/100 second. This is
                                                     because when the lower counter is read, the upper counter
                                                     is held off from incrementing until it is read so that
                                                     the full time stamp can be read.                                          */
    } CTRUP_b;
  } ;

  union {
    __IOM uint32_t ALMLOW;                      /*!< (@ 0x00000048) This register is the Alarm settings for hours,
                                                                    minutes, second and 1/100th seconds settings.              */

    struct {
      __IOM uint32_t ALM100     : 8;            /*!< [7..0] 100ths of a second Alarm                                           */
      __IOM uint32_t ALMSEC     : 7;            /*!< [14..8] Seconds Alarm                                                     */
            uint32_t            : 1;
      __IOM uint32_t ALMMIN     : 7;            /*!< [22..16] Minutes Alarm                                                    */
            uint32_t            : 1;
      __IOM uint32_t ALMHR      : 6;            /*!< [29..24] Hours Alarm                                                      */
            uint32_t            : 2;
    } ALMLOW_b;
  } ;

  union {
    __IOM uint32_t ALMUP;                       /*!< (@ 0x0000004C) This register is the alarm settings for week,
                                                                    month and day.                                             */

    struct {
      __IOM uint32_t ALMDATE    : 6;            /*!< [5..0] Date Alarm                                                         */
            uint32_t            : 2;
      __IOM uint32_t ALMMO      : 5;            /*!< [12..8] Months Alarm                                                      */
            uint32_t            : 3;
      __IOM uint32_t ALMWKDY    : 3;            /*!< [18..16] Weekdays Alarm                                                   */
            uint32_t            : 13;
    } ALMUP_b;
  } ;

  union {
    __IOM uint32_t RTCCTL;                      /*!< (@ 0x00000050) This is the register control for the RTC module.
                                                                    It sets the 12 or 24 hours mode, enables
                                                                    counter writes and sets the alarm repeat
                                                                    interval.                                                  */

    struct {
      __IOM uint32_t WRTC       : 1;            /*!< [0..0] Counter write control                                              */
      __IOM uint32_t RPT        : 3;            /*!< [3..1] Alarm repeat interval                                              */
      __IOM uint32_t RSTOP      : 1;            /*!< [4..4] RTC input clock control                                            */
      __IOM uint32_t HR1224     : 1;            /*!< [5..5] Hours Counter mode                                                 */
            uint32_t            : 26;
    } RTCCTL_b;
  } ;
  __IM  uint32_t  RESERVED1[43];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000100) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t ALM        : 1;            /*!< [0..0] RTC Alarm interrupt                                                */
            uint32_t            : 31;
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000104) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t ALM        : 1;            /*!< [0..0] RTC Alarm interrupt                                                */
            uint32_t            : 31;
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000108) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t ALM        : 1;            /*!< [0..0] RTC Alarm interrupt                                                */
            uint32_t            : 31;
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000010C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t ALM        : 1;            /*!< [0..0] RTC Alarm interrupt                                                */
            uint32_t            : 31;
    } INTSET_b;
  } ;
} RTC_Type;                                     /*!< Size = 272 (0x110)                                                        */



/* =========================================================================================================================== */
/* ================                                           SCARD                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial ISO7816 (SCARD)
  */

typedef struct {                                /*!< (@ 0x40080000) SCARD Structure                                            */

  union {
    __IOM uint32_t SR;                          /*!< (@ 0x00000000) ISO7816 interrupt status                                   */

    struct {
      __IOM uint32_t FNE        : 1;            /*!< [0..0] RX FIFO not empty.                                                 */
      __IOM uint32_t TBERBF     : 1;            /*!< [1..1] FIFO empty (transmit) or full (receive).                           */
      __IOM uint32_t FER        : 1;            /*!< [2..2] Framing error.                                                     */
      __IOM uint32_t OVR        : 1;            /*!< [3..3] RX FIFO overflow.                                                  */
      __IOM uint32_t PE         : 1;            /*!< [4..4] Parity Error.                                                      */
      __IOM uint32_t FT2REND    : 1;            /*!< [5..5] TX to RX finished.                                                 */
      __IOM uint32_t FHF        : 1;            /*!< [6..6] FIFO Half Full.                                                    */
            uint32_t            : 25;
    } SR_b;
  } ;

  union {
    __IOM uint32_t IER;                         /*!< (@ 0x00000004) ISO7816 interrupt enable                                   */

    struct {
      __IOM uint32_t FNEEN      : 1;            /*!< [0..0] RX FIFO not empty interrupt enable.                                */
      __IOM uint32_t TBERBFEN   : 1;            /*!< [1..1] FIFO empty (transmit) or full (receive) interrupt enable.          */
      __IOM uint32_t FEREN      : 1;            /*!< [2..2] Framing error interrupt enable.                                    */
      __IOM uint32_t OVREN      : 1;            /*!< [3..3] RX FIFOI overflow interrupt enable.                                */
      __IOM uint32_t PEEN       : 1;            /*!< [4..4] Parity Error interrupt enable.                                     */
      __IOM uint32_t FT2RENDEN  : 1;            /*!< [5..5] TX to RX finished interrupt enable.                                */
      __IOM uint32_t FHFEN      : 1;            /*!< [6..6] FIFO Half Full interrupt enable.                                   */
            uint32_t            : 25;
    } IER_b;
  } ;

  union {
    __IOM uint32_t TCR;                         /*!< (@ 0x00000008) ISO7816 transmit control                                   */

    struct {
      __IOM uint32_t CONV       : 1;            /*!< [0..0] Conversion inversion control.                                      */
      __IOM uint32_t SS         : 1;            /*!< [1..1] Use first byte to configure conversion.                            */
      __IOM uint32_t LCT        : 1;            /*!< [2..2] Fast TX to RX.                                                     */
      __IOM uint32_t TR         : 1;            /*!< [3..3] Transmit/receive mode.                                             */
      __IOM uint32_t PROT       : 1;            /*!< [4..4] PROT control.                                                      */
      __IOM uint32_t AUTOCONV   : 1;            /*!< [5..5] Automatic conversion.                                              */
      __IOM uint32_t FIP        : 1;            /*!< [6..6] Parity select.                                                     */
      __IOM uint32_t DMAMD      : 1;            /*!< [7..7] DMA direction.                                                     */
            uint32_t            : 24;
    } TCR_b;
  } ;

  union {
    __IOM uint32_t UCR;                         /*!< (@ 0x0000000C) ISO7816 user control                                       */

    struct {
      __IOM uint32_t CST        : 1;            /*!< [0..0] Clock control.                                                     */
      __IOM uint32_t RIU        : 1;            /*!< [1..1] ISO7816 reset. This bit is write-only.                             */
      __IOM uint32_t RSTIN      : 1;            /*!< [2..2] Reset polarity.                                                    */
      __IOM uint32_t RETXEN     : 1;            /*!< [3..3] Enable TX/RX time configuration.                                   */
            uint32_t            : 28;
    } UCR_b;
  } ;

  union {
    __IOM uint32_t DR;                          /*!< (@ 0x00000010) ISO7816 data                                               */

    struct {
      __IOM uint32_t DR         : 8;            /*!< [7..0] Data register.                                                     */
            uint32_t            : 24;
    } DR_b;
  } ;

  union {
    __IOM uint32_t BPRL;                        /*!< (@ 0x00000014) ISO7816 baud rate low                                      */

    struct {
      __IOM uint32_t BPRL       : 8;            /*!< [7..0] Baud rate low                                                      */
            uint32_t            : 24;
    } BPRL_b;
  } ;

  union {
    __IOM uint32_t BPRH;                        /*!< (@ 0x00000018) ISO7816 baud rate high                                     */

    struct {
      __IOM uint32_t BPRH       : 4;            /*!< [3..0] Baud rate high                                                     */
            uint32_t            : 28;
    } BPRH_b;
  } ;

  union {
    __IOM uint32_t UCR1;                        /*!< (@ 0x0000001C) ISO7816 user control 1                                     */

    struct {
      __IOM uint32_t PR         : 1;            /*!< [0..0] Query Card Detect.                                                 */
            uint32_t            : 1;
      __IOM uint32_t STSP       : 1;            /*!< [2..2] ETU counter control. This bit is write-only.                       */
      __IOM uint32_t T1PAREN    : 1;            /*!< [3..3] Parity check control.                                              */
      __IOM uint32_t CLKIOV     : 1;            /*!< [4..4] Output clock level.                                                */
      __IOM uint32_t ENLASTB    : 1;            /*!< [5..5] Enable last byte function.                                         */
            uint32_t            : 26;
    } UCR1_b;
  } ;

  union {
    __IOM uint32_t SR1;                         /*!< (@ 0x00000020) ISO7816 interrupt status 1                                 */

    struct {
      __IOM uint32_t ECNTOVER   : 1;            /*!< [0..0] ETU counter overflow.                                              */
      __IOM uint32_t PRL        : 1;            /*!< [1..1] Card insert/remove.                                                */
      __IOM uint32_t SYNCEND    : 1;            /*!< [2..2] Write complete synchronization.                                    */
      __IOM uint32_t IDLE       : 1;            /*!< [3..3] ISO7816 idle.                                                      */
            uint32_t            : 28;
    } SR1_b;
  } ;

  union {
    __IOM uint32_t IER1;                        /*!< (@ 0x00000024) ISO7816 interrupt enable 1                                 */

    struct {
      __IOM uint32_t ECNTOVEREN : 1;            /*!< [0..0] ETU counter overflow interrupt enable.                             */
      __IOM uint32_t PRLEN      : 1;            /*!< [1..1] Card insert/remove interrupt enable.                               */
      __IOM uint32_t SYNCENDEN  : 1;            /*!< [2..2] Write complete synchronization interrupt enable.                   */
            uint32_t            : 29;
    } IER1_b;
  } ;

  union {
    __IOM uint32_t ECNTL;                       /*!< (@ 0x00000028) ETU counter low                                            */

    struct {
      __IOM uint32_t ECNTL      : 8;            /*!< [7..0] ETU counter low register.                                          */
            uint32_t            : 24;
    } ECNTL_b;
  } ;

  union {
    __IOM uint32_t ECNTH;                       /*!< (@ 0x0000002C) ETU counter high                                           */

    struct {
      __IOM uint32_t ECNTH      : 8;            /*!< [7..0] ETU counter high register.                                         */
            uint32_t            : 24;
    } ECNTH_b;
  } ;

  union {
    __IOM uint32_t GTR;                         /*!< (@ 0x00000030) ISO7816 guard time configuration                           */

    struct {
      __IOM uint32_t GTR        : 8;            /*!< [7..0] Guard time configuration register.                                 */
            uint32_t            : 24;
    } GTR_b;
  } ;

  union {
    __IOM uint32_t RETXCNT;                     /*!< (@ 0x00000034) ISO7816 resend count                                       */

    struct {
      __IOM uint32_t RETXCNT    : 4;            /*!< [3..0] Resend count register.                                             */
            uint32_t            : 28;
    } RETXCNT_b;
  } ;

  union {
    __IOM uint32_t RETXCNTRMI;                  /*!< (@ 0x00000038) ISO7816 resent count inquiry                               */

    struct {
      __IOM uint32_t RETXCNTRMI : 4;            /*!< [3..0] Resent count inquiry register.                                     */
            uint32_t            : 28;
    } RETXCNTRMI_b;
  } ;
  __IM  uint32_t  RESERVED[49];

  union {
    __IOM uint32_t CLKCTRL;                     /*!< (@ 0x00000100) SCARD external clock control                               */

    struct {
      __IOM uint32_t CLKEN      : 1;            /*!< [0..0] Enable the serial source clock for SCARD.                          */
      __IOM uint32_t APBCLKEN   : 1;            /*!< [1..1] Enable the SCARD APB clock to run continuously.                    */
            uint32_t            : 30;
    } CLKCTRL_b;
  } ;
} SCARD_Type;                                   /*!< Size = 260 (0x104)                                                        */



/* =========================================================================================================================== */
/* ================                                         SECURITY                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief Security Interfaces (SECURITY)
  */

typedef struct {                                /*!< (@ 0x40030000) SECURITY Structure                                         */

  union {
    __IOM uint32_t CTRL;                        /*!< (@ 0x00000000) Control                                                    */

    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< [0..0] Function Enable. Software should set the ENABLE bit to
                                                     initiate a CRC operation. Hardware will clear the ENABLE
                                                     bit upon completion.                                                      */
            uint32_t            : 3;
      __IOM uint32_t FUNCTION   : 4;            /*!< [7..4] Function Select                                                    */
            uint32_t            : 23;
      __IOM uint32_t CRCERROR   : 1;            /*!< [31..31] CRC Error Status - Set to 1 if an error occurs during
                                                     a CRC operation. Cleared when CTRL register is written
                                                     (with any value). Usually indicates an invalid address
                                                     range.                                                                    */
    } CTRL_b;
  } ;
  __IM  uint32_t  RESERVED[3];

  union {
    __IOM uint32_t SRCADDR;                     /*!< (@ 0x00000010) Source Address                                             */

    struct {
      __IOM uint32_t ADDR       : 32;           /*!< [31..0] Source Buffer Address. Address may be byte aligned,
                                                     but the length must be a multiple of 4 bits.                              */
    } SRCADDR_b;
  } ;
  __IM  uint32_t  RESERVED1[3];

  union {
    __IOM uint32_t LEN;                         /*!< (@ 0x00000020) Length                                                     */

    struct {
            uint32_t            : 2;
      __IOM uint32_t LEN        : 18;           /*!< [19..2] Buffer size (bottom two bits assumed to be zero to ensure
                                                     a multiple of 4 bytes)                                                    */
            uint32_t            : 12;
    } LEN_b;
  } ;
  __IM  uint32_t  RESERVED2[3];

  union {
    __IOM uint32_t RESULT;                      /*!< (@ 0x00000030) CRC Seed/Result                                            */

    struct {
      __IOM uint32_t CRC        : 32;           /*!< [31..0] CRC Seed/Result. Software must seed the CRC with 0xFFFFFFFF
                                                     before starting a CRC operation (unless the CRC is continued
                                                     from a previous operation).                                               */
    } RESULT_b;
  } ;
  __IM  uint32_t  RESERVED3[17];

  union {
    __IOM uint32_t LOCKCTRL;                    /*!< (@ 0x00000078) LOCK Control                                               */

    struct {
      __IOM uint32_t SELECT     : 8;            /*!< [7..0] LOCK Function Select register.                                     */
            uint32_t            : 24;
    } LOCKCTRL_b;
  } ;

  union {
    __IOM uint32_t LOCKSTAT;                    /*!< (@ 0x0000007C) LOCK Status                                                */

    struct {
      __IOM uint32_t STATUS     : 32;           /*!< [31..0] LOCK Status register. This register is a bit mask for
                                                     which resources are currently unlocked. These bits are
                                                     one-hot per resource.                                                     */
    } LOCKSTAT_b;
  } ;

  union {
    __IOM uint32_t KEY0;                        /*!< (@ 0x00000080) Key0                                                       */

    struct {
      __IOM uint32_t KEY0       : 32;           /*!< [31..0] Bits [31:0] of the 128-bit key should be written to
                                                     this register. To protect key values, the register always
                                                     returns 0x00000000.                                                       */
    } KEY0_b;
  } ;

  union {
    __IOM uint32_t KEY1;                        /*!< (@ 0x00000084) Key1                                                       */

    struct {
      __IOM uint32_t KEY1       : 32;           /*!< [31..0] Bits [63:32] of the 128-bit key should be written to
                                                     this register. To protect key values, the register always
                                                     returns 0x00000000.                                                       */
    } KEY1_b;
  } ;

  union {
    __IOM uint32_t KEY2;                        /*!< (@ 0x00000088) Key2                                                       */

    struct {
      __IOM uint32_t KEY2       : 32;           /*!< [31..0] Bits [95:64] of the 128-bit key should be written to
                                                     this register. To protect key values, the register always
                                                     returns 0x00000000.                                                       */
    } KEY2_b;
  } ;

  union {
    __IOM uint32_t KEY3;                        /*!< (@ 0x0000008C) Key3                                                       */

    struct {
      __IOM uint32_t KEY3       : 32;           /*!< [31..0] Bits [127:96] of the 128-bit key should be written to
                                                     this register. To protect key values, the register always
                                                     returns 0x00000000.                                                       */
    } KEY3_b;
  } ;
} SECURITY_Type;                                /*!< Size = 144 (0x90)                                                         */



/* =========================================================================================================================== */
/* ================                                           UART0                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial UART (UART0)
  */

typedef struct {                                /*!< (@ 0x4001C000) UART0 Structure                                            */

  union {
    __IOM uint32_t DR;                          /*!< (@ 0x00000000) UART Data                                                  */

    struct {
      __IOM uint32_t DATA       : 8;            /*!< [7..0] This is the UART data port.                                        */
      __IOM uint32_t FEDATA     : 1;            /*!< [8..8] This is the framing error indicator.                               */
      __IOM uint32_t PEDATA     : 1;            /*!< [9..9] This is the parity error indicator.                                */
      __IOM uint32_t BEDATA     : 1;            /*!< [10..10] This is the break error indicator.                               */
      __IOM uint32_t OEDATA     : 1;            /*!< [11..11] This is the overrun error indicator.                             */
            uint32_t            : 20;
    } DR_b;
  } ;

  union {
    __IOM uint32_t RSR;                         /*!< (@ 0x00000004) UART Status                                                */

    struct {
      __IOM uint32_t FESTAT     : 1;            /*!< [0..0] This is the framing error indicator.                               */
      __IOM uint32_t PESTAT     : 1;            /*!< [1..1] This is the parity error indicator.                                */
      __IOM uint32_t BESTAT     : 1;            /*!< [2..2] This is the break error indicator.                                 */
      __IOM uint32_t OESTAT     : 1;            /*!< [3..3] This is the overrun error indicator.                               */
            uint32_t            : 28;
    } RSR_b;
  } ;
  __IM  uint32_t  RESERVED[4];

  union {
    __IOM uint32_t FR;                          /*!< (@ 0x00000018) Flag                                                       */

    struct {
      __IOM uint32_t CTS        : 1;            /*!< [0..0] This bit holds the clear to send indicator.                        */
      __IOM uint32_t DSR        : 1;            /*!< [1..1] This bit holds the data set ready indicator.                       */
      __IOM uint32_t DCD        : 1;            /*!< [2..2] This bit holds the data carrier detect indicator.                  */
      __IOM uint32_t BUSY       : 1;            /*!< [3..3] This bit holds the busy indicator.                                 */
      __IOM uint32_t RXFE       : 1;            /*!< [4..4] This bit holds the receive FIFO empty indicator.                   */
      __IOM uint32_t TXFF       : 1;            /*!< [5..5] This bit holds the transmit FIFO full indicator.                   */
      __IOM uint32_t RXFF       : 1;            /*!< [6..6] This bit holds the receive FIFO full indicator.                    */
      __IOM uint32_t TXFE       : 1;            /*!< [7..7] This bit holds the transmit FIFO empty indicator.                  */
      __IOM uint32_t TXBUSY     : 1;            /*!< [8..8] This bit holds the transmit BUSY indicator.                        */
            uint32_t            : 23;
    } FR_b;
  } ;
  __IM  uint32_t  RESERVED1;

  union {
    __IOM uint32_t ILPR;                        /*!< (@ 0x00000020) IrDA Counter                                               */

    struct {
      __IOM uint32_t ILPDVSR    : 8;            /*!< [7..0] These bits hold the IrDA counter divisor.                          */
            uint32_t            : 24;
    } ILPR_b;
  } ;

  union {
    __IOM uint32_t IBRD;                        /*!< (@ 0x00000024) Integer Baud Rate Divisor                                  */

    struct {
      __IOM uint32_t DIVINT     : 16;           /*!< [15..0] These bits hold the baud integer divisor.                         */
            uint32_t            : 16;
    } IBRD_b;
  } ;

  union {
    __IOM uint32_t FBRD;                        /*!< (@ 0x00000028) Fractional Baud Rate Divisor                               */

    struct {
      __IOM uint32_t DIVFRAC    : 6;            /*!< [5..0] These bits hold the baud fractional divisor.                       */
            uint32_t            : 26;
    } FBRD_b;
  } ;

  union {
    __IOM uint32_t LCRH;                        /*!< (@ 0x0000002C) Line Control High                                          */

    struct {
      __IOM uint32_t BRK        : 1;            /*!< [0..0] This bit holds the break set.                                      */
      __IOM uint32_t PEN        : 1;            /*!< [1..1] This bit holds the parity enable.                                  */
      __IOM uint32_t EPS        : 1;            /*!< [2..2] This bit holds the even parity select.                             */
      __IOM uint32_t STP2       : 1;            /*!< [3..3] This bit holds the two stop bits select.                           */
      __IOM uint32_t FEN        : 1;            /*!< [4..4] This bit holds the FIFO enable.                                    */
      __IOM uint32_t WLEN       : 2;            /*!< [6..5] These bits hold the write length.                                  */
      __IOM uint32_t SPS        : 1;            /*!< [7..7] This bit holds the stick parity select.                            */
            uint32_t            : 24;
    } LCRH_b;
  } ;

  union {
    __IOM uint32_t CR;                          /*!< (@ 0x00000030) Control                                                    */

    struct {
      __IOM uint32_t UARTEN     : 1;            /*!< [0..0] This bit is the UART enable.                                       */
      __IOM uint32_t SIREN      : 1;            /*!< [1..1] This bit is the SIR ENDEC enable.                                  */
      __IOM uint32_t SIRLP      : 1;            /*!< [2..2] This bit is the SIR low power select.                              */
      __IOM uint32_t CLKEN      : 1;            /*!< [3..3] This bit is the UART clock enable.                                 */
      __IOM uint32_t CLKSEL     : 3;            /*!< [6..4] This bit field is the UART clock select.                           */
      __IOM uint32_t LBE        : 1;            /*!< [7..7] This bit is the loopback enable.                                   */
      __IOM uint32_t TXE        : 1;            /*!< [8..8] This bit is the transmit enable.                                   */
      __IOM uint32_t RXE        : 1;            /*!< [9..9] This bit is the receive enable.                                    */
      __IOM uint32_t DTR        : 1;            /*!< [10..10] This bit enables data transmit ready.                            */
      __IOM uint32_t RTS        : 1;            /*!< [11..11] This bit enables request to send.                                */
      __IOM uint32_t OUT1       : 1;            /*!< [12..12] This bit holds modem Out1.                                       */
      __IOM uint32_t OUT2       : 1;            /*!< [13..13] This bit holds modem Out2.                                       */
      __IOM uint32_t RTSEN      : 1;            /*!< [14..14] This bit enables RTS hardware flow control.                      */
      __IOM uint32_t CTSEN      : 1;            /*!< [15..15] This bit enables CTS hardware flow control.                      */
            uint32_t            : 16;
    } CR_b;
  } ;

  union {
    __IOM uint32_t IFLS;                        /*!< (@ 0x00000034) FIFO Interrupt Level Select                                */

    struct {
      __IOM uint32_t TXIFLSEL   : 3;            /*!< [2..0] These bits hold the transmit FIFO interrupt level.                 */
      __IOM uint32_t RXIFLSEL   : 3;            /*!< [5..3] These bits hold the receive FIFO interrupt level.                  */
            uint32_t            : 26;
    } IFLS_b;
  } ;

  union {
    __IOM uint32_t IER;                         /*!< (@ 0x00000038) Interrupt Enable                                           */

    struct {
      __IOM uint32_t TXCMPMIM   : 1;            /*!< [0..0] This bit holds the modem TXCMP interrupt enable.                   */
      __IOM uint32_t CTSMIM     : 1;            /*!< [1..1] This bit holds the modem CTS interrupt enable.                     */
      __IOM uint32_t DCDMIM     : 1;            /*!< [2..2] This bit holds the modem DCD interrupt enable.                     */
      __IOM uint32_t DSRMIM     : 1;            /*!< [3..3] This bit holds the modem DSR interrupt enable.                     */
      __IOM uint32_t RXIM       : 1;            /*!< [4..4] This bit holds the receive interrupt enable.                       */
      __IOM uint32_t TXIM       : 1;            /*!< [5..5] This bit holds the transmit interrupt enable.                      */
      __IOM uint32_t RTIM       : 1;            /*!< [6..6] This bit holds the receive timeout interrupt enable.               */
      __IOM uint32_t FEIM       : 1;            /*!< [7..7] This bit holds the framing error interrupt enable.                 */
      __IOM uint32_t PEIM       : 1;            /*!< [8..8] This bit holds the parity error interrupt enable.                  */
      __IOM uint32_t BEIM       : 1;            /*!< [9..9] This bit holds the break error interrupt enable.                   */
      __IOM uint32_t OEIM       : 1;            /*!< [10..10] This bit holds the overflow interrupt enable.                    */
            uint32_t            : 21;
    } IER_b;
  } ;

  union {
    __IOM uint32_t IES;                         /*!< (@ 0x0000003C) Interrupt Status                                           */

    struct {
      __IOM uint32_t TXCMPMRIS  : 1;            /*!< [0..0] This bit holds the modem TXCMP interrupt status.                   */
      __IOM uint32_t CTSMRIS    : 1;            /*!< [1..1] This bit holds the modem CTS interrupt status.                     */
      __IOM uint32_t DCDMRIS    : 1;            /*!< [2..2] This bit holds the modem DCD interrupt status.                     */
      __IOM uint32_t DSRMRIS    : 1;            /*!< [3..3] This bit holds the modem DSR interrupt status.                     */
      __IOM uint32_t RXRIS      : 1;            /*!< [4..4] This bit holds the receive interrupt status.                       */
      __IOM uint32_t TXRIS      : 1;            /*!< [5..5] This bit holds the transmit interrupt status.                      */
      __IOM uint32_t RTRIS      : 1;            /*!< [6..6] This bit holds the receive timeout interrupt status.               */
      __IOM uint32_t FERIS      : 1;            /*!< [7..7] This bit holds the framing error interrupt status.                 */
      __IOM uint32_t PERIS      : 1;            /*!< [8..8] This bit holds the parity error interrupt status.                  */
      __IOM uint32_t BERIS      : 1;            /*!< [9..9] This bit holds the break error interrupt status.                   */
      __IOM uint32_t OERIS      : 1;            /*!< [10..10] This bit holds the overflow interrupt status.                    */
            uint32_t            : 21;
    } IES_b;
  } ;

  union {
    __IOM uint32_t MIS;                         /*!< (@ 0x00000040) Masked Interrupt Status                                    */

    struct {
      __IOM uint32_t TXCMPMMIS  : 1;            /*!< [0..0] This bit holds the modem TXCMP interrupt status masked.            */
      __IOM uint32_t CTSMMIS    : 1;            /*!< [1..1] This bit holds the modem CTS interrupt status masked.              */
      __IOM uint32_t DCDMMIS    : 1;            /*!< [2..2] This bit holds the modem DCD interrupt status masked.              */
      __IOM uint32_t DSRMMIS    : 1;            /*!< [3..3] This bit holds the modem DSR interrupt status masked.              */
      __IOM uint32_t RXMIS      : 1;            /*!< [4..4] This bit holds the receive interrupt status masked.                */
      __IOM uint32_t TXMIS      : 1;            /*!< [5..5] This bit holds the transmit interrupt status masked.               */
      __IOM uint32_t RTMIS      : 1;            /*!< [6..6] This bit holds the receive timeout interrupt status masked.        */
      __IOM uint32_t FEMIS      : 1;            /*!< [7..7] This bit holds the framing error interrupt status masked.          */
      __IOM uint32_t PEMIS      : 1;            /*!< [8..8] This bit holds the parity error interrupt status masked.           */
      __IOM uint32_t BEMIS      : 1;            /*!< [9..9] This bit holds the break error interrupt status masked.            */
      __IOM uint32_t OEMIS      : 1;            /*!< [10..10] This bit holds the overflow interrupt status masked.             */
            uint32_t            : 21;
    } MIS_b;
  } ;

  union {
    __IOM uint32_t IEC;                         /*!< (@ 0x00000044) Interrupt Clear                                            */

    struct {
      __IOM uint32_t TXCMPMIC   : 1;            /*!< [0..0] This bit holds the modem TXCMP interrupt clear.                    */
      __IOM uint32_t CTSMIC     : 1;            /*!< [1..1] This bit holds the modem CTS interrupt clear.                      */
      __IOM uint32_t DCDMIC     : 1;            /*!< [2..2] This bit holds the modem DCD interrupt clear.                      */
      __IOM uint32_t DSRMIC     : 1;            /*!< [3..3] This bit holds the modem DSR interrupt clear.                      */
      __IOM uint32_t RXIC       : 1;            /*!< [4..4] This bit holds the receive interrupt clear.                        */
      __IOM uint32_t TXIC       : 1;            /*!< [5..5] This bit holds the transmit interrupt clear.                       */
      __IOM uint32_t RTIC       : 1;            /*!< [6..6] This bit holds the receive timeout interrupt clear.                */
      __IOM uint32_t FEIC       : 1;            /*!< [7..7] This bit holds the framing error interrupt clear.                  */
      __IOM uint32_t PEIC       : 1;            /*!< [8..8] This bit holds the parity error interrupt clear.                   */
      __IOM uint32_t BEIC       : 1;            /*!< [9..9] This bit holds the break error interrupt clear.                    */
      __IOM uint32_t OEIC       : 1;            /*!< [10..10] This bit holds the overflow interrupt clear.                     */
            uint32_t            : 21;
    } IEC_b;
  } ;
} UART0_Type;                                   /*!< Size = 72 (0x48)                                                          */



/* =========================================================================================================================== */
/* ================                                           VCOMP                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Voltage Comparator (VCOMP)
  */

typedef struct {                                /*!< (@ 0x4000C000) VCOMP Structure                                            */

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) The Voltage Comparator Configuration Register
                                                                    contains the software control for selecting
                                                                    between the 4 options for the positive input
                                                                    as well as the multiple options for the
                                                                    reference input.                                           */

    struct {
      __IOM uint32_t PSEL       : 2;            /*!< [1..0] This bit field selects the positive input to the comparator.       */
            uint32_t            : 6;
      __IOM uint32_t NSEL       : 2;            /*!< [9..8] This bit field selects the negative input to the comparator.       */
            uint32_t            : 6;
      __IOM uint32_t LVLSEL     : 4;            /*!< [19..16] When the reference input NSEL is set to NSEL_DAC, this
                                                     bit field selects the voltage level for the negative input
                                                     to the comparator.                                                        */
            uint32_t            : 12;
    } CFG_b;
  } ;

  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) Status                                                     */

    struct {
      __IOM uint32_t CMPOUT     : 1;            /*!< [0..0] This bit is 1 if the positive input of the comparator
                                                     is greater than the negative input.                                       */
      __IOM uint32_t PWDSTAT    : 1;            /*!< [1..1] This bit indicates the power down state of the voltage
                                                     comparator.                                                               */
            uint32_t            : 30;
    } STAT_b;
  } ;

  union {
    __IOM uint32_t PWDKEY;                      /*!< (@ 0x00000008) Write a value of 0x37 to unlock, write any other
                                                                    value to lock. This register also indicates
                                                                    lock status when read. When in the unlocked
                                                                    state (i.e. 0x37 has been written), it reads
                                                                    as 1. When in the locked state, it reads
                                                                    as 0.                                                      */

    struct {
      __IOM uint32_t PWDKEY     : 32;           /*!< [31..0] Key register value.                                               */
    } PWDKEY_b;
  } ;
  __IM  uint32_t  RESERVED[125];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< [0..0] This bit is the vcompout low interrupt.                            */
      __IOM uint32_t OUTHI      : 1;            /*!< [1..1] This bit is the vcompout high interrupt.                           */
            uint32_t            : 30;
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< [0..0] This bit is the vcompout low interrupt.                            */
      __IOM uint32_t OUTHI      : 1;            /*!< [1..1] This bit is the vcompout high interrupt.                           */
            uint32_t            : 30;
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< [0..0] This bit is the vcompout low interrupt.                            */
      __IOM uint32_t OUTHI      : 1;            /*!< [1..1] This bit is the vcompout high interrupt.                           */
            uint32_t            : 30;
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< [0..0] This bit is the vcompout low interrupt.                            */
      __IOM uint32_t OUTHI      : 1;            /*!< [1..1] This bit is the vcompout high interrupt.                           */
            uint32_t            : 30;
    } INTSET_b;
  } ;
} VCOMP_Type;                                   /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                            WDT                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Watchdog Timer (WDT)
  */

typedef struct {                                /*!< (@ 0x40024000) WDT Structure                                              */

  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) This is the configuration register for the watch
                                                                    dog timer. It controls the enable, interrupt
                                                                    set, clocks for the timer, the compare values
                                                                    for the counters to trigger a reset or interrupt.
                                                                    This register can only be written to if
                                                                    the watch dog timer is unlocked (WDTLOCK
                                                                    is not set).                                               */

    struct {
      __IOM uint32_t WDTEN      : 1;            /*!< [0..0] This bit field enables the WDT.                                    */
      __IOM uint32_t INTEN      : 1;            /*!< [1..1] This bit field enables the WDT interrupt. Note : This
                                                     bit must be set before the interrupt status bit will reflect
                                                     a watchdog timer expiration. The IER interrupt register
                                                     must also be enabled for a WDT interrupt to be sent to
                                                     the NVIC.                                                                 */
      __IOM uint32_t RESEN      : 1;            /*!< [2..2] This bit field enables the WDT reset. This needs to be
                                                     set together with the WDREN bit in REG_RSTGEN_CFG register
                                                     (in reset gen) to trigger the reset.                                      */
            uint32_t            : 5;
      __IOM uint32_t RESVAL     : 8;            /*!< [15..8] This bit field is the compare value for counter bits
                                                     7:0 to generate a watchdog reset. This will cause a software
                                                     reset.                                                                    */
      __IOM uint32_t INTVAL     : 8;            /*!< [23..16] This bit field is the compare value for counter bits
                                                     7:0 to generate a watchdog interrupt.                                     */
      __IOM uint32_t CLKSEL     : 3;            /*!< [26..24] Select the frequency for the WDT. All values not enumerated
                                                     below are undefined.                                                      */
            uint32_t            : 5;
    } CFG_b;
  } ;

  union {
    __IOM uint32_t RSTRT;                       /*!< (@ 0x00000004) This register will Restart the watchdog timer.
                                                                    Writing a special key value into this register
                                                                    will result in the watch dog timer being
                                                                    reset, so that the count will start again.
                                                                    It is expected that the software will periodically
                                                                    write to this register to indicate that
                                                                    the system is functional. The watch dog
                                                                    timer can continue running when the system
                                                                    is in deep sleep, and the interrupt will
                                                                    trigger the wake. After the wake, the core
                                                                    can reset the watch dog timer.                             */

    struct {
      __IOM uint32_t RSTRT      : 8;            /*!< [7..0] Writing 0xB2 to WDTRSTRT restarts the watchdog timer.
                                                     This is a write only register. Reading this register will
                                                     only provide all 0.                                                       */
            uint32_t            : 24;
    } RSTRT_b;
  } ;

  union {
    __IOM uint32_t LOCK;                        /*!< (@ 0x00000008) This register locks the watch dog timer. Once
                                                                    it is locked, the configuration register
                                                                    (WDTCFG) for watch dog timer cannot be written
                                                                    to.                                                        */

    struct {
      __IOM uint32_t LOCK       : 8;            /*!< [7..0] Writing 0x3A locks the watchdog timer. Once locked, the
                                                     WDTCFG reg cannot be written and WDTEN is set.                            */
            uint32_t            : 24;
    } LOCK_b;
  } ;

  union {
    __IOM uint32_t COUNT;                       /*!< (@ 0x0000000C) This register holds the current count for the
                                                                    watch dog timer. This is a read only register.
                                                                    SW cannot set the value in the counter,
                                                                    but can reset it.                                          */

    struct {
      __IOM uint32_t COUNT      : 8;            /*!< [7..0] Read-Only current value of the WDT counter                         */
            uint32_t            : 24;
    } COUNT_b;
  } ;
  __IM  uint32_t  RESERVED[124];

  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Set bits in this register to allow this module
                                                                    to generate the corresponding interrupt.                   */

    struct {
      __IOM uint32_t WDTINT     : 1;            /*!< [0..0] Watchdog Timer Interrupt.                                          */
            uint32_t            : 31;
    } INTEN_b;
  } ;

  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Read bits from this register to discover the
                                                                    cause of a recent interrupt.                               */

    struct {
      __IOM uint32_t WDTINT     : 1;            /*!< [0..0] Watchdog Timer Interrupt.                                          */
            uint32_t            : 31;
    } INTSTAT_b;
  } ;

  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Write a 1 to a bit in this register to clear
                                                                    the interrupt status associated with that
                                                                    bit.                                                       */

    struct {
      __IOM uint32_t WDTINT     : 1;            /*!< [0..0] Watchdog Timer Interrupt.                                          */
            uint32_t            : 31;
    } INTCLR_b;
  } ;

  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Write a 1 to a bit in this register to instantly
                                                                    generate an interrupt from this module.
                                                                    (Generally used for testing purposes).                     */

    struct {
      __IOM uint32_t WDTINT     : 1;            /*!< [0..0] Watchdog Timer Interrupt.                                          */
            uint32_t            : 31;
    } INTSET_b;
  } ;
} WDT_Type;                                     /*!< Size = 528 (0x210)                                                        */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define ADC_BASE                    0x50010000UL
#define APBDMA_BASE                 0x40011000UL
#define BLEIF_BASE                  0x5000C000UL
#define CACHECTRL_BASE              0x40018000UL
#define CLKGEN_BASE                 0x40004000UL
#define CTIMER_BASE                 0x40008000UL
#define GPIO_BASE                   0x40010000UL
#define IOM0_BASE                   0x50004000UL
#define IOM1_BASE                   0x50005000UL
#define IOM2_BASE                   0x50006000UL
#define IOM3_BASE                   0x50007000UL
#define IOM4_BASE                   0x50008000UL
#define IOM5_BASE                   0x50009000UL
#define IOSLAVE_BASE                0x50000000UL
#define MCUCTRL_BASE                0x40020000UL
#define MSPI_BASE                   0x50014000UL
#define PDM_BASE                    0x50011000UL
#define PWRCTRL_BASE                0x40021000UL
#define RSTGEN_BASE                 0x40000000UL
#define RTC_BASE                    0x40004200UL
#define SCARD_BASE                  0x40080000UL
#define SECURITY_BASE               0x40030000UL
#define UART0_BASE                  0x4001C000UL
#define UART1_BASE                  0x4001D000UL
#define VCOMP_BASE                  0x4000C000UL
#define WDT_BASE                    0x40024000UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define ADC                         ((ADC_Type*)               ADC_BASE)
#define APBDMA                      ((APBDMA_Type*)            APBDMA_BASE)
#define BLEIF                       ((BLEIF_Type*)             BLEIF_BASE)
#define CACHECTRL                   ((CACHECTRL_Type*)         CACHECTRL_BASE)
#define CLKGEN                      ((CLKGEN_Type*)            CLKGEN_BASE)
#define CTIMER                      ((CTIMER_Type*)            CTIMER_BASE)
#define GPIO                        ((GPIO_Type*)              GPIO_BASE)
#define IOM0                        ((IOM0_Type*)              IOM0_BASE)
#define IOM1                        ((IOM0_Type*)              IOM1_BASE)
#define IOM2                        ((IOM0_Type*)              IOM2_BASE)
#define IOM3                        ((IOM0_Type*)              IOM3_BASE)
#define IOM4                        ((IOM0_Type*)              IOM4_BASE)
#define IOM5                        ((IOM0_Type*)              IOM5_BASE)
#define IOSLAVE                     ((IOSLAVE_Type*)           IOSLAVE_BASE)
#define MCUCTRL                     ((MCUCTRL_Type*)           MCUCTRL_BASE)
#define MSPI                        ((MSPI_Type*)              MSPI_BASE)
#define PDM                         ((PDM_Type*)               PDM_BASE)
#define PWRCTRL                     ((PWRCTRL_Type*)           PWRCTRL_BASE)
#define RSTGEN                      ((RSTGEN_Type*)            RSTGEN_BASE)
#define RTC                         ((RTC_Type*)               RTC_BASE)
#define SCARD                       ((SCARD_Type*)             SCARD_BASE)
#define SECURITY                    ((SECURITY_Type*)          SECURITY_BASE)
#define UART0                       ((UART0_Type*)             UART0_BASE)
#define UART1                       ((UART0_Type*)             UART1_BASE)
#define VCOMP                       ((VCOMP_Type*)             VCOMP_BASE)
#define WDT                         ((WDT_Type*)               WDT_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */


/** @addtogroup PosMask_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define ADC_CFG_CLKSEL_Pos                (24UL)                    /*!< CLKSEL (Bit 24)                                       */
#define ADC_CFG_CLKSEL_Msk                (0x3000000UL)             /*!< CLKSEL (Bitfield-Mask: 0x03)                          */
#define ADC_CFG_TRIGPOL_Pos               (19UL)                    /*!< TRIGPOL (Bit 19)                                      */
#define ADC_CFG_TRIGPOL_Msk               (0x80000UL)               /*!< TRIGPOL (Bitfield-Mask: 0x01)                         */
#define ADC_CFG_TRIGSEL_Pos               (16UL)                    /*!< TRIGSEL (Bit 16)                                      */
#define ADC_CFG_TRIGSEL_Msk               (0x70000UL)               /*!< TRIGSEL (Bitfield-Mask: 0x07)                         */
#define ADC_CFG_DFIFORDEN_Pos             (12UL)                    /*!< DFIFORDEN (Bit 12)                                    */
#define ADC_CFG_DFIFORDEN_Msk             (0x1000UL)                /*!< DFIFORDEN (Bitfield-Mask: 0x01)                       */
#define ADC_CFG_REFSEL_Pos                (8UL)                     /*!< REFSEL (Bit 8)                                        */
#define ADC_CFG_REFSEL_Msk                (0x300UL)                 /*!< REFSEL (Bitfield-Mask: 0x03)                          */
#define ADC_CFG_CKMODE_Pos                (4UL)                     /*!< CKMODE (Bit 4)                                        */
#define ADC_CFG_CKMODE_Msk                (0x10UL)                  /*!< CKMODE (Bitfield-Mask: 0x01)                          */
#define ADC_CFG_LPMODE_Pos                (3UL)                     /*!< LPMODE (Bit 3)                                        */
#define ADC_CFG_LPMODE_Msk                (0x8UL)                   /*!< LPMODE (Bitfield-Mask: 0x01)                          */
#define ADC_CFG_RPTEN_Pos                 (2UL)                     /*!< RPTEN (Bit 2)                                         */
#define ADC_CFG_RPTEN_Msk                 (0x4UL)                   /*!< RPTEN (Bitfield-Mask: 0x01)                           */
#define ADC_CFG_ADCEN_Pos                 (0UL)                     /*!< ADCEN (Bit 0)                                         */
#define ADC_CFG_ADCEN_Msk                 (0x1UL)                   /*!< ADCEN (Bitfield-Mask: 0x01)                           */
/* =========================================================  STAT  ========================================================== */
#define ADC_STAT_PWDSTAT_Pos              (0UL)                     /*!< PWDSTAT (Bit 0)                                       */
#define ADC_STAT_PWDSTAT_Msk              (0x1UL)                   /*!< PWDSTAT (Bitfield-Mask: 0x01)                         */
/* ==========================================================  SWT  ========================================================== */
#define ADC_SWT_SWT_Pos                   (0UL)                     /*!< SWT (Bit 0)                                           */
#define ADC_SWT_SWT_Msk                   (0xffUL)                  /*!< SWT (Bitfield-Mask: 0xff)                             */
/* ========================================================  SL0CFG  ========================================================= */
#define ADC_SL0CFG_ADSEL0_Pos             (24UL)                    /*!< ADSEL0 (Bit 24)                                       */
#define ADC_SL0CFG_ADSEL0_Msk             (0x7000000UL)             /*!< ADSEL0 (Bitfield-Mask: 0x07)                          */
#define ADC_SL0CFG_PRMODE0_Pos            (16UL)                    /*!< PRMODE0 (Bit 16)                                      */
#define ADC_SL0CFG_PRMODE0_Msk            (0x30000UL)               /*!< PRMODE0 (Bitfield-Mask: 0x03)                         */
#define ADC_SL0CFG_CHSEL0_Pos             (8UL)                     /*!< CHSEL0 (Bit 8)                                        */
#define ADC_SL0CFG_CHSEL0_Msk             (0xf00UL)                 /*!< CHSEL0 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL0CFG_WCEN0_Pos              (1UL)                     /*!< WCEN0 (Bit 1)                                         */
#define ADC_SL0CFG_WCEN0_Msk              (0x2UL)                   /*!< WCEN0 (Bitfield-Mask: 0x01)                           */
#define ADC_SL0CFG_SLEN0_Pos              (0UL)                     /*!< SLEN0 (Bit 0)                                         */
#define ADC_SL0CFG_SLEN0_Msk              (0x1UL)                   /*!< SLEN0 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL1CFG  ========================================================= */
#define ADC_SL1CFG_ADSEL1_Pos             (24UL)                    /*!< ADSEL1 (Bit 24)                                       */
#define ADC_SL1CFG_ADSEL1_Msk             (0x7000000UL)             /*!< ADSEL1 (Bitfield-Mask: 0x07)                          */
#define ADC_SL1CFG_PRMODE1_Pos            (16UL)                    /*!< PRMODE1 (Bit 16)                                      */
#define ADC_SL1CFG_PRMODE1_Msk            (0x30000UL)               /*!< PRMODE1 (Bitfield-Mask: 0x03)                         */
#define ADC_SL1CFG_CHSEL1_Pos             (8UL)                     /*!< CHSEL1 (Bit 8)                                        */
#define ADC_SL1CFG_CHSEL1_Msk             (0xf00UL)                 /*!< CHSEL1 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL1CFG_WCEN1_Pos              (1UL)                     /*!< WCEN1 (Bit 1)                                         */
#define ADC_SL1CFG_WCEN1_Msk              (0x2UL)                   /*!< WCEN1 (Bitfield-Mask: 0x01)                           */
#define ADC_SL1CFG_SLEN1_Pos              (0UL)                     /*!< SLEN1 (Bit 0)                                         */
#define ADC_SL1CFG_SLEN1_Msk              (0x1UL)                   /*!< SLEN1 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL2CFG  ========================================================= */
#define ADC_SL2CFG_ADSEL2_Pos             (24UL)                    /*!< ADSEL2 (Bit 24)                                       */
#define ADC_SL2CFG_ADSEL2_Msk             (0x7000000UL)             /*!< ADSEL2 (Bitfield-Mask: 0x07)                          */
#define ADC_SL2CFG_PRMODE2_Pos            (16UL)                    /*!< PRMODE2 (Bit 16)                                      */
#define ADC_SL2CFG_PRMODE2_Msk            (0x30000UL)               /*!< PRMODE2 (Bitfield-Mask: 0x03)                         */
#define ADC_SL2CFG_CHSEL2_Pos             (8UL)                     /*!< CHSEL2 (Bit 8)                                        */
#define ADC_SL2CFG_CHSEL2_Msk             (0xf00UL)                 /*!< CHSEL2 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL2CFG_WCEN2_Pos              (1UL)                     /*!< WCEN2 (Bit 1)                                         */
#define ADC_SL2CFG_WCEN2_Msk              (0x2UL)                   /*!< WCEN2 (Bitfield-Mask: 0x01)                           */
#define ADC_SL2CFG_SLEN2_Pos              (0UL)                     /*!< SLEN2 (Bit 0)                                         */
#define ADC_SL2CFG_SLEN2_Msk              (0x1UL)                   /*!< SLEN2 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL3CFG  ========================================================= */
#define ADC_SL3CFG_ADSEL3_Pos             (24UL)                    /*!< ADSEL3 (Bit 24)                                       */
#define ADC_SL3CFG_ADSEL3_Msk             (0x7000000UL)             /*!< ADSEL3 (Bitfield-Mask: 0x07)                          */
#define ADC_SL3CFG_PRMODE3_Pos            (16UL)                    /*!< PRMODE3 (Bit 16)                                      */
#define ADC_SL3CFG_PRMODE3_Msk            (0x30000UL)               /*!< PRMODE3 (Bitfield-Mask: 0x03)                         */
#define ADC_SL3CFG_CHSEL3_Pos             (8UL)                     /*!< CHSEL3 (Bit 8)                                        */
#define ADC_SL3CFG_CHSEL3_Msk             (0xf00UL)                 /*!< CHSEL3 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL3CFG_WCEN3_Pos              (1UL)                     /*!< WCEN3 (Bit 1)                                         */
#define ADC_SL3CFG_WCEN3_Msk              (0x2UL)                   /*!< WCEN3 (Bitfield-Mask: 0x01)                           */
#define ADC_SL3CFG_SLEN3_Pos              (0UL)                     /*!< SLEN3 (Bit 0)                                         */
#define ADC_SL3CFG_SLEN3_Msk              (0x1UL)                   /*!< SLEN3 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL4CFG  ========================================================= */
#define ADC_SL4CFG_ADSEL4_Pos             (24UL)                    /*!< ADSEL4 (Bit 24)                                       */
#define ADC_SL4CFG_ADSEL4_Msk             (0x7000000UL)             /*!< ADSEL4 (Bitfield-Mask: 0x07)                          */
#define ADC_SL4CFG_PRMODE4_Pos            (16UL)                    /*!< PRMODE4 (Bit 16)                                      */
#define ADC_SL4CFG_PRMODE4_Msk            (0x30000UL)               /*!< PRMODE4 (Bitfield-Mask: 0x03)                         */
#define ADC_SL4CFG_CHSEL4_Pos             (8UL)                     /*!< CHSEL4 (Bit 8)                                        */
#define ADC_SL4CFG_CHSEL4_Msk             (0xf00UL)                 /*!< CHSEL4 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL4CFG_WCEN4_Pos              (1UL)                     /*!< WCEN4 (Bit 1)                                         */
#define ADC_SL4CFG_WCEN4_Msk              (0x2UL)                   /*!< WCEN4 (Bitfield-Mask: 0x01)                           */
#define ADC_SL4CFG_SLEN4_Pos              (0UL)                     /*!< SLEN4 (Bit 0)                                         */
#define ADC_SL4CFG_SLEN4_Msk              (0x1UL)                   /*!< SLEN4 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL5CFG  ========================================================= */
#define ADC_SL5CFG_ADSEL5_Pos             (24UL)                    /*!< ADSEL5 (Bit 24)                                       */
#define ADC_SL5CFG_ADSEL5_Msk             (0x7000000UL)             /*!< ADSEL5 (Bitfield-Mask: 0x07)                          */
#define ADC_SL5CFG_PRMODE5_Pos            (16UL)                    /*!< PRMODE5 (Bit 16)                                      */
#define ADC_SL5CFG_PRMODE5_Msk            (0x30000UL)               /*!< PRMODE5 (Bitfield-Mask: 0x03)                         */
#define ADC_SL5CFG_CHSEL5_Pos             (8UL)                     /*!< CHSEL5 (Bit 8)                                        */
#define ADC_SL5CFG_CHSEL5_Msk             (0xf00UL)                 /*!< CHSEL5 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL5CFG_WCEN5_Pos              (1UL)                     /*!< WCEN5 (Bit 1)                                         */
#define ADC_SL5CFG_WCEN5_Msk              (0x2UL)                   /*!< WCEN5 (Bitfield-Mask: 0x01)                           */
#define ADC_SL5CFG_SLEN5_Pos              (0UL)                     /*!< SLEN5 (Bit 0)                                         */
#define ADC_SL5CFG_SLEN5_Msk              (0x1UL)                   /*!< SLEN5 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL6CFG  ========================================================= */
#define ADC_SL6CFG_ADSEL6_Pos             (24UL)                    /*!< ADSEL6 (Bit 24)                                       */
#define ADC_SL6CFG_ADSEL6_Msk             (0x7000000UL)             /*!< ADSEL6 (Bitfield-Mask: 0x07)                          */
#define ADC_SL6CFG_PRMODE6_Pos            (16UL)                    /*!< PRMODE6 (Bit 16)                                      */
#define ADC_SL6CFG_PRMODE6_Msk            (0x30000UL)               /*!< PRMODE6 (Bitfield-Mask: 0x03)                         */
#define ADC_SL6CFG_CHSEL6_Pos             (8UL)                     /*!< CHSEL6 (Bit 8)                                        */
#define ADC_SL6CFG_CHSEL6_Msk             (0xf00UL)                 /*!< CHSEL6 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL6CFG_WCEN6_Pos              (1UL)                     /*!< WCEN6 (Bit 1)                                         */
#define ADC_SL6CFG_WCEN6_Msk              (0x2UL)                   /*!< WCEN6 (Bitfield-Mask: 0x01)                           */
#define ADC_SL6CFG_SLEN6_Pos              (0UL)                     /*!< SLEN6 (Bit 0)                                         */
#define ADC_SL6CFG_SLEN6_Msk              (0x1UL)                   /*!< SLEN6 (Bitfield-Mask: 0x01)                           */
/* ========================================================  SL7CFG  ========================================================= */
#define ADC_SL7CFG_ADSEL7_Pos             (24UL)                    /*!< ADSEL7 (Bit 24)                                       */
#define ADC_SL7CFG_ADSEL7_Msk             (0x7000000UL)             /*!< ADSEL7 (Bitfield-Mask: 0x07)                          */
#define ADC_SL7CFG_PRMODE7_Pos            (16UL)                    /*!< PRMODE7 (Bit 16)                                      */
#define ADC_SL7CFG_PRMODE7_Msk            (0x30000UL)               /*!< PRMODE7 (Bitfield-Mask: 0x03)                         */
#define ADC_SL7CFG_CHSEL7_Pos             (8UL)                     /*!< CHSEL7 (Bit 8)                                        */
#define ADC_SL7CFG_CHSEL7_Msk             (0xf00UL)                 /*!< CHSEL7 (Bitfield-Mask: 0x0f)                          */
#define ADC_SL7CFG_WCEN7_Pos              (1UL)                     /*!< WCEN7 (Bit 1)                                         */
#define ADC_SL7CFG_WCEN7_Msk              (0x2UL)                   /*!< WCEN7 (Bitfield-Mask: 0x01)                           */
#define ADC_SL7CFG_SLEN7_Pos              (0UL)                     /*!< SLEN7 (Bit 0)                                         */
#define ADC_SL7CFG_SLEN7_Msk              (0x1UL)                   /*!< SLEN7 (Bitfield-Mask: 0x01)                           */
/* =========================================================  WULIM  ========================================================= */
#define ADC_WULIM_ULIM_Pos                (0UL)                     /*!< ULIM (Bit 0)                                          */
#define ADC_WULIM_ULIM_Msk                (0xfffffUL)               /*!< ULIM (Bitfield-Mask: 0xfffff)                         */
/* =========================================================  WLLIM  ========================================================= */
#define ADC_WLLIM_LLIM_Pos                (0UL)                     /*!< LLIM (Bit 0)                                          */
#define ADC_WLLIM_LLIM_Msk                (0xfffffUL)               /*!< LLIM (Bitfield-Mask: 0xfffff)                         */
/* ========================================================  SCWLIM  ========================================================= */
#define ADC_SCWLIM_SCWLIMEN_Pos           (0UL)                     /*!< SCWLIMEN (Bit 0)                                      */
#define ADC_SCWLIM_SCWLIMEN_Msk           (0x1UL)                   /*!< SCWLIMEN (Bitfield-Mask: 0x01)                        */
/* =========================================================  FIFO  ========================================================== */
#define ADC_FIFO_RSVD_Pos                 (31UL)                    /*!< RSVD (Bit 31)                                         */
#define ADC_FIFO_RSVD_Msk                 (0x80000000UL)            /*!< RSVD (Bitfield-Mask: 0x01)                            */
#define ADC_FIFO_SLOTNUM_Pos              (28UL)                    /*!< SLOTNUM (Bit 28)                                      */
#define ADC_FIFO_SLOTNUM_Msk              (0x70000000UL)            /*!< SLOTNUM (Bitfield-Mask: 0x07)                         */
#define ADC_FIFO_COUNT_Pos                (20UL)                    /*!< COUNT (Bit 20)                                        */
#define ADC_FIFO_COUNT_Msk                (0xff00000UL)             /*!< COUNT (Bitfield-Mask: 0xff)                           */
#define ADC_FIFO_DATA_Pos                 (0UL)                     /*!< DATA (Bit 0)                                          */
#define ADC_FIFO_DATA_Msk                 (0xfffffUL)               /*!< DATA (Bitfield-Mask: 0xfffff)                         */
/* ========================================================  FIFOPR  ========================================================= */
#define ADC_FIFOPR_RSVDPR_Pos             (31UL)                    /*!< RSVDPR (Bit 31)                                       */
#define ADC_FIFOPR_RSVDPR_Msk             (0x80000000UL)            /*!< RSVDPR (Bitfield-Mask: 0x01)                          */
#define ADC_FIFOPR_SLOTNUMPR_Pos          (28UL)                    /*!< SLOTNUMPR (Bit 28)                                    */
#define ADC_FIFOPR_SLOTNUMPR_Msk          (0x70000000UL)            /*!< SLOTNUMPR (Bitfield-Mask: 0x07)                       */
#define ADC_FIFOPR_COUNT_Pos              (20UL)                    /*!< COUNT (Bit 20)                                        */
#define ADC_FIFOPR_COUNT_Msk              (0xff00000UL)             /*!< COUNT (Bitfield-Mask: 0xff)                           */
#define ADC_FIFOPR_DATA_Pos               (0UL)                     /*!< DATA (Bit 0)                                          */
#define ADC_FIFOPR_DATA_Msk               (0xfffffUL)               /*!< DATA (Bitfield-Mask: 0xfffff)                         */
/* =========================================================  INTEN  ========================================================= */
#define ADC_INTEN_DERR_Pos                (7UL)                     /*!< DERR (Bit 7)                                          */
#define ADC_INTEN_DERR_Msk                (0x80UL)                  /*!< DERR (Bitfield-Mask: 0x01)                            */
#define ADC_INTEN_DCMP_Pos                (6UL)                     /*!< DCMP (Bit 6)                                          */
#define ADC_INTEN_DCMP_Msk                (0x40UL)                  /*!< DCMP (Bitfield-Mask: 0x01)                            */
#define ADC_INTEN_WCINC_Pos               (5UL)                     /*!< WCINC (Bit 5)                                         */
#define ADC_INTEN_WCINC_Msk               (0x20UL)                  /*!< WCINC (Bitfield-Mask: 0x01)                           */
#define ADC_INTEN_WCEXC_Pos               (4UL)                     /*!< WCEXC (Bit 4)                                         */
#define ADC_INTEN_WCEXC_Msk               (0x10UL)                  /*!< WCEXC (Bitfield-Mask: 0x01)                           */
#define ADC_INTEN_FIFOOVR2_Pos            (3UL)                     /*!< FIFOOVR2 (Bit 3)                                      */
#define ADC_INTEN_FIFOOVR2_Msk            (0x8UL)                   /*!< FIFOOVR2 (Bitfield-Mask: 0x01)                        */
#define ADC_INTEN_FIFOOVR1_Pos            (2UL)                     /*!< FIFOOVR1 (Bit 2)                                      */
#define ADC_INTEN_FIFOOVR1_Msk            (0x4UL)                   /*!< FIFOOVR1 (Bitfield-Mask: 0x01)                        */
#define ADC_INTEN_SCNCMP_Pos              (1UL)                     /*!< SCNCMP (Bit 1)                                        */
#define ADC_INTEN_SCNCMP_Msk              (0x2UL)                   /*!< SCNCMP (Bitfield-Mask: 0x01)                          */
#define ADC_INTEN_CNVCMP_Pos              (0UL)                     /*!< CNVCMP (Bit 0)                                        */
#define ADC_INTEN_CNVCMP_Msk              (0x1UL)                   /*!< CNVCMP (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTSTAT  ======================================================== */
#define ADC_INTSTAT_DERR_Pos              (7UL)                     /*!< DERR (Bit 7)                                          */
#define ADC_INTSTAT_DERR_Msk              (0x80UL)                  /*!< DERR (Bitfield-Mask: 0x01)                            */
#define ADC_INTSTAT_DCMP_Pos              (6UL)                     /*!< DCMP (Bit 6)                                          */
#define ADC_INTSTAT_DCMP_Msk              (0x40UL)                  /*!< DCMP (Bitfield-Mask: 0x01)                            */
#define ADC_INTSTAT_WCINC_Pos             (5UL)                     /*!< WCINC (Bit 5)                                         */
#define ADC_INTSTAT_WCINC_Msk             (0x20UL)                  /*!< WCINC (Bitfield-Mask: 0x01)                           */
#define ADC_INTSTAT_WCEXC_Pos             (4UL)                     /*!< WCEXC (Bit 4)                                         */
#define ADC_INTSTAT_WCEXC_Msk             (0x10UL)                  /*!< WCEXC (Bitfield-Mask: 0x01)                           */
#define ADC_INTSTAT_FIFOOVR2_Pos          (3UL)                     /*!< FIFOOVR2 (Bit 3)                                      */
#define ADC_INTSTAT_FIFOOVR2_Msk          (0x8UL)                   /*!< FIFOOVR2 (Bitfield-Mask: 0x01)                        */
#define ADC_INTSTAT_FIFOOVR1_Pos          (2UL)                     /*!< FIFOOVR1 (Bit 2)                                      */
#define ADC_INTSTAT_FIFOOVR1_Msk          (0x4UL)                   /*!< FIFOOVR1 (Bitfield-Mask: 0x01)                        */
#define ADC_INTSTAT_SCNCMP_Pos            (1UL)                     /*!< SCNCMP (Bit 1)                                        */
#define ADC_INTSTAT_SCNCMP_Msk            (0x2UL)                   /*!< SCNCMP (Bitfield-Mask: 0x01)                          */
#define ADC_INTSTAT_CNVCMP_Pos            (0UL)                     /*!< CNVCMP (Bit 0)                                        */
#define ADC_INTSTAT_CNVCMP_Msk            (0x1UL)                   /*!< CNVCMP (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTCLR  ========================================================= */
#define ADC_INTCLR_DERR_Pos               (7UL)                     /*!< DERR (Bit 7)                                          */
#define ADC_INTCLR_DERR_Msk               (0x80UL)                  /*!< DERR (Bitfield-Mask: 0x01)                            */
#define ADC_INTCLR_DCMP_Pos               (6UL)                     /*!< DCMP (Bit 6)                                          */
#define ADC_INTCLR_DCMP_Msk               (0x40UL)                  /*!< DCMP (Bitfield-Mask: 0x01)                            */
#define ADC_INTCLR_WCINC_Pos              (5UL)                     /*!< WCINC (Bit 5)                                         */
#define ADC_INTCLR_WCINC_Msk              (0x20UL)                  /*!< WCINC (Bitfield-Mask: 0x01)                           */
#define ADC_INTCLR_WCEXC_Pos              (4UL)                     /*!< WCEXC (Bit 4)                                         */
#define ADC_INTCLR_WCEXC_Msk              (0x10UL)                  /*!< WCEXC (Bitfield-Mask: 0x01)                           */
#define ADC_INTCLR_FIFOOVR2_Pos           (3UL)                     /*!< FIFOOVR2 (Bit 3)                                      */
#define ADC_INTCLR_FIFOOVR2_Msk           (0x8UL)                   /*!< FIFOOVR2 (Bitfield-Mask: 0x01)                        */
#define ADC_INTCLR_FIFOOVR1_Pos           (2UL)                     /*!< FIFOOVR1 (Bit 2)                                      */
#define ADC_INTCLR_FIFOOVR1_Msk           (0x4UL)                   /*!< FIFOOVR1 (Bitfield-Mask: 0x01)                        */
#define ADC_INTCLR_SCNCMP_Pos             (1UL)                     /*!< SCNCMP (Bit 1)                                        */
#define ADC_INTCLR_SCNCMP_Msk             (0x2UL)                   /*!< SCNCMP (Bitfield-Mask: 0x01)                          */
#define ADC_INTCLR_CNVCMP_Pos             (0UL)                     /*!< CNVCMP (Bit 0)                                        */
#define ADC_INTCLR_CNVCMP_Msk             (0x1UL)                   /*!< CNVCMP (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTSET  ========================================================= */
#define ADC_INTSET_DERR_Pos               (7UL)                     /*!< DERR (Bit 7)                                          */
#define ADC_INTSET_DERR_Msk               (0x80UL)                  /*!< DERR (Bitfield-Mask: 0x01)                            */
#define ADC_INTSET_DCMP_Pos               (6UL)                     /*!< DCMP (Bit 6)                                          */
#define ADC_INTSET_DCMP_Msk               (0x40UL)                  /*!< DCMP (Bitfield-Mask: 0x01)                            */
#define ADC_INTSET_WCINC_Pos              (5UL)                     /*!< WCINC (Bit 5)                                         */
#define ADC_INTSET_WCINC_Msk              (0x20UL)                  /*!< WCINC (Bitfield-Mask: 0x01)                           */
#define ADC_INTSET_WCEXC_Pos              (4UL)                     /*!< WCEXC (Bit 4)                                         */
#define ADC_INTSET_WCEXC_Msk              (0x10UL)                  /*!< WCEXC (Bitfield-Mask: 0x01)                           */
#define ADC_INTSET_FIFOOVR2_Pos           (3UL)                     /*!< FIFOOVR2 (Bit 3)                                      */
#define ADC_INTSET_FIFOOVR2_Msk           (0x8UL)                   /*!< FIFOOVR2 (Bitfield-Mask: 0x01)                        */
#define ADC_INTSET_FIFOOVR1_Pos           (2UL)                     /*!< FIFOOVR1 (Bit 2)                                      */
#define ADC_INTSET_FIFOOVR1_Msk           (0x4UL)                   /*!< FIFOOVR1 (Bitfield-Mask: 0x01)                        */
#define ADC_INTSET_SCNCMP_Pos             (1UL)                     /*!< SCNCMP (Bit 1)                                        */
#define ADC_INTSET_SCNCMP_Msk             (0x2UL)                   /*!< SCNCMP (Bitfield-Mask: 0x01)                          */
#define ADC_INTSET_CNVCMP_Pos             (0UL)                     /*!< CNVCMP (Bit 0)                                        */
#define ADC_INTSET_CNVCMP_Msk             (0x1UL)                   /*!< CNVCMP (Bitfield-Mask: 0x01)                          */
/* =======================================================  DMATRIGEN  ======================================================= */
#define ADC_DMATRIGEN_DFIFOFULL_Pos       (1UL)                     /*!< DFIFOFULL (Bit 1)                                     */
#define ADC_DMATRIGEN_DFIFOFULL_Msk       (0x2UL)                   /*!< DFIFOFULL (Bitfield-Mask: 0x01)                       */
#define ADC_DMATRIGEN_DFIFO75_Pos         (0UL)                     /*!< DFIFO75 (Bit 0)                                       */
#define ADC_DMATRIGEN_DFIFO75_Msk         (0x1UL)                   /*!< DFIFO75 (Bitfield-Mask: 0x01)                         */
/* ======================================================  DMATRIGSTAT  ====================================================== */
#define ADC_DMATRIGSTAT_DFULLSTAT_Pos     (1UL)                     /*!< DFULLSTAT (Bit 1)                                     */
#define ADC_DMATRIGSTAT_DFULLSTAT_Msk     (0x2UL)                   /*!< DFULLSTAT (Bitfield-Mask: 0x01)                       */
#define ADC_DMATRIGSTAT_D75STAT_Pos       (0UL)                     /*!< D75STAT (Bit 0)                                       */
#define ADC_DMATRIGSTAT_D75STAT_Msk       (0x1UL)                   /*!< D75STAT (Bitfield-Mask: 0x01)                         */
/* ========================================================  DMACFG  ========================================================= */
#define ADC_DMACFG_DPWROFF_Pos            (18UL)                    /*!< DPWROFF (Bit 18)                                      */
#define ADC_DMACFG_DPWROFF_Msk            (0x40000UL)               /*!< DPWROFF (Bitfield-Mask: 0x01)                         */
#define ADC_DMACFG_DMAMSK_Pos             (17UL)                    /*!< DMAMSK (Bit 17)                                       */
#define ADC_DMACFG_DMAMSK_Msk             (0x20000UL)               /*!< DMAMSK (Bitfield-Mask: 0x01)                          */
#define ADC_DMACFG_DMAHONSTAT_Pos         (16UL)                    /*!< DMAHONSTAT (Bit 16)                                   */
#define ADC_DMACFG_DMAHONSTAT_Msk         (0x10000UL)               /*!< DMAHONSTAT (Bitfield-Mask: 0x01)                      */
#define ADC_DMACFG_DMADYNPRI_Pos          (9UL)                     /*!< DMADYNPRI (Bit 9)                                     */
#define ADC_DMACFG_DMADYNPRI_Msk          (0x200UL)                 /*!< DMADYNPRI (Bitfield-Mask: 0x01)                       */
#define ADC_DMACFG_DMAPRI_Pos             (8UL)                     /*!< DMAPRI (Bit 8)                                        */
#define ADC_DMACFG_DMAPRI_Msk             (0x100UL)                 /*!< DMAPRI (Bitfield-Mask: 0x01)                          */
#define ADC_DMACFG_DMADIR_Pos             (2UL)                     /*!< DMADIR (Bit 2)                                        */
#define ADC_DMACFG_DMADIR_Msk             (0x4UL)                   /*!< DMADIR (Bitfield-Mask: 0x01)                          */
#define ADC_DMACFG_DMAEN_Pos              (0UL)                     /*!< DMAEN (Bit 0)                                         */
#define ADC_DMACFG_DMAEN_Msk              (0x1UL)                   /*!< DMAEN (Bitfield-Mask: 0x01)                           */
/* ======================================================  DMATOTCOUNT  ====================================================== */
#define ADC_DMATOTCOUNT_TOTCOUNT_Pos      (2UL)                     /*!< TOTCOUNT (Bit 2)                                      */
#define ADC_DMATOTCOUNT_TOTCOUNT_Msk      (0x3fffcUL)               /*!< TOTCOUNT (Bitfield-Mask: 0xffff)                      */
/* ======================================================  DMATARGADDR  ====================================================== */
#define ADC_DMATARGADDR_UTARGADDR_Pos     (19UL)                    /*!< UTARGADDR (Bit 19)                                    */
#define ADC_DMATARGADDR_UTARGADDR_Msk     (0xfff80000UL)            /*!< UTARGADDR (Bitfield-Mask: 0x1fff)                     */
#define ADC_DMATARGADDR_LTARGADDR_Pos     (0UL)                     /*!< LTARGADDR (Bit 0)                                     */
#define ADC_DMATARGADDR_LTARGADDR_Msk     (0x7ffffUL)               /*!< LTARGADDR (Bitfield-Mask: 0x7ffff)                    */
/* ========================================================  DMASTAT  ======================================================== */
#define ADC_DMASTAT_DMAERR_Pos            (2UL)                     /*!< DMAERR (Bit 2)                                        */
#define ADC_DMASTAT_DMAERR_Msk            (0x4UL)                   /*!< DMAERR (Bitfield-Mask: 0x01)                          */
#define ADC_DMASTAT_DMACPL_Pos            (1UL)                     /*!< DMACPL (Bit 1)                                        */
#define ADC_DMASTAT_DMACPL_Msk            (0x2UL)                   /*!< DMACPL (Bitfield-Mask: 0x01)                          */
#define ADC_DMASTAT_DMATIP_Pos            (0UL)                     /*!< DMATIP (Bit 0)                                        */
#define ADC_DMASTAT_DMATIP_Msk            (0x1UL)                   /*!< DMATIP (Bitfield-Mask: 0x01)                          */


/* =========================================================================================================================== */
/* ================                                          APBDMA                                           ================ */
/* =========================================================================================================================== */

/* ========================================================  BBVALUE  ======================================================== */
#define APBDMA_BBVALUE_PIN_Pos            (16UL)                    /*!< PIN (Bit 16)                                          */
#define APBDMA_BBVALUE_PIN_Msk            (0xff0000UL)              /*!< PIN (Bitfield-Mask: 0xff)                             */
#define APBDMA_BBVALUE_DATAOUT_Pos        (0UL)                     /*!< DATAOUT (Bit 0)                                       */
#define APBDMA_BBVALUE_DATAOUT_Msk        (0xffUL)                  /*!< DATAOUT (Bitfield-Mask: 0xff)                         */
/* ======================================================  BBSETCLEAR  ======================================================= */
#define APBDMA_BBSETCLEAR_CLEAR_Pos       (16UL)                    /*!< CLEAR (Bit 16)                                        */
#define APBDMA_BBSETCLEAR_CLEAR_Msk       (0xff0000UL)              /*!< CLEAR (Bitfield-Mask: 0xff)                           */
#define APBDMA_BBSETCLEAR_SET_Pos         (0UL)                     /*!< SET (Bit 0)                                           */
#define APBDMA_BBSETCLEAR_SET_Msk         (0xffUL)                  /*!< SET (Bitfield-Mask: 0xff)                             */
/* ========================================================  BBINPUT  ======================================================== */
#define APBDMA_BBINPUT_DATAIN_Pos         (0UL)                     /*!< DATAIN (Bit 0)                                        */
#define APBDMA_BBINPUT_DATAIN_Msk         (0xffUL)                  /*!< DATAIN (Bitfield-Mask: 0xff)                          */
/* =======================================================  DEBUGDATA  ======================================================= */
#define APBDMA_DEBUGDATA_DEBUGDATA_Pos    (0UL)                     /*!< DEBUGDATA (Bit 0)                                     */
#define APBDMA_DEBUGDATA_DEBUGDATA_Msk    (0xffffffffUL)            /*!< DEBUGDATA (Bitfield-Mask: 0xffffffff)                 */
/* =========================================================  DEBUG  ========================================================= */
#define APBDMA_DEBUG_DEBUGEN_Pos          (0UL)                     /*!< DEBUGEN (Bit 0)                                       */
#define APBDMA_DEBUG_DEBUGEN_Msk          (0xfUL)                   /*!< DEBUGEN (Bitfield-Mask: 0x0f)                         */


/* =========================================================================================================================== */
/* ================                                           BLEIF                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  FIFO  ========================================================== */
#define BLEIF_FIFO_FIFO_Pos               (0UL)                     /*!< FIFO (Bit 0)                                          */
#define BLEIF_FIFO_FIFO_Msk               (0xffffffffUL)            /*!< FIFO (Bitfield-Mask: 0xffffffff)                      */
/* ========================================================  FIFOPTR  ======================================================== */
#define BLEIF_FIFOPTR_FIFO1REM_Pos        (24UL)                    /*!< FIFO1REM (Bit 24)                                     */
#define BLEIF_FIFOPTR_FIFO1REM_Msk        (0xff000000UL)            /*!< FIFO1REM (Bitfield-Mask: 0xff)                        */
#define BLEIF_FIFOPTR_FIFO1SIZ_Pos        (16UL)                    /*!< FIFO1SIZ (Bit 16)                                     */
#define BLEIF_FIFOPTR_FIFO1SIZ_Msk        (0xff0000UL)              /*!< FIFO1SIZ (Bitfield-Mask: 0xff)                        */
#define BLEIF_FIFOPTR_FIFO0REM_Pos        (8UL)                     /*!< FIFO0REM (Bit 8)                                      */
#define BLEIF_FIFOPTR_FIFO0REM_Msk        (0xff00UL)                /*!< FIFO0REM (Bitfield-Mask: 0xff)                        */
#define BLEIF_FIFOPTR_FIFO0SIZ_Pos        (0UL)                     /*!< FIFO0SIZ (Bit 0)                                      */
#define BLEIF_FIFOPTR_FIFO0SIZ_Msk        (0xffUL)                  /*!< FIFO0SIZ (Bitfield-Mask: 0xff)                        */
/* ========================================================  FIFOTHR  ======================================================== */
#define BLEIF_FIFOTHR_FIFOWTHR_Pos        (8UL)                     /*!< FIFOWTHR (Bit 8)                                      */
#define BLEIF_FIFOTHR_FIFOWTHR_Msk        (0x3f00UL)                /*!< FIFOWTHR (Bitfield-Mask: 0x3f)                        */
#define BLEIF_FIFOTHR_FIFORTHR_Pos        (0UL)                     /*!< FIFORTHR (Bit 0)                                      */
#define BLEIF_FIFOTHR_FIFORTHR_Msk        (0x3fUL)                  /*!< FIFORTHR (Bitfield-Mask: 0x3f)                        */
/* ========================================================  FIFOPOP  ======================================================== */
#define BLEIF_FIFOPOP_FIFODOUT_Pos        (0UL)                     /*!< FIFODOUT (Bit 0)                                      */
#define BLEIF_FIFOPOP_FIFODOUT_Msk        (0xffffffffUL)            /*!< FIFODOUT (Bitfield-Mask: 0xffffffff)                  */
/* =======================================================  FIFOPUSH  ======================================================== */
#define BLEIF_FIFOPUSH_FIFODIN_Pos        (0UL)                     /*!< FIFODIN (Bit 0)                                       */
#define BLEIF_FIFOPUSH_FIFODIN_Msk        (0xffffffffUL)            /*!< FIFODIN (Bitfield-Mask: 0xffffffff)                   */
/* =======================================================  FIFOCTRL  ======================================================== */
#define BLEIF_FIFOCTRL_FIFORSTN_Pos       (1UL)                     /*!< FIFORSTN (Bit 1)                                      */
#define BLEIF_FIFOCTRL_FIFORSTN_Msk       (0x2UL)                   /*!< FIFORSTN (Bitfield-Mask: 0x01)                        */
#define BLEIF_FIFOCTRL_POPWR_Pos          (0UL)                     /*!< POPWR (Bit 0)                                         */
#define BLEIF_FIFOCTRL_POPWR_Msk          (0x1UL)                   /*!< POPWR (Bitfield-Mask: 0x01)                           */
/* ========================================================  FIFOLOC  ======================================================== */
#define BLEIF_FIFOLOC_FIFORPTR_Pos        (8UL)                     /*!< FIFORPTR (Bit 8)                                      */
#define BLEIF_FIFOLOC_FIFORPTR_Msk        (0xf00UL)                 /*!< FIFORPTR (Bitfield-Mask: 0x0f)                        */
#define BLEIF_FIFOLOC_FIFOWPTR_Pos        (0UL)                     /*!< FIFOWPTR (Bit 0)                                      */
#define BLEIF_FIFOLOC_FIFOWPTR_Msk        (0xfUL)                   /*!< FIFOWPTR (Bitfield-Mask: 0x0f)                        */
/* ========================================================  CLKCFG  ========================================================= */
#define BLEIF_CLKCFG_DIV3_Pos             (12UL)                    /*!< DIV3 (Bit 12)                                         */
#define BLEIF_CLKCFG_DIV3_Msk             (0x1000UL)                /*!< DIV3 (Bitfield-Mask: 0x01)                            */
#define BLEIF_CLKCFG_CLK32KEN_Pos         (11UL)                    /*!< CLK32KEN (Bit 11)                                     */
#define BLEIF_CLKCFG_CLK32KEN_Msk         (0x800UL)                 /*!< CLK32KEN (Bitfield-Mask: 0x01)                        */
#define BLEIF_CLKCFG_FSEL_Pos             (8UL)                     /*!< FSEL (Bit 8)                                          */
#define BLEIF_CLKCFG_FSEL_Msk             (0x700UL)                 /*!< FSEL (Bitfield-Mask: 0x07)                            */
#define BLEIF_CLKCFG_IOCLKEN_Pos          (0UL)                     /*!< IOCLKEN (Bit 0)                                       */
#define BLEIF_CLKCFG_IOCLKEN_Msk          (0x1UL)                   /*!< IOCLKEN (Bitfield-Mask: 0x01)                         */
/* ==========================================================  CMD  ========================================================== */
#define BLEIF_CMD_OFFSETLO_Pos            (24UL)                    /*!< OFFSETLO (Bit 24)                                     */
#define BLEIF_CMD_OFFSETLO_Msk            (0xff000000UL)            /*!< OFFSETLO (Bitfield-Mask: 0xff)                        */
#define BLEIF_CMD_CMDSEL_Pos              (20UL)                    /*!< CMDSEL (Bit 20)                                       */
#define BLEIF_CMD_CMDSEL_Msk              (0x300000UL)              /*!< CMDSEL (Bitfield-Mask: 0x03)                          */
#define BLEIF_CMD_TSIZE_Pos               (8UL)                     /*!< TSIZE (Bit 8)                                         */
#define BLEIF_CMD_TSIZE_Msk               (0xfff00UL)               /*!< TSIZE (Bitfield-Mask: 0xfff)                          */
#define BLEIF_CMD_CONT_Pos                (7UL)                     /*!< CONT (Bit 7)                                          */
#define BLEIF_CMD_CONT_Msk                (0x80UL)                  /*!< CONT (Bitfield-Mask: 0x01)                            */
#define BLEIF_CMD_OFFSETCNT_Pos           (5UL)                     /*!< OFFSETCNT (Bit 5)                                     */
#define BLEIF_CMD_OFFSETCNT_Msk           (0x60UL)                  /*!< OFFSETCNT (Bitfield-Mask: 0x03)                       */
#define BLEIF_CMD_CMD_Pos                 (0UL)                     /*!< CMD (Bit 0)                                           */
#define BLEIF_CMD_CMD_Msk                 (0x1fUL)                  /*!< CMD (Bitfield-Mask: 0x1f)                             */
/* ========================================================  CMDRPT  ========================================================= */
#define BLEIF_CMDRPT_CMDRPT_Pos           (0UL)                     /*!< CMDRPT (Bit 0)                                        */
#define BLEIF_CMDRPT_CMDRPT_Msk           (0x1fUL)                  /*!< CMDRPT (Bitfield-Mask: 0x1f)                          */
/* =======================================================  OFFSETHI  ======================================================== */
#define BLEIF_OFFSETHI_OFFSETHI_Pos       (0UL)                     /*!< OFFSETHI (Bit 0)                                      */
#define BLEIF_OFFSETHI_OFFSETHI_Msk       (0xffffUL)                /*!< OFFSETHI (Bitfield-Mask: 0xffff)                      */
/* ========================================================  CMDSTAT  ======================================================== */
#define BLEIF_CMDSTAT_CTSIZE_Pos          (8UL)                     /*!< CTSIZE (Bit 8)                                        */
#define BLEIF_CMDSTAT_CTSIZE_Msk          (0xfff00UL)               /*!< CTSIZE (Bitfield-Mask: 0xfff)                         */
#define BLEIF_CMDSTAT_CMDSTAT_Pos         (5UL)                     /*!< CMDSTAT (Bit 5)                                       */
#define BLEIF_CMDSTAT_CMDSTAT_Msk         (0xe0UL)                  /*!< CMDSTAT (Bitfield-Mask: 0x07)                         */
#define BLEIF_CMDSTAT_CCMD_Pos            (0UL)                     /*!< CCMD (Bit 0)                                          */
#define BLEIF_CMDSTAT_CCMD_Msk            (0x1fUL)                  /*!< CCMD (Bitfield-Mask: 0x1f)                            */
/* =========================================================  INTEN  ========================================================= */
#define BLEIF_INTEN_B2MSHUTDN_Pos         (16UL)                    /*!< B2MSHUTDN (Bit 16)                                    */
#define BLEIF_INTEN_B2MSHUTDN_Msk         (0x10000UL)               /*!< B2MSHUTDN (Bitfield-Mask: 0x01)                       */
#define BLEIF_INTEN_B2MACTIVE_Pos         (15UL)                    /*!< B2MACTIVE (Bit 15)                                    */
#define BLEIF_INTEN_B2MACTIVE_Msk         (0x8000UL)                /*!< B2MACTIVE (Bitfield-Mask: 0x01)                       */
#define BLEIF_INTEN_B2MSLEEP_Pos          (14UL)                    /*!< B2MSLEEP (Bit 14)                                     */
#define BLEIF_INTEN_B2MSLEEP_Msk          (0x4000UL)                /*!< B2MSLEEP (Bitfield-Mask: 0x01)                        */
#define BLEIF_INTEN_CQERR_Pos             (13UL)                    /*!< CQERR (Bit 13)                                        */
#define BLEIF_INTEN_CQERR_Msk             (0x2000UL)                /*!< CQERR (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTEN_CQUPD_Pos             (12UL)                    /*!< CQUPD (Bit 12)                                        */
#define BLEIF_INTEN_CQUPD_Msk             (0x1000UL)                /*!< CQUPD (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTEN_CQPAUSED_Pos          (11UL)                    /*!< CQPAUSED (Bit 11)                                     */
#define BLEIF_INTEN_CQPAUSED_Msk          (0x800UL)                 /*!< CQPAUSED (Bitfield-Mask: 0x01)                        */
#define BLEIF_INTEN_DERR_Pos              (10UL)                    /*!< DERR (Bit 10)                                         */
#define BLEIF_INTEN_DERR_Msk              (0x400UL)                 /*!< DERR (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTEN_DCMP_Pos              (9UL)                     /*!< DCMP (Bit 9)                                          */
#define BLEIF_INTEN_DCMP_Msk              (0x200UL)                 /*!< DCMP (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTEN_BLECSSTAT_Pos         (8UL)                     /*!< BLECSSTAT (Bit 8)                                     */
#define BLEIF_INTEN_BLECSSTAT_Msk         (0x100UL)                 /*!< BLECSSTAT (Bitfield-Mask: 0x01)                       */
#define BLEIF_INTEN_BLECIRQ_Pos           (7UL)                     /*!< BLECIRQ (Bit 7)                                       */
#define BLEIF_INTEN_BLECIRQ_Msk           (0x80UL)                  /*!< BLECIRQ (Bitfield-Mask: 0x01)                         */
#define BLEIF_INTEN_ICMD_Pos              (6UL)                     /*!< ICMD (Bit 6)                                          */
#define BLEIF_INTEN_ICMD_Msk              (0x40UL)                  /*!< ICMD (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTEN_IACC_Pos              (5UL)                     /*!< IACC (Bit 5)                                          */
#define BLEIF_INTEN_IACC_Msk              (0x20UL)                  /*!< IACC (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTEN_B2MST_Pos             (4UL)                     /*!< B2MST (Bit 4)                                         */
#define BLEIF_INTEN_B2MST_Msk             (0x10UL)                  /*!< B2MST (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTEN_FOVFL_Pos             (3UL)                     /*!< FOVFL (Bit 3)                                         */
#define BLEIF_INTEN_FOVFL_Msk             (0x8UL)                   /*!< FOVFL (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTEN_FUNDFL_Pos            (2UL)                     /*!< FUNDFL (Bit 2)                                        */
#define BLEIF_INTEN_FUNDFL_Msk            (0x4UL)                   /*!< FUNDFL (Bitfield-Mask: 0x01)                          */
#define BLEIF_INTEN_THR_Pos               (1UL)                     /*!< THR (Bit 1)                                           */
#define BLEIF_INTEN_THR_Msk               (0x2UL)                   /*!< THR (Bitfield-Mask: 0x01)                             */
#define BLEIF_INTEN_CMDCMP_Pos            (0UL)                     /*!< CMDCMP (Bit 0)                                        */
#define BLEIF_INTEN_CMDCMP_Msk            (0x1UL)                   /*!< CMDCMP (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTSTAT  ======================================================== */
#define BLEIF_INTSTAT_B2MSHUTDN_Pos       (16UL)                    /*!< B2MSHUTDN (Bit 16)                                    */
#define BLEIF_INTSTAT_B2MSHUTDN_Msk       (0x10000UL)               /*!< B2MSHUTDN (Bitfield-Mask: 0x01)                       */
#define BLEIF_INTSTAT_B2MACTIVE_Pos       (15UL)                    /*!< B2MACTIVE (Bit 15)                                    */
#define BLEIF_INTSTAT_B2MACTIVE_Msk       (0x8000UL)                /*!< B2MACTIVE (Bitfield-Mask: 0x01)                       */
#define BLEIF_INTSTAT_B2MSLEEP_Pos        (14UL)                    /*!< B2MSLEEP (Bit 14)                                     */
#define BLEIF_INTSTAT_B2MSLEEP_Msk        (0x4000UL)                /*!< B2MSLEEP (Bitfield-Mask: 0x01)                        */
#define BLEIF_INTSTAT_CQERR_Pos           (13UL)                    /*!< CQERR (Bit 13)                                        */
#define BLEIF_INTSTAT_CQERR_Msk           (0x2000UL)                /*!< CQERR (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTSTAT_CQUPD_Pos           (12UL)                    /*!< CQUPD (Bit 12)                                        */
#define BLEIF_INTSTAT_CQUPD_Msk           (0x1000UL)                /*!< CQUPD (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTSTAT_CQPAUSED_Pos        (11UL)                    /*!< CQPAUSED (Bit 11)                                     */
#define BLEIF_INTSTAT_CQPAUSED_Msk        (0x800UL)                 /*!< CQPAUSED (Bitfield-Mask: 0x01)                        */
#define BLEIF_INTSTAT_DERR_Pos            (10UL)                    /*!< DERR (Bit 10)                                         */
#define BLEIF_INTSTAT_DERR_Msk            (0x400UL)                 /*!< DERR (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTSTAT_DCMP_Pos            (9UL)                     /*!< DCMP (Bit 9)                                          */
#define BLEIF_INTSTAT_DCMP_Msk            (0x200UL)                 /*!< DCMP (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTSTAT_BLECSSTAT_Pos       (8UL)                     /*!< BLECSSTAT (Bit 8)                                     */
#define BLEIF_INTSTAT_BLECSSTAT_Msk       (0x100UL)                 /*!< BLECSSTAT (Bitfield-Mask: 0x01)                       */
#define BLEIF_INTSTAT_BLECIRQ_Pos         (7UL)                     /*!< BLECIRQ (Bit 7)                                       */
#define BLEIF_INTSTAT_BLECIRQ_Msk         (0x80UL)                  /*!< BLECIRQ (Bitfield-Mask: 0x01)                         */
#define BLEIF_INTSTAT_ICMD_Pos            (6UL)                     /*!< ICMD (Bit 6)                                          */
#define BLEIF_INTSTAT_ICMD_Msk            (0x40UL)                  /*!< ICMD (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTSTAT_IACC_Pos            (5UL)                     /*!< IACC (Bit 5)                                          */
#define BLEIF_INTSTAT_IACC_Msk            (0x20UL)                  /*!< IACC (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTSTAT_B2MST_Pos           (4UL)                     /*!< B2MST (Bit 4)                                         */
#define BLEIF_INTSTAT_B2MST_Msk           (0x10UL)                  /*!< B2MST (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTSTAT_FOVFL_Pos           (3UL)                     /*!< FOVFL (Bit 3)                                         */
#define BLEIF_INTSTAT_FOVFL_Msk           (0x8UL)                   /*!< FOVFL (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTSTAT_FUNDFL_Pos          (2UL)                     /*!< FUNDFL (Bit 2)                                        */
#define BLEIF_INTSTAT_FUNDFL_Msk          (0x4UL)                   /*!< FUNDFL (Bitfield-Mask: 0x01)                          */
#define BLEIF_INTSTAT_THR_Pos             (1UL)                     /*!< THR (Bit 1)                                           */
#define BLEIF_INTSTAT_THR_Msk             (0x2UL)                   /*!< THR (Bitfield-Mask: 0x01)                             */
#define BLEIF_INTSTAT_CMDCMP_Pos          (0UL)                     /*!< CMDCMP (Bit 0)                                        */
#define BLEIF_INTSTAT_CMDCMP_Msk          (0x1UL)                   /*!< CMDCMP (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTCLR  ========================================================= */
#define BLEIF_INTCLR_B2MSHUTDN_Pos        (16UL)                    /*!< B2MSHUTDN (Bit 16)                                    */
#define BLEIF_INTCLR_B2MSHUTDN_Msk        (0x10000UL)               /*!< B2MSHUTDN (Bitfield-Mask: 0x01)                       */
#define BLEIF_INTCLR_B2MACTIVE_Pos        (15UL)                    /*!< B2MACTIVE (Bit 15)                                    */
#define BLEIF_INTCLR_B2MACTIVE_Msk        (0x8000UL)                /*!< B2MACTIVE (Bitfield-Mask: 0x01)                       */
#define BLEIF_INTCLR_B2MSLEEP_Pos         (14UL)                    /*!< B2MSLEEP (Bit 14)                                     */
#define BLEIF_INTCLR_B2MSLEEP_Msk         (0x4000UL)                /*!< B2MSLEEP (Bitfield-Mask: 0x01)                        */
#define BLEIF_INTCLR_CQERR_Pos            (13UL)                    /*!< CQERR (Bit 13)                                        */
#define BLEIF_INTCLR_CQERR_Msk            (0x2000UL)                /*!< CQERR (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTCLR_CQUPD_Pos            (12UL)                    /*!< CQUPD (Bit 12)                                        */
#define BLEIF_INTCLR_CQUPD_Msk            (0x1000UL)                /*!< CQUPD (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTCLR_CQPAUSED_Pos         (11UL)                    /*!< CQPAUSED (Bit 11)                                     */
#define BLEIF_INTCLR_CQPAUSED_Msk         (0x800UL)                 /*!< CQPAUSED (Bitfield-Mask: 0x01)                        */
#define BLEIF_INTCLR_DERR_Pos             (10UL)                    /*!< DERR (Bit 10)                                         */
#define BLEIF_INTCLR_DERR_Msk             (0x400UL)                 /*!< DERR (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTCLR_DCMP_Pos             (9UL)                     /*!< DCMP (Bit 9)                                          */
#define BLEIF_INTCLR_DCMP_Msk             (0x200UL)                 /*!< DCMP (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTCLR_BLECSSTAT_Pos        (8UL)                     /*!< BLECSSTAT (Bit 8)                                     */
#define BLEIF_INTCLR_BLECSSTAT_Msk        (0x100UL)                 /*!< BLECSSTAT (Bitfield-Mask: 0x01)                       */
#define BLEIF_INTCLR_BLECIRQ_Pos          (7UL)                     /*!< BLECIRQ (Bit 7)                                       */
#define BLEIF_INTCLR_BLECIRQ_Msk          (0x80UL)                  /*!< BLECIRQ (Bitfield-Mask: 0x01)                         */
#define BLEIF_INTCLR_ICMD_Pos             (6UL)                     /*!< ICMD (Bit 6)                                          */
#define BLEIF_INTCLR_ICMD_Msk             (0x40UL)                  /*!< ICMD (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTCLR_IACC_Pos             (5UL)                     /*!< IACC (Bit 5)                                          */
#define BLEIF_INTCLR_IACC_Msk             (0x20UL)                  /*!< IACC (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTCLR_B2MST_Pos            (4UL)                     /*!< B2MST (Bit 4)                                         */
#define BLEIF_INTCLR_B2MST_Msk            (0x10UL)                  /*!< B2MST (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTCLR_FOVFL_Pos            (3UL)                     /*!< FOVFL (Bit 3)                                         */
#define BLEIF_INTCLR_FOVFL_Msk            (0x8UL)                   /*!< FOVFL (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTCLR_FUNDFL_Pos           (2UL)                     /*!< FUNDFL (Bit 2)                                        */
#define BLEIF_INTCLR_FUNDFL_Msk           (0x4UL)                   /*!< FUNDFL (Bitfield-Mask: 0x01)                          */
#define BLEIF_INTCLR_THR_Pos              (1UL)                     /*!< THR (Bit 1)                                           */
#define BLEIF_INTCLR_THR_Msk              (0x2UL)                   /*!< THR (Bitfield-Mask: 0x01)                             */
#define BLEIF_INTCLR_CMDCMP_Pos           (0UL)                     /*!< CMDCMP (Bit 0)                                        */
#define BLEIF_INTCLR_CMDCMP_Msk           (0x1UL)                   /*!< CMDCMP (Bitfield-Mask: 0x01)                          */
/* ========================================================  INTSET  ========================================================= */
#define BLEIF_INTSET_B2MSHUTDN_Pos        (16UL)                    /*!< B2MSHUTDN (Bit 16)                                    */
#define BLEIF_INTSET_B2MSHUTDN_Msk        (0x10000UL)               /*!< B2MSHUTDN (Bitfield-Mask: 0x01)                       */
#define BLEIF_INTSET_B2MACTIVE_Pos        (15UL)                    /*!< B2MACTIVE (Bit 15)                                    */
#define BLEIF_INTSET_B2MACTIVE_Msk        (0x8000UL)                /*!< B2MACTIVE (Bitfield-Mask: 0x01)                       */
#define BLEIF_INTSET_B2MSLEEP_Pos         (14UL)                    /*!< B2MSLEEP (Bit 14)                                     */
#define BLEIF_INTSET_B2MSLEEP_Msk         (0x4000UL)                /*!< B2MSLEEP (Bitfield-Mask: 0x01)                        */
#define BLEIF_INTSET_CQERR_Pos            (13UL)                    /*!< CQERR (Bit 13)                                        */
#define BLEIF_INTSET_CQERR_Msk            (0x2000UL)                /*!< CQERR (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTSET_CQUPD_Pos            (12UL)                    /*!< CQUPD (Bit 12)                                        */
#define BLEIF_INTSET_CQUPD_Msk            (0x1000UL)                /*!< CQUPD (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTSET_CQPAUSED_Pos         (11UL)                    /*!< CQPAUSED (Bit 11)                                     */
#define BLEIF_INTSET_CQPAUSED_Msk         (0x800UL)                 /*!< CQPAUSED (Bitfield-Mask: 0x01)                        */
#define BLEIF_INTSET_DERR_Pos             (10UL)                    /*!< DERR (Bit 10)                                         */
#define BLEIF_INTSET_DERR_Msk             (0x400UL)                 /*!< DERR (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTSET_DCMP_Pos             (9UL)                     /*!< DCMP (Bit 9)                                          */
#define BLEIF_INTSET_DCMP_Msk             (0x200UL)                 /*!< DCMP (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTSET_BLECSSTAT_Pos        (8UL)                     /*!< BLECSSTAT (Bit 8)                                     */
#define BLEIF_INTSET_BLECSSTAT_Msk        (0x100UL)                 /*!< BLECSSTAT (Bitfield-Mask: 0x01)                       */
#define BLEIF_INTSET_BLECIRQ_Pos          (7UL)                     /*!< BLECIRQ (Bit 7)                                       */
#define BLEIF_INTSET_BLECIRQ_Msk          (0x80UL)                  /*!< BLECIRQ (Bitfield-Mask: 0x01)                         */
#define BLEIF_INTSET_ICMD_Pos             (6UL)                     /*!< ICMD (Bit 6)                                          */
#define BLEIF_INTSET_ICMD_Msk             (0x40UL)                  /*!< ICMD (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTSET_IACC_Pos             (5UL)                     /*!< IACC (Bit 5)                                          */
#define BLEIF_INTSET_IACC_Msk             (0x20UL)                  /*!< IACC (Bitfield-Mask: 0x01)                            */
#define BLEIF_INTSET_B2MST_Pos            (4UL)                     /*!< B2MST (Bit 4)                                         */
#define BLEIF_INTSET_B2MST_Msk            (0x10UL)                  /*!< B2MST (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTSET_FOVFL_Pos            (3UL)                     /*!< FOVFL (Bit 3)                                         */
#define BLEIF_INTSET_FOVFL_Msk            (0x8UL)                   /*!< FOVFL (Bitfield-Mask: 0x01)                           */
#define BLEIF_INTSET_FUNDFL_Pos           (2UL)                     /*!< FUNDFL (Bit 2)                                        */
#define BLEIF_INTSET_FUNDFL_Msk           (0x4UL)                   /*!< FUNDFL (Bitfield-Mask: 0x01)                          */
#define BLEIF_INTSET_THR_Pos              (1UL)                     /*!< THR (Bit 1)                                           */
#define BLEIF_INTSET_THR_Msk              (0x2UL)                   /*!< THR (Bitfield-Mask: 0x01)                             */
#define BLEIF_INTSET_CMDCMP_Pos           (0UL)                     /*!< CMDCMP (Bit 0)                                        */
#define BLEIF_INTSET_CMDCMP_Msk           (0x1UL)                   /*!< CMDCMP (Bitfield-Mask: 0x01)                          */
/* =======================================================  DMATRIGEN  ======================================================= */
#define BLEIF_DMATRIGEN_DTHREN_Pos        (1UL)                     /*!< DTHREN (Bit 1)                                        */
#define BLEIF_DMATRIGEN_DTHREN_Msk        (0x2UL)                   /*!< DTHREN (Bitfield-Mask: 0x01)                          */
#define BLEIF_DMATRIGEN_DCMDCMPEN_Pos     (0UL)                     /*!< DCMDCMPEN (Bit 0)                                     */
#define BLEIF_DMATRIGEN_DCMDCMPEN_Msk     (0x1UL)                   /*!< DCMDCMPEN (Bitfield-Mask: 0x01)                       */
/* ======================================================  DMATRIGSTAT  ====================================================== */
#define BLEIF_DMATRIGSTAT_DTOTCMP_Pos     (2UL)                     /*!< DTOTCMP (Bit 2)                                       */
#define BLEIF_DMATRIGSTAT_DTOTCMP_Msk     (0x4UL)                   /*!< DTOTCMP (Bitfield-Mask: 0x01)                         */
#define BLEIF_DMATRIGSTAT_DTHR_Pos        (1UL)                     /*!< DTHR (Bit 1)                                          */
#define BLEIF_DMATRIGSTAT_DTHR_Msk        (0x2UL)                   /*!< DTHR (Bitfield-Mask: 0x01)                            */
#define BLEIF_DMATRIGSTAT_DCMDCMP_Pos     (0UL)                     /*!< DCMDCMP (Bit 0)                                       */
#define BLEIF_DMATRIGSTAT_DCMDCMP_Msk     (0x1UL)                   /*!< DCMDCMP (Bitfield-Mask: 0x01)                         */
/* ========================================================  DMACFG  ========================================================= */
#define BLEIF_DMACFG_DPWROFF_Pos          (9UL)                     /*!< DPWROFF (Bit 9)                                       */
#define BLEIF_DMACFG_DPWROFF_Msk          (0x200UL)                 /*!< DPWROFF (Bitfield-Mask: 0x01)                         */
#define BLEIF_DMACFG_DMAPRI_Pos           (8UL)                     /*!< DMAPRI (Bit 8)                                        */
#define BLEIF_DMACFG_DMAPRI_Msk           (0x100UL)                 /*!< DMAPRI (Bitfield-Mask: 0x01)                          */
#define BLEIF_DMACFG_DMADIR_Pos           (1UL)                     /*!< DMADIR (Bit 1)                                        */
#define BLEIF_DMACFG_DMADIR_Msk           (0x2UL)                   /*!< DMADIR (Bitfield-Mask: 0x01)                          */
#define BLEIF_DMACFG_DMAEN_Pos            (0UL)                     /*!< DMAEN (Bit 0)                                         */
#define BLEIF_DMACFG_DMAEN_Msk            (0x1UL)                   /*!< DMAEN (Bitfield-Mask: 0x01)                           */
/* ======================================================  DMATOTCOUNT  ====================================================== */
#define BLEIF_DMATOTCOUNT_TOTCOUNT_Pos    (0UL)                     /*!< TOTCOUNT (Bit 0)                                      */
#define BLEIF_DMATOTCOUNT_TOTCOUNT_Msk    (0xfffUL)                 /*!< TOTCOUNT (Bitfield-Mask: 0xfff)                       */
/* ======================================================  DMATARGADDR  ====================================================== */
#define BLEIF_DMATARGADDR_TARGADDR28_Pos  (28UL)                    /*!< TARGADDR28 (Bit 28)                                   */
#define BLEIF_DMATARGADDR_TARGADDR28_Msk  (0x10000000UL)            /*!< TARGADDR28 (Bitfield-Mask: 0x01)                      */
#define BLEIF_DMATARGADDR_TARGADDR_Pos    (0UL)                     /*!< TARGADDR (Bit 0)                                      */
#define BLEIF_DMATARGADDR_TARGADDR_Msk    (0xfffffUL)               /*!< TARGADDR (Bitfield-Mask: 0xfffff)                     */
/* ========================================================  DMASTAT  ======================================================== */
#define BLEIF_DMASTAT_DMAERR_Pos          (2UL)                     /*!< DMAERR (Bit 2)                                        */
#define BLEIF_DMASTAT_DMAERR_Msk          (0x4UL)                   /*!< DMAERR (Bitfield-Mask: 0x01)                          */
#define BLEIF_DMASTAT_DMACPL_Pos          (1UL)                     /*!< DMACPL (Bit 1)                                        */
#define BLEIF_DMASTAT_DMACPL_Msk          (0x2UL)                   /*!< DMACPL (Bitfield-Mask: 0x01)                          */
#define BLEIF_DMASTAT_DMATIP_Pos          (0UL)                     /*!< DMATIP (Bit 0)                                        */
#define BLEIF_DMASTAT_DMATIP_Msk          (0x1UL)                   /*!< DMATIP (Bitfield-Mask: 0x01)                          */
/* =========================================================  CQCFG  ========================================================= */
#define BLEIF_CQCFG_CQPRI_Pos             (1UL)                     /*!< CQPRI (Bit 1)                                         */
#define BLEIF_CQCFG_CQPRI_Msk             (0x2UL)                   /*!< CQPRI (Bitfield-Mask: 0x01)                           */
#define BLEIF_CQCFG_CQEN_Pos              (0UL)                     /*!< CQEN (Bit 0)                                          */
#define BLEIF_CQCFG_CQEN_Msk              (0x1UL)                   /*!< CQEN (Bitfield-Mask: 0x01)                            */
/* ========================================================  CQADDR  ========================================================= */
#define BLEIF_CQADDR_CQADDR28_Pos         (28UL)                    /*!< CQADDR28 (Bit 28)                                     */
#define BLEIF_CQADDR_CQADDR28_Msk         (0x10000000UL)            /*!< CQADDR28 (Bitfield-Mask: 0x01)                        */
#define BLEIF_CQADDR_CQADDR_Pos           (2UL)                     /*!< CQADDR (Bit 2)                                        */
#define BLEIF_CQADDR_CQADDR_Msk           (0xffffcUL)               /*!< CQADDR (Bitfield-Mask: 0x3ffff)                       */
/* ========================================================  CQSTAT  ========================================================= */
#define BLEIF_CQSTAT_CQERR_Pos            (2UL)                     /*!< CQERR (Bit 2)                                         */
#define BLEIF_CQSTAT_CQERR_Msk            (0x4UL)                   /*!< CQERR (Bitfield-Mask: 0x01)                           */
#define BLEIF_CQSTAT_CQPAUSED_Pos         (1UL)                     /*!< CQPAUSED (Bit 1)                                      */
#define BLEIF_CQSTAT_CQPAUSED_Msk         (0x2UL)                   /*!< CQPAUSED (Bitfield-Mask: 0x01)                        */
#define BLEIF_CQSTAT_CQTIP_Pos            (0UL)                     /*!< CQTIP (Bit 0)                                         */
#define BLEIF_CQSTAT_CQTIP_Msk            (0x1UL)                   /*!< CQTIP (Bitfield-Mask: 0x01)                           */
/* ========================================================  CQFLAGS  ======================================================== */
#define BLEIF_CQFLAGS_CQIRQMASK_Pos       (16UL)                    /*!< CQIRQMASK (Bit 16)                                    */
#define BLEIF_CQFLAGS_CQIRQMASK_Msk       (0xffff0000UL)            /*!< CQIRQMASK (Bitfield-Mask: 0xffff)                     */
#define BLEIF_CQFLAGS_CQFLAGS_Pos         (0UL)                     /*!< CQFLAGS (Bit 0)                                       */
#define BLEIF_CQFLAGS_CQFLAGS_Msk         (0xffffUL)                /*!< CQFLAGS (Bitfield-Mask: 0xffff)                       */
/* ======================================================  CQSETCLEAR  ======================================================= */
#define BLEIF_CQSETCLEAR_CQFCLR_Pos       (16UL)                    /*!< CQFCLR (Bit 16)                                       */
#define BLEIF_CQSETCLEAR_CQFCLR_Msk       (0xff0000UL)              /*!< CQFCLR (Bitfield-Mask: 0xff)                          */
#define BLEIF_CQSETCLEAR_CQFTGL_Pos       (8UL)                     /*!< CQFTGL (Bit 8)                                        */
#define BLEIF_CQSETCLEAR_CQFTGL_Msk       (0xff00UL)                /*!< CQFTGL (Bitfield-Mask: 0xff)                          */
#define BLEIF_CQSETCLEAR_CQFSET_Pos       (0UL)                     /*!< CQFSET (Bit 0)                                        */
#define BLEIF_CQSETCLEAR_CQFSET_Msk       (0xffUL)                  /*!< CQFSET (Bitfield-Mask: 0xff)                          */
/* =======================================================  CQPAUSEEN  ======================================================= */
#define BLEIF_CQPAUSEEN_CQPEN_Pos         (0UL)                     /*!< CQPEN (Bit 0)                                         */
#define BLEIF_CQPAUSEEN_CQPEN_Msk         (0xffffUL)                /*!< CQPEN (Bitfield-Mask: 0xffff)                         */
/* =======================================================  CQCURIDX  ======================================================== */
#define BLEIF_CQCURIDX_CQCURIDX_Pos       (0UL)                     /*!< CQCURIDX (Bit 0)                                      */
#define BLEIF_CQCURIDX_CQCURIDX_Msk       (0xffUL)                  /*!< CQCURIDX (Bitfield-Mask: 0xff)                        */
/* =======================================================  CQENDIDX  ======================================================== */
#define BLEIF_CQENDIDX_CQENDIDX_Pos       (0UL)                     /*!< CQENDIDX (Bit 0)                                      */
#define BLEIF_CQENDIDX_CQENDIDX_Msk       (0xffUL)                  /*!< CQENDIDX (Bitfield-Mask: 0xff)                        */
/* ========================================================  STATUS  ========================================================= */
#define BLEIF_STATUS_IDLEST_Pos           (2UL)                     /*!< IDLEST (Bit 2)                                        */
#define BLEIF_STATUS_IDLEST_Msk           (0x4UL)                   /*!< IDLEST (Bitfield-Mask: 0x01)                          */
#define BLEIF_STATUS_CMDACT_Pos           (1UL)                     /*!< CMDACT (Bit 1)                                        */
#define BLEIF_STATUS_CMDACT_Msk           (0x2UL)                   /*!< CMDACT (Bitfield-Mask: 0x01)                          */
#define BLEIF_STATUS_ERR_Pos              (0UL)                     /*!< ERR (Bit 0)                                           */
#define BLEIF_STATUS_ERR_Msk              (0x1UL)                   /*!< ERR (Bitfield-Mask: 0x01)                             */
/* ========================================================  MSPICFG  ======================================================== */
#define BLEIF_MSPICFG_MSPIRST_Pos         (30UL)                    /*!< MSPIRST (Bit 30)                                      */
#define BLEIF_MSPICFG_MSPIRST_Msk         (0x40000000UL)            /*!< MSPIRST (Bitfield-Mask: 0x01)                         */
#define BLEIF_MSPICFG_DOUTDLY_Pos         (27UL)                    /*!< DOUTDLY (Bit 27)                                      */
#define BLEIF_MSPICFG_DOUTDLY_Msk         (0x38000000UL)            /*!< DOUTDLY (Bitfield-Mask: 0x07)                         */
#define BLEIF_MSPICFG_DINDLY_Pos          (24UL)                    /*!< DINDLY (Bit 24)                                       */
#define BLEIF_MSPICFG_DINDLY_Msk          (0x7000000UL)             /*!< DINDLY (Bitfield-Mask: 0x07)                          */
#define BLEIF_MSPICFG_SPILSB_Pos          (23UL)                    /*!< SPILSB (Bit 23)                                       */
#define BLEIF_MSPICFG_SPILSB_Msk          (0x800000UL)              /*!< SPILSB (Bitfield-Mask: 0x01)                          */
#define BLEIF_MSPICFG_RDFCPOL_Pos         (22UL)                    /*!< RDFCPOL (Bit 22)                                      */
#define BLEIF_MSPICFG_RDFCPOL_Msk         (0x400000UL)              /*!< RDFCPOL (Bitfield-Mask: 0x01)                         */
#define BLEIF_MSPICFG_WTFCPOL_Pos         (21UL)                    /*!< WTFCPOL (Bit 21)                                      */
#define BLEIF_MSPICFG_WTFCPOL_Msk         (0x200000UL)              /*!< WTFCPOL (Bitfield-Mask: 0x01)                         */
#define BLEIF_MSPICFG_RDFC_Pos            (17UL)                    /*!< RDFC (Bit 17)                                         */
#define BLEIF_MSPICFG_RDFC_Msk            (0x20000UL)               /*!< RDFC (Bitfield-Mask: 0x01)                            */
#define BLEIF_MSPICFG_WTFC_Pos            (16UL)                    /*!< WTFC (Bit 16)                                         */
#define BLEIF_MSPICFG_WTFC_Msk            (0x10000UL)               /*!< WTFC (Bitfield-Mask: 0x01)                            */
#define BLEIF_MSPICFG_FULLDUP_Pos         (2UL)                     /*!< FULLDUP (Bit 2)                                       */
#define BLEIF_MSPICFG_FULLDUP_Msk         (0x4UL)                   /*!< FULLDUP (Bitfield-Mask: 0x01)                         */
#define BLEIF_MSPICFG_SPHA_Pos            (1UL)                     /*!< SPHA (Bit 1)                                          */
#define BLEIF_MSPICFG_SPHA_Msk            (0x2UL)                   /*!< SPHA (Bitfield-Mask: 0x01)                            */
#define BLEIF_MSPICFG_SPOL_Pos            (0UL)                     /*!< SPOL (Bit 0)                                          */
#define BLEIF_MSPICFG_SPOL_Msk            (0x1UL)                   /*!< SPOL (Bitfield-Mask: 0x01)                            */
/* ========================================================  BLECFG  ========================================================= */
#define BLEIF_BLECFG_SPIISOCTL_Pos        (14UL)                    /*!< SPIISOCTL (Bit 14)                                    */
#define BLEIF_BLECFG_SPIISOCTL_Msk        (0xc000UL)                /*!< SPIISOCTL (Bitfield-Mask: 0x03)                       */
#define BLEIF_BLECFG_PWRISOCTL_Pos        (12UL)                    /*!< PWRISOCTL (Bit 12)                                    */
#define BLEIF_BLECFG_PWRISOCTL_Msk        (0x3000UL)                /*!< PWRISOCTL (Bitfield-Mask: 0x03)                       */
#define BLEIF_BLECFG_STAYASLEEP_Pos       (11UL)                    /*!< STAYASLEEP (Bit 11)                                   */
#define BLEIF_BLECFG_STAYASLEEP_Msk       (0x800UL)                 /*!< STAYASLEEP (Bitfield-Mask: 0x01)                      */
#define BLEIF_BLECFG_FRCCLK_Pos           (10UL)                    /*!< FRCCLK (Bit 10)                                       */
#define BLEIF_BLECFG_FRCCLK_Msk           (0x400UL)                 /*!< FRCCLK (Bitfield-Mask: 0x01)                          */
#define BLEIF_BLECFG_MCUFRCSLP_Pos        (9UL)                     /*!< MCUFRCSLP (Bit 9)                                     */
#define BLEIF_BLECFG_MCUFRCSLP_Msk        (0x200UL)                 /*!< MCUFRCSLP (Bitfield-Mask: 0x01)                       */
#define BLEIF_BLECFG_WT4ACTOFF_Pos        (8UL)                     /*!< WT4ACTOFF (Bit 8)                                     */
#define BLEIF_BLECFG_WT4ACTOFF_Msk        (0x100UL)                 /*!< WT4ACTOFF (Bitfield-Mask: 0x01)                       */
#define BLEIF_BLECFG_BLEHREQCTL_Pos       (6UL)                     /*!< BLEHREQCTL (Bit 6)                                    */
#define BLEIF_BLECFG_BLEHREQCTL_Msk       (0xc0UL)                  /*!< BLEHREQCTL (Bitfield-Mask: 0x03)                      */
#define BLEIF_BLECFG_DCDCFLGCTL_Pos       (4UL)                     /*!< DCDCFLGCTL (Bit 4)                                    */
#define BLEIF_BLECFG_DCDCFLGCTL_Msk       (0x30UL)                  /*!< DCDCFLGCTL (Bitfield-Mask: 0x03)                      */
#define BLEIF_BLECFG_WAKEUPCTL_Pos        (2UL)                     /*!< WAKEUPCTL (Bit 2)                                     */
#define BLEIF_BLECFG_WAKEUPCTL_Msk        (0xcUL)                   /*!< WAKEUPCTL (Bitfield-Mask: 0x03)                       */
#define BLEIF_BLECFG_BLERSTN_Pos          (1UL)                     /*!< BLERSTN (Bit 1)                                       */
#define BLEIF_BLECFG_BLERSTN_Msk          (0x2UL)                   /*!< BLERSTN (Bitfield-Mask: 0x01)                         */
#define BLEIF_BLECFG_PWRSMEN_Pos          (0UL)                     /*!< PWRSMEN (Bit 0)                                       */
#define BLEIF_BLECFG_PWRSMEN_Msk          (0x1UL)                   /*!< PWRSMEN (Bitfield-Mask: 0x01)                         */
/* ========================================================  PWRCMD  ========================================================= */
#define BLEIF_PWRCMD_RESTART_Pos          (1UL)                     /*!< RESTART (Bit 1)                                       */
#define BLEIF_PWRCMD_RESTART_Msk          (0x2UL)                   /*!< RESTART (Bitfield-Mask: 0x01)                         */
#define BLEIF_PWRCMD_WAKEREQ_Pos          (0UL)                     /*!< WAKEREQ (Bit 0)                                       */
#define BLEIF_PWRCMD_WAKEREQ_Msk          (0x1UL)                   /*!< WAKEREQ (Bitfield-Mask: 0x01)                         */
/* ========================================================  BSTATUS  ======================================================== */
#define BLEIF_BSTATUS_BLEHREQ_Pos         (12UL)                    /*!< BLEHREQ (Bit 12)                                      */
#define BLEIF_BSTATUS_BLEHREQ_Msk         (0x1000UL)                /*!< BLEHREQ (Bitfield-Mask: 0x01)                         */
#define BLEIF_BSTATUS_BLEHACK_Pos         (11UL)                    /*!< BLEHACK (Bit 11)                                      */
#define BLEIF_BSTATUS_BLEHACK_Msk         (0x800UL)                 /*!< BLEHACK (Bitfield-Mask: 0x01)                         */
#define BLEIF_BSTATUS_PWRST_Pos           (8UL)                     /*!< PWRST (Bit 8)                                         */
#define BLEIF_BSTATUS_PWRST_Msk           (0x700UL)                 /*!< PWRST (Bitfield-Mask: 0x07)                           */
#define BLEIF_BSTATUS_BLEIRQ_Pos          (7UL)                     /*!< BLEIRQ (Bit 7)                                        */
#define BLEIF_BSTATUS_BLEIRQ_Msk          (0x80UL)                  /*!< BLEIRQ (Bitfield-Mask: 0x01)                          */
#define BLEIF_BSTATUS_WAKEUP_Pos          (6UL)                     /*!< WAKEUP (Bit 6)                                        */
#define BLEIF_BSTATUS_WAKEUP_Msk          (0x40UL)                  /*!< WAKEUP (Bitfield-Mask: 0x01)                          */
#define BLEIF_BSTATUS_DCDCFLAG_Pos        (5UL)                     /*!< DCDCFLAG (Bit 5)                                      */
#define BLEIF_BSTATUS_DCDCFLAG_Msk        (0x20UL)                  /*!< DCDCFLAG (Bitfield-Mask: 0x01)                        */
#define BLEIF_BSTATUS_DCDCREQ_Pos         (4UL)                     /*!< DCDCREQ (Bit 4)                                       */
#define BLEIF_BSTATUS_DCDCREQ_Msk         (0x10UL)                  /*!< DCDCREQ (Bitfield-Mask: 0x01)                         */
#define BLEIF_BSTATUS_SPISTATUS_Pos       (3UL)                     /*!< SPISTATUS (Bit 3)                                     */
#define BLEIF_BSTATUS_SPISTATUS_Msk       (0x8UL)                   /*!< SPISTATUS (Bitfield-Mask: 0x01)                       */
#define BLEIF_BSTATUS_B2MSTATE_Pos        (0UL)                     /*!< B2MSTATE (Bit 0)                                      */
#define BLEIF_BSTATUS_B2MSTATE_Msk        (0x7UL)                   /*!< B2MSTATE (Bitfield-Mask: 0x07)                        */
/* ========================================================  BLEDBG  ========================================================= */
#define BLEIF_BLEDBG_DBGDATA_Pos          (3UL)                     /*!< DBGDATA (Bit 3)                                       */
#define BLEIF_BLEDBG_DBGDATA_Msk          (0xfffffff8UL)            /*!< DBGDATA (Bitfield-Mask: 0x1fffffff)                   */
#define BLEIF_BLEDBG_APBCLKON_Pos         (2UL)                     /*!< APBCLKON (Bit 2)                                      */
#define BLEIF_BLEDBG_APBCLKON_Msk         (0x4UL)                   /*!< APBCLKON (Bitfield-Mask: 0x01)                        */
#define BLEIF_BLEDBG_IOCLKON_Pos          (1UL)                     /*!< IOCLKON (Bit 1)                                       */
#define BLEIF_BLEDBG_IOCLKON_Msk          (0x2UL)                   /*!< IOCLKON (Bitfield-Mask: 0x01)                         */
#define BLEIF_BLEDBG_DBGEN_Pos            (0UL)                     /*!< DBGEN (Bit 0)                                         */
#define BLEIF_BLEDBG_DBGEN_Msk            (0x1UL)                   /*!< DBGEN (Bitfield-Mask: 0x01)                           */


/* =========================================================================================================================== */
/* ================                                         CACHECTRL                                         ================ */
/* =========================================================================================================================== */

/* =======================================================  CACHECFG  ======================================================== */
#define CACHECTRL_CACHECFG_ENABLE_MONITOR_Pos (24UL)                /*!< ENABLE_MONITOR (Bit 24)                               */
#define CACHECTRL_CACHECFG_ENABLE_MONITOR_Msk (0x1000000UL)         /*!< ENABLE_MONITOR (Bitfield-Mask: 0x01)                  */
#define CACHECTRL_CACHECFG_DATA_CLKGATE_Pos (20UL)                  /*!< DATA_CLKGATE (Bit 20)                                 */
#define CACHECTRL_CACHECFG_DATA_CLKGATE_Msk (0x100000UL)            /*!< DATA_CLKGATE (Bitfield-Mask: 0x01)                    */
#define CACHECTRL_CACHECFG_CACHE_LS_Pos   (11UL)                    /*!< CACHE_LS (Bit 11)                                     */
#define CACHECTRL_CACHECFG_CACHE_LS_Msk   (0x800UL)                 /*!< CACHE_LS (Bitfield-Mask: 0x01)                        */
#define CACHECTRL_CACHECFG_CACHE_CLKGATE_Pos (10UL)                 /*!< CACHE_CLKGATE (Bit 10)                                */
#define CACHECTRL_CACHECFG_CACHE_CLKGATE_Msk (0x400UL)              /*!< CACHE_CLKGATE (Bitfield-Mask: 0x01)                   */
#define CACHECTRL_CACHECFG_DCACHE_ENABLE_Pos (9UL)                  /*!< DCACHE_ENABLE (Bit 9)                                 */
#define CACHECTRL_CACHECFG_DCACHE_ENABLE_Msk (0x200UL)              /*!< DCACHE_ENABLE (Bitfield-Mask: 0x01)                   */
#define CACHECTRL_CACHECFG_ICACHE_ENABLE_Pos (8UL)                  /*!< ICACHE_ENABLE (Bit 8)                                 */
#define CACHECTRL_CACHECFG_ICACHE_ENABLE_Msk (0x100UL)              /*!< ICACHE_ENABLE (Bitfield-Mask: 0x01)                   */
#define CACHECTRL_CACHECFG_CONFIG_Pos     (4UL)                     /*!< CONFIG (Bit 4)                                        */
#define CACHECTRL_CACHECFG_CONFIG_Msk     (0xf0UL)                  /*!< CONFIG (Bitfield-Mask: 0x0f)                          */
#define CACHECTRL_CACHECFG_ENABLE_NC1_Pos (3UL)                     /*!< ENABLE_NC1 (Bit 3)                                    */
#define CACHECTRL_CACHECFG_ENABLE_NC1_Msk (0x8UL)                   /*!< ENABLE_NC1 (Bitfield-Mask: 0x01)                      */
#define CACHECTRL_CACHECFG_ENABLE_NC0_Pos (2UL)                     /*!< ENABLE_NC0 (Bit 2)                                    */
#define CACHECTRL_CACHECFG_ENABLE_NC0_Msk (0x4UL)                   /*!< ENABLE_NC0 (Bitfield-Mask: 0x01)                      */
#define CACHECTRL_CACHECFG_LRU_Pos        (1UL)                     /*!< LRU (Bit 1)                                           */
#define CACHECTRL_CACHECFG_LRU_Msk        (0x2UL)                   /*!< LRU (Bitfield-Mask: 0x01)                             */
#define CACHECTRL_CACHECFG_ENABLE_Pos     (0UL)                     /*!< ENABLE (Bit 0)                                        */
#define CACHECTRL_CACHECFG_ENABLE_Msk     (0x1UL)                   /*!< ENABLE (Bitfield-Mask: 0x01)                          */
/* =======================================================  FLASHCFG  ======================================================== */
#define CACHECTRL_FLASHCFG_LPMMODE_Pos    (12UL)                    /*!< LPMMODE (Bit 12)                                      */
#define CACHECTRL_FLASHCFG_LPMMODE_Msk    (0x3000UL)                /*!< LPMMODE (Bitfield-Mask: 0x03)                         */
#define CACHECTRL_FLASHCFG_LPM_RD_WAIT_Pos (8UL)                    /*!< LPM_RD_WAIT (Bit 8)                                   */
#define CACHECTRL_FLASHCFG_LPM_RD_WAIT_Msk (0xf00UL)                /*!< LPM_RD_WAIT (Bitfield-Mask: 0x0f)                     */
#define CACHECTRL_FLASHCFG_SEDELAY_Pos    (4UL)                     /*!< SEDELAY (Bit 4)                                       */
#define CACHECTRL_FLASHCFG_SEDELAY_Msk    (0x70UL)                  /*!< SEDELAY (Bitfield-Mask: 0x07)                         */
#define CACHECTRL_FLASHCFG_RD_WAIT_Pos    (0UL)                     /*!< RD_WAIT (Bit 0)                                       */
#define CACHECTRL_FLASHCFG_RD_WAIT_Msk    (0xfUL)                   /*!< RD_WAIT (Bitfield-Mask: 0x0f)                         */
/* =========================================================  CTRL  ========================================================== */
#define CACHECTRL_CTRL_FLASH1_SLM_ENABLE_Pos (10UL)                 /*!< FLASH1_SLM_ENABLE (Bit 10)                            */
#define CACHECTRL_CTRL_FLASH1_SLM_ENABLE_Msk (0x400UL)              /*!< FLASH1_SLM_ENABLE (Bitfield-Mask: 0x01)               */
#define CACHECTRL_CTRL_FLASH1_SLM_DISABLE_Pos (9UL)                 /*!< FLASH1_SLM_DISABLE (Bit 9)                            */
#define CACHECTRL_CTRL_FLASH1_SLM_DISABLE_Msk (0x200UL)             /*!< FLASH1_SLM_DISABLE (Bitfield-Mask: 0x01)              */
#define CACHECTRL_CTRL_FLASH1_SLM_STATUS_Pos (8UL)                  /*!< FLASH1_SLM_STATUS (Bit 8)                             */
#define CACHECTRL_CTRL_FLASH1_SLM_STATUS_Msk (0x100UL)              /*!< FLASH1_SLM_STATUS (Bitfield-Mask: 0x01)               */
#define CACHECTRL_CTRL_FLASH0_SLM_ENABLE_Pos (6UL)                  /*!< FLASH0_SLM_ENABLE (Bit 6)                             */
#define CACHECTRL_CTRL_FLASH0_SLM_ENABLE_Msk (0x40UL)               /*!< FLASH0_SLM_ENABLE (Bitfield-Mask: 0x01)               */
#define CACHECTRL_CTRL_FLASH0_SLM_DISABLE_Pos (5UL)                 /*!< FLASH0_SLM_DISABLE (Bit 5)                            */
#define CACHECTRL_CTRL_FLASH0_SLM_DISABLE_Msk (0x20UL)              /*!< FLASH0_SLM_DISABLE (Bitfield-Mask: 0x01)              */
#define CACHECTRL_CTRL_FLASH0_SLM_STATUS_Pos (4UL)                  /*!< FLASH0_SLM_STATUS (Bit 4)                             */
#define CACHECTRL_CTRL_FLASH0_SLM_STATUS_Msk (0x10UL)               /*!< FLASH0_SLM_STATUS (Bitfield-Mask: 0x01)               */
#define CACHECTRL_CTRL_CACHE_READY_Pos    (2UL)                     /*!< CACHE_READY (Bit 2)                                   */
#define CACHECTRL_CTRL_CACHE_READY_Msk    (0x4UL)                   /*!< CACHE_READY (Bitfield-Mask: 0x01)                     */
#define CACHECTRL_CTRL_RESET_STAT_Pos     (1UL)                     /*!< RESET_STAT (Bit 1)                                    */
#define CACHECTRL_CTRL_RESET_STAT_Msk     (0x2UL)                   /*!< RESET_STAT (Bitfield-Mask: 0x01)                      */
#define CACHECTRL_CTRL_INVALIDATE_Pos     (0UL)                     /*!< INVALIDATE (Bit 0)                                    */
#define CACHECTRL_CTRL_INVALIDATE_Msk     (0x1UL)                   /*!< INVALIDATE (Bitfield-Mask: 0x01)                      */
/* =======================================================  NCR0START  ======================================================= */
#define CACHECTRL_NCR0START_ADDR_Pos      (4UL)                     /*!< ADDR (Bit 4)                                          */
#define CACHECTRL_NCR0START_ADDR_Msk      (0x7fffff0UL)             /*!< ADDR (Bitfield-Mask: 0x7fffff)                        */
/* ========================================================  NCR0END  ======================================================== */
#define CACHECTRL_NCR0END_ADDR_Pos        (4UL)                     /*!< ADDR (Bit 4)                                          */
#define CACHECTRL_NCR0END_ADDR_Msk        (0x7fffff0UL)             /*!< ADDR (Bitfield-Mask: 0x7fffff)                        */
/* =======================================================  NCR1START  ======================================================= */
#define CACHECTRL_NCR1START_ADDR_Pos      (4UL)                     /*!< ADDR (Bit 4)                                          */
#define CACHECTRL_NCR1START_ADDR_Msk      (0x7fffff0UL)             /*!< ADDR (Bitfield-Mask: 0x7fffff)                        */
/* ========================================================  NCR1END  ======================================================== */
#define CACHECTRL_NCR1END_ADDR_Pos        (4UL)                     /*!< ADDR (Bit 4)                                          */
#define CACHECTRL_NCR1END_ADDR_Msk        (0x7fffff0UL)             /*!< ADDR (Bitfield-Mask: 0x7fffff)                        */
/* =========================================================  DMON0  ========================================================= */
#define CACHECTRL_DMON0_DACCESS_COUNT_Pos (0UL)                     /*!< DACCESS_COUNT (Bit 0)                                 */
#define CACHECTRL_DMON0_DACCESS_COUNT_Msk (0xffffffffUL)            /*!< DACCESS_COUNT (Bitfield-Mask: 0xffffffff)             */
/* =========================================================  DMON1  ========================================================= */
#define CACHECTRL_DMON1_DLOOKUP_COUNT_Pos (0UL)                     /*!< DLOOKUP_COUNT (Bit 0)                                 */
#define CACHECTRL_DMON1_DLOOKUP_COUNT_Msk (0xffffffffUL)            /*!< DLOOKUP_COUNT (Bitfield-Mask: 0xffffffff)             */
/* =========================================================  DMON2  ========================================================= */
#define CACHECTRL_DMON2_DHIT_COUNT_Pos    (0UL)                     /*!< DHIT_COUNT (Bit 0)                                    */
#define CACHECTRL_DMON2_DHIT_COUNT_Msk    (0xffffffffUL)            /*!< DHIT_COUNT (Bitfield-Mask: 0xffffffff)                */
/* =========================================================  DMON3  ========================================================= */
#define CACHECTRL_DMON3_DLINE_COUNT_Pos   (0UL)                     /*!< DLINE_COUNT (Bit 0)                                   */
#define CACHECTRL_DMON3_DLINE_COUNT_Msk   (0xffffffffUL)            /*!< DLINE_COUNT (Bitfield-Mask: 0xffffffff)               */
/* =========================================================  IMON0  ========================================================= */
#define CACHECTRL_IMON0_IACCESS_COUNT_Pos (0UL)                     /*!< IACCESS_COUNT (Bit 0)                                 */
#define CACHECTRL_IMON0_IACCESS_COUNT_Msk (0xffffffffUL)            /*!< IACCESS_COUNT (Bitfield-Mask: 0xffffffff)             */
/* =========================================================  IMON1  ========================================================= */
#define CACHECTRL_IMON1_ILOOKUP_COUNT_Pos (0UL)                     /*!< ILOOKUP_COUNT (Bit 0)                                 */
#define CACHECTRL_IMON1_ILOOKUP_COUNT_Msk (0xffffffffUL)            /*!< ILOOKUP_COUNT (Bitfield-Mask: 0xffffffff)             */
/* =========================================================  IMON2  ========================================================= */
#define CACHECTRL_IMON2_IHIT_COUNT_Pos    (0UL)                     /*!< IHIT_COUNT (Bit 0)                                    */
#define CACHECTRL_IMON2_IHIT_COUNT_Msk    (0xffffffffUL)            /*!< IHIT_COUNT (Bitfield-Mask: 0xffffffff)                */
/* =========================================================  IMON3  ========================================================= */
#define CACHECTRL_IMON3_ILINE_COUNT_Pos   (0UL)                     /*!< ILINE_COUNT (Bit 0)                                   */
#define CACHECTRL_IMON3_ILINE_COUNT_Msk   (0xffffffffUL)            /*!< ILINE_COUNT (Bitfield-Mask: 0xffffffff)               */


/* =========================================================================================================================== */
/* ================                                          CLKGEN                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  CALXT  ========================================================= */
#define CLKGEN_CALXT_CALXT_Pos            (0UL)                     /*!< CALXT (Bit 0)                                         */
#define CLKGEN_CALXT_CALXT_Msk            (0x7ffUL)                 /*!< CALXT (Bitfield-Mask: 0x7ff)                          */
/* =========================================================  CALRC  ========================================================= */
#define CLKGEN_CALRC_CALRC_Pos            (0UL)                     /*!< CALRC (Bit 0)                                         */
#define CLKGEN_CALRC_CALRC_Msk            (0x3ffffUL)               /*!< CALRC (Bitfield-Mask: 0x3ffff)                        */
/* ========================================================  ACALCTR  ======================================================== */
#define CLKGEN_ACALCTR_ACALCTR_Pos        (0UL)                     /*!< ACALCTR (Bit 0)                                       */
#define CLKGEN_ACALCTR_ACALCTR_Msk        (0xffffffUL)              /*!< ACALCTR (Bitfield-Mask: 0xffffff)                     */
/* =========================================================  OCTRL  ========================================================= */
#define CLKGEN_OCTRL_ACAL_Pos             (8UL)                     /*!< ACAL (Bit 8)                                          */
#define CLKGEN_OCTRL_ACAL_Msk             (0x700UL)                 /*!< ACAL (Bitfield-Mask: 0x07)                            */
#define CLKGEN_OCTRL_OSEL_Pos             (7UL)                     /*!< OSEL (Bit 7)                                          */
#define CLKGEN_OCTRL_OSEL_Msk             (0x80UL)                  /*!< OSEL (Bitfield-Mask: 0x01)                            */
#define CLKGEN_OCTRL_FOS_Pos              (6UL)                     /*!< FOS (Bit 6)                                           */
#define CLKGEN_OCTRL_FOS_Msk              (0x40UL)                  /*!< FOS (Bitfield-Mask: 0x01)                             */
#define CLKGEN_OCTRL_STOPRC_Pos           (1UL)                     /*!< STOPRC (Bit 1)                                        */
#define CLKGEN_OCTRL_STOPRC_Msk           (0x2UL)                   /*!< STOPRC (Bitfield-Mask: 0x01)                          */
#define CLKGEN_OCTRL_STOPXT_Pos           (0UL)                     /*!< STOPXT (Bit 0)                                        */
#define CLKGEN_OCTRL_STOPXT_Msk           (0x1UL)                   /*!< STOPXT (Bitfield-Mask: 0x01)                          */
/* ========================================================  CLKOUT  ========================================================= */
#define CLKGEN_CLKOUT_CKEN_Pos            (7UL)                     /*!< CKEN (Bit 7)                                          */
#define CLKGEN_CLKOUT_CKEN_Msk            (0x80UL)                  /*!< CKEN (Bitfield-Mask: 0x01)                            */
#define CLKGEN_CLKOUT_CKSEL_Pos           (0UL)                     /*!< CKSEL (Bit 0)                                         */
#define CLKGEN_CLKOUT_CKSEL_Msk           (0x3fUL)                  /*!< CKSEL (Bitfield-Mask: 0x3f)                           */
/* ========================================================  CLKKEY  ========================================================= */
#define CLKGEN_CLKKEY_CLKKEY_Pos          (0UL)                     /*!< CLKKEY (Bit 0)                                        */
#define CLKGEN_CLKKEY_CLKKEY_Msk          (0xffffffffUL)            /*!< CLKKEY (Bitfield-Mask: 0xffffffff)                    */
/* =========================================================  CCTRL  ========================================================= */
#define CLKGEN_CCTRL_CORESEL_Pos          (0UL)                     /*!< CORESEL (Bit 0)                                       */
#define CLKGEN_CCTRL_CORESEL_Msk          (0x1UL)                   /*!< CORESEL (Bitfield-Mask: 0x01)                         */
/* ========================================================  STATUS  ========================================================= */
#define CLKGEN_STATUS_OSCF_Pos            (1UL)                     /*!< OSCF (Bit 1)                                          */
#define CLKGEN_STATUS_OSCF_Msk            (0x2UL)                   /*!< OSCF (Bitfield-Mask: 0x01)                            */
#define CLKGEN_STATUS_OMODE_Pos           (0UL)                     /*!< OMODE (Bit 0)                                         */
#define CLKGEN_STATUS_OMODE_Msk           (0x1UL)                   /*!< OMODE (Bitfield-Mask: 0x01)                           */
/* =========================================================  HFADJ  ========================================================= */
#define CLKGEN_HFADJ_HFADJGAIN_Pos        (21UL)                    /*!< HFADJGAIN (Bit 21)                                    */
#define CLKGEN_HFADJ_HFADJGAIN_Msk        (0xe00000UL)              /*!< HFADJGAIN (Bitfield-Mask: 0x07)                       */
#define CLKGEN_HFADJ_HFWARMUP_Pos         (20UL)                    /*!< HFWARMUP (Bit 20)                                     */
#define CLKGEN_HFADJ_HFWARMUP_Msk         (0x100000UL)              /*!< HFWARMUP (Bitfield-Mask: 0x01)                        */
#define CLKGEN_HFADJ_HFXTADJ_Pos          (8UL)                     /*!< HFXTADJ (Bit 8)                                       */
#define CLKGEN_HFADJ_HFXTADJ_Msk          (0xfff00UL)               /*!< HFXTADJ (Bitfield-Mask: 0xfff)                        */
#define CLKGEN_HFADJ_HFADJCK_Pos          (1UL)                     /*!< HFADJCK (Bit 1)                                       */
#define CLKGEN_HFADJ_HFADJCK_Msk          (0xeUL)                   /*!< HFADJCK (Bitfield-Mask: 0x07)                         */
#define CLKGEN_HFADJ_HFADJEN_Pos          (0UL)                     /*!< HFADJEN (Bit 0)                                       */
#define CLKGEN_HFADJ_HFADJEN_Msk          (0x1UL)                   /*!< HFADJEN (Bitfield-Mask: 0x01)                         */
/* ======================================================  CLOCKENSTAT  ====================================================== */
#define CLKGEN_CLOCKENSTAT_CLOCKENSTAT_Pos (0UL)                    /*!< CLOCKENSTAT (Bit 0)                                   */
#define CLKGEN_CLOCKENSTAT_CLOCKENSTAT_Msk (0xffffffffUL)           /*!< CLOCKENSTAT (Bitfield-Mask: 0xffffffff)               */
/* =====================================================  CLOCKEN2STAT  ====================================================== */
#define CLKGEN_CLOCKEN2STAT_CLOCKEN2STAT_Pos (0UL)                  /*!< CLOCKEN2STAT (Bit 0)                                  */
#define CLKGEN_CLOCKEN2STAT_CLOCKEN2STAT_Msk (0xffffffffUL)         /*!< CLOCKEN2STAT (Bitfield-Mask: 0xffffffff)              */
/* =====================================================  CLOCKEN3STAT  ====================================================== */
#define CLKGEN_CLOCKEN3STAT_CLOCKEN3STAT_Pos (0UL)                  /*!< CLOCKEN3STAT (Bit 0)                                  */
#define CLKGEN_CLOCKEN3STAT_CLOCKEN3STAT_Msk (0xffffffffUL)         /*!< CLOCKEN3STAT (Bitfield-Mask: 0xffffffff)              */
/* =======================================================  FREQCTRL  ======================================================== */
#define CLKGEN_FREQCTRL_BURSTSTATUS_Pos   (2UL)                     /*!< BURSTSTATUS (Bit 2)                                   */
#define CLKGEN_FREQCTRL_BURSTSTATUS_Msk   (0x4UL)                   /*!< BURSTSTATUS (Bitfield-Mask: 0x01)                     */
#define CLKGEN_FREQCTRL_BURSTACK_Pos      (1UL)                     /*!< BURSTACK (Bit 1)                                      */
#define CLKGEN_FREQCTRL_BURSTACK_Msk      (0x2UL)                   /*!< BURSTACK (Bitfield-Mask: 0x01)                        */
#define CLKGEN_FREQCTRL_BURSTREQ_Pos      (0UL)                     /*!< BURSTREQ (Bit 0)                                      */
#define CLKGEN_FREQCTRL_BURSTREQ_Msk      (0x1UL)                   /*!< BURSTREQ (Bitfield-Mask: 0x01)                        */
/* =====================================================  BLEBUCKTONADJ  ===================================================== */
#define CLKGEN_BLEBUCKTONADJ_ZEROLENDETECTEN_Pos (27UL)             /*!< ZEROLENDETECTEN (Bit 27)                              */
#define CLKGEN_BLEBUCKTONADJ_ZEROLENDETECTEN_Msk (0x8000000UL)      /*!< ZEROLENDETECTEN (Bitfield-Mask: 0x01)                 */
#define CLKGEN_BLEBUCKTONADJ_ZEROLENDETECTTRIM_Pos (23UL)           /*!< ZEROLENDETECTTRIM (Bit 23)                            */
#define CLKGEN_BLEBUCKTONADJ_ZEROLENDETECTTRIM_Msk (0x7800000UL)    /*!< ZEROLENDETECTTRIM (Bitfield-Mask: 0x0f)               */
#define CLKGEN_BLEBUCKTONADJ_TONADJUSTEN_Pos (22UL)                 /*!< TONADJUSTEN (Bit 22)                                  */
#define CLKGEN_BLEBUCKTONADJ_TONADJUSTEN_Msk (0x400000UL)           /*!< TONADJUSTEN (Bitfield-Mask: 0x01)                     */
#define CLKGEN_BLEBUCKTONADJ_TONADJUSTPERIOD_Pos (20UL)             /*!< TONADJUSTPERIOD (Bit 20)                              */
#define CLKGEN_BLEBUCKTONADJ_TONADJUSTPERIOD_Msk (0x300000UL)       /*!< TONADJUSTPERIOD (Bitfield-Mask: 0x03)                 */
#define CLKGEN_BLEBUCKTONADJ_TONHIGHTHRESHOLD_Pos (10UL)            /*!< TONHIGHTHRESHOLD (Bit 10)                             */
#define CLKGEN_BLEBUCKTONADJ_TONHIGHTHRESHOLD_Msk (0xffc00UL)       /*!< TONHIGHTHRESHOLD (Bitfield-Mask: 0x3ff)               */
#define CLKGEN_BLEBUCKTONADJ_TONLOWTHRESHOLD_Pos (0UL)              /*!< TONLOWTHRESHOLD (Bit 0)                               */
#define CLKGEN_BLEBUCKTONADJ_TONLOWTHRESHOLD_Msk (0x3ffUL)          /*!< TONLOWTHRESHOLD (Bitfield-Mask: 0x3ff)                */
/* =======================================================  INTRPTEN  ======================================================== */
#define CLKGEN_INTRPTEN_OF_Pos            (2UL)                     /*!< OF (Bit 2)                                            */
#define CLKGEN_INTRPTEN_OF_Msk            (0x4UL)                   /*!< OF (Bitfield-Mask: 0x01)                              */
#define CLKGEN_INTRPTEN_ACC_Pos           (1UL)                     /*!< ACC (Bit 1)                                           */
#define CLKGEN_INTRPTEN_ACC_Msk           (0x2UL)                   /*!< ACC (Bitfield-Mask: 0x01)                             */
#define CLKGEN_INTRPTEN_ACF_Pos           (0UL)                     /*!< ACF (Bit 0)                                           */
#define CLKGEN_INTRPTEN_ACF_Msk           (0x1UL)                   /*!< ACF (Bitfield-Mask: 0x01)                             */
/* ======================================================  INTRPTSTAT  ======================================================= */
#define CLKGEN_INTRPTSTAT_OF_Pos          (2UL)                     /*!< OF (Bit 2)                                            */
#define CLKGEN_INTRPTSTAT_OF_Msk          (0x4UL)                   /*!< OF (Bitfield-Mask: 0x01)                              */
#define CLKGEN_INTRPTSTAT_ACC_Pos         (1UL)                     /*!< ACC (Bit 1)                                           */
#define CLKGEN_INTRPTSTAT_ACC_Msk         (0x2UL)                   /*!< ACC (Bitfield-Mask: 0x01)                             */
#define CLKGEN_INTRPTSTAT_ACF_Pos         (0UL)                     /*!< ACF (Bit 0)                                           */
#define CLKGEN_INTRPTSTAT_ACF_Msk         (0x1UL)                   /*!< ACF (Bitfield-Mask: 0x01)                             */
/* =======================================================  INTRPTCLR  ======================================================= */
#define CLKGEN_INTRPTCLR_OF_Pos           (2UL)                     /*!< OF (Bit 2)                                            */
#define CLKGEN_INTRPTCLR_OF_Msk           (0x4UL)                   /*!< OF (Bitfield-Mask: 0x01)                              */
#define CLKGEN_INTRPTCLR_ACC_Pos          (1UL)                     /*!< ACC (Bit 1)                                           */
#define CLKGEN_INTRPTCLR_ACC_Msk          (0x2UL)                   /*!< ACC (Bitfield-Mask: 0x01)                             */
#define CLKGEN_INTRPTCLR_ACF_Pos          (0UL)                     /*!< ACF (Bit 0)                                           */
#define CLKGEN_INTRPTCLR_ACF_Msk          (0x1UL)                   /*!< ACF (Bitfield-Mask: 0x01)                             */
/* =======================================================  INTRPTSET  ======================================================= */
#define CLKGEN_INTRPTSET_OF_Pos           (2UL)                     /*!< OF (Bit 2)                                            */
#define CLKGEN_INTRPTSET_OF_Msk           (0x4UL)                   /*!< OF (Bitfield-Mask: 0x01)                              */
#define CLKGEN_INTRPTSET_ACC_Pos          (1UL)                     /*!< ACC (Bit 1)                                           */
#define CLKGEN_INTRPTSET_ACC_Msk          (0x2UL)                   /*!< ACC (Bitfield-Mask: 0x01)                             */
#define CLKGEN_INTRPTSET_ACF_Pos          (0UL)                     /*!< ACF (Bit 0)                                           */
#define CLKGEN_INTRPTSET_ACF_Msk          (0x1UL)                   /*!< ACF (Bitfield-Mask: 0x01)                             */


/* =========================================================================================================================== */
/* ================                                          CTIMER                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  TMR0  ========================================================== */
#define CTIMER_TMR0_CTTMRB0_Pos           (16UL)                    /*!< CTTMRB0 (Bit 16)                                      */
#define CTIMER_TMR0_CTTMRB0_Msk           (0xffff0000UL)            /*!< CTTMRB0 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_TMR0_CTTMRA0_Pos           (0UL)                     /*!< CTTMRA0 (Bit 0)                                       */
#define CTIMER_TMR0_CTTMRA0_Msk           (0xffffUL)                /*!< CTTMRA0 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRA0  ========================================================= */
#define CTIMER_CMPRA0_CMPR1A0_Pos         (16UL)                    /*!< CMPR1A0 (Bit 16)                                      */
#define CTIMER_CMPRA0_CMPR1A0_Msk         (0xffff0000UL)            /*!< CMPR1A0 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRA0_CMPR0A0_Pos         (0UL)                     /*!< CMPR0A0 (Bit 0)                                       */
#define CTIMER_CMPRA0_CMPR0A0_Msk         (0xffffUL)                /*!< CMPR0A0 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRB0  ========================================================= */
#define CTIMER_CMPRB0_CMPR1B0_Pos         (16UL)                    /*!< CMPR1B0 (Bit 16)                                      */
#define CTIMER_CMPRB0_CMPR1B0_Msk         (0xffff0000UL)            /*!< CMPR1B0 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRB0_CMPR0B0_Pos         (0UL)                     /*!< CMPR0B0 (Bit 0)                                       */
#define CTIMER_CMPRB0_CMPR0B0_Msk         (0xffffUL)                /*!< CMPR0B0 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  CTRL0  ========================================================= */
#define CTIMER_CTRL0_CTLINK0_Pos          (31UL)                    /*!< CTLINK0 (Bit 31)                                      */
#define CTIMER_CTRL0_CTLINK0_Msk          (0x80000000UL)            /*!< CTLINK0 (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL0_TMRB0POL_Pos         (28UL)                    /*!< TMRB0POL (Bit 28)                                     */
#define CTIMER_CTRL0_TMRB0POL_Msk         (0x10000000UL)            /*!< TMRB0POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRB0CLR_Pos         (27UL)                    /*!< TMRB0CLR (Bit 27)                                     */
#define CTIMER_CTRL0_TMRB0CLR_Msk         (0x8000000UL)             /*!< TMRB0CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRB0IE1_Pos         (26UL)                    /*!< TMRB0IE1 (Bit 26)                                     */
#define CTIMER_CTRL0_TMRB0IE1_Msk         (0x4000000UL)             /*!< TMRB0IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRB0IE0_Pos         (25UL)                    /*!< TMRB0IE0 (Bit 25)                                     */
#define CTIMER_CTRL0_TMRB0IE0_Msk         (0x2000000UL)             /*!< TMRB0IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRB0FN_Pos          (22UL)                    /*!< TMRB0FN (Bit 22)                                      */
#define CTIMER_CTRL0_TMRB0FN_Msk          (0x1c00000UL)             /*!< TMRB0FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL0_TMRB0CLK_Pos         (17UL)                    /*!< TMRB0CLK (Bit 17)                                     */
#define CTIMER_CTRL0_TMRB0CLK_Msk         (0x3e0000UL)              /*!< TMRB0CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL0_TMRB0EN_Pos          (16UL)                    /*!< TMRB0EN (Bit 16)                                      */
#define CTIMER_CTRL0_TMRB0EN_Msk          (0x10000UL)               /*!< TMRB0EN (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL0_TMRA0POL_Pos         (12UL)                    /*!< TMRA0POL (Bit 12)                                     */
#define CTIMER_CTRL0_TMRA0POL_Msk         (0x1000UL)                /*!< TMRA0POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRA0CLR_Pos         (11UL)                    /*!< TMRA0CLR (Bit 11)                                     */
#define CTIMER_CTRL0_TMRA0CLR_Msk         (0x800UL)                 /*!< TMRA0CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRA0IE1_Pos         (10UL)                    /*!< TMRA0IE1 (Bit 10)                                     */
#define CTIMER_CTRL0_TMRA0IE1_Msk         (0x400UL)                 /*!< TMRA0IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRA0IE0_Pos         (9UL)                     /*!< TMRA0IE0 (Bit 9)                                      */
#define CTIMER_CTRL0_TMRA0IE0_Msk         (0x200UL)                 /*!< TMRA0IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL0_TMRA0FN_Pos          (6UL)                     /*!< TMRA0FN (Bit 6)                                       */
#define CTIMER_CTRL0_TMRA0FN_Msk          (0x1c0UL)                 /*!< TMRA0FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL0_TMRA0CLK_Pos         (1UL)                     /*!< TMRA0CLK (Bit 1)                                      */
#define CTIMER_CTRL0_TMRA0CLK_Msk         (0x3eUL)                  /*!< TMRA0CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL0_TMRA0EN_Pos          (0UL)                     /*!< TMRA0EN (Bit 0)                                       */
#define CTIMER_CTRL0_TMRA0EN_Msk          (0x1UL)                   /*!< TMRA0EN (Bitfield-Mask: 0x01)                         */
/* =======================================================  CMPRAUXA0  ======================================================= */
#define CTIMER_CMPRAUXA0_CMPR3A0_Pos      (16UL)                    /*!< CMPR3A0 (Bit 16)                                      */
#define CTIMER_CMPRAUXA0_CMPR3A0_Msk      (0xffff0000UL)            /*!< CMPR3A0 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXA0_CMPR2A0_Pos      (0UL)                     /*!< CMPR2A0 (Bit 0)                                       */
#define CTIMER_CMPRAUXA0_CMPR2A0_Msk      (0xffffUL)                /*!< CMPR2A0 (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CMPRAUXB0  ======================================================= */
#define CTIMER_CMPRAUXB0_CMPR3B0_Pos      (16UL)                    /*!< CMPR3B0 (Bit 16)                                      */
#define CTIMER_CMPRAUXB0_CMPR3B0_Msk      (0xffff0000UL)            /*!< CMPR3B0 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXB0_CMPR2B0_Pos      (0UL)                     /*!< CMPR2B0 (Bit 0)                                       */
#define CTIMER_CMPRAUXB0_CMPR2B0_Msk      (0xffffUL)                /*!< CMPR2B0 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  AUX0  ========================================================== */
#define CTIMER_AUX0_TMRB0EN23_Pos         (30UL)                    /*!< TMRB0EN23 (Bit 30)                                    */
#define CTIMER_AUX0_TMRB0EN23_Msk         (0x40000000UL)            /*!< TMRB0EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX0_TMRB0POL23_Pos        (29UL)                    /*!< TMRB0POL23 (Bit 29)                                   */
#define CTIMER_AUX0_TMRB0POL23_Msk        (0x20000000UL)            /*!< TMRB0POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX0_TMRB0TINV_Pos         (28UL)                    /*!< TMRB0TINV (Bit 28)                                    */
#define CTIMER_AUX0_TMRB0TINV_Msk         (0x10000000UL)            /*!< TMRB0TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX0_TMRB0NOSYNC_Pos       (27UL)                    /*!< TMRB0NOSYNC (Bit 27)                                  */
#define CTIMER_AUX0_TMRB0NOSYNC_Msk       (0x8000000UL)             /*!< TMRB0NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX0_TMRB0TRIG_Pos         (23UL)                    /*!< TMRB0TRIG (Bit 23)                                    */
#define CTIMER_AUX0_TMRB0TRIG_Msk         (0x7800000UL)             /*!< TMRB0TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX0_TMRB0LMT_Pos          (16UL)                    /*!< TMRB0LMT (Bit 16)                                     */
#define CTIMER_AUX0_TMRB0LMT_Msk          (0x3f0000UL)              /*!< TMRB0LMT (Bitfield-Mask: 0x3f)                        */
#define CTIMER_AUX0_TMRA0EN23_Pos         (14UL)                    /*!< TMRA0EN23 (Bit 14)                                    */
#define CTIMER_AUX0_TMRA0EN23_Msk         (0x4000UL)                /*!< TMRA0EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX0_TMRA0POL23_Pos        (13UL)                    /*!< TMRA0POL23 (Bit 13)                                   */
#define CTIMER_AUX0_TMRA0POL23_Msk        (0x2000UL)                /*!< TMRA0POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX0_TMRA0TINV_Pos         (12UL)                    /*!< TMRA0TINV (Bit 12)                                    */
#define CTIMER_AUX0_TMRA0TINV_Msk         (0x1000UL)                /*!< TMRA0TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX0_TMRA0NOSYNC_Pos       (11UL)                    /*!< TMRA0NOSYNC (Bit 11)                                  */
#define CTIMER_AUX0_TMRA0NOSYNC_Msk       (0x800UL)                 /*!< TMRA0NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX0_TMRA0TRIG_Pos         (7UL)                     /*!< TMRA0TRIG (Bit 7)                                     */
#define CTIMER_AUX0_TMRA0TRIG_Msk         (0x780UL)                 /*!< TMRA0TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX0_TMRA0LMT_Pos          (0UL)                     /*!< TMRA0LMT (Bit 0)                                      */
#define CTIMER_AUX0_TMRA0LMT_Msk          (0x7fUL)                  /*!< TMRA0LMT (Bitfield-Mask: 0x7f)                        */
/* =========================================================  TMR1  ========================================================== */
#define CTIMER_TMR1_CTTMRB1_Pos           (16UL)                    /*!< CTTMRB1 (Bit 16)                                      */
#define CTIMER_TMR1_CTTMRB1_Msk           (0xffff0000UL)            /*!< CTTMRB1 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_TMR1_CTTMRA1_Pos           (0UL)                     /*!< CTTMRA1 (Bit 0)                                       */
#define CTIMER_TMR1_CTTMRA1_Msk           (0xffffUL)                /*!< CTTMRA1 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRA1  ========================================================= */
#define CTIMER_CMPRA1_CMPR1A1_Pos         (16UL)                    /*!< CMPR1A1 (Bit 16)                                      */
#define CTIMER_CMPRA1_CMPR1A1_Msk         (0xffff0000UL)            /*!< CMPR1A1 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRA1_CMPR0A1_Pos         (0UL)                     /*!< CMPR0A1 (Bit 0)                                       */
#define CTIMER_CMPRA1_CMPR0A1_Msk         (0xffffUL)                /*!< CMPR0A1 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRB1  ========================================================= */
#define CTIMER_CMPRB1_CMPR1B1_Pos         (16UL)                    /*!< CMPR1B1 (Bit 16)                                      */
#define CTIMER_CMPRB1_CMPR1B1_Msk         (0xffff0000UL)            /*!< CMPR1B1 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRB1_CMPR0B1_Pos         (0UL)                     /*!< CMPR0B1 (Bit 0)                                       */
#define CTIMER_CMPRB1_CMPR0B1_Msk         (0xffffUL)                /*!< CMPR0B1 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  CTRL1  ========================================================= */
#define CTIMER_CTRL1_CTLINK1_Pos          (31UL)                    /*!< CTLINK1 (Bit 31)                                      */
#define CTIMER_CTRL1_CTLINK1_Msk          (0x80000000UL)            /*!< CTLINK1 (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL1_TMRB1POL_Pos         (28UL)                    /*!< TMRB1POL (Bit 28)                                     */
#define CTIMER_CTRL1_TMRB1POL_Msk         (0x10000000UL)            /*!< TMRB1POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRB1CLR_Pos         (27UL)                    /*!< TMRB1CLR (Bit 27)                                     */
#define CTIMER_CTRL1_TMRB1CLR_Msk         (0x8000000UL)             /*!< TMRB1CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRB1IE1_Pos         (26UL)                    /*!< TMRB1IE1 (Bit 26)                                     */
#define CTIMER_CTRL1_TMRB1IE1_Msk         (0x4000000UL)             /*!< TMRB1IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRB1IE0_Pos         (25UL)                    /*!< TMRB1IE0 (Bit 25)                                     */
#define CTIMER_CTRL1_TMRB1IE0_Msk         (0x2000000UL)             /*!< TMRB1IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRB1FN_Pos          (22UL)                    /*!< TMRB1FN (Bit 22)                                      */
#define CTIMER_CTRL1_TMRB1FN_Msk          (0x1c00000UL)             /*!< TMRB1FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL1_TMRB1CLK_Pos         (17UL)                    /*!< TMRB1CLK (Bit 17)                                     */
#define CTIMER_CTRL1_TMRB1CLK_Msk         (0x3e0000UL)              /*!< TMRB1CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL1_TMRB1EN_Pos          (16UL)                    /*!< TMRB1EN (Bit 16)                                      */
#define CTIMER_CTRL1_TMRB1EN_Msk          (0x10000UL)               /*!< TMRB1EN (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL1_TMRA1POL_Pos         (12UL)                    /*!< TMRA1POL (Bit 12)                                     */
#define CTIMER_CTRL1_TMRA1POL_Msk         (0x1000UL)                /*!< TMRA1POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRA1CLR_Pos         (11UL)                    /*!< TMRA1CLR (Bit 11)                                     */
#define CTIMER_CTRL1_TMRA1CLR_Msk         (0x800UL)                 /*!< TMRA1CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRA1IE1_Pos         (10UL)                    /*!< TMRA1IE1 (Bit 10)                                     */
#define CTIMER_CTRL1_TMRA1IE1_Msk         (0x400UL)                 /*!< TMRA1IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRA1IE0_Pos         (9UL)                     /*!< TMRA1IE0 (Bit 9)                                      */
#define CTIMER_CTRL1_TMRA1IE0_Msk         (0x200UL)                 /*!< TMRA1IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL1_TMRA1FN_Pos          (6UL)                     /*!< TMRA1FN (Bit 6)                                       */
#define CTIMER_CTRL1_TMRA1FN_Msk          (0x1c0UL)                 /*!< TMRA1FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL1_TMRA1CLK_Pos         (1UL)                     /*!< TMRA1CLK (Bit 1)                                      */
#define CTIMER_CTRL1_TMRA1CLK_Msk         (0x3eUL)                  /*!< TMRA1CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL1_TMRA1EN_Pos          (0UL)                     /*!< TMRA1EN (Bit 0)                                       */
#define CTIMER_CTRL1_TMRA1EN_Msk          (0x1UL)                   /*!< TMRA1EN (Bitfield-Mask: 0x01)                         */
/* =======================================================  CMPRAUXA1  ======================================================= */
#define CTIMER_CMPRAUXA1_CMPR3A1_Pos      (16UL)                    /*!< CMPR3A1 (Bit 16)                                      */
#define CTIMER_CMPRAUXA1_CMPR3A1_Msk      (0xffff0000UL)            /*!< CMPR3A1 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXA1_CMPR2A1_Pos      (0UL)                     /*!< CMPR2A1 (Bit 0)                                       */
#define CTIMER_CMPRAUXA1_CMPR2A1_Msk      (0xffffUL)                /*!< CMPR2A1 (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CMPRAUXB1  ======================================================= */
#define CTIMER_CMPRAUXB1_CMPR3B1_Pos      (16UL)                    /*!< CMPR3B1 (Bit 16)                                      */
#define CTIMER_CMPRAUXB1_CMPR3B1_Msk      (0xffff0000UL)            /*!< CMPR3B1 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXB1_CMPR2B1_Pos      (0UL)                     /*!< CMPR2B1 (Bit 0)                                       */
#define CTIMER_CMPRAUXB1_CMPR2B1_Msk      (0xffffUL)                /*!< CMPR2B1 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  AUX1  ========================================================== */
#define CTIMER_AUX1_TMRB1EN23_Pos         (30UL)                    /*!< TMRB1EN23 (Bit 30)                                    */
#define CTIMER_AUX1_TMRB1EN23_Msk         (0x40000000UL)            /*!< TMRB1EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX1_TMRB1POL23_Pos        (29UL)                    /*!< TMRB1POL23 (Bit 29)                                   */
#define CTIMER_AUX1_TMRB1POL23_Msk        (0x20000000UL)            /*!< TMRB1POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX1_TMRB1TINV_Pos         (28UL)                    /*!< TMRB1TINV (Bit 28)                                    */
#define CTIMER_AUX1_TMRB1TINV_Msk         (0x10000000UL)            /*!< TMRB1TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX1_TMRB1NOSYNC_Pos       (27UL)                    /*!< TMRB1NOSYNC (Bit 27)                                  */
#define CTIMER_AUX1_TMRB1NOSYNC_Msk       (0x8000000UL)             /*!< TMRB1NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX1_TMRB1TRIG_Pos         (23UL)                    /*!< TMRB1TRIG (Bit 23)                                    */
#define CTIMER_AUX1_TMRB1TRIG_Msk         (0x7800000UL)             /*!< TMRB1TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX1_TMRB1LMT_Pos          (16UL)                    /*!< TMRB1LMT (Bit 16)                                     */
#define CTIMER_AUX1_TMRB1LMT_Msk          (0x3f0000UL)              /*!< TMRB1LMT (Bitfield-Mask: 0x3f)                        */
#define CTIMER_AUX1_TMRA1EN23_Pos         (14UL)                    /*!< TMRA1EN23 (Bit 14)                                    */
#define CTIMER_AUX1_TMRA1EN23_Msk         (0x4000UL)                /*!< TMRA1EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX1_TMRA1POL23_Pos        (13UL)                    /*!< TMRA1POL23 (Bit 13)                                   */
#define CTIMER_AUX1_TMRA1POL23_Msk        (0x2000UL)                /*!< TMRA1POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX1_TMRA1TINV_Pos         (12UL)                    /*!< TMRA1TINV (Bit 12)                                    */
#define CTIMER_AUX1_TMRA1TINV_Msk         (0x1000UL)                /*!< TMRA1TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX1_TMRA1NOSYNC_Pos       (11UL)                    /*!< TMRA1NOSYNC (Bit 11)                                  */
#define CTIMER_AUX1_TMRA1NOSYNC_Msk       (0x800UL)                 /*!< TMRA1NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX1_TMRA1TRIG_Pos         (7UL)                     /*!< TMRA1TRIG (Bit 7)                                     */
#define CTIMER_AUX1_TMRA1TRIG_Msk         (0x780UL)                 /*!< TMRA1TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX1_TMRA1LMT_Pos          (0UL)                     /*!< TMRA1LMT (Bit 0)                                      */
#define CTIMER_AUX1_TMRA1LMT_Msk          (0x7fUL)                  /*!< TMRA1LMT (Bitfield-Mask: 0x7f)                        */
/* =========================================================  TMR2  ========================================================== */
#define CTIMER_TMR2_CTTMRB2_Pos           (16UL)                    /*!< CTTMRB2 (Bit 16)                                      */
#define CTIMER_TMR2_CTTMRB2_Msk           (0xffff0000UL)            /*!< CTTMRB2 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_TMR2_CTTMRA2_Pos           (0UL)                     /*!< CTTMRA2 (Bit 0)                                       */
#define CTIMER_TMR2_CTTMRA2_Msk           (0xffffUL)                /*!< CTTMRA2 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRA2  ========================================================= */
#define CTIMER_CMPRA2_CMPR1A2_Pos         (16UL)                    /*!< CMPR1A2 (Bit 16)                                      */
#define CTIMER_CMPRA2_CMPR1A2_Msk         (0xffff0000UL)            /*!< CMPR1A2 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRA2_CMPR0A2_Pos         (0UL)                     /*!< CMPR0A2 (Bit 0)                                       */
#define CTIMER_CMPRA2_CMPR0A2_Msk         (0xffffUL)                /*!< CMPR0A2 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRB2  ========================================================= */
#define CTIMER_CMPRB2_CMPR1B2_Pos         (16UL)                    /*!< CMPR1B2 (Bit 16)                                      */
#define CTIMER_CMPRB2_CMPR1B2_Msk         (0xffff0000UL)            /*!< CMPR1B2 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRB2_CMPR0B2_Pos         (0UL)                     /*!< CMPR0B2 (Bit 0)                                       */
#define CTIMER_CMPRB2_CMPR0B2_Msk         (0xffffUL)                /*!< CMPR0B2 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  CTRL2  ========================================================= */
#define CTIMER_CTRL2_CTLINK2_Pos          (31UL)                    /*!< CTLINK2 (Bit 31)                                      */
#define CTIMER_CTRL2_CTLINK2_Msk          (0x80000000UL)            /*!< CTLINK2 (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL2_TMRB2POL_Pos         (28UL)                    /*!< TMRB2POL (Bit 28)                                     */
#define CTIMER_CTRL2_TMRB2POL_Msk         (0x10000000UL)            /*!< TMRB2POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRB2CLR_Pos         (27UL)                    /*!< TMRB2CLR (Bit 27)                                     */
#define CTIMER_CTRL2_TMRB2CLR_Msk         (0x8000000UL)             /*!< TMRB2CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRB2IE1_Pos         (26UL)                    /*!< TMRB2IE1 (Bit 26)                                     */
#define CTIMER_CTRL2_TMRB2IE1_Msk         (0x4000000UL)             /*!< TMRB2IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRB2IE0_Pos         (25UL)                    /*!< TMRB2IE0 (Bit 25)                                     */
#define CTIMER_CTRL2_TMRB2IE0_Msk         (0x2000000UL)             /*!< TMRB2IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRB2FN_Pos          (22UL)                    /*!< TMRB2FN (Bit 22)                                      */
#define CTIMER_CTRL2_TMRB2FN_Msk          (0x1c00000UL)             /*!< TMRB2FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL2_TMRB2CLK_Pos         (17UL)                    /*!< TMRB2CLK (Bit 17)                                     */
#define CTIMER_CTRL2_TMRB2CLK_Msk         (0x3e0000UL)              /*!< TMRB2CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL2_TMRB2EN_Pos          (16UL)                    /*!< TMRB2EN (Bit 16)                                      */
#define CTIMER_CTRL2_TMRB2EN_Msk          (0x10000UL)               /*!< TMRB2EN (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL2_TMRA2POL_Pos         (12UL)                    /*!< TMRA2POL (Bit 12)                                     */
#define CTIMER_CTRL2_TMRA2POL_Msk         (0x1000UL)                /*!< TMRA2POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRA2CLR_Pos         (11UL)                    /*!< TMRA2CLR (Bit 11)                                     */
#define CTIMER_CTRL2_TMRA2CLR_Msk         (0x800UL)                 /*!< TMRA2CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRA2IE1_Pos         (10UL)                    /*!< TMRA2IE1 (Bit 10)                                     */
#define CTIMER_CTRL2_TMRA2IE1_Msk         (0x400UL)                 /*!< TMRA2IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRA2IE0_Pos         (9UL)                     /*!< TMRA2IE0 (Bit 9)                                      */
#define CTIMER_CTRL2_TMRA2IE0_Msk         (0x200UL)                 /*!< TMRA2IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL2_TMRA2FN_Pos          (6UL)                     /*!< TMRA2FN (Bit 6)                                       */
#define CTIMER_CTRL2_TMRA2FN_Msk          (0x1c0UL)                 /*!< TMRA2FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL2_TMRA2CLK_Pos         (1UL)                     /*!< TMRA2CLK (Bit 1)                                      */
#define CTIMER_CTRL2_TMRA2CLK_Msk         (0x3eUL)                  /*!< TMRA2CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL2_TMRA2EN_Pos          (0UL)                     /*!< TMRA2EN (Bit 0)                                       */
#define CTIMER_CTRL2_TMRA2EN_Msk          (0x1UL)                   /*!< TMRA2EN (Bitfield-Mask: 0x01)                         */
/* =======================================================  CMPRAUXA2  ======================================================= */
#define CTIMER_CMPRAUXA2_CMPR3A2_Pos      (16UL)                    /*!< CMPR3A2 (Bit 16)                                      */
#define CTIMER_CMPRAUXA2_CMPR3A2_Msk      (0xffff0000UL)            /*!< CMPR3A2 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXA2_CMPR2A2_Pos      (0UL)                     /*!< CMPR2A2 (Bit 0)                                       */
#define CTIMER_CMPRAUXA2_CMPR2A2_Msk      (0xffffUL)                /*!< CMPR2A2 (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CMPRAUXB2  ======================================================= */
#define CTIMER_CMPRAUXB2_CMPR3B2_Pos      (16UL)                    /*!< CMPR3B2 (Bit 16)                                      */
#define CTIMER_CMPRAUXB2_CMPR3B2_Msk      (0xffff0000UL)            /*!< CMPR3B2 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXB2_CMPR2B2_Pos      (0UL)                     /*!< CMPR2B2 (Bit 0)                                       */
#define CTIMER_CMPRAUXB2_CMPR2B2_Msk      (0xffffUL)                /*!< CMPR2B2 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  AUX2  ========================================================== */
#define CTIMER_AUX2_TMRB2EN23_Pos         (30UL)                    /*!< TMRB2EN23 (Bit 30)                                    */
#define CTIMER_AUX2_TMRB2EN23_Msk         (0x40000000UL)            /*!< TMRB2EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX2_TMRB2POL23_Pos        (29UL)                    /*!< TMRB2POL23 (Bit 29)                                   */
#define CTIMER_AUX2_TMRB2POL23_Msk        (0x20000000UL)            /*!< TMRB2POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX2_TMRB2TINV_Pos         (28UL)                    /*!< TMRB2TINV (Bit 28)                                    */
#define CTIMER_AUX2_TMRB2TINV_Msk         (0x10000000UL)            /*!< TMRB2TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX2_TMRB2NOSYNC_Pos       (27UL)                    /*!< TMRB2NOSYNC (Bit 27)                                  */
#define CTIMER_AUX2_TMRB2NOSYNC_Msk       (0x8000000UL)             /*!< TMRB2NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX2_TMRB2TRIG_Pos         (23UL)                    /*!< TMRB2TRIG (Bit 23)                                    */
#define CTIMER_AUX2_TMRB2TRIG_Msk         (0x7800000UL)             /*!< TMRB2TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX2_TMRB2LMT_Pos          (16UL)                    /*!< TMRB2LMT (Bit 16)                                     */
#define CTIMER_AUX2_TMRB2LMT_Msk          (0x3f0000UL)              /*!< TMRB2LMT (Bitfield-Mask: 0x3f)                        */
#define CTIMER_AUX2_TMRA2EN23_Pos         (14UL)                    /*!< TMRA2EN23 (Bit 14)                                    */
#define CTIMER_AUX2_TMRA2EN23_Msk         (0x4000UL)                /*!< TMRA2EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX2_TMRA2POL23_Pos        (13UL)                    /*!< TMRA2POL23 (Bit 13)                                   */
#define CTIMER_AUX2_TMRA2POL23_Msk        (0x2000UL)                /*!< TMRA2POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX2_TMRA2TINV_Pos         (12UL)                    /*!< TMRA2TINV (Bit 12)                                    */
#define CTIMER_AUX2_TMRA2TINV_Msk         (0x1000UL)                /*!< TMRA2TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX2_TMRA2NOSYNC_Pos       (11UL)                    /*!< TMRA2NOSYNC (Bit 11)                                  */
#define CTIMER_AUX2_TMRA2NOSYNC_Msk       (0x800UL)                 /*!< TMRA2NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX2_TMRA2TRIG_Pos         (7UL)                     /*!< TMRA2TRIG (Bit 7)                                     */
#define CTIMER_AUX2_TMRA2TRIG_Msk         (0x780UL)                 /*!< TMRA2TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX2_TMRA2LMT_Pos          (0UL)                     /*!< TMRA2LMT (Bit 0)                                      */
#define CTIMER_AUX2_TMRA2LMT_Msk          (0x7fUL)                  /*!< TMRA2LMT (Bitfield-Mask: 0x7f)                        */
/* =========================================================  TMR3  ========================================================== */
#define CTIMER_TMR3_CTTMRB3_Pos           (16UL)                    /*!< CTTMRB3 (Bit 16)                                      */
#define CTIMER_TMR3_CTTMRB3_Msk           (0xffff0000UL)            /*!< CTTMRB3 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_TMR3_CTTMRA3_Pos           (0UL)                     /*!< CTTMRA3 (Bit 0)                                       */
#define CTIMER_TMR3_CTTMRA3_Msk           (0xffffUL)                /*!< CTTMRA3 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRA3  ========================================================= */
#define CTIMER_CMPRA3_CMPR1A3_Pos         (16UL)                    /*!< CMPR1A3 (Bit 16)                                      */
#define CTIMER_CMPRA3_CMPR1A3_Msk         (0xffff0000UL)            /*!< CMPR1A3 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRA3_CMPR0A3_Pos         (0UL)                     /*!< CMPR0A3 (Bit 0)                                       */
#define CTIMER_CMPRA3_CMPR0A3_Msk         (0xffffUL)                /*!< CMPR0A3 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRB3  ========================================================= */
#define CTIMER_CMPRB3_CMPR1B3_Pos         (16UL)                    /*!< CMPR1B3 (Bit 16)                                      */
#define CTIMER_CMPRB3_CMPR1B3_Msk         (0xffff0000UL)            /*!< CMPR1B3 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRB3_CMPR0B3_Pos         (0UL)                     /*!< CMPR0B3 (Bit 0)                                       */
#define CTIMER_CMPRB3_CMPR0B3_Msk         (0xffffUL)                /*!< CMPR0B3 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  CTRL3  ========================================================= */
#define CTIMER_CTRL3_CTLINK3_Pos          (31UL)                    /*!< CTLINK3 (Bit 31)                                      */
#define CTIMER_CTRL3_CTLINK3_Msk          (0x80000000UL)            /*!< CTLINK3 (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL3_TMRB3POL_Pos         (28UL)                    /*!< TMRB3POL (Bit 28)                                     */
#define CTIMER_CTRL3_TMRB3POL_Msk         (0x10000000UL)            /*!< TMRB3POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRB3CLR_Pos         (27UL)                    /*!< TMRB3CLR (Bit 27)                                     */
#define CTIMER_CTRL3_TMRB3CLR_Msk         (0x8000000UL)             /*!< TMRB3CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRB3IE1_Pos         (26UL)                    /*!< TMRB3IE1 (Bit 26)                                     */
#define CTIMER_CTRL3_TMRB3IE1_Msk         (0x4000000UL)             /*!< TMRB3IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRB3IE0_Pos         (25UL)                    /*!< TMRB3IE0 (Bit 25)                                     */
#define CTIMER_CTRL3_TMRB3IE0_Msk         (0x2000000UL)             /*!< TMRB3IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRB3FN_Pos          (22UL)                    /*!< TMRB3FN (Bit 22)                                      */
#define CTIMER_CTRL3_TMRB3FN_Msk          (0x1c00000UL)             /*!< TMRB3FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL3_TMRB3CLK_Pos         (17UL)                    /*!< TMRB3CLK (Bit 17)                                     */
#define CTIMER_CTRL3_TMRB3CLK_Msk         (0x3e0000UL)              /*!< TMRB3CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL3_TMRB3EN_Pos          (16UL)                    /*!< TMRB3EN (Bit 16)                                      */
#define CTIMER_CTRL3_TMRB3EN_Msk          (0x10000UL)               /*!< TMRB3EN (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL3_ADCEN_Pos            (15UL)                    /*!< ADCEN (Bit 15)                                        */
#define CTIMER_CTRL3_ADCEN_Msk            (0x8000UL)                /*!< ADCEN (Bitfield-Mask: 0x01)                           */
#define CTIMER_CTRL3_TMRA3POL_Pos         (12UL)                    /*!< TMRA3POL (Bit 12)                                     */
#define CTIMER_CTRL3_TMRA3POL_Msk         (0x1000UL)                /*!< TMRA3POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRA3CLR_Pos         (11UL)                    /*!< TMRA3CLR (Bit 11)                                     */
#define CTIMER_CTRL3_TMRA3CLR_Msk         (0x800UL)                 /*!< TMRA3CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRA3IE1_Pos         (10UL)                    /*!< TMRA3IE1 (Bit 10)                                     */
#define CTIMER_CTRL3_TMRA3IE1_Msk         (0x400UL)                 /*!< TMRA3IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRA3IE0_Pos         (9UL)                     /*!< TMRA3IE0 (Bit 9)                                      */
#define CTIMER_CTRL3_TMRA3IE0_Msk         (0x200UL)                 /*!< TMRA3IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL3_TMRA3FN_Pos          (6UL)                     /*!< TMRA3FN (Bit 6)                                       */
#define CTIMER_CTRL3_TMRA3FN_Msk          (0x1c0UL)                 /*!< TMRA3FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL3_TMRA3CLK_Pos         (1UL)                     /*!< TMRA3CLK (Bit 1)                                      */
#define CTIMER_CTRL3_TMRA3CLK_Msk         (0x3eUL)                  /*!< TMRA3CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL3_TMRA3EN_Pos          (0UL)                     /*!< TMRA3EN (Bit 0)                                       */
#define CTIMER_CTRL3_TMRA3EN_Msk          (0x1UL)                   /*!< TMRA3EN (Bitfield-Mask: 0x01)                         */
/* =======================================================  CMPRAUXA3  ======================================================= */
#define CTIMER_CMPRAUXA3_CMPR3A3_Pos      (16UL)                    /*!< CMPR3A3 (Bit 16)                                      */
#define CTIMER_CMPRAUXA3_CMPR3A3_Msk      (0xffff0000UL)            /*!< CMPR3A3 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXA3_CMPR2A3_Pos      (0UL)                     /*!< CMPR2A3 (Bit 0)                                       */
#define CTIMER_CMPRAUXA3_CMPR2A3_Msk      (0xffffUL)                /*!< CMPR2A3 (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CMPRAUXB3  ======================================================= */
#define CTIMER_CMPRAUXB3_CMPR3B3_Pos      (16UL)                    /*!< CMPR3B3 (Bit 16)                                      */
#define CTIMER_CMPRAUXB3_CMPR3B3_Msk      (0xffff0000UL)            /*!< CMPR3B3 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXB3_CMPR2B3_Pos      (0UL)                     /*!< CMPR2B3 (Bit 0)                                       */
#define CTIMER_CMPRAUXB3_CMPR2B3_Msk      (0xffffUL)                /*!< CMPR2B3 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  AUX3  ========================================================== */
#define CTIMER_AUX3_TMRB3EN23_Pos         (30UL)                    /*!< TMRB3EN23 (Bit 30)                                    */
#define CTIMER_AUX3_TMRB3EN23_Msk         (0x40000000UL)            /*!< TMRB3EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX3_TMRB3POL23_Pos        (29UL)                    /*!< TMRB3POL23 (Bit 29)                                   */
#define CTIMER_AUX3_TMRB3POL23_Msk        (0x20000000UL)            /*!< TMRB3POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX3_TMRB3TINV_Pos         (28UL)                    /*!< TMRB3TINV (Bit 28)                                    */
#define CTIMER_AUX3_TMRB3TINV_Msk         (0x10000000UL)            /*!< TMRB3TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX3_TMRB3NOSYNC_Pos       (27UL)                    /*!< TMRB3NOSYNC (Bit 27)                                  */
#define CTIMER_AUX3_TMRB3NOSYNC_Msk       (0x8000000UL)             /*!< TMRB3NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX3_TMRB3TRIG_Pos         (23UL)                    /*!< TMRB3TRIG (Bit 23)                                    */
#define CTIMER_AUX3_TMRB3TRIG_Msk         (0x7800000UL)             /*!< TMRB3TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX3_TMRB3LMT_Pos          (16UL)                    /*!< TMRB3LMT (Bit 16)                                     */
#define CTIMER_AUX3_TMRB3LMT_Msk          (0x3f0000UL)              /*!< TMRB3LMT (Bitfield-Mask: 0x3f)                        */
#define CTIMER_AUX3_TMRA3EN23_Pos         (14UL)                    /*!< TMRA3EN23 (Bit 14)                                    */
#define CTIMER_AUX3_TMRA3EN23_Msk         (0x4000UL)                /*!< TMRA3EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX3_TMRA3POL23_Pos        (13UL)                    /*!< TMRA3POL23 (Bit 13)                                   */
#define CTIMER_AUX3_TMRA3POL23_Msk        (0x2000UL)                /*!< TMRA3POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX3_TMRA3TINV_Pos         (12UL)                    /*!< TMRA3TINV (Bit 12)                                    */
#define CTIMER_AUX3_TMRA3TINV_Msk         (0x1000UL)                /*!< TMRA3TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX3_TMRA3NOSYNC_Pos       (11UL)                    /*!< TMRA3NOSYNC (Bit 11)                                  */
#define CTIMER_AUX3_TMRA3NOSYNC_Msk       (0x800UL)                 /*!< TMRA3NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX3_TMRA3TRIG_Pos         (7UL)                     /*!< TMRA3TRIG (Bit 7)                                     */
#define CTIMER_AUX3_TMRA3TRIG_Msk         (0x780UL)                 /*!< TMRA3TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX3_TMRA3LMT_Pos          (0UL)                     /*!< TMRA3LMT (Bit 0)                                      */
#define CTIMER_AUX3_TMRA3LMT_Msk          (0x7fUL)                  /*!< TMRA3LMT (Bitfield-Mask: 0x7f)                        */
/* =========================================================  TMR4  ========================================================== */
#define CTIMER_TMR4_CTTMRB4_Pos           (16UL)                    /*!< CTTMRB4 (Bit 16)                                      */
#define CTIMER_TMR4_CTTMRB4_Msk           (0xffff0000UL)            /*!< CTTMRB4 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_TMR4_CTTMRA4_Pos           (0UL)                     /*!< CTTMRA4 (Bit 0)                                       */
#define CTIMER_TMR4_CTTMRA4_Msk           (0xffffUL)                /*!< CTTMRA4 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRA4  ========================================================= */
#define CTIMER_CMPRA4_CMPR1A4_Pos         (16UL)                    /*!< CMPR1A4 (Bit 16)                                      */
#define CTIMER_CMPRA4_CMPR1A4_Msk         (0xffff0000UL)            /*!< CMPR1A4 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRA4_CMPR0A4_Pos         (0UL)                     /*!< CMPR0A4 (Bit 0)                                       */
#define CTIMER_CMPRA4_CMPR0A4_Msk         (0xffffUL)                /*!< CMPR0A4 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRB4  ========================================================= */
#define CTIMER_CMPRB4_CMPR1B4_Pos         (16UL)                    /*!< CMPR1B4 (Bit 16)                                      */
#define CTIMER_CMPRB4_CMPR1B4_Msk         (0xffff0000UL)            /*!< CMPR1B4 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRB4_CMPR0B4_Pos         (0UL)                     /*!< CMPR0B4 (Bit 0)                                       */
#define CTIMER_CMPRB4_CMPR0B4_Msk         (0xffffUL)                /*!< CMPR0B4 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  CTRL4  ========================================================= */
#define CTIMER_CTRL4_CTLINK4_Pos          (31UL)                    /*!< CTLINK4 (Bit 31)                                      */
#define CTIMER_CTRL4_CTLINK4_Msk          (0x80000000UL)            /*!< CTLINK4 (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL4_TMRB4POL_Pos         (28UL)                    /*!< TMRB4POL (Bit 28)                                     */
#define CTIMER_CTRL4_TMRB4POL_Msk         (0x10000000UL)            /*!< TMRB4POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL4_TMRB4CLR_Pos         (27UL)                    /*!< TMRB4CLR (Bit 27)                                     */
#define CTIMER_CTRL4_TMRB4CLR_Msk         (0x8000000UL)             /*!< TMRB4CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL4_TMRB4IE1_Pos         (26UL)                    /*!< TMRB4IE1 (Bit 26)                                     */
#define CTIMER_CTRL4_TMRB4IE1_Msk         (0x4000000UL)             /*!< TMRB4IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL4_TMRB4IE0_Pos         (25UL)                    /*!< TMRB4IE0 (Bit 25)                                     */
#define CTIMER_CTRL4_TMRB4IE0_Msk         (0x2000000UL)             /*!< TMRB4IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL4_TMRB4FN_Pos          (22UL)                    /*!< TMRB4FN (Bit 22)                                      */
#define CTIMER_CTRL4_TMRB4FN_Msk          (0x1c00000UL)             /*!< TMRB4FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL4_TMRB4CLK_Pos         (17UL)                    /*!< TMRB4CLK (Bit 17)                                     */
#define CTIMER_CTRL4_TMRB4CLK_Msk         (0x3e0000UL)              /*!< TMRB4CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL4_TMRB4EN_Pos          (16UL)                    /*!< TMRB4EN (Bit 16)                                      */
#define CTIMER_CTRL4_TMRB4EN_Msk          (0x10000UL)               /*!< TMRB4EN (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL4_TMRA4POL_Pos         (12UL)                    /*!< TMRA4POL (Bit 12)                                     */
#define CTIMER_CTRL4_TMRA4POL_Msk         (0x1000UL)                /*!< TMRA4POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL4_TMRA4CLR_Pos         (11UL)                    /*!< TMRA4CLR (Bit 11)                                     */
#define CTIMER_CTRL4_TMRA4CLR_Msk         (0x800UL)                 /*!< TMRA4CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL4_TMRA4IE1_Pos         (10UL)                    /*!< TMRA4IE1 (Bit 10)                                     */
#define CTIMER_CTRL4_TMRA4IE1_Msk         (0x400UL)                 /*!< TMRA4IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL4_TMRA4IE0_Pos         (9UL)                     /*!< TMRA4IE0 (Bit 9)                                      */
#define CTIMER_CTRL4_TMRA4IE0_Msk         (0x200UL)                 /*!< TMRA4IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL4_TMRA4FN_Pos          (6UL)                     /*!< TMRA4FN (Bit 6)                                       */
#define CTIMER_CTRL4_TMRA4FN_Msk          (0x1c0UL)                 /*!< TMRA4FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL4_TMRA4CLK_Pos         (1UL)                     /*!< TMRA4CLK (Bit 1)                                      */
#define CTIMER_CTRL4_TMRA4CLK_Msk         (0x3eUL)                  /*!< TMRA4CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL4_TMRA4EN_Pos          (0UL)                     /*!< TMRA4EN (Bit 0)                                       */
#define CTIMER_CTRL4_TMRA4EN_Msk          (0x1UL)                   /*!< TMRA4EN (Bitfield-Mask: 0x01)                         */
/* =======================================================  CMPRAUXA4  ======================================================= */
#define CTIMER_CMPRAUXA4_CMPR3A4_Pos      (16UL)                    /*!< CMPR3A4 (Bit 16)                                      */
#define CTIMER_CMPRAUXA4_CMPR3A4_Msk      (0xffff0000UL)            /*!< CMPR3A4 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXA4_CMPR2A4_Pos      (0UL)                     /*!< CMPR2A4 (Bit 0)                                       */
#define CTIMER_CMPRAUXA4_CMPR2A4_Msk      (0xffffUL)                /*!< CMPR2A4 (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CMPRAUXB4  ======================================================= */
#define CTIMER_CMPRAUXB4_CMPR3B4_Pos      (16UL)                    /*!< CMPR3B4 (Bit 16)                                      */
#define CTIMER_CMPRAUXB4_CMPR3B4_Msk      (0xffff0000UL)            /*!< CMPR3B4 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXB4_CMPR2B4_Pos      (0UL)                     /*!< CMPR2B4 (Bit 0)                                       */
#define CTIMER_CMPRAUXB4_CMPR2B4_Msk      (0xffffUL)                /*!< CMPR2B4 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  AUX4  ========================================================== */
#define CTIMER_AUX4_TMRB4EN23_Pos         (30UL)                    /*!< TMRB4EN23 (Bit 30)                                    */
#define CTIMER_AUX4_TMRB4EN23_Msk         (0x40000000UL)            /*!< TMRB4EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX4_TMRB4POL23_Pos        (29UL)                    /*!< TMRB4POL23 (Bit 29)                                   */
#define CTIMER_AUX4_TMRB4POL23_Msk        (0x20000000UL)            /*!< TMRB4POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX4_TMRB4TINV_Pos         (28UL)                    /*!< TMRB4TINV (Bit 28)                                    */
#define CTIMER_AUX4_TMRB4TINV_Msk         (0x10000000UL)            /*!< TMRB4TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX4_TMRB4NOSYNC_Pos       (27UL)                    /*!< TMRB4NOSYNC (Bit 27)                                  */
#define CTIMER_AUX4_TMRB4NOSYNC_Msk       (0x8000000UL)             /*!< TMRB4NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX4_TMRB4TRIG_Pos         (23UL)                    /*!< TMRB4TRIG (Bit 23)                                    */
#define CTIMER_AUX4_TMRB4TRIG_Msk         (0x7800000UL)             /*!< TMRB4TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX4_TMRB4LMT_Pos          (16UL)                    /*!< TMRB4LMT (Bit 16)                                     */
#define CTIMER_AUX4_TMRB4LMT_Msk          (0x3f0000UL)              /*!< TMRB4LMT (Bitfield-Mask: 0x3f)                        */
#define CTIMER_AUX4_TMRA4EN23_Pos         (14UL)                    /*!< TMRA4EN23 (Bit 14)                                    */
#define CTIMER_AUX4_TMRA4EN23_Msk         (0x4000UL)                /*!< TMRA4EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX4_TMRA4POL23_Pos        (13UL)                    /*!< TMRA4POL23 (Bit 13)                                   */
#define CTIMER_AUX4_TMRA4POL23_Msk        (0x2000UL)                /*!< TMRA4POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX4_TMRA4TINV_Pos         (12UL)                    /*!< TMRA4TINV (Bit 12)                                    */
#define CTIMER_AUX4_TMRA4TINV_Msk         (0x1000UL)                /*!< TMRA4TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX4_TMRA4NOSYNC_Pos       (11UL)                    /*!< TMRA4NOSYNC (Bit 11)                                  */
#define CTIMER_AUX4_TMRA4NOSYNC_Msk       (0x800UL)                 /*!< TMRA4NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX4_TMRA4TRIG_Pos         (7UL)                     /*!< TMRA4TRIG (Bit 7)                                     */
#define CTIMER_AUX4_TMRA4TRIG_Msk         (0x780UL)                 /*!< TMRA4TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX4_TMRA4LMT_Pos          (0UL)                     /*!< TMRA4LMT (Bit 0)                                      */
#define CTIMER_AUX4_TMRA4LMT_Msk          (0x7fUL)                  /*!< TMRA4LMT (Bitfield-Mask: 0x7f)                        */
/* =========================================================  TMR5  ========================================================== */
#define CTIMER_TMR5_CTTMRB5_Pos           (16UL)                    /*!< CTTMRB5 (Bit 16)                                      */
#define CTIMER_TMR5_CTTMRB5_Msk           (0xffff0000UL)            /*!< CTTMRB5 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_TMR5_CTTMRA5_Pos           (0UL)                     /*!< CTTMRA5 (Bit 0)                                       */
#define CTIMER_TMR5_CTTMRA5_Msk           (0xffffUL)                /*!< CTTMRA5 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRA5  ========================================================= */
#define CTIMER_CMPRA5_CMPR1A5_Pos         (16UL)                    /*!< CMPR1A5 (Bit 16)                                      */
#define CTIMER_CMPRA5_CMPR1A5_Msk         (0xffff0000UL)            /*!< CMPR1A5 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRA5_CMPR0A5_Pos         (0UL)                     /*!< CMPR0A5 (Bit 0)                                       */
#define CTIMER_CMPRA5_CMPR0A5_Msk         (0xffffUL)                /*!< CMPR0A5 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRB5  ========================================================= */
#define CTIMER_CMPRB5_CMPR1B5_Pos         (16UL)                    /*!< CMPR1B5 (Bit 16)                                      */
#define CTIMER_CMPRB5_CMPR1B5_Msk         (0xffff0000UL)            /*!< CMPR1B5 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRB5_CMPR0B5_Pos         (0UL)                     /*!< CMPR0B5 (Bit 0)                                       */
#define CTIMER_CMPRB5_CMPR0B5_Msk         (0xffffUL)                /*!< CMPR0B5 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  CTRL5  ========================================================= */
#define CTIMER_CTRL5_CTLINK5_Pos          (31UL)                    /*!< CTLINK5 (Bit 31)                                      */
#define CTIMER_CTRL5_CTLINK5_Msk          (0x80000000UL)            /*!< CTLINK5 (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL5_TMRB5POL_Pos         (28UL)                    /*!< TMRB5POL (Bit 28)                                     */
#define CTIMER_CTRL5_TMRB5POL_Msk         (0x10000000UL)            /*!< TMRB5POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL5_TMRB5CLR_Pos         (27UL)                    /*!< TMRB5CLR (Bit 27)                                     */
#define CTIMER_CTRL5_TMRB5CLR_Msk         (0x8000000UL)             /*!< TMRB5CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL5_TMRB5IE1_Pos         (26UL)                    /*!< TMRB5IE1 (Bit 26)                                     */
#define CTIMER_CTRL5_TMRB5IE1_Msk         (0x4000000UL)             /*!< TMRB5IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL5_TMRB5IE0_Pos         (25UL)                    /*!< TMRB5IE0 (Bit 25)                                     */
#define CTIMER_CTRL5_TMRB5IE0_Msk         (0x2000000UL)             /*!< TMRB5IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL5_TMRB5FN_Pos          (22UL)                    /*!< TMRB5FN (Bit 22)                                      */
#define CTIMER_CTRL5_TMRB5FN_Msk          (0x1c00000UL)             /*!< TMRB5FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL5_TMRB5CLK_Pos         (17UL)                    /*!< TMRB5CLK (Bit 17)                                     */
#define CTIMER_CTRL5_TMRB5CLK_Msk         (0x3e0000UL)              /*!< TMRB5CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL5_TMRB5EN_Pos          (16UL)                    /*!< TMRB5EN (Bit 16)                                      */
#define CTIMER_CTRL5_TMRB5EN_Msk          (0x10000UL)               /*!< TMRB5EN (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL5_TMRA5POL_Pos         (12UL)                    /*!< TMRA5POL (Bit 12)                                     */
#define CTIMER_CTRL5_TMRA5POL_Msk         (0x1000UL)                /*!< TMRA5POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL5_TMRA5CLR_Pos         (11UL)                    /*!< TMRA5CLR (Bit 11)                                     */
#define CTIMER_CTRL5_TMRA5CLR_Msk         (0x800UL)                 /*!< TMRA5CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL5_TMRA5IE1_Pos         (10UL)                    /*!< TMRA5IE1 (Bit 10)                                     */
#define CTIMER_CTRL5_TMRA5IE1_Msk         (0x400UL)                 /*!< TMRA5IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL5_TMRA5IE0_Pos         (9UL)                     /*!< TMRA5IE0 (Bit 9)                                      */
#define CTIMER_CTRL5_TMRA5IE0_Msk         (0x200UL)                 /*!< TMRA5IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL5_TMRA5FN_Pos          (6UL)                     /*!< TMRA5FN (Bit 6)                                       */
#define CTIMER_CTRL5_TMRA5FN_Msk          (0x1c0UL)                 /*!< TMRA5FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL5_TMRA5CLK_Pos         (1UL)                     /*!< TMRA5CLK (Bit 1)                                      */
#define CTIMER_CTRL5_TMRA5CLK_Msk         (0x3eUL)                  /*!< TMRA5CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL5_TMRA5EN_Pos          (0UL)                     /*!< TMRA5EN (Bit 0)                                       */
#define CTIMER_CTRL5_TMRA5EN_Msk          (0x1UL)                   /*!< TMRA5EN (Bitfield-Mask: 0x01)                         */
/* =======================================================  CMPRAUXA5  ======================================================= */
#define CTIMER_CMPRAUXA5_CMPR3A5_Pos      (16UL)                    /*!< CMPR3A5 (Bit 16)                                      */
#define CTIMER_CMPRAUXA5_CMPR3A5_Msk      (0xffff0000UL)            /*!< CMPR3A5 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXA5_CMPR2A5_Pos      (0UL)                     /*!< CMPR2A5 (Bit 0)                                       */
#define CTIMER_CMPRAUXA5_CMPR2A5_Msk      (0xffffUL)                /*!< CMPR2A5 (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CMPRAUXB5  ======================================================= */
#define CTIMER_CMPRAUXB5_CMPR3B5_Pos      (16UL)                    /*!< CMPR3B5 (Bit 16)                                      */
#define CTIMER_CMPRAUXB5_CMPR3B5_Msk      (0xffff0000UL)            /*!< CMPR3B5 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXB5_CMPR2B5_Pos      (0UL)                     /*!< CMPR2B5 (Bit 0)                                       */
#define CTIMER_CMPRAUXB5_CMPR2B5_Msk      (0xffffUL)                /*!< CMPR2B5 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  AUX5  ========================================================== */
#define CTIMER_AUX5_TMRB5EN23_Pos         (30UL)                    /*!< TMRB5EN23 (Bit 30)                                    */
#define CTIMER_AUX5_TMRB5EN23_Msk         (0x40000000UL)            /*!< TMRB5EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX5_TMRB5POL23_Pos        (29UL)                    /*!< TMRB5POL23 (Bit 29)                                   */
#define CTIMER_AUX5_TMRB5POL23_Msk        (0x20000000UL)            /*!< TMRB5POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX5_TMRB5TINV_Pos         (28UL)                    /*!< TMRB5TINV (Bit 28)                                    */
#define CTIMER_AUX5_TMRB5TINV_Msk         (0x10000000UL)            /*!< TMRB5TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX5_TMRB5NOSYNC_Pos       (27UL)                    /*!< TMRB5NOSYNC (Bit 27)                                  */
#define CTIMER_AUX5_TMRB5NOSYNC_Msk       (0x8000000UL)             /*!< TMRB5NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX5_TMRB5TRIG_Pos         (23UL)                    /*!< TMRB5TRIG (Bit 23)                                    */
#define CTIMER_AUX5_TMRB5TRIG_Msk         (0x7800000UL)             /*!< TMRB5TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX5_TMRB5LMT_Pos          (16UL)                    /*!< TMRB5LMT (Bit 16)                                     */
#define CTIMER_AUX5_TMRB5LMT_Msk          (0x3f0000UL)              /*!< TMRB5LMT (Bitfield-Mask: 0x3f)                        */
#define CTIMER_AUX5_TMRA5EN23_Pos         (14UL)                    /*!< TMRA5EN23 (Bit 14)                                    */
#define CTIMER_AUX5_TMRA5EN23_Msk         (0x4000UL)                /*!< TMRA5EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX5_TMRA5POL23_Pos        (13UL)                    /*!< TMRA5POL23 (Bit 13)                                   */
#define CTIMER_AUX5_TMRA5POL23_Msk        (0x2000UL)                /*!< TMRA5POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX5_TMRA5TINV_Pos         (12UL)                    /*!< TMRA5TINV (Bit 12)                                    */
#define CTIMER_AUX5_TMRA5TINV_Msk         (0x1000UL)                /*!< TMRA5TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX5_TMRA5NOSYNC_Pos       (11UL)                    /*!< TMRA5NOSYNC (Bit 11)                                  */
#define CTIMER_AUX5_TMRA5NOSYNC_Msk       (0x800UL)                 /*!< TMRA5NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX5_TMRA5TRIG_Pos         (7UL)                     /*!< TMRA5TRIG (Bit 7)                                     */
#define CTIMER_AUX5_TMRA5TRIG_Msk         (0x780UL)                 /*!< TMRA5TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX5_TMRA5LMT_Pos          (0UL)                     /*!< TMRA5LMT (Bit 0)                                      */
#define CTIMER_AUX5_TMRA5LMT_Msk          (0x7fUL)                  /*!< TMRA5LMT (Bitfield-Mask: 0x7f)                        */
/* =========================================================  TMR6  ========================================================== */
#define CTIMER_TMR6_CTTMRB6_Pos           (16UL)                    /*!< CTTMRB6 (Bit 16)                                      */
#define CTIMER_TMR6_CTTMRB6_Msk           (0xffff0000UL)            /*!< CTTMRB6 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_TMR6_CTTMRA6_Pos           (0UL)                     /*!< CTTMRA6 (Bit 0)                                       */
#define CTIMER_TMR6_CTTMRA6_Msk           (0xffffUL)                /*!< CTTMRA6 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRA6  ========================================================= */
#define CTIMER_CMPRA6_CMPR1A6_Pos         (16UL)                    /*!< CMPR1A6 (Bit 16)                                      */
#define CTIMER_CMPRA6_CMPR1A6_Msk         (0xffff0000UL)            /*!< CMPR1A6 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRA6_CMPR0A6_Pos         (0UL)                     /*!< CMPR0A6 (Bit 0)                                       */
#define CTIMER_CMPRA6_CMPR0A6_Msk         (0xffffUL)                /*!< CMPR0A6 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRB6  ========================================================= */
#define CTIMER_CMPRB6_CMPR1B6_Pos         (16UL)                    /*!< CMPR1B6 (Bit 16)                                      */
#define CTIMER_CMPRB6_CMPR1B6_Msk         (0xffff0000UL)            /*!< CMPR1B6 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRB6_CMPR0B6_Pos         (0UL)                     /*!< CMPR0B6 (Bit 0)                                       */
#define CTIMER_CMPRB6_CMPR0B6_Msk         (0xffffUL)                /*!< CMPR0B6 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  CTRL6  ========================================================= */
#define CTIMER_CTRL6_CTLINK6_Pos          (31UL)                    /*!< CTLINK6 (Bit 31)                                      */
#define CTIMER_CTRL6_CTLINK6_Msk          (0x80000000UL)            /*!< CTLINK6 (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL6_TMRB6POL_Pos         (28UL)                    /*!< TMRB6POL (Bit 28)                                     */
#define CTIMER_CTRL6_TMRB6POL_Msk         (0x10000000UL)            /*!< TMRB6POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL6_TMRB6CLR_Pos         (27UL)                    /*!< TMRB6CLR (Bit 27)                                     */
#define CTIMER_CTRL6_TMRB6CLR_Msk         (0x8000000UL)             /*!< TMRB6CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL6_TMRB6IE1_Pos         (26UL)                    /*!< TMRB6IE1 (Bit 26)                                     */
#define CTIMER_CTRL6_TMRB6IE1_Msk         (0x4000000UL)             /*!< TMRB6IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL6_TMRB6IE0_Pos         (25UL)                    /*!< TMRB6IE0 (Bit 25)                                     */
#define CTIMER_CTRL6_TMRB6IE0_Msk         (0x2000000UL)             /*!< TMRB6IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL6_TMRB6FN_Pos          (22UL)                    /*!< TMRB6FN (Bit 22)                                      */
#define CTIMER_CTRL6_TMRB6FN_Msk          (0x1c00000UL)             /*!< TMRB6FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL6_TMRB6CLK_Pos         (17UL)                    /*!< TMRB6CLK (Bit 17)                                     */
#define CTIMER_CTRL6_TMRB6CLK_Msk         (0x3e0000UL)              /*!< TMRB6CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL6_TMRB6EN_Pos          (16UL)                    /*!< TMRB6EN (Bit 16)                                      */
#define CTIMER_CTRL6_TMRB6EN_Msk          (0x10000UL)               /*!< TMRB6EN (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL6_TMRA6POL_Pos         (12UL)                    /*!< TMRA6POL (Bit 12)                                     */
#define CTIMER_CTRL6_TMRA6POL_Msk         (0x1000UL)                /*!< TMRA6POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL6_TMRA6CLR_Pos         (11UL)                    /*!< TMRA6CLR (Bit 11)                                     */
#define CTIMER_CTRL6_TMRA6CLR_Msk         (0x800UL)                 /*!< TMRA6CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL6_TMRA6IE1_Pos         (10UL)                    /*!< TMRA6IE1 (Bit 10)                                     */
#define CTIMER_CTRL6_TMRA6IE1_Msk         (0x400UL)                 /*!< TMRA6IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL6_TMRA6IE0_Pos         (9UL)                     /*!< TMRA6IE0 (Bit 9)                                      */
#define CTIMER_CTRL6_TMRA6IE0_Msk         (0x200UL)                 /*!< TMRA6IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL6_TMRA6FN_Pos          (6UL)                     /*!< TMRA6FN (Bit 6)                                       */
#define CTIMER_CTRL6_TMRA6FN_Msk          (0x1c0UL)                 /*!< TMRA6FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL6_TMRA6CLK_Pos         (1UL)                     /*!< TMRA6CLK (Bit 1)                                      */
#define CTIMER_CTRL6_TMRA6CLK_Msk         (0x3eUL)                  /*!< TMRA6CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL6_TMRA6EN_Pos          (0UL)                     /*!< TMRA6EN (Bit 0)                                       */
#define CTIMER_CTRL6_TMRA6EN_Msk          (0x1UL)                   /*!< TMRA6EN (Bitfield-Mask: 0x01)                         */
/* =======================================================  CMPRAUXA6  ======================================================= */
#define CTIMER_CMPRAUXA6_CMPR3A6_Pos      (16UL)                    /*!< CMPR3A6 (Bit 16)                                      */
#define CTIMER_CMPRAUXA6_CMPR3A6_Msk      (0xffff0000UL)            /*!< CMPR3A6 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXA6_CMPR2A6_Pos      (0UL)                     /*!< CMPR2A6 (Bit 0)                                       */
#define CTIMER_CMPRAUXA6_CMPR2A6_Msk      (0xffffUL)                /*!< CMPR2A6 (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CMPRAUXB6  ======================================================= */
#define CTIMER_CMPRAUXB6_CMPR3B6_Pos      (16UL)                    /*!< CMPR3B6 (Bit 16)                                      */
#define CTIMER_CMPRAUXB6_CMPR3B6_Msk      (0xffff0000UL)            /*!< CMPR3B6 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXB6_CMPR2B6_Pos      (0UL)                     /*!< CMPR2B6 (Bit 0)                                       */
#define CTIMER_CMPRAUXB6_CMPR2B6_Msk      (0xffffUL)                /*!< CMPR2B6 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  AUX6  ========================================================== */
#define CTIMER_AUX6_TMRB6EN23_Pos         (30UL)                    /*!< TMRB6EN23 (Bit 30)                                    */
#define CTIMER_AUX6_TMRB6EN23_Msk         (0x40000000UL)            /*!< TMRB6EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX6_TMRB6POL23_Pos        (29UL)                    /*!< TMRB6POL23 (Bit 29)                                   */
#define CTIMER_AUX6_TMRB6POL23_Msk        (0x20000000UL)            /*!< TMRB6POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX6_TMRB6TINV_Pos         (28UL)                    /*!< TMRB6TINV (Bit 28)                                    */
#define CTIMER_AUX6_TMRB6TINV_Msk         (0x10000000UL)            /*!< TMRB6TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX6_TMRB6NOSYNC_Pos       (27UL)                    /*!< TMRB6NOSYNC (Bit 27)                                  */
#define CTIMER_AUX6_TMRB6NOSYNC_Msk       (0x8000000UL)             /*!< TMRB6NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX6_TMRB6TRIG_Pos         (23UL)                    /*!< TMRB6TRIG (Bit 23)                                    */
#define CTIMER_AUX6_TMRB6TRIG_Msk         (0x7800000UL)             /*!< TMRB6TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX6_TMRB6LMT_Pos          (16UL)                    /*!< TMRB6LMT (Bit 16)                                     */
#define CTIMER_AUX6_TMRB6LMT_Msk          (0x3f0000UL)              /*!< TMRB6LMT (Bitfield-Mask: 0x3f)                        */
#define CTIMER_AUX6_TMRA6EN23_Pos         (14UL)                    /*!< TMRA6EN23 (Bit 14)                                    */
#define CTIMER_AUX6_TMRA6EN23_Msk         (0x4000UL)                /*!< TMRA6EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX6_TMRA6POL23_Pos        (13UL)                    /*!< TMRA6POL23 (Bit 13)                                   */
#define CTIMER_AUX6_TMRA6POL23_Msk        (0x2000UL)                /*!< TMRA6POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX6_TMRA6TINV_Pos         (12UL)                    /*!< TMRA6TINV (Bit 12)                                    */
#define CTIMER_AUX6_TMRA6TINV_Msk         (0x1000UL)                /*!< TMRA6TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX6_TMRA6NOSYNC_Pos       (11UL)                    /*!< TMRA6NOSYNC (Bit 11)                                  */
#define CTIMER_AUX6_TMRA6NOSYNC_Msk       (0x800UL)                 /*!< TMRA6NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX6_TMRA6TRIG_Pos         (7UL)                     /*!< TMRA6TRIG (Bit 7)                                     */
#define CTIMER_AUX6_TMRA6TRIG_Msk         (0x780UL)                 /*!< TMRA6TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX6_TMRA6LMT_Pos          (0UL)                     /*!< TMRA6LMT (Bit 0)                                      */
#define CTIMER_AUX6_TMRA6LMT_Msk          (0x7fUL)                  /*!< TMRA6LMT (Bitfield-Mask: 0x7f)                        */
/* =========================================================  TMR7  ========================================================== */
#define CTIMER_TMR7_CTTMRB7_Pos           (16UL)                    /*!< CTTMRB7 (Bit 16)                                      */
#define CTIMER_TMR7_CTTMRB7_Msk           (0xffff0000UL)            /*!< CTTMRB7 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_TMR7_CTTMRA7_Pos           (0UL)                     /*!< CTTMRA7 (Bit 0)                                       */
#define CTIMER_TMR7_CTTMRA7_Msk           (0xffffUL)                /*!< CTTMRA7 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRA7  ========================================================= */
#define CTIMER_CMPRA7_CMPR1A7_Pos         (16UL)                    /*!< CMPR1A7 (Bit 16)                                      */
#define CTIMER_CMPRA7_CMPR1A7_Msk         (0xffff0000UL)            /*!< CMPR1A7 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRA7_CMPR0A7_Pos         (0UL)                     /*!< CMPR0A7 (Bit 0)                                       */
#define CTIMER_CMPRA7_CMPR0A7_Msk         (0xffffUL)                /*!< CMPR0A7 (Bitfield-Mask: 0xffff)                       */
/* ========================================================  CMPRB7  ========================================================= */
#define CTIMER_CMPRB7_CMPR1B7_Pos         (16UL)                    /*!< CMPR1B7 (Bit 16)                                      */
#define CTIMER_CMPRB7_CMPR1B7_Msk         (0xffff0000UL)            /*!< CMPR1B7 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRB7_CMPR0B7_Pos         (0UL)                     /*!< CMPR0B7 (Bit 0)                                       */
#define CTIMER_CMPRB7_CMPR0B7_Msk         (0xffffUL)                /*!< CMPR0B7 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  CTRL7  ========================================================= */
#define CTIMER_CTRL7_CTLINK7_Pos          (31UL)                    /*!< CTLINK7 (Bit 31)                                      */
#define CTIMER_CTRL7_CTLINK7_Msk          (0x80000000UL)            /*!< CTLINK7 (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL7_TMRB7POL_Pos         (28UL)                    /*!< TMRB7POL (Bit 28)                                     */
#define CTIMER_CTRL7_TMRB7POL_Msk         (0x10000000UL)            /*!< TMRB7POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL7_TMRB7CLR_Pos         (27UL)                    /*!< TMRB7CLR (Bit 27)                                     */
#define CTIMER_CTRL7_TMRB7CLR_Msk         (0x8000000UL)             /*!< TMRB7CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL7_TMRB7IE1_Pos         (26UL)                    /*!< TMRB7IE1 (Bit 26)                                     */
#define CTIMER_CTRL7_TMRB7IE1_Msk         (0x4000000UL)             /*!< TMRB7IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL7_TMRB7IE0_Pos         (25UL)                    /*!< TMRB7IE0 (Bit 25)                                     */
#define CTIMER_CTRL7_TMRB7IE0_Msk         (0x2000000UL)             /*!< TMRB7IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL7_TMRB7FN_Pos          (22UL)                    /*!< TMRB7FN (Bit 22)                                      */
#define CTIMER_CTRL7_TMRB7FN_Msk          (0x1c00000UL)             /*!< TMRB7FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL7_TMRB7CLK_Pos         (17UL)                    /*!< TMRB7CLK (Bit 17)                                     */
#define CTIMER_CTRL7_TMRB7CLK_Msk         (0x3e0000UL)              /*!< TMRB7CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL7_TMRB7EN_Pos          (16UL)                    /*!< TMRB7EN (Bit 16)                                      */
#define CTIMER_CTRL7_TMRB7EN_Msk          (0x10000UL)               /*!< TMRB7EN (Bitfield-Mask: 0x01)                         */
#define CTIMER_CTRL7_TMRA7POL_Pos         (12UL)                    /*!< TMRA7POL (Bit 12)                                     */
#define CTIMER_CTRL7_TMRA7POL_Msk         (0x1000UL)                /*!< TMRA7POL (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL7_TMRA7CLR_Pos         (11UL)                    /*!< TMRA7CLR (Bit 11)                                     */
#define CTIMER_CTRL7_TMRA7CLR_Msk         (0x800UL)                 /*!< TMRA7CLR (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL7_TMRA7IE1_Pos         (10UL)                    /*!< TMRA7IE1 (Bit 10)                                     */
#define CTIMER_CTRL7_TMRA7IE1_Msk         (0x400UL)                 /*!< TMRA7IE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL7_TMRA7IE0_Pos         (9UL)                     /*!< TMRA7IE0 (Bit 9)                                      */
#define CTIMER_CTRL7_TMRA7IE0_Msk         (0x200UL)                 /*!< TMRA7IE0 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CTRL7_TMRA7FN_Pos          (6UL)                     /*!< TMRA7FN (Bit 6)                                       */
#define CTIMER_CTRL7_TMRA7FN_Msk          (0x1c0UL)                 /*!< TMRA7FN (Bitfield-Mask: 0x07)                         */
#define CTIMER_CTRL7_TMRA7CLK_Pos         (1UL)                     /*!< TMRA7CLK (Bit 1)                                      */
#define CTIMER_CTRL7_TMRA7CLK_Msk         (0x3eUL)                  /*!< TMRA7CLK (Bitfield-Mask: 0x1f)                        */
#define CTIMER_CTRL7_TMRA7EN_Pos          (0UL)                     /*!< TMRA7EN (Bit 0)                                       */
#define CTIMER_CTRL7_TMRA7EN_Msk          (0x1UL)                   /*!< TMRA7EN (Bitfield-Mask: 0x01)                         */
/* =======================================================  CMPRAUXA7  ======================================================= */
#define CTIMER_CMPRAUXA7_CMPR3A7_Pos      (16UL)                    /*!< CMPR3A7 (Bit 16)                                      */
#define CTIMER_CMPRAUXA7_CMPR3A7_Msk      (0xffff0000UL)            /*!< CMPR3A7 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXA7_CMPR2A7_Pos      (0UL)                     /*!< CMPR2A7 (Bit 0)                                       */
#define CTIMER_CMPRAUXA7_CMPR2A7_Msk      (0xffffUL)                /*!< CMPR2A7 (Bitfield-Mask: 0xffff)                       */
/* =======================================================  CMPRAUXB7  ======================================================= */
#define CTIMER_CMPRAUXB7_CMPR3B7_Pos      (16UL)                    /*!< CMPR3B7 (Bit 16)                                      */
#define CTIMER_CMPRAUXB7_CMPR3B7_Msk      (0xffff0000UL)            /*!< CMPR3B7 (Bitfield-Mask: 0xffff)                       */
#define CTIMER_CMPRAUXB7_CMPR2B7_Pos      (0UL)                     /*!< CMPR2B7 (Bit 0)                                       */
#define CTIMER_CMPRAUXB7_CMPR2B7_Msk      (0xffffUL)                /*!< CMPR2B7 (Bitfield-Mask: 0xffff)                       */
/* =========================================================  AUX7  ========================================================== */
#define CTIMER_AUX7_TMRB7EN23_Pos         (30UL)                    /*!< TMRB7EN23 (Bit 30)                                    */
#define CTIMER_AUX7_TMRB7EN23_Msk         (0x40000000UL)            /*!< TMRB7EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX7_TMRB7POL23_Pos        (29UL)                    /*!< TMRB7POL23 (Bit 29)                                   */
#define CTIMER_AUX7_TMRB7POL23_Msk        (0x20000000UL)            /*!< TMRB7POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX7_TMRB7TINV_Pos         (28UL)                    /*!< TMRB7TINV (Bit 28)                                    */
#define CTIMER_AUX7_TMRB7TINV_Msk         (0x10000000UL)            /*!< TMRB7TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX7_TMRB7NOSYNC_Pos       (27UL)                    /*!< TMRB7NOSYNC (Bit 27)                                  */
#define CTIMER_AUX7_TMRB7NOSYNC_Msk       (0x8000000UL)             /*!< TMRB7NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX7_TMRB7TRIG_Pos         (23UL)                    /*!< TMRB7TRIG (Bit 23)                                    */
#define CTIMER_AUX7_TMRB7TRIG_Msk         (0x7800000UL)             /*!< TMRB7TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX7_TMRB7LMT_Pos          (16UL)                    /*!< TMRB7LMT (Bit 16)                                     */
#define CTIMER_AUX7_TMRB7LMT_Msk          (0x3f0000UL)              /*!< TMRB7LMT (Bitfield-Mask: 0x3f)                        */
#define CTIMER_AUX7_TMRA7EN23_Pos         (14UL)                    /*!< TMRA7EN23 (Bit 14)                                    */
#define CTIMER_AUX7_TMRA7EN23_Msk         (0x4000UL)                /*!< TMRA7EN23 (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX7_TMRA7POL23_Pos        (13UL)                    /*!< TMRA7POL23 (Bit 13)                                   */
#define CTIMER_AUX7_TMRA7POL23_Msk        (0x2000UL)                /*!< TMRA7POL23 (Bitfield-Mask: 0x01)                      */
#define CTIMER_AUX7_TMRA7TINV_Pos         (12UL)                    /*!< TMRA7TINV (Bit 12)                                    */
#define CTIMER_AUX7_TMRA7TINV_Msk         (0x1000UL)                /*!< TMRA7TINV (Bitfield-Mask: 0x01)                       */
#define CTIMER_AUX7_TMRA7NOSYNC_Pos       (11UL)                    /*!< TMRA7NOSYNC (Bit 11)                                  */
#define CTIMER_AUX7_TMRA7NOSYNC_Msk       (0x800UL)                 /*!< TMRA7NOSYNC (Bitfield-Mask: 0x01)                     */
#define CTIMER_AUX7_TMRA7TRIG_Pos         (7UL)                     /*!< TMRA7TRIG (Bit 7)                                     */
#define CTIMER_AUX7_TMRA7TRIG_Msk         (0x780UL)                 /*!< TMRA7TRIG (Bitfield-Mask: 0x0f)                       */
#define CTIMER_AUX7_TMRA7LMT_Pos          (0UL)                     /*!< TMRA7LMT (Bit 0)                                      */
#define CTIMER_AUX7_TMRA7LMT_Msk          (0x7fUL)                  /*!< TMRA7LMT (Bitfield-Mask: 0x7f)                        */
/* ========================================================  GLOBEN  ========================================================= */
#define CTIMER_GLOBEN_ENB7_Pos            (15UL)                    /*!< ENB7 (Bit 15)                                         */
#define CTIMER_GLOBEN_ENB7_Msk            (0x8000UL)                /*!< ENB7 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENA7_Pos            (14UL)                    /*!< ENA7 (Bit 14)                                         */
#define CTIMER_GLOBEN_ENA7_Msk            (0x4000UL)                /*!< ENA7 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENB6_Pos            (13UL)                    /*!< ENB6 (Bit 13)                                         */
#define CTIMER_GLOBEN_ENB6_Msk            (0x2000UL)                /*!< ENB6 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENA6_Pos            (12UL)                    /*!< ENA6 (Bit 12)                                         */
#define CTIMER_GLOBEN_ENA6_Msk            (0x1000UL)                /*!< ENA6 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENB5_Pos            (11UL)                    /*!< ENB5 (Bit 11)                                         */
#define CTIMER_GLOBEN_ENB5_Msk            (0x800UL)                 /*!< ENB5 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENA5_Pos            (10UL)                    /*!< ENA5 (Bit 10)                                         */
#define CTIMER_GLOBEN_ENA5_Msk            (0x400UL)                 /*!< ENA5 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENB4_Pos            (9UL)                     /*!< ENB4 (Bit 9)                                          */
#define CTIMER_GLOBEN_ENB4_Msk            (0x200UL)                 /*!< ENB4 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENA4_Pos            (8UL)                     /*!< ENA4 (Bit 8)                                          */
#define CTIMER_GLOBEN_ENA4_Msk            (0x100UL)                 /*!< ENA4 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENB3_Pos            (7UL)                     /*!< ENB3 (Bit 7)                                          */
#define CTIMER_GLOBEN_ENB3_Msk            (0x80UL)                  /*!< ENB3 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENA3_Pos            (6UL)                     /*!< ENA3 (Bit 6)                                          */
#define CTIMER_GLOBEN_ENA3_Msk            (0x40UL)                  /*!< ENA3 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENB2_Pos            (5UL)                     /*!< ENB2 (Bit 5)                                          */
#define CTIMER_GLOBEN_ENB2_Msk            (0x20UL)                  /*!< ENB2 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENA2_Pos            (4UL)                     /*!< ENA2 (Bit 4)                                          */
#define CTIMER_GLOBEN_ENA2_Msk            (0x10UL)                  /*!< ENA2 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENB1_Pos            (3UL)                     /*!< ENB1 (Bit 3)                                          */
#define CTIMER_GLOBEN_ENB1_Msk            (0x8UL)                   /*!< ENB1 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENA1_Pos            (2UL)                     /*!< ENA1 (Bit 2)                                          */
#define CTIMER_GLOBEN_ENA1_Msk            (0x4UL)                   /*!< ENA1 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENB0_Pos            (1UL)                     /*!< ENB0 (Bit 1)                                          */
#define CTIMER_GLOBEN_ENB0_Msk            (0x2UL)                   /*!< ENB0 (Bitfield-Mask: 0x01)                            */
#define CTIMER_GLOBEN_ENA0_Pos            (0UL)                     /*!< ENA0 (Bit 0)                                          */
#define CTIMER_GLOBEN_ENA0_Msk            (0x1UL)                   /*!< ENA0 (Bitfield-Mask: 0x01)                            */
/* ========================================================  OUTCFG0  ======================================================== */
#define CTIMER_OUTCFG0_CFG9_Pos           (28UL)                    /*!< CFG9 (Bit 28)                                         */
#define CTIMER_OUTCFG0_CFG9_Msk           (0x70000000UL)            /*!< CFG9 (Bitfield-Mask: 0x07)                            */
#define CTIMER_OUTCFG0_CFG8_Pos           (25UL)                    /*!< CFG8 (Bit 25)                                         */
#define CTIMER_OUTCFG0_CFG8_Msk           (0xe000000UL)             /*!< CFG8 (Bitfield-Mask: 0x07)                            */
#define CTIMER_OUTCFG0_CFG7_Pos           (22UL)                    /*!< CFG7 (Bit 22)                                         */
#define CTIMER_OUTCFG0_CFG7_Msk           (0x1c00000UL)             /*!< CFG7 (Bitfield-Mask: 0x07)                            */
#define CTIMER_OUTCFG0_CFG6_Pos           (19UL)                    /*!< CFG6 (Bit 19)                                         */
#define CTIMER_OUTCFG0_CFG6_Msk           (0x380000UL)              /*!< CFG6 (Bitfield-Mask: 0x07)                            */
#define CTIMER_OUTCFG0_CFG5_Pos           (16UL)                    /*!< CFG5 (Bit 16)                                         */
#define CTIMER_OUTCFG0_CFG5_Msk           (0x70000UL)               /*!< CFG5 (Bitfield-Mask: 0x07)                            */
#define CTIMER_OUTCFG0_CFG4_Pos           (12UL)                    /*!< CFG4 (Bit 12)                                         */
#define CTIMER_OUTCFG0_CFG4_Msk           (0x7000UL)                /*!< CFG4 (Bitfield-Mask: 0x07)                            */
#define CTIMER_OUTCFG0_CFG3_Pos           (9UL)                     /*!< CFG3 (Bit 9)                                          */
#define CTIMER_OUTCFG0_CFG3_Msk           (0xe00UL)                 /*!< CFG3 (Bitfield-Mask: 0x07)                            */
#define CTIMER_OUTCFG0_CFG2_Pos           (6UL)                     /*!< CFG2 (Bit 6)                                          */
#define CTIMER_OUTCFG0_CFG2_Msk           (0x1c0UL)                 /*!< CFG2 (Bitfield-Mask: 0x07)                            */
#define CTIMER_OUTCFG0_CFG1_Pos           (3UL)                     /*!< CFG1 (Bit 3)                                          */
#define CTIMER_OUTCFG0_CFG1_Msk           (0x38UL)                  /*!< CFG1 (Bitfield-Mask: 0x07)                            */
#define CTIMER_OUTCFG0_CFG0_Pos           (0UL)                     /*!< CFG0 (Bit 0)                                          */
#define CTIMER_OUTCFG0_CFG0_Msk           (0x7UL)                   /*!< CFG0 (Bitfield-Mask: 0x07)                            */
/* ========================================================  OUTCFG1  ======================================================== */
#define CTIMER_OUTCFG1_CFG19_Pos          (28UL)                    /*!< CFG19 (Bit 28)                                        */
#define CTIMER_OUTCFG1_CFG19_Msk          (0x70000000UL)            /*!< CFG19 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG1_CFG18_Pos          (25UL)                    /*!< CFG18 (Bit 25)                                        */
#define CTIMER_OUTCFG1_CFG18_Msk          (0xe000000UL)             /*!< CFG18 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG1_CFG17_Pos          (22UL)                    /*!< CFG17 (Bit 22)                                        */
#define CTIMER_OUTCFG1_CFG17_Msk          (0x1c00000UL)             /*!< CFG17 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG1_CFG16_Pos          (19UL)                    /*!< CFG16 (Bit 19)                                        */
#define CTIMER_OUTCFG1_CFG16_Msk          (0x380000UL)              /*!< CFG16 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG1_CFG15_Pos          (16UL)                    /*!< CFG15 (Bit 16)                                        */
#define CTIMER_OUTCFG1_CFG15_Msk          (0x70000UL)               /*!< CFG15 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG1_CFG14_Pos          (12UL)                    /*!< CFG14 (Bit 12)                                        */
#define CTIMER_OUTCFG1_CFG14_Msk          (0x7000UL)                /*!< CFG14 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG1_CFG13_Pos          (9UL)                     /*!< CFG13 (Bit 9)                                         */
#define CTIMER_OUTCFG1_CFG13_Msk          (0xe00UL)                 /*!< CFG13 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG1_CFG12_Pos          (6UL)                     /*!< CFG12 (Bit 6)                                         */
#define CTIMER_OUTCFG1_CFG12_Msk          (0x1c0UL)                 /*!< CFG12 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG1_CFG11_Pos          (3UL)                     /*!< CFG11 (Bit 3)                                         */
#define CTIMER_OUTCFG1_CFG11_Msk          (0x38UL)                  /*!< CFG11 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG1_CFG10_Pos          (0UL)                     /*!< CFG10 (Bit 0)                                         */
#define CTIMER_OUTCFG1_CFG10_Msk          (0x7UL)                   /*!< CFG10 (Bitfield-Mask: 0x07)                           */
/* ========================================================  OUTCFG2  ======================================================== */
#define CTIMER_OUTCFG2_CFG29_Pos          (28UL)                    /*!< CFG29 (Bit 28)                                        */
#define CTIMER_OUTCFG2_CFG29_Msk          (0x70000000UL)            /*!< CFG29 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG2_CFG28_Pos          (25UL)                    /*!< CFG28 (Bit 25)                                        */
#define CTIMER_OUTCFG2_CFG28_Msk          (0xe000000UL)             /*!< CFG28 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG2_CFG27_Pos          (22UL)                    /*!< CFG27 (Bit 22)                                        */
#define CTIMER_OUTCFG2_CFG27_Msk          (0x1c00000UL)             /*!< CFG27 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG2_CFG26_Pos          (19UL)                    /*!< CFG26 (Bit 19)                                        */
#define CTIMER_OUTCFG2_CFG26_Msk          (0x380000UL)              /*!< CFG26 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG2_CFG25_Pos          (16UL)                    /*!< CFG25 (Bit 16)                                        */
#define CTIMER_OUTCFG2_CFG25_Msk          (0x70000UL)               /*!< CFG25 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG2_CFG24_Pos          (12UL)                    /*!< CFG24 (Bit 12)                                        */
#define CTIMER_OUTCFG2_CFG24_Msk          (0x7000UL)                /*!< CFG24 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG2_CFG23_Pos          (9UL)                     /*!< CFG23 (Bit 9)                                         */
#define CTIMER_OUTCFG2_CFG23_Msk          (0xe00UL)                 /*!< CFG23 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG2_CFG22_Pos          (6UL)                     /*!< CFG22 (Bit 6)                                         */
#define CTIMER_OUTCFG2_CFG22_Msk          (0x1c0UL)                 /*!< CFG22 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG2_CFG21_Pos          (3UL)                     /*!< CFG21 (Bit 3)                                         */
#define CTIMER_OUTCFG2_CFG21_Msk          (0x38UL)                  /*!< CFG21 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG2_CFG20_Pos          (0UL)                     /*!< CFG20 (Bit 0)                                         */
#define CTIMER_OUTCFG2_CFG20_Msk          (0x7UL)                   /*!< CFG20 (Bitfield-Mask: 0x07)                           */
/* ========================================================  OUTCFG3  ======================================================== */
#define CTIMER_OUTCFG3_CFG31_Pos          (3UL)                     /*!< CFG31 (Bit 3)                                         */
#define CTIMER_OUTCFG3_CFG31_Msk          (0x38UL)                  /*!< CFG31 (Bitfield-Mask: 0x07)                           */
#define CTIMER_OUTCFG3_CFG30_Pos          (0UL)                     /*!< CFG30 (Bit 0)                                         */
#define CTIMER_OUTCFG3_CFG30_Msk          (0x7UL)                   /*!< CFG30 (Bitfield-Mask: 0x07)                           */
/* =========================================================  INCFG  ========================================================= */
#define CTIMER_INCFG_CFGB7_Pos            (15UL)                    /*!< CFGB7 (Bit 15)                                        */
#define CTIMER_INCFG_CFGB7_Msk            (0x8000UL)                /*!< CFGB7 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGA7_Pos            (14UL)                    /*!< CFGA7 (Bit 14)                                        */
#define CTIMER_INCFG_CFGA7_Msk            (0x4000UL)                /*!< CFGA7 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGB6_Pos            (13UL)                    /*!< CFGB6 (Bit 13)                                        */
#define CTIMER_INCFG_CFGB6_Msk            (0x2000UL)                /*!< CFGB6 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGA6_Pos            (12UL)                    /*!< CFGA6 (Bit 12)                                        */
#define CTIMER_INCFG_CFGA6_Msk            (0x1000UL)                /*!< CFGA6 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGB5_Pos            (11UL)                    /*!< CFGB5 (Bit 11)                                        */
#define CTIMER_INCFG_CFGB5_Msk            (0x800UL)                 /*!< CFGB5 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGA5_Pos            (10UL)                    /*!< CFGA5 (Bit 10)                                        */
#define CTIMER_INCFG_CFGA5_Msk            (0x400UL)                 /*!< CFGA5 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGB4_Pos            (9UL)                     /*!< CFGB4 (Bit 9)                                         */
#define CTIMER_INCFG_CFGB4_Msk            (0x200UL)                 /*!< CFGB4 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGA4_Pos            (8UL)                     /*!< CFGA4 (Bit 8)                                         */
#define CTIMER_INCFG_CFGA4_Msk            (0x100UL)                 /*!< CFGA4 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGB3_Pos            (7UL)                     /*!< CFGB3 (Bit 7)                                         */
#define CTIMER_INCFG_CFGB3_Msk            (0x80UL)                  /*!< CFGB3 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGA3_Pos            (6UL)                     /*!< CFGA3 (Bit 6)                                         */
#define CTIMER_INCFG_CFGA3_Msk            (0x40UL)                  /*!< CFGA3 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGB2_Pos            (5UL)                     /*!< CFGB2 (Bit 5)                                         */
#define CTIMER_INCFG_CFGB2_Msk            (0x20UL)                  /*!< CFGB2 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGA2_Pos            (4UL)                     /*!< CFGA2 (Bit 4)                                         */
#define CTIMER_INCFG_CFGA2_Msk            (0x10UL)                  /*!< CFGA2 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGB1_Pos            (3UL)                     /*!< CFGB1 (Bit 3)                                         */
#define CTIMER_INCFG_CFGB1_Msk            (0x8UL)                   /*!< CFGB1 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGA1_Pos            (2UL)                     /*!< CFGA1 (Bit 2)                                         */
#define CTIMER_INCFG_CFGA1_Msk            (0x4UL)                   /*!< CFGA1 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGB0_Pos            (1UL)                     /*!< CFGB0 (Bit 1)                                         */
#define CTIMER_INCFG_CFGB0_Msk            (0x2UL)                   /*!< CFGB0 (Bitfield-Mask: 0x01)                           */
#define CTIMER_INCFG_CFGA0_Pos            (0UL)                     /*!< CFGA0 (Bit 0)                                         */
#define CTIMER_INCFG_CFGA0_Msk            (0x1UL)                   /*!< CFGA0 (Bitfield-Mask: 0x01)                           */
/* =========================================================  STCFG  ========================================================= */
#define CTIMER_STCFG_FREEZE_Pos           (31UL)                    /*!< FREEZE (Bit 31)                                       */
#define CTIMER_STCFG_FREEZE_Msk           (0x80000000UL)            /*!< FREEZE (Bitfield-Mask: 0x01)                          */
#define CTIMER_STCFG_CLEAR_Pos            (30UL)                    /*!< CLEAR (Bit 30)                                        */
#define CTIMER_STCFG_CLEAR_Msk            (0x40000000UL)            /*!< CLEAR (Bitfield-Mask: 0x01)                           */
#define CTIMER_STCFG_COMPARE_H_EN_Pos     (15UL)                    /*!< COMPARE_H_EN (Bit 15)                                 */
#define CTIMER_STCFG_COMPARE_H_EN_Msk     (0x8000UL)                /*!< COMPARE_H_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_G_EN_Pos     (14UL)                    /*!< COMPARE_G_EN (Bit 14)                                 */
#define CTIMER_STCFG_COMPARE_G_EN_Msk     (0x4000UL)                /*!< COMPARE_G_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_F_EN_Pos     (13UL)                    /*!< COMPARE_F_EN (Bit 13)                                 */
#define CTIMER_STCFG_COMPARE_F_EN_Msk     (0x2000UL)                /*!< COMPARE_F_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_E_EN_Pos     (12UL)                    /*!< COMPARE_E_EN (Bit 12)                                 */
#define CTIMER_STCFG_COMPARE_E_EN_Msk     (0x1000UL)                /*!< COMPARE_E_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_D_EN_Pos     (11UL)                    /*!< COMPARE_D_EN (Bit 11)                                 */
#define CTIMER_STCFG_COMPARE_D_EN_Msk     (0x800UL)                 /*!< COMPARE_D_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_C_EN_Pos     (10UL)                    /*!< COMPARE_C_EN (Bit 10)                                 */
#define CTIMER_STCFG_COMPARE_C_EN_Msk     (0x400UL)                 /*!< COMPARE_C_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_B_EN_Pos     (9UL)                     /*!< COMPARE_B_EN (Bit 9)                                  */
#define CTIMER_STCFG_COMPARE_B_EN_Msk     (0x200UL)                 /*!< COMPARE_B_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_COMPARE_A_EN_Pos     (8UL)                     /*!< COMPARE_A_EN (Bit 8)                                  */
#define CTIMER_STCFG_COMPARE_A_EN_Msk     (0x100UL)                 /*!< COMPARE_A_EN (Bitfield-Mask: 0x01)                    */
#define CTIMER_STCFG_CLKSEL_Pos           (0UL)                     /*!< CLKSEL (Bit 0)                                        */
#define CTIMER_STCFG_CLKSEL_Msk           (0xfUL)                   /*!< CLKSEL (Bitfield-Mask: 0x0f)                          */
/* =========================================================  STTMR  ========================================================= */
#define CTIMER_STTMR_STTMR_Pos            (0UL)                     /*!< STTMR (Bit 0)                                         */
#define CTIMER_STTMR_STTMR_Msk            (0xffffffffUL)            /*!< STTMR (Bitfield-Mask: 0xffffffff)                     */
/* ====================================================  CAPTURECONTROL  ===================================================== */
#define CTIMER_CAPTURECONTROL_CAPTURE3_Pos (3UL)                    /*!< CAPTURE3 (Bit 3)                                      */
#define CTIMER_CAPTURECONTROL_CAPTURE3_Msk (0x8UL)                  /*!< CAPTURE3 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CAPTURECONTROL_CAPTURE2_Pos (2UL)                    /*!< CAPTURE2 (Bit 2)                                      */
#define CTIMER_CAPTURECONTROL_CAPTURE2_Msk (0x4UL)                  /*!< CAPTURE2 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CAPTURECONTROL_CAPTURE1_Pos (1UL)                    /*!< CAPTURE1 (Bit 1)                                      */
#define CTIMER_CAPTURECONTROL_CAPTURE1_Msk (0x2UL)                  /*!< CAPTURE1 (Bitfield-Mask: 0x01)                        */
#define CTIMER_CAPTURECONTROL_CAPTURE0_Pos (0UL)                    /*!< CAPTURE0 (Bit 0)                                      */
#define CTIMER_CAPTURECONTROL_CAPTURE0_Msk (0x1UL)                  /*!< CAPTURE0 (Bitfield-Mask: 0x01)                        */
/* ========================================================  SCMPR0  ========================================================= */
#define CTIMER_SCMPR0_SCMPR0_Pos          (0UL)                     /*!< SCMPR0 (Bit 0)                                        */
#define CTIMER_SCMPR0_SCMPR0_Msk          (0xffffffffUL)            /*!< SCMPR0 (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  SCMPR1  ========================================================= */
#define CTIMER_SCMPR1_SCMPR1_Pos          (0UL)                     /*!< SCMPR1 (Bit 0)                                        */
#define CTIMER_SCMPR1_SCMPR1_Msk          (0xffffffffUL)            /*!< SCMPR1 (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  SCMPR2  ========================================================= */
#define CTIMER_SCMPR2_SCMPR2_Pos          (0UL)                     /*!< SCMPR2 (Bit 0)                                        */
#define CTIMER_SCMPR2_SCMPR2_Msk          (0xffffffffUL)            /*!< SCMPR2 (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  SCMPR3  ========================================================= */
#define CTIMER_SCMPR3_SCMPR3_Pos          (0UL)                     /*!< SCMPR3 (Bit 0)                                        */
#define CTIMER_SCMPR3_SCMPR3_Msk          (0xffffffffUL)            /*!< SCMPR3 (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  SCMPR4  ========================================================= */
#define CTIMER_SCMPR4_SCMPR4_Pos          (0UL)                     /*!< SCMPR4 (Bit 0)                                        */
#define CTIMER_SCMPR4_SCMPR4_Msk          (0xffffffffUL)            /*!< SCMPR4 (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  SCMPR5  ========================================================= */
#define CTIMER_SCMPR5_SCMPR5_Pos          (0UL)                     /*!< SCMPR5 (Bit 0)                                        */
#define CTIMER_SCMPR5_SCMPR5_Msk          (0xffffffffUL)            /*!< SCMPR5 (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  SCMPR6  ========================================================= */
#define CTIMER_SCMPR6_SCMPR6_Pos          (0UL)                     /*!< SCMPR6 (Bit 0)                                        */
#define CTIMER_SCMPR6_SCMPR6_Msk          (0xffffffffUL)            /*!< SCMPR6 (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  SCMPR7  ========================================================= */
#define CTIMER_SCMPR7_SCMPR7_Pos          (0UL)                     /*!< SCMPR7 (Bit 0)                                        */
#define CTIMER_SCMPR7_SCMPR7_Msk          (0xffffffffUL)            /*!< SCMPR7 (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  SCAPT0  ========================================================= */
#define CTIMER_SCAPT0_SCAPT0_Pos          (0UL)                     /*!< SCAPT0 (Bit 0)                                        */
#define CTIMER_SCAPT0_SCAPT0_Msk          (0xffffffffUL)            /*!< SCAPT0 (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  SCAPT1  ========================================================= */
#define CTIMER_SCAPT1_SCAPT1_Pos          (0UL)                     /*!< SCAPT1 (Bit 0)                                        */
#define CTIMER_SCAPT1_SCAPT1_Msk          (0xffffffffUL)            /*!< SCAPT1 (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  SCAPT2  ========================================================= */
#define CTIMER_SCAPT2_SCAPT2_Pos          (0UL)                     /*!< SCAPT2 (Bit 0)                                        */
#define CTIMER_SCAPT2_SCAPT2_Msk          (0xffffffffUL)            /*!< SCAPT2 (Bitfield-Mask: 0xffffffff)                    */
/* ========================================================  SCAPT3  ========================================================= */
#define CTIMER_SCAPT3_SCAPT3_Pos          (0UL)                     /*!< SCAPT3 (Bit 0)                                        */
#define CTIMER_SCAPT3_SCAPT3_Msk          (0xffffffffUL)            /*!< SCAPT3 (Bitfield-Mask: 0xffffffff)                    */
/* =========================================================  SNVR0  ========================================================= */
#define CTIMER_SNVR0_SNVR0_Pos            (0UL)                     /*!< SNVR0 (Bit 0)                                         */
#define CTIMER_SNVR0_SNVR0_Msk            (0xffffffffUL)            /*!< SNVR0 (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  SNVR1  ========================================================= */
#define CTIMER_SNVR1_SNVR1_Pos            (0UL)                     /*!< SNVR1 (Bit 0)                                         */
#define CTIMER_SNVR1_SNVR1_Msk            (0xffffffffUL)            /*!< SNVR1 (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  SNVR2  ========================================================= */
#define CTIMER_SNVR2_SNVR2_Pos            (0UL)                     /*!< SNVR2 (Bit 0)                                         */
#define CTIMER_SNVR2_SNVR2_Msk            (0xffffffffUL)            /*!< SNVR2 (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  SNVR3  ========================================================= */
#define CTIMER_SNVR3_SNVR3_Pos            (0UL)                     /*!< SNVR3 (Bit 0)                                         */
#define CTIMER_SNVR3_SNVR3_Msk            (0xffffffffUL)            /*!< SNVR3 (Bitfield-Mask: 0xffffffff)                     */
/* =========================================================  INTEN  ========================================================= */
#define CTIMER_INTEN_CTMRB7C1INT_Pos      (31UL)                    /*!< CTMRB7C1INT (Bit 31)                                  */
#define CTIMER_INTEN_CTMRB7C1INT_Msk      (0x80000000UL)            /*!< CTMRB7C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA7C1INT_Pos      (30UL)                    /*!< CTMRA7C1INT (Bit 30)                                  */
#define CTIMER_INTEN_CTMRA7C1INT_Msk      (0x40000000UL)            /*!< CTMRA7C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB6C1INT_Pos      (29UL)                    /*!< CTMRB6C1INT (Bit 29)                                  */
#define CTIMER_INTEN_CTMRB6C1INT_Msk      (0x20000000UL)            /*!< CTMRB6C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA6C1INT_Pos      (28UL)                    /*!< CTMRA6C1INT (Bit 28)                                  */
#define CTIMER_INTEN_CTMRA6C1INT_Msk      (0x10000000UL)            /*!< CTMRA6C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB5C1INT_Pos      (27UL)                    /*!< CTMRB5C1INT (Bit 27)                                  */
#define CTIMER_INTEN_CTMRB5C1INT_Msk      (0x8000000UL)             /*!< CTMRB5C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA5C1INT_Pos      (26UL)                    /*!< CTMRA5C1INT (Bit 26)                                  */
#define CTIMER_INTEN_CTMRA5C1INT_Msk      (0x4000000UL)             /*!< CTMRA5C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB4C1INT_Pos      (25UL)                    /*!< CTMRB4C1INT (Bit 25)                                  */
#define CTIMER_INTEN_CTMRB4C1INT_Msk      (0x2000000UL)             /*!< CTMRB4C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA4C1INT_Pos      (24UL)                    /*!< CTMRA4C1INT (Bit 24)                                  */
#define CTIMER_INTEN_CTMRA4C1INT_Msk      (0x1000000UL)             /*!< CTMRA4C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB3C1INT_Pos      (23UL)                    /*!< CTMRB3C1INT (Bit 23)                                  */
#define CTIMER_INTEN_CTMRB3C1INT_Msk      (0x800000UL)              /*!< CTMRB3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA3C1INT_Pos      (22UL)                    /*!< CTMRA3C1INT (Bit 22)                                  */
#define CTIMER_INTEN_CTMRA3C1INT_Msk      (0x400000UL)              /*!< CTMRA3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB2C1INT_Pos      (21UL)                    /*!< CTMRB2C1INT (Bit 21)                                  */
#define CTIMER_INTEN_CTMRB2C1INT_Msk      (0x200000UL)              /*!< CTMRB2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA2C1INT_Pos      (20UL)                    /*!< CTMRA2C1INT (Bit 20)                                  */
#define CTIMER_INTEN_CTMRA2C1INT_Msk      (0x100000UL)              /*!< CTMRA2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB1C1INT_Pos      (19UL)                    /*!< CTMRB1C1INT (Bit 19)                                  */
#define CTIMER_INTEN_CTMRB1C1INT_Msk      (0x80000UL)               /*!< CTMRB1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA1C1INT_Pos      (18UL)                    /*!< CTMRA1C1INT (Bit 18)                                  */
#define CTIMER_INTEN_CTMRA1C1INT_Msk      (0x40000UL)               /*!< CTMRA1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB0C1INT_Pos      (17UL)                    /*!< CTMRB0C1INT (Bit 17)                                  */
#define CTIMER_INTEN_CTMRB0C1INT_Msk      (0x20000UL)               /*!< CTMRB0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA0C1INT_Pos      (16UL)                    /*!< CTMRA0C1INT (Bit 16)                                  */
#define CTIMER_INTEN_CTMRA0C1INT_Msk      (0x10000UL)               /*!< CTMRA0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB7C0INT_Pos      (15UL)                    /*!< CTMRB7C0INT (Bit 15)                                  */
#define CTIMER_INTEN_CTMRB7C0INT_Msk      (0x8000UL)                /*!< CTMRB7C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA7C0INT_Pos      (14UL)                    /*!< CTMRA7C0INT (Bit 14)                                  */
#define CTIMER_INTEN_CTMRA7C0INT_Msk      (0x4000UL)                /*!< CTMRA7C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB6C0INT_Pos      (13UL)                    /*!< CTMRB6C0INT (Bit 13)                                  */
#define CTIMER_INTEN_CTMRB6C0INT_Msk      (0x2000UL)                /*!< CTMRB6C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA6C0INT_Pos      (12UL)                    /*!< CTMRA6C0INT (Bit 12)                                  */
#define CTIMER_INTEN_CTMRA6C0INT_Msk      (0x1000UL)                /*!< CTMRA6C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB5C0INT_Pos      (11UL)                    /*!< CTMRB5C0INT (Bit 11)                                  */
#define CTIMER_INTEN_CTMRB5C0INT_Msk      (0x800UL)                 /*!< CTMRB5C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA5C0INT_Pos      (10UL)                    /*!< CTMRA5C0INT (Bit 10)                                  */
#define CTIMER_INTEN_CTMRA5C0INT_Msk      (0x400UL)                 /*!< CTMRA5C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB4C0INT_Pos      (9UL)                     /*!< CTMRB4C0INT (Bit 9)                                   */
#define CTIMER_INTEN_CTMRB4C0INT_Msk      (0x200UL)                 /*!< CTMRB4C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA4C0INT_Pos      (8UL)                     /*!< CTMRA4C0INT (Bit 8)                                   */
#define CTIMER_INTEN_CTMRA4C0INT_Msk      (0x100UL)                 /*!< CTMRA4C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB3C0INT_Pos      (7UL)                     /*!< CTMRB3C0INT (Bit 7)                                   */
#define CTIMER_INTEN_CTMRB3C0INT_Msk      (0x80UL)                  /*!< CTMRB3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA3C0INT_Pos      (6UL)                     /*!< CTMRA3C0INT (Bit 6)                                   */
#define CTIMER_INTEN_CTMRA3C0INT_Msk      (0x40UL)                  /*!< CTMRA3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB2C0INT_Pos      (5UL)                     /*!< CTMRB2C0INT (Bit 5)                                   */
#define CTIMER_INTEN_CTMRB2C0INT_Msk      (0x20UL)                  /*!< CTMRB2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA2C0INT_Pos      (4UL)                     /*!< CTMRA2C0INT (Bit 4)                                   */
#define CTIMER_INTEN_CTMRA2C0INT_Msk      (0x10UL)                  /*!< CTMRA2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB1C0INT_Pos      (3UL)                     /*!< CTMRB1C0INT (Bit 3)                                   */
#define CTIMER_INTEN_CTMRB1C0INT_Msk      (0x8UL)                   /*!< CTMRB1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA1C0INT_Pos      (2UL)                     /*!< CTMRA1C0INT (Bit 2)                                   */
#define CTIMER_INTEN_CTMRA1C0INT_Msk      (0x4UL)                   /*!< CTMRA1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRB0C0INT_Pos      (1UL)                     /*!< CTMRB0C0INT (Bit 1)                                   */
#define CTIMER_INTEN_CTMRB0C0INT_Msk      (0x2UL)                   /*!< CTMRB0C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTEN_CTMRA0C0INT_Pos      (0UL)                     /*!< CTMRA0C0INT (Bit 0)                                   */
#define CTIMER_INTEN_CTMRA0C0INT_Msk      (0x1UL)                   /*!< CTMRA0C0INT (Bitfield-Mask: 0x01)                     */
/* ========================================================  INTSTAT  ======================================================== */
#define CTIMER_INTSTAT_CTMRB7C1INT_Pos    (31UL)                    /*!< CTMRB7C1INT (Bit 31)                                  */
#define CTIMER_INTSTAT_CTMRB7C1INT_Msk    (0x80000000UL)            /*!< CTMRB7C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA7C1INT_Pos    (30UL)                    /*!< CTMRA7C1INT (Bit 30)                                  */
#define CTIMER_INTSTAT_CTMRA7C1INT_Msk    (0x40000000UL)            /*!< CTMRA7C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB6C1INT_Pos    (29UL)                    /*!< CTMRB6C1INT (Bit 29)                                  */
#define CTIMER_INTSTAT_CTMRB6C1INT_Msk    (0x20000000UL)            /*!< CTMRB6C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA6C1INT_Pos    (28UL)                    /*!< CTMRA6C1INT (Bit 28)                                  */
#define CTIMER_INTSTAT_CTMRA6C1INT_Msk    (0x10000000UL)            /*!< CTMRA6C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB5C1INT_Pos    (27UL)                    /*!< CTMRB5C1INT (Bit 27)                                  */
#define CTIMER_INTSTAT_CTMRB5C1INT_Msk    (0x8000000UL)             /*!< CTMRB5C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA5C1INT_Pos    (26UL)                    /*!< CTMRA5C1INT (Bit 26)                                  */
#define CTIMER_INTSTAT_CTMRA5C1INT_Msk    (0x4000000UL)             /*!< CTMRA5C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB4C1INT_Pos    (25UL)                    /*!< CTMRB4C1INT (Bit 25)                                  */
#define CTIMER_INTSTAT_CTMRB4C1INT_Msk    (0x2000000UL)             /*!< CTMRB4C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA4C1INT_Pos    (24UL)                    /*!< CTMRA4C1INT (Bit 24)                                  */
#define CTIMER_INTSTAT_CTMRA4C1INT_Msk    (0x1000000UL)             /*!< CTMRA4C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB3C1INT_Pos    (23UL)                    /*!< CTMRB3C1INT (Bit 23)                                  */
#define CTIMER_INTSTAT_CTMRB3C1INT_Msk    (0x800000UL)              /*!< CTMRB3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA3C1INT_Pos    (22UL)                    /*!< CTMRA3C1INT (Bit 22)                                  */
#define CTIMER_INTSTAT_CTMRA3C1INT_Msk    (0x400000UL)              /*!< CTMRA3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB2C1INT_Pos    (21UL)                    /*!< CTMRB2C1INT (Bit 21)                                  */
#define CTIMER_INTSTAT_CTMRB2C1INT_Msk    (0x200000UL)              /*!< CTMRB2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA2C1INT_Pos    (20UL)                    /*!< CTMRA2C1INT (Bit 20)                                  */
#define CTIMER_INTSTAT_CTMRA2C1INT_Msk    (0x100000UL)              /*!< CTMRA2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB1C1INT_Pos    (19UL)                    /*!< CTMRB1C1INT (Bit 19)                                  */
#define CTIMER_INTSTAT_CTMRB1C1INT_Msk    (0x80000UL)               /*!< CTMRB1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA1C1INT_Pos    (18UL)                    /*!< CTMRA1C1INT (Bit 18)                                  */
#define CTIMER_INTSTAT_CTMRA1C1INT_Msk    (0x40000UL)               /*!< CTMRA1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB0C1INT_Pos    (17UL)                    /*!< CTMRB0C1INT (Bit 17)                                  */
#define CTIMER_INTSTAT_CTMRB0C1INT_Msk    (0x20000UL)               /*!< CTMRB0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA0C1INT_Pos    (16UL)                    /*!< CTMRA0C1INT (Bit 16)                                  */
#define CTIMER_INTSTAT_CTMRA0C1INT_Msk    (0x10000UL)               /*!< CTMRA0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB7C0INT_Pos    (15UL)                    /*!< CTMRB7C0INT (Bit 15)                                  */
#define CTIMER_INTSTAT_CTMRB7C0INT_Msk    (0x8000UL)                /*!< CTMRB7C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA7C0INT_Pos    (14UL)                    /*!< CTMRA7C0INT (Bit 14)                                  */
#define CTIMER_INTSTAT_CTMRA7C0INT_Msk    (0x4000UL)                /*!< CTMRA7C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB6C0INT_Pos    (13UL)                    /*!< CTMRB6C0INT (Bit 13)                                  */
#define CTIMER_INTSTAT_CTMRB6C0INT_Msk    (0x2000UL)                /*!< CTMRB6C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA6C0INT_Pos    (12UL)                    /*!< CTMRA6C0INT (Bit 12)                                  */
#define CTIMER_INTSTAT_CTMRA6C0INT_Msk    (0x1000UL)                /*!< CTMRA6C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB5C0INT_Pos    (11UL)                    /*!< CTMRB5C0INT (Bit 11)                                  */
#define CTIMER_INTSTAT_CTMRB5C0INT_Msk    (0x800UL)                 /*!< CTMRB5C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA5C0INT_Pos    (10UL)                    /*!< CTMRA5C0INT (Bit 10)                                  */
#define CTIMER_INTSTAT_CTMRA5C0INT_Msk    (0x400UL)                 /*!< CTMRA5C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB4C0INT_Pos    (9UL)                     /*!< CTMRB4C0INT (Bit 9)                                   */
#define CTIMER_INTSTAT_CTMRB4C0INT_Msk    (0x200UL)                 /*!< CTMRB4C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA4C0INT_Pos    (8UL)                     /*!< CTMRA4C0INT (Bit 8)                                   */
#define CTIMER_INTSTAT_CTMRA4C0INT_Msk    (0x100UL)                 /*!< CTMRA4C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB3C0INT_Pos    (7UL)                     /*!< CTMRB3C0INT (Bit 7)                                   */
#define CTIMER_INTSTAT_CTMRB3C0INT_Msk    (0x80UL)                  /*!< CTMRB3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA3C0INT_Pos    (6UL)                     /*!< CTMRA3C0INT (Bit 6)                                   */
#define CTIMER_INTSTAT_CTMRA3C0INT_Msk    (0x40UL)                  /*!< CTMRA3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB2C0INT_Pos    (5UL)                     /*!< CTMRB2C0INT (Bit 5)                                   */
#define CTIMER_INTSTAT_CTMRB2C0INT_Msk    (0x20UL)                  /*!< CTMRB2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA2C0INT_Pos    (4UL)                     /*!< CTMRA2C0INT (Bit 4)                                   */
#define CTIMER_INTSTAT_CTMRA2C0INT_Msk    (0x10UL)                  /*!< CTMRA2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB1C0INT_Pos    (3UL)                     /*!< CTMRB1C0INT (Bit 3)                                   */
#define CTIMER_INTSTAT_CTMRB1C0INT_Msk    (0x8UL)                   /*!< CTMRB1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA1C0INT_Pos    (2UL)                     /*!< CTMRA1C0INT (Bit 2)                                   */
#define CTIMER_INTSTAT_CTMRA1C0INT_Msk    (0x4UL)                   /*!< CTMRA1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRB0C0INT_Pos    (1UL)                     /*!< CTMRB0C0INT (Bit 1)                                   */
#define CTIMER_INTSTAT_CTMRB0C0INT_Msk    (0x2UL)                   /*!< CTMRB0C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSTAT_CTMRA0C0INT_Pos    (0UL)                     /*!< CTMRA0C0INT (Bit 0)                                   */
#define CTIMER_INTSTAT_CTMRA0C0INT_Msk    (0x1UL)                   /*!< CTMRA0C0INT (Bitfield-Mask: 0x01)                     */
/* ========================================================  INTCLR  ========================================================= */
#define CTIMER_INTCLR_CTMRB7C1INT_Pos     (31UL)                    /*!< CTMRB7C1INT (Bit 31)                                  */
#define CTIMER_INTCLR_CTMRB7C1INT_Msk     (0x80000000UL)            /*!< CTMRB7C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA7C1INT_Pos     (30UL)                    /*!< CTMRA7C1INT (Bit 30)                                  */
#define CTIMER_INTCLR_CTMRA7C1INT_Msk     (0x40000000UL)            /*!< CTMRA7C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB6C1INT_Pos     (29UL)                    /*!< CTMRB6C1INT (Bit 29)                                  */
#define CTIMER_INTCLR_CTMRB6C1INT_Msk     (0x20000000UL)            /*!< CTMRB6C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA6C1INT_Pos     (28UL)                    /*!< CTMRA6C1INT (Bit 28)                                  */
#define CTIMER_INTCLR_CTMRA6C1INT_Msk     (0x10000000UL)            /*!< CTMRA6C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB5C1INT_Pos     (27UL)                    /*!< CTMRB5C1INT (Bit 27)                                  */
#define CTIMER_INTCLR_CTMRB5C1INT_Msk     (0x8000000UL)             /*!< CTMRB5C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA5C1INT_Pos     (26UL)                    /*!< CTMRA5C1INT (Bit 26)                                  */
#define CTIMER_INTCLR_CTMRA5C1INT_Msk     (0x4000000UL)             /*!< CTMRA5C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB4C1INT_Pos     (25UL)                    /*!< CTMRB4C1INT (Bit 25)                                  */
#define CTIMER_INTCLR_CTMRB4C1INT_Msk     (0x2000000UL)             /*!< CTMRB4C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA4C1INT_Pos     (24UL)                    /*!< CTMRA4C1INT (Bit 24)                                  */
#define CTIMER_INTCLR_CTMRA4C1INT_Msk     (0x1000000UL)             /*!< CTMRA4C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB3C1INT_Pos     (23UL)                    /*!< CTMRB3C1INT (Bit 23)                                  */
#define CTIMER_INTCLR_CTMRB3C1INT_Msk     (0x800000UL)              /*!< CTMRB3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA3C1INT_Pos     (22UL)                    /*!< CTMRA3C1INT (Bit 22)                                  */
#define CTIMER_INTCLR_CTMRA3C1INT_Msk     (0x400000UL)              /*!< CTMRA3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB2C1INT_Pos     (21UL)                    /*!< CTMRB2C1INT (Bit 21)                                  */
#define CTIMER_INTCLR_CTMRB2C1INT_Msk     (0x200000UL)              /*!< CTMRB2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA2C1INT_Pos     (20UL)                    /*!< CTMRA2C1INT (Bit 20)                                  */
#define CTIMER_INTCLR_CTMRA2C1INT_Msk     (0x100000UL)              /*!< CTMRA2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB1C1INT_Pos     (19UL)                    /*!< CTMRB1C1INT (Bit 19)                                  */
#define CTIMER_INTCLR_CTMRB1C1INT_Msk     (0x80000UL)               /*!< CTMRB1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA1C1INT_Pos     (18UL)                    /*!< CTMRA1C1INT (Bit 18)                                  */
#define CTIMER_INTCLR_CTMRA1C1INT_Msk     (0x40000UL)               /*!< CTMRA1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB0C1INT_Pos     (17UL)                    /*!< CTMRB0C1INT (Bit 17)                                  */
#define CTIMER_INTCLR_CTMRB0C1INT_Msk     (0x20000UL)               /*!< CTMRB0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA0C1INT_Pos     (16UL)                    /*!< CTMRA0C1INT (Bit 16)                                  */
#define CTIMER_INTCLR_CTMRA0C1INT_Msk     (0x10000UL)               /*!< CTMRA0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB7C0INT_Pos     (15UL)                    /*!< CTMRB7C0INT (Bit 15)                                  */
#define CTIMER_INTCLR_CTMRB7C0INT_Msk     (0x8000UL)                /*!< CTMRB7C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA7C0INT_Pos     (14UL)                    /*!< CTMRA7C0INT (Bit 14)                                  */
#define CTIMER_INTCLR_CTMRA7C0INT_Msk     (0x4000UL)                /*!< CTMRA7C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB6C0INT_Pos     (13UL)                    /*!< CTMRB6C0INT (Bit 13)                                  */
#define CTIMER_INTCLR_CTMRB6C0INT_Msk     (0x2000UL)                /*!< CTMRB6C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA6C0INT_Pos     (12UL)                    /*!< CTMRA6C0INT (Bit 12)                                  */
#define CTIMER_INTCLR_CTMRA6C0INT_Msk     (0x1000UL)                /*!< CTMRA6C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB5C0INT_Pos     (11UL)                    /*!< CTMRB5C0INT (Bit 11)                                  */
#define CTIMER_INTCLR_CTMRB5C0INT_Msk     (0x800UL)                 /*!< CTMRB5C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA5C0INT_Pos     (10UL)                    /*!< CTMRA5C0INT (Bit 10)                                  */
#define CTIMER_INTCLR_CTMRA5C0INT_Msk     (0x400UL)                 /*!< CTMRA5C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB4C0INT_Pos     (9UL)                     /*!< CTMRB4C0INT (Bit 9)                                   */
#define CTIMER_INTCLR_CTMRB4C0INT_Msk     (0x200UL)                 /*!< CTMRB4C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA4C0INT_Pos     (8UL)                     /*!< CTMRA4C0INT (Bit 8)                                   */
#define CTIMER_INTCLR_CTMRA4C0INT_Msk     (0x100UL)                 /*!< CTMRA4C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB3C0INT_Pos     (7UL)                     /*!< CTMRB3C0INT (Bit 7)                                   */
#define CTIMER_INTCLR_CTMRB3C0INT_Msk     (0x80UL)                  /*!< CTMRB3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA3C0INT_Pos     (6UL)                     /*!< CTMRA3C0INT (Bit 6)                                   */
#define CTIMER_INTCLR_CTMRA3C0INT_Msk     (0x40UL)                  /*!< CTMRA3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB2C0INT_Pos     (5UL)                     /*!< CTMRB2C0INT (Bit 5)                                   */
#define CTIMER_INTCLR_CTMRB2C0INT_Msk     (0x20UL)                  /*!< CTMRB2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA2C0INT_Pos     (4UL)                     /*!< CTMRA2C0INT (Bit 4)                                   */
#define CTIMER_INTCLR_CTMRA2C0INT_Msk     (0x10UL)                  /*!< CTMRA2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB1C0INT_Pos     (3UL)                     /*!< CTMRB1C0INT (Bit 3)                                   */
#define CTIMER_INTCLR_CTMRB1C0INT_Msk     (0x8UL)                   /*!< CTMRB1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA1C0INT_Pos     (2UL)                     /*!< CTMRA1C0INT (Bit 2)                                   */
#define CTIMER_INTCLR_CTMRA1C0INT_Msk     (0x4UL)                   /*!< CTMRA1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRB0C0INT_Pos     (1UL)                     /*!< CTMRB0C0INT (Bit 1)                                   */
#define CTIMER_INTCLR_CTMRB0C0INT_Msk     (0x2UL)                   /*!< CTMRB0C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTCLR_CTMRA0C0INT_Pos     (0UL)                     /*!< CTMRA0C0INT (Bit 0)                                   */
#define CTIMER_INTCLR_CTMRA0C0INT_Msk     (0x1UL)                   /*!< CTMRA0C0INT (Bitfield-Mask: 0x01)                     */
/* ========================================================  INTSET  ========================================================= */
#define CTIMER_INTSET_CTMRB7C1INT_Pos     (31UL)                    /*!< CTMRB7C1INT (Bit 31)                                  */
#define CTIMER_INTSET_CTMRB7C1INT_Msk     (0x80000000UL)            /*!< CTMRB7C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA7C1INT_Pos     (30UL)                    /*!< CTMRA7C1INT (Bit 30)                                  */
#define CTIMER_INTSET_CTMRA7C1INT_Msk     (0x40000000UL)            /*!< CTMRA7C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB6C1INT_Pos     (29UL)                    /*!< CTMRB6C1INT (Bit 29)                                  */
#define CTIMER_INTSET_CTMRB6C1INT_Msk     (0x20000000UL)            /*!< CTMRB6C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA6C1INT_Pos     (28UL)                    /*!< CTMRA6C1INT (Bit 28)                                  */
#define CTIMER_INTSET_CTMRA6C1INT_Msk     (0x10000000UL)            /*!< CTMRA6C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB5C1INT_Pos     (27UL)                    /*!< CTMRB5C1INT (Bit 27)                                  */
#define CTIMER_INTSET_CTMRB5C1INT_Msk     (0x8000000UL)             /*!< CTMRB5C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA5C1INT_Pos     (26UL)                    /*!< CTMRA5C1INT (Bit 26)                                  */
#define CTIMER_INTSET_CTMRA5C1INT_Msk     (0x4000000UL)             /*!< CTMRA5C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB4C1INT_Pos     (25UL)                    /*!< CTMRB4C1INT (Bit 25)                                  */
#define CTIMER_INTSET_CTMRB4C1INT_Msk     (0x2000000UL)             /*!< CTMRB4C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA4C1INT_Pos     (24UL)                    /*!< CTMRA4C1INT (Bit 24)                                  */
#define CTIMER_INTSET_CTMRA4C1INT_Msk     (0x1000000UL)             /*!< CTMRA4C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB3C1INT_Pos     (23UL)                    /*!< CTMRB3C1INT (Bit 23)                                  */
#define CTIMER_INTSET_CTMRB3C1INT_Msk     (0x800000UL)              /*!< CTMRB3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA3C1INT_Pos     (22UL)                    /*!< CTMRA3C1INT (Bit 22)                                  */
#define CTIMER_INTSET_CTMRA3C1INT_Msk     (0x400000UL)              /*!< CTMRA3C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB2C1INT_Pos     (21UL)                    /*!< CTMRB2C1INT (Bit 21)                                  */
#define CTIMER_INTSET_CTMRB2C1INT_Msk     (0x200000UL)              /*!< CTMRB2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA2C1INT_Pos     (20UL)                    /*!< CTMRA2C1INT (Bit 20)                                  */
#define CTIMER_INTSET_CTMRA2C1INT_Msk     (0x100000UL)              /*!< CTMRA2C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB1C1INT_Pos     (19UL)                    /*!< CTMRB1C1INT (Bit 19)                                  */
#define CTIMER_INTSET_CTMRB1C1INT_Msk     (0x80000UL)               /*!< CTMRB1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA1C1INT_Pos     (18UL)                    /*!< CTMRA1C1INT (Bit 18)                                  */
#define CTIMER_INTSET_CTMRA1C1INT_Msk     (0x40000UL)               /*!< CTMRA1C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB0C1INT_Pos     (17UL)                    /*!< CTMRB0C1INT (Bit 17)                                  */
#define CTIMER_INTSET_CTMRB0C1INT_Msk     (0x20000UL)               /*!< CTMRB0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA0C1INT_Pos     (16UL)                    /*!< CTMRA0C1INT (Bit 16)                                  */
#define CTIMER_INTSET_CTMRA0C1INT_Msk     (0x10000UL)               /*!< CTMRA0C1INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB7C0INT_Pos     (15UL)                    /*!< CTMRB7C0INT (Bit 15)                                  */
#define CTIMER_INTSET_CTMRB7C0INT_Msk     (0x8000UL)                /*!< CTMRB7C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA7C0INT_Pos     (14UL)                    /*!< CTMRA7C0INT (Bit 14)                                  */
#define CTIMER_INTSET_CTMRA7C0INT_Msk     (0x4000UL)                /*!< CTMRA7C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB6C0INT_Pos     (13UL)                    /*!< CTMRB6C0INT (Bit 13)                                  */
#define CTIMER_INTSET_CTMRB6C0INT_Msk     (0x2000UL)                /*!< CTMRB6C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA6C0INT_Pos     (12UL)                    /*!< CTMRA6C0INT (Bit 12)                                  */
#define CTIMER_INTSET_CTMRA6C0INT_Msk     (0x1000UL)                /*!< CTMRA6C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB5C0INT_Pos     (11UL)                    /*!< CTMRB5C0INT (Bit 11)                                  */
#define CTIMER_INTSET_CTMRB5C0INT_Msk     (0x800UL)                 /*!< CTMRB5C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA5C0INT_Pos     (10UL)                    /*!< CTMRA5C0INT (Bit 10)                                  */
#define CTIMER_INTSET_CTMRA5C0INT_Msk     (0x400UL)                 /*!< CTMRA5C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB4C0INT_Pos     (9UL)                     /*!< CTMRB4C0INT (Bit 9)                                   */
#define CTIMER_INTSET_CTMRB4C0INT_Msk     (0x200UL)                 /*!< CTMRB4C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA4C0INT_Pos     (8UL)                     /*!< CTMRA4C0INT (Bit 8)                                   */
#define CTIMER_INTSET_CTMRA4C0INT_Msk     (0x100UL)                 /*!< CTMRA4C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB3C0INT_Pos     (7UL)                     /*!< CTMRB3C0INT (Bit 7)                                   */
#define CTIMER_INTSET_CTMRB3C0INT_Msk     (0x80UL)                  /*!< CTMRB3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA3C0INT_Pos     (6UL)                     /*!< CTMRA3C0INT (Bit 6)                                   */
#define CTIMER_INTSET_CTMRA3C0INT_Msk     (0x40UL)                  /*!< CTMRA3C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB2C0INT_Pos     (5UL)                     /*!< CTMRB2C0INT (Bit 5)                                   */
#define CTIMER_INTSET_CTMRB2C0INT_Msk     (0x20UL)                  /*!< CTMRB2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA2C0INT_Pos     (4UL)                     /*!< CTMRA2C0INT (Bit 4)                                   */
#define CTIMER_INTSET_CTMRA2C0INT_Msk     (0x10UL)                  /*!< CTMRA2C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB1C0INT_Pos     (3UL)                     /*!< CTMRB1C0INT (Bit 3)                                   */
#define CTIMER_INTSET_CTMRB1C0INT_Msk     (0x8UL)                   /*!< CTMRB1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA1C0INT_Pos     (2UL)                     /*!< CTMRA1C0INT (Bit 2)                                   */
#define CTIMER_INTSET_CTMRA1C0INT_Msk     (0x4UL)                   /*!< CTMRA1C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRB0C0INT_Pos     (1UL)                     /*!< CTMRB0C0INT (Bit 1)                                   */
#define CTIMER_INTSET_CTMRB0C0INT_Msk     (0x2UL)                   /*!< CTMRB0C0INT (Bitfield-Mask: 0x01)                     */
#define CTIMER_INTSET_CTMRA0C0INT_Pos     (0UL)                     /*!< CTMRA0C0INT (Bit 0)                                   */
#define CTIMER_INTSET_CTMRA0C0INT_Msk     (0x1UL)                   /*!< CTMRA0C0INT (Bitfield-Mask: 0x01)                     */
/* =======================================================  STMINTEN  ======================================================== */
#define CTIMER_STMINTEN_CAPTURED_Pos      (12UL)                    /*!< CAPTURED (Bit 12)                                     */
#define CTIMER_STMINTEN_CAPTURED_Msk      (0x1000UL)                /*!< CAPTURED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_CAPTUREC_Pos      (11UL)                    /*!< CAPTUREC (Bit 11)                                     */
#define CTIMER_STMINTEN_CAPTUREC_Msk      (0x800UL)                 /*!< CAPTUREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_CAPTUREB_Pos      (10UL)                    /*!< CAPTUREB (Bit 10)                                     */
#define CTIMER_STMINTEN_CAPTUREB_Msk      (0x400UL)                 /*!< CAPTUREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_CAPTUREA_Pos      (9UL)                     /*!< CAPTUREA (Bit 9)                                      */
#define CTIMER_STMINTEN_CAPTUREA_Msk      (0x200UL)                 /*!< CAPTUREA (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_OVERFLOW_Pos      (8UL)                     /*!< OVERFLOW (Bit 8)                                      */
#define CTIMER_STMINTEN_OVERFLOW_Msk      (0x100UL)                 /*!< OVERFLOW (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREH_Pos      (7UL)                     /*!< COMPAREH (Bit 7)                                      */
#define CTIMER_STMINTEN_COMPAREH_Msk      (0x80UL)                  /*!< COMPAREH (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREG_Pos      (6UL)                     /*!< COMPAREG (Bit 6)                                      */
#define CTIMER_STMINTEN_COMPAREG_Msk      (0x40UL)                  /*!< COMPAREG (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREF_Pos      (5UL)                     /*!< COMPAREF (Bit 5)                                      */
#define CTIMER_STMINTEN_COMPAREF_Msk      (0x20UL)                  /*!< COMPAREF (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREE_Pos      (4UL)                     /*!< COMPAREE (Bit 4)                                      */
#define CTIMER_STMINTEN_COMPAREE_Msk      (0x10UL)                  /*!< COMPAREE (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPARED_Pos      (3UL)                     /*!< COMPARED (Bit 3)                                      */
#define CTIMER_STMINTEN_COMPARED_Msk      (0x8UL)                   /*!< COMPARED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREC_Pos      (2UL)                     /*!< COMPAREC (Bit 2)                                      */
#define CTIMER_STMINTEN_COMPAREC_Msk      (0x4UL)                   /*!< COMPAREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREB_Pos      (1UL)                     /*!< COMPAREB (Bit 1)                                      */
#define CTIMER_STMINTEN_COMPAREB_Msk      (0x2UL)                   /*!< COMPAREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTEN_COMPAREA_Pos      (0UL)                     /*!< COMPAREA (Bit 0)                                      */
#define CTIMER_STMINTEN_COMPAREA_Msk      (0x1UL)                   /*!< COMPAREA (Bitfield-Mask: 0x01)                        */
/* ======================================================  STMINTSTAT  ======================================================= */
#define CTIMER_STMINTSTAT_CAPTURED_Pos    (12UL)                    /*!< CAPTURED (Bit 12)                                     */
#define CTIMER_STMINTSTAT_CAPTURED_Msk    (0x1000UL)                /*!< CAPTURED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_CAPTUREC_Pos    (11UL)                    /*!< CAPTUREC (Bit 11)                                     */
#define CTIMER_STMINTSTAT_CAPTUREC_Msk    (0x800UL)                 /*!< CAPTUREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_CAPTUREB_Pos    (10UL)                    /*!< CAPTUREB (Bit 10)                                     */
#define CTIMER_STMINTSTAT_CAPTUREB_Msk    (0x400UL)                 /*!< CAPTUREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_CAPTUREA_Pos    (9UL)                     /*!< CAPTUREA (Bit 9)                                      */
#define CTIMER_STMINTSTAT_CAPTUREA_Msk    (0x200UL)                 /*!< CAPTUREA (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_OVERFLOW_Pos    (8UL)                     /*!< OVERFLOW (Bit 8)                                      */
#define CTIMER_STMINTSTAT_OVERFLOW_Msk    (0x100UL)                 /*!< OVERFLOW (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREH_Pos    (7UL)                     /*!< COMPAREH (Bit 7)                                      */
#define CTIMER_STMINTSTAT_COMPAREH_Msk    (0x80UL)                  /*!< COMPAREH (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREG_Pos    (6UL)                     /*!< COMPAREG (Bit 6)                                      */
#define CTIMER_STMINTSTAT_COMPAREG_Msk    (0x40UL)                  /*!< COMPAREG (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREF_Pos    (5UL)                     /*!< COMPAREF (Bit 5)                                      */
#define CTIMER_STMINTSTAT_COMPAREF_Msk    (0x20UL)                  /*!< COMPAREF (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREE_Pos    (4UL)                     /*!< COMPAREE (Bit 4)                                      */
#define CTIMER_STMINTSTAT_COMPAREE_Msk    (0x10UL)                  /*!< COMPAREE (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPARED_Pos    (3UL)                     /*!< COMPARED (Bit 3)                                      */
#define CTIMER_STMINTSTAT_COMPARED_Msk    (0x8UL)                   /*!< COMPARED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREC_Pos    (2UL)                     /*!< COMPAREC (Bit 2)                                      */
#define CTIMER_STMINTSTAT_COMPAREC_Msk    (0x4UL)                   /*!< COMPAREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREB_Pos    (1UL)                     /*!< COMPAREB (Bit 1)                                      */
#define CTIMER_STMINTSTAT_COMPAREB_Msk    (0x2UL)                   /*!< COMPAREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSTAT_COMPAREA_Pos    (0UL)                     /*!< COMPAREA (Bit 0)                                      */
#define CTIMER_STMINTSTAT_COMPAREA_Msk    (0x1UL)                   /*!< COMPAREA (Bitfield-Mask: 0x01)                        */
/* =======================================================  STMINTCLR  ======================================================= */
#define CTIMER_STMINTCLR_CAPTURED_Pos     (12UL)                    /*!< CAPTURED (Bit 12)                                     */
#define CTIMER_STMINTCLR_CAPTURED_Msk     (0x1000UL)                /*!< CAPTURED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_CAPTUREC_Pos     (11UL)                    /*!< CAPTUREC (Bit 11)                                     */
#define CTIMER_STMINTCLR_CAPTUREC_Msk     (0x800UL)                 /*!< CAPTUREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_CAPTUREB_Pos     (10UL)                    /*!< CAPTUREB (Bit 10)                                     */
#define CTIMER_STMINTCLR_CAPTUREB_Msk     (0x400UL)                 /*!< CAPTUREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_CAPTUREA_Pos     (9UL)                     /*!< CAPTUREA (Bit 9)                                      */
#define CTIMER_STMINTCLR_CAPTUREA_Msk     (0x200UL)                 /*!< CAPTUREA (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_OVERFLOW_Pos     (8UL)                     /*!< OVERFLOW (Bit 8)                                      */
#define CTIMER_STMINTCLR_OVERFLOW_Msk     (0x100UL)                 /*!< OVERFLOW (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREH_Pos     (7UL)                     /*!< COMPAREH (Bit 7)                                      */
#define CTIMER_STMINTCLR_COMPAREH_Msk     (0x80UL)                  /*!< COMPAREH (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREG_Pos     (6UL)                     /*!< COMPAREG (Bit 6)                                      */
#define CTIMER_STMINTCLR_COMPAREG_Msk     (0x40UL)                  /*!< COMPAREG (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREF_Pos     (5UL)                     /*!< COMPAREF (Bit 5)                                      */
#define CTIMER_STMINTCLR_COMPAREF_Msk     (0x20UL)                  /*!< COMPAREF (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREE_Pos     (4UL)                     /*!< COMPAREE (Bit 4)                                      */
#define CTIMER_STMINTCLR_COMPAREE_Msk     (0x10UL)                  /*!< COMPAREE (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPARED_Pos     (3UL)                     /*!< COMPARED (Bit 3)                                      */
#define CTIMER_STMINTCLR_COMPARED_Msk     (0x8UL)                   /*!< COMPARED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREC_Pos     (2UL)                     /*!< COMPAREC (Bit 2)                                      */
#define CTIMER_STMINTCLR_COMPAREC_Msk     (0x4UL)                   /*!< COMPAREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREB_Pos     (1UL)                     /*!< COMPAREB (Bit 1)                                      */
#define CTIMER_STMINTCLR_COMPAREB_Msk     (0x2UL)                   /*!< COMPAREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTCLR_COMPAREA_Pos     (0UL)                     /*!< COMPAREA (Bit 0)                                      */
#define CTIMER_STMINTCLR_COMPAREA_Msk     (0x1UL)                   /*!< COMPAREA (Bitfield-Mask: 0x01)                        */
/* =======================================================  STMINTSET  ======================================================= */
#define CTIMER_STMINTSET_CAPTURED_Pos     (12UL)                    /*!< CAPTURED (Bit 12)                                     */
#define CTIMER_STMINTSET_CAPTURED_Msk     (0x1000UL)                /*!< CAPTURED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_CAPTUREC_Pos     (11UL)                    /*!< CAPTUREC (Bit 11)                                     */
#define CTIMER_STMINTSET_CAPTUREC_Msk     (0x800UL)                 /*!< CAPTUREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_CAPTUREB_Pos     (10UL)                    /*!< CAPTUREB (Bit 10)                                     */
#define CTIMER_STMINTSET_CAPTUREB_Msk     (0x400UL)                 /*!< CAPTUREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_CAPTUREA_Pos     (9UL)                     /*!< CAPTUREA (Bit 9)                                      */
#define CTIMER_STMINTSET_CAPTUREA_Msk     (0x200UL)                 /*!< CAPTUREA (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_OVERFLOW_Pos     (8UL)                     /*!< OVERFLOW (Bit 8)                                      */
#define CTIMER_STMINTSET_OVERFLOW_Msk     (0x100UL)                 /*!< OVERFLOW (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREH_Pos     (7UL)                     /*!< COMPAREH (Bit 7)                                      */
#define CTIMER_STMINTSET_COMPAREH_Msk     (0x80UL)                  /*!< COMPAREH (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREG_Pos     (6UL)                     /*!< COMPAREG (Bit 6)                                      */
#define CTIMER_STMINTSET_COMPAREG_Msk     (0x40UL)                  /*!< COMPAREG (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREF_Pos     (5UL)                     /*!< COMPAREF (Bit 5)                                      */
#define CTIMER_STMINTSET_COMPAREF_Msk     (0x20UL)                  /*!< COMPAREF (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREE_Pos     (4UL)                     /*!< COMPAREE (Bit 4)                                      */
#define CTIMER_STMINTSET_COMPAREE_Msk     (0x10UL)                  /*!< COMPAREE (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPARED_Pos     (3UL)                     /*!< COMPARED (Bit 3)                                      */
#define CTIMER_STMINTSET_COMPARED_Msk     (0x8UL)                   /*!< COMPARED (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREC_Pos     (2UL)                     /*!< COMPAREC (Bit 2)                                      */
#define CTIMER_STMINTSET_COMPAREC_Msk     (0x4UL)                   /*!< COMPAREC (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREB_Pos     (1UL)                     /*!< COMPAREB (Bit 1)                                      */
#define CTIMER_STMINTSET_COMPAREB_Msk     (0x2UL)                   /*!< COMPAREB (Bitfield-Mask: 0x01)                        */
#define CTIMER_STMINTSET_COMPAREA_Pos     (0UL)                     /*!< COMPAREA (Bit 0)                                      */
#define CTIMER_STMINTSET_COMPAREA_Msk     (0x1UL)                   /*!< COMPAREA (Bitfield-Mask: 0x01)                        */


/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  PADREGA  ======================================================== */
#define GPIO_PADREGA_PAD3PWRUP_Pos        (30UL)                    /*!< PAD3PWRUP (Bit 30)                                    */
#define GPIO_PADREGA_PAD3PWRUP_Msk        (0x40000000UL)            /*!< PAD3PWRUP (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD3FNCSEL_Pos       (27UL)                    /*!< PAD3FNCSEL (Bit 27)                                   */
#define GPIO_PADREGA_PAD3FNCSEL_Msk       (0x38000000UL)            /*!< PAD3FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGA_PAD3STRNG_Pos        (26UL)                    /*!< PAD3STRNG (Bit 26)                                    */
#define GPIO_PADREGA_PAD3STRNG_Msk        (0x4000000UL)             /*!< PAD3STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD3INPEN_Pos        (25UL)                    /*!< PAD3INPEN (Bit 25)                                    */
#define GPIO_PADREGA_PAD3INPEN_Msk        (0x2000000UL)             /*!< PAD3INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD3PULL_Pos         (24UL)                    /*!< PAD3PULL (Bit 24)                                     */
#define GPIO_PADREGA_PAD3PULL_Msk         (0x1000000UL)             /*!< PAD3PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGA_PAD2FNCSEL_Pos       (19UL)                    /*!< PAD2FNCSEL (Bit 19)                                   */
#define GPIO_PADREGA_PAD2FNCSEL_Msk       (0x380000UL)              /*!< PAD2FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGA_PAD2STRNG_Pos        (18UL)                    /*!< PAD2STRNG (Bit 18)                                    */
#define GPIO_PADREGA_PAD2STRNG_Msk        (0x40000UL)               /*!< PAD2STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD2INPEN_Pos        (17UL)                    /*!< PAD2INPEN (Bit 17)                                    */
#define GPIO_PADREGA_PAD2INPEN_Msk        (0x20000UL)               /*!< PAD2INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD2PULL_Pos         (16UL)                    /*!< PAD2PULL (Bit 16)                                     */
#define GPIO_PADREGA_PAD2PULL_Msk         (0x10000UL)               /*!< PAD2PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGA_PAD1RSEL_Pos         (14UL)                    /*!< PAD1RSEL (Bit 14)                                     */
#define GPIO_PADREGA_PAD1RSEL_Msk         (0xc000UL)                /*!< PAD1RSEL (Bitfield-Mask: 0x03)                        */
#define GPIO_PADREGA_PAD1FNCSEL_Pos       (11UL)                    /*!< PAD1FNCSEL (Bit 11)                                   */
#define GPIO_PADREGA_PAD1FNCSEL_Msk       (0x3800UL)                /*!< PAD1FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGA_PAD1STRNG_Pos        (10UL)                    /*!< PAD1STRNG (Bit 10)                                    */
#define GPIO_PADREGA_PAD1STRNG_Msk        (0x400UL)                 /*!< PAD1STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD1INPEN_Pos        (9UL)                     /*!< PAD1INPEN (Bit 9)                                     */
#define GPIO_PADREGA_PAD1INPEN_Msk        (0x200UL)                 /*!< PAD1INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD1PULL_Pos         (8UL)                     /*!< PAD1PULL (Bit 8)                                      */
#define GPIO_PADREGA_PAD1PULL_Msk         (0x100UL)                 /*!< PAD1PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGA_PAD0RSEL_Pos         (6UL)                     /*!< PAD0RSEL (Bit 6)                                      */
#define GPIO_PADREGA_PAD0RSEL_Msk         (0xc0UL)                  /*!< PAD0RSEL (Bitfield-Mask: 0x03)                        */
#define GPIO_PADREGA_PAD0FNCSEL_Pos       (3UL)                     /*!< PAD0FNCSEL (Bit 3)                                    */
#define GPIO_PADREGA_PAD0FNCSEL_Msk       (0x38UL)                  /*!< PAD0FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGA_PAD0STRNG_Pos        (2UL)                     /*!< PAD0STRNG (Bit 2)                                     */
#define GPIO_PADREGA_PAD0STRNG_Msk        (0x4UL)                   /*!< PAD0STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD0INPEN_Pos        (1UL)                     /*!< PAD0INPEN (Bit 1)                                     */
#define GPIO_PADREGA_PAD0INPEN_Msk        (0x2UL)                   /*!< PAD0INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGA_PAD0PULL_Pos         (0UL)                     /*!< PAD0PULL (Bit 0)                                      */
#define GPIO_PADREGA_PAD0PULL_Msk         (0x1UL)                   /*!< PAD0PULL (Bitfield-Mask: 0x01)                        */
/* ========================================================  PADREGB  ======================================================== */
#define GPIO_PADREGB_PAD7FNCSEL_Pos       (27UL)                    /*!< PAD7FNCSEL (Bit 27)                                   */
#define GPIO_PADREGB_PAD7FNCSEL_Msk       (0x38000000UL)            /*!< PAD7FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGB_PAD7STRNG_Pos        (26UL)                    /*!< PAD7STRNG (Bit 26)                                    */
#define GPIO_PADREGB_PAD7STRNG_Msk        (0x4000000UL)             /*!< PAD7STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD7INPEN_Pos        (25UL)                    /*!< PAD7INPEN (Bit 25)                                    */
#define GPIO_PADREGB_PAD7INPEN_Msk        (0x2000000UL)             /*!< PAD7INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD7PULL_Pos         (24UL)                    /*!< PAD7PULL (Bit 24)                                     */
#define GPIO_PADREGB_PAD7PULL_Msk         (0x1000000UL)             /*!< PAD7PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGB_PAD6RSEL_Pos         (22UL)                    /*!< PAD6RSEL (Bit 22)                                     */
#define GPIO_PADREGB_PAD6RSEL_Msk         (0xc00000UL)              /*!< PAD6RSEL (Bitfield-Mask: 0x03)                        */
#define GPIO_PADREGB_PAD6FNCSEL_Pos       (19UL)                    /*!< PAD6FNCSEL (Bit 19)                                   */
#define GPIO_PADREGB_PAD6FNCSEL_Msk       (0x380000UL)              /*!< PAD6FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGB_PAD6STRNG_Pos        (18UL)                    /*!< PAD6STRNG (Bit 18)                                    */
#define GPIO_PADREGB_PAD6STRNG_Msk        (0x40000UL)               /*!< PAD6STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD6INPEN_Pos        (17UL)                    /*!< PAD6INPEN (Bit 17)                                    */
#define GPIO_PADREGB_PAD6INPEN_Msk        (0x20000UL)               /*!< PAD6INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD6PULL_Pos         (16UL)                    /*!< PAD6PULL (Bit 16)                                     */
#define GPIO_PADREGB_PAD6PULL_Msk         (0x10000UL)               /*!< PAD6PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGB_PAD5RSEL_Pos         (14UL)                    /*!< PAD5RSEL (Bit 14)                                     */
#define GPIO_PADREGB_PAD5RSEL_Msk         (0xc000UL)                /*!< PAD5RSEL (Bitfield-Mask: 0x03)                        */
#define GPIO_PADREGB_PAD5FNCSEL_Pos       (11UL)                    /*!< PAD5FNCSEL (Bit 11)                                   */
#define GPIO_PADREGB_PAD5FNCSEL_Msk       (0x3800UL)                /*!< PAD5FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGB_PAD5STRNG_Pos        (10UL)                    /*!< PAD5STRNG (Bit 10)                                    */
#define GPIO_PADREGB_PAD5STRNG_Msk        (0x400UL)                 /*!< PAD5STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD5INPEN_Pos        (9UL)                     /*!< PAD5INPEN (Bit 9)                                     */
#define GPIO_PADREGB_PAD5INPEN_Msk        (0x200UL)                 /*!< PAD5INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD5PULL_Pos         (8UL)                     /*!< PAD5PULL (Bit 8)                                      */
#define GPIO_PADREGB_PAD5PULL_Msk         (0x100UL)                 /*!< PAD5PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGB_PAD4FNCSEL_Pos       (3UL)                     /*!< PAD4FNCSEL (Bit 3)                                    */
#define GPIO_PADREGB_PAD4FNCSEL_Msk       (0x38UL)                  /*!< PAD4FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGB_PAD4STRNG_Pos        (2UL)                     /*!< PAD4STRNG (Bit 2)                                     */
#define GPIO_PADREGB_PAD4STRNG_Msk        (0x4UL)                   /*!< PAD4STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD4INPEN_Pos        (1UL)                     /*!< PAD4INPEN (Bit 1)                                     */
#define GPIO_PADREGB_PAD4INPEN_Msk        (0x2UL)                   /*!< PAD4INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGB_PAD4PULL_Pos         (0UL)                     /*!< PAD4PULL (Bit 0)                                      */
#define GPIO_PADREGB_PAD4PULL_Msk         (0x1UL)                   /*!< PAD4PULL (Bitfield-Mask: 0x01)                        */
/* ========================================================  PADREGC  ======================================================== */
#define GPIO_PADREGC_PAD11FNCSEL_Pos      (27UL)                    /*!< PAD11FNCSEL (Bit 27)                                  */
#define GPIO_PADREGC_PAD11FNCSEL_Msk      (0x38000000UL)            /*!< PAD11FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGC_PAD11STRNG_Pos       (26UL)                    /*!< PAD11STRNG (Bit 26)                                   */
#define GPIO_PADREGC_PAD11STRNG_Msk       (0x4000000UL)             /*!< PAD11STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGC_PAD11INPEN_Pos       (25UL)                    /*!< PAD11INPEN (Bit 25)                                   */
#define GPIO_PADREGC_PAD11INPEN_Msk       (0x2000000UL)             /*!< PAD11INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGC_PAD11PULL_Pos        (24UL)                    /*!< PAD11PULL (Bit 24)                                    */
#define GPIO_PADREGC_PAD11PULL_Msk        (0x1000000UL)             /*!< PAD11PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGC_PAD10FNCSEL_Pos      (19UL)                    /*!< PAD10FNCSEL (Bit 19)                                  */
#define GPIO_PADREGC_PAD10FNCSEL_Msk      (0x380000UL)              /*!< PAD10FNCSEL (Bitfield-Mask: 0x07)                     */
#define GPIO_PADREGC_PAD10STRNG_Pos       (18UL)                    /*!< PAD10STRNG (Bit 18)                                   */
#define GPIO_PADREGC_PAD10STRNG_Msk       (0x40000UL)               /*!< PAD10STRNG (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGC_PAD10INPEN_Pos       (17UL)                    /*!< PAD10INPEN (Bit 17)                                   */
#define GPIO_PADREGC_PAD10INPEN_Msk       (0x20000UL)               /*!< PAD10INPEN (Bitfield-Mask: 0x01)                      */
#define GPIO_PADREGC_PAD10PULL_Pos        (16UL)                    /*!< PAD10PULL (Bit 16)                                    */
#define GPIO_PADREGC_PAD10PULL_Msk        (0x10000UL)               /*!< PAD10PULL (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGC_PAD9RSEL_Pos         (14UL)                    /*!< PAD9RSEL (Bit 14)                                     */
#define GPIO_PADREGC_PAD9RSEL_Msk         (0xc000UL)                /*!< PAD9RSEL (Bitfield-Mask: 0x03)                        */
#define GPIO_PADREGC_PAD9FNCSEL_Pos       (11UL)                    /*!< PAD9FNCSEL (Bit 11)                                   */
#define GPIO_PADREGC_PAD9FNCSEL_Msk       (0x3800UL)                /*!< PAD9FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGC_PAD9STRNG_Pos        (10UL)                    /*!< PAD9STRNG (Bit 10)                                    */
#define GPIO_PADREGC_PAD9STRNG_Msk        (0x400UL)                 /*!< PAD9STRNG (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGC_PAD9INPEN_Pos        (9UL)                     /*!< PAD9INPEN (Bit 9)                                     */
#define GPIO_PADREGC_PAD9INPEN_Msk        (0x200UL)                 /*!< PAD9INPEN (Bitfield-Mask: 0x01)                       */
#define GPIO_PADREGC_PAD9PULL_Pos         (8UL)                     /*!< PAD9PULL (Bit 8)                                      */
#define GPIO_PADREGC_PAD9PULL_Msk         (0x100UL)                 /*!< PAD9PULL (Bitfield-Mask: 0x01)                        */
#define GPIO_PADREGC_PAD8RSEL_Pos         (6UL)                     /*!< PAD8RSEL (Bit 6)                                      */
#define GPIO_PADREGC_PAD8RSEL_Msk         (0xc0UL)                  /*!< PAD8RSEL (Bitfield-Mask: 0x03)                        */
#define GPIO_PADREGC_PAD8FNCSEL_Pos       (3UL)                     /*!< PAD8FNCSEL (Bit 3)                                    */
#define GPIO_PADREGC_PAD8FNCSEL_Msk       (0x38UL)                  /*!< PAD8FNCSEL (Bitfield-Mask: 0x07)                      */
#define GPIO_PADREGC_PAD8STRNG_Pos        (2UL)                     /*!< PAD8STRNG (Bit 2)                                     */
#define GPIO_PADREGC_