/**
 *******************************************************************************
 * @file    TMPM3HxA.h
 * @brief   CMSIS Cortex-M Core Peripheral Access Layer Header File for the
 *          TOSHIBA TXZp MICROCONTROLLER 
 * @version V1.0.0.0
 * $Date:: 2020-07-03 #$
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LICENSE AGREEMENT.
 * 
 * Copyright(C) Toshiba Electronic Device Solutions Corporation 2020
 *******************************************************************************
 */
#ifndef __TMPM3HxA_H__
#define __TMPM3HxA_H__

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup TOSHIBA_TXZp_MICROCONTROLLER TOSHIBA TXZp MICROCONTROLLER
  * @{
  */
  
/** @addtogroup TMPM3HxA
  * @{
  */

#if !defined(TMPM3HQA) && !defined(TMPM3HPA) && !defined(TMPM3HNA) && \
    !defined(TMPM3HMA) && !defined(TMPM3HLA)

/**
  * @brief Remove a comment of target device.
  */
   #define TMPM3HQA      /*!< TMPM3HQA device */
/* #define TMPM3HPA */   /*!< TMPM3HPA device */
/* #define TMPM3HNA */   /*!< TMPM3HNA device */
/* #define TMPM3HMA */   /*!< TMPM3HMA device */
/* #define TMPM3HLA */   /*!< TMPM3HLA device */

#endif

/** @defgroup Device_Included Device Included
  * @{
  */

#if defined(TMPM3HQA)
   #include "TMPM3HQA.h"
#elif defined(TMPM3HPA)
   #include "TMPM3HPA.h"
#elif defined(TMPM3HNA)
   #include "TMPM3HNA.h"
#elif defined(TMPM3HMA)
   #include "TMPM3HMA.h"
#elif defined(TMPM3HLA)
   #include "TMPM3HLA.h"
#else
   #error "target device is non-select."
#endif


/**
  * @}
  */ /* End of group Device_Included */

#ifdef __cplusplus
}
#endif

#endif  /* __TMPM3HxA_H__ */

/**
  * @}
  */ /* End of group TMPM3HxA */

/**
  * @}
  */ /* End of group TOSHIBA_TXZp_MICROCONTROLLER */
