/**
 *******************************************************************************
 * @file    TMPM3Hy.h
 * @brief   CMSIS Cortex-M3 Core Peripheral Access Layer Header File for the
 *          TOSHIBA 'TMPM3Hy' Group
 * @version V0.0.0.1
 * $Date:: 2018-06-08 #$
 * 
 * DO NOT USE THIS SOFTWARE WITHOUT THE SOFTWARE LISENCE AGREEMENT.
 * 
 * (C)Copyright TOSHIBA MICROELECTRONICS CORPORATION 2018 All rights reserved
 *******************************************************************************
 */
#ifndef __TMPM3Hy_H__
#define __TMPM3Hy_H__

#ifdef __cplusplus
extern "C" {
#endif

/** @addtogroup TOSHIBA_TXZ_MICROCONTROLLER TOSHIBA TXZ MICROCONTROLLER
  * @{
  */
  
/** @addtogroup TMPM3Hy TMPM3Hy
  * @{
  */

#if !defined(TMPM3HQ) && !defined(TMPM3HP) && !defined(TMPM3HN) && \
    !defined(TMPM3HM) && !defined(TMPM3HL) && !defined(TMPM3HN_L)

/**
  * @brief Remove a comment of target device.
  */
   #define TMPM3HQ      /*!< TMPM3HQ device */
/* #define TMPM3HP */   /*!< TMPM3HP device */
/* #define TMPM3HN */   /*!< TMPM3HN device */
/* #define TMPM3HM */   /*!< TMPM3HM device */
/* #define TMPM3HL */   /*!< TMPM3HL device */
/* #define TMPM3HN_L */ /*!< TMPM3HN_L edvice */
#endif

/** @defgroup Device_Included Device Included
  * @{
  */

#if defined(TMPM3HQ)
   #include "TMPM3HQ.h"
#elif defined(TMPM3HP)
   #include "TMPM3HP.h"
#elif defined(TMPM3HN)
   #include "TMPM3HN.h"
#elif defined(TMPM3HM)
   #include "TMPM3HM.h"
#elif defined(TMPM3HL)
   #include "TMPM3HL.h"
#elif defined(TMPM3HN_L)
   #include "TMPM3HN_L.h"
#else
   #error "target device is non-select."
#endif

/**
  * @}
  */ /* End of group Device_Included */

#ifdef __cplusplus
}
#endif

#endif  /* __TMPM3Hy_H__ */

/**
  * @}
  */ /* End of group TMPM3Hy */

/**
  * @}
  */ /* End of group TOSHIBA_TXZ_MICROCONTROLLER */
