/*********************************************************************
*                   (c) SEGGER Microcontroller GmbH                  *
*                        The Embedded Experts                        *
*                           www.segger.com                           *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------

File    : system_R7FS7G2.c
Purpose : Target specific system Init file
*/

#define system_R7FS7G2_C       // Used to control "extern" statements of global variables specified by this module
#include "system_R7FS7G2.h"

/*********************************************************************
*
*       Defines, configurable
*
**********************************************************************
*/

/*********************************************************************
*
*       Defines, fixed
*
**********************************************************************
*/

#define U8  unsigned char
#define U16 unsigned short
#define U32 unsigned long
#define U64 unsigned long long

#define I8  signed char
#define I16 signed short
#define I32 signed long

/*********************************************************************
*
*       Types, local
*
**********************************************************************
*/

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/
//
// Set HOCO to 16 MHz and set it to be enbled after reset
//
const U32  __attribute((section(".optbytes"))) _OptBytes[2] = {0xFFFFFFFF, 0xFFFFF8FF};

/*********************************************************************
*
*       Local functions
*
**********************************************************************
*/

/*********************************************************************
*
*       Global functions
*
**********************************************************************
*/

/*********************************************************************
*
*       SystemInit
*
* Return values:
*   >0 = OK, clockspeed [Hz] after prepare operation
*    0 = OK, clockspeed not changed by prepare operation
*   <0 = Error
*/
int SystemInit(void) {
  U8 v8;
  U32 v32;
  U16 PRCRVal;
  //
  // Lift register write protection
  //
  PRCRVal = SYSTEM_PRCR_16B & 0xFFFF;
  SYSTEM_PRCR_16B = (1 << 0) | (1 << 1) | (1 << 3) | (0xA5 << 8);  // Enable writing to system registers for clock selection etc.
  //
  // Init clocks (We assume 16 MHz HOCO) if you use other values make sure
  // to modify the init code accordingly!
  //
   v8 = SYSTEM_HOCOCR_8B;
  if (v8 & 1) {                                                 // HOCO stopped? => Enable/Start it
    SYSTEM_HOCOCR_8B = 0;
    while((SYSTEM_OSCSF_8B & (1 << 0)) == 0);
  }
  //
  // Init PLLout to 240 MHz, making sure we do not exceed the 240 MHz limit as HOCO may not be that precise
  // PLLin: 8-24 MHz
  // PLLout: 120-240 MHz
  // Clocks: ICLK max. 120 MHz
  //         FCLK max. 60 MHz
  //         Rest max. 60 MHz
  //
  if ((SYSTEM_PLLCR_8B & 1) == 0) {                              // PLL already operating? => Stop it
    SYSTEM_PLLCR_8B = 1;                                         // Stop PLL
    while ((SYSTEM_OSCSF_8B >> 5) & 1);
  }
  SYSTEM_PLLCCR_16B = 0           // PLLOut = (HOCO / PLDIV) * PLLMUL
                    | (28 << 8)   // PLLMUL
                    | ( 1 << 4)   // PLSRCSEL: 1 == HOCO
                    | ( 0 << 0)   // PLDIV: 00b/01b/10b == Div 1/2/3
                    ;
  SYSTEM_PLLCR_8B = 0;            // Start PLL
  while ((SYSTEM_OSCSF_8B & (1 << 5)) == 0);
  //
  // Setup clock dividers (ClockOut = In / (2^<Val>))
  //
  v32 = 0
      | (2 << 28) // FCK
      | (1 << 24) // ICK
      | (2 << 16) // BCK
      | (2 << 12) // PCLKA
      | (2 <<  8) // PCLKB
      | (2 <<  4) // PCLKC
      | (2 <<  0) // PCLKD
      ;
  SYSTEM_SCKDIVCR_32B = v32;
  while(SYSTEM_SCKDIVCR_32B != v32);
  SYSTEM_SCKSCR_8B = 5;                         // Source == PLL
  while(SYSTEM_SCKSCR_8B != 5);
  //
  // Prepare flash controller for higher speeds
  // ICLK <= 40 MHz:  0 wait states
  // ICLK <= 80 MHz:  1 wait states
  // ICLK <= 120 MHz: 2 wait states
  //
  v8 = _FLWT_REG_8B;
  if (v8 != 2) {
    _FLWT_REG_8B = 2;
  }
  //
  // Restore register write protection
  //
  SYSTEM_PRCR_16B = PRCRVal | (0xA5 << 8);                                          // Restore register write protection
  return 0;
}

/*************************** End of file ****************************/
