/*********************************************************************
*                   (c) SEGGER Microcontroller GmbH                  *
*                        The Embedded Experts                        *
*                           www.segger.com                           *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------

File    : system_R7FS7G2.h
*/

#ifndef system_R7FS7G2_H            // Avoid multiple inclusion.
#define system_R7FS7G2_H

#if defined(__cplusplus)
  extern "C" {                // Make sure we have C-declarations in C++ programs.
#endif

/*********************************************************************
*
*       Types, global
*
**********************************************************************
*/

/*********************************************************************
*
*       Global data
*
**********************************************************************
*/

#define SYSTEM_SCKDIVCR_32B  *((volatile U32*)0x4001E020)
#define SYSTEM_SCKDIVCR2_8B  *((volatile U8*)0x4001E024)
#define SYSTEM_SCKSCR_8B     *((volatile U8*)0x4001E026)
#define SYSTEM_PLLCCR_16B    *((volatile U16*)0x4001E028)
#define SYSTEM_PLLCCR2_8B    *((volatile U8*)0x4001E02B)
#define SYSTEM_PLLCR_8B      *((volatile U8*)0x4001E02A)
#define SYSTEM_BCKCR_8B      *((volatile U8*)0x4001E030)
#define SYSTEM_MEMWAIT_8B    *((volatile U8*)0x4001E031)
#define SYSTEM_MOSCCR_8B     *((volatile U8*)0x4001E032)
#define SYSTEM_SOSCCR_8B     *((volatile U8*)0x4001E480)
#define SYSTEM_LOCOCR_8B     *((volatile U8*)0x4001E490)
#define SYSTEM_HOCOCR_8B     *((volatile U8*)0x4001E036)
#define SYSTEM_MOCOCR_8B     *((volatile U8*)0x4001E038)
#define SYSTEM_OSCSF_8B      *((volatile U8*)0x4001E03C)
#define SYSTEM_OSTDCR_8B     *((volatile U8*)0x4001E040)
#define SYSTEM_OSTDSR_8B     *((volatile U8*)0x4001E041)
#define SYSTEM_OPCCR_8B      *((volatile U8*)0x4001E0A0)
#define SYSTEM_MOSCWTCR_8B   *((volatile U8*)0x4001E0A2)
#define SYSTEM_MOMCR_8B      *((volatile U8*)0x4001E413)
#define SYSTEM_SOMCR_8B      *((volatile U8*)0x4001E481)
#define SYSTEM_SLCDSCKCR_8B  *((volatile U8*)0x4001E050)
#define SYSTEM_CKOCR_8B      *((volatile U8*)0x4001E03E)
#define SYSTEM_EBCKOCR_8B    *((volatile U8*)0x4001E052)
#define SYSTEM_SDCKOCR_8B    *((volatile U8*)0x4001E053)
#define SYSTEM_LOCOUTCR_8B   *((volatile U8*)0x4001E492)
#define SYSTEM_MOCOUTCR_8B   *((volatile U8*)0x4001E061)
#define SYSTEM_HOCOUTCR_8B   *((volatile U8*)0x4001E062)
#define SYSTEM_PRCR_16B      *((volatile U16*)0x4001E3FE)
#define _FLWT_REG_8B         *((volatile U8*)0x4001C11C)

#ifdef   EXTERN
  #undef EXTERN
#endif

#ifndef system_R7FS7G2_C       
  #define EXTERN extern
#else
  #define EXTERN
#endif

EXTERN int TEMPLATE_Data;

#undef EXTERN

/*********************************************************************
*
*       API functions / Function prototypes
*
**********************************************************************
*/

#if defined(__cplusplus)
}                             // Make sure we have C-declarations in C++ programs.
#endif

#endif                        // Avoid multiple inclusion.

/*************************** End of file ****************************/
