/*********************************************************************
*               (c) SEGGER Microcontroller GmbH & Co. KG             *
*                        The Embedded Experts                        *
*                           www.segger.com                           *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------

File    : TraceDemo.c
Purpose : .
*/

#include "BSP.h"

/*********************************************************************
*
*       Static data
*
**********************************************************************
*/

volatile unsigned int _TestFunc0Cnt;
volatile unsigned int _TestFunc1Cnt;
volatile unsigned int _TestFunc2Cnt;

/*********************************************************************
*
*       Types
*
**********************************************************************
*/

typedef void (*TestFunc) (void);

/*********************************************************************
*
*       Local functions
*
**********************************************************************
*/

/********************************************************************* 
*
*       _TestFunc0b()
*
*  Function description
*    Simply dummy function called via function pointer.
*/
static void _TestFunc0b(void) {
  _TestFunc0Cnt = 0;
}

/********************************************************************* 
*
*       _TestFunc0b()
*
*  Function description
*    Simply dummy function called via function pointer.
*/
static void _TestFunc0a(void) {
  _TestFunc0Cnt++;
}

/********************************************************************* 
*
*       _TestFunc0()
*
*  Function description
*    Simple dummy function using function pointers.
*/
static void _TestFunc0(void) {
  TestFunc pF;

  if (_TestFunc0Cnt < 2000) {
    pF = _TestFunc0a;
  } else {
    pF = _TestFunc0b;
  }
  pF();
}

/********************************************************************* 
*
*       _TestFunc1()
*
*  Function description
*    Simple dummy function.
*/
static void _TestFunc1(void) {
  if (_TestFunc1Cnt < 2000) {
    _TestFunc1Cnt++;
  } else {
    _TestFunc1Cnt = 0;
  }
}

/********************************************************************* 
*
*       _TestFunc2()
*
*  Function description
*    Simple dummy function.
*/
static void _TestFunc2(void) {
  _TestFunc2Cnt = 10000;
  do {
    _TestFunc2Cnt--;
  } while (_TestFunc2Cnt);
}

/*********************************************************************
*
*       Global functions
*
**********************************************************************
*/
/********************************************************************* 
*
*       main()
*/
int main(void) {
  int Cnt;

  Cnt = 0;
  BSP_Init();
  BSP_SetLED(0);
  while (1) {
    Cnt++;
    _TestFunc0();
    _TestFunc1();
    _TestFunc2();

    if ((Cnt % 10) == 0) {
      BSP_ToggleLED((Cnt / 10) % 3);
    }
  }
  return 0;
}

/****** End Of File *************************************************/
