/*
 * Copyright (C) 2015-2017, Ambiq Micro
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 
 * 3. Neither the name of the copyright holder nor the names of itscontributors may be used to endorse
 * or promote products derived from thissoftware without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @file     apollo1.h
 * @brief    CMSIS HeaderFile
 * @version  1.0
 * @date     13. March 2017
 * @note     Generated by SVDConv V3.2.53 on Monday, 13.03.2017 18:37:05
 *           from File 'apollo1.svd',
 *           last modified on Monday, 13.03.2017 23:37:02
 */



/** @addtogroup Ambiq Micro
  * @{
  */


/** @addtogroup apollo1
  * @{
  */


#ifndef APOLLO1_H
#define APOLLO1_H

#ifdef __cplusplus
extern "C" {
#endif


/** @addtogroup Configuration_of_CMSIS
  * @{
  */



/* =========================================================================================================================== */
/* ================                                Interrupt Number Definition                                ================ */
/* =========================================================================================================================== */

typedef enum {
/* =======================================  ARM Cortex-M4 Specific Interrupt Numbers  ======================================== */
  Reset_IRQn                = -15,              /*!< -15  Reset Vector, invoked on Power up and warm reset                     */
  NonMaskableInt_IRQn       = -14,              /*!< -14  Non maskable Interrupt, cannot be stopped or preempted               */
  HardFault_IRQn            = -13,              /*!< -13  Hard Fault, all classes of Fault                                     */
  MemoryManagement_IRQn     = -12,              /*!< -12  Memory Management, MPU mismatch, including Access Violation
                                                      and No Match                                                             */
  BusFault_IRQn             = -11,              /*!< -11  Bus Fault, Pre-Fetch-, Memory Access Fault, other address/memory
                                                      related Fault                                                            */
  UsageFault_IRQn           = -10,              /*!< -10  Usage Fault, i.e. Undef Instruction, Illegal State Transition        */
  SVCall_IRQn               =  -5,              /*!< -5 System Service Call via SVC instruction                                */
  DebugMonitor_IRQn         =  -4,              /*!< -4 Debug Monitor                                                          */
  PendSV_IRQn               =  -2,              /*!< -2 Pendable request for system service                                    */
  SysTick_IRQn              =  -1,              /*!< -1 System Tick Timer                                                      */
/* ==========================================  apollo1 Specific Interrupt Numbers  =========================================== */
  BROWNOUT_IRQn             =   0,              /*!< 0  BROWNOUT                                                               */
  WDT_IRQn                  =   1,              /*!< 1  WDT                                                                    */
  CLKGEN_RTC_IRQn           =   2,              /*!< 2  CLKGEN_RTC                                                             */
  VCOMP_IRQn                =   3,              /*!< 3  VCOMP                                                                  */
  IOSLAVE_IRQn              =   4,              /*!< 4  IOSLAVE                                                                */
  IOSLAVEACC_IRQn           =   5,              /*!< 5  IOSLAVEACC                                                             */
  IOMSTR0_IRQn              =   6,              /*!< 6  IOMSTR0                                                                */
  IOMSTR1_IRQn              =   7,              /*!< 7  IOMSTR1                                                                */
  ADC_IRQn                  =   8,              /*!< 8  ADC                                                                    */
  GPIO_IRQn                 =   9,              /*!< 9  GPIO                                                                   */
  CTIMER_IRQn               =  10,              /*!< 10 CTIMER                                                                 */
  UART_IRQn                 =  11               /*!< 11 UART                                                                   */
} IRQn_Type;



/* =========================================================================================================================== */
/* ================                           Processor and Core Peripheral Section                           ================ */
/* =========================================================================================================================== */

/* ===========================  Configuration of the ARM Cortex-M4 Processor and Core Peripherals  =========================== */
#define __CM4_REV                 0x0100U       /*!< CM4 Core Revision                                                         */
#define __NVIC_PRIO_BITS               3        /*!< Number of Bits used for Priority Levels                                   */
#define __Vendor_SysTickConfig         0        /*!< Set to 1 if different SysTick Config is used                              */
#define __MPU_PRESENT                  1        /*!< MPU present or not                                                        */
#define __FPU_PRESENT                  1        /*!< FPU present or not                                                        */


/** @} */ /* End of group Configuration_of_CMSIS */

#include "core_cm4.h"                           /*!< ARM Cortex-M4 processor and core peripherals                              */
#include "system_apollo1.h"                     /*!< apollo1 System                                                            */

#ifndef __IM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __IM   __I
#endif
#ifndef __OM                                    /*!< Fallback for older CMSIS versions                                         */
  #define __OM   __O
#endif
#ifndef __IOM                                   /*!< Fallback for older CMSIS versions                                         */
  #define __IOM  __IO
#endif


/* ========================================  Start of section using anonymous unions  ======================================== */
#if defined (__CC_ARM)
  #pragma push
  #pragma anon_unions
#elif defined (__ICCARM__)
  #pragma language=extended
#elif defined(__ARMCC_VERSION) && (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic push
  #pragma clang diagnostic ignored "-Wc11-extensions"
  #pragma clang diagnostic ignored "-Wreserved-id-macro"
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning 586
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#else
  #warning Not supported compiler type
#endif


/* =========================================================================================================================== */
/* ================                            Device Specific Peripheral Section                             ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Analog Digital Converter Control (ADC)
  */

typedef struct {                                /*!< (@ 0x50008000) ADC Structure                                              */
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */
    
    struct {
      __IOM uint32_t ADCEN      : 1;            /*!< (@ 0x00000000) This bit enables the ADC module. While the ADC
                                                                    is enabled, the ADCCFG and SLOT Configuration
                                                                    regsiter settings must remain stable and
                                                                    unchanged.                                                 */
      __IOM uint32_t TMPSPWR    : 1;            /*!< (@ 0x00000001) This enables power to the temperature sensor
                                                                    module. After setting this bit, the temperature
                                                                    sensor will remain powered down while the
                                                                    ADC is power is disconnected (i.e, when
                                                                    the ADC PWDSTAT is 2'b10).                                 */
      __IOM uint32_t RPTEN      : 1;            /*!< (@ 0x00000002) This bit enables Repeating Scan Mode.                      */
      __IOM uint32_t LPMODE     : 2;            /*!< (@ 0x00000003) Select power mode to enter between active scans.           */
      __IOM uint32_t OPMODE     : 2;            /*!< (@ 0x00000005) Select the sample rate mode. It adjusts the current
                                                                    in the ADC for higher sample rates. A 12MHz
                                                                    ADC clock can result in a sample rate up
                                                                    to 1Msps depending on the trigger or repeating
                                                                    mode rate. A 1.5MHz ADC clock can result
                                                                    in a sample rate up 125K sps. NOTE: All
                                                                    other values not specified below are undefined.            */
      __IOM uint32_t BATTLOAD   : 1;            /*!< (@ 0x00000007) Control 500 Ohm battery load resistor.                     */
      __IOM uint32_t REFSEL     : 2;            /*!< (@ 0x00000008) Select the ADC reference voltage.                          */
      __IM  uint32_t            : 6;
      __IOM uint32_t TRIGSEL    : 4;            /*!< (@ 0x00000010) Select the ADC trigger source.                             */
      __IOM uint32_t TRIGPOL    : 1;            /*!< (@ 0x00000014) This bit selects the ADC trigger polarity for
                                                                    external off chip triggers.                                */
      __IM  uint32_t            : 3;
      __IOM uint32_t CLKSEL     : 3;            /*!< (@ 0x00000018) Select the source and frequency for the ADC clock.
                                                                    All values not enumerated below are undefined.             */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) ADC Power Status                                           */
    
    struct {
      __IOM uint32_t PWDSTAT    : 2;            /*!< (@ 0x00000000) Indicates the power-status of the ADC.                     */
    } STAT_b;
  } ;
  
  union {
    __IOM uint32_t SWT;                         /*!< (@ 0x00000008) Software trigger                                           */
    
    struct {
      __IOM uint32_t SWT        : 8;            /*!< (@ 0x00000000) Writing 0x37 to this register generates a software
                                                                    trigger.                                                   */
    } SWT_b;
  } ;
  
  union {
    __IOM uint32_t SL0CFG;                      /*!< (@ 0x0000000C) Slot 0 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN0      : 1;            /*!< (@ 0x00000000) This bit enables slot 0 for ADC conversions.               */
      __IOM uint32_t WCEN0      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 0.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL0     : 4;            /*!< (@ 0x00000008) Select one of the 13 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t THSEL0     : 3;            /*!< (@ 0x00000010) Select the track and hold delay for this slot.
                                                                    NOTE: The track and hold delay must be
                                                                    less than 50us for correct operation. When
                                                                    the ADC is configured to use the 1.5Mhz
                                                                    clock, the track and hold delay cannot
                                                                    exceed 64 clocks.                                          */
      __IM  uint32_t            : 5;
      __IOM uint32_t ADSEL0     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL0CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL1CFG;                      /*!< (@ 0x00000010) Slot 1 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN1      : 1;            /*!< (@ 0x00000000) This bit enables slot 1 for ADC conversions.               */
      __IOM uint32_t WCEN1      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 1.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL1     : 4;            /*!< (@ 0x00000008) Select one of the 13 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t THSEL1     : 3;            /*!< (@ 0x00000010) Select the track and hold delay for this slot.
                                                                    NOTE: The track and hold delay must be
                                                                    less than 50us for correct operation. When
                                                                    the ADC is configured to use the 1.5 Mhz
                                                                    clock, the track and hold delay cannot
                                                                    exceed 64 clocks.                                          */
      __IM  uint32_t            : 5;
      __IOM uint32_t ADSEL1     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL1CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL2CFG;                      /*!< (@ 0x00000014) Slot 2 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN2      : 1;            /*!< (@ 0x00000000) This bit enables slot 2 for ADC conversions.               */
      __IOM uint32_t WCEN2      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 2.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL2     : 4;            /*!< (@ 0x00000008) Select one of the 13 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t THSEL2     : 3;            /*!< (@ 0x00000010) Select the track and hold delay for this slot.
                                                                    NOTE: The track and hold delay must be
                                                                    less than 50us for correct operation. When
                                                                    the ADC is configured to use the 1.5Mhz
                                                                    clock, the track and hold delay cannot
                                                                    exceed 64 clocks.                                          */
      __IM  uint32_t            : 5;
      __IOM uint32_t ADSEL2     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL2CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL3CFG;                      /*!< (@ 0x00000018) Slot 3 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN3      : 1;            /*!< (@ 0x00000000) This bit enables slot 3 for ADC conversions.               */
      __IOM uint32_t WCEN3      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 3.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL3     : 4;            /*!< (@ 0x00000008) Select one of the 13 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t THSEL3     : 3;            /*!< (@ 0x00000010) Select the track and hold delay for this slot.
                                                                    NOTE: The track and hold delay must be
                                                                    less than 50us for correct operation. When
                                                                    the ADC is configured to use the 1.5Mhz
                                                                    clock, the track and hold delay cannot
                                                                    exceed 64 clocks.                                          */
      __IM  uint32_t            : 5;
      __IOM uint32_t ADSEL3     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL3CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL4CFG;                      /*!< (@ 0x0000001C) Slot 4 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN4      : 1;            /*!< (@ 0x00000000) This bit enables slot 4 for ADC conversions.               */
      __IOM uint32_t WCEN4      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 4.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL4     : 4;            /*!< (@ 0x00000008) Select one of the 13 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t THSEL4     : 3;            /*!< (@ 0x00000010) Select the track and hold delay for this slot.
                                                                    NOTE: The track and hold delay must be
                                                                    less than 50us for correct operation. When
                                                                    the ADC is configured to use the 1.5Mhz
                                                                    clock, the track and hold delay cannot
                                                                    exceed 64 clocks.                                          */
      __IM  uint32_t            : 5;
      __IOM uint32_t ADSEL4     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL4CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL5CFG;                      /*!< (@ 0x00000020) Slot 5 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN5      : 1;            /*!< (@ 0x00000000) This bit enables slot 5 for ADC conversions.               */
      __IOM uint32_t WCEN5      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 5.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL5     : 4;            /*!< (@ 0x00000008) Select one of the 13 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t THSEL5     : 3;            /*!< (@ 0x00000010) Select track and hold delay for this slot. NOTE:
                                                                    The track and hold delay must be less than
                                                                    50us for correct operation. When the ADC
                                                                    is configured to use the 1.5Mhz clock,
                                                                    the track and hold delay cannot exceed
                                                                    64 clocks.                                                 */
      __IM  uint32_t            : 5;
      __IOM uint32_t ADSEL5     : 3;            /*!< (@ 0x00000018) Select number of measurements to average in the
                                                                    accumulate divide module for this slot.                    */
    } SL5CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL6CFG;                      /*!< (@ 0x00000024) Slot 6 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN6      : 1;            /*!< (@ 0x00000000) This bit enables slot 6 for ADC conversions.               */
      __IOM uint32_t WCEN6      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 6.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL6     : 4;            /*!< (@ 0x00000008) Select one of the 13 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t THSEL6     : 3;            /*!< (@ 0x00000010) Select track and hold delay for this slot. NOTE:
                                                                    The track and hold delay must be less than
                                                                    50us for correct operation. When the ADC
                                                                    is configured to use the 1.5Mhz clock,
                                                                    the track and hold delay cannot exceed
                                                                    64 clocks.                                                 */
      __IM  uint32_t            : 5;
      __IOM uint32_t ADSEL6     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL6CFG_b;
  } ;
  
  union {
    __IOM uint32_t SL7CFG;                      /*!< (@ 0x00000028) Slot 7 Configuration Register                              */
    
    struct {
      __IOM uint32_t SLEN7      : 1;            /*!< (@ 0x00000000) This bit enables slot 7 for ADC conversions.               */
      __IOM uint32_t WCEN7      : 1;            /*!< (@ 0x00000001) This bit enables the window compare function
                                                                    for slot 7.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t CHSEL7     : 4;            /*!< (@ 0x00000008) Select one of the 13 channel inputs for this
                                                                    slot.                                                      */
      __IM  uint32_t            : 4;
      __IOM uint32_t THSEL7     : 3;            /*!< (@ 0x00000010) Select track and hold delay for this slot. NOTE:
                                                                    The track and hold delay must be less than
                                                                    50us for correct operation. When the ADC
                                                                    is configured to use the 1.5Mhz clock,
                                                                    the track and hold delay cannot exceed
                                                                    64 clocks.                                                 */
      __IM  uint32_t            : 5;
      __IOM uint32_t ADSEL7     : 3;            /*!< (@ 0x00000018) Select the number of measurements to average
                                                                    in the accumulate divide module for this
                                                                    slot.                                                      */
    } SL7CFG_b;
  } ;
  
  union {
    __IOM uint32_t WLIM;                        /*!< (@ 0x0000002C) Window Comparator Limits Register                          */
    
    struct {
      __IOM uint32_t LLIM       : 16;           /*!< (@ 0x00000000) Sets the lower limit for the wondow comparator.            */
      __IOM uint32_t ULIM       : 16;           /*!< (@ 0x00000010) Sets the upper limit for the wondow comparator.            */
    } WLIM_b;
  } ;
  
  union {
    __IOM uint32_t FIFO;                        /*!< (@ 0x00000030) FIFO Data and Valid Count Register                         */
    
    struct {
      __IOM uint32_t DATA       : 16;           /*!< (@ 0x00000000) Oldest data in the FIFO.                                   */
      __IOM uint32_t COUNT      : 4;            /*!< (@ 0x00000010) Number of valid entries in the ADC FIFO.                   */
      __IOM uint32_t RSVD_20    : 4;            /*!< (@ 0x00000014) RESERVED.                                                  */
      __IOM uint32_t SLOTNUM    : 3;            /*!< (@ 0x00000018) Slot number associated with this FIFO data.                */
      __IOM uint32_t RSVD_27    : 5;            /*!< (@ 0x0000001B) RESERVED.                                                  */
    } FIFO_b;
  } ;
  __IM  uint32_t  RESERVED[115];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) ADC Interrupt registers: Enable                            */
    
    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< (@ 0x00000000) ADC conversion complete interrupt.                         */
      __IOM uint32_t SCNCMP     : 1;            /*!< (@ 0x00000001) ADC scan complete interrupt.                               */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< (@ 0x00000002) FIFO 75 percent full interrupt.                            */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< (@ 0x00000003) FIFO 100 percent full interrupt.                           */
      __IOM uint32_t WCEXC      : 1;            /*!< (@ 0x00000004) Window comparator voltage excursion interrupt.             */
      __IOM uint32_t WCINC      : 1;            /*!< (@ 0x00000005) Window comparator voltage incursion interrupt.             */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) ADC Interrupt registers: Status                            */
    
    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< (@ 0x00000000) ADC conversion complete interrupt.                         */
      __IOM uint32_t SCNCMP     : 1;            /*!< (@ 0x00000001) ADC scan complete interrupt.                               */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< (@ 0x00000002) FIFO 75 percent full interrupt.                            */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< (@ 0x00000003) FIFO 100 percent full interrupt.                           */
      __IOM uint32_t WCEXC      : 1;            /*!< (@ 0x00000004) Window comparator voltage excursion interrupt.             */
      __IOM uint32_t WCINC      : 1;            /*!< (@ 0x00000005) Window comparator voltage incursion interrupt.             */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) ADC Interrupt registers: Clear                             */
    
    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< (@ 0x00000000) ADC conversion complete interrupt.                         */
      __IOM uint32_t SCNCMP     : 1;            /*!< (@ 0x00000001) ADC scan complete interrupt.                               */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< (@ 0x00000002) FIFO 75 percent full interrupt.                            */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< (@ 0x00000003) FIFO 100 percent full interrupt.                           */
      __IOM uint32_t WCEXC      : 1;            /*!< (@ 0x00000004) Window comparator voltage excursion interrupt.             */
      __IOM uint32_t WCINC      : 1;            /*!< (@ 0x00000005) Window comparator voltage incursion interrupt.             */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) ADC Interrupt registers: Set                               */
    
    struct {
      __IOM uint32_t CNVCMP     : 1;            /*!< (@ 0x00000000) ADC conversion complete interrupt.                         */
      __IOM uint32_t SCNCMP     : 1;            /*!< (@ 0x00000001) ADC scan complete interrupt.                               */
      __IOM uint32_t FIFOOVR1   : 1;            /*!< (@ 0x00000002) FIFO 75 percent full interrupt.                            */
      __IOM uint32_t FIFOOVR2   : 1;            /*!< (@ 0x00000003) FIFO 100 percent full interrupt.                           */
      __IOM uint32_t WCEXC      : 1;            /*!< (@ 0x00000004) Window comparator voltage excursion interrupt.             */
      __IOM uint32_t WCINC      : 1;            /*!< (@ 0x00000005) Window comparator voltage incursion interrupt.             */
    } INTSET_b;
  } ;
} ADC_Type;                                     /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                          CTIMER                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Counter/Timer (CTIMER)
  */

typedef struct {                                /*!< (@ 0x40008000) CTIMER Structure                                           */
  
  union {
    __IOM uint32_t TMR0;                        /*!< (@ 0x00000000) Counter/Timer Register                                     */
    
    struct {
      __IOM uint32_t CTTMRA0    : 16;           /*!< (@ 0x00000000) Counter/Timer A0.                                          */
      __IOM uint32_t CTTMRB0    : 16;           /*!< (@ 0x00000010) Counter/Timer B0.                                          */
    } TMR0_b;
  } ;
  
  union {
    __IOM uint32_t CMPRA0;                      /*!< (@ 0x00000004) Counter/Timer A0 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0A0    : 16;           /*!< (@ 0x00000000) Counter/Timer A0 Compare Register 0. Holds the
                                                                    lower limit for timer half A.                              */
      __IOM uint32_t CMPR1A0    : 16;           /*!< (@ 0x00000010) Counter/Timer A0 Compare Register 1. Holds the
                                                                    upper limit for timer half A.                              */
    } CMPRA0_b;
  } ;
  
  union {
    __IOM uint32_t CMPRB0;                      /*!< (@ 0x00000008) Counter/Timer B0 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0B0    : 16;           /*!< (@ 0x00000000) Counter/Timer B0 Compare Register 0. Holds the
                                                                    lower limit for timer half B.                              */
      __IOM uint32_t CMPR1B0    : 16;           /*!< (@ 0x00000010) Counter/Timer B0 Compare Register 1. Holds the
                                                                    upper limit for timer half B.                              */
    } CMPRB0_b;
  } ;
  
  union {
    __IOM uint32_t CTRL0;                       /*!< (@ 0x0000000C) Counter/Timer Control                                      */
    
    struct {
      __IOM uint32_t TMRA0EN    : 1;            /*!< (@ 0x00000000) Counter/Timer A0 Enable bit.                               */
      __IOM uint32_t TMRA0CLK   : 5;            /*!< (@ 0x00000001) Counter/Timer A0 Clock Select.                             */
      __IOM uint32_t TMRA0FN    : 3;            /*!< (@ 0x00000006) Counter/Timer A0 Function Select.                          */
      __IOM uint32_t TMRA0IE    : 1;            /*!< (@ 0x00000009) Counter/Timer A0 Interrupt Enable bit.                     */
      __IOM uint32_t TMRA0PE    : 1;            /*!< (@ 0x0000000A) Counter/Timer A0 Output Enable bit.                        */
      __IOM uint32_t TMRA0CLR   : 1;            /*!< (@ 0x0000000B) Counter/Timer A0 Clear bit.                                */
      __IOM uint32_t TMRA0POL   : 1;            /*!< (@ 0x0000000C) Counter/Timer A0 output polarity.                          */
      __IM  uint32_t            : 3;
      __IOM uint32_t TMRB0EN    : 1;            /*!< (@ 0x00000010) Counter/Timer B0 Enable bit.                               */
      __IOM uint32_t TMRB0CLK   : 5;            /*!< (@ 0x00000011) Counter/Timer B0 Clock Select.                             */
      __IOM uint32_t TMRB0FN    : 3;            /*!< (@ 0x00000016) Counter/Timer B0 Function Select.                          */
      __IOM uint32_t TMRB0IE    : 1;            /*!< (@ 0x00000019) Counter/Timer B0 Interrupt Enable bit.                     */
      __IOM uint32_t TMRB0PE    : 1;            /*!< (@ 0x0000001A) Counter/Timer B0 Output Enable bit.                        */
      __IOM uint32_t TMRB0CLR   : 1;            /*!< (@ 0x0000001B) Counter/Timer B0 Clear bit.                                */
      __IOM uint32_t TMRB0POL   : 1;            /*!< (@ 0x0000001C) Counter/Timer B0 output polarity.                          */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTLINK0    : 1;            /*!< (@ 0x0000001F) Counter/Timer A0/B0 Link bit.                              */
    } CTRL0_b;
  } ;
  
  union {
    __IOM uint32_t TMR1;                        /*!< (@ 0x00000010) Counter/Timer Register                                     */
    
    struct {
      __IOM uint32_t CTTMRA1    : 16;           /*!< (@ 0x00000000) Counter/Timer A1.                                          */
      __IOM uint32_t CTTMRB1    : 16;           /*!< (@ 0x00000010) Counter/Timer B1.                                          */
    } TMR1_b;
  } ;
  
  union {
    __IOM uint32_t CMPRA1;                      /*!< (@ 0x00000014) Counter/Timer A1 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0A1    : 16;           /*!< (@ 0x00000000) Counter/Timer A1 Compare Register 0.                       */
      __IOM uint32_t CMPR1A1    : 16;           /*!< (@ 0x00000010) Counter/Timer A1 Compare Register 1.                       */
    } CMPRA1_b;
  } ;
  
  union {
    __IOM uint32_t CMPRB1;                      /*!< (@ 0x00000018) Counter/Timer B1 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0B1    : 16;           /*!< (@ 0x00000000) Counter/Timer B1 Compare Register 0.                       */
      __IOM uint32_t CMPR1B1    : 16;           /*!< (@ 0x00000010) Counter/Timer B1 Compare Register 1.                       */
    } CMPRB1_b;
  } ;
  
  union {
    __IOM uint32_t CTRL1;                       /*!< (@ 0x0000001C) Counter/Timer Control                                      */
    
    struct {
      __IOM uint32_t TMRA1EN    : 1;            /*!< (@ 0x00000000) Counter/Timer A1 Enable bit.                               */
      __IOM uint32_t TMRA1CLK   : 5;            /*!< (@ 0x00000001) Counter/Timer A1 Clock Select.                             */
      __IOM uint32_t TMRA1FN    : 3;            /*!< (@ 0x00000006) Counter/Timer A1 Function Select.                          */
      __IOM uint32_t TMRA1IE    : 1;            /*!< (@ 0x00000009) Counter/Timer A1 Interrupt Enable bit.                     */
      __IOM uint32_t TMRA1PE    : 1;            /*!< (@ 0x0000000A) Counter/Timer A1 Output Enable bit.                        */
      __IOM uint32_t TMRA1CLR   : 1;            /*!< (@ 0x0000000B) Counter/Timer A1 Clear bit.                                */
      __IOM uint32_t TMRA1POL   : 1;            /*!< (@ 0x0000000C) Counter/Timer A1 output polarity.                          */
      __IM  uint32_t            : 3;
      __IOM uint32_t TMRB1EN    : 1;            /*!< (@ 0x00000010) Counter/Timer B1 Enable bit.                               */
      __IOM uint32_t TMRB1CLK   : 5;            /*!< (@ 0x00000011) Counter/Timer B1 Clock Select.                             */
      __IOM uint32_t TMRB1FN    : 3;            /*!< (@ 0x00000016) Counter/Timer B1 Function Select.                          */
      __IOM uint32_t TMRB1IE    : 1;            /*!< (@ 0x00000019) Counter/Timer B1 Interrupt Enable bit.                     */
      __IOM uint32_t TMRB1PE    : 1;            /*!< (@ 0x0000001A) Counter/Timer B1 Output Enable bit.                        */
      __IOM uint32_t TMRB1CLR   : 1;            /*!< (@ 0x0000001B) Counter/Timer B1 Clear bit.                                */
      __IOM uint32_t TMRB1POL   : 1;            /*!< (@ 0x0000001C) Counter/Timer B1 output polarity.                          */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTLINK1    : 1;            /*!< (@ 0x0000001F) Counter/Timer A1/B1 Link bit.                              */
    } CTRL1_b;
  } ;
  
  union {
    __IOM uint32_t TMR2;                        /*!< (@ 0x00000020) Counter/Timer Register                                     */
    
    struct {
      __IOM uint32_t CTTMRA2    : 16;           /*!< (@ 0x00000000) Counter/Timer A2.                                          */
      __IOM uint32_t CTTMRB2    : 16;           /*!< (@ 0x00000010) Counter/Timer B2.                                          */
    } TMR2_b;
  } ;
  
  union {
    __IOM uint32_t CMPRA2;                      /*!< (@ 0x00000024) Counter/Timer A2 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0A2    : 16;           /*!< (@ 0x00000000) Counter/Timer A2 Compare Register 0.                       */
      __IOM uint32_t CMPR1A2    : 16;           /*!< (@ 0x00000010) Counter/Timer A2 Compare Register 1.                       */
    } CMPRA2_b;
  } ;
  
  union {
    __IOM uint32_t CMPRB2;                      /*!< (@ 0x00000028) Counter/Timer B2 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0B2    : 16;           /*!< (@ 0x00000000) Counter/Timer B2 Compare Register 0.                       */
      __IOM uint32_t CMPR1B2    : 16;           /*!< (@ 0x00000010) Counter/Timer B2 Compare Register 1.                       */
    } CMPRB2_b;
  } ;
  
  union {
    __IOM uint32_t CTRL2;                       /*!< (@ 0x0000002C) Counter/Timer Control                                      */
    
    struct {
      __IOM uint32_t TMRA2EN    : 1;            /*!< (@ 0x00000000) Counter/Timer A2 Enable bit.                               */
      __IOM uint32_t TMRA2CLK   : 5;            /*!< (@ 0x00000001) Counter/Timer A2 Clock Select.                             */
      __IOM uint32_t TMRA2FN    : 3;            /*!< (@ 0x00000006) Counter/Timer A2 Function Select.                          */
      __IOM uint32_t TMRA2IE    : 1;            /*!< (@ 0x00000009) Counter/Timer A2 Interrupt Enable bit.                     */
      __IOM uint32_t TMRA2PE    : 1;            /*!< (@ 0x0000000A) Counter/Timer A2 Output Enable bit.                        */
      __IOM uint32_t TMRA2CLR   : 1;            /*!< (@ 0x0000000B) Counter/Timer A2 Clear bit.                                */
      __IOM uint32_t TMRA2POL   : 1;            /*!< (@ 0x0000000C) Counter/Timer A2 output polarity.                          */
      __IM  uint32_t            : 3;
      __IOM uint32_t TMRB2EN    : 1;            /*!< (@ 0x00000010) Counter/Timer B2 Enable bit.                               */
      __IOM uint32_t TMRB2CLK   : 5;            /*!< (@ 0x00000011) Counter/Timer B2 Clock Select.                             */
      __IOM uint32_t TMRB2FN    : 3;            /*!< (@ 0x00000016) Counter/Timer B2 Function Select.                          */
      __IOM uint32_t TMRB2IE    : 1;            /*!< (@ 0x00000019) Counter/Timer B2 Interrupt Enable bit.                     */
      __IOM uint32_t TMRB2PE    : 1;            /*!< (@ 0x0000001A) Counter/Timer B2 Output Enable bit.                        */
      __IOM uint32_t TMRB2CLR   : 1;            /*!< (@ 0x0000001B) Counter/Timer B2 Clear bit.                                */
      __IOM uint32_t TMRB2POL   : 1;            /*!< (@ 0x0000001C) Counter/Timer B2 output polarity.                          */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTLINK2    : 1;            /*!< (@ 0x0000001F) Counter/Timer A2/B2 Link bit.                              */
    } CTRL2_b;
  } ;
  
  union {
    __IOM uint32_t TMR3;                        /*!< (@ 0x00000030) Counter/Timer Register                                     */
    
    struct {
      __IOM uint32_t CTTMRA3    : 16;           /*!< (@ 0x00000000) Counter/Timer A3.                                          */
      __IOM uint32_t CTTMRB3    : 16;           /*!< (@ 0x00000010) Counter/Timer B3.                                          */
    } TMR3_b;
  } ;
  
  union {
    __IOM uint32_t CMPRA3;                      /*!< (@ 0x00000034) Counter/Timer A3 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0A3    : 16;           /*!< (@ 0x00000000) Counter/Timer A3 Compare Register 0.                       */
      __IOM uint32_t CMPR1A3    : 16;           /*!< (@ 0x00000010) Counter/Timer A3 Compare Register 1.                       */
    } CMPRA3_b;
  } ;
  
  union {
    __IOM uint32_t CMPRB3;                      /*!< (@ 0x00000038) Counter/Timer B3 Compare Registers                         */
    
    struct {
      __IOM uint32_t CMPR0B3    : 16;           /*!< (@ 0x00000000) Counter/Timer B3 Compare Register 0.                       */
      __IOM uint32_t CMPR1B3    : 16;           /*!< (@ 0x00000010) Counter/Timer B3 Compare Register 1.                       */
    } CMPRB3_b;
  } ;
  
  union {
    __IOM uint32_t CTRL3;                       /*!< (@ 0x0000003C) Counter/Timer Control                                      */
    
    struct {
      __IOM uint32_t TMRA3EN    : 1;            /*!< (@ 0x00000000) Counter/Timer A3 Enable bit.                               */
      __IOM uint32_t TMRA3CLK   : 5;            /*!< (@ 0x00000001) Counter/Timer A3 Clock Select.                             */
      __IOM uint32_t TMRA3FN    : 3;            /*!< (@ 0x00000006) Counter/Timer A3 Function Select.                          */
      __IOM uint32_t TMRA3IE    : 1;            /*!< (@ 0x00000009) Counter/Timer A3 Interrupt Enable bit.                     */
      __IOM uint32_t TMRA3PE    : 1;            /*!< (@ 0x0000000A) Counter/Timer A3 Output Enable bit.                        */
      __IOM uint32_t TMRA3CLR   : 1;            /*!< (@ 0x0000000B) Counter/Timer A3 Clear bit.                                */
      __IOM uint32_t TMRA3POL   : 1;            /*!< (@ 0x0000000C) Counter/Timer A3 output polarity.                          */
      __IM  uint32_t            : 2;
      __IOM uint32_t ADCEN      : 1;            /*!< (@ 0x0000000F) Special Timer A3 enable for ADC function.                  */
      __IOM uint32_t TMRB3EN    : 1;            /*!< (@ 0x00000010) Counter/Timer B3 Enable bit.                               */
      __IOM uint32_t TMRB3CLK   : 5;            /*!< (@ 0x00000011) Counter/Timer B3 Clock Select.                             */
      __IOM uint32_t TMRB3FN    : 3;            /*!< (@ 0x00000016) Counter/Timer B3 Function Select.                          */
      __IOM uint32_t TMRB3IE    : 1;            /*!< (@ 0x00000019) Counter/Timer B3 Interrupt Enable bit.                     */
      __IOM uint32_t TMRB3PE    : 1;            /*!< (@ 0x0000001A) Counter/Timer B3 Output Enable bit.                        */
      __IOM uint32_t TMRB3CLR   : 1;            /*!< (@ 0x0000001B) Counter/Timer B3 Clear bit.                                */
      __IOM uint32_t TMRB3POL   : 1;            /*!< (@ 0x0000001C) Counter/Timer B3 output polarity.                          */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTLINK3    : 1;            /*!< (@ 0x0000001F) Counter/Timer A/B Link bit.                                */
    } CTRL3_b;
  } ;
  __IM  uint32_t  RESERVED[112];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Counter/Timer Interrupts: Enable                           */
    
    struct {
      __IOM uint32_t CTMRA0INT  : 1;            /*!< (@ 0x00000000) Counter/Timer A0 interrupt.                                */
      __IOM uint32_t CTMRB0INT  : 1;            /*!< (@ 0x00000001) Counter/Timer B0 interrupt.                                */
      __IOM uint32_t CTMRA1INT  : 1;            /*!< (@ 0x00000002) Counter/Timer A1 interrupt.                                */
      __IOM uint32_t CTMRB1INT  : 1;            /*!< (@ 0x00000003) Counter/Timer B1 interrupt.                                */
      __IOM uint32_t CTMRA2INT  : 1;            /*!< (@ 0x00000004) Counter/Timer A2 interrupt.                                */
      __IOM uint32_t CTMRB2INT  : 1;            /*!< (@ 0x00000005) Counter/Timer B2 interrupt.                                */
      __IOM uint32_t CTMRA3INT  : 1;            /*!< (@ 0x00000006) Counter/Timer A3 interrupt.                                */
      __IOM uint32_t CTMRB3INT  : 1;            /*!< (@ 0x00000007) Counter/Timer B3 interrupt.                                */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Counter/Timer Interrupts: Status                           */
    
    struct {
      __IOM uint32_t CTMRA0INT  : 1;            /*!< (@ 0x00000000) Counter/Timer A0 interrupt.                                */
      __IOM uint32_t CTMRB0INT  : 1;            /*!< (@ 0x00000001) Counter/Timer B0 interrupt.                                */
      __IOM uint32_t CTMRA1INT  : 1;            /*!< (@ 0x00000002) Counter/Timer A1 interrupt.                                */
      __IOM uint32_t CTMRB1INT  : 1;            /*!< (@ 0x00000003) Counter/Timer B1 interrupt.                                */
      __IOM uint32_t CTMRA2INT  : 1;            /*!< (@ 0x00000004) Counter/Timer A2 interrupt.                                */
      __IOM uint32_t CTMRB2INT  : 1;            /*!< (@ 0x00000005) Counter/Timer B2 interrupt.                                */
      __IOM uint32_t CTMRA3INT  : 1;            /*!< (@ 0x00000006) Counter/Timer A3 interrupt.                                */
      __IOM uint32_t CTMRB3INT  : 1;            /*!< (@ 0x00000007) Counter/Timer B3 interrupt.                                */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Counter/Timer Interrupts: Clear                            */
    
    struct {
      __IOM uint32_t CTMRA0INT  : 1;            /*!< (@ 0x00000000) Counter/Timer A0 interrupt.                                */
      __IOM uint32_t CTMRB0INT  : 1;            /*!< (@ 0x00000001) Counter/Timer B0 interrupt.                                */
      __IOM uint32_t CTMRA1INT  : 1;            /*!< (@ 0x00000002) Counter/Timer A1 interrupt.                                */
      __IOM uint32_t CTMRB1INT  : 1;            /*!< (@ 0x00000003) Counter/Timer B1 interrupt.                                */
      __IOM uint32_t CTMRA2INT  : 1;            /*!< (@ 0x00000004) Counter/Timer A2 interrupt.                                */
      __IOM uint32_t CTMRB2INT  : 1;            /*!< (@ 0x00000005) Counter/Timer B2 interrupt.                                */
      __IOM uint32_t CTMRA3INT  : 1;            /*!< (@ 0x00000006) Counter/Timer A3 interrupt.                                */
      __IOM uint32_t CTMRB3INT  : 1;            /*!< (@ 0x00000007) Counter/Timer B3 interrupt.                                */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Counter/Timer Interrupts: Set                              */
    
    struct {
      __IOM uint32_t CTMRA0INT  : 1;            /*!< (@ 0x00000000) Counter/Timer A0 interrupt.                                */
      __IOM uint32_t CTMRB0INT  : 1;            /*!< (@ 0x00000001) Counter/Timer B0 interrupt.                                */
      __IOM uint32_t CTMRA1INT  : 1;            /*!< (@ 0x00000002) Counter/Timer A1 interrupt.                                */
      __IOM uint32_t CTMRB1INT  : 1;            /*!< (@ 0x00000003) Counter/Timer B1 interrupt.                                */
      __IOM uint32_t CTMRA2INT  : 1;            /*!< (@ 0x00000004) Counter/Timer A2 interrupt.                                */
      __IOM uint32_t CTMRB2INT  : 1;            /*!< (@ 0x00000005) Counter/Timer B2 interrupt.                                */
      __IOM uint32_t CTMRA3INT  : 1;            /*!< (@ 0x00000006) Counter/Timer A3 interrupt.                                */
      __IOM uint32_t CTMRB3INT  : 1;            /*!< (@ 0x00000007) Counter/Timer B3 interrupt.                                */
    } INTSET_b;
  } ;
} CTIMER_Type;                                  /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief General Purpose IO (GPIO)
  */

typedef struct {                                /*!< (@ 0x40010000) GPIO Structure                                             */
  
  union {
    __IOM uint32_t PADREGA;                     /*!< (@ 0x00000000) Pad Configuration Register A                               */
    
    struct {
      __IOM uint32_t PAD0PULL   : 1;            /*!< (@ 0x00000000) Pad 0 pullup enable                                        */
      __IOM uint32_t PAD0INPEN  : 1;            /*!< (@ 0x00000001) Pad 0 input enable                                         */
      __IOM uint32_t PAD0STRNG  : 1;            /*!< (@ 0x00000002) Pad 0 drive strength                                       */
      __IOM uint32_t PAD0FNCSEL : 3;            /*!< (@ 0x00000003) Pad 0 function select                                      */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD1PULL   : 1;            /*!< (@ 0x00000008) Pad 1 pullup enable                                        */
      __IOM uint32_t PAD1INPEN  : 1;            /*!< (@ 0x00000009) Pad 1 input enable                                         */
      __IOM uint32_t PAD1STRNG  : 1;            /*!< (@ 0x0000000A) Pad 1 drive strength                                       */
      __IOM uint32_t PAD1FNCSEL : 3;            /*!< (@ 0x0000000B) Pad 1 function select                                      */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD2PULL   : 1;            /*!< (@ 0x00000010) Pad 2 pullup enable                                        */
      __IOM uint32_t PAD2INPEN  : 1;            /*!< (@ 0x00000011) Pad 2 input enable                                         */
      __IOM uint32_t PAD2STRNG  : 1;            /*!< (@ 0x00000012) Pad 2 drive strength                                       */
      __IOM uint32_t PAD2FNCSEL : 3;            /*!< (@ 0x00000013) Pad 2 function select                                      */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD3PULL   : 1;            /*!< (@ 0x00000018) Pad 3 pullup enable                                        */
      __IOM uint32_t PAD3INPEN  : 1;            /*!< (@ 0x00000019) Pad 3 input enable.                                        */
      __IOM uint32_t PAD3STRNG  : 1;            /*!< (@ 0x0000001A) Pad 3 drive strength.                                      */
      __IOM uint32_t PAD3FNCSEL : 3;            /*!< (@ 0x0000001B) Pad 3 function select                                      */
      __IM  uint32_t            : 1;
      __IOM uint32_t PAD3PWRUP  : 1;            /*!< (@ 0x0000001F) Pad 3 upper power switch enable                            */
    } PADREGA_b;
  } ;
  
  union {
    __IOM uint32_t PADREGB;                     /*!< (@ 0x00000004) Pad Configuration Register B                               */
    
    struct {
      __IOM uint32_t PAD4PULL   : 1;            /*!< (@ 0x00000000) Pad 4 pullup enable                                        */
      __IOM uint32_t PAD4INPEN  : 1;            /*!< (@ 0x00000001) Pad 4 input enable                                         */
      __IOM uint32_t PAD4STRNG  : 1;            /*!< (@ 0x00000002) Pad 4 drive strength                                       */
      __IOM uint32_t PAD4FNCSEL : 3;            /*!< (@ 0x00000003) Pad 4 function select                                      */
      __IM  uint32_t            : 1;
      __IOM uint32_t PAD4PWRUP  : 1;            /*!< (@ 0x00000007) Pad 4 upper power switch enable                            */
      __IOM uint32_t PAD5PULL   : 1;            /*!< (@ 0x00000008) Pad 5 pullup enable                                        */
      __IOM uint32_t PAD5INPEN  : 1;            /*!< (@ 0x00000009) Pad 5 input enable                                         */
      __IOM uint32_t PAD5STRNG  : 1;            /*!< (@ 0x0000000A) Pad 5 drive strength                                       */
      __IOM uint32_t PAD5FNCSEL : 3;            /*!< (@ 0x0000000B) Pad 5 function select                                      */
      __IOM uint32_t PAD5RSEL   : 2;            /*!< (@ 0x0000000E) Pad 5 pullup resistor selection.                           */
      __IOM uint32_t PAD6PULL   : 1;            /*!< (@ 0x00000010) Pad 6 pullup enable                                        */
      __IOM uint32_t PAD6INPEN  : 1;            /*!< (@ 0x00000011) Pad 6 input enable                                         */
      __IOM uint32_t PAD6STRNG  : 1;            /*!< (@ 0x00000012) Pad 6 drive strength                                       */
      __IOM uint32_t PAD6FNCSEL : 3;            /*!< (@ 0x00000013) Pad 6 function select                                      */
      __IOM uint32_t PAD6RSEL   : 2;            /*!< (@ 0x00000016) Pad 6 pullup resistor selection.                           */
      __IOM uint32_t PAD7PULL   : 1;            /*!< (@ 0x00000018) Pad 7 pullup enable                                        */
      __IOM uint32_t PAD7INPEN  : 1;            /*!< (@ 0x00000019) Pad 7 input enable                                         */
      __IOM uint32_t PAD7STRNG  : 1;            /*!< (@ 0x0000001A) Pad 7 drive strentgh                                       */
      __IOM uint32_t PAD7FNCSEL : 3;            /*!< (@ 0x0000001B) Pad 7 function select                                      */
    } PADREGB_b;
  } ;
  
  union {
    __IOM uint32_t PADREGC;                     /*!< (@ 0x00000008) Pad Configuration Register C                               */
    
    struct {
      __IOM uint32_t PAD8PULL   : 1;            /*!< (@ 0x00000000) Pad 8 pullup enable                                        */
      __IOM uint32_t PAD8INPEN  : 1;            /*!< (@ 0x00000001) Pad 8 input enable                                         */
      __IOM uint32_t PAD8STRNG  : 1;            /*!< (@ 0x00000002) Pad 8 drive strength                                       */
      __IOM uint32_t PAD8FNCSEL : 3;            /*!< (@ 0x00000003) Pad 8 function select                                      */
      __IOM uint32_t PAD8RSEL   : 2;            /*!< (@ 0x00000006) Pad 8 pullup resistor selection.                           */
      __IOM uint32_t PAD9PULL   : 1;            /*!< (@ 0x00000008) Pad 9 pullup enable                                        */
      __IOM uint32_t PAD9INPEN  : 1;            /*!< (@ 0x00000009) Pad 9 input enable                                         */
      __IOM uint32_t PAD9STRNG  : 1;            /*!< (@ 0x0000000A) Pad 9 drive strength                                       */
      __IOM uint32_t PAD9FNCSEL : 3;            /*!< (@ 0x0000000B) Pad 9 function select                                      */
      __IOM uint32_t PAD9RSEL   : 2;            /*!< (@ 0x0000000E) Pad 9 pullup resistor selection                            */
      __IOM uint32_t PAD10PULL  : 1;            /*!< (@ 0x00000010) Pad 10 pullup enable                                       */
      __IOM uint32_t PAD10INPEN : 1;            /*!< (@ 0x00000011) Pad 10 input enable                                        */
      __IOM uint32_t PAD10STRNG : 1;            /*!< (@ 0x00000012) Pad 10 drive strength                                      */
      __IOM uint32_t PAD10FNCSEL : 3;           /*!< (@ 0x00000013) Pad 10 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD11PULL  : 1;            /*!< (@ 0x00000018) Pad 11 pullup enable                                       */
      __IOM uint32_t PAD11INPEN : 1;            /*!< (@ 0x00000019) Pad 11 input enable                                        */
      __IOM uint32_t PAD11STRNG : 1;            /*!< (@ 0x0000001A) Pad 11 drive strentgh                                      */
      __IOM uint32_t PAD11FNCSEL : 2;           /*!< (@ 0x0000001B) Pad 11 function select                                     */
      __IM  uint32_t            : 1;
      __IOM uint32_t PAD11PWRDN : 1;            /*!< (@ 0x0000001E) Pad 11 lower power switch enable                           */
    } PADREGC_b;
  } ;
  
  union {
    __IOM uint32_t PADREGD;                     /*!< (@ 0x0000000C) Pad Configuration Register D                               */
    
    struct {
      __IOM uint32_t PAD12PULL  : 1;            /*!< (@ 0x00000000) Pad 12 pullup enable                                       */
      __IOM uint32_t PAD12INPEN : 1;            /*!< (@ 0x00000001) Pad 12 input enable                                        */
      __IOM uint32_t PAD12STRNG : 1;            /*!< (@ 0x00000002) Pad 12 drive strength                                      */
      __IOM uint32_t PAD12FNCSEL : 2;           /*!< (@ 0x00000003) Pad 12 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD13PULL  : 1;            /*!< (@ 0x00000008) Pad 13 pullup enable                                       */
      __IOM uint32_t PAD13INPEN : 1;            /*!< (@ 0x00000009) Pad 13 input enable                                        */
      __IOM uint32_t PAD13STRNG : 1;            /*!< (@ 0x0000000A) Pad 13 drive strength                                      */
      __IOM uint32_t PAD13FNCSEL : 3;           /*!< (@ 0x0000000B) Pad 13 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD14PULL  : 1;            /*!< (@ 0x00000010) Pad 14 pullup enable                                       */
      __IOM uint32_t PAD14INPEN : 1;            /*!< (@ 0x00000011) Pad 14 input enable                                        */
      __IOM uint32_t PAD14STRNG : 1;            /*!< (@ 0x00000012) Pad 14 drive strength                                      */
      __IOM uint32_t PAD14FNCSEL : 3;           /*!< (@ 0x00000013) Pad 14 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD15PULL  : 1;            /*!< (@ 0x00000018) Pad 15 pullup enable                                       */
      __IOM uint32_t PAD15INPEN : 1;            /*!< (@ 0x00000019) Pad 15 input enable                                        */
      __IOM uint32_t PAD15STRNG : 1;            /*!< (@ 0x0000001A) Pad 15 drive strentgh                                      */
      __IOM uint32_t PAD15FNCSEL : 3;           /*!< (@ 0x0000001B) Pad 15 function select                                     */
    } PADREGD_b;
  } ;
  
  union {
    __IOM uint32_t PADREGE;                     /*!< (@ 0x00000010) Pad Configuration Register E                               */
    
    struct {
      __IOM uint32_t PAD16PULL  : 1;            /*!< (@ 0x00000000) Pad 16 pullup enable                                       */
      __IOM uint32_t PAD16INPEN : 1;            /*!< (@ 0x00000001) Pad 16 input enable                                        */
      __IOM uint32_t PAD16STRNG : 1;            /*!< (@ 0x00000002) Pad 16 drive strength                                      */
      __IOM uint32_t PAD16FNCSEL : 2;           /*!< (@ 0x00000003) Pad 16 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD17PULL  : 1;            /*!< (@ 0x00000008) Pad 17 pullup enable                                       */
      __IOM uint32_t PAD17INPEN : 1;            /*!< (@ 0x00000009) Pad 17 input enable                                        */
      __IOM uint32_t PAD17STRNG : 1;            /*!< (@ 0x0000000A) Pad 17 drive strength                                      */
      __IOM uint32_t PAD17FNCSEL : 3;           /*!< (@ 0x0000000B) Pad 17 function select                                     */
      __IM  uint32_t            : 2;
      __IOM uint32_t PAD18PULL  : 1;            /*!< (@ 0x00000010) Pad 18 pullup enable                                       */
      __IOM uint32_t PAD18INPEN : 1;            /*!< (@ 0x00000011) Pad 18 input enable                                        */
      __IOM uint32_t PAD18STRNG : 1;            /*!< (@ 0x00000012) Pad 18 drive strength                                      */
      __IOM uint32_t PAD18FNCSEL : 2;           /*!< (@ 0x00000013) Pad 18 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD19PULL  : 1;            /*!< (@ 0x00000018) Pad 19 pullup enable                                       */
      __IOM uint32_t PAD19INPEN : 1;            /*!< (@ 0x00000019) Pad 19 input enable                                        */
      __IOM uint32_t PAD19STRNG : 1;            /*!< (@ 0x0000001A) Pad 19 drive strentgh                                      */
      __IOM uint32_t PAD19FNCSEL : 2;           /*!< (@ 0x0000001B) Pad 19 function select                                     */
    } PADREGE_b;
  } ;
  
  union {
    __IOM uint32_t PADREGF;                     /*!< (@ 0x00000014) Pad Configuration Register F                               */
    
    struct {
      __IOM uint32_t PAD20PULL  : 1;            /*!< (@ 0x00000000) Pad 20 pulldown enable                                     */
      __IOM uint32_t PAD20INPEN : 1;            /*!< (@ 0x00000001) Pad 20 input enable                                        */
      __IOM uint32_t PAD20STRNG : 1;            /*!< (@ 0x00000002) Pad 20 drive strength                                      */
      __IOM uint32_t PAD20FNCSEL : 2;           /*!< (@ 0x00000003) Pad 20 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD21PULL  : 1;            /*!< (@ 0x00000008) Pad 21 pullup enable                                       */
      __IOM uint32_t PAD21INPEN : 1;            /*!< (@ 0x00000009) Pad 21 input enable                                        */
      __IOM uint32_t PAD21STRNG : 1;            /*!< (@ 0x0000000A) Pad 21 drive strength                                      */
      __IOM uint32_t PAD21FNCSEL : 2;           /*!< (@ 0x0000000B) Pad 21 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD22PULL  : 1;            /*!< (@ 0x00000010) Pad 22 pullup enable                                       */
      __IOM uint32_t PAD22INPEN : 1;            /*!< (@ 0x00000011) Pad 22 input enable                                        */
      __IOM uint32_t PAD22STRNG : 1;            /*!< (@ 0x00000012) Pad 22 drive strength                                      */
      __IOM uint32_t PAD22FNCSEL : 2;           /*!< (@ 0x00000013) Pad 22 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD23PULL  : 1;            /*!< (@ 0x00000018) Pad 23 pullup enable                                       */
      __IOM uint32_t PAD23INPEN : 1;            /*!< (@ 0x00000019) Pad 23 input enable                                        */
      __IOM uint32_t PAD23STRNG : 1;            /*!< (@ 0x0000001A) Pad 23 drive strentgh                                      */
      __IOM uint32_t PAD23FNCSEL : 2;           /*!< (@ 0x0000001B) Pad 23 function select                                     */
    } PADREGF_b;
  } ;
  
  union {
    __IOM uint32_t PADREGG;                     /*!< (@ 0x00000018) Pad Configuration Register G                               */
    
    struct {
      __IOM uint32_t PAD24PULL  : 1;            /*!< (@ 0x00000000) Pad 24 pullup enable                                       */
      __IOM uint32_t PAD24INPEN : 1;            /*!< (@ 0x00000001) Pad 24 input enable                                        */
      __IOM uint32_t PAD24STRNG : 1;            /*!< (@ 0x00000002) Pad 24 drive strength                                      */
      __IOM uint32_t PAD24FNCSEL : 2;           /*!< (@ 0x00000003) Pad 24 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD25PULL  : 1;            /*!< (@ 0x00000008) Pad 25 pullup enable                                       */
      __IOM uint32_t PAD25INPEN : 1;            /*!< (@ 0x00000009) Pad 25 input enable                                        */
      __IOM uint32_t PAD25STRNG : 1;            /*!< (@ 0x0000000A) Pad 25 drive strength                                      */
      __IOM uint32_t PAD25FNCSEL : 2;           /*!< (@ 0x0000000B) Pad 25 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD26PULL  : 1;            /*!< (@ 0x00000010) Pad 26 pullup enable                                       */
      __IOM uint32_t PAD26INPEN : 1;            /*!< (@ 0x00000011) Pad 26 input enable                                        */
      __IOM uint32_t PAD26STRNG : 1;            /*!< (@ 0x00000012) Pad 26 drive strength                                      */
      __IOM uint32_t PAD26FNCSEL : 2;           /*!< (@ 0x00000013) Pad 26 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD27PULL  : 1;            /*!< (@ 0x00000018) Pad 27 pullup enable                                       */
      __IOM uint32_t PAD27INPEN : 1;            /*!< (@ 0x00000019) Pad 27 input enable                                        */
      __IOM uint32_t PAD27STRNG : 1;            /*!< (@ 0x0000001A) Pad 27 drive strentgh                                      */
      __IOM uint32_t PAD27FNCSEL : 2;           /*!< (@ 0x0000001B) Pad 27 function select                                     */
    } PADREGG_b;
  } ;
  
  union {
    __IOM uint32_t PADREGH;                     /*!< (@ 0x0000001C) Pad Configuration Register H                               */
    
    struct {
      __IOM uint32_t PAD28PULL  : 1;            /*!< (@ 0x00000000) Pad 28 pullup enable                                       */
      __IOM uint32_t PAD28INPEN : 1;            /*!< (@ 0x00000001) Pad 28 input enable                                        */
      __IOM uint32_t PAD28STRNG : 1;            /*!< (@ 0x00000002) Pad 28 drive strength                                      */
      __IOM uint32_t PAD28FNCSEL : 2;           /*!< (@ 0x00000003) Pad 28 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD29PULL  : 1;            /*!< (@ 0x00000008) Pad 29 pullup enable                                       */
      __IOM uint32_t PAD29INPEN : 1;            /*!< (@ 0x00000009) Pad 29 input enable                                        */
      __IOM uint32_t PAD29STRNG : 1;            /*!< (@ 0x0000000A) Pad 29 drive strength                                      */
      __IOM uint32_t PAD29FNCSEL : 2;           /*!< (@ 0x0000000B) Pad 29 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD30PULL  : 1;            /*!< (@ 0x00000010) Pad 30 pullup enable                                       */
      __IOM uint32_t PAD30INPEN : 1;            /*!< (@ 0x00000011) Pad 30 input enable                                        */
      __IOM uint32_t PAD30STRNG : 1;            /*!< (@ 0x00000012) Pad 30 drive strength                                      */
      __IOM uint32_t PAD30FNCSEL : 2;           /*!< (@ 0x00000013) Pad 30 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD31PULL  : 1;            /*!< (@ 0x00000018) Pad 31 pullup enable                                       */
      __IOM uint32_t PAD31INPEN : 1;            /*!< (@ 0x00000019) Pad 31 input enable                                        */
      __IOM uint32_t PAD31STRNG : 1;            /*!< (@ 0x0000001A) Pad 31 drive strentgh                                      */
      __IOM uint32_t PAD31FNCSEL : 2;           /*!< (@ 0x0000001B) Pad 31 function select                                     */
    } PADREGH_b;
  } ;
  
  union {
    __IOM uint32_t PADREGI;                     /*!< (@ 0x00000020) Pad Configuration Register I                               */
    
    struct {
      __IOM uint32_t PAD32PULL  : 1;            /*!< (@ 0x00000000) Pad 32 pullup enable                                       */
      __IOM uint32_t PAD32INPEN : 1;            /*!< (@ 0x00000001) Pad 32 input enable                                        */
      __IOM uint32_t PAD32STRNG : 1;            /*!< (@ 0x00000002) Pad 32 drive strength                                      */
      __IOM uint32_t PAD32FNCSEL : 2;           /*!< (@ 0x00000003) Pad 32 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD33PULL  : 1;            /*!< (@ 0x00000008) Pad 33 pullup enable                                       */
      __IOM uint32_t PAD33INPEN : 1;            /*!< (@ 0x00000009) Pad 33 input enable                                        */
      __IOM uint32_t PAD33STRNG : 1;            /*!< (@ 0x0000000A) Pad 33 drive strength                                      */
      __IOM uint32_t PAD33FNCSEL : 2;           /*!< (@ 0x0000000B) Pad 33 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD34PULL  : 1;            /*!< (@ 0x00000010) Pad 34 pullup enable                                       */
      __IOM uint32_t PAD34INPEN : 1;            /*!< (@ 0x00000011) Pad 34 input enable                                        */
      __IOM uint32_t PAD34STRNG : 1;            /*!< (@ 0x00000012) Pad 34 drive strength                                      */
      __IOM uint32_t PAD34FNCSEL : 2;           /*!< (@ 0x00000013) Pad 34 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD35PULL  : 1;            /*!< (@ 0x00000018) Pad 35 pullup enable                                       */
      __IOM uint32_t PAD35INPEN : 1;            /*!< (@ 0x00000019) Pad 35 input enable                                        */
      __IOM uint32_t PAD35STRNG : 1;            /*!< (@ 0x0000001A) Pad 35 drive strentgh                                      */
      __IOM uint32_t PAD35FNCSEL : 2;           /*!< (@ 0x0000001B) Pad 35 function select                                     */
    } PADREGI_b;
  } ;
  
  union {
    __IOM uint32_t PADREGJ;                     /*!< (@ 0x00000024) Pad Configuration Register J                               */
    
    struct {
      __IOM uint32_t PAD36PULL  : 1;            /*!< (@ 0x00000000) Pad 36 pullup enable                                       */
      __IOM uint32_t PAD36INPEN : 1;            /*!< (@ 0x00000001) Pad 36 input enable                                        */
      __IOM uint32_t PAD36STRNG : 1;            /*!< (@ 0x00000002) Pad 36 drive strength                                      */
      __IOM uint32_t PAD36FNCSEL : 2;           /*!< (@ 0x00000003) Pad 36 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD37PULL  : 1;            /*!< (@ 0x00000008) Pad 37 pullup enable                                       */
      __IOM uint32_t PAD37INPEN : 1;            /*!< (@ 0x00000009) Pad 37 input enable                                        */
      __IOM uint32_t PAD37STRNG : 1;            /*!< (@ 0x0000000A) Pad 37 drive strength                                      */
      __IOM uint32_t PAD37FNCSEL : 2;           /*!< (@ 0x0000000B) Pad 37 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD38PULL  : 1;            /*!< (@ 0x00000010) Pad 38 pullup enable                                       */
      __IOM uint32_t PAD38INPEN : 1;            /*!< (@ 0x00000011) Pad 38 input enable                                        */
      __IOM uint32_t PAD38STRNG : 1;            /*!< (@ 0x00000012) Pad 38 drive strength                                      */
      __IOM uint32_t PAD38FNCSEL : 2;           /*!< (@ 0x00000013) Pad 38 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD39PULL  : 1;            /*!< (@ 0x00000018) Pad 39 pullup enable                                       */
      __IOM uint32_t PAD39INPEN : 1;            /*!< (@ 0x00000019) Pad 39 input enable                                        */
      __IOM uint32_t PAD39STRNG : 1;            /*!< (@ 0x0000001A) Pad 39 drive strentgh                                      */
      __IOM uint32_t PAD39FNCSEL : 2;           /*!< (@ 0x0000001B) Pad 39 function select                                     */
    } PADREGJ_b;
  } ;
  
  union {
    __IOM uint32_t PADREGK;                     /*!< (@ 0x00000028) Pad Configuration Register K                               */
    
    struct {
      __IOM uint32_t PAD40PULL  : 1;            /*!< (@ 0x00000000) Pad 40 pullup enable                                       */
      __IOM uint32_t PAD40INPEN : 1;            /*!< (@ 0x00000001) Pad 40 input enable                                        */
      __IOM uint32_t PAD40STRNG : 1;            /*!< (@ 0x00000002) Pad 40 drive strength                                      */
      __IOM uint32_t PAD40FNCSEL : 2;           /*!< (@ 0x00000003) Pad 40 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD41PULL  : 1;            /*!< (@ 0x00000008) Pad 41 pullup enable                                       */
      __IOM uint32_t PAD41INPEN : 1;            /*!< (@ 0x00000009) Pad 41 input enable                                        */
      __IOM uint32_t PAD41STRNG : 1;            /*!< (@ 0x0000000A) Pad 41 drive strength                                      */
      __IOM uint32_t PAD41FNCSEL : 2;           /*!< (@ 0x0000000B) Pad 41 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD42PULL  : 1;            /*!< (@ 0x00000010) Pad 42 pullup enable                                       */
      __IOM uint32_t PAD42INPEN : 1;            /*!< (@ 0x00000011) Pad 42 input enable                                        */
      __IOM uint32_t PAD42STRNG : 1;            /*!< (@ 0x00000012) Pad 42 drive strength                                      */
      __IOM uint32_t PAD42FNCSEL : 2;           /*!< (@ 0x00000013) Pad 42 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD43PULL  : 1;            /*!< (@ 0x00000018) Pad 43 pullup enable                                       */
      __IOM uint32_t PAD43INPEN : 1;            /*!< (@ 0x00000019) Pad 43 input enable                                        */
      __IOM uint32_t PAD43STRNG : 1;            /*!< (@ 0x0000001A) Pad 43 drive strentgh                                      */
      __IOM uint32_t PAD43FNCSEL : 2;           /*!< (@ 0x0000001B) Pad 43 function select                                     */
    } PADREGK_b;
  } ;
  
  union {
    __IOM uint32_t PADREGL;                     /*!< (@ 0x0000002C) Pad Configuration Register L                               */
    
    struct {
      __IOM uint32_t PAD44PULL  : 1;            /*!< (@ 0x00000000) Pad 44 pullup enable                                       */
      __IOM uint32_t PAD44INPEN : 1;            /*!< (@ 0x00000001) Pad 44 input enable                                        */
      __IOM uint32_t PAD44STRNG : 1;            /*!< (@ 0x00000002) Pad 44 drive strength                                      */
      __IOM uint32_t PAD44FNCSEL : 2;           /*!< (@ 0x00000003) Pad 44 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD45PULL  : 1;            /*!< (@ 0x00000008) Pad 45 pullup enable                                       */
      __IOM uint32_t PAD45INPEN : 1;            /*!< (@ 0x00000009) Pad 45 input enable                                        */
      __IOM uint32_t PAD45STRNG : 1;            /*!< (@ 0x0000000A) Pad 45 drive strength                                      */
      __IOM uint32_t PAD45FNCSEL : 2;           /*!< (@ 0x0000000B) Pad 45 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD46PULL  : 1;            /*!< (@ 0x00000010) Pad 46 pullup enable                                       */
      __IOM uint32_t PAD46INPEN : 1;            /*!< (@ 0x00000011) Pad 46 input enable                                        */
      __IOM uint32_t PAD46STRNG : 1;            /*!< (@ 0x00000012) Pad 46 drive strength                                      */
      __IOM uint32_t PAD46FNCSEL : 2;           /*!< (@ 0x00000013) Pad 46 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD47PULL  : 1;            /*!< (@ 0x00000018) Pad 47 pullup enable                                       */
      __IOM uint32_t PAD47INPEN : 1;            /*!< (@ 0x00000019) Pad 47 input enable                                        */
      __IOM uint32_t PAD47STRNG : 1;            /*!< (@ 0x0000001A) Pad 47 drive strentgh                                      */
      __IOM uint32_t PAD47FNCSEL : 2;           /*!< (@ 0x0000001B) Pad 47 function select                                     */
    } PADREGL_b;
  } ;
  
  union {
    __IOM uint32_t PADREGM;                     /*!< (@ 0x00000030) Pad Configuration Register M                               */
    
    struct {
      __IOM uint32_t PAD48PULL  : 1;            /*!< (@ 0x00000000) Pad 48 pullup enable                                       */
      __IOM uint32_t PAD48INPEN : 1;            /*!< (@ 0x00000001) Pad 48 input enable                                        */
      __IOM uint32_t PAD48STRNG : 1;            /*!< (@ 0x00000002) Pad 48 drive strength                                      */
      __IOM uint32_t PAD48FNCSEL : 2;           /*!< (@ 0x00000003) Pad 48 function select                                     */
      __IM  uint32_t            : 3;
      __IOM uint32_t PAD49PULL  : 1;            /*!< (@ 0x00000008) Pad 49 pullup enable                                       */
      __IOM uint32_t PAD49INPEN : 1;            /*!< (@ 0x00000009) Pad 49 input enable                                        */
      __IOM uint32_t PAD49STRNG : 1;            /*!< (@ 0x0000000A) Pad 49 drive strength                                      */
      __IOM uint32_t PAD49FNCSEL : 2;           /*!< (@ 0x0000000B) Pad 49 function select                                     */
    } PADREGM_b;
  } ;
  __IM  uint32_t  RESERVED[3];
  
  union {
    __IOM uint32_t CFGA;                        /*!< (@ 0x00000040) GPIO Configuration Register A                              */
    
    struct {
      __IOM uint32_t GPIO0INCFG : 1;            /*!< (@ 0x00000000) GPIO0 input enable.                                        */
      __IOM uint32_t GPIO0OUTCFG : 2;           /*!< (@ 0x00000001) GPIO0 output configuration.                                */
      __IOM uint32_t GPIO0INTD  : 1;            /*!< (@ 0x00000003) GPIO0 interrupt direction.                                 */
      __IOM uint32_t GPIO1INCFG : 1;            /*!< (@ 0x00000004) GPIO1 input enable.                                        */
      __IOM uint32_t GPIO1OUTCFG : 2;           /*!< (@ 0x00000005) GPIO1 output configuration.                                */
      __IOM uint32_t GPIO1INTD  : 1;            /*!< (@ 0x00000007) GPIO1 interrupt direction.                                 */
      __IOM uint32_t GPIO2INCFG : 1;            /*!< (@ 0x00000008) GPIO2 input enable.                                        */
      __IOM uint32_t GPIO2OUTCFG : 2;           /*!< (@ 0x00000009) GPIO2 output configuration.                                */
      __IOM uint32_t GPIO2INTD  : 1;            /*!< (@ 0x0000000B) GPIO2 interrupt direction.                                 */
      __IOM uint32_t GPIO3INCFG : 1;            /*!< (@ 0x0000000C) GPIO3 input enable.                                        */
      __IOM uint32_t GPIO3OUTCFG : 2;           /*!< (@ 0x0000000D) GPIO3 output configuration.                                */
      __IOM uint32_t GPIO3INTD  : 1;            /*!< (@ 0x0000000F) GPIO3 interrupt direction.                                 */
      __IOM uint32_t GPIO4INCFG : 1;            /*!< (@ 0x00000010) GPIO4 input enable.                                        */
      __IOM uint32_t GPIO4OUTCFG : 2;           /*!< (@ 0x00000011) GPIO4 output configuration.                                */
      __IOM uint32_t GPIO4INTD  : 1;            /*!< (@ 0x00000013) GPIO4 interrupt direction.                                 */
      __IOM uint32_t GPIO5INCFG : 1;            /*!< (@ 0x00000014) GPIO5 input enable.                                        */
      __IOM uint32_t GPIO5OUTCFG : 2;           /*!< (@ 0x00000015) GPIO5 output configuration.                                */
      __IOM uint32_t GPIO5INTD  : 1;            /*!< (@ 0x00000017) GPIO5 interrupt direction.                                 */
      __IOM uint32_t GPIO6INCFG : 1;            /*!< (@ 0x00000018) GPIO6 input enable.                                        */
      __IOM uint32_t GPIO6OUTCFG : 2;           /*!< (@ 0x00000019) GPIO6 output configuration.                                */
      __IOM uint32_t GPIO6INTD  : 1;            /*!< (@ 0x0000001B) GPIO6 interrupt direction.                                 */
      __IOM uint32_t GPIO7INCFG : 1;            /*!< (@ 0x0000001C) GPIO7 input enable.                                        */
      __IOM uint32_t GPIO7OUTCFG : 2;           /*!< (@ 0x0000001D) GPIO7 output configuration.                                */
      __IOM uint32_t GPIO7INTD  : 1;            /*!< (@ 0x0000001F) GPIO7 interrupt direction.                                 */
    } CFGA_b;
  } ;
  
  union {
    __IOM uint32_t CFGB;                        /*!< (@ 0x00000044) GPIO Configuration Register B                              */
    
    struct {
      __IOM uint32_t GPIO8INCFG : 1;            /*!< (@ 0x00000000) GPIO8 input enable.                                        */
      __IOM uint32_t GPIO8OUTCFG : 2;           /*!< (@ 0x00000001) GPIO8 output configuration.                                */
      __IOM uint32_t GPIO8INTD  : 1;            /*!< (@ 0x00000003) GPIO8 interrupt direction.                                 */
      __IOM uint32_t GPIO9INCFG : 1;            /*!< (@ 0x00000004) GPIO9 input enable.                                        */
      __IOM uint32_t GPIO9OUTCFG : 2;           /*!< (@ 0x00000005) GPIO9 output configuration.                                */
      __IOM uint32_t GPIO9INTD  : 1;            /*!< (@ 0x00000007) GPIO9 interrupt direction.                                 */
      __IOM uint32_t GPIO10INCFG : 1;           /*!< (@ 0x00000008) GPIO10 input enable.                                       */
      __IOM uint32_t GPIO10OUTCFG : 2;          /*!< (@ 0x00000009) GPIO10 output configuration.                               */
      __IOM uint32_t GPIO10INTD : 1;            /*!< (@ 0x0000000B) GPIO10 interrupt direction.                                */
      __IOM uint32_t GPIO11INCFG : 1;           /*!< (@ 0x0000000C) GPIO11 input enable.                                       */
      __IOM uint32_t GPIO11OUTCFG : 2;          /*!< (@ 0x0000000D) GPIO11 output configuration.                               */
      __IOM uint32_t GPIO11INTD : 1;            /*!< (@ 0x0000000F) GPIO11 interrupt direction.                                */
      __IOM uint32_t GPIO12INCFG : 1;           /*!< (@ 0x00000010) GPIO12 input enable.                                       */
      __IOM uint32_t GPIO12OUTCFG : 2;          /*!< (@ 0x00000011) GPIO12 output configuration.                               */
      __IOM uint32_t GPIO12INTD : 1;            /*!< (@ 0x00000013) GPIO12 interrupt direction.                                */
      __IOM uint32_t GPIO13INCFG : 1;           /*!< (@ 0x00000014) GPIO13 input enable.                                       */
      __IOM uint32_t GPIO13OUTCFG : 2;          /*!< (@ 0x00000015) GPIO13 output configuration.                               */
      __IOM uint32_t GPIO13INTD : 1;            /*!< (@ 0x00000017) GPIO13 interrupt direction.                                */
      __IOM uint32_t GPIO14INCFG : 1;           /*!< (@ 0x00000018) GPIO14 input enable.                                       */
      __IOM uint32_t GPIO14OUTCFG : 2;          /*!< (@ 0x00000019) GPIO14 output configuration.                               */
      __IOM uint32_t GPIO14INTD : 1;            /*!< (@ 0x0000001B) GPIO14 interrupt direction.                                */
      __IOM uint32_t GPIO15INCFG : 1;           /*!< (@ 0x0000001C) GPIO15 input enable.                                       */
      __IOM uint32_t GPIO15OUTCFG : 2;          /*!< (@ 0x0000001D) GPIO15 output configuration.                               */
      __IOM uint32_t GPIO15INTD : 1;            /*!< (@ 0x0000001F) GPIO15 interrupt direction.                                */
    } CFGB_b;
  } ;
  
  union {
    __IOM uint32_t CFGC;                        /*!< (@ 0x00000048) GPIO Configuration Register C                              */
    
    struct {
      __IOM uint32_t GPIO16INCFG : 1;           /*!< (@ 0x00000000) GPIO16 input enable.                                       */
      __IOM uint32_t GPIO16OUTCFG : 2;          /*!< (@ 0x00000001) GPIO16 output configuration.                               */
      __IOM uint32_t GPIO16INTD : 1;            /*!< (@ 0x00000003) GPIO16 interrupt direction.                                */
      __IOM uint32_t GPIO17INCFG : 1;           /*!< (@ 0x00000004) GPIO17 input enable.                                       */
      __IOM uint32_t GPIO17OUTCFG : 2;          /*!< (@ 0x00000005) GPIO17 output configuration.                               */
      __IOM uint32_t GPIO17INTD : 1;            /*!< (@ 0x00000007) GPIO17 interrupt direction.                                */
      __IOM uint32_t GPIO18INCFG : 1;           /*!< (@ 0x00000008) GPIO18 input enable.                                       */
      __IOM uint32_t GPIO18OUTCFG : 2;          /*!< (@ 0x00000009) GPIO18 output configuration.                               */
      __IOM uint32_t GPIO18INTD : 1;            /*!< (@ 0x0000000B) GPIO18 interrupt direction.                                */
      __IOM uint32_t GPIO19INCFG : 1;           /*!< (@ 0x0000000C) GPIO19 input enable.                                       */
      __IOM uint32_t GPIO19OUTCFG : 2;          /*!< (@ 0x0000000D) GPIO19 output configuration.                               */
      __IOM uint32_t GPIO19INTD : 1;            /*!< (@ 0x0000000F) GPIO19 interrupt direction.                                */
      __IOM uint32_t GPIO20INCFG : 1;           /*!< (@ 0x00000010) GPIO20 input enable.                                       */
      __IOM uint32_t GPIO20OUTCFG : 2;          /*!< (@ 0x00000011) GPIO20 output configuration.                               */
      __IOM uint32_t GPIO20INTD : 1;            /*!< (@ 0x00000013) GPIO20 interrupt direction.                                */
      __IOM uint32_t GPIO21INCFG : 1;           /*!< (@ 0x00000014) GPIO21 input enable.                                       */
      __IOM uint32_t GPIO21OUTCFG : 2;          /*!< (@ 0x00000015) GPIO21 output configuration.                               */
      __IOM uint32_t GPIO21INTD : 1;            /*!< (@ 0x00000017) GPIO21 interrupt direction.                                */
      __IOM uint32_t GPIO22INCFG : 1;           /*!< (@ 0x00000018) GPIO22 input enable.                                       */
      __IOM uint32_t GPIO22OUTCFG : 2;          /*!< (@ 0x00000019) GPIO22 output configuration.                               */
      __IOM uint32_t GPIO22INTD : 1;            /*!< (@ 0x0000001B) GPIO22 interrupt direction.                                */
      __IOM uint32_t GPIO23INCFG : 1;           /*!< (@ 0x0000001C) GPIO23 input enable.                                       */
      __IOM uint32_t GPIO23OUTCFG : 2;          /*!< (@ 0x0000001D) GPIO23 output configuration.                               */
      __IOM uint32_t GPIO23INTD : 1;            /*!< (@ 0x0000001F) GPIO23 interrupt direction.                                */
    } CFGC_b;
  } ;
  
  union {
    __IOM uint32_t CFGD;                        /*!< (@ 0x0000004C) GPIO Configuration Register D                              */
    
    struct {
      __IOM uint32_t GPIO24INCFG : 1;           /*!< (@ 0x00000000) GPIO24 input enable.                                       */
      __IOM uint32_t GPIO24OUTCFG : 2;          /*!< (@ 0x00000001) GPIO24 output configuration.                               */
      __IOM uint32_t GPIO24INTD : 1;            /*!< (@ 0x00000003) GPIO24 interrupt direction.                                */
      __IOM uint32_t GPIO25INCFG : 1;           /*!< (@ 0x00000004) GPIO25 input enable.                                       */
      __IOM uint32_t GPIO25OUTCFG : 2;          /*!< (@ 0x00000005) GPIO25 output configuration.                               */
      __IOM uint32_t GPIO25INTD : 1;            /*!< (@ 0x00000007) GPIO25 interrupt direction.                                */
      __IOM uint32_t GPIO26INCFG : 1;           /*!< (@ 0x00000008) GPIO26 input enable.                                       */
      __IOM uint32_t GPIO26OUTCFG : 2;          /*!< (@ 0x00000009) GPIO26 output configuration.                               */
      __IOM uint32_t GPIO26INTD : 1;            /*!< (@ 0x0000000B) GPIO26 interrupt direction.                                */
      __IOM uint32_t GPIO27INCFG : 1;           /*!< (@ 0x0000000C) GPIO27 input enable.                                       */
      __IOM uint32_t GPIO27OUTCFG : 2;          /*!< (@ 0x0000000D) GPIO27 output configuration.                               */
      __IOM uint32_t GPIO27INTD : 1;            /*!< (@ 0x0000000F) GPIO27 interrupt direction.                                */
      __IOM uint32_t GPIO28INCFG : 1;           /*!< (@ 0x00000010) GPIO28 input enable.                                       */
      __IOM uint32_t GPIO28OUTCFG : 2;          /*!< (@ 0x00000011) GPIO28 output configuration.                               */
      __IOM uint32_t GPIO28INTD : 1;            /*!< (@ 0x00000013) GPIO28 interrupt direction.                                */
      __IOM uint32_t GPIO29INCFG : 1;           /*!< (@ 0x00000014) GPIO29 input enable.                                       */
      __IOM uint32_t GPIO29OUTCFG : 2;          /*!< (@ 0x00000015) GPIO29 output configuration.                               */
      __IOM uint32_t GPIO29INTD : 1;            /*!< (@ 0x00000017) GPIO29 interrupt direction.                                */
      __IOM uint32_t GPIO30INCFG : 1;           /*!< (@ 0x00000018) GPIO30 input enable.                                       */
      __IOM uint32_t GPIO30OUTCFG : 2;          /*!< (@ 0x00000019) GPIO30 output configuration.                               */
      __IOM uint32_t GPIO30INTD : 1;            /*!< (@ 0x0000001B) GPIO30 interrupt direction.                                */
      __IOM uint32_t GPIO31INCFG : 1;           /*!< (@ 0x0000001C) GPIO31 input enable.                                       */
      __IOM uint32_t GPIO31OUTCFG : 2;          /*!< (@ 0x0000001D) GPIO31 output configuration.                               */
      __IOM uint32_t GPIO31INTD : 1;            /*!< (@ 0x0000001F) GPIO31 interrupt direction.                                */
    } CFGD_b;
  } ;
  
  union {
    __IOM uint32_t CFGE;                        /*!< (@ 0x00000050) GPIO Configuration Register E                              */
    
    struct {
      __IOM uint32_t GPIO32INCFG : 1;           /*!< (@ 0x00000000) GPIO32 input enable.                                       */
      __IOM uint32_t GPIO32OUTCFG : 2;          /*!< (@ 0x00000001) GPIO32 output configuration.                               */
      __IOM uint32_t GPIO32INTD : 1;            /*!< (@ 0x00000003) GPIO32 interrupt direction.                                */
      __IOM uint32_t GPIO33INCFG : 1;           /*!< (@ 0x00000004) GPIO33 input enable.                                       */
      __IOM uint32_t GPIO33OUTCFG : 2;          /*!< (@ 0x00000005) GPIO33 output configuration.                               */
      __IOM uint32_t GPIO33INTD : 1;            /*!< (@ 0x00000007) GPIO33 interrupt direction.                                */
      __IOM uint32_t GPIO34INCFG : 1;           /*!< (@ 0x00000008) GPIO34 input enable.                                       */
      __IOM uint32_t GPIO34OUTCFG : 2;          /*!< (@ 0x00000009) GPIO34 output configuration.                               */
      __IOM uint32_t GPIO34INTD : 1;            /*!< (@ 0x0000000B) GPIO34 interrupt direction.                                */
      __IOM uint32_t GPIO35INCFG : 1;           /*!< (@ 0x0000000C) GPIO35 input enable.                                       */
      __IOM uint32_t GPIO35OUTCFG : 2;          /*!< (@ 0x0000000D) GPIO35 output configuration.                               */
      __IOM uint32_t GPIO35INTD : 1;            /*!< (@ 0x0000000F) GPIO35 interrupt direction.                                */
      __IOM uint32_t GPIO36INCFG : 1;           /*!< (@ 0x00000010) GPIO36 input enable.                                       */
      __IOM uint32_t GPIO36OUTCFG : 2;          /*!< (@ 0x00000011) GPIO36 output configuration.                               */
      __IOM uint32_t GPIO36INTD : 1;            /*!< (@ 0x00000013) GPIO36 interrupt direction.                                */
      __IOM uint32_t GPIO37INCFG : 1;           /*!< (@ 0x00000014) GPIO37 input enable.                                       */
      __IOM uint32_t GPIO37OUTCFG : 2;          /*!< (@ 0x00000015) GPIO37 output configuration.                               */
      __IOM uint32_t GPIO37INTD : 1;            /*!< (@ 0x00000017) GPIO37 interrupt direction.                                */
      __IOM uint32_t GPIO38INCFG : 1;           /*!< (@ 0x00000018) GPIO38 input enable.                                       */
      __IOM uint32_t GPIO38OUTCFG : 2;          /*!< (@ 0x00000019) GPIO38 output configuration.                               */
      __IOM uint32_t GPIO38INTD : 1;            /*!< (@ 0x0000001B) GPIO38 interrupt direction.                                */
      __IOM uint32_t GPIO39INCFG : 1;           /*!< (@ 0x0000001C) GPIO39 input enable.                                       */
      __IOM uint32_t GPIO39OUTCFG : 2;          /*!< (@ 0x0000001D) GPIO39 output configuration.                               */
      __IOM uint32_t GPIO39INTD : 1;            /*!< (@ 0x0000001F) GPIO39 interrupt direction.                                */
    } CFGE_b;
  } ;
  
  union {
    __IOM uint32_t CFGF;                        /*!< (@ 0x00000054) GPIO Configuration Register F                              */
    
    struct {
      __IOM uint32_t GPIO40INCFG : 1;           /*!< (@ 0x00000000) GPIO40 input enable.                                       */
      __IOM uint32_t GPIO40OUTCFG : 2;          /*!< (@ 0x00000001) GPIO40 output configuration.                               */
      __IOM uint32_t GPIO40INTD : 1;            /*!< (@ 0x00000003) GPIO40 interrupt direction.                                */
      __IOM uint32_t GPIO41INCFG : 1;           /*!< (@ 0x00000004) GPIO41 input enable.                                       */
      __IOM uint32_t GPIO41OUTCFG : 2;          /*!< (@ 0x00000005) GPIO41 output configuration.                               */
      __IOM uint32_t GPIO41INTD : 1;            /*!< (@ 0x00000007) GPIO41 interrupt direction.                                */
      __IOM uint32_t GPIO42INCFG : 1;           /*!< (@ 0x00000008) GPIO42 input enable.                                       */
      __IOM uint32_t GPIO42OUTCFG : 2;          /*!< (@ 0x00000009) GPIO42 output configuration.                               */
      __IOM uint32_t GPIO42INTD : 1;            /*!< (@ 0x0000000B) GPIO42 interrupt direction.                                */
      __IOM uint32_t GPIO43INCFG : 1;           /*!< (@ 0x0000000C) GPIO43 input enable.                                       */
      __IOM uint32_t GPIO43OUTCFG : 2;          /*!< (@ 0x0000000D) GPIO43 output configuration.                               */
      __IOM uint32_t GPIO43INTD : 1;            /*!< (@ 0x0000000F) GPIO43 interrupt direction.                                */
      __IOM uint32_t GPIO44INCFG : 1;           /*!< (@ 0x00000010) GPIO44 input enable.                                       */
      __IOM uint32_t GPIO44OUTCFG : 2;          /*!< (@ 0x00000011) GPIO44 output configuration.                               */
      __IOM uint32_t GPIO44INTD : 1;            /*!< (@ 0x00000013) GPIO44 interrupt direction.                                */
      __IOM uint32_t GPIO45INCFG : 1;           /*!< (@ 0x00000014) GPIO45 input enable.                                       */
      __IOM uint32_t GPIO45OUTCFG : 2;          /*!< (@ 0x00000015) GPIO45 output configuration.                               */
      __IOM uint32_t GPIO45INTD : 1;            /*!< (@ 0x00000017) GPIO45 interrupt direction.                                */
      __IOM uint32_t GPIO46INCFG : 1;           /*!< (@ 0x00000018) GPIO46 input enable.                                       */
      __IOM uint32_t GPIO46OUTCFG : 2;          /*!< (@ 0x00000019) GPIO46 output configuration.                               */
      __IOM uint32_t GPIO46INTD : 1;            /*!< (@ 0x0000001B) GPIO46 interrupt direction.                                */
      __IOM uint32_t GPIO47INCFG : 1;           /*!< (@ 0x0000001C) GPIO47 input enable.                                       */
      __IOM uint32_t GPIO47OUTCFG : 2;          /*!< (@ 0x0000001D) GPIO47 output configuration.                               */
      __IOM uint32_t GPIO47INTD : 1;            /*!< (@ 0x0000001F) GPIO47 interrupt direction.                                */
    } CFGF_b;
  } ;
  
  union {
    __IOM uint32_t CFGG;                        /*!< (@ 0x00000058) GPIO Configuration Register G                              */
    
    struct {
      __IOM uint32_t GPIO48INCFG : 1;           /*!< (@ 0x00000000) GPIO48 input enable.                                       */
      __IOM uint32_t GPIO48OUTCFG : 2;          /*!< (@ 0x00000001) GPIO48 output configuration.                               */
      __IOM uint32_t GPIO48INTD : 1;            /*!< (@ 0x00000003) GPIO48 interrupt direction.                                */
      __IOM uint32_t GPIO49INCFG : 1;           /*!< (@ 0x00000004) GPIO49 input enable.                                       */
      __IOM uint32_t GPIO49OUTCFG : 2;          /*!< (@ 0x00000005) GPIO49 output configuration.                               */
      __IOM uint32_t GPIO49INTD : 1;            /*!< (@ 0x00000007) GPIO49 interrupt direction.                                */
    } CFGG_b;
  } ;
  __IM  uint32_t  RESERVED1;
  
  union {
    __IOM uint32_t PADKEY;                      /*!< (@ 0x00000060) Key Register for all pad configuration registers           */
    
    struct {
      __IOM uint32_t PADKEY     : 32;           /*!< (@ 0x00000000) Key register value.                                        */
    } PADKEY_b;
  } ;
  __IM  uint32_t  RESERVED2[7];
  
  union {
    __IOM uint32_t RDA;                         /*!< (@ 0x00000080) GPIO Input Register A                                      */
    
    struct {
      __IOM uint32_t RDA        : 32;           /*!< (@ 0x00000000) GPIO31-0 read data.                                        */
    } RDA_b;
  } ;
  
  union {
    __IOM uint32_t RDB;                         /*!< (@ 0x00000084) GPIO Input Register B                                      */
    
    struct {
      __IOM uint32_t RDB        : 18;           /*!< (@ 0x00000000) GPIO49-32 read data.                                       */
    } RDB_b;
  } ;
  
  union {
    __IOM uint32_t WTA;                         /*!< (@ 0x00000088) GPIO Output Register A                                     */
    
    struct {
      __IOM uint32_t WTA        : 32;           /*!< (@ 0x00000000) GPIO31-0 write data.                                       */
    } WTA_b;
  } ;
  
  union {
    __IOM uint32_t WTB;                         /*!< (@ 0x0000008C) GPIO Output Register B                                     */
    
    struct {
      __IOM uint32_t WTB        : 18;           /*!< (@ 0x00000000) GPIO49-32 write data.                                      */
    } WTB_b;
  } ;
  
  union {
    __IOM uint32_t WTSA;                        /*!< (@ 0x00000090) GPIO Output Register A Set                                 */
    
    struct {
      __IOM uint32_t WTSA       : 32;           /*!< (@ 0x00000000) Set the GPIO31-0 write data.                               */
    } WTSA_b;
  } ;
  
  union {
    __IOM uint32_t WTSB;                        /*!< (@ 0x00000094) GPIO Output Register B Set                                 */
    
    struct {
      __IOM uint32_t WTSB       : 18;           /*!< (@ 0x00000000) Set the GPIO49-32 write data.                              */
    } WTSB_b;
  } ;
  
  union {
    __IOM uint32_t WTCA;                        /*!< (@ 0x00000098) GPIO Output Register A Clear                               */
    
    struct {
      __IOM uint32_t WTCA       : 32;           /*!< (@ 0x00000000) Clear the GPIO31-0 write data.                             */
    } WTCA_b;
  } ;
  
  union {
    __IOM uint32_t WTCB;                        /*!< (@ 0x0000009C) GPIO Output Register B Clear                               */
    
    struct {
      __IOM uint32_t WTCB       : 18;           /*!< (@ 0x00000000) Clear the GPIO49-32 write data.                            */
    } WTCB_b;
  } ;
  
  union {
    __IOM uint32_t ENA;                         /*!< (@ 0x000000A0) GPIO Enable Register A                                     */
    
    struct {
      __IOM uint32_t ENA        : 32;           /*!< (@ 0x00000000) GPIO31-0 output enables                                    */
    } ENA_b;
  } ;
  
  union {
    __IOM uint32_t ENB;                         /*!< (@ 0x000000A4) GPIO Enable Register B                                     */
    
    struct {
      __IOM uint32_t ENB        : 18;           /*!< (@ 0x00000000) GPIO49-32 output enables                                   */
    } ENB_b;
  } ;
  
  union {
    __IOM uint32_t ENSA;                        /*!< (@ 0x000000A8) GPIO Enable Register A Set                                 */
    
    struct {
      __IOM uint32_t ENSA       : 32;           /*!< (@ 0x00000000) Set the GPIO31-0 output enables                            */
    } ENSA_b;
  } ;
  
  union {
    __IOM uint32_t ENSB;                        /*!< (@ 0x000000AC) GPIO Enable Register B Set                                 */
    
    struct {
      __IOM uint32_t ENSB       : 18;           /*!< (@ 0x00000000) Set the GPIO49-32 output enables                           */
    } ENSB_b;
  } ;
  __IM  uint32_t  RESERVED3;
  
  union {
    __IOM uint32_t ENCA;                        /*!< (@ 0x000000B4) GPIO Enable Register A Clear                               */
    
    struct {
      __IOM uint32_t ENCA       : 32;           /*!< (@ 0x00000000) Clear the GPIO31-0 output enables                          */
    } ENCA_b;
  } ;
  
  union {
    __IOM uint32_t ENCB;                        /*!< (@ 0x000000B8) GPIO Enable Register B Clear                               */
    
    struct {
      __IOM uint32_t ENCB       : 18;           /*!< (@ 0x00000000) Clear the GPIO49-32 output enables                         */
    } ENCB_b;
  } ;
  __IM  uint32_t  RESERVED4[81];
  
  union {
    __IOM uint32_t INT0EN;                      /*!< (@ 0x00000200) GPIO Interrupt Registers 31-0: Enable                      */
    
    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< (@ 0x00000000) GPIO0 interrupt.                                           */
      __IOM uint32_t GPIO1      : 1;            /*!< (@ 0x00000001) GPIO1 interrupt.                                           */
      __IOM uint32_t GPIO2      : 1;            /*!< (@ 0x00000002) GPIO2 interrupt.                                           */
      __IOM uint32_t GPIO3      : 1;            /*!< (@ 0x00000003) GPIO3 interrupt.                                           */
      __IOM uint32_t GPIO4      : 1;            /*!< (@ 0x00000004) GPIO4 interrupt.                                           */
      __IOM uint32_t GPIO5      : 1;            /*!< (@ 0x00000005) GPIO5 interrupt.                                           */
      __IOM uint32_t GPIO6      : 1;            /*!< (@ 0x00000006) GPIO6 interrupt.                                           */
      __IOM uint32_t GPIO7      : 1;            /*!< (@ 0x00000007) GPIO7 interrupt.                                           */
      __IOM uint32_t GPIO8      : 1;            /*!< (@ 0x00000008) GPIO8 interrupt.                                           */
      __IOM uint32_t GPIO9      : 1;            /*!< (@ 0x00000009) GPIO9 interrupt.                                           */
      __IOM uint32_t GPIO10     : 1;            /*!< (@ 0x0000000A) GPIO10 interrupt.                                          */
      __IOM uint32_t GPIO11     : 1;            /*!< (@ 0x0000000B) GPIO11 interrupt.                                          */
      __IOM uint32_t GPIO12     : 1;            /*!< (@ 0x0000000C) GPIO12 interrupt.                                          */
      __IOM uint32_t GPIO13     : 1;            /*!< (@ 0x0000000D) GPIO13 interrupt.                                          */
      __IOM uint32_t GPIO14     : 1;            /*!< (@ 0x0000000E) GPIO14 interrupt.                                          */
      __IOM uint32_t GPIO15     : 1;            /*!< (@ 0x0000000F) GPIO15 interrupt.                                          */
      __IOM uint32_t GPIO16     : 1;            /*!< (@ 0x00000010) GPIO16 interrupt.                                          */
      __IOM uint32_t GPIO17     : 1;            /*!< (@ 0x00000011) GPIO17 interrupt.                                          */
      __IOM uint32_t GPIO18     : 1;            /*!< (@ 0x00000012) GPIO18interrupt.                                           */
      __IOM uint32_t GPIO19     : 1;            /*!< (@ 0x00000013) GPIO19 interrupt.                                          */
      __IOM uint32_t GPIO20     : 1;            /*!< (@ 0x00000014) GPIO20 interrupt.                                          */
      __IOM uint32_t GPIO21     : 1;            /*!< (@ 0x00000015) GPIO21 interrupt.                                          */
      __IOM uint32_t GPIO22     : 1;            /*!< (@ 0x00000016) GPIO22 interrupt.                                          */
      __IOM uint32_t GPIO23     : 1;            /*!< (@ 0x00000017) GPIO23 interrupt.                                          */
      __IOM uint32_t GPIO24     : 1;            /*!< (@ 0x00000018) GPIO24 interrupt.                                          */
      __IOM uint32_t GPIO25     : 1;            /*!< (@ 0x00000019) GPIO25 interrupt.                                          */
      __IOM uint32_t GPIO26     : 1;            /*!< (@ 0x0000001A) GPIO26 interrupt.                                          */
      __IOM uint32_t GPIO27     : 1;            /*!< (@ 0x0000001B) GPIO27 interrupt.                                          */
      __IOM uint32_t GPIO28     : 1;            /*!< (@ 0x0000001C) GPIO28 interrupt.                                          */
      __IOM uint32_t GPIO29     : 1;            /*!< (@ 0x0000001D) GPIO29 interrupt.                                          */
      __IOM uint32_t GPIO30     : 1;            /*!< (@ 0x0000001E) GPIO30 interrupt.                                          */
      __IOM uint32_t GPIO31     : 1;            /*!< (@ 0x0000001F) GPIO31 interrupt.                                          */
    } INT0EN_b;
  } ;
  
  union {
    __IOM uint32_t INT0STAT;                    /*!< (@ 0x00000204) GPIO Interrupt Registers 31-0: Status                      */
    
    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< (@ 0x00000000) GPIO0 interrupt.                                           */
      __IOM uint32_t GPIO1      : 1;            /*!< (@ 0x00000001) GPIO1 interrupt.                                           */
      __IOM uint32_t GPIO2      : 1;            /*!< (@ 0x00000002) GPIO2 interrupt.                                           */
      __IOM uint32_t GPIO3      : 1;            /*!< (@ 0x00000003) GPIO3 interrupt.                                           */
      __IOM uint32_t GPIO4      : 1;            /*!< (@ 0x00000004) GPIO4 interrupt.                                           */
      __IOM uint32_t GPIO5      : 1;            /*!< (@ 0x00000005) GPIO5 interrupt.                                           */
      __IOM uint32_t GPIO6      : 1;            /*!< (@ 0x00000006) GPIO6 interrupt.                                           */
      __IOM uint32_t GPIO7      : 1;            /*!< (@ 0x00000007) GPIO7 interrupt.                                           */
      __IOM uint32_t GPIO8      : 1;            /*!< (@ 0x00000008) GPIO8 interrupt.                                           */
      __IOM uint32_t GPIO9      : 1;            /*!< (@ 0x00000009) GPIO9 interrupt.                                           */
      __IOM uint32_t GPIO10     : 1;            /*!< (@ 0x0000000A) GPIO10 interrupt.                                          */
      __IOM uint32_t GPIO11     : 1;            /*!< (@ 0x0000000B) GPIO11 interrupt.                                          */
      __IOM uint32_t GPIO12     : 1;            /*!< (@ 0x0000000C) GPIO12 interrupt.                                          */
      __IOM uint32_t GPIO13     : 1;            /*!< (@ 0x0000000D) GPIO13 interrupt.                                          */
      __IOM uint32_t GPIO14     : 1;            /*!< (@ 0x0000000E) GPIO14 interrupt.                                          */
      __IOM uint32_t GPIO15     : 1;            /*!< (@ 0x0000000F) GPIO15 interrupt.                                          */
      __IOM uint32_t GPIO16     : 1;            /*!< (@ 0x00000010) GPIO16 interrupt.                                          */
      __IOM uint32_t GPIO17     : 1;            /*!< (@ 0x00000011) GPIO17 interrupt.                                          */
      __IOM uint32_t GPIO18     : 1;            /*!< (@ 0x00000012) GPIO18interrupt.                                           */
      __IOM uint32_t GPIO19     : 1;            /*!< (@ 0x00000013) GPIO19 interrupt.                                          */
      __IOM uint32_t GPIO20     : 1;            /*!< (@ 0x00000014) GPIO20 interrupt.                                          */
      __IOM uint32_t GPIO21     : 1;            /*!< (@ 0x00000015) GPIO21 interrupt.                                          */
      __IOM uint32_t GPIO22     : 1;            /*!< (@ 0x00000016) GPIO22 interrupt.                                          */
      __IOM uint32_t GPIO23     : 1;            /*!< (@ 0x00000017) GPIO23 interrupt.                                          */
      __IOM uint32_t GPIO24     : 1;            /*!< (@ 0x00000018) GPIO24 interrupt.                                          */
      __IOM uint32_t GPIO25     : 1;            /*!< (@ 0x00000019) GPIO25 interrupt.                                          */
      __IOM uint32_t GPIO26     : 1;            /*!< (@ 0x0000001A) GPIO26 interrupt.                                          */
      __IOM uint32_t GPIO27     : 1;            /*!< (@ 0x0000001B) GPIO27 interrupt.                                          */
      __IOM uint32_t GPIO28     : 1;            /*!< (@ 0x0000001C) GPIO28 interrupt.                                          */
      __IOM uint32_t GPIO29     : 1;            /*!< (@ 0x0000001D) GPIO29 interrupt.                                          */
      __IOM uint32_t GPIO30     : 1;            /*!< (@ 0x0000001E) GPIO30 interrupt.                                          */
      __IOM uint32_t GPIO31     : 1;            /*!< (@ 0x0000001F) GPIO31 interrupt.                                          */
    } INT0STAT_b;
  } ;
  
  union {
    __IOM uint32_t INT0CLR;                     /*!< (@ 0x00000208) GPIO Interrupt Registers 31-0: Clear                       */
    
    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< (@ 0x00000000) GPIO0 interrupt.                                           */
      __IOM uint32_t GPIO1      : 1;            /*!< (@ 0x00000001) GPIO1 interrupt.                                           */
      __IOM uint32_t GPIO2      : 1;            /*!< (@ 0x00000002) GPIO2 interrupt.                                           */
      __IOM uint32_t GPIO3      : 1;            /*!< (@ 0x00000003) GPIO3 interrupt.                                           */
      __IOM uint32_t GPIO4      : 1;            /*!< (@ 0x00000004) GPIO4 interrupt.                                           */
      __IOM uint32_t GPIO5      : 1;            /*!< (@ 0x00000005) GPIO5 interrupt.                                           */
      __IOM uint32_t GPIO6      : 1;            /*!< (@ 0x00000006) GPIO6 interrupt.                                           */
      __IOM uint32_t GPIO7      : 1;            /*!< (@ 0x00000007) GPIO7 interrupt.                                           */
      __IOM uint32_t GPIO8      : 1;            /*!< (@ 0x00000008) GPIO8 interrupt.                                           */
      __IOM uint32_t GPIO9      : 1;            /*!< (@ 0x00000009) GPIO9 interrupt.                                           */
      __IOM uint32_t GPIO10     : 1;            /*!< (@ 0x0000000A) GPIO10 interrupt.                                          */
      __IOM uint32_t GPIO11     : 1;            /*!< (@ 0x0000000B) GPIO11 interrupt.                                          */
      __IOM uint32_t GPIO12     : 1;            /*!< (@ 0x0000000C) GPIO12 interrupt.                                          */
      __IOM uint32_t GPIO13     : 1;            /*!< (@ 0x0000000D) GPIO13 interrupt.                                          */
      __IOM uint32_t GPIO14     : 1;            /*!< (@ 0x0000000E) GPIO14 interrupt.                                          */
      __IOM uint32_t GPIO15     : 1;            /*!< (@ 0x0000000F) GPIO15 interrupt.                                          */
      __IOM uint32_t GPIO16     : 1;            /*!< (@ 0x00000010) GPIO16 interrupt.                                          */
      __IOM uint32_t GPIO17     : 1;            /*!< (@ 0x00000011) GPIO17 interrupt.                                          */
      __IOM uint32_t GPIO18     : 1;            /*!< (@ 0x00000012) GPIO18interrupt.                                           */
      __IOM uint32_t GPIO19     : 1;            /*!< (@ 0x00000013) GPIO19 interrupt.                                          */
      __IOM uint32_t GPIO20     : 1;            /*!< (@ 0x00000014) GPIO20 interrupt.                                          */
      __IOM uint32_t GPIO21     : 1;            /*!< (@ 0x00000015) GPIO21 interrupt.                                          */
      __IOM uint32_t GPIO22     : 1;            /*!< (@ 0x00000016) GPIO22 interrupt.                                          */
      __IOM uint32_t GPIO23     : 1;            /*!< (@ 0x00000017) GPIO23 interrupt.                                          */
      __IOM uint32_t GPIO24     : 1;            /*!< (@ 0x00000018) GPIO24 interrupt.                                          */
      __IOM uint32_t GPIO25     : 1;            /*!< (@ 0x00000019) GPIO25 interrupt.                                          */
      __IOM uint32_t GPIO26     : 1;            /*!< (@ 0x0000001A) GPIO26 interrupt.                                          */
      __IOM uint32_t GPIO27     : 1;            /*!< (@ 0x0000001B) GPIO27 interrupt.                                          */
      __IOM uint32_t GPIO28     : 1;            /*!< (@ 0x0000001C) GPIO28 interrupt.                                          */
      __IOM uint32_t GPIO29     : 1;            /*!< (@ 0x0000001D) GPIO29 interrupt.                                          */
      __IOM uint32_t GPIO30     : 1;            /*!< (@ 0x0000001E) GPIO30 interrupt.                                          */
      __IOM uint32_t GPIO31     : 1;            /*!< (@ 0x0000001F) GPIO31 interrupt.                                          */
    } INT0CLR_b;
  } ;
  
  union {
    __IOM uint32_t INT0SET;                     /*!< (@ 0x0000020C) GPIO Interrupt Registers 31-0: Set                         */
    
    struct {
      __IOM uint32_t GPIO0      : 1;            /*!< (@ 0x00000000) GPIO0 interrupt.                                           */
      __IOM uint32_t GPIO1      : 1;            /*!< (@ 0x00000001) GPIO1 interrupt.                                           */
      __IOM uint32_t GPIO2      : 1;            /*!< (@ 0x00000002) GPIO2 interrupt.                                           */
      __IOM uint32_t GPIO3      : 1;            /*!< (@ 0x00000003) GPIO3 interrupt.                                           */
      __IOM uint32_t GPIO4      : 1;            /*!< (@ 0x00000004) GPIO4 interrupt.                                           */
      __IOM uint32_t GPIO5      : 1;            /*!< (@ 0x00000005) GPIO5 interrupt.                                           */
      __IOM uint32_t GPIO6      : 1;            /*!< (@ 0x00000006) GPIO6 interrupt.                                           */
      __IOM uint32_t GPIO7      : 1;            /*!< (@ 0x00000007) GPIO7 interrupt.                                           */
      __IOM uint32_t GPIO8      : 1;            /*!< (@ 0x00000008) GPIO8 interrupt.                                           */
      __IOM uint32_t GPIO9      : 1;            /*!< (@ 0x00000009) GPIO9 interrupt.                                           */
      __IOM uint32_t GPIO10     : 1;            /*!< (@ 0x0000000A) GPIO10 interrupt.                                          */
      __IOM uint32_t GPIO11     : 1;            /*!< (@ 0x0000000B) GPIO11 interrupt.                                          */
      __IOM uint32_t GPIO12     : 1;            /*!< (@ 0x0000000C) GPIO12 interrupt.                                          */
      __IOM uint32_t GPIO13     : 1;            /*!< (@ 0x0000000D) GPIO13 interrupt.                                          */
      __IOM uint32_t GPIO14     : 1;            /*!< (@ 0x0000000E) GPIO14 interrupt.                                          */
      __IOM uint32_t GPIO15     : 1;            /*!< (@ 0x0000000F) GPIO15 interrupt.                                          */
      __IOM uint32_t GPIO16     : 1;            /*!< (@ 0x00000010) GPIO16 interrupt.                                          */
      __IOM uint32_t GPIO17     : 1;            /*!< (@ 0x00000011) GPIO17 interrupt.                                          */
      __IOM uint32_t GPIO18     : 1;            /*!< (@ 0x00000012) GPIO18interrupt.                                           */
      __IOM uint32_t GPIO19     : 1;            /*!< (@ 0x00000013) GPIO19 interrupt.                                          */
      __IOM uint32_t GPIO20     : 1;            /*!< (@ 0x00000014) GPIO20 interrupt.                                          */
      __IOM uint32_t GPIO21     : 1;            /*!< (@ 0x00000015) GPIO21 interrupt.                                          */
      __IOM uint32_t GPIO22     : 1;            /*!< (@ 0x00000016) GPIO22 interrupt.                                          */
      __IOM uint32_t GPIO23     : 1;            /*!< (@ 0x00000017) GPIO23 interrupt.                                          */
      __IOM uint32_t GPIO24     : 1;            /*!< (@ 0x00000018) GPIO24 interrupt.                                          */
      __IOM uint32_t GPIO25     : 1;            /*!< (@ 0x00000019) GPIO25 interrupt.                                          */
      __IOM uint32_t GPIO26     : 1;            /*!< (@ 0x0000001A) GPIO26 interrupt.                                          */
      __IOM uint32_t GPIO27     : 1;            /*!< (@ 0x0000001B) GPIO27 interrupt.                                          */
      __IOM uint32_t GPIO28     : 1;            /*!< (@ 0x0000001C) GPIO28 interrupt.                                          */
      __IOM uint32_t GPIO29     : 1;            /*!< (@ 0x0000001D) GPIO29 interrupt.                                          */
      __IOM uint32_t GPIO30     : 1;            /*!< (@ 0x0000001E) GPIO30 interrupt.                                          */
      __IOM uint32_t GPIO31     : 1;            /*!< (@ 0x0000001F) GPIO31 interrupt.                                          */
    } INT0SET_b;
  } ;
  
  union {
    __IOM uint32_t INT1EN;                      /*!< (@ 0x00000210) GPIO Interrupt Registers 49-32: Enable                     */
    
    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< (@ 0x00000000) GPIO32 interrupt.                                          */
      __IOM uint32_t GPIO33     : 1;            /*!< (@ 0x00000001) GPIO33 interrupt.                                          */
      __IOM uint32_t GPIO34     : 1;            /*!< (@ 0x00000002) GPIO34 interrupt.                                          */
      __IOM uint32_t GPIO35     : 1;            /*!< (@ 0x00000003) GPIO35 interrupt.                                          */
      __IOM uint32_t GPIO36     : 1;            /*!< (@ 0x00000004) GPIO36 interrupt.                                          */
      __IOM uint32_t GPIO37     : 1;            /*!< (@ 0x00000005) GPIO37 interrupt.                                          */
      __IOM uint32_t GPIO38     : 1;            /*!< (@ 0x00000006) GPIO38 interrupt.                                          */
      __IOM uint32_t GPIO39     : 1;            /*!< (@ 0x00000007) GPIO39 interrupt.                                          */
      __IOM uint32_t GPIO40     : 1;            /*!< (@ 0x00000008) GPIO40 interrupt.                                          */
      __IOM uint32_t GPIO41     : 1;            /*!< (@ 0x00000009) GPIO41 interrupt.                                          */
      __IOM uint32_t GPIO42     : 1;            /*!< (@ 0x0000000A) GPIO42 interrupt.                                          */
      __IOM uint32_t GPIO43     : 1;            /*!< (@ 0x0000000B) GPIO43 interrupt.                                          */
      __IOM uint32_t GPIO44     : 1;            /*!< (@ 0x0000000C) GPIO44 interrupt.                                          */
      __IOM uint32_t GPIO45     : 1;            /*!< (@ 0x0000000D) GPIO45 interrupt.                                          */
      __IOM uint32_t GPIO46     : 1;            /*!< (@ 0x0000000E) GPIO46 interrupt.                                          */
      __IOM uint32_t GPIO47     : 1;            /*!< (@ 0x0000000F) GPIO47 interrupt.                                          */
      __IOM uint32_t GPIO48     : 1;            /*!< (@ 0x00000010) GPIO48 interrupt.                                          */
      __IOM uint32_t GPIO49     : 1;            /*!< (@ 0x00000011) GPIO49 interrupt.                                          */
    } INT1EN_b;
  } ;
  
  union {
    __IOM uint32_t INT1STAT;                    /*!< (@ 0x00000214) GPIO Interrupt Registers 49-32: Status                     */
    
    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< (@ 0x00000000) GPIO32 interrupt.                                          */
      __IOM uint32_t GPIO33     : 1;            /*!< (@ 0x00000001) GPIO33 interrupt.                                          */
      __IOM uint32_t GPIO34     : 1;            /*!< (@ 0x00000002) GPIO34 interrupt.                                          */
      __IOM uint32_t GPIO35     : 1;            /*!< (@ 0x00000003) GPIO35 interrupt.                                          */
      __IOM uint32_t GPIO36     : 1;            /*!< (@ 0x00000004) GPIO36 interrupt.                                          */
      __IOM uint32_t GPIO37     : 1;            /*!< (@ 0x00000005) GPIO37 interrupt.                                          */
      __IOM uint32_t GPIO38     : 1;            /*!< (@ 0x00000006) GPIO38 interrupt.                                          */
      __IOM uint32_t GPIO39     : 1;            /*!< (@ 0x00000007) GPIO39 interrupt.                                          */
      __IOM uint32_t GPIO40     : 1;            /*!< (@ 0x00000008) GPIO40 interrupt.                                          */
      __IOM uint32_t GPIO41     : 1;            /*!< (@ 0x00000009) GPIO41 interrupt.                                          */
      __IOM uint32_t GPIO42     : 1;            /*!< (@ 0x0000000A) GPIO42 interrupt.                                          */
      __IOM uint32_t GPIO43     : 1;            /*!< (@ 0x0000000B) GPIO43 interrupt.                                          */
      __IOM uint32_t GPIO44     : 1;            /*!< (@ 0x0000000C) GPIO44 interrupt.                                          */
      __IOM uint32_t GPIO45     : 1;            /*!< (@ 0x0000000D) GPIO45 interrupt.                                          */
      __IOM uint32_t GPIO46     : 1;            /*!< (@ 0x0000000E) GPIO46 interrupt.                                          */
      __IOM uint32_t GPIO47     : 1;            /*!< (@ 0x0000000F) GPIO47 interrupt.                                          */
      __IOM uint32_t GPIO48     : 1;            /*!< (@ 0x00000010) GPIO48 interrupt.                                          */
      __IOM uint32_t GPIO49     : 1;            /*!< (@ 0x00000011) GPIO49 interrupt.                                          */
    } INT1STAT_b;
  } ;
  
  union {
    __IOM uint32_t INT1CLR;                     /*!< (@ 0x00000218) GPIO Interrupt Registers 49-32: Clear                      */
    
    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< (@ 0x00000000) GPIO32 interrupt.                                          */
      __IOM uint32_t GPIO33     : 1;            /*!< (@ 0x00000001) GPIO33 interrupt.                                          */
      __IOM uint32_t GPIO34     : 1;            /*!< (@ 0x00000002) GPIO34 interrupt.                                          */
      __IOM uint32_t GPIO35     : 1;            /*!< (@ 0x00000003) GPIO35 interrupt.                                          */
      __IOM uint32_t GPIO36     : 1;            /*!< (@ 0x00000004) GPIO36 interrupt.                                          */
      __IOM uint32_t GPIO37     : 1;            /*!< (@ 0x00000005) GPIO37 interrupt.                                          */
      __IOM uint32_t GPIO38     : 1;            /*!< (@ 0x00000006) GPIO38 interrupt.                                          */
      __IOM uint32_t GPIO39     : 1;            /*!< (@ 0x00000007) GPIO39 interrupt.                                          */
      __IOM uint32_t GPIO40     : 1;            /*!< (@ 0x00000008) GPIO40 interrupt.                                          */
      __IOM uint32_t GPIO41     : 1;            /*!< (@ 0x00000009) GPIO41 interrupt.                                          */
      __IOM uint32_t GPIO42     : 1;            /*!< (@ 0x0000000A) GPIO42 interrupt.                                          */
      __IOM uint32_t GPIO43     : 1;            /*!< (@ 0x0000000B) GPIO43 interrupt.                                          */
      __IOM uint32_t GPIO44     : 1;            /*!< (@ 0x0000000C) GPIO44 interrupt.                                          */
      __IOM uint32_t GPIO45     : 1;            /*!< (@ 0x0000000D) GPIO45 interrupt.                                          */
      __IOM uint32_t GPIO46     : 1;            /*!< (@ 0x0000000E) GPIO46 interrupt.                                          */
      __IOM uint32_t GPIO47     : 1;            /*!< (@ 0x0000000F) GPIO47 interrupt.                                          */
      __IOM uint32_t GPIO48     : 1;            /*!< (@ 0x00000010) GPIO48 interrupt.                                          */
      __IOM uint32_t GPIO49     : 1;            /*!< (@ 0x00000011) GPIO49 interrupt.                                          */
    } INT1CLR_b;
  } ;
  
  union {
    __IOM uint32_t INT1SET;                     /*!< (@ 0x0000021C) GPIO Interrupt Registers 49-32: Set                        */
    
    struct {
      __IOM uint32_t GPIO32     : 1;            /*!< (@ 0x00000000) GPIO32 interrupt.                                          */
      __IOM uint32_t GPIO33     : 1;            /*!< (@ 0x00000001) GPIO33 interrupt.                                          */
      __IOM uint32_t GPIO34     : 1;            /*!< (@ 0x00000002) GPIO34 interrupt.                                          */
      __IOM uint32_t GPIO35     : 1;            /*!< (@ 0x00000003) GPIO35 interrupt.                                          */
      __IOM uint32_t GPIO36     : 1;            /*!< (@ 0x00000004) GPIO36 interrupt.                                          */
      __IOM uint32_t GPIO37     : 1;            /*!< (@ 0x00000005) GPIO37 interrupt.                                          */
      __IOM uint32_t GPIO38     : 1;            /*!< (@ 0x00000006) GPIO38 interrupt.                                          */
      __IOM uint32_t GPIO39     : 1;            /*!< (@ 0x00000007) GPIO39 interrupt.                                          */
      __IOM uint32_t GPIO40     : 1;            /*!< (@ 0x00000008) GPIO40 interrupt.                                          */
      __IOM uint32_t GPIO41     : 1;            /*!< (@ 0x00000009) GPIO41 interrupt.                                          */
      __IOM uint32_t GPIO42     : 1;            /*!< (@ 0x0000000A) GPIO42 interrupt.                                          */
      __IOM uint32_t GPIO43     : 1;            /*!< (@ 0x0000000B) GPIO43 interrupt.                                          */
      __IOM uint32_t GPIO44     : 1;            /*!< (@ 0x0000000C) GPIO44 interrupt.                                          */
      __IOM uint32_t GPIO45     : 1;            /*!< (@ 0x0000000D) GPIO45 interrupt.                                          */
      __IOM uint32_t GPIO46     : 1;            /*!< (@ 0x0000000E) GPIO46 interrupt.                                          */
      __IOM uint32_t GPIO47     : 1;            /*!< (@ 0x0000000F) GPIO47 interrupt.                                          */
      __IOM uint32_t GPIO48     : 1;            /*!< (@ 0x00000010) GPIO48 interrupt.                                          */
      __IOM uint32_t GPIO49     : 1;            /*!< (@ 0x00000011) GPIO49 interrupt.                                          */
    } INT1SET_b;
  } ;
} GPIO_Type;                                    /*!< Size = 544 (0x220)                                                        */



/* =========================================================================================================================== */
/* ================                                          IOMSTR0                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C/SPI Master (IOMSTR0)
  */

typedef struct {                                /*!< (@ 0x50004000) IOMSTR0 Structure                                          */
  
  union {
    __IOM uint32_t FIFO;                        /*!< (@ 0x00000000) FIFO Access Port                                           */
    
    struct {
      __IOM uint32_t FIFO       : 32;           /*!< (@ 0x00000000) FIFO access port.                                          */
    } FIFO_b;
  } ;
  __IM  uint32_t  RESERVED[63];
  
  union {
    __IOM uint32_t FIFOPTR;                     /*!< (@ 0x00000100) Current FIFO Pointers                                      */
    
    struct {
      __IOM uint32_t FIFOSIZ    : 7;            /*!< (@ 0x00000000) The number of bytes currently in the FIFO.                 */
      __IM  uint32_t            : 9;
      __IOM uint32_t FIFOREM    : 7;            /*!< (@ 0x00000010) The number of bytes remaining in the FIFO (i.e.
                                                                    64-FIFOSIZ).                                               */
    } FIFOPTR_b;
  } ;
  
  union {
    __IOM uint32_t TLNGTH;                      /*!< (@ 0x00000104) Transfer Length                                            */
    
    struct {
      __IOM uint32_t TLNGTH     : 12;           /*!< (@ 0x00000000) Remaining transfer length.                                 */
    } TLNGTH_b;
  } ;
  
  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000108) FIFO Threshold Configuration                               */
    
    struct {
      __IOM uint32_t FIFORTHR   : 6;            /*!< (@ 0x00000000) FIFO read threshold.                                       */
      __IM  uint32_t            : 2;
      __IOM uint32_t FIFOWTHR   : 6;            /*!< (@ 0x00000008) FIFO write threshold.                                      */
    } FIFOTHR_b;
  } ;
  
  union {
    __IOM uint32_t CLKCFG;                      /*!< (@ 0x0000010C) I/O Clock Configuration                                    */
    
    struct {
      __IM  uint32_t            : 8;
      __IOM uint32_t FSEL       : 3;            /*!< (@ 0x00000008) Select the input clock frequency.                          */
      __IOM uint32_t DIV3       : 1;            /*!< (@ 0x0000000B) Enable divide by 3.                                        */
      __IOM uint32_t DIVEN      : 1;            /*!< (@ 0x0000000C) Enable clock division by TOTPER.                           */
      __IM  uint32_t            : 3;
      __IOM uint32_t LOWPER     : 8;            /*!< (@ 0x00000010) Clock low count minus 1.                                   */
      __IOM uint32_t TOTPER     : 8;            /*!< (@ 0x00000018) Clock total count minus 1.                                 */
    } CLKCFG_b;
  } ;
  
  union {
    __IOM uint32_t CMD;                         /*!< (@ 0x00000110) Command Register                                           */
    
    struct {
      __IOM uint32_t CMD        : 32;           /*!< (@ 0x00000000) This register is the I/O Command.                          */
    } CMD_b;
  } ;
  
  union {
    __IOM uint32_t CMDRPT;                      /*!< (@ 0x00000114) Command Repeat Register                                    */
    
    struct {
      __IOM uint32_t CMDRPT     : 5;            /*!< (@ 0x00000000) These bits hold the Command repeat count.                  */
    } CMDRPT_b;
  } ;
  
  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x00000118) Status Register                                            */
    
    struct {
      __IOM uint32_t ERR        : 1;            /*!< (@ 0x00000000) This bit indicates if an error interrupt has
                                                                    occurred.                                                  */
      __IOM uint32_t CMDACT     : 1;            /*!< (@ 0x00000001) This bit indicates if the I/O Command is active.           */
      __IOM uint32_t IDLEST     : 1;            /*!< (@ 0x00000002) This bit indicates if the I/O state machine is
                                                                    IDLE.                                                      */
    } STATUS_b;
  } ;
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x0000011C) I/O Master Configuration                                   */
    
    struct {
      __IOM uint32_t IFCSEL     : 1;            /*!< (@ 0x00000000) This bit selects the I/O interface.                        */
      __IOM uint32_t SPOL       : 1;            /*!< (@ 0x00000001) This bit selects SPI polarity.                             */
      __IOM uint32_t SPHA       : 1;            /*!< (@ 0x00000002) This bit selects SPI phase.                                */
      __IM  uint32_t            : 28;
      __IOM uint32_t IFCEN      : 1;            /*!< (@ 0x0000001F) This bit enables the IO Master.                            */
    } CFG_b;
  } ;
  __IM  uint32_t  RESERVED1[56];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) IO Master Interrupts: Enable                               */
    
    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< (@ 0x00000000) This is the Command Complete interrupt.                    */
      __IOM uint32_t THR        : 1;            /*!< (@ 0x00000001) This is the FIFO Threshold interrupt.                      */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) This is the Write FIFO Underflow interrupt.                */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000003) This is the Read FIFO Overflow interrupt.                  */
      __IOM uint32_t NAK        : 1;            /*!< (@ 0x00000004) This is the I2C NAK interrupt.                             */
      __IOM uint32_t WTLEN      : 1;            /*!< (@ 0x00000005) This is the write length mismatch interrupt.               */
      __IOM uint32_t IACC       : 1;            /*!< (@ 0x00000006) This is the illegal FIFO access interrupt.                 */
      __IOM uint32_t ICMD       : 1;            /*!< (@ 0x00000007) This is the illegal command interrupt.                     */
      __IOM uint32_t START      : 1;            /*!< (@ 0x00000008) This is the START command interrupt.                       */
      __IOM uint32_t STOP       : 1;            /*!< (@ 0x00000009) This is the STOP command interrupt.                        */
      __IOM uint32_t ARB        : 1;            /*!< (@ 0x0000000A) This is the arbitration loss interrupt.                    */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) IO Master Interrupts: Status                               */
    
    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< (@ 0x00000000) This is the Command Complete interrupt.                    */
      __IOM uint32_t THR        : 1;            /*!< (@ 0x00000001) This is the FIFO Threshold interrupt.                      */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) This is the Write FIFO Underflow interrupt.                */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000003) This is the Read FIFO Overflow interrupt.                  */
      __IOM uint32_t NAK        : 1;            /*!< (@ 0x00000004) This is the I2C NAK interrupt.                             */
      __IOM uint32_t WTLEN      : 1;            /*!< (@ 0x00000005) This is the write length mismatch interrupt.               */
      __IOM uint32_t IACC       : 1;            /*!< (@ 0x00000006) This is the illegal FIFO access interrupt.                 */
      __IOM uint32_t ICMD       : 1;            /*!< (@ 0x00000007) This is the illegal command interrupt.                     */
      __IOM uint32_t START      : 1;            /*!< (@ 0x00000008) This is the START command interrupt.                       */
      __IOM uint32_t STOP       : 1;            /*!< (@ 0x00000009) This is the STOP command interrupt.                        */
      __IOM uint32_t ARB        : 1;            /*!< (@ 0x0000000A) This is the arbitration loss interrupt.                    */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) IO Master Interrupts: Clear                                */
    
    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< (@ 0x00000000) This is the Command Complete interrupt.                    */
      __IOM uint32_t THR        : 1;            /*!< (@ 0x00000001) This is the FIFO Threshold interrupt.                      */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) This is the Write FIFO Underflow interrupt.                */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000003) This is the Read FIFO Overflow interrupt.                  */
      __IOM uint32_t NAK        : 1;            /*!< (@ 0x00000004) This is the I2C NAK interrupt.                             */
      __IOM uint32_t WTLEN      : 1;            /*!< (@ 0x00000005) This is the write length mismatch interrupt.               */
      __IOM uint32_t IACC       : 1;            /*!< (@ 0x00000006) This is the illegal FIFO access interrupt.                 */
      __IOM uint32_t ICMD       : 1;            /*!< (@ 0x00000007) This is the illegal command interrupt.                     */
      __IOM uint32_t START      : 1;            /*!< (@ 0x00000008) This is the START command interrupt.                       */
      __IOM uint32_t STOP       : 1;            /*!< (@ 0x00000009) This is the STOP command interrupt.                        */
      __IOM uint32_t ARB        : 1;            /*!< (@ 0x0000000A) This is the arbitration loss interrupt.                    */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) IO Master Interrupts: Set                                  */
    
    struct {
      __IOM uint32_t CMDCMP     : 1;            /*!< (@ 0x00000000) This is the Command Complete interrupt.                    */
      __IOM uint32_t THR        : 1;            /*!< (@ 0x00000001) This is the FIFO Threshold interrupt.                      */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) This is the Write FIFO Underflow interrupt.                */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000003) This is the Read FIFO Overflow interrupt.                  */
      __IOM uint32_t NAK        : 1;            /*!< (@ 0x00000004) This is the I2C NAK interrupt.                             */
      __IOM uint32_t WTLEN      : 1;            /*!< (@ 0x00000005) This is the write length mismatch interrupt.               */
      __IOM uint32_t IACC       : 1;            /*!< (@ 0x00000006) This is the illegal FIFO access interrupt.                 */
      __IOM uint32_t ICMD       : 1;            /*!< (@ 0x00000007) This is the illegal command interrupt.                     */
      __IOM uint32_t START      : 1;            /*!< (@ 0x00000008) This is the START command interrupt.                       */
      __IOM uint32_t STOP       : 1;            /*!< (@ 0x00000009) This is the STOP command interrupt.                        */
      __IOM uint32_t ARB        : 1;            /*!< (@ 0x0000000A) This is the arbitration loss interrupt.                    */
    } INTSET_b;
  } ;
} IOMSTR0_Type;                                 /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                          IOSLAVE                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief I2C/SPI Slave (IOSLAVE)
  */

typedef struct {                                /*!< (@ 0x50000000) IOSLAVE Structure                                          */
  __IM  uint32_t  RESERVED[64];
  
  union {
    __IOM uint32_t FIFOPTR;                     /*!< (@ 0x00000100) Current FIFO Pointer                                       */
    
    struct {
      __IOM uint32_t FIFOPTR    : 8;            /*!< (@ 0x00000000) Current FIFO pointer.                                      */
      __IOM uint32_t FIFOSIZ    : 8;            /*!< (@ 0x00000008) The number of bytes currently in the hardware
                                                                    FIFO.                                                      */
    } FIFOPTR_b;
  } ;
  
  union {
    __IOM uint32_t FIFOCFG;                     /*!< (@ 0x00000104) FIFO Configuration                                         */
    
    struct {
      __IOM uint32_t FIFOBASE   : 5;            /*!< (@ 0x00000000) These bits hold the base address of the I/O FIFO
                                                                    in 8 byte segments. The IO Slave FIFO is
                                                                    situated in LRAM at (FIFOBASE*8) to (FIFOMAX*8-1).         */
      __IM  uint32_t            : 3;
      __IOM uint32_t FIFOMAX    : 6;            /*!< (@ 0x00000008) These bits hold the maximum FIFO address in 8
                                                                    byte segments. It is also the beginning
                                                                    of the RAM area of the LRAM. Note that
                                                                    no RAM area is configured if FIFOMAX is
                                                                    set to 0x1F.                                               */
      __IM  uint32_t            : 10;
      __IOM uint32_t ROBASE     : 6;            /*!< (@ 0x00000018) Defines the read-only area. The IO Slave read-only
                                                                    area is situated in LRAM at (ROBASE*8)
                                                                    to (FIFOOBASE*8-1)                                         */
    } FIFOCFG_b;
  } ;
  
  union {
    __IOM uint32_t FIFOTHR;                     /*!< (@ 0x00000108) FIFO Threshold Configuration                               */
    
    struct {
      __IOM uint32_t FIFOTHR    : 8;            /*!< (@ 0x00000000) FIFO size interrupt threshold.                             */
    } FIFOTHR_b;
  } ;
  
  union {
    __IOM uint32_t FUPD;                        /*!< (@ 0x0000010C) FIFO Update Status                                         */
    
    struct {
      __IOM uint32_t FIFOUPD    : 1;            /*!< (@ 0x00000000) This bit indicates that a FIFO update is underway.         */
      __IOM uint32_t IOREAD     : 1;            /*!< (@ 0x00000001) This bitfield indicates an IO read is active.              */
    } FUPD_b;
  } ;
  
  union {
    __IOM uint32_t FIFOCTR;                     /*!< (@ 0x00000110) Overall FIFO Counter                                       */
    
    struct {
      __IOM uint32_t FIFOCTR    : 10;           /*!< (@ 0x00000000) Virtual FIFO byte count                                    */
    } FIFOCTR_b;
  } ;
  
  union {
    __IOM uint32_t FIFOINC;                     /*!< (@ 0x00000114) Overall FIFO Counter Increment                             */
    
    struct {
      __IOM uint32_t FIFOINC    : 10;           /*!< (@ 0x00000000) Increment the Overall FIFO Counter by this value
                                                                    on a write                                                 */
    } FIFOINC_b;
  } ;
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000118) I/O Slave Configuration                                    */
    
    struct {
      __IOM uint32_t IFCSEL     : 1;            /*!< (@ 0x00000000) This bit selects the I/O interface.                        */
      __IOM uint32_t SPOL       : 1;            /*!< (@ 0x00000001) This bit selects SPI polarity.                             */
      __IOM uint32_t LSB        : 1;            /*!< (@ 0x00000002) This bit selects the transfer bit ordering.                */
      __IM  uint32_t            : 1;
      __IOM uint32_t STARTRD    : 1;            /*!< (@ 0x00000004) This bit holds the cycle to initiate an I/O RAM
                                                                    read.                                                      */
      __IM  uint32_t            : 3;
      __IOM uint32_t I2CADDR    : 12;           /*!< (@ 0x00000008) 7-bit or 10-bit I2C device address.                        */
      __IM  uint32_t            : 11;
      __IOM uint32_t IFCEN      : 1;            /*!< (@ 0x0000001F) IOSLAVE interface enable.                                  */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t PRENC;                       /*!< (@ 0x0000011C) I/O Slave Interrupt Priority Encode                        */
    
    struct {
      __IOM uint32_t PRENC      : 5;            /*!< (@ 0x00000000) These bits hold the priority encode of the REGACC
                                                                    interrupts.                                                */
    } PRENC_b;
  } ;
  
  union {
    __IOM uint32_t IOINTCTL;                    /*!< (@ 0x00000120) I/O Interrupt Control                                      */
    
    struct {
      __IOM uint32_t IOINTEN    : 8;            /*!< (@ 0x00000000) These bits setread the IOINT interrupt enables.            */
      __IOM uint32_t IOINT      : 8;            /*!< (@ 0x00000008) These bits read the IOINT interrupts.                      */
      __IOM uint32_t IOINTCLR   : 1;            /*!< (@ 0x00000010) This bit clears all of the IOINT interrupts when
                                                                    written with a 1.                                          */
      __IM  uint32_t            : 7;
      __IOM uint32_t IOINTSET   : 8;            /*!< (@ 0x00000018) These bits set the IOINT interrupts when written
                                                                    with a 1.                                                  */
    } IOINTCTL_b;
  } ;
  
  union {
    __IOM uint32_t GENADD;                      /*!< (@ 0x00000124) General Address Data                                       */
    
    struct {
      __IOM uint32_t GADATA     : 8;            /*!< (@ 0x00000000) The data supplied on the last General Address
                                                                    reference.                                                 */
    } GENADD_b;
  } ;
  __IM  uint32_t  RESERVED1[54];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) IO Slave Interrupts: Enable                                */
    
    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< (@ 0x00000000) FIFO Size interrupt.                                       */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000001) FIFO Overflow interrupt.                                   */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) FIFO Underflow interrupt.                                  */
      __IOM uint32_t FRDERR     : 1;            /*!< (@ 0x00000003) FIFO Read Error interrupt.                                 */
      __IOM uint32_t GENAD      : 1;            /*!< (@ 0x00000004) I2C General Address interrupt.                             */
      __IOM uint32_t IOINTW     : 1;            /*!< (@ 0x00000005) I2C Interrupt Write interrupt.                             */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) IO Slave Interrupts: Status                                */
    
    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< (@ 0x00000000) FIFO Size interrupt.                                       */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000001) FIFO Overflow interrupt.                                   */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) FIFO Underflow interrupt.                                  */
      __IOM uint32_t FRDERR     : 1;            /*!< (@ 0x00000003) FIFO Read Error interrupt.                                 */
      __IOM uint32_t GENAD      : 1;            /*!< (@ 0x00000004) I2C General Address interrupt.                             */
      __IOM uint32_t IOINTW     : 1;            /*!< (@ 0x00000005) I2C Interrupt Write interrupt.                             */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) IO Slave Interrupts: Clear                                 */
    
    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< (@ 0x00000000) FIFO Size interrupt.                                       */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000001) FIFO Overflow interrupt.                                   */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) FIFO Underflow interrupt.                                  */
      __IOM uint32_t FRDERR     : 1;            /*!< (@ 0x00000003) FIFO Read Error interrupt.                                 */
      __IOM uint32_t GENAD      : 1;            /*!< (@ 0x00000004) I2C General Address interrupt.                             */
      __IOM uint32_t IOINTW     : 1;            /*!< (@ 0x00000005) I2C Interrupt Write interrupt.                             */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) IO Slave Interrupts: Set                                   */
    
    struct {
      __IOM uint32_t FSIZE      : 1;            /*!< (@ 0x00000000) FIFO Size interrupt.                                       */
      __IOM uint32_t FOVFL      : 1;            /*!< (@ 0x00000001) FIFO Overflow interrupt.                                   */
      __IOM uint32_t FUNDFL     : 1;            /*!< (@ 0x00000002) FIFO Underflow interrupt.                                  */
      __IOM uint32_t FRDERR     : 1;            /*!< (@ 0x00000003) FIFO Read Error interrupt.                                 */
      __IOM uint32_t GENAD      : 1;            /*!< (@ 0x00000004) I2C General Address interrupt.                             */
      __IOM uint32_t IOINTW     : 1;            /*!< (@ 0x00000005) I2C Interrupt Write interrupt.                             */
    } INTSET_b;
  } ;
  
  union {
    __IOM uint32_t REGACCINTEN;                 /*!< (@ 0x00000210) Register Access Interrupts: Enable                         */
    
    struct {
      __IOM uint32_t REGACC     : 32;           /*!< (@ 0x00000000) Register access interrupts.                                */
    } REGACCINTEN_b;
  } ;
  
  union {
    __IOM uint32_t REGACCINTSTAT;               /*!< (@ 0x00000214) Register Access Interrupts: Status                         */
    
    struct {
      __IOM uint32_t REGACC     : 32;           /*!< (@ 0x00000000) Register access interrupts.                                */
    } REGACCINTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t REGACCINTCLR;                /*!< (@ 0x00000218) Register Access Interrupts: Clear                          */
    
    struct {
      __IOM uint32_t REGACC     : 32;           /*!< (@ 0x00000000) Register access interrupts.                                */
    } REGACCINTCLR_b;
  } ;
  
  union {
    __IOM uint32_t REGACCINTSET;                /*!< (@ 0x0000021C) Register Access Interrupts: Set                            */
    
    struct {
      __IOM uint32_t REGACC     : 32;           /*!< (@ 0x00000000) Register access interrupts.                                */
    } REGACCINTSET_b;
  } ;
} IOSLAVE_Type;                                 /*!< Size = 544 (0x220)                                                        */



/* =========================================================================================================================== */
/* ================                                          MCUCTRL                                          ================ */
/* =========================================================================================================================== */


/**
  * @brief MCU Miscellaneous Control Logic (MCUCTRL)
  */

typedef struct {                                /*!< (@ 0x40020000) MCUCTRL Structure                                          */
  
  union {
    __IOM uint32_t CHIP_INFO;                   /*!< (@ 0x00000000) Chip Information Register                                  */
    
    struct {
      __IOM uint32_t QUAL       : 1;            /*!< (@ 0x00000000) Device qualified.                                          */
      __IOM uint32_t TEMP       : 2;            /*!< (@ 0x00000001) Device temperature range.                                  */
      __IOM uint32_t PINS       : 3;            /*!< (@ 0x00000003) Number of pins.                                            */
      __IOM uint32_t PKG        : 2;            /*!< (@ 0x00000006) Device package type.                                       */
      __IOM uint32_t MINORREV   : 4;            /*!< (@ 0x00000008) Minor device revision number.                              */
      __IOM uint32_t MAJORREV   : 4;            /*!< (@ 0x0000000C) Major device revision number.                              */
      __IOM uint32_t RAM        : 4;            /*!< (@ 0x00000010) Device RAM size.                                           */
      __IOM uint32_t FLASH      : 4;            /*!< (@ 0x00000014) Device flash size.                                         */
      __IOM uint32_t CLASS      : 8;            /*!< (@ 0x00000018) Device class.                                              */
    } CHIP_INFO_b;
  } ;
  
  union {
    __IOM uint32_t CHIPID0;                     /*!< (@ 0x00000004) Unique Chip ID 0                                           */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Unique chip ID 0.                                          */
    } CHIPID0_b;
  } ;
  
  union {
    __IOM uint32_t CHIPID1;                     /*!< (@ 0x00000008) Unique Chip ID 1                                           */
    
    struct {
      __IOM uint32_t VALUE      : 32;           /*!< (@ 0x00000000) Unique chip ID 1.                                          */
    } CHIPID1_b;
  } ;
  
  union {
    __IOM uint32_t CHIPREV;                     /*!< (@ 0x0000000C) Chip Revision                                              */
    
    struct {
      __IOM uint32_t REVISION   : 8;            /*!< (@ 0x00000000) Chip Revision Number.                                      */
    } CHIPREV_b;
  } ;
  
  union {
    __IOM uint32_t SUPPLYSRC;                   /*!< (@ 0x00000010) Memory and Core Voltage Supply Source Select
                                                                    Register                                                   */
    
    struct {
      __IOM uint32_t MEMBUCKEN  : 1;            /*!< (@ 0x00000000) Enables and select the Memory Buck as the supply
                                                                    for the Flash and SRAM power domain.                       */
      __IOM uint32_t COREBUCKEN : 1;            /*!< (@ 0x00000001) Enables and Selects the Core Buck as the supply
                                                                    for the low-voltage power domain.                          */
    } SUPPLYSRC_b;
  } ;
  
  union {
    __IOM uint32_t SUPPLYSTATUS;                /*!< (@ 0x00000014) Memory and Core Voltage Supply Source Status
                                                                    Register                                                   */
    
    struct {
      __IOM uint32_t MEMBUCKON  : 1;            /*!< (@ 0x00000000) Indicate whether the Memory power domain is supplied
                                                                    from the LDO or the Buck.                                  */
      __IOM uint32_t COREBUCKON : 1;            /*!< (@ 0x00000001) Indicates whether the Core low-voltage domain
                                                                    is supplied from the LDO or the Buck.                      */
    } SUPPLYSTATUS_b;
  } ;
  __IM  uint32_t  RESERVED[57];
  
  union {
    __IOM uint32_t BANDGAPEN;                   /*!< (@ 0x000000FC) Band Gap Enable                                            */
    
    struct {
      __IOM uint32_t BGPEN      : 1;            /*!< (@ 0x00000000) Bandgap Enable                                             */
    } BANDGAPEN_b;
  } ;
  __IM  uint32_t  RESERVED1[16];
  
  union {
    __IOM uint32_t SRAMPWDINSLEEP;              /*!< (@ 0x00000140) Powerdown an SRAM Bank in Deep Sleep mode                  */
    
    struct {
      __IOM uint32_t BANK0      : 1;            /*!< (@ 0x00000000) Force SRAM Bank 0 to powerdown in deep sleep
                                                                    mode, causing the contents of the bank
                                                                    to be lost.                                                */
      __IOM uint32_t BANK1      : 1;            /*!< (@ 0x00000001) Force SRAM Bank 1 to powerdown in deep sleep
                                                                    mode, causing the contents of the bank
                                                                    to be lost.                                                */
      __IOM uint32_t BANK2      : 1;            /*!< (@ 0x00000002) Force SRAM Bank 2 to powerdown in deep sleep
                                                                    mode, causing the contents of the bank
                                                                    to be lost.                                                */
      __IOM uint32_t BANK3      : 1;            /*!< (@ 0x00000003) Force SRAM Bank 3 to powerdown in deep sleep
                                                                    mode, causing the contents of the bank
                                                                    to be lost.                                                */
      __IOM uint32_t BANK4      : 1;            /*!< (@ 0x00000004) Force SRAM Bank 4 to powerdown in deep sleep
                                                                    mode, causing the contents of the bank
                                                                    to be lost.                                                */
      __IOM uint32_t BANK5      : 1;            /*!< (@ 0x00000005) Force SRAM Bank 5 to powerdown in deep sleep
                                                                    mode, causing the contents of the bank
                                                                    to be lost.                                                */
      __IOM uint32_t BANK6      : 1;            /*!< (@ 0x00000006) Force SRAM Bank 6 to powerdown in deep sleep
                                                                    mode, causing the contents of the bank
                                                                    to be lost.                                                */
      __IOM uint32_t BANK7      : 1;            /*!< (@ 0x00000007) Force SRAM Bank 7 to powerdown in deep sleep
                                                                    mode, causing the contents of the bank
                                                                    to be lost.                                                */
    } SRAMPWDINSLEEP_b;
  } ;
  
  union {
    __IOM uint32_t SRAMPWRDIS;                  /*!< (@ 0x00000144) Disables individual banks of the SRAM array                */
    
    struct {
      __IOM uint32_t BANK0      : 1;            /*!< (@ 0x00000000) Remove power from SRAM Bank 0 which will cause
                                                                    an access to its address space to generate
                                                                    a Hard Fault.                                              */
      __IOM uint32_t BANK1      : 1;            /*!< (@ 0x00000001) Remove power from SRAM Bank 1 which will cause
                                                                    an access to its address space to generate
                                                                    a Hard Fault.                                              */
      __IOM uint32_t BANK2      : 1;            /*!< (@ 0x00000002) Remove power from SRAM Bank 2 which will cause
                                                                    an access to its address space to generate
                                                                    a Hard Fault.                                              */
      __IOM uint32_t BANK3      : 1;            /*!< (@ 0x00000003) Remove power from SRAM Bank 3 which will cause
                                                                    an access to its address space to generate
                                                                    a Hard Fault.                                              */
      __IOM uint32_t BANK4      : 1;            /*!< (@ 0x00000004) Remove power from SRAM Bank 4 which will cause
                                                                    an access to its address space to generate
                                                                    a Hard Fault.                                              */
      __IOM uint32_t BANK5      : 1;            /*!< (@ 0x00000005) Remove power from SRAM Bank 5 which will cause
                                                                    an access to its address space to generate
                                                                    a Hard Fault.                                              */
      __IOM uint32_t BANK6      : 1;            /*!< (@ 0x00000006) Remove power from SRAM Bank 6 which will cause
                                                                    an access to its address space to generate
                                                                    a Hard Fault.                                              */
      __IOM uint32_t BANK7      : 1;            /*!< (@ 0x00000007) Remove power from SRAM Bank 7 which will cause
                                                                    an access to its address space to generate
                                                                    a Hard Fault.                                              */
    } SRAMPWRDIS_b;
  } ;
  
  union {
    __IOM uint32_t FLASHPWRDIS;                 /*!< (@ 0x00000148) Disables individual banks of the Flash array               */
    
    struct {
      __IOM uint32_t BANK0      : 1;            /*!< (@ 0x00000000) Remove power from Flash Bank 0 which will cause
                                                                    an access to its address space to generate
                                                                    a Hard Fault.                                              */
      __IOM uint32_t BANK1      : 1;            /*!< (@ 0x00000001) Remove power from Flash Bank 1 which will cause
                                                                    an access to its address space to generate
                                                                    a Hard Fault.                                              */
    } FLASHPWRDIS_b;
  } ;
  __IM  uint32_t  RESERVED2[29];
  
  union {
    __IOM uint32_t ICODEFAULTADDR;              /*!< (@ 0x000001C0) ICODE bus address which was present when a bus
                                                                    fault occurred.                                            */
    
    struct {
      __IOM uint32_t ADDR       : 32;           /*!< (@ 0x00000000) The ICODE bus address observed when a Bus Fault
                                                                    occurred. Once an address is captured in
                                                                    this field, it is held until the corresponding
                                                                    Fault Observed bit is cleared in the FAULTSTATUS
                                                                    register.                                                  */
    } ICODEFAULTADDR_b;
  } ;
  
  union {
    __IOM uint32_t DCODEFAULTADDR;              /*!< (@ 0x000001C4) DCODE bus address which was present when a bus
                                                                    fault occurred.                                            */
    
    struct {
      __IOM uint32_t ADDR       : 32;           /*!< (@ 0x00000000) The DCODE bus address observed when a Bus Fault
                                                                    occurred. Once an address is captured in
                                                                    this field, it is held until the corresponding
                                                                    Fault Observed bit is cleared in the FAULTSTATUS
                                                                    register.                                                  */
    } DCODEFAULTADDR_b;
  } ;
  
  union {
    __IOM uint32_t SYSFAULTADDR;                /*!< (@ 0x000001C8) System bus address which was present when a bus
                                                                    fault occurred.                                            */
    
    struct {
      __IOM uint32_t ADDR       : 32;           /*!< (@ 0x00000000) SYS bus address observed when a Bus Fault occurred.
                                                                    Once an address is captured in this field,
                                                                    it is held until the corresponding Fault
                                                                    Observed bit is cleared in the FAULTSTATUS
                                                                    register.                                                  */
    } SYSFAULTADDR_b;
  } ;
  
  union {
    __IOM uint32_t FAULTSTATUS;                 /*!< (@ 0x000001CC) Reflects the status of the bus decoders' fault
                                                                    detection. Any write to this register will
                                                                    clear all of the status bits within the
                                                                    register.                                                  */
    
    struct {
      __IOM uint32_t ICODE      : 1;            /*!< (@ 0x00000000) The ICODE Bus Decoder Fault Detected bit. When
                                                                    set, a fault has been detected, and the
                                                                    ICODEFAULTADDR register will contain the
                                                                    bus address which generated the fault.                     */
      __IOM uint32_t DCODE      : 1;            /*!< (@ 0x00000001) DCODE Bus Decoder Fault Detected bit. When set,
                                                                    a fault has been detected, and the DCODEFAULTADDR
                                                                    register will contain the bus address which
                                                                    generated the fault.                                       */
      __IOM uint32_t SYS        : 1;            /*!< (@ 0x00000002) SYS Bus Decoder Fault Detected bit. When set,
                                                                    a fault has been detected, and the SYSFAULTADDR
                                                                    register will contain the bus address which
                                                                    generated the fault.                                       */
    } FAULTSTATUS_b;
  } ;
  
  union {
    __IOM uint32_t FAULTCAPTUREEN;              /*!< (@ 0x000001D0) Enable the fault capture registers                         */
    
    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< (@ 0x00000000) Fault Capture Enable field. When set, the Fault
                                                                    Capture monitors are enabled and addresses
                                                                    which generate a hard fault are captured
                                                                    into the FAULTADDR registers.                              */
    } FAULTCAPTUREEN_b;
  } ;
  __IM  uint32_t  RESERVED3[31];
  
  union {
    __IOM uint32_t TPIUCTRL;                    /*!< (@ 0x00000250) TPIU Control Register. Determines the clock enable
                                                                    and frequency for the M4's TPIU interface.                 */
    
    struct {
      __IOM uint32_t ENABLE     : 1;            /*!< (@ 0x00000000) TPIU Enable field. When set, the ARM M4 TPIU
                                                                    is enabled and data can be streamed out
                                                                    of the MCU's SWO port using the ARM ITM
                                                                    and TPIU modules.                                          */
      __IM  uint32_t            : 7;
      __IOM uint32_t CLKSEL     : 2;            /*!< (@ 0x00000008) This field selects the frequency of the ARM M4
                                                                    TPIU port.                                                 */
    } TPIUCTRL_b;
  } ;
} MCUCTRL_Type;                                 /*!< Size = 596 (0x254)                                                        */



/* =========================================================================================================================== */
/* ================                                          RSTGEN                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief MCU Reset Generator (RSTGEN)
  */

typedef struct {                                /*!< (@ 0x40000000) RSTGEN Structure                                           */
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */
    
    struct {
      __IOM uint32_t BODHREN    : 1;            /*!< (@ 0x00000000) Brown out high (2.1v) reset enable.                        */
      __IOM uint32_t WDREN      : 1;            /*!< (@ 0x00000001) Watchdog Timer Reset Enable. NOTE: The WDT module
                                                                    must also be configured for WDT reset.                     */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t SWPOI;                       /*!< (@ 0x00000004) Software POI Reset                                         */
    
    struct {
      __IOM uint32_t SWPOIKEY   : 8;            /*!< (@ 0x00000000) 0x1B generates a software POI reset.                       */
    } SWPOI_b;
  } ;
  
  union {
    __IOM uint32_t SWPOR;                       /*!< (@ 0x00000008) Software POR Reset                                         */
    
    struct {
      __IOM uint32_t SWPORKEY   : 8;            /*!< (@ 0x00000000) 0xD4 generates a software POR reset.                       */
    } SWPOR_b;
  } ;
  
  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x0000000C) Status Register                                            */
    
    struct {
      __IOM uint32_t EXRSTAT    : 1;            /*!< (@ 0x00000000) Reset was initiated by an External Reset.                  */
      __IOM uint32_t PORSTAT    : 1;            /*!< (@ 0x00000001) Reset was initiated by a Power-On Reset.                   */
      __IOM uint32_t BORSTAT    : 1;            /*!< (@ 0x00000002) Reset was initiated by a Brown-Out Reset.                  */
      __IOM uint32_t SWRSTAT    : 1;            /*!< (@ 0x00000003) Reset was a initiated by SW POR or AIRCR Reset.            */
      __IOM uint32_t POIRSTAT   : 1;            /*!< (@ 0x00000004) Reset was a initiated by Software POI Reset.               */
      __IOM uint32_t DBGRSTAT   : 1;            /*!< (@ 0x00000005) Reset was a initiated by Debugger Reset.                   */
      __IOM uint32_t WDRSTAT    : 1;            /*!< (@ 0x00000006) Reset was initiated by a Watchdog Timer Reset.             */
    } STAT_b;
  } ;
  
  union {
    __IOM uint32_t CLRSTAT;                     /*!< (@ 0x00000010) Clear the status register                                  */
    
    struct {
      __IOM uint32_t CLRSTAT    : 1;            /*!< (@ 0x00000000) Writing a 1 to this bit clears all bits in the
                                                                    RST_STAT.                                                  */
    } CLRSTAT_b;
  } ;
  __IM  uint32_t  RESERVED[123];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Reset Interrupt register: Enable                           */
    
    struct {
      __IOM uint32_t BODH       : 1;            /*!< (@ 0x00000000) Enables an interrupt that triggers when VCC is
                                                                    below BODH level.                                          */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Reset Interrupt register: Status                           */
    
    struct {
      __IOM uint32_t BODH       : 1;            /*!< (@ 0x00000000) Enables an interrupt that triggers when VCC is
                                                                    below BODH level.                                          */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Reset Interrupt register: Clear                            */
    
    struct {
      __IOM uint32_t BODH       : 1;            /*!< (@ 0x00000000) Enables an interrupt that triggers when VCC is
                                                                    below BODH level.                                          */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Reset Interrupt register: Set                              */
    
    struct {
      __IOM uint32_t BODH       : 1;            /*!< (@ 0x00000000) Enables an interrupt that triggers when VCC is
                                                                    below BODH level.                                          */
    } INTSET_b;
  } ;
} RSTGEN_Type;                                  /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                           UART                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Serial UART (UART)
  */

typedef struct {                                /*!< (@ 0x4001C000) UART Structure                                             */
  
  union {
    __IOM uint32_t DR;                          /*!< (@ 0x00000000) UART Data Register                                         */
    
    struct {
      __IOM uint32_t DATA       : 8;            /*!< (@ 0x00000000) This is the UART data port.                                */
      __IOM uint32_t FEDATA     : 1;            /*!< (@ 0x00000008) This is the framing error indicator.                       */
      __IOM uint32_t PEDATA     : 1;            /*!< (@ 0x00000009) This is the parity error indicator.                        */
      __IOM uint32_t BEDATA     : 1;            /*!< (@ 0x0000000A) This is the break error indicator.                         */
      __IOM uint32_t OEDATA     : 1;            /*!< (@ 0x0000000B) This is the overrun error indicator.                       */
    } DR_b;
  } ;
  
  union {
    __IOM uint32_t RSR;                         /*!< (@ 0x00000004) UART Status Register                                       */
    
    struct {
      __IOM uint32_t FESTAT     : 1;            /*!< (@ 0x00000000) This is the framing error indicator.                       */
      __IOM uint32_t PESTAT     : 1;            /*!< (@ 0x00000001) This is the parity error indicator.                        */
      __IOM uint32_t BESTAT     : 1;            /*!< (@ 0x00000002) This is the break error indicator.                         */
      __IOM uint32_t OESTAT     : 1;            /*!< (@ 0x00000003) This is the overrun error indicator.                       */
    } RSR_b;
  } ;
  __IM  uint32_t  RESERVED[4];
  
  union {
    __IOM uint32_t FR;                          /*!< (@ 0x00000018) Flag Register                                              */
    
    struct {
      __IOM uint32_t CTS        : 1;            /*!< (@ 0x00000000) This bit holds the clear to send indicator.                */
      __IOM uint32_t DSR        : 1;            /*!< (@ 0x00000001) This bit holds the data set ready indicator.               */
      __IOM uint32_t DCD        : 1;            /*!< (@ 0x00000002) This bit holds the data carrier detect indicator.          */
      __IOM uint32_t BUSY       : 1;            /*!< (@ 0x00000003) This bit holds the busy indicator.                         */
      __IOM uint32_t RXFE       : 1;            /*!< (@ 0x00000004) This bit holds the receive FIFO empty indicator.           */
      __IOM uint32_t TXFF       : 1;            /*!< (@ 0x00000005) This bit holds the transmit FIFO full indicator.           */
      __IOM uint32_t RXFF       : 1;            /*!< (@ 0x00000006) This bit holds the receive FIFO full indicator.            */
      __IOM uint32_t TXFE       : 1;            /*!< (@ 0x00000007) This bit holds the transmit FIFO empty indicator.          */
      __IOM uint32_t RI         : 1;            /*!< (@ 0x00000008) This bit holds the ring indicator.                         */
    } FR_b;
  } ;
  __IM  uint32_t  RESERVED1;
  
  union {
    __IOM uint32_t ILPR;                        /*!< (@ 0x00000020) IrDA Counter                                               */
    
    struct {
      __IOM uint32_t ILPDVSR    : 8;            /*!< (@ 0x00000000) These bits hold the IrDA counter divisor.                  */
    } ILPR_b;
  } ;
  
  union {
    __IOM uint32_t IBRD;                        /*!< (@ 0x00000024) Integer Baud Rate Divisor                                  */
    
    struct {
      __IOM uint32_t DIVINT     : 16;           /*!< (@ 0x00000000) These bits hold the baud integer divisor.                  */
    } IBRD_b;
  } ;
  
  union {
    __IOM uint32_t FBRD;                        /*!< (@ 0x00000028) Fractional Baud Rate Divisor                               */
    
    struct {
      __IOM uint32_t DIVFRAC    : 6;            /*!< (@ 0x00000000) These bits hold the baud fractional divisor.               */
    } FBRD_b;
  } ;
  
  union {
    __IOM uint32_t LCRH;                        /*!< (@ 0x0000002C) Line Control High                                          */
    
    struct {
      __IOM uint32_t BRK        : 1;            /*!< (@ 0x00000000) This bit holds the break set.                              */
      __IOM uint32_t PEN        : 1;            /*!< (@ 0x00000001) This bit holds the parity enable.                          */
      __IOM uint32_t EPS        : 1;            /*!< (@ 0x00000002) This bit holds the even parity select.                     */
      __IOM uint32_t STP2       : 1;            /*!< (@ 0x00000003) This bit holds the two stop bits select.                   */
      __IOM uint32_t FEN        : 1;            /*!< (@ 0x00000004) This bit holds the FIFO enable.                            */
      __IOM uint32_t WLEN       : 2;            /*!< (@ 0x00000005) These bits hold the write length.                          */
      __IOM uint32_t SPS        : 1;            /*!< (@ 0x00000007) This bit holds the stick parity select.                    */
    } LCRH_b;
  } ;
  
  union {
    __IOM uint32_t CR;                          /*!< (@ 0x00000030) Control Register                                           */
    
    struct {
      __IOM uint32_t UARTEN     : 1;            /*!< (@ 0x00000000) This bit is the UART enable.                               */
      __IOM uint32_t SIREN      : 1;            /*!< (@ 0x00000001) This bit is the SIR ENDEC enable.                          */
      __IOM uint32_t SIRLP      : 1;            /*!< (@ 0x00000002) This bit is the SIR low power select.                      */
      __IOM uint32_t CLKEN      : 1;            /*!< (@ 0x00000003) This bit is the UART clock enable.                         */
      __IOM uint32_t CLKSEL     : 3;            /*!< (@ 0x00000004) This bitfield is the UART clock select.                    */
      __IOM uint32_t LBE        : 1;            /*!< (@ 0x00000007) This bit is the loopback enable.                           */
      __IOM uint32_t TXE        : 1;            /*!< (@ 0x00000008) This bit is the transmit enable.                           */
      __IOM uint32_t RXE        : 1;            /*!< (@ 0x00000009) This bit is the receive enable.                            */
      __IOM uint32_t DTR        : 1;            /*!< (@ 0x0000000A) This bit enables data transmit ready.                      */
      __IOM uint32_t RTS        : 1;            /*!< (@ 0x0000000B) This bit enables request to send.                          */
      __IOM uint32_t OUT1       : 1;            /*!< (@ 0x0000000C) This bit holds modem Out1.                                 */
      __IOM uint32_t OUT2       : 1;            /*!< (@ 0x0000000D) This bit holds modem Out2.                                 */
      __IOM uint32_t RTSEN      : 1;            /*!< (@ 0x0000000E) This bit enables RTS hardware flow control.                */
      __IOM uint32_t CTSEN      : 1;            /*!< (@ 0x0000000F) This bit enables CTS hardware flow control.                */
    } CR_b;
  } ;
  
  union {
    __IOM uint32_t IFLS;                        /*!< (@ 0x00000034) FIFO Interrupt Level Select                                */
    
    struct {
      __IOM uint32_t TXIFLSEL   : 3;            /*!< (@ 0x00000000) These bits hold the transmit FIFO interrupt level.         */
      __IOM uint32_t RXIFLSEL   : 3;            /*!< (@ 0x00000003) These bits hold the receive FIFO interrupt level.          */
    } IFLS_b;
  } ;
  
  union {
    __IOM uint32_t IER;                         /*!< (@ 0x00000038) Interrupt Enable                                           */
    
    struct {
      __IOM uint32_t RIMIM      : 1;            /*!< (@ 0x00000000) This bit holds the modem RI interrupt enable.              */
      __IOM uint32_t CTSMIM     : 1;            /*!< (@ 0x00000001) This bit holds the modem CTS interrupt enable.             */
      __IOM uint32_t DCDMIM     : 1;            /*!< (@ 0x00000002) This bit holds the modem DCD interrupt enable.             */
      __IOM uint32_t DSRMIM     : 1;            /*!< (@ 0x00000003) This bit holds the modem DSR interrupt enable.             */
      __IOM uint32_t RXIM       : 1;            /*!< (@ 0x00000004) This bit holds the receive interrupt enable.               */
      __IOM uint32_t TXIM       : 1;            /*!< (@ 0x00000005) This bit holds the transmit interrupt enable.              */
      __IOM uint32_t RTIM       : 1;            /*!< (@ 0x00000006) This bit holds the receive timeout interrupt
                                                                    enable.                                                    */
      __IOM uint32_t FEIM       : 1;            /*!< (@ 0x00000007) This bit holds the framing error interrupt enable.         */
      __IOM uint32_t PEIM       : 1;            /*!< (@ 0x00000008) This bit holds the parity error interrupt enable.          */
      __IOM uint32_t BEIM       : 1;            /*!< (@ 0x00000009) This bit holds the break error interrupt enable.           */
      __IOM uint32_t OEIM       : 1;            /*!< (@ 0x0000000A) This bit holds the overflow interrupt enable.              */
    } IER_b;
  } ;
  
  union {
    __IOM uint32_t IES;                         /*!< (@ 0x0000003C) Interrupt Status                                           */
    
    struct {
      __IOM uint32_t RIMRIS     : 1;            /*!< (@ 0x00000000) This bit holds the modem RI interrupt status.              */
      __IOM uint32_t CTSMRIS    : 1;            /*!< (@ 0x00000001) This bit holds the modem CTS interrupt status.             */
      __IOM uint32_t DCDMRIS    : 1;            /*!< (@ 0x00000002) This bit holds the modem DCD interrupt status.             */
      __IOM uint32_t DSRMRIS    : 1;            /*!< (@ 0x00000003) This bit holds the modem DSR interrupt status.             */
      __IOM uint32_t RXRIS      : 1;            /*!< (@ 0x00000004) This bit holds the receive interrupt status.               */
      __IOM uint32_t TXRIS      : 1;            /*!< (@ 0x00000005) This bit holds the transmit interrupt status.              */
      __IOM uint32_t RTRIS      : 1;            /*!< (@ 0x00000006) This bit holds the receive timeout interrupt
                                                                    status.                                                    */
      __IOM uint32_t FERIS      : 1;            /*!< (@ 0x00000007) This bit holds the framing error interrupt status.         */
      __IOM uint32_t PERIS      : 1;            /*!< (@ 0x00000008) This bit holds the parity error interrupt status.          */
      __IOM uint32_t BERIS      : 1;            /*!< (@ 0x00000009) This bit holds the break error interrupt status.           */
      __IOM uint32_t OERIS      : 1;            /*!< (@ 0x0000000A) This bit holds the overflow interrupt status.              */
    } IES_b;
  } ;
  
  union {
    __IOM uint32_t MIS;                         /*!< (@ 0x00000040) Masked Interrupt Status                                    */
    
    struct {
      __IOM uint32_t RIMMIS     : 1;            /*!< (@ 0x00000000) This bit holds the modem RI interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t CTSMMIS    : 1;            /*!< (@ 0x00000001) This bit holds the modem CTS interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t DCDMMIS    : 1;            /*!< (@ 0x00000002) This bit holds the modem DCD interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t DSRMMIS    : 1;            /*!< (@ 0x00000003) This bit holds the modem DSR interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t RXMIS      : 1;            /*!< (@ 0x00000004) This bit holds the receive interrupt status masked.        */
      __IOM uint32_t TXMIS      : 1;            /*!< (@ 0x00000005) This bit holds the transmit interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t RTMIS      : 1;            /*!< (@ 0x00000006) This bit holds the receive timeout interrupt
                                                                    status masked.                                             */
      __IOM uint32_t FEMIS      : 1;            /*!< (@ 0x00000007) This bit holds the framing error interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t PEMIS      : 1;            /*!< (@ 0x00000008) This bit holds the parity error interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t BEMIS      : 1;            /*!< (@ 0x00000009) This bit holds the break error interrupt status
                                                                    masked.                                                    */
      __IOM uint32_t OEMIS      : 1;            /*!< (@ 0x0000000A) This bit holds the overflow interrupt status
                                                                    masked.                                                    */
    } MIS_b;
  } ;
  
  union {
    __IOM uint32_t IEC;                         /*!< (@ 0x00000044) Interrupt Clear                                            */
    
    struct {
      __IOM uint32_t RIMIC      : 1;            /*!< (@ 0x00000000) This bit holds the modem RI interrupt clear.               */
      __IOM uint32_t CTSMIC     : 1;            /*!< (@ 0x00000001) This bit holds the modem CTS interrupt clear.              */
      __IOM uint32_t DCDMIC     : 1;            /*!< (@ 0x00000002) This bit holds the modem DCD interrupt clear.              */
      __IOM uint32_t DSRMIC     : 1;            /*!< (@ 0x00000003) This bit holds the modem DSR interrupt clear.              */
      __IOM uint32_t RXIC       : 1;            /*!< (@ 0x00000004) This bit holds the receive interrupt clear.                */
      __IOM uint32_t TXIC       : 1;            /*!< (@ 0x00000005) This bit holds the transmit interrupt clear.               */
      __IOM uint32_t RTIC       : 1;            /*!< (@ 0x00000006) This bit holds the receive timeout interrupt
                                                                    clear.                                                     */
      __IOM uint32_t FEIC       : 1;            /*!< (@ 0x00000007) This bit holds the framing error interrupt clear.          */
      __IOM uint32_t PEIC       : 1;            /*!< (@ 0x00000008) This bit holds the parity error interrupt clear.           */
      __IOM uint32_t BEIC       : 1;            /*!< (@ 0x00000009) This bit holds the break error interrupt clear.            */
      __IOM uint32_t OEIC       : 1;            /*!< (@ 0x0000000A) This bit holds the overflow interrupt clear.               */
    } IEC_b;
  } ;
} UART_Type;                                    /*!< Size = 72 (0x48)                                                          */



/* =========================================================================================================================== */
/* ================                                           VCOMP                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Voltage Comparator (VCOMP)
  */

typedef struct {                                /*!< (@ 0x4000C000) VCOMP Structure                                            */
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */
    
    struct {
      __IOM uint32_t PSEL       : 2;            /*!< (@ 0x00000000) This bitfield selects the positive input to the
                                                                    comparator.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t NSEL       : 2;            /*!< (@ 0x00000008) This bitfield selects the negative input to the
                                                                    comparator.                                                */
      __IM  uint32_t            : 6;
      __IOM uint32_t LVLSEL     : 4;            /*!< (@ 0x00000010) When the reference input NSEL is set to NSEL_DAC,
                                                                    this bitfield selects the voltage level
                                                                    for the negative input to the comparator.                  */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t STAT;                        /*!< (@ 0x00000004) Status Register                                            */
    
    struct {
      __IOM uint32_t CMPOUT     : 1;            /*!< (@ 0x00000000) This bit is 1 if the positive input of the comparator
                                                                    is greater than the negative input.                        */
      __IOM uint32_t PWDSTAT    : 1;            /*!< (@ 0x00000001) This bit indicates the power down state of the
                                                                    voltage comparator.                                        */
    } STAT_b;
  } ;
  
  union {
    __IOM uint32_t PWDKEY;                      /*!< (@ 0x00000008) Key Register for Powering Down the Voltage Comparator      */
    
    struct {
      __IOM uint32_t PWDKEY     : 32;           /*!< (@ 0x00000000) Key register value.                                        */
    } PWDKEY_b;
  } ;
  __IM  uint32_t  RESERVED[125];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) Voltage Comparator Interrupt registers: Enable             */
    
    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< (@ 0x00000000) This bit is the vcompout low interrupt.                    */
      __IOM uint32_t OUTHI      : 1;            /*!< (@ 0x00000001) This bit is the vcompout high interrupt.                   */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) Voltage Comparator Interrupt registers: Status             */
    
    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< (@ 0x00000000) This bit is the vcompout low interrupt.                    */
      __IOM uint32_t OUTHI      : 1;            /*!< (@ 0x00000001) This bit is the vcompout high interrupt.                   */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) Voltage Comparator Interrupt registers: Clear              */
    
    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< (@ 0x00000000) This bit is the vcompout low interrupt.                    */
      __IOM uint32_t OUTHI      : 1;            /*!< (@ 0x00000001) This bit is the vcompout high interrupt.                   */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) Voltage Comparator Interrupt registers: Set                */
    
    struct {
      __IOM uint32_t OUTLOW     : 1;            /*!< (@ 0x00000000) This bit is the vcompout low interrupt.                    */
      __IOM uint32_t OUTHI      : 1;            /*!< (@ 0x00000001) This bit is the vcompout high interrupt.                   */
    } INTSET_b;
  } ;
} VCOMP_Type;                                   /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                            WDT                                            ================ */
/* =========================================================================================================================== */


/**
  * @brief Watchdog Timer (WDT)
  */

typedef struct {                                /*!< (@ 0x40024000) WDT Structure                                              */
  
  union {
    __IOM uint32_t CFG;                         /*!< (@ 0x00000000) Configuration Register                                     */
    
    struct {
      __IOM uint32_t WDTEN      : 1;            /*!< (@ 0x00000000) This bitfield enables the WDT.                             */
      __IOM uint32_t INTEN      : 1;            /*!< (@ 0x00000001) This bitfield enables the WDT interrupt. Note
                                                                    : This bit must be set before the interrupt
                                                                    status bit will reflect a watchdog timer
                                                                    expiration. The IER interrupt register
                                                                    must also be enabled for a WDT interrupt
                                                                    to be sent to the NVIC.                                    */
      __IOM uint32_t RESEN      : 1;            /*!< (@ 0x00000002) This bitfield enables the WDT reset.                       */
      __IM  uint32_t            : 5;
      __IOM uint32_t RESVAL     : 8;            /*!< (@ 0x00000008) This bitfield is the compare value for counter
                                                                    bits 7:0 to generate a watchdog reset.                     */
      __IOM uint32_t INTVAL     : 8;            /*!< (@ 0x00000010) This bitfield is the compare value for counter
                                                                    bits 7:0 to generate a watchdog interrupt.                 */
    } CFG_b;
  } ;
  
  union {
    __IOM uint32_t RSTRT;                       /*!< (@ 0x00000004) Restart the watchdog timer                                 */
    
    struct {
      __IOM uint32_t RSTRT      : 8;            /*!< (@ 0x00000000) Writing 0xB2 to WDTRSTRT restarts the watchdog
                                                                    timer.                                                     */
    } RSTRT_b;
  } ;
  
  union {
    __IOM uint32_t LOCK;                        /*!< (@ 0x00000008) Locks the WDT                                              */
    
    struct {
      __IOM uint32_t LOCK       : 8;            /*!< (@ 0x00000000) Writing 0x3A locks the watchdog timer. Once locked,
                                                                    the WDTCFG reg cannot be written and WDTEN
                                                                    is set.                                                    */
    } LOCK_b;
  } ;
  __IM  uint32_t  RESERVED[125];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000200) WDT Interrupt register: Enable                             */
    
    struct {
      __IOM uint32_t WDT        : 1;            /*!< (@ 0x00000000) Watchdog Timer Interrupt.                                  */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000204) WDT Interrupt register: Status                             */
    
    struct {
      __IOM uint32_t WDT        : 1;            /*!< (@ 0x00000000) Watchdog Timer Interrupt.                                  */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000208) WDT Interrupt register: Clear                              */
    
    struct {
      __IOM uint32_t WDT        : 1;            /*!< (@ 0x00000000) Watchdog Timer Interrupt.                                  */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000020C) WDT Interrupt register: Set                                */
    
    struct {
      __IOM uint32_t WDT        : 1;            /*!< (@ 0x00000000) Watchdog Timer Interrupt.                                  */
    } INTSET_b;
  } ;
} WDT_Type;                                     /*!< Size = 528 (0x210)                                                        */



/* =========================================================================================================================== */
/* ================                                          CLKGEN                                           ================ */
/* =========================================================================================================================== */


/**
  * @brief Clock Generator (CLKGEN)
  */

typedef struct {                                /*!< (@ 0x40004000) CLKGEN Structure                                           */
  
  union {
    __IOM uint32_t CALXT;                       /*!< (@ 0x00000000) XT Oscillator Control                                      */
    
    struct {
      __IOM uint32_t CALXT      : 11;           /*!< (@ 0x00000000) XT Oscillator calibration value                            */
    } CALXT_b;
  } ;
  
  union {
    __IOM uint32_t CALRC;                       /*!< (@ 0x00000004) RC Oscillator Control                                      */
    
    struct {
      __IOM uint32_t CALRC      : 18;           /*!< (@ 0x00000000) LFRC Oscillator calibration value                          */
    } CALRC_b;
  } ;
  
  union {
    __IOM uint32_t ACALCTR;                     /*!< (@ 0x00000008) Autocalibration Counter                                    */
    
    struct {
      __IOM uint32_t ACALCTR    : 24;           /*!< (@ 0x00000000) Autocalibration Counter result.                            */
    } ACALCTR_b;
  } ;
  
  union {
    __IOM uint32_t OCTRL;                       /*!< (@ 0x0000000C) Oscillator Control                                         */
    
    struct {
      __IOM uint32_t STOPXT     : 1;            /*!< (@ 0x00000000) Stop the XT Oscillator to the RTC                          */
      __IOM uint32_t STOPRC     : 1;            /*!< (@ 0x00000001) Stop the LFRC Oscillator to the RTC                        */
      __IM  uint32_t            : 4;
      __IOM uint32_t FOS        : 1;            /*!< (@ 0x00000006) Oscillator switch on failure function                      */
      __IOM uint32_t OSEL       : 1;            /*!< (@ 0x00000007) Selects the RTC oscillator (1 => LFRC, 0 => XT)            */
      __IOM uint32_t ACAL       : 3;            /*!< (@ 0x00000008) Autocalibration control                                    */
    } OCTRL_b;
  } ;
  
  union {
    __IOM uint32_t CLKOUT;                      /*!< (@ 0x00000010) CLKOUT Frequency Select                                    */
    
    struct {
      __IOM uint32_t CKSEL      : 6;            /*!< (@ 0x00000000) CLKOUT signal select                                       */
      __IM  uint32_t            : 1;
      __IOM uint32_t CKEN       : 1;            /*!< (@ 0x00000007) Enable the CLKOUT signal                                   */
    } CLKOUT_b;
  } ;
  
  union {
    __IOM uint32_t CLKKEY;                      /*!< (@ 0x00000014) Key Register for Clock Control Register                    */
    
    struct {
      __IOM uint32_t CLKKEY     : 32;           /*!< (@ 0x00000000) Key register value.                                        */
    } CLKKEY_b;
  } ;
  
  union {
    __IOM uint32_t CCTRL;                       /*!< (@ 0x00000018) HFRC Clock Control                                         */
    
    struct {
      __IOM uint32_t CORESEL    : 3;            /*!< (@ 0x00000000) Core Clock divisor                                         */
      __IOM uint32_t MEMSEL     : 1;            /*!< (@ 0x00000003) Flash Clock divisor                                        */
    } CCTRL_b;
  } ;
  
  union {
    __IOM uint32_t STATUS;                      /*!< (@ 0x0000001C) Clock Generator Status                                     */
    
    struct {
      __IOM uint32_t OMODE      : 1;            /*!< (@ 0x00000000) Current RTC oscillator (1 => LFRC, 0 => XT)                */
      __IOM uint32_t OSCF       : 1;            /*!< (@ 0x00000001) XT Oscillator is enabled but not oscillating               */
    } STATUS_b;
  } ;
  
  union {
    __IOM uint32_t HFADJ;                       /*!< (@ 0x00000020) HFRC Adjustment                                            */
    
    struct {
      __IOM uint32_t HFADJEN    : 1;            /*!< (@ 0x00000000) HFRC adjustment control                                    */
      __IOM uint32_t HFADJCK    : 3;            /*!< (@ 0x00000001) Repeat period for HFRC adjustment                          */
      __IM  uint32_t            : 4;
      __IOM uint32_t HFXTADJ    : 11;           /*!< (@ 0x00000008) Target HFRC adjustment value.                              */
      __IOM uint32_t HFWARMUP   : 1;            /*!< (@ 0x00000013) XT warmup period for HFRC adjustment                       */
    } HFADJ_b;
  } ;
  
  union {
    __IOM uint32_t HFVAL;                       /*!< (@ 0x00000024) HFADJ readback                                             */
    
    struct {
      __IOM uint32_t HFTUNERB   : 11;           /*!< (@ 0x00000000) Current HFTUNE value                                       */
    } HFVAL_b;
  } ;
  
  union {
    __IOM uint32_t CLOCKEN;                     /*!< (@ 0x00000028) Clock Enable Status                                        */
    
    struct {
      __IOM uint32_t CLOCKEN    : 32;           /*!< (@ 0x00000000) Clock enable status                                        */
    } CLOCKEN_b;
  } ;
  
  union {
    __IOM uint32_t UARTEN;                      /*!< (@ 0x0000002C) UART Enable                                                */
    
    struct {
      __IOM uint32_t UARTEN     : 1;            /*!< (@ 0x00000000) UART system clock control                                  */
    } UARTEN_b;
  } ;
  __IM  uint32_t  RESERVED[4];
  
  union {
    __IOM uint32_t CTRLOW;                      /*!< (@ 0x00000040) RTC Counters Lower                                         */
    
    struct {
      __IOM uint32_t CTR100     : 8;            /*!< (@ 0x00000000) 100ths of a second Counter                                 */
      __IOM uint32_t CTRSEC     : 7;            /*!< (@ 0x00000008) Seconds Counter                                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTRMIN     : 7;            /*!< (@ 0x00000010) Minutes Counter                                            */
      __IM  uint32_t            : 1;
      __IOM uint32_t CTRHR      : 6;            /*!< (@ 0x00000018) Hours Counter                                              */
    } CTRLOW_b;
  } ;
  
  union {
    __IOM uint32_t CTRUP;                       /*!< (@ 0x00000044) RTC Counters Upper                                         */
    
    struct {
      __IOM uint32_t CTRDATE    : 6;            /*!< (@ 0x00000000) Date Counter                                               */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTRMO      : 5;            /*!< (@ 0x00000008) Months Counter                                             */
      __IM  uint32_t            : 3;
      __IOM uint32_t CTRYR      : 8;            /*!< (@ 0x00000010) Years Counter                                              */
      __IOM uint32_t CTRWKDY    : 3;            /*!< (@ 0x00000018) Weekdays Counter                                           */
      __IOM uint32_t CB         : 1;            /*!< (@ 0x0000001B) Century                                                    */
      __IOM uint32_t CEB        : 1;            /*!< (@ 0x0000001C) Century enable                                             */
      __IM  uint32_t            : 2;
      __IOM uint32_t CTERR      : 1;            /*!< (@ 0x0000001F) Counter read error status                                  */
    } CTRUP_b;
  } ;
  
  union {
    __IOM uint32_t ALMLOW;                      /*!< (@ 0x00000048) RTC Alarms Lower                                           */
    
    struct {
      __IOM uint32_t ALM100     : 8;            /*!< (@ 0x00000000) 100ths of a second Alarm                                   */
      __IOM uint32_t ALMSEC     : 7;            /*!< (@ 0x00000008) Seconds Alarm                                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t ALMMIN     : 7;            /*!< (@ 0x00000010) Minutes Alarm                                              */
      __IM  uint32_t            : 1;
      __IOM uint32_t ALMHR      : 6;            /*!< (@ 0x00000018) Hours Alarm                                                */
    } ALMLOW_b;
  } ;
  
  union {
    __IOM uint32_t ALMUP;                       /*!< (@ 0x0000004C) RTC Alarms Upper                                           */
    
    struct {
      __IOM uint32_t ALMDATE    : 6;            /*!< (@ 0x00000000) Date Alarm                                                 */
      __IM  uint32_t            : 2;
      __IOM uint32_t ALMMO      : 5;            /*!< (@ 0x00000008) Months Alarm                                               */
      __IM  uint32_t            : 3;
      __IOM uint32_t ALMWKDY    : 3;            /*!< (@ 0x00000010) Weekdays Alarm                                             */
    } ALMUP_b;
  } ;
  
  union {
    __IOM uint32_t RTCCTL;                      /*!< (@ 0x00000050) RTC Control Register                                       */
    
    struct {
      __IOM uint32_t WRTC       : 1;            /*!< (@ 0x00000000) Counter write control                                      */
      __IOM uint32_t RPT        : 3;            /*!< (@ 0x00000001) Alarm repeat interval                                      */
      __IOM uint32_t RSTOP      : 1;            /*!< (@ 0x00000004) RTC input clock control                                    */
      __IOM uint32_t HR1224     : 1;            /*!< (@ 0x00000005) Hours Counter mode                                         */
    } RTCCTL_b;
  } ;
  __IM  uint32_t  RESERVED1[43];
  
  union {
    __IOM uint32_t INTEN;                       /*!< (@ 0x00000100) CLKGEN Interrupt Register: Enable                          */
    
    struct {
      __IOM uint32_t ACF        : 1;            /*!< (@ 0x00000000) Autocalibration Fail interrupt                             */
      __IOM uint32_t ACC        : 1;            /*!< (@ 0x00000001) Autocalibration Complete interrupt                         */
      __IOM uint32_t OF         : 1;            /*!< (@ 0x00000002) XT Oscillator Fail interrupt                               */
      __IOM uint32_t ALM        : 1;            /*!< (@ 0x00000003) RTC Alarm interrupt                                        */
    } INTEN_b;
  } ;
  
  union {
    __IOM uint32_t INTSTAT;                     /*!< (@ 0x00000104) CLKGEN Interrupt Register: Status                          */
    
    struct {
      __IOM uint32_t ACF        : 1;            /*!< (@ 0x00000000) Autocalibration Fail interrupt                             */
      __IOM uint32_t ACC        : 1;            /*!< (@ 0x00000001) Autocalibration Complete interrupt                         */
      __IOM uint32_t OF         : 1;            /*!< (@ 0x00000002) XT Oscillator Fail interrupt                               */
      __IOM uint32_t ALM        : 1;            /*!< (@ 0x00000003) RTC Alarm interrupt                                        */
    } INTSTAT_b;
  } ;
  
  union {
    __IOM uint32_t INTCLR;                      /*!< (@ 0x00000108) CLKGEN Interrupt Register: Clear                           */
    
    struct {
      __IOM uint32_t ACF        : 1;            /*!< (@ 0x00000000) Autocalibration Fail interrupt                             */
      __IOM uint32_t ACC        : 1;            /*!< (@ 0x00000001) Autocalibration Complete interrupt                         */
      __IOM uint32_t OF         : 1;            /*!< (@ 0x00000002) XT Oscillator Fail interrupt                               */
      __IOM uint32_t ALM        : 1;            /*!< (@ 0x00000003) RTC Alarm interrupt                                        */
    } INTCLR_b;
  } ;
  
  union {
    __IOM uint32_t INTSET;                      /*!< (@ 0x0000010C) CLKGEN Interrupt Register: Set                             */
    
    struct {
      __IOM uint32_t ACF        : 1;            /*!< (@ 0x00000000) Autocalibration Fail interrupt                             */
      __IOM uint32_t ACC        : 1;            /*!< (@ 0x00000001) Autocalibration Complete interrupt                         */
      __IOM uint32_t OF         : 1;            /*!< (@ 0x00000002) XT Oscillator Fail interrupt                               */
      __IOM uint32_t ALM        : 1;            /*!< (@ 0x00000003) RTC Alarm interrupt                                        */
    } INTSET_b;
  } ;
} CLKGEN_Type;                                  /*!< Size = 272 (0x110)                                                        */


/** @} */ /* End of group Device_Peripheral_peripherals */


/* =========================================  End of section using anonymous unions  ========================================= */
#if defined (__CC_ARM)
  #pragma pop
#elif defined (__ICCARM__)
  /* leave anonymous unions enabled */
#elif (__ARMCC_VERSION >= 6010050)
  #pragma clang diagnostic pop
#elif defined (__GNUC__)
  /* anonymous unions are enabled by default */
#elif defined (__TMS470__)
  /* anonymous unions are enabled by default */
#elif defined (__TASKING__)
  #pragma warning restore
#elif defined (__CSMC__)
  /* anonymous unions are enabled by default */
#endif


/* =========================================================================================================================== */
/* ================                          Device Specific Peripheral Address Map                           ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_peripheralAddr
  * @{
  */

#define ADC_BASE                    0x50008000UL
#define CTIMER_BASE                 0x40008000UL
#define GPIO_BASE                   0x40010000UL
#define IOMSTR0_BASE                0x50004000UL
#define IOMSTR1_BASE                0x50005000UL
#define IOSLAVE_BASE                0x50000000UL
#define MCUCTRL_BASE                0x40020000UL
#define RSTGEN_BASE                 0x40000000UL
#define UART_BASE                   0x4001C000UL
#define VCOMP_BASE                  0x4000C000UL
#define WDT_BASE                    0x40024000UL
#define CLKGEN_BASE                 0x40004000UL

/** @} */ /* End of group Device_Peripheral_peripheralAddr */


/* =========================================================================================================================== */
/* ================                                  Peripheral declaration                                   ================ */
/* =========================================================================================================================== */


/** @addtogroup Device_Peripheral_declaration
  * @{
  */

#define ADC                         ((ADC_Type*)               ADC_BASE)
#define CTIMER                      ((CTIMER_Type*)            CTIMER_BASE)
#define GPIO                        ((GPIO_Type*)              GPIO_BASE)
#define IOMSTR0                     ((IOMSTR0_Type*)           IOMSTR0_BASE)
#define IOMSTR1                     ((IOMSTR0_Type*)           IOMSTR1_BASE)
#define IOSLAVE                     ((IOSLAVE_Type*)           IOSLAVE_BASE)
#define MCUCTRL                     ((MCUCTRL_Type*)           MCUCTRL_BASE)
#define RSTGEN                      ((RSTGEN_Type*)            RSTGEN_BASE)
#define UART                        ((UART_Type*)              UART_BASE)
#define VCOMP                       ((VCOMP_Type*)             VCOMP_BASE)
#define WDT                         ((WDT_Type*)               WDT_BASE)
#define CLKGEN                      ((CLKGEN_Type*)            CLKGEN_BASE)

/** @} */ /* End of group Device_Peripheral_declaration */


/* =========================================================================================================================== */
/* ================                                Pos/Mask Peripheral Section                                ================ */
/* =========================================================================================================================== */


/** @addtogroup PosMask_peripherals
  * @{
  */



/* =========================================================================================================================== */
/* ================                                            ADC                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define ADC_CFG_CLKSEL_Pos                (24UL)                    /*!< ADC CFG: CLKSEL (Bit 24)                              */
#define ADC_CFG_CLKSEL_Msk                (0x7000000UL)             /*!< ADC CFG: CLKSEL (Bitfield-Mask: 0x07)                 */
#define ADC_CFG_TRIGPOL_Pos               (20UL)                    /*!< ADC CFG: TRIGPOL (Bit 20)                             */
#define ADC_CFG_TRIGPOL_Msk               (0x100000UL)              /*!< ADC CFG: TRIGPOL (Bitfield-Mask: 0x01)                */
#define ADC_CFG_TRIGSEL_Pos               (16UL)                    /*!< ADC CFG: TRIGSEL (Bit 16)                             */
#define ADC_CFG_TRIGSEL_Msk               (0xf0000UL)               /*!< ADC CFG: TRIGSEL (Bitfield-Mask: 0x0f)                */
#define ADC_CFG_REFSEL_Pos                (8UL)                     /*!< ADC CFG: REFSEL (Bit 8)                               */
#define ADC_CFG_REFSEL_Msk                (0x300UL)                 /*!< ADC CFG: REFSEL (Bitfield-Mask: 0x03)                 */
#define ADC_CFG_BATTLOAD_Pos              (7UL)                     /*!< ADC CFG: BATTLOAD (Bit 7)                             */
#define ADC_CFG_BATTLOAD_Msk              (0x80UL)                  /*!< ADC CFG: BATTLOAD (Bitfield-Mask: 0x01)               */
#define ADC_CFG_OPMODE_Pos                (5UL)                     /*!< ADC CFG: OPMODE (Bit 5)                               */
#define ADC_CFG_OPMODE_Msk                (0x60UL)                  /*!< ADC CFG: OPMODE (Bitfield-Mask: 0x03)                 */
#define ADC_CFG_LPMODE_Pos                (3UL)                     /*!< ADC CFG: LPMODE (Bit 3)                               */
#define ADC_CFG_LPMODE_Msk                (0x18UL)                  /*!< ADC CFG: LPMODE (Bitfield-Mask: 0x03)                 */
#define ADC_CFG_RPTEN_Pos                 (2UL)                     /*!< ADC CFG: RPTEN (Bit 2)                                */
#define ADC_CFG_RPTEN_Msk                 (0x4UL)                   /*!< ADC CFG: RPTEN (Bitfield-Mask: 0x01)                  */
#define ADC_CFG_TMPSPWR_Pos               (1UL)                     /*!< ADC CFG: TMPSPWR (Bit 1)                              */
#define ADC_CFG_TMPSPWR_Msk               (0x2UL)                   /*!< ADC CFG: TMPSPWR (Bitfield-Mask: 0x01)                */
#define ADC_CFG_ADCEN_Pos                 (0UL)                     /*!< ADC CFG: ADCEN (Bit 0)                                */
#define ADC_CFG_ADCEN_Msk                 (0x1UL)                   /*!< ADC CFG: ADCEN (Bitfield-Mask: 0x01)                  */
/* =========================================================  STAT  ========================================================== */
#define ADC_STAT_PWDSTAT_Pos              (0UL)                     /*!< ADC STAT: PWDSTAT (Bit 0)                             */
#define ADC_STAT_PWDSTAT_Msk              (0x3UL)                   /*!< ADC STAT: PWDSTAT (Bitfield-Mask: 0x03)               */
/* ==========================================================  SWT  ========================================================== */
#define ADC_SWT_SWT_Pos                   (0UL)                     /*!< ADC SWT: SWT (Bit 0)                                  */
#define ADC_SWT_SWT_Msk                   (0xffUL)                  /*!< ADC SWT: SWT (Bitfield-Mask: 0xff)                    */
/* ========================================================  SL0CFG  ========================================================= */
#define ADC_SL0CFG_ADSEL0_Pos             (24UL)                    /*!< ADC SL0CFG: ADSEL0 (Bit 24)                           */
#define ADC_SL0CFG_ADSEL0_Msk             (0x7000000UL)             /*!< ADC SL0CFG: ADSEL0 (Bitfield-Mask: 0x07)              */
#define ADC_SL0CFG_THSEL0_Pos             (16UL)                    /*!< ADC SL0CFG: THSEL0 (Bit 16)                           */
#define ADC_SL0CFG_THSEL0_Msk             (0x70000UL)               /*!< ADC SL0CFG: THSEL0 (Bitfield-Mask: 0x07)              */
#define ADC_SL0CFG_CHSEL0_Pos             (8UL)                     /*!< ADC SL0CFG: CHSEL0 (Bit 8)                            */
#define ADC_SL0CFG_CHSEL0_Msk             (0xf00UL)                 /*!< ADC SL0CFG: CHSEL0 (Bitfield-Mask: 0x0f)              */
#define ADC_SL0CFG_WCEN0_Pos              (1UL)                     /*!< ADC SL0CFG: WCEN0 (Bit 1)                             */
#define ADC_SL0CFG_WCEN0_Msk              (0x2UL)                   /*!< ADC SL0CFG: WCEN0 (Bitfield-Mask: 0x01)               */
#define ADC_SL0CFG_SLEN0_Pos              (0UL)                     /*!< ADC SL0CFG: SLEN0 (Bit 0)                             */
#define ADC_SL0CFG_SLEN0_Msk              (0x1UL)                   /*!< ADC SL0CFG: SLEN0 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL1CFG  ========================================================= */
#define ADC_SL1CFG_ADSEL1_Pos             (24UL)                    /*!< ADC SL1CFG: ADSEL1 (Bit 24)                           */
#define ADC_SL1CFG_ADSEL1_Msk             (0x7000000UL)             /*!< ADC SL1CFG: ADSEL1 (Bitfield-Mask: 0x07)              */
#define ADC_SL1CFG_THSEL1_Pos             (16UL)                    /*!< ADC SL1CFG: THSEL1 (Bit 16)                           */
#define ADC_SL1CFG_THSEL1_Msk             (0x70000UL)               /*!< ADC SL1CFG: THSEL1 (Bitfield-Mask: 0x07)              */
#define ADC_SL1CFG_CHSEL1_Pos             (8UL)                     /*!< ADC SL1CFG: CHSEL1 (Bit 8)                            */
#define ADC_SL1CFG_CHSEL1_Msk             (0xf00UL)                 /*!< ADC SL1CFG: CHSEL1 (Bitfield-Mask: 0x0f)              */
#define ADC_SL1CFG_WCEN1_Pos              (1UL)                     /*!< ADC SL1CFG: WCEN1 (Bit 1)                             */
#define ADC_SL1CFG_WCEN1_Msk              (0x2UL)                   /*!< ADC SL1CFG: WCEN1 (Bitfield-Mask: 0x01)               */
#define ADC_SL1CFG_SLEN1_Pos              (0UL)                     /*!< ADC SL1CFG: SLEN1 (Bit 0)                             */
#define ADC_SL1CFG_SLEN1_Msk              (0x1UL)                   /*!< ADC SL1CFG: SLEN1 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL2CFG  ========================================================= */
#define ADC_SL2CFG_ADSEL2_Pos             (24UL)                    /*!< ADC SL2CFG: ADSEL2 (Bit 24)                           */
#define ADC_SL2CFG_ADSEL2_Msk             (0x7000000UL)             /*!< ADC SL2CFG: ADSEL2 (Bitfield-Mask: 0x07)              */
#define ADC_SL2CFG_THSEL2_Pos             (16UL)                    /*!< ADC SL2CFG: THSEL2 (Bit 16)                           */
#define ADC_SL2CFG_THSEL2_Msk             (0x70000UL)               /*!< ADC SL2CFG: THSEL2 (Bitfield-Mask: 0x07)              */
#define ADC_SL2CFG_CHSEL2_Pos             (8UL)                     /*!< ADC SL2CFG: CHSEL2 (Bit 8)                            */
#define ADC_SL2CFG_CHSEL2_Msk             (0xf00UL)                 /*!< ADC SL2CFG: CHSEL2 (Bitfield-Mask: 0x0f)              */
#define ADC_SL2CFG_WCEN2_Pos              (1UL)                     /*!< ADC SL2CFG: WCEN2 (Bit 1)                             */
#define ADC_SL2CFG_WCEN2_Msk              (0x2UL)                   /*!< ADC SL2CFG: WCEN2 (Bitfield-Mask: 0x01)               */
#define ADC_SL2CFG_SLEN2_Pos              (0UL)                     /*!< ADC SL2CFG: SLEN2 (Bit 0)                             */
#define ADC_SL2CFG_SLEN2_Msk              (0x1UL)                   /*!< ADC SL2CFG: SLEN2 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL3CFG  ========================================================= */
#define ADC_SL3CFG_ADSEL3_Pos             (24UL)                    /*!< ADC SL3CFG: ADSEL3 (Bit 24)                           */
#define ADC_SL3CFG_ADSEL3_Msk             (0x7000000UL)             /*!< ADC SL3CFG: ADSEL3 (Bitfield-Mask: 0x07)              */
#define ADC_SL3CFG_THSEL3_Pos             (16UL)                    /*!< ADC SL3CFG: THSEL3 (Bit 16)                           */
#define ADC_SL3CFG_THSEL3_Msk             (0x70000UL)               /*!< ADC SL3CFG: THSEL3 (Bitfield-Mask: 0x07)              */
#define ADC_SL3CFG_CHSEL3_Pos             (8UL)                     /*!< ADC SL3CFG: CHSEL3 (Bit 8)                            */
#define ADC_SL3CFG_CHSEL3_Msk             (0xf00UL)                 /*!< ADC SL3CFG: CHSEL3 (Bitfield-Mask: 0x0f)              */
#define ADC_SL3CFG_WCEN3_Pos              (1UL)                     /*!< ADC SL3CFG: WCEN3 (Bit 1)                             */
#define ADC_SL3CFG_WCEN3_Msk              (0x2UL)                   /*!< ADC SL3CFG: WCEN3 (Bitfield-Mask: 0x01)               */
#define ADC_SL3CFG_SLEN3_Pos              (0UL)                     /*!< ADC SL3CFG: SLEN3 (Bit 0)                             */
#define ADC_SL3CFG_SLEN3_Msk              (0x1UL)                   /*!< ADC SL3CFG: SLEN3 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL4CFG  ========================================================= */
#define ADC_SL4CFG_ADSEL4_Pos             (24UL)                    /*!< ADC SL4CFG: ADSEL4 (Bit 24)                           */
#define ADC_SL4CFG_ADSEL4_Msk             (0x7000000UL)             /*!< ADC SL4CFG: ADSEL4 (Bitfield-Mask: 0x07)              */
#define ADC_SL4CFG_THSEL4_Pos             (16UL)                    /*!< ADC SL4CFG: THSEL4 (Bit 16)                           */
#define ADC_SL4CFG_THSEL4_Msk             (0x70000UL)               /*!< ADC SL4CFG: THSEL4 (Bitfield-Mask: 0x07)              */
#define ADC_SL4CFG_CHSEL4_Pos             (8UL)                     /*!< ADC SL4CFG: CHSEL4 (Bit 8)                            */
#define ADC_SL4CFG_CHSEL4_Msk             (0xf00UL)                 /*!< ADC SL4CFG: CHSEL4 (Bitfield-Mask: 0x0f)              */
#define ADC_SL4CFG_WCEN4_Pos              (1UL)                     /*!< ADC SL4CFG: WCEN4 (Bit 1)                             */
#define ADC_SL4CFG_WCEN4_Msk              (0x2UL)                   /*!< ADC SL4CFG: WCEN4 (Bitfield-Mask: 0x01)               */
#define ADC_SL4CFG_SLEN4_Pos              (0UL)                     /*!< ADC SL4CFG: SLEN4 (Bit 0)                             */
#define ADC_SL4CFG_SLEN4_Msk              (0x1UL)                   /*!< ADC SL4CFG: SLEN4 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL5CFG  ========================================================= */
#define ADC_SL5CFG_ADSEL5_Pos             (24UL)                    /*!< ADC SL5CFG: ADSEL5 (Bit 24)                           */
#define ADC_SL5CFG_ADSEL5_Msk             (0x7000000UL)             /*!< ADC SL5CFG: ADSEL5 (Bitfield-Mask: 0x07)              */
#define ADC_SL5CFG_THSEL5_Pos             (16UL)                    /*!< ADC SL5CFG: THSEL5 (Bit 16)                           */
#define ADC_SL5CFG_THSEL5_Msk             (0x70000UL)               /*!< ADC SL5CFG: THSEL5 (Bitfield-Mask: 0x07)              */
#define ADC_SL5CFG_CHSEL5_Pos             (8UL)                     /*!< ADC SL5CFG: CHSEL5 (Bit 8)                            */
#define ADC_SL5CFG_CHSEL5_Msk             (0xf00UL)                 /*!< ADC SL5CFG: CHSEL5 (Bitfield-Mask: 0x0f)              */
#define ADC_SL5CFG_WCEN5_Pos              (1UL)                     /*!< ADC SL5CFG: WCEN5 (Bit 1)                             */
#define ADC_SL5CFG_WCEN5_Msk              (0x2UL)                   /*!< ADC SL5CFG: WCEN5 (Bitfield-Mask: 0x01)               */
#define ADC_SL5CFG_SLEN5_Pos              (0UL)                     /*!< ADC SL5CFG: SLEN5 (Bit 0)                             */
#define ADC_SL5CFG_SLEN5_Msk              (0x1UL)                   /*!< ADC SL5CFG: SLEN5 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL6CFG  ========================================================= */
#define ADC_SL6CFG_ADSEL6_Pos             (24UL)                    /*!< ADC SL6CFG: ADSEL6 (Bit 24)                           */
#define ADC_SL6CFG_ADSEL6_Msk             (0x7000000UL)             /*!< ADC SL6CFG: ADSEL6 (Bitfield-Mask: 0x07)              */
#define ADC_SL6CFG_THSEL6_Pos             (16UL)                    /*!< ADC SL6CFG: THSEL6 (Bit 16)                           */
#define ADC_SL6CFG_THSEL6_Msk             (0x70000UL)               /*!< ADC SL6CFG: THSEL6 (Bitfield-Mask: 0x07)              */
#define ADC_SL6CFG_CHSEL6_Pos             (8UL)                     /*!< ADC SL6CFG: CHSEL6 (Bit 8)                            */
#define ADC_SL6CFG_CHSEL6_Msk             (0xf00UL)                 /*!< ADC SL6CFG: CHSEL6 (Bitfield-Mask: 0x0f)              */
#define ADC_SL6CFG_WCEN6_Pos              (1UL)                     /*!< ADC SL6CFG: WCEN6 (Bit 1)                             */
#define ADC_SL6CFG_WCEN6_Msk              (0x2UL)                   /*!< ADC SL6CFG: WCEN6 (Bitfield-Mask: 0x01)               */
#define ADC_SL6CFG_SLEN6_Pos              (0UL)                     /*!< ADC SL6CFG: SLEN6 (Bit 0)                             */
#define ADC_SL6CFG_SLEN6_Msk              (0x1UL)                   /*!< ADC SL6CFG: SLEN6 (Bitfield-Mask: 0x01)               */
/* ========================================================  SL7CFG  ========================================================= */
#define ADC_SL7CFG_ADSEL7_Pos             (24UL)                    /*!< ADC SL7CFG: ADSEL7 (Bit 24)                           */
#define ADC_SL7CFG_ADSEL7_Msk             (0x7000000UL)             /*!< ADC SL7CFG: ADSEL7 (Bitfield-Mask: 0x07)              */
#define ADC_SL7CFG_THSEL7_Pos             (16UL)                    /*!< ADC SL7CFG: THSEL7 (Bit 16)                           */
#define ADC_SL7CFG_THSEL7_Msk             (0x70000UL)               /*!< ADC SL7CFG: THSEL7 (Bitfield-Mask: 0x07)              */
#define ADC_SL7CFG_CHSEL7_Pos             (8UL)                     /*!< ADC SL7CFG: CHSEL7 (Bit 8)                            */
#define ADC_SL7CFG_CHSEL7_Msk             (0xf00UL)                 /*!< ADC SL7CFG: CHSEL7 (Bitfield-Mask: 0x0f)              */
#define ADC_SL7CFG_WCEN7_Pos              (1UL)                     /*!< ADC SL7CFG: WCEN7 (Bit 1)                             */
#define ADC_SL7CFG_WCEN7_Msk              (0x2UL)                   /*!< ADC SL7CFG: WCEN7 (Bitfield-Mask: 0x01)               */
#define ADC_SL7CFG_SLEN7_Pos              (0UL)                     /*!< ADC SL7CFG: SLEN7 (Bit 0)                             */
#define ADC_SL7CFG_SLEN7_Msk              (0x1UL)                   /*!< ADC SL7CFG: SLEN7 (Bitfield-Mask: 0x01)               */
/* =========================================================  WLIM  ========================================================== */
#define ADC_WLIM_ULIM_Pos                 (16UL)                    /*!< ADC WLIM: ULIM (Bit 16)                               */
#define ADC_WLIM_ULIM_Msk                 (0xffff0000UL)            /*!< ADC WLIM: ULIM (Bitfield-Mask: 0xffff)                */
#define ADC_WLIM_LLIM_Pos                 (0UL)                     /*!< ADC WLIM: LLIM (Bit 0)                                */
#define ADC_WLIM_LLIM_Msk                 (0xffffUL)                /*!< ADC WLIM: LLIM (Bitfield-Mask: 0xffff)                */
/* =========================================================  FIFO  ========================================================== */
#define ADC_FIFO_RSVD_27_Pos              (27UL)                    /*!< ADC FIFO: RSVD_27 (Bit 27)                            */
#define ADC_FIFO_RSVD_27_Msk              (0xf8000000UL)            /*!< ADC FIFO: RSVD_27 (Bitfield-Mask: 0x1f)               */
#define ADC_FIFO_SLOTNUM_Pos              (24UL)                    /*!< ADC FIFO: SLOTNUM (Bit 24)                            */
#define ADC_FIFO_SLOTNUM_Msk              (0x7000000UL)             /*!< ADC FIFO: SLOTNUM (Bitfield-Mask: 0x07)               */
#define ADC_FIFO_RSVD_20_Pos              (20UL)                    /*!< ADC FIFO: RSVD_20 (Bit 20)                            */
#define ADC_FIFO_RSVD_20_Msk              (0xf00000UL)              /*!< ADC FIFO: RSVD_20 (Bitfield-Mask: 0x0f)               */
#define ADC_FIFO_COUNT_Pos                (16UL)                    /*!< ADC FIFO: COUNT (Bit 16)                              */
#define ADC_FIFO_COUNT_Msk                (0xf0000UL)               /*!< ADC FIFO: COUNT (Bitfield-Mask: 0x0f)                 */
#define ADC_FIFO_DATA_Pos                 (0UL)                     /*!< ADC FIFO: DATA (Bit 0)                                */
#define ADC_FIFO_DATA_Msk                 (0xffffUL)                /*!< ADC FIFO: DATA (Bitfield-Mask: 0xffff)                */
/* =========================================================  INTEN  ========================================================= */
#define ADC_INTEN_WCINC_Pos               (5UL)                     /*!< ADC INTEN: WCINC (Bit 5)                              */
#define ADC_INTEN_WCINC_Msk               (0x20UL)                  /*!< ADC INTEN: WCINC (Bitfield-Mask: 0x01)                */
#define ADC_INTEN_WCEXC_Pos               (4UL)                     /*!< ADC INTEN: WCEXC (Bit 4)                              */
#define ADC_INTEN_WCEXC_Msk               (0x10UL)                  /*!< ADC INTEN: WCEXC (Bitfield-Mask: 0x01)                */
#define ADC_INTEN_FIFOOVR2_Pos            (3UL)                     /*!< ADC INTEN: FIFOOVR2 (Bit 3)                           */
#define ADC_INTEN_FIFOOVR2_Msk            (0x8UL)                   /*!< ADC INTEN: FIFOOVR2 (Bitfield-Mask: 0x01)             */
#define ADC_INTEN_FIFOOVR1_Pos            (2UL)                     /*!< ADC INTEN: FIFOOVR1 (Bit 2)                           */
#define ADC_INTEN_FIFOOVR1_Msk            (0x4UL)                   /*!< ADC INTEN: FIFOOVR1 (Bitfield-Mask: 0x01)             */
#define ADC_INTEN_SCNCMP_Pos              (1UL)                     /*!< ADC INTEN: SCNCMP (Bit 1)                             */
#define ADC_INTEN_SCNCMP_Msk              (0x2UL)                   /*!< ADC INTEN: SCNCMP (Bitfield-Mask: 0x01)               */
#define ADC_INTEN_CNVCMP_Pos              (0UL)                     /*!< ADC INTEN: CNVCMP (Bit 0)                             */
#define ADC_INTEN_CNVCMP_Msk              (0x1UL)                   /*!< ADC INTEN: CNVCMP (Bitfield-Mask: 0x01)               */
/* ========================================================  INTSTAT  ======================================================== */
#define ADC_INTSTAT_WCINC_Pos             (5UL)                     /*!< ADC INTSTAT: WCINC (Bit 5)                            */
#define ADC_INTSTAT_WCINC_Msk             (0x20UL)                  /*!< ADC INTSTAT: WCINC (Bitfield-Mask: 0x01)              */
#define ADC_INTSTAT_WCEXC_Pos             (4UL)                     /*!< ADC INTSTAT: WCEXC (Bit 4)                            */
#define ADC_INTSTAT_WCEXC_Msk             (0x10UL)                  /*!< ADC INTSTAT: WCEXC (Bitfield-Mask: 0x01)              */
#define ADC_INTSTAT_FIFOOVR2_Pos          (3UL)                     /*!< ADC INTSTAT: FIFOOVR2 (Bit 3)                         */
#define ADC_INTSTAT_FIFOOVR2_Msk          (0x8UL)                   /*!< ADC INTSTAT: FIFOOVR2 (Bitfield-Mask: 0x01)           */
#define ADC_INTSTAT_FIFOOVR1_Pos          (2UL)                     /*!< ADC INTSTAT: FIFOOVR1 (Bit 2)                         */
#define ADC_INTSTAT_FIFOOVR1_Msk          (0x4UL)                   /*!< ADC INTSTAT: FIFOOVR1 (Bitfield-Mask: 0x01)           */
#define ADC_INTSTAT_SCNCMP_Pos            (1UL)                     /*!< ADC INTSTAT: SCNCMP (Bit 1)                           */
#define ADC_INTSTAT_SCNCMP_Msk            (0x2UL)                   /*!< ADC INTSTAT: SCNCMP (Bitfield-Mask: 0x01)             */
#define ADC_INTSTAT_CNVCMP_Pos            (0UL)                     /*!< ADC INTSTAT: CNVCMP (Bit 0)                           */
#define ADC_INTSTAT_CNVCMP_Msk            (0x1UL)                   /*!< ADC INTSTAT: CNVCMP (Bitfield-Mask: 0x01)             */
/* ========================================================  INTCLR  ========================================================= */
#define ADC_INTCLR_WCINC_Pos              (5UL)                     /*!< ADC INTCLR: WCINC (Bit 5)                             */
#define ADC_INTCLR_WCINC_Msk              (0x20UL)                  /*!< ADC INTCLR: WCINC (Bitfield-Mask: 0x01)               */
#define ADC_INTCLR_WCEXC_Pos              (4UL)                     /*!< ADC INTCLR: WCEXC (Bit 4)                             */
#define ADC_INTCLR_WCEXC_Msk              (0x10UL)                  /*!< ADC INTCLR: WCEXC (Bitfield-Mask: 0x01)               */
#define ADC_INTCLR_FIFOOVR2_Pos           (3UL)                     /*!< ADC INTCLR: FIFOOVR2 (Bit 3)                          */
#define ADC_INTCLR_FIFOOVR2_Msk           (0x8UL)                   /*!< ADC INTCLR: FIFOOVR2 (Bitfield-Mask: 0x01)            */
#define ADC_INTCLR_FIFOOVR1_Pos           (2UL)                     /*!< ADC INTCLR: FIFOOVR1 (Bit 2)                          */
#define ADC_INTCLR_FIFOOVR1_Msk           (0x4UL)                   /*!< ADC INTCLR: FIFOOVR1 (Bitfield-Mask: 0x01)            */
#define ADC_INTCLR_SCNCMP_Pos             (1UL)                     /*!< ADC INTCLR: SCNCMP (Bit 1)                            */
#define ADC_INTCLR_SCNCMP_Msk             (0x2UL)                   /*!< ADC INTCLR: SCNCMP (Bitfield-Mask: 0x01)              */
#define ADC_INTCLR_CNVCMP_Pos             (0UL)                     /*!< ADC INTCLR: CNVCMP (Bit 0)                            */
#define ADC_INTCLR_CNVCMP_Msk             (0x1UL)                   /*!< ADC INTCLR: CNVCMP (Bitfield-Mask: 0x01)              */
/* ========================================================  INTSET  ========================================================= */
#define ADC_INTSET_WCINC_Pos              (5UL)                     /*!< ADC INTSET: WCINC (Bit 5)                             */
#define ADC_INTSET_WCINC_Msk              (0x20UL)                  /*!< ADC INTSET: WCINC (Bitfield-Mask: 0x01)               */
#define ADC_INTSET_WCEXC_Pos              (4UL)                     /*!< ADC INTSET: WCEXC (Bit 4)                             */
#define ADC_INTSET_WCEXC_Msk              (0x10UL)                  /*!< ADC INTSET: WCEXC (Bitfield-Mask: 0x01)               */
#define ADC_INTSET_FIFOOVR2_Pos           (3UL)                     /*!< ADC INTSET: FIFOOVR2 (Bit 3)                          */
#define ADC_INTSET_FIFOOVR2_Msk           (0x8UL)                   /*!< ADC INTSET: FIFOOVR2 (Bitfield-Mask: 0x01)            */
#define ADC_INTSET_FIFOOVR1_Pos           (2UL)                     /*!< ADC INTSET: FIFOOVR1 (Bit 2)                          */
#define ADC_INTSET_FIFOOVR1_Msk           (0x4UL)                   /*!< ADC INTSET: FIFOOVR1 (Bitfield-Mask: 0x01)            */
#define ADC_INTSET_SCNCMP_Pos             (1UL)                     /*!< ADC INTSET: SCNCMP (Bit 1)                            */
#define ADC_INTSET_SCNCMP_Msk             (0x2UL)                   /*!< ADC INTSET: SCNCMP (Bitfield-Mask: 0x01)              */
#define ADC_INTSET_CNVCMP_Pos             (0UL)                     /*!< ADC INTSET: CNVCMP (Bit 0)                            */
#define ADC_INTSET_CNVCMP_Msk             (0x1UL)                   /*!< ADC INTSET: CNVCMP (Bitfield-Mask: 0x01)              */


/* =========================================================================================================================== */
/* ================                                          CTIMER                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  TMR0  ========================================================== */
#define CTIMER_TMR0_CTTMRB0_Pos           (16UL)                    /*!< CTIMER TMR0: CTTMRB0 (Bit 16)                         */
#define CTIMER_TMR0_CTTMRB0_Msk           (0xffff0000UL)            /*!< CTIMER TMR0: CTTMRB0 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR0_CTTMRA0_Pos           (0UL)                     /*!< CTIMER TMR0: CTTMRA0 (Bit 0)                          */
#define CTIMER_TMR0_CTTMRA0_Msk           (0xffffUL)                /*!< CTIMER TMR0: CTTMRA0 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA0  ========================================================= */
#define CTIMER_CMPRA0_CMPR1A0_Pos         (16UL)                    /*!< CTIMER CMPRA0: CMPR1A0 (Bit 16)                       */
#define CTIMER_CMPRA0_CMPR1A0_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA0: CMPR1A0 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA0_CMPR0A0_Pos         (0UL)                     /*!< CTIMER CMPRA0: CMPR0A0 (Bit 0)                        */
#define CTIMER_CMPRA0_CMPR0A0_Msk         (0xffffUL)                /*!< CTIMER CMPRA0: CMPR0A0 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB0  ========================================================= */
#define CTIMER_CMPRB0_CMPR1B0_Pos         (16UL)                    /*!< CTIMER CMPRB0: CMPR1B0 (Bit 16)                       */
#define CTIMER_CMPRB0_CMPR1B0_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB0: CMPR1B0 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB0_CMPR0B0_Pos         (0UL)                     /*!< CTIMER CMPRB0: CMPR0B0 (Bit 0)                        */
#define CTIMER_CMPRB0_CMPR0B0_Msk         (0xffffUL)                /*!< CTIMER CMPRB0: CMPR0B0 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL0  ========================================================= */
#define CTIMER_CTRL0_CTLINK0_Pos          (31UL)                    /*!< CTIMER CTRL0: CTLINK0 (Bit 31)                        */
#define CTIMER_CTRL0_CTLINK0_Msk          (0x80000000UL)            /*!< CTIMER CTRL0: CTLINK0 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL0_TMRB0POL_Pos         (28UL)                    /*!< CTIMER CTRL0: TMRB0POL (Bit 28)                       */
#define CTIMER_CTRL0_TMRB0POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL0: TMRB0POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRB0CLR_Pos         (27UL)                    /*!< CTIMER CTRL0: TMRB0CLR (Bit 27)                       */
#define CTIMER_CTRL0_TMRB0CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL0: TMRB0CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRB0PE_Pos          (26UL)                    /*!< CTIMER CTRL0: TMRB0PE (Bit 26)                        */
#define CTIMER_CTRL0_TMRB0PE_Msk          (0x4000000UL)             /*!< CTIMER CTRL0: TMRB0PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL0_TMRB0IE_Pos          (25UL)                    /*!< CTIMER CTRL0: TMRB0IE (Bit 25)                        */
#define CTIMER_CTRL0_TMRB0IE_Msk          (0x2000000UL)             /*!< CTIMER CTRL0: TMRB0IE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL0_TMRB0FN_Pos          (22UL)                    /*!< CTIMER CTRL0: TMRB0FN (Bit 22)                        */
#define CTIMER_CTRL0_TMRB0FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL0: TMRB0FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL0_TMRB0CLK_Pos         (17UL)                    /*!< CTIMER CTRL0: TMRB0CLK (Bit 17)                       */
#define CTIMER_CTRL0_TMRB0CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL0: TMRB0CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL0_TMRB0EN_Pos          (16UL)                    /*!< CTIMER CTRL0: TMRB0EN (Bit 16)                        */
#define CTIMER_CTRL0_TMRB0EN_Msk          (0x10000UL)               /*!< CTIMER CTRL0: TMRB0EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL0_TMRA0POL_Pos         (12UL)                    /*!< CTIMER CTRL0: TMRA0POL (Bit 12)                       */
#define CTIMER_CTRL0_TMRA0POL_Msk         (0x1000UL)                /*!< CTIMER CTRL0: TMRA0POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRA0CLR_Pos         (11UL)                    /*!< CTIMER CTRL0: TMRA0CLR (Bit 11)                       */
#define CTIMER_CTRL0_TMRA0CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL0: TMRA0CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL0_TMRA0PE_Pos          (10UL)                    /*!< CTIMER CTRL0: TMRA0PE (Bit 10)                        */
#define CTIMER_CTRL0_TMRA0PE_Msk          (0x400UL)                 /*!< CTIMER CTRL0: TMRA0PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL0_TMRA0IE_Pos          (9UL)                     /*!< CTIMER CTRL0: TMRA0IE (Bit 9)                         */
#define CTIMER_CTRL0_TMRA0IE_Msk          (0x200UL)                 /*!< CTIMER CTRL0: TMRA0IE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL0_TMRA0FN_Pos          (6UL)                     /*!< CTIMER CTRL0: TMRA0FN (Bit 6)                         */
#define CTIMER_CTRL0_TMRA0FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL0: TMRA0FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL0_TMRA0CLK_Pos         (1UL)                     /*!< CTIMER CTRL0: TMRA0CLK (Bit 1)                        */
#define CTIMER_CTRL0_TMRA0CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL0: TMRA0CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL0_TMRA0EN_Pos          (0UL)                     /*!< CTIMER CTRL0: TMRA0EN (Bit 0)                         */
#define CTIMER_CTRL0_TMRA0EN_Msk          (0x1UL)                   /*!< CTIMER CTRL0: TMRA0EN (Bitfield-Mask: 0x01)           */
/* =========================================================  TMR1  ========================================================== */
#define CTIMER_TMR1_CTTMRB1_Pos           (16UL)                    /*!< CTIMER TMR1: CTTMRB1 (Bit 16)                         */
#define CTIMER_TMR1_CTTMRB1_Msk           (0xffff0000UL)            /*!< CTIMER TMR1: CTTMRB1 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR1_CTTMRA1_Pos           (0UL)                     /*!< CTIMER TMR1: CTTMRA1 (Bit 0)                          */
#define CTIMER_TMR1_CTTMRA1_Msk           (0xffffUL)                /*!< CTIMER TMR1: CTTMRA1 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA1  ========================================================= */
#define CTIMER_CMPRA1_CMPR1A1_Pos         (16UL)                    /*!< CTIMER CMPRA1: CMPR1A1 (Bit 16)                       */
#define CTIMER_CMPRA1_CMPR1A1_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA1: CMPR1A1 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA1_CMPR0A1_Pos         (0UL)                     /*!< CTIMER CMPRA1: CMPR0A1 (Bit 0)                        */
#define CTIMER_CMPRA1_CMPR0A1_Msk         (0xffffUL)                /*!< CTIMER CMPRA1: CMPR0A1 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB1  ========================================================= */
#define CTIMER_CMPRB1_CMPR1B1_Pos         (16UL)                    /*!< CTIMER CMPRB1: CMPR1B1 (Bit 16)                       */
#define CTIMER_CMPRB1_CMPR1B1_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB1: CMPR1B1 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB1_CMPR0B1_Pos         (0UL)                     /*!< CTIMER CMPRB1: CMPR0B1 (Bit 0)                        */
#define CTIMER_CMPRB1_CMPR0B1_Msk         (0xffffUL)                /*!< CTIMER CMPRB1: CMPR0B1 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL1  ========================================================= */
#define CTIMER_CTRL1_CTLINK1_Pos          (31UL)                    /*!< CTIMER CTRL1: CTLINK1 (Bit 31)                        */
#define CTIMER_CTRL1_CTLINK1_Msk          (0x80000000UL)            /*!< CTIMER CTRL1: CTLINK1 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL1_TMRB1POL_Pos         (28UL)                    /*!< CTIMER CTRL1: TMRB1POL (Bit 28)                       */
#define CTIMER_CTRL1_TMRB1POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL1: TMRB1POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRB1CLR_Pos         (27UL)                    /*!< CTIMER CTRL1: TMRB1CLR (Bit 27)                       */
#define CTIMER_CTRL1_TMRB1CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL1: TMRB1CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRB1PE_Pos          (26UL)                    /*!< CTIMER CTRL1: TMRB1PE (Bit 26)                        */
#define CTIMER_CTRL1_TMRB1PE_Msk          (0x4000000UL)             /*!< CTIMER CTRL1: TMRB1PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL1_TMRB1IE_Pos          (25UL)                    /*!< CTIMER CTRL1: TMRB1IE (Bit 25)                        */
#define CTIMER_CTRL1_TMRB1IE_Msk          (0x2000000UL)             /*!< CTIMER CTRL1: TMRB1IE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL1_TMRB1FN_Pos          (22UL)                    /*!< CTIMER CTRL1: TMRB1FN (Bit 22)                        */
#define CTIMER_CTRL1_TMRB1FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL1: TMRB1FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL1_TMRB1CLK_Pos         (17UL)                    /*!< CTIMER CTRL1: TMRB1CLK (Bit 17)                       */
#define CTIMER_CTRL1_TMRB1CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL1: TMRB1CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL1_TMRB1EN_Pos          (16UL)                    /*!< CTIMER CTRL1: TMRB1EN (Bit 16)                        */
#define CTIMER_CTRL1_TMRB1EN_Msk          (0x10000UL)               /*!< CTIMER CTRL1: TMRB1EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL1_TMRA1POL_Pos         (12UL)                    /*!< CTIMER CTRL1: TMRA1POL (Bit 12)                       */
#define CTIMER_CTRL1_TMRA1POL_Msk         (0x1000UL)                /*!< CTIMER CTRL1: TMRA1POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRA1CLR_Pos         (11UL)                    /*!< CTIMER CTRL1: TMRA1CLR (Bit 11)                       */
#define CTIMER_CTRL1_TMRA1CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL1: TMRA1CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL1_TMRA1PE_Pos          (10UL)                    /*!< CTIMER CTRL1: TMRA1PE (Bit 10)                        */
#define CTIMER_CTRL1_TMRA1PE_Msk          (0x400UL)                 /*!< CTIMER CTRL1: TMRA1PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL1_TMRA1IE_Pos          (9UL)                     /*!< CTIMER CTRL1: TMRA1IE (Bit 9)                         */
#define CTIMER_CTRL1_TMRA1IE_Msk          (0x200UL)                 /*!< CTIMER CTRL1: TMRA1IE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL1_TMRA1FN_Pos          (6UL)                     /*!< CTIMER CTRL1: TMRA1FN (Bit 6)                         */
#define CTIMER_CTRL1_TMRA1FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL1: TMRA1FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL1_TMRA1CLK_Pos         (1UL)                     /*!< CTIMER CTRL1: TMRA1CLK (Bit 1)                        */
#define CTIMER_CTRL1_TMRA1CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL1: TMRA1CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL1_TMRA1EN_Pos          (0UL)                     /*!< CTIMER CTRL1: TMRA1EN (Bit 0)                         */
#define CTIMER_CTRL1_TMRA1EN_Msk          (0x1UL)                   /*!< CTIMER CTRL1: TMRA1EN (Bitfield-Mask: 0x01)           */
/* =========================================================  TMR2  ========================================================== */
#define CTIMER_TMR2_CTTMRB2_Pos           (16UL)                    /*!< CTIMER TMR2: CTTMRB2 (Bit 16)                         */
#define CTIMER_TMR2_CTTMRB2_Msk           (0xffff0000UL)            /*!< CTIMER TMR2: CTTMRB2 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR2_CTTMRA2_Pos           (0UL)                     /*!< CTIMER TMR2: CTTMRA2 (Bit 0)                          */
#define CTIMER_TMR2_CTTMRA2_Msk           (0xffffUL)                /*!< CTIMER TMR2: CTTMRA2 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA2  ========================================================= */
#define CTIMER_CMPRA2_CMPR1A2_Pos         (16UL)                    /*!< CTIMER CMPRA2: CMPR1A2 (Bit 16)                       */
#define CTIMER_CMPRA2_CMPR1A2_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA2: CMPR1A2 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA2_CMPR0A2_Pos         (0UL)                     /*!< CTIMER CMPRA2: CMPR0A2 (Bit 0)                        */
#define CTIMER_CMPRA2_CMPR0A2_Msk         (0xffffUL)                /*!< CTIMER CMPRA2: CMPR0A2 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB2  ========================================================= */
#define CTIMER_CMPRB2_CMPR1B2_Pos         (16UL)                    /*!< CTIMER CMPRB2: CMPR1B2 (Bit 16)                       */
#define CTIMER_CMPRB2_CMPR1B2_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB2: CMPR1B2 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB2_CMPR0B2_Pos         (0UL)                     /*!< CTIMER CMPRB2: CMPR0B2 (Bit 0)                        */
#define CTIMER_CMPRB2_CMPR0B2_Msk         (0xffffUL)                /*!< CTIMER CMPRB2: CMPR0B2 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL2  ========================================================= */
#define CTIMER_CTRL2_CTLINK2_Pos          (31UL)                    /*!< CTIMER CTRL2: CTLINK2 (Bit 31)                        */
#define CTIMER_CTRL2_CTLINK2_Msk          (0x80000000UL)            /*!< CTIMER CTRL2: CTLINK2 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL2_TMRB2POL_Pos         (28UL)                    /*!< CTIMER CTRL2: TMRB2POL (Bit 28)                       */
#define CTIMER_CTRL2_TMRB2POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL2: TMRB2POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRB2CLR_Pos         (27UL)                    /*!< CTIMER CTRL2: TMRB2CLR (Bit 27)                       */
#define CTIMER_CTRL2_TMRB2CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL2: TMRB2CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRB2PE_Pos          (26UL)                    /*!< CTIMER CTRL2: TMRB2PE (Bit 26)                        */
#define CTIMER_CTRL2_TMRB2PE_Msk          (0x4000000UL)             /*!< CTIMER CTRL2: TMRB2PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL2_TMRB2IE_Pos          (25UL)                    /*!< CTIMER CTRL2: TMRB2IE (Bit 25)                        */
#define CTIMER_CTRL2_TMRB2IE_Msk          (0x2000000UL)             /*!< CTIMER CTRL2: TMRB2IE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL2_TMRB2FN_Pos          (22UL)                    /*!< CTIMER CTRL2: TMRB2FN (Bit 22)                        */
#define CTIMER_CTRL2_TMRB2FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL2: TMRB2FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL2_TMRB2CLK_Pos         (17UL)                    /*!< CTIMER CTRL2: TMRB2CLK (Bit 17)                       */
#define CTIMER_CTRL2_TMRB2CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL2: TMRB2CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL2_TMRB2EN_Pos          (16UL)                    /*!< CTIMER CTRL2: TMRB2EN (Bit 16)                        */
#define CTIMER_CTRL2_TMRB2EN_Msk          (0x10000UL)               /*!< CTIMER CTRL2: TMRB2EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL2_TMRA2POL_Pos         (12UL)                    /*!< CTIMER CTRL2: TMRA2POL (Bit 12)                       */
#define CTIMER_CTRL2_TMRA2POL_Msk         (0x1000UL)                /*!< CTIMER CTRL2: TMRA2POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRA2CLR_Pos         (11UL)                    /*!< CTIMER CTRL2: TMRA2CLR (Bit 11)                       */
#define CTIMER_CTRL2_TMRA2CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL2: TMRA2CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL2_TMRA2PE_Pos          (10UL)                    /*!< CTIMER CTRL2: TMRA2PE (Bit 10)                        */
#define CTIMER_CTRL2_TMRA2PE_Msk          (0x400UL)                 /*!< CTIMER CTRL2: TMRA2PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL2_TMRA2IE_Pos          (9UL)                     /*!< CTIMER CTRL2: TMRA2IE (Bit 9)                         */
#define CTIMER_CTRL2_TMRA2IE_Msk          (0x200UL)                 /*!< CTIMER CTRL2: TMRA2IE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL2_TMRA2FN_Pos          (6UL)                     /*!< CTIMER CTRL2: TMRA2FN (Bit 6)                         */
#define CTIMER_CTRL2_TMRA2FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL2: TMRA2FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL2_TMRA2CLK_Pos         (1UL)                     /*!< CTIMER CTRL2: TMRA2CLK (Bit 1)                        */
#define CTIMER_CTRL2_TMRA2CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL2: TMRA2CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL2_TMRA2EN_Pos          (0UL)                     /*!< CTIMER CTRL2: TMRA2EN (Bit 0)                         */
#define CTIMER_CTRL2_TMRA2EN_Msk          (0x1UL)                   /*!< CTIMER CTRL2: TMRA2EN (Bitfield-Mask: 0x01)           */
/* =========================================================  TMR3  ========================================================== */
#define CTIMER_TMR3_CTTMRB3_Pos           (16UL)                    /*!< CTIMER TMR3: CTTMRB3 (Bit 16)                         */
#define CTIMER_TMR3_CTTMRB3_Msk           (0xffff0000UL)            /*!< CTIMER TMR3: CTTMRB3 (Bitfield-Mask: 0xffff)          */
#define CTIMER_TMR3_CTTMRA3_Pos           (0UL)                     /*!< CTIMER TMR3: CTTMRA3 (Bit 0)                          */
#define CTIMER_TMR3_CTTMRA3_Msk           (0xffffUL)                /*!< CTIMER TMR3: CTTMRA3 (Bitfield-Mask: 0xffff)          */
/* ========================================================  CMPRA3  ========================================================= */
#define CTIMER_CMPRA3_CMPR1A3_Pos         (16UL)                    /*!< CTIMER CMPRA3: CMPR1A3 (Bit 16)                       */
#define CTIMER_CMPRA3_CMPR1A3_Msk         (0xffff0000UL)            /*!< CTIMER CMPRA3: CMPR1A3 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRA3_CMPR0A3_Pos         (0UL)                     /*!< CTIMER CMPRA3: CMPR0A3 (Bit 0)                        */
#define CTIMER_CMPRA3_CMPR0A3_Msk         (0xffffUL)                /*!< CTIMER CMPRA3: CMPR0A3 (Bitfield-Mask: 0xffff)        */
/* ========================================================  CMPRB3  ========================================================= */
#define CTIMER_CMPRB3_CMPR1B3_Pos         (16UL)                    /*!< CTIMER CMPRB3: CMPR1B3 (Bit 16)                       */
#define CTIMER_CMPRB3_CMPR1B3_Msk         (0xffff0000UL)            /*!< CTIMER CMPRB3: CMPR1B3 (Bitfield-Mask: 0xffff)        */
#define CTIMER_CMPRB3_CMPR0B3_Pos         (0UL)                     /*!< CTIMER CMPRB3: CMPR0B3 (Bit 0)                        */
#define CTIMER_CMPRB3_CMPR0B3_Msk         (0xffffUL)                /*!< CTIMER CMPRB3: CMPR0B3 (Bitfield-Mask: 0xffff)        */
/* =========================================================  CTRL3  ========================================================= */
#define CTIMER_CTRL3_CTLINK3_Pos          (31UL)                    /*!< CTIMER CTRL3: CTLINK3 (Bit 31)                        */
#define CTIMER_CTRL3_CTLINK3_Msk          (0x80000000UL)            /*!< CTIMER CTRL3: CTLINK3 (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL3_TMRB3POL_Pos         (28UL)                    /*!< CTIMER CTRL3: TMRB3POL (Bit 28)                       */
#define CTIMER_CTRL3_TMRB3POL_Msk         (0x10000000UL)            /*!< CTIMER CTRL3: TMRB3POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRB3CLR_Pos         (27UL)                    /*!< CTIMER CTRL3: TMRB3CLR (Bit 27)                       */
#define CTIMER_CTRL3_TMRB3CLR_Msk         (0x8000000UL)             /*!< CTIMER CTRL3: TMRB3CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRB3PE_Pos          (26UL)                    /*!< CTIMER CTRL3: TMRB3PE (Bit 26)                        */
#define CTIMER_CTRL3_TMRB3PE_Msk          (0x4000000UL)             /*!< CTIMER CTRL3: TMRB3PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL3_TMRB3IE_Pos          (25UL)                    /*!< CTIMER CTRL3: TMRB3IE (Bit 25)                        */
#define CTIMER_CTRL3_TMRB3IE_Msk          (0x2000000UL)             /*!< CTIMER CTRL3: TMRB3IE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL3_TMRB3FN_Pos          (22UL)                    /*!< CTIMER CTRL3: TMRB3FN (Bit 22)                        */
#define CTIMER_CTRL3_TMRB3FN_Msk          (0x1c00000UL)             /*!< CTIMER CTRL3: TMRB3FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL3_TMRB3CLK_Pos         (17UL)                    /*!< CTIMER CTRL3: TMRB3CLK (Bit 17)                       */
#define CTIMER_CTRL3_TMRB3CLK_Msk         (0x3e0000UL)              /*!< CTIMER CTRL3: TMRB3CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL3_TMRB3EN_Pos          (16UL)                    /*!< CTIMER CTRL3: TMRB3EN (Bit 16)                        */
#define CTIMER_CTRL3_TMRB3EN_Msk          (0x10000UL)               /*!< CTIMER CTRL3: TMRB3EN (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL3_ADCEN_Pos            (15UL)                    /*!< CTIMER CTRL3: ADCEN (Bit 15)                          */
#define CTIMER_CTRL3_ADCEN_Msk            (0x8000UL)                /*!< CTIMER CTRL3: ADCEN (Bitfield-Mask: 0x01)             */
#define CTIMER_CTRL3_TMRA3POL_Pos         (12UL)                    /*!< CTIMER CTRL3: TMRA3POL (Bit 12)                       */
#define CTIMER_CTRL3_TMRA3POL_Msk         (0x1000UL)                /*!< CTIMER CTRL3: TMRA3POL (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRA3CLR_Pos         (11UL)                    /*!< CTIMER CTRL3: TMRA3CLR (Bit 11)                       */
#define CTIMER_CTRL3_TMRA3CLR_Msk         (0x800UL)                 /*!< CTIMER CTRL3: TMRA3CLR (Bitfield-Mask: 0x01)          */
#define CTIMER_CTRL3_TMRA3PE_Pos          (10UL)                    /*!< CTIMER CTRL3: TMRA3PE (Bit 10)                        */
#define CTIMER_CTRL3_TMRA3PE_Msk          (0x400UL)                 /*!< CTIMER CTRL3: TMRA3PE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL3_TMRA3IE_Pos          (9UL)                     /*!< CTIMER CTRL3: TMRA3IE (Bit 9)                         */
#define CTIMER_CTRL3_TMRA3IE_Msk          (0x200UL)                 /*!< CTIMER CTRL3: TMRA3IE (Bitfield-Mask: 0x01)           */
#define CTIMER_CTRL3_TMRA3FN_Pos          (6UL)                     /*!< CTIMER CTRL3: TMRA3FN (Bit 6)                         */
#define CTIMER_CTRL3_TMRA3FN_Msk          (0x1c0UL)                 /*!< CTIMER CTRL3: TMRA3FN (Bitfield-Mask: 0x07)           */
#define CTIMER_CTRL3_TMRA3CLK_Pos         (1UL)                     /*!< CTIMER CTRL3: TMRA3CLK (Bit 1)                        */
#define CTIMER_CTRL3_TMRA3CLK_Msk         (0x3eUL)                  /*!< CTIMER CTRL3: TMRA3CLK (Bitfield-Mask: 0x1f)          */
#define CTIMER_CTRL3_TMRA3EN_Pos          (0UL)                     /*!< CTIMER CTRL3: TMRA3EN (Bit 0)                         */
#define CTIMER_CTRL3_TMRA3EN_Msk          (0x1UL)                   /*!< CTIMER CTRL3: TMRA3EN (Bitfield-Mask: 0x01)           */
/* =========================================================  INTEN  ========================================================= */
#define CTIMER_INTEN_CTMRB3INT_Pos        (7UL)                     /*!< CTIMER INTEN: CTMRB3INT (Bit 7)                       */
#define CTIMER_INTEN_CTMRB3INT_Msk        (0x80UL)                  /*!< CTIMER INTEN: CTMRB3INT (Bitfield-Mask: 0x01)         */
#define CTIMER_INTEN_CTMRA3INT_Pos        (6UL)                     /*!< CTIMER INTEN: CTMRA3INT (Bit 6)                       */
#define CTIMER_INTEN_CTMRA3INT_Msk        (0x40UL)                  /*!< CTIMER INTEN: CTMRA3INT (Bitfield-Mask: 0x01)         */
#define CTIMER_INTEN_CTMRB2INT_Pos        (5UL)                     /*!< CTIMER INTEN: CTMRB2INT (Bit 5)                       */
#define CTIMER_INTEN_CTMRB2INT_Msk        (0x20UL)                  /*!< CTIMER INTEN: CTMRB2INT (Bitfield-Mask: 0x01)         */
#define CTIMER_INTEN_CTMRA2INT_Pos        (4UL)                     /*!< CTIMER INTEN: CTMRA2INT (Bit 4)                       */
#define CTIMER_INTEN_CTMRA2INT_Msk        (0x10UL)                  /*!< CTIMER INTEN: CTMRA2INT (Bitfield-Mask: 0x01)         */
#define CTIMER_INTEN_CTMRB1INT_Pos        (3UL)                     /*!< CTIMER INTEN: CTMRB1INT (Bit 3)                       */
#define CTIMER_INTEN_CTMRB1INT_Msk        (0x8UL)                   /*!< CTIMER INTEN: CTMRB1INT (Bitfield-Mask: 0x01)         */
#define CTIMER_INTEN_CTMRA1INT_Pos        (2UL)                     /*!< CTIMER INTEN: CTMRA1INT (Bit 2)                       */
#define CTIMER_INTEN_CTMRA1INT_Msk        (0x4UL)                   /*!< CTIMER INTEN: CTMRA1INT (Bitfield-Mask: 0x01)         */
#define CTIMER_INTEN_CTMRB0INT_Pos        (1UL)                     /*!< CTIMER INTEN: CTMRB0INT (Bit 1)                       */
#define CTIMER_INTEN_CTMRB0INT_Msk        (0x2UL)                   /*!< CTIMER INTEN: CTMRB0INT (Bitfield-Mask: 0x01)         */
#define CTIMER_INTEN_CTMRA0INT_Pos        (0UL)                     /*!< CTIMER INTEN: CTMRA0INT (Bit 0)                       */
#define CTIMER_INTEN_CTMRA0INT_Msk        (0x1UL)                   /*!< CTIMER INTEN: CTMRA0INT (Bitfield-Mask: 0x01)         */
/* ========================================================  INTSTAT  ======================================================== */
#define CTIMER_INTSTAT_CTMRB3INT_Pos      (7UL)                     /*!< CTIMER INTSTAT: CTMRB3INT (Bit 7)                     */
#define CTIMER_INTSTAT_CTMRB3INT_Msk      (0x80UL)                  /*!< CTIMER INTSTAT: CTMRB3INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTSTAT_CTMRA3INT_Pos      (6UL)                     /*!< CTIMER INTSTAT: CTMRA3INT (Bit 6)                     */
#define CTIMER_INTSTAT_CTMRA3INT_Msk      (0x40UL)                  /*!< CTIMER INTSTAT: CTMRA3INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTSTAT_CTMRB2INT_Pos      (5UL)                     /*!< CTIMER INTSTAT: CTMRB2INT (Bit 5)                     */
#define CTIMER_INTSTAT_CTMRB2INT_Msk      (0x20UL)                  /*!< CTIMER INTSTAT: CTMRB2INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTSTAT_CTMRA2INT_Pos      (4UL)                     /*!< CTIMER INTSTAT: CTMRA2INT (Bit 4)                     */
#define CTIMER_INTSTAT_CTMRA2INT_Msk      (0x10UL)                  /*!< CTIMER INTSTAT: CTMRA2INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTSTAT_CTMRB1INT_Pos      (3UL)                     /*!< CTIMER INTSTAT: CTMRB1INT (Bit 3)                     */
#define CTIMER_INTSTAT_CTMRB1INT_Msk      (0x8UL)                   /*!< CTIMER INTSTAT: CTMRB1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTSTAT_CTMRA1INT_Pos      (2UL)                     /*!< CTIMER INTSTAT: CTMRA1INT (Bit 2)                     */
#define CTIMER_INTSTAT_CTMRA1INT_Msk      (0x4UL)                   /*!< CTIMER INTSTAT: CTMRA1INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTSTAT_CTMRB0INT_Pos      (1UL)                     /*!< CTIMER INTSTAT: CTMRB0INT (Bit 1)                     */
#define CTIMER_INTSTAT_CTMRB0INT_Msk      (0x2UL)                   /*!< CTIMER INTSTAT: CTMRB0INT (Bitfield-Mask: 0x01)       */
#define CTIMER_INTSTAT_CTMRA0INT_Pos      (0UL)                     /*!< CTIMER INTSTAT: CTMRA0INT (Bit 0)                     */
#define CTIMER_INTSTAT_CTMRA0INT_Msk      (0x1UL)                   /*!< CTIMER INTSTAT: CTMRA0INT (Bitfield-Mask: 0x01)       */
/* ========================================================  INTCLR  ========================================================= */
#define CTIMER_INTCLR_CTMRB3INT_Pos       (7UL)                     /*!< CTIMER INTCLR: CTMRB3INT (Bit 7)                      */
#define CTIMER_INTCLR_CTMRB3INT_Msk       (0x80UL)                  /*!< CTIMER INTCLR: CTMRB3INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTCLR_CTMRA3INT_Pos       (6UL)                     /*!< CTIMER INTCLR: CTMRA3INT (Bit 6)                      */
#define CTIMER_INTCLR_CTMRA3INT_Msk       (0x40UL)                  /*!< CTIMER INTCLR: CTMRA3INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTCLR_CTMRB2INT_Pos       (5UL)                     /*!< CTIMER INTCLR: CTMRB2INT (Bit 5)                      */
#define CTIMER_INTCLR_CTMRB2INT_Msk       (0x20UL)                  /*!< CTIMER INTCLR: CTMRB2INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTCLR_CTMRA2INT_Pos       (4UL)                     /*!< CTIMER INTCLR: CTMRA2INT (Bit 4)                      */
#define CTIMER_INTCLR_CTMRA2INT_Msk       (0x10UL)                  /*!< CTIMER INTCLR: CTMRA2INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTCLR_CTMRB1INT_Pos       (3UL)                     /*!< CTIMER INTCLR: CTMRB1INT (Bit 3)                      */
#define CTIMER_INTCLR_CTMRB1INT_Msk       (0x8UL)                   /*!< CTIMER INTCLR: CTMRB1INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTCLR_CTMRA1INT_Pos       (2UL)                     /*!< CTIMER INTCLR: CTMRA1INT (Bit 2)                      */
#define CTIMER_INTCLR_CTMRA1INT_Msk       (0x4UL)                   /*!< CTIMER INTCLR: CTMRA1INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTCLR_CTMRB0INT_Pos       (1UL)                     /*!< CTIMER INTCLR: CTMRB0INT (Bit 1)                      */
#define CTIMER_INTCLR_CTMRB0INT_Msk       (0x2UL)                   /*!< CTIMER INTCLR: CTMRB0INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTCLR_CTMRA0INT_Pos       (0UL)                     /*!< CTIMER INTCLR: CTMRA0INT (Bit 0)                      */
#define CTIMER_INTCLR_CTMRA0INT_Msk       (0x1UL)                   /*!< CTIMER INTCLR: CTMRA0INT (Bitfield-Mask: 0x01)        */
/* ========================================================  INTSET  ========================================================= */
#define CTIMER_INTSET_CTMRB3INT_Pos       (7UL)                     /*!< CTIMER INTSET: CTMRB3INT (Bit 7)                      */
#define CTIMER_INTSET_CTMRB3INT_Msk       (0x80UL)                  /*!< CTIMER INTSET: CTMRB3INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTSET_CTMRA3INT_Pos       (6UL)                     /*!< CTIMER INTSET: CTMRA3INT (Bit 6)                      */
#define CTIMER_INTSET_CTMRA3INT_Msk       (0x40UL)                  /*!< CTIMER INTSET: CTMRA3INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTSET_CTMRB2INT_Pos       (5UL)                     /*!< CTIMER INTSET: CTMRB2INT (Bit 5)                      */
#define CTIMER_INTSET_CTMRB2INT_Msk       (0x20UL)                  /*!< CTIMER INTSET: CTMRB2INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTSET_CTMRA2INT_Pos       (4UL)                     /*!< CTIMER INTSET: CTMRA2INT (Bit 4)                      */
#define CTIMER_INTSET_CTMRA2INT_Msk       (0x10UL)                  /*!< CTIMER INTSET: CTMRA2INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTSET_CTMRB1INT_Pos       (3UL)                     /*!< CTIMER INTSET: CTMRB1INT (Bit 3)                      */
#define CTIMER_INTSET_CTMRB1INT_Msk       (0x8UL)                   /*!< CTIMER INTSET: CTMRB1INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTSET_CTMRA1INT_Pos       (2UL)                     /*!< CTIMER INTSET: CTMRA1INT (Bit 2)                      */
#define CTIMER_INTSET_CTMRA1INT_Msk       (0x4UL)                   /*!< CTIMER INTSET: CTMRA1INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTSET_CTMRB0INT_Pos       (1UL)                     /*!< CTIMER INTSET: CTMRB0INT (Bit 1)                      */
#define CTIMER_INTSET_CTMRB0INT_Msk       (0x2UL)                   /*!< CTIMER INTSET: CTMRB0INT (Bitfield-Mask: 0x01)        */
#define CTIMER_INTSET_CTMRA0INT_Pos       (0UL)                     /*!< CTIMER INTSET: CTMRA0INT (Bit 0)                      */
#define CTIMER_INTSET_CTMRA0INT_Msk       (0x1UL)                   /*!< CTIMER INTSET: CTMRA0INT (Bitfield-Mask: 0x01)        */


/* =========================================================================================================================== */
/* ================                                           GPIO                                            ================ */
/* =========================================================================================================================== */

/* ========================================================  PADREGA  ======================================================== */
#define GPIO_PADREGA_PAD3PWRUP_Pos        (31UL)                    /*!< GPIO PADREGA: PAD3PWRUP (Bit 31)                      */
#define GPIO_PADREGA_PAD3PWRUP_Msk        (0x80000000UL)            /*!< GPIO PADREGA: PAD3PWRUP (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD3FNCSEL_Pos       (27UL)                    /*!< GPIO PADREGA: PAD3FNCSEL (Bit 27)                     */
#define GPIO_PADREGA_PAD3FNCSEL_Msk       (0x38000000UL)            /*!< GPIO PADREGA: PAD3FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGA_PAD3STRNG_Pos        (26UL)                    /*!< GPIO PADREGA: PAD3STRNG (Bit 26)                      */
#define GPIO_PADREGA_PAD3STRNG_Msk        (0x4000000UL)             /*!< GPIO PADREGA: PAD3STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD3INPEN_Pos        (25UL)                    /*!< GPIO PADREGA: PAD3INPEN (Bit 25)                      */
#define GPIO_PADREGA_PAD3INPEN_Msk        (0x2000000UL)             /*!< GPIO PADREGA: PAD3INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD3PULL_Pos         (24UL)                    /*!< GPIO PADREGA: PAD3PULL (Bit 24)                       */
#define GPIO_PADREGA_PAD3PULL_Msk         (0x1000000UL)             /*!< GPIO PADREGA: PAD3PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGA_PAD2FNCSEL_Pos       (19UL)                    /*!< GPIO PADREGA: PAD2FNCSEL (Bit 19)                     */
#define GPIO_PADREGA_PAD2FNCSEL_Msk       (0x380000UL)              /*!< GPIO PADREGA: PAD2FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGA_PAD2STRNG_Pos        (18UL)                    /*!< GPIO PADREGA: PAD2STRNG (Bit 18)                      */
#define GPIO_PADREGA_PAD2STRNG_Msk        (0x40000UL)               /*!< GPIO PADREGA: PAD2STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD2INPEN_Pos        (17UL)                    /*!< GPIO PADREGA: PAD2INPEN (Bit 17)                      */
#define GPIO_PADREGA_PAD2INPEN_Msk        (0x20000UL)               /*!< GPIO PADREGA: PAD2INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD2PULL_Pos         (16UL)                    /*!< GPIO PADREGA: PAD2PULL (Bit 16)                       */
#define GPIO_PADREGA_PAD2PULL_Msk         (0x10000UL)               /*!< GPIO PADREGA: PAD2PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGA_PAD1FNCSEL_Pos       (11UL)                    /*!< GPIO PADREGA: PAD1FNCSEL (Bit 11)                     */
#define GPIO_PADREGA_PAD1FNCSEL_Msk       (0x3800UL)                /*!< GPIO PADREGA: PAD1FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGA_PAD1STRNG_Pos        (10UL)                    /*!< GPIO PADREGA: PAD1STRNG (Bit 10)                      */
#define GPIO_PADREGA_PAD1STRNG_Msk        (0x400UL)                 /*!< GPIO PADREGA: PAD1STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD1INPEN_Pos        (9UL)                     /*!< GPIO PADREGA: PAD1INPEN (Bit 9)                       */
#define GPIO_PADREGA_PAD1INPEN_Msk        (0x200UL)                 /*!< GPIO PADREGA: PAD1INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD1PULL_Pos         (8UL)                     /*!< GPIO PADREGA: PAD1PULL (Bit 8)                        */
#define GPIO_PADREGA_PAD1PULL_Msk         (0x100UL)                 /*!< GPIO PADREGA: PAD1PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGA_PAD0FNCSEL_Pos       (3UL)                     /*!< GPIO PADREGA: PAD0FNCSEL (Bit 3)                      */
#define GPIO_PADREGA_PAD0FNCSEL_Msk       (0x38UL)                  /*!< GPIO PADREGA: PAD0FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGA_PAD0STRNG_Pos        (2UL)                     /*!< GPIO PADREGA: PAD0STRNG (Bit 2)                       */
#define GPIO_PADREGA_PAD0STRNG_Msk        (0x4UL)                   /*!< GPIO PADREGA: PAD0STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD0INPEN_Pos        (1UL)                     /*!< GPIO PADREGA: PAD0INPEN (Bit 1)                       */
#define GPIO_PADREGA_PAD0INPEN_Msk        (0x2UL)                   /*!< GPIO PADREGA: PAD0INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGA_PAD0PULL_Pos         (0UL)                     /*!< GPIO PADREGA: PAD0PULL (Bit 0)                        */
#define GPIO_PADREGA_PAD0PULL_Msk         (0x1UL)                   /*!< GPIO PADREGA: PAD0PULL (Bitfield-Mask: 0x01)          */
/* ========================================================  PADREGB  ======================================================== */
#define GPIO_PADREGB_PAD7FNCSEL_Pos       (27UL)                    /*!< GPIO PADREGB: PAD7FNCSEL (Bit 27)                     */
#define GPIO_PADREGB_PAD7FNCSEL_Msk       (0x38000000UL)            /*!< GPIO PADREGB: PAD7FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGB_PAD7STRNG_Pos        (26UL)                    /*!< GPIO PADREGB: PAD7STRNG (Bit 26)                      */
#define GPIO_PADREGB_PAD7STRNG_Msk        (0x4000000UL)             /*!< GPIO PADREGB: PAD7STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD7INPEN_Pos        (25UL)                    /*!< GPIO PADREGB: PAD7INPEN (Bit 25)                      */
#define GPIO_PADREGB_PAD7INPEN_Msk        (0x2000000UL)             /*!< GPIO PADREGB: PAD7INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD7PULL_Pos         (24UL)                    /*!< GPIO PADREGB: PAD7PULL (Bit 24)                       */
#define GPIO_PADREGB_PAD7PULL_Msk         (0x1000000UL)             /*!< GPIO PADREGB: PAD7PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGB_PAD6RSEL_Pos         (22UL)                    /*!< GPIO PADREGB: PAD6RSEL (Bit 22)                       */
#define GPIO_PADREGB_PAD6RSEL_Msk         (0xc00000UL)              /*!< GPIO PADREGB: PAD6RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGB_PAD6FNCSEL_Pos       (19UL)                    /*!< GPIO PADREGB: PAD6FNCSEL (Bit 19)                     */
#define GPIO_PADREGB_PAD6FNCSEL_Msk       (0x380000UL)              /*!< GPIO PADREGB: PAD6FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGB_PAD6STRNG_Pos        (18UL)                    /*!< GPIO PADREGB: PAD6STRNG (Bit 18)                      */
#define GPIO_PADREGB_PAD6STRNG_Msk        (0x40000UL)               /*!< GPIO PADREGB: PAD6STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD6INPEN_Pos        (17UL)                    /*!< GPIO PADREGB: PAD6INPEN (Bit 17)                      */
#define GPIO_PADREGB_PAD6INPEN_Msk        (0x20000UL)               /*!< GPIO PADREGB: PAD6INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD6PULL_Pos         (16UL)                    /*!< GPIO PADREGB: PAD6PULL (Bit 16)                       */
#define GPIO_PADREGB_PAD6PULL_Msk         (0x10000UL)               /*!< GPIO PADREGB: PAD6PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGB_PAD5RSEL_Pos         (14UL)                    /*!< GPIO PADREGB: PAD5RSEL (Bit 14)                       */
#define GPIO_PADREGB_PAD5RSEL_Msk         (0xc000UL)                /*!< GPIO PADREGB: PAD5RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGB_PAD5FNCSEL_Pos       (11UL)                    /*!< GPIO PADREGB: PAD5FNCSEL (Bit 11)                     */
#define GPIO_PADREGB_PAD5FNCSEL_Msk       (0x3800UL)                /*!< GPIO PADREGB: PAD5FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGB_PAD5STRNG_Pos        (10UL)                    /*!< GPIO PADREGB: PAD5STRNG (Bit 10)                      */
#define GPIO_PADREGB_PAD5STRNG_Msk        (0x400UL)                 /*!< GPIO PADREGB: PAD5STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD5INPEN_Pos        (9UL)                     /*!< GPIO PADREGB: PAD5INPEN (Bit 9)                       */
#define GPIO_PADREGB_PAD5INPEN_Msk        (0x200UL)                 /*!< GPIO PADREGB: PAD5INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD5PULL_Pos         (8UL)                     /*!< GPIO PADREGB: PAD5PULL (Bit 8)                        */
#define GPIO_PADREGB_PAD5PULL_Msk         (0x100UL)                 /*!< GPIO PADREGB: PAD5PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGB_PAD4PWRUP_Pos        (7UL)                     /*!< GPIO PADREGB: PAD4PWRUP (Bit 7)                       */
#define GPIO_PADREGB_PAD4PWRUP_Msk        (0x80UL)                  /*!< GPIO PADREGB: PAD4PWRUP (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD4FNCSEL_Pos       (3UL)                     /*!< GPIO PADREGB: PAD4FNCSEL (Bit 3)                      */
#define GPIO_PADREGB_PAD4FNCSEL_Msk       (0x38UL)                  /*!< GPIO PADREGB: PAD4FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGB_PAD4STRNG_Pos        (2UL)                     /*!< GPIO PADREGB: PAD4STRNG (Bit 2)                       */
#define GPIO_PADREGB_PAD4STRNG_Msk        (0x4UL)                   /*!< GPIO PADREGB: PAD4STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD4INPEN_Pos        (1UL)                     /*!< GPIO PADREGB: PAD4INPEN (Bit 1)                       */
#define GPIO_PADREGB_PAD4INPEN_Msk        (0x2UL)                   /*!< GPIO PADREGB: PAD4INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGB_PAD4PULL_Pos         (0UL)                     /*!< GPIO PADREGB: PAD4PULL (Bit 0)                        */
#define GPIO_PADREGB_PAD4PULL_Msk         (0x1UL)                   /*!< GPIO PADREGB: PAD4PULL (Bitfield-Mask: 0x01)          */
/* ========================================================  PADREGC  ======================================================== */
#define GPIO_PADREGC_PAD11PWRDN_Pos       (30UL)                    /*!< GPIO PADREGC: PAD11PWRDN (Bit 30)                     */
#define GPIO_PADREGC_PAD11PWRDN_Msk       (0x40000000UL)            /*!< GPIO PADREGC: PAD11PWRDN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGC_PAD11FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGC: PAD11FNCSEL (Bit 27)                    */
#define GPIO_PADREGC_PAD11FNCSEL_Msk      (0x18000000UL)            /*!< GPIO PADREGC: PAD11FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGC_PAD11STRNG_Pos       (26UL)                    /*!< GPIO PADREGC: PAD11STRNG (Bit 26)                     */
#define GPIO_PADREGC_PAD11STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGC: PAD11STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGC_PAD11INPEN_Pos       (25UL)                    /*!< GPIO PADREGC: PAD11INPEN (Bit 25)                     */
#define GPIO_PADREGC_PAD11INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGC: PAD11INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGC_PAD11PULL_Pos        (24UL)                    /*!< GPIO PADREGC: PAD11PULL (Bit 24)                      */
#define GPIO_PADREGC_PAD11PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGC: PAD11PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD10FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGC: PAD10FNCSEL (Bit 19)                    */
#define GPIO_PADREGC_PAD10FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGC: PAD10FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGC_PAD10STRNG_Pos       (18UL)                    /*!< GPIO PADREGC: PAD10STRNG (Bit 18)                     */
#define GPIO_PADREGC_PAD10STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGC: PAD10STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGC_PAD10INPEN_Pos       (17UL)                    /*!< GPIO PADREGC: PAD10INPEN (Bit 17)                     */
#define GPIO_PADREGC_PAD10INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGC: PAD10INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGC_PAD10PULL_Pos        (16UL)                    /*!< GPIO PADREGC: PAD10PULL (Bit 16)                      */
#define GPIO_PADREGC_PAD10PULL_Msk        (0x10000UL)               /*!< GPIO PADREGC: PAD10PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD9RSEL_Pos         (14UL)                    /*!< GPIO PADREGC: PAD9RSEL (Bit 14)                       */
#define GPIO_PADREGC_PAD9RSEL_Msk         (0xc000UL)                /*!< GPIO PADREGC: PAD9RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGC_PAD9FNCSEL_Pos       (11UL)                    /*!< GPIO PADREGC: PAD9FNCSEL (Bit 11)                     */
#define GPIO_PADREGC_PAD9FNCSEL_Msk       (0x3800UL)                /*!< GPIO PADREGC: PAD9FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGC_PAD9STRNG_Pos        (10UL)                    /*!< GPIO PADREGC: PAD9STRNG (Bit 10)                      */
#define GPIO_PADREGC_PAD9STRNG_Msk        (0x400UL)                 /*!< GPIO PADREGC: PAD9STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD9INPEN_Pos        (9UL)                     /*!< GPIO PADREGC: PAD9INPEN (Bit 9)                       */
#define GPIO_PADREGC_PAD9INPEN_Msk        (0x200UL)                 /*!< GPIO PADREGC: PAD9INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD9PULL_Pos         (8UL)                     /*!< GPIO PADREGC: PAD9PULL (Bit 8)                        */
#define GPIO_PADREGC_PAD9PULL_Msk         (0x100UL)                 /*!< GPIO PADREGC: PAD9PULL (Bitfield-Mask: 0x01)          */
#define GPIO_PADREGC_PAD8RSEL_Pos         (6UL)                     /*!< GPIO PADREGC: PAD8RSEL (Bit 6)                        */
#define GPIO_PADREGC_PAD8RSEL_Msk         (0xc0UL)                  /*!< GPIO PADREGC: PAD8RSEL (Bitfield-Mask: 0x03)          */
#define GPIO_PADREGC_PAD8FNCSEL_Pos       (3UL)                     /*!< GPIO PADREGC: PAD8FNCSEL (Bit 3)                      */
#define GPIO_PADREGC_PAD8FNCSEL_Msk       (0x38UL)                  /*!< GPIO PADREGC: PAD8FNCSEL (Bitfield-Mask: 0x07)        */
#define GPIO_PADREGC_PAD8STRNG_Pos        (2UL)                     /*!< GPIO PADREGC: PAD8STRNG (Bit 2)                       */
#define GPIO_PADREGC_PAD8STRNG_Msk        (0x4UL)                   /*!< GPIO PADREGC: PAD8STRNG (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD8INPEN_Pos        (1UL)                     /*!< GPIO PADREGC: PAD8INPEN (Bit 1)                       */
#define GPIO_PADREGC_PAD8INPEN_Msk        (0x2UL)                   /*!< GPIO PADREGC: PAD8INPEN (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGC_PAD8PULL_Pos         (0UL)                     /*!< GPIO PADREGC: PAD8PULL (Bit 0)                        */
#define GPIO_PADREGC_PAD8PULL_Msk         (0x1UL)                   /*!< GPIO PADREGC: PAD8PULL (Bitfield-Mask: 0x01)          */
/* ========================================================  PADREGD  ======================================================== */
#define GPIO_PADREGD_PAD15FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGD: PAD15FNCSEL (Bit 27)                    */
#define GPIO_PADREGD_PAD15FNCSEL_Msk      (0x38000000UL)            /*!< GPIO PADREGD: PAD15FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGD_PAD15STRNG_Pos       (26UL)                    /*!< GPIO PADREGD: PAD15STRNG (Bit 26)                     */
#define GPIO_PADREGD_PAD15STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGD: PAD15STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD15INPEN_Pos       (25UL)                    /*!< GPIO PADREGD: PAD15INPEN (Bit 25)                     */
#define GPIO_PADREGD_PAD15INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGD: PAD15INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD15PULL_Pos        (24UL)                    /*!< GPIO PADREGD: PAD15PULL (Bit 24)                      */
#define GPIO_PADREGD_PAD15PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGD: PAD15PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGD_PAD14FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGD: PAD14FNCSEL (Bit 19)                    */
#define GPIO_PADREGD_PAD14FNCSEL_Msk      (0x380000UL)              /*!< GPIO PADREGD: PAD14FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGD_PAD14STRNG_Pos       (18UL)                    /*!< GPIO PADREGD: PAD14STRNG (Bit 18)                     */
#define GPIO_PADREGD_PAD14STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGD: PAD14STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD14INPEN_Pos       (17UL)                    /*!< GPIO PADREGD: PAD14INPEN (Bit 17)                     */
#define GPIO_PADREGD_PAD14INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGD: PAD14INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD14PULL_Pos        (16UL)                    /*!< GPIO PADREGD: PAD14PULL (Bit 16)                      */
#define GPIO_PADREGD_PAD14PULL_Msk        (0x10000UL)               /*!< GPIO PADREGD: PAD14PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGD_PAD13FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGD: PAD13FNCSEL (Bit 11)                    */
#define GPIO_PADREGD_PAD13FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGD: PAD13FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGD_PAD13STRNG_Pos       (10UL)                    /*!< GPIO PADREGD: PAD13STRNG (Bit 10)                     */
#define GPIO_PADREGD_PAD13STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGD: PAD13STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD13INPEN_Pos       (9UL)                     /*!< GPIO PADREGD: PAD13INPEN (Bit 9)                      */
#define GPIO_PADREGD_PAD13INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGD: PAD13INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD13PULL_Pos        (8UL)                     /*!< GPIO PADREGD: PAD13PULL (Bit 8)                       */
#define GPIO_PADREGD_PAD13PULL_Msk        (0x100UL)                 /*!< GPIO PADREGD: PAD13PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGD_PAD12FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGD: PAD12FNCSEL (Bit 3)                     */
#define GPIO_PADREGD_PAD12FNCSEL_Msk      (0x18UL)                  /*!< GPIO PADREGD: PAD12FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGD_PAD12STRNG_Pos       (2UL)                     /*!< GPIO PADREGD: PAD12STRNG (Bit 2)                      */
#define GPIO_PADREGD_PAD12STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGD: PAD12STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD12INPEN_Pos       (1UL)                     /*!< GPIO PADREGD: PAD12INPEN (Bit 1)                      */
#define GPIO_PADREGD_PAD12INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGD: PAD12INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGD_PAD12PULL_Pos        (0UL)                     /*!< GPIO PADREGD: PAD12PULL (Bit 0)                       */
#define GPIO_PADREGD_PAD12PULL_Msk        (0x1UL)                   /*!< GPIO PADREGD: PAD12PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGE  ======================================================== */
#define GPIO_PADREGE_PAD19FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGE: PAD19FNCSEL (Bit 27)                    */
#define GPIO_PADREGE_PAD19FNCSEL_Msk      (0x18000000UL)            /*!< GPIO PADREGE: PAD19FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGE_PAD19STRNG_Pos       (26UL)                    /*!< GPIO PADREGE: PAD19STRNG (Bit 26)                     */
#define GPIO_PADREGE_PAD19STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGE: PAD19STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD19INPEN_Pos       (25UL)                    /*!< GPIO PADREGE: PAD19INPEN (Bit 25)                     */
#define GPIO_PADREGE_PAD19INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGE: PAD19INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD19PULL_Pos        (24UL)                    /*!< GPIO PADREGE: PAD19PULL (Bit 24)                      */
#define GPIO_PADREGE_PAD19PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGE: PAD19PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGE_PAD18FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGE: PAD18FNCSEL (Bit 19)                    */
#define GPIO_PADREGE_PAD18FNCSEL_Msk      (0x180000UL)              /*!< GPIO PADREGE: PAD18FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGE_PAD18STRNG_Pos       (18UL)                    /*!< GPIO PADREGE: PAD18STRNG (Bit 18)                     */
#define GPIO_PADREGE_PAD18STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGE: PAD18STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD18INPEN_Pos       (17UL)                    /*!< GPIO PADREGE: PAD18INPEN (Bit 17)                     */
#define GPIO_PADREGE_PAD18INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGE: PAD18INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD18PULL_Pos        (16UL)                    /*!< GPIO PADREGE: PAD18PULL (Bit 16)                      */
#define GPIO_PADREGE_PAD18PULL_Msk        (0x10000UL)               /*!< GPIO PADREGE: PAD18PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGE_PAD17FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGE: PAD17FNCSEL (Bit 11)                    */
#define GPIO_PADREGE_PAD17FNCSEL_Msk      (0x3800UL)                /*!< GPIO PADREGE: PAD17FNCSEL (Bitfield-Mask: 0x07)       */
#define GPIO_PADREGE_PAD17STRNG_Pos       (10UL)                    /*!< GPIO PADREGE: PAD17STRNG (Bit 10)                     */
#define GPIO_PADREGE_PAD17STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGE: PAD17STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD17INPEN_Pos       (9UL)                     /*!< GPIO PADREGE: PAD17INPEN (Bit 9)                      */
#define GPIO_PADREGE_PAD17INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGE: PAD17INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD17PULL_Pos        (8UL)                     /*!< GPIO PADREGE: PAD17PULL (Bit 8)                       */
#define GPIO_PADREGE_PAD17PULL_Msk        (0x100UL)                 /*!< GPIO PADREGE: PAD17PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGE_PAD16FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGE: PAD16FNCSEL (Bit 3)                     */
#define GPIO_PADREGE_PAD16FNCSEL_Msk      (0x18UL)                  /*!< GPIO PADREGE: PAD16FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGE_PAD16STRNG_Pos       (2UL)                     /*!< GPIO PADREGE: PAD16STRNG (Bit 2)                      */
#define GPIO_PADREGE_PAD16STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGE: PAD16STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD16INPEN_Pos       (1UL)                     /*!< GPIO PADREGE: PAD16INPEN (Bit 1)                      */
#define GPIO_PADREGE_PAD16INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGE: PAD16INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGE_PAD16PULL_Pos        (0UL)                     /*!< GPIO PADREGE: PAD16PULL (Bit 0)                       */
#define GPIO_PADREGE_PAD16PULL_Msk        (0x1UL)                   /*!< GPIO PADREGE: PAD16PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGF  ======================================================== */
#define GPIO_PADREGF_PAD23FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGF: PAD23FNCSEL (Bit 27)                    */
#define GPIO_PADREGF_PAD23FNCSEL_Msk      (0x18000000UL)            /*!< GPIO PADREGF: PAD23FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGF_PAD23STRNG_Pos       (26UL)                    /*!< GPIO PADREGF: PAD23STRNG (Bit 26)                     */
#define GPIO_PADREGF_PAD23STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGF: PAD23STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD23INPEN_Pos       (25UL)                    /*!< GPIO PADREGF: PAD23INPEN (Bit 25)                     */
#define GPIO_PADREGF_PAD23INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGF: PAD23INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD23PULL_Pos        (24UL)                    /*!< GPIO PADREGF: PAD23PULL (Bit 24)                      */
#define GPIO_PADREGF_PAD23PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGF: PAD23PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGF_PAD22FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGF: PAD22FNCSEL (Bit 19)                    */
#define GPIO_PADREGF_PAD22FNCSEL_Msk      (0x180000UL)              /*!< GPIO PADREGF: PAD22FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGF_PAD22STRNG_Pos       (18UL)                    /*!< GPIO PADREGF: PAD22STRNG (Bit 18)                     */
#define GPIO_PADREGF_PAD22STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGF: PAD22STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD22INPEN_Pos       (17UL)                    /*!< GPIO PADREGF: PAD22INPEN (Bit 17)                     */
#define GPIO_PADREGF_PAD22INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGF: PAD22INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD22PULL_Pos        (16UL)                    /*!< GPIO PADREGF: PAD22PULL (Bit 16)                      */
#define GPIO_PADREGF_PAD22PULL_Msk        (0x10000UL)               /*!< GPIO PADREGF: PAD22PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGF_PAD21FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGF: PAD21FNCSEL (Bit 11)                    */
#define GPIO_PADREGF_PAD21FNCSEL_Msk      (0x1800UL)                /*!< GPIO PADREGF: PAD21FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGF_PAD21STRNG_Pos       (10UL)                    /*!< GPIO PADREGF: PAD21STRNG (Bit 10)                     */
#define GPIO_PADREGF_PAD21STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGF: PAD21STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD21INPEN_Pos       (9UL)                     /*!< GPIO PADREGF: PAD21INPEN (Bit 9)                      */
#define GPIO_PADREGF_PAD21INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGF: PAD21INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD21PULL_Pos        (8UL)                     /*!< GPIO PADREGF: PAD21PULL (Bit 8)                       */
#define GPIO_PADREGF_PAD21PULL_Msk        (0x100UL)                 /*!< GPIO PADREGF: PAD21PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGF_PAD20FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGF: PAD20FNCSEL (Bit 3)                     */
#define GPIO_PADREGF_PAD20FNCSEL_Msk      (0x18UL)                  /*!< GPIO PADREGF: PAD20FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGF_PAD20STRNG_Pos       (2UL)                     /*!< GPIO PADREGF: PAD20STRNG (Bit 2)                      */
#define GPIO_PADREGF_PAD20STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGF: PAD20STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD20INPEN_Pos       (1UL)                     /*!< GPIO PADREGF: PAD20INPEN (Bit 1)                      */
#define GPIO_PADREGF_PAD20INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGF: PAD20INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGF_PAD20PULL_Pos        (0UL)                     /*!< GPIO PADREGF: PAD20PULL (Bit 0)                       */
#define GPIO_PADREGF_PAD20PULL_Msk        (0x1UL)                   /*!< GPIO PADREGF: PAD20PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGG  ======================================================== */
#define GPIO_PADREGG_PAD27FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGG: PAD27FNCSEL (Bit 27)                    */
#define GPIO_PADREGG_PAD27FNCSEL_Msk      (0x18000000UL)            /*!< GPIO PADREGG: PAD27FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGG_PAD27STRNG_Pos       (26UL)                    /*!< GPIO PADREGG: PAD27STRNG (Bit 26)                     */
#define GPIO_PADREGG_PAD27STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGG: PAD27STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD27INPEN_Pos       (25UL)                    /*!< GPIO PADREGG: PAD27INPEN (Bit 25)                     */
#define GPIO_PADREGG_PAD27INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGG: PAD27INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD27PULL_Pos        (24UL)                    /*!< GPIO PADREGG: PAD27PULL (Bit 24)                      */
#define GPIO_PADREGG_PAD27PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGG: PAD27PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGG_PAD26FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGG: PAD26FNCSEL (Bit 19)                    */
#define GPIO_PADREGG_PAD26FNCSEL_Msk      (0x180000UL)              /*!< GPIO PADREGG: PAD26FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGG_PAD26STRNG_Pos       (18UL)                    /*!< GPIO PADREGG: PAD26STRNG (Bit 18)                     */
#define GPIO_PADREGG_PAD26STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGG: PAD26STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD26INPEN_Pos       (17UL)                    /*!< GPIO PADREGG: PAD26INPEN (Bit 17)                     */
#define GPIO_PADREGG_PAD26INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGG: PAD26INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD26PULL_Pos        (16UL)                    /*!< GPIO PADREGG: PAD26PULL (Bit 16)                      */
#define GPIO_PADREGG_PAD26PULL_Msk        (0x10000UL)               /*!< GPIO PADREGG: PAD26PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGG_PAD25FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGG: PAD25FNCSEL (Bit 11)                    */
#define GPIO_PADREGG_PAD25FNCSEL_Msk      (0x1800UL)                /*!< GPIO PADREGG: PAD25FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGG_PAD25STRNG_Pos       (10UL)                    /*!< GPIO PADREGG: PAD25STRNG (Bit 10)                     */
#define GPIO_PADREGG_PAD25STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGG: PAD25STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD25INPEN_Pos       (9UL)                     /*!< GPIO PADREGG: PAD25INPEN (Bit 9)                      */
#define GPIO_PADREGG_PAD25INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGG: PAD25INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD25PULL_Pos        (8UL)                     /*!< GPIO PADREGG: PAD25PULL (Bit 8)                       */
#define GPIO_PADREGG_PAD25PULL_Msk        (0x100UL)                 /*!< GPIO PADREGG: PAD25PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGG_PAD24FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGG: PAD24FNCSEL (Bit 3)                     */
#define GPIO_PADREGG_PAD24FNCSEL_Msk      (0x18UL)                  /*!< GPIO PADREGG: PAD24FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGG_PAD24STRNG_Pos       (2UL)                     /*!< GPIO PADREGG: PAD24STRNG (Bit 2)                      */
#define GPIO_PADREGG_PAD24STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGG: PAD24STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD24INPEN_Pos       (1UL)                     /*!< GPIO PADREGG: PAD24INPEN (Bit 1)                      */
#define GPIO_PADREGG_PAD24INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGG: PAD24INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGG_PAD24PULL_Pos        (0UL)                     /*!< GPIO PADREGG: PAD24PULL (Bit 0)                       */
#define GPIO_PADREGG_PAD24PULL_Msk        (0x1UL)                   /*!< GPIO PADREGG: PAD24PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGH  ======================================================== */
#define GPIO_PADREGH_PAD31FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGH: PAD31FNCSEL (Bit 27)                    */
#define GPIO_PADREGH_PAD31FNCSEL_Msk      (0x18000000UL)            /*!< GPIO PADREGH: PAD31FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGH_PAD31STRNG_Pos       (26UL)                    /*!< GPIO PADREGH: PAD31STRNG (Bit 26)                     */
#define GPIO_PADREGH_PAD31STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGH: PAD31STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD31INPEN_Pos       (25UL)                    /*!< GPIO PADREGH: PAD31INPEN (Bit 25)                     */
#define GPIO_PADREGH_PAD31INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGH: PAD31INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD31PULL_Pos        (24UL)                    /*!< GPIO PADREGH: PAD31PULL (Bit 24)                      */
#define GPIO_PADREGH_PAD31PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGH: PAD31PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGH_PAD30FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGH: PAD30FNCSEL (Bit 19)                    */
#define GPIO_PADREGH_PAD30FNCSEL_Msk      (0x180000UL)              /*!< GPIO PADREGH: PAD30FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGH_PAD30STRNG_Pos       (18UL)                    /*!< GPIO PADREGH: PAD30STRNG (Bit 18)                     */
#define GPIO_PADREGH_PAD30STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGH: PAD30STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD30INPEN_Pos       (17UL)                    /*!< GPIO PADREGH: PAD30INPEN (Bit 17)                     */
#define GPIO_PADREGH_PAD30INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGH: PAD30INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD30PULL_Pos        (16UL)                    /*!< GPIO PADREGH: PAD30PULL (Bit 16)                      */
#define GPIO_PADREGH_PAD30PULL_Msk        (0x10000UL)               /*!< GPIO PADREGH: PAD30PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGH_PAD29FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGH: PAD29FNCSEL (Bit 11)                    */
#define GPIO_PADREGH_PAD29FNCSEL_Msk      (0x1800UL)                /*!< GPIO PADREGH: PAD29FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGH_PAD29STRNG_Pos       (10UL)                    /*!< GPIO PADREGH: PAD29STRNG (Bit 10)                     */
#define GPIO_PADREGH_PAD29STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGH: PAD29STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD29INPEN_Pos       (9UL)                     /*!< GPIO PADREGH: PAD29INPEN (Bit 9)                      */
#define GPIO_PADREGH_PAD29INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGH: PAD29INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD29PULL_Pos        (8UL)                     /*!< GPIO PADREGH: PAD29PULL (Bit 8)                       */
#define GPIO_PADREGH_PAD29PULL_Msk        (0x100UL)                 /*!< GPIO PADREGH: PAD29PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGH_PAD28FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGH: PAD28FNCSEL (Bit 3)                     */
#define GPIO_PADREGH_PAD28FNCSEL_Msk      (0x18UL)                  /*!< GPIO PADREGH: PAD28FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGH_PAD28STRNG_Pos       (2UL)                     /*!< GPIO PADREGH: PAD28STRNG (Bit 2)                      */
#define GPIO_PADREGH_PAD28STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGH: PAD28STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD28INPEN_Pos       (1UL)                     /*!< GPIO PADREGH: PAD28INPEN (Bit 1)                      */
#define GPIO_PADREGH_PAD28INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGH: PAD28INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGH_PAD28PULL_Pos        (0UL)                     /*!< GPIO PADREGH: PAD28PULL (Bit 0)                       */
#define GPIO_PADREGH_PAD28PULL_Msk        (0x1UL)                   /*!< GPIO PADREGH: PAD28PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGI  ======================================================== */
#define GPIO_PADREGI_PAD35FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGI: PAD35FNCSEL (Bit 27)                    */
#define GPIO_PADREGI_PAD35FNCSEL_Msk      (0x18000000UL)            /*!< GPIO PADREGI: PAD35FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGI_PAD35STRNG_Pos       (26UL)                    /*!< GPIO PADREGI: PAD35STRNG (Bit 26)                     */
#define GPIO_PADREGI_PAD35STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGI: PAD35STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD35INPEN_Pos       (25UL)                    /*!< GPIO PADREGI: PAD35INPEN (Bit 25)                     */
#define GPIO_PADREGI_PAD35INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGI: PAD35INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD35PULL_Pos        (24UL)                    /*!< GPIO PADREGI: PAD35PULL (Bit 24)                      */
#define GPIO_PADREGI_PAD35PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGI: PAD35PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGI_PAD34FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGI: PAD34FNCSEL (Bit 19)                    */
#define GPIO_PADREGI_PAD34FNCSEL_Msk      (0x180000UL)              /*!< GPIO PADREGI: PAD34FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGI_PAD34STRNG_Pos       (18UL)                    /*!< GPIO PADREGI: PAD34STRNG (Bit 18)                     */
#define GPIO_PADREGI_PAD34STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGI: PAD34STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD34INPEN_Pos       (17UL)                    /*!< GPIO PADREGI: PAD34INPEN (Bit 17)                     */
#define GPIO_PADREGI_PAD34INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGI: PAD34INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD34PULL_Pos        (16UL)                    /*!< GPIO PADREGI: PAD34PULL (Bit 16)                      */
#define GPIO_PADREGI_PAD34PULL_Msk        (0x10000UL)               /*!< GPIO PADREGI: PAD34PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGI_PAD33FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGI: PAD33FNCSEL (Bit 11)                    */
#define GPIO_PADREGI_PAD33FNCSEL_Msk      (0x1800UL)                /*!< GPIO PADREGI: PAD33FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGI_PAD33STRNG_Pos       (10UL)                    /*!< GPIO PADREGI: PAD33STRNG (Bit 10)                     */
#define GPIO_PADREGI_PAD33STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGI: PAD33STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD33INPEN_Pos       (9UL)                     /*!< GPIO PADREGI: PAD33INPEN (Bit 9)                      */
#define GPIO_PADREGI_PAD33INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGI: PAD33INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD33PULL_Pos        (8UL)                     /*!< GPIO PADREGI: PAD33PULL (Bit 8)                       */
#define GPIO_PADREGI_PAD33PULL_Msk        (0x100UL)                 /*!< GPIO PADREGI: PAD33PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGI_PAD32FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGI: PAD32FNCSEL (Bit 3)                     */
#define GPIO_PADREGI_PAD32FNCSEL_Msk      (0x18UL)                  /*!< GPIO PADREGI: PAD32FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGI_PAD32STRNG_Pos       (2UL)                     /*!< GPIO PADREGI: PAD32STRNG (Bit 2)                      */
#define GPIO_PADREGI_PAD32STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGI: PAD32STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD32INPEN_Pos       (1UL)                     /*!< GPIO PADREGI: PAD32INPEN (Bit 1)                      */
#define GPIO_PADREGI_PAD32INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGI: PAD32INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGI_PAD32PULL_Pos        (0UL)                     /*!< GPIO PADREGI: PAD32PULL (Bit 0)                       */
#define GPIO_PADREGI_PAD32PULL_Msk        (0x1UL)                   /*!< GPIO PADREGI: PAD32PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGJ  ======================================================== */
#define GPIO_PADREGJ_PAD39FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGJ: PAD39FNCSEL (Bit 27)                    */
#define GPIO_PADREGJ_PAD39FNCSEL_Msk      (0x18000000UL)            /*!< GPIO PADREGJ: PAD39FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGJ_PAD39STRNG_Pos       (26UL)                    /*!< GPIO PADREGJ: PAD39STRNG (Bit 26)                     */
#define GPIO_PADREGJ_PAD39STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGJ: PAD39STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD39INPEN_Pos       (25UL)                    /*!< GPIO PADREGJ: PAD39INPEN (Bit 25)                     */
#define GPIO_PADREGJ_PAD39INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGJ: PAD39INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD39PULL_Pos        (24UL)                    /*!< GPIO PADREGJ: PAD39PULL (Bit 24)                      */
#define GPIO_PADREGJ_PAD39PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGJ: PAD39PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGJ_PAD38FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGJ: PAD38FNCSEL (Bit 19)                    */
#define GPIO_PADREGJ_PAD38FNCSEL_Msk      (0x180000UL)              /*!< GPIO PADREGJ: PAD38FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGJ_PAD38STRNG_Pos       (18UL)                    /*!< GPIO PADREGJ: PAD38STRNG (Bit 18)                     */
#define GPIO_PADREGJ_PAD38STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGJ: PAD38STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD38INPEN_Pos       (17UL)                    /*!< GPIO PADREGJ: PAD38INPEN (Bit 17)                     */
#define GPIO_PADREGJ_PAD38INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGJ: PAD38INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD38PULL_Pos        (16UL)                    /*!< GPIO PADREGJ: PAD38PULL (Bit 16)                      */
#define GPIO_PADREGJ_PAD38PULL_Msk        (0x10000UL)               /*!< GPIO PADREGJ: PAD38PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGJ_PAD37FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGJ: PAD37FNCSEL (Bit 11)                    */
#define GPIO_PADREGJ_PAD37FNCSEL_Msk      (0x1800UL)                /*!< GPIO PADREGJ: PAD37FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGJ_PAD37STRNG_Pos       (10UL)                    /*!< GPIO PADREGJ: PAD37STRNG (Bit 10)                     */
#define GPIO_PADREGJ_PAD37STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGJ: PAD37STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD37INPEN_Pos       (9UL)                     /*!< GPIO PADREGJ: PAD37INPEN (Bit 9)                      */
#define GPIO_PADREGJ_PAD37INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGJ: PAD37INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD37PULL_Pos        (8UL)                     /*!< GPIO PADREGJ: PAD37PULL (Bit 8)                       */
#define GPIO_PADREGJ_PAD37PULL_Msk        (0x100UL)                 /*!< GPIO PADREGJ: PAD37PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGJ_PAD36FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGJ: PAD36FNCSEL (Bit 3)                     */
#define GPIO_PADREGJ_PAD36FNCSEL_Msk      (0x18UL)                  /*!< GPIO PADREGJ: PAD36FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGJ_PAD36STRNG_Pos       (2UL)                     /*!< GPIO PADREGJ: PAD36STRNG (Bit 2)                      */
#define GPIO_PADREGJ_PAD36STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGJ: PAD36STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD36INPEN_Pos       (1UL)                     /*!< GPIO PADREGJ: PAD36INPEN (Bit 1)                      */
#define GPIO_PADREGJ_PAD36INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGJ: PAD36INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGJ_PAD36PULL_Pos        (0UL)                     /*!< GPIO PADREGJ: PAD36PULL (Bit 0)                       */
#define GPIO_PADREGJ_PAD36PULL_Msk        (0x1UL)                   /*!< GPIO PADREGJ: PAD36PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGK  ======================================================== */
#define GPIO_PADREGK_PAD43FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGK: PAD43FNCSEL (Bit 27)                    */
#define GPIO_PADREGK_PAD43FNCSEL_Msk      (0x18000000UL)            /*!< GPIO PADREGK: PAD43FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGK_PAD43STRNG_Pos       (26UL)                    /*!< GPIO PADREGK: PAD43STRNG (Bit 26)                     */
#define GPIO_PADREGK_PAD43STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGK: PAD43STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD43INPEN_Pos       (25UL)                    /*!< GPIO PADREGK: PAD43INPEN (Bit 25)                     */
#define GPIO_PADREGK_PAD43INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGK: PAD43INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD43PULL_Pos        (24UL)                    /*!< GPIO PADREGK: PAD43PULL (Bit 24)                      */
#define GPIO_PADREGK_PAD43PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGK: PAD43PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGK_PAD42FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGK: PAD42FNCSEL (Bit 19)                    */
#define GPIO_PADREGK_PAD42FNCSEL_Msk      (0x180000UL)              /*!< GPIO PADREGK: PAD42FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGK_PAD42STRNG_Pos       (18UL)                    /*!< GPIO PADREGK: PAD42STRNG (Bit 18)                     */
#define GPIO_PADREGK_PAD42STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGK: PAD42STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD42INPEN_Pos       (17UL)                    /*!< GPIO PADREGK: PAD42INPEN (Bit 17)                     */
#define GPIO_PADREGK_PAD42INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGK: PAD42INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD42PULL_Pos        (16UL)                    /*!< GPIO PADREGK: PAD42PULL (Bit 16)                      */
#define GPIO_PADREGK_PAD42PULL_Msk        (0x10000UL)               /*!< GPIO PADREGK: PAD42PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGK_PAD41FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGK: PAD41FNCSEL (Bit 11)                    */
#define GPIO_PADREGK_PAD41FNCSEL_Msk      (0x1800UL)                /*!< GPIO PADREGK: PAD41FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGK_PAD41STRNG_Pos       (10UL)                    /*!< GPIO PADREGK: PAD41STRNG (Bit 10)                     */
#define GPIO_PADREGK_PAD41STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGK: PAD41STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD41INPEN_Pos       (9UL)                     /*!< GPIO PADREGK: PAD41INPEN (Bit 9)                      */
#define GPIO_PADREGK_PAD41INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGK: PAD41INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD41PULL_Pos        (8UL)                     /*!< GPIO PADREGK: PAD41PULL (Bit 8)                       */
#define GPIO_PADREGK_PAD41PULL_Msk        (0x100UL)                 /*!< GPIO PADREGK: PAD41PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGK_PAD40FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGK: PAD40FNCSEL (Bit 3)                     */
#define GPIO_PADREGK_PAD40FNCSEL_Msk      (0x18UL)                  /*!< GPIO PADREGK: PAD40FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGK_PAD40STRNG_Pos       (2UL)                     /*!< GPIO PADREGK: PAD40STRNG (Bit 2)                      */
#define GPIO_PADREGK_PAD40STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGK: PAD40STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD40INPEN_Pos       (1UL)                     /*!< GPIO PADREGK: PAD40INPEN (Bit 1)                      */
#define GPIO_PADREGK_PAD40INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGK: PAD40INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGK_PAD40PULL_Pos        (0UL)                     /*!< GPIO PADREGK: PAD40PULL (Bit 0)                       */
#define GPIO_PADREGK_PAD40PULL_Msk        (0x1UL)                   /*!< GPIO PADREGK: PAD40PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGL  ======================================================== */
#define GPIO_PADREGL_PAD47FNCSEL_Pos      (27UL)                    /*!< GPIO PADREGL: PAD47FNCSEL (Bit 27)                    */
#define GPIO_PADREGL_PAD47FNCSEL_Msk      (0x18000000UL)            /*!< GPIO PADREGL: PAD47FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGL_PAD47STRNG_Pos       (26UL)                    /*!< GPIO PADREGL: PAD47STRNG (Bit 26)                     */
#define GPIO_PADREGL_PAD47STRNG_Msk       (0x4000000UL)             /*!< GPIO PADREGL: PAD47STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD47INPEN_Pos       (25UL)                    /*!< GPIO PADREGL: PAD47INPEN (Bit 25)                     */
#define GPIO_PADREGL_PAD47INPEN_Msk       (0x2000000UL)             /*!< GPIO PADREGL: PAD47INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD47PULL_Pos        (24UL)                    /*!< GPIO PADREGL: PAD47PULL (Bit 24)                      */
#define GPIO_PADREGL_PAD47PULL_Msk        (0x1000000UL)             /*!< GPIO PADREGL: PAD47PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGL_PAD46FNCSEL_Pos      (19UL)                    /*!< GPIO PADREGL: PAD46FNCSEL (Bit 19)                    */
#define GPIO_PADREGL_PAD46FNCSEL_Msk      (0x180000UL)              /*!< GPIO PADREGL: PAD46FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGL_PAD46STRNG_Pos       (18UL)                    /*!< GPIO PADREGL: PAD46STRNG (Bit 18)                     */
#define GPIO_PADREGL_PAD46STRNG_Msk       (0x40000UL)               /*!< GPIO PADREGL: PAD46STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD46INPEN_Pos       (17UL)                    /*!< GPIO PADREGL: PAD46INPEN (Bit 17)                     */
#define GPIO_PADREGL_PAD46INPEN_Msk       (0x20000UL)               /*!< GPIO PADREGL: PAD46INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD46PULL_Pos        (16UL)                    /*!< GPIO PADREGL: PAD46PULL (Bit 16)                      */
#define GPIO_PADREGL_PAD46PULL_Msk        (0x10000UL)               /*!< GPIO PADREGL: PAD46PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGL_PAD45FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGL: PAD45FNCSEL (Bit 11)                    */
#define GPIO_PADREGL_PAD45FNCSEL_Msk      (0x1800UL)                /*!< GPIO PADREGL: PAD45FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGL_PAD45STRNG_Pos       (10UL)                    /*!< GPIO PADREGL: PAD45STRNG (Bit 10)                     */
#define GPIO_PADREGL_PAD45STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGL: PAD45STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD45INPEN_Pos       (9UL)                     /*!< GPIO PADREGL: PAD45INPEN (Bit 9)                      */
#define GPIO_PADREGL_PAD45INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGL: PAD45INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD45PULL_Pos        (8UL)                     /*!< GPIO PADREGL: PAD45PULL (Bit 8)                       */
#define GPIO_PADREGL_PAD45PULL_Msk        (0x100UL)                 /*!< GPIO PADREGL: PAD45PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGL_PAD44FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGL: PAD44FNCSEL (Bit 3)                     */
#define GPIO_PADREGL_PAD44FNCSEL_Msk      (0x18UL)                  /*!< GPIO PADREGL: PAD44FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGL_PAD44STRNG_Pos       (2UL)                     /*!< GPIO PADREGL: PAD44STRNG (Bit 2)                      */
#define GPIO_PADREGL_PAD44STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGL: PAD44STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD44INPEN_Pos       (1UL)                     /*!< GPIO PADREGL: PAD44INPEN (Bit 1)                      */
#define GPIO_PADREGL_PAD44INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGL: PAD44INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGL_PAD44PULL_Pos        (0UL)                     /*!< GPIO PADREGL: PAD44PULL (Bit 0)                       */
#define GPIO_PADREGL_PAD44PULL_Msk        (0x1UL)                   /*!< GPIO PADREGL: PAD44PULL (Bitfield-Mask: 0x01)         */
/* ========================================================  PADREGM  ======================================================== */
#define GPIO_PADREGM_PAD49FNCSEL_Pos      (11UL)                    /*!< GPIO PADREGM: PAD49FNCSEL (Bit 11)                    */
#define GPIO_PADREGM_PAD49FNCSEL_Msk      (0x1800UL)                /*!< GPIO PADREGM: PAD49FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGM_PAD49STRNG_Pos       (10UL)                    /*!< GPIO PADREGM: PAD49STRNG (Bit 10)                     */
#define GPIO_PADREGM_PAD49STRNG_Msk       (0x400UL)                 /*!< GPIO PADREGM: PAD49STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGM_PAD49INPEN_Pos       (9UL)                     /*!< GPIO PADREGM: PAD49INPEN (Bit 9)                      */
#define GPIO_PADREGM_PAD49INPEN_Msk       (0x200UL)                 /*!< GPIO PADREGM: PAD49INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGM_PAD49PULL_Pos        (8UL)                     /*!< GPIO PADREGM: PAD49PULL (Bit 8)                       */
#define GPIO_PADREGM_PAD49PULL_Msk        (0x100UL)                 /*!< GPIO PADREGM: PAD49PULL (Bitfield-Mask: 0x01)         */
#define GPIO_PADREGM_PAD48FNCSEL_Pos      (3UL)                     /*!< GPIO PADREGM: PAD48FNCSEL (Bit 3)                     */
#define GPIO_PADREGM_PAD48FNCSEL_Msk      (0x18UL)                  /*!< GPIO PADREGM: PAD48FNCSEL (Bitfield-Mask: 0x03)       */
#define GPIO_PADREGM_PAD48STRNG_Pos       (2UL)                     /*!< GPIO PADREGM: PAD48STRNG (Bit 2)                      */
#define GPIO_PADREGM_PAD48STRNG_Msk       (0x4UL)                   /*!< GPIO PADREGM: PAD48STRNG (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGM_PAD48INPEN_Pos       (1UL)                     /*!< GPIO PADREGM: PAD48INPEN (Bit 1)                      */
#define GPIO_PADREGM_PAD48INPEN_Msk       (0x2UL)                   /*!< GPIO PADREGM: PAD48INPEN (Bitfield-Mask: 0x01)        */
#define GPIO_PADREGM_PAD48PULL_Pos        (0UL)                     /*!< GPIO PADREGM: PAD48PULL (Bit 0)                       */
#define GPIO_PADREGM_PAD48PULL_Msk        (0x1UL)                   /*!< GPIO PADREGM: PAD48PULL (Bitfield-Mask: 0x01)         */
/* =========================================================  CFGA  ========================================================== */
#define GPIO_CFGA_GPIO7INTD_Pos           (31UL)                    /*!< GPIO CFGA: GPIO7INTD (Bit 31)                         */
#define GPIO_CFGA_GPIO7INTD_Msk           (0x80000000UL)            /*!< GPIO CFGA: GPIO7INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO7OUTCFG_Pos         (29UL)                    /*!< GPIO CFGA: GPIO7OUTCFG (Bit 29)                       */
#define GPIO_CFGA_GPIO7OUTCFG_Msk         (0x60000000UL)            /*!< GPIO CFGA: GPIO7OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO7INCFG_Pos          (28UL)                    /*!< GPIO CFGA: GPIO7INCFG (Bit 28)                        */
#define GPIO_CFGA_GPIO7INCFG_Msk          (0x10000000UL)            /*!< GPIO CFGA: GPIO7INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO6INTD_Pos           (27UL)                    /*!< GPIO CFGA: GPIO6INTD (Bit 27)                         */
#define GPIO_CFGA_GPIO6INTD_Msk           (0x8000000UL)             /*!< GPIO CFGA: GPIO6INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO6OUTCFG_Pos         (25UL)                    /*!< GPIO CFGA: GPIO6OUTCFG (Bit 25)                       */
#define GPIO_CFGA_GPIO6OUTCFG_Msk         (0x6000000UL)             /*!< GPIO CFGA: GPIO6OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO6INCFG_Pos          (24UL)                    /*!< GPIO CFGA: GPIO6INCFG (Bit 24)                        */
#define GPIO_CFGA_GPIO6INCFG_Msk          (0x1000000UL)             /*!< GPIO CFGA: GPIO6INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO5INTD_Pos           (23UL)                    /*!< GPIO CFGA: GPIO5INTD (Bit 23)                         */
#define GPIO_CFGA_GPIO5INTD_Msk           (0x800000UL)              /*!< GPIO CFGA: GPIO5INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO5OUTCFG_Pos         (21UL)                    /*!< GPIO CFGA: GPIO5OUTCFG (Bit 21)                       */
#define GPIO_CFGA_GPIO5OUTCFG_Msk         (0x600000UL)              /*!< GPIO CFGA: GPIO5OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO5INCFG_Pos          (20UL)                    /*!< GPIO CFGA: GPIO5INCFG (Bit 20)                        */
#define GPIO_CFGA_GPIO5INCFG_Msk          (0x100000UL)              /*!< GPIO CFGA: GPIO5INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO4INTD_Pos           (19UL)                    /*!< GPIO CFGA: GPIO4INTD (Bit 19)                         */
#define GPIO_CFGA_GPIO4INTD_Msk           (0x80000UL)               /*!< GPIO CFGA: GPIO4INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO4OUTCFG_Pos         (17UL)                    /*!< GPIO CFGA: GPIO4OUTCFG (Bit 17)                       */
#define GPIO_CFGA_GPIO4OUTCFG_Msk         (0x60000UL)               /*!< GPIO CFGA: GPIO4OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO4INCFG_Pos          (16UL)                    /*!< GPIO CFGA: GPIO4INCFG (Bit 16)                        */
#define GPIO_CFGA_GPIO4INCFG_Msk          (0x10000UL)               /*!< GPIO CFGA: GPIO4INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO3INTD_Pos           (15UL)                    /*!< GPIO CFGA: GPIO3INTD (Bit 15)                         */
#define GPIO_CFGA_GPIO3INTD_Msk           (0x8000UL)                /*!< GPIO CFGA: GPIO3INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO3OUTCFG_Pos         (13UL)                    /*!< GPIO CFGA: GPIO3OUTCFG (Bit 13)                       */
#define GPIO_CFGA_GPIO3OUTCFG_Msk         (0x6000UL)                /*!< GPIO CFGA: GPIO3OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO3INCFG_Pos          (12UL)                    /*!< GPIO CFGA: GPIO3INCFG (Bit 12)                        */
#define GPIO_CFGA_GPIO3INCFG_Msk          (0x1000UL)                /*!< GPIO CFGA: GPIO3INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO2INTD_Pos           (11UL)                    /*!< GPIO CFGA: GPIO2INTD (Bit 11)                         */
#define GPIO_CFGA_GPIO2INTD_Msk           (0x800UL)                 /*!< GPIO CFGA: GPIO2INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO2OUTCFG_Pos         (9UL)                     /*!< GPIO CFGA: GPIO2OUTCFG (Bit 9)                        */
#define GPIO_CFGA_GPIO2OUTCFG_Msk         (0x600UL)                 /*!< GPIO CFGA: GPIO2OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO2INCFG_Pos          (8UL)                     /*!< GPIO CFGA: GPIO2INCFG (Bit 8)                         */
#define GPIO_CFGA_GPIO2INCFG_Msk          (0x100UL)                 /*!< GPIO CFGA: GPIO2INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO1INTD_Pos           (7UL)                     /*!< GPIO CFGA: GPIO1INTD (Bit 7)                          */
#define GPIO_CFGA_GPIO1INTD_Msk           (0x80UL)                  /*!< GPIO CFGA: GPIO1INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO1OUTCFG_Pos         (5UL)                     /*!< GPIO CFGA: GPIO1OUTCFG (Bit 5)                        */
#define GPIO_CFGA_GPIO1OUTCFG_Msk         (0x60UL)                  /*!< GPIO CFGA: GPIO1OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO1INCFG_Pos          (4UL)                     /*!< GPIO CFGA: GPIO1INCFG (Bit 4)                         */
#define GPIO_CFGA_GPIO1INCFG_Msk          (0x10UL)                  /*!< GPIO CFGA: GPIO1INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGA_GPIO0INTD_Pos           (3UL)                     /*!< GPIO CFGA: GPIO0INTD (Bit 3)                          */
#define GPIO_CFGA_GPIO0INTD_Msk           (0x8UL)                   /*!< GPIO CFGA: GPIO0INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGA_GPIO0OUTCFG_Pos         (1UL)                     /*!< GPIO CFGA: GPIO0OUTCFG (Bit 1)                        */
#define GPIO_CFGA_GPIO0OUTCFG_Msk         (0x6UL)                   /*!< GPIO CFGA: GPIO0OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGA_GPIO0INCFG_Pos          (0UL)                     /*!< GPIO CFGA: GPIO0INCFG (Bit 0)                         */
#define GPIO_CFGA_GPIO0INCFG_Msk          (0x1UL)                   /*!< GPIO CFGA: GPIO0INCFG (Bitfield-Mask: 0x01)           */
/* =========================================================  CFGB  ========================================================== */
#define GPIO_CFGB_GPIO15INTD_Pos          (31UL)                    /*!< GPIO CFGB: GPIO15INTD (Bit 31)                        */
#define GPIO_CFGB_GPIO15INTD_Msk          (0x80000000UL)            /*!< GPIO CFGB: GPIO15INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO15OUTCFG_Pos        (29UL)                    /*!< GPIO CFGB: GPIO15OUTCFG (Bit 29)                      */
#define GPIO_CFGB_GPIO15OUTCFG_Msk        (0x60000000UL)            /*!< GPIO CFGB: GPIO15OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGB_GPIO15INCFG_Pos         (28UL)                    /*!< GPIO CFGB: GPIO15INCFG (Bit 28)                       */
#define GPIO_CFGB_GPIO15INCFG_Msk         (0x10000000UL)            /*!< GPIO CFGB: GPIO15INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGB_GPIO14INTD_Pos          (27UL)                    /*!< GPIO CFGB: GPIO14INTD (Bit 27)                        */
#define GPIO_CFGB_GPIO14INTD_Msk          (0x8000000UL)             /*!< GPIO CFGB: GPIO14INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO14OUTCFG_Pos        (25UL)                    /*!< GPIO CFGB: GPIO14OUTCFG (Bit 25)                      */
#define GPIO_CFGB_GPIO14OUTCFG_Msk        (0x6000000UL)             /*!< GPIO CFGB: GPIO14OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGB_GPIO14INCFG_Pos         (24UL)                    /*!< GPIO CFGB: GPIO14INCFG (Bit 24)                       */
#define GPIO_CFGB_GPIO14INCFG_Msk         (0x1000000UL)             /*!< GPIO CFGB: GPIO14INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGB_GPIO13INTD_Pos          (23UL)                    /*!< GPIO CFGB: GPIO13INTD (Bit 23)                        */
#define GPIO_CFGB_GPIO13INTD_Msk          (0x800000UL)              /*!< GPIO CFGB: GPIO13INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO13OUTCFG_Pos        (21UL)                    /*!< GPIO CFGB: GPIO13OUTCFG (Bit 21)                      */
#define GPIO_CFGB_GPIO13OUTCFG_Msk        (0x600000UL)              /*!< GPIO CFGB: GPIO13OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGB_GPIO13INCFG_Pos         (20UL)                    /*!< GPIO CFGB: GPIO13INCFG (Bit 20)                       */
#define GPIO_CFGB_GPIO13INCFG_Msk         (0x100000UL)              /*!< GPIO CFGB: GPIO13INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGB_GPIO12INTD_Pos          (19UL)                    /*!< GPIO CFGB: GPIO12INTD (Bit 19)                        */
#define GPIO_CFGB_GPIO12INTD_Msk          (0x80000UL)               /*!< GPIO CFGB: GPIO12INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO12OUTCFG_Pos        (17UL)                    /*!< GPIO CFGB: GPIO12OUTCFG (Bit 17)                      */
#define GPIO_CFGB_GPIO12OUTCFG_Msk        (0x60000UL)               /*!< GPIO CFGB: GPIO12OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGB_GPIO12INCFG_Pos         (16UL)                    /*!< GPIO CFGB: GPIO12INCFG (Bit 16)                       */
#define GPIO_CFGB_GPIO12INCFG_Msk         (0x10000UL)               /*!< GPIO CFGB: GPIO12INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGB_GPIO11INTD_Pos          (15UL)                    /*!< GPIO CFGB: GPIO11INTD (Bit 15)                        */
#define GPIO_CFGB_GPIO11INTD_Msk          (0x8000UL)                /*!< GPIO CFGB: GPIO11INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO11OUTCFG_Pos        (13UL)                    /*!< GPIO CFGB: GPIO11OUTCFG (Bit 13)                      */
#define GPIO_CFGB_GPIO11OUTCFG_Msk        (0x6000UL)                /*!< GPIO CFGB: GPIO11OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGB_GPIO11INCFG_Pos         (12UL)                    /*!< GPIO CFGB: GPIO11INCFG (Bit 12)                       */
#define GPIO_CFGB_GPIO11INCFG_Msk         (0x1000UL)                /*!< GPIO CFGB: GPIO11INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGB_GPIO10INTD_Pos          (11UL)                    /*!< GPIO CFGB: GPIO10INTD (Bit 11)                        */
#define GPIO_CFGB_GPIO10INTD_Msk          (0x800UL)                 /*!< GPIO CFGB: GPIO10INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO10OUTCFG_Pos        (9UL)                     /*!< GPIO CFGB: GPIO10OUTCFG (Bit 9)                       */
#define GPIO_CFGB_GPIO10OUTCFG_Msk        (0x600UL)                 /*!< GPIO CFGB: GPIO10OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGB_GPIO10INCFG_Pos         (8UL)                     /*!< GPIO CFGB: GPIO10INCFG (Bit 8)                        */
#define GPIO_CFGB_GPIO10INCFG_Msk         (0x100UL)                 /*!< GPIO CFGB: GPIO10INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGB_GPIO9INTD_Pos           (7UL)                     /*!< GPIO CFGB: GPIO9INTD (Bit 7)                          */
#define GPIO_CFGB_GPIO9INTD_Msk           (0x80UL)                  /*!< GPIO CFGB: GPIO9INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGB_GPIO9OUTCFG_Pos         (5UL)                     /*!< GPIO CFGB: GPIO9OUTCFG (Bit 5)                        */
#define GPIO_CFGB_GPIO9OUTCFG_Msk         (0x60UL)                  /*!< GPIO CFGB: GPIO9OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGB_GPIO9INCFG_Pos          (4UL)                     /*!< GPIO CFGB: GPIO9INCFG (Bit 4)                         */
#define GPIO_CFGB_GPIO9INCFG_Msk          (0x10UL)                  /*!< GPIO CFGB: GPIO9INCFG (Bitfield-Mask: 0x01)           */
#define GPIO_CFGB_GPIO8INTD_Pos           (3UL)                     /*!< GPIO CFGB: GPIO8INTD (Bit 3)                          */
#define GPIO_CFGB_GPIO8INTD_Msk           (0x8UL)                   /*!< GPIO CFGB: GPIO8INTD (Bitfield-Mask: 0x01)            */
#define GPIO_CFGB_GPIO8OUTCFG_Pos         (1UL)                     /*!< GPIO CFGB: GPIO8OUTCFG (Bit 1)                        */
#define GPIO_CFGB_GPIO8OUTCFG_Msk         (0x6UL)                   /*!< GPIO CFGB: GPIO8OUTCFG (Bitfield-Mask: 0x03)          */
#define GPIO_CFGB_GPIO8INCFG_Pos          (0UL)                     /*!< GPIO CFGB: GPIO8INCFG (Bit 0)                         */
#define GPIO_CFGB_GPIO8INCFG_Msk          (0x1UL)                   /*!< GPIO CFGB: GPIO8INCFG (Bitfield-Mask: 0x01)           */
/* =========================================================  CFGC  ========================================================== */
#define GPIO_CFGC_GPIO23INTD_Pos          (31UL)                    /*!< GPIO CFGC: GPIO23INTD (Bit 31)                        */
#define GPIO_CFGC_GPIO23INTD_Msk          (0x80000000UL)            /*!< GPIO CFGC: GPIO23INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO23OUTCFG_Pos        (29UL)                    /*!< GPIO CFGC: GPIO23OUTCFG (Bit 29)                      */
#define GPIO_CFGC_GPIO23OUTCFG_Msk        (0x60000000UL)            /*!< GPIO CFGC: GPIO23OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO23INCFG_Pos         (28UL)                    /*!< GPIO CFGC: GPIO23INCFG (Bit 28)                       */
#define GPIO_CFGC_GPIO23INCFG_Msk         (0x10000000UL)            /*!< GPIO CFGC: GPIO23INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO22INTD_Pos          (27UL)                    /*!< GPIO CFGC: GPIO22INTD (Bit 27)                        */
#define GPIO_CFGC_GPIO22INTD_Msk          (0x8000000UL)             /*!< GPIO CFGC: GPIO22INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO22OUTCFG_Pos        (25UL)                    /*!< GPIO CFGC: GPIO22OUTCFG (Bit 25)                      */
#define GPIO_CFGC_GPIO22OUTCFG_Msk        (0x6000000UL)             /*!< GPIO CFGC: GPIO22OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO22INCFG_Pos         (24UL)                    /*!< GPIO CFGC: GPIO22INCFG (Bit 24)                       */
#define GPIO_CFGC_GPIO22INCFG_Msk         (0x1000000UL)             /*!< GPIO CFGC: GPIO22INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO21INTD_Pos          (23UL)                    /*!< GPIO CFGC: GPIO21INTD (Bit 23)                        */
#define GPIO_CFGC_GPIO21INTD_Msk          (0x800000UL)              /*!< GPIO CFGC: GPIO21INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO21OUTCFG_Pos        (21UL)                    /*!< GPIO CFGC: GPIO21OUTCFG (Bit 21)                      */
#define GPIO_CFGC_GPIO21OUTCFG_Msk        (0x600000UL)              /*!< GPIO CFGC: GPIO21OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO21INCFG_Pos         (20UL)                    /*!< GPIO CFGC: GPIO21INCFG (Bit 20)                       */
#define GPIO_CFGC_GPIO21INCFG_Msk         (0x100000UL)              /*!< GPIO CFGC: GPIO21INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO20INTD_Pos          (19UL)                    /*!< GPIO CFGC: GPIO20INTD (Bit 19)                        */
#define GPIO_CFGC_GPIO20INTD_Msk          (0x80000UL)               /*!< GPIO CFGC: GPIO20INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO20OUTCFG_Pos        (17UL)                    /*!< GPIO CFGC: GPIO20OUTCFG (Bit 17)                      */
#define GPIO_CFGC_GPIO20OUTCFG_Msk        (0x60000UL)               /*!< GPIO CFGC: GPIO20OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO20INCFG_Pos         (16UL)                    /*!< GPIO CFGC: GPIO20INCFG (Bit 16)                       */
#define GPIO_CFGC_GPIO20INCFG_Msk         (0x10000UL)               /*!< GPIO CFGC: GPIO20INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO19INTD_Pos          (15UL)                    /*!< GPIO CFGC: GPIO19INTD (Bit 15)                        */
#define GPIO_CFGC_GPIO19INTD_Msk          (0x8000UL)                /*!< GPIO CFGC: GPIO19INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO19OUTCFG_Pos        (13UL)                    /*!< GPIO CFGC: GPIO19OUTCFG (Bit 13)                      */
#define GPIO_CFGC_GPIO19OUTCFG_Msk        (0x6000UL)                /*!< GPIO CFGC: GPIO19OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO19INCFG_Pos         (12UL)                    /*!< GPIO CFGC: GPIO19INCFG (Bit 12)                       */
#define GPIO_CFGC_GPIO19INCFG_Msk         (0x1000UL)                /*!< GPIO CFGC: GPIO19INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO18INTD_Pos          (11UL)                    /*!< GPIO CFGC: GPIO18INTD (Bit 11)                        */
#define GPIO_CFGC_GPIO18INTD_Msk          (0x800UL)                 /*!< GPIO CFGC: GPIO18INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO18OUTCFG_Pos        (9UL)                     /*!< GPIO CFGC: GPIO18OUTCFG (Bit 9)                       */
#define GPIO_CFGC_GPIO18OUTCFG_Msk        (0x600UL)                 /*!< GPIO CFGC: GPIO18OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO18INCFG_Pos         (8UL)                     /*!< GPIO CFGC: GPIO18INCFG (Bit 8)                        */
#define GPIO_CFGC_GPIO18INCFG_Msk         (0x100UL)                 /*!< GPIO CFGC: GPIO18INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO17INTD_Pos          (7UL)                     /*!< GPIO CFGC: GPIO17INTD (Bit 7)                         */
#define GPIO_CFGC_GPIO17INTD_Msk          (0x80UL)                  /*!< GPIO CFGC: GPIO17INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO17OUTCFG_Pos        (5UL)                     /*!< GPIO CFGC: GPIO17OUTCFG (Bit 5)                       */
#define GPIO_CFGC_GPIO17OUTCFG_Msk        (0x60UL)                  /*!< GPIO CFGC: GPIO17OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO17INCFG_Pos         (4UL)                     /*!< GPIO CFGC: GPIO17INCFG (Bit 4)                        */
#define GPIO_CFGC_GPIO17INCFG_Msk         (0x10UL)                  /*!< GPIO CFGC: GPIO17INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGC_GPIO16INTD_Pos          (3UL)                     /*!< GPIO CFGC: GPIO16INTD (Bit 3)                         */
#define GPIO_CFGC_GPIO16INTD_Msk          (0x8UL)                   /*!< GPIO CFGC: GPIO16INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGC_GPIO16OUTCFG_Pos        (1UL)                     /*!< GPIO CFGC: GPIO16OUTCFG (Bit 1)                       */
#define GPIO_CFGC_GPIO16OUTCFG_Msk        (0x6UL)                   /*!< GPIO CFGC: GPIO16OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGC_GPIO16INCFG_Pos         (0UL)                     /*!< GPIO CFGC: GPIO16INCFG (Bit 0)                        */
#define GPIO_CFGC_GPIO16INCFG_Msk         (0x1UL)                   /*!< GPIO CFGC: GPIO16INCFG (Bitfield-Mask: 0x01)          */
/* =========================================================  CFGD  ========================================================== */
#define GPIO_CFGD_GPIO31INTD_Pos          (31UL)                    /*!< GPIO CFGD: GPIO31INTD (Bit 31)                        */
#define GPIO_CFGD_GPIO31INTD_Msk          (0x80000000UL)            /*!< GPIO CFGD: GPIO31INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO31OUTCFG_Pos        (29UL)                    /*!< GPIO CFGD: GPIO31OUTCFG (Bit 29)                      */
#define GPIO_CFGD_GPIO31OUTCFG_Msk        (0x60000000UL)            /*!< GPIO CFGD: GPIO31OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO31INCFG_Pos         (28UL)                    /*!< GPIO CFGD: GPIO31INCFG (Bit 28)                       */
#define GPIO_CFGD_GPIO31INCFG_Msk         (0x10000000UL)            /*!< GPIO CFGD: GPIO31INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO30INTD_Pos          (27UL)                    /*!< GPIO CFGD: GPIO30INTD (Bit 27)                        */
#define GPIO_CFGD_GPIO30INTD_Msk          (0x8000000UL)             /*!< GPIO CFGD: GPIO30INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO30OUTCFG_Pos        (25UL)                    /*!< GPIO CFGD: GPIO30OUTCFG (Bit 25)                      */
#define GPIO_CFGD_GPIO30OUTCFG_Msk        (0x6000000UL)             /*!< GPIO CFGD: GPIO30OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO30INCFG_Pos         (24UL)                    /*!< GPIO CFGD: GPIO30INCFG (Bit 24)                       */
#define GPIO_CFGD_GPIO30INCFG_Msk         (0x1000000UL)             /*!< GPIO CFGD: GPIO30INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO29INTD_Pos          (23UL)                    /*!< GPIO CFGD: GPIO29INTD (Bit 23)                        */
#define GPIO_CFGD_GPIO29INTD_Msk          (0x800000UL)              /*!< GPIO CFGD: GPIO29INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO29OUTCFG_Pos        (21UL)                    /*!< GPIO CFGD: GPIO29OUTCFG (Bit 21)                      */
#define GPIO_CFGD_GPIO29OUTCFG_Msk        (0x600000UL)              /*!< GPIO CFGD: GPIO29OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO29INCFG_Pos         (20UL)                    /*!< GPIO CFGD: GPIO29INCFG (Bit 20)                       */
#define GPIO_CFGD_GPIO29INCFG_Msk         (0x100000UL)              /*!< GPIO CFGD: GPIO29INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO28INTD_Pos          (19UL)                    /*!< GPIO CFGD: GPIO28INTD (Bit 19)                        */
#define GPIO_CFGD_GPIO28INTD_Msk          (0x80000UL)               /*!< GPIO CFGD: GPIO28INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO28OUTCFG_Pos        (17UL)                    /*!< GPIO CFGD: GPIO28OUTCFG (Bit 17)                      */
#define GPIO_CFGD_GPIO28OUTCFG_Msk        (0x60000UL)               /*!< GPIO CFGD: GPIO28OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO28INCFG_Pos         (16UL)                    /*!< GPIO CFGD: GPIO28INCFG (Bit 16)                       */
#define GPIO_CFGD_GPIO28INCFG_Msk         (0x10000UL)               /*!< GPIO CFGD: GPIO28INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO27INTD_Pos          (15UL)                    /*!< GPIO CFGD: GPIO27INTD (Bit 15)                        */
#define GPIO_CFGD_GPIO27INTD_Msk          (0x8000UL)                /*!< GPIO CFGD: GPIO27INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO27OUTCFG_Pos        (13UL)                    /*!< GPIO CFGD: GPIO27OUTCFG (Bit 13)                      */
#define GPIO_CFGD_GPIO27OUTCFG_Msk        (0x6000UL)                /*!< GPIO CFGD: GPIO27OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO27INCFG_Pos         (12UL)                    /*!< GPIO CFGD: GPIO27INCFG (Bit 12)                       */
#define GPIO_CFGD_GPIO27INCFG_Msk         (0x1000UL)                /*!< GPIO CFGD: GPIO27INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO26INTD_Pos          (11UL)                    /*!< GPIO CFGD: GPIO26INTD (Bit 11)                        */
#define GPIO_CFGD_GPIO26INTD_Msk          (0x800UL)                 /*!< GPIO CFGD: GPIO26INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO26OUTCFG_Pos        (9UL)                     /*!< GPIO CFGD: GPIO26OUTCFG (Bit 9)                       */
#define GPIO_CFGD_GPIO26OUTCFG_Msk        (0x600UL)                 /*!< GPIO CFGD: GPIO26OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO26INCFG_Pos         (8UL)                     /*!< GPIO CFGD: GPIO26INCFG (Bit 8)                        */
#define GPIO_CFGD_GPIO26INCFG_Msk         (0x100UL)                 /*!< GPIO CFGD: GPIO26INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO25INTD_Pos          (7UL)                     /*!< GPIO CFGD: GPIO25INTD (Bit 7)                         */
#define GPIO_CFGD_GPIO25INTD_Msk          (0x80UL)                  /*!< GPIO CFGD: GPIO25INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO25OUTCFG_Pos        (5UL)                     /*!< GPIO CFGD: GPIO25OUTCFG (Bit 5)                       */
#define GPIO_CFGD_GPIO25OUTCFG_Msk        (0x60UL)                  /*!< GPIO CFGD: GPIO25OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO25INCFG_Pos         (4UL)                     /*!< GPIO CFGD: GPIO25INCFG (Bit 4)                        */
#define GPIO_CFGD_GPIO25INCFG_Msk         (0x10UL)                  /*!< GPIO CFGD: GPIO25INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGD_GPIO24INTD_Pos          (3UL)                     /*!< GPIO CFGD: GPIO24INTD (Bit 3)                         */
#define GPIO_CFGD_GPIO24INTD_Msk          (0x8UL)                   /*!< GPIO CFGD: GPIO24INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGD_GPIO24OUTCFG_Pos        (1UL)                     /*!< GPIO CFGD: GPIO24OUTCFG (Bit 1)                       */
#define GPIO_CFGD_GPIO24OUTCFG_Msk        (0x6UL)                   /*!< GPIO CFGD: GPIO24OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGD_GPIO24INCFG_Pos         (0UL)                     /*!< GPIO CFGD: GPIO24INCFG (Bit 0)                        */
#define GPIO_CFGD_GPIO24INCFG_Msk         (0x1UL)                   /*!< GPIO CFGD: GPIO24INCFG (Bitfield-Mask: 0x01)          */
/* =========================================================  CFGE  ========================================================== */
#define GPIO_CFGE_GPIO39INTD_Pos          (31UL)                    /*!< GPIO CFGE: GPIO39INTD (Bit 31)                        */
#define GPIO_CFGE_GPIO39INTD_Msk          (0x80000000UL)            /*!< GPIO CFGE: GPIO39INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO39OUTCFG_Pos        (29UL)                    /*!< GPIO CFGE: GPIO39OUTCFG (Bit 29)                      */
#define GPIO_CFGE_GPIO39OUTCFG_Msk        (0x60000000UL)            /*!< GPIO CFGE: GPIO39OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO39INCFG_Pos         (28UL)                    /*!< GPIO CFGE: GPIO39INCFG (Bit 28)                       */
#define GPIO_CFGE_GPIO39INCFG_Msk         (0x10000000UL)            /*!< GPIO CFGE: GPIO39INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO38INTD_Pos          (27UL)                    /*!< GPIO CFGE: GPIO38INTD (Bit 27)                        */
#define GPIO_CFGE_GPIO38INTD_Msk          (0x8000000UL)             /*!< GPIO CFGE: GPIO38INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO38OUTCFG_Pos        (25UL)                    /*!< GPIO CFGE: GPIO38OUTCFG (Bit 25)                      */
#define GPIO_CFGE_GPIO38OUTCFG_Msk        (0x6000000UL)             /*!< GPIO CFGE: GPIO38OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO38INCFG_Pos         (24UL)                    /*!< GPIO CFGE: GPIO38INCFG (Bit 24)                       */
#define GPIO_CFGE_GPIO38INCFG_Msk         (0x1000000UL)             /*!< GPIO CFGE: GPIO38INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO37INTD_Pos          (23UL)                    /*!< GPIO CFGE: GPIO37INTD (Bit 23)                        */
#define GPIO_CFGE_GPIO37INTD_Msk          (0x800000UL)              /*!< GPIO CFGE: GPIO37INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO37OUTCFG_Pos        (21UL)                    /*!< GPIO CFGE: GPIO37OUTCFG (Bit 21)                      */
#define GPIO_CFGE_GPIO37OUTCFG_Msk        (0x600000UL)              /*!< GPIO CFGE: GPIO37OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO37INCFG_Pos         (20UL)                    /*!< GPIO CFGE: GPIO37INCFG (Bit 20)                       */
#define GPIO_CFGE_GPIO37INCFG_Msk         (0x100000UL)              /*!< GPIO CFGE: GPIO37INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO36INTD_Pos          (19UL)                    /*!< GPIO CFGE: GPIO36INTD (Bit 19)                        */
#define GPIO_CFGE_GPIO36INTD_Msk          (0x80000UL)               /*!< GPIO CFGE: GPIO36INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO36OUTCFG_Pos        (17UL)                    /*!< GPIO CFGE: GPIO36OUTCFG (Bit 17)                      */
#define GPIO_CFGE_GPIO36OUTCFG_Msk        (0x60000UL)               /*!< GPIO CFGE: GPIO36OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO36INCFG_Pos         (16UL)                    /*!< GPIO CFGE: GPIO36INCFG (Bit 16)                       */
#define GPIO_CFGE_GPIO36INCFG_Msk         (0x10000UL)               /*!< GPIO CFGE: GPIO36INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO35INTD_Pos          (15UL)                    /*!< GPIO CFGE: GPIO35INTD (Bit 15)                        */
#define GPIO_CFGE_GPIO35INTD_Msk          (0x8000UL)                /*!< GPIO CFGE: GPIO35INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO35OUTCFG_Pos        (13UL)                    /*!< GPIO CFGE: GPIO35OUTCFG (Bit 13)                      */
#define GPIO_CFGE_GPIO35OUTCFG_Msk        (0x6000UL)                /*!< GPIO CFGE: GPIO35OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO35INCFG_Pos         (12UL)                    /*!< GPIO CFGE: GPIO35INCFG (Bit 12)                       */
#define GPIO_CFGE_GPIO35INCFG_Msk         (0x1000UL)                /*!< GPIO CFGE: GPIO35INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO34INTD_Pos          (11UL)                    /*!< GPIO CFGE: GPIO34INTD (Bit 11)                        */
#define GPIO_CFGE_GPIO34INTD_Msk          (0x800UL)                 /*!< GPIO CFGE: GPIO34INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO34OUTCFG_Pos        (9UL)                     /*!< GPIO CFGE: GPIO34OUTCFG (Bit 9)                       */
#define GPIO_CFGE_GPIO34OUTCFG_Msk        (0x600UL)                 /*!< GPIO CFGE: GPIO34OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO34INCFG_Pos         (8UL)                     /*!< GPIO CFGE: GPIO34INCFG (Bit 8)                        */
#define GPIO_CFGE_GPIO34INCFG_Msk         (0x100UL)                 /*!< GPIO CFGE: GPIO34INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO33INTD_Pos          (7UL)                     /*!< GPIO CFGE: GPIO33INTD (Bit 7)                         */
#define GPIO_CFGE_GPIO33INTD_Msk          (0x80UL)                  /*!< GPIO CFGE: GPIO33INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO33OUTCFG_Pos        (5UL)                     /*!< GPIO CFGE: GPIO33OUTCFG (Bit 5)                       */
#define GPIO_CFGE_GPIO33OUTCFG_Msk        (0x60UL)                  /*!< GPIO CFGE: GPIO33OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO33INCFG_Pos         (4UL)                     /*!< GPIO CFGE: GPIO33INCFG (Bit 4)                        */
#define GPIO_CFGE_GPIO33INCFG_Msk         (0x10UL)                  /*!< GPIO CFGE: GPIO33INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGE_GPIO32INTD_Pos          (3UL)                     /*!< GPIO CFGE: GPIO32INTD (Bit 3)                         */
#define GPIO_CFGE_GPIO32INTD_Msk          (0x8UL)                   /*!< GPIO CFGE: GPIO32INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGE_GPIO32OUTCFG_Pos        (1UL)                     /*!< GPIO CFGE: GPIO32OUTCFG (Bit 1)                       */
#define GPIO_CFGE_GPIO32OUTCFG_Msk        (0x6UL)                   /*!< GPIO CFGE: GPIO32OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGE_GPIO32INCFG_Pos         (0UL)                     /*!< GPIO CFGE: GPIO32INCFG (Bit 0)                        */
#define GPIO_CFGE_GPIO32INCFG_Msk         (0x1UL)                   /*!< GPIO CFGE: GPIO32INCFG (Bitfield-Mask: 0x01)          */
/* =========================================================  CFGF  ========================================================== */
#define GPIO_CFGF_GPIO47INTD_Pos          (31UL)                    /*!< GPIO CFGF: GPIO47INTD (Bit 31)                        */
#define GPIO_CFGF_GPIO47INTD_Msk          (0x80000000UL)            /*!< GPIO CFGF: GPIO47INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO47OUTCFG_Pos        (29UL)                    /*!< GPIO CFGF: GPIO47OUTCFG (Bit 29)                      */
#define GPIO_CFGF_GPIO47OUTCFG_Msk        (0x60000000UL)            /*!< GPIO CFGF: GPIO47OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO47INCFG_Pos         (28UL)                    /*!< GPIO CFGF: GPIO47INCFG (Bit 28)                       */
#define GPIO_CFGF_GPIO47INCFG_Msk         (0x10000000UL)            /*!< GPIO CFGF: GPIO47INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO46INTD_Pos          (27UL)                    /*!< GPIO CFGF: GPIO46INTD (Bit 27)                        */
#define GPIO_CFGF_GPIO46INTD_Msk          (0x8000000UL)             /*!< GPIO CFGF: GPIO46INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO46OUTCFG_Pos        (25UL)                    /*!< GPIO CFGF: GPIO46OUTCFG (Bit 25)                      */
#define GPIO_CFGF_GPIO46OUTCFG_Msk        (0x6000000UL)             /*!< GPIO CFGF: GPIO46OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO46INCFG_Pos         (24UL)                    /*!< GPIO CFGF: GPIO46INCFG (Bit 24)                       */
#define GPIO_CFGF_GPIO46INCFG_Msk         (0x1000000UL)             /*!< GPIO CFGF: GPIO46INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO45INTD_Pos          (23UL)                    /*!< GPIO CFGF: GPIO45INTD (Bit 23)                        */
#define GPIO_CFGF_GPIO45INTD_Msk          (0x800000UL)              /*!< GPIO CFGF: GPIO45INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO45OUTCFG_Pos        (21UL)                    /*!< GPIO CFGF: GPIO45OUTCFG (Bit 21)                      */
#define GPIO_CFGF_GPIO45OUTCFG_Msk        (0x600000UL)              /*!< GPIO CFGF: GPIO45OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO45INCFG_Pos         (20UL)                    /*!< GPIO CFGF: GPIO45INCFG (Bit 20)                       */
#define GPIO_CFGF_GPIO45INCFG_Msk         (0x100000UL)              /*!< GPIO CFGF: GPIO45INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO44INTD_Pos          (19UL)                    /*!< GPIO CFGF: GPIO44INTD (Bit 19)                        */
#define GPIO_CFGF_GPIO44INTD_Msk          (0x80000UL)               /*!< GPIO CFGF: GPIO44INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO44OUTCFG_Pos        (17UL)                    /*!< GPIO CFGF: GPIO44OUTCFG (Bit 17)                      */
#define GPIO_CFGF_GPIO44OUTCFG_Msk        (0x60000UL)               /*!< GPIO CFGF: GPIO44OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO44INCFG_Pos         (16UL)                    /*!< GPIO CFGF: GPIO44INCFG (Bit 16)                       */
#define GPIO_CFGF_GPIO44INCFG_Msk         (0x10000UL)               /*!< GPIO CFGF: GPIO44INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO43INTD_Pos          (15UL)                    /*!< GPIO CFGF: GPIO43INTD (Bit 15)                        */
#define GPIO_CFGF_GPIO43INTD_Msk          (0x8000UL)                /*!< GPIO CFGF: GPIO43INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO43OUTCFG_Pos        (13UL)                    /*!< GPIO CFGF: GPIO43OUTCFG (Bit 13)                      */
#define GPIO_CFGF_GPIO43OUTCFG_Msk        (0x6000UL)                /*!< GPIO CFGF: GPIO43OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO43INCFG_Pos         (12UL)                    /*!< GPIO CFGF: GPIO43INCFG (Bit 12)                       */
#define GPIO_CFGF_GPIO43INCFG_Msk         (0x1000UL)                /*!< GPIO CFGF: GPIO43INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO42INTD_Pos          (11UL)                    /*!< GPIO CFGF: GPIO42INTD (Bit 11)                        */
#define GPIO_CFGF_GPIO42INTD_Msk          (0x800UL)                 /*!< GPIO CFGF: GPIO42INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO42OUTCFG_Pos        (9UL)                     /*!< GPIO CFGF: GPIO42OUTCFG (Bit 9)                       */
#define GPIO_CFGF_GPIO42OUTCFG_Msk        (0x600UL)                 /*!< GPIO CFGF: GPIO42OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO42INCFG_Pos         (8UL)                     /*!< GPIO CFGF: GPIO42INCFG (Bit 8)                        */
#define GPIO_CFGF_GPIO42INCFG_Msk         (0x100UL)                 /*!< GPIO CFGF: GPIO42INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO41INTD_Pos          (7UL)                     /*!< GPIO CFGF: GPIO41INTD (Bit 7)                         */
#define GPIO_CFGF_GPIO41INTD_Msk          (0x80UL)                  /*!< GPIO CFGF: GPIO41INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO41OUTCFG_Pos        (5UL)                     /*!< GPIO CFGF: GPIO41OUTCFG (Bit 5)                       */
#define GPIO_CFGF_GPIO41OUTCFG_Msk        (0x60UL)                  /*!< GPIO CFGF: GPIO41OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO41INCFG_Pos         (4UL)                     /*!< GPIO CFGF: GPIO41INCFG (Bit 4)                        */
#define GPIO_CFGF_GPIO41INCFG_Msk         (0x10UL)                  /*!< GPIO CFGF: GPIO41INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGF_GPIO40INTD_Pos          (3UL)                     /*!< GPIO CFGF: GPIO40INTD (Bit 3)                         */
#define GPIO_CFGF_GPIO40INTD_Msk          (0x8UL)                   /*!< GPIO CFGF: GPIO40INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGF_GPIO40OUTCFG_Pos        (1UL)                     /*!< GPIO CFGF: GPIO40OUTCFG (Bit 1)                       */
#define GPIO_CFGF_GPIO40OUTCFG_Msk        (0x6UL)                   /*!< GPIO CFGF: GPIO40OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGF_GPIO40INCFG_Pos         (0UL)                     /*!< GPIO CFGF: GPIO40INCFG (Bit 0)                        */
#define GPIO_CFGF_GPIO40INCFG_Msk         (0x1UL)                   /*!< GPIO CFGF: GPIO40INCFG (Bitfield-Mask: 0x01)          */
/* =========================================================  CFGG  ========================================================== */
#define GPIO_CFGG_GPIO49INTD_Pos          (7UL)                     /*!< GPIO CFGG: GPIO49INTD (Bit 7)                         */
#define GPIO_CFGG_GPIO49INTD_Msk          (0x80UL)                  /*!< GPIO CFGG: GPIO49INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGG_GPIO49OUTCFG_Pos        (5UL)                     /*!< GPIO CFGG: GPIO49OUTCFG (Bit 5)                       */
#define GPIO_CFGG_GPIO49OUTCFG_Msk        (0x60UL)                  /*!< GPIO CFGG: GPIO49OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGG_GPIO49INCFG_Pos         (4UL)                     /*!< GPIO CFGG: GPIO49INCFG (Bit 4)                        */
#define GPIO_CFGG_GPIO49INCFG_Msk         (0x10UL)                  /*!< GPIO CFGG: GPIO49INCFG (Bitfield-Mask: 0x01)          */
#define GPIO_CFGG_GPIO48INTD_Pos          (3UL)                     /*!< GPIO CFGG: GPIO48INTD (Bit 3)                         */
#define GPIO_CFGG_GPIO48INTD_Msk          (0x8UL)                   /*!< GPIO CFGG: GPIO48INTD (Bitfield-Mask: 0x01)           */
#define GPIO_CFGG_GPIO48OUTCFG_Pos        (1UL)                     /*!< GPIO CFGG: GPIO48OUTCFG (Bit 1)                       */
#define GPIO_CFGG_GPIO48OUTCFG_Msk        (0x6UL)                   /*!< GPIO CFGG: GPIO48OUTCFG (Bitfield-Mask: 0x03)         */
#define GPIO_CFGG_GPIO48INCFG_Pos         (0UL)                     /*!< GPIO CFGG: GPIO48INCFG (Bit 0)                        */
#define GPIO_CFGG_GPIO48INCFG_Msk         (0x1UL)                   /*!< GPIO CFGG: GPIO48INCFG (Bitfield-Mask: 0x01)          */
/* ========================================================  PADKEY  ========================================================= */
#define GPIO_PADKEY_PADKEY_Pos            (0UL)                     /*!< GPIO PADKEY: PADKEY (Bit 0)                           */
#define GPIO_PADKEY_PADKEY_Msk            (0xffffffffUL)            /*!< GPIO PADKEY: PADKEY (Bitfield-Mask: 0xffffffff)       */
/* ==========================================================  RDA  ========================================================== */
#define GPIO_RDA_RDA_Pos                  (0UL)                     /*!< GPIO RDA: RDA (Bit 0)                                 */
#define GPIO_RDA_RDA_Msk                  (0xffffffffUL)            /*!< GPIO RDA: RDA (Bitfield-Mask: 0xffffffff)             */
/* ==========================================================  RDB  ========================================================== */
#define GPIO_RDB_RDB_Pos                  (0UL)                     /*!< GPIO RDB: RDB (Bit 0)                                 */
#define GPIO_RDB_RDB_Msk                  (0x3ffffUL)               /*!< GPIO RDB: RDB (Bitfield-Mask: 0x3ffff)                */
/* ==========================================================  WTA  ========================================================== */
#define GPIO_WTA_WTA_Pos                  (0UL)                     /*!< GPIO WTA: WTA (Bit 0)                                 */
#define GPIO_WTA_WTA_Msk                  (0xffffffffUL)            /*!< GPIO WTA: WTA (Bitfield-Mask: 0xffffffff)             */
/* ==========================================================  WTB  ========================================================== */
#define GPIO_WTB_WTB_Pos                  (0UL)                     /*!< GPIO WTB: WTB (Bit 0)                                 */
#define GPIO_WTB_WTB_Msk                  (0x3ffffUL)               /*!< GPIO WTB: WTB (Bitfield-Mask: 0x3ffff)                */
/* =========================================================  WTSA  ========================================================== */
#define GPIO_WTSA_WTSA_Pos                (0UL)                     /*!< GPIO WTSA: WTSA (Bit 0)                               */
#define GPIO_WTSA_WTSA_Msk                (0xffffffffUL)            /*!< GPIO WTSA: WTSA (Bitfield-Mask: 0xffffffff)           */
/* =========================================================  WTSB  ========================================================== */
#define GPIO_WTSB_WTSB_Pos                (0UL)                     /*!< GPIO WTSB: WTSB (Bit 0)                               */
#define GPIO_WTSB_WTSB_Msk                (0x3ffffUL)               /*!< GPIO WTSB: WTSB (Bitfield-Mask: 0x3ffff)              */
/* =========================================================  WTCA  ========================================================== */
#define GPIO_WTCA_WTCA_Pos                (0UL)                     /*!< GPIO WTCA: WTCA (Bit 0)                               */
#define GPIO_WTCA_WTCA_Msk                (0xffffffffUL)            /*!< GPIO WTCA: WTCA (Bitfield-Mask: 0xffffffff)           */
/* =========================================================  WTCB  ========================================================== */
#define GPIO_WTCB_WTCB_Pos                (0UL)                     /*!< GPIO WTCB: WTCB (Bit 0)                               */
#define GPIO_WTCB_WTCB_Msk                (0x3ffffUL)               /*!< GPIO WTCB: WTCB (Bitfield-Mask: 0x3ffff)              */
/* ==========================================================  ENA  ========================================================== */
#define GPIO_ENA_ENA_Pos                  (0UL)                     /*!< GPIO ENA: ENA (Bit 0)                                 */
#define GPIO_ENA_ENA_Msk                  (0xffffffffUL)            /*!< GPIO ENA: ENA (Bitfield-Mask: 0xffffffff)             */
/* ==========================================================  ENB  ========================================================== */
#define GPIO_ENB_ENB_Pos                  (0UL)                     /*!< GPIO ENB: ENB (Bit 0)                                 */
#define GPIO_ENB_ENB_Msk                  (0x3ffffUL)               /*!< GPIO ENB: ENB (Bitfield-Mask: 0x3ffff)                */
/* =========================================================  ENSA  ========================================================== */
#define GPIO_ENSA_ENSA_Pos                (0UL)                     /*!< GPIO ENSA: ENSA (Bit 0)                               */
#define GPIO_ENSA_ENSA_Msk                (0xffffffffUL)            /*!< GPIO ENSA: ENSA (Bitfield-Mask: 0xffffffff)           */
/* =========================================================  ENSB  ========================================================== */
#define GPIO_ENSB_ENSB_Pos                (0UL)                     /*!< GPIO ENSB: ENSB (Bit 0)                               */
#define GPIO_ENSB_ENSB_Msk                (0x3ffffUL)               /*!< GPIO ENSB: ENSB (Bitfield-Mask: 0x3ffff)              */
/* =========================================================  ENCA  ========================================================== */
#define GPIO_ENCA_ENCA_Pos                (0UL)                     /*!< GPIO ENCA: ENCA (Bit 0)                               */
#define GPIO_ENCA_ENCA_Msk                (0xffffffffUL)            /*!< GPIO ENCA: ENCA (Bitfield-Mask: 0xffffffff)           */
/* =========================================================  ENCB  ========================================================== */
#define GPIO_ENCB_ENCB_Pos                (0UL)                     /*!< GPIO ENCB: ENCB (Bit 0)                               */
#define GPIO_ENCB_ENCB_Msk                (0x3ffffUL)               /*!< GPIO ENCB: ENCB (Bitfield-Mask: 0x3ffff)              */
/* ========================================================  INT0EN  ========================================================= */
#define GPIO_INT0EN_GPIO31_Pos            (31UL)                    /*!< GPIO INT0EN: GPIO31 (Bit 31)                          */
#define GPIO_INT0EN_GPIO31_Msk            (0x80000000UL)            /*!< GPIO INT0EN: GPIO31 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO30_Pos            (30UL)                    /*!< GPIO INT0EN: GPIO30 (Bit 30)                          */
#define GPIO_INT0EN_GPIO30_Msk            (0x40000000UL)            /*!< GPIO INT0EN: GPIO30 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO29_Pos            (29UL)                    /*!< GPIO INT0EN: GPIO29 (Bit 29)                          */
#define GPIO_INT0EN_GPIO29_Msk            (0x20000000UL)            /*!< GPIO INT0EN: GPIO29 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO28_Pos            (28UL)                    /*!< GPIO INT0EN: GPIO28 (Bit 28)                          */
#define GPIO_INT0EN_GPIO28_Msk            (0x10000000UL)            /*!< GPIO INT0EN: GPIO28 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO27_Pos            (27UL)                    /*!< GPIO INT0EN: GPIO27 (Bit 27)                          */
#define GPIO_INT0EN_GPIO27_Msk            (0x8000000UL)             /*!< GPIO INT0EN: GPIO27 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO26_Pos            (26UL)                    /*!< GPIO INT0EN: GPIO26 (Bit 26)                          */
#define GPIO_INT0EN_GPIO26_Msk            (0x4000000UL)             /*!< GPIO INT0EN: GPIO26 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO25_Pos            (25UL)                    /*!< GPIO INT0EN: GPIO25 (Bit 25)                          */
#define GPIO_INT0EN_GPIO25_Msk            (0x2000000UL)             /*!< GPIO INT0EN: GPIO25 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO24_Pos            (24UL)                    /*!< GPIO INT0EN: GPIO24 (Bit 24)                          */
#define GPIO_INT0EN_GPIO24_Msk            (0x1000000UL)             /*!< GPIO INT0EN: GPIO24 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO23_Pos            (23UL)                    /*!< GPIO INT0EN: GPIO23 (Bit 23)                          */
#define GPIO_INT0EN_GPIO23_Msk            (0x800000UL)              /*!< GPIO INT0EN: GPIO23 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO22_Pos            (22UL)                    /*!< GPIO INT0EN: GPIO22 (Bit 22)                          */
#define GPIO_INT0EN_GPIO22_Msk            (0x400000UL)              /*!< GPIO INT0EN: GPIO22 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO21_Pos            (21UL)                    /*!< GPIO INT0EN: GPIO21 (Bit 21)                          */
#define GPIO_INT0EN_GPIO21_Msk            (0x200000UL)              /*!< GPIO INT0EN: GPIO21 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO20_Pos            (20UL)                    /*!< GPIO INT0EN: GPIO20 (Bit 20)                          */
#define GPIO_INT0EN_GPIO20_Msk            (0x100000UL)              /*!< GPIO INT0EN: GPIO20 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO19_Pos            (19UL)                    /*!< GPIO INT0EN: GPIO19 (Bit 19)                          */
#define GPIO_INT0EN_GPIO19_Msk            (0x80000UL)               /*!< GPIO INT0EN: GPIO19 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO18_Pos            (18UL)                    /*!< GPIO INT0EN: GPIO18 (Bit 18)                          */
#define GPIO_INT0EN_GPIO18_Msk            (0x40000UL)               /*!< GPIO INT0EN: GPIO18 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO17_Pos            (17UL)                    /*!< GPIO INT0EN: GPIO17 (Bit 17)                          */
#define GPIO_INT0EN_GPIO17_Msk            (0x20000UL)               /*!< GPIO INT0EN: GPIO17 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO16_Pos            (16UL)                    /*!< GPIO INT0EN: GPIO16 (Bit 16)                          */
#define GPIO_INT0EN_GPIO16_Msk            (0x10000UL)               /*!< GPIO INT0EN: GPIO16 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO15_Pos            (15UL)                    /*!< GPIO INT0EN: GPIO15 (Bit 15)                          */
#define GPIO_INT0EN_GPIO15_Msk            (0x8000UL)                /*!< GPIO INT0EN: GPIO15 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO14_Pos            (14UL)                    /*!< GPIO INT0EN: GPIO14 (Bit 14)                          */
#define GPIO_INT0EN_GPIO14_Msk            (0x4000UL)                /*!< GPIO INT0EN: GPIO14 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO13_Pos            (13UL)                    /*!< GPIO INT0EN: GPIO13 (Bit 13)                          */
#define GPIO_INT0EN_GPIO13_Msk            (0x2000UL)                /*!< GPIO INT0EN: GPIO13 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO12_Pos            (12UL)                    /*!< GPIO INT0EN: GPIO12 (Bit 12)                          */
#define GPIO_INT0EN_GPIO12_Msk            (0x1000UL)                /*!< GPIO INT0EN: GPIO12 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO11_Pos            (11UL)                    /*!< GPIO INT0EN: GPIO11 (Bit 11)                          */
#define GPIO_INT0EN_GPIO11_Msk            (0x800UL)                 /*!< GPIO INT0EN: GPIO11 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO10_Pos            (10UL)                    /*!< GPIO INT0EN: GPIO10 (Bit 10)                          */
#define GPIO_INT0EN_GPIO10_Msk            (0x400UL)                 /*!< GPIO INT0EN: GPIO10 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0EN_GPIO9_Pos             (9UL)                     /*!< GPIO INT0EN: GPIO9 (Bit 9)                            */
#define GPIO_INT0EN_GPIO9_Msk             (0x200UL)                 /*!< GPIO INT0EN: GPIO9 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO8_Pos             (8UL)                     /*!< GPIO INT0EN: GPIO8 (Bit 8)                            */
#define GPIO_INT0EN_GPIO8_Msk             (0x100UL)                 /*!< GPIO INT0EN: GPIO8 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO7_Pos             (7UL)                     /*!< GPIO INT0EN: GPIO7 (Bit 7)                            */
#define GPIO_INT0EN_GPIO7_Msk             (0x80UL)                  /*!< GPIO INT0EN: GPIO7 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO6_Pos             (6UL)                     /*!< GPIO INT0EN: GPIO6 (Bit 6)                            */
#define GPIO_INT0EN_GPIO6_Msk             (0x40UL)                  /*!< GPIO INT0EN: GPIO6 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO5_Pos             (5UL)                     /*!< GPIO INT0EN: GPIO5 (Bit 5)                            */
#define GPIO_INT0EN_GPIO5_Msk             (0x20UL)                  /*!< GPIO INT0EN: GPIO5 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO4_Pos             (4UL)                     /*!< GPIO INT0EN: GPIO4 (Bit 4)                            */
#define GPIO_INT0EN_GPIO4_Msk             (0x10UL)                  /*!< GPIO INT0EN: GPIO4 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO3_Pos             (3UL)                     /*!< GPIO INT0EN: GPIO3 (Bit 3)                            */
#define GPIO_INT0EN_GPIO3_Msk             (0x8UL)                   /*!< GPIO INT0EN: GPIO3 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO2_Pos             (2UL)                     /*!< GPIO INT0EN: GPIO2 (Bit 2)                            */
#define GPIO_INT0EN_GPIO2_Msk             (0x4UL)                   /*!< GPIO INT0EN: GPIO2 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO1_Pos             (1UL)                     /*!< GPIO INT0EN: GPIO1 (Bit 1)                            */
#define GPIO_INT0EN_GPIO1_Msk             (0x2UL)                   /*!< GPIO INT0EN: GPIO1 (Bitfield-Mask: 0x01)              */
#define GPIO_INT0EN_GPIO0_Pos             (0UL)                     /*!< GPIO INT0EN: GPIO0 (Bit 0)                            */
#define GPIO_INT0EN_GPIO0_Msk             (0x1UL)                   /*!< GPIO INT0EN: GPIO0 (Bitfield-Mask: 0x01)              */
/* =======================================================  INT0STAT  ======================================================== */
#define GPIO_INT0STAT_GPIO31_Pos          (31UL)                    /*!< GPIO INT0STAT: GPIO31 (Bit 31)                        */
#define GPIO_INT0STAT_GPIO31_Msk          (0x80000000UL)            /*!< GPIO INT0STAT: GPIO31 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO30_Pos          (30UL)                    /*!< GPIO INT0STAT: GPIO30 (Bit 30)                        */
#define GPIO_INT0STAT_GPIO30_Msk          (0x40000000UL)            /*!< GPIO INT0STAT: GPIO30 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO29_Pos          (29UL)                    /*!< GPIO INT0STAT: GPIO29 (Bit 29)                        */
#define GPIO_INT0STAT_GPIO29_Msk          (0x20000000UL)            /*!< GPIO INT0STAT: GPIO29 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO28_Pos          (28UL)                    /*!< GPIO INT0STAT: GPIO28 (Bit 28)                        */
#define GPIO_INT0STAT_GPIO28_Msk          (0x10000000UL)            /*!< GPIO INT0STAT: GPIO28 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO27_Pos          (27UL)                    /*!< GPIO INT0STAT: GPIO27 (Bit 27)                        */
#define GPIO_INT0STAT_GPIO27_Msk          (0x8000000UL)             /*!< GPIO INT0STAT: GPIO27 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO26_Pos          (26UL)                    /*!< GPIO INT0STAT: GPIO26 (Bit 26)                        */
#define GPIO_INT0STAT_GPIO26_Msk          (0x4000000UL)             /*!< GPIO INT0STAT: GPIO26 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO25_Pos          (25UL)                    /*!< GPIO INT0STAT: GPIO25 (Bit 25)                        */
#define GPIO_INT0STAT_GPIO25_Msk          (0x2000000UL)             /*!< GPIO INT0STAT: GPIO25 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO24_Pos          (24UL)                    /*!< GPIO INT0STAT: GPIO24 (Bit 24)                        */
#define GPIO_INT0STAT_GPIO24_Msk          (0x1000000UL)             /*!< GPIO INT0STAT: GPIO24 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO23_Pos          (23UL)                    /*!< GPIO INT0STAT: GPIO23 (Bit 23)                        */
#define GPIO_INT0STAT_GPIO23_Msk          (0x800000UL)              /*!< GPIO INT0STAT: GPIO23 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO22_Pos          (22UL)                    /*!< GPIO INT0STAT: GPIO22 (Bit 22)                        */
#define GPIO_INT0STAT_GPIO22_Msk          (0x400000UL)              /*!< GPIO INT0STAT: GPIO22 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO21_Pos          (21UL)                    /*!< GPIO INT0STAT: GPIO21 (Bit 21)                        */
#define GPIO_INT0STAT_GPIO21_Msk          (0x200000UL)              /*!< GPIO INT0STAT: GPIO21 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO20_Pos          (20UL)                    /*!< GPIO INT0STAT: GPIO20 (Bit 20)                        */
#define GPIO_INT0STAT_GPIO20_Msk          (0x100000UL)              /*!< GPIO INT0STAT: GPIO20 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO19_Pos          (19UL)                    /*!< GPIO INT0STAT: GPIO19 (Bit 19)                        */
#define GPIO_INT0STAT_GPIO19_Msk          (0x80000UL)               /*!< GPIO INT0STAT: GPIO19 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO18_Pos          (18UL)                    /*!< GPIO INT0STAT: GPIO18 (Bit 18)                        */
#define GPIO_INT0STAT_GPIO18_Msk          (0x40000UL)               /*!< GPIO INT0STAT: GPIO18 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO17_Pos          (17UL)                    /*!< GPIO INT0STAT: GPIO17 (Bit 17)                        */
#define GPIO_INT0STAT_GPIO17_Msk          (0x20000UL)               /*!< GPIO INT0STAT: GPIO17 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO16_Pos          (16UL)                    /*!< GPIO INT0STAT: GPIO16 (Bit 16)                        */
#define GPIO_INT0STAT_GPIO16_Msk          (0x10000UL)               /*!< GPIO INT0STAT: GPIO16 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO15_Pos          (15UL)                    /*!< GPIO INT0STAT: GPIO15 (Bit 15)                        */
#define GPIO_INT0STAT_GPIO15_Msk          (0x8000UL)                /*!< GPIO INT0STAT: GPIO15 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO14_Pos          (14UL)                    /*!< GPIO INT0STAT: GPIO14 (Bit 14)                        */
#define GPIO_INT0STAT_GPIO14_Msk          (0x4000UL)                /*!< GPIO INT0STAT: GPIO14 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO13_Pos          (13UL)                    /*!< GPIO INT0STAT: GPIO13 (Bit 13)                        */
#define GPIO_INT0STAT_GPIO13_Msk          (0x2000UL)                /*!< GPIO INT0STAT: GPIO13 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO12_Pos          (12UL)                    /*!< GPIO INT0STAT: GPIO12 (Bit 12)                        */
#define GPIO_INT0STAT_GPIO12_Msk          (0x1000UL)                /*!< GPIO INT0STAT: GPIO12 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO11_Pos          (11UL)                    /*!< GPIO INT0STAT: GPIO11 (Bit 11)                        */
#define GPIO_INT0STAT_GPIO11_Msk          (0x800UL)                 /*!< GPIO INT0STAT: GPIO11 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO10_Pos          (10UL)                    /*!< GPIO INT0STAT: GPIO10 (Bit 10)                        */
#define GPIO_INT0STAT_GPIO10_Msk          (0x400UL)                 /*!< GPIO INT0STAT: GPIO10 (Bitfield-Mask: 0x01)           */
#define GPIO_INT0STAT_GPIO9_Pos           (9UL)                     /*!< GPIO INT0STAT: GPIO9 (Bit 9)                          */
#define GPIO_INT0STAT_GPIO9_Msk           (0x200UL)                 /*!< GPIO INT0STAT: GPIO9 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO8_Pos           (8UL)                     /*!< GPIO INT0STAT: GPIO8 (Bit 8)                          */
#define GPIO_INT0STAT_GPIO8_Msk           (0x100UL)                 /*!< GPIO INT0STAT: GPIO8 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO7_Pos           (7UL)                     /*!< GPIO INT0STAT: GPIO7 (Bit 7)                          */
#define GPIO_INT0STAT_GPIO7_Msk           (0x80UL)                  /*!< GPIO INT0STAT: GPIO7 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO6_Pos           (6UL)                     /*!< GPIO INT0STAT: GPIO6 (Bit 6)                          */
#define GPIO_INT0STAT_GPIO6_Msk           (0x40UL)                  /*!< GPIO INT0STAT: GPIO6 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO5_Pos           (5UL)                     /*!< GPIO INT0STAT: GPIO5 (Bit 5)                          */
#define GPIO_INT0STAT_GPIO5_Msk           (0x20UL)                  /*!< GPIO INT0STAT: GPIO5 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO4_Pos           (4UL)                     /*!< GPIO INT0STAT: GPIO4 (Bit 4)                          */
#define GPIO_INT0STAT_GPIO4_Msk           (0x10UL)                  /*!< GPIO INT0STAT: GPIO4 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO3_Pos           (3UL)                     /*!< GPIO INT0STAT: GPIO3 (Bit 3)                          */
#define GPIO_INT0STAT_GPIO3_Msk           (0x8UL)                   /*!< GPIO INT0STAT: GPIO3 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO2_Pos           (2UL)                     /*!< GPIO INT0STAT: GPIO2 (Bit 2)                          */
#define GPIO_INT0STAT_GPIO2_Msk           (0x4UL)                   /*!< GPIO INT0STAT: GPIO2 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO1_Pos           (1UL)                     /*!< GPIO INT0STAT: GPIO1 (Bit 1)                          */
#define GPIO_INT0STAT_GPIO1_Msk           (0x2UL)                   /*!< GPIO INT0STAT: GPIO1 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0STAT_GPIO0_Pos           (0UL)                     /*!< GPIO INT0STAT: GPIO0 (Bit 0)                          */
#define GPIO_INT0STAT_GPIO0_Msk           (0x1UL)                   /*!< GPIO INT0STAT: GPIO0 (Bitfield-Mask: 0x01)            */
/* ========================================================  INT0CLR  ======================================================== */
#define GPIO_INT0CLR_GPIO31_Pos           (31UL)                    /*!< GPIO INT0CLR: GPIO31 (Bit 31)                         */
#define GPIO_INT0CLR_GPIO31_Msk           (0x80000000UL)            /*!< GPIO INT0CLR: GPIO31 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO30_Pos           (30UL)                    /*!< GPIO INT0CLR: GPIO30 (Bit 30)                         */
#define GPIO_INT0CLR_GPIO30_Msk           (0x40000000UL)            /*!< GPIO INT0CLR: GPIO30 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO29_Pos           (29UL)                    /*!< GPIO INT0CLR: GPIO29 (Bit 29)                         */
#define GPIO_INT0CLR_GPIO29_Msk           (0x20000000UL)            /*!< GPIO INT0CLR: GPIO29 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO28_Pos           (28UL)                    /*!< GPIO INT0CLR: GPIO28 (Bit 28)                         */
#define GPIO_INT0CLR_GPIO28_Msk           (0x10000000UL)            /*!< GPIO INT0CLR: GPIO28 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO27_Pos           (27UL)                    /*!< GPIO INT0CLR: GPIO27 (Bit 27)                         */
#define GPIO_INT0CLR_GPIO27_Msk           (0x8000000UL)             /*!< GPIO INT0CLR: GPIO27 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO26_Pos           (26UL)                    /*!< GPIO INT0CLR: GPIO26 (Bit 26)                         */
#define GPIO_INT0CLR_GPIO26_Msk           (0x4000000UL)             /*!< GPIO INT0CLR: GPIO26 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO25_Pos           (25UL)                    /*!< GPIO INT0CLR: GPIO25 (Bit 25)                         */
#define GPIO_INT0CLR_GPIO25_Msk           (0x2000000UL)             /*!< GPIO INT0CLR: GPIO25 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO24_Pos           (24UL)                    /*!< GPIO INT0CLR: GPIO24 (Bit 24)                         */
#define GPIO_INT0CLR_GPIO24_Msk           (0x1000000UL)             /*!< GPIO INT0CLR: GPIO24 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO23_Pos           (23UL)                    /*!< GPIO INT0CLR: GPIO23 (Bit 23)                         */
#define GPIO_INT0CLR_GPIO23_Msk           (0x800000UL)              /*!< GPIO INT0CLR: GPIO23 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO22_Pos           (22UL)                    /*!< GPIO INT0CLR: GPIO22 (Bit 22)                         */
#define GPIO_INT0CLR_GPIO22_Msk           (0x400000UL)              /*!< GPIO INT0CLR: GPIO22 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO21_Pos           (21UL)                    /*!< GPIO INT0CLR: GPIO21 (Bit 21)                         */
#define GPIO_INT0CLR_GPIO21_Msk           (0x200000UL)              /*!< GPIO INT0CLR: GPIO21 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO20_Pos           (20UL)                    /*!< GPIO INT0CLR: GPIO20 (Bit 20)                         */
#define GPIO_INT0CLR_GPIO20_Msk           (0x100000UL)              /*!< GPIO INT0CLR: GPIO20 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO19_Pos           (19UL)                    /*!< GPIO INT0CLR: GPIO19 (Bit 19)                         */
#define GPIO_INT0CLR_GPIO19_Msk           (0x80000UL)               /*!< GPIO INT0CLR: GPIO19 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO18_Pos           (18UL)                    /*!< GPIO INT0CLR: GPIO18 (Bit 18)                         */
#define GPIO_INT0CLR_GPIO18_Msk           (0x40000UL)               /*!< GPIO INT0CLR: GPIO18 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO17_Pos           (17UL)                    /*!< GPIO INT0CLR: GPIO17 (Bit 17)                         */
#define GPIO_INT0CLR_GPIO17_Msk           (0x20000UL)               /*!< GPIO INT0CLR: GPIO17 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO16_Pos           (16UL)                    /*!< GPIO INT0CLR: GPIO16 (Bit 16)                         */
#define GPIO_INT0CLR_GPIO16_Msk           (0x10000UL)               /*!< GPIO INT0CLR: GPIO16 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO15_Pos           (15UL)                    /*!< GPIO INT0CLR: GPIO15 (Bit 15)                         */
#define GPIO_INT0CLR_GPIO15_Msk           (0x8000UL)                /*!< GPIO INT0CLR: GPIO15 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO14_Pos           (14UL)                    /*!< GPIO INT0CLR: GPIO14 (Bit 14)                         */
#define GPIO_INT0CLR_GPIO14_Msk           (0x4000UL)                /*!< GPIO INT0CLR: GPIO14 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO13_Pos           (13UL)                    /*!< GPIO INT0CLR: GPIO13 (Bit 13)                         */
#define GPIO_INT0CLR_GPIO13_Msk           (0x2000UL)                /*!< GPIO INT0CLR: GPIO13 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO12_Pos           (12UL)                    /*!< GPIO INT0CLR: GPIO12 (Bit 12)                         */
#define GPIO_INT0CLR_GPIO12_Msk           (0x1000UL)                /*!< GPIO INT0CLR: GPIO12 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO11_Pos           (11UL)                    /*!< GPIO INT0CLR: GPIO11 (Bit 11)                         */
#define GPIO_INT0CLR_GPIO11_Msk           (0x800UL)                 /*!< GPIO INT0CLR: GPIO11 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO10_Pos           (10UL)                    /*!< GPIO INT0CLR: GPIO10 (Bit 10)                         */
#define GPIO_INT0CLR_GPIO10_Msk           (0x400UL)                 /*!< GPIO INT0CLR: GPIO10 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0CLR_GPIO9_Pos            (9UL)                     /*!< GPIO INT0CLR: GPIO9 (Bit 9)                           */
#define GPIO_INT0CLR_GPIO9_Msk            (0x200UL)                 /*!< GPIO INT0CLR: GPIO9 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO8_Pos            (8UL)                     /*!< GPIO INT0CLR: GPIO8 (Bit 8)                           */
#define GPIO_INT0CLR_GPIO8_Msk            (0x100UL)                 /*!< GPIO INT0CLR: GPIO8 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO7_Pos            (7UL)                     /*!< GPIO INT0CLR: GPIO7 (Bit 7)                           */
#define GPIO_INT0CLR_GPIO7_Msk            (0x80UL)                  /*!< GPIO INT0CLR: GPIO7 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO6_Pos            (6UL)                     /*!< GPIO INT0CLR: GPIO6 (Bit 6)                           */
#define GPIO_INT0CLR_GPIO6_Msk            (0x40UL)                  /*!< GPIO INT0CLR: GPIO6 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO5_Pos            (5UL)                     /*!< GPIO INT0CLR: GPIO5 (Bit 5)                           */
#define GPIO_INT0CLR_GPIO5_Msk            (0x20UL)                  /*!< GPIO INT0CLR: GPIO5 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO4_Pos            (4UL)                     /*!< GPIO INT0CLR: GPIO4 (Bit 4)                           */
#define GPIO_INT0CLR_GPIO4_Msk            (0x10UL)                  /*!< GPIO INT0CLR: GPIO4 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO3_Pos            (3UL)                     /*!< GPIO INT0CLR: GPIO3 (Bit 3)                           */
#define GPIO_INT0CLR_GPIO3_Msk            (0x8UL)                   /*!< GPIO INT0CLR: GPIO3 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO2_Pos            (2UL)                     /*!< GPIO INT0CLR: GPIO2 (Bit 2)                           */
#define GPIO_INT0CLR_GPIO2_Msk            (0x4UL)                   /*!< GPIO INT0CLR: GPIO2 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO1_Pos            (1UL)                     /*!< GPIO INT0CLR: GPIO1 (Bit 1)                           */
#define GPIO_INT0CLR_GPIO1_Msk            (0x2UL)                   /*!< GPIO INT0CLR: GPIO1 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0CLR_GPIO0_Pos            (0UL)                     /*!< GPIO INT0CLR: GPIO0 (Bit 0)                           */
#define GPIO_INT0CLR_GPIO0_Msk            (0x1UL)                   /*!< GPIO INT0CLR: GPIO0 (Bitfield-Mask: 0x01)             */
/* ========================================================  INT0SET  ======================================================== */
#define GPIO_INT0SET_GPIO31_Pos           (31UL)                    /*!< GPIO INT0SET: GPIO31 (Bit 31)                         */
#define GPIO_INT0SET_GPIO31_Msk           (0x80000000UL)            /*!< GPIO INT0SET: GPIO31 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO30_Pos           (30UL)                    /*!< GPIO INT0SET: GPIO30 (Bit 30)                         */
#define GPIO_INT0SET_GPIO30_Msk           (0x40000000UL)            /*!< GPIO INT0SET: GPIO30 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO29_Pos           (29UL)                    /*!< GPIO INT0SET: GPIO29 (Bit 29)                         */
#define GPIO_INT0SET_GPIO29_Msk           (0x20000000UL)            /*!< GPIO INT0SET: GPIO29 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO28_Pos           (28UL)                    /*!< GPIO INT0SET: GPIO28 (Bit 28)                         */
#define GPIO_INT0SET_GPIO28_Msk           (0x10000000UL)            /*!< GPIO INT0SET: GPIO28 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO27_Pos           (27UL)                    /*!< GPIO INT0SET: GPIO27 (Bit 27)                         */
#define GPIO_INT0SET_GPIO27_Msk           (0x8000000UL)             /*!< GPIO INT0SET: GPIO27 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO26_Pos           (26UL)                    /*!< GPIO INT0SET: GPIO26 (Bit 26)                         */
#define GPIO_INT0SET_GPIO26_Msk           (0x4000000UL)             /*!< GPIO INT0SET: GPIO26 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO25_Pos           (25UL)                    /*!< GPIO INT0SET: GPIO25 (Bit 25)                         */
#define GPIO_INT0SET_GPIO25_Msk           (0x2000000UL)             /*!< GPIO INT0SET: GPIO25 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO24_Pos           (24UL)                    /*!< GPIO INT0SET: GPIO24 (Bit 24)                         */
#define GPIO_INT0SET_GPIO24_Msk           (0x1000000UL)             /*!< GPIO INT0SET: GPIO24 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO23_Pos           (23UL)                    /*!< GPIO INT0SET: GPIO23 (Bit 23)                         */
#define GPIO_INT0SET_GPIO23_Msk           (0x800000UL)              /*!< GPIO INT0SET: GPIO23 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO22_Pos           (22UL)                    /*!< GPIO INT0SET: GPIO22 (Bit 22)                         */
#define GPIO_INT0SET_GPIO22_Msk           (0x400000UL)              /*!< GPIO INT0SET: GPIO22 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO21_Pos           (21UL)                    /*!< GPIO INT0SET: GPIO21 (Bit 21)                         */
#define GPIO_INT0SET_GPIO21_Msk           (0x200000UL)              /*!< GPIO INT0SET: GPIO21 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO20_Pos           (20UL)                    /*!< GPIO INT0SET: GPIO20 (Bit 20)                         */
#define GPIO_INT0SET_GPIO20_Msk           (0x100000UL)              /*!< GPIO INT0SET: GPIO20 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO19_Pos           (19UL)                    /*!< GPIO INT0SET: GPIO19 (Bit 19)                         */
#define GPIO_INT0SET_GPIO19_Msk           (0x80000UL)               /*!< GPIO INT0SET: GPIO19 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO18_Pos           (18UL)                    /*!< GPIO INT0SET: GPIO18 (Bit 18)                         */
#define GPIO_INT0SET_GPIO18_Msk           (0x40000UL)               /*!< GPIO INT0SET: GPIO18 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO17_Pos           (17UL)                    /*!< GPIO INT0SET: GPIO17 (Bit 17)                         */
#define GPIO_INT0SET_GPIO17_Msk           (0x20000UL)               /*!< GPIO INT0SET: GPIO17 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO16_Pos           (16UL)                    /*!< GPIO INT0SET: GPIO16 (Bit 16)                         */
#define GPIO_INT0SET_GPIO16_Msk           (0x10000UL)               /*!< GPIO INT0SET: GPIO16 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO15_Pos           (15UL)                    /*!< GPIO INT0SET: GPIO15 (Bit 15)                         */
#define GPIO_INT0SET_GPIO15_Msk           (0x8000UL)                /*!< GPIO INT0SET: GPIO15 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO14_Pos           (14UL)                    /*!< GPIO INT0SET: GPIO14 (Bit 14)                         */
#define GPIO_INT0SET_GPIO14_Msk           (0x4000UL)                /*!< GPIO INT0SET: GPIO14 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO13_Pos           (13UL)                    /*!< GPIO INT0SET: GPIO13 (Bit 13)                         */
#define GPIO_INT0SET_GPIO13_Msk           (0x2000UL)                /*!< GPIO INT0SET: GPIO13 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO12_Pos           (12UL)                    /*!< GPIO INT0SET: GPIO12 (Bit 12)                         */
#define GPIO_INT0SET_GPIO12_Msk           (0x1000UL)                /*!< GPIO INT0SET: GPIO12 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO11_Pos           (11UL)                    /*!< GPIO INT0SET: GPIO11 (Bit 11)                         */
#define GPIO_INT0SET_GPIO11_Msk           (0x800UL)                 /*!< GPIO INT0SET: GPIO11 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO10_Pos           (10UL)                    /*!< GPIO INT0SET: GPIO10 (Bit 10)                         */
#define GPIO_INT0SET_GPIO10_Msk           (0x400UL)                 /*!< GPIO INT0SET: GPIO10 (Bitfield-Mask: 0x01)            */
#define GPIO_INT0SET_GPIO9_Pos            (9UL)                     /*!< GPIO INT0SET: GPIO9 (Bit 9)                           */
#define GPIO_INT0SET_GPIO9_Msk            (0x200UL)                 /*!< GPIO INT0SET: GPIO9 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO8_Pos            (8UL)                     /*!< GPIO INT0SET: GPIO8 (Bit 8)                           */
#define GPIO_INT0SET_GPIO8_Msk            (0x100UL)                 /*!< GPIO INT0SET: GPIO8 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO7_Pos            (7UL)                     /*!< GPIO INT0SET: GPIO7 (Bit 7)                           */
#define GPIO_INT0SET_GPIO7_Msk            (0x80UL)                  /*!< GPIO INT0SET: GPIO7 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO6_Pos            (6UL)                     /*!< GPIO INT0SET: GPIO6 (Bit 6)                           */
#define GPIO_INT0SET_GPIO6_Msk            (0x40UL)                  /*!< GPIO INT0SET: GPIO6 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO5_Pos            (5UL)                     /*!< GPIO INT0SET: GPIO5 (Bit 5)                           */
#define GPIO_INT0SET_GPIO5_Msk            (0x20UL)                  /*!< GPIO INT0SET: GPIO5 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO4_Pos            (4UL)                     /*!< GPIO INT0SET: GPIO4 (Bit 4)                           */
#define GPIO_INT0SET_GPIO4_Msk            (0x10UL)                  /*!< GPIO INT0SET: GPIO4 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO3_Pos            (3UL)                     /*!< GPIO INT0SET: GPIO3 (Bit 3)                           */
#define GPIO_INT0SET_GPIO3_Msk            (0x8UL)                   /*!< GPIO INT0SET: GPIO3 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO2_Pos            (2UL)                     /*!< GPIO INT0SET: GPIO2 (Bit 2)                           */
#define GPIO_INT0SET_GPIO2_Msk            (0x4UL)                   /*!< GPIO INT0SET: GPIO2 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO1_Pos            (1UL)                     /*!< GPIO INT0SET: GPIO1 (Bit 1)                           */
#define GPIO_INT0SET_GPIO1_Msk            (0x2UL)                   /*!< GPIO INT0SET: GPIO1 (Bitfield-Mask: 0x01)             */
#define GPIO_INT0SET_GPIO0_Pos            (0UL)                     /*!< GPIO INT0SET: GPIO0 (Bit 0)                           */
#define GPIO_INT0SET_GPIO0_Msk            (0x1UL)                   /*!< GPIO INT0SET: GPIO0 (Bitfield-Mask: 0x01)             */
/* ========================================================  INT1EN  ========================================================= */
#define GPIO_INT1EN_GPIO49_Pos            (17UL)                    /*!< GPIO INT1EN: GPIO49 (Bit 17)                          */
#define GPIO_INT1EN_GPIO49_Msk            (0x20000UL)               /*!< GPIO INT1EN: GPIO49 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO48_Pos            (16UL)                    /*!< GPIO INT1EN: GPIO48 (Bit 16)                          */
#define GPIO_INT1EN_GPIO48_Msk            (0x10000UL)               /*!< GPIO INT1EN: GPIO48 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO47_Pos            (15UL)                    /*!< GPIO INT1EN: GPIO47 (Bit 15)                          */
#define GPIO_INT1EN_GPIO47_Msk            (0x8000UL)                /*!< GPIO INT1EN: GPIO47 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO46_Pos            (14UL)                    /*!< GPIO INT1EN: GPIO46 (Bit 14)                          */
#define GPIO_INT1EN_GPIO46_Msk            (0x4000UL)                /*!< GPIO INT1EN: GPIO46 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO45_Pos            (13UL)                    /*!< GPIO INT1EN: GPIO45 (Bit 13)                          */
#define GPIO_INT1EN_GPIO45_Msk            (0x2000UL)                /*!< GPIO INT1EN: GPIO45 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO44_Pos            (12UL)                    /*!< GPIO INT1EN: GPIO44 (Bit 12)                          */
#define GPIO_INT1EN_GPIO44_Msk            (0x1000UL)                /*!< GPIO INT1EN: GPIO44 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO43_Pos            (11UL)                    /*!< GPIO INT1EN: GPIO43 (Bit 11)                          */
#define GPIO_INT1EN_GPIO43_Msk            (0x800UL)                 /*!< GPIO INT1EN: GPIO43 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO42_Pos            (10UL)                    /*!< GPIO INT1EN: GPIO42 (Bit 10)                          */
#define GPIO_INT1EN_GPIO42_Msk            (0x400UL)                 /*!< GPIO INT1EN: GPIO42 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO41_Pos            (9UL)                     /*!< GPIO INT1EN: GPIO41 (Bit 9)                           */
#define GPIO_INT1EN_GPIO41_Msk            (0x200UL)                 /*!< GPIO INT1EN: GPIO41 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO40_Pos            (8UL)                     /*!< GPIO INT1EN: GPIO40 (Bit 8)                           */
#define GPIO_INT1EN_GPIO40_Msk            (0x100UL)                 /*!< GPIO INT1EN: GPIO40 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO39_Pos            (7UL)                     /*!< GPIO INT1EN: GPIO39 (Bit 7)                           */
#define GPIO_INT1EN_GPIO39_Msk            (0x80UL)                  /*!< GPIO INT1EN: GPIO39 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO38_Pos            (6UL)                     /*!< GPIO INT1EN: GPIO38 (Bit 6)                           */
#define GPIO_INT1EN_GPIO38_Msk            (0x40UL)                  /*!< GPIO INT1EN: GPIO38 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO37_Pos            (5UL)                     /*!< GPIO INT1EN: GPIO37 (Bit 5)                           */
#define GPIO_INT1EN_GPIO37_Msk            (0x20UL)                  /*!< GPIO INT1EN: GPIO37 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO36_Pos            (4UL)                     /*!< GPIO INT1EN: GPIO36 (Bit 4)                           */
#define GPIO_INT1EN_GPIO36_Msk            (0x10UL)                  /*!< GPIO INT1EN: GPIO36 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO35_Pos            (3UL)                     /*!< GPIO INT1EN: GPIO35 (Bit 3)                           */
#define GPIO_INT1EN_GPIO35_Msk            (0x8UL)                   /*!< GPIO INT1EN: GPIO35 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO34_Pos            (2UL)                     /*!< GPIO INT1EN: GPIO34 (Bit 2)                           */
#define GPIO_INT1EN_GPIO34_Msk            (0x4UL)                   /*!< GPIO INT1EN: GPIO34 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO33_Pos            (1UL)                     /*!< GPIO INT1EN: GPIO33 (Bit 1)                           */
#define GPIO_INT1EN_GPIO33_Msk            (0x2UL)                   /*!< GPIO INT1EN: GPIO33 (Bitfield-Mask: 0x01)             */
#define GPIO_INT1EN_GPIO32_Pos            (0UL)                     /*!< GPIO INT1EN: GPIO32 (Bit 0)                           */
#define GPIO_INT1EN_GPIO32_Msk            (0x1UL)                   /*!< GPIO INT1EN: GPIO32 (Bitfield-Mask: 0x01)             */
/* =======================================================  INT1STAT  ======================================================== */
#define GPIO_INT1STAT_GPIO49_Pos          (17UL)                    /*!< GPIO INT1STAT: GPIO49 (Bit 17)                        */
#define GPIO_INT1STAT_GPIO49_Msk          (0x20000UL)               /*!< GPIO INT1STAT: GPIO49 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO48_Pos          (16UL)                    /*!< GPIO INT1STAT: GPIO48 (Bit 16)                        */
#define GPIO_INT1STAT_GPIO48_Msk          (0x10000UL)               /*!< GPIO INT1STAT: GPIO48 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO47_Pos          (15UL)                    /*!< GPIO INT1STAT: GPIO47 (Bit 15)                        */
#define GPIO_INT1STAT_GPIO47_Msk          (0x8000UL)                /*!< GPIO INT1STAT: GPIO47 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO46_Pos          (14UL)                    /*!< GPIO INT1STAT: GPIO46 (Bit 14)                        */
#define GPIO_INT1STAT_GPIO46_Msk          (0x4000UL)                /*!< GPIO INT1STAT: GPIO46 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO45_Pos          (13UL)                    /*!< GPIO INT1STAT: GPIO45 (Bit 13)                        */
#define GPIO_INT1STAT_GPIO45_Msk          (0x2000UL)                /*!< GPIO INT1STAT: GPIO45 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO44_Pos          (12UL)                    /*!< GPIO INT1STAT: GPIO44 (Bit 12)                        */
#define GPIO_INT1STAT_GPIO44_Msk          (0x1000UL)                /*!< GPIO INT1STAT: GPIO44 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO43_Pos          (11UL)                    /*!< GPIO INT1STAT: GPIO43 (Bit 11)                        */
#define GPIO_INT1STAT_GPIO43_Msk          (0x800UL)                 /*!< GPIO INT1STAT: GPIO43 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO42_Pos          (10UL)                    /*!< GPIO INT1STAT: GPIO42 (Bit 10)                        */
#define GPIO_INT1STAT_GPIO42_Msk          (0x400UL)                 /*!< GPIO INT1STAT: GPIO42 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO41_Pos          (9UL)                     /*!< GPIO INT1STAT: GPIO41 (Bit 9)                         */
#define GPIO_INT1STAT_GPIO41_Msk          (0x200UL)                 /*!< GPIO INT1STAT: GPIO41 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO40_Pos          (8UL)                     /*!< GPIO INT1STAT: GPIO40 (Bit 8)                         */
#define GPIO_INT1STAT_GPIO40_Msk          (0x100UL)                 /*!< GPIO INT1STAT: GPIO40 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO39_Pos          (7UL)                     /*!< GPIO INT1STAT: GPIO39 (Bit 7)                         */
#define GPIO_INT1STAT_GPIO39_Msk          (0x80UL)                  /*!< GPIO INT1STAT: GPIO39 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO38_Pos          (6UL)                     /*!< GPIO INT1STAT: GPIO38 (Bit 6)                         */
#define GPIO_INT1STAT_GPIO38_Msk          (0x40UL)                  /*!< GPIO INT1STAT: GPIO38 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO37_Pos          (5UL)                     /*!< GPIO INT1STAT: GPIO37 (Bit 5)                         */
#define GPIO_INT1STAT_GPIO37_Msk          (0x20UL)                  /*!< GPIO INT1STAT: GPIO37 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO36_Pos          (4UL)                     /*!< GPIO INT1STAT: GPIO36 (Bit 4)                         */
#define GPIO_INT1STAT_GPIO36_Msk          (0x10UL)                  /*!< GPIO INT1STAT: GPIO36 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO35_Pos          (3UL)                     /*!< GPIO INT1STAT: GPIO35 (Bit 3)                         */
#define GPIO_INT1STAT_GPIO35_Msk          (0x8UL)                   /*!< GPIO INT1STAT: GPIO35 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO34_Pos          (2UL)                     /*!< GPIO INT1STAT: GPIO34 (Bit 2)                         */
#define GPIO_INT1STAT_GPIO34_Msk          (0x4UL)                   /*!< GPIO INT1STAT: GPIO34 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO33_Pos          (1UL)                     /*!< GPIO INT1STAT: GPIO33 (Bit 1)                         */
#define GPIO_INT1STAT_GPIO33_Msk          (0x2UL)                   /*!< GPIO INT1STAT: GPIO33 (Bitfield-Mask: 0x01)           */
#define GPIO_INT1STAT_GPIO32_Pos          (0UL)                     /*!< GPIO INT1STAT: GPIO32 (Bit 0)                         */
#define GPIO_INT1STAT_GPIO32_Msk          (0x1UL)                   /*!< GPIO INT1STAT: GPIO32 (Bitfield-Mask: 0x01)           */
/* ========================================================  INT1CLR  ======================================================== */
#define GPIO_INT1CLR_GPIO49_Pos           (17UL)                    /*!< GPIO INT1CLR: GPIO49 (Bit 17)                         */
#define GPIO_INT1CLR_GPIO49_Msk           (0x20000UL)               /*!< GPIO INT1CLR: GPIO49 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO48_Pos           (16UL)                    /*!< GPIO INT1CLR: GPIO48 (Bit 16)                         */
#define GPIO_INT1CLR_GPIO48_Msk           (0x10000UL)               /*!< GPIO INT1CLR: GPIO48 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO47_Pos           (15UL)                    /*!< GPIO INT1CLR: GPIO47 (Bit 15)                         */
#define GPIO_INT1CLR_GPIO47_Msk           (0x8000UL)                /*!< GPIO INT1CLR: GPIO47 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO46_Pos           (14UL)                    /*!< GPIO INT1CLR: GPIO46 (Bit 14)                         */
#define GPIO_INT1CLR_GPIO46_Msk           (0x4000UL)                /*!< GPIO INT1CLR: GPIO46 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO45_Pos           (13UL)                    /*!< GPIO INT1CLR: GPIO45 (Bit 13)                         */
#define GPIO_INT1CLR_GPIO45_Msk           (0x2000UL)                /*!< GPIO INT1CLR: GPIO45 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO44_Pos           (12UL)                    /*!< GPIO INT1CLR: GPIO44 (Bit 12)                         */
#define GPIO_INT1CLR_GPIO44_Msk           (0x1000UL)                /*!< GPIO INT1CLR: GPIO44 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO43_Pos           (11UL)                    /*!< GPIO INT1CLR: GPIO43 (Bit 11)                         */
#define GPIO_INT1CLR_GPIO43_Msk           (0x800UL)                 /*!< GPIO INT1CLR: GPIO43 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO42_Pos           (10UL)                    /*!< GPIO INT1CLR: GPIO42 (Bit 10)                         */
#define GPIO_INT1CLR_GPIO42_Msk           (0x400UL)                 /*!< GPIO INT1CLR: GPIO42 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO41_Pos           (9UL)                     /*!< GPIO INT1CLR: GPIO41 (Bit 9)                          */
#define GPIO_INT1CLR_GPIO41_Msk           (0x200UL)                 /*!< GPIO INT1CLR: GPIO41 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO40_Pos           (8UL)                     /*!< GPIO INT1CLR: GPIO40 (Bit 8)                          */
#define GPIO_INT1CLR_GPIO40_Msk           (0x100UL)                 /*!< GPIO INT1CLR: GPIO40 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO39_Pos           (7UL)                     /*!< GPIO INT1CLR: GPIO39 (Bit 7)                          */
#define GPIO_INT1CLR_GPIO39_Msk           (0x80UL)                  /*!< GPIO INT1CLR: GPIO39 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO38_Pos           (6UL)                     /*!< GPIO INT1CLR: GPIO38 (Bit 6)                          */
#define GPIO_INT1CLR_GPIO38_Msk           (0x40UL)                  /*!< GPIO INT1CLR: GPIO38 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO37_Pos           (5UL)                     /*!< GPIO INT1CLR: GPIO37 (Bit 5)                          */
#define GPIO_INT1CLR_GPIO37_Msk           (0x20UL)                  /*!< GPIO INT1CLR: GPIO37 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO36_Pos           (4UL)                     /*!< GPIO INT1CLR: GPIO36 (Bit 4)                          */
#define GPIO_INT1CLR_GPIO36_Msk           (0x10UL)                  /*!< GPIO INT1CLR: GPIO36 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO35_Pos           (3UL)                     /*!< GPIO INT1CLR: GPIO35 (Bit 3)                          */
#define GPIO_INT1CLR_GPIO35_Msk           (0x8UL)                   /*!< GPIO INT1CLR: GPIO35 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO34_Pos           (2UL)                     /*!< GPIO INT1CLR: GPIO34 (Bit 2)                          */
#define GPIO_INT1CLR_GPIO34_Msk           (0x4UL)                   /*!< GPIO INT1CLR: GPIO34 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO33_Pos           (1UL)                     /*!< GPIO INT1CLR: GPIO33 (Bit 1)                          */
#define GPIO_INT1CLR_GPIO33_Msk           (0x2UL)                   /*!< GPIO INT1CLR: GPIO33 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1CLR_GPIO32_Pos           (0UL)                     /*!< GPIO INT1CLR: GPIO32 (Bit 0)                          */
#define GPIO_INT1CLR_GPIO32_Msk           (0x1UL)                   /*!< GPIO INT1CLR: GPIO32 (Bitfield-Mask: 0x01)            */
/* ========================================================  INT1SET  ======================================================== */
#define GPIO_INT1SET_GPIO49_Pos           (17UL)                    /*!< GPIO INT1SET: GPIO49 (Bit 17)                         */
#define GPIO_INT1SET_GPIO49_Msk           (0x20000UL)               /*!< GPIO INT1SET: GPIO49 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO48_Pos           (16UL)                    /*!< GPIO INT1SET: GPIO48 (Bit 16)                         */
#define GPIO_INT1SET_GPIO48_Msk           (0x10000UL)               /*!< GPIO INT1SET: GPIO48 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO47_Pos           (15UL)                    /*!< GPIO INT1SET: GPIO47 (Bit 15)                         */
#define GPIO_INT1SET_GPIO47_Msk           (0x8000UL)                /*!< GPIO INT1SET: GPIO47 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO46_Pos           (14UL)                    /*!< GPIO INT1SET: GPIO46 (Bit 14)                         */
#define GPIO_INT1SET_GPIO46_Msk           (0x4000UL)                /*!< GPIO INT1SET: GPIO46 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO45_Pos           (13UL)                    /*!< GPIO INT1SET: GPIO45 (Bit 13)                         */
#define GPIO_INT1SET_GPIO45_Msk           (0x2000UL)                /*!< GPIO INT1SET: GPIO45 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO44_Pos           (12UL)                    /*!< GPIO INT1SET: GPIO44 (Bit 12)                         */
#define GPIO_INT1SET_GPIO44_Msk           (0x1000UL)                /*!< GPIO INT1SET: GPIO44 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO43_Pos           (11UL)                    /*!< GPIO INT1SET: GPIO43 (Bit 11)                         */
#define GPIO_INT1SET_GPIO43_Msk           (0x800UL)                 /*!< GPIO INT1SET: GPIO43 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO42_Pos           (10UL)                    /*!< GPIO INT1SET: GPIO42 (Bit 10)                         */
#define GPIO_INT1SET_GPIO42_Msk           (0x400UL)                 /*!< GPIO INT1SET: GPIO42 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO41_Pos           (9UL)                     /*!< GPIO INT1SET: GPIO41 (Bit 9)                          */
#define GPIO_INT1SET_GPIO41_Msk           (0x200UL)                 /*!< GPIO INT1SET: GPIO41 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO40_Pos           (8UL)                     /*!< GPIO INT1SET: GPIO40 (Bit 8)                          */
#define GPIO_INT1SET_GPIO40_Msk           (0x100UL)                 /*!< GPIO INT1SET: GPIO40 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO39_Pos           (7UL)                     /*!< GPIO INT1SET: GPIO39 (Bit 7)                          */
#define GPIO_INT1SET_GPIO39_Msk           (0x80UL)                  /*!< GPIO INT1SET: GPIO39 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO38_Pos           (6UL)                     /*!< GPIO INT1SET: GPIO38 (Bit 6)                          */
#define GPIO_INT1SET_GPIO38_Msk           (0x40UL)                  /*!< GPIO INT1SET: GPIO38 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO37_Pos           (5UL)                     /*!< GPIO INT1SET: GPIO37 (Bit 5)                          */
#define GPIO_INT1SET_GPIO37_Msk           (0x20UL)                  /*!< GPIO INT1SET: GPIO37 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO36_Pos           (4UL)                     /*!< GPIO INT1SET: GPIO36 (Bit 4)                          */
#define GPIO_INT1SET_GPIO36_Msk           (0x10UL)                  /*!< GPIO INT1SET: GPIO36 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO35_Pos           (3UL)                     /*!< GPIO INT1SET: GPIO35 (Bit 3)                          */
#define GPIO_INT1SET_GPIO35_Msk           (0x8UL)                   /*!< GPIO INT1SET: GPIO35 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO34_Pos           (2UL)                     /*!< GPIO INT1SET: GPIO34 (Bit 2)                          */
#define GPIO_INT1SET_GPIO34_Msk           (0x4UL)                   /*!< GPIO INT1SET: GPIO34 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO33_Pos           (1UL)                     /*!< GPIO INT1SET: GPIO33 (Bit 1)                          */
#define GPIO_INT1SET_GPIO33_Msk           (0x2UL)                   /*!< GPIO INT1SET: GPIO33 (Bitfield-Mask: 0x01)            */
#define GPIO_INT1SET_GPIO32_Pos           (0UL)                     /*!< GPIO INT1SET: GPIO32 (Bit 0)                          */
#define GPIO_INT1SET_GPIO32_Msk           (0x1UL)                   /*!< GPIO INT1SET: GPIO32 (Bitfield-Mask: 0x01)            */


/* =========================================================================================================================== */
/* ================                                          IOMSTR0                                          ================ */
/* =========================================================================================================================== */

/* =========================================================  FIFO  ========================================================== */
#define IOMSTR0_FIFO_FIFO_Pos             (0UL)                     /*!< IOMSTR0 FIFO: FIFO (Bit 0)                            */
#define IOMSTR0_FIFO_FIFO_Msk             (0xffffffffUL)            /*!< IOMSTR0 FIFO: FIFO (Bitfield-Mask: 0xffffffff)        */
/* ========================================================  FIFOPTR  ======================================================== */
#define IOMSTR0_FIFOPTR_FIFOREM_Pos       (16UL)                    /*!< IOMSTR0 FIFOPTR: FIFOREM (Bit 16)                     */
#define IOMSTR0_FIFOPTR_FIFOREM_Msk       (0x7f0000UL)              /*!< IOMSTR0 FIFOPTR: FIFOREM (Bitfield-Mask: 0x7f)        */
#define IOMSTR0_FIFOPTR_FIFOSIZ_Pos       (0UL)                     /*!< IOMSTR0 FIFOPTR: FIFOSIZ (Bit 0)                      */
#define IOMSTR0_FIFOPTR_FIFOSIZ_Msk       (0x7fUL)                  /*!< IOMSTR0 FIFOPTR: FIFOSIZ (Bitfield-Mask: 0x7f)        */
/* ========================================================  TLNGTH  ========================================================= */
#define IOMSTR0_TLNGTH_TLNGTH_Pos         (0UL)                     /*!< IOMSTR0 TLNGTH: TLNGTH (Bit 0)                        */
#define IOMSTR0_TLNGTH_TLNGTH_Msk         (0xfffUL)                 /*!< IOMSTR0 TLNGTH: TLNGTH (Bitfield-Mask: 0xfff)         */
/* ========================================================  FIFOTHR  ======================================================== */
#define IOMSTR0_FIFOTHR_FIFOWTHR_Pos      (8UL)                     /*!< IOMSTR0 FIFOTHR: FIFOWTHR (Bit 8)                     */
#define IOMSTR0_FIFOTHR_FIFOWTHR_Msk      (0x3f00UL)                /*!< IOMSTR0 FIFOTHR: FIFOWTHR (Bitfield-Mask: 0x3f)       */
#define IOMSTR0_FIFOTHR_FIFORTHR_Pos      (0UL)                     /*!< IOMSTR0 FIFOTHR: FIFORTHR (Bit 0)                     */
#define IOMSTR0_FIFOTHR_FIFORTHR_Msk      (0x3fUL)                  /*!< IOMSTR0 FIFOTHR: FIFORTHR (Bitfield-Mask: 0x3f)       */
/* ========================================================  CLKCFG  ========================================================= */
#define IOMSTR0_CLKCFG_TOTPER_Pos         (24UL)                    /*!< IOMSTR0 CLKCFG: TOTPER (Bit 24)                       */
#define IOMSTR0_CLKCFG_TOTPER_Msk         (0xff000000UL)            /*!< IOMSTR0 CLKCFG: TOTPER (Bitfield-Mask: 0xff)          */
#define IOMSTR0_CLKCFG_LOWPER_Pos         (16UL)                    /*!< IOMSTR0 CLKCFG: LOWPER (Bit 16)                       */
#define IOMSTR0_CLKCFG_LOWPER_Msk         (0xff0000UL)              /*!< IOMSTR0 CLKCFG: LOWPER (Bitfield-Mask: 0xff)          */
#define IOMSTR0_CLKCFG_DIVEN_Pos          (12UL)                    /*!< IOMSTR0 CLKCFG: DIVEN (Bit 12)                        */
#define IOMSTR0_CLKCFG_DIVEN_Msk          (0x1000UL)                /*!< IOMSTR0 CLKCFG: DIVEN (Bitfield-Mask: 0x01)           */
#define IOMSTR0_CLKCFG_DIV3_Pos           (11UL)                    /*!< IOMSTR0 CLKCFG: DIV3 (Bit 11)                         */
#define IOMSTR0_CLKCFG_DIV3_Msk           (0x800UL)                 /*!< IOMSTR0 CLKCFG: DIV3 (Bitfield-Mask: 0x01)            */
#define IOMSTR0_CLKCFG_FSEL_Pos           (8UL)                     /*!< IOMSTR0 CLKCFG: FSEL (Bit 8)                          */
#define IOMSTR0_CLKCFG_FSEL_Msk           (0x700UL)                 /*!< IOMSTR0 CLKCFG: FSEL (Bitfield-Mask: 0x07)            */
/* ==========================================================  CMD  ========================================================== */
#define IOMSTR0_CMD_CMD_Pos               (0UL)                     /*!< IOMSTR0 CMD: CMD (Bit 0)                              */
#define IOMSTR0_CMD_CMD_Msk               (0xffffffffUL)            /*!< IOMSTR0 CMD: CMD (Bitfield-Mask: 0xffffffff)          */
/* ========================================================  CMDRPT  ========================================================= */
#define IOMSTR0_CMDRPT_CMDRPT_Pos         (0UL)                     /*!< IOMSTR0 CMDRPT: CMDRPT (Bit 0)                        */
#define IOMSTR0_CMDRPT_CMDRPT_Msk         (0x1fUL)                  /*!< IOMSTR0 CMDRPT: CMDRPT (Bitfield-Mask: 0x1f)          */
/* ========================================================  STATUS  ========================================================= */
#define IOMSTR0_STATUS_IDLEST_Pos         (2UL)                     /*!< IOMSTR0 STATUS: IDLEST (Bit 2)                        */
#define IOMSTR0_STATUS_IDLEST_Msk         (0x4UL)                   /*!< IOMSTR0 STATUS: IDLEST (Bitfield-Mask: 0x01)          */
#define IOMSTR0_STATUS_CMDACT_Pos         (1UL)                     /*!< IOMSTR0 STATUS: CMDACT (Bit 1)                        */
#define IOMSTR0_STATUS_CMDACT_Msk         (0x2UL)                   /*!< IOMSTR0 STATUS: CMDACT (Bitfield-Mask: 0x01)          */
#define IOMSTR0_STATUS_ERR_Pos            (0UL)                     /*!< IOMSTR0 STATUS: ERR (Bit 0)                           */
#define IOMSTR0_STATUS_ERR_Msk            (0x1UL)                   /*!< IOMSTR0 STATUS: ERR (Bitfield-Mask: 0x01)             */
/* ==========================================================  CFG  ========================================================== */
#define IOMSTR0_CFG_IFCEN_Pos             (31UL)                    /*!< IOMSTR0 CFG: IFCEN (Bit 31)                           */
#define IOMSTR0_CFG_IFCEN_Msk             (0x80000000UL)            /*!< IOMSTR0 CFG: IFCEN (Bitfield-Mask: 0x01)              */
#define IOMSTR0_CFG_SPHA_Pos              (2UL)                     /*!< IOMSTR0 CFG: SPHA (Bit 2)                             */
#define IOMSTR0_CFG_SPHA_Msk              (0x4UL)                   /*!< IOMSTR0 CFG: SPHA (Bitfield-Mask: 0x01)               */
#define IOMSTR0_CFG_SPOL_Pos              (1UL)                     /*!< IOMSTR0 CFG: SPOL (Bit 1)                             */
#define IOMSTR0_CFG_SPOL_Msk              (0x2UL)                   /*!< IOMSTR0 CFG: SPOL (Bitfield-Mask: 0x01)               */
#define IOMSTR0_CFG_IFCSEL_Pos            (0UL)                     /*!< IOMSTR0 CFG: IFCSEL (Bit 0)                           */
#define IOMSTR0_CFG_IFCSEL_Msk            (0x1UL)                   /*!< IOMSTR0 CFG: IFCSEL (Bitfield-Mask: 0x01)             */
/* =========================================================  INTEN  ========================================================= */
#define IOMSTR0_INTEN_ARB_Pos             (10UL)                    /*!< IOMSTR0 INTEN: ARB (Bit 10)                           */
#define IOMSTR0_INTEN_ARB_Msk             (0x400UL)                 /*!< IOMSTR0 INTEN: ARB (Bitfield-Mask: 0x01)              */
#define IOMSTR0_INTEN_STOP_Pos            (9UL)                     /*!< IOMSTR0 INTEN: STOP (Bit 9)                           */
#define IOMSTR0_INTEN_STOP_Msk            (0x200UL)                 /*!< IOMSTR0 INTEN: STOP (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTEN_START_Pos           (8UL)                     /*!< IOMSTR0 INTEN: START (Bit 8)                          */
#define IOMSTR0_INTEN_START_Msk           (0x100UL)                 /*!< IOMSTR0 INTEN: START (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTEN_ICMD_Pos            (7UL)                     /*!< IOMSTR0 INTEN: ICMD (Bit 7)                           */
#define IOMSTR0_INTEN_ICMD_Msk            (0x80UL)                  /*!< IOMSTR0 INTEN: ICMD (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTEN_IACC_Pos            (6UL)                     /*!< IOMSTR0 INTEN: IACC (Bit 6)                           */
#define IOMSTR0_INTEN_IACC_Msk            (0x40UL)                  /*!< IOMSTR0 INTEN: IACC (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTEN_WTLEN_Pos           (5UL)                     /*!< IOMSTR0 INTEN: WTLEN (Bit 5)                          */
#define IOMSTR0_INTEN_WTLEN_Msk           (0x20UL)                  /*!< IOMSTR0 INTEN: WTLEN (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTEN_NAK_Pos             (4UL)                     /*!< IOMSTR0 INTEN: NAK (Bit 4)                            */
#define IOMSTR0_INTEN_NAK_Msk             (0x10UL)                  /*!< IOMSTR0 INTEN: NAK (Bitfield-Mask: 0x01)              */
#define IOMSTR0_INTEN_FOVFL_Pos           (3UL)                     /*!< IOMSTR0 INTEN: FOVFL (Bit 3)                          */
#define IOMSTR0_INTEN_FOVFL_Msk           (0x8UL)                   /*!< IOMSTR0 INTEN: FOVFL (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTEN_FUNDFL_Pos          (2UL)                     /*!< IOMSTR0 INTEN: FUNDFL (Bit 2)                         */
#define IOMSTR0_INTEN_FUNDFL_Msk          (0x4UL)                   /*!< IOMSTR0 INTEN: FUNDFL (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTEN_THR_Pos             (1UL)                     /*!< IOMSTR0 INTEN: THR (Bit 1)                            */
#define IOMSTR0_INTEN_THR_Msk             (0x2UL)                   /*!< IOMSTR0 INTEN: THR (Bitfield-Mask: 0x01)              */
#define IOMSTR0_INTEN_CMDCMP_Pos          (0UL)                     /*!< IOMSTR0 INTEN: CMDCMP (Bit 0)                         */
#define IOMSTR0_INTEN_CMDCMP_Msk          (0x1UL)                   /*!< IOMSTR0 INTEN: CMDCMP (Bitfield-Mask: 0x01)           */
/* ========================================================  INTSTAT  ======================================================== */
#define IOMSTR0_INTSTAT_ARB_Pos           (10UL)                    /*!< IOMSTR0 INTSTAT: ARB (Bit 10)                         */
#define IOMSTR0_INTSTAT_ARB_Msk           (0x400UL)                 /*!< IOMSTR0 INTSTAT: ARB (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTSTAT_STOP_Pos          (9UL)                     /*!< IOMSTR0 INTSTAT: STOP (Bit 9)                         */
#define IOMSTR0_INTSTAT_STOP_Msk          (0x200UL)                 /*!< IOMSTR0 INTSTAT: STOP (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTSTAT_START_Pos         (8UL)                     /*!< IOMSTR0 INTSTAT: START (Bit 8)                        */
#define IOMSTR0_INTSTAT_START_Msk         (0x100UL)                 /*!< IOMSTR0 INTSTAT: START (Bitfield-Mask: 0x01)          */
#define IOMSTR0_INTSTAT_ICMD_Pos          (7UL)                     /*!< IOMSTR0 INTSTAT: ICMD (Bit 7)                         */
#define IOMSTR0_INTSTAT_ICMD_Msk          (0x80UL)                  /*!< IOMSTR0 INTSTAT: ICMD (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTSTAT_IACC_Pos          (6UL)                     /*!< IOMSTR0 INTSTAT: IACC (Bit 6)                         */
#define IOMSTR0_INTSTAT_IACC_Msk          (0x40UL)                  /*!< IOMSTR0 INTSTAT: IACC (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTSTAT_WTLEN_Pos         (5UL)                     /*!< IOMSTR0 INTSTAT: WTLEN (Bit 5)                        */
#define IOMSTR0_INTSTAT_WTLEN_Msk         (0x20UL)                  /*!< IOMSTR0 INTSTAT: WTLEN (Bitfield-Mask: 0x01)          */
#define IOMSTR0_INTSTAT_NAK_Pos           (4UL)                     /*!< IOMSTR0 INTSTAT: NAK (Bit 4)                          */
#define IOMSTR0_INTSTAT_NAK_Msk           (0x10UL)                  /*!< IOMSTR0 INTSTAT: NAK (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTSTAT_FOVFL_Pos         (3UL)                     /*!< IOMSTR0 INTSTAT: FOVFL (Bit 3)                        */
#define IOMSTR0_INTSTAT_FOVFL_Msk         (0x8UL)                   /*!< IOMSTR0 INTSTAT: FOVFL (Bitfield-Mask: 0x01)          */
#define IOMSTR0_INTSTAT_FUNDFL_Pos        (2UL)                     /*!< IOMSTR0 INTSTAT: FUNDFL (Bit 2)                       */
#define IOMSTR0_INTSTAT_FUNDFL_Msk        (0x4UL)                   /*!< IOMSTR0 INTSTAT: FUNDFL (Bitfield-Mask: 0x01)         */
#define IOMSTR0_INTSTAT_THR_Pos           (1UL)                     /*!< IOMSTR0 INTSTAT: THR (Bit 1)                          */
#define IOMSTR0_INTSTAT_THR_Msk           (0x2UL)                   /*!< IOMSTR0 INTSTAT: THR (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTSTAT_CMDCMP_Pos        (0UL)                     /*!< IOMSTR0 INTSTAT: CMDCMP (Bit 0)                       */
#define IOMSTR0_INTSTAT_CMDCMP_Msk        (0x1UL)                   /*!< IOMSTR0 INTSTAT: CMDCMP (Bitfield-Mask: 0x01)         */
/* ========================================================  INTCLR  ========================================================= */
#define IOMSTR0_INTCLR_ARB_Pos            (10UL)                    /*!< IOMSTR0 INTCLR: ARB (Bit 10)                          */
#define IOMSTR0_INTCLR_ARB_Msk            (0x400UL)                 /*!< IOMSTR0 INTCLR: ARB (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTCLR_STOP_Pos           (9UL)                     /*!< IOMSTR0 INTCLR: STOP (Bit 9)                          */
#define IOMSTR0_INTCLR_STOP_Msk           (0x200UL)                 /*!< IOMSTR0 INTCLR: STOP (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTCLR_START_Pos          (8UL)                     /*!< IOMSTR0 INTCLR: START (Bit 8)                         */
#define IOMSTR0_INTCLR_START_Msk          (0x100UL)                 /*!< IOMSTR0 INTCLR: START (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTCLR_ICMD_Pos           (7UL)                     /*!< IOMSTR0 INTCLR: ICMD (Bit 7)                          */
#define IOMSTR0_INTCLR_ICMD_Msk           (0x80UL)                  /*!< IOMSTR0 INTCLR: ICMD (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTCLR_IACC_Pos           (6UL)                     /*!< IOMSTR0 INTCLR: IACC (Bit 6)                          */
#define IOMSTR0_INTCLR_IACC_Msk           (0x40UL)                  /*!< IOMSTR0 INTCLR: IACC (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTCLR_WTLEN_Pos          (5UL)                     /*!< IOMSTR0 INTCLR: WTLEN (Bit 5)                         */
#define IOMSTR0_INTCLR_WTLEN_Msk          (0x20UL)                  /*!< IOMSTR0 INTCLR: WTLEN (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTCLR_NAK_Pos            (4UL)                     /*!< IOMSTR0 INTCLR: NAK (Bit 4)                           */
#define IOMSTR0_INTCLR_NAK_Msk            (0x10UL)                  /*!< IOMSTR0 INTCLR: NAK (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTCLR_FOVFL_Pos          (3UL)                     /*!< IOMSTR0 INTCLR: FOVFL (Bit 3)                         */
#define IOMSTR0_INTCLR_FOVFL_Msk          (0x8UL)                   /*!< IOMSTR0 INTCLR: FOVFL (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTCLR_FUNDFL_Pos         (2UL)                     /*!< IOMSTR0 INTCLR: FUNDFL (Bit 2)                        */
#define IOMSTR0_INTCLR_FUNDFL_Msk         (0x4UL)                   /*!< IOMSTR0 INTCLR: FUNDFL (Bitfield-Mask: 0x01)          */
#define IOMSTR0_INTCLR_THR_Pos            (1UL)                     /*!< IOMSTR0 INTCLR: THR (Bit 1)                           */
#define IOMSTR0_INTCLR_THR_Msk            (0x2UL)                   /*!< IOMSTR0 INTCLR: THR (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTCLR_CMDCMP_Pos         (0UL)                     /*!< IOMSTR0 INTCLR: CMDCMP (Bit 0)                        */
#define IOMSTR0_INTCLR_CMDCMP_Msk         (0x1UL)                   /*!< IOMSTR0 INTCLR: CMDCMP (Bitfield-Mask: 0x01)          */
/* ========================================================  INTSET  ========================================================= */
#define IOMSTR0_INTSET_ARB_Pos            (10UL)                    /*!< IOMSTR0 INTSET: ARB (Bit 10)                          */
#define IOMSTR0_INTSET_ARB_Msk            (0x400UL)                 /*!< IOMSTR0 INTSET: ARB (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTSET_STOP_Pos           (9UL)                     /*!< IOMSTR0 INTSET: STOP (Bit 9)                          */
#define IOMSTR0_INTSET_STOP_Msk           (0x200UL)                 /*!< IOMSTR0 INTSET: STOP (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTSET_START_Pos          (8UL)                     /*!< IOMSTR0 INTSET: START (Bit 8)                         */
#define IOMSTR0_INTSET_START_Msk          (0x100UL)                 /*!< IOMSTR0 INTSET: START (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTSET_ICMD_Pos           (7UL)                     /*!< IOMSTR0 INTSET: ICMD (Bit 7)                          */
#define IOMSTR0_INTSET_ICMD_Msk           (0x80UL)                  /*!< IOMSTR0 INTSET: ICMD (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTSET_IACC_Pos           (6UL)                     /*!< IOMSTR0 INTSET: IACC (Bit 6)                          */
#define IOMSTR0_INTSET_IACC_Msk           (0x40UL)                  /*!< IOMSTR0 INTSET: IACC (Bitfield-Mask: 0x01)            */
#define IOMSTR0_INTSET_WTLEN_Pos          (5UL)                     /*!< IOMSTR0 INTSET: WTLEN (Bit 5)                         */
#define IOMSTR0_INTSET_WTLEN_Msk          (0x20UL)                  /*!< IOMSTR0 INTSET: WTLEN (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTSET_NAK_Pos            (4UL)                     /*!< IOMSTR0 INTSET: NAK (Bit 4)                           */
#define IOMSTR0_INTSET_NAK_Msk            (0x10UL)                  /*!< IOMSTR0 INTSET: NAK (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTSET_FOVFL_Pos          (3UL)                     /*!< IOMSTR0 INTSET: FOVFL (Bit 3)                         */
#define IOMSTR0_INTSET_FOVFL_Msk          (0x8UL)                   /*!< IOMSTR0 INTSET: FOVFL (Bitfield-Mask: 0x01)           */
#define IOMSTR0_INTSET_FUNDFL_Pos         (2UL)                     /*!< IOMSTR0 INTSET: FUNDFL (Bit 2)                        */
#define IOMSTR0_INTSET_FUNDFL_Msk         (0x4UL)                   /*!< IOMSTR0 INTSET: FUNDFL (Bitfield-Mask: 0x01)          */
#define IOMSTR0_INTSET_THR_Pos            (1UL)                     /*!< IOMSTR0 INTSET: THR (Bit 1)                           */
#define IOMSTR0_INTSET_THR_Msk            (0x2UL)                   /*!< IOMSTR0 INTSET: THR (Bitfield-Mask: 0x01)             */
#define IOMSTR0_INTSET_CMDCMP_Pos         (0UL)                     /*!< IOMSTR0 INTSET: CMDCMP (Bit 0)                        */
#define IOMSTR0_INTSET_CMDCMP_Msk         (0x1UL)                   /*!< IOMSTR0 INTSET: CMDCMP (Bitfield-Mask: 0x01)          */


/* =========================================================================================================================== */
/* ================                                          IOSLAVE                                          ================ */
/* =========================================================================================================================== */

/* ========================================================  FIFOPTR  ======================================================== */
#define IOSLAVE_FIFOPTR_FIFOSIZ_Pos       (8UL)                     /*!< IOSLAVE FIFOPTR: FIFOSIZ (Bit 8)                      */
#define IOSLAVE_FIFOPTR_FIFOSIZ_Msk       (0xff00UL)                /*!< IOSLAVE FIFOPTR: FIFOSIZ (Bitfield-Mask: 0xff)        */
#define IOSLAVE_FIFOPTR_FIFOPTR_Pos       (0UL)                     /*!< IOSLAVE FIFOPTR: FIFOPTR (Bit 0)                      */
#define IOSLAVE_FIFOPTR_FIFOPTR_Msk       (0xffUL)                  /*!< IOSLAVE FIFOPTR: FIFOPTR (Bitfield-Mask: 0xff)        */
/* ========================================================  FIFOCFG  ======================================================== */
#define IOSLAVE_FIFOCFG_ROBASE_Pos        (24UL)                    /*!< IOSLAVE FIFOCFG: ROBASE (Bit 24)                      */
#define IOSLAVE_FIFOCFG_ROBASE_Msk        (0x3f000000UL)            /*!< IOSLAVE FIFOCFG: ROBASE (Bitfield-Mask: 0x3f)         */
#define IOSLAVE_FIFOCFG_FIFOMAX_Pos       (8UL)                     /*!< IOSLAVE FIFOCFG: FIFOMAX (Bit 8)                      */
#define IOSLAVE_FIFOCFG_FIFOMAX_Msk       (0x3f00UL)                /*!< IOSLAVE FIFOCFG: FIFOMAX (Bitfield-Mask: 0x3f)        */
#define IOSLAVE_FIFOCFG_FIFOBASE_Pos      (0UL)                     /*!< IOSLAVE FIFOCFG: FIFOBASE (Bit 0)                     */
#define IOSLAVE_FIFOCFG_FIFOBASE_Msk      (0x1fUL)                  /*!< IOSLAVE FIFOCFG: FIFOBASE (Bitfield-Mask: 0x1f)       */
/* ========================================================  FIFOTHR  ======================================================== */
#define IOSLAVE_FIFOTHR_FIFOTHR_Pos       (0UL)                     /*!< IOSLAVE FIFOTHR: FIFOTHR (Bit 0)                      */
#define IOSLAVE_FIFOTHR_FIFOTHR_Msk       (0xffUL)                  /*!< IOSLAVE FIFOTHR: FIFOTHR (Bitfield-Mask: 0xff)        */
/* =========================================================  FUPD  ========================================================== */
#define IOSLAVE_FUPD_IOREAD_Pos           (1UL)                     /*!< IOSLAVE FUPD: IOREAD (Bit 1)                          */
#define IOSLAVE_FUPD_IOREAD_Msk           (0x2UL)                   /*!< IOSLAVE FUPD: IOREAD (Bitfield-Mask: 0x01)            */
#define IOSLAVE_FUPD_FIFOUPD_Pos          (0UL)                     /*!< IOSLAVE FUPD: FIFOUPD (Bit 0)                         */
#define IOSLAVE_FUPD_FIFOUPD_Msk          (0x1UL)                   /*!< IOSLAVE FUPD: FIFOUPD (Bitfield-Mask: 0x01)           */
/* ========================================================  FIFOCTR  ======================================================== */
#define IOSLAVE_FIFOCTR_FIFOCTR_Pos       (0UL)                     /*!< IOSLAVE FIFOCTR: FIFOCTR (Bit 0)                      */
#define IOSLAVE_FIFOCTR_FIFOCTR_Msk       (0x3ffUL)                 /*!< IOSLAVE FIFOCTR: FIFOCTR (Bitfield-Mask: 0x3ff)       */
/* ========================================================  FIFOINC  ======================================================== */
#define IOSLAVE_FIFOINC_FIFOINC_Pos       (0UL)                     /*!< IOSLAVE FIFOINC: FIFOINC (Bit 0)                      */
#define IOSLAVE_FIFOINC_FIFOINC_Msk       (0x3ffUL)                 /*!< IOSLAVE FIFOINC: FIFOINC (Bitfield-Mask: 0x3ff)       */
/* ==========================================================  CFG  ========================================================== */
#define IOSLAVE_CFG_IFCEN_Pos             (31UL)                    /*!< IOSLAVE CFG: IFCEN (Bit 31)                           */
#define IOSLAVE_CFG_IFCEN_Msk             (0x80000000UL)            /*!< IOSLAVE CFG: IFCEN (Bitfield-Mask: 0x01)              */
#define IOSLAVE_CFG_I2CADDR_Pos           (8UL)                     /*!< IOSLAVE CFG: I2CADDR (Bit 8)                          */
#define IOSLAVE_CFG_I2CADDR_Msk           (0xfff00UL)               /*!< IOSLAVE CFG: I2CADDR (Bitfield-Mask: 0xfff)           */
#define IOSLAVE_CFG_STARTRD_Pos           (4UL)                     /*!< IOSLAVE CFG: STARTRD (Bit 4)                          */
#define IOSLAVE_CFG_STARTRD_Msk           (0x10UL)                  /*!< IOSLAVE CFG: STARTRD (Bitfield-Mask: 0x01)            */
#define IOSLAVE_CFG_LSB_Pos               (2UL)                     /*!< IOSLAVE CFG: LSB (Bit 2)                              */
#define IOSLAVE_CFG_LSB_Msk               (0x4UL)                   /*!< IOSLAVE CFG: LSB (Bitfield-Mask: 0x01)                */
#define IOSLAVE_CFG_SPOL_Pos              (1UL)                     /*!< IOSLAVE CFG: SPOL (Bit 1)                             */
#define IOSLAVE_CFG_SPOL_Msk              (0x2UL)                   /*!< IOSLAVE CFG: SPOL (Bitfield-Mask: 0x01)               */
#define IOSLAVE_CFG_IFCSEL_Pos            (0UL)                     /*!< IOSLAVE CFG: IFCSEL (Bit 0)                           */
#define IOSLAVE_CFG_IFCSEL_Msk            (0x1UL)                   /*!< IOSLAVE CFG: IFCSEL (Bitfield-Mask: 0x01)             */
/* =========================================================  PRENC  ========================================================= */
#define IOSLAVE_PRENC_PRENC_Pos           (0UL)                     /*!< IOSLAVE PRENC: PRENC (Bit 0)                          */
#define IOSLAVE_PRENC_PRENC_Msk           (0x1fUL)                  /*!< IOSLAVE PRENC: PRENC (Bitfield-Mask: 0x1f)            */
/* =======================================================  IOINTCTL  ======================================================== */
#define IOSLAVE_IOINTCTL_IOINTSET_Pos     (24UL)                    /*!< IOSLAVE IOINTCTL: IOINTSET (Bit 24)                   */
#define IOSLAVE_IOINTCTL_IOINTSET_Msk     (0xff000000UL)            /*!< IOSLAVE IOINTCTL: IOINTSET (Bitfield-Mask: 0xff)      */
#define IOSLAVE_IOINTCTL_IOINTCLR_Pos     (16UL)                    /*!< IOSLAVE IOINTCTL: IOINTCLR (Bit 16)                   */
#define IOSLAVE_IOINTCTL_IOINTCLR_Msk     (0x10000UL)               /*!< IOSLAVE IOINTCTL: IOINTCLR (Bitfield-Mask: 0x01)      */
#define IOSLAVE_IOINTCTL_IOINT_Pos        (8UL)                     /*!< IOSLAVE IOINTCTL: IOINT (Bit 8)                       */
#define IOSLAVE_IOINTCTL_IOINT_Msk        (0xff00UL)                /*!< IOSLAVE IOINTCTL: IOINT (Bitfield-Mask: 0xff)         */
#define IOSLAVE_IOINTCTL_IOINTEN_Pos      (0UL)                     /*!< IOSLAVE IOINTCTL: IOINTEN (Bit 0)                     */
#define IOSLAVE_IOINTCTL_IOINTEN_Msk      (0xffUL)                  /*!< IOSLAVE IOINTCTL: IOINTEN (Bitfield-Mask: 0xff)       */
/* ========================================================  GENADD  ========================================================= */
#define IOSLAVE_GENADD_GADATA_Pos         (0UL)                     /*!< IOSLAVE GENADD: GADATA (Bit 0)                        */
#define IOSLAVE_GENADD_GADATA_Msk         (0xffUL)                  /*!< IOSLAVE GENADD: GADATA (Bitfield-Mask: 0xff)          */
/* =========================================================  INTEN  ========================================================= */
#define IOSLAVE_INTEN_IOINTW_Pos          (5UL)                     /*!< IOSLAVE INTEN: IOINTW (Bit 5)                         */
#define IOSLAVE_INTEN_IOINTW_Msk          (0x20UL)                  /*!< IOSLAVE INTEN: IOINTW (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTEN_GENAD_Pos           (4UL)                     /*!< IOSLAVE INTEN: GENAD (Bit 4)                          */
#define IOSLAVE_INTEN_GENAD_Msk           (0x10UL)                  /*!< IOSLAVE INTEN: GENAD (Bitfield-Mask: 0x01)            */
#define IOSLAVE_INTEN_FRDERR_Pos          (3UL)                     /*!< IOSLAVE INTEN: FRDERR (Bit 3)                         */
#define IOSLAVE_INTEN_FRDERR_Msk          (0x8UL)                   /*!< IOSLAVE INTEN: FRDERR (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTEN_FUNDFL_Pos          (2UL)                     /*!< IOSLAVE INTEN: FUNDFL (Bit 2)                         */
#define IOSLAVE_INTEN_FUNDFL_Msk          (0x4UL)                   /*!< IOSLAVE INTEN: FUNDFL (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTEN_FOVFL_Pos           (1UL)                     /*!< IOSLAVE INTEN: FOVFL (Bit 1)                          */
#define IOSLAVE_INTEN_FOVFL_Msk           (0x2UL)                   /*!< IOSLAVE INTEN: FOVFL (Bitfield-Mask: 0x01)            */
#define IOSLAVE_INTEN_FSIZE_Pos           (0UL)                     /*!< IOSLAVE INTEN: FSIZE (Bit 0)                          */
#define IOSLAVE_INTEN_FSIZE_Msk           (0x1UL)                   /*!< IOSLAVE INTEN: FSIZE (Bitfield-Mask: 0x01)            */
/* ========================================================  INTSTAT  ======================================================== */
#define IOSLAVE_INTSTAT_IOINTW_Pos        (5UL)                     /*!< IOSLAVE INTSTAT: IOINTW (Bit 5)                       */
#define IOSLAVE_INTSTAT_IOINTW_Msk        (0x20UL)                  /*!< IOSLAVE INTSTAT: IOINTW (Bitfield-Mask: 0x01)         */
#define IOSLAVE_INTSTAT_GENAD_Pos         (4UL)                     /*!< IOSLAVE INTSTAT: GENAD (Bit 4)                        */
#define IOSLAVE_INTSTAT_GENAD_Msk         (0x10UL)                  /*!< IOSLAVE INTSTAT: GENAD (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSTAT_FRDERR_Pos        (3UL)                     /*!< IOSLAVE INTSTAT: FRDERR (Bit 3)                       */
#define IOSLAVE_INTSTAT_FRDERR_Msk        (0x8UL)                   /*!< IOSLAVE INTSTAT: FRDERR (Bitfield-Mask: 0x01)         */
#define IOSLAVE_INTSTAT_FUNDFL_Pos        (2UL)                     /*!< IOSLAVE INTSTAT: FUNDFL (Bit 2)                       */
#define IOSLAVE_INTSTAT_FUNDFL_Msk        (0x4UL)                   /*!< IOSLAVE INTSTAT: FUNDFL (Bitfield-Mask: 0x01)         */
#define IOSLAVE_INTSTAT_FOVFL_Pos         (1UL)                     /*!< IOSLAVE INTSTAT: FOVFL (Bit 1)                        */
#define IOSLAVE_INTSTAT_FOVFL_Msk         (0x2UL)                   /*!< IOSLAVE INTSTAT: FOVFL (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSTAT_FSIZE_Pos         (0UL)                     /*!< IOSLAVE INTSTAT: FSIZE (Bit 0)                        */
#define IOSLAVE_INTSTAT_FSIZE_Msk         (0x1UL)                   /*!< IOSLAVE INTSTAT: FSIZE (Bitfield-Mask: 0x01)          */
/* ========================================================  INTCLR  ========================================================= */
#define IOSLAVE_INTCLR_IOINTW_Pos         (5UL)                     /*!< IOSLAVE INTCLR: IOINTW (Bit 5)                        */
#define IOSLAVE_INTCLR_IOINTW_Msk         (0x20UL)                  /*!< IOSLAVE INTCLR: IOINTW (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTCLR_GENAD_Pos          (4UL)                     /*!< IOSLAVE INTCLR: GENAD (Bit 4)                         */
#define IOSLAVE_INTCLR_GENAD_Msk          (0x10UL)                  /*!< IOSLAVE INTCLR: GENAD (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTCLR_FRDERR_Pos         (3UL)                     /*!< IOSLAVE INTCLR: FRDERR (Bit 3)                        */
#define IOSLAVE_INTCLR_FRDERR_Msk         (0x8UL)                   /*!< IOSLAVE INTCLR: FRDERR (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTCLR_FUNDFL_Pos         (2UL)                     /*!< IOSLAVE INTCLR: FUNDFL (Bit 2)                        */
#define IOSLAVE_INTCLR_FUNDFL_Msk         (0x4UL)                   /*!< IOSLAVE INTCLR: FUNDFL (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTCLR_FOVFL_Pos          (1UL)                     /*!< IOSLAVE INTCLR: FOVFL (Bit 1)                         */
#define IOSLAVE_INTCLR_FOVFL_Msk          (0x2UL)                   /*!< IOSLAVE INTCLR: FOVFL (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTCLR_FSIZE_Pos          (0UL)                     /*!< IOSLAVE INTCLR: FSIZE (Bit 0)                         */
#define IOSLAVE_INTCLR_FSIZE_Msk          (0x1UL)                   /*!< IOSLAVE INTCLR: FSIZE (Bitfield-Mask: 0x01)           */
/* ========================================================  INTSET  ========================================================= */
#define IOSLAVE_INTSET_IOINTW_Pos         (5UL)                     /*!< IOSLAVE INTSET: IOINTW (Bit 5)                        */
#define IOSLAVE_INTSET_IOINTW_Msk         (0x20UL)                  /*!< IOSLAVE INTSET: IOINTW (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSET_GENAD_Pos          (4UL)                     /*!< IOSLAVE INTSET: GENAD (Bit 4)                         */
#define IOSLAVE_INTSET_GENAD_Msk          (0x10UL)                  /*!< IOSLAVE INTSET: GENAD (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTSET_FRDERR_Pos         (3UL)                     /*!< IOSLAVE INTSET: FRDERR (Bit 3)                        */
#define IOSLAVE_INTSET_FRDERR_Msk         (0x8UL)                   /*!< IOSLAVE INTSET: FRDERR (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSET_FUNDFL_Pos         (2UL)                     /*!< IOSLAVE INTSET: FUNDFL (Bit 2)                        */
#define IOSLAVE_INTSET_FUNDFL_Msk         (0x4UL)                   /*!< IOSLAVE INTSET: FUNDFL (Bitfield-Mask: 0x01)          */
#define IOSLAVE_INTSET_FOVFL_Pos          (1UL)                     /*!< IOSLAVE INTSET: FOVFL (Bit 1)                         */
#define IOSLAVE_INTSET_FOVFL_Msk          (0x2UL)                   /*!< IOSLAVE INTSET: FOVFL (Bitfield-Mask: 0x01)           */
#define IOSLAVE_INTSET_FSIZE_Pos          (0UL)                     /*!< IOSLAVE INTSET: FSIZE (Bit 0)                         */
#define IOSLAVE_INTSET_FSIZE_Msk          (0x1UL)                   /*!< IOSLAVE INTSET: FSIZE (Bitfield-Mask: 0x01)           */
/* ======================================================  REGACCINTEN  ====================================================== */
#define IOSLAVE_REGACCINTEN_REGACC_Pos    (0UL)                     /*!< IOSLAVE REGACCINTEN: REGACC (Bit 0)                   */
#define IOSLAVE_REGACCINTEN_REGACC_Msk    (0xffffffffUL)            /*!< IOSLAVE REGACCINTEN: REGACC (Bitfield-Mask: 0xffffffff) */
/* =====================================================  REGACCINTSTAT  ===================================================== */
#define IOSLAVE_REGACCINTSTAT_REGACC_Pos  (0UL)                     /*!< IOSLAVE REGACCINTSTAT: REGACC (Bit 0)                 */
#define IOSLAVE_REGACCINTSTAT_REGACC_Msk  (0xffffffffUL)            /*!< IOSLAVE REGACCINTSTAT: REGACC (Bitfield-Mask: 0xffffffff) */
/* =====================================================  REGACCINTCLR  ====================================================== */
#define IOSLAVE_REGACCINTCLR_REGACC_Pos   (0UL)                     /*!< IOSLAVE REGACCINTCLR: REGACC (Bit 0)                  */
#define IOSLAVE_REGACCINTCLR_REGACC_Msk   (0xffffffffUL)            /*!< IOSLAVE REGACCINTCLR: REGACC (Bitfield-Mask: 0xffffffff) */
/* =====================================================  REGACCINTSET  ====================================================== */
#define IOSLAVE_REGACCINTSET_REGACC_Pos   (0UL)                     /*!< IOSLAVE REGACCINTSET: REGACC (Bit 0)                  */
#define IOSLAVE_REGACCINTSET_REGACC_Msk   (0xffffffffUL)            /*!< IOSLAVE REGACCINTSET: REGACC (Bitfield-Mask: 0xffffffff) */


/* =========================================================================================================================== */
/* ================                                          MCUCTRL                                          ================ */
/* =========================================================================================================================== */

/* =======================================================  CHIP_INFO  ======================================================= */
#define MCUCTRL_CHIP_INFO_CLASS_Pos       (24UL)                    /*!< MCUCTRL CHIP_INFO: CLASS (Bit 24)                     */
#define MCUCTRL_CHIP_INFO_CLASS_Msk       (0xff000000UL)            /*!< MCUCTRL CHIP_INFO: CLASS (Bitfield-Mask: 0xff)        */
#define MCUCTRL_CHIP_INFO_FLASH_Pos       (20UL)                    /*!< MCUCTRL CHIP_INFO: FLASH (Bit 20)                     */
#define MCUCTRL_CHIP_INFO_FLASH_Msk       (0xf00000UL)              /*!< MCUCTRL CHIP_INFO: FLASH (Bitfield-Mask: 0x0f)        */
#define MCUCTRL_CHIP_INFO_RAM_Pos         (16UL)                    /*!< MCUCTRL CHIP_INFO: RAM (Bit 16)                       */
#define MCUCTRL_CHIP_INFO_RAM_Msk         (0xf0000UL)               /*!< MCUCTRL CHIP_INFO: RAM (Bitfield-Mask: 0x0f)          */
#define MCUCTRL_CHIP_INFO_MAJORREV_Pos    (12UL)                    /*!< MCUCTRL CHIP_INFO: MAJORREV (Bit 12)                  */
#define MCUCTRL_CHIP_INFO_MAJORREV_Msk    (0xf000UL)                /*!< MCUCTRL CHIP_INFO: MAJORREV (Bitfield-Mask: 0x0f)     */
#define MCUCTRL_CHIP_INFO_MINORREV_Pos    (8UL)                     /*!< MCUCTRL CHIP_INFO: MINORREV (Bit 8)                   */
#define MCUCTRL_CHIP_INFO_MINORREV_Msk    (0xf00UL)                 /*!< MCUCTRL CHIP_INFO: MINORREV (Bitfield-Mask: 0x0f)     */
#define MCUCTRL_CHIP_INFO_PKG_Pos         (6UL)                     /*!< MCUCTRL CHIP_INFO: PKG (Bit 6)                        */
#define MCUCTRL_CHIP_INFO_PKG_Msk         (0xc0UL)                  /*!< MCUCTRL CHIP_INFO: PKG (Bitfield-Mask: 0x03)          */
#define MCUCTRL_CHIP_INFO_PINS_Pos        (3UL)                     /*!< MCUCTRL CHIP_INFO: PINS (Bit 3)                       */
#define MCUCTRL_CHIP_INFO_PINS_Msk        (0x38UL)                  /*!< MCUCTRL CHIP_INFO: PINS (Bitfield-Mask: 0x07)         */
#define MCUCTRL_CHIP_INFO_TEMP_Pos        (1UL)                     /*!< MCUCTRL CHIP_INFO: TEMP (Bit 1)                       */
#define MCUCTRL_CHIP_INFO_TEMP_Msk        (0x6UL)                   /*!< MCUCTRL CHIP_INFO: TEMP (Bitfield-Mask: 0x03)         */
#define MCUCTRL_CHIP_INFO_QUAL_Pos        (0UL)                     /*!< MCUCTRL CHIP_INFO: QUAL (Bit 0)                       */
#define MCUCTRL_CHIP_INFO_QUAL_Msk        (0x1UL)                   /*!< MCUCTRL CHIP_INFO: QUAL (Bitfield-Mask: 0x01)         */
/* ========================================================  CHIPID0  ======================================================== */
#define MCUCTRL_CHIPID0_VALUE_Pos         (0UL)                     /*!< MCUCTRL CHIPID0: VALUE (Bit 0)                        */
#define MCUCTRL_CHIPID0_VALUE_Msk         (0xffffffffUL)            /*!< MCUCTRL CHIPID0: VALUE (Bitfield-Mask: 0xffffffff)    */
/* ========================================================  CHIPID1  ======================================================== */
#define MCUCTRL_CHIPID1_VALUE_Pos         (0UL)                     /*!< MCUCTRL CHIPID1: VALUE (Bit 0)                        */
#define MCUCTRL_CHIPID1_VALUE_Msk         (0xffffffffUL)            /*!< MCUCTRL CHIPID1: VALUE (Bitfield-Mask: 0xffffffff)    */
/* ========================================================  CHIPREV  ======================================================== */
#define MCUCTRL_CHIPREV_REVISION_Pos      (0UL)                     /*!< MCUCTRL CHIPREV: REVISION (Bit 0)                     */
#define MCUCTRL_CHIPREV_REVISION_Msk      (0xffUL)                  /*!< MCUCTRL CHIPREV: REVISION (Bitfield-Mask: 0xff)       */
/* =======================================================  SUPPLYSRC  ======================================================= */
#define MCUCTRL_SUPPLYSRC_COREBUCKEN_Pos  (1UL)                     /*!< MCUCTRL SUPPLYSRC: COREBUCKEN (Bit 1)                 */
#define MCUCTRL_SUPPLYSRC_COREBUCKEN_Msk  (0x2UL)                   /*!< MCUCTRL SUPPLYSRC: COREBUCKEN (Bitfield-Mask: 0x01)   */
#define MCUCTRL_SUPPLYSRC_MEMBUCKEN_Pos   (0UL)                     /*!< MCUCTRL SUPPLYSRC: MEMBUCKEN (Bit 0)                  */
#define MCUCTRL_SUPPLYSRC_MEMBUCKEN_Msk   (0x1UL)                   /*!< MCUCTRL SUPPLYSRC: MEMBUCKEN (Bitfield-Mask: 0x01)    */
/* =====================================================  SUPPLYSTATUS  ====================================================== */
#define MCUCTRL_SUPPLYSTATUS_COREBUCKON_Pos (1UL)                   /*!< MCUCTRL SUPPLYSTATUS: COREBUCKON (Bit 1)              */
#define MCUCTRL_SUPPLYSTATUS_COREBUCKON_Msk (0x2UL)                 /*!< MCUCTRL SUPPLYSTATUS: COREBUCKON (Bitfield-Mask: 0x01) */
#define MCUCTRL_SUPPLYSTATUS_MEMBUCKON_Pos (0UL)                    /*!< MCUCTRL SUPPLYSTATUS: MEMBUCKON (Bit 0)               */
#define MCUCTRL_SUPPLYSTATUS_MEMBUCKON_Msk (0x1UL)                  /*!< MCUCTRL SUPPLYSTATUS: MEMBUCKON (Bitfield-Mask: 0x01) */
/* =======================================================  BANDGAPEN  ======================================================= */
#define MCUCTRL_BANDGAPEN_BGPEN_Pos       (0UL)                     /*!< MCUCTRL BANDGAPEN: BGPEN (Bit 0)                      */
#define MCUCTRL_BANDGAPEN_BGPEN_Msk       (0x1UL)                   /*!< MCUCTRL BANDGAPEN: BGPEN (Bitfield-Mask: 0x01)        */
/* ====================================================  SRAMPWDINSLEEP  ===================================================== */
#define MCUCTRL_SRAMPWDINSLEEP_BANK7_Pos  (7UL)                     /*!< MCUCTRL SRAMPWDINSLEEP: BANK7 (Bit 7)                 */
#define MCUCTRL_SRAMPWDINSLEEP_BANK7_Msk  (0x80UL)                  /*!< MCUCTRL SRAMPWDINSLEEP: BANK7 (Bitfield-Mask: 0x01)   */
#define MCUCTRL_SRAMPWDINSLEEP_BANK6_Pos  (6UL)                     /*!< MCUCTRL SRAMPWDINSLEEP: BANK6 (Bit 6)                 */
#define MCUCTRL_SRAMPWDINSLEEP_BANK6_Msk  (0x40UL)                  /*!< MCUCTRL SRAMPWDINSLEEP: BANK6 (Bitfield-Mask: 0x01)   */
#define MCUCTRL_SRAMPWDINSLEEP_BANK5_Pos  (5UL)                     /*!< MCUCTRL SRAMPWDINSLEEP: BANK5 (Bit 5)                 */
#define MCUCTRL_SRAMPWDINSLEEP_BANK5_Msk  (0x20UL)                  /*!< MCUCTRL SRAMPWDINSLEEP: BANK5 (Bitfield-Mask: 0x01)   */
#define MCUCTRL_SRAMPWDINSLEEP_BANK4_Pos  (4UL)                     /*!< MCUCTRL SRAMPWDINSLEEP: BANK4 (Bit 4)                 */
#define MCUCTRL_SRAMPWDINSLEEP_BANK4_Msk  (0x10UL)                  /*!< MCUCTRL SRAMPWDINSLEEP: BANK4 (Bitfield-Mask: 0x01)   */
#define MCUCTRL_SRAMPWDINSLEEP_BANK3_Pos  (3UL)                     /*!< MCUCTRL SRAMPWDINSLEEP: BANK3 (Bit 3)                 */
#define MCUCTRL_SRAMPWDINSLEEP_BANK3_Msk  (0x8UL)                   /*!< MCUCTRL SRAMPWDINSLEEP: BANK3 (Bitfield-Mask: 0x01)   */
#define MCUCTRL_SRAMPWDINSLEEP_BANK2_Pos  (2UL)                     /*!< MCUCTRL SRAMPWDINSLEEP: BANK2 (Bit 2)                 */
#define MCUCTRL_SRAMPWDINSLEEP_BANK2_Msk  (0x4UL)                   /*!< MCUCTRL SRAMPWDINSLEEP: BANK2 (Bitfield-Mask: 0x01)   */
#define MCUCTRL_SRAMPWDINSLEEP_BANK1_Pos  (1UL)                     /*!< MCUCTRL SRAMPWDINSLEEP: BANK1 (Bit 1)                 */
#define MCUCTRL_SRAMPWDINSLEEP_BANK1_Msk  (0x2UL)                   /*!< MCUCTRL SRAMPWDINSLEEP: BANK1 (Bitfield-Mask: 0x01)   */
#define MCUCTRL_SRAMPWDINSLEEP_BANK0_Pos  (0UL)                     /*!< MCUCTRL SRAMPWDINSLEEP: BANK0 (Bit 0)                 */
#define MCUCTRL_SRAMPWDINSLEEP_BANK0_Msk  (0x1UL)                   /*!< MCUCTRL SRAMPWDINSLEEP: BANK0 (Bitfield-Mask: 0x01)   */
/* ======================================================  SRAMPWRDIS  ======================================================= */
#define MCUCTRL_SRAMPWRDIS_BANK7_Pos      (7UL)                     /*!< MCUCTRL SRAMPWRDIS: BANK7 (Bit 7)                     */
#define MCUCTRL_SRAMPWRDIS_BANK7_Msk      (0x80UL)                  /*!< MCUCTRL SRAMPWRDIS: BANK7 (Bitfield-Mask: 0x01)       */
#define MCUCTRL_SRAMPWRDIS_BANK6_Pos      (6UL)                     /*!< MCUCTRL SRAMPWRDIS: BANK6 (Bit 6)                     */
#define MCUCTRL_SRAMPWRDIS_BANK6_Msk      (0x40UL)                  /*!< MCUCTRL SRAMPWRDIS: BANK6 (Bitfield-Mask: 0x01)       */
#define MCUCTRL_SRAMPWRDIS_BANK5_Pos      (5UL)                     /*!< MCUCTRL SRAMPWRDIS: BANK5 (Bit 5)                     */
#define MCUCTRL_SRAMPWRDIS_BANK5_Msk      (0x20UL)                  /*!< MCUCTRL SRAMPWRDIS: BANK5 (Bitfield-Mask: 0x01)       */
#define MCUCTRL_SRAMPWRDIS_BANK4_Pos      (4UL)                     /*!< MCUCTRL SRAMPWRDIS: BANK4 (Bit 4)                     */
#define MCUCTRL_SRAMPWRDIS_BANK4_Msk      (0x10UL)                  /*!< MCUCTRL SRAMPWRDIS: BANK4 (Bitfield-Mask: 0x01)       */
#define MCUCTRL_SRAMPWRDIS_BANK3_Pos      (3UL)                     /*!< MCUCTRL SRAMPWRDIS: BANK3 (Bit 3)                     */
#define MCUCTRL_SRAMPWRDIS_BANK3_Msk      (0x8UL)                   /*!< MCUCTRL SRAMPWRDIS: BANK3 (Bitfield-Mask: 0x01)       */
#define MCUCTRL_SRAMPWRDIS_BANK2_Pos      (2UL)                     /*!< MCUCTRL SRAMPWRDIS: BANK2 (Bit 2)                     */
#define MCUCTRL_SRAMPWRDIS_BANK2_Msk      (0x4UL)                   /*!< MCUCTRL SRAMPWRDIS: BANK2 (Bitfield-Mask: 0x01)       */
#define MCUCTRL_SRAMPWRDIS_BANK1_Pos      (1UL)                     /*!< MCUCTRL SRAMPWRDIS: BANK1 (Bit 1)                     */
#define MCUCTRL_SRAMPWRDIS_BANK1_Msk      (0x2UL)                   /*!< MCUCTRL SRAMPWRDIS: BANK1 (Bitfield-Mask: 0x01)       */
#define MCUCTRL_SRAMPWRDIS_BANK0_Pos      (0UL)                     /*!< MCUCTRL SRAMPWRDIS: BANK0 (Bit 0)                     */
#define MCUCTRL_SRAMPWRDIS_BANK0_Msk      (0x1UL)                   /*!< MCUCTRL SRAMPWRDIS: BANK0 (Bitfield-Mask: 0x01)       */
/* ======================================================  FLASHPWRDIS  ====================================================== */
#define MCUCTRL_FLASHPWRDIS_BANK1_Pos     (1UL)                     /*!< MCUCTRL FLASHPWRDIS: BANK1 (Bit 1)                    */
#define MCUCTRL_FLASHPWRDIS_BANK1_Msk     (0x2UL)                   /*!< MCUCTRL FLASHPWRDIS: BANK1 (Bitfield-Mask: 0x01)      */
#define MCUCTRL_FLASHPWRDIS_BANK0_Pos     (0UL)                     /*!< MCUCTRL FLASHPWRDIS: BANK0 (Bit 0)                    */
#define MCUCTRL_FLASHPWRDIS_BANK0_Msk     (0x1UL)                   /*!< MCUCTRL FLASHPWRDIS: BANK0 (Bitfield-Mask: 0x01)      */
/* ====================================================  ICODEFAULTADDR  ===================================================== */
#define MCUCTRL_ICODEFAULTADDR_ADDR_Pos   (0UL)                     /*!< MCUCTRL ICODEFAULTADDR: ADDR (Bit 0)                  */
#define MCUCTRL_ICODEFAULTADDR_ADDR_Msk   (0xffffffffUL)            /*!< MCUCTRL ICODEFAULTADDR: ADDR (Bitfield-Mask: 0xffffffff) */
/* ====================================================  DCODEFAULTADDR  ===================================================== */
#define MCUCTRL_DCODEFAULTADDR_ADDR_Pos   (0UL)                     /*!< MCUCTRL DCODEFAULTADDR: ADDR (Bit 0)                  */
#define MCUCTRL_DCODEFAULTADDR_ADDR_Msk   (0xffffffffUL)            /*!< MCUCTRL DCODEFAULTADDR: ADDR (Bitfield-Mask: 0xffffffff) */
/* =====================================================  SYSFAULTADDR  ====================================================== */
#define MCUCTRL_SYSFAULTADDR_ADDR_Pos     (0UL)                     /*!< MCUCTRL SYSFAULTADDR: ADDR (Bit 0)                    */
#define MCUCTRL_SYSFAULTADDR_ADDR_Msk     (0xffffffffUL)            /*!< MCUCTRL SYSFAULTADDR: ADDR (Bitfield-Mask: 0xffffffff) */
/* ======================================================  FAULTSTATUS  ====================================================== */
#define MCUCTRL_FAULTSTATUS_SYS_Pos       (2UL)                     /*!< MCUCTRL FAULTSTATUS: SYS (Bit 2)                      */
#define MCUCTRL_FAULTSTATUS_SYS_Msk       (0x4UL)                   /*!< MCUCTRL FAULTSTATUS: SYS (Bitfield-Mask: 0x01)        */
#define MCUCTRL_FAULTSTATUS_DCODE_Pos     (1UL)                     /*!< MCUCTRL FAULTSTATUS: DCODE (Bit 1)                    */
#define MCUCTRL_FAULTSTATUS_DCODE_Msk     (0x2UL)                   /*!< MCUCTRL FAULTSTATUS: DCODE (Bitfield-Mask: 0x01)      */
#define MCUCTRL_FAULTSTATUS_ICODE_Pos     (0UL)                     /*!< MCUCTRL FAULTSTATUS: ICODE (Bit 0)                    */
#define MCUCTRL_FAULTSTATUS_ICODE_Msk     (0x1UL)                   /*!< MCUCTRL FAULTSTATUS: ICODE (Bitfield-Mask: 0x01)      */
/* ====================================================  FAULTCAPTUREEN  ===================================================== */
#define MCUCTRL_FAULTCAPTUREEN_ENABLE_Pos (0UL)                     /*!< MCUCTRL FAULTCAPTUREEN: ENABLE (Bit 0)                */
#define MCUCTRL_FAULTCAPTUREEN_ENABLE_Msk (0x1UL)                   /*!< MCUCTRL FAULTCAPTUREEN: ENABLE (Bitfield-Mask: 0x01)  */
/* =======================================================  TPIUCTRL  ======================================================== */
#define MCUCTRL_TPIUCTRL_CLKSEL_Pos       (8UL)                     /*!< MCUCTRL TPIUCTRL: CLKSEL (Bit 8)                      */
#define MCUCTRL_TPIUCTRL_CLKSEL_Msk       (0x300UL)                 /*!< MCUCTRL TPIUCTRL: CLKSEL (Bitfield-Mask: 0x03)        */
#define MCUCTRL_TPIUCTRL_ENABLE_Pos       (0UL)                     /*!< MCUCTRL TPIUCTRL: ENABLE (Bit 0)                      */
#define MCUCTRL_TPIUCTRL_ENABLE_Msk       (0x1UL)                   /*!< MCUCTRL TPIUCTRL: ENABLE (Bitfield-Mask: 0x01)        */


/* =========================================================================================================================== */
/* ================                                          RSTGEN                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define RSTGEN_CFG_WDREN_Pos              (1UL)                     /*!< RSTGEN CFG: WDREN (Bit 1)                             */
#define RSTGEN_CFG_WDREN_Msk              (0x2UL)                   /*!< RSTGEN CFG: WDREN (Bitfield-Mask: 0x01)               */
#define RSTGEN_CFG_BODHREN_Pos            (0UL)                     /*!< RSTGEN CFG: BODHREN (Bit 0)                           */
#define RSTGEN_CFG_BODHREN_Msk            (0x1UL)                   /*!< RSTGEN CFG: BODHREN (Bitfield-Mask: 0x01)             */
/* =========================================================  SWPOI  ========================================================= */
#define RSTGEN_SWPOI_SWPOIKEY_Pos         (0UL)                     /*!< RSTGEN SWPOI: SWPOIKEY (Bit 0)                        */
#define RSTGEN_SWPOI_SWPOIKEY_Msk         (0xffUL)                  /*!< RSTGEN SWPOI: SWPOIKEY (Bitfield-Mask: 0xff)          */
/* =========================================================  SWPOR  ========================================================= */
#define RSTGEN_SWPOR_SWPORKEY_Pos         (0UL)                     /*!< RSTGEN SWPOR: SWPORKEY (Bit 0)                        */
#define RSTGEN_SWPOR_SWPORKEY_Msk         (0xffUL)                  /*!< RSTGEN SWPOR: SWPORKEY (Bitfield-Mask: 0xff)          */
/* =========================================================  STAT  ========================================================== */
#define RSTGEN_STAT_WDRSTAT_Pos           (6UL)                     /*!< RSTGEN STAT: WDRSTAT (Bit 6)                          */
#define RSTGEN_STAT_WDRSTAT_Msk           (0x40UL)                  /*!< RSTGEN STAT: WDRSTAT (Bitfield-Mask: 0x01)            */
#define RSTGEN_STAT_DBGRSTAT_Pos          (5UL)                     /*!< RSTGEN STAT: DBGRSTAT (Bit 5)                         */
#define RSTGEN_STAT_DBGRSTAT_Msk          (0x20UL)                  /*!< RSTGEN STAT: DBGRSTAT (Bitfield-Mask: 0x01)           */
#define RSTGEN_STAT_POIRSTAT_Pos          (4UL)                     /*!< RSTGEN STAT: POIRSTAT (Bit 4)                         */
#define RSTGEN_STAT_POIRSTAT_Msk          (0x10UL)                  /*!< RSTGEN STAT: POIRSTAT (Bitfield-Mask: 0x01)           */
#define RSTGEN_STAT_SWRSTAT_Pos           (3UL)                     /*!< RSTGEN STAT: SWRSTAT (Bit 3)                          */
#define RSTGEN_STAT_SWRSTAT_Msk           (0x8UL)                   /*!< RSTGEN STAT: SWRSTAT (Bitfield-Mask: 0x01)            */
#define RSTGEN_STAT_BORSTAT_Pos           (2UL)                     /*!< RSTGEN STAT: BORSTAT (Bit 2)                          */
#define RSTGEN_STAT_BORSTAT_Msk           (0x4UL)                   /*!< RSTGEN STAT: BORSTAT (Bitfield-Mask: 0x01)            */
#define RSTGEN_STAT_PORSTAT_Pos           (1UL)                     /*!< RSTGEN STAT: PORSTAT (Bit 1)                          */
#define RSTGEN_STAT_PORSTAT_Msk           (0x2UL)                   /*!< RSTGEN STAT: PORSTAT (Bitfield-Mask: 0x01)            */
#define RSTGEN_STAT_EXRSTAT_Pos           (0UL)                     /*!< RSTGEN STAT: EXRSTAT (Bit 0)                          */
#define RSTGEN_STAT_EXRSTAT_Msk           (0x1UL)                   /*!< RSTGEN STAT: EXRSTAT (Bitfield-Mask: 0x01)            */
/* ========================================================  CLRSTAT  ======================================================== */
#define RSTGEN_CLRSTAT_CLRSTAT_Pos        (0UL)                     /*!< RSTGEN CLRSTAT: CLRSTAT (Bit 0)                       */
#define RSTGEN_CLRSTAT_CLRSTAT_Msk        (0x1UL)                   /*!< RSTGEN CLRSTAT: CLRSTAT (Bitfield-Mask: 0x01)         */
/* =========================================================  INTEN  ========================================================= */
#define RSTGEN_INTEN_BODH_Pos             (0UL)                     /*!< RSTGEN INTEN: BODH (Bit 0)                            */
#define RSTGEN_INTEN_BODH_Msk             (0x1UL)                   /*!< RSTGEN INTEN: BODH (Bitfield-Mask: 0x01)              */
/* ========================================================  INTSTAT  ======================================================== */
#define RSTGEN_INTSTAT_BODH_Pos           (0UL)                     /*!< RSTGEN INTSTAT: BODH (Bit 0)                          */
#define RSTGEN_INTSTAT_BODH_Msk           (0x1UL)                   /*!< RSTGEN INTSTAT: BODH (Bitfield-Mask: 0x01)            */
/* ========================================================  INTCLR  ========================================================= */
#define RSTGEN_INTCLR_BODH_Pos            (0UL)                     /*!< RSTGEN INTCLR: BODH (Bit 0)                           */
#define RSTGEN_INTCLR_BODH_Msk            (0x1UL)                   /*!< RSTGEN INTCLR: BODH (Bitfield-Mask: 0x01)             */
/* ========================================================  INTSET  ========================================================= */
#define RSTGEN_INTSET_BODH_Pos            (0UL)                     /*!< RSTGEN INTSET: BODH (Bit 0)                           */
#define RSTGEN_INTSET_BODH_Msk            (0x1UL)                   /*!< RSTGEN INTSET: BODH (Bitfield-Mask: 0x01)             */


/* =========================================================================================================================== */
/* ================                                           UART                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  DR  =========================================================== */
#define UART_DR_OEDATA_Pos                (11UL)                    /*!< UART DR: OEDATA (Bit 11)                              */
#define UART_DR_OEDATA_Msk                (0x800UL)                 /*!< UART DR: OEDATA (Bitfield-Mask: 0x01)                 */
#define UART_DR_BEDATA_Pos                (10UL)                    /*!< UART DR: BEDATA (Bit 10)                              */
#define UART_DR_BEDATA_Msk                (0x400UL)                 /*!< UART DR: BEDATA (Bitfield-Mask: 0x01)                 */
#define UART_DR_PEDATA_Pos                (9UL)                     /*!< UART DR: PEDATA (Bit 9)                               */
#define UART_DR_PEDATA_Msk                (0x200UL)                 /*!< UART DR: PEDATA (Bitfield-Mask: 0x01)                 */
#define UART_DR_FEDATA_Pos                (8UL)                     /*!< UART DR: FEDATA (Bit 8)                               */
#define UART_DR_FEDATA_Msk                (0x100UL)                 /*!< UART DR: FEDATA (Bitfield-Mask: 0x01)                 */
#define UART_DR_DATA_Pos                  (0UL)                     /*!< UART DR: DATA (Bit 0)                                 */
#define UART_DR_DATA_Msk                  (0xffUL)                  /*!< UART DR: DATA (Bitfield-Mask: 0xff)                   */
/* ==========================================================  RSR  ========================================================== */
#define UART_RSR_OESTAT_Pos               (3UL)                     /*!< UART RSR: OESTAT (Bit 3)                              */
#define UART_RSR_OESTAT_Msk               (0x8UL)                   /*!< UART RSR: OESTAT (Bitfield-Mask: 0x01)                */
#define UART_RSR_BESTAT_Pos               (2UL)                     /*!< UART RSR: BESTAT (Bit 2)                              */
#define UART_RSR_BESTAT_Msk               (0x4UL)                   /*!< UART RSR: BESTAT (Bitfield-Mask: 0x01)                */
#define UART_RSR_PESTAT_Pos               (1UL)                     /*!< UART RSR: PESTAT (Bit 1)                              */
#define UART_RSR_PESTAT_Msk               (0x2UL)                   /*!< UART RSR: PESTAT (Bitfield-Mask: 0x01)                */
#define UART_RSR_FESTAT_Pos               (0UL)                     /*!< UART RSR: FESTAT (Bit 0)                              */
#define UART_RSR_FESTAT_Msk               (0x1UL)                   /*!< UART RSR: FESTAT (Bitfield-Mask: 0x01)                */
/* ==========================================================  FR  =========================================================== */
#define UART_FR_RI_Pos                    (8UL)                     /*!< UART FR: RI (Bit 8)                                   */
#define UART_FR_RI_Msk                    (0x100UL)                 /*!< UART FR: RI (Bitfield-Mask: 0x01)                     */
#define UART_FR_TXFE_Pos                  (7UL)                     /*!< UART FR: TXFE (Bit 7)                                 */
#define UART_FR_TXFE_Msk                  (0x80UL)                  /*!< UART FR: TXFE (Bitfield-Mask: 0x01)                   */
#define UART_FR_RXFF_Pos                  (6UL)                     /*!< UART FR: RXFF (Bit 6)                                 */
#define UART_FR_RXFF_Msk                  (0x40UL)                  /*!< UART FR: RXFF (Bitfield-Mask: 0x01)                   */
#define UART_FR_TXFF_Pos                  (5UL)                     /*!< UART FR: TXFF (Bit 5)                                 */
#define UART_FR_TXFF_Msk                  (0x20UL)                  /*!< UART FR: TXFF (Bitfield-Mask: 0x01)                   */
#define UART_FR_RXFE_Pos                  (4UL)                     /*!< UART FR: RXFE (Bit 4)                                 */
#define UART_FR_RXFE_Msk                  (0x10UL)                  /*!< UART FR: RXFE (Bitfield-Mask: 0x01)                   */
#define UART_FR_BUSY_Pos                  (3UL)                     /*!< UART FR: BUSY (Bit 3)                                 */
#define UART_FR_BUSY_Msk                  (0x8UL)                   /*!< UART FR: BUSY (Bitfield-Mask: 0x01)                   */
#define UART_FR_DCD_Pos                   (2UL)                     /*!< UART FR: DCD (Bit 2)                                  */
#define UART_FR_DCD_Msk                   (0x4UL)                   /*!< UART FR: DCD (Bitfield-Mask: 0x01)                    */
#define UART_FR_DSR_Pos                   (1UL)                     /*!< UART FR: DSR (Bit 1)                                  */
#define UART_FR_DSR_Msk                   (0x2UL)                   /*!< UART FR: DSR (Bitfield-Mask: 0x01)                    */
#define UART_FR_CTS_Pos                   (0UL)                     /*!< UART FR: CTS (Bit 0)                                  */
#define UART_FR_CTS_Msk                   (0x1UL)                   /*!< UART FR: CTS (Bitfield-Mask: 0x01)                    */
/* =========================================================  ILPR  ========================================================== */
#define UART_ILPR_ILPDVSR_Pos             (0UL)                     /*!< UART ILPR: ILPDVSR (Bit 0)                            */
#define UART_ILPR_ILPDVSR_Msk             (0xffUL)                  /*!< UART ILPR: ILPDVSR (Bitfield-Mask: 0xff)              */
/* =========================================================  IBRD  ========================================================== */
#define UART_IBRD_DIVINT_Pos              (0UL)                     /*!< UART IBRD: DIVINT (Bit 0)                             */
#define UART_IBRD_DIVINT_Msk              (0xffffUL)                /*!< UART IBRD: DIVINT (Bitfield-Mask: 0xffff)             */
/* =========================================================  FBRD  ========================================================== */
#define UART_FBRD_DIVFRAC_Pos             (0UL)                     /*!< UART FBRD: DIVFRAC (Bit 0)                            */
#define UART_FBRD_DIVFRAC_Msk             (0x3fUL)                  /*!< UART FBRD: DIVFRAC (Bitfield-Mask: 0x3f)              */
/* =========================================================  LCRH  ========================================================== */
#define UART_LCRH_SPS_Pos                 (7UL)                     /*!< UART LCRH: SPS (Bit 7)                                */
#define UART_LCRH_SPS_Msk                 (0x80UL)                  /*!< UART LCRH: SPS (Bitfield-Mask: 0x01)                  */
#define UART_LCRH_WLEN_Pos                (5UL)                     /*!< UART LCRH: WLEN (Bit 5)                               */
#define UART_LCRH_WLEN_Msk                (0x60UL)                  /*!< UART LCRH: WLEN (Bitfield-Mask: 0x03)                 */
#define UART_LCRH_FEN_Pos                 (4UL)                     /*!< UART LCRH: FEN (Bit 4)                                */
#define UART_LCRH_FEN_Msk                 (0x10UL)                  /*!< UART LCRH: FEN (Bitfield-Mask: 0x01)                  */
#define UART_LCRH_STP2_Pos                (3UL)                     /*!< UART LCRH: STP2 (Bit 3)                               */
#define UART_LCRH_STP2_Msk                (0x8UL)                   /*!< UART LCRH: STP2 (Bitfield-Mask: 0x01)                 */
#define UART_LCRH_EPS_Pos                 (2UL)                     /*!< UART LCRH: EPS (Bit 2)                                */
#define UART_LCRH_EPS_Msk                 (0x4UL)                   /*!< UART LCRH: EPS (Bitfield-Mask: 0x01)                  */
#define UART_LCRH_PEN_Pos                 (1UL)                     /*!< UART LCRH: PEN (Bit 1)                                */
#define UART_LCRH_PEN_Msk                 (0x2UL)                   /*!< UART LCRH: PEN (Bitfield-Mask: 0x01)                  */
#define UART_LCRH_BRK_Pos                 (0UL)                     /*!< UART LCRH: BRK (Bit 0)                                */
#define UART_LCRH_BRK_Msk                 (0x1UL)                   /*!< UART LCRH: BRK (Bitfield-Mask: 0x01)                  */
/* ==========================================================  CR  =========================================================== */
#define UART_CR_CTSEN_Pos                 (15UL)                    /*!< UART CR: CTSEN (Bit 15)                               */
#define UART_CR_CTSEN_Msk                 (0x8000UL)                /*!< UART CR: CTSEN (Bitfield-Mask: 0x01)                  */
#define UART_CR_RTSEN_Pos                 (14UL)                    /*!< UART CR: RTSEN (Bit 14)                               */
#define UART_CR_RTSEN_Msk                 (0x4000UL)                /*!< UART CR: RTSEN (Bitfield-Mask: 0x01)                  */
#define UART_CR_OUT2_Pos                  (13UL)                    /*!< UART CR: OUT2 (Bit 13)                                */
#define UART_CR_OUT2_Msk                  (0x2000UL)                /*!< UART CR: OUT2 (Bitfield-Mask: 0x01)                   */
#define UART_CR_OUT1_Pos                  (12UL)                    /*!< UART CR: OUT1 (Bit 12)                                */
#define UART_CR_OUT1_Msk                  (0x1000UL)                /*!< UART CR: OUT1 (Bitfield-Mask: 0x01)                   */
#define UART_CR_RTS_Pos                   (11UL)                    /*!< UART CR: RTS (Bit 11)                                 */
#define UART_CR_RTS_Msk                   (0x800UL)                 /*!< UART CR: RTS (Bitfield-Mask: 0x01)                    */
#define UART_CR_DTR_Pos                   (10UL)                    /*!< UART CR: DTR (Bit 10)                                 */
#define UART_CR_DTR_Msk                   (0x400UL)                 /*!< UART CR: DTR (Bitfield-Mask: 0x01)                    */
#define UART_CR_RXE_Pos                   (9UL)                     /*!< UART CR: RXE (Bit 9)                                  */
#define UART_CR_RXE_Msk                   (0x200UL)                 /*!< UART CR: RXE (Bitfield-Mask: 0x01)                    */
#define UART_CR_TXE_Pos                   (8UL)                     /*!< UART CR: TXE (Bit 8)                                  */
#define UART_CR_TXE_Msk                   (0x100UL)                 /*!< UART CR: TXE (Bitfield-Mask: 0x01)                    */
#define UART_CR_LBE_Pos                   (7UL)                     /*!< UART CR: LBE (Bit 7)                                  */
#define UART_CR_LBE_Msk                   (0x80UL)                  /*!< UART CR: LBE (Bitfield-Mask: 0x01)                    */
#define UART_CR_CLKSEL_Pos                (4UL)                     /*!< UART CR: CLKSEL (Bit 4)                               */
#define UART_CR_CLKSEL_Msk                (0x70UL)                  /*!< UART CR: CLKSEL (Bitfield-Mask: 0x07)                 */
#define UART_CR_CLKEN_Pos                 (3UL)                     /*!< UART CR: CLKEN (Bit 3)                                */
#define UART_CR_CLKEN_Msk                 (0x8UL)                   /*!< UART CR: CLKEN (Bitfield-Mask: 0x01)                  */
#define UART_CR_SIRLP_Pos                 (2UL)                     /*!< UART CR: SIRLP (Bit 2)                                */
#define UART_CR_SIRLP_Msk                 (0x4UL)                   /*!< UART CR: SIRLP (Bitfield-Mask: 0x01)                  */
#define UART_CR_SIREN_Pos                 (1UL)                     /*!< UART CR: SIREN (Bit 1)                                */
#define UART_CR_SIREN_Msk                 (0x2UL)                   /*!< UART CR: SIREN (Bitfield-Mask: 0x01)                  */
#define UART_CR_UARTEN_Pos                (0UL)                     /*!< UART CR: UARTEN (Bit 0)                               */
#define UART_CR_UARTEN_Msk                (0x1UL)                   /*!< UART CR: UARTEN (Bitfield-Mask: 0x01)                 */
/* =========================================================  IFLS  ========================================================== */
#define UART_IFLS_RXIFLSEL_Pos            (3UL)                     /*!< UART IFLS: RXIFLSEL (Bit 3)                           */
#define UART_IFLS_RXIFLSEL_Msk            (0x38UL)                  /*!< UART IFLS: RXIFLSEL (Bitfield-Mask: 0x07)             */
#define UART_IFLS_TXIFLSEL_Pos            (0UL)                     /*!< UART IFLS: TXIFLSEL (Bit 0)                           */
#define UART_IFLS_TXIFLSEL_Msk            (0x7UL)                   /*!< UART IFLS: TXIFLSEL (Bitfield-Mask: 0x07)             */
/* ==========================================================  IER  ========================================================== */
#define UART_IER_OEIM_Pos                 (10UL)                    /*!< UART IER: OEIM (Bit 10)                               */
#define UART_IER_OEIM_Msk                 (0x400UL)                 /*!< UART IER: OEIM (Bitfield-Mask: 0x01)                  */
#define UART_IER_BEIM_Pos                 (9UL)                     /*!< UART IER: BEIM (Bit 9)                                */
#define UART_IER_BEIM_Msk                 (0x200UL)                 /*!< UART IER: BEIM (Bitfield-Mask: 0x01)                  */
#define UART_IER_PEIM_Pos                 (8UL)                     /*!< UART IER: PEIM (Bit 8)                                */
#define UART_IER_PEIM_Msk                 (0x100UL)                 /*!< UART IER: PEIM (Bitfield-Mask: 0x01)                  */
#define UART_IER_FEIM_Pos                 (7UL)                     /*!< UART IER: FEIM (Bit 7)                                */
#define UART_IER_FEIM_Msk                 (0x80UL)                  /*!< UART IER: FEIM (Bitfield-Mask: 0x01)                  */
#define UART_IER_RTIM_Pos                 (6UL)                     /*!< UART IER: RTIM (Bit 6)                                */
#define UART_IER_RTIM_Msk                 (0x40UL)                  /*!< UART IER: RTIM (Bitfield-Mask: 0x01)                  */
#define UART_IER_TXIM_Pos                 (5UL)                     /*!< UART IER: TXIM (Bit 5)                                */
#define UART_IER_TXIM_Msk                 (0x20UL)                  /*!< UART IER: TXIM (Bitfield-Mask: 0x01)                  */
#define UART_IER_RXIM_Pos                 (4UL)                     /*!< UART IER: RXIM (Bit 4)                                */
#define UART_IER_RXIM_Msk                 (0x10UL)                  /*!< UART IER: RXIM (Bitfield-Mask: 0x01)                  */
#define UART_IER_DSRMIM_Pos               (3UL)                     /*!< UART IER: DSRMIM (Bit 3)                              */
#define UART_IER_DSRMIM_Msk               (0x8UL)                   /*!< UART IER: DSRMIM (Bitfield-Mask: 0x01)                */
#define UART_IER_DCDMIM_Pos               (2UL)                     /*!< UART IER: DCDMIM (Bit 2)                              */
#define UART_IER_DCDMIM_Msk               (0x4UL)                   /*!< UART IER: DCDMIM (Bitfield-Mask: 0x01)                */
#define UART_IER_CTSMIM_Pos               (1UL)                     /*!< UART IER: CTSMIM (Bit 1)                              */
#define UART_IER_CTSMIM_Msk               (0x2UL)                   /*!< UART IER: CTSMIM (Bitfield-Mask: 0x01)                */
#define UART_IER_RIMIM_Pos                (0UL)                     /*!< UART IER: RIMIM (Bit 0)                               */
#define UART_IER_RIMIM_Msk                (0x1UL)                   /*!< UART IER: RIMIM (Bitfield-Mask: 0x01)                 */
/* ==========================================================  IES  ========================================================== */
#define UART_IES_OERIS_Pos                (10UL)                    /*!< UART IES: OERIS (Bit 10)                              */
#define UART_IES_OERIS_Msk                (0x400UL)                 /*!< UART IES: OERIS (Bitfield-Mask: 0x01)                 */
#define UART_IES_BERIS_Pos                (9UL)                     /*!< UART IES: BERIS (Bit 9)                               */
#define UART_IES_BERIS_Msk                (0x200UL)                 /*!< UART IES: BERIS (Bitfield-Mask: 0x01)                 */
#define UART_IES_PERIS_Pos                (8UL)                     /*!< UART IES: PERIS (Bit 8)                               */
#define UART_IES_PERIS_Msk                (0x100UL)                 /*!< UART IES: PERIS (Bitfield-Mask: 0x01)                 */
#define UART_IES_FERIS_Pos                (7UL)                     /*!< UART IES: FERIS (Bit 7)                               */
#define UART_IES_FERIS_Msk                (0x80UL)                  /*!< UART IES: FERIS (Bitfield-Mask: 0x01)                 */
#define UART_IES_RTRIS_Pos                (6UL)                     /*!< UART IES: RTRIS (Bit 6)                               */
#define UART_IES_RTRIS_Msk                (0x40UL)                  /*!< UART IES: RTRIS (Bitfield-Mask: 0x01)                 */
#define UART_IES_TXRIS_Pos                (5UL)                     /*!< UART IES: TXRIS (Bit 5)                               */
#define UART_IES_TXRIS_Msk                (0x20UL)                  /*!< UART IES: TXRIS (Bitfield-Mask: 0x01)                 */
#define UART_IES_RXRIS_Pos                (4UL)                     /*!< UART IES: RXRIS (Bit 4)                               */
#define UART_IES_RXRIS_Msk                (0x10UL)                  /*!< UART IES: RXRIS (Bitfield-Mask: 0x01)                 */
#define UART_IES_DSRMRIS_Pos              (3UL)                     /*!< UART IES: DSRMRIS (Bit 3)                             */
#define UART_IES_DSRMRIS_Msk              (0x8UL)                   /*!< UART IES: DSRMRIS (Bitfield-Mask: 0x01)               */
#define UART_IES_DCDMRIS_Pos              (2UL)                     /*!< UART IES: DCDMRIS (Bit 2)                             */
#define UART_IES_DCDMRIS_Msk              (0x4UL)                   /*!< UART IES: DCDMRIS (Bitfield-Mask: 0x01)               */
#define UART_IES_CTSMRIS_Pos              (1UL)                     /*!< UART IES: CTSMRIS (Bit 1)                             */
#define UART_IES_CTSMRIS_Msk              (0x2UL)                   /*!< UART IES: CTSMRIS (Bitfield-Mask: 0x01)               */
#define UART_IES_RIMRIS_Pos               (0UL)                     /*!< UART IES: RIMRIS (Bit 0)                              */
#define UART_IES_RIMRIS_Msk               (0x1UL)                   /*!< UART IES: RIMRIS (Bitfield-Mask: 0x01)                */
/* ==========================================================  MIS  ========================================================== */
#define UART_MIS_OEMIS_Pos                (10UL)                    /*!< UART MIS: OEMIS (Bit 10)                              */
#define UART_MIS_OEMIS_Msk                (0x400UL)                 /*!< UART MIS: OEMIS (Bitfield-Mask: 0x01)                 */
#define UART_MIS_BEMIS_Pos                (9UL)                     /*!< UART MIS: BEMIS (Bit 9)                               */
#define UART_MIS_BEMIS_Msk                (0x200UL)                 /*!< UART MIS: BEMIS (Bitfield-Mask: 0x01)                 */
#define UART_MIS_PEMIS_Pos                (8UL)                     /*!< UART MIS: PEMIS (Bit 8)                               */
#define UART_MIS_PEMIS_Msk                (0x100UL)                 /*!< UART MIS: PEMIS (Bitfield-Mask: 0x01)                 */
#define UART_MIS_FEMIS_Pos                (7UL)                     /*!< UART MIS: FEMIS (Bit 7)                               */
#define UART_MIS_FEMIS_Msk                (0x80UL)                  /*!< UART MIS: FEMIS (Bitfield-Mask: 0x01)                 */
#define UART_MIS_RTMIS_Pos                (6UL)                     /*!< UART MIS: RTMIS (Bit 6)                               */
#define UART_MIS_RTMIS_Msk                (0x40UL)                  /*!< UART MIS: RTMIS (Bitfield-Mask: 0x01)                 */
#define UART_MIS_TXMIS_Pos                (5UL)                     /*!< UART MIS: TXMIS (Bit 5)                               */
#define UART_MIS_TXMIS_Msk                (0x20UL)                  /*!< UART MIS: TXMIS (Bitfield-Mask: 0x01)                 */
#define UART_MIS_RXMIS_Pos                (4UL)                     /*!< UART MIS: RXMIS (Bit 4)                               */
#define UART_MIS_RXMIS_Msk                (0x10UL)                  /*!< UART MIS: RXMIS (Bitfield-Mask: 0x01)                 */
#define UART_MIS_DSRMMIS_Pos              (3UL)                     /*!< UART MIS: DSRMMIS (Bit 3)                             */
#define UART_MIS_DSRMMIS_Msk              (0x8UL)                   /*!< UART MIS: DSRMMIS (Bitfield-Mask: 0x01)               */
#define UART_MIS_DCDMMIS_Pos              (2UL)                     /*!< UART MIS: DCDMMIS (Bit 2)                             */
#define UART_MIS_DCDMMIS_Msk              (0x4UL)                   /*!< UART MIS: DCDMMIS (Bitfield-Mask: 0x01)               */
#define UART_MIS_CTSMMIS_Pos              (1UL)                     /*!< UART MIS: CTSMMIS (Bit 1)                             */
#define UART_MIS_CTSMMIS_Msk              (0x2UL)                   /*!< UART MIS: CTSMMIS (Bitfield-Mask: 0x01)               */
#define UART_MIS_RIMMIS_Pos               (0UL)                     /*!< UART MIS: RIMMIS (Bit 0)                              */
#define UART_MIS_RIMMIS_Msk               (0x1UL)                   /*!< UART MIS: RIMMIS (Bitfield-Mask: 0x01)                */
/* ==========================================================  IEC  ========================================================== */
#define UART_IEC_OEIC_Pos                 (10UL)                    /*!< UART IEC: OEIC (Bit 10)                               */
#define UART_IEC_OEIC_Msk                 (0x400UL)                 /*!< UART IEC: OEIC (Bitfield-Mask: 0x01)                  */
#define UART_IEC_BEIC_Pos                 (9UL)                     /*!< UART IEC: BEIC (Bit 9)                                */
#define UART_IEC_BEIC_Msk                 (0x200UL)                 /*!< UART IEC: BEIC (Bitfield-Mask: 0x01)                  */
#define UART_IEC_PEIC_Pos                 (8UL)                     /*!< UART IEC: PEIC (Bit 8)                                */
#define UART_IEC_PEIC_Msk                 (0x100UL)                 /*!< UART IEC: PEIC (Bitfield-Mask: 0x01)                  */
#define UART_IEC_FEIC_Pos                 (7UL)                     /*!< UART IEC: FEIC (Bit 7)                                */
#define UART_IEC_FEIC_Msk                 (0x80UL)                  /*!< UART IEC: FEIC (Bitfield-Mask: 0x01)                  */
#define UART_IEC_RTIC_Pos                 (6UL)                     /*!< UART IEC: RTIC (Bit 6)                                */
#define UART_IEC_RTIC_Msk                 (0x40UL)                  /*!< UART IEC: RTIC (Bitfield-Mask: 0x01)                  */
#define UART_IEC_TXIC_Pos                 (5UL)                     /*!< UART IEC: TXIC (Bit 5)                                */
#define UART_IEC_TXIC_Msk                 (0x20UL)                  /*!< UART IEC: TXIC (Bitfield-Mask: 0x01)                  */
#define UART_IEC_RXIC_Pos                 (4UL)                     /*!< UART IEC: RXIC (Bit 4)                                */
#define UART_IEC_RXIC_Msk                 (0x10UL)                  /*!< UART IEC: RXIC (Bitfield-Mask: 0x01)                  */
#define UART_IEC_DSRMIC_Pos               (3UL)                     /*!< UART IEC: DSRMIC (Bit 3)                              */
#define UART_IEC_DSRMIC_Msk               (0x8UL)                   /*!< UART IEC: DSRMIC (Bitfield-Mask: 0x01)                */
#define UART_IEC_DCDMIC_Pos               (2UL)                     /*!< UART IEC: DCDMIC (Bit 2)                              */
#define UART_IEC_DCDMIC_Msk               (0x4UL)                   /*!< UART IEC: DCDMIC (Bitfield-Mask: 0x01)                */
#define UART_IEC_CTSMIC_Pos               (1UL)                     /*!< UART IEC: CTSMIC (Bit 1)                              */
#define UART_IEC_CTSMIC_Msk               (0x2UL)                   /*!< UART IEC: CTSMIC (Bitfield-Mask: 0x01)                */
#define UART_IEC_RIMIC_Pos                (0UL)                     /*!< UART IEC: RIMIC (Bit 0)                               */
#define UART_IEC_RIMIC_Msk                (0x1UL)                   /*!< UART IEC: RIMIC (Bitfield-Mask: 0x01)                 */


/* =========================================================================================================================== */
/* ================                                           VCOMP                                           ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define VCOMP_CFG_LVLSEL_Pos              (16UL)                    /*!< VCOMP CFG: LVLSEL (Bit 16)                            */
#define VCOMP_CFG_LVLSEL_Msk              (0xf0000UL)               /*!< VCOMP CFG: LVLSEL (Bitfield-Mask: 0x0f)               */
#define VCOMP_CFG_NSEL_Pos                (8UL)                     /*!< VCOMP CFG: NSEL (Bit 8)                               */
#define VCOMP_CFG_NSEL_Msk                (0x300UL)                 /*!< VCOMP CFG: NSEL (Bitfield-Mask: 0x03)                 */
#define VCOMP_CFG_PSEL_Pos                (0UL)                     /*!< VCOMP CFG: PSEL (Bit 0)                               */
#define VCOMP_CFG_PSEL_Msk                (0x3UL)                   /*!< VCOMP CFG: PSEL (Bitfield-Mask: 0x03)                 */
/* =========================================================  STAT  ========================================================== */
#define VCOMP_STAT_PWDSTAT_Pos            (1UL)                     /*!< VCOMP STAT: PWDSTAT (Bit 1)                           */
#define VCOMP_STAT_PWDSTAT_Msk            (0x2UL)                   /*!< VCOMP STAT: PWDSTAT (Bitfield-Mask: 0x01)             */
#define VCOMP_STAT_CMPOUT_Pos             (0UL)                     /*!< VCOMP STAT: CMPOUT (Bit 0)                            */
#define VCOMP_STAT_CMPOUT_Msk             (0x1UL)                   /*!< VCOMP STAT: CMPOUT (Bitfield-Mask: 0x01)              */
/* ========================================================  PWDKEY  ========================================================= */
#define VCOMP_PWDKEY_PWDKEY_Pos           (0UL)                     /*!< VCOMP PWDKEY: PWDKEY (Bit 0)                          */
#define VCOMP_PWDKEY_PWDKEY_Msk           (0xffffffffUL)            /*!< VCOMP PWDKEY: PWDKEY (Bitfield-Mask: 0xffffffff)      */
/* =========================================================  INTEN  ========================================================= */
#define VCOMP_INTEN_OUTHI_Pos             (1UL)                     /*!< VCOMP INTEN: OUTHI (Bit 1)                            */
#define VCOMP_INTEN_OUTHI_Msk             (0x2UL)                   /*!< VCOMP INTEN: OUTHI (Bitfield-Mask: 0x01)              */
#define VCOMP_INTEN_OUTLOW_Pos            (0UL)                     /*!< VCOMP INTEN: OUTLOW (Bit 0)                           */
#define VCOMP_INTEN_OUTLOW_Msk            (0x1UL)                   /*!< VCOMP INTEN: OUTLOW (Bitfield-Mask: 0x01)             */
/* ========================================================  INTSTAT  ======================================================== */
#define VCOMP_INTSTAT_OUTHI_Pos           (1UL)                     /*!< VCOMP INTSTAT: OUTHI (Bit 1)                          */
#define VCOMP_INTSTAT_OUTHI_Msk           (0x2UL)                   /*!< VCOMP INTSTAT: OUTHI (Bitfield-Mask: 0x01)            */
#define VCOMP_INTSTAT_OUTLOW_Pos          (0UL)                     /*!< VCOMP INTSTAT: OUTLOW (Bit 0)                         */
#define VCOMP_INTSTAT_OUTLOW_Msk          (0x1UL)                   /*!< VCOMP INTSTAT: OUTLOW (Bitfield-Mask: 0x01)           */
/* ========================================================  INTCLR  ========================================================= */
#define VCOMP_INTCLR_OUTHI_Pos            (1UL)                     /*!< VCOMP INTCLR: OUTHI (Bit 1)                           */
#define VCOMP_INTCLR_OUTHI_Msk            (0x2UL)                   /*!< VCOMP INTCLR: OUTHI (Bitfield-Mask: 0x01)             */
#define VCOMP_INTCLR_OUTLOW_Pos           (0UL)                     /*!< VCOMP INTCLR: OUTLOW (Bit 0)                          */
#define VCOMP_INTCLR_OUTLOW_Msk           (0x1UL)                   /*!< VCOMP INTCLR: OUTLOW (Bitfield-Mask: 0x01)            */
/* ========================================================  INTSET  ========================================================= */
#define VCOMP_INTSET_OUTHI_Pos            (1UL)                     /*!< VCOMP INTSET: OUTHI (Bit 1)                           */
#define VCOMP_INTSET_OUTHI_Msk            (0x2UL)                   /*!< VCOMP INTSET: OUTHI (Bitfield-Mask: 0x01)             */
#define VCOMP_INTSET_OUTLOW_Pos           (0UL)                     /*!< VCOMP INTSET: OUTLOW (Bit 0)                          */
#define VCOMP_INTSET_OUTLOW_Msk           (0x1UL)                   /*!< VCOMP INTSET: OUTLOW (Bitfield-Mask: 0x01)            */


/* =========================================================================================================================== */
/* ================                                            WDT                                            ================ */
/* =========================================================================================================================== */

/* ==========================================================  CFG  ========================================================== */
#define WDT_CFG_INTVAL_Pos                (16UL)                    /*!< WDT CFG: INTVAL (Bit 16)                              */
#define WDT_CFG_INTVAL_Msk                (0xff0000UL)              /*!< WDT CFG: INTVAL (Bitfield-Mask: 0xff)                 */
#define WDT_CFG_RESVAL_Pos                (8UL)                     /*!< WDT CFG: RESVAL (Bit 8)                               */
#define WDT_CFG_RESVAL_Msk                (0xff00UL)                /*!< WDT CFG: RESVAL (Bitfield-Mask: 0xff)                 */
#define WDT_CFG_RESEN_Pos                 (2UL)                     /*!< WDT CFG: RESEN (Bit 2)                                */
#define WDT_CFG_RESEN_Msk                 (0x4UL)                   /*!< WDT CFG: RESEN (Bitfield-Mask: 0x01)                  */
#define WDT_CFG_INTEN_Pos                 (1UL)                     /*!< WDT CFG: INTEN (Bit 1)                                */
#define WDT_CFG_INTEN_Msk                 (0x2UL)                   /*!< WDT CFG: INTEN (Bitfield-Mask: 0x01)                  */
#define WDT_CFG_WDTEN_Pos                 (0UL)                     /*!< WDT CFG: WDTEN (Bit 0)                                */
#define WDT_CFG_WDTEN_Msk                 (0x1UL)                   /*!< WDT CFG: WDTEN (Bitfield-Mask: 0x01)                  */
/* =========================================================  RSTRT  ========================================================= */
#define WDT_RSTRT_RSTRT_Pos               (0UL)                     /*!< WDT RSTRT: RSTRT (Bit 0)                              */
#define WDT_RSTRT_RSTRT_Msk               (0xffUL)                  /*!< WDT RSTRT: RSTRT (Bitfield-Mask: 0xff)                */
/* =========================================================  LOCK  ========================================================== */
#define WDT_LOCK_LOCK_Pos                 (0UL)                     /*!< WDT LOCK: LOCK (Bit 0)                                */
#define WDT_LOCK_LOCK_Msk                 (0xffUL)                  /*!< WDT LOCK: LOCK (Bitfield-Mask: 0xff)                  */
/* =========================================================  INTEN  ========================================================= */
#define WDT_INTEN_WDT_Pos                 (0UL)                     /*!< WDT INTEN: WDT (Bit 0)                                */
#define WDT_INTEN_WDT_Msk                 (0x1UL)                   /*!< WDT INTEN: WDT (Bitfield-Mask: 0x01)                  */
/* ========================================================  INTSTAT  ======================================================== */
#define WDT_INTSTAT_WDT_Pos               (0UL)                     /*!< WDT INTSTAT: WDT (Bit 0)                              */
#define WDT_INTSTAT_WDT_Msk               (0x1UL)                   /*!< WDT INTSTAT: WDT (Bitfield-Mask: 0x01)                */
/* ========================================================  INTCLR  ========================================================= */
#define WDT_INTCLR_WDT_Pos                (0UL)                     /*!< WDT INTCLR: WDT (Bit 0)                               */
#define WDT_INTCLR_WDT_Msk                (0x1UL)                   /*!< WDT INTCLR: WDT (Bitfield-Mask: 0x01)                 */
/* ========================================================  INTSET  ========================================================= */
#define WDT_INTSET_WDT_Pos                (0UL)                     /*!< WDT INTSET: WDT (Bit 0)                               */
#define WDT_INTSET_WDT_Msk                (0x1UL)                   /*!< WDT INTSET: WDT (Bitfield-Mask: 0x01)                 */


/* =========================================================================================================================== */
/* ================                                          CLKGEN                                           ================ */
/* =========================================================================================================================== */

/* =========================================================  CALXT  ========================================================= */
#define CLKGEN_CALXT_CALXT_Pos            (0UL)                     /*!< CLKGEN CALXT: CALXT (Bit 0)                           */
#define CLKGEN_CALXT_CALXT_Msk            (0x7ffUL)                 /*!< CLKGEN CALXT: CALXT (Bitfield-Mask: 0x7ff)            */
/* =========================================================  CALRC  ========================================================= */
#define CLKGEN_CALRC_CALRC_Pos            (0UL)                     /*!< CLKGEN CALRC: CALRC (Bit 0)                           */
#define CLKGEN_CALRC_CALRC_Msk            (0x3ffffUL)               /*!< CLKGEN CALRC: CALRC (Bitfield-Mask: 0x3ffff)          */
/* ========================================================  ACALCTR  ======================================================== */
#define CLKGEN_ACALCTR_ACALCTR_Pos        (0UL)                     /*!< CLKGEN ACALCTR: ACALCTR (Bit 0)                       */
#define CLKGEN_ACALCTR_ACALCTR_Msk        (0xffffffUL)              /*!< CLKGEN ACALCTR: ACALCTR (Bitfield-Mask: 0xffffff)     */
/* =========================================================  OCTRL  ========================================================= */
#define CLKGEN_OCTRL_ACAL_Pos             (8UL)                     /*!< CLKGEN OCTRL: ACAL (Bit 8)                            */
#define CLKGEN_OCTRL_ACAL_Msk             (0x700UL)                 /*!< CLKGEN OCTRL: ACAL (Bitfield-Mask: 0x07)              */
#define CLKGEN_OCTRL_OSEL_Pos             (7UL)                     /*!< CLKGEN OCTRL: OSEL (Bit 7)                            */
#define CLKGEN_OCTRL_OSEL_Msk             (0x80UL)                  /*!< CLKGEN OCTRL: OSEL (Bitfield-Mask: 0x01)              */
#define CLKGEN_OCTRL_FOS_Pos              (6UL)                     /*!< CLKGEN OCTRL: FOS (Bit 6)                             */
#define CLKGEN_OCTRL_FOS_Msk              (0x40UL)                  /*!< CLKGEN OCTRL: FOS (Bitfield-Mask: 0x01)               */
#define CLKGEN_OCTRL_STOPRC_Pos           (1UL)                     /*!< CLKGEN OCTRL: STOPRC (Bit 1)                          */
#define CLKGEN_OCTRL_STOPRC_Msk           (0x2UL)                   /*!< CLKGEN OCTRL: STOPRC (Bitfield-Mask: 0x01)            */
#define CLKGEN_OCTRL_STOPXT_Pos           (0UL)                     /*!< CLKGEN OCTRL: STOPXT (Bit 0)                          */
#define CLKGEN_OCTRL_STOPXT_Msk           (0x1UL)                   /*!< CLKGEN OCTRL: STOPXT (Bitfield-Mask: 0x01)            */
/* ========================================================  CLKOUT  ========================================================= */
#define CLKGEN_CLKOUT_CKEN_Pos            (7UL)                     /*!< CLKGEN CLKOUT: CKEN (Bit 7)                           */
#define CLKGEN_CLKOUT_CKEN_Msk            (0x80UL)                  /*!< CLKGEN CLKOUT: CKEN (Bitfield-Mask: 0x01)             */
#define CLKGEN_CLKOUT_CKSEL_Pos           (0UL)                     /*!< CLKGEN CLKOUT: CKSEL (Bit 0)                          */
#define CLKGEN_CLKOUT_CKSEL_Msk           (0x3fUL)                  /*!< CLKGEN CLKOUT: CKSEL (Bitfield-Mask: 0x3f)            */
/* ========================================================  CLKKEY  ========================================================= */
#define CLKGEN_CLKKEY_CLKKEY_Pos          (0UL)                     /*!< CLKGEN CLKKEY: CLKKEY (Bit 0)                         */
#define CLKGEN_CLKKEY_CLKKEY_Msk          (0xffffffffUL)            /*!< CLKGEN CLKKEY: CLKKEY (Bitfield-Mask: 0xffffffff)     */
/* =========================================================  CCTRL  ========================================================= */
#define CLKGEN_CCTRL_MEMSEL_Pos           (3UL)                     /*!< CLKGEN CCTRL: MEMSEL (Bit 3)                          */
#define CLKGEN_CCTRL_MEMSEL_Msk           (0x8UL)                   /*!< CLKGEN CCTRL: MEMSEL (Bitfield-Mask: 0x01)            */
#define CLKGEN_CCTRL_CORESEL_Pos          (0UL)                     /*!< CLKGEN CCTRL: CORESEL (Bit 0)                         */
#define CLKGEN_CCTRL_CORESEL_Msk          (0x7UL)                   /*!< CLKGEN CCTRL: CORESEL (Bitfield-Mask: 0x07)           */
/* ========================================================  STATUS  ========================================================= */
#define CLKGEN_STATUS_OSCF_Pos            (1UL)                     /*!< CLKGEN STATUS: OSCF (Bit 1)                           */
#define CLKGEN_STATUS_OSCF_Msk            (0x2UL)                   /*!< CLKGEN STATUS: OSCF (Bitfield-Mask: 0x01)             */
#define CLKGEN_STATUS_OMODE_Pos           (0UL)                     /*!< CLKGEN STATUS: OMODE (Bit 0)                          */
#define CLKGEN_STATUS_OMODE_Msk           (0x1UL)                   /*!< CLKGEN STATUS: OMODE (Bitfield-Mask: 0x01)            */
/* =========================================================  HFADJ  ========================================================= */
#define CLKGEN_HFADJ_HFWARMUP_Pos         (19UL)                    /*!< CLKGEN HFADJ: HFWARMUP (Bit 19)                       */
#define CLKGEN_HFADJ_HFWARMUP_Msk         (0x80000UL)               /*!< CLKGEN HFADJ: HFWARMUP (Bitfield-Mask: 0x01)          */
#define CLKGEN_HFADJ_HFXTADJ_Pos          (8UL)                     /*!< CLKGEN HFADJ: HFXTADJ (Bit 8)                         */
#define CLKGEN_HFADJ_HFXTADJ_Msk          (0x7ff00UL)               /*!< CLKGEN HFADJ: HFXTADJ (Bitfield-Mask: 0x7ff)          */
#define CLKGEN_HFADJ_HFADJCK_Pos          (1UL)                     /*!< CLKGEN HFADJ: HFADJCK (Bit 1)                         */
#define CLKGEN_HFADJ_HFADJCK_Msk          (0xeUL)                   /*!< CLKGEN HFADJ: HFADJCK (Bitfield-Mask: 0x07)           */
#define CLKGEN_HFADJ_HFADJEN_Pos          (0UL)                     /*!< CLKGEN HFADJ: HFADJEN (Bit 0)                         */
#define CLKGEN_HFADJ_HFADJEN_Msk          (0x1UL)                   /*!< CLKGEN HFADJ: HFADJEN (Bitfield-Mask: 0x01)           */
/* =========================================================  HFVAL  ========================================================= */
#define CLKGEN_HFVAL_HFTUNERB_Pos         (0UL)                     /*!< CLKGEN HFVAL: HFTUNERB (Bit 0)                        */
#define CLKGEN_HFVAL_HFTUNERB_Msk         (0x7ffUL)                 /*!< CLKGEN HFVAL: HFTUNERB (Bitfield-Mask: 0x7ff)         */
/* ========================================================  CLOCKEN  ======================================================== */
#define CLKGEN_CLOCKEN_CLOCKEN_Pos        (0UL)                     /*!< CLKGEN CLOCKEN: CLOCKEN (Bit 0)                       */
#define CLKGEN_CLOCKEN_CLOCKEN_Msk        (0xffffffffUL)            /*!< CLKGEN CLOCKEN: CLOCKEN (Bitfield-Mask: 0xffffffff)   */
/* ========================================================  UARTEN  ========================================================= */
#define CLKGEN_UARTEN_UARTEN_Pos          (0UL)                     /*!< CLKGEN UARTEN: UARTEN (Bit 0)                         */
#define CLKGEN_UARTEN_UARTEN_Msk          (0x1UL)                   /*!< CLKGEN UARTEN: UARTEN (Bitfield-Mask: 0x01)           */
/* ========================================================  CTRLOW  ========================================================= */
#define CLKGEN_CTRLOW_CTRHR_Pos           (24UL)                    /*!< CLKGEN CTRLOW: CTRHR (Bit 24)                         */
#define CLKGEN_CTRLOW_CTRHR_Msk           (0x3f000000UL)            /*!< CLKGEN CTRLOW: CTRHR (Bitfield-Mask: 0x3f)            */
#define CLKGEN_CTRLOW_CTRMIN_Pos          (16UL)                    /*!< CLKGEN CTRLOW: CTRMIN (Bit 16)                        */
#define CLKGEN_CTRLOW_CTRMIN_Msk          (0x7f0000UL)              /*!< CLKGEN CTRLOW: CTRMIN (Bitfield-Mask: 0x7f)           */
#define CLKGEN_CTRLOW_CTRSEC_Pos          (8UL)                     /*!< CLKGEN CTRLOW: CTRSEC (Bit 8)                         */
#define CLKGEN_CTRLOW_CTRSEC_Msk          (0x7f00UL)                /*!< CLKGEN CTRLOW: CTRSEC (Bitfield-Mask: 0x7f)           */
#define CLKGEN_CTRLOW_CTR100_Pos          (0UL)                     /*!< CLKGEN CTRLOW: CTR100 (Bit 0)                         */
#define CLKGEN_CTRLOW_CTR100_Msk          (0xffUL)                  /*!< CLKGEN CTRLOW: CTR100 (Bitfield-Mask: 0xff)           */
/* =========================================================  CTRUP  ========================================================= */
#define CLKGEN_CTRUP_CTERR_Pos            (31UL)                    /*!< CLKGEN CTRUP: CTERR (Bit 31)                          */
#define CLKGEN_CTRUP_CTERR_Msk            (0x80000000UL)            /*!< CLKGEN CTRUP: CTERR (Bitfield-Mask: 0x01)             */
#define CLKGEN_CTRUP_CEB_Pos              (28UL)                    /*!< CLKGEN CTRUP: CEB (Bit 28)                            */
#define CLKGEN_CTRUP_CEB_Msk              (0x10000000UL)            /*!< CLKGEN CTRUP: CEB (Bitfield-Mask: 0x01)               */
#define CLKGEN_CTRUP_CB_Pos               (27UL)                    /*!< CLKGEN CTRUP: CB (Bit 27)                             */
#define CLKGEN_CTRUP_CB_Msk               (0x8000000UL)             /*!< CLKGEN CTRUP: CB (Bitfield-Mask: 0x01)                */
#define CLKGEN_CTRUP_CTRWKDY_Pos          (24UL)                    /*!< CLKGEN CTRUP: CTRWKDY (Bit 24)                        */
#define CLKGEN_CTRUP_CTRWKDY_Msk          (0x7000000UL)             /*!< CLKGEN CTRUP: CTRWKDY (Bitfield-Mask: 0x07)           */
#define CLKGEN_CTRUP_CTRYR_Pos            (16UL)                    /*!< CLKGEN CTRUP: CTRYR (Bit 16)                          */
#define CLKGEN_CTRUP_CTRYR_Msk            (0xff0000UL)              /*!< CLKGEN CTRUP: CTRYR (Bitfield-Mask: 0xff)             */
#define CLKGEN_CTRUP_CTRMO_Pos            (8UL)                     /*!< CLKGEN CTRUP: CTRMO (Bit 8)                           */
#define CLKGEN_CTRUP_CTRMO_Msk            (0x1f00UL)                /*!< CLKGEN CTRUP: CTRMO (Bitfield-Mask: 0x1f)             */
#define CLKGEN_CTRUP_CTRDATE_Pos          (0UL)                     /*!< CLKGEN CTRUP: CTRDATE (Bit 0)                         */
#define CLKGEN_CTRUP_CTRDATE_Msk          (0x3fUL)                  /*!< CLKGEN CTRUP: CTRDATE (Bitfield-Mask: 0x3f)           */
/* ========================================================  ALMLOW  ========================================================= */
#define CLKGEN_ALMLOW_ALMHR_Pos           (24UL)                    /*!< CLKGEN ALMLOW: ALMHR (Bit 24)                         */
#define CLKGEN_ALMLOW_ALMHR_Msk           (0x3f000000UL)            /*!< CLKGEN ALMLOW: ALMHR (Bitfield-Mask: 0x3f)            */
#define CLKGEN_ALMLOW_ALMMIN_Pos          (16UL)                    /*!< CLKGEN ALMLOW: ALMMIN (Bit 16)                        */
#define CLKGEN_ALMLOW_ALMMIN_Msk          (0x7f0000UL)              /*!< CLKGEN ALMLOW: ALMMIN (Bitfield-Mask: 0x7f)           */
#define CLKGEN_ALMLOW_ALMSEC_Pos          (8UL)                     /*!< CLKGEN ALMLOW: ALMSEC (Bit 8)                         */
#define CLKGEN_ALMLOW_ALMSEC_Msk          (0x7f00UL)                /*!< CLKGEN ALMLOW: ALMSEC (Bitfield-Mask: 0x7f)           */
#define CLKGEN_ALMLOW_ALM100_Pos          (0UL)                     /*!< CLKGEN ALMLOW: ALM100 (Bit 0)                         */
#define CLKGEN_ALMLOW_ALM100_Msk          (0xffUL)                  /*!< CLKGEN ALMLOW: ALM100 (Bitfield-Mask: 0xff)           */
/* =========================================================  ALMUP  ========================================================= */
#define CLKGEN_ALMUP_ALMWKDY_Pos          (16UL)                    /*!< CLKGEN ALMUP: ALMWKDY (Bit 16)                        */
#define CLKGEN_ALMUP_ALMWKDY_Msk          (0x70000UL)               /*!< CLKGEN ALMUP: ALMWKDY (Bitfield-Mask: 0x07)           */
#define CLKGEN_ALMUP_ALMMO_Pos            (8UL)                     /*!< CLKGEN ALMUP: ALMMO (Bit 8)                           */
#define CLKGEN_ALMUP_ALMMO_Msk            (0x1f00UL)                /*!< CLKGEN ALMUP: ALMMO (Bitfield-Mask: 0x1f)             */
#define CLKGEN_ALMUP_ALMDATE_Pos          (0UL)                     /*!< CLKGEN ALMUP: ALMDATE (Bit 0)                         */
#define CLKGEN_ALMUP_ALMDATE_Msk          (0x3fUL)                  /*!< CLKGEN ALMUP: ALMDATE (Bitfield-Mask: 0x3f)           */
/* ========================================================  RTCCTL  ========================================================= */
#define CLKGEN_RTCCTL_HR1224_Pos          (5UL)                     /*!< CLKGEN RTCCTL: HR1224 (Bit 5)                         */
#define CLKGEN_RTCCTL_HR1224_Msk          (0x20UL)                  /*!< CLKGEN RTCCTL: HR1224 (Bitfield-Mask: 0x01)           */
#define CLKGEN_RTCCTL_RSTOP_Pos           (4UL)                     /*!< CLKGEN RTCCTL: RSTOP (Bit 4)                          */
#define CLKGEN_RTCCTL_RSTOP_Msk           (0x10UL)                  /*!< CLKGEN RTCCTL: RSTOP (Bitfield-Mask: 0x01)            */
#define CLKGEN_RTCCTL_RPT_Pos             (1UL)                     /*!< CLKGEN RTCCTL: RPT (Bit 1)                            */
#define CLKGEN_RTCCTL_RPT_Msk             (0xeUL)                   /*!< CLKGEN RTCCTL: RPT (Bitfield-Mask: 0x07)              */
#define CLKGEN_RTCCTL_WRTC_Pos            (0UL)                     /*!< CLKGEN RTCCTL: WRTC (Bit 0)                           */
#define CLKGEN_RTCCTL_WRTC_Msk            (0x1UL)                   /*!< CLKGEN RTCCTL: WRTC (Bitfield-Mask: 0x01)             */
/* =========================================================  INTEN  ========================================================= */
#define CLKGEN_INTEN_ALM_Pos              (3UL)                     /*!< CLKGEN INTEN: ALM (Bit 3)                             */
#define CLKGEN_INTEN_ALM_Msk              (0x8UL)                   /*!< CLKGEN INTEN: ALM (Bitfield-Mask: 0x01)               */
#define CLKGEN_INTEN_OF_Pos               (2UL)                     /*!< CLKGEN INTEN: OF (Bit 2)                              */
#define CLKGEN_INTEN_OF_Msk               (0x4UL)                   /*!< CLKGEN INTEN: OF (Bitfield-Mask: 0x01)                */
#define CLKGEN_INTEN_ACC_Pos              (1UL)                     /*!< CLKGEN INTEN: ACC (Bit 1)                             */
#define CLKGEN_INTEN_ACC_Msk              (0x2UL)                   /*!< CLKGEN INTEN: ACC (Bitfield-Mask: 0x01)               */
#define CLKGEN_INTEN_ACF_Pos              (0UL)                     /*!< CLKGEN INTEN: ACF (Bit 0)                             */
#define CLKGEN_INTEN_ACF_Msk              (0x1UL)                   /*!< CLKGEN INTEN: ACF (Bitfield-Mask: 0x01)               */
/* ========================================================  INTSTAT  ======================================================== */
#define CLKGEN_INTSTAT_ALM_Pos            (3UL)                     /*!< CLKGEN INTSTAT: ALM (Bit 3)                           */
#define CLKGEN_INTSTAT_ALM_Msk            (0x8UL)                   /*!< CLKGEN INTSTAT: ALM (Bitfield-Mask: 0x01)             */
#define CLKGEN_INTSTAT_OF_Pos             (2UL)                     /*!< CLKGEN INTSTAT: OF (Bit 2)                            */
#define CLKGEN_INTSTAT_OF_Msk             (0x4UL)                   /*!< CLKGEN INTSTAT: OF (Bitfield-Mask: 0x01)              */
#define CLKGEN_INTSTAT_ACC_Pos            (1UL)                     /*!< CLKGEN INTSTAT: ACC (Bit 1)                           */
#define CLKGEN_INTSTAT_ACC_Msk            (0x2UL)                   /*!< CLKGEN INTSTAT: ACC (Bitfield-Mask: 0x01)             */
#define CLKGEN_INTSTAT_ACF_Pos            (0UL)                     /*!< CLKGEN INTSTAT: ACF (Bit 0)                           */
#define CLKGEN_INTSTAT_ACF_Msk            (0x1UL)                   /*!< CLKGEN INTSTAT: ACF (Bitfield-Mask: 0x01)             */
/* ========================================================  INTCLR  ========================================================= */
#define CLKGEN_INTCLR_ALM_Pos             (3UL)                     /*!< CLKGEN INTCLR: ALM (Bit 3)                            */
#define CLKGEN_INTCLR_ALM_Msk             (0x8UL)                   /*!< CLKGEN INTCLR: ALM (Bitfield-Mask: 0x01)              */
#define CLKGEN_INTCLR_OF_Pos              (2UL)                     /*!< CLKGEN INTCLR: OF (Bit 2)                             */
#define CLKGEN_INTCLR_OF_Msk              (0x4UL)                   /*!< CLKGEN INTCLR: OF (Bitfield-Mask: 0x01)               */
#define CLKGEN_INTCLR_ACC_Pos             (1UL)                     /*!< CLKGEN INTCLR: ACC (Bit 1)                            */
#define CLKGEN_INTCLR_ACC_Msk             (0x2UL)                   /*!< CLKGEN INTCLR: ACC (Bitfield-Mask: 0x01)              */
#define CLKGEN_INTCLR_ACF_Pos             (0UL)                     /*!< CLKGEN INTCLR: ACF (Bit 0)                            */
#define CLKGEN_INTCLR_ACF_Msk             (0x1UL)                   /*!< CLKGEN INTCLR: ACF (Bitfield-Mask: 0x01)              */
/* ========================================================  INTSET  ========================================================= */
#define CLKGEN_INTSET_ALM_Pos             (3UL)                     /*!< CLKGEN INTSET: ALM (Bit 3)                            */
#define CLKGEN_INTSET_ALM_Msk             (0x8UL)                   /*!< CLKGEN INTSET: ALM (Bitfield-Mask: 0x01)              */
#define CLKGEN_INTSET_OF_Pos              (2UL)                     /*!< CLKGEN INTSET: OF (Bit 2)                             */
#define CLKGEN_INTSET_OF_Msk              (0x4UL)                   /*!< CLKGEN INTSET: OF (Bitfield-Mask: 0x01)               */
#define CLKGEN_INTSET_ACC_Pos             (1UL)                     /*!< CLKGEN INTSET: ACC (Bit 1)                            */
#define CLKGEN_INTSET_ACC_Msk             (0x2UL)                   /*!< CLKGEN INTSET: ACC (Bitfield-Mask: 0x01)              */
#define CLKGEN_INTSET_ACF_Pos             (0UL)                     /*!< CLKGEN INTSET: ACF (Bit 0)                            */
#define CLKGEN_INTSET_ACF_Msk             (0x1UL)                   /*!< CLKGEN INTSET: ACF (Bitfield-Mask: 0x01)              */

/** @} */ /* End of group PosMask_peripherals */


#ifdef __cplusplus
}
#endif

#endif /* APOLLO1_H */


/** @} */ /* End of group apollo1 */

/** @} */ /* End of group Ambiq Micro */
