/*****************************************************************************
 *                   SEGGER Microcontroller GmbH & Co. KG                    *
 *            Solutions for real time microcontroller applications           *
 *****************************************************************************
 *                                                                           *
 *               (c) 2017 SEGGER Microcontroller GmbH & Co. KG               *
 *                                                                           *
 *           Internet: www.segger.com   Support: support@segger.com          *
 *                                                                           *
 *****************************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 0

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak BROWNOUT_IRQHandler
  .thumb_set BROWNOUT_IRQHandler,Dummy_Handler

  .weak WDT_IRQHandler
  .thumb_set WDT_IRQHandler,Dummy_Handler

  .weak CLKGEN_RTC_IRQHandler
  .thumb_set CLKGEN_RTC_IRQHandler,Dummy_Handler

  .weak VCOMP_IRQHandler
  .thumb_set VCOMP_IRQHandler,Dummy_Handler

  .weak IOSLAVE_IRQHandler
  .thumb_set IOSLAVE_IRQHandler,Dummy_Handler

  .weak IOSLAVEACC_IRQHandler
  .thumb_set IOSLAVEACC_IRQHandler,Dummy_Handler

  .weak IOMSTR0_IRQHandler
  .thumb_set IOMSTR0_IRQHandler,Dummy_Handler

  .weak IOMSTR1_IRQHandler
  .thumb_set IOMSTR1_IRQHandler,Dummy_Handler

  .weak IOMSTR2_IRQHandler
  .thumb_set IOMSTR2_IRQHandler,Dummy_Handler

  .weak IOMSTR3_IRQHandler
  .thumb_set IOMSTR3_IRQHandler,Dummy_Handler

  .weak IOMSTR4_IRQHandler
  .thumb_set IOMSTR4_IRQHandler,Dummy_Handler

  .weak IOMSTR5_IRQHandler
  .thumb_set IOMSTR5_IRQHandler,Dummy_Handler

  .weak GPIO_IRQHandler
  .thumb_set GPIO_IRQHandler,Dummy_Handler

  .weak CTIMER_IRQHandler
  .thumb_set CTIMER_IRQHandler,Dummy_Handler

  .weak UART0_IRQHandler
  .thumb_set UART0_IRQHandler,Dummy_Handler

  .weak UART1_IRQHandler
  .thumb_set UART1_IRQHandler,Dummy_Handler

  .weak ADC_IRQHandler
  .thumb_set ADC_IRQHandler,Dummy_Handler

  .weak PDM_IRQHandler
  .thumb_set PDM_IRQHandler,Dummy_Handler

  .weak STIMER_IRQHandler
  .thumb_set STIMER_IRQHandler,Dummy_Handler

  .weak STIMER_CMPR0_IRQHandler
  .thumb_set STIMER_CMPR0_IRQHandler,Dummy_Handler

  .weak STIMER_CMPR1_IRQHandler
  .thumb_set STIMER_CMPR1_IRQHandler,Dummy_Handler

  .weak STIMER_CMPR2_IRQHandler
  .thumb_set STIMER_CMPR2_IRQHandler,Dummy_Handler

  .weak STIMER_CMPR3_IRQHandler
  .thumb_set STIMER_CMPR3_IRQHandler,Dummy_Handler

  .weak STIMER_CMPR4_IRQHandler
  .thumb_set STIMER_CMPR4_IRQHandler,Dummy_Handler

  .weak STIMER_CMPR5_IRQHandler
  .thumb_set STIMER_CMPR5_IRQHandler,Dummy_Handler

  .weak STIMER_CMPR6_IRQHandler
  .thumb_set STIMER_CMPR6_IRQHandler,Dummy_Handler

  .weak STIMER_CMPR7_IRQHandler
  .thumb_set STIMER_CMPR7_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak BROWNOUT_IRQHandler
BROWNOUT_IRQHandler:
  b .

  .thumb_func
  .weak WDT_IRQHandler
WDT_IRQHandler:
  b .

  .thumb_func
  .weak CLKGEN_RTC_IRQHandler
CLKGEN_RTC_IRQHandler:
  b .

  .thumb_func
  .weak VCOMP_IRQHandler
VCOMP_IRQHandler:
  b .

  .thumb_func
  .weak IOSLAVE_IRQHandler
IOSLAVE_IRQHandler:
  b .

  .thumb_func
  .weak IOSLAVEACC_IRQHandler
IOSLAVEACC_IRQHandler:
  b .

  .thumb_func
  .weak IOMSTR0_IRQHandler
IOMSTR0_IRQHandler:
  b .

  .thumb_func
  .weak IOMSTR1_IRQHandler
IOMSTR1_IRQHandler:
  b .

  .thumb_func
  .weak IOMSTR2_IRQHandler
IOMSTR2_IRQHandler:
  b .

  .thumb_func
  .weak IOMSTR3_IRQHandler
IOMSTR3_IRQHandler:
  b .

  .thumb_func
  .weak IOMSTR4_IRQHandler
IOMSTR4_IRQHandler:
  b .

  .thumb_func
  .weak IOMSTR5_IRQHandler
IOMSTR5_IRQHandler:
  b .

  .thumb_func
  .weak GPIO_IRQHandler
GPIO_IRQHandler:
  b .

  .thumb_func
  .weak CTIMER_IRQHandler
CTIMER_IRQHandler:
  b .

  .thumb_func
  .weak UART0_IRQHandler
UART0_IRQHandler:
  b .

  .thumb_func
  .weak UART1_IRQHandler
UART1_IRQHandler:
  b .

  .thumb_func
  .weak ADC_IRQHandler
ADC_IRQHandler:
  b .

  .thumb_func
  .weak PDM_IRQHandler
PDM_IRQHandler:
  b .

  .thumb_func
  .weak STIMER_IRQHandler
STIMER_IRQHandler:
  b .

  .thumb_func
  .weak STIMER_CMPR0_IRQHandler
STIMER_CMPR0_IRQHandler:
  b .

  .thumb_func
  .weak STIMER_CMPR1_IRQHandler
STIMER_CMPR1_IRQHandler:
  b .

  .thumb_func
  .weak STIMER_CMPR2_IRQHandler
STIMER_CMPR2_IRQHandler:
  b .

  .thumb_func
  .weak STIMER_CMPR3_IRQHandler
STIMER_CMPR3_IRQHandler:
  b .

  .thumb_func
  .weak STIMER_CMPR4_IRQHandler
STIMER_CMPR4_IRQHandler:
  b .

  .thumb_func
  .weak STIMER_CMPR5_IRQHandler
STIMER_CMPR5_IRQHandler:
  b .

  .thumb_func
  .weak STIMER_CMPR6_IRQHandler
STIMER_CMPR6_IRQHandler:
  b .

  .thumb_func
  .weak STIMER_CMPR7_IRQHandler
STIMER_CMPR7_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .align 0
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word BROWNOUT_IRQHandler
  .word WDT_IRQHandler
  .word CLKGEN_RTC_IRQHandler
  .word VCOMP_IRQHandler
  .word IOSLAVE_IRQHandler
  .word IOSLAVEACC_IRQHandler
  .word IOMSTR0_IRQHandler
  .word IOMSTR1_IRQHandler
  .word IOMSTR2_IRQHandler
  .word IOMSTR3_IRQHandler
  .word IOMSTR4_IRQHandler
  .word IOMSTR5_IRQHandler
  .word GPIO_IRQHandler
  .word CTIMER_IRQHandler
  .word UART0_IRQHandler
  .word UART1_IRQHandler
  .word ADC_IRQHandler
  .word PDM_IRQHandler
  .word STIMER_IRQHandler
  .word STIMER_CMPR0_IRQHandler
  .word STIMER_CMPR1_IRQHandler
  .word STIMER_CMPR2_IRQHandler
  .word STIMER_CMPR3_IRQHandler
  .word STIMER_CMPR4_IRQHandler
  .word STIMER_CMPR5_IRQHandler
  .word STIMER_CMPR6_IRQHandler
  .word STIMER_CMPR7_IRQHandler
_vectors_end:

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .align 0
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
