/*********************************************************************
*                     SEGGER Microcontroller GmbH                    *
*                        The Embedded Experts                        *
**********************************************************************
*                                                                    *
*       (c) 1995 - 2020 SEGGER Microcontroller GmbH                  *
*                                                                    *
*       Internet: segger.com  Support: support_embos@segger.com      *
*                                                                    *
**********************************************************************
*                                                                    *
*       embOS * Real time operating system for microcontrollers      *
*                                                                    *
*       Please note:                                                 *
*                                                                    *
*       Knowledge of this file may under no circumstances            *
*       be used to write a similar product or a real-time            *
*       operating system for in-house use.                           *
*                                                                    *
*       Thank you for your fairness !                                *
*                                                                    *
**********************************************************************
*                                                                    *
*       OS version: V5.10.1.0                                        *
*                                                                    *
**********************************************************************

-------------------------- END-OF-HEADER -----------------------------
File    : BSP.c
Purpose : BSP for MIMXRT685-EVK
*/

#include "BSP.h"

/*********************************************************************
*
*       Defines
*
**********************************************************************
*/

#define LED0_BIT (26)  // Blue,  D8
#define LED1_BIT (31)  // Red,   D9
#define LED2_BIT (14)  // Green, D10

#define CLKCTL1_PSCCTL1  (*(volatile unsigned int*)(0x40021014u))
#define RSTCTL1_PRSTCTL1 (*(volatile unsigned int*)(0x40020014u))

#define GPIO_BASE_ADDR   (0x40100000u)
#define GPIO_DIRSET0     (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x2380u))  // Port 0 set direction register
#define GPIO_SET0        (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x2200u))  // Port 0 set register
#define GPIO_CLR0        (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x2280u))  // Port 0 clear register
#define GPIO_NOT0        (*(volatile unsigned int*)(GPIO_BASE_ADDR + 0x2300u))  // Port 0 toggle register

/*********************************************************************
*
*       Global functions
*
**********************************************************************
*/

/*********************************************************************
*
*       BSP_Init()
*/
void BSP_Init(void) {
  CLKCTL1_PSCCTL1  |=  (1u << 0);  // Enable unsecure GPIO 0 clock
  RSTCTL1_PRSTCTL1 &= ~(1u << 0);  // Clear  unsecure GPIO 0 reset
  GPIO_DIRSET0     |=  (1u << LED0_BIT)
                   |   (1u << LED1_BIT)
                   |   (1u << LED2_BIT);
}

/*********************************************************************
*
*       BSP_SetLED()
*/
void BSP_SetLED(int Index) {
  switch(Index) {
    case 0:
      GPIO_SET0 |= (1u << LED0_BIT);
      break;
    case 1:
      GPIO_SET0 |= (1u << LED1_BIT);
      break;
    case 2:
      GPIO_SET0 |= (1u << LED2_BIT);
      break;
    default:
      break;
  }
}

/*********************************************************************
*
*       BSP_ClrLED()
*/
void BSP_ClrLED(int Index) {
  switch(Index) {
    case 0:
      GPIO_CLR0 |= (1u << LED0_BIT);
      break;
    case 1:
      GPIO_CLR0 |= (1u << LED1_BIT);
      break;
    case 2:
      GPIO_CLR0 |= (1u << LED2_BIT);
      break;
    default:
      break;
  }
}

/*********************************************************************
*
*       BSP_ToggleLED()
*/
void BSP_ToggleLED(int Index) {
switch(Index) {
    case 0:
      GPIO_NOT0 |= (1u << LED0_BIT);
      break;
    case 1:
      GPIO_NOT0 |= (1u << LED1_BIT);
      break;
    case 2:
      GPIO_NOT0 |= (1u << LED2_BIT);
      break;
    default:
      break;
  }
}

/*************************** End of file ****************************/
