/*********************************************************************
*                    SEGGER Microcontroller GmbH                     *
*                        The Embedded Experts                        *
**********************************************************************
*                                                                    *
*            (c) 2014 - 2020 SEGGER Microcontroller GmbH             *
*                                                                    *
*           www.segger.com     Support: support@segger.com           *
*                                                                    *
**********************************************************************
*                                                                    *
* All rights reserved.                                               *
*                                                                    *
* Redistribution and use in source and binary forms, with or         *
* without modification, are permitted provided that the following    *
* conditions are met:                                                *
*                                                                    *
* - Redistributions of source code must retain the above copyright   *
*   notice, this list of conditions and the following disclaimer.    *
*                                                                    *
* - Neither the name of SEGGER Microcontroller GmbH                  *
*   nor the names of its contributors may be used to endorse or      *
*   promote products derived from this software without specific     *
*   prior written permission.                                        *
*                                                                    *
* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND             *
* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,        *
* INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF           *
* MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE           *
* DISCLAIMED.                                                        *
* IN NO EVENT SHALL SEGGER Microcontroller GmbH BE LIABLE FOR        *
* ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR           *
* CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT  *
* OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;    *
* OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF      *
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT          *
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE  *
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH   *
* DAMAGE.                                                            *
*                                                                    *
*********************************************************************/

/*****************************************************************************
 *                         Preprocessor Definitions                          *
 *                         ------------------------                          *
 * VECTORS_IN_RAM                                                            *
 *                                                                           *
 *   If defined, an area of RAM will large enough to store the vector table  *
 *   will be reserved.                                                       *
 *                                                                           *
 *****************************************************************************/

  .syntax unified
  .code 16

  .section .init, "ax"
  .align 2

/*****************************************************************************
 * Default Exception Handlers                                                *
 *****************************************************************************/

  .thumb_func
  .weak NMI_Handler
NMI_Handler:
  b .

  .thumb_func
  .weak HardFault_Handler
HardFault_Handler:
  b .

  .thumb_func
  .weak SVC_Handler
SVC_Handler:
  b .

  .thumb_func
  .weak PendSV_Handler
PendSV_Handler:
  b .

  .thumb_func
  .weak SysTick_Handler
SysTick_Handler:
  b .

  .thumb_func
Dummy_Handler:
  b .

#if defined(__OPTIMIZATION_SMALL)

  .weak WWDG_IRQHandler
  .thumb_set WWDG_IRQHandler,Dummy_Handler

  .weak PVD_PVM_IRQHandler
  .thumb_set PVD_PVM_IRQHandler,Dummy_Handler

  .weak RTC_TAMP_CSS_LSE_IRQHandler
  .thumb_set RTC_TAMP_CSS_LSE_IRQHandler,Dummy_Handler

  .weak RTC_WKUP_IRQHandler
  .thumb_set RTC_WKUP_IRQHandler,Dummy_Handler

  .weak FLASH_IRQHandler
  .thumb_set FLASH_IRQHandler,Dummy_Handler

  .weak RCC_IRQHandler
  .thumb_set RCC_IRQHandler,Dummy_Handler

  .weak EXTI0_IRQHandler
  .thumb_set EXTI0_IRQHandler,Dummy_Handler

  .weak EXTI1_IRQHandler
  .thumb_set EXTI1_IRQHandler,Dummy_Handler

  .weak EXTI2_IRQHandler
  .thumb_set EXTI2_IRQHandler,Dummy_Handler

  .weak EXTI3_IRQHandler
  .thumb_set EXTI3_IRQHandler,Dummy_Handler

  .weak EXTI4_IRQHandler
  .thumb_set EXTI4_IRQHandler,Dummy_Handler

  .weak DMA1_CH1_IRQHandler
  .thumb_set DMA1_CH1_IRQHandler,Dummy_Handler

  .weak DMA1_CH2_IRQHandler
  .thumb_set DMA1_CH2_IRQHandler,Dummy_Handler

  .weak DMA1_CH3_IRQHandler
  .thumb_set DMA1_CH3_IRQHandler,Dummy_Handler

  .weak DMA1_CH4_IRQHandler
  .thumb_set DMA1_CH4_IRQHandler,Dummy_Handler

  .weak DMA1_CH5_IRQHandler
  .thumb_set DMA1_CH5_IRQHandler,Dummy_Handler

  .weak DMA1_CH6_IRQHandler
  .thumb_set DMA1_CH6_IRQHandler,Dummy_Handler

  .weak DMA1_CH7_IRQHandler
  .thumb_set DMA1_CH7_IRQHandler,Dummy_Handler

  .weak ADC1_2_IRQHandler
  .thumb_set ADC1_2_IRQHandler,Dummy_Handler

  .weak USB_HP_IRQHandler
  .thumb_set USB_HP_IRQHandler,Dummy_Handler

  .weak USB_LP_IRQHandler
  .thumb_set USB_LP_IRQHandler,Dummy_Handler

  .weak fdcan1_intr1_it_IRQHandler
  .thumb_set fdcan1_intr1_it_IRQHandler,Dummy_Handler

  .weak fdcan1_intr0_it_IRQHandler
  .thumb_set fdcan1_intr0_it_IRQHandler,Dummy_Handler

  .weak EXTI9_5_IRQHandler
  .thumb_set EXTI9_5_IRQHandler,Dummy_Handler

  .weak TIM1_BRK_TIM15_IRQHandler
  .thumb_set TIM1_BRK_TIM15_IRQHandler,Dummy_Handler

  .weak TIM1_UP_TIM16_IRQHandler
  .thumb_set TIM1_UP_TIM16_IRQHandler,Dummy_Handler

  .weak TIM1_TRG_COM_IRQHandler
  .thumb_set TIM1_TRG_COM_IRQHandler,Dummy_Handler

  .weak TIM1_CC_IRQHandler
  .thumb_set TIM1_CC_IRQHandler,Dummy_Handler

  .weak TIM2_IRQHandler
  .thumb_set TIM2_IRQHandler,Dummy_Handler

  .weak TIM3_IRQHandler
  .thumb_set TIM3_IRQHandler,Dummy_Handler

  .weak TIM4_IRQHandler
  .thumb_set TIM4_IRQHandler,Dummy_Handler

  .weak I2C1_EV_IRQHandler
  .thumb_set I2C1_EV_IRQHandler,Dummy_Handler

  .weak I2C1_ER_IRQHandler
  .thumb_set I2C1_ER_IRQHandler,Dummy_Handler

  .weak I2C2_EV_IRQHandler
  .thumb_set I2C2_EV_IRQHandler,Dummy_Handler

  .weak I2C2_ER_IRQHandler
  .thumb_set I2C2_ER_IRQHandler,Dummy_Handler

  .weak SPI1_IRQHandler
  .thumb_set SPI1_IRQHandler,Dummy_Handler

  .weak SPI2_IRQHandler
  .thumb_set SPI2_IRQHandler,Dummy_Handler

  .weak USART1_IRQHandler
  .thumb_set USART1_IRQHandler,Dummy_Handler

  .weak USART2_IRQHandler
  .thumb_set USART2_IRQHandler,Dummy_Handler

  .weak USART3_IRQHandler
  .thumb_set USART3_IRQHandler,Dummy_Handler

  .weak EXTI15_10_IRQHandler
  .thumb_set EXTI15_10_IRQHandler,Dummy_Handler

  .weak RTC_ALARM_IRQHandler
  .thumb_set RTC_ALARM_IRQHandler,Dummy_Handler

  .weak USBWakeUP_IRQHandler
  .thumb_set USBWakeUP_IRQHandler,Dummy_Handler

  .weak TIM8_BRK_IRQHandler
  .thumb_set TIM8_BRK_IRQHandler,Dummy_Handler

  .weak TIM8_UP_IRQHandler
  .thumb_set TIM8_UP_IRQHandler,Dummy_Handler

  .weak TIM8_TRG_COM_IRQHandler
  .thumb_set TIM8_TRG_COM_IRQHandler,Dummy_Handler

  .weak TIM8_CC_IRQHandler
  .thumb_set TIM8_CC_IRQHandler,Dummy_Handler

  .weak ADC3_IRQHandler
  .thumb_set ADC3_IRQHandler,Dummy_Handler

  .weak FMC_IRQHandler
  .thumb_set FMC_IRQHandler,Dummy_Handler

  .weak LPTIM1_IRQHandler
  .thumb_set LPTIM1_IRQHandler,Dummy_Handler

  .weak TIM5_IRQHandler
  .thumb_set TIM5_IRQHandler,Dummy_Handler

  .weak SPI3_IRQHandler
  .thumb_set SPI3_IRQHandler,Dummy_Handler

  .weak UART4_IRQHandler
  .thumb_set UART4_IRQHandler,Dummy_Handler

  .weak UART5_IRQHandler
  .thumb_set UART5_IRQHandler,Dummy_Handler

  .weak TIM6_DACUNDER_IRQHandler
  .thumb_set TIM6_DACUNDER_IRQHandler,Dummy_Handler

  .weak TIM7_IRQHandler
  .thumb_set TIM7_IRQHandler,Dummy_Handler

  .weak DMA2_CH1_IRQHandler
  .thumb_set DMA2_CH1_IRQHandler,Dummy_Handler

  .weak DMA2_CH2_IRQHandler
  .thumb_set DMA2_CH2_IRQHandler,Dummy_Handler

  .weak DMA2_CH3_IRQHandler
  .thumb_set DMA2_CH3_IRQHandler,Dummy_Handler

  .weak DMA2_CH4_IRQHandler
  .thumb_set DMA2_CH4_IRQHandler,Dummy_Handler

  .weak DMA2_CH5_IRQHandler
  .thumb_set DMA2_CH5_IRQHandler,Dummy_Handler

  .weak ADC4_IRQHandler
  .thumb_set ADC4_IRQHandler,Dummy_Handler

  .weak ADC5_IRQHandler
  .thumb_set ADC5_IRQHandler,Dummy_Handler

  .weak UCPD1_IRQHandler
  .thumb_set UCPD1_IRQHandler,Dummy_Handler

  .weak COMP1_2_3_IRQHandler
  .thumb_set COMP1_2_3_IRQHandler,Dummy_Handler

  .weak COMP4_5_6_IRQHandler
  .thumb_set COMP4_5_6_IRQHandler,Dummy_Handler

  .weak COMP7_IRQHandler
  .thumb_set COMP7_IRQHandler,Dummy_Handler

  .weak HRTIM_Master_IRQn_IRQHandler
  .thumb_set HRTIM_Master_IRQn_IRQHandler,Dummy_Handler

  .weak HRTIM_TIMA_IRQn_IRQHandler
  .thumb_set HRTIM_TIMA_IRQn_IRQHandler,Dummy_Handler

  .weak HRTIM_TIMB_IRQn_IRQHandler
  .thumb_set HRTIM_TIMB_IRQn_IRQHandler,Dummy_Handler

  .weak HRTIM_TIMC_IRQn_IRQHandler
  .thumb_set HRTIM_TIMC_IRQn_IRQHandler,Dummy_Handler

  .weak HRTIM_TIMD_IRQn_IRQHandler
  .thumb_set HRTIM_TIMD_IRQn_IRQHandler,Dummy_Handler

  .weak HRTIM_TIME_IRQn_IRQHandler
  .thumb_set HRTIM_TIME_IRQn_IRQHandler,Dummy_Handler

  .weak HRTIM_TIM_FLT_IRQn_IRQHandler
  .thumb_set HRTIM_TIM_FLT_IRQn_IRQHandler,Dummy_Handler

  .weak HRTIM_TIMF_IRQn_IRQHandler
  .thumb_set HRTIM_TIMF_IRQn_IRQHandler,Dummy_Handler

  .weak CRS_IRQHandler
  .thumb_set CRS_IRQHandler,Dummy_Handler

  .weak SAI_IRQHandler
  .thumb_set SAI_IRQHandler,Dummy_Handler

  .weak TIM20_BRK_IRQHandler
  .thumb_set TIM20_BRK_IRQHandler,Dummy_Handler

  .weak TIM20_UP_IRQHandler
  .thumb_set TIM20_UP_IRQHandler,Dummy_Handler

  .weak TIM20_TRG_COM_IRQHandler
  .thumb_set TIM20_TRG_COM_IRQHandler,Dummy_Handler

  .weak TIM20_CC_IRQHandler
  .thumb_set TIM20_CC_IRQHandler,Dummy_Handler

  .weak FPU_IRQHandler
  .thumb_set FPU_IRQHandler,Dummy_Handler

  .weak I2C4_EV_IRQHandler
  .thumb_set I2C4_EV_IRQHandler,Dummy_Handler

  .weak I2C4_ER_IRQHandler
  .thumb_set I2C4_ER_IRQHandler,Dummy_Handler

  .weak SPI4_IRQHandler
  .thumb_set SPI4_IRQHandler,Dummy_Handler

  .weak AES_IRQHandler
  .thumb_set AES_IRQHandler,Dummy_Handler

  .weak FDCAN2_intr0_IRQHandler
  .thumb_set FDCAN2_intr0_IRQHandler,Dummy_Handler

  .weak FDCAN2_intr1_IRQHandler
  .thumb_set FDCAN2_intr1_IRQHandler,Dummy_Handler

  .weak FDCAN3_intr0_IRQHandler
  .thumb_set FDCAN3_intr0_IRQHandler,Dummy_Handler

  .weak FDCAN3_intr1_IRQHandler
  .thumb_set FDCAN3_intr1_IRQHandler,Dummy_Handler

  .weak RNG_IRQHandler
  .thumb_set RNG_IRQHandler,Dummy_Handler

  .weak LPUART_IRQHandler
  .thumb_set LPUART_IRQHandler,Dummy_Handler

  .weak I2C3_EV_IRQHandler
  .thumb_set I2C3_EV_IRQHandler,Dummy_Handler

  .weak I2C3_ER_IRQHandler
  .thumb_set I2C3_ER_IRQHandler,Dummy_Handler

  .weak DMAMUX_OVR_IRQHandler
  .thumb_set DMAMUX_OVR_IRQHandler,Dummy_Handler

  .weak QUADSPI_IRQHandler
  .thumb_set QUADSPI_IRQHandler,Dummy_Handler

  .weak DMA1_CH8_IRQHandler
  .thumb_set DMA1_CH8_IRQHandler,Dummy_Handler

  .weak DMA2_CH6_IRQHandler
  .thumb_set DMA2_CH6_IRQHandler,Dummy_Handler

  .weak DMA2_CH7_IRQHandler
  .thumb_set DMA2_CH7_IRQHandler,Dummy_Handler

  .weak DMA2_CH8_IRQHandler
  .thumb_set DMA2_CH8_IRQHandler,Dummy_Handler

  .weak Cordic_IRQHandler
  .thumb_set Cordic_IRQHandler,Dummy_Handler

  .weak FMAC_IRQHandler
  .thumb_set FMAC_IRQHandler,Dummy_Handler

#else

  .thumb_func
  .weak WWDG_IRQHandler
WWDG_IRQHandler:
  b .

  .thumb_func
  .weak PVD_PVM_IRQHandler
PVD_PVM_IRQHandler:
  b .

  .thumb_func
  .weak RTC_TAMP_CSS_LSE_IRQHandler
RTC_TAMP_CSS_LSE_IRQHandler:
  b .

  .thumb_func
  .weak RTC_WKUP_IRQHandler
RTC_WKUP_IRQHandler:
  b .

  .thumb_func
  .weak FLASH_IRQHandler
FLASH_IRQHandler:
  b .

  .thumb_func
  .weak RCC_IRQHandler
RCC_IRQHandler:
  b .

  .thumb_func
  .weak EXTI0_IRQHandler
EXTI0_IRQHandler:
  b .

  .thumb_func
  .weak EXTI1_IRQHandler
EXTI1_IRQHandler:
  b .

  .thumb_func
  .weak EXTI2_IRQHandler
EXTI2_IRQHandler:
  b .

  .thumb_func
  .weak EXTI3_IRQHandler
EXTI3_IRQHandler:
  b .

  .thumb_func
  .weak EXTI4_IRQHandler
EXTI4_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH1_IRQHandler
DMA1_CH1_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH2_IRQHandler
DMA1_CH2_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH3_IRQHandler
DMA1_CH3_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH4_IRQHandler
DMA1_CH4_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH5_IRQHandler
DMA1_CH5_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH6_IRQHandler
DMA1_CH6_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH7_IRQHandler
DMA1_CH7_IRQHandler:
  b .

  .thumb_func
  .weak ADC1_2_IRQHandler
ADC1_2_IRQHandler:
  b .

  .thumb_func
  .weak USB_HP_IRQHandler
USB_HP_IRQHandler:
  b .

  .thumb_func
  .weak USB_LP_IRQHandler
USB_LP_IRQHandler:
  b .

  .thumb_func
  .weak fdcan1_intr1_it_IRQHandler
fdcan1_intr1_it_IRQHandler:
  b .

  .thumb_func
  .weak fdcan1_intr0_it_IRQHandler
fdcan1_intr0_it_IRQHandler:
  b .

  .thumb_func
  .weak EXTI9_5_IRQHandler
EXTI9_5_IRQHandler:
  b .

  .thumb_func
  .weak TIM1_BRK_TIM15_IRQHandler
TIM1_BRK_TIM15_IRQHandler:
  b .

  .thumb_func
  .weak TIM1_UP_TIM16_IRQHandler
TIM1_UP_TIM16_IRQHandler:
  b .

  .thumb_func
  .weak TIM1_TRG_COM_IRQHandler
TIM1_TRG_COM_IRQHandler:
  b .

  .thumb_func
  .weak TIM1_CC_IRQHandler
TIM1_CC_IRQHandler:
  b .

  .thumb_func
  .weak TIM2_IRQHandler
TIM2_IRQHandler:
  b .

  .thumb_func
  .weak TIM3_IRQHandler
TIM3_IRQHandler:
  b .

  .thumb_func
  .weak TIM4_IRQHandler
TIM4_IRQHandler:
  b .

  .thumb_func
  .weak I2C1_EV_IRQHandler
I2C1_EV_IRQHandler:
  b .

  .thumb_func
  .weak I2C1_ER_IRQHandler
I2C1_ER_IRQHandler:
  b .

  .thumb_func
  .weak I2C2_EV_IRQHandler
I2C2_EV_IRQHandler:
  b .

  .thumb_func
  .weak I2C2_ER_IRQHandler
I2C2_ER_IRQHandler:
  b .

  .thumb_func
  .weak SPI1_IRQHandler
SPI1_IRQHandler:
  b .

  .thumb_func
  .weak SPI2_IRQHandler
SPI2_IRQHandler:
  b .

  .thumb_func
  .weak USART1_IRQHandler
USART1_IRQHandler:
  b .

  .thumb_func
  .weak USART2_IRQHandler
USART2_IRQHandler:
  b .

  .thumb_func
  .weak USART3_IRQHandler
USART3_IRQHandler:
  b .

  .thumb_func
  .weak EXTI15_10_IRQHandler
EXTI15_10_IRQHandler:
  b .

  .thumb_func
  .weak RTC_ALARM_IRQHandler
RTC_ALARM_IRQHandler:
  b .

  .thumb_func
  .weak USBWakeUP_IRQHandler
USBWakeUP_IRQHandler:
  b .

  .thumb_func
  .weak TIM8_BRK_IRQHandler
TIM8_BRK_IRQHandler:
  b .

  .thumb_func
  .weak TIM8_UP_IRQHandler
TIM8_UP_IRQHandler:
  b .

  .thumb_func
  .weak TIM8_TRG_COM_IRQHandler
TIM8_TRG_COM_IRQHandler:
  b .

  .thumb_func
  .weak TIM8_CC_IRQHandler
TIM8_CC_IRQHandler:
  b .

  .thumb_func
  .weak ADC3_IRQHandler
ADC3_IRQHandler:
  b .

  .thumb_func
  .weak FMC_IRQHandler
FMC_IRQHandler:
  b .

  .thumb_func
  .weak LPTIM1_IRQHandler
LPTIM1_IRQHandler:
  b .

  .thumb_func
  .weak TIM5_IRQHandler
TIM5_IRQHandler:
  b .

  .thumb_func
  .weak SPI3_IRQHandler
SPI3_IRQHandler:
  b .

  .thumb_func
  .weak UART4_IRQHandler
UART4_IRQHandler:
  b .

  .thumb_func
  .weak UART5_IRQHandler
UART5_IRQHandler:
  b .

  .thumb_func
  .weak TIM6_DACUNDER_IRQHandler
TIM6_DACUNDER_IRQHandler:
  b .

  .thumb_func
  .weak TIM7_IRQHandler
TIM7_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH1_IRQHandler
DMA2_CH1_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH2_IRQHandler
DMA2_CH2_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH3_IRQHandler
DMA2_CH3_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH4_IRQHandler
DMA2_CH4_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH5_IRQHandler
DMA2_CH5_IRQHandler:
  b .

  .thumb_func
  .weak ADC4_IRQHandler
ADC4_IRQHandler:
  b .

  .thumb_func
  .weak ADC5_IRQHandler
ADC5_IRQHandler:
  b .

  .thumb_func
  .weak UCPD1_IRQHandler
UCPD1_IRQHandler:
  b .

  .thumb_func
  .weak COMP1_2_3_IRQHandler
COMP1_2_3_IRQHandler:
  b .

  .thumb_func
  .weak COMP4_5_6_IRQHandler
COMP4_5_6_IRQHandler:
  b .

  .thumb_func
  .weak COMP7_IRQHandler
COMP7_IRQHandler:
  b .

  .thumb_func
  .weak HRTIM_Master_IRQn_IRQHandler
HRTIM_Master_IRQn_IRQHandler:
  b .

  .thumb_func
  .weak HRTIM_TIMA_IRQn_IRQHandler
HRTIM_TIMA_IRQn_IRQHandler:
  b .

  .thumb_func
  .weak HRTIM_TIMB_IRQn_IRQHandler
HRTIM_TIMB_IRQn_IRQHandler:
  b .

  .thumb_func
  .weak HRTIM_TIMC_IRQn_IRQHandler
HRTIM_TIMC_IRQn_IRQHandler:
  b .

  .thumb_func
  .weak HRTIM_TIMD_IRQn_IRQHandler
HRTIM_TIMD_IRQn_IRQHandler:
  b .

  .thumb_func
  .weak HRTIM_TIME_IRQn_IRQHandler
HRTIM_TIME_IRQn_IRQHandler:
  b .

  .thumb_func
  .weak HRTIM_TIM_FLT_IRQn_IRQHandler
HRTIM_TIM_FLT_IRQn_IRQHandler:
  b .

  .thumb_func
  .weak HRTIM_TIMF_IRQn_IRQHandler
HRTIM_TIMF_IRQn_IRQHandler:
  b .

  .thumb_func
  .weak CRS_IRQHandler
CRS_IRQHandler:
  b .

  .thumb_func
  .weak SAI_IRQHandler
SAI_IRQHandler:
  b .

  .thumb_func
  .weak TIM20_BRK_IRQHandler
TIM20_BRK_IRQHandler:
  b .

  .thumb_func
  .weak TIM20_UP_IRQHandler
TIM20_UP_IRQHandler:
  b .

  .thumb_func
  .weak TIM20_TRG_COM_IRQHandler
TIM20_TRG_COM_IRQHandler:
  b .

  .thumb_func
  .weak TIM20_CC_IRQHandler
TIM20_CC_IRQHandler:
  b .

  .thumb_func
  .weak FPU_IRQHandler
FPU_IRQHandler:
  b .

  .thumb_func
  .weak I2C4_EV_IRQHandler
I2C4_EV_IRQHandler:
  b .

  .thumb_func
  .weak I2C4_ER_IRQHandler
I2C4_ER_IRQHandler:
  b .

  .thumb_func
  .weak SPI4_IRQHandler
SPI4_IRQHandler:
  b .

  .thumb_func
  .weak AES_IRQHandler
AES_IRQHandler:
  b .

  .thumb_func
  .weak FDCAN2_intr0_IRQHandler
FDCAN2_intr0_IRQHandler:
  b .

  .thumb_func
  .weak FDCAN2_intr1_IRQHandler
FDCAN2_intr1_IRQHandler:
  b .

  .thumb_func
  .weak FDCAN3_intr0_IRQHandler
FDCAN3_intr0_IRQHandler:
  b .

  .thumb_func
  .weak FDCAN3_intr1_IRQHandler
FDCAN3_intr1_IRQHandler:
  b .

  .thumb_func
  .weak RNG_IRQHandler
RNG_IRQHandler:
  b .

  .thumb_func
  .weak LPUART_IRQHandler
LPUART_IRQHandler:
  b .

  .thumb_func
  .weak I2C3_EV_IRQHandler
I2C3_EV_IRQHandler:
  b .

  .thumb_func
  .weak I2C3_ER_IRQHandler
I2C3_ER_IRQHandler:
  b .

  .thumb_func
  .weak DMAMUX_OVR_IRQHandler
DMAMUX_OVR_IRQHandler:
  b .

  .thumb_func
  .weak QUADSPI_IRQHandler
QUADSPI_IRQHandler:
  b .

  .thumb_func
  .weak DMA1_CH8_IRQHandler
DMA1_CH8_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH6_IRQHandler
DMA2_CH6_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH7_IRQHandler
DMA2_CH7_IRQHandler:
  b .

  .thumb_func
  .weak DMA2_CH8_IRQHandler
DMA2_CH8_IRQHandler:
  b .

  .thumb_func
  .weak Cordic_IRQHandler
Cordic_IRQHandler:
  b .

  .thumb_func
  .weak FMAC_IRQHandler
FMAC_IRQHandler:
  b .

#endif

/*****************************************************************************
 * Vector Table                                                              *
 *****************************************************************************/

  .section .vectors, "ax"
  .balign 512
  .global _vectors
  .extern __stack_end__
  .extern Reset_Handler

_vectors:
  .word __stack_end__
  .word Reset_Handler
  .word NMI_Handler
  .word HardFault_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word SVC_Handler
  .word 0 /* Reserved */
  .word 0 /* Reserved */
  .word PendSV_Handler
  .word SysTick_Handler
  .word WWDG_IRQHandler
  .word PVD_PVM_IRQHandler
  .word RTC_TAMP_CSS_LSE_IRQHandler
  .word RTC_WKUP_IRQHandler
  .word FLASH_IRQHandler
  .word RCC_IRQHandler
  .word EXTI0_IRQHandler
  .word EXTI1_IRQHandler
  .word EXTI2_IRQHandler
  .word EXTI3_IRQHandler
  .word EXTI4_IRQHandler
  .word DMA1_CH1_IRQHandler
  .word DMA1_CH2_IRQHandler
  .word DMA1_CH3_IRQHandler
  .word DMA1_CH4_IRQHandler
  .word DMA1_CH5_IRQHandler
  .word DMA1_CH6_IRQHandler
  .word DMA1_CH7_IRQHandler
  .word ADC1_2_IRQHandler
  .word USB_HP_IRQHandler
  .word USB_LP_IRQHandler
  .word fdcan1_intr1_it_IRQHandler
  .word fdcan1_intr0_it_IRQHandler
  .word EXTI9_5_IRQHandler
  .word TIM1_BRK_TIM15_IRQHandler
  .word TIM1_UP_TIM16_IRQHandler
  .word TIM1_TRG_COM_IRQHandler
  .word TIM1_CC_IRQHandler
  .word TIM2_IRQHandler
  .word TIM3_IRQHandler
  .word TIM4_IRQHandler
  .word I2C1_EV_IRQHandler
  .word I2C1_ER_IRQHandler
  .word I2C2_EV_IRQHandler
  .word I2C2_ER_IRQHandler
  .word SPI1_IRQHandler
  .word SPI2_IRQHandler
  .word USART1_IRQHandler
  .word USART2_IRQHandler
  .word USART3_IRQHandler
  .word EXTI15_10_IRQHandler
  .word RTC_ALARM_IRQHandler
  .word USBWakeUP_IRQHandler
  .word TIM8_BRK_IRQHandler
  .word TIM8_UP_IRQHandler
  .word TIM8_TRG_COM_IRQHandler
  .word TIM8_CC_IRQHandler
  .word ADC3_IRQHandler
  .word FMC_IRQHandler
  .word LPTIM1_IRQHandler
  .word TIM5_IRQHandler
  .word SPI3_IRQHandler
  .word UART4_IRQHandler
  .word UART5_IRQHandler
  .word TIM6_DACUNDER_IRQHandler
  .word TIM7_IRQHandler
  .word DMA2_CH1_IRQHandler
  .word DMA2_CH2_IRQHandler
  .word DMA2_CH3_IRQHandler
  .word DMA2_CH4_IRQHandler
  .word DMA2_CH5_IRQHandler
  .word ADC4_IRQHandler
  .word ADC5_IRQHandler
  .word UCPD1_IRQHandler
  .word COMP1_2_3_IRQHandler
  .word COMP4_5_6_IRQHandler
  .word COMP7_IRQHandler
  .word HRTIM_Master_IRQn_IRQHandler
  .word HRTIM_TIMA_IRQn_IRQHandler
  .word HRTIM_TIMB_IRQn_IRQHandler
  .word HRTIM_TIMC_IRQn_IRQHandler
  .word HRTIM_TIMD_IRQn_IRQHandler
  .word HRTIM_TIME_IRQn_IRQHandler
  .word HRTIM_TIM_FLT_IRQn_IRQHandler
  .word HRTIM_TIMF_IRQn_IRQHandler
  .word CRS_IRQHandler
  .word SAI_IRQHandler
  .word TIM20_BRK_IRQHandler
  .word TIM20_UP_IRQHandler
  .word TIM20_TRG_COM_IRQHandler
  .word TIM20_CC_IRQHandler
  .word FPU_IRQHandler
  .word I2C4_EV_IRQHandler
  .word I2C4_ER_IRQHandler
  .word SPI4_IRQHandler
  .word AES_IRQHandler
  .word FDCAN2_intr0_IRQHandler
  .word FDCAN2_intr1_IRQHandler
  .word FDCAN3_intr0_IRQHandler
  .word FDCAN3_intr1_IRQHandler
  .word RNG_IRQHandler
  .word LPUART_IRQHandler
  .word I2C3_EV_IRQHandler
  .word I2C3_ER_IRQHandler
  .word DMAMUX_OVR_IRQHandler
  .word QUADSPI_IRQHandler
  .word DMA1_CH8_IRQHandler
  .word DMA2_CH6_IRQHandler
  .word DMA2_CH7_IRQHandler
  .word DMA2_CH8_IRQHandler
  .word Cordic_IRQHandler
  .word FMAC_IRQHandler
_vectors_end:

#ifdef VECTORS_IN_RAM
  .section .vectors_ram, "ax"
  .balign 512
  .global _vectors_ram

_vectors_ram:
  .space _vectors_end - _vectors, 0
#endif
