# Use these settings for Cortex-M7
set(common_TARGET_OPTS_LIST
  -mcpu=cortex-m7
  -mlittle-endian
  -mfloat-abi=hard
  -mabi=aapcs
  -mfpu=fpv5-sp-d16
  -mthumb
  -munaligned-access
  -mtp=soft
  -mfp16-format=ieee

  -fmessage-length=0
  -fomit-frame-pointer
  -fno-common
  -fmath-errno
  -fdiagnostics-show-caret
  -ffunction-sections
  -fdata-sections
  -fshort-enums

  -Wall
  -Wextra
  -Wstrict-prototypes
  -Wstrict-aliasing
  -Wunused-variable
  -Wuninitialized
  -Wmissing-field-initializers
  -Wmissing-prototypes
  -Wundef

  -gdwarf-4
  -g3
  -gpubnames
)

#-Cleanup-------------------------------------------------------------
list(JOIN common_TARGET_OPTS_LIST " " common_TARGET_OPTS_STR )
unset(common_TARGET_OPTS_LIST)
