/*
 * FreeRTOS V202411.00
 * Copyright (C) 2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of
 * this software and associated documentation files (the "Software"), to deal in
 * the Software without restriction, including without limitation the rights to
 * use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
 * the Software, and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
 * FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
 * COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
 * IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 * https://www.FreeRTOS.org
 * https://github.com/FreeRTOS
 *
 */

#ifndef SECURE_REG_TEST_ASM_H
#define SECURE_REG_TEST_ASM_H

/* Callback function pointer definition. */
typedef void ( * RegTestCallback_t )( void );

/**
 * @brief Function that implements reg tests for the secure side.
 *
 * This function is exported as "non-secure callable" and is called
 * from a FreeRTOS task on the non-secure side.
 */
void vRegTestAsm_Secure( void );

/**
 * @brief Invokes the supplied reg test callback on the non-secure side.
 *
 * This function is exported as "non-secure callable" and is called
 * from a FreeRTOS task on the non-secure side..
 */
void vRegTest_NonSecureCallback( RegTestCallback_t pxRegTestCallback );

#endif /* SECURE_REG_TEST_ASM_H */
