# FreeRTOS Demo project with CMake and SEGGER Compiler Toolchain
This project is a demo that showcases how we can use CMake and the SEGGER compiler toolchain for a FreeRTOS project.\
The demo has been derived from the official FreeRTOS Demo from [version 202411.00](https://github.com/FreeRTOS/FreeRTOS/releases/tag/202411.00)\
The project is also designed to support building with ARM GCC as well in order to easily derive build-size comparisons.\
This demo runs on the [Atmel/Microchip SAME70_Xplained Ultra board](https://www.microchip.com/en-us/development-tool/DM320113) and is set up to be used with Visual Studio Code using CMake presets. Of course command-line usage is also possible.


This project relies heavily on the CMake preset mechanism. This makes it easy to reproduce results and reduces effort on user end to configure builds properly.\
The presets provided in CMakePresets.json are named in a manner that should make their purpose clear e.g. 
+ configuration preset: `armgcc_flat_noipo`, `sgr_flat_ipo`, etc.
+ build preset: `sgr_flat_noipo_rel`, `sgr_flat_noipo_minsizerel`, etc.

## Setup
### A. Install FreeRTOS kernel source package
**NOTE:** You may skip this step if you downloaded this project as a complete ZIP package
1. Download https://github.com/FreeRTOS/FreeRTOS-Kernel/releases/download/V11.1.0/FreeRTOS-KernelV11.1.0.zip \
   (This project has also been tested successfully with FreeRTOS-Kernel ccabdec2f8c2cb8c7740e018546a53a3e6e0ef22 from the main branch)
2. Unzip the download package into a working directory (or use git clone).
3. Rename the unzipped folder to `Source`

### B. Clone this Demo project
**NOTE:** You may skip this step if you downloaded this project as a complete ZIP package
1. From within the working directory, clone this project with the `--recurse-submodules` option and make sure the target folder name is `Demo`:
   ```
   git clone --recurse-submodules <url_to_this_project> Demo
   ```
   The `--recurse-submodules` option is required for ensuring that the SEGGER Cmake toolchain files become available. The ARMGCC toolchain files are already stored within this project.
2. You should now have this folder structure in your working directory (hiding some details):
    ```
    .
    ├── Demo
    │   ├── CORTEX_M7_SAME70_Xplained_AtmelStudio
    │   │   ├── CMakeLists.txt
    │   │   ├── CMakePresets.json
    │   │   ├── RTOSDemo.atsln
    │   │   ├── RTOSDemo.cproj
    │   │   ├── Readme.md
    │   │   ├── Toolchains
    │   │   │   └── Segger
    │   │   ├── cmake_modules
    │   │   │   └── Platform
    │   │   ├── cmake_toolchains
    │   │   │   ├── arm-cmake-toolchains
    │   │   │   │   ├── arm-gcc-toolchain.cmake
    │   │   │   └── segger-toolchain-cmake
    │   │   │       ├── segger-toolchain.cmake
    │   │   │       └── segger_cmake_modules
    │   │   └── src
    └── Source
        ├── CMakeLists.txt
        ├── GitHub-FreeRTOS-Kernel-Home.url
        ├── History.txt
        ├── LICENSE.md
        ├── MISRA.md
        ├── Quick_Start_Guide.url
        ├── README.md
        ├── croutine.c
        ├── cspell.config.yaml
        ├── event_groups.c
        ├── examples
        ├── include
        ├── list.c
        ├── manifest.yml
        ├── portable
        ├── queue.c
        ├── stream_buffer.c
        ├── tasks.c
        └── timers.c
    ```

### C. Install required toolchains, CMake toolchain files and other prerequisites
1. Install other prerequisites (e.g. Ninja etc) as described at [segger-toolchain-cmake](http://gitea.segger.local/public/segger-toolchain-cmake)
2. For ARM GCC builds, install an ARM GCC distribution: https://developer.arm.com/downloads/-/arm-gnu-toolchain-downloads

### D. User-specific adaptations via environment variables
1. Make sure the `PATH` environment variable contains the paths to the following:
    - `cmake` executable (at least version 3.24)
    - `ninja`executable
    - `arm-none-eabi-gcc` executable etc. (from your ARM GCC distribution)

## Command-line usage
**NOTE:** issue these commands from within the `Demo/CORTEX_M7_SAME70_Xplained_AtmelStudio` subfolder!
1. `cmake --list-presets` reveals which configuration-presets are available:\
<img src=".pics/step_1.png" alt="Alt Text" style="width:20%; height:auto;">

2. `cmake --build --list-presets` reveals which build-presets are available:\
<img src=".pics/step_2.png" alt="Alt Text" style="width:16%; height:auto;">

3. First execute the configuration step with `cmake --preset <config-preset-name>`:\
<img src=".pics/step_3.png" alt="Alt Text" style="width:20%; height:auto;">

4. Then execute the build step with `cmake --build <build-preset-name>`:\
<img src=".pics/step_4.png" alt="Alt Text" style="width:28%; height:auto;">

## VS-Code usage
**NOTE:** Open the `Demo/CORTEX_M7_SAME70_Xplained_AtmelStudio` subfolder as the workspace folder withing VSCode!
1. When opening the project folder in VS-Code for the first time, the CMake extension pops up a drop-down list of configuration-presets to choose from:\
<img src=".pics/vscode_fresh.png" alt="Alt Text" style="width:60%; height:auto;">

2. The selected configuration-preset is shown in the extensions page. You may also choose another configuration-preset by clikcing on the pencil icon:\
<img src=".pics/vscode_sel_cfg_prst.png" alt="Alt Text" style="width:25%; height:auto;">

3. The currently effective build-preset is shown in the extensions page. You may also choose another build-preset by clikcing on the pencil icon:\
<img src=".pics/vscode_sel_bld_prst.png" alt="Alt Text" style="width:60%; height:auto;">

4. Click on the build-icon on the "Build" section in order to build the associated artefacts:\
<img src=".pics/vscode_build.png" alt="Alt Text" style="width:60%; height:auto;">

## Project configurations
This project supports following kinds of builds (and to a certain extent combinations of them):
  - **LTO/IPO** versus **non-LTO** builds: LTO/IPO-builds can only be done with the SEGGER toolchain.\
  `PROJECT_ENABLE_IPO=1` for LTO/IPO builds.
  - **SEGGER** versus **ARM GCC** builds:
    - GNU ARM GCC builds are activated by setting `USE_ARM_GCC_TOOLCHAIN=1`. This variable is also used within the project in order to select toolchain-specific device/startup source code.
    - **Note**: this project modifies the default compiler flags provided by the ARM GCC CMake toolchain file such that `-Os` is used instead of `-O3` for `Release` builds and `-Oz` is used instead of `-Os` for `MinSizeRel`. This is done in order to have a fair comparison between SEGGER toolchain and ARM GCC for build sizes, since by default the ARM GCC `Release` and `MinSizeRel` builds would otherwise generate much larger binaries.
