/**
  ******************************************************************************
  * @file    stm32mp151axx_cm4.h
  * @author  MCD Application Team
  * @brief   CMSIS stm32mp151axx_cm4 Device Peripheral Access Layer Header File.
  *
  *          This file contains:
  *           - Data structures and the address mapping for all peripherals
  *           - Peripheral's registers declarations and bits definition
  *           - Macros to access peripherals registers hardware
  *
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; COPYRIGHT(c) 2017 STMicroelectronics</center></h2>
  *
  * Redistribution and use in source and binary forms, with or without modification,
  * are permitted provided that the following conditions are met:
  *   1. Redistributions of source code must retain the above copyright notice,
  *      this list of conditions and the following disclaimer.
  *   2. Redistributions in binary form must reproduce the above copyright notice,
  *      this list of conditions and the following disclaimer in the documentation
  *      and/or other materials provided with the distribution.
  *   3. Neither the name of STMicroelectronics nor the names of its contributors
  *      may be used to endorse or promote products derived from this software
  *      without specific prior written permission.
  *
  * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
  * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
  * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
  * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
  * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
  * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  ******************************************************************************
  */

/** @addtogroup CMSIS_Device
  * @{
  */

/** @addtogroup stm32mp151axx_cm4
  * @{
  */

#ifndef __STM32MP151Axx_CM4_H
#define __STM32MP151Axx_CM4_H

#ifdef __cplusplus
 extern "C" {
#endif /* __cplusplus */

/**
  * @brief Bit position definition inside a 32 bits registers
  */
#define  B(x) \
        ((uint32_t) 1 << x)
/**
  * @}
  */

/** @addtogroup Peripheral_interrupt_number_definition
  * @{
  */

/**
 * @brief STM32MP1XX Interrupt Number Definition, according to the selected device
 *        in @ref Library_configuration_section
 */
 typedef enum IRQn
 {
 /******  Cortex-M Processor Exceptions Numbers *******************************************************************/
   NonMaskableInt_IRQn         = -14,   /*!< 2 Non Maskable Interrupt                                             */
   HardFault_IRQn              = -13,   /*!< 4 Cortex-M Memory Management Interrupt                               */
   MemoryManagement_IRQn       = -12,   /*!< 4 Cortex-M Memory Management Interrupt                               */
   BusFault_IRQn               = -11,   /*!< 5 Cortex-M Bus Fault Interrupt                                       */
   UsageFault_IRQn             = -10,   /*!< 6 Cortex-M Usage Fault Interrupt                                     */
   SVCall_IRQn                 = -5,    /*!< 11 Cortex-M SV Call Interrupt                                        */
   DebugMonitor_IRQn           = -4,    /*!< 12 Cortex-M Debug Monitor Interrupt                                  */
   PendSV_IRQn                 = -2,    /*!< 14 Cortex-M Pend SV Interrupt                                        */
   SysTick_IRQn                = -1,    /*!< 15 Cortex-M System Tick Interrupt                                    */
 /******  STM32 specific Interrupt Numbers ************************************************************************/
   WWDG1_IRQn                  = 0,     /*!< Window WatchDog Interrupt                                            */
   PVD_AVD_IRQn                = 1,     /*!< PVD & AVD detector through EXTI                                      */
   TAMP_IRQn                   = 2,     /*!< Tamper interrupts through the EXTI line                              */
   RTC_WKUP_ALARM_IRQn         = 3,     /*!< RTC Wakeup and Alarm (A & B) interrupt through the EXTI line         */
   RESERVED_4                  = 4,     /*!< RESERVED interrupt                                                   */
   RCC_IRQn                    = 5,     /*!< RCC global Interrupt                                                 */
   EXTI0_IRQn                  = 6,     /*!< EXTI Line0 Interrupt                                                 */
   EXTI1_IRQn                  = 7,     /*!< EXTI Line1 Interrupt                                                 */
   EXTI2_IRQn                  = 8,     /*!< EXTI Line2 Interrupt                                                 */
   EXTI3_IRQn                  = 9,     /*!< EXTI Line3 Interrupt                                                 */
   EXTI4_IRQn                  = 10,    /*!< EXTI Line4 Interrupt                                                 */
   DMA1_Stream0_IRQn           = 11,    /*!< DMA1 Stream 0 global Interrupt                                       */
   DMA1_Stream1_IRQn           = 12,    /*!< DMA1 Stream 1 global Interrupt                                       */
   DMA1_Stream2_IRQn           = 13,    /*!< DMA1 Stream 2 global Interrupt                                       */
   DMA1_Stream3_IRQn           = 14,    /*!< DMA1 Stream 3 global Interrupt                                       */
   DMA1_Stream4_IRQn           = 15,    /*!< DMA1 Stream 4 global Interrupt                                       */
   DMA1_Stream5_IRQn           = 16,    /*!< DMA1 Stream 5 global Interrupt                                       */
   DMA1_Stream6_IRQn           = 17,    /*!< DMA1 Stream 6 global Interrupt                                       */
   ADC1_IRQn                   = 18,    /*!< ADC1 global Interrupts                                               */
   RESERVED_19                 = 19,    /*!< reserved                                                             */
   RESERVED_20                 = 20,    /*!< reserved                                                             */
   RESERVED_21                 = 21,    /*!< reserved                                                             */
   RESERVED_22                 = 22,    /*!< reserved                                                             */
   EXTI5_IRQn                  = 23,    /*!< External Line[9:5] Interrupts                                        */
   TIM1_BRK_IRQn               = 24,    /*!< TIM1 Break interrupt                                                 */
   TIM1_UP_IRQn                = 25,    /*!< TIM1 Update Interrupt                                                */
   TIM1_TRG_COM_IRQn           = 26,    /*!< TIM1 Trigger and Commutation Interrupt                               */
   TIM1_CC_IRQn                = 27,    /*!< TIM1 Capture Compare Interrupt                                       */
   TIM2_IRQn                   = 28,    /*!< TIM2 global Interrupt                                                */
   TIM3_IRQn                   = 29,    /*!< TIM3 global Interrupt                                                */
   TIM4_IRQn                   = 30,    /*!< TIM4 global Interrupt                                                */
   I2C1_EV_IRQn                = 31,    /*!< I2C1 Event Interrupt                                                 */
   I2C1_ER_IRQn                = 32,    /*!< I2C1 Error Interrupt                                                 */
   I2C2_EV_IRQn                = 33,    /*!< I2C2 Event Interrupt                                                 */
   I2C2_ER_IRQn                = 34,    /*!< I2C2 Error Interrupt                                                 */
   SPI1_IRQn                   = 35,    /*!< SPI1 global Interrupt                                                */
   SPI2_IRQn                   = 36,    /*!< SPI2 global Interrupt                                                */
   USART1_IRQn                 = 37,    /*!< USART1 global Interrupt                                              */
   USART2_IRQn                 = 38,    /*!< USART2 global Interrupt                                              */
   USART3_IRQn                 = 39,    /*!< USART3 global Interrupt                                              */
   EXTI10_IRQn                 = 40,    /*!< EXTI Line 10 Interrupts                                              */
   RTC_TIMESTAMP_IRQn          = 41,    /*!< RTC TimeStamp through EXTI Line Interrupt                            */
   EXTI11_IRQn                 = 42,    /*!< EXTI Line 11 Interrupts                                              */
   TIM8_BRK_IRQn               = 43,    /*!< TIM8 Break Interrupt                                                 */
   TIM8_UP_IRQn                = 44,    /*!< TIM8 Update Interrupt                                                */
   TIM8_TRG_COM_IRQn           = 45,    /*!< TIM8 Trigger and Commutation Interrupt                               */
   TIM8_CC_IRQn                = 46,    /*!< TIM8 Capture Compare Interrupt                                       */
   DMA1_Stream7_IRQn           = 47,    /*!< DMA1 Stream7 Interrupt                                               */
   FMC_IRQn                    = 48,    /*!< FMC global Interrupt                                                 */
   SDMMC1_IRQn                 = 49,    /*!< SDMMC1 global Interrupt                                              */
   TIM5_IRQn                   = 50,    /*!< TIM5 global Interrupt                                                */
   SPI3_IRQn                   = 51,    /*!< SPI3 global Interrupt                                                */
   UART4_IRQn                  = 52,    /*!< UART4 global Interrupt                                               */
   UART5_IRQn                  = 53,    /*!< UART5 global Interrupt                                               */
   TIM6_IRQn                   = 54,    /*!< TIM6 global                                                          */
   TIM7_IRQn                   = 55,    /*!< TIM7 global interrupt                                                */
   DMA2_Stream0_IRQn           = 56,    /*!< DMA2 Stream 0 global Interrupt                                       */
   DMA2_Stream1_IRQn           = 57,    /*!< DMA2 Stream 1 global Interrupt                                       */
   DMA2_Stream2_IRQn           = 58,    /*!< DMA2 Stream 2 global Interrupt                                       */
   DMA2_Stream3_IRQn           = 59,    /*!< GPDMA2 Stream 3 global Interrupt                                     */
   DMA2_Stream4_IRQn           = 60,    /*!< GPDMA2 Stream 4 global Interrupt                                     */
   ETH1_IRQn                   = 61,    /*!< Ethernet global Interrupt                                            */
   ETH1_WKUP_IRQn              = 62,    /*!< Ethernet Wakeup through EXTI line Interrupt                          */
   RESERVED_63                 = 63,    /*!< RESERVED interrupt                                                    */
   EXTI6_IRQn                  = 64,    /*!< EXTI Line 6 Interrupts                                               */
   EXTI7_IRQn                  = 65,    /*!< EXTI Line 7 Interrupts                                               */
   EXTI8_IRQn                  = 66,    /*!< EXTI Line 8 Interrupts                                               */
   EXTI9_IRQn                  = 67,    /*!< EXTI Line 9 Interrupts                                               */
   DMA2_Stream5_IRQn           = 68,    /*!< DMA2 Stream 5 global interrupt                                       */
   DMA2_Stream6_IRQn           = 69,    /*!< DMA2 Stream 6 global interrupt                                       */
   DMA2_Stream7_IRQn           = 70,    /*!< DMA2 Stream 7 global interrupt                                       */
   USART6_IRQn                 = 71,    /*!< USART6 global interrupt                                              */
   I2C3_EV_IRQn                = 72,    /*!< I2C3 event interrupt                                                 */
   I2C3_ER_IRQn                = 73,    /*!< I2C3 error interrupt                                                 */
   USBH_OHCI_IRQn              = 74,    /*!< USB OHCI global interrupt                                            */
   USBH_EHCI_IRQn              = 75,    /*!< USB EHCI global interrupt                                            */
   EXTI12_IRQn                 = 76,    /*!< EXTI Line 76 Interrupts                                              */
   EXTI13_IRQn                 = 77,    /*!< EXTI Line 77 Interrupts                                              */
   DCMI_IRQn                   = 78,    /*!< DCMI global interrupt                                                */
   RESERVED_79                 = 79,   /*!< RESERVED interrupt                                                    */
   HASH1_IRQn                  = 80,    /*!< Hash global interrupt                                                */
   FPU_IRQn                    = 81,    /*!< FPU global interrupt                                                 */
   UART7_IRQn                  = 82,    /*!< UART7 global interrupt                                               */
   UART8_IRQn                  = 83,    /*!< UART8 global interrupt                                               */
   SPI4_IRQn                   = 84,    /*!< SPI4 global Interrupt                                                */
   SPI5_IRQn                   = 85,    /*!< SPI5 global Interrupt                                                */
   SPI6_IRQn                   = 86,    /*!< SPI6 global Interrupt                                                */
   SAI1_IRQn                   = 87,    /*!< SAI1 global Interrupt                                                */
   LTDC_IRQn                   = 88,    /*!< LTDC global Interrupt                                                */
   LTDC_ER_IRQn                = 89,    /*!< LTDC Error global Interrupt                                          */
   ADC2_IRQn                   = 90,    /*!< ADC2 global Interrupts                                               */
   SAI2_IRQn                   = 91,    /*!< SAI2 global Interrupt                                                */
   QUADSPI_IRQn                = 92,    /*!< Quad SPI global interrupt                                            */
   LPTIM1_IRQn                 = 93,    /*!< LP TIM1 interrupt                                                    */
   CEC_IRQn                    = 94,    /*!< HDMI-CEC global Interrupt                                            */
   I2C4_EV_IRQn                = 95,    /*!< I2C4 Event Interrupt                                                 */
   I2C4_ER_IRQn                = 96,    /*!< I2C4 Error Interrupt                                                 */
   SPDIF_RX_IRQn               = 97,    /*!< SPDIF-RX global Interrupt                                            */
   OTG_IRQn                   = 98,    /*!< USB On The Go global interrupt                                       */
   RESERVED_99                 = 99,    /*!< RESERVED interrupt                                                   */
   IPCC_RX0_IRQn               = 100,   /*!< IPCC RX0 Occupied interrupt (interrupt going to AIEC input as well)  */
   IPCC_TX0_IRQn               = 101,   /*!< IPCC TX0 Free interrupt (interrupt going to AIEC input as well)      */
   DMAMUX1_OVR_IRQn            = 102,   /*!< DMAMUX1 Overrun interrupt                                            */
   IPCC_RX1_IRQn               = 103,   /*!< IPCC RX1 Occupied interrupt (interrupt going to AIEC input as well)  */
   IPCC_TX1_IRQn               = 104,   /*!< IPCC TX1 Free interrupt (interrupt going to AIEC input as well)      */
   RESERVED_105                = 105,   /*!< RESERVED interrupt                                                   */
   HASH2_IRQn                  = 106,   /*!< Crypto Hash2 interrupt                                               */
   I2C5_EV_IRQn                = 107,   /*!< I2C5 Event Interrupt                                                 */
   I2C5_ER_IRQn                = 108,   /*!< I2C5 Error Interrupt                                                 */
   RESERVED_109                = 109,   /*!< RESERVED interrupt                                                   */
   DFSDM1_FLT0_IRQn            = 110,   /*!< DFSDM Filter1 Interrupt                                              */
   DFSDM1_FLT1_IRQn            = 111,   /*!< DFSDM Filter2 Interrupt                                              */
   DFSDM1_FLT2_IRQn            = 112,   /*!< DFSDM Filter3 Interrupt                                              */
   DFSDM1_FLT3_IRQn            = 113,   /*!< DFSDM Filter4 Interrupt                                              */
   SAI3_IRQn                   = 114,   /*!< SAI3 global Interrupt                                                */
   DFSDM1_FLT4_IRQn            = 115,   /*!< DFSDM Filter5 Interrupt                                              */
   TIM15_IRQn                  = 116,   /*!< TIM15 global Interrupt                                               */
   TIM16_IRQn                  = 117,   /*!< TIM16 global Interrupt                                               */
   TIM17_IRQn                  = 118,   /*!< TIM17 global Interrupt                                               */
   TIM12_IRQn                  = 119,   /*!< TIM12 global Interrupt                                               */
   MDIOS_IRQn                  = 120,   /*!< MDIOS global Interrupt                                               */
   EXTI14_IRQn                 = 121,   /*!< EXTI Line 14 Interrupts                                              */
   MDMA_IRQn                   = 122,   /*!< MDMA global Interrupt                                                */
   RESERVED_123                = 123,   /*!< RESERVED interrupt                                                   */
   SDMMC2_IRQn                 = 124,   /*!< SDMMC2 global Interrupt                                              */
   HSEM_IT2_IRQn               = 125,   /*!< HSEM Semaphore Interrupt 2                                           */
   DFSDM1_FLT5_IRQn            = 126,   /*!< DFSDM Filter6 Interrupt                                              */
   EXTI15_IRQn                 = 127,   /*!< EXTI Line 15 Interrupts                                              */
   nCTIIRQ1_IRQn               = 128,   /*!< Cortex-M4 CTI interrupt 1                                            */
   nCTIIRQ2_IRQn               = 129,   /*!< Cortex-M4 CTI interrupt 2                                            */
   TIM13_IRQn                  = 130,   /*!< TIM13 global interrupt                                               */
   TIM14_IRQn                  = 131,   /*!< TIM14 global interrupt                                               */
   DAC_IRQn                    = 132,   /*!< DAC1 and DAC2 underrun error interrupts                              */
   RNG1_IRQn                   = 133,   /*!< RNG1 interrupt                                                       */
   RNG2_IRQn                   = 134,   /*!< RNG2 interrupt                                                       */
   I2C6_EV_IRQn                = 135,   /*!< I2C6 Event Interrupt                                                 */
   I2C6_ER_IRQn                = 136,   /*!< I2C6 Error Interrupt                                                 */
   SDMMC3_IRQn                 = 137,   /*!< SDMMC3 global Interrupt                                              */
   LPTIM2_IRQn                 = 138,   /*!< LP TIM2 global interrupt                                             */
   LPTIM3_IRQn                 = 139,   /*!< LP TIM3 global interrupt                                             */
   LPTIM4_IRQn                 = 140,   /*!< LP TIM4 global interrupt                                             */
   LPTIM5_IRQn                 = 141,   /*!< LP TIM5 global interrupt                                             */
   ETH1_LPI_IRQn               = 142,   /*!< ETH1_LPI interrupt (LPI: lpi_intr_o)                                 */
   RESERVED_143                = 143,   /*!< RESERVED interrupt                                                   */
   MPU_SEV_IRQn                = 144,   /*!< MPU Send Event  interrupt                                            */
   RCC_WAKEUP_IRQn             = 145,   /*!< RCC Wake up interrupt                                                */
   SAI4_IRQn                   = 146,   /*!< SAI4 global interrupt                                                */
   DTS_IRQn                    = 147,   /*!< Temperature sensor Global Interrupt                                  */
   RESERVED_148                = 148,   /*!< RESERVED interrupt                                                   */
   WAKEUP_PIN_IRQn             = 149,   /*!< Interrupt for all 6 wake-up pins                                     */
   MAX_IRQ_n
 } IRQn_Type;

/** @addtogroup Configuration_section_for_CMSIS
  * @{
  */

#define SDC        /*!< Step Down Converter feature */

/**
  * @brief Configuration of the Cortex-M4/ Cortex-M7 Processor and Core Peripherals
   */
#define __CM4_REV                 0x0001  /*!< Cortex-M4 revision r0p1                       */
#define __MPU_PRESENT             1       /*!< CM4 provides an MPU                           */
#define __NVIC_PRIO_BITS          4       /*!< CM4 uses 4 Bits for the Priority Levels       */
#define __Vendor_SysTickConfig    0       /*!< Set to 1 if different SysTick Config is used  */
#define __FPU_PRESENT             1       /*!< FPU present                                   */

#include "core_cm4.h"                     /*!< Cortex-M4 processor and core peripherals      */
#include "system_stm32mp1xx.h"


#include <stdint.h>

/** @addtogroup Peripheral_registers_structures
  * @{
  */

/**
  * @brief Analog to Digital Converter
  */

typedef struct
{
  __IO uint32_t ISR;              /*!< ADC Interrupt and Status Register,                 Address offset: 0x00 */
  __IO uint32_t IER;              /*!< ADC Interrupt Enable Register,                     Address offset: 0x04 */
  __IO uint32_t CR;               /*!< ADC control register,                              Address offset: 0x08 */
  __IO uint32_t CFGR;             /*!< ADC Configuration register,                        Address offset: 0x0C */
  __IO uint32_t CFGR2;            /*!< ADC Configuration register 2,                      Address offset: 0x10 */
  __IO uint32_t SMPR1;            /*!< ADC sample time register 1,                        Address offset: 0x14 */
  __IO uint32_t SMPR2;            /*!< ADC sample time register 2,                        Address offset: 0x18 */
  __IO uint32_t PCSEL;            /*!< ADC pre-channel selection,                         Address offset: 0x1C */
  __IO uint32_t LTR1;             /*!< ADC watchdog Lower threshold register 1,           Address offset: 0x20 */
  __IO uint32_t HTR1;             /*!< ADC watchdog higher threshold register 1,          Address offset: 0x24 */
  uint32_t      RESERVED1;        /*!< Reserved, 0x028                                                         */
  uint32_t      RESERVED2;        /*!< Reserved, 0x02C                                                         */
  __IO uint32_t SQR1;             /*!< ADC regular sequence register 1,                   Address offset: 0x30 */
  __IO uint32_t SQR2;             /*!< ADC regular sequence register 2,                   Address offset: 0x34 */
  __IO uint32_t SQR3;             /*!< ADC regular sequence register 3,                   Address offset: 0x38 */
  __IO uint32_t SQR4;             /*!< ADC regular sequence register 4,                   Address offset: 0x3C */
  __IO uint32_t DR;               /*!< ADC regular data register,                         Address offset: 0x40 */
  uint32_t      RESERVED3;        /*!< Reserved, 0x044                                                         */
  uint32_t      RESERVED4;        /*!< Reserved, 0x048                                                         */
  __IO uint32_t JSQR;             /*!< ADC injected sequence register,                    Address offset: 0x4C */
  uint32_t      RESERVED5[4];     /*!< Reserved, 0x050 - 0x05C                                                 */
  __IO uint32_t OFR1;             /*!< ADC offset register 1,                             Address offset: 0x60 */
  __IO uint32_t OFR2;             /*!< ADC offset register 2,                             Address offset: 0x64 */
  __IO uint32_t OFR3;             /*!< ADC offset register 3,                             Address offset: 0x68 */
  __IO uint32_t OFR4;             /*!< ADC offset register 4,                             Address offset: 0x6C */
  uint32_t      RESERVED6[4];     /*!< Reserved, 0x070 - 0x07C                                                 */
  __IO uint32_t JDR1;             /*!< ADC injected data register 1,                      Address offset: 0x80 */
  __IO uint32_t JDR2;             /*!< ADC injected data register 2,                      Address offset: 0x84 */
  __IO uint32_t JDR3;             /*!< ADC injected data register 3,                      Address offset: 0x88 */
  __IO uint32_t JDR4;             /*!< ADC injected data register 4,                      Address offset: 0x8C */
  uint32_t      RESERVED7[4];     /*!< Reserved, 0x090 - 0x09C                                                 */
  __IO uint32_t AWD2CR;           /*!< ADC  Analog Watchdog 2 Configuration Register,     Address offset: 0xA0 */
  __IO uint32_t AWD3CR;           /*!< ADC  Analog Watchdog 3 Configuration Register,     Address offset: 0xA4 */
  uint32_t      RESERVED8;        /*!< Reserved, 0x0A8                                                         */
  uint32_t      RESERVED9;        /*!< Reserved, 0x0AC                                                         */
  __IO uint32_t LTR2;             /*!< ADC watchdog Lower threshold register 2,           Address offset: 0xB0 */
  __IO uint32_t HTR2;             /*!< ADC watchdog Higher threshold register 2,          Address offset: 0xB4 */
  __IO uint32_t LTR3;             /*!< ADC watchdog Lower threshold register 3,           Address offset: 0xB8 */
  __IO uint32_t HTR3;             /*!< ADC watchdog Higher threshold register 3,          Address offset: 0xBC */
  __IO uint32_t DIFSEL;           /*!< ADC  Differential Mode Selection Register,         Address offset: 0xC0 */
  __IO uint32_t CALFACT;          /*!< ADC  Calibration Factors,                          Address offset: 0xC4 */
  __IO uint32_t CALFACT2;         /*!< ADC  Linearity Calibration Factors,                Address offset: 0xC8 */
  uint32_t      RESERVED10;       /*!< Reserved,                                                         0x0CC */
  __IO uint32_t OR;               /*!< ADC  Calibration Factors,                         Address offset: 0x0D0 */
  uint32_t  RESERVED11[200];       /*!< Reserved,                                                 0x0D4 - 0x3F0 */
  __IO uint32_t VERR;             /*!< ADC version register,                             Address offset: 0x3F4 */
  __IO uint32_t IPIDR;            /*!< ADC ID register,                                  Address offset: 0x3F8 */
  __IO uint32_t SIDR;             /*!< ADC Size ID register,                             Address offset: 0x3FC */
} ADC_TypeDef;


typedef struct
{
  __IO uint32_t CSR; /*!< ADC Common status register, Address offset: ADC1/3 base address + 0x300 */
  uint32_t RESERVED; /*!< Reserved, ADC1/3 base address + 0x304 */
  __IO uint32_t CCR; /*!< ADC common control register, Address offset: ADC1/3 base address + 0x308 */
  __IO uint32_t CDR; /*!< ADC common regular data register for dual Address offset: ADC1/3 base address + 0x30C */
  __IO uint32_t CDR2; /*!< ADC common regular data register for 32-bit dual mode Address offset: ADC1/3 base address + 0x310 */

} ADC_Common_TypeDef;


/**
  * @brief Consumer Electronics Control
  */

typedef struct
{
  __IO uint32_t CR;           /*!< CEC control register,               Address offset: 0x000 */
  __IO uint32_t CFGR;         /*!< CEC configuration register,         Address offset: 0x004 */
  __IO uint32_t TXDR;         /*!< CEC Tx data register ,              Address offset: 0x008 */
  __IO uint32_t RXDR;         /*!< CEC Rx Data Register,               Address offset: 0x00C */
  __IO uint32_t ISR;          /*!< CEC Interrupt and Status Register,  Address offset: 0x010 */
  __IO uint32_t IER;          /*!< CEC interrupt enable register,      Address offset: 0x014 */
  uint32_t  RESERVED3[247];   /*!< Reserved,                                   0x018 - 0x3F0 */
  __IO uint32_t VERR;         /*!< CEC version register,               Address offset: 0x3F4 */
  __IO uint32_t IPIDR;        /*!< CEC ID register,                    Address offset: 0x3F8 */
  __IO uint32_t SIDR;         /*!< CEC Size ID register,               Address offset: 0x3FC */
}CEC_TypeDef;

/**
  * @brief CRC calculation unit
  */

typedef struct
{
  __IO uint32_t DR;          /*!< CRC Data register,                           Address offset: 0x000 */
  __IO uint32_t IDR;         /*!< CRC Independent data register,               Address offset: 0x004 */
  __IO uint32_t CR;          /*!< CRC Control register,                        Address offset: 0x008 */
  uint32_t      RESERVED2;   /*!< Reserved,                                                    0x00C */
  __IO uint32_t INIT;        /*!< Initial CRC value register,                  Address offset: 0x010 */
  __IO uint32_t POL;         /*!< CRC polynomial register,                     Address offset: 0x014 */
  uint32_t      RESERVED3[247];   /*!< Reserved,                                       0x018 - 0x3F0 */
  __IO uint32_t VERR;        /*!< CRC version register,                        Address offset: 0x3F4 */
  __IO uint32_t IPIDR;       /*!< CRC ID register,                             Address offset: 0x3F8 */
  __IO uint32_t SIDR;        /*!< CRC Size ID register,                        Address offset: 0x3FC */
} CRC_TypeDef;


/**
  * @brief Clock Recovery System
  */
typedef struct
{
  __IO uint32_t CR;            /*!< CRS ccontrol register,              Address offset: 0x00 */
  __IO uint32_t CFGR;          /*!< CRS configuration register,         Address offset: 0x04 */
  __IO uint32_t ISR;           /*!< CRS interrupt and status register,  Address offset: 0x08 */
  __IO uint32_t ICR;           /*!< CRS interrupt flag clear register,  Address offset: 0x0C */
} CRS_TypeDef;


/**
  * @brief Digital to Analog Converter
  */

typedef struct
{
  __IO uint32_t CR;       /*!< DAC control register,                                    Address offset: 0x00 */
  __IO uint32_t SWTRIGR;  /*!< DAC software trigger register,                           Address offset: 0x04 */
  __IO uint32_t DHR12R1;  /*!< DAC channel1 12-bit right-aligned data holding register, Address offset: 0x08 */
  __IO uint32_t DHR12L1;  /*!< DAC channel1 12-bit left aligned data holding register,  Address offset: 0x0C */
  __IO uint32_t DHR8R1;   /*!< DAC channel1 8-bit right aligned data holding register,  Address offset: 0x10 */
  __IO uint32_t DHR12R2;  /*!< DAC channel2 12-bit right aligned data holding register, Address offset: 0x14 */
  __IO uint32_t DHR12L2;  /*!< DAC channel2 12-bit left aligned data holding register,  Address offset: 0x18 */
  __IO uint32_t DHR8R2;   /*!< DAC channel2 8-bit right-aligned data holding register,  Address offset: 0x1C */
  __IO uint32_t DHR12RD;  /*!< Dual DAC 12-bit right-aligned data holding register,     Address offset: 0x20 */
  __IO uint32_t DHR12LD;  /*!< DUAL DAC 12-bit left aligned data holding register,      Address offset: 0x24 */
  __IO uint32_t DHR8RD;   /*!< DUAL DAC 8-bit right aligned data holding register,      Address offset: 0x28 */
  __IO uint32_t DOR1;     /*!< DAC channel1 data output register,                       Address offset: 0x2C */
  __IO uint32_t DOR2;     /*!< DAC channel2 data output register,                       Address offset: 0x30 */
  __IO uint32_t SR;       /*!< DAC status register,                                     Address offset: 0x34 */
  __IO uint32_t CCR;      /*!< DAC calibration control register,                        Address offset: 0x38 */
  __IO uint32_t MCR;      /*!< DAC mode control register,                               Address offset: 0x3C */
  __IO uint32_t SHSR1;    /*!< DAC Sample and Hold sample time register 1,              Address offset: 0x40 */
  __IO uint32_t SHSR2;    /*!< DAC Sample and Hold sample time register 2,              Address offset: 0x44 */
  __IO uint32_t SHHR;     /*!< DAC Sample and Hold hold time register,                  Address offset: 0x48 */
  __IO uint32_t SHRR;     /*!< DAC Sample and Hold refresh time register,               Address offset: 0x4C */
  uint32_t    RESERVED0[232];  /*!< Reserved,                                           Address offset: 0x50 - 0x3EC */
  __IO uint32_t IP_HWCFGR0;  /*!< DAC x IP hardware configuration register,             Address offset: 0x3F0 */
  __IO uint32_t IP_VER;      /*!< DAC version register,                                 Address offset: 0x3F4 */
  __IO uint32_t IPIDR;       /*!< DAC ID register,                                      Address offset: 0x3F8 */
  __IO uint32_t SIDR;        /*!< DAC magic ID register,                                Address offset: 0x3FC */
} DAC_TypeDef;

/**
  * @brief DFSDM module registers
  */
typedef struct
{
  __IO uint32_t FLTCR1;      /*!< DFSDM control register1,                          Address offset: 0x100 */
  __IO uint32_t FLTCR2;      /*!< DFSDM control register2,                          Address offset: 0x104 */
  __IO uint32_t FLTISR;      /*!< DFSDM interrupt and status register,              Address offset: 0x108 */
  __IO uint32_t FLTICR;      /*!< DFSDM interrupt flag clear register,              Address offset: 0x10C */
  __IO uint32_t FLTJCHGR;    /*!< DFSDM injected channel group selection register,  Address offset: 0x110 */
  __IO uint32_t FLTFCR;      /*!< DFSDM filter control register,                    Address offset: 0x114 */
  __IO uint32_t FLTJDATAR;   /*!< DFSDM data register for injected group,           Address offset: 0x118 */
  __IO uint32_t FLTRDATAR;   /*!< DFSDM data register for regular group,            Address offset: 0x11C */
  __IO uint32_t FLTAWHTR;    /*!< DFSDM analog watchdog high threshold register,    Address offset: 0x120 */
  __IO uint32_t FLTAWLTR;    /*!< DFSDM analog watchdog low threshold register,     Address offset: 0x124 */
  __IO uint32_t FLTAWSR;     /*!< DFSDM analog watchdog status register             Address offset: 0x128 */
  __IO uint32_t FLTAWCFR;    /*!< DFSDM analog watchdog clear flag register         Address offset: 0x12C */
  __IO uint32_t FLTEXMAX;    /*!< DFSDM extreme detector maximum register,          Address offset: 0x130 */
  __IO uint32_t FLTEXMIN;    /*!< DFSDM extreme detector minimum register           Address offset: 0x134 */
  __IO uint32_t FLTCNVTIMR;  /*!< DFSDM conversion timer,                           Address offset: 0x138 */
} DFSDM_Filter_TypeDef;

/**
  * @brief DFSDM channel configuration registers
  */
typedef struct
{
  __IO uint32_t CHCFGR1;     /*!< DFSDM channel configuration register1,            Address offset: 0x00 */
  __IO uint32_t CHCFGR2;     /*!< DFSDM channel configuration register2,            Address offset: 0x04 */
  __IO uint32_t CHAWSCDR;    /*!< DFSDM channel analog watchdog and
                                  short circuit detector register,                  Address offset: 0x08 */
  __IO uint32_t CHWDATAR;    /*!< DFSDM channel watchdog filter data register,      Address offset: 0x0C */
  __IO uint32_t CHDATINR;    /*!< DFSDM channel data input register,                Address offset: 0x10 */
  __IO uint32_t CHDLYR;      /*!< DFSDM channel delay register,                     Address offset: 0x14 */
} DFSDM_Channel_TypeDef;


/**
  * @brief DFSDM registers
  */
typedef struct
{
  uint32_t RESERVED[508];/*!< Reserved,                                       0x000 - 0x7F0 */
  __IO uint32_t HWCFGR;  /*!< DFSDM HW Configuration register ,       Address offset: 0x7F0 */
  __IO uint32_t VERR;    /*!< DFSDM Version register,                 Address offset: 0x7F4 */
  __IO uint32_t IPDR;    /*!< DFSDM Identification register,          Address offset: 0x7F8 */
  __IO uint32_t SIDR;    /*!< DFSDM Size Identification register,     Address offset: 0x7FC */
} DFSDM_TypeDef;


/**
  * @brief Debug MCU
  */

typedef struct
{
  __IO uint32_t IDCODE;        /*!< MCU device ID code,                         Address offset: 0x00 */
  __IO uint32_t CR;            /*!< Debug MCU configuration register,           Address offset: 0x04 */
  __IO uint32_t RESERVED4[9];  /*!< Reserved,                                   Address offset: 0x08 */
  __IO uint32_t APB4FZ1;       /*!< Debug MCU APB4FZ1 freeze register CPU1,     Address offset: 0x2C */
  __IO uint32_t APB4FZ2;       /*!< Debug MCU APB4FZ2 freeze register CPU2,     Address offset: 0x30 */
  __IO uint32_t APB1FZ1;       /*!< Debug MCU APB1FZ1 freeze register CPU1,     Address offset: 0x34 */
  __IO uint32_t APB1FZ2;       /*!< Debug MCU APB1FZ2 freeze register CPU2,     Address offset: 0x38 */
  __IO uint32_t APB2FZ1;       /*!< Debug MCU APB2FZ1 freeze register CPU1,     Address offset: 0x3C */
  __IO uint32_t APB2FZ2;       /*!< Debug MCU APB2FZ2 freeze register CPU2,     Address offset: 0x40 */
  __IO uint32_t APB3FZ1;       /*!< Debug MCU APB3FZ1 freeze register CPU1,     Address offset: 0x44 */
  __IO uint32_t APB3FZ2;       /*!< Debug MCU APB3FZ2 freeze register CPU2,     Address offset: 0x48 */
  __IO uint32_t APB5FZ1;       /*!< Debug MCU APB5FZ1 freeze register CPU1,     Address offset: 0x4C */
  __IO uint32_t APB5FZ2;       /*!< Debug MCU APB5FZ2 freeze register CPU2,     Address offset: 0x50 */
}DBGMCU_TypeDef;

/**
  * @brief DCMI
  */

typedef struct
{
  __IO uint32_t CR;       /*!< DCMI control register 1,                       Address offset: 0x000 */
  __IO uint32_t SR;       /*!< DCMI status register,                          Address offset: 0x004 */
  __IO uint32_t RISR;     /*!< DCMI raw interrupt status register,            Address offset: 0x008 */
  __IO uint32_t IER;      /*!< DCMI interrupt enable register,                Address offset: 0x00C */
  __IO uint32_t MISR;     /*!< DCMI masked interrupt status register,         Address offset: 0x010 */
  __IO uint32_t ICR;      /*!< DCMI interrupt clear register,                 Address offset: 0x014 */
  __IO uint32_t ESCR;     /*!< DCMI embedded synchronization code register,   Address offset: 0x018 */
  __IO uint32_t ESUR;     /*!< DCMI embedded synchronization unmask register, Address offset: 0x01C */
  __IO uint32_t CWSTRTR;  /*!< DCMI crop window start,                        Address offset: 0x020 */
  __IO uint32_t CWSIZER;  /*!< DCMI crop window size,                         Address offset: 0x024 */
  __IO uint32_t DR;       /*!< DCMI data register,                            Address offset: 0x028 */
  uint32_t RESERVED[242]; /*!< Reserved,                                              0x02C - 0x3F0 */
  __IO uint32_t VERR;     /*!< DCMI Version register,                         Address offset: 0x3F4 */
  __IO uint32_t IPDR;     /*!< DCMI Identification register,                  Address offset: 0x3F8 */
  __IO uint32_t SIDR;     /*!< DCMI Size Identification register,             Address offset: 0x3FC */
} DCMI_TypeDef;

/**
  * @brief DMA Controller
  */

typedef struct
{
  __IO uint32_t CR;     /*!< DMA stream x configuration register      */
  __IO uint32_t NDTR;   /*!< DMA stream x number of data register     */
  __IO uint32_t PAR;    /*!< DMA stream x peripheral address register */
  __IO uint32_t M0AR;   /*!< DMA stream x memory 0 address register   */
  __IO uint32_t M1AR;   /*!< DMA stream x memory 1 address register   */
  __IO uint32_t FCR;    /*!< DMA stream x FIFO control register       */
} DMA_Stream_TypeDef;

typedef struct
{
  __IO uint32_t LISR;   /*!< DMA low interrupt status register,      Address offset: 0x00 */
  __IO uint32_t HISR;   /*!< DMA high interrupt status register,     Address offset: 0x04 */
  __IO uint32_t LIFCR;  /*!< DMA low interrupt flag clear register,  Address offset: 0x08 */
  __IO uint32_t HIFCR;  /*!< DMA high interrupt flag clear register, Address offset: 0x0C */
  __IO uint32_t RESERVED[247];  /*!< Reserved,               Address offset: 0x10 - 0x3E8 */
  __IO uint32_t HWCFGR2; /*!< DMA HW Configuration register 2,      Address offset: 0x3EC */
  __IO uint32_t HWCFGR1; /*!< DMA HW Configuration register 1,      Address offset: 0x3F0 */
  __IO uint32_t VERR;    /*!< DMA Version register,                 Address offset: 0x3F4 */
  __IO uint32_t IPDR;    /*!< DMA Identification register,          Address offset: 0x3F8 */
  __IO uint32_t SIDR;    /*!< DMA Size Identification register,     Address offset: 0x3FC */
} DMA_TypeDef;

typedef struct
{
  __IO uint32_t  CCR;        /*!< DMA Multiplexer Channel x Control Register   */
}DMAMUX_Channel_TypeDef;

typedef struct
{
  __IO uint32_t  CSR;      /*!< DMA Channel Status Register     */
  __IO uint32_t  CFR;      /*!< DMA Channel Clear Flag Register */
}DMAMUX_ChannelStatus_TypeDef;

typedef struct
{
  __IO uint32_t  RGCR;        /*!< DMA Request Generator x Control Register   */
}DMAMUX_RequestGen_TypeDef;

typedef struct
{
  __IO uint32_t  RGSR;            /*!< DMAMUX Request Generator Status Register,           Address offset: 0x140 */
  __IO uint32_t  RGCFR;           /*!< DMAMUX Request Generator Clear Flag Register,       Address offset: 0x144 */
  uint32_t       RESERVED0[169];  /*!< Reserved, 0x144 -> 0x144                                                  */
  __IO uint32_t  HWCFGR2;         /*!< DMAMUX Configuration register 2,                    Address offset: 0x3EC */
  __IO uint32_t  HWCFGR1;         /*!< DMAMUX Configuration register 1,                    Address offset: 0x3F0 */
  __IO uint32_t  VERR;            /*!< DMAMUX Verion Register,                             Address offset: 0x3F4 */
  __IO uint32_t  IPDR;            /*!< DMAMUX Identification register,                     Address offset: 0x3F8 */
  __IO uint32_t  SIDR;            /*!< DMAMUX Size Identification register,                Address offset: 0x3FC */

}DMAMUX_RequestGenStatus_TypeDef;

/**
  * @brief MDMA Controller
  */
typedef struct
{
  __IO uint32_t  GISR0;   /*!< MDMA Global Interrupt/Status Register 0,          Address offset: 0x000 */
  uint32_t RESERVED1;      /*!< Reserved,                                                         0x004 */
//  __IO uint32_t  GISR1;   /*!< MDMA Global Interrupt/Status Register 1,          Address offset: 0x004 */
  __IO uint32_t  SGISR0;  /*!< MDMA Secure Global Interrupt/Status Register 0,   Address offset: 0x008 */
//  __IO uint32_t  SGISR1;  /*!< MDMA Secure Global Interrupt/Status Register 1,   Address offset: 0x00C */
  uint32_t RESERVED2[250]; /*!< Reserved,                                                  0x10 - 0x3F0 */
  __IO uint32_t  VERR;    /*!< MDMA Verion Register,                             Address offset: 0x3F4 */
  __IO uint32_t  IPDR;    /*!< MDMA Identification register,                     Address offset: 0x3F8 */
  __IO uint32_t  SIDR;    /*!< MDMA Size Identification register,                Address offset: 0x3FC */
}MDMA_TypeDef;

typedef struct
{
  __IO uint32_t  CISR;      /*!< MDMA channel x interrupt/status register,             Address offset: 0x40 */
  __IO uint32_t  CIFCR;     /*!< MDMA channel x interrupt flag clear register,         Address offset: 0x44 */
  __IO uint32_t  CESR;      /*!< MDMA Channel x error status register,                 Address offset: 0x48 */
  __IO uint32_t  CCR;       /*!< MDMA channel x control register,                      Address offset: 0x4C */
  __IO uint32_t  CTCR;      /*!< MDMA channel x Transfer Configuration register,       Address offset: 0x50 */
  __IO uint32_t  CBNDTR;    /*!< MDMA Channel x block number of data register,         Address offset: 0x54 */
  __IO uint32_t  CSAR;      /*!< MDMA channel x source address register,               Address offset: 0x58 */
  __IO uint32_t  CDAR;      /*!< MDMA channel x destination address register,          Address offset: 0x5C */
  __IO uint32_t  CBRUR;     /*!< MDMA channel x Block Repeat address Update register,  Address offset: 0x60 */
  __IO uint32_t  CLAR;      /*!< MDMA channel x Link Address register,                 Address offset: 0x64 */
  __IO uint32_t  CTBR;      /*!< MDMA channel x Trigger and Bus selection Register,    Address offset: 0x68 */
  uint32_t       RESERVED0; /*!< Reserved, 0x68                                                             */
 __IO uint32_t    CMAR;      /*!< MDMA channel x Mask address register,                Address offset: 0x70 */
 __IO uint32_t   CMDR;       /*!< MDMA channel x Mask Data register,                   Address offset: 0x74 */
}MDMA_Channel_TypeDef;


/**
  * @brief Ethernet MAC
  */
typedef struct
{
  __IO uint32_t MACCR;
  __IO uint32_t MACECR;
  __IO uint32_t MACPFR;
  __IO uint32_t MACWTR;
  __IO uint32_t MACHTHR;
  __IO uint32_t MACHTLR;
  uint32_t      RESERVED1[14];
  __IO uint32_t MACVTR;
  uint32_t      RESERVED2;
  __IO uint32_t MACVHTR;
  uint32_t      RESERVED3;
  __IO uint32_t MACVIR;
  __IO uint32_t MACIVIR;
  uint32_t      RESERVED4[2];
  __IO uint32_t MACTFCR;
  uint32_t      RESERVED5[7];
  __IO uint32_t MACRFCR;
  uint32_t      RESERVED6[3];
  __IO uint32_t MACRC0R;
  uint32_t      RESERVEDX[3];
  __IO uint32_t MACISR;
  __IO uint32_t MACIER;
  __IO uint32_t MACRTSR;
  uint32_t      RESERVED7;
  __IO uint32_t MACPCSR;
  __IO uint32_t MACRWKPFR;
  uint32_t      RESERVED8[2];
  __IO uint32_t MACLPICSR;
  __IO uint32_t MACLPITCR;
  __IO uint32_t MACLPIETR;
  __IO uint32_t MAC1USTCR;
  uint32_t      RESERVED9[12];
  __IO uint32_t MACVR;
  __IO uint32_t MACDR;
  uint32_t      RESERVED10;
  __IO uint32_t MACHWF0R;
  __IO uint32_t MACHWF1R;
  __IO uint32_t MACHWF2R;
  uint32_t      RESERVED11[54];
  __IO uint32_t MACMDIOAR;
  __IO uint32_t MACMDIODR;
  uint32_t      RESERVED12[2];
  __IO uint32_t MACARPAR;
  uint32_t      RESERVED13[59];
  __IO uint32_t MACA0HR;
  __IO uint32_t MACA0LR;
  __IO uint32_t MACA1HR;
  __IO uint32_t MACA1LR;
  __IO uint32_t MACA2HR;
  __IO uint32_t MACA2LR;
  __IO uint32_t MACA3HR;
  __IO uint32_t MACA3LR;
  uint32_t      RESERVED14[248];
  __IO uint32_t MMCCR;
  __IO uint32_t MMCRIR;
  __IO uint32_t MMCTIR;
  __IO uint32_t MMCRIMR;
  __IO uint32_t MMCTIMR;
  uint32_t      RESERVED15[14];
  __IO uint32_t MMCTSCGPR;
  __IO uint32_t MMCTMCGPR;
  int32_t       RESERVED16[5];
  __IO uint32_t MMCTPCGR;
  uint32_t      RESERVED17[10];
  __IO uint32_t MMCRCRCEPR;
  __IO uint32_t MMCRAEPR;
  uint32_t      RESERVED18[10];
  __IO uint32_t MMCRUPGR;
  uint32_t      RESERVED19[9];
  __IO uint32_t MMCTLPIMSTR;
  __IO uint32_t MMCTLPITCR;
  __IO uint32_t MMCRLPIMSTR;
  __IO uint32_t MMCRLPITCR;
  uint32_t      RESERVED20[65];
  __IO uint32_t MACL3L4C0R;
  __IO uint32_t MACL4A0R;
  uint32_t      RESERVED21[2];
  __IO uint32_t MACL3A0R0R;
  __IO uint32_t MACL3A1R0R;
  __IO uint32_t MACL3A2R0R;
  __IO uint32_t MACL3A3R0R;
  uint32_t      RESERVED22[4];
  __IO uint32_t MACL3L4C1R;
  __IO uint32_t MACL4A1R;
  uint32_t      RESERVED23[2];
  __IO uint32_t MACL3A0R1R;
  __IO uint32_t MACL3A1R1R;
  __IO uint32_t MACL3A2R1R;
  __IO uint32_t MACL3A3R1R;
  uint32_t      RESERVED24[108];
  __IO uint32_t MACTSCR;
  __IO uint32_t MACSSIR;
  __IO uint32_t MACSTSR;
  __IO uint32_t MACSTNR;
  __IO uint32_t MACSTSUR;
  __IO uint32_t MACSTNUR;
  __IO uint32_t MACTSAR;
  uint32_t      RESERVED25;
  __IO uint32_t MACTSSR;
  uint32_t      RESERVED26[3];
  __IO uint32_t MACTTSSNR;
  __IO uint32_t MACTTSSSR;
  uint32_t      RESERVED27[2];
  __IO uint32_t MACACR;
  uint32_t      RESERVED28;
  __IO uint32_t MACATSNR;
  __IO uint32_t MACATSSR;
  __IO uint32_t MACTSIACR;
  __IO uint32_t MACTSEACR;
  __IO uint32_t MACTSICNR;
  __IO uint32_t MACTSECNR;
  uint32_t      RESERVED29[4];
  __IO uint32_t MACPPSCR;
  uint32_t      RESERVED30[3];
  __IO uint32_t MACPPSTTSR;
  __IO uint32_t MACPPSTTNR;
  __IO uint32_t MACPPSIR;
  __IO uint32_t MACPPSWR;
  uint32_t      RESERVED31[12];
  __IO uint32_t MACPOCR;
  __IO uint32_t MACSPI0R;
  __IO uint32_t MACSPI1R;
  __IO uint32_t MACSPI2R;
  __IO uint32_t MACLMIR;
  uint32_t      RESERVED32[11];
  __IO uint32_t MTLOMR;
  uint32_t      RESERVED33[7];
  __IO uint32_t MTLISR;
  uint32_t      RESERVED34[55];
  __IO uint32_t MTLTQOMR;
  __IO uint32_t MTLTQUR;
  __IO uint32_t MTLTQDR;
  uint32_t      RESERVED35[8];
  __IO uint32_t MTLQICSR;
  __IO uint32_t MTLRQOMR;
  __IO uint32_t MTLRQMPOCR;
  __IO uint32_t MTLRQDR;
  uint32_t      RESERVED36[177];
  __IO uint32_t DMAMR;
  __IO uint32_t DMASBMR;
  __IO uint32_t DMAISR;
  __IO uint32_t DMADSR;
  uint32_t      RESERVED37[60];
  __IO uint32_t DMACCR;
  __IO uint32_t DMACTCR;
  __IO uint32_t DMACRCR;
  uint32_t      RESERVED38[2];
  __IO uint32_t DMACTDLAR;
  uint32_t      RESERVED39;
  __IO uint32_t DMACRDLAR;
  __IO uint32_t DMACTDTPR;
  uint32_t      RESERVED40;
  __IO uint32_t DMACRDTPR;
  __IO uint32_t DMACTDRLR;
  __IO uint32_t DMACRDRLR;
  __IO uint32_t DMACIER;
  __IO uint32_t DMACRIWTR;
  __IO uint32_t DMACSFCSR;
  uint32_t      RESERVED41;
  __IO uint32_t DMACCATDR;
  uint32_t      RESERVED42;
  __IO uint32_t DMACCARDR;
  uint32_t      RESERVED43;
  __IO uint32_t DMACCATBR;
  uint32_t      RESERVED44;
  __IO uint32_t DMACCARBR;
  __IO uint32_t DMACSR;
  uint32_t      RESERVED45[2];
  __IO uint32_t DMACMFCR;
}ETH_TypeDef;

/**
  * @brief External Interrupt/Event Controller
  */

typedef struct
{
  __IO uint32_t RTSR1;               /*!< EXTI Rising trigger selection register,                   Address offset: 0x00 */
  __IO uint32_t FTSR1;               /*!< EXTI Falling trigger selection register,                  Address offset: 0x04 */
  __IO uint32_t SWIER1;              /*!< EXTI Software interrupt event register,                   Address offset: 0x08 */
  __IO uint32_t RPR1;                /*!< EXTI Rising Edge Pending mask register,                   Address offset: 0x0C */
  __IO uint32_t FPR1;                /*!< EXTI Falling Edge Pending mask register,                  Address offset: 0x10 */
  __IO uint32_t TZENR1;              /*!< EXTI Trust Zone enable register,                          Address offset: 0x14 */
  uint32_t      RESERVED1[2];        /*!< Reserved, offset 0x18 -> 0x20                                                  */
  __IO uint32_t RTSR2;               /*!< EXTI Rising trigger selection register,                   Address offset: 0x20 */
  __IO uint32_t FTSR2;               /*!< EXTI Falling trigger selection register,                  Address offset: 0x24 */
  __IO uint32_t SWIER2;              /*!< EXTI Software interrupt event register,                   Address offset: 0x28 */
  __IO uint32_t RPR2;                /*!< EXTI Rising Edge Pending mask register,                   Address offset: 0x2C */
  __IO uint32_t FPR2;                /*!< EXTI Falling Edge Pending mask register,                  Address offset: 0x30 */
  __IO uint32_t TZENR2;              /*!< EXTI Trust Zone enable register,                          Address offset: 0x34 */
  uint32_t      RESERVED2[2];        /*!< Reserved, offset 0x38 -> 0x40                                                  */
  __IO uint32_t RTSR3;               /*!< EXTI Rising trigger selection register,                   Address offset: 0x40 */
  __IO uint32_t FTSR3;               /*!< EXTI Falling trigger selection register,                  Address offset: 0x44 */
  __IO uint32_t SWIER3;              /*!< EXTI Software interrupt event register,                   Address offset: 0x48 */
  __IO uint32_t RPR3;                /*!< EXTI Rising Edge Pending mask register,                   Address offset: 0x4C */
  __IO uint32_t FPR3;                /*!< EXTI Falling Edge Pending mask register,                  Address offset: 0x50 */
  __IO uint32_t TZENR3;              /*!< EXTI Trust Zone enable register,                          Address offset: 0x54 */
  uint32_t      RESERVED3[2];        /*!< Reserved, offset 0x58 -> 0x5C                                                  */
  __IO uint32_t EXTICR[4];           /*!< EXTI Configuration Register mask register,                Address offset: 0x60 */
  uint32_t      RESERVED4[4];        /*!< Reserved, offset 0x70 -> 0x7C                                                  */
  __IO uint32_t C1IMR1;              /*!< EXTI wakeup with interrupt mask register for cpu1 [31:0], Address offset: 0x80 */
  __IO uint32_t C1EMR1;              /*!< EXTI wakeup with event mask register for cpu1 [31:0],     Address offset: 0x84 */
  __IO uint32_t RESERVED5[2];        /*!< Reserved,                                                 Address offset: 0x88 - 0x8C */
  __IO uint32_t C1IMR2;              /*!< EXTI wakeup with interrupt mask register for cpu1 [31:0], Address offset: 0x90 */
  __IO uint32_t C1EMR2;              /*!< EXTI wakeup with event mask register for cpu1 [31:0],     Address offset: 0x94 */
  __IO uint32_t RESERVED6[2];        /*!< Reserved,                                                 Address offset: 0x98 - 0x9C */
  __IO uint32_t C1IMR3;              /*!< EXTI wakeup with interrupt mask register for cpu1 [31:0], Address offset: 0xA0 */
  __IO uint32_t C1EMR3;              /*!< EXTI wakeup with event mask register for cpu1 [31:0],     Address offset: 0xA4 */
  __IO uint32_t RESERVED7[6];        /*!< Reserved,                                                 Address offset: 0xA8 - 0xBC */
  __IO uint32_t C2IMR1;              /*!< EXTI wakeup with interrupt mask register for cpu2 [31:0], Address offset: 0xC0 */
  __IO uint32_t C2EMR1;              /*!< EXTI wakeup with event mask register for cpu2 [31:0],     Address offset: 0xC4 */
  __IO uint32_t RESERVED8[2];        /*!< Reserved,                                                 Address offset: 0xC8 - 0xCC */
  __IO uint32_t C2IMR2;              /*!< EXTI wakeup with interrupt mask register for cpu2 [31:0], Address offset: 0xD0 */
  __IO uint32_t C2EMR2;              /*!< EXTI wakeup with event mask register for cpu2 [31:0],     Address offset: 0xD4 */
  __IO uint32_t RESERVED9[2];        /*!< Reserved,                                                 Address offset: 0xD8 - 0xDC */
  __IO uint32_t C2IMR3;              /*!< EXTI wakeup with interrupt mask register for cpu2 [31:0], Address offset: 0xE0 */
  __IO uint32_t C2EMR3;              /*!< EXTI wakeup with event mask register for cpu2 [31:0],     Address offset: 0xE4 */
  uint32_t      RESERVED10[182];     /*!< Reserved, offset 0xE8 -> 0x3BC                                                 */
  __IO uint32_t HWCFGR13;            /*!< EXTI HW Configuration Register 13,                        Address offset: 0x3C0 */
  __IO uint32_t HWCFGR12;            /*!< EXTI HW Configuration Register 12,                        Address offset: 0x3C4 */
  __IO uint32_t HWCFGR11;            /*!< EXTI HW Configuration Register 11,                        Address offset: 0x3C8 */
  __IO uint32_t HWCFGR10;            /*!< EXTI HW Configuration Register 10,                        Address offset: 0x3CC */
  __IO uint32_t HWCFGR9;             /*!< EXTI HW Configuration Register 9,                         Address offset: 0x3D0 */
  __IO uint32_t HWCFGR8;             /*!< EXTI HW Configuration Register 8,                         Address offset: 0x3D4 */
  __IO uint32_t HWCFGR7;             /*!< EXTI HW Configuration Register 7,                         Address offset: 0x3D8 */
  __IO uint32_t HWCFGR6;             /*!< EXTI HW Configuration Register 6,                         Address offset: 0x3DC */
  __IO uint32_t HWCFGR5;             /*!< EXTI HW Configuration Register 5,                         Address offset: 0x3E0 */
  __IO uint32_t HWCFGR4;             /*!< EXTI HW Configuration Register 4,                         Address offset: 0x3E4 */
  __IO uint32_t HWCFGR3;             /*!< EXTI HW Configuration Register 3,                         Address offset: 0x3E8 */
  __IO uint32_t HWCFGR2;             /*!< EXTI HW Configuration Register 2,                         Address offset: 0x3EC */
  __IO uint32_t HWCFGR1;             /*!< EXTI HW Configuration Register 1,                         Address offset: 0x3F0 */
  __IO uint32_t VERR;                /*!< EXTI Version Register ,                                   Address offset: 0x3F4 */
  __IO uint32_t IPIDR;               /*!< EXTI Identification Register ,                            Address offset: 0x3F8 */
  __IO uint32_t SIDR;                /*!< EXTI Size ID Register ,                                   Address offset: 0x3FC */

}EXTI_TypeDef;

typedef struct
{
  __IO uint32_t IMR1;                /*!< EXTI Interrupt mask register,                Address offset: 0x00 */
  __IO uint32_t EMR1;                /*!< EXTI Event mask register,                    Address offset: 0x04 */
  uint32_t      RESERVED1[2];        /*!< Reserved, offset 0x08 -> 0x10                                     */
  __IO uint32_t IMR2;                /*!< EXTI Interrupt mask register,                Address offset: 0x10 */
  __IO uint32_t EMR2;                /*!< EXTI Event mask register,                    Address offset: 0x14 */
  uint32_t      RESERVED2[2];        /*!< Reserved, offset 0x18 -> 0x20                                     */
  __IO uint32_t IMR3;                /*!< EXTI Interrupt mask register,                Address offset: 0x20 */
  __IO uint32_t EMR3;                /*!< EXTI Event mask register,                    Address offset: 0x24 */
  uint32_t      RESERVED3[6];        /*!< Reserved, offset 0x28 -> 0x40                                     */
}EXTI_Core_TypeDef;


/**
  * @brief Flexible Memory Controller
  */

typedef struct
{
  __IO uint32_t BTCR[8];    /*!< NOR/PSRAM chip-select control register(BCR) and chip-select timing register(BTR), Address offset: 0x00-1C */
} FMC_Bank1_TypeDef;

/**
  * @brief Flexible Memory Controller Bank1E
  */

typedef struct
{
  __IO uint32_t BWTR[7];    /*!< NOR/PSRAM write timing registers, Address offset: 0x104-0x11C */
} FMC_Bank1E_TypeDef;

/**
  * @brief Flexible Memory Controller Bank2
  */

typedef struct
{
  __IO uint32_t PCR2;       /*!< NAND Flash control register 2,                       Address offset: 0x60 */
  __IO uint32_t SR2;        /*!< NAND Flash FIFO status and interrupt register 2,     Address offset: 0x64 */
  __IO uint32_t PMEM2;      /*!< NAND Flash Common memory space timing register 2,    Address offset: 0x68 */
  __IO uint32_t PATT2;      /*!< NAND Flash Attribute memory space timing register 2, Address offset: 0x6C */
  uint32_t      RESERVED0;  /*!< Reserved, 0x70                                                            */
  __IO uint32_t ECCR2;      /*!< NAND Flash ECC result registers 2,                   Address offset: 0x74 */
} FMC_Bank2_TypeDef;

/**
  * @brief Flexible Memory Controller Bank3
  */

typedef struct
{
  __IO uint32_t PCR;         /*!< NAND Flash control register 3,                       Address offset: 0x80 */
  __IO uint32_t SR;          /*!< NAND Flash FIFO status and interrupt register 3,     Address offset: 0x84 */
  __IO uint32_t PMEM;        /*!< NAND Flash Common memory space timing register 3,    Address offset: 0x88 */
  __IO uint32_t PATT;        /*!< NAND Flash Attribute memory space timing register 3, Address offset: 0x8C */
  __IO uint32_t HPR;         /*!< NAND Flash Hamming Parity result registers 3,        Address offset: 0x90 */
  __IO uint32_t HECCR;       /*!< NAND Flash Hamming ECC result registers 3,           Address offset: 0x94 */
  uint32_t RESERVED[110];    /*!< Reserved, 0x94->0x250 */
  __IO uint32_t BCHIER;      /*!< BCH Interrupt Enable Register,                       Address offset: 0x250 */
  __IO uint32_t BCHISR;      /*!< BCH Interrupt Status Register,                       Address offset: 0x254 */
  __IO uint32_t BCHICR;      /*!< BCH Interrupt Clear Register,                        Address offset: 0x258 */
  uint32_t RESERVED1;        /*!< Reserved, 0x25C */
  __IO uint32_t BCHPBR1;     /*!< BCH Parity Bits Register 1,                          Address offset: 0x260 */
  __IO uint32_t BCHPBR2;     /*!< BCH Parity Bits Register 2,                          Address offset: 0x264 */
  __IO uint32_t BCHPBR3;     /*!< BCH Parity Bits Register 3,                          Address offset: 0x268 */
  __IO uint32_t BCHPBR4;     /*!< BCH Parity Bits Register 4,                          Address offset: 0x26C */
  uint32_t RESERVED2[3];        /*!< Reserved, 0x25C */
  __IO uint32_t BCHDSR0;     /*!< BCH Decoder Status Register 0,                       Address offset: 0x27C */
  __IO uint32_t BCHDSR1;     /*!< BCH Decoder Status Register 1,                       Address offset: 0x280 */
  __IO uint32_t BCHDSR2;     /*!< BCH Decoder Status Register 2,                       Address offset: 0x284 */
  __IO uint32_t BCHDSR3;     /*!< BCH Decoder Status Register 3,                       Address offset: 0x288 */
  __IO uint32_t BCHDSR4;     /*!< BCH Decoder Status Register 4,                       Address offset: 0x28C */
  uint32_t RESERVED3[87];    /*!< Reserved, 0x28C->0x3EC */
  __IO uint32_t HWCFGR2;     /*!< FMC HW Configuration register 2,                     Address offset: 0x3EC */
  __IO uint32_t HWCFGR1;     /*!< FMC HW Configuration register 1,                     Address offset: 0x3F0 */
  __IO uint32_t VERR;        /*!< FMC Version register ,                               Address offset: 0x3F4 */
  __IO uint32_t IDR;         /*!< FMC Identification register ,                        Address offset: 0x3F8 */
  __IO uint32_t SIDR;        /*!< FMC Size ID register ,                               Address offset: 0x3FC */
} FMC_Bank3_TypeDef;

/**
  * @brief Flexible Memory Controller Bank5 and 6
  */


typedef struct
{
  __IO uint32_t SDCR[2];        /*!< SDRAM Control registers ,      Address offset: 0x140-0x144  */
  __IO uint32_t SDTR[2];        /*!< SDRAM Timing registers ,       Address offset: 0x148-0x14C  */
  __IO uint32_t SDCMR;       /*!< SDRAM Command Mode register,    Address offset: 0x150  */
  __IO uint32_t SDRTR;       /*!< SDRAM Refresh Timer register,   Address offset: 0x154  */
  __IO uint32_t SDSR;        /*!< SDRAM Status register,          Address offset: 0x158  */
} FMC_Bank5_6_TypeDef;


/**
  * @brief General Purpose I/O
  */

typedef struct
{
  __IO uint32_t MODER;    /*!< GPIO port mode register,               Address offset: 0x00      */
  __IO uint32_t OTYPER;   /*!< GPIO port output type register,        Address offset: 0x04      */
  __IO uint32_t OSPEEDR;  /*!< GPIO port output speed register,       Address offset: 0x08      */
  __IO uint32_t PUPDR;    /*!< GPIO port pull-up/pull-down register,  Address offset: 0x0C      */
  __IO uint32_t IDR;      /*!< GPIO port input data register,         Address offset: 0x10      */
  __IO uint32_t ODR;      /*!< GPIO port output data register,        Address offset: 0x14      */
  __IO uint32_t BSRR;     /*!< GPIO port bit set/reset register,      Address offset: 0x18      */
  __IO uint32_t LCKR;     /*!< GPIO port configuration lock register, Address offset: 0x1C      */
  __IO uint32_t AFR[2];   /*!< GPIO alternate function registers,     Address offset: 0x20-0x24 */
  __IO uint32_t BRR;      /*!< GPIO Bit Reset register,               Address offset: 0x28      */
  uint32_t RESERVED0[2];  /*!< Reserved,                              Address offset: 0x28-0x2C */
  __IO uint32_t SECR;     /*!< GPIO security register,                Address offset: 0x30      */
  uint32_t RESERVED1[240];/*!< Reserved, 0x24->0x3F4 */
  __IO uint32_t VERR;     /*!< GPIO version register,                 Address offset: 0x3F4     */
  __IO uint32_t IPIDR;    /*!< GPIO version register,                 Address offset: 0x3F8     */
  __IO uint32_t SIDR;     /*!< GPIO version register,                 Address offset: 0x3FC     */
} GPIO_TypeDef;


/**
  * @brief System configuration controller
  */

typedef struct
{
  __IO uint32_t BOOTR;          /*!< SYSCFG Boot pin control register,                                Address offset: 0x00        */
  __IO uint32_t PMCSETR;        /*!< SYSCFG Peripheral Mode configuration set register,               Address offset: 0x04        */
  __IO uint32_t RESERVED1[4];   /*!< Reserved,                                                        Address offset: 0x08-0x18   */
  __IO uint32_t IOCTRLSETR;     /*!< SYSCFG ioctl set register,                                       Address offset: 0x18        */
  __IO uint32_t ICNR;           /*!< SYSCFG interconnect control register,                            Address offset: 0x1C        */
  __IO uint32_t CMPCR;          /*!< SYSCFG compensation cell control register,                       Address offset: 0x20        */
  __IO uint32_t CMPENSETR;      /*!< SYSCFG compensation cell enable set register,                    Address offset: 0x24        */
  __IO uint32_t CMPENCLRR;      /*!< SYSCFG compensation cell enable clear register,                  Address offset: 0x28        */
  __IO uint32_t CBR;            /*!< SYSCFG control timer break register,                             Address offset: 0x2C        */
  __IO uint32_t RESERVED2[5];   /*!< Reserved,                                                        Address offset: 0x30-0x40   */
  __IO uint32_t PMCCLRR;        /*!< SYSCFG Peripheral Mode configuration clear register,             Address offset: 0x44        */
  __IO uint32_t RESERVED3[4];   /*!< Reserved,                                                        Address offset: 0x48-0x54   */
  __IO uint32_t IOCTRLCLRR;     /*!< SYSCFG ioctl clear register,                                     Address offset: 0x58        */
       uint32_t RESERVED4[230]; /*!< Reserved,                                                        Address offset: 0x5C->0x3F4 */
  __IO uint32_t VERR;           /*!< SYSCFG version register,                                         Address offset: 0x3F4       */
  __IO uint32_t IPIDR;          /*!< SYSCFG ID register,                                              Address offset: 0x3F8       */
  __IO uint32_t SIDR;           /*!< SYSCFG magic ID register,                                        Address offset: 0x3FC       */
} SYSCFG_TypeDef;


/**
  * @briefVoltage reference buffer
  */
typedef struct
{
  __IO uint32_t CSR;                /*VREF control and status register                      Address offset: 0x00      */
  __IO uint32_t CCR;                /*VREF control and status register                      Address offset: 0x04      */
} VREF_TypeDef;


/**
  * @brief Inter-integrated Circuit Interface
  */

typedef struct
{
  __IO uint32_t CR1;      /*!< I2C Control register 1,            Address offset: 0x00 */
  __IO uint32_t CR2;      /*!< I2C Control register 2,            Address offset: 0x04 */
  __IO uint32_t OAR1;     /*!< I2C Own address 1 register,        Address offset: 0x08 */
  __IO uint32_t OAR2;     /*!< I2C Own address 2 register,        Address offset: 0x0C */
  __IO uint32_t TIMINGR;  /*!< I2C Timing register,               Address offset: 0x10 */
  __IO uint32_t TIMEOUTR; /*!< I2C Timeout register,              Address offset: 0x14 */
  __IO uint32_t ISR;      /*!< I2C Interrupt and status register, Address offset: 0x18 */
  __IO uint32_t ICR;      /*!< I2C Interrupt clear register,      Address offset: 0x1C */
  __IO uint32_t PECR;     /*!< I2C PEC register,                  Address offset: 0x20 */
  __IO uint32_t RXDR;     /*!< I2C Receive data register,         Address offset: 0x24 */
  __IO uint32_t TXDR;     /*!< I2C Transmit data register,        Address offset: 0x28 */
  uint32_t RESERVED[241]; /*!< Reserved, 0x2C->0x3F0 */
  __IO uint32_t HWCFGR;   /*!< I2C hardware configuration register,  Address offset: 0x3F0 */
  __IO uint32_t VERR;     /*!< I2C version register,                 Address offset: 0x3F4 */
  __IO uint32_t IPIDR;    /*!< I2C identification register,          Address offset: 0x3F8 */
  __IO uint32_t SIDR;     /*!< I2C size identification register,     Address offset: 0x3FC */
} I2C_TypeDef;

/**
  * @brief Independent WATCHDOG
  */

typedef struct
{
  __IO uint32_t KR;   /*!< IWDG Key register,                          Address offset: 0x00 */
  __IO uint32_t PR;   /*!< IWDG Prescaler register,                    Address offset: 0x04 */
  __IO uint32_t RLR;  /*!< IWDG Reload register,                       Address offset: 0x08 */
  __IO uint32_t SR;   /*!< IWDG Status register,                       Address offset: 0x0C */
  __IO uint32_t WINR; /*!< IWDG Window register,                       Address offset: 0x10 */
  __IO uint32_t EWCR; /*!< IWDG Window register,                       Address offset: 0x14 */
  uint32_t RESERVED[246]; /*!< Reserved,                                        0x18->0x3EC */
  __IO uint32_t HWCFGR;   /*!< IWDG hardware configuration register,  Address offset: 0x3F0 */
  __IO uint32_t VERR;     /*!< IWDG version register,                 Address offset: 0x3F4 */
  __IO uint32_t IDR;    /*!< IWDG identification register,            Address offset: 0x3F8 */
  __IO uint32_t SIDR;     /*!< IWDG size identification register,     Address offset: 0x3FC */
} IWDG_TypeDef;


/**
  * @brief JPEG Codec
  */
typedef struct
{
  __IO uint32_t CONFR0;          /*!< JPEG Codec Control Register (JPEG_CONFR0),        Address offset: 00h       */
  __IO uint32_t CONFR1;          /*!< JPEG Codec Control Register (JPEG_CONFR1),        Address offset: 04h       */
  __IO uint32_t CONFR2;          /*!< JPEG Codec Control Register (JPEG_CONFR2),        Address offset: 08h       */
  __IO uint32_t CONFR3;          /*!< JPEG Codec Control Register (JPEG_CONFR3),        Address offset: 0Ch       */
  __IO uint32_t CONFR4;          /*!< JPEG Codec Control Register (JPEG_CONFR4),        Address offset: 10h       */
  __IO uint32_t CONFR5;          /*!< JPEG Codec Control Register (JPEG_CONFR5),        Address offset: 14h       */
  __IO uint32_t CONFR6;          /*!< JPEG Codec Control Register (JPEG_CONFR6),        Address offset: 18h       */
  __IO uint32_t CONFR7;          /*!< JPEG Codec Control Register (JPEG_CONFR7),        Address offset: 1Ch       */
  uint32_t  Reserved20[4];       /* Reserved                                            Address offset: 20h-2Ch   */
  __IO uint32_t CR;              /*!< JPEG Control Register (JPEG_CR),                  Address offset: 30h       */
  __IO uint32_t SR;              /*!< JPEG Status Register (JPEG_SR),                   Address offset: 34h       */
  __IO uint32_t CFR;             /*!< JPEG Clear Flag Register (JPEG_CFR),              Address offset: 38h       */
  uint32_t  Reserved3c;          /* Reserved                                            Address offset: 3Ch       */
  __IO uint32_t DIR;             /*!< JPEG Data Input Register (JPEG_DIR),              Address offset: 40h       */
  __IO uint32_t DOR;             /*!< JPEG Data Output Register (JPEG_DOR),             Address offset: 44h       */
  uint32_t  Reserved48[2];       /* Reserved                                            Address offset: 48h-4Ch   */
  __IO uint32_t QMEM0[16];       /*!< JPEG quantization tables 0,                       Address offset: 50h-8Ch   */
  __IO uint32_t QMEM1[16];       /*!< JPEG quantization tables 1,                       Address offset: 90h-CCh   */
  __IO uint32_t QMEM2[16];       /*!< JPEG quantization tables 2,                       Address offset: D0h-10Ch  */
  __IO uint32_t QMEM3[16];       /*!< JPEG quantization tables 3,                       Address offset: 110h-14Ch */
  __IO uint32_t HUFFMIN[16];     /*!< JPEG HuffMin tables,                              Address offset: 150h-18Ch */
  __IO uint32_t HUFFBASE[32];    /*!< JPEG HuffSymb tables,                             Address offset: 190h-20Ch */
  __IO uint32_t HUFFSYMB[84];    /*!< JPEG HUFFSYMB tables,                             Address offset: 210h-35Ch */
  __IO uint32_t DHTMEM[103];     /*!< JPEG DHTMem tables,                               Address offset: 360h-4F8h */
  uint32_t  Reserved4FC;         /* Reserved                                            Address offset: 4FCh      */
  __IO uint32_t HUFFENC_AC0[88]; /*!< JPEG encodor, AC Huffman table 0,                 Address offset: 500h-65Ch */
  __IO uint32_t HUFFENC_AC1[88]; /*!< JPEG encodor, AC Huffman table 1,                 Address offset: 660h-7BCh */
  __IO uint32_t HUFFENC_DC0[8];  /*!< JPEG encodor, DC Huffman table 0,                 Address offset: 7C0h-7DCh */
  __IO uint32_t HUFFENC_DC1[8];  /*!< JPEG encodor, DC Huffman table 1,                 Address offset: 7E0h-7FCh */

} JPEG_TypeDef;


/**
  * @brief LCD
  */

typedef struct
{
  __IO uint32_t CR;        /*!< LCD control register,              Address offset: 0x00 */
  __IO uint32_t FCR;       /*!< LCD frame control register,        Address offset: 0x04 */
  __IO uint32_t SR;        /*!< LCD status register,               Address offset: 0x08 */
  __IO uint32_t CLR;       /*!< LCD clear register,                Address offset: 0x0C */
  uint32_t RESERVED;       /*!< Reserved,                          Address offset: 0x10 */
  __IO uint32_t RAM[16];   /*!< LCD display memory,           Address offset: 0x14-0x50 */
} LCD_TypeDef;

/**
  * @brief LCD-TFT Display Controller
  */

typedef struct
{
  uint32_t      RESERVED0[2];  /*!< Reserved, 0x00-0x04 */
  __IO uint32_t SSCR;          /*!< LTDC Synchronization Size Configuration Register,    Address offset: 0x08 */
  __IO uint32_t BPCR;          /*!< LTDC Back Porch Configuration Register,              Address offset: 0x0C */
  __IO uint32_t AWCR;          /*!< LTDC Active Width Configuration Register,            Address offset: 0x10 */
  __IO uint32_t TWCR;          /*!< LTDC Total Width Configuration Register,             Address offset: 0x14 */
  __IO uint32_t GCR;           /*!< LTDC Global Control Register,                        Address offset: 0x18 */
  uint32_t      RESERVED1[2];  /*!< Reserved, 0x1C-0x20 */
  __IO uint32_t SRCR;          /*!< LTDC Shadow Reload Configuration Register,           Address offset: 0x24 */
  uint32_t      RESERVED2[1];  /*!< Reserved, 0x28 */
  __IO uint32_t BCCR;          /*!< LTDC Background Color Configuration Register,        Address offset: 0x2C */
  uint32_t      RESERVED3[1];  /*!< Reserved, 0x30 */
  __IO uint32_t IER;           /*!< LTDC Interrupt Enable Register,                      Address offset: 0x34 */
  __IO uint32_t ISR;           /*!< LTDC Interrupt Status Register,                      Address offset: 0x38 */
  __IO uint32_t ICR;           /*!< LTDC Interrupt Clear Register,                       Address offset: 0x3C */
  __IO uint32_t LIPCR;         /*!< LTDC Line Interrupt Position Configuration Register, Address offset: 0x40 */
  __IO uint32_t CPSR;          /*!< LTDC Current Position Status Register,               Address offset: 0x44 */
  __IO uint32_t CDSR;         /*!< LTDC Current Display Status Register,                       Address offset: 0x48 */
} LTDC_TypeDef;

/**
  * @brief LCD-TFT Display layer x Controller
  */

typedef struct
{
  __IO uint32_t CR;            /*!< LTDC Layerx Control Register                                  Address offset: 0x84 */
  __IO uint32_t WHPCR;         /*!< LTDC Layerx Window Horizontal Position Configuration Register Address offset: 0x88 */
  __IO uint32_t WVPCR;         /*!< LTDC Layerx Window Vertical Position Configuration Register   Address offset: 0x8C */
  __IO uint32_t CKCR;          /*!< LTDC Layerx Color Keying Configuration Register               Address offset: 0x90 */
  __IO uint32_t PFCR;          /*!< LTDC Layerx Pixel Format Configuration Register               Address offset: 0x94 */
  __IO uint32_t CACR;          /*!< LTDC Layerx Constant Alpha Configuration Register             Address offset: 0x98 */
  __IO uint32_t DCCR;          /*!< LTDC Layerx Default Color Configuration Register              Address offset: 0x9C */
  __IO uint32_t BFCR;          /*!< LTDC Layerx Blending Factors Configuration Register           Address offset: 0xA0 */
  uint32_t      RESERVED0[2];  /*!< Reserved */
  __IO uint32_t CFBAR;         /*!< LTDC Layerx Color Frame Buffer Address Register               Address offset: 0xAC */
  __IO uint32_t CFBLR;         /*!< LTDC Layerx Color Frame Buffer Length Register                Address offset: 0xB0 */
  __IO uint32_t CFBLNR;        /*!< LTDC Layerx ColorFrame Buffer Line Number Register            Address offset: 0xB4 */
  uint32_t      RESERVED1[3];  /*!< Reserved */
  __IO uint32_t CLUTWR;         /*!< LTDC Layerx CLUT Write Register                               Address offset: 0x144 */

} LTDC_Layer_TypeDef;


/**
  * @brief DDRPHYC DDR Physical Interface Control
  */
typedef struct
{
  __IO uint32_t RIDR;             /*!< DDR_PHY: PUBL revision Identification register,              Address offset: 0x000 */
  __IO uint32_t PIR;              /*!< DDR_PHY: PUBL PHY Initialization register,                   Address offset: 0x004 */
  __IO uint32_t PGCR;             /*!< DDR_PHY:                                                     Address offset: 0x008 */
  __IO uint32_t PGSR;             /*!< DDR_PHY:                                                     Address offset: 0x00C */
  __IO uint32_t DLLGCR;           /*!< DDR_PHY:                                                     Address offset: 0x010 */
  __IO uint32_t ACDLLCR;          /*!< DDR_PHY:                                                     Address offset: 0x014 */
  __IO uint32_t PTR0;             /*!< DDR_PHY:                                                     Address offset: 0x018 */
  __IO uint32_t PTR1;             /*!< DDR_PHY:                                                     Address offset: 0x01C */
  __IO uint32_t PTR2;             /*!< DDR_PHY:                                                     Address offset: 0x020 */
  __IO uint32_t ACIOCR;           /*!< DDR_PHY: PUBL AC I/O Configuration Register,                 Address offset: 0x024 */
  __IO uint32_t DXCCR;            /*!< DDR_PHY: PUBL DATX8 Common Configuration Register,           Address offset: 0x028 */
  __IO uint32_t DSGCR;            /*!< DDR_PHY: PUBL DDR System General Configuration Register,     Address offset: 0x02C */
  __IO uint32_t DCR;              /*!< DDR_PHY:                                                     Address offset: 0x030 */
  __IO uint32_t DTPR0;            /*!< DDR_PHY:                                                     Address offset: 0x034 */
  __IO uint32_t DTPR1;            /*!< DDR_PHY:                                                     Address offset: 0x038 */
  __IO uint32_t DTPR2;            /*!< DDR_PHY:                                                     Address offset: 0x03C */
  __IO uint32_t MR0;              /*!< DDR_PHY:H                                                    Address offset: 0x040 */
  __IO uint32_t MR1;              /*!< DDR_PHY:H                                                    Address offset: 0x044 */
  __IO uint32_t MR2;              /*!< DDR_PHY:H                                                    Address offset: 0x048 */
  __IO uint32_t MR3;              /*!< DDR_PHY:B                                                    Address offset: 0x04C */
  __IO uint32_t ODTCR;            /*!< DDR_PHY:H                                                    Address offset: 0x050 */
  __IO uint32_t DTAR;             /*!< DDR_PHY:                                                     Address offset: 0x054 */
  __IO uint32_t DTDR0;            /*!< DDR_PHY:                                                     Address offset: 0x058 */
  __IO uint32_t DTDR1;            /*!< DDR_PHY:                                                     Address offset: 0x05C */
  uint32_t      RESERVED0[24];    /*!< Reserved */
  __IO uint32_t DCUAR;            /*!< DDR_PHY:H                                                    Address offset: 0x0C0 */
  __IO uint32_t DCUDR;            /*!< DDR_PHY:                                                     Address offset: 0x0C4 */
  __IO uint32_t DCURR;            /*!< DDR_PHY:                                                     Address offset: 0x0C8 */
  __IO uint32_t DCULR;            /*!< DDR_PHY:                                                     Address offset: 0x0CC */
  __IO uint32_t DCUGCR;           /*!< DDR_PHY:H                                                    Address offset: 0x0D0 */
  __IO uint32_t DCUTPR;           /*!< DDR_PHY:                                                     Address offset: 0x0D4 */
  __IO uint32_t DCUSR0;           /*!< DDR_PHY:B                                                    Address offset: 0x0D8 */
  __IO uint32_t DCUSR1;           /*!< DDR_PHY:                                                     Address offset: 0x0DC */
  uint32_t      RESERVED1[8];    /*!< Reserved */
  __IO uint32_t BISTRR;           /*!< DDR_PHY:                                                     Address offset: 0x100 */
  __IO uint32_t BISTMSKR0;        /*!< DDR_PHY:                                                     Address offset: 0x104 */
  __IO uint32_t BISTMSKR1;        /*!< DDR_PHY:                                                     Address offset: 0x108 */
  __IO uint32_t BISTWCR;          /*!< DDR_PHY:H                                                    Address offset: 0x10C */
  __IO uint32_t BISTLSR;          /*!< DDR_PHY:                                                     Address offset: 0x110 */
  __IO uint32_t BISTAR0;          /*!< DDR_PHY:                                                     Address offset: 0x114 */
  __IO uint32_t BISTAR1;          /*!< DDR_PHY:H                                                    Address offset: 0x118 */
  __IO uint32_t BISTAR2;          /*!< DDR_PHY:                                                     Address offset: 0x11C */
  __IO uint32_t BISTUDPR;         /*!< DDR_PHY:                                                     Address offset: 0x120 */
  __IO uint32_t BISTGSR;          /*!< DDR_PHY:                                                     Address offset: 0x124 */
  __IO uint32_t BISTWER;          /*!< DDR_PHY:                                                     Address offset: 0x128 */
  __IO uint32_t BISTBER0;         /*!< DDR_PHY:                                                     Address offset: 0x12C */
  __IO uint32_t BISTBER1;         /*!< DDR_PHY:                                                     Address offset: 0x130 */
  __IO uint32_t BISTBER2;         /*!< DDR_PHY:                                                     Address offset: 0x134 */
  __IO uint32_t BISTWCSR;         /*!< DDR_PHY:                                                     Address offset: 0x138 */
  __IO uint32_t BISTFWR0;         /*!< DDR_PHY:                                                     Address offset: 0x13C */
  __IO uint32_t BISTFWR1;         /*!< DDR_PHY:                                                     Address offset: 0x140 */
  uint32_t      RESERVED2[13];    /*!< Reserved */
  __IO uint32_t GPR0;             /*!< DDR_PHY:                                                     Address offset: 0x178 */
  __IO uint32_t GPR1;             /*!< DDR_PHY:                                                     Address offset: 0x17C */
  __IO uint32_t ZQ0CR0;           /*!< DDR_PHY:                                                     Address offset: 0x180 */
  __IO uint32_t ZQ0CR1;           /*!< DDR_PHY:B                                                    Address offset: 0x184 */
  __IO uint32_t ZQ0SR0;           /*!< DDR_PHY:                                                     Address offset: 0x188 */
  __IO uint32_t ZQ0SR1;           /*!< DDR_PHY:B                                                    Address offset: 0x18C */
  uint32_t      RESERVED3[12];    /*!< Reserved */
  __IO uint32_t DX0GCR;           /*!< DDR_PHY:                                                     Address offset: 0x1C0 */
  __IO uint32_t DX0GSR0;          /*!< DDR_PHY:H                                                    Address offset: 0x1C4 */
  __IO uint32_t DX0GSR1;          /*!< DDR_PHY:                                                     Address offset: 0x1C8 */
  __IO uint32_t DX0DLLCR;         /*!< DDR_PHY:                                                     Address offset: 0x1CC */
  __IO uint32_t DX0DQTR;          /*!< DDR_PHY:                                                     Address offset: 0x1D0 */
  __IO uint32_t DX0DQSTR;         /*!< DDR_PHY:                                                     Address offset: 0x1D4 */
  uint32_t      RESERVED4[10];    /*!< Reserved */
  __IO uint32_t DX1GCR;           /*!< DDR_PHY:                                                     Address offset: 0x200 */
  __IO uint32_t DX1GSR0;          /*!< DDR_PHY:H                                                    Address offset: 0x204 */
  __IO uint32_t DX1GSR1;          /*!< DDR_PHY:                                                     Address offset: 0x208 */
  __IO uint32_t DX1DLLCR;         /*!< DDR_PHY:                                                     Address offset: 0x20C */
  __IO uint32_t DX1DQTR;          /*!< DDR_PHY:                                                     Address offset: 0x210 */
  __IO uint32_t DX1DQSTR;         /*!< DDR_PHY:                                                     Address offset: 0x214 */
  uint32_t      RESERVED5[10];    /*!< Reserved */
  __IO uint32_t DX2GCR;           /*!< DDR_PHY:                                                     Address offset: 0x240 */
  __IO uint32_t DX2GSR0;          /*!< DDR_PHY:H                                                    Address offset: 0x244 */
  __IO uint32_t DX2GSR1;          /*!< DDR_PHY:                                                     Address offset: 0x248 */
  __IO uint32_t DX2DLLCR;         /*!< DDR_PHY:                                                     Address offset: 0x24C */
  __IO uint32_t DX2DQTR;          /*!< DDR_PHY:                                                     Address offset: 0x250 */
  __IO uint32_t DX2DQSTR;         /*!< DDR_PHY:                                                     Address offset: 0x254 */
  uint32_t      RESERVED6[10];    /*!< Reserved */
  __IO uint32_t DX3GCR;           /*!< DDR_PHY:                                                     Address offset: 0x280 */
  __IO uint32_t DX3GSR0;          /*!< DDR_PHY:H                                                    Address offset: 0x284 */
  __IO uint32_t DX3GSR1;          /*!< DDR_PHY:                                                     Address offset: 0x288 */
  __IO uint32_t DX3DLLCR;         /*!< DDR_PHY:                                                     Address offset: 0x28C */
  __IO uint32_t DX3DQTR;          /*!< DDR_PHY:                                                     Address offset: 0x290 */
  __IO uint32_t DX3DQSTR;         /*!< DDR_PHY:                                                     Address offset: 0x294 */
}DDRPHYC_TypeDef;


/**
  * @brief DDRC DDR3/LPDDR2 Controller (DDRCTRL)
  */
typedef struct
{
  __IO uint32_t MSTR;      /*!< DDR_PHY: PUBL revision Identification register,              Address offset: 0x00 */
  /* @TODO : TypeDef to be compleated */
}DDRC_TypeDef;


/**
  * @brief USBPHYC  USB HS PHY Control
  */
typedef struct
{
  __IO uint32_t PLL;                       /*!< USBPHYC PLL control register,               Address offset: 0x000 */
  uint32_t RESERVED0;                      /*! Reserved                                     Address offset: 0x004 */
  __IO uint32_t MISC;                      /*!< USBPHYC Misc Control register,              Address offset: 0x008 */
  uint32_t RESERVED1[250] ;                /*! Reserved                              Address offset: 0x00C - 0x3F0*/
  __IO uint32_t VERR;                      /*!< USBPHYC Version register,                   Address offset: 0x3F4 */
  __IO uint32_t IPIDR;                     /*!< USBPHYC Identification register,            Address offset: 0x3F8 */
  __IO uint32_t SIDR;                      /*!< USBPHYC Size ID register,                   Address offset: 0x3FC */
}USBPHYC_GlobalTypeDef;


/**
  * @brief USBPHYC  USB HS PHY Control PHYx
  */
typedef struct
{
  uint32_t RESERVED0[3];                   /*! Reserved                              Address offset: 0x000 - 0x008 */
  __IO uint32_t TUNE;                     /*!< USBPHYC x TUNE register  ter,                Address offset: 0x00C */
}USBPHYC_InstanceTypeDef;


/**
  * @brief TZC TrustZone Address Space Controller for DDR
  */
typedef struct
{
  __IO uint32_t BUILD_CONFIG;       /*!< Build config register,               Address offset: 0x00 */
  __IO uint32_t ACTION;             /*!< Action register,                     Address offset: 0x04 */
  __IO uint32_t GATE_KEEPER;        /*!< Gate keeper register,                Address offset: 0x08 */
  __IO uint32_t SPECULATION_CTRL;   /*!< Speculation control register,        Address offset: 0x0C */
  uint8_t RESERVED0[0x100 - 0x10];
  __IO uint32_t REG_BASE_LOWO;      /*!< Region 0 base address low register,  Address offset: 0x100 */
  __IO uint32_t REG_BASE_HIGHO;     /*!< Region 0 base address high register, Address offset: 0x104 */
  __IO uint32_t REG_TOP_LOWO;       /*!< Region 0 top address low register,   Address offset: 0x108 */
  __IO uint32_t REG_TOP_HIGHO;      /*!< Region 0 top address high register,  Address offset: 0x10C */
  __IO uint32_t REG_ATTRIBUTESO;    /*!< Region 0 attribute register,         Address offset: 0x110 */
  __IO uint32_t REG_ID_ACCESSO;     /*!< Region 0 ID access register,         Address offset: 0x114 */
  /* @TODO : TypeDef to be compleated if needed*/
}TZC_TypeDef;



/**
  * @brief TZPC TrustZone Protection Controller
  */
typedef struct
{
  __IO uint32_t   TZMA0_SIZE;         /*!<TZPC ROM Secure Size Definition register,             Address offset: 0x00 */
  __IO uint32_t   TZMA1_SIZE;         /*!<TZPC SYSRAM Secure Size Definition register,          Address offset: 0x04 */
  uint32_t        RESERVED0[2];       /*!< Reserved */
  __IO uint32_t   DECPROT0;           /*!<TZPC Securable peripheral definition register 0,      Address offset: 0x10 */
  __IO uint32_t   DECPROT1;           /*!<TZPC Securable peripheral definition register 1,      Address offset: 0x14 */
  __IO uint32_t   DECPROT2;           /*!<TZPC Securable peripheral definition register 2,      Address offset: 0x18 */
  __IO uint32_t   DECPROT3;           /*!<TZPC Securable peripheral definition register 3,      Address offset: 0x1C */
  __IO uint32_t   DECPROT4;           /*!<TZPC Securable peripheral definition register 4,      Address offset: 0x20 */
  __IO uint32_t   DECPROT5;           /*!<TZPC Securable peripheral definition register 5,      Address offset: 0x24 */
  uint32_t        RESERVED1[2];       /*!< Reserved */
  __IO uint32_t   DECPROT_LOCK0;      /*!<TZPC Securable lock of security register 0,           Address offset: 0x30 */
  __IO uint32_t   DECPROT_LOCK1;      /*!<TZPC Securable lock of security register 1,           Address offset: 0x34 */
  __IO uint32_t   DECPROT_LOCK2;      /*!<TZPC Securable lock of security register 2,           Address offset: 0x38 */
  uint32_t        RESERVED2[237];     /*!< Reserved */
  __IO uint32_t   HWCFGR;             /*!< TZPC IP HW configuration register                    Address offset:0x3F0  */
  __IO uint32_t   IP_VER;             /*!< TZPC IP version register                             Address offset:0x3F4  */
  __IO uint32_t   ID;                 /*!< TZPC IP version register                             Address offset:0x3F8  */
  __IO uint32_t   SID;                /*!< TZPC IP version register                             Address offset:0x3FC  */
}TZPC_TypeDef;



/**
  * @brief STGENC System Generic Counter Control
  */
typedef struct
{
  __IO uint32_t CNTCR;       /*!< STGEN Counter Control Register,               Address offset: 0x00 */
  /* @TODO : TypeDef to be compleated if needed*/
}STGENC_TypeDef;

/**
  * @brief Firewall
  */

typedef struct
{
  __IO uint32_t CSSA;     /*!< Code Segment Start Address register,              Address offset: 0x00 */
  __IO uint32_t CSL;      /*!< Code Segment Length register,                      Address offset: 0x04 */
  __IO uint32_t NVDSSA;   /*!< NON volatile data Segment Start Address register,  Address offset: 0x08 */
  __IO uint32_t NVDSL;    /*!< NON volatile data Segment Length register,         Address offset: 0x0C */
  __IO uint32_t VDSSA ;   /*!< Volatile data Segment Start Address register,      Address offset: 0x10 */
  __IO uint32_t VDSL ;    /*!< Volatile data Segment Length register,             Address offset: 0x14 */
  __IO uint32_t CR ;      /*!< Configuration  register,                           Address offset: 0x20 */

} FIREWALL_TypeDef;

/**
  * @brief Power Control
  */

typedef struct
{
  __IO uint32_t CR1;              /*!< PWR control register 1,                   Address offset: 0x00 */
  __IO uint32_t CSR1;             /*!< PWR control status register 1,            Address offset: 0x04 */
  __IO uint32_t CR2;              /*!< PWR control register 2,                   Address offset: 0x08 */
  __IO uint32_t CR3;              /*!< PWR control register 3,                   Address offset: 0x0C */
  __IO uint32_t MPUCR;            /*!< PWR MPU control register,                 Address offset: 0x10 */
  __IO uint32_t MCUCR;            /*!< PWR MCU control register,                 Address offset: 0x14 */
       uint32_t RESERVED0[2];     /*!< Reserved, 0x18-0x1C                       Address offset: 0x18 */
  __IO uint32_t WKUPCR;           /*!< PWR wakeup clear register,                Address offset: 0x20 */
  __IO uint32_t WKUPFR;           /*!< PWR wakeup flag register,                 Address offset: 0x24 */
  __IO uint32_t MPUWKUPENR;       /*!< PWR wakeup enable and polarity register,  Address offset: 0x28 */
  __IO uint32_t MCUWKUPENR;       /*!< PWR wakeup enable and polarity register,  Address offset: 0x2C */
       uint32_t RESERVED1[241];   /*!< Reserved, 0x30-0x3F0                      Address offset: 0x30 */
  __IO uint32_t VER;              /*!< PWR IP version register,                  Address offset: 0x3F4 */
  __IO uint32_t ID;               /*!< PWR IP identification register,           Address offset: 0x3F8 */
  __IO uint32_t SID;              /*!< PWR size ID register,                     Address offset: 0x3FC */
} PWR_TypeDef;


/**
  * @brief Reset and Clock Control
  */

typedef struct
{
  __IO uint32_t TZCR;                      /*!< RCC TrustZone Control Register                       Address offset: 0x00 */
       uint32_t RESERVED0[2];              /*!< Reserved, 0x04-0x08                                  Address offset: 0x04 */
  __IO uint32_t OCENSETR;                  /*!< RCC Oscillator Clock Enable Set Register             Address offset: 0x0C */
  __IO uint32_t OCENCLRR;                  /*!< RCC Oscillator Enable Control Clear Register         Address offset: 0x10 */
       uint32_t RESERVED1;                 /*!< Reserved,                                            Address offset: 0x14 */
  __IO uint32_t HSICFGR;                   /*!< RCC HSI Configuration Register                       Address offset: 0x18 */
  __IO uint32_t CSICFGR;                   /*!< RCC CSI Configuration Register                       Address offset: 0x1C */
  __IO uint32_t MPCKSELR;                  /*!< RCC MPU Clock Selection Register                     Address offset: 0x20 */
  __IO uint32_t ASSCKSELR;                 /*!< RCC AXI Sub-System Clock Selection Register          Address offset: 0x24 */
  __IO uint32_t RCK12SELR;                 /*!< RCC PLL 1 and 2 Ref. Clock Selection Register        Address offset: 0x28 */
  __IO uint32_t MPCKDIVR;                  /*!< RCC MPU Clock Divider Register                       Address offset: 0x2C */
  __IO uint32_t AXIDIVR;                   /*!< RCC AXI Clock Divider Register                       Address offset: 0x30 */
       uint32_t RESERVED2[2];              /*!< Reserved, 0x34-0x38                                  Address offset: 0x34 */
  __IO uint32_t APB4DIVR;                  /*!< RCC APB4 Clock Divider Register                      Address offset: 0x3C */
  __IO uint32_t APB5DIVR;                  /*!< RCC APB5 Clock Divider Register                      Address offset: 0x40 */
  __IO uint32_t RTCDIVR;                   /*!< RCC RTC Clock Division Register                      Address offset: 0x44 */
  __IO uint32_t MSSCKSELR;                 /*!< RCC MCU Sub-System Clock Selection Register          Address offset: 0x48 */
       uint32_t RESERVED3[13];             /*!< Reserved, 0x4C-0x7C                                  Address offset: 0x4C */
  __IO uint32_t PLL1CR;                    /*!< RCC PLL1 Control Register                            Address offset: 0x80 */
  __IO uint32_t PLL1CFGR1;                 /*!< RCC PLL1 Configuration Register 1                    Address offset: 0x84 */
  __IO uint32_t PLL1CFGR2;                 /*!< RCC PLL1 Configuration Register 2                    Address offset: 0x88 */
  __IO uint32_t PLL1FRACR;                 /*!< RCC PLL1 Fractional Register                         Address offset: 0x8C */
  __IO uint32_t PLL1CSGR;                  /*!< RCC PLL1 Clock Spreading Generator Register          Address offset: 0x90 */
  __IO uint32_t PLL2CR;                    /*!< RCC PLL2 Control Register                            Address offset: 0x94 */
  __IO uint32_t PLL2CFGR1;                 /*!< RCC PLL2 Configuration Register 1                    Address offset: 0x98 */
  __IO uint32_t PLL2CFGR2;                 /*!< RCC PLL2 Configuration Register 2                    Address offset: 0x9C */
  __IO uint32_t PLL2FRACR;                 /*!< RCC PLL2 Fractional Register                         Address offset: 0xA0 */
  __IO uint32_t PLL2CSGR;                  /*!< RCC PLL2 Clock Spreading Generator Register          Address offset: 0xA4 */
       uint32_t RESERVED4[6];              /*!< Reserved, 0xA8-0xBC                                  Address offset: 0xA8 */
  __IO uint32_t I2C46CKSELR;               /*!< RCC I2C46 Kernel Clock Selection Register            Address offset: 0xC0 */
  __IO uint32_t SPI6CKSELR;                /*!< RCC SPI6 Kernel Clock Selection Register             Address offset: 0xC4 */
  __IO uint32_t UART1CKSELR;               /*!< RCC USART1 Kernel Clock Selection Register           Address offset: 0xC8 */
  __IO uint32_t RNG1CKSELR;                /*!< RCC RNG1 Kernel Clock Selection Register             Address offset: 0xCC */
  __IO uint32_t CPERCKSELR;                /*!< RCC Common Peripheral Clock Selection Register       Address offset: 0xD0 */
  __IO uint32_t STGENCKSELR;               /*!< RCC STGEN Clock Selection Register                   Address offset: 0xD4 */
  __IO uint32_t DDRITFCR;                  /*!< RCC control DDR interface, DDRC and DDRPHYC Register Address offset: 0xD8 */
       uint32_t RESERVED5;                 /*!< Reserved,                                            Address offset: 0xDC */
       uint32_t RESERVED6[8];              /*!< Reserved, 0xE0-0xFC                                  Address offset: 0xE0 */
  __IO uint32_t MP_BOOTCR;                 /*!< RCC Hold Boot Control Register                       Address offset: 0x100 */
  __IO uint32_t MP_SREQSETR;               /*!< RCC Stop Request Set Register                        Address offset: 0x104 */
  __IO uint32_t MP_SREQCLRR;               /*!< RCC Stop Request Clear Register                      Address offset: 0x108 */
  __IO uint32_t MP_GCR;                    /*!< RCC Global Control Register                          Address offset: 0x10C */
  __IO uint32_t MP_APRSTCR;                /*!< RCC Application Reset Control Register               Address offset: 0x110 */
  __IO uint32_t MP_APRSTSR;                /*!< RCC Application Reset Status Register                Address offset: 0x114 */
       uint32_t RESERVED7[10];             /*!< Reserved, 0x118-0x13C                                Address offset: 0x118 */
  __IO uint32_t BDCR;                      /*!< RCC Backup Domain Control Register                   Address offset: 0x140 */
  __IO uint32_t RDLSICR;                   /*!< RCC Reset Duration and LSI Control Register          Address offset: 0x144 */
       uint32_t RESERVED8[14];             /*!< Reserved, 0x148-0x17C                                Address offset: 0x148 */
  __IO uint32_t APB4RSTSETR;               /*!< RCC APB4 Peripheral Reset Set Register               Address offset: 0x180 */
  __IO uint32_t APB4RSTCLRR;               /*!< RCC APB4 Peripheral Reset Clear Register             Address offset: 0x184 */
  __IO uint32_t APB5RSTSETR;               /*!< RCC APB5 Peripheral Reset Set Register               Address offset: 0x188 */
  __IO uint32_t APB5RSTCLRR;               /*!< RCC APB5 Peripheral Reset Clear Register             Address offset: 0x18C */
  __IO uint32_t AHB5RSTSETR;               /*!< RCC AHB5 Peripheral Reset Set Register               Address offset: 0x190 */
  __IO uint32_t AHB5RSTCLRR;               /*!< RCC AHB5 Peripheral Reset Clear Register             Address offset: 0x194 */
  __IO uint32_t AHB6RSTSETR;               /*!< RCC AHB6 Peripheral Reset Set Register               Address offset: 0x198 */
  __IO uint32_t AHB6RSTCLRR;               /*!< RCC AHB6 Peripheral Reset Clear Register             Address offset: 0x19C */
  __IO uint32_t TZAHB6RSTSETR;             /*!< RCC AHB6 Peripheral Reset Set Register               Address offset: 0x1A0 */
  __IO uint32_t TZAHB6RSTCLRR;             /*!< RCC AHB6 Peripheral Reset Clear Register             Address offset: 0x1A4 */
       uint32_t RESERVED9[22];             /*!< Reserved, 0x1A8-0x1FC                                Address offset: 0x1A8 */
  __IO uint32_t MP_APB4ENSETR;             /*!< RCC APB4 Periph. Enable For MPU Set Register         Address offset: 0x200 */
  __IO uint32_t MP_APB4ENCLRR;             /*!< RCC APB4 Periph. Enable For MPU Clear Register       Address offset: 0x204 */
  __IO uint32_t MP_APB5ENSETR;             /*!< RCC APB5 Periph. Enable For MPU Set Register         Address offset: 0x208 */
  __IO uint32_t MP_APB5ENCLRR;             /*!< RCC APB5 Periph. Enable For MPU Clear Register       Address offset: 0x20C */
  __IO uint32_t MP_AHB5ENSETR;             /*!< RCC AHB5 Periph. Enable For MPU Set Register         Address offset: 0x210 */
  __IO uint32_t MP_AHB5ENCLRR;             /*!< RCC AHB5 Periph. Enable For MPU Clear Register       Address offset: 0x214 */
  __IO uint32_t MP_AHB6ENSETR;             /*!< RCC AHB6 Periph. Enable For MPU Set Register         Address offset: 0x218 */
  __IO uint32_t MP_AHB6ENCLRR;             /*!< RCC AHB6 Periph. Enable For MPU Clear Register       Address offset: 0x21C */
       uint32_t RESERVED10[24];             /*!< Reserved, 0x220-0x27C                                Address offset: 0x220 */
  __IO uint32_t MC_APB4ENSETR;             /*!< RCC APB4 Periph. Enable For MCU Set Register         Address offset: 0x280 */
  __IO uint32_t MC_APB4ENCLRR;             /*!< RCC APB4 Periph. Enable For MCU Clear Register       Address offset: 0x284 */
  __IO uint32_t MC_APB5ENSETR;             /*!< RCC APB5 Periph. Enable For MCU Set Register         Address offset: 0x288 */
  __IO uint32_t MC_APB5ENCLRR;             /*!< RCC APB5 Periph. Enable For MCU Clear Register       Address offset: 0x28C */
  __IO uint32_t MC_AHB5ENSETR;             /*!< RCC AHB5 Periph. Enable For MCU Set Register         Address offset: 0x290 */
  __IO uint32_t MC_AHB5ENCLRR;             /*!< RCC AHB5 Periph. Enable For MCU Clear Register       Address offset: 0x294 */
  __IO uint32_t MC_AHB6ENSETR;             /*!< RCC AHB6 Periph. Enable For MCU Set Register         Address offset: 0x298 */
  __IO uint32_t MC_AHB6ENCLRR;             /*!< RCC AHB6 Periph. Enable For MCU Clear Register       Address offset: 0x29C */
       uint32_t RESERVED11[24];            /*!< Reserved, 0x2A0-0x2FC                                Address offset: 0x2A0 */
  __IO uint32_t MP_APB4LPENSETR;           /*!< RCC APB4 Sleep Clock Ena. For MPU Set Register       Address offset: 0x300 */
  __IO uint32_t MP_APB4LPENCLRR;           /*!< RCC APB4 Sleep Clock Ena. For MPU Clear Register     Address offset: 0x304 */
  __IO uint32_t MP_APB5LPENSETR;           /*!< RCC APB5 Sleep Clock Ena. For MPU Set Register       Address offset: 0x308 */
  __IO uint32_t MP_APB5LPENCLRR;           /*!< RCC APB5 Sleep Clock Ena. For MPU Clear Register     Address offset: 0x30C */
  __IO uint32_t MP_AHB5LPENSETR;           /*!< RCC AHB5 Sleep Clock Ena. For MPU Set Register       Address offset: 0x310 */
  __IO uint32_t MP_AHB5LPENCLRR;           /*!< RCC AHB5 Sleep Clock Ena. For MPU Clear Register     Address offset: 0x314 */
  __IO uint32_t MP_AHB6LPENSETR;           /*!< RCC AHB6 Sleep Clock Ena. For MPU Set Register       Address offset: 0x318 */
  __IO uint32_t MP_AHB6LPENCLRR;           /*!< RCC AHB6 Sleep Clock Ena. For MPU Clear Register     Address offset: 0x31C */
       uint32_t RESERVED12[24];            /*!< Reserved, 0x320-0x30C                                Address offset: 0x320 */
  __IO uint32_t MC_APB4LPENSETR;           /*!< RCC APB4 Sleep Clock Ena. For MCU Set Register       Address offset: 0x380 */
  __IO uint32_t MC_APB4LPENCLRR;           /*!< RCC APB4 Sleep Clock Ena. For MCU Clear Register     Address offset: 0x384 */
  __IO uint32_t MC_APB5LPENSETR;           /*!< RCC APB5 Sleep Clock Ena. For MCU Set Register       Address offset: 0x388 */
  __IO uint32_t MC_APB5LPENCLRR;           /*!< RCC APB5 Sleep Clock Ena. For MCU Clear Register     Address offset: 0x38C */
  __IO uint32_t MC_AHB5LPENSETR;           /*!< RCC AHB5 Sleep Clock Ena. For MCU Set Register       Address offset: 0x390 */
  __IO uint32_t MC_AHB5LPENCLRR;           /*!< RCC AHB5 Sleep Clock Ena. For MCU Clear Register     Address offset: 0x394 */
  __IO uint32_t MC_AHB6LPENSETR;           /*!< RCC AHB6 Sleep Clock Ena. For MCU Set Register       Address offset: 0x398 */
  __IO uint32_t MC_AHB6LPENCLRR;           /*!< RCC AHB6 Sleep Clock Ena. For MCU Clear Register     Address offset: 0x39C */
       uint32_t RESERVED13[24];            /*!< Reserved, 0x3A0-0x3FC                                Address offset: 0x3A0 */
  __IO uint32_t BR_RSTSCLRR;               /*!< RCC BootRom Reset Status Clear Register              Address offset: 0x400 */
  __IO uint32_t MP_GRSTCSETR;              /*!< RCC Global Reset Control Set Register                Address offset: 0x404 */
  __IO uint32_t MP_RSTSCLRR;               /*!< RCC MPU Reset Status Clear Register                  Address offset: 0x408 */
  __IO uint32_t MP_IWDGFZSETR;             /*!< RCC IWDG Clock Freeze Set Register                   Address offset: 0x40C */
  __IO uint32_t MP_IWDGFZCLRR;             /*!< RCC IWDG Clock Freeze Clear Register                 Address offset: 0x410 */
  __IO uint32_t MP_CIER;                   /*!< RCC Clock Source Interrupt Enable Register           Address offset: 0x414 */
  __IO uint32_t MP_CIFR;                   /*!< RCC Clock Source Interrupt Flag Register             Address offset: 0x418 */
  __IO uint32_t PWRLPDLYCR;                /*!< RCC PWR_LP Delay Control Register                    Address offset: 0x41C */
  __IO uint32_t MP_RSTSSETR;               /*!< RCC MPU Reset Status Set Register                    Address offset: 0x420 */
       uint32_t RESERVED14[247];           /*!< Reserved, 0x424-0x7FC                                Address offset: 0x424 */
  __IO uint32_t MCO1CFGR;                  /*!< RCC MCO1 Configuration Register                      Address offset: 0x800 */
  __IO uint32_t MCO2CFGR;                  /*!< RCC MCO2 Configuration Register                      Address offset: 0x804 */
  __IO uint32_t OCRDYR;                    /*!< RCC Oscillator Clock Ready Register                  Address offset: 0x808 */
  __IO uint32_t DBGCFGR;                   /*!< Debug Configuration Register                         Address offset: 0x80C */
       uint32_t RESERVED15[4];             /*!< Reserved, 0x810-0x81C                                Address offset: 0x810 */
  __IO uint32_t RCK3SELR;                  /*!< RCC PLL 3 Ref. Clock Selection Register              Address offset: 0x820 */
  __IO uint32_t RCK4SELR;                  /*!< RCC PLL4 Ref. Clock Selection Register               Address offset: 0x824 */
  __IO uint32_t TIMG1PRER;                 /*!< RCC TIM Group 1 Prescaler Register                   Address offset: 0x828 */
  __IO uint32_t TIMG2PRER;                 /*!< RCC TIM Group 2 Prescaler Register                   Address offset: 0x82C */
  __IO uint32_t MCUDIVR;                   /*!< RCC MCU Clock Prescaler Register                     Address offset: 0x830 */
  __IO uint32_t APB1DIVR;                  /*!< RCC APB1 Clock Prescaler Register                    Address offset: 0x834 */
  __IO uint32_t APB2DIVR;                  /*!< RCC APB2 Clock Prescaler Register                    Address offset: 0x838 */
  __IO uint32_t APB3DIVR;                  /*!< RCC APB3 Clock Prescaler Register                    Address offset: 0x83C */
       uint32_t RESERVED16[16];            /*!< Reserved, 0x840-0x87C                                Address offset: 0x840 */
  __IO uint32_t PLL3CR;                    /*!< RCC PLL3 Control Register                            Address offset: 0x880 */
  __IO uint32_t PLL3CFGR1;                 /*!< RCC PLL3 Configuration Register 1                    Address offset: 0x884 */
  __IO uint32_t PLL3CFGR2;                 /*!< RCC PLL3 Configuration Register 2                    Address offset: 0x888 */
  __IO uint32_t PLL3FRACR;                 /*!< RCC PLL3 Fractional Register                         Address offset: 0x88C */
  __IO uint32_t PLL3CSGR;                  /*!< RCC PLL3 Clock Spreading Generator Register          Address offset: 0x890 */
  __IO uint32_t PLL4CR;                    /*!< RCC PLL4 Control Register                            Address offset: 0x894 */
  __IO uint32_t PLL4CFGR1;                 /*!< RCC PLL4 Configuration Register 1                    Address offset: 0x898 */
  __IO uint32_t PLL4CFGR2;                 /*!< RCC PLL4 Configuration Register 2                    Address offset: 0x89C */
  __IO uint32_t PLL4FRACR;                 /*!< RCC PLL4 Fractional Register                         Address offset: 0x8A0 */
  __IO uint32_t PLL4CSGR;                  /*!< RCC PLL4 Clock Spreading Generator Register          Address offset: 0x8A4 */
       uint32_t RESERVED17[6];             /*!< Reserved, 0x8A8-0x8BC                                Address offset: 0x8A8 */
  __IO uint32_t I2C12CKSELR;               /*!< RCC I2C1,2 Kernel Clock Selection Register           Address offset: 0x8C0 */
  __IO uint32_t I2C35CKSELR;               /*!< RCC I2C3,5 Kernel Clock Selection Register           Address offset: 0x8C4 */
  __IO uint32_t SAI1CKSELR;                /*!< RCC SAI1 Kernel Clock Selection Register             Address offset: 0x8C8 */
  __IO uint32_t SAI2CKSELR;                /*!< RCC SAI2 Kernel Clock Selection Register             Address offset: 0x8CC */
  __IO uint32_t SAI3CKSELR;                /*!< RCC SAI3 Kernel Clock Selection Register             Address offset: 0x8D0 */
  __IO uint32_t SAI4CKSELR;                /*!< RCC SAI4 Kernel Clock Selection Register             Address offset: 0x8D4 */
  __IO uint32_t SPI2S1CKSELR;              /*!< RCC SPI/I2S1 Kernel Clock Selection Register         Address offset: 0x8D8 */
  __IO uint32_t SPI2S23CKSELR;             /*!< RCC SPI/I2S2,3 Kernel Clock Selection Register       Address offset: 0x8DC */
  __IO uint32_t SPI45CKSELR;               /*!< RCC SPI4,5 Kernel Clock Selection Register           Address offset: 0x8E0 */
  __IO uint32_t UART6CKSELR;               /*!< RCC USART6 Kernel Clock Selection Register           Address offset: 0x8E4 */
  __IO uint32_t UART24CKSELR;              /*!< RCC UART2,4 Kernel Clock Selection Register          Address offset: 0x8E8 */
  __IO uint32_t UART35CKSELR;              /*!< RCC UART3,5 Kernel Clock Selection Register          Address offset: 0x8EC */
  __IO uint32_t UART78CKSELR;              /*!< RCC UART7,8 Kernel Clock Selection Register          Address offset: 0x8F0 */
  __IO uint32_t SDMMC12CKSELR;             /*!< RCC SDMMC1&2 Kernel Clock Selection Register         Address offset: 0x8F4 */
  __IO uint32_t SDMMC3CKSELR;              /*!< RCC SDMMC3 Kernel Clock Selection Register           Address offset: 0x8F8 */
  __IO uint32_t ETHCKSELR;                 /*!< RCC Ethernet Kernel Clock Selection Register         Address offset: 0x8FC */
  __IO uint32_t QSPICKSELR;                /*!< RCC QUADSPI Kernel Clock Selection Register          Address offset: 0x900 */
  __IO uint32_t FMCCKSELR;                 /*!< RCC FMC Kernel Clock Selection Register              Address offset: 0x904 */
       uint32_t RESERVED18;                /*!< Reserved,                                            Address offset: 0x908 */
       uint32_t RESERVED30;                /*!< Reserved,                                            Address offset: 0x90C */
       uint32_t RESERVED19;                /*!< Reserved,                                            Address offset: 0x910 */
  __IO uint32_t SPDIFCKSELR;               /*!< RCC SPDIF Kernel Clock Selection Register            Address offset: 0x914 */
  __IO uint32_t CECCKSELR;                 /*!< RCC CEC Kernel Clock Selection Register              Address offset: 0x918 */
  __IO uint32_t USBCKSELR;                 /*!< RCC USB Kernel Clock Selection Register              Address offset: 0x91C */
  __IO uint32_t RNG2CKSELR;                /*!< RCC RNG2 Kernel Clock Selection Register             Address offset: 0x920 */
       uint32_t RESERVED31;                /*!< Reserved,                                            Address offset: 0x924 */
  __IO uint32_t ADCCKSELR;                 /*!< RCC ADC Kernel Clock Selection Register              Address offset: 0x928 */
  __IO uint32_t LPTIM45CKSELR;             /*!< RCC LPTIM4&5 Kernel Clock Selection Register         Address offset: 0x92C */
  __IO uint32_t LPTIM23CKSELR;             /*!< RCC LPTIM2&3 Kernel Clock Selection Register         Address offset: 0x930 */
  __IO uint32_t LPTIM1CKSELR;              /*!< RCC LPTIM1 Kernel Clock Selection Register           Address offset: 0x934 */
       uint32_t RESERVED20[18];            /*!< Reserved, 0x938-0x97C                                Address offset: 0x938 */
  __IO uint32_t APB1RSTSETR;               /*!< RCC APB1 Peripheral Reset Set Register               Address offset: 0x980 */
  __IO uint32_t APB1RSTCLRR;               /*!< RCC APB1 Peripheral Reset Clear Register             Address offset: 0x984 */
  __IO uint32_t APB2RSTSETR;               /*!< RCC APB2 Peripheral Reset Set Register               Address offset: 0x988 */
  __IO uint32_t APB2RSTCLRR;               /*!< RCC APB2 Peripheral Reset Clear Register             Address offset: 0x98C */
  __IO uint32_t APB3RSTSETR;               /*!< RCC APB3 Peripheral Reset Set Register               Address offset: 0x990 */
  __IO uint32_t APB3RSTCLRR;               /*!< RCC APB3 Peripheral Reset Clear Register             Address offset: 0x994 */
  __IO uint32_t AHB2RSTSETR;               /*!< RCC AHB2 Peripheral Reset Set Register               Address offset: 0x998 */
  __IO uint32_t AHB2RSTCLRR;               /*!< RCC AHB2 Peripheral Reset Clear Register             Address offset: 0x99C */
  __IO uint32_t AHB3RSTSETR;               /*!< RCC AHB3 Peripheral Reset Set Register               Address offset: 0x9A0 */
  __IO uint32_t AHB3RSTCLRR;               /*!< RCC AHB3 Peripheral Reset Clear Register             Address offset: 0x9A4 */
  __IO uint32_t AHB4RSTSETR;               /*!< RCC AHB4 Peripheral Reset Set Register               Address offset: 0x9A8 */
  __IO uint32_t AHB4RSTCLRR;               /*!< RCC AHB4 Peripheral Reset Clear Register             Address offset: 0x9AC */
       uint32_t RESERVED21[20];            /*!< Reserved, 0x9B0-0x9FC                                Address offset: 0x9B0 */
  __IO uint32_t MP_APB1ENSETR;             /*!< RCC APB1 Peripheral Enable For MPU Set Register      Address offset: 0xA00 */
  __IO uint32_t MP_APB1ENCLRR;             /*!< RCC APB1 Peripheral Enable For MPU Clear Register    Address offset: 0xA04 */
  __IO uint32_t MP_APB2ENSETR;             /*!< RCC APB2 Peripheral Enable For MPU Set Register      Address offset: 0xA08 */
  __IO uint32_t MP_APB2ENCLRR;             /*!< RCC APB2 Peripheral Enable For MPU Clear Register    Address offset: 0xA0C */
  __IO uint32_t MP_APB3ENSETR;             /*!< RCC APB3 Peripheral Enable For MPU Set Register      Address offset: 0xA10 */
  __IO uint32_t MP_APB3ENCLRR;             /*!< RCC APB3 Peripheral Enable For MPU Clear Register    Address offset: 0xA14 */
  __IO uint32_t MP_AHB2ENSETR;             /*!< RCC AHB2 Peripheral Enable For MPU Set Register      Address offset: 0xA18 */
  __IO uint32_t MP_AHB2ENCLRR;             /*!< RCC AHB2 Peripheral Enable For MPU Clear Register    Address offset: 0xA1C */
  __IO uint32_t MP_AHB3ENSETR;             /*!< RCC AHB3 Peripheral Enable For MPU Set Register      Address offset: 0xA20 */
  __IO uint32_t MP_AHB3ENCLRR;             /*!< RCC AHB3 Peripheral Enable For MPU Clear Register    Address offset: 0xA24 */
  __IO uint32_t MP_AHB4ENSETR;             /*!< RCC AHB4 Peripheral Enable For MPU Set Register      Address offset: 0xA28 */
  __IO uint32_t MP_AHB4ENCLRR;             /*!< RCC AHB4 Peripheral Enable For MPU Clear Register    Address offset: 0xA2C */
       uint32_t RESERVED22[2];             /*!< Reserved, 0xA30-0xA34                                Address offset: 0xA30 */
  __IO uint32_t MP_MLAHBENSETR;            /*!< RCC MLAHB Periph. Enable For MPU Set Register        Address offset: 0xA38 */
  __IO uint32_t MP_MLAHBENCLRR;            /*!< RCC MLAHB Periph. Enable For MPU Clear Register      Address offset: 0xA3C */
       uint32_t RESERVED23[16];            /*!< Reserved, 0x940-0xA7C                                Address offset: 0x940 */
  __IO uint32_t MC_APB1ENSETR;             /*!< RCC APB1 Peripheral Enable For MCU Set Register      Address offset: 0xA80 */
  __IO uint32_t MC_APB1ENCLRR;             /*!< RCC APB1 Peripheral Enable For MCU Clear Register    Address offset: 0xA84 */
  __IO uint32_t MC_APB2ENSETR;             /*!< RCC APB2 Peripheral Enable For MCU Set Register      Address offset: 0xA88 */
  __IO uint32_t MC_APB2ENCLRR;             /*!< RCC APB2 Peripheral Enable For MCU Clear Register    Address offset: 0xA8C */
  __IO uint32_t MC_APB3ENSETR;             /*!< RCC APB3 Peripheral Enable For MCU Set Register      Address offset: 0xA90 */
  __IO uint32_t MC_APB3ENCLRR;             /*!< RCC APB3 Peripheral Enable For MCU Clear Register    Address offset: 0xA94 */
  __IO uint32_t MC_AHB2ENSETR;             /*!< RCC AHB2 Peripheral Enable For MCU Set Register      Address offset: 0xA98 */
  __IO uint32_t MC_AHB2ENCLRR;             /*!< RCC AHB2 Peripheral Enable For MCU Clear Register    Address offset: 0xA9C */
  __IO uint32_t MC_AHB3ENSETR;             /*!< RCC AHB3 Peripheral Enable For MCU Set Register      Address offset: 0xAA0 */
  __IO uint32_t MC_AHB3ENCLRR;             /*!< RCC AHB3 Peripheral Enable For MCU Clear Register    Address offset: 0xAA4 */
  __IO uint32_t MC_AHB4ENSETR;             /*!< RCC AHB4 Peripheral Enable For MCU Set Register      Address offset: 0xAA8 */
  __IO uint32_t MC_AHB4ENCLRR;             /*!< RCC AHB4 Peripheral Enable For MCU Clear Register    Address offset: 0xAAC */
  __IO uint32_t MC_AXIMENSETR;             /*!< RCC AXI Periph. Enable For MCU Set Register          Address offset: 0xAB0 */
  __IO uint32_t MC_AXIMENCLRR;             /*!< RCC AXI Periph. Enable For MCU Clear Register        Address offset: 0xAB4 */
  __IO uint32_t MC_MLAHBENSETR;            /*!< RCC MLAHB Periph. Enable For MCU Set Register        Address offset: 0xAB8 */
  __IO uint32_t MC_MLAHBENCLRR;            /*!< RCC MLAHB Periph. Enable For MCU Clear Register      Address offset: 0xABC */
       uint32_t RESERVED24[16];            /*!< Reserved, 0xAC0-0xAFC                                Address offset: 0xAC0 */
  __IO uint32_t MP_APB1LPENSETR;           /*!< RCC APB1 Sleep Clock Ena. For MPU Set Register       Address offset: 0xB00 */
  __IO uint32_t MP_APB1LPENCLRR;           /*!< RCC APB1 Sleep Clock Ena. For MPU Clear Register     Address offset: 0xB04 */
  __IO uint32_t MP_APB2LPENSETR;           /*!< RCC APB2 Sleep Clock Ena. For MPU Set Register       Address offset: 0xB08 */
  __IO uint32_t MP_APB2LPENCLRR;           /*!< RCC APB2 Sleep Clock Ena. For MPU Clear Register     Address offset: 0xB0C */
  __IO uint32_t MP_APB3LPENSETR;           /*!< RCC APB3 Sleep Clock Ena. For MPU Set Register       Address offset: 0xB10 */
  __IO uint32_t MP_APB3LPENCLRR;           /*!< RCC APB3 Sleep Clock Ena. For MPU Clear Register     Address offset: 0xB14 */
  __IO uint32_t MP_AHB2LPENSETR;           /*!< RCC AHB2 Sleep Clock Ena. For MPU Set Register       Address offset: 0xB18 */
  __IO uint32_t MP_AHB2LPENCLRR;           /*!< RCC AHB2 Sleep Clock Ena. For MPU Clear Register     Address offset: 0xB1C */
  __IO uint32_t MP_AHB3LPENSETR;           /*!< RCC AHB3 Sleep Clock Ena. For MPU Set Register       Address offset: 0xB20 */
  __IO uint32_t MP_AHB3LPENCLRR;           /*!< RCC AHB3 Sleep Clock Ena. For MPU Clear Register     Address offset: 0xB24 */
  __IO uint32_t MP_AHB4LPENSETR;           /*!< RCC AHB4 Sleep Clock Ena. For MPU Set Register       Address offset: 0xB28 */
  __IO uint32_t MP_AHB4LPENCLRR;           /*!< RCC AHB4 Sleep Clock Ena. For MPU Clear Register     Address offset: 0xB2C */
  __IO uint32_t MP_AXIMLPENSETR;           /*!< RCC AXI Sleep Clock Ena. For MPU Set Register        Address offset: 0xB30 */
  __IO uint32_t MP_AXIMLPENCLRR;           /*!< RCC AXI Sleep Clock Ena. For MPU Clear Register      Address offset: 0xB34 */
  __IO uint32_t MP_MLAHBLPENSETR;          /*!< RCC MLAHB Sleep Clock Ena. For MPU Set Register      Address offset: 0xB38 */
  __IO uint32_t MP_MLAHBLPENCLRR;          /*!< RCC MLAHB Sleep Clock Ena. For MPU Clear Register    Address offset: 0xB3C */
       uint32_t RESERVED25[16];            /*!< Reserved, 0xB40-0xB7C                                Address offset: 0xB40 */
  __IO uint32_t MC_APB1LPENSETR;           /*!< RCC APB1 Sleep Clock Ena. For MCU Set Register       Address offset: 0xB80 */
  __IO uint32_t MC_APB1LPENCLRR;           /*!< RCC APB1 Sleep Clock Ena. For MCU Clear Register     Address offset: 0xB84 */
  __IO uint32_t MC_APB2LPENSETR;           /*!< RCC APB2 Sleep Clock Ena. For MCU Set Register       Address offset: 0xB88 */
  __IO uint32_t MC_APB2LPENCLRR;           /*!< RCC APB2 Sleep Clock Ena. For MCU Clear Register     Address offset: 0xB8C */
  __IO uint32_t MC_APB3LPENSETR;           /*!< RCC APB3 Sleep Clock Ena. For MCU Set Register       Address offset: 0xB90 */
  __IO uint32_t MC_APB3LPENCLRR;           /*!< RCC APB3 Sleep Clock Ena. For MCU Clear Register     Address offset: 0xB94 */
  __IO uint32_t MC_AHB2LPENSETR;           /*!< RCC AHB2 Sleep Clock Ena. For MCU Set Register       Address offset: 0xB98 */
  __IO uint32_t MC_AHB2LPENCLRR;           /*!< RCC AHB2 Sleep Clock Ena. For MCU Clear Register     Address offset: 0xB9C */
  __IO uint32_t MC_AHB3LPENSETR;           /*!< RCC AHB3 Sleep Clock Ena. For MCU Set Register       Address offset: 0xBA0 */
  __IO uint32_t MC_AHB3LPENCLRR;           /*!< RCC AHB3 Sleep Clock Ena. For MCU Clear Register     Address offset: 0xBA4 */
  __IO uint32_t MC_AHB4LPENSETR;           /*!< RCC AHB4 Sleep Clock Ena. For MCU Set Register       Address offset: 0xBA8 */
  __IO uint32_t MC_AHB4LPENCLRR;           /*!< RCC AHB4 Sleep Clock Ena. For MCU Clear Register     Address offset: 0xBAC */
  __IO uint32_t MC_AXIMLPENSETR;           /*!< RCC AXI Sleep Clock Ena. For MCU Set Register        Address offset: 0xBB0 */
  __IO uint32_t MC_AXIMLPENCLRR;           /*!< RCC AXI Sleep Clock Ena. For MCU Clear Register      Address offset: 0xBB4 */
  __IO uint32_t MC_MLAHBLPENSETR;          /*!< RCC MLAHB Sleep Clock Ena. For MCU Set Register      Address offset: 0xBB8 */
  __IO uint32_t MC_MLAHBLPENCLRR;          /*!< RCC MLAHB Sleep Clock Ena. For MCU Clear Register    Address offset: 0xBBC */
       uint32_t RESERVED26[16];            /*!< Reserved, 0xBC0-0xBFC                                Address offset: 0xBC0 */
  __IO uint32_t MC_RSTSCLRR;               /*!< RCC MCU Reset Status Clear Register                  Address offset: 0xC00 */
       uint32_t RESERVED27[4];             /*!< Reserved, 0xC04-0xC10                                Address offset: 0xC04 */
  __IO uint32_t MC_CIER;                   /*!< RCC Clock Source Interrupt Enable Register           Address offset: 0xC14 */
  __IO uint32_t MC_CIFR;                   /*!< RCC Clock Source Interrupt Flag Register             Address offset: 0xC18 */
       uint32_t RESERVED28[246];           /*!< Reserved, 0xC1C-0xFF0                                Address offset: 0xC1C */
  __IO uint32_t VERR;                      /*!< RCC Version register                                 Address offset: 0xFF4 */
  __IO uint32_t IPIDR;                     /*!< RCC ID register                                      Address offset: 0xFF8 */
  __IO uint32_t SIDR;                      /*!< Size ID register                                     Address offset: 0xFFC */
} RCC_TypeDef;

/**
  * @brief Hardware Debug Port
  */

typedef struct
{
  __IO uint32_t HDP_CTRL;                  /*!< HDP Control Register,                                Address offset: 0x00 */
  __IO uint32_t HDP_MUX;                   /*!< HDP Multiplexers Control Register,                   Address offset: 0x04 */
       uint32_t RESERVED0[2];              /*!< Reserved, 0x08-0x0C                                  Address offset: 0x08 */
  __IO uint32_t HDP_VAL;                   /*!< HDP Read Back Value Register,                        Address offset: 0x10 */
  __IO uint32_t HDP_GPOSET;                /*!< HDP General Purpose Output Set Register,             Address offset: 0x14 */
  __IO uint32_t HDP_GPOCLR;                /*!< HDP General Purpose Output Clear Register,           Address offset: 0x18 */
  __IO uint32_t HDP_GPOVAL;                /*!< HDP General Purpose Output Value Register,           Address offset: 0x1C */
       uint32_t RESERVED1[245];            /*!< Reserved, 0x20-0x3F4                                 Address offset: 0x20 */
  __IO uint32_t VERR;                  /*!< HDP Version Register,                                Address offset: 0x3F4 */
  __IO uint32_t IPIDR;                 /*!< HDP IP Identification Register,                      Address offset: 0x3F8 */
  __IO uint32_t SIDR;                  /*!< HDP Size Identification register,                    Address offset: 0x3FC */
} HDP_TypeDef;


/**
  * @brief Boot and Security and OTP Control
  */

typedef struct
{
  __IO uint32_t BSEC_OTP_CONFIG;           /*!< BSEC OTP Configuration,                              Address offset: 0x00 */
  __IO uint32_t BSEC_OTP_CONTROL;          /*!< BSEC OTP Control,                                    Address offset: 0x04 */
  __IO uint32_t BSEC_OTP_WRDATA;           /*!< BSEC OTP Write Data,                                 Address offset: 0x08 */
  __IO uint32_t BSEC_OTP_STATUS;           /*!< BSEC OTP Status,                                     Address offset: 0x0C */
  __IO uint32_t BSEC_OTP_LOCK;             /*!< BSEC OTP Configuration,                              Address offset: 0x10 */
  __IO uint32_t BSEC_DENABLE;              /*!< BSEC Debug Configuration,                            Address offset: 0x14 */
  __IO uint32_t BSEC_FENABLE;              /*!< BSEC Feature Configuration,                          Address offset: 0x18 */
  __IO uint32_t BSEC_OTP_DISTURBED0;       /*!< BSEC OTP Disturbed Status,                           Address offset: 0x1C */
  __IO uint32_t BSEC_OTP_DISTURBED1;       /*!< BSEC OTP Disturbed Status,                           Address offset: 0x20 */
  __IO uint32_t BSEC_OTP_DISTURBED2;       /*!< BSEC OTP Disturbed Status,                           Address offset: 0x24 */
       uint32_t RESERVED0x28;              /*!< Reserved,                                            Address offset: 0x28 */
       uint32_t RESERVED0x2C;              /*!< Reserved,                                            Address offset: 0x2C */
       uint32_t RESERVED0x30;              /*!< Reserved,                                            Address offset: 0x30 */
  __IO uint32_t BSEC_OTP_ERROR0;           /*!< BSEC OTP Error Status,                               Address offset: 0x34 */
  __IO uint32_t BSEC_OTP_ERROR1;           /*!< BSEC OTP Error Status,                               Address offset: 0x38 */
  __IO uint32_t BSEC_OTP_ERROR2;           /*!< BSEC OTP Error Status,                               Address offset: 0x3C */
       uint32_t RESERVED0x40;              /*!< Reserved,                                            Address offset: 0x40 */
       uint32_t RESERVED0x44;              /*!< Reserved,                                            Address offset: 0x44 */
       uint32_t RESERVED0x48;              /*!< Reserved,                                            Address offset: 0x48 */
  __IO uint32_t BSEC_OTP_WRLOCK0;          /*!< BSEC OTP Lock status,                                Address offset: 0x4C */
  __IO uint32_t BSEC_OTP_WRLOCK1;          /*!< BSEC OTP Lock status,                                Address offset: 0x50 */
  __IO uint32_t BSEC_OTP_WRLOCK2;          /*!< BSEC OTP Lock status,                                Address offset: 0x54 */
       uint32_t RESERVED0x58;              /*!< Reserved,                                            Address offset: 0x58 */
       uint32_t RESERVED0x5C;              /*!< Reserved,                                            Address offset: 0x5C */
       uint32_t RESERVED0x60;              /*!< Reserved,                                            Address offset: 0x60 */
  __IO uint32_t BSEC_OTP_SPLOCK0;          /*!< BSEC OTP prg lock under ctrl by stick bits,          Address offset: 0x64 */
  __IO uint32_t BSEC_OTP_SPLOCK1;          /*!< BSEC OTP prg lock under ctrl by stick bits,          Address offset: 0x68 */
  __IO uint32_t BSEC_OTP_SPLOCK2;          /*!< BSEC OTP prg lock under ctrl by stick bits,          Address offset: 0x6C */
       uint32_t RESERVED0x70;              /*!< Reserved,                                            Address offset: 0x70 */
       uint32_t RESERVED0x74;              /*!< Reserved,                                            Address offset: 0x74 */
       uint32_t RESERVED0x78;              /*!< Reserved,                                            Address offset: 0x78 */
  __IO uint32_t BSEC_OTP_SWLOCK0;          /*!< BSEC OTP Shadow Write Lck under ctrl by sticky bits, Address offset: 0x7C */
  __IO uint32_t BSEC_OTP_SWLOCK1;          /*!< BSEC OTP Shadow Write Lck under ctrl by sticky bits, Address offset: 0x80 */
  __IO uint32_t BSEC_OTP_SWLOCK2;          /*!< BSEC OTP Shadow Write Lck under ctrl by sticky bits, Address offset: 0x84 */
       uint32_t RESERVED0x88;              /*!< Reserved,                                            Address offset: 0x88 */
       uint32_t RESERVED0x8C;              /*!< Reserved,                                            Address offset: 0x8C */
       uint32_t RESERVED0x90;              /*!< Reserved,                                            Address offset: 0x90 */
  __IO uint32_t BSEC_OTP_SRLOCK0;          /*!< BSEC OTP Shadow read lock under ctrl by sticky bits, Address offset: 0x94 */
  __IO uint32_t BSEC_OTP_SRLOCK1;          /*!< BSEC OTP Shadow read lock under ctrl by sticky bits, Address offset: 0x98 */
  __IO uint32_t BSEC_OTP_SRLOCK2;          /*!< BSEC OTP Shadow read lock under ctrl by sticky bits, Address offset: 0x9C */
       uint32_t RESERVED0xA0;              /*!< Reserved,                                            Address offset: 0xA0 */
       uint32_t RESERVED0xA4;              /*!< Reserved,                                            Address offset: 0xA4 */
       uint32_t RESERVED0xA8;              /*!< Reserved,                                            Address offset: 0xA8 */
  __IO uint32_t BSEC_JTAGIN;               /*!< BSEC JTAG Input,                                     Address offset: 0xAC */
  __IO uint32_t BSEC_JTAGOUT;              /*!< BSEC JTAG Output,                                    Address offset: 0xB0 */
  __IO uint32_t BSEC_SCRATCH;              /*!< BSEC SCRATCH,                                        Address offset: 0xB4 */
       uint32_t RESERVED0xB8[82];          /*!< Reserved, 0x0B8-0x200                                Address offset: 0xB8 */
  __IO uint32_t BSEC_OTP_DATA[96];         /*!< BSEC Shadow Registers,                               Address offset: 0x200 */
       uint32_t RESERVED0x380[796];        /*!< Reserved, 0x0380-0xFF0                               Address offset: 0x380 */
  __IO uint32_t IPHW_CFGR;                 /*!< BSEC IP HW Configuration Register,                   Address offset: 0xFF0 */
  __IO uint32_t VER;                       /*!< BSEC IP version Register,                            Address offset: 0xFF4 */
  __IO uint32_t ID;                        /*!< BSEC ID Register,                                    Address offset: 0xFF8 */
  __IO uint32_t SID;                       /*!< BSEC SID Register,                                   Address offset: 0xFFC */
} BSEC_TypeDef;


/**
  * @brief Real-Time Clock
  */

typedef struct
{
    __IO uint32_t TR;             /*!< RTC time register,                                         Address offset: 0x00 */
    __IO uint32_t DR;             /*!< RTC date register,                                         Address offset: 0x04 */
    __IO uint32_t SSR;            /*!< RTC sub-second register,                                   Address offset: 0x08 */
    __IO uint32_t ICSR;           /*!< RTC initialization control and status register,            Address offset: 0x0C */
    __IO uint32_t PRER;           /*!< RTC prescaler register,                                    Address offset: 0x10 */
    __IO uint32_t WUTR;           /*!< RTC wakeup timer register,                                 Address offset: 0x14 */
    __IO uint32_t CR;             /*!< RTC control register,                                      Address offset: 0x18 */
         uint32_t RESERVED;       /*!< Reserved                                                                        */
    __IO uint32_t SMCR;           /*!< RTC secure mode control register,                          Address offset: 0x20 */
    __IO uint32_t WPR;            /*!< RTC write protection register,                             Address offset: 0x24 */
    __IO uint32_t CALR;           /*!< RTC calibration register,                                  Address offset: 0x28 */
    __IO uint32_t SHIFTR;         /*!< RTC shift control register,                                Address offset: 0x2C */
    __IO uint32_t TSTR;           /*!< RTC time stamp time register,                              Address offset: 0x30 */
    __IO uint32_t TSDR;           /*!< RTC time stamp date register,                              Address offset: 0x34 */
    __IO uint32_t TSSSR;           /*!< RTC time stamp sub second register,                        Address offset: 0x38 */
         uint32_t RESERVED1;      /*!< Reserved                                                                        */
    __IO uint32_t ALRMAR;         /*!< RTC alarm A register,                                      Address offset: 0x40 */
    __IO uint32_t ALRMASSR;       /*!< RTC alarm A sub second register,                           Address offset: 0x44 */
    __IO uint32_t ALRMBR;         /*!< RTC alarm B register,                                      Address offset: 0x48 */
    __IO uint32_t ALRMBSSR;       /*!< RTC alarm B sub second register,                           Address offset: 0x4C */
    __IO uint32_t SR;             /*!< RTC status register,                                       Address offset: 0x50 */
    __IO uint32_t MISR;           /*!< RTC masked interrupt status register,                      Address offset: 0x54 */
    __IO uint32_t SMISR;          /*!< RTC secure masked interrupt status register,               Address offset: 0x58 */
    __IO uint32_t SCR;            /*!< RTC status clear register,                                 Address offset: 0x5C */
    __IO uint32_t OR;             /*!< RTC option register,                                       Address offset: 0x60 */
         uint32_t RESERVED2[227]; /*!< Reserved                                                                        */
    __IO uint32_t HWCFGR;         /*!< RTC hardware configuration register,                       Address offset: 0x3F0 */
    __IO uint32_t VERR;            /*!< RTC version register,                                     Address offset: 0x3F4 */
    __IO uint32_t IPIDR;          /*!< RTC identification register,                               Address offset: 0x3F8 */
    __IO uint32_t SIDR;           /*!< RTC size identification register,                          Address offset: 0x3FC */
} RTC_TypeDef;


/**
  * @brief Tamper and Backup registers
  */
typedef struct
{
  __IO uint32_t CR1;           /*!< TAMP tamper control register 1,                         Address offset: 0x00 */
  __IO uint32_t CR2;           /*!< TAMP tamper control register 2,                         Address offset: 0x04 */
       uint32_t RESERVED;      /*!< Reserved                                                                     */
  __IO uint32_t FLTCR;         /*!< TAMP filter control register,                           Address offset: 0x0C */
  __IO uint32_t ATCR;          /*!< TAMP active tamper control register,                    Address offset: 0x10 */
  __IO uint32_t ATSEEDR;       /*!< TAMP active tamper seed register,                       Address offset: 0x14 */
  __IO uint32_t ATOR;          /*!< TAMP active tamper output register,                     Address offset: 0x18 */
       uint32_t RESERVED1;     /*!< Reserved                                                                     */
  __IO uint32_t SMCR;          /*!< TAMP secure mode control register,                      Address offset: 0x20 */
       uint32_t RESERVED2[2];  /*!< Reserved, 0x024 - 0x028                                                      */
  __IO uint32_t IER;           /*!< TAMP interrupt enable register,                         Address offset: 0x2C */
  __IO uint32_t SR;            /*!< TAMP status register,                                   Address offset: 0x30 */
  __IO uint32_t MISR;          /*!< TAMP masked interrupt status register,                  Address offset: 0x34 */
  __IO uint32_t SMISR;         /*!< TAMP secure masked interrupt status register,           Address offset: 0x38 */
  __IO uint32_t SCR;           /*!< TAMP status clear register,                             Address offset: 0x3C */
  __IO uint32_t COUNTR;        /*!< TAMP monotonic counter register,                        Address offset: 0x40 */
  uint32_t RESERVED3[3];       /*!< Reserved, 0x044 - 0x04C                                                      */
  __IO uint32_t OR;            /*!< TAMP option register,                                   Address offset: 0x50 */
  uint32_t RESERVED4[43];      /*!< Reserved, 0x054 - 0x0FC                                                      */
  __IO uint32_t BKP0R;         /*!< TAMP backup register 0,                                 Address offset: 0x100 */
  __IO uint32_t BKP1R;         /*!< TAMP backup register 1,                                 Address offset: 0x104 */
  __IO uint32_t BKP2R;         /*!< TAMP backup register 2,                                 Address offset: 0x108 */
  __IO uint32_t BKP3R;         /*!< TAMP backup register 3,                                 Address offset: 0x10C */
  __IO uint32_t BKP4R;         /*!< TAMP backup register 4,                                 Address offset: 0x110 */
  __IO uint32_t BKP5R;         /*!< TAMP backup register 5,                                 Address offset: 0x114 */
  __IO uint32_t BKP6R;         /*!< TAMP backup register 6,                                 Address offset: 0x118 */
  __IO uint32_t BKP7R;         /*!< TAMP backup register 7,                                 Address offset: 0x11C */
  __IO uint32_t BKP8R;         /*!< TAMP backup register 8,                                 Address offset: 0x120 */
  __IO uint32_t BKP9R;         /*!< TAMP backup register 9,                                 Address offset: 0x124 */
  __IO uint32_t BKP10R;        /*!< TAMP backup register 10,                                Address offset: 0x128 */
  __IO uint32_t BKP11R;        /*!< TAMP backup register 11,                                Address offset: 0x12C */
  __IO uint32_t BKP12R;        /*!< TAMP backup register 12,                                Address offset: 0x130 */
  __IO uint32_t BKP13R;        /*!< TAMP backup register 13,                                Address offset: 0x134 */
  __IO uint32_t BKP14R;        /*!< TAMP backup register 14,                                Address offset: 0x138 */
  __IO uint32_t BKP15R;        /*!< TAMP backup register 15,                                Address offset: 0x13C */
  __IO uint32_t BKP16R;        /*!< TAMP backup register 16,                                Address offset: 0x140 */
  __IO uint32_t BKP17R;        /*!< TAMP backup register 17,                                Address offset: 0x144 */
  __IO uint32_t BKP18R;        /*!< TAMP backup register 18,                                Address offset: 0x148 */
  __IO uint32_t BKP19R;        /*!< TAMP backup register 19,                                Address offset: 0x14C */
  __IO uint32_t BKP20R;        /*!< TAMP backup register 20,                                Address offset: 0x150 */
  __IO uint32_t BKP21R;        /*!< TAMP backup register 21,                                Address offset: 0x154 */
  __IO uint32_t BKP22R;        /*!< TAMP backup register 22,                                Address offset: 0x158 */
  __IO uint32_t BKP23R;        /*!< TAMP backup register 23,                                Address offset: 0x15C */
  __IO uint32_t BKP24R;        /*!< TAMP backup register 24,                                Address offset: 0x160 */
  __IO uint32_t BKP25R;        /*!< TAMP backup register 25,                                Address offset: 0x164 */
  __IO uint32_t BKP26R;        /*!< TAMP backup register 26,                                Address offset: 0x168 */
  __IO uint32_t BKP27R;        /*!< TAMP backup register 27,                                Address offset: 0x16C */
  __IO uint32_t BKP28R;        /*!< TAMP backup register 28,                                Address offset: 0x170 */
  __IO uint32_t BKP29R;        /*!< TAMP backup register 29,                                Address offset: 0x174 */
  __IO uint32_t BKP30R;        /*!< TAMP backup register 30,                                Address offset: 0x178 */
  __IO uint32_t BKP31R;        /*!< TAMP backup register 31,                                Address offset: 0x17C */
  __IO uint32_t BKP32R;        /*!< TAMP backup register 32,                                Address offset: 0x180 */
  __IO uint32_t BKP33R;        /*!< TAMP backup register 33,                                Address offset: 0x184 */
  __IO uint32_t BKP34R;        /*!< TAMP backup register 34,                                Address offset: 0x188 */
  __IO uint32_t BKP35R;        /*!< TAMP backup register 35,                                Address offset: 0x18C */
  __IO uint32_t BKP36R;        /*!< TAMP backup register 36,                                Address offset: 0x190 */
  __IO uint32_t BKP37R;        /*!< TAMP backup register 37,                                Address offset: 0x194 */
  __IO uint32_t BKP38R;        /*!< TAMP backup register 38,                                Address offset: 0x198 */
  __IO uint32_t BKP39R;        /*!< TAMP backup register 39,                                Address offset: 0x19C */
  __IO uint32_t BKP40R;        /*!< TAMP backup register 40,                                Address offset: 0x1A0 */
  __IO uint32_t BKP41R;        /*!< TAMP backup register 41,                                Address offset: 0x1A4 */
  __IO uint32_t BKP42R;        /*!< TAMP backup register 42,                                Address offset: 0x1A8 */
  __IO uint32_t BKP43R;        /*!< TAMP backup register 43,                                Address offset: 0x1AC */
  __IO uint32_t BKP44R;        /*!< TAMP backup register 44,                                Address offset: 0x1B0 */
  __IO uint32_t BKP45R;        /*!< TAMP backup register 45,                                Address offset: 0x1B4 */
  __IO uint32_t BKP46R;        /*!< TAMP backup register 46,                                Address offset: 0x1B8 */
  __IO uint32_t BKP47R;        /*!< TAMP backup register 47,                                Address offset: 0x1BC */
  __IO uint32_t BKP48R;        /*!< TAMP backup register 48,                                Address offset: 0x1C0 */
  __IO uint32_t BKP49R;        /*!< TAMP backup register 49,                                Address offset: 0x1C4 */
  __IO uint32_t BKP50R;        /*!< TAMP backup register 50,                                Address offset: 0x1C8 */
  __IO uint32_t BKP51R;        /*!< TAMP backup register 51,                                Address offset: 0x1CC */
  __IO uint32_t BKP52R;        /*!< TAMP backup register 52,                                Address offset: 0x1D0 */
  __IO uint32_t BKP53R;        /*!< TAMP backup register 53,                                Address offset: 0x1D4 */
  __IO uint32_t BKP54R;        /*!< TAMP backup register 54,                                Address offset: 0x1D8 */
  __IO uint32_t BKP55R;        /*!< TAMP backup register 55,                                Address offset: 0x1DC */
  __IO uint32_t BKP56R;        /*!< TAMP backup register 56,                                Address offset: 0x1E0 */
  __IO uint32_t BKP57R;        /*!< TAMP backup register 57,                                Address offset: 0x1E4 */
  __IO uint32_t BKP58R;        /*!< TAMP backup register 58,                                Address offset: 0x1E8 */
  __IO uint32_t BKP59R;        /*!< TAMP backup register 59,                                Address offset: 0x1EC */
  __IO uint32_t BKP60R;        /*!< TAMP backup register 60,                                Address offset: 0x1F0 */
  __IO uint32_t BKP61R;        /*!< TAMP backup register 61,                                Address offset: 0x1F4 */
  __IO uint32_t BKP62R;        /*!< TAMP backup register 62,                                Address offset: 0x1F8 */
  __IO uint32_t BKP63R;        /*!< TAMP backup register 63,                                Address offset: 0x1FC */
  __IO uint32_t BKP64R;        /*!< TAMP backup register 64,                                Address offset: 0x200 */
  __IO uint32_t BKP65R;        /*!< TAMP backup register 65,                                Address offset: 0x204 */
  __IO uint32_t BKP66R;        /*!< TAMP backup register 66,                                Address offset: 0x208 */
  __IO uint32_t BKP67R;        /*!< TAMP backup register 67,                                Address offset: 0x20C */
  __IO uint32_t BKP68R;        /*!< TAMP backup register 68,                                Address offset: 0x210 */
  __IO uint32_t BKP69R;        /*!< TAMP backup register 69,                                Address offset: 0x214 */
  __IO uint32_t BKP70R;        /*!< TAMP backup register 70,                                Address offset: 0x218 */
  __IO uint32_t BKP71R;        /*!< TAMP backup register 71,                                Address offset: 0x21C */
  __IO uint32_t BKP72R;        /*!< TAMP backup register 72,                                Address offset: 0x220 */
  __IO uint32_t BKP73R;        /*!< TAMP backup register 73,                                Address offset: 0x224 */
  __IO uint32_t BKP74R;        /*!< TAMP backup register 74,                                Address offset: 0x228 */
  __IO uint32_t BKP75R;        /*!< TAMP backup register 75,                                Address offset: 0x22C */
  __IO uint32_t BKP76R;        /*!< TAMP backup register 76,                                Address offset: 0x230 */
  __IO uint32_t BKP77R;        /*!< TAMP backup register 77,                                Address offset: 0x234 */
  __IO uint32_t BKP78R;        /*!< TAMP backup register 78,                                Address offset: 0x238 */
  __IO uint32_t BKP79R;        /*!< TAMP backup register 79,                                Address offset: 0x23C */
  __IO uint32_t BKP80R;        /*!< TAMP backup register 80,                                Address offset: 0x240 */
  __IO uint32_t BKP81R;        /*!< TAMP backup register 81,                                Address offset: 0x244 */
  __IO uint32_t BKP82R;        /*!< TAMP backup register 82,                                Address offset: 0x248 */
  __IO uint32_t BKP83R;        /*!< TAMP backup register 83,                                Address offset: 0x24C */
  __IO uint32_t BKP84R;        /*!< TAMP backup register 84,                                Address offset: 0x250 */
  __IO uint32_t BKP85R;        /*!< TAMP backup register 85,                                Address offset: 0x254 */
  __IO uint32_t BKP86R;        /*!< TAMP backup register 86,                                Address offset: 0x258 */
  __IO uint32_t BKP87R;        /*!< TAMP backup register 87,                                Address offset: 0x25C */
  __IO uint32_t BKP88R;        /*!< TAMP backup register 88,                                Address offset: 0x260 */
  __IO uint32_t BKP89R;        /*!< TAMP backup register 89,                                Address offset: 0x264 */
  __IO uint32_t BKP90R;        /*!< TAMP backup register 90,                                Address offset: 0x268 */
  __IO uint32_t BKP91R;        /*!< TAMP backup register 91,                                Address offset: 0x26C */
  __IO uint32_t BKP92R;        /*!< TAMP backup register 92,                                Address offset: 0x270 */
  __IO uint32_t BKP93R;        /*!< TAMP backup register 93,                                Address offset: 0x274 */
  __IO uint32_t BKP94R;        /*!< TAMP backup register 94,                                Address offset: 0x278 */
  __IO uint32_t BKP95R;        /*!< TAMP backup register 95,                                Address offset: 0x27C */
  __IO uint32_t BKP96R;        /*!< TAMP backup register 96,                                Address offset: 0x280 */
  __IO uint32_t BKP97R;        /*!< TAMP backup register 97,                                Address offset: 0x284 */
  __IO uint32_t BKP98R;        /*!< TAMP backup register 98,                                Address offset: 0x288 */
  __IO uint32_t BKP99R;        /*!< TAMP backup register 99,                                Address offset: 0x28C */
  __IO uint32_t BKP100R;       /*!< TAMP backup register 100,                               Address offset: 0x290 */
  __IO uint32_t BKP101R;       /*!< TAMP backup register 101,                               Address offset: 0x294 */
  __IO uint32_t BKP102R;       /*!< TAMP backup register 102,                               Address offset: 0x298 */
  __IO uint32_t BKP103R;       /*!< TAMP backup register 103,                               Address offset: 0x29C */
  __IO uint32_t BKP104R;       /*!< TAMP backup register 104,                               Address offset: 0x2A0 */
  __IO uint32_t BKP105R;       /*!< TAMP backup register 105,                               Address offset: 0x2A4 */
  __IO uint32_t BKP106R;       /*!< TAMP backup register 106,                               Address offset: 0x2A8 */
  __IO uint32_t BKP107R;       /*!< TAMP backup register 107,                               Address offset: 0x2AC */
  __IO uint32_t BKP108R;       /*!< TAMP backup register 108,                               Address offset: 0x2B0 */
  __IO uint32_t BKP109R;       /*!< TAMP backup register 109,                               Address offset: 0x2B4 */
  __IO uint32_t BKP110R;       /*!< TAMP backup register 110,                               Address offset: 0x2B8 */
  __IO uint32_t BKP111R;       /*!< TAMP backup register 111,                               Address offset: 0x2BC */
  __IO uint32_t BKP112R;       /*!< TAMP backup register 112,                               Address offset: 0x2C0 */
  __IO uint32_t BKP113R;       /*!< TAMP backup register 113,                               Address offset: 0x2C4 */
  __IO uint32_t BKP114R;       /*!< TAMP backup register 114,                               Address offset: 0x2C8 */
  __IO uint32_t BKP115R;       /*!< TAMP backup register 115,                               Address offset: 0x2CC */
  __IO uint32_t BKP116R;       /*!< TAMP backup register 116,                               Address offset: 0x2D0 */
  __IO uint32_t BKP117R;       /*!< TAMP backup register 117,                               Address offset: 0x2D4 */
  __IO uint32_t BKP118R;       /*!< TAMP backup register 118,                               Address offset: 0x2D8 */
  __IO uint32_t BKP119R;       /*!< TAMP backup register 119,                               Address offset: 0x2DC */
  __IO uint32_t BKP120R;       /*!< TAMP backup register 120,                               Address offset: 0x2E0 */
  __IO uint32_t BKP121R;       /*!< TAMP backup register 121,                               Address offset: 0x2E4 */
  __IO uint32_t BKP122R;       /*!< TAMP backup register 122,                               Address offset: 0x2E8 */
  __IO uint32_t BKP123R;       /*!< TAMP backup register 123,                               Address offset: 0x2EC */
  __IO uint32_t BKP124R;       /*!< TAMP backup register 124,                               Address offset: 0x2F0 */
  __IO uint32_t BKP125R;       /*!< TAMP backup register 125,                               Address offset: 0x2F4 */
  __IO uint32_t BKP126R;       /*!< TAMP backup register 126,                               Address offset: 0x2F8 */
  __IO uint32_t BKP127R;       /*!< TAMP backup register 127,                               Address offset: 0x2FC */
       uint32_t RESERVED5[59]; /*!< Reserved, 0x0300 - 0x3E8                                                      */
  __IO uint32_t HWCFGR2;        /*!< TAMP hardware configuration register,                  Address offset: 0x3EC */
  __IO uint32_t HWCFGR1;        /*!< TAMP hardware configuration register,                  Address offset: 0x3F0 */
  __IO uint32_t VERR;           /*!< TAMP version register,                                 Address offset: 0x3F4 */
  __IO uint32_t IPIDR;          /*!< TAMP identification register,                          Address offset: 0x3F8 */
  __IO uint32_t SIDR;           /*!< TAMP size identification register,                     Address offset: 0x3FC */

} TAMP_TypeDef;



/**
  * @brief Serial Audio Interface
  */

typedef struct
{
  __IO uint32_t GCR;           /*!< SAI global configuration register, Address offset: 0x00  */
  uint32_t      RESERVED0[16]; /*!< Reserved, 0x04 - 0x43                                    */
  __IO uint32_t PDMCR;         /*!< SAI PDM control register,          Address offset: 0x44  */
  __IO uint32_t PDMDLY;        /*!< SAI PDM delay register,            Address offset: 0x48  */
  uint32_t      RESERVED1[233]; /*!< Reserved, 0x4C - 0x3EC                                  */
  __IO uint32_t HWCFGR;        /*!< SAI HW Configuration register,     Address offset: 0x3F0 */
  __IO uint32_t VERR;          /*!< SAI PVersion register,             Address offset: 0x3F4 */
  __IO uint32_t IDR;           /*!< SAI Identification register,       Address offset: 0x3F8 */
  __IO uint32_t SIDR;          /*!< SAI Size Identification register,  Address offset: 0x3FC */
} SAI_TypeDef;

typedef struct
{
  __IO uint32_t CR1;      /*!< SAI block x configuration register 1,     Address offset: 0x04 */
  __IO uint32_t CR2;      /*!< SAI block x configuration register 2,     Address offset: 0x08 */
  __IO uint32_t FRCR;     /*!< SAI block x frame configuration register, Address offset: 0x0C */
  __IO uint32_t SLOTR;    /*!< SAI block x slot register,                Address offset: 0x10 */
  __IO uint32_t IMR;      /*!< SAI block x interrupt mask register,       Address offset: 0x14 */
  __IO uint32_t SR;       /*!< SAI block x status register,              Address offset: 0x18 */
  __IO uint32_t CLRFR;    /*!< SAI block x clear flag register,          Address offset: 0x1C */
  __IO uint32_t DR;       /*!< SAI block x data register,                Address offset: 0x20 */
} SAI_Block_TypeDef;



/**
  * @brief  Process Monitor Block
  */

typedef struct
{
  uint32_t Reserved;            /*!< Reserved, Address offset: 0x00 */
  __IO uint32_t SENS_CTRL;      /*!< PMB Sensor control,         Address offset: 0x04 */
  __IO uint32_t REF_COUNTER;    /*!< PMB Reference counter,      Address offset: 0x08 */
  __IO uint32_t SENSOR_STATUS;  /*!< PMB Sensor Status,          Address offset: 0x0C */
}PMB_TypeDef;


/**
  * @brief SPDIF-RX Interface
  */

typedef struct
{
  __IO uint32_t   CR;           /*!< Control register,                      Address offset: 0x00 */
  __IO uint32_t   IMR;          /*!< Interrupt mask register,               Address offset: 0x04 */
  __IO uint32_t   SR;           /*!< Status register,                       Address offset: 0x08 */
  __IO uint32_t   IFCR;         /*!< Interrupt Flag Clear register,         Address offset: 0x0C */
  __IO uint32_t   DR;           /*!< Data input register,                   Address offset: 0x10 */
  __IO uint32_t   CSR;          /*!< Channel Status register,               Address offset: 0x14 */
  __IO uint32_t   DIR;          /*!< Debug Information register,            Address offset: 0x18 */
  uint32_t        RESERVED2[246];   /*!< Reserved,                                0x1C   - 0x3F0 */
  __IO uint32_t   VERR;         /*!< SPDIFRX version register,             Address offset: 0x3F4 */
  __IO uint32_t   IDR;          /*!< SPDIFRX Identificationn register,     Address offset: 0x3F8 */
  __IO uint32_t   SIDR;         /*!< SPDIFRX Size Identification register, Address offset: 0x3FC */
} SPDIFRX_TypeDef;


/**
  * @brief Secure digital input/output Interface
  */

typedef struct
{
  __IO uint32_t POWER;          /*!< SDMMC power control register,             Address offset: 0x00 */
  __IO uint32_t CLKCR;          /*!< SDMMC clock control register,             Address offset: 0x04 */
  __IO uint32_t ARG;            /*!< SDMMC argument register,                  Address offset: 0x08 */
  __IO uint32_t CMD;            /*!< SDMMC command register,                   Address offset: 0x0C */
  __I uint32_t  RESPCMD;        /*!< SDMMC command response register,          Address offset: 0x10 */
  __I uint32_t  RESP1;          /*!< SDMMC response 1 register,                Address offset: 0x14 */
  __I uint32_t  RESP2;          /*!< SDMMC response 2 register,                Address offset: 0x18 */
  __I uint32_t  RESP3;          /*!< SDMMC response 3 register,                Address offset: 0x1C */
  __I uint32_t  RESP4;          /*!< SDMMC response 4 register,                Address offset: 0x20 */
  __IO uint32_t DTIMER;         /*!< SDMMC data timer register,                Address offset: 0x24 */
  __IO uint32_t DLEN;           /*!< SDMMC data length register,               Address offset: 0x28 */
  __IO uint32_t DCTRL;          /*!< SDMMC data control register,              Address offset: 0x2C */
  __I uint32_t  DCOUNT;         /*!< SDMMC data counter register,              Address offset: 0x30 */
  __I uint32_t  STA;            /*!< SDMMC status register,                    Address offset: 0x34 */
  __IO uint32_t ICR;            /*!< SDMMC interrupt clear register,           Address offset: 0x38 */
  __IO uint32_t MASK;           /*!< SDMMC mask register,                      Address offset: 0x3C */
  __IO uint32_t ACKTIME;        /*!< SDMMC Acknowledgement timer register,     Address offset: 0x40 */
  uint32_t      RESERVED0[3];   /*!< Reserved, 0x44 - 0x4C - 0x4C                                   */
  __IO uint32_t IDMACTRL;       /*!< SDMMC DMA control register,               Address offset: 0x50 */
  __IO uint32_t IDMABSIZE;      /*!< SDMMC DMA buffer size register,           Address offset: 0x54 */
  __IO uint32_t IDMABASE0;      /*!< SDMMC DMA buffer 0 base address register, Address offset: 0x58 */
  __IO uint32_t IDMABASE1;      /*!< SDMMC DMA buffer 1 base address register, Address offset: 0x5C */
  uint32_t      RESERVED1[1];   /*!< Reserved, 0x60                                            */
  __IO uint32_t IDMALAR;        /*!< SDMMC DMA linked list address register,   Address offset: 0x64 */
  __IO uint32_t IDMABAR;        /*!< SDMMC DMA linked list memory base register, Address offset: 0x68 */
  uint32_t      RESERVED2[5];   /*!< Reserved, 0x6C-0x7C                                            */
  __IO uint32_t FIFO;           /*!< SDMMC data FIFO register,               Address offset: 0x80 - 0xBC */
  uint32_t      RESERVED3[220]; /*!< Reserved, 0xBC-0x3F4                                           */
  __IO uint32_t VERR;           /*!< SDMMC version register,                  Address offset: 0x3F4 */
  __IO uint32_t IPIDR;           /*!< SDMMC identification register,          Address offset: 0x3F8 */
  __IO uint32_t SIDR;           /*!< SDMMCsize ID register,                   Address offset: 0x3FC */
} SDMMC_TypeDef;


/**
  * @brief Delay Block DLYB
  */

typedef struct
{
  __IO uint32_t CR;          /*!< DELAY BLOCK control register,          Address offset: 0x00 */
  __IO uint32_t CFGR;        /*!< DELAY BLOCK configuration register,    Address offset: 0x04 */
  uint32_t  Reserved[249];   /* Reserved                         Address offset: 0x08 - 0x3F0 */
  __IO uint32_t VERR;        /*!< DELAY BLOCK Version register,         Address offset: 0x3F4 */
  __IO uint32_t IPIDR;       /*!< DELAY BLOCK Identification register,  Address offset: 0x3F8 */
  __IO uint32_t SIDR;        /*!< DELAY BLOCK Size ID register,         Address offset: 0x3FC */
} DLYB_TypeDef;

/**
  * @brief HW Semaphore HSEM
  */

typedef struct
{
  __IO uint32_t R[32];      /*!< 2-step write lock and read back registers,     Address offset: 00h-7Ch  */
  __IO uint32_t RLR[32];    /*!< 1-step read lock registers,                    Address offset: 80h-FCh  */
  __IO uint32_t C1IER;      /*!< HSEM Interrupt 0 enable register ,             Address offset: 100h     */
  __IO uint32_t C1ICR;      /*!< HSEM Interrupt 0 clear register ,              Address offset: 104h     */
  __IO uint32_t C1ISR;      /*!< HSEM Interrupt 0 Status register ,             Address offset: 108h     */
  __IO uint32_t C1MISR;     /*!< HSEM Interrupt 0 Masked Status register ,      Address offset: 10Ch     */
  __IO uint32_t C2IER;      /*!< HSEM Interrupt 1 enable register ,             Address offset: 110h     */
  __IO uint32_t C2ICR;      /*!< HSEM Interrupt 1 clear register ,              Address offset: 114h     */
  __IO uint32_t C2ISR;      /*!< HSEM Interrupt 1 Status register ,             Address offset: 118h     */
  __IO uint32_t C2MISR;     /*!< HSEM Interrupt 1 Masked Status register ,      Address offset: 11Ch     */
   uint32_t  Reserved[8];        /* Reserved                                         Address offset: 120h-13Ch*/
  __IO uint32_t CR;         /*!< HSEM Semaphore clear register ,                Address offset: 140h      */
  __IO uint32_t KEYR;       /*!< HSEM Semaphore clear key register ,            Address offset: 144h      */
  uint32_t  Reserved1[169];      /* Reserved                                         Address offset: 148h-3E8h */
  __IO uint32_t HWCFGR2;    /*!< HSEM Hardware Configuration Register 2 ,       Address offset: 3ECh      */
  __IO uint32_t HWCFGR1;    /*!< HSEM Hardware Configuration Register 1 ,       Address offset: 3F0h      */
  __IO uint32_t VERR;       /*!< HSEM IP Version Register ,                     Address offset: 3F4h      */
  __IO uint32_t IPIDR;      /*!< HSEM IP Identification Register ,              Address offset: 3F8h      */
  __IO uint32_t SIDR;      /*!< HSEM Size Identification Register ,             Address offset: 3FCh      */
} HSEM_TypeDef;

typedef struct
{
  __IO uint32_t IER;        /*!< HSEM interrupt enable register ,                Address offset:   0h     */
  __IO uint32_t ICR;        /*!< HSEM interrupt clear register ,                 Address offset:   4h     */
  __IO uint32_t ISR;        /*!< HSEM interrupt status register ,                Address offset:   8h     */
  __IO uint32_t MISR;       /*!< HSEM masked interrupt status register ,         Address offset:   Ch     */
} HSEM_Common_TypeDef;

/**
  * @brief Serial Peripheral Interface
  */

typedef struct
{
  __IO uint32_t CR1;          /*!< SPI Control register 1,                             Address offset: 0x00 */
  __IO uint32_t CR2;          /*!< SPI Control register 2,                             Address offset: 0x04 */
  __IO uint32_t CFG1;         /*!< SPI Status register,                                Address offset: 0x08 */
  __IO uint32_t CFG2;         /*!< SPI Status register,                                Address offset: 0x0C */
  __IO uint32_t IER;          /*!< SPI data register,                                  Address offset: 0x10 */
  __IO uint32_t SR;           /*!< SPI data register,                                  Address offset: 0x14 */
  __IO uint32_t IFCR;         /*!< SPI data register,                                  Address offset: 0x18 */
  uint32_t      RESERVED0;    /*!< SPI data register,                                  Address offset: 0x1C */
  __IO uint32_t TXDR;         /*!< SPI data register,                                  Address offset: 0x20 */
  uint32_t      RESERVED1[3]; /*!< Reserved, 0x24-0x2C                                                      */
  __IO uint32_t RXDR;         /*!< SPI data register,                                  Address offset: 0x30 */
  uint32_t      RESERVED2[3]; /*!< Reserved, 0x34-0x3C                                                      */
  __IO uint32_t CRCPOLY;     /*!< SPI data register,                                   Address offset: 0x40 */
  __IO uint32_t TXCRC;       /*!< SPI data register,                                   Address offset: 0x44 */
  __IO uint32_t RXCRC;       /*!< SPI data register,                                   Address offset: 0x48 */
  __IO uint32_t UDRDR;       /*!< SPI data register,                                   Address offset: 0x4C */
  __IO uint32_t I2SCFGR;     /*!< SPI data register,                                   Address offset: 0x50 */
  uint32_t      RESERVED3[231]; /*!< Reserved, 0x54-0x3EC                                                   */
  __IO uint32_t HWCFGR;       /*!< SPI HW Configuration register,                     Address offset: 0x3F0 */
  __IO uint32_t VERR;         /*!< SPI Version register,                              Address offset: 0x3F4 */
  __IO uint32_t IPIDR;        /*!< SPI identification register,                       Address offset: 0x3F8 */
  __IO uint32_t SIDR;         /*!< SPI Size Identification register,                  Address offset: 0x3FC */
} SPI_TypeDef;

/**
  * @brief QUAD Serial Peripheral Interface
  */

typedef struct
{
  __IO uint32_t CR;       /*!< QUADSPI Control register,                           Address offset: 0x00 */
  __IO uint32_t DCR;      /*!< QUADSPI Device Configuration register,              Address offset: 0x04 */
  __IO uint32_t SR;       /*!< QUADSPI Status register,                            Address offset: 0x08 */
  __IO uint32_t FCR;      /*!< QUADSPI Flag Clear register,                        Address offset: 0x0C */
  __IO uint32_t DLR;      /*!< QUADSPI Data Length register,                       Address offset: 0x10 */
  __IO uint32_t CCR;      /*!< QUADSPI Communication Configuration register,       Address offset: 0x14 */
  __IO uint32_t AR;       /*!< QUADSPI Address register,                           Address offset: 0x18 */
  __IO uint32_t ABR;      /*!< QUADSPI Alternate Bytes register,                   Address offset: 0x1C */
  __IO uint32_t DR;       /*!< QUADSPI Data register,                              Address offset: 0x20 */
  __IO uint32_t PSMKR;    /*!< QUADSPI Polling Status Mask register,               Address offset: 0x24 */
  __IO uint32_t PSMAR;    /*!< QUADSPI Polling Status Match register,              Address offset: 0x28 */
  __IO uint32_t PIR;      /*!< QUADSPI Polling Interval register,                  Address offset: 0x2C */
  __IO uint32_t LPTR;     /*!< QUADSPI Low Power Timeout register,                 Address offset: 0x30 */
  uint32_t      RESERVED[239]; /*!< Reserved, 0x34-0x3EC                                                */
  __IO uint32_t HWCFGR;   /*!< QUADSPI HW configuration register,                  Address offset: 0x3F0*/
  __IO uint32_t VERR;     /*!< QUADSPI version register,                           Address offset: 0x3F4*/
  __IO uint32_t IPIDR;    /*!< QUADSPI dentification register,                     Address offset: 0x3F8*/
  __IO uint32_t SIDR;    /*!< QUADSPI size identification register,                Address offset: 0x3FC*/
} QUADSPI_TypeDef;

/**
  * @brief Temperature Sensor
  */
/* TMPSENS has been renamed in DTS*/
typedef struct
{
  __IO uint32_t CFGR1;    /*!< Temperature Sensor Configuration Register 1,         Address offset: 0x00 */
  uint32_t RESERVED0;     /*!< Reserved,                                            Address offset: 0x04 */
  __IO uint32_t T0VALR1;  /*!< Temperature sensor T0 Value Register 1,              Address offset: 0x08 */
  uint32_t RESERVED1;     /*!< Reserved,                                            Address offset: 0x0C */
  __IO uint32_t RAMPVALR; /*!< Temperature sensor Ramp Value Register,              Address offset: 0x10 */
  __IO uint32_t ITR1;     /*!< Temperature sensor Interrupt Threshold Register 1,   Address offset: 0x14 */
  uint32_t RESERVED2;     /*!< Reserved,                                            Address offset: 0x18 */
  __IO uint32_t DR;       /*!< Temperature sensor Data Register,                    Address offset: 0x1C */
  __IO uint32_t SR;       /*!< Temperature sensor Status Register,                  Address offset: 0x20 */
  __IO uint32_t ITENR;    /*!< Temperature sensor Interrupt Enable Register,        Address offset: 0x24 */
  __IO uint32_t ICIFR;    /*!< Temperature sensor clear interrupt flag register,    Address offset: 0x28 */
  __IO uint32_t OR;       /*!< Temperature sensor option register,                  Address offset: 0x2C */
}DTS_TypeDef;

/**
  * @brief TIM
  */

typedef struct
{
  __IO uint16_t CR1;         /*!< TIM control register 1,                   Address offset: 0x00 */
  uint16_t      RESERVED0;   /*!< Reserved, 0x02                                                 */
  __IO uint32_t CR2;         /*!< TIM control register 2,                   Address offset: 0x04 */
  __IO uint32_t SMCR;        /*!< TIM slave mode control register,          Address offset: 0x08 */
  __IO uint32_t DIER;        /*!< TIM DMA/interrupt enable register,        Address offset: 0x0C */
  __IO uint32_t SR;          /*!< TIM status register,                      Address offset: 0x10 */
  __IO uint32_t EGR;         /*!< TIM event generation register,            Address offset: 0x14 */
  __IO uint32_t CCMR1;       /*!< TIM capture/compare mode register 1,      Address offset: 0x18 */
  __IO uint32_t CCMR2;       /*!< TIM capture/compare mode register 2,      Address offset: 0x1C */
  __IO uint32_t CCER;        /*!< TIM capture/compare enable register,      Address offset: 0x20 */
  __IO uint32_t CNT;         /*!< TIM counter register,                     Address offset: 0x24 */
  __IO uint16_t PSC;         /*!< TIM prescaler,                            Address offset: 0x28 */
  uint16_t      RESERVED9;   /*!< Reserved, 0x2A                                                 */
  __IO uint32_t ARR;         /*!< TIM auto-reload register,                 Address offset: 0x2C */
  __IO uint16_t RCR;         /*!< TIM repetition counter register,          Address offset: 0x30 */
  uint16_t      RESERVED10;  /*!< Reserved, 0x32                                                 */
  __IO uint32_t CCR1;        /*!< TIM capture/compare register 1,           Address offset: 0x34 */
  __IO uint32_t CCR2;        /*!< TIM capture/compare register 2,           Address offset: 0x38 */
  __IO uint32_t CCR3;        /*!< TIM capture/compare register 3,           Address offset: 0x3C */
  __IO uint32_t CCR4;        /*!< TIM capture/compare register 4,           Address offset: 0x40 */
  __IO uint32_t BDTR;        /*!< TIM break and dead-time register,         Address offset: 0x44 */
  __IO uint16_t DCR;         /*!< TIM DMA control register,                 Address offset: 0x48 */
  uint16_t      RESERVED12;  /*!< Reserved, 0x4A                                                 */
  __IO uint16_t DMAR;        /*!< TIM DMA address for full transfer,        Address offset: 0x4C */
  uint16_t      RESERVED13;  /*!< Reserved, 0x4E                                                 */
  uint16_t      RESERVED14;  /*!< Reserved, 0x50                                                 */
  __IO uint32_t CCMR3;       /*!< TIM capture/compare mode register 3,      Address offset: 0x54 */
  __IO uint32_t CCR5;        /*!< TIM capture/compare register5,            Address offset: 0x58 */
  __IO uint32_t CCR6;        /*!< TIM capture/compare register6,            Address offset: 0x5C */
  __IO uint32_t AF1;         /*!< TIM alternate function option register 1, Address offset: 0x60 */
  __IO uint32_t AF2;         /*!< TIM alternate function option register 2, Address offset: 0x64 */
  __IO uint32_t TISEL;       /*!< TIM Input Selection register,             Address offset: 0x68 */
  uint32_t  RESERVED2[226];  /*!< Reserved,                                           0x6C-0x3F0 */
  __IO uint32_t VERR;        /*!< TIM version register,                    Address offset: 0x3F4 */
  __IO uint32_t IPIDR;       /*!< TIM Identification register,             Address offset: 0x3F8 */
  __IO uint32_t SIDR;        /*!< TIM Size Identification register,        Address offset: 0x3FC */
} TIM_TypeDef;

/**
  * @brief LPTIMIMER
  */
typedef struct
{
  __IO uint32_t ISR;      /*!< LPTIM Interrupt and Status register,                Address offset: 0x00 */
  __IO uint32_t ICR;      /*!< LPTIM Interrupt Clear register,                     Address offset: 0x04 */
  __IO uint32_t IER;      /*!< LPTIM Interrupt Enable register,                    Address offset: 0x08 */
  __IO uint32_t CFGR;     /*!< LPTIM Configuration register,                       Address offset: 0x0C */
  __IO uint32_t CR;       /*!< LPTIM Control register,                             Address offset: 0x10 */
  __IO uint32_t CMP;      /*!< LPTIM Compare register,                             Address offset: 0x14 */
  __IO uint32_t ARR;      /*!< LPTIM Autoreload register,                          Address offset: 0x18 */
  __IO uint32_t CNT;      /*!< LPTIM Counter register,                             Address offset: 0x1C */
  uint16_t  RESERVED1;    /*!< Reserved, 0x20                                                 */
  __IO uint32_t CFGR2;    /*!< LPTIM Option register,                              Address offset: 0x24 */
  uint32_t  RESERVED2[242];    /*!< Reserved, 0x28-0x3EC                                                */
  __IO uint32_t HWCFGR;   /*!< LPTIM HW configuration register,                    Address offset: 0x3F0 */
  __IO uint32_t VERR;     /*!< LPTIM version register,                             Address offset: 0x3F4 */
  __IO uint32_t PIDR;     /*!< LPTIM Identification register,                      Address offset: 0x3F8 */
  __IO uint32_t SIDR;     /*!< LPTIM Size Identification register,                 Address offset: 0x3FC */
} LPTIM_TypeDef;

/**
  * @brief Comparator
  */
typedef struct
{
  __IO uint32_t SR;        /*!< Comparator status register,                    Address offset: 0x00 */
  __IO uint32_t ICFR;      /*!< Comparator interrupt clear flag register,      Address offset: 0x04 */
  __IO uint32_t OR;        /*!< Comparator option register,                    Address offset: 0x08 */
} COMPOPT_TypeDef;

typedef struct
{
  __IO uint32_t CFGR;      /*!< Comparator configuration register  ,           Address offset: 0x00 */
} COMP_TypeDef;

typedef struct
{
  __IO uint32_t CFGR;       /*!< COMP control and status register, used for bits common to several COMP instances, Address offset: 0x00 */
} COMP_Common_TypeDef;
/**
  * @brief Universal Synchronous Asynchronous Receiver Transmitter
  */

typedef struct
{
  __IO uint32_t CR1;    /*!< USART Control register 1,                 Address offset: 0x00 */
  __IO uint32_t CR2;    /*!< USART Control register 2,                 Address offset: 0x04 */
  __IO uint32_t CR3;    /*!< USART Control register 3,                 Address offset: 0x08 */
  __IO uint32_t BRR;    /*!< USART Baud rate register,                 Address offset: 0x0C */
  __IO uint16_t GTPR;   /*!< USART Guard time and prescaler register,  Address offset: 0x10 */
  uint16_t  RESERVED2;  /*!< Reserved, 0x12                                                 */
  __IO uint32_t RTOR;   /*!< USART Receiver Time Out register,         Address offset: 0x14 */
  __IO uint16_t RQR;    /*!< USART Request register,                   Address offset: 0x18 */
  uint16_t  RESERVED3;  /*!< Reserved, 0x1A                                                 */
  __IO uint32_t ISR;    /*!< USART Interrupt and status register,      Address offset: 0x1C */
  __IO uint32_t ICR;    /*!< USART Interrupt flag Clear register,      Address offset: 0x20 */
  __IO uint16_t RDR;    /*!< USART Receive Data register,              Address offset: 0x24 */
  uint16_t  RESERVED4;  /*!< Reserved, 0x26                                                 */
  __IO uint16_t TDR;    /*!< USART Transmit Data register,             Address offset: 0x28 */
  uint16_t  RESERVED5;  /*!< Reserved, 0x2A                                                 */
  __IO uint32_t PRESC;  /*!< USART clock Prescaler register,           Address offset: 0x2C */
  uint32_t  RESERVED6[239];  /*!< Reserved,                                    0x30 - 0x3E8 */
  __IO uint32_t HWCFGR2;  /*!< USART Configuration2 register,          Address offset: 0x3EC */
  __IO uint32_t HWCFGR1;  /*!< USART Configuration1 register,          Address offset: 0x3F0 */
  __IO uint32_t VERR;   /*!< USART Version register,                   Address offset: 0x3F4 */
  __IO uint32_t IPIDR;  /*!< USART Identification register,            Address offset: 0x3F8 */
  __IO uint32_t SIDR;   /*!< USART clock Size Identification register, Address offset: 0x3FC */

} USART_TypeDef;

/**
  * @brief Single Wire Protocol Master Interface SPWMI
  */
typedef struct
{
  __IO uint32_t CR;          /*!< SWPMI Configuration/Control register,     Address offset: 0x00 */
  __IO uint32_t BRR;         /*!< SWPMI bitrate register,                   Address offset: 0x04 */
    uint32_t  RESERVED1;     /*!< Reserved, 0x08                                                 */
  __IO uint32_t ISR;         /*!< SWPMI Interrupt and Status register,      Address offset: 0x0C */
  __IO uint32_t ICR;         /*!< SWPMI Interrupt Flag Clear register,      Address offset: 0x10 */
  __IO uint32_t IER;         /*!< SWPMI Interrupt Enable register,          Address offset: 0x14 */
  __IO uint32_t RFL;         /*!< SWPMI Receive Frame Length register,      Address offset: 0x18 */
  __IO uint32_t TDR;         /*!< SWPMI Transmit data register,             Address offset: 0x1C */
  __IO uint32_t RDR;         /*!< SWPMI Receive data register,              Address offset: 0x20 */
  __IO uint32_t OR;          /*!< SWPMI Option register,                    Address offset: 0x24 */
} SWPMI_TypeDef;

/**
  * @brief Window WATCHDOG
  */

typedef struct
{
  __IO uint32_t CR;      /*!< WWDG Control register,        Address offset:  0x00 */
  __IO uint32_t CFR;     /*!< WWDG Configuration register,  Address offset:  0x04 */
  __IO uint32_t SR;      /*!< WWDG Status register,         Address offset:  0x08 */
  uint32_t  RESERVED1[249];   /*!< Reserved,                         0x0C - 0x3EC */
  __IO uint32_t HWCFGR;  /*!< WWDG HW Config register,      Address offset: 0x3F0 */
  __IO uint32_t VERR;    /*!< WWDG Version register,        Address offset: 0x3F4 */
  __IO uint32_t IPIDR;   /*!< WWDG Identification register, Address offset: 0x3F8 */
  __IO uint32_t SIDR;    /*!< WWDG Size ID register,        Address offset: 0x3FC */

} WWDG_TypeDef;
/**
  * @brief HASH
  */

typedef struct
{
  __IO uint32_t CR;               /*!< HASH control register,          Address offset: 0x00        */
  __IO uint32_t DIN;              /*!< HASH data input register,       Address offset: 0x04        */
  __IO uint32_t STR;              /*!< HASH start register,            Address offset: 0x08        */
  __IO uint32_t HR[5];            /*!< HASH digest registers,          Address offset: 0x0C-0x1C   */
  __IO uint32_t IMR;              /*!< HASH interrupt enable register, Address offset: 0x20        */
  __IO uint32_t SR;               /*!< HASH status register,           Address offset: 0x24        */
       uint32_t RESERVED[52];     /*!< Reserved, 0x28-0xF4                                         */
  __IO uint32_t CSR[54];          /*!< HASH context swap registers,    Address offset: 0x0F8-0x1CC */
       uint32_t RESERVED2[80];
  __IO uint32_t HR2[8];
       uint32_t RESERVED3[48];
  __IO uint32_t HWCFGR;           /*!< HASH Hardware configuration register, Address offset: 0x3F0 */
  __IO uint32_t VER;           /*!< HASH Version register,                   Address offset: 0x3F4 */
  __IO uint32_t ID;           /*!< HASH identification register,             Address offset: 0x3F8 */
  __IO uint32_t MID;           /*!< HASH Hardware Magic ID register,         Address offset: 0x3FC */
} HASH_TypeDef;

/**
  * @brief HASH_DIGEST
  */

typedef struct
{
  __IO uint32_t HR[8];     /*!< HASH digest registers,          Address offset: 0x310-0x32C */
} HASH_DIGEST_TypeDef;


/**
  * @brief RNG
  */

typedef struct
{
  __IO uint32_t CR;      /*!< RNG control register,             Address offset: 0x00  */
  __IO uint32_t SR;      /*!< RNG status register,              Address offset: 0x04  */
  __IO uint32_t DR;      /*!< RNG data register,                Address offset: 0x08  */
  __IO uint32_t RESERVED1[249];   /*!< Reserved                 0x0C - 0x3EC          */
  __IO uint32_t HWCFGR;  /*!< RNG HW Configuration register,    Address offset: 0x3F0 */
  __IO uint32_t VER;     /*!< RNG Version register,             Address offset: 0x3F4 */
  __IO uint32_t ID;      /*!< RNG identification register,      Address offset: 0x3F8 */
  __IO uint32_t MID;     /*!< RNG HW magic ID,                  Address offset: 0x3FC */
} RNG_TypeDef;

/**
  * @brief Inter-Processor Communication
  */
typedef struct
{
  __IO uint32_t C1CR;             /*!< Inter-Processor Communication: C1 control register,                  Address offset: 0x000 */
  __IO uint32_t C1MR ;            /*!< Inter-Processor Communication: C1 mask register,                     Address offset: 0x004 */
  __IO uint32_t C1SCR;            /*!< Inter-Processor Communication: C1 status set clear register,         Address offset: 0x008 */
  __IO uint32_t C1TOC2SR;         /*!< Inter-Processor Communication: C1 to processor M4  status register,  Address offset: 0x00C */
  __IO uint32_t C2CR;             /*!< Inter-Processor Communication: C2 control register,                  Address offset: 0x010 */
  __IO uint32_t C2MR ;            /*!< Inter-Processor Communication: C2 mask register,                     Address offset: 0x014 */
  __IO uint32_t C2SCR;            /*!< Inter-Processor Communication: C2 status set clear register,         Address offset: 0x018 */
  __IO uint32_t C2TOC1SR;         /*!< Inter-Processor Communication: C2 to processor M4 status register,   Address offset: 0x01C */
  __IO uint32_t RESERVED1[244];   /*!< Reserved                                                                                   */
  __IO uint32_t HWCFGR;           /*!< Inter-Processor Communication hardware configuration register,       Address offset: 0x3F0 */
  __IO uint32_t VER;             /*!< Inter-Processor Communication version register,                      Address offset: 0x3F4 */
  __IO uint32_t ID;            /*!< Inter-Processor Communication identification register,               Address offset: 0x3F8 */
  __IO uint32_t SID;             /*!< Inter-Processor Communication size identification register,          Address offset: 0x3FC */
} IPCC_TypeDef;

typedef struct
{
  __IO uint32_t CR;               /*!< Control register,                                                    Address offset: 0x000 */
  __IO uint32_t MR;               /*!< Mask register,                                                       Address offset: 0x004 */
  __IO uint32_t SCR;              /*!< Status set clear register,                                           Address offset: 0x008 */
  __IO uint32_t SR;               /*!< Status register,                                                     Address offset: 0x00C */
} IPCC_CommonTypeDef;

/**
  * @brief MDIOS
  */

typedef struct
{
  __IO uint32_t CR;               /*!< Control register,                                                    Address offset: 0x000 */
  __IO uint32_t WRFR;             /*!< Write Flag register,                                                 Address offset: 0x004 */
  __IO uint32_t CWRFR;            /*!< Clear Write Flag register,                                           Address offset: 0x008 */
  __IO uint32_t RDFR;             /*!< Read Flag register,                                                  Address offset: 0x00C */
  __IO uint32_t CRDFR;            /*!< Clear Read Flag register,                                            Address offset: 0x010 */
  __IO uint32_t SR;               /*!< Status register,                                                     Address offset: 0x014 */
  __IO uint32_t CLRFR;            /*!< Clear Flag register,                                                 Address offset: 0x018 */
  uint32_t RESERVED[57];          /*!< Reserved,                                                    Address offset: 0x01C - 0x0FC */
  __IO uint32_t DINR0;            /*!< Input Data register 0                                                Address offset: 0x100 */
  __IO uint32_t DINR1;            /*!< Input Data register 1                                                Address offset: 0x104 */
  __IO uint32_t DINR2;            /*!< Input Data register 2                                                Address offset: 0x108 */
  __IO uint32_t DINR3;            /*!< Input Data register 3                                                Address offset: 0x10C */
  __IO uint32_t DINR4;            /*!< Input Data register 4                                                Address offset: 0x110 */
  __IO uint32_t DINR5;            /*!< Input Data register 5                                                Address offset: 0x114 */
  __IO uint32_t DINR6;            /*!< Input Data register 6                                                Address offset: 0x118 */
  __IO uint32_t DINR7;            /*!< Input Data register 7                                                Address offset: 0x11C */
  __IO uint32_t DINR8;            /*!< Input Data register 8                                                Address offset: 0x120 */
  __IO uint32_t DINR9;            /*!< Input Data register 9                                                Address offset: 0x124 */
  __IO uint32_t DINR10;           /*!< Input Data register 10                                               Address offset: 0x128 */
  __IO uint32_t DINR11;           /*!< Input Data register 11                                               Address offset: 0x12C */
  __IO uint32_t DINR12;           /*!< Input Data register 12                                               Address offset: 0x130 */
  __IO uint32_t DINR13;           /*!< Input Data register 13                                               Address offset: 0x134 */
  __IO uint32_t DINR14;           /*!< Input Data register 14                                               Address offset: 0x138 */
  __IO uint32_t DINR15;           /*!< Input Data register 15                                               Address offset: 0x13C */
  __IO uint32_t DINR16;           /*!< Input Data register 16                                               Address offset: 0x140 */
  __IO uint32_t DINR17;           /*!< Input Data register 17                                               Address offset: 0x144 */
  __IO uint32_t DINR18;           /*!< Input Data register 18                                               Address offset: 0x148 */
  __IO uint32_t DINR19;           /*!< Input Data register 19                                               Address offset: 0x14C */
  __IO uint32_t DINR20;           /*!< Input Data register 20                                               Address offset: 0x150 */
  __IO uint32_t DINR21;           /*!< Input Data register 21                                               Address offset: 0x154 */
  __IO uint32_t DINR22;           /*!< Input Data register 22                                               Address offset: 0x158 */
  __IO uint32_t DINR23;           /*!< Input Data register 23                                               Address offset: 0x15C */
  __IO uint32_t DINR24;           /*!< Input Data register 24                                               Address offset: 0x160 */
  __IO uint32_t DINR25;           /*!< Input Data register 25                                               Address offset: 0x164 */
  __IO uint32_t DINR26;           /*!< Input Data register 26                                               Address offset: 0x168 */
  __IO uint32_t DINR27;           /*!< Input Data register 27                                               Address offset: 0x16C */
  __IO uint32_t DINR28;           /*!< Input Data register 28                                               Address offset: 0x170 */
  __IO uint32_t DINR29;           /*!< Input Data register 29                                               Address offset: 0x174 */
  __IO uint32_t DINR30;           /*!< Input Data register 30                                               Address offset: 0x178 */
  __IO uint32_t DINR31;           /*!< Input Data register 31                                               Address offset: 0x17C */
  __IO uint32_t DOUTR0;           /*!< Output Data register 0                                               Address offset: 0x180 */
  __IO uint32_t DOUTR1;           /*!< Output Data register 1                                               Address offset: 0x184 */
  __IO uint32_t DOUTR2;           /*!< Output Data register 2                                               Address offset: 0x188 */
  __IO uint32_t DOUTR3;           /*!< Output Data register 3                                               Address offset: 0x18C */
  __IO uint32_t DOUTR4;           /*!< Output Data register 4                                               Address offset: 0x190 */
  __IO uint32_t DOUTR5;           /*!< Output Data register 5                                               Address offset: 0x194 */
  __IO uint32_t DOUTR6;           /*!< Output Data register 6                                               Address offset: 0x198 */
  __IO uint32_t DOUTR7;           /*!< Output Data register 7                                               Address offset: 0x19C */
  __IO uint32_t DOUTR8;           /*!< Output Data register 8                                               Address offset: 0x1A0 */
  __IO uint32_t DOUTR9;           /*!< Output Data register 9                                               Address offset: 0x1A4 */
  __IO uint32_t DOUTR10;          /*!< Output Data register 10                                              Address offset: 0x1A8 */
  __IO uint32_t DOUTR11;          /*!< Output Data register 11                                              Address offset: 0x1AC */
  __IO uint32_t DOUTR12;          /*!< Output Data register 12                                              Address offset: 0x1B0 */
  __IO uint32_t DOUTR13;          /*!< Output Data register 13                                              Address offset: 0x1B4 */
  __IO uint32_t DOUTR14;          /*!< Output Data register 14                                              Address offset: 0x1B8 */
  __IO uint32_t DOUTR15;          /*!< Output Data register 15                                              Address offset: 0x1BC */
  __IO uint32_t DOUTR16;          /*!< Output Data register 16                                              Address offset: 0x1C0 */
  __IO uint32_t DOUTR17;          /*!< Output Data register 17                                              Address offset: 0x1C4 */
  __IO uint32_t DOUTR18;          /*!< Output Data register 18                                              Address offset: 0x1C8 */
  __IO uint32_t DOUTR19;          /*!< Output Data register 19                                              Address offset: 0x1CC */
  __IO uint32_t DOUTR20;          /*!< Output Data register 20                                              Address offset: 0x1D0 */
  __IO uint32_t DOUTR21;          /*!< Output Data register 21                                              Address offset: 0x1D4 */
  __IO uint32_t DOUTR22;          /*!< Output Data register 22                                              Address offset: 0x1D8 */
  __IO uint32_t DOUTR23;          /*!< Output Data register 23                                              Address offset: 0x1DC */
  __IO uint32_t DOUTR24;          /*!< Output Data register 24                                              Address offset: 0x1E0 */
  __IO uint32_t DOUTR25;          /*!< Output Data register 25                                              Address offset: 0x1E4 */
  __IO uint32_t DOUTR26;          /*!< Output Data register 26                                              Address offset: 0x1E8 */
  __IO uint32_t DOUTR27;          /*!< Output Data register 27                                              Address offset: 0x1EC */
  __IO uint32_t DOUTR28;          /*!< Output Data register 28                                              Address offset: 0x1F0 */
  __IO uint32_t DOUTR29;          /*!< Output Data register 29                                              Address offset: 0x1F4 */
  __IO uint32_t DOUTR30;          /*!< Output Data register 30                                              Address offset: 0x1F8 */
  __IO uint32_t DOUTR31;          /*!< Output Data register 31                                              Address offset: 0x1FC */
  uint32_t RESERVED1[124]; /*!< Reserved                                     0x200 - 0x3EC */
  __IO uint32_t HWCFGR;    /*!< MDIOS HW Configuration register,     Address offset: 0x3F0 */
  __IO uint32_t VERR;      /*!< MDIOS Version register,              Address offset: 0x3F4 */
  __IO uint32_t IPIDR;     /*!< MDIOS identification register,       Address offset: 0x3F8 */
  __IO uint32_t SIDR;      /*!< MDIOS Size ID register,              Address offset: 0x3FC */
} MDIOS_TypeDef;


/**
  * @brief USB_OTG_Core_Registers
  */
typedef struct
{
 __IO uint32_t GOTGCTL;               /*!< USB_OTG Control and Status Register          000h */
  __IO uint32_t GOTGINT;              /*!< USB_OTG Interrupt Register                   004h */
  __IO uint32_t GAHBCFG;              /*!< Core AHB Configuration Register              008h */
  __IO uint32_t GUSBCFG;              /*!< Core USB Configuration Register              00Ch */
  __IO uint32_t GRSTCTL;              /*!< Core Reset Register                          010h */
  __IO uint32_t GINTSTS;              /*!< Core Interrupt Register                      014h */
  __IO uint32_t GINTMSK;              /*!< Core Interrupt Mask Register                 018h */
  __IO uint32_t GRXSTSR;              /*!< Receive Sts Q Read Register                  01Ch */
  __IO uint32_t GRXSTSP;              /*!< Receive Sts Q Read & POP Register            020h */
  __IO uint32_t GRXFSIZ;              /*!< Receive FIFO Size Register                   024h */
  __IO uint32_t DIEPTXF0_HNPTXFSIZ;   /*!< EP0 / Non Periodic Tx FIFO Size Register     028h */
  __IO uint32_t HNPTXSTS;             /*!< Non Periodic Tx FIFO/Queue Sts reg           02Ch */
  __IO uint32_t GI2CCTL;              /*!< I2C Access Register                          030h */
  uint32_t Reserved30;                /*!< Reserved                                     034h */
  __IO uint32_t GCCFG;                /*!< General Purpose IO Register                  038h */
  __IO uint32_t CID;                  /*!< User ID Register                             03Ch */
  uint32_t  Reserved5[4];             /*!< Reserved                                040h-048h */
  uint32_t  Reserved6;                /*!< Reserved                                     050h */
  __IO uint32_t GLPMCFG;              /*!< LPM Register                                 054h */
  uint32_t  Reserved43[42];         /*!< Reserved                                  058h-0FFh */
  __IO uint32_t HPTXFSIZ;             /*!< Host Periodic Tx FIFO Size Reg               100h */
  __IO uint32_t DIEPTXF[0x0F];        /*!< dev Periodic Transmit FIFO */
} USB_OTG_GlobalTypeDef;


/**
  * @brief USB_OTG_device_Registers
  */
typedef struct
{
  __IO uint32_t DCFG;            /*!< dev Configuration Register   800h */
  __IO uint32_t DCTL;            /*!< dev Control Register         804h */
  __IO uint32_t DSTS;            /*!< dev Status Register (RO)     808h */
  uint32_t Reserved0C;           /*!< Reserved                     80Ch */
  __IO uint32_t DIEPMSK;         /*!< dev IN Endpoint Mask         810h */
  __IO uint32_t DOEPMSK;         /*!< dev OUT Endpoint Mask        814h */
  __IO uint32_t DAINT;           /*!< dev All Endpoints Itr Reg    818h */
  __IO uint32_t DAINTMSK;        /*!< dev All Endpoints Itr Mask   81Ch */
  uint32_t  Reserved20;          /*!< Reserved                     820h */
  uint32_t Reserved9;            /*!< Reserved                     824h */
  __IO uint32_t DVBUSDIS;        /*!< dev VBUS discharge Register  828h */
  __IO uint32_t DVBUSPULSE;      /*!< dev VBUS Pulse Register      82Ch */
  __IO uint32_t DTHRCTL;         /*!< dev threshold                830h */
  __IO uint32_t DIEPEMPMSK;      /*!< dev empty msk                834h */
  __IO uint32_t DEACHINT;        /*!< dedicated EP interrupt       838h */
  __IO uint32_t DEACHMSK;        /*!< dedicated EP msk             83Ch */
  uint32_t Reserved40;           /*!< dedicated EP mask            840h */
  __IO uint32_t DINEP1MSK;       /*!< dedicated EP mask            844h */
  uint32_t  Reserved44[15];      /*!< Reserved                 844-87Ch */
  __IO uint32_t DOUTEP1MSK;      /*!< dedicated EP msk             884h */
} USB_OTG_DeviceTypeDef;


/**
  * @brief USB_OTG_IN_Endpoint-Specific_Register
  */
typedef struct
{
  __IO uint32_t DIEPCTL;           /*!< dev IN Endpoint Control Reg    900h + (ep_num * 20h) + 00h */
  uint32_t Reserved04;             /*!< Reserved                       900h + (ep_num * 20h) + 04h */
  __IO uint32_t DIEPINT;           /*!< dev IN Endpoint Itr Reg        900h + (ep_num * 20h) + 08h */
  uint32_t Reserved0C;             /*!< Reserved                       900h + (ep_num * 20h) + 0Ch */
  __IO uint32_t DIEPTSIZ;          /*!< IN Endpoint Txfer Size         900h + (ep_num * 20h) + 10h */
  __IO uint32_t DIEPDMA;           /*!< IN Endpoint DMA Address Reg    900h + (ep_num * 20h) + 14h */
  __IO uint32_t DTXFSTS;           /*!< IN Endpoint Tx FIFO Status Reg 900h + (ep_num * 20h) + 18h */
  uint32_t Reserved18;             /*!< Reserved  900h+(ep_num*20h)+1Ch-900h+ (ep_num * 20h) + 1Ch */
} USB_OTG_INEndpointTypeDef;


/**
  * @brief USB_OTG_OUT_Endpoint-Specific_Registers
  */
typedef struct
{
  __IO uint32_t DOEPCTL;       /*!< dev OUT Endpoint Control Reg           B00h + (ep_num * 20h) + 00h */
  uint32_t Reserved04;         /*!< Reserved                               B00h + (ep_num * 20h) + 04h */
  __IO uint32_t DOEPINT;       /*!< dev OUT Endpoint Itr Reg               B00h + (ep_num * 20h) + 08h */
  uint32_t Reserved0C;         /*!< Reserved                               B00h + (ep_num * 20h) + 0Ch */
  __IO uint32_t DOEPTSIZ;      /*!< dev OUT Endpoint Txfer Size            B00h + (ep_num * 20h) + 10h */
  __IO uint32_t DOEPDMA;       /*!< dev OUT Endpoint DMA Address           B00h + (ep_num * 20h) + 14h */
  uint32_t Reserved18[2];      /*!< Reserved B00h + (ep_num * 20h) + 18h - B00h + (ep_num * 20h) + 1Ch */
} USB_OTG_OUTEndpointTypeDef;


/**
  * @brief USB_OTG_Host_Mode_Register_Structures
  */
typedef struct
{
  __IO uint32_t HCFG;             /*!< Host Configuration Register           400h */
  __IO uint32_t HFIR;             /*!< Host Frame Interval Register          404h */
  __IO uint32_t HFNUM;            /*!< Host Frame Nbr/Frame Remaining        408h */
  uint32_t Reserved40C;           /*!< Reserved                              40Ch */
  __IO uint32_t HPTXSTS;          /*!< Host Periodic Tx FIFO/ Queue Status   410h */
  __IO uint32_t HAINT;            /*!< Host All Channels Interrupt Register  414h */
  __IO uint32_t HAINTMSK;         /*!< Host All Channels Interrupt Mask      418h */
  __IO uint32_t HFLBADDR;         /*!< Host frame list base address register 41Ch */
  uint32_t Reserved420[8];        /*!< Reserved                              420h */
  __IO uint32_t HPRT;             /*!< Host port control and status register 440h */
} USB_OTG_HostTypeDef;

/**
  * @brief USB_OTG_Host_Channel_Specific_Registers
  */
typedef struct
{
  __IO uint32_t HCCHAR;           /*!< Host Channel Characteristics Register    500h */
  __IO uint32_t HCSPLT;           /*!< Host Channel Split Control Register      504h */
  __IO uint32_t HCINT;            /*!< Host Channel Interrupt Register          508h */
  __IO uint32_t HCINTMSK;         /*!< Host Channel Interrupt Mask Register     50Ch */
  __IO uint32_t HCTSIZ;           /*!< Host Channel Transfer Size Register      510h */
  __IO uint32_t HCDMA;            /*!< Host Channel DMA Address Register        514h */
  uint32_t Reserved0;             /*!< Reserved                                 518h */
  __IO uint32_t HCDMAB;           /*!< Host Channel DMA Address Buffer Register 51Ch */
  uint32_t Reserved[2];           /*!< Reserved                                      */
} USB_OTG_HostChannelTypeDef;
/**
  * @}
  */

/**
  * @brief USB_EHCI Capability Registers
  */
typedef struct
{
  __IO uint32_t HCCAPBASE;        /*!< Capability Register register,              Address offset: 0x00 */
  __IO uint32_t HCSPARAMS;        /*!< Structural Parameter register              Address offset: 0x04 */
  __IO uint32_t HCCPARAMS;        /*!< Capability Parameter register,             Address offset: 0x08 */
       uint32_t RESERVED;         /*!< USB Command register,                      Address offset: 0x0C */
  __IO uint32_t USBCMD;           /*!< USB Command register,                      Address offset: 0x10 */
  __IO uint32_t USBSTS;           /*!< USB Status register,                       Address offset: 0x14 */
  __IO uint32_t USBINTR;          /*!< USB Interrupt Enable register,             Address offset: 0x18 */
  __IO uint32_t FRINDEX;          /*!< USB Frame Index register ,                 Address offset: 0x1C */
  __IO uint32_t CTRLDSSEGMENT;    /*!< 4G Segment Selector register,              Address offset: 0x20 */
  __IO uint32_t PERIODICLISTBASE; /*!< Periodic Frame List Base Address register, Address offset: 0x24 */
  __IO uint32_t ASYNCLISTADDR;    /*!< Asynchronous List Address register,        Address offset: 0x28 */
} USB_EHCI_CapabilityTypeDef;
/**
  * @}
  */



/** @addtogroup Peripheral_memory_map
  * @{
  */
#define MCU_AHB_SRAM            ((uint32_t)0x10000000) /*!< Base address of : (up to 288KB) system data RAM accessible over over AHB             */
#define MCU_AHB_RETRAM          ((uint32_t)0x00000000) /*!< Base address of : (up to 64KB) Retention RAM accessible over over AHB                */

#define SYSRAM_BASE             ((uint32_t)0x2FFC0000) /*!< Base address of : (up to 256KB) System RAM accessible over over AXI                  */
#define RETRAM_BASE             MCU_AHB_RETRAM
#define SRAM_BASE               MCU_AHB_SRAM
#define PERIPH_BASE             ((uint32_t)0x40000000) /*!< Base address of : AHB/ABP Peripherals                                                */
#define MPU_AXI_BUS_MEMORY_BASE ((uint32_t)0x60000000) /*!< Base address of : AXI Bus                                                            */

#define FMC_NOR_MEM_BASE        (MPU_AXI_BUS_MEMORY_BASE)              /*!< Base address of : FMC NOR memories  accessible over AXI              */
#define QSPI_MEM_BASE           (MPU_AXI_BUS_MEMORY_BASE + 0x10000000) /*!< Base address of : QSPI memories  accessible over AXI                 */
#define FMC_NAND_MEM_BASE       (MPU_AXI_BUS_MEMORY_BASE + 0x20000000) /*!< Base address of : FMC NAND memories  accessible over AXI             */
#define STM_DATA_BASE           (MPU_AXI_BUS_MEMORY_BASE + 0x30000000) /*!< Base address of : STM Data accessible over AXI                       */
#define DRAM_MEM_BASE           (MPU_AXI_BUS_MEMORY_BASE + 0x60000000) /*!< Base address of : DRAM (DDR) over AXI                                */

/*!< Device electronic signature memory map */
#define UID_BASE                  (0x5C005234L)            /*!< Unique Device ID register base address */
#define PACKAGE_BASE              (0x5C005240L)            /*!< Package Data register base address */
#define RPN_BASE                  (0x5C005204L)            /*!< Device Part Number register base address */
#define DV_BASE                   (0x50081000L)            /*!< Device Version register base address */

/*!< Peripheral memory map */
#define MCU_APB1_PERIPH_BASE        (PERIPH_BASE + 0x00000000)
#define MCU_APB2_PERIPH_BASE        (PERIPH_BASE + 0x04000000)
#define MCU_AHB2_PERIPH_BASE        (PERIPH_BASE + 0x08000000)
#define MCU_AHB3_PERIPH_BASE        (PERIPH_BASE + 0x0C000000)
#define MCU_AHB4_PERIPH_BASE        (PERIPH_BASE + 0x10000000)
#define MCU_APB3_PERIPH_BASE        (PERIPH_BASE + 0x10020000)
#define APB_DEBUG_PERIPH_BASE       (PERIPH_BASE + 0x10080000)
#define MPU_AHB5_PERIPH_BASE        (PERIPH_BASE + 0x14000000)
#define GPV_PERIPH_BASE             (PERIPH_BASE + 0x17000000)
#define MPU_AHB6_PERIPH_BASE        (PERIPH_BASE + 0x18000000)
#define MPU_APB4_PERIPH_BASE        (PERIPH_BASE + 0x1A000000)
#define MPU_APB5_PERIPH_BASE        (PERIPH_BASE + 0x1C000000)


/*!< MCU_APB1 */
#define TIM2_BASE             (MCU_APB1_PERIPH_BASE + 0x0000)
#define TIM3_BASE             (MCU_APB1_PERIPH_BASE + 0x1000)
#define TIM4_BASE             (MCU_APB1_PERIPH_BASE + 0x2000)
#define TIM5_BASE             (MCU_APB1_PERIPH_BASE + 0x3000)
#define TIM6_BASE             (MCU_APB1_PERIPH_BASE + 0x4000)
#define TIM7_BASE             (MCU_APB1_PERIPH_BASE + 0x5000)
#define TIM12_BASE            (MCU_APB1_PERIPH_BASE + 0x6000)
#define TIM13_BASE            (MCU_APB1_PERIPH_BASE + 0x7000)
#define TIM14_BASE            (MCU_APB1_PERIPH_BASE + 0x8000)
#define LPTIM1_BASE           (MCU_APB1_PERIPH_BASE + 0x9000)
#define WWDG1_BASE            (MCU_APB1_PERIPH_BASE + 0xA000)
#define SPI2_BASE             (MCU_APB1_PERIPH_BASE + 0xB000)
#define SPI3_BASE             (MCU_APB1_PERIPH_BASE + 0xC000)
#define SPDIFRX_BASE          (MCU_APB1_PERIPH_BASE + 0xD000)
#define USART2_BASE           (MCU_APB1_PERIPH_BASE + 0xE000)
#define USART3_BASE           (MCU_APB1_PERIPH_BASE + 0xF000)
#define UART4_BASE            (MCU_APB1_PERIPH_BASE + 0x10000)
#define UART5_BASE            (MCU_APB1_PERIPH_BASE + 0x11000)
#define I2C1_BASE             (MCU_APB1_PERIPH_BASE + 0x12000)
#define I2C2_BASE             (MCU_APB1_PERIPH_BASE + 0x13000)
#define I2C3_BASE             (MCU_APB1_PERIPH_BASE + 0x14000)
#define I2C5_BASE             (MCU_APB1_PERIPH_BASE + 0x15000)
#define CEC_BASE              (MCU_APB1_PERIPH_BASE + 0x16000)
#define DAC1_BASE             (MCU_APB1_PERIPH_BASE + 0x17000)
#define UART7_BASE            (MCU_APB1_PERIPH_BASE + 0x18000)
#define UART8_BASE            (MCU_APB1_PERIPH_BASE + 0x19000)
#define MDIOS_BASE            (MCU_APB1_PERIPH_BASE + 0x1C000)

/*!< MCU_APB2 */
#define TIM1_BASE             (MCU_APB2_PERIPH_BASE + 0x0000)
#define TIM8_BASE             (MCU_APB2_PERIPH_BASE + 0x1000)
#define USART6_BASE           (MCU_APB2_PERIPH_BASE + 0x3000)
#define SPI1_BASE             (MCU_APB2_PERIPH_BASE + 0x4000)
#define SPI4_BASE             (MCU_APB2_PERIPH_BASE + 0x5000)
#define TIM15_BASE            (MCU_APB2_PERIPH_BASE + 0x6000)
#define TIM16_BASE            (MCU_APB2_PERIPH_BASE + 0x7000)
#define TIM17_BASE            (MCU_APB2_PERIPH_BASE + 0x8000)
#define SPI5_BASE             (MCU_APB2_PERIPH_BASE + 0x9000)
#define SAI1_BASE             (MCU_APB2_PERIPH_BASE + 0xA000)
#define SAI1_Block_A_BASE     (SAI1_BASE + 0x004)
#define SAI1_Block_B_BASE     (SAI1_BASE + 0x024)
#define SAI2_BASE             (MCU_APB2_PERIPH_BASE + 0xB000)
#define SAI2_Block_A_BASE     (SAI2_BASE + 0x004)
#define SAI2_Block_B_BASE     (SAI2_BASE + 0x024)
#define SAI3_BASE             (MCU_APB2_PERIPH_BASE + 0xC000)
#define SAI3_Block_A_BASE     (SAI3_BASE + 0x004)
#define SAI3_Block_B_BASE     (SAI3_BASE + 0x024)
#define DFSDM1_BASE           (MCU_APB2_PERIPH_BASE + 0xD000)
#define DFSDM1_Channel0_BASE  (DFSDM1_BASE + 0x00)
#define DFSDM1_Channel1_BASE  (DFSDM1_BASE + 0x20)
#define DFSDM1_Channel2_BASE  (DFSDM1_BASE + 0x40)
#define DFSDM1_Channel3_BASE  (DFSDM1_BASE + 0x60)
#define DFSDM1_Channel4_BASE  (DFSDM1_BASE + 0x80)
#define DFSDM1_Channel5_BASE  (DFSDM1_BASE + 0xA0)
#define DFSDM1_Channel6_BASE  (DFSDM1_BASE + 0xC0)
#define DFSDM1_Channel7_BASE  (DFSDM1_BASE + 0xE0)
#define DFSDM1_Filter0_BASE   (DFSDM1_BASE + 0x100)
#define DFSDM1_Filter1_BASE   (DFSDM1_BASE + 0x180)
#define DFSDM1_Filter2_BASE   (DFSDM1_BASE + 0x200)
#define DFSDM1_Filter3_BASE   (DFSDM1_BASE + 0x280)
#define DFSDM1_Filter4_BASE   (DFSDM1_BASE + 0x300)
#define DFSDM1_Filter5_BASE   (DFSDM1_BASE + 0x380)

/*!< MCU_AHB2 */
#define DMA1_BASE             (MCU_AHB2_PERIPH_BASE + 0x0000)
#define DMA2_BASE             (MCU_AHB2_PERIPH_BASE + 0x1000)
#define DMAMUX1_BASE          (MCU_AHB2_PERIPH_BASE + 0x2000)
#define ADC1_BASE             (MCU_AHB2_PERIPH_BASE + 0x3000)
#define ADC2_BASE             (MCU_AHB2_PERIPH_BASE + 0x3100)
#define ADC12_COMMON_BASE     (MCU_AHB2_PERIPH_BASE + 0x3300)
#define SDMMC3_BASE           (MCU_AHB2_PERIPH_BASE + 0x4000)
#define DLYB_SDMMC3_BASE          (MCU_AHB2_PERIPH_BASE + 0x5000)
#define USBOTG_BASE           (MCU_AHB2_PERIPH_BASE + 0x1000000)


/*!< MCU_AHB3 */
#define HSEM_BASE             (MCU_AHB3_PERIPH_BASE + 0x0000)
#define IPCC_BASE             (MCU_AHB3_PERIPH_BASE + 0x1000)
#define HASH2_BASE            (MCU_AHB3_PERIPH_BASE + 0x2000)
#define HASH2_DIGEST_BASE     (MCU_AHB3_PERIPH_BASE + 0x2310)
#define RNG2_BASE             (MCU_AHB3_PERIPH_BASE + 0x3000)
#define CRC2_BASE             (MCU_AHB3_PERIPH_BASE + 0x4000)
#define DCMI_BASE             (MCU_AHB3_PERIPH_BASE + 0x6000)

/*!< MCU_AHB4 */
#define RCC_BASE              (MCU_AHB4_PERIPH_BASE + 0x0000)
#define PWR_BASE              (MCU_AHB4_PERIPH_BASE + 0x1000)
#define GPIOA_BASE            (MCU_AHB4_PERIPH_BASE + 0x2000)
#define GPIOB_BASE            (MCU_AHB4_PERIPH_BASE + 0x3000)
#define GPIOC_BASE            (MCU_AHB4_PERIPH_BASE + 0x4000)
#define GPIOD_BASE            (MCU_AHB4_PERIPH_BASE + 0x5000)
#define GPIOE_BASE            (MCU_AHB4_PERIPH_BASE + 0x6000)
#define GPIOF_BASE            (MCU_AHB4_PERIPH_BASE + 0x7000)
#define GPIOG_BASE            (MCU_AHB4_PERIPH_BASE + 0x8000)
#define GPIOH_BASE            (MCU_AHB4_PERIPH_BASE + 0x9000)
#define GPIOI_BASE            (MCU_AHB4_PERIPH_BASE + 0xA000)
#define GPIOJ_BASE            (MCU_AHB4_PERIPH_BASE + 0xB000)
#define GPIOK_BASE            (MCU_AHB4_PERIPH_BASE + 0xC000)
#define AIEC_BASE             (MCU_AHB4_PERIPH_BASE + 0xD000)
#define AIEC_C1_BASE          (AIEC_BASE + 0x0080)
#define AIEC_C2_BASE          (AIEC_BASE + 0x00C0)
/* Alias EXTI_BASE defined because HAL code not yet reworked with new name AIEC*/
#define EXTI_BASE             AIEC_BASE
#define EXTI_C1_BASE          AIEC_C1_BASE
#define EXTI_C2_BASE          AIEC_C2_BASE


/*!< MCU_APB3 */
#define SYSCFG_BASE           (MCU_APB3_PERIPH_BASE + 0x0000)
#define LPTIM2_BASE           (MCU_APB3_PERIPH_BASE + 0x1000)
#define LPTIM3_BASE           (MCU_APB3_PERIPH_BASE + 0x2000)
#define LPTIM4_BASE           (MCU_APB3_PERIPH_BASE + 0x3000)
#define LPTIM5_BASE           (MCU_APB3_PERIPH_BASE + 0x4000)
#define VREFBUF_BASE          (MCU_APB3_PERIPH_BASE + 0x5000)
#define SAI4_BASE             (MCU_APB3_PERIPH_BASE + 0x7000)
#define SAI4_Block_A_BASE     (SAI4_BASE + 0x004)
#define SAI4_Block_B_BASE     (SAI4_BASE + 0x024)
#define DTS_BASE              (MCU_APB3_PERIPH_BASE + 0x8000)
#define PMB_BASE              (MCU_APB3_PERIPH_BASE + 0x9000)
#define HDP_BASE              (MCU_APB3_PERIPH_BASE + 0xA000)

/*!< MCU_AHB4 _APB_Debug */
#define DBGMCU_BASE           ((uint32_t )0x50081000)

/*!< MCU_AHB5 */
#define BKPSRAM_BASE          (MPU_AHB5_PERIPH_BASE + 0x0000)
#define HASH1_BASE            (MPU_AHB5_PERIPH_BASE + 0x2000)
#define HASH1_DIGEST_BASE     (MPU_AHB5_PERIPH_BASE + 0x2310)
#define RNG1_BASE             (MPU_AHB5_PERIPH_BASE + 0x3000)
#define GPIOZ_BASE            (MPU_AHB5_PERIPH_BASE + 0x4000)

/*!< GPV */

/*!< MPU_AHB6 */
#define MDMA_BASE               (MPU_AHB6_PERIPH_BASE + 0x0000)
#define FMC_R_BASE              (MPU_AHB6_PERIPH_BASE + 0x2000)
#define QSPI_R_BASE             (MPU_AHB6_PERIPH_BASE + 0x3000)
#define DLYB_QSPI_BASE          (MPU_AHB6_PERIPH_BASE + 0x4000)
#define SDMMC1_BASE             (MPU_AHB6_PERIPH_BASE + 0x5000)
#define DLYB_SDMMC1_BASE        (MPU_AHB6_PERIPH_BASE + 0x6000)
#define SDMMC2_BASE             (MPU_AHB6_PERIPH_BASE + 0x7000)
#define DLYB_SDMMC2_BASE        (MPU_AHB6_PERIPH_BASE + 0x8000)
#define CRC1_BASE               (MPU_AHB6_PERIPH_BASE + 0x9000)
#define ETH_BASE                (MPU_AHB6_PERIPH_BASE + 0xA000)
#define ETH_MAC_BASE            (ETH_BASE)
#define USB1HSFSP2_BASE         (MPU_AHB6_PERIPH_BASE + 0xC000)
#define USB1HSFSP1_BASE         (MPU_AHB6_PERIPH_BASE + 0xD000)

/*!< MPU_APB4 */
#define LTDC_BASE             (MPU_APB4_PERIPH_BASE + 0x1000)
#define LTDC_Layer1_BASE      (LTDC_BASE + 0x84)
#define LTDC_Layer2_BASE      (LTDC_BASE + 0x104)
#define IWDG2_BASE            (MPU_APB4_PERIPH_BASE + 0x2000)
#define DDRC_BASE             (MPU_APB4_PERIPH_BASE + 0x3000)
#define DDRPHYC_BASE          (MPU_APB4_PERIPH_BASE + 0x4000)
#define STGENR_BASE           (MPU_APB4_PERIPH_BASE + 0x5000)
#define USBPHYC_BASE          (MPU_APB4_PERIPH_BASE + 0x6000)
#define USBPHYC_PHY1_BASE     (USBPHYC_BASE + 0x100)
#define USBPHYC_PHY2_BASE     (USBPHYC_BASE + 0x200)

/*!< MPU_APB5 */
#define USART1_BASE           (MPU_APB5_PERIPH_BASE + 0x0000)
#define SPI6_BASE             (MPU_APB5_PERIPH_BASE + 0x1000)
#define I2C4_BASE             (MPU_APB5_PERIPH_BASE + 0x2000)
#define IWDG1_BASE            (MPU_APB5_PERIPH_BASE + 0x3000)
#define RTC_BASE              (MPU_APB5_PERIPH_BASE + 0x4000)
#define BSEC_BASE             (MPU_APB5_PERIPH_BASE + 0x5000)
#define TZC_BASE              (MPU_APB5_PERIPH_BASE + 0x6000)
#define TZPC_BASE             (MPU_APB5_PERIPH_BASE + 0x7000)
#define STGENC_BASE           (MPU_APB5_PERIPH_BASE + 0x8000)
#define I2C6_BASE             (MPU_APB5_PERIPH_BASE + 0x9000)
#define TAMP_BASE             (MPU_APB5_PERIPH_BASE + 0xA000)



/*!< USB registers base address */
#define USB_OTG_GLOBAL_BASE                  ((uint32_t )0x000)
#define USB_OTG_DEVICE_BASE                  ((uint32_t )0x800)
#define USB_OTG_IN_ENDPOINT_BASE             ((uint32_t )0x900)
#define USB_OTG_OUT_ENDPOINT_BASE            ((uint32_t )0xB00)
#define USB_OTG_EP_REG_SIZE                  ((uint32_t )0x20)
#define USB_OTG_HOST_BASE                    ((uint32_t )0x400)
#define USB_OTG_HOST_PORT_BASE               ((uint32_t )0x440)
#define USB_OTG_HOST_CHANNEL_BASE            ((uint32_t )0x500)
#define USB_OTG_HOST_CHANNEL_SIZE            ((uint32_t )0x20)
#define USB_OTG_PCGCCTL_BASE                 ((uint32_t )0xE00)
#define USB_OTG_FIFO_BASE                    ((uint32_t )0x1000)
#define USB_OTG_FIFO_SIZE                    ((uint32_t )0x1000)



#define DMA1_Stream0_BASE     (DMA1_BASE + 0x010)
#define DMA1_Stream1_BASE     (DMA1_BASE + 0x028)
#define DMA1_Stream2_BASE     (DMA1_BASE + 0x040)
#define DMA1_Stream3_BASE     (DMA1_BASE + 0x058)
#define DMA1_Stream4_BASE     (DMA1_BASE + 0x070)
#define DMA1_Stream5_BASE     (DMA1_BASE + 0x088)
#define DMA1_Stream6_BASE     (DMA1_BASE + 0x0A0)
#define DMA1_Stream7_BASE     (DMA1_BASE + 0x0B8)

#define DMA2_Stream0_BASE     (DMA2_BASE + 0x010)
#define DMA2_Stream1_BASE     (DMA2_BASE + 0x028)
#define DMA2_Stream2_BASE     (DMA2_BASE + 0x040)
#define DMA2_Stream3_BASE     (DMA2_BASE + 0x058)
#define DMA2_Stream4_BASE     (DMA2_BASE + 0x070)
#define DMA2_Stream5_BASE     (DMA2_BASE + 0x088)
#define DMA2_Stream6_BASE     (DMA2_BASE + 0x0A0)
#define DMA2_Stream7_BASE     (DMA2_BASE + 0x0B8)

#define DMAMUX1_Channel0_BASE    (DMAMUX1_BASE)
#define DMAMUX1_Channel1_BASE    (DMAMUX1_BASE + 0x0004)
#define DMAMUX1_Channel2_BASE    (DMAMUX1_BASE + 0x0008)
#define DMAMUX1_Channel3_BASE    (DMAMUX1_BASE + 0x000C)
#define DMAMUX1_Channel4_BASE    (DMAMUX1_BASE + 0x0010)
#define DMAMUX1_Channel5_BASE    (DMAMUX1_BASE + 0x0014)
#define DMAMUX1_Channel6_BASE    (DMAMUX1_BASE + 0x0018)
#define DMAMUX1_Channel7_BASE    (DMAMUX1_BASE + 0x001C)
#define DMAMUX1_Channel8_BASE    (DMAMUX1_BASE + 0x0020)
#define DMAMUX1_Channel9_BASE    (DMAMUX1_BASE + 0x0024)
#define DMAMUX1_Channel10_BASE   (DMAMUX1_BASE + 0x0028)
#define DMAMUX1_Channel11_BASE   (DMAMUX1_BASE + 0x002C)
#define DMAMUX1_Channel12_BASE   (DMAMUX1_BASE + 0x0030)
#define DMAMUX1_Channel13_BASE   (DMAMUX1_BASE + 0x0034)
#define DMAMUX1_Channel14_BASE   (DMAMUX1_BASE + 0x0038)
#define DMAMUX1_Channel15_BASE   (DMAMUX1_BASE + 0x003C)

#define DMAMUX1_RequestGenerator0_BASE  (DMAMUX1_BASE + 0x0100)
#define DMAMUX1_RequestGenerator1_BASE  (DMAMUX1_BASE + 0x0104)
#define DMAMUX1_RequestGenerator2_BASE  (DMAMUX1_BASE + 0x0108)
#define DMAMUX1_RequestGenerator3_BASE  (DMAMUX1_BASE + 0x010C)

#define DMAMUX1_ChannelStatus_BASE      (DMAMUX1_BASE + 0x0080)
#define DMAMUX1_RequestGenStatus_BASE   (DMAMUX1_BASE + 0x0140)



/*!< FMC Banks registers base  address */
#define FMC_Bank1_R_BASE      (FMC_R_BASE + 0x0000)
#define FMC_Bank1E_R_BASE     (FMC_R_BASE + 0x0104)
#define FMC_Bank2_R_BASE      (FMC_R_BASE + 0x0060)
#define FMC_Bank3_R_BASE      (FMC_R_BASE + 0x0080)
#define FMC_Bank5_6_R_BASE    (FMC_R_BASE + 0x0140)

#define MDMA_NB_CHANNELS        32
#define MDMA_Channel0_BASE    (MDMA_BASE + 0x00000040)
#define MDMA_Channel1_BASE    (MDMA_BASE + 0x00000080)
#define MDMA_Channel2_BASE    (MDMA_BASE + 0x000000C0)
#define MDMA_Channel3_BASE    (MDMA_BASE + 0x00000100)
#define MDMA_Channel4_BASE    (MDMA_BASE + 0x00000140)
#define MDMA_Channel5_BASE    (MDMA_BASE + 0x00000180)
#define MDMA_Channel6_BASE    (MDMA_BASE + 0x000001C0)
#define MDMA_Channel7_BASE    (MDMA_BASE + 0x00000200)
#define MDMA_Channel8_BASE    (MDMA_BASE + 0x00000240)
#define MDMA_Channel9_BASE    (MDMA_BASE + 0x00000280)
#define MDMA_Channel10_BASE   (MDMA_BASE + 0x000002C0)
#define MDMA_Channel11_BASE   (MDMA_BASE + 0x00000300)
#define MDMA_Channel12_BASE   (MDMA_BASE + 0x00000340)
#define MDMA_Channel13_BASE   (MDMA_BASE + 0x00000380)
#define MDMA_Channel14_BASE   (MDMA_BASE + 0x000003C0)
#define MDMA_Channel15_BASE   (MDMA_BASE + 0x00000400)
#define MDMA_Channel16_BASE   (MDMA_BASE + 0x00000440)
#define MDMA_Channel17_BASE   (MDMA_BASE + 0x00000480)
#define MDMA_Channel18_BASE   (MDMA_BASE + 0x000004C0)
#define MDMA_Channel19_BASE   (MDMA_BASE + 0x00000500)
#define MDMA_Channel20_BASE   (MDMA_BASE + 0x00000540)
#define MDMA_Channel21_BASE   (MDMA_BASE + 0x00000580)
#define MDMA_Channel22_BASE   (MDMA_BASE + 0x000005C0)
#define MDMA_Channel23_BASE   (MDMA_BASE + 0x00000600)
#define MDMA_Channel24_BASE   (MDMA_BASE + 0x00000640)
#define MDMA_Channel25_BASE   (MDMA_BASE + 0x00000680)
#define MDMA_Channel26_BASE   (MDMA_BASE + 0x000006C0)
#define MDMA_Channel27_BASE   (MDMA_BASE + 0x00000700)
#define MDMA_Channel28_BASE   (MDMA_BASE + 0x00000740)
#define MDMA_Channel29_BASE   (MDMA_BASE + 0x00000780)
#define MDMA_Channel30_BASE   (MDMA_BASE + 0x000007C0)
#define MDMA_Channel31_BASE   (MDMA_BASE + 0x00000800)

/**
  * @}
  */

/** @addtogroup Peripheral_declaration
  * @{
  */
#define TIM2                ((TIM_TypeDef *) TIM2_BASE)
#define TIM3                ((TIM_TypeDef *) TIM3_BASE)
#define TIM4                ((TIM_TypeDef *) TIM4_BASE)
#define TIM5                ((TIM_TypeDef *) TIM5_BASE)
#define TIM6                ((TIM_TypeDef *) TIM6_BASE)
#define TIM7                ((TIM_TypeDef *) TIM7_BASE)
#define TIM12               ((TIM_TypeDef *) TIM12_BASE)
#define TIM13               ((TIM_TypeDef *) TIM13_BASE)
#define TIM14               ((TIM_TypeDef *) TIM14_BASE)
#define LCD                 ((LCD_TypeDef *) LCD_BASE)
#define RTC                 ((RTC_TypeDef *) RTC_BASE)
#define TAMP                 ((TAMP_TypeDef *) TAMP_BASE)
#define WWDG1               ((WWDG_TypeDef *) WWDG1_BASE)
#define IWDG1               ((IWDG_TypeDef *) IWDG1_BASE)
#define IWDG2               ((IWDG_TypeDef *) IWDG2_BASE)
#define SPI2                ((SPI_TypeDef *) SPI2_BASE)
#define SPI3                ((SPI_TypeDef *) SPI3_BASE)
#define SPI4                ((SPI_TypeDef *) SPI4_BASE)
#define SPI5                ((SPI_TypeDef *) SPI5_BASE)
#define SPI6                ((SPI_TypeDef *) SPI6_BASE)
#define USART2              ((USART_TypeDef *) USART2_BASE)
#define USART3              ((USART_TypeDef *) USART3_BASE)
#define USART6              ((USART_TypeDef *) USART6_BASE)
#define UART7               ((USART_TypeDef *) UART7_BASE)
#define UART8               ((USART_TypeDef *) UART8_BASE)
#define UART4               ((USART_TypeDef *) UART4_BASE)
#define UART5               ((USART_TypeDef *) UART5_BASE)
#define I2C1                ((I2C_TypeDef *) I2C1_BASE)
#define I2C2                ((I2C_TypeDef *) I2C2_BASE)
#define I2C3                ((I2C_TypeDef *) I2C3_BASE)
#define I2C4                ((I2C_TypeDef *) I2C4_BASE)
#define I2C5                ((I2C_TypeDef *) I2C5_BASE)
#define I2C6                ((I2C_TypeDef *) I2C6_BASE)
#define CEC                 ((CEC_TypeDef *) CEC_BASE)
#define LPTIM1              ((LPTIM_TypeDef *) LPTIM1_BASE)
#define PWR                 ((PWR_TypeDef *) PWR_BASE)
#define DAC1                ((DAC_TypeDef *) DAC1_BASE)
#define LPTIM2              ((LPTIM_TypeDef *) LPTIM2_BASE)
#define LPTIM3              ((LPTIM_TypeDef *) LPTIM3_BASE)
#define LPTIM4              ((LPTIM_TypeDef *) LPTIM4_BASE)
#define LPTIM5              ((LPTIM_TypeDef *) LPTIM5_BASE)
#define SYSCFG              ((SYSCFG_TypeDef *) SYSCFG_BASE)
#define VREFBUF             ((VREF_TypeDef *) VREFBUF_BASE)



#define EXTI                ((EXTI_TypeDef *) EXTI_BASE)
#define EXTI_C1             ((EXTI_Core_TypeDef *) EXTI_C1_BASE)
#define EXTI_C2             ((EXTI_Core_TypeDef *) EXTI_C2_BASE)
#define TIM1                ((TIM_TypeDef *) TIM1_BASE)
#define SPI1                ((SPI_TypeDef *) SPI1_BASE)
#define TIM8                ((TIM_TypeDef *) TIM8_BASE)
#define USART1              ((USART_TypeDef *) USART1_BASE)
#define TIM15               ((TIM_TypeDef *) TIM15_BASE)
#define TIM16               ((TIM_TypeDef *) TIM16_BASE)
#define TIM17               ((TIM_TypeDef *) TIM17_BASE)
#define SAI1                ((SAI_TypeDef *) SAI1_BASE)
#define SAI1_Block_A        ((SAI_Block_TypeDef *)SAI1_Block_A_BASE)
#define SAI1_Block_B        ((SAI_Block_TypeDef *)SAI1_Block_B_BASE)
#define SAI2                ((SAI_TypeDef *) SAI2_BASE)
#define SAI2_Block_A        ((SAI_Block_TypeDef *)SAI2_Block_A_BASE)
#define SAI2_Block_B        ((SAI_Block_TypeDef *)SAI2_Block_B_BASE)
#define SAI3                ((SAI_TypeDef *) SAI3_BASE)
#define SAI3_Block_A        ((SAI_Block_TypeDef *)SAI3_Block_A_BASE)
#define SAI3_Block_B        ((SAI_Block_TypeDef *)SAI3_Block_B_BASE)
#define SAI4                ((SAI_TypeDef *) SAI4_BASE)
#define SAI4_Block_A        ((SAI_Block_TypeDef *)SAI4_Block_A_BASE)
#define SAI4_Block_B        ((SAI_Block_TypeDef *)SAI4_Block_B_BASE)
#define TMPSENS1             ((TMPSENS_TypeDef *) TMPSENS_BASE)
#define PMB                 ((PMB_TypeDef *) PMB_BASE)
#define SPDIFRX             ((SPDIFRX_TypeDef *) SPDIFRX_BASE)
#define DFSDM1              ((DFSDM_TypeDef *) DFSDM1_BASE)
#define DFSDM1_Channel0     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel0_BASE)
#define DFSDM1_Channel1     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel1_BASE)
#define DFSDM1_Channel2     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel2_BASE)
#define DFSDM1_Channel3     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel3_BASE)
#define DFSDM1_Channel4     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel4_BASE)
#define DFSDM1_Channel5     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel5_BASE)
#define DFSDM1_Channel6     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel6_BASE)
#define DFSDM1_Channel7     ((DFSDM_Channel_TypeDef *) DFSDM1_Channel7_BASE)
#define DFSDM1_Filter0      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter0_BASE)
#define DFSDM1_Filter1      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter1_BASE)
#define DFSDM1_Filter2      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter2_BASE)
#define DFSDM1_Filter3      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter3_BASE)
#define DFSDM1_Filter4      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter4_BASE)
#define DFSDM1_Filter5      ((DFSDM_Filter_TypeDef *) DFSDM1_Filter5_BASE)
#define DCMI                ((DCMI_TypeDef *) DCMI_BASE)

#define RCC                 ((RCC_TypeDef *) RCC_BASE)

#define HDP                 ((HDP_TypeDef *) HDP_BASE)

#define BSEC                ((BSEC_TypeDef *) BSEC_BASE)


#define CRC2                 ((CRC_TypeDef *) CRC2_BASE)
#define CRC1                     ((CRC_TypeDef *) CRC1_BASE)

#define GPIOA               ((GPIO_TypeDef *) GPIOA_BASE)
#define GPIOB               ((GPIO_TypeDef *) GPIOB_BASE)
#define GPIOC               ((GPIO_TypeDef *) GPIOC_BASE)
#define GPIOD               ((GPIO_TypeDef *) GPIOD_BASE)
#define GPIOE               ((GPIO_TypeDef *) GPIOE_BASE)
#define GPIOF               ((GPIO_TypeDef *) GPIOF_BASE)
#define GPIOG               ((GPIO_TypeDef *) GPIOG_BASE)
#define GPIOH               ((GPIO_TypeDef *) GPIOH_BASE)
#define GPIOI               ((GPIO_TypeDef *) GPIOI_BASE)
#define GPIOJ               ((GPIO_TypeDef *) GPIOJ_BASE)
#define GPIOK               ((GPIO_TypeDef *) GPIOK_BASE)
#define ADC1                ((ADC_TypeDef *) ADC1_BASE)
#define ADC2                ((ADC_TypeDef *) ADC2_BASE)
#define ADC12_COMMON        ((ADC_Common_TypeDef *) ADC12_COMMON_BASE)

#define IPCC                ((IPCC_TypeDef *) IPCC_BASE)
#define IPCC_C1             ((IPCC_CommonTypeDef *) IPCC_BASE)
#define IPCC_C2             ((IPCC_CommonTypeDef *) (IPCC_BASE + 0x10U))
#define HASH2               ((HASH_TypeDef *) HASH2_BASE)
#define HASH1               ((HASH_TypeDef *) HASH1_BASE)
#define HASH2_DIGEST        ((HASH_DIGEST_TypeDef *) HASH2_DIGEST_BASE)
#define HASH1_DIGEST        ((HASH_DIGEST_TypeDef *) HASH1_DIGEST_BASE)
#define HASH                ((HASH_TypeDef *) HASH2)
#define HASH_DIGEST         ((HASH_DIGEST_TypeDef *) HASH2_DIGEST)
#define RNG2                ((RNG_TypeDef *) RNG2_BASE)
#define RNG1                ((RNG_TypeDef *) RNG1_BASE)
#define GPIOZ               ((GPIO_TypeDef *) GPIOZ_BASE)
#define SDMMC2              ((SDMMC_TypeDef *) SDMMC2_BASE)

#define DLYB_SDMMC1         ((DLYB_TypeDef *) DLYB_SDMMC1_BASE)
#define DLYB_SDMMC2         ((DLYB_TypeDef *) DLYB_SDMMC2_BASE)
#define DLYB_SDMMC3         ((DLYB_TypeDef *) DLYB_SDMMC3_BASE)

#define DMA2                ((DMA_TypeDef *) DMA2_BASE)
#define DMA2_Stream0        ((DMA_Stream_TypeDef *) DMA2_Stream0_BASE)
#define DMA2_Stream1        ((DMA_Stream_TypeDef *) DMA2_Stream1_BASE)
#define DMA2_Stream2        ((DMA_Stream_TypeDef *) DMA2_Stream2_BASE)
#define DMA2_Stream3        ((DMA_Stream_TypeDef *) DMA2_Stream3_BASE)
#define DMA2_Stream4        ((DMA_Stream_TypeDef *) DMA2_Stream4_BASE)
#define DMA2_Stream5        ((DMA_Stream_TypeDef *) DMA2_Stream5_BASE)
#define DMA2_Stream6        ((DMA_Stream_TypeDef *) DMA2_Stream6_BASE)
#define DMA2_Stream7        ((DMA_Stream_TypeDef *) DMA2_Stream7_BASE)

#define DMA1                ((DMA_TypeDef *) DMA1_BASE)
#define DMA1_Stream0        ((DMA_Stream_TypeDef *) DMA1_Stream0_BASE)
#define DMA1_Stream1        ((DMA_Stream_TypeDef *) DMA1_Stream1_BASE)
#define DMA1_Stream2        ((DMA_Stream_TypeDef *) DMA1_Stream2_BASE)
#define DMA1_Stream3        ((DMA_Stream_TypeDef *) DMA1_Stream3_BASE)
#define DMA1_Stream4        ((DMA_Stream_TypeDef *) DMA1_Stream4_BASE)
#define DMA1_Stream5        ((DMA_Stream_TypeDef *) DMA1_Stream5_BASE)
#define DMA1_Stream6        ((DMA_Stream_TypeDef *) DMA1_Stream6_BASE)
#define DMA1_Stream7        ((DMA_Stream_TypeDef *) DMA1_Stream7_BASE)


#define DMAMUX1              ((DMAMUX_Channel_TypeDef *) DMAMUX1_BASE)
#define DMAMUX1_Channel0     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel0_BASE)
#define DMAMUX1_Channel1     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel1_BASE)
#define DMAMUX1_Channel2     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel2_BASE)
#define DMAMUX1_Channel3     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel3_BASE)
#define DMAMUX1_Channel4     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel4_BASE)
#define DMAMUX1_Channel5     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel5_BASE)
#define DMAMUX1_Channel6     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel6_BASE)
#define DMAMUX1_Channel7     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel7_BASE)
#define DMAMUX1_Channel8     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel8_BASE)
#define DMAMUX1_Channel9     ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel9_BASE)
#define DMAMUX1_Channel10    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel10_BASE)
#define DMAMUX1_Channel11    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel11_BASE)
#define DMAMUX1_Channel12    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel12_BASE)
#define DMAMUX1_Channel13    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel13_BASE)
#define DMAMUX1_Channel14    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel14_BASE)
#define DMAMUX1_Channel15    ((DMAMUX_Channel_TypeDef *) DMAMUX1_Channel15_BASE)

#define DMAMUX1_RequestGenerator0  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator0_BASE)
#define DMAMUX1_RequestGenerator1  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator1_BASE)
#define DMAMUX1_RequestGenerator2  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator2_BASE)
#define DMAMUX1_RequestGenerator3  ((DMAMUX_RequestGen_TypeDef *) DMAMUX1_RequestGenerator3_BASE)

#define DMAMUX1_ChannelStatus      ((DMAMUX_ChannelStatus_TypeDef *)    DMAMUX1_ChannelStatus_BASE)
#define DMAMUX1_RequestGenStatus   ((DMAMUX_RequestGenStatus_TypeDef *) DMAMUX1_RequestGenStatus_BASE)


#define FMC_Bank1           ((FMC_Bank1_TypeDef *) FMC_Bank1_R_BASE)
#define FMC_Bank1E          ((FMC_Bank1E_TypeDef *) FMC_Bank1E_R_BASE)
#define FMC_Bank2           ((FMC_Bank2_TypeDef *) FMC_Bank2_R_BASE)
#define FMC_Bank3           ((FMC_Bank3_TypeDef *) FMC_Bank3_R_BASE)
#define FMC_Bank5_6         ((FMC_Bank5_6_TypeDef *) FMC_Bank5_6_R_BASE)

#define QUADSPI               ((QUADSPI_TypeDef *) QSPI_R_BASE)
#define DLYB_QUADSPI          ((DLYB_TypeDef *) DLYB_QSPI_BASE)

#define SDMMC1                ((SDMMC_TypeDef *) SDMMC1_BASE)
#define SDMMC3                ((SDMMC_TypeDef *) SDMMC3_BASE)

#define DBGMCU              ((DBGMCU_TypeDef *) DBGMCU_BASE)

#define JPEG                ((JPEG_TypeDef *) JPGDEC_BASE)
#define HSEM                ((HSEM_TypeDef *) HSEM_BASE)
#define HSEM_COMMON         ((HSEM_Common_TypeDef *) (HSEM_BASE + 0x110U))


#define USBPHYC             ((USBPHYC_GlobalTypeDef *)USBPHYC_BASE)
#define USBPHYC_PHY1        ((USBPHYC_InstanceTypeDef *)USBPHYC_PHY1_BASE)
#define USBPHYC_PHY2        ((USBPHYC_InstanceTypeDef *)USBPHYC_PHY2_BASE)

#define DDRC                ((DDRC_TypeDef *)DDRC_BASE)
#define DDRPHYC             ((DDRPHYC_TypeDef *)DDRPHYC_BASE)
#define LTDC                ((LTDC_TypeDef *)LTDC_BASE)
#define LTDC_Layer1         ((LTDC_Layer_TypeDef *)LTDC_Layer1_BASE)
#define LTDC_Layer2         ((LTDC_Layer_TypeDef *)LTDC_Layer2_BASE)

#define TZC                 ((TZC_TypeDef *)TZC_BASE)
#define TZPC                ((TZPC_TypeDef *)TZPC_BASE)
#define STGENC              ((STGENC_TypeDef *)STGENC_BASE)


#define MDIOS               ((MDIOS_TypeDef *) MDIOS_BASE)

#define ETH                 ((ETH_TypeDef *) ETH_BASE)
#define MDMA                ((MDMA_TypeDef *) MDMA_BASE)
#define MDMA_Channel0       ((MDMA_Channel_TypeDef *)MDMA_Channel0_BASE)
#define MDMA_Channel1       ((MDMA_Channel_TypeDef *)MDMA_Channel1_BASE)
#define MDMA_Channel2       ((MDMA_Channel_TypeDef *)MDMA_Channel2_BASE)
#define MDMA_Channel3       ((MDMA_Channel_TypeDef *)MDMA_Channel3_BASE)
#define MDMA_Channel4       ((MDMA_Channel_TypeDef *)MDMA_Channel4_BASE)
#define MDMA_Channel5       ((MDMA_Channel_TypeDef *)MDMA_Channel5_BASE)
#define MDMA_Channel6       ((MDMA_Channel_TypeDef *)MDMA_Channel6_BASE)
#define MDMA_Channel7       ((MDMA_Channel_TypeDef *)MDMA_Channel7_BASE)
#define MDMA_Channel8       ((MDMA_Channel_TypeDef *)MDMA_Channel8_BASE)
#define MDMA_Channel9       ((MDMA_Channel_TypeDef *)MDMA_Channel9_BASE)
#define MDMA_Channel10      ((MDMA_Channel_TypeDef *)MDMA_Channel10_BASE)
#define MDMA_Channel11      ((MDMA_Channel_TypeDef *)MDMA_Channel11_BASE)
#define MDMA_Channel12      ((MDMA_Channel_TypeDef *)MDMA_Channel12_BASE)
#define MDMA_Channel13      ((MDMA_Channel_TypeDef *)MDMA_Channel13_BASE)
#define MDMA_Channel14      ((MDMA_Channel_TypeDef *)MDMA_Channel14_BASE)
#define MDMA_Channel15      ((MDMA_Channel_TypeDef *)MDMA_Channel15_BASE)
#define MDMA_Channel16      ((MDMA_Channel_TypeDef *)MDMA_Channel16_BASE)
#define MDMA_Channel17      ((MDMA_Channel_TypeDef *)MDMA_Channel17_BASE)
#define MDMA_Channel18      ((MDMA_Channel_TypeDef *)MDMA_Channel18_BASE)
#define MDMA_Channel19      ((MDMA_Channel_TypeDef *)MDMA_Channel19_BASE)
#define MDMA_Channel20      ((MDMA_Channel_TypeDef *)MDMA_Channel20_BASE)
#define MDMA_Channel21      ((MDMA_Channel_TypeDef *)MDMA_Channel21_BASE)
#define MDMA_Channel22      ((MDMA_Channel_TypeDef *)MDMA_Channel22_BASE)
#define MDMA_Channel23      ((MDMA_Channel_TypeDef *)MDMA_Channel23_BASE)
#define MDMA_Channel24      ((MDMA_Channel_TypeDef *)MDMA_Channel24_BASE)
#define MDMA_Channel25      ((MDMA_Channel_TypeDef *)MDMA_Channel25_BASE)
#define MDMA_Channel26      ((MDMA_Channel_TypeDef *)MDMA_Channel26_BASE)
#define MDMA_Channel27      ((MDMA_Channel_TypeDef *)MDMA_Channel27_BASE)
#define MDMA_Channel28      ((MDMA_Channel_TypeDef *)MDMA_Channel28_BASE)
#define MDMA_Channel29      ((MDMA_Channel_TypeDef *)MDMA_Channel29_BASE)
#define MDMA_Channel30      ((MDMA_Channel_TypeDef *)MDMA_Channel30_BASE)
#define MDMA_Channel31      ((MDMA_Channel_TypeDef *)MDMA_Channel31_BASE)

#define USB_OTG_HS            ((USB_OTG_GlobalTypeDef *) USBOTG_BASE)
/* backward compatibility */
#define USB1_OTG_HS           USB_OTG_HS
#define USB2_OTG_FS           ((USB_OTG_GlobalTypeDef *) 0x00000000)
#define USB_OTG_FS            USB2_OTG_FS

#define USB1_EHCI             ((USB_EHCI_CapabilityTypeDef *) USB1HSFSP1_BASE)




/**
  * @}
  */

/** @addtogroup Exported_constants
  * @{
  */

  /** @addtogroup Peripheral_Registers_Bits_Definition
  * @{
  */

/******************************************************************************/
/*                         Peripheral Registers_Bits_Definition               */
/******************************************************************************/

/******************************************************************************/
/*                                                                            */
/*                        Device Electronic Signature                         */
/*                                                                            */
/******************************************************************************/
#define PKG_ID_Pos              (27U)
#define PKG_ID_Msk              (0x7U << PKG_ID_Pos)        /*!< 0x38000000 */
#define PKG_ID                  PKG_ID_Msk                  /*!< Package Type */

#define RPN_ID_Pos              (0U)
#define RPN_ID_Msk              (0xFFU << RPN_ID_Pos)       /*!< 0x000000FF */
#define RPN_ID                  RPN_ID_Msk                  /*!< Device Part Number */

#define DV_DEV_ID_Pos           (0U)
#define DV_DEV_ID_Msk           (0xFFFU << DV_DEV_ID_Pos)   /*!< 0x00000FFF */
#define DV_DEV_ID               DV_DEV_ID_Msk               /*!< Device ID */
#define DV_REV_ID_Pos           (16U)
#define DV_REV_ID_Msk           (0xFFFFU << DV_REV_ID_Pos)  /*!< 0xFFFF0000 */
#define DV_REV_ID               DV_REV_ID_Msk               /*!< Device Rev ID */

/******************************************************************************/
/*                                                                            */
/*                        Analog to Digital Converter                         */
/*                                                                            */
/******************************************************************************/
/*
* @brief Specific device feature definitions (not present on all devices in the STM32L4 serie)
*/
#define ADC_MULTIMODE_SUPPORT                          /*!< ADC feature available only on specific devices: multimode available on devices with several ADC instances */

/********************  Bit definition for ADC_ISR register  ********************/
#define ADC_ISR_ADRDY_Pos                  (0U)
#define ADC_ISR_ADRDY_Msk                  (0x1U << ADC_ISR_ADRDY_Pos)           /*!< 0x00000001 */
#define ADC_ISR_ADRDY                      ADC_ISR_ADRDY_Msk                     /*!< ADC Ready (ADRDY) flag  */
#define ADC_ISR_EOSMP_Pos                 (1U)
#define ADC_ISR_EOSMP_Msk                 (0x1U << ADC_ISR_EOSMP_Pos)          /*!< 0x00000002 */
#define ADC_ISR_EOSMP                     ADC_ISR_EOSMP_Msk                    /*!< ADC End of Sampling flag */
#define ADC_ISR_EOC_Pos                   (2U)
#define ADC_ISR_EOC_Msk                   (0x1U << ADC_ISR_EOC_Pos)            /*!< 0x00000004 */
#define ADC_ISR_EOC                       ADC_ISR_EOC_Msk                      /*!< ADC End of Regular Conversion flag */
#define ADC_ISR_EOS_Pos                   (3U)
#define ADC_ISR_EOS_Msk                   (0x1U << ADC_ISR_EOS_Pos)            /*!< 0x00000008 */
#define ADC_ISR_EOS                       ADC_ISR_EOS_Msk                      /*!< ADC End of Regular sequence of Conversions flag */
#define ADC_ISR_OVR_Pos                   (4U)
#define ADC_ISR_OVR_Msk                   (0x1U << ADC_ISR_OVR_Pos)            /*!< 0x00000010 */
#define ADC_ISR_OVR                       ADC_ISR_OVR_Msk                      /*!< ADC overrun flag */
#define ADC_ISR_JEOC_Pos                  (5U)
#define ADC_ISR_JEOC_Msk                  (0x1U << ADC_ISR_JEOC_Pos)           /*!< 0x00000020 */
#define ADC_ISR_JEOC                      ADC_ISR_JEOC_Msk                     /*!< ADC End of Injected Conversion flag */
#define ADC_ISR_JEOS_Pos                  (6U)
#define ADC_ISR_JEOS_Msk                  (0x1U << ADC_ISR_JEOS_Pos)           /*!< 0x00000040 */
#define ADC_ISR_JEOS                      ADC_ISR_JEOS_Msk                     /*!< ADC End of Injected sequence of Conversions flag */
#define ADC_ISR_AWD1_Pos                  (7U)
#define ADC_ISR_AWD1_Msk                  (0x1U << ADC_ISR_AWD1_Pos)           /*!< 0x00000080 */
#define ADC_ISR_AWD1                      ADC_ISR_AWD1_Msk                     /*!< ADC Analog watchdog 1 flag */
#define ADC_ISR_AWD2_Pos                  (8U)
#define ADC_ISR_AWD2_Msk                  (0x1U << ADC_ISR_AWD2_Pos)           /*!< 0x00000100 */
#define ADC_ISR_AWD2                      ADC_ISR_AWD2_Msk                     /*!< ADC Analog watchdog 2 flag */
#define ADC_ISR_AWD3_Pos                  (9U)
#define ADC_ISR_AWD3_Msk                  (0x1U << ADC_ISR_AWD3_Pos)           /*!< 0x00000200 */
#define ADC_ISR_AWD3                      ADC_ISR_AWD3_Msk                     /*!< ADC Analog watchdog 3 flag */
#define ADC_ISR_JQOVF_Pos                 (10U)
#define ADC_ISR_JQOVF_Msk                 (0x1U << ADC_ISR_JQOVF_Pos)          /*!< 0x00000400 */
#define ADC_ISR_JQOVF                     ADC_ISR_JQOVF_Msk                    /*!< ADC Injected Context Queue Overflow flag */

/********************  Bit definition for ADC_IER register  ********************/
#define ADC_IER_ADRDYIE_Pos               (0U)
#define ADC_IER_ADRDYIE_Msk               (0x1U << ADC_IER_ADRDYIE_Pos)            /*!< 0x00000001 */
#define ADC_IER_ADRDYIE                   ADC_IER_ADRDYIE_Msk                      /*!< ADC Ready (ADRDY) interrupt source */
#define ADC_IER_EOSMPIE_Pos               (1U)
#define ADC_IER_EOSMPIE_Msk               (0x1U << ADC_IER_EOSMPIE_Pos)          /*!< 0x00000002 */
#define ADC_IER_EOSMPIE                   ADC_IER_EOSMPIE_Msk                    /*!< ADC End of Sampling interrupt source */
#define ADC_IER_EOCIE_Pos                 (2U)
#define ADC_IER_EOCIE_Msk                 (0x1U << ADC_IER_EOCIE_Pos)            /*!< 0x00000004 */
#define ADC_IER_EOCIE                     ADC_IER_EOCIE_Msk                      /*!< ADC End of Regular Conversion interrupt source */
#define ADC_IER_EOSIE_Pos                 (3U)
#define ADC_IER_EOSIE_Msk                 (0x1U << ADC_IER_EOSIE_Pos)            /*!< 0x00000008 */
#define ADC_IER_EOSIE                     ADC_IER_EOSIE_Msk                      /*!< ADC End of Regular sequence of Conversions interrupt source */
#define ADC_IER_OVRIE_Pos                 (4U)
#define ADC_IER_OVRIE_Msk                 (0x1U << ADC_IER_OVRIE_Pos)            /*!< 0x00000010 */
#define ADC_IER_OVRIE                     ADC_IER_OVRIE_Msk                      /*!< ADC overrun interrupt source */
#define ADC_IER_JEOCIE_Pos                (5U)
#define ADC_IER_JEOCIE_Msk                (0x1U << ADC_IER_JEOCIE_Pos)           /*!< 0x00000020 */
#define ADC_IER_JEOCIE                    ADC_IER_JEOCIE_Msk                     /*!< ADC End of Injected Conversion interrupt source */
#define ADC_IER_JEOSIE_Pos                (6U)
#define ADC_IER_JEOSIE_Msk                (0x1U << ADC_IER_JEOSIE_Pos)           /*!< 0x00000040 */
#define ADC_IER_JEOSIE                    ADC_IER_JEOSIE_Msk                     /*!< ADC End of Injected sequence of Conversions interrupt source */
#define ADC_IER_AWD1IE_Pos                (7U)
#define ADC_IER_AWD1IE_Msk                (0x1U << ADC_IER_AWD1IE_Pos)           /*!< 0x00000080 */
#define ADC_IER_AWD1IE                    ADC_IER_AWD1IE_Msk                     /*!< ADC Analog watchdog 1 interrupt source */
#define ADC_IER_AWD2IE_Pos                (8U)
#define ADC_IER_AWD2IE_Msk                (0x1U << ADC_IER_AWD2IE_Pos)           /*!< 0x00000100 */
#define ADC_IER_AWD2IE                    ADC_IER_AWD2IE_Msk                     /*!< ADC Analog watchdog 2 interrupt source */
#define ADC_IER_AWD3IE_Pos                (9U)
#define ADC_IER_AWD3IE_Msk                (0x1U << ADC_IER_AWD3IE_Pos)           /*!< 0x00000200 */
#define ADC_IER_AWD3IE                    ADC_IER_AWD3IE_Msk                     /*!< ADC Analog watchdog 3 interrupt source */
#define ADC_IER_JQOVFIE_Pos               (10U)
#define ADC_IER_JQOVFIE_Msk               (0x1U << ADC_IER_JQOVFIE_Pos)          /*!< 0x00000400 */
#define ADC_IER_JQOVFIE                   ADC_IER_JQOVFIE_Msk                    /*!< ADC Injected Context Queue Overflow interrupt source */

/********************  Bit definition for ADC_CR register  ********************/
#define ADC_CR_ADEN_Pos                   (0U)
#define ADC_CR_ADEN_Msk                   (0x1U << ADC_CR_ADEN_Pos)            /*!< 0x00000001 */
#define ADC_CR_ADEN                       ADC_CR_ADEN_Msk                      /*!< ADC Enable control */
#define ADC_CR_ADDIS_Pos                  (1U)
#define ADC_CR_ADDIS_Msk                  (0x1U << ADC_CR_ADDIS_Pos)           /*!< 0x00000002 */
#define ADC_CR_ADDIS                      ADC_CR_ADDIS_Msk                     /*!< ADC Disable command */
#define ADC_CR_ADSTART_Pos                (2U)
#define ADC_CR_ADSTART_Msk                (0x1U << ADC_CR_ADSTART_Pos)         /*!< 0x00000004 */
#define ADC_CR_ADSTART                    ADC_CR_ADSTART_Msk                   /*!< ADC Start of Regular conversion */
#define ADC_CR_JADSTART_Pos               (3U)
#define ADC_CR_JADSTART_Msk               (0x1U << ADC_CR_JADSTART_Pos)        /*!< 0x00000008 */
#define ADC_CR_JADSTART                   ADC_CR_JADSTART_Msk                  /*!< ADC Start of injected conversion */
#define ADC_CR_ADSTP_Pos                  (4U)
#define ADC_CR_ADSTP_Msk                  (0x1U << ADC_CR_ADSTP_Pos)           /*!< 0x00000010 */
#define ADC_CR_ADSTP                      ADC_CR_ADSTP_Msk                     /*!< ADC Stop of Regular conversion */
#define ADC_CR_JADSTP_Pos                 (5U)
#define ADC_CR_JADSTP_Msk                 (0x1U << ADC_CR_JADSTP_Pos)          /*!< 0x00000020 */
#define ADC_CR_JADSTP                     ADC_CR_JADSTP_Msk                    /*!< ADC Stop of injected conversion */
#define ADC_CR_BOOST_Pos                  (8U)
#define ADC_CR_BOOST_Msk                  (0x1U << ADC_CR_BOOST_Pos)           /*!< 0x00000100 */
#define ADC_CR_BOOST                      ADC_CR_BOOST_Msk                     /*!< ADC Boost Mode */
#define ADC_CR_ADCALLIN_Pos               (16U)
#define ADC_CR_ADCALLIN_Msk               (0x1U << ADC_CR_ADCALLIN_Pos)        /*!< 0x00010000 */
#define ADC_CR_ADCALLIN                   ADC_CR_ADCALLIN_Msk                  /*!< ADC Linearity calibration */
#define ADC_CR_LINCALRDYW1_Pos            (22U)
#define ADC_CR_LINCALRDYW1_Msk            (0x1U << ADC_CR_LINCALRDYW1_Pos)     /*!< 0x00400000 */
#define ADC_CR_LINCALRDYW1                ADC_CR_LINCALRDYW1_Msk               /*!< ADC Linearity calibration ready Word 1 */
#define ADC_CR_LINCALRDYW2_Pos            (23U)
#define ADC_CR_LINCALRDYW2_Msk            (0x1U << ADC_CR_LINCALRDYW2_Pos)     /*!< 0x00800000 */
#define ADC_CR_LINCALRDYW2                ADC_CR_LINCALRDYW2_Msk               /*!< ADC Linearity calibration ready Word 2 */
#define ADC_CR_LINCALRDYW3_Pos            (24U)
#define ADC_CR_LINCALRDYW3_Msk            (0x1U << ADC_CR_LINCALRDYW3_Pos)     /*!< 0x01000000 */
#define ADC_CR_LINCALRDYW3                ADC_CR_LINCALRDYW3_Msk               /*!< ADC Linearity calibration ready Word 3 */
#define ADC_CR_LINCALRDYW4_Pos            (25U)
#define ADC_CR_LINCALRDYW4_Msk            (0x1U << ADC_CR_LINCALRDYW4_Pos)     /*!< 0x02000000 */
#define ADC_CR_LINCALRDYW4                ADC_CR_LINCALRDYW4_Msk               /*!< ADC Linearity calibration ready Word 4 */
#define ADC_CR_LINCALRDYW5_Pos            (26U)
#define ADC_CR_LINCALRDYW5_Msk            (0x1U << ADC_CR_LINCALRDYW5_Pos)     /*!< 0x04000000 */
#define ADC_CR_LINCALRDYW5                ADC_CR_LINCALRDYW5_Msk               /*!< ADC Linearity calibration ready Word 5 */
#define ADC_CR_LINCALRDYW6_Pos            (27U)
#define ADC_CR_LINCALRDYW6_Msk            (0x1U << ADC_CR_LINCALRDYW6_Pos)     /*!< 0x08000000 */
#define ADC_CR_LINCALRDYW6                ADC_CR_LINCALRDYW6_Msk               /*!< ADC Linearity calibration ready Word 6 */
#define ADC_CR_ADVREGEN_Pos               (28U)
#define ADC_CR_ADVREGEN_Msk               (0x1U << ADC_CR_ADVREGEN_Pos)        /*!< 0x10000000 */
#define ADC_CR_ADVREGEN                   ADC_CR_ADVREGEN_Msk                  /*!< ADC Voltage regulator Enable */
#define ADC_CR_DEEPPWD_Pos                (29U)
#define ADC_CR_DEEPPWD_Msk                (0x1U << ADC_CR_DEEPPWD_Pos)         /*!< 0x20000000 */
#define ADC_CR_DEEPPWD                    ADC_CR_DEEPPWD_Msk                   /*!< ADC Deep power down Enable */
#define ADC_CR_ADCALDIF_Pos               (30U)
#define ADC_CR_ADCALDIF_Msk               (0x1U << ADC_CR_ADCALDIF_Pos)        /*!< 0x40000000 */
#define ADC_CR_ADCALDIF                   ADC_CR_ADCALDIF_Msk                  /*!< ADC Differential Mode for calibration */
#define ADC_CR_ADCAL_Pos                  (31U)
#define ADC_CR_ADCAL_Msk                  (0x1U << ADC_CR_ADCAL_Pos)           /*!< 0x80000000 */
#define ADC_CR_ADCAL                      ADC_CR_ADCAL_Msk                     /*!< ADC Calibration */

/********************  Bit definition for ADC_CFGR register  ********************/
#define ADC_CFGR_DMNGT_Pos                (0U)
#define ADC_CFGR_DMNGT_Msk                (0x3U << ADC_CFGR_DMNGT_Pos)         /*!< 0x00000003 */
#define ADC_CFGR_DMNGT                    ADC_CFGR_DMNGT_Msk                   /*!< ADC Data Management configuration */
#define ADC_CFGR_DMNGT_0                  (0x1U << ADC_CFGR_DMNGT_Pos)         /*!< 0x00000001 */
#define ADC_CFGR_DMNGT_1                  (0x2U << ADC_CFGR_DMNGT_Pos)         /*!< 0x00000002 */

#define ADC_CFGR_RES_Pos                  (2U)
#define ADC_CFGR_RES_Msk                  (0x7U << ADC_CFGR_RES_Pos)           /*!< 0x0000001C */
#define ADC_CFGR_RES                      ADC_CFGR_RES_Msk                     /*!< ADC Data resolution */
#define ADC_CFGR_RES_0                    (0x1U << ADC_CFGR_RES_Pos)           /*!< 0x00000004 */
#define ADC_CFGR_RES_1                    (0x2U << ADC_CFGR_RES_Pos)           /*!< 0x00000008 */
#define ADC_CFGR_RES_2                    (0x4U << ADC_CFGR_RES_Pos)           /*!< 0x00000010 */

#define ADC_CFGR_EXTSEL_Pos               (5U)
#define ADC_CFGR_EXTSEL_Msk               (0x1FU << ADC_CFGR_EXTSEL_Pos)       /*!< 0x000003E0 */
#define ADC_CFGR_EXTSEL                   ADC_CFGR_EXTSEL_Msk                  /*!< ADC External trigger selection for regular group */
#define ADC_CFGR_EXTSEL_0                 (0x01U << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000020 */
#define ADC_CFGR_EXTSEL_1                 (0x02U << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000040 */
#define ADC_CFGR_EXTSEL_2                 (0x04U << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000080 */
#define ADC_CFGR_EXTSEL_3                 (0x08U << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000100 */
#define ADC_CFGR_EXTSEL_4                 (0x10U << ADC_CFGR_EXTSEL_Pos)       /*!< 0x00000200 */

#define ADC_CFGR_EXTEN_Pos                (10U)
#define ADC_CFGR_EXTEN_Msk                (0x3U << ADC_CFGR_EXTEN_Pos)         /*!< 0x00000C00 */
#define ADC_CFGR_EXTEN                    ADC_CFGR_EXTEN_Msk                   /*!< ADC External trigger enable and polarity selection for regular channels */
#define ADC_CFGR_EXTEN_0                  (0x1U << ADC_CFGR_EXTEN_Pos)         /*!< 0x00000400 */
#define ADC_CFGR_EXTEN_1                  (0x2U << ADC_CFGR_EXTEN_Pos)         /*!< 0x00000800 */

#define ADC_CFGR_OVRMOD_Pos               (12U)
#define ADC_CFGR_OVRMOD_Msk               (0x1U << ADC_CFGR_OVRMOD_Pos)        /*!< 0x00001000 */
#define ADC_CFGR_OVRMOD                   ADC_CFGR_OVRMOD_Msk                  /*!< ADC overrun mode */
#define ADC_CFGR_CONT_Pos                 (13U)
#define ADC_CFGR_CONT_Msk                 (0x1U << ADC_CFGR_CONT_Pos)          /*!< 0x00002000 */
#define ADC_CFGR_CONT                     ADC_CFGR_CONT_Msk                    /*!< ADC Single/continuous conversion mode for regular conversion */
#define ADC_CFGR_AUTDLY_Pos               (14U)
#define ADC_CFGR_AUTDLY_Msk               (0x1U << ADC_CFGR_AUTDLY_Pos)        /*!< 0x00004000 */
#define ADC_CFGR_AUTDLY                   ADC_CFGR_AUTDLY_Msk                  /*!< ADC Delayed conversion mode */

#define ADC_CFGR_DISCEN_Pos               (16U)
#define ADC_CFGR_DISCEN_Msk               (0x1U << ADC_CFGR_DISCEN_Pos)        /*!< 0x00010000 */
#define ADC_CFGR_DISCEN                   ADC_CFGR_DISCEN_Msk                  /*!< ADC Discontinuous mode for regular channels */

#define ADC_CFGR_DISCNUM_Pos              (17U)
#define ADC_CFGR_DISCNUM_Msk              (0x7U << ADC_CFGR_DISCNUM_Pos)       /*!< 0x000E0000 */
#define ADC_CFGR_DISCNUM                  ADC_CFGR_DISCNUM_Msk                 /*!< ADC Discontinuous mode channel count */
#define ADC_CFGR_DISCNUM_0                (0x1U << ADC_CFGR_DISCNUM_Pos)       /*!< 0x00020000 */
#define ADC_CFGR_DISCNUM_1                (0x2U << ADC_CFGR_DISCNUM_Pos)       /*!< 0x00040000 */
#define ADC_CFGR_DISCNUM_2                (0x4U << ADC_CFGR_DISCNUM_Pos)       /*!< 0x00080000 */

#define ADC_CFGR_JDISCEN_Pos              (20U)
#define ADC_CFGR_JDISCEN_Msk              (0x1U << ADC_CFGR_JDISCEN_Pos)       /*!< 0x00100000 */
#define ADC_CFGR_JDISCEN                  ADC_CFGR_JDISCEN_Msk                 /*!< ADC Discontinuous mode on injected channels */
#define ADC_CFGR_JQM_Pos                  (21U)
#define ADC_CFGR_JQM_Msk                  (0x1U << ADC_CFGR_JQM_Pos)           /*!< 0x00200000 */
#define ADC_CFGR_JQM                      ADC_CFGR_JQM_Msk                     /*!< ADC JSQR Queue mode */
#define ADC_CFGR_AWD1SGL_Pos              (22U)
#define ADC_CFGR_AWD1SGL_Msk              (0x1U << ADC_CFGR_AWD1SGL_Pos)       /*!< 0x00400000 */
#define ADC_CFGR_AWD1SGL                  ADC_CFGR_AWD1SGL_Msk                 /*!< Enable the watchdog 1 on a single channel or on all channels */
#define ADC_CFGR_AWD1EN_Pos               (23U)
#define ADC_CFGR_AWD1EN_Msk               (0x1U << ADC_CFGR_AWD1EN_Pos)        /*!< 0x00800000 */
#define ADC_CFGR_AWD1EN                   ADC_CFGR_AWD1EN_Msk                  /*!< ADC Analog watchdog 1 enable on regular Channels */
#define ADC_CFGR_JAWD1EN_Pos              (24U)
#define ADC_CFGR_JAWD1EN_Msk              (0x1U << ADC_CFGR_JAWD1EN_Pos)       /*!< 0x01000000 */
#define ADC_CFGR_JAWD1EN                  ADC_CFGR_JAWD1EN_Msk                 /*!< ADC Analog watchdog 1 enable on injected Channels */
#define ADC_CFGR_JAUTO_Pos                (25U)
#define ADC_CFGR_JAUTO_Msk                (0x1U << ADC_CFGR_JAUTO_Pos)         /*!< 0x02000000 */
#define ADC_CFGR_JAUTO                    ADC_CFGR_JAUTO_Msk                   /*!< ADC Automatic injected group conversion */

#define ADC_CFGR_AWD1CH_Pos               (26U)
#define ADC_CFGR_AWD1CH_Msk               (0x1FU << ADC_CFGR_AWD1CH_Pos)       /*!< 0x7C000000 */
#define ADC_CFGR_AWD1CH                   ADC_CFGR_AWD1CH_Msk                  /*!< ADC Analog watchdog 1 Channel selection */
#define ADC_CFGR_AWD1CH_0                 (0x01U << ADC_CFGR_AWD1CH_Pos)       /*!< 0x04000000 */
#define ADC_CFGR_AWD1CH_1                 (0x02U << ADC_CFGR_AWD1CH_Pos)       /*!< 0x08000000 */
#define ADC_CFGR_AWD1CH_2                 (0x04U << ADC_CFGR_AWD1CH_Pos)       /*!< 0x10000000 */
#define ADC_CFGR_AWD1CH_3                 (0x08U << ADC_CFGR_AWD1CH_Pos)       /*!< 0x20000000 */
#define ADC_CFGR_AWD1CH_4                 (0x10U << ADC_CFGR_AWD1CH_Pos)       /*!< 0x40000000 */

#define ADC_CFGR_JQDIS_Pos                (31U)
#define ADC_CFGR_JQDIS_Msk                (0x1U << ADC_CFGR_JQDIS_Pos)         /*!< 0x80000000 */
#define ADC_CFGR_JQDIS                    ADC_CFGR_JQDIS_Msk                   /*!< ADC Injected queue disable */

/********************  Bit definition for ADC_CFGR2 register  ********************/
#define ADC_CFGR2_ROVSE_Pos               (0U)
#define ADC_CFGR2_ROVSE_Msk               (0x1U << ADC_CFGR2_ROVSE_Pos)        /*!< 0x00000001 */
#define ADC_CFGR2_ROVSE                   ADC_CFGR2_ROVSE_Msk                  /*!< ADC Regular group oversampler enable */
#define ADC_CFGR2_JOVSE_Pos               (1U)
#define ADC_CFGR2_JOVSE_Msk               (0x1U << ADC_CFGR2_JOVSE_Pos)        /*!< 0x00000002 */
#define ADC_CFGR2_JOVSE                   ADC_CFGR2_JOVSE_Msk                  /*!< ADC Injected group oversampler enable */

#define ADC_CFGR2_OVSR_Pos                (2U)
#define ADC_CFGR2_OVSR_Msk                (0x7U << ADC_CFGR2_OVSR_Pos)         /*!< 0x0000001C */
#define ADC_CFGR2_OVSR                    ADC_CFGR2_OVSR_Msk                   /*!< ADC Regular group oversampler enable TO Be removed after ADC driver update*/
#define ADC_CFGR2_OVSR_0                  (0x1U << ADC_CFGR2_OVSR_Pos)         /*!< 0x00000004 */
#define ADC_CFGR2_OVSR_1                  (0x2U << ADC_CFGR2_OVSR_Pos)         /*!< 0x00000008 */
#define ADC_CFGR2_OVSR_2                  (0x4U << ADC_CFGR2_OVSR_Pos)         /*!< 0x00000010 */

#define ADC_CFGR2_OVSS_Pos                (5U)
#define ADC_CFGR2_OVSS_Msk                (0xFU << ADC_CFGR2_OVSS_Pos)         /*!< 0x000001E0 */
#define ADC_CFGR2_OVSS                    ADC_CFGR2_OVSS_Msk                   /*!< ADC Regular Oversampling shift */
#define ADC_CFGR2_OVSS_0                  (0x1U << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000020 */
#define ADC_CFGR2_OVSS_1                  (0x2U << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000040 */
#define ADC_CFGR2_OVSS_2                  (0x4U << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000080 */
#define ADC_CFGR2_OVSS_3                  (0x8U << ADC_CFGR2_OVSS_Pos)         /*!< 0x00000100 */

#define ADC_CFGR2_TROVS_Pos               (9U)
#define ADC_CFGR2_TROVS_Msk               (0x1U << ADC_CFGR2_TROVS_Pos)        /*!< 0x00000200 */
#define ADC_CFGR2_TROVS                   ADC_CFGR2_TROVS_Msk                  /*!< ADC Triggered regular Oversampling */
#define ADC_CFGR2_ROVSM_Pos               (10U)
#define ADC_CFGR2_ROVSM_Msk               (0x1U << ADC_CFGR2_ROVSM_Pos)        /*!< 0x00000400 */
#define ADC_CFGR2_ROVSM                   ADC_CFGR2_ROVSM_Msk                  /*!< ADC Regular oversampling mode */

#define ADC_CFGR2_RSHIFT1_Pos             (11U)
#define ADC_CFGR2_RSHIFT1_Msk             (0x1U << ADC_CFGR2_RSHIFT1_Pos)      /*!< 0x00000800 */
#define ADC_CFGR2_RSHIFT1                 ADC_CFGR2_RSHIFT1_Msk                /*!< ADC Right-shift data after Offset 1 correction */
#define ADC_CFGR2_RSHIFT2_Pos             (12U)
#define ADC_CFGR2_RSHIFT2_Msk             (0x1U << ADC_CFGR2_RSHIFT2_Pos)      /*!< 0x00001000 */
#define ADC_CFGR2_RSHIFT2                 ADC_CFGR2_RSHIFT2_Msk                /*!< ADC Right-shift data after Offset 2 correction */
#define ADC_CFGR2_RSHIFT3_Pos             (13U)
#define ADC_CFGR2_RSHIFT3_Msk             (0x1U << ADC_CFGR2_RSHIFT3_Pos)      /*!< 0x00002000 */
#define ADC_CFGR2_RSHIFT3                 ADC_CFGR2_RSHIFT3_Msk                /*!< ADC Right-shift data after Offset 3 correction */
#define ADC_CFGR2_RSHIFT4_Pos             (14U)
#define ADC_CFGR2_RSHIFT4_Msk             (0x1U << ADC_CFGR2_RSHIFT4_Pos)      /*!< 0x00004000 */
#define ADC_CFGR2_RSHIFT4                 ADC_CFGR2_RSHIFT4_Msk                /*!< ADC Right-shift data after Offset 4 correction */

#define ADC_CFGR2_OSR_Pos                 (16U)
#define ADC_CFGR2_OSR_Msk                 (0x3FFU << ADC_CFGR2_OSR_Pos)        /*!< 0x03FF0000 */
#define ADC_CFGR2_OSR                     ADC_CFGR2_OSR_Msk                    /*!< ADC oversampling Ratio */
#define ADC_CFGR2_OSR_0                   (0x001U << ADC_CFGR2_OSR_Pos)        /*!< 0x00010000 */
#define ADC_CFGR2_OSR_1                   (0x002U << ADC_CFGR2_OSR_Pos)        /*!< 0x00020000 */
#define ADC_CFGR2_OSR_2                   (0x004U << ADC_CFGR2_OSR_Pos)        /*!< 0x00040000 */
#define ADC_CFGR2_OSR_3                   (0x008U << ADC_CFGR2_OSR_Pos)        /*!< 0x00080000 */
#define ADC_CFGR2_OSR_4                   (0x010U << ADC_CFGR2_OSR_Pos)        /*!< 0x00100000 */
#define ADC_CFGR2_OSR_5                   (0x020U << ADC_CFGR2_OSR_Pos)        /*!< 0x00200000 */
#define ADC_CFGR2_OSR_6                   (0x040U << ADC_CFGR2_OSR_Pos)        /*!< 0x00400000 */
#define ADC_CFGR2_OSR_7                   (0x080U << ADC_CFGR2_OSR_Pos)        /*!< 0x00800000 */
#define ADC_CFGR2_OSR_8                   (0x100U << ADC_CFGR2_OSR_Pos)        /*!< 0x01000000 */
#define ADC_CFGR2_OSR_9                   (0x200U << ADC_CFGR2_OSR_Pos)        /*!< 0x02000000 */

#define ADC_CFGR2_LSHIFT_Pos              (28U)
#define ADC_CFGR2_LSHIFT_Msk              (0xFU << ADC_CFGR2_LSHIFT_Pos)       /*!< 0xF0000000 */
#define ADC_CFGR2_LSHIFT                  ADC_CFGR2_LSHIFT_Msk                 /*!< ADC Left shift factor */
#define ADC_CFGR2_LSHIFT_0                (0x1U << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x10000000 */
#define ADC_CFGR2_LSHIFT_1                (0x2U << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x20000000 */
#define ADC_CFGR2_LSHIFT_2                (0x4U << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x40000000 */
#define ADC_CFGR2_LSHIFT_3                (0x8U << ADC_CFGR2_LSHIFT_Pos)       /*!< 0x80000000 */

/********************  Bit definition for ADC_SMPR1 register  ********************/
#define ADC_SMPR1_SMP0_Pos                (0U)
#define ADC_SMPR1_SMP0_Msk                (0x7U << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000007 */
#define ADC_SMPR1_SMP0                    ADC_SMPR1_SMP0_Msk                   /*!< ADC Channel 0 Sampling time selection  */
#define ADC_SMPR1_SMP0_0                  (0x1U << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000001 */
#define ADC_SMPR1_SMP0_1                  (0x2U << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000002 */
#define ADC_SMPR1_SMP0_2                  (0x4U << ADC_SMPR1_SMP0_Pos)         /*!< 0x00000004 */

#define ADC_SMPR1_SMP1_Pos                (3U)
#define ADC_SMPR1_SMP1_Msk                (0x7U << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000038 */
#define ADC_SMPR1_SMP1                    ADC_SMPR1_SMP1_Msk                   /*!< ADC Channel 1 Sampling time selection  */
#define ADC_SMPR1_SMP1_0                  (0x1U << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000008 */
#define ADC_SMPR1_SMP1_1                  (0x2U << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000010 */
#define ADC_SMPR1_SMP1_2                  (0x4U << ADC_SMPR1_SMP1_Pos)         /*!< 0x00000020 */

#define ADC_SMPR1_SMP2_Pos                (6U)
#define ADC_SMPR1_SMP2_Msk                (0x7U << ADC_SMPR1_SMP2_Pos)         /*!< 0x000001C0 */
#define ADC_SMPR1_SMP2                    ADC_SMPR1_SMP2_Msk                   /*!< ADC Channel 2 Sampling time selection  */
#define ADC_SMPR1_SMP2_0                  (0x1U << ADC_SMPR1_SMP2_Pos)         /*!< 0x00000040 */
#define ADC_SMPR1_SMP2_1                  (0x2U << ADC_SMPR1_SMP2_Pos)         /*!< 0x00000080 */
#define ADC_SMPR1_SMP2_2                  (0x4U << ADC_SMPR1_SMP2_Pos)         /*!< 0x00000100 */

#define ADC_SMPR1_SMP3_Pos                (9U)
#define ADC_SMPR1_SMP3_Msk                (0x7U << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000E00 */
#define ADC_SMPR1_SMP3                    ADC_SMPR1_SMP3_Msk                   /*!< ADC Channel 3 Sampling time selection  */
#define ADC_SMPR1_SMP3_0                  (0x1U << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000200 */
#define ADC_SMPR1_SMP3_1                  (0x2U << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000400 */
#define ADC_SMPR1_SMP3_2                  (0x4U << ADC_SMPR1_SMP3_Pos)         /*!< 0x00000800 */

#define ADC_SMPR1_SMP4_Pos                (12U)
#define ADC_SMPR1_SMP4_Msk                (0x7U << ADC_SMPR1_SMP4_Pos)         /*!< 0x00007000 */
#define ADC_SMPR1_SMP4                    ADC_SMPR1_SMP4_Msk                   /*!< ADC Channel 4 Sampling time selection  */
#define ADC_SMPR1_SMP4_0                  (0x1U << ADC_SMPR1_SMP4_Pos)         /*!< 0x00001000 */
#define ADC_SMPR1_SMP4_1                  (0x2U << ADC_SMPR1_SMP4_Pos)         /*!< 0x00002000 */
#define ADC_SMPR1_SMP4_2                  (0x4U << ADC_SMPR1_SMP4_Pos)         /*!< 0x00004000 */

#define ADC_SMPR1_SMP5_Pos                (15U)
#define ADC_SMPR1_SMP5_Msk                (0x7U << ADC_SMPR1_SMP5_Pos)         /*!< 0x00038000 */
#define ADC_SMPR1_SMP5                    ADC_SMPR1_SMP5_Msk                   /*!< ADC Channel 5 Sampling time selection  */
#define ADC_SMPR1_SMP5_0                  (0x1U << ADC_SMPR1_SMP5_Pos)         /*!< 0x00008000 */
#define ADC_SMPR1_SMP5_1                  (0x2U << ADC_SMPR1_SMP5_Pos)         /*!< 0x00010000 */
#define ADC_SMPR1_SMP5_2                  (0x4U << ADC_SMPR1_SMP5_Pos)         /*!< 0x00020000 */

#define ADC_SMPR1_SMP6_Pos                (18U)
#define ADC_SMPR1_SMP6_Msk                (0x7U << ADC_SMPR1_SMP6_Pos)         /*!< 0x001C0000 */
#define ADC_SMPR1_SMP6                    ADC_SMPR1_SMP6_Msk                   /*!< ADC Channel 6 Sampling time selection  */
#define ADC_SMPR1_SMP6_0                  (0x1U << ADC_SMPR1_SMP6_Pos)         /*!< 0x00040000 */
#define ADC_SMPR1_SMP6_1                  (0x2U << ADC_SMPR1_SMP6_Pos)         /*!< 0x00080000 */
#define ADC_SMPR1_SMP6_2                  (0x4U << ADC_SMPR1_SMP6_Pos)         /*!< 0x00100000 */

#define ADC_SMPR1_SMP7_Pos                (21U)
#define ADC_SMPR1_SMP7_Msk                (0x7U << ADC_SMPR1_SMP7_Pos)         /*!< 0x00E00000 */
#define ADC_SMPR1_SMP7                    ADC_SMPR1_SMP7_Msk                   /*!< ADC Channel 7 Sampling time selection  */
#define ADC_SMPR1_SMP7_0                  (0x1U << ADC_SMPR1_SMP7_Pos)         /*!< 0x00200000 */
#define ADC_SMPR1_SMP7_1                  (0x2U << ADC_SMPR1_SMP7_Pos)         /*!< 0x00400000 */
#define ADC_SMPR1_SMP7_2                  (0x4U << ADC_SMPR1_SMP7_Pos)         /*!< 0x00800000 */

#define ADC_SMPR1_SMP8_Pos                (24U)
#define ADC_SMPR1_SMP8_Msk                (0x7U << ADC_SMPR1_SMP8_Pos)         /*!< 0x07000000 */
#define ADC_SMPR1_SMP8                    ADC_SMPR1_SMP8_Msk                   /*!< ADC Channel 8 Sampling time selection  */
#define ADC_SMPR1_SMP8_0                  (0x1U << ADC_SMPR1_SMP8_Pos)         /*!< 0x01000000 */
#define ADC_SMPR1_SMP8_1                  (0x2U << ADC_SMPR1_SMP8_Pos)         /*!< 0x02000000 */
#define ADC_SMPR1_SMP8_2                  (0x4U << ADC_SMPR1_SMP8_Pos)         /*!< 0x04000000 */

#define ADC_SMPR1_SMP9_Pos                (27U)
#define ADC_SMPR1_SMP9_Msk                (0x7U << ADC_SMPR1_SMP9_Pos)         /*!< 0x38000000 */
#define ADC_SMPR1_SMP9                    ADC_SMPR1_SMP9_Msk                   /*!< ADC Channel 9 Sampling time selection  */
#define ADC_SMPR1_SMP9_0                  (0x1U << ADC_SMPR1_SMP9_Pos)         /*!< 0x08000000 */
#define ADC_SMPR1_SMP9_1                  (0x2U << ADC_SMPR1_SMP9_Pos)         /*!< 0x10000000 */
#define ADC_SMPR1_SMP9_2                  (0x4U << ADC_SMPR1_SMP9_Pos)         /*!< 0x20000000 */

/********************  Bit definition for ADC_SMPR2 register  ********************/
#define ADC_SMPR2_SMP10_Pos               (0U)
#define ADC_SMPR2_SMP10_Msk               (0x7U << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000007 */
#define ADC_SMPR2_SMP10                   ADC_SMPR2_SMP10_Msk                  /*!< ADC Channel 10 Sampling time selection  */
#define ADC_SMPR2_SMP10_0                 (0x1U << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000001 */
#define ADC_SMPR2_SMP10_1                 (0x2U << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000002 */
#define ADC_SMPR2_SMP10_2                 (0x4U << ADC_SMPR2_SMP10_Pos)        /*!< 0x00000004 */

#define ADC_SMPR2_SMP11_Pos               (3U)
#define ADC_SMPR2_SMP11_Msk               (0x7U << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000038 */
#define ADC_SMPR2_SMP11                   ADC_SMPR2_SMP11_Msk                  /*!< ADC Channel 11 Sampling time selection  */
#define ADC_SMPR2_SMP11_0                 (0x1U << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000008 */
#define ADC_SMPR2_SMP11_1                 (0x2U << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000010 */
#define ADC_SMPR2_SMP11_2                 (0x4U << ADC_SMPR2_SMP11_Pos)        /*!< 0x00000020 */

#define ADC_SMPR2_SMP12_Pos               (6U)
#define ADC_SMPR2_SMP12_Msk               (0x7U << ADC_SMPR2_SMP12_Pos)        /*!< 0x000001C0 */
#define ADC_SMPR2_SMP12                   ADC_SMPR2_SMP12_Msk                  /*!< ADC Channel 12 Sampling time selection  */
#define ADC_SMPR2_SMP12_0                 (0x1U << ADC_SMPR2_SMP12_Pos)        /*!< 0x00000040 */
#define ADC_SMPR2_SMP12_1                 (0x2U << ADC_SMPR2_SMP12_Pos)        /*!< 0x00000080 */
#define ADC_SMPR2_SMP12_2                 (0x4U << ADC_SMPR2_SMP12_Pos)        /*!< 0x00000100 */

#define ADC_SMPR2_SMP13_Pos               (9U)
#define ADC_SMPR2_SMP13_Msk               (0x7U << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000E00 */
#define ADC_SMPR2_SMP13                   ADC_SMPR2_SMP13_Msk                  /*!< ADC Channel 13 Sampling time selection  */
#define ADC_SMPR2_SMP13_0                 (0x1U << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000200 */
#define ADC_SMPR2_SMP13_1                 (0x2U << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000400 */
#define ADC_SMPR2_SMP13_2                 (0x4U << ADC_SMPR2_SMP13_Pos)        /*!< 0x00000800 */

#define ADC_SMPR2_SMP14_Pos               (12U)
#define ADC_SMPR2_SMP14_Msk               (0x7U << ADC_SMPR2_SMP14_Pos)        /*!< 0x00007000 */
#define ADC_SMPR2_SMP14                   ADC_SMPR2_SMP14_Msk                  /*!< ADC Channel 14 Sampling time selection  */
#define ADC_SMPR2_SMP14_0                 (0x1U << ADC_SMPR2_SMP14_Pos)        /*!< 0x00001000 */
#define ADC_SMPR2_SMP14_1                 (0x2U << ADC_SMPR2_SMP14_Pos)        /*!< 0x00002000 */
#define ADC_SMPR2_SMP14_2                 (0x4U << ADC_SMPR2_SMP14_Pos)        /*!< 0x00004000 */

#define ADC_SMPR2_SMP15_Pos               (15U)
#define ADC_SMPR2_SMP15_Msk               (0x7U << ADC_SMPR2_SMP15_Pos)        /*!< 0x00038000 */
#define ADC_SMPR2_SMP15                   ADC_SMPR2_SMP15_Msk                  /*!< ADC Channel 15 Sampling time selection  */
#define ADC_SMPR2_SMP15_0                 (0x1U << ADC_SMPR2_SMP15_Pos)        /*!< 0x00008000 */
#define ADC_SMPR2_SMP15_1                 (0x2U << ADC_SMPR2_SMP15_Pos)        /*!< 0x00010000 */
#define ADC_SMPR2_SMP15_2                 (0x4U << ADC_SMPR2_SMP15_Pos)        /*!< 0x00020000 */

#define ADC_SMPR2_SMP16_Pos               (18U)
#define ADC_SMPR2_SMP16_Msk               (0x7U << ADC_SMPR2_SMP16_Pos)        /*!< 0x001C0000 */
#define ADC_SMPR2_SMP16                   ADC_SMPR2_SMP16_Msk                  /*!< ADC Channel 16 Sampling time selection  */
#define ADC_SMPR2_SMP16_0                 (0x1U << ADC_SMPR2_SMP16_Pos)        /*!< 0x00040000 */
#define ADC_SMPR2_SMP16_1                 (0x2U << ADC_SMPR2_SMP16_Pos)        /*!< 0x00080000 */
#define ADC_SMPR2_SMP16_2                 (0x4U << ADC_SMPR2_SMP16_Pos)        /*!< 0x00100000 */

#define ADC_SMPR2_SMP17_Pos               (21U)
#define ADC_SMPR2_SMP17_Msk               (0x7U << ADC_SMPR2_SMP17_Pos)        /*!< 0x00E00000 */
#define ADC_SMPR2_SMP17                   ADC_SMPR2_SMP17_Msk                  /*!< ADC Channel 17 Sampling time selection  */
#define ADC_SMPR2_SMP17_0                 (0x1U << ADC_SMPR2_SMP17_Pos)        /*!< 0x00200000 */
#define ADC_SMPR2_SMP17_1                 (0x2U << ADC_SMPR2_SMP17_Pos)        /*!< 0x00400000 */
#define ADC_SMPR2_SMP17_2                 (0x4U << ADC_SMPR2_SMP17_Pos)        /*!< 0x00800000 */

#define ADC_SMPR2_SMP18_Pos               (24U)
#define ADC_SMPR2_SMP18_Msk               (0x7U << ADC_SMPR2_SMP18_Pos)        /*!< 0x07000000 */
#define ADC_SMPR2_SMP18                   ADC_SMPR2_SMP18_Msk                  /*!< ADC Channel 18 Sampling time selection  */
#define ADC_SMPR2_SMP18_0                 (0x1U << ADC_SMPR2_SMP18_Pos)        /*!< 0x01000000 */
#define ADC_SMPR2_SMP18_1                 (0x2U << ADC_SMPR2_SMP18_Pos)        /*!< 0x02000000 */
#define ADC_SMPR2_SMP18_2                 (0x4U << ADC_SMPR2_SMP18_Pos)        /*!< 0x04000000 */

#define ADC_SMPR2_SMP19_Pos               (27U)
#define ADC_SMPR2_SMP19_Msk               (0x7U << ADC_SMPR2_SMP19_Pos)        /*!< 0x38000000 */
#define ADC_SMPR2_SMP19                   ADC_SMPR2_SMP19_Msk                  /*!< ADC Channel 19 Sampling time selection  */
#define ADC_SMPR2_SMP19_0                 (0x1U << ADC_SMPR2_SMP19_Pos)        /*!< 0x08000000 */
#define ADC_SMPR2_SMP19_1                 (0x2U << ADC_SMPR2_SMP19_Pos)        /*!< 0x10000000 */
#define ADC_SMPR2_SMP19_2                 (0x4U << ADC_SMPR2_SMP19_Pos)        /*!< 0x20000000 */

/********************  Bit definition for ADC_PCSEL register  ********************/
#define ADC_PCSEL_PCSEL_Pos               (0U)
#define ADC_PCSEL_PCSEL_Msk               (0xFFFFFU << ADC_PCSEL_PCSEL_Pos)    /*!< 0x000FFFFF */
#define ADC_PCSEL_PCSEL                   ADC_PCSEL_PCSEL_Msk                  /*!< ADC pre channel selection */
#define ADC_PCSEL_PCSEL_0                 (0x00001U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000001 */
#define ADC_PCSEL_PCSEL_1                 (0x00002U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000002 */
#define ADC_PCSEL_PCSEL_2                 (0x00004U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000004 */
#define ADC_PCSEL_PCSEL_3                 (0x00008U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000008 */
#define ADC_PCSEL_PCSEL_4                 (0x00010U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000010 */
#define ADC_PCSEL_PCSEL_5                 (0x00020U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000020 */
#define ADC_PCSEL_PCSEL_6                 (0x00040U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000040 */
#define ADC_PCSEL_PCSEL_7                 (0x00080U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000080 */
#define ADC_PCSEL_PCSEL_8                 (0x00100U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000100 */
#define ADC_PCSEL_PCSEL_9                 (0x00200U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000200 */
#define ADC_PCSEL_PCSEL_10                (0x00400U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000400 */
#define ADC_PCSEL_PCSEL_11                (0x00800U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00000800 */
#define ADC_PCSEL_PCSEL_12                (0x01000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00001000 */
#define ADC_PCSEL_PCSEL_13                (0x02000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00002000 */
#define ADC_PCSEL_PCSEL_14                (0x04000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00004000 */
#define ADC_PCSEL_PCSEL_15                (0x08000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00008000 */
#define ADC_PCSEL_PCSEL_16                (0x10000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00010000 */
#define ADC_PCSEL_PCSEL_17                (0x20000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00020000 */
#define ADC_PCSEL_PCSEL_18                (0x40000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00040000 */
#define ADC_PCSEL_PCSEL_19                (0x80000U << ADC_PCSEL_PCSEL_Pos)    /*!< 0x00080000 */

/********************  Bit definition for ADC_LTR1 register  ********************/
#define ADC_LTR1_LT1_Pos                  (0U)
#define ADC_LTR1_LT1_Msk                  (0x3FFFFFFU << ADC_LTR1_LT1_Pos)     /*!< 0x03FFFFFF */
#define ADC_LTR1_LT1                      ADC_LTR1_LT1_Msk                     /*!< ADC Analog watchdog 1 lower threshold */
#define ADC_LTR1_LT1_0                    (0x0000001U << ADC_LTR1_LT1_Pos)     /*!< 0x00000001 */
#define ADC_LTR1_LT1_1                    (0x0000002U << ADC_LTR1_LT1_Pos)     /*!< 0x00000002 */
#define ADC_LTR1_LT1_2                    (0x0000004U << ADC_LTR1_LT1_Pos)     /*!< 0x00000004 */
#define ADC_LTR1_LT1_3                    (0x0000008U << ADC_LTR1_LT1_Pos)     /*!< 0x00000008 */
#define ADC_LTR1_LT1_4                    (0x0000010U << ADC_LTR1_LT1_Pos)     /*!< 0x00000010 */
#define ADC_LTR1_LT1_5                    (0x0000020U << ADC_LTR1_LT1_Pos)     /*!< 0x00000020 */
#define ADC_LTR1_LT1_6                    (0x0000040U << ADC_LTR1_LT1_Pos)     /*!< 0x00000040 */
#define ADC_LTR1_LT1_7                    (0x0000080U << ADC_LTR1_LT1_Pos)     /*!< 0x00000080 */
#define ADC_LTR1_LT1_8                    (0x0000100U << ADC_LTR1_LT1_Pos)     /*!< 0x00000100 */
#define ADC_LTR1_LT1_9                    (0x0000200U << ADC_LTR1_LT1_Pos)     /*!< 0x00000200 */
#define ADC_LTR1_LT1_10                   (0x0000400U << ADC_LTR1_LT1_Pos)     /*!< 0x00000400 */
#define ADC_LTR1_LT1_11                   (0x0000800U << ADC_LTR1_LT1_Pos)     /*!< 0x00000800 */
#define ADC_LTR1_LT1_12                   (0x0001000U << ADC_LTR1_LT1_Pos)     /*!< 0x00001000 */
#define ADC_LTR1_LT1_13                   (0x0002000U << ADC_LTR1_LT1_Pos)     /*!< 0x00002000 */
#define ADC_LTR1_LT1_14                   (0x0004000U << ADC_LTR1_LT1_Pos)     /*!< 0x00004000 */
#define ADC_LTR1_LT1_15                   (0x0008000U << ADC_LTR1_LT1_Pos)     /*!< 0x00008000 */
#define ADC_LTR1_LT1_16                   (0x0010000U << ADC_LTR1_LT1_Pos)     /*!< 0x00010000 */
#define ADC_LTR1_LT1_17                   (0x0020000U << ADC_LTR1_LT1_Pos)     /*!< 0x00020000 */
#define ADC_LTR1_LT1_18                   (0x0040000U << ADC_LTR1_LT1_Pos)     /*!< 0x00040000 */
#define ADC_LTR1_LT1_19                   (0x0080000U << ADC_LTR1_LT1_Pos)     /*!< 0x00080000 */
#define ADC_LTR1_LT1_20                   (0x0100000U << ADC_LTR1_LT1_Pos)     /*!< 0x00100000 */
#define ADC_LTR1_LT1_21                   (0x0200000U << ADC_LTR1_LT1_Pos)     /*!< 0x00200000 */
#define ADC_LTR1_LT1_22                   (0x0400000U << ADC_LTR1_LT1_Pos)     /*!< 0x00400000 */
#define ADC_LTR1_LT1_23                   (0x0800000U << ADC_LTR1_LT1_Pos)     /*!< 0x00800000 */
#define ADC_LTR1_LT1_24                   (0x1000000U << ADC_LTR1_LT1_Pos)     /*!< 0x01000000 */
#define ADC_LTR1_LT1_25                   (0x2000000U << ADC_LTR1_LT1_Pos)     /*!< 0x02000000 */

/********************  Bit definition for ADC_HTR1 register  ********************/
#define ADC_HTR1_HT1         ((uint32_t) 0x03FFFFFF) /*!< ADC Analog watchdog 1 higher threshold */
#define ADC_HTR1_HT1_0                    ((uint32_t)0x00000001)               /*!< ADC HT1 bit 0 */
#define ADC_HTR1_HT1_1                    ((uint32_t)0x00000002)               /*!< ADC HT1 bit 1 */
#define ADC_HTR1_HT1_2                    ((uint32_t)0x00000004)               /*!< ADC HT1 bit 2 */
#define ADC_HTR1_HT1_3                    ((uint32_t)0x00000008)               /*!< ADC HT1 bit 3 */
#define ADC_HTR1_HT1_4                    ((uint32_t)0x00000010)               /*!< ADC HT1 bit 4 */
#define ADC_HTR1_HT1_5                    ((uint32_t)0x00000020)               /*!< ADC HT1 bit 5 */
#define ADC_HTR1_HT1_6                    ((uint32_t)0x00000040)               /*!< ADC HT1 bit 6 */
#define ADC_HTR1_HT1_7                    ((uint32_t)0x00000080)               /*!< ADC HT1 bit 7 */
#define ADC_HTR1_HT1_8                    ((uint32_t)0x00000100)               /*!< ADC HT1 bit 8 */
#define ADC_HTR1_HT1_9                    ((uint32_t)0x00000200)               /*!< ADC HT1 bit 9 */
#define ADC_HTR1_HT1_10                   ((uint32_t)0x00000400)               /*!< ADC HT1 bit 10 */
#define ADC_HTR1_HT1_11                   ((uint32_t)0x00000800)               /*!< ADC HT1 bit 11 */
#define ADC_HTR1_HT1_12                   ((uint32_t)0x00001000)               /*!< ADC HT1 bit 12 */
#define ADC_HTR1_HT1_13                   ((uint32_t)0x00002000)               /*!< ADC HT1 bit 13 */
#define ADC_HTR1_HT1_14                   ((uint32_t)0x00004000)               /*!< ADC HT1 bit 14 */
#define ADC_HTR1_HT1_15                   ((uint32_t)0x00008000)               /*!< ADC HT1 bit 15 */
#define ADC_HTR1_HT1_16                   ((uint32_t)0x00010000)               /*!< ADC HT1 bit 16 */
#define ADC_HTR1_HT1_17                   ((uint32_t)0x00020000)               /*!< ADC HT1 bit 17 */
#define ADC_HTR1_HT1_18                   ((uint32_t)0x00040000)               /*!< ADC HT1 bit 18 */
#define ADC_HTR1_HT1_19                   ((uint32_t)0x00080000)               /*!< ADC HT1 bit 19 */
#define ADC_HTR1_HT1_20                   ((uint32_t)0x00100000)               /*!< ADC HT1 bit 20 */
#define ADC_HTR1_HT1_21                   ((uint32_t)0x00200000)               /*!< ADC HT1 bit 21 */
#define ADC_HTR1_HT1_22                   ((uint32_t)0x00400000)               /*!< ADC HT1 bit 22 */
#define ADC_HTR1_HT1_23                   ((uint32_t)0x00800000)               /*!< ADC HT1 bit 23 */
#define ADC_HTR1_HT1_24                   ((uint32_t)0x01000000)               /*!< ADC HT1 bit 24 */
#define ADC_HTR1_HT1_25                   ((uint32_t)0x02000000)               /*!< ADC HT1 bit 25 */

/********************  Bit definition for ADC_LTR2 register  ********************/
#define ADC_LTR2_LT2         ((uint32_t) 0x03FFFFFF) /*!< ADC Analog watchdog 2 lower threshold */
#define ADC_LTR2_LT2_0                    ((uint32_t)0x00000001)               /*!< ADC LT2 bit 0 */
#define ADC_LTR2_LT2_1                    ((uint32_t)0x00000002)               /*!< ADC LT2 bit 1 */
#define ADC_LTR2_LT2_2                    ((uint32_t)0x00000004)               /*!< ADC LT2 bit 2 */
#define ADC_LTR2_LT2_3                    ((uint32_t)0x00000008)               /*!< ADC LT2 bit 3 */
#define ADC_LTR2_LT2_4                    ((uint32_t)0x00000010)               /*!< ADC LT2 bit 4 */
#define ADC_LTR2_LT2_5                    ((uint32_t)0x00000020)               /*!< ADC LT2 bit 5 */
#define ADC_LTR2_LT2_6                    ((uint32_t)0x00000040)               /*!< ADC LT2 bit 6 */
#define ADC_LTR2_LT2_7                    ((uint32_t)0x00000080)               /*!< ADC LT2 bit 7 */
#define ADC_LTR2_LT2_8                    ((uint32_t)0x00000100)               /*!< ADC LT2 bit 8 */
#define ADC_LTR2_LT2_9                    ((uint32_t)0x00000200)               /*!< ADC LT2 bit 9 */
#define ADC_LTR2_LT2_10                   ((uint32_t)0x00000400)               /*!< ADC LT2 bit 10 */
#define ADC_LTR2_LT2_11                   ((uint32_t)0x00000800)               /*!< ADC LT2 bit 11 */
#define ADC_LTR2_LT2_12                   ((uint32_t)0x00001000)               /*!< ADC LT2 bit 12 */
#define ADC_LTR2_LT2_13                   ((uint32_t)0x00002000)               /*!< ADC LT2 bit 13 */
#define ADC_LTR2_LT2_14                   ((uint32_t)0x00004000)               /*!< ADC LT2 bit 14 */
#define ADC_LTR2_LT2_15                   ((uint32_t)0x00008000)               /*!< ADC LT2 bit 15 */
#define ADC_LTR2_LT2_16                   ((uint32_t)0x00010000)               /*!< ADC LT2 bit 16 */
#define ADC_LTR2_LT2_17                   ((uint32_t)0x00020000)               /*!< ADC LT2 bit 17 */
#define ADC_LTR2_LT2_18                   ((uint32_t)0x00040000)               /*!< ADC LT2 bit 18 */
#define ADC_LTR2_LT2_19                   ((uint32_t)0x00080000)               /*!< ADC LT2 bit 19 */
#define ADC_LTR2_LT2_20                   ((uint32_t)0x00100000)               /*!< ADC LT2 bit 20 */
#define ADC_LTR2_LT2_21                   ((uint32_t)0x00200000)               /*!< ADC LT2 bit 21 */
#define ADC_LTR2_LT2_22                   ((uint32_t)0x00400000)               /*!< ADC LT2 bit 22 */
#define ADC_LTR2_LT2_23                   ((uint32_t)0x00800000)               /*!< ADC LT2 bit 23 */
#define ADC_LTR2_LT2_24                   ((uint32_t)0x01000000)               /*!< ADC LT2 bit 24 */
#define ADC_LTR2_LT2_25                   ((uint32_t)0x02000000)               /*!< ADC LT2 bit 25 */

/********************  Bit definition for ADC_HTR2 register  ********************/
#define ADC_HTR2_HT2         ((uint32_t) 0x03FFFFFF) /*!< ADC Analog watchdog 2 higher threshold */
#define ADC_HTR2_HT2_0                    ((uint32_t)0x00000001)               /*!< ADC HT2 bit 0 */
#define ADC_HTR2_HT2_1                    ((uint32_t)0x00000002)               /*!< ADC HT2 bit 1 */
#define ADC_HTR2_HT2_2                    ((uint32_t)0x00000004)               /*!< ADC HT2 bit 2 */
#define ADC_HTR2_HT2_3                    ((uint32_t)0x00000008)               /*!< ADC HT2 bit 3 */
#define ADC_HTR2_HT2_4                    ((uint32_t)0x00000010)               /*!< ADC HT2 bit 4 */
#define ADC_HTR2_HT2_5                    ((uint32_t)0x00000020)               /*!< ADC HT2 bit 5 */
#define ADC_HTR2_HT2_6                    ((uint32_t)0x00000040)               /*!< ADC HT2 bit 6 */
#define ADC_HTR2_HT2_7                    ((uint32_t)0x00000080)               /*!< ADC HT2 bit 7 */
#define ADC_HTR2_HT2_8                    ((uint32_t)0x00000100)               /*!< ADC HT2 bit 8 */
#define ADC_HTR2_HT2_9                    ((uint32_t)0x00000200)               /*!< ADC HT2 bit 9 */
#define ADC_HTR2_HT2_10                   ((uint32_t)0x00000400)               /*!< ADC HT2 bit 10 */
#define ADC_HTR2_HT2_11                   ((uint32_t)0x00000800)               /*!< ADC HT2 bit 11 */
#define ADC_HTR2_HT2_12                   ((uint32_t)0x00001000)               /*!< ADC HT2 bit 12 */
#define ADC_HTR2_HT2_13                   ((uint32_t)0x00002000)               /*!< ADC HT2 bit 13 */
#define ADC_HTR2_HT2_14                   ((uint32_t)0x00004000)               /*!< ADC HT2 bit 14 */
#define ADC_HTR2_HT2_15                   ((uint32_t)0x00008000)               /*!< ADC HT2 bit 15 */
#define ADC_HTR2_HT2_16                   ((uint32_t)0x00010000)               /*!< ADC HT2 bit 16 */
#define ADC_HTR2_HT2_17                   ((uint32_t)0x00020000)               /*!< ADC HT2 bit 17 */
#define ADC_HTR2_HT2_18                   ((uint32_t)0x00040000)               /*!< ADC HT2 bit 18 */
#define ADC_HTR2_HT2_19                   ((uint32_t)0x00080000)               /*!< ADC HT2 bit 19 */
#define ADC_HTR2_HT2_20                   ((uint32_t)0x00100000)               /*!< ADC HT2 bit 20 */
#define ADC_HTR2_HT2_21                   ((uint32_t)0x00200000)               /*!< ADC HT2 bit 21 */
#define ADC_HTR2_HT2_22                   ((uint32_t)0x00400000)               /*!< ADC HT2 bit 22 */
#define ADC_HTR2_HT2_23                   ((uint32_t)0x00800000)               /*!< ADC HT2 bit 23 */
#define ADC_HTR2_HT2_24                   ((uint32_t)0x01000000)               /*!< ADC HT2 bit 24 */
#define ADC_HTR2_HT2_25      ((uint32_t)0x020000000) /*!< ADC HT2 bit 25 */

/********************  Bit definition for ADC_LTR3 register  ********************/
#define ADC_LTR3_LT3         ((uint32_t) 0x03FFFFFF) /*!< ADC Analog watchdog 3 lower threshold */
#define ADC_LTR3_LT3_0                    ((uint32_t)0x00000001)               /*!< ADC LT3 bit 0 */
#define ADC_LTR3_LT3_1                    ((uint32_t)0x00000002)               /*!< ADC LT3 bit 1 */
#define ADC_LTR3_LT3_2                    ((uint32_t)0x00000004)               /*!< ADC LT3 bit 2 */
#define ADC_LTR3_LT3_3                    ((uint32_t)0x00000008)               /*!< ADC LT3 bit 3 */
#define ADC_LTR3_LT3_4                    ((uint32_t)0x00000010)               /*!< ADC LT3 bit 4 */
#define ADC_LTR3_LT3_5                    ((uint32_t)0x00000020)               /*!< ADC LT3 bit 5 */
#define ADC_LTR3_LT3_6                    ((uint32_t)0x00000040)               /*!< ADC LT3 bit 6 */
#define ADC_LTR3_LT3_7                    ((uint32_t)0x00000080)               /*!< ADC LT3 bit 7 */
#define ADC_LTR3_LT3_8                    ((uint32_t)0x00000100)               /*!< ADC LT3 bit 8 */
#define ADC_LTR3_LT3_9                    ((uint32_t)0x00000200)               /*!< ADC LT3 bit 9 */
#define ADC_LTR3_LT3_10                   ((uint32_t)0x00000400)               /*!< ADC LT3 bit 10 */
#define ADC_LTR3_LT3_11                   ((uint32_t)0x00000800)               /*!< ADC LT3 bit 11 */
#define ADC_LTR3_LT3_12                   ((uint32_t)0x00001000)               /*!< ADC LT3 bit 12 */
#define ADC_LTR3_LT3_13                   ((uint32_t)0x00002000)               /*!< ADC LT3 bit 13 */
#define ADC_LTR3_LT3_14                   ((uint32_t)0x00004000)               /*!< ADC LT3 bit 14 */
#define ADC_LTR3_LT3_15                   ((uint32_t)0x00008000)               /*!< ADC LT3 bit 15 */
#define ADC_LTR3_LT3_16                   ((uint32_t)0x00010000)               /*!< ADC LT3 bit 16 */
#define ADC_LTR3_LT3_17                   ((uint32_t)0x00020000)               /*!< ADC LT3 bit 17 */
#define ADC_LTR3_LT3_18                   ((uint32_t)0x00040000)               /*!< ADC LT3 bit 18 */
#define ADC_LTR3_LT3_19                   ((uint32_t)0x00080000)               /*!< ADC LT3 bit 19 */
#define ADC_LTR3_LT3_20                   ((uint32_t)0x00100000)               /*!< ADC LT3 bit 20 */
#define ADC_LTR3_LT3_21                   ((uint32_t)0x00200000)               /*!< ADC LT3 bit 21 */
#define ADC_LTR3_LT3_22                   ((uint32_t)0x00400000)               /*!< ADC LT3 bit 22 */
#define ADC_LTR3_LT3_23                   ((uint32_t)0x00800000)               /*!< ADC LT3 bit 23 */
#define ADC_LTR3_LT3_24                   ((uint32_t)0x01000000)               /*!< ADC LT3 bit 24*/
#define ADC_LTR3_LT3_25                   ((uint32_t)0x02000000)               /*!< ADC LT3 bit 25 */

/********************  Bit definition for ADC_HTR3 register  ********************/
#define ADC_HTR3_HT3         ((uint32_t) 0x03FFFFFF) /*!< ADC Analog watchdog 3 higher threshold */
#define ADC_HTR3_HT3_0                    ((uint32_t)0x00000001)               /*!< ADC HT3 bit 0 */
#define ADC_HTR3_HT3_1                    ((uint32_t)0x00000002)               /*!< ADC HT3 bit 1 */
#define ADC_HTR3_HT3_2                    ((uint32_t)0x00000004)               /*!< ADC HT3 bit 2 */
#define ADC_HTR3_HT3_3                    ((uint32_t)0x00000008)               /*!< ADC HT3 bit 3 */
#define ADC_HTR3_HT3_4                    ((uint32_t)0x00000010)               /*!< ADC HT3 bit 4 */
#define ADC_HTR3_HT3_5                    ((uint32_t)0x00000020)               /*!< ADC HT3 bit 5 */
#define ADC_HTR3_HT3_6                    ((uint32_t)0x00000040)               /*!< ADC HT3 bit 6 */
#define ADC_HTR3_HT3_7                    ((uint32_t)0x00000080)               /*!< ADC HT3 bit 7 */
#define ADC_HTR3_HT3_8                    ((uint32_t)0x00000100)               /*!< ADC HT3 bit 8 */
#define ADC_HTR3_HT3_9                    ((uint32_t)0x00000200)               /*!< ADC HT3 bit 9 */
#define ADC_HTR3_HT3_10                   ((uint32_t)0x00000400)               /*!< ADC HT3 bit 10 */
#define ADC_HTR3_HT3_11                   ((uint32_t)0x00000800)               /*!< ADC HT3 bit 11 */
#define ADC_HTR3_HT3_12                   ((uint32_t)0x00001000)               /*!< ADC HT3 bit 12 */
#define ADC_HTR3_HT3_13                   ((uint32_t)0x00002000)               /*!< ADC HT3 bit 13 */
#define ADC_HTR3_HT3_14                   ((uint32_t)0x00004000)               /*!< ADC HT3 bit 14 */
#define ADC_HTR3_HT3_15                   ((uint32_t)0x00008000)               /*!< ADC HT3 bit 15 */
#define ADC_HTR3_HT3_16                   ((uint32_t)0x00010000)               /*!< ADC HT3 bit 16 */
#define ADC_HTR3_HT3_17                   ((uint32_t)0x00020000)               /*!< ADC HT3 bit 17 */
#define ADC_HTR3_HT3_18                   ((uint32_t)0x00040000)               /*!< ADC HT3 bit 18 */
#define ADC_HTR3_HT3_19                   ((uint32_t)0x00080000)               /*!< ADC HT3 bit 19 */
#define ADC_HTR3_HT3_20                   ((uint32_t)0x00100000)               /*!< ADC HT3 bit 20 */
#define ADC_HTR3_HT3_21                   ((uint32_t)0x00200000)               /*!< ADC HT3 bit 21 */
#define ADC_HTR3_HT3_22                   ((uint32_t)0x00400000)               /*!< ADC HT3 bit 22 */
#define ADC_HTR3_HT3_23                   ((uint32_t)0x00800000)               /*!< ADC HT3 bit 23 */
#define ADC_HTR3_HT3_24                   ((uint32_t)0x01000000)               /*!< ADC HT3 bit 24 */
#define ADC_HTR3_HT3_25                   ((uint32_t)0x02000000)               /*!< ADC HT3 bit 25 */

/********************  Bit definition for ADC_SQR1 register  ********************/
#define ADC_SQR1_L_Pos                    (0U)
#define ADC_SQR1_L_Msk                    (0xFU << ADC_SQR1_L_Pos)             /*!< 0x0000000F */
#define ADC_SQR1_L                        ADC_SQR1_L_Msk                       /*!< ADC regular channel sequence lenght */
#define ADC_SQR1_L_0                      (0x1U << ADC_SQR1_L_Pos)             /*!< 0x00000001 */
#define ADC_SQR1_L_1                      (0x2U << ADC_SQR1_L_Pos)             /*!< 0x00000002 */
#define ADC_SQR1_L_2                      (0x4U << ADC_SQR1_L_Pos)             /*!< 0x00000004 */
#define ADC_SQR1_L_3                      (0x8U << ADC_SQR1_L_Pos)             /*!< 0x00000008 */

#define ADC_SQR1_SQ1_Pos                  (6U)
#define ADC_SQR1_SQ1_Msk                  (0x1FU << ADC_SQR1_SQ1_Pos)          /*!< 0x000007C0 */
#define ADC_SQR1_SQ1                      ADC_SQR1_SQ1_Msk                     /*!< ADC 1st conversion in regular sequence */
#define ADC_SQR1_SQ1_0                    (0x01U << ADC_SQR1_SQ1_Pos)          /*!< 0x00000040 */
#define ADC_SQR1_SQ1_1                    (0x02U << ADC_SQR1_SQ1_Pos)          /*!< 0x00000080 */
#define ADC_SQR1_SQ1_2                    (0x04U << ADC_SQR1_SQ1_Pos)          /*!< 0x00000100 */
#define ADC_SQR1_SQ1_3                    (0x08U << ADC_SQR1_SQ1_Pos)          /*!< 0x00000200 */
#define ADC_SQR1_SQ1_4                    (0x10U << ADC_SQR1_SQ1_Pos)          /*!< 0x00000400 */

#define ADC_SQR1_SQ2_Pos                  (12U)
#define ADC_SQR1_SQ2_Msk                  (0x1FU << ADC_SQR1_SQ2_Pos)          /*!< 0x0001F000 */
#define ADC_SQR1_SQ2                      ADC_SQR1_SQ2_Msk                     /*!< ADC 2nd conversion in regular sequence */
#define ADC_SQR1_SQ2_0                    (0x01U << ADC_SQR1_SQ2_Pos)          /*!< 0x00001000 */
#define ADC_SQR1_SQ2_1                    (0x02U << ADC_SQR1_SQ2_Pos)          /*!< 0x00002000 */
#define ADC_SQR1_SQ2_2                    (0x04U << ADC_SQR1_SQ2_Pos)          /*!< 0x00004000 */
#define ADC_SQR1_SQ2_3                    (0x08U << ADC_SQR1_SQ2_Pos)          /*!< 0x00008000 */
#define ADC_SQR1_SQ2_4                    (0x10U << ADC_SQR1_SQ2_Pos)          /*!< 0x00010000 */

#define ADC_SQR1_SQ3_Pos                  (18U)
#define ADC_SQR1_SQ3_Msk                  (0x1FU << ADC_SQR1_SQ3_Pos)          /*!< 0x007C0000 */
#define ADC_SQR1_SQ3                      ADC_SQR1_SQ3_Msk                     /*!< ADC 3rd conversion in regular sequence */
#define ADC_SQR1_SQ3_0                    (0x01U << ADC_SQR1_SQ3_Pos)          /*!< 0x00040000 */
#define ADC_SQR1_SQ3_1                    (0x02U << ADC_SQR1_SQ3_Pos)          /*!< 0x00080000 */
#define ADC_SQR1_SQ3_2                    (0x04U << ADC_SQR1_SQ3_Pos)          /*!< 0x00100000 */
#define ADC_SQR1_SQ3_3                    (0x08U << ADC_SQR1_SQ3_Pos)          /*!< 0x00200000 */
#define ADC_SQR1_SQ3_4                    (0x10U << ADC_SQR1_SQ3_Pos)          /*!< 0x00400000 */

#define ADC_SQR1_SQ4_Pos                  (24U)
#define ADC_SQR1_SQ4_Msk                  (0x1FU << ADC_SQR1_SQ4_Pos)          /*!< 0x1F000000 */
#define ADC_SQR1_SQ4                      ADC_SQR1_SQ4_Msk                     /*!< ADC 4th conversion in regular sequence */
#define ADC_SQR1_SQ4_0                    (0x01U << ADC_SQR1_SQ4_Pos)          /*!< 0x01000000 */
#define ADC_SQR1_SQ4_1                    (0x02U << ADC_SQR1_SQ4_Pos)          /*!< 0x02000000 */
#define ADC_SQR1_SQ4_2                    (0x04U << ADC_SQR1_SQ4_Pos)          /*!< 0x04000000 */
#define ADC_SQR1_SQ4_3                    (0x08U << ADC_SQR1_SQ4_Pos)          /*!< 0x08000000 */
#define ADC_SQR1_SQ4_4                    (0x10U << ADC_SQR1_SQ4_Pos)          /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR2 register  ********************/
#define ADC_SQR2_SQ5_Pos                  (0U)
#define ADC_SQR2_SQ5_Msk                  (0x1FU << ADC_SQR2_SQ5_Pos)          /*!< 0x0000001F */
#define ADC_SQR2_SQ5                      ADC_SQR2_SQ5_Msk                     /*!< ADC 5th conversion in regular sequence */
#define ADC_SQR2_SQ5_0                    (0x01U << ADC_SQR2_SQ5_Pos)          /*!< 0x00000001 */
#define ADC_SQR2_SQ5_1                    (0x02U << ADC_SQR2_SQ5_Pos)          /*!< 0x00000002 */
#define ADC_SQR2_SQ5_2                    (0x04U << ADC_SQR2_SQ5_Pos)          /*!< 0x00000004 */
#define ADC_SQR2_SQ5_3                    (0x08U << ADC_SQR2_SQ5_Pos)          /*!< 0x00000008 */
#define ADC_SQR2_SQ5_4                    (0x10U << ADC_SQR2_SQ5_Pos)          /*!< 0x00000010 */

#define ADC_SQR2_SQ6_Pos                  (6U)
#define ADC_SQR2_SQ6_Msk                  (0x1FU << ADC_SQR2_SQ6_Pos)          /*!< 0x000007C0 */
#define ADC_SQR2_SQ6                      ADC_SQR2_SQ6_Msk                     /*!< ADC 6th conversion in regular sequence */
#define ADC_SQR2_SQ6_0                    (0x01U << ADC_SQR2_SQ6_Pos)          /*!< 0x00000040 */
#define ADC_SQR2_SQ6_1                    (0x02U << ADC_SQR2_SQ6_Pos)          /*!< 0x00000080 */
#define ADC_SQR2_SQ6_2                    (0x04U << ADC_SQR2_SQ6_Pos)          /*!< 0x00000100 */
#define ADC_SQR2_SQ6_3                    (0x08U << ADC_SQR2_SQ6_Pos)          /*!< 0x00000200 */
#define ADC_SQR2_SQ6_4                    (0x10U << ADC_SQR2_SQ6_Pos)          /*!< 0x00000400 */

#define ADC_SQR2_SQ7_Pos                  (12U)
#define ADC_SQR2_SQ7_Msk                  (0x1FU << ADC_SQR2_SQ7_Pos)          /*!< 0x0001F000 */
#define ADC_SQR2_SQ7                      ADC_SQR2_SQ7_Msk                     /*!< ADC 7th conversion in regular sequence */
#define ADC_SQR2_SQ7_0                    (0x01U << ADC_SQR2_SQ7_Pos)          /*!< 0x00001000 */
#define ADC_SQR2_SQ7_1                    (0x02U << ADC_SQR2_SQ7_Pos)          /*!< 0x00002000 */
#define ADC_SQR2_SQ7_2                    (0x04U << ADC_SQR2_SQ7_Pos)          /*!< 0x00004000 */
#define ADC_SQR2_SQ7_3                    (0x08U << ADC_SQR2_SQ7_Pos)          /*!< 0x00008000 */
#define ADC_SQR2_SQ7_4                    (0x10U << ADC_SQR2_SQ7_Pos)          /*!< 0x00010000 */

#define ADC_SQR2_SQ8_Pos                  (18U)
#define ADC_SQR2_SQ8_Msk                  (0x1FU << ADC_SQR2_SQ8_Pos)          /*!< 0x007C0000 */
#define ADC_SQR2_SQ8                      ADC_SQR2_SQ8_Msk                     /*!< ADC 8th conversion in regular sequence */
#define ADC_SQR2_SQ8_0                    (0x01U << ADC_SQR2_SQ8_Pos)          /*!< 0x00040000 */
#define ADC_SQR2_SQ8_1                    (0x02U << ADC_SQR2_SQ8_Pos)          /*!< 0x00080000 */
#define ADC_SQR2_SQ8_2                    (0x04U << ADC_SQR2_SQ8_Pos)          /*!< 0x00100000 */
#define ADC_SQR2_SQ8_3                    (0x08U << ADC_SQR2_SQ8_Pos)          /*!< 0x00200000 */
#define ADC_SQR2_SQ8_4                    (0x10U << ADC_SQR2_SQ8_Pos)          /*!< 0x00400000 */

#define ADC_SQR2_SQ9_Pos                  (24U)
#define ADC_SQR2_SQ9_Msk                  (0x1FU << ADC_SQR2_SQ9_Pos)          /*!< 0x1F000000 */
#define ADC_SQR2_SQ9                      ADC_SQR2_SQ9_Msk                     /*!< ADC 9th conversion in regular sequence */
#define ADC_SQR2_SQ9_0                    (0x01U << ADC_SQR2_SQ9_Pos)          /*!< 0x01000000 */
#define ADC_SQR2_SQ9_1                    (0x02U << ADC_SQR2_SQ9_Pos)          /*!< 0x02000000 */
#define ADC_SQR2_SQ9_2                    (0x04U << ADC_SQR2_SQ9_Pos)          /*!< 0x04000000 */
#define ADC_SQR2_SQ9_3                    (0x08U << ADC_SQR2_SQ9_Pos)          /*!< 0x08000000 */
#define ADC_SQR2_SQ9_4                    (0x10U << ADC_SQR2_SQ9_Pos)          /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR3 register  ********************/
#define ADC_SQR3_SQ10_Pos                 (0U)
#define ADC_SQR3_SQ10_Msk                 (0x1FU << ADC_SQR3_SQ10_Pos)         /*!< 0x0000001F */
#define ADC_SQR3_SQ10                     ADC_SQR3_SQ10_Msk                    /*!< ADC 10th conversion in regular sequence */
#define ADC_SQR3_SQ10_0                   (0x01U << ADC_SQR3_SQ10_Pos)         /*!< 0x00000001 */
#define ADC_SQR3_SQ10_1                   (0x02U << ADC_SQR3_SQ10_Pos)         /*!< 0x00000002 */
#define ADC_SQR3_SQ10_2                   (0x04U << ADC_SQR3_SQ10_Pos)         /*!< 0x00000004 */
#define ADC_SQR3_SQ10_3                   (0x08U << ADC_SQR3_SQ10_Pos)         /*!< 0x00000008 */
#define ADC_SQR3_SQ10_4                   (0x10U << ADC_SQR3_SQ10_Pos)         /*!< 0x00000010 */

#define ADC_SQR3_SQ11_Pos                 (6U)
#define ADC_SQR3_SQ11_Msk                 (0x1FU << ADC_SQR3_SQ11_Pos)         /*!< 0x000007C0 */
#define ADC_SQR3_SQ11                     ADC_SQR3_SQ11_Msk                    /*!< ADC 11th conversion in regular sequence */
#define ADC_SQR3_SQ11_0                   (0x01U << ADC_SQR3_SQ11_Pos)         /*!< 0x00000040 */
#define ADC_SQR3_SQ11_1                   (0x02U << ADC_SQR3_SQ11_Pos)         /*!< 0x00000080 */
#define ADC_SQR3_SQ11_2                   (0x04U << ADC_SQR3_SQ11_Pos)         /*!< 0x00000100 */
#define ADC_SQR3_SQ11_3                   (0x08U << ADC_SQR3_SQ11_Pos)         /*!< 0x00000200 */
#define ADC_SQR3_SQ11_4                   (0x10U << ADC_SQR3_SQ11_Pos)         /*!< 0x00000400 */

#define ADC_SQR3_SQ12_Pos                 (12U)
#define ADC_SQR3_SQ12_Msk                 (0x1FU << ADC_SQR3_SQ12_Pos)         /*!< 0x0001F000 */
#define ADC_SQR3_SQ12                     ADC_SQR3_SQ12_Msk                    /*!< ADC 12th conversion in regular sequence */
#define ADC_SQR3_SQ12_0                   (0x01U << ADC_SQR3_SQ12_Pos)         /*!< 0x00001000 */
#define ADC_SQR3_SQ12_1                   (0x02U << ADC_SQR3_SQ12_Pos)         /*!< 0x00002000 */
#define ADC_SQR3_SQ12_2                   (0x04U << ADC_SQR3_SQ12_Pos)         /*!< 0x00004000 */
#define ADC_SQR3_SQ12_3                   (0x08U << ADC_SQR3_SQ12_Pos)         /*!< 0x00008000 */
#define ADC_SQR3_SQ12_4                   (0x10U << ADC_SQR3_SQ12_Pos)         /*!< 0x00010000 */

#define ADC_SQR3_SQ13_Pos                 (18U)
#define ADC_SQR3_SQ13_Msk                 (0x1FU << ADC_SQR3_SQ13_Pos)         /*!< 0x007C0000 */
#define ADC_SQR3_SQ13                     ADC_SQR3_SQ13_Msk                    /*!< ADC 13th conversion in regular sequence */
#define ADC_SQR3_SQ13_0                   (0x01U << ADC_SQR3_SQ13_Pos)         /*!< 0x00040000 */
#define ADC_SQR3_SQ13_1                   (0x02U << ADC_SQR3_SQ13_Pos)         /*!< 0x00080000 */
#define ADC_SQR3_SQ13_2                   (0x04U << ADC_SQR3_SQ13_Pos)         /*!< 0x00100000 */
#define ADC_SQR3_SQ13_3                   (0x08U << ADC_SQR3_SQ13_Pos)         /*!< 0x00200000 */
#define ADC_SQR3_SQ13_4                   (0x10U << ADC_SQR3_SQ13_Pos)         /*!< 0x00400000 */

#define ADC_SQR3_SQ14_Pos                 (24U)
#define ADC_SQR3_SQ14_Msk                 (0x1FU << ADC_SQR3_SQ14_Pos)         /*!< 0x1F000000 */
#define ADC_SQR3_SQ14                     ADC_SQR3_SQ14_Msk                    /*!< ADC 14th conversion in regular sequence */
#define ADC_SQR3_SQ14_0                   (0x01U << ADC_SQR3_SQ14_Pos)         /*!< 0x01000000 */
#define ADC_SQR3_SQ14_1                   (0x02U << ADC_SQR3_SQ14_Pos)         /*!< 0x02000000 */
#define ADC_SQR3_SQ14_2                   (0x04U << ADC_SQR3_SQ14_Pos)         /*!< 0x04000000 */
#define ADC_SQR3_SQ14_3                   (0x08U << ADC_SQR3_SQ14_Pos)         /*!< 0x08000000 */
#define ADC_SQR3_SQ14_4                   (0x10U << ADC_SQR3_SQ14_Pos)         /*!< 0x10000000 */

/********************  Bit definition for ADC_SQR4 register  ********************/
#define ADC_SQR4_SQ15_Pos                 (0U)
#define ADC_SQR4_SQ15_Msk                 (0x1FU << ADC_SQR4_SQ15_Pos)         /*!< 0x0000001F */
#define ADC_SQR4_SQ15                     ADC_SQR4_SQ15_Msk                    /*!< ADC 15th conversion in regular sequence */
#define ADC_SQR4_SQ15_0                   (0x01U << ADC_SQR4_SQ15_Pos)         /*!< 0x00000001 */
#define ADC_SQR4_SQ15_1                   (0x02U << ADC_SQR4_SQ15_Pos)         /*!< 0x00000002 */
#define ADC_SQR4_SQ15_2                   (0x04U << ADC_SQR4_SQ15_Pos)         /*!< 0x00000004 */
#define ADC_SQR4_SQ15_3                   (0x08U << ADC_SQR4_SQ15_Pos)         /*!< 0x00000008 */
#define ADC_SQR4_SQ15_4                   (0x10U << ADC_SQR4_SQ15_Pos)         /*!< 0x00000010 */

#define ADC_SQR4_SQ16_Pos                 (6U)
#define ADC_SQR4_SQ16_Msk                 (0x1FU << ADC_SQR4_SQ16_Pos)         /*!< 0x000007C0 */
#define ADC_SQR4_SQ16                     ADC_SQR4_SQ16_Msk                    /*!< ADC 16th conversion in regular sequence */
#define ADC_SQR4_SQ16_0                   (0x01U << ADC_SQR4_SQ16_Pos)         /*!< 0x00000040 */
#define ADC_SQR4_SQ16_1                   (0x02U << ADC_SQR4_SQ16_Pos)         /*!< 0x00000080 */
#define ADC_SQR4_SQ16_2                   (0x04U << ADC_SQR4_SQ16_Pos)         /*!< 0x00000100 */
#define ADC_SQR4_SQ16_3                   (0x08U << ADC_SQR4_SQ16_Pos)         /*!< 0x00000200 */
#define ADC_SQR4_SQ16_4                   (0x10U << ADC_SQR4_SQ16_Pos)         /*!< 0x00000400 */
/********************  Bit definition for ADC_DR register  ********************/
#define ADC_DR_RDATA_Pos                  (0U)
#define ADC_DR_RDATA_Msk                  (0xFFFFU << ADC_DR_RDATA_Pos)        /*!< 0x0000FFFF */
#define ADC_DR_RDATA                      ADC_DR_RDATA_Msk                     /*!< ADC regular Data converted */
#define ADC_DR_RDATA_0                    (0x0001U << ADC_DR_RDATA_Pos)        /*!< 0x00000001 */
#define ADC_DR_RDATA_1                    (0x0002U << ADC_DR_RDATA_Pos)        /*!< 0x00000002 */
#define ADC_DR_RDATA_2                    (0x0004U << ADC_DR_RDATA_Pos)        /*!< 0x00000004 */
#define ADC_DR_RDATA_3                    (0x0008U << ADC_DR_RDATA_Pos)        /*!< 0x00000008 */
#define ADC_DR_RDATA_4                    (0x0010U << ADC_DR_RDATA_Pos)        /*!< 0x00000010 */
#define ADC_DR_RDATA_5                    (0x0020U << ADC_DR_RDATA_Pos)        /*!< 0x00000020 */
#define ADC_DR_RDATA_6                    (0x0040U << ADC_DR_RDATA_Pos)        /*!< 0x00000040 */
#define ADC_DR_RDATA_7                    (0x0080U << ADC_DR_RDATA_Pos)        /*!< 0x00000080 */
#define ADC_DR_RDATA_8                    (0x0100U << ADC_DR_RDATA_Pos)        /*!< 0x00000100 */
#define ADC_DR_RDATA_9                    (0x0200U << ADC_DR_RDATA_Pos)        /*!< 0x00000200 */
#define ADC_DR_RDATA_10                   (0x0400U << ADC_DR_RDATA_Pos)        /*!< 0x00000400 */
#define ADC_DR_RDATA_11                   (0x0800U << ADC_DR_RDATA_Pos)        /*!< 0x00000800 */
#define ADC_DR_RDATA_12                   (0x1000U << ADC_DR_RDATA_Pos)        /*!< 0x00001000 */
#define ADC_DR_RDATA_13                   (0x2000U << ADC_DR_RDATA_Pos)        /*!< 0x00002000 */
#define ADC_DR_RDATA_14                   (0x4000U << ADC_DR_RDATA_Pos)        /*!< 0x00004000 */
#define ADC_DR_RDATA_15                   (0x8000U << ADC_DR_RDATA_Pos)        /*!< 0x00008000 */
#define ADC_DR_RDATA_16                   (0x10000U << ADC_DR_RDATA_Pos)       /*!< 0x00010000 */
#define ADC_DR_RDATA_17                   (0x20000U << ADC_DR_RDATA_Pos)       /*!< 0x00020000 */
#define ADC_DR_RDATA_18                   (0x40000U << ADC_DR_RDATA_Pos)       /*!< 0x00040000 */
#define ADC_DR_RDATA_19                   (0x80000U << ADC_DR_RDATA_Pos)       /*!< 0x00080000 */
#define ADC_DR_RDATA_20                   (0x100000U << ADC_DR_RDATA_Pos)      /*!< 0x00100000 */
#define ADC_DR_RDATA_21                   (0x200000U << ADC_DR_RDATA_Pos)      /*!< 0x00200000 */
#define ADC_DR_RDATA_22                   (0x400000U << ADC_DR_RDATA_Pos)      /*!< 0x00400000 */
#define ADC_DR_RDATA_23                   (0x800000U << ADC_DR_RDATA_Pos)      /*!< 0x00800000 */
#define ADC_DR_RDATA_24                   (0x1000000U << ADC_DR_RDATA_Pos)     /*!< 0x01000000 */
#define ADC_DR_RDATA_25                   (0x2000000U << ADC_DR_RDATA_Pos)     /*!< 0x02000000 */
#define ADC_DR_RDATA_26                   (0x4000000U << ADC_DR_RDATA_Pos)     /*!< 0x04000000 */
#define ADC_DR_RDATA_27                   (0x8000000U << ADC_DR_RDATA_Pos)     /*!< 0x08000000 */
#define ADC_DR_RDATA_28                   (0x10000000U << ADC_DR_RDATA_Pos)    /*!< 0x10000000 */
#define ADC_DR_RDATA_29                   (0x20000000U << ADC_DR_RDATA_Pos)    /*!< 0x20000000 */
#define ADC_DR_RDATA_30                   (0x40000000U << ADC_DR_RDATA_Pos)    /*!< 0x40000000 */
#define ADC_DR_RDATA_31                   (0x80000000U << ADC_DR_RDATA_Pos)    /*!< 0x80000000 */

/********************  Bit definition for ADC_JSQR register  ********************/
#define ADC_JSQR_JL_Pos                   (0U)
#define ADC_JSQR_JL_Msk                   (0x3U << ADC_JSQR_JL_Pos)            /*!< 0x00000003 */
#define ADC_JSQR_JL                       ADC_JSQR_JL_Msk                      /*!< ADC injected channel sequence length */
#define ADC_JSQR_JL_0                     (0x1U << ADC_JSQR_JL_Pos)            /*!< 0x00000001 */
#define ADC_JSQR_JL_1                     (0x2U << ADC_JSQR_JL_Pos)            /*!< 0x00000002 */

#define ADC_JSQR_JEXTSEL_Pos              (2U)
#define ADC_JSQR_JEXTSEL_Msk              (0x1FU << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x0000007C */
#define ADC_JSQR_JEXTSEL                  ADC_JSQR_JEXTSEL_Msk                 /*!< ADC external trigger selection for injected group */
#define ADC_JSQR_JEXTSEL_0                (0x01U << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000004 */
#define ADC_JSQR_JEXTSEL_1                (0x02U << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000008 */
#define ADC_JSQR_JEXTSEL_2                (0x04U << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000010 */
#define ADC_JSQR_JEXTSEL_3                (0x08U << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000020 */
#define ADC_JSQR_JEXTSEL_4                (0x10U << ADC_JSQR_JEXTSEL_Pos)      /*!< 0x00000040 */

#define ADC_JSQR_JEXTEN_Pos               (7U)
#define ADC_JSQR_JEXTEN_Msk               (0x3U << ADC_JSQR_JEXTEN_Pos)        /*!< 0x00000180 */
#define ADC_JSQR_JEXTEN                   ADC_JSQR_JEXTEN_Msk                  /*!< ADC external trigger enable and polarity selection for injected channels */
#define ADC_JSQR_JEXTEN_0                 (0x1U << ADC_JSQR_JEXTEN_Pos)        /*!< 0x00000080 */
#define ADC_JSQR_JEXTEN_1                 (0x2U << ADC_JSQR_JEXTEN_Pos)        /*!< 0x00000100 */

#define ADC_JSQR_JSQ1_Pos                 (9U)
#define ADC_JSQR_JSQ1_Msk                 (0x1FU << ADC_JSQR_JSQ1_Pos)         /*!< 0x00003E00 */
#define ADC_JSQR_JSQ1                     ADC_JSQR_JSQ1_Msk                    /*!< ADC 1st conversion in injected sequence */
#define ADC_JSQR_JSQ1_0                   (0x01U << ADC_JSQR_JSQ1_Pos)         /*!< 0x00000200 */
#define ADC_JSQR_JSQ1_1                   (0x02U << ADC_JSQR_JSQ1_Pos)         /*!< 0x00000400 */
#define ADC_JSQR_JSQ1_2                   (0x04U << ADC_JSQR_JSQ1_Pos)         /*!< 0x00000800 */
#define ADC_JSQR_JSQ1_3                   (0x08U << ADC_JSQR_JSQ1_Pos)         /*!< 0x00001000 */
#define ADC_JSQR_JSQ1_4                   (0x10U << ADC_JSQR_JSQ1_Pos)         /*!< 0x00002000 */

#define ADC_JSQR_JSQ2_Pos                 (15U)
#define ADC_JSQR_JSQ2_Msk                 (0x1FU << ADC_JSQR_JSQ2_Pos)         /*!< 0x000F8000 */
#define ADC_JSQR_JSQ2                     ADC_JSQR_JSQ2_Msk                    /*!< ADC 2nd conversion in injected sequence */
#define ADC_JSQR_JSQ2_0                   (0x01U << ADC_JSQR_JSQ2_Pos)         /*!< 0x00008000 */
#define ADC_JSQR_JSQ2_1                   (0x02U << ADC_JSQR_JSQ2_Pos)         /*!< 0x00010000 */
#define ADC_JSQR_JSQ2_2                   (0x04U << ADC_JSQR_JSQ2_Pos)         /*!< 0x00020000 */
#define ADC_JSQR_JSQ2_3                   (0x08U << ADC_JSQR_JSQ2_Pos)         /*!< 0x00040000 */
#define ADC_JSQR_JSQ2_4                   (0x10U << ADC_JSQR_JSQ2_Pos)         /*!< 0x00080000 */

#define ADC_JSQR_JSQ3_Pos                 (21U)
#define ADC_JSQR_JSQ3_Msk                 (0x1FU << ADC_JSQR_JSQ3_Pos)         /*!< 0x03E00000 */
#define ADC_JSQR_JSQ3                     ADC_JSQR_JSQ3_Msk                    /*!< ADC 3rd conversion in injected sequence */
#define ADC_JSQR_JSQ3_0                   (0x01U << ADC_JSQR_JSQ3_Pos)         /*!< 0x00200000 */
#define ADC_JSQR_JSQ3_1                   (0x02U << ADC_JSQR_JSQ3_Pos)         /*!< 0x00400000 */
#define ADC_JSQR_JSQ3_2                   (0x04U << ADC_JSQR_JSQ3_Pos)         /*!< 0x00800000 */
#define ADC_JSQR_JSQ3_3                   (0x08U << ADC_JSQR_JSQ3_Pos)         /*!< 0x01000000 */
#define ADC_JSQR_JSQ3_4                   (0x10U << ADC_JSQR_JSQ3_Pos)         /*!< 0x02000000 */

#define ADC_JSQR_JSQ4_Pos                 (27U)
#define ADC_JSQR_JSQ4_Msk                 (0x1FU << ADC_JSQR_JSQ4_Pos)         /*!< 0xF8000000 */
#define ADC_JSQR_JSQ4                     ADC_JSQR_JSQ4_Msk                    /*!< ADC 4th conversion in injected sequence */
#define ADC_JSQR_JSQ4_0                   (0x01U << ADC_JSQR_JSQ4_Pos)         /*!< 0x08000000 */
#define ADC_JSQR_JSQ4_1                   (0x02U << ADC_JSQR_JSQ4_Pos)         /*!< 0x10000000 */
#define ADC_JSQR_JSQ4_2                   (0x04U << ADC_JSQR_JSQ4_Pos)         /*!< 0x20000000 */
#define ADC_JSQR_JSQ4_3                   (0x08U << ADC_JSQR_JSQ4_Pos)         /*!< 0x40000000 */
#define ADC_JSQR_JSQ4_4                   (0x10U << ADC_JSQR_JSQ4_Pos)         /*!< 0x80000000 */

/********************  Bit definition for ADC_OFR1 register  ********************/
#define ADC_OFR1_OFFSET1_Pos              (0U)
#define ADC_OFR1_OFFSET1_Msk              (0x3FFFFFFU << ADC_OFR1_OFFSET1_Pos) /*!< 0x03FFFFFF */
#define ADC_OFR1_OFFSET1                  ADC_OFR1_OFFSET1_Msk                 /*!< ADC data offset 1 for channel programmed into bits OFFSET1_CH[4:0] */
#define ADC_OFR1_OFFSET1_0                (0x0000001U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000001 */
#define ADC_OFR1_OFFSET1_1                (0x0000002U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000002 */
#define ADC_OFR1_OFFSET1_2                (0x0000004U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000004 */
#define ADC_OFR1_OFFSET1_3                (0x0000008U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000008 */
#define ADC_OFR1_OFFSET1_4                (0x0000010U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000010 */
#define ADC_OFR1_OFFSET1_5                (0x0000020U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000020 */
#define ADC_OFR1_OFFSET1_6                (0x0000040U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000040 */
#define ADC_OFR1_OFFSET1_7                (0x0000080U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000080 */
#define ADC_OFR1_OFFSET1_8                (0x0000100U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000100 */
#define ADC_OFR1_OFFSET1_9                (0x0000200U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000200 */
#define ADC_OFR1_OFFSET1_10               (0x0000400U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000400 */
#define ADC_OFR1_OFFSET1_11               (0x0000800U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00000800 */
#define ADC_OFR1_OFFSET1_12               (0x0001000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00001000 */
#define ADC_OFR1_OFFSET1_13               (0x0002000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00002000 */
#define ADC_OFR1_OFFSET1_14               (0x0004000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00004000 */
#define ADC_OFR1_OFFSET1_15               (0x0008000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00008000 */
#define ADC_OFR1_OFFSET1_16               (0x0010000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00010000 */
#define ADC_OFR1_OFFSET1_17               (0x0020000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00020000 */
#define ADC_OFR1_OFFSET1_18               (0x0040000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00040000 */
#define ADC_OFR1_OFFSET1_19               (0x0080000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00080000 */
#define ADC_OFR1_OFFSET1_20               (0x0100000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00100000 */
#define ADC_OFR1_OFFSET1_21               (0x0200000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00200000 */
#define ADC_OFR1_OFFSET1_22               (0x0400000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00400000 */
#define ADC_OFR1_OFFSET1_23               (0x0800000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x00800000 */
#define ADC_OFR1_OFFSET1_24               (0x1000000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x01000000 */
#define ADC_OFR1_OFFSET1_25               (0x2000000U << ADC_OFR1_OFFSET1_Pos) /*!< 0x02000000 */

#define ADC_OFR1_OFFSET1_CH_Pos           (26U)
#define ADC_OFR1_OFFSET1_CH_Msk           (0x1FU << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR1_OFFSET1_CH               ADC_OFR1_OFFSET1_CH_Msk              /*!< ADC Channel selection for the data offset 1 */
#define ADC_OFR1_OFFSET1_CH_0             (0x01U << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR1_OFFSET1_CH_1             (0x02U << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR1_OFFSET1_CH_2             (0x04U << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR1_OFFSET1_CH_3             (0x08U << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR1_OFFSET1_CH_4             (0x10U << ADC_OFR1_OFFSET1_CH_Pos)   /*!< 0x40000000 */

#define ADC_OFR1_SSATE_Pos                (31U)
#define ADC_OFR1_SSATE_Msk                (0x1U << ADC_OFR1_SSATE_Pos)         /*!< 0x80000000 */
#define ADC_OFR1_SSATE                    ADC_OFR1_SSATE_Msk                   /*!< ADC Signed saturation Enable */

/********************  Bit definition for ADC_OFR2 register  ********************/
#define ADC_OFR2_OFFSET2_Pos              (0U)
#define ADC_OFR2_OFFSET2_Msk              (0x3FFFFFFU << ADC_OFR2_OFFSET2_Pos) /*!< 0x03FFFFFF */
#define ADC_OFR2_OFFSET2                  ADC_OFR2_OFFSET2_Msk                 /*!< ADC data offset 2 for channel programmed into bits OFFSET2_CH[4:0] */
#define ADC_OFR2_OFFSET2_0                (0x0000001U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000001 */
#define ADC_OFR2_OFFSET2_1                (0x0000002U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000002 */
#define ADC_OFR2_OFFSET2_2                (0x0000004U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000004 */
#define ADC_OFR2_OFFSET2_3                (0x0000008U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000008 */
#define ADC_OFR2_OFFSET2_4                (0x0000010U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000010 */
#define ADC_OFR2_OFFSET2_5                (0x0000020U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000020 */
#define ADC_OFR2_OFFSET2_6                (0x0000040U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000040 */
#define ADC_OFR2_OFFSET2_7                (0x0000080U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000080 */
#define ADC_OFR2_OFFSET2_8                (0x0000100U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000100 */
#define ADC_OFR2_OFFSET2_9                (0x0000200U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000200 */
#define ADC_OFR2_OFFSET2_10               (0x0000400U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000400 */
#define ADC_OFR2_OFFSET2_11               (0x0000800U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00000800 */
#define ADC_OFR2_OFFSET2_12               (0x0001000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00001000 */
#define ADC_OFR2_OFFSET2_13               (0x0002000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00002000 */
#define ADC_OFR2_OFFSET2_14               (0x0004000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00004000 */
#define ADC_OFR2_OFFSET2_15               (0x0008000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00008000 */
#define ADC_OFR2_OFFSET2_16               (0x0010000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00010000 */
#define ADC_OFR2_OFFSET2_17               (0x0020000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00020000 */
#define ADC_OFR2_OFFSET2_18               (0x0040000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00040000 */
#define ADC_OFR2_OFFSET2_19               (0x0080000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00080000 */
#define ADC_OFR2_OFFSET2_20               (0x0100000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00100000 */
#define ADC_OFR2_OFFSET2_21               (0x0200000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00200000 */
#define ADC_OFR2_OFFSET2_22               (0x0400000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00400000 */
#define ADC_OFR2_OFFSET2_23               (0x0800000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x00800000 */
#define ADC_OFR2_OFFSET2_24               (0x1000000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x01000000 */
#define ADC_OFR2_OFFSET2_25               (0x2000000U << ADC_OFR2_OFFSET2_Pos) /*!< 0x02000000 */

#define ADC_OFR2_OFFSET2_CH_Pos           (26U)
#define ADC_OFR2_OFFSET2_CH_Msk           (0x1FU << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR2_OFFSET2_CH               ADC_OFR2_OFFSET2_CH_Msk              /*!< ADC Channel selection for the data offset 2 */
#define ADC_OFR2_OFFSET2_CH_0             (0x01U << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR2_OFFSET2_CH_1             (0x02U << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR2_OFFSET2_CH_2             (0x04U << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR2_OFFSET2_CH_3             (0x08U << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR2_OFFSET2_CH_4             (0x10U << ADC_OFR2_OFFSET2_CH_Pos)   /*!< 0x40000000 */

#define ADC_OFR2_SSATE_Pos                (31U)
#define ADC_OFR2_SSATE_Msk                (0x1U << ADC_OFR2_SSATE_Pos)         /*!< 0x80000000 */
#define ADC_OFR2_SSATE                    ADC_OFR2_SSATE_Msk                   /*!< ADC Signed saturation Enable */

/********************  Bit definition for ADC_OFR3 register  ********************/
#define ADC_OFR3_OFFSET3_Pos              (0U)
#define ADC_OFR3_OFFSET3_Msk              (0x3FFFFFFU << ADC_OFR3_OFFSET3_Pos) /*!< 0x03FFFFFF */
#define ADC_OFR3_OFFSET3                  ADC_OFR3_OFFSET3_Msk                 /*!< ADC data offset 3 for channel programmed into bits OFFSET3_CH[4:0] */
#define ADC_OFR3_OFFSET3_0                (0x0000001U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000001 */
#define ADC_OFR3_OFFSET3_1                (0x0000002U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000002 */
#define ADC_OFR3_OFFSET3_2                (0x0000004U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000004 */
#define ADC_OFR3_OFFSET3_3                (0x0000008U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000008 */
#define ADC_OFR3_OFFSET3_4                (0x0000010U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000010 */
#define ADC_OFR3_OFFSET3_5                (0x0000020U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000020 */
#define ADC_OFR3_OFFSET3_6                (0x0000040U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000040 */
#define ADC_OFR3_OFFSET3_7                (0x0000080U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000080 */
#define ADC_OFR3_OFFSET3_8                (0x0000100U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000100 */
#define ADC_OFR3_OFFSET3_9                (0x0000200U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000200 */
#define ADC_OFR3_OFFSET3_10               (0x0000400U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000400 */
#define ADC_OFR3_OFFSET3_11               (0x0000800U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00000800 */
#define ADC_OFR3_OFFSET3_12               (0x0001000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00001000 */
#define ADC_OFR3_OFFSET3_13               (0x0002000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00002000 */
#define ADC_OFR3_OFFSET3_14               (0x0004000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00004000 */
#define ADC_OFR3_OFFSET3_15               (0x0008000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00008000 */
#define ADC_OFR3_OFFSET3_16               (0x0010000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00010000 */
#define ADC_OFR3_OFFSET3_17               (0x0020000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00020000 */
#define ADC_OFR3_OFFSET3_18               (0x0040000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00040000 */
#define ADC_OFR3_OFFSET3_19               (0x0080000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00080000 */
#define ADC_OFR3_OFFSET3_20               (0x0100000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00100000 */
#define ADC_OFR3_OFFSET3_21               (0x0200000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00200000 */
#define ADC_OFR3_OFFSET3_22               (0x0400000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00400000 */
#define ADC_OFR3_OFFSET3_23               (0x0800000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x00800000 */
#define ADC_OFR3_OFFSET3_24               (0x1000000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x01000000 */
#define ADC_OFR3_OFFSET3_25               (0x2000000U << ADC_OFR3_OFFSET3_Pos) /*!< 0x02000000 */

#define ADC_OFR3_OFFSET3_CH_Pos           (26U)
#define ADC_OFR3_OFFSET3_CH_Msk           (0x1FU << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR3_OFFSET3_CH               ADC_OFR3_OFFSET3_CH_Msk              /*!< ADC Channel selection for the data offset 3 */
#define ADC_OFR3_OFFSET3_CH_0             (0x01U << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR3_OFFSET3_CH_1             (0x02U << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR3_OFFSET3_CH_2             (0x04U << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR3_OFFSET3_CH_3             (0x08U << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR3_OFFSET3_CH_4             (0x10U << ADC_OFR3_OFFSET3_CH_Pos)   /*!< 0x40000000 */

#define ADC_OFR3_SSATE_Pos                (31U)
#define ADC_OFR3_SSATE_Msk                (0x1U << ADC_OFR3_SSATE_Pos)         /*!< 0x80000000 */
#define ADC_OFR3_SSATE                    ADC_OFR3_SSATE_Msk                   /*!< ADC Signed saturation Enable */

/********************  Bit definition for ADC_OFR4 register  ********************/
#define ADC_OFR4_OFFSET4_Pos              (0U)
#define ADC_OFR4_OFFSET4_Msk              (0x3FFFFFFU << ADC_OFR4_OFFSET4_Pos) /*!< 0x03FFFFFF */
#define ADC_OFR4_OFFSET4                  ADC_OFR4_OFFSET4_Msk                 /*!< ADC data offset 4 for channel programmed into bits OFFSET4_CH[4:0] */
#define ADC_OFR4_OFFSET4_0                (0x0000001U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000001 */
#define ADC_OFR4_OFFSET4_1                (0x0000002U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000002 */
#define ADC_OFR4_OFFSET4_2                (0x0000004U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000004 */
#define ADC_OFR4_OFFSET4_3                (0x0000008U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000008 */
#define ADC_OFR4_OFFSET4_4                (0x0000010U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000010 */
#define ADC_OFR4_OFFSET4_5                (0x0000020U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000020 */
#define ADC_OFR4_OFFSET4_6                (0x0000040U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000040 */
#define ADC_OFR4_OFFSET4_7                (0x0000080U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000080 */
#define ADC_OFR4_OFFSET4_8                (0x0000100U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000100 */
#define ADC_OFR4_OFFSET4_9                (0x0000200U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000200 */
#define ADC_OFR4_OFFSET4_10               (0x0000400U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000400 */
#define ADC_OFR4_OFFSET4_11               (0x0000800U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00000800 */
#define ADC_OFR4_OFFSET4_12               (0x0001000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00001000 */
#define ADC_OFR4_OFFSET4_13               (0x0002000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00002000 */
#define ADC_OFR4_OFFSET4_14               (0x0004000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00004000 */
#define ADC_OFR4_OFFSET4_15               (0x0008000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00008000 */
#define ADC_OFR4_OFFSET4_16               (0x0010000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00010000 */
#define ADC_OFR4_OFFSET4_17               (0x0020000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00020000 */
#define ADC_OFR4_OFFSET4_18               (0x0040000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00040000 */
#define ADC_OFR4_OFFSET4_19               (0x0080000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00080000 */
#define ADC_OFR4_OFFSET4_20               (0x0100000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00100000 */
#define ADC_OFR4_OFFSET4_21               (0x0200000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00200000 */
#define ADC_OFR4_OFFSET4_22               (0x0400000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00400000 */
#define ADC_OFR4_OFFSET4_23               (0x0800000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x00800000 */
#define ADC_OFR4_OFFSET4_24               (0x1000000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x01000000 */
#define ADC_OFR4_OFFSET4_25               (0x2000000U << ADC_OFR4_OFFSET4_Pos) /*!< 0x02000000 */

#define ADC_OFR4_OFFSET4_CH_Pos           (26U)
#define ADC_OFR4_OFFSET4_CH_Msk           (0x1FU << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x7C000000 */
#define ADC_OFR4_OFFSET4_CH               ADC_OFR4_OFFSET4_CH_Msk              /*!< ADC Channel selection for the data offset 4 */
#define ADC_OFR4_OFFSET4_CH_0             (0x01U << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x04000000 */
#define ADC_OFR4_OFFSET4_CH_1             (0x02U << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x08000000 */
#define ADC_OFR4_OFFSET4_CH_2             (0x04U << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x10000000 */
#define ADC_OFR4_OFFSET4_CH_3             (0x08U << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x20000000 */
#define ADC_OFR4_OFFSET4_CH_4             (0x10U << ADC_OFR4_OFFSET4_CH_Pos)   /*!< 0x40000000 */

#define ADC_OFR4_SSATE_Pos                (31U)
#define ADC_OFR4_SSATE_Msk                (0x1U << ADC_OFR4_SSATE_Pos)         /*!< 0x80000000 */
#define ADC_OFR4_SSATE                    ADC_OFR4_SSATE_Msk                   /*!< ADC Signed saturation Enable */

/********************  Bit definition for ADC_JDR1 register  ********************/
#define ADC_JDR1_JDATA_Pos                (0U)
#define ADC_JDR1_JDATA_Msk                (0xFFFFU << ADC_JDR1_JDATA_Pos)      /*!< 0x0000FFFF */
#define ADC_JDR1_JDATA                    ADC_JDR1_JDATA_Msk                   /*!< ADC Injected DATA */
#define ADC_JDR1_JDATA_0                  (0x0001U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000001 */
#define ADC_JDR1_JDATA_1                  (0x0002U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000002 */
#define ADC_JDR1_JDATA_2                  (0x0004U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000004 */
#define ADC_JDR1_JDATA_3                  (0x0008U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000008 */
#define ADC_JDR1_JDATA_4                  (0x0010U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000010 */
#define ADC_JDR1_JDATA_5                  (0x0020U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000020 */
#define ADC_JDR1_JDATA_6                  (0x0040U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000040 */
#define ADC_JDR1_JDATA_7                  (0x0080U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000080 */
#define ADC_JDR1_JDATA_8                  (0x0100U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000100 */
#define ADC_JDR1_JDATA_9                  (0x0200U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000200 */
#define ADC_JDR1_JDATA_10                 (0x0400U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000400 */
#define ADC_JDR1_JDATA_11                 (0x0800U << ADC_JDR1_JDATA_Pos)      /*!< 0x00000800 */
#define ADC_JDR1_JDATA_12                 (0x1000U << ADC_JDR1_JDATA_Pos)      /*!< 0x00001000 */
#define ADC_JDR1_JDATA_13                 (0x2000U << ADC_JDR1_JDATA_Pos)      /*!< 0x00002000 */
#define ADC_JDR1_JDATA_14                 (0x4000U << ADC_JDR1_JDATA_Pos)      /*!< 0x00004000 */
#define ADC_JDR1_JDATA_15                 (0x8000U << ADC_JDR1_JDATA_Pos)      /*!< 0x00008000 */
#define ADC_JDR1_JDATA_16                 (0x10000U << ADC_JDR1_JDATA_Pos)     /*!< 0x00010000 */
#define ADC_JDR1_JDATA_17                 (0x20000U << ADC_JDR1_JDATA_Pos)     /*!< 0x00020000 */
#define ADC_JDR1_JDATA_18                 (0x40000U << ADC_JDR1_JDATA_Pos)     /*!< 0x00040000 */
#define ADC_JDR1_JDATA_19                 (0x80000U << ADC_JDR1_JDATA_Pos)     /*!< 0x00080000 */
#define ADC_JDR1_JDATA_20                 (0x100000U << ADC_JDR1_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR1_JDATA_21                 (0x200000U << ADC_JDR1_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR1_JDATA_22                 (0x400000U << ADC_JDR1_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR1_JDATA_23                 (0x800000U << ADC_JDR1_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR1_JDATA_24                 (0x1000000U << ADC_JDR1_JDATA_Pos)   /*!< 0x01000000 */
#define ADC_JDR1_JDATA_25                 (0x2000000U << ADC_JDR1_JDATA_Pos)   /*!< 0x02000000 */
#define ADC_JDR1_JDATA_26                 (0x4000000U << ADC_JDR1_JDATA_Pos)   /*!< 0x04000000 */
#define ADC_JDR1_JDATA_27                 (0x8000000U << ADC_JDR1_JDATA_Pos)   /*!< 0x08000000 */
#define ADC_JDR1_JDATA_28                 (0x10000000U << ADC_JDR1_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR1_JDATA_29                 (0x20000000U << ADC_JDR1_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR1_JDATA_30                 (0x40000000U << ADC_JDR1_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR1_JDATA_31                 (0x80000000U << ADC_JDR1_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR2 register  ********************/
#define ADC_JDR2_JDATA_Pos                (0U)
#define ADC_JDR2_JDATA_Msk                (0xFFFFU << ADC_JDR2_JDATA_Pos)      /*!< 0x0000FFFF */
#define ADC_JDR2_JDATA                    ADC_JDR2_JDATA_Msk                   /*!< ADC Injected DATA */
#define ADC_JDR2_JDATA_0                  (0x0001U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000001 */
#define ADC_JDR2_JDATA_1                  (0x0002U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000002 */
#define ADC_JDR2_JDATA_2                  (0x0004U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000004 */
#define ADC_JDR2_JDATA_3                  (0x0008U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000008 */
#define ADC_JDR2_JDATA_4                  (0x0010U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000010 */
#define ADC_JDR2_JDATA_5                  (0x0020U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000020 */
#define ADC_JDR2_JDATA_6                  (0x0040U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000040 */
#define ADC_JDR2_JDATA_7                  (0x0080U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000080 */
#define ADC_JDR2_JDATA_8                  (0x0100U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000100 */
#define ADC_JDR2_JDATA_9                  (0x0200U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000200 */
#define ADC_JDR2_JDATA_10                 (0x0400U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000400 */
#define ADC_JDR2_JDATA_11                 (0x0800U << ADC_JDR2_JDATA_Pos)      /*!< 0x00000800 */
#define ADC_JDR2_JDATA_12                 (0x1000U << ADC_JDR2_JDATA_Pos)      /*!< 0x00001000 */
#define ADC_JDR2_JDATA_13                 (0x2000U << ADC_JDR2_JDATA_Pos)      /*!< 0x00002000 */
#define ADC_JDR2_JDATA_14                 (0x4000U << ADC_JDR2_JDATA_Pos)      /*!< 0x00004000 */
#define ADC_JDR2_JDATA_15                 (0x8000U << ADC_JDR2_JDATA_Pos)      /*!< 0x00008000 */
#define ADC_JDR2_JDATA_16                 (0x10000U << ADC_JDR2_JDATA_Pos)     /*!< 0x00010000 */
#define ADC_JDR2_JDATA_17                 (0x20000U << ADC_JDR2_JDATA_Pos)     /*!< 0x00020000 */
#define ADC_JDR2_JDATA_18                 (0x40000U << ADC_JDR2_JDATA_Pos)     /*!< 0x00040000 */
#define ADC_JDR2_JDATA_19                 (0x80000U << ADC_JDR2_JDATA_Pos)     /*!< 0x00080000 */
#define ADC_JDR2_JDATA_20                 (0x100000U << ADC_JDR2_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR2_JDATA_21                 (0x200000U << ADC_JDR2_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR2_JDATA_22                 (0x400000U << ADC_JDR2_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR2_JDATA_23                 (0x800000U << ADC_JDR2_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR2_JDATA_24                 (0x1000000U << ADC_JDR2_JDATA_Pos)   /*!< 0x01000000 */
#define ADC_JDR2_JDATA_25                 (0x2000000U << ADC_JDR2_JDATA_Pos)   /*!< 0x02000000 */
#define ADC_JDR2_JDATA_26                 (0x4000000U << ADC_JDR2_JDATA_Pos)   /*!< 0x04000000 */
#define ADC_JDR2_JDATA_27                 (0x8000000U << ADC_JDR2_JDATA_Pos)   /*!< 0x08000000 */
#define ADC_JDR2_JDATA_28                 (0x10000000U << ADC_JDR2_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR2_JDATA_29                 (0x20000000U << ADC_JDR2_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR2_JDATA_30                 (0x40000000U << ADC_JDR2_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR2_JDATA_31                 (0x80000000U << ADC_JDR2_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR3 register  ********************/
#define ADC_JDR3_JDATA_Pos                (0U)
#define ADC_JDR3_JDATA_Msk                (0xFFFFU << ADC_JDR3_JDATA_Pos)      /*!< 0x0000FFFF */
#define ADC_JDR3_JDATA                    ADC_JDR3_JDATA_Msk                   /*!< ADC Injected DATA */
#define ADC_JDR3_JDATA_0                  (0x0001U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000001 */
#define ADC_JDR3_JDATA_1                  (0x0002U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000002 */
#define ADC_JDR3_JDATA_2                  (0x0004U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000004 */
#define ADC_JDR3_JDATA_3                  (0x0008U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000008 */
#define ADC_JDR3_JDATA_4                  (0x0010U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000010 */
#define ADC_JDR3_JDATA_5                  (0x0020U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000020 */
#define ADC_JDR3_JDATA_6                  (0x0040U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000040 */
#define ADC_JDR3_JDATA_7                  (0x0080U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000080 */
#define ADC_JDR3_JDATA_8                  (0x0100U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000100 */
#define ADC_JDR3_JDATA_9                  (0x0200U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000200 */
#define ADC_JDR3_JDATA_10                 (0x0400U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000400 */
#define ADC_JDR3_JDATA_11                 (0x0800U << ADC_JDR3_JDATA_Pos)      /*!< 0x00000800 */
#define ADC_JDR3_JDATA_12                 (0x1000U << ADC_JDR3_JDATA_Pos)      /*!< 0x00001000 */
#define ADC_JDR3_JDATA_13                 (0x2000U << ADC_JDR3_JDATA_Pos)      /*!< 0x00002000 */
#define ADC_JDR3_JDATA_14                 (0x4000U << ADC_JDR3_JDATA_Pos)      /*!< 0x00004000 */
#define ADC_JDR3_JDATA_15                 (0x8000U << ADC_JDR3_JDATA_Pos)      /*!< 0x00008000 */
#define ADC_JDR3_JDATA_16                 (0x10000U << ADC_JDR3_JDATA_Pos)     /*!< 0x00010000 */
#define ADC_JDR3_JDATA_17                 (0x20000U << ADC_JDR3_JDATA_Pos)     /*!< 0x00020000 */
#define ADC_JDR3_JDATA_18                 (0x40000U << ADC_JDR3_JDATA_Pos)     /*!< 0x00040000 */
#define ADC_JDR3_JDATA_19                 (0x80000U << ADC_JDR3_JDATA_Pos)     /*!< 0x00080000 */
#define ADC_JDR3_JDATA_20                 (0x100000U << ADC_JDR3_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR3_JDATA_21                 (0x200000U << ADC_JDR3_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR3_JDATA_22                 (0x400000U << ADC_JDR3_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR3_JDATA_23                 (0x800000U << ADC_JDR3_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR3_JDATA_24                 (0x1000000U << ADC_JDR3_JDATA_Pos)   /*!< 0x01000000 */
#define ADC_JDR3_JDATA_25                 (0x2000000U << ADC_JDR3_JDATA_Pos)   /*!< 0x02000000 */
#define ADC_JDR3_JDATA_26                 (0x4000000U << ADC_JDR3_JDATA_Pos)   /*!< 0x04000000 */
#define ADC_JDR3_JDATA_27                 (0x8000000U << ADC_JDR3_JDATA_Pos)   /*!< 0x08000000 */
#define ADC_JDR3_JDATA_28                 (0x10000000U << ADC_JDR3_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR3_JDATA_29                 (0x20000000U << ADC_JDR3_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR3_JDATA_30                 (0x40000000U << ADC_JDR3_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR3_JDATA_31                 (0x80000000U << ADC_JDR3_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_JDR4 register  ********************/
#define ADC_JDR4_JDATA_Pos                (0U)
#define ADC_JDR4_JDATA_Msk                (0xFFFFU << ADC_JDR4_JDATA_Pos)      /*!< 0x0000FFFF */
#define ADC_JDR4_JDATA                    ADC_JDR4_JDATA_Msk                   /*!< ADC Injected DATA */
#define ADC_JDR4_JDATA_0                  (0x0001U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000001 */
#define ADC_JDR4_JDATA_1                  (0x0002U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000002 */
#define ADC_JDR4_JDATA_2                  (0x0004U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000004 */
#define ADC_JDR4_JDATA_3                  (0x0008U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000008 */
#define ADC_JDR4_JDATA_4                  (0x0010U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000010 */
#define ADC_JDR4_JDATA_5                  (0x0020U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000020 */
#define ADC_JDR4_JDATA_6                  (0x0040U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000040 */
#define ADC_JDR4_JDATA_7                  (0x0080U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000080 */
#define ADC_JDR4_JDATA_8                  (0x0100U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000100 */
#define ADC_JDR4_JDATA_9                  (0x0200U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000200 */
#define ADC_JDR4_JDATA_10                 (0x0400U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000400 */
#define ADC_JDR4_JDATA_11                 (0x0800U << ADC_JDR4_JDATA_Pos)      /*!< 0x00000800 */
#define ADC_JDR4_JDATA_12                 (0x1000U << ADC_JDR4_JDATA_Pos)      /*!< 0x00001000 */
#define ADC_JDR4_JDATA_13                 (0x2000U << ADC_JDR4_JDATA_Pos)      /*!< 0x00002000 */
#define ADC_JDR4_JDATA_14                 (0x4000U << ADC_JDR4_JDATA_Pos)      /*!< 0x00004000 */
#define ADC_JDR4_JDATA_15                 (0x8000U << ADC_JDR4_JDATA_Pos)      /*!< 0x00008000 */
#define ADC_JDR4_JDATA_16                 (0x10000U << ADC_JDR4_JDATA_Pos)     /*!< 0x00010000 */
#define ADC_JDR4_JDATA_17                 (0x20000U << ADC_JDR4_JDATA_Pos)     /*!< 0x00020000 */
#define ADC_JDR4_JDATA_18                 (0x40000U << ADC_JDR4_JDATA_Pos)     /*!< 0x00040000 */
#define ADC_JDR4_JDATA_19                 (0x80000U << ADC_JDR4_JDATA_Pos)     /*!< 0x00080000 */
#define ADC_JDR4_JDATA_20                 (0x100000U << ADC_JDR4_JDATA_Pos)    /*!< 0x00100000 */
#define ADC_JDR4_JDATA_21                 (0x200000U << ADC_JDR4_JDATA_Pos)    /*!< 0x00200000 */
#define ADC_JDR4_JDATA_22                 (0x400000U << ADC_JDR4_JDATA_Pos)    /*!< 0x00400000 */
#define ADC_JDR4_JDATA_23                 (0x800000U << ADC_JDR4_JDATA_Pos)    /*!< 0x00800000 */
#define ADC_JDR4_JDATA_24                 (0x1000000U << ADC_JDR4_JDATA_Pos)   /*!< 0x01000000 */
#define ADC_JDR4_JDATA_25                 (0x2000000U << ADC_JDR4_JDATA_Pos)   /*!< 0x02000000 */
#define ADC_JDR4_JDATA_26                 (0x4000000U << ADC_JDR4_JDATA_Pos)   /*!< 0x04000000 */
#define ADC_JDR4_JDATA_27                 (0x8000000U << ADC_JDR4_JDATA_Pos)   /*!< 0x08000000 */
#define ADC_JDR4_JDATA_28                 (0x10000000U << ADC_JDR4_JDATA_Pos)  /*!< 0x10000000 */
#define ADC_JDR4_JDATA_29                 (0x20000000U << ADC_JDR4_JDATA_Pos)  /*!< 0x20000000 */
#define ADC_JDR4_JDATA_30                 (0x40000000U << ADC_JDR4_JDATA_Pos)  /*!< 0x40000000 */
#define ADC_JDR4_JDATA_31                 (0x80000000U << ADC_JDR4_JDATA_Pos)  /*!< 0x80000000 */

/********************  Bit definition for ADC_AWD2CR register  ********************/
#define ADC_AWD2CR_AWD2CH_Pos             (0U)
#define ADC_AWD2CR_AWD2CH_Msk             (0xFFFFFU << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x000FFFFF */
#define ADC_AWD2CR_AWD2CH                 ADC_AWD2CR_AWD2CH_Msk                /*!< ADC Analog watchdog 2 channel selection */
#define ADC_AWD2CR_AWD2CH_0               (0x00001U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000001 */
#define ADC_AWD2CR_AWD2CH_1               (0x00002U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000002 */
#define ADC_AWD2CR_AWD2CH_2               (0x00004U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000004 */
#define ADC_AWD2CR_AWD2CH_3               (0x00008U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000008 */
#define ADC_AWD2CR_AWD2CH_4               (0x00010U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000010 */
#define ADC_AWD2CR_AWD2CH_5               (0x00020U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000020 */
#define ADC_AWD2CR_AWD2CH_6               (0x00040U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000040 */
#define ADC_AWD2CR_AWD2CH_7               (0x00080U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000080 */
#define ADC_AWD2CR_AWD2CH_8               (0x00100U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000100 */
#define ADC_AWD2CR_AWD2CH_9               (0x00200U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000200 */
#define ADC_AWD2CR_AWD2CH_10              (0x00400U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000400 */
#define ADC_AWD2CR_AWD2CH_11              (0x00800U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00000800 */
#define ADC_AWD2CR_AWD2CH_12              (0x01000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00001000 */
#define ADC_AWD2CR_AWD2CH_13              (0x02000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00002000 */
#define ADC_AWD2CR_AWD2CH_14              (0x04000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00004000 */
#define ADC_AWD2CR_AWD2CH_15              (0x08000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00008000 */
#define ADC_AWD2CR_AWD2CH_16              (0x10000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00010000 */
#define ADC_AWD2CR_AWD2CH_17              (0x20000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00020000 */
#define ADC_AWD2CR_AWD2CH_18              (0x40000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00040000 */
#define ADC_AWD2CR_AWD2CH_19              (0x80000U << ADC_AWD2CR_AWD2CH_Pos)  /*!< 0x00080000 */

/********************  Bit definition for ADC_AWD3CR register  ********************/
#define ADC_AWD3CR_AWD3CH_Pos             (0U)
#define ADC_AWD3CR_AWD3CH_Msk             (0xFFFFFU << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x000FFFFF */
#define ADC_AWD3CR_AWD3CH                 ADC_AWD3CR_AWD3CH_Msk                /*!< ADC Analog watchdog 3 channel selection */
#define ADC_AWD3CR_AWD3CH_0               (0x00001U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000001 */
#define ADC_AWD3CR_AWD3CH_1               (0x00002U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000002 */
#define ADC_AWD3CR_AWD3CH_2               (0x00004U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000004 */
#define ADC_AWD3CR_AWD3CH_3               (0x00008U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000008 */
#define ADC_AWD3CR_AWD3CH_4               (0x00010U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000010 */
#define ADC_AWD3CR_AWD3CH_5               (0x00020U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000020 */
#define ADC_AWD3CR_AWD3CH_6               (0x00040U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000040 */
#define ADC_AWD3CR_AWD3CH_7               (0x00080U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000080 */
#define ADC_AWD3CR_AWD3CH_8               (0x00100U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000100 */
#define ADC_AWD3CR_AWD3CH_9               (0x00200U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000200 */
#define ADC_AWD3CR_AWD3CH_10              (0x00400U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000400 */
#define ADC_AWD3CR_AWD3CH_11              (0x00800U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00000800 */
#define ADC_AWD3CR_AWD3CH_12              (0x01000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00001000 */
#define ADC_AWD3CR_AWD3CH_13              (0x02000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00002000 */
#define ADC_AWD3CR_AWD3CH_14              (0x04000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00004000 */
#define ADC_AWD3CR_AWD3CH_15              (0x08000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00008000 */
#define ADC_AWD3CR_AWD3CH_16              (0x10000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00010000 */
#define ADC_AWD3CR_AWD3CH_17              (0x20000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00020000 */
#define ADC_AWD3CR_AWD3CH_18              (0x40000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00040000 */
#define ADC_AWD3CR_AWD3CH_19              (0x80000U << ADC_AWD3CR_AWD3CH_Pos)  /*!< 0x00080000 */

/********************  Bit definition for ADC_DIFSEL register  ********************/
#define ADC_DIFSEL_DIFSEL_Pos             (0U)
#define ADC_DIFSEL_DIFSEL_Msk             (0xFFFFFU << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x000FFFFF */
#define ADC_DIFSEL_DIFSEL                 ADC_DIFSEL_DIFSEL_Msk                /*!< ADC differential modes for channels 1 to 18 */
#define ADC_DIFSEL_DIFSEL_0               (0x00001U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000001 */
#define ADC_DIFSEL_DIFSEL_1               (0x00002U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000002 */
#define ADC_DIFSEL_DIFSEL_2               (0x00004U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000004 */
#define ADC_DIFSEL_DIFSEL_3               (0x00008U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000008 */
#define ADC_DIFSEL_DIFSEL_4               (0x00010U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000010 */
#define ADC_DIFSEL_DIFSEL_5               (0x00020U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000020 */
#define ADC_DIFSEL_DIFSEL_6               (0x00040U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000040 */
#define ADC_DIFSEL_DIFSEL_7               (0x00080U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000080 */
#define ADC_DIFSEL_DIFSEL_8               (0x00100U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000100 */
#define ADC_DIFSEL_DIFSEL_9               (0x00200U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000200 */
#define ADC_DIFSEL_DIFSEL_10              (0x00400U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000400 */
#define ADC_DIFSEL_DIFSEL_11              (0x00800U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00000800 */
#define ADC_DIFSEL_DIFSEL_12              (0x01000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00001000 */
#define ADC_DIFSEL_DIFSEL_13              (0x02000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00002000 */
#define ADC_DIFSEL_DIFSEL_14              (0x04000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00004000 */
#define ADC_DIFSEL_DIFSEL_15              (0x08000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00008000 */
#define ADC_DIFSEL_DIFSEL_16              (0x10000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00010000 */
#define ADC_DIFSEL_DIFSEL_17              (0x20000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00020000 */
#define ADC_DIFSEL_DIFSEL_18              (0x40000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00040000 */
#define ADC_DIFSEL_DIFSEL_19              (0x80000U << ADC_DIFSEL_DIFSEL_Pos)  /*!< 0x00080000 */

/********************  Bit definition for ADC_CALFACT register  ********************/
#define ADC_CALFACT_CALFACT_S_Pos         (0U)
#define ADC_CALFACT_CALFACT_S_Msk         (0x7FFU << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x000007FF */
#define ADC_CALFACT_CALFACT_S             ADC_CALFACT_CALFACT_S_Msk            /*!< ADC calibration factors in single-ended mode */
#define ADC_CALFACT_CALFACT_S_0           (0x001U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000001 */
#define ADC_CALFACT_CALFACT_S_1           (0x002U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000002 */
#define ADC_CALFACT_CALFACT_S_2           (0x004U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000004 */
#define ADC_CALFACT_CALFACT_S_3           (0x008U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000008 */
#define ADC_CALFACT_CALFACT_S_4           (0x010U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000010 */
#define ADC_CALFACT_CALFACT_S_5           (0x020U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000020 */
#define ADC_CALFACT_CALFACT_S_6           (0x040U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000040 */
#define ADC_CALFACT_CALFACT_S_7           (0x080U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000080 */
#define ADC_CALFACT_CALFACT_S_8           (0x100U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000100 */
#define ADC_CALFACT_CALFACT_S_9           (0x200U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000200 */
#define ADC_CALFACT_CALFACT_S_10          (0x400U << ADC_CALFACT_CALFACT_S_Pos) /*!< 0x00000400 */
#define ADC_CALFACT_CALFACT_D_Pos         (16U)
#define ADC_CALFACT_CALFACT_D_Msk         (0x7FFU << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x07FF0000 */
#define ADC_CALFACT_CALFACT_D             ADC_CALFACT_CALFACT_D_Msk            /*!< ADC calibration factors in differential mode */
#define ADC_CALFACT_CALFACT_D_0           (0x001U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00010000 */
#define ADC_CALFACT_CALFACT_D_1           (0x002U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00020000 */
#define ADC_CALFACT_CALFACT_D_2           (0x004U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00040000 */
#define ADC_CALFACT_CALFACT_D_3           (0x008U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00080000 */
#define ADC_CALFACT_CALFACT_D_4           (0x010U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00100000 */
#define ADC_CALFACT_CALFACT_D_5           (0x020U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00200000 */
#define ADC_CALFACT_CALFACT_D_6           (0x040U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00400000 */
#define ADC_CALFACT_CALFACT_D_7           (0x080U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x00800000 */
#define ADC_CALFACT_CALFACT_D_8           (0x100U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x01000000 */
#define ADC_CALFACT_CALFACT_D_9           (0x200U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x02000000 */
#define ADC_CALFACT_CALFACT_D_10          (0x400U << ADC_CALFACT_CALFACT_D_Pos) /*!< 0x04000000 */

/********************  Bit definition for ADC_CALFACT2 register  ********************/
#define ADC_CALFACT2_LINCALFACT_Pos       (0U)
#define ADC_CALFACT2_LINCALFACT_Msk       (0x3FFFFFFFU << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x3FFFFFFF */
#define ADC_CALFACT2_LINCALFACT           ADC_CALFACT2_LINCALFACT_Msk          /*!< ADC Linearity calibration factors */
#define ADC_CALFACT2_LINCALFACT_0         (0x00000001U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000001 */
#define ADC_CALFACT2_LINCALFACT_1         (0x00000002U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000002 */
#define ADC_CALFACT2_LINCALFACT_2         (0x00000004U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000004 */
#define ADC_CALFACT2_LINCALFACT_3         (0x00000008U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000008 */
#define ADC_CALFACT2_LINCALFACT_4         (0x00000010U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000010 */
#define ADC_CALFACT2_LINCALFACT_5         (0x00000020U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000020 */
#define ADC_CALFACT2_LINCALFACT_6         (0x00000040U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000040 */
#define ADC_CALFACT2_LINCALFACT_7         (0x00000080U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000080 */
#define ADC_CALFACT2_LINCALFACT_8         (0x00000100U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000100 */
#define ADC_CALFACT2_LINCALFACT_9         (0x00000200U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000200 */
#define ADC_CALFACT2_LINCALFACT_10        (0x00000400U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000400 */
#define ADC_CALFACT2_LINCALFACT_11        (0x00000800U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00000800 */
#define ADC_CALFACT2_LINCALFACT_12        (0x00001000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00001000 */
#define ADC_CALFACT2_LINCALFACT_13        (0x00002000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00002000 */
#define ADC_CALFACT2_LINCALFACT_14        (0x00004000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00004000 */
#define ADC_CALFACT2_LINCALFACT_15        (0x00008000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00008000 */
#define ADC_CALFACT2_LINCALFACT_16        (0x00010000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00010000 */
#define ADC_CALFACT2_LINCALFACT_17        (0x00020000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00020000 */
#define ADC_CALFACT2_LINCALFACT_18        (0x00040000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00040000 */
#define ADC_CALFACT2_LINCALFACT_19        (0x00080000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00080000 */
#define ADC_CALFACT2_LINCALFACT_20        (0x00100000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00100000 */
#define ADC_CALFACT2_LINCALFACT_21        (0x00200000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00200000 */
#define ADC_CALFACT2_LINCALFACT_22        (0x00400000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00400000 */
#define ADC_CALFACT2_LINCALFACT_23        (0x00800000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x00800000 */
#define ADC_CALFACT2_LINCALFACT_24        (0x01000000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x01000000 */
#define ADC_CALFACT2_LINCALFACT_25        (0x02000000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x02000000 */
#define ADC_CALFACT2_LINCALFACT_26        (0x04000000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x04000000 */
#define ADC_CALFACT2_LINCALFACT_27        (0x08000001U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x08000001 */
#define ADC_CALFACT2_LINCALFACT_28        (0x10000000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x10000000 */
#define ADC_CALFACT2_LINCALFACT_29        (0x20000000U << ADC_CALFACT2_LINCALFACT_Pos) /*!< 0x20000000 */

/********************  Bit definition for ADC2_OR - Option Register  ********************/
#define ADC2_OR_VDDCOREEN_Pos            (0U)
#define ADC2_OR_VDDCOREEN_Msk            (0x1U << ADC2_OR_VDDCOREEN_Pos) /*!< 0x00000001 */
#define ADC2_OR_VDDCOREEN                ADC2_OR_VDDCOREEN_Msk          /*!< ADC2 Option Register  - VDDCORE enable bit */

/*************************  ADC Common registers  *****************************/
/********************  Bit definition for ADC_CSR register  ********************/
#define ADC_CSR_ADRDY_MST_Pos          (0U)
#define ADC_CSR_ADRDY_MST_Msk          (0x1U << ADC_CSR_ADRDY_MST_Pos)   /*!< 0x00000001 */
#define ADC_CSR_ADRDY_MST              ADC_CSR_ADRDY_MST_Msk             /*!< Master ADC ready */
#define ADC_CSR_EOSMP_MST_Pos          (1U)
#define ADC_CSR_EOSMP_MST_Msk          (0x1U << ADC_CSR_EOSMP_MST_Pos) /*!< 0x00000002 */
#define ADC_CSR_EOSMP_MST              ADC_CSR_EOSMP_MST_Msk       /*!< End of sampling phase flag of the master ADC */
#define ADC_CSR_EOC_MST_Pos      (2U)
#define ADC_CSR_EOC_MST_Msk      (0x1U << ADC_CSR_EOC_MST_Pos) /*!< 0x00000004 */
#define ADC_CSR_EOC_MST          ADC_CSR_EOC_MST_Msk         /*!< End of regular conversion of the master ADC */
#define ADC_CSR_EOS_MST_Pos      (3U)
#define ADC_CSR_EOS_MST_Msk      (0x1U << ADC_CSR_EOS_MST_Pos) /*!< 0x00000008 */
#define ADC_CSR_EOS_MST          ADC_CSR_EOS_MST_Msk         /*!< End of regular sequence flag of the master ADC */
#define ADC_CSR_OVR_MST_Pos      (4U)
#define ADC_CSR_OVR_MST_Msk      (0x1U << ADC_CSR_OVR_MST_Pos) /*!< 0x00000010 */
#define ADC_CSR_OVR_MST          ADC_CSR_OVR_MST_Msk         /*!< Overrun flag of the master ADC */
#define ADC_CSR_JEOC_MST_Pos     (5U)
#define ADC_CSR_JEOC_MST_Msk     (0x1U << ADC_CSR_JEOC_MST_Pos) /*!< 0x00000020 */
#define ADC_CSR_JEOC_MST         ADC_CSR_JEOC_MST_Msk        /*!< End of injected conversion of the master ADC */
#define ADC_CSR_JEOS_MST_Pos     (6U)
#define ADC_CSR_JEOS_MST_Msk     (0x1U << ADC_CSR_JEOS_MST_Pos) /*!< 0x00000040 */
#define ADC_CSR_JEOS_MST         ADC_CSR_JEOS_MST_Msk        /*!< End of injected sequence flag of the master ADC */
#define ADC_CSR_AWD1_MST_Pos           (7U)
#define ADC_CSR_AWD1_MST_Msk           (0x1U << ADC_CSR_AWD1_MST_Pos)    /*!< 0x00000080 */
#define ADC_CSR_AWD1_MST               ADC_CSR_AWD1_MST_Msk              /*!< Analog watchdog 1 flag of the master ADC */
#define ADC_CSR_AWD2_MST_Pos           (8U)
#define ADC_CSR_AWD2_MST_Msk           (0x1U << ADC_CSR_AWD2_MST_Pos)    /*!< 0x00000100 */
#define ADC_CSR_AWD2_MST               ADC_CSR_AWD2_MST_Msk              /*!< Analog watchdog 2 flag of the master ADC */
#define ADC_CSR_AWD3_MST_Pos           (9U)
#define ADC_CSR_AWD3_MST_Msk           (0x1U << ADC_CSR_AWD3_MST_Pos)    /*!< 0x00000200 */
#define ADC_CSR_AWD3_MST               ADC_CSR_AWD3_MST_Msk              /*!< Analog watchdog 3 flag of the master ADC */
#define ADC_CSR_JQOVF_MST_Pos          (10U)
#define ADC_CSR_JQOVF_MST_Msk          (0x1U << ADC_CSR_JQOVF_MST_Pos)   /*!< 0x00000400 */
#define ADC_CSR_JQOVF_MST              ADC_CSR_JQOVF_MST_Msk             /*!< Injected context queue overflow flag of the master ADC */
#define ADC_CSR_ADRDY_SLV_Pos          (16U)
#define ADC_CSR_ADRDY_SLV_Msk          (0x1U << ADC_CSR_ADRDY_SLV_Pos)   /*!< 0x00010000 */
#define ADC_CSR_ADRDY_SLV              ADC_CSR_ADRDY_SLV_Msk             /*!< Slave ADC ready */
#define ADC_CSR_EOSMP_SLV_Pos    (17U)
#define ADC_CSR_EOSMP_SLV_Msk    (0x1U << ADC_CSR_EOSMP_SLV_Pos) /*!< 0x00020000 */
#define ADC_CSR_EOSMP_SLV        ADC_CSR_EOSMP_SLV_Msk       /*!< End of sampling phase flag of the slave ADC */
#define ADC_CSR_EOC_SLV_Pos      (18U)
#define ADC_CSR_EOC_SLV_Msk      (0x1U << ADC_CSR_EOC_SLV_Pos) /*!< 0x00040000 */
#define ADC_CSR_EOC_SLV          ADC_CSR_EOC_SLV_Msk         /*!< End of regular conversion of the slave ADC */
#define ADC_CSR_EOS_SLV_Pos      (19U)
#define ADC_CSR_EOS_SLV_Msk      (0x1U << ADC_CSR_EOS_SLV_Pos) /*!< 0x00080000 */
#define ADC_CSR_EOS_SLV          ADC_CSR_EOS_SLV_Msk         /*!< End of regular sequence flag of the slave ADC */
#define ADC_CSR_OVR_SLV_Pos      (20U)
#define ADC_CSR_OVR_SLV_Msk      (0x1U << ADC_CSR_OVR_SLV_Pos) /*!< 0x00100000 */
#define ADC_CSR_OVR_SLV          ADC_CSR_OVR_SLV_Msk         /*!< Overrun flag of the slave ADC */
#define ADC_CSR_JEOC_SLV_Pos     (21U)
#define ADC_CSR_JEOC_SLV_Msk     (0x1U << ADC_CSR_JEOC_SLV_Pos) /*!< 0x00200000 */
#define ADC_CSR_JEOC_SLV         ADC_CSR_JEOC_SLV_Msk        /*!< End of injected conversion of the slave ADC */
#define ADC_CSR_JEOS_SLV_Pos     (22U)
#define ADC_CSR_JEOS_SLV_Msk     (0x1U << ADC_CSR_JEOS_SLV_Pos) /*!< 0x00400000 */
#define ADC_CSR_JEOS_SLV         ADC_CSR_JEOS_SLV_Msk        /*!< End of injected sequence flag of the slave ADC */
#define ADC_CSR_AWD1_SLV_Pos           (23U)
#define ADC_CSR_AWD1_SLV_Msk           (0x1U << ADC_CSR_AWD1_SLV_Pos)    /*!< 0x00800000 */
#define ADC_CSR_AWD1_SLV               ADC_CSR_AWD1_SLV_Msk              /*!< Analog watchdog 1 flag of the slave ADC */
#define ADC_CSR_AWD2_SLV_Pos           (24U)
#define ADC_CSR_AWD2_SLV_Msk           (0x1U << ADC_CSR_AWD2_SLV_Pos)    /*!< 0x01000000 */
#define ADC_CSR_AWD2_SLV               ADC_CSR_AWD2_SLV_Msk              /*!< Analog watchdog 2 flag of the slave ADC */
#define ADC_CSR_AWD3_SLV_Pos           (25U)
#define ADC_CSR_AWD3_SLV_Msk           (0x1U << ADC_CSR_AWD3_SLV_Pos)    /*!< 0x02000000 */
#define ADC_CSR_AWD3_SLV               ADC_CSR_AWD3_SLV_Msk              /*!< Analog watchdog 3 flag of the slave ADC */
#define ADC_CSR_JQOVF_SLV_Pos          (26U)
#define ADC_CSR_JQOVF_SLV_Msk          (0x1U << ADC_CSR_JQOVF_SLV_Pos)   /*!< 0x04000000 */
#define ADC_CSR_JQOVF_SLV              ADC_CSR_JQOVF_SLV_Msk             /*!< Injected context queue overflow flag of the slave ADC */

/********************  Bit definition for ADC_CCR register  ********************/
#define ADC_CCR_DUAL_Pos                  (0U)
#define ADC_CCR_DUAL_Msk                  (0x1FU << ADC_CCR_DUAL_Pos)          /*!< 0x0000001F */
#define ADC_CCR_DUAL                      ADC_CCR_DUAL_Msk                     /*!< Dual ADC mode selection */
#define ADC_CCR_DUAL_0                    (0x01U << ADC_CCR_DUAL_Pos)          /*!< 0x00000001 */
#define ADC_CCR_DUAL_1                    (0x02U << ADC_CCR_DUAL_Pos)          /*!< 0x00000002 */
#define ADC_CCR_DUAL_2                    (0x04U << ADC_CCR_DUAL_Pos)          /*!< 0x00000004 */
#define ADC_CCR_DUAL_3                    (0x08U << ADC_CCR_DUAL_Pos)          /*!< 0x00000008 */
#define ADC_CCR_DUAL_4                    (0x10U << ADC_CCR_DUAL_Pos)          /*!< 0x00000010 */

#define ADC_CCR_DELAY_Pos                 (8U)
#define ADC_CCR_DELAY_Msk                 (0xFU << ADC_CCR_DELAY_Pos)          /*!< 0x00000F00 */
#define ADC_CCR_DELAY                     ADC_CCR_DELAY_Msk                    /*!< Delay between 2 sampling phases */
#define ADC_CCR_DELAY_0                   (0x1U << ADC_CCR_DELAY_Pos)          /*!< 0x00000100 */
#define ADC_CCR_DELAY_1                   (0x2U << ADC_CCR_DELAY_Pos)          /*!< 0x00000200 */
#define ADC_CCR_DELAY_2                   (0x4U << ADC_CCR_DELAY_Pos)          /*!< 0x00000400 */
#define ADC_CCR_DELAY_3                   (0x8U << ADC_CCR_DELAY_Pos)          /*!< 0x00000800 */

#define ADC_CCR_DAMDF_Pos                 (14U)
#define ADC_CCR_DAMDF_Msk                 (0x3U << ADC_CCR_DAMDF_Pos)          /*!< 0x0000C000 */
#define ADC_CCR_DAMDF                     ADC_CCR_DAMDF_Msk                    /*!< Dual ADC mode Data format */
#define ADC_CCR_DAMDF_0                   (0x1U << ADC_CCR_DAMDF_Pos)          /*!< 0x00004000 */
#define ADC_CCR_DAMDF_1                   (0x2U << ADC_CCR_DAMDF_Pos)          /*!< 0x00008000 */

#define ADC_CCR_CKMODE_Pos                (16U)
#define ADC_CCR_CKMODE_Msk                (0x3U << ADC_CCR_CKMODE_Pos)         /*!< 0x00030000 */
#define ADC_CCR_CKMODE                    ADC_CCR_CKMODE_Msk                   /*!< ADC clock mode */
#define ADC_CCR_CKMODE_0                  (0x1U << ADC_CCR_CKMODE_Pos)         /*!< 0x00010000 */
#define ADC_CCR_CKMODE_1                  (0x2U << ADC_CCR_CKMODE_Pos)         /*!< 0x00020000 */

#define ADC_CCR_PRESC_Pos                 (18U)
#define ADC_CCR_PRESC_Msk                 (0xFU << ADC_CCR_PRESC_Pos)          /*!< 0x003C0000 */
#define ADC_CCR_PRESC                     ADC_CCR_PRESC_Msk                    /*!< ADC prescaler */
#define ADC_CCR_PRESC_0                   (0x1U << ADC_CCR_PRESC_Pos)          /*!< 0x00040000 */
#define ADC_CCR_PRESC_1                   (0x2U << ADC_CCR_PRESC_Pos)          /*!< 0x00080000 */
#define ADC_CCR_PRESC_2                   (0x4U << ADC_CCR_PRESC_Pos)          /*!< 0x00100000 */
#define ADC_CCR_PRESC_3                   (0x8U << ADC_CCR_PRESC_Pos)          /*!< 0x00200000 */

#define ADC_CCR_VREFEN_Pos                (22U)
#define ADC_CCR_VREFEN_Msk                (0x1U << ADC_CCR_VREFEN_Pos)         /*!< 0x00400000 */
#define ADC_CCR_VREFEN                    ADC_CCR_VREFEN_Msk                   /*!< VREFINT enable */
#define ADC_CCR_VSENSEEN_Pos              (23U)
#define ADC_CCR_VSENSEEN_Msk              (0x1U << ADC_CCR_VSENSEEN_Pos)      /*!< 0x00800000 */
#define ADC_CCR_VSENSEEN                  ADC_CCR_VSENSEEN_Msk                /*!< Temperature sensor enable */
#define ADC_CCR_VBATEN_Pos                (24U)
#define ADC_CCR_VBATEN_Msk                (0x1U << ADC_CCR_VBATEN_Pos)         /*!< 0x01000000 */
#define ADC_CCR_VBATEN                    ADC_CCR_VBATEN_Msk                   /*!< VBAT enable */

/********************  Bit definition for ADC_CDR register  ********************/
#define ADC_CDR_RDATA_MST_Pos          (0U)
#define ADC_CDR_RDATA_MST_Msk          (0xFFFFU << ADC_CDR_RDATA_MST_Pos) /*!< 0x0000FFFF */
#define ADC_CDR_RDATA_MST              ADC_CDR_RDATA_MST_Msk             /*!< Regular Data of the master ADC */
#define ADC_CDR_RDATA_MST_0            (0x0001U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000001 */
#define ADC_CDR_RDATA_MST_1            (0x0002U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000002 */
#define ADC_CDR_RDATA_MST_2            (0x0004U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000004 */
#define ADC_CDR_RDATA_MST_3            (0x0008U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000008 */
#define ADC_CDR_RDATA_MST_4            (0x0010U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000010 */
#define ADC_CDR_RDATA_MST_5            (0x0020U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000020 */
#define ADC_CDR_RDATA_MST_6            (0x0040U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000040 */
#define ADC_CDR_RDATA_MST_7            (0x0080U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000080 */
#define ADC_CDR_RDATA_MST_8            (0x0100U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000100 */
#define ADC_CDR_RDATA_MST_9            (0x0200U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000200 */
#define ADC_CDR_RDATA_MST_10           (0x0400U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000400 */
#define ADC_CDR_RDATA_MST_11           (0x0800U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00000800 */
#define ADC_CDR_RDATA_MST_12           (0x1000U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00001000 */
#define ADC_CDR_RDATA_MST_13           (0x2000U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00002000 */
#define ADC_CDR_RDATA_MST_14           (0x4000U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00004000 */
#define ADC_CDR_RDATA_MST_15           (0x8000U << ADC_CDR_RDATA_MST_Pos) /*!< 0x00008000 */

#define ADC_CDR_RDATA_SLV_Pos          (16U)
#define ADC_CDR_RDATA_SLV_Msk          (0xFFFFU << ADC_CDR_RDATA_SLV_Pos) /*!< 0xFFFF0000 */
#define ADC_CDR_RDATA_SLV              ADC_CDR_RDATA_SLV_Msk             /*!< Regular Data of the master ADC */
#define ADC_CDR_RDATA_SLV_0            (0x0001U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00010000 */
#define ADC_CDR_RDATA_SLV_1            (0x0002U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00020000 */
#define ADC_CDR_RDATA_SLV_2            (0x0004U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00040000 */
#define ADC_CDR_RDATA_SLV_3            (0x0008U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00080000 */
#define ADC_CDR_RDATA_SLV_4            (0x0010U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00100000 */
#define ADC_CDR_RDATA_SLV_5            (0x0020U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00200000 */
#define ADC_CDR_RDATA_SLV_6            (0x0040U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00400000 */
#define ADC_CDR_RDATA_SLV_7            (0x0080U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x00800000 */
#define ADC_CDR_RDATA_SLV_8            (0x0100U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x01000000 */
#define ADC_CDR_RDATA_SLV_9            (0x0200U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x02000000 */
#define ADC_CDR_RDATA_SLV_10           (0x0400U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x04000000 */
#define ADC_CDR_RDATA_SLV_11           (0x0800U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x08000000 */
#define ADC_CDR_RDATA_SLV_12           (0x1000U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x10000000 */
#define ADC_CDR_RDATA_SLV_13           (0x2000U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x20000000 */
#define ADC_CDR_RDATA_SLV_14           (0x4000U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x40000000 */
#define ADC_CDR_RDATA_SLV_15           (0x8000U << ADC_CDR_RDATA_SLV_Pos) /*!< 0x80000000 */

/********************  Bit definition for ADC_CDR2 register  ********************/
#define ADC_CDR2_RDATA_ALT_Pos         (0U)
#define ADC_CDR2_RDATA_ALT_Msk         (0xFFFFFFFFU << ADC_CDR2_RDATA_ALT_Pos) /*!< 0xFFFFFFFF */
#define ADC_CDR2_RDATA_ALT             ADC_CDR2_RDATA_ALT_Msk            /*!< Regular Data for dual Mode */
#define ADC_CDR2_RDATA_ALT_0           (0x00000001U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000001 */
#define ADC_CDR2_RDATA_ALT_1           (0x00000002U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000002 */
#define ADC_CDR2_RDATA_ALT_2           (0x00000004U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000004 */
#define ADC_CDR2_RDATA_ALT_3           (0x00000008U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000008 */
#define ADC_CDR2_RDATA_ALT_4           (0x00000010U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000010 */
#define ADC_CDR2_RDATA_ALT_5           (0x00000020U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000020 */
#define ADC_CDR2_RDATA_ALT_6           (0x00000040U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000040 */
#define ADC_CDR2_RDATA_ALT_7           (0x00000080U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000080 */
#define ADC_CDR2_RDATA_ALT_8           (0x00000100U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000100 */
#define ADC_CDR2_RDATA_ALT_9           (0x00000200U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000200 */
#define ADC_CDR2_RDATA_ALT_10          (0x00000400U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000400 */
#define ADC_CDR2_RDATA_ALT_11          (0x00000800U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00000800 */
#define ADC_CDR2_RDATA_ALT_12          (0x00001000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00001000 */
#define ADC_CDR2_RDATA_ALT_13          (0x00002000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00002000 */
#define ADC_CDR2_RDATA_ALT_14          (0x00004000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00004000 */
#define ADC_CDR2_RDATA_ALT_15          (0x00008000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00008000 */
#define ADC_CDR2_RDATA_ALT_16          (0x00010000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00010000 */
#define ADC_CDR2_RDATA_ALT_17          (0x00020000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00020000 */
#define ADC_CDR2_RDATA_ALT_18          (0x00040000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00040000 */
#define ADC_CDR2_RDATA_ALT_19          (0x00080000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00080000 */
#define ADC_CDR2_RDATA_ALT_20          (0x00100000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00100000 */
#define ADC_CDR2_RDATA_ALT_21          (0x00200000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00200000 */
#define ADC_CDR2_RDATA_ALT_22          (0x00400000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00400000 */
#define ADC_CDR2_RDATA_ALT_23          (0x00800000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x00800000 */
#define ADC_CDR2_RDATA_ALT_24          (0x01000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x01000000 */
#define ADC_CDR2_RDATA_ALT_25          (0x02000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x02000000 */
#define ADC_CDR2_RDATA_ALT_26          (0x04000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x04000000 */
#define ADC_CDR2_RDATA_ALT_27          (0x08000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x08000000 */
#define ADC_CDR2_RDATA_ALT_28          (0x10000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x10000000 */
#define ADC_CDR2_RDATA_ALT_29          (0x20000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x20000000 */
#define ADC_CDR2_RDATA_ALT_30          (0x40000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x40000000 */
#define ADC_CDR2_RDATA_ALT_31          (0x80000000U << ADC_CDR2_RDATA_ALT_Pos) /*!< 0x80000000 */

/******************************************************************************/
/*                                                                            */
/*                                   VREFBUF                                  */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for VREFBUF_CSR register  ****************/
#define VREFBUF_CSR_ENVR_Pos        (0U)
#define VREFBUF_CSR_ENVR_Msk        (0x1U << VREFBUF_CSR_ENVR_Pos)             /*!< 0x00000001 */
#define VREFBUF_CSR_ENVR            VREFBUF_CSR_ENVR_Msk                       /*!<Voltage reference buffer enable */
#define VREFBUF_CSR_HIZ_Pos         (1U)
#define VREFBUF_CSR_HIZ_Msk         (0x1U << VREFBUF_CSR_HIZ_Pos)              /*!< 0x00000002 */
#define VREFBUF_CSR_HIZ             VREFBUF_CSR_HIZ_Msk                        /*!<High impedance mode             */
#define VREFBUF_CSR_VRR_Pos         (3U)
#define VREFBUF_CSR_VRR_Msk         (0x1U << VREFBUF_CSR_VRR_Pos)              /*!< 0x00000008 */
#define VREFBUF_CSR_VRR             VREFBUF_CSR_VRR_Msk                        /*!<Voltage reference buffer ready  */
#define VREFBUF_CSR_VRS_Pos         (4U)
#define VREFBUF_CSR_VRS_Msk         (0x7U << VREFBUF_CSR_VRS_Pos)              /*!< 0x00000070 */
#define VREFBUF_CSR_VRS             VREFBUF_CSR_VRS_Msk                        /*!<Voltage reference scale         */

#define VREFBUF_CSR_VRS_OUT1        ((uint32_t)0x00000000)                     /*!<Voltage reference VREF_OUT1     */
#define VREFBUF_CSR_VRS_OUT2_Pos    (4U)
#define VREFBUF_CSR_VRS_OUT2_Msk    (0x1U << VREFBUF_CSR_VRS_OUT2_Pos)         /*!< 0x00000010 */
#define VREFBUF_CSR_VRS_OUT2        VREFBUF_CSR_VRS_OUT2_Msk                   /*!<Voltage reference VREF_OUT2     */
#define VREFBUF_CSR_VRS_OUT3_Pos    (5U)
#define VREFBUF_CSR_VRS_OUT3_Msk    (0x1U << VREFBUF_CSR_VRS_OUT3_Pos)         /*!< 0x00000020 */
#define VREFBUF_CSR_VRS_OUT3        VREFBUF_CSR_VRS_OUT3_Msk                   /*!<Voltage reference VREF_OUT3     */
#define VREFBUF_CSR_VRS_OUT4_Pos    (4U)
#define VREFBUF_CSR_VRS_OUT4_Msk    (0x3U << VREFBUF_CSR_VRS_OUT4_Pos)         /*!< 0x00000030 */
#define VREFBUF_CSR_VRS_OUT4        VREFBUF_CSR_VRS_OUT4_Msk                   /*!<Voltage reference VREF_OUT4     */

/*******************  Bit definition for VREFBUF_CCR register  ****************/
#define VREFBUF_CCR_TRIM_Pos        (0U)
#define VREFBUF_CCR_TRIM_Msk        (0x3FU << VREFBUF_CCR_TRIM_Pos)            /*!< 0x0000003F */
#define VREFBUF_CCR_TRIM            VREFBUF_CCR_TRIM_Msk                       /*!<TRIM[5:0] bits (Trimming code)  */


/******************************************************************************/
/*                                                                            */
/*                          HDMI-CEC (CEC)                                    */
/*                                                                            */
/******************************************************************************/

/*******************  Bit definition for CEC_CR register  *********************/
#define CEC_CR_CECEN_Pos         (0U)
#define CEC_CR_CECEN_Msk         (0x1U << CEC_CR_CECEN_Pos)                    /*!< 0x00000001 */
#define CEC_CR_CECEN             CEC_CR_CECEN_Msk                              /*!< CEC Enable                                */
#define CEC_CR_TXSOM_Pos         (1U)
#define CEC_CR_TXSOM_Msk         (0x1U << CEC_CR_TXSOM_Pos)                    /*!< 0x00000002 */
#define CEC_CR_TXSOM             CEC_CR_TXSOM_Msk                              /*!< CEC Tx Start Of Message                   */
#define CEC_CR_TXEOM_Pos         (2U)
#define CEC_CR_TXEOM_Msk         (0x1U << CEC_CR_TXEOM_Pos)                    /*!< 0x00000004 */
#define CEC_CR_TXEOM             CEC_CR_TXEOM_Msk                              /*!< CEC Tx End Of Message                     */

/*******************  Bit definition for CEC_CFGR register  *******************/
#define CEC_CFGR_SFT_Pos         (0U)
#define CEC_CFGR_SFT_Msk         (0x7U << CEC_CFGR_SFT_Pos)                    /*!< 0x00000007 */
#define CEC_CFGR_SFT             CEC_CFGR_SFT_Msk                              /*!< CEC Signal Free Time                      */
#define CEC_CFGR_RXTOL_Pos       (3U)
#define CEC_CFGR_RXTOL_Msk       (0x1U << CEC_CFGR_RXTOL_Pos)                  /*!< 0x00000008 */
#define CEC_CFGR_RXTOL           CEC_CFGR_RXTOL_Msk                            /*!< CEC Tolerance                             */
#define CEC_CFGR_BRESTP_Pos      (4U)
#define CEC_CFGR_BRESTP_Msk      (0x1U << CEC_CFGR_BRESTP_Pos)                 /*!< 0x00000010 */
#define CEC_CFGR_BRESTP          CEC_CFGR_BRESTP_Msk                           /*!< CEC Rx Stop                               */
#define CEC_CFGR_BREGEN_Pos      (5U)
#define CEC_CFGR_BREGEN_Msk      (0x1U << CEC_CFGR_BREGEN_Pos)                 /*!< 0x00000020 */
#define CEC_CFGR_BREGEN          CEC_CFGR_BREGEN_Msk                           /*!< CEC Bit Rising Error generation           */
#define CEC_CFGR_LBPEGEN_Pos     (6U)
#define CEC_CFGR_LBPEGEN_Msk     (0x1U << CEC_CFGR_LBPEGEN_Pos)                /*!< 0x00000040 */
#define CEC_CFGR_LBPEGEN         CEC_CFGR_LBPEGEN_Msk                          /*!< CEC Long Bit Period Error generation      */
#define CEC_CFGR_SFTOPT_Pos      (8U)
#define CEC_CFGR_SFTOPT_Msk      (0x1U << CEC_CFGR_SFTOPT_Pos)                 /*!< 0x00000100 */
#define CEC_CFGR_SFTOPT          CEC_CFGR_SFTOPT_Msk                           /*!< CEC Signal Free Time optional             */
#define CEC_CFGR_BRDNOGEN_Pos    (7U)
#define CEC_CFGR_BRDNOGEN_Msk    (0x1U << CEC_CFGR_BRDNOGEN_Pos)               /*!< 0x00000080 */
#define CEC_CFGR_BRDNOGEN        CEC_CFGR_BRDNOGEN_Msk                         /*!< CEC Broadcast No error generation         */
#define CEC_CFGR_OAR_Pos         (16U)
#define CEC_CFGR_OAR_Msk         (0x7FFFU << CEC_CFGR_OAR_Pos)                 /*!< 0x7FFF0000 */
#define CEC_CFGR_OAR             CEC_CFGR_OAR_Msk                              /*!< CEC Own Address                           */
#define CEC_CFGR_LSTN_Pos        (31U)
#define CEC_CFGR_LSTN_Msk        (0x1U << CEC_CFGR_LSTN_Pos)                   /*!< 0x80000000 */
#define CEC_CFGR_LSTN            CEC_CFGR_LSTN_Msk                             /*!< CEC Listen mode                           */

/*******************  Bit definition for CEC_TXDR register  *******************/
#define CEC_TXDR_TXD_Pos         (0U)
#define CEC_TXDR_TXD_Msk         (0xFFU << CEC_TXDR_TXD_Pos)                   /*!< 0x000000FF */
#define CEC_TXDR_TXD             CEC_TXDR_TXD_Msk                              /*!< CEC Tx Data                               */

/*******************  Bit definition for CEC_RXDR register  *******************/
#define CEC_TXDR_RXD_Pos         (0U)
#define CEC_TXDR_RXD_Msk         (0xFFU << CEC_TXDR_RXD_Pos)                   /*!< 0x000000FF */
#define CEC_TXDR_RXD             CEC_TXDR_RXD_Msk                              /*!< CEC Rx Data                               */

/*******************  Bit definition for CEC_ISR register  ********************/
#define CEC_ISR_RXBR_Pos         (0U)
#define CEC_ISR_RXBR_Msk         (0x1U << CEC_ISR_RXBR_Pos)                    /*!< 0x00000001 */
#define CEC_ISR_RXBR             CEC_ISR_RXBR_Msk                              /*!< CEC Rx-Byte Received                      */
#define CEC_ISR_RXEND_Pos        (1U)
#define CEC_ISR_RXEND_Msk        (0x1U << CEC_ISR_RXEND_Pos)                   /*!< 0x00000002 */
#define CEC_ISR_RXEND            CEC_ISR_RXEND_Msk                             /*!< CEC End Of Reception                      */
#define CEC_ISR_RXOVR_Pos        (2U)
#define CEC_ISR_RXOVR_Msk        (0x1U << CEC_ISR_RXOVR_Pos)                   /*!< 0x00000004 */
#define CEC_ISR_RXOVR            CEC_ISR_RXOVR_Msk                             /*!< CEC Rx-Overrun                            */
#define CEC_ISR_BRE_Pos          (3U)
#define CEC_ISR_BRE_Msk          (0x1U << CEC_ISR_BRE_Pos)                     /*!< 0x00000008 */
#define CEC_ISR_BRE              CEC_ISR_BRE_Msk                               /*!< CEC Rx Bit Rising Error                   */
#define CEC_ISR_SBPE_Pos         (4U)
#define CEC_ISR_SBPE_Msk         (0x1U << CEC_ISR_SBPE_Pos)                    /*!< 0x00000010 */
#define CEC_ISR_SBPE             CEC_ISR_SBPE_Msk                              /*!< CEC Rx Short Bit period Error             */
#define CEC_ISR_LBPE_Pos         (5U)
#define CEC_ISR_LBPE_Msk         (0x1U << CEC_ISR_LBPE_Pos)                    /*!< 0x00000020 */
#define CEC_ISR_LBPE             CEC_ISR_LBPE_Msk                              /*!< CEC Rx Long Bit period Error              */
#define CEC_ISR_RXACKE_Pos       (6U)
#define CEC_ISR_RXACKE_Msk       (0x1U << CEC_ISR_RXACKE_Pos)                  /*!< 0x00000040 */
#define CEC_ISR_RXACKE           CEC_ISR_RXACKE_Msk                            /*!< CEC Rx Missing Acknowledge                */
#define CEC_ISR_ARBLST_Pos       (7U)
#define CEC_ISR_ARBLST_Msk       (0x1U << CEC_ISR_ARBLST_Pos)                  /*!< 0x00000080 */
#define CEC_ISR_ARBLST           CEC_ISR_ARBLST_Msk                            /*!< CEC Arbitration Lost                      */
#define CEC_ISR_TXBR_Pos         (8U)
#define CEC_ISR_TXBR_Msk         (0x1U << CEC_ISR_TXBR_Pos)                    /*!< 0x00000100 */
#define CEC_ISR_TXBR             CEC_ISR_TXBR_Msk                              /*!< CEC Tx Byte Request                       */
#define CEC_ISR_TXEND_Pos        (9U)
#define CEC_ISR_TXEND_Msk        (0x1U << CEC_ISR_TXEND_Pos)                   /*!< 0x00000200 */
#define CEC_ISR_TXEND            CEC_ISR_TXEND_Msk                             /*!< CEC End of Transmission                   */
#define CEC_ISR_TXUDR_Pos        (10U)
#define CEC_ISR_TXUDR_Msk        (0x1U << CEC_ISR_TXUDR_Pos)                   /*!< 0x00000400 */
#define CEC_ISR_TXUDR            CEC_ISR_TXUDR_Msk                             /*!< CEC Tx-Buffer Underrun                    */
#define CEC_ISR_TXERR_Pos        (11U)
#define CEC_ISR_TXERR_Msk        (0x1U << CEC_ISR_TXERR_Pos)                   /*!< 0x00000800 */
#define CEC_ISR_TXERR            CEC_ISR_TXERR_Msk                             /*!< CEC Tx-Error                              */
#define CEC_ISR_TXACKE_Pos       (12U)
#define CEC_ISR_TXACKE_Msk       (0x1U << CEC_ISR_TXACKE_Pos)                  /*!< 0x00001000 */
#define CEC_ISR_TXACKE           CEC_ISR_TXACKE_Msk                            /*!< CEC Tx Missing Acknowledge                */

/*******************  Bit definition for CEC_IER register  ********************/
#define CEC_IER_RXBRIE_Pos       (0U)
#define CEC_IER_RXBRIE_Msk       (0x1U << CEC_IER_RXBRIE_Pos)                  /*!< 0x00000001 */
#define CEC_IER_RXBRIE           CEC_IER_RXBRIE_Msk                            /*!< CEC Rx-Byte Received IT Enable            */
#define CEC_IER_RXENDIE_Pos      (1U)
#define CEC_IER_RXENDIE_Msk      (0x1U << CEC_IER_RXENDIE_Pos)                 /*!< 0x00000002 */
#define CEC_IER_RXENDIE          CEC_IER_RXENDIE_Msk                           /*!< CEC End Of Reception IT Enable            */
#define CEC_IER_RXOVRIE_Pos      (2U)
#define CEC_IER_RXOVRIE_Msk      (0x1U << CEC_IER_RXOVRIE_Pos)                 /*!< 0x00000004 */
#define CEC_IER_RXOVRIE          CEC_IER_RXOVRIE_Msk                           /*!< CEC Rx-Overrun IT Enable                  */
#define CEC_IER_BREIE_Pos        (3U)
#define CEC_IER_BREIE_Msk        (0x1U << CEC_IER_BREIE_Pos)                   /*!< 0x00000008 */
#define CEC_IER_BREIE            CEC_IER_BREIE_Msk                             /*!< CEC Rx Bit Rising Error IT Enable         */
#define CEC_IER_SBPEIE_Pos       (4U)
#define CEC_IER_SBPEIE_Msk       (0x1U << CEC_IER_SBPEIE_Pos)                  /*!< 0x00000010 */
#define CEC_IER_SBPEIE           CEC_IER_SBPEIE_Msk                            /*!< CEC Rx Short Bit period Error IT Enable   */
#define CEC_IER_LBPEIE_Pos       (5U)
#define CEC_IER_LBPEIE_Msk       (0x1U << CEC_IER_LBPEIE_Pos)                  /*!< 0x00000020 */
#define CEC_IER_LBPEIE           CEC_IER_LBPEIE_Msk                            /*!< CEC Rx Long Bit period Error IT Enable    */
#define CEC_IER_RXACKEIE_Pos     (6U)
#define CEC_IER_RXACKEIE_Msk     (0x1U << CEC_IER_RXACKEIE_Pos)                /*!< 0x00000040 */
#define CEC_IER_RXACKEIE         CEC_IER_RXACKEIE_Msk                          /*!< CEC Rx Missing Acknowledge IT Enable      */
#define CEC_IER_ARBLSTIE_Pos     (7U)
#define CEC_IER_ARBLSTIE_Msk     (0x1U << CEC_IER_ARBLSTIE_Pos)                /*!< 0x00000080 */
#define CEC_IER_ARBLSTIE         CEC_IER_ARBLSTIE_Msk                          /*!< CEC Arbitration Lost IT Enable            */
#define CEC_IER_TXBRIE_Pos       (8U)
#define CEC_IER_TXBRIE_Msk       (0x1U << CEC_IER_TXBRIE_Pos)                  /*!< 0x00000100 */
#define CEC_IER_TXBRIE           CEC_IER_TXBRIE_Msk                            /*!< CEC Tx Byte Request  IT Enable            */
#define CEC_IER_TXENDIE_Pos      (9U)
#define CEC_IER_TXENDIE_Msk      (0x1U << CEC_IER_TXENDIE_Pos)                 /*!< 0x00000200 */
#define CEC_IER_TXENDIE          CEC_IER_TXENDIE_Msk                           /*!< CEC End of Transmission IT Enable         */
#define CEC_IER_TXUDRIE_Pos      (10U)
#define CEC_IER_TXUDRIE_Msk      (0x1U << CEC_IER_TXUDRIE_Pos)                 /*!< 0x00000400 */
#define CEC_IER_TXUDRIE          CEC_IER_TXUDRIE_Msk                           /*!< CEC Tx-Buffer Underrun IT Enable          */
#define CEC_IER_TXERRIE_Pos      (11U)
#define CEC_IER_TXERRIE_Msk      (0x1U << CEC_IER_TXERRIE_Pos)                 /*!< 0x00000800 */
#define CEC_IER_TXERRIE          CEC_IER_TXERRIE_Msk                           /*!< CEC Tx-Error IT Enable                    */
#define CEC_IER_TXACKEIE_Pos     (12U)
#define CEC_IER_TXACKEIE_Msk     (0x1U << CEC_IER_TXACKEIE_Pos)                /*!< 0x00001000 */
#define CEC_IER_TXACKEIE         CEC_IER_TXACKEIE_Msk                          /*!< CEC Tx Missing Acknowledge IT Enable      */

/******************************************************************************/
/*                                                                            */
/*                          CRC calculation unit                              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for CRC_DR register  *********************/
#define CRC_DR_DR_Pos            (0U)
#define CRC_DR_DR_Msk            (0xFFFFFFFFU << CRC_DR_DR_Pos)                /*!< 0xFFFFFFFF */
#define CRC_DR_DR                CRC_DR_DR_Msk                                 /*!< Data register bits */

/*******************  Bit definition for CRC_IDR register  ********************/
#define CRC_IDR_IDR_Pos          (0U)
#define CRC_IDR_IDR_Msk          (0xFFFFFFFFU << CRC_IDR_IDR_Pos)              /*!< 0xFFFFFFFF */
#define CRC_IDR_IDR              CRC_IDR_IDR_Msk                               /*!< General-purpose 32-bit data register bits */

/********************  Bit definition for CRC_CR register  ********************/
#define CRC_CR_RESET_Pos         (0U)
#define CRC_CR_RESET_Msk         (0x1U << CRC_CR_RESET_Pos)                    /*!< 0x00000001 */
#define CRC_CR_RESET             CRC_CR_RESET_Msk                              /*!< RESET the CRC computation unit bit */
#define CRC_CR_POLYSIZE_Pos      (3U)
#define CRC_CR_POLYSIZE_Msk      (0x3U << CRC_CR_POLYSIZE_Pos)                 /*!< 0x00000018 */
#define CRC_CR_POLYSIZE          CRC_CR_POLYSIZE_Msk                           /*!< Polynomial size bits */
#define CRC_CR_POLYSIZE_0        (0x1U << CRC_CR_POLYSIZE_Pos)                 /*!< 0x00000008 */
#define CRC_CR_POLYSIZE_1        (0x2U << CRC_CR_POLYSIZE_Pos)                 /*!< 0x00000010 */
#define CRC_CR_REV_IN_Pos        (5U)
#define CRC_CR_REV_IN_Msk        (0x3U << CRC_CR_REV_IN_Pos)                   /*!< 0x00000060 */
#define CRC_CR_REV_IN            CRC_CR_REV_IN_Msk                             /*!< REV_IN Reverse Input Data bits */
#define CRC_CR_REV_IN_0          (0x1U << CRC_CR_REV_IN_Pos)                   /*!< 0x00000020 */
#define CRC_CR_REV_IN_1          (0x2U << CRC_CR_REV_IN_Pos)                   /*!< 0x00000040 */
#define CRC_CR_REV_OUT_Pos       (7U)
#define CRC_CR_REV_OUT_Msk       (0x1U << CRC_CR_REV_OUT_Pos)                  /*!< 0x00000080 */
#define CRC_CR_REV_OUT           CRC_CR_REV_OUT_Msk                            /*!< REV_OUT Reverse Output Data bits */

/*******************  Bit definition for CRC_INIT register  *******************/
#define CRC_INIT_INIT_Pos        (0U)
#define CRC_INIT_INIT_Msk        (0xFFFFFFFFU << CRC_INIT_INIT_Pos)            /*!< 0xFFFFFFFF */
#define CRC_INIT_INIT            CRC_INIT_INIT_Msk                             /*!< Initial CRC value bits */

/*******************  Bit definition for CRC_POL register  ********************/
#define CRC_POL_POL_Pos          (0U)
#define CRC_POL_POL_Msk          (0xFFFFFFFFU << CRC_POL_POL_Pos)              /*!< 0xFFFFFFFF */
#define CRC_POL_POL              CRC_POL_POL_Msk                               /*!< Coefficients of the polynomial */

/******************************************************************************/
/*                                                                            */
/*                          CRS Clock Recovery System                         */
/******************************************************************************/

/*******************  Bit definition for CRS_CR register  *********************/
#define CRS_CR_SYNCOKIE_Pos       (0U)
#define CRS_CR_SYNCOKIE_Msk       (0x1U << CRS_CR_SYNCOKIE_Pos)                /*!< 0x00000001 */
#define CRS_CR_SYNCOKIE           CRS_CR_SYNCOKIE_Msk                          /*!< SYNC event OK interrupt enable */
#define CRS_CR_SYNCWARNIE_Pos     (1U)
#define CRS_CR_SYNCWARNIE_Msk     (0x1U << CRS_CR_SYNCWARNIE_Pos)              /*!< 0x00000002 */
#define CRS_CR_SYNCWARNIE         CRS_CR_SYNCWARNIE_Msk                        /*!< SYNC warning interrupt enable */
#define CRS_CR_ERRIE_Pos          (2U)
#define CRS_CR_ERRIE_Msk          (0x1U << CRS_CR_ERRIE_Pos)                   /*!< 0x00000004 */
#define CRS_CR_ERRIE              CRS_CR_ERRIE_Msk                             /*!< SYNC error or trimming error interrupt enable */
#define CRS_CR_ESYNCIE_Pos        (3U)
#define CRS_CR_ESYNCIE_Msk        (0x1U << CRS_CR_ESYNCIE_Pos)                 /*!< 0x00000008 */
#define CRS_CR_ESYNCIE            CRS_CR_ESYNCIE_Msk                           /*!< Expected SYNC interrupt enable */
#define CRS_CR_CEN_Pos            (5U)
#define CRS_CR_CEN_Msk            (0x1U << CRS_CR_CEN_Pos)                     /*!< 0x00000020 */
#define CRS_CR_CEN                CRS_CR_CEN_Msk                               /*!< Frequency error counter enable */
#define CRS_CR_AUTOTRIMEN_Pos     (6U)
#define CRS_CR_AUTOTRIMEN_Msk     (0x1U << CRS_CR_AUTOTRIMEN_Pos)              /*!< 0x00000040 */
#define CRS_CR_AUTOTRIMEN         CRS_CR_AUTOTRIMEN_Msk                        /*!< Automatic trimming enable */
#define CRS_CR_SWSYNC_Pos         (7U)
#define CRS_CR_SWSYNC_Msk         (0x1U << CRS_CR_SWSYNC_Pos)                  /*!< 0x00000080 */
#define CRS_CR_SWSYNC             CRS_CR_SWSYNC_Msk                            /*!< Generate software SYNC event */
#define CRS_CR_TRIM_Pos           (8U)
#define CRS_CR_TRIM_Msk           (0x3FU << CRS_CR_TRIM_Pos)                   /*!< 0x00003F00 */
#define CRS_CR_TRIM               CRS_CR_TRIM_Msk                              /*!< HSI48 oscillator smooth trimming */

/*******************  Bit definition for CRS_CFGR register  *********************/
#define CRS_CFGR_RELOAD_Pos       (0U)
#define CRS_CFGR_RELOAD_Msk       (0xFFFFU << CRS_CFGR_RELOAD_Pos)             /*!< 0x0000FFFF */
#define CRS_CFGR_RELOAD           CRS_CFGR_RELOAD_Msk                          /*!< Counter reload value */
#define CRS_CFGR_FELIM_Pos        (16U)
#define CRS_CFGR_FELIM_Msk        (0xFFU << CRS_CFGR_FELIM_Pos)                /*!< 0x00FF0000 */
#define CRS_CFGR_FELIM            CRS_CFGR_FELIM_Msk                           /*!< Frequency error limit */

#define CRS_CFGR_SYNCDIV_Pos      (24U)
#define CRS_CFGR_SYNCDIV_Msk      (0x7U << CRS_CFGR_SYNCDIV_Pos)               /*!< 0x07000000 */
#define CRS_CFGR_SYNCDIV          CRS_CFGR_SYNCDIV_Msk                         /*!< SYNC divider */
#define CRS_CFGR_SYNCDIV_0        (0x1U << CRS_CFGR_SYNCDIV_Pos)               /*!< 0x01000000 */
#define CRS_CFGR_SYNCDIV_1        (0x2U << CRS_CFGR_SYNCDIV_Pos)               /*!< 0x02000000 */
#define CRS_CFGR_SYNCDIV_2        (0x4U << CRS_CFGR_SYNCDIV_Pos)               /*!< 0x04000000 */

#define CRS_CFGR_SYNCSRC_Pos      (28U)
#define CRS_CFGR_SYNCSRC_Msk      (0x3U << CRS_CFGR_SYNCSRC_Pos)               /*!< 0x30000000 */
#define CRS_CFGR_SYNCSRC          CRS_CFGR_SYNCSRC_Msk                         /*!< SYNC signal source selection */
#define CRS_CFGR_SYNCSRC_0        (0x1U << CRS_CFGR_SYNCSRC_Pos)               /*!< 0x10000000 */
#define CRS_CFGR_SYNCSRC_1        (0x2U << CRS_CFGR_SYNCSRC_Pos)               /*!< 0x20000000 */

#define CRS_CFGR_SYNCPOL_Pos      (31U)
#define CRS_CFGR_SYNCPOL_Msk      (0x1U << CRS_CFGR_SYNCPOL_Pos)               /*!< 0x80000000 */
#define CRS_CFGR_SYNCPOL          CRS_CFGR_SYNCPOL_Msk                         /*!< SYNC polarity selection */

/*******************  Bit definition for CRS_ISR register  *********************/
#define CRS_ISR_SYNCOKF_Pos       (0U)
#define CRS_ISR_SYNCOKF_Msk       (0x1U << CRS_ISR_SYNCOKF_Pos)                /*!< 0x00000001 */
#define CRS_ISR_SYNCOKF           CRS_ISR_SYNCOKF_Msk                          /*!< SYNC event OK flag */
#define CRS_ISR_SYNCWARNF_Pos     (1U)
#define CRS_ISR_SYNCWARNF_Msk     (0x1U << CRS_ISR_SYNCWARNF_Pos)              /*!< 0x00000002 */
#define CRS_ISR_SYNCWARNF         CRS_ISR_SYNCWARNF_Msk                        /*!< SYNC warning flag */
#define CRS_ISR_ERRF_Pos          (2U)
#define CRS_ISR_ERRF_Msk          (0x1U << CRS_ISR_ERRF_Pos)                   /*!< 0x00000004 */
#define CRS_ISR_ERRF              CRS_ISR_ERRF_Msk                             /*!< Error flag */
#define CRS_ISR_ESYNCF_Pos        (3U)
#define CRS_ISR_ESYNCF_Msk        (0x1U << CRS_ISR_ESYNCF_Pos)                 /*!< 0x00000008 */
#define CRS_ISR_ESYNCF            CRS_ISR_ESYNCF_Msk                           /*!< Expected SYNC flag */
#define CRS_ISR_SYNCERR_Pos       (8U)
#define CRS_ISR_SYNCERR_Msk       (0x1U << CRS_ISR_SYNCERR_Pos)                /*!< 0x00000100 */
#define CRS_ISR_SYNCERR           CRS_ISR_SYNCERR_Msk                          /*!< SYNC error */
#define CRS_ISR_SYNCMISS_Pos      (9U)
#define CRS_ISR_SYNCMISS_Msk      (0x1U << CRS_ISR_SYNCMISS_Pos)               /*!< 0x00000200 */
#define CRS_ISR_SYNCMISS          CRS_ISR_SYNCMISS_Msk                         /*!< SYNC missed */
#define CRS_ISR_TRIMOVF_Pos       (10U)
#define CRS_ISR_TRIMOVF_Msk       (0x1U << CRS_ISR_TRIMOVF_Pos)                /*!< 0x00000400 */
#define CRS_ISR_TRIMOVF           CRS_ISR_TRIMOVF_Msk                          /*!< Trimming overflow or underflow */
#define CRS_ISR_FEDIR_Pos         (15U)
#define CRS_ISR_FEDIR_Msk         (0x1U << CRS_ISR_FEDIR_Pos)                  /*!< 0x00008000 */
#define CRS_ISR_FEDIR             CRS_ISR_FEDIR_Msk                            /*!< Frequency error direction */
#define CRS_ISR_FECAP_Pos         (16U)
#define CRS_ISR_FECAP_Msk         (0xFFFFU << CRS_ISR_FECAP_Pos)               /*!< 0xFFFF0000 */
#define CRS_ISR_FECAP             CRS_ISR_FECAP_Msk                            /*!< Frequency error capture */

/*******************  Bit definition for CRS_ICR register  *********************/
#define CRS_ICR_SYNCOKC_Pos       (0U)
#define CRS_ICR_SYNCOKC_Msk       (0x1U << CRS_ICR_SYNCOKC_Pos)                /*!< 0x00000001 */
#define CRS_ICR_SYNCOKC           CRS_ICR_SYNCOKC_Msk                          /*!< SYNC event OK clear flag */
#define CRS_ICR_SYNCWARNC_Pos     (1U)
#define CRS_ICR_SYNCWARNC_Msk     (0x1U << CRS_ICR_SYNCWARNC_Pos)              /*!< 0x00000002 */
#define CRS_ICR_SYNCWARNC         CRS_ICR_SYNCWARNC_Msk                        /*!< SYNC warning clear flag */
#define CRS_ICR_ERRC_Pos          (2U)
#define CRS_ICR_ERRC_Msk          (0x1U << CRS_ICR_ERRC_Pos)                   /*!< 0x00000004 */
#define CRS_ICR_ERRC              CRS_ICR_ERRC_Msk                             /*!< Error clear flag */
#define CRS_ICR_ESYNCC_Pos        (3U)
#define CRS_ICR_ESYNCC_Msk        (0x1U << CRS_ICR_ESYNCC_Pos)                 /*!< 0x00000008 */
#define CRS_ICR_ESYNCC            CRS_ICR_ESYNCC_Msk                           /*!< Expected SYNC clear flag */


/******************************************************************************/
/*                                                                            */
/*                      Digital to Analog Converter                           */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for DAC_CR register  ********************/
#define DAC_CR_EN1_Pos              (0U)
#define DAC_CR_EN1_Msk              (0x1U << DAC_CR_EN1_Pos)                   /*!< 0x00000001 */
#define DAC_CR_EN1                  DAC_CR_EN1_Msk                             /*!<DAC channel1 enable */
#define DAC_CR_TEN1_Pos             (1U)
#define DAC_CR_TEN1_Msk             (0x1U << DAC_CR_TEN1_Pos)                  /*!< 0x00000002 */
#define DAC_CR_TEN1                 DAC_CR_TEN1_Msk                            /*!<DAC channel1 Trigger enable */

#define DAC_CR_TSEL1_Pos            (2U)
#define DAC_CR_TSEL1_Msk            (0xFU << DAC_CR_TSEL1_Pos)                 /*!< 0x0000003C */
#define DAC_CR_TSEL1                DAC_CR_TSEL1_Msk                           /*!<TSEL1[2:0] (DAC channel1 Trigger selection) */
#define DAC_CR_TSEL1_0              (0x1U << DAC_CR_TSEL1_Pos)                 /*!< 0x00000004 */
#define DAC_CR_TSEL1_1              (0x2U << DAC_CR_TSEL1_Pos)                 /*!< 0x00000008 */
#define DAC_CR_TSEL1_2              (0x4U << DAC_CR_TSEL1_Pos)                 /*!< 0x00000010 */
#define DAC_CR_TSEL1_3              (0x8U << DAC_CR_TSEL1_Pos)                 /*!< 0x00000020 */


#define DAC_CR_WAVE1_Pos            (6U)
#define DAC_CR_WAVE1_Msk            (0x3U << DAC_CR_WAVE1_Pos)                 /*!< 0x000000C0 */
#define DAC_CR_WAVE1                DAC_CR_WAVE1_Msk                           /*!<WAVE1[1:0] (DAC channel1 noise/triangle wave generation enable) */
#define DAC_CR_WAVE1_0              (0x1U << DAC_CR_WAVE1_Pos)                 /*!< 0x00000040 */
#define DAC_CR_WAVE1_1              (0x2U << DAC_CR_WAVE1_Pos)                 /*!< 0x00000080 */

#define DAC_CR_MAMP1_Pos            (8U)
#define DAC_CR_MAMP1_Msk            (0xFU << DAC_CR_MAMP1_Pos)                 /*!< 0x00000F00 */
#define DAC_CR_MAMP1                DAC_CR_MAMP1_Msk                           /*!<MAMP1[3:0] (DAC channel1 Mask/Amplitude selector) */
#define DAC_CR_MAMP1_0              (0x1U << DAC_CR_MAMP1_Pos)                 /*!< 0x00000100 */
#define DAC_CR_MAMP1_1              (0x2U << DAC_CR_MAMP1_Pos)                 /*!< 0x00000200 */
#define DAC_CR_MAMP1_2              (0x4U << DAC_CR_MAMP1_Pos)                 /*!< 0x00000400 */
#define DAC_CR_MAMP1_3              (0x8U << DAC_CR_MAMP1_Pos)                 /*!< 0x00000800 */

#define DAC_CR_DMAEN1_Pos           (12U)
#define DAC_CR_DMAEN1_Msk           (0x1U << DAC_CR_DMAEN1_Pos)                /*!< 0x00001000 */
#define DAC_CR_DMAEN1               DAC_CR_DMAEN1_Msk                          /*!<DAC channel1 DMA enable */
#define DAC_CR_DMAUDRIE1_Pos        (13U)
#define DAC_CR_DMAUDRIE1_Msk        (0x1U << DAC_CR_DMAUDRIE1_Pos)             /*!< 0x00002000 */
#define DAC_CR_DMAUDRIE1            DAC_CR_DMAUDRIE1_Msk                       /*!<DAC channel 1 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN1_Pos             (14U)
#define DAC_CR_CEN1_Msk             (0x1U << DAC_CR_CEN1_Pos)                  /*!< 0x00004000 */
#define DAC_CR_CEN1                 DAC_CR_CEN1_Msk                            /*!<DAC channel 1 calibration enable >*/
#define DAC_CR_HFSEL_Pos            (15U)
#define DAC_CR_HFSEL_Msk            (0x1U << DAC_CR_HFSEL_Pos)                  /*!< 0x00008000 */
#define DAC_CR_HFSEL                DAC_CR_HFSEL_Msk                            /*!<High frequency interface mode enable >*/

#define DAC_CR_EN2_Pos              (16U)
#define DAC_CR_EN2_Msk              (0x1U << DAC_CR_EN2_Pos)                   /*!< 0x00010000 */
#define DAC_CR_EN2                  DAC_CR_EN2_Msk                             /*!<DAC channel2 enable */
#define DAC_CR_TEN2_Pos             (17U)
#define DAC_CR_TEN2_Msk             (0x1U << DAC_CR_TEN2_Pos)                  /*!< 0x00020000 */
#define DAC_CR_TEN2                 DAC_CR_TEN2_Msk                            /*!<DAC channel2 Trigger enable */

#define DAC_CR_TSEL2_Pos            (18U)
#define DAC_CR_TSEL2_Msk            (0xFU << DAC_CR_TSEL2_Pos)                 /*!< 0x003C0000 */
#define DAC_CR_TSEL2                DAC_CR_TSEL2_Msk                           /*!<TSEL2[2:0] (DAC channel2 Trigger selection) */
#define DAC_CR_TSEL2_0              (0x1U << DAC_CR_TSEL2_Pos)                 /*!< 0x00040000 */
#define DAC_CR_TSEL2_1              (0x2U << DAC_CR_TSEL2_Pos)                 /*!< 0x00080000 */
#define DAC_CR_TSEL2_2              (0x4U << DAC_CR_TSEL2_Pos)                 /*!< 0x00100000 */
#define DAC_CR_TSEL2_3              (0x8U << DAC_CR_TSEL2_Pos)                 /*!< 0x00200000 */


#define DAC_CR_WAVE2_Pos            (22U)
#define DAC_CR_WAVE2_Msk            (0x3U << DAC_CR_WAVE2_Pos)                 /*!< 0x00C00000 */
#define DAC_CR_WAVE2                DAC_CR_WAVE2_Msk                           /*!<WAVE2[1:0] (DAC channel2 noise/triangle wave generation enable) */
#define DAC_CR_WAVE2_0              (0x1U << DAC_CR_WAVE2_Pos)                 /*!< 0x00400000 */
#define DAC_CR_WAVE2_1              (0x2U << DAC_CR_WAVE2_Pos)                 /*!< 0x00800000 */

#define DAC_CR_MAMP2_Pos            (24U)
#define DAC_CR_MAMP2_Msk            (0xFU << DAC_CR_MAMP2_Pos)                 /*!< 0x0F000000 */
#define DAC_CR_MAMP2                DAC_CR_MAMP2_Msk                           /*!<MAMP2[3:0] (DAC channel2 Mask/Amplitude selector) */
#define DAC_CR_MAMP2_0              (0x1U << DAC_CR_MAMP2_Pos)                 /*!< 0x01000000 */
#define DAC_CR_MAMP2_1              (0x2U << DAC_CR_MAMP2_Pos)                 /*!< 0x02000000 */
#define DAC_CR_MAMP2_2              (0x4U << DAC_CR_MAMP2_Pos)                 /*!< 0x04000000 */
#define DAC_CR_MAMP2_3              (0x8U << DAC_CR_MAMP2_Pos)                 /*!< 0x08000000 */

#define DAC_CR_DMAEN2_Pos           (28U)
#define DAC_CR_DMAEN2_Msk           (0x1U << DAC_CR_DMAEN2_Pos)                /*!< 0x10000000 */
#define DAC_CR_DMAEN2               DAC_CR_DMAEN2_Msk                          /*!<DAC channel2 DMA enabled */
#define DAC_CR_DMAUDRIE2_Pos        (29U)
#define DAC_CR_DMAUDRIE2_Msk        (0x1U << DAC_CR_DMAUDRIE2_Pos)             /*!< 0x20000000 */
#define DAC_CR_DMAUDRIE2            DAC_CR_DMAUDRIE2_Msk                       /*!<DAC channel2 DMA underrun interrupt enable  >*/
#define DAC_CR_CEN2_Pos             (30U)
#define DAC_CR_CEN2_Msk             (0x1U << DAC_CR_CEN2_Pos)                  /*!< 0x40000000 */
#define DAC_CR_CEN2                 DAC_CR_CEN2_Msk                            /*!<DAC channel2 calibration enable >*/

/*****************  Bit definition for DAC_SWTRIGR register  ******************/
#define DAC_SWTRIGR_SWTRIG1         ((uint8_t)0x01)                            /*!<DAC channel1 software trigger */
#define DAC_SWTRIGR_SWTRIG2         ((uint8_t)0x02)                            /*!<DAC channel2 software trigger */

/*****************  Bit definition for DAC_DHR12R1 register  ******************/
#define DAC_DHR12R1_DACC1DHR        ((uint16_t)0x0FFF)                         /*!<DAC channel1 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12L1 register  ******************/
#define DAC_DHR12L1_DACC1DHR        ((uint16_t)0xFFF0)                         /*!<DAC channel1 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8R1 register  ******************/
#define DAC_DHR8R1_DACC1DHR         ((uint8_t)0xFF)                            /*!<DAC channel1 8-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12R2 register  ******************/
#define DAC_DHR12R2_DACC2DHR        ((uint16_t)0x0FFF)                         /*!<DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12L2 register  ******************/
#define DAC_DHR12L2_DACC2DHR        ((uint16_t)0xFFF0)                         /*!<DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8R2 register  ******************/
#define DAC_DHR8R2_DACC2DHR         ((uint8_t)0xFF)                            /*!<DAC channel2 8-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12RD register  ******************/
#define DAC_DHR12RD_DACC1DHR_Pos    (0U)
#define DAC_DHR12RD_DACC1DHR_Msk    (0xFFFU << DAC_DHR12RD_DACC1DHR_Pos)       /*!< 0x00000FFF */
#define DAC_DHR12RD_DACC1DHR        DAC_DHR12RD_DACC1DHR_Msk                   /*!<DAC channel1 12-bit Right aligned data */
#define DAC_DHR12RD_DACC2DHR_Pos    (16U)
#define DAC_DHR12RD_DACC2DHR_Msk    (0xFFFU << DAC_DHR12RD_DACC2DHR_Pos)       /*!< 0x0FFF0000 */
#define DAC_DHR12RD_DACC2DHR        DAC_DHR12RD_DACC2DHR_Msk                   /*!<DAC channel2 12-bit Right aligned data */

/*****************  Bit definition for DAC_DHR12LD register  ******************/
#define DAC_DHR12LD_DACC1DHR_Pos    (4U)
#define DAC_DHR12LD_DACC1DHR_Msk    (0xFFFU << DAC_DHR12LD_DACC1DHR_Pos)       /*!< 0x0000FFF0 */
#define DAC_DHR12LD_DACC1DHR        DAC_DHR12LD_DACC1DHR_Msk                   /*!<DAC channel1 12-bit Left aligned data */
#define DAC_DHR12LD_DACC2DHR_Pos    (20U)
#define DAC_DHR12LD_DACC2DHR_Msk    (0xFFFU << DAC_DHR12LD_DACC2DHR_Pos)       /*!< 0xFFF00000 */
#define DAC_DHR12LD_DACC2DHR        DAC_DHR12LD_DACC2DHR_Msk                   /*!<DAC channel2 12-bit Left aligned data */

/******************  Bit definition for DAC_DHR8RD register  ******************/
#define DAC_DHR8RD_DACC1DHR         ((uint16_t)0x00FF)                         /*!<DAC channel1 8-bit Right aligned data */
#define DAC_DHR8RD_DACC2DHR         ((uint16_t)0xFF00)                         /*!<DAC channel2 8-bit Right aligned data */

/*******************  Bit definition for DAC_DOR1 register  *******************/
#define DAC_DOR1_DACC1DOR           ((uint16_t)0x0FFF)                         /*!<DAC channel1 data output */

/*******************  Bit definition for DAC_DOR2 register  *******************/
#define DAC_DOR2_DACC2DOR           ((uint16_t)0x0FFF)                         /*!<DAC channel2 data output */

/********************  Bit definition for DAC_SR register  ********************/
#define DAC_SR_DMAUDR1_Pos          (13U)
#define DAC_SR_DMAUDR1_Msk          (0x1U << DAC_SR_DMAUDR1_Pos)               /*!< 0x00002000 */
#define DAC_SR_DMAUDR1              DAC_SR_DMAUDR1_Msk                         /*!<DAC channel1 DMA underrun flag */
#define DAC_SR_CAL_FLAG1_Pos        (14U)
#define DAC_SR_CAL_FLAG1_Msk        (0x1U << DAC_SR_CAL_FLAG1_Pos)             /*!< 0x00004000 */
#define DAC_SR_CAL_FLAG1            DAC_SR_CAL_FLAG1_Msk                       /*!<DAC channel1 calibration offset status */
#define DAC_SR_BWST1_Pos            (15U)
#define DAC_SR_BWST1_Msk            (0x4001U << DAC_SR_BWST1_Pos)              /*!< 0x20008000 */
#define DAC_SR_BWST1                DAC_SR_BWST1_Msk                           /*!<DAC channel1 busy writing sample time flag */

#define DAC_SR_DMAUDR2_Pos          (29U)
#define DAC_SR_DMAUDR2_Msk          (0x1U << DAC_SR_DMAUDR2_Pos)               /*!< 0x20000000 */
#define DAC_SR_DMAUDR2              DAC_SR_DMAUDR2_Msk                         /*!<DAC channel2 DMA underrun flag */
#define DAC_SR_CAL_FLAG2_Pos        (30U)
#define DAC_SR_CAL_FLAG2_Msk        (0x1U << DAC_SR_CAL_FLAG2_Pos)             /*!< 0x40000000 */
#define DAC_SR_CAL_FLAG2            DAC_SR_CAL_FLAG2_Msk                       /*!<DAC channel2 calibration offset status */
#define DAC_SR_BWST2_Pos            (31U)
#define DAC_SR_BWST2_Msk            (0x1U << DAC_SR_BWST2_Pos)                 /*!< 0x80000000 */
#define DAC_SR_BWST2                DAC_SR_BWST2_Msk                           /*!<DAC channel2 busy writing sample time flag */

/*******************  Bit definition for DAC_CCR register  ********************/
#define DAC_CCR_OTRIM1_Pos          (0U)
#define DAC_CCR_OTRIM1_Msk          (0x1FU << DAC_CCR_OTRIM1_Pos)              /*!< 0x0000001F */
#define DAC_CCR_OTRIM1              DAC_CCR_OTRIM1_Msk                         /*!<DAC channel1 offset trimming value */
#define DAC_CCR_OTRIM2_Pos          (16U)
#define DAC_CCR_OTRIM2_Msk          (0x1FU << DAC_CCR_OTRIM2_Pos)              /*!< 0x001F0000 */
#define DAC_CCR_OTRIM2              DAC_CCR_OTRIM2_Msk                         /*!<DAC channel2 offset trimming value */

/*******************  Bit definition for DAC_MCR register  *******************/
#define DAC_MCR_MODE1_Pos           (0U)
#define DAC_MCR_MODE1_Msk           (0x7U << DAC_MCR_MODE1_Pos)                /*!< 0x00000007 */
#define DAC_MCR_MODE1               DAC_MCR_MODE1_Msk                          /*!<MODE1[2:0] (DAC channel1 mode) */
#define DAC_MCR_MODE1_0             (0x1U << DAC_MCR_MODE1_Pos)                /*!< 0x00000001 */
#define DAC_MCR_MODE1_1             (0x2U << DAC_MCR_MODE1_Pos)                /*!< 0x00000002 */
#define DAC_MCR_MODE1_2             (0x4U << DAC_MCR_MODE1_Pos)                /*!< 0x00000004 */

#define DAC_MCR_MODE2_Pos           (16U)
#define DAC_MCR_MODE2_Msk           (0x7U << DAC_MCR_MODE2_Pos)                /*!< 0x00070000 */
#define DAC_MCR_MODE2               DAC_MCR_MODE2_Msk                          /*!<MODE2[2:0] (DAC channel2 mode) */
#define DAC_MCR_MODE2_0             (0x1U << DAC_MCR_MODE2_Pos)                /*!< 0x00010000 */
#define DAC_MCR_MODE2_1             (0x2U << DAC_MCR_MODE2_Pos)                /*!< 0x00020000 */
#define DAC_MCR_MODE2_2             (0x4U << DAC_MCR_MODE2_Pos)                /*!< 0x00040000 */

/******************  Bit definition for DAC_SHSR1 register  ******************/
#define DAC_SHSR1_TSAMPLE1_Pos      (0U)
#define DAC_SHSR1_TSAMPLE1_Msk      (0x3FFU << DAC_SHSR1_TSAMPLE1_Pos)         /*!< 0x000003FF */
#define DAC_SHSR1_TSAMPLE1          DAC_SHSR1_TSAMPLE1_Msk                     /*!<DAC channel1 sample time */

/******************  Bit definition for DAC_SHSR2 register  ******************/
#define DAC_SHSR1_TSAMPLE2_Pos      (0U)
#define DAC_SHSR1_TSAMPLE2_Msk      (0x3FFU << DAC_SHSR1_TSAMPLE2_Pos)         /*!< 0x000003FF */
#define DAC_SHSR1_TSAMPLE2          DAC_SHSR1_TSAMPLE2_Msk                     /*!<DAC channel2 sample time */

/******************  Bit definition for DAC_SHHR register  ******************/
#define DAC_SHHR_THOLD1_Pos         (0U)
#define DAC_SHHR_THOLD1_Msk         (0x3FFU << DAC_SHHR_THOLD1_Pos)            /*!< 0x000003FF */
#define DAC_SHHR_THOLD1             DAC_SHHR_THOLD1_Msk                        /*!<DAC channel1 hold time */
#define DAC_SHHR_THOLD2_Pos         (16U)
#define DAC_SHHR_THOLD2_Msk         (0x3FFU << DAC_SHHR_THOLD2_Pos)            /*!< 0x03FF0000 */
#define DAC_SHHR_THOLD2             DAC_SHHR_THOLD2_Msk                        /*!<DAC channel2 hold time */

/******************  Bit definition for DAC_SHRR register  ******************/
#define DAC_SHRR_TREFRESH1_Pos      (0U)
#define DAC_SHRR_TREFRESH1_Msk      (0xFFU << DAC_SHRR_TREFRESH1_Pos)          /*!< 0x000000FF */
#define DAC_SHRR_TREFRESH1          DAC_SHRR_TREFRESH1_Msk                     /*!<DAC channel1 refresh time */
#define DAC_SHRR_TREFRESH2_Pos      (16U)
#define DAC_SHRR_TREFRESH2_Msk      (0xFFU << DAC_SHRR_TREFRESH2_Pos)          /*!< 0x00FF0000 */
#define DAC_SHRR_TREFRESH2          DAC_SHRR_TREFRESH2_Msk                     /*!<DAC channel2 refresh time */

/********************  Bit definition for DAC_VER register********************/
#define DAC_VER_MINREV_Pos        (0U)
#define DAC_VER_MINREV_Msk        (0xFU << DAC_VER_MINREV_Pos)           /*!< 0x0000000F */
#define DAC_VER_MINREV            DAC_VER_MINREV_Msk                     /*!< MAJREV[3:0] bits (Minor revision) */
#define DAC_VER_MAJREV_Pos        (4U)
#define DAC_VER_MAJREV_Msk        (0xFU << DAC_VER_MAJREV_Pos)           /*!< 0x000000F0 */
#define DAC_VER_MAJREV            DAC_VER_MAJREV_Msk                     /*!< MINREV[3:0] bits (Major revision) */

/******************************************************************************/
/*                                                                            */
/*                                DBG                                         */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for DBGMCU_IDCODE register  *************/
#define DBGMCU_IDCODE_DEV_ID_Pos              (0U)
#define DBGMCU_IDCODE_DEV_ID_Msk              (0xFFFU << DBGMCU_IDCODE_DEV_ID_Pos) /*!< 0x00000FFF */
#define DBGMCU_IDCODE_DEV_ID                  DBGMCU_IDCODE_DEV_ID_Msk
#define DBGMCU_IDCODE_REV_ID_Pos              (16U)
#define DBGMCU_IDCODE_REV_ID_Msk              (0xFFFFU << DBGMCU_IDCODE_REV_ID_Pos) /*!< 0xFFFF0000 */
#define DBGMCU_IDCODE_REV_ID                  DBGMCU_IDCODE_REV_ID_Msk

/********************  Bit definition for DBGMCU_CR register  *****************/
#define DBGMCU_CR_DBG_SLEEP_Pos               (0U)
#define DBGMCU_CR_DBG_SLEEP_Msk               (0x1U << DBGMCU_CR_DBG_SLEEP_Pos) /*!< 0x00000001 */
#define DBGMCU_CR_DBG_SLEEP                   DBGMCU_CR_DBG_SLEEP_Msk
#define DBGMCU_CR_DBG_STOP_Pos                (1U)
#define DBGMCU_CR_DBG_STOP_Msk                (0x1U << DBGMCU_CR_DBG_STOP_Pos) /*!< 0x00000002 */
#define DBGMCU_CR_DBG_STOP                    DBGMCU_CR_DBG_STOP_Msk
#define DBGMCU_CR_DBG_STANDBY_Pos             (2U)
#define DBGMCU_CR_DBG_STANDBY_Msk             (0x1U << DBGMCU_CR_DBG_STANDBY_Pos) /*!< 0x00000004 */
#define DBGMCU_CR_DBG_STANDBY                 DBGMCU_CR_DBG_STANDBY_Msk
#define DBGMCU_CR_DBG_WDFZCTL_Pos             (24U)
#define DBGMCU_CR_DBG_WDFZCTL_Msk             (0x1U << DBGMCU_CR_DBG_WDFZCTL_Pos) /*!< 0x01000000 */
#define DBGMCU_CR_DBG_WDFZCTL                 DBGMCU_CR_DBG_WDFZCTL_Msk
#define DBGMCU_CR_DBG_TRGOEN_Pos              (28U)
#define DBGMCU_CR_DBG_TRGOEN_Msk              (0x1U << DBGMCU_CR_DBG_TRGOEN_Pos) /*!< 0x10000000 */
#define DBGMCU_CR_DBG_TRGOEN                  DBGMCU_CR_DBG_TRGOEN_Msk

/********************  Bit definition for APB4FZ register  ************/
#define DBGMCU_APB4_FZ_DBG_IWDG2_STOP_Pos     (2U)
#define DBGMCU_APB4_FZ_DBG_IWDG2_STOP_Msk     (0x1U << DBGMCU_APB4_FZ_DBG_IWDG2_STOP_Pos) /*!< 0x00000004 */
#define DBGMCU_APB4_FZ_DBG_IWDG2_STOP         DBGMCU_APB4_FZ_DBG_IWDG2_STOP_Msk

/********************  Bit definition for APB1FZ register  ************/
#define DBGMCU_APB1_FZ_DBG_TIM2_STOP_Pos      (0U)
#define DBGMCU_APB1_FZ_DBG_TIM2_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_TIM2_STOP_Pos) /*!< 0x00000001 */
#define DBGMCU_APB1_FZ_DBG_TIM2_STOP          DBGMCU_APB1_FZ_DBG_TIM2_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM3_STOP_Pos      (1U)
#define DBGMCU_APB1_FZ_DBG_TIM3_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_TIM3_STOP_Pos) /*!< 0x00000002 */
#define DBGMCU_APB1_FZ_DBG_TIM3_STOP          DBGMCU_APB1_FZ_DBG_TIM3_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM4_STOP_Pos      (2U)
#define DBGMCU_APB1_FZ_DBG_TIM4_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_TIM4_STOP_Pos) /*!< 0x00000004 */
#define DBGMCU_APB1_FZ_DBG_TIM4_STOP          DBGMCU_APB1_FZ_DBG_TIM4_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM5_STOP_Pos      (3U)
#define DBGMCU_APB1_FZ_DBG_TIM5_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_TIM5_STOP_Pos) /*!< 0x00000008 */
#define DBGMCU_APB1_FZ_DBG_TIM5_STOP          DBGMCU_APB1_FZ_DBG_TIM5_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM6_STOP_Pos      (4U)
#define DBGMCU_APB1_FZ_DBG_TIM6_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_TIM6_STOP_Pos) /*!< 0x00000010 */
#define DBGMCU_APB1_FZ_DBG_TIM6_STOP          DBGMCU_APB1_FZ_DBG_TIM6_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM7_STOP_Pos      (5U)
#define DBGMCU_APB1_FZ_DBG_TIM7_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_TIM7_STOP_Pos) /*!< 0x00000020 */
#define DBGMCU_APB1_FZ_DBG_TIM7_STOP          DBGMCU_APB1_FZ_DBG_TIM7_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM12_STOP_Pos     (6U)
#define DBGMCU_APB1_FZ_DBG_TIM12_STOP_Msk     (0x1U << DBGMCU_APB1_FZ_DBG_TIM12_STOP_Pos) /*!< 0x00000040 */
#define DBGMCU_APB1_FZ_DBG_TIM12_STOP         DBGMCU_APB1_FZ_DBG_TIM12_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM13_STOP_Pos     (7U)
#define DBGMCU_APB1_FZ_DBG_TIM13_STOP_Msk     (0x1U << DBGMCU_APB1_FZ_DBG_TIM13_STOP_Pos) /*!< 0x00000080 */
#define DBGMCU_APB1_FZ_DBG_TIM13_STOP         DBGMCU_APB1_FZ_DBG_TIM13_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_TIM14_STOP_Pos     (8U)
#define DBGMCU_APB1_FZ_DBG_TIM14_STOP_Msk     (0x1U << DBGMCU_APB1_FZ_DBG_TIM14_STOP_Pos) /*!< 0x00000100 */
#define DBGMCU_APB1_FZ_DBG_TIM14_STOP         DBGMCU_APB1_FZ_DBG_TIM14_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_LPTIM1_STOP_Pos    (9U)
#define DBGMCU_APB1_FZ_DBG_LPTIM1_STOP_Msk    (0x1U << DBGMCU_APB1_FZ_DBG_LPTIM1_STOP_Pos) /*!< 0x00000200 */
#define DBGMCU_APB1_FZ_DBG_LPTIM1_STOP        DBGMCU_APB1_FZ_DBG_LPTIM1_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_WWDG1_STOP_Pos     (10U)
#define DBGMCU_APB1_FZ_DBG_WWDG1_STOP_Msk     (0x1U << DBGMCU_APB1_FZ_DBG_WWDG1_STOP_Pos) /*!< 0x00000400 */
#define DBGMCU_APB1_FZ_DBG_WWDG1_STOP         DBGMCU_APB1_FZ_DBG_WWDG1_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_I2C1_STOP_Pos      (18U)
#define DBGMCU_APB1_FZ_DBG_I2C1_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_I2C1_STOP_Pos) /*!< 0x00040000 */
#define DBGMCU_APB1_FZ_DBG_I2C1_STOP          DBGMCU_APB1_FZ_DBG_I2C1_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_I2C2_STOP_Pos      (19U)
#define DBGMCU_APB1_FZ_DBG_I2C2_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_I2C2_STOP_Pos) /*!< 0x00080000 */
#define DBGMCU_APB1_FZ_DBG_I2C2_STOP          DBGMCU_APB1_FZ_DBG_I2C2_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_I2C3_STOP_Pos      (20U)
#define DBGMCU_APB1_FZ_DBG_I2C3_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_I2C3_STOP_Pos) /*!< 0x00100000 */
#define DBGMCU_APB1_FZ_DBG_I2C3_STOP          DBGMCU_APB1_FZ_DBG_I2C3_STOP_Msk
#define DBGMCU_APB1_FZ_DBG_I2C5_STOP_Pos      (21U)
#define DBGMCU_APB1_FZ_DBG_I2C5_STOP_Msk      (0x1U << DBGMCU_APB1_FZ_DBG_I2C5_STOP_Pos) /*!< 0x00200000 */
#define DBGMCU_APB1_FZ_DBG_I2C5_STOP          DBGMCU_APB1_FZ_DBG_I2C5_STOP_Msk

/********************  Bit definition for APB2FZ register  ************/
#define DBGMCU_APB2_FZ_DBG_TIM1_STOP_Pos      (0U)
#define DBGMCU_APB2_FZ_DBG_TIM1_STOP_Msk      (0x1U << DBGMCU_APB2_FZ_DBG_TIM1_STOP_Pos) /*!< 0x00000001 */
#define DBGMCU_APB2_FZ_DBG_TIM1_STOP          DBGMCU_APB2_FZ_DBG_TIM1_STOP_Msk
#define DBGMCU_APB2_FZ_DBG_TIM8_STOP_Pos      (1U)
#define DBGMCU_APB2_FZ_DBG_TIM8_STOP_Msk      (0x1U << DBGMCU_APB2_FZ_DBG_TIM8_STOP_Pos) /*!< 0x00000002 */
#define DBGMCU_APB2_FZ_DBG_TIM8_STOP          DBGMCU_APB2_FZ_DBG_TIM8_STOP_Msk
#define DBGMCU_APB2_FZ_DBG_TIM15_STOP_Pos     (6U)
#define DBGMCU_APB2_FZ_DBG_TIM15_STOP_Msk     (0x1U << DBGMCU_APB2_FZ_DBG_TIM15_STOP_Pos) /*!< 0x00000040 */
#define DBGMCU_APB2_FZ_DBG_TIM15_STOP         DBGMCU_APB2_FZ_DBG_TIM15_STOP_Msk
#define DBGMCU_APB2_FZ_DBG_TIM16_STOP_Pos     (7U)
#define DBGMCU_APB2_FZ_DBG_TIM16_STOP_Msk     (0x1U << DBGMCU_APB2_FZ_DBG_TIM16_STOP_Pos) /*!< 0x00000080 */
#define DBGMCU_APB2_FZ_DBG_TIM16_STOP         DBGMCU_APB2_FZ_DBG_TIM16_STOP_Msk
#define DBGMCU_APB2_FZ_DBG_TIM17_STOP_Pos     (8U)
#define DBGMCU_APB2_FZ_DBG_TIM17_STOP_Msk     (0x1U << DBGMCU_APB2_FZ_DBG_TIM17_STOP_Pos) /*!< 0x00000100 */
#define DBGMCU_APB2_FZ_DBG_TIM17_STOP         DBGMCU_APB2_FZ_DBG_TIM17_STOP_Msk

/********************  Bit definition for APB3FZ register  ************/
#define DBGMCU_APB3_FZ_DBG_LPTIM2_STOP_Pos    (1U)
#define DBGMCU_APB3_FZ_DBG_LPTIM2_STOP_Msk    (0x1U << DBGMCU_APB3_FZ_DBG_LPTIM2_STOP_Pos) /*!< 0x00000002 */
#define DBGMCU_APB3_FZ_DBG_LPTIM2_STOP        DBGMCU_APB3_FZ_DBG_LPTIM2_STOP_Msk
#define DBGMCU_APB3_FZ_DBG_LPTIM3_STOP_Pos    (2U)
#define DBGMCU_APB3_FZ_DBG_LPTIM3_STOP_Msk    (0x1U << DBGMCU_APB3_FZ_DBG_LPTIM3_STOP_Pos) /*!< 0x00000004 */
#define DBGMCU_APB3_FZ_DBG_LPTIM3_STOP        DBGMCU_APB3_FZ_DBG_LPTIM3_STOP_Msk
#define DBGMCU_APB3_FZ_DBG_LPTIM4_STOP_Pos    (3U)
#define DBGMCU_APB3_FZ_DBG_LPTIM4_STOP_Msk    (0x1U << DBGMCU_APB3_FZ_DBG_LPTIM4_STOP_Pos) /*!< 0x00000008 */
#define DBGMCU_APB3_FZ_DBG_LPTIM4_STOP        DBGMCU_APB3_FZ_DBG_LPTIM4_STOP_Msk
#define DBGMCU_APB3_FZ_DBG_LPTIM5_STOP_Pos    (4U)
#define DBGMCU_APB3_FZ_DBG_LPTIM5_STOP_Msk    (0x1U << DBGMCU_APB3_FZ_DBG_LPTIM5_STOP_Pos) /*!< 0x00000010 */
#define DBGMCU_APB3_FZ_DBG_LPTIM5_STOP        DBGMCU_APB3_FZ_DBG_LPTIM5_STOP_Msk

/********************  Bit definition for APB5FZ register  ************/
#define DBGMCU_APB5_FZ_DBG_I2C4_STOP_Pos      (2U)
#define DBGMCU_APB5_FZ_DBG_I2C4_STOP_Msk      (0x1U << DBGMCU_APB5_FZ_DBG_I2C4_STOP_Pos) /*!< 0x00000004 */
#define DBGMCU_APB5_FZ_DBG_I2C4_STOP          DBGMCU_APB5_FZ_DBG_I2C4_STOP_Msk
#define DBGMCU_APB5_FZ_DBG_IWDG1_STOP_Pos     (3U)
#define DBGMCU_APB5_FZ_DBG_IWDG1_STOP_Msk     (0x1U << DBGMCU_APB5_FZ_DBG_IWDG1_STOP_Pos) /*!< 0x00000008 */
#define DBGMCU_APB5_FZ_DBG_IWDG1_STOP         DBGMCU_APB5_FZ_DBG_IWDG1_STOP_Msk
#define DBGMCU_APB5_FZ_DBG_RTC_STOP_Pos       (4U)
#define DBGMCU_APB5_FZ_DBG_RTC_STOP_Msk       (0x1U << DBGMCU_APB5_FZ_DBG_RTC_STOP_Pos) /*!< 0x00000010 */
#define DBGMCU_APB5_FZ_DBG_RTC_STOP           DBGMCU_APB5_FZ_DBG_RTC_STOP_Msk
#define DBGMCU_APB5_FZ_DBG_I2C6_STOP_Pos      (9U)
#define DBGMCU_APB5_FZ_DBG_I2C6_STOP_Msk      (0x1U << DBGMCU_APB5_FZ_DBG_I2C6_STOP_Pos) /*!< 0x00000200 */
#define DBGMCU_APB5_FZ_DBG_I2C6_STOP          DBGMCU_APB5_FZ_DBG_I2C6_STOP_Msk

/******************************************************************************/
/*                                                                            */
/*                                    DCMI                                    */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for DCMI_CR register  ******************/
#define DCMI_CR_CAPTURE_Pos        (0U)
#define DCMI_CR_CAPTURE_Msk        (0x1UL << DCMI_CR_CAPTURE_Pos)              /*!< 0x00000001 */
#define DCMI_CR_CAPTURE            DCMI_CR_CAPTURE_Msk
#define DCMI_CR_CM_Pos             (1U)
#define DCMI_CR_CM_Msk             (0x1UL << DCMI_CR_CM_Pos)                   /*!< 0x00000002 */
#define DCMI_CR_CM                 DCMI_CR_CM_Msk
#define DCMI_CR_CROP_Pos           (2U)
#define DCMI_CR_CROP_Msk           (0x1UL << DCMI_CR_CROP_Pos)                 /*!< 0x00000004 */
#define DCMI_CR_CROP               DCMI_CR_CROP_Msk
#define DCMI_CR_JPEG_Pos           (3U)
#define DCMI_CR_JPEG_Msk           (0x1UL << DCMI_CR_JPEG_Pos)                 /*!< 0x00000008 */
#define DCMI_CR_JPEG               DCMI_CR_JPEG_Msk
#define DCMI_CR_ESS_Pos            (4U)
#define DCMI_CR_ESS_Msk            (0x1UL << DCMI_CR_ESS_Pos)                  /*!< 0x00000010 */
#define DCMI_CR_ESS                DCMI_CR_ESS_Msk
#define DCMI_CR_PCKPOL_Pos         (5U)
#define DCMI_CR_PCKPOL_Msk         (0x1UL << DCMI_CR_PCKPOL_Pos)               /*!< 0x00000020 */
#define DCMI_CR_PCKPOL             DCMI_CR_PCKPOL_Msk
#define DCMI_CR_HSPOL_Pos          (6U)
#define DCMI_CR_HSPOL_Msk          (0x1UL << DCMI_CR_HSPOL_Pos)                /*!< 0x00000040 */
#define DCMI_CR_HSPOL              DCMI_CR_HSPOL_Msk
#define DCMI_CR_VSPOL_Pos          (7U)
#define DCMI_CR_VSPOL_Msk          (0x1UL << DCMI_CR_VSPOL_Pos)                /*!< 0x00000080 */
#define DCMI_CR_VSPOL              DCMI_CR_VSPOL_Msk
#define DCMI_CR_FCRC_0             ((uint32_t)0x00000100U)
#define DCMI_CR_FCRC_1             ((uint32_t)0x00000200U)
#define DCMI_CR_EDM_0              ((uint32_t)0x00000400U)
#define DCMI_CR_EDM_1              ((uint32_t)0x00000800U)
#define DCMI_CR_CRE_Pos            (12U)
#define DCMI_CR_CRE_Msk            (0x1UL << DCMI_CR_CRE_Pos)                  /*!< 0x00001000 */
#define DCMI_CR_CRE                DCMI_CR_CRE_Msk
#define DCMI_CR_ENABLE_Pos         (14U)
#define DCMI_CR_ENABLE_Msk         (0x1UL << DCMI_CR_ENABLE_Pos)               /*!< 0x00004000 */
#define DCMI_CR_ENABLE             DCMI_CR_ENABLE_Msk
#define DCMI_CR_BSM_Pos            (16U)
#define DCMI_CR_BSM_Msk            (0x3UL << DCMI_CR_BSM_Pos)                  /*!< 0x00030000 */
#define DCMI_CR_BSM                DCMI_CR_BSM_Msk
#define DCMI_CR_BSM_0              (0x1U << DCMI_CR_BSM_Pos)                   /*!< 0x00010000 */
#define DCMI_CR_BSM_1              (0x2U << DCMI_CR_BSM_Pos)                   /*!< 0x00020000 */
#define DCMI_CR_OEBS_Pos           (18U)
#define DCMI_CR_OEBS_Msk           (0x1UL << DCMI_CR_OEBS_Pos)                 /*!< 0x00040000 */
#define DCMI_CR_OEBS               DCMI_CR_OEBS_Msk
#define DCMI_CR_LSM_Pos            (19U)
#define DCMI_CR_LSM_Msk            (0x1UL << DCMI_CR_LSM_Pos)                  /*!< 0x00080000 */
#define DCMI_CR_LSM                DCMI_CR_LSM_Msk
#define DCMI_CR_OELS_Pos           (20U)
#define DCMI_CR_OELS_Msk           (0x1UL << DCMI_CR_OELS_Pos)                 /*!< 0x00100000 */
#define DCMI_CR_OELS               DCMI_CR_OELS_Msk

/********************  Bits definition for DCMI_SR register  ******************/
#define DCMI_SR_HSYNC_Pos          (0U)
#define DCMI_SR_HSYNC_Msk          (0x1UL << DCMI_SR_HSYNC_Pos)                /*!< 0x00000001 */
#define DCMI_SR_HSYNC              DCMI_SR_HSYNC_Msk
#define DCMI_SR_VSYNC_Pos          (1U)
#define DCMI_SR_VSYNC_Msk          (0x1UL << DCMI_SR_VSYNC_Pos)                /*!< 0x00000002 */
#define DCMI_SR_VSYNC              DCMI_SR_VSYNC_Msk
#define DCMI_SR_FNE_Pos            (2U)
#define DCMI_SR_FNE_Msk            (0x1UL << DCMI_SR_FNE_Pos)                  /*!< 0x00000004 */
#define DCMI_SR_FNE                DCMI_SR_FNE_Msk

/********************  Bits definition for DCMI_RIS register   ****************/
#define DCMI_RIS_FRAME_RIS_Pos     (0U)
#define DCMI_RIS_FRAME_RIS_Msk     (0x1UL << DCMI_RIS_FRAME_RIS_Pos)           /*!< 0x00000001 */
#define DCMI_RIS_FRAME_RIS         DCMI_RIS_FRAME_RIS_Msk
#define DCMI_RIS_OVR_RIS_Pos       (1U)
#define DCMI_RIS_OVR_RIS_Msk       (0x1UL << DCMI_RIS_OVR_RIS_Pos)             /*!< 0x00000002 */
#define DCMI_RIS_OVR_RIS           DCMI_RIS_OVR_RIS_Msk
#define DCMI_RIS_ERR_RIS_Pos       (2U)
#define DCMI_RIS_ERR_RIS_Msk       (0x1UL << DCMI_RIS_ERR_RIS_Pos)             /*!< 0x00000004 */
#define DCMI_RIS_ERR_RIS           DCMI_RIS_ERR_RIS_Msk
#define DCMI_RIS_VSYNC_RIS_Pos     (3U)
#define DCMI_RIS_VSYNC_RIS_Msk     (0x1UL << DCMI_RIS_VSYNC_RIS_Pos)           /*!< 0x00000008 */
#define DCMI_RIS_VSYNC_RIS         DCMI_RIS_VSYNC_RIS_Msk
#define DCMI_RIS_LINE_RIS_Pos      (4U)
#define DCMI_RIS_LINE_RIS_Msk      (0x1UL << DCMI_RIS_LINE_RIS_Pos)            /*!< 0x00000010 */
#define DCMI_RIS_LINE_RIS          DCMI_RIS_LINE_RIS_Msk

/********************  Bits definition for DCMI_IER register  *****************/
#define DCMI_IER_FRAME_IE_Pos      (0U)
#define DCMI_IER_FRAME_IE_Msk      (0x1UL << DCMI_IER_FRAME_IE_Pos)            /*!< 0x00000001 */
#define DCMI_IER_FRAME_IE          DCMI_IER_FRAME_IE_Msk
#define DCMI_IER_OVR_IE_Pos        (1U)
#define DCMI_IER_OVR_IE_Msk        (0x1UL << DCMI_IER_OVR_IE_Pos)              /*!< 0x00000002 */
#define DCMI_IER_OVR_IE            DCMI_IER_OVR_IE_Msk
#define DCMI_IER_ERR_IE_Pos        (2U)
#define DCMI_IER_ERR_IE_Msk        (0x1UL << DCMI_IER_ERR_IE_Pos)              /*!< 0x00000004 */
#define DCMI_IER_ERR_IE            DCMI_IER_ERR_IE_Msk
#define DCMI_IER_VSYNC_IE_Pos      (3U)
#define DCMI_IER_VSYNC_IE_Msk      (0x1UL << DCMI_IER_VSYNC_IE_Pos)            /*!< 0x00000008 */
#define DCMI_IER_VSYNC_IE          DCMI_IER_VSYNC_IE_Msk
#define DCMI_IER_LINE_IE_Pos       (4U)
#define DCMI_IER_LINE_IE_Msk       (0x1UL << DCMI_IER_LINE_IE_Pos)             /*!< 0x00000010 */
#define DCMI_IER_LINE_IE           DCMI_IER_LINE_IE_Msk


/********************  Bits definition for DCMI_MIS register  *****************/
#define DCMI_MIS_FRAME_MIS_Pos     (0U)
#define DCMI_MIS_FRAME_MIS_Msk     (0x1UL << DCMI_MIS_FRAME_MIS_Pos)           /*!< 0x00000001 */
#define DCMI_MIS_FRAME_MIS         DCMI_MIS_FRAME_MIS_Msk
#define DCMI_MIS_OVR_MIS_Pos       (1U)
#define DCMI_MIS_OVR_MIS_Msk       (0x1UL << DCMI_MIS_OVR_MIS_Pos)             /*!< 0x00000002 */
#define DCMI_MIS_OVR_MIS           DCMI_MIS_OVR_MIS_Msk
#define DCMI_MIS_ERR_MIS_Pos       (2U)
#define DCMI_MIS_ERR_MIS_Msk       (0x1UL << DCMI_MIS_ERR_MIS_Pos)             /*!< 0x00000004 */
#define DCMI_MIS_ERR_MIS           DCMI_MIS_ERR_MIS_Msk
#define DCMI_MIS_VSYNC_MIS_Pos     (3U)
#define DCMI_MIS_VSYNC_MIS_Msk     (0x1UL << DCMI_MIS_VSYNC_MIS_Pos)           /*!< 0x00000008 */
#define DCMI_MIS_VSYNC_MIS         DCMI_MIS_VSYNC_MIS_Msk
#define DCMI_MIS_LINE_MIS_Pos      (4U)
#define DCMI_MIS_LINE_MIS_Msk      (0x1UL << DCMI_MIS_LINE_MIS_Pos)            /*!< 0x00000010 */
#define DCMI_MIS_LINE_MIS          DCMI_MIS_LINE_MIS_Msk


/********************  Bits definition for DCMI_ICR register  *****************/
#define DCMI_ICR_FRAME_ISC_Pos     (0U)
#define DCMI_ICR_FRAME_ISC_Msk     (0x1UL << DCMI_ICR_FRAME_ISC_Pos)           /*!< 0x00000001 */
#define DCMI_ICR_FRAME_ISC         DCMI_ICR_FRAME_ISC_Msk
#define DCMI_ICR_OVR_ISC_Pos       (1U)
#define DCMI_ICR_OVR_ISC_Msk       (0x1UL << DCMI_ICR_OVR_ISC_Pos)             /*!< 0x00000002 */
#define DCMI_ICR_OVR_ISC           DCMI_ICR_OVR_ISC_Msk
#define DCMI_ICR_ERR_ISC_Pos       (2U)
#define DCMI_ICR_ERR_ISC_Msk       (0x1UL << DCMI_ICR_ERR_ISC_Pos)             /*!< 0x00000004 */
#define DCMI_ICR_ERR_ISC           DCMI_ICR_ERR_ISC_Msk
#define DCMI_ICR_VSYNC_ISC_Pos     (3U)
#define DCMI_ICR_VSYNC_ISC_Msk     (0x1UL << DCMI_ICR_VSYNC_ISC_Pos)           /*!< 0x00000008 */
#define DCMI_ICR_VSYNC_ISC         DCMI_ICR_VSYNC_ISC_Msk
#define DCMI_ICR_LINE_ISC_Pos      (4U)
#define DCMI_ICR_LINE_ISC_Msk      (0x1UL << DCMI_ICR_LINE_ISC_Pos)            /*!< 0x00000010 */
#define DCMI_ICR_LINE_ISC          DCMI_ICR_LINE_ISC_Msk


/********************  Bits definition for DCMI_ESCR register  ******************/
#define DCMI_ESCR_FSC_Pos          (0U)
#define DCMI_ESCR_FSC_Msk          (0xFFUL << DCMI_ESCR_FSC_Pos)               /*!< 0x000000FF */
#define DCMI_ESCR_FSC              DCMI_ESCR_FSC_Msk
#define DCMI_ESCR_LSC_Pos          (8U)
#define DCMI_ESCR_LSC_Msk          (0xFFUL << DCMI_ESCR_LSC_Pos)               /*!< 0x0000FF00 */
#define DCMI_ESCR_LSC              DCMI_ESCR_LSC_Msk
#define DCMI_ESCR_LEC_Pos          (16U)
#define DCMI_ESCR_LEC_Msk          (0xFFUL << DCMI_ESCR_LEC_Pos)               /*!< 0x00FF0000 */
#define DCMI_ESCR_LEC              DCMI_ESCR_LEC_Msk
#define DCMI_ESCR_FEC_Pos          (24U)
#define DCMI_ESCR_FEC_Msk          (0xFFUL << DCMI_ESCR_FEC_Pos)               /*!< 0xFF000000 */
#define DCMI_ESCR_FEC              DCMI_ESCR_FEC_Msk

/********************  Bits definition for DCMI_ESUR register  ******************/
#define DCMI_ESUR_FSU_Pos          (0U)
#define DCMI_ESUR_FSU_Msk          (0xFFUL << DCMI_ESUR_FSU_Pos)               /*!< 0x000000FF */
#define DCMI_ESUR_FSU              DCMI_ESUR_FSU_Msk
#define DCMI_ESUR_LSU_Pos          (8U)
#define DCMI_ESUR_LSU_Msk          (0xFFUL << DCMI_ESUR_LSU_Pos)               /*!< 0x0000FF00 */
#define DCMI_ESUR_LSU              DCMI_ESUR_LSU_Msk
#define DCMI_ESUR_LEU_Pos          (16U)
#define DCMI_ESUR_LEU_Msk          (0xFFUL << DCMI_ESUR_LEU_Pos)               /*!< 0x00FF0000 */
#define DCMI_ESUR_LEU              DCMI_ESUR_LEU_Msk
#define DCMI_ESUR_FEU_Pos          (24U)
#define DCMI_ESUR_FEU_Msk          (0xFFUL << DCMI_ESUR_FEU_Pos)               /*!< 0xFF000000 */
#define DCMI_ESUR_FEU              DCMI_ESUR_FEU_Msk

/********************  Bits definition for DCMI_CWSTRT register  ******************/
#define DCMI_CWSTRT_HOFFCNT_Pos    (0U)
#define DCMI_CWSTRT_HOFFCNT_Msk    (0x3FFFUL << DCMI_CWSTRT_HOFFCNT_Pos)       /*!< 0x00003FFF */
#define DCMI_CWSTRT_HOFFCNT        DCMI_CWSTRT_HOFFCNT_Msk
#define DCMI_CWSTRT_VST_Pos        (16U)
#define DCMI_CWSTRT_VST_Msk        (0x1FFFUL << DCMI_CWSTRT_VST_Pos)           /*!< 0x1FFF0000 */
#define DCMI_CWSTRT_VST            DCMI_CWSTRT_VST_Msk

/********************  Bits definition for DCMI_CWSIZE register  ******************/
#define DCMI_CWSIZE_CAPCNT_Pos     (0U)
#define DCMI_CWSIZE_CAPCNT_Msk     (0x3FFFUL << DCMI_CWSIZE_CAPCNT_Pos)        /*!< 0x00003FFF */
#define DCMI_CWSIZE_CAPCNT         DCMI_CWSIZE_CAPCNT_Msk
#define DCMI_CWSIZE_VLINE_Pos      (16U)
#define DCMI_CWSIZE_VLINE_Msk      (0x3FFFUL << DCMI_CWSIZE_VLINE_Pos)         /*!< 0x3FFF0000 */
#define DCMI_CWSIZE_VLINE          DCMI_CWSIZE_VLINE_Msk

/********************  Bits definition for DCMI_DR register  ******************/
#define DCMI_DR_BYTE0_Pos          (0U)
#define DCMI_DR_BYTE0_Msk          (0xFFUL << DCMI_DR_BYTE0_Pos)               /*!< 0x000000FF */
#define DCMI_DR_BYTE0              DCMI_DR_BYTE0_Msk
#define DCMI_DR_BYTE1_Pos          (8U)
#define DCMI_DR_BYTE1_Msk          (0xFFUL << DCMI_DR_BYTE1_Pos)               /*!< 0x0000FF00 */
#define DCMI_DR_BYTE1              DCMI_DR_BYTE1_Msk
#define DCMI_DR_BYTE2_Pos          (16U)
#define DCMI_DR_BYTE2_Msk          (0xFFUL << DCMI_DR_BYTE2_Pos)               /*!< 0x00FF0000 */
#define DCMI_DR_BYTE2              DCMI_DR_BYTE2_Msk
#define DCMI_DR_BYTE3_Pos          (24U)
#define DCMI_DR_BYTE3_Msk          (0xFFUL << DCMI_DR_BYTE3_Pos)               /*!< 0xFF000000 */
#define DCMI_DR_BYTE3              DCMI_DR_BYTE3_Msk

/******************************************************************************/
/*                                                                            */
/*                 Digital Filter for Sigma Delta Modulators                  */
/*                                                                            */
/******************************************************************************/

/****************   DFSDM channel configuration registers  ********************/

/***************  Bit definition for DFSDM_CHCFGR1 register  ******************/
#define DFSDM_CHCFGR1_DFSDMEN_Pos       (31U)
#define DFSDM_CHCFGR1_DFSDMEN_Msk       (0x1UL << DFSDM_CHCFGR1_DFSDMEN_Pos)   /*!< 0x80000000 */
#define DFSDM_CHCFGR1_DFSDMEN           DFSDM_CHCFGR1_DFSDMEN_Msk              /*!< Global enable for DFSDM interface */
#define DFSDM_CHCFGR1_CKOUTSRC_Pos      (30U)
#define DFSDM_CHCFGR1_CKOUTSRC_Msk      (0x1UL << DFSDM_CHCFGR1_CKOUTSRC_Pos)  /*!< 0x40000000 */
#define DFSDM_CHCFGR1_CKOUTSRC          DFSDM_CHCFGR1_CKOUTSRC_Msk             /*!< Output serial clock source selection */
#define DFSDM_CHCFGR1_CKOUTDIV_Pos      (16U)
#define DFSDM_CHCFGR1_CKOUTDIV_Msk      (0xFFUL << DFSDM_CHCFGR1_CKOUTDIV_Pos) /*!< 0x00FF0000 */
#define DFSDM_CHCFGR1_CKOUTDIV          DFSDM_CHCFGR1_CKOUTDIV_Msk             /*!< CKOUTDIV[7:0] output serial clock divider */
#define DFSDM_CHCFGR1_DATPACK_Pos       (14U)
#define DFSDM_CHCFGR1_DATPACK_Msk       (0x3UL << DFSDM_CHCFGR1_DATPACK_Pos)   /*!< 0x0000C000 */
#define DFSDM_CHCFGR1_DATPACK           DFSDM_CHCFGR1_DATPACK_Msk              /*!< DATPACK[1:0] Data packing mode */
#define DFSDM_CHCFGR1_DATPACK_1         (0x2UL << DFSDM_CHCFGR1_DATPACK_Pos)   /*!< 0x00008000 */
#define DFSDM_CHCFGR1_DATPACK_0         (0x1UL << DFSDM_CHCFGR1_DATPACK_Pos)   /*!< 0x00004000 */
#define DFSDM_CHCFGR1_DATMPX_Pos        (12U)
#define DFSDM_CHCFGR1_DATMPX_Msk        (0x3UL << DFSDM_CHCFGR1_DATMPX_Pos)    /*!< 0x00003000 */
#define DFSDM_CHCFGR1_DATMPX            DFSDM_CHCFGR1_DATMPX_Msk               /*!< DATMPX[1:0] Input data multiplexer for channel y */
#define DFSDM_CHCFGR1_DATMPX_1          (0x2UL << DFSDM_CHCFGR1_DATMPX_Pos)    /*!< 0x00002000 */
#define DFSDM_CHCFGR1_DATMPX_0          (0x1UL << DFSDM_CHCFGR1_DATMPX_Pos)    /*!< 0x00001000 */
#define DFSDM_CHCFGR1_CHINSEL_Pos       (8U)
#define DFSDM_CHCFGR1_CHINSEL_Msk       (0x1UL << DFSDM_CHCFGR1_CHINSEL_Pos)   /*!< 0x00000100 */
#define DFSDM_CHCFGR1_CHINSEL           DFSDM_CHCFGR1_CHINSEL_Msk              /*!< Serial inputs selection for channel y */
#define DFSDM_CHCFGR1_CHEN_Pos          (7U)
#define DFSDM_CHCFGR1_CHEN_Msk          (0x1UL << DFSDM_CHCFGR1_CHEN_Pos)      /*!< 0x00000080 */
#define DFSDM_CHCFGR1_CHEN              DFSDM_CHCFGR1_CHEN_Msk                 /*!< Channel y enable */
#define DFSDM_CHCFGR1_CKABEN_Pos        (6U)
#define DFSDM_CHCFGR1_CKABEN_Msk        (0x1UL << DFSDM_CHCFGR1_CKABEN_Pos)    /*!< 0x00000040 */
#define DFSDM_CHCFGR1_CKABEN            DFSDM_CHCFGR1_CKABEN_Msk               /*!< Clock absence detector enable on channel y */
#define DFSDM_CHCFGR1_SCDEN_Pos         (5U)
#define DFSDM_CHCFGR1_SCDEN_Msk         (0x1UL << DFSDM_CHCFGR1_SCDEN_Pos)     /*!< 0x00000020 */
#define DFSDM_CHCFGR1_SCDEN             DFSDM_CHCFGR1_SCDEN_Msk                /*!< Short circuit detector enable on channel y */
#define DFSDM_CHCFGR1_SPICKSEL_Pos      (2U)
#define DFSDM_CHCFGR1_SPICKSEL_Msk      (0x3UL << DFSDM_CHCFGR1_SPICKSEL_Pos)  /*!< 0x0000000C */
#define DFSDM_CHCFGR1_SPICKSEL          DFSDM_CHCFGR1_SPICKSEL_Msk             /*!< SPICKSEL[1:0] SPI clock select for channel y */
#define DFSDM_CHCFGR1_SPICKSEL_1        (0x2UL << DFSDM_CHCFGR1_SPICKSEL_Pos)  /*!< 0x00000008 */
#define DFSDM_CHCFGR1_SPICKSEL_0        (0x1UL << DFSDM_CHCFGR1_SPICKSEL_Pos)  /*!< 0x00000004 */
#define DFSDM_CHCFGR1_SITP_Pos          (0U)
#define DFSDM_CHCFGR1_SITP_Msk          (0x3UL << DFSDM_CHCFGR1_SITP_Pos)      /*!< 0x00000003 */
#define DFSDM_CHCFGR1_SITP              DFSDM_CHCFGR1_SITP_Msk                 /*!< SITP[1:0] Serial interface type for channel y */
#define DFSDM_CHCFGR1_SITP_1            (0x2UL << DFSDM_CHCFGR1_SITP_Pos)      /*!< 0x00000002 */
#define DFSDM_CHCFGR1_SITP_0            (0x1UL << DFSDM_CHCFGR1_SITP_Pos)      /*!< 0x00000001 */

/***************  Bit definition for DFSDM_CHCFGR2 register  ******************/
#define DFSDM_CHCFGR2_OFFSET_Pos        (8U)
#define DFSDM_CHCFGR2_OFFSET_Msk        (0xFFFFFFUL << DFSDM_CHCFGR2_OFFSET_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_CHCFGR2_OFFSET            DFSDM_CHCFGR2_OFFSET_Msk               /*!< OFFSET[23:0] 24-bit calibration offset for channel y */
#define DFSDM_CHCFGR2_DTRBS_Pos         (3U)
#define DFSDM_CHCFGR2_DTRBS_Msk         (0x1FUL << DFSDM_CHCFGR2_DTRBS_Pos)    /*!< 0x000000F8 */
#define DFSDM_CHCFGR2_DTRBS             DFSDM_CHCFGR2_DTRBS_Msk                /*!< DTRBS[4:0] Data right bit-shift for channel y */

/****************  Bit definition for DFSDM_CHAWSCDR register *****************/
#define DFSDM_CHAWSCDR_AWFORD_Pos       (22U)
#define DFSDM_CHAWSCDR_AWFORD_Msk       (0x3UL << DFSDM_CHAWSCDR_AWFORD_Pos)   /*!< 0x00C00000 */
#define DFSDM_CHAWSCDR_AWFORD           DFSDM_CHAWSCDR_AWFORD_Msk              /*!< AWFORD[1:0] Analog watchdog Sinc filter order on channel y */
#define DFSDM_CHAWSCDR_AWFORD_1         (0x2UL << DFSDM_CHAWSCDR_AWFORD_Pos)   /*!< 0x00800000 */
#define DFSDM_CHAWSCDR_AWFORD_0         (0x1UL << DFSDM_CHAWSCDR_AWFORD_Pos)   /*!< 0x00400000 */
#define DFSDM_CHAWSCDR_AWFOSR_Pos       (16U)
#define DFSDM_CHAWSCDR_AWFOSR_Msk       (0x1FUL << DFSDM_CHAWSCDR_AWFOSR_Pos)  /*!< 0x001F0000 */
#define DFSDM_CHAWSCDR_AWFOSR           DFSDM_CHAWSCDR_AWFOSR_Msk              /*!< AWFOSR[4:0] Analog watchdog filter oversampling ratio on channel y */
#define DFSDM_CHAWSCDR_BKSCD_Pos        (12U)
#define DFSDM_CHAWSCDR_BKSCD_Msk        (0xFUL << DFSDM_CHAWSCDR_BKSCD_Pos)    /*!< 0x0000F000 */
#define DFSDM_CHAWSCDR_BKSCD            DFSDM_CHAWSCDR_BKSCD_Msk               /*!< BKSCD[3:0] Break signal assignment for short circuit detector on channel y */
#define DFSDM_CHAWSCDR_SCDT_Pos         (0U)
#define DFSDM_CHAWSCDR_SCDT_Msk         (0xFFUL << DFSDM_CHAWSCDR_SCDT_Pos)    /*!< 0x000000FF */
#define DFSDM_CHAWSCDR_SCDT             DFSDM_CHAWSCDR_SCDT_Msk                /*!< SCDT[7:0] Short circuit detector threshold for channel y */

/****************  Bit definition for DFSDM_CHWDATR register *******************/
#define DFSDM_CHWDATR_WDATA_Pos         (0U)
#define DFSDM_CHWDATR_WDATA_Msk         (0xFFFFUL << DFSDM_CHWDATR_WDATA_Pos)  /*!< 0x0000FFFF */
#define DFSDM_CHWDATR_WDATA             DFSDM_CHWDATR_WDATA_Msk                /*!< WDATA[15:0] Input channel y watchdog data */

/****************  Bit definition for DFSDM_CHDATINR register *****************/
#define DFSDM_CHDATINR_INDAT0_Pos       (0U)
#define DFSDM_CHDATINR_INDAT0_Msk       (0xFFFFUL << DFSDM_CHDATINR_INDAT0_Pos)/*!< 0x0000FFFF */
#define DFSDM_CHDATINR_INDAT0           DFSDM_CHDATINR_INDAT0_Msk              /*!< INDAT0[31:16] Input data for channel y or channel (y+1) */
#define DFSDM_CHDATINR_INDAT1_Pos       (16U)
#define DFSDM_CHDATINR_INDAT1_Msk       (0xFFFFUL << DFSDM_CHDATINR_INDAT1_Pos)/*!< 0xFFFF0000 */
#define DFSDM_CHDATINR_INDAT1           DFSDM_CHDATINR_INDAT1_Msk              /*!< INDAT0[15:0] Input data for channel y */

/****************  Bit definition for DFSDM_CHDLYR register *******************/
#define DFSDM_CHDLYR_PLSSKP_Pos         (0U)
#define DFSDM_CHDLYR_PLSSKP_Msk         (0x3FUL << DFSDM_CHDLYR_PLSSKP_Pos)    /*!< 0x0000003F */
#define DFSDM_CHDLYR_PLSSKP             DFSDM_CHDLYR_PLSSKP_Msk                /*!< PLSSKP[5:0] Number of input serial samples that will be skipped */

/************************   DFSDM module registers  ****************************/

/*****************  Bit definition for DFSDM_FLTCR1 register *******************/
#define DFSDM_FLTCR1_AWFSEL_Pos         (30U)
#define DFSDM_FLTCR1_AWFSEL_Msk         (0x1UL << DFSDM_FLTCR1_AWFSEL_Pos)     /*!< 0x40000000 */
#define DFSDM_FLTCR1_AWFSEL             DFSDM_FLTCR1_AWFSEL_Msk                /*!< Analog watchdog fast mode select */
#define DFSDM_FLTCR1_FAST_Pos           (29U)
#define DFSDM_FLTCR1_FAST_Msk           (0x1UL << DFSDM_FLTCR1_FAST_Pos)       /*!< 0x20000000 */
#define DFSDM_FLTCR1_FAST               DFSDM_FLTCR1_FAST_Msk                  /*!< Fast conversion mode selection */
#define DFSDM_FLTCR1_RCH_Pos            (24U)
#define DFSDM_FLTCR1_RCH_Msk            (0x7UL << DFSDM_FLTCR1_RCH_Pos)        /*!< 0x07000000 */
#define DFSDM_FLTCR1_RCH                DFSDM_FLTCR1_RCH_Msk                   /*!< RCH[2:0] Regular channel selection */
#define DFSDM_FLTCR1_RDMAEN_Pos         (21U)
#define DFSDM_FLTCR1_RDMAEN_Msk         (0x1UL << DFSDM_FLTCR1_RDMAEN_Pos)     /*!< 0x00200000 */
#define DFSDM_FLTCR1_RDMAEN             DFSDM_FLTCR1_RDMAEN_Msk                /*!< DMA channel enabled to read data for the regular conversion */
#define DFSDM_FLTCR1_RSYNC_Pos          (19U)
#define DFSDM_FLTCR1_RSYNC_Msk          (0x1UL << DFSDM_FLTCR1_RSYNC_Pos)      /*!< 0x00080000 */
#define DFSDM_FLTCR1_RSYNC              DFSDM_FLTCR1_RSYNC_Msk                 /*!< Launch regular conversion synchronously with DFSDMx */
#define DFSDM_FLTCR1_RCONT_Pos          (18U)
#define DFSDM_FLTCR1_RCONT_Msk          (0x1UL << DFSDM_FLTCR1_RCONT_Pos)      /*!< 0x00040000 */
#define DFSDM_FLTCR1_RCONT              DFSDM_FLTCR1_RCONT_Msk                 /*!< Continuous mode selection for regular conversions */
#define DFSDM_FLTCR1_RSWSTART_Pos       (17U)
#define DFSDM_FLTCR1_RSWSTART_Msk       (0x1UL << DFSDM_FLTCR1_RSWSTART_Pos)   /*!< 0x00020000 */
#define DFSDM_FLTCR1_RSWSTART           DFSDM_FLTCR1_RSWSTART_Msk              /*!< Software start of a conversion on the regular channel */
#define DFSDM_FLTCR1_JEXTEN_Pos         (13U)
#define DFSDM_FLTCR1_JEXTEN_Msk         (0x3UL << DFSDM_FLTCR1_JEXTEN_Pos)     /*!< 0x00006000 */
#define DFSDM_FLTCR1_JEXTEN             DFSDM_FLTCR1_JEXTEN_Msk                /*!< JEXTEN[1:0] Trigger enable and trigger edge selection for injected conversions */
#define DFSDM_FLTCR1_JEXTEN_1           (0x2UL << DFSDM_FLTCR1_JEXTEN_Pos)     /*!< 0x00004000 */
#define DFSDM_FLTCR1_JEXTEN_0           (0x1UL << DFSDM_FLTCR1_JEXTEN_Pos)     /*!< 0x00002000 */
#define DFSDM_FLTCR1_JEXTSEL_Pos        (8U)
#define DFSDM_FLTCR1_JEXTSEL_Msk        (0x1FUL << DFSDM_FLTCR1_JEXTSEL_Pos)   /*!< 0x00001F00 */
#define DFSDM_FLTCR1_JEXTSEL            DFSDM_FLTCR1_JEXTSEL_Msk               /*!< JEXTSEL[4:0]Trigger signal selection for launching injected conversions */
#define DFSDM_FLTCR1_JEXTSEL_4          (0x10UL << DFSDM_FLTCR1_JEXTSEL_Pos)   /*!< 0x00001000 */
#define DFSDM_FLTCR1_JEXTSEL_3          (0x08UL << DFSDM_FLTCR1_JEXTSEL_Pos)   /*!< 0x00000800 */
#define DFSDM_FLTCR1_JEXTSEL_2          (0x04UL << DFSDM_FLTCR1_JEXTSEL_Pos)   /*!< 0x00000400 */
#define DFSDM_FLTCR1_JEXTSEL_1          (0x02UL << DFSDM_FLTCR1_JEXTSEL_Pos)   /*!< 0x00000200 */
#define DFSDM_FLTCR1_JEXTSEL_0          (0x01UL << DFSDM_FLTCR1_JEXTSEL_Pos)   /*!< 0x00000100 */
#define DFSDM_FLTCR1_JDMAEN_Pos         (5U)
#define DFSDM_FLTCR1_JDMAEN_Msk         (0x1UL << DFSDM_FLTCR1_JDMAEN_Pos)     /*!< 0x00000020 */
#define DFSDM_FLTCR1_JDMAEN             DFSDM_FLTCR1_JDMAEN_Msk                /*!< DMA channel enabled to read data for the injected channel group */
#define DFSDM_FLTCR1_JSCAN_Pos          (4U)
#define DFSDM_FLTCR1_JSCAN_Msk          (0x1UL << DFSDM_FLTCR1_JSCAN_Pos)      /*!< 0x00000010 */
#define DFSDM_FLTCR1_JSCAN              DFSDM_FLTCR1_JSCAN_Msk                 /*!< Scanning conversion in continuous mode selection for injected conversions */
#define DFSDM_FLTCR1_JSYNC_Pos          (3U)
#define DFSDM_FLTCR1_JSYNC_Msk          (0x1UL << DFSDM_FLTCR1_JSYNC_Pos)      /*!< 0x00000008 */
#define DFSDM_FLTCR1_JSYNC              DFSDM_FLTCR1_JSYNC_Msk                 /*!< Launch an injected conversion synchronously with DFSDMx JSWSTART trigger  */
#define DFSDM_FLTCR1_JSWSTART_Pos       (1U)
#define DFSDM_FLTCR1_JSWSTART_Msk       (0x1UL << DFSDM_FLTCR1_JSWSTART_Pos)   /*!< 0x00000002 */
#define DFSDM_FLTCR1_JSWSTART           DFSDM_FLTCR1_JSWSTART_Msk              /*!< Start the conversion of the injected group of channels */
#define DFSDM_FLTCR1_DFEN_Pos           (0U)
#define DFSDM_FLTCR1_DFEN_Msk           (0x1UL << DFSDM_FLTCR1_DFEN_Pos)       /*!< 0x00000001 */
#define DFSDM_FLTCR1_DFEN               DFSDM_FLTCR1_DFEN_Msk                  /*!< DFSDM enable */

/*****************  Bit definition for DFSDM_FLTCR2 register *******************/
#define DFSDM_FLTCR2_AWDCH_Pos          (16U)
#define DFSDM_FLTCR2_AWDCH_Msk          (0xFFUL << DFSDM_FLTCR2_AWDCH_Pos)     /*!< 0x00FF0000 */
#define DFSDM_FLTCR2_AWDCH              DFSDM_FLTCR2_AWDCH_Msk                 /*!< AWDCH[7:0] Analog watchdog channel selection */
#define DFSDM_FLTCR2_EXCH_Pos           (8U)
#define DFSDM_FLTCR2_EXCH_Msk           (0xFFUL << DFSDM_FLTCR2_EXCH_Pos)      /*!< 0x0000FF00 */
#define DFSDM_FLTCR2_EXCH               DFSDM_FLTCR2_EXCH_Msk                  /*!< EXCH[7:0] Extreme detector channel selection */
#define DFSDM_FLTCR2_CKABIE_Pos         (6U)
#define DFSDM_FLTCR2_CKABIE_Msk         (0x1UL << DFSDM_FLTCR2_CKABIE_Pos)     /*!< 0x00000040 */
#define DFSDM_FLTCR2_CKABIE             DFSDM_FLTCR2_CKABIE_Msk                /*!< Clock absence interrupt enable */
#define DFSDM_FLTCR2_SCDIE_Pos          (5U)
#define DFSDM_FLTCR2_SCDIE_Msk          (0x1UL << DFSDM_FLTCR2_SCDIE_Pos)      /*!< 0x00000020 */
#define DFSDM_FLTCR2_SCDIE              DFSDM_FLTCR2_SCDIE_Msk                 /*!< Short circuit detector interrupt enable */
#define DFSDM_FLTCR2_AWDIE_Pos          (4U)
#define DFSDM_FLTCR2_AWDIE_Msk          (0x1UL << DFSDM_FLTCR2_AWDIE_Pos)      /*!< 0x00000010 */
#define DFSDM_FLTCR2_AWDIE              DFSDM_FLTCR2_AWDIE_Msk                 /*!< Analog watchdog interrupt enable */
#define DFSDM_FLTCR2_ROVRIE_Pos         (3U)
#define DFSDM_FLTCR2_ROVRIE_Msk         (0x1UL << DFSDM_FLTCR2_ROVRIE_Pos)     /*!< 0x00000008 */
#define DFSDM_FLTCR2_ROVRIE             DFSDM_FLTCR2_ROVRIE_Msk                /*!< Regular data overrun interrupt enable */
#define DFSDM_FLTCR2_JOVRIE_Pos         (2U)
#define DFSDM_FLTCR2_JOVRIE_Msk         (0x1UL << DFSDM_FLTCR2_JOVRIE_Pos)     /*!< 0x00000004 */
#define DFSDM_FLTCR2_JOVRIE             DFSDM_FLTCR2_JOVRIE_Msk                /*!< Injected data overrun interrupt enable */
#define DFSDM_FLTCR2_REOCIE_Pos         (1U)
#define DFSDM_FLTCR2_REOCIE_Msk         (0x1UL << DFSDM_FLTCR2_REOCIE_Pos)     /*!< 0x00000002 */
#define DFSDM_FLTCR2_REOCIE             DFSDM_FLTCR2_REOCIE_Msk                /*!< Regular end of conversion interrupt enable */
#define DFSDM_FLTCR2_JEOCIE_Pos         (0U)
#define DFSDM_FLTCR2_JEOCIE_Msk         (0x1UL << DFSDM_FLTCR2_JEOCIE_Pos)     /*!< 0x00000001 */
#define DFSDM_FLTCR2_JEOCIE             DFSDM_FLTCR2_JEOCIE_Msk                /*!< Injected end of conversion interrupt enable */

/*****************  Bit definition for DFSDM_FLTISR register *******************/
#define DFSDM_FLTISR_SCDF_Pos           (24U)
#define DFSDM_FLTISR_SCDF_Msk           (0xFFUL << DFSDM_FLTISR_SCDF_Pos)      /*!< 0xFF000000 */
#define DFSDM_FLTISR_SCDF               DFSDM_FLTISR_SCDF_Msk                  /*!< SCDF[7:0] Short circuit detector flag */
#define DFSDM_FLTISR_CKABF_Pos          (16U)
#define DFSDM_FLTISR_CKABF_Msk          (0xFFUL << DFSDM_FLTISR_CKABF_Pos)     /*!< 0x00FF0000 */
#define DFSDM_FLTISR_CKABF              DFSDM_FLTISR_CKABF_Msk                 /*!< CKABF[7:0] Clock absence flag */
#define DFSDM_FLTISR_RCIP_Pos           (14U)
#define DFSDM_FLTISR_RCIP_Msk           (0x1UL << DFSDM_FLTISR_RCIP_Pos)       /*!< 0x00004000 */
#define DFSDM_FLTISR_RCIP               DFSDM_FLTISR_RCIP_Msk                  /*!< Regular conversion in progress status */
#define DFSDM_FLTISR_JCIP_Pos           (13U)
#define DFSDM_FLTISR_JCIP_Msk           (0x1UL << DFSDM_FLTISR_JCIP_Pos)       /*!< 0x00002000 */
#define DFSDM_FLTISR_JCIP               DFSDM_FLTISR_JCIP_Msk                  /*!< Injected conversion in progress status */
#define DFSDM_FLTISR_AWDF_Pos           (4U)
#define DFSDM_FLTISR_AWDF_Msk           (0x1UL << DFSDM_FLTISR_AWDF_Pos)       /*!< 0x00000010 */
#define DFSDM_FLTISR_AWDF               DFSDM_FLTISR_AWDF_Msk                  /*!< Analog watchdog */
#define DFSDM_FLTISR_ROVRF_Pos          (3U)
#define DFSDM_FLTISR_ROVRF_Msk          (0x1UL << DFSDM_FLTISR_ROVRF_Pos)      /*!< 0x00000008 */
#define DFSDM_FLTISR_ROVRF              DFSDM_FLTISR_ROVRF_Msk                 /*!< Regular conversion overrun flag */
#define DFSDM_FLTISR_JOVRF_Pos          (2U)
#define DFSDM_FLTISR_JOVRF_Msk          (0x1UL << DFSDM_FLTISR_JOVRF_Pos)      /*!< 0x00000004 */
#define DFSDM_FLTISR_JOVRF              DFSDM_FLTISR_JOVRF_Msk                 /*!< Injected conversion overrun flag */
#define DFSDM_FLTISR_REOCF_Pos          (1U)
#define DFSDM_FLTISR_REOCF_Msk          (0x1UL << DFSDM_FLTISR_REOCF_Pos)      /*!< 0x00000002 */
#define DFSDM_FLTISR_REOCF              DFSDM_FLTISR_REOCF_Msk                 /*!< End of regular conversion flag */
#define DFSDM_FLTISR_JEOCF_Pos          (0U)
#define DFSDM_FLTISR_JEOCF_Msk          (0x1UL << DFSDM_FLTISR_JEOCF_Pos)      /*!< 0x00000001 */
#define DFSDM_FLTISR_JEOCF              DFSDM_FLTISR_JEOCF_Msk                 /*!< End of injected conversion flag */

/*****************  Bit definition for DFSDM_FLTICR register *******************/
#define DFSDM_FLTICR_CLRSCDF_Pos        (24U)
#define DFSDM_FLTICR_CLRSCDF_Msk        (0xFFUL << DFSDM_FLTICR_CLRSCDF_Pos)   /*!< 0xFF000000 */
#define DFSDM_FLTICR_CLRSCDF            DFSDM_FLTICR_CLRSCDF_Msk               /*!< CLRSCDF[7:0] Clear the short circuit detector flag */
#define DFSDM_FLTICR_CLRCKABF_Pos       (16U)
#define DFSDM_FLTICR_CLRCKABF_Msk       (0xFFUL << DFSDM_FLTICR_CLRCKABF_Pos)  /*!< 0x00FF0000 */
#define DFSDM_FLTICR_CLRCKABF           DFSDM_FLTICR_CLRCKABF_Msk              /*!< CLRCKABF[7:0] Clear the clock absence flag */
#define DFSDM_FLTICR_CLRROVRF_Pos       (3U)
#define DFSDM_FLTICR_CLRROVRF_Msk       (0x1UL << DFSDM_FLTICR_CLRROVRF_Pos)   /*!< 0x00000008 */
#define DFSDM_FLTICR_CLRROVRF           DFSDM_FLTICR_CLRROVRF_Msk              /*!< Clear the regular conversion overrun flag */
#define DFSDM_FLTICR_CLRJOVRF_Pos       (2U)
#define DFSDM_FLTICR_CLRJOVRF_Msk       (0x1UL << DFSDM_FLTICR_CLRJOVRF_Pos)   /*!< 0x00000004 */
#define DFSDM_FLTICR_CLRJOVRF           DFSDM_FLTICR_CLRJOVRF_Msk              /*!< Clear the injected conversion overrun flag */

/****************  Bit definition for DFSDM_FLTJCHGR register ******************/
#define DFSDM_FLTJCHGR_JCHG_Pos         (0U)
#define DFSDM_FLTJCHGR_JCHG_Msk         (0xFFUL << DFSDM_FLTJCHGR_JCHG_Pos)    /*!< 0x000000FF */
#define DFSDM_FLTJCHGR_JCHG             DFSDM_FLTJCHGR_JCHG_Msk                /*!< JCHG[7:0] Injected channel group selection */

/*****************  Bit definition for DFSDM_FLTFCR register *******************/
#define DFSDM_FLTFCR_FORD_Pos           (29U)
#define DFSDM_FLTFCR_FORD_Msk           (0x7UL << DFSDM_FLTFCR_FORD_Pos)       /*!< 0xE0000000 */
#define DFSDM_FLTFCR_FORD               DFSDM_FLTFCR_FORD_Msk                  /*!< FORD[2:0] Sinc filter order */
#define DFSDM_FLTFCR_FORD_2             (0x4UL << DFSDM_FLTFCR_FORD_Pos)       /*!< 0x80000000 */
#define DFSDM_FLTFCR_FORD_1             (0x2UL << DFSDM_FLTFCR_FORD_Pos)       /*!< 0x40000000 */
#define DFSDM_FLTFCR_FORD_0             (0x1UL << DFSDM_FLTFCR_FORD_Pos)       /*!< 0x20000000 */
#define DFSDM_FLTFCR_FOSR_Pos           (16U)
#define DFSDM_FLTFCR_FOSR_Msk           (0x3FFUL << DFSDM_FLTFCR_FOSR_Pos)     /*!< 0x03FF0000 */
#define DFSDM_FLTFCR_FOSR               DFSDM_FLTFCR_FOSR_Msk                  /*!< FOSR[9:0] Sinc filter oversampling ratio (decimation rate) */
#define DFSDM_FLTFCR_IOSR_Pos           (0U)
#define DFSDM_FLTFCR_IOSR_Msk           (0xFFUL << DFSDM_FLTFCR_IOSR_Pos)      /*!< 0x000000FF */
#define DFSDM_FLTFCR_IOSR               DFSDM_FLTFCR_IOSR_Msk                  /*!< IOSR[7:0] Integrator oversampling ratio (averaging length) */

/***************  Bit definition for DFSDM_FLTJDATAR register *****************/
#define DFSDM_FLTJDATAR_JDATA_Pos       (8U)
#define DFSDM_FLTJDATAR_JDATA_Msk       (0xFFFFFFUL << DFSDM_FLTJDATAR_JDATA_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_FLTJDATAR_JDATA           DFSDM_FLTJDATAR_JDATA_Msk              /*!< JDATA[23:0] Injected group conversion data */
#define DFSDM_FLTJDATAR_JDATACH_Pos     (0U)
#define DFSDM_FLTJDATAR_JDATACH_Msk     (0x7UL << DFSDM_FLTJDATAR_JDATACH_Pos) /*!< 0x00000007 */
#define DFSDM_FLTJDATAR_JDATACH         DFSDM_FLTJDATAR_JDATACH_Msk            /*!< JDATACH[2:0] Injected channel most recently converted */

/***************  Bit definition for DFSDM_FLTRDATAR register *****************/
#define DFSDM_FLTRDATAR_RDATA_Pos       (8U)
#define DFSDM_FLTRDATAR_RDATA_Msk       (0xFFFFFFUL << DFSDM_FLTRDATAR_RDATA_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_FLTRDATAR_RDATA           DFSDM_FLTRDATAR_RDATA_Msk              /*!< RDATA[23:0] Regular channel conversion data */
#define DFSDM_FLTRDATAR_RPEND_Pos       (4U)
#define DFSDM_FLTRDATAR_RPEND_Msk       (0x1UL << DFSDM_FLTRDATAR_RPEND_Pos)   /*!< 0x00000010 */
#define DFSDM_FLTRDATAR_RPEND           DFSDM_FLTRDATAR_RPEND_Msk              /*!< RPEND Regular channel pending data */
#define DFSDM_FLTRDATAR_RDATACH_Pos     (0U)
#define DFSDM_FLTRDATAR_RDATACH_Msk     (0x7UL << DFSDM_FLTRDATAR_RDATACH_Pos) /*!< 0x00000007 */
#define DFSDM_FLTRDATAR_RDATACH         DFSDM_FLTRDATAR_RDATACH_Msk            /*!< RDATACH[2:0] Regular channel most recently converted */

/***************  Bit definition for DFSDM_FLTAWHTR register ******************/
#define DFSDM_FLTAWHTR_AWHT_Pos         (8U)
#define DFSDM_FLTAWHTR_AWHT_Msk         (0xFFFFFFUL << DFSDM_FLTAWHTR_AWHT_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_FLTAWHTR_AWHT             DFSDM_FLTAWHTR_AWHT_Msk                /*!< AWHT[23:0] Analog watchdog high threshold */
#define DFSDM_FLTAWHTR_BKAWH_Pos        (0U)
#define DFSDM_FLTAWHTR_BKAWH_Msk        (0xFUL << DFSDM_FLTAWHTR_BKAWH_Pos)    /*!< 0x0000000F */
#define DFSDM_FLTAWHTR_BKAWH            DFSDM_FLTAWHTR_BKAWH_Msk               /*!< BKAWH[3:0] Break signal assignment to analog watchdog high threshold event */

/***************  Bit definition for DFSDM_FLTAWLTR register ******************/
#define DFSDM_FLTAWLTR_AWLT_Pos         (8U)
#define DFSDM_FLTAWLTR_AWLT_Msk         (0xFFFFFFUL << DFSDM_FLTAWLTR_AWLT_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_FLTAWLTR_AWLT             DFSDM_FLTAWLTR_AWLT_Msk                /*!< AWLT[23:0] Analog watchdog low threshold */
#define DFSDM_FLTAWLTR_BKAWL_Pos        (0U)
#define DFSDM_FLTAWLTR_BKAWL_Msk        (0xFUL << DFSDM_FLTAWLTR_BKAWL_Pos)    /*!< 0x0000000F */
#define DFSDM_FLTAWLTR_BKAWL            DFSDM_FLTAWLTR_BKAWL_Msk               /*!< BKAWL[3:0] Break signal assignment to analog watchdog low threshold event */

/***************  Bit definition for DFSDM_FLTAWSR register *******************/
#define DFSDM_FLTAWSR_AWHTF_Pos         (8U)
#define DFSDM_FLTAWSR_AWHTF_Msk         (0xFFUL << DFSDM_FLTAWSR_AWHTF_Pos)    /*!< 0x0000FF00 */
#define DFSDM_FLTAWSR_AWHTF             DFSDM_FLTAWSR_AWHTF_Msk                /*!< AWHTF[15:8] Analog watchdog high threshold error on given channels */
#define DFSDM_FLTAWSR_AWLTF_Pos         (0U)
#define DFSDM_FLTAWSR_AWLTF_Msk         (0xFFUL << DFSDM_FLTAWSR_AWLTF_Pos)    /*!< 0x000000FF */
#define DFSDM_FLTAWSR_AWLTF             DFSDM_FLTAWSR_AWLTF_Msk                /*!< AWLTF[7:0] Analog watchdog low threshold error on given channels */

/***************  Bit definition for DFSDM_FLTAWCFR register ******************/
#define DFSDM_FLTAWCFR_CLRAWHTF_Pos     (8U)
#define DFSDM_FLTAWCFR_CLRAWHTF_Msk     (0xFFUL << DFSDM_FLTAWCFR_CLRAWHTF_Pos)/*!< 0x0000FF00 */
#define DFSDM_FLTAWCFR_CLRAWHTF         DFSDM_FLTAWCFR_CLRAWHTF_Msk            /*!< CLRAWHTF[15:8] Clear the Analog watchdog high threshold flag */
#define DFSDM_FLTAWCFR_CLRAWLTF_Pos     (0U)
#define DFSDM_FLTAWCFR_CLRAWLTF_Msk     (0xFFUL << DFSDM_FLTAWCFR_CLRAWLTF_Pos)/*!< 0x000000FF */
#define DFSDM_FLTAWCFR_CLRAWLTF         DFSDM_FLTAWCFR_CLRAWLTF_Msk            /*!< CLRAWLTF[7:0] Clear the Analog watchdog low threshold flag */

/***************  Bit definition for DFSDM_FLTEXMAX register ******************/
#define DFSDM_FLTEXMAX_EXMAX_Pos        (8U)
#define DFSDM_FLTEXMAX_EXMAX_Msk        (0xFFFFFFUL << DFSDM_FLTEXMAX_EXMAX_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_FLTEXMAX_EXMAX            DFSDM_FLTEXMAX_EXMAX_Msk               /*!< EXMAX[23:0] Extreme detector maximum value */
#define DFSDM_FLTEXMAX_EXMAXCH_Pos      (0U)
#define DFSDM_FLTEXMAX_EXMAXCH_Msk      (0x7UL << DFSDM_FLTEXMAX_EXMAXCH_Pos)  /*!< 0x00000007 */
#define DFSDM_FLTEXMAX_EXMAXCH          DFSDM_FLTEXMAX_EXMAXCH_Msk             /*!< EXMAXCH[2:0] Extreme detector maximum data channel */

/***************  Bit definition for DFSDM_FLTEXMIN register ******************/
#define DFSDM_FLTEXMIN_EXMIN_Pos        (8U)
#define DFSDM_FLTEXMIN_EXMIN_Msk        (0xFFFFFFUL << DFSDM_FLTEXMIN_EXMIN_Pos)/*!< 0xFFFFFF00 */
#define DFSDM_FLTEXMIN_EXMIN            DFSDM_FLTEXMIN_EXMIN_Msk               /*!< EXMIN[23:0] Extreme detector minimum value */
#define DFSDM_FLTEXMIN_EXMINCH_Pos      (0U)
#define DFSDM_FLTEXMIN_EXMINCH_Msk      (0x7UL << DFSDM_FLTEXMIN_EXMINCH_Pos)  /*!< 0x00000007 */
#define DFSDM_FLTEXMIN_EXMINCH          DFSDM_FLTEXMIN_EXMINCH_Msk             /*!< EXMINCH[2:0] Extreme detector minimum data channel */

/***************  Bit definition for DFSDM_FLTCNVTIMR register ****************/
#define DFSDM_FLTCNVTIMR_CNVCNT_Pos     (4U)
#define DFSDM_FLTCNVTIMR_CNVCNT_Msk     (0xFFFFFFFUL << DFSDM_FLTCNVTIMR_CNVCNT_Pos)/*!< 0xFFFFFFF0 */
#define DFSDM_FLTCNVTIMR_CNVCNT         DFSDM_FLTCNVTIMR_CNVCNT_Msk            /*!< CNVCNT[27:0]: 28-bit timer counting conversion time */


/******************************************************************************/
/*                                                                            */
/*                Ethernet MAC Registers bits definitions                     */
/*                                                                            */
/******************************************************************************/
/* Bit definition for Ethernet MAC Configuration Register register */
#define ETH_MACCR_ARP_Pos                             (31U)
#define ETH_MACCR_ARP_Msk                             (0x1U << ETH_MACCR_ARP_Pos) /*!< 0x80000000 */
#define ETH_MACCR_ARP                                 ETH_MACCR_ARP_Msk        /* ARP Offload Enable */
#define ETH_MACCR_SARC_Pos                            (28U)
#define ETH_MACCR_SARC_Msk                            (0x7U << ETH_MACCR_SARC_Pos) /*!< 0x70000000 */
#define ETH_MACCR_SARC                                ETH_MACCR_SARC_Msk       /* Source Address Insertion or Replacement Control */
#define ETH_MACCR_SARC_MTIATI                         ((uint32_t)0x00000000)   /* The mti_sa_ctrl_i and ati_sa_ctrl_i input signals control the SA field generation. */
#define ETH_MACCR_SARC_INSADDR0_Pos                   (29U)
#define ETH_MACCR_SARC_INSADDR0_Msk                   (0x1U << ETH_MACCR_SARC_INSADDR0_Pos) /*!< 0x20000000 */
#define ETH_MACCR_SARC_INSADDR0                       ETH_MACCR_SARC_INSADDR0_Msk /* Insert MAC Address0 in the SA field of all transmitted packets. */
#define ETH_MACCR_SARC_INSADDR1_Pos                   (29U)
#define ETH_MACCR_SARC_INSADDR1_Msk                   (0x3U << ETH_MACCR_SARC_INSADDR1_Pos) /*!< 0x60000000 */
#define ETH_MACCR_SARC_INSADDR1                       ETH_MACCR_SARC_INSADDR1_Msk /* Insert MAC Address1 in the SA field of all transmitted packets. */
#define ETH_MACCR_SARC_REPADDR0_Pos                   (28U)
#define ETH_MACCR_SARC_REPADDR0_Msk                   (0x3U << ETH_MACCR_SARC_REPADDR0_Pos) /*!< 0x30000000 */
#define ETH_MACCR_SARC_REPADDR0                       ETH_MACCR_SARC_REPADDR0_Msk /* Replace MAC Address0 in the SA field of all transmitted packets. */
#define ETH_MACCR_SARC_REPADDR1_Pos                   (28U)
#define ETH_MACCR_SARC_REPADDR1_Msk                   (0x7U << ETH_MACCR_SARC_REPADDR1_Pos) /*!< 0x70000000 */
#define ETH_MACCR_SARC_REPADDR1                       ETH_MACCR_SARC_REPADDR1_Msk /* Replace MAC Address1 in the SA field of all transmitted packets. */
#define ETH_MACCR_IPC_Pos                             (27U)
#define ETH_MACCR_IPC_Msk                             (0x1U << ETH_MACCR_IPC_Pos) /*!< 0x08000000 */
#define ETH_MACCR_IPC                                 ETH_MACCR_IPC_Msk        /* Checksum Offload */
#define ETH_MACCR_IPG_Pos                             (24U)
#define ETH_MACCR_IPG_Msk                             (0x7U << ETH_MACCR_IPG_Pos) /*!< 0x07000000 */
#define ETH_MACCR_IPG                                 ETH_MACCR_IPG_Msk        /* Inter-Packet Gap */
#define ETH_MACCR_IPG_96BIT                           ((uint32_t)0x00000000)   /* Minimum IFG between Packets during transmission is 96Bit */
#define ETH_MACCR_IPG_88BIT                           ((uint32_t)0x01000000)   /* Minimum IFG between Packets during transmission is 88Bit */
#define ETH_MACCR_IPG_80BIT                           ((uint32_t)0x02000000)   /* Minimum IFG between Packets during transmission is 80Bit */
#define ETH_MACCR_IPG_72BIT                           ((uint32_t)0x03000000)   /* Minimum IFG between Packets during transmission is 72Bit */
#define ETH_MACCR_IPG_64BIT                           ((uint32_t)0x04000000)   /* Minimum IFG between Packets during transmission is 64Bit */
#define ETH_MACCR_IPG_56BIT                           ((uint32_t)0x05000000)   /* Minimum IFG between Packets during transmission is 56Bit */
#define ETH_MACCR_IPG_48BIT                           ((uint32_t)0x06000000)   /* Minimum IFG between Packets during transmission is 48Bit */
#define ETH_MACCR_IPG_40BIT                           ((uint32_t)0x07000000)   /* Minimum IFG between Packets during transmission is 40Bit */
#define ETH_MACCR_GPSLCE_Pos                          (23U)
#define ETH_MACCR_GPSLCE_Msk                          (0x1U << ETH_MACCR_GPSLCE_Pos) /*!< 0x00800000 */
#define ETH_MACCR_GPSLCE                              ETH_MACCR_GPSLCE_Msk     /* Giant Packet Size Limit Control Enable */
#define ETH_MACCR_S2KP_Pos                            (22U)
#define ETH_MACCR_S2KP_Msk                            (0x1U << ETH_MACCR_S2KP_Pos) /*!< 0x00400000 */
#define ETH_MACCR_S2KP                                ETH_MACCR_S2KP_Msk       /* IEEE 802.3as Support for 2K Packets */
#define ETH_MACCR_CST_Pos                             (21U)
#define ETH_MACCR_CST_Msk                             (0x1U << ETH_MACCR_CST_Pos) /*!< 0x00200000 */
#define ETH_MACCR_CST                                 ETH_MACCR_CST_Msk        /* CRC stripping for Type packets */
#define ETH_MACCR_ACS_Pos                             (20U)
#define ETH_MACCR_ACS_Msk                             (0x1U << ETH_MACCR_ACS_Pos) /*!< 0x00100000 */
#define ETH_MACCR_ACS                                 ETH_MACCR_ACS_Msk        /* Automatic Pad or CRC Stripping */
#define ETH_MACCR_WD_Pos                              (19U)
#define ETH_MACCR_WD_Msk                              (0x1U << ETH_MACCR_WD_Pos) /*!< 0x00080000 */
#define ETH_MACCR_WD                                  ETH_MACCR_WD_Msk         /* Watchdog disable */
#define ETH_MACCR_JD_Pos                              (17U)
#define ETH_MACCR_JD_Msk                              (0x1U << ETH_MACCR_JD_Pos) /*!< 0x00020000 */
#define ETH_MACCR_JD                                  ETH_MACCR_JD_Msk         /* Jabber disable */
#define ETH_MACCR_JE_Pos                              (16U)
#define ETH_MACCR_JE_Msk                              (0x1U << ETH_MACCR_JE_Pos) /*!< 0x00010000 */
#define ETH_MACCR_JE                                  ETH_MACCR_JE_Msk         /* Jumbo Packet Enable */
#define ETH_MACCR_PS_Pos                              (15U)
#define ETH_MACCR_PS_Msk                              (0x1U << ETH_MACCR_PS_Pos) /*!< 0x00010000 */
#define ETH_MACCR_PS                                  ETH_MACCR_PS_Msk         /* Port Select */
#define ETH_MACCR_FES_Pos                             (14U)
#define ETH_MACCR_FES_Msk                             (0x1U << ETH_MACCR_FES_Pos) /*!< 0x00004000 */
#define ETH_MACCR_FES                                 ETH_MACCR_FES_Msk        /* Fast ethernet speed */
#define ETH_MACCR_DM_Pos                              (13U)
#define ETH_MACCR_DM_Msk                              (0x1U << ETH_MACCR_DM_Pos) /*!< 0x00002000 */
#define ETH_MACCR_DM                                  ETH_MACCR_DM_Msk         /* Duplex mode */
#define ETH_MACCR_LM_Pos                              (12U)
#define ETH_MACCR_LM_Msk                              (0x1U << ETH_MACCR_LM_Pos) /*!< 0x00001000 */
#define ETH_MACCR_LM                                  ETH_MACCR_LM_Msk         /* loopback mode */
#define ETH_MACCR_ECRSFD_Pos                          (11U)
#define ETH_MACCR_ECRSFD_Msk                          (0x1U << ETH_MACCR_ECRSFD_Pos) /*!< 0x00000800 */
#define ETH_MACCR_ECRSFD                              ETH_MACCR_ECRSFD_Msk     /* Enable Carrier Sense Before Transmission in Full-Duplex Mode */
#define ETH_MACCR_DO_Pos                              (10U)
#define ETH_MACCR_DO_Msk                              (0x1U << ETH_MACCR_DO_Pos) /*!< 0x00000400 */
#define ETH_MACCR_DO                                  ETH_MACCR_DO_Msk         /* Disable Receive own  */
#define ETH_MACCR_DCRS_Pos                            (9U)
#define ETH_MACCR_DCRS_Msk                            (0x1U << ETH_MACCR_DCRS_Pos) /*!< 0x00000200 */
#define ETH_MACCR_DCRS                                ETH_MACCR_DCRS_Msk       /* Disable Carrier Sense During Transmission */
#define ETH_MACCR_DR_Pos                              (8U)
#define ETH_MACCR_DR_Msk                              (0x1U << ETH_MACCR_DR_Pos) /*!< 0x00000100 */
#define ETH_MACCR_DR                                  ETH_MACCR_DR_Msk         /* Disable Retry */
#define ETH_MACCR_BL_Pos                              (5U)
#define ETH_MACCR_BL_Msk                              (0x3U << ETH_MACCR_BL_Pos) /*!< 0x00000060 */
#define ETH_MACCR_BL                                  ETH_MACCR_BL_Msk         /* Back-off limit mask */
#define ETH_MACCR_BL_10                               (0x0U << ETH_MACCR_BL_Pos) /*!< 0x00000000 */
#define ETH_MACCR_BL_8                                (0x1U << ETH_MACCR_BL_Pos) /*!< 0x00000020 */
#define ETH_MACCR_BL_4                                (0x2U << ETH_MACCR_BL_Pos) /*!< 0x00000040 */
#define ETH_MACCR_BL_1                                (0x3U << ETH_MACCR_BL_Pos) /*!< 0x00000060 */
#define ETH_MACCR_DC_Pos                              (4U)
#define ETH_MACCR_DC_Msk                              (0x1U << ETH_MACCR_DC_Pos) /*!< 0x00000010 */
#define ETH_MACCR_DC                                  ETH_MACCR_DC_Msk         /* Defferal check */
#define ETH_MACCR_PRELEN_Pos                          (2U)
#define ETH_MACCR_PRELEN_Msk                          (0x3U << ETH_MACCR_PRELEN_Pos) /*!< 0x0000000C */
#define ETH_MACCR_PRELEN                              ETH_MACCR_PRELEN_Msk     /* Preamble Length for Transmit packets */
#define ETH_MACCR_PRELEN_7                            (0x0U << ETH_MACCR_PRELEN_Pos) /*!< 0x00000000 */
#define ETH_MACCR_PRELEN_5                            (0x1U << ETH_MACCR_PRELEN_Pos) /*!< 0x00000004 */
#define ETH_MACCR_PRELEN_3                            (0x2U << ETH_MACCR_PRELEN_Pos) /*!< 0x00000008 */
#define ETH_MACCR_TE_Pos                              (1U)
#define ETH_MACCR_TE_Msk                              (0x1U << ETH_MACCR_TE_Pos) /*!< 0x00000002 */
#define ETH_MACCR_TE                                  ETH_MACCR_TE_Msk         /* Transmitter enable */
#define ETH_MACCR_RE_Pos                              (0U)
#define ETH_MACCR_RE_Msk                              (0x1U << ETH_MACCR_RE_Pos) /*!< 0x00000001 */
#define ETH_MACCR_RE                                  ETH_MACCR_RE_Msk         /* Receiver enable */

/* Bit definition for Ethernet MAC Extended Configuration Register register */
#define ETH_MACECR_EIPG_Pos                           (25U)
#define ETH_MACECR_EIPG_Msk                           (0x1FU << ETH_MACECR_EIPG_Pos) /*!< 0x3E000000 */
#define ETH_MACECR_EIPG                               ETH_MACECR_EIPG_Msk      /* Extended Inter-Packet Gap */
#define ETH_MACECR_EIPGEN_Pos                         (24U)
#define ETH_MACECR_EIPGEN_Msk                         (0x1U << ETH_MACECR_EIPGEN_Pos) /*!< 0x01000000 */
#define ETH_MACECR_EIPGEN                             ETH_MACECR_EIPGEN_Msk    /* Extended Inter-Packet Gap Enable */
#define ETH_MACECR_USP_Pos                            (18U)
#define ETH_MACECR_USP_Msk                            (0x1U << ETH_MACECR_USP_Pos) /*!< 0x00040000 */
#define ETH_MACECR_USP                                ETH_MACECR_USP_Msk       /* Unicast Slow Protocol Packet Detect */
#define ETH_MACECR_SPEN_Pos                           (17U)
#define ETH_MACECR_SPEN_Msk                           (0x1U << ETH_MACECR_SPEN_Pos) /*!< 0x00020000 */
#define ETH_MACECR_SPEN                               ETH_MACECR_SPEN_Msk      /* Slow Protocol Detection Enable */
#define ETH_MACECR_DCRCC_Pos                          (16U)
#define ETH_MACECR_DCRCC_Msk                          (0x1U << ETH_MACECR_DCRCC_Pos) /*!< 0x00010000 */
#define ETH_MACECR_DCRCC                              ETH_MACECR_DCRCC_Msk     /* Disable CRC Checking for Received Packets */
#define ETH_MACECR_GPSL_Pos                           (0U)
#define ETH_MACECR_GPSL_Msk                           (0x3FFFU << ETH_MACECR_GPSL_Pos) /*!< 0x00003FFF */
#define ETH_MACECR_GPSL                               ETH_MACECR_GPSL_Msk      /* Giant Packet Size Limit */

/* Bit definition for Ethernet MAC Packet Filter Register */
#define ETH_MACPFR_RA_Pos                             (31U)
#define ETH_MACPFR_RA_Msk                             (0x1U << ETH_MACPFR_RA_Pos) /*!< 0x80000000 */
#define ETH_MACPFR_RA                                 ETH_MACPFR_RA_Msk        /* Receive all */
#define ETH_MACPFR_DNTU_Pos                           (21U)
#define ETH_MACPFR_DNTU_Msk                           (0x1U << ETH_MACPFR_DNTU_Pos) /*!< 0x00200000 */
#define ETH_MACPFR_DNTU                               ETH_MACPFR_DNTU_Msk      /* Drop Non-TCP/UDP over IP Packets */
#define ETH_MACPFR_IPFE_Pos                           (20U)
#define ETH_MACPFR_IPFE_Msk                           (0x1U << ETH_MACPFR_IPFE_Pos) /*!< 0x00100000 */
#define ETH_MACPFR_IPFE                               ETH_MACPFR_IPFE_Msk      /* Layer 3 and Layer 4 Filter Enable */
#define ETH_MACPFR_VTFE_Pos                           (16U)
#define ETH_MACPFR_VTFE_Msk                           (0x1U << ETH_MACPFR_VTFE_Pos) /*!< 0x00010000 */
#define ETH_MACPFR_VTFE                               ETH_MACPFR_VTFE_Msk      /* VLAN Tag Filter Enable */
#define ETH_MACPFR_HPF_Pos                            (10U)
#define ETH_MACPFR_HPF_Msk                            (0x1U << ETH_MACPFR_HPF_Pos) /*!< 0x00000400 */
#define ETH_MACPFR_HPF                                ETH_MACPFR_HPF_Msk       /* Hash or perfect filter */
#define ETH_MACPFR_SAF_Pos                            (9U)
#define ETH_MACPFR_SAF_Msk                            (0x1U << ETH_MACPFR_SAF_Pos) /*!< 0x00000200 */
#define ETH_MACPFR_SAF                                ETH_MACPFR_SAF_Msk       /* Source address filter enable */
#define ETH_MACPFR_SAIF_Pos                           (8U)
#define ETH_MACPFR_SAIF_Msk                           (0x1U << ETH_MACPFR_SAIF_Pos) /*!< 0x00000100 */
#define ETH_MACPFR_SAIF                               ETH_MACPFR_SAIF_Msk      /* SA inverse filtering */
#define ETH_MACPFR_PCF_Pos                            (6U)
#define ETH_MACPFR_PCF_Msk                            (0x3U << ETH_MACPFR_PCF_Pos) /*!< 0x000000C0 */
#define ETH_MACPFR_PCF                                ETH_MACPFR_PCF_Msk       /* Pass control frames: 4 cases */
#define ETH_MACPFR_PCF_BLOCKALL                       ((uint32_t)0x00000000)   /* MAC filters all control frames from reaching the application */
#define ETH_MACPFR_PCF_FORWARDALLEXCEPTPA_Pos         (6U)
#define ETH_MACPFR_PCF_FORWARDALLEXCEPTPA_Msk         (0x1U << ETH_MACPFR_PCF_FORWARDALLEXCEPTPA_Pos) /*!< 0x00000040 */
#define ETH_MACPFR_PCF_FORWARDALLEXCEPTPA             ETH_MACPFR_PCF_FORWARDALLEXCEPTPA_Msk /* MAC forwards all control frames except Pause packets to application even if they fail the Address Filter */
#define ETH_MACPFR_PCF_FORWARDALL_Pos                 (7U)
#define ETH_MACPFR_PCF_FORWARDALL_Msk                 (0x1U << ETH_MACPFR_PCF_FORWARDALL_Pos) /*!< 0x00000080 */
#define ETH_MACPFR_PCF_FORWARDALL                     ETH_MACPFR_PCF_FORWARDALL_Msk /* MAC forwards all control frames to application even if they fail the Address Filter */
#define ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER_Pos    (6U)
#define ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER_Msk    (0x3U << ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER_Pos) /*!< 0x000000C0 */
#define ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER        ETH_MACPFR_PCF_FORWARDPASSEDADDRFILTER_Msk /* MAC forwards control frames that pass the Address Filter. */
#define ETH_MACPFR_DBF_Pos                            (5U)
#define ETH_MACPFR_DBF_Msk                            (0x1U << ETH_MACPFR_DBF_Pos) /*!< 0x00000020 */
#define ETH_MACPFR_DBF                                ETH_MACPFR_DBF_Msk       /* Disable Broadcast Packets */
#define ETH_MACPFR_PM_Pos                             (4U)
#define ETH_MACPFR_PM_Msk                             (0x1U << ETH_MACPFR_PM_Pos) /*!< 0x00000010 */
#define ETH_MACPFR_PM                                 ETH_MACPFR_PM_Msk        /* Pass all mutlicast */
#define ETH_MACPFR_DAIF_Pos                           (3U)
#define ETH_MACPFR_DAIF_Msk                           (0x1U << ETH_MACPFR_DAIF_Pos) /*!< 0x00000008 */
#define ETH_MACPFR_DAIF                               ETH_MACPFR_DAIF_Msk      /* DA Inverse filtering */
#define ETH_MACPFR_HMC_Pos                            (2U)
#define ETH_MACPFR_HMC_Msk                            (0x1U << ETH_MACPFR_HMC_Pos) /*!< 0x00000004 */
#define ETH_MACPFR_HMC                                ETH_MACPFR_HMC_Msk       /* Hash multicast */
#define ETH_MACPFR_HUC_Pos                            (1U)
#define ETH_MACPFR_HUC_Msk                            (0x1U << ETH_MACPFR_HUC_Pos) /*!< 0x00000002 */
#define ETH_MACPFR_HUC                                ETH_MACPFR_HUC_Msk       /* Hash unicast */
#define ETH_MACPFR_PR_Pos                             (0U)
#define ETH_MACPFR_PR_Msk                             (0x1U << ETH_MACPFR_PR_Pos) /*!< 0x00000001 */
#define ETH_MACPFR_PR                                 ETH_MACPFR_PR_Msk        /* Promiscuous mode */

/* Bit definition for Ethernet MAC Watchdog Timeout Register */
#define ETH_MACWTR_PWE_Pos                            (8U)
#define ETH_MACWTR_PWE_Msk                            (0x1U << ETH_MACWTR_PWE_Pos) /*!< 0x00000100 */
#define ETH_MACWTR_PWE                                ETH_MACWTR_PWE_Msk       /* Programmable Watchdog Enable */
#define ETH_MACWTR_WTO_Pos                            (0U)
#define ETH_MACWTR_WTO_Msk                            (0xFU << ETH_MACWTR_WTO_Pos) /*!< 0x0000000F */
#define ETH_MACWTR_WTO                                ETH_MACWTR_WTO_Msk       /* Watchdog Timeout */
#define ETH_MACWTR_WTO_2KB                            ((uint32_t)0x00000000)   /* Maximum received packet length 2KB*/
#define ETH_MACWTR_WTO_3KB                            ((uint32_t)0x00000001)   /* Maximum received packet length 3KB */
#define ETH_MACWTR_WTO_4KB                            ((uint32_t)0x00000002)   /* Maximum received packet length 4KB */
#define ETH_MACWTR_WTO_5KB                            ((uint32_t)0x00000003)   /* Maximum received packet length 5KB */
#define ETH_MACWTR_WTO_6KB                            ((uint32_t)0x00000004)   /* Maximum received packet length 6KB */
#define ETH_MACWTR_WTO_7KB                            ((uint32_t)0x00000005)   /* Maximum received packet length 7KB */
#define ETH_MACWTR_WTO_8KB                            ((uint32_t)0x00000006)   /* Maximum received packet length 8KB */
#define ETH_MACWTR_WTO_9KB                            ((uint32_t)0x00000007)   /* Maximum received packet length 9KB */
#define ETH_MACWTR_WTO_10KB                           ((uint32_t)0x00000008)   /* Maximum received packet length 10KB */
#define ETH_MACWTR_WTO_11KB                           ((uint32_t)0x00000009)   /* Maximum received packet length 11KB */
#define ETH_MACWTR_WTO_12KB                           ((uint32_t)0x0000000A)   /* Maximum received packet length 12KB */
#define ETH_MACWTR_WTO_13KB                           ((uint32_t)0x0000000B)   /* Maximum received packet length 13KB */
#define ETH_MACWTR_WTO_14KB                           ((uint32_t)0x0000000C)   /* Maximum received packet length 14KB */
#define ETH_MACWTR_WTO_15KB                           ((uint32_t)0x0000000D)   /* Maximum received packet length 15KB */
#define ETH_MACWTR_WTO_16KB                           ((uint32_t)0x0000000E)   /* Maximum received packet length 16KB */

/* Bit definition for Ethernet MAC Hash Table High Register */
#define ETH_MACHTHR_HTH_Pos                           (0U)
#define ETH_MACHTHR_HTH_Msk                           (0xFFFFFFFFU << ETH_MACHTHR_HTH_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACHTHR_HTH                               ETH_MACHTHR_HTH_Msk      /* Hash table high */

/* Bit definition for Ethernet MAC Hash Table Low Register */
#define ETH_MACHTLR_HTL_Pos                           (0U)
#define ETH_MACHTLR_HTL_Msk                           (0xFFFFFFFFU << ETH_MACHTLR_HTL_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACHTLR_HTL                               ETH_MACHTLR_HTL_Msk      /* Hash table low */

/* Bit definition for Ethernet MAC VLAN Tag Register */
#define ETH_MACVTR_EIVLRXS_Pos                        (31U)
#define ETH_MACVTR_EIVLRXS_Msk                        (0x1U << ETH_MACVTR_EIVLRXS_Pos) /*!< 0x80000000 */
#define ETH_MACVTR_EIVLRXS                            ETH_MACVTR_EIVLRXS_Msk   /* Enable Inner VLAN Tag in Rx Status */
#define ETH_MACVTR_EIVLS_Pos                          (28U)
#define ETH_MACVTR_EIVLS_Msk                          (0x3U << ETH_MACVTR_EIVLS_Pos) /*!< 0x30000000 */
#define ETH_MACVTR_EIVLS                              ETH_MACVTR_EIVLS_Msk     /* Enable Inner VLAN Tag Stripping on Receive */
#define ETH_MACVTR_EIVLS_DONOTSTRIP                   ((uint32_t)0x00000000)   /* Do not strip */
#define ETH_MACVTR_EIVLS_STRIPIFPASS_Pos              (28U)
#define ETH_MACVTR_EIVLS_STRIPIFPASS_Msk              (0x1U << ETH_MACVTR_EIVLS_STRIPIFPASS_Pos) /*!< 0x10000000 */
#define ETH_MACVTR_EIVLS_STRIPIFPASS                  ETH_MACVTR_EIVLS_STRIPIFPASS_Msk /* Strip if VLAN filter passes */
#define ETH_MACVTR_EIVLS_STRIPIFFAILS_Pos             (29U)
#define ETH_MACVTR_EIVLS_STRIPIFFAILS_Msk             (0x1U << ETH_MACVTR_EIVLS_STRIPIFFAILS_Pos) /*!< 0x20000000 */
#define ETH_MACVTR_EIVLS_STRIPIFFAILS                 ETH_MACVTR_EIVLS_STRIPIFFAILS_Msk /* Strip if VLAN filter fails */
#define ETH_MACVTR_EIVLS_ALWAYSSTRIP_Pos              (28U)
#define ETH_MACVTR_EIVLS_ALWAYSSTRIP_Msk              (0x3U << ETH_MACVTR_EIVLS_ALWAYSSTRIP_Pos) /*!< 0x30000000 */
#define ETH_MACVTR_EIVLS_ALWAYSSTRIP                  ETH_MACVTR_EIVLS_ALWAYSSTRIP_Msk /* Always strip */
#define ETH_MACVTR_ERIVLT_Pos                         (27U)
#define ETH_MACVTR_ERIVLT_Msk                         (0x1U << ETH_MACVTR_ERIVLT_Pos) /*!< 0x08000000 */
#define ETH_MACVTR_ERIVLT                             ETH_MACVTR_ERIVLT_Msk    /* Enable Inner VLAN Tag */
#define ETH_MACVTR_EDVLP_Pos                          (26U)
#define ETH_MACVTR_EDVLP_Msk                          (0x1U << ETH_MACVTR_EDVLP_Pos) /*!< 0x04000000 */
#define ETH_MACVTR_EDVLP                              ETH_MACVTR_EDVLP_Msk     /* Enable Double VLAN Processing */
#define ETH_MACVTR_VTHM_Pos                           (25U)
#define ETH_MACVTR_VTHM_Msk                           (0x1U << ETH_MACVTR_VTHM_Pos) /*!< 0x02000000 */
#define ETH_MACVTR_VTHM                               ETH_MACVTR_VTHM_Msk      /* VLAN Tag Hash Table Match Enable */
#define ETH_MACVTR_EVLRXS_Pos                         (24U)
#define ETH_MACVTR_EVLRXS_Msk                         (0x1U << ETH_MACVTR_EVLRXS_Pos) /*!< 0x01000000 */
#define ETH_MACVTR_EVLRXS                             ETH_MACVTR_EVLRXS_Msk    /* Enable VLAN Tag in Rx status */
#define ETH_MACVTR_EVLS_Pos                           (21U)
#define ETH_MACVTR_EVLS_Msk                           (0x3U << ETH_MACVTR_EVLS_Pos) /*!< 0x00600000 */
#define ETH_MACVTR_EVLS                               ETH_MACVTR_EVLS_Msk      /* Enable VLAN Tag Stripping on Receive */
#define ETH_MACVTR_EVLS_DONOTSTRIP                    ((uint32_t)0x00000000)   /* Do not strip */
#define ETH_MACVTR_EVLS_STRIPIFPASS_Pos               (21U)
#define ETH_MACVTR_EVLS_STRIPIFPASS_Msk               (0x1U << ETH_MACVTR_EVLS_STRIPIFPASS_Pos) /*!< 0x00200000 */
#define ETH_MACVTR_EVLS_STRIPIFPASS                   ETH_MACVTR_EVLS_STRIPIFPASS_Msk /* Strip if VLAN filter passes */
#define ETH_MACVTR_EVLS_STRIPIFFAILS_Pos              (22U)
#define ETH_MACVTR_EVLS_STRIPIFFAILS_Msk              (0x1U << ETH_MACVTR_EVLS_STRIPIFFAILS_Pos) /*!< 0x00400000 */
#define ETH_MACVTR_EVLS_STRIPIFFAILS                  ETH_MACVTR_EVLS_STRIPIFFAILS_Msk /* Strip if VLAN filter fails */
#define ETH_MACVTR_EVLS_ALWAYSSTRIP_Pos               (21U)
#define ETH_MACVTR_EVLS_ALWAYSSTRIP_Msk               (0x3U << ETH_MACVTR_EVLS_ALWAYSSTRIP_Pos) /*!< 0x00600000 */
#define ETH_MACVTR_EVLS_ALWAYSSTRIP                   ETH_MACVTR_EVLS_ALWAYSSTRIP_Msk /* Always strip */
#define ETH_MACVTR_DOVLTC_Pos                         (20U)
#define ETH_MACVTR_DOVLTC_Msk                         (0x1U << ETH_MACVTR_DOVLTC_Pos) /*!< 0x00100000 */
#define ETH_MACVTR_DOVLTC                             ETH_MACVTR_DOVLTC_Msk    /* Disable VLAN Type Check */
#define ETH_MACVTR_ERSVLM_Pos                         (19U)
#define ETH_MACVTR_ERSVLM_Msk                         (0x1U << ETH_MACVTR_ERSVLM_Pos) /*!< 0x00080000 */
#define ETH_MACVTR_ERSVLM                             ETH_MACVTR_ERSVLM_Msk    /* Enable Receive S-VLAN Match */
#define ETH_MACVTR_ESVL_Pos                           (18U)
#define ETH_MACVTR_ESVL_Msk                           (0x1U << ETH_MACVTR_ESVL_Pos) /*!< 0x00040000 */
#define ETH_MACVTR_ESVL                               ETH_MACVTR_ESVL_Msk      /* Enable S-VLAN */
#define ETH_MACVTR_VTIM_Pos                           (17U)
#define ETH_MACVTR_VTIM_Msk                           (0x1U << ETH_MACVTR_VTIM_Pos) /*!< 0x00020000 */
#define ETH_MACVTR_VTIM                               ETH_MACVTR_VTIM_Msk      /* VLAN Tag Inverse Match Enable */
#define ETH_MACVTR_ETV_Pos                            (16U)
#define ETH_MACVTR_ETV_Msk                            (0x1U << ETH_MACVTR_ETV_Pos) /*!< 0x00010000 */
#define ETH_MACVTR_ETV                                ETH_MACVTR_ETV_Msk       /* Enable 12-Bit VLAN Tag Comparison */
#define ETH_MACVTR_VL_Pos                             (0U)
#define ETH_MACVTR_VL_Msk                             (0xFFFFU << ETH_MACVTR_VL_Pos) /*!< 0x0000FFFF */
#define ETH_MACVTR_VL                                 ETH_MACVTR_VL_Msk        /* VLAN Tag Identifier for Receive Packets */
#define ETH_MACVTR_VL_UP_Pos                          (13U)
#define ETH_MACVTR_VL_UP_Msk                          (0x7U << ETH_MACVTR_VL_UP_Pos) /*!< 0x0000E000 */
#define ETH_MACVTR_VL_UP                              ETH_MACVTR_VL_UP_Msk     /* User Priority */
#define ETH_MACVTR_VL_CFIDEI_Pos                      (12U)
#define ETH_MACVTR_VL_CFIDEI_Msk                      (0x1U << ETH_MACVTR_VL_CFIDEI_Pos) /*!< 0x00001000 */
#define ETH_MACVTR_VL_CFIDEI                          ETH_MACVTR_VL_CFIDEI_Msk /* Canonical Format Indicator or Drop Eligible Indicator */
#define ETH_MACVTR_VL_VID_Pos                         (0U)
#define ETH_MACVTR_VL_VID_Msk                         (0xFFFU << ETH_MACVTR_VL_VID_Pos) /*!< 0x00000FFF */
#define ETH_MACVTR_VL_VID                             ETH_MACVTR_VL_VID_Msk    /* VLAN Identifier field of VLAN tag */

/* Bit definition for Ethernet MAC VLAN Hash Table Register */
#define ETH_MACVHTR_VLHT_Pos                          (0U)
#define ETH_MACVHTR_VLHT_Msk                          (0xFFFFU << ETH_MACVHTR_VLHT_Pos) /*!< 0x0000FFFF */
#define ETH_MACVHTR_VLHT                              ETH_MACVHTR_VLHT_Msk     /* VLAN Hash Table */

/* Bit definition for Ethernet MAC VLAN Incl Register */
#define ETH_MACVIR_VLTI_Pos                           (20U)
#define ETH_MACVIR_VLTI_Msk                           (0x1U << ETH_MACVIR_VLTI_Pos) /*!< 0x00100000 */
#define ETH_MACVIR_VLTI                               ETH_MACVIR_VLTI_Msk      /* VLAN Tag Input */
#define ETH_MACVIR_CSVL_Pos                           (19U)
#define ETH_MACVIR_CSVL_Msk                           (0x1U << ETH_MACVIR_CSVL_Pos) /*!< 0x00080000 */
#define ETH_MACVIR_CSVL                               ETH_MACVIR_CSVL_Msk      /* C-VLAN or S-VLAN */
#define ETH_MACVIR_VLP_Pos                            (18U)
#define ETH_MACVIR_VLP_Msk                            (0x1U << ETH_MACVIR_VLP_Pos) /*!< 0x00040000 */
#define ETH_MACVIR_VLP                                ETH_MACVIR_VLP_Msk       /* VLAN Priority Control */
#define ETH_MACVIR_VLC_Pos                            (16U)
#define ETH_MACVIR_VLC_Msk                            (0x3U << ETH_MACVIR_VLC_Pos) /*!< 0x00030000 */
#define ETH_MACVIR_VLC                                ETH_MACVIR_VLC_Msk       /* VLAN Tag Control in Transmit Packets */
#define ETH_MACVIR_VLC_NOVLANTAG                      ((uint32_t)0x00000000)   /* No VLAN tag deletion, insertion, or replacement */
#define ETH_MACVIR_VLC_VLANTAGDELETE_Pos              (16U)
#define ETH_MACVIR_VLC_VLANTAGDELETE_Msk              (0x1U << ETH_MACVIR_VLC_VLANTAGDELETE_Pos) /*!< 0x00010000 */
#define ETH_MACVIR_VLC_VLANTAGDELETE                  ETH_MACVIR_VLC_VLANTAGDELETE_Msk /* VLAN tag deletion */
#define ETH_MACVIR_VLC_VLANTAGINSERT_Pos              (17U)
#define ETH_MACVIR_VLC_VLANTAGINSERT_Msk              (0x1U << ETH_MACVIR_VLC_VLANTAGINSERT_Pos) /*!< 0x00020000 */
#define ETH_MACVIR_VLC_VLANTAGINSERT                  ETH_MACVIR_VLC_VLANTAGINSERT_Msk /* VLAN tag insertion */
#define ETH_MACVIR_VLC_VLANTAGREPLACE_Pos             (16U)
#define ETH_MACVIR_VLC_VLANTAGREPLACE_Msk             (0x3U << ETH_MACVIR_VLC_VLANTAGREPLACE_Pos) /*!< 0x00030000 */
#define ETH_MACVIR_VLC_VLANTAGREPLACE                 ETH_MACVIR_VLC_VLANTAGREPLACE_Msk /* VLAN tag replacement */
#define ETH_MACVIR_VLT_Pos                            (0U)
#define ETH_MACVIR_VLT_Msk                            (0xFFFFU << ETH_MACVIR_VLT_Pos) /*!< 0x0000FFFF */
#define ETH_MACVIR_VLT                                ETH_MACVIR_VLT_Msk       /* VLAN Tag for Transmit Packets */
#define ETH_MACVIR_VLT_UP_Pos                         (13U)
#define ETH_MACVIR_VLT_UP_Msk                         (0x7U << ETH_MACVIR_VLT_UP_Pos) /*!< 0x0000E000 */
#define ETH_MACVIR_VLT_UP                             ETH_MACVIR_VLT_UP_Msk    /* User Priority */
#define ETH_MACVIR_VLT_CFIDEI_Pos                     (12U)
#define ETH_MACVIR_VLT_CFIDEI_Msk                     (0x1U << ETH_MACVIR_VLT_CFIDEI_Pos) /*!< 0x00001000 */
#define ETH_MACVIR_VLT_CFIDEI                         ETH_MACVIR_VLT_CFIDEI_Msk /* Canonical Format Indicator or Drop Eligible Indicator */
#define ETH_MACVIR_VLT_VID_Pos                        (0U)
#define ETH_MACVIR_VLT_VID_Msk                        (0xFFFU << ETH_MACVIR_VLT_VID_Pos) /*!< 0x00000FFF */
#define ETH_MACVIR_VLT_VID                            ETH_MACVIR_VLT_VID_Msk   /* VLAN Identifier field of VLAN tag */

/* Bit definition for Ethernet MAC Inner_VLAN Incl Register */
#define ETH_MACIVIR_VLTI_Pos                          (20U)
#define ETH_MACIVIR_VLTI_Msk                          (0x1U << ETH_MACIVIR_VLTI_Pos) /*!< 0x00100000 */
#define ETH_MACIVIR_VLTI                              ETH_MACIVIR_VLTI_Msk     /* VLAN Tag Input */
#define ETH_MACIVIR_CSVL_Pos                          (19U)
#define ETH_MACIVIR_CSVL_Msk                          (0x1U << ETH_MACIVIR_CSVL_Pos) /*!< 0x00080000 */
#define ETH_MACIVIR_CSVL                              ETH_MACIVIR_CSVL_Msk     /* C-VLAN or S-VLAN */
#define ETH_MACIVIR_VLP_Pos                           (18U)
#define ETH_MACIVIR_VLP_Msk                           (0x1U << ETH_MACIVIR_VLP_Pos) /*!< 0x00040000 */
#define ETH_MACIVIR_VLP                               ETH_MACIVIR_VLP_Msk      /* VLAN Priority Control */
#define ETH_MACIVIR_VLC_Pos                           (16U)
#define ETH_MACIVIR_VLC_Msk                           (0x3U << ETH_MACIVIR_VLC_Pos) /*!< 0x00030000 */
#define ETH_MACIVIR_VLC                               ETH_MACIVIR_VLC_Msk      /* VLAN Tag Control in Transmit Packets */
#define ETH_MACIVIR_VLC_NOVLANTAG                     ((uint32_t)0x00000000)   /* No VLAN tag deletion, insertion, or replacement */
#define ETH_MACIVIR_VLC_VLANTAGDELETE_Pos             (16U)
#define ETH_MACIVIR_VLC_VLANTAGDELETE_Msk             (0x1U << ETH_MACIVIR_VLC_VLANTAGDELETE_Pos) /*!< 0x00010000 */
#define ETH_MACIVIR_VLC_VLANTAGDELETE                 ETH_MACIVIR_VLC_VLANTAGDELETE_Msk /* VLAN tag deletion */
#define ETH_MACIVIR_VLC_VLANTAGINSERT_Pos             (17U)
#define ETH_MACIVIR_VLC_VLANTAGINSERT_Msk             (0x1U << ETH_MACIVIR_VLC_VLANTAGINSERT_Pos) /*!< 0x00020000 */
#define ETH_MACIVIR_VLC_VLANTAGINSERT                 ETH_MACIVIR_VLC_VLANTAGINSERT_Msk /* VLAN tag insertion */
#define ETH_MACIVIR_VLC_VLANTAGREPLACE_Pos            (16U)
#define ETH_MACIVIR_VLC_VLANTAGREPLACE_Msk            (0x3U << ETH_MACIVIR_VLC_VLANTAGREPLACE_Pos) /*!< 0x00030000 */
#define ETH_MACIVIR_VLC_VLANTAGREPLACE                ETH_MACIVIR_VLC_VLANTAGREPLACE_Msk /* VLAN tag replacement */
#define ETH_MACIVIR_VLT_Pos                           (0U)
#define ETH_MACIVIR_VLT_Msk                           (0xFFFFU << ETH_MACIVIR_VLT_Pos) /*!< 0x0000FFFF */
#define ETH_MACIVIR_VLT                               ETH_MACIVIR_VLT_Msk      /* VLAN Tag for Transmit Packets */
#define ETH_MACIVIR_VLT_UP_Pos                        (13U)
#define ETH_MACIVIR_VLT_UP_Msk                        (0x7U << ETH_MACIVIR_VLT_UP_Pos) /*!< 0x0000E000 */
#define ETH_MACIVIR_VLT_UP                            ETH_MACIVIR_VLT_UP_Msk   /* User Priority */
#define ETH_MACIVIR_VLT_CFIDEI_Pos                    (12U)
#define ETH_MACIVIR_VLT_CFIDEI_Msk                    (0x1U << ETH_MACIVIR_VLT_CFIDEI_Pos) /*!< 0x00001000 */
#define ETH_MACIVIR_VLT_CFIDEI                        ETH_MACIVIR_VLT_CFIDEI_Msk /* Canonical Format Indicator or Drop Eligible Indicator */
#define ETH_MACIVIR_VLT_VID_Pos                       (0U)
#define ETH_MACIVIR_VLT_VID_Msk                       (0xFFFU << ETH_MACIVIR_VLT_VID_Pos) /*!< 0x00000FFF */
#define ETH_MACIVIR_VLT_VID                           ETH_MACIVIR_VLT_VID_Msk  /* VLAN Identifier field of VLAN tag */

/* Bit definition for Ethernet MAC Tx Flow Ctrl Register */
#define ETH_MACTFCR_PT_Pos                            (16U)
#define ETH_MACTFCR_PT_Msk                            (0xFFFFU << ETH_MACTFCR_PT_Pos) /*!< 0xFFFF0000 */
#define ETH_MACTFCR_PT                                ETH_MACTFCR_PT_Msk       /* Pause Time */
#define ETH_MACTFCR_DZPQ_Pos                          (7U)
#define ETH_MACTFCR_DZPQ_Msk                          (0x1U << ETH_MACTFCR_DZPQ_Pos) /*!< 0x00000080 */
#define ETH_MACTFCR_DZPQ                              ETH_MACTFCR_DZPQ_Msk     /* Disable Zero-Quanta Pause */
#define ETH_MACTFCR_PLT_Pos                           (4U)
#define ETH_MACTFCR_PLT_Msk                           (0x7U << ETH_MACTFCR_PLT_Pos) /*!< 0x00000070 */
#define ETH_MACTFCR_PLT                               ETH_MACTFCR_PLT_Msk      /* Pause Low Threshold */
#define ETH_MACTFCR_PLT_MINUS4                        ((uint32_t)0x00000000)   /* Pause time minus 4 slot times */
#define ETH_MACTFCR_PLT_MINUS28_Pos                   (4U)
#define ETH_MACTFCR_PLT_MINUS28_Msk                   (0x1U << ETH_MACTFCR_PLT_MINUS28_Pos) /*!< 0x00000010 */
#define ETH_MACTFCR_PLT_MINUS28                       ETH_MACTFCR_PLT_MINUS28_Msk /* Pause time minus 28 slot times */
#define ETH_MACTFCR_PLT_MINUS36_Pos                   (5U)
#define ETH_MACTFCR_PLT_MINUS36_Msk                   (0x1U << ETH_MACTFCR_PLT_MINUS36_Pos) /*!< 0x00000020 */
#define ETH_MACTFCR_PLT_MINUS36                       ETH_MACTFCR_PLT_MINUS36_Msk /* Pause time minus 36 slot times */
#define ETH_MACTFCR_PLT_MINUS144_Pos                  (4U)
#define ETH_MACTFCR_PLT_MINUS144_Msk                  (0x3U << ETH_MACTFCR_PLT_MINUS144_Pos) /*!< 0x00000030 */
#define ETH_MACTFCR_PLT_MINUS144                      ETH_MACTFCR_PLT_MINUS144_Msk /* Pause time minus 144 slot times */
#define ETH_MACTFCR_PLT_MINUS256_Pos                  (6U)
#define ETH_MACTFCR_PLT_MINUS256_Msk                  (0x1U << ETH_MACTFCR_PLT_MINUS256_Pos) /*!< 0x00000040 */
#define ETH_MACTFCR_PLT_MINUS256                      ETH_MACTFCR_PLT_MINUS256_Msk /* Pause time minus 256 slot times */
#define ETH_MACTFCR_PLT_MINUS512_Pos                  (4U)
#define ETH_MACTFCR_PLT_MINUS512_Msk                  (0x5U << ETH_MACTFCR_PLT_MINUS512_Pos) /*!< 0x00000050 */
#define ETH_MACTFCR_PLT_MINUS512                      ETH_MACTFCR_PLT_MINUS512_Msk /* Pause time minus 512 slot times */
#define ETH_MACTFCR_TFE_Pos                           (1U)
#define ETH_MACTFCR_TFE_Msk                           (0x1U << ETH_MACTFCR_TFE_Pos) /*!< 0x00000002 */
#define ETH_MACTFCR_TFE                               ETH_MACTFCR_TFE_Msk      /* Transmit Flow Control Enable */
#define ETH_MACTFCR_FCB_Pos                           (0U)
#define ETH_MACTFCR_FCB_Msk                           (0x1U << ETH_MACTFCR_FCB_Pos) /*!< 0x00000001 */
#define ETH_MACTFCR_FCB                               ETH_MACTFCR_FCB_Msk      /* Flow Control Busy or Backpressure Activate */

/* Bit definition for Ethernet MAC Rx Flow Ctrl Register */
#define ETH_MACRFCR_UP_Pos                            (1U)
#define ETH_MACRFCR_UP_Msk                            (0x1U << ETH_MACRFCR_UP_Pos) /*!< 0x00000002 */
#define ETH_MACRFCR_UP                                ETH_MACRFCR_UP_Msk       /* Unicast Pause Packet Detect */
#define ETH_MACRFCR_RFE_Pos                           (0U)
#define ETH_MACRFCR_RFE_Msk                           (0x1U << ETH_MACRFCR_RFE_Pos) /*!< 0x00000001 */
#define ETH_MACRFCR_RFE                               ETH_MACRFCR_RFE_Msk      /* Receive Flow Control Enable */

/* Bit definition for Ethernet MAC Interrupt Status Register */
#define ETH_MACISR_RXSTSIS_Pos                        (14U)
#define ETH_MACISR_RXSTSIS_Msk                        (0x1U << ETH_MACISR_RXSTSIS_Pos) /*!< 0x00004000 */
#define ETH_MACISR_RXSTSIS                            ETH_MACISR_RXSTSIS_Msk   /* Receive Status Interrupt */
#define ETH_MACISR_TXSTSIS_Pos                        (13U)
#define ETH_MACISR_TXSTSIS_Msk                        (0x1U << ETH_MACISR_TXSTSIS_Pos) /*!< 0x00002000 */
#define ETH_MACISR_TXSTSIS                            ETH_MACISR_TXSTSIS_Msk   /* Transmit Status Interrupt */
#define ETH_MACISR_TSIS_Pos                           (12U)
#define ETH_MACISR_TSIS_Msk                           (0x1U << ETH_MACISR_TSIS_Pos) /*!< 0x00001000 */
#define ETH_MACISR_TSIS                               ETH_MACISR_TSIS_Msk      /* Timestamp Interrupt Status */
#define ETH_MACISR_MMCTXIS_Pos                        (10U)
#define ETH_MACISR_MMCTXIS_Msk                        (0x1U << ETH_MACISR_MMCTXIS_Pos) /*!< 0x00000400 */
#define ETH_MACISR_MMCTXIS                            ETH_MACISR_MMCTXIS_Msk   /* MMC Transmit Interrupt Status */
#define ETH_MACISR_MMCRXIS_Pos                        (9U)
#define ETH_MACISR_MMCRXIS_Msk                        (0x1U << ETH_MACISR_MMCRXIS_Pos) /*!< 0x00000200 */
#define ETH_MACISR_MMCRXIS                            ETH_MACISR_MMCRXIS_Msk   /* MMC Receive Interrupt Status */
#define ETH_MACISR_MMCIS_Pos                          (8U)
#define ETH_MACISR_MMCIS_Msk                          (0x1U << ETH_MACISR_MMCIS_Pos) /*!< 0x00000100 */
#define ETH_MACISR_MMCIS                              ETH_MACISR_MMCIS_Msk     /* MMC Interrupt Status */
#define ETH_MACISR_LPIIS_Pos                          (5U)
#define ETH_MACISR_LPIIS_Msk                          (0x1U << ETH_MACISR_LPIIS_Pos) /*!< 0x00000020 */
#define ETH_MACISR_LPIIS                              ETH_MACISR_LPIIS_Msk     /* LPI Interrupt Status */
#define ETH_MACISR_PMTIS_Pos                          (4U)
#define ETH_MACISR_PMTIS_Msk                          (0x1U << ETH_MACISR_PMTIS_Pos) /*!< 0x00000010 */
#define ETH_MACISR_PMTIS                              ETH_MACISR_PMTIS_Msk     /* PMT Interrupt Status */
#define ETH_MACISR_PHYIS_Pos                          (3U)
#define ETH_MACISR_PHYIS_Msk                          (0x1U << ETH_MACISR_PHYIS_Pos) /*!< 0x00000008 */
#define ETH_MACISR_PHYIS                              ETH_MACISR_PHYIS_Msk     /* PHY Interrupt */

/* Bit definition for Ethernet MAC Interrupt Enable Register */
#define ETH_MACIER_RXSTSIE_Pos                        (14U)
#define ETH_MACIER_RXSTSIE_Msk                        (0x1U << ETH_MACIER_RXSTSIE_Pos) /*!< 0x00004000 */
#define ETH_MACIER_RXSTSIE                            ETH_MACIER_RXSTSIE_Msk   /* Receive Status Interrupt Enable */
#define ETH_MACIER_TXSTSIE_Pos                        (13U)
#define ETH_MACIER_TXSTSIE_Msk                        (0x1U << ETH_MACIER_TXSTSIE_Pos) /*!< 0x00002000 */
#define ETH_MACIER_TXSTSIE                            ETH_MACIER_TXSTSIE_Msk   /* Transmit Status Interrupt Enable */
#define ETH_MACIER_TSIE_Pos                           (12U)
#define ETH_MACIER_TSIE_Msk                           (0x1U << ETH_MACIER_TSIE_Pos) /*!< 0x00001000 */
#define ETH_MACIER_TSIE                               ETH_MACIER_TSIE_Msk      /* Timestamp Interrupt Enable */
#define ETH_MACIER_LPIIE_Pos                          (5U)
#define ETH_MACIER_LPIIE_Msk                          (0x1U << ETH_MACIER_LPIIE_Pos) /*!< 0x00000020 */
#define ETH_MACIER_LPIIE                              ETH_MACIER_LPIIE_Msk     /* LPI Interrupt Enable */
#define ETH_MACIER_PMTIE_Pos                          (4U)
#define ETH_MACIER_PMTIE_Msk                          (0x1U << ETH_MACIER_PMTIE_Pos) /*!< 0x00000010 */
#define ETH_MACIER_PMTIE                              ETH_MACIER_PMTIE_Msk     /* PMT Interrupt Enable */
#define ETH_MACIER_PHYIE_Pos                          (3U)
#define ETH_MACIER_PHYIE_Msk                          (0x1U << ETH_MACIER_PHYIE_Pos) /*!< 0x00000008 */
#define ETH_MACIER_PHYIE                              ETH_MACIER_PHYIE_Msk     /* PHY Interrupt Enable */

/* Bit definition for Ethernet MAC Rx Tx Status Register */
#define ETH_MACRTSR_RWT_Pos                           (8U)
#define ETH_MACRTSR_RWT_Msk                           (0x1U << ETH_MACRTSR_RWT_Pos) /*!< 0x00000100 */
#define ETH_MACRTSR_RWT                               ETH_MACRTSR_RWT_Msk      /* Receive Watchdog Timeout */
#define ETH_MACRTSR_EXCOL_Pos                         (5U)
#define ETH_MACRTSR_EXCOL_Msk                         (0x1U << ETH_MACRTSR_EXCOL_Pos) /*!< 0x00000020 */
#define ETH_MACRTSR_EXCOL                             ETH_MACRTSR_EXCOL_Msk    /* Excessive Collisions */
#define ETH_MACRTSR_LCOL_Pos                          (4U)
#define ETH_MACRTSR_LCOL_Msk                          (0x1U << ETH_MACRTSR_LCOL_Pos) /*!< 0x00000010 */
#define ETH_MACRTSR_LCOL                              ETH_MACRTSR_LCOL_Msk     /* Late Collision */
#define ETH_MACRTSR_EXDEF_Pos                         (3U)
#define ETH_MACRTSR_EXDEF_Msk                         (0x1U << ETH_MACRTSR_EXDEF_Pos) /*!< 0x00000008 */
#define ETH_MACRTSR_EXDEF                             ETH_MACRTSR_EXDEF_Msk    /* Excessive Deferral */
#define ETH_MACRTSR_LCARR_Pos                         (2U)
#define ETH_MACRTSR_LCARR_Msk                         (0x1U << ETH_MACRTSR_LCARR_Pos) /*!< 0x00000004 */
#define ETH_MACRTSR_LCARR                             ETH_MACRTSR_LCARR_Msk    /* Loss of Carrier */
#define ETH_MACRTSR_NCARR_Pos                         (1U)
#define ETH_MACRTSR_NCARR_Msk                         (0x1U << ETH_MACRTSR_NCARR_Pos) /*!< 0x00000002 */
#define ETH_MACRTSR_NCARR                             ETH_MACRTSR_NCARR_Msk    /* No Carrier */
#define ETH_MACRTSR_TJT_Pos                           (0U)
#define ETH_MACRTSR_TJT_Msk                           (0x1U << ETH_MACRTSR_TJT_Pos) /*!< 0x00000001 */
#define ETH_MACRTSR_TJT                               ETH_MACRTSR_TJT_Msk      /* Transmit Jabber Timeout */

/* Bit definition for Ethernet MAC PMT Control Status Register */
#define ETH_MACPCSR_RWKFILTRST_Pos                    (31U)
#define ETH_MACPCSR_RWKFILTRST_Msk                    (0x1U << ETH_MACPCSR_RWKFILTRST_Pos) /*!< 0x80000000 */
#define ETH_MACPCSR_RWKFILTRST                        ETH_MACPCSR_RWKFILTRST_Msk /* Remote Wake-Up Packet Filter Register Pointer Reset */
#define ETH_MACPCSR_RWKPTR_Pos                        (24U)
#define ETH_MACPCSR_RWKPTR_Msk                        (0x1FU << ETH_MACPCSR_RWKPTR_Pos) /*!< 0x1F000000 */
#define ETH_MACPCSR_RWKPTR                            ETH_MACPCSR_RWKPTR_Msk   /* Remote Wake-up FIFO Pointer */
#define ETH_MACPCSR_RWKPFE_Pos                        (10U)
#define ETH_MACPCSR_RWKPFE_Msk                        (0x1U << ETH_MACPCSR_RWKPFE_Pos) /*!< 0x00000400 */
#define ETH_MACPCSR_RWKPFE                            ETH_MACPCSR_RWKPFE_Msk   /* Remote Wake-up Packet Forwarding Enable */
#define ETH_MACPCSR_GLBLUCAST_Pos                     (9U)
#define ETH_MACPCSR_GLBLUCAST_Msk                     (0x1U << ETH_MACPCSR_GLBLUCAST_Pos) /*!< 0x00000200 */
#define ETH_MACPCSR_GLBLUCAST                         ETH_MACPCSR_GLBLUCAST_Msk /* Global Unicast */
#define ETH_MACPCSR_RWKPRCVD_Pos                      (6U)
#define ETH_MACPCSR_RWKPRCVD_Msk                      (0x1U << ETH_MACPCSR_RWKPRCVD_Pos) /*!< 0x00000040 */
#define ETH_MACPCSR_RWKPRCVD                          ETH_MACPCSR_RWKPRCVD_Msk /* Remote Wake-Up Packet Received */
#define ETH_MACPCSR_MGKPRCVD_Pos                      (5U)
#define ETH_MACPCSR_MGKPRCVD_Msk                      (0x1U << ETH_MACPCSR_MGKPRCVD_Pos) /*!< 0x00000020 */
#define ETH_MACPCSR_MGKPRCVD                          ETH_MACPCSR_MGKPRCVD_Msk /* Magic Packet Received */
#define ETH_MACPCSR_RWKPKTEN_Pos                      (2U)
#define ETH_MACPCSR_RWKPKTEN_Msk                      (0x1U << ETH_MACPCSR_RWKPKTEN_Pos) /*!< 0x00000004 */
#define ETH_MACPCSR_RWKPKTEN                          ETH_MACPCSR_RWKPKTEN_Msk /* Remote Wake-Up Packet Enable */
#define ETH_MACPCSR_MGKPKTEN_Pos                      (1U)
#define ETH_MACPCSR_MGKPKTEN_Msk                      (0x1U << ETH_MACPCSR_MGKPKTEN_Pos) /*!< 0x00000002 */
#define ETH_MACPCSR_MGKPKTEN                          ETH_MACPCSR_MGKPKTEN_Msk /* Magic Packet Enable */
#define ETH_MACPCSR_PWRDWN_Pos                        (0U)
#define ETH_MACPCSR_PWRDWN_Msk                        (0x1U << ETH_MACPCSR_PWRDWN_Pos) /*!< 0x00000001 */
#define ETH_MACPCSR_PWRDWN                            ETH_MACPCSR_PWRDWN_Msk   /* Power Down */

/* Bit definition for Ethernet MAC Remote Wake-Up Packet Filter Register */
#define ETH_MACRWUPFR_D_Pos                           (0U)
#define ETH_MACRWUPFR_D_Msk                           (0xFFFFFFFFU << ETH_MACRWUPFR_D_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACRWUPFR_D                               ETH_MACRWUPFR_D_Msk      /* Wake-up Packet filter register data */

/* Bit definition for Ethernet MAC LPI Control Status Register */
#define ETH_MACLPICSR_LPITCSE_Pos                     (21U)
#define ETH_MACLPICSR_LPITCSE_Msk                     (0x1U << ETH_MACLPICSR_LPITCSE_Pos) /*!< 0x00200000 */
#define ETH_MACLPICSR_LPITCSE                         ETH_MACLPICSR_LPITCSE_Msk /* LPI Tx Clock Stop Enable */
#define ETH_MACLPICSR_LPITE_Pos                       (20U)
#define ETH_MACLPICSR_LPITE_Msk                       (0x1U << ETH_MACLPICSR_LPITE_Pos) /*!< 0x00100000 */
#define ETH_MACLPICSR_LPITE                           ETH_MACLPICSR_LPITE_Msk  /* LPI Timer Enable */
#define ETH_MACLPICSR_LPITXA_Pos                      (19U)
#define ETH_MACLPICSR_LPITXA_Msk                      (0x1U << ETH_MACLPICSR_LPITXA_Pos) /*!< 0x00080000 */
#define ETH_MACLPICSR_LPITXA                          ETH_MACLPICSR_LPITXA_Msk /* LPI Tx Automate */
#define ETH_MACLPICSR_PLS_Pos                         (17U)
#define ETH_MACLPICSR_PLS_Msk                         (0x1U << ETH_MACLPICSR_PLS_Pos) /*!< 0x00020000 */
#define ETH_MACLPICSR_PLS                             ETH_MACLPICSR_PLS_Msk    /* PHY Link Status */
#define ETH_MACLPICSR_LPIEN_Pos                       (16U)
#define ETH_MACLPICSR_LPIEN_Msk                       (0x1U << ETH_MACLPICSR_LPIEN_Pos) /*!< 0x00010000 */
#define ETH_MACLPICSR_LPIEN                           ETH_MACLPICSR_LPIEN_Msk  /* LPI Enable */
#define ETH_MACLPICSR_RLPIST_Pos                      (9U)
#define ETH_MACLPICSR_RLPIST_Msk                      (0x1U << ETH_MACLPICSR_RLPIST_Pos) /*!< 0x00000200 */
#define ETH_MACLPICSR_RLPIST                          ETH_MACLPICSR_RLPIST_Msk /* Receive LPI State */
#define ETH_MACLPICSR_TLPIST_Pos                      (8U)
#define ETH_MACLPICSR_TLPIST_Msk                      (0x1U << ETH_MACLPICSR_TLPIST_Pos) /*!< 0x00000100 */
#define ETH_MACLPICSR_TLPIST                          ETH_MACLPICSR_TLPIST_Msk /* Transmit LPI State */
#define ETH_MACLPICSR_RLPIEX_Pos                      (3U)
#define ETH_MACLPICSR_RLPIEX_Msk                      (0x1U << ETH_MACLPICSR_RLPIEX_Pos) /*!< 0x00000008 */
#define ETH_MACLPICSR_RLPIEX                          ETH_MACLPICSR_RLPIEX_Msk /* Receive LPI Exit */
#define ETH_MACLPICSR_RLPIEN_Pos                      (2U)
#define ETH_MACLPICSR_RLPIEN_Msk                      (0x1U << ETH_MACLPICSR_RLPIEN_Pos) /*!< 0x00000004 */
#define ETH_MACLPICSR_RLPIEN                          ETH_MACLPICSR_RLPIEN_Msk /* Receive LPI Entry */
#define ETH_MACLPICSR_TLPIEX_Pos                      (1U)
#define ETH_MACLPICSR_TLPIEX_Msk                      (0x1U << ETH_MACLPICSR_TLPIEX_Pos) /*!< 0x00000002 */
#define ETH_MACLPICSR_TLPIEX                          ETH_MACLPICSR_TLPIEX_Msk /* Transmit LPI Exit */
#define ETH_MACLPICSR_TLPIEN_Pos                      (0U)
#define ETH_MACLPICSR_TLPIEN_Msk                      (0x1U << ETH_MACLPICSR_TLPIEN_Pos) /*!< 0x00000001 */
#define ETH_MACLPICSR_TLPIEN                          ETH_MACLPICSR_TLPIEN_Msk /* Transmit LPI Entry */

/* Bit definition for Ethernet MAC LPI Timers Control Register */
#define ETH_MACLPITCR_LST_Pos                         (16U)
#define ETH_MACLPITCR_LST_Msk                         (0x3FFU << ETH_MACLPITCR_LST_Pos) /*!< 0x03FF0000 */
#define ETH_MACLPITCR_LST                             ETH_MACLPITCR_LST_Msk    /* LPI LS TIMER */
#define ETH_MACLPITCR_TWT_Pos                         (0U)
#define ETH_MACLPITCR_TWT_Msk                         (0xFFFFU << ETH_MACLPITCR_TWT_Pos) /*!< 0x0000FFFF */
#define ETH_MACLPITCR_TWT                             ETH_MACLPITCR_TWT_Msk    /* LPI TW TIMER */

/* Bit definition for Ethernet MAC LPI Entry Timer Register */
#define ETH_MACLPIETR_LPIET_Pos                       (0U)
#define ETH_MACLPIETR_LPIET_Msk                       (0xFFFFFU << ETH_MACLPIETR_LPIET_Pos) /*!< 0x000FFFFF */
#define ETH_MACLPIETR_LPIET                           ETH_MACLPIETR_LPIET_Msk  /* LPI Entry Timer */

/* Bit definition for Ethernet MAC 1US Tic Counter Register */
#define ETH_MAC1USTCR_TIC1USCNTR_Pos                  (0U)
#define ETH_MAC1USTCR_TIC1USCNTR_Msk                  (0xFFFU << ETH_MAC1USTCR_TIC1USCNTR_Pos) /*!< 0x00000FFF */
#define ETH_MAC1USTCR_TIC1USCNTR                      ETH_MAC1USTCR_TIC1USCNTR_Msk /* 1US TIC Counter */

/* Bit definition for Ethernet MAC Version Register */
#define ETH_MACVR_USERVER_Pos                         (8U)
#define ETH_MACVR_USERVER_Msk                         (0xFFU << ETH_MACVR_USERVER_Pos) /*!< 0x0000FF00 */
#define ETH_MACVR_USERVER                             ETH_MACVR_USERVER_Msk    /* User-defined Version */
#define ETH_MACVR_SNPSVER_Pos                         (0U)
#define ETH_MACVR_SNPSVER_Msk                         (0xFFU << ETH_MACVR_SNPSVER_Pos) /*!< 0x000000FF */
#define ETH_MACVR_SNPSVER                             ETH_MACVR_SNPSVER_Msk    /* Synopsys-defined Version */

/* Bit definition for Ethernet MAC Debug Register */
#define ETH_MACDR_TFCSTS_Pos                          (17U)
#define ETH_MACDR_TFCSTS_Msk                          (0x3U << ETH_MACDR_TFCSTS_Pos) /*!< 0x00060000 */
#define ETH_MACDR_TFCSTS                              ETH_MACDR_TFCSTS_Msk     /* MAC Transmit Packet Controller Status */
#define ETH_MACDR_TFCSTS_IDLE                         ((uint32_t)0x00000000)   /* Idle state */
#define ETH_MACDR_TFCSTS_WAIT_Pos                     (17U)
#define ETH_MACDR_TFCSTS_WAIT_Msk                     (0x1U << ETH_MACDR_TFCSTS_WAIT_Pos) /*!< 0x00020000 */
#define ETH_MACDR_TFCSTS_WAIT                         ETH_MACDR_TFCSTS_WAIT_Msk /* Waiting for status of the previous packet, IPG or backoff period to be over */
#define ETH_MACDR_TFCSTS_GENERATEPCP_Pos              (18U)
#define ETH_MACDR_TFCSTS_GENERATEPCP_Msk              (0x1U << ETH_MACDR_TFCSTS_GENERATEPCP_Pos) /*!< 0x00040000 */
#define ETH_MACDR_TFCSTS_GENERATEPCP                  ETH_MACDR_TFCSTS_GENERATEPCP_Msk /* Generating and transmitting a Pause control packet */
#define ETH_MACDR_TFCSTS_TRASFERIP_Pos                (17U)
#define ETH_MACDR_TFCSTS_TRASFERIP_Msk                (0x3U << ETH_MACDR_TFCSTS_TRASFERIP_Pos) /*!< 0x00060000 */
#define ETH_MACDR_TFCSTS_TRASFERIP                    ETH_MACDR_TFCSTS_TRASFERIP_Msk /* Transferring input packet for transmission */
#define ETH_MACDR_TPESTS_Pos                          (16U)
#define ETH_MACDR_TPESTS_Msk                          (0x1U << ETH_MACDR_TPESTS_Pos) /*!< 0x00010000 */
#define ETH_MACDR_TPESTS                              ETH_MACDR_TPESTS_Msk     /* MAC Receive Packet Controller FIFO Status */
#define ETH_MACDR_RFCFCSTS_Pos                        (1U)
#define ETH_MACDR_RFCFCSTS_Msk                        (0x3U << ETH_MACDR_RFCFCSTS_Pos) /*!< 0x00000006 */
#define ETH_MACDR_RFCFCSTS                            ETH_MACDR_RFCFCSTS_Msk   /* MAC MII Transmit Protocol Engine Status */
#define ETH_MACDR_RPESTS_Pos                          (0U)
#define ETH_MACDR_RPESTS_Msk                          (0x1U << ETH_MACDR_RPESTS_Pos) /*!< 0x00000001 */
#define ETH_MACDR_RPESTS                              ETH_MACDR_RPESTS_Msk     /* MAC MII Receive Protocol Engine Status */

/* Bit definition for Ethernet MAC HW Feature0 Register */
#define ETH_MACHWF0R_ACTPHYSEL_Pos                    (28U)
#define ETH_MACHWF0R_ACTPHYSEL_Msk                    (0x7U << ETH_MACHWF0R_ACTPHYSEL_Pos) /*!< 0x70000000 */
#define ETH_MACHWF0R_ACTPHYSEL                        ETH_MACHWF0R_ACTPHYSEL_Msk /* Active PHY Selected */
#define ETH_MACHWF0R_ACTPHYSEL_MII                    ((uint32_t)0x00000000)   /* MII */
#define ETH_MACHWF0R_ACTPHYSEL_RMII_Pos               (30U)
#define ETH_MACHWF0R_ACTPHYSEL_RMII_Msk               (0x1U << ETH_MACHWF0R_ACTPHYSEL_RMII_Pos) /*!< 0x40000000 */
#define ETH_MACHWF0R_ACTPHYSEL_RMII                   ETH_MACHWF0R_ACTPHYSEL_RMII_Msk /* RMII */
#define ETH_MACHWF0R_ACTPHYSEL_REVMII_Pos             (28U)
#define ETH_MACHWF0R_ACTPHYSEL_REVMII_Msk             (0x7U << ETH_MACHWF0R_ACTPHYSEL_REVMII_Pos) /*!< 0x70000000 */
#define ETH_MACHWF0R_ACTPHYSEL_REVMII                 ETH_MACHWF0R_ACTPHYSEL_REVMII_Msk /* RevMII */
#define ETH_MACHWF0R_SAVLANINS_Pos                    (27U)
#define ETH_MACHWF0R_SAVLANINS_Msk                    (0x1U << ETH_MACHWF0R_SAVLANINS_Pos) /*!< 0x08000000 */
#define ETH_MACHWF0R_SAVLANINS                        ETH_MACHWF0R_SAVLANINS_Msk /* Source Address or VLAN Insertion Enable */
#define ETH_MACHWF0R_TSSTSSEL_Pos                     (25U)
#define ETH_MACHWF0R_TSSTSSEL_Msk                     (0x3U << ETH_MACHWF0R_TSSTSSEL_Pos) /*!< 0x06000000 */
#define ETH_MACHWF0R_TSSTSSEL                         ETH_MACHWF0R_TSSTSSEL_Msk /* Timestamp System Time Source */
#define ETH_MACHWF0R_TSSTSSEL_INTERNAL_Pos            (25U)
#define ETH_MACHWF0R_TSSTSSEL_INTERNAL_Msk            (0x1U << ETH_MACHWF0R_TSSTSSEL_INTERNAL_Pos) /*!< 0x02000000 */
#define ETH_MACHWF0R_TSSTSSEL_INTERNAL                ETH_MACHWF0R_TSSTSSEL_INTERNAL_Msk /* Timestamp System Time Source: Internal */
#define ETH_MACHWF0R_TSSTSSEL_EXTERNAL_Pos            (26U)
#define ETH_MACHWF0R_TSSTSSEL_EXTERNAL_Msk            (0x1U << ETH_MACHWF0R_TSSTSSEL_EXTERNAL_Pos) /*!< 0x04000000 */
#define ETH_MACHWF0R_TSSTSSEL_EXTERNAL                ETH_MACHWF0R_TSSTSSEL_EXTERNAL_Msk /* Timestamp System Time Source: External */
#define ETH_MACHWF0R_TSSTSSEL_BOTH_Pos                (25U)
#define ETH_MACHWF0R_TSSTSSEL_BOTH_Msk                (0x3U << ETH_MACHWF0R_TSSTSSEL_BOTH_Pos) /*!< 0x06000000 */
#define ETH_MACHWF0R_TSSTSSEL_BOTH                    ETH_MACHWF0R_TSSTSSEL_BOTH_Msk /* Timestamp System Time Source: Internal & External */
#define ETH_MACHWF0R_MACADR64SEL_Pos                  (24U)
#define ETH_MACHWF0R_MACADR64SEL_Msk                  (0x1U << ETH_MACHWF0R_MACADR64SEL_Pos) /*!< 0x01000000 */
#define ETH_MACHWF0R_MACADR64SEL                      ETH_MACHWF0R_MACADR64SEL_Msk /* MAC Addresses 64\96127 Selected */
#define ETH_MACHWF0R_MACADR32SEL_Pos                  (23U)
#define ETH_MACHWF0R_MACADR32SEL_Msk                  (0x1U << ETH_MACHWF0R_MACADR32SEL_Pos) /*!< 0x00800000 */
#define ETH_MACHWF0R_MACADR32SEL                      ETH_MACHWF0R_MACADR32SEL_Msk /* MAC Addresses 32\9663 Selected */
#define ETH_MACHWF0R_ADDMACADRSEL_Pos                 (18U)
#define ETH_MACHWF0R_ADDMACADRSEL_Msk                 (0x1FU << ETH_MACHWF0R_ADDMACADRSEL_Pos) /*!< 0x007C0000 */
#define ETH_MACHWF0R_ADDMACADRSEL                     ETH_MACHWF0R_ADDMACADRSEL_Msk /* MAC Addresses 1\96 31 Selected */
#define ETH_MACHWF0R_RXCOESEL_Pos                     (16U)
#define ETH_MACHWF0R_RXCOESEL_Msk                     (0x1U << ETH_MACHWF0R_RXCOESEL_Pos) /*!< 0x00010000 */
#define ETH_MACHWF0R_RXCOESEL                         ETH_MACHWF0R_RXCOESEL_Msk /* Receive Checksum Offload Enabled */
#define ETH_MACHWF0R_TXCOESEL_Pos                     (14U)
#define ETH_MACHWF0R_TXCOESEL_Msk                     (0x1U << ETH_MACHWF0R_TXCOESEL_Pos) /*!< 0x00004000 */
#define ETH_MACHWF0R_TXCOESEL                         ETH_MACHWF0R_TXCOESEL_Msk /* Transmit Checksum Offload Enabled */
#define ETH_MACHWF0R_EEESEL_Pos                       (13U)
#define ETH_MACHWF0R_EEESEL_Msk                       (0x1U << ETH_MACHWF0R_EEESEL_Pos) /*!< 0x00002000 */
#define ETH_MACHWF0R_EEESEL                           ETH_MACHWF0R_EEESEL_Msk  /* Energy Efficient Ethernet Enabled */
#define ETH_MACHWF0R_TSSEL_Pos                        (12U)
#define ETH_MACHWF0R_TSSEL_Msk                        (0x1U << ETH_MACHWF0R_TSSEL_Pos) /*!< 0x00001000 */
#define ETH_MACHWF0R_TSSEL                            ETH_MACHWF0R_TSSEL_Msk   /* IEEE 1588-2008 Timestamp Enabled */
#define ETH_MACHWF0R_ARPOFFSEL_Pos                    (9U)
#define ETH_MACHWF0R_ARPOFFSEL_Msk                    (0x1U << ETH_MACHWF0R_ARPOFFSEL_Pos) /*!< 0x00000200 */
#define ETH_MACHWF0R_ARPOFFSEL                        ETH_MACHWF0R_ARPOFFSEL_Msk /* ARP Offload Enabled */
#define ETH_MACHWF0R_MMCSEL_Pos                       (8U)
#define ETH_MACHWF0R_MMCSEL_Msk                       (0x1U << ETH_MACHWF0R_MMCSEL_Pos) /*!< 0x00000100 */
#define ETH_MACHWF0R_MMCSEL                           ETH_MACHWF0R_MMCSEL_Msk  /* RMON Module Enable */
#define ETH_MACHWF0R_MGKSEL_Pos                       (7U)
#define ETH_MACHWF0R_MGKSEL_Msk                       (0x1U << ETH_MACHWF0R_MGKSEL_Pos) /*!< 0x00000080 */
#define ETH_MACHWF0R_MGKSEL                           ETH_MACHWF0R_MGKSEL_Msk  /* PMT Magic Packet Enable */
#define ETH_MACHWF0R_RWKSEL_Pos                       (6U)
#define ETH_MACHWF0R_RWKSEL_Msk                       (0x1U << ETH_MACHWF0R_RWKSEL_Pos) /*!< 0x00000040 */
#define ETH_MACHWF0R_RWKSEL                           ETH_MACHWF0R_RWKSEL_Msk  /* PMT Remote Wake-up Packet Enable */
#define ETH_MACHWF0R_SMASEL_Pos                       (5U)
#define ETH_MACHWF0R_SMASEL_Msk                       (0x1U << ETH_MACHWF0R_SMASEL_Pos) /*!< 0x00000020 */
#define ETH_MACHWF0R_SMASEL                           ETH_MACHWF0R_SMASEL_Msk  /* SMA (MDIO) Interface */
#define ETH_MACHWF0R_VLHASH_Pos                       (4U)
#define ETH_MACHWF0R_VLHASH_Msk                       (0x1U << ETH_MACHWF0R_VLHASH_Pos) /*!< 0x00000010 */
#define ETH_MACHWF0R_VLHASH                           ETH_MACHWF0R_VLHASH_Msk  /* VLAN Hash Filter Selected */
#define ETH_MACHWF0R_PCSSEL_Pos                       (3U)
#define ETH_MACHWF0R_PCSSEL_Msk                       (0x1U << ETH_MACHWF0R_PCSSEL_Pos) /*!< 0x00000008 */
#define ETH_MACHWF0R_PCSSEL                           ETH_MACHWF0R_PCSSEL_Msk  /* PCS Registers (TBI, SGMII, or RTBI PHY interface) */
#define ETH_MACHWF0R_HDSEL_Pos                        (2U)
#define ETH_MACHWF0R_HDSEL_Msk                        (0x1U << ETH_MACHWF0R_HDSEL_Pos) /*!< 0x00000004 */
#define ETH_MACHWF0R_HDSEL                            ETH_MACHWF0R_HDSEL_Msk   /* Half-duplex Support */
#define ETH_MACHWF0R_GMIISEL_Pos                      (1U)
#define ETH_MACHWF0R_GMIISEL_Msk                      (0x1U << ETH_MACHWF0R_GMIISEL_Pos) /*!< 0x00000002 */
#define ETH_MACHWF0R_GMIISEL                          ETH_MACHWF0R_GMIISEL_Msk /* 1000 Mbps Support */
#define ETH_MACHWF0R_MIISEL_Pos                       (0U)
#define ETH_MACHWF0R_MIISEL_Msk                       (0x1U << ETH_MACHWF0R_MIISEL_Pos) /*!< 0x00000001 */
#define ETH_MACHWF0R_MIISEL                           ETH_MACHWF0R_MIISEL_Msk  /* 10 or 100 Mbps Support */

/* Bit definition for Ethernet MAC HW Feature1 Register */
#define ETH_MACHWF1R_L3L4FNUM_Pos                     (27U)
#define ETH_MACHWF1R_L3L4FNUM_Msk                     (0xFU << ETH_MACHWF1R_L3L4FNUM_Pos) /*!< 0x78000000 */
#define ETH_MACHWF1R_L3L4FNUM                         ETH_MACHWF1R_L3L4FNUM_Msk /* Total number of L3 or L4 Filters */
#define ETH_MACHWF1R_HASHTBLSZ_Pos                    (24U)
#define ETH_MACHWF1R_HASHTBLSZ_Msk                    (0x3U << ETH_MACHWF1R_HASHTBLSZ_Pos) /*!< 0x03000000 */
#define ETH_MACHWF1R_HASHTBLSZ                        ETH_MACHWF1R_HASHTBLSZ_Msk /* Hash Table Size */
#define ETH_MACHWF1R_AVSEL_Pos                        (20U)
#define ETH_MACHWF1R_AVSEL_Msk                        (0x1U << ETH_MACHWF1R_AVSEL_Pos) /*!< 0x00100000 */
#define ETH_MACHWF1R_AVSEL                            ETH_MACHWF1R_AVSEL_Msk   /* AV Feature Enabled */
#define ETH_MACHWF1R_DBGMEMA_Pos                      (19U)
#define ETH_MACHWF1R_DBGMEMA_Msk                      (0x1U << ETH_MACHWF1R_DBGMEMA_Pos) /*!< 0x00080000 */
#define ETH_MACHWF1R_DBGMEMA                          ETH_MACHWF1R_DBGMEMA_Msk /* Debug Memory Interface Enabled */
#define ETH_MACHWF1R_TSOEN_Pos                        (18U)
#define ETH_MACHWF1R_TSOEN_Msk                        (0x1U << ETH_MACHWF1R_TSOEN_Pos) /*!< 0x00040000 */
#define ETH_MACHWF1R_TSOEN                            ETH_MACHWF1R_TSOEN_Msk   /* TCP Segmentation Offload Enable */
#define ETH_MACHWF1R_SPHEN_Pos                        (17U)
#define ETH_MACHWF1R_SPHEN_Msk                        (0x1U << ETH_MACHWF1R_SPHEN_Pos) /*!< 0x00020000 */
#define ETH_MACHWF1R_SPHEN                            ETH_MACHWF1R_SPHEN_Msk   /* Split Header Feature Enable */
#define ETH_MACHWF1R_DCBEN_Pos                        (16U)
#define ETH_MACHWF1R_DCBEN_Msk                        (0x1U << ETH_MACHWF1R_DCBEN_Pos) /*!< 0x00010000 */
#define ETH_MACHWF1R_DCBEN                            ETH_MACHWF1R_DCBEN_Msk   /* DCB Feature Enable */
#define ETH_MACHWF1R_ADDR64_Pos                       (14U)
#define ETH_MACHWF1R_ADDR64_Msk                       (0x3U << ETH_MACHWF1R_ADDR64_Pos) /*!< 0x0000C000 */
#define ETH_MACHWF1R_ADDR64                           ETH_MACHWF1R_ADDR64_Msk  /* Address Width */
#define ETH_MACHWF1R_ADDR64_32                        (0x0U << ETH_MACHWF1R_ADDR64_Pos) /*!< 0x00000000 */
#define ETH_MACHWF1R_ADDR64_40                        (0x1U << ETH_MACHWF1R_ADDR64_Pos) /*!< 0x00004000 */
#define ETH_MACHWF1R_ADDR64_48                        (0x2U << ETH_MACHWF1R_ADDR64_Pos) /*!< 0x00008000 */
#define ETH_MACHWF1R_ADVTHWORD_Pos                    (13U)
#define ETH_MACHWF1R_ADVTHWORD_Msk                    (0x1U << ETH_MACHWF1R_ADVTHWORD_Pos) /*!< 0x00002000 */
#define ETH_MACHWF1R_ADVTHWORD                        ETH_MACHWF1R_ADVTHWORD_Msk /* IEEE 1588 High Word Register Enable */
#define ETH_MACHWF1R_PTOEN_Pos                        (12U)
#define ETH_MACHWF1R_PTOEN_Msk                        (0x1U << ETH_MACHWF1R_PTOEN_Pos) /*!< 0x00001000 */
#define ETH_MACHWF1R_PTOEN                            ETH_MACHWF1R_PTOEN_Msk   /* PTP Offload Enable */
#define ETH_MACHWF1R_OSTEN_Pos                        (11U)
#define ETH_MACHWF1R_OSTEN_Msk                        (0x1U << ETH_MACHWF1R_OSTEN_Pos) /*!< 0x00000800 */
#define ETH_MACHWF1R_OSTEN                            ETH_MACHWF1R_OSTEN_Msk   /* One-Step Timestamping Enable */
#define ETH_MACHWF1R_TXFIFOSIZE_Pos                   (6U)
#define ETH_MACHWF1R_TXFIFOSIZE_Msk                   (0x1FU << ETH_MACHWF1R_TXFIFOSIZE_Pos) /*!< 0x000007C0 */
#define ETH_MACHWF1R_TXFIFOSIZE                       ETH_MACHWF1R_TXFIFOSIZE_Msk /* MTL Transmit FIFO Size */
#define ETH_MACHWF1R_RXFIFOSIZE_Pos                   (0U)
#define ETH_MACHWF1R_RXFIFOSIZE_Msk                   (0x1FU << ETH_MACHWF1R_RXFIFOSIZE_Pos) /*!< 0x0000001F */
#define ETH_MACHWF1R_RXFIFOSIZE                       ETH_MACHWF1R_RXFIFOSIZE_Msk /* MTL Receive FIFO Size */

/* Bit definition for Ethernet MAC HW Feature2 Register */
#define ETH_MACHWF2R_AUXSNAPNUM_Pos                   (28U)
#define ETH_MACHWF2R_AUXSNAPNUM_Msk                   (0x7U << ETH_MACHWF2R_AUXSNAPNUM_Pos) /*!< 0x70000000 */
#define ETH_MACHWF2R_AUXSNAPNUM                       ETH_MACHWF2R_AUXSNAPNUM_Msk /* Number of Auxiliary Snapshot Inputs */
#define ETH_MACHWF2R_PPSOUTNUM_Pos                    (24U)
#define ETH_MACHWF2R_PPSOUTNUM_Msk                    (0x7U << ETH_MACHWF2R_PPSOUTNUM_Pos) /*!< 0x07000000 */
#define ETH_MACHWF2R_PPSOUTNUM                        ETH_MACHWF2R_PPSOUTNUM_Msk /*  Number of PPS Outputs */
#define ETH_MACHWF2R_TXCHCNT_Pos                      (18U)
#define ETH_MACHWF2R_TXCHCNT_Msk                      (0xFU << ETH_MACHWF2R_TXCHCNT_Pos) /*!< 0x003C0000 */
#define ETH_MACHWF2R_TXCHCNT                          ETH_MACHWF2R_TXCHCNT_Msk /* Number of DMA Transmit Channels */
#define ETH_MACHWF2R_RXCHCNT_Pos                      (13U)
#define ETH_MACHWF2R_RXCHCNT_Msk                      (0x7U << ETH_MACHWF2R_RXCHCNT_Pos) /*!< 0x0000E000 */
#define ETH_MACHWF2R_RXCHCNT                          ETH_MACHWF2R_RXCHCNT_Msk /* Number of DMA Receive Channels */
#define ETH_MACHWF2R_TXQCNT_Pos                       (6U)
#define ETH_MACHWF2R_TXQCNT_Msk                       (0xFU << ETH_MACHWF2R_TXQCNT_Pos) /*!< 0x000003C0 */
#define ETH_MACHWF2R_TXQCNT                           ETH_MACHWF2R_TXQCNT_Msk  /* Number of MTL Transmit Queues */
#define ETH_MACHWF2R_RXQCNT_Pos                       (0U)
#define ETH_MACHWF2R_RXQCNT_Msk                       (0xFU << ETH_MACHWF2R_RXQCNT_Pos) /*!< 0x0000000F */
#define ETH_MACHWF2R_RXQCNT                           ETH_MACHWF2R_RXQCNT_Msk  /* Number of MTL Receive Queues */

/* Bit definition for Ethernet MAC MDIO Address Register */
#define ETH_MACMDIOAR_PSE_Pos                         (27U)
#define ETH_MACMDIOAR_PSE_Msk                         (0x1U << ETH_MACMDIOAR_PSE_Pos) /*!< 0x08000000 */
#define ETH_MACMDIOAR_PSE                             ETH_MACMDIOAR_PSE_Msk    /* Preamble Suppression Enable */
#define ETH_MACMDIOAR_BTB_Pos                         (26U)
#define ETH_MACMDIOAR_BTB_Msk                         (0x1U << ETH_MACMDIOAR_BTB_Pos) /*!< 0x04000000 */
#define ETH_MACMDIOAR_BTB                             ETH_MACMDIOAR_BTB_Msk    /* Back to Back transactions */
#define ETH_MACMDIOAR_PA_Pos                          (21U)
#define ETH_MACMDIOAR_PA_Msk                          (0x1FU << ETH_MACMDIOAR_PA_Pos) /*!< 0x03E00000 */
#define ETH_MACMDIOAR_PA                              ETH_MACMDIOAR_PA_Msk     /* Physical Layer Address */
#define ETH_MACMDIOAR_RDA_Pos                         (16U)
#define ETH_MACMDIOAR_RDA_Msk                         (0x1FU << ETH_MACMDIOAR_RDA_Pos) /*!< 0x001F0000 */
#define ETH_MACMDIOAR_RDA                             ETH_MACMDIOAR_RDA_Msk    /* Register/Device Address */
#define ETH_MACMDIOAR_NTC_Pos                         (12U)
#define ETH_MACMDIOAR_NTC_Msk                         (0x7U << ETH_MACMDIOAR_NTC_Pos) /*!< 0x00007000 */
#define ETH_MACMDIOAR_NTC                             ETH_MACMDIOAR_NTC_Msk    /* Number of Trailing Clocks */
#define ETH_MACMDIOAR_CR_Pos                          (8U)
#define ETH_MACMDIOAR_CR_Msk                          (0xFU << ETH_MACMDIOAR_CR_Pos) /*!< 0x00000F00 */
#define ETH_MACMDIOAR_CR                              ETH_MACMDIOAR_CR_Msk     /* CSR Clock Range */
#define ETH_MACMDIOAR_CR_DIV42                        ((uint32_t)0x00000000)   /* CSR clock/42 */
#define ETH_MACMDIOAR_CR_DIV62_Pos                    (8U)
#define ETH_MACMDIOAR_CR_DIV62_Msk                    (0x1U << ETH_MACMDIOAR_CR_DIV62_Pos) /*!< 0x00000100 */
#define ETH_MACMDIOAR_CR_DIV62                        ETH_MACMDIOAR_CR_DIV62_Msk /* CSR clock/62 */
#define ETH_MACMDIOAR_CR_DIV16_Pos                    (9U)
#define ETH_MACMDIOAR_CR_DIV16_Msk                    (0x1U << ETH_MACMDIOAR_CR_DIV16_Pos) /*!< 0x00000200 */
#define ETH_MACMDIOAR_CR_DIV16                        ETH_MACMDIOAR_CR_DIV16_Msk /* CSR clock/16 */
#define ETH_MACMDIOAR_CR_DIV26_Pos                    (8U)
#define ETH_MACMDIOAR_CR_DIV26_Msk                    (0x3U << ETH_MACMDIOAR_CR_DIV26_Pos) /*!< 0x00000300 */
#define ETH_MACMDIOAR_CR_DIV26                        ETH_MACMDIOAR_CR_DIV26_Msk /* CSR clock/26 */
#define ETH_MACMDIOAR_CR_DIV102_Pos                   (10U)
#define ETH_MACMDIOAR_CR_DIV102_Msk                   (0x1U << ETH_MACMDIOAR_CR_DIV102_Pos) /*!< 0x00000400 */
#define ETH_MACMDIOAR_CR_DIV102                       ETH_MACMDIOAR_CR_DIV102_Msk /* CSR clock/102 */
#define ETH_MACMDIOAR_CR_DIV124_Pos                   (8U)
#define ETH_MACMDIOAR_CR_DIV124_Msk                   (0x5U << ETH_MACMDIOAR_CR_DIV124_Pos) /*!< 0x00000500 */
#define ETH_MACMDIOAR_CR_DIV124                       ETH_MACMDIOAR_CR_DIV124_Msk /* CSR clock/124 */
#define ETH_MACMDIOAR_CR_DIV4AR_Pos                   (11U)
#define ETH_MACMDIOAR_CR_DIV4AR_Msk                   (0x1U << ETH_MACMDIOAR_CR_DIV4AR_Pos) /*!< 0x00000800 */
#define ETH_MACMDIOAR_CR_DIV4AR                       ETH_MACMDIOAR_CR_DIV4AR_Msk /* CSR clock/4: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV6AR_Pos                   (8U)
#define ETH_MACMDIOAR_CR_DIV6AR_Msk                   (0x9U << ETH_MACMDIOAR_CR_DIV6AR_Pos) /*!< 0x00000900 */
#define ETH_MACMDIOAR_CR_DIV6AR                       ETH_MACMDIOAR_CR_DIV6AR_Msk /* CSR clock/6: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV8AR_Pos                   (9U)
#define ETH_MACMDIOAR_CR_DIV8AR_Msk                   (0x5U << ETH_MACMDIOAR_CR_DIV8AR_Pos) /*!< 0x00000A00 */
#define ETH_MACMDIOAR_CR_DIV8AR                       ETH_MACMDIOAR_CR_DIV8AR_Msk /* CSR clock/8: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV10AR_Pos                  (8U)
#define ETH_MACMDIOAR_CR_DIV10AR_Msk                  (0xBU << ETH_MACMDIOAR_CR_DIV10AR_Pos) /*!< 0x00000B00 */
#define ETH_MACMDIOAR_CR_DIV10AR                      ETH_MACMDIOAR_CR_DIV10AR_Msk /* CSR clock/10: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV12AR_Pos                  (10U)
#define ETH_MACMDIOAR_CR_DIV12AR_Msk                  (0x3U << ETH_MACMDIOAR_CR_DIV12AR_Pos) /*!< 0x00000C00 */
#define ETH_MACMDIOAR_CR_DIV12AR                      ETH_MACMDIOAR_CR_DIV12AR_Msk /* CSR clock/12: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV14AR_Pos                  (8U)
#define ETH_MACMDIOAR_CR_DIV14AR_Msk                  (0xDU << ETH_MACMDIOAR_CR_DIV14AR_Pos) /*!< 0x00000D00 */
#define ETH_MACMDIOAR_CR_DIV14AR                      ETH_MACMDIOAR_CR_DIV14AR_Msk /* CSR clock/14: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV16AR_Pos                  (9U)
#define ETH_MACMDIOAR_CR_DIV16AR_Msk                  (0x7U << ETH_MACMDIOAR_CR_DIV16AR_Pos) /*!< 0x00000E00 */
#define ETH_MACMDIOAR_CR_DIV16AR                      ETH_MACMDIOAR_CR_DIV16AR_Msk /* CSR clock/16: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_CR_DIV18AR_Pos                  (8U)
#define ETH_MACMDIOAR_CR_DIV18AR_Msk                  (0xFU << ETH_MACMDIOAR_CR_DIV18AR_Pos) /*!< 0x00000F00 */
#define ETH_MACMDIOAR_CR_DIV18AR                      ETH_MACMDIOAR_CR_DIV18AR_Msk /* CSR clock/18: MDC clock above range specified in IEEE */
#define ETH_MACMDIOAR_SKAP_Pos                        (4U)
#define ETH_MACMDIOAR_SKAP_Msk                        (0x1U << ETH_MACMDIOAR_SKAP_Pos) /*!< 0x00000010 */
#define ETH_MACMDIOAR_SKAP                            ETH_MACMDIOAR_SKAP_Msk   /* Skip Address Packet */
#define ETH_MACMDIOAR_MOC_Pos                         (2U)
#define ETH_MACMDIOAR_MOC_Msk                         (0x3U << ETH_MACMDIOAR_MOC_Pos) /*!< 0x0000000C */
#define ETH_MACMDIOAR_MOC                             ETH_MACMDIOAR_MOC_Msk    /* MII Operation Command */
#define ETH_MACMDIOAR_MOC_WR_Pos                      (2U)
#define ETH_MACMDIOAR_MOC_WR_Msk                      (0x1U << ETH_MACMDIOAR_MOC_WR_Pos) /*!< 0x00000004 */
#define ETH_MACMDIOAR_MOC_WR                          ETH_MACMDIOAR_MOC_WR_Msk /* Write */
#define ETH_MACMDIOAR_MOC_PRDIA_Pos                   (3U)
#define ETH_MACMDIOAR_MOC_PRDIA_Msk                   (0x1U << ETH_MACMDIOAR_MOC_PRDIA_Pos) /*!< 0x00000008 */
#define ETH_MACMDIOAR_MOC_PRDIA                       ETH_MACMDIOAR_MOC_PRDIA_Msk /* Post Read Increment Address for Clause 45 PHY */
#define ETH_MACMDIOAR_MOC_RD_Pos                      (2U)
#define ETH_MACMDIOAR_MOC_RD_Msk                      (0x3U << ETH_MACMDIOAR_MOC_RD_Pos) /*!< 0x0000000C */
#define ETH_MACMDIOAR_MOC_RD                          ETH_MACMDIOAR_MOC_RD_Msk /* Read */
#define ETH_MACMDIOAR_C45E_Pos                        (1U)
#define ETH_MACMDIOAR_C45E_Msk                        (0x1U << ETH_MACMDIOAR_C45E_Pos) /*!< 0x00000002 */
#define ETH_MACMDIOAR_C45E                            ETH_MACMDIOAR_C45E_Msk   /* Clause 45 PHY Enable */
#define ETH_MACMDIOAR_MB_Pos                          (0U)
#define ETH_MACMDIOAR_MB_Msk                          (0x1U << ETH_MACMDIOAR_MB_Pos) /*!< 0x00000001 */
#define ETH_MACMDIOAR_MB                              ETH_MACMDIOAR_MB_Msk     /* MII Busy */

/* Bit definition for Ethernet MAC MDIO Data Register */
#define ETH_MACMDIODR_RA_Pos                          (16U)
#define ETH_MACMDIODR_RA_Msk                          (0xFFFFU << ETH_MACMDIODR_RA_Pos) /*!< 0xFFFF0000 */
#define ETH_MACMDIODR_RA                              ETH_MACMDIODR_RA_Msk     /* Register Address */
#define ETH_MACMDIODR_MD_Pos                          (0U)
#define ETH_MACMDIODR_MD_Msk                          (0xFFFFU << ETH_MACMDIODR_MD_Pos) /*!< 0x0000FFFF */
#define ETH_MACMDIODR_MD                              ETH_MACMDIODR_MD_Msk     /* MII Data */

/* Bit definition for Ethernet MAC Address0 High Register */
#define ETH_MACA0HR_MACA0H_Pos                        (0U)
#define ETH_MACA0HR_MACA0H_Msk                        (0xFFFFU << ETH_MACA0HR_MACA0H_Pos) /*!< 0x0000FFFF */
#define ETH_MACA0HR_MACA0H                            ETH_MACA0HR_MACA0H_Msk   /* MAC address0 high */

/* Bit definition for Ethernet MAC Address0 Low Register */
#define ETH_MACA0LR_MACA0L_Pos                        (0U)
#define ETH_MACA0LR_MACA0L_Msk                        (0xFFFFFFFFU << ETH_MACA0LR_MACA0L_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACA0LR_MACA0L                            ETH_MACA0LR_MACA0L_Msk   /* MAC address0 low */

/* TMP: there are 3 adresses but driver uses a generic bitfield for SA and AE - wait for final driver*/
#define ETH_MACAHR_AE_Pos                             (31U)
#define ETH_MACAHR_AE_Msk                             (0x1U << ETH_MACAHR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACAHR_AE                                 ETH_MACAHR_AE_Msk        /* Address enable */
#define ETH_MACAHR_SA_Pos                             (30U)
#define ETH_MACAHR_SA_Msk                             (0x1U << ETH_MACAHR_SA_Pos) /*!< 0x40000000 */
#define ETH_MACAHR_SA                                 ETH_MACAHR_SA_Msk        /* Source address */


/* Bit definition for Ethernet MAC Address1 High Register */
#define ETH_MACA1HR_AE_Pos                            (31U)
#define ETH_MACA1HR_AE_Msk                            (0x1U << ETH_MACA1HR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACA1HR_AE                                ETH_MACA1HR_AE_Msk       /* Address enable */
#define ETH_MACA1HR_SA_Pos                            (30U)
#define ETH_MACA1HR_SA_Msk                            (0x1U << ETH_MACA1HR_SA_Pos) /*!< 0x40000000 */
#define ETH_MACA1HR_SA                                ETH_MACA1HR_SA_Msk       /* Source address */
#define ETH_MACA1HR_MBC_Pos                           (24U)
#define ETH_MACA1HR_MBC_Msk                           (0x3FU << ETH_MACA1HR_MBC_Pos) /*!< 0x3F000000 */
#define ETH_MACA1HR_MBC                               ETH_MACA1HR_MBC_Msk      /* Mask byte control: bits to mask for comparison of the MAC Address bytes */
#define ETH_MACA1HR_MBC_HBITS15_8                     ((uint32_t)0x20000000)   /* Mask MAC Address high reg bits [15:8] */
#define ETH_MACA1HR_MBC_HBITS7_0                      ((uint32_t)0x10000000)   /* Mask MAC Address high reg bits [7:0] */
#define ETH_MACA1HR_MBC_LBITS31_24                    ((uint32_t)0x08000000)   /* Mask MAC Address low reg bits [31:24] */
#define ETH_MACA1HR_MBC_LBITS23_16                    ((uint32_t)0x04000000)   /* Mask MAC Address low reg bits [23:16] */
#define ETH_MACA1HR_MBC_LBITS15_8                     ((uint32_t)0x02000000)   /* Mask MAC Address low reg bits [15:8] */
#define ETH_MACA1HR_MBC_LBITS7_0                      ((uint32_t)0x01000000)   /* Mask MAC Address low reg bits [7:0] */
#define ETH_MACA1HR_MACA1H_Pos                        (0U)
#define ETH_MACA1HR_MACA1H_Msk                        (0xFFFFU << ETH_MACA1HR_MACA1H_Pos) /*!< 0x0000FFFF */
#define ETH_MACA1HR_MACA1H                            ETH_MACA1HR_MACA1H_Msk   /* MAC address1 high */

/* Bit definition for Ethernet MAC Address1 Low Register */
#define ETH_MACA1LR_MACA1L_Pos                        (0U)
#define ETH_MACA1LR_MACA1L_Msk                        (0xFFFFFFFFU << ETH_MACA1LR_MACA1L_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACA1LR_MACA1L                            ETH_MACA1LR_MACA1L_Msk   /* MAC address1 low */

/* Bit definition for Ethernet MAC Address2 High Register */
#define ETH_MACA2HR_AE_Pos                            (31U)
#define ETH_MACA2HR_AE_Msk                            (0x1U << ETH_MACA2HR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACA2HR_AE                                ETH_MACA2HR_AE_Msk       /* Address enable */
#define ETH_MACA2HR_SA_Pos                            (30U)
#define ETH_MACA2HR_SA_Msk                            (0x1U << ETH_MACA2HR_SA_Pos) /*!< 0x40000000 */
#define ETH_MACA2HR_SA                                ETH_MACA2HR_SA_Msk       /* Source address */
#define ETH_MACA2HR_MBC_Pos                           (24U)
#define ETH_MACA2HR_MBC_Msk                           (0x3FU << ETH_MACA2HR_MBC_Pos) /*!< 0x3F000000 */
#define ETH_MACA2HR_MBC                               ETH_MACA2HR_MBC_Msk      /* Mask byte control */
#define ETH_MACA2HR_MBC_HBITS15_8                     ((uint32_t)0x20000000)   /* Mask MAC Address high reg bits [15:8] */
#define ETH_MACA2HR_MBC_HBITS7_0                      ((uint32_t)0x10000000)   /* Mask MAC Address high reg bits [7:0] */
#define ETH_MACA2HR_MBC_LBITS31_24                    ((uint32_t)0x08000000)   /* Mask MAC Address low reg bits [31:24] */
#define ETH_MACA2HR_MBC_LBITS23_16                    ((uint32_t)0x04000000)   /* Mask MAC Address low reg bits [23:16] */
#define ETH_MACA2HR_MBC_LBITS15_8                     ((uint32_t)0x02000000)   /* Mask MAC Address low reg bits [15:8] */
#define ETH_MACA2HR_MBC_LBITS7_0                      ((uint32_t)0x01000000)   /* Mask MAC Address low reg bits [70] */
#define ETH_MACA2HR_MACA2H_Pos                        (0U)
#define ETH_MACA2HR_MACA2H_Msk                        (0xFFFFU << ETH_MACA2HR_MACA2H_Pos) /*!< 0x0000FFFF */
#define ETH_MACA2HR_MACA2H                            ETH_MACA2HR_MACA2H_Msk   /* MAC address1 high */

/* Bit definition for Ethernet MAC Address2 Low Register */
#define ETH_MACA2LR_MACA2L_Pos                        (0U)
#define ETH_MACA2LR_MACA2L_Msk                        (0xFFFFFFFFU << ETH_MACA2LR_MACA2L_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACA2LR_MACA2L                            ETH_MACA2LR_MACA2L_Msk   /* MAC address2 low */

/* Bit definition for Ethernet MAC Address3 High Register */
#define ETH_MACA3HR_AE_Pos                            (31U)
#define ETH_MACA3HR_AE_Msk                            (0x1U << ETH_MACA3HR_AE_Pos) /*!< 0x80000000 */
#define ETH_MACA3HR_AE                                ETH_MACA3HR_AE_Msk       /* Address enable */
#define ETH_MACA3HR_SA_Pos                            (30U)
#define ETH_MACA3HR_SA_Msk                            (0x1U << ETH_MACA3HR_SA_Pos) /*!< 0x40000000 */
#define ETH_MACA3HR_SA                                ETH_MACA3HR_SA_Msk       /* Source address */
#define ETH_MACA3HR_MBC_Pos                           (24U)
#define ETH_MACA3HR_MBC_Msk                           (0x3FU << ETH_MACA3HR_MBC_Pos) /*!< 0x3F000000 */
#define ETH_MACA3HR_MBC                               ETH_MACA3HR_MBC_Msk      /* Mask byte control */
#define ETH_MACA3HR_MBC_HBITS15_8                     ((uint32_t)0x20000000)   /* Mask MAC Address high reg bits [15:8] */
#define ETH_MACA3HR_MBC_HBITS7_0                      ((uint32_t)0x10000000)   /* Mask MAC Address high reg bits [7:0] */
#define ETH_MACA3HR_MBC_LBITS31_24                    ((uint32_t)0x08000000)   /* Mask MAC Address low reg bits [31:24] */
#define ETH_MACA3HR_MBC_LBITS23_16                    ((uint32_t)0x04000000)   /* Mask MAC Address low reg bits [23:16] */
#define ETH_MACA3HR_MBC_LBITS15_8                     ((uint32_t)0x02000000)   /* Mask MAC Address low reg bits [15:8] */
#define ETH_MACA3HR_MBC_LBITS7_0                      ((uint32_t)0x01000000)   /* Mask MAC Address low reg bits [70] */
#define ETH_MACA3HR_MACA3H_Pos                        (0U)
#define ETH_MACA3HR_MACA3H_Msk                        (0xFFFFU << ETH_MACA3HR_MACA3H_Pos) /*!< 0x0000FFFF */
#define ETH_MACA3HR_MACA3H                            ETH_MACA3HR_MACA3H_Msk   /* MAC address3 high */

/* Bit definition for Ethernet MAC Address3 Low Register */
#define ETH_MACA3LR_MACA3L_Pos                        (0U)
#define ETH_MACA3LR_MACA3L_Msk                        (0xFFFFFFFFU << ETH_MACA3LR_MACA3L_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACA3LR_MACA3L                            ETH_MACA3LR_MACA3L_Msk   /* MAC address3 low */

/* Bit definition for Ethernet MAC L3 L4 Control Register */
#define ETH_MACL3L4CR_L4DPIM_Pos                      (21U)
#define ETH_MACL3L4CR_L4DPIM_Msk                      (0x1U << ETH_MACL3L4CR_L4DPIM_Pos) /*!< 0x00200000 */
#define ETH_MACL3L4CR_L4DPIM                          ETH_MACL3L4CR_L4DPIM_Msk /* Layer 4 Destination Port Inverse Match Enable */
#define ETH_MACL3L4CR_L4DPM_Pos                       (20U)
#define ETH_MACL3L4CR_L4DPM_Msk                       (0x1U << ETH_MACL3L4CR_L4DPM_Pos) /*!< 0x00100000 */
#define ETH_MACL3L4CR_L4DPM                           ETH_MACL3L4CR_L4DPM_Msk  /* Layer 4 Destination Port Match Enable */
#define ETH_MACL3L4CR_L4SPIM_Pos                      (19U)
#define ETH_MACL3L4CR_L4SPIM_Msk                      (0x1U << ETH_MACL3L4CR_L4SPIM_Pos) /*!< 0x00080000 */
#define ETH_MACL3L4CR_L4SPIM                          ETH_MACL3L4CR_L4SPIM_Msk /* Layer 4 Source Port Inverse Match Enable */
#define ETH_MACL3L4CR_L4SPM_Pos                       (18U)
#define ETH_MACL3L4CR_L4SPM_Msk                       (0x1U << ETH_MACL3L4CR_L4SPM_Pos) /*!< 0x00040000 */
#define ETH_MACL3L4CR_L4SPM                           ETH_MACL3L4CR_L4SPM_Msk  /* Layer 4 Source Port Match Enable */
#define ETH_MACL3L4CR_L4PEN_Pos                       (16U)
#define ETH_MACL3L4CR_L4PEN_Msk                       (0x1U << ETH_MACL3L4CR_L4PEN_Pos) /*!< 0x00010000 */
#define ETH_MACL3L4CR_L4PEN                           ETH_MACL3L4CR_L4PEN_Msk  /* Layer 4 Protocol Enable */
#define ETH_MACL3L4CR_L3HDBM_Pos                      (11U)
#define ETH_MACL3L4CR_L3HDBM_Msk                      (0x1FU << ETH_MACL3L4CR_L3HDBM_Pos) /*!< 0x0000F800 */
#define ETH_MACL3L4CR_L3HDBM                          ETH_MACL3L4CR_L3HDBM_Msk /* Layer 3 IP DA Higher Bits Match */
#define ETH_MACL3L4CR_L3HSBM_Pos                      (6U)
#define ETH_MACL3L4CR_L3HSBM_Msk                      (0x1FU << ETH_MACL3L4CR_L3HSBM_Pos) /*!< 0x000007C0 */
#define ETH_MACL3L4CR_L3HSBM                          ETH_MACL3L4CR_L3HSBM_Msk /* Layer 3 IP SA Higher Bits Match */
#define ETH_MACL3L4CR_L3DAIM_Pos                      (5U)
#define ETH_MACL3L4CR_L3DAIM_Msk                      (0x1U << ETH_MACL3L4CR_L3DAIM_Pos) /*!< 0x00000020 */
#define ETH_MACL3L4CR_L3DAIM                          ETH_MACL3L4CR_L3DAIM_Msk /* Layer 3 IP DA Inverse Match Enable */
#define ETH_MACL3L4CR_L3DAM_Pos                       (4U)
#define ETH_MACL3L4CR_L3DAM_Msk                       (0x1U << ETH_MACL3L4CR_L3DAM_Pos) /*!< 0x00000010 */
#define ETH_MACL3L4CR_L3DAM                           ETH_MACL3L4CR_L3DAM_Msk  /* Layer 3 IP DA Match Enable */
#define ETH_MACL3L4CR_L3SAIM_Pos                      (3U)
#define ETH_MACL3L4CR_L3SAIM_Msk                      (0x1U << ETH_MACL3L4CR_L3SAIM_Pos) /*!< 0x00000008 */
#define ETH_MACL3L4CR_L3SAIM                          ETH_MACL3L4CR_L3SAIM_Msk /* Layer 3 IP SA Inverse Match Enable */
#define ETH_MACL3L4CR_L3SAM_Pos                       (2U)
#define ETH_MACL3L4CR_L3SAM_Msk                       (0x1U << ETH_MACL3L4CR_L3SAM_Pos) /*!< 0x00000004 */
#define ETH_MACL3L4CR_L3SAM                           ETH_MACL3L4CR_L3SAM_Msk  /* Layer 3 IP SA Match Enable*/
#define ETH_MACL3L4CR_L3PEN_Pos                       (0U)
#define ETH_MACL3L4CR_L3PEN_Msk                       (0x1U << ETH_MACL3L4CR_L3PEN_Pos) /*!< 0x00000001 */
#define ETH_MACL3L4CR_L3PEN                           ETH_MACL3L4CR_L3PEN_Msk  /* Layer 3 Protocol Enable */

/* Bit definition for Ethernet MAC L4 Address Register */
#define ETH_MACL4AR_L4DP_Pos                          (16U)
#define ETH_MACL4AR_L4DP_Msk                          (0xFFFFU << ETH_MACL4AR_L4DP_Pos) /*!< 0xFFFF0000 */
#define ETH_MACL4AR_L4DP                              ETH_MACL4AR_L4DP_Msk     /* Layer 4 Destination Port Number Field */
#define ETH_MACL4AR_L4SP_Pos                          (0U)
#define ETH_MACL4AR_L4SP_Msk                          (0xFFFFU << ETH_MACL4AR_L4SP_Pos) /*!< 0x0000FFFF */
#define ETH_MACL4AR_L4SP                              ETH_MACL4AR_L4SP_Msk     /* Layer 4 Source Port Number Field */

/* Bit definition for Ethernet MAC L3 Address0 Register */
#define ETH_MACL3A0R_L3A0_Pos                         (0U)
#define ETH_MACL3A0R_L3A0_Msk                         (0xFFFFFFFFU << ETH_MACL3A0R_L3A0_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACL3A0R_L3A0                             ETH_MACL3A0R_L3A0_Msk    /* Layer 3 Address 0 Field */

/* Bit definition for Ethernet MAC L4 Address1 Register */
#define ETH_MACL3A1R_L3A1_Pos                         (0U)
#define ETH_MACL3A1R_L3A1_Msk                         (0xFFFFFFFFU << ETH_MACL3A1R_L3A1_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACL3A1R_L3A1                             ETH_MACL3A1R_L3A1_Msk    /* Layer 3 Address 1 Field */

/* Bit definition for Ethernet MAC L4 Address2 Register */
#define ETH_MACL3A2R_L3A2_Pos                         (0U)
#define ETH_MACL3A2R_L3A2_Msk                         (0xFFFFFFFFU << ETH_MACL3A2R_L3A2_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACL3A2R_L3A2                             ETH_MACL3A2R_L3A2_Msk    /* Layer 3 Address 2 Field */

/* Bit definition for Ethernet MAC L4 Address3 Register */
#define ETH_MACL3A3R_L3A3_Pos                         (0U)
#define ETH_MACL3A3R_L3A3_Msk                         (0xFFFFFFFFU << ETH_MACL3A3R_L3A3_Pos) /*!< 0xFFFFFFFF */
#define ETH_MACL3A3R_L3A3                             ETH_MACL3A3R_L3A3_Msk    /* Layer 3 Address 3 Field */

/* Bit definition for Ethernet MTL Operation Mode Register */
#define ETH_MTLOMR_CNTCLR_Pos                         (9U)
#define ETH_MTLOMR_CNTCLR_Msk                         (0x1U << ETH_MTLOMR_CNTCLR_Pos) /*!< 0x00000200 */
#define ETH_MTLOMR_CNTCLR                             ETH_MTLOMR_CNTCLR_Msk    /* Counters Reset */
#define ETH_MTLOMR_CNTPRST_Pos                        (8U)
#define ETH_MTLOMR_CNTPRST_Msk                        (0x1U << ETH_MTLOMR_CNTPRST_Pos) /*!< 0x00000100 */
#define ETH_MTLOMR_CNTPRST                            ETH_MTLOMR_CNTPRST_Msk   /* Counters Preset */

/* Bit definition for Ethernet MTL Interrupt Status Register */
#define ETH_MTLISR_MACIS_Pos                          (16U)
#define ETH_MTLISR_MACIS_Msk                          (0x1U << ETH_MTLISR_MACIS_Pos) /*!< 0x00010000 */
#define ETH_MTLISR_MACIS                              ETH_MTLISR_MACIS_Msk     /* MAC Interrupt Status */
#define ETH_MTLISR_QIS_Pos                            (0U)
#define ETH_MTLISR_QIS_Msk                            (0x1U << ETH_MTLISR_QIS_Pos) /*!< 0x00000001 */
#define ETH_MTLISR_QIS                                ETH_MTLISR_QIS_Msk       /* Queue Interrupt status */

/* Bit definition for Ethernet MTL Tx Queue Operation Mode Register */
#define ETH_MTLTQOMR_TTC_Pos                          (4U)
#define ETH_MTLTQOMR_TTC_Msk                          (0x7U << ETH_MTLTQOMR_TTC_Pos) /*!< 0x00000070 */
#define ETH_MTLTQOMR_TTC                              ETH_MTLTQOMR_TTC_Msk     /* Transmit Threshold Control */
#define ETH_MTLTQOMR_TTC_32BITS                       ((uint32_t)0x00000000)   /* 32 bits Threshold */
#define ETH_MTLTQOMR_TTC_64BITS                       ((uint32_t)0x00000010)   /* 64  bits Threshold */
#define ETH_MTLTQOMR_TTC_96BITS                       ((uint32_t)0x00000020)   /* 96 bits Threshold */
#define ETH_MTLTQOMR_TTC_128BITS                      ((uint32_t)0x00000030)   /* 128 bits Threshold */
#define ETH_MTLTQOMR_TTC_192BITS                      ((uint32_t)0x00000040)   /* 192 bits Threshold */
#define ETH_MTLTQOMR_TTC_256BITS                      ((uint32_t)0x00000050)   /* 256 bits Threshold */
#define ETH_MTLTQOMR_TTC_384BITS                      ((uint32_t)0x00000060)   /* 384 bits Threshold */
#define ETH_MTLTQOMR_TTC_512BITS                      ((uint32_t)0x00000070)   /* 512 bits Threshold */
#define ETH_MTLTQOMR_TXQUEN_Pos                       (3U)
#define ETH_MTLTQOMR_TXQUEN_Msk                       (0x1U << ETH_MTLTQOMR_TXQUEN_Pos) /*!< 0x00000008 */
#define ETH_MTLTQOMR_TXQUEN                           ETH_MTLTQOMR_TXQUEN_Msk  /* Transmit Queue Enable */
#define ETH_MTLTQOMR_TSF_Pos                          (1U)
#define ETH_MTLTQOMR_TSF_Msk                          (0x1U << ETH_MTLTQOMR_TSF_Pos) /*!< 0x00000002 */
#define ETH_MTLTQOMR_TSF                              ETH_MTLTQOMR_TSF_Msk     /* Transmit Store and Forward */
#define ETH_MTLTQOMR_FTQ_Pos                          (0U)
#define ETH_MTLTQOMR_FTQ_Msk                          (0x1U << ETH_MTLTQOMR_FTQ_Pos) /*!< 0x00000001 */
#define ETH_MTLTQOMR_FTQ                              ETH_MTLTQOMR_FTQ_Msk     /* Flush Transmit Queue */

/* Bit definition for Ethernet MTL Tx Queue Underflow Register */
#define ETH_MTLTQUR_UFCNTOVF_Pos                      (11U)
#define ETH_MTLTQUR_UFCNTOVF_Msk                      (0x1U << ETH_MTLTQUR_UFCNTOVF_Pos) /*!< 0x00000800 */
#define ETH_MTLTQUR_UFCNTOVF                          ETH_MTLTQUR_UFCNTOVF_Msk /* Overflow Bit for Underflow Packet Counter */
#define ETH_MTLTQUR_UFPKTCNT_Pos                      (0U)
#define ETH_MTLTQUR_UFPKTCNT_Msk                      (0x7FFU << ETH_MTLTQUR_UFPKTCNT_Pos) /*!< 0x000007FF */
#define ETH_MTLTQUR_UFPKTCNT                          ETH_MTLTQUR_UFPKTCNT_Msk /* Underflow Packet Counter */

/* Bit definition for Ethernet MTL Tx Queue Debug Register */
#define ETH_MTLTQDR_STXSTSF_Pos                       (20U)
#define ETH_MTLTQDR_STXSTSF_Msk                       (0x7U << ETH_MTLTQDR_STXSTSF_Pos) /*!< 0x00700000 */
#define ETH_MTLTQDR_STXSTSF                           ETH_MTLTQDR_STXSTSF_Msk  /* Number of Status Words in the Tx Status FIFO of Queue */
#define ETH_MTLTQDR_PTXQ_Pos                          (16U)
#define ETH_MTLTQDR_PTXQ_Msk                          (0x7U << ETH_MTLTQDR_PTXQ_Pos) /*!< 0x00070000 */
#define ETH_MTLTQDR_PTXQ                              ETH_MTLTQDR_PTXQ_Msk     /* Number of Packets in the Transmit Queue */
#define ETH_MTLTQDR_TXSTSFSTS_Pos                     (5U)
#define ETH_MTLTQDR_TXSTSFSTS_Msk                     (0x1U << ETH_MTLTQDR_TXSTSFSTS_Pos) /*!< 0x00000020 */
#define ETH_MTLTQDR_TXSTSFSTS                         ETH_MTLTQDR_TXSTSFSTS_Msk /* MTL Tx Status FIFO Full Status */
#define ETH_MTLTQDR_TXQSTS_Pos                        (4U)
#define ETH_MTLTQDR_TXQSTS_Msk                        (0x1U << ETH_MTLTQDR_TXQSTS_Pos) /*!< 0x00000010 */
#define ETH_MTLTQDR_TXQSTS                            ETH_MTLTQDR_TXQSTS_Msk   /* MTL Tx Queue Not Empty Status */
#define ETH_MTLTQDR_TWCSTS_Pos                        (3U)
#define ETH_MTLTQDR_TWCSTS_Msk                        (0x1U << ETH_MTLTQDR_TWCSTS_Pos) /*!< 0x00000008 */
#define ETH_MTLTQDR_TWCSTS                            ETH_MTLTQDR_TWCSTS_Msk   /* MTL Tx Queue Write Controller Status */
#define ETH_MTLTQDR_TRCSTS_Pos                        (1U)
#define ETH_MTLTQDR_TRCSTS_Msk                        (0x3U << ETH_MTLTQDR_TRCSTS_Pos) /*!< 0x00000006 */
#define ETH_MTLTQDR_TRCSTS                            ETH_MTLTQDR_TRCSTS_Msk   /* MTL Tx Queue Read Controller Status */
#define ETH_MTLTQDR_TXQSTS_IDLE                       ((uint32_t)0x00000000)   /* Idle state */
#define ETH_MTLTQDR_TXQSTS_READ_Pos                   (1U)
#define ETH_MTLTQDR_TXQSTS_READ_Msk                   (0x1U << ETH_MTLTQDR_TXQSTS_READ_Pos) /*!< 0x00000002 */
#define ETH_MTLTQDR_TXQSTS_READ                       ETH_MTLTQDR_TXQSTS_READ_Msk /* Read state (transferring data to the MAC transmitter) */
#define ETH_MTLTQDR_TXQSTS_WAITING_Pos                (2U)
#define ETH_MTLTQDR_TXQSTS_WAITING_Msk                (0x1U << ETH_MTLTQDR_TXQSTS_WAITING_Pos) /*!< 0x00000004 */
#define ETH_MTLTQDR_TXQSTS_WAITING                    ETH_MTLTQDR_TXQSTS_WAITING_Msk /* Waiting for pending Tx Status from the MAC transmitter */
#define ETH_MTLTQDR_TXQSTS_FLUSHING_Pos               (1U)
#define ETH_MTLTQDR_TXQSTS_FLUSHING_Msk               (0x3U << ETH_MTLTQDR_TXQSTS_FLUSHING_Pos) /*!< 0x00000006 */
#define ETH_MTLTQDR_TXQSTS_FLUSHING                   ETH_MTLTQDR_TXQSTS_FLUSHING_Msk /* Flushing the Tx queue because of the Packet Abort request from the MAC */
#define ETH_MTLTQDR_TXQPAUSED_Pos                     (0U)
#define ETH_MTLTQDR_TXQPAUSED_Msk                     (0x1U << ETH_MTLTQDR_TXQPAUSED_Pos) /*!< 0x00000001 */
#define ETH_MTLTQDR_TXQPAUSED                         ETH_MTLTQDR_TXQPAUSED_Msk /* Transmit Queue in Pause */

/* Bit definition for Ethernet MTL Queue Interrupt Control Status Register */
#define ETH_MTLQICSR_RXOIE_Pos                        (24U)
#define ETH_MTLQICSR_RXOIE_Msk                        (0x1U << ETH_MTLQICSR_RXOIE_Pos) /*!< 0x01000000 */
#define ETH_MTLQICSR_RXOIE                            ETH_MTLQICSR_RXOIE_Msk   /* Receive Queue Overflow Interrupt Enable */
#define ETH_MTLQICSR_RXOVFIS_Pos                      (16U)
#define ETH_MTLQICSR_RXOVFIS_Msk                      (0x1U << ETH_MTLQICSR_RXOVFIS_Pos) /*!< 0x00010000 */
#define ETH_MTLQICSR_RXOVFIS                          ETH_MTLQICSR_RXOVFIS_Msk /* Receive Queue Overflow Interrupt Status */
#define ETH_MTLQICSR_TXUIE_Pos                        (8U)
#define ETH_MTLQICSR_TXUIE_Msk                        (0x1U << ETH_MTLQICSR_TXUIE_Pos) /*!< 0x00000100 */
#define ETH_MTLQICSR_TXUIE                            ETH_MTLQICSR_TXUIE_Msk   /* Transmit Queue Underflow Interrupt Enable */
#define ETH_MTLQICSR_TXUNFIS_Pos                      (0U)
#define ETH_MTLQICSR_TXUNFIS_Msk                      (0x1U << ETH_MTLQICSR_TXUNFIS_Pos) /*!< 0x00000001 */
#define ETH_MTLQICSR_TXUNFIS                          ETH_MTLQICSR_TXUNFIS_Msk /* Transmit Queue Underflow Interrupt Status */

/* Bit definition for Ethernet MTL Rx Queue Operation Mode Register */
#define ETH_MTLRQOMR_DISTCPEF_Pos                     (6U)
#define ETH_MTLRQOMR_DISTCPEF_Msk                     (0x1U << ETH_MTLRQOMR_DISTCPEF_Pos) /*!< 0x00000040 */
#define ETH_MTLRQOMR_DISTCPEF                         ETH_MTLRQOMR_DISTCPEF_Msk /* Disable Dropping of TCP/IP Checksum Error Packets */
#define ETH_MTLRQOMR_RSF_Pos                          (5U)
#define ETH_MTLRQOMR_RSF_Msk                          (0x1U << ETH_MTLRQOMR_RSF_Pos) /*!< 0x00000020 */
#define ETH_MTLRQOMR_RSF                              ETH_MTLRQOMR_RSF_Msk     /* Receive Queue Store and Forward */
#define ETH_MTLRQOMR_FEP_Pos                          (4U)
#define ETH_MTLRQOMR_FEP_Msk                          (0x1U << ETH_MTLRQOMR_FEP_Pos) /*!< 0x00000010 */
#define ETH_MTLRQOMR_FEP                              ETH_MTLRQOMR_FEP_Msk     /* Forward Error Packets */
#define ETH_MTLRQOMR_FUP_Pos                          (3U)
#define ETH_MTLRQOMR_FUP_Msk                          (0x1U << ETH_MTLRQOMR_FUP_Pos) /*!< 0x00000008 */
#define ETH_MTLRQOMR_FUP                              ETH_MTLRQOMR_FUP_Msk     /* Forward Undersized Good Packets */
#define ETH_MTLRQOMR_RTC_Pos                          (0U)
#define ETH_MTLRQOMR_RTC_Msk                          (0x3U << ETH_MTLRQOMR_RTC_Pos) /*!< 0x00000003 */
#define ETH_MTLRQOMR_RTC                              ETH_MTLRQOMR_RTC_Msk     /* Receive Queue Threshold Control */
#define ETH_MTLRQOMR_RTC_64BITS                       ((uint32_t)0x00000000)   /* 64 bits Threshold */
#define ETH_MTLRQOMR_RTC_32BITS                       ((uint32_t)0x00000001)   /* 32 bits Threshold */
#define ETH_MTLRQOMR_RTC_96BITS                       ((uint32_t)0x00000002)   /* 96 bits Threshold */
#define ETH_MTLRQOMR_RTC_128BITS                      ((uint32_t)0x00000003)   /* 128 bits Threshold */

/* Bit definition for Ethernet MTL Rx Queue Missed Packet Overflow Cnt Register */
#define ETH_MTLRQMPOCR_MISCNTOVF_Pos                  (27U)
#define ETH_MTLRQMPOCR_MISCNTOVF_Msk                  (0x1U << ETH_MTLRQMPOCR_MISCNTOVF_Pos) /*!< 0x08000000 */
#define ETH_MTLRQMPOCR_MISCNTOVF                      ETH_MTLRQMPOCR_MISCNTOVF_Msk /* Missed Packet Counter Overflow Bit */
#define ETH_MTLRQMPOCR_MISPKTCNT_Pos                  (16U)
#define ETH_MTLRQMPOCR_MISPKTCNT_Msk                  (0x7FFU << ETH_MTLRQMPOCR_MISPKTCNT_Pos) /*!< 0x07FF0000 */
#define ETH_MTLRQMPOCR_MISPKTCNT                      ETH_MTLRQMPOCR_MISPKTCNT_Msk /* Missed Packet Counter */
#define ETH_MTLRQMPOCR_OVFCNTOVF_Pos                  (11U)
#define ETH_MTLRQMPOCR_OVFCNTOVF_Msk                  (0x1U << ETH_MTLRQMPOCR_OVFCNTOVF_Pos) /*!< 0x00000800 */
#define ETH_MTLRQMPOCR_OVFCNTOVF                      ETH_MTLRQMPOCR_OVFCNTOVF_Msk /* Overflow Counter Overflow Bit */
#define ETH_MTLRQMPOCR_OVFPKTCNT_Pos                  (0U)
#define ETH_MTLRQMPOCR_OVFPKTCNT_Msk                  (0x7FFU << ETH_MTLRQMPOCR_OVFPKTCNT_Pos) /*!< 0x000007FF */
#define ETH_MTLRQMPOCR_OVFPKTCNT                      ETH_MTLRQMPOCR_OVFPKTCNT_Msk /* Overflow Packet Counter */

/* Bit definition for Ethernet MTL Rx Queue Debug Register */
#define ETH_MTLRQDR_PRXQ_Pos                          (16U)
#define ETH_MTLRQDR_PRXQ_Msk                          (0x3FFFU << ETH_MTLRQDR_PRXQ_Pos) /*!< 0x3FFF0000 */
#define ETH_MTLRQDR_PRXQ                              ETH_MTLRQDR_PRXQ_Msk     /* Number of Packets in Receive Queue */
#define ETH_MTLRQDR_RXQSTS_Pos                        (4U)
#define ETH_MTLRQDR_RXQSTS_Msk                        (0x3U << ETH_MTLRQDR_RXQSTS_Pos) /*!< 0x00000030 */
#define ETH_MTLRQDR_RXQSTS                            ETH_MTLRQDR_RXQSTS_Msk   /* MTL Rx Queue Fill-Level Status */
#define ETH_MTLRQDR_RXQSTS_EMPTY                      ((uint32_t)0x00000000)   /* Rx Queue empty */
#define ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD_Pos         (4U)
#define ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD_Msk         (0x1U << ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD_Pos) /*!< 0x00000010 */
#define ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD             ETH_MTLRQDR_RXQSTS_BELOWTHRESHOLD_Msk /* Rx Queue fill-level below flow-control deactivate threshold */
#define ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD_Pos         (5U)
#define ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD_Msk         (0x1U << ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD_Pos) /*!< 0x00000020 */
#define ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD             ETH_MTLRQDR_RXQSTS_ABOVETHRESHOLD_Msk /* Rx Queue fill-level above flow-control activate threshold */
#define ETH_MTLRQDR_RXQSTS_FULL_Pos                   (4U)
#define ETH_MTLRQDR_RXQSTS_FULL_Msk                   (0x3U << ETH_MTLRQDR_RXQSTS_FULL_Pos) /*!< 0x00000030 */
#define ETH_MTLRQDR_RXQSTS_FULL                       ETH_MTLRQDR_RXQSTS_FULL_Msk /* Rx Queue full */
#define ETH_MTLRQDR_RRCSTS_Pos                        (1U)
#define ETH_MTLRQDR_RRCSTS_Msk                        (0x3U << ETH_MTLRQDR_RRCSTS_Pos) /*!< 0x00000006 */
#define ETH_MTLRQDR_RRCSTS                            ETH_MTLRQDR_RRCSTS_Msk   /* MTL Rx Queue Read Controller State */
#define ETH_MTLRQDR_RRCSTS_IDLE                       ((uint32_t)0x00000000)   /* Idle state */
#define ETH_MTLRQDR_RRCSTS_READINGDATA_Pos            (1U)
#define ETH_MTLRQDR_RRCSTS_READINGDATA_Msk            (0x1U << ETH_MTLRQDR_RRCSTS_READINGDATA_Pos) /*!< 0x00000002 */
#define ETH_MTLRQDR_RRCSTS_READINGDATA                ETH_MTLRQDR_RRCSTS_READINGDATA_Msk /* Reading packet data */
#define ETH_MTLRQDR_RRCSTS_READINGSTATUS_Pos          (2U)
#define ETH_MTLRQDR_RRCSTS_READINGSTATUS_Msk          (0x1U << ETH_MTLRQDR_RRCSTS_READINGSTATUS_Pos) /*!< 0x00000004 */
#define ETH_MTLRQDR_RRCSTS_READINGSTATUS              ETH_MTLRQDR_RRCSTS_READINGSTATUS_Msk /* Reading packet status (or timestamp) */
#define ETH_MTLRQDR_RRCSTS_FLUSHING_Pos               (1U)
#define ETH_MTLRQDR_RRCSTS_FLUSHING_Msk               (0x3U << ETH_MTLRQDR_RRCSTS_FLUSHING_Pos) /*!< 0x00000006 */
#define ETH_MTLRQDR_RRCSTS_FLUSHING                   ETH_MTLRQDR_RRCSTS_FLUSHING_Msk /* Flushing the packet data and status */
#define ETH_MTLRQDR_RWCSTS_Pos                        (0U)
#define ETH_MTLRQDR_RWCSTS_Msk                        (0x1U << ETH_MTLRQDR_RWCSTS_Pos) /*!< 0x00000001 */
#define ETH_MTLRQDR_RWCSTS                            ETH_MTLRQDR_RWCSTS_Msk   /* MTL Rx Queue Write Controller Active Status */

/* Bit definition for Ethernet MTL Rx Queue Control Register */
#define ETH_MTLRQCR_RQPA_Pos                          (3U)
#define ETH_MTLRQCR_RQPA_Msk                          (0x1U << ETH_MTLRQCR_RQPA_Pos) /*!< 0x00000008 */
#define ETH_MTLRQCR_RQPA                              ETH_MTLRQCR_RQPA_Msk     /* Receive Queue Packet Arbitration */
#define ETH_MTLRQCR_RQW_Pos                           (0U)
#define ETH_MTLRQCR_RQW_Msk                           (0x7U << ETH_MTLRQCR_RQW_Pos) /*!< 0x00000007 */
#define ETH_MTLRQCR_RQW                               ETH_MTLRQCR_RQW_Msk      /* Receive Queue Weight */

/* Bit definition for Ethernet DMA Mode Register */
#define ETH_DMAMR_INTM_Pos                            (16U)
#define ETH_DMAMR_INTM_Msk                            (0x3U << ETH_DMAMR_INTM_Pos) /*!< 0x00030000 */
#define ETH_DMAMR_INTM                                ETH_DMAMR_INTM_Msk       /* This field defines the interrupt mode */
#define ETH_DMAMR_INTM_0                              (0x0U << ETH_DMAMR_INTM_Pos) /*!< 0x00000000 */
#define ETH_DMAMR_INTM_1                              (0x1U << ETH_DMAMR_INTM_Pos) /*!< 0x00010000 */
#define ETH_DMAMR_INTM_2                              (0x2U << ETH_DMAMR_INTM_Pos) /*!< 0x00020000 */
#define ETH_DMAMR_PR_Pos                              (12U)
#define ETH_DMAMR_PR_Msk                              (0x7U << ETH_DMAMR_PR_Pos) /*!< 0x00007000 */
#define ETH_DMAMR_PR                                  ETH_DMAMR_PR_Msk         /* Priority Ratio */
#define ETH_DMAMR_PR_1_1                              ((uint32_t)0x00000000)   /* The priority ratio is 1:1 */
#define ETH_DMAMR_PR_2_1                              ((uint32_t)0x00001000)   /* The priority ratio is 2:1 */
#define ETH_DMAMR_PR_3_1                              ((uint32_t)0x00002000)   /* The priority ratio is 3:1 */
#define ETH_DMAMR_PR_4_1                              ((uint32_t)0x00003000)   /* The priority ratio is 4:1 */
#define ETH_DMAMR_PR_5_1                              ((uint32_t)0x00004000)   /* The priority ratio is 5:1 */
#define ETH_DMAMR_PR_6_1                              ((uint32_t)0x00005000)   /* The priority ratio is 6:1 */
#define ETH_DMAMR_PR_7_1                              ((uint32_t)0x00006000)   /* The priority ratio is 7:1 */
#define ETH_DMAMR_PR_8_1                              ((uint32_t)0x00007000)   /* The priority ratio is 8:1 */
#define ETH_DMAMR_TXPR_Pos                            (11U)
#define ETH_DMAMR_TXPR_Msk                            (0x1U << ETH_DMAMR_TXPR_Pos) /*!< 0x00000800 */
#define ETH_DMAMR_TXPR                                ETH_DMAMR_TXPR_Msk       /* Transmit Priority */
#define ETH_DMAMR_DA_Pos                              (1U)
#define ETH_DMAMR_DA_Msk                              (0x1U << ETH_DMAMR_DA_Pos) /*!< 0x00000002 */
#define ETH_DMAMR_DA                                  ETH_DMAMR_DA_Msk         /* DMA Tx or Rx Arbitration Scheme */
#define ETH_DMAMR_SWR_Pos                             (0U)
#define ETH_DMAMR_SWR_Msk                             (0x1U << ETH_DMAMR_SWR_Pos) /*!< 0x00000001 */
#define ETH_DMAMR_SWR                                 ETH_DMAMR_SWR_Msk        /* Software Reset */

/* Bit definition for Ethernet DMA SysBus Mode Register */
#define ETH_DMASBMR_RB_Pos                            (15U)
#define ETH_DMASBMR_RB_Msk                            (0x1U << ETH_DMASBMR_RB_Pos) /*!< 0x00008000 */
#define ETH_DMASBMR_RB                                ETH_DMASBMR_RB_Msk       /* Rebuild INCRx Burst */
#define ETH_DMASBMR_MB_Pos                            (14U)
#define ETH_DMASBMR_MB_Msk                            (0x1U << ETH_DMASBMR_MB_Pos) /*!< 0x00004000 */
#define ETH_DMASBMR_MB                                ETH_DMASBMR_MB_Msk       /* Mixed Burst */
#define ETH_DMASBMR_AAL_Pos                           (12U)
#define ETH_DMASBMR_AAL_Msk                           (0x1U << ETH_DMASBMR_AAL_Pos) /*!< 0x00001000 */
#define ETH_DMASBMR_AAL                               ETH_DMASBMR_AAL_Msk      /* Address-Aligned Beats */
#define ETH_DMASBMR_FB_Pos                            (0U)
#define ETH_DMASBMR_FB_Msk                            (0x1U << ETH_DMASBMR_FB_Pos) /*!< 0x00000001 */
#define ETH_DMASBMR_FB                                ETH_DMASBMR_FB_Msk       /* Fixed Burst Length */

/* Bit definition for Ethernet DMA Interrupt Status Register */
#define ETH_DMAISR_MACIS_Pos                          (17U)
#define ETH_DMAISR_MACIS_Msk                          (0x1U << ETH_DMAISR_MACIS_Pos) /*!< 0x00020000 */
#define ETH_DMAISR_MACIS                              ETH_DMAISR_MACIS_Msk     /* MAC Interrupt Status */
#define ETH_DMAISR_MTLIS_Pos                          (16U)
#define ETH_DMAISR_MTLIS_Msk                          (0x1U << ETH_DMAISR_MTLIS_Pos) /*!< 0x00010000 */
#define ETH_DMAISR_MTLIS                              ETH_DMAISR_MTLIS_Msk     /* MAC Interrupt Status */
#define ETH_DMAISR_DMACIS_Pos                         (0U)
#define ETH_DMAISR_DMACIS_Msk                         (0x1U << ETH_DMAISR_DMACIS_Pos) /*!< 0x00000001 */
#define ETH_DMAISR_DMACIS                             ETH_DMAISR_DMACIS_Msk    /* DMA Channel Interrupt Status */

/* Bit definition for Ethernet DMA Debug Status Register */
#define ETH_DMADSR_TPS_Pos                            (12U)
#define ETH_DMADSR_TPS_Msk                            (0xFU << ETH_DMADSR_TPS_Pos) /*!< 0x0000F000 */
#define ETH_DMADSR_TPS                                ETH_DMADSR_TPS_Msk       /* DMA Channel Transmit Process State */
#define ETH_DMADSR_TPS_STOPPED                        ((uint32_t)0x00000000)   /* Stopped (Reset or Stop Transmit Command issued) */
#define ETH_DMADSR_TPS_FETCHING_Pos                   (12U)
#define ETH_DMADSR_TPS_FETCHING_Msk                   (0x1U << ETH_DMADSR_TPS_FETCHING_Pos) /*!< 0x00001000 */
#define ETH_DMADSR_TPS_FETCHING                       ETH_DMADSR_TPS_FETCHING_Msk /* Running (Fetching Tx Transfer Descriptor) */
#define ETH_DMADSR_TPS_WAITING_Pos                    (13U)
#define ETH_DMADSR_TPS_WAITING_Msk                    (0x1U << ETH_DMADSR_TPS_WAITING_Pos) /*!< 0x00002000 */
#define ETH_DMADSR_TPS_WAITING                        ETH_DMADSR_TPS_WAITING_Msk /* Running (Waiting for status) */
#define ETH_DMADSR_TPS_READING_Pos                    (12U)
#define ETH_DMADSR_TPS_READING_Msk                    (0x3U << ETH_DMADSR_TPS_READING_Pos) /*!< 0x00003000 */
#define ETH_DMADSR_TPS_READING                        ETH_DMADSR_TPS_READING_Msk /* Running (Reading Data from system memory buffer and queuing it to the Tx buffer (Tx FIFO)) */
#define ETH_DMADSR_TPS_TIMESTAMP_WR_Pos               (14U)
#define ETH_DMADSR_TPS_TIMESTAMP_WR_Msk               (0x1U << ETH_DMADSR_TPS_TIMESTAMP_WR_Pos) /*!< 0x00004000 */
#define ETH_DMADSR_TPS_TIMESTAMP_WR                   ETH_DMADSR_TPS_TIMESTAMP_WR_Msk /* Timestamp write state */
#define ETH_DMADSR_TPS_SUSPENDED_Pos                  (13U)
#define ETH_DMADSR_TPS_SUSPENDED_Msk                  (0x3U << ETH_DMADSR_TPS_SUSPENDED_Pos) /*!< 0x00006000 */
#define ETH_DMADSR_TPS_SUSPENDED                      ETH_DMADSR_TPS_SUSPENDED_Msk /* Suspended (Tx Descriptor Unavailable or Tx Buffer Underflow) */
#define ETH_DMADSR_TPS_CLOSING_Pos                    (12U)
#define ETH_DMADSR_TPS_CLOSING_Msk                    (0x7U << ETH_DMADSR_TPS_CLOSING_Pos) /*!< 0x00007000 */
#define ETH_DMADSR_TPS_CLOSING                        ETH_DMADSR_TPS_CLOSING_Msk /* Running (Closing Tx Descriptor) */
#define ETH_DMADSR_RPS_Pos                            (8U)
#define ETH_DMADSR_RPS_Msk                            (0xFU << ETH_DMADSR_RPS_Pos) /*!< 0x00000F00 */
#define ETH_DMADSR_RPS                                ETH_DMADSR_RPS_Msk       /* DMA Channel Receive Process State */
#define ETH_DMADSR_RPS_STOPPED                        ((uint32_t)0x00000000)   /* Stopped (Reset or Stop Receive Command issued) */
#define ETH_DMADSR_RPS_FETCHING_Pos                   (12U)
#define ETH_DMADSR_RPS_FETCHING_Msk                   (0x1U << ETH_DMADSR_RPS_FETCHING_Pos) /*!< 0x00001000 */
#define ETH_DMADSR_RPS_FETCHING                       ETH_DMADSR_RPS_FETCHING_Msk /* Running (Fetching Rx Transfer Descriptor) */
#define ETH_DMADSR_RPS_WAITING_Pos                    (12U)
#define ETH_DMADSR_RPS_WAITING_Msk                    (0x3U << ETH_DMADSR_RPS_WAITING_Pos) /*!< 0x00003000 */
#define ETH_DMADSR_RPS_WAITING                        ETH_DMADSR_RPS_WAITING_Msk /* Running (Waiting for status) */
#define ETH_DMADSR_RPS_SUSPENDED_Pos                  (14U)
#define ETH_DMADSR_RPS_SUSPENDED_Msk                  (0x1U << ETH_DMADSR_RPS_SUSPENDED_Pos) /*!< 0x00004000 */
#define ETH_DMADSR_RPS_SUSPENDED                      ETH_DMADSR_RPS_SUSPENDED_Msk /* Suspended (Rx Descriptor Unavailable) */
#define ETH_DMADSR_RPS_CLOSING_Pos                    (12U)
#define ETH_DMADSR_RPS_CLOSING_Msk                    (0x5U << ETH_DMADSR_RPS_CLOSING_Pos) /*!< 0x00005000 */
#define ETH_DMADSR_RPS_CLOSING                        ETH_DMADSR_RPS_CLOSING_Msk /* Running (Closing the Rx Descriptor) */
#define ETH_DMADSR_RPS_TIMESTAMP_WR_Pos               (13U)
#define ETH_DMADSR_RPS_TIMESTAMP_WR_Msk               (0x3U << ETH_DMADSR_RPS_TIMESTAMP_WR_Pos) /*!< 0x00006000 */
#define ETH_DMADSR_RPS_TIMESTAMP_WR                   ETH_DMADSR_RPS_TIMESTAMP_WR_Msk /* Timestamp write state */
#define ETH_DMADSR_RPS_TRANSFERRING_Pos               (12U)
#define ETH_DMADSR_RPS_TRANSFERRING_Msk               (0x7U << ETH_DMADSR_RPS_TRANSFERRING_Pos) /*!< 0x00007000 */
#define ETH_DMADSR_RPS_TRANSFERRING                   ETH_DMADSR_RPS_TRANSFERRING_Msk /* Running (Transferring the received packet data from the Rx buffer to the system memory) */

/* Bit definition for Ethernet DMA Channel Control Register */
#define ETH_DMACCR_DSL_Pos                            (18U)
#define ETH_DMACCR_DSL_Msk                            (0x7U << ETH_DMACCR_DSL_Pos) /*!< 0x001C0000 */
#define ETH_DMACCR_DSL                                ETH_DMACCR_DSL_Msk       /* Descriptor Skip Length */
#define ETH_DMACCR_DSL_0BIT                           ((uint32_t)0x00000000)
#define ETH_DMACCR_DSL_32BIT                          ((uint32_t)0x00040000)
#define ETH_DMACCR_DSL_64BIT                          ((uint32_t)0x00080000)
#define ETH_DMACCR_DSL_128BIT                         ((uint32_t)0x00100000)
#define ETH_DMACCR_8PBL                               ((uint32_t)0x00010000)   /* 8xPBL mode */
#define ETH_DMACCR_MSS_Pos                            (0U)
#define ETH_DMACCR_MSS_Msk                            (0x3FFFU << ETH_DMACCR_MSS_Pos) /*!< 0x00003FFF */
#define ETH_DMACCR_MSS                                ETH_DMACCR_MSS_Msk       /* Maximum Segment Size */

/* Bit definition for Ethernet DMA Channel Tx Control Register */
#define ETH_DMACTCR_TPBL_Pos                          (16U)
#define ETH_DMACTCR_TPBL_Msk                          (0x3FU << ETH_DMACTCR_TPBL_Pos) /*!< 0x003F0000 */
#define ETH_DMACTCR_TPBL                              ETH_DMACTCR_TPBL_Msk     /* Transmit Programmable Burst Length */
#define ETH_DMACTCR_TPBL_1PBL                         ((uint32_t)0x00010000)   /* Transmit Programmable Burst Length 1 */
#define ETH_DMACTCR_TPBL_2PBL                         ((uint32_t)0x00020000)   /* Transmit Programmable Burst Length 2 */
#define ETH_DMACTCR_TPBL_4PBL                         ((uint32_t)0x00040000)   /* Transmit Programmable Burst Length 4 */
#define ETH_DMACTCR_TPBL_8PBL                         ((uint32_t)0x00080000)   /* Transmit Programmable Burst Length 8 */
#define ETH_DMACTCR_TPBL_16PBL                        ((uint32_t)0x00100000)   /* Transmit Programmable Burst Length 16 */
#define ETH_DMACTCR_TPBL_32PBL                        ((uint32_t)0x00200000)   /* Transmit Programmable Burst Length 32 */
#define ETH_DMACTCR_TSE_Pos                           (12U)
#define ETH_DMACTCR_TSE_Msk                           (0x1U << ETH_DMACTCR_TSE_Pos) /*!< 0x00001000 */
#define ETH_DMACTCR_TSE                               ETH_DMACTCR_TSE_Msk      /* TCP Segmentation Enabled */
#define ETH_DMACTCR_OSP_Pos                           (4U)
#define ETH_DMACTCR_OSP_Msk                           (0x1U << ETH_DMACTCR_OSP_Pos) /*!< 0x00000010 */
#define ETH_DMACTCR_OSP                               ETH_DMACTCR_OSP_Msk      /* Operate on Second Packet */
#define ETH_DMACTCR_ST_Pos                            (0U)
#define ETH_DMACTCR_ST_Msk                            (0x1U << ETH_DMACTCR_ST_Pos) /*!< 0x00000001 */
#define ETH_DMACTCR_ST                                ETH_DMACTCR_ST_Msk       /* Start or Stop Transmission Command */

/* Bit definition for Ethernet DMA Channel Rx Control Register */
#define ETH_DMACRCR_RPF_Pos                           (31U)
#define ETH_DMACRCR_RPF_Msk                           (0x1U << ETH_DMACRCR_RPF_Pos) /*!< 0x80000000 */
#define ETH_DMACRCR_RPF                               ETH_DMACRCR_RPF_Msk      /* Rx Packet Flush */
#define ETH_DMACRCR_RPBL_Pos                          (16U)
#define ETH_DMACRCR_RPBL_Msk                          (0x3FU << ETH_DMACRCR_RPBL_Pos) /*!< 0x003F0000 */
#define ETH_DMACRCR_RPBL                              ETH_DMACRCR_RPBL_Msk     /* Receive Programmable Burst Length */
#define ETH_DMACRCR_RPBL_1PBL                         ((uint32_t)0x00010000)   /* Receive Programmable Burst Length 1 */
#define ETH_DMACRCR_RPBL_2PBL                         ((uint32_t)0x00020000)   /* Receive Programmable Burst Length 2 */
#define ETH_DMACRCR_RPBL_4PBL                         ((uint32_t)0x00040000)   /* Receive Programmable Burst Length 4 */
#define ETH_DMACRCR_RPBL_8PBL                         ((uint32_t)0x00080000)   /* Receive Programmable Burst Length 8 */
#define ETH_DMACRCR_RPBL_16PBL                        ((uint32_t)0x00100000)   /* Receive Programmable Burst Length 16 */
#define ETH_DMACRCR_RPBL_32PBL                        ((uint32_t)0x00200000)   /* Receive Programmable Burst Length 32 */
#define ETH_DMACRCR_RBSZ_Pos                          (1U)
#define ETH_DMACRCR_RBSZ_Msk                          (0x3FFFU << ETH_DMACRCR_RBSZ_Pos) /*!< 0x00007FFE */
#define ETH_DMACRCR_RBSZ                              ETH_DMACRCR_RBSZ_Msk     /* Receive Buffer size */
#define ETH_DMACRCR_SR_Pos                            (0U)
#define ETH_DMACRCR_SR_Msk                            (0x1U << ETH_DMACRCR_SR_Pos) /*!< 0x00000001 */
#define ETH_DMACRCR_SR                                ETH_DMACRCR_SR_Msk       /* Start or Stop Receive */

/* Bit definition for Ethernet DMA CH Tx Desc List Address Register */
#define ETH_DMACTDLAR_TDESLA_Pos                      (2U)
#define ETH_DMACTDLAR_TDESLA_Msk                      (0x3FFFFFFFU << ETH_DMACTDLAR_TDESLA_Pos) /*!< 0xFFFFFFFC */
#define ETH_DMACTDLAR_TDESLA                          ETH_DMACTDLAR_TDESLA_Msk /* Start of Transmit List */

/* Bit definition for Ethernet DMA CH Rx Desc List Address Register */
#define ETH_DMACRDLAR_RDESLA_Pos                      (2U)
#define ETH_DMACRDLAR_RDESLA_Msk                      (0x3FFFFFFFU << ETH_DMACRDLAR_RDESLA_Pos) /*!< 0xFFFFFFFC */
#define ETH_DMACRDLAR_RDESLA                          ETH_DMACRDLAR_RDESLA_Msk /* Start of Receive List */

/* Bit definition for Ethernet DMA CH Tx Desc Tail Pointer Register */
#define ETH_DMACTDTPR_TDT_Pos                         (2U)
#define ETH_DMACTDTPR_TDT_Msk                         (0x3FFFFFFFU << ETH_DMACTDTPR_TDT_Pos) /*!< 0xFFFFFFFC */
#define ETH_DMACTDTPR_TDT                             ETH_DMACTDTPR_TDT_Msk    /* Transmit Descriptor Tail Pointer */

/* Bit definition for Ethernet DMA CH Rx Desc Tail Pointer Register */
#define ETH_DMACRDTPR_RDT_Pos                         (2U)
#define ETH_DMACRDTPR_RDT_Msk                         (0x3FFFFFFFU << ETH_DMACRDTPR_RDT_Pos) /*!< 0xFFFFFFFC */
#define ETH_DMACRDTPR_RDT                             ETH_DMACRDTPR_RDT_Msk    /* Receive Descriptor Tail Pointer */

/* Bit definition for Ethernet DMA CH Tx Desc Ring Length Register */
#define ETH_DMACTDRLR_TDRL_Pos                        (0U)
#define ETH_DMACTDRLR_TDRL_Msk                        (0x3FFU << ETH_DMACTDRLR_TDRL_Pos) /*!< 0x000003FF */
#define ETH_DMACTDRLR_TDRL                            ETH_DMACTDRLR_TDRL_Msk   /* Transmit Descriptor Ring Length */

/* Bit definition for Ethernet DMA CH Rx Desc Ring Length Register */
#define ETH_DMACRDRLR_RDRL_Pos                        (0U)
#define ETH_DMACRDRLR_RDRL_Msk                        (0x3FFU << ETH_DMACRDRLR_RDRL_Pos) /*!< 0x000003FF */
#define ETH_DMACRDRLR_RDRL                            ETH_DMACRDRLR_RDRL_Msk   /* Receive Descriptor Ring Length */

/* Bit definition for Ethernet DMA Channel Interrupt Enable Register */
#define ETH_DMACIER_NIE_Pos                           (15U)
#define ETH_DMACIER_NIE_Msk                           (0x1U << ETH_DMACIER_NIE_Pos) /*!< 0x00008000 */
#define ETH_DMACIER_NIE                               ETH_DMACIER_NIE_Msk      /* Normal Interrupt Summary Enable */
#define ETH_DMACIER_AIE_Pos                           (14U)
#define ETH_DMACIER_AIE_Msk                           (0x1U << ETH_DMACIER_AIE_Pos) /*!< 0x00004000 */
#define ETH_DMACIER_AIE                               ETH_DMACIER_AIE_Msk      /* Abnormal Interrupt Summary Enable */
#define ETH_DMACIER_CDEE_Pos                          (13U)
#define ETH_DMACIER_CDEE_Msk                          (0x1U << ETH_DMACIER_CDEE_Pos) /*!< 0x00002000 */
#define ETH_DMACIER_CDEE                              ETH_DMACIER_CDEE_Msk     /* Context Descriptor Error Enable */
#define ETH_DMACIER_FBEE_Pos                          (12U)
#define ETH_DMACIER_FBEE_Msk                          (0x1U << ETH_DMACIER_FBEE_Pos) /*!< 0x00001000 */
#define ETH_DMACIER_FBEE                              ETH_DMACIER_FBEE_Msk     /* Fatal Bus Error Enable */
#define ETH_DMACIER_ERIE_Pos                          (11U)
#define ETH_DMACIER_ERIE_Msk                          (0x1U << ETH_DMACIER_ERIE_Pos) /*!< 0x00000800 */
#define ETH_DMACIER_ERIE                              ETH_DMACIER_ERIE_Msk     /* Early Receive Interrupt Enable */
#define ETH_DMACIER_ETIE_Pos                          (10U)
#define ETH_DMACIER_ETIE_Msk                          (0x1U << ETH_DMACIER_ETIE_Pos) /*!< 0x00000400 */
#define ETH_DMACIER_ETIE                              ETH_DMACIER_ETIE_Msk     /* Early Transmit Interrupt Enable */
#define ETH_DMACIER_RWTE_Pos                          (9U)
#define ETH_DMACIER_RWTE_Msk                          (0x1U << ETH_DMACIER_RWTE_Pos) /*!< 0x00000200 */
#define ETH_DMACIER_RWTE                              ETH_DMACIER_RWTE_Msk     /* Receive Watchdog Timeout Enable */
#define ETH_DMACIER_RSE_Pos                           (8U)
#define ETH_DMACIER_RSE_Msk                           (0x1U << ETH_DMACIER_RSE_Pos) /*!< 0x00000100 */
#define ETH_DMACIER_RSE                               ETH_DMACIER_RSE_Msk      /* Receive Stopped Enable */
#define ETH_DMACIER_RBUE_Pos                          (7U)
#define ETH_DMACIER_RBUE_Msk                          (0x1U << ETH_DMACIER_RBUE_Pos) /*!< 0x00000080 */
#define ETH_DMACIER_RBUE                              ETH_DMACIER_RBUE_Msk     /* Receive Buffer Unavailable Enable */
#define ETH_DMACIER_RIE_Pos                           (6U)
#define ETH_DMACIER_RIE_Msk                           (0x1U << ETH_DMACIER_RIE_Pos) /*!< 0x00000040 */
#define ETH_DMACIER_RIE                               ETH_DMACIER_RIE_Msk      /* Receive Interrupt Enable */
#define ETH_DMACIER_TBUE_Pos                          (2U)
#define ETH_DMACIER_TBUE_Msk                          (0x1U << ETH_DMACIER_TBUE_Pos) /*!< 0x00000004 */
#define ETH_DMACIER_TBUE                              ETH_DMACIER_TBUE_Msk     /* Transmit Buffer Unavailable Enable */
#define ETH_DMACIER_TXSE_Pos                          (1U)
#define ETH_DMACIER_TXSE_Msk                          (0x1U << ETH_DMACIER_TXSE_Pos) /*!< 0x00000002 */
#define ETH_DMACIER_TXSE                              ETH_DMACIER_TXSE_Msk     /* Transmit Stopped Enable */
#define ETH_DMACIER_TIE_Pos                           (0U)
#define ETH_DMACIER_TIE_Msk                           (0x1U << ETH_DMACIER_TIE_Pos) /*!< 0x00000001 */
#define ETH_DMACIER_TIE                               ETH_DMACIER_TIE_Msk      /* Transmit Interrupt Enable */

/* Bit definition for Ethernet DMA Channel Rx Interrupt Watchdog Timer Register */
#define ETH_DMACRIWTR_RWT_Pos                         (0U)
#define ETH_DMACRIWTR_RWT_Msk                         (0xFFU << ETH_DMACRIWTR_RWT_Pos) /*!< 0x000000FF */
#define ETH_DMACRIWTR_RWT                             ETH_DMACRIWTR_RWT_Msk    /* Receive Interrupt Watchdog Timer Count */

/* Bit definition for Ethernet DMA Channel Current App Tx Desc Register */
#define ETH_DMACCATDR_CURTDESAPTR_Pos                 (0U)
#define ETH_DMACCATDR_CURTDESAPTR_Msk                 (0xFFFFFFFFU << ETH_DMACCATDR_CURTDESAPTR_Pos) /*!< 0xFFFFFFFF */
#define ETH_DMACCATDR_CURTDESAPTR                     ETH_DMACCATDR_CURTDESAPTR_Msk /* Application Transmit Descriptor Address Pointer */

/* Bit definition for Ethernet DMA Channel Current App Rx Desc Register */
#define ETH_DMACCARDR_CURRDESAPTR_Pos                 (0U)
#define ETH_DMACCARDR_CURRDESAPTR_Msk                 (0xFFFFFFFFU << ETH_DMACCARDR_CURRDESAPTR_Pos) /*!< 0xFFFFFFFF */
#define ETH_DMACCARDR_CURRDESAPTR                     ETH_DMACCARDR_CURRDESAPTR_Msk /* Application Receive Descriptor Address Pointer */

/* Bit definition for Ethernet DMA Channel Current App Tx Buffer Register */
#define ETH_DMACCATBR_CURTBUFAPTR_Pos                 (0U)
#define ETH_DMACCATBR_CURTBUFAPTR_Msk                 (0xFFFFFFFFU << ETH_DMACCATBR_CURTBUFAPTR_Pos) /*!< 0xFFFFFFFF */
#define ETH_DMACCATBR_CURTBUFAPTR                     ETH_DMACCATBR_CURTBUFAPTR_Msk /* Application Transmit Buffer Address Pointer */

/* Bit definition for Ethernet DMA Channel Current App Rx Buffer Register */
#define ETH_DMACCARBR_CURRBUFAPTR_Pos                 (0U)
#define ETH_DMACCARBR_CURRBUFAPTR_Msk                 (0xFFFFFFFFU << ETH_DMACCARBR_CURRBUFAPTR_Pos) /*!< 0xFFFFFFFF */
#define ETH_DMACCARBR_CURRBUFAPTR                     ETH_DMACCARBR_CURRBUFAPTR_Msk /* Application Receive Buffer Address Pointer */

/* Bit definition for Ethernet DMA Channel Status Register */
#define ETH_DMACSR_REB_Pos                            (19U)
#define ETH_DMACSR_REB_Msk                            (0x7U << ETH_DMACSR_REB_Pos) /*!< 0x00380000 */
#define ETH_DMACSR_REB                                ETH_DMACSR_REB_Msk       /* Rx DMA Error Bits */
#define ETH_DMACSR_TEB_Pos                            (16U)
#define ETH_DMACSR_TEB_Msk                            (0x7U << ETH_DMACSR_TEB_Pos) /*!< 0x00070000 */
#define ETH_DMACSR_TEB                                ETH_DMACSR_TEB_Msk       /* Tx DMA Error Bits */
#define ETH_DMACSR_NIS_Pos                            (15U)
#define ETH_DMACSR_NIS_Msk                            (0x1U << ETH_DMACSR_NIS_Pos) /*!< 0x00008000 */
#define ETH_DMACSR_NIS                                ETH_DMACSR_NIS_Msk       /* Normal Interrupt Summary */
#define ETH_DMACSR_AIS_Pos                            (14U)
#define ETH_DMACSR_AIS_Msk                            (0x1U << ETH_DMACSR_AIS_Pos) /*!< 0x00004000 */
#define ETH_DMACSR_AIS                                ETH_DMACSR_AIS_Msk       /* Abnormal Interrupt Summary */
#define ETH_DMACSR_CDE_Pos                            (13U)
#define ETH_DMACSR_CDE_Msk                            (0x1U << ETH_DMACSR_CDE_Pos) /*!< 0x00002000 */
#define ETH_DMACSR_CDE                                ETH_DMACSR_CDE_Msk       /* Context Descriptor Error */
#define ETH_DMACSR_FBE_Pos                            (12U)
#define ETH_DMACSR_FBE_Msk                            (0x1U << ETH_DMACSR_FBE_Pos) /*!< 0x00001000 */
#define ETH_DMACSR_FBE                                ETH_DMACSR_FBE_Msk       /* Fatal Bus Error */
#define ETH_DMACSR_ERI_Pos                            (11U)
#define ETH_DMACSR_ERI_Msk                            (0x1U << ETH_DMACSR_ERI_Pos) /*!< 0x00000800 */
#define ETH_DMACSR_ERI                                ETH_DMACSR_ERI_Msk       /* Early Receive Interrupt */
#define ETH_DMACSR_ETI_Pos                            (10U)
#define ETH_DMACSR_ETI_Msk                            (0x1U << ETH_DMACSR_ETI_Pos) /*!< 0x00000400 */
#define ETH_DMACSR_ETI                                ETH_DMACSR_ETI_Msk       /* Early Transmit Interrupt */
#define ETH_DMACSR_RWT_Pos                            (9U)
#define ETH_DMACSR_RWT_Msk                            (0x1U << ETH_DMACSR_RWT_Pos) /*!< 0x00000200 */
#define ETH_DMACSR_RWT                                ETH_DMACSR_RWT_Msk       /* Receive Watchdog Timeout */
#define ETH_DMACSR_RPS_Pos                            (8U)
#define ETH_DMACSR_RPS_Msk                            (0x1U << ETH_DMACSR_RPS_Pos) /*!< 0x00000100 */
#define ETH_DMACSR_RPS                                ETH_DMACSR_RPS_Msk       /* Receive Process Stopped */
#define ETH_DMACSR_RBU_Pos                            (7U)
#define ETH_DMACSR_RBU_Msk                            (0x1U << ETH_DMACSR_RBU_Pos) /*!< 0x00000080 */
#define ETH_DMACSR_RBU                                ETH_DMACSR_RBU_Msk       /* Receive Buffer Unavailable */
#define ETH_DMACSR_RI_Pos                             (6U)
#define ETH_DMACSR_RI_Msk                             (0x1U << ETH_DMACSR_RI_Pos) /*!< 0x00000040 */
#define ETH_DMACSR_RI                                 ETH_DMACSR_RI_Msk        /* Receive Interrupt */
#define ETH_DMACSR_TBU_Pos                            (2U)
#define ETH_DMACSR_TBU_Msk                            (0x1U << ETH_DMACSR_TBU_Pos) /*!< 0x00000004 */
#define ETH_DMACSR_TBU                                ETH_DMACSR_TBU_Msk       /* Transmit Buffer Unavailable */
#define ETH_DMACSR_TPS_Pos                            (1U)
#define ETH_DMACSR_TPS_Msk                            (0x1U << ETH_DMACSR_TPS_Pos) /*!< 0x00000002 */
#define ETH_DMACSR_TPS                                ETH_DMACSR_TPS_Msk       /* Transmit Process Stopped */
#define ETH_DMACSR_TI_Pos                             (0U)
#define ETH_DMACSR_TI_Msk                             (0x1U << ETH_DMACSR_TI_Pos) /*!< 0x00000001 */
#define ETH_DMACSR_TI                                 ETH_DMACSR_TI_Msk        /* Transmit Interrupt */

/* Bit definition for Ethernet DMA Channel missed frame count register */
#define ETH_DMACMFCR_MFCO_Pos                         (15U)
#define ETH_DMACMFCR_MFCO_Msk                         (0x1U << ETH_DMACMFCR_MFCO_Pos) /*!< 0x00008000 */
#define ETH_DMACMFCR_MFCO                             ETH_DMACMFCR_MFCO_Msk    /* Overflow status of the MFC Counter */
#define ETH_DMACMFCR_MFC_Pos                          (0U)
#define ETH_DMACMFCR_MFC_Msk                          (0x7FFU << ETH_DMACMFCR_MFC_Pos) /*!< 0x000007FF */
#define ETH_DMACMFCR_MFC                              ETH_DMACMFCR_MFC_Msk     /* The number of packet counters dropped by the DMA */


/******************************************************************************/
/*                                                                            */
/*                             DMA Controller                                 */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for DMA_SxCR register  *****************/
#define DMA_SxCR_MBURST_Pos      (23U)
#define DMA_SxCR_MBURST_Msk      (0x3U << DMA_SxCR_MBURST_Pos)                 /*!< 0x01800000 */
#define DMA_SxCR_MBURST          DMA_SxCR_MBURST_Msk
#define DMA_SxCR_MBURST_0        (0x1U << DMA_SxCR_MBURST_Pos)                 /*!< 0x00800000 */
#define DMA_SxCR_MBURST_1        (0x2U << DMA_SxCR_MBURST_Pos)                 /*!< 0x01000000 */
#define DMA_SxCR_PBURST_Pos      (21U)
#define DMA_SxCR_PBURST_Msk      (0x3U << DMA_SxCR_PBURST_Pos)                 /*!< 0x00600000 */
#define DMA_SxCR_PBURST          DMA_SxCR_PBURST_Msk
#define DMA_SxCR_PBURST_0        (0x1U << DMA_SxCR_PBURST_Pos)                 /*!< 0x00200000 */
#define DMA_SxCR_PBURST_1        (0x2U << DMA_SxCR_PBURST_Pos)                 /*!< 0x00400000 */
#define DMA_SxCR_ACK_Pos         (20U)
#define DMA_SxCR_ACK_Msk         (0x1U << DMA_SxCR_ACK_Pos)                    /*!< 0x00100000 */
#define DMA_SxCR_ACK             DMA_SxCR_ACK_Msk
#define DMA_SxCR_CT_Pos          (19U)
#define DMA_SxCR_CT_Msk          (0x1U << DMA_SxCR_CT_Pos)                     /*!< 0x00080000 */
#define DMA_SxCR_CT              DMA_SxCR_CT_Msk
#define DMA_SxCR_DBM_Pos         (18U)
#define DMA_SxCR_DBM_Msk         (0x1U << DMA_SxCR_DBM_Pos)                    /*!< 0x00040000 */
#define DMA_SxCR_DBM             DMA_SxCR_DBM_Msk
#define DMA_SxCR_PL_Pos          (16U)
#define DMA_SxCR_PL_Msk          (0x3U << DMA_SxCR_PL_Pos)                     /*!< 0x00030000 */
#define DMA_SxCR_PL              DMA_SxCR_PL_Msk
#define DMA_SxCR_PL_0            (0x1U << DMA_SxCR_PL_Pos)                     /*!< 0x00010000 */
#define DMA_SxCR_PL_1            (0x2U << DMA_SxCR_PL_Pos)                     /*!< 0x00020000 */
#define DMA_SxCR_PINCOS_Pos      (15U)
#define DMA_SxCR_PINCOS_Msk      (0x1U << DMA_SxCR_PINCOS_Pos)                 /*!< 0x00008000 */
#define DMA_SxCR_PINCOS          DMA_SxCR_PINCOS_Msk
#define DMA_SxCR_MSIZE_Pos       (13U)
#define DMA_SxCR_MSIZE_Msk       (0x3U << DMA_SxCR_MSIZE_Pos)                  /*!< 0x00006000 */
#define DMA_SxCR_MSIZE           DMA_SxCR_MSIZE_Msk
#define DMA_SxCR_MSIZE_0         (0x1U << DMA_SxCR_MSIZE_Pos)                  /*!< 0x00002000 */
#define DMA_SxCR_MSIZE_1         (0x2U << DMA_SxCR_MSIZE_Pos)                  /*!< 0x00004000 */
#define DMA_SxCR_PSIZE_Pos       (11U)
#define DMA_SxCR_PSIZE_Msk       (0x3U << DMA_SxCR_PSIZE_Pos)                  /*!< 0x00001800 */
#define DMA_SxCR_PSIZE           DMA_SxCR_PSIZE_Msk
#define DMA_SxCR_PSIZE_0         (0x1U << DMA_SxCR_PSIZE_Pos)                  /*!< 0x00000800 */
#define DMA_SxCR_PSIZE_1         (0x2U << DMA_SxCR_PSIZE_Pos)                  /*!< 0x00001000 */
#define DMA_SxCR_MINC_Pos        (10U)
#define DMA_SxCR_MINC_Msk        (0x1U << DMA_SxCR_MINC_Pos)                   /*!< 0x00000400 */
#define DMA_SxCR_MINC            DMA_SxCR_MINC_Msk
#define DMA_SxCR_PINC_Pos        (9U)
#define DMA_SxCR_PINC_Msk        (0x1U << DMA_SxCR_PINC_Pos)                   /*!< 0x00000200 */
#define DMA_SxCR_PINC            DMA_SxCR_PINC_Msk
#define DMA_SxCR_CIRC_Pos        (8U)
#define DMA_SxCR_CIRC_Msk        (0x1U << DMA_SxCR_CIRC_Pos)                   /*!< 0x00000100 */
#define DMA_SxCR_CIRC            DMA_SxCR_CIRC_Msk
#define DMA_SxCR_DIR_Pos         (6U)
#define DMA_SxCR_DIR_Msk         (0x3U << DMA_SxCR_DIR_Pos)                    /*!< 0x000000C0 */
#define DMA_SxCR_DIR             DMA_SxCR_DIR_Msk
#define DMA_SxCR_DIR_0           (0x1U << DMA_SxCR_DIR_Pos)                    /*!< 0x00000040 */
#define DMA_SxCR_DIR_1           (0x2U << DMA_SxCR_DIR_Pos)                    /*!< 0x00000080 */
#define DMA_SxCR_PFCTRL_Pos      (5U)
#define DMA_SxCR_PFCTRL_Msk      (0x1U << DMA_SxCR_PFCTRL_Pos)                 /*!< 0x00000020 */
#define DMA_SxCR_PFCTRL          DMA_SxCR_PFCTRL_Msk
#define DMA_SxCR_TCIE_Pos        (4U)
#define DMA_SxCR_TCIE_Msk        (0x1U << DMA_SxCR_TCIE_Pos)                   /*!< 0x00000010 */
#define DMA_SxCR_TCIE            DMA_SxCR_TCIE_Msk
#define DMA_SxCR_HTIE_Pos        (3U)
#define DMA_SxCR_HTIE_Msk        (0x1U << DMA_SxCR_HTIE_Pos)                   /*!< 0x00000008 */
#define DMA_SxCR_HTIE            DMA_SxCR_HTIE_Msk
#define DMA_SxCR_TEIE_Pos        (2U)
#define DMA_SxCR_TEIE_Msk        (0x1U << DMA_SxCR_TEIE_Pos)                   /*!< 0x00000004 */
#define DMA_SxCR_TEIE            DMA_SxCR_TEIE_Msk
#define DMA_SxCR_DMEIE_Pos       (1U)
#define DMA_SxCR_DMEIE_Msk       (0x1U << DMA_SxCR_DMEIE_Pos)                  /*!< 0x00000002 */
#define DMA_SxCR_DMEIE           DMA_SxCR_DMEIE_Msk
#define DMA_SxCR_EN_Pos          (0U)
#define DMA_SxCR_EN_Msk          (0x1U << DMA_SxCR_EN_Pos)                     /*!< 0x00000001 */
#define DMA_SxCR_EN              DMA_SxCR_EN_Msk

/********************  Bits definition for DMA_SxCNDTR register  **************/
#define DMA_SxNDT_Pos            (0U)
#define DMA_SxNDT_Msk            (0xFFFFU << DMA_SxNDT_Pos)                    /*!< 0x0000FFFF */
#define DMA_SxNDT                DMA_SxNDT_Msk
#define DMA_SxNDT_0              (0x0001U << DMA_SxNDT_Pos)                    /*!< 0x00000001 */
#define DMA_SxNDT_1              (0x0002U << DMA_SxNDT_Pos)                    /*!< 0x00000002 */
#define DMA_SxNDT_2              (0x0004U << DMA_SxNDT_Pos)                    /*!< 0x00000004 */
#define DMA_SxNDT_3              (0x0008U << DMA_SxNDT_Pos)                    /*!< 0x00000008 */
#define DMA_SxNDT_4              (0x0010U << DMA_SxNDT_Pos)                    /*!< 0x00000010 */
#define DMA_SxNDT_5              (0x0020U << DMA_SxNDT_Pos)                    /*!< 0x00000020 */
#define DMA_SxNDT_6              (0x0040U << DMA_SxNDT_Pos)                    /*!< 0x00000040 */
#define DMA_SxNDT_7              (0x0080U << DMA_SxNDT_Pos)                    /*!< 0x00000080 */
#define DMA_SxNDT_8              (0x0100U << DMA_SxNDT_Pos)                    /*!< 0x00000100 */
#define DMA_SxNDT_9              (0x0200U << DMA_SxNDT_Pos)                    /*!< 0x00000200 */
#define DMA_SxNDT_10             (0x0400U << DMA_SxNDT_Pos)                    /*!< 0x00000400 */
#define DMA_SxNDT_11             (0x0800U << DMA_SxNDT_Pos)                    /*!< 0x00000800 */
#define DMA_SxNDT_12             (0x1000U << DMA_SxNDT_Pos)                    /*!< 0x00001000 */
#define DMA_SxNDT_13             (0x2000U << DMA_SxNDT_Pos)                    /*!< 0x00002000 */
#define DMA_SxNDT_14             (0x4000U << DMA_SxNDT_Pos)                    /*!< 0x00004000 */
#define DMA_SxNDT_15             (0x8000U << DMA_SxNDT_Pos)                    /*!< 0x00008000 */

/********************  Bits definition for DMA_SxFCR register  ****************/
#define DMA_SxFCR_FEIE_Pos       (7U)
#define DMA_SxFCR_FEIE_Msk       (0x1U << DMA_SxFCR_FEIE_Pos)                  /*!< 0x00000080 */
#define DMA_SxFCR_FEIE           DMA_SxFCR_FEIE_Msk
#define DMA_SxFCR_FS_Pos         (3U)
#define DMA_SxFCR_FS_Msk         (0x7U << DMA_SxFCR_FS_Pos)                    /*!< 0x00000038 */
#define DMA_SxFCR_FS             DMA_SxFCR_FS_Msk
#define DMA_SxFCR_FS_0           (0x1U << DMA_SxFCR_FS_Pos)                    /*!< 0x00000008 */
#define DMA_SxFCR_FS_1           (0x2U << DMA_SxFCR_FS_Pos)                    /*!< 0x00000010 */
#define DMA_SxFCR_FS_2           (0x4U << DMA_SxFCR_FS_Pos)                    /*!< 0x00000020 */
#define DMA_SxFCR_DMDIS_Pos      (2U)
#define DMA_SxFCR_DMDIS_Msk      (0x1U << DMA_SxFCR_DMDIS_Pos)                 /*!< 0x00000004 */
#define DMA_SxFCR_DMDIS          DMA_SxFCR_DMDIS_Msk
#define DMA_SxFCR_FTH_Pos        (0U)
#define DMA_SxFCR_FTH_Msk        (0x3U << DMA_SxFCR_FTH_Pos)                   /*!< 0x00000003 */
#define DMA_SxFCR_FTH            DMA_SxFCR_FTH_Msk
#define DMA_SxFCR_FTH_0          (0x1U << DMA_SxFCR_FTH_Pos)                   /*!< 0x00000001 */
#define DMA_SxFCR_FTH_1          (0x2U << DMA_SxFCR_FTH_Pos)                   /*!< 0x00000002 */

/******************  Bit definition for DMA_CPAR register  ********************/
#define DMA_SxPAR_PA_Pos         (0U)
#define DMA_SxPAR_PA_Msk         (0xFFFFFFFFU << DMA_SxPAR_PA_Pos)             /*!< 0xFFFFFFFF */
#define DMA_SxPAR_PA             DMA_SxPAR_PA_Msk                              /*!< Peripheral Address */

/******************  Bit definition for DMA_CMAR register  ********************/
#define DMA_SxM0AR_M0A_Pos        (0U)
#define DMA_SxM0AR_M0A_Msk        (0xFFFFFFFFU << DMA_SxM0AR_M0A_Pos)            /*!< 0xFFFFFFFF */
#define DMA_SxM0AR_M0A            DMA_SxM0AR_M0A_Msk                             /*!< Memory Address    */
#define DMA_SxM1AR_M1A_Pos        (0U)
#define DMA_SxM1AR_M1A_Msk        (0xFFFFFFFFU << DMA_SxM1AR_M1A_Pos)            /*!< 0xFFFFFFFF */
#define DMA_SxM1AR_M1A            DMA_SxM1AR_M1A_Msk                             /*!< Memory Address    */

/********************  Bits definition for DMA_LISR register  *****************/
#define DMA_LISR_TCIF3_Pos       (27U)
#define DMA_LISR_TCIF3_Msk       (0x1U << DMA_LISR_TCIF3_Pos)                  /*!< 0x08000000 */
#define DMA_LISR_TCIF3           DMA_LISR_TCIF3_Msk
#define DMA_LISR_HTIF3_Pos       (26U)
#define DMA_LISR_HTIF3_Msk       (0x1U << DMA_LISR_HTIF3_Pos)                  /*!< 0x04000000 */
#define DMA_LISR_HTIF3           DMA_LISR_HTIF3_Msk
#define DMA_LISR_TEIF3_Pos       (25U)
#define DMA_LISR_TEIF3_Msk       (0x1U << DMA_LISR_TEIF3_Pos)                  /*!< 0x02000000 */
#define DMA_LISR_TEIF3           DMA_LISR_TEIF3_Msk
#define DMA_LISR_DMEIF3_Pos      (24U)
#define DMA_LISR_DMEIF3_Msk      (0x1U << DMA_LISR_DMEIF3_Pos)                 /*!< 0x01000000 */
#define DMA_LISR_DMEIF3          DMA_LISR_DMEIF3_Msk
#define DMA_LISR_FEIF3_Pos       (22U)
#define DMA_LISR_FEIF3_Msk       (0x1U << DMA_LISR_FEIF3_Pos)                  /*!< 0x00400000 */
#define DMA_LISR_FEIF3           DMA_LISR_FEIF3_Msk
#define DMA_LISR_TCIF2_Pos       (21U)
#define DMA_LISR_TCIF2_Msk       (0x1U << DMA_LISR_TCIF2_Pos)                  /*!< 0x00200000 */
#define DMA_LISR_TCIF2           DMA_LISR_TCIF2_Msk
#define DMA_LISR_HTIF2_Pos       (20U)
#define DMA_LISR_HTIF2_Msk       (0x1U << DMA_LISR_HTIF2_Pos)                  /*!< 0x00100000 */
#define DMA_LISR_HTIF2           DMA_LISR_HTIF2_Msk
#define DMA_LISR_TEIF2_Pos       (19U)
#define DMA_LISR_TEIF2_Msk       (0x1U << DMA_LISR_TEIF2_Pos)                  /*!< 0x00080000 */
#define DMA_LISR_TEIF2           DMA_LISR_TEIF2_Msk
#define DMA_LISR_DMEIF2_Pos      (18U)
#define DMA_LISR_DMEIF2_Msk      (0x1U << DMA_LISR_DMEIF2_Pos)                 /*!< 0x00040000 */
#define DMA_LISR_DMEIF2          DMA_LISR_DMEIF2_Msk
#define DMA_LISR_FEIF2_Pos       (16U)
#define DMA_LISR_FEIF2_Msk       (0x1U << DMA_LISR_FEIF2_Pos)                  /*!< 0x00010000 */
#define DMA_LISR_FEIF2           DMA_LISR_FEIF2_Msk
#define DMA_LISR_TCIF1_Pos       (11U)
#define DMA_LISR_TCIF1_Msk       (0x1U << DMA_LISR_TCIF1_Pos)                  /*!< 0x00000800 */
#define DMA_LISR_TCIF1           DMA_LISR_TCIF1_Msk
#define DMA_LISR_HTIF1_Pos       (10U)
#define DMA_LISR_HTIF1_Msk       (0x1U << DMA_LISR_HTIF1_Pos)                  /*!< 0x00000400 */
#define DMA_LISR_HTIF1           DMA_LISR_HTIF1_Msk
#define DMA_LISR_TEIF1_Pos       (9U)
#define DMA_LISR_TEIF1_Msk       (0x1U << DMA_LISR_TEIF1_Pos)                  /*!< 0x00000200 */
#define DMA_LISR_TEIF1           DMA_LISR_TEIF1_Msk
#define DMA_LISR_DMEIF1_Pos      (8U)
#define DMA_LISR_DMEIF1_Msk      (0x1U << DMA_LISR_DMEIF1_Pos)                 /*!< 0x00000100 */
#define DMA_LISR_DMEIF1          DMA_LISR_DMEIF1_Msk
#define DMA_LISR_FEIF1_Pos       (6U)
#define DMA_LISR_FEIF1_Msk       (0x1U << DMA_LISR_FEIF1_Pos)                  /*!< 0x00000040 */
#define DMA_LISR_FEIF1           DMA_LISR_FEIF1_Msk
#define DMA_LISR_TCIF0_Pos       (5U)
#define DMA_LISR_TCIF0_Msk       (0x1U << DMA_LISR_TCIF0_Pos)                  /*!< 0x00000020 */
#define DMA_LISR_TCIF0           DMA_LISR_TCIF0_Msk
#define DMA_LISR_HTIF0_Pos       (4U)
#define DMA_LISR_HTIF0_Msk       (0x1U << DMA_LISR_HTIF0_Pos)                  /*!< 0x00000010 */
#define DMA_LISR_HTIF0           DMA_LISR_HTIF0_Msk
#define DMA_LISR_TEIF0_Pos       (3U)
#define DMA_LISR_TEIF0_Msk       (0x1U << DMA_LISR_TEIF0_Pos)                  /*!< 0x00000008 */
#define DMA_LISR_TEIF0           DMA_LISR_TEIF0_Msk
#define DMA_LISR_DMEIF0_Pos      (2U)
#define DMA_LISR_DMEIF0_Msk      (0x1U << DMA_LISR_DMEIF0_Pos)                 /*!< 0x00000004 */
#define DMA_LISR_DMEIF0          DMA_LISR_DMEIF0_Msk
#define DMA_LISR_FEIF0_Pos       (0U)
#define DMA_LISR_FEIF0_Msk       (0x1U << DMA_LISR_FEIF0_Pos)                  /*!< 0x00000001 */
#define DMA_LISR_FEIF0           DMA_LISR_FEIF0_Msk

/********************  Bits definition for DMA_HISR register  *****************/
#define DMA_HISR_TCIF7_Pos       (27U)
#define DMA_HISR_TCIF7_Msk       (0x1U << DMA_HISR_TCIF7_Pos)                  /*!< 0x08000000 */
#define DMA_HISR_TCIF7           DMA_HISR_TCIF7_Msk
#define DMA_HISR_HTIF7_Pos       (26U)
#define DMA_HISR_HTIF7_Msk       (0x1U << DMA_HISR_HTIF7_Pos)                  /*!< 0x04000000 */
#define DMA_HISR_HTIF7           DMA_HISR_HTIF7_Msk
#define DMA_HISR_TEIF7_Pos       (25U)
#define DMA_HISR_TEIF7_Msk       (0x1U << DMA_HISR_TEIF7_Pos)                  /*!< 0x02000000 */
#define DMA_HISR_TEIF7           DMA_HISR_TEIF7_Msk
#define DMA_HISR_DMEIF7_Pos      (24U)
#define DMA_HISR_DMEIF7_Msk      (0x1U << DMA_HISR_DMEIF7_Pos)                 /*!< 0x01000000 */
#define DMA_HISR_DMEIF7          DMA_HISR_DMEIF7_Msk
#define DMA_HISR_FEIF7_Pos       (22U)
#define DMA_HISR_FEIF7_Msk       (0x1U << DMA_HISR_FEIF7_Pos)                  /*!< 0x00400000 */
#define DMA_HISR_FEIF7           DMA_HISR_FEIF7_Msk
#define DMA_HISR_TCIF6_Pos       (21U)
#define DMA_HISR_TCIF6_Msk       (0x1U << DMA_HISR_TCIF6_Pos)                  /*!< 0x00200000 */
#define DMA_HISR_TCIF6           DMA_HISR_TCIF6_Msk
#define DMA_HISR_HTIF6_Pos       (20U)
#define DMA_HISR_HTIF6_Msk       (0x1U << DMA_HISR_HTIF6_Pos)                  /*!< 0x00100000 */
#define DMA_HISR_HTIF6           DMA_HISR_HTIF6_Msk
#define DMA_HISR_TEIF6_Pos       (19U)
#define DMA_HISR_TEIF6_Msk       (0x1U << DMA_HISR_TEIF6_Pos)                  /*!< 0x00080000 */
#define DMA_HISR_TEIF6           DMA_HISR_TEIF6_Msk
#define DMA_HISR_DMEIF6_Pos      (18U)
#define DMA_HISR_DMEIF6_Msk      (0x1U << DMA_HISR_DMEIF6_Pos)                 /*!< 0x00040000 */
#define DMA_HISR_DMEIF6          DMA_HISR_DMEIF6_Msk
#define DMA_HISR_FEIF6_Pos       (16U)
#define DMA_HISR_FEIF6_Msk       (0x1U << DMA_HISR_FEIF6_Pos)                  /*!< 0x00010000 */
#define DMA_HISR_FEIF6           DMA_HISR_FEIF6_Msk
#define DMA_HISR_TCIF5_Pos       (11U)
#define DMA_HISR_TCIF5_Msk       (0x1U << DMA_HISR_TCIF5_Pos)                  /*!< 0x00000800 */
#define DMA_HISR_TCIF5           DMA_HISR_TCIF5_Msk
#define DMA_HISR_HTIF5_Pos       (10U)
#define DMA_HISR_HTIF5_Msk       (0x1U << DMA_HISR_HTIF5_Pos)                  /*!< 0x00000400 */
#define DMA_HISR_HTIF5           DMA_HISR_HTIF5_Msk
#define DMA_HISR_TEIF5_Pos       (9U)
#define DMA_HISR_TEIF5_Msk       (0x1U << DMA_HISR_TEIF5_Pos)                  /*!< 0x00000200 */
#define DMA_HISR_TEIF5           DMA_HISR_TEIF5_Msk
#define DMA_HISR_DMEIF5_Pos      (8U)
#define DMA_HISR_DMEIF5_Msk      (0x1U << DMA_HISR_DMEIF5_Pos)                 /*!< 0x00000100 */
#define DMA_HISR_DMEIF5          DMA_HISR_DMEIF5_Msk
#define DMA_HISR_FEIF5_Pos       (6U)
#define DMA_HISR_FEIF5_Msk       (0x1U << DMA_HISR_FEIF5_Pos)                  /*!< 0x00000040 */
#define DMA_HISR_FEIF5           DMA_HISR_FEIF5_Msk
#define DMA_HISR_TCIF4_Pos       (5U)
#define DMA_HISR_TCIF4_Msk       (0x1U << DMA_HISR_TCIF4_Pos)                  /*!< 0x00000020 */
#define DMA_HISR_TCIF4           DMA_HISR_TCIF4_Msk
#define DMA_HISR_HTIF4_Pos       (4U)
#define DMA_HISR_HTIF4_Msk       (0x1U << DMA_HISR_HTIF4_Pos)                  /*!< 0x00000010 */
#define DMA_HISR_HTIF4           DMA_HISR_HTIF4_Msk
#define DMA_HISR_TEIF4_Pos       (3U)
#define DMA_HISR_TEIF4_Msk       (0x1U << DMA_HISR_TEIF4_Pos)                  /*!< 0x00000008 */
#define DMA_HISR_TEIF4           DMA_HISR_TEIF4_Msk
#define DMA_HISR_DMEIF4_Pos      (2U)
#define DMA_HISR_DMEIF4_Msk      (0x1U << DMA_HISR_DMEIF4_Pos)                 /*!< 0x00000004 */
#define DMA_HISR_DMEIF4          DMA_HISR_DMEIF4_Msk
#define DMA_HISR_FEIF4_Pos       (0U)
#define DMA_HISR_FEIF4_Msk       (0x1U << DMA_HISR_FEIF4_Pos)                  /*!< 0x00000001 */
#define DMA_HISR_FEIF4           DMA_HISR_FEIF4_Msk

/********************  Bits definition for DMA_LIFCR register  ****************/
#define DMA_LIFCR_CTCIF3_Pos     (27U)
#define DMA_LIFCR_CTCIF3_Msk     (0x1U << DMA_LIFCR_CTCIF3_Pos)                /*!< 0x08000000 */
#define DMA_LIFCR_CTCIF3         DMA_LIFCR_CTCIF3_Msk
#define DMA_LIFCR_CHTIF3_Pos     (26U)
#define DMA_LIFCR_CHTIF3_Msk     (0x1U << DMA_LIFCR_CHTIF3_Pos)                /*!< 0x04000000 */
#define DMA_LIFCR_CHTIF3         DMA_LIFCR_CHTIF3_Msk
#define DMA_LIFCR_CTEIF3_Pos     (25U)
#define DMA_LIFCR_CTEIF3_Msk     (0x1U << DMA_LIFCR_CTEIF3_Pos)                /*!< 0x02000000 */
#define DMA_LIFCR_CTEIF3         DMA_LIFCR_CTEIF3_Msk
#define DMA_LIFCR_CDMEIF3_Pos    (24U)
#define DMA_LIFCR_CDMEIF3_Msk    (0x1U << DMA_LIFCR_CDMEIF3_Pos)               /*!< 0x01000000 */
#define DMA_LIFCR_CDMEIF3        DMA_LIFCR_CDMEIF3_Msk
#define DMA_LIFCR_CFEIF3_Pos     (22U)
#define DMA_LIFCR_CFEIF3_Msk     (0x1U << DMA_LIFCR_CFEIF3_Pos)                /*!< 0x00400000 */
#define DMA_LIFCR_CFEIF3         DMA_LIFCR_CFEIF3_Msk
#define DMA_LIFCR_CTCIF2_Pos     (21U)
#define DMA_LIFCR_CTCIF2_Msk     (0x1U << DMA_LIFCR_CTCIF2_Pos)                /*!< 0x00200000 */
#define DMA_LIFCR_CTCIF2         DMA_LIFCR_CTCIF2_Msk
#define DMA_LIFCR_CHTIF2_Pos     (20U)
#define DMA_LIFCR_CHTIF2_Msk     (0x1U << DMA_LIFCR_CHTIF2_Pos)                /*!< 0x00100000 */
#define DMA_LIFCR_CHTIF2         DMA_LIFCR_CHTIF2_Msk
#define DMA_LIFCR_CTEIF2_Pos     (19U)
#define DMA_LIFCR_CTEIF2_Msk     (0x1U << DMA_LIFCR_CTEIF2_Pos)                /*!< 0x00080000 */
#define DMA_LIFCR_CTEIF2         DMA_LIFCR_CTEIF2_Msk
#define DMA_LIFCR_CDMEIF2_Pos    (18U)
#define DMA_LIFCR_CDMEIF2_Msk    (0x1U << DMA_LIFCR_CDMEIF2_Pos)               /*!< 0x00040000 */
#define DMA_LIFCR_CDMEIF2        DMA_LIFCR_CDMEIF2_Msk
#define DMA_LIFCR_CFEIF2_Pos     (16U)
#define DMA_LIFCR_CFEIF2_Msk     (0x1U << DMA_LIFCR_CFEIF2_Pos)                /*!< 0x00010000 */
#define DMA_LIFCR_CFEIF2         DMA_LIFCR_CFEIF2_Msk
#define DMA_LIFCR_CTCIF1_Pos     (11U)
#define DMA_LIFCR_CTCIF1_Msk     (0x1U << DMA_LIFCR_CTCIF1_Pos)                /*!< 0x00000800 */
#define DMA_LIFCR_CTCIF1         DMA_LIFCR_CTCIF1_Msk
#define DMA_LIFCR_CHTIF1_Pos     (10U)
#define DMA_LIFCR_CHTIF1_Msk     (0x1U << DMA_LIFCR_CHTIF1_Pos)                /*!< 0x00000400 */
#define DMA_LIFCR_CHTIF1         DMA_LIFCR_CHTIF1_Msk
#define DMA_LIFCR_CTEIF1_Pos     (9U)
#define DMA_LIFCR_CTEIF1_Msk     (0x1U << DMA_LIFCR_CTEIF1_Pos)                /*!< 0x00000200 */
#define DMA_LIFCR_CTEIF1         DMA_LIFCR_CTEIF1_Msk
#define DMA_LIFCR_CDMEIF1_Pos    (8U)
#define DMA_LIFCR_CDMEIF1_Msk    (0x1U << DMA_LIFCR_CDMEIF1_Pos)               /*!< 0x00000100 */
#define DMA_LIFCR_CDMEIF1        DMA_LIFCR_CDMEIF1_Msk
#define DMA_LIFCR_CFEIF1_Pos     (6U)
#define DMA_LIFCR_CFEIF1_Msk     (0x1U << DMA_LIFCR_CFEIF1_Pos)                /*!< 0x00000040 */
#define DMA_LIFCR_CFEIF1         DMA_LIFCR_CFEIF1_Msk
#define DMA_LIFCR_CTCIF0_Pos     (5U)
#define DMA_LIFCR_CTCIF0_Msk     (0x1U << DMA_LIFCR_CTCIF0_Pos)                /*!< 0x00000020 */
#define DMA_LIFCR_CTCIF0         DMA_LIFCR_CTCIF0_Msk
#define DMA_LIFCR_CHTIF0_Pos     (4U)
#define DMA_LIFCR_CHTIF0_Msk     (0x1U << DMA_LIFCR_CHTIF0_Pos)                /*!< 0x00000010 */
#define DMA_LIFCR_CHTIF0         DMA_LIFCR_CHTIF0_Msk
#define DMA_LIFCR_CTEIF0_Pos     (3U)
#define DMA_LIFCR_CTEIF0_Msk     (0x1U << DMA_LIFCR_CTEIF0_Pos)                /*!< 0x00000008 */
#define DMA_LIFCR_CTEIF0         DMA_LIFCR_CTEIF0_Msk
#define DMA_LIFCR_CDMEIF0_Pos    (2U)
#define DMA_LIFCR_CDMEIF0_Msk    (0x1U << DMA_LIFCR_CDMEIF0_Pos)               /*!< 0x00000004 */
#define DMA_LIFCR_CDMEIF0        DMA_LIFCR_CDMEIF0_Msk
#define DMA_LIFCR_CFEIF0_Pos     (0U)
#define DMA_LIFCR_CFEIF0_Msk     (0x1U << DMA_LIFCR_CFEIF0_Pos)                /*!< 0x00000001 */
#define DMA_LIFCR_CFEIF0         DMA_LIFCR_CFEIF0_Msk

/********************  Bits definition for DMA_HIFCR  register  ****************/
#define DMA_HIFCR_CTCIF7_Pos     (27U)
#define DMA_HIFCR_CTCIF7_Msk     (0x1U << DMA_HIFCR_CTCIF7_Pos)                /*!< 0x08000000 */
#define DMA_HIFCR_CTCIF7         DMA_HIFCR_CTCIF7_Msk
#define DMA_HIFCR_CHTIF7_Pos     (26U)
#define DMA_HIFCR_CHTIF7_Msk     (0x1U << DMA_HIFCR_CHTIF7_Pos)                /*!< 0x04000000 */
#define DMA_HIFCR_CHTIF7         DMA_HIFCR_CHTIF7_Msk
#define DMA_HIFCR_CTEIF7_Pos     (25U)
#define DMA_HIFCR_CTEIF7_Msk     (0x1U << DMA_HIFCR_CTEIF7_Pos)                /*!< 0x02000000 */
#define DMA_HIFCR_CTEIF7         DMA_HIFCR_CTEIF7_Msk
#define DMA_HIFCR_CDMEIF7_Pos    (24U)
#define DMA_HIFCR_CDMEIF7_Msk    (0x1U << DMA_HIFCR_CDMEIF7_Pos)               /*!< 0x01000000 */
#define DMA_HIFCR_CDMEIF7        DMA_HIFCR_CDMEIF7_Msk
#define DMA_HIFCR_CFEIF7_Pos     (22U)
#define DMA_HIFCR_CFEIF7_Msk     (0x1U << DMA_HIFCR_CFEIF7_Pos)                /*!< 0x00400000 */
#define DMA_HIFCR_CFEIF7         DMA_HIFCR_CFEIF7_Msk
#define DMA_HIFCR_CTCIF6_Pos     (21U)
#define DMA_HIFCR_CTCIF6_Msk     (0x1U << DMA_HIFCR_CTCIF6_Pos)                /*!< 0x00200000 */
#define DMA_HIFCR_CTCIF6         DMA_HIFCR_CTCIF6_Msk
#define DMA_HIFCR_CHTIF6_Pos     (20U)
#define DMA_HIFCR_CHTIF6_Msk     (0x1U << DMA_HIFCR_CHTIF6_Pos)                /*!< 0x00100000 */
#define DMA_HIFCR_CHTIF6         DMA_HIFCR_CHTIF6_Msk
#define DMA_HIFCR_CTEIF6_Pos     (19U)
#define DMA_HIFCR_CTEIF6_Msk     (0x1U << DMA_HIFCR_CTEIF6_Pos)                /*!< 0x00080000 */
#define DMA_HIFCR_CTEIF6         DMA_HIFCR_CTEIF6_Msk
#define DMA_HIFCR_CDMEIF6_Pos    (18U)
#define DMA_HIFCR_CDMEIF6_Msk    (0x1U << DMA_HIFCR_CDMEIF6_Pos)               /*!< 0x00040000 */
#define DMA_HIFCR_CDMEIF6        DMA_HIFCR_CDMEIF6_Msk
#define DMA_HIFCR_CFEIF6_Pos     (16U)
#define DMA_HIFCR_CFEIF6_Msk     (0x1U << DMA_HIFCR_CFEIF6_Pos)                /*!< 0x00010000 */
#define DMA_HIFCR_CFEIF6         DMA_HIFCR_CFEIF6_Msk
#define DMA_HIFCR_CTCIF5_Pos     (11U)
#define DMA_HIFCR_CTCIF5_Msk     (0x1U << DMA_HIFCR_CTCIF5_Pos)                /*!< 0x00000800 */
#define DMA_HIFCR_CTCIF5         DMA_HIFCR_CTCIF5_Msk
#define DMA_HIFCR_CHTIF5_Pos     (10U)
#define DMA_HIFCR_CHTIF5_Msk     (0x1U << DMA_HIFCR_CHTIF5_Pos)                /*!< 0x00000400 */
#define DMA_HIFCR_CHTIF5         DMA_HIFCR_CHTIF5_Msk
#define DMA_HIFCR_CTEIF5_Pos     (9U)
#define DMA_HIFCR_CTEIF5_Msk     (0x1U << DMA_HIFCR_CTEIF5_Pos)                /*!< 0x00000200 */
#define DMA_HIFCR_CTEIF5         DMA_HIFCR_CTEIF5_Msk
#define DMA_HIFCR_CDMEIF5_Pos    (8U)
#define DMA_HIFCR_CDMEIF5_Msk    (0x1U << DMA_HIFCR_CDMEIF5_Pos)               /*!< 0x00000100 */
#define DMA_HIFCR_CDMEIF5        DMA_HIFCR_CDMEIF5_Msk
#define DMA_HIFCR_CFEIF5_Pos     (6U)
#define DMA_HIFCR_CFEIF5_Msk     (0x1U << DMA_HIFCR_CFEIF5_Pos)                /*!< 0x00000040 */
#define DMA_HIFCR_CFEIF5         DMA_HIFCR_CFEIF5_Msk
#define DMA_HIFCR_CTCIF4_Pos     (5U)
#define DMA_HIFCR_CTCIF4_Msk     (0x1U << DMA_HIFCR_CTCIF4_Pos)                /*!< 0x00000020 */
#define DMA_HIFCR_CTCIF4         DMA_HIFCR_CTCIF4_Msk
#define DMA_HIFCR_CHTIF4_Pos     (4U)
#define DMA_HIFCR_CHTIF4_Msk     (0x1U << DMA_HIFCR_CHTIF4_Pos)                /*!< 0x00000010 */
#define DMA_HIFCR_CHTIF4         DMA_HIFCR_CHTIF4_Msk
#define DMA_HIFCR_CTEIF4_Pos     (3U)
#define DMA_HIFCR_CTEIF4_Msk     (0x1U << DMA_HIFCR_CTEIF4_Pos)                /*!< 0x00000008 */
#define DMA_HIFCR_CTEIF4         DMA_HIFCR_CTEIF4_Msk
#define DMA_HIFCR_CDMEIF4_Pos    (2U)
#define DMA_HIFCR_CDMEIF4_Msk    (0x1U << DMA_HIFCR_CDMEIF4_Pos)               /*!< 0x00000004 */
#define DMA_HIFCR_CDMEIF4        DMA_HIFCR_CDMEIF4_Msk
#define DMA_HIFCR_CFEIF4_Pos     (0U)
#define DMA_HIFCR_CFEIF4_Msk     (0x1U << DMA_HIFCR_CFEIF4_Pos)                /*!< 0x00000001 */
#define DMA_HIFCR_CFEIF4         DMA_HIFCR_CFEIF4_Msk



/******************************************************************************/
/*                                                                            */
/*                             DMAMUX Controller                              */
/*                                                                            */
/******************************************************************************/
/********************  Bits definition for DMAMUX_CxCR register  **************/
#define DMAMUX_CxCR_DMAREQ_ID_Pos      (0U)
#define DMAMUX_CxCR_DMAREQ_ID_Msk      (0xFFU << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x000000FF */
#define DMAMUX_CxCR_DMAREQ_ID          DMAMUX_CxCR_DMAREQ_ID_Msk
#define DMAMUX_CxCR_DMAREQ_ID_0        (0x01U << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000001 */
#define DMAMUX_CxCR_DMAREQ_ID_1        (0x02U << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000002 */
#define DMAMUX_CxCR_DMAREQ_ID_2        (0x04U << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000004 */
#define DMAMUX_CxCR_DMAREQ_ID_3        (0x08U << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000008 */
#define DMAMUX_CxCR_DMAREQ_ID_4        (0x10U << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000010 */
#define DMAMUX_CxCR_DMAREQ_ID_5        (0x20U << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000020 */
#define DMAMUX_CxCR_DMAREQ_ID_6        (0x40U << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000040 */
#define DMAMUX_CxCR_DMAREQ_ID_7        (0x80U << DMAMUX_CxCR_DMAREQ_ID_Pos)    /*!< 0x00000080 */
#define DMAMUX_CxCR_SOIE_Pos           (8U)
#define DMAMUX_CxCR_SOIE_Msk           (0x1U << DMAMUX_CxCR_SOIE_Pos)          /*!< 0x00000100 */
#define DMAMUX_CxCR_SOIE               DMAMUX_CxCR_SOIE_Msk
#define DMAMUX_CxCR_EGE_Pos            (9U)
#define DMAMUX_CxCR_EGE_Msk            (0x1U << DMAMUX_CxCR_EGE_Pos)           /*!< 0x00000200 */
#define DMAMUX_CxCR_EGE                DMAMUX_CxCR_EGE_Msk
#define DMAMUX_CxCR_SE_Pos             (16U)
#define DMAMUX_CxCR_SE_Msk             (0x1U << DMAMUX_CxCR_SE_Pos)            /*!< 0x00010000 */
#define DMAMUX_CxCR_SE                 DMAMUX_CxCR_SE_Msk
#define DMAMUX_CxCR_SPOL_Pos           (17U)
#define DMAMUX_CxCR_SPOL_Msk           (0x3U << DMAMUX_CxCR_SPOL_Pos)          /*!< 0x00060000 */
#define DMAMUX_CxCR_SPOL               DMAMUX_CxCR_SPOL_Msk
#define DMAMUX_CxCR_SPOL_0             (0x1U << DMAMUX_CxCR_SPOL_Pos)          /*!< 0x00020000 */
#define DMAMUX_CxCR_SPOL_1             (0x2U << DMAMUX_CxCR_SPOL_Pos)          /*!< 0x00040000 */
#define DMAMUX_CxCR_NBREQ_Pos          (19U)
#define DMAMUX_CxCR_NBREQ_Msk          (0x1FU << DMAMUX_CxCR_NBREQ_Pos)        /*!< 0x00F80000 */
#define DMAMUX_CxCR_NBREQ              DMAMUX_CxCR_NBREQ_Msk
#define DMAMUX_CxCR_NBREQ_0            (0x01U << DMAMUX_CxCR_NBREQ_Pos)        /*!< 0x00080000 */
#define DMAMUX_CxCR_NBREQ_1            (0x02U << DMAMUX_CxCR_NBREQ_Pos)        /*!< 0x00100000 */
#define DMAMUX_CxCR_NBREQ_2            (0x04U << DMAMUX_CxCR_NBREQ_Pos)        /*!< 0x00200000 */
#define DMAMUX_CxCR_NBREQ_3            (0x08U << DMAMUX_CxCR_NBREQ_Pos)        /*!< 0x00400000 */
#define DMAMUX_CxCR_NBREQ_4            (0x10U << DMAMUX_CxCR_NBREQ_Pos)        /*!< 0x00800000 */
#define DMAMUX_CxCR_SYNC_ID_Pos        (24U)
#define DMAMUX_CxCR_SYNC_ID_Msk        (0x1FU << DMAMUX_CxCR_SYNC_ID_Pos)      /*!< 0x1F000000 */
#define DMAMUX_CxCR_SYNC_ID            DMAMUX_CxCR_SYNC_ID_Msk
#define DMAMUX_CxCR_SYNC_ID_0          (0x01U << DMAMUX_CxCR_SYNC_ID_Pos)      /*!< 0x01000000 */
#define DMAMUX_CxCR_SYNC_ID_1          (0x02U << DMAMUX_CxCR_SYNC_ID_Pos)      /*!< 0x02000000 */
#define DMAMUX_CxCR_SYNC_ID_2          (0x04U << DMAMUX_CxCR_SYNC_ID_Pos)      /*!< 0x04000000 */
#define DMAMUX_CxCR_SYNC_ID_3          (0x08U << DMAMUX_CxCR_SYNC_ID_Pos)      /*!< 0x08000000 */
#define DMAMUX_CxCR_SYNC_ID_4          (0x10U << DMAMUX_CxCR_SYNC_ID_Pos)      /*!< 0x10000000 */

/********************  Bits definition for DMAMUX_CSR register  **************/
#define DMAMUX_CSR_SOF0_Pos            (0U)
#define DMAMUX_CSR_SOF0_Msk            (0x1U << DMAMUX_CSR_SOF0_Pos)           /*!< 0x00000001 */
#define DMAMUX_CSR_SOF0                DMAMUX_CSR_SOF0_Msk
#define DMAMUX_CSR_SOF1_Pos            (1U)
#define DMAMUX_CSR_SOF1_Msk            (0x1U << DMAMUX_CSR_SOF1_Pos)           /*!< 0x00000002 */
#define DMAMUX_CSR_SOF1                DMAMUX_CSR_SOF1_Msk
#define DMAMUX_CSR_SOF2_Pos            (2U)
#define DMAMUX_CSR_SOF2_Msk            (0x1U << DMAMUX_CSR_SOF2_Pos)           /*!< 0x00000004 */
#define DMAMUX_CSR_SOF2                DMAMUX_CSR_SOF2_Msk
#define DMAMUX_CSR_SOF3_Pos            (3U)
#define DMAMUX_CSR_SOF3_Msk            (0x1U << DMAMUX_CSR_SOF3_Pos)           /*!< 0x00000008 */
#define DMAMUX_CSR_SOF3                DMAMUX_CSR_SOF3_Msk
#define DMAMUX_CSR_SOF4_Pos            (4U)
#define DMAMUX_CSR_SOF4_Msk            (0x1U << DMAMUX_CSR_SOF4_Pos)           /*!< 0x00000010 */
#define DMAMUX_CSR_SOF4                DMAMUX_CSR_SOF4_Msk
#define DMAMUX_CSR_SOF5_Pos            (5U)
#define DMAMUX_CSR_SOF5_Msk            (0x1U << DMAMUX_CSR_SOF5_Pos)           /*!< 0x00000020 */
#define DMAMUX_CSR_SOF5                DMAMUX_CSR_SOF5_Msk
#define DMAMUX_CSR_SOF6_Pos            (6U)
#define DMAMUX_CSR_SOF6_Msk            (0x1U << DMAMUX_CSR_SOF6_Pos)           /*!< 0x00000040 */
#define DMAMUX_CSR_SOF6                DMAMUX_CSR_SOF6_Msk
#define DMAMUX_CSR_SOF7_Pos            (7U)
#define DMAMUX_CSR_SOF7_Msk            (0x1U << DMAMUX_CSR_SOF7_Pos)           /*!< 0x00000080 */
#define DMAMUX_CSR_SOF7                DMAMUX_CSR_SOF7_Msk
#define DMAMUX_CSR_SOF8_Pos            (8U)
#define DMAMUX_CSR_SOF8_Msk            (0x1U << DMAMUX_CSR_SOF8_Pos)           /*!< 0x00000100 */
#define DMAMUX_CSR_SOF8                DMAMUX_CSR_SOF8_Msk
#define DMAMUX_CSR_SOF9_Pos            (9U)
#define DMAMUX_CSR_SOF9_Msk            (0x1U << DMAMUX_CSR_SOF9_Pos)           /*!< 0x00000200 */
#define DMAMUX_CSR_SOF9                DMAMUX_CSR_SOF9_Msk
#define DMAMUX_CSR_SOF10_Pos           (10U)
#define DMAMUX_CSR_SOF10_Msk           (0x1U << DMAMUX_CSR_SOF10_Pos)          /*!< 0x00000400 */
#define DMAMUX_CSR_SOF10               DMAMUX_CSR_SOF10_Msk
#define DMAMUX_CSR_SOF11_Pos           (11U)
#define DMAMUX_CSR_SOF11_Msk           (0x1U << DMAMUX_CSR_SOF11_Pos)          /*!< 0x00000800 */
#define DMAMUX_CSR_SOF11               DMAMUX_CSR_SOF11_Msk
#define DMAMUX_CSR_SOF12_Pos           (12U)
#define DMAMUX_CSR_SOF12_Msk           (0x1U << DMAMUX_CSR_SOF12_Pos)          /*!< 0x00001000 */
#define DMAMUX_CSR_SOF12               DMAMUX_CSR_SOF12_Msk
#define DMAMUX_CSR_SOF13_Pos           (13U)
#define DMAMUX_CSR_SOF13_Msk           (0x1U << DMAMUX_CSR_SOF13_Pos)          /*!< 0x00002000 */
#define DMAMUX_CSR_SOF13               DMAMUX_CSR_SOF13_Msk
#define DMAMUX_CSR_SOF14_Pos           (14U)
#define DMAMUX_CSR_SOF14_Msk           (0x1U << DMAMUX_CSR_SOF14_Pos)          /*!< 0x00004000 */
#define DMAMUX_CSR_SOF14               DMAMUX_CSR_SOF14_Msk
#define DMAMUX_CSR_SOF15_Pos           (15U)
#define DMAMUX_CSR_SOF15_Msk           (0x1U << DMAMUX_CSR_SOF15_Pos)          /*!< 0x00008000 */
#define DMAMUX_CSR_SOF15               DMAMUX_CSR_SOF15_Msk

/********************  Bits definition for DMAMUX_CFR register  **************/
#define DMAMUX_CFR_CSOF0_Pos           (0U)
#define DMAMUX_CFR_CSOF0_Msk           (0x1U << DMAMUX_CFR_CSOF0_Pos)          /*!< 0x00000001 */
#define DMAMUX_CFR_CSOF0               DMAMUX_CFR_CSOF0_Msk
#define DMAMUX_CFR_CSOF1_Pos           (1U)
#define DMAMUX_CFR_CSOF1_Msk           (0x1U << DMAMUX_CFR_CSOF1_Pos)          /*!< 0x00000002 */
#define DMAMUX_CFR_CSOF1               DMAMUX_CFR_CSOF1_Msk
#define DMAMUX_CFR_CSOF2_Pos           (2U)
#define DMAMUX_CFR_CSOF2_Msk           (0x1U << DMAMUX_CFR_CSOF2_Pos)          /*!< 0x00000004 */
#define DMAMUX_CFR_CSOF2               DMAMUX_CFR_CSOF2_Msk
#define DMAMUX_CFR_CSOF3_Pos           (3U)
#define DMAMUX_CFR_CSOF3_Msk           (0x1U << DMAMUX_CFR_CSOF3_Pos)          /*!< 0x00000008 */
#define DMAMUX_CFR_CSOF3               DMAMUX_CFR_CSOF3_Msk
#define DMAMUX_CFR_CSOF4_Pos           (4U)
#define DMAMUX_CFR_CSOF4_Msk           (0x1U << DMAMUX_CFR_CSOF4_Pos)          /*!< 0x00000010 */
#define DMAMUX_CFR_CSOF4               DMAMUX_CFR_CSOF4_Msk
#define DMAMUX_CFR_CSOF5_Pos           (5U)
#define DMAMUX_CFR_CSOF5_Msk           (0x1U << DMAMUX_CFR_CSOF5_Pos)          /*!< 0x00000020 */
#define DMAMUX_CFR_CSOF5               DMAMUX_CFR_CSOF5_Msk
#define DMAMUX_CFR_CSOF6_Pos           (6U)
#define DMAMUX_CFR_CSOF6_Msk           (0x1U << DMAMUX_CFR_CSOF6_Pos)          /*!< 0x00000040 */
#define DMAMUX_CFR_CSOF6               DMAMUX_CFR_CSOF6_Msk
#define DMAMUX_CFR_CSOF7_Pos           (7U)
#define DMAMUX_CFR_CSOF7_Msk           (0x1U << DMAMUX_CFR_CSOF7_Pos)          /*!< 0x00000080 */
#define DMAMUX_CFR_CSOF7               DMAMUX_CFR_CSOF7_Msk
#define DMAMUX_CFR_CSOF8_Pos           (8U)
#define DMAMUX_CFR_CSOF8_Msk           (0x1U << DMAMUX_CFR_CSOF8_Pos)          /*!< 0x00000100 */
#define DMAMUX_CFR_CSOF8               DMAMUX_CFR_CSOF8_Msk
#define DMAMUX_CFR_CSOF9_Pos           (9U)
#define DMAMUX_CFR_CSOF9_Msk           (0x1U << DMAMUX_CFR_CSOF9_Pos)          /*!< 0x00000200 */
#define DMAMUX_CFR_CSOF9               DMAMUX_CFR_CSOF9_Msk
#define DMAMUX_CFR_CSOF10_Pos          (10U)
#define DMAMUX_CFR_CSOF10_Msk          (0x1U << DMAMUX_CFR_CSOF10_Pos)         /*!< 0x00000400 */
#define DMAMUX_CFR_CSOF10              DMAMUX_CFR_CSOF10_Msk
#define DMAMUX_CFR_CSOF11_Pos          (11U)
#define DMAMUX_CFR_CSOF11_Msk          (0x1U << DMAMUX_CFR_CSOF11_Pos)         /*!< 0x00000800 */
#define DMAMUX_CFR_CSOF11              DMAMUX_CFR_CSOF11_Msk
#define DMAMUX_CFR_CSOF12_Pos          (12U)
#define DMAMUX_CFR_CSOF12_Msk          (0x1U << DMAMUX_CFR_CSOF12_Pos)         /*!< 0x00001000 */
#define DMAMUX_CFR_CSOF12              DMAMUX_CFR_CSOF12_Msk
#define DMAMUX_CFR_CSOF13_Pos          (13U)
#define DMAMUX_CFR_CSOF13_Msk          (0x1U << DMAMUX_CFR_CSOF13_Pos)         /*!< 0x00002000 */
#define DMAMUX_CFR_CSOF13              DMAMUX_CFR_CSOF13_Msk
#define DMAMUX_CFR_CSOF14_Pos          (14U)
#define DMAMUX_CFR_CSOF14_Msk          (0x1U << DMAMUX_CFR_CSOF14_Pos)         /*!< 0x00004000 */
#define DMAMUX_CFR_CSOF14              DMAMUX_CFR_CSOF14_Msk
#define DMAMUX_CFR_CSOF15_Pos          (15U)
#define DMAMUX_CFR_CSOF15_Msk          (0x1U << DMAMUX_CFR_CSOF15_Pos)         /*!< 0x00008000 */
#define DMAMUX_CFR_CSOF15              DMAMUX_CFR_CSOF15_Msk

/********************  Bits definition for DMAMUX_RGxCR register  ************/
#define DMAMUX_RGxCR_SIG_ID_Pos        (0U)
#define DMAMUX_RGxCR_SIG_ID_Msk        (0x1FU << DMAMUX_RGxCR_SIG_ID_Pos)      /*!< 0x0000001F */
#define DMAMUX_RGxCR_SIG_ID            DMAMUX_RGxCR_SIG_ID_Msk
#define DMAMUX_RGxCR_SIG_ID_0          (0x01U << DMAMUX_RGxCR_SIG_ID_Pos)      /*!< 0x00000001 */
#define DMAMUX_RGxCR_SIG_ID_1          (0x02U << DMAMUX_RGxCR_SIG_ID_Pos)      /*!< 0x00000002 */
#define DMAMUX_RGxCR_SIG_ID_2          (0x04U << DMAMUX_RGxCR_SIG_ID_Pos)      /*!< 0x00000004 */
#define DMAMUX_RGxCR_SIG_ID_3          (0x08U << DMAMUX_RGxCR_SIG_ID_Pos)      /*!< 0x00000008 */
#define DMAMUX_RGxCR_SIG_ID_4          (0x10U << DMAMUX_RGxCR_SIG_ID_Pos)      /*!< 0x00000010 */
#define DMAMUX_RGxCR_OIE_Pos           (8U)
#define DMAMUX_RGxCR_OIE_Msk           (0x1U << DMAMUX_RGxCR_OIE_Pos)          /*!< 0x00000100 */
#define DMAMUX_RGxCR_OIE               DMAMUX_RGxCR_OIE_Msk
#define DMAMUX_RGxCR_GE_Pos            (16U)
#define DMAMUX_RGxCR_GE_Msk            (0x1U << DMAMUX_RGxCR_GE_Pos)           /*!< 0x00010000 */
#define DMAMUX_RGxCR_GE                DMAMUX_RGxCR_GE_Msk
#define DMAMUX_RGxCR_GPOL_Pos          (17U)
#define DMAMUX_RGxCR_GPOL_Msk          (0x3U << DMAMUX_RGxCR_GPOL_Pos)         /*!< 0x00060000 */
#define DMAMUX_RGxCR_GPOL              DMAMUX_RGxCR_GPOL_Msk
#define DMAMUX_RGxCR_GPOL_0            (0x1U << DMAMUX_RGxCR_GPOL_Pos)         /*!< 0x00020000 */
#define DMAMUX_RGxCR_GPOL_1            (0x2U << DMAMUX_RGxCR_GPOL_Pos)         /*!< 0x00040000 */
#define DMAMUX_RGxCR_GNBREQ_Pos        (19U)                                   
#define DMAMUX_RGxCR_GNBREQ_Msk        (0x1FU << DMAMUX_RGxCR_GNBREQ_Pos)      /*!< 0x00F80000 */
#define DMAMUX_RGxCR_GNBREQ            DMAMUX_RGxCR_GNBREQ_Msk                 /*!< Number of DMA requests to be generated */
#define DMAMUX_RGxCR_GNBREQ_0          (0x01U << DMAMUX_RGxCR_GNBREQ_Pos)      /*!< 0x00080000 */
#define DMAMUX_RGxCR_GNBREQ_1          (0x02U << DMAMUX_RGxCR_GNBREQ_Pos)      /*!< 0x00100000 */
#define DMAMUX_RGxCR_GNBREQ_2          (0x04U << DMAMUX_RGxCR_GNBREQ_Pos)      /*!< 0x00200000 */
#define DMAMUX_RGxCR_GNBREQ_3          (0x08U << DMAMUX_RGxCR_GNBREQ_Pos)      /*!< 0x00400000 */
#define DMAMUX_RGxCR_GNBREQ_4          (0x10U << DMAMUX_RGxCR_GNBREQ_Pos)      /*!< 0x00800000 */

/********************  Bits definition for DMAMUX_RGSR register  **************/
#define DMAMUX_RGSR_OF0_Pos            (0U)
#define DMAMUX_RGSR_OF0_Msk            (0x1U << DMAMUX_RGSR_OF0_Pos)           /*!< 0x00000001 */
#define DMAMUX_RGSR_OF0                DMAMUX_RGSR_OF0_Msk
#define DMAMUX_RGSR_OF1_Pos            (1U)
#define DMAMUX_RGSR_OF1_Msk            (0x1U << DMAMUX_RGSR_OF1_Pos)           /*!< 0x00000002 */
#define DMAMUX_RGSR_OF1                DMAMUX_RGSR_OF1_Msk
#define DMAMUX_RGSR_OF2_Pos            (2U)
#define DMAMUX_RGSR_OF2_Msk            (0x1U << DMAMUX_RGSR_OF2_Pos)           /*!< 0x00000004 */
#define DMAMUX_RGSR_OF2                DMAMUX_RGSR_OF2_Msk
#define DMAMUX_RGSR_OF3_Pos            (3U)
#define DMAMUX_RGSR_OF3_Msk            (0x1U << DMAMUX_RGSR_OF3_Pos)           /*!< 0x00000008 */
#define DMAMUX_RGSR_OF3                DMAMUX_RGSR_OF3_Msk
#define DMAMUX_RGSR_OF4_Pos            (4U)
#define DMAMUX_RGSR_OF4_Msk            (0x1U << DMAMUX_RGSR_OF4_Pos)           /*!< 0x00000010 */
#define DMAMUX_RGSR_OF4                DMAMUX_RGSR_OF4_Msk
#define DMAMUX_RGSR_OF5_Pos            (5U)
#define DMAMUX_RGSR_OF5_Msk            (0x1U << DMAMUX_RGSR_OF5_Pos)           /*!< 0x00000020 */
#define DMAMUX_RGSR_OF5                DMAMUX_RGSR_OF5_Msk
#define DMAMUX_RGSR_OF6_Pos            (6U)
#define DMAMUX_RGSR_OF6_Msk            (0x1U << DMAMUX_RGSR_OF6_Pos)           /*!< 0x00000040 */
#define DMAMUX_RGSR_OF6                DMAMUX_RGSR_OF6_Msk
#define DMAMUX_RGSR_OF7_Pos            (7U)
#define DMAMUX_RGSR_OF7_Msk            (0x1U << DMAMUX_RGSR_OF7_Pos)           /*!< 0x00000080 */
#define DMAMUX_RGSR_OF7                DMAMUX_RGSR_OF7_Msk

/********************  Bits definition for DMAMUX_RGCFR register  **************/
#define DMAMUX_RGCFR_COF0_Pos          (0U)
#define DMAMUX_RGCFR_COF0_Msk          (0x1U << DMAMUX_RGCFR_COF0_Pos)         /*!< 0x00000001 */
#define DMAMUX_RGCFR_COF0              DMAMUX_RGCFR_COF0_Msk
#define DMAMUX_RGCFR_COF1_Pos          (1U)
#define DMAMUX_RGCFR_COF1_Msk          (0x1U << DMAMUX_RGCFR_COF1_Pos)         /*!< 0x00000002 */
#define DMAMUX_RGCFR_COF1              DMAMUX_RGCFR_COF1_Msk
#define DMAMUX_RGCFR_COF2_Pos          (2U)
#define DMAMUX_RGCFR_COF2_Msk          (0x1U << DMAMUX_RGCFR_COF2_Pos)         /*!< 0x00000004 */
#define DMAMUX_RGCFR_COF2              DMAMUX_RGCFR_COF2_Msk
#define DMAMUX_RGCFR_COF3_Pos          (3U)
#define DMAMUX_RGCFR_COF3_Msk          (0x1U << DMAMUX_RGCFR_COF3_Pos)         /*!< 0x00000008 */
#define DMAMUX_RGCFR_COF3              DMAMUX_RGCFR_COF3_Msk
#define DMAMUX_RGCFR_COF4_Pos          (4U)
#define DMAMUX_RGCFR_COF4_Msk          (0x1U << DMAMUX_RGCFR_COF4_Pos)         /*!< 0x00000010 */
#define DMAMUX_RGCFR_COF4              DMAMUX_RGCFR_COF4_Msk
#define DMAMUX_RGCFR_COF5_Pos          (5U)
#define DMAMUX_RGCFR_COF5_Msk          (0x1U << DMAMUX_RGCFR_COF5_Pos)         /*!< 0x00000020 */
#define DMAMUX_RGCFR_COF5              DMAMUX_RGCFR_COF5_Msk
#define DMAMUX_RGCFR_COF6_Pos          (6U)
#define DMAMUX_RGCFR_COF6_Msk          (0x1U << DMAMUX_RGCFR_COF6_Pos)         /*!< 0x00000040 */
#define DMAMUX_RGCFR_COF6              DMAMUX_RGCFR_COF6_Msk
#define DMAMUX_RGCFR_COF7_Pos          (7U)
#define DMAMUX_RGCFR_COF7_Msk          (0x1U << DMAMUX_RGCFR_COF7_Pos)         /*!< 0x00000080 */
#define DMAMUX_RGCFR_COF7              DMAMUX_RGCFR_COF7_Msk


/******************************************************************************/
/*                                                                            */
/*                    External Interrupt/Event Controller                     */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for EXTI_IMR1 register  *******************/
#define EXTI_IMR1_IM0_Pos          (0U)
#define EXTI_IMR1_IM0_Msk          (0x1U << EXTI_IMR1_IM0_Pos)                 /*!< 0x00000001 */
#define EXTI_IMR1_IM0              EXTI_IMR1_IM0_Msk                           /*!< Interrupt Mask on line 0 */
#define EXTI_IMR1_IM1_Pos          (1U)
#define EXTI_IMR1_IM1_Msk          (0x1U << EXTI_IMR1_IM1_Pos)                 /*!< 0x00000002 */
#define EXTI_IMR1_IM1              EXTI_IMR1_IM1_Msk                           /*!< Interrupt Mask on line 1 */
#define EXTI_IMR1_IM2_Pos          (2U)
#define EXTI_IMR1_IM2_Msk          (0x1U << EXTI_IMR1_IM2_Pos)                 /*!< 0x00000004 */
#define EXTI_IMR1_IM2              EXTI_IMR1_IM2_Msk                           /*!< Interrupt Mask on line 2 */
#define EXTI_IMR1_IM3_Pos          (3U)
#define EXTI_IMR1_IM3_Msk          (0x1U << EXTI_IMR1_IM3_Pos)                 /*!< 0x00000008 */
#define EXTI_IMR1_IM3              EXTI_IMR1_IM3_Msk                           /*!< Interrupt Mask on line 3 */
#define EXTI_IMR1_IM4_Pos          (4U)
#define EXTI_IMR1_IM4_Msk          (0x1U << EXTI_IMR1_IM4_Pos)                 /*!< 0x00000010 */
#define EXTI_IMR1_IM4              EXTI_IMR1_IM4_Msk                           /*!< Interrupt Mask on line 4 */
#define EXTI_IMR1_IM5_Pos          (5U)
#define EXTI_IMR1_IM5_Msk          (0x1U << EXTI_IMR1_IM5_Pos)                 /*!< 0x00000020 */
#define EXTI_IMR1_IM5              EXTI_IMR1_IM5_Msk                           /*!< Interrupt Mask on line 5 */
#define EXTI_IMR1_IM6_Pos          (6U)
#define EXTI_IMR1_IM6_Msk          (0x1U << EXTI_IMR1_IM6_Pos)                 /*!< 0x00000040 */
#define EXTI_IMR1_IM6              EXTI_IMR1_IM6_Msk                           /*!< Interrupt Mask on line 6 */
#define EXTI_IMR1_IM7_Pos          (7U)
#define EXTI_IMR1_IM7_Msk          (0x1U << EXTI_IMR1_IM7_Pos)                 /*!< 0x00000080 */
#define EXTI_IMR1_IM7              EXTI_IMR1_IM7_Msk                           /*!< Interrupt Mask on line 7 */
#define EXTI_IMR1_IM8_Pos          (8U)
#define EXTI_IMR1_IM8_Msk          (0x1U << EXTI_IMR1_IM8_Pos)                 /*!< 0x00000100 */
#define EXTI_IMR1_IM8              EXTI_IMR1_IM8_Msk                           /*!< Interrupt Mask on line 8 */
#define EXTI_IMR1_IM9_Pos          (9U)
#define EXTI_IMR1_IM9_Msk          (0x1U << EXTI_IMR1_IM9_Pos)                 /*!< 0x00000200 */
#define EXTI_IMR1_IM9              EXTI_IMR1_IM9_Msk                           /*!< Interrupt Mask on line 9 */
#define EXTI_IMR1_IM10_Pos         (10U)
#define EXTI_IMR1_IM10_Msk         (0x1U << EXTI_IMR1_IM10_Pos)                /*!< 0x00000400 */
#define EXTI_IMR1_IM10             EXTI_IMR1_IM10_Msk                          /*!< Interrupt Mask on line 10 */
#define EXTI_IMR1_IM11_Pos         (11U)
#define EXTI_IMR1_IM11_Msk         (0x1U << EXTI_IMR1_IM11_Pos)                /*!< 0x00000800 */
#define EXTI_IMR1_IM11             EXTI_IMR1_IM11_Msk                          /*!< Interrupt Mask on line 11 */
#define EXTI_IMR1_IM12_Pos         (12U)
#define EXTI_IMR1_IM12_Msk         (0x1U << EXTI_IMR1_IM12_Pos)                /*!< 0x00001000 */
#define EXTI_IMR1_IM12             EXTI_IMR1_IM12_Msk                          /*!< Interrupt Mask on line 12 */
#define EXTI_IMR1_IM13_Pos         (13U)
#define EXTI_IMR1_IM13_Msk         (0x1U << EXTI_IMR1_IM13_Pos)                /*!< 0x00002000 */
#define EXTI_IMR1_IM13             EXTI_IMR1_IM13_Msk                          /*!< Interrupt Mask on line 13 */
#define EXTI_IMR1_IM14_Pos         (14U)
#define EXTI_IMR1_IM14_Msk         (0x1U << EXTI_IMR1_IM14_Pos)                /*!< 0x00004000 */
#define EXTI_IMR1_IM14             EXTI_IMR1_IM14_Msk                          /*!< Interrupt Mask on line 14 */
#define EXTI_IMR1_IM15_Pos         (15U)
#define EXTI_IMR1_IM15_Msk         (0x1U << EXTI_IMR1_IM15_Pos)                /*!< 0x00008000 */
#define EXTI_IMR1_IM15             EXTI_IMR1_IM15_Msk                          /*!< Interrupt Mask on line 15 */
#define EXTI_IMR1_IM16_Pos         (16U)
#define EXTI_IMR1_IM16_Msk         (0x1U << EXTI_IMR1_IM16_Pos)                /*!< 0x00010000 */
#define EXTI_IMR1_IM16             EXTI_IMR1_IM16_Msk                          /*!< Interrupt Mask on line 16 */
#define EXTI_IMR1_IM17_Pos         (17U)
#define EXTI_IMR1_IM17_Msk         (0x1U << EXTI_IMR1_IM17_Pos)                /*!< 0x00020000 */
#define EXTI_IMR1_IM17             EXTI_IMR1_IM17_Msk                          /*!< Interrupt Mask on line 17 */
#define EXTI_IMR1_IM18_Pos         (18U)
#define EXTI_IMR1_IM18_Msk         (0x1U << EXTI_IMR1_IM18_Pos)                /*!< 0x00040000 */
#define EXTI_IMR1_IM18             EXTI_IMR1_IM18_Msk                          /*!< Interrupt Mask on line 18 */
#define EXTI_IMR1_IM19_Pos         (19U)
#define EXTI_IMR1_IM19_Msk         (0x1U << EXTI_IMR1_IM19_Pos)                /*!< 0x00080000 */
#define EXTI_IMR1_IM19             EXTI_IMR1_IM19_Msk                          /*!< Interrupt Mask on line 19 */
#define EXTI_IMR1_IM20_Pos         (20U)
#define EXTI_IMR1_IM20_Msk         (0x1U << EXTI_IMR1_IM20_Pos)                /*!< 0x00100000 */
#define EXTI_IMR1_IM20             EXTI_IMR1_IM20_Msk                          /*!< Interrupt Mask on line 20 */
#define EXTI_IMR1_IM21_Pos         (21U)
#define EXTI_IMR1_IM21_Msk         (0x1U << EXTI_IMR1_IM21_Pos)                /*!< 0x00200000 */
#define EXTI_IMR1_IM21             EXTI_IMR1_IM21_Msk                          /*!< Interrupt Mask on line 21 */
#define EXTI_IMR1_IM22_Pos         (22U)
#define EXTI_IMR1_IM22_Msk         (0x1U << EXTI_IMR1_IM22_Pos)                /*!< 0x00400000 */
#define EXTI_IMR1_IM22             EXTI_IMR1_IM22_Msk                          /*!< Interrupt Mask on line 22 */
#define EXTI_IMR1_IM23_Pos         (23U)
#define EXTI_IMR1_IM23_Msk         (0x1U << EXTI_IMR1_IM23_Pos)                /*!< 0x00800000 */
#define EXTI_IMR1_IM23             EXTI_IMR1_IM23_Msk                          /*!< Interrupt Mask on line 23 */
#define EXTI_IMR1_IM24_Pos         (24U)
#define EXTI_IMR1_IM24_Msk         (0x1U << EXTI_IMR1_IM24_Pos)                /*!< 0x01000000 */
#define EXTI_IMR1_IM24             EXTI_IMR1_IM24_Msk                          /*!< Interrupt Mask on line 24 */
#define EXTI_IMR1_IM25_Pos         (25U)
#define EXTI_IMR1_IM25_Msk         (0x1U << EXTI_IMR1_IM25_Pos)                /*!< 0x02000000 */
#define EXTI_IMR1_IM25             EXTI_IMR1_IM25_Msk                          /*!< Interrupt Mask on line 25 */
#define EXTI_IMR1_IM26_Pos         (26U)
#define EXTI_IMR1_IM26_Msk         (0x1U << EXTI_IMR1_IM26_Pos)                /*!< 0x04000000 */
#define EXTI_IMR1_IM26             EXTI_IMR1_IM26_Msk                          /*!< Interrupt Mask on line 26 */
#define EXTI_IMR1_IM27_Pos         (27U)
#define EXTI_IMR1_IM27_Msk         (0x1U << EXTI_IMR1_IM27_Pos)                /*!< 0x08000000 */
#define EXTI_IMR1_IM27             EXTI_IMR1_IM27_Msk                          /*!< Interrupt Mask on line 27 */
#define EXTI_IMR1_IM28_Pos         (28U)
#define EXTI_IMR1_IM28_Msk         (0x1U << EXTI_IMR1_IM28_Pos)                /*!< 0x10000000 */
#define EXTI_IMR1_IM28             EXTI_IMR1_IM28_Msk                          /*!< Interrupt Mask on line 28 */
#define EXTI_IMR1_IM29_Pos         (29U)
#define EXTI_IMR1_IM29_Msk         (0x1U << EXTI_IMR1_IM29_Pos)                /*!< 0x20000000 */
#define EXTI_IMR1_IM29             EXTI_IMR1_IM29_Msk                          /*!< Interrupt Mask on line 29 */
#define EXTI_IMR1_IM30_Pos         (30U)
#define EXTI_IMR1_IM30_Msk         (0x1U << EXTI_IMR1_IM30_Pos)                /*!< 0x40000000 */
#define EXTI_IMR1_IM30             EXTI_IMR1_IM30_Msk                          /*!< Interrupt Mask on line 30 */
#define EXTI_IMR1_IM31_Pos         (31U)
#define EXTI_IMR1_IM31_Msk         (0x1U << EXTI_IMR1_IM31_Pos)                /*!< 0x80000000 */
#define EXTI_IMR1_IM31             EXTI_IMR1_IM31_Msk                          /*!< Interrupt Mask on line 31 */
/*******************  Bit definition for EXTI_IMR2 register  *******************/
#define EXTI_IMR2_IM32_Pos         (0U)
#define EXTI_IMR2_IM32_Msk         (0x1U << EXTI_IMR2_IM32_Pos)                /*!< 0x00000001 */
#define EXTI_IMR2_IM32             EXTI_IMR2_IM32_Msk                          /*!< Interrupt Mask on line 32 */
#define EXTI_IMR2_IM33_Pos         (1U)
#define EXTI_IMR2_IM33_Msk         (0x1U << EXTI_IMR2_IM33_Pos)                /*!< 0x00000002 */
#define EXTI_IMR2_IM33             EXTI_IMR2_IM33_Msk                          /*!< Interrupt Mask on line 33 */
#define EXTI_IMR2_IM34_Pos         (2U)
#define EXTI_IMR2_IM34_Msk         (0x1U << EXTI_IMR2_IM34_Pos)                /*!< 0x00000004 */
#define EXTI_IMR2_IM34             EXTI_IMR2_IM34_Msk                          /*!< Interrupt Mask on line 34 */
#define EXTI_IMR2_IM35_Pos         (3U)
#define EXTI_IMR2_IM35_Msk         (0x1U << EXTI_IMR2_IM35_Pos)                /*!< 0x00000008 */
#define EXTI_IMR2_IM35             EXTI_IMR2_IM35_Msk                          /*!< Interrupt Mask on line 35 */
#define EXTI_IMR2_IM36_Pos         (4U)
#define EXTI_IMR2_IM36_Msk         (0x1U << EXTI_IMR2_IM36_Pos)                /*!< 0x00000010 */
#define EXTI_IMR2_IM36             EXTI_IMR2_IM36_Msk                          /*!< Interrupt Mask on line 36 */
#define EXTI_IMR2_IM37_Pos         (5U)
#define EXTI_IMR2_IM37_Msk         (0x1U << EXTI_IMR2_IM37_Pos)                /*!< 0x00000020 */
#define EXTI_IMR2_IM37             EXTI_IMR2_IM37_Msk                          /*!< Interrupt Mask on line 37 */
#define EXTI_IMR2_IM38_Pos         (6U)
#define EXTI_IMR2_IM38_Msk         (0x1U << EXTI_IMR2_IM38_Pos)                /*!< 0x00000040 */
#define EXTI_IMR2_IM38             EXTI_IMR2_IM38_Msk                          /*!< Interrupt Mask on line 38 */
#define EXTI_IMR2_IM39_Pos         (7U)
#define EXTI_IMR2_IM39_Msk         (0x1U << EXTI_IMR2_IM39_Pos)                /*!< 0x00000080 */
#define EXTI_IMR2_IM39             EXTI_IMR2_IM39_Msk                          /*!< Interrupt Mask on line 39 */
#define EXTI_IMR2_IM40_Pos         (8U)
#define EXTI_IMR2_IM40_Msk         (0x1U << EXTI_IMR2_IM40_Pos)                /*!< 0x00000100 */
#define EXTI_IMR2_IM40             EXTI_IMR2_IM40_Msk                          /*!< Interrupt Mask on line 40 */
#define EXTI_IMR2_IM41_Pos         (9U)
#define EXTI_IMR2_IM41_Msk         (0x1U << EXTI_IMR2_IM41_Pos)                /*!< 0x00000200 */
#define EXTI_IMR2_IM41             EXTI_IMR2_IM41_Msk                          /*!< Interrupt Mask on line 41 */
#define EXTI_IMR2_IM42_Pos         (10U)
#define EXTI_IMR2_IM42_Msk         (0x1U << EXTI_IMR2_IM42_Pos)                /*!< 0x00000400 */
#define EXTI_IMR2_IM42             EXTI_IMR2_IM42_Msk                          /*!< Interrupt Mask on line 42 */
#define EXTI_IMR2_IM43_Pos         (11U)
#define EXTI_IMR2_IM43_Msk         (0x1U << EXTI_IMR2_IM43_Pos)                /*!< 0x00000800 */
#define EXTI_IMR2_IM43             EXTI_IMR2_IM43_Msk                          /*!< Interrupt Mask on line 43 */
#define EXTI_IMR2_IM44_Pos         (12U)
#define EXTI_IMR2_IM44_Msk         (0x1U << EXTI_IMR2_IM44_Pos)                /*!< 0x00001000 */
#define EXTI_IMR2_IM44             EXTI_IMR2_IM44_Msk                          /*!< Interrupt Mask on line 44 */
#define EXTI_IMR2_IM45_Pos         (13U)
#define EXTI_IMR2_IM45_Msk         (0x1U << EXTI_IMR2_IM45_Pos)                /*!< 0x00002000 */
#define EXTI_IMR2_IM45             EXTI_IMR2_IM45_Msk                          /*!< Interrupt Mask on line 45 */
#define EXTI_IMR2_IM46_Pos         (14U)
#define EXTI_IMR2_IM46_Msk         (0x1U << EXTI_IMR2_IM46_Pos)                /*!< 0x00004000 */
#define EXTI_IMR2_IM46             EXTI_IMR2_IM46_Msk                          /*!< Interrupt Mask on line 46 */
#define EXTI_IMR2_IM47_Pos         (15U)
#define EXTI_IMR2_IM47_Msk         (0x1U << EXTI_IMR2_IM47_Pos)                /*!< 0x00008000 */
#define EXTI_IMR2_IM47             EXTI_IMR2_IM47_Msk                          /*!< Interrupt Mask on line 47 */
#define EXTI_IMR2_IM48_Pos         (16U)
#define EXTI_IMR2_IM48_Msk         (0x1U << EXTI_IMR2_IM48_Pos)                /*!< 0x00010000 */
#define EXTI_IMR2_IM48             EXTI_IMR2_IM48_Msk                          /*!< Interrupt Mask on line 48 */
#define EXTI_IMR2_IM49_Pos         (17U)
#define EXTI_IMR2_IM49_Msk         (0x1U << EXTI_IMR2_IM49_Pos)                /*!< 0x00020000 */
#define EXTI_IMR2_IM49             EXTI_IMR2_IM49_Msk                          /*!< Interrupt Mask on line 49 */
#define EXTI_IMR2_IM50_Pos         (18U)
#define EXTI_IMR2_IM50_Msk         (0x1U << EXTI_IMR2_IM50_Pos)                /*!< 0x00040000 */
#define EXTI_IMR2_IM50             EXTI_IMR2_IM50_Msk                          /*!< Interrupt Mask on line 50 */
#define EXTI_IMR2_IM51_Pos         (19U)
#define EXTI_IMR2_IM51_Msk         (0x1U << EXTI_IMR2_IM51_Pos)                /*!< 0x00080000 */
#define EXTI_IMR2_IM51             EXTI_IMR2_IM51_Msk                          /*!< Interrupt Mask on line 51 */
#define EXTI_IMR2_IM52_Pos         (20U)
#define EXTI_IMR2_IM52_Msk         (0x1U << EXTI_IMR2_IM52_Pos)                /*!< 0x00100000 */
#define EXTI_IMR2_IM52             EXTI_IMR2_IM52_Msk                          /*!< Interrupt Mask on line 52 */
#define EXTI_IMR2_IM53_Pos         (21U)
#define EXTI_IMR2_IM53_Msk         (0x1U << EXTI_IMR2_IM53_Pos)                /*!< 0x00200000 */
#define EXTI_IMR2_IM53             EXTI_IMR2_IM53_Msk                          /*!< Interrupt Mask on line 53 */
#define EXTI_IMR2_IM54_Pos         (22U)
#define EXTI_IMR2_IM54_Msk         (0x1U << EXTI_IMR2_IM54_Pos)                /*!< 0x00400000 */
#define EXTI_IMR2_IM54             EXTI_IMR2_IM54_Msk                          /*!< Interrupt Mask on line 54 */
#define EXTI_IMR2_IM55_Pos         (23U)
#define EXTI_IMR2_IM55_Msk         (0x1U << EXTI_IMR2_IM55_Pos)                /*!< 0x00800000 */
#define EXTI_IMR2_IM55             EXTI_IMR2_IM55_Msk                          /*!< Interrupt Mask on line 55 */
#define EXTI_IMR2_IM56_Pos         (24U)
#define EXTI_IMR2_IM56_Msk         (0x1U << EXTI_IMR2_IM56_Pos)                /*!< 0x01000000 */
#define EXTI_IMR2_IM56             EXTI_IMR2_IM56_Msk                          /*!< Interrupt Mask on line 56 */
#define EXTI_IMR2_IM57_Pos         (25U)
#define EXTI_IMR2_IM57_Msk         (0x1U << EXTI_IMR2_IM57_Pos)                /*!< 0x02000000 */
#define EXTI_IMR2_IM57             EXTI_IMR2_IM57_Msk                          /*!< Interrupt Mask on line 57 */
#define EXTI_IMR2_IM58_Pos         (26U)
#define EXTI_IMR2_IM58_Msk         (0x1U << EXTI_IMR2_IM58_Pos)                /*!< 0x04000000 */
#define EXTI_IMR2_IM58             EXTI_IMR2_IM58_Msk                          /*!< Interrupt Mask on line 58 */
#define EXTI_IMR2_IM59_Pos         (27U)
#define EXTI_IMR2_IM59_Msk         (0x1U << EXTI_IMR2_IM59_Pos)                /*!< 0x08000000 */
#define EXTI_IMR2_IM59             EXTI_IMR2_IM59_Msk                          /*!< Interrupt Mask on line 59 */
#define EXTI_IMR2_IM60_Pos         (28U)
#define EXTI_IMR2_IM60_Msk         (0x1U << EXTI_IMR2_IM60_Pos)                /*!< 0x10000000 */
#define EXTI_IMR2_IM60             EXTI_IMR2_IM60_Msk                          /*!< Interrupt Mask on line 60 */
#define EXTI_IMR2_IM61_Pos         (29U)
#define EXTI_IMR2_IM61_Msk         (0x1U << EXTI_IMR2_IM61_Pos)                /*!< 0x20000000 */
#define EXTI_IMR2_IM61             EXTI_IMR2_IM61_Msk                          /*!< Interrupt Mask on line 61 */
#define EXTI_IMR2_IM62_Pos         (30U)
#define EXTI_IMR2_IM62_Msk         (0x1U << EXTI_IMR2_IM62_Pos)                /*!< 0x40000000 */
#define EXTI_IMR2_IM62             EXTI_IMR2_IM62_Msk                          /*!< Interrupt Mask on line 62 */
#define EXTI_IMR2_IM63_Pos         (31U)
#define EXTI_IMR2_IM63_Msk         (0x1U << EXTI_IMR2_IM63_Pos)                /*!< 0x80000000 */
#define EXTI_IMR2_IM63             EXTI_IMR2_IM63_Msk                          /*!< Interrupt Mask on line 63 */
/*******************  Bit definition for EXTI_IMR3 register  *******************/
#define EXTI_IMR3_IM64_Pos         (0U)
#define EXTI_IMR3_IM64_Msk         (0x1U << EXTI_IMR3_IM64_Pos)                /*!< 0x00000001 */
#define EXTI_IMR3_IM64             EXTI_IMR3_IM64_Msk                          /*!< Interrupt Mask on line 64 */
#define EXTI_IMR3_IM65_Pos         (1U)
#define EXTI_IMR3_IM65_Msk         (0x1U << EXTI_IMR3_IM65_Pos)                /*!< 0x00000002 */
#define EXTI_IMR3_IM65             EXTI_IMR3_IM65_Msk                          /*!< Interrupt Mask on line 65 */
#define EXTI_IMR3_IM66_Pos         (2U)
#define EXTI_IMR3_IM66_Msk         (0x1U << EXTI_IMR3_IM66_Pos)                /*!< 0x00000004 */
#define EXTI_IMR3_IM66             EXTI_IMR3_IM66_Msk                          /*!< Interrupt Mask on line 66 */
#define EXTI_IMR3_IM67_Pos         (3U)
#define EXTI_IMR3_IM67_Msk         (0x1U << EXTI_IMR3_IM67_Pos)                /*!< 0x00000008 */
#define EXTI_IMR3_IM67             EXTI_IMR3_IM67_Msk                          /*!< Interrupt Mask on line 67 */
#define EXTI_IMR3_IM68_Pos         (4U)
#define EXTI_IMR3_IM68_Msk         (0x1U << EXTI_IMR3_IM68_Pos)                /*!< 0x00000010 */
#define EXTI_IMR3_IM68             EXTI_IMR3_IM68_Msk                          /*!< Interrupt Mask on line 68 */
#define EXTI_IMR3_IM69_Pos         (5U)
#define EXTI_IMR3_IM69_Msk         (0x1U << EXTI_IMR3_IM69_Pos)                /*!< 0x00000020 */
#define EXTI_IMR3_IM69             EXTI_IMR3_IM69_Msk                          /*!< Interrupt Mask on line 69 */
#define EXTI_IMR3_IM70_Pos         (6U)
#define EXTI_IMR3_IM70_Msk         (0x1U << EXTI_IMR3_IM70_Pos)                /*!< 0x00000040 */
#define EXTI_IMR3_IM70             EXTI_IMR3_IM70_Msk                          /*!< Interrupt Mask on line 70 */
#define EXTI_IMR3_IM71_Pos         (7U)
#define EXTI_IMR3_IM71_Msk         (0x1U << EXTI_IMR3_IM71_Pos)                /*!< 0x00000080 */
#define EXTI_IMR3_IM71             EXTI_IMR3_IM71_Msk                          /*!< Interrupt Mask on line 71 */
#define EXTI_IMR3_IM72_Pos         (8U)
#define EXTI_IMR3_IM72_Msk         (0x1U << EXTI_IMR3_IM72_Pos)                /*!< 0x00000100 */
#define EXTI_IMR3_IM72             EXTI_IMR3_IM72_Msk                          /*!< Interrupt Mask on line 72 */
#define EXTI_IMR3_IM73_Pos         (9U)
#define EXTI_IMR3_IM73_Msk         (0x1U << EXTI_IMR3_IM73_Pos)                /*!< 0x00000200 */
#define EXTI_IMR3_IM73             EXTI_IMR3_IM73_Msk                          /*!< Interrupt Mask on line 73 */
#define EXTI_IMR3_IM74_Pos         (10U)
#define EXTI_IMR3_IM74_Msk         (0x1U << EXTI_IMR3_IM74_Pos)                /*!< 0x00000400 */
#define EXTI_IMR3_IM74             EXTI_IMR3_IM74_Msk                          /*!< Interrupt Mask on line 74 */
#define EXTI_IMR3_IM75_Pos         (11U)
#define EXTI_IMR3_IM75_Msk         (0x1U << EXTI_IMR3_IM75_Pos)                /*!< 0x00000800 */
#define EXTI_IMR3_IM75             EXTI_IMR3_IM75_Msk                          /*!< Interrupt Mask on line 75 */
#define EXTI_IMR3_IM76_Pos         (12U)
#define EXTI_IMR3_IM76_Msk         (0x1U << EXTI_IMR3_IM76_Pos)                /*!< 0x00001000 */
#define EXTI_IMR3_IM76             EXTI_IMR3_IM76_Msk                          /*!< Interrupt Mask on line 76 */
#define EXTI_IMR3_IM77_Pos         (13U)
#define EXTI_IMR3_IM77_Msk         (0x1U << EXTI_IMR3_IM77_Pos)                /*!< 0x00002000 */
#define EXTI_IMR3_IM77             EXTI_IMR3_IM77_Msk                          /*!< Interrupt Mask on line 77 */
#define EXTI_IMR3_IM78_Pos         (14U)
#define EXTI_IMR3_IM78_Msk         (0x1U << EXTI_IMR3_IM78_Pos)                /*!< 0x00004000 */
#define EXTI_IMR3_IM78             EXTI_IMR3_IM78_Msk                          /*!< Interrupt Mask on line 78 */
#define EXTI_IMR3_IM79_Pos         (15U)
#define EXTI_IMR3_IM79_Msk         (0x1U << EXTI_IMR3_IM79_Pos)                /*!< 0x00008000 */
#define EXTI_IMR3_IM79             EXTI_IMR3_IM79_Msk                          /*!< Interrupt Mask on line 79 */
#define EXTI_IMR3_IM80_Pos         (16U)
#define EXTI_IMR3_IM80_Msk         (0x1U << EXTI_IMR3_IM80_Pos)                /*!< 0x00010000 */
#define EXTI_IMR3_IM80             EXTI_IMR3_IM80_Msk                          /*!< Interrupt Mask on line 80 */
#define EXTI_IMR3_IM81_Pos         (17U)
#define EXTI_IMR3_IM81_Msk         (0x1U << EXTI_IMR3_IM81_Pos)                /*!< 0x00020000 */
#define EXTI_IMR3_IM81             EXTI_IMR3_IM81_Msk                          /*!< Interrupt Mask on line 81 */
#define EXTI_IMR3_IM82_Pos         (18U)
#define EXTI_IMR3_IM82_Msk         (0x1U << EXTI_IMR3_IM82_Pos)                /*!< 0x00040000 */
#define EXTI_IMR3_IM82             EXTI_IMR3_IM82_Msk                          /*!< Interrupt Mask on line 82 */
#define EXTI_IMR3_IM84_Pos         (20U)
#define EXTI_IMR3_IM84_Msk         (0x1U << EXTI_IMR3_IM84_Pos)                /*!< 0x00100000 */
#define EXTI_IMR3_IM84             EXTI_IMR3_IM84_Msk                          /*!< Interrupt Mask on line 84 */
#define EXTI_IMR3_IM85_Pos         (21U)
#define EXTI_IMR3_IM85_Msk         (0x1U << EXTI_IMR3_IM85_Pos)                /*!< 0x00200000 */
#define EXTI_IMR3_IM85             EXTI_IMR3_IM85_Msk                          /*!< Interrupt Mask on line 85 */
#define EXTI_IMR3_IM86_Pos         (22U)
#define EXTI_IMR3_IM86_Msk         (0x1U << EXTI_IMR3_IM86_Pos)                /*!< 0x00400000 */
#define EXTI_IMR3_IM86             EXTI_IMR3_IM86_Msk                          /*!< Interrupt Mask on line 86 */
#define EXTI_IMR3_IM87_Pos         (23U)
#define EXTI_IMR3_IM87_Msk         (0x1U << EXTI_IMR3_IM87_Pos)                /*!< 0x00800000 */
#define EXTI_IMR3_IM87             EXTI_IMR3_IM87_Msk                          /*!< Interrupt Mask on line 87 */
#define EXTI_IMR3_IM88_Pos         (24U)
#define EXTI_IMR3_IM88_Msk         (0x1U << EXTI_IMR3_IM88_Pos)                /*!< 0x01000000 */
#define EXTI_IMR3_IM88             EXTI_IMR3_IM88_Msk                          /*!< Interrupt Mask on line 88 */
/*******************  Bit definition for EXTI_EMR1 register  *******************/
#define EXTI_EMR1_EM0_Pos          (0U)
#define EXTI_EMR1_EM0_Msk          (0x1U << EXTI_EMR1_EM0_Pos)                 /*!< 0x00000001 */
#define EXTI_EMR1_EM0              EXTI_EMR1_EM0_Msk                           /*!< Event Mask on line 0 */
#define EXTI_EMR1_EM1_Pos          (1U)
#define EXTI_EMR1_EM1_Msk          (0x1U << EXTI_EMR1_EM1_Pos)                 /*!< 0x00000002 */
#define EXTI_EMR1_EM1              EXTI_EMR1_EM1_Msk                           /*!< Event Mask on line 1 */
#define EXTI_EMR1_EM2_Pos          (2U)
#define EXTI_EMR1_EM2_Msk          (0x1U << EXTI_EMR1_EM2_Pos)                 /*!< 0x00000004 */
#define EXTI_EMR1_EM2              EXTI_EMR1_EM2_Msk                           /*!< Event Mask on line 2 */
#define EXTI_EMR1_EM3_Pos          (3U)
#define EXTI_EMR1_EM3_Msk          (0x1U << EXTI_EMR1_EM3_Pos)                 /*!< 0x00000008 */
#define EXTI_EMR1_EM3              EXTI_EMR1_EM3_Msk                           /*!< Event Mask on line 3 */
#define EXTI_EMR1_EM4_Pos          (4U)
#define EXTI_EMR1_EM4_Msk          (0x1U << EXTI_EMR1_EM4_Pos)                 /*!< 0x00000010 */
#define EXTI_EMR1_EM4              EXTI_EMR1_EM4_Msk                           /*!< Event Mask on line 4 */
#define EXTI_EMR1_EM5_Pos          (5U)
#define EXTI_EMR1_EM5_Msk          (0x1U << EXTI_EMR1_EM5_Pos)                 /*!< 0x00000020 */
#define EXTI_EMR1_EM5              EXTI_EMR1_EM5_Msk                           /*!< Event Mask on line 5 */
#define EXTI_EMR1_EM6_Pos          (6U)
#define EXTI_EMR1_EM6_Msk          (0x1U << EXTI_EMR1_EM6_Pos)                 /*!< 0x00000040 */
#define EXTI_EMR1_EM6              EXTI_EMR1_EM6_Msk                           /*!< Event Mask on line 6 */
#define EXTI_EMR1_EM7_Pos          (7U)
#define EXTI_EMR1_EM7_Msk          (0x1U << EXTI_EMR1_EM7_Pos)                 /*!< 0x00000080 */
#define EXTI_EMR1_EM7              EXTI_EMR1_EM7_Msk                           /*!< Event Mask on line 7 */
#define EXTI_EMR1_EM8_Pos          (8U)
#define EXTI_EMR1_EM8_Msk          (0x1U << EXTI_EMR1_EM8_Pos)                 /*!< 0x00000100 */
#define EXTI_EMR1_EM8              EXTI_EMR1_EM8_Msk                           /*!< Event Mask on line 8 */
#define EXTI_EMR1_EM9_Pos          (9U)
#define EXTI_EMR1_EM9_Msk          (0x1U << EXTI_EMR1_EM9_Pos)                 /*!< 0x00000200 */
#define EXTI_EMR1_EM9              EXTI_EMR1_EM9_Msk                           /*!< Event Mask on line 9 */
#define EXTI_EMR1_EM10_Pos         (10U)
#define EXTI_EMR1_EM10_Msk         (0x1U << EXTI_EMR1_EM10_Pos)                /*!< 0x00000400 */
#define EXTI_EMR1_EM10             EXTI_EMR1_EM10_Msk                          /*!< Event Mask on line 10 */
#define EXTI_EMR1_EM11_Pos         (11U)
#define EXTI_EMR1_EM11_Msk         (0x1U << EXTI_EMR1_EM11_Pos)                /*!< 0x00000800 */
#define EXTI_EMR1_EM11             EXTI_EMR1_EM11_Msk                          /*!< Event Mask on line 11 */
#define EXTI_EMR1_EM12_Pos         (12U)
#define EXTI_EMR1_EM12_Msk         (0x1U << EXTI_EMR1_EM12_Pos)                /*!< 0x00001000 */
#define EXTI_EMR1_EM12             EXTI_EMR1_EM12_Msk                          /*!< Event Mask on line 12 */
#define EXTI_EMR1_EM13_Pos         (13U)
#define EXTI_EMR1_EM13_Msk         (0x1U << EXTI_EMR1_EM13_Pos)                /*!< 0x00002000 */
#define EXTI_EMR1_EM13             EXTI_EMR1_EM13_Msk                          /*!< Event Mask on line 13 */
#define EXTI_EMR1_EM14_Pos         (14U)
#define EXTI_EMR1_EM14_Msk         (0x1U << EXTI_EMR1_EM14_Pos)                /*!< 0x00004000 */
#define EXTI_EMR1_EM14             EXTI_EMR1_EM14_Msk                          /*!< Event Mask on line 14 */
#define EXTI_EMR1_EM15_Pos         (15U)
#define EXTI_EMR1_EM15_Msk         (0x1U << EXTI_EMR1_EM15_Pos)                /*!< 0x00008000 */
#define EXTI_EMR1_EM15             EXTI_EMR1_EM15_Msk                          /*!< Event Mask on line 15 */
#define EXTI_EMR1_EM16_Pos         (16U)
#define EXTI_EMR1_EM16_Msk         (0x1U << EXTI_EMR1_EM16_Pos)                /*!< 0x00010000 */
#define EXTI_EMR1_EM16             EXTI_EMR1_EM16_Msk                          /*!< Event Mask on line 16 */
#define EXTI_EMR1_EM17_Pos         (17U)
#define EXTI_EMR1_EM17_Msk         (0x1U << EXTI_EMR1_EM17_Pos)                /*!< 0x00020000 */
#define EXTI_EMR1_EM17             EXTI_EMR1_EM17_Msk                          /*!< Event Mask on line 17 */
#define EXTI_EMR1_EM18_Pos         (18U)
#define EXTI_EMR1_EM18_Msk         (0x1U << EXTI_EMR1_EM18_Pos)                /*!< 0x00040000 */
#define EXTI_EMR1_EM18             EXTI_EMR1_EM18_Msk                          /*!< Event Mask on line 18 */
#define EXTI_EMR1_EM20_Pos         (20U)
#define EXTI_EMR1_EM20_Msk         (0x1U << EXTI_EMR1_EM20_Pos)                /*!< 0x00100000 */
#define EXTI_EMR1_EM20             EXTI_EMR1_EM20_Msk                          /*!< Event Mask on line 20 */
#define EXTI_EMR1_EM21_Pos         (21U)
#define EXTI_EMR1_EM21_Msk         (0x1U << EXTI_EMR1_EM21_Pos)                /*!< 0x00200000 */
#define EXTI_EMR1_EM21             EXTI_EMR1_EM21_Msk                          /*!< Event Mask on line 21 */
#define EXTI_EMR1_EM22_Pos         (22U)
#define EXTI_EMR1_EM22_Msk         (0x1U << EXTI_EMR1_EM22_Pos)                /*!< 0x00400000 */
#define EXTI_EMR1_EM22             EXTI_EMR1_EM22_Msk                          /*!< Event Mask on line 22 */
#define EXTI_EMR1_EM23_Pos         (23U)
#define EXTI_EMR1_EM23_Msk         (0x1U << EXTI_EMR1_EM23_Pos)                /*!< 0x00800000 */
#define EXTI_EMR1_EM23             EXTI_EMR1_EM23_Msk                          /*!< Event Mask on line 23 */
#define EXTI_EMR1_EM24_Pos         (24U)
#define EXTI_EMR1_EM24_Msk         (0x1U << EXTI_EMR1_EM24_Pos)                /*!< 0x01000000 */
#define EXTI_EMR1_EM24             EXTI_EMR1_EM24_Msk                          /*!< Event Mask on line 24 */
#define EXTI_EMR1_EM25_Pos         (25U)
#define EXTI_EMR1_EM25_Msk         (0x1U << EXTI_EMR1_EM25_Pos)                /*!< 0x02000000 */
#define EXTI_EMR1_EM25             EXTI_EMR1_EM25_Msk                          /*!< Event Mask on line 25 */
#define EXTI_EMR1_EM26_Pos         (26U)
#define EXTI_EMR1_EM26_Msk         (0x1U << EXTI_EMR1_EM26_Pos)                /*!< 0x04000000 */
#define EXTI_EMR1_EM26             EXTI_EMR1_EM26_Msk                          /*!< Event Mask on line 26 */
#define EXTI_EMR1_EM27_Pos         (27U)
#define EXTI_EMR1_EM27_Msk         (0x1U << EXTI_EMR1_EM27_Pos)                /*!< 0x08000000 */
#define EXTI_EMR1_EM27             EXTI_EMR1_EM27_Msk                          /*!< Event Mask on line 27 */
#define EXTI_EMR1_EM28_Pos         (28U)
#define EXTI_EMR1_EM28_Msk         (0x1U << EXTI_EMR1_EM28_Pos)                /*!< 0x10000000 */
#define EXTI_EMR1_EM28             EXTI_EMR1_EM28_Msk                          /*!< Event Mask on line 28 */
#define EXTI_EMR1_EM29_Pos         (29U)
#define EXTI_EMR1_EM29_Msk         (0x1U << EXTI_EMR1_EM29_Pos)                /*!< 0x20000000 */
#define EXTI_EMR1_EM29             EXTI_EMR1_EM29_Msk                          /*!< Event Mask on line 29 */
#define EXTI_EMR1_EM30_Pos         (30U)
#define EXTI_EMR1_EM30_Msk         (0x1U << EXTI_EMR1_EM30_Pos)                /*!< 0x40000000 */
#define EXTI_EMR1_EM30             EXTI_EMR1_EM30_Msk                          /*!< Event Mask on line 30 */
#define EXTI_EMR1_EM31_Pos         (31U)
#define EXTI_EMR1_EM31_Msk         (0x1U << EXTI_EMR1_EM31_Pos)                /*!< 0x80000000 */
#define EXTI_EMR1_EM31             EXTI_EMR1_EM31_Msk                          /*!< Event Mask on line 31 */
/*******************  Bit definition for EXTI_EMR2 register  *******************/
#define EXTI_EMR2_EM32_Pos         (0U)
#define EXTI_EMR2_EM32_Msk         (0x1U << EXTI_EMR2_EM32_Pos)                /*!< 0x00000001 */
#define EXTI_EMR2_EM32             EXTI_EMR2_EM32_Msk                          /*!< Event Mask on line 32*/
#define EXTI_EMR2_EM33_Pos         (1U)
#define EXTI_EMR2_EM33_Msk         (0x1U << EXTI_EMR2_EM33_Pos)                /*!< 0x00000002 */
#define EXTI_EMR2_EM33             EXTI_EMR2_EM33_Msk                          /*!< Event Mask on line 33*/
#define EXTI_EMR2_EM34_Pos         (2U)
#define EXTI_EMR2_EM34_Msk         (0x1U << EXTI_EMR2_EM34_Pos)                /*!< 0x00000004 */
#define EXTI_EMR2_EM34             EXTI_EMR2_EM34_Msk                          /*!< Event Mask on line 34*/
#define EXTI_EMR2_EM35_Pos         (3U)
#define EXTI_EMR2_EM35_Msk         (0x1U << EXTI_EMR2_EM35_Pos)                /*!< 0x00000008 */
#define EXTI_EMR2_EM35             EXTI_EMR2_EM35_Msk                          /*!< Event Mask on line 35*/
#define EXTI_EMR2_EM36_Pos         (4U)
#define EXTI_EMR2_EM36_Msk         (0x1U << EXTI_EMR2_EM36_Pos)                /*!< 0x00000010 */
#define EXTI_EMR2_EM36             EXTI_EMR2_EM36_Msk                          /*!< Event Mask on line 36*/
#define EXTI_EMR2_EM37_Pos         (5U)
#define EXTI_EMR2_EM37_Msk         (0x1U << EXTI_EMR2_EM37_Pos)                /*!< 0x00000020 */
#define EXTI_EMR2_EM37             EXTI_EMR2_EM37_Msk                          /*!< Event Mask on line 37*/
#define EXTI_EMR2_EM38_Pos         (6U)
#define EXTI_EMR2_EM38_Msk         (0x1U << EXTI_EMR2_EM38_Pos)                /*!< 0x00000040 */
#define EXTI_EMR2_EM38             EXTI_EMR2_EM38_Msk                          /*!< Event Mask on line 38*/
#define EXTI_EMR2_EM39_Pos         (7U)
#define EXTI_EMR2_EM39_Msk         (0x1U << EXTI_EMR2_EM39_Pos)                /*!< 0x00000080 */
#define EXTI_EMR2_EM39             EXTI_EMR2_EM39_Msk                          /*!< Event Mask on line 39*/
#define EXTI_EMR2_EM40_Pos         (8U)
#define EXTI_EMR2_EM40_Msk         (0x1U << EXTI_EMR2_EM40_Pos)                /*!< 0x00000100 */
#define EXTI_EMR2_EM40             EXTI_EMR2_EM40_Msk                          /*!< Event Mask on line 40*/
#define EXTI_EMR2_EM41_Pos         (9U)
#define EXTI_EMR2_EM41_Msk         (0x1U << EXTI_EMR2_EM41_Pos)                /*!< 0x00000200 */
#define EXTI_EMR2_EM41             EXTI_EMR2_EM41_Msk                          /*!< Event Mask on line 41*/
#define EXTI_EMR2_EM42_Pos         (10U)
#define EXTI_EMR2_EM42_Msk         (0x1U << EXTI_EMR2_EM42_Pos)                /*!< 0x00000400 */
#define EXTI_EMR2_EM42             EXTI_EMR2_EM42_Msk                          /*!< Event Mask on line 42 */
#define EXTI_EMR2_EM43_Pos         (11U)
#define EXTI_EMR2_EM43_Msk         (0x1U << EXTI_EMR2_EM43_Pos)                /*!< 0x00000800 */
#define EXTI_EMR2_EM43             EXTI_EMR2_EM43_Msk                          /*!< Event Mask on line 43 */
#define EXTI_EMR2_EM44_Pos         (12U)
#define EXTI_EMR2_EM44_Msk         (0x1U << EXTI_EMR2_EM44_Pos)                /*!< 0x00001000 */
#define EXTI_EMR2_EM44             EXTI_EMR2_EM44_Msk                          /*!< Event Mask on line 44 */
#define EXTI_EMR2_EM45_Pos         (13U)
#define EXTI_EMR2_EM45_Msk         (0x1U << EXTI_EMR2_EM45_Pos)                /*!< 0x00002000 */
#define EXTI_EMR2_EM45             EXTI_EMR2_EM45_Msk                          /*!< Event Mask on line 45 */
#define EXTI_EMR2_EM46_Pos         (14U)
#define EXTI_EMR2_EM46_Msk         (0x1U << EXTI_EMR2_EM46_Pos)                /*!< 0x00004000 */
#define EXTI_EMR2_EM46             EXTI_EMR2_EM46_Msk                          /*!< Event Mask on line 46 */
#define EXTI_EMR2_EM47_Pos         (15U)
#define EXTI_EMR2_EM47_Msk         (0x1U << EXTI_EMR2_EM47_Pos)                /*!< 0x00008000 */
#define EXTI_EMR2_EM47             EXTI_EMR2_EM47_Msk                          /*!< Event Mask on line 47 */
#define EXTI_EMR2_EM48_Pos         (16U)
#define EXTI_EMR2_EM48_Msk         (0x1U << EXTI_EMR2_EM48_Pos)                /*!< 0x00010000 */
#define EXTI_EMR2_EM48             EXTI_EMR2_EM48_Msk                          /*!< Event Mask on line 48 */
#define EXTI_EMR2_EM49_Pos         (17U)
#define EXTI_EMR2_EM49_Msk         (0x1U << EXTI_EMR2_EM49_Pos)                /*!< 0x00020000 */
#define EXTI_EMR2_EM49             EXTI_EMR2_EM49_Msk                          /*!< Event Mask on line 49 */
#define EXTI_EMR2_EM50_Pos         (18U)
#define EXTI_EMR2_EM50_Msk         (0x1U << EXTI_EMR2_EM50_Pos)                /*!< 0x00040000 */
#define EXTI_EMR2_EM50             EXTI_EMR2_EM50_Msk                          /*!< Event Mask on line 50 */
#define EXTI_EMR2_EM51_Pos         (19U)
#define EXTI_EMR2_EM51_Msk         (0x1U << EXTI_EMR2_EM51_Pos)                /*!< 0x00080000 */
#define EXTI_EMR2_EM51             EXTI_EMR2_EM51_Msk                          /*!< Event Mask on line 51 */
#define EXTI_EMR2_EM52_Pos         (20U)
#define EXTI_EMR2_EM52_Msk         (0x1U << EXTI_EMR2_EM52_Pos)                /*!< 0x00100000 */
#define EXTI_EMR2_EM52             EXTI_EMR2_EM52_Msk                          /*!< Event Mask on line 52 */
#define EXTI_EMR2_EM53_Pos         (21U)
#define EXTI_EMR2_EM53_Msk         (0x1U << EXTI_EMR2_EM53_Pos)                /*!< 0x00200000 */
#define EXTI_EMR2_EM53             EXTI_EMR2_EM53_Msk                          /*!< Event Mask on line 53 */
#define EXTI_EMR2_EM54_Pos         (22U)
#define EXTI_EMR2_EM54_Msk         (0x1U << EXTI_EMR2_EM54_Pos)                /*!< 0x00400000 */
#define EXTI_EMR2_EM54             EXTI_EMR2_EM54_Msk                          /*!< Event Mask on line 54 */
#define EXTI_EMR2_EM55_Pos         (23U)
#define EXTI_EMR2_EM55_Msk         (0x1U << EXTI_EMR2_EM55_Pos)                /*!< 0x00800000 */
#define EXTI_EMR2_EM55             EXTI_EMR2_EM55_Msk                          /*!< Event Mask on line 55 */
#define EXTI_EMR2_EM56_Pos         (24U)
#define EXTI_EMR2_EM56_Msk         (0x1U << EXTI_EMR2_EM56_Pos)                /*!< 0x01000000 */
#define EXTI_EMR2_EM56             EXTI_EMR2_EM56_Msk                          /*!< Event Mask on line 56 */
#define EXTI_EMR2_EM57_Pos         (25U)
#define EXTI_EMR2_EM57_Msk         (0x1U << EXTI_EMR2_EM57_Pos)                /*!< 0x02000000 */
#define EXTI_EMR2_EM57             EXTI_EMR2_EM57_Msk                          /*!< Event Mask on line 57 */
#define EXTI_EMR2_EM58_Pos         (26U)
#define EXTI_EMR2_EM58_Msk         (0x1U << EXTI_EMR2_EM58_Pos)                /*!< 0x04000000 */
#define EXTI_EMR2_EM58             EXTI_EMR2_EM58_Msk                          /*!< Event Mask on line 58 */
#define EXTI_EMR2_EM59_Pos         (27U)
#define EXTI_EMR2_EM59_Msk         (0x1U << EXTI_EMR2_EM59_Pos)                /*!< 0x08000000 */
#define EXTI_EMR2_EM59             EXTI_EMR2_EM59_Msk                          /*!< Event Mask on line 59 */
#define EXTI_EMR2_EM60_Pos         (28U)
#define EXTI_EMR2_EM60_Msk         (0x1U << EXTI_EMR2_EM60_Pos)                /*!< 0x10000000 */
#define EXTI_EMR2_EM60             EXTI_EMR2_EM60_Msk                          /*!< Event Mask on line 60 */
#define EXTI_EMR2_EM61_Pos         (29U)
#define EXTI_EMR2_EM61_Msk         (0x1U << EXTI_EMR2_EM61_Pos)                /*!< 0x20000000 */
#define EXTI_EMR2_EM61             EXTI_EMR2_EM61_Msk                          /*!< Event Mask on line 61 */
#define EXTI_EMR2_EM62_Pos         (30U)
#define EXTI_EMR2_EM62_Msk         (0x1U << EXTI_EMR2_EM62_Pos)                /*!< 0x40000000 */
#define EXTI_EMR2_EM62             EXTI_EMR2_EM62_Msk                          /*!< Event Mask on line 62 */
#define EXTI_EMR2_EM63_Pos         (31U)
#define EXTI_EMR2_EM63_Msk         (0x1U << EXTI_EMR2_EM63_Pos)                /*!< 0x80000000 */
#define EXTI_EMR2_EM63             EXTI_EMR2_EM63_Msk                          /*!< Event Mask on line 63 */
/*******************  Bit definition for EXTI_EMR3 register  *******************/
#define EXTI_EMR3_EM64_Pos         (0U)
#define EXTI_EMR3_EM64_Msk         (0x1U << EXTI_EMR3_EM64_Pos)                /*!< 0x00000001 */
#define EXTI_EMR3_EM64             EXTI_EMR3_EM64_Msk                          /*!< Event Mask on line 64*/
#define EXTI_EMR3_EM65_Pos         (1U)
#define EXTI_EMR3_EM65_Msk         (0x1U << EXTI_EMR3_EM65_Pos)                /*!< 0x00000002 */
#define EXTI_EMR3_EM65             EXTI_EMR3_EM65_Msk                          /*!< Event Mask on line 65*/
#define EXTI_EMR3_EM66_Pos         (2U)
#define EXTI_EMR3_EM66_Msk         (0x1U << EXTI_EMR3_EM66_Pos)                /*!< 0x00000004 */
#define EXTI_EMR3_EM66             EXTI_EMR3_EM66_Msk                          /*!< Event Mask on line 66*/
#define EXTI_EMR3_EM67_Pos         (3U)
#define EXTI_EMR3_EM67_Msk         (0x1U << EXTI_EMR3_EM67_Pos)                /*!< 0x00000008 */
#define EXTI_EMR3_EM67             EXTI_EMR3_EM67_Msk                          /*!< Event Mask on line 67*/
#define EXTI_EMR3_EM68_Pos         (4U)
#define EXTI_EMR3_EM68_Msk         (0x1U << EXTI_EMR3_EM68_Pos)                /*!< 0x00000010 */
#define EXTI_EMR3_EM68             EXTI_EMR3_EM68_Msk                          /*!< Event Mask on line 68*/
#define EXTI_EMR3_EM69_Pos         (5U)
#define EXTI_EMR3_EM69_Msk         (0x1U << EXTI_EMR3_EM69_Pos)                /*!< 0x00000020 */
#define EXTI_EMR3_EM69             EXTI_EMR3_EM69_Msk                          /*!< Event Mask on line 69*/
#define EXTI_EMR3_EM70_Pos         (6U)
#define EXTI_EMR3_EM70_Msk         (0x1U << EXTI_EMR3_EM70_Pos)                /*!< 0x00000040 */
#define EXTI_EMR3_EM70             EXTI_EMR3_EM70_Msk                          /*!< Event Mask on line 70*/
#define EXTI_EMR3_EM71_Pos         (7U)
#define EXTI_EMR3_EM71_Msk         (0x1U << EXTI_EMR3_EM71_Pos)                /*!< 0x00000080 */
#define EXTI_EMR3_EM71             EXTI_EMR3_EM71_Msk                          /*!< Event Mask on line 71*/
#define EXTI_EMR3_EM72_Pos         (8U)
#define EXTI_EMR3_EM72_Msk         (0x1U << EXTI_EMR3_EM72_Pos)                /*!< 0x00000100 */
#define EXTI_EMR3_EM72             EXTI_EMR3_EM72_Msk                          /*!< Event Mask on line 72*/
#define EXTI_EMR3_EM73_Pos         (9U)
#define EXTI_EMR3_EM73_Msk         (0x1U << EXTI_EMR3_EM73_Pos)                /*!< 0x00000200 */
#define EXTI_EMR3_EM73             EXTI_EMR3_EM73_Msk                          /*!< Event Mask on line 73*/
#define EXTI_EMR3_EM74_Pos         (10U)
#define EXTI_EMR3_EM74_Msk         (0x1U << EXTI_EMR3_EM74_Pos)                /*!< 0x00000400 */
#define EXTI_EMR3_EM74             EXTI_EMR3_EM74_Msk                          /*!< Event Mask on line 74 */
#define EXTI_EMR3_EM75_Pos         (11U)
#define EXTI_EMR3_EM75_Msk         (0x1U << EXTI_EMR3_EM75_Pos)                /*!< 0x00000800 */
#define EXTI_EMR3_EM75             EXTI_EMR3_EM75_Msk                          /*!< Event Mask on line 75 */
#define EXTI_EMR3_EM76_Pos         (12U)
#define EXTI_EMR3_EM76_Msk         (0x1U << EXTI_EMR3_EM76_Pos)                /*!< 0x00001000 */
#define EXTI_EMR3_EM76             EXTI_EMR3_EM76_Msk                          /*!< Event Mask on line 76 */
#define EXTI_EMR3_EM77_Pos         (13U)
#define EXTI_EMR3_EM77_Msk         (0x1U << EXTI_EMR3_EM77_Pos)                /*!< 0x00002000 */
#define EXTI_EMR3_EM77             EXTI_EMR3_EM77_Msk                          /*!< Event Mask on line 77 */
#define EXTI_EMR3_EM78_Pos         (14U)
#define EXTI_EMR3_EM78_Msk         (0x1U << EXTI_EMR3_EM78_Pos)                /*!< 0x00004000 */
#define EXTI_EMR3_EM78             EXTI_EMR3_EM78_Msk                          /*!< Event Mask on line 78 */
#define EXTI_EMR3_EM79_Pos         (15U)
#define EXTI_EMR3_EM79_Msk         (0x1U << EXTI_EMR3_EM79_Pos)                /*!< 0x00008000 */
#define EXTI_EMR3_EM79             EXTI_EMR3_EM79_Msk                          /*!< Event Mask on line 79 */
#define EXTI_EMR3_EM80_Pos         (16U)
#define EXTI_EMR3_EM80_Msk         (0x1U << EXTI_EMR3_EM80_Pos)                /*!< 0x00010000 */
#define EXTI_EMR3_EM80             EXTI_EMR3_EM80_Msk                          /*!< Event Mask on line 80 */
#define EXTI_EMR3_EM81_Pos         (17U)
#define EXTI_EMR3_EM81_Msk         (0x1U << EXTI_EMR3_EM81_Pos)                /*!< 0x00020000 */
#define EXTI_EMR3_EM81             EXTI_EMR3_EM81_Msk                          /*!< Event Mask on line 81 */
#define EXTI_EMR3_EM82_Pos         (18U)
#define EXTI_EMR3_EM82_Msk         (0x1U << EXTI_EMR3_EM82_Pos)                /*!< 0x00040000 */
#define EXTI_EMR3_EM82             EXTI_EMR3_EM82_Msk                          /*!< Event Mask on line 82 */
#define EXTI_EMR3_EM84_Pos         (20U)
#define EXTI_EMR3_EM84_Msk         (0x1U << EXTI_EMR3_EM84_Pos)                /*!< 0x00100000 */
#define EXTI_EMR3_EM84             EXTI_EMR3_EM84_Msk                          /*!< Event Mask on line 84 */
#define EXTI_EMR3_EM85_Pos         (21U)
#define EXTI_EMR3_EM85_Msk         (0x1U << EXTI_EMR3_EM85_Pos)                /*!< 0x00200000 */
#define EXTI_EMR3_EM85             EXTI_EMR3_EM85_Msk                          /*!< Event Mask on line 85 */
#define EXTI_EMR3_EM86_Pos         (22U)
#define EXTI_EMR3_EM86_Msk         (0x1U << EXTI_EMR3_EM86_Pos)                /*!< 0x00400000 */
#define EXTI_EMR3_EM86             EXTI_EMR3_EM86_Msk                          /*!< Event Mask on line 86 */
#define EXTI_EMR3_EM87_Pos         (23U)
#define EXTI_EMR3_EM87_Msk         (0x1U << EXTI_EMR3_EM87_Pos)                /*!< 0x00800000 */
#define EXTI_EMR3_EM87             EXTI_EMR3_EM87_Msk                          /*!< Event Mask on line 87 */
#define EXTI_EMR3_EM88_Pos         (24U)
#define EXTI_EMR3_EM88_Msk         (0x1U << EXTI_EMR3_EM88_Pos)                /*!< 0x01000000 */
#define EXTI_EMR3_EM88             EXTI_EMR3_EM88_Msk                          /*!< Event Mask on line 88 */
/******************  Bit definition for EXTI_RTSR1 register  *******************/
#define EXTI_RTSR1_TR0_Pos         (0U)
#define EXTI_RTSR1_TR0_Msk         (0x1U << EXTI_RTSR1_TR0_Pos)                /*!< 0x00000001 */
#define EXTI_RTSR1_TR0             EXTI_RTSR1_TR0_Msk                          /*!< Rising trigger event configuration bit of line 0 */
#define EXTI_RTSR1_TR1_Pos         (1U)
#define EXTI_RTSR1_TR1_Msk         (0x1U << EXTI_RTSR1_TR1_Pos)                /*!< 0x00000002 */
#define EXTI_RTSR1_TR1             EXTI_RTSR1_TR1_Msk                          /*!< Rising trigger event configuration bit of line 1 */
#define EXTI_RTSR1_TR2_Pos         (2U)
#define EXTI_RTSR1_TR2_Msk         (0x1U << EXTI_RTSR1_TR2_Pos)                /*!< 0x00000004 */
#define EXTI_RTSR1_TR2             EXTI_RTSR1_TR2_Msk                          /*!< Rising trigger event configuration bit of line 2 */
#define EXTI_RTSR1_TR3_Pos         (3U)
#define EXTI_RTSR1_TR3_Msk         (0x1U << EXTI_RTSR1_TR3_Pos)                /*!< 0x00000008 */
#define EXTI_RTSR1_TR3             EXTI_RTSR1_TR3_Msk                          /*!< Rising trigger event configuration bit of line 3 */
#define EXTI_RTSR1_TR4_Pos         (4U)
#define EXTI_RTSR1_TR4_Msk         (0x1U << EXTI_RTSR1_TR4_Pos)                /*!< 0x00000010 */
#define EXTI_RTSR1_TR4             EXTI_RTSR1_TR4_Msk                          /*!< Rising trigger event configuration bit of line 4 */
#define EXTI_RTSR1_TR5_Pos         (5U)
#define EXTI_RTSR1_TR5_Msk         (0x1U << EXTI_RTSR1_TR5_Pos)                /*!< 0x00000020 */
#define EXTI_RTSR1_TR5             EXTI_RTSR1_TR5_Msk                          /*!< Rising trigger event configuration bit of line 5 */
#define EXTI_RTSR1_TR6_Pos         (6U)
#define EXTI_RTSR1_TR6_Msk         (0x1U << EXTI_RTSR1_TR6_Pos)                /*!< 0x00000040 */
#define EXTI_RTSR1_TR6             EXTI_RTSR1_TR6_Msk                          /*!< Rising trigger event configuration bit of line 6 */
#define EXTI_RTSR1_TR7_Pos         (7U)
#define EXTI_RTSR1_TR7_Msk         (0x1U << EXTI_RTSR1_TR7_Pos)                /*!< 0x00000080 */
#define EXTI_RTSR1_TR7             EXTI_RTSR1_TR7_Msk                          /*!< Rising trigger event configuration bit of line 7 */
#define EXTI_RTSR1_TR8_Pos         (8U)
#define EXTI_RTSR1_TR8_Msk         (0x1U << EXTI_RTSR1_TR8_Pos)                /*!< 0x00000100 */
#define EXTI_RTSR1_TR8             EXTI_RTSR1_TR8_Msk                          /*!< Rising trigger event configuration bit of line 8 */
#define EXTI_RTSR1_TR9_Pos         (9U)
#define EXTI_RTSR1_TR9_Msk         (0x1U << EXTI_RTSR1_TR9_Pos)                /*!< 0x00000200 */
#define EXTI_RTSR1_TR9             EXTI_RTSR1_TR9_Msk                          /*!< Rising trigger event configuration bit of line 9 */
#define EXTI_RTSR1_TR10_Pos        (10U)
#define EXTI_RTSR1_TR10_Msk        (0x1U << EXTI_RTSR1_TR10_Pos)               /*!< 0x00000400 */
#define EXTI_RTSR1_TR10            EXTI_RTSR1_TR10_Msk                         /*!< Rising trigger event configuration bit of line 10 */
#define EXTI_RTSR1_TR11_Pos        (11U)
#define EXTI_RTSR1_TR11_Msk        (0x1U << EXTI_RTSR1_TR11_Pos)               /*!< 0x00000800 */
#define EXTI_RTSR1_TR11            EXTI_RTSR1_TR11_Msk                         /*!< Rising trigger event configuration bit of line 11 */
#define EXTI_RTSR1_TR12_Pos        (12U)
#define EXTI_RTSR1_TR12_Msk        (0x1U << EXTI_RTSR1_TR12_Pos)               /*!< 0x00001000 */
#define EXTI_RTSR1_TR12            EXTI_RTSR1_TR12_Msk                         /*!< Rising trigger event configuration bit of line 12 */
#define EXTI_RTSR1_TR13_Pos        (13U)
#define EXTI_RTSR1_TR13_Msk        (0x1U << EXTI_RTSR1_TR13_Pos)               /*!< 0x00002000 */
#define EXTI_RTSR1_TR13            EXTI_RTSR1_TR13_Msk                         /*!< Rising trigger event configuration bit of line 13 */
#define EXTI_RTSR1_TR14_Pos        (14U)
#define EXTI_RTSR1_TR14_Msk        (0x1U << EXTI_RTSR1_TR14_Pos)               /*!< 0x00004000 */
#define EXTI_RTSR1_TR14            EXTI_RTSR1_TR14_Msk                         /*!< Rising trigger event configuration bit of line 14 */
#define EXTI_RTSR1_TR15_Pos        (15U)
#define EXTI_RTSR1_TR15_Msk        (0x1U << EXTI_RTSR1_TR15_Pos)               /*!< 0x00008000 */
#define EXTI_RTSR1_TR15            EXTI_RTSR1_TR15_Msk                         /*!< Rising trigger event configuration bit of line 15 */
#define EXTI_RTSR1_TR16_Pos        (16U)
#define EXTI_RTSR1_TR16_Msk        (0x1U << EXTI_RTSR1_TR16_Pos)               /*!< 0x00010000 */
#define EXTI_RTSR1_TR16            EXTI_RTSR1_TR16_Msk                         /*!< Rising trigger event configuration bit of line 16 */
#define EXTI_RTSR1_TR17_Pos        (17U)
#define EXTI_RTSR1_TR17_Msk        (0x1U << EXTI_RTSR1_TR17_Pos)               /*!< 0x00020000 */
#define EXTI_RTSR1_TR17            EXTI_RTSR1_TR17_Msk                         /*!< Rising trigger event configuration bit of line 17 */
#define EXTI_RTSR1_TR18_Pos        (18U)
#define EXTI_RTSR1_TR18_Msk        (0x1U << EXTI_RTSR1_TR18_Pos)               /*!< 0x00040000 */
#define EXTI_RTSR1_TR18            EXTI_RTSR1_TR18_Msk                         /*!< Rising trigger event configuration bit of line 18 */
#define EXTI_RTSR1_TR19_Pos        (19U)
#define EXTI_RTSR1_TR19_Msk        (0x1U << EXTI_RTSR1_TR19_Pos)               /*!< 0x00080000 */
#define EXTI_RTSR1_TR19            EXTI_RTSR1_TR19_Msk                         /*!< Rising trigger event configuration bit of line 19 */
#define EXTI_RTSR1_TR20_Pos        (20U)
#define EXTI_RTSR1_TR20_Msk        (0x1U << EXTI_RTSR1_TR20_Pos)               /*!< 0x00100000 */
#define EXTI_RTSR1_TR20            EXTI_RTSR1_TR20_Msk                         /*!< Rising trigger event configuration bit of line 20 */
#define EXTI_RTSR1_TR21_Pos        (21U)
#define EXTI_RTSR1_TR21_Msk        (0x1U << EXTI_RTSR1_TR21_Pos)               /*!< 0x00200000 */
#define EXTI_RTSR1_TR21            EXTI_RTSR1_TR21_Msk                         /*!< Rising trigger event configuration bit of line 21 */
/******************  Bit definition for EXTI_RTSR2 register  *******************/
#define EXTI_RTSR2_TR49_Pos        (17U)
#define EXTI_RTSR2_TR49_Msk        (0x1U << EXTI_RTSR2_TR49_Pos)               /*!< 0x00020000 */
#define EXTI_RTSR2_TR49            EXTI_RTSR2_TR49_Msk                         /*!< Rising trigger event configuration bit of line 49 */
#define EXTI_RTSR2_TR51_Pos        (19U)
#define EXTI_RTSR2_TR51_Msk        (0x1U << EXTI_RTSR2_TR51_Pos)               /*!< 0x00080000 */
#define EXTI_RTSR2_TR51            EXTI_RTSR2_TR51_Msk                         /*!< Rising trigger event configuration bit of line 51 */
/******************  Bit definition for EXTI_RTSR3 register  *******************/
#define EXTI_RTSR3_TR85_Pos        (21U)
#define EXTI_RTSR3_TR85_Msk        (0x1U << EXTI_RTSR3_TR85_Pos)               /*!< 0x00200000 */
#define EXTI_RTSR3_TR85            EXTI_RTSR3_TR85_Msk                         /*!< Rising trigger event configuration bit of line 85 */
#define EXTI_RTSR3_TR86_Pos        (22U)
#define EXTI_RTSR3_TR86_Msk        (0x1U << EXTI_RTSR3_TR86_Pos)               /*!< 0x00400000 */
#define EXTI_RTSR3_TR86            EXTI_RTSR3_TR86_Msk                         /*!< Rising trigger event configuration bit of line 86 */

/******************  Bit definition for EXTI_FTSR1 register  *******************/
#define EXTI_FTSR1_TR0_Pos         (0U)
#define EXTI_FTSR1_TR0_Msk         (0x1U << EXTI_FTSR1_TR0_Pos)                /*!< 0x00000001 */
#define EXTI_FTSR1_TR0             EXTI_FTSR1_TR0_Msk                          /*!< Falling trigger event configuration bit of line 0 */
#define EXTI_FTSR1_TR1_Pos         (1U)
#define EXTI_FTSR1_TR1_Msk         (0x1U << EXTI_FTSR1_TR1_Pos)                /*!< 0x00000002 */
#define EXTI_FTSR1_TR1             EXTI_FTSR1_TR1_Msk                          /*!< Falling trigger event configuration bit of line 1 */
#define EXTI_FTSR1_TR2_Pos         (2U)
#define EXTI_FTSR1_TR2_Msk         (0x1U << EXTI_FTSR1_TR2_Pos)                /*!< 0x00000004 */
#define EXTI_FTSR1_TR2             EXTI_FTSR1_TR2_Msk                          /*!< Falling trigger event configuration bit of line 2 */
#define EXTI_FTSR1_TR3_Pos         (3U)
#define EXTI_FTSR1_TR3_Msk         (0x1U << EXTI_FTSR1_TR3_Pos)                /*!< 0x00000008 */
#define EXTI_FTSR1_TR3             EXTI_FTSR1_TR3_Msk                          /*!< Falling trigger event configuration bit of line 3 */
#define EXTI_FTSR1_TR4_Pos         (4U)
#define EXTI_FTSR1_TR4_Msk         (0x1U << EXTI_FTSR1_TR4_Pos)                /*!< 0x00000010 */
#define EXTI_FTSR1_TR4             EXTI_FTSR1_TR4_Msk                          /*!< Falling trigger event configuration bit of line 4 */
#define EXTI_FTSR1_TR5_Pos         (5U)
#define EXTI_FTSR1_TR5_Msk         (0x1U << EXTI_FTSR1_TR5_Pos)                /*!< 0x00000020 */
#define EXTI_FTSR1_TR5             EXTI_FTSR1_TR5_Msk                          /*!< Falling trigger event configuration bit of line 5 */
#define EXTI_FTSR1_TR6_Pos         (6U)
#define EXTI_FTSR1_TR6_Msk         (0x1U << EXTI_FTSR1_TR6_Pos)                /*!< 0x00000040 */
#define EXTI_FTSR1_TR6             EXTI_FTSR1_TR6_Msk                          /*!< Falling trigger event configuration bit of line 6 */
#define EXTI_FTSR1_TR7_Pos         (7U)
#define EXTI_FTSR1_TR7_Msk         (0x1U << EXTI_FTSR1_TR7_Pos)                /*!< 0x00000080 */
#define EXTI_FTSR1_TR7             EXTI_FTSR1_TR7_Msk                          /*!< Falling trigger event configuration bit of line 7 */
#define EXTI_FTSR1_TR8_Pos         (8U)
#define EXTI_FTSR1_TR8_Msk         (0x1U << EXTI_FTSR1_TR8_Pos)                /*!< 0x00000100 */
#define EXTI_FTSR1_TR8             EXTI_FTSR1_TR8_Msk                          /*!< Falling trigger event configuration bit of line 8 */
#define EXTI_FTSR1_TR9_Pos         (9U)
#define EXTI_FTSR1_TR9_Msk         (0x1U << EXTI_FTSR1_TR9_Pos)                /*!< 0x00000200 */
#define EXTI_FTSR1_TR9             EXTI_FTSR1_TR9_Msk                          /*!< Falling trigger event configuration bit of line 9 */
#define EXTI_FTSR1_TR10_Pos        (10U)
#define EXTI_FTSR1_TR10_Msk        (0x1U << EXTI_FTSR1_TR10_Pos)               /*!< 0x00000400 */
#define EXTI_FTSR1_TR10            EXTI_FTSR1_TR10_Msk                         /*!< Falling trigger event configuration bit of line 10 */
#define EXTI_FTSR1_TR11_Pos        (11U)
#define EXTI_FTSR1_TR11_Msk        (0x1U << EXTI_FTSR1_TR11_Pos)               /*!< 0x00000800 */
#define EXTI_FTSR1_TR11            EXTI_FTSR1_TR11_Msk                         /*!< Falling trigger event configuration bit of line 11 */
#define EXTI_FTSR1_TR12_Pos        (12U)
#define EXTI_FTSR1_TR12_Msk        (0x1U << EXTI_FTSR1_TR12_Pos)               /*!< 0x00001000 */
#define EXTI_FTSR1_TR12            EXTI_FTSR1_TR12_Msk                         /*!< Falling trigger event configuration bit of line 12 */
#define EXTI_FTSR1_TR13_Pos        (13U)
#define EXTI_FTSR1_TR13_Msk        (0x1U << EXTI_FTSR1_TR13_Pos)               /*!< 0x00002000 */
#define EXTI_FTSR1_TR13            EXTI_FTSR1_TR13_Msk                         /*!< Falling trigger event configuration bit of line 13 */
#define EXTI_FTSR1_TR14_Pos        (14U)
#define EXTI_FTSR1_TR14_Msk        (0x1U << EXTI_FTSR1_TR14_Pos)               /*!< 0x00004000 */
#define EXTI_FTSR1_TR14            EXTI_FTSR1_TR14_Msk                         /*!< Falling trigger event configuration bit of line 14 */
#define EXTI_FTSR1_TR15_Pos        (15U)
#define EXTI_FTSR1_TR15_Msk        (0x1U << EXTI_FTSR1_TR15_Pos)               /*!< 0x00008000 */
#define EXTI_FTSR1_TR15            EXTI_FTSR1_TR15_Msk                         /*!< Falling trigger event configuration bit of line 15 */
#define EXTI_FTSR1_TR16_Pos        (16U)
#define EXTI_FTSR1_TR16_Msk        (0x1U << EXTI_FTSR1_TR16_Pos)               /*!< 0x00010000 */
#define EXTI_FTSR1_TR16            EXTI_FTSR1_TR16_Msk                         /*!< Falling trigger event configuration bit of line 16 */
#define EXTI_FTSR1_TR17_Pos        (17U)
#define EXTI_FTSR1_TR17_Msk        (0x1U << EXTI_FTSR1_TR17_Pos)               /*!< 0x00020000 */
#define EXTI_FTSR1_TR17            EXTI_FTSR1_TR17_Msk                         /*!< Falling trigger event configuration bit of line 17 */
#define EXTI_FTSR1_TR18_Pos        (18U)
#define EXTI_FTSR1_TR18_Msk        (0x1U << EXTI_FTSR1_TR18_Pos)               /*!< 0x00040000 */
#define EXTI_FTSR1_TR18            EXTI_FTSR1_TR18_Msk                         /*!< Falling trigger event configuration bit of line 18 */
#define EXTI_FTSR1_TR19_Pos        (19U)
#define EXTI_FTSR1_TR19_Msk        (0x1U << EXTI_FTSR1_TR19_Pos)               /*!< 0x00080000 */
#define EXTI_FTSR1_TR19            EXTI_FTSR1_TR19_Msk                         /*!< Falling trigger event configuration bit of line 19 */
#define EXTI_FTSR1_TR20_Pos        (20U)
#define EXTI_FTSR1_TR20_Msk        (0x1U << EXTI_FTSR1_TR20_Pos)               /*!< 0x00100000 */
#define EXTI_FTSR1_TR20            EXTI_FTSR1_TR20_Msk                         /*!< Falling trigger event configuration bit of line 20 */
#define EXTI_FTSR1_TR21_Pos        (21U)
#define EXTI_FTSR1_TR21_Msk        (0x1U << EXTI_FTSR1_TR21_Pos)               /*!< 0x00200000 */
#define EXTI_FTSR1_TR21            EXTI_FTSR1_TR21_Msk                         /*!< Falling trigger event configuration bit of line 21 */
/******************  Bit definition for EXTI_FTSR2 register  *******************/
#define EXTI_FTSR2_TR49_Pos        (17U)
#define EXTI_FTSR2_TR49_Msk        (0x1U << EXTI_FTSR2_TR49_Pos)               /*!< 0x00020000 */
#define EXTI_FTSR2_TR49            EXTI_FTSR2_TR49_Msk                         /*!< Falling trigger event configuration bit of line 49 */
#define EXTI_FTSR2_TR51_Pos        (19U)
#define EXTI_FTSR2_TR51_Msk        (0x1U << EXTI_FTSR2_TR51_Pos)               /*!< 0x00080000 */
#define EXTI_FTSR2_TR51            EXTI_FTSR2_TR51_Msk                         /*!< Falling trigger event configuration bit of line 51 */

/******************  Bit definition for EXTI_FTSR3 register  *******************/
#define EXTI_FTSR3_TR85_Pos        (21U)
#define EXTI_FTSR3_TR85_Msk        (0x1U << EXTI_FTSR3_TR85_Pos)               /*!< 0x00200000 */
#define EXTI_FTSR3_TR85            EXTI_FTSR3_TR85_Msk                         /*!< Falling trigger event configuration bit of line 85 */
#define EXTI_FTSR3_TR86_Pos        (22U)
#define EXTI_FTSR3_TR86_Msk        (0x1U << EXTI_FTSR3_TR86_Pos)               /*!< 0x00400000 */
#define EXTI_FTSR3_TR86            EXTI_FTSR3_TR86_Msk                         /*!< Falling trigger event configuration bit of line 86 */
/******************  Bit definition for EXTI_SWIER1 register  ******************/
#define EXTI_SWIER1_SWIER0_Pos     (0U)
#define EXTI_SWIER1_SWIER0_Msk     (0x1U << EXTI_SWIER1_SWIER0_Pos)            /*!< 0x00000001 */
#define EXTI_SWIER1_SWIER0         EXTI_SWIER1_SWIER0_Msk                      /*!< Software Interrupt on line 0 */
#define EXTI_SWIER1_SWIER1_Pos     (1U)
#define EXTI_SWIER1_SWIER1_Msk     (0x1U << EXTI_SWIER1_SWIER1_Pos)            /*!< 0x00000002 */
#define EXTI_SWIER1_SWIER1         EXTI_SWIER1_SWIER1_Msk                      /*!< Software Interrupt on line 1 */
#define EXTI_SWIER1_SWIER2_Pos     (2U)
#define EXTI_SWIER1_SWIER2_Msk     (0x1U << EXTI_SWIER1_SWIER2_Pos)            /*!< 0x00000004 */
#define EXTI_SWIER1_SWIER2         EXTI_SWIER1_SWIER2_Msk                      /*!< Software Interrupt on line 2 */
#define EXTI_SWIER1_SWIER3_Pos     (3U)
#define EXTI_SWIER1_SWIER3_Msk     (0x1U << EXTI_SWIER1_SWIER3_Pos)            /*!< 0x00000008 */
#define EXTI_SWIER1_SWIER3         EXTI_SWIER1_SWIER3_Msk                      /*!< Software Interrupt on line 3 */
#define EXTI_SWIER1_SWIER4_Pos     (4U)
#define EXTI_SWIER1_SWIER4_Msk     (0x1U << EXTI_SWIER1_SWIER4_Pos)            /*!< 0x00000010 */
#define EXTI_SWIER1_SWIER4         EXTI_SWIER1_SWIER4_Msk                      /*!< Software Interrupt on line 4 */
#define EXTI_SWIER1_SWIER5_Pos     (5U)
#define EXTI_SWIER1_SWIER5_Msk     (0x1U << EXTI_SWIER1_SWIER5_Pos)            /*!< 0x00000020 */
#define EXTI_SWIER1_SWIER5         EXTI_SWIER1_SWIER5_Msk                      /*!< Software Interrupt on line 5 */
#define EXTI_SWIER1_SWIER6_Pos     (6U)
#define EXTI_SWIER1_SWIER6_Msk     (0x1U << EXTI_SWIER1_SWIER6_Pos)            /*!< 0x00000040 */
#define EXTI_SWIER1_SWIER6         EXTI_SWIER1_SWIER6_Msk                      /*!< Software Interrupt on line 6 */
#define EXTI_SWIER1_SWIER7_Pos     (7U)
#define EXTI_SWIER1_SWIER7_Msk     (0x1U << EXTI_SWIER1_SWIER7_Pos)            /*!< 0x00000080 */
#define EXTI_SWIER1_SWIER7         EXTI_SWIER1_SWIER7_Msk                      /*!< Software Interrupt on line 7 */
#define EXTI_SWIER1_SWIER8_Pos     (8U)
#define EXTI_SWIER1_SWIER8_Msk     (0x1U << EXTI_SWIER1_SWIER8_Pos)            /*!< 0x00000100 */
#define EXTI_SWIER1_SWIER8         EXTI_SWIER1_SWIER8_Msk                      /*!< Software Interrupt on line 8 */
#define EXTI_SWIER1_SWIER9_Pos     (9U)
#define EXTI_SWIER1_SWIER9_Msk     (0x1U << EXTI_SWIER1_SWIER9_Pos)            /*!< 0x00000200 */
#define EXTI_SWIER1_SWIER9         EXTI_SWIER1_SWIER9_Msk                      /*!< Software Interrupt on line 9 */
#define EXTI_SWIER1_SWIER10_Pos    (10U)
#define EXTI_SWIER1_SWIER10_Msk    (0x1U << EXTI_SWIER1_SWIER10_Pos)           /*!< 0x00000400 */
#define EXTI_SWIER1_SWIER10        EXTI_SWIER1_SWIER10_Msk                     /*!< Software Interrupt on line 10 */
#define EXTI_SWIER1_SWIER11_Pos    (11U)
#define EXTI_SWIER1_SWIER11_Msk    (0x1U << EXTI_SWIER1_SWIER11_Pos)           /*!< 0x00000800 */
#define EXTI_SWIER1_SWIER11        EXTI_SWIER1_SWIER11_Msk                     /*!< Software Interrupt on line 11 */
#define EXTI_SWIER1_SWIER12_Pos    (12U)
#define EXTI_SWIER1_SWIER12_Msk    (0x1U << EXTI_SWIER1_SWIER12_Pos)           /*!< 0x00001000 */
#define EXTI_SWIER1_SWIER12        EXTI_SWIER1_SWIER12_Msk                     /*!< Software Interrupt on line 12 */
#define EXTI_SWIER1_SWIER13_Pos    (13U)
#define EXTI_SWIER1_SWIER13_Msk    (0x1U << EXTI_SWIER1_SWIER13_Pos)           /*!< 0x00002000 */
#define EXTI_SWIER1_SWIER13        EXTI_SWIER1_SWIER13_Msk                     /*!< Software Interrupt on line 13 */
#define EXTI_SWIER1_SWIER14_Pos    (14U)
#define EXTI_SWIER1_SWIER14_Msk    (0x1U << EXTI_SWIER1_SWIER14_Pos)           /*!< 0x00004000 */
#define EXTI_SWIER1_SWIER14        EXTI_SWIER1_SWIER14_Msk                     /*!< Software Interrupt on line 14 */
#define EXTI_SWIER1_SWIER15_Pos    (15U)
#define EXTI_SWIER1_SWIER15_Msk    (0x1U << EXTI_SWIER1_SWIER15_Pos)           /*!< 0x00008000 */
#define EXTI_SWIER1_SWIER15        EXTI_SWIER1_SWIER15_Msk                     /*!< Software Interrupt on line 15 */
#define EXTI_SWIER1_SWIER16_Pos    (16U)
#define EXTI_SWIER1_SWIER16_Msk    (0x1U << EXTI_SWIER1_SWIER16_Pos)           /*!< 0x00010000 */
#define EXTI_SWIER1_SWIER16        EXTI_SWIER1_SWIER16_Msk                     /*!< Software Interrupt on line 16 */
#define EXTI_SWIER1_SWIER17_Pos    (17U)
#define EXTI_SWIER1_SWIER17_Msk    (0x1U << EXTI_SWIER1_SWIER17_Pos)           /*!< 0x00020000 */
#define EXTI_SWIER1_SWIER17        EXTI_SWIER1_SWIER17_Msk                     /*!< Software Interrupt on line 17 */
#define EXTI_SWIER1_SWIER18_Pos    (18U)
#define EXTI_SWIER1_SWIER18_Msk    (0x1U << EXTI_SWIER1_SWIER18_Pos)           /*!< 0x00040000 */
#define EXTI_SWIER1_SWIER18        EXTI_SWIER1_SWIER18_Msk                     /*!< Software Interrupt on line 18 */
#define EXTI_SWIER1_SWIER19_Pos    (19U)
#define EXTI_SWIER1_SWIER19_Msk    (0x1U << EXTI_SWIER1_SWIER19_Pos)           /*!< 0x00080000 */
#define EXTI_SWIER1_SWIER19        EXTI_SWIER1_SWIER19_Msk                     /*!< Software Interrupt on line 19 */
#define EXTI_SWIER1_SWIER20_Pos    (20U)
#define EXTI_SWIER1_SWIER20_Msk    (0x1U << EXTI_SWIER1_SWIER20_Pos)           /*!< 0x00100000 */
#define EXTI_SWIER1_SWIER20        EXTI_SWIER1_SWIER20_Msk                     /*!< Software Interrupt on line 20 */
#define EXTI_SWIER1_SWIER21_Pos    (21U)
#define EXTI_SWIER1_SWIER21_Msk    (0x1U << EXTI_SWIER1_SWIER21_Pos)           /*!< 0x00200000 */
#define EXTI_SWIER1_SWIER21        EXTI_SWIER1_SWIER21_Msk                     /*!< Software Interrupt on line 21 */

/******************  Bit definition for EXTI_SWIER2 register  ******************/
#define EXTI_SWIER2_SWIER49_Pos    (17U)
#define EXTI_SWIER2_SWIER49_Msk    (0x1U << EXTI_SWIER2_SWIER49_Pos)           /*!< 0x00020000 */
#define EXTI_SWIER2_SWIER49        EXTI_SWIER2_SWIER49_Msk                     /*!< Software Interrupt on line 49 */
#define EXTI_SWIER2_SWIER51_Pos    (19U)
#define EXTI_SWIER2_SWIER51_Msk    (0x1U << EXTI_SWIER2_SWIER51_Pos)           /*!< 0x00080000 */
#define EXTI_SWIER2_SWIER51        EXTI_SWIER2_SWIER51_Msk                     /*!< Software Interrupt on line 51 */

/******************  Bit definition for EXTI_SWIER3 register  ******************/
#define EXTI_SWIER3_SWIER85_Pos    (21U)
#define EXTI_SWIER3_SWIER85_Msk    (0x1U << EXTI_SWIER3_SWIER85_Pos)           /*!< 0x00200000 */
#define EXTI_SWIER3_SWIER85        EXTI_SWIER3_SWIER85_Msk                     /*!< Software Interrupt on line 85 */
#define EXTI_SWIER3_SWIER86_Pos    (22U)
#define EXTI_SWIER3_SWIER86_Msk    (0x1U << EXTI_SWIER3_SWIER86_Pos)           /*!< 0x00400000 */
#define EXTI_SWIER3_SWIER86        EXTI_SWIER3_SWIER86_Msk                     /*!< Software Interrupt on line 86 */

/*******************  Bit definition for EXTI_PR1 register  ********************/
#define EXTI_PR1_PR0_Pos           (0U)
#define EXTI_PR1_PR0_Msk           (0x1U << EXTI_PR1_PR0_Pos)                  /*!< 0x00000001 */
#define EXTI_PR1_PR0               EXTI_PR1_PR0_Msk                            /*!< Pending bit for line 0 */
#define EXTI_PR1_PR1_Pos           (1U)
#define EXTI_PR1_PR1_Msk           (0x1U << EXTI_PR1_PR1_Pos)                  /*!< 0x00000002 */
#define EXTI_PR1_PR1               EXTI_PR1_PR1_Msk                            /*!< Pending bit for line 1 */
#define EXTI_PR1_PR2_Pos           (2U)
#define EXTI_PR1_PR2_Msk           (0x1U << EXTI_PR1_PR2_Pos)                  /*!< 0x00000004 */
#define EXTI_PR1_PR2               EXTI_PR1_PR2_Msk                            /*!< Pending bit for line 2 */
#define EXTI_PR1_PR3_Pos           (3U)
#define EXTI_PR1_PR3_Msk           (0x1U << EXTI_PR1_PR3_Pos)                  /*!< 0x00000008 */
#define EXTI_PR1_PR3               EXTI_PR1_PR3_Msk                            /*!< Pending bit for line 3 */
#define EXTI_PR1_PR4_Pos           (4U)
#define EXTI_PR1_PR4_Msk           (0x1U << EXTI_PR1_PR4_Pos)                  /*!< 0x00000010 */
#define EXTI_PR1_PR4               EXTI_PR1_PR4_Msk                            /*!< Pending bit for line 4 */
#define EXTI_PR1_PR5_Pos           (5U)
#define EXTI_PR1_PR5_Msk           (0x1U << EXTI_PR1_PR5_Pos)                  /*!< 0x00000020 */
#define EXTI_PR1_PR5               EXTI_PR1_PR5_Msk                            /*!< Pending bit for line 5 */
#define EXTI_PR1_PR6_Pos           (6U)
#define EXTI_PR1_PR6_Msk           (0x1U << EXTI_PR1_PR6_Pos)                  /*!< 0x00000040 */
#define EXTI_PR1_PR6               EXTI_PR1_PR6_Msk                            /*!< Pending bit for line 6 */
#define EXTI_PR1_PR7_Pos           (7U)
#define EXTI_PR1_PR7_Msk           (0x1U << EXTI_PR1_PR7_Pos)                  /*!< 0x00000080 */
#define EXTI_PR1_PR7               EXTI_PR1_PR7_Msk                            /*!< Pending bit for line 7 */
#define EXTI_PR1_PR8_Pos           (8U)
#define EXTI_PR1_PR8_Msk           (0x1U << EXTI_PR1_PR8_Pos)                  /*!< 0x00000100 */
#define EXTI_PR1_PR8               EXTI_PR1_PR8_Msk                            /*!< Pending bit for line 8 */
#define EXTI_PR1_PR9_Pos           (9U)
#define EXTI_PR1_PR9_Msk           (0x1U << EXTI_PR1_PR9_Pos)                  /*!< 0x00000200 */
#define EXTI_PR1_PR9               EXTI_PR1_PR9_Msk                            /*!< Pending bit for line 9 */
#define EXTI_PR1_PR10_Pos          (10U)
#define EXTI_PR1_PR10_Msk          (0x1U << EXTI_PR1_PR10_Pos)                 /*!< 0x00000400 */
#define EXTI_PR1_PR10              EXTI_PR1_PR10_Msk                           /*!< Pending bit for line 10 */
#define EXTI_PR1_PR11_Pos          (11U)
#define EXTI_PR1_PR11_Msk          (0x1U << EXTI_PR1_PR11_Pos)                 /*!< 0x00000800 */
#define EXTI_PR1_PR11              EXTI_PR1_PR11_Msk                           /*!< Pending bit for line 11 */
#define EXTI_PR1_PR12_Pos          (12U)
#define EXTI_PR1_PR12_Msk          (0x1U << EXTI_PR1_PR12_Pos)                 /*!< 0x00001000 */
#define EXTI_PR1_PR12              EXTI_PR1_PR12_Msk                           /*!< Pending bit for line 12 */
#define EXTI_PR1_PR13_Pos          (13U)
#define EXTI_PR1_PR13_Msk          (0x1U << EXTI_PR1_PR13_Pos)                 /*!< 0x00002000 */
#define EXTI_PR1_PR13              EXTI_PR1_PR13_Msk                           /*!< Pending bit for line 13 */
#define EXTI_PR1_PR14_Pos          (14U)
#define EXTI_PR1_PR14_Msk          (0x1U << EXTI_PR1_PR14_Pos)                 /*!< 0x00004000 */
#define EXTI_PR1_PR14              EXTI_PR1_PR14_Msk                           /*!< Pending bit for line 14 */
#define EXTI_PR1_PR15_Pos          (15U)
#define EXTI_PR1_PR15_Msk          (0x1U << EXTI_PR1_PR15_Pos)                 /*!< 0x00008000 */
#define EXTI_PR1_PR15              EXTI_PR1_PR15_Msk                           /*!< Pending bit for line 15 */
#define EXTI_PR1_PR16_Pos          (16U)
#define EXTI_PR1_PR16_Msk          (0x1U << EXTI_PR1_PR16_Pos)                 /*!< 0x00010000 */
#define EXTI_PR1_PR16              EXTI_PR1_PR16_Msk                           /*!< Pending bit for line 16 */

/*******************  Bit definition for EXTI_PR3 register  ********************/
#define EXTI_PR3_PR65_Pos          (1U)
#define EXTI_PR3_PR65_Msk          (0x1U << EXTI_PR3_PR65_Pos)                 /*!< 0x00000002 */
#define EXTI_PR3_PR65              EXTI_PR3_PR65_Msk                           /*!< Pending bit for line 65 */
#define EXTI_PR3_PR66_Pos          (2U)
#define EXTI_PR3_PR66_Msk          (0x1U << EXTI_PR3_PR66_Pos)                 /*!< 0x00000004 */
#define EXTI_PR3_PR66              EXTI_PR3_PR66_Msk                           /*!< Pending bit for line 66 */
#define EXTI_PR3_PR68_Pos          (4U)
#define EXTI_PR3_PR68_Msk          (0x1U << EXTI_PR3_PR68_Pos)                 /*!< 0x00000010 */
#define EXTI_PR3_PR68              EXTI_PR3_PR68_Msk                           /*!< Pending bit for line 68 */
#define EXTI_PR3_PR73_Pos          (9U)
#define EXTI_PR3_PR73_Msk          (0x1U << EXTI_PR3_PR73_Pos)                 /*!< 0x00000200 */
#define EXTI_PR3_PR73              EXTI_PR3_PR73_Msk                           /*!< Pending bit for line 73 */
#define EXTI_PR3_PR74_Pos          (10U)
#define EXTI_PR3_PR74_Msk          (0x1U << EXTI_PR3_PR74_Pos)                 /*!< 0x00000400 */
#define EXTI_PR3_PR74              EXTI_PR3_PR74_Msk                           /*!< Pending bit for line 74 */

/*****************  Bit definition for EXTI_EXTICR1 register  ***************/
#define EXTI_EXTICR1_EXTI0_Pos        (0U)
#define EXTI_EXTICR1_EXTI0_Msk        (0xFFU << EXTI_EXTICR1_EXTI0_Pos)        /*!< 0x000000FF */
#define EXTI_EXTICR1_EXTI0            EXTI_EXTICR1_EXTI0_Msk                   /*!<EXTI 0 configuration */
#define EXTI_EXTICR1_EXTI1_Pos        (8U)
#define EXTI_EXTICR1_EXTI1_Msk        (0xFFU << EXTI_EXTICR1_EXTI1_Pos)        /*!< 0x0000FF00 */
#define EXTI_EXTICR1_EXTI1            EXTI_EXTICR1_EXTI1_Msk                   /*!<EXTI 1 configuration */
#define EXTI_EXTICR1_EXTI2_Pos        (16U)
#define EXTI_EXTICR1_EXTI2_Msk        (0xFFU << EXTI_EXTICR1_EXTI2_Pos)        /*!< 0x00FF0000 */
#define EXTI_EXTICR1_EXTI2            EXTI_EXTICR1_EXTI2_Msk                   /*!<EXTI 2 configuration */
#define EXTI_EXTICR1_EXTI3_Pos        (24U)
#define EXTI_EXTICR1_EXTI3_Msk        (0xFFU << EXTI_EXTICR1_EXTI3_Pos)        /*!< 0xFF000000 */
#define EXTI_EXTICR1_EXTI3            EXTI_EXTICR1_EXTI3_Msk                   /*!<EXTI 3 configuration */
/**
  * @brief   EXTI0 configuration
  */
#define EXTI_EXTICR1_EXTI0_PA         ((uint32_t)0x00000000)                   /*!<PA[0] pin */
#define EXTI_EXTICR1_EXTI0_PB_Pos     (0U)
#define EXTI_EXTICR1_EXTI0_PB_Msk     (0x1U << EXTI_EXTICR1_EXTI0_PB_Pos)      /*!< 0x00000001 */
#define EXTI_EXTICR1_EXTI0_PB         EXTI_EXTICR1_EXTI0_PB_Msk                /*!<PB[0] pin */
#define EXTI_EXTICR1_EXTI0_PC_Pos     (1U)
#define EXTI_EXTICR1_EXTI0_PC_Msk     (0x1U << EXTI_EXTICR1_EXTI0_PC_Pos)      /*!< 0x00000002 */
#define EXTI_EXTICR1_EXTI0_PC         EXTI_EXTICR1_EXTI0_PC_Msk                /*!<PC[0] pin */
#define EXTI_EXTICR1_EXTI0_PD_Pos     (0U)
#define EXTI_EXTICR1_EXTI0_PD_Msk     (0x3U << EXTI_EXTICR1_EXTI0_PD_Pos)      /*!< 0x00000003 */
#define EXTI_EXTICR1_EXTI0_PD         EXTI_EXTICR1_EXTI0_PD_Msk                /*!<PD[0] pin */
#define EXTI_EXTICR1_EXTI0_PE_Pos     (2U)
#define EXTI_EXTICR1_EXTI0_PE_Msk     (0x1U << EXTI_EXTICR1_EXTI0_PE_Pos)      /*!< 0x00000004 */
#define EXTI_EXTICR1_EXTI0_PE         EXTI_EXTICR1_EXTI0_PE_Msk                /*!<PE[0] pin */
#define EXTI_EXTICR1_EXTI0_PF_Pos     (0U)
#define EXTI_EXTICR1_EXTI0_PF_Msk     (0x5U << EXTI_EXTICR1_EXTI0_PF_Pos)      /*!< 0x00000005 */
#define EXTI_EXTICR1_EXTI0_PF         EXTI_EXTICR1_EXTI0_PF_Msk                /*!<PF[0] pin */
#define EXTI_EXTICR1_EXTI0_PG_Pos     (1U)
#define EXTI_EXTICR1_EXTI0_PG_Msk     (0x3U << EXTI_EXTICR1_EXTI0_PG_Pos)      /*!< 0x00000006 */
#define EXTI_EXTICR1_EXTI0_PG         EXTI_EXTICR1_EXTI0_PG_Msk                /*!<PG[0] pin */
#define EXTI_EXTICR1_EXTI0_PH_Pos     (0U)
#define EXTI_EXTICR1_EXTI0_PH_Msk     (0x7U << EXTI_EXTICR1_EXTI0_PH_Pos)      /*!< 0x00000007 */
#define EXTI_EXTICR1_EXTI0_PH         EXTI_EXTICR1_EXTI0_PH_Msk                /*!<PH[0] pin */
#define EXTI_EXTICR1_EXTI0_PI_Pos     (3U)
#define EXTI_EXTICR1_EXTI0_PI_Msk     (0x1U << EXTI_EXTICR1_EXTI0_PI_Pos)      /*!< 0x00000008 */
#define EXTI_EXTICR1_EXTI0_PI         EXTI_EXTICR1_EXTI0_PI_Msk                /*!<PI[0] pin */
#define EXTI_EXTICR1_EXTI0_PJ_Pos     (0U)
#define EXTI_EXTICR1_EXTI0_PJ_Msk     (0x9U << EXTI_EXTICR1_EXTI0_PJ_Pos)      /*!< 0x00000009 */
#define EXTI_EXTICR1_EXTI0_PJ         EXTI_EXTICR1_EXTI0_PJ_Msk                /*!<PJ[0] pin */
#define EXTI_EXTICR1_EXTI0_PK_Pos     (1U)
#define EXTI_EXTICR1_EXTI0_PK_Msk     (0x5U << EXTI_EXTICR1_EXTI0_PK_Pos)      /*!< 0x0000000A */
#define EXTI_EXTICR1_EXTI0_PK         EXTI_EXTICR1_EXTI0_PK_Msk                /*!<PK[0] pin */
#define EXTI_EXTICR1_EXTI0_PZ_Pos     (0U)
#define EXTI_EXTICR1_EXTI0_PZ_Msk     (0x19U << EXTI_EXTICR1_EXTI0_PZ_Pos)     /*!< 0x00000019 */
#define EXTI_EXTICR1_EXTI0_PZ         EXTI_EXTICR1_EXTI0_PZ_Msk                /*!<PZ[0] pin */



/**
  * @brief   EXTI1 configuration
  */
#define EXTI_EXTICR1_EXTI1_PA         ((uint32_t)0x00000000)                   /*!<PA[1] pin */
#define EXTI_EXTICR1_EXTI1_PB_Pos     (8U)
#define EXTI_EXTICR1_EXTI1_PB_Msk     (0x1U << EXTI_EXTICR1_EXTI1_PB_Pos)      /*!< 0x00000100 */
#define EXTI_EXTICR1_EXTI1_PB         EXTI_EXTICR1_EXTI1_PB_Msk                /*!<PB[1] pin */
#define EXTI_EXTICR1_EXTI1_PC_Pos     (9U)
#define EXTI_EXTICR1_EXTI1_PC_Msk     (0x1U << EXTI_EXTICR1_EXTI1_PC_Pos)      /*!< 0x00000200 */
#define EXTI_EXTICR1_EXTI1_PC         EXTI_EXTICR1_EXTI1_PC_Msk                /*!<PC[1] pin */
#define EXTI_EXTICR1_EXTI1_PD_Pos     (8U)
#define EXTI_EXTICR1_EXTI1_PD_Msk     (0x3U << EXTI_EXTICR1_EXTI1_PD_Pos)      /*!< 0x00000300 */
#define EXTI_EXTICR1_EXTI1_PD         EXTI_EXTICR1_EXTI1_PD_Msk                /*!<PD[1] pin */
#define EXTI_EXTICR1_EXTI1_PE_Pos     (10U)
#define EXTI_EXTICR1_EXTI1_PE_Msk     (0x1U << EXTI_EXTICR1_EXTI1_PE_Pos)      /*!< 0x00000400 */
#define EXTI_EXTICR1_EXTI1_PE         EXTI_EXTICR1_EXTI1_PE_Msk                /*!<PE[1] pin */
#define EXTI_EXTICR1_EXTI1_PF_Pos     (8U)
#define EXTI_EXTICR1_EXTI1_PF_Msk     (0x5U << EXTI_EXTICR1_EXTI1_PF_Pos)      /*!< 0x00000500 */
#define EXTI_EXTICR1_EXTI1_PF         EXTI_EXTICR1_EXTI1_PF_Msk                /*!<PF[1] pin */
#define EXTI_EXTICR1_EXTI1_PG_Pos     (9U)
#define EXTI_EXTICR1_EXTI1_PG_Msk     (0x3U << EXTI_EXTICR1_EXTI1_PG_Pos)      /*!< 0x00000600 */
#define EXTI_EXTICR1_EXTI1_PG         EXTI_EXTICR1_EXTI1_PG_Msk                /*!<PG[1] pin */
#define EXTI_EXTICR1_EXTI1_PH_Pos     (8U)
#define EXTI_EXTICR1_EXTI1_PH_Msk     (0x7U << EXTI_EXTICR1_EXTI1_PH_Pos)      /*!< 0x00000700 */
#define EXTI_EXTICR1_EXTI1_PH         EXTI_EXTICR1_EXTI1_PH_Msk                /*!<PH[1] pin */
#define EXTI_EXTICR1_EXTI1_PI_Pos     (11U)
#define EXTI_EXTICR1_EXTI1_PI_Msk     (0x1U << EXTI_EXTICR1_EXTI1_PI_Pos)      /*!< 0x00000800 */
#define EXTI_EXTICR1_EXTI1_PI         EXTI_EXTICR1_EXTI1_PI_Msk                /*!<PI[1] pin */
#define EXTI_EXTICR1_EXTI1_PJ_Pos     (8U)
#define EXTI_EXTICR1_EXTI1_PJ_Msk     (0x9U << EXTI_EXTICR1_EXTI1_PJ_Pos)      /*!< 0x00000900 */
#define EXTI_EXTICR1_EXTI1_PJ         EXTI_EXTICR1_EXTI1_PJ_Msk                /*!<PJ[1] pin */
#define EXTI_EXTICR1_EXTI1_PK_Pos     (9U)
#define EXTI_EXTICR1_EXTI1_PK_Msk     (0x5U << EXTI_EXTICR1_EXTI1_PK_Pos)      /*!< 0x00000A00 */
#define EXTI_EXTICR1_EXTI1_PK         EXTI_EXTICR1_EXTI1_PK_Msk                /*!<PK[1] pin */
#define EXTI_EXTICR1_EXTI1_PZ_Pos     (8U)
#define EXTI_EXTICR1_EXTI1_PZ_Msk     (0x19U << EXTI_EXTICR1_EXTI1_PZ_Pos)     /*!< 0x00001900 */
#define EXTI_EXTICR1_EXTI1_PZ         EXTI_EXTICR1_EXTI1_PZ_Msk                /*!<PZ[1] pin */

/**
  * @brief   EXTI2 configuration
  */
#define EXTI_EXTICR1_EXTI2_PA         ((uint32_t)0x00000000)                   /*!<PA[2] pin */
#define EXTI_EXTICR1_EXTI2_PB_Pos     (16U)
#define EXTI_EXTICR1_EXTI2_PB_Msk     (0x1U << EXTI_EXTICR1_EXTI2_PB_Pos)      /*!< 0x00010000 */
#define EXTI_EXTICR1_EXTI2_PB         EXTI_EXTICR1_EXTI2_PB_Msk                /*!<PB[2] pin */
#define EXTI_EXTICR1_EXTI2_PC_Pos     (17U)
#define EXTI_EXTICR1_EXTI2_PC_Msk     (0x1U << EXTI_EXTICR1_EXTI2_PC_Pos)      /*!< 0x00020000 */
#define EXTI_EXTICR1_EXTI2_PC         EXTI_EXTICR1_EXTI2_PC_Msk                /*!<PC[2] pin */
#define EXTI_EXTICR1_EXTI2_PD_Pos     (16U)
#define EXTI_EXTICR1_EXTI2_PD_Msk     (0x3U << EXTI_EXTICR1_EXTI2_PD_Pos)      /*!< 0x00030000 */
#define EXTI_EXTICR1_EXTI2_PD         EXTI_EXTICR1_EXTI2_PD_Msk                /*!<PD[2] pin */
#define EXTI_EXTICR1_EXTI2_PE_Pos     (18U)
#define EXTI_EXTICR1_EXTI2_PE_Msk     (0x1U << EXTI_EXTICR1_EXTI2_PE_Pos)      /*!< 0x00040000 */
#define EXTI_EXTICR1_EXTI2_PE         EXTI_EXTICR1_EXTI2_PE_Msk                /*!<PE[2] pin */
#define EXTI_EXTICR1_EXTI2_PF_Pos     (16U)
#define EXTI_EXTICR1_EXTI2_PF_Msk     (0x5U << EXTI_EXTICR1_EXTI2_PF_Pos)      /*!< 0x00050000 */
#define EXTI_EXTICR1_EXTI2_PF         EXTI_EXTICR1_EXTI2_PF_Msk                /*!<PF[2] pin */
#define EXTI_EXTICR1_EXTI2_PG_Pos     (17U)
#define EXTI_EXTICR1_EXTI2_PG_Msk     (0x3U << EXTI_EXTICR1_EXTI2_PG_Pos)      /*!< 0x00060000 */
#define EXTI_EXTICR1_EXTI2_PG         EXTI_EXTICR1_EXTI2_PG_Msk                /*!<PG[2] pin */
#define EXTI_EXTICR1_EXTI2_PH_Pos     (16U)
#define EXTI_EXTICR1_EXTI2_PH_Msk     (0x7U << EXTI_EXTICR1_EXTI2_PH_Pos)      /*!< 0x00070000 */
#define EXTI_EXTICR1_EXTI2_PH         EXTI_EXTICR1_EXTI2_PH_Msk                /*!<PH[2] pin */
#define EXTI_EXTICR1_EXTI2_PI_Pos     (19U)
#define EXTI_EXTICR1_EXTI2_PI_Msk     (0x1U << EXTI_EXTICR1_EXTI2_PI_Pos)      /*!< 0x00080000 */
#define EXTI_EXTICR1_EXTI2_PI         EXTI_EXTICR1_EXTI2_PI_Msk                /*!<PI[2] pin */
#define EXTI_EXTICR1_EXTI2_PJ_Pos     (16U)
#define EXTI_EXTICR1_EXTI2_PJ_Msk     (0x9U << EXTI_EXTICR1_EXTI2_PJ_Pos)      /*!< 0x00090000 */
#define EXTI_EXTICR1_EXTI2_PJ         EXTI_EXTICR1_EXTI2_PJ_Msk                /*!<PJ[2] pin */
#define EXTI_EXTICR1_EXTI2_PK_Pos     (17U)
#define EXTI_EXTICR1_EXTI2_PK_Msk     (0x5U << EXTI_EXTICR1_EXTI2_PK_Pos)      /*!< 0x000A0000 */
#define EXTI_EXTICR1_EXTI2_PK         EXTI_EXTICR1_EXTI2_PK_Msk                /*!<PK[2] pin */
#define EXTI_EXTICR1_EXTI2_PZ_Pos     (16U)
#define EXTI_EXTICR1_EXTI2_PZ_Msk     (0x19U << EXTI_EXTICR1_EXTI2_PZ_Pos)     /*!< 0x00190000 */
#define EXTI_EXTICR1_EXTI2_PZ         EXTI_EXTICR1_EXTI2_PZ_Msk                /*!<PZ[2] pin */

/**
  * @brief   EXTI3 configuration
  */
#define EXTI_EXTICR1_EXTI3_PA         ((uint32_t)0x00000000)                   /*!<PA[3] pin */
#define EXTI_EXTICR1_EXTI3_PB_Pos     (24U)
#define EXTI_EXTICR1_EXTI3_PB_Msk     (0x1U << EXTI_EXTICR1_EXTI3_PB_Pos)      /*!< 0x01000000 */
#define EXTI_EXTICR1_EXTI3_PB         EXTI_EXTICR1_EXTI3_PB_Msk                /*!<PB[3] pin */
#define EXTI_EXTICR1_EXTI3_PC_Pos     (25U)
#define EXTI_EXTICR1_EXTI3_PC_Msk     (0x1U << EXTI_EXTICR1_EXTI3_PC_Pos)      /*!< 0x02000000 */
#define EXTI_EXTICR1_EXTI3_PC         EXTI_EXTICR1_EXTI3_PC_Msk                /*!<PC[3] pin */
#define EXTI_EXTICR1_EXTI3_PD_Pos     (24U)
#define EXTI_EXTICR1_EXTI3_PD_Msk     (0x3U << EXTI_EXTICR1_EXTI3_PD_Pos)      /*!< 0x03000000 */
#define EXTI_EXTICR1_EXTI3_PD         EXTI_EXTICR1_EXTI3_PD_Msk                /*!<PD[3] pin */
#define EXTI_EXTICR1_EXTI3_PE_Pos     (26U)
#define EXTI_EXTICR1_EXTI3_PE_Msk     (0x1U << EXTI_EXTICR1_EXTI3_PE_Pos)      /*!< 0x04000000 */
#define EXTI_EXTICR1_EXTI3_PE         EXTI_EXTICR1_EXTI3_PE_Msk                /*!<PE[3] pin */
#define EXTI_EXTICR1_EXTI3_PF_Pos     (24U)
#define EXTI_EXTICR1_EXTI3_PF_Msk     (0x5U << EXTI_EXTICR1_EXTI3_PF_Pos)      /*!< 0x05000000 */
#define EXTI_EXTICR1_EXTI3_PF         EXTI_EXTICR1_EXTI3_PF_Msk                /*!<PF[3] pin */
#define EXTI_EXTICR1_EXTI3_PG_Pos     (25U)
#define EXTI_EXTICR1_EXTI3_PG_Msk     (0x3U << EXTI_EXTICR1_EXTI3_PG_Pos)      /*!< 0x06000000 */
#define EXTI_EXTICR1_EXTI3_PG         EXTI_EXTICR1_EXTI3_PG_Msk                /*!<PG[3] pin */
#define EXTI_EXTICR1_EXTI3_PH_Pos     (24U)
#define EXTI_EXTICR1_EXTI3_PH_Msk     (0x7U << EXTI_EXTICR1_EXTI3_PH_Pos)      /*!< 0x07000000 */
#define EXTI_EXTICR1_EXTI3_PH         EXTI_EXTICR1_EXTI3_PH_Msk                /*!<PH[3] pin */
#define EXTI_EXTICR1_EXTI3_PI_Pos     (27U)
#define EXTI_EXTICR1_EXTI3_PI_Msk     (0x1U << EXTI_EXTICR1_EXTI3_PI_Pos)      /*!< 0x08000000 */
#define EXTI_EXTICR1_EXTI3_PI         EXTI_EXTICR1_EXTI3_PI_Msk                /*!<PI[3] pin */
#define EXTI_EXTICR1_EXTI3_PJ_Pos     (24U)
#define EXTI_EXTICR1_EXTI3_PJ_Msk     (0x9U << EXTI_EXTICR1_EXTI3_PJ_Pos)      /*!< 0x09000000 */
#define EXTI_EXTICR1_EXTI3_PJ         EXTI_EXTICR1_EXTI3_PJ_Msk                /*!<PJ[3] pin */
#define EXTI_EXTICR1_EXTI3_PK_Pos     (25U)
#define EXTI_EXTICR1_EXTI3_PK_Msk     (0x5U << EXTI_EXTICR1_EXTI3_PK_Pos)      /*!< 0x0A000000 */
#define EXTI_EXTICR1_EXTI3_PK         EXTI_EXTICR1_EXTI3_PK_Msk                /*!<PK[3] pin */
#define EXTI_EXTICR1_EXTI3_PZ_Pos     (24U)
#define EXTI_EXTICR1_EXTI3_PZ_Msk     (0x19U << EXTI_EXTICR1_EXTI3_PZ_Pos)     /*!< 0x19000000 */
#define EXTI_EXTICR1_EXTI3_PZ         EXTI_EXTICR1_EXTI3_PZ_Msk                /*!<PZ[3] pin */


/*****************  Bit definition for EXTI_EXTICR2 register  ***************/
#define EXTI_EXTICR2_EXTI4_Pos        (0U)
#define EXTI_EXTICR2_EXTI4_Msk        (0xFFU << EXTI_EXTICR2_EXTI4_Pos)        /*!< 0x000000FF */
#define EXTI_EXTICR2_EXTI4            EXTI_EXTICR2_EXTI4_Msk                   /*!<EXTI 4 configuration */
#define EXTI_EXTICR2_EXTI5_Pos        (8U)
#define EXTI_EXTICR2_EXTI5_Msk        (0xFFU << EXTI_EXTICR2_EXTI5_Pos)        /*!< 0x0000FF00 */
#define EXTI_EXTICR2_EXTI5            EXTI_EXTICR2_EXTI5_Msk                   /*!<EXTI 5 configuration */
#define EXTI_EXTICR2_EXTI6_Pos        (16U)
#define EXTI_EXTICR2_EXTI6_Msk        (0xFFU << EXTI_EXTICR2_EXTI6_Pos)        /*!< 0x00FF0000 */
#define EXTI_EXTICR2_EXTI6            EXTI_EXTICR2_EXTI6_Msk                   /*!<EXTI 6 configuration */
#define EXTI_EXTICR2_EXTI7_Pos        (24U)
#define EXTI_EXTICR2_EXTI7_Msk        (0xFFU << EXTI_EXTICR2_EXTI7_Pos)        /*!< 0xFF000000 */
#define EXTI_EXTICR2_EXTI7            EXTI_EXTICR2_EXTI7_Msk                   /*!<EXTI 7 configuration */

/**
  * @brief   EXTI4 configuration
  */
#define EXTI_EXTICR2_EXTI4_PA         ((uint32_t)0x00000000)                   /*!<PA[4] pin */
#define EXTI_EXTICR2_EXTI4_PB_Pos     (0U)
#define EXTI_EXTICR2_EXTI4_PB_Msk     (0x1U << EXTI_EXTICR2_EXTI4_PB_Pos)      /*!< 0x00000001 */
#define EXTI_EXTICR2_EXTI4_PB         EXTI_EXTICR2_EXTI4_PB_Msk                /*!<PB[4] pin */
#define EXTI_EXTICR2_EXTI4_PC_Pos     (1U)
#define EXTI_EXTICR2_EXTI4_PC_Msk     (0x1U << EXTI_EXTICR2_EXTI4_PC_Pos)      /*!< 0x00000002 */
#define EXTI_EXTICR2_EXTI4_PC         EXTI_EXTICR2_EXTI4_PC_Msk                /*!<PC[4] pin */
#define EXTI_EXTICR2_EXTI4_PD_Pos     (0U)
#define EXTI_EXTICR2_EXTI4_PD_Msk     (0x3U << EXTI_EXTICR2_EXTI4_PD_Pos)      /*!< 0x00000003 */
#define EXTI_EXTICR2_EXTI4_PD         EXTI_EXTICR2_EXTI4_PD_Msk                /*!<PD[4] pin */
#define EXTI_EXTICR2_EXTI4_PE_Pos     (2U)
#define EXTI_EXTICR2_EXTI4_PE_Msk     (0x1U << EXTI_EXTICR2_EXTI4_PE_Pos)      /*!< 0x00000004 */
#define EXTI_EXTICR2_EXTI4_PE         EXTI_EXTICR2_EXTI4_PE_Msk                /*!<PE[4] pin */
#define EXTI_EXTICR2_EXTI4_PF_Pos     (0U)
#define EXTI_EXTICR2_EXTI4_PF_Msk     (0x5U << EXTI_EXTICR2_EXTI4_PF_Pos)      /*!< 0x00000005 */
#define EXTI_EXTICR2_EXTI4_PF         EXTI_EXTICR2_EXTI4_PF_Msk                /*!<PF[4] pin */
#define EXTI_EXTICR2_EXTI4_PG_Pos     (1U)
#define EXTI_EXTICR2_EXTI4_PG_Msk     (0x3U << EXTI_EXTICR2_EXTI4_PG_Pos)      /*!< 0x00000006 */
#define EXTI_EXTICR2_EXTI4_PG         EXTI_EXTICR2_EXTI4_PG_Msk                /*!<PG[4] pin */
#define EXTI_EXTICR2_EXTI4_PH_Pos     (0U)
#define EXTI_EXTICR2_EXTI4_PH_Msk     (0x7U << EXTI_EXTICR2_EXTI4_PH_Pos)      /*!< 0x00000007 */
#define EXTI_EXTICR2_EXTI4_PH         EXTI_EXTICR2_EXTI4_PH_Msk                /*!<PH[4] pin */
#define EXTI_EXTICR2_EXTI4_PI_Pos     (3U)
#define EXTI_EXTICR2_EXTI4_PI_Msk     (0x1U << EXTI_EXTICR2_EXTI4_PI_Pos)      /*!< 0x00000008 */
#define EXTI_EXTICR2_EXTI4_PI         EXTI_EXTICR2_EXTI4_PI_Msk                /*!<PI[4] pin */
#define EXTI_EXTICR2_EXTI4_PJ_Pos     (0U)
#define EXTI_EXTICR2_EXTI4_PJ_Msk     (0x9U << EXTI_EXTICR2_EXTI4_PJ_Pos)      /*!< 0x00000009 */
#define EXTI_EXTICR2_EXTI4_PJ         EXTI_EXTICR2_EXTI4_PJ_Msk                /*!<PJ[4] pin */
#define EXTI_EXTICR2_EXTI4_PK_Pos     (1U)
#define EXTI_EXTICR2_EXTI4_PK_Msk     (0x5U << EXTI_EXTICR2_EXTI4_PK_Pos)      /*!< 0x0000000A */
#define EXTI_EXTICR2_EXTI4_PK         EXTI_EXTICR2_EXTI4_PK_Msk                /*!<PK[4] pin */
#define EXTI_EXTICR2_EXTI4_PZ_Pos     (0U)
#define EXTI_EXTICR2_EXTI4_PZ_Msk     (0x19U << EXTI_EXTICR2_EXTI4_PZ_Pos)     /*!< 0x00000019 */
#define EXTI_EXTICR2_EXTI4_PZ         EXTI_EXTICR2_EXTI4_PZ_Msk                /*!<PZ[4] pin */

/**
  * @brief   EXTI5 configuration
  */
#define EXTI_EXTICR2_EXTI5_PA         ((uint32_t)0x00000000)                   /*!<PA[5] pin */
#define EXTI_EXTICR2_EXTI5_PB_Pos     (8U)
#define EXTI_EXTICR2_EXTI5_PB_Msk     (0x1U << EXTI_EXTICR2_EXTI5_PB_Pos)      /*!< 0x00000100 */
#define EXTI_EXTICR2_EXTI5_PB         EXTI_EXTICR2_EXTI5_PB_Msk                /*!<PB[5] pin */
#define EXTI_EXTICR2_EXTI5_PC_Pos     (9U)
#define EXTI_EXTICR2_EXTI5_PC_Msk     (0x1U << EXTI_EXTICR2_EXTI5_PC_Pos)      /*!< 0x00000200 */
#define EXTI_EXTICR2_EXTI5_PC         EXTI_EXTICR2_EXTI5_PC_Msk                /*!<PC[5] pin */
#define EXTI_EXTICR2_EXTI5_PD_Pos     (8U)
#define EXTI_EXTICR2_EXTI5_PD_Msk     (0x3U << EXTI_EXTICR2_EXTI5_PD_Pos)      /*!< 0x00000300 */
#define EXTI_EXTICR2_EXTI5_PD         EXTI_EXTICR2_EXTI5_PD_Msk                /*!<PD[5] pin */
#define EXTI_EXTICR2_EXTI5_PE_Pos     (10U)
#define EXTI_EXTICR2_EXTI5_PE_Msk     (0x1U << EXTI_EXTICR2_EXTI5_PE_Pos)      /*!< 0x00000400 */
#define EXTI_EXTICR2_EXTI5_PE         EXTI_EXTICR2_EXTI5_PE_Msk                /*!<PE[5] pin */
#define EXTI_EXTICR2_EXTI5_PF_Pos     (8U)
#define EXTI_EXTICR2_EXTI5_PF_Msk     (0x5U << EXTI_EXTICR2_EXTI5_PF_Pos)      /*!< 0x00000500 */
#define EXTI_EXTICR2_EXTI5_PF         EXTI_EXTICR2_EXTI5_PF_Msk                /*!<PF[5] pin */
#define EXTI_EXTICR2_EXTI5_PG_Pos     (9U)
#define EXTI_EXTICR2_EXTI5_PG_Msk     (0x3U << EXTI_EXTICR2_EXTI5_PG_Pos)      /*!< 0x00000600 */
#define EXTI_EXTICR2_EXTI5_PG         EXTI_EXTICR2_EXTI5_PG_Msk                /*!<PG[5] pin */
#define EXTI_EXTICR2_EXTI5_PH_Pos     (8U)
#define EXTI_EXTICR2_EXTI5_PH_Msk     (0x7U << EXTI_EXTICR2_EXTI5_PH_Pos)      /*!< 0x00000700 */
#define EXTI_EXTICR2_EXTI5_PH         EXTI_EXTICR2_EXTI5_PH_Msk                /*!<PH[5] pin */
#define EXTI_EXTICR2_EXTI5_PI_Pos     (11U)
#define EXTI_EXTICR2_EXTI5_PI_Msk     (0x1U << EXTI_EXTICR2_EXTI5_PI_Pos)      /*!< 0x00000800 */
#define EXTI_EXTICR2_EXTI5_PI         EXTI_EXTICR2_EXTI5_PI_Msk                /*!<PI[5] pin */
#define EXTI_EXTICR2_EXTI5_PJ_Pos     (8U)
#define EXTI_EXTICR2_EXTI5_PJ_Msk     (0x9U << EXTI_EXTICR2_EXTI5_PJ_Pos)      /*!< 0x00000900 */
#define EXTI_EXTICR2_EXTI5_PJ         EXTI_EXTICR2_EXTI5_PJ_Msk                /*!<PJ[5] pin */
#define EXTI_EXTICR2_EXTI5_PK_Pos     (9U)
#define EXTI_EXTICR2_EXTI5_PK_Msk     (0x5U << EXTI_EXTICR2_EXTI5_PK_Pos)      /*!< 0x00000A00 */
#define EXTI_EXTICR2_EXTI5_PK         EXTI_EXTICR2_EXTI5_PK_Msk                /*!<PK[5] pin */
#define EXTI_EXTICR2_EXTI5_PZ_Pos     (8U)
#define EXTI_EXTICR2_EXTI5_PZ_Msk     (0x19U << EXTI_EXTICR2_EXTI5_PZ_Pos)     /*!< 0x00001900 */
#define EXTI_EXTICR2_EXTI5_PZ         EXTI_EXTICR2_EXTI5_PZ_Msk                /*!<PZ[5] pin */

/**
  * @brief   EXTI6 configuration
  */
#define EXTI_EXTICR2_EXTI6_PA         ((uint32_t)0x00000000)                   /*!<PA[6] pin */
#define EXTI_EXTICR2_EXTI6_PB_Pos     (16U)
#define EXTI_EXTICR2_EXTI6_PB_Msk     (0x1U << EXTI_EXTICR2_EXTI6_PB_Pos)      /*!< 0x00010000 */
#define EXTI_EXTICR2_EXTI6_PB         EXTI_EXTICR2_EXTI6_PB_Msk                /*!<PB[6] pin */
#define EXTI_EXTICR2_EXTI6_PC_Pos     (17U)
#define EXTI_EXTICR2_EXTI6_PC_Msk     (0x1U << EXTI_EXTICR2_EXTI6_PC_Pos)      /*!< 0x00020000 */
#define EXTI_EXTICR2_EXTI6_PC         EXTI_EXTICR2_EXTI6_PC_Msk                /*!<PC[6] pin */
#define EXTI_EXTICR2_EXTI6_PD_Pos     (16U)
#define EXTI_EXTICR2_EXTI6_PD_Msk     (0x3U << EXTI_EXTICR2_EXTI6_PD_Pos)      /*!< 0x00030000 */
#define EXTI_EXTICR2_EXTI6_PD         EXTI_EXTICR2_EXTI6_PD_Msk                /*!<PD[6] pin */
#define EXTI_EXTICR2_EXTI6_PE_Pos     (18U)
#define EXTI_EXTICR2_EXTI6_PE_Msk     (0x1U << EXTI_EXTICR2_EXTI6_PE_Pos)      /*!< 0x00040000 */
#define EXTI_EXTICR2_EXTI6_PE         EXTI_EXTICR2_EXTI6_PE_Msk                /*!<PE[6] pin */
#define EXTI_EXTICR2_EXTI6_PF_Pos     (16U)
#define EXTI_EXTICR2_EXTI6_PF_Msk     (0x5U << EXTI_EXTICR2_EXTI6_PF_Pos)      /*!< 0x00050000 */
#define EXTI_EXTICR2_EXTI6_PF         EXTI_EXTICR2_EXTI6_PF_Msk                /*!<PF[6] pin */
#define EXTI_EXTICR2_EXTI6_PG_Pos     (17U)
#define EXTI_EXTICR2_EXTI6_PG_Msk     (0x3U << EXTI_EXTICR2_EXTI6_PG_Pos)      /*!< 0x00060000 */
#define EXTI_EXTICR2_EXTI6_PG         EXTI_EXTICR2_EXTI6_PG_Msk                /*!<PG[6] pin */
#define EXTI_EXTICR2_EXTI6_PH_Pos     (16U)
#define EXTI_EXTICR2_EXTI6_PH_Msk     (0x7U << EXTI_EXTICR2_EXTI6_PH_Pos)      /*!< 0x00070000 */
#define EXTI_EXTICR2_EXTI6_PH         EXTI_EXTICR2_EXTI6_PH_Msk                /*!<PH[6] pin */
#define EXTI_EXTICR2_EXTI6_PI_Pos     (19U)
#define EXTI_EXTICR2_EXTI6_PI_Msk     (0x1U << EXTI_EXTICR2_EXTI6_PI_Pos)      /*!< 0x00080000 */
#define EXTI_EXTICR2_EXTI6_PI         EXTI_EXTICR2_EXTI6_PI_Msk                /*!<PI[6] pin */
#define EXTI_EXTICR2_EXTI6_PJ_Pos     (16U)
#define EXTI_EXTICR2_EXTI6_PJ_Msk     (0x9U << EXTI_EXTICR2_EXTI6_PJ_Pos)      /*!< 0x00090000 */
#define EXTI_EXTICR2_EXTI6_PJ         EXTI_EXTICR2_EXTI6_PJ_Msk                /*!<PJ[6] pin */
#define EXTI_EXTICR2_EXTI6_PK_Pos     (17U)
#define EXTI_EXTICR2_EXTI6_PK_Msk     (0x5U << EXTI_EXTICR2_EXTI6_PK_Pos)      /*!< 0x000A0000 */
#define EXTI_EXTICR2_EXTI6_PK         EXTI_EXTICR2_EXTI6_PK_Msk                /*!<PK[6] pin */
#define EXTI_EXTICR2_EXTI6_PZ_Pos     (16U)
#define EXTI_EXTICR2_EXTI6_PZ_Msk     (0x19U << EXTI_EXTICR2_EXTI6_PZ_Pos)     /*!< 0x00190000 */
#define EXTI_EXTICR2_EXTI6_PZ         EXTI_EXTICR2_EXTI6_PZ_Msk                /*!<PZ[6] pin */

/**
  * @brief   EXTI7 configuration
  */
#define EXTI_EXTICR2_EXTI7_PA         ((uint32_t)0x00000000)                   /*!<PA[7] pin */
#define EXTI_EXTICR2_EXTI7_PB_Pos     (24U)
#define EXTI_EXTICR2_EXTI7_PB_Msk     (0x1U << EXTI_EXTICR2_EXTI7_PB_Pos)      /*!< 0x01000000 */
#define EXTI_EXTICR2_EXTI7_PB         EXTI_EXTICR2_EXTI7_PB_Msk                /*!<PB[7] pin */
#define EXTI_EXTICR2_EXTI7_PC_Pos     (25U)
#define EXTI_EXTICR2_EXTI7_PC_Msk     (0x1U << EXTI_EXTICR2_EXTI7_PC_Pos)      /*!< 0x02000000 */
#define EXTI_EXTICR2_EXTI7_PC         EXTI_EXTICR2_EXTI7_PC_Msk                /*!<PC[7] pin */
#define EXTI_EXTICR2_EXTI7_PD_Pos     (24U)
#define EXTI_EXTICR2_EXTI7_PD_Msk     (0x3U << EXTI_EXTICR2_EXTI7_PD_Pos)      /*!< 0x03000000 */
#define EXTI_EXTICR2_EXTI7_PD         EXTI_EXTICR2_EXTI7_PD_Msk                /*!<PD[7] pin */
#define EXTI_EXTICR2_EXTI7_PE_Pos     (26U)
#define EXTI_EXTICR2_EXTI7_PE_Msk     (0x1U << EXTI_EXTICR2_EXTI7_PE_Pos)      /*!< 0x04000000 */
#define EXTI_EXTICR2_EXTI7_PE         EXTI_EXTICR2_EXTI7_PE_Msk                /*!<PE[7] pin */
#define EXTI_EXTICR2_EXTI7_PF_Pos     (24U)
#define EXTI_EXTICR2_EXTI7_PF_Msk     (0x5U << EXTI_EXTICR2_EXTI7_PF_Pos)      /*!< 0x05000000 */
#define EXTI_EXTICR2_EXTI7_PF         EXTI_EXTICR2_EXTI7_PF_Msk                /*!<PF[7] pin */
#define EXTI_EXTICR2_EXTI7_PG_Pos     (25U)
#define EXTI_EXTICR2_EXTI7_PG_Msk     (0x3U << EXTI_EXTICR2_EXTI7_PG_Pos)      /*!< 0x06000000 */
#define EXTI_EXTICR2_EXTI7_PG         EXTI_EXTICR2_EXTI7_PG_Msk                /*!<PG[7] pin */
#define EXTI_EXTICR2_EXTI7_PH_Pos     (24U)
#define EXTI_EXTICR2_EXTI7_PH_Msk     (0x7U << EXTI_EXTICR2_EXTI7_PH_Pos)      /*!< 0x07000000 */
#define EXTI_EXTICR2_EXTI7_PH         EXTI_EXTICR2_EXTI7_PH_Msk                /*!<PH[7] pin */
#define EXTI_EXTICR2_EXTI7_PI_Pos     (27U)
#define EXTI_EXTICR2_EXTI7_PI_Msk     (0x1U << EXTI_EXTICR2_EXTI7_PI_Pos)      /*!< 0x08000000 */
#define EXTI_EXTICR2_EXTI7_PI         EXTI_EXTICR2_EXTI7_PI_Msk                /*!<PI[7] pin */
#define EXTI_EXTICR2_EXTI7_PJ_Pos     (24U)
#define EXTI_EXTICR2_EXTI7_PJ_Msk     (0x9U << EXTI_EXTICR2_EXTI7_PJ_Pos)      /*!< 0x09000000 */
#define EXTI_EXTICR2_EXTI7_PJ         EXTI_EXTICR2_EXTI7_PJ_Msk                /*!<PJ[7] pin */
#define EXTI_EXTICR2_EXTI7_PK_Pos     (25U)
#define EXTI_EXTICR2_EXTI7_PK_Msk     (0x5U << EXTI_EXTICR2_EXTI7_PK_Pos)      /*!< 0x0A000000 */
#define EXTI_EXTICR2_EXTI7_PK         EXTI_EXTICR2_EXTI7_PK_Msk                /*!<PK[7] pin */
#define EXTI_EXTICR2_EXTI7_PZ_Pos     (24U)
#define EXTI_EXTICR2_EXTI7_PZ_Msk     (0x19U << EXTI_EXTICR2_EXTI7_PZ_Pos)     /*!< 0x19000000 */
#define EXTI_EXTICR2_EXTI7_PZ         EXTI_EXTICR2_EXTI7_PZ_Msk                /*!<PZ[7] pin */


/*****************  Bit definition for EXTI_EXTICR3 register  ***************/
#define EXTI_EXTICR3_EXTI8_Pos        (0U)
#define EXTI_EXTICR3_EXTI8_Msk        (0xFFU << EXTI_EXTICR3_EXTI8_Pos)        /*!< 0x000000FF */
#define EXTI_EXTICR3_EXTI8            EXTI_EXTICR3_EXTI8_Msk                   /*!<EXTI 8 configuration */
#define EXTI_EXTICR3_EXTI9_Pos        (8U)
#define EXTI_EXTICR3_EXTI9_Msk        (0xFFU << EXTI_EXTICR3_EXTI9_Pos)        /*!< 0x0000FF00 */
#define EXTI_EXTICR3_EXTI9            EXTI_EXTICR3_EXTI9_Msk                   /*!<EXTI 9 configuration */
#define EXTI_EXTICR3_EXTI10_Pos       (16U)
#define EXTI_EXTICR3_EXTI10_Msk       (0xFFU << EXTI_EXTICR3_EXTI10_Pos)       /*!< 0x00FF0000 */
#define EXTI_EXTICR3_EXTI10           EXTI_EXTICR3_EXTI10_Msk                  /*!<EXTI 10 configuration */
#define EXTI_EXTICR3_EXTI11_Pos       (24U)
#define EXTI_EXTICR3_EXTI11_Msk       (0xFFU << EXTI_EXTICR3_EXTI11_Pos)       /*!< 0xFF000000 */
#define EXTI_EXTICR3_EXTI11           EXTI_EXTICR3_EXTI11_Msk                  /*!<EXTI 11 configuration */

/**
  * @brief   EXTI8 configuration
  */
#define EXTI_EXTICR3_EXTI8_PA         ((uint32_t)0x00000000)                   /*!<PA[8] pin */
#define EXTI_EXTICR3_EXTI8_PB_Pos     (0U)
#define EXTI_EXTICR3_EXTI8_PB_Msk     (0x1U << EXTI_EXTICR3_EXTI8_PB_Pos)      /*!< 0x00000001 */
#define EXTI_EXTICR3_EXTI8_PB         EXTI_EXTICR3_EXTI8_PB_Msk                /*!<PB[8] pin */
#define EXTI_EXTICR3_EXTI8_PC_Pos     (1U)
#define EXTI_EXTICR3_EXTI8_PC_Msk     (0x1U << EXTI_EXTICR3_EXTI8_PC_Pos)      /*!< 0x00000002 */
#define EXTI_EXTICR3_EXTI8_PC         EXTI_EXTICR3_EXTI8_PC_Msk                /*!<PC[8] pin */
#define EXTI_EXTICR3_EXTI8_PD_Pos     (0U)
#define EXTI_EXTICR3_EXTI8_PD_Msk     (0x3U << EXTI_EXTICR3_EXTI8_PD_Pos)      /*!< 0x00000003 */
#define EXTI_EXTICR3_EXTI8_PD         EXTI_EXTICR3_EXTI8_PD_Msk                /*!<PD[8] pin */
#define EXTI_EXTICR3_EXTI8_PE_Pos     (2U)
#define EXTI_EXTICR3_EXTI8_PE_Msk     (0x1U << EXTI_EXTICR3_EXTI8_PE_Pos)      /*!< 0x00000004 */
#define EXTI_EXTICR3_EXTI8_PE         EXTI_EXTICR3_EXTI8_PE_Msk                /*!<PE[8] pin */
#define EXTI_EXTICR3_EXTI8_PF_Pos     (0U)
#define EXTI_EXTICR3_EXTI8_PF_Msk     (0x5U << EXTI_EXTICR3_EXTI8_PF_Pos)      /*!< 0x00000005 */
#define EXTI_EXTICR3_EXTI8_PF         EXTI_EXTICR3_EXTI8_PF_Msk                /*!<PF[8] pin */
#define EXTI_EXTICR3_EXTI8_PG_Pos     (1U)
#define EXTI_EXTICR3_EXTI8_PG_Msk     (0x3U << EXTI_EXTICR3_EXTI8_PG_Pos)      /*!< 0x00000006 */
#define EXTI_EXTICR3_EXTI8_PG         EXTI_EXTICR3_EXTI8_PG_Msk                /*!<PG[8] pin */
#define EXTI_EXTICR3_EXTI8_PH_Pos     (0U)
#define EXTI_EXTICR3_EXTI8_PH_Msk     (0x7U << EXTI_EXTICR3_EXTI8_PH_Pos)      /*!< 0x00000007 */
#define EXTI_EXTICR3_EXTI8_PH         EXTI_EXTICR3_EXTI8_PH_Msk                /*!<PH[8] pin */
#define EXTI_EXTICR3_EXTI8_PI_Pos     (3U)
#define EXTI_EXTICR3_EXTI8_PI_Msk     (0x1U << EXTI_EXTICR3_EXTI8_PI_Pos)      /*!< 0x00000008 */
#define EXTI_EXTICR3_EXTI8_PI         EXTI_EXTICR3_EXTI8_PI_Msk                /*!<PI[8] pin */
#define EXTI_EXTICR3_EXTI8_PJ_Pos     (0U)
#define EXTI_EXTICR3_EXTI8_PJ_Msk     (0x9U << EXTI_EXTICR3_EXTI8_PJ_Pos)      /*!< 0x00000009 */
#define EXTI_EXTICR3_EXTI8_PJ         EXTI_EXTICR3_EXTI8_PJ_Msk                /*!<PJ[8] pin */

/**
  * @brief   EXTI9 configuration
  */
#define EXTI_EXTICR3_EXTI9_PA         ((uint32_t)0x00000000)                   /*!<PA[9] pin */
#define EXTI_EXTICR3_EXTI9_PB_Pos     (8U)
#define EXTI_EXTICR3_EXTI9_PB_Msk     (0x1U << EXTI_EXTICR3_EXTI9_PB_Pos)      /*!< 0x00000100 */
#define EXTI_EXTICR3_EXTI9_PB         EXTI_EXTICR3_EXTI9_PB_Msk                /*!<PB[9] pin */
#define EXTI_EXTICR3_EXTI9_PC_Pos     (9U)
#define EXTI_EXTICR3_EXTI9_PC_Msk     (0x1U << EXTI_EXTICR3_EXTI9_PC_Pos)      /*!< 0x00000200 */
#define EXTI_EXTICR3_EXTI9_PC         EXTI_EXTICR3_EXTI9_PC_Msk                /*!<PC[9] pin */
#define EXTI_EXTICR3_EXTI9_PD_Pos     (8U)
#define EXTI_EXTICR3_EXTI9_PD_Msk     (0x3U << EXTI_EXTICR3_EXTI9_PD_Pos)      /*!< 0x00000300 */
#define EXTI_EXTICR3_EXTI9_PD         EXTI_EXTICR3_EXTI9_PD_Msk                /*!<PD[9] pin */
#define EXTI_EXTICR3_EXTI9_PE_Pos     (10U)
#define EXTI_EXTICR3_EXTI9_PE_Msk     (0x1U << EXTI_EXTICR3_EXTI9_PE_Pos)      /*!< 0x00000400 */
#define EXTI_EXTICR3_EXTI9_PE         EXTI_EXTICR3_EXTI9_PE_Msk                /*!<PE[9] pin */
#define EXTI_EXTICR3_EXTI9_PF_Pos     (8U)
#define EXTI_EXTICR3_EXTI9_PF_Msk     (0x5U << EXTI_EXTICR3_EXTI9_PF_Pos)      /*!< 0x00000500 */
#define EXTI_EXTICR3_EXTI9_PF         EXTI_EXTICR3_EXTI9_PF_Msk                /*!<PF[9] pin */
#define EXTI_EXTICR3_EXTI9_PG_Pos     (9U)
#define EXTI_EXTICR3_EXTI9_PG_Msk     (0x3U << EXTI_EXTICR3_EXTI9_PG_Pos)      /*!< 0x00000600 */
#define EXTI_EXTICR3_EXTI9_PG         EXTI_EXTICR3_EXTI9_PG_Msk                /*!<PG[9] pin */
#define EXTI_EXTICR3_EXTI9_PH_Pos     (8U)
#define EXTI_EXTICR3_EXTI9_PH_Msk     (0x7U << EXTI_EXTICR3_EXTI9_PH_Pos)      /*!< 0x00000700 */
#define EXTI_EXTICR3_EXTI9_PH         EXTI_EXTICR3_EXTI9_PH_Msk                /*!<PH[9] pin */
#define EXTI_EXTICR3_EXTI9_PI_Pos     (11U)
#define EXTI_EXTICR3_EXTI9_PI_Msk     (0x1U << EXTI_EXTICR3_EXTI9_PI_Pos)      /*!< 0x00000800 */
#define EXTI_EXTICR3_EXTI9_PI         EXTI_EXTICR3_EXTI9_PI_Msk                /*!<PI[9] pin */
#define EXTI_EXTICR3_EXTI9_PJ_Pos     (8U)
#define EXTI_EXTICR3_EXTI9_PJ_Msk     (0x9U << EXTI_EXTICR3_EXTI9_PJ_Pos)      /*!< 0x00000900 */
#define EXTI_EXTICR3_EXTI9_PJ         EXTI_EXTICR3_EXTI9_PJ_Msk                /*!<PJ[9] pin */

/**
  * @brief   EXTI10 configuration
  */
#define EXTI_EXTICR3_EXTI10_PA        ((uint32_t)0x00000000)                   /*!<PA[10] pin */
#define EXTI_EXTICR3_EXTI10_PB_Pos    (16U)
#define EXTI_EXTICR3_EXTI10_PB_Msk    (0x1U << EXTI_EXTICR3_EXTI10_PB_Pos)     /*!< 0x00010000 */
#define EXTI_EXTICR3_EXTI10_PB        EXTI_EXTICR3_EXTI10_PB_Msk               /*!<PB[10] pin */
#define EXTI_EXTICR3_EXTI10_PC_Pos    (17U)
#define EXTI_EXTICR3_EXTI10_PC_Msk    (0x1U << EXTI_EXTICR3_EXTI10_PC_Pos)     /*!< 0x00020000 */
#define EXTI_EXTICR3_EXTI10_PC        EXTI_EXTICR3_EXTI10_PC_Msk               /*!<PC[10] pin */
#define EXTI_EXTICR3_EXTI10_PD_Pos    (16U)
#define EXTI_EXTICR3_EXTI10_PD_Msk    (0x3U << EXTI_EXTICR3_EXTI10_PD_Pos)     /*!< 0x00030000 */
#define EXTI_EXTICR3_EXTI10_PD        EXTI_EXTICR3_EXTI10_PD_Msk               /*!<PD[10] pin */
#define EXTI_EXTICR3_EXTI10_PE_Pos    (18U)
#define EXTI_EXTICR3_EXTI10_PE_Msk    (0x1U << EXTI_EXTICR3_EXTI10_PE_Pos)     /*!< 0x00040000 */
#define EXTI_EXTICR3_EXTI10_PE        EXTI_EXTICR3_EXTI10_PE_Msk               /*!<PE[10] pin */
#define EXTI_EXTICR3_EXTI10_PF_Pos    (16U)
#define EXTI_EXTICR3_EXTI10_PF_Msk    (0x5U << EXTI_EXTICR3_EXTI10_PF_Pos)     /*!< 0x00050000 */
#define EXTI_EXTICR3_EXTI10_PF        EXTI_EXTICR3_EXTI10_PF_Msk               /*!<PF[10] pin */
#define EXTI_EXTICR3_EXTI10_PG_Pos    (17U)
#define EXTI_EXTICR3_EXTI10_PG_Msk    (0x3U << EXTI_EXTICR3_EXTI10_PG_Pos)     /*!< 0x00060000 */
#define EXTI_EXTICR3_EXTI10_PG        EXTI_EXTICR3_EXTI10_PG_Msk               /*!<PG[10] pin */
#define EXTI_EXTICR3_EXTI10_PH_Pos    (16U)
#define EXTI_EXTICR3_EXTI10_PH_Msk    (0x7U << EXTI_EXTICR3_EXTI10_PH_Pos)     /*!< 0x00070000 */
#define EXTI_EXTICR3_EXTI10_PH        EXTI_EXTICR3_EXTI10_PH_Msk               /*!<PH[10] pin */
#define EXTI_EXTICR3_EXTI10_PI_Pos    (19U)
#define EXTI_EXTICR3_EXTI10_PI_Msk    (0x1U << EXTI_EXTICR3_EXTI10_PI_Pos)     /*!< 0x00080000 */
#define EXTI_EXTICR3_EXTI10_PI        EXTI_EXTICR3_EXTI10_PI_Msk               /*!<PI[10] pin */
#define EXTI_EXTICR3_EXTI10_PJ_Pos    (16U)
#define EXTI_EXTICR3_EXTI10_PJ_Msk    (0x9U << EXTI_EXTICR3_EXTI10_PJ_Pos)     /*!< 0x00090000 */
#define EXTI_EXTICR3_EXTI10_PJ        EXTI_EXTICR3_EXTI10_PJ_Msk               /*!<PJ[10] pin */

/**
  * @brief   EXTI11 configuration
  */
#define EXTI_EXTICR3_EXTI11_PA        ((uint32_t)0x00000000)                   /*!<PA[11] pin */
#define EXTI_EXTICR3_EXTI11_PB_Pos    (24U)
#define EXTI_EXTICR3_EXTI11_PB_Msk    (0x1U << EXTI_EXTICR3_EXTI11_PB_Pos)     /*!< 0x01000000 */
#define EXTI_EXTICR3_EXTI11_PB        EXTI_EXTICR3_EXTI11_PB_Msk               /*!<PB[11] pin */
#define EXTI_EXTICR3_EXTI11_PC_Pos    (25U)
#define EXTI_EXTICR3_EXTI11_PC_Msk    (0x1U << EXTI_EXTICR3_EXTI11_PC_Pos)     /*!< 0x02000000 */
#define EXTI_EXTICR3_EXTI11_PC        EXTI_EXTICR3_EXTI11_PC_Msk               /*!<PC[11] pin */
#define EXTI_EXTICR3_EXTI11_PD_Pos    (24U)
#define EXTI_EXTICR3_EXTI11_PD_Msk    (0x3U << EXTI_EXTICR3_EXTI11_PD_Pos)     /*!< 0x03000000 */
#define EXTI_EXTICR3_EXTI11_PD        EXTI_EXTICR3_EXTI11_PD_Msk               /*!<PD[11] pin */
#define EXTI_EXTICR3_EXTI11_PE_Pos    (26U)
#define EXTI_EXTICR3_EXTI11_PE_Msk    (0x1U << EXTI_EXTICR3_EXTI11_PE_Pos)     /*!< 0x04000000 */
#define EXTI_EXTICR3_EXTI11_PE        EXTI_EXTICR3_EXTI11_PE_Msk               /*!<PE[11] pin */
#define EXTI_EXTICR3_EXTI11_PF_Pos    (24U)
#define EXTI_EXTICR3_EXTI11_PF_Msk    (0x5U << EXTI_EXTICR3_EXTI11_PF_Pos)     /*!< 0x05000000 */
#define EXTI_EXTICR3_EXTI11_PF        EXTI_EXTICR3_EXTI11_PF_Msk               /*!<PF[11] pin */
#define EXTI_EXTICR3_EXTI11_PG_Pos    (25U)
#define EXTI_EXTICR3_EXTI11_PG_Msk    (0x3U << EXTI_EXTICR3_EXTI11_PG_Pos)     /*!< 0x06000000 */
#define EXTI_EXTICR3_EXTI11_PG        EXTI_EXTICR3_EXTI11_PG_Msk               /*!<PG[11] pin */
#define EXTI_EXTICR3_EXTI11_PH_Pos    (24U)
#define EXTI_EXTICR3_EXTI11_PH_Msk    (0x7U << EXTI_EXTICR3_EXTI11_PH_Pos)     /*!< 0x07000000 */
#define EXTI_EXTICR3_EXTI11_PH        EXTI_EXTICR3_EXTI11_PH_Msk               /*!<PH[11] pin */
#define EXTI_EXTICR3_EXTI11_PI_Pos    (27U)
#define EXTI_EXTICR3_EXTI11_PI_Msk    (0x1U << EXTI_EXTICR3_EXTI11_PI_Pos)     /*!< 0x08000000 */
#define EXTI_EXTICR3_EXTI11_PI        EXTI_EXTICR3_EXTI11_PI_Msk               /*!<PI[11] pin */
#define EXTI_EXTICR3_EXTI11_PJ_Pos    (24U)
#define EXTI_EXTICR3_EXTI11_PJ_Msk    (0x9U << EXTI_EXTICR3_EXTI11_PJ_Pos)     /*!< 0x09000000 */
#define EXTI_EXTICR3_EXTI11_PJ        EXTI_EXTICR3_EXTI11_PJ_Msk               /*!<PJ[11] pin */


/*****************  Bit definition for EXTI_EXTICR4 register  ***************/
#define EXTI_EXTICR4_EXTI12_Pos       (0U)
#define EXTI_EXTICR4_EXTI12_Msk       (0xFFU << EXTI_EXTICR4_EXTI12_Pos)       /*!< 0x000000FF */
#define EXTI_EXTICR4_EXTI12           EXTI_EXTICR4_EXTI12_Msk                  /*!<EXTI 12 configuration */
#define EXTI_EXTICR4_EXTI13_Pos       (8U)
#define EXTI_EXTICR4_EXTI13_Msk       (0xFFU << EXTI_EXTICR4_EXTI13_Pos)       /*!< 0x0000FF00 */
#define EXTI_EXTICR4_EXTI13           EXTI_EXTICR4_EXTI13_Msk                  /*!<EXTI 13 configuration */
#define EXTI_EXTICR4_EXTI14_Pos       (16U)
#define EXTI_EXTICR4_EXTI14_Msk       (0xFFU << EXTI_EXTICR4_EXTI14_Pos)       /*!< 0x00FF0000 */
#define EXTI_EXTICR4_EXTI14           EXTI_EXTICR4_EXTI14_Msk                  /*!<EXTI 14 configuration */
#define EXTI_EXTICR4_EXTI15_Pos       (24U)
#define EXTI_EXTICR4_EXTI15_Msk       (0xFFU << EXTI_EXTICR4_EXTI15_Pos)       /*!< 0xFF000000 */
#define EXTI_EXTICR4_EXTI15           EXTI_EXTICR4_EXTI15_Msk                  /*!<EXTI 15 configuration */

/**
  * @brief   EXTI12 configuration
  */
#define EXTI_EXTICR4_EXTI12_PA        ((uint32_t)0x00000000)                   /*!<PA[12] pin */
#define EXTI_EXTICR4_EXTI12_PB_Pos    (0U)
#define EXTI_EXTICR4_EXTI12_PB_Msk    (0x1U << EXTI_EXTICR4_EXTI12_PB_Pos)     /*!< 0x00000001 */
#define EXTI_EXTICR4_EXTI12_PB        EXTI_EXTICR4_EXTI12_PB_Msk               /*!<PB[12] pin */
#define EXTI_EXTICR4_EXTI12_PC_Pos    (1U)
#define EXTI_EXTICR4_EXTI12_PC_Msk    (0x1U << EXTI_EXTICR4_EXTI12_PC_Pos)     /*!< 0x00000002 */
#define EXTI_EXTICR4_EXTI12_PC        EXTI_EXTICR4_EXTI12_PC_Msk               /*!<PC[12] pin */
#define EXTI_EXTICR4_EXTI12_PD_Pos    (0U)
#define EXTI_EXTICR4_EXTI12_PD_Msk    (0x3U << EXTI_EXTICR4_EXTI12_PD_Pos)     /*!< 0x00000003 */
#define EXTI_EXTICR4_EXTI12_PD        EXTI_EXTICR4_EXTI12_PD_Msk               /*!<PD[12] pin */
#define EXTI_EXTICR4_EXTI12_PE_Pos    (2U)
#define EXTI_EXTICR4_EXTI12_PE_Msk    (0x1U << EXTI_EXTICR4_EXTI12_PE_Pos)     /*!< 0x00000004 */
#define EXTI_EXTICR4_EXTI12_PE        EXTI_EXTICR4_EXTI12_PE_Msk               /*!<PE[12] pin */
#define EXTI_EXTICR4_EXTI12_PF_Pos    (0U)
#define EXTI_EXTICR4_EXTI12_PF_Msk    (0x5U << EXTI_EXTICR4_EXTI12_PF_Pos)     /*!< 0x00000005 */
#define EXTI_EXTICR4_EXTI12_PF        EXTI_EXTICR4_EXTI12_PF_Msk               /*!<PF[12] pin */
#define EXTI_EXTICR4_EXTI12_PG_Pos    (1U)
#define EXTI_EXTICR4_EXTI12_PG_Msk    (0x3U << EXTI_EXTICR4_EXTI12_PG_Pos)     /*!< 0x00000006 */
#define EXTI_EXTICR4_EXTI12_PG        EXTI_EXTICR4_EXTI12_PG_Msk               /*!<PG[12] pin */
#define EXTI_EXTICR4_EXTI12_PH_Pos    (0U)
#define EXTI_EXTICR4_EXTI12_PH_Msk    (0x7U << EXTI_EXTICR4_EXTI12_PH_Pos)     /*!< 0x00000007 */
#define EXTI_EXTICR4_EXTI12_PH        EXTI_EXTICR4_EXTI12_PH_Msk               /*!<PH[12] pin */
#define EXTI_EXTICR4_EXTI12_PI_Pos    (3U)
#define EXTI_EXTICR4_EXTI12_PI_Msk    (0x1U << EXTI_EXTICR4_EXTI12_PI_Pos)     /*!< 0x00000008 */
#define EXTI_EXTICR4_EXTI12_PI        EXTI_EXTICR4_EXTI12_PI_Msk               /*!<PI[12] pin */
#define EXTI_EXTICR4_EXTI12_PJ_Pos    (0U)
#define EXTI_EXTICR4_EXTI12_PJ_Msk    (0x9U << EXTI_EXTICR4_EXTI12_PJ_Pos)     /*!< 0x00000009 */
#define EXTI_EXTICR4_EXTI12_PJ        EXTI_EXTICR4_EXTI12_PJ_Msk               /*!<PJ[12] pin */

/**
  * @brief   EXTI13 configuration
  */
#define EXTI_EXTICR4_EXTI13_PA        ((uint32_t)0x00000000)                   /*!<PA[13] pin */
#define EXTI_EXTICR4_EXTI13_PB_Pos    (8U)
#define EXTI_EXTICR4_EXTI13_PB_Msk    (0x1U << EXTI_EXTICR4_EXTI13_PB_Pos)     /*!< 0x00000100 */
#define EXTI_EXTICR4_EXTI13_PB        EXTI_EXTICR4_EXTI13_PB_Msk               /*!<PB[13] pin */
#define EXTI_EXTICR4_EXTI13_PC_Pos    (9U)
#define EXTI_EXTICR4_EXTI13_PC_Msk    (0x1U << EXTI_EXTICR4_EXTI13_PC_Pos)     /*!< 0x00000200 */
#define EXTI_EXTICR4_EXTI13_PC        EXTI_EXTICR4_EXTI13_PC_Msk               /*!<PC[13] pin */
#define EXTI_EXTICR4_EXTI13_PD_Pos    (8U)
#define EXTI_EXTICR4_EXTI13_PD_Msk    (0x3U << EXTI_EXTICR4_EXTI13_PD_Pos)     /*!< 0x00000300 */
#define EXTI_EXTICR4_EXTI13_PD        EXTI_EXTICR4_EXTI13_PD_Msk               /*!<PD[13] pin */
#define EXTI_EXTICR4_EXTI13_PE_Pos    (10U)
#define EXTI_EXTICR4_EXTI13_PE_Msk    (0x1U << EXTI_EXTICR4_EXTI13_PE_Pos)     /*!< 0x00000400 */
#define EXTI_EXTICR4_EXTI13_PE        EXTI_EXTICR4_EXTI13_PE_Msk               /*!<PE[13] pin */
#define EXTI_EXTICR4_EXTI13_PF_Pos    (8U)
#define EXTI_EXTICR4_EXTI13_PF_Msk    (0x5U << EXTI_EXTICR4_EXTI13_PF_Pos)     /*!< 0x00000500 */
#define EXTI_EXTICR4_EXTI13_PF        EXTI_EXTICR4_EXTI13_PF_Msk               /*!<PF[13] pin */
#define EXTI_EXTICR4_EXTI13_PG_Pos    (9U)
#define EXTI_EXTICR4_EXTI13_PG_Msk    (0x3U << EXTI_EXTICR4_EXTI13_PG_Pos)     /*!< 0x00000600 */
#define EXTI_EXTICR4_EXTI13_PG        EXTI_EXTICR4_EXTI13_PG_Msk               /*!<PG[13] pin */
#define EXTI_EXTICR4_EXTI13_PH_Pos    (8U)
#define EXTI_EXTICR4_EXTI13_PH_Msk    (0x7U << EXTI_EXTICR4_EXTI13_PH_Pos)     /*!< 0x00000700 */
#define EXTI_EXTICR4_EXTI13_PH        EXTI_EXTICR4_EXTI13_PH_Msk               /*!<PH[13] pin */
#define EXTI_EXTICR4_EXTI13_PI_Pos    (11U)
#define EXTI_EXTICR4_EXTI13_PI_Msk    (0x1U << EXTI_EXTICR4_EXTI13_PI_Pos)     /*!< 0x00000800 */
#define EXTI_EXTICR4_EXTI13_PI        EXTI_EXTICR4_EXTI13_PI_Msk               /*!<PI[13] pin */
#define EXTI_EXTICR4_EXTI13_PJ_Pos    (8U)
#define EXTI_EXTICR4_EXTI13_PJ_Msk    (0x9U << EXTI_EXTICR4_EXTI13_PJ_Pos)     /*!< 0x00000900 */
#define EXTI_EXTICR4_EXTI13_PJ        EXTI_EXTICR4_EXTI13_PJ_Msk               /*!<PJ[13] pin */

/**
  * @brief   EXTI14 configuration
  */
#define EXTI_EXTICR4_EXTI14_PA        ((uint32_t)0x00000000)                   /*!<PA[14] pin */
#define EXTI_EXTICR4_EXTI14_PB_Pos    (16U)
#define EXTI_EXTICR4_EXTI14_PB_Msk    (0x1U << EXTI_EXTICR4_EXTI14_PB_Pos)     /*!< 0x00010000 */
#define EXTI_EXTICR4_EXTI14_PB        EXTI_EXTICR4_EXTI14_PB_Msk               /*!<PB[14] pin */
#define EXTI_EXTICR4_EXTI14_PC_Pos    (17U)
#define EXTI_EXTICR4_EXTI14_PC_Msk    (0x1U << EXTI_EXTICR4_EXTI14_PC_Pos)     /*!< 0x00020000 */
#define EXTI_EXTICR4_EXTI14_PC        EXTI_EXTICR4_EXTI14_PC_Msk               /*!<PC[14] pin */
#define EXTI_EXTICR4_EXTI14_PD_Pos    (16U)
#define EXTI_EXTICR4_EXTI14_PD_Msk    (0x3U << EXTI_EXTICR4_EXTI14_PD_Pos)     /*!< 0x00030000 */
#define EXTI_EXTICR4_EXTI14_PD        EXTI_EXTICR4_EXTI14_PD_Msk               /*!<PD[14] pin */
#define EXTI_EXTICR4_EXTI14_PE_Pos    (18U)
#define EXTI_EXTICR4_EXTI14_PE_Msk    (0x1U << EXTI_EXTICR4_EXTI14_PE_Pos)     /*!< 0x00040000 */
#define EXTI_EXTICR4_EXTI14_PE        EXTI_EXTICR4_EXTI14_PE_Msk               /*!<PE[14] pin */
#define EXTI_EXTICR4_EXTI14_PF_Pos    (16U)
#define EXTI_EXTICR4_EXTI14_PF_Msk    (0x5U << EXTI_EXTICR4_EXTI14_PF_Pos)     /*!< 0x00050000 */
#define EXTI_EXTICR4_EXTI14_PF        EXTI_EXTICR4_EXTI14_PF_Msk               /*!<PF[14] pin */
#define EXTI_EXTICR4_EXTI14_PG_Pos    (17U)
#define EXTI_EXTICR4_EXTI14_PG_Msk    (0x3U << EXTI_EXTICR4_EXTI14_PG_Pos)     /*!< 0x00060000 */
#define EXTI_EXTICR4_EXTI14_PG        EXTI_EXTICR4_EXTI14_PG_Msk               /*!<PG[14] pin */
#define EXTI_EXTICR4_EXTI14_PH_Pos    (16U)
#define EXTI_EXTICR4_EXTI14_PH_Msk    (0x7U << EXTI_EXTICR4_EXTI14_PH_Pos)     /*!< 0x00070000 */
#define EXTI_EXTICR4_EXTI14_PH        EXTI_EXTICR4_EXTI14_PH_Msk               /*!<PH[14] pin */
#define EXTI_EXTICR4_EXTI14_PI_Pos    (19U)
#define EXTI_EXTICR4_EXTI14_PI_Msk    (0x1U << EXTI_EXTICR4_EXTI14_PI_Pos)     /*!< 0x00080000 */
#define EXTI_EXTICR4_EXTI14_PI        EXTI_EXTICR4_EXTI14_PI_Msk               /*!<PI[14] pin */
#define EXTI_EXTICR4_EXTI14_PJ_Pos    (16U)
#define EXTI_EXTICR4_EXTI14_PJ_Msk    (0x9U << EXTI_EXTICR4_EXTI14_PJ_Pos)     /*!< 0x00090000 */
#define EXTI_EXTICR4_EXTI14_PJ        EXTI_EXTICR4_EXTI14_PJ_Msk               /*!<PJ[14] pin */

/**
  * @brief   EXTI15 configuration
  */
#define EXTI_EXTICR4_EXTI15_PA        ((uint32_t)0x00000000)                   /*!<PA[15] pin */
#define EXTI_EXTICR4_EXTI15_PB_Pos    (24U)
#define EXTI_EXTICR4_EXTI15_PB_Msk    (0x1U << EXTI_EXTICR4_EXTI15_PB_Pos)     /*!< 0x01000000 */
#define EXTI_EXTICR4_EXTI15_PB        EXTI_EXTICR4_EXTI15_PB_Msk               /*!<PB[15] pin */
#define EXTI_EXTICR4_EXTI15_PC_Pos    (25U)
#define EXTI_EXTICR4_EXTI15_PC_Msk    (0x1U << EXTI_EXTICR4_EXTI15_PC_Pos)     /*!< 0x02000000 */
#define EXTI_EXTICR4_EXTI15_PC        EXTI_EXTICR4_EXTI15_PC_Msk               /*!<PC[15] pin */
#define EXTI_EXTICR4_EXTI15_PD_Pos    (24U)
#define EXTI_EXTICR4_EXTI15_PD_Msk    (0x3U << EXTI_EXTICR4_EXTI15_PD_Pos)     /*!< 0x03000000 */
#define EXTI_EXTICR4_EXTI15_PD        EXTI_EXTICR4_EXTI15_PD_Msk               /*!<PD[15] pin */
#define EXTI_EXTICR4_EXTI15_PE_Pos    (26U)
#define EXTI_EXTICR4_EXTI15_PE_Msk    (0x1U << EXTI_EXTICR4_EXTI15_PE_Pos)     /*!< 0x04000000 */
#define EXTI_EXTICR4_EXTI15_PE        EXTI_EXTICR4_EXTI15_PE_Msk               /*!<PE[15] pin */
#define EXTI_EXTICR4_EXTI15_PF_Pos    (24U)
#define EXTI_EXTICR4_EXTI15_PF_Msk    (0x5U << EXTI_EXTICR4_EXTI15_PF_Pos)     /*!< 0x05000000 */
#define EXTI_EXTICR4_EXTI15_PF        EXTI_EXTICR4_EXTI15_PF_Msk               /*!<PF[15] pin */
#define EXTI_EXTICR4_EXTI15_PG_Pos    (25U)
#define EXTI_EXTICR4_EXTI15_PG_Msk    (0x3U << EXTI_EXTICR4_EXTI15_PG_Pos)     /*!< 0x06000000 */
#define EXTI_EXTICR4_EXTI15_PG        EXTI_EXTICR4_EXTI15_PG_Msk               /*!<PG[15] pin */
#define EXTI_EXTICR4_EXTI15_PH_Pos    (24U)
#define EXTI_EXTICR4_EXTI15_PH_Msk    (0x7U << EXTI_EXTICR4_EXTI15_PH_Pos)     /*!< 0x07000000 */
#define EXTI_EXTICR4_EXTI15_PH        EXTI_EXTICR4_EXTI15_PH_Msk               /*!<PH[15] pin */
#define EXTI_EXTICR4_EXTI15_PI_Pos    (27U)
#define EXTI_EXTICR4_EXTI15_PI_Msk    (0x1U << EXTI_EXTICR4_EXTI15_PI_Pos)     /*!< 0x08000000 */
#define EXTI_EXTICR4_EXTI15_PI        EXTI_EXTICR4_EXTI15_PI_Msk               /*!<PI[15] pin */
#define EXTI_EXTICR4_EXTI15_PJ_Pos    (24U)
#define EXTI_EXTICR4_EXTI15_PJ_Msk    (0x9U << EXTI_EXTICR4_EXTI15_PJ_Pos)     /*!< 0x09000000 */
#define EXTI_EXTICR4_EXTI15_PJ        EXTI_EXTICR4_EXTI15_PJ_Msk               /*!<PJ[15] pin */



/******************************************************************************/
/*                                                                            */
/*                          Flexible Memory Controller                        */
/*                                                                            */
/******************************************************************************/
/******************  Bit definition for FMC_BCR1 register  *******************/
#define FMC_BCR1_MBKEN_Pos         (0U)
#define FMC_BCR1_MBKEN_Msk         (0x1U << FMC_BCR1_MBKEN_Pos)                /*!< 0x00000001 */
#define FMC_BCR1_MBKEN             FMC_BCR1_MBKEN_Msk                          /*!<Memory bank enable bit                 */
#define FMC_BCR1_MUXEN_Pos         (1U)
#define FMC_BCR1_MUXEN_Msk         (0x1U << FMC_BCR1_MUXEN_Pos)                /*!< 0x00000002 */
#define FMC_BCR1_MUXEN             FMC_BCR1_MUXEN_Msk                          /*!<Address/data multiplexing enable bit   */

#define FMC_BCR1_MTYP_Pos          (2U)
#define FMC_BCR1_MTYP_Msk          (0x3U << FMC_BCR1_MTYP_Pos)                 /*!< 0x0000000C */
#define FMC_BCR1_MTYP              FMC_BCR1_MTYP_Msk                           /*!<MTYP[1:0] bits (Memory type)           */
#define FMC_BCR1_MTYP_0            (0x1U << FMC_BCR1_MTYP_Pos)                 /*!< 0x00000004 */
#define FMC_BCR1_MTYP_1            (0x2U << FMC_BCR1_MTYP_Pos)                 /*!< 0x00000008 */

#define FMC_BCR1_MWID_Pos          (4U)
#define FMC_BCR1_MWID_Msk          (0x3U << FMC_BCR1_MWID_Pos)                 /*!< 0x00000030 */
#define FMC_BCR1_MWID              FMC_BCR1_MWID_Msk                           /*!<MWID[1:0] bits (Memory data bus width) */
#define FMC_BCR1_MWID_0            (0x1U << FMC_BCR1_MWID_Pos)                 /*!< 0x00000010 */
#define FMC_BCR1_MWID_1            (0x2U << FMC_BCR1_MWID_Pos)                 /*!< 0x00000020 */

#define FMC_BCR1_FACCEN_Pos        (6U)
#define FMC_BCR1_FACCEN_Msk        (0x1U << FMC_BCR1_FACCEN_Pos)               /*!< 0x00000040 */
#define FMC_BCR1_FACCEN            FMC_BCR1_FACCEN_Msk                         /*!<Flash access enable        */
#define FMC_BCR1_BURSTEN_Pos       (8U)
#define FMC_BCR1_BURSTEN_Msk       (0x1U << FMC_BCR1_BURSTEN_Pos)              /*!< 0x00000100 */
#define FMC_BCR1_BURSTEN           FMC_BCR1_BURSTEN_Msk                        /*!<Burst enable bit           */
#define FMC_BCR1_WAITPOL_Pos       (9U)
#define FMC_BCR1_WAITPOL_Msk       (0x1U << FMC_BCR1_WAITPOL_Pos)              /*!< 0x00000200 */
#define FMC_BCR1_WAITPOL           FMC_BCR1_WAITPOL_Msk                        /*!<Wait signal polarity bit   */
#define FMC_BCR1_WRAPMOD_Pos       (10U)
#define FMC_BCR1_WRAPMOD_Msk       (0x1U << FMC_BCR1_WRAPMOD_Pos)              /*!< 0x00000400 */
#define FMC_BCR1_WRAPMOD           FMC_BCR1_WRAPMOD_Msk                        /*!<Wrapped burst mode support */
#define FMC_BCR1_WAITCFG_Pos       (11U)
#define FMC_BCR1_WAITCFG_Msk       (0x1U << FMC_BCR1_WAITCFG_Pos)              /*!< 0x00000800 */
#define FMC_BCR1_WAITCFG           FMC_BCR1_WAITCFG_Msk                        /*!<Wait timing configuration  */
#define FMC_BCR1_WREN_Pos          (12U)
#define FMC_BCR1_WREN_Msk          (0x1U << FMC_BCR1_WREN_Pos)                 /*!< 0x00001000 */
#define FMC_BCR1_WREN              FMC_BCR1_WREN_Msk                           /*!<Write enable bit           */
#define FMC_BCR1_WAITEN_Pos        (13U)
#define FMC_BCR1_WAITEN_Msk        (0x1U << FMC_BCR1_WAITEN_Pos)               /*!< 0x00002000 */
#define FMC_BCR1_WAITEN            FMC_BCR1_WAITEN_Msk                         /*!<Wait enable bit            */
#define FMC_BCR1_EXTMOD_Pos        (14U)
#define FMC_BCR1_EXTMOD_Msk        (0x1U << FMC_BCR1_EXTMOD_Pos)               /*!< 0x00004000 */
#define FMC_BCR1_EXTMOD            FMC_BCR1_EXTMOD_Msk                         /*!<Extended mode enable       */
#define FMC_BCR1_ASYNCWAIT_Pos     (15U)
#define FMC_BCR1_ASYNCWAIT_Msk     (0x1U << FMC_BCR1_ASYNCWAIT_Pos)            /*!< 0x00008000 */
#define FMC_BCR1_ASYNCWAIT         FMC_BCR1_ASYNCWAIT_Msk                      /*!<Asynchronous wait          */

#define FMC_BCR1_CPSIZE_Pos        (16U)
#define FMC_BCR1_CPSIZE_Msk        (0x7U << FMC_BCR1_CPSIZE_Pos)               /*!< 0x00070000 */
#define FMC_BCR1_CPSIZE            FMC_BCR1_CPSIZE_Msk                         /*!<PSIZE[2:0] bits CRAM Page Size */
#define FMC_BCR1_CPSIZE_0          (0x1U << FMC_BCR1_CPSIZE_Pos)               /*!< 0x00010000 */
#define FMC_BCR1_CPSIZE_1          (0x2U << FMC_BCR1_CPSIZE_Pos)               /*!< 0x00020000 */
#define FMC_BCR1_CPSIZE_2          (0x4U << FMC_BCR1_CPSIZE_Pos)               /*!< 0x00040000 */

#define FMC_BCR1_CBURSTRW_Pos      (19U)
#define FMC_BCR1_CBURSTRW_Msk      (0x1U << FMC_BCR1_CBURSTRW_Pos)             /*!< 0x00080000 */
#define FMC_BCR1_CBURSTRW          FMC_BCR1_CBURSTRW_Msk                       /*!<Write burst enable         */
#define FMC_BCR1_CCLKEN_Pos        (20U)
#define FMC_BCR1_CCLKEN_Msk        (0x1U << FMC_BCR1_CCLKEN_Pos)               /*!< 0x00100000 */
#define FMC_BCR1_CCLKEN            FMC_BCR1_CCLKEN_Msk                         /*!<Continous clock enable     */
#define FMC_BCR1_WFDIS_Pos         (21U)
#define FMC_BCR1_WFDIS_Msk         (0x1U << FMC_BCR1_WFDIS_Pos)                /*!< 0x00200000 */
#define FMC_BCR1_WFDIS             FMC_BCR1_WFDIS_Msk                          /*!<Write FIFO Disable         */

/******************  Bit definition for FMC_BCR2 register  *******************/
#define FMC_BCR2_MBKEN_Pos         (0U)
#define FMC_BCR2_MBKEN_Msk         (0x1U << FMC_BCR2_MBKEN_Pos)                /*!< 0x00000001 */
#define FMC_BCR2_MBKEN             FMC_BCR2_MBKEN_Msk                          /*!<Memory bank enable bit                 */
#define FMC_BCR2_MUXEN_Pos         (1U)
#define FMC_BCR2_MUXEN_Msk         (0x1U << FMC_BCR2_MUXEN_Pos)                /*!< 0x00000002 */
#define FMC_BCR2_MUXEN             FMC_BCR2_MUXEN_Msk                          /*!<Address/data multiplexing enable bit   */

#define FMC_BCR2_MTYP_Pos          (2U)
#define FMC_BCR2_MTYP_Msk          (0x3U << FMC_BCR2_MTYP_Pos)                 /*!< 0x0000000C */
#define FMC_BCR2_MTYP              FMC_BCR2_MTYP_Msk                           /*!<MTYP[1:0] bits (Memory type)           */
#define FMC_BCR2_MTYP_0            (0x1U << FMC_BCR2_MTYP_Pos)                 /*!< 0x00000004 */
#define FMC_BCR2_MTYP_1            (0x2U << FMC_BCR2_MTYP_Pos)                 /*!< 0x00000008 */

#define FMC_BCR2_MWID_Pos          (4U)
#define FMC_BCR2_MWID_Msk          (0x3U << FMC_BCR2_MWID_Pos)                 /*!< 0x00000030 */
#define FMC_BCR2_MWID              FMC_BCR2_MWID_Msk                           /*!<MWID[1:0] bits (Memory data bus width) */
#define FMC_BCR2_MWID_0            (0x1U << FMC_BCR2_MWID_Pos)                 /*!< 0x00000010 */
#define FMC_BCR2_MWID_1            (0x2U << FMC_BCR2_MWID_Pos)                 /*!< 0x00000020 */

#define FMC_BCR2_FACCEN_Pos        (6U)
#define FMC_BCR2_FACCEN_Msk        (0x1U << FMC_BCR2_FACCEN_Pos)               /*!< 0x00000040 */
#define FMC_BCR2_FACCEN            FMC_BCR2_FACCEN_Msk                         /*!<Flash access enable        */
#define FMC_BCR2_BURSTEN_Pos       (8U)
#define FMC_BCR2_BURSTEN_Msk       (0x1U << FMC_BCR2_BURSTEN_Pos)              /*!< 0x00000100 */
#define FMC_BCR2_BURSTEN           FMC_BCR2_BURSTEN_Msk                        /*!<Burst enable bit           */
#define FMC_BCR2_WAITPOL_Pos       (9U)
#define FMC_BCR2_WAITPOL_Msk       (0x1U << FMC_BCR2_WAITPOL_Pos)              /*!< 0x00000200 */
#define FMC_BCR2_WAITPOL           FMC_BCR2_WAITPOL_Msk                        /*!<Wait signal polarity bit   */
#define FMC_BCR2_WRAPMOD_Pos       (10U)
#define FMC_BCR2_WRAPMOD_Msk       (0x1U << FMC_BCR2_WRAPMOD_Pos)              /*!< 0x00000400 */
#define FMC_BCR2_WRAPMOD           FMC_BCR2_WRAPMOD_Msk                        /*!<Wrapped burst mode support */
#define FMC_BCR2_WAITCFG_Pos       (11U)
#define FMC_BCR2_WAITCFG_Msk       (0x1U << FMC_BCR2_WAITCFG_Pos)              /*!< 0x00000800 */
#define FMC_BCR2_WAITCFG           FMC_BCR2_WAITCFG_Msk                        /*!<Wait timing configuration  */
#define FMC_BCR2_WREN_Pos          (12U)
#define FMC_BCR2_WREN_Msk          (0x1U << FMC_BCR2_WREN_Pos)                 /*!< 0x00001000 */
#define FMC_BCR2_WREN              FMC_BCR2_WREN_Msk                           /*!<Write enable bit           */
#define FMC_BCR2_WAITEN_Pos        (13U)
#define FMC_BCR2_WAITEN_Msk        (0x1U << FMC_BCR2_WAITEN_Pos)               /*!< 0x00002000 */
#define FMC_BCR2_WAITEN            FMC_BCR2_WAITEN_Msk                         /*!<Wait enable bit            */
#define FMC_BCR2_EXTMOD_Pos        (14U)
#define FMC_BCR2_EXTMOD_Msk        (0x1U << FMC_BCR2_EXTMOD_Pos)               /*!< 0x00004000 */
#define FMC_BCR2_EXTMOD            FMC_BCR2_EXTMOD_Msk                         /*!<Extended mode enable       */
#define FMC_BCR2_ASYNCWAIT_Pos     (15U)
#define FMC_BCR2_ASYNCWAIT_Msk     (0x1U << FMC_BCR2_ASYNCWAIT_Pos)            /*!< 0x00008000 */
#define FMC_BCR2_ASYNCWAIT         FMC_BCR2_ASYNCWAIT_Msk                      /*!<Asynchronous wait          */

#define FMC_BCR2_PSIZE_Pos         (16U)
#define FMC_BCR2_PSIZE_Msk         (0x7U << FMC_BCR2_PSIZE_Pos)                /*!< 0x00070000 */
#define FMC_BCR2_PSIZE             FMC_BCR2_PSIZE_Msk                          /*!<PSIZE[2:0] bits CRAM Page Size */
#define FMC_BCR2_PSIZE_0           (0x1U << FMC_BCR2_PSIZE_Pos)                /*!< 0x00010000 */
#define FMC_BCR2_PSIZE_1           (0x2U << FMC_BCR2_PSIZE_Pos)                /*!< 0x00020000 */
#define FMC_BCR2_PSIZE_2           (0x4U << FMC_BCR2_PSIZE_Pos)                /*!< 0x00040000 */

#define FMC_BCR2_CBURSTRW_Pos      (19U)
#define FMC_BCR2_CBURSTRW_Msk      (0x1U << FMC_BCR2_CBURSTRW_Pos)             /*!< 0x00080000 */
#define FMC_BCR2_CBURSTRW          FMC_BCR2_CBURSTRW_Msk                       /*!<Write burst enable         */

/******************  Bit definition for FMC_BCR3 register  *******************/
#define FMC_BCR3_MBKEN_Pos         (0U)
#define FMC_BCR3_MBKEN_Msk         (0x1U << FMC_BCR3_MBKEN_Pos)                /*!< 0x00000001 */
#define FMC_BCR3_MBKEN             FMC_BCR3_MBKEN_Msk                          /*!<Memory bank enable bit                 */
#define FMC_BCR3_MUXEN_Pos         (1U)
#define FMC_BCR3_MUXEN_Msk         (0x1U << FMC_BCR3_MUXEN_Pos)                /*!< 0x00000002 */
#define FMC_BCR3_MUXEN             FMC_BCR3_MUXEN_Msk                          /*!<Address/data multiplexing enable bit   */

#define FMC_BCR3_MTYP_Pos          (2U)
#define FMC_BCR3_MTYP_Msk          (0x3U << FMC_BCR3_MTYP_Pos)                 /*!< 0x0000000C */
#define FMC_BCR3_MTYP              FMC_BCR3_MTYP_Msk                           /*!<MTYP[1:0] bits (Memory type)           */
#define FMC_BCR3_MTYP_0            (0x1U << FMC_BCR3_MTYP_Pos)                 /*!< 0x00000004 */
#define FMC_BCR3_MTYP_1            (0x2U << FMC_BCR3_MTYP_Pos)                 /*!< 0x00000008 */

#define FMC_BCR3_MWID_Pos          (4U)
#define FMC_BCR3_MWID_Msk          (0x3U << FMC_BCR3_MWID_Pos)                 /*!< 0x00000030 */
#define FMC_BCR3_MWID              FMC_BCR3_MWID_Msk                           /*!<MWID[1:0] bits (Memory data bus width) */
#define FMC_BCR3_MWID_0            (0x1U << FMC_BCR3_MWID_Pos)                 /*!< 0x00000010 */
#define FMC_BCR3_MWID_1            (0x2U << FMC_BCR3_MWID_Pos)                 /*!< 0x00000020 */

#define FMC_BCR3_FACCEN_Pos        (6U)
#define FMC_BCR3_FACCEN_Msk        (0x1U << FMC_BCR3_FACCEN_Pos)               /*!< 0x00000040 */
#define FMC_BCR3_FACCEN            FMC_BCR3_FACCEN_Msk                         /*!<Flash access enable        */
#define FMC_BCR3_BURSTEN_Pos       (8U)
#define FMC_BCR3_BURSTEN_Msk       (0x1U << FMC_BCR3_BURSTEN_Pos)              /*!< 0x00000100 */
#define FMC_BCR3_BURSTEN           FMC_BCR3_BURSTEN_Msk                        /*!<Burst enable bit           */
#define FMC_BCR3_WAITPOL_Pos       (9U)
#define FMC_BCR3_WAITPOL_Msk       (0x1U << FMC_BCR3_WAITPOL_Pos)              /*!< 0x00000200 */
#define FMC_BCR3_WAITPOL           FMC_BCR3_WAITPOL_Msk                        /*!<Wait signal polarity bit   */
#define FMC_BCR3_WRAPMOD_Pos       (10U)
#define FMC_BCR3_WRAPMOD_Msk       (0x1U << FMC_BCR3_WRAPMOD_Pos)              /*!< 0x00000400 */
#define FMC_BCR3_WRAPMOD           FMC_BCR3_WRAPMOD_Msk                        /*!<Wrapped burst mode support */
#define FMC_BCR3_WAITCFG_Pos       (11U)
#define FMC_BCR3_WAITCFG_Msk       (0x1U << FMC_BCR3_WAITCFG_Pos)              /*!< 0x00000800 */
#define FMC_BCR3_WAITCFG           FMC_BCR3_WAITCFG_Msk                        /*!<Wait timing configuration  */
#define FMC_BCR3_WREN_Pos          (12U)
#define FMC_BCR3_WREN_Msk          (0x1U << FMC_BCR3_WREN_Pos)                 /*!< 0x00001000 */
#define FMC_BCR3_WREN              FMC_BCR3_WREN_Msk                           /*!<Write enable bit           */
#define FMC_BCR3_WAITEN_Pos        (13U)
#define FMC_BCR3_WAITEN_Msk        (0x1U << FMC_BCR3_WAITEN_Pos)               /*!< 0x00002000 */
#define FMC_BCR3_WAITEN            FMC_BCR3_WAITEN_Msk                         /*!<Wait enable bit            */
#define FMC_BCR3_EXTMOD_Pos        (14U)
#define FMC_BCR3_EXTMOD_Msk        (0x1U << FMC_BCR3_EXTMOD_Pos)               /*!< 0x00004000 */
#define FMC_BCR3_EXTMOD            FMC_BCR3_EXTMOD_Msk                         /*!<Extended mode enable       */
#define FMC_BCR3_ASYNCWAIT_Pos     (15U)
#define FMC_BCR3_ASYNCWAIT_Msk     (0x1U << FMC_BCR3_ASYNCWAIT_Pos)            /*!< 0x00008000 */
#define FMC_BCR3_ASYNCWAIT         FMC_BCR3_ASYNCWAIT_Msk                      /*!<Asynchronous wait          */

#define FMC_BCR3_PSIZE_Pos         (16U)
#define FMC_BCR3_PSIZE_Msk         (0x7U << FMC_BCR3_PSIZE_Pos)                /*!< 0x00070000 */
#define FMC_BCR3_PSIZE             FMC_BCR3_PSIZE_Msk                          /*!<PSIZE[2:0] bits CRAM Page Size */
#define FMC_BCR3_PSIZE_0           (0x1U << FMC_BCR3_PSIZE_Pos)                /*!< 0x00010000 */
#define FMC_BCR3_PSIZE_1           (0x2U << FMC_BCR3_PSIZE_Pos)                /*!< 0x00020000 */
#define FMC_BCR3_PSIZE_2           (0x4U << FMC_BCR3_PSIZE_Pos)                /*!< 0x00040000 */

#define FMC_BCR3_CBURSTRW_Pos      (19U)
#define FMC_BCR3_CBURSTRW_Msk      (0x1U << FMC_BCR3_CBURSTRW_Pos)             /*!< 0x00080000 */
#define FMC_BCR3_CBURSTRW          FMC_BCR3_CBURSTRW_Msk                       /*!<Write burst enable         */

/******************  Bit definition for FMC_BCR4 register  *******************/
#define FMC_BCR4_MBKEN_Pos         (0U)
#define FMC_BCR4_MBKEN_Msk         (0x1U << FMC_BCR4_MBKEN_Pos)                /*!< 0x00000001 */
#define FMC_BCR4_MBKEN             FMC_BCR4_MBKEN_Msk                          /*!<Memory bank enable bit                 */
#define FMC_BCR4_MUXEN_Pos         (1U)
#define FMC_BCR4_MUXEN_Msk         (0x1U << FMC_BCR4_MUXEN_Pos)                /*!< 0x00000002 */
#define FMC_BCR4_MUXEN             FMC_BCR4_MUXEN_Msk                          /*!<Address/data multiplexing enable bit   */

#define FMC_BCR4_MTYP_Pos          (2U)
#define FMC_BCR4_MTYP_Msk          (0x3U << FMC_BCR4_MTYP_Pos)                 /*!< 0x0000000C */
#define FMC_BCR4_MTYP              FMC_BCR4_MTYP_Msk                           /*!<MTYP[1:0] bits (Memory type)           */
#define FMC_BCR4_MTYP_0            (0x1U << FMC_BCR4_MTYP_Pos)                 /*!< 0x00000004 */
#define FMC_BCR4_MTYP_1            (0x2U << FMC_BCR4_MTYP_Pos)                 /*!< 0x00000008 */

#define FMC_BCR4_MWID_Pos          (4U)
#define FMC_BCR4_MWID_Msk          (0x3U << FMC_BCR4_MWID_Pos)                 /*!< 0x00000030 */
#define FMC_BCR4_MWID              FMC_BCR4_MWID_Msk                           /*!<MWID[1:0] bits (Memory data bus width) */
#define FMC_BCR4_MWID_0            (0x1U << FMC_BCR4_MWID_Pos)                 /*!< 0x00000010 */
#define FMC_BCR4_MWID_1            (0x2U << FMC_BCR4_MWID_Pos)                 /*!< 0x00000020 */

#define FMC_BCR4_FACCEN_Pos        (6U)
#define FMC_BCR4_FACCEN_Msk        (0x1U << FMC_BCR4_FACCEN_Pos)               /*!< 0x00000040 */
#define FMC_BCR4_FACCEN            FMC_BCR4_FACCEN_Msk                         /*!<Flash access enable        */
#define FMC_BCR4_BURSTEN_Pos       (8U)
#define FMC_BCR4_BURSTEN_Msk       (0x1U << FMC_BCR4_BURSTEN_Pos)              /*!< 0x00000100 */
#define FMC_BCR4_BURSTEN           FMC_BCR4_BURSTEN_Msk                        /*!<Burst enable bit           */
#define FMC_BCR4_WAITPOL_Pos       (9U)
#define FMC_BCR4_WAITPOL_Msk       (0x1U << FMC_BCR4_WAITPOL_Pos)              /*!< 0x00000200 */
#define FMC_BCR4_WAITPOL           FMC_BCR4_WAITPOL_Msk                        /*!<Wait signal polarity bit   */
#define FMC_BCR4_WRAPMOD_Pos       (10U)
#define FMC_BCR4_WRAPMOD_Msk       (0x1U << FMC_BCR4_WRAPMOD_Pos)              /*!< 0x00000400 */
#define FMC_BCR4_WRAPMOD           FMC_BCR4_WRAPMOD_Msk                        /*!<Wrapped burst mode support */
#define FMC_BCR4_WAITCFG_Pos       (11U)
#define FMC_BCR4_WAITCFG_Msk       (0x1U << FMC_BCR4_WAITCFG_Pos)              /*!< 0x00000800 */
#define FMC_BCR4_WAITCFG           FMC_BCR4_WAITCFG_Msk                        /*!<Wait timing configuration  */
#define FMC_BCR4_WREN_Pos          (12U)
#define FMC_BCR4_WREN_Msk          (0x1U << FMC_BCR4_WREN_Pos)                 /*!< 0x00001000 */
#define FMC_BCR4_WREN              FMC_BCR4_WREN_Msk                           /*!<Write enable bit           */
#define FMC_BCR4_WAITEN_Pos        (13U)
#define FMC_BCR4_WAITEN_Msk        (0x1U << FMC_BCR4_WAITEN_Pos)               /*!< 0x00002000 */
#define FMC_BCR4_WAITEN            FMC_BCR4_WAITEN_Msk                         /*!<Wait enable bit            */
#define FMC_BCR4_EXTMOD_Pos        (14U)
#define FMC_BCR4_EXTMOD_Msk        (0x1U << FMC_BCR4_EXTMOD_Pos)               /*!< 0x00004000 */
#define FMC_BCR4_EXTMOD            FMC_BCR4_EXTMOD_Msk                         /*!<Extended mode enable       */
#define FMC_BCR4_ASYNCWAIT_Pos     (15U)
#define FMC_BCR4_ASYNCWAIT_Msk     (0x1U << FMC_BCR4_ASYNCWAIT_Pos)            /*!< 0x00008000 */
#define FMC_BCR4_ASYNCWAIT         FMC_BCR4_ASYNCWAIT_Msk                      /*!<Asynchronous wait          */

#define FMC_BCR4_PSIZE_Pos         (16U)
#define FMC_BCR4_PSIZE_Msk         (0x7U << FMC_BCR4_PSIZE_Pos)                /*!< 0x00070000 */
#define FMC_BCR4_PSIZE             FMC_BCR4_PSIZE_Msk                          /*!<PSIZE[2:0] bits CRAM Page Size */
#define FMC_BCR4_PSIZE_0           (0x1U << FMC_BCR4_PSIZE_Pos)                /*!< 0x00010000 */
#define FMC_BCR4_PSIZE_1           (0x2U << FMC_BCR4_PSIZE_Pos)                /*!< 0x00020000 */
#define FMC_BCR4_PSIZE_2           (0x4U << FMC_BCR4_PSIZE_Pos)                /*!< 0x00040000 */

#define FMC_BCR4_CBURSTRW_Pos      (19U)
#define FMC_BCR4_CBURSTRW_Msk      (0x1U << FMC_BCR4_CBURSTRW_Pos)             /*!< 0x00080000 */
#define FMC_BCR4_CBURSTRW          FMC_BCR4_CBURSTRW_Msk                       /*!<Write burst enable         */

/******************  Bit definition for FMC_BTR1 register  ******************/
#define FMC_BTR1_ADDSET_Pos        (0U)
#define FMC_BTR1_ADDSET_Msk        (0xFU << FMC_BTR1_ADDSET_Pos)               /*!< 0x0000000F */
#define FMC_BTR1_ADDSET            FMC_BTR1_ADDSET_Msk                         /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BTR1_ADDSET_0          (0x1U << FMC_BTR1_ADDSET_Pos)               /*!< 0x00000001 */
#define FMC_BTR1_ADDSET_1          (0x2U << FMC_BTR1_ADDSET_Pos)               /*!< 0x00000002 */
#define FMC_BTR1_ADDSET_2          (0x4U << FMC_BTR1_ADDSET_Pos)               /*!< 0x00000004 */
#define FMC_BTR1_ADDSET_3          (0x8U << FMC_BTR1_ADDSET_Pos)               /*!< 0x00000008 */

#define FMC_BTR1_ADDHLD_Pos        (4U)
#define FMC_BTR1_ADDHLD_Msk        (0xFU << FMC_BTR1_ADDHLD_Pos)               /*!< 0x000000F0 */
#define FMC_BTR1_ADDHLD            FMC_BTR1_ADDHLD_Msk                         /*!<ADDHLD[3:0] bits (Address-hold phase duration)  */
#define FMC_BTR1_ADDHLD_0          (0x1U << FMC_BTR1_ADDHLD_Pos)               /*!< 0x00000010 */
#define FMC_BTR1_ADDHLD_1          (0x2U << FMC_BTR1_ADDHLD_Pos)               /*!< 0x00000020 */
#define FMC_BTR1_ADDHLD_2          (0x4U << FMC_BTR1_ADDHLD_Pos)               /*!< 0x00000040 */
#define FMC_BTR1_ADDHLD_3          (0x8U << FMC_BTR1_ADDHLD_Pos)               /*!< 0x00000080 */

#define FMC_BTR1_DATAST_Pos        (8U)
#define FMC_BTR1_DATAST_Msk        (0xFFU << FMC_BTR1_DATAST_Pos)              /*!< 0x0000FF00 */
#define FMC_BTR1_DATAST            FMC_BTR1_DATAST_Msk                         /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BTR1_DATAST_0          (0x01U << FMC_BTR1_DATAST_Pos)              /*!< 0x00000100 */
#define FMC_BTR1_DATAST_1          (0x02U << FMC_BTR1_DATAST_Pos)              /*!< 0x00000200 */
#define FMC_BTR1_DATAST_2          (0x04U << FMC_BTR1_DATAST_Pos)              /*!< 0x00000400 */
#define FMC_BTR1_DATAST_3          (0x08U << FMC_BTR1_DATAST_Pos)              /*!< 0x00000800 */
#define FMC_BTR1_DATAST_4          (0x10U << FMC_BTR1_DATAST_Pos)              /*!< 0x00001000 */
#define FMC_BTR1_DATAST_5          (0x20U << FMC_BTR1_DATAST_Pos)              /*!< 0x00002000 */
#define FMC_BTR1_DATAST_6          (0x40U << FMC_BTR1_DATAST_Pos)              /*!< 0x00004000 */
#define FMC_BTR1_DATAST_7          (0x80U << FMC_BTR1_DATAST_Pos)              /*!< 0x00008000 */

#define FMC_BTR1_BUSTURN_Pos       (16U)
#define FMC_BTR1_BUSTURN_Msk       (0xFU << FMC_BTR1_BUSTURN_Pos)              /*!< 0x000F0000 */
#define FMC_BTR1_BUSTURN           FMC_BTR1_BUSTURN_Msk                        /*!<BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FMC_BTR1_BUSTURN_0         (0x1U << FMC_BTR1_BUSTURN_Pos)              /*!< 0x00010000 */
#define FMC_BTR1_BUSTURN_1         (0x2U << FMC_BTR1_BUSTURN_Pos)              /*!< 0x00020000 */
#define FMC_BTR1_BUSTURN_2         (0x4U << FMC_BTR1_BUSTURN_Pos)              /*!< 0x00040000 */
#define FMC_BTR1_BUSTURN_3         (0x8U << FMC_BTR1_BUSTURN_Pos)              /*!< 0x00080000 */

#define FMC_BTR1_CLKDIV_Pos        (20U)
#define FMC_BTR1_CLKDIV_Msk        (0xFU << FMC_BTR1_CLKDIV_Pos)               /*!< 0x00F00000 */
#define FMC_BTR1_CLKDIV            FMC_BTR1_CLKDIV_Msk                         /*!<CLKDIV[3:0] bits (Clock divide ratio) */
#define FMC_BTR1_CLKDIV_0          (0x1U << FMC_BTR1_CLKDIV_Pos)               /*!< 0x00100000 */
#define FMC_BTR1_CLKDIV_1          (0x2U << FMC_BTR1_CLKDIV_Pos)               /*!< 0x00200000 */
#define FMC_BTR1_CLKDIV_2          (0x4U << FMC_BTR1_CLKDIV_Pos)               /*!< 0x00400000 */
#define FMC_BTR1_CLKDIV_3          (0x8U << FMC_BTR1_CLKDIV_Pos)               /*!< 0x00800000 */

#define FMC_BTR1_DATLAT_Pos        (24U)
#define FMC_BTR1_DATLAT_Msk        (0xFU << FMC_BTR1_DATLAT_Pos)               /*!< 0x0F000000 */
#define FMC_BTR1_DATLAT            FMC_BTR1_DATLAT_Msk                         /*!<DATLA[3:0] bits (Data latency) */
#define FMC_BTR1_DATLAT_0          (0x1U << FMC_BTR1_DATLAT_Pos)               /*!< 0x01000000 */
#define FMC_BTR1_DATLAT_1          (0x2U << FMC_BTR1_DATLAT_Pos)               /*!< 0x02000000 */
#define FMC_BTR1_DATLAT_2          (0x4U << FMC_BTR1_DATLAT_Pos)               /*!< 0x04000000 */
#define FMC_BTR1_DATLAT_3          (0x8U << FMC_BTR1_DATLAT_Pos)               /*!< 0x08000000 */

#define FMC_BTR1_ACCMOD_Pos        (28U)
#define FMC_BTR1_ACCMOD_Msk        (0x3U << FMC_BTR1_ACCMOD_Pos)               /*!< 0x30000000 */
#define FMC_BTR1_ACCMOD            FMC_BTR1_ACCMOD_Msk                         /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BTR1_ACCMOD_0          (0x1U << FMC_BTR1_ACCMOD_Pos)               /*!< 0x10000000 */
#define FMC_BTR1_ACCMOD_1          (0x2U << FMC_BTR1_ACCMOD_Pos)               /*!< 0x20000000 */

/******************  Bit definition for FMC_BTR2 register  *******************/
#define FMC_BTR2_ADDSET_Pos        (0U)
#define FMC_BTR2_ADDSET_Msk        (0xFU << FMC_BTR2_ADDSET_Pos)               /*!< 0x0000000F */
#define FMC_BTR2_ADDSET            FMC_BTR2_ADDSET_Msk                         /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BTR2_ADDSET_0          (0x1U << FMC_BTR2_ADDSET_Pos)               /*!< 0x00000001 */
#define FMC_BTR2_ADDSET_1          (0x2U << FMC_BTR2_ADDSET_Pos)               /*!< 0x00000002 */
#define FMC_BTR2_ADDSET_2          (0x4U << FMC_BTR2_ADDSET_Pos)               /*!< 0x00000004 */
#define FMC_BTR2_ADDSET_3          (0x8U << FMC_BTR2_ADDSET_Pos)               /*!< 0x00000008 */

#define FMC_BTR2_ADDHLD_Pos        (4U)
#define FMC_BTR2_ADDHLD_Msk        (0xFU << FMC_BTR2_ADDHLD_Pos)               /*!< 0x000000F0 */
#define FMC_BTR2_ADDHLD            FMC_BTR2_ADDHLD_Msk                         /*!<ADDHLD[3:0] bits (Address-hold phase duration) */
#define FMC_BTR2_ADDHLD_0          (0x1U << FMC_BTR2_ADDHLD_Pos)               /*!< 0x00000010 */
#define FMC_BTR2_ADDHLD_1          (0x2U << FMC_BTR2_ADDHLD_Pos)               /*!< 0x00000020 */
#define FMC_BTR2_ADDHLD_2          (0x4U << FMC_BTR2_ADDHLD_Pos)               /*!< 0x00000040 */
#define FMC_BTR2_ADDHLD_3          (0x8U << FMC_BTR2_ADDHLD_Pos)               /*!< 0x00000080 */

#define FMC_BTR2_DATAST_Pos        (8U)
#define FMC_BTR2_DATAST_Msk        (0xFFU << FMC_BTR2_DATAST_Pos)              /*!< 0x0000FF00 */
#define FMC_BTR2_DATAST            FMC_BTR2_DATAST_Msk                         /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BTR2_DATAST_0          (0x01U << FMC_BTR2_DATAST_Pos)              /*!< 0x00000100 */
#define FMC_BTR2_DATAST_1          (0x02U << FMC_BTR2_DATAST_Pos)              /*!< 0x00000200 */
#define FMC_BTR2_DATAST_2          (0x04U << FMC_BTR2_DATAST_Pos)              /*!< 0x00000400 */
#define FMC_BTR2_DATAST_3          (0x08U << FMC_BTR2_DATAST_Pos)              /*!< 0x00000800 */
#define FMC_BTR2_DATAST_4          (0x10U << FMC_BTR2_DATAST_Pos)              /*!< 0x00001000 */
#define FMC_BTR2_DATAST_5          (0x20U << FMC_BTR2_DATAST_Pos)              /*!< 0x00002000 */
#define FMC_BTR2_DATAST_6          (0x40U << FMC_BTR2_DATAST_Pos)              /*!< 0x00004000 */
#define FMC_BTR2_DATAST_7          (0x80U << FMC_BTR2_DATAST_Pos)              /*!< 0x00008000 */

#define FMC_BTR2_BUSTURN_Pos       (16U)
#define FMC_BTR2_BUSTURN_Msk       (0xFU << FMC_BTR2_BUSTURN_Pos)              /*!< 0x000F0000 */
#define FMC_BTR2_BUSTURN           FMC_BTR2_BUSTURN_Msk                        /*!<BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FMC_BTR2_BUSTURN_0         (0x1U << FMC_BTR2_BUSTURN_Pos)              /*!< 0x00010000 */
#define FMC_BTR2_BUSTURN_1         (0x2U << FMC_BTR2_BUSTURN_Pos)              /*!< 0x00020000 */
#define FMC_BTR2_BUSTURN_2         (0x4U << FMC_BTR2_BUSTURN_Pos)              /*!< 0x00040000 */
#define FMC_BTR2_BUSTURN_3         (0x8U << FMC_BTR2_BUSTURN_Pos)              /*!< 0x00080000 */

#define FMC_BTR2_CLKDIV_Pos        (20U)
#define FMC_BTR2_CLKDIV_Msk        (0xFU << FMC_BTR2_CLKDIV_Pos)               /*!< 0x00F00000 */
#define FMC_BTR2_CLKDIV            FMC_BTR2_CLKDIV_Msk                         /*!<CLKDIV[3:0] bits (Clock divide ratio) */
#define FMC_BTR2_CLKDIV_0          (0x1U << FMC_BTR2_CLKDIV_Pos)               /*!< 0x00100000 */
#define FMC_BTR2_CLKDIV_1          (0x2U << FMC_BTR2_CLKDIV_Pos)               /*!< 0x00200000 */
#define FMC_BTR2_CLKDIV_2          (0x4U << FMC_BTR2_CLKDIV_Pos)               /*!< 0x00400000 */
#define FMC_BTR2_CLKDIV_3          (0x8U << FMC_BTR2_CLKDIV_Pos)               /*!< 0x00800000 */

#define FMC_BTR2_DATLAT_Pos        (24U)
#define FMC_BTR2_DATLAT_Msk        (0xFU << FMC_BTR2_DATLAT_Pos)               /*!< 0x0F000000 */
#define FMC_BTR2_DATLAT            FMC_BTR2_DATLAT_Msk                         /*!<DATLA[3:0] bits (Data latency) */
#define FMC_BTR2_DATLAT_0          (0x1U << FMC_BTR2_DATLAT_Pos)               /*!< 0x01000000 */
#define FMC_BTR2_DATLAT_1          (0x2U << FMC_BTR2_DATLAT_Pos)               /*!< 0x02000000 */
#define FMC_BTR2_DATLAT_2          (0x4U << FMC_BTR2_DATLAT_Pos)               /*!< 0x04000000 */
#define FMC_BTR2_DATLAT_3          (0x8U << FMC_BTR2_DATLAT_Pos)               /*!< 0x08000000 */

#define FMC_BTR2_ACCMOD_Pos        (28U)
#define FMC_BTR2_ACCMOD_Msk        (0x3U << FMC_BTR2_ACCMOD_Pos)               /*!< 0x30000000 */
#define FMC_BTR2_ACCMOD            FMC_BTR2_ACCMOD_Msk                         /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BTR2_ACCMOD_0          (0x1U << FMC_BTR2_ACCMOD_Pos)               /*!< 0x10000000 */
#define FMC_BTR2_ACCMOD_1          (0x2U << FMC_BTR2_ACCMOD_Pos)               /*!< 0x20000000 */

/*******************  Bit definition for FMC_BTR3 register  *******************/
#define FMC_BTR3_ADDSET_Pos        (0U)
#define FMC_BTR3_ADDSET_Msk        (0xFU << FMC_BTR3_ADDSET_Pos)               /*!< 0x0000000F */
#define FMC_BTR3_ADDSET            FMC_BTR3_ADDSET_Msk                         /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BTR3_ADDSET_0          (0x1U << FMC_BTR3_ADDSET_Pos)               /*!< 0x00000001 */
#define FMC_BTR3_ADDSET_1          (0x2U << FMC_BTR3_ADDSET_Pos)               /*!< 0x00000002 */
#define FMC_BTR3_ADDSET_2          (0x4U << FMC_BTR3_ADDSET_Pos)               /*!< 0x00000004 */
#define FMC_BTR3_ADDSET_3          (0x8U << FMC_BTR3_ADDSET_Pos)               /*!< 0x00000008 */

#define FMC_BTR3_ADDHLD_Pos        (4U)
#define FMC_BTR3_ADDHLD_Msk        (0xFU << FMC_BTR3_ADDHLD_Pos)               /*!< 0x000000F0 */
#define FMC_BTR3_ADDHLD            FMC_BTR3_ADDHLD_Msk                         /*!<ADDHLD[3:0] bits (Address-hold phase duration) */
#define FMC_BTR3_ADDHLD_0          (0x1U << FMC_BTR3_ADDHLD_Pos)               /*!< 0x00000010 */
#define FMC_BTR3_ADDHLD_1          (0x2U << FMC_BTR3_ADDHLD_Pos)               /*!< 0x00000020 */
#define FMC_BTR3_ADDHLD_2          (0x4U << FMC_BTR3_ADDHLD_Pos)               /*!< 0x00000040 */
#define FMC_BTR3_ADDHLD_3          (0x8U << FMC_BTR3_ADDHLD_Pos)               /*!< 0x00000080 */

#define FMC_BTR3_DATAST_Pos        (8U)
#define FMC_BTR3_DATAST_Msk        (0xFFU << FMC_BTR3_DATAST_Pos)              /*!< 0x0000FF00 */
#define FMC_BTR3_DATAST            FMC_BTR3_DATAST_Msk                         /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BTR3_DATAST_0          (0x01U << FMC_BTR3_DATAST_Pos)              /*!< 0x00000100 */
#define FMC_BTR3_DATAST_1          (0x02U << FMC_BTR3_DATAST_Pos)              /*!< 0x00000200 */
#define FMC_BTR3_DATAST_2          (0x04U << FMC_BTR3_DATAST_Pos)              /*!< 0x00000400 */
#define FMC_BTR3_DATAST_3          (0x08U << FMC_BTR3_DATAST_Pos)              /*!< 0x00000800 */
#define FMC_BTR3_DATAST_4          (0x10U << FMC_BTR3_DATAST_Pos)              /*!< 0x00001000 */
#define FMC_BTR3_DATAST_5          (0x20U << FMC_BTR3_DATAST_Pos)              /*!< 0x00002000 */
#define FMC_BTR3_DATAST_6          (0x40U << FMC_BTR3_DATAST_Pos)              /*!< 0x00004000 */
#define FMC_BTR3_DATAST_7          (0x80U << FMC_BTR3_DATAST_Pos)              /*!< 0x00008000 */

#define FMC_BTR3_BUSTURN_Pos       (16U)
#define FMC_BTR3_BUSTURN_Msk       (0xFU << FMC_BTR3_BUSTURN_Pos)              /*!< 0x000F0000 */
#define FMC_BTR3_BUSTURN           FMC_BTR3_BUSTURN_Msk                        /*!<BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FMC_BTR3_BUSTURN_0         (0x1U << FMC_BTR3_BUSTURN_Pos)              /*!< 0x00010000 */
#define FMC_BTR3_BUSTURN_1         (0x2U << FMC_BTR3_BUSTURN_Pos)              /*!< 0x00020000 */
#define FMC_BTR3_BUSTURN_2         (0x4U << FMC_BTR3_BUSTURN_Pos)              /*!< 0x00040000 */
#define FMC_BTR3_BUSTURN_3         (0x8U << FMC_BTR3_BUSTURN_Pos)              /*!< 0x00080000 */

#define FMC_BTR3_CLKDIV_Pos        (20U)
#define FMC_BTR3_CLKDIV_Msk        (0xFU << FMC_BTR3_CLKDIV_Pos)               /*!< 0x00F00000 */
#define FMC_BTR3_CLKDIV            FMC_BTR3_CLKDIV_Msk                         /*!<CLKDIV[3:0] bits (Clock divide ratio) */
#define FMC_BTR3_CLKDIV_0          (0x1U << FMC_BTR3_CLKDIV_Pos)               /*!< 0x00100000 */
#define FMC_BTR3_CLKDIV_1          (0x2U << FMC_BTR3_CLKDIV_Pos)               /*!< 0x00200000 */
#define FMC_BTR3_CLKDIV_2          (0x4U << FMC_BTR3_CLKDIV_Pos)               /*!< 0x00400000 */
#define FMC_BTR3_CLKDIV_3          (0x8U << FMC_BTR3_CLKDIV_Pos)               /*!< 0x00800000 */

#define FMC_BTR3_DATLAT_Pos        (24U)
#define FMC_BTR3_DATLAT_Msk        (0xFU << FMC_BTR3_DATLAT_Pos)               /*!< 0x0F000000 */
#define FMC_BTR3_DATLAT            FMC_BTR3_DATLAT_Msk                         /*!<DATLA[3:0] bits (Data latency) */
#define FMC_BTR3_DATLAT_0          (0x1U << FMC_BTR3_DATLAT_Pos)               /*!< 0x01000000 */
#define FMC_BTR3_DATLAT_1          (0x2U << FMC_BTR3_DATLAT_Pos)               /*!< 0x02000000 */
#define FMC_BTR3_DATLAT_2          (0x4U << FMC_BTR3_DATLAT_Pos)               /*!< 0x04000000 */
#define FMC_BTR3_DATLAT_3          (0x8U << FMC_BTR3_DATLAT_Pos)               /*!< 0x08000000 */

#define FMC_BTR3_ACCMOD_Pos        (28U)
#define FMC_BTR3_ACCMOD_Msk        (0x3U << FMC_BTR3_ACCMOD_Pos)               /*!< 0x30000000 */
#define FMC_BTR3_ACCMOD            FMC_BTR3_ACCMOD_Msk                         /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BTR3_ACCMOD_0          (0x1U << FMC_BTR3_ACCMOD_Pos)               /*!< 0x10000000 */
#define FMC_BTR3_ACCMOD_1          (0x2U << FMC_BTR3_ACCMOD_Pos)               /*!< 0x20000000 */

/******************  Bit definition for FMC_BTR4 register  *******************/
#define FMC_BTR4_ADDSET_Pos        (0U)
#define FMC_BTR4_ADDSET_Msk        (0xFU << FMC_BTR4_ADDSET_Pos)               /*!< 0x0000000F */
#define FMC_BTR4_ADDSET            FMC_BTR4_ADDSET_Msk                         /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BTR4_ADDSET_0          (0x1U << FMC_BTR4_ADDSET_Pos)               /*!< 0x00000001 */
#define FMC_BTR4_ADDSET_1          (0x2U << FMC_BTR4_ADDSET_Pos)               /*!< 0x00000002 */
#define FMC_BTR4_ADDSET_2          (0x4U << FMC_BTR4_ADDSET_Pos)               /*!< 0x00000004 */
#define FMC_BTR4_ADDSET_3          (0x8U << FMC_BTR4_ADDSET_Pos)               /*!< 0x00000008 */

#define FMC_BTR4_ADDHLD_Pos        (4U)
#define FMC_BTR4_ADDHLD_Msk        (0xFU << FMC_BTR4_ADDHLD_Pos)               /*!< 0x000000F0 */
#define FMC_BTR4_ADDHLD            FMC_BTR4_ADDHLD_Msk                         /*!<ADDHLD[3:0] bits (Address-hold phase duration) */
#define FMC_BTR4_ADDHLD_0          (0x1U << FMC_BTR4_ADDHLD_Pos)               /*!< 0x00000010 */
#define FMC_BTR4_ADDHLD_1          (0x2U << FMC_BTR4_ADDHLD_Pos)               /*!< 0x00000020 */
#define FMC_BTR4_ADDHLD_2          (0x4U << FMC_BTR4_ADDHLD_Pos)               /*!< 0x00000040 */
#define FMC_BTR4_ADDHLD_3          (0x8U << FMC_BTR4_ADDHLD_Pos)               /*!< 0x00000080 */

#define FMC_BTR4_DATAST_Pos        (8U)
#define FMC_BTR4_DATAST_Msk        (0xFFU << FMC_BTR4_DATAST_Pos)              /*!< 0x0000FF00 */
#define FMC_BTR4_DATAST            FMC_BTR4_DATAST_Msk                         /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BTR4_DATAST_0          (0x01U << FMC_BTR4_DATAST_Pos)              /*!< 0x00000100 */
#define FMC_BTR4_DATAST_1          (0x02U << FMC_BTR4_DATAST_Pos)              /*!< 0x00000200 */
#define FMC_BTR4_DATAST_2          (0x04U << FMC_BTR4_DATAST_Pos)              /*!< 0x00000400 */
#define FMC_BTR4_DATAST_3          (0x08U << FMC_BTR4_DATAST_Pos)              /*!< 0x00000800 */
#define FMC_BTR4_DATAST_4          (0x10U << FMC_BTR4_DATAST_Pos)              /*!< 0x00001000 */
#define FMC_BTR4_DATAST_5          (0x20U << FMC_BTR4_DATAST_Pos)              /*!< 0x00002000 */
#define FMC_BTR4_DATAST_6          (0x40U << FMC_BTR4_DATAST_Pos)              /*!< 0x00004000 */
#define FMC_BTR4_DATAST_7          (0x80U << FMC_BTR4_DATAST_Pos)              /*!< 0x00008000 */

#define FMC_BTR4_BUSTURN_Pos       (16U)
#define FMC_BTR4_BUSTURN_Msk       (0xFU << FMC_BTR4_BUSTURN_Pos)              /*!< 0x000F0000 */
#define FMC_BTR4_BUSTURN           FMC_BTR4_BUSTURN_Msk                        /*!<BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FMC_BTR4_BUSTURN_0         (0x1U << FMC_BTR4_BUSTURN_Pos)              /*!< 0x00010000 */
#define FMC_BTR4_BUSTURN_1         (0x2U << FMC_BTR4_BUSTURN_Pos)              /*!< 0x00020000 */
#define FMC_BTR4_BUSTURN_2         (0x4U << FMC_BTR4_BUSTURN_Pos)              /*!< 0x00040000 */
#define FMC_BTR4_BUSTURN_3         (0x8U << FMC_BTR4_BUSTURN_Pos)              /*!< 0x00080000 */

#define FMC_BTR4_CLKDIV_Pos        (20U)
#define FMC_BTR4_CLKDIV_Msk        (0xFU << FMC_BTR4_CLKDIV_Pos)               /*!< 0x00F00000 */
#define FMC_BTR4_CLKDIV            FMC_BTR4_CLKDIV_Msk                         /*!<CLKDIV[3:0] bits (Clock divide ratio) */
#define FMC_BTR4_CLKDIV_0          (0x1U << FMC_BTR4_CLKDIV_Pos)               /*!< 0x00100000 */
#define FMC_BTR4_CLKDIV_1          (0x2U << FMC_BTR4_CLKDIV_Pos)               /*!< 0x00200000 */
#define FMC_BTR4_CLKDIV_2          (0x4U << FMC_BTR4_CLKDIV_Pos)               /*!< 0x00400000 */
#define FMC_BTR4_CLKDIV_3          (0x8U << FMC_BTR4_CLKDIV_Pos)               /*!< 0x00800000 */

#define FMC_BTR4_DATLAT_Pos        (24U)
#define FMC_BTR4_DATLAT_Msk        (0xFU << FMC_BTR4_DATLAT_Pos)               /*!< 0x0F000000 */
#define FMC_BTR4_DATLAT            FMC_BTR4_DATLAT_Msk                         /*!<DATLA[3:0] bits (Data latency) */
#define FMC_BTR4_DATLAT_0          (0x1U << FMC_BTR4_DATLAT_Pos)               /*!< 0x01000000 */
#define FMC_BTR4_DATLAT_1          (0x2U << FMC_BTR4_DATLAT_Pos)               /*!< 0x02000000 */
#define FMC_BTR4_DATLAT_2          (0x4U << FMC_BTR4_DATLAT_Pos)               /*!< 0x04000000 */
#define FMC_BTR4_DATLAT_3          (0x8U << FMC_BTR4_DATLAT_Pos)               /*!< 0x08000000 */

#define FMC_BTR4_ACCMOD_Pos        (28U)
#define FMC_BTR4_ACCMOD_Msk        (0x3U << FMC_BTR4_ACCMOD_Pos)               /*!< 0x30000000 */
#define FMC_BTR4_ACCMOD            FMC_BTR4_ACCMOD_Msk                         /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BTR4_ACCMOD_0          (0x1U << FMC_BTR4_ACCMOD_Pos)               /*!< 0x10000000 */
#define FMC_BTR4_ACCMOD_1          (0x2U << FMC_BTR4_ACCMOD_Pos)               /*!< 0x20000000 */

/******************  Bit definition for FMC_BWTR1 register  ******************/
#define FMC_BWTR1_ADDSET_Pos       (0U)
#define FMC_BWTR1_ADDSET_Msk       (0xFU << FMC_BWTR1_ADDSET_Pos)              /*!< 0x0000000F */
#define FMC_BWTR1_ADDSET           FMC_BWTR1_ADDSET_Msk                        /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BWTR1_ADDSET_0         (0x1U << FMC_BWTR1_ADDSET_Pos)              /*!< 0x00000001 */
#define FMC_BWTR1_ADDSET_1         (0x2U << FMC_BWTR1_ADDSET_Pos)              /*!< 0x00000002 */
#define FMC_BWTR1_ADDSET_2         (0x4U << FMC_BWTR1_ADDSET_Pos)              /*!< 0x00000004 */
#define FMC_BWTR1_ADDSET_3         (0x8U << FMC_BWTR1_ADDSET_Pos)              /*!< 0x00000008 */

#define FMC_BWTR1_ADDHLD_Pos       (4U)
#define FMC_BWTR1_ADDHLD_Msk       (0xFU << FMC_BWTR1_ADDHLD_Pos)              /*!< 0x000000F0 */
#define FMC_BWTR1_ADDHLD           FMC_BWTR1_ADDHLD_Msk                        /*!<ADDHLD[3:0] bits (Address-hold phase duration) */
#define FMC_BWTR1_ADDHLD_0         (0x1U << FMC_BWTR1_ADDHLD_Pos)              /*!< 0x00000010 */
#define FMC_BWTR1_ADDHLD_1         (0x2U << FMC_BWTR1_ADDHLD_Pos)              /*!< 0x00000020 */
#define FMC_BWTR1_ADDHLD_2         (0x4U << FMC_BWTR1_ADDHLD_Pos)              /*!< 0x00000040 */
#define FMC_BWTR1_ADDHLD_3         (0x8U << FMC_BWTR1_ADDHLD_Pos)              /*!< 0x00000080 */

#define FMC_BWTR1_DATAST_Pos       (8U)
#define FMC_BWTR1_DATAST_Msk       (0xFFU << FMC_BWTR1_DATAST_Pos)             /*!< 0x0000FF00 */
#define FMC_BWTR1_DATAST           FMC_BWTR1_DATAST_Msk                        /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BWTR1_DATAST_0         (0x01U << FMC_BWTR1_DATAST_Pos)             /*!< 0x00000100 */
#define FMC_BWTR1_DATAST_1         (0x02U << FMC_BWTR1_DATAST_Pos)             /*!< 0x00000200 */
#define FMC_BWTR1_DATAST_2         (0x04U << FMC_BWTR1_DATAST_Pos)             /*!< 0x00000400 */
#define FMC_BWTR1_DATAST_3         (0x08U << FMC_BWTR1_DATAST_Pos)             /*!< 0x00000800 */
#define FMC_BWTR1_DATAST_4         (0x10U << FMC_BWTR1_DATAST_Pos)             /*!< 0x00001000 */
#define FMC_BWTR1_DATAST_5         (0x20U << FMC_BWTR1_DATAST_Pos)             /*!< 0x00002000 */
#define FMC_BWTR1_DATAST_6         (0x40U << FMC_BWTR1_DATAST_Pos)             /*!< 0x00004000 */
#define FMC_BWTR1_DATAST_7         (0x80U << FMC_BWTR1_DATAST_Pos)             /*!< 0x00008000 */

#define FMC_BWTR1_CLKDIV_Pos       (20U)
#define FMC_BWTR1_CLKDIV_Msk       (0xFU << FMC_BWTR1_CLKDIV_Pos)              /*!< 0x00F00000 */
#define FMC_BWTR1_CLKDIV           FMC_BWTR1_CLKDIV_Msk                        /*!<CLKDIV[3:0] bits (Clock divide ratio) */
#define FMC_BWTR1_CLKDIV_0         (0x1U << FMC_BWTR1_CLKDIV_Pos)              /*!< 0x00100000 */
#define FMC_BWTR1_CLKDIV_1         (0x2U << FMC_BWTR1_CLKDIV_Pos)              /*!< 0x00200000 */
#define FMC_BWTR1_CLKDIV_2         (0x4U << FMC_BWTR1_CLKDIV_Pos)              /*!< 0x00400000 */
#define FMC_BWTR1_CLKDIV_3         (0x8U << FMC_BWTR1_CLKDIV_Pos)              /*!< 0x00800000 */

#define FMC_BWTR1_DATLAT_Pos       (24U)
#define FMC_BWTR1_DATLAT_Msk       (0xFU << FMC_BWTR1_DATLAT_Pos)              /*!< 0x0F000000 */
#define FMC_BWTR1_DATLAT           FMC_BWTR1_DATLAT_Msk                        /*!<DATLA[3:0] bits (Data latency) */
#define FMC_BWTR1_DATLAT_0         (0x1U << FMC_BWTR1_DATLAT_Pos)              /*!< 0x01000000 */
#define FMC_BWTR1_DATLAT_1         (0x2U << FMC_BWTR1_DATLAT_Pos)              /*!< 0x02000000 */
#define FMC_BWTR1_DATLAT_2         (0x4U << FMC_BWTR1_DATLAT_Pos)              /*!< 0x04000000 */
#define FMC_BWTR1_DATLAT_3         (0x8U << FMC_BWTR1_DATLAT_Pos)              /*!< 0x08000000 */

#define FMC_BWTR1_BUSTURN_Pos      (16U)
#define FMC_BWTR1_BUSTURN_Msk      (0xFU << FMC_BWTR1_BUSTURN_Pos)             /*!< 0x000F0000 */
#define FMC_BWTR1_BUSTURN          FMC_BWTR1_BUSTURN_Msk                       /*!<BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FMC_BWTR1_BUSTURN_0        (0x1U << FMC_BWTR1_BUSTURN_Pos)             /*!< 0x00010000 */
#define FMC_BWTR1_BUSTURN_1        (0x2U << FMC_BWTR1_BUSTURN_Pos)             /*!< 0x00020000 */
#define FMC_BWTR1_BUSTURN_2        (0x4U << FMC_BWTR1_BUSTURN_Pos)             /*!< 0x00040000 */
#define FMC_BWTR1_BUSTURN_3        (0x8U << FMC_BWTR1_BUSTURN_Pos)             /*!< 0x00080000 */


#define FMC_BWTR1_ACCMOD_Pos       (28U)
#define FMC_BWTR1_ACCMOD_Msk       (0x3U << FMC_BWTR1_ACCMOD_Pos)              /*!< 0x30000000 */
#define FMC_BWTR1_ACCMOD           FMC_BWTR1_ACCMOD_Msk                        /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BWTR1_ACCMOD_0         (0x1U << FMC_BWTR1_ACCMOD_Pos)              /*!< 0x10000000 */
#define FMC_BWTR1_ACCMOD_1         (0x2U << FMC_BWTR1_ACCMOD_Pos)              /*!< 0x20000000 */

/******************  Bit definition for FMC_BWTR2 register  ******************/
#define FMC_BWTR2_ADDSET_Pos       (0U)
#define FMC_BWTR2_ADDSET_Msk       (0xFU << FMC_BWTR2_ADDSET_Pos)              /*!< 0x0000000F */
#define FMC_BWTR2_ADDSET           FMC_BWTR2_ADDSET_Msk                        /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BWTR2_ADDSET_0         (0x1U << FMC_BWTR2_ADDSET_Pos)              /*!< 0x00000001 */
#define FMC_BWTR2_ADDSET_1         (0x2U << FMC_BWTR2_ADDSET_Pos)              /*!< 0x00000002 */
#define FMC_BWTR2_ADDSET_2         (0x4U << FMC_BWTR2_ADDSET_Pos)              /*!< 0x00000004 */
#define FMC_BWTR2_ADDSET_3         (0x8U << FMC_BWTR2_ADDSET_Pos)              /*!< 0x00000008 */

#define FMC_BWTR2_ADDHLD_Pos       (4U)
#define FMC_BWTR2_ADDHLD_Msk       (0xFU << FMC_BWTR2_ADDHLD_Pos)              /*!< 0x000000F0 */
#define FMC_BWTR2_ADDHLD           FMC_BWTR2_ADDHLD_Msk                        /*!<ADDHLD[3:0] bits (Address-hold phase duration) */
#define FMC_BWTR2_ADDHLD_0         (0x1U << FMC_BWTR2_ADDHLD_Pos)              /*!< 0x00000010 */
#define FMC_BWTR2_ADDHLD_1         (0x2U << FMC_BWTR2_ADDHLD_Pos)              /*!< 0x00000020 */
#define FMC_BWTR2_ADDHLD_2         (0x4U << FMC_BWTR2_ADDHLD_Pos)              /*!< 0x00000040 */
#define FMC_BWTR2_ADDHLD_3         (0x8U << FMC_BWTR2_ADDHLD_Pos)              /*!< 0x00000080 */

#define FMC_BWTR2_DATAST_Pos       (8U)
#define FMC_BWTR2_DATAST_Msk       (0xFFU << FMC_BWTR2_DATAST_Pos)             /*!< 0x0000FF00 */
#define FMC_BWTR2_DATAST           FMC_BWTR2_DATAST_Msk                        /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BWTR2_DATAST_0         (0x01U << FMC_BWTR2_DATAST_Pos)             /*!< 0x00000100 */
#define FMC_BWTR2_DATAST_1         (0x02U << FMC_BWTR2_DATAST_Pos)             /*!< 0x00000200 */
#define FMC_BWTR2_DATAST_2         (0x04U << FMC_BWTR2_DATAST_Pos)             /*!< 0x00000400 */
#define FMC_BWTR2_DATAST_3         (0x08U << FMC_BWTR2_DATAST_Pos)             /*!< 0x00000800 */
#define FMC_BWTR2_DATAST_4         (0x10U << FMC_BWTR2_DATAST_Pos)             /*!< 0x00001000 */
#define FMC_BWTR2_DATAST_5         (0x20U << FMC_BWTR2_DATAST_Pos)             /*!< 0x00002000 */
#define FMC_BWTR2_DATAST_6         (0x40U << FMC_BWTR2_DATAST_Pos)             /*!< 0x00004000 */
#define FMC_BWTR2_DATAST_7         (0x80U << FMC_BWTR2_DATAST_Pos)             /*!< 0x00008000 */

#define FMC_BWTR2_CLKDIV_Pos       (20U)
#define FMC_BWTR2_CLKDIV_Msk       (0xFU << FMC_BWTR2_CLKDIV_Pos)              /*!< 0x00F00000 */
#define FMC_BWTR2_CLKDIV           FMC_BWTR2_CLKDIV_Msk                        /*!<CLKDIV[3:0] bits (Clock divide ratio) */
#define FMC_BWTR2_CLKDIV_0         (0x1U << FMC_BWTR2_CLKDIV_Pos)              /*!< 0x00100000 */
#define FMC_BWTR2_CLKDIV_1         (0x2U << FMC_BWTR2_CLKDIV_Pos)              /*!< 0x00200000 */
#define FMC_BWTR2_CLKDIV_2         (0x4U << FMC_BWTR2_CLKDIV_Pos)              /*!< 0x00400000 */
#define FMC_BWTR2_CLKDIV_3         (0x8U << FMC_BWTR2_CLKDIV_Pos)              /*!< 0x00800000 */

#define FMC_BWTR2_DATLAT_Pos       (24U)
#define FMC_BWTR2_DATLAT_Msk       (0xFU << FMC_BWTR2_DATLAT_Pos)              /*!< 0x0F000000 */
#define FMC_BWTR2_DATLAT           FMC_BWTR2_DATLAT_Msk                        /*!<DATLA[3:0] bits (Data latency) */
#define FMC_BWTR2_DATLAT_0         (0x1U << FMC_BWTR2_DATLAT_Pos)              /*!< 0x01000000 */
#define FMC_BWTR2_DATLAT_1         (0x2U << FMC_BWTR2_DATLAT_Pos)              /*!< 0x02000000 */
#define FMC_BWTR2_DATLAT_2         (0x4U << FMC_BWTR2_DATLAT_Pos)              /*!< 0x04000000 */
#define FMC_BWTR2_DATLAT_3         (0x8U << FMC_BWTR2_DATLAT_Pos)              /*!< 0x08000000 */

#define FMC_BWTR2_ACCMOD_Pos       (28U)
#define FMC_BWTR2_ACCMOD_Msk       (0x3U << FMC_BWTR2_ACCMOD_Pos)              /*!< 0x30000000 */
#define FMC_BWTR2_ACCMOD           FMC_BWTR2_ACCMOD_Msk                        /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BWTR2_ACCMOD_0         (0x1U << FMC_BWTR2_ACCMOD_Pos)              /*!< 0x10000000 */
#define FMC_BWTR2_ACCMOD_1         (0x2U << FMC_BWTR2_ACCMOD_Pos)              /*!< 0x20000000 */

/******************  Bit definition for FMC_BWTR3 register  ******************/
#define FMC_BWTR3_ADDSET_Pos       (0U)
#define FMC_BWTR3_ADDSET_Msk       (0xFU << FMC_BWTR3_ADDSET_Pos)              /*!< 0x0000000F */
#define FMC_BWTR3_ADDSET           FMC_BWTR3_ADDSET_Msk                        /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BWTR3_ADDSET_0         (0x1U << FMC_BWTR3_ADDSET_Pos)              /*!< 0x00000001 */
#define FMC_BWTR3_ADDSET_1         (0x2U << FMC_BWTR3_ADDSET_Pos)              /*!< 0x00000002 */
#define FMC_BWTR3_ADDSET_2         (0x4U << FMC_BWTR3_ADDSET_Pos)              /*!< 0x00000004 */
#define FMC_BWTR3_ADDSET_3         (0x8U << FMC_BWTR3_ADDSET_Pos)              /*!< 0x00000008 */

#define FMC_BWTR3_ADDHLD_Pos       (4U)
#define FMC_BWTR3_ADDHLD_Msk       (0xFU << FMC_BWTR3_ADDHLD_Pos)              /*!< 0x000000F0 */
#define FMC_BWTR3_ADDHLD           FMC_BWTR3_ADDHLD_Msk                        /*!<ADDHLD[3:0] bits (Address-hold phase duration) */
#define FMC_BWTR3_ADDHLD_0         (0x1U << FMC_BWTR3_ADDHLD_Pos)              /*!< 0x00000010 */
#define FMC_BWTR3_ADDHLD_1         (0x2U << FMC_BWTR3_ADDHLD_Pos)              /*!< 0x00000020 */
#define FMC_BWTR3_ADDHLD_2         (0x4U << FMC_BWTR3_ADDHLD_Pos)              /*!< 0x00000040 */
#define FMC_BWTR3_ADDHLD_3         (0x8U << FMC_BWTR3_ADDHLD_Pos)              /*!< 0x00000080 */

#define FMC_BWTR3_DATAST_Pos       (8U)
#define FMC_BWTR3_DATAST_Msk       (0xFFU << FMC_BWTR3_DATAST_Pos)             /*!< 0x0000FF00 */
#define FMC_BWTR3_DATAST           FMC_BWTR3_DATAST_Msk                        /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BWTR3_DATAST_0         (0x01U << FMC_BWTR3_DATAST_Pos)             /*!< 0x00000100 */
#define FMC_BWTR3_DATAST_1         (0x02U << FMC_BWTR3_DATAST_Pos)             /*!< 0x00000200 */
#define FMC_BWTR3_DATAST_2         (0x04U << FMC_BWTR3_DATAST_Pos)             /*!< 0x00000400 */
#define FMC_BWTR3_DATAST_3         (0x08U << FMC_BWTR3_DATAST_Pos)             /*!< 0x00000800 */
#define FMC_BWTR3_DATAST_4         (0x10U << FMC_BWTR3_DATAST_Pos)             /*!< 0x00001000 */
#define FMC_BWTR3_DATAST_5         (0x20U << FMC_BWTR3_DATAST_Pos)             /*!< 0x00002000 */
#define FMC_BWTR3_DATAST_6         (0x40U << FMC_BWTR3_DATAST_Pos)             /*!< 0x00004000 */
#define FMC_BWTR3_DATAST_7         (0x80U << FMC_BWTR3_DATAST_Pos)             /*!< 0x00008000 */

#define FMC_BWTR3_CLKDIV_Pos       (20U)
#define FMC_BWTR3_CLKDIV_Msk       (0xFU << FMC_BWTR3_CLKDIV_Pos)              /*!< 0x00F00000 */
#define FMC_BWTR3_CLKDIV           FMC_BWTR3_CLKDIV_Msk                        /*!<CLKDIV[3:0] bits (Clock divide ratio) */
#define FMC_BWTR3_CLKDIV_0         (0x1U << FMC_BWTR3_CLKDIV_Pos)              /*!< 0x00100000 */
#define FMC_BWTR3_CLKDIV_1         (0x2U << FMC_BWTR3_CLKDIV_Pos)              /*!< 0x00200000 */
#define FMC_BWTR3_CLKDIV_2         (0x4U << FMC_BWTR3_CLKDIV_Pos)              /*!< 0x00400000 */
#define FMC_BWTR3_CLKDIV_3         (0x8U << FMC_BWTR3_CLKDIV_Pos)              /*!< 0x00800000 */

#define FMC_BWTR3_DATLAT_Pos       (24U)
#define FMC_BWTR3_DATLAT_Msk       (0xFU << FMC_BWTR3_DATLAT_Pos)              /*!< 0x0F000000 */
#define FMC_BWTR3_DATLAT           FMC_BWTR3_DATLAT_Msk                        /*!<DATLA[3:0] bits (Data latency) */
#define FMC_BWTR3_DATLAT_0         (0x1U << FMC_BWTR3_DATLAT_Pos)              /*!< 0x01000000 */
#define FMC_BWTR3_DATLAT_1         (0x2U << FMC_BWTR3_DATLAT_Pos)              /*!< 0x02000000 */
#define FMC_BWTR3_DATLAT_2         (0x4U << FMC_BWTR3_DATLAT_Pos)              /*!< 0x04000000 */
#define FMC_BWTR3_DATLAT_3         (0x8U << FMC_BWTR3_DATLAT_Pos)              /*!< 0x08000000 */

#define FMC_BWTR3_ACCMOD_Pos       (28U)
#define FMC_BWTR3_ACCMOD_Msk       (0x3U << FMC_BWTR3_ACCMOD_Pos)              /*!< 0x30000000 */
#define FMC_BWTR3_ACCMOD           FMC_BWTR3_ACCMOD_Msk                        /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BWTR3_ACCMOD_0         (0x1U << FMC_BWTR3_ACCMOD_Pos)              /*!< 0x10000000 */
#define FMC_BWTR3_ACCMOD_1         (0x2U << FMC_BWTR3_ACCMOD_Pos)              /*!< 0x20000000 */

/******************  Bit definition for FMC_BWTR4 register  ******************/
#define FMC_BWTR4_ADDSET_Pos       (0U)
#define FMC_BWTR4_ADDSET_Msk       (0xFU << FMC_BWTR4_ADDSET_Pos)              /*!< 0x0000000F */
#define FMC_BWTR4_ADDSET           FMC_BWTR4_ADDSET_Msk                        /*!<ADDSET[3:0] bits (Address setup phase duration) */
#define FMC_BWTR4_ADDSET_0         (0x1U << FMC_BWTR4_ADDSET_Pos)              /*!< 0x00000001 */
#define FMC_BWTR4_ADDSET_1         (0x2U << FMC_BWTR4_ADDSET_Pos)              /*!< 0x00000002 */
#define FMC_BWTR4_ADDSET_2         (0x4U << FMC_BWTR4_ADDSET_Pos)              /*!< 0x00000004 */
#define FMC_BWTR4_ADDSET_3         (0x8U << FMC_BWTR4_ADDSET_Pos)              /*!< 0x00000008 */

#define FMC_BWTR4_ADDHLD_Pos       (4U)
#define FMC_BWTR4_ADDHLD_Msk       (0xFU << FMC_BWTR4_ADDHLD_Pos)              /*!< 0x000000F0 */
#define FMC_BWTR4_ADDHLD           FMC_BWTR4_ADDHLD_Msk                        /*!<ADDHLD[3:0] bits (Address-hold phase duration) */
#define FMC_BWTR4_ADDHLD_0         (0x1U << FMC_BWTR4_ADDHLD_Pos)              /*!< 0x00000010 */
#define FMC_BWTR4_ADDHLD_1         (0x2U << FMC_BWTR4_ADDHLD_Pos)              /*!< 0x00000020 */
#define FMC_BWTR4_ADDHLD_2         (0x4U << FMC_BWTR4_ADDHLD_Pos)              /*!< 0x00000040 */
#define FMC_BWTR4_ADDHLD_3         (0x8U << FMC_BWTR4_ADDHLD_Pos)              /*!< 0x00000080 */

#define FMC_BWTR4_DATAST_Pos       (8U)
#define FMC_BWTR4_DATAST_Msk       (0xFFU << FMC_BWTR4_DATAST_Pos)             /*!< 0x0000FF00 */
#define FMC_BWTR4_DATAST           FMC_BWTR4_DATAST_Msk                        /*!<DATAST [3:0] bits (Data-phase duration) */
#define FMC_BWTR4_DATAST_0         (0x01U << FMC_BWTR4_DATAST_Pos)             /*!< 0x00000100 */
#define FMC_BWTR4_DATAST_1         (0x02U << FMC_BWTR4_DATAST_Pos)             /*!< 0x00000200 */
#define FMC_BWTR4_DATAST_2         (0x04U << FMC_BWTR4_DATAST_Pos)             /*!< 0x00000400 */
#define FMC_BWTR4_DATAST_3         (0x08U << FMC_BWTR4_DATAST_Pos)             /*!< 0x00000800 */
#define FMC_BWTR4_DATAST_4         (0x10U << FMC_BWTR4_DATAST_Pos)             /*!< 0x00001000 */
#define FMC_BWTR4_DATAST_5         (0x20U << FMC_BWTR4_DATAST_Pos)             /*!< 0x00002000 */
#define FMC_BWTR4_DATAST_6         (0x40U << FMC_BWTR4_DATAST_Pos)             /*!< 0x00004000 */
#define FMC_BWTR4_DATAST_7         (0x80U << FMC_BWTR4_DATAST_Pos)             /*!< 0x00008000 */

#define FMC_BWTR4_CLKDIV_Pos       (20U)
#define FMC_BWTR4_CLKDIV_Msk       (0xFU << FMC_BWTR4_CLKDIV_Pos)              /*!< 0x00F00000 */
#define FMC_BWTR4_CLKDIV           FMC_BWTR4_CLKDIV_Msk                        /*!<CLKDIV[3:0] bits (Clock divide ratio) */
#define FMC_BWTR4_CLKDIV_0         (0x1U << FMC_BWTR4_CLKDIV_Pos)              /*!< 0x00100000 */
#define FMC_BWTR4_CLKDIV_1         (0x2U << FMC_BWTR4_CLKDIV_Pos)              /*!< 0x00200000 */
#define FMC_BWTR4_CLKDIV_2         (0x4U << FMC_BWTR4_CLKDIV_Pos)              /*!< 0x00400000 */
#define FMC_BWTR4_CLKDIV_3         (0x8U << FMC_BWTR4_CLKDIV_Pos)              /*!< 0x00800000 */

#define FMC_BWTR4_DATLAT_Pos       (24U)
#define FMC_BWTR4_DATLAT_Msk       (0xFU << FMC_BWTR4_DATLAT_Pos)              /*!< 0x0F000000 */
#define FMC_BWTR4_DATLAT           FMC_BWTR4_DATLAT_Msk                        /*!<DATLA[3:0] bits (Data latency) */
#define FMC_BWTR4_DATLAT_0         (0x1U << FMC_BWTR4_DATLAT_Pos)              /*!< 0x01000000 */
#define FMC_BWTR4_DATLAT_1         (0x2U << FMC_BWTR4_DATLAT_Pos)              /*!< 0x02000000 */
#define FMC_BWTR4_DATLAT_2         (0x4U << FMC_BWTR4_DATLAT_Pos)              /*!< 0x04000000 */
#define FMC_BWTR4_DATLAT_3         (0x8U << FMC_BWTR4_DATLAT_Pos)              /*!< 0x08000000 */

#define FMC_BWTR4_ACCMOD_Pos       (28U)
#define FMC_BWTR4_ACCMOD_Msk       (0x3U << FMC_BWTR4_ACCMOD_Pos)              /*!< 0x30000000 */
#define FMC_BWTR4_ACCMOD           FMC_BWTR4_ACCMOD_Msk                        /*!<ACCMOD[1:0] bits (Access mode) */
#define FMC_BWTR4_ACCMOD_0         (0x1U << FMC_BWTR4_ACCMOD_Pos)              /*!< 0x10000000 */
#define FMC_BWTR4_ACCMOD_1         (0x2U << FMC_BWTR4_ACCMOD_Pos)              /*!< 0x20000000 */

/******************  Bit definition for FMC_PCR register  *******************/
#define FMC_PCR_PWAITEN_Pos        (1U)
#define FMC_PCR_PWAITEN_Msk        (0x1U << FMC_PCR_PWAITEN_Pos)               /*!< 0x00000002 */
#define FMC_PCR_PWAITEN            FMC_PCR_PWAITEN_Msk                         /*!<Wait feature enable bit                   */
#define FMC_PCR_PBKEN_Pos          (2U)
#define FMC_PCR_PBKEN_Msk          (0x1U << FMC_PCR_PBKEN_Pos)                 /*!< 0x00000004 */
#define FMC_PCR_PBKEN              FMC_PCR_PBKEN_Msk                           /*!<PC Card/NAND Flash memory bank enable bit */
#define FMC_PCR_PTYP_Pos           (3U)
#define FMC_PCR_PTYP_Msk           (0x1U << FMC_PCR_PTYP_Pos)                  /*!< 0x00000008 */
#define FMC_PCR_PTYP               FMC_PCR_PTYP_Msk                            /*!<Memory type                               */

#define FMC_PCR_PWID_Pos           (4U)
#define FMC_PCR_PWID_Msk           (0x3U << FMC_PCR_PWID_Pos)                  /*!< 0x00000030 */
#define FMC_PCR_PWID               FMC_PCR_PWID_Msk                            /*!<PWID[1:0] bits (NAND Flash databus width) */
#define FMC_PCR_PWID_0             (0x1U << FMC_PCR_PWID_Pos)                  /*!< 0x00000010 */
#define FMC_PCR_PWID_1             (0x2U << FMC_PCR_PWID_Pos)                  /*!< 0x00000020 */

#define FMC_PCR_ECCEN_Pos          (6U)
#define FMC_PCR_ECCEN_Msk          (0x1U << FMC_PCR_ECCEN_Pos)                 /*!< 0x00000040 */
#define FMC_PCR_ECCEN              FMC_PCR_ECCEN_Msk                           /*!<ECC computation logic enable bit          */

#define FMC_PCR_TCLR_Pos           (9U)
#define FMC_PCR_TCLR_Msk           (0xFU << FMC_PCR_TCLR_Pos)                  /*!< 0x00001E00 */
#define FMC_PCR_TCLR               FMC_PCR_TCLR_Msk                            /*!<TCLR[3:0] bits (CLE to RE delay)          */
#define FMC_PCR_TCLR_0             (0x1U << FMC_PCR_TCLR_Pos)                  /*!< 0x00000200 */
#define FMC_PCR_TCLR_1             (0x2U << FMC_PCR_TCLR_Pos)                  /*!< 0x00000400 */
#define FMC_PCR_TCLR_2             (0x4U << FMC_PCR_TCLR_Pos)                  /*!< 0x00000800 */
#define FMC_PCR_TCLR_3             (0x8U << FMC_PCR_TCLR_Pos)                  /*!< 0x00001000 */

#define FMC_PCR_TAR_Pos            (13U)
#define FMC_PCR_TAR_Msk            (0xFU << FMC_PCR_TAR_Pos)                   /*!< 0x0001E000 */
#define FMC_PCR_TAR                FMC_PCR_TAR_Msk                             /*!<TAR[3:0] bits (ALE to RE delay)           */
#define FMC_PCR_TAR_0              (0x1U << FMC_PCR_TAR_Pos)                   /*!< 0x00002000 */
#define FMC_PCR_TAR_1              (0x2U << FMC_PCR_TAR_Pos)                   /*!< 0x00004000 */
#define FMC_PCR_TAR_2              (0x4U << FMC_PCR_TAR_Pos)                   /*!< 0x00008000 */
#define FMC_PCR_TAR_3              (0x8U << FMC_PCR_TAR_Pos)                   /*!< 0x00010000 */

#define FMC_PCR_ECCPS_Pos          (17U)
#define FMC_PCR_ECCPS_Msk          (0x7U << FMC_PCR_ECCPS_Pos)                 /*!< 0x000E0000 */
#define FMC_PCR_ECCPS              FMC_PCR_ECCPS_Msk                           /*!<ECCPS[1:0] bits (ECC page size)           */
#define FMC_PCR_ECCPS_0            (0x1U << FMC_PCR_ECCPS_Pos)                 /*!< 0x00020000 */
#define FMC_PCR_ECCPS_1            (0x2U << FMC_PCR_ECCPS_Pos)                 /*!< 0x00040000 */
#define FMC_PCR_ECCPS_2            (0x4U << FMC_PCR_ECCPS_Pos)                 /*!< 0x00080000 */

/*******************  Bit definition for FMC_SR register  *******************/
#define FMC_SR_IRS                 ((uint8_t)0x01)                             /*!<Interrupt Rising Edge status                */
#define FMC_SR_ILS                 ((uint8_t)0x02)                             /*!<Interrupt Level status                      */
#define FMC_SR_IFS                 ((uint8_t)0x04)                             /*!<Interrupt Falling Edge status               */
#define FMC_SR_IREN                ((uint8_t)0x08)                             /*!<Interrupt Rising Edge detection Enable bit  */
#define FMC_SR_ILEN                ((uint8_t)0x10)                             /*!<Interrupt Level detection Enable bit        */
#define FMC_SR_IFEN                ((uint8_t)0x20)                             /*!<Interrupt Falling Edge detection Enable bit */
#define FMC_SR_FEMPT               ((uint8_t)0x40)                             /*!<FIFO empty                                  */

/******************  Bit definition for FMC_PMEM register  ******************/
#define FMC_PMEM_MEMSET3_Pos       (0U)
#define FMC_PMEM_MEMSET3_Msk       (0xFFU << FMC_PMEM_MEMSET3_Pos)             /*!< 0x000000FF */
#define FMC_PMEM_MEMSET3           FMC_PMEM_MEMSET3_Msk                        /*!<MEMSET2[7:0] bits (Common memory 2 setup time) */
#define FMC_PMEM_MEMSET3_0         (0x01U << FMC_PMEM_MEMSET3_Pos)             /*!< 0x00000001 */
#define FMC_PMEM_MEMSET3_1         (0x02U << FMC_PMEM_MEMSET3_Pos)             /*!< 0x00000002 */
#define FMC_PMEM_MEMSET3_2         (0x04U << FMC_PMEM_MEMSET3_Pos)             /*!< 0x00000004 */
#define FMC_PMEM_MEMSET3_3         (0x08U << FMC_PMEM_MEMSET3_Pos)             /*!< 0x00000008 */
#define FMC_PMEM_MEMSET3_4         (0x10U << FMC_PMEM_MEMSET3_Pos)             /*!< 0x00000010 */
#define FMC_PMEM_MEMSET3_5         (0x20U << FMC_PMEM_MEMSET3_Pos)             /*!< 0x00000020 */
#define FMC_PMEM_MEMSET3_6         (0x40U << FMC_PMEM_MEMSET3_Pos)             /*!< 0x00000040 */
#define FMC_PMEM_MEMSET3_7         (0x80U << FMC_PMEM_MEMSET3_Pos)             /*!< 0x00000080 */

#define FMC_PMEM_MEMWAIT3_Pos      (8U)
#define FMC_PMEM_MEMWAIT3_Msk      (0xFFU << FMC_PMEM_MEMWAIT3_Pos)            /*!< 0x0000FF00 */
#define FMC_PMEM_MEMWAIT3          FMC_PMEM_MEMWAIT3_Msk                       /*!<MEMWAIT2[7:0] bits (Common memory 2 wait time) */
#define FMC_PMEM_MEMWAIT3_0        (0x01U << FMC_PMEM_MEMWAIT3_Pos)            /*!< 0x00000100 */
#define FMC_PMEM_MEMWAIT3_1        (0x02U << FMC_PMEM_MEMWAIT3_Pos)            /*!< 0x00000200 */
#define FMC_PMEM_MEMWAIT3_2        (0x04U << FMC_PMEM_MEMWAIT3_Pos)            /*!< 0x00000400 */
#define FMC_PMEM_MEMWAIT3_3        (0x08U << FMC_PMEM_MEMWAIT3_Pos)            /*!< 0x00000800 */
#define FMC_PMEM_MEMWAIT3_4        (0x10U << FMC_PMEM_MEMWAIT3_Pos)            /*!< 0x00001000 */
#define FMC_PMEM_MEMWAIT3_5        (0x20U << FMC_PMEM_MEMWAIT3_Pos)            /*!< 0x00002000 */
#define FMC_PMEM_MEMWAIT3_6        (0x40U << FMC_PMEM_MEMWAIT3_Pos)            /*!< 0x00004000 */
#define FMC_PMEM_MEMWAIT3_7        (0x80U << FMC_PMEM_MEMWAIT3_Pos)            /*!< 0x00008000 */

#define FMC_PMEM_MEMHOLD3_Pos      (16U)
#define FMC_PMEM_MEMHOLD3_Msk      (0xFFU << FMC_PMEM_MEMHOLD3_Pos)            /*!< 0x00FF0000 */
#define FMC_PMEM_MEMHOLD3          FMC_PMEM_MEMHOLD3_Msk                       /*!<MEMHOLD2[7:0] bits (Common memory 2 hold time) */
#define FMC_PMEM_MEMHOLD3_0        (0x01U << FMC_PMEM_MEMHOLD3_Pos)            /*!< 0x00010000 */
#define FMC_PMEM_MEMHOLD3_1        (0x02U << FMC_PMEM_MEMHOLD3_Pos)            /*!< 0x00020000 */
#define FMC_PMEM_MEMHOLD3_2        (0x04U << FMC_PMEM_MEMHOLD3_Pos)            /*!< 0x00040000 */
#define FMC_PMEM_MEMHOLD3_3        (0x08U << FMC_PMEM_MEMHOLD3_Pos)            /*!< 0x00080000 */
#define FMC_PMEM_MEMHOLD3_4        (0x10U << FMC_PMEM_MEMHOLD3_Pos)            /*!< 0x00100000 */
#define FMC_PMEM_MEMHOLD3_5        (0x20U << FMC_PMEM_MEMHOLD3_Pos)            /*!< 0x00200000 */
#define FMC_PMEM_MEMHOLD3_6        (0x40U << FMC_PMEM_MEMHOLD3_Pos)            /*!< 0x00400000 */
#define FMC_PMEM_MEMHOLD3_7        (0x80U << FMC_PMEM_MEMHOLD3_Pos)            /*!< 0x00800000 */

#define FMC_PMEM_MEMHIZ3_Pos       (24U)
#define FMC_PMEM_MEMHIZ3_Msk       (0xFFU << FMC_PMEM_MEMHIZ3_Pos)             /*!< 0xFF000000 */
#define FMC_PMEM_MEMHIZ3           FMC_PMEM_MEMHIZ3_Msk                        /*!<MEMHIZ2[7:0] bits (Common memory 2 databus HiZ time) */
#define FMC_PMEM_MEMHIZ3_0         (0x01U << FMC_PMEM_MEMHIZ3_Pos)             /*!< 0x01000000 */
#define FMC_PMEM_MEMHIZ3_1         (0x02U << FMC_PMEM_MEMHIZ3_Pos)             /*!< 0x02000000 */
#define FMC_PMEM_MEMHIZ3_2         (0x04U << FMC_PMEM_MEMHIZ3_Pos)             /*!< 0x04000000 */
#define FMC_PMEM_MEMHIZ3_3         (0x08U << FMC_PMEM_MEMHIZ3_Pos)             /*!< 0x08000000 */
#define FMC_PMEM_MEMHIZ3_4         (0x10U << FMC_PMEM_MEMHIZ3_Pos)             /*!< 0x10000000 */
#define FMC_PMEM_MEMHIZ3_5         (0x20U << FMC_PMEM_MEMHIZ3_Pos)             /*!< 0x20000000 */
#define FMC_PMEM_MEMHIZ3_6         (0x40U << FMC_PMEM_MEMHIZ3_Pos)             /*!< 0x40000000 */
#define FMC_PMEM_MEMHIZ3_7         (0x80U << FMC_PMEM_MEMHIZ3_Pos)             /*!< 0x80000000 */

/******************  Bit definition for FMC_PATT register  ******************/
#define FMC_PATT_ATTSET3_Pos       (0U)
#define FMC_PATT_ATTSET3_Msk       (0xFFU << FMC_PATT_ATTSET3_Pos)             /*!< 0x000000FF */
#define FMC_PATT_ATTSET3           FMC_PATT_ATTSET3_Msk                        /*!<ATTSET2[7:0] bits (Attribute memory 2 setup time) */
#define FMC_PATT_ATTSET3_0         (0x01U << FMC_PATT_ATTSET3_Pos)             /*!< 0x00000001 */
#define FMC_PATT_ATTSET3_1         (0x02U << FMC_PATT_ATTSET3_Pos)             /*!< 0x00000002 */
#define FMC_PATT_ATTSET3_2         (0x04U << FMC_PATT_ATTSET3_Pos)             /*!< 0x00000004 */
#define FMC_PATT_ATTSET3_3         (0x08U << FMC_PATT_ATTSET3_Pos)             /*!< 0x00000008 */
#define FMC_PATT_ATTSET3_4         (0x10U << FMC_PATT_ATTSET3_Pos)             /*!< 0x00000010 */
#define FMC_PATT_ATTSET3_5         (0x20U << FMC_PATT_ATTSET3_Pos)             /*!< 0x00000020 */
#define FMC_PATT_ATTSET3_6         (0x40U << FMC_PATT_ATTSET3_Pos)             /*!< 0x00000040 */
#define FMC_PATT_ATTSET3_7         (0x80U << FMC_PATT_ATTSET3_Pos)             /*!< 0x00000080 */

#define FMC_PATT_ATTWAIT3_Pos      (8U)
#define FMC_PATT_ATTWAIT3_Msk      (0xFFU << FMC_PATT_ATTWAIT3_Pos)            /*!< 0x0000FF00 */
#define FMC_PATT_ATTWAIT3          FMC_PATT_ATTWAIT3_Msk                       /*!<ATTWAIT2[7:0] bits (Attribute memory 2 wait time) */
#define FMC_PATT_ATTWAIT3_0        (0x01U << FMC_PATT_ATTWAIT3_Pos)            /*!< 0x00000100 */
#define FMC_PATT_ATTWAIT3_1        (0x02U << FMC_PATT_ATTWAIT3_Pos)            /*!< 0x00000200 */
#define FMC_PATT_ATTWAIT3_2        (0x04U << FMC_PATT_ATTWAIT3_Pos)            /*!< 0x00000400 */
#define FMC_PATT_ATTWAIT3_3        (0x08U << FMC_PATT_ATTWAIT3_Pos)            /*!< 0x00000800 */
#define FMC_PATT_ATTWAIT3_4        (0x10U << FMC_PATT_ATTWAIT3_Pos)            /*!< 0x00001000 */
#define FMC_PATT_ATTWAIT3_5        (0x20U << FMC_PATT_ATTWAIT3_Pos)            /*!< 0x00002000 */
#define FMC_PATT_ATTWAIT3_6        (0x40U << FMC_PATT_ATTWAIT3_Pos)            /*!< 0x00004000 */
#define FMC_PATT_ATTWAIT3_7        (0x80U << FMC_PATT_ATTWAIT3_Pos)            /*!< 0x00008000 */

#define FMC_PATT_ATTHOLD3_Pos      (16U)
#define FMC_PATT_ATTHOLD3_Msk      (0xFFU << FMC_PATT_ATTHOLD3_Pos)            /*!< 0x00FF0000 */
#define FMC_PATT_ATTHOLD3          FMC_PATT_ATTHOLD3_Msk                       /*!<ATTHOLD2[7:0] bits (Attribute memory 2 hold time) */
#define FMC_PATT_ATTHOLD3_0        (0x01U << FMC_PATT_ATTHOLD3_Pos)            /*!< 0x00010000 */
#define FMC_PATT_ATTHOLD3_1        (0x02U << FMC_PATT_ATTHOLD3_Pos)            /*!< 0x00020000 */
#define FMC_PATT_ATTHOLD3_2        (0x04U << FMC_PATT_ATTHOLD3_Pos)            /*!< 0x00040000 */
#define FMC_PATT_ATTHOLD3_3        (0x08U << FMC_PATT_ATTHOLD3_Pos)            /*!< 0x00080000 */
#define FMC_PATT_ATTHOLD3_4        (0x10U << FMC_PATT_ATTHOLD3_Pos)            /*!< 0x00100000 */
#define FMC_PATT_ATTHOLD3_5        (0x20U << FMC_PATT_ATTHOLD3_Pos)            /*!< 0x00200000 */
#define FMC_PATT_ATTHOLD3_6        (0x40U << FMC_PATT_ATTHOLD3_Pos)            /*!< 0x00400000 */
#define FMC_PATT_ATTHOLD3_7        (0x80U << FMC_PATT_ATTHOLD3_Pos)            /*!< 0x00800000 */

#define FMC_PATT_ATTHIZ3_Pos       (24U)
#define FMC_PATT_ATTHIZ3_Msk       (0xFFU << FMC_PATT_ATTHIZ3_Pos)             /*!< 0xFF000000 */
#define FMC_PATT_ATTHIZ3           FMC_PATT_ATTHIZ3_Msk                        /*!<ATTHIZ2[7:0] bits (Attribute memory 2 databus HiZ time) */
#define FMC_PATT_ATTHIZ3_0         (0x01U << FMC_PATT_ATTHIZ3_Pos)             /*!< 0x01000000 */
#define FMC_PATT_ATTHIZ3_1         (0x02U << FMC_PATT_ATTHIZ3_Pos)             /*!< 0x02000000 */
#define FMC_PATT_ATTHIZ3_2         (0x04U << FMC_PATT_ATTHIZ3_Pos)             /*!< 0x04000000 */
#define FMC_PATT_ATTHIZ3_3         (0x08U << FMC_PATT_ATTHIZ3_Pos)             /*!< 0x08000000 */
#define FMC_PATT_ATTHIZ3_4         (0x10U << FMC_PATT_ATTHIZ3_Pos)             /*!< 0x10000000 */
#define FMC_PATT_ATTHIZ3_5         (0x20U << FMC_PATT_ATTHIZ3_Pos)             /*!< 0x20000000 */
#define FMC_PATT_ATTHIZ3_6         (0x40U << FMC_PATT_ATTHIZ3_Pos)             /*!< 0x40000000 */
#define FMC_PATT_ATTHIZ3_7         (0x80U << FMC_PATT_ATTHIZ3_Pos)             /*!< 0x80000000 */

/******************  Bit definition for FMC_PIO4 register  *******************/
#define FMC_PIO4_IOSET4_Pos        (0U)
#define FMC_PIO4_IOSET4_Msk        (0xFFU << FMC_PIO4_IOSET4_Pos)              /*!< 0x000000FF */
#define FMC_PIO4_IOSET4            FMC_PIO4_IOSET4_Msk                         /*!<IOSET4[7:0] bits (I/O 4 setup time) */
#define FMC_PIO4_IOSET4_0          (0x01U << FMC_PIO4_IOSET4_Pos)              /*!< 0x00000001 */
#define FMC_PIO4_IOSET4_1          (0x02U << FMC_PIO4_IOSET4_Pos)              /*!< 0x00000002 */
#define FMC_PIO4_IOSET4_2          (0x04U << FMC_PIO4_IOSET4_Pos)              /*!< 0x00000004 */
#define FMC_PIO4_IOSET4_3          (0x08U << FMC_PIO4_IOSET4_Pos)              /*!< 0x00000008 */
#define FMC_PIO4_IOSET4_4          (0x10U << FMC_PIO4_IOSET4_Pos)              /*!< 0x00000010 */
#define FMC_PIO4_IOSET4_5          (0x20U << FMC_PIO4_IOSET4_Pos)              /*!< 0x00000020 */
#define FMC_PIO4_IOSET4_6          (0x40U << FMC_PIO4_IOSET4_Pos)              /*!< 0x00000040 */
#define FMC_PIO4_IOSET4_7          (0x80U << FMC_PIO4_IOSET4_Pos)              /*!< 0x00000080 */

#define FMC_PIO4_IOWAIT4_Pos       (8U)
#define FMC_PIO4_IOWAIT4_Msk       (0xFFU << FMC_PIO4_IOWAIT4_Pos)             /*!< 0x0000FF00 */
#define FMC_PIO4_IOWAIT4           FMC_PIO4_IOWAIT4_Msk                        /*!<IOWAIT4[7:0] bits (I/O 4 wait time) */
#define FMC_PIO4_IOWAIT4_0         (0x01U << FMC_PIO4_IOWAIT4_Pos)             /*!< 0x00000100 */
#define FMC_PIO4_IOWAIT4_1         (0x02U << FMC_PIO4_IOWAIT4_Pos)             /*!< 0x00000200 */
#define FMC_PIO4_IOWAIT4_2         (0x04U << FMC_PIO4_IOWAIT4_Pos)             /*!< 0x00000400 */
#define FMC_PIO4_IOWAIT4_3         (0x08U << FMC_PIO4_IOWAIT4_Pos)             /*!< 0x00000800 */
#define FMC_PIO4_IOWAIT4_4         (0x10U << FMC_PIO4_IOWAIT4_Pos)             /*!< 0x00001000 */
#define FMC_PIO4_IOWAIT4_5         (0x20U << FMC_PIO4_IOWAIT4_Pos)             /*!< 0x00002000 */
#define FMC_PIO4_IOWAIT4_6         (0x40U << FMC_PIO4_IOWAIT4_Pos)             /*!< 0x00004000 */
#define FMC_PIO4_IOWAIT4_7         (0x80U << FMC_PIO4_IOWAIT4_Pos)             /*!< 0x00008000 */

#define FMC_PIO4_IOHOLD4_Pos       (16U)
#define FMC_PIO4_IOHOLD4_Msk       (0xFFU << FMC_PIO4_IOHOLD4_Pos)             /*!< 0x00FF0000 */
#define FMC_PIO4_IOHOLD4           FMC_PIO4_IOHOLD4_Msk                        /*!<IOHOLD4[7:0] bits (I/O 4 hold time) */
#define FMC_PIO4_IOHOLD4_0         (0x01U << FMC_PIO4_IOHOLD4_Pos)             /*!< 0x00010000 */
#define FMC_PIO4_IOHOLD4_1         (0x02U << FMC_PIO4_IOHOLD4_Pos)             /*!< 0x00020000 */
#define FMC_PIO4_IOHOLD4_2         (0x04U << FMC_PIO4_IOHOLD4_Pos)             /*!< 0x00040000 */
#define FMC_PIO4_IOHOLD4_3         (0x08U << FMC_PIO4_IOHOLD4_Pos)             /*!< 0x00080000 */
#define FMC_PIO4_IOHOLD4_4         (0x10U << FMC_PIO4_IOHOLD4_Pos)             /*!< 0x00100000 */
#define FMC_PIO4_IOHOLD4_5         (0x20U << FMC_PIO4_IOHOLD4_Pos)             /*!< 0x00200000 */
#define FMC_PIO4_IOHOLD4_6         (0x40U << FMC_PIO4_IOHOLD4_Pos)             /*!< 0x00400000 */
#define FMC_PIO4_IOHOLD4_7         (0x80U << FMC_PIO4_IOHOLD4_Pos)             /*!< 0x00800000 */

#define FMC_PIO4_IOHIZ4_Pos        (24U)
#define FMC_PIO4_IOHIZ4_Msk        (0xFFU << FMC_PIO4_IOHIZ4_Pos)              /*!< 0xFF000000 */
#define FMC_PIO4_IOHIZ4            FMC_PIO4_IOHIZ4_Msk                         /*!<IOHIZ4[7:0] bits (I/O 4 databus HiZ time) */
#define FMC_PIO4_IOHIZ4_0          (0x01U << FMC_PIO4_IOHIZ4_Pos)              /*!< 0x01000000 */
#define FMC_PIO4_IOHIZ4_1          (0x02U << FMC_PIO4_IOHIZ4_Pos)              /*!< 0x02000000 */
#define FMC_PIO4_IOHIZ4_2          (0x04U << FMC_PIO4_IOHIZ4_Pos)              /*!< 0x04000000 */
#define FMC_PIO4_IOHIZ4_3          (0x08U << FMC_PIO4_IOHIZ4_Pos)              /*!< 0x08000000 */
#define FMC_PIO4_IOHIZ4_4          (0x10U << FMC_PIO4_IOHIZ4_Pos)              /*!< 0x10000000 */
#define FMC_PIO4_IOHIZ4_5          (0x20U << FMC_PIO4_IOHIZ4_Pos)              /*!< 0x20000000 */
#define FMC_PIO4_IOHIZ4_6          (0x40U << FMC_PIO4_IOHIZ4_Pos)              /*!< 0x40000000 */
#define FMC_PIO4_IOHIZ4_7          (0x80U << FMC_PIO4_IOHIZ4_Pos)              /*!< 0x80000000 */

/******************  Bit definition for FMC_ECCR2 register  ******************/
#define FMC_ECCR2_ECC2_Pos         (0U)
#define FMC_ECCR2_ECC2_Msk         (0xFFFFFFFFU << FMC_ECCR2_ECC2_Pos)         /*!< 0xFFFFFFFF */
#define FMC_ECCR2_ECC2             FMC_ECCR2_ECC2_Msk                          /*!<ECC result */

/******************  Bit definition for FMC_ECCR3 register  ******************/
#define FMC_ECCR3_ECC3_Pos         (0U)
#define FMC_ECCR3_ECC3_Msk         (0xFFFFFFFFU << FMC_ECCR3_ECC3_Pos)         /*!< 0xFFFFFFFF */
#define FMC_ECCR3_ECC3             FMC_ECCR3_ECC3_Msk                          /*!<ECC result */

/******************  Bit definition for FMC_SDCR1 register  ******************/
#define FMC_SDCR1_NC_Pos           (0U)
#define FMC_SDCR1_NC_Msk           (0x3U << FMC_SDCR1_NC_Pos)                  /*!< 0x00000003 */
#define FMC_SDCR1_NC               FMC_SDCR1_NC_Msk                            /*!<NC[1:0] bits (Number of column bits) */
#define FMC_SDCR1_NC_0             (0x1U << FMC_SDCR1_NC_Pos)                  /*!< 0x00000001 */
#define FMC_SDCR1_NC_1             (0x2U << FMC_SDCR1_NC_Pos)                  /*!< 0x00000002 */

#define FMC_SDCR1_NR_Pos           (2U)
#define FMC_SDCR1_NR_Msk           (0x3U << FMC_SDCR1_NR_Pos)                  /*!< 0x0000000C */
#define FMC_SDCR1_NR               FMC_SDCR1_NR_Msk                            /*!<NR[1:0] bits (Number of row bits) */
#define FMC_SDCR1_NR_0             (0x1U << FMC_SDCR1_NR_Pos)                  /*!< 0x00000004 */
#define FMC_SDCR1_NR_1             (0x2U << FMC_SDCR1_NR_Pos)                  /*!< 0x00000008 */

#define FMC_SDCR1_MWID_Pos         (4U)
#define FMC_SDCR1_MWID_Msk         (0x3U << FMC_SDCR1_MWID_Pos)                /*!< 0x00000030 */
#define FMC_SDCR1_MWID             FMC_SDCR1_MWID_Msk                          /*!<NR[1:0] bits (Number of row bits) */
#define FMC_SDCR1_MWID_0           (0x1U << FMC_SDCR1_MWID_Pos)                /*!< 0x00000010 */
#define FMC_SDCR1_MWID_1           (0x2U << FMC_SDCR1_MWID_Pos)                /*!< 0x00000020 */

#define FMC_SDCR1_NB_Pos           (6U)
#define FMC_SDCR1_NB_Msk           (0x1U << FMC_SDCR1_NB_Pos)                  /*!< 0x00000040 */
#define FMC_SDCR1_NB               FMC_SDCR1_NB_Msk                            /*!<Number of internal bank */

#define FMC_SDCR1_CAS_Pos          (7U)
#define FMC_SDCR1_CAS_Msk          (0x3U << FMC_SDCR1_CAS_Pos)                 /*!< 0x00000180 */
#define FMC_SDCR1_CAS              FMC_SDCR1_CAS_Msk                           /*!<CAS[1:0] bits (CAS latency) */
#define FMC_SDCR1_CAS_0            (0x1U << FMC_SDCR1_CAS_Pos)                 /*!< 0x00000080 */
#define FMC_SDCR1_CAS_1            (0x2U << FMC_SDCR1_CAS_Pos)                 /*!< 0x00000100 */

#define FMC_SDCR1_WP_Pos           (9U)
#define FMC_SDCR1_WP_Msk           (0x1U << FMC_SDCR1_WP_Pos)                  /*!< 0x00000200 */
#define FMC_SDCR1_WP               FMC_SDCR1_WP_Msk                            /*!<Write protection */

#define FMC_SDCR1_SDCLK_Pos        (10U)
#define FMC_SDCR1_SDCLK_Msk        (0x3U << FMC_SDCR1_SDCLK_Pos)               /*!< 0x00000C00 */
#define FMC_SDCR1_SDCLK            FMC_SDCR1_SDCLK_Msk                         /*!<SDRAM clock configuration */
#define FMC_SDCR1_SDCLK_0          (0x1U << FMC_SDCR1_SDCLK_Pos)               /*!< 0x00000400 */
#define FMC_SDCR1_SDCLK_1          (0x2U << FMC_SDCR1_SDCLK_Pos)               /*!< 0x00000800 */

#define FMC_SDCR1_RBURST_Pos       (12U)
#define FMC_SDCR1_RBURST_Msk       (0x1U << FMC_SDCR1_RBURST_Pos)              /*!< 0x00001000 */
#define FMC_SDCR1_RBURST           FMC_SDCR1_RBURST_Msk                        /*!<Read burst */

#define FMC_SDCR1_RPIPE_Pos        (13U)
#define FMC_SDCR1_RPIPE_Msk        (0x3U << FMC_SDCR1_RPIPE_Pos)               /*!< 0x00006000 */
#define FMC_SDCR1_RPIPE            FMC_SDCR1_RPIPE_Msk                         /*!<Write protection */
#define FMC_SDCR1_RPIPE_0          (0x1U << FMC_SDCR1_RPIPE_Pos)               /*!< 0x00002000 */
#define FMC_SDCR1_RPIPE_1          (0x2U << FMC_SDCR1_RPIPE_Pos)               /*!< 0x00004000 */

/******************  Bit definition for FMC_SDCR2 register  ******************/
#define FMC_SDCR2_NC_Pos           (0U)
#define FMC_SDCR2_NC_Msk           (0x3U << FMC_SDCR2_NC_Pos)                  /*!< 0x00000003 */
#define FMC_SDCR2_NC               FMC_SDCR2_NC_Msk                            /*!<NC[1:0] bits (Number of column bits) */
#define FMC_SDCR2_NC_0             (0x1U << FMC_SDCR2_NC_Pos)                  /*!< 0x00000001 */
#define FMC_SDCR2_NC_1             (0x2U << FMC_SDCR2_NC_Pos)                  /*!< 0x00000002 */

#define FMC_SDCR2_NR_Pos           (2U)
#define FMC_SDCR2_NR_Msk           (0x3U << FMC_SDCR2_NR_Pos)                  /*!< 0x0000000C */
#define FMC_SDCR2_NR               FMC_SDCR2_NR_Msk                            /*!<NR[1:0] bits (Number of row bits) */
#define FMC_SDCR2_NR_0             (0x1U << FMC_SDCR2_NR_Pos)                  /*!< 0x00000004 */
#define FMC_SDCR2_NR_1             (0x2U << FMC_SDCR2_NR_Pos)                  /*!< 0x00000008 */

#define FMC_SDCR2_MWID_Pos         (4U)
#define FMC_SDCR2_MWID_Msk         (0x3U << FMC_SDCR2_MWID_Pos)                /*!< 0x00000030 */
#define FMC_SDCR2_MWID             FMC_SDCR2_MWID_Msk                          /*!<NR[1:0] bits (Number of row bits) */
#define FMC_SDCR2_MWID_0           (0x1U << FMC_SDCR2_MWID_Pos)                /*!< 0x00000010 */
#define FMC_SDCR2_MWID_1           (0x2U << FMC_SDCR2_MWID_Pos)                /*!< 0x00000020 */

#define FMC_SDCR2_NB_Pos           (6U)
#define FMC_SDCR2_NB_Msk           (0x1U << FMC_SDCR2_NB_Pos)                  /*!< 0x00000040 */
#define FMC_SDCR2_NB               FMC_SDCR2_NB_Msk                            /*!<Number of internal bank */

#define FMC_SDCR2_CAS_Pos          (7U)
#define FMC_SDCR2_CAS_Msk          (0x3U << FMC_SDCR2_CAS_Pos)                 /*!< 0x00000180 */
#define FMC_SDCR2_CAS              FMC_SDCR2_CAS_Msk                           /*!<CAS[1:0] bits (CAS latency) */
#define FMC_SDCR2_CAS_0            (0x1U << FMC_SDCR2_CAS_Pos)                 /*!< 0x00000080 */
#define FMC_SDCR2_CAS_1            (0x2U << FMC_SDCR2_CAS_Pos)                 /*!< 0x00000100 */

#define FMC_SDCR2_WP_Pos           (9U)
#define FMC_SDCR2_WP_Msk           (0x1U << FMC_SDCR2_WP_Pos)                  /*!< 0x00000200 */
#define FMC_SDCR2_WP               FMC_SDCR2_WP_Msk                            /*!<Write protection */

#define FMC_SDCR2_SDCLK_Pos        (10U)
#define FMC_SDCR2_SDCLK_Msk        (0x3U << FMC_SDCR2_SDCLK_Pos)               /*!< 0x00000C00 */
#define FMC_SDCR2_SDCLK            FMC_SDCR2_SDCLK_Msk                         /*!<SDCLK[1:0] (SDRAM clock configuration) */
#define FMC_SDCR2_SDCLK_0          (0x1U << FMC_SDCR2_SDCLK_Pos)               /*!< 0x00000400 */
#define FMC_SDCR2_SDCLK_1          (0x2U << FMC_SDCR2_SDCLK_Pos)               /*!< 0x00000800 */

#define FMC_SDCR2_RBURST_Pos       (12U)
#define FMC_SDCR2_RBURST_Msk       (0x1U << FMC_SDCR2_RBURST_Pos)              /*!< 0x00001000 */
#define FMC_SDCR2_RBURST           FMC_SDCR2_RBURST_Msk                        /*!<Read burst */

#define FMC_SDCR2_RPIPE_Pos        (13U)
#define FMC_SDCR2_RPIPE_Msk        (0x3U << FMC_SDCR2_RPIPE_Pos)               /*!< 0x00006000 */
#define FMC_SDCR2_RPIPE            FMC_SDCR2_RPIPE_Msk                         /*!<RPIPE[1:0](Read pipe) */
#define FMC_SDCR2_RPIPE_0          (0x1U << FMC_SDCR2_RPIPE_Pos)               /*!< 0x00002000 */
#define FMC_SDCR2_RPIPE_1          (0x2U << FMC_SDCR2_RPIPE_Pos)               /*!< 0x00004000 */

/******************  Bit definition for FMC_SDTR1 register  ******************/
#define FMC_SDTR1_TMRD_Pos         (0U)
#define FMC_SDTR1_TMRD_Msk         (0xFU << FMC_SDTR1_TMRD_Pos)                /*!< 0x0000000F */
#define FMC_SDTR1_TMRD             FMC_SDTR1_TMRD_Msk                          /*!<TMRD[3:0] bits (Load mode register to active) */
#define FMC_SDTR1_TMRD_0           (0x1U << FMC_SDTR1_TMRD_Pos)                /*!< 0x00000001 */
#define FMC_SDTR1_TMRD_1           (0x2U << FMC_SDTR1_TMRD_Pos)                /*!< 0x00000002 */
#define FMC_SDTR1_TMRD_2           (0x4U << FMC_SDTR1_TMRD_Pos)                /*!< 0x00000004 */
#define FMC_SDTR1_TMRD_3           (0x8U << FMC_SDTR1_TMRD_Pos)                /*!< 0x00000008 */

#define FMC_SDTR1_TXSR_Pos         (4U)
#define FMC_SDTR1_TXSR_Msk         (0xFU << FMC_SDTR1_TXSR_Pos)                /*!< 0x000000F0 */
#define FMC_SDTR1_TXSR             FMC_SDTR1_TXSR_Msk                          /*!<TXSR[3:0] bits (Exit self refresh) */
#define FMC_SDTR1_TXSR_0           (0x1U << FMC_SDTR1_TXSR_Pos)                /*!< 0x00000010 */
#define FMC_SDTR1_TXSR_1           (0x2U << FMC_SDTR1_TXSR_Pos)                /*!< 0x00000020 */
#define FMC_SDTR1_TXSR_2           (0x4U << FMC_SDTR1_TXSR_Pos)                /*!< 0x00000040 */
#define FMC_SDTR1_TXSR_3           (0x8U << FMC_SDTR1_TXSR_Pos)                /*!< 0x00000080 */

#define FMC_SDTR1_TRAS_Pos         (8U)
#define FMC_SDTR1_TRAS_Msk         (0xFU << FMC_SDTR1_TRAS_Pos)                /*!< 0x00000F00 */
#define FMC_SDTR1_TRAS             FMC_SDTR1_TRAS_Msk                          /*!<TRAS[3:0] bits (Self refresh time) */
#define FMC_SDTR1_TRAS_0           (0x1U << FMC_SDTR1_TRAS_Pos)                /*!< 0x00000100 */
#define FMC_SDTR1_TRAS_1           (0x2U << FMC_SDTR1_TRAS_Pos)                /*!< 0x00000200 */
#define FMC_SDTR1_TRAS_2           (0x4U << FMC_SDTR1_TRAS_Pos)                /*!< 0x00000400 */
#define FMC_SDTR1_TRAS_3           (0x8U << FMC_SDTR1_TRAS_Pos)                /*!< 0x00000800 */

#define FMC_SDTR1_TRC_Pos          (12U)
#define FMC_SDTR1_TRC_Msk          (0xFU << FMC_SDTR1_TRC_Pos)                 /*!< 0x0000F000 */
#define FMC_SDTR1_TRC              FMC_SDTR1_TRC_Msk                           /*!<TRC[2:0] bits (Row cycle delay) */
#define FMC_SDTR1_TRC_0            (0x1U << FMC_SDTR1_TRC_Pos)                 /*!< 0x00001000 */
#define FMC_SDTR1_TRC_1            (0x2U << FMC_SDTR1_TRC_Pos)                 /*!< 0x00002000 */
#define FMC_SDTR1_TRC_2            (0x4U << FMC_SDTR1_TRC_Pos)                 /*!< 0x00004000 */

#define FMC_SDTR1_TWR_Pos          (16U)
#define FMC_SDTR1_TWR_Msk          (0xFU << FMC_SDTR1_TWR_Pos)                 /*!< 0x000F0000 */
#define FMC_SDTR1_TWR              FMC_SDTR1_TWR_Msk                           /*!<TRC[2:0] bits (Write recovery delay) */
#define FMC_SDTR1_TWR_0            (0x1U << FMC_SDTR1_TWR_Pos)                 /*!< 0x00010000 */
#define FMC_SDTR1_TWR_1            (0x2U << FMC_SDTR1_TWR_Pos)                 /*!< 0x00020000 */
#define FMC_SDTR1_TWR_2            (0x4U << FMC_SDTR1_TWR_Pos)                 /*!< 0x00040000 */

#define FMC_SDTR1_TRP_Pos          (20U)
#define FMC_SDTR1_TRP_Msk          (0xFU << FMC_SDTR1_TRP_Pos)                 /*!< 0x00F00000 */
#define FMC_SDTR1_TRP              FMC_SDTR1_TRP_Msk                           /*!<TRP[2:0] bits (Row precharge delay) */
#define FMC_SDTR1_TRP_0            (0x1U << FMC_SDTR1_TRP_Pos)                 /*!< 0x00100000 */
#define FMC_SDTR1_TRP_1            (0x2U << FMC_SDTR1_TRP_Pos)                 /*!< 0x00200000 */
#define FMC_SDTR1_TRP_2            (0x4U << FMC_SDTR1_TRP_Pos)                 /*!< 0x00400000 */

#define FMC_SDTR1_TRCD_Pos         (24U)
#define FMC_SDTR1_TRCD_Msk         (0xFU << FMC_SDTR1_TRCD_Pos)                /*!< 0x0F000000 */
#define FMC_SDTR1_TRCD             FMC_SDTR1_TRCD_Msk                          /*!<TRP[2:0] bits (Row to column delay) */
#define FMC_SDTR1_TRCD_0           (0x1U << FMC_SDTR1_TRCD_Pos)                /*!< 0x01000000 */
#define FMC_SDTR1_TRCD_1           (0x2U << FMC_SDTR1_TRCD_Pos)                /*!< 0x02000000 */
#define FMC_SDTR1_TRCD_2           (0x4U << FMC_SDTR1_TRCD_Pos)                /*!< 0x04000000 */

/******************  Bit definition for FMC_SDTR2 register  ******************/
#define FMC_SDTR2_TMRD_Pos         (0U)
#define FMC_SDTR2_TMRD_Msk         (0xFU << FMC_SDTR2_TMRD_Pos)                /*!< 0x0000000F */
#define FMC_SDTR2_TMRD             FMC_SDTR2_TMRD_Msk                          /*!<TMRD[3:0] bits (Load mode register to active) */
#define FMC_SDTR2_TMRD_0           (0x1U << FMC_SDTR2_TMRD_Pos)                /*!< 0x00000001 */
#define FMC_SDTR2_TMRD_1           (0x2U << FMC_SDTR2_TMRD_Pos)                /*!< 0x00000002 */
#define FMC_SDTR2_TMRD_2           (0x4U << FMC_SDTR2_TMRD_Pos)                /*!< 0x00000004 */
#define FMC_SDTR2_TMRD_3           (0x8U << FMC_SDTR2_TMRD_Pos)                /*!< 0x00000008 */

#define FMC_SDTR2_TXSR_Pos         (4U)
#define FMC_SDTR2_TXSR_Msk         (0xFU << FMC_SDTR2_TXSR_Pos)                /*!< 0x000000F0 */
#define FMC_SDTR2_TXSR             FMC_SDTR2_TXSR_Msk                          /*!<TXSR[3:0] bits (Exit self refresh) */
#define FMC_SDTR2_TXSR_0           (0x1U << FMC_SDTR2_TXSR_Pos)                /*!< 0x00000010 */
#define FMC_SDTR2_TXSR_1           (0x2U << FMC_SDTR2_TXSR_Pos)                /*!< 0x00000020 */
#define FMC_SDTR2_TXSR_2           (0x4U << FMC_SDTR2_TXSR_Pos)                /*!< 0x00000040 */
#define FMC_SDTR2_TXSR_3           (0x8U << FMC_SDTR2_TXSR_Pos)                /*!< 0x00000080 */

#define FMC_SDTR2_TRAS_Pos         (8U)
#define FMC_SDTR2_TRAS_Msk         (0xFU << FMC_SDTR2_TRAS_Pos)                /*!< 0x00000F00 */
#define FMC_SDTR2_TRAS             FMC_SDTR2_TRAS_Msk                          /*!<TRAS[3:0] bits (Self refresh time) */
#define FMC_SDTR2_TRAS_0           (0x1U << FMC_SDTR2_TRAS_Pos)                /*!< 0x00000100 */
#define FMC_SDTR2_TRAS_1           (0x2U << FMC_SDTR2_TRAS_Pos)                /*!< 0x00000200 */
#define FMC_SDTR2_TRAS_2           (0x4U << FMC_SDTR2_TRAS_Pos)                /*!< 0x00000400 */
#define FMC_SDTR2_TRAS_3           (0x8U << FMC_SDTR2_TRAS_Pos)                /*!< 0x00000800 */

#define FMC_SDTR2_TRC_Pos          (12U)
#define FMC_SDTR2_TRC_Msk          (0xFU << FMC_SDTR2_TRC_Pos)                 /*!< 0x0000F000 */
#define FMC_SDTR2_TRC              FMC_SDTR2_TRC_Msk                           /*!<TRC[2:0] bits (Row cycle delay) */
#define FMC_SDTR2_TRC_0            (0x1U << FMC_SDTR2_TRC_Pos)                 /*!< 0x00001000 */
#define FMC_SDTR2_TRC_1            (0x2U << FMC_SDTR2_TRC_Pos)                 /*!< 0x00002000 */
#define FMC_SDTR2_TRC_2            (0x4U << FMC_SDTR2_TRC_Pos)                 /*!< 0x00004000 */

#define FMC_SDTR2_TWR_Pos          (16U)
#define FMC_SDTR2_TWR_Msk          (0xFU << FMC_SDTR2_TWR_Pos)                 /*!< 0x000F0000 */
#define FMC_SDTR2_TWR              FMC_SDTR2_TWR_Msk                           /*!<TRC[2:0] bits (Write recovery delay) */
#define FMC_SDTR2_TWR_0            (0x1U << FMC_SDTR2_TWR_Pos)                 /*!< 0x00010000 */
#define FMC_SDTR2_TWR_1            (0x2U << FMC_SDTR2_TWR_Pos)                 /*!< 0x00020000 */
#define FMC_SDTR2_TWR_2            (0x4U << FMC_SDTR2_TWR_Pos)                 /*!< 0x00040000 */

#define FMC_SDTR2_TRP_Pos          (20U)
#define FMC_SDTR2_TRP_Msk          (0xFU << FMC_SDTR2_TRP_Pos)                 /*!< 0x00F00000 */
#define FMC_SDTR2_TRP              FMC_SDTR2_TRP_Msk                           /*!<TRP[2:0] bits (Row precharge delay) */
#define FMC_SDTR2_TRP_0            (0x1U << FMC_SDTR2_TRP_Pos)                 /*!< 0x00100000 */
#define FMC_SDTR2_TRP_1            (0x2U << FMC_SDTR2_TRP_Pos)                 /*!< 0x00200000 */
#define FMC_SDTR2_TRP_2            (0x4U << FMC_SDTR2_TRP_Pos)                 /*!< 0x00400000 */

#define FMC_SDTR2_TRCD_Pos         (24U)
#define FMC_SDTR2_TRCD_Msk         (0xFU << FMC_SDTR2_TRCD_Pos)                /*!< 0x0F000000 */
#define FMC_SDTR2_TRCD             FMC_SDTR2_TRCD_Msk                          /*!<TRP[2:0] bits (Row to column delay) */
#define FMC_SDTR2_TRCD_0           (0x1U << FMC_SDTR2_TRCD_Pos)                /*!< 0x01000000 */
#define FMC_SDTR2_TRCD_1           (0x2U << FMC_SDTR2_TRCD_Pos)                /*!< 0x02000000 */
#define FMC_SDTR2_TRCD_2           (0x4U << FMC_SDTR2_TRCD_Pos)                /*!< 0x04000000 */

/******************  Bit definition for FMC_SDCMR register  ******************/
#define FMC_SDCMR_MODE_Pos         (0U)
#define FMC_SDCMR_MODE_Msk         (0x7U << FMC_SDCMR_MODE_Pos)                /*!< 0x00000007 */
#define FMC_SDCMR_MODE             FMC_SDCMR_MODE_Msk                          /*!<MODE[2:0] bits (Command mode) */
#define FMC_SDCMR_MODE_0           (0x1U << FMC_SDCMR_MODE_Pos)                /*!< 0x00000001 */
#define FMC_SDCMR_MODE_1           (0x2U << FMC_SDCMR_MODE_Pos)                /*!< 0x00000002 */
#define FMC_SDCMR_MODE_2           (0x3U << FMC_SDCMR_MODE_Pos)                /*!< 0x00000003 */

#define FMC_SDCMR_CTB2_Pos         (3U)
#define FMC_SDCMR_CTB2_Msk         (0x1U << FMC_SDCMR_CTB2_Pos)                /*!< 0x00000008 */
#define FMC_SDCMR_CTB2             FMC_SDCMR_CTB2_Msk                          /*!<Command target 2 */

#define FMC_SDCMR_CTB1_Pos         (4U)
#define FMC_SDCMR_CTB1_Msk         (0x1U << FMC_SDCMR_CTB1_Pos)                /*!< 0x00000010 */
#define FMC_SDCMR_CTB1             FMC_SDCMR_CTB1_Msk                          /*!<Command target 1 */

#define FMC_SDCMR_NRFS_Pos         (5U)
#define FMC_SDCMR_NRFS_Msk         (0xFU << FMC_SDCMR_NRFS_Pos)                /*!< 0x000001E0 */
#define FMC_SDCMR_NRFS             FMC_SDCMR_NRFS_Msk                          /*!<NRFS[3:0] bits (Number of auto-refresh) */
#define FMC_SDCMR_NRFS_0           (0x1U << FMC_SDCMR_NRFS_Pos)                /*!< 0x00000020 */
#define FMC_SDCMR_NRFS_1           (0x2U << FMC_SDCMR_NRFS_Pos)                /*!< 0x00000040 */
#define FMC_SDCMR_NRFS_2           (0x4U << FMC_SDCMR_NRFS_Pos)                /*!< 0x00000080 */
#define FMC_SDCMR_NRFS_3           (0x8U << FMC_SDCMR_NRFS_Pos)                /*!< 0x00000100 */

#define FMC_SDCMR_MRD_Pos          (9U)
#define FMC_SDCMR_MRD_Msk          (0x1FFFU << FMC_SDCMR_MRD_Pos)              /*!< 0x003FFE00 */
#define FMC_SDCMR_MRD              FMC_SDCMR_MRD_Msk                           /*!<MRD[12:0] bits (Mode register definition) */

/******************  Bit definition for FMC_SDRTR register  ******************/
#define FMC_SDRTR_CRE_Pos          (0U)
#define FMC_SDRTR_CRE_Msk          (0x1U << FMC_SDRTR_CRE_Pos)                 /*!< 0x00000001 */
#define FMC_SDRTR_CRE              FMC_SDRTR_CRE_Msk                           /*!<Clear refresh error flag */

#define FMC_SDRTR_COUNT_Pos        (1U)
#define FMC_SDRTR_COUNT_Msk        (0x1FFFU << FMC_SDRTR_COUNT_Pos)            /*!< 0x00003FFE */
#define FMC_SDRTR_COUNT            FMC_SDRTR_COUNT_Msk                         /*!<COUNT[12:0] bits (Refresh timer count) */

#define FMC_SDRTR_REIE_Pos         (14U)
#define FMC_SDRTR_REIE_Msk         (0x1U << FMC_SDRTR_REIE_Pos)                /*!< 0x00004000 */
#define FMC_SDRTR_REIE             FMC_SDRTR_REIE_Msk                          /*!<RES interupt enable */

/******************  Bit definition for FMC_SDSR register  ******************/
#define FMC_SDSR_RE_Pos            (0U)
#define FMC_SDSR_RE_Msk            (0x1U << FMC_SDSR_RE_Pos)                   /*!< 0x00000001 */
#define FMC_SDSR_RE                FMC_SDSR_RE_Msk                             /*!<Refresh error flag */

#define FMC_SDSR_MODES1_Pos        (1U)
#define FMC_SDSR_MODES1_Msk        (0x3U << FMC_SDSR_MODES1_Pos)               /*!< 0x00000006 */
#define FMC_SDSR_MODES1            FMC_SDSR_MODES1_Msk                         /*!<MODES1[1:0]bits (Status mode for bank 1) */
#define FMC_SDSR_MODES1_0          (0x1U << FMC_SDSR_MODES1_Pos)               /*!< 0x00000002 */
#define FMC_SDSR_MODES1_1          (0x2U << FMC_SDSR_MODES1_Pos)               /*!< 0x00000004 */

#define FMC_SDSR_MODES2_Pos        (3U)
#define FMC_SDSR_MODES2_Msk        (0x3U << FMC_SDSR_MODES2_Pos)               /*!< 0x00000018 */
#define FMC_SDSR_MODES2            FMC_SDSR_MODES2_Msk                         /*!<MODES2[1:0]bits (Status mode for bank 2) */
#define FMC_SDSR_MODES2_0          (0x1U << FMC_SDSR_MODES2_Pos)               /*!< 0x00000008 */
#define FMC_SDSR_MODES2_1          (0x2U << FMC_SDSR_MODES2_Pos)               /*!< 0x00000010 */

#define FMC_SDSR_BUSY_Pos          (5U)
#define FMC_SDSR_BUSY_Msk          (0x1U << FMC_SDSR_BUSY_Pos)                 /*!< 0x00000020 */
#define FMC_SDSR_BUSY              FMC_SDSR_BUSY_Msk                           /*!<Busy status */

/******************************************************************************/
/*                                                                            */
/*                            General Purpose I/O                             */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for GPIO_MODER register  *****************/
#define GPIO_MODER_MODER0_Pos            (0U)
#define GPIO_MODER_MODER0_Msk            (0x3U << GPIO_MODER_MODER0_Pos)       /*!< 0x00000003 */
#define GPIO_MODER_MODER0                GPIO_MODER_MODER0_Msk
#define GPIO_MODER_MODER0_0              (0x1U << GPIO_MODER_MODER0_Pos)       /*!< 0x00000001 */
#define GPIO_MODER_MODER0_1              (0x2U << GPIO_MODER_MODER0_Pos)       /*!< 0x00000002 */

#define GPIO_MODER_MODER1_Pos            (2U)
#define GPIO_MODER_MODER1_Msk            (0x3U << GPIO_MODER_MODER1_Pos)       /*!< 0x0000000C */
#define GPIO_MODER_MODER1                GPIO_MODER_MODER1_Msk
#define GPIO_MODER_MODER1_0              (0x1U << GPIO_MODER_MODER1_Pos)       /*!< 0x00000004 */
#define GPIO_MODER_MODER1_1              (0x2U << GPIO_MODER_MODER1_Pos)       /*!< 0x00000008 */

#define GPIO_MODER_MODER2_Pos            (4U)
#define GPIO_MODER_MODER2_Msk            (0x3U << GPIO_MODER_MODER2_Pos)       /*!< 0x00000030 */
#define GPIO_MODER_MODER2                GPIO_MODER_MODER2_Msk
#define GPIO_MODER_MODER2_0              (0x1U << GPIO_MODER_MODER2_Pos)       /*!< 0x00000010 */
#define GPIO_MODER_MODER2_1              (0x2U << GPIO_MODER_MODER2_Pos)       /*!< 0x00000020 */

#define GPIO_MODER_MODER3_Pos            (6U)
#define GPIO_MODER_MODER3_Msk            (0x3U << GPIO_MODER_MODER3_Pos)       /*!< 0x000000C0 */
#define GPIO_MODER_MODER3                GPIO_MODER_MODER3_Msk
#define GPIO_MODER_MODER3_0              (0x1U << GPIO_MODER_MODER3_Pos)       /*!< 0x00000040 */
#define GPIO_MODER_MODER3_1              (0x2U << GPIO_MODER_MODER3_Pos)       /*!< 0x00000080 */

#define GPIO_MODER_MODER4_Pos            (8U)
#define GPIO_MODER_MODER4_Msk            (0x3U << GPIO_MODER_MODER4_Pos)       /*!< 0x00000300 */
#define GPIO_MODER_MODER4                GPIO_MODER_MODER4_Msk
#define GPIO_MODER_MODER4_0              (0x1U << GPIO_MODER_MODER4_Pos)       /*!< 0x00000100 */
#define GPIO_MODER_MODER4_1              (0x2U << GPIO_MODER_MODER4_Pos)       /*!< 0x00000200 */

#define GPIO_MODER_MODER5_Pos            (10U)
#define GPIO_MODER_MODER5_Msk            (0x3U << GPIO_MODER_MODER5_Pos)       /*!< 0x00000C00 */
#define GPIO_MODER_MODER5                GPIO_MODER_MODER5_Msk
#define GPIO_MODER_MODER5_0              (0x1U << GPIO_MODER_MODER5_Pos)       /*!< 0x00000400 */
#define GPIO_MODER_MODER5_1              (0x2U << GPIO_MODER_MODER5_Pos)       /*!< 0x00000800 */

#define GPIO_MODER_MODER6_Pos            (12U)
#define GPIO_MODER_MODER6_Msk            (0x3U << GPIO_MODER_MODER6_Pos)       /*!< 0x00003000 */
#define GPIO_MODER_MODER6                GPIO_MODER_MODER6_Msk
#define GPIO_MODER_MODER6_0              (0x1U << GPIO_MODER_MODER6_Pos)       /*!< 0x00001000 */
#define GPIO_MODER_MODER6_1              (0x2U << GPIO_MODER_MODER6_Pos)       /*!< 0x00002000 */

#define GPIO_MODER_MODER7_Pos            (14U)
#define GPIO_MODER_MODER7_Msk            (0x3U << GPIO_MODER_MODER7_Pos)       /*!< 0x0000C000 */
#define GPIO_MODER_MODER7                GPIO_MODER_MODER7_Msk
#define GPIO_MODER_MODER7_0              (0x1U << GPIO_MODER_MODER7_Pos)       /*!< 0x00004000 */
#define GPIO_MODER_MODER7_1              (0x2U << GPIO_MODER_MODER7_Pos)       /*!< 0x00008000 */

#define GPIO_MODER_MODER8_Pos            (16U)
#define GPIO_MODER_MODER8_Msk            (0x3U << GPIO_MODER_MODER8_Pos)       /*!< 0x00030000 */
#define GPIO_MODER_MODER8                GPIO_MODER_MODER8_Msk
#define GPIO_MODER_MODER8_0              (0x1U << GPIO_MODER_MODER8_Pos)       /*!< 0x00010000 */
#define GPIO_MODER_MODER8_1              (0x2U << GPIO_MODER_MODER8_Pos)       /*!< 0x00020000 */

#define GPIO_MODER_MODER9_Pos            (18U)
#define GPIO_MODER_MODER9_Msk            (0x3U << GPIO_MODER_MODER9_Pos)       /*!< 0x000C0000 */
#define GPIO_MODER_MODER9                GPIO_MODER_MODER9_Msk
#define GPIO_MODER_MODER9_0              (0x1U << GPIO_MODER_MODER9_Pos)       /*!< 0x00040000 */
#define GPIO_MODER_MODER9_1              (0x2U << GPIO_MODER_MODER9_Pos)       /*!< 0x00080000 */

#define GPIO_MODER_MODER10_Pos           (20U)
#define GPIO_MODER_MODER10_Msk           (0x3U << GPIO_MODER_MODER10_Pos)      /*!< 0x00300000 */
#define GPIO_MODER_MODER10               GPIO_MODER_MODER10_Msk
#define GPIO_MODER_MODER10_0             (0x1U << GPIO_MODER_MODER10_Pos)      /*!< 0x00100000 */
#define GPIO_MODER_MODER10_1             (0x2U << GPIO_MODER_MODER10_Pos)      /*!< 0x00200000 */

#define GPIO_MODER_MODER11_Pos           (22U)
#define GPIO_MODER_MODER11_Msk           (0x3U << GPIO_MODER_MODER11_Pos)      /*!< 0x00C00000 */
#define GPIO_MODER_MODER11               GPIO_MODER_MODER11_Msk
#define GPIO_MODER_MODER11_0             (0x1U << GPIO_MODER_MODER11_Pos)      /*!< 0x00400000 */
#define GPIO_MODER_MODER11_1             (0x2U << GPIO_MODER_MODER11_Pos)      /*!< 0x00800000 */

#define GPIO_MODER_MODER12_Pos           (24U)
#define GPIO_MODER_MODER12_Msk           (0x3U << GPIO_MODER_MODER12_Pos)      /*!< 0x03000000 */
#define GPIO_MODER_MODER12               GPIO_MODER_MODER12_Msk
#define GPIO_MODER_MODER12_0             (0x1U << GPIO_MODER_MODER12_Pos)      /*!< 0x01000000 */
#define GPIO_MODER_MODER12_1             (0x2U << GPIO_MODER_MODER12_Pos)      /*!< 0x02000000 */

#define GPIO_MODER_MODER13_Pos           (26U)
#define GPIO_MODER_MODER13_Msk           (0x3U << GPIO_MODER_MODER13_Pos)      /*!< 0x0C000000 */
#define GPIO_MODER_MODER13               GPIO_MODER_MODER13_Msk
#define GPIO_MODER_MODER13_0             (0x1U << GPIO_MODER_MODER13_Pos)      /*!< 0x04000000 */
#define GPIO_MODER_MODER13_1             (0x2U << GPIO_MODER_MODER13_Pos)      /*!< 0x08000000 */

#define GPIO_MODER_MODER14_Pos           (28U)
#define GPIO_MODER_MODER14_Msk           (0x3U << GPIO_MODER_MODER14_Pos)      /*!< 0x30000000 */
#define GPIO_MODER_MODER14               GPIO_MODER_MODER14_Msk
#define GPIO_MODER_MODER14_0             (0x1U << GPIO_MODER_MODER14_Pos)      /*!< 0x10000000 */
#define GPIO_MODER_MODER14_1             (0x2U << GPIO_MODER_MODER14_Pos)      /*!< 0x20000000 */

#define GPIO_MODER_MODER15_Pos           (30U)
#define GPIO_MODER_MODER15_Msk           (0x3U << GPIO_MODER_MODER15_Pos)      /*!< 0xC0000000 */
#define GPIO_MODER_MODER15               GPIO_MODER_MODER15_Msk
#define GPIO_MODER_MODER15_0             (0x1U << GPIO_MODER_MODER15_Pos)      /*!< 0x40000000 */
#define GPIO_MODER_MODER15_1             (0x2U << GPIO_MODER_MODER15_Pos)      /*!< 0x80000000 */

/******************  Bits definition for GPIO_OTYPER register  ****************/
#define GPIO_OTYPER_OT0_Pos            (0U)
#define GPIO_OTYPER_OT0_Msk            (0x1U << GPIO_OTYPER_OT0_Pos)           /*!< 0x00000001 */
#define GPIO_OTYPER_OT0                GPIO_OTYPER_OT0_Msk
#define GPIO_OTYPER_OT1_Pos            (1U)
#define GPIO_OTYPER_OT1_Msk            (0x1U << GPIO_OTYPER_OT1_Pos)           /*!< 0x00000002 */
#define GPIO_OTYPER_OT1                GPIO_OTYPER_OT1_Msk
#define GPIO_OTYPER_OT2_Pos            (2U)
#define GPIO_OTYPER_OT2_Msk            (0x1U << GPIO_OTYPER_OT2_Pos)           /*!< 0x00000004 */
#define GPIO_OTYPER_OT2                GPIO_OTYPER_OT2_Msk
#define GPIO_OTYPER_OT3_Pos            (3U)
#define GPIO_OTYPER_OT3_Msk            (0x1U << GPIO_OTYPER_OT3_Pos)           /*!< 0x00000008 */
#define GPIO_OTYPER_OT3                GPIO_OTYPER_OT3_Msk
#define GPIO_OTYPER_OT4_Pos            (4U)
#define GPIO_OTYPER_OT4_Msk            (0x1U << GPIO_OTYPER_OT4_Pos)           /*!< 0x00000010 */
#define GPIO_OTYPER_OT4                GPIO_OTYPER_OT4_Msk
#define GPIO_OTYPER_OT5_Pos            (5U)
#define GPIO_OTYPER_OT5_Msk            (0x1U << GPIO_OTYPER_OT5_Pos)           /*!< 0x00000020 */
#define GPIO_OTYPER_OT5                GPIO_OTYPER_OT5_Msk
#define GPIO_OTYPER_OT6_Pos            (6U)
#define GPIO_OTYPER_OT6_Msk            (0x1U << GPIO_OTYPER_OT6_Pos)           /*!< 0x00000040 */
#define GPIO_OTYPER_OT6                GPIO_OTYPER_OT6_Msk
#define GPIO_OTYPER_OT7_Pos            (7U)
#define GPIO_OTYPER_OT7_Msk            (0x1U << GPIO_OTYPER_OT7_Pos)           /*!< 0x00000080 */
#define GPIO_OTYPER_OT7                GPIO_OTYPER_OT7_Msk
#define GPIO_OTYPER_OT8_Pos            (8U)
#define GPIO_OTYPER_OT8_Msk            (0x1U << GPIO_OTYPER_OT8_Pos)           /*!< 0x00000100 */
#define GPIO_OTYPER_OT8                GPIO_OTYPER_OT8_Msk
#define GPIO_OTYPER_OT9_Pos            (9U)
#define GPIO_OTYPER_OT9_Msk            (0x1U << GPIO_OTYPER_OT9_Pos)           /*!< 0x00000200 */
#define GPIO_OTYPER_OT9                GPIO_OTYPER_OT9_Msk
#define GPIO_OTYPER_OT10_Pos           (10U)
#define GPIO_OTYPER_OT10_Msk           (0x1U << GPIO_OTYPER_OT10_Pos)          /*!< 0x00000400 */
#define GPIO_OTYPER_OT10               GPIO_OTYPER_OT10_Msk
#define GPIO_OTYPER_OT11_Pos           (11U)
#define GPIO_OTYPER_OT11_Msk           (0x1U << GPIO_OTYPER_OT11_Pos)          /*!< 0x00000800 */
#define GPIO_OTYPER_OT11               GPIO_OTYPER_OT11_Msk
#define GPIO_OTYPER_OT12_Pos           (12U)
#define GPIO_OTYPER_OT12_Msk           (0x1U << GPIO_OTYPER_OT12_Pos)          /*!< 0x00001000 */
#define GPIO_OTYPER_OT12               GPIO_OTYPER_OT12_Msk
#define GPIO_OTYPER_OT13_Pos           (13U)
#define GPIO_OTYPER_OT13_Msk           (0x1U << GPIO_OTYPER_OT13_Pos)          /*!< 0x00002000 */
#define GPIO_OTYPER_OT13               GPIO_OTYPER_OT13_Msk
#define GPIO_OTYPER_OT14_Pos           (14U)
#define GPIO_OTYPER_OT14_Msk           (0x1U << GPIO_OTYPER_OT14_Pos)          /*!< 0x00004000 */
#define GPIO_OTYPER_OT14               GPIO_OTYPER_OT14_Msk
#define GPIO_OTYPER_OT15_Pos           (15U)
#define GPIO_OTYPER_OT15_Msk           (0x1U << GPIO_OTYPER_OT15_Pos)          /*!< 0x00008000 */
#define GPIO_OTYPER_OT15               GPIO_OTYPER_OT15_Msk

/******************  Bits definition for GPIO_OSPEEDR register  ***************/
#define GPIO_OSPEEDR_OSPEEDR0_Pos       (0U)
#define GPIO_OSPEEDR_OSPEEDR0_Msk       (0x3U << GPIO_OSPEEDR_OSPEEDR0_Pos)  /*!< 0x00000003 */
#define GPIO_OSPEEDR_OSPEEDR0           GPIO_OSPEEDR_OSPEEDR0_Msk
#define GPIO_OSPEEDR_OSPEEDR0_0         (0x1U << GPIO_OSPEEDR_OSPEEDR0_Pos)  /*!< 0x00000001 */
#define GPIO_OSPEEDR_OSPEEDR0_1         (0x2U << GPIO_OSPEEDR_OSPEEDR0_Pos)  /*!< 0x00000002 */

#define GPIO_OSPEEDR_OSPEEDR1_Pos       (2U)
#define GPIO_OSPEEDR_OSPEEDR1_Msk       (0x3U << GPIO_OSPEEDR_OSPEEDR1_Pos)  /*!< 0x0000000C */
#define GPIO_OSPEEDR_OSPEEDR1           GPIO_OSPEEDR_OSPEEDR1_Msk
#define GPIO_OSPEEDR_OSPEEDR1_0         (0x1U << GPIO_OSPEEDR_OSPEEDR1_Pos)  /*!< 0x00000004 */
#define GPIO_OSPEEDR_OSPEEDR1_1         (0x2U << GPIO_OSPEEDR_OSPEEDR1_Pos)  /*!< 0x00000008 */

#define GPIO_OSPEEDR_OSPEEDR2_Pos       (4U)
#define GPIO_OSPEEDR_OSPEEDR2_Msk       (0x3U << GPIO_OSPEEDR_OSPEEDR2_Pos)  /*!< 0x00000030 */
#define GPIO_OSPEEDR_OSPEEDR2           GPIO_OSPEEDR_OSPEEDR2_Msk
#define GPIO_OSPEEDR_OSPEEDR2_0         (0x1U << GPIO_OSPEEDR_OSPEEDR2_Pos)  /*!< 0x00000010 */
#define GPIO_OSPEEDR_OSPEEDR2_1         (0x2U << GPIO_OSPEEDR_OSPEEDR2_Pos)  /*!< 0x00000020 */

#define GPIO_OSPEEDR_OSPEEDR3_Pos       (6U)
#define GPIO_OSPEEDR_OSPEEDR3_Msk       (0x3U << GPIO_OSPEEDR_OSPEEDR3_Pos)  /*!< 0x000000C0 */
#define GPIO_OSPEEDR_OSPEEDR3           GPIO_OSPEEDR_OSPEEDR3_Msk
#define GPIO_OSPEEDR_OSPEEDR3_0         (0x1U << GPIO_OSPEEDR_OSPEEDR3_Pos)  /*!< 0x00000040 */
#define GPIO_OSPEEDR_OSPEEDR3_1         (0x2U << GPIO_OSPEEDR_OSPEEDR3_Pos)  /*!< 0x00000080 */

#define GPIO_OSPEEDR_OSPEEDR4_Pos       (8U)
#define GPIO_OSPEEDR_OSPEEDR4_Msk       (0x3U << GPIO_OSPEEDR_OSPEEDR4_Pos)  /*!< 0x00000300 */
#define GPIO_OSPEEDR_OSPEEDR4           GPIO_OSPEEDR_OSPEEDR4_Msk
#define GPIO_OSPEEDR_OSPEEDR4_0         (0x1U << GPIO_OSPEEDR_OSPEEDR4_Pos)  /*!< 0x00000100 */
#define GPIO_OSPEEDR_OSPEEDR4_1         (0x2U << GPIO_OSPEEDR_OSPEEDR4_Pos)  /*!< 0x00000200 */

#define GPIO_OSPEEDR_OSPEEDR5_Pos       (10U)
#define GPIO_OSPEEDR_OSPEEDR5_Msk       (0x3U << GPIO_OSPEEDR_OSPEEDR5_Pos)  /*!< 0x00000C00 */
#define GPIO_OSPEEDR_OSPEEDR5           GPIO_OSPEEDR_OSPEEDR5_Msk
#define GPIO_OSPEEDR_OSPEEDR5_0         (0x1U << GPIO_OSPEEDR_OSPEEDR5_Pos)  /*!< 0x00000400 */
#define GPIO_OSPEEDR_OSPEEDR5_1         (0x2U << GPIO_OSPEEDR_OSPEEDR5_Pos)  /*!< 0x00000800 */

#define GPIO_OSPEEDR_OSPEEDR6_Pos       (12U)
#define GPIO_OSPEEDR_OSPEEDR6_Msk       (0x3U << GPIO_OSPEEDR_OSPEEDR6_Pos)  /*!< 0x00003000 */
#define GPIO_OSPEEDR_OSPEEDR6           GPIO_OSPEEDR_OSPEEDR6_Msk
#define GPIO_OSPEEDR_OSPEEDR6_0         (0x1U << GPIO_OSPEEDR_OSPEEDR6_Pos)  /*!< 0x00001000 */
#define GPIO_OSPEEDR_OSPEEDR6_1         (0x2U << GPIO_OSPEEDR_OSPEEDR6_Pos)  /*!< 0x00002000 */

#define GPIO_OSPEEDR_OSPEEDR7_Pos       (14U)
#define GPIO_OSPEEDR_OSPEEDR7_Msk       (0x3U << GPIO_OSPEEDR_OSPEEDR7_Pos)  /*!< 0x0000C000 */
#define GPIO_OSPEEDR_OSPEEDR7           GPIO_OSPEEDR_OSPEEDR7_Msk
#define GPIO_OSPEEDR_OSPEEDR7_0         (0x1U << GPIO_OSPEEDR_OSPEEDR7_Pos)  /*!< 0x00004000 */
#define GPIO_OSPEEDR_OSPEEDR7_1         (0x2U << GPIO_OSPEEDR_OSPEEDR7_Pos)  /*!< 0x00008000 */

#define GPIO_OSPEEDR_OSPEEDR8_Pos       (16U)
#define GPIO_OSPEEDR_OSPEEDR8_Msk       (0x3U << GPIO_OSPEEDR_OSPEEDR8_Pos)  /*!< 0x00030000 */
#define GPIO_OSPEEDR_OSPEEDR8           GPIO_OSPEEDR_OSPEEDR8_Msk
#define GPIO_OSPEEDR_OSPEEDR8_0         (0x1U << GPIO_OSPEEDR_OSPEEDR8_Pos)  /*!< 0x00010000 */
#define GPIO_OSPEEDR_OSPEEDR8_1         (0x2U << GPIO_OSPEEDR_OSPEEDR8_Pos)  /*!< 0x00020000 */

#define GPIO_OSPEEDR_OSPEEDR9_Pos       (18U)
#define GPIO_OSPEEDR_OSPEEDR9_Msk       (0x3U << GPIO_OSPEEDR_OSPEEDR9_Pos)  /*!< 0x000C0000 */
#define GPIO_OSPEEDR_OSPEEDR9           GPIO_OSPEEDR_OSPEEDR9_Msk
#define GPIO_OSPEEDR_OSPEEDR9_0         (0x1U << GPIO_OSPEEDR_OSPEEDR9_Pos)  /*!< 0x00040000 */
#define GPIO_OSPEEDR_OSPEEDR9_1         (0x2U << GPIO_OSPEEDR_OSPEEDR9_Pos)  /*!< 0x00080000 */

#define GPIO_OSPEEDR_OSPEEDR10_Pos      (20U)
#define GPIO_OSPEEDR_OSPEEDR10_Msk      (0x3U << GPIO_OSPEEDR_OSPEEDR10_Pos) /*!< 0x00300000 */
#define GPIO_OSPEEDR_OSPEEDR10          GPIO_OSPEEDR_OSPEEDR10_Msk
#define GPIO_OSPEEDR_OSPEEDR10_0        (0x1U << GPIO_OSPEEDR_OSPEEDR10_Pos) /*!< 0x00100000 */
#define GPIO_OSPEEDR_OSPEEDR10_1        (0x2U << GPIO_OSPEEDR_OSPEEDR10_Pos) /*!< 0x00200000 */

#define GPIO_OSPEEDR_OSPEEDR11_Pos      (22U)
#define GPIO_OSPEEDR_OSPEEDR11_Msk      (0x3U << GPIO_OSPEEDR_OSPEEDR11_Pos) /*!< 0x00C00000 */
#define GPIO_OSPEEDR_OSPEEDR11          GPIO_OSPEEDR_OSPEEDR11_Msk
#define GPIO_OSPEEDR_OSPEEDR11_0        (0x1U << GPIO_OSPEEDR_OSPEEDR11_Pos) /*!< 0x00400000 */
#define GPIO_OSPEEDR_OSPEEDR11_1        (0x2U << GPIO_OSPEEDR_OSPEEDR11_Pos) /*!< 0x00800000 */

#define GPIO_OSPEEDR_OSPEEDR12_Pos      (24U)
#define GPIO_OSPEEDR_OSPEEDR12_Msk      (0x3U << GPIO_OSPEEDR_OSPEEDR12_Pos) /*!< 0x03000000 */
#define GPIO_OSPEEDR_OSPEEDR12          GPIO_OSPEEDR_OSPEEDR12_Msk
#define GPIO_OSPEEDR_OSPEEDR12_0        (0x1U << GPIO_OSPEEDR_OSPEEDR12_Pos) /*!< 0x01000000 */
#define GPIO_OSPEEDR_OSPEEDR12_1        (0x2U << GPIO_OSPEEDR_OSPEEDR12_Pos) /*!< 0x02000000 */

#define GPIO_OSPEEDR_OSPEEDR13_Pos      (26U)
#define GPIO_OSPEEDR_OSPEEDR13_Msk      (0x3U << GPIO_OSPEEDR_OSPEEDR13_Pos) /*!< 0x0C000000 */
#define GPIO_OSPEEDR_OSPEEDR13          GPIO_OSPEEDR_OSPEEDR13_Msk
#define GPIO_OSPEEDR_OSPEEDR13_0        (0x1U << GPIO_OSPEEDR_OSPEEDR13_Pos) /*!< 0x04000000 */
#define GPIO_OSPEEDR_OSPEEDR13_1        (0x2U << GPIO_OSPEEDR_OSPEEDR13_Pos) /*!< 0x08000000 */

#define GPIO_OSPEEDR_OSPEEDR14_Pos      (28U)
#define GPIO_OSPEEDR_OSPEEDR14_Msk      (0x3U << GPIO_OSPEEDR_OSPEEDR14_Pos) /*!< 0x30000000 */
#define GPIO_OSPEEDR_OSPEEDR14          GPIO_OSPEEDR_OSPEEDR14_Msk
#define GPIO_OSPEEDR_OSPEEDR14_0        (0x1U << GPIO_OSPEEDR_OSPEEDR14_Pos) /*!< 0x10000000 */
#define GPIO_OSPEEDR_OSPEEDR14_1        (0x2U << GPIO_OSPEEDR_OSPEEDR14_Pos) /*!< 0x20000000 */

#define GPIO_OSPEEDR_OSPEEDR15_Pos      (30U)
#define GPIO_OSPEEDR_OSPEEDR15_Msk      (0x3U << GPIO_OSPEEDR_OSPEEDR15_Pos) /*!< 0xC0000000 */
#define GPIO_OSPEEDR_OSPEEDR15          GPIO_OSPEEDR_OSPEEDR15_Msk
#define GPIO_OSPEEDR_OSPEEDR15_0        (0x1U << GPIO_OSPEEDR_OSPEEDR15_Pos) /*!< 0x40000000 */
#define GPIO_OSPEEDR_OSPEEDR15_1        (0x2U << GPIO_OSPEEDR_OSPEEDR15_Pos) /*!< 0x80000000 */

/******************  Bits definition for GPIO_PUPDR register  *****************/
#define GPIO_PUPDR_PUPDR0_Pos            (0U)
#define GPIO_PUPDR_PUPDR0_Msk            (0x3U << GPIO_PUPDR_PUPDR0_Pos)       /*!< 0x00000003 */
#define GPIO_PUPDR_PUPDR0                GPIO_PUPDR_PUPDR0_Msk
#define GPIO_PUPDR_PUPDR0_0              (0x1U << GPIO_PUPDR_PUPDR0_Pos)       /*!< 0x00000001 */
#define GPIO_PUPDR_PUPDR0_1              (0x2U << GPIO_PUPDR_PUPDR0_Pos)       /*!< 0x00000002 */

#define GPIO_PUPDR_PUPDR1_Pos            (2U)
#define GPIO_PUPDR_PUPDR1_Msk            (0x3U << GPIO_PUPDR_PUPDR1_Pos)       /*!< 0x0000000C */
#define GPIO_PUPDR_PUPDR1                GPIO_PUPDR_PUPDR1_Msk
#define GPIO_PUPDR_PUPDR1_0              (0x1U << GPIO_PUPDR_PUPDR1_Pos)       /*!< 0x00000004 */
#define GPIO_PUPDR_PUPDR1_1              (0x2U << GPIO_PUPDR_PUPDR1_Pos)       /*!< 0x00000008 */

#define GPIO_PUPDR_PUPDR2_Pos            (4U)
#define GPIO_PUPDR_PUPDR2_Msk            (0x3U << GPIO_PUPDR_PUPDR2_Pos)       /*!< 0x00000030 */
#define GPIO_PUPDR_PUPDR2                GPIO_PUPDR_PUPDR2_Msk
#define GPIO_PUPDR_PUPDR2_0              (0x1U << GPIO_PUPDR_PUPDR2_Pos)       /*!< 0x00000010 */
#define GPIO_PUPDR_PUPDR2_1              (0x2U << GPIO_PUPDR_PUPDR2_Pos)       /*!< 0x00000020 */

#define GPIO_PUPDR_PUPDR3_Pos            (6U)
#define GPIO_PUPDR_PUPDR3_Msk            (0x3U << GPIO_PUPDR_PUPDR3_Pos)       /*!< 0x000000C0 */
#define GPIO_PUPDR_PUPDR3                GPIO_PUPDR_PUPDR3_Msk
#define GPIO_PUPDR_PUPDR3_0              (0x1U << GPIO_PUPDR_PUPDR3_Pos)       /*!< 0x00000040 */
#define GPIO_PUPDR_PUPDR3_1              (0x2U << GPIO_PUPDR_PUPDR3_Pos)       /*!< 0x00000080 */

#define GPIO_PUPDR_PUPDR4_Pos            (8U)
#define GPIO_PUPDR_PUPDR4_Msk            (0x3U << GPIO_PUPDR_PUPDR4_Pos)       /*!< 0x00000300 */
#define GPIO_PUPDR_PUPDR4                GPIO_PUPDR_PUPDR4_Msk
#define GPIO_PUPDR_PUPDR4_0              (0x1U << GPIO_PUPDR_PUPDR4_Pos)       /*!< 0x00000100 */
#define GPIO_PUPDR_PUPDR4_1              (0x2U << GPIO_PUPDR_PUPDR4_Pos)       /*!< 0x00000200 */

#define GPIO_PUPDR_PUPDR5_Pos            (10U)
#define GPIO_PUPDR_PUPDR5_Msk            (0x3U << GPIO_PUPDR_PUPDR5_Pos)       /*!< 0x00000C00 */
#define GPIO_PUPDR_PUPDR5                GPIO_PUPDR_PUPDR5_Msk
#define GPIO_PUPDR_PUPDR5_0              (0x1U << GPIO_PUPDR_PUPDR5_Pos)       /*!< 0x00000400 */
#define GPIO_PUPDR_PUPDR5_1              (0x2U << GPIO_PUPDR_PUPDR5_Pos)       /*!< 0x00000800 */

#define GPIO_PUPDR_PUPDR6_Pos            (12U)
#define GPIO_PUPDR_PUPDR6_Msk            (0x3U << GPIO_PUPDR_PUPDR6_Pos)       /*!< 0x00003000 */
#define GPIO_PUPDR_PUPDR6                GPIO_PUPDR_PUPDR6_Msk
#define GPIO_PUPDR_PUPDR6_0              (0x1U << GPIO_PUPDR_PUPDR6_Pos)       /*!< 0x00001000 */
#define GPIO_PUPDR_PUPDR6_1              (0x2U << GPIO_PUPDR_PUPDR6_Pos)       /*!< 0x00002000 */

#define GPIO_PUPDR_PUPDR7_Pos            (14U)
#define GPIO_PUPDR_PUPDR7_Msk            (0x3U << GPIO_PUPDR_PUPDR7_Pos)       /*!< 0x0000C000 */
#define GPIO_PUPDR_PUPDR7                GPIO_PUPDR_PUPDR7_Msk
#define GPIO_PUPDR_PUPDR7_0              (0x1U << GPIO_PUPDR_PUPDR7_Pos)       /*!< 0x00004000 */
#define GPIO_PUPDR_PUPDR7_1              (0x2U << GPIO_PUPDR_PUPDR7_Pos)       /*!< 0x00008000 */

#define GPIO_PUPDR_PUPDR8_Pos            (16U)
#define GPIO_PUPDR_PUPDR8_Msk            (0x3U << GPIO_PUPDR_PUPDR8_Pos)       /*!< 0x00030000 */
#define GPIO_PUPDR_PUPDR8                GPIO_PUPDR_PUPDR8_Msk
#define GPIO_PUPDR_PUPDR8_0              (0x1U << GPIO_PUPDR_PUPDR8_Pos)       /*!< 0x00010000 */
#define GPIO_PUPDR_PUPDR8_1              (0x2U << GPIO_PUPDR_PUPDR8_Pos)       /*!< 0x00020000 */

#define GPIO_PUPDR_PUPDR9_Pos            (18U)
#define GPIO_PUPDR_PUPDR9_Msk            (0x3U << GPIO_PUPDR_PUPDR9_Pos)       /*!< 0x000C0000 */
#define GPIO_PUPDR_PUPDR9                GPIO_PUPDR_PUPDR9_Msk
#define GPIO_PUPDR_PUPDR9_0              (0x1U << GPIO_PUPDR_PUPDR9_Pos)       /*!< 0x00040000 */
#define GPIO_PUPDR_PUPDR9_1              (0x2U << GPIO_PUPDR_PUPDR9_Pos)       /*!< 0x00080000 */

#define GPIO_PUPDR_PUPDR10_Pos           (20U)
#define GPIO_PUPDR_PUPDR10_Msk           (0x3U << GPIO_PUPDR_PUPDR10_Pos)      /*!< 0x00300000 */
#define GPIO_PUPDR_PUPDR10               GPIO_PUPDR_PUPDR10_Msk
#define GPIO_PUPDR_PUPDR10_0             (0x1U << GPIO_PUPDR_PUPDR10_Pos)      /*!< 0x00100000 */
#define GPIO_PUPDR_PUPDR10_1             (0x2U << GPIO_PUPDR_PUPDR10_Pos)      /*!< 0x00200000 */

#define GPIO_PUPDR_PUPDR11_Pos           (22U)
#define GPIO_PUPDR_PUPDR11_Msk           (0x3U << GPIO_PUPDR_PUPDR11_Pos)      /*!< 0x00C00000 */
#define GPIO_PUPDR_PUPDR11               GPIO_PUPDR_PUPDR11_Msk
#define GPIO_PUPDR_PUPDR11_0             (0x1U << GPIO_PUPDR_PUPDR11_Pos)      /*!< 0x00400000 */
#define GPIO_PUPDR_PUPDR11_1             (0x2U << GPIO_PUPDR_PUPDR11_Pos)      /*!< 0x00800000 */

#define GPIO_PUPDR_PUPDR12_Pos           (24U)
#define GPIO_PUPDR_PUPDR12_Msk           (0x3U << GPIO_PUPDR_PUPDR12_Pos)      /*!< 0x03000000 */
#define GPIO_PUPDR_PUPDR12               GPIO_PUPDR_PUPDR12_Msk
#define GPIO_PUPDR_PUPDR12_0             (0x1U << GPIO_PUPDR_PUPDR12_Pos)      /*!< 0x01000000 */
#define GPIO_PUPDR_PUPDR12_1             (0x2U << GPIO_PUPDR_PUPDR12_Pos)      /*!< 0x02000000 */

#define GPIO_PUPDR_PUPDR13_Pos           (26U)
#define GPIO_PUPDR_PUPDR13_Msk           (0x3U << GPIO_PUPDR_PUPDR13_Pos)      /*!< 0x0C000000 */
#define GPIO_PUPDR_PUPDR13               GPIO_PUPDR_PUPDR13_Msk
#define GPIO_PUPDR_PUPDR13_0             (0x1U << GPIO_PUPDR_PUPDR13_Pos)      /*!< 0x04000000 */
#define GPIO_PUPDR_PUPDR13_1             (0x2U << GPIO_PUPDR_PUPDR13_Pos)      /*!< 0x08000000 */

#define GPIO_PUPDR_PUPDR14_Pos           (28U)
#define GPIO_PUPDR_PUPDR14_Msk           (0x3U << GPIO_PUPDR_PUPDR14_Pos)      /*!< 0x30000000 */
#define GPIO_PUPDR_PUPDR14               GPIO_PUPDR_PUPDR14_Msk
#define GPIO_PUPDR_PUPDR14_0             (0x1U << GPIO_PUPDR_PUPDR14_Pos)      /*!< 0x10000000 */
#define GPIO_PUPDR_PUPDR14_1             (0x2U << GPIO_PUPDR_PUPDR14_Pos)      /*!< 0x20000000 */

#define GPIO_PUPDR_PUPDR15_Pos           (30U)
#define GPIO_PUPDR_PUPDR15_Msk           (0x3U << GPIO_PUPDR_PUPDR15_Pos)      /*!< 0xC0000000 */
#define GPIO_PUPDR_PUPDR15               GPIO_PUPDR_PUPDR15_Msk
#define GPIO_PUPDR_PUPDR15_0             (0x1U << GPIO_PUPDR_PUPDR15_Pos)      /*!< 0x40000000 */
#define GPIO_PUPDR_PUPDR15_1             (0x2U << GPIO_PUPDR_PUPDR15_Pos)      /*!< 0x80000000 */

/******************  Bits definition for GPIO_IDR register  *******************/
#define GPIO_IDR_ID0_Pos               (0U)
#define GPIO_IDR_ID0_Msk               (0x1U << GPIO_IDR_ID0_Pos)              /*!< 0x00000001 */
#define GPIO_IDR_ID0                   GPIO_IDR_ID0_Msk
#define GPIO_IDR_ID1_Pos               (1U)
#define GPIO_IDR_ID1_Msk               (0x1U << GPIO_IDR_ID1_Pos)              /*!< 0x00000002 */
#define GPIO_IDR_ID1                   GPIO_IDR_ID1_Msk
#define GPIO_IDR_ID2_Pos               (2U)
#define GPIO_IDR_ID2_Msk               (0x1U << GPIO_IDR_ID2_Pos)              /*!< 0x00000004 */
#define GPIO_IDR_ID2                   GPIO_IDR_ID2_Msk
#define GPIO_IDR_ID3_Pos               (3U)
#define GPIO_IDR_ID3_Msk               (0x1U << GPIO_IDR_ID3_Pos)              /*!< 0x00000008 */
#define GPIO_IDR_ID3                   GPIO_IDR_ID3_Msk
#define GPIO_IDR_ID4_Pos               (4U)
#define GPIO_IDR_ID4_Msk               (0x1U << GPIO_IDR_ID4_Pos)              /*!< 0x00000010 */
#define GPIO_IDR_ID4                   GPIO_IDR_ID4_Msk
#define GPIO_IDR_ID5_Pos               (5U)
#define GPIO_IDR_ID5_Msk               (0x1U << GPIO_IDR_ID5_Pos)              /*!< 0x00000020 */
#define GPIO_IDR_ID5                   GPIO_IDR_ID5_Msk
#define GPIO_IDR_ID6_Pos               (6U)
#define GPIO_IDR_ID6_Msk               (0x1U << GPIO_IDR_ID6_Pos)              /*!< 0x00000040 */
#define GPIO_IDR_ID6                   GPIO_IDR_ID6_Msk
#define GPIO_IDR_ID7_Pos               (7U)
#define GPIO_IDR_ID7_Msk               (0x1U << GPIO_IDR_ID7_Pos)              /*!< 0x00000080 */
#define GPIO_IDR_ID7                   GPIO_IDR_ID7_Msk
#define GPIO_IDR_ID8_Pos               (8U)
#define GPIO_IDR_ID8_Msk               (0x1U << GPIO_IDR_ID8_Pos)              /*!< 0x00000100 */
#define GPIO_IDR_ID8                   GPIO_IDR_ID8_Msk
#define GPIO_IDR_ID9_Pos               (9U)
#define GPIO_IDR_ID9_Msk               (0x1U << GPIO_IDR_ID9_Pos)              /*!< 0x00000200 */
#define GPIO_IDR_ID9                   GPIO_IDR_ID9_Msk
#define GPIO_IDR_ID10_Pos              (10U)
#define GPIO_IDR_ID10_Msk              (0x1U << GPIO_IDR_ID10_Pos)             /*!< 0x00000400 */
#define GPIO_IDR_ID10                  GPIO_IDR_ID10_Msk
#define GPIO_IDR_ID11_Pos              (11U)
#define GPIO_IDR_ID11_Msk              (0x1U << GPIO_IDR_ID11_Pos)             /*!< 0x00000800 */
#define GPIO_IDR_ID11                  GPIO_IDR_ID11_Msk
#define GPIO_IDR_ID12_Pos              (12U)
#define GPIO_IDR_ID12_Msk              (0x1U << GPIO_IDR_ID12_Pos)             /*!< 0x00001000 */
#define GPIO_IDR_ID12                  GPIO_IDR_ID12_Msk
#define GPIO_IDR_ID13_Pos              (13U)
#define GPIO_IDR_ID13_Msk              (0x1U << GPIO_IDR_ID13_Pos)             /*!< 0x00002000 */
#define GPIO_IDR_ID13                  GPIO_IDR_ID13_Msk
#define GPIO_IDR_ID14_Pos              (14U)
#define GPIO_IDR_ID14_Msk              (0x1U << GPIO_IDR_ID14_Pos)             /*!< 0x00004000 */
#define GPIO_IDR_ID14                  GPIO_IDR_ID14_Msk
#define GPIO_IDR_ID15_Pos              (15U)
#define GPIO_IDR_ID15_Msk              (0x1U << GPIO_IDR_ID15_Pos)             /*!< 0x00008000 */
#define GPIO_IDR_ID15                  GPIO_IDR_ID15_Msk

/******************  Bits definition for GPIO_ODR register  *******************/
#define GPIO_ODR_OD0_Pos               (0U)
#define GPIO_ODR_OD0_Msk               (0x1U << GPIO_ODR_OD0_Pos)              /*!< 0x00000001 */
#define GPIO_ODR_OD0                   GPIO_ODR_OD0_Msk
#define GPIO_ODR_OD1_Pos               (1U)
#define GPIO_ODR_OD1_Msk               (0x1U << GPIO_ODR_OD1_Pos)              /*!< 0x00000002 */
#define GPIO_ODR_OD1                   GPIO_ODR_OD1_Msk
#define GPIO_ODR_OD2_Pos               (2U)
#define GPIO_ODR_OD2_Msk               (0x1U << GPIO_ODR_OD2_Pos)              /*!< 0x00000004 */
#define GPIO_ODR_OD2                   GPIO_ODR_OD2_Msk
#define GPIO_ODR_OD3_Pos               (3U)
#define GPIO_ODR_OD3_Msk               (0x1U << GPIO_ODR_OD3_Pos)              /*!< 0x00000008 */
#define GPIO_ODR_OD3                   GPIO_ODR_OD3_Msk
#define GPIO_ODR_OD4_Pos               (4U)
#define GPIO_ODR_OD4_Msk               (0x1U << GPIO_ODR_OD4_Pos)              /*!< 0x00000010 */
#define GPIO_ODR_OD4                   GPIO_ODR_OD4_Msk
#define GPIO_ODR_OD5_Pos               (5U)
#define GPIO_ODR_OD5_Msk               (0x1U << GPIO_ODR_OD5_Pos)              /*!< 0x00000020 */
#define GPIO_ODR_OD5                   GPIO_ODR_OD5_Msk
#define GPIO_ODR_OD6_Pos               (6U)
#define GPIO_ODR_OD6_Msk               (0x1U << GPIO_ODR_OD6_Pos)              /*!< 0x00000040 */
#define GPIO_ODR_OD6                   GPIO_ODR_OD6_Msk
#define GPIO_ODR_OD7_Pos               (7U)
#define GPIO_ODR_OD7_Msk               (0x1U << GPIO_ODR_OD7_Pos)              /*!< 0x00000080 */
#define GPIO_ODR_OD7                   GPIO_ODR_OD7_Msk
#define GPIO_ODR_OD8_Pos               (8U)
#define GPIO_ODR_OD8_Msk               (0x1U << GPIO_ODR_OD8_Pos)              /*!< 0x00000100 */
#define GPIO_ODR_OD8                   GPIO_ODR_OD8_Msk
#define GPIO_ODR_OD9_Pos               (9U)
#define GPIO_ODR_OD9_Msk               (0x1U << GPIO_ODR_OD9_Pos)              /*!< 0x00000200 */
#define GPIO_ODR_OD9                   GPIO_ODR_OD9_Msk
#define GPIO_ODR_OD10_Pos              (10U)
#define GPIO_ODR_OD10_Msk              (0x1U << GPIO_ODR_OD10_Pos)             /*!< 0x00000400 */
#define GPIO_ODR_OD10                  GPIO_ODR_OD10_Msk
#define GPIO_ODR_OD11_Pos              (11U)
#define GPIO_ODR_OD11_Msk              (0x1U << GPIO_ODR_OD11_Pos)             /*!< 0x00000800 */
#define GPIO_ODR_OD11                  GPIO_ODR_OD11_Msk
#define GPIO_ODR_OD12_Pos              (12U)
#define GPIO_ODR_OD12_Msk              (0x1U << GPIO_ODR_OD12_Pos)             /*!< 0x00001000 */
#define GPIO_ODR_OD12                  GPIO_ODR_OD12_Msk
#define GPIO_ODR_OD13_Pos              (13U)
#define GPIO_ODR_OD13_Msk              (0x1U << GPIO_ODR_OD13_Pos)             /*!< 0x00002000 */
#define GPIO_ODR_OD13                  GPIO_ODR_OD13_Msk
#define GPIO_ODR_OD14_Pos              (14U)
#define GPIO_ODR_OD14_Msk              (0x1U << GPIO_ODR_OD14_Pos)             /*!< 0x00004000 */
#define GPIO_ODR_OD14                  GPIO_ODR_OD14_Msk
#define GPIO_ODR_OD15_Pos              (15U)
#define GPIO_ODR_OD15_Msk              (0x1U << GPIO_ODR_OD15_Pos)             /*!< 0x00008000 */
#define GPIO_ODR_OD15                  GPIO_ODR_OD15_Msk

/******************  Bits definition for GPIO_BSRR register  ******************/
#define GPIO_BSRR_BS0_Pos              (0U)
#define GPIO_BSRR_BS0_Msk              (0x1U << GPIO_BSRR_BS0_Pos)             /*!< 0x00000001 */
#define GPIO_BSRR_BS0                  GPIO_BSRR_BS0_Msk
#define GPIO_BSRR_BS1_Pos              (1U)
#define GPIO_BSRR_BS1_Msk              (0x1U << GPIO_BSRR_BS1_Pos)             /*!< 0x00000002 */
#define GPIO_BSRR_BS1                  GPIO_BSRR_BS1_Msk
#define GPIO_BSRR_BS2_Pos              (2U)
#define GPIO_BSRR_BS2_Msk              (0x1U << GPIO_BSRR_BS2_Pos)             /*!< 0x00000004 */
#define GPIO_BSRR_BS2                  GPIO_BSRR_BS2_Msk
#define GPIO_BSRR_BS3_Pos              (3U)
#define GPIO_BSRR_BS3_Msk              (0x1U << GPIO_BSRR_BS3_Pos)             /*!< 0x00000008 */
#define GPIO_BSRR_BS3                  GPIO_BSRR_BS3_Msk
#define GPIO_BSRR_BS4_Pos              (4U)
#define GPIO_BSRR_BS4_Msk              (0x1U << GPIO_BSRR_BS4_Pos)             /*!< 0x00000010 */
#define GPIO_BSRR_BS4                  GPIO_BSRR_BS4_Msk
#define GPIO_BSRR_BS5_Pos              (5U)
#define GPIO_BSRR_BS5_Msk              (0x1U << GPIO_BSRR_BS5_Pos)             /*!< 0x00000020 */
#define GPIO_BSRR_BS5                  GPIO_BSRR_BS5_Msk
#define GPIO_BSRR_BS6_Pos              (6U)
#define GPIO_BSRR_BS6_Msk              (0x1U << GPIO_BSRR_BS6_Pos)             /*!< 0x00000040 */
#define GPIO_BSRR_BS6                  GPIO_BSRR_BS6_Msk
#define GPIO_BSRR_BS7_Pos              (7U)
#define GPIO_BSRR_BS7_Msk              (0x1U << GPIO_BSRR_BS7_Pos)             /*!< 0x00000080 */
#define GPIO_BSRR_BS7                  GPIO_BSRR_BS7_Msk
#define GPIO_BSRR_BS8_Pos              (8U)
#define GPIO_BSRR_BS8_Msk              (0x1U << GPIO_BSRR_BS8_Pos)             /*!< 0x00000100 */
#define GPIO_BSRR_BS8                  GPIO_BSRR_BS8_Msk
#define GPIO_BSRR_BS9_Pos              (9U)
#define GPIO_BSRR_BS9_Msk              (0x1U << GPIO_BSRR_BS9_Pos)             /*!< 0x00000200 */
#define GPIO_BSRR_BS9                  GPIO_BSRR_BS9_Msk
#define GPIO_BSRR_BS10_Pos             (10U)
#define GPIO_BSRR_BS10_Msk             (0x1U << GPIO_BSRR_BS10_Pos)            /*!< 0x00000400 */
#define GPIO_BSRR_BS10                 GPIO_BSRR_BS10_Msk
#define GPIO_BSRR_BS11_Pos             (11U)
#define GPIO_BSRR_BS11_Msk             (0x1U << GPIO_BSRR_BS11_Pos)            /*!< 0x00000800 */
#define GPIO_BSRR_BS11                 GPIO_BSRR_BS11_Msk
#define GPIO_BSRR_BS12_Pos             (12U)
#define GPIO_BSRR_BS12_Msk             (0x1U << GPIO_BSRR_BS12_Pos)            /*!< 0x00001000 */
#define GPIO_BSRR_BS12                 GPIO_BSRR_BS12_Msk
#define GPIO_BSRR_BS13_Pos             (13U)
#define GPIO_BSRR_BS13_Msk             (0x1U << GPIO_BSRR_BS13_Pos)            /*!< 0x00002000 */
#define GPIO_BSRR_BS13                 GPIO_BSRR_BS13_Msk
#define GPIO_BSRR_BS14_Pos             (14U)
#define GPIO_BSRR_BS14_Msk             (0x1U << GPIO_BSRR_BS14_Pos)            /*!< 0x00004000 */
#define GPIO_BSRR_BS14                 GPIO_BSRR_BS14_Msk
#define GPIO_BSRR_BS15_Pos             (15U)
#define GPIO_BSRR_BS15_Msk             (0x1U << GPIO_BSRR_BS15_Pos)            /*!< 0x00008000 */
#define GPIO_BSRR_BS15                 GPIO_BSRR_BS15_Msk
#define GPIO_BSRR_BR0_Pos              (16U)
#define GPIO_BSRR_BR0_Msk              (0x1U << GPIO_BSRR_BR0_Pos)             /*!< 0x00010000 */
#define GPIO_BSRR_BR0                  GPIO_BSRR_BR0_Msk
#define GPIO_BSRR_BR1_Pos              (17U)
#define GPIO_BSRR_BR1_Msk              (0x1U << GPIO_BSRR_BR1_Pos)             /*!< 0x00020000 */
#define GPIO_BSRR_BR1                  GPIO_BSRR_BR1_Msk
#define GPIO_BSRR_BR2_Pos              (18U)
#define GPIO_BSRR_BR2_Msk              (0x1U << GPIO_BSRR_BR2_Pos)             /*!< 0x00040000 */
#define GPIO_BSRR_BR2                  GPIO_BSRR_BR2_Msk
#define GPIO_BSRR_BR3_Pos              (19U)
#define GPIO_BSRR_BR3_Msk              (0x1U << GPIO_BSRR_BR3_Pos)             /*!< 0x00080000 */
#define GPIO_BSRR_BR3                  GPIO_BSRR_BR3_Msk
#define GPIO_BSRR_BR4_Pos              (20U)
#define GPIO_BSRR_BR4_Msk              (0x1U << GPIO_BSRR_BR4_Pos)             /*!< 0x00100000 */
#define GPIO_BSRR_BR4                  GPIO_BSRR_BR4_Msk
#define GPIO_BSRR_BR5_Pos              (21U)
#define GPIO_BSRR_BR5_Msk              (0x1U << GPIO_BSRR_BR5_Pos)             /*!< 0x00200000 */
#define GPIO_BSRR_BR5                  GPIO_BSRR_BR5_Msk
#define GPIO_BSRR_BR6_Pos              (22U)
#define GPIO_BSRR_BR6_Msk              (0x1U << GPIO_BSRR_BR6_Pos)             /*!< 0x00400000 */
#define GPIO_BSRR_BR6                  GPIO_BSRR_BR6_Msk
#define GPIO_BSRR_BR7_Pos              (23U)
#define GPIO_BSRR_BR7_Msk              (0x1U << GPIO_BSRR_BR7_Pos)             /*!< 0x00800000 */
#define GPIO_BSRR_BR7                  GPIO_BSRR_BR7_Msk
#define GPIO_BSRR_BR8_Pos              (24U)
#define GPIO_BSRR_BR8_Msk              (0x1U << GPIO_BSRR_BR8_Pos)             /*!< 0x01000000 */
#define GPIO_BSRR_BR8                  GPIO_BSRR_BR8_Msk
#define GPIO_BSRR_BR9_Pos              (25U)
#define GPIO_BSRR_BR9_Msk              (0x1U << GPIO_BSRR_BR9_Pos)             /*!< 0x02000000 */
#define GPIO_BSRR_BR9                  GPIO_BSRR_BR9_Msk
#define GPIO_BSRR_BR10_Pos             (26U)
#define GPIO_BSRR_BR10_Msk             (0x1U << GPIO_BSRR_BR10_Pos)            /*!< 0x04000000 */
#define GPIO_BSRR_BR10                 GPIO_BSRR_BR10_Msk
#define GPIO_BSRR_BR11_Pos             (27U)
#define GPIO_BSRR_BR11_Msk             (0x1U << GPIO_BSRR_BR11_Pos)            /*!< 0x08000000 */
#define GPIO_BSRR_BR11                 GPIO_BSRR_BR11_Msk
#define GPIO_BSRR_BR12_Pos             (28U)
#define GPIO_BSRR_BR12_Msk             (0x1U << GPIO_BSRR_BR12_Pos)            /*!< 0x10000000 */
#define GPIO_BSRR_BR12                 GPIO_BSRR_BR12_Msk
#define GPIO_BSRR_BR13_Pos             (29U)
#define GPIO_BSRR_BR13_Msk             (0x1U << GPIO_BSRR_BR13_Pos)            /*!< 0x20000000 */
#define GPIO_BSRR_BR13                 GPIO_BSRR_BR13_Msk
#define GPIO_BSRR_BR14_Pos             (30U)
#define GPIO_BSRR_BR14_Msk             (0x1U << GPIO_BSRR_BR14_Pos)            /*!< 0x40000000 */
#define GPIO_BSRR_BR14                 GPIO_BSRR_BR14_Msk
#define GPIO_BSRR_BR15_Pos             (31U)
#define GPIO_BSRR_BR15_Msk             (0x1U << GPIO_BSRR_BR15_Pos)            /*!< 0x80000000 */
#define GPIO_BSRR_BR15                 GPIO_BSRR_BR15_Msk

/****************** Bit definition for GPIO_LCKR register *********************/
#define GPIO_LCKR_LCK0_Pos             (0U)
#define GPIO_LCKR_LCK0_Msk             (0x1U << GPIO_LCKR_LCK0_Pos)            /*!< 0x00000001 */
#define GPIO_LCKR_LCK0                 GPIO_LCKR_LCK0_Msk
#define GPIO_LCKR_LCK1_Pos             (1U)
#define GPIO_LCKR_LCK1_Msk             (0x1U << GPIO_LCKR_LCK1_Pos)            /*!< 0x00000002 */
#define GPIO_LCKR_LCK1                 GPIO_LCKR_LCK1_Msk
#define GPIO_LCKR_LCK2_Pos             (2U)
#define GPIO_LCKR_LCK2_Msk             (0x1U << GPIO_LCKR_LCK2_Pos)            /*!< 0x00000004 */
#define GPIO_LCKR_LCK2                 GPIO_LCKR_LCK2_Msk
#define GPIO_LCKR_LCK3_Pos             (3U)
#define GPIO_LCKR_LCK3_Msk             (0x1U << GPIO_LCKR_LCK3_Pos)            /*!< 0x00000008 */
#define GPIO_LCKR_LCK3                 GPIO_LCKR_LCK3_Msk
#define GPIO_LCKR_LCK4_Pos             (4U)
#define GPIO_LCKR_LCK4_Msk             (0x1U << GPIO_LCKR_LCK4_Pos)            /*!< 0x00000010 */
#define GPIO_LCKR_LCK4                 GPIO_LCKR_LCK4_Msk
#define GPIO_LCKR_LCK5_Pos             (5U)
#define GPIO_LCKR_LCK5_Msk             (0x1U << GPIO_LCKR_LCK5_Pos)            /*!< 0x00000020 */
#define GPIO_LCKR_LCK5                 GPIO_LCKR_LCK5_Msk
#define GPIO_LCKR_LCK6_Pos             (6U)
#define GPIO_LCKR_LCK6_Msk             (0x1U << GPIO_LCKR_LCK6_Pos)            /*!< 0x00000040 */
#define GPIO_LCKR_LCK6                 GPIO_LCKR_LCK6_Msk
#define GPIO_LCKR_LCK7_Pos             (7U)
#define GPIO_LCKR_LCK7_Msk             (0x1U << GPIO_LCKR_LCK7_Pos)            /*!< 0x00000080 */
#define GPIO_LCKR_LCK7                 GPIO_LCKR_LCK7_Msk
#define GPIO_LCKR_LCK8_Pos             (8U)
#define GPIO_LCKR_LCK8_Msk             (0x1U << GPIO_LCKR_LCK8_Pos)            /*!< 0x00000100 */
#define GPIO_LCKR_LCK8                 GPIO_LCKR_LCK8_Msk
#define GPIO_LCKR_LCK9_Pos             (9U)
#define GPIO_LCKR_LCK9_Msk             (0x1U << GPIO_LCKR_LCK9_Pos)            /*!< 0x00000200 */
#define GPIO_LCKR_LCK9                 GPIO_LCKR_LCK9_Msk
#define GPIO_LCKR_LCK10_Pos            (10U)
#define GPIO_LCKR_LCK10_Msk            (0x1U << GPIO_LCKR_LCK10_Pos)           /*!< 0x00000400 */
#define GPIO_LCKR_LCK10                GPIO_LCKR_LCK10_Msk
#define GPIO_LCKR_LCK11_Pos            (11U)
#define GPIO_LCKR_LCK11_Msk            (0x1U << GPIO_LCKR_LCK11_Pos)           /*!< 0x00000800 */
#define GPIO_LCKR_LCK11                GPIO_LCKR_LCK11_Msk
#define GPIO_LCKR_LCK12_Pos            (12U)
#define GPIO_LCKR_LCK12_Msk            (0x1U << GPIO_LCKR_LCK12_Pos)           /*!< 0x00001000 */
#define GPIO_LCKR_LCK12                GPIO_LCKR_LCK12_Msk
#define GPIO_LCKR_LCK13_Pos            (13U)
#define GPIO_LCKR_LCK13_Msk            (0x1U << GPIO_LCKR_LCK13_Pos)           /*!< 0x00002000 */
#define GPIO_LCKR_LCK13                GPIO_LCKR_LCK13_Msk
#define GPIO_LCKR_LCK14_Pos            (14U)
#define GPIO_LCKR_LCK14_Msk            (0x1U << GPIO_LCKR_LCK14_Pos)           /*!< 0x00004000 */
#define GPIO_LCKR_LCK14                GPIO_LCKR_LCK14_Msk
#define GPIO_LCKR_LCK15_Pos            (15U)
#define GPIO_LCKR_LCK15_Msk            (0x1U << GPIO_LCKR_LCK15_Pos)           /*!< 0x00008000 */
#define GPIO_LCKR_LCK15                GPIO_LCKR_LCK15_Msk
#define GPIO_LCKR_LCKK_Pos             (16U)
#define GPIO_LCKR_LCKK_Msk             (0x1U << GPIO_LCKR_LCKK_Pos)            /*!< 0x00010000 */
#define GPIO_LCKR_LCKK                 GPIO_LCKR_LCKK_Msk

/****************** Bit definition for GPIO_AFRL register *********************/
#define GPIO_AFRL_AFSEL0_Pos           (0U)
#define GPIO_AFRL_AFSEL0_Msk           (0xFU << GPIO_AFRL_AFSEL0_Pos)          /*!< 0x0000000F */
#define GPIO_AFRL_AFSEL0               GPIO_AFRL_AFSEL0_Msk
#define GPIO_AFRL_AFSEL0_0             (0x1U << GPIO_AFRL_AFSEL0_Pos)          /*!< 0x00000001 */
#define GPIO_AFRL_AFSEL0_1             (0x2U << GPIO_AFRL_AFSEL0_Pos)          /*!< 0x00000002 */
#define GPIO_AFRL_AFSEL0_2             (0x4U << GPIO_AFRL_AFSEL0_Pos)          /*!< 0x00000004 */
#define GPIO_AFRL_AFSEL0_3             (0x8U << GPIO_AFRL_AFSEL0_Pos)          /*!< 0x00000008 */
#define GPIO_AFRL_AFSEL1_Pos           (4U)
#define GPIO_AFRL_AFSEL1_Msk           (0xFU << GPIO_AFRL_AFSEL1_Pos)          /*!< 0x000000F0 */
#define GPIO_AFRL_AFSEL1               GPIO_AFRL_AFSEL1_Msk
#define GPIO_AFRL_AFSEL1_0             (0x1U << GPIO_AFRL_AFSEL1_Pos)          /*!< 0x00000010 */
#define GPIO_AFRL_AFSEL1_1             (0x2U << GPIO_AFRL_AFSEL1_Pos)          /*!< 0x00000020 */
#define GPIO_AFRL_AFSEL1_2             (0x4U << GPIO_AFRL_AFSEL1_Pos)          /*!< 0x00000040 */
#define GPIO_AFRL_AFSEL1_3             (0x8U << GPIO_AFRL_AFSEL1_Pos)          /*!< 0x00000080 */
#define GPIO_AFRL_AFSEL2_Pos           (8U)
#define GPIO_AFRL_AFSEL2_Msk           (0xFU << GPIO_AFRL_AFSEL2_Pos)          /*!< 0x00000F00 */
#define GPIO_AFRL_AFSEL2               GPIO_AFRL_AFSEL2_Msk
#define GPIO_AFRL_AFSEL2_0             (0x1U << GPIO_AFRL_AFSEL2_Pos)          /*!< 0x00000100 */
#define GPIO_AFRL_AFSEL2_1             (0x2U << GPIO_AFRL_AFSEL2_Pos)          /*!< 0x00000200 */
#define GPIO_AFRL_AFSEL2_2             (0x4U << GPIO_AFRL_AFSEL2_Pos)          /*!< 0x00000400 */
#define GPIO_AFRL_AFSEL2_3             (0x8U << GPIO_AFRL_AFSEL2_Pos)          /*!< 0x00000800 */
#define GPIO_AFRL_AFSEL3_Pos           (12U)
#define GPIO_AFRL_AFSEL3_Msk           (0xFU << GPIO_AFRL_AFSEL3_Pos)          /*!< 0x0000F000 */
#define GPIO_AFRL_AFSEL3               GPIO_AFRL_AFSEL3_Msk
#define GPIO_AFRL_AFSEL3_0             (0x1U << GPIO_AFRL_AFSEL3_Pos)          /*!< 0x00001000 */
#define GPIO_AFRL_AFSEL3_1             (0x2U << GPIO_AFRL_AFSEL3_Pos)          /*!< 0x00002000 */
#define GPIO_AFRL_AFSEL3_2             (0x4U << GPIO_AFRL_AFSEL3_Pos)          /*!< 0x00004000 */
#define GPIO_AFRL_AFSEL3_3             (0x8U << GPIO_AFRL_AFSEL3_Pos)          /*!< 0x00008000 */
#define GPIO_AFRL_AFSEL4_Pos           (16U)
#define GPIO_AFRL_AFSEL4_Msk           (0xFU << GPIO_AFRL_AFSEL4_Pos)          /*!< 0x000F0000 */
#define GPIO_AFRL_AFSEL4               GPIO_AFRL_AFSEL4_Msk
#define GPIO_AFRL_AFSEL4_0             (0x1U << GPIO_AFRL_AFSEL4_Pos)          /*!< 0x00010000 */
#define GPIO_AFRL_AFSEL4_1             (0x2U << GPIO_AFRL_AFSEL4_Pos)          /*!< 0x00020000 */
#define GPIO_AFRL_AFSEL4_2             (0x4U << GPIO_AFRL_AFSEL4_Pos)          /*!< 0x00040000 */
#define GPIO_AFRL_AFSEL4_3             (0x8U << GPIO_AFRL_AFSEL4_Pos)          /*!< 0x00080000 */
#define GPIO_AFRL_AFSEL5_Pos           (20U)
#define GPIO_AFRL_AFSEL5_Msk           (0xFU << GPIO_AFRL_AFSEL5_Pos)          /*!< 0x00F00000 */
#define GPIO_AFRL_AFSEL5               GPIO_AFRL_AFSEL5_Msk
#define GPIO_AFRL_AFSEL5_0             (0x1U << GPIO_AFRL_AFSEL5_Pos)          /*!< 0x00100000 */
#define GPIO_AFRL_AFSEL5_1             (0x2U << GPIO_AFRL_AFSEL5_Pos)          /*!< 0x00200000 */
#define GPIO_AFRL_AFSEL5_2             (0x4U << GPIO_AFRL_AFSEL5_Pos)          /*!< 0x00400000 */
#define GPIO_AFRL_AFSEL5_3             (0x8U << GPIO_AFRL_AFSEL5_Pos)          /*!< 0x00800000 */
#define GPIO_AFRL_AFSEL6_Pos           (24U)
#define GPIO_AFRL_AFSEL6_Msk           (0xFU << GPIO_AFRL_AFSEL6_Pos)          /*!< 0x0F000000 */
#define GPIO_AFRL_AFSEL6               GPIO_AFRL_AFSEL6_Msk
#define GPIO_AFRL_AFSEL6_0             (0x1U << GPIO_AFRL_AFSEL6_Pos)          /*!< 0x01000000 */
#define GPIO_AFRL_AFSEL6_1             (0x2U << GPIO_AFRL_AFSEL6_Pos)          /*!< 0x02000000 */
#define GPIO_AFRL_AFSEL6_2             (0x4U << GPIO_AFRL_AFSEL6_Pos)          /*!< 0x04000000 */
#define GPIO_AFRL_AFSEL6_3             (0x8U << GPIO_AFRL_AFSEL6_Pos)          /*!< 0x08000000 */
#define GPIO_AFRL_AFSEL7_Pos           (28U)
#define GPIO_AFRL_AFSEL7_Msk           (0xFU << GPIO_AFRL_AFSEL7_Pos)          /*!< 0xF0000000 */
#define GPIO_AFRL_AFSEL7               GPIO_AFRL_AFSEL7_Msk
#define GPIO_AFRL_AFSEL7_0             (0x1U << GPIO_AFRL_AFSEL7_Pos)          /*!< 0x10000000 */
#define GPIO_AFRL_AFSEL7_1             (0x2U << GPIO_AFRL_AFSEL7_Pos)          /*!< 0x20000000 */
#define GPIO_AFRL_AFSEL7_2             (0x4U << GPIO_AFRL_AFSEL7_Pos)          /*!< 0x40000000 */
#define GPIO_AFRL_AFSEL7_3             (0x8U << GPIO_AFRL_AFSEL7_Pos)          /*!< 0x80000000 */

/****************** Bit definition for GPIO_AFRH register *********************/
#define GPIO_AFRH_AFSEL8_Pos           (0U)
#define GPIO_AFRH_AFSEL8_Msk           (0xFU << GPIO_AFRH_AFSEL8_Pos)          /*!< 0x0000000F */
#define GPIO_AFRH_AFSEL8               GPIO_AFRH_AFSEL8_Msk
#define GPIO_AFRH_AFSEL8_0             (0x1U << GPIO_AFRH_AFSEL8_Pos)          /*!< 0x00000001 */
#define GPIO_AFRH_AFSEL8_1             (0x2U << GPIO_AFRH_AFSEL8_Pos)          /*!< 0x00000002 */
#define GPIO_AFRH_AFSEL8_2             (0x4U << GPIO_AFRH_AFSEL8_Pos)          /*!< 0x00000004 */
#define GPIO_AFRH_AFSEL8_3             (0x8U << GPIO_AFRH_AFSEL8_Pos)          /*!< 0x00000008 */
#define GPIO_AFRH_AFSEL9_Pos           (4U)
#define GPIO_AFRH_AFSEL9_Msk           (0xFU << GPIO_AFRH_AFSEL9_Pos)          /*!< 0x000000F0 */
#define GPIO_AFRH_AFSEL9               GPIO_AFRH_AFSEL9_Msk
#define GPIO_AFRH_AFSEL9_0             (0x1U << GPIO_AFRH_AFSEL9_Pos)          /*!< 0x00000010 */
#define GPIO_AFRH_AFSEL9_1             (0x2U << GPIO_AFRH_AFSEL9_Pos)          /*!< 0x00000020 */
#define GPIO_AFRH_AFSEL9_2             (0x4U << GPIO_AFRH_AFSEL9_Pos)          /*!< 0x00000040 */
#define GPIO_AFRH_AFSEL9_3             (0x8U << GPIO_AFRH_AFSEL9_Pos)          /*!< 0x00000080 */
#define GPIO_AFRH_AFSEL10_Pos          (8U)
#define GPIO_AFRH_AFSEL10_Msk          (0xFU << GPIO_AFRH_AFSEL10_Pos)         /*!< 0x00000F00 */
#define GPIO_AFRH_AFSEL10              GPIO_AFRH_AFSEL10_Msk
#define GPIO_AFRH_AFSEL10_0            (0x1U << GPIO_AFRH_AFSEL10_Pos)         /*!< 0x00000100 */
#define GPIO_AFRH_AFSEL10_1            (0x2U << GPIO_AFRH_AFSEL10_Pos)         /*!< 0x00000200 */
#define GPIO_AFRH_AFSEL10_2            (0x4U << GPIO_AFRH_AFSEL10_Pos)         /*!< 0x00000400 */
#define GPIO_AFRH_AFSEL10_3            (0x8U << GPIO_AFRH_AFSEL10_Pos)         /*!< 0x00000800 */
#define GPIO_AFRH_AFSEL11_Pos          (12U)
#define GPIO_AFRH_AFSEL11_Msk          (0xFU << GPIO_AFRH_AFSEL11_Pos)         /*!< 0x0000F000 */
#define GPIO_AFRH_AFSEL11              GPIO_AFRH_AFSEL11_Msk
#define GPIO_AFRH_AFSEL11_0            (0x1U << GPIO_AFRH_AFSEL11_Pos)         /*!< 0x00001000 */
#define GPIO_AFRH_AFSEL11_1            (0x2U << GPIO_AFRH_AFSEL11_Pos)         /*!< 0x00002000 */
#define GPIO_AFRH_AFSEL11_2            (0x4U << GPIO_AFRH_AFSEL11_Pos)         /*!< 0x00004000 */
#define GPIO_AFRH_AFSEL11_3            (0x8U << GPIO_AFRH_AFSEL11_Pos)         /*!< 0x00008000 */
#define GPIO_AFRH_AFSEL12_Pos          (16U)
#define GPIO_AFRH_AFSEL12_Msk          (0xFU << GPIO_AFRH_AFSEL12_Pos)         /*!< 0x000F0000 */
#define GPIO_AFRH_AFSEL12              GPIO_AFRH_AFSEL12_Msk
#define GPIO_AFRH_AFSEL12_0            (0x1U << GPIO_AFRH_AFSEL12_Pos)         /*!< 0x00010000 */
#define GPIO_AFRH_AFSEL12_1            (0x2U << GPIO_AFRH_AFSEL12_Pos)         /*!< 0x00020000 */
#define GPIO_AFRH_AFSEL12_2            (0x4U << GPIO_AFRH_AFSEL12_Pos)         /*!< 0x00040000 */
#define GPIO_AFRH_AFSEL12_3            (0x8U << GPIO_AFRH_AFSEL12_Pos)         /*!< 0x00080000 */
#define GPIO_AFRH_AFSEL13_Pos          (20U)
#define GPIO_AFRH_AFSEL13_Msk          (0xFU << GPIO_AFRH_AFSEL13_Pos)         /*!< 0x00F00000 */
#define GPIO_AFRH_AFSEL13              GPIO_AFRH_AFSEL13_Msk
#define GPIO_AFRH_AFSEL13_0            (0x1U << GPIO_AFRH_AFSEL13_Pos)         /*!< 0x00100000 */
#define GPIO_AFRH_AFSEL13_1            (0x2U << GPIO_AFRH_AFSEL13_Pos)         /*!< 0x00200000 */
#define GPIO_AFRH_AFSEL13_2            (0x4U << GPIO_AFRH_AFSEL13_Pos)         /*!< 0x00400000 */
#define GPIO_AFRH_AFSEL13_3            (0x8U << GPIO_AFRH_AFSEL13_Pos)         /*!< 0x00800000 */
#define GPIO_AFRH_AFSEL14_Pos          (24U)
#define GPIO_AFRH_AFSEL14_Msk          (0xFU << GPIO_AFRH_AFSEL14_Pos)         /*!< 0x0F000000 */
#define GPIO_AFRH_AFSEL14              GPIO_AFRH_AFSEL14_Msk
#define GPIO_AFRH_AFSEL14_0            (0x1U << GPIO_AFRH_AFSEL14_Pos)         /*!< 0x01000000 */
#define GPIO_AFRH_AFSEL14_1            (0x2U << GPIO_AFRH_AFSEL14_Pos)         /*!< 0x02000000 */
#define GPIO_AFRH_AFSEL14_2            (0x4U << GPIO_AFRH_AFSEL14_Pos)         /*!< 0x04000000 */
#define GPIO_AFRH_AFSEL14_3            (0x8U << GPIO_AFRH_AFSEL14_Pos)         /*!< 0x08000000 */
#define GPIO_AFRH_AFSEL15_Pos          (28U)
#define GPIO_AFRH_AFSEL15_Msk          (0xFU << GPIO_AFRH_AFSEL15_Pos)         /*!< 0xF0000000 */
#define GPIO_AFRH_AFSEL15              GPIO_AFRH_AFSEL15_Msk
#define GPIO_AFRH_AFSEL15_0            (0x1U << GPIO_AFRH_AFSEL15_Pos)         /*!< 0x10000000 */
#define GPIO_AFRH_AFSEL15_1            (0x2U << GPIO_AFRH_AFSEL15_Pos)         /*!< 0x20000000 */
#define GPIO_AFRH_AFSEL15_2            (0x4U << GPIO_AFRH_AFSEL15_Pos)         /*!< 0x40000000 */
#define GPIO_AFRH_AFSEL15_3            (0x8U << GPIO_AFRH_AFSEL15_Pos)         /*!< 0x80000000 */

/******************  Bits definition for GPIO_BRR register  ******************/
#define GPIO_BRR_BR0_Pos               (0U)
#define GPIO_BRR_BR0_Msk               (0x1UL << GPIO_BRR_BR0_Pos)              /*!< 0x00000001 */
#define GPIO_BRR_BR0                   GPIO_BRR_BR0_Msk
#define GPIO_BRR_BR1_Pos               (1U)
#define GPIO_BRR_BR1_Msk               (0x1UL << GPIO_BRR_BR1_Pos)              /*!< 0x00000002 */
#define GPIO_BRR_BR1                   GPIO_BRR_BR1_Msk
#define GPIO_BRR_BR2_Pos               (2U)
#define GPIO_BRR_BR2_Msk               (0x1UL << GPIO_BRR_BR2_Pos)              /*!< 0x00000004 */
#define GPIO_BRR_BR2                   GPIO_BRR_BR2_Msk
#define GPIO_BRR_BR3_Pos               (3U)
#define GPIO_BRR_BR3_Msk               (0x1UL << GPIO_BRR_BR3_Pos)              /*!< 0x00000008 */
#define GPIO_BRR_BR3                   GPIO_BRR_BR3_Msk
#define GPIO_BRR_BR4_Pos               (4U)
#define GPIO_BRR_BR4_Msk               (0x1UL << GPIO_BRR_BR4_Pos)              /*!< 0x00000010 */
#define GPIO_BRR_BR4                   GPIO_BRR_BR4_Msk
#define GPIO_BRR_BR5_Pos               (5U)
#define GPIO_BRR_BR5_Msk               (0x1UL << GPIO_BRR_BR5_Pos)              /*!< 0x00000020 */
#define GPIO_BRR_BR5                   GPIO_BRR_BR5_Msk
#define GPIO_BRR_BR6_Pos               (6U)
#define GPIO_BRR_BR6_Msk               (0x1UL << GPIO_BRR_BR6_Pos)              /*!< 0x00000040 */
#define GPIO_BRR_BR6                   GPIO_BRR_BR6_Msk
#define GPIO_BRR_BR7_Pos               (7U)
#define GPIO_BRR_BR7_Msk               (0x1UL << GPIO_BRR_BR7_Pos)              /*!< 0x00000080 */
#define GPIO_BRR_BR7                   GPIO_BRR_BR7_Msk
#define GPIO_BRR_BR8_Pos               (8U)
#define GPIO_BRR_BR8_Msk               (0x1UL << GPIO_BRR_BR8_Pos)              /*!< 0x00000100 */
#define GPIO_BRR_BR8                   GPIO_BRR_BR8_Msk
#define GPIO_BRR_BR9_Pos               (9U)
#define GPIO_BRR_BR9_Msk               (0x1UL << GPIO_BRR_BR9_Pos)              /*!< 0x00000200 */
#define GPIO_BRR_BR9                   GPIO_BRR_BR9_Msk
#define GPIO_BRR_BR10_Pos              (10U)
#define GPIO_BRR_BR10_Msk              (0x1UL << GPIO_BRR_BR10_Pos)             /*!< 0x00000400 */
#define GPIO_BRR_BR10                  GPIO_BRR_BR10_Msk
#define GPIO_BRR_BR11_Pos              (11U)
#define GPIO_BRR_BR11_Msk              (0x1UL << GPIO_BRR_BR11_Pos)             /*!< 0x00000800 */
#define GPIO_BRR_BR11                  GPIO_BRR_BR11_Msk
#define GPIO_BRR_BR12_Pos              (12U)
#define GPIO_BRR_BR12_Msk              (0x1UL << GPIO_BRR_BR12_Pos)             /*!< 0x00001000 */
#define GPIO_BRR_BR12                  GPIO_BRR_BR12_Msk
#define GPIO_BRR_BR13_Pos              (13U)
#define GPIO_BRR_BR13_Msk              (0x1UL << GPIO_BRR_BR13_Pos)             /*!< 0x00002000 */
#define GPIO_BRR_BR13                  GPIO_BRR_BR13_Msk
#define GPIO_BRR_BR14_Pos              (14U)
#define GPIO_BRR_BR14_Msk              (0x1UL << GPIO_BRR_BR14_Pos)             /*!< 0x00004000 */
#define GPIO_BRR_BR14                  GPIO_BRR_BR14_Msk
#define GPIO_BRR_BR15_Pos              (15U)
#define GPIO_BRR_BR15_Msk              (0x1UL << GPIO_BRR_BR15_Pos)             /*!< 0x00008000 */
#define GPIO_BRR_BR15                  GPIO_BRR_BR15_Msk

/******************  Bits definition for GPIO_SECR register  ******************/
#define GPIO_SECR_SEC0_Pos            (0U)
#define GPIO_SECR_SEC0_Msk            (0x1U << GPIO_SECR_SEC0_Pos)           /*!< 0x00000001 */
#define GPIO_SECR_SEC0                GPIO_SECR_SEC0_Msk
#define GPIO_SECR_SEC1_Pos            (1U)
#define GPIO_SECR_SEC1_Msk            (0x1U << GPIO_SECR_SEC1_Pos)           /*!< 0x00000002 */
#define GPIO_SECR_SEC1                GPIO_SECR_SEC1_Msk
#define GPIO_SECR_SEC2_Pos            (2U)
#define GPIO_SECR_SEC2_Msk            (0x1U << GPIO_SECR_SEC2_Pos)           /*!< 0x00000004 */
#define GPIO_SECR_SEC2                GPIO_SECR_SEC2_Msk
#define GPIO_SECR_SEC3_Pos            (3U)
#define GPIO_SECR_SEC3_Msk            (0x1U << GPIO_SECR_SEC3_Pos)           /*!< 0x00000008 */
#define GPIO_SECR_SEC3                GPIO_SECR_SEC3_Msk
#define GPIO_SECR_SEC4_Pos            (4U)
#define GPIO_SECR_SEC4_Msk            (0x1U << GPIO_SECR_SEC4_Pos)           /*!< 0x00000010 */
#define GPIO_SECR_SEC4                GPIO_SECR_SEC4_Msk
#define GPIO_SECR_SEC5_Pos            (5U)
#define GPIO_SECR_SEC5_Msk            (0x1U << GPIO_SECR_SEC5_Pos)           /*!< 0x00000020 */
#define GPIO_SECR_SEC5                GPIO_SECR_SEC5_Msk
#define GPIO_SECR_SEC6_Pos            (6U)
#define GPIO_SECR_SEC6_Msk            (0x1U << GPIO_SECR_SEC6_Pos)           /*!< 0x00000040 */
#define GPIO_SECR_SEC6                GPIO_SECR_SEC6_Msk
#define GPIO_SECR_SEC7_Pos            (7U)
#define GPIO_SECR_SEC7_Msk            (0x1U << GPIO_SECR_SEC7_Pos)           /*!< 0x00000080 */
#define GPIO_SECR_SEC7                GPIO_SECR_SEC7_Msk
#define GPIO_SECR_SEC8_Pos            (8U)
#define GPIO_SECR_SEC8_Msk            (0x1U << GPIO_SECR_SEC8_Pos)           /*!< 0x00000100 */
#define GPIO_SECR_SEC8                GPIO_SECR_SEC8_Msk
#define GPIO_SECR_SEC9_Pos            (9U)
#define GPIO_SECR_SEC9_Msk            (0x1U << GPIO_SECR_SEC9_Pos)           /*!< 0x00000200 */
#define GPIO_SECR_SEC9                GPIO_SECR_SEC9_Msk
#define GPIO_SECR_SEC10_Pos           (10U)
#define GPIO_SECR_SEC10_Msk           (0x1U << GPIO_SECR_SEC10_Pos)          /*!< 0x00000400 */
#define GPIO_SECR_SEC10               GPIO_SECR_SEC10_Msk
#define GPIO_SECR_SEC11_Pos           (11U)
#define GPIO_SECR_SEC11_Msk           (0x1U << GPIO_SECR_SEC11_Pos)          /*!< 0x00000800 */
#define GPIO_SECR_SEC11               GPIO_SECR_SEC11_Msk
#define GPIO_SECR_SEC12_Pos           (12U)
#define GPIO_SECR_SEC12_Msk           (0x1U << GPIO_SECR_SEC12_Pos)          /*!< 0x00001000 */
#define GPIO_SECR_SEC12               GPIO_SECR_SEC12_Msk
#define GPIO_SECR_SEC13_Pos           (13U)
#define GPIO_SECR_SEC13_Msk           (0x1U << GPIO_SECR_SEC13_Pos)          /*!< 0x00002000 */
#define GPIO_SECR_SEC13               GPIO_SECR_SEC13_Msk
#define GPIO_SECR_SEC14_Pos           (14U)
#define GPIO_SECR_SEC14_Msk           (0x1U << GPIO_SECR_SEC14_Pos)          /*!< 0x00004000 */
#define GPIO_SECR_SEC14               GPIO_SECR_SEC14_Msk
#define GPIO_SECR_SEC15_Pos           (15U)
#define GPIO_SECR_SEC15_Msk           (0x1U << GPIO_SECR_SEC15_Pos)          /*!< 0x00008000 */
#define GPIO_SECR_SEC15               GPIO_SECR_SEC15_Msk


/******************************************************************************/
/*                                                                            */
/*                        HSEM HW Semaphore                                   */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for HSEM_R register  ********************/
#define HSEM_R_PROCID_Pos         (0U)
#define HSEM_R_PROCID_Msk         (0xFFUL << HSEM_R_PROCID_Pos)                /*!< 0x000000FF */
#define HSEM_R_PROCID             HSEM_R_PROCID_Msk                             /*!<Semaphore ProcessID */
#define HSEM_R_COREID_Pos         (8U)
#define HSEM_R_COREID_Msk         (0xFFUL << HSEM_R_COREID_Pos)                /*!< 0x0000FF00 */
#define HSEM_R_COREID             HSEM_R_COREID_Msk                             /*!<Semaphore CoreID. */
#define HSEM_R_LOCK_Pos           (31U)
#define HSEM_R_LOCK_Msk           (0x1UL << HSEM_R_LOCK_Pos)                   /*!< 0x80000000 */
#define HSEM_R_LOCK               HSEM_R_LOCK_Msk                               /*!<Lock indication. */

/********************  Bit definition for HSEM_RLR register  ******************/
#define HSEM_RLR_PROCID_Pos       (0U)
#define HSEM_RLR_PROCID_Msk       (0xFFUL << HSEM_RLR_PROCID_Pos)              /*!< 0x000000FF */
#define HSEM_RLR_PROCID           HSEM_RLR_PROCID_Msk                           /*!<Semaphore ProcessID */
#define HSEM_RLR_COREID_Pos       (8U)
#define HSEM_RLR_COREID_Msk       (0xFFUL << HSEM_RLR_COREID_Pos)              /*!< 0x0000FF00 */
#define HSEM_RLR_COREID           HSEM_RLR_COREID_Msk                           /*!<Semaphore CoreID. */
#define HSEM_RLR_LOCK_Pos         (31U)
#define HSEM_RLR_LOCK_Msk         (0x1UL << HSEM_RLR_LOCK_Pos)                 /*!< 0x80000000 */
#define HSEM_RLR_LOCK             HSEM_RLR_LOCK_Msk                             /*!<Lock indication. */

/********************  Bit definition for HSEM_C1IER register  *****************/
#define HSEM_C1IER_ISE0_Pos       (0U)
#define HSEM_C1IER_ISE0_Msk       (0x1UL << HSEM_C1IER_ISE0_Pos)               /*!< 0x00000001 */
#define HSEM_C1IER_ISE0           HSEM_C1IER_ISE0_Msk                          /*!<semaphore 0 , interrupt 0 enable bit.  */
#define HSEM_C1IER_ISE1_Pos       (1U)
#define HSEM_C1IER_ISE1_Msk       (0x1UL << HSEM_C1IER_ISE1_Pos)               /*!< 0x00000002 */
#define HSEM_C1IER_ISE1           HSEM_C1IER_ISE1_Msk                          /*!<semaphore 1 , interrupt 0 enable bit.  */
#define HSEM_C1IER_ISE2_Pos       (2U)
#define HSEM_C1IER_ISE2_Msk       (0x1UL << HSEM_C1IER_ISE2_Pos)               /*!< 0x00000004 */
#define HSEM_C1IER_ISE2           HSEM_C1IER_ISE2_Msk                          /*!<semaphore 2 , interrupt 0 enable bit.  */
#define HSEM_C1IER_ISE3_Pos       (3U)
#define HSEM_C1IER_ISE3_Msk       (0x1UL << HSEM_C1IER_ISE3_Pos)               /*!< 0x00000008 */
#define HSEM_C1IER_ISE3           HSEM_C1IER_ISE3_Msk                          /*!<semaphore 3 , interrupt 0 enable bit.  */
#define HSEM_C1IER_ISE4_Pos       (4U)
#define HSEM_C1IER_ISE4_Msk       (0x1UL << HSEM_C1IER_ISE4_Pos)               /*!< 0x00000010 */
#define HSEM_C1IER_ISE4           HSEM_C1IER_ISE4_Msk                          /*!<semaphore 4 , interrupt 0 enable bit.  */
#define HSEM_C1IER_ISE5_Pos       (5U)
#define HSEM_C1IER_ISE5_Msk       (0x1UL << HSEM_C1IER_ISE5_Pos)               /*!< 0x00000020 */
#define HSEM_C1IER_ISE5           HSEM_C1IER_ISE5_Msk                          /*!<semaphore 5 interrupt 0 enable bit.    */
#define HSEM_C1IER_ISE6_Pos       (6U)
#define HSEM_C1IER_ISE6_Msk       (0x1UL << HSEM_C1IER_ISE6_Pos)               /*!< 0x00000040 */
#define HSEM_C1IER_ISE6           HSEM_C1IER_ISE6_Msk                          /*!<semaphore 6 interrupt 0 enable bit.    */
#define HSEM_C1IER_ISE7_Pos       (7U)
#define HSEM_C1IER_ISE7_Msk       (0x1UL << HSEM_C1IER_ISE7_Pos)               /*!< 0x00000080 */
#define HSEM_C1IER_ISE7           HSEM_C1IER_ISE7_Msk                          /*!<semaphore 7 interrupt 0 enable bit.    */
#define HSEM_C1IER_ISE8_Pos       (8U)
#define HSEM_C1IER_ISE8_Msk       (0x1UL << HSEM_C1IER_ISE8_Pos)               /*!< 0x00000100 */
#define HSEM_C1IER_ISE8           HSEM_C1IER_ISE8_Msk                          /*!<semaphore 8 interrupt 0 enable bit.    */
#define HSEM_C1IER_ISE9_Pos       (9U)
#define HSEM_C1IER_ISE9_Msk       (0x1UL << HSEM_C1IER_ISE9_Pos)               /*!< 0x00000200 */
#define HSEM_C1IER_ISE9           HSEM_C1IER_ISE9_Msk                          /*!<semaphore 9 interrupt 0 enable bit.    */
#define HSEM_C1IER_ISE10_Pos      (10U)
#define HSEM_C1IER_ISE10_Msk      (0x1UL << HSEM_C1IER_ISE10_Pos)              /*!< 0x00000400 */
#define HSEM_C1IER_ISE10          HSEM_C1IER_ISE10_Msk                         /*!<semaphore 10 interrupt 0 enable bit.   */
#define HSEM_C1IER_ISE11_Pos      (11U)
#define HSEM_C1IER_ISE11_Msk      (0x1UL << HSEM_C1IER_ISE11_Pos)              /*!< 0x00000800 */
#define HSEM_C1IER_ISE11          HSEM_C1IER_ISE11_Msk                         /*!<semaphore 11 interrupt 0 enable bit.   */
#define HSEM_C1IER_ISE12_Pos      (12U)
#define HSEM_C1IER_ISE12_Msk      (0x1UL << HSEM_C1IER_ISE12_Pos)              /*!< 0x00001000 */
#define HSEM_C1IER_ISE12          HSEM_C1IER_ISE12_Msk                         /*!<semaphore 12 interrupt 0 enable bit.   */
#define HSEM_C1IER_ISE13_Pos      (13U)
#define HSEM_C1IER_ISE13_Msk      (0x1UL << HSEM_C1IER_ISE13_Pos)              /*!< 0x00002000 */
#define HSEM_C1IER_ISE13          HSEM_C1IER_ISE13_Msk                         /*!<semaphore 13 interrupt 0 enable bit.   */
#define HSEM_C1IER_ISE14_Pos      (14U)
#define HSEM_C1IER_ISE14_Msk      (0x1UL << HSEM_C1IER_ISE14_Pos)              /*!< 0x00004000 */
#define HSEM_C1IER_ISE14          HSEM_C1IER_ISE14_Msk                         /*!<semaphore 14 interrupt 0 enable bit.   */
#define HSEM_C1IER_ISE15_Pos      (15U)
#define HSEM_C1IER_ISE15_Msk      (0x1UL << HSEM_C1IER_ISE15_Pos)              /*!< 0x00008000 */
#define HSEM_C1IER_ISE15          HSEM_C1IER_ISE15_Msk                         /*!<semaphore 15 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE16_Pos      (16U)
#define HSEM_C1IER_ISE16_Msk      (0x1UL << HSEM_C1IER_ISE16_Pos)              /*!< 0x00010000 */
#define HSEM_C1IER_ISE16          HSEM_C1IER_ISE16_Msk                         /*!<semaphore 16 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE17_Pos      (17U)
#define HSEM_C1IER_ISE17_Msk      (0x1UL << HSEM_C1IER_ISE17_Pos)              /*!< 0x00020000 */
#define HSEM_C1IER_ISE17          HSEM_C1IER_ISE17_Msk                         /*!<semaphore 17 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE18_Pos      (18U)
#define HSEM_C1IER_ISE18_Msk      (0x1UL << HSEM_C1IER_ISE18_Pos)              /*!< 0x00040000 */
#define HSEM_C1IER_ISE18          HSEM_C1IER_ISE18_Msk                         /*!<semaphore 18 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE19_Pos      (19U)
#define HSEM_C1IER_ISE19_Msk      (0x1UL << HSEM_C1IER_ISE19_Pos)              /*!< 0x00080000 */
#define HSEM_C1IER_ISE19          HSEM_C1IER_ISE19_Msk                         /*!<semaphore 19 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE20_Pos      (20U)
#define HSEM_C1IER_ISE20_Msk      (0x1UL << HSEM_C1IER_ISE20_Pos)              /*!< 0x00100000 */
#define HSEM_C1IER_ISE20          HSEM_C1IER_ISE20_Msk                         /*!<semaphore 20 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE21_Pos      (21U)
#define HSEM_C1IER_ISE21_Msk      (0x1UL << HSEM_C1IER_ISE21_Pos)              /*!< 0x00200000 */
#define HSEM_C1IER_ISE21          HSEM_C1IER_ISE21_Msk                         /*!<semaphore 21 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE22_Pos      (22U)
#define HSEM_C1IER_ISE22_Msk      (0x1UL << HSEM_C1IER_ISE22_Pos)              /*!< 0x00400000 */
#define HSEM_C1IER_ISE22          HSEM_C1IER_ISE22_Msk                         /*!<semaphore 22 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE23_Pos      (23U)
#define HSEM_C1IER_ISE23_Msk      (0x1UL << HSEM_C1IER_ISE23_Pos)              /*!< 0x00800000 */
#define HSEM_C1IER_ISE23          HSEM_C1IER_ISE23_Msk                         /*!<semaphore 23 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE24_Pos      (24U)
#define HSEM_C1IER_ISE24_Msk      (0x1UL << HSEM_C1IER_ISE24_Pos)              /*!< 0x01000000 */
#define HSEM_C1IER_ISE24          HSEM_C1IER_ISE24_Msk                         /*!<semaphore 24 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE25_Pos      (25U)
#define HSEM_C1IER_ISE25_Msk      (0x1UL << HSEM_C1IER_ISE25_Pos)              /*!< 0x02000000 */
#define HSEM_C1IER_ISE25          HSEM_C1IER_ISE25_Msk                         /*!<semaphore 25 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE26_Pos      (26U)
#define HSEM_C1IER_ISE26_Msk      (0x1UL << HSEM_C1IER_ISE26_Pos)              /*!< 0x04000000 */
#define HSEM_C1IER_ISE26          HSEM_C1IER_ISE26_Msk                         /*!<semaphore 26 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE27_Pos      (27U)
#define HSEM_C1IER_ISE27_Msk      (0x1UL << HSEM_C1IER_ISE27_Pos)              /*!< 0x08000000 */
#define HSEM_C1IER_ISE27          HSEM_C1IER_ISE27_Msk                         /*!<semaphore 27 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE28_Pos      (28U)
#define HSEM_C1IER_ISE28_Msk      (0x1UL << HSEM_C1IER_ISE28_Pos)              /*!< 0x10000000 */
#define HSEM_C1IER_ISE28          HSEM_C1IER_ISE28_Msk                         /*!<semaphore 28 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE29_Pos      (29U)
#define HSEM_C1IER_ISE29_Msk      (0x1UL << HSEM_C1IER_ISE29_Pos)              /*!< 0x20000000 */
#define HSEM_C1IER_ISE29          HSEM_C1IER_ISE29_Msk                         /*!<semaphore 29 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE30_Pos      (30U)
#define HSEM_C1IER_ISE30_Msk      (0x1UL << HSEM_C1IER_ISE30_Pos)              /*!< 0x40000000 */
#define HSEM_C1IER_ISE30          HSEM_C1IER_ISE30_Msk                         /*!<semaphore 30 interrupt 0 enable bit. */
#define HSEM_C1IER_ISE31_Pos      (31U)
#define HSEM_C1IER_ISE31_Msk      (0x1UL << HSEM_C1IER_ISE31_Pos)              /*!< 0x80000000 */
#define HSEM_C1IER_ISE31          HSEM_C1IER_ISE31_Msk                         /*!<semaphore 31 interrupt 0 enable bit. */

/********************  Bit definition for HSEM_C1ICR register  *****************/
#define HSEM_C1ICR_ISC0_Pos       (0U)
#define HSEM_C1ICR_ISC0_Msk       (0x1UL << HSEM_C1ICR_ISC0_Pos)               /*!< 0x00000001 */
#define HSEM_C1ICR_ISC0           HSEM_C1ICR_ISC0_Msk                          /*!<semaphore 0 , interrupt 0 clear bit.  */
#define HSEM_C1ICR_ISC1_Pos       (1U)
#define HSEM_C1ICR_ISC1_Msk       (0x1UL << HSEM_C1ICR_ISC1_Pos)               /*!< 0x00000002 */
#define HSEM_C1ICR_ISC1           HSEM_C1ICR_ISC1_Msk                          /*!<semaphore 1 , interrupt 0 clear bit.  */
#define HSEM_C1ICR_ISC2_Pos       (2U)
#define HSEM_C1ICR_ISC2_Msk       (0x1UL << HSEM_C1ICR_ISC2_Pos)               /*!< 0x00000004 */
#define HSEM_C1ICR_ISC2           HSEM_C1ICR_ISC2_Msk                          /*!<semaphore 2 , interrupt 0 clear bit.  */
#define HSEM_C1ICR_ISC3_Pos       (3U)
#define HSEM_C1ICR_ISC3_Msk       (0x1UL << HSEM_C1ICR_ISC3_Pos)               /*!< 0x00000008 */
#define HSEM_C1ICR_ISC3           HSEM_C1ICR_ISC3_Msk                          /*!<semaphore 3 , interrupt 0 clear bit.  */
#define HSEM_C1ICR_ISC4_Pos       (4U)
#define HSEM_C1ICR_ISC4_Msk       (0x1UL << HSEM_C1ICR_ISC4_Pos)               /*!< 0x00000010 */
#define HSEM_C1ICR_ISC4           HSEM_C1ICR_ISC4_Msk                          /*!<semaphore 4 , interrupt 0 clear bit.  */
#define HSEM_C1ICR_ISC5_Pos       (5U)
#define HSEM_C1ICR_ISC5_Msk       (0x1UL << HSEM_C1ICR_ISC5_Pos)               /*!< 0x00000020 */
#define HSEM_C1ICR_ISC5           HSEM_C1ICR_ISC5_Msk                          /*!<semaphore 5 interrupt 0 clear bit.  */
#define HSEM_C1ICR_ISC6_Pos       (6U)
#define HSEM_C1ICR_ISC6_Msk       (0x1UL << HSEM_C1ICR_ISC6_Pos)               /*!< 0x00000040 */
#define HSEM_C1ICR_ISC6           HSEM_C1ICR_ISC6_Msk                          /*!<semaphore 6 interrupt 0 clear bit.  */
#define HSEM_C1ICR_ISC7_Pos       (7U)
#define HSEM_C1ICR_ISC7_Msk       (0x1UL << HSEM_C1ICR_ISC7_Pos)               /*!< 0x00000080 */
#define HSEM_C1ICR_ISC7           HSEM_C1ICR_ISC7_Msk                          /*!<semaphore 7 interrupt 0 clear bit.  */
#define HSEM_C1ICR_ISC8_Pos       (8U)
#define HSEM_C1ICR_ISC8_Msk       (0x1UL << HSEM_C1ICR_ISC8_Pos)               /*!< 0x00000100 */
#define HSEM_C1ICR_ISC8           HSEM_C1ICR_ISC8_Msk                          /*!<semaphore 8 interrupt 0 clear bit.  */
#define HSEM_C1ICR_ISC9_Pos       (9U)
#define HSEM_C1ICR_ISC9_Msk       (0x1UL << HSEM_C1ICR_ISC9_Pos)               /*!< 0x00000200 */
#define HSEM_C1ICR_ISC9           HSEM_C1ICR_ISC9_Msk                          /*!<semaphore 9 interrupt 0 clear bit.  */
#define HSEM_C1ICR_ISC10_Pos      (10U)
#define HSEM_C1ICR_ISC10_Msk      (0x1UL << HSEM_C1ICR_ISC10_Pos)              /*!< 0x00000400 */
#define HSEM_C1ICR_ISC10          HSEM_C1ICR_ISC10_Msk                         /*!<semaphore 10 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC11_Pos      (11U)
#define HSEM_C1ICR_ISC11_Msk      (0x1UL << HSEM_C1ICR_ISC11_Pos)              /*!< 0x00000800 */
#define HSEM_C1ICR_ISC11          HSEM_C1ICR_ISC11_Msk                         /*!<semaphore 11 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC12_Pos      (12U)
#define HSEM_C1ICR_ISC12_Msk      (0x1UL << HSEM_C1ICR_ISC12_Pos)              /*!< 0x00001000 */
#define HSEM_C1ICR_ISC12          HSEM_C1ICR_ISC12_Msk                         /*!<semaphore 12 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC13_Pos      (13U)
#define HSEM_C1ICR_ISC13_Msk      (0x1UL << HSEM_C1ICR_ISC13_Pos)              /*!< 0x00002000 */
#define HSEM_C1ICR_ISC13          HSEM_C1ICR_ISC13_Msk                         /*!<semaphore 13 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC14_Pos      (14U)
#define HSEM_C1ICR_ISC14_Msk      (0x1UL << HSEM_C1ICR_ISC14_Pos)              /*!< 0x00004000 */
#define HSEM_C1ICR_ISC14          HSEM_C1ICR_ISC14_Msk                         /*!<semaphore 14 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC15_Pos      (15U)
#define HSEM_C1ICR_ISC15_Msk      (0x1UL << HSEM_C1ICR_ISC15_Pos)              /*!< 0x00008000 */
#define HSEM_C1ICR_ISC15          HSEM_C1ICR_ISC15_Msk                         /*!<semaphore 15 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC16_Pos      (16U)
#define HSEM_C1ICR_ISC16_Msk      (0x1UL << HSEM_C1ICR_ISC16_Pos)              /*!< 0x00010000 */
#define HSEM_C1ICR_ISC16          HSEM_C1ICR_ISC16_Msk                         /*!<semaphore 16 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC17_Pos      (17U)
#define HSEM_C1ICR_ISC17_Msk      (0x1UL << HSEM_C1ICR_ISC17_Pos)              /*!< 0x00020000 */
#define HSEM_C1ICR_ISC17          HSEM_C1ICR_ISC17_Msk                         /*!<semaphore 17 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC18_Pos      (18U)
#define HSEM_C1ICR_ISC18_Msk      (0x1UL << HSEM_C1ICR_ISC18_Pos)              /*!< 0x00040000 */
#define HSEM_C1ICR_ISC18          HSEM_C1ICR_ISC18_Msk                         /*!<semaphore 18 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC19_Pos      (19U)
#define HSEM_C1ICR_ISC19_Msk      (0x1UL << HSEM_C1ICR_ISC19_Pos)              /*!< 0x00080000 */
#define HSEM_C1ICR_ISC19          HSEM_C1ICR_ISC19_Msk                         /*!<semaphore 19 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC20_Pos      (20U)
#define HSEM_C1ICR_ISC20_Msk      (0x1UL << HSEM_C1ICR_ISC20_Pos)              /*!< 0x00100000 */
#define HSEM_C1ICR_ISC20          HSEM_C1ICR_ISC20_Msk                         /*!<semaphore 20 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC21_Pos      (21U)
#define HSEM_C1ICR_ISC21_Msk      (0x1UL << HSEM_C1ICR_ISC21_Pos)              /*!< 0x00200000 */
#define HSEM_C1ICR_ISC21          HSEM_C1ICR_ISC21_Msk                         /*!<semaphore 21 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC22_Pos      (22U)
#define HSEM_C1ICR_ISC22_Msk      (0x1UL << HSEM_C1ICR_ISC22_Pos)              /*!< 0x00400000 */
#define HSEM_C1ICR_ISC22          HSEM_C1ICR_ISC22_Msk                         /*!<semaphore 22 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC23_Pos      (23U)
#define HSEM_C1ICR_ISC23_Msk      (0x1UL << HSEM_C1ICR_ISC23_Pos)              /*!< 0x00800000 */
#define HSEM_C1ICR_ISC23          HSEM_C1ICR_ISC23_Msk                         /*!<semaphore 23 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC24_Pos      (24U)
#define HSEM_C1ICR_ISC24_Msk      (0x1UL << HSEM_C1ICR_ISC24_Pos)              /*!< 0x01000000 */
#define HSEM_C1ICR_ISC24          HSEM_C1ICR_ISC24_Msk                         /*!<semaphore 24 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC25_Pos      (25U)
#define HSEM_C1ICR_ISC25_Msk      (0x1UL << HSEM_C1ICR_ISC25_Pos)              /*!< 0x02000000 */
#define HSEM_C1ICR_ISC25          HSEM_C1ICR_ISC25_Msk                         /*!<semaphore 25 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC26_Pos      (26U)
#define HSEM_C1ICR_ISC26_Msk      (0x1UL << HSEM_C1ICR_ISC26_Pos)              /*!< 0x04000000 */
#define HSEM_C1ICR_ISC26          HSEM_C1ICR_ISC26_Msk                         /*!<semaphore 26 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC27_Pos      (27U)
#define HSEM_C1ICR_ISC27_Msk      (0x1UL << HSEM_C1ICR_ISC27_Pos)              /*!< 0x08000000 */
#define HSEM_C1ICR_ISC27          HSEM_C1ICR_ISC27_Msk                         /*!<semaphore 27 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC28_Pos      (28U)
#define HSEM_C1ICR_ISC28_Msk      (0x1UL << HSEM_C1ICR_ISC28_Pos)              /*!< 0x10000000 */
#define HSEM_C1ICR_ISC28          HSEM_C1ICR_ISC28_Msk                         /*!<semaphore 28 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC29_Pos      (29U)
#define HSEM_C1ICR_ISC29_Msk      (0x1UL << HSEM_C1ICR_ISC29_Pos)              /*!< 0x20000000 */
#define HSEM_C1ICR_ISC29          HSEM_C1ICR_ISC29_Msk                         /*!<semaphore 29 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC30_Pos      (30U)
#define HSEM_C1ICR_ISC30_Msk      (0x1UL << HSEM_C1ICR_ISC30_Pos)              /*!< 0x40000000 */
#define HSEM_C1ICR_ISC30          HSEM_C1ICR_ISC30_Msk                         /*!<semaphore 30 interrupt 0 clear bit. */
#define HSEM_C1ICR_ISC31_Pos      (31U)
#define HSEM_C1ICR_ISC31_Msk      (0x1UL << HSEM_C1ICR_ISC31_Pos)              /*!< 0x80000000 */
#define HSEM_C1ICR_ISC31          HSEM_C1ICR_ISC31_Msk                         /*!<semaphore 31 interrupt 0 clear bit. */

/********************  Bit definition for HSEM_C1ISR register  *****************/
#define HSEM_C1ISR_ISF0_Pos       (0U)
#define HSEM_C1ISR_ISF0_Msk       (0x1UL << HSEM_C1ISR_ISF0_Pos)               /*!< 0x00000001 */
#define HSEM_C1ISR_ISF0           HSEM_C1ISR_ISF0_Msk                          /*!<semaphore 0 interrupt 0 status bit.  */
#define HSEM_C1ISR_ISF1_Pos       (1U)
#define HSEM_C1ISR_ISF1_Msk       (0x1UL << HSEM_C1ISR_ISF1_Pos)               /*!< 0x00000002 */
#define HSEM_C1ISR_ISF1           HSEM_C1ISR_ISF1_Msk                          /*!<semaphore 1 interrupt 0 status bit.  */
#define HSEM_C1ISR_ISF2_Pos       (2U)
#define HSEM_C1ISR_ISF2_Msk       (0x1UL << HSEM_C1ISR_ISF2_Pos)               /*!< 0x00000004 */
#define HSEM_C1ISR_ISF2           HSEM_C1ISR_ISF2_Msk                          /*!<semaphore 2 interrupt 0 status bit.  */
#define HSEM_C1ISR_ISF3_Pos       (3U)
#define HSEM_C1ISR_ISF3_Msk       (0x1UL << HSEM_C1ISR_ISF3_Pos)               /*!< 0x00000008 */
#define HSEM_C1ISR_ISF3           HSEM_C1ISR_ISF3_Msk                          /*!<semaphore 3 interrupt 0 status bit.  */
#define HSEM_C1ISR_ISF4_Pos       (4U)
#define HSEM_C1ISR_ISF4_Msk       (0x1UL << HSEM_C1ISR_ISF4_Pos)               /*!< 0x00000010 */
#define HSEM_C1ISR_ISF4           HSEM_C1ISR_ISF4_Msk                          /*!<semaphore 4 interrupt 0 status bit.  */
#define HSEM_C1ISR_ISF5_Pos       (5U)
#define HSEM_C1ISR_ISF5_Msk       (0x1UL << HSEM_C1ISR_ISF5_Pos)               /*!< 0x00000020 */
#define HSEM_C1ISR_ISF5           HSEM_C1ISR_ISF5_Msk                          /*!<semaphore 5 interrupt 0 status bit.  */
#define HSEM_C1ISR_ISF6_Pos       (6U)
#define HSEM_C1ISR_ISF6_Msk       (0x1UL << HSEM_C1ISR_ISF6_Pos)               /*!< 0x00000040 */
#define HSEM_C1ISR_ISF6           HSEM_C1ISR_ISF6_Msk                          /*!<semaphore 6 interrupt 0 status bit.  */
#define HSEM_C1ISR_ISF7_Pos       (7U)
#define HSEM_C1ISR_ISF7_Msk       (0x1UL << HSEM_C1ISR_ISF7_Pos)               /*!< 0x00000080 */
#define HSEM_C1ISR_ISF7           HSEM_C1ISR_ISF7_Msk                          /*!<semaphore 7 interrupt 0 status bit.  */
#define HSEM_C1ISR_ISF8_Pos       (8U)
#define HSEM_C1ISR_ISF8_Msk       (0x1UL << HSEM_C1ISR_ISF8_Pos)               /*!< 0x00000100 */
#define HSEM_C1ISR_ISF8           HSEM_C1ISR_ISF8_Msk                          /*!<semaphore 8 interrupt 0 status bit.  */
#define HSEM_C1ISR_ISF9_Pos       (9U)
#define HSEM_C1ISR_ISF9_Msk       (0x1UL << HSEM_C1ISR_ISF9_Pos)               /*!< 0x00000200 */
#define HSEM_C1ISR_ISF9           HSEM_C1ISR_ISF9_Msk                          /*!<semaphore 9 interrupt 0 status bit.  */
#define HSEM_C1ISR_ISF10_Pos      (10U)
#define HSEM_C1ISR_ISF10_Msk      (0x1UL << HSEM_C1ISR_ISF10_Pos)              /*!< 0x00000400 */
#define HSEM_C1ISR_ISF10          HSEM_C1ISR_ISF10_Msk                         /*!<semaphore 10 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF11_Pos      (11U)
#define HSEM_C1ISR_ISF11_Msk      (0x1UL << HSEM_C1ISR_ISF11_Pos)              /*!< 0x00000800 */
#define HSEM_C1ISR_ISF11          HSEM_C1ISR_ISF11_Msk                         /*!<semaphore 11 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF12_Pos      (12U)
#define HSEM_C1ISR_ISF12_Msk      (0x1UL << HSEM_C1ISR_ISF12_Pos)              /*!< 0x00001000 */
#define HSEM_C1ISR_ISF12          HSEM_C1ISR_ISF12_Msk                         /*!<semaphore 12 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF13_Pos      (13U)
#define HSEM_C1ISR_ISF13_Msk      (0x1UL << HSEM_C1ISR_ISF13_Pos)              /*!< 0x00002000 */
#define HSEM_C1ISR_ISF13          HSEM_C1ISR_ISF13_Msk                         /*!<semaphore 13 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF14_Pos      (14U)
#define HSEM_C1ISR_ISF14_Msk      (0x1UL << HSEM_C1ISR_ISF14_Pos)              /*!< 0x00004000 */
#define HSEM_C1ISR_ISF14          HSEM_C1ISR_ISF14_Msk                         /*!<semaphore 14 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF15_Pos      (15U)
#define HSEM_C1ISR_ISF15_Msk      (0x1UL << HSEM_C1ISR_ISF15_Pos)              /*!< 0x00008000 */
#define HSEM_C1ISR_ISF15          HSEM_C1ISR_ISF15_Msk                         /*!<semaphore 15 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF16_Pos      (16U)
#define HSEM_C1ISR_ISF16_Msk      (0x1UL << HSEM_C1ISR_ISF16_Pos)              /*!< 0x00010000 */
#define HSEM_C1ISR_ISF16          HSEM_C1ISR_ISF16_Msk                         /*!<semaphore 16 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF17_Pos      (17U)
#define HSEM_C1ISR_ISF17_Msk      (0x1UL << HSEM_C1ISR_ISF17_Pos)              /*!< 0x00020000 */
#define HSEM_C1ISR_ISF17          HSEM_C1ISR_ISF17_Msk                         /*!<semaphore 17 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF18_Pos      (18U)
#define HSEM_C1ISR_ISF18_Msk      (0x1UL << HSEM_C1ISR_ISF18_Pos)              /*!< 0x00040000 */
#define HSEM_C1ISR_ISF18          HSEM_C1ISR_ISF18_Msk                         /*!<semaphore 18 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF19_Pos      (19U)
#define HSEM_C1ISR_ISF19_Msk      (0x1UL << HSEM_C1ISR_ISF19_Pos)              /*!< 0x00080000 */
#define HSEM_C1ISR_ISF19          HSEM_C1ISR_ISF19_Msk                         /*!<semaphore 19 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF20_Pos      (20U)
#define HSEM_C1ISR_ISF20_Msk      (0x1UL << HSEM_C1ISR_ISF20_Pos)              /*!< 0x00100000 */
#define HSEM_C1ISR_ISF20          HSEM_C1ISR_ISF20_Msk                         /*!<semaphore 20 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF21_Pos      (21U)
#define HSEM_C1ISR_ISF21_Msk      (0x1UL << HSEM_C1ISR_ISF21_Pos)              /*!< 0x00200000 */
#define HSEM_C1ISR_ISF21          HSEM_C1ISR_ISF21_Msk                         /*!<semaphore 21 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF22_Pos      (22U)
#define HSEM_C1ISR_ISF22_Msk      (0x1UL << HSEM_C1ISR_ISF22_Pos)              /*!< 0x00400000 */
#define HSEM_C1ISR_ISF22          HSEM_C1ISR_ISF22_Msk                         /*!<semaphore 22 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF23_Pos      (23U)
#define HSEM_C1ISR_ISF23_Msk      (0x1UL << HSEM_C1ISR_ISF23_Pos)              /*!< 0x00800000 */
#define HSEM_C1ISR_ISF23          HSEM_C1ISR_ISF23_Msk                         /*!<semaphore 23 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF24_Pos      (24U)
#define HSEM_C1ISR_ISF24_Msk      (0x1UL << HSEM_C1ISR_ISF24_Pos)              /*!< 0x01000000 */
#define HSEM_C1ISR_ISF24          HSEM_C1ISR_ISF24_Msk                         /*!<semaphore 24 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF25_Pos      (25U)
#define HSEM_C1ISR_ISF25_Msk      (0x1UL << HSEM_C1ISR_ISF25_Pos)              /*!< 0x02000000 */
#define HSEM_C1ISR_ISF25          HSEM_C1ISR_ISF25_Msk                         /*!<semaphore 25 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF26_Pos      (26U)
#define HSEM_C1ISR_ISF26_Msk      (0x1UL << HSEM_C1ISR_ISF26_Pos)              /*!< 0x04000000 */
#define HSEM_C1ISR_ISF26          HSEM_C1ISR_ISF26_Msk                         /*!<semaphore 26 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF27_Pos      (27U)
#define HSEM_C1ISR_ISF27_Msk      (0x1UL << HSEM_C1ISR_ISF27_Pos)              /*!< 0x08000000 */
#define HSEM_C1ISR_ISF27          HSEM_C1ISR_ISF27_Msk                         /*!<semaphore 27 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF28_Pos      (28U)
#define HSEM_C1ISR_ISF28_Msk      (0x1UL << HSEM_C1ISR_ISF28_Pos)              /*!< 0x10000000 */
#define HSEM_C1ISR_ISF28          HSEM_C1ISR_ISF28_Msk                         /*!<semaphore 28 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF29_Pos      (29U)
#define HSEM_C1ISR_ISF29_Msk      (0x1UL << HSEM_C1ISR_ISF29_Pos)              /*!< 0x20000000 */
#define HSEM_C1ISR_ISF29          HSEM_C1ISR_ISF29_Msk                         /*!<semaphore 29 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF30_Pos      (30U)
#define HSEM_C1ISR_ISF30_Msk      (0x1UL << HSEM_C1ISR_ISF30_Pos)              /*!< 0x40000000 */
#define HSEM_C1ISR_ISF30          HSEM_C1ISR_ISF30_Msk                         /*!<semaphore 30 interrupt 0 status bit. */
#define HSEM_C1ISR_ISF31_Pos      (31U)
#define HSEM_C1ISR_ISF31_Msk      (0x1UL << HSEM_C1ISR_ISF31_Pos)              /*!< 0x80000000 */
#define HSEM_C1ISR_ISF31          HSEM_C1ISR_ISF31_Msk                         /*!<semaphore 31 interrupt 0 status bit. */

/********************  Bit definition for HSEM_C1MISR register  *****************/
#define HSEM_C1MISR_MISF0_Pos     (0U)
#define HSEM_C1MISR_MISF0_Msk     (0x1UL << HSEM_C1MISR_MISF0_Pos)             /*!< 0x00000001 */
#define HSEM_C1MISR_MISF0         HSEM_C1MISR_MISF0_Msk                        /*!<semaphore 0 interrupt 0 masked status bit.  */
#define HSEM_C1MISR_MISF1_Pos     (1U)
#define HSEM_C1MISR_MISF1_Msk     (0x1UL << HSEM_C1MISR_MISF1_Pos)             /*!< 0x00000002 */
#define HSEM_C1MISR_MISF1         HSEM_C1MISR_MISF1_Msk                        /*!<semaphore 1 interrupt 0 masked status bit.  */
#define HSEM_C1MISR_MISF2_Pos     (2U)
#define HSEM_C1MISR_MISF2_Msk     (0x1UL << HSEM_C1MISR_MISF2_Pos)             /*!< 0x00000004 */
#define HSEM_C1MISR_MISF2         HSEM_C1MISR_MISF2_Msk                        /*!<semaphore 2 interrupt 0 masked status bit.  */
#define HSEM_C1MISR_MISF3_Pos     (3U)
#define HSEM_C1MISR_MISF3_Msk     (0x1UL << HSEM_C1MISR_MISF3_Pos)             /*!< 0x00000008 */
#define HSEM_C1MISR_MISF3         HSEM_C1MISR_MISF3_Msk                        /*!<semaphore 3 interrupt 0 masked status bit.  */
#define HSEM_C1MISR_MISF4_Pos     (4U)
#define HSEM_C1MISR_MISF4_Msk     (0x1UL << HSEM_C1MISR_MISF4_Pos)             /*!< 0x00000010 */
#define HSEM_C1MISR_MISF4         HSEM_C1MISR_MISF4_Msk                        /*!<semaphore 4 interrupt 0 masked status bit.  */
#define HSEM_C1MISR_MISF5_Pos     (5U)
#define HSEM_C1MISR_MISF5_Msk     (0x1UL << HSEM_C1MISR_MISF5_Pos)             /*!< 0x00000020 */
#define HSEM_C1MISR_MISF5         HSEM_C1MISR_MISF5_Msk                        /*!<semaphore 5 interrupt 0 masked status bit.  */
#define HSEM_C1MISR_MISF6_Pos     (6U)
#define HSEM_C1MISR_MISF6_Msk     (0x1UL << HSEM_C1MISR_MISF6_Pos)             /*!< 0x00000040 */
#define HSEM_C1MISR_MISF6         HSEM_C1MISR_MISF6_Msk                        /*!<semaphore 6 interrupt 0 masked status bit.  */
#define HSEM_C1MISR_MISF7_Pos     (7U)
#define HSEM_C1MISR_MISF7_Msk     (0x1UL << HSEM_C1MISR_MISF7_Pos)             /*!< 0x00000080 */
#define HSEM_C1MISR_MISF7         HSEM_C1MISR_MISF7_Msk                        /*!<semaphore 7 interrupt 0 masked status bit.  */
#define HSEM_C1MISR_MISF8_Pos     (8U)
#define HSEM_C1MISR_MISF8_Msk     (0x1UL << HSEM_C1MISR_MISF8_Pos)             /*!< 0x00000100 */
#define HSEM_C1MISR_MISF8         HSEM_C1MISR_MISF8_Msk                        /*!<semaphore 8 interrupt 0 masked status bit.  */
#define HSEM_C1MISR_MISF9_Pos     (9U)
#define HSEM_C1MISR_MISF9_Msk     (0x1UL << HSEM_C1MISR_MISF9_Pos)             /*!< 0x00000200 */
#define HSEM_C1MISR_MISF9         HSEM_C1MISR_MISF9_Msk                        /*!<semaphore 9 interrupt 0 masked status bit.  */
#define HSEM_C1MISR_MISF10_Pos    (10U)
#define HSEM_C1MISR_MISF10_Msk    (0x1UL << HSEM_C1MISR_MISF10_Pos)            /*!< 0x00000400 */
#define HSEM_C1MISR_MISF10        HSEM_C1MISR_MISF10_Msk                       /*!<semaphore 10 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF11_Pos    (11U)
#define HSEM_C1MISR_MISF11_Msk    (0x1UL << HSEM_C1MISR_MISF11_Pos)            /*!< 0x00000800 */
#define HSEM_C1MISR_MISF11        HSEM_C1MISR_MISF11_Msk                       /*!<semaphore 11 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF12_Pos    (12U)
#define HSEM_C1MISR_MISF12_Msk    (0x1UL << HSEM_C1MISR_MISF12_Pos)            /*!< 0x00001000 */
#define HSEM_C1MISR_MISF12        HSEM_C1MISR_MISF12_Msk                       /*!<semaphore 12 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF13_Pos    (13U)
#define HSEM_C1MISR_MISF13_Msk    (0x1UL << HSEM_C1MISR_MISF13_Pos)            /*!< 0x00002000 */
#define HSEM_C1MISR_MISF13        HSEM_C1MISR_MISF13_Msk                       /*!<semaphore 13 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF14_Pos    (14U)
#define HSEM_C1MISR_MISF14_Msk    (0x1UL << HSEM_C1MISR_MISF14_Pos)            /*!< 0x00004000 */
#define HSEM_C1MISR_MISF14        HSEM_C1MISR_MISF14_Msk                       /*!<semaphore 14 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF15_Pos    (15U)
#define HSEM_C1MISR_MISF15_Msk    (0x1UL << HSEM_C1MISR_MISF15_Pos)            /*!< 0x00008000 */
#define HSEM_C1MISR_MISF15        HSEM_C1MISR_MISF15_Msk                       /*!<semaphore 15 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF16_Pos    (16U)
#define HSEM_C1MISR_MISF16_Msk    (0x1UL << HSEM_C1MISR_MISF16_Pos)            /*!< 0x00010000 */
#define HSEM_C1MISR_MISF16        HSEM_C1MISR_MISF16_Msk                       /*!<semaphore 16 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF17_Pos    (17U)
#define HSEM_C1MISR_MISF17_Msk    (0x1UL << HSEM_C1MISR_MISF17_Pos)            /*!< 0x00020000 */
#define HSEM_C1MISR_MISF17        HSEM_C1MISR_MISF17_Msk                       /*!<semaphore 17 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF18_Pos    (18U)
#define HSEM_C1MISR_MISF18_Msk    (0x1UL << HSEM_C1MISR_MISF18_Pos)            /*!< 0x00040000 */
#define HSEM_C1MISR_MISF18        HSEM_C1MISR_MISF18_Msk                       /*!<semaphore 18 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF19_Pos    (19U)
#define HSEM_C1MISR_MISF19_Msk    (0x1UL << HSEM_C1MISR_MISF19_Pos)            /*!< 0x00080000 */
#define HSEM_C1MISR_MISF19        HSEM_C1MISR_MISF19_Msk                       /*!<semaphore 19 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF20_Pos    (20U)
#define HSEM_C1MISR_MISF20_Msk    (0x1UL << HSEM_C1MISR_MISF20_Pos)            /*!< 0x00100000 */
#define HSEM_C1MISR_MISF20        HSEM_C1MISR_MISF20_Msk                       /*!<semaphore 20 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF21_Pos    (21U)
#define HSEM_C1MISR_MISF21_Msk    (0x1UL << HSEM_C1MISR_MISF21_Pos)            /*!< 0x00200000 */
#define HSEM_C1MISR_MISF21        HSEM_C1MISR_MISF21_Msk                       /*!<semaphore 21 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF22_Pos    (22U)
#define HSEM_C1MISR_MISF22_Msk    (0x1UL << HSEM_C1MISR_MISF22_Pos)            /*!< 0x00400000 */
#define HSEM_C1MISR_MISF22        HSEM_C1MISR_MISF22_Msk                       /*!<semaphore 22 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF23_Pos    (23U)
#define HSEM_C1MISR_MISF23_Msk    (0x1UL << HSEM_C1MISR_MISF23_Pos)            /*!< 0x00800000 */
#define HSEM_C1MISR_MISF23        HSEM_C1MISR_MISF23_Msk                       /*!<semaphore 23 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF24_Pos    (24U)
#define HSEM_C1MISR_MISF24_Msk    (0x1UL << HSEM_C1MISR_MISF24_Pos)            /*!< 0x01000000 */
#define HSEM_C1MISR_MISF24        HSEM_C1MISR_MISF24_Msk                       /*!<semaphore 24 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF25_Pos    (25U)
#define HSEM_C1MISR_MISF25_Msk    (0x1UL << HSEM_C1MISR_MISF25_Pos)            /*!< 0x02000000 */
#define HSEM_C1MISR_MISF25        HSEM_C1MISR_MISF25_Msk                       /*!<semaphore 25 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF26_Pos    (26U)
#define HSEM_C1MISR_MISF26_Msk    (0x1UL << HSEM_C1MISR_MISF26_Pos)            /*!< 0x04000000 */
#define HSEM_C1MISR_MISF26        HSEM_C1MISR_MISF26_Msk                       /*!<semaphore 26 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF27_Pos    (27U)
#define HSEM_C1MISR_MISF27_Msk    (0x1UL << HSEM_C1MISR_MISF27_Pos)            /*!< 0x08000000 */
#define HSEM_C1MISR_MISF27        HSEM_C1MISR_MISF27_Msk                       /*!<semaphore 27 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF28_Pos    (28U)
#define HSEM_C1MISR_MISF28_Msk    (0x1UL << HSEM_C1MISR_MISF28_Pos)            /*!< 0x10000000 */
#define HSEM_C1MISR_MISF28        HSEM_C1MISR_MISF28_Msk                       /*!<semaphore 28 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF29_Pos    (29U)
#define HSEM_C1MISR_MISF29_Msk    (0x1UL << HSEM_C1MISR_MISF29_Pos)            /*!< 0x20000000 */
#define HSEM_C1MISR_MISF29        HSEM_C1MISR_MISF29_Msk                       /*!<semaphore 29 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF30_Pos    (30U)
#define HSEM_C1MISR_MISF30_Msk    (0x1UL << HSEM_C1MISR_MISF30_Pos)            /*!< 0x40000000 */
#define HSEM_C1MISR_MISF30        HSEM_C1MISR_MISF30_Msk                       /*!<semaphore 30 interrupt 0 masked status bit. */
#define HSEM_C1MISR_MISF31_Pos    (31U)
#define HSEM_C1MISR_MISF31_Msk    (0x1UL << HSEM_C1MISR_MISF31_Pos)            /*!< 0x80000000 */
#define HSEM_C1MISR_MISF31        HSEM_C1MISR_MISF31_Msk                       /*!<semaphore 31 interrupt 0 masked status bit. */

/********************  Bit definition for HSEM_CR register  *****************/
#define HSEM_CR_COREID_Pos        (8U)
#define HSEM_CR_COREID_Msk        (0xFFUL << HSEM_CR_COREID_Pos)               /*!< 0x0000FF00 */
#define HSEM_CR_COREID            HSEM_CR_COREID_Msk                            /*!<CoreID of semaphores to be cleared. */
#define HSEM_CR_KEY_Pos           (16U)
#define HSEM_CR_KEY_Msk           (0xFFFFUL << HSEM_CR_KEY_Pos)                /*!< 0xFFFF0000 */
#define HSEM_CR_KEY               HSEM_CR_KEY_Msk                               /*!<semaphores clear key. */

/********************  Bit definition for HSEM_KEYR register  *****************/
#define HSEM_KEYR_KEY_Pos         (16U)
#define HSEM_KEYR_KEY_Msk         (0xFFFFUL << HSEM_KEYR_KEY_Pos)              /*!< 0xFFFF0000 */
#define HSEM_KEYR_KEY             HSEM_KEYR_KEY_Msk                             /*!<semaphores clear key. */

/******************************************************************************/
/*                                                                            */
/*                                    HASH                                    */
/*                                                                            */
/******************************************************************************/
/******************  Bits definition for HASH_CR register  ********************/
#define HASH_CR_INIT_Pos          (2U)
#define HASH_CR_INIT_Msk          (0x1U << HASH_CR_INIT_Pos)                   /*!< 0x00000004 */
#define HASH_CR_INIT              HASH_CR_INIT_Msk
#define HASH_CR_DMAE_Pos          (3U)
#define HASH_CR_DMAE_Msk          (0x1U << HASH_CR_DMAE_Pos)                   /*!< 0x00000008 */
#define HASH_CR_DMAE              HASH_CR_DMAE_Msk
#define HASH_CR_DATATYPE_Pos      (4U)
#define HASH_CR_DATATYPE_Msk      (0x3U << HASH_CR_DATATYPE_Pos)               /*!< 0x00000030 */
#define HASH_CR_DATATYPE          HASH_CR_DATATYPE_Msk
#define HASH_CR_DATATYPE_0        (0x1U << HASH_CR_DATATYPE_Pos)               /*!< 0x00000010 */
#define HASH_CR_DATATYPE_1        (0x2U << HASH_CR_DATATYPE_Pos)               /*!< 0x00000020 */
#define HASH_CR_MODE_Pos          (6U)
#define HASH_CR_MODE_Msk          (0x1U << HASH_CR_MODE_Pos)                   /*!< 0x00000040 */
#define HASH_CR_MODE              HASH_CR_MODE_Msk
#define HASH_CR_ALGO_Pos          (7U)
#define HASH_CR_ALGO_Msk          (0x801U << HASH_CR_ALGO_Pos)                 /*!< 0x00040080 */
#define HASH_CR_ALGO              HASH_CR_ALGO_Msk
#define HASH_CR_ALGO_0            (0x001U << HASH_CR_ALGO_Pos)                 /*!< 0x00000080 */
#define HASH_CR_ALGO_1            (0x800U << HASH_CR_ALGO_Pos)                 /*!< 0x00040000 */
#define HASH_CR_NBW_Pos           (8U)
#define HASH_CR_NBW_Msk           (0xFU << HASH_CR_NBW_Pos)                    /*!< 0x00000F00 */
#define HASH_CR_NBW               HASH_CR_NBW_Msk
#define HASH_CR_NBW_0             (0x1U << HASH_CR_NBW_Pos)                    /*!< 0x00000100 */
#define HASH_CR_NBW_1             (0x2U << HASH_CR_NBW_Pos)                    /*!< 0x00000200 */
#define HASH_CR_NBW_2             (0x4U << HASH_CR_NBW_Pos)                    /*!< 0x00000400 */
#define HASH_CR_NBW_3             (0x8U << HASH_CR_NBW_Pos)                    /*!< 0x00000800 */
#define HASH_CR_DINNE_Pos         (12U)
#define HASH_CR_DINNE_Msk         (0x1U << HASH_CR_DINNE_Pos)                  /*!< 0x00001000 */
#define HASH_CR_DINNE             HASH_CR_DINNE_Msk
#define HASH_CR_MDMAT_Pos         (13U)
#define HASH_CR_MDMAT_Msk         (0x1U << HASH_CR_MDMAT_Pos)                  /*!< 0x00002000 */
#define HASH_CR_MDMAT             HASH_CR_MDMAT_Msk
#define HASH_CR_DMAA_Pos          (14U)
#define HASH_CR_DMAA_Msk          (0x1U << HASH_CR_DMAA_Pos)                   /*!< 0x00004000 */
#define HASH_CR_DMAA              HASH_CR_DMAA_Msk
#define HASH_CR_LKEY_Pos          (16U)
#define HASH_CR_LKEY_Msk          (0x1U << HASH_CR_LKEY_Pos)                   /*!< 0x00010000 */
#define HASH_CR_LKEY              HASH_CR_LKEY_Msk

/******************  Bits definition for HASH_STR register  *******************/
#define HASH_STR_NBLW_Pos         (0U)
#define HASH_STR_NBLW_Msk         (0x1FU << HASH_STR_NBLW_Pos)                 /*!< 0x0000001F */
#define HASH_STR_NBLW             HASH_STR_NBLW_Msk
#define HASH_STR_NBLW_0           (0x01U << HASH_STR_NBLW_Pos)                 /*!< 0x00000001 */
#define HASH_STR_NBLW_1           (0x02U << HASH_STR_NBLW_Pos)                 /*!< 0x00000002 */
#define HASH_STR_NBLW_2           (0x04U << HASH_STR_NBLW_Pos)                 /*!< 0x00000004 */
#define HASH_STR_NBLW_3           (0x08U << HASH_STR_NBLW_Pos)                 /*!< 0x00000008 */
#define HASH_STR_NBLW_4           (0x10U << HASH_STR_NBLW_Pos)                 /*!< 0x00000010 */
#define HASH_STR_DCAL_Pos         (8U)
#define HASH_STR_DCAL_Msk         (0x1U << HASH_STR_DCAL_Pos)                  /*!< 0x00000100 */
#define HASH_STR_DCAL             HASH_STR_DCAL_Msk

/******************  Bits definition for HASH_IMR register  *******************/
#define HASH_IMR_DINIE_Pos        (0U)
#define HASH_IMR_DINIE_Msk        (0x1U << HASH_IMR_DINIE_Pos)                 /*!< 0x00000001 */
#define HASH_IMR_DINIE            HASH_IMR_DINIE_Msk
#define HASH_IMR_DCIE_Pos         (1U)
#define HASH_IMR_DCIE_Msk         (0x1U << HASH_IMR_DCIE_Pos)                  /*!< 0x00000002 */
#define HASH_IMR_DCIE             HASH_IMR_DCIE_Msk

/******************  Bits definition for HASH_SR register  ********************/
#define HASH_SR_DINIS_Pos         (0U)
#define HASH_SR_DINIS_Msk         (0x1U << HASH_SR_DINIS_Pos)                  /*!< 0x00000001 */
#define HASH_SR_DINIS             HASH_SR_DINIS_Msk
#define HASH_SR_DCIS_Pos          (1U)
#define HASH_SR_DCIS_Msk          (0x1U << HASH_SR_DCIS_Pos)                   /*!< 0x00000002 */
#define HASH_SR_DCIS              HASH_SR_DCIS_Msk
#define HASH_SR_DMAS_Pos          (2U)
#define HASH_SR_DMAS_Msk          (0x1U << HASH_SR_DMAS_Pos)                   /*!< 0x00000004 */
#define HASH_SR_DMAS              HASH_SR_DMAS_Msk
#define HASH_SR_BUSY_Pos          (3U)
#define HASH_SR_BUSY_Msk          (0x1U << HASH_SR_BUSY_Pos)                   /*!< 0x00000008 */
#define HASH_SR_BUSY              HASH_SR_BUSY_Msk

/******************************************************************************/
/*                                                                            */
/*                      Inter-integrated Circuit Interface (I2C)              */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for I2C_CR1 register  *******************/
#define I2C_CR1_PE_Pos               (0U)
#define I2C_CR1_PE_Msk               (0x1U << I2C_CR1_PE_Pos)                  /*!< 0x00000001 */
#define I2C_CR1_PE                   I2C_CR1_PE_Msk                            /*!< Peripheral enable */
#define I2C_CR1_TXIE_Pos             (1U)
#define I2C_CR1_TXIE_Msk             (0x1U << I2C_CR1_TXIE_Pos)                /*!< 0x00000002 */
#define I2C_CR1_TXIE                 I2C_CR1_TXIE_Msk                          /*!< TX interrupt enable */
#define I2C_CR1_RXIE_Pos             (2U)
#define I2C_CR1_RXIE_Msk             (0x1U << I2C_CR1_RXIE_Pos)                /*!< 0x00000004 */
#define I2C_CR1_RXIE                 I2C_CR1_RXIE_Msk                          /*!< RX interrupt enable */
#define I2C_CR1_ADDRIE_Pos           (3U)
#define I2C_CR1_ADDRIE_Msk           (0x1U << I2C_CR1_ADDRIE_Pos)              /*!< 0x00000008 */
#define I2C_CR1_ADDRIE               I2C_CR1_ADDRIE_Msk                        /*!< Address match interrupt enable */
#define I2C_CR1_NACKIE_Pos           (4U)
#define I2C_CR1_NACKIE_Msk           (0x1U << I2C_CR1_NACKIE_Pos)              /*!< 0x00000010 */
#define I2C_CR1_NACKIE               I2C_CR1_NACKIE_Msk                        /*!< NACK received interrupt enable */
#define I2C_CR1_STOPIE_Pos           (5U)
#define I2C_CR1_STOPIE_Msk           (0x1U << I2C_CR1_STOPIE_Pos)              /*!< 0x00000020 */
#define I2C_CR1_STOPIE               I2C_CR1_STOPIE_Msk                        /*!< STOP detection interrupt enable */
#define I2C_CR1_TCIE_Pos             (6U)
#define I2C_CR1_TCIE_Msk             (0x1U << I2C_CR1_TCIE_Pos)                /*!< 0x00000040 */
#define I2C_CR1_TCIE                 I2C_CR1_TCIE_Msk                          /*!< Transfer complete interrupt enable */
#define I2C_CR1_ERRIE_Pos            (7U)
#define I2C_CR1_ERRIE_Msk            (0x1U << I2C_CR1_ERRIE_Pos)               /*!< 0x00000080 */
#define I2C_CR1_ERRIE                I2C_CR1_ERRIE_Msk                         /*!< Errors interrupt enable */
#define I2C_CR1_DNF_Pos              (8U)
#define I2C_CR1_DNF_Msk              (0xFU << I2C_CR1_DNF_Pos)                 /*!< 0x00000F00 */
#define I2C_CR1_DNF                  I2C_CR1_DNF_Msk                           /*!< Digital noise filter */
#define I2C_CR1_ANFOFF_Pos           (12U)
#define I2C_CR1_ANFOFF_Msk           (0x1U << I2C_CR1_ANFOFF_Pos)              /*!< 0x00001000 */
#define I2C_CR1_ANFOFF               I2C_CR1_ANFOFF_Msk                        /*!< Analog noise filter OFF */
#define I2C_CR1_SWRST_Pos            (13U)
#define I2C_CR1_SWRST_Msk            (0x1U << I2C_CR1_SWRST_Pos)               /*!< 0x00002000 */
#define I2C_CR1_SWRST                I2C_CR1_SWRST_Msk                         /*!< Software reset */
#define I2C_CR1_TXDMAEN_Pos          (14U)
#define I2C_CR1_TXDMAEN_Msk          (0x1U << I2C_CR1_TXDMAEN_Pos)             /*!< 0x00004000 */
#define I2C_CR1_TXDMAEN              I2C_CR1_TXDMAEN_Msk                       /*!< DMA transmission requests enable */
#define I2C_CR1_RXDMAEN_Pos          (15U)
#define I2C_CR1_RXDMAEN_Msk          (0x1U << I2C_CR1_RXDMAEN_Pos)             /*!< 0x00008000 */
#define I2C_CR1_RXDMAEN              I2C_CR1_RXDMAEN_Msk                       /*!< DMA reception requests enable */
#define I2C_CR1_SBC_Pos              (16U)
#define I2C_CR1_SBC_Msk              (0x1U << I2C_CR1_SBC_Pos)                 /*!< 0x00010000 */
#define I2C_CR1_SBC                  I2C_CR1_SBC_Msk                           /*!< Slave byte control */
#define I2C_CR1_NOSTRETCH_Pos        (17U)
#define I2C_CR1_NOSTRETCH_Msk        (0x1U << I2C_CR1_NOSTRETCH_Pos)           /*!< 0x00020000 */
#define I2C_CR1_NOSTRETCH            I2C_CR1_NOSTRETCH_Msk                     /*!< Clock stretching disable */
#define I2C_CR1_WUPEN_Pos            (18U)
#define I2C_CR1_WUPEN_Msk            (0x1U << I2C_CR1_WUPEN_Pos)               /*!< 0x00040000 */
#define I2C_CR1_WUPEN                I2C_CR1_WUPEN_Msk                         /*!< Wakeup from STOP enable */
#define I2C_CR1_GCEN_Pos             (19U)
#define I2C_CR1_GCEN_Msk             (0x1U << I2C_CR1_GCEN_Pos)                /*!< 0x00080000 */
#define I2C_CR1_GCEN                 I2C_CR1_GCEN_Msk                          /*!< General call enable */
#define I2C_CR1_SMBHEN_Pos           (20U)
#define I2C_CR1_SMBHEN_Msk           (0x1U << I2C_CR1_SMBHEN_Pos)              /*!< 0x00100000 */
#define I2C_CR1_SMBHEN               I2C_CR1_SMBHEN_Msk                        /*!< SMBus host address enable */
#define I2C_CR1_SMBDEN_Pos           (21U)
#define I2C_CR1_SMBDEN_Msk           (0x1U << I2C_CR1_SMBDEN_Pos)              /*!< 0x00200000 */
#define I2C_CR1_SMBDEN               I2C_CR1_SMBDEN_Msk                        /*!< SMBus device default address enable */
#define I2C_CR1_ALERTEN_Pos          (22U)
#define I2C_CR1_ALERTEN_Msk          (0x1U << I2C_CR1_ALERTEN_Pos)             /*!< 0x00400000 */
#define I2C_CR1_ALERTEN              I2C_CR1_ALERTEN_Msk                       /*!< SMBus alert enable */
#define I2C_CR1_PECEN_Pos            (23U)
#define I2C_CR1_PECEN_Msk            (0x1U << I2C_CR1_PECEN_Pos)               /*!< 0x00800000 */
#define I2C_CR1_PECEN                I2C_CR1_PECEN_Msk                         /*!< PEC enable */

/******************  Bit definition for I2C_CR2 register  ********************/
#define I2C_CR2_SADD_Pos             (0U)
#define I2C_CR2_SADD_Msk             (0x3FFU << I2C_CR2_SADD_Pos)              /*!< 0x000003FF */
#define I2C_CR2_SADD                 I2C_CR2_SADD_Msk                          /*!< Slave address (master mode) */
#define I2C_CR2_RD_WRN_Pos           (10U)
#define I2C_CR2_RD_WRN_Msk           (0x1U << I2C_CR2_RD_WRN_Pos)              /*!< 0x00000400 */
#define I2C_CR2_RD_WRN               I2C_CR2_RD_WRN_Msk                        /*!< Transfer direction (master mode) */
#define I2C_CR2_ADD10_Pos            (11U)
#define I2C_CR2_ADD10_Msk            (0x1U << I2C_CR2_ADD10_Pos)               /*!< 0x00000800 */
#define I2C_CR2_ADD10                I2C_CR2_ADD10_Msk                         /*!< 10-bit addressing mode (master mode) */
#define I2C_CR2_HEAD10R_Pos          (12U)
#define I2C_CR2_HEAD10R_Msk          (0x1U << I2C_CR2_HEAD10R_Pos)             /*!< 0x00001000 */
#define I2C_CR2_HEAD10R              I2C_CR2_HEAD10R_Msk                       /*!< 10-bit address header only read direction (master mode) */
#define I2C_CR2_START_Pos            (13U)
#define I2C_CR2_START_Msk            (0x1U << I2C_CR2_START_Pos)               /*!< 0x00002000 */
#define I2C_CR2_START                I2C_CR2_START_Msk                         /*!< START generation */
#define I2C_CR2_STOP_Pos             (14U)
#define I2C_CR2_STOP_Msk             (0x1U << I2C_CR2_STOP_Pos)                /*!< 0x00004000 */
#define I2C_CR2_STOP                 I2C_CR2_STOP_Msk                          /*!< STOP generation (master mode) */
#define I2C_CR2_NACK_Pos             (15U)
#define I2C_CR2_NACK_Msk             (0x1U << I2C_CR2_NACK_Pos)                /*!< 0x00008000 */
#define I2C_CR2_NACK                 I2C_CR2_NACK_Msk                          /*!< NACK generation (slave mode) */
#define I2C_CR2_NBYTES_Pos           (16U)
#define I2C_CR2_NBYTES_Msk           (0xFFU << I2C_CR2_NBYTES_Pos)             /*!< 0x00FF0000 */
#define I2C_CR2_NBYTES               I2C_CR2_NBYTES_Msk                        /*!< Number of bytes */
#define I2C_CR2_RELOAD_Pos           (24U)
#define I2C_CR2_RELOAD_Msk           (0x1U << I2C_CR2_RELOAD_Pos)              /*!< 0x01000000 */
#define I2C_CR2_RELOAD               I2C_CR2_RELOAD_Msk                        /*!< NBYTES reload mode */
#define I2C_CR2_AUTOEND_Pos          (25U)
#define I2C_CR2_AUTOEND_Msk          (0x1U << I2C_CR2_AUTOEND_Pos)             /*!< 0x02000000 */
#define I2C_CR2_AUTOEND              I2C_CR2_AUTOEND_Msk                       /*!< Automatic end mode (master mode) */
#define I2C_CR2_PECBYTE_Pos          (26U)
#define I2C_CR2_PECBYTE_Msk          (0x1U << I2C_CR2_PECBYTE_Pos)             /*!< 0x04000000 */
#define I2C_CR2_PECBYTE              I2C_CR2_PECBYTE_Msk                       /*!< Packet error checking byte */

/*******************  Bit definition for I2C_OAR1 register  ******************/
#define I2C_OAR1_OA1_Pos             (0U)
#define I2C_OAR1_OA1_Msk             (0x3FFU << I2C_OAR1_OA1_Pos)              /*!< 0x000003FF */
#define I2C_OAR1_OA1                 I2C_OAR1_OA1_Msk                          /*!< Interface own address 1 */
#define I2C_OAR1_OA1MODE_Pos         (10U)
#define I2C_OAR1_OA1MODE_Msk         (0x1U << I2C_OAR1_OA1MODE_Pos)            /*!< 0x00000400 */
#define I2C_OAR1_OA1MODE             I2C_OAR1_OA1MODE_Msk                      /*!< Own address 1 10-bit mode */
#define I2C_OAR1_OA1EN_Pos           (15U)
#define I2C_OAR1_OA1EN_Msk           (0x1U << I2C_OAR1_OA1EN_Pos)              /*!< 0x00008000 */
#define I2C_OAR1_OA1EN               I2C_OAR1_OA1EN_Msk                        /*!< Own address 1 enable */

/*******************  Bit definition for I2C_OAR2 register  ******************/
#define I2C_OAR2_OA2_Pos             (1U)
#define I2C_OAR2_OA2_Msk             (0x7FU << I2C_OAR2_OA2_Pos)               /*!< 0x000000FE */
#define I2C_OAR2_OA2                 I2C_OAR2_OA2_Msk                          /*!< Interface own address 2 */
#define I2C_OAR2_OA2MSK_Pos          (8U)
#define I2C_OAR2_OA2MSK_Msk          (0x7U << I2C_OAR2_OA2MSK_Pos)             /*!< 0x00000700 */
#define I2C_OAR2_OA2MSK              I2C_OAR2_OA2MSK_Msk                       /*!< Own address 2 masks */
#define I2C_OAR2_OA2EN_Pos           (15U)
#define I2C_OAR2_OA2EN_Msk           (0x1U << I2C_OAR2_OA2EN_Pos)              /*!< 0x00008000 */
#define I2C_OAR2_OA2EN               I2C_OAR2_OA2EN_Msk                        /*!< Own address 2 enable */

/*******************  Bit definition for I2C_TIMINGR register *******************/
#define I2C_TIMINGR_SCLL_Pos         (0U)
#define I2C_TIMINGR_SCLL_Msk         (0xFFU << I2C_TIMINGR_SCLL_Pos)           /*!< 0x000000FF */
#define I2C_TIMINGR_SCLL             I2C_TIMINGR_SCLL_Msk                      /*!< SCL low period (master mode) */
#define I2C_TIMINGR_SCLH_Pos         (8U)
#define I2C_TIMINGR_SCLH_Msk         (0xFFU << I2C_TIMINGR_SCLH_Pos)           /*!< 0x0000FF00 */
#define I2C_TIMINGR_SCLH             I2C_TIMINGR_SCLH_Msk                      /*!< SCL high period (master mode) */
#define I2C_TIMINGR_SDADEL_Pos       (16U)
#define I2C_TIMINGR_SDADEL_Msk       (0xFU << I2C_TIMINGR_SDADEL_Pos)          /*!< 0x000F0000 */
#define I2C_TIMINGR_SDADEL           I2C_TIMINGR_SDADEL_Msk                    /*!< Data hold time */
#define I2C_TIMINGR_SCLDEL_Pos       (20U)
#define I2C_TIMINGR_SCLDEL_Msk       (0xFU << I2C_TIMINGR_SCLDEL_Pos)          /*!< 0x00F00000 */
#define I2C_TIMINGR_SCLDEL           I2C_TIMINGR_SCLDEL_Msk                    /*!< Data setup time */
#define I2C_TIMINGR_PRESC_Pos        (28U)
#define I2C_TIMINGR_PRESC_Msk        (0xFU << I2C_TIMINGR_PRESC_Pos)           /*!< 0xF0000000 */
#define I2C_TIMINGR_PRESC            I2C_TIMINGR_PRESC_Msk                     /*!< Timings prescaler */

/******************* Bit definition for I2C_TIMEOUTR register *******************/
#define I2C_TIMEOUTR_TIMEOUTA_Pos    (0U)
#define I2C_TIMEOUTR_TIMEOUTA_Msk    (0xFFFU << I2C_TIMEOUTR_TIMEOUTA_Pos)     /*!< 0x00000FFF */
#define I2C_TIMEOUTR_TIMEOUTA        I2C_TIMEOUTR_TIMEOUTA_Msk                 /*!< Bus timeout A */
#define I2C_TIMEOUTR_TIDLE_Pos       (12U)
#define I2C_TIMEOUTR_TIDLE_Msk       (0x1U << I2C_TIMEOUTR_TIDLE_Pos)          /*!< 0x00001000 */
#define I2C_TIMEOUTR_TIDLE           I2C_TIMEOUTR_TIDLE_Msk                    /*!< Idle clock timeout detection */
#define I2C_TIMEOUTR_TIMOUTEN_Pos    (15U)
#define I2C_TIMEOUTR_TIMOUTEN_Msk    (0x1U << I2C_TIMEOUTR_TIMOUTEN_Pos)       /*!< 0x00008000 */
#define I2C_TIMEOUTR_TIMOUTEN        I2C_TIMEOUTR_TIMOUTEN_Msk                 /*!< Clock timeout enable */
#define I2C_TIMEOUTR_TIMEOUTB_Pos    (16U)
#define I2C_TIMEOUTR_TIMEOUTB_Msk    (0xFFFU << I2C_TIMEOUTR_TIMEOUTB_Pos)     /*!< 0x0FFF0000 */
#define I2C_TIMEOUTR_TIMEOUTB        I2C_TIMEOUTR_TIMEOUTB_Msk                 /*!< Bus timeout B*/
#define I2C_TIMEOUTR_TEXTEN_Pos      (31U)
#define I2C_TIMEOUTR_TEXTEN_Msk      (0x1U << I2C_TIMEOUTR_TEXTEN_Pos)         /*!< 0x80000000 */
#define I2C_TIMEOUTR_TEXTEN          I2C_TIMEOUTR_TEXTEN_Msk                   /*!< Extended clock timeout enable */

/******************  Bit definition for I2C_ISR register  *********************/
#define I2C_ISR_TXE_Pos              (0U)
#define I2C_ISR_TXE_Msk              (0x1U << I2C_ISR_TXE_Pos)                 /*!< 0x00000001 */
#define I2C_ISR_TXE                  I2C_ISR_TXE_Msk                           /*!< Transmit data register empty */
#define I2C_ISR_TXIS_Pos             (1U)
#define I2C_ISR_TXIS_Msk             (0x1U << I2C_ISR_TXIS_Pos)                /*!< 0x00000002 */
#define I2C_ISR_TXIS                 I2C_ISR_TXIS_Msk                          /*!< Transmit interrupt status */
#define I2C_ISR_RXNE_Pos             (2U)
#define I2C_ISR_RXNE_Msk             (0x1U << I2C_ISR_RXNE_Pos)                /*!< 0x00000004 */
#define I2C_ISR_RXNE                 I2C_ISR_RXNE_Msk                          /*!< Receive data register not empty */
#define I2C_ISR_ADDR_Pos             (3U)
#define I2C_ISR_ADDR_Msk             (0x1U << I2C_ISR_ADDR_Pos)                /*!< 0x00000008 */
#define I2C_ISR_ADDR                 I2C_ISR_ADDR_Msk                          /*!< Address matched (slave mode)*/
#define I2C_ISR_NACKF_Pos            (4U)
#define I2C_ISR_NACKF_Msk            (0x1U << I2C_ISR_NACKF_Pos)               /*!< 0x00000010 */
#define I2C_ISR_NACKF                I2C_ISR_NACKF_Msk                         /*!< NACK received flag */
#define I2C_ISR_STOPF_Pos            (5U)
#define I2C_ISR_STOPF_Msk            (0x1U << I2C_ISR_STOPF_Pos)               /*!< 0x00000020 */
#define I2C_ISR_STOPF                I2C_ISR_STOPF_Msk                         /*!< STOP detection flag */
#define I2C_ISR_TC_Pos               (6U)
#define I2C_ISR_TC_Msk               (0x1U << I2C_ISR_TC_Pos)                  /*!< 0x00000040 */
#define I2C_ISR_TC                   I2C_ISR_TC_Msk                            /*!< Transfer complete (master mode) */
#define I2C_ISR_TCR_Pos              (7U)
#define I2C_ISR_TCR_Msk              (0x1U << I2C_ISR_TCR_Pos)                 /*!< 0x00000080 */
#define I2C_ISR_TCR                  I2C_ISR_TCR_Msk                           /*!< Transfer complete reload */
#define I2C_ISR_BERR_Pos             (8U)
#define I2C_ISR_BERR_Msk             (0x1U << I2C_ISR_BERR_Pos)                /*!< 0x00000100 */
#define I2C_ISR_BERR                 I2C_ISR_BERR_Msk                          /*!< Bus error */
#define I2C_ISR_ARLO_Pos             (9U)
#define I2C_ISR_ARLO_Msk             (0x1U << I2C_ISR_ARLO_Pos)                /*!< 0x00000200 */
#define I2C_ISR_ARLO                 I2C_ISR_ARLO_Msk                          /*!< Arbitration lost */
#define I2C_ISR_OVR_Pos              (10U)
#define I2C_ISR_OVR_Msk              (0x1U << I2C_ISR_OVR_Pos)                 /*!< 0x00000400 */
#define I2C_ISR_OVR                  I2C_ISR_OVR_Msk                           /*!< Overrun/Underrun */
#define I2C_ISR_PECERR_Pos           (11U)
#define I2C_ISR_PECERR_Msk           (0x1U << I2C_ISR_PECERR_Pos)              /*!< 0x00000800 */
#define I2C_ISR_PECERR               I2C_ISR_PECERR_Msk                        /*!< PEC error in reception */
#define I2C_ISR_TIMEOUT_Pos          (12U)
#define I2C_ISR_TIMEOUT_Msk          (0x1U << I2C_ISR_TIMEOUT_Pos)             /*!< 0x00001000 */
#define I2C_ISR_TIMEOUT              I2C_ISR_TIMEOUT_Msk                       /*!< Timeout or Tlow detection flag */
#define I2C_ISR_ALERT_Pos            (13U)
#define I2C_ISR_ALERT_Msk            (0x1U << I2C_ISR_ALERT_Pos)               /*!< 0x00002000 */
#define I2C_ISR_ALERT                I2C_ISR_ALERT_Msk                         /*!< SMBus alert */
#define I2C_ISR_BUSY_Pos             (15U)
#define I2C_ISR_BUSY_Msk             (0x1U << I2C_ISR_BUSY_Pos)                /*!< 0x00008000 */
#define I2C_ISR_BUSY                 I2C_ISR_BUSY_Msk                          /*!< Bus busy */
#define I2C_ISR_DIR_Pos              (16U)
#define I2C_ISR_DIR_Msk              (0x1U << I2C_ISR_DIR_Pos)                 /*!< 0x00010000 */
#define I2C_ISR_DIR                  I2C_ISR_DIR_Msk                           /*!< Transfer direction (slave mode) */
#define I2C_ISR_ADDCODE_Pos          (17U)
#define I2C_ISR_ADDCODE_Msk          (0x7FU << I2C_ISR_ADDCODE_Pos)            /*!< 0x00FE0000 */
#define I2C_ISR_ADDCODE              I2C_ISR_ADDCODE_Msk                       /*!< Address match code (slave mode) */

/******************  Bit definition for I2C_ICR register  *********************/
#define I2C_ICR_ADDRCF_Pos           (3U)
#define I2C_ICR_ADDRCF_Msk           (0x1U << I2C_ICR_ADDRCF_Pos)              /*!< 0x00000008 */
#define I2C_ICR_ADDRCF               I2C_ICR_ADDRCF_Msk                        /*!< Address matched clear flag */
#define I2C_ICR_NACKCF_Pos           (4U)
#define I2C_ICR_NACKCF_Msk           (0x1U << I2C_ICR_NACKCF_Pos)              /*!< 0x00000010 */
#define I2C_ICR_NACKCF               I2C_ICR_NACKCF_Msk                        /*!< NACK clear flag */
#define I2C_ICR_STOPCF_Pos           (5U)
#define I2C_ICR_STOPCF_Msk           (0x1U << I2C_ICR_STOPCF_Pos)              /*!< 0x00000020 */
#define I2C_ICR_STOPCF               I2C_ICR_STOPCF_Msk                        /*!< STOP detection clear flag */
#define I2C_ICR_BERRCF_Pos           (8U)
#define I2C_ICR_BERRCF_Msk           (0x1U << I2C_ICR_BERRCF_Pos)              /*!< 0x00000100 */
#define I2C_ICR_BERRCF               I2C_ICR_BERRCF_Msk                        /*!< Bus error clear flag */
#define I2C_ICR_ARLOCF_Pos           (9U)
#define I2C_ICR_ARLOCF_Msk           (0x1U << I2C_ICR_ARLOCF_Pos)              /*!< 0x00000200 */
#define I2C_ICR_ARLOCF               I2C_ICR_ARLOCF_Msk                        /*!< Arbitration lost clear flag */
#define I2C_ICR_OVRCF_Pos            (10U)
#define I2C_ICR_OVRCF_Msk            (0x1U << I2C_ICR_OVRCF_Pos)               /*!< 0x00000400 */
#define I2C_ICR_OVRCF                I2C_ICR_OVRCF_Msk                         /*!< Overrun/Underrun clear flag */
#define I2C_ICR_PECCF_Pos            (11U)
#define I2C_ICR_PECCF_Msk            (0x1U << I2C_ICR_PECCF_Pos)               /*!< 0x00000800 */
#define I2C_ICR_PECCF                I2C_ICR_PECCF_Msk                         /*!< PAC error clear flag */
#define I2C_ICR_TIMOUTCF_Pos         (12U)
#define I2C_ICR_TIMOUTCF_Msk         (0x1U << I2C_ICR_TIMOUTCF_Pos)            /*!< 0x00001000 */
#define I2C_ICR_TIMOUTCF             I2C_ICR_TIMOUTCF_Msk                      /*!< Timeout clear flag */
#define I2C_ICR_ALERTCF_Pos          (13U)
#define I2C_ICR_ALERTCF_Msk          (0x1U << I2C_ICR_ALERTCF_Pos)             /*!< 0x00002000 */
#define I2C_ICR_ALERTCF              I2C_ICR_ALERTCF_Msk                       /*!< Alert clear flag */

/******************  Bit definition for I2C_PECR register  *********************/
#define I2C_PECR_PEC_Pos             (0U)
#define I2C_PECR_PEC_Msk             (0xFFU << I2C_PECR_PEC_Pos)               /*!< 0x000000FF */
#define I2C_PECR_PEC                 I2C_PECR_PEC_Msk                          /*!< PEC register */

/******************  Bit definition for I2C_RXDR register  *********************/
#define I2C_RXDR_RXDATA_Pos          (0U)
#define I2C_RXDR_RXDATA_Msk          (0xFFU << I2C_RXDR_RXDATA_Pos)            /*!< 0x000000FF */
#define I2C_RXDR_RXDATA              I2C_RXDR_RXDATA_Msk                       /*!< 8-bit receive data */

/******************  Bit definition for I2C_TXDR register  *********************/
#define I2C_TXDR_TXDATA_Pos          (0U)
#define I2C_TXDR_TXDATA_Msk          (0xFFU << I2C_TXDR_TXDATA_Pos)            /*!< 0x000000FF */
#define I2C_TXDR_TXDATA              I2C_TXDR_TXDATA_Msk                       /*!< 8-bit transmit data */

/********************  Bit definition for I2C_VERR register***********************/
#define I2C_VERR_MINREV_Pos          (0U)
#define I2C_VERR_MINREV_Msk          (0xFU << I2C_VERR_MINREV_Pos)             /*!< 0x0000000F */
#define I2C_VERR_MINREV              I2C_VERR_MINREV_Msk                       /*Minor Revision of the IP*/
#define I2C_VERR_MAJREV_Pos          (4U)
#define I2C_VERR_MAJREV_Msk          (0xFU << I2C_VERR_MAJREV_Pos)             /*!< 0x000000F0 */
#define I2C_VERR_MAJREV              I2C_VERR_MAJREV_Msk                       /*Major Revision of the IP*/

/********************  Bit definition for I2C_IPIDR register**********************/
#define I2C_IPIDR_ID_Pos             (0U)
#define I2C_IPIDR_ID_Msk             (0xFFFFFFFFU << I2C_IPIDR_ID_Pos)         /*!< 0xFFFFFFFF */
#define I2C_IPIDR_ID                 I2C_IPIDR_ID_Msk                          /*IP Identifier*/

/********************  Bit definition for I2C_SIDR register**********************/
#define I2C_SIDR_SID_Pos             (0U)
#define I2C_SIDR_SID_Msk             (0xFFFFFFFFU << I2C_SIDR_SID_Pos)         /*!< 0xFFFFFFFF */
#define I2C_SIDR_SID                 I2C_SIDR_SID_Msk                          /*Size Identifier*/

/******************************************************************************/
/*                                                                            */
/*                        Independent WATCHDOG (IWDG)                         */
/*                                                                            */
/******************************************************************************/
/*******************  Bit definition for IWDG_KR register  ********************/
#define IWDG_KR_KEY_Pos      (0U)
#define IWDG_KR_KEY_Msk      (0xFFFFU << IWDG_KR_KEY_Pos)                      /*!< 0x0000FFFF */
#define IWDG_KR_KEY          IWDG_KR_KEY_Msk                                   /*!<Key value (write only, read 0000h)  */

/*******************  Bit definition for IWDG_PR register  ********************/
#define IWDG_PR_PR_Pos       (0U)
#define IWDG_PR_PR_Msk       (0xFU << IWDG_PR_PR_Pos)                          /*!< 0x00000007 */
#define IWDG_PR_PR           IWDG_PR_PR_Msk                                    /*!<PR[2:0] (Prescaler divider)         */
#define IWDG_PR_PR_0         (0x1U << IWDG_PR_PR_Pos)                          /*!< 0x00000001 */
#define IWDG_PR_PR_1         (0x2U << IWDG_PR_PR_Pos)                          /*!< 0x00000002 */
#define IWDG_PR_PR_2         (0x4U << IWDG_PR_PR_Pos)                          /*!< 0x00000004 */
#define IWDG_PR_PR_3         (0x8U << IWDG_PR_PR_Pos)                          /*!< 0x00000008 */

/*******************  Bit definition for IWDG_RLR register  *******************/
#define IWDG_RLR_RL_Pos      (0U)
#define IWDG_RLR_RL_Msk      (0xFFFU << IWDG_RLR_RL_Pos)                       /*!< 0x00000FFF */
#define IWDG_RLR_RL          IWDG_RLR_RL_Msk                                   /*!<Watchdog counter reload value        */

/*******************  Bit definition for IWDG_SR register  ********************/
#define IWDG_SR_PVU_Pos      (0U)
#define IWDG_SR_PVU_Msk      (0x1U << IWDG_SR_PVU_Pos)                         /*!< 0x00000001 */
#define IWDG_SR_PVU          IWDG_SR_PVU_Msk                                   /*!< Watchdog prescaler value update */
#define IWDG_SR_RVU_Pos      (1U)
#define IWDG_SR_RVU_Msk      (0x1U << IWDG_SR_RVU_Pos)                         /*!< 0x00000002 */
#define IWDG_SR_RVU          IWDG_SR_RVU_Msk                                   /*!< Watchdog counter reload value update */
#define IWDG_SR_WVU_Pos      (2U)
#define IWDG_SR_WVU_Msk      (0x1U << IWDG_SR_WVU_Pos)                         /*!< 0x00000004 */
#define IWDG_SR_WVU          IWDG_SR_WVU_Msk                                   /*!< Watchdog counter window value update */
#define IWDG_SR_EWU_Pos      (3U)
#define IWDG_SR_EWU_Msk      (0x1U << IWDG_SR_EWU_Pos)                         /*!< 0x00000008 */
#define IWDG_SR_EWU          IWDG_SR_EWU_Msk                                   /*!< Watchdog interrupt comparator value update */
#define IWDG_SR_EWIF_Pos     (14U)
#define IWDG_SR_EWIF_Msk     (0x1U << IWDG_SR_EWIF_Pos)                         /*!< 0x00004000 */
#define IWDG_SR_EWIF         IWDG_SR_EWIF_Msk                                   /*!< Watchdog early interrupt flag */

/*******************  Bit definition for IWDG_KR register  ********************/
#define IWDG_WINR_WIN_Pos    (0U)
#define IWDG_WINR_WIN_Msk    (0xFFFU << IWDG_WINR_WIN_Pos)                     /*!< 0x00000FFF */
#define IWDG_WINR_WIN        IWDG_WINR_WIN_Msk                                 /*!< Watchdog counter window value */

/*******************  Bit definition for IWDG_EWCR register  ********************/
#define IWDG_EWCR_EWIT_Pos   (0U)
#define IWDG_EWCR_EWIT_Msk   (0xFFFU << IWDG_EWCR_EWIT_Pos)                     /*!< 0x00000FFF */
#define IWDG_EWCR_EWIT       IWDG_EWCR_EWIT_Msk                                 /*!< Watchdog early wakeup comparator value */
#define IWDG_EWCR_EWIC_Pos   (14U)
#define IWDG_EWCR_EWIC_Msk   (0x1U << IWDG_EWCR_EWIC_Pos)                       /*!< 0x00004000 */
#define IWDG_EWCR_EWIC       IWDG_EWCR_EWIC_Msk                                 /*!< Watchdog early interrupt acknowledge */
#define IWDG_EWCR_EWIE_Pos   (15U)
#define IWDG_EWCR_EWIE_Msk   (0x1U << IWDG_EWCR_EWIE_Pos)                       /*!< 0x00008000 */
#define IWDG_EWCR_EWIE       IWDG_EWCR_EWIE_Msk                                 /*!< Watchdog early interrupt enable */

/******************************************************************************/
/*                                                                            */
/*                      LCD-TFT Display Controller (LTDC)                     */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for LTDC_SSCR register  *****************/

#define LTDC_SSCR_VSH_Pos            (0U)
#define LTDC_SSCR_VSH_Msk            (0x7FFU << LTDC_SSCR_VSH_Pos)             /*!< 0x000007FF */
#define LTDC_SSCR_VSH                LTDC_SSCR_VSH_Msk                         /*!< Vertical Synchronization Height  */
#define LTDC_SSCR_HSW_Pos            (16U)
#define LTDC_SSCR_HSW_Msk            (0xFFFU << LTDC_SSCR_HSW_Pos)             /*!< 0x0FFF0000 */
#define LTDC_SSCR_HSW                LTDC_SSCR_HSW_Msk                         /*!< Horizontal Synchronization Width */

/********************  Bit definition for LTDC_BPCR register  *****************/

#define LTDC_BPCR_AVBP_Pos           (0U)
#define LTDC_BPCR_AVBP_Msk           (0x7FFU << LTDC_BPCR_AVBP_Pos)            /*!< 0x000007FF */
#define LTDC_BPCR_AVBP               LTDC_BPCR_AVBP_Msk                        /*!< Accumulated Vertical Back Porch   */
#define LTDC_BPCR_AHBP_Pos           (16U)
#define LTDC_BPCR_AHBP_Msk           (0xFFFU << LTDC_BPCR_AHBP_Pos)            /*!< 0x0FFF0000 */
#define LTDC_BPCR_AHBP               LTDC_BPCR_AHBP_Msk                        /*!< Accumulated Horizontal Back Porch */

/********************  Bit definition for LTDC_AWCR register  *****************/

#define LTDC_AWCR_AAH_Pos            (0U)
#define LTDC_AWCR_AAH_Msk            (0x7FFU << LTDC_AWCR_AAH_Pos)             /*!< 0x000007FF */
#define LTDC_AWCR_AAH                LTDC_AWCR_AAH_Msk                         /*!< Accumulated Active heigh */
#define LTDC_AWCR_AAW_Pos            (16U)
#define LTDC_AWCR_AAW_Msk            (0xFFFU << LTDC_AWCR_AAW_Pos)             /*!< 0x0FFF0000 */
#define LTDC_AWCR_AAW                LTDC_AWCR_AAW_Msk                         /*!< Accumulated Active Width */

/********************  Bit definition for LTDC_TWCR register  *****************/

#define LTDC_TWCR_TOTALH_Pos         (0U)
#define LTDC_TWCR_TOTALH_Msk         (0x7FFU << LTDC_TWCR_TOTALH_Pos)          /*!< 0x000007FF */
#define LTDC_TWCR_TOTALH             LTDC_TWCR_TOTALH_Msk                      /*!< Total Heigh */
#define LTDC_TWCR_TOTALW_Pos         (16U)
#define LTDC_TWCR_TOTALW_Msk         (0xFFFU << LTDC_TWCR_TOTALW_Pos)          /*!< 0x0FFF0000 */
#define LTDC_TWCR_TOTALW             LTDC_TWCR_TOTALW_Msk                      /*!< Total Width */

/********************  Bit definition for LTDC_GCR register  ******************/

#define LTDC_GCR_LTDCEN_Pos          (0U)
#define LTDC_GCR_LTDCEN_Msk          (0x1U << LTDC_GCR_LTDCEN_Pos)             /*!< 0x00000001 */
#define LTDC_GCR_LTDCEN              LTDC_GCR_LTDCEN_Msk                       /*!< LCD-TFT controller enable bit       */
#define LTDC_GCR_DBW_Pos             (4U)
#define LTDC_GCR_DBW_Msk             (0x7U << LTDC_GCR_DBW_Pos)                /*!< 0x00000070 */
#define LTDC_GCR_DBW                 LTDC_GCR_DBW_Msk                          /*!< Dither Blue Width                   */
#define LTDC_GCR_DGW_Pos             (8U)
#define LTDC_GCR_DGW_Msk             (0x7U << LTDC_GCR_DGW_Pos)                /*!< 0x00000700 */
#define LTDC_GCR_DGW                 LTDC_GCR_DGW_Msk                          /*!< Dither Green Width                  */
#define LTDC_GCR_DRW_Pos             (12U)
#define LTDC_GCR_DRW_Msk             (0x7U << LTDC_GCR_DRW_Pos)                /*!< 0x00007000 */
#define LTDC_GCR_DRW                 LTDC_GCR_DRW_Msk                          /*!< Dither Red Width                    */
#define LTDC_GCR_DEN_Pos             (16U)
#define LTDC_GCR_DEN_Msk             (0x1U << LTDC_GCR_DEN_Pos)                /*!< 0x00010000 */
#define LTDC_GCR_DEN                 LTDC_GCR_DEN_Msk                          /*!< Dither Enable                       */
#define LTDC_GCR_PCPOL_Pos           (28U)
#define LTDC_GCR_PCPOL_Msk           (0x1U << LTDC_GCR_PCPOL_Pos)              /*!< 0x10000000 */
#define LTDC_GCR_PCPOL               LTDC_GCR_PCPOL_Msk                        /*!< Pixel Clock Polarity                */
#define LTDC_GCR_DEPOL_Pos           (29U)
#define LTDC_GCR_DEPOL_Msk           (0x1U << LTDC_GCR_DEPOL_Pos)              /*!< 0x20000000 */
#define LTDC_GCR_DEPOL               LTDC_GCR_DEPOL_Msk                        /*!< Data Enable Polarity                */
#define LTDC_GCR_VSPOL_Pos           (30U)
#define LTDC_GCR_VSPOL_Msk           (0x1U << LTDC_GCR_VSPOL_Pos)              /*!< 0x40000000 */
#define LTDC_GCR_VSPOL               LTDC_GCR_VSPOL_Msk                        /*!< Vertical Synchronization Polarity   */
#define LTDC_GCR_HSPOL_Pos           (31U)
#define LTDC_GCR_HSPOL_Msk           (0x1U << LTDC_GCR_HSPOL_Pos)              /*!< 0x80000000 */
#define LTDC_GCR_HSPOL               LTDC_GCR_HSPOL_Msk                        /*!< Horizontal Synchronization Polarity */


/********************  Bit definition for LTDC_SRCR register  *****************/

#define LTDC_SRCR_IMR_Pos            (0U)
#define LTDC_SRCR_IMR_Msk            (0x1U << LTDC_SRCR_IMR_Pos)               /*!< 0x00000001 */
#define LTDC_SRCR_IMR                LTDC_SRCR_IMR_Msk                         /*!< Immediate Reload         */
#define LTDC_SRCR_VBR_Pos            (1U)
#define LTDC_SRCR_VBR_Msk            (0x1U << LTDC_SRCR_VBR_Pos)               /*!< 0x00000002 */
#define LTDC_SRCR_VBR                LTDC_SRCR_VBR_Msk                         /*!< Vertical Blanking Reload */

/********************  Bit definition for LTDC_BCCR register  *****************/

#define LTDC_BCCR_BCBLUE_Pos         (0U)
#define LTDC_BCCR_BCBLUE_Msk         (0xFFU << LTDC_BCCR_BCBLUE_Pos)           /*!< 0x000000FF */
#define LTDC_BCCR_BCBLUE             LTDC_BCCR_BCBLUE_Msk                      /*!< Background Blue value  */
#define LTDC_BCCR_BCGREEN_Pos        (8U)
#define LTDC_BCCR_BCGREEN_Msk        (0xFFU << LTDC_BCCR_BCGREEN_Pos)          /*!< 0x0000FF00 */
#define LTDC_BCCR_BCGREEN            LTDC_BCCR_BCGREEN_Msk                     /*!< Background Green value */
#define LTDC_BCCR_BCRED_Pos          (16U)
#define LTDC_BCCR_BCRED_Msk          (0xFFU << LTDC_BCCR_BCRED_Pos)            /*!< 0x00FF0000 */
#define LTDC_BCCR_BCRED              LTDC_BCCR_BCRED_Msk                       /*!< Background Red value   */

/********************  Bit definition for LTDC_IER register  ******************/

#define LTDC_IER_LIE_Pos             (0U)
#define LTDC_IER_LIE_Msk             (0x1U << LTDC_IER_LIE_Pos)                /*!< 0x00000001 */
#define LTDC_IER_LIE                 LTDC_IER_LIE_Msk                          /*!< Line Interrupt Enable            */
#define LTDC_IER_FUIE_Pos            (1U)
#define LTDC_IER_FUIE_Msk            (0x1U << LTDC_IER_FUIE_Pos)               /*!< 0x00000002 */
#define LTDC_IER_FUIE                LTDC_IER_FUIE_Msk                         /*!< FIFO Underrun Interrupt Enable   */
#define LTDC_IER_TERRIE_Pos          (2U)
#define LTDC_IER_TERRIE_Msk          (0x1U << LTDC_IER_TERRIE_Pos)             /*!< 0x00000004 */
#define LTDC_IER_TERRIE              LTDC_IER_TERRIE_Msk                       /*!< Transfer Error Interrupt Enable  */
#define LTDC_IER_RRIE_Pos            (3U)
#define LTDC_IER_RRIE_Msk            (0x1U << LTDC_IER_RRIE_Pos)               /*!< 0x00000008 */
#define LTDC_IER_RRIE                LTDC_IER_RRIE_Msk                         /*!< Register Reload interrupt enable */

/********************  Bit definition for LTDC_ISR register  ******************/

#define LTDC_ISR_LIF_Pos             (0U)
#define LTDC_ISR_LIF_Msk             (0x1U << LTDC_ISR_LIF_Pos)                /*!< 0x00000001 */
#define LTDC_ISR_LIF                 LTDC_ISR_LIF_Msk                          /*!< Line Interrupt Flag */
#define LTDC_ISR_FUIF_Pos            (1U)
#define LTDC_ISR_FUIF_Msk            (0x1U << LTDC_ISR_FUIF_Pos)               /*!< 0x00000002 */
#define LTDC_ISR_FUIF                LTDC_ISR_FUIF_Msk                         /*!< FIFO Underrun Interrupt Flag */
#define LTDC_ISR_TERRIF_Pos          (2U)
#define LTDC_ISR_TERRIF_Msk          (0x1U << LTDC_ISR_TERRIF_Pos)             /*!< 0x00000004 */
#define LTDC_ISR_TERRIF              LTDC_ISR_TERRIF_Msk                       /*!< Transfer Error Interrupt Flag */
#define LTDC_ISR_RRIF_Pos            (3U)
#define LTDC_ISR_RRIF_Msk            (0x1U << LTDC_ISR_RRIF_Pos)               /*!< 0x00000008 */
#define LTDC_ISR_RRIF                LTDC_ISR_RRIF_Msk                         /*!< Register Reload interrupt Flag */

/********************  Bit definition for LTDC_ICR register  ******************/

#define LTDC_ICR_CLIF_Pos            (0U)
#define LTDC_ICR_CLIF_Msk            (0x1U << LTDC_ICR_CLIF_Pos)               /*!< 0x00000001 */
#define LTDC_ICR_CLIF                LTDC_ICR_CLIF_Msk                         /*!< Clears the Line Interrupt Flag */
#define LTDC_ICR_CFUIF_Pos           (1U)
#define LTDC_ICR_CFUIF_Msk           (0x1U << LTDC_ICR_CFUIF_Pos)              /*!< 0x00000002 */
#define LTDC_ICR_CFUIF               LTDC_ICR_CFUIF_Msk                        /*!< Clears the FIFO Underrun Interrupt Flag */
#define LTDC_ICR_CTERRIF_Pos         (2U)
#define LTDC_ICR_CTERRIF_Msk         (0x1U << LTDC_ICR_CTERRIF_Pos)            /*!< 0x00000004 */
#define LTDC_ICR_CTERRIF             LTDC_ICR_CTERRIF_Msk                      /*!< Clears the Transfer Error Interrupt Flag */
#define LTDC_ICR_CRRIF_Pos           (3U)
#define LTDC_ICR_CRRIF_Msk           (0x1U << LTDC_ICR_CRRIF_Pos)              /*!< 0x00000008 */
#define LTDC_ICR_CRRIF               LTDC_ICR_CRRIF_Msk                        /*!< Clears Register Reload interrupt Flag */

/********************  Bit definition for LTDC_LIPCR register  ****************/

#define LTDC_LIPCR_LIPOS_Pos         (0U)
#define LTDC_LIPCR_LIPOS_Msk         (0x7FFU << LTDC_LIPCR_LIPOS_Pos)          /*!< 0x000007FF */
#define LTDC_LIPCR_LIPOS             LTDC_LIPCR_LIPOS_Msk                      /*!< Line Interrupt Position */

/********************  Bit definition for LTDC_CPSR register  *****************/

#define LTDC_CPSR_CYPOS_Pos          (0U)
#define LTDC_CPSR_CYPOS_Msk          (0xFFFFU << LTDC_CPSR_CYPOS_Pos)          /*!< 0x0000FFFF */
#define LTDC_CPSR_CYPOS              LTDC_CPSR_CYPOS_Msk                       /*!< Current Y Position */
#define LTDC_CPSR_CXPOS_Pos          (16U)
#define LTDC_CPSR_CXPOS_Msk          (0xFFFFU << LTDC_CPSR_CXPOS_Pos)          /*!< 0xFFFF0000 */
#define LTDC_CPSR_CXPOS              LTDC_CPSR_CXPOS_Msk                       /*!< Current X Position */

/********************  Bit definition for LTDC_CDSR register  *****************/

#define LTDC_CDSR_VDES_Pos           (0U)
#define LTDC_CDSR_VDES_Msk           (0x1U << LTDC_CDSR_VDES_Pos)              /*!< 0x00000001 */
#define LTDC_CDSR_VDES               LTDC_CDSR_VDES_Msk                        /*!< Vertical Data Enable Status       */
#define LTDC_CDSR_HDES_Pos           (1U)
#define LTDC_CDSR_HDES_Msk           (0x1U << LTDC_CDSR_HDES_Pos)              /*!< 0x00000002 */
#define LTDC_CDSR_HDES               LTDC_CDSR_HDES_Msk                        /*!< Horizontal Data Enable Status     */
#define LTDC_CDSR_VSYNCS_Pos         (2U)
#define LTDC_CDSR_VSYNCS_Msk         (0x1U << LTDC_CDSR_VSYNCS_Pos)            /*!< 0x00000004 */
#define LTDC_CDSR_VSYNCS             LTDC_CDSR_VSYNCS_Msk                      /*!< Vertical Synchronization Status   */
#define LTDC_CDSR_HSYNCS_Pos         (3U)
#define LTDC_CDSR_HSYNCS_Msk         (0x1U << LTDC_CDSR_HSYNCS_Pos)            /*!< 0x00000008 */
#define LTDC_CDSR_HSYNCS             LTDC_CDSR_HSYNCS_Msk                      /*!< Horizontal Synchronization Status */

/********************  Bit definition for LTDC_LxCR register  *****************/

#define LTDC_LxCR_LEN_Pos            (0U)
#define LTDC_LxCR_LEN_Msk            (0x1U << LTDC_LxCR_LEN_Pos)               /*!< 0x00000001 */
#define LTDC_LxCR_LEN                LTDC_LxCR_LEN_Msk                         /*!< Layer Enable              */
#define LTDC_LxCR_COLKEN_Pos         (1U)
#define LTDC_LxCR_COLKEN_Msk         (0x1U << LTDC_LxCR_COLKEN_Pos)            /*!< 0x00000002 */
#define LTDC_LxCR_COLKEN             LTDC_LxCR_COLKEN_Msk                      /*!< Color Keying Enable       */
#define LTDC_LxCR_CLUTEN_Pos         (4U)
#define LTDC_LxCR_CLUTEN_Msk         (0x1U << LTDC_LxCR_CLUTEN_Pos)            /*!< 0x00000010 */
#define LTDC_LxCR_CLUTEN             LTDC_LxCR_CLUTEN_Msk                      /*!< Color Lockup Table Enable */

/********************  Bit definition for LTDC_LxWHPCR register  **************/

#define LTDC_LxWHPCR_WHSTPOS_Pos     (0U)
#define LTDC_LxWHPCR_WHSTPOS_Msk     (0xFFFU << LTDC_LxWHPCR_WHSTPOS_Pos)      /*!< 0x00000FFF */
#define LTDC_LxWHPCR_WHSTPOS         LTDC_LxWHPCR_WHSTPOS_Msk                  /*!< Window Horizontal Start Position */
#define LTDC_LxWHPCR_WHSPPOS_Pos     (16U)
#define LTDC_LxWHPCR_WHSPPOS_Msk     (0xFFFFU << LTDC_LxWHPCR_WHSPPOS_Pos)     /*!< 0xFFFF0000 */
#define LTDC_LxWHPCR_WHSPPOS         LTDC_LxWHPCR_WHSPPOS_Msk                  /*!< Window Horizontal Stop Position  */

/********************  Bit definition for LTDC_LxWVPCR register  **************/

#define LTDC_LxWVPCR_WVSTPOS_Pos     (0U)
#define LTDC_LxWVPCR_WVSTPOS_Msk     (0xFFFU << LTDC_LxWVPCR_WVSTPOS_Pos)      /*!< 0x00000FFF */
#define LTDC_LxWVPCR_WVSTPOS         LTDC_LxWVPCR_WVSTPOS_Msk                  /*!< Window Vertical Start Position */
#define LTDC_LxWVPCR_WVSPPOS_Pos     (16U)
#define LTDC_LxWVPCR_WVSPPOS_Msk     (0xFFFFU << LTDC_LxWVPCR_WVSPPOS_Pos)     /*!< 0xFFFF0000 */
#define LTDC_LxWVPCR_WVSPPOS         LTDC_LxWVPCR_WVSPPOS_Msk                  /*!< Window Vertical Stop Position  */

/********************  Bit definition for LTDC_LxCKCR register  ***************/

#define LTDC_LxCKCR_CKBLUE_Pos       (0U)
#define LTDC_LxCKCR_CKBLUE_Msk       (0xFFU << LTDC_LxCKCR_CKBLUE_Pos)         /*!< 0x000000FF */
#define LTDC_LxCKCR_CKBLUE           LTDC_LxCKCR_CKBLUE_Msk                    /*!< Color Key Blue value  */
#define LTDC_LxCKCR_CKGREEN_Pos      (8U)
#define LTDC_LxCKCR_CKGREEN_Msk      (0xFFU << LTDC_LxCKCR_CKGREEN_Pos)        /*!< 0x0000FF00 */
#define LTDC_LxCKCR_CKGREEN          LTDC_LxCKCR_CKGREEN_Msk                   /*!< Color Key Green value */
#define LTDC_LxCKCR_CKRED_Pos        (16U)
#define LTDC_LxCKCR_CKRED_Msk        (0xFFU << LTDC_LxCKCR_CKRED_Pos)          /*!< 0x00FF0000 */
#define LTDC_LxCKCR_CKRED            LTDC_LxCKCR_CKRED_Msk                     /*!< Color Key Red value   */

/********************  Bit definition for LTDC_LxPFCR register  ***************/

#define LTDC_LxPFCR_PF_Pos           (0U)
#define LTDC_LxPFCR_PF_Msk           (0x7U << LTDC_LxPFCR_PF_Pos)              /*!< 0x00000007 */
#define LTDC_LxPFCR_PF               LTDC_LxPFCR_PF_Msk                        /*!< Pixel Format */

/********************  Bit definition for LTDC_LxCACR register  ***************/

#define LTDC_LxCACR_CONSTA_Pos       (0U)
#define LTDC_LxCACR_CONSTA_Msk       (0xFFU << LTDC_LxCACR_CONSTA_Pos)         /*!< 0x000000FF */
#define LTDC_LxCACR_CONSTA           LTDC_LxCACR_CONSTA_Msk                    /*!< Constant Alpha */

/********************  Bit definition for LTDC_LxDCCR register  ***************/

#define LTDC_LxDCCR_DCBLUE_Pos       (0U)
#define LTDC_LxDCCR_DCBLUE_Msk       (0xFFU << LTDC_LxDCCR_DCBLUE_Pos)         /*!< 0x000000FF */
#define LTDC_LxDCCR_DCBLUE           LTDC_LxDCCR_DCBLUE_Msk                    /*!< Default Color Blue  */
#define LTDC_LxDCCR_DCGREEN_Pos      (8U)
#define LTDC_LxDCCR_DCGREEN_Msk      (0xFFU << LTDC_LxDCCR_DCGREEN_Pos)        /*!< 0x0000FF00 */
#define LTDC_LxDCCR_DCGREEN          LTDC_LxDCCR_DCGREEN_Msk                   /*!< Default Color Green */
#define LTDC_LxDCCR_DCRED_Pos        (16U)
#define LTDC_LxDCCR_DCRED_Msk        (0xFFU << LTDC_LxDCCR_DCRED_Pos)          /*!< 0x00FF0000 */
#define LTDC_LxDCCR_DCRED            LTDC_LxDCCR_DCRED_Msk                     /*!< Default Color Red   */
#define LTDC_LxDCCR_DCALPHA_Pos      (24U)
#define LTDC_LxDCCR_DCALPHA_Msk      (0xFFU << LTDC_LxDCCR_DCALPHA_Pos)        /*!< 0xFF000000 */
#define LTDC_LxDCCR_DCALPHA          LTDC_LxDCCR_DCALPHA_Msk                   /*!< Default Color Alpha */

/********************  Bit definition for LTDC_LxBFCR register  ***************/

#define LTDC_LxBFCR_BF2_Pos          (0U)
#define LTDC_LxBFCR_BF2_Msk          (0x7U << LTDC_LxBFCR_BF2_Pos)             /*!< 0x00000007 */
#define LTDC_LxBFCR_BF2              LTDC_LxBFCR_BF2_Msk                       /*!< Blending Factor 2 */
#define LTDC_LxBFCR_BF1_Pos          (8U)
#define LTDC_LxBFCR_BF1_Msk          (0x7U << LTDC_LxBFCR_BF1_Pos)             /*!< 0x00000700 */
#define LTDC_LxBFCR_BF1              LTDC_LxBFCR_BF1_Msk                       /*!< Blending Factor 1 */

/********************  Bit definition for LTDC_LxCFBAR register  **************/

#define LTDC_LxCFBAR_CFBADD_Pos      (0U)
#define LTDC_LxCFBAR_CFBADD_Msk      (0xFFFFFFFFU << LTDC_LxCFBAR_CFBADD_Pos)  /*!< 0xFFFFFFFF */
#define LTDC_LxCFBAR_CFBADD          LTDC_LxCFBAR_CFBADD_Msk                   /*!< Color Frame Buffer Start Address */

/********************  Bit definition for LTDC_LxCFBLR register  **************/

#define LTDC_LxCFBLR_CFBLL_Pos       (0U)
#define LTDC_LxCFBLR_CFBLL_Msk       (0x1FFFU << LTDC_LxCFBLR_CFBLL_Pos)       /*!< 0x00001FFF */
#define LTDC_LxCFBLR_CFBLL           LTDC_LxCFBLR_CFBLL_Msk                    /*!< Color Frame Buffer Line Length    */
#define LTDC_LxCFBLR_CFBP_Pos        (16U)
#define LTDC_LxCFBLR_CFBP_Msk        (0x1FFFU << LTDC_LxCFBLR_CFBP_Pos)        /*!< 0x1FFF0000 */
#define LTDC_LxCFBLR_CFBP            LTDC_LxCFBLR_CFBP_Msk                     /*!< Color Frame Buffer Pitch in bytes */

/********************  Bit definition for LTDC_LxCFBLNR register  *************/

#define LTDC_LxCFBLNR_CFBLNBR_Pos    (0U)
#define LTDC_LxCFBLNR_CFBLNBR_Msk    (0x7FFU << LTDC_LxCFBLNR_CFBLNBR_Pos)     /*!< 0x000007FF */
#define LTDC_LxCFBLNR_CFBLNBR        LTDC_LxCFBLNR_CFBLNBR_Msk                 /*!< Frame Buffer Line Number */

/********************  Bit definition for LTDC_LxCLUTWR register  *************/

#define LTDC_LxCLUTWR_BLUE_Pos       (0U)
#define LTDC_LxCLUTWR_BLUE_Msk       (0xFFU << LTDC_LxCLUTWR_BLUE_Pos)         /*!< 0x000000FF */
#define LTDC_LxCLUTWR_BLUE           LTDC_LxCLUTWR_BLUE_Msk                    /*!< Blue value   */
#define LTDC_LxCLUTWR_GREEN_Pos      (8U)
#define LTDC_LxCLUTWR_GREEN_Msk      (0xFFU << LTDC_LxCLUTWR_GREEN_Pos)        /*!< 0x0000FF00 */
#define LTDC_LxCLUTWR_GREEN          LTDC_LxCLUTWR_GREEN_Msk                   /*!< Green value  */
#define LTDC_LxCLUTWR_RED_Pos        (16U)
#define LTDC_LxCLUTWR_RED_Msk        (0xFFU << LTDC_LxCLUTWR_RED_Pos)          /*!< 0x00FF0000 */
#define LTDC_LxCLUTWR_RED            LTDC_LxCLUTWR_RED_Msk                     /*!< Red value    */
#define LTDC_LxCLUTWR_CLUTADD_Pos    (24U)
#define LTDC_LxCLUTWR_CLUTADD_Msk    (0xFFU << LTDC_LxCLUTWR_CLUTADD_Pos)      /*!< 0xFF000000 */
#define LTDC_LxCLUTWR_CLUTADD        LTDC_LxCLUTWR_CLUTADD_Msk                 /*!< CLUT address */

/******************************************************************************/
/*                                                                            */
/*         Inter-Processor Communication Controller (IPCC)                    */
/*                                                                            */
/******************************************************************************/

/**********************  Bit definition for IPCC_C1CR register  ***************/
#define IPCC_C1CR_RXOIE_Pos      (0U)
#define IPCC_C1CR_RXOIE_Msk      (0x1U << IPCC_C1CR_RXOIE_Pos)                 /*!< 0x00000001 */
#define IPCC_C1CR_RXOIE          IPCC_C1CR_RXOIE_Msk                           /*!< Processor M4 Receive channel occupied interrupt enable */
#define IPCC_C1CR_TXFIE_Pos      (16U)
#define IPCC_C1CR_TXFIE_Msk      (0x1U << IPCC_C1CR_TXFIE_Pos)                 /*!< 0x00010000 */
#define IPCC_C1CR_TXFIE          IPCC_C1CR_TXFIE_Msk                           /*!< Processor M4 Transmit channel free interrupt enable */

/**********************  Bit definition for IPCC_C1MR register  **************/
#define IPCC_C1MR_CH1OM_Pos      (0U)
#define IPCC_C1MR_CH1OM_Msk      (0x1U << IPCC_C1MR_CH1OM_Pos)                 /*!< 0x00000001 */
#define IPCC_C1MR_CH1OM          IPCC_C1MR_CH1OM_Msk                           /*!< M4 Channel1 occupied interrupt mask */
#define IPCC_C1MR_CH2OM_Pos      (1U)
#define IPCC_C1MR_CH2OM_Msk      (0x1U << IPCC_C1MR_CH2OM_Pos)                 /*!< 0x00000002 */
#define IPCC_C1MR_CH2OM          IPCC_C1MR_CH2OM_Msk                           /*!< M4 Channel2 occupied interrupt mask */
#define IPCC_C1MR_CH3OM_Pos      (2U)
#define IPCC_C1MR_CH3OM_Msk      (0x1U << IPCC_C1MR_CH3OM_Pos)                 /*!< 0x00000004 */
#define IPCC_C1MR_CH3OM          IPCC_C1MR_CH3OM_Msk                           /*!< M4 Channel3 occupied interrupt mask */
#define IPCC_C1MR_CH4OM_Pos      (3U)
#define IPCC_C1MR_CH4OM_Msk      (0x1U << IPCC_C1MR_CH4OM_Pos)                 /*!< 0x00000008 */
#define IPCC_C1MR_CH4OM          IPCC_C1MR_CH4OM_Msk                           /*!< M4 Channel4 occupied interrupt mask */
#define IPCC_C1MR_CH5OM_Pos      (4U)
#define IPCC_C1MR_CH5OM_Msk      (0x1U << IPCC_C1MR_CH5OM_Pos)                 /*!< 0x00000010 */
#define IPCC_C1MR_CH5OM          IPCC_C1MR_CH5OM_Msk                           /*!< M4 Channel5 occupied interrupt mask */
#define IPCC_C1MR_CH6OM_Pos      (5U)
#define IPCC_C1MR_CH6OM_Msk      (0x1U << IPCC_C1MR_CH6OM_Pos)                 /*!< 0x00000020 */
#define IPCC_C1MR_CH6OM          IPCC_C1MR_CH6OM_Msk                           /*!< M4 Channel6 occupied interrupt mask */

#define IPCC_C1MR_CH1FM_Pos      (16U)
#define IPCC_C1MR_CH1FM_Msk      (0x1U << IPCC_C1MR_CH1FM_Pos)                 /*!< 0x00010000 */
#define IPCC_C1MR_CH1FM          IPCC_C1MR_CH1FM_Msk                           /*!< M4 Transmit Channel1 free interrupt mask */
#define IPCC_C1MR_CH2FM_Pos      (17U)
#define IPCC_C1MR_CH2FM_Msk      (0x1U << IPCC_C1MR_CH2FM_Pos)                 /*!< 0x00020000 */
#define IPCC_C1MR_CH2FM          IPCC_C1MR_CH2FM_Msk                           /*!< M4 Transmit Channel2 free interrupt mask */
#define IPCC_C1MR_CH3FM_Pos      (18U)
#define IPCC_C1MR_CH3FM_Msk      (0x1U << IPCC_C1MR_CH3FM_Pos)                 /*!< 0x00040000 */
#define IPCC_C1MR_CH3FM          IPCC_C1MR_CH3FM_Msk                           /*!< M4 Transmit Channel3 free interrupt mask */
#define IPCC_C1MR_CH4FM_Pos      (19U)
#define IPCC_C1MR_CH4FM_Msk      (0x1U << IPCC_C1MR_CH4FM_Pos)                 /*!< 0x00080000 */
#define IPCC_C1MR_CH4FM          IPCC_C1MR_CH4FM_Msk                           /*!< M4 Transmit Channel4 free interrupt mask */
#define IPCC_C1MR_CH5FM_Pos      (20U)
#define IPCC_C1MR_CH5FM_Msk      (0x1U << IPCC_C1MR_CH5FM_Pos)                 /*!< 0x00100000 */
#define IPCC_C1MR_CH5FM          IPCC_C1MR_CH5FM_Msk                           /*!< M4 Transmit Channel5 free interrupt mask */
#define IPCC_C1MR_CH6FM_Pos      (21U)
#define IPCC_C1MR_CH6FM_Msk      (0x1U << IPCC_C1MR_CH6FM_Pos)                 /*!< 0x00200000 */
#define IPCC_C1MR_CH6FM          IPCC_C1MR_CH6FM_Msk                           /*!< M4 Transmit Channel6 free interrupt mask */

/**********************  Bit definition for IPCC_C1SCR register  ***************/
#define IPCC_C1SCR_CH1C_Pos      (0U)
#define IPCC_C1SCR_CH1C_Msk      (0x1U << IPCC_C1SCR_CH1C_Pos)                 /*!< 0x00000001 */
#define IPCC_C1SCR_CH1C          IPCC_C1SCR_CH1C_Msk                           /*!< M4 receive Channel1 status clear */
#define IPCC_C1SCR_CH2C_Pos      (1U)
#define IPCC_C1SCR_CH2C_Msk      (0x1U << IPCC_C1SCR_CH2C_Pos)                 /*!< 0x00000002 */
#define IPCC_C1SCR_CH2C          IPCC_C1SCR_CH2C_Msk                           /*!< M4 receive Channel2 status clear */
#define IPCC_C1SCR_CH3C_Pos      (2U)
#define IPCC_C1SCR_CH3C_Msk      (0x1U << IPCC_C1SCR_CH3C_Pos)                 /*!< 0x00000004 */
#define IPCC_C1SCR_CH3C          IPCC_C1SCR_CH3C_Msk                           /*!< M4 receive Channel3 status clear */
#define IPCC_C1SCR_CH4C_Pos      (3U)
#define IPCC_C1SCR_CH4C_Msk      (0x1U << IPCC_C1SCR_CH4C_Pos)                 /*!< 0x00000008 */
#define IPCC_C1SCR_CH4C          IPCC_C1SCR_CH4C_Msk                           /*!< M4 receive Channel4 status clear */
#define IPCC_C1SCR_CH5C_Pos      (4U)
#define IPCC_C1SCR_CH5C_Msk      (0x1U << IPCC_C1SCR_CH5C_Pos)                 /*!< 0x00000010 */
#define IPCC_C1SCR_CH5C          IPCC_C1SCR_CH5C_Msk                           /*!< M4 receive Channel5 status clear */
#define IPCC_C1SCR_CH6C_Pos      (5U)
#define IPCC_C1SCR_CH6C_Msk      (0x1U << IPCC_C1SCR_CH6C_Pos)                 /*!< 0x00000020 */
#define IPCC_C1SCR_CH6C          IPCC_C1SCR_CH6C_Msk                           /*!< M4 receive Channel6 status clear */

#define IPCC_C1SCR_CH1S_Pos      (16U)
#define IPCC_C1SCR_CH1S_Msk      (0x1U << IPCC_C1SCR_CH1S_Pos)                 /*!< 0x00010000 */
#define IPCC_C1SCR_CH1S          IPCC_C1SCR_CH1S_Msk                           /*!< M4 transmit Channel1 status set */
#define IPCC_C1SCR_CH2S_Pos      (17U)
#define IPCC_C1SCR_CH2S_Msk      (0x1U << IPCC_C1SCR_CH2S_Pos)                 /*!< 0x00020000 */
#define IPCC_C1SCR_CH2S          IPCC_C1SCR_CH2S_Msk                           /*!< M4 transmit Channel2 status set  */
#define IPCC_C1SCR_CH3S_Pos      (18U)
#define IPCC_C1SCR_CH3S_Msk      (0x1U << IPCC_C1SCR_CH3S_Pos)                 /*!< 0x00040000 */
#define IPCC_C1SCR_CH3S          IPCC_C1SCR_CH3S_Msk                           /*!< M4 transmit Channel3 status set  */
#define IPCC_C1SCR_CH4S_Pos      (19U)
#define IPCC_C1SCR_CH4S_Msk      (0x1U << IPCC_C1SCR_CH4S_Pos)                 /*!< 0x00080000 */
#define IPCC_C1SCR_CH4S          IPCC_C1SCR_CH4S_Msk                           /*!< M4 transmit Channel4 status set  */
#define IPCC_C1SCR_CH5S_Pos      (20U)
#define IPCC_C1SCR_CH5S_Msk      (0x1U << IPCC_C1SCR_CH5S_Pos)                 /*!< 0x00100000 */
#define IPCC_C1SCR_CH5S          IPCC_C1SCR_CH5S_Msk                           /*!< M4 transmit Channel5 status set  */
#define IPCC_C1SCR_CH6S_Pos      (21U)
#define IPCC_C1SCR_CH6S_Msk      (0x1U << IPCC_C1SCR_CH6S_Pos)                 /*!< 0x00200000 */
#define IPCC_C1SCR_CH6S          IPCC_C1SCR_CH6S_Msk                           /*!< M4 transmit Channel6 status set  */

/**********************  Bit definition for IPCC_C1TOC2SR register  ***************/
#define IPCC_C1TOC2SR_CH1F_Pos    (0U)
#define IPCC_C1TOC2SR_CH1F_Msk    (0x1U << IPCC_C1TOC2SR_CH1F_Pos)             /*!< 0x00000001 */
#define IPCC_C1TOC2SR_CH1F        IPCC_C1TOC2SR_CH1F_Msk                       /*!< M4 transmit to M4 receive Channel1 status flag before masking */
#define IPCC_C1TOC2SR_CH2F_Pos    (1U)
#define IPCC_C1TOC2SR_CH2F_Msk    (0x1U << IPCC_C1TOC2SR_CH2F_Pos)             /*!< 0x00000002 */
#define IPCC_C1TOC2SR_CH2F        IPCC_C1TOC2SR_CH2F_Msk                       /*!< M4 transmit to M4 receive Channel2 status flag before masking */
#define IPCC_C1TOC2SR_CH3F_Pos    (2U)
#define IPCC_C1TOC2SR_CH3F_Msk    (0x1U << IPCC_C1TOC2SR_CH3F_Pos)             /*!< 0x00000004 */
#define IPCC_C1TOC2SR_CH3F        IPCC_C1TOC2SR_CH3F_Msk                       /*!< M4 transmit to M4 receive Channel3 status flag before masking */
#define IPCC_C1TOC2SR_CH4F_Pos    (3U)
#define IPCC_C1TOC2SR_CH4F_Msk    (0x1U << IPCC_C1TOC2SR_CH4F_Pos)             /*!< 0x00000008 */
#define IPCC_C1TOC2SR_CH4F        IPCC_C1TOC2SR_CH4F_Msk                       /*!< M4 transmit to M4 receive Channel4 status flag before masking */
#define IPCC_C1TOC2SR_CH5F_Pos    (4U)
#define IPCC_C1TOC2SR_CH5F_Msk    (0x1U << IPCC_C1TOC2SR_CH5F_Pos)             /*!< 0x00000010 */
#define IPCC_C1TOC2SR_CH5F        IPCC_C1TOC2SR_CH5F_Msk                       /*!< M4 transmit to M4 receive Channel5 status flag before masking */
#define IPCC_C1TOC2SR_CH6F_Pos    (5U)
#define IPCC_C1TOC2SR_CH6F_Msk    (0x1U << IPCC_C1TOC2SR_CH6F_Pos)             /*!< 0x00000020 */
#define IPCC_C1TOC2SR_CH6F        IPCC_C1TOC2SR_CH6F_Msk                       /*!< M4 transmit to M4 receive Channel6 status flag before masking */

/**********************  Bit definition for IPCC_C2CR register  ***************/
#define IPCC_C2CR_RXOIE_Pos      (0U)
#define IPCC_C2CR_RXOIE_Msk      (0x1U << IPCC_C2CR_RXOIE_Pos)                 /*!< 0x00000001 */
#define IPCC_C2CR_RXOIE          IPCC_C2C