/***********************************************************************
*                    SEGGER Microcontroller GmbH                       *
*                        The Embedded Experts                          *
************************************************************************
*                                                                      *
*                  (c) SEGGER Microcontroller GmbH                     *
*                        All rights reserved                           *
*                          www.segger.com                              *
*                                                                      *
************************************************************************
*                                                                      *
************************************************************************
*                                                                      *
*                                                                      *
*  Licensing terms                                                     *
*                                                                      *
* Redistribution and use in source and binary forms, with or without   *
* modification, are permitted provided that the following conditions   *
* are met:                                                             *
*                                                                      *
* 1. Redistributions of source code must retain the above copyright    *
* notice, this list of conditions and the following disclaimer.        *
*                                                                      *
* 2. Redistributions in binary form must reproduce the above           *
* copyright notice, this list of conditions and the following          *
* disclaimer in the documentation and/or other materials provided      *
* with the distribution.                                               *
*                                                                      *
*                                                                      *
* THIS SOFTWARE IS PROVIDED BY COPYRIGHT HOLDER "AS IS" AND ANY        *
* EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE    *
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR   *
* PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL COPYRIGHT HOLDER BE        *
* LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,     *
* OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,             *
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR   *
* PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY  *
* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT         *
* (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    *
* USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH.    *
* DAMAGE.                                                              *
*                                                                      *
***********************************************************************/

#ifndef __FLASH_CONFIG__
#define __FLASH_CONFIG__

#include <stdint.h>
#include <stdbool.h>

extern uint32_t _vectors[];

#define IMAGE_ENTRY_ADDRESS ((uint32_t)_vectors)
#define IVT_RSVD             (uint32_t)(0x00000000)


#define BOOT_CFG_CM7_0_ENABLE     (1uL << 0)
#define BOOT_CFG_CM7_0_DISABLE    (0uL << 0)
#define BOOT_CFG_CM7_1_ENABLE     (1uL << 1)
#define BOOT_CFG_CM7_1_DISABLE    (0uL << 1)
#define BOOT_SEQ_NON_SECURE_BOOT  (0uL << 3)
#define BOOT_SEQ_SECURE_BOOT      (1uL << 3)

#define BOOT_CONFIG_WORD (BOOT_CFG_CM7_0_ENABLE | BOOT_CFG_CM7_1_DISABLE | BOOT_SEQ_NON_SECURE_BOOT)

#define IVT_MARKER 0x5AA55AA5
#define CM7_0_APP_START_ADDR IMAGE_ENTRY_ADDRESS
#define CM7_1_APP_START_ADDR 0                     // This is a single core sample
#define XRCDC_CONFIG_ADDR 0                        // This sample does not use XRDC configuration data
#define LC_CONFIG_ADDR 0                           // This sample does not use LC configuration data

typedef struct {
  const uint32_t  Header;                   /* Header of boot header structure */
  const uint32_t  BootConfig;               /* Boot Configuration Word */
  const uint32_t  Reserved3;                /* Reserved */
  const uint32_t  CM7_0_StartAddress;       /* Start address of application on CM7_0 core */
  const uint32_t  Reserved4;                /* Reserved */
  const uint32_t  CM7_1_StartAddress;       /* Start address of application on CM7_1 core */
  const uint32_t  Reserved5;                /* Reserved */
  const uint32_t  CM7_2_StartAddress;       /* Start address of application on CM7_2 core */
  const uint32_t  XRDCConfig_StartAddress;  /* Address of XRDC configuration data */
  const uint32_t  LCConfig;                 /* Address of LC configuration */
  const uint32_t  Reserved1;                /* Reserved */
  const uint32_t  HseFwHeader_StartAddress; /* Start address of HSE-FW image */
  const uint8_t   Reserved[192];            /* Reserved for future use */
  const uint8_t   CMAC[16];                 /* CMAC */
} boot_header;

#ifdef __cplusplus
}
#endif
#endif /* __FLASH_CONFIG__ */
